#ifndef(CSGPlane_Included)
#	declare CSGPlane_Included=true;

#ifdef(View_POV_Include_Stack)
#   debug "including CSGPlane.inc\n"
#end

#declare upperwing=box{
	#local wspan=3;
	#local wingheight_u=1;
	<-wspan,-0.05,-0.5>
	<wspan,0.05,0.5>	
	translate wingheight_u*y
	pigment{White}
}

#declare lowerwing=box{
	#local wspan=3;
	#local wingheight_l=0;
	<-wspan,-0.05,-0.5>
	<wspan,0.05,0.5>		
	translate wingheight_l*y
	pigment{White}
}

#declare body=union{
	#local blength=2.2;
	#local frontradius=0.6;
	cone{	
		<0,0,-blength>, frontradius
		<0,0,blength>, 0.15		
		pigment{Red}
	}
	cylinder{
		<0,0,0.3>
		<0,0,-0.3>
		frontradius
		translate (-blength+0.1)*z		
		pigment{Gray20}
	}
	translate z*1			
}

#declare fin=cylinder{
	<-0.05,0,0>
	<0.05,0,0>
	0.5
	translate <0,0.45,blength+0.7>
	pigment{White}
}

#declare stay=box{
	<-0.05,wingheight_l,-0.05>
	<0.05,wingheight_u,0.05>
	pigment{White}
}

#declare pilot=sphere{
	<0,0.5,1>, 0.2
	pigment{White}
}

#declare BiPlane=union{
	object{body}
	object{upperwing}
	object{lowerwing}
	object{stay	translate x*-(wspan-0.3)} // left outer
	object{stay	translate x*(wspan-0.3)} // right outer
	object{stay	translate x*-(wspan-1.5)} // left inner
	object{stay	translate x*(wspan-1.5)} // right inner
	object{lowerwing scale <0.4,0.5,1> translate z*(blength+0.5)}	// stabilizer
	object{fin}
	object{pilot}	
}

//***************************************************

#end // #ifndef(CSGPlane_Included)
