
//*************************************************************************************
// SmokeGen v1.2 example file.
// Example demonstrating the usage of centrifugal force simulation and multiple sources
//
// Render with the following INI settings: (or use Multi.ini)
// Initial_Clock=0	(+KI0.0)
// Final_Clock=2	   (+KF2)
// Initial_Frame=1	(+KFI1)
// Final_Frame=120 	(+KFF120)
//
//*************************************************************************************

#include "colors.inc"
#include "textures.inc"
#include "stones1.inc"

camera
{
  location  <3.0, 7, -8.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 5,  0.0>
}

light_source
{
  0*x 
  color red 1.0  green 1.0  blue 1.0  
  translate <20, 30, -30>
}

//*************************************************************************************
// The box. (check roundbox.inc for info on how the box is declared)

#declare RB_P1 = <1.2, 1.2, 1.2>;	// roundbox.inc-specific
#declare RB_P2 = <-1.2, -1.2, -1.2>; // roundbox.inc-specific

#declare source_point=array[8]  // creates an array with 8 elements
#include "point.inc"            // includes the file containing the point-rotating macro

#declare cube_rotation=<clock*360, clock*360, clock*360>;    // controls the rotation of the cube with its smoke sources
#declare cube_transformation=<0,5,0>; // controls the transformation of the cube with its smoke sources

object
{	 
	#include "roundbox.inc" // creates a cube at <0,0,0> with a side of 2.4 units
	texture{T_Grnt26}
	rotate cube_rotation			// this rotation is also used by the smoke sources
	translate cube_transformation	// places the center of the box at <0,5,0>
	point(0,<0.9,0.9,0.9>,cube_rotation,cube_transformation)
	point(1,<-0.9,0.9,0.9>,cube_rotation,cube_transformation)
	point(2,<0.9,0.9,-0.9>,cube_rotation,cube_transformation)
	point(3,<-0.9,0.9,-0.9>,cube_rotation,cube_transformation)
	point(4,<0.9,-0.9,0.9>,cube_rotation,cube_transformation)
	point(5,<-0.9,-0.9,0.9>,cube_rotation,cube_transformation)
	point(6,<0.9,-0.9,-0.9>,cube_rotation,cube_transformation)
	point(7,<-0.9,-0.9,-0.9>,cube_rotation,cube_transformation)
}

//*************************************************************************************
// The SmokeGen parameters: (all except obj_pos and SourceID, which has to be changed before SmokeGen is included each time)

#declare SceneStartClock=0;
#declare PreviewMode=2;

#declare MainColor=<1,1,1>;

#declare InitialSize=1;
#declare MaxSizeInc=0.1;

#declare InitEmiss=0.5;
#declare Trend=-0.05;								// Negative Trend value = we want the smoke to fade eventually

#declare CenterOfRotation=<0,5,0>;	// Same value as cube_transformation
#declare SmokeMass=0.3;

//*************************************************************************************
// finally....all set & done, ready to go....

#local SmokeIsOn=1;
#ifdef(SmokeIsOn)

	#declare obj_pos=source_point[0];	// the first corner of the cube (source_point[0] was declared by the point macro)
	#declare SourceID=1;
	#include "SmokeGen.inc"
	
	// as none of the SmokeGen parameters are re-declared here, 
	// the second source gets the same properties as the first 
	// (and so on).
	
	#declare obj_pos=source_point[1];	// the second corner of the cube (source_point[1] was also declared by the point macro)
	#declare SourceID=2;
	#include "SmokeGen.inc"
		
	#declare obj_pos=source_point[2]; 	// the third corner of the cube (source_point[2] was also declared by the point macro)
	#declare SourceID=3;
	#include "SmokeGen.inc"
	
	#declare obj_pos=source_point[3];	// etc.
	#declare SourceID=4;
	#include "SmokeGen.inc"
	
	#declare obj_pos=source_point[4];
	#declare SourceID=5;
	#include "SmokeGen.inc"
	
	#declare obj_pos=source_point[5];
	#declare SourceID=6;
	#include "SmokeGen.inc"
		
	#declare obj_pos=source_point[6];
	#declare SourceID=7;
	#include "SmokeGen.inc"
	
	#declare obj_pos=source_point[7];
	#declare SourceID=8;
	#include "SmokeGen.inc"
#end

//*************************************************************************************
//EOF	