/**********************************************************************************/
// Persistence of Vision Ray Tracer Scene Description File
// File name   : Bamboo.pov 
// Version     : 3.5
// Image size  : Render with ... x ... for best results
// Description : Macro for planting reeds and bamboos, made with Hamapatch and
//		 converted to mesh (Pig plugin)
// Date        : August 2002 - May 2003
// Author      : Thomas A. M. de Groot
// E-mail      : t.degroot@inter.nl.net
 
// Copyright (C) 2002, 2003. All rights reserved.
/**********************************************************************************/

global_settings {
  noise_generator 3
  assumed_gamma 1.0
}

#declare Test = true; //for use as a macro, change to false
#if (Test)
#include "TdG_Textures.inc"
camera {
	location <0, 40, -80>
	look_at <0, 25, 0>
}

light_source { < 500, 500, -500 > color rgb <1,1,1> }
light_source { < -500, 500, -500 > color rgb <1,1,1> }

background { color rgb <0.5, 0.5, 0.7> }

// Copy these declarations into your scene, include Bamboo.pov, and object {MeshVeg}:
#declare Whatever = seed(4382);			//random seed
#declare MinSca = 0.5;							//minimum scale of each complete element
#declare MaxSca = 2.0;							//maximum scale of each complete element
#declare MinRot = -50;							//minimum rotation (Y-axis) of each individual element, and complete element
#declare MaxRot = 50;							//maximum rotation (Y-axis) of each individual element. and complete element
#declare PtA = <-20,-0.99,-20>;			//first angle of confining rectangle
#declare PtB = <20,0.0,20>;					//second angle of confining rectangle
#declare GenSca = 0.3;							//scale of each complete element
#declare Number = 200;								//number of elements
#declare WindAngle =<0,0,5>;				//direction and force of the wind on each individual elements
#declare Type = 6; 									//bamboo or reed type
#declare Moray = false;							//correction for use with Moray
#declare PlantTex = TdG_Reed_01	//texture

#end //end of Test

/***********************************************************************************

           B A M B O O   a n d   R E E D   P L A N T I N G   v. 2.0 
         
                                     b y
                                   
                        T h o m a s   d e   G r o o t
                        
                           August 2002 / May 2003

------------------------------------------------------------------------------------
Type 1 = Simple Bamboo, with unstalked leaves
Type 2 = Reed, simple
Type 3 = Bamboo, with a stalked composite leaf
Type 4 = Bamboo, with multiple composite branches/leaves
Type 5 = Reed, with fan-like disposition of leaves
Type 6 = Reed, more complex 
************************************************************************************/

#include "rand.inc"

#ifndef (Whatever)  #declare Whatever = seed(432); #end
#ifndef (MinSca)    #declare MinSca = 0.5; #end
#ifndef (MaxSca)    #declare MaxSca = 1.0; #end
#ifndef (MinRot)    #declare MinRot = -45; #end
#ifndef (MaxRot)    #declare MaxRot = 45; #end
#ifndef (PtA)       #declare PtA = <-10,-0.99,-10>; #end
#ifndef (PtB)       #declare PtB = <10,0.0,10>; #end
#ifndef (GenSca)    #declare GenSca = 1.0; #end
#ifndef (Number)    #declare Number = 50; #end
#ifndef (WindAngle) #declare WindAngle =<0,0,2>; #end
#ifndef (Type) #declare Type = 3; #end
#ifndef (Moray) #declare Moray = false; #end
#ifndef (PlantTex) #declare PlantTex = texture {pigment {rgb < 1, 1, 0 >} finish {phong 0.9}} #end

#switch (Type)
#declare Total = 0;

#case (1) // Simple Bamboo
#include "BambooMesh_01.inc"
#declare Stalk08 = object {Bamboo08 translate -41.841497*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 41.841497*y}
#declare Stalk07 = union {object {Stalk08} object {Bamboo07} translate -36.922737*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 36.922737*y}
#declare Stalk06 = union {object {Stalk07} object {Bamboo06} translate -31.510188*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 31.510188*y}
#declare Stalk05 = union {object {Stalk06} object {Bamboo05} translate -25.816218*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 25.816218*y}
#declare Stalk04 = union {object {Stalk05} object {Bamboo04} translate -19.820239*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 19.820239*y}
#declare Stalk03 = union {object {Stalk04} object {Bamboo03} translate -13.390003*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 13.390003*y}
#declare Stalk02 = union {object {Stalk03} object {Bamboo02} translate  -6.689961*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 6.689961*y}
#declare Stalk01 = union {object {Stalk02} object {Bamboo01} translate        0.0*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate  0.0*y texture {PlantTex}}
#break

#case (2) //Reed
#include "ReedMesh_01.inc"
#declare Stalk08 = object {Reed08 translate -95.4*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 95.4*y}
#declare Stalk07 = union {object {Stalk08} object {Reed07} translate -87.9*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 87.9*y}
#declare Stalk06 = union {object {Stalk07} object {Reed06} translate -77.2*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 77.2*y}
#declare Stalk05 = union {object {Stalk06} object {Reed05} translate -62.0*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 62.0*y}
#declare Stalk04 = union {object {Stalk05} object {Reed04} translate -46.5*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 46.5*y}
#declare Stalk03 = union {object {Stalk04} object {Reed03} translate -31.0*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 31.0*y}
#declare Stalk02 = union {object {Stalk03} object {Reed02} translate -15.5*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 15.5*y}
#declare Stalk01 = union {object {Stalk02} object {Reed01} translate   0.0*y scale <0.9,1,0.9> rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate  0.0*y texture {PlantTex}}
#break

#case (3) //Bamboo with a stalked composite leaf
#include "BambooMesh_02.inc"
#declare Stalk08 = object {Bamboo08 translate -41.841497*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 41.841497*y}
#declare Stalk07 = union {object {Stalk08} object {Bamboo07} translate -36.922737*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 36.922737*y}
#declare Stalk06 = union {object {Stalk07} object {Bamboo06} translate -31.510188*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 31.510188*y}
#declare Stalk05 = union {object {Stalk06} object {Bamboo05} translate -25.816218*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 25.816218*y}
#declare Stalk04 = union {object {Stalk05} object {Bamboo04} translate -19.820239*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 19.820239*y}
#declare Stalk03 = union {object {Stalk04} object {Bamboo03} translate -13.390003*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 13.390003*y}
#declare Stalk02 = union {object {Stalk03} object {Bamboo02} translate  -6.689961*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 6.689961*y}
#declare Stalk01 = union {object {Stalk02} object {Bamboo01} translate        0.0*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate  0.0*y texture {PlantTex}}
#break

#case (4) //Bamboo with multiple composite branches/leaves
#include "BambooMesh_03.inc"
#declare Stalk08 = object {Bamboo08 translate -41.841497*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 41.841497*y}
#declare Stalk07 = union {object {Stalk08} object {Bamboo07} translate -36.922737*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 36.922737*y}
#declare Stalk06 = union {object {Stalk07} object {Bamboo06} translate -31.510188*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 31.510188*y}
#declare Stalk05 = union {object {Stalk06} object {Bamboo05} translate -25.816218*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 25.816218*y}
#declare Stalk04 = union {object {Stalk05} object {Bamboo04} translate -19.820239*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 19.820239*y}
#declare Stalk03 = union {object {Stalk04} object {Bamboo03} translate -13.390003*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 13.390003*y}
#declare Stalk02 = union {object {Stalk03} object {Bamboo02} translate  -6.689961*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 6.689961*y}
#declare Stalk01 = union {object {Stalk02} object {Bamboo01} translate        0.0*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate  0.0*y texture {PlantTex}}
#break

#case (5) //Reed with fan-like disposition of leaves
#include "ReedMeshg_02.inc"
#declare Stalk01 = object {Reed02 texture {PlantTex}}
#break

#case (6) //Reed
#include "ReedMesh_03.inc"
#declare Stalk08 = object {Reed08 translate -95.4*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 95.4*y}
#declare Stalk07 = union {object {Stalk08} object {Reed07} translate -87.9*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 87.9*y}
#declare Stalk06 = union {object {Stalk07} object {Reed06} translate -77.2*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 77.2*y}
#declare Stalk05 = union {object {Stalk06} object {Reed05} translate -62.0*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 62.0*y}
#declare Stalk04 = union {object {Stalk05} object {Reed04} translate -46.5*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 46.5*y}
#declare Stalk03 = union {object {Stalk04} object {Reed03} translate -31.0*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 31.0*y}
#declare Stalk02 = union {object {Stalk03} object {Reed02} translate -15.5*y rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate 15.5*y}
#declare Stalk01 = union {object {Stalk02} object {Reed01} translate   0.0*y scale <0.9,1,0.9> rotate RRand(MinRot, MaxRot, Whatever)*y rotate WindAngle translate  0.0*y texture {PlantTex}}
#end

#declare MeshVeg =
union {
 #while (Total<Number)
  object {Stalk01
    scale GenSca
    scale RRand(MinSca, MaxSca, Whatever)
    rotate RRand(MinRot, MaxRot, Whatever)*y
    translate VRand_In_Box(PtA, PtB, Whatever)
  }
  #declare Total =Total+1;
 #end
}

#switch (Type)
#case (1)
	#debug concat("Planted ", str(Number,0,0), " bamboo stalks\n")
#break
#case (2)
	#debug concat("Planted ", str(Number,0,0), " reed stalks\n")
#break
#case (3)
	#debug concat("Planted ", str(Number,0,0), " bamboo stalks\n")
#break
#case (4)
	#debug concat("Planted ", str(Number,0,0), " bamboo stalks\n")
#break
#case (5)
	#debug concat("Planted ", str(Number,0,0), " reed stalks\n")
#break
#case (6)
	#debug concat("Planted ", str(Number,0,0), " reed stalks\n")
#end

// Transformations for the use in Moray:
#if (Moray)
	#declare MeshVeg =
	object {MeshVeg scale <1,1,-1> rotate x*90}
#end

#if (Test)
	object {MeshVeg rotate <0,0,0> translate <0,0,0>}
	box {
  	PtA  // one corner position <X1 Y1 Z1>
  	PtB  // other corner position <X2 Y2 Z2>
		pigment { rgb < 1, 0, 0 > }
		finish { phong 0.9 }
	}
  plane {
    y, 
    -0.99 // distance from the origin in the direction of the surface normal
    pigment { rgb < 1, 0.5, 0.5 > }
  }
#end


