
/**********************************************************************************
 Persistence of Vision Ray Tracer Scene Description File
 File name   : HF_testing.pov
 Version     : 3.8
 Description : Test file for any kind of height_field
**********************************************************************************/

// Render settings (right-click on a line below):
//+w800 +h400 +a0.3 +am2 +bm2 +bs8 +wt6

#version 3.8;

#declare AspectRatio    = image_width/image_height;
#declare CamZoom        = 1.0;
#declare CamSky         = <0, 1, 0>;
#declare CamAng         = 85;
#declare CamLoc         = <0, 250, -450.0>;
#declare CamLookAt      = <0.0, 0.0, 0.0>;

#declare HF_scale       = <500, 100, 500>;
#declare HF_res         = 2000;

global_settings {
  assumed_gamma 1.0
}

camera {
  location  CamLoc
  direction CamZoom*z
  right     x*AspectRatio
  look_at   CamLookAt
  angle     CamAng
}

light_source {
  <0, 0, 0>
  color rgb <1, 1, 1>*2
  translate <3, 2, -3>*1000
}

light_source {
  <0, 0, 0>
  color rgb <1, 1, 1>*0.3
  translate <-3, 2, 3>*1000
  shadowless
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

//====================================================================================
#declare F_HF_01 =
function {
  pigment {
    image_map {
      tga "GC_Gancaloon_03.tga" gamma 1.0
      //once
      map_type 0
      interpolate 2
    }
  }
}

#declare hf1 =
//intersection {
  height_field {
    function HF_res, HF_res {F_HF_01(x,y,z).hf}
    scale HF_scale
    translate <-HF_scale.x/2, 0, -HF_scale.z/2>
  }
//  box {
//    <-0.5, -0.5, -0.5>, <0.5, 1.0, 0.5>
//    scale HF_scale * <0.99, 1, 0.99>
//  }
//}

object {hf1 pigment {rgb x+y}}
