/* POV-Ray 3.1 Scene Description File
   FURTEX
   Copyright April 2000 Rune S. Johansen - http://rsj.mobilixnet.dk
   
   Use:
   
   object {
      MyObject
      FurTex ( color MyColor )
   }
   
*/
   
// Start of FurTex macro
   #macro FurTex(Color)
      texture {
         average
         texture_map {
            [
               pigment {
                  bozo
                  color_map {[0,color Color*0.9][1,color Color*1.1]}
                  scale 0.001
               }
               normal {
                  average
                  normal_map {
                     [
                        bumps 0.3*2
                        warp {turbulence 1}
                        scale 0.2
                     ]
                     [
                        bumps 0.2*2
                        warp {turbulence 0.5}
                        scale 0.001
                     ]
                  }
               }
               finish {ambient 0.1*2 diffuse 0.6*2 brilliance 0.6}
            ]
            [
               pigment {color -Color}
               finish {ambient 0 diffuse 0 phong 0.5*2 phong_size 2 metallic}
            ]
         }
      }
   #end
// End of FurTex macro
   
   #declare Seed = seed(4);
   
   #declare X = 0;
   #declare Y = 5;
   #while (X<Y)
      blob {
         threshold 1
         sphere {x,1.5,2 rotate 000*z}
         sphere {x,1.5,2 rotate 120*z}
         sphere {x,1.5,2 rotate 240*z}
         FurTex(color <0.5+rand(Seed),0.5+rand(Seed),0.5+rand(Seed)>)
         rotate 3600*<rand(Seed),rand(Seed),rand(Seed)>
         translate 3*x
         rotate 360*X/Y*z
      }
      #declare X = X+1;
   #end
   
   blob {
      threshold 1.4
      sphere {x,1.5,2 rotate 000*z}
      sphere {x,1.5,2 rotate 120*z}
      sphere {x,1.5,2 rotate 240*z}
      pigment {color <1.0,0.8,0.7>}
      finish {phong 0.1 phong_size 10}
      rotate <0,30,-40>
   }
   
   light_source {<+1,+2,-2>*1000, color 0.6}
   light_source {<-1,+1,-2>*1000, color 0.5}
   light_source {<+2,+0,-2>*1000, color 0.4}
   
   background {color rgb 0.8}
   
   camera {
      location -20*z
      angle 30
      look_at 0
   }
   