// File : VERSION31.POV created by BIOFORM v.0.99g ----------
global_settings {assumed_gamma 2.2}
 
#include "biopred.inc"
 
camera { 
  location <0.0, 0.0, -30>
  direction <0.0, 0.0, 1.2>
  right <1.3, 0.0, 0.0>
  look_at <0.0, 0.0, 0.0>
}
 
light_source {0*x color red 1.000 green 1.000 blue 1.000 translate <-10, 10, -30>}
light_source {0*x color red 0.600 green 0.600 blue 0.600 translate <40, 60, -60>}
 
#declare Bol = sphere {<0, 0, 0>, .5 }
#declare Spik1 =  union {
 sphere { <0, 0, 0>, .5}
 cone {<0,0,0>,0.15, <1.5,0,0>, 0.005}
 cone {<0,0,0>,0.15, <1.5,0,0>, 0.005 rotate <0,0,90>}
 cone {<0,0,0>,0.15, <1.5,0,0>, 0.005 rotate <0,0,180>}
 cone {<0,0,0>,0.15, <1.5,0,0>, 0.005 rotate <0,0,270>}
}
#declare SS =  union {
 cylinder { <-2, 0, 0>, <0, 0, 0>, .25 rotate <0,0,-10>}
 cylinder { <0, 0, 0>, <2, 0, 0>, .25  rotate <0,0,10>}
 cone {<-1.8,0,0>, 0.2 <-1.8,4,0>, 0.005 rotate <0,0,5>}
 cone {<1.8,0,0>, 0.2 <1.8,4,0>, 0.005 rotate <0,0,-5>}
 }
#declare Spik3 = union {
 object {SS}
 object {SS rotate <0, 60, 0>}
 object {SS rotate <0, 120,0>}
 }
#declare Spik4 =  union {
 sphere { <0, 0, 0>, .6 }
 cone {<0,0,0>,0.1, <-0, 4, 0>, 0.005 rotate <0, 0, -10> translate <0.4,0,0>}
 cone {<0,0,0>,0.1, <0, 4, 0>, 0.005 rotate <0, 0, 10> translate <-0.4,0,0>}
}
 
#macro Connect(SP,SR,EP,ER)
 #local D=vlength(EP-SP);
 #local Rd=SR-ER;
 #local D2=sqrt(D*D-Rd*Rd);
 cone { SP+(EP-SP)/D*Rd*(SR)/D,(SR)*D2/D,EP+(EP-SP)/D*Rd*(ER)/D,(ER)*D2/D }
#end 
 
 
#declare JSegment = object {Spik3}
 
#declare JSegment2 = object {Spik4}
 
#declare HuskObj =  object {Bol}
 
#declare HelixObj =  object {Spik1}
 
#declare W0 = 
 union {
  object { 
  JSegment
  scale <0.996, 0.997, 0.996>
  rotate <1, 1, 1>
  translate <-0.038, 0.100, 0.032>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <0, 0, 0>
  translate <-0.038, 0.100, 0.032>
  translate <0.096, -0.029, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <138, 138, 138>
  translate <-0.078, 0.199, 0.064>
  translate <0.083, -0.056, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <275, 275, 275>
  translate <-0.120, 0.298, 0.095>
  translate <0.062, -0.078, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <413, 413, 413>
  translate <-0.165, 0.397, 0.124>
  translate <0.037, -0.093, 0.000>
 }
  object { 
  JSegment2
  scale <0.982, 0.984, 0.980>
  rotate <4, 4, 4>
  translate <-0.212, 0.495, 0.153>
 }
 object{ Connect(<-0.16, 0.40, 0.12>, 0.49, <-0.21, 0.50, 0.15>, 0.49)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <550, 550, 550>
  translate <-0.212, 0.495, 0.153>
  translate <0.007, -0.100, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <688, 688, 688>
  translate <-0.261, 0.593, 0.181>
  translate <-0.022, -0.097, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <825, 825, 825>
  translate <-0.313, 0.691, 0.207>
  translate <-0.050, -0.087, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <963, 963, 963>
  translate <-0.366, 0.788, 0.233>
  translate <-0.073, -0.068, 0.000>
 }
  object { 
  JSegment
  scale <0.968, 0.971, 0.964>
  rotate <7, 7, 7>
  translate <-0.421, 0.886, 0.257>
 }
 object{ Connect(<-0.37, 0.79, 0.23>, 0.49, <-0.42, 0.89, 0.26>, 0.48)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1100, 1.1E3, 1.1E3>
  translate <-0.421, 0.886, 0.257>
  translate <-0.090, -0.043, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1238, 1.24E3, 1.24E3>
  translate <-0.478, 0.982, 0.280>
  translate <-0.099, -0.015, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1375, 1.38E3, 1.38E3>
  translate <-0.537, 1.079, 0.302>
  translate <-0.099, 0.015, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1513, 1.51E3, 1.51E3>
  translate <-0.597, 1.175, 0.323>
  translate <-0.090, 0.043, 0.000>
 }
  object { 
  JSegment2
  scale <0.954, 0.958, 0.948>
  rotate <11, 11, 11>
  translate <-0.659, 1.271, 0.343>
 }
 object{ Connect(<-0.60, 1.17, 0.32>, 0.48, <-0.66, 1.27, 0.34>, 0.48)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1650, 1.65E3, 1.65E3>
  translate <-0.659, 1.271, 0.343>
  translate <-0.073, 0.068, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1788, 1.79E3, 1.79E3>
  translate <-0.722, 1.366, 0.361>
  translate <-0.050, 0.087, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1925, 1.93E3, 1.93E3>
  translate <-0.786, 1.461, 0.378>
  translate <-0.022, 0.097, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <2063, 2.06E3, 2.06E3>
  translate <-0.852, 1.556, 0.394>
  translate <0.007, 0.100, 0.000>
 }
  object { 
  JSegment
  scale <0.939, 0.945, 0.932>
  rotate <14, 14, 14>
  translate <-0.918, 1.651, 0.408>
 }
 object{ Connect(<-0.85, 1.56, 0.39>, 0.47, <-0.92, 1.65, 0.41>, 0.47)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <2200, 2.2E3, 2.2E3>
  translate <-0.918, 1.651, 0.408>
  translate <0.037, 0.093, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <2338, 2.34E3, 2.34E3>
  translate <-0.986, 1.745, 0.421>
  translate <0.062, 0.078, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <2475, 2.48E3, 2.48E3>
  translate <-1.054, 1.839, 0.433>
  translate <0.083, 0.056, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <2613, 2.61E3, 2.61E3>
  translate <-1.122, 1.932, 0.443>
  translate <0.096, 0.029, 0.000>
 }
  object { 
  JSegment2
  scale <0.925, 0.932, 0.916>
  rotate <17, 17, 17>
  translate <-1.192, 2.026, 0.452>
 }
 object{ Connect(<-1.12, 1.93, 0.44>, 0.46, <-1.19, 2.03, 0.45>, 0.46)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <2750, 2.75E3, 2.75E3>
  translate <-1.192, 2.026, 0.452>
  translate <0.100, 0.000, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <2888, 2.89E3, 2.89E3>
  translate <-1.261, 2.119, 0.460>
  translate <0.096, -0.029, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <3025, 3.03E3, 3.03E3>
  translate <-1.331, 2.211, 0.466>
  translate <0.083, -0.056, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <3163, 3.16E3, 3.16E3>
  translate <-1.402, 2.304, 0.471>
  translate <0.062, -0.078, 0.000>
 }
  object { 
  JSegment
  scale <0.911, 0.920, 0.900>
  rotate <20, 20, 20>
  translate <-1.472, 2.396, 0.475>
 }
 object{ Connect(<-1.40, 2.30, 0.47>, 0.46, <-1.47, 2.40, 0.47>, 0.46)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <3300, 3.3E3, 3.3E3>
  translate <-1.472, 2.396, 0.475>
  translate <0.037, -0.093, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <3438, 3.44E3, 3.44E3>
  translate <-1.542, 2.487, 0.477>
  translate <0.007, -0.100, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <3575, 3.58E3, 3.58E3>
  translate <-1.612, 2.578, 0.478>
  translate <-0.022, -0.097, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <3713, 3.71E3, 3.71E3>
  translate <-1.682, 2.669, 0.477>
  translate <-0.050, -0.087, 0.000>
 }
  object { 
  JSegment2
  scale <0.896, 0.907, 0.884>
  rotate <24, 24, 24>
  translate <-1.751, 2.760, 0.475>
 }
 object{ Connect(<-1.68, 2.67, 0.48>, 0.45, <-1.75, 2.76, 0.48>, 0.45)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <3850, 3.85E3, 3.85E3>
  translate <-1.751, 2.760, 0.475>
  translate <-0.073, -0.068, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <3988, 3.99E3, 3.99E3>
  translate <-1.820, 2.851, 0.472>
  translate <-0.090, -0.043, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <4125, 4.13E3, 4.13E3>
  translate <-1.888, 2.941, 0.468>
  translate <-0.099, -0.015, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <4263, 4.26E3, 4.26E3>
  translate <-1.956, 3.030, 0.462>
  translate <-0.099, 0.015, 0.000>
 }
 object {HuskObj
   texture {pigment { bozo  color_map {  [0.000 color rgb <0.140, 0.560, 0.420 > ] [1.000 color rgb <0.850, 0.530, 0.100 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  scale <0.882, 0.894, 0.868>
  rotate <27, 27, 27>
  translate <-2.023, 3.120, 0.455>
 }
 object{ Connect(<-1.96, 3.03, 0.46>, 0.44, <-2.02, 3.12, 0.46>, 0.44)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <4400, 4.4E3, 4.4E3>
  translate <-2.023, 3.120, 0.455>
  translate <-0.090, 0.043, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <4538, 4.54E3, 4.54E3>
  translate <-2.089, 3.209, 0.447>
  translate <-0.073, 0.068, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <4675, 4.68E3, 4.68E3>
  translate <-2.153, 3.297, 0.438>
  translate <-0.050, 0.087, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <4813, 4.81E3, 4.81E3>
  translate <-2.217, 3.386, 0.427>
  translate <-0.022, 0.097, 0.000>
 }
 object {HuskObj
   texture {pigment { bozo  color_map {  [0.000 color rgb <0.140, 0.560, 0.420 > ] [1.000 color rgb <0.850, 0.530, 0.100 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  scale <0.868, 0.881, 0.852>
  rotate <30, 30, 30>
  translate <-2.280, 3.474, 0.416>
 }
 object{ Connect(<-2.22, 3.39, 0.43>, 0.44, <-2.28, 3.47, 0.42>, 0.43)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <4950, 4.95E3, 4.95E3>
  translate <-2.280, 3.474, 0.416>
  translate <0.007, 0.100, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <5088, 5.09E3, 5.09E3>
  translate <-2.341, 3.562, 0.403>
  translate <0.037, 0.093, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <5225, 5.23E3, 5.23E3>
  translate <-2.401, 3.649, 0.389>
  translate <0.062, 0.078, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <5363, 5.36E3, 5.36E3>
  translate <-2.459, 3.736, 0.374>
  translate <0.083, 0.056, 0.000>
 }
 object {HuskObj
   texture {pigment { bozo  color_map {  [0.000 color rgb <0.140, 0.560, 0.420 > ] [1.000 color rgb <0.850, 0.530, 0.100 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  scale <0.854, 0.868, 0.836>
  rotate <34, 34, 34>
  translate <-2.516, 3.823, 0.358>
 }
 object{ Connect(<-2.46, 3.74, 0.37>, 0.43, <-2.52, 3.82, 0.36>, 0.43)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <5500, 5.5E3, 5.5E3>
  translate <-2.516, 3.823, 0.358>
  translate <0.096, 0.029, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <5638, 5.64E3, 5.64E3>
  translate <-2.571, 3.910, 0.341>
  translate <0.100, 0.000, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <5775, 5.78E3, 5.78E3>
  translate <-2.625, 3.996, 0.323>
  translate <0.096, -0.029, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <5913, 5.91E3, 5.91E3>
  translate <-2.676, 4.082, 0.304>
  translate <0.083, -0.056, 0.000>
 }
 object {HuskObj
   texture {pigment { bozo  color_map {  [0.000 color rgb <0.140, 0.560, 0.420 > ] [1.000 color rgb <0.850, 0.530, 0.100 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  scale <0.839, 0.855, 0.821>
  rotate <37, 37, 37>
  translate <-2.726, 4.167, 0.284>
 }
 object{ Connect(<-2.68, 4.08, 0.30>, 0.42, <-2.73, 4.17, 0.28>, 0.42)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <6050, 6.05E3, 6.05E3>
  translate <-2.726, 4.167, 0.284>
  translate <0.062, -0.078, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <6188, 6.19E3, 6.19E3>
  translate <-2.774, 4.253, 0.264>
  translate <0.037, -0.093, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <6325, 6.33E3, 6.33E3>
  translate <-2.820, 4.337, 0.242>
  translate <0.007, -0.100, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <6463, 6.46E3, 6.46E3>
  translate <-2.864, 4.422, 0.220>
  translate <-0.022, -0.097, 0.000>
 }
  object { 
  JSegment
  scale <0.825, 0.842, 0.805>
  rotate <40, 40, 40>
  translate <-2.906, 4.506, 0.197>
 }
 object{ Connect(<-2.86, 4.42, 0.22>, 0.41, <-2.91, 4.51, 0.20>, 0.41)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <6600, 6.6E3, 6.6E3>
  translate <-2.906, 4.506, 0.197>
  translate <-0.050, -0.087, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <6738, 6.74E3, 6.74E3>
  translate <-2.946, 4.590, 0.173>
  translate <-0.073, -0.068, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <6875, 6.88E3, 6.88E3>
  translate <-2.983, 4.674, 0.149>
  translate <-0.090, -0.043, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <7013, 7.01E3, 7.01E3>
  translate <-3.018, 4.757, 0.124>
  translate <-0.099, -0.015, 0.000>
 }
  object { 
  JSegment2
  scale <0.811, 0.830, 0.789>
  rotate <43, 43, 43>
  translate <-3.052, 4.840, 0.099>
 }
 object{ Connect(<-3.02, 4.76, 0.12>, 0.41, <-3.05, 4.84, 0.10>, 0.41)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <7150, 7.15E3, 7.15E3>
  translate <-3.052, 4.840, 0.099>
  translate <-0.099, 0.015, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <7288, 7.29E3, 7.29E3>
  translate <-3.082, 4.923, 0.073>
  translate <-0.090, 0.043, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <7425, 7.43E3, 7.43E3>
  translate <-3.111, 5.005, 0.047>
  translate <-0.073, 0.068, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <7563, 7.56E3, 7.56E3>
  translate <-3.137, 5.087, 0.020>
  translate <-0.050, 0.087, 0.000>
 }
  object { 
  JSegment
  scale <0.796, 0.817, 0.773>
  rotate <47, 47, 47>
  translate <-3.161, 5.169, -0.007>
 }
 object{ Connect(<-3.14, 5.09, 0.02>, 0.40, <-3.16, 5.17, -0.01>, 0.40)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <7700, 7.7E3, 7.7E3>
  translate <-3.161, 5.169, -0.007>
  translate <-0.022, 0.097, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <7838, 7.84E3, 7.84E3>
  translate <-3.182, 5.250, -0.034>
  translate <0.007, 0.100, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <7975, 7.98E3, 7.98E3>
  translate <-3.201, 5.331, -0.061>
  translate <0.037, 0.093, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <8113, 8.11E3, 8.11E3>
  translate <-3.217, 5.412, -0.089>
  translate <0.062, 0.078, 0.000>
 }
  object { 
  JSegment2
  scale <0.782, 0.804, 0.757>
  rotate <50, 50, 50>
  translate <-3.232, 5.492, -0.117>
 }
 object{ Connect(<-3.22, 5.41, -0.09>, 0.39, <-3.23, 5.49, -0.12>, 0.39)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <8250, 8.25E3, 8.25E3>
  translate <-3.232, 5.492, -0.117>
  translate <0.083, 0.056, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <8388, 8.39E3, 8.39E3>
  translate <-3.243, 5.572, -0.145>
  translate <0.096, 0.029, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <8525, 8.53E3, 8.53E3>
  translate <-3.253, 5.652, -0.173>
  translate <0.100, 0.000, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <8663, 8.66E3, 8.66E3>
  translate <-3.260, 5.731, -0.201>
  translate <0.096, -0.029, 0.000>
 }
  object { 
  JSegment
  scale <0.768, 0.791, 0.741>
  rotate <53, 53, 53>
  translate <-3.264, 5.811, -0.230>
 }
 object{ Connect(<-3.26, 5.73, -0.20>, 0.39, <-3.26, 5.81, -0.23>, 0.38)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <8800, 8.8E3, 8.8E3>
  translate <-3.264, 5.811, -0.230>
  translate <0.083, -0.056, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <8938, 8.94E3, 8.94E3>
  translate <-3.266, 5.889, -0.258>
  translate <0.062, -0.078, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <9075, 9.08E3, 9.08E3>
  translate <-3.266, 5.968, -0.286>
  translate <0.037, -0.093, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <9213, 9.21E3, 9.21E3>
  translate <-3.264, 6.046, -0.313>
  translate <0.007, -0.100, 0.000>
 }
  object { 
  JSegment2
  scale <0.754, 0.778, 0.725>
  rotate <56, 56, 56>
  translate <-3.259, 6.124, -0.341>
 }
 object{ Connect(<-3.26, 6.05, -0.31>, 0.38, <-3.26, 6.12, -0.34>, 0.38)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <9350, 9.35E3, 9.35E3>
  translate <-3.259, 6.124, -0.341>
  translate <-0.022, -0.097, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <9488, 9.49E3, 9.49E3>
  translate <-3.252, 6.201, -0.368>
  translate <-0.050, -0.087, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <9625, 9.63E3, 9.63E3>
  translate <-3.242, 6.278, -0.395>
  translate <-0.073, -0.068, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <9763, 9.76E3, 9.76E3>
  translate <-3.231, 6.355, -0.422>
  translate <-0.090, -0.043, 0.000>
 }
  object { 
  JSegment
  scale <0.739, 0.765, 0.709>
  rotate <60, 60, 60>
  translate <-3.217, 6.432, -0.448>
 }
 object{ Connect(<-3.23, 6.36, -0.42>, 0.37, <-3.22, 6.43, -0.45>, 0.37)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <9900, 9.9E3, 9.9E3>
  translate <-3.217, 6.432, -0.448>
  translate <-0.099, -0.015, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.004E4, 1E4, 1E4>
  translate <-3.202, 6.508, -0.474>
  translate <-0.099, 0.015, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.018E4, 1.02E4, 1.02E4>
  translate <-3.184, 6.584, -0.499>
  translate <-0.090, 0.043, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.031E4, 1.03E4, 1.03E4>
  translate <-3.164, 6.659, -0.524>
  translate <-0.073, 0.068, 0.000>
 }
  object { 
  JSegment2
  scale <0.725, 0.752, 0.693>
  rotate <63, 63, 63>
  translate <-3.142, 6.735, -0.549>
 }
 object{ Connect(<-3.16, 6.66, -0.52>, 0.36, <-3.14, 6.73, -0.55>, 0.36)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.045E4, 1.05E4, 1.05E4>
  translate <-3.142, 6.735, -0.549>
  translate <-0.050, 0.087, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.059E4, 1.06E4, 1.06E4>
  translate <-3.118, 6.810, -0.573>
  translate <-0.022, 0.097, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.073E4, 1.07E4, 1.07E4>
  translate <-3.093, 6.884, -0.596>
  translate <0.007, 0.100, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.086E4, 1.09E4, 1.09E4>
  translate <-3.065, 6.959, -0.618>
  translate <0.037, 0.093, 0.000>
 }
  object { 
  JSegment
  scale <0.711, 0.740, 0.677>
  rotate <66, 66, 66>
  translate <-3.036, 7.033, -0.640>
 }
 object{ Connect(<-3.07, 6.96, -0.62>, 0.36, <-3.04, 7.03, -0.64>, 0.36)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.1E4, 1.1E4, 1.1E4>
  translate <-3.036, 7.033, -0.640>
  translate <0.062, 0.078, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.114E4, 1.11E4, 1.11E4>
  translate <-3.006, 7.106, -0.662>
  translate <0.083, 0.056, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.128E4, 1.13E4, 1.13E4>
  translate <-2.973, 7.179, -0.682>
  translate <0.096, 0.029, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.141E4, 1.14E4, 1.14E4>
  translate <-2.939, 7.252, -0.702>
  translate <0.100, 0.000, 0.000>
 }
  object { 
  JSegment2
  scale <0.696, 0.727, 0.661>
  rotate <70, 70, 70>
  translate <-2.904, 7.325, -0.721>
 }
 object{ Connect(<-2.94, 7.25, -0.70>, 0.35, <-2.90, 7.33, -0.72>, 0.35)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.155E4, 1.16E4, 1.16E4>
  translate <-2.904, 7.325, -0.721>
  translate <0.096, -0.029, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.169E4, 1.17E4, 1.17E4>
  translate <-2.868, 7.398, -0.739>
  translate <0.083, -0.056, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.183E4, 1.18E4, 1.18E4>
  translate <-2.830, 7.470, -0.757>
  translate <0.062, -0.078, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.196E4, 1.2E4, 1.2E4>
  translate <-2.791, 7.541, -0.774>
  translate <0.037, -0.093, 0.000>
 }
  object { 
  JSegment
  scale <0.682, 0.714, 0.645>
  rotate <73, 73, 73>
  translate <-2.750, 7.613, -0.789>
 }
 object{ Connect(<-2.79, 7.54, -0.77>, 0.34, <-2.75, 7.61, -0.79>, 0.34)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.21E4, 1.21E4, 1.21E4>
  translate <-2.750, 7.613, -0.789>
  translate <0.007, -0.100, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.224E4, 1.22E4, 1.22E4>
  translate <-2.709, 7.684, -0.804>
  translate <-0.022, -0.097, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.238E4, 1.24E4, 1.24E4>
  translate <-2.667, 7.754, -0.818>
  translate <-0.050, -0.087, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.251E4, 1.25E4, 1.25E4>
  translate <-2.623, 7.825, -0.831>
  translate <-0.073, -0.068, 0.000>
 }
  object { 
  JSegment2
  scale <0.668, 0.701, 0.629>
  rotate <76, 76, 76>
  translate <-2.579, 7.895, -0.844>
 }
 object{ Connect(<-2.62, 7.82, -0.83>, 0.34, <-2.58, 7.90, -0.84>, 0.33)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.265E4, 1.27E4, 1.27E4>
  translate <-2.579, 7.895, -0.844>
  translate <-0.090, -0.043, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.279E4, 1.28E4, 1.28E4>
  translate <-2.534, 7.965, -0.855>
  translate <-0.099, -0.015, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.293E4, 1.29E4, 1.29E4>
  translate <-2.489, 8.034, -0.865>
  translate <-0.099, 0.015, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.306E4, 1.31E4, 1.31E4>
  translate <-2.443, 8.103, -0.875>
  translate <-0.090, 0.043, 0.000>
 }
  object { 
  JSegment
  scale <0.654, 0.688, 0.613>
  rotate <79, 79, 79>
  translate <-2.396, 8.172, -0.883>
 }
 object{ Connect(<-2.44, 8.10, -0.87>, 0.33, <-2.40, 8.17, -0.88>, 0.33)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.32E4, 1.32E4, 1.32E4>
  translate <-2.396, 8.172, -0.883>
  translate <-0.073, 0.068, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.334E4, 1.33E4, 1.33E4>
  translate <-2.350, 8.241, -0.891>
  translate <-0.050, 0.087, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.348E4, 1.35E4, 1.35E4>
  translate <-2.302, 8.309, -0.898>
  translate <-0.022, 0.097, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.361E4, 1.36E4, 1.36E4>
  translate <-2.255, 8.377, -0.903>
  translate <0.007, 0.100, 0.000>
 }
  object { 
  JSegment2
  scale <0.639, 0.675, 0.597>
  rotate <83, 83, 83>
  translate <-2.207, 8.444, -0.908>
 }
 object{ Connect(<-2.25, 8.38, -0.90>, 0.32, <-2.21, 8.44, -0.91>, 0.32)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.375E4, 1.38E4, 1.38E4>
  translate <-2.207, 8.444, -0.908>
  translate <0.037, 0.093, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.389E4, 1.39E4, 1.39E4>
  translate <-2.160, 8.512, -0.912>
  translate <0.062, 0.078, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.403E4, 1.4E4, 1.4E4>
  translate <-2.112, 8.578, -0.915>
  translate <0.083, 0.056, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.416E4, 1.42E4, 1.42E4>
  translate <-2.064, 8.645, -0.917>
  translate <0.096, 0.029, 0.000>
 }
  object { 
  JSegment
  scale <0.625, 0.662, 0.581>
  rotate <86, 86, 86>
  translate <-2.017, 8.711, -0.918>
 }
 object{ Connect(<-2.06, 8.64, -0.92>, 0.31, <-2.02, 8.71, -0.92>, 0.31)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.43E4, 1.43E4, 1.43E4>
  translate <-2.017, 8.711, -0.918>
  translate <0.100, 0.000, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.444E4, 1.44E4, 1.44E4>
  translate <-1.969, 8.777, -0.918>
  translate <0.096, -0.029, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.458E4, 1.46E4, 1.46E4>
  translate <-1.923, 8.843, -0.918>
  translate <0.083, -0.056, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.471E4, 1.47E4, 1.47E4>
  translate <-1.876, 8.908, -0.916>
  translate <0.062, -0.078, 0.000>
 }
  object { 
  JSegment2
  scale <0.611, 0.650, 0.565>
  rotate <89, 89, 89>
  translate <-1.830, 8.973, -0.913>
 }
 object{ Connect(<-1.88, 8.91, -0.92>, 0.31, <-1.83, 8.97, -0.91>, 0.31)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.485E4, 1.49E4, 1.49E4>
  translate <-1.830, 8.973, -0.913>
  translate <0.037, -0.093, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.499E4, 1.5E4, 1.5E4>
  translate <-1.784, 9.038, -0.910>
  translate <0.007, -0.100, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.513E4, 1.51E4, 1.51E4>
  translate <-1.739, 9.102, -0.906>
  translate <-0.022, -0.097, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.526E4, 1.53E4, 1.53E4>
  translate <-1.695, 9.166, -0.901>
  translate <-0.050, -0.087, 0.000>
 }
  object { 
  JSegment
  scale <0.596, 0.637, 0.549>
  rotate <92, 92, 92>
  translate <-1.652, 9.230, -0.895>
 }
 object{ Connect(<-1.70, 9.17, -0.90>, 0.30, <-1.65, 9.23, -0.90>, 0.30)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.54E4, 1.54E4, 1.54E4>
  translate <-1.652, 9.230, -0.895>
  translate <-0.073, -0.068, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.554E4, 1.55E4, 1.55E4>
  translate <-1.609, 9.293, -0.889>
  translate <-0.090, -0.043, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.568E4, 1.57E4, 1.57E4>
  translate <-1.567, 9.356, -0.881>
  translate <-0.099, -0.015, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.581E4, 1.58E4, 1.58E4>
  translate <-1.526, 9.419, -0.873>
  translate <-0.099, 0.015, 0.000>
 }
  object { 
  JSegment2
  scale <0.582, 0.624, 0.533>
  rotate <96, 96, 96>
  translate <-1.486, 9.481, -0.864>
 }
 object{ Connect(<-1.53, 9.42, -0.87>, 0.29, <-1.49, 9.48, -0.86>, 0.29)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.595E4, 1.6E4, 1.6E4>
  translate <-1.486, 9.481, -0.864>
  translate <-0.090, 0.043, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.609E4, 1.61E4, 1.61E4>
  translate <-1.447, 9.543, -0.855>
  translate <-0.073, 0.068, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.623E4, 1.62E4, 1.62E4>
  translate <-1.409, 9.605, -0.845>
  translate <-0.050, 0.087, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.636E4, 1.64E4, 1.64E4>
  translate <-1.372, 9.666, -0.834>
  translate <-0.022, 0.097, 0.000>
 }
  object { 
  JSegment
  scale <0.568, 0.611, 0.517>
  rotate <99, 99, 99>
  translate <-1.337, 9.728, -0.822>
 }
 object{ Connect(<-1.37, 9.67, -0.83>, 0.29, <-1.34, 9.73, -0.82>, 0.28)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.65E4, 1.65E4, 1.65E4>
  translate <-1.337, 9.728, -0.822>
  translate <0.007, 0.100, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.664E4, 1.66E4, 1.66E4>
  translate <-1.302, 9.788, -0.810>
  translate <0.037, 0.093, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.678E4, 1.68E4, 1.68E4>
  translate <-1.269, 9.849, -0.798>
  translate <0.062, 0.078, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.691E4, 1.69E4, 1.69E4>
  translate <-1.237, 9.909, -0.785>
  translate <0.083, 0.056, 0.000>
 }
  object { 
  JSegment2
  scale <0.554, 0.598, 0.501>
  rotate <102, 102, 102>
  translate <-1.207, 9.969, -0.771>
 }
 object{ Connect(<-1.24, 9.91, -0.78>, 0.28, <-1.21, 9.97, -0.77>, 0.28)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.705E4, 1.71E4, 1.71E4>
  translate <-1.207, 9.969, -0.771>
  translate <0.096, 0.029, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.719E4, 1.72E4, 1.72E4>
  translate <-1.178, 10.028, -0.757>
  translate <0.100, 0.000, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.733E4, 1.73E4, 1.73E4>
  translate <-1.150, 10.087, -0.743>
  translate <0.096, -0.029, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.746E4, 1.75E4, 1.75E4>
  translate <-1.124, 10.146, -0.728>
  translate <0.083, -0.056, 0.000>
 }
  object { 
  JSegment
  scale <0.539, 0.585, 0.486>
  rotate <106, 106, 106>
  translate <-1.099, 10.205, -0.712>
 }
 object{ Connect(<-1.12, 10.15, -0.73>, 0.27, <-1.10, 10.20, -0.71>, 0.27)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.76E4, 1.76E4, 1.76E4>
  translate <-1.099, 10.205, -0.712>
  translate <0.062, -0.078, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.774E4, 1.77E4, 1.77E4>
  translate <-1.076, 10.263, -0.697>
  translate <0.037, -0.093, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.788E4, 1.79E4, 1.79E4>
  translate <-1.054, 10.321, -0.681>
  translate <0.007, -0.100, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.801E4, 1.8E4, 1.8E4>
  translate <-1.033, 10.378, -0.664>
  translate <-0.022, -0.097, 0.000>
 }
  object { 
  JSegment2
  scale <0.525, 0.572, 0.470>
  rotate <109, 109, 109>
  translate <-1.014, 10.436, -0.648>
 }
 object{ Connect(<-1.03, 10.38, -0.66>, 0.26, <-1.01, 10.44, -0.65>, 0.26)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.815E4, 1.82E4, 1.82E4>
  translate <-1.014, 10.436, -0.648>
  translate <-0.050, -0.087, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.829E4, 1.83E4, 1.83E4>
  translate <-0.997, 10.493, -0.631>
  translate <-0.073, -0.068, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.843E4, 1.84E4, 1.84E4>
  translate <-0.981, 10.549, -0.614>
  translate <-0.090, -0.043, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.856E4, 1.86E4, 1.86E4>
  translate <-0.967, 10.606, -0.597>
  translate <-0.099, -0.015, 0.000>
 }
  object { 
  JSegment
  scale <0.511, 0.560, 0.454>
  rotate <112, 112, 112>
  translate <-0.954, 10.662, -0.580>
 }
 object{ Connect(<-0.97, 10.61, -0.60>, 0.26, <-0.95, 10.66, -0.58>, 0.26)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.87E4, 1.87E4, 1.87E4>
  translate <-0.954, 10.662, -0.580>
  translate <-0.099, 0.015, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.884E4, 1.88E4, 1.88E4>
  translate <-0.943, 10.717, -0.563>
  translate <-0.090, 0.043, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.898E4, 1.9E4, 1.9E4>
  translate <-0.934, 10.772, -0.545>
  translate <-0.073, 0.068, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.911E4, 1.91E4, 1.91E4>
  translate <-0.925, 10.827, -0.528>
  translate <-0.050, 0.087, 0.000>
 }
  object { 
  JSegment2
  scale <0.496, 0.547, 0.438>
  rotate <115, 115, 115>
  translate <-0.919, 10.882, -0.510>
 }
 object{ Connect(<-0.93, 10.83, -0.53>, 0.25, <-0.92, 10.88, -0.51>, 0.25)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.925E4, 1.93E4, 1.93E4>
  translate <-0.919, 10.882, -0.510>
  translate <-0.022, 0.097, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.939E4, 1.94E4, 1.94E4>
  translate <-0.914, 10.937, -0.493>
  translate <0.007, 0.100, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.953E4, 1.95E4, 1.95E4>
  translate <-0.910, 10.991, -0.476>
  translate <0.037, 0.093, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.966E4, 1.97E4, 1.97E4>
  translate <-0.908, 11.044, -0.458>
  translate <0.062, 0.078, 0.000>
 }
  object { 
  JSegment
  scale <0.482, 0.534, 0.422>
  rotate <119, 119, 119>
  translate <-0.907, 11.098, -0.441>
 }
 object{ Connect(<-0.91, 11.04, -0.46>, 0.24, <-0.91, 11.10, -0.44>, 0.24)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.98E4, 1.98E4, 1.98E4>
  translate <-0.907, 11.098, -0.441>
  translate <0.083, 0.056, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <1.994E4, 1.99E4, 1.99E4>
  translate <-0.908, 11.151, -0.424>
  translate <0.096, 0.029, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <2.008E4, 2.01E4, 2.01E4>
  translate <-0.910, 11.203, -0.407>
  translate <0.100, 0.000, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <2.021E4, 2.02E4, 2.02E4>
  translate <-0.914, 11.256, -0.391>
  translate <0.096, -0.029, 0.000>
 }
  object { 
  JSegment2
  scale <0.468, 0.521, 0.406>
  rotate <122, 122, 122>
  translate <-0.919, 11.308, -0.374>
 }
 object{ Connect(<-0.91, 11.26, -0.39>, 0.24, <-0.92, 11.31, -0.37>, 0.23)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <2.035E4, 2.04E4, 2.04E4>
  translate <-0.919, 11.308, -0.374>
  translate <0.083, -0.056, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <2.049E4, 2.05E4, 2.05E4>
  translate <-0.925, 11.360, -0.358>
  translate <0.062, -0.078, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <2.063E4, 2.06E4, 2.06E4>
  translate <-0.933, 11.411, -0.342>
  translate <0.037, -0.093, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <2.076E4, 2.08E4, 2.08E4>
  translate <-0.941, 11.462, -0.326>
  translate <0.007, -0.100, 0.000>
 }
  object { 
  JSegment
  scale <0.454, 0.508, 0.390>
  rotate <125, 125, 125>
  translate <-0.951, 11.513, -0.311>
 }
 object{ Connect(<-0.94, 11.46, -0.33>, 0.23, <-0.95, 11.51, -0.31>, 0.23)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <2.09E4, 2.09E4, 2.09E4>
  translate <-0.951, 11.513, -0.311>
  translate <-0.022, -0.097, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <2.104E4, 2.1E4, 2.1E4>
  translate <-0.962, 11.564, -0.296>
  translate <-0.050, -0.087, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <2.118E4, 2.12E4, 2.12E4>
  translate <-0.975, 11.614, -0.281>
  translate <-0.073, -0.068, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <2.131E4, 2.13E4, 2.13E4>
  translate <-0.988, 11.664, -0.267>
  translate <-0.090, -0.043, 0.000>
 }
  object { 
  JSegment2
  scale <0.439, 0.495, 0.374>
  rotate <128, 128, 128>
  translate <-1.003, 11.713, -0.253>
 }
 object{ Connect(<-0.99, 11.66, -0.27>, 0.22, <-1.00, 11.71, -0.25>, 0.22)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <2.145E4, 2.15E4, 2.15E4>
  translate <-1.003, 11.713, -0.253>
  translate <-0.099, -0.015, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <2.159E4, 2.16E4, 2.16E4>
  translate <-1.018, 11.763, -0.240>
  translate <-0.099, 0.015, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <2.173E4, 2.17E4, 2.17E4>
  translate <-1.035, 11.811, -0.227>
  translate <-0.090, 0.043, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <2.186E4, 2.19E4, 2.19E4>
  translate <-1.052, 11.860, -0.214>
  translate <-0.073, 0.068, 0.000>
 }
  object { 
  JSegment
  scale <0.425, 0.482, 0.358>
  rotate <132, 132, 132>
  translate <-1.070, 11.908, -0.202>
 }
 object{ Connect(<-1.05, 11.86, -0.21>, 0.21, <-1.07, 11.91, -0.20>, 0.21)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <2.2E4, 2.2E4, 2.2E4>
  translate <-1.070, 11.908, -0.202>
  translate <-0.050, 0.087, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <2.214E4, 2.21E4, 2.21E4>
  translate <-1.089, 11.956, -0.190>
  translate <-0.022, 0.097, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <2.228E4, 2.23E4, 2.23E4>
  translate <-1.109, 12.004, -0.179>
  translate <0.007, 0.100, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <2.241E4, 2.24E4, 2.24E4>
  translate <-1.130, 12.051, -0.168>
  translate <0.037, 0.093, 0.000>
 }
  object { 
  JSegment2
  scale <0.411, 0.470, 0.342>
  rotate <135, 135, 135>
  translate <-1.151, 12.098, -0.158>
 }
 object{ Connect(<-1.13, 12.05, -0.17>, 0.21, <-1.15, 12.10, -0.16>, 0.21)}
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <2.255E4, 2.26E4, 2.26E4>
  translate <-1.151, 12.098, -0.158>
  translate <0.062, 0.078, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <2.269E4, 2.27E4, 2.27E4>
  translate <-1.173, 12.145, -0.148>
  translate <0.083, 0.056, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <2.283E4, 2.28E4, 2.28E4>
  translate <-1.195, 12.191, -0.139>
  translate <0.096, 0.029, 0.000>
 }
  object { HelixObj
  texture {pigment { granite  color_map {  [0.000 color rgb <0.550, 0.090, 0.090 > ] [1.000 color rgb <1.000, 0.000, 0.000 > ]} turbulence 3 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  rotate <2.296E4, 2.3E4, 2.3E4>
  translate <-1.218, 12.237, -0.130>
  translate <0.100, 0.000, 0.000>
 }
 }
 
#declare JWorm =
  object { W0
  scale <1.000, 1.000, 1.000>
  rotate <0, 90, 0>
  translate <0.000, 0.000, 0.000>
 }
 
 #declare Worm1 = object {
  JWorm
   }
 
#declare WheelWorm =  union {
 object {
 Worm1
  scale <0.991, 0.982, 1.010>
  scale <1.000, 1.000, 1.000>
  rotate <-2, -6, 4>
  rotate <0, 0, 0>
  rotate <0, 0, 0>
  translate <0.000, 0.000, 0.000>
 }
 object {
 Worm1
  scale <0.985, 0.959, 0.978>
  scale <1.000, 1.000, 1.000>
  rotate <8, -0, 6>
  rotate <0, 0, 51>
  rotate <0, 1, 0>
  translate <0.000, 0.000, 0.000>
 }
 object {
 Worm1
  scale <0.958, 0.978, 0.966>
  scale <1.000, 1.000, 1.000>
  rotate <-6, -6, -2>
  rotate <0, 0, 101>
  rotate <0, 2, 0>
  translate <0.000, 0.000, 0.000>
 }
 object {
 Worm1
  scale <0.955, 0.979, 0.972>
  scale <1.000, 1.000, 1.000>
  rotate <-6, 6, -3>
  rotate <0, 0, 152>
  rotate <0, 3, 0>
  translate <0.000, 0.000, 0.000>
 }
 object {
 Worm1
  scale <0.967, 0.995, 0.952>
  scale <1.000, 1.000, 1.000>
  rotate <-1, -7, -5>
  rotate <0, 0, 202>
  rotate <0, 5, 0>
  translate <0.000, 0.000, 0.000>
 }
 object {
 Worm1
  scale <1.036, 1.043, 1.017>
  scale <1.000, 1.000, 1.000>
  rotate <-1, -6, -2>
  rotate <0, 0, 253>
  rotate <0, 6, 0>
  translate <0.000, 0.000, 0.000>
 }
 object {
 Worm1
  scale <0.960, 0.989, 1.035>
  scale <1.000, 1.000, 1.000>
  rotate <7, 5, 3>
  rotate <0, 0, 303>
  rotate <0, 7, 0>
  translate <0.000, 0.000, 0.000>
 }
 object {
 Worm1
  scale <0.962, 0.980, 1.034>
  scale <1.000, 1.000, 1.000>
  rotate <7, 9, -10>
  rotate <0, 0, 354>
  rotate <0, 8, 0>
  translate <0.000, 0.000, 0.000>
 }
 }
 
object {WheelWorm
  texture {pigment { agate agate_turb 3 color_map { [0.000 color rgb <0.890, 0.470, 0.200 > ] [1.000 color rgb <0.290, 0.460, 0.430 > ]} lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 0.5} normal { bumps 0.5 turbulence 5 lambda 2 omega 0.5 octaves 3 frequency 1 phase 0 scale 1 } finish { ambient rgb <0.1, 0.1, 0.1> diffuse 0.7 brilliance 2 phong 0.4 phong_size 60 specular 1 roughness 0.001 reflection rgb <0.3, 0.3, 0.3> } scale <1,1,1> rotate <0,0,0>}
  scale <1, 1, 1>
  rotate <0, 0, 0>
  translate <0, 0, 0>
 }
 
//----------------Background--------------------------
sky_sphere {
  pigment {
   gradient y
     color_map { [0 color rgb <0.650, 0.700, 0.800> ]
                 [1 color rgb <0.850, 0.700, 0.800> ]
     }
  }
  pigment {  // high stratus clouds
    wrinkles
      turbulence 0.7
      octaves 6
      lambda 5
      omega .3
    color_map {
      [0 color rgbt <1, 1, 1, 1>]
      [.5 color rgbt <.98, .99, .99, .8>]
      [1 color rgbt <1, 1, 1, 1>]
    }
    scale <.8, .1, .8>
  }
 }
 
