
// Sun   
light_source {  
   <-domeradius*1.6,domeradius*1.6,domeradius*1.6>
   color rgb <1,1,1>
} 
// Exterior camera light   
light_source {  
   <domeradius*1.6,domeradius*1.6,domeradius*1.6>
   color rgb <1,0.9,0.9>*0.35
} 
// Exterior back light   
light_source {  
   <-domeradius*1.6,-domeradius*1.6,domeradius*0.25>
   color rgb <0,0,1>*0.45
} 


background {
   color rgb <0,0,0.2>
}

// Ground plane
box {<-20000,-20000,-1>,<20000,20000,0>
   texture {
      pigment {rgb <1,1,1>*0.25}
   }
} 

union {
	#declare ix = -20000;
	#while (ix < 20001)
		cylinder { <20000,ix,0>, <-20000,ix,0>, 30*3 }
      cylinder { <ix,20000,0>, <ix,-20000,0>, 30*3 }
		#declare ix = ix + 1000;
	#end
	texture {
      pigment {
         color rgb <0.1,0.4,0.1>
		}
	}
}

// Projection sphere
difference {
   sphere {
      <0,0,0>, domeradius
      hollow
      no_shadow
      double_illuminate
      texture {
         pigment { color rgbt <1,1,1,0.5> }
      }
      texture {
         pigment {
            image_map {
               tga "polargrid.tga"
               map_type 1
               interpolate 2
               once
            }
         }
         rotate <90,0,0>
      }
      translate <0,0,domezshift>
   }
   plane {
      <0,0,1>, 0
		texture {
			pigment { color rgb <0,0,0> }
		}
   }
}

/*
// Define an arrow along the x axis
#declare RR = 20;
#declare anarrow = union {
   cylinder { <0,0,0>, <1000,0,0>, RR }
   cone { <1000,0,0>, 2*RR, <1100,0,0>, 0 }
}

// X axis
object {
   anarrow
   translate <100,0,0>
   texture {
      pigment { color rgb <1,0,0> }
      finish { ambient 0.2 diffuse 0.5 specular 0.4 }
   }
}

// Y axis
object {
   anarrow
   rotate <0,0,90>
   translate <0,100,0>
   texture {
      pigment { color rgb <0,1,0> }
      finish { ambient 0.2 diffuse 0.5 specular 0.4 }
   }
}

// Z axis
object {
   anarrow
   rotate <0,-90,0>
   translate <0,0,100>
   texture {
      pigment { color rgb <0,0,1> }
      finish { ambient 0.2 diffuse 0.5 specular 0.4 }
   }
}
*/
