/*
#include "rad_def.inc"
global_settings {
   radiosity {
      Rad_Settings(Radiosity_2Bounce, off, off)
   }
}
*/
//#default {finish {ambient 0 diffuse 0}}

// All units in meters

// Projector and image properties
#declare nprojector = 5;
#declare projectorposition = <0,3000,300>;
#declare projectorangle = 25;
#declare iwidth = 1000;
#declare aspect = 4/3.0;
#declare throw = 1.0;

// Dome attributes
#declare domeradius = 6000;
#declare domezshift = 5000;

#include "misc.inc"

#local C = 4; //#local C = clock;
#switch (C)
#case (4)                              // Exterior, perspective
	#declare VP = <0,-domeradius+1,2000>;
	#declare VD = <0,1,0>;
        cylinder {<0,0,0>,<0,0,11000>,350 translate <7000,-7000,0> pigment{rgb <1,1,1>} }
        cylinder {<0,0,0>,<0,0,11000>,350 translate <5000,-7000,0> pigment{rgb <1,1,1>} }
        cylinder {<0,0,0>,<0,0,11000>,350 translate <3000,-7000,0> pigment{rgb <1,1,1>} }
        cylinder {<0,0,0>,<0,0,11000>,350 translate <1000,-7000,0> pigment{rgb <1,1,1>} }
        cylinder {<0,0,0>,<0,0,11000>,350 translate <-1000,-7000,0> pigment{rgb <1,1,1>} }
        cylinder {<0,0,0>,<0,0,11000>,350 translate <-3000,-7000,0> pigment{rgb <1,1,1>} }
        cylinder {<0,0,0>,<0,0,11000>,350 translate <-5000,-7000,0> pigment{rgb <1,1,1>} }
        cylinder {<0,0,0>,<0,0,11000>,350 translate <-7000,-7000,0> pigment{rgb <1,1,1>} }
        cylinder {<0,0,0>,<0,0,11000>,350 translate <-7000,-5000,0> pigment{rgb <1,1,1>} }
        cylinder {<0,0,0>,<0,0,11000>,350 translate <-7000,-3000,0> pigment{rgb <1,1,1>} }
        cylinder {<0,0,0>,<0,0,11000>,350 translate <-7000,-1000,0> pigment{rgb <1,1,1>} }
        cylinder {<0,0,0>,<0,0,11000>,350 translate <-7000,1000,0> pigment{rgb <1,1,1>} }
        cylinder {<0,0,0>,<0,0,11000>,350 translate <-7000,3000,0> pigment{rgb <1,1,1>} }
        cylinder {<0,0,0>,<0,0,11000>,350 translate <-7000,5000,0> pigment{rgb <1,1,1>} }
        cylinder {<0,0,0>,<0,0,11000>,350 translate <-7000,7000,0> pigment{rgb <1,1,1>} }
	camera {
	   perspective
	   location domeradius*1.5
	   up y
	   right image_width*x/image_height
	   angle 90
	   sky <0,0,1>
	   look_at <0,0,domezshift>
	}
#break
#case (3)                              // Side view, parallel
	#declare VP = <0,0,domeradius/2+domezshift/2>;
	#declare VD = <0,-1,0>;
	camera {
   	orthographic
   	location VP
   	up 2.5*domeradius*z
   	right 2.5*domeradius*x
   	sky <0,0,1>
   	look_at VP + VD
	}
#break
#case (2)                              // Interior, perspective
	#declare VP = <0,-domeradius+1,2000>;
	#declare VD = <0,1,0>;
	camera {
	   perspective
	   location VP
	   up y
	   right image_width*x/image_height
	   angle 90
	   sky <0,0,1>
	   look_at VP + VD
	}
#break
#case (1)                              // Interior spherical projection
	#declare VP = <0,0,domeradius/2 + domezshift/2>;
	#declare VD = <1,0,0>;
	camera {
	   spherical
	   location VP
	   up y
	   right image_width*x/image_height
	   angle 360
	   sky <0,0,1>
	   look_at VP + VD
	}
#break
#case (0)                              // Top view, parallel
	#declare VP = <0,0,2.5*(domeradius+domezshift)>;
	#declare VD = <0,0,-1>;
	camera {
	   orthographic
	   location VP
	   up 2.5*domeradius*y
	   right 2.5*domeradius*x
	   sky <0,1,0>
	   look_at VP + VD
	}
#break
#end

// Projector Frustrum, onaxis
#declare pscale = 0.5;
#declare dy = throw * iwidth; // Distance away of projection plane
#declare p1 = pscale * <-0.5*iwidth,-dy,-0.5*iwidth/aspect>;
#declare p2 = pscale * < 0.5*iwidth,-dy,-0.5*iwidth/aspect>;
#declare p3 = pscale * < 0.5*iwidth,-dy, 0.5*iwidth/aspect>;
#declare p4 = pscale * <-0.5*iwidth,-dy, 0.5*iwidth/aspect>;

#declare ip = 0;
#while (ip < nprojector)

	// Light source
	light_source {
		projectorposition
   	color rgb <1,1,1>
		rotate <0,0,ip*360/nprojector>
	}

	// Plane with image to be projected
	polygon {
		5, p1, p2, p3, p4, p1
		texture {
			pigment {
				image_map {
					tga concat("projectorimage",str(ip+1,0,0),".tga")
					map_type 0
					interpolate 2
					once
	   			filter all 1
				   transmit all 0
				}
	         rotate <90,0,0>
	         translate <-0.5,0,-0.5>
	         scale pscale*<iwidth,1,iwidth/aspect>
			}
		}
		rotate <-projectorangle,0,0>
		translate projectorposition
		rotate <0,0,ip*360/nprojector>
	}

	// Projector frustum
	union {
		polygon { 4, <0,0,0>, p1, p2, <0,0,0> }
		polygon { 4, <0,0,0>, p2, p3, <0,0,0> }
		polygon { 4, <0,0,0>, p3, p4, <0,0,0> }
		polygon { 4, <0,0,0>, p4, p1, <0,0,0> } 
		translate <0,0.01,-0.001>
		rotate <-projectorangle,0,0>
		translate projectorposition
		texture {
			pigment { color rgb <1.0,1.0,1.0> }
			finish { ambient 0.2 diffuse 0.5 specular 0 }
		}
		rotate <0,0,ip*360/nprojector>
	}

	#declare ip = ip + 1;
#end

