//  Persistance of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 4 lights, 20 materials and 479 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 09/18/1999    (18.09.1999)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment


// Scene Includes

#include "C:\programs\povray31\scenes\gazeboa.inc"

// End Scene Includes

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            400
    distance_maximum 2.5
    error_bound      0.35
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.02
    nearest_count    8
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

fog {
  fog_type 2    // Ground Fog
  distance     10.0
  color <0.6,0.6,0.6,0.0,0.0>
  up           <0,0,1>
  fog_offset   0.0
  fog_alt      5.0
}

camera {  //  Camera StdCam
  location  <    159.973,       0.000,     121.173>
  direction <        0.0,         0.0,      2.1964> // Aperture is 0.45 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <    -53.586,       0.000,      82.386>
}

//    Other cameras are commented out.
/*
camera {  //  Camera TablePotFlowerCamera
  location  <    -87.146,     -61.155,      93.894>
  direction <        0.0,         0.0,      2.4880> // Aperture is 0.40 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <   -134.315,     -14.586,      60.454>
}

*/

/*
camera {  //  Camera TableLegsCam
  location  <    -76.495,     -35.254,      62.945>
  direction <        0.0,         0.0,      2.4880> // Aperture is 0.40 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <   -127.035,     -10.464,      35.412>
}

*/

/*
camera {  //  Camera SeatCam
  location  <    -38.612,    -113.079,     105.448>
  direction <        0.0,         0.0,      2.4880> // Aperture is 0.40 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <   -109.729,     -24.354,      31.538>
}

*/

/*
camera {  //  Camera BigPotCam
  location  <    -68.093,      73.641,     128.623>
  direction <        0.0,         0.0,      2.4880> // Aperture is 0.40 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <   -122.080,      36.579,      40.086>
}

*/

/*
camera {  //  Camera SpotCam001
  location  <   -745.274,    -231.112,     321.145> // Attached to SunSpotLight
  direction <        0.0,         0.0,      1.7354> // Aperture is 0.56 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <   -685.043,    -208.982,     292.346> // Following SunSpotLight
}

*/

/*
camera {  //  Camera SandalCam
  location  <   -106.222,      53.443,      53.528>
  direction <        0.0,         0.0,      2.4880> // Aperture is 0.40 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <   -104.793,     -38.545,      -2.539>
}

*/

//
// *******  L I G H T S *******
//

light_source {   // GazeboTopLight
  <-126.496, 1.518, 143.035>
  color rgb <0.741, 1.000, 1.000>
}

light_source {   // Spotlight SunSpotLight
  <-745.274, -231.112, 321.145>
  color rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <-624.812, -186.853, 263.548>
    falloff    16.072  // outer radius (in deg)
    radius     12.599  // inner radius
    tightness  5.737
}

light_source { // TopLight3
  <49.021, -244.405, 359.736>
  color rgb <0.750, 0.750, 0.750>
  area_light <-40.307, 39.744, -82.831>, <-70.440, -71.438, 0.000>, 3, 3
  adaptive 1
  jitter
  shadowless
}


light_source { // TopLight4
  <40.144, 212.785, 359.736>
  color rgb <0.500, 0.500, 0.500>
  area_light <-43.663, -36.024, -82.831>, <63.847, -77.387, 0.000>, 3, 3
  adaptive 1
  jitter
  shadowless
}



//
// ********  MATERIALS  *******
//

#include "gazebo.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

#declare FrontSandleTreadCyls = union {
  cylinder { // SandleTreadCyl
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.670642>
    rotate -90.0*y
    translate  <-109.872547, 9.923904, 20.49721>
  }
  cylinder { // SandleTreadCyl1
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.670642>
    rotate -90.0*y
    translate  <-109.872547, 8.414208, 20.49721>
  }
  cylinder { // SandleTreadCyl2
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.670642>
    rotate -90.0*y
    translate  <-109.872547, 7.036316, 20.49721>
  }
}
#declare RearSandleTreadCyls = union {
  cylinder { // SandleTreadCyl3
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.670642>
    rotate -90.0*y
    translate  <-109.872547, 1.472833, 20.49721>
  }
  cylinder { // SandleTreadCyl4
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.670642>
    rotate -90.0*y
    translate  <-109.872547, -0.036863, 20.49721>
  }
}
#declare SandleTreadUni = union {
  object { FrontSandleTreadCyls }
  object { RearSandleTreadCyls }
}
#declare LeftSandal = union {
  box { // SandalCube
    <-1, -1, -1>, <1, 1, 1>
    scale <1.960653, 5.803267, 1.0>
    translate  <-111.697515, 4.831488, 22.058343>
  }
  object { SandleTreadUni }
  torus { // ThongTorus
    1.79, 0.21  rotate -x*90
    material {
      Granit_DO
    }
    rotate -90.0*x
    translate  <-111.683732, 8.273649, 22.879203>
  }
  material {
    DMFLightOak_Moray
  }
  translate  -0.367438*z
}
#declare FrontSandleTreadCyls1 = union {
  cylinder { // SandleTreadCyl5
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.670642>
    rotate -90.0*y
    translate  <-109.872547, 9.923904, 20.49721>
  }
  cylinder { // SandleTreadCyl6
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.670642>
    rotate -90.0*y
    translate  <-109.872547, 8.414208, 20.49721>
  }
  cylinder { // SandleTreadCyl7
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.670642>
    rotate -90.0*y
    translate  <-109.872547, 7.036316, 20.49721>
  }
}
#declare RearSandleTreadCyls1 = union {
  cylinder { // SandleTreadCyl8
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.670642>
    rotate -90.0*y
    translate  <-109.872547, 1.472833, 20.49721>
  }
  cylinder { // SandleTreadCyl9
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.670642>
    rotate -90.0*y
    translate  <-109.872547, -0.036863, 20.49721>
  }
}
#declare SandleTreadUni1 = union {
  object { FrontSandleTreadCyls1 }
  object { RearSandleTreadCyls1 }
}
#declare RightSandal = union {
  box { // SandalCube1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.960653, 5.803267, 1.0>
    translate  <-111.697515, 4.831488, 22.058343>
  }
  object { SandleTreadUni1 }
  torus { // ThongTorus1
    1.79, 0.21  rotate -x*90
    material {
      Granit_DO
    }
    rotate -90.0*x
    translate  <-111.683732, 8.273649, 22.879203>
  }
  material {
    DMFLightOak_Moray
  }
  rotate -9.927526*z
  translate  <8.580981, -23.847737, -0.367438>
}
union { // Sandals
  object { LeftSandal }
  object { RightSandal }
}


#declare StaffMetalInsetsDiffCuts = union {
  cylinder { // StaffCyl1
    <0,0,1>, <0,0,0>, 1 
    scale <1.25, 1.25, 6.102665>
    translate  <-97.044882, -28.856768, 60.026401>
  }
  cylinder { // StaffCyl4
    <0,0,1>, <0,0,0>, 1 
    scale <1.25, 1.25, 6.102665>
    translate  <-97.044882, -28.856768, 25.916264>
  }
}
#declare StaffTopTorusCuts = union {
  torus { // StaffTopTorusCut
    1.425, 0.575  rotate -x*90
    translate  <-97.046637, -28.856588, 70.633668>
  }
  torus { // StaffTopTorusCut1
    1.425, 0.575  rotate -x*90
    translate  <-97.046637, -28.856588, 69.428294>
  }
  torus { // StaffTopTorusCut2
    1.425, 0.575  rotate -x*90
    translate  <-97.046637, -28.856588, 68.255497>
  }
  material {
    EMBWood1_Moray
  }
}
#declare StaffCuts = union {
  object { StaffMetalInsetsDiffCuts }
  object { StaffTopTorusCuts }
}
#declare StaffDiff = difference {
  cylinder { // StaffCyl
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 53.296497>
    translate  <-97.044882, -28.856768, 19.635284>
  }
  object { StaffCuts }
  material {
    DMFWood2_Moray
  }
}
#declare TopMetalBandInt = intersection {
  cylinder { // StaffCyl2
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 53.296497>
    translate  <-97.044882, -28.856768, 19.635284>
  }
  cylinder { // StaffCyl3
    <0,0,1>, <0,0,0>, 1 
    scale <1.25, 1.25, 6.102665>
    translate  <-97.044882, -28.856768, 60.026401>
  }
  material {
    ki_Gold
  }
}
#declare TopMetalBandInt1 = intersection {
  cylinder { // StaffCyl5
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 53.296497>
    translate  <-97.044882, -28.856768, 19.635284>
  }
  cylinder { // StaffCyl6
    <0,0,1>, <0,0,0>, 1 
    scale <1.25, 1.25, 6.102665>
    translate  <-97.044882, -28.856768, 25.916264>
  }
  material {
    ki_Gold
  }
}
#declare StaffInts = union {
  object { TopMetalBandInt }
  object { TopMetalBandInt1 }
}
union { // Staff
  object { StaffDiff }
  object { StaffInts }
  rotate <-170.308334, -165.705444, 177.585403>
  translate  <6.317035, 4.124068, 30.236092>
}






#declare GroundPoolDiff = difference {
  box { // GroundCube
    <-1, -1, -1>, <1, 1, 1>
    scale <686.061218, 305.422058, 26.060759>
    translate  <-450.32315, -12.895565, -16.944417>
  }
  box { // GroundCubeCut
    <-1, -1, -1>, <1, 1, 1>
    scale <552.872253, 229.304367, 26.060759>
    translate  <-506.697826, -12.895565, 10.529791>
  }
  material {
    Pierre12
  }
}
#include "C:\programs\povray31\scenes\waterp.inc"

#declare WaterPlant_Ref = object {
  NONAME
  scale 0.025
  rotate -90.0*y
  translate  <-635.10197, -126.430357, 8.095919>
}
#declare WaterPlant1_Ref = object {
  NONAME
  scale 0.025
  rotate <45.0, -90.0, -180.0>
  translate  <-638.041097, -126.430357, 8.095919>
}
#declare WaterPlant2_Ref = object {
  NONAME
  scale 0.025
  rotate <-45.0, -90.0, -180.0>
  translate  <-640.980224, -138.186864, 8.095919>
}
#declare WaterPlantsCluster = union {
  object { WaterPlant_Ref }
  object { WaterPlant1_Ref }
  object { WaterPlant2_Ref }
  material {
    WaterPlantMaterial
  }
}
#declare WaterPlant3_Ref = object {
  NONAME
  scale 0.025
  rotate -90.0*y
  translate  <-635.10197, -126.430357, 8.095919>
}
#declare WaterPlant4_Ref = object {
  NONAME
  scale 0.025
  rotate <45.0, -90.0, -180.0>
  translate  <-638.041097, -126.430357, 8.095919>
}
#declare WaterPlant5_Ref = object {
  NONAME
  scale 0.025
  rotate <-45.0, -90.0, -180.0>
  translate  <-640.980224, -138.186864, 8.095919>
}
#declare WaterPlantsCluster1 = union {
  object { WaterPlant3_Ref }
  object { WaterPlant4_Ref }
  object { WaterPlant5_Ref }
  material {
    WaterPlantMaterial
  }
  translate  <319.589756, 253.008557, 0.0>
}
#declare WaterPlant6_Ref = object {
  NONAME
  scale 0.025
  rotate -90.0*y
  translate  <-635.10197, -126.430357, 8.095919>
}
#declare WaterPlant7_Ref = object {
  NONAME
  scale 0.025
  rotate <45.0, -90.0, -180.0>
  translate  <-638.041097, -126.430357, 8.095919>
}
#declare WaterPlant8_Ref = object {
  NONAME
  scale 0.025
  rotate <-45.0, -90.0, -180.0>
  translate  <-640.980224, -138.186864, 8.095919>
}
#declare WaterPlantsCluster2 = union {
  object { WaterPlant6_Ref }
  object { WaterPlant7_Ref }
  object { WaterPlant8_Ref }
  material {
    WaterPlantMaterial
  }
  rotate 28.518816*z
  translate  <-329.911348, 543.410492, 0.0>
}
#declare WaterPlant9_Ref = object {
  NONAME
  scale 0.025
  rotate -90.0*y
  translate  <-635.10197, -126.430357, 8.095919>
}
#declare WaterPlant10_Ref = object {
  NONAME
  scale 0.025
  rotate <45.0, -90.0, -180.0>
  translate  <-638.041097, -126.430357, 8.095919>
}
#declare WaterPlant11_Ref = object {
  NONAME
  scale 0.025
  rotate <-45.0, -90.0, -180.0>
  translate  <-640.980224, -138.186864, 8.095919>
}
#declare WaterPlantsCluster3 = union {
  object { WaterPlant9_Ref }
  object { WaterPlant10_Ref }
  object { WaterPlant11_Ref }
  material {
    WaterPlantMaterial
  }
  rotate 82.385506*z
  translate  <-782.688559, 802.586413, 0.0>
}
#declare WaterPlantsClusters = union {
  object { WaterPlantsCluster }
  object { WaterPlantsCluster1 }
  object { WaterPlantsCluster2 }
  object { WaterPlantsCluster3 }
}
#include "C:\programs\povray31\scenes\flower.inc"

#declare Flower_Ref = object {
  X
  material {
    WhiteFlowerMaterial
  }
  scale <0.09, 0.05, 0.05>
  rotate <-90.0, -90.0, 0.0>
  translate  <-511.017347, 139.888372, 2.520917>
}
#declare Flower1_Ref = object {
  X
  material {
    BlueFlowerMaterial
  }
  scale <0.09, 0.05, 0.05>
  rotate <45.0, -90.0, 0.0>
  translate  <-494.705004, 136.39287, 4.201528>
}
#declare Flower2_Ref = object {
  X
  material {
    RedFlowerMaterial
  }
  scale <0.09, 0.05, 0.05>
  rotate <-190.0, -90.0, 0.0>
  translate  <-499.754062, 152.316823, 4.201528>
}
#declare FlowerCluster = union {
  object { Flower_Ref }
  object { Flower1_Ref }
  object { Flower2_Ref }
}
#declare Flower3_Ref = object {
  X
  material {
    WhiteFlowerMaterial
  }
  scale <0.09, 0.05, 0.05>
  rotate <-90.0, -90.0, 0.0>
  translate  <-511.017347, 139.888372, 2.520917>
}
#declare Flower4_Ref = object {
  X
  material {
    BlueFlowerMaterial
  }
  scale <0.09, 0.05, 0.05>
  rotate <45.0, -90.0, 0.0>
  translate  <-494.705004, 136.39287, 4.201528>
}
#declare Flower5_Ref = object {
  X
  material {
    RedFlowerMaterial
  }
  scale <0.09, 0.05, 0.05>
  rotate <-190.0, -90.0, 0.0>
  translate  <-499.754062, 152.316823, 4.201528>
}
#declare FlowerCluster1 = union {
  object { Flower3_Ref }
  object { Flower4_Ref }
  object { Flower5_Ref }
  translate  <-333.560503, -146.574898, 0.0>
}
#declare Flower6_Ref = object {
  X
  material {
    WhiteFlowerMaterial
  }
  scale <0.09, 0.05, 0.05>
  rotate <-90.0, -90.0, 0.0>
  translate  <-511.017347, 139.888372, 2.520917>
}
#declare Flower7_Ref = object {
  X
  material {
    BlueFlowerMaterial
  }
  scale <0.09, 0.05, 0.05>
  rotate <45.0, -90.0, 0.0>
  translate  <-494.705004, 136.39287, 4.201528>
}
#declare Flower8_Ref = object {
  X
  material {
    RedFlowerMaterial
  }
  scale <0.09, 0.05, 0.05>
  rotate <-190.0, -90.0, 0.0>
  translate  <-499.754062, 152.316823, 4.201528>
}
#declare FlowerCluster2 = union {
  object { Flower6_Ref }
  object { Flower7_Ref }
  object { Flower8_Ref }
  translate  <-312.503056, -234.314261, 0.0>
}
#declare Flower9_Ref = object {
  X
  material {
    WhiteFlowerMaterial
  }
  scale <0.09, 0.05, 0.05>
  rotate <-90.0, -90.0, 0.0>
  translate  <-511.017347, 139.888372, 2.520917>
}
#declare Flower10_Ref = object {
  X
  material {
    BlueFlowerMaterial
  }
  scale <0.09, 0.05, 0.05>
  rotate <45.0, -90.0, 0.0>
  translate  <-494.705004, 136.39287, 4.201528>
}
#declare Flower11_Ref = object {
  X
  material {
    RedFlowerMaterial
  }
  scale <0.09, 0.05, 0.05>
  rotate <-190.0, -90.0, 0.0>
  translate  <-499.754062, 152.316823, 4.201528>
}
#declare FlowerCluster3 = union {
  object { Flower9_Ref }
  object { Flower10_Ref }
  object { Flower11_Ref }
  translate  <-519.567955, 28.90383, 0.0>
}
#declare Flower12_Ref = object {
  X
  material {
    WhiteFlowerMaterial
  }
  scale <0.09, 0.05, 0.05>
  rotate <-90.0, -90.0, 0.0>
  translate  <-511.017347, 139.888372, 2.520917>
}
#declare Flower13_Ref = object {
  X
  material {
    BlueFlowerMaterial
  }
  scale <0.09, 0.05, 0.05>
  rotate <45.0, -90.0, 0.0>
  translate  <-494.705004, 136.39287, 4.201528>
}
#declare Flower14_Ref = object {
  X
  material {
    RedFlowerMaterial
  }
  scale <0.09, 0.05, 0.05>
  rotate <-190.0, -90.0, 0.0>
  translate  <-499.754062, 152.316823, 4.201528>
}
#declare FlowerCluster4 = union {
  object { Flower12_Ref }
  object { Flower13_Ref }
  object { Flower14_Ref }
  translate  <-480.962635, -283.448305, 0.0>
}
#declare Flower15_Ref = object {
  X
  material {
    WhiteFlowerMaterial
  }
  scale <0.09, 0.05, 0.05>
  rotate <-90.0, -90.0, 0.0>
  translate  <-511.017347, 139.888372, 2.520917>
}
#declare Flower16_Ref = object {
  X
  material {
    BlueFlowerMaterial
  }
  scale <0.09, 0.05, 0.05>
  rotate <45.0, -90.0, 0.0>
  translate  <-494.705004, 136.39287, 4.201528>
}
#declare Flower17_Ref = object {
  X
  material {
    RedFlowerMaterial
  }
  scale <0.09, 0.05, 0.05>
  rotate <-190.0, -90.0, 0.0>
  translate  <-499.754062, 152.316823, 4.201528>
}
#declare FlowerCluster5 = union {
  object { Flower15_Ref }
  object { Flower16_Ref }
  object { Flower17_Ref }
  translate  <30.828467, -223.237587, 0.0>
}
#declare FlowerClusters = union {
  object { FlowerCluster }
  object { FlowerCluster1 }
  object { FlowerCluster2 }
  object { FlowerCluster3 }
  object { FlowerCluster4 }
  object { FlowerCluster5 }
}
#declare WaterPlants = union {
  object { WaterPlantsClusters }
  object { FlowerClusters }
}
#declare TreeBowl = lathe {
  quadratic_spline
  13  // control points
  <0.055944, -1.16317>,
  <0.053613, -1.141026>,
  <0.69819, -1.074197>,
  <1.218462, -0.847226>,
  <1.310532, -0.047608>,
  <1.0908, 0.194105>,
  <0.848449, 0.160879>,
  <0.874225, 0.469224>,
  <1.132706, 0.397816>,
  <1.382631, 0.437373>,
  <1.55711, 0.70979>,
  <0.755043, 0.860641>,
  <0.755245, 0.708625>
  rotate <90,0,90>
  material {
    Tx_3
  }
  scale 13.925369
  translate  <-175.213388, -77.916742, 8.417854>
}
union { // GroundPool
  object { GroundPoolDiff }
  box { // WaterSurface
    <-1, -1, -1>, <1, 1, 1>
    material {
      WaterSurfaceMaterial
    }
    scale <542.939819, 230.410049, 10.169115>
    translate  <-516.770419, -12.895565, -2.633642>
  }
  object { WaterPlants }
  object { TreeBowl }
  material {
    WaterSurfaceMaterial
  }
}


#declare FrontVertSeatLegs = union {
  cylinder { // SeatLeg
    <0,0,1>, <0,0,0>, 1 
    scale <1.349008, 1.349008, 10.888035>
    translate  <-114.596509, -11.968383, 32.303345>
  }
  cylinder { // SeatLeg1
    <0,0,1>, <0,0,0>, 1 
    scale <1.349008, 1.349008, 10.888035>
    translate  <-101.968382, -11.968383, 32.303345>
  }
}
#declare BottomHorizSeatLegs = union {
  cylinder { // SeatLeg2
    <0,0,1>, <0,0,0>, 1 
    scale <1.349008, 1.349008, 22.284149>
    rotate -90.0*x
    translate  <-114.596509, -34.760611, 21.110563>
  }
  cylinder { // SeatLeg3
    <0,0,1>, <0,0,0>, 1 
    scale <1.349008, 1.349008, 22.284149>
    rotate -90.0*x
    translate  <-101.96938, -34.760611, 21.110563>
  }
}
#declare BackVertSeatLegs = union {
  cylinder { // SeatLeg4
    <0,0,1>, <0,0,0>, 1 
    scale <1.349008, 1.349008, 21.281334>
    translate  <-114.596509, -33.498598, 21.881075>
  }
  cylinder { // SeatLeg5
    <0,0,1>, <0,0,0>, 1 
    scale <1.349008, 1.349008, 21.28133>
    translate  <-101.968382, -33.498598, 21.881075>
  }
}
#declare TopHorizSeatLegs = union {
  cylinder { // SeatLeg6
    <0,0,1>, <0,0,0>, 1 
    scale <1.349008, 1.349008, 23.330341>
    rotate -90.0*x
    translate  <-114.596509, -34.760611, 21.910047>
  }
  cylinder { // SeatLeg7
    <0,0,1>, <0,0,0>, 1 
    scale <1.349008, 1.349008, 23.330339>
    rotate -90.0*x
    translate  <-101.96938, -34.760611, 21.91005>
  }
  translate  20.786596*z
}
#declare TopBackSpheres = union {
  sphere { // SeatConnectorSphere
    <0,0,0>,1
    scale 1.5
    translate  <-114.54261, -33.832299, 42.812741>
  }
  sphere { // SeatConnectorSphere1
    <0,0,0>,1
    scale 1.5
    translate  <-101.916634, -33.832299, 42.812741>
  }
}
#declare BottomFrontSpheres = union {
  sphere { // SeatConnectorSphere2
    <0,0,0>,1
    scale 1.5
    translate  <-101.916634, -13.43154, 21.145391>
  }
  sphere { // SeatConnectorSphere3
    <0,0,0>,1
    scale 1.5
    translate  <-114.645313, -13.43154, 21.145391>
  }
}
#declare BottomBackSpheres = union {
  sphere { // SeatConnectorSphere4
    <0,0,0>,1
    scale 1.5
    translate  <-114.54261, -33.832299, 20.954903>
  }
  sphere { // SeatConnectorSphere5
    <0,0,0>,1
    scale 1.5
    translate  <-101.916634, -33.832299, 20.9549>
  }
}
#declare TopFrontSpheres = union {
  sphere { // SeatConnectorSphere6
    <0,0,0>,1
    scale 1.5
    translate  <-101.916634, -12.210981, 42.78019>
  }
  sphere { // SeatConnectorSphere7
    <0,0,0>,1
    scale 1.5
    translate  <-114.645313, -12.2109, 42.78019>
  }
}
#declare SeatConnectorSpheres = union {
  object { TopBackSpheres }
  object { BottomFrontSpheres }
  object { BottomBackSpheres }
  object { TopFrontSpheres }
}
#declare BottomConnectorLegs = union {
  cylinder { // SeatLeg8
    <0,0,1>, <0,0,0>, 1 
    scale <1.349008, 1.349008, 13.04278>
    rotate <-90.0, -0.0, -90.0>
    translate  <-114.596509, -13.313659, 21.110563>
  }
  cylinder { // SeatLeg9
    <0,0,1>, <0,0,0>, 1 
    scale <1.349008, 1.349008, 13.04278>
    rotate <-90.0, -0.0, -90.0>
    translate  <-114.596509, -33.540053, 21.110563>
  }
}
#declare TopConnectorLegs = union {
  cylinder { // SeatLeg10
    <0,0,1>, <0,0,0>, 1 
    scale <1.349008, 1.349008, 13.04278>
    rotate <-90.0, -0.0, -90.0>
    translate  <-114.596509, -12.267466, 42.522323>
  }
  cylinder { // SeatLeg11
    <0,0,1>, <0,0,0>, 1 
    scale <1.349008, 1.349008, 13.04278>
    rotate <-90.0, -0.0, -90.0>
    translate  <-114.596509, -33.540053, 42.522323>
  }
}
#declare ConnectorLegs = union {
  object { BottomConnectorLegs }
  object { TopConnectorLegs }
}
#declare SeatLegs = union {
  object { FrontVertSeatLegs }
  object { BottomHorizSeatLegs }
  object { BackVertSeatLegs }
  object { TopHorizSeatLegs }
  object { SeatConnectorSpheres }
  object { ConnectorLegs }
}
#declare TopBackSpheres1 = union {
  sphere { // SeatConnectorSphere8
    <0,0,0>,1
    scale 1.5
    translate  <-114.54261, -39.178589, 69.875315>
  }
  sphere { // SeatConnectorSphere9
    <0,0,0>,1
    scale 1.5
    translate  <-101.916634, -39.1785, 69.87531>
  }
}
#declare VertSeatBackRestUni = union {
  cylinder { // SeatLeg12
    <0,0,1>, <0,0,0>, 1 
    scale <1.349008, 1.349008, 29.580523>
    rotate 11.517895*x
    translate  <-114.596509, -33.498598, 41.726963>
  }
  cylinder { // SeatLeg13
    <0,0,1>, <0,0,0>, 1 
    scale <1.349008, 1.349008, 29.580521>
    rotate 11.5178*x
    translate  <-101.968382, -33.498598, 41.72696>
  }
  cylinder { // SeatLeg14
    <0,0,1>, <0,0,0>, 1 
    scale <1.349008, 1.349008, 13.04278>
    rotate <-90.0, -0.0, -90.0>
    translate  <-114.596509, -38.998913, 69.945731>
  }
  object { TopBackSpheres1 }
}
#declare TwoSeatCyls = union {
  cylinder { // SeatSeatCyl
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -12.267466, 44.576311>
  }
  cylinder { // SeatSeatCyl1
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -13.139294, 44.576311>
  }
}
#declare TwoSeatCyls1 = union {
  cylinder { // SeatSeatCyl2
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -12.267466, 44.576311>
  }
  cylinder { // SeatSeatCyl3
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -13.139294, 44.576311>
  }
  translate  -1.830837*y
}
#declare FourSeatCyls = union {
  object { TwoSeatCyls }
  object { TwoSeatCyls1 }
}
#declare TwoSeatCyls2 = union {
  cylinder { // SeatSeatCyl4
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -12.267466, 44.576311>
  }
  cylinder { // SeatSeatCyl5
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -13.139294, 44.576311>
  }
}
#declare TwoSeatCyls3 = union {
  cylinder { // SeatSeatCyl6
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -12.267466, 44.576311>
  }
  cylinder { // SeatSeatCyl7
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -13.139294, 44.576311>
  }
  translate  -1.830837*y
}
#declare FourSeatCyls1 = union {
  object { TwoSeatCyls2 }
  object { TwoSeatCyls3 }
  translate  -3.83604*y
}
#declare EightSeatCyls = union {
  object { FourSeatCyls }
  object { FourSeatCyls1 }
}
#declare TwoSeatCyls4 = union {
  cylinder { // SeatSeatCyl8
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -12.267466, 44.576311>
  }
  cylinder { // SeatSeatCyl9
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -13.139294, 44.576311>
  }
}
#declare TwoSeatCyls5 = union {
  cylinder { // SeatSeatCyl10
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -12.267466, 44.576311>
  }
  cylinder { // SeatSeatCyl11
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -13.139294, 44.576311>
  }
  translate  -1.830837*y
}
#declare FourSeatCyls2 = union {
  object { TwoSeatCyls4 }
  object { TwoSeatCyls5 }
}
#declare TwoSeatCyls6 = union {
  cylinder { // SeatSeatCyl12
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -12.267466, 44.576311>
  }
  cylinder { // SeatSeatCyl13
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -13.139294, 44.576311>
  }
}
#declare TwoSeatCyls7 = union {
  cylinder { // SeatSeatCyl14
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -12.267466, 44.576311>
  }
  cylinder { // SeatSeatCyl15
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -13.139294, 44.576311>
  }
  translate  -1.830837*y
}
#declare FourSeatCyls3 = union {
  object { TwoSeatCyls6 }
  object { TwoSeatCyls7 }
  translate  -3.83604*y
}
#declare EightSeatCyls1 = union {
  object { FourSeatCyls2 }
  object { FourSeatCyls3 }
  translate  -7.67208*y
}
#declare EightSeatHorizPatch = union {
  object { EightSeatCyls }
  object { EightSeatCyls1 }
}
#declare TwoSeatCyls8 = union {
  cylinder { // SeatSeatCyl16
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -12.267466, 44.576311>
  }
  cylinder { // SeatSeatCyl17
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -13.139294, 44.576311>
  }
}
#declare TwoSeatCyls9 = union {
  cylinder { // SeatSeatCyl18
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -12.267466, 44.576311>
  }
  cylinder { // SeatSeatCyl19
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -13.139294, 44.576311>
  }
  translate  -1.830837*y
}
#declare FourSeatCyls4 = union {
  object { TwoSeatCyls8 }
  object { TwoSeatCyls9 }
  translate  -15.431344*y
}
#declare TwoSeatCyls10 = union {
  cylinder { // SeatSeatCyl20
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -12.267466, 44.576311>
  }
  cylinder { // SeatSeatCyl21
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -13.139294, 44.576311>
  }
  translate  -19.354567*y
}
#declare FinishingHorizSeatPatch = union {
  object { FourSeatCyls4 }
  object { TwoSeatCyls10 }
}
#declare Seatseat = union {
  object { EightSeatHorizPatch }
  object { FinishingHorizSeatPatch }
}
#declare TwoSeatCyls11 = union {
  cylinder { // SeatSeatCyl22
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -12.267466, 44.576311>
  }
  cylinder { // SeatSeatCyl23
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -13.139294, 44.576311>
  }
}
#declare TwoSeatCyls12 = union {
  cylinder { // SeatSeatCyl24
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -12.267466, 44.576311>
  }
  cylinder { // SeatSeatCyl25
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -13.139294, 44.576311>
  }
  translate  -1.830837*y
}
#declare FourSeatCyls5 = union {
  object { TwoSeatCyls11 }
  object { TwoSeatCyls12 }
}
#declare TwoSeatCyls13 = union {
  cylinder { // SeatSeatCyl26
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -12.267466, 44.576311>
  }
  cylinder { // SeatSeatCyl27
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -13.139294, 44.576311>
  }
}
#declare TwoSeatCyls14 = union {
  cylinder { // SeatSeatCyl28
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -12.267466, 44.576311>
  }
  cylinder { // SeatSeatCyl29
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -13.139294, 44.576311>
  }
  translate  -1.830837*y
}
#declare FourSeatCyls6 = union {
  object { TwoSeatCyls13 }
  object { TwoSeatCyls14 }
  translate  -3.83604*y
}
#declare EightSeatCyls2 = union {
  object { FourSeatCyls5 }
  object { FourSeatCyls6 }
}
#declare TwoSeatCyls15 = union {
  cylinder { // SeatSeatCyl30
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -12.267466, 44.576311>
  }
  cylinder { // SeatSeatCyl31
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -13.139294, 44.576311>
  }
}
#declare TwoSeatCyls16 = union {
  cylinder { // SeatSeatCyl32
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -12.267466, 44.576311>
  }
  cylinder { // SeatSeatCyl33
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -13.139294, 44.576311>
  }
  translate  -1.830837*y
}
#declare FourSeatCyls7 = union {
  object { TwoSeatCyls15 }
  object { TwoSeatCyls16 }
}
#declare TwoSeatCyls17 = union {
  cylinder { // SeatSeatCyl34
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -12.267466, 44.576311>
  }
  cylinder { // SeatSeatCyl35
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -13.139294, 44.576311>
  }
}
#declare TwoSeatCyls18 = union {
  cylinder { // SeatSeatCyl36
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -12.267466, 44.576311>
  }
  cylinder { // SeatSeatCyl37
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -13.139294, 44.576311>
  }
  translate  -1.830837*y
}
#declare FourSeatCyls8 = union {
  object { TwoSeatCyls17 }
  object { TwoSeatCyls18 }
  translate  -3.83604*y
}
#declare EightSeatCyls3 = union {
  object { FourSeatCyls7 }
  object { FourSeatCyls8 }
  translate  -7.67208*y
}
#declare EightSeatHorizPatch1 = union {
  object { EightSeatCyls2 }
  object { EightSeatCyls3 }
}
#declare TwoSeatCyls19 = union {
  cylinder { // SeatSeatCyl38
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -12.267466, 44.576311>
  }
  cylinder { // SeatSeatCyl39
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -13.139294, 44.576311>
  }
}
#declare TwoSeatCyls20 = union {
  cylinder { // SeatSeatCyl40
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -12.267466, 44.576311>
  }
  cylinder { // SeatSeatCyl41
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -13.139294, 44.576311>
  }
  translate  -1.830837*y
}
#declare FourSeatCyls9 = union {
  object { TwoSeatCyls19 }
  object { TwoSeatCyls20 }
  translate  -15.431344*y
}
#declare TwoSeatCyls21 = union {
  cylinder { // SeatSeatCyl42
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -12.267466, 44.576311>
  }
  cylinder { // SeatSeatCyl43
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -13.139294, 44.576311>
  }
  translate  -19.354567*y
}
#declare FinishingHorizSeatPatch1 = union {
  object { FourSeatCyls9 }
  object { TwoSeatCyls21 }
}
#declare TwoSeatCyls22 = union {
  cylinder { // SeatSeatCyl44
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -12.267466, 44.576311>
  }
  cylinder { // SeatSeatCyl45
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -13.139294, 44.576311>
  }
  translate  <-0.0, -21.431954, -0.032223>
}
#declare TwoSeatCyls23 = union {
  cylinder { // SeatSeatCyl46
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -12.267466, 44.576311>
  }
  cylinder { // SeatSeatCyl47
    <0,0,1>, <0,0,0>, 1 
    scale <0.49318, 0.49318, 14.707105>
    rotate <-90.0, -0.0, -90.0>
    translate  <-115.817067, -13.139294, 44.576311>
  }
  translate  <-0.0, -23.467031, -0.127173>
}
#declare SeatBack = union {
  object { EightSeatHorizPatch1 }
  object { FinishingHorizSeatPatch1 }
  object { TwoSeatCyls22 }
  object { TwoSeatCyls23 }
  rotate -79.0*x
  translate  <0.254306, -74.505468, 24.943735>
}
union { // Seat
  object { SeatLegs }
  object { VertSeatBackRestUni }
  object { Seatseat }
  object { SeatBack }
  material {
    DMFLightOak_Moray
  }
}


box { // BackgroundCube
  <-1, -1, -1>, <1, 1, 1>
  material {
    BackgroundMateral
    scale <1.928956, 2.00503, 1.0>
    rotate <-90.0, -180.0, 90.0>
    translate <1.857355, 0.938504, -1.008878>
  }
  scale <0.906078, -425.561951, 170.859131>
  translate  <-1137.835315, 0.0, 107.165147>
}


#declare TableLeg = difference {
  cylinder { // TableLegOuter
    <0,0,1>, <0,0,0>, 1 
    scale <13.58105, 7.104145, 7.104145>
    rotate -90.0*y
    translate  <-85.423162, 1.670857, 33.739948>
  }
  cylinder { // TableLegInner
    <0,0,1>, <0,0,0>, 1 
    scale <10.485561, 5.30192, 8.229888>
    rotate -90.0*y
    translate  <-84.874168, 1.487859, 33.739948>
  }
  material {
    DMFWood2_Moray
  }
  translate  10.120165*y
}
#declare TableLeg2 = difference {
  cylinder { // TableLegOuter1
    <0,0,1>, <0,0,0>, 1 
    scale <13.58105, 7.104145, 7.104145>
    rotate -90.0*y
    translate  <-85.423162, 1.670857, 33.739948>
  }
  cylinder { // TableLegInner1
    <0,0,1>, <0,0,0>, 1 
    scale <10.485561, 5.30192, 8.229888>
    rotate -90.0*y
    translate  <-84.874168, 1.487859, 33.739948>
  }
  material {
    DMFWood2_Moray
  }
  translate  -4.857679*y
}
#declare TableLegSet = union {
  object { TableLeg }
  object { TableLeg2 }
  translate  -2.833646*y
}
#declare TableLeg1 = difference {
  cylinder { // TableLegOuter2
    <0,0,1>, <0,0,0>, 1 
    scale <13.58105, 7.104145, 7.104145>
    rotate -90.0*y
    translate  <-85.423162, 1.670857, 33.739948>
  }
  cylinder { // TableLegInner2
    <0,0,1>, <0,0,0>, 1 
    scale <10.485561, 5.30192, 8.229888>
    rotate -90.0*y
    translate  <-84.874168, 1.487859, 33.739948>
  }
  material {
    DMFWood2_Moray
  }
  translate  10.120165*y
}
#declare TableLeg3 = difference {
  cylinder { // TableLegOuter3
    <0,0,1>, <0,0,0>, 1 
    scale <13.58105, 7.104145, 7.104145>
    rotate -90.0*y
    translate  <-85.423162, 1.670857, 33.739948>
  }
  cylinder { // TableLegInner3
    <0,0,1>, <0,0,0>, 1 
    scale <10.485561, 5.30192, 8.229888>
    rotate -90.0*y
    translate  <-84.874168, 1.487859, 33.739948>
  }
  material {
    DMFWood2_Moray
  }
  translate  -4.857679*y
}
#declare TableLegSet2 = union {
  object { TableLeg1 }
  object { TableLeg3 }
  translate  <-33.582205, -2.833646, 0.0>
}
#declare VerticalPinBlocks = union {
  box { // PinBlockLeft
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.832572>
    translate  <-89.321643, -2.403773, 33.182429>
  }
  box { // PinBlockRight
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.832572>
    translate  <-89.36853, 4.982236, 33.182429>
  }
}
#declare HorizPinBlocks = union {
  box { // PinBlockLeft1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.832572>
    rotate <-90.0, -0.0, 88.925079>
    translate  <-89.321643, -2.403773, 33.182429>
  }
  box { // PinBlockRight1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.832572>
    rotate <-90.0, 0.0, 88.925003>
    translate  <-89.36853, 4.982236, 33.182429>
  }
}
#declare FrontLegsPin = union {
  cylinder { // LegPin
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 10.0>
    rotate <90.0, -70.0, -0.0>
    translate  <-89.323806, 6.300491, 33.123577>
  }
  object { VerticalPinBlocks }
  object { HorizPinBlocks }
}
#declare VerticalPinBlocks1 = union {
  box { // PinBlockLeft2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.832572>
    translate  <-89.321643, -2.403773, 33.182429>
  }
  box { // PinBlockRight2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.832572>
    translate  <-89.36853, 4.982236, 33.182429>
  }
}
#declare HorizPinBlocks1 = union {
  box { // PinBlockLeft3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.832572>
    rotate <-90.0, -0.0, 88.925079>
    translate  <-89.321643, -2.403773, 33.182429>
  }
  box { // PinBlockRight3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.832572>
    rotate <-90.0, 0.0, 88.925003>
    translate  <-89.36853, 4.982236, 33.182429>
  }
}
#declare BackLegsPin = union {
  cylinder { // LegPin1
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 10.0>
    rotate <90.0, -70.0, -0.0>
    translate  <-89.323806, 6.300491, 33.123577>
  }
  object { VerticalPinBlocks1 }
  object { HorizPinBlocks1 }
  translate  <-33.192461, -0.153116, 0.0>
}
#declare TableLegsPin = union {
  object { FrontLegsPin }
  object { BackLegsPin }
  material {
    DMFWood2_Moray
  }
}
#declare TableLegs = union {
  object { TableLegSet }
  object { TableLegSet2 }
  object { TableLegsPin }
}
#declare TableTopCuts = union {
  box { // TableTopCut
    <-1, -1, -1>, <1, 1, 1>
    scale <-24.06498, -0.300864, 1.0>
    translate  <-105.872697, 8.611085, 49.105104>
  }
  box { // TableTopCut1
    <-1, -1, -1>, <1, 1, 1>
    scale <-24.06498, -0.300864, 1.0>
    translate  <-105.872697, 1.42979, 49.105104>
  }
  box { // TableTopCut2
    <-1, -1, -1>, <1, 1, 1>
    scale <-24.06498, -0.300864, 1.0>
    translate  <-105.872697, -5.59192, 49.105104>
  }
  material {
    DMFWood2_Moray
  }
}
#declare TableTopDiff = difference {
  box { // TableTop
    <-1, -1, -1>, <1, 1, 1>
    material {
      DMFWood2_Moray
    }
    scale <-21.144787, -11.471766, 1.0>
    translate  <-105.872697, 1.270206, 48.466767>
  }
  object { TableTopCuts }
}
#declare PlantBowl = lathe {
  quadratic_spline
  9  // control points
  <0.592075, -0.93007>,
  <0.090909, -1.128205>,
  <1.002611, -1.008019>,
  <1.83683, -0.7331>,
  <2.115358, -0.131205>,
  <1.428011, 0.418205>,
  <0.729604, 0.68648>,
  <0.971602, 0.932676>,
  <1.244755, 0.83683>
  rotate <90,0,90>
  material {
    Pierre2
  }
  scale 3.219797
  translate  <-120.484056, 6.896978, 53.719084>
}
#declare FrontPlantVase = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.171875, -0.671875>, <0.039464, -0.171875, -0.671875>, <0.093629, -0.149439, -0.671875>, <0.121534, -0.121534, -0.671875>, 
      <0.000000, -0.156757, -0.748412>, <0.039464, -0.156757, -0.748412>, <0.082938, -0.138749, -0.748412>, <0.110844, -0.110844, -0.748412>, 
      <0.000000, -0.325000, -0.770312>, <0.089691, -0.325000, -0.770312>, <0.166388, -0.293231, -0.770312>, <0.229810, -0.229810, -0.770312>, 
      <0.000000, -0.390625, -0.812500>, <0.089691, -0.390625, -0.812500>, <0.212793, -0.339635, -0.812500>, <0.276214, -0.276214, -0.812500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.121534, -0.121534, -0.671875>, <-0.093629, -0.149439, -0.671875>, <-0.039464, -0.171875, -0.671875>, <0.000000, -0.171875, -0.671875>, 
      <-0.110844, -0.110844, -0.748412>, <-0.082938, -0.138749, -0.748412>, <-0.039464, -0.156757, -0.748412>, <0.000000, -0.156757, -0.748412>, 
      <-0.229810, -0.229810, -0.770312>, <-0.166388, -0.293231, -0.770312>, <-0.089691, -0.325000, -0.770312>, <0.000000, -0.325000, -0.770312>, 
      <-0.276214, -0.276214, -0.812500>, <-0.212793, -0.339635, -0.812500>, <-0.089691, -0.390625, -0.812500>, <0.000000, -0.390625, -0.812500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.171875, 0.000000, -0.671875>, <-0.171875, -0.039464, -0.671875>, <-0.149439, -0.093629, -0.671875>, <-0.121534, -0.121534, -0.671875>, 
      <-0.156757, 0.000000, -0.748412>, <-0.156757, -0.039464, -0.748412>, <-0.138749, -0.082938, -0.748412>, <-0.110844, -0.110844, -0.748412>, 
      <-0.325000, 0.000000, -0.770312>, <-0.325000, -0.089691, -0.770312>, <-0.293231, -0.166388, -0.770312>, <-0.229810, -0.229810, -0.770312>, 
      <-0.390625, 0.000000, -0.812500>, <-0.390625, -0.089691, -0.812500>, <-0.339635, -0.212793, -0.812500>, <-0.276214, -0.276214, -0.812500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.121534, 0.121534, -0.671875>, <-0.149439, 0.093629, -0.671875>, <-0.171875, 0.039464, -0.671875>, <-0.171875, 0.000000, -0.671875>, 
      <-0.110844, 0.110844, -0.748412>, <-0.138749, 0.082938, -0.748412>, <-0.156757, 0.039464, -0.748412>, <-0.156757, 0.000000, -0.748412>, 
      <-0.229810, 0.229810, -0.770312>, <-0.293231, 0.166388, -0.770312>, <-0.325000, 0.089691, -0.770312>, <-0.325000, 0.000000, -0.770312>, 
      <-0.276214, 0.276214, -0.812500>, <-0.339635, 0.212793, -0.812500>, <-0.390625, 0.089691, -0.812500>, <-0.390625, 0.000000, -0.812500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.171875, -0.671875>, <-0.039464, 0.171875, -0.671875>, <-0.093629, 0.149439, -0.671875>, <-0.121534, 0.121534, -0.671875>, 
      <0.000000, 0.156757, -0.748412>, <-0.039464, 0.156757, -0.748412>, <-0.082938, 0.138749, -0.748412>, <-0.110844, 0.110844, -0.748412>, 
      <0.000000, 0.325000, -0.770312>, <-0.089691, 0.325000, -0.770312>, <-0.166388, 0.293231, -0.770312>, <-0.229810, 0.229810, -0.770312>, 
      <0.000000, 0.390625, -0.812500>, <-0.089691, 0.390625, -0.812500>, <-0.212793, 0.339635, -0.812500>, <-0.276214, 0.276214, -0.812500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.121534, 0.121534, -0.671875>, <0.093629, 0.149439, -0.671875>, <0.039464, 0.171875, -0.671875>, <0.000000, 0.171875, -0.671875>, 
      <0.110844, 0.110844, -0.748412>, <0.082938, 0.138749, -0.748412>, <0.039464, 0.156757, -0.748412>, <0.000000, 0.156757, -0.748412>, 
      <0.229810, 0.229810, -0.770312>, <0.166388, 0.293231, -0.770312>, <0.089691, 0.325000, -0.770312>, <0.000000, 0.325000, -0.770312>, 
      <0.276214, 0.276214, -0.812500>, <0.212793, 0.339635, -0.812500>, <0.089691, 0.390625, -0.812500>, <0.000000, 0.390625, -0.812500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.640625, 0.453125>, <0.147094, -0.640625, 0.453125>, <0.348979, -0.557001, 0.453125>, <0.452990, -0.452990, 0.453125>, 
      <0.000000, -0.603426, 0.089397>, <0.147094, -0.603426, 0.089397>, <0.322675, -0.530697, 0.089397>, <0.426686, -0.426686, 0.089397>, 
      <0.000000, -0.242728, -0.313181>, <0.039464, -0.242728, -0.313181>, <0.143729, -0.199540, -0.313181>, <0.171635, -0.171635, -0.313181>, 
      <0.000000, -0.171875, -0.671875>, <0.039464, -0.171875, -0.671875>, <0.093629, -0.149439, -0.671875>, <0.121534, -0.121534, -0.671875>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.452990, -0.452990, 0.453125>, <-0.348979, -0.557001, 0.453125>, <-0.147094, -0.640625, 0.453125>, <0.000000, -0.640625, 0.453125>, 
      <-0.426686, -0.426686, 0.089397>, <-0.322675, -0.530697, 0.089397>, <-0.147094, -0.603426, 0.089397>, <0.000000, -0.603426, 0.089397>, 
      <-0.171635, -0.171635, -0.313181>, <-0.143729, -0.199540, -0.313181>, <-0.039464, -0.242728, -0.313181>, <0.000000, -0.242728, -0.313181>, 
      <-0.121534, -0.121534, -0.671875>, <-0.093629, -0.149439, -0.671875>, <-0.039464, -0.171875, -0.671875>, <0.000000, -0.171875, -0.671875>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.640625, 0.000000, 0.453125>, <-0.640625, -0.147094, 0.453125>, <-0.557001, -0.348979, 0.453125>, <-0.452990, -0.452990, 0.453125>, 
      <-0.603426, 0.000000, 0.089397>, <-0.603426, -0.147094, 0.089397>, <-0.530697, -0.322675, 0.089397>, <-0.426686, -0.426686, 0.089397>, 
      <-0.242728, 0.000000, -0.313181>, <-0.242728, -0.039464, -0.313181>, <-0.199540, -0.143729, -0.313181>, <-0.171635, -0.171635, -0.313181>, 
      <-0.171875, 0.000000, -0.671875>, <-0.171875, -0.039464, -0.671875>, <-0.149439, -0.093629, -0.671875>, <-0.121534, -0.121534, -0.671875>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.452990, 0.452990, 0.453125>, <-0.557001, 0.348979, 0.453125>, <-0.640625, 0.147094, 0.453125>, <-0.640625, 0.000000, 0.453125>, 
      <-0.426686, 0.426686, 0.089397>, <-0.530697, 0.322675, 0.089397>, <-0.603426, 0.147094, 0.089397>, <-0.603426, 0.000000, 0.089397>, 
      <-0.171635, 0.171635, -0.313181>, <-0.199540, 0.143729, -0.313181>, <-0.242728, 0.039464, -0.313181>, <-0.242728, 0.000000, -0.313181>, 
      <-0.121534, 0.121534, -0.671875>, <-0.149439, 0.093629, -0.671875>, <-0.171875, 0.039464, -0.671875>, <-0.171875, 0.000000, -0.671875>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.640625, 0.453125>, <-0.147094, 0.640625, 0.453125>, <-0.348979, 0.557001, 0.453125>, <-0.452990, 0.452990, 0.453125>, 
      <0.000000, 0.603426, 0.089397>, <-0.147094, 0.603426, 0.089397>, <-0.322675, 0.530697, 0.089397>, <-0.426686, 0.426686, 0.089397>, 
      <0.000000, 0.242728, -0.313181>, <-0.039464, 0.242728, -0.313181>, <-0.143729, 0.199540, -0.313181>, <-0.171635, 0.171635, -0.313181>, 
      <0.000000, 0.171875, -0.671875>, <-0.039464, 0.171875, -0.671875>, <-0.093629, 0.149439, -0.671875>, <-0.121534, 0.121534, -0.671875>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.452990, 0.452990, 0.453125>, <0.348979, 0.557001, 0.453125>, <0.147094, 0.640625, 0.453125>, <0.000000, 0.640625, 0.453125>, 
      <0.426686, 0.426686, 0.089397>, <0.322675, 0.530697, 0.089397>, <0.147094, 0.603426, 0.089397>, <0.000000, 0.603426, 0.089397>, 
      <0.171635, 0.171635, -0.313181>, <0.143729, 0.199540, -0.313181>, <0.039464, 0.242728, -0.313181>, <0.000000, 0.242728, -0.313181>, 
      <0.121534, 0.121534, -0.671875>, <0.093629, 0.149439, -0.671875>, <0.039464, 0.171875, -0.671875>, <0.000000, 0.171875, -0.671875>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.312500, 0.703125>, <0.071753, -0.312500, 0.703125>, <0.170234, -0.271708, 0.703125>, <0.220971, -0.220971, 0.703125>, 
      <0.000000, -0.394717, 0.610630>, <0.071753, -0.394717, 0.610630>, <0.228370, -0.329844, 0.610630>, <0.279107, -0.279107, 0.610630>, 
      <0.000000, -0.653216, 0.576236>, <0.147094, -0.653216, 0.576236>, <0.357882, -0.565904, 0.576236>, <0.461893, -0.461893, 0.576236>, 
      <0.000000, -0.640625, 0.453125>, <0.147094, -0.640625, 0.453125>, <0.348979, -0.557001, 0.453125>, <0.452990, -0.452990, 0.453125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.220971, -0.220971, 0.703125>, <-0.170234, -0.271708, 0.703125>, <-0.071753, -0.312500, 0.703125>, <0.000000, -0.312500, 0.703125>, 
      <-0.279107, -0.279107, 0.610630>, <-0.228370, -0.329844, 0.610630>, <-0.071753, -0.394717, 0.610630>, <0.000000, -0.394717, 0.610630>, 
      <-0.461893, -0.461893, 0.576236>, <-0.357882, -0.565904, 0.576236>, <-0.147094, -0.653216, 0.576236>, <0.000000, -0.653216, 0.576236>, 
      <-0.452990, -0.452990, 0.453125>, <-0.348979, -0.557001, 0.453125>, <-0.147094, -0.640625, 0.453125>, <0.000000, -0.640625, 0.453125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.312500, 0.000000, 0.703125>, <-0.312500, -0.071753, 0.703125>, <-0.271708, -0.170234, 0.703125>, <-0.220971, -0.220971, 0.703125>, 
      <-0.394717, 0.000000, 0.610630>, <-0.394717, -0.071753, 0.610630>, <-0.329844, -0.228370, 0.610630>, <-0.279107, -0.279107, 0.610630>, 
      <-0.653216, 0.000000, 0.576236>, <-0.653216, -0.147094, 0.576236>, <-0.565904, -0.357882, 0.576236>, <-0.461893, -0.461893, 0.576236>, 
      <-0.640625, 0.000000, 0.453125>, <-0.640625, -0.147094, 0.453125>, <-0.557001, -0.348979, 0.453125>, <-0.452990, -0.452990, 0.453125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.220971, 0.220971, 0.703125>, <-0.271708, 0.170234, 0.703125>, <-0.312500, 0.071753, 0.703125>, <-0.312500, 0.000000, 0.703125>, 
      <-0.279107, 0.279107, 0.610630>, <-0.329844, 0.228370, 0.610630>, <-0.394717, 0.071753, 0.610630>, <-0.394717, 0.000000, 0.610630>, 
      <-0.461893, 0.461893, 0.576236>, <-0.565904, 0.357882, 0.576236>, <-0.653216, 0.147094, 0.576236>, <-0.653216, 0.000000, 0.576236>, 
      <-0.452990, 0.452990, 0.453125>, <-0.557001, 0.348979, 0.453125>, <-0.640625, 0.147094, 0.453125>, <-0.640625, 0.000000, 0.453125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.312500, 0.703125>, <-0.071753, 0.312500, 0.703125>, <-0.170234, 0.271708, 0.703125>, <-0.220971, 0.220971, 0.703125>, 
      <0.000000, 0.394717, 0.610630>, <-0.071753, 0.394717, 0.610630>, <-0.228370, 0.329844, 0.610630>, <-0.279107, 0.279107, 0.610630>, 
      <0.000000, 0.653216, 0.576236>, <-0.147094, 0.653216, 0.576236>, <-0.357882, 0.565904, 0.576236>, <-0.461893, 0.461893, 0.576236>, 
      <0.000000, 0.640625, 0.453125>, <-0.147094, 0.640625, 0.453125>, <-0.348979, 0.557001, 0.453125>, <-0.452990, 0.452990, 0.453125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.220971, 0.220971, 0.703125>, <0.170234, 0.271708, 0.703125>, <0.071753, 0.312500, 0.703125>, <0.000000, 0.312500, 0.703125>, 
      <0.279107, 0.279107, 0.610630>, <0.228370, 0.329844, 0.610630>, <0.071753, 0.394717, 0.610630>, <0.000000, 0.394717, 0.610630>, 
      <0.461893, 0.461893, 0.576236>, <0.357882, 0.565904, 0.576236>, <0.147094, 0.653216, 0.576236>, <0.000000, 0.653216, 0.576236>, 
      <0.452990, 0.452990, 0.453125>, <0.348979, 0.557001, 0.453125>, <0.147094, 0.640625, 0.453125>, <0.000000, 0.640625, 0.453125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.265625, 0.875000>, <0.060990, -0.265625, 0.875000>, <0.144699, -0.230952, 0.875000>, <0.187825, -0.187825, 0.875000>, 
      <0.000000, -0.240903, 0.827616>, <0.060990, -0.240903, 0.827616>, <0.127217, -0.213470, 0.827616>, <0.170344, -0.170344, 0.827616>, 
      <0.000000, -0.276993, 0.743071>, <0.071753, -0.276993, 0.743071>, <0.145126, -0.246601, 0.743071>, <0.195864, -0.195864, 0.743071>, 
      <0.000000, -0.312500, 0.703125>, <0.071753, -0.312500, 0.703125>, <0.170234, -0.271708, 0.703125>, <0.220971, -0.220971, 0.703125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.187825, -0.187825, 0.875000>, <-0.144699, -0.230952, 0.875000>, <-0.060990, -0.265625, 0.875000>, <0.000000, -0.265625, 0.875000>, 
      <-0.170344, -0.170344, 0.827616>, <-0.127217, -0.213470, 0.827616>, <-0.060990, -0.240903, 0.827616>, <0.000000, -0.240903, 0.827616>, 
      <-0.195864, -0.195864, 0.743071>, <-0.145126, -0.246601, 0.743071>, <-0.071753, -0.276993, 0.743071>, <0.000000, -0.276993, 0.743071>, 
      <-0.220971, -0.220971, 0.703125>, <-0.170234, -0.271708, 0.703125>, <-0.071753, -0.312500, 0.703125>, <0.000000, -0.312500, 0.703125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.265625, 0.000000, 0.875000>, <-0.265625, -0.060990, 0.875000>, <-0.230952, -0.144699, 0.875000>, <-0.187825, -0.187825, 0.875000>, 
      <-0.240903, 0.000000, 0.827616>, <-0.240903, -0.060990, 0.827616>, <-0.213470, -0.127217, 0.827616>, <-0.170344, -0.170344, 0.827616>, 
      <-0.276993, 0.000000, 0.743071>, <-0.276993, -0.071753, 0.743071>, <-0.246601, -0.145126, 0.743071>, <-0.195864, -0.195864, 0.743071>, 
      <-0.312500, 0.000000, 0.703125>, <-0.312500, -0.071753, 0.703125>, <-0.271708, -0.170234, 0.703125>, <-0.220971, -0.220971, 0.703125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.187825, 0.187825, 0.875000>, <-0.230952, 0.144699, 0.875000>, <-0.265625, 0.060990, 0.875000>, <-0.265625, 0.000000, 0.875000>, 
      <-0.170344, 0.170344, 0.827616>, <-0.213470, 0.127217, 0.827616>, <-0.240903, 0.060990, 0.827616>, <-0.240903, 0.000000, 0.827616>, 
      <-0.195864, 0.195864, 0.743071>, <-0.246601, 0.145126, 0.743071>, <-0.276993, 0.071753, 0.743071>, <-0.276993, 0.000000, 0.743071>, 
      <-0.220971, 0.220971, 0.703125>, <-0.271708, 0.170234, 0.703125>, <-0.312500, 0.071753, 0.703125>, <-0.312500, 0.000000, 0.703125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.265625, 0.875000>, <-0.060990, 0.265625, 0.875000>, <-0.144699, 0.230952, 0.875000>, <-0.187825, 0.187825, 0.875000>, 
      <0.000000, 0.240903, 0.827616>, <-0.060990, 0.240903, 0.827616>, <-0.127217, 0.213470, 0.827616>, <-0.170344, 0.170344, 0.827616>, 
      <0.000000, 0.276993, 0.743071>, <-0.071753, 0.276993, 0.743071>, <-0.145126, 0.246601, 0.743071>, <-0.195864, 0.195864, 0.743071>, 
      <0.000000, 0.312500, 0.703125>, <-0.071753, 0.312500, 0.703125>, <-0.170234, 0.271708, 0.703125>, <-0.220971, 0.220971, 0.703125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.187825, 0.187825, 0.875000>, <0.144699, 0.230952, 0.875000>, <0.060990, 0.265625, 0.875000>, <0.000000, 0.265625, 0.875000>, 
      <0.170344, 0.170344, 0.827616>, <0.127217, 0.213470, 0.827616>, <0.060990, 0.240903, 0.827616>, <0.000000, 0.240903, 0.827616>, 
      <0.195864, 0.195864, 0.743071>, <0.145126, 0.246601, 0.743071>, <0.071753, 0.276993, 0.743071>, <0.000000, 0.276993, 0.743071>, 
      <0.220971, 0.220971, 0.703125>, <0.170234, 0.271708, 0.703125>, <0.071753, 0.312500, 0.703125>, <0.000000, 0.312500, 0.703125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.500000, 1.062500>, <0.114805, -0.500000, 1.062500>, <0.272375, -0.434733, 1.062500>, <0.353554, -0.353553, 1.062500>, 
      <0.000000, -0.429688, 1.006250>, <0.114805, -0.429688, 1.006250>, <0.222656, -0.385014, 1.006250>, <0.303835, -0.303835, 1.006250>, 
      <0.000000, -0.307276, 0.954832>, <0.060990, -0.307276, 0.954832>, <0.174151, -0.260403, 0.954832>, <0.217277, -0.217277, 0.954832>, 
      <0.000000, -0.265625, 0.875000>, <0.060990, -0.265625, 0.875000>, <0.144699, -0.230952, 0.875000>, <0.187825, -0.187825, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.353553, -0.353553, 1.062500>, <-0.272374, -0.434732, 1.062500>, <-0.114805, -0.500000, 1.062500>, <0.000000, -0.500000, 1.062500>, 
      <-0.303835, -0.303835, 1.006250>, <-0.222655, -0.385014, 1.006250>, <-0.114805, -0.429688, 1.006250>, <0.000000, -0.429688, 1.006250>, 
      <-0.217277, -0.217277, 0.954832>, <-0.174150, -0.260403, 0.954832>, <-0.060990, -0.307276, 0.954832>, <0.000000, -0.307276, 0.954832>, 
      <-0.187825, -0.187825, 0.875000>, <-0.144699, -0.230952, 0.875000>, <-0.060990, -0.265625, 0.875000>, <0.000000, -0.265625, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 1.062500>, <-0.500000, -0.114805, 1.062500>, <-0.434732, -0.272374, 1.062500>, <-0.353553, -0.353553, 1.062500>, 
      <-0.429688, 0.000000, 1.006250>, <-0.429688, -0.114805, 1.006250>, <-0.385014, -0.222655, 1.006250>, <-0.303835, -0.303835, 1.006250>, 
      <-0.307276, 0.000000, 0.954832>, <-0.307276, -0.060990, 0.954832>, <-0.260403, -0.174150, 0.954832>, <-0.217277, -0.217277, 0.954832>, 
      <-0.265625, 0.000000, 0.875000>, <-0.265625, -0.060990, 0.875000>, <-0.230952, -0.144699, 0.875000>, <-0.187825, -0.187825, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.353553, 0.353553, 1.062500>, <-0.434732, 0.272374, 1.062500>, <-0.500000, 0.114805, 1.062500>, <-0.500000, 0.000000, 1.062500>, 
      <-0.303835, 0.303835, 1.006250>, <-0.385014, 0.222655, 1.006250>, <-0.429688, 0.114805, 1.006250>, <-0.429688, 0.000000, 1.006250>, 
      <-0.217277, 0.217277, 0.954832>, <-0.260403, 0.174150, 0.954832>, <-0.307276, 0.060990, 0.954832>, <-0.307276, 0.000000, 0.954832>, 
      <-0.187825, 0.187825, 0.875000>, <-0.230952, 0.144699, 0.875000>, <-0.265625, 0.060990, 0.875000>, <-0.265625, 0.000000, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.500000, 1.062500>, <-0.114805, 0.500000, 1.062500>, <-0.272374, 0.434732, 1.062500>, <-0.353553, 0.353553, 1.062500>, 
      <0.000000, 0.429688, 1.006250>, <-0.114805, 0.429688, 1.006250>, <-0.222655, 0.385014, 1.006250>, <-0.303835, 0.303835, 1.006250>, 
      <0.000000, 0.307276, 0.954832>, <-0.060990, 0.307276, 0.954832>, <-0.174150, 0.260403, 0.954832>, <-0.217277, 0.217277, 0.954832>, 
      <0.000000, 0.265625, 0.875000>, <-0.060990, 0.265625, 0.875000>, <-0.144699, 0.230952, 0.875000>, <-0.187825, 0.187825, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.353553, 0.353553, 1.062500>, <0.272374, 0.434732, 1.062500>, <0.114805, 0.500000, 1.062500>, <0.000000, 0.500000, 1.062500>, 
      <0.303835, 0.303835, 1.006250>, <0.222655, 0.385014, 1.006250>, <0.114805, 0.429688, 1.006250>, <0.000000, 0.429688, 1.006250>, 
      <0.217277, 0.217277, 0.954832>, <0.174150, 0.260403, 0.954832>, <0.060990, 0.307276, 0.954832>, <0.000000, 0.307276, 0.954832>, 
      <0.187825, 0.187825, 0.875000>, <0.144699, 0.230952, 0.875000>, <0.060990, 0.265625, 0.875000>, <0.000000, 0.265625, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.171875, 0.000000, -0.671875>, <0.171875, 0.039464, -0.671875>, <0.149439, 0.093629, -0.671875>, <0.121534, 0.121534, -0.671875>, 
      <0.156757, 0.000000, -0.748412>, <0.156757, 0.039464, -0.748412>, <0.138749, 0.082938, -0.748412>, <0.110844, 0.110844, -0.748412>, 
      <0.325000, 0.000000, -0.770312>, <0.325000, 0.089691, -0.770312>, <0.293231, 0.166388, -0.770312>, <0.229810, 0.229810, -0.770312>, 
      <0.390625, 0.000000, -0.812500>, <0.390625, 0.089691, -0.812500>, <0.339635, 0.212793, -0.812500>, <0.276214, 0.276214, -0.812500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.171875, 0.000000, -0.671875>, <0.156757, 0.000000, -0.748412>, <0.325000, 0.000000, -0.770312>, <0.390625, 0.000000, -0.812500>, 
      <0.171875, -0.039464, -0.671875>, <0.156757, -0.039464, -0.748412>, <0.325000, -0.089691, -0.770312>, <0.390625, -0.089691, -0.812500>, 
      <0.149439, -0.093629, -0.671875>, <0.138749, -0.082938, -0.748412>, <0.293231, -0.166388, -0.770312>, <0.339635, -0.212793, -0.812500>, 
      <0.121534, -0.121534, -0.671875>, <0.110844, -0.110844, -0.748412>, <0.229810, -0.229810, -0.770312>, <0.276214, -0.276214, -0.812500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.640625, 0.000000, 0.453125>, <0.640625, 0.147094, 0.453125>, <0.557001, 0.348979, 0.453125>, <0.452990, 0.452990, 0.453125>, 
      <0.603426, 0.000000, 0.089397>, <0.603426, 0.147094, 0.089397>, <0.530697, 0.322675, 0.089397>, <0.426686, 0.426686, 0.089397>, 
      <0.242728, 0.000000, -0.313181>, <0.242728, 0.039464, -0.313181>, <0.199540, 0.143729, -0.313181>, <0.171635, 0.171635, -0.313181>, 
      <0.171875, 0.000000, -0.671875>, <0.171875, 0.039464, -0.671875>, <0.149439, 0.093629, -0.671875>, <0.121534, 0.121534, -0.671875>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.640625, 0.000000, 0.453125>, <0.603426, 0.000000, 0.089397>, <0.242728, 0.000000, -0.313181>, <0.171875, 0.000000, -0.671875>, 
      <0.640625, -0.147094, 0.453125>, <0.603426, -0.147094, 0.089397>, <0.242728, -0.039464, -0.313181>, <0.171875, -0.039464, -0.671875>, 
      <0.557001, -0.348979, 0.453125>, <0.530697, -0.322675, 0.089397>, <0.199540, -0.143729, -0.313181>, <0.149439, -0.093629, -0.671875>, 
      <0.452990, -0.452990, 0.453125>, <0.426686, -0.426686, 0.089397>, <0.171635, -0.171635, -0.313181>, <0.121534, -0.121534, -0.671875>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.312500, 0.000000, 0.703125>, <0.312500, 0.071753, 0.703125>, <0.271708, 0.170234, 0.703125>, <0.220971, 0.220971, 0.703125>, 
      <0.394717, 0.000000, 0.610630>, <0.394717, 0.071753, 0.610630>, <0.329844, 0.228370, 0.610630>, <0.279107, 0.279107, 0.610630>, 
      <0.653216, 0.000000, 0.576236>, <0.653216, 0.147094, 0.576236>, <0.565904, 0.357882, 0.576236>, <0.461893, 0.461893, 0.576236>, 
      <0.640625, 0.000000, 0.453125>, <0.640625, 0.147094, 0.453125>, <0.557001, 0.348979, 0.453125>, <0.452990, 0.452990, 0.453125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.312500, 0.000000, 0.703125>, <0.394717, 0.000000, 0.610630>, <0.653216, 0.000000, 0.576236>, <0.640625, 0.000000, 0.453125>, 
      <0.312500, -0.071753, 0.703125>, <0.394717, -0.071753, 0.610630>, <0.653216, -0.147094, 0.576236>, <0.640625, -0.147094, 0.453125>, 
      <0.271708, -0.170234, 0.703125>, <0.329844, -0.228370, 0.610630>, <0.565904, -0.357882, 0.576236>, <0.557001, -0.348979, 0.453125>, 
      <0.220971, -0.220971, 0.703125>, <0.279107, -0.279107, 0.610630>, <0.461893, -0.461893, 0.576236>, <0.452990, -0.452990, 0.453125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.265625, 0.000000, 0.875000>, <0.265625, 0.060990, 0.875000>, <0.230952, 0.144699, 0.875000>, <0.187825, 0.187825, 0.875000>, 
      <0.240903, 0.000000, 0.827616>, <0.240903, 0.060990, 0.827616>, <0.213470, 0.127217, 0.827616>, <0.170344, 0.170344, 0.827616>, 
      <0.276993, 0.000000, 0.743071>, <0.276993, 0.071753, 0.743071>, <0.246601, 0.145126, 0.743071>, <0.195864, 0.195864, 0.743071>, 
      <0.312500, 0.000000, 0.703125>, <0.312500, 0.071753, 0.703125>, <0.271708, 0.170234, 0.703125>, <0.220971, 0.220971, 0.703125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.265625, 0.000000, 0.875000>, <0.240903, 0.000000, 0.827616>, <0.276993, 0.000000, 0.743071>, <0.312500, 0.000000, 0.703125>, 
      <0.265625, -0.060990, 0.875000>, <0.240903, -0.060990, 0.827616>, <0.276993, -0.071753, 0.743071>, <0.312500, -0.071753, 0.703125>, 
      <0.230952, -0.144699, 0.875000>, <0.213470, -0.127217, 0.827616>, <0.246601, -0.145126, 0.743071>, <0.271708, -0.170234, 0.703125>, 
      <0.187825, -0.187825, 0.875000>, <0.170344, -0.170344, 0.827616>, <0.195864, -0.195864, 0.743071>, <0.220971, -0.220971, 0.703125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, 0.000000, 1.062500>, <0.500000, 0.114805, 1.062500>, <0.434732, 0.272374, 1.062500>, <0.353553, 0.353553, 1.062500>, 
      <0.429688, 0.000000, 1.006250>, <0.429687, 0.114805, 1.006250>, <0.385014, 0.222655, 1.006250>, <0.303835, 0.303835, 1.006250>, 
      <0.307276, 0.000000, 0.954832>, <0.307276, 0.060990, 0.954832>, <0.260403, 0.174150, 0.954832>, <0.217277, 0.217277, 0.954832>, 
      <0.265625, 0.000000, 0.875000>, <0.265625, 0.060990, 0.875000>, <0.230952, 0.144699, 0.875000>, <0.187825, 0.187825, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, 0.000000, 1.062500>, <0.429688, 0.000000, 1.006250>, <0.307276, 0.000000, 0.954832>, <0.265625, 0.000000, 0.875000>, 
      <0.500000, -0.114805, 1.062500>, <0.429688, -0.114805, 1.006250>, <0.307276, -0.060990, 0.954832>, <0.265625, -0.060990, 0.875000>, 
      <0.434733, -0.272374, 1.062500>, <0.385015, -0.222655, 1.006250>, <0.260404, -0.174150, 0.954832>, <0.230952, -0.144699, 0.875000>, 
      <0.353554, -0.353553, 1.062500>, <0.303835, -0.303835, 1.006250>, <0.217277, -0.217277, 0.954832>, <0.187825, -0.187825, 0.875000>
    }
  }
  material {
    HeadCheese
  }
  scale 7.0
  translate  <-108.86505, -5.006292, 55.751077>
}
#declare FlatPlantBowl = lathe {
  quadratic_spline
  5  // control points
  <1.0, -1.011655>,
  <0.065268, -0.954545>,
  <1.369403, -0.91397>,
  <2.06993, -0.758741>,
  <2.398601, -0.223776>
  rotate <90,0,90>
  material {
    Pierre2
  }
  scale 2.0
  translate  <-100.730906, 5.860512, 52.06941>
}
#declare FlatCurvedLeftFrontBowl = lathe {
  quadratic_spline
  10  // control points
  <0.74359, -1.11655>,
  <0.076923, -0.954545>,
  <0.213706, -0.813613>,
  <0.356643, -0.677156>,
  <0.59704, -0.89751>,
  <0.915406, -0.937638>,
  <1.019972, -0.780624>,
  <0.978178, -0.662327>,
  <1.077696, -0.466233>,
  <1.198135, -0.631702>
  rotate <90,0,90>
  material {
    Brown_Agate_Moray
  }
  scale 5.338403
  translate  <-93.723871, -4.187806, 55.312455>
}
#declare ThingsOnTable = union {
  object { PlantBowl }
  object { FrontPlantVase }
  object { FlatPlantBowl }
  object { FlatCurvedLeftFrontBowl }
}
union { // Table
  object { TableLegs }
  object { TableTopDiff }
  object { ThingsOnTable }
  rotate -30.830572*z
  translate  <-55.970342, -55.483644, -0.269563>
}


#declare OneRowPath = union {
  superellipsoid { // PathStone
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone1
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone2
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  -2.936653*z
}
#declare OneRowPath2 = union {
  superellipsoid { // PathStone3
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone4
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone5
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 22.211574, -2.936653>
}
#declare OneRowPath3 = union {
  superellipsoid { // PathStone6
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone7
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone8
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 44.423147, -2.936653>
}
#declare PathUniNearGazebo = union {
  object { OneRowPath }
  object { OneRowPath2 }
  object { OneRowPath3 }
  superellipsoid { // PathStone9
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 129.117262, 12.333942>
  }
  material {
    Granit_DO
  }
  translate  3.236755*z
}
#declare OneRowPath1 = union {
  superellipsoid { // PathStone10
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone11
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone12
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  -2.936653*z
}
#declare OneRowPath4 = union {
  superellipsoid { // PathStone13
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone14
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone15
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 22.211574, -2.936653>
}
#declare OneRowPath5 = union {
  superellipsoid { // PathStone16
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone17
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone18
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 44.423147, -2.936653>
}
#declare ThreeRows = union {
  object { OneRowPath1 }
  object { OneRowPath4 }
  object { OneRowPath5 }
}
#declare OneRowPath6 = union {
  superellipsoid { // PathStone19
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone20
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone21
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  -2.936653*z
}
#declare OneRowPath7 = union {
  superellipsoid { // PathStone22
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone23
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone24
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 22.211574, -2.936653>
}
#declare OneRowPath8 = union {
  superellipsoid { // PathStone25
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone26
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone27
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 44.423147, -2.936653>
}
#declare ThreeRows2 = union {
  object { OneRowPath6 }
  object { OneRowPath7 }
  object { OneRowPath8 }
  translate  <-0.0, 66.689406, 0.0>
}
#declare SixRows = union {
  object { ThreeRows }
  object { ThreeRows2 }
}
#declare OneRowPath9 = union {
  superellipsoid { // PathStone28
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone29
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone30
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  -2.936653*z
}
#declare OneRowPath10 = union {
  superellipsoid { // PathStone31
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone32
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone33
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 22.211574, -2.936653>
}
#declare OneRowPath11 = union {
  superellipsoid { // PathStone34
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone35
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone36
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 44.423147, -2.936653>
}
#declare ThreeRows1 = union {
  object { OneRowPath9 }
  object { OneRowPath10 }
  object { OneRowPath11 }
}
#declare OneRowPath12 = union {
  superellipsoid { // PathStone37
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone38
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone39
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  -2.936653*z
}
#declare OneRowPath13 = union {
  superellipsoid { // PathStone40
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone41
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone42
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 22.211574, -2.936653>
}
#declare OneRowPath14 = union {
  superellipsoid { // PathStone43
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone44
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone45
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 44.423147, -2.936653>
}
#declare ThreeRows3 = union {
  object { OneRowPath12 }
  object { OneRowPath13 }
  object { OneRowPath14 }
  translate  <-0.0, 66.689406, 0.0>
}
#declare SixRows2 = union {
  object { ThreeRows1 }
  object { ThreeRows3 }
  translate  <-0.0, 133.378812, 0.0>
}
#declare OneRowPath15 = union {
  superellipsoid { // PathStone46
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone47
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone48
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  -2.936653*z
}
#declare OneRowPath16 = union {
  superellipsoid { // PathStone49
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone50
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone51
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 22.211574, -2.936653>
}
#declare OneRowPath17 = union {
  superellipsoid { // PathStone52
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone53
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone54
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 44.423147, -2.936653>
}
#declare ThreeRows4 = union {
  object { OneRowPath15 }
  object { OneRowPath16 }
  object { OneRowPath17 }
}
#declare OneRowPath18 = union {
  superellipsoid { // PathStone55
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone56
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone57
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  -2.936653*z
}
#declare OneRowPath19 = union {
  superellipsoid { // PathStone58
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone59
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone60
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 22.211574, -2.936653>
}
#declare OneRowPath20 = union {
  superellipsoid { // PathStone61
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone62
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone63
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 44.423147, -2.936653>
}
#declare ThreeRows5 = union {
  object { OneRowPath18 }
  object { OneRowPath19 }
  object { OneRowPath20 }
  translate  <-0.0, 66.689406, 0.0>
}
#declare SixRows3 = union {
  object { ThreeRows4 }
  object { ThreeRows5 }
  translate  <-0.0, 268.176548, 0.0>
}
#declare OneRowPath21 = union {
  superellipsoid { // PathStone64
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone65
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone66
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  -2.936653*z
}
#declare OneRowPath22 = union {
  superellipsoid { // PathStone67
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone68
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone69
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 22.211574, -2.936653>
}
#declare OneRowPath23 = union {
  superellipsoid { // PathStone70
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone71
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone72
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 44.423147, -2.936653>
}
#declare ThreeRows6 = union {
  object { OneRowPath21 }
  object { OneRowPath22 }
  object { OneRowPath23 }
}
#declare OneRowPath24 = union {
  superellipsoid { // PathStone73
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone74
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone75
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  -2.936653*z
}
#declare OneRowPath25 = union {
  superellipsoid { // PathStone76
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone77
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone78
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 22.211574, -2.936653>
}
#declare OneRowPath26 = union {
  superellipsoid { // PathStone79
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone80
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone81
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 44.423147, -2.936653>
}
#declare ThreeRows7 = union {
  object { OneRowPath24 }
  object { OneRowPath25 }
  object { OneRowPath26 }
  translate  <-0.0, 66.689406, 0.0>
}
#declare SixRows4 = union {
  object { ThreeRows6 }
  object { ThreeRows7 }
  translate  <-0.0, 401.55536, 0.0>
}
#declare OneRowPath75 = union {
  superellipsoid { // PathStone82
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone227
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone228
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  -2.936653*z
}
#declare OneRowPath76 = union {
  superellipsoid { // PathStone229
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone230
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone231
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 22.211574, -2.936653>
}
#declare OneRowPath77 = union {
  superellipsoid { // PathStone232
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone233
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone234
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 44.423147, -2.936653>
}
#declare ThreeRows24 = union {
  object { OneRowPath75 }
  object { OneRowPath76 }
  object { OneRowPath77 }
}
#declare SixRows12 = union {
  object { ThreeRows24 }
  translate  <-0.0, 534.948716, 0.0>
}
#declare PathUniRightGazebo = union {
  object { SixRows }
  object { SixRows2 }
  object { SixRows3 }
  object { SixRows4 }
  object { SixRows12 }
  material {
    Granit_DO
  }
  rotate -90.0*z
  translate  <-1112.805366, 129.610275, 0.421744>
}
#declare OneRowPath27 = union {
  superellipsoid { // PathStone83
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone84
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone85
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  -2.936653*z
}
#declare OneRowPath28 = union {
  superellipsoid { // PathStone86
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone87
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone88
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 22.211574, -2.936653>
}
#declare OneRowPath29 = union {
  superellipsoid { // PathStone89
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone90
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone91
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 44.423147, -2.936653>
}
#declare ThreeRows8 = union {
  object { OneRowPath27 }
  object { OneRowPath28 }
  object { OneRowPath29 }
}
#declare OneRowPath30 = union {
  superellipsoid { // PathStone92
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone93
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone94
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  -2.936653*z
}
#declare OneRowPath31 = union {
  superellipsoid { // PathStone95
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone96
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone97
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 22.211574, -2.936653>
}
#declare OneRowPath32 = union {
  superellipsoid { // PathStone98
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone99
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone100
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 44.423147, -2.936653>
}
#declare ThreeRows9 = union {
  object { OneRowPath30 }
  object { OneRowPath31 }
  object { OneRowPath32 }
  translate  <-0.0, 66.689406, 0.0>
}
#declare SixRows1 = union {
  object { ThreeRows8 }
  object { ThreeRows9 }
}
#declare OneRowPath33 = union {
  superellipsoid { // PathStone101
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone102
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone103
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  -2.936653*z
}
#declare OneRowPath34 = union {
  superellipsoid { // PathStone104
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone105
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone106
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 22.211574, -2.936653>
}
#declare OneRowPath35 = union {
  superellipsoid { // PathStone107
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone108
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone109
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 44.423147, -2.936653>
}
#declare ThreeRows10 = union {
  object { OneRowPath33 }
  object { OneRowPath34 }
  object { OneRowPath35 }
}
#declare OneRowPath36 = union {
  superellipsoid { // PathStone110
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone111
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone112
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  -2.936653*z
}
#declare OneRowPath37 = union {
  superellipsoid { // PathStone113
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone114
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone115
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 22.211574, -2.936653>
}
#declare OneRowPath38 = union {
  superellipsoid { // PathStone116
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone117
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone118
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 44.423147, -2.936653>
}
#declare ThreeRows11 = union {
  object { OneRowPath36 }
  object { OneRowPath37 }
  object { OneRowPath38 }
  translate  <-0.0, 66.689406, 0.0>
}
#declare SixRows5 = union {
  object { ThreeRows10 }
  object { ThreeRows11 }
  translate  <-0.0, 133.378812, 0.0>
}
#declare OneRowPath39 = union {
  superellipsoid { // PathStone119
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone120
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone121
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  -2.936653*z
}
#declare OneRowPath40 = union {
  superellipsoid { // PathStone122
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone123
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone124
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 22.211574, -2.936653>
}
#declare OneRowPath41 = union {
  superellipsoid { // PathStone125
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone126
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone127
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 44.423147, -2.936653>
}
#declare ThreeRows12 = union {
  object { OneRowPath39 }
  object { OneRowPath40 }
  object { OneRowPath41 }
}
#declare OneRowPath42 = union {
  superellipsoid { // PathStone128
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone129
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone130
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  -2.936653*z
}
#declare OneRowPath43 = union {
  superellipsoid { // PathStone131
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone132
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone133
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 22.211574, -2.936653>
}
#declare OneRowPath44 = union {
  superellipsoid { // PathStone134
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone135
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone136
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 44.423147, -2.936653>
}
#declare ThreeRows13 = union {
  object { OneRowPath42 }
  object { OneRowPath43 }
  object { OneRowPath44 }
  translate  <-0.0, 66.689406, 0.0>
}
#declare SixRows6 = union {
  object { ThreeRows12 }
  object { ThreeRows13 }
  translate  <-0.0, 268.176548, 0.0>
}
#declare OneRowPath45 = union {
  superellipsoid { // PathStone137
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone138
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone139
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  -2.936653*z
}
#declare OneRowPath46 = union {
  superellipsoid { // PathStone140
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone141
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone142
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 22.211574, -2.936653>
}
#declare OneRowPath47 = union {
  superellipsoid { // PathStone143
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone144
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone145
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 44.423147, -2.936653>
}
#declare ThreeRows14 = union {
  object { OneRowPath45 }
  object { OneRowPath46 }
  object { OneRowPath47 }
}
#declare OneRowPath48 = union {
  superellipsoid { // PathStone146
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone147
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone148
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  -2.936653*z
}
#declare OneRowPath49 = union {
  superellipsoid { // PathStone149
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone150
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone151
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 22.211574, -2.936653>
}
#declare OneRowPath50 = union {
  superellipsoid { // PathStone152
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone153
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone154
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 44.423147, -2.936653>
}
#declare ThreeRows15 = union {
  object { OneRowPath48 }
  object { OneRowPath49 }
  object { OneRowPath50 }
  translate  <-0.0, 66.689406, 0.0>
}
#declare SixRows7 = union {
  object { ThreeRows14 }
  object { ThreeRows15 }
  translate  <-0.0, 401.55536, 0.0>
}
#declare PathUniTopGazebo = union {
  object { SixRows1 }
  object { SixRows5 }
  object { SixRows6 }
  object { SixRows7 }
  material {
    Granit_DO
  }
  rotate -180.0*z
  translate  <-1224.192481, 340.180533, 0.363546>
}
#declare OneRowPath51 = union {
  superellipsoid { // PathStone155
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone156
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone157
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  -2.936653*z
}
#declare OneRowPath52 = union {
  superellipsoid { // PathStone158
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone159
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone160
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 22.211574, -2.936653>
}
#declare OneRowPath53 = union {
  superellipsoid { // PathStone161
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone162
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone163
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 44.423147, -2.936653>
}
#declare ThreeRows16 = union {
  object { OneRowPath51 }
  object { OneRowPath52 }
  object { OneRowPath53 }
}
#declare OneRowPath54 = union {
  superellipsoid { // PathStone164
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone165
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone166
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  -2.936653*z
}
#declare OneRowPath55 = union {
  superellipsoid { // PathStone167
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone168
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone169
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 22.211574, -2.936653>
}
#declare OneRowPath56 = union {
  superellipsoid { // PathStone170
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone171
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone172
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 44.423147, -2.936653>
}
#declare ThreeRows17 = union {
  object { OneRowPath54 }
  object { OneRowPath55 }
  object { OneRowPath56 }
  translate  <-0.0, 66.689406, 0.0>
}
#declare SixRows8 = union {
  object { ThreeRows16 }
  object { ThreeRows17 }
}
#declare OneRowPath57 = union {
  superellipsoid { // PathStone173
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone174
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone175
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  -2.936653*z
}
#declare OneRowPath58 = union {
  superellipsoid { // PathStone176
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone177
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone178
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 22.211574, -2.936653>
}
#declare OneRowPath59 = union {
  superellipsoid { // PathStone179
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone180
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone181
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 44.423147, -2.936653>
}
#declare ThreeRows18 = union {
  object { OneRowPath57 }
  object { OneRowPath58 }
  object { OneRowPath59 }
}
#declare OneRowPath60 = union {
  superellipsoid { // PathStone182
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone183
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone184
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  -2.936653*z
}
#declare OneRowPath61 = union {
  superellipsoid { // PathStone185
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone186
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone187
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 22.211574, -2.936653>
}
#declare OneRowPath62 = union {
  superellipsoid { // PathStone188
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone189
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone190
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 44.423147, -2.936653>
}
#declare ThreeRows19 = union {
  object { OneRowPath60 }
  object { OneRowPath61 }
  object { OneRowPath62 }
  translate  <-0.0, 66.689406, 0.0>
}
#declare SixRows9 = union {
  object { ThreeRows18 }
  object { ThreeRows19 }
  translate  <-0.0, 133.378812, 0.0>
}
#declare OneRowPath63 = union {
  superellipsoid { // PathStone191
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone192
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone193
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  -2.936653*z
}
#declare OneRowPath64 = union {
  superellipsoid { // PathStone194
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone195
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone196
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 22.211574, -2.936653>
}
#declare OneRowPath65 = union {
  superellipsoid { // PathStone197
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone198
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone199
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 44.423147, -2.936653>
}
#declare ThreeRows20 = union {
  object { OneRowPath63 }
  object { OneRowPath64 }
  object { OneRowPath65 }
}
#declare OneRowPath66 = union {
  superellipsoid { // PathStone200
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone201
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone202
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  -2.936653*z
}
#declare OneRowPath67 = union {
  superellipsoid { // PathStone203
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone204
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone205
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 22.211574, -2.936653>
}
#declare OneRowPath68 = union {
  superellipsoid { // PathStone206
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone207
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone208
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 44.423147, -2.936653>
}
#declare ThreeRows21 = union {
  object { OneRowPath66 }
  object { OneRowPath67 }
  object { OneRowPath68 }
  translate  <-0.0, 66.689406, 0.0>
}
#declare SixRows10 = union {
  object { ThreeRows20 }
  object { ThreeRows21 }
  translate  <-0.0, 268.176548, 0.0>
}
#declare OneRowPath69 = union {
  superellipsoid { // PathStone209
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone210
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone211
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  -2.936653*z
}
#declare OneRowPath70 = union {
  superellipsoid { // PathStone212
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone213
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone214
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 22.211574, -2.936653>
}
#declare OneRowPath71 = union {
  superellipsoid { // PathStone215
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone216
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone217
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 44.423147, -2.936653>
}
#declare ThreeRows22 = union {
  object { OneRowPath69 }
  object { OneRowPath70 }
  object { OneRowPath71 }
}
#declare OneRowPath72 = union {
  superellipsoid { // PathStone218
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone219
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone220
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  -2.936653*z
}
#declare OneRowPath73 = union {
  superellipsoid { // PathStone221
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone222
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone223
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 22.211574, -2.936653>
}
#declare OneRowPath74 = union {
  superellipsoid { // PathStone224
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone225
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone226
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <0.0, 44.423147, -2.936653>
}
#declare OneRowPath78 = union {
  superellipsoid { // PathStone235
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone236
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone237
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <-0.0, 67.018611, -2.936653>
}
#declare OneRowPath79 = union {
  superellipsoid { // PathStone238
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone239
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone240
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <-0.0, 89.614075, -2.936653>
}
#declare OneRowPath80 = union {
  superellipsoid { // PathStone241
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone242
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone243
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <-0.0, 111.544966, -2.936653>
}
#declare OneRowPath81 = union {
  superellipsoid { // PathStone244
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-149.895166, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone245
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-126.435844, 62.482542, 15.270595>
  }
  superellipsoid { // PathStone246
    <0.1, 0.5>
    scale <10.188609, 10.188609, 4.315303>
    translate  <-102.709845, 62.482542, 15.270595>
  }
  translate  <-0.0, 134.14043, -2.936653>
}
#declare ThreeRows23 = union {
  object { OneRowPath72 }
  object { OneRowPath73 }
  object { OneRowPath74 }
  object { OneRowPath78 }
  object { OneRowPath79 }
  object { OneRowPath80 }
  object { OneRowPath81 }
  translate  <-0.0, 66.689406, 0.0>
}
#declare SixRows11 = union {
  object { ThreeRows22 }
  object { ThreeRows23 }
  translate  <-0.0, 401.55536, 0.0>
}
#declare PathUniLeftGazebo = union {
  object { SixRows8 }
  object { SixRows9 }
  object { SixRows10 }
  object { SixRows11 }
  material {
    Granit_DO
  }
  rotate -90.0*z
  translate  <-1186.047342, -407.356844, 0.421744>
}
union { // Paths
  object { PathUniNearGazebo }
  object { PathUniRightGazebo }
  object { PathUniTopGazebo }
  object { PathUniLeftGazebo }
  translate  <-1.074127, 1.61119, 0.0>
}


#declare RoofRingDiff = difference {
  cylinder { // RoofRingCyl
    <0,0,1>, <0,0,0>, 1 
    scale <50.0, 50.92207, 3.101328>
    translate  <-126.584824, 1.721451, 112.12603>
  }
  cylinder { // RoofRingCyl1
    <0,0,1>, <0,0,0>, 1 
    scale <45.379948, 45.379951, 9.351262>
    translate  <-126.584824, 1.721451, 108.64033>
  }
  translate  -2.324999*z
}
#declare FloorPlankCutsUni = union {
  box { // PlankCut
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 54.945915, 2.211686>
    rotate 42.100857*z
    translate  <-142.507377, -7.963461, 21.396424>
  }
  box { // PlankCut1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 54.945915, 2.211686>
    rotate 42.100857*z
    translate  <-125.355307, 4.900592, 21.396424>
  }
  box { // PlankCut2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 54.945915, 2.211686>
    rotate 42.100857*z
    translate  <-109.428384, 19.602366, 21.396424>
  }
  box { // PlankCut3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 54.945915, 2.211686>
    rotate 42.100857*z
    translate  <-95.339184, 30.628697, 21.396424>
  }
  box { // PlankCut4
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 54.945915, 2.211686>
    rotate 42.100857*z
    translate  <-154.146282, -22.665236, 21.396424>
  }
}
#declare GazeboFloorDiff = difference {
  cylinder { // GazeboFloor
    <0,0,1>, <0,0,0>, 1 
    scale <50.0, 50.92207, 3.101328>
    translate  <-126.584824, 1.721451, 16.525598>
  }
  object { FloorPlankCutsUni }
}
#declare RoofRunesUni = union {
  text {   // TopRune16
    ttf      "C:\WINDOWS\Fonts\Wingding.ttf",
    "a",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <8.474401, 8.474402, 8.474402>
    rotate <-53.827358, -180.0, 90.0>
    translate  <-89.645999, -4.326638, 123.021918>
  }

  text {   // TopRune17
    ttf      "C:\WINDOWS\Fonts\Wingding.ttf",
    "b",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <8.474401, 8.474402, 8.474402>
    rotate <-53.827358, -180.0, 90.0>
    translate  <-89.645999, 4.803439, 123.021918>
  }

  text {   // TopRune18
    ttf      "C:\WINDOWS\Fonts\Wingding.ttf",
    "c",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <8.474401, 8.474402, 8.474402>
    rotate <-53.827358, -180.0, 90.0>
    translate  <-89.645999, 13.793472, 123.021918>
  }

  translate  <5.907964, 0.805595, -3.741737>
}
#declare GazeboRoofRuneDiff = difference {
  cone { // GazeboRoof
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      GazeboRoofTex
    }
    hollow
    scale -47.8269
    translate  <-126.248685, 1.829438, 158.821321>
  }
  object { RoofRunesUni }
}
#declare GazeboRoofRuneInt = intersection {
  cone { // GazeboRoof1
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    scale -47.8269
    translate  <-126.248685, 1.829438, 158.821321>
  }
  text {   // TopRune19
    ttf      "C:\WINDOWS\Fonts\Wingding.ttf",
    "a",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <8.474401, 8.474402, 8.474402>
    rotate <126.172638, 0.0, -90.0>
    translate  <-83.738035, -3.521043, 119.280181>
  }

}
#declare GazeboRoofRuneInt2 = intersection {
  cone { // GazeboRoof2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    scale -47.8269
    translate  <-126.248685, 1.829438, 158.821321>
  }
  text {   // TopRune21
    ttf      "C:\WINDOWS\Fonts\Wingding.ttf",
    "b",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <8.474401, 8.474402, 8.474402>
    rotate <126.172638, 0.0, -90.0>
    translate  <-83.738035, 5.609034, 119.280181>
  }

}
#declare GazeboRoofRuneInt3 = intersection {
  cone { // GazeboRoof3
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    scale -47.8269
    translate  <-126.248685, 1.829438, 158.821321>
  }
  text {   // TopRune23
    ttf      "C:\WINDOWS\Fonts\Wingding.ttf",
    "c",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <8.474401, 8.474402, 8.474402>
    rotate <126.172638, 0.0, -90.0>
    translate  <-83.738035, 14.599067, 119.280181>
  }

}
#declare GazeboRoofRuneInts = union {
  object { GazeboRoofRuneInt }
  object { GazeboRoofRuneInt2 }
  object { GazeboRoofRuneInt3 }
  material {
    RoofRuneMaterial
  }
}
#declare LeftRoofPostTopRuneDiff = difference {
  cylinder { // RoofPost3
    <0,0,1>, <0,0,0>, 1 
    scale <2.5, 2.5, 102.617096>
    translate  <-86.139092, -20.986608, 18.193826>
  }
  text {   // TopRune
    ttf      "C:\WINDOWS\Fonts\Wingding.ttf",
    "R",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <6.002142, 6.002144, 6.002144>
    rotate <-0.0, -90.0, -0.0>
    translate  <-80.193203, -23.164916, 99.174078>
  }

}
#declare LeftRoofPostTopRuneInt = intersection {
  cylinder { // RoofPost4
    <0,0,1>, <0,0,0>, 1 
    scale <2.5, 2.5, 102.617096>
    translate  <-86.139092, -20.986608, 18.193826>
  }
  text {   // TopRune1
    ttf      "C:\WINDOWS\Fonts\Wingding.ttf",
    "R",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <6.002142, 6.002144, 6.002144>
    rotate <-0.0, -90.0, -0.0>
    translate  <-80.193203, -23.164916, 99.174078>
  }

  material {
    RuneMaterial
  }
}
#declare FirstRune = union {
  object { LeftRoofPostTopRuneDiff }
  object { LeftRoofPostTopRuneInt }
}
#declare LeftRoofPostTopRuneDiff1 = difference {
  cylinder { // RoofPost5
    <0,0,1>, <0,0,0>, 1 
    scale <2.5, 2.5, 102.617096>
    translate  <-86.139092, -20.986608, 18.193826>
  }
  text {   // TopRune2
    ttf      "C:\WINDOWS\Fonts\Wingding.ttf",
    "P",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <6.002142, 6.002144, 6.002144>
    rotate <-0.0, -90.0, -0.0>
    translate  <-80.193203, -23.48315, 92.638575>
  }

}
#declare LeftRoofPostTopRuneInt1 = intersection {
  cylinder { // RoofPost6
    <0,0,1>, <0,0,0>, 1 
    scale <2.5, 2.5, 102.617096>
    translate  <-86.139092, -20.986608, 18.193826>
  }
  text {   // TopRune3
    ttf      "C:\WINDOWS\Fonts\Wingding.ttf",
    "P",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <6.002142, 6.002144, 6.002144>
    rotate <-0.0, -90.0, -0.0>
    translate  <-80.193203, -23.48315, 92.638575>
  }

  material {
    RuneMaterial
  }
}
#declare SecondRune = union {
  object { LeftRoofPostTopRuneDiff1 }
  object { LeftRoofPostTopRuneInt1 }
}
#declare LeftRoofPostTopRuneDiff2 = difference {
  cylinder { // RoofPost7
    <0,0,1>, <0,0,0>, 1 
    scale <2.5, 2.5, 102.617096>
    translate  <-86.139092, -20.986608, 18.193826>
  }
  text {   // TopRune4
    ttf      "C:\WINDOWS\Fonts\Wingding.ttf",
    "T",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <6.002142, 6.002144, 6.002144>
    rotate <-0.0, -90.0, -0.0>
    translate  <-80.193203, -23.264337, 87.239681>
  }

}
#declare LeftRoofPostTopRuneInt2 = intersection {
  cylinder { // RoofPost8
    <0,0,1>, <0,0,0>, 1 
    scale <2.5, 2.5, 102.617096>
    translate  <-86.139092, -20.986608, 18.193826>
  }
  text {   // TopRune5
    ttf      "C:\WINDOWS\Fonts\Wingding.ttf",
    "T",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <6.002142, 6.002144, 6.002144>
    rotate <-0.0, -90.0, -0.0>
    translate  <-80.193203, -23.264337, 87.239681>
  }

  material {
    RuneMaterial
  }
}
#declare ThirdRune = union {
  object { LeftRoofPostTopRuneDiff2 }
  object { LeftRoofPostTopRuneInt2 }
}
#declare LeftRoofPostTopRuneDiff3 = difference {
  cylinder { // RoofPost9
    <0,0,1>, <0,0,0>, 1 
    scale <2.5, 2.5, 102.617096>
    translate  <-86.139092, -20.986608, 18.193826>
  }
  text {   // TopRune6
    ttf      "C:\WINDOWS\Fonts\Wingding.ttf",
    "W",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <6.002142, 6.002144, 6.002144>
    rotate <-0.0, -90.0, -0.0>
    translate  <-80.161945, -23.143065, 82.409092>
  }

}
#declare LeftRoofPostTopRuneInt3 = intersection {
  cylinder { // RoofPost10
    <0,0,1>, <0,0,0>, 1 
    scale <2.5, 2.5, 102.617096>
    translate  <-86.139092, -20.986608, 18.193826>
  }
  text {   // TopRune7
    ttf      "C:\WINDOWS\Fonts\Wingding.ttf",
    "W",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <6.002142, 6.002144, 6.002144>
    rotate <-0.0, -90.0, -0.0>
    translate  <-80.161945, -23.143065, 82.409092>
  }

  material {
    RuneMaterial
  }
}
#declare FourthRune = union {
  object { LeftRoofPostTopRuneDiff3 }
  object { LeftRoofPostTopRuneInt3 }
}
#declare LeftFrontPost = union {
  object { FirstRune }
  object { SecondRune }
  object { ThirdRune }
  object { FourthRune }
}
#declare RightFrontPostTopRuneDiff = difference {
  cylinder { // RoofPost
    <0,0,1>, <0,0,0>, 1 
    scale <2.5, 2.5, 102.617096>
    translate  <-86.139092, 25.727246, 18.193826>
  }
  text {   // TopRune8
    ttf      "C:\WINDOWS\Fonts\Wingding.ttf",
    "Y",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <6.002142, 6.002144, 6.002144>
    rotate <-0.0, -90.0, -0.0>
    translate  <-80.193203, 23.496219, 99.174078>
  }

}
#declare RightFrontPostTopRuneInt = intersection {
  cylinder { // RoofPost11
    <0,0,1>, <0,0,0>, 1 
    scale <2.5, 2.5, 102.617096>
    translate  <-86.139092, 25.727246, 18.193826>
  }
  text {   // TopRune9
    ttf      "C:\WINDOWS\Fonts\Wingding.ttf",
    "Y",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <6.002142, 6.002144, 6.002144>
    rotate <-0.0, -90.0, -0.0>
    translate  <-80.193203, 23.496219, 99.174078>
  }

  material {
    RuneMaterial
  }
}
#declare FirstRune1 = union {
  object { RightFrontPostTopRuneDiff }
  object { RightFrontPostTopRuneInt }
}
#declare RightFrontPostTopRuneDiff1 = difference {
  cylinder { // RoofPost12
    <0,0,1>, <0,0,0>, 1 
    scale <2.5, 2.5, 102.617096>
    translate  <-86.139092, 25.727246, 18.193826>
  }
  text {   // TopRune10
    ttf      "C:\WINDOWS\Fonts\Wingding.ttf",
    "a",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <6.002142, 6.002144, 6.002144>
    rotate <-0.0, -90.0, -0.0>
    translate  <-80.193203, 23.496219, 91.757301>
  }

}
#declare RightFrontPostTopRuneInt1 = intersection {
  cylinder { // RoofPost13
    <0,0,1>, <0,0,0>, 1 
    scale <2.5, 2.5, 102.617096>
    translate  <-86.139092, 25.727246, 18.193826>
  }
  text {   // TopRune11
    ttf      "C:\WINDOWS\Fonts\Wingding.ttf",
    "a",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <6.002142, 6.002144, 6.002144>
    rotate <-0.0, -90.0, -0.0>
    translate  <-80.193203, 23.496219, 91.757301>
  }

  material {
    RuneMaterial
  }
}
#declare SecondRune1 = union {
  object { RightFrontPostTopRuneDiff1 }
  object { RightFrontPostTopRuneInt1 }
}
#declare RightFrontPostTopRuneDiff2 = difference {
  cylinder { // RoofPost14
    <0,0,1>, <0,0,0>, 1 
    scale <2.5, 2.5, 102.617096>
    translate  <-86.139092, 25.727246, 18.193826>
  }
  text {   // TopRune12
    ttf      "C:\WINDOWS\Fonts\Wingding.ttf",
    "b",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <6.002142, 6.002144, 6.002144>
    rotate <-90.0, -180.0, 90.0>
    translate  <-80.193203, 28.090533, 85.014777>
  }

}
#declare RightFrontPostTopRuneInt2 = intersection {
  cylinder { // RoofPost15
    <0,0,1>, <0,0,0>, 1 
    scale <2.5, 2.5, 102.617096>
    translate  <-86.139092, 25.727246, 18.193826>
  }
  text {   // TopRune13
    ttf      "C:\WINDOWS\Fonts\Wingding.ttf",
    "b",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <6.002142, 6.002144, 6.002144>
    rotate <-90.0, -180.0, 90.0>
    translate  <-80.193203, 28.090533, 85.014777>
  }

  material {
    RuneMaterial
  }
}
#declare ThirdRune1 = union {
  object { RightFrontPostTopRuneDiff2 }
  object { RightFrontPostTopRuneInt2 }
}
#declare RightFrontPostTopRuneDiff3 = difference {
  cylinder { // RoofPost16
    <0,0,1>, <0,0,0>, 1 
    scale <2.5, 2.5, 102.617096>
    translate  <-86.139092, 25.727246, 18.193826>
  }
  text {   // TopRune14
    ttf      "C:\WINDOWS\Fonts\Wingding.ttf",
    "c",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <6.002142, 6.002144, 6.002144>
    rotate <-90.0, -180.0, 90.0>
    translate  <-80.193203, 28.090533, 77.373249>
  }

}
#declare RightFrontPostTopRuneInt3 = intersection {
  cylinder { // RoofPost17
    <0,0,1>, <0,0,0>, 1 
    scale <2.5, 2.5, 102.617096>
    translate  <-86.139092, 25.727246, 18.193826>
  }
  text {   // TopRune15
    ttf      "C:\WINDOWS\Fonts\Wingding.ttf",
    "c",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <6.002142, 6.002144, 6.002144>
    rotate <-90.0, -180.0, 90.0>
    translate  <-80.193203, 28.090533, 77.373249>
  }

  material {
    RuneMaterial
  }
}
#declare FourthRune1 = union {
  object { RightFrontPostTopRuneDiff3 }
  object { RightFrontPostTopRuneInt3 }
}
#declare RightFrontPost = union {
  object { FirstRune1 }
  object { SecondRune1 }
  object { ThirdRune1 }
  object { FourthRune1 }
}
#declare RoofPosts = union {
  cylinder { // RoofPost1
    <0,0,1>, <0,0,0>, 1 
    scale <2.5, 2.5, 102.617096>
    translate  <-166.733322, -22.526625, 18.193826>
  }
  cylinder { // RoofPost2
    <0,0,1>, <0,0,0>, 1 
    scale <2.5, 2.5, 102.617096>
    translate  <-166.733322, 25.727246, 18.193826>
  }
  object { LeftFrontPost }
  object { RightFrontPost }
  translate  -2.697296*z
}
#declare LeftMetalRuneCubeDiff = difference {
  box { // MetalRuneCube
    <-1, -1, -1>, <1, 1, 1>
    material {
      ki_Gold
    }
    scale <16.421158, 1.514268, 4.954984>
    rotate <0.0, -0.0, 32.0>
    translate  <-103.315543, -36.478106, 91.097803>
  }
  box { // MetalRuneCutCube
    <-1, -1, -1>, <1, 1, 1>
    scale <14.352301, 2.43376, 3.454767>
    rotate <0.0, -0.0, 32.0>
    translate  <-103.315543, -36.478106, 91.097803>
  }
}
#declare LeftMetalRuneCubeUni = union {
  object { LeftMetalRuneCubeDiff }
  text {   // RuneText
    ttf      "C:\WINDOWS\Fonts\Wingding.ttf",
    "deg",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <7.082895, 7.082895, 4.686301>
    rotate <90.0, -0.0, 32.0>
    translate  <-113.339703, -40.149418, 89.262906>
  }

  material {
    ki_Gold
  }
}
#declare LeftMetalRuneCubeDiff1 = difference {
  box { // MetalRuneCube1
    <-1, -1, -1>, <1, 1, 1>
    material {
      ki_Gold
    }
    scale <16.421158, 1.514268, 4.954984>
    rotate <0.0, -0.0, -90.0>
    translate  <-103.315543, -36.478106, 91.097803>
  }
  box { // MetalRuneCutCube1
    <-1, -1, -1>, <1, 1, 1>
    scale <14.352301, 2.43376, 3.454767>
    rotate <0.0, -0.0, -90.0>
    translate  <-103.315543, -36.478106, 91.097803>
  }
  translate  <16.602108, 38.36352, -0.321926>
}
#declare MiddleMetalRuneCubeUni = union {
  object { LeftMetalRuneCubeDiff1 }
  text {   // RuneText1
    ttf      "C:\WINDOWS\Fonts\Wingding.ttf",
    "fhi",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <8.452671, 8.178716, 4.686301>
    rotate <90.0, -0.0, -90.0>
    translate  <-84.853114, 12.603783, 87.621165>
  }

  material {
    ki_Gold
  }
  translate  <5.060351, -0.389258, 0.0>
}
#declare LeftMetalRuneCubeDiff2 = difference {
  box { // MetalRuneCube2
    <-1, -1, -1>, <1, 1, 1>
    material {
      ki_Gold
    }
    scale <16.421158, 1.514268, 4.954984>
    rotate <0.0, -0.0, -32.0>
    translate  <-103.315543, -36.478106, 91.097803>
  }
  box { // MetalRuneCutCube2
    <-1, -1, -1>, <1, 1, 1>
    scale <14.352301, 2.43376, 3.454767>
    rotate <0.0, -0.0, -32.0>
    translate  <-103.315543, -36.478106, 91.097803>
  }
  translate  <-6.831092, 78.395237, -0.321926>
}
#declare RightMetalRuneCube = union {
  object { LeftMetalRuneCubeDiff2 }
  text {   // RuneText2
    ttf      "C:\WINDOWS\Fonts\Wingding.ttf",
    "jkl",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <8.452671, 8.178716, 4.686301>
    rotate <90.0, -0.0, -32.0>
    translate  <-118.538339, 50.194542, 87.621165>
  }

  material {
    ki_Gold
  }
  translate  <5.060351, -0.389258, 0.0>
}
#declare MetalRuneCubes = union {
  object { LeftMetalRuneCubeUni }
  object { MiddleMetalRuneCubeUni }
  object { RightMetalRuneCube }
}
#declare BigPotOnFloor = lathe {
  quadratic_spline
  8  // control points
  <1.0, -1.0>,
  <0.018648, -0.651515>,
  <0.822552, -0.671474>,
  <1.732214, -0.28965>,
  <2.0, 0.5>,
  <1.383401, 0.954903>,
  <0.90522, 1.002053>,
  <0.7669, 0.81352>
  rotate <90,0,90>
  material {
    Pierre12
  }
  scale 8.043994
  translate  <-127.522186, 30.066405, 25.251808>
}
union { // Gazebo
  object { RoofRingDiff }
  object { GazeboFloorDiff }
  cylinder { // GazeboBase
    <0,0,1>, <0,0,0>, 1 
    material {
      Asteroid
    }
    scale <50.0, 50.92207, 6.362239>
    translate  <-126.584824, 1.721451, 10.003776>
  }
  object { GazeboRoofRuneDiff }
  object { GazeboRoofRuneInts }
  object { RoofPosts }
  object { MetalRuneCubes }
  object { BigPotOnFloor }
  material {
    EMBWood1_Moray
  }
}




