//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 15 lights, 27 materials and 216 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.2 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 09/01/2000    (01.09.2000)
//



/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment


// Scene Includes

#include "C:\programs\pov31\scenes\gal1.inc"

// End Scene Includes

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera DesignCam1
  location  <    -42.790,     -32.795,      40.661>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.34707,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         30.00000    // Vertical      22.500
  look_at   <     -5.138,      -3.013,      10.968>
}

//    Other cameras are commented out.
/*
camera {  //  Camera StdCam
  location  <      0.000,      -0.001,      50.000>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35836,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         40.00000    // Vertical      30.000
  look_at   <      0.000,       0.000,       0.000>
}

*/

/*
camera {  //  Camera RWallCam
  location  <    -43.455,       0.000,      14.274>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.34707,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         30.00000    // Vertical      22.500
  look_at   <     -5.138,       0.000,      10.968>
}

*/

/*
camera {  //  Camera SpotCam001
  location  <     30.476,       0.000,      27.427> // Attached to Spotlight001
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.38459,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         55.72852    // Vertical      41.796
  look_at   <     29.760,       0.000,      26.728> // Following Spotlight001
}

*/

/*
camera {  //  Camera BookCam
  location  <      4.988,      -9.207,      18.482>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.34707,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         30.00000    // Vertical      22.500
  look_at   <     13.296,      -6.502,       7.570>
}

*/

/*
camera {  //  Camera LabraCam
  location  <      6.767,       8.098,      16.233>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.34707,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         30.00000    // Vertical      22.500
  look_at   <     16.542,      -3.485,      13.979>
}

*/

/*
camera {  //  Camera LabraCam2
  location  <      1.864,      -5.498,      19.632>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.34707,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         30.00000    // Vertical      22.500
  look_at   <     16.542,      -3.485,      13.979>
}

*/

/*
camera {  //  Camera BustCam
  location  <    -13.550,       6.491,       6.146>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.34707,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         30.00000    // Vertical      22.500
  look_at   <      4.567,       6.251,       3.364>
}

*/

/*
camera {  //  Camera LegSetCam
  location  <    -11.007,      10.583,       6.214>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.34707,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         30.00000    // Vertical      22.500
  look_at   <     -3.704,       4.125,       0.886>
}

*/

/*
camera {  //  Camera SmallTableCam
  location  <      8.347,      -1.429,       3.006>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.34707,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         30.00000    // Vertical      22.500
  look_at   <     11.609,       0.685,       1.355>
}

*/

/*
camera {  //  Camera Bee_Cam
  location  <    -10.448,       0.805,      13.498>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.34707,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         30.00000    // Vertical      22.500
  look_at   <     -5.295,       8.367,      12.494>
}

*/

//
// *******  L I G H T S *******
//

#declare Light001 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <0.500, 0.500, 0.500>
  media_interaction off
  scale 0.25
  translate  <16.42786, -5.063581, 16.346228>
}

#declare Light002 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <0.500, 0.500, 0.500>
  media_interaction off
  scale 0.25
  translate  <14.808205, -3.595816, 16.676005>
}

#declare Light003 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <0.500, 0.500, 0.500>
  media_interaction off
  scale 0.25
  translate  <14.805564, -6.742322, 16.676005>
}

#declare SideboardCandleLight = light_source {
  <0.0, 0.0, 0.0>
  color rgb <0.500, 0.500, 0.500>
  media_interaction off
  scale 0.25
  translate  <12.587828, -3.728865, 10.781748>
}

#declare SideboardCandleLight1 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <0.500, 0.500, 0.500>
  media_interaction off
  scale 0.25
  translate  <16.491177, -9.110466, 10.786836>
}

#declare Spotlight009 = light_source {   // Spotlight Spotlight009
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.000, 0.009>
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    21.629  // outer radius (in deg)
    radius     16.072  // inner radius
    tightness  0.000
  rotate 45.710327*y
  translate  <30.475931, 0.0, 27.426758>
}

#declare Spotlight010 = light_source {   // Spotlight Spotlight010
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.009, 0.000>
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    21.629  // outer radius (in deg)
    radius     16.072  // inner radius
    tightness  0.000
  rotate 45.710327*y
  translate  <30.475931, 0.0, 27.426758>
}

#declare Spotlight011 = light_source {   // Spotlight Spotlight011
  <0.0, 0.0, 0.0>
  color rgb <0.000, 0.000, 1.000>
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    21.629  // outer radius (in deg)
    radius     16.072  // inner radius
    tightness  0.000
  rotate 45.710327*y
  translate  <30.475931, 0.0, 27.426758>
}

#declare Spotlight012 = light_source {   // Spotlight Spotlight012
  <0.0, 0.0, 0.0>
  color rgb <0.000, 0.000, 1.000>
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    21.629  // outer radius (in deg)
    radius     16.072  // inner radius
    tightness  0.000
  rotate 45.710327*y
  translate  <30.475931, 0.0, 27.426758>
}

#declare Spotlight005 = light_source {   // Spotlight Spotlight005
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.000, 0.000>
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    21.629  // outer radius (in deg)
    radius     16.072  // inner radius
    tightness  0.000
  rotate 45.710327*y
  translate  <30.475931, 0.0, 27.426758>
}

#declare Spotlight008 = light_source {   // Spotlight Spotlight008
  <0.0, 0.0, 0.0>
  color rgb <0.000, 0.000, 1.000>
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    21.629  // outer radius (in deg)
    radius     16.072  // inner radius
    tightness  0.000
  rotate 45.710327*y
  translate  <30.475931, 0.0, 27.426758>
}

#declare Spotlight001 = light_source {   // Spotlight Spotlight001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.000, 0.009>
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    21.629  // outer radius (in deg)
    radius     16.072  // inner radius
    tightness  0.000
  rotate 45.710327*y
  translate  <30.475931, 0.0, 27.426758>
}

#declare Spotlight004 = light_source {   // Spotlight Spotlight004
  <0.0, 0.0, 0.0>
  color rgb <0.000, 0.000, 1.000>
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    21.629  // outer radius (in deg)
    radius     16.072  // inner radius
    tightness  0.000
  rotate 45.710327*y
  translate  <30.475931, 0.0, 27.426758>
}

#declare Light1 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <0.500, 0.500, 0.500>*0.6983
  media_interaction off
  translate  40.0*z
}

#declare Light2 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <0.500, 0.500, 0.500>
  media_interaction off
  translate  40.0*z
}


//
// ********  MATERIALS  *******
//

#include "gal.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

box { // FarwallCube
  <-1, -1, -1>, <1, 1, 1>
  material {
    Background_Mat
    scale <1.722604, 1.973482, 1.0>
    rotate <-90.0, -180.0, -180.0>
    translate <-0.612979, 18.755639, -1.006741>
  }
  scale <19.474939, 0.084575, 12.39087>
  translate  <-1.269761, 14.951204, 7.965154>
}


#include "C:\programs\pov31\scenes\bee.inc"

#declare SPHERE_82_default_Ref = object {
  SPHERE_82_default
}
#declare SPHERE_57_default_Ref = object {
  SPHERE_57_default
}
#declare SPHERE_default_Ref = object {
  SPHERE_default
}
#declare SPHERE_56_default_Ref = object {
  SPHERE_56_default
}
#declare SPHERE_64_default_Ref = object {
  SPHERE_64_default
}
#declare SPHERE_48_default_Ref = object {
  SPHERE_48_default
}
#declare AXIS_8_default_Ref = object {
  AXIS_8_default
}
#declare HEAD_default_Ref = object {
  HEAD_default
}
#declare ABDOMEN_default_Ref = object {
  ABDOMEN_default
}
#declare HAIR_2_default_Ref = object {
  HAIR_2_default
}
#declare SPHERE_1_default_Ref = object {
  SPHERE_1_default
}
#declare SPHERE_72_default_Ref = object {
  SPHERE_72_default
}
#declare SPHERE_80_default_Ref = object {
  SPHERE_80_default
}
#declare SPHERE_88_default_Ref = object {
  SPHERE_88_default
}
#declare SPHERE_89_default_Ref = object {
  SPHERE_89_default
}
#declare SPHERE_90_default_Ref = object {
  SPHERE_90_default
}
#declare SPHERE_91_default_Ref = object {
  SPHERE_91_default
}
#declare SPHERE_92_default_Ref = object {
  SPHERE_92_default
}
#declare SPHERE_93_default_Ref = object {
  SPHERE_93_default
}
#declare SPHERE_94_default_Ref = object {
  SPHERE_94_default
}
#declare SPHERE_95_default_Ref = object {
  SPHERE_95_default
}
#declare SPHERE_81_default_Ref = object {
  SPHERE_81_default
}
#declare SPHERE_83_default_Ref = object {
  SPHERE_83_default
}
#declare SPHERE_84_default_Ref = object {
  SPHERE_84_default
}
#declare SPHERE_85_default_Ref = object {
  SPHERE_85_default
}
#declare SPHERE_86_default_Ref = object {
  SPHERE_86_default
}
#declare SPHERE_87_default_Ref = object {
  SPHERE_87_default
}
#declare SPHERE_73_default_Ref = object {
  SPHERE_73_default
}
#declare SPHERE_74_default_Ref = object {
  SPHERE_74_default
}
#declare SPHERE_75_default_Ref = object {
  SPHERE_75_default
}
#declare SPHERE_76_default_Ref = object {
  SPHERE_76_default
}
#declare SPHERE_77_default_Ref = object {
  SPHERE_77_default
}
#declare SPHERE_78_default_Ref = object {
  SPHERE_78_default
}
#declare SPHERE_79_default_Ref = object {
  SPHERE_79_default
}
#declare FRONTWING__default_Ref = object {
  FRONTWING__default
}
#declare HINDWING_2_default_Ref = object {
  HINDWING_2_default
}
#declare HAIR_3_default_Ref = object {
  HAIR_3_default
}
#declare LFTANTENNA_default_Ref = object {
  LFTANTENNA_default
}
#declare RTANTENNA_default_Ref = object {
  RTANTENNA_default
}
#declare RTEYE_default_Ref = object {
  RTEYE_default
}
#declare LFTEYE_default_Ref = object {
  LFTEYE_default
}
#declare TONGUE_default_Ref = object {
  TONGUE_default
}
#declare JAWS_default_Ref = object {
  JAWS_default
}
#declare HAIR_1_default_Ref = object {
  HAIR_1_default
}
#declare TUBE_default_Ref = object {
  TUBE_default
}
#declare SPHERE_49_default_Ref = object {
  SPHERE_49_default
}
#declare SPHERE_50_default_Ref = object {
  SPHERE_50_default
}
#declare SPHERE_51_default_Ref = object {
  SPHERE_51_default
}
#declare SPHERE_52_default_Ref = object {
  SPHERE_52_default
}
#declare SPHERE_53_default_Ref = object {
  SPHERE_53_default
}
#declare SPHERE_54_default_Ref = object {
  SPHERE_54_default
}
#declare SPHERE_55_default_Ref = object {
  SPHERE_55_default
}
#declare SPHERE_65_default_Ref = object {
  SPHERE_65_default
}
#declare SPHERE_66_default_Ref = object {
  SPHERE_66_default
}
#declare SPHERE_67_default_Ref = object {
  SPHERE_67_default
}
#declare SPHERE_68_default_Ref = object {
  SPHERE_68_default
}
#declare SPHERE_71_default_Ref = object {
  SPHERE_71_default
}
#declare SPHERE_69_default_Ref = object {
  SPHERE_69_default
}
#declare SPHERE_70_default_Ref = object {
  SPHERE_70_default
}
#declare SPHERE_58_default_Ref = object {
  SPHERE_58_default
}
#declare SPHERE_59_default_Ref = object {
  SPHERE_59_default
}
#declare SPHERE_60_default_Ref = object {
  SPHERE_60_default
}
#declare SPHERE_63_default_Ref = object {
  SPHERE_63_default
}
#declare SPHERE_62_default_Ref = object {
  SPHERE_62_default
}
#declare SPHERE_61_default_Ref = object {
  SPHERE_61_default
}
#declare FRONTWING1_default_Ref = object {
  FRONTWING1_default
}
#declare HINDWING_1_default_Ref = object {
  HINDWING_1_default
}
#declare THORAX_default_Ref = object {
  THORAX_default
}
#declare bee_group = union {
  object { SPHERE_82_default_Ref }
  object { SPHERE_57_default_Ref }
  object { SPHERE_default_Ref }
  object { SPHERE_56_default_Ref }
  object { SPHERE_64_default_Ref }
  object { SPHERE_48_default_Ref }
  object { AXIS_8_default_Ref }
  object { HEAD_default_Ref }
  object { ABDOMEN_default_Ref }
  object { HAIR_2_default_Ref }
  object { SPHERE_1_default_Ref }
  object { SPHERE_72_default_Ref }
  object { SPHERE_80_default_Ref }
  object { SPHERE_88_default_Ref }
  object { SPHERE_89_default_Ref }
  object { SPHERE_90_default_Ref }
  object { SPHERE_91_default_Ref }
  object { SPHERE_92_default_Ref }
  object { SPHERE_93_default_Ref }
  object { SPHERE_94_default_Ref }
  object { SPHERE_95_default_Ref }
  object { SPHERE_81_default_Ref }
  object { SPHERE_83_default_Ref }
  object { SPHERE_84_default_Ref }
  object { SPHERE_85_default_Ref }
  object { SPHERE_86_default_Ref }
  object { SPHERE_87_default_Ref }
  object { SPHERE_73_default_Ref }
  object { SPHERE_74_default_Ref }
  object { SPHERE_75_default_Ref }
  object { SPHERE_76_default_Ref }
  object { SPHERE_77_default_Ref }
  object { SPHERE_78_default_Ref }
  object { SPHERE_79_default_Ref }
  object { FRONTWING__default_Ref }
  object { HINDWING_2_default_Ref }
  object { HAIR_3_default_Ref }
  object { LFTANTENNA_default_Ref }
  object { RTANTENNA_default_Ref }
  object { RTEYE_default_Ref }
  object { LFTEYE_default_Ref }
  object { TONGUE_default_Ref }
  object { JAWS_default_Ref }
  object { HAIR_1_default_Ref }
  object { TUBE_default_Ref }
  object { SPHERE_49_default_Ref }
  object { SPHERE_50_default_Ref }
  object { SPHERE_51_default_Ref }
  object { SPHERE_52_default_Ref }
  object { SPHERE_53_default_Ref }
  object { SPHERE_54_default_Ref }
  object { SPHERE_55_default_Ref }
  object { SPHERE_65_default_Ref }
  object { SPHERE_66_default_Ref }
  object { SPHERE_67_default_Ref }
  object { SPHERE_68_default_Ref }
  object { SPHERE_71_default_Ref }
  object { SPHERE_69_default_Ref }
  object { SPHERE_70_default_Ref }
  object { SPHERE_58_default_Ref }
  object { SPHERE_59_default_Ref }
  object { SPHERE_60_default_Ref }
  object { SPHERE_63_default_Ref }
  object { SPHERE_62_default_Ref }
  object { SPHERE_61_default_Ref }
  object { FRONTWING1_default_Ref }
  object { HINDWING_1_default_Ref }
  object { THORAX_default_Ref }
  material {
    Glass_Colored_Blue_1
  }
  scale 0.02
  translate  <-4.784276, 10.281776, 11.168735>
}
#declare HorisontalStandCyls = union {
  cylinder { // BeestandCyl
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 3.327081>
    rotate -90.0*x
    translate  <-3.854419, 8.338708, 10.136508>
  }
  cylinder { // BeestandCyl1
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 3.327081>
    rotate -90.0*x
    translate  <-5.879676, 8.338708, 10.136508>
  }
  cylinder { // BeestandCyl2
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 3.327081>
    rotate -90.0*x
    translate  <-4.832129, 8.338708, 13.488658>
  }
}
#declare TwoVerts = union {
  cylinder { // BeestandCyl3
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 4.93332>
    translate  <-3.854419, 9.149965, 10.136508>
  }
  cylinder { // BeestandCyl4
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 4.93332>
    translate  <-5.861213, 9.149965, 10.136508>
  }
}
#declare TwoVerts1 = union {
  cylinder { // BeestandCyl5
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 4.93332>
    translate  <-3.854419, 11.156758, 10.136508>
  }
  cylinder { // BeestandCyl6
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 4.93332>
    translate  <-5.861213, 11.199456, 10.136508>
  }
}
#declare VerticalStandCyls = union {
  object { TwoVerts }
  object { TwoVerts1 }
}
#declare Stand = union {
  object { HorisontalStandCyls }
  object { VerticalStandCyls }
  material {
    Gold_Metal_Mine
  }
}
union { // BeeAndHolder
  object { bee_group }
  object { Stand }
}


#include "C:\programs\pov31\scenes\spiral1.inc"

#declare Armanisoft_0_Ref = object {
  Armanisoft_0
  scale 0.1
  rotate -90.0*x
  translate  <5.042009, 10.65133, 10.197267>
}
#declare Armanisoft_1_Ref = object {
  Armanisoft_0
  scale 0.1
  rotate <-90.0, 0.0, 26.104387>
  translate  <2.327081, 10.457406, 10.197267>
}
union { // Shells
  object { Armanisoft_0_Ref }
  object { Armanisoft_1_Ref }
  material {
    TableTop_Mat
  }
}


#include "C:\programs\pov31\scenes\brigde.inc"

object {
  adX
  material {
    S_Wood5_Mine
  }
  scale 0.02
  rotate <90.0, 23.867283, 72.508324>
  translate  <0.801451, 8.201349, 10.26978>
}


#declare TableStand = union {
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    scale <2.028836, 1.0, 1.0>
    rotate -90.0*x
    translate  <14.193289, 1.55798, 0.128604>
  }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    scale <2.028836, 1.0, 1.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <13.665752, 2.074763, 0.089276>
  }
}
#declare SideHemiSphereCutsFront = union {
  sphere { // Sphere002
    <0,0,0>,1
    scale 0.299106
    translate  <12.258799, 2.42595, 0.254696>
  }
  sphere { // Sphere003
    <0,0,0>,1
    scale 0.299106
    translate  <12.258799, 1.698099, 0.25663>
  }
}
#declare SideHemiSphereCutsBack = union {
  sphere { // Sphere004
    <0,0,0>,1
    scale 0.299106
    translate  <16.140672, 2.42595, 0.254696>
  }
  sphere { // Sphere005
    <0,0,0>,1
    scale 0.299106
    translate  <16.16763, 1.698099, 0.25663>
  }
}
#declare SideHemiSphereCuts = union {
  object { SideHemiSphereCutsFront }
  object { SideHemiSphereCutsBack }
}
#declare SideHemiSphereCutsFront1 = union {
  sphere { // Sphere006
    <0,0,0>,1
    scale 0.299106
    translate  <13.714502, 4.01644, 0.254696>
  }
  sphere { // Sphere007
    <0,0,0>,1
    scale 0.299106
    translate  <14.523225, 4.01644, 0.25663>
  }
}
#declare SideHemiSphereCutsBack1 = union {
  sphere { // Sphere008
    <0,0,0>,1
    scale 0.299106
    translate  <14.57714, 0.080652, 0.254696>
  }
  sphere { // Sphere009
    <0,0,0>,1
    scale 0.299106
    translate  <13.741459, 0.026737, 0.25663>
  }
}
#declare TopHemiSphereCuts = union {
  object { SideHemiSphereCutsFront1 }
  object { SideHemiSphereCutsBack1 }
}
#declare LegHemisphereCuts = union {
  object { SideHemiSphereCuts }
  object { TopHemiSphereCuts }
}
#declare FrontCarvings = union {
  text {   // Carving
    ttf      "C:\WINDOWS\Fonts\Afrioo__.ttf",
    "A",
    0.5,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.417557
    rotate -31.282227*y
    translate  <12.659714, 1.864067, 0.577704>
  }

  text {   // Carving1
    ttf      "C:\WINDOWS\Fonts\Afrioo__.ttf",
    "B",
    0.5,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.417557
    rotate -25.135319*y
    translate  <13.163901, 1.87696, 0.820948>
  }

}
#declare SideCarvings = union {
  text {   // Carving2
    ttf      "C:\WINDOWS\Fonts\Afrioo__.ttf",
    "A",
    0.5,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.417557
    rotate <-0.0, -31.282227, 90.0>
    translate  <14.387421, 0.548946, 0.577704>
  }

  text {   // Carving3
    ttf      "C:\WINDOWS\Fonts\Afrioo__.ttf",
    "B",
    0.5,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.417557
    rotate <0.0, -25.135319, 90.0>
    translate  <14.388768, 1.090467, 0.820948>
  }

}
#declare TableStandCarvings = union {
  object { FrontCarvings }
  object { SideCarvings }
  material {
    Gold_Metal_Mine
  }
}
#declare TableStandCuts = union {
  sphere { // MainCutSphere
    <0,0,0>,1
    scale <1.558695, 1.478768, 1.015203>
    translate  <14.199736, 1.967673, -0.061635>
  }
  object { LegHemisphereCuts }
  object { TableStandCarvings }
}
#declare TableStandDiff = difference {
  object { TableStand }
  object { TableStandCuts }
  material {
    T_Wood35_mine
  }
}
#declare SmallTableTopDiff = difference {
  box { // SmallTableTopCube
    <-1, -1, -1>, <1, 1, 1>
    scale <1.796013, 2.114419, 0.064491>
    translate  <14.155319, 1.956912, 7.087992>
  }
  text {   // Carving4
    ttf      "C:\WINDOWS\Fonts\Afrioo__.ttf",
    "A",
    0.5,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      Gold_Metal_Mine
    }
    scale <2.644434, 2.955959, 0.417557>
    translate  <12.776608, 0.565476, 7.116271>
  }

}
#declare TableStructure = union {
  cylinder { // TableStandStalk
    <0,0,1>, <0,0,0>, 1 
    scale <0.343134, 0.343134, 6.079281>
    translate  <14.189961, 1.922579, 1.018584>
  }
  object { SmallTableTopDiff }
}
#declare RosePot = lathe {
  cubic_spline
  11  // control points
  <0.128066, -0.973578>,
  <0.24704, -1.01357>,
  <0.524646, -1.001198>,
  <1.45, -0.775>,
  <2.0, -0.5>,
  <2.0, 0.5>,
  <0.858344, 2.496307>,
  <1.041467, 3.690188>,
  <1.264222, 4.487735>,
  <0.920733, 4.320053>,
  <0.735778, 3.938961>
  rotate <90,0,90>
  material {
    Glass_Colored_Blue
  }
  scale 0.5
  translate  <14.178799, 2.026402, 7.586025>
}
#include "C:\programs\pov31\scenes\rose.inc"

#declare STEM_STEM_dark_blu1_Ref = object {
  STEM_STEM_dark_blu1
  material {
    Rose_Stem_Material
  }
}
#declare STEM_STEM_light_purp_Ref = object {
  STEM_STEM_light_purp
  material {
    Rose_Petals_Material
  }
}
#declare STEM_STEM_dark_bluis_Ref = object {
  STEM_STEM_dark_bluis
  material {
    Rose_PetalStalk_Material
  }
}
#declare rose_group = union {
  object { STEM_STEM_dark_blu1_Ref }
  object { STEM_STEM_light_purp_Ref }
  object { STEM_STEM_dark_bluis_Ref }
  scale 0.01
  rotate <-90.0, -0.0, 0.0>
  translate  <15.404599, 2.141185, 7.74788>
}
#declare STEM_STEM_dark_blu2_Ref = object {
  STEM_STEM_dark_blu1
  material {
    Rose_Stem_Material
  }
}
#declare STEM_STEM_light_purp1_Ref = object {
  STEM_STEM_light_purp
  material {
    Rose_Petals_Material
  }
}
#declare STEM_STEM_dark_bluis1_Ref = object {
  STEM_STEM_dark_bluis
  material {
    Rose_PetalStalk_Material
  }
}
#declare rose_group1 = union {
  object { STEM_STEM_dark_blu2_Ref }
  object { STEM_STEM_light_purp1_Ref }
  object { STEM_STEM_dark_bluis1_Ref }
  scale 0.01
  rotate <-88.439079, 1.156034, -174.104477>
  translate  <13.068993, 1.525557, 7.721049>
}
#declare Roses = union {
  object { rose_group }
  object { rose_group1 }
}
union { // SmallWindowTable
  object { TableStandDiff }
  object { TableStructure }
  object { RosePot }
  object { Roses }
  material {
    T_Wood35_mine
  }
}


union { // TableTop
  box { // TableTopCube
    <-1, -1, -1>, <1, 1, 1>
    material {
      Cherry_Wood_Mine
      scale 0.05
      rotate 33.745136*y
    }
    scale <7.772166, 4.999983, 0.101104>
    translate  <-0.686092, 7.395521, 9.538517>
  }
  box { // GlassTableTop
    <-1, -1, -1>, <1, 1, 1>
    material {
      TableTop_Glass_Mat
      scale 0.5
      rotate 33.745136*y
    }
    scale <7.772166, 4.999983, 0.020048>
    translate  <-0.686092, 7.395521, 9.700628>
  }
}


#include "C:\programs\pov31\scenes\vichair.inc"

#declare chair05_BROWN_WOODISH1_Ref = object {
  chair05_BROWN_WOODISH
  material {
    T_Wood1_Mine
  }
  scale <0.02, 0.02, 0.025>
  rotate 145.0*z
  translate  <-0.007608, -12.694769, 9.262706>
}
#declare Chair_Cushion1 = union {
  object { chair05_BROWN_WOODISH1_Ref }
  superellipsoid { // Cushion1
    <0.75, 0.5>
    material {
      Cushion_Mat
    }
    scale <2.195552, 2.267974, 0.55>
    rotate <-0.0, 0.0, -34.193165>
    translate  <1.44789, -11.227723, 5.627416>
  }
  rotate 34.492729*z
  translate  <-5.207681, 8.778663, 0.0>
}
#declare chair05_BROWN_WOODISH_Ref = object {
  chair05_BROWN_WOODISH
  material {
    T_Wood1_Mine
  }
  scale <0.02, 0.02, 0.025>
  rotate 145.0*z
  translate  <-0.007608, -12.694769, 9.262706>
}
#declare Chair_Cushion = union {
  object { chair05_BROWN_WOODISH_Ref }
  superellipsoid { // Cushion
    <0.75, 0.5>
    material {
      Cushion_Mat
    }
    scale <2.195552, 2.267974, 0.55>
    rotate <-0.0, 0.0, -34.193165>
    translate  <1.44789, -11.227723, 5.627416>
  }
  rotate -55.925095*z
  translate  <7.588336, -3.570982, 0.0>
}
#declare chair05_BROWN_WOODISH2_Ref = object {
  chair05_BROWN_WOODISH
  material {
    T_Wood1_Mine
  }
  scale <0.02, 0.02, 0.025>
  rotate 145.0*z
  translate  <-0.007608, -12.694769, 9.262706>
}
#declare Chair_Cushion2 = union {
  object { chair05_BROWN_WOODISH2_Ref }
  superellipsoid { // Cushion2
    <0.75, 0.5>
    material {
      Cushion_Mat
    }
    scale <2.195552, 2.267974, 0.55>
    rotate <-0.0, 0.0, -34.193165>
    translate  <1.44789, -11.227723, 5.627416>
  }
  rotate -87.529305*z
  translate  <0.58731, 10.380755, 0.0>
}
union { // SceneChairs
  object { Chair_Cushion1 }
  object { Chair_Cushion }
  object { Chair_Cushion2 }
}


union { // CandleLights
  object { Light001 }
  object { Light002 }
  object { Light003 }
  object { SideboardCandleLight }
  object { SideboardCandleLight1 }
}


#declare LabraBaseDiffCuts = union {
  cylinder { // LabraBase1
    <0,0,1>, <0,0,0>, 1 
    material {
      Gold_Metal_Mine
    }
    scale <0.25, 0.25, 0.253109>
    rotate -90.0*y
    translate  <18.022347, -4.749007, 14.194718>
  }
  cylinder { // LabraBase2
    <0,0,1>, <0,0,0>, 1 
    material {
      Gold_Metal_Mine
    }
    scale <0.25, 0.25, 0.253109>
    rotate -90.0*y
    translate  <18.022347, -5.463206, 14.194718>
  }
  cylinder { // LabraBase3
    <0,0,1>, <0,0,0>, 1 
    material {
      Gold_Metal_Mine
    }
    scale <0.25, 0.25, 0.253109>
    rotate -90.0*y
    translate  <18.022347, -4.749007, 13.258871>
  }
  cylinder { // LabraBase4
    <0,0,1>, <0,0,0>, 1 
    material {
      Gold_Metal_Mine
    }
    scale <0.25, 0.25, 0.253109>
    rotate -90.0*y
    translate  <18.022347, -5.463206, 13.258871>
  }
}
#declare LabraBaseDiff = difference {
  cylinder { // LabraBase
    <0,0,1>, <0,0,0>, 1 
    material {
      Gold_Metal_Mine
    }
    scale <0.624275, 0.624275, 0.105039>
    rotate -90.0*y
    translate  <17.956928, -5.093793, 13.726794>
  }
  object { LabraBaseDiffCuts }
}
#declare LabraBaseInt = intersection {
  cylinder { // LabraBase5
    <0,0,1>, <0,0,0>, 1 
    scale <0.624275, 0.624275, 0.105039>
    rotate -90.0*y
    translate  <17.956928, -5.093793, 13.726794>
  }
  cylinder { // LabraBase6
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.253109>
    rotate -90.0*y
    translate  <18.022347, -4.749007, 14.194718>
  }
}
#declare LabraBaseInt1 = intersection {
  cylinder { // LabraBase7
    <0,0,1>, <0,0,0>, 1 
    scale <0.624275, 0.624275, 0.105039>
    rotate -90.0*y
    translate  <17.956928, -5.093793, 13.726794>
  }
  cylinder { // LabraBase8
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.253109>
    rotate -90.0*y
    translate  <18.022347, -5.463206, 14.194718>
  }
}
#declare LabraBaseInt2 = intersection {
  cylinder { // LabraBase9
    <0,0,1>, <0,0,0>, 1 
    scale <0.624275, 0.624275, 0.105039>
    rotate -90.0*y
    translate  <17.956928, -5.093793, 13.726794>
  }
  cylinder { // LabraBase10
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.253109>
    rotate -90.0*y
    translate  <18.022347, -4.749007, 13.258871>
  }
}
#declare LabraBaseInt3 = intersection {
  cylinder { // LabraBase11
    <0,0,1>, <0,0,0>, 1 
    scale <0.624275, 0.624275, 0.105039>
    rotate -90.0*y
    translate  <17.956928, -5.093793, 13.726794>
  }
  cylinder { // LabraBase12
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.253109>
    rotate -90.0*y
    translate  <18.022347, -5.463206, 13.258871>
  }
}
#declare LabraBaseIntsUni = union {
  object { LabraBaseInt }
  object { LabraBaseInt1 }
  object { LabraBaseInt2 }
  object { LabraBaseInt3 }
  material {
    Aluminum_Mine
  }
}
#declare LabraBaseUni = union {
  object { LabraBaseDiff }
  object { LabraBaseIntsUni }
}
#declare CandleBase = lathe {
  quadratic_spline
  11  // control points
  <0.032634, -1.13986>,
  <0.067306, -1.178213>,
  <0.653584, -1.121489>,
  <1.251224, -0.939948>,
  <1.558275, -0.86655>,
  <2.0, -0.5>,
  <2.291375, -0.04662>,
  <2.0, 0.5>,
  <1.494172, 0.033217>,
  <0.70204, -0.278467>,
  <0.055944, -0.340326>
  rotate <90,0,90>
  material {
    CandleBaseMat
  }
  scale 0.15
  translate  <16.423654, -5.086749, 15.33585>
}
#declare CandleBaseDiff = difference {
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 0.770284>
    translate  <16.41835, -5.077359, 14.437863>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 0.25>
    translate  <16.41835, -5.077359, 14.708411>
  }
  material {
    Gold_Metal_Mine
  }
}
#declare CandleInt = intersection {
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 0.770284>
    translate  <16.41835, -5.077359, 14.437863>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 0.25>
    translate  <16.41835, -5.077359, 14.708411>
  }
  material {
    Brass_Metal_Mine
  }
}
#declare CandleBaseUni = union {
  object { CandleBaseDiff }
  object { CandleInt }
}
#declare CandleBase1 = lathe {
  quadratic_spline
  11  // control points
  <0.032634, -1.13986>,
  <0.067306, -1.178213>,
  <0.653584, -1.121489>,
  <1.251224, -0.939948>,
  <1.558275, -0.86655>,
  <2.0, -0.5>,
  <2.291375, -0.04662>,
  <2.0, 0.5>,
  <1.494172, 0.033217>,
  <0.70204, -0.278467>,
  <0.055944, -0.340326>
  rotate <90,0,90>
  material {
    CandleBaseMat
  }
  scale 0.15
  translate  <16.423654, -5.086749, 15.33585>
}
#declare LeftCandleUni = union {
  cylinder { // Candle
    <0,0,1>, <0,0,0>, 1 
    material {
      CandleMaterial
    }
    scale <0.15, 0.15, 0.770284>
  }
  cylinder { // Wick
    <0,0,1>, <0,0,0>, 1 
    material {
      WickMaterial
    }
    scale <0.025, 0.025, 0.294946>
    translate  <0.0, -0.0, 0.770365>
  }
  translate  <16.42441, -5.06276, 15.27032>
}
#declare CandleStand = union {
  object { CandleBaseUni }
  object { CandleBase1 }
  object { LeftCandleUni }
  translate  <-1.617605, 1.466617, 0.332982>
}
#declare CandleBaseDiff1 = difference {
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 0.770284>
    translate  <16.41835, -5.077359, 14.437863>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 0.25>
    translate  <16.41835, -5.077359, 14.708411>
  }
  material {
    Gold_Metal_Mine
  }
}
#declare CandleInt1 = intersection {
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 0.770284>
    translate  <16.41835, -5.077359, 14.437863>
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 0.25>
    translate  <16.41835, -5.077359, 14.708411>
  }
  material {
    Brass_Metal_Mine
  }
}
#declare CandleBaseUni1 = union {
  object { CandleBaseDiff1 }
  object { CandleInt1 }
}
#declare CandleBase2 = lathe {
  quadratic_spline
  11  // control points
  <0.032634, -1.13986>,
  <0.067306, -1.178213>,
  <0.653584, -1.121489>,
  <1.251224, -0.939948>,
  <1.558275, -0.86655>,
  <2.0, -0.5>,
  <2.291375, -0.04662>,
  <2.0, 0.5>,
  <1.494172, 0.033217>,
  <0.70204, -0.278467>,
  <0.055944, -0.340326>
  rotate <90,0,90>
  material {
    CandleBaseMat
  }
  scale 0.15
  translate  <16.423654, -5.086749, 15.33585>
}
#declare RightCandleUni = union {
  cylinder { // Candle2
    <0,0,1>, <0,0,0>, 1 
    material {
      CandleMaterial
    }
    scale <0.15, 0.15, 0.770284>
  }
  cylinder { // Wick2
    <0,0,1>, <0,0,0>, 1 
    material {
      WickMaterial
    }
    scale <0.025, 0.025, 0.294946>
    translate  <0.0, -0.0, 0.770365>
  }
  translate  <16.42441, -5.06276, 15.27032>
}
#declare CandleStand1 = union {
  object { CandleBaseUni1 }
  object { CandleBase2 }
  object { RightCandleUni }
  translate  <-1.617605, -1.677181, 0.332982>
}
#declare CandleStands = union {
  object { CandleStand }
  object { CandleStand1 }
}
#declare CenterCandleUni = union {
  cylinder { // Candle1
    <0,0,1>, <0,0,0>, 1 
    material {
      CandleMaterial
    }
    scale <0.15, 0.15, 0.770284>
  }
  cylinder { // Wick1
    <0,0,1>, <0,0,0>, 1 
    material {
      WickMaterial
    }
    scale <0.025, 0.025, 0.294946>
    translate  <0.0, -0.0, 0.770365>
  }
  translate  <16.42441, -5.06276, 15.27032>
}
union { // RWallLabra
  object { LabraBaseUni }
  object { CandleBase }
  object { CandleStands }
  object { CenterCandleUni }
}


#include "gal.in1"
#declare ChessPieces = object {
  ChessPieces_Raw
  material {
    Sandalwood_Mine
  }
  scale 0.2
  rotate <90.0, -0.0, -89.173012>
  translate  <13.866404, -9.576287, 9.655173>
}
#declare Chalice = lathe {
  cubic_spline
  11  // control points
  <0.965035, -2.060606>,
  <0.72357, -2.239534>,
  <0.259562, -2.253924>,
  <0.155086, -2.257132>,
  <0.063794, -2.211838>,
  <0.054917, -1.803252>,
  <0.150495, -1.325685>,
  <0.434149, -0.939103>,
  <1.207459, -0.465035>,
  <1.528152, 0.560504>,
  <1.16317, 0.137529>
  rotate <90,0,90>
  material {
    Gold_Metal_Mine
  }
  scale 0.727469
  translate  <14.589315, -3.771775, 10.089274>
}
#declare ChaliceUni = union {
  object { Chalice }
  cylinder { // Wine
    <0,0,1>, <0,0,0>, 1 
    material {
      Wine_Mat
      scale 0.25
    }
    scale <0.939578, 0.967362, 0.282986>
    translate  <14.622247, -3.782377, 10.119781>
  }
  translate  0.822519*x
}
#declare BookCuts = union {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <0.35, 0.35, 2.714446>
    rotate -90.0*x
    translate  <10.721715, -8.297651, 8.8801>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <0.35, 0.35, 3.995187>
    rotate <-90.0, -0.0, -90.0>
    translate  <10.721715, -8.136458, 8.8801>
  }
  material {
    BookCover_Mat
  }
}
#declare BookDiff = difference {
  superellipsoid { // Book
    <0.1, 0.25>
    material {
      BookCover_Mat
    }
    scale <1.924418, 1.346657, 0.461179>
    translate  <12.717722, -6.792086, 8.90986>
  }
  object { BookCuts }
}
#declare ThreePages = union {
  box { // Pages1
    <-1, -1, -1>, <1, 1, 1>
    material {
      Pages_Mat
    }
    scale <1.987122, 1.188874, 0.01>
    translate  <12.729136, -6.748469, 9.237017>
  }
  box { // Pages2
    <-1, -1, -1>, <1, 1, 1>
    material {
      Pages_Mat
    }
    scale <1.987122, 1.188874, 0.01>
    translate  <12.729136, -6.748469, 9.18431>
  }
  box { // Pages3
    <-1, -1, -1>, <1, 1, 1>
    material {
      Pages_Mat
    }
    scale <1.987122, 1.188874, 0.01>
    translate  <12.729136, -6.748469, 9.131602>
  }
}
#declare ThreePages1 = union {
  box { // Pages4
    <-1, -1, -1>, <1, 1, 1>
    material {
      Pages_Mat
    }
    scale <1.987122, 1.188874, 0.01>
    translate  <12.729136, -6.748469, 9.237017>
  }
  box { // Pages5
    <-1, -1, -1>, <1, 1, 1>
    material {
      Pages_Mat
    }
    scale <1.987122, 1.188874, 0.01>
    translate  <12.729136, -6.748469, 9.18431>
  }
  box { // Pages6
    <-1, -1, -1>, <1, 1, 1>
    material {
      Pages_Mat
    }
    scale <1.987122, 1.188874, 0.01>
    translate  <12.729136, -6.748469, 9.131602>
  }
  translate  -0.158122*z
}
#declare ThreePages2 = union {
  box { // Pages7
    <-1, -1, -1>, <1, 1, 1>
    material {
      Pages_Mat
    }
    scale <1.987122, 1.188874, 0.01>
    translate  <12.729136, -6.748469, 9.237017>
  }
  box { // Pages8
    <-1, -1, -1>, <1, 1, 1>
    material {
      Pages_Mat
    }
    scale <1.987122, 1.188874, 0.01>
    translate  <12.729136, -6.748469, 9.18431>
  }
  box { // Pages9
    <-1, -1, -1>, <1, 1, 1>
    material {
      Pages_Mat
    }
    scale <1.987122, 1.188874, 0.01>
    translate  <12.729136, -6.748469, 9.131602>
  }
  translate  -0.329422*z
}
#declare ThreePages3 = union {
  box { // Pages10
    <-1, -1, -1>, <1, 1, 1>
    material {
      Pages_Mat
    }
    scale <1.987122, 1.188874, 0.01>
    translate  <12.729136, -6.748469, 9.237017>
  }
  box { // Pages11
    <-1, -1, -1>, <1, 1, 1>
    material {
      Pages_Mat
    }
    scale <1.987122, 1.188874, 0.01>
    translate  <12.729136, -6.748469, 9.18431>
  }
  box { // Pages12
    <-1, -1, -1>, <1, 1, 1>
    material {
      Pages_Mat
    }
    scale <1.987122, 1.188874, 0.01>
    translate  <12.729136, -6.748469, 9.131602>
  }
  translate  -0.500721*z
}
#declare PagesCuts = union {
  object { ThreePages }
  object { ThreePages1 }
  object { ThreePages2 }
  object { ThreePages3 }
}
#declare PagesDiff = difference {
  box { // Pages
    <-1, -1, -1>, <1, 1, 1>
    material {
      Pages_Mat
    }
    scale <1.798248, 1.094437, 0.363764>
    translate  <12.729136, -6.748469, 8.920772>
  }
  object { PagesCuts }
}
#declare BookDiffUni = union {
  object { BookDiff }
  object { PagesDiff }
}
#declare BookTextUni = union {
  text {   // Liber
    ttf      "C:\WINDOWS\Fonts\Bedrockn.ttf",
    "LIBER",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      Gold_Metal_Mine
    }
    scale <0.667909, 0.625496, 0.03>
    rotate -90.0*z
    translate  <13.017399, -6.347159, 9.34336>
  }

  text {   // BookBorder
    ttf      "C:\WINDOWS\Fonts\Borders1.ttf",
    "H",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      Gold_Metal_Mine
    }
    scale <3.684128, 5.014633, 0.03>
    translate  <11.060394, -8.090086, 9.341597>
  }

  text {   // Ex
    ttf      "C:\WINDOWS\Fonts\Bedrockn.ttf",
    "EX",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      Gold_Metal_Mine
    }
    scale <0.667909, 0.625496, 0.03>
    rotate -90.0*z
    translate  <12.377622, -6.596829, 9.34336>
  }

  text {   // Doctrina
    ttf      "C:\WINDOWS\Fonts\Bedrockn.ttf",
    "DOCTRINA",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      Gold_Metal_Mine
    }
    scale <0.667909, 0.625496, 0.03>
    rotate -90.0*z
    translate  <11.72224, -6.019468, 9.34336>
  }

}
#declare BookUni = union {
  object { BookDiffUni }
  object { BookTextUni }
  translate  1.370865*x
}
#include "C:\programs\pov31\scenes\table3d.inc"

#declare TABLELEG_TABLELEGS_1_lig_Ref = object {
  TABLELEG_TABLELEGS_1_lig
}
#declare DRAWERS__DRAWERS_1_light_Ref = object {
  DRAWERS__DRAWERS_1_light
}
#declare TABLEBOD_TABLEBODY_1_lig_Ref = object {
  TABLEBOD_TABLEBODY_1_lig
}
#declare KNOB_2_KNOB_2_light_or_Ref = object {
  KNOB_2_KNOB_2_light_or
  material {
    Brass_Metal_Mine
  }
}
#declare KNOB_3_KNOB_3_light_or_Ref = object {
  KNOB_3_KNOB_3_light_or
  material {
    Brass_Metal_Mine
  }
}
#declare LEG_4_LEG_4_light_ora_Ref = object {
  LEG_4_LEG_4_light_ora
}
#declare LEG_5_LEG_5_light_ora_Ref = object {
  LEG_5_LEG_5_light_ora
}
#declare LEG_6_LEG_6_light_ora_Ref = object {
  LEG_6_LEG_6_light_ora
}
#declare LEG_7_LEG_7_light_ora_Ref = object {
  LEG_7_LEG_7_light_ora
}
#declare SKIRTTOP_SKIRTTOP_light_Ref = object {
  SKIRTTOP_SKIRTTOP_light
  material {
    T_Wood1_Mine
  }
}
#declare TABLETOP_TABLETOP_1_ligh_Ref = object {
  TABLETOP_TABLETOP_1_ligh
  material {
    TableTop_Mat
  }
}
#declare SKIRTSID_SKIRTSIDES_ligh_Ref = object {
  SKIRTSID_SKIRTSIDES_ligh
  material {
    T_Wood1_Mine
  }
}
#declare table3d_group = union {
  object { TABLELEG_TABLELEGS_1_lig_Ref }
  object { DRAWERS__DRAWERS_1_light_Ref }
  object { TABLEBOD_TABLEBODY_1_lig_Ref }
  object { KNOB_2_KNOB_2_light_or_Ref }
  object { KNOB_3_KNOB_3_light_or_Ref }
  object { LEG_4_LEG_4_light_ora_Ref }
  object { LEG_5_LEG_5_light_ora_Ref }
  object { LEG_6_LEG_6_light_ora_Ref }
  object { LEG_7_LEG_7_light_ora_Ref }
  object { SKIRTTOP_SKIRTTOP_light_Ref }
  object { TABLETOP_TABLETOP_1_ligh_Ref }
  object { SKIRTSID_SKIRTSIDES_ligh_Ref }
  material {
    DMFDarkOak_Mine
  }
  scale <0.0125, 0.0125, 0.0105>
  rotate -90.0*z
  translate  <-16.916434, 12.470454, 0.038243>
}
#declare CandleBase3 = lathe {
  quadratic_spline
  11  // control points
  <0.032634, -1.13986>,
  <0.067306, -1.178213>,
  <0.653584, -1.121489>,
  <1.251224, -0.939948>,
  <1.558275, -0.86655>,
  <2.0, -0.5>,
  <2.291375, -0.04662>,
  <2.0, 0.5>,
  <1.494172, 0.033217>,
  <0.70204, -0.278467>,
  <0.055944, -0.340326>
  rotate <90,0,90>
  material {
    CandleBaseMat
  }
  scale 0.15
  translate  <16.423654, -5.086749, 15.33585>
}
#declare LeftCandleUni1 = union {
  cylinder { // Candle3
    <0,0,1>, <0,0,0>, 1 
    material {
      CandleMaterial
    }
    scale <0.15, 0.15, 0.770284>
  }
  cylinder { // Wick3
    <0,0,1>, <0,0,0>, 1 
    material {
      WickMaterial
    }
    scale <0.025, 0.025, 0.294946>
    translate  <0.0, -0.0, 0.770365>
  }
  translate  <16.42441, -5.06276, 15.27032>
}
#declare CandleStand2 = union {
  object { CandleBase3 }
  object { LeftCandleUni1 }
  scale 2.0
  translate  <-20.269233, 6.398639, -21.903651>
}
#declare CandleBase4 = lathe {
  quadratic_spline
  11  // control points
  <0.032634, -1.13986>,
  <0.067306, -1.178213>,
  <0.653584, -1.121489>,
  <1.251224, -0.939948>,
  <1.558275, -0.86655>,
  <2.0, -0.5>,
  <2.291375, -0.04662>,
  <2.0, 0.5>,
  <1.494172, 0.033217>,
  <0.70204, -0.278467>,
  <0.055944, -0.340326>
  rotate <90,0,90>
  material {
    CandleBaseMat
  }
  scale 0.15
  translate  <16.423654, -5.086749, 15.33585>
}
#declare LeftCandleUni2 = union {
  cylinder { // Candle4
    <0,0,1>, <0,0,0>, 1 
    material {
      CandleMaterial
    }
    scale <0.15, 0.15, 0.770284>
  }
  cylinder { // Wick4
    <0,0,1>, <0,0,0>, 1 
    material {
      WickMaterial
    }
    scale <0.025, 0.025, 0.294946>
    translate  <0.0, -0.0, 0.770365>
  }
  translate  <16.42441, -5.06276, 15.27032>
}
#declare CandleStand3 = union {
  object { CandleBase4 }
  object { LeftCandleUni2 }
  scale 2.0
  translate  <-16.365885, 1.025794, -21.903651>
}
#declare SideBoardCandleStands = union {
  object { CandleStand2 }
  object { CandleStand3 }
}
union { // TheSideboard
  object { ChessPieces }
  object { ChaliceUni }
  object { BookUni }
  object { table3d_group }
  object { SideBoardCandleStands }
}


#declare ThirdWindowLightGroup1 = union {
  object { Spotlight009 }
  object { Spotlight010 }
  object { Spotlight011 }
  object { Spotlight012 }
  translate  5.461455*y
}
#declare SecondWindowLightGroup = union {
  object { Spotlight005 }
  object { Spotlight008 }
  translate  10.467789*y
}
#declare FirstWindowLightGroup = union {
  object { Spotlight001 }
  object { Spotlight004 }
}
union { // SpotLights
  object { ThirdWindowLightGroup1 }
  object { SecondWindowLightGroup }
  object { FirstWindowLightGroup }
}


union { // DesignLights
  object { Light1 }
  object { Light2 }
}


