#version unofficial MegaPov 0.5;

$fnBase = function{"rounded_box", <0.1,0.1,0.1,1>}
$fnNormal = function{pigment{bozo}}
$fnNormal2 = function{pigment{granite}}                      
$fnSphere = function{"sphere",<0.25>}
   
isosurface
{  
 #ifdef (finalbumps)
  function {fnBase(x,y,z) + (fnNormal(x,y,z) * 0.025) +
   (fnNormal2(x,y,z) * 0.08)}
 #else
  function {fnBase(x,y,z) + (fnNormal(x,y,z) * 0.025)}
 #end 
 contained_by{box{<-0.1,-0.1,-0.1>,<0.1,0.1,0.1>}}
 threshold 0.05
 eval
 
 material
 {
  texture
  {
   pigment
   { 
    #ifdef (final)
     gradient x
     color_map
     {
      [0.25 color CornflowerBlue transmit 0.75]
      [0.35 color SteelBlue transmit 0.65]
      [0.45 color Blue transmit 0.45]
     }                          
     frequency 50
     turbulence 0.25
    #else
     color SteelBlue
    #end
   }
   #ifdef (finishes)
    finish
    {
     reflection 0.345
     #ifdef (final)
      blinn 2 facets .7 
      reflection_blur 1.25
      reflection_samples 20
      conserve_energy
     #end 
    }
   #end 
  }        
  interior
  {
   ior 5.75
  }
 }             
 scale <150,100,6>
}                                    

$ridges = 4;
$twists = 2;
$sphere_radius = 2.5;
$displace_factor = 1.5;

#declare a=function{atan2(sqrt(x^2+z^2),y)}
#declare b=function{atan2(z,x)*ridges}
#declare c=function{cos(b+atan2(sqrt(x^2+z^2),y)*2*twists*ridges)*sin(a)*displace_factor}  
#declare final_function=function{sqrt(x^2+y^2+z^2)-sphere_radius-c}  
                  
$sphereoid = object
{

 isosurface
{
 function {final_function}
 contained_by{sphere{0.0,2.5}}
 
 material
 {
  texture
  {
   pigment
   { 
    #ifdef (final)
     gradient x
     color_map
     {
      [0.25 color CornflowerBlue transmit 0.75]
      [0.35 color Clear]
      [0.45 color Blue transmit 0.45]
     }                          
     frequency 50
     turbulence 0.25
    #else
     color SteelBlue
    #end 
   }
   #ifdef (finishes)
    finish
    {
     reflection 0.45  
     #ifdef (final)
      blinn 1 facets .2 
      reflection_blur 1.25
      reflection_samples 20
      conserve_energy
     #end 
    }
   #end 
  }
  interior
  {
   ior 1.25
  }
 }
 translate <-10.2,6.58,3.4>             
}
                     
}
        
object
{
 sphereoid
 translate <0,-15,0>
}        
     
#ifdef (final)        
 $lights_color = rgb <1,0.405,0.205>;

union
{
 light_source {
  <0.0, 0.0, 0.0>
  color lights_color
  translate  40.0*z     
 }
 object {sphereoid}
} 

$num_lights = 0;

#while (num_lights < 2)
union
{
 light_source {
  <0.0, 0.0, 0.0>
  color lights_color
  translate <-10.2,6.5,3.4>     
 }
 object {sphereoid}
}                  
 $num_lights = num_lights + 1;
 #end          
#end

#version official 3.1;
