//  Persistence of Vision Raytracer V3.5
//  World definition file.
//
//  Contains 3 lights, 21 materials and 261 primitives.
//
//  This file was generated for POV-Ray V3.5 by
//  Moray V3.5 For Windows Copyright (c) 1993-2003 Lutz + Kretzschmar
//

//  Date : 04/10/2004    (10.04.2004)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray V3.4 Beta For Windows.

*/ // End Scene Comment


// Scene Includes

#include "/mnt/win/programs/povray35/scenes/domus_pool_1.inc"

// End Scene Includes

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  noise_generator 2
  charset ascii
  radiosity {
    brightness       0.65
    count            100
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
    #if (version>3.1)
      adc_bailout      0.01
      max_sample       -1.0
      media            off
      normal           off
      always_sample    1

      pretrace_start   0.08
      pretrace_end     0.04
    #end
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Scenecam
  location  <     -8.254,     -11.442,       5.687>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35783,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         39.60000    // Vertical      29.700
  look_at   <     -2.338,       3.556,      -0.449>
  // Focal blur settings
  focal_point  <-2.338, 3.556, -0.449> // Always Lookat
  aperture     0.25
  blur_samples 80
  confidence   0.75
  variance     1/10000
}

//    Other cameras are commented out.
/*
camera {  //  Camera BenchCam
  location  <     -2.268,      -1.911,       3.656>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.34707,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         30.00000    // Vertical      22.500
  look_at   <     -0.173,       3.646,      -0.496>
}

*/

/*
camera {  //  Camera FarFloorCam
  location  <      6.899,      11.880,       2.483>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.38192,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         54.40000    // Vertical      40.800
  look_at   <      0.888,      10.849,       0.293>
}

*/

/*
camera {  //  Camera PoolWallCam
  location  <     -2.786,      -1.252,       0.823>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.38192,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         54.40000    // Vertical      40.800
  look_at   <     -2.229,       4.081,      -1.582>
}

*/

/*
camera {  //  Camera TreeCam
  location  <    -12.508,       6.562,       3.529>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.38192,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         54.40000    // Vertical      40.800
  look_at   <     -7.911,       3.956,       1.000>
}

*/

//
// *******  L I G H T S *******
//

#declare Light001 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 0.819>
  translate  <11.530411, -7.488517, 5.205261>
}

#declare Light002 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <0.690, 0.690, 0.586>*0.7351
  translate  <11.530411, -7.488517, 5.205261>
}

#declare LeftSideLight = light_source {
  <0.0, 0.0, 0.0>
  color rgb <0.810, 0.819, 0.638>
  translate  <-15.906438, -4.17092, 2.351342>
}


//
// ********  MATERIALS  *******
//

#include "/mnt/win/programs/povray35/scenes/domus_pool.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare PoolFloorDecoration = object {
  text {   // PoolFloorDecoration
    ttf      "/mnt/win/WINDOWS/Fonts/Afrioo__.ttf",
    "I",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      Azurite_4
    }
    scale <2.219307, 2.260593, 0.019534>
    rotate 90.0*z
    translate  <-4.998689, 1.418345, -2.963014>
  }

}
#declare PoolFloorDecoration2 = object {
  text {   // PoolFloorDecoration2
    ttf      "/mnt/win/WINDOWS/Fonts/Afrioo__.ttf",
    "L",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      Azurite_3
    }
    scale <2.219307, 2.260593, 0.019534>
    rotate 90.0*z
    translate  <-4.998689, -1.705327, -2.963014>
  }

}


#declare MainRoofTrussCube = object {
  box { // MainRoofTrussCube
    <-1, -1, -1>, <1, 1, 1>
    scale <0.062, 0.592425, 0.15>
    rotate 35.0*x
    translate  <-4.442389, 9.712349, 3.706365>
  }
}
#declare MainRoofTrussCube1 = object {
  object { // MainRoofTrussCube1 -> MainRoofTrussCube
    MainRoofTrussCube
    rotate <0.0, 0.0, -0.0>
    translate  <-1.209119, 0.0, -0.0>
  }
}
#declare MainRoofTrussCube4 = object {
  object { // MainRoofTrussCube4 -> MainRoofTrussCube
    MainRoofTrussCube
    rotate <0.0, 0.0, -0.0>
    translate  <3.606199, 0.0, -0.0>
  }
}
#declare MainRoofPlate1 = object {
  box { // MainRoofPlate1
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoofPlateTex
    }
    scale <0.025, 0.072962, 0.85>
    rotate <0.0, -54.573605, -90.0>
    translate  <-4.618976, 9.614071, 3.869734>
  }
}
#declare MainRoofPlate2 = object {
  object { // MainRoofPlate2 -> MainRoofPlate1
    MainRoofPlate1
    rotate <0.0, 0.0, -0.0>
    translate  <-0.538753, 0.0, -0.0>
  }
}
#declare MainRoofPlate3 = object {
  object { // MainRoofPlate3 -> MainRoofPlate2
    MainRoofPlate2
    rotate -0.0*z
    translate  <-0.589771, -0.0, 0.0>
  }
}
#declare MainRoofPlate4 = object {
  object { // MainRoofPlate4 -> MainRoofPlate3
    MainRoofPlate3
    translate  -0.540966*x
  }
}
#declare MainRoofPlate5 = object {
  object { // MainRoofPlate5 -> MainRoofPlate4
    MainRoofPlate4
    translate  -0.570208*x
  }
}
#declare MainRoofPlate7 = object {
  box { // MainRoofPlate7
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoofPlateTex
    }
    scale <0.025, 0.072962, 0.85>
    rotate <-180.0, -55.021, -180.0>
    translate  <-3.267092, 7.268296, 3.948865>
  }
}
#declare MainRoofPlate8 = object {
  object { // MainRoofPlate8 -> MainRoofPlate7
    MainRoofPlate7
    rotate <-0.0, 0.0, -0.0>
    translate  <0.0, 0.586946, 0.0>
  }
}
#declare MainRoofPlate9 = object {
  object { // MainRoofPlate9 -> MainRoofPlate8
    MainRoofPlate8
    rotate 0.0*z
    translate  <0.0, 0.688143, -0.0>
  }
}
#declare MainRoofPlate10 = object {
  object { // MainRoofPlate10 -> MainRoofPlate9
    MainRoofPlate9
    translate  0.607185*y
  }
}
#declare DoorCut = object {
  box { // DoorCut
    <-1, -1, -1>, <1, 1, 1>
    scale <0.770101, 0.100835, 0.760524>
    translate  <-2.171713, 9.96598, 1.616975>
  }
}
#declare HouseDoorFrame = object {
  box { // HouseDoorFrame
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.270298, 1.833007>
    translate  <-1.236778, 9.975676, 0.716774>
  }
}


#declare StairPoolColumn = merge {
  #declare KHCENTERCOL101 = 	cylinder
	{// Center Column
	   <0,0,1>, <0,0,0>, 1
		scale <1.0, 1.0, 16.000>
  }
union
{// Plain Column
  object { KHCENTERCOL101 }
  box
  { // Cube001
     <-1, -1, -1>, <1, 1, 1>
     scale <1.6, 1.6, 0.3>
     translate  <0,0,16.450>
  }
  torus { // Torus004
    1.5, 0.5  rotate -x*90
    scale <0.6, 0.6, 0.3>
    translate  <0.0, 0.0, 0.7>
  }
  difference { // CSG001
    cylinder { // Cylndr001
      <0,0,1>, <0,0,0>, 1 
      scale <1.2, 1.2, 0.6>
      translate  <0.0, 0.0, -0.020347>
    }
    torus { // Torus003
      1.597, 0.44  rotate -x*90
      scale <1.0, 1.0, 0.45>
      translate  <0.0, 0.0, 0.308211>
    }
  }
  torus { // Torus002
    1.5, 0.5  rotate -x*90
    scale <0.7, 0.7, 0.35>
    translate  <0.0, 0.020145, 0.5>
  }
  torus { // Torus001
    1.5, 0.5  rotate -x*90
    scale <0.8, 0.8, 0.35>
    translate  0.0*x
  }
  torus
  { // Torus001
     1.5, 0.5  rotate -x*90
     scale <0.7, 0.7, 0.325>
     translate  <0,0,16.000>
  }
  box 
  { // Cube002
     <-1, -1, -1>, <1, 1, 1>
     scale <1.6, 1.6, 0.3>
     translate  <0,0,-0.35>
  }
   rotate <0.000, 0.000, 0.000>
   scale <0.261, 0.261, 0.243>
   translate <-3.734, 7.572, -0.850>
material {AberGraniteGR}
}
}


#include "/mnt/win/programs/povray35/scenes/curvewall.inc"

#declare CurveWall_Ref = object {
  Cube_001
  scale <0.579265, 0.479613, 0.307255>
  translate  <0.668574, -0.293355, -0.916878>
}
#declare CurveWall1_Ref = object {
  Cube_001
  scale <0.579265, 0.479613, 0.307255>
  translate  <0.951162, -0.293355, -0.916878>
}
#declare BottomWallStraightCubeFar = object {
  box { // BottomWallStraightCubeFar
    <-1, -1, -1>, <1, 1, 1>
    scale <0.282659, 0.985092, 0.0751>
    translate  <0.809467, 3.261387, -0.916781>
  }
}
#declare BottomWallStraightCubeFar1 = object {
  object { // BottomWallStraightCubeFar1 -> BottomWallStraightCubeFar
    BottomWallStraightCubeFar
    rotate 90.0*z
    translate  <2.803104, 3.154353, 0.0>
  }
}
#declare BottomWallStraightCubeFar2 = object {
  object { // BottomWallStraightCubeFar2 -> BottomWallStraightCubeFar1
    BottomWallStraightCubeFar1
    rotate -90.0*z
    translate  <-5.124536, 4.773288, 0.0>
  }
}
#declare BottomWallStraightCubeFar4 = object {
  object { // BottomWallStraightCubeFar4 -> BottomWallStraightCubeFar1
    BottomWallStraightCubeFar1
    rotate -0.0*z
    translate  <-3.964078, 0.0, 0.0>
  }
}
#declare BottomWallStraightCubeFar6 = object {
  object { // BottomWallStraightCubeFar6 -> BottomWallStraightCubeFar2
    BottomWallStraightCubeFar2
    rotate -0.0*z
    translate  <-6.499572, -1.970184, 0.0>
  }
}
#declare BottomWallStraightCubeFar8 = object {
  object { // BottomWallStraightCubeFar8 -> BottomWallStraightCubeFar2
    BottomWallStraightCubeFar2
    rotate -90.0*z
    translate  <-5.689853, 5.338605, 0.0>
  }
}
#declare BottomCurveWall = union {
  object { CurveWall_Ref }
  object { CurveWall1_Ref }
  box { // BottomWallStraightCubeNear
    <-1, -1, -1>, <1, 1, 1>
    scale <0.282659, 0.985092, 0.0751>
    translate  <0.809467, -3.290718, -0.916781>
  }
  object { BottomWallStraightCubeFar }
  object { BottomWallStraightCubeFar1 }
  object { BottomWallStraightCubeFar2 }
  object { // BottomWallStraightCubeFar3 -> BottomWallStraightCubeFar2
    BottomWallStraightCubeFar2
    rotate -0.0*z
    translate  -2.559207*x
  }
  object { BottomWallStraightCubeFar4 }
  object { // BottomWallStraightCubeFar5 -> BottomWallStraightCubeFar4
    BottomWallStraightCubeFar4
    rotate 0.0*z
    translate  -1.970177*x
  }
  object { BottomWallStraightCubeFar6 }
  object { // BottomWallStraightCubeFar7 -> BottomWallStraightCubeFar6
    BottomWallStraightCubeFar6
    rotate -90.0*z
    translate  <-12.189423, -5.101334, 0.0>
  }
  object { BottomWallStraightCubeFar8 }
  object { // BottomWallStraightCubeFar9 -> BottomWallStraightCubeFar8
    BottomWallStraightCubeFar8
    rotate -90.0*z
    translate  <-6.255169, 7.308789, 0.0>
  }
}
#declare BenchRailingStand = lathe {
  quadratic_spline
  8  // control points
  <0.499086, -1.040974>,
  <0.212625, -1.190293>,
  <0.449752, -0.441629>,
  <0.215306, 0.249413>,
  <0.385373, 0.965793>,
  <0.273941, 1.291626>,
  <0.266754, 1.564458>,
  <0.384742, 1.995346>
  rotate <90,0,90>
  scale 0.426595
  translate  <0.81047, -2.004484, -0.329263>
}
#declare BenchRailingStand1 = object {
  object { // BenchRailingStand1 -> BenchRailingStand
    BenchRailingStand
    rotate 0.0*y
    translate  <0.253095, 0.517997, 0.0>
  }
}
#declare BenchRailingStand2 = object {
  object { // BenchRailingStand2 -> BenchRailingStand1
    BenchRailingStand1
    translate  <0.388743, 0.497726, 0.0>
  }
}
#declare BenchRailingStand3 = object {
  object { // BenchRailingStand3 -> BenchRailingStand2
    BenchRailingStand2
    translate  <0.223595, 0.49191, 0.0>
  }
}
#declare BenchRailingStand4 = object {
  object { // BenchRailingStand4 -> BenchRailingStand3
    BenchRailingStand3
    translate  0.493177*y
  }
}
#declare BenchRailingStand5 = object {
  object { // BenchRailingStand5 -> BenchRailingStand4
    BenchRailingStand4
    translate  0.558988*y
  }
}
#declare BenchRailingStand6 = object {
  object { // BenchRailingStand6 -> BenchRailingStand5
    BenchRailingStand5
    translate  <-0.273457, 0.484606, 0.0>
  }
}
#declare BenchRailingStand7 = object {
  object { // BenchRailingStand7 -> BenchRailingStand6
    BenchRailingStand6
    translate  <-0.360361, 0.467015, 0.0>
  }
}
#declare BenchRailingStand8 = object {
  object { // BenchRailingStand8 -> BenchRailingStand7
    BenchRailingStand7
    translate  <-0.217705, 0.501668, 0.0>
  }
}
#declare BenchRailingStand9 = object {
  object { // BenchRailingStand9 -> BenchRailingStand8
    BenchRailingStand8
    translate  0.553967*y
  }
}
#declare BenchRailingStand10 = object {
  object { // BenchRailingStand10 -> BenchRailingStand9
    BenchRailingStand9
    translate  0.630068*y
  }
}
#declare BenchRailingStand11 = object {
  object { // BenchRailingStand11 -> BenchRailingStand10
    BenchRailingStand10
    translate  0.621003*y
  }
}
#declare BenchRailingStand12 = object {
  object { // BenchRailingStand12 -> BenchRailingStand11
    BenchRailingStand11
    translate  <-0.542416, 0.161773, 0.0>
  }
}
#declare BenchRailingStand13 = object {
  object { // BenchRailingStand13 -> BenchRailingStand12
    BenchRailingStand12
    translate  -0.50911*x
  }
}
#declare BenchRailingStand14 = object {
  object { // BenchRailingStand14 -> BenchRailingStand13
    BenchRailingStand13
    translate  -0.499594*x
  }
}
#declare BenchRailingStand15 = object {
  object { // BenchRailingStand15 -> BenchRailingStand14
    BenchRailingStand14
    translate  -0.499594*x
  }
}
#declare BenchRailingStand16 = object {
  object { // BenchRailingStand16 -> BenchRailingStand15
    BenchRailingStand15
    translate  0.534259*y
  }
}
#declare BenchRailingStand17 = object {
  object { // BenchRailingStand17 -> BenchRailingStand16
    BenchRailingStand16
    translate  0.48366*y
  }
}
#declare BenchRailingStand18 = object {
  object { // BenchRailingStand18 -> BenchRailingStand17
    BenchRailingStand17
    translate  0.475321*y
  }
}
#declare BenchRailingStand19 = object {
  object { // BenchRailingStand19 -> BenchRailingStand18
    BenchRailingStand18
    translate  0.458643*y
  }
}
#declare BenchRailingStand23 = object {
  object { // BenchRailingStand23 -> BenchRailingStand16
    BenchRailingStand16
    translate  -2.442855*x
  }
}
#declare BenchRailingStand24 = object {
  object { // BenchRailingStand24 -> BenchRailingStand23
    BenchRailingStand23
  }
}
#declare BenchRailingStand25 = object {
  object { // BenchRailingStand25 -> BenchRailingStand24
    BenchRailingStand24
    translate  -0.531491*y
  }
}
#declare BenchRailingStand26 = object {
  object { // BenchRailingStand26 -> BenchRailingStand25
    BenchRailingStand25
    translate  -0.497566*x
  }
}
#declare BenchRailingStand27 = object {
  object { // BenchRailingStand27 -> BenchRailingStand26
    BenchRailingStand26
    translate  -0.50322*x
  }
}
#declare BenchRailingStand28 = object {
  object { // BenchRailingStand28 -> BenchRailingStand27
    BenchRailingStand27
    translate  -0.47495*x
  }
}
#declare BenchRailingStand29 = object {
  object { // BenchRailingStand29 -> BenchRailingStand28
    BenchRailingStand28
    translate  -0.535968*x
  }
}
#declare BenchRailingStand30 = object {
  object { // BenchRailingStand30 -> BenchRailingStand29
    BenchRailingStand29
    translate  -0.470339*x
  }
}
#declare BenchRailingStand31 = object {
  object { // BenchRailingStand31 -> BenchRailingStand30
    BenchRailingStand30
    translate  -0.470339*x
  }
}
#declare BenchRailingStand32 = object {
  object { // BenchRailingStand32 -> BenchRailingStand31
    BenchRailingStand31
    translate  -0.459401*x
  }
}
#declare BenchRailingStand33 = object {
  object { // BenchRailingStand33 -> BenchRailingStand32
    BenchRailingStand32
    translate  -0.571751*x
  }
}
#declare BenchRailingStand34 = object {
  object { // BenchRailingStand34 -> BenchRailingStand33
    BenchRailingStand33
    translate  -0.458906*y
  }
}
#declare BenchRailingStand35 = object {
  object { // BenchRailingStand35 -> BenchRailingStand34
    BenchRailingStand34
    translate  -0.458906*y
  }
}
#declare BenchRailingStand36 = object {
  object { // BenchRailingStand36 -> BenchRailingStand35
    BenchRailingStand35
    translate  -0.44386*y
  }
}
#declare BenchRailingStand37 = object {
  object { // BenchRailingStand37 -> BenchRailingStand36
    BenchRailingStand36
    translate  -0.546055*x
  }
}
#declare BenchRailingStand39 = object {
  object { // BenchRailingStand39 -> BenchRailingStand19
    BenchRailingStand19
    translate  0.566021*y
  }
}
#declare BenchRailingStand40 = object {
  object { // BenchRailingStand40 -> BenchRailingStand39
    BenchRailingStand39
    translate  0.474882*x
  }
}
#declare BenchRailingStand41 = object {
  object { // BenchRailingStand41 -> BenchRailingStand40
    BenchRailingStand40
    translate  0.472673*x
  }
}
#declare BenchRailingStand42 = object {
  object { // BenchRailingStand42 -> BenchRailingStand41
    BenchRailingStand41
    translate  0.455792*x
  }
}
#declare BenchRailingStand43 = object {
  object { // BenchRailingStand43 -> BenchRailingStand42
    BenchRailingStand42
    translate  <0.070385, 0.522861, 0.0>
  }
}
#declare BenchRailingStand44 = object {
  object { // BenchRailingStand44 -> BenchRailingStand43
    BenchRailingStand43
    translate  0.463913*y
  }
}
#declare BenchRailingStand45 = object {
  object { // BenchRailingStand45 -> BenchRailingStand44
    BenchRailingStand44
    translate  0.463913*y
  }
}




//
// ********  OBJECTS  *******
//

#declare LeftPalmPot = lathe {
  quadratic_spline
  9  // control points
  <1.0, -0.985612>,
  <1.336965, -1.076743>,
  <2.0, -0.773375>,
  <1.483899, -0.192764>,
  <2.015124, 0.204497>,
  <2.129025, 0.5>,
  <1.032507, 0.711634>,
  <1.031953, 0.859113>,
  <1.516101, 1.0>
  rotate <90,0,90>
  material {
    Brown_Agate
  }
  scale <0.298027, 0.298027, 0.668137>
  translate  <-0.47553, 2.739959, -0.307624>
}
#declare LeftPalmPot2 = lathe {
  quadratic_spline
  9  // control points
  <1.0, -0.985612>,
  <1.336965, -1.076743>,
  <2.0, -0.773375>,
  <1.483899, -0.192764>,
  <2.015124, 0.204497>,
  <2.129025, 0.5>,
  <1.032507, 0.711634>,
  <1.031953, 0.859113>,
  <1.516101, 1.0>
  rotate <90,0,90>
  material {
    Brown_Agate
  }
  scale <0.469081, 0.469081, 1.051617>
  translate  <-0.612442, -3.187446, 0.139187>
}
#declare RightPalmPot = lathe {
  quadratic_spline
  9  // control points
  <1.0, -0.985612>,
  <1.336965, -1.076743>,
  <2.0, -0.773375>,
  <1.483899, -0.192764>,
  <2.015124, 0.204497>,
  <2.129025, 0.5>,
  <1.032507, 0.711634>,
  <1.031953, 0.859113>,
  <1.516101, 1.0>
  rotate <90,0,90>
  material {
    Brown_Agate
  }
  scale <0.298027, 0.298027, 0.668137>
  translate  <-8.693947, 3.623247, -0.307624>
}
union { // PalmPots
  object { LeftPalmPot }
  object { LeftPalmPot2 }
  object { RightPalmPot }
}


#declare RightSideSceneLights = union {
  object { Light001 }
  object { Light002 }
  translate  <-0.102818, -1.95354, 6.571556>
}
union { // SceneLights
  object { RightSideSceneLights }
  object { LeftSideLight }
}


#declare FarIsland = object { 
  height_field {
    tga "/mnt/win/programs/povray35/scenes/Parkshf.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    Mountains
  }
  scale <5.5, 7.71103, 3.15>
  rotate 45.0*z
  translate  <35.519835, 46.944698, -3.157785>
}
#declare FarIsland1 = object { 
  height_field {
    tga "/mnt/win/programs/povray35/scenes/Parkshf.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    Mountains
  }
  scale <5.5, 7.71103, 3.348469>
  translate  <38.896481, 37.297137, -3.157785>
}
union { // RightsideIslands
  object { FarIsland }
  object { FarIsland1 }
}


difference { // MySkyDiff
  sphere { // MySkySphere
    <0,0,0>,1
    scale 72.865059
  }
  sphere { // MySkySphere1
    <0,0,0>,1
    scale 69.96077
  }
  material {
    Tropics_Cloud_Sky
  }
}


#declare CliffBacking = object { 
  height_field {
    tga "/mnt/win/programs/povray35/scenes/Land1.tga"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    Mountains
  }
  scale <0.970713, 1.0, 0.150685>
  rotate 90.0*x
  translate  <-0.395966, 6.241785, -1.956959>
}
#declare PoolWater = object { 
  height_field {
    tga "/mnt/win/programs/povray35/scenes/Land1.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    Water
  }
  scale <3.994099, 5.090006, 0.291626>
  translate  <-5.308911, 0.634828, -1.331522>
}
union { // HeighFields
  object { CliffBacking }
  object { PoolWater }
}


text {   // DoorText
  ttf    "/mnt/win/WINDOWS/Fonts/Afrioo__.ttf",
  "ABCE",
  1.0,  // Depth
  <0.0,   0.0, 0.0> // Offset
  material {
    Asteroid
  }
  scale <0.696323, 0.984427, 0.215423>
  rotate <90.0, 90.0, 0.0>
  translate  <-4.799487, 9.875071, 2.507282>
}



#declare PoolWalls = union {
  box { // PoolCubeWall
    <-1, -1, -1>, <1, 1, 1>
    scale <0.054653, 5.337651, 1.0>
    translate  <-1.359466, 0.583071, -1.987314>
  }
  box { // PoolCubeWall1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.054653, 1.045593, 1.0>
    rotate -90.0*z
    translate  <-2.436895, 5.650217, -1.987314>
  }
  box { // PoolCubeWall2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.054653, 0.991048, 1.0>
    translate  <-3.48888, 4.67277, -1.987314>
  }
  box { // PoolCubeWall3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.054653, 1.949013, 1.0>
    rotate -90.0*z
    translate  <-5.4914, 3.737315, -1.987314>
  }
  box { // PoolCubeWall4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.054653, 0.722814, 1.0>
    translate  <-7.432916, 3.002924, -1.987314>
  }
  box { // PoolCubeWall5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.054653, 1.949013, 1.0>
    rotate -90.0*z
    translate  <-9.436432, 2.334976, -1.987314>
  }
  box { // PoolFloorCube
    <-1, -1, -1>, <1, 1, 1>
    scale <0.054653, 4.384061, 4.563149>
    rotate <-180.0, -90.0, 90.0>
    translate  <-5.739172, 1.104362, -3.00453>
  }
}
#declare PoolSteps = union {
  box { // PoolStep
    <-1, -1, -1>, <1, 1, 1>
    scale <1.013178, 0.424403, 0.380917>
    translate  <-2.435433, 5.186771, -1.928681>
  }
  box { // PoolStep1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.013178, 0.424403, 0.380917>
    translate  <-2.435433, 4.345069, -2.596922>
  }
}
#declare PoolWallsDecoration = union {
  text {   // PoolDecorationImageWall
    ttf      "/mnt/win/WINDOWS/Fonts/Afrioo__.ttf",
    "E",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      Azurite
    }
    scale <1.228265, 0.447075, 0.019534>
    rotate 90.0*x
    translate  <-3.026319, 5.599604, -1.492539>
  }

  text {   // PoolDecorationImageWall1
    ttf      "/mnt/win/WINDOWS/Fonts/Afrioo__.ttf",
    "E",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      Azurite_3
    }
    scale <1.228265, 0.447075, 0.019534>
    rotate <90.0, -0.0, -90.0>
    translate  <-1.401356, 5.515328, -1.4898>
  }

  text {   // PoolDecorationImageWall2
    ttf      "/mnt/win/WINDOWS/Fonts/Afrioo__.ttf",
    "E",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      Azurite_4
    }
    scale <1.228265, 0.447075, 0.019534>
    rotate <90.0, -0.0, -90.0>
    translate  <-1.401356, 3.969666, -1.4898>
  }

  text {   // PoolDecorationImageWall3
    ttf      "/mnt/win/WINDOWS/Fonts/Afrioo__.ttf",
    "E",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      Azurite
    }
    scale <1.228265, 0.447075, 0.019534>
    rotate <90.0, -0.0, -90.0>
    translate  <-1.401356, 2.462645, -1.4898>
  }

  text {   // PoolDecorationImageWall4
    ttf      "/mnt/win/WINDOWS/Fonts/Afrioo__.ttf",
    "E",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      Azurite_3
    }
    scale <1.228265, 0.447075, 0.019534>
    rotate <90.0, -0.0, -90.0>
    translate  <-1.401356, 0.859021, -1.4898>
  }

  text {   // PoolDecorationImageWall5
    ttf      "/mnt/win/WINDOWS/Fonts/Afrioo__.ttf",
    "E",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      Azurite_4
    }
    scale <1.228265, 0.447075, 0.019534>
    rotate <90.0, -0.0, -90.0>
    translate  <-1.401356, -0.763924, -1.4898>
  }

  text {   // PoolDecorationImageWall6
    ttf      "/mnt/win/WINDOWS/Fonts/Afrioo__.ttf",
    "E",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      Azurite
    }
    scale <1.228265, 0.447075, 0.019534>
    rotate <90.0, -0.0, -90.0>
    translate  <-1.401356, -2.38687, -1.4898>
  }

  text {   // PoolDecorationImageWall7
    ttf      "/mnt/win/WINDOWS/Fonts/Afrioo__.ttf",
    "E",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      Azurite_4
    }
    scale <1.228265, 0.447075, 0.019534>
    rotate 90.0*x
    translate  <-4.77275, 3.698817, -1.4898>
  }

  text {   // PoolDecorationImageWall8
    ttf      "/mnt/win/WINDOWS/Fonts/Afrioo__.ttf",
    "E",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      Azurite_3
    }
    scale <1.228265, 0.447075, 0.019534>
    rotate 90.0*x
    translate  <-6.293885, 3.698817, -1.4898>
  }

  text {   // PoolDecorationImageWall9
    ttf      "/mnt/win/WINDOWS/Fonts/Afrioo__.ttf",
    "F",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      Azurite
    }
    scale <1.586907, 0.756248, 0.019534>
    rotate <90.0, -90.0, -0.0>
    translate  <-6.504123, 3.698817, -2.775964>
  }

  text {   // PoolDecorationImageWall10
    ttf      "/mnt/win/WINDOWS/Fonts/Afrioo__.ttf",
    "I",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      Azurite_4
    }
    scale <1.586907, 0.756248, 0.019534>
    rotate <90.0, -90.0, -0.0>
    translate  <-7.625208, 2.294423, -2.763597>
  }

}
#declare PoolFloorDecorationUni = union {
  object { PoolFloorDecoration }
  object { // PoolFloorDecoration1 -> PoolFloorDecoration
    PoolFloorDecoration
    rotate <-0.0, -0.0, 0.0>
    translate  <3.487781, 0.0, 0.0>
  }
  object { PoolFloorDecoration2 }
  object { // PoolFloorDecoration3 -> PoolFloorDecoration2
    PoolFloorDecoration2
    material {
      Azurite_3
    }
    rotate <0.0, 0.0, -0.0>
    translate  <3.43029, 0.0, 0.0>
  }
  text {   // PoolFloorDecoration4
    ttf      "/mnt/win/WINDOWS/Fonts/Afrioo__.ttf",
    "K",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      Azurite_2
    }
    scale <1.404853, 1.829412, 0.019534>
    rotate 90.0*z
    translate  <-3.465598, -0.038091, -2.963014>
  }

}
union { // Pool
  object { PoolWalls }
  object { PoolSteps }
  object { PoolWallsDecoration }
  object { PoolFloorDecorationUni }
  material {
    Asteroid2
  }
}


#declare MainRoofTrusses = union {
  object { MainRoofTrussCube }
  object { MainRoofTrussCube1 }
  object { // MainRoofTrussCube2 -> MainRoofTrussCube1
    MainRoofTrussCube1
    rotate <0.0, -0.0, 0.0>
    translate  <-1.055231, 0.0, 0.0>
  }
  object { MainRoofTrussCube4 }
  object { // MainRoofTrussCube5 -> MainRoofTrussCube4
    MainRoofTrussCube4
    rotate -0.0*z
    translate  <0.68328, -0.0, 0.0>
  }
  object { // MainRoofTrussCube3 -> MainRoofTrussCube1
    MainRoofTrussCube1
    rotate <0.0, -0.0, 0.0>
    translate  <-2.142469, 0.0, 0.0>
  }
  material {
    T_Wood23_mine
  }
}
#declare MainRoofPlateDiffCuts = union {
  object { MainRoofPlate1 }
  object { MainRoofPlate2 }
  object { MainRoofPlate3 }
  object { MainRoofPlate4 }
  object { MainRoofPlate5 }
  object { // MainRoofPlate6 -> MainRoofPlate5
    MainRoofPlate5
    translate  -0.599449*x
  }
}
#declare LeftRoofPlateDiff = difference {
  box { // MainRoofPlate
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoofPlateTex
    }
    scale <0.025, 2.194639, 0.85>
    rotate <0.0, -54.573605, -90.0>
    translate  <-6.127485, 9.655767, 3.859311>
  }
  object { MainRoofPlateDiffCuts }
}
#declare RightRoofPlateDiff = union {
  box { // RightRoofPlate
    <-1, -1, -1>, <1, 1, 1>
    material {
      RoofPlateTex
    }
    scale <0.025, 0.782111, 0.85>
    rotate <0.0, -54.573605, -90.0>
    translate  <-0.243788, 9.655767, 3.859311>
  }
  material {
    RoofPlateTex
  }
}
#declare RoofPlates = union {
  object { LeftRoofPlateDiff }
  object { RightRoofPlateDiff }
}
#declare MainRoof = union {
  object { MainRoofTrusses }
  object { RoofPlates }
}
#declare DoorRoofFrame = union {
  box { // DoorRoofFrameCube
    <-1, -1, -1>, <1, 1, 1>
    scale <0.062, 1.623907, 0.15>
    translate  <-3.738901, 8.601656, 3.37971>
  }
  box { // DoorRoofFrameCube1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.062, 1.623907, 0.15>
    translate  <-1.175103, 8.601656, 3.37971>
  }
  box { // DoorRoofFrameCube2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.062, 1.346701, 0.15>
    rotate -90.0*z
    translate  <-2.457714, 7.038295, 3.37971>
  }
  box { // DoorRoofFrameCube3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.062, 0.775, 0.15>
    rotate <-35.0, -0.0, -90.0>
    translate  <-1.873642, 7.038295, 3.835194>
  }
  box { // DoorRoofFrameCube4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.062, 0.775, 0.15>
    rotate <35.0, -0.0, -90.0>
    translate  <-3.051386, 7.038295, 3.835194>
  }
  material {
    T_Wood23_mine
  }
}
#declare DoorRoofLeftPlateCuts = union {
  object { MainRoofPlate7 }
  object { MainRoofPlate8 }
  object { MainRoofPlate9 }
  object { MainRoofPlate10 }
  object { // MainRoofPlate11 -> MainRoofPlate10
    MainRoofPlate10
    translate  0.607185*y
  }
}
#declare DoorRoofLeftPlateDiff = difference {
  box { // DoorRoofPlate
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 1.7, 0.85>
    rotate 54.763912*y
    translate  <-3.222009, 8.534396, 3.944246>
  }
  object { DoorRoofLeftPlateCuts }
}
#declare DoorRoofPlates = union {
  box { // DoorRoofPlate1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 1.7, 0.85>
    rotate -54.763908*y
    translate  <-1.724656, 8.534396, 3.943423>
  }
  object { DoorRoofLeftPlateDiff }
  material {
    RoofPlateTex
  }
}
#declare RoofCylCapDiffCuts = union {
  cylinder { // Cylndr030
    <0,0,1>, <0,0,0>, 1 
    scale <0.103621, 0.103621, 3.555875>
    rotate -90.0*x
    translate  <-2.478434, 6.78771, 4.447553>
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <0.136836, 1.76932, 0.12323>
    translate  <-2.482431, 8.546478, 4.299395>
  }
}
#declare RoofCylCapDiff = difference {
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    scale <0.126933, 0.126933, 3.419936>
    rotate -90.0*x
    translate  <-2.478434, 6.83478, 4.447553>
  }
  object { RoofCylCapDiffCuts }
  material {
    RoofPlateTex
  }
}
#declare DoorRoof = union {
  object { DoorRoofFrame }
  object { DoorRoofPlates }
  object { RoofCylCapDiff }
}
#declare WindowFrame = union {
  box { // WindowFrameCubeCube
    <-1, -1, -1>, <1, 1, 1>
    scale <0.062493, 0.058225, 1.257273>
    translate  <-5.041008, 9.974951, 1.289554>
  }
  box { // WindowFrameCubeCube1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.062493, 0.058225, 1.880265>
    rotate -90.0*y
    translate  <-6.981073, 9.975886, 0.087598>
  }
  box { // WindowFrameCubeCube2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.062493, 0.058225, 1.880265>
    rotate -90.0*y
    translate  <-6.981073, 9.975886, 2.473077>
  }
  box { // WindowFrameCubeCube3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.026729, 0.058225, 1.880265>
    rotate -90.0*y
    translate  <-6.981073, 9.975886, 1.273003>
  }
}
#declare BottomDiagonalWoodPieces1 = union {
  box { // DoorWindowFrameCube9
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025942, 0.058225, 0.275425>
    rotate 40.0*y
    translate  <-1.558877, 9.974951, -0.692557>
  }
  box { // DoorWindowFrameCube10
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025942, 0.058225, 0.3903>
    rotate 40.0*y
    translate  <-1.634277, 9.974951, -0.602048>
  }
  box { // DoorWindowFrameCube16
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025942, 0.058225, 0.510396>
    rotate 40.0*y
    translate  <-1.716297, 9.974951, -0.50424>
  }
  box { // DoorWindowFrameCube17
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025942, 0.058225, 0.630002>
    rotate 40.0*y
    translate  <-1.793689, 9.974951, -0.405741>
  }
  translate  <-3.697266, 0.0, 1.026245>
}
#declare TopDiagonalWoodPieces_Window = union {
  box { // DoorWindowFrameCube18
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025942, 0.058225, 0.275425>
    rotate -40.0*y
    translate  <-1.558877, 9.974951, 1.18558>
  }
  box { // DoorWindowFrameCube19
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025942, 0.058225, 0.3903>
    rotate -40.0*y
    translate  <-1.634277, 9.974951, 1.090771>
  }
  box { // DoorWindowFrameCube20
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025942, 0.058225, 0.510396>
    rotate -40.0*y
    translate  <-1.716297, 9.974951, 1.005787>
  }
  box { // DoorWindowFrameCube21
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025942, 0.058225, 0.630002>
    rotate -40.0*y
    translate  <-1.793689, 9.974951, 0.913545>
  }
  translate  <-3.697266, 0.0, 1.026245>
}
#declare WindowDiagonalWoodPieces = union {
  object { BottomDiagonalWoodPieces1 }
  object { TopDiagonalWoodPieces_Window }
}
#declare HouseWindow = union {
  object { WindowFrame }
  object { WindowDiagonalWoodPieces }
  box { // Wall_Window
    <-1, -1, -1>, <1, 1, 1>
    material {
      WindowMaterial
    }
    scale <1.739197, 0.007561, 1.201831>
    translate  <-6.788316, 9.991408, 1.279825>
  }
  material {
    T_Wood23_mine
  }
}
#declare BigDoorWindowCuts = union {
  object { DoorCut }
  object { // DoorCut1 -> DoorCut
    DoorCut
    rotate <0.0, -0.0, -0.0>
    translate  -1.742944*z
  }
  box { // DoorCut2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.160912, 0.100835, 0.574805>
    translate  <-3.263447, 9.96598, 1.798273>
  }
  box { // DoorCut3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.160912, 0.100835, 0.574805>
    translate  <-3.263447, 9.96598, -0.306403>
  }
}
#declare DoorWindowSlitCuts = union {
  box { // DoorWindowFrameCube13
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025942, 0.078409, 0.37343>
    rotate -90.0*y
    translate  <-2.110848, 9.979436, 0.748169>
  }
  box { // DoorWindowFrameCube14
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025942, 0.078409, 0.203688>
    rotate -90.0*y
    translate  <-2.735328, 9.979436, 0.748169>
  }
  box { // DoorWindowFrameCube15
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025942, 0.078409, 0.151299>
    rotate -90.0*y
    translate  <-1.553426, 9.979436, 0.748169>
  }
}
#declare DoorCubeCuts = union {
  object { BigDoorWindowCuts }
  object { DoorWindowSlitCuts }
}
#declare DoorCubeDiff = difference {
  box { // Master_DoorCube
    <-1, -1, -1>, <1, 1, 1>
    scale <1.203208, 0.057203, 1.833007>
    translate  <-2.401552, 9.975676, 0.716774>
  }
  object { DoorCubeCuts }
  material {
    T_Wood23_mine
  }
}
#declare TopDiagonalWoodPieces = union {
  box { // DoorWindowFrameCube1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025942, 0.058225, 0.275425>
    rotate -40.0*y
    translate  <-1.939725, 9.974951, 1.051446>
  }
  box { // DoorWindowFrameCube2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025942, 0.058225, 0.3903>
    rotate -40.0*y
    translate  <-1.866623, 9.974951, 1.140213>
  }
  box { // DoorWindowFrameCube3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025942, 0.058225, 0.510396>
    rotate -40.0*y
    translate  <-1.788299, 9.974951, 1.228979>
  }
}
#declare BottomDiagonalWoodPieces = union {
  box { // DoorWindowFrameCube4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025942, 0.058225, 0.275425>
    rotate 40.0*y
    translate  <-1.558877, 9.974951, -0.692557>
  }
  box { // DoorWindowFrameCube5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025942, 0.058225, 0.3903>
    rotate 40.0*y
    translate  <-1.634277, 9.974951, -0.602048>
  }
  box { // DoorWindowFrameCube6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025942, 0.058225, 0.510396>
    rotate 40.0*y
    translate  <-1.716297, 9.974951, -0.50424>
  }
}
#declare DiagonalWoodPieces = union {
  object { TopDiagonalWoodPieces }
  object { BottomDiagonalWoodPieces }
}
#declare TopwoodPieces = union {
  box { // DoorWindowFrameCube7
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025942, 0.058225, 0.374551>
    rotate -90.0*y
    translate  <-2.581897, 9.974951, 0.939942>
  }
  box { // DoorWindowFrameCube8
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025942, 0.058225, 0.374551>
    rotate -90.0*y
    translate  <-2.581897, 9.974951, 1.040622>
  }
}
#declare BottomWoodPieces = union {
  box { // DoorWindowFrameCube11
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025942, 0.058225, 0.374551>
    rotate -90.0*y
    translate  <-2.581897, 9.974951, -0.819571>
  }
  box { // DoorWindowFrameCube12
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025942, 0.058225, 0.374551>
    rotate -90.0*y
    translate  <-2.581897, 9.974951, -0.733273>
  }
}
#declare HorizontalLeftPaneWoodPieces = union {
  object { TopwoodPieces }
  object { BottomWoodPieces }
}
#declare HousedoorFrame = union {
  box { // DoorWindowFrameCube
    <-1, -1, -1>, <1, 1, 1>
    scale <0.062493, 0.058225, 1.634539>
    translate  <-2.160606, 9.974951, 0.744773>
  }
  object { DiagonalWoodPieces }
  object { HorizontalLeftPaneWoodPieces }
  material {
    T_Wood23_mine
  }
}
#declare HouseDoor = union {
  object { DoorCubeDiff }
  object { HousedoorFrame }
  box { // Door_Window
    <-1, -1, -1>, <1, 1, 1>
    material {
      WindowMaterial
    }
    scale <1.203208, 0.013941, 1.833007>
    translate  <-2.401552, 9.991408, 0.716774>
  }
}
#declare DoorFrame = union {
  object { HouseDoorFrame }
  object { // HouseDoorFrame1 -> HouseDoorFrame
    HouseDoorFrame
    translate  <-2.313591, 0.0, -0.0>
  }
  box { // HouseDoorFrame2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.270298, 1.210048>
    rotate -90.0*y
    translate  <-2.393611, 9.975676, 2.507357>
  }
  material {
    T_Wood23_mine
  }
}
union { // House
  object { MainRoof }
  object { DoorRoof }
  object { HouseWindow }
  object { HouseDoor }
  object { DoorFrame }
}


text {   // RailingFillerAgainstHouseWall
  ttf    "/mnt/win/WINDOWS/Fonts/Afrioo__.ttf",
  "A",
  1.0,  // Depth
  <0.0,   0.0, 0.0> // Offset
  material {
    AberGraniteGR
  }
  scale <1.139335, 1.658541, 0.570505>
  rotate <90.0, 0.0, 90.0>
  translate  <-0.046115, 8.752747, -0.990869>
}



#declare WallBlockerCutCubes = union {
  box { // HouseDoorCutCube
    <-1, -1, -1>, <1, 1, 1>
    material {
      ProxyMat
    }
    scale <1.203208, 0.270298, 1.833007>
    translate  <-2.401552, 9.975676, 0.716774>
  }
  box { // HouseWindowCutCube
    <-1, -1, -1>, <1, 1, 1>
    material {
      ProxyMat
    }
    scale <1.794289, 0.270298, 1.256064>
    translate  <-6.768104, 9.975676, 1.286108>
  }
}
#declare HouseWallBlockerCuts = difference {
  box { // HouseWallBlocker
    <-1, -1, -1>, <1, 1, 1>
    scale <6.13, 0.01, 3.425>
    translate  <-5.763158, 9.987968, 2.304391>
  }
  object { WallBlockerCutCubes }
}
union { // Blockers
  object { HouseWallBlockerCuts }
  material {
    BlockerMat
  }
}


union { // StairPoolColumns
  object { StairPoolColumn }
  object { // StairPoolColumn1 -> StairPoolColumn
    StairPoolColumn
    rotate <0.0, 0.0, 0.0>
    translate  2.547846*x
  }
}


#declare BottomCurveWallFloorStrip_Ref = object {
  Cube_001
  scale <0.57726, 0.479613, 0.057243>
  translate  <0.584678, -0.293355, -0.97833>
}
#declare FloorstripCurveWall = union {
  object { BottomCurveWallFloorStrip_Ref }
  box { // BottomWallStraightCubeStrip
    <-1, -1, -1>, <1, 1, 1>
    scale <0.041687, 0.985092, 0.014034>
    translate  <0.48509, -3.290718, -0.978354>
  }
  material {
    AberGranitePR
  }
}
#declare CurvewallBehindBench = union {
  object { BottomCurveWall }
  object { // TopCurveWall -> BottomCurveWall
    BottomCurveWall
    translate  1.509261*z
  }
  object { FloorstripCurveWall }
  material {
    AberGraniteGR
  }
}
#declare BenchRailingStands = union {
  object { BenchRailingStand }
  object { BenchRailingStand1 }
  object { BenchRailingStand2 }
  object { BenchRailingStand3 }
  object { BenchRailingStand4 }
  object { BenchRailingStand5 }
  object { BenchRailingStand6 }
  object { BenchRailingStand7 }
  object { BenchRailingStand8 }
  object { BenchRailingStand9 }
  object { BenchRailingStand10 }
  object { BenchRailingStand11 }
  object { BenchRailingStand12 }
  object { BenchRailingStand13 }
  object { BenchRailingStand14 }
  object { BenchRailingStand15 }
  object { BenchRailingStand16 }
  object { BenchRailingStand17 }
  object { BenchRailingStand18 }
  object { BenchRailingStand19 }
  object { // BenchRailingStand20 -> BenchRailingStand19
    BenchRailingStand19
    translate  -2.430579*x
  }
  object { // BenchRailingStand21 -> BenchRailingStand18
    BenchRailingStand18
    translate  -2.430579*x
  }
  object { // BenchRailingStand22 -> BenchRailingStand17
    BenchRailingStand17
    translate  -2.436717*x
  }
  object { BenchRailingStand23 }
  object { BenchRailingStand24 }
  object { BenchRailingStand25 }
  object { BenchRailingStand26 }
  object { BenchRailingStand27 }
  object { BenchRailingStand28 }
  object { BenchRailingStand29 }
  object { BenchRailingStand30 }
  object { BenchRailingStand31 }
  object { BenchRailingStand32 }
  object { BenchRailingStand33 }
  object { BenchRailingStand34 }
  object { BenchRailingStand35 }
  object { BenchRailingStand36 }
  object { BenchRailingStand37 }
  object { // BenchRailingStand38 -> BenchRailingStand37
    BenchRailingStand37
    translate  -0.473248*x
  }
  object { BenchRailingStand39 }
  object { BenchRailingStand40 }
  object { BenchRailingStand41 }
  object { BenchRailingStand42 }
  object { BenchRailingStand43 }
  object { BenchRailingStand44 }
  object { BenchRailingStand45 }
  object { // BenchRailingStand46 -> BenchRailingStand45
    BenchRailingStand45
    translate  0.457889*y
  }
  material {
    AberGranitePR
  }
}
union { // BenchCurveWall
  object { CurvewallBehindBench }
  object { BenchRailingStands }
}


#declare BenchCubeTop = merge {
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
  scale <1.219993, 3.324848, 0.218848>
}
#declare CylinderEdgeCuts = union {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.518227>
    translate  <-0.535515, -1.226048, -0.242681>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.518227>
    translate  <-0.535515, 1.338788, -0.242681>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.518227>
    translate  <0.483664, 1.338788, -0.242681>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.518227>
    translate  <0.483664, -1.209159, -0.242681>
  }
}
#declare CubeEdgeCuts = union {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <0.10268, 1.288029, 0.26557>
    translate  <-0.542824, 0.077546, 0.0>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <0.10268, 1.288029, 0.26557>
    translate  <0.498511, 0.077546, 0.0>
  }
}
#declare InnerCubeEdgeCuts = union {
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <0.014056, 1.288029, 0.26557>
    translate  <-0.332341, 0.077546, 0.0>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <0.014056, 1.288029, 0.26557>
    translate  <0.276951, 0.077546, 0.0>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <0.014056, 0.584574, 0.26557>
    rotate -90.0*z
    translate  <-0.044312, 0.974867, 0.0>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <0.014056, 0.584574, 0.26557>
    rotate -90.0*z
    translate  <-0.044312, -0.853008, 0.0>
  }
}
#declare BenchPatCutCubeUni = union {
  object { CylinderEdgeCuts }
  object { CubeEdgeCuts }
  object { InnerCubeEdgeCuts }
}
#declare BenchPatCutCubeDiff = difference {
  box { // BenchPatCutCube
    <-1, -1, -1>, <1, 1, 1>
    scale <0.760427, 1.232526, 0.208093>
  }
  object { BenchPatCutCubeUni }
}
#declare OuterEdgeCylCutDiffFront = difference {
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.518227>
    translate  <-0.037004, -1.680247, -0.242681>
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    scale <0.201058, 0.201058, 0.633181>
    translate  <-0.037004, -1.680247, -0.293772>
  }
}
#declare OuterEdgeCylCutDiffBack = difference {
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.518227>
    translate  <-0.037004, -1.680247, -0.242681>
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    scale <0.201058, 0.201058, 0.633181>
    translate  <-0.037004, -1.680247, -0.293772>
  }
  translate  3.354782*y
}
#declare MiddleEdgeCylCuts = union {
  object { OuterEdgeCylCutDiffFront }
  object { OuterEdgeCylCutDiffBack }
}
#declare FrontCornerCylCuts = union {
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.518227>
    translate  <-0.581121, -1.620889, -0.242681>
  }
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.518227>
    translate  <0.51206, -1.620889, -0.242681>
  }
  translate  <0.544117, -0.059358, 0.0>
}
#declare RearCornerCylCuts = union {
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.518227>
    translate  <-0.581121, -1.620889, -0.242681>
  }
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.518227>
    translate  <0.51206, -1.620889, -0.242681>
  }
  translate  <0.544117, 3.157759, 0.0>
}
#declare CornerCylCuts = union {
  object { FrontCornerCylCuts }
  object { RearCornerCylCuts }
  material {
    Asteroid
  }
  translate  <-0.544117, 0.059358, 0.0>
}
#declare EdgesCutsUni = union {
  object { MiddleEdgeCylCuts }
  object { CornerCylCuts }
  translate  0.05539*x
}
#declare LeftRippleCuts = union {
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    scale <0.013332, 0.01333, 2.499855>
    rotate -90.0*x
    translate  <-0.561564, -1.254818, 0.110775>
  }
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    scale <0.013332, 0.01333, 2.139115>
    rotate -90.0*x
    translate  <-0.517126, -1.064866, 0.116404>
  }
}
#declare RightRippleCuts = union {
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    scale <0.013332, 0.01333, 2.499855>
    rotate -90.0*x
    translate  <0.573759, -1.254818, 0.110775>
  }
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    scale <0.013332, 0.01333, 2.139115>
    rotate -90.0*x
    translate  <0.535628, -1.064866, 0.116404>
  }
}
#declare TopRippleCutsUni = union {
  object { LeftRippleCuts }
  object { RightRippleCuts }
  material {
    Asteroid
  }
  translate  0.05539*x
}
#declare TwoSymbols = union {
  text {   // EdgeSymbol
    ttf      "/mnt/win/WINDOWS/Fonts/Brdbt-f2.ttf",
    "A",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      T_Grnt19
    }
    scale <0.19352, 0.180345, 0.150616>
    rotate 45.0*z
    translate  <-0.317809, -1.502081, 0.029247>
  }

  text {   // EdgeSymbol1
    ttf      "/mnt/win/WINDOWS/Fonts/Brdbt-f2.ttf",
    "A",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      T_Grnt19
    }
    scale <0.19352, 0.180345, 0.150616>
    rotate -45.0*z
    translate  <0.122505, -1.374967, 0.029247>
  }

}
#declare TwoSymbols1 = union {
  text {   // EdgeSymbol2
    ttf      "/mnt/win/WINDOWS/Fonts/Brdbt-f2.ttf",
    "A",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      T_Grnt19
    }
    scale <0.19352, 0.180345, 0.150616>
    rotate 45.0*z
    translate  <-0.317809, -1.502081, 0.029247>
  }

  text {   // EdgeSymbol3
    ttf      "/mnt/win/WINDOWS/Fonts/Brdbt-f2.ttf",
    "A",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      T_Grnt19
    }
    scale <0.19352, 0.180345, 0.150616>
    rotate -45.0*z
    translate  <0.122505, -1.374967, 0.029247>
  }

  rotate -180.0*x
  translate  0.208445*z
}
#declare TopEdgeSymbols = union {
  object { TwoSymbols }
  object { TwoSymbols1 }
  translate  0.05539*x
}
#declare FilligereeBorders4 = union {
  text {   // InnerBorderFilligeree8
    ttf      "/mnt/win/WINDOWS/Fonts/Brdb-fi.ttf",
    "A",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <0.25, 0.25, 0.115>
    translate  <-0.303334, 0.70145, 0.052938>
  }

  text {   // InnerBorderFilligeree9
    ttf      "/mnt/win/WINDOWS/Fonts/Brdb-fi.ttf",
    "A",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <0.25, 0.25, 0.115>
    rotate -90.0*z
    translate  <0.002933, 0.951991, 0.052938>
  }

}
#declare FilligereeBorders5 = union {
  text {   // InnerBorderFilligeree10
    ttf      "/mnt/win/WINDOWS/Fonts/Brdb-fi.ttf",
    "A",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <0.25, 0.25, 0.115>
    translate  <-0.303334, 0.70145, 0.052938>
  }

  text {   // InnerBorderFilligeree11
    ttf      "/mnt/win/WINDOWS/Fonts/Brdb-fi.ttf",
    "A",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <0.25, 0.25, 0.115>
    rotate -90.0*z
    translate  <0.002933, 0.951991, 0.052938>
  }

  rotate -180.0*z
  translate  <-0.052351, 0.126119, 0.0>
}
#declare FilligereeBordersTop2 = union {
  object { FilligereeBorders4 }
  object { FilligereeBorders5 }
  translate  0.05539*x
}
#declare BenchCubeHorizStripeCut = merge {
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
  scale <1.394798, 3.544973, 0.042456>
  translate  0.05539*x
}
#declare BenchTopDiffCuts = union {
  object { EdgesCutsUni }
  object { TopRippleCutsUni }
  object { TopEdgeSymbols }
  object { FilligereeBordersTop2 }
  object { BenchCubeHorizStripeCut }
  material {
    Asteroid
  }
  translate  -0.05539*x
}
#declare BenchTopDiff = difference {
  object { BenchCubeTop }
  object { BenchPatCutCubeDiff }
  object { BenchTopDiffCuts }
  material {
    AberGraniteGR
  }
}
#declare BenchCubeTop1 = merge {
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
  scale <1.219993, 3.324848, 0.218848>
}
#declare OuterEdgeCylCutDiffFront1 = difference {
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.518227>
    translate  <-0.037004, -1.680247, -0.242681>
  }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    scale <0.201058, 0.201058, 0.633181>
    translate  <-0.037004, -1.680247, -0.293772>
  }
  translate  0.05539*x
}
#declare OuterEdgeCylCutDiffBack1 = difference {
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.518227>
    translate  <-0.037004, -1.680247, -0.242681>
  }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    scale <0.201058, 0.201058, 0.633181>
    translate  <-0.037004, -1.680247, -0.293772>
  }
  translate  <0.05539, 3.354782, 0.0>
}
#declare BenchTopDiffCuts1 = union {
  object { OuterEdgeCylCutDiffFront1 }
  object { OuterEdgeCylCutDiffBack1 }
  translate  -0.05539*x
}
#declare TwoSymbols2 = union {
  text {   // EdgeSymbol4
    ttf      "/mnt/win/WINDOWS/Fonts/Brdbt-f2.ttf",
    "A",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      T_Grnt19
    }
    scale <0.19352, 0.180345, 0.150616>
    rotate 45.0*z
    translate  <-0.317809, -1.502081, 0.029247>
  }

  text {   // EdgeSymbol5
    ttf      "/mnt/win/WINDOWS/Fonts/Brdbt-f2.ttf",
    "A",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      T_Grnt19
    }
    scale <0.19352, 0.180345, 0.150616>
    rotate -45.0*z
    translate  <0.122505, -1.374967, 0.029247>
  }

}
#declare TwoSymbols3 = union {
  text {   // EdgeSymbol6
    ttf      "/mnt/win/WINDOWS/Fonts/Brdbt-f2.ttf",
    "A",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      T_Grnt19
    }
    scale <0.19352, 0.180345, 0.150616>
    rotate 45.0*z
    translate  <-0.317809, -1.502081, 0.029247>
  }

  text {   // EdgeSymbol7
    ttf      "/mnt/win/WINDOWS/Fonts/Brdbt-f2.ttf",
    "A",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      T_Grnt19
    }
    scale <0.19352, 0.180345, 0.150616>
    rotate -45.0*z
    translate  <0.122505, -1.374967, 0.029247>
  }

  rotate -180.0*x
  translate  0.208445*z
}
#declare TopEdgeSymbols1 = union {
  object { TwoSymbols2 }
  object { TwoSymbols3 }
  material {
    Azurite
  }
  translate  0.05539*x
}
#declare BenchTopPatternUnis = union {
  object { BenchTopDiffCuts1 }
  object { TopEdgeSymbols1 }
}
#declare CylinderEdgeCuts1 = union {
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.518227>
    translate  <-0.535515, -1.226048, -0.242681>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.518227>
    translate  <-0.535515, 1.338788, -0.242681>
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.518227>
    translate  <0.483664, 1.338788, -0.242681>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.518227>
    translate  <0.483664, -1.209159, -0.242681>
  }
}
#declare CubeEdgeCuts1 = union {
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <0.10268, 1.288029, 0.26557>
    translate  <-0.542824, 0.077546, 0.0>
  }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <0.10268, 1.288029, 0.26557>
    translate  <0.498511, 0.077546, 0.0>
  }
}
#declare InnerCubeEdgeCuts1 = union {
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <0.014056, 1.288029, 0.26557>
    translate  <-0.332341, 0.077546, 0.0>
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <0.014056, 1.288029, 0.26557>
    translate  <0.276951, 0.077546, 0.0>
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <0.014056, 0.584574, 0.26557>
    rotate -90.0*z
    translate  <-0.044312, 0.974867, 0.0>
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <0.014056, 0.584574, 0.26557>
    rotate -90.0*z
    translate  <-0.044312, -0.853008, 0.0>
  }
}
#declare BenchPatCutCubeUni1 = union {
  object { CylinderEdgeCuts1 }
  object { CubeEdgeCuts1 }
  object { InnerCubeEdgeCuts1 }
}
#declare BenchPatCutCubeDiff1 = difference {
  box { // BenchPatCutCube1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.760427, 1.232526, 0.208093>
  }
  object { BenchPatCutCubeUni1 }
}
#declare BenchCubeHorizStripeCut1 = merge {
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
  scale <1.394798, 3.544973, 0.042456>
  translate  0.05539*x
}
#declare FrontCornerCylCuts1 = union {
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.518227>
    translate  <-0.581121, -1.620889, -0.242681>
  }
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.518227>
    translate  <0.51206, -1.620889, -0.242681>
  }
  translate  <0.544117, -0.059358, 0.0>
}
#declare RearCornerCylCuts1 = union {
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.518227>
    translate  <-0.581121, -1.620889, -0.242681>
  }
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.518227>
    translate  <0.51206, -1.620889, -0.242681>
  }
  translate  <0.544117, 3.157759, 0.0>
}
#declare CornerCylCuts1 = union {
  object { FrontCornerCylCuts1 }
  object { RearCornerCylCuts1 }
  translate  <-0.544117, 0.059358, 0.0>
}
#declare BenchHorizStripeDiff = union {
  object { CornerCylCuts1 }
}
#declare BenchHorizStripeCutUni = difference {
  object { BenchCubeHorizStripeCut1 }
  object { BenchHorizStripeDiff }
}
#declare BenchTopPatternIntsCSG = union {
  object { BenchPatCutCubeDiff1 }
  object { BenchHorizStripeCutUni }
}
#declare BenchTopPatternInts = union {
  object { BenchTopPatternUnis }
  object { BenchTopPatternIntsCSG }
}
#declare BenchTopInt = intersection {
  object { BenchCubeTop1 }
  object { BenchTopPatternInts }
  material {
    T_Grnt19
  }
}
#declare BenchCubeTop2 = merge {
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
  scale <1.219993, 3.324848, 0.218848>
}
#declare FilligereeBorders2 = union {
  text {   // InnerBorderFilligeree4
    ttf      "/mnt/win/WINDOWS/Fonts/Brdb-fi.ttf",
    "A",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <0.25, 0.25, 0.115>
    translate  <-0.303334, 0.70145, 0.052938>
  }

  text {   // InnerBorderFilligeree5
    ttf      "/mnt/win/WINDOWS/Fonts/Brdb-fi.ttf",
    "A",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <0.25, 0.25, 0.115>
    rotate -90.0*z
    translate  <0.002933, 0.951991, 0.052938>
  }

}
#declare FilligereeBorders3 = union {
  text {   // InnerBorderFilligeree6
    ttf      "/mnt/win/WINDOWS/Fonts/Brdb-fi.ttf",
    "A",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <0.25, 0.25, 0.115>
    translate  <-0.303334, 0.70145, 0.052938>
  }

  text {   // InnerBorderFilligeree7
    ttf      "/mnt/win/WINDOWS/Fonts/Brdb-fi.ttf",
    "A",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <0.25, 0.25, 0.115>
    rotate -90.0*z
    translate  <0.002933, 0.951991, 0.052938>
  }

  rotate -180.0*z
  translate  <-0.052351, 0.126119, 0.0>
}
#declare FilligereeBordersTop1 = union {
  object { FilligereeBorders2 }
  object { FilligereeBorders3 }
}
#declare BenchFilligereeInt = intersection {
  object { BenchCubeTop2 }
  object { FilligereeBordersTop1 }
  material {
    Gold_Metal
  }
}
#declare BenchInts = union {
  object { BenchTopInt }
  object { BenchFilligereeInt }
}
#declare BenchTop = union {
  object { BenchTopDiff }
  object { BenchInts }
}
#declare BenchLeg = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.6000, 0.6000, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-0.7020, -0.7020, 0.7980>, <0.7020, 0.7020, 1.0020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.6020, -0.6020, -0.0020>, <0.6020, 0.6020, 0.1020> } } }
  scale <0.25, 0.25, 0.867209>
  translate  <0.0, -1.223352, -0.950494>
}
#declare BenchLegCutout = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.6000, 0.6000, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-0.7020, -0.7020, 0.7980>, <0.7020, 0.7020, 1.0020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.6020, -0.6020, -0.0020>, <0.6020, 0.6020, 0.1020> } } }
  scale <0.15, 0.15, 0.678636>
  translate  <-0.235465, -1.427781, -0.855953>
}
#declare BenchLegCutout1 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.6000, 0.6000, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-0.7020, -0.7020, 0.7980>, <0.7020, 0.7020, 1.0020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.6020, -0.6020, -0.0020>, <0.6020, 0.6020, 0.1020> } } }
  scale <0.15, 0.15, 0.678636>
  translate  <0.239759, -1.427781, -0.855953>
}
#declare TwoBenchLegCutouts = union {
  object { BenchLegCutout }
  object { BenchLegCutout1 }
}
#declare BenchLegCutout2 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.6000, 0.6000, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-0.7020, -0.7020, 0.7980>, <0.7020, 0.7020, 1.0020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.6020, -0.6020, -0.0020>, <0.6020, 0.6020, 0.1020> } } }
  scale <0.15, 0.15, 0.678636>
  translate  <-0.235465, -1.427781, -0.855953>
}
#declare BenchLegCutout3 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.6000, 0.6000, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-0.7020, -0.7020, 0.7980>, <0.7020, 0.7020, 1.0020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.6020, -0.6020, -0.0020>, <0.6020, 0.6020, 0.1020> } } }
  scale <0.15, 0.15, 0.678636>
  translate  <0.239759, -1.427781, -0.855953>
}
#declare TwoBenchLegCutouts2 = union {
  object { BenchLegCutout2 }
  object { BenchLegCutout3 }
  translate  0.408532*y
}
#declare BenchLegCutouts = union {
  object { TwoBenchLegCutouts }
  object { TwoBenchLegCutouts2 }
}
#declare RoundedCylCuts = union {
  object { BenchLegCutouts }
}
#declare TorusCuts = union {
  torus { // BenchLegTorusCut
    1.5, 0.5  rotate -x*90
    scale <0.238616, 0.23862, 0.159897>
    translate  <0.0, -1.228432, -0.754983>
  }
  torus { // BenchLegTorusCut1
    1.5, 0.5  rotate -x*90
    scale <0.238616, 0.23862, 0.159897>
    translate  <0.0, -1.228432, -0.270033>
  }
  torus { // BenchLegTorusCut2
    1.5, 0.5  rotate -x*90
    scale <0.238616, 0.23862, 0.159897>
    translate  <0.0, -1.228432, -0.506496>
  }
}
#declare BenchLegCutsUni = union {
  object { RoundedCylCuts }
  object { TorusCuts }
}
#declare BenchLegCSG = difference {
  object { BenchLeg }
  object { BenchLegCutsUni }
  material {
    AberGraniteGR
  }
}
#declare BenchLeg1 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.6000, 0.6000, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-0.7020, -0.7020, 0.7980>, <0.7020, 0.7020, 1.0020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.6020, -0.6020, -0.0020>, <0.6020, 0.6020, 0.1020> } } }
  scale <0.25, 0.25, 0.867209>
  translate  <0.0, -1.223352, -0.950494>
}
#declare BenchLegCutout4 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.6000, 0.6000, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-0.7020, -0.7020, 0.7980>, <0.7020, 0.7020, 1.0020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.6020, -0.6020, -0.0020>, <0.6020, 0.6020, 0.1020> } } }
  scale <0.15, 0.15, 0.678636>
  translate  <-0.235465, -1.427781, -0.855953>
}
#declare BenchLegCutout5 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.6000, 0.6000, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-0.7020, -0.7020, 0.7980>, <0.7020, 0.7020, 1.0020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.6020, -0.6020, -0.0020>, <0.6020, 0.6020, 0.1020> } } }
  scale <0.15, 0.15, 0.678636>
  translate  <0.239759, -1.427781, -0.855953>
}
#declare TwoBenchLegCutouts1 = union {
  object { BenchLegCutout4 }
  object { BenchLegCutout5 }
}
#declare BenchLegCutout6 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.6000, 0.6000, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-0.7020, -0.7020, 0.7980>, <0.7020, 0.7020, 1.0020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.6020, -0.6020, -0.0020>, <0.6020, 0.6020, 0.1020> } } }
  scale <0.15, 0.15, 0.678636>
  translate  <-0.235465, -1.427781, -0.855953>
}
#declare BenchLegCutout7 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.6000, 0.6000, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-0.7020, -0.7020, 0.7980>, <0.7020, 0.7020, 1.0020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.6020, -0.6020, -0.0020>, <0.6020, 0.6020, 0.1020> } } }
  scale <0.15, 0.15, 0.678636>
  translate  <0.239759, -1.427781, -0.855953>
}
#declare TwoBenchLegCutouts3 = union {
  object { BenchLegCutout6 }
  object { BenchLegCutout7 }
  translate  0.408532*y
}
#declare BenchLegCutouts1 = union {
  object { TwoBenchLegCutouts1 }
  object { TwoBenchLegCutouts3 }
}
#declare RoundedCylCuts1 = union {
  object { BenchLegCutouts1 }
}
#declare TorusCuts1 = union {
  torus { // BenchLegTorusCut3
    1.5, 0.5  rotate -x*90
    scale <0.238616, 0.23862, 0.159897>
    translate  <0.0, -1.228432, -0.754983>
  }
  torus { // BenchLegTorusCut4
    1.5, 0.5  rotate -x*90
    scale <0.238616, 0.23862, 0.159897>
    translate  <0.0, -1.228432, -0.270033>
  }
  torus { // BenchLegTorusCut5
    1.5, 0.5  rotate -x*90
    scale <0.238616, 0.23862, 0.159897>
    translate  <0.0, -1.228432, -0.506496>
  }
}
#declare BenchLegCutsUni1 = union {
  object { RoundedCylCuts1 }
  object { TorusCuts1 }
}
#declare BenchLegCSG1 = difference {
  object { BenchLeg1 }
  object { BenchLegCutsUni1 }
  material {
    AberGraniteGR
  }
  translate  2.44268*y
}
#declare BenchLegs = union {
  object { BenchLegCSG }
  object { BenchLegCSG1 }
}
union { // Bench
  object { BenchTop }
  object { BenchLegs }
  translate  -0.040821*z
}


