//The palm trees

#declare  Palm_Material =
material{
 texture{//pigment{color rgbf<0.7,1.0,0.1,0.3>}
        pigment{color rgb<0.7,1.0,0.1>}
        normal {bumps 0.25 scale <1,0.5,0.002>}
        finish { ambient 0.4 diffuse 0.5 reflection 0.1 phong 0.7 }    
        }//--------
// interior{ caustics 0.2} 
  }
#declare Oleaf =  sphere { <1, 0, 1.732> 2.01 
                          clipped_by{sphere {<1,0,-1.732>,2 scale<1,0.03,0.5> }}
                          scale<1,1.35,1>} //-------------------

//#declare Zufall0 = seed (1000);
#declare Zufall1 = seed (1021);
#declare Zufall2 = seed (1022);
#declare Zufall3 = seed (1023);
              
#macro Palm_Head(Number_of_arms)
 union{

#local Cno =Number_of_arms; 
#local Cn =0; 
 #while (Cn <Cno)

  #local ScFactor=5; //lo
  #local Xrot =Cn/Cno*50/2;
  #local Yrot =Cn*360*3/5+4;   
  
  #local Xp =0;
  #local Yp =-Cn/25;
  #local Zp =0;

  // loop for the fingers of one palm leaf
  #local Cto = 30+Cn*2;// number of single leaf fingers
  #local Ct =0; 
  #while (Ct < Cto)
   #local Xrot =Xrot+1.5+Ct/Cto*1.75*(Cn*0.5+1);// this reduces leafes to stronger curves
   #local Yrot =Yrot;
   union{
     cylinder {<0,-0.05,0>,<0,1.05,0>, 0.3*(1-Ct/Cto)+0.05  scale<0.7,0.9,0.4>}
     #if ( Ct/2 = int(Ct/2) )
     object { Oleaf scale ScFactor*<sin((15+155*Ct/Cto)*pi/180), 1, sin((15+155*Ct/Cto)*pi/180)>
                    rotate  z*Ct/Cto*50 -3*(0.5-rand(Zufall3))         }
     #else
     object { Oleaf scale<-1,1,1> 
                    scale ScFactor*<sin((15+155*Ct/Cto)*pi/180), 1, sin((15+155*Ct/Cto)*pi/180)>
                    rotate z*-Ct/Cto*50 -3*(0.5-rand(Zufall3))         }
     #end
     scale 1.5*<0.75,1,1>*(1+Cn*0.015) //increases scale for last
     rotate <Xrot,Yrot,0> translate <Xp,Yp,Zp>
     }// end of union
    #local Xp =Xp+sin(Xrot*pi/180)*sin(Yrot*pi/180);
    #local Yp =Yp+cos(Xrot*pi/180)               ;
    #local Zp =Zp+sin(Xrot*pi/180)*cos(Yrot*pi/180);
  #local Ct = Ct+1; #end
 #local Cn = Cn+1; #end
scale 0.035
material{Palm_Material}
}#end // end of Palm_Head

//---------------------------------------------- 

#macro Palme(SegD, Height, Nr_of_arms)
#local SegH = 0.10;  
#local SegScale =  1+Height/10;  // scale of the segments depending from Height!
#local EndNr = int(Height/SegH); // end
#local Palm_Height = EndNr*SegH;

#local Segment = 
difference{
cone{<0,-0.05,0>,0.05,<0,SegH      ,0>,SegD }
cone{<0,2*SegH/3,0>,0.05,<0,SegH+0.001,0>,SegD }
     scale <1,1,1> rotate<0,0,0> translate<0,0,0>
     texture{pigment{color LightWood}
             normal {bumps 1.0 scale<0.005,0.2,0.005>}
             finish {ambient 0.45 diffuse 0.55 phong 0.1}}}
#local High = 0;
#local Nr = 0;     // start

union{
#while (Nr< EndNr)  
   #local ScaleY = (1-0.15*rand(Zufall1));
   #local ScaleT = (0.5+0.15*cos(pi*High/(Palm_Height)));
   object{Segment
          scale <ScaleT,ScaleY,ScaleT>*SegScale 
          rotate<20*(0.5-rand(Zufall2)),80*(0.5-rand(Zufall3)),0> 
          translate<7/EndNr*(-0.15+0.15*cos(pi*High/(1.2*Palm_Height)))
                    ,High,0>} 
 #local High= High+0.1*ScaleY*SegScale;
 #local Nr = Nr + 1;  // next Nr

 #if (Nr = EndNr)

  object{Palm_Head(Nr_of_arms) 
         scale 1+Height/7 
         translate<7/EndNr*(-0.15+0.15*cos(pi*High/(1.2*Palm_Height))) ,High,0>} 
 #end 
 
#end // --------------- end of loop 
 }// end of union
#end // of Palme macro ----------

#ifdef (palms)

object{Palme (0.20,  1.0,  14) scale <1.55,1.55,1.85> rotate<90,0,0> 
        translate<-0.47946,2.74737,0>}                               
        
object{Palme (0.20,  1.0,  14) scale <1.55,1.55,1.85> rotate<90,0,0> 
        translate<-8.65,3.5,0>}           
       
object{Palme (0.25,  2.2,  15) scale <2,2,1.25> rotate<90,0,0> 
        translate<-0.62287,-3.19225,0.71108>}                  
        
object{Palme (0.25,  2.2,  15) scale <2,2,1.25> rotate<90,15,0> 
        translate<-0.62287,-3.19225,0.71108>}                
        
object{Palme (0.25,  2.2,  15) scale <2,2,1.25> rotate<90,-11,0> 
        translate<-0.62287,-3.19225,0.735>}                
#end        