//domus_pool_2.inc - The floor

#declare fnbumps = function{pigment{granite}}                           
#declare fntile = function{x}

#declare reflection_val = 0.215;
                        
//#declare floor_reflection = 1;                        
                        
#declare floortile = object
{
 isosurface
 {
        function{fntile(x,y,z) + fnbumps(x,y,z).x * 0.25}
        max_gradient 0.719
        threshold 1
        
        contained_by
                {
                        box {-2,2}
                }                 
         rotate y*-90
 }        
 scale <0.35,0.35,0.01955>
}
     
#declare xloc = 0.79441;
#declare yfac = 1.425;

#declare xcount = 2;

#declare thefloor = object
{                      
 union
 {
                    
#while (xcount > 0)                    
 #declare ycount = 6;
 #declare yloc = -3.66119;

 #while (ycount > 0)     
             
        object
        {
         floortile
         material
         {
                texture
                {
                      T_Stone2
                      #ifdef (floor_reflection)
                      finish
                        {
                                reflection reflection_val  
                        }                      
                      #end  
                }
         }      
         translate <xloc,yloc,-1.0102>
         
        }
        #declare yloc = yloc + yfac;
        
        #declare ycount = ycount - 1;
 #end//ycount
 #declare xloc = xloc - yfac;
               
 #declare xcount = xcount - 1;
#end//xcount 
 }//union
}//object 

difference
{
 object
 {
  thefloor
 }           
 box { 
  <-1, -1, -1>, <1, 1, 1>
  material {
    texture{pigment{color rgb <0,0,0>}}
  }
  scale <0.613478, 1.620444, 0.082497>
  translate  <1.703248, -2.842385, -1.010201>
 }
}//difference 

//Far left floor to the left of steps leading into pool

#declare yloc = 4.9;
#declare ycount = 3;

#while (ycount > 0)

 #declare xloc = -4.5;
 #declare xcount = 4;
           
 #while (xcount > 0)           
 object
 {
  floortile
  material
  {
        texture
        {
                T_Stone2
                #ifdef (floor_reflection)
                      finish
                        {
                                reflection reflection_val
                        }                      
                      #end  
        }
                     
  } 
  translate <xloc,yloc,-1.010201>
 }                              
  #declare xloc = xloc - yfac;
  #declare xcount = xcount - 1;
 #end                         
 #declare yloc = yloc + yfac;
 #declare ycount = ycount - 1;
#end 
                                     
#declare xloc = xloc + yfac + 0.25;
#declare yloc = yloc - 4 * yfac;

object
 {
  floortile
  material
  {
        texture
        {
                T_Stone2
                #ifdef (floor_reflection)
                      finish
                        {
                                reflection reflection_val
                        }                      
                #end  
        }
                     
  } 
  translate <xloc,yloc,-1.010201>
 }

//Floortiles near and under the columns at pool steps                                 

#declare yloc = yloc + 2 * yfac;                       


 #declare xloc = xloc + 4 * yfac - 0.25;
 #declare xcount = 2;

 #while (xcount > 0)
 object
 {
  floortile
  material
  {
        texture
        {
                T_Stone2
                #ifdef (floor_reflection)
                      finish
                        {
                                reflection reflection_val
                        }                      
                #end  
        }
                     
  } 
  translate <xloc,yloc,-1.010201>
 }                 

 #declare xloc = xloc + yfac;
 #declare xcount = xcount - 1;
 #end                          

#declare xloc = xloc - 2 * yfac;
#declare yloc = yloc + yfac;                              

#declare xcount = 3;

#while (xcount > 0)
                                 
object
 {
  floortile
  material
  {
        texture
        {
                T_Stone2
                #ifdef (floor_reflection)
                      finish
                        {
                                reflection reflection_val
                        }                      
                #end  
        }
                     
  } 
  translate <xloc,yloc,-1.010201>
 }                            
 #declare xloc = xloc + yfac;
 #declare xcount = xcount - 1;
#end                                  
     
#declare xloc = xloc - yfac;     
#declare yloc = yloc + yfac;     

#declare xcount = 7;

#while (xcount > 0)
     
object
 {
  floortile
  material
  {
        texture
        {
                T_Stone2
                #ifdef (floor_reflection)
                      finish
                        {
                                reflection reflection_val
                        }                      
                #end  
        }
                     
  } 
  translate <xloc,yloc,-1.010201>
 }                            
 #declare xloc = xloc - yfac;
 #declare xcount = xcount - 1;            
#end 