// Razor wire generator v1.0
// by mutewitness 07/10/1999 - please distribute or modify freely as long as 
// you send me the changes you made ;)
// Triangles are not smooth, i am not good with computing normals however it
// makes the razor wire look more "artifical" or "hard"
// email: mutewitness@mpinet.net

// Input variables...
// num_segments = number of loops you want
// divisions    = triangle resolution per loop 
// inner_radius = inner radius of the wire
// outer_radius = outer radius of the wire
// barb_size    = size of the barbs
// barb_freq    = number of barbs per loop

#macro razor_wire(num_segments, divisions, inner_radius, outer_radius, barb_size, barb_freq)
#local sine_count = 0.0;   
//#local divisions = 64;
//#local num_segments = 2;
//#local inner_radius = 0.9;
//#local outer_radius = 1.0;
#local sine_adder = ((2*pi)/divisions);
#local temp_z = 0;
#local temp_nz = 1/divisions;
#local temp_nnz = (1/divisions)*2;
#local temp_pz = -(1/divisions);
#local z_adder = 1/divisions;
#local main_count = 0;
#local poly_count = 0;
mesh {
  #while (temp_z < num_segments)
    #local inner_temp_x = sin(sine_count)*inner_radius;
    #local inner_temp_y = cos(sine_count)*inner_radius;
    #local inner_temp_nx = sin(sine_count+((2*pi)/divisions))*inner_radius;
    #local inner_temp_ny = cos(sine_count+((2*pi)/divisions))*inner_radius;

    #local outer_temp_x = sin(sine_count)*outer_radius;
    #local outer_temp_y = cos(sine_count)*outer_radius;
    #local outer_temp_nx = sin(sine_count+((2*pi)/divisions))*outer_radius;
    #local outer_temp_ny = cos(sine_count+((2*pi)/divisions))*outer_radius;

    triangle {
      <inner_temp_x, inner_temp_y, temp_z>
      <outer_temp_x, outer_temp_y, temp_z>
      <outer_temp_nx, outer_temp_ny, temp_nz>
    }
    triangle {
      <outer_temp_nx, outer_temp_ny, temp_nz> 
      <inner_temp_nx, inner_temp_ny, temp_nz>
      <inner_temp_x, inner_temp_y, temp_z>
    } 

    #if (mod(main_count, divisions/barb_freq) = 0)
      // outer barb
      #local barb_temp_x = sin(sine_count)*(outer_radius+barb_size);
      #local barb_temp_y = cos(sine_count)*(outer_radius+barb_size);
      #local barb_temp_nx = sin(sine_count+((2*pi)/divisions))*(outer_radius+barb_size);
      #local barb_temp_ny = cos(sine_count+((2*pi)/divisions))*(outer_radius+barb_size);
      #local barb_temp_nnx = sin(sine_count+((2*pi)/divisions)*2)*(outer_radius+barb_size);
      #local barb_temp_nny = cos(sine_count+((2*pi)/divisions)*2)*(outer_radius+barb_size);
      #local barb_temp_px = sin(sine_count-((2*pi)/divisions))*(outer_radius+barb_size);
      #local barb_temp_py = cos(sine_count-((2*pi)/divisions))*(outer_radius+barb_size);
      triangle {
        <outer_temp_x, outer_temp_y, temp_z> 
        <barb_temp_x, barb_temp_y, temp_z>
        <barb_temp_px, barb_temp_py, temp_pz>
      }     
      triangle {
        <outer_temp_x, outer_temp_y, temp_z> 
        <barb_temp_x, barb_temp_y, temp_z>
        <barb_temp_nx, barb_temp_ny, temp_nz>
      }     
      triangle {
        <barb_temp_nx, barb_temp_ny, temp_nz>
        <outer_temp_nx, outer_temp_ny, temp_nz> 
        <outer_temp_x, outer_temp_y, temp_z> 
      }     
      triangle {
        <outer_temp_nx, outer_temp_ny, temp_nz> 
        <barb_temp_nx, barb_temp_ny, temp_nz>
        <barb_temp_nnx, barb_temp_nny, temp_nnz>
      }     

      // inner barb
      #local barb_temp_x = sin(sine_count)*(inner_radius-barb_size);
      #local barb_temp_y = cos(sine_count)*(inner_radius-barb_size);
      #local barb_temp_nx = sin(sine_count+((2*pi)/divisions))*(inner_radius-barb_size);
      #local barb_temp_ny = cos(sine_count+((2*pi)/divisions))*(inner_radius-barb_size);
      #local barb_temp_nnx = sin(sine_count+((2*pi)/divisions)*2)*(inner_radius-barb_size);
      #local barb_temp_nny = cos(sine_count+((2*pi)/divisions)*2)*(inner_radius-barb_size);
      #local barb_temp_px = sin(sine_count-((2*pi)/divisions))*(inner_radius-barb_size);
      #local barb_temp_py = cos(sine_count-((2*pi)/divisions))*(inner_radius-barb_size);
      triangle {
        <inner_temp_x, inner_temp_y, temp_z> 
        <barb_temp_x, barb_temp_y, temp_z>
        <barb_temp_px, barb_temp_py, temp_pz>
      }     
      triangle {
        <inner_temp_x, inner_temp_y, temp_z> 
        <barb_temp_x, barb_temp_y, temp_z>
        <barb_temp_nx, barb_temp_ny, temp_nz>
      }     
      triangle {
        <barb_temp_nx, barb_temp_ny, temp_nz>
        <inner_temp_nx, inner_temp_ny, temp_nz> 
        <inner_temp_x, inner_temp_y, temp_z> 
      }     
      triangle {
        <inner_temp_nx, inner_temp_ny, temp_nz> 
        <barb_temp_nx, barb_temp_ny, temp_nz>
        <barb_temp_nnx, barb_temp_nny, temp_nnz>
      }     
    #end
    
    #local sine_count = sine_count + ((2*pi)/divisions);
    #local temp_z = temp_z + z_adder;
    #local temp_nz = temp_nz + z_adder;
    #local temp_nnz = temp_nnz + z_adder;
    #local temp_pz = temp_pz + z_adder;
    #local poly_count = poly_count + 10;
    #if (mod(main_count, divisions) = 0)
      #debug concat("Assembling razor wire segment ",str(main_count/divisions,0,0)," of ",str(num_segments-1,0,0),"\n")
    #end  
    #local main_count = main_count + 1;
  #end
  #debug concat("Total polygons in razor wire = ",str(poly_count,0,0),"\n")
}
#end