#include "colors.inc"

#default
{ finish
  { ambient 0.15
    diffuse 1
    brilliance 3
    specular 0.25
    roughness 0.005
  }
}

#declare T=0

#declare R1 = seed(int(12345678*clock))

#declare N1 = 2*(rand(R1)-0.5) //
#declare N2 = 2*(rand(R1)-0.5) // the vector
#declare N3 = 2*(rand(R1)-0.5) //
#declare N4 = 2*(rand(R1)-0.5) //
#declare N5 = 5+int(8*(rand(R1)-0.5)) // max_iter
#declare N6 = 30+50*(rand(R1)-0.5) // precision
#declare N7 = 360*(rand(R1)-0.5) // rotation
#declare N8 = 2*(rand(R1)-0.5) //
#declare N9 = 2*(rand(R1)-0.5) // the slice
#declare N10 = 2*(rand(R1)-0.5) //
#declare N11 = 2*(rand(R1)-0.5) //
#declare N12 = 2*(rand(R1)-0.5) // distance

#declare String1 = concat ( "<",str(N1,-3,6),", ",str(N2,-3,6),", ",str(N3,-3,6),", ",str(N4,-3,6),">")
#declare String2 = concat ( "max_iteration ", str(N5,1,0))
#declare String3 = concat ( "precision ", str(N6,1,0))
#declare String4 = concat ( "y axis rotation ", str (N7,1,2))
#declare String5 = concat ( "<",str(N8,-3,6),", ",str(N9,-3,6),", ",str(N10,-3,6),", ",str(N11,-3,6),">")
#declare String6 = concat ( "Distance ", str (N12,-3,6))

union
{
text
{ ttf "cyrvetic.ttf",
  String1,
  0.1,0
  pigment { Green }
  scale 0.3
  translate <-3.5,-3,0>
}
text
{ ttf "cyrvetic.ttf",
  String2,
  0.1,0
  pigment { Green }
  scale 0.3
  translate <-3.5,-3.3,0>
}
text
{ ttf "cyrvetic.ttf",
  String3,
  0.1,0
  pigment { Green }
  scale 0.3
  translate <-3.5,-3.6,0>
}
text
{ ttf "cyrvetic.ttf",
  String4,
  0.1,0
  pigment { Green }
  scale 0.3
  translate <-3.5,-3.9,0>
}
text
{ ttf "cyrvetic.ttf",
  String5,
  0.1,0
  pigment { Green }
  scale 0.3
  translate <-3.5,-4.2,0>
}
text
{ ttf "cyrvetic.ttf",
  String6,
  0.1,0
  pigment { Green }
  scale 0.3
  translate <-3.5,-4.5,0>
}

translate T

}

camera
{
  location  <0.0 , -1 ,-5.0>
  up <0,1.5,0>
  right <1.5,0,0>
  look_at   <0.0 , -1 , 0.0>
  translate T
}


//light_source { <100,0,-100> color Red rotate z*360*clock }
//light_source { <100,0,-100> color Green rotate z*(120 + 360*clock) }
//light_source { <100,0,-100> color Blue rotate z*(-120 + 360*clock) }
light_source { <0,0,-100> color White } //rotate (-120*z + 360*clock) }
