/* foreach.inc
 *
 * iterate over an array, call the given macro for every primary element,
 * ie 'A[n]', with options for additional dimension(s) and early termination.
 *
 * see documentation and examples in 'forach.html'.
 *
 *
 *     macro Foreach(array, macro, flags, optional dim)
 *
 * arguments:
 *    array  - name of array.  either "old" style declared, ie sized,
 *             or the new since version 3.8 auto-sizing type.
 *
 *    macro  - name (string) of "payload" macro, called with two arguments
 *             (primary index and current array element).
 *             either no return ("void" type), or bool return.
 *
 *    flags  - sum of:
 *             1 - primary and n'th dim.
 *             2 - primary to n'th dim.
 *             4 - bool payload.
 *             8 - break on false when bool.
 *            16 - extra (secondary dim) argument when walk.
 *
 *    dim    - index of n'th (rightmost) dimension to "walk", optional.
 *             default '1'.
 *
 *
 * version: 202103.1
 *
 */

#ifndef (fore_include_temp)

#declare fore_include_temp = version;
#version 3.8;

#ifdef (View_POV_Include_Stack)
#debug "including 'foreach.inc'\n"
#end

/* default is suppress extra info */
#ifndef (global.fore_debug)
#declare fore_debug = off;
#end
#ifndef (global.fore_verbose)
#declare fore_verbose = off;
#end

/* pretty printing */
#macro fore_hyphens(n_)
  #local s_ = "";
  #for (i_,1,n_)
    #local s_ = concat(s_,"-");
  #end
  s_
#end
#macro fore_boolFmt(f_)
  #if (f_)
    #local s_ = "yes";
  #else
    #local s_ = "no";
  #end
  s_
#end
#macro fore_strFmt(s_)
  #local w_ = 20;
  #local n_ = strlen(s_);
  #if (w_ > n_)
    #local s_ = concat(substr("                    ",1,(w_-n_)),s_);
  #end
  s_
#end
#macro fore_emitBool(s_,v_)
  #debug concat(fore_strFmt(s_),": ",fore_boolFmt(v_),"\n")
#end
#macro fore_emitStr(s_,v_)
  #debug concat(fore_strFmt(s_),": ",v_,"\n")
#end
#macro fore_emitVal(s_,v_,p_)
  #debug concat(fore_strFmt(s_),": ",str(v_,0,p_),"\n")
#end

/* flags */
#macro fore_flagWalk1(f_)   (bitwise_and(f_, 1) ? 1 : 0) #end
#macro fore_flagWalk2(f_)   (bitwise_and(f_, 2) ? 1 : 0) #end
#macro fore_flagBoolean(f_) (bitwise_and(f_, 4) ? 1 : 0) #end
#macro fore_flagStrict(f_)  (bitwise_and(f_, 8) ? 1 : 0) #end
#macro fore_flagExtra(f_)   (bitwise_and(f_,16) ? 1 : 0) #end

/* call handling.
 * 'exec' is local copy of 'strings.inc:Parse_String'.
 */
#macro fore_exec(s_)
  #local fn_ = "/tmp/parse_fore.tmp";
  #fopen fp_ fn_ write
  #write (fp_, s_)
  #fclose fp_
  #include fn_
#end

#macro fore_call(a_,s_,f_)
  #if (f_)
    #local rtn_ = fore_exec(s_);
  #else
    fore_exec(s_)
    #local rtn_ = 1;
  #end
  #if (fore_debug)
    #debug concat("call '",s_,"' returned '",str(rtn_,0,0),"'.\n")
  #end
  rtn_
#end

#macro fore_mkCmd(m_,sf_,st_,i_,j_,f_)
  #local s_ = concat(m_,"(",str(i_,0,0),",");
  #if (f_)
    #local s_ = concat(s_,str(j_,0,0),",a_",sf_,st_,")");
  #else
    #local s_ = concat(s_,"a_",sf_,st_,")");
  #end
  s_
#end

/* make array access strings, eg "[3][3][1][0]" */
#macro fore_mkaaStr(d1_,optional d2_,optional d3_,optional d4_,optional d5_)
  #local s_ = "";
  #ifdef (local.d5_) #local s_ = concat("[",str(d5_,0,0),"]",s_); #end
  #ifdef (local.d4_) #local s_ = concat("[",str(d4_,0,0),"]",s_); #end
  #ifdef (local.d3_) #local s_ = concat("[",str(d3_,0,0),"]",s_); #end
  #ifdef (local.d2_) #local s_ = concat("[",str(d2_,0,0),"]",s_); #end
  concat("[",str(d1_,0,0),"]",s_)
#end

#macro fore_mkaaTail(n_,d_)
  #local s_ = "";
  #for (i_, 0, (n_-d_)-1)
    #local s_ = concat(s_,"[0]");
  #end
  s_
#end

/* process "old-style" arrays; 1D used for both new and old style.
 * array a_, macro m_, flags f_, dim d_, ndims n_, tail t_.
 */
#macro fore_walker5D(a_,m_,f_,d_,n_)
  #local lim5_ = dimension_size(a_,5) - 1;
  #local cont_ = 1;
  #if (fore_flagWalk2(f_))
    #local lim4_ = dimension_size(a_,4) - 1;
    #local lim3_ = dimension_size(a_,3) - 1;
    #local lim2_ = dimension_size(a_,2) - 1;
    #for (i1_, 0, dimension_size(a_,1)-1)
      #for (i2_, 0, lim2_)
        #for (i3_, 0, lim3_)
          #for (i4_, 0, lim4_)
            #for (i5_, 0, lim5_)
              #if (cont_)
                #local fmt_ = fore_mkaaStr(i1_,i2_,i3_,i4_,i5_);
                #local cmd_ =
                    fore_mkCmd(m_,fmt_,"",i1_,i5_,fore_flagExtra(f_));
                #if (!fore_call(a_,cmd_,fore_flagBoolean(f_)))
                  #if (fore_flagStrict(f_))
                    #debug concat("break after element '",fmt_,"'.\n")
                    #local cont_ = 0;
                  #end
                  #if (fore_verbose)
                    #debug concat("0/false return from element '",fmt_,"'.\n")
                  #end
                #end
              #end
            #end
          #end
        #end
      #end
    #end
  #else
    #for (i1_, 0, dimension_size(a_,1)-1)
      #for (i5_, 0, lim5_)
        #if (cont_)
          #local fmt_ = fore_mkaaStr(i1_,0,0,0,i5_);
          #local cmd_ = fore_mkCmd(m_,fmt_,"",i1_,i5_,fore_flagExtra(f_));
          #if (!fore_call(a_,cmd_,fore_flagBoolean(f_)))
            #if (fore_flagStrict(f_))
              #debug concat("break after element '",fmt_,"'.\n")
              #local cont_ = 0;
            #end
            #if (fore_verbose)
              #debug concat("0/false return from element '",fmt_,"'.\n")
            #end
          #end
        #end
      #end
    #end
  #end
#end

#macro fore_walker4D(a_,m_,f_,d_,n_,t_)
  #local lim4_ = dimension_size(a_,4) - 1;
  #local cont_ = 1;
  #if (fore_flagWalk2(f_))
    #local lim3_ = dimension_size(a_,3) - 1;
    #local lim2_ = dimension_size(a_,2) - 1;
    #for (i1_, 0, dimension_size(a_,1)-1)
      #for (i2_, 0, lim2_)
        #for (i3_, 0, lim3_)
          #for (i4_, 0, lim4_)
            #if (cont_)
              #local fmt_ = fore_mkaaStr(i1_,i2_,i3_,i4_,);
              #local cmd_ = fore_mkCmd(m_,fmt_,t_,i1_,i4_,fore_flagExtra(f_));
              #if (!fore_call(a_,cmd_,fore_flagBoolean(f_)))
                #if (fore_flagStrict(f_))
                  #debug concat("break after element '",fmt_,t_,"'.\n")
                  #local cont_ = 0;
                #end
                #if (fore_verbose)
                  #debug concat("0/false return from element '",fmt_,t_,"'.\n")
                #end
              #end
            #end
          #end
        #end
      #end
    #end
  #else
    #for (i1_, 0, dimension_size(a_,1)-1)
      #for (i4_, 0, lim4_)
        #if (cont_)
          #local fmt_ = fore_mkaaStr(i1_,0,0,i4_,);
          #local cmd_ = fore_mkCmd(m_,fmt_,t_,i1_,i4_,fore_flagExtra(f_));
          #if (!fore_call(a_,cmd_,fore_flagBoolean(f_)))
            #if (fore_flagStrict(f_))
              #debug concat("break after element '",fmt_,t_,"'.\n")
              #local cont_ = 0;
            #end
            #if (fore_verbose)
              #debug concat("0/false return from element '",fmt_,t_,"'.\n")
            #end
          #end
        #end
      #end
    #end
  #end
#end

#macro fore_walker3D(a_,m_,f_,d_,n_,t_)
  #local lim3_ = dimension_size(a_,3) - 1;
  #local cont_ = 1;
  #if (fore_flagWalk2(f_))
    #local lim2_ = dimension_size(a_,2) - 1;
    #for (i1_, 0, dimension_size(a_,1)-1)
      #for (i2_, 0, lim2_)
        #for (i3_, 0, lim3_)
          #if (cont_)
            #local fmt_ = fore_mkaaStr(i1_,i2_,i3_,,);
            #local cmd_ = fore_mkCmd(m_,fmt_,t_,i1_,i3_,fore_flagExtra(f_));
            #if (!fore_call(a_,cmd_,fore_flagBoolean(f_)))
              #if (fore_flagStrict(f_))
                #debug concat("break after element '",fmt_,t_,"'.\n")
                #local cont_ = 0;
              #end
              #if (fore_verbose)
                #debug concat("0/false return from element '",fmt_,t_,"'.\n")
              #end
            #end
          #end
        #end
      #end
    #end
  #else
    #for (i1_, 0, dimension_size(a_,1)-1)
      #for (i3_, 0, lim3_)
        #if (cont_)
          #local fmt_ = fore_mkaaStr(i1_,0,i3_,,);
          #local cmd_ = fore_mkCmd(m_,fmt_,t_,i1_,i3_,fore_flagExtra(f_));
          #if (!fore_call(a_,cmd_,fore_flagBoolean(f_)))
            #if (fore_flagStrict(f_))
              #debug concat("break after element '",fmt_,t_,"'.\n")
              #local cont_ = 0;
            #end
            #if (fore_verbose)
              #debug concat("0/false return from element '",fmt_,t_,"'.\n")
            #end
          #end
        #end
      #end
    #end
  #end
#end

#macro fore_walker2D(a_,m_,f_,d_,n_,t_)
  #local lim2_ = dimension_size(a_,2) - 1;
  #local cont_ = 1;
  #if (fore_flagWalk2(f_))
    #for (i1_, 0, dimension_size(a_,1)-1)
      #for (i2_, 0, lim2_)
        #if (cont_)
          #local fmt_ = fore_mkaaStr(i1_,i2_,,,);
          #local cmd_ = fore_mkCmd(m_,fmt_,t_,i1_,i2_,fore_flagExtra(f_));
          #if (!fore_call(a_,cmd_,fore_flagBoolean(f_)))
            #if (fore_flagStrict(f_))
              #debug concat("break after element '",fmt_,t_,"'.\n")
              #local cont_ = 0;
            #end
            #if (fore_verbose)
              #debug concat("0/false return from element '",fmt_,t_,"'.\n")
            #end
          #end
        #end
      #end
    #end
  #else
    #for (i1_, 0, dimension_size(a_,1)-1)
      #for (i2_, 0, lim2_)
        #if (cont_)
          #local fmt_ = fore_mkaaStr(i1_,i2_,,,);
          #local cmd_ = fore_mkCmd(m_,fmt_,t_,i1_,i2_,fore_flagExtra(f_));
          #if (!fore_call(a_,cmd_,fore_flagBoolean(f_)))
            #if (fore_flagStrict(f_))
              #debug concat("break after element '",fmt_,t_,"'.\n")
              #local cont_ = 0;
            #end
            #if (fore_verbose)
              #debug concat("0/false return from element '",fmt_,t_,"'.\n")
            #end
          #end
        #end
      #end
    #end
  #end
#end

#macro fore_walker1D(a_,m_,f_,d_,n_,t_)
  #local cont_ = 1;
  #for (i_, 0, dimension_size(a_,1)-1)
    #if (cont_)
      #local fmt_ = fore_mkaaStr(i_,,,,);
      #local cmd_ = fore_mkCmd(m_,fmt_,t_,i_,0,0);
      #if (!fore_call(a_,cmd_,fore_flagBoolean(f_)))
        #if (fore_flagStrict(f_))
          #debug concat("break after element '",fmt_,t_,"'.\n")
          #local cont_ = 0;
        #end
        #if (fore_verbose)
          #debug concat("0/false return from element '",fmt_,t_,"'.\n")
        #end
      #end
    #end
  #end
#end

/* -------------------------------------------------------------------------- *
 * "the public interface" macro.  returns nothing.
 */

#macro Foreach(arr_,mac_,flg_,optional dim_)
  #ifdef (fore_running_)
    #error "oops, cannot nest 'Foreach()' calls."
  #end
  #local fore_running_ = 1;

  #ifndef(mac_)
    #error concat("oops, macro '",mac_,"' not found.")
  #end

  /* error if array is not, always '1' when new-style */
  #local ndims_ = dimensions(arr_);

  /* set dim when not "walking" */
  #ifndef (local.dim_)
    #local dim_ = 1;
  #elseif (1 > dim_ | 5 < dim_ | dim_ != int(dim_))
    #error "oops, bad 'dim' argument."
  #elseif (!(fore_flagWalk1(flg_) | fore_flagWalk2(flg_)))
    #local dim_ = 1;
  #end

  #if (fore_flagExtra(flg_) & !(fore_flagWalk1(flg_) | fore_flagWalk2(flg_)))
    #error "oops, bad 'flags' argument."
  #end

  #if (fore_verbose | fore_debug)
    #debug concat(fore_hyphens(5),"[Foreach()]",fore_hyphens(56),"\n")
    fore_emitBool("walk n'th dim",fore_flagWalk1(flg_))
    fore_emitBool("walk thru to n'th",fore_flagWalk2(flg_))
    fore_emitVal("dimension n",dim_,0)
    fore_emitStr("payload macro",mac_)
    fore_emitBool("extra arg",fore_flagExtra(flg_))
    fore_emitBool("returns bool",fore_flagBoolean(flg_))
    fore_emitBool("break on 'false'",fore_flagStrict(flg_))
  #end

  #if (1 = ndims_)
    #if (1 = dim_)
      fore_walker1D(arr_,mac_,flg_,dim_,ndims_,"")
    #else
      // TODO fore_walkerXD()?
      #error "oops, multi-dim new-style array access not yet implemented"
    #end
  #elseif (ndims_ < dim_)
    #error "oops, bad 'dim' argument."
  #else
    #local tail_ = fore_mkaaTail(ndims_,dim_);
    #switch (dim_)
      #case (5)  /* no tail */
        fore_walker5D(arr_,mac_,flg_,dim_,ndims_)
        #break
      #case (4)
        fore_walker4D(arr_,mac_,flg_,dim_,ndims_,tail_)
        #break
      #case (3)
        fore_walker3D(arr_,mac_,flg_,dim_,ndims_,tail_)
        #break
      #case (2)
        fore_walker2D(arr_,mac_,flg_,dim_,ndims_,tail_)
        #break
      #case (1)
        fore_walker1D(arr_,mac_,flg_,dim_,ndims_,tail_)
        #break
      #else
        #error "oops, \"cannot happen\" error."
    #end
  #end
#end

#version fore_include_temp;

#end

