/* fore_demo.pov
 * the code is organised in blocks, each of which can be enabled/disabled
 * separately.  each block demonstrates some aspects/features of 'Forach()'
 * and has comments - in lieu of the "man page", which isn't ready yet.
 * enable one at a time.
 */

#version 3.8;

global_settings {assumed_gamma 1}


#include "foreach.inc"

/* -------------------------------------------------------------------------- *
 * 'bool' + 'strict'.
 * by default 'Foreach()' expects your macro to return nothing ('void').
 * the 'bool' flag (value '4') indicates that the macro does return a 
 * true/false (ie non-zero/zero) status value.  unless the 'strict' flag
 * (value '8') is given, a false return is simply reported[*] and
 * execution continues, with 'strict' the 'Foreach()' macro terminates.
 * [*] requires 'fore_verbose' on.
 */
#if (0)
/* avoid 'no objects in scene' warning */
box {0,1}

#declare A = array [2][2][3] {
  {{1, 2, 3}, {4, 5, 6}}, {{7, 8, 9}, {10, 11, 12}}
};

#macro m_void(i_, elem_)
  #local n_ = elem_ * elem_;
  #debug concat("m_void i = ",str(i_,0,0),", elem = ",str(elem_,0,0),
          "  sqr = ",str(n_,0,0),".\n")
#end

#macro m_bool(i_, elem_)
  #local n_ = elem_ * elem_;
  #debug concat("m_bool i = ",str(i_,0,0),", elem = ",str(elem_,0,0),
          "  sqr = ",str(n_,0,0),".\n")
  #if (n_ < 30)
    #local r_ = 0;
  #else
    #local r_ = 1;
  #end
  r_
#end

#declare fore_verbose = on;

/* flags are added together */
Foreach(A, "m_void", 0,)

Foreach(A, "m_bool", 4,)

Foreach(A, "m_bool", 12,)

#debug concat("\n")

#declare fore_verbose = off;

Foreach(A, "m_bool", 12,)

/* calling a void-type macro with 'bool' flag, or bool-type and no flag,
 * results, predictably, in error(s).  ;-)
 */
//Foreach(A, "m_void", 4,)
//Foreach(A, "m_bool", 0,)

#end


/* -------------------------------------------------------------------------- *
 * 'walk1' + 'walk2'.
 * the primary/first dimension of any given array is always "walked" for each
 * element.  with the 'walk?' flags one can access additional elements.
 * the 'walk1' flag (value '1') says to walk the Nth dimension too, while the
 * 'walk2' flag (value '2') says to walk through all dims, up to and including
 * the Nth.  eg for array 'X[2][2][2][2]', third dim:
 *
 *   no flags       walk 1         walk 2
 *  ------------   ------------   ------------
 *  [0][0][0][0]   [0][0][0][0]   [0][0][0][0]
 *  [1][0][0][0]   [0][0][1][0]   [0][0][1][0]
 *                 [1][0][0][0]   [0][1][0][0]
 *                 [1][0][1][0]   [0][1][1][0]
 *                                [1][0][0][0]
 *                                [1][0][1][0]
 *                                [1][1][0][0]
 *                                [1][1][1][0]
 *
 * if both 'walk?' flags given uses 'walk2'.
 * when walking, the dimension is given as the last 'Foreach()' argument.
 */
#if (0)
box {0,1}

#declare A = array [2][2][3] {
  {{1, 2, 3}, {4, 5, 6}}, {{7, 8, 9}, {10, 11, 12}}
};

#macro m_walk(i_, elem_)
  #local n_ = elem_ * elem_;
  #debug concat("m_walk i = ",str(i_,0,0),", elem = ",str(elem_,0,0),
          "  sqr = ",str(n_,0,0),".\n")
#end

#declare fore_verbose = on;

Foreach(A, "m_walk", 1, 3)
//Foreach(A, "m_walk", 1, 2)

Foreach(A, "m_walk", 2, 3)
//Foreach(A, "m_walk", 2, 2)

/* no 'walk?' flag means dimension is forced to '1' */
//Foreach(A, "m_walk", 0, 3)

#end


/* -------------------------------------------------------------------------- *
 * 'extra'.
 * this flag (value '16') is only permitted when either of the 'walk?' flags
 * is given.  it changes the payload macro's interface from two to three
 * arguments.  the added argument provides the current index of the given
 * Nth dimension.
 *
 *  without 'extra':  foo(i, elem)
 *     with 'extra':  foo(i, j, elem)
 */
#if (0)
box {0,1}

#declare A = array [2][2][3] {
  {{1, 2, 3}, {4, 5, 6}}, {{7, 8, 9}, {10, 11, 12}}
};

#macro m_3arg(i_, j_, elem_)
  #local n_ = elem_ * elem_;
  #debug concat("m_3arg i = ",str(i_,0,0),", j = ",str(j_,0,0),
          ", elem = ",str(elem_,0,0),"  sqr = ",str(n_,0,0),".\n")
#end

#declare fore_verbose = on;

Foreach(A, "m_3arg", 17, 3)

Foreach(A, "m_3arg", 18, 3)

/* error if no 'walk?' */
//Foreach(A, "m_3arg", 16, 3)

#end


/* -------------------------------------------------------------------------- *
 *
 */
#if (1)

camera {
  location <0,0,-10>
  direction z
  right x * (4/3)
  up y
  look_at <0,0,0>
}

background {color rgb .85}

#declare fin_ = finish {ambient 0 emission 1};

#declare colours_ = array [8] {
  color rgb <0, 0, 0>, color rgb <1, 0, 0>,
  color rgb <0, 1, 0>, color rgb <0, 0, 1>,
  color rgb <1, 1, 0>, color rgb <0, 1, 1>,
  color rgb <1, 0, 1>, color rgb <1, 1, 1>
};

#declare positions_ = array [8] {
  <0, 0, 0>, <1, 0, 0>, <0, 1, 0>, <1, 1, 0>,
  <0, 0, 1>, <1, 0, 1>, <0, 1, 1>, <1, 1, 1>
};

#declare stuff_ = array {
  array mixed {0, 0, "one",   7},
  array mixed {2, 1, "two",   6},
  array mixed {4, 2, "three", 5},
  array mixed {6, 3, "four",  3},
  array mixed {1, 4, "five",  2},
  array mixed {3, 5, "six",   4},
  array mixed {5, 6, "seven", 1},
  array mixed {7, 7, "eight", 0}
};

#macro mkSphere(p_,d_,c_)
  sphere {
    p_, d_
    pigment {colours_[c_]}
  }
#end

#macro bigSphere(i_, elem_)
  #debug concat("e[0] = ",str(elem_[0],0,0),"  e[1] = ",str(elem_[1],0,0),
          "  e[2] = '",elem_[2],"'  e[3] = ",str(elem_[3],0,0),".\n")
//mkSphere(positions_[elem_[1]], .25, elem_[3])
#end

//#declare fore_debug = on;

Foreach(stuff_, "bigSphere", 0,)


#end

