// Generated By: LDView 4.2.0.1 (C) Travis Cobbs and Peter Bartfai, 2012
// See: http://ldview.sourceforge.net/
// Date: Tue Jan  7 21:36:26 2014
// Input LDraw File: datsville.ldr
// LDraw File Author: Various
//
// This file was automatically generated from an LDraw file by the program
// LDView.  See comments above for further details.

//#version 3.6;

#version 3.7;

#include "ldv_wrapper_townview.inc"

#declare LDXQual = 2;	// Quality (0 = Bounding Box; 1 = No Refraction; 2 = Normal; 3 = Stud Logos)
#declare LDXSW = 0;	// Seam Width (0 for no seams)
#declare LDXStuds = 1;	// Show studs? (1 = YES; 0 = NO)
#declare LDXRefls = 1;	// Reflections? (1 = YES; 0 = NO)
#declare LDXShads = 1;	// Shadows? (1 = YES; 0 = NO)
#declare LDXFloor = 0;	// Include Floor? (1 = YES; 0 = NO)

// Model bounds information
#declare LDXMinX = -7050;
#declare LDXMinY = -2652;
#declare LDXMinZ = -10240;
#declare LDXMaxX = 7680;
#declare LDXMaxY = 96;
#declare LDXMaxZ = 10252.371094;
#declare LDXCenterX = 315;
#declare LDXCenterY = -1278;
#declare LDXCenterZ = 6.185547;
#declare LDXCenter = <LDXCenterX,LDXCenterY,LDXCenterZ>;
#declare LDXRadius = 12317.013672;

// Camera settings
#declare LDXCameraLoc = < 5835708.5,-4764960,-5836669.5 >;	// Camera Location vector
#declare LDXCameraLookAt = < -398.79438558313995599747,201.58261994551867246628,-563.34171733539551496506 >;	// Camera look-at point vector
#declare LDXCameraSky = < -0.35355329881115843405,-0.86602543005723520153,0.35355341802042911103 >;	// Camera sky vector (<0,-1,0> will usually work for standard "up")

#declare LDXFloorLoc = LDXMaxY;	// Floor location. (Dependent on floor axis; MAX_Y is bottom of model)
#declare LDXFloorAxis = y;	// Floor axis (x, y, or z)
#declare LDXFloorR = 0.8;	// Floor Red
#declare LDXFloorG = 0.8;	// Floor Green
#declare LDXFloorB = 0.8;	// Floor Blue
#declare LDXFloorAmb = 0.4;	// Floor Ambient
#declare LDXFloorDif = 0.4;	// Floor Diffuse
#declare LDXAmb = 0.4;
#declare LDXDif = 0.4;
#declare LDXRefl = 0.08;
#declare LDXPhong = 0.5;
#declare LDXPhongS = 40;
#declare LDXTRefl = 0.2;
#declare LDXTFilt = 0.85;
#declare LDXIoR = 1.25;
#declare LDXRubberRefl = 0;
#declare LDXRubberPhong = 0.1;
#declare LDXRubberPhongS = 10;
#declare LDXChromeRefl = 0.85;
#declare LDXChromeBril = 5;
#declare LDXChromeSpec = 0.8;
#declare LDXChromeRough = 0.01;
#declare LDXIPov = 1;	// Use inline POV code from LDraw file? (1 = YES; 0 = NO)
#declare LDXBgR = 0;	// Background Red
#declare LDXBgG = 0;	// Background Green
#declare LDXBgB = 0;	// Background Blue
#declare LDXOrigVer = version;	// DO NOT MODIFY

// Camera
#ifndef (LDXSkipCamera)
camera {
	#declare LDXCamAspect = image_width/image_height;
	location LDXCameraLoc
	sky LDXCameraSky
	right LDXCamAspect * < -1,0,0 >
	look_at LDXCameraLookAt
	angle 0.133333
}
#end

// Lights
#ifndef (LDXSkipLight1)
light_source {	// Latitude,Longitude: 45,0,LDXRadius*2
	<0*LDXRadius,-1.414214*LDXRadius,-1.414214*LDXRadius> + LDXCenter
	color rgb <1,1,1>
}
#end
#ifndef (LDXSkipLight2)
light_source {	// Latitude,Longitude: 30,120,LDXRadius*2
	<1.5*LDXRadius,-1*LDXRadius,0.866026*LDXRadius> + LDXCenter
	color rgb <1,1,1>
}
#end
#ifndef (LDXSkipLight3)
light_source {	// Latitude,Longitude: 60,-120,LDXRadius*2
	<-0.866025*LDXRadius,-1.732051*LDXRadius,0.5*LDXRadius> + LDXCenter
	color rgb <1,1,1>
}
#end

#macro LDXSeamMatrix(Width, Height, Depth, CenterX, CenterY, CenterZ)
#local aw = 0;
#local ah = 0;
#local ad = 0;
#local ax = 0;
#local ay = 0;
#local az = 0;
#if (Width != 0)
#local aw = 1-LDXSW/Width;
#end
#if (Height != 0)
#local ah = 1-LDXSW/Height;
#end
#if (Depth != 0)
#local ad = 1-LDXSW/Depth;
#end
#if (Width != 0 & CenterX != 0)
#local ax = LDXSW/(Width / CenterX);
#end
#if (Height != 0 & CenterY != 0)
#local ay = LDXSW/(Height / CenterY);
#end
#if (Depth != 0 & CenterZ != 0)
#local az = LDXSW/(Depth / CenterZ);
#end
#if (aw <= 0)
#local aw = 1;
#local ax = 0;
#end
#if (ah <= 0)
#local ah = 1;
#local ay = 0;
#end
#if (ad <= 0)
#local ad = 1;
#local az = 0;
#end
matrix <aw,0,0,0,ah,0,0,0,ad,ax,ay,az>
#end


background { color rgb <LDXBgR,LDXBgG,LDXBgB> }

#declare lg_quality = LDXQual;
#if (lg_quality = 3)
#declare lg_quality = 4;
#end

#declare lg_studs = LDXStuds;


#include "lg_defs.inc"

#include "lg_color.inc"

#ifndef (LDXColor0) // Black
#declare LDXColor0 = #if (version >= 3.1) material { #end
	texture {
		lg_black
	}
#if (version >= 3.1) } #end
#declare LDXColor0_slope = #if (version >= 3.1) material { #end
	texture {
		lg_black
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor1) // Blue
#declare LDXColor1 = #if (version >= 3.1) material { #end
	texture {
		lg_blue
	}
#if (version >= 3.1) } #end
#declare LDXColor1_slope = #if (version >= 3.1) material { #end
	texture {
		lg_blue
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor2) // Green
#declare LDXColor2 = #if (version >= 3.1) material { #end
	texture {
		lg_green
	}
#if (version >= 3.1) } #end
#declare LDXColor2_slope = #if (version >= 3.1) material { #end
	texture {
		lg_green
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor3) // Dark Turquoise
#declare LDXColor3 = #if (version >= 3.1) material { #end
	texture {
		lg_cyan
	}
#if (version >= 3.1) } #end
#declare LDXColor3_slope = #if (version >= 3.1) material { #end
	texture {
		lg_cyan
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor4) // Red
#declare LDXColor4 = #if (version >= 3.1) material { #end
	texture {
		lg_red
	}
#if (version >= 3.1) } #end
#declare LDXColor4_slope = #if (version >= 3.1) material { #end
	texture {
		lg_red
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor5) // Dark Pink
#declare LDXColor5 = #if (version >= 3.1) material { #end
	texture {
		lg_dark_pink
	}
#if (version >= 3.1) } #end
#declare LDXColor5_slope = #if (version >= 3.1) material { #end
	texture {
		lg_dark_pink
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor6) // Brown
#declare LDXColor6 = #if (version >= 3.1) material { #end
	texture {
		lg_brown
	}
#if (version >= 3.1) } #end
#declare LDXColor6_slope = #if (version >= 3.1) material { #end
	texture {
		lg_brown
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor7) // Light Gray
#declare LDXColor7 = #if (version >= 3.1) material { #end
	texture {
		lg_grey
	}
#if (version >= 3.1) } #end
#declare LDXColor7_slope = #if (version >= 3.1) material { #end
	texture {
		lg_grey
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor8) // Dark Gray
#declare LDXColor8 = #if (version >= 3.1) material { #end
	texture {
		lg_dark_grey
	}
#if (version >= 3.1) } #end
#declare LDXColor8_slope = #if (version >= 3.1) material { #end
	texture {
		lg_dark_grey
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor9) // Light Blue
#declare LDXColor9 = #if (version >= 3.1) material { #end
	texture {
		lg_light_blue
	}
#if (version >= 3.1) } #end
#declare LDXColor9_slope = #if (version >= 3.1) material { #end
	texture {
		lg_light_blue
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor10) // Bright Green
#declare LDXColor10 = #if (version >= 3.1) material { #end
	texture {
		lg_bright_green
	}
#if (version >= 3.1) } #end
#declare LDXColor10_slope = #if (version >= 3.1) material { #end
	texture {
		lg_bright_green
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor11) // Light Turquoise
#declare LDXColor11 = #if (version >= 3.1) material { #end
	texture {
		lg_turquoise
	}
#if (version >= 3.1) } #end
#declare LDXColor11_slope = #if (version >= 3.1) material { #end
	texture {
		lg_turquoise
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor12) // Salmon
#declare LDXColor12 = #if (version >= 3.1) material { #end
	texture {
		lg_salmon
	}
#if (version >= 3.1) } #end
#declare LDXColor12_slope = #if (version >= 3.1) material { #end
	texture {
		lg_salmon
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor13) // Pink
#declare LDXColor13 = #if (version >= 3.1) material { #end
	texture {
		lg_pink
	}
#if (version >= 3.1) } #end
#declare LDXColor13_slope = #if (version >= 3.1) material { #end
	texture {
		lg_pink
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor14) // Yellow
#declare LDXColor14 = #if (version >= 3.1) material { #end
	texture {
		lg_yellow
	}
#if (version >= 3.1) } #end
#declare LDXColor14_slope = #if (version >= 3.1) material { #end
	texture {
		lg_yellow
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor15) // White
#declare LDXColor15 = #if (version >= 3.1) material { #end
	texture {
		lg_white
	}
#if (version >= 3.1) } #end
#declare LDXColor15_slope = #if (version >= 3.1) material { #end
	texture {
		lg_white
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor18) // Light Yellow
#declare LDXColor18 = #if (version >= 3.1) material { #end
	texture {
		lg_light_yellow
	}
#if (version >= 3.1) } #end
#declare LDXColor18_slope = #if (version >= 3.1) material { #end
	texture {
		lg_light_yellow
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor19) // Tan
#declare LDXColor19 = #if (version >= 3.1) material { #end
	texture {
		lg_tan
	}
#if (version >= 3.1) } #end
#declare LDXColor19_slope = #if (version >= 3.1) material { #end
	texture {
		lg_tan
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor20) // Light Violet
#declare LDXColor20 = #if (version >= 3.1) material { #end
	texture {
		lg_light_violet
	}
#if (version >= 3.1) } #end
#declare LDXColor20_slope = #if (version >= 3.1) material { #end
	texture {
		lg_light_violet
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor25) // Orange
#declare LDXColor25 = #if (version >= 3.1) material { #end
	texture {
		lg_orange
	}
#if (version >= 3.1) } #end
#declare LDXColor25_slope = #if (version >= 3.1) material { #end
	texture {
		lg_orange
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor26) // Magenta
#declare LDXColor26 = #if (version >= 3.1) material { #end
	texture {
		lg_magenta
	}
#if (version >= 3.1) } #end
#declare LDXColor26_slope = #if (version >= 3.1) material { #end
	texture {
		lg_magenta
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor27) // Lime
#declare LDXColor27 = #if (version >= 3.1) material { #end
	texture {
		lg_lime
	}
#if (version >= 3.1) } #end
#declare LDXColor27_slope = #if (version >= 3.1) material { #end
	texture {
		lg_lime
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor28) // Dark Tan
#declare LDXColor28 = #if (version >= 3.1) material { #end
	texture {
		lg_dark_tan
	}
#if (version >= 3.1) } #end
#declare LDXColor28_slope = #if (version >= 3.1) material { #end
	texture {
		lg_dark_tan
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXSkipTransColorMacro)
#macro LDXTransColor(r, g, b)
#if (version >= 3.1) material { #end
	texture {
		pigment { #if (LDXQual > 1) rgbf <r,g,b,LDXTFilt> #else rgbf <0.6,0.6,0.6,0> #end }
#if (LDXQual > 1)
		finish { ambient LDXAmb diffuse LDXDif }
		finish { phong LDXPhong phong_size LDXPhongS reflection LDXTRefl }
		#if (version >= 3.1) #else finish { refraction 1 ior LDXIoR } #end
#end
	}
#if (version >= 3.1) #if (LDXQual > 1)
	interior { ior LDXIoR }
#end #end
#if (version >= 3.1) } #end
#end
#end

#ifndef (LDXColor32) // Trans Black IR Lens
#declare LDXColor32 = LDXTransColor(0,0,0)
#end

#ifndef (LDXColor33) // Trans Dark Blue
#declare LDXColor33 = #if (version >= 3.1) material { #end
	texture {
		lg_clear_blue
	}
	#if (LDXQual > 1) interior { lg_ior } #end
#if (version >= 3.1) } #end
#declare LDXColor33_slope = #if (version >= 3.1) material { #end
	texture {
		lg_clear_blue
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
	#if (LDXQual > 1) interior { lg_ior } #end
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor34) // Trans Green
#declare LDXColor34 = #if (version >= 3.1) material { #end
	texture {
		lg_clear_green
	}
	#if (LDXQual > 1) interior { lg_ior } #end
#if (version >= 3.1) } #end
#declare LDXColor34_slope = #if (version >= 3.1) material { #end
	texture {
		lg_clear_green
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
	#if (LDXQual > 1) interior { lg_ior } #end
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor35) // Trans Bright Green
#declare LDXColor35 = LDXTransColor(0.505882,0.990196,0.411765)
#end

#ifndef (LDXColor36) // Trans Red
#declare LDXColor36 = #if (version >= 3.1) material { #end
	texture {
		lg_clear_red
	}
	#if (LDXQual > 1) interior { lg_ior } #end
#if (version >= 3.1) } #end
#declare LDXColor36_slope = #if (version >= 3.1) material { #end
	texture {
		lg_clear_red
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
	#if (LDXQual > 1) interior { lg_ior } #end
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor37) // Trans Dark Pink
#declare LDXColor37 = #if (version >= 3.1) material { #end
	texture {
		lg_clear_violet
	}
	#if (LDXQual > 1) interior { lg_ior } #end
#if (version >= 3.1) } #end
#declare LDXColor37_slope = #if (version >= 3.1) material { #end
	texture {
		lg_clear_violet
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
	#if (LDXQual > 1) interior { lg_ior } #end
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor38) // Trans Neon Orange
#declare LDXColor38 = LDXTransColor(1,0.950196,0.076471)
#end

#ifndef (LDXColor39) // Trans Very Light Blue
#declare LDXColor39 = LDXTransColor(0.975686,0.987451,0.994118)
#end

#ifndef (LDXColor40) // Trans Black
#declare LDXColor40 = #if (version >= 3.1) material { #end
	texture {
		lg_clear_brown
	}
	#if (LDXQual > 1) interior { lg_ior } #end
#if (version >= 3.1) } #end
#declare LDXColor40_slope = #if (version >= 3.1) material { #end
	texture {
		lg_clear_brown
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
	#if (LDXQual > 1) interior { lg_ior } #end
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor41) // Trans Medium Blue
#declare LDXColor41 = #if (version >= 3.1) material { #end
	texture {
		lg_clear_cyan
	}
	#if (LDXQual > 1) interior { lg_ior } #end
#if (version >= 3.1) } #end
#declare LDXColor41_slope = #if (version >= 3.1) material { #end
	texture {
		lg_clear_cyan
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
	#if (LDXQual > 1) interior { lg_ior } #end
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor42) // Trans Neon Green
#declare LDXColor42 = #if (version >= 3.1) material { #end
	texture {
		lg_clear_neon_yellow
	}
	#if (LDXQual > 1) interior { lg_ior } #end
#if (version >= 3.1) } #end
#declare LDXColor42_slope = #if (version >= 3.1) material { #end
	texture {
		lg_clear_neon_yellow
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
	#if (LDXQual > 1) interior { lg_ior } #end
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor43) // Trans Light Blue
#declare LDXColor43 = LDXTransColor(0.968235,0.991373,0.993725)
#end

#ifndef (LDXColor44) // Trans Light Purple
#declare LDXColor44 = LDXTransColor(0.958824,0.658824,0.962353)
#end

#ifndef (LDXColor45) // Trans Pink
#declare LDXColor45 = #if (version >= 3.1) material { #end
	texture {
		lg_clear_pink
	}
	#if (LDXQual > 1) interior { lg_ior } #end
#if (version >= 3.1) } #end
#declare LDXColor45_slope = #if (version >= 3.1) material { #end
	texture {
		lg_clear_pink
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
	#if (LDXQual > 1) interior { lg_ior } #end
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor46) // Trans Yellow
#declare LDXColor46 = #if (version >= 3.1) material { #end
	texture {
		lg_clear_yellow
	}
	#if (LDXQual > 1) interior { lg_ior } #end
#if (version >= 3.1) } #end
#declare LDXColor46_slope = #if (version >= 3.1) material { #end
	texture {
		lg_clear_yellow
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
	#if (LDXQual > 1) interior { lg_ior } #end
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor47) // Trans Clear
#declare LDXColor47 = #if (version >= 3.1) material { #end
	texture {
		lg_clear
	}
	#if (LDXQual > 1) interior { lg_ior } #end
#if (version >= 3.1) } #end
#declare LDXColor47_slope = #if (version >= 3.1) material { #end
	texture {
		lg_clear
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
	#if (LDXQual > 1) interior { lg_ior } #end
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor57) // Trans Orange
#declare LDXColor57 = #if (version >= 3.1) material { #end
	texture {
		lg_clear_neon_orange
	}
	#if (LDXQual > 1) interior { lg_ior } #end
#if (version >= 3.1) } #end
#declare LDXColor57_slope = #if (version >= 3.1) material { #end
	texture {
		lg_clear_neon_orange
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
	#if (LDXQual > 1) interior { lg_ior } #end
#if (version >= 3.1) } #end
#end

#ifndef (LDXSkipChromeColorMacro)
#macro LDXChromeColor(r, g, b)
#if (version >= 3.1) material { #end
	texture {
		pigment { rgbf <r,g,b,0> }
#if (LDXQual > 1)
		finish { ambient LDXAmb diffuse LDXDif }
		finish { phong LDXPhong phong_size LDXPhongS reflection LDXChromeRefl brilliance LDXChromeBril metallic specular LDXChromeSpec roughness LDXChromeRough}
#end
	}
#if (version >= 3.1) } #end
#end
#end

#ifndef (LDXColor60) // Chrome Antique Brass
#declare LDXColor60 = LDXChromeColor(0.392157,0.352941,0.298039)
#end

#ifndef (LDXColor70) // Reddish Brown
#declare LDXColor70 = #if (version >= 3.1) material { #end
	texture {
		lg_reddish_brown
	}
#if (version >= 3.1) } #end
#declare LDXColor70_slope = #if (version >= 3.1) material { #end
	texture {
		lg_reddish_brown
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor71) // Light Bluish Gray
#declare LDXColor71 = #if (version >= 3.1) material { #end
	texture {
		lg_bluish_grey
	}
#if (version >= 3.1) } #end
#declare LDXColor71_slope = #if (version >= 3.1) material { #end
	texture {
		lg_bluish_grey
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor72) // Dark Bluish Gray
#declare LDXColor72 = #if (version >= 3.1) material { #end
	texture {
		lg_dark_bluish_grey
	}
#if (version >= 3.1) } #end
#declare LDXColor72_slope = #if (version >= 3.1) material { #end
	texture {
		lg_dark_bluish_grey
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor74) // Medium Green
#declare LDXColor74 = #if (version >= 3.1) material { #end
	texture {
		lg_medium_green
	}
#if (version >= 3.1) } #end
#declare LDXColor74_slope = #if (version >= 3.1) material { #end
	texture {
		lg_medium_green
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor77) // Light Pink
#declare LDXColor77 = #if (version >= 3.1) material { #end
	texture {
		lg_paradisa_pink
	}
#if (version >= 3.1) } #end
#declare LDXColor77_slope = #if (version >= 3.1) material { #end
	texture {
		lg_paradisa_pink
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXSkipOpaqueColorMacro)
#macro LDXOpaqueColor(r, g, b)
#if (version >= 3.1) material { #end
	texture {
		pigment { rgbf <r,g,b,0> }
#if (LDXQual > 1)
		finish { ambient LDXAmb diffuse LDXDif }
		finish { phong LDXPhong phong_size LDXPhongS reflection LDXRefl }
#end
	}
#if (version >= 3.1) } #end
#end
#end

#ifndef (LDXColor80) // Metallic Silver
#declare LDXColor80 = LDXOpaqueColor(0.647059,0.662745,0.705882)
#end

#ifndef (LDXColor87) // Metallic Dark Gray
#declare LDXColor87 = LDXOpaqueColor(0.427451,0.431373,0.360784)
#end

#ifndef (LDXColor110) // Violet
#declare LDXColor110 = LDXOpaqueColor(0.262745,0.329412,0.639216)
#end

#ifndef (LDXColor134) // Copper
#declare LDXColor134 = #if (version >= 3.1) material { #end
	texture {
		lg_pearl_copper
	}
#if (version >= 3.1) } #end
#declare LDXColor134_slope = #if (version >= 3.1) material { #end
	texture {
		lg_pearl_copper
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXSkipRubberColorMacro)
#macro LDXRubberColor(r, g, b)
#if (version >= 3.1) material { #end
	texture {
		pigment { rgbf <r,g,b,0> }
#if (LDXQual > 1)
		finish { ambient LDXAmb diffuse LDXDif }
		finish { phong LDXRubberPhong phong_size LDXRubberPhongS reflection LDXRubberRefl }
#end
	}
#if (version >= 3.1) } #end
#end
#end

#ifndef (LDXColor256) // Rubber Black
#declare LDXColor256 = LDXRubberColor(0.129412,0.129412,0.129412)
#end

#ifndef (LDXColor258)
#declare LDXColor258 = LDXOpaqueColor(0.098039,0.34902,0.2)
#end

#ifndef (LDXColor272) // Dark Blue
#declare LDXColor272 = #if (version >= 3.1) material { #end
	texture {
		lg_dark_blue
	}
#if (version >= 3.1) } #end
#declare LDXColor272_slope = #if (version >= 3.1) material { #end
	texture {
		lg_dark_blue
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor277)
#declare LDXColor277 = LDXOpaqueColor(0.498039,0.2,0.647059)
#end

#ifndef (LDXColor288) // Dark Green
#declare LDXColor288 = #if (version >= 3.1) material { #end
	texture {
		lg_dark_green
	}
#if (version >= 3.1) } #end
#declare LDXColor288_slope = #if (version >= 3.1) material { #end
	texture {
		lg_dark_green
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor320) // Dark Red
#declare LDXColor320 = #if (version >= 3.1) material { #end
	texture {
		lg_dark_red
	}
#if (version >= 3.1) } #end
#declare LDXColor320_slope = #if (version >= 3.1) material { #end
	texture {
		lg_dark_red
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor324) // Rubber Red
#declare LDXColor324 = LDXRubberColor(0.768627,0,0.14902)
#end

#ifndef (LDXColor334) // Chrome Gold
#declare LDXColor334 = #if (version >= 3.1) material { #end
	texture {
		lg_gold_chrome
	}
#if (version >= 3.1) } #end
#declare LDXColor334_slope = #if (version >= 3.1) material { #end
	texture {
		lg_gold_chrome
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor354)
#declare LDXColor354 = LDXOpaqueColor(0.2,0.34902,0.098039)
#end

#ifndef (LDXColor366) // Earth Orange
#declare LDXColor366 = #if (version >= 3.1) material { #end
	texture {
		lg_earth_orange
	}
#if (version >= 3.1) } #end
#declare LDXColor366_slope = #if (version >= 3.1) material { #end
	texture {
		lg_earth_orange
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor379) // Sand Blue
#declare LDXColor379 = #if (version >= 3.1) material { #end
	texture {
		lg_sand_blue
	}
#if (version >= 3.1) } #end
#declare LDXColor379_slope = #if (version >= 3.1) material { #end
	texture {
		lg_sand_blue
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor382)
#declare LDXColor382 = LDXOpaqueColor(0.8,0.666667,0.4)
#end

#ifndef (LDXColor383) // Chrome Silver
#declare LDXColor383 = #if (version >= 3.1) material { #end
	texture {
		lg_chrome
	}
#if (version >= 3.1) } #end
#declare LDXColor383_slope = #if (version >= 3.1) material { #end
	texture {
		lg_chrome
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor484) // Dark Orange
#declare LDXColor484 = #if (version >= 3.1) material { #end
	texture {
		lg_dark_orange
	}
#if (version >= 3.1) } #end
#declare LDXColor484_slope = #if (version >= 3.1) material { #end
	texture {
		lg_dark_orange
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor487)
#declare LDXColor487 = LDXOpaqueColor(0.8,0.74902,0.298039)
#end

#ifndef (LDXColor492)
#declare LDXColor492 = LDXOpaqueColor(1,0.447059,0)
#end

#ifndef (LDXColor493) // Magnet
#declare LDXColor493 = LDXOpaqueColor(0.396078,0.403922,0.380392)
#end

#ifndef (LDXColor494) // Electric Contact Alloy
#declare LDXColor494 = LDXOpaqueColor(0.815686,0.815686,0.815686)
#end

#ifndef (LDXColor503) // Very Light Gray
#declare LDXColor503 = #if (version >= 3.1) material { #end
	texture {
		lg_very_light_grey
	}
#if (version >= 3.1) } #end
#declare LDXColor503_slope = #if (version >= 3.1) material { #end
	texture {
		lg_very_light_grey
		#if (LDXQual > 1) normal { bumps 0.3 scale 25*0.02 } #end
	}
#if (version >= 3.1) } #end
#end

#ifndef (LDXColor43602464)
#declare LDXColor43602464 = LDXOpaqueColor(0.6,0.321569,0.12549)
#end

#include "lg_3811.inc" // Baseplate 32 x 32

#include "lg_3068b.inc" // Tile  2 x  2 with Groove

#include "lg_3070a.inc" // Tile  1 x  1 without Groove

#include "lg_3024.inc" // Plate  1 x  1

#include "lg_3035.inc" // Plate  4 x  8

#include "lg_3958.inc" // Plate  6 x  6

#include "lg_3023.inc" // Plate  1 x  2

#include "lg_3795.inc" // Plate  2 x  6

#include "lg_3020.inc" // Plate  2 x  4

#include "lg_3022.inc" // Plate  2 x  2

#include "lg_2420.inc" // Plate  2 x  2 Corner

#include "lg_3666.inc" // Plate  1 x  6

#declare LDX_4_dash_4cyli_dot_dat_in_part = cylinder // Cylinder 1
{
	<0,0,0>,<0,1,0>,1 open
}

#declare LDX_4_dash_4cyli_dot_dat = cylinder // Cylinder 1
{
	<0,0,0>,<0,1,0>,1 open
}

#declare LDX_4_dash_4ring2_dot_dat_in_part = disc // Ring 1
{
	<0,0,0>,<0,1,0>,3,2
}

#declare LDX_4_dash_4ring2_dot_dat = disc // Ring 1
{
	<0,0,0>,<0,1,0>,3,2
}

#declare LDX_stud2_dot_dat_in_part = union {
// Stud Open
// Name: stud2.dat
// Author: James Jessiman
// !LDRAW_ORG Primitive UPDATE 2009-02
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CCW
// !HISTORY 1999-07-05 [PTadmin] Official Update 1999-05
// !HISTORY 2002-04-04 [sbliss] Modified for BFC compliance
// !HISTORY 2002-04-25 [PTadmin] Official Update 2002-02
// !HISTORY 2007-06-24 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
// !HISTORY 2009-06-21 [cwdee] Update ring references to 4-4ring
// !HISTORY 2009-09-03 [PTadmin] Official Update 2009-02
// BFC INVERTNEXT
	object {
		LDX_4_dash_4cyli_dot_dat_in_part
		matrix <4,0,0,0,4,0,0,0,4,0,-4,0>
	}
	object {
		LDX_4_dash_4cyli_dot_dat_in_part
		matrix <6,0,0,0,4,0,0,0,6,0,-4,0>
	}
	object {
		LDX_4_dash_4ring2_dot_dat_in_part
		matrix <2,0,0,0,1,0,0,0,2,0,-4,0>
	}
}

#declare LDX_4_dash_4disc_dot_dat_in_part = disc // Disc 1
{
	<0,0,0>,<0,1,0>,1
}

#declare LDX_4_dash_4disc_dot_dat = disc // Disc 1
{
	<0,0,0>,<0,1,0>,1
}

#declare LDX_4_dash_4ring4_dot_dat_in_part = disc // Ring 1
{
	<0,0,0>,<0,1,0>,5,4
}

#declare LDX_4_dash_4ring4_dot_dat = disc // Ring 1
{
	<0,0,0>,<0,1,0>,5,4
}

#declare LDX_t04o3333_dot_dat_in_part = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_4_dash_4ring3_dot_dat_in_part = disc // Ring 1
{
	<0,0,0>,<0,1,0>,4,3
}

#declare LDX_4_dash_4ring3_dot_dat = disc // Ring 1
{
	<0,0,0>,<0,1,0>,4,3
}

#declare LDX_4_dash_4ndis_dot_dat_in_part = disc // Not-Disc 1
{
	<0,0,0>,<0,1,0>,2,1
	clipped_by
	{
		box
		{
			<-1,-1,-1>,<1,1,1>
		}
	}
}

#declare LDX_4_dash_4ndis_dot_dat = disc // Not-Disc 1
{
	<0,0,0>,<0,1,0>,2,1
	clipped_by
	{
		box
		{
			<-1,-1,-1>,<1,1,1>
		}
	}
}

#declare LDX_1_dash_4cyli_dot_dat_in_part = cylinder // Cylinder 0.25
{
	<0,0,0>,<0,1,0>,1 open
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
	}
}

#declare LDX_1_dash_4cyli_dot_dat = cylinder // Cylinder 0.25
{
	<0,0,0>,<0,1,0>,1 open
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
	}
}

#declare LDX_1_dash_4disc_dot_dat_in_part = disc // Disc 0.25
{
	<0,0,0>,<0,1,0>,1
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
	}
}

#declare LDX_1_dash_4disc_dot_dat = disc // Disc 0.25
{
	<0,0,0>,<0,1,0>,1
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
	}
}

#declare LDX_1_dash_4ring1_dot_dat_in_part = disc // Ring 0.25
{
	<0,0,0>,<0,1,0>,2,1
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
	}
}

#declare LDX_1_dash_4ring1_dot_dat = disc // Ring 0.25
{
	<0,0,0>,<0,1,0>,2,1
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
	}
}

#declare LDX_stud4_dot_dat_in_part = union {
// Stud Tube Open
// Name: stud4.dat
// Author: James Jessiman
// !LDRAW_ORG Primitive UPDATE 2009-02
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CCW
// !HISTORY 1999-07-05 [PTadmin] Official Update 1999-05
// !HISTORY 2002-04-04 [sbliss] Modified for BFC compliance
// !HISTORY 2002-04-25 [PTadmin] Official Update 2002-02
// !HISTORY 2007-06-24 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
// !HISTORY 2009-06-21 [cwdee] Update ring references to 4-4ring
// !HISTORY 2009-09-03 [PTadmin] Official Update 2009-02
// BFC INVERTNEXT
	object {
		LDX_4_dash_4cyli_dot_dat_in_part
		matrix <6,0,0,0,4,0,0,0,6,0,-4,0>
	}
	object {
		LDX_4_dash_4cyli_dot_dat_in_part
		matrix <8,0,0,0,4,0,0,0,8,0,-4,0>
	}
	object {
		LDX_4_dash_4ring3_dot_dat_in_part
		matrix <2,0,0,0,1,0,0,0,2,0,-4,0>
	}
}

#declare LDX_4_dash_4ring5_dot_dat_in_part = disc // Ring 1
{
	<0,0,0>,<0,1,0>,6,5
}

#declare LDX_4_dash_4ring5_dot_dat = disc // Ring 1
{
	<0,0,0>,<0,1,0>,6,5
}

#declare LDX_t04o3333_dot_dat_in_part = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat_in_part = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat_in_part = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat_in_part = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat_in_part = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat_in_part = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat_in_part = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat_in_part = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat_in_part = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat_in_part = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat_in_part = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat_in_part = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat_in_part = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat_in_part = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat_in_part = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat_in_part = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat_in_part = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat_in_part = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat_in_part = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat_in_part = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o3333_dot_dat = torus // Torus 0.25
{
	1,0.3333333432674407959
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_2039_dot_dat =
#if (LDXQual = 0)
box {
	<-20,-4,-20>,<20,168,20>
}
#else
union {
// Lamppost  2 x  2 x  7
// Name: 2039.dat
// Author: Chris Dee [cwdee]
// !LDRAW_ORG Part UPDATE 2013-02
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CCW
// !CATEGORY Roadsign
// !KEYWORDS Fabuland, Belville, Trains, Harry Potter, Creator, Freestyle
// !HISTORY 2002-11-30 [PTadmin] Official Update 2002-05
// !HISTORY 2007-05-04 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
// !HISTORY 2008-07-07 [nielsk] Made BFC compliant (2005-10-31)
// !HISTORY 2008-07-08 [Philo] Corrected bad ring (2007-11-26)
// !HISTORY 2009-09-03 [PTadmin] Official Update 2009-02
// !HISTORY 2013-08-29 [cwdee] Update category
// !HISTORY 2013-12-23 [PTadmin] Official Update 2013-02
	#if (LDXStuds)
		object {
			LDX_stud2_dot_dat_in_part
			matrix <1,0,0,0,1,0,0,0,1,0,0,0>
		}
	#end // LDXStuds
	object {
		LDX_4_dash_4disc_dot_dat_in_part
		matrix <4,0,0,0,1,0,0,0,4,0,0,0>
	}
// // top torus
	object {
		LDX_4_dash_4ring4_dot_dat_in_part
		matrix <1.5,0,0,0,1,0,0,0,1.5,0,0,0>
	}
	object {
		LDX_t04o3333_dot_dat_in_part
		matrix <7.5,0,0,0,7.5,0,0,0,7.5,0,2.5,0>
	}
	object {
		LDX_t04o3333_dot_dat_in_part
		matrix <-7.5,0,0,0,7.5,0,0,0,7.5,0,2.5,0>
	}
	object {
		LDX_t04o3333_dot_dat_in_part
		matrix <7.5,0,0,0,7.5,0,0,0,-7.5,0,2.5,0>
	}
	object {
		LDX_t04o3333_dot_dat_in_part
		matrix <-7.5,0,0,0,7.5,0,0,0,-7.5,0,2.5,0>
	}
	object {
		LDX_t04o3333_dot_dat_in_part
		matrix <7.5,0,0,0,-7.5,0,0,0,7.5,0,2.5,0>
	}
	object {
		LDX_t04o3333_dot_dat_in_part
		matrix <-7.5,0,0,0,-7.5,0,0,0,7.5,0,2.5,0>
	}
	object {
		LDX_t04o3333_dot_dat_in_part
		matrix <7.5,0,0,0,-7.5,0,0,0,-7.5,0,2.5,0>
	}
	object {
		LDX_t04o3333_dot_dat_in_part
		matrix <-7.5,0,0,0,-7.5,0,0,0,-7.5,0,2.5,0>
	}
	object {
		LDX_4_dash_4ring4_dot_dat_in_part
		matrix <1.5,0,0,0,-1,0,0,0,1.5,0,5,0>
	}
// // cylinder between tori
	object {
		LDX_4_dash_4cyli_dot_dat_in_part
		matrix <6,0,0,0,8,0,0,0,6,0,5,0>
	}
// // second torus
	object {
		LDX_4_dash_4ring4_dot_dat_in_part
		matrix <1.5,0,0,0,1,0,0,0,1.5,0,13,0>
	}
	object {
		LDX_t04o3333_dot_dat_in_part
		matrix <7.5,0,0,0,7.5,0,0,0,7.5,0,15.5,0>
	}
	object {
		LDX_t04o3333_dot_dat_in_part
		matrix <-7.5,0,0,0,7.5,0,0,0,7.5,0,15.5,0>
	}
	object {
		LDX_t04o3333_dot_dat_in_part
		matrix <7.5,0,0,0,7.5,0,0,0,-7.5,0,15.5,0>
	}
	object {
		LDX_t04o3333_dot_dat_in_part
		matrix <-7.5,0,0,0,7.5,0,0,0,-7.5,0,15.5,0>
	}
	object {
		LDX_t04o3333_dot_dat_in_part
		matrix <7.5,0,0,0,-7.5,0,0,0,7.5,0,15.5,0>
	}
	object {
		LDX_t04o3333_dot_dat_in_part
		matrix <-7.5,0,0,0,-7.5,0,0,0,7.5,0,15.5,0>
	}
	object {
		LDX_t04o3333_dot_dat_in_part
		matrix <7.5,0,0,0,-7.5,0,0,0,-7.5,0,15.5,0>
	}
	object {
		LDX_t04o3333_dot_dat_in_part
		matrix <-7.5,0,0,0,-7.5,0,0,0,-7.5,0,15.5,0>
	}
	object {
		LDX_4_dash_4disc_dot_dat_in_part
		matrix <7.5,0,0,0,-1,0,0,0,7.5,0,18,0>
	}
// // upper column
	object {
		LDX_4_dash_4disc_dot_dat_in_part
		matrix <7,0,0,0,1,0,0,0,7,0,100,0>
	}
	object {
		LDX_4_dash_4disc_dot_dat_in_part
		matrix <8.705,0,0,0,-1,0,0,0,8.705,0,104,0>
	}
// // lower column
	object {
		LDX_4_dash_4ring3_dot_dat_in_part
		matrix <2.5,0,0,0,1,0,0,0,2.5,0,154,0>
	}
	object {
		LDX_4_dash_4cyli_dot_dat_in_part
		matrix <10,0,0,0,6,0,0,0,10,0,154,0>
	}
	object {
		LDX_4_dash_4ndis_dot_dat_in_part
		matrix <10,0,0,0,1,0,0,0,10,0,160,0>
	}
	object {
		LDX_1_dash_4cyli_dot_dat_in_part
		matrix <0,-2,0,-24,0,0,0,0,2,12,162,18>
	}
	object {
		LDX_1_dash_4disc_dot_dat_in_part
		matrix <6,0,0,0,1,0,0,0,6,12,160,12>
	}
	object {
		LDX_t04o3333_dot_dat_in_part
		matrix <6,0,0,0,-6,0,0,0,6,12,162,12>
	}
	object {
		LDX_1_dash_4cyli_dot_dat_in_part
		matrix <8,0,0,0,6,0,0,0,8,12,162,12>
	}
	object {
		LDX_1_dash_4ring1_dot_dat_in_part
		matrix <4,0,0,0,-1,0,0,0,4,12,168,12>
	}
// BFC INVERTNEXT
	object {
		LDX_1_dash_4cyli_dot_dat_in_part
		matrix <4,0,0,0,-4,0,0,0,4,12,168,12>
	}
	object {
		LDX_1_dash_4disc_dot_dat_in_part
		matrix <4,0,0,0,-1,0,0,0,4,12,164,12>
	}
	object {
		LDX_1_dash_4cyli_dot_dat_in_part
		matrix <0,-2,0,0,0,24,2,0,0,18,162,-12>
	}
	object {
		LDX_1_dash_4disc_dot_dat_in_part
		matrix <0,0,-6,0,1,0,6,0,0,12,160,-12>
	}
	object {
		LDX_t04o3333_dot_dat_in_part
		matrix <0,0,-6,0,-6,0,6,0,0,12,162,-12>
	}
	object {
		LDX_1_dash_4cyli_dot_dat_in_part
		matrix <0,0,-8,0,6,0,8,0,0,12,162,-12>
	}
	object {
		LDX_1_dash_4ring1_dot_dat_in_part
		matrix <0,0,-4,0,-1,0,4,0,0,12,168,-12>
	}
// BFC INVERTNEXT
	object {
		LDX_1_dash_4cyli_dot_dat_in_part
		matrix <0,0,-4,0,-4,0,4,0,0,12,168,-12>
	}
	object {
		LDX_1_dash_4disc_dot_dat_in_part
		matrix <0,0,-4,0,-1,0,4,0,0,12,164,-12>
	}
	object {
		LDX_1_dash_4cyli_dot_dat_in_part
		matrix <0,-2,0,24,0,0,0,0,-2,-12,162,-18>
	}
	object {
		LDX_1_dash_4disc_dot_dat_in_part
		matrix <-6,0,0,0,1,0,0,0,-6,-12,160,-12>
	}
	object {
		LDX_t04o3333_dot_dat_in_part
		matrix <-6,0,0,0,-6,0,0,0,-6,-12,162,-12>
	}
	object {
		LDX_1_dash_4cyli_dot_dat_in_part
		matrix <-8,0,0,0,6,0,0,0,-8,-12,162,-12>
	}
	object {
		LDX_1_dash_4ring1_dot_dat_in_part
		matrix <-4,0,0,0,-1,0,0,0,-4,-12,168,-12>
	}
// BFC INVERTNEXT
	object {
		LDX_1_dash_4cyli_dot_dat_in_part
		matrix <-4,0,0,0,-4,0,0,0,-4,-12,168,-12>
	}
	object {
		LDX_1_dash_4disc_dot_dat_in_part
		matrix <-4,0,0,0,-1,0,0,0,-4,-12,164,-12>
	}
	object {
		LDX_1_dash_4cyli_dot_dat_in_part
		matrix <0,-2,0,0,0,-24,-2,0,0,-18,162,12>
	}
	object {
		LDX_1_dash_4disc_dot_dat_in_part
		matrix <0,0,6,0,1,0,-6,0,0,-12,160,12>
	}
	object {
		LDX_t04o3333_dot_dat_in_part
		matrix <0,0,6,0,-6,0,-6,0,0,-12,162,12>
	}
	object {
		LDX_1_dash_4cyli_dot_dat_in_part
		matrix <0,0,8,0,6,0,-8,0,0,-12,162,12>
	}
	object {
		LDX_1_dash_4ring1_dot_dat_in_part
		matrix <0,0,4,0,-1,0,-4,0,0,-12,168,12>
	}
// BFC INVERTNEXT
	object {
		LDX_1_dash_4cyli_dot_dat_in_part
		matrix <0,0,4,0,-4,0,-4,0,0,-12,168,12>
	}
	object {
		LDX_1_dash_4disc_dot_dat_in_part
		matrix <0,0,4,0,-1,0,-4,0,0,-12,164,12>
	}
	#if (LDXStuds)
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,0,164,0>
		}
	#end // LDXStuds
	object {
		LDX_4_dash_4ndis_dot_dat_in_part
		matrix <8,0,0,0,-1,0,0,0,8,0,164,0>
	}
	object {
		LDX_4_dash_4ring5_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,0,164,0>
	}
// BFC INVERTNEXT
	object {
		LDX_4_dash_4cyli_dot_dat_in_part
		matrix <5,0,0,0,-56,0,0,0,5,0,164,0>
	}
	object {
		LDX_4_dash_4disc_dot_dat_in_part
		matrix <5,0,0,0,-1,0,0,0,5,0,108,0>
	}
	mesh2 {
		vertex_vectors {
			840,
			<-20,162,-12>, <-20,162,12>, <-20,168,-12>, <-20,168,12>,
			<-18,160,-12>, <-18,160,12>, <-16,164,-12>, <-16,164,12>,
			<-16,168,-12>, <-16,168,12>, <-12,160,-18>, <-12,160,-12>,
			<-12,160,12>, <-12,160,18>, <-12,162,-20>, <-12,162,20>,
			<-12,164,-16>, <-12,164,-12>, <-12,164,12>, <-12,164,16>,
			<-12,168,-20>, <-12,168,-16>, <-12,168,16>, <-12,168,20>,
			<-10,160,-10>, <-10,160,10>, <-9.99956,124,-1.499934>, <-9.999559,124,1.499934>,
			<-9.99956,134,-1.499934>, <-9.999559,134,1.499934>, <-9,102.5,0>, <-8.999603,113,-1.499934>,
			<-8.999604,113,1.499934>, <-8.999603,145,-1.499934>, <-8.999604,145,1.499934>, <-8.848,101.542999,0>,
			<-8.848,103.457001,0>, <-8.705,104,0>, <-8.69306,113,-2.262858>, <-8.69306,113,2.262858>,
			<-8.69306,145,-2.262858>, <-8.69306,145,2.262858>, <-8.555195,109,-1.499686>, <-8.555195,109,1.499686>,
			<-8.555195,149,-1.499686>, <-8.555195,149,1.499686>, <-8.414,100.732002,0>, <-8.388491,107.5,-1.50043>,
			<-8.388491,107.5,1.50043>, <-8.388491,150.5,-1.50043>, <-8.388491,150.5,1.50043>, <-8.315,102.5,-3.444>,
			<-8.315,102.5,3.444>, <-8.233036,124,-1.731678>, <-8.233036,124,1.731678>, <-8.233036,134,-1.731678>,
			<-8.233036,134,1.731678>, <-8.174,101.542999,-3.386>, <-8.174,101.542999,3.386>, <-8.174,103.457001,-3.386>,
			<-8.174,103.457001,3.386>, <-8.061638,109,-2.9225>, <-8.061638,109,2.9225>, <-8.061638,149,-2.9225>,
			<-8.061638,149,2.9225>, <-8.042,104,-3.331>, <-8.042,104,3.331>, <-8,164,-8>,
			<-8,164,8>, <-7.999648,104,-1.499934>, <-7.999648,104,1.499934>, <-7.999648,154,-1.499934>,
			<-7.999648,154,1.499934>, <-7.95441,108.426003,-2.992224>, <-7.95441,108.426003,2.992224>, <-7.95441,149.574005,-2.992224>,
			<-7.95441,149.574005,2.992224>, <-7.88458,113,-2.603192>, <-7.88458,113,2.603192>, <-7.88458,145,-2.603192>,
			<-7.88458,145,2.603192>, <-7.774,100.732002,-3.22>, <-7.774,100.732002,3.22>, <-7.772858,107.939003,-3.262674>,
			<-7.772858,107.939003,3.262674>, <-7.772858,150.061005,-3.262674>, <-7.772858,150.061005,3.262674>, <-7.765,100.190002,0>,
			<-7.544946,107.613998,-3.693416>, <-7.544946,107.613998,3.693416>, <-7.544946,150.386002,-3.693416>, <-7.544946,150.386002,3.693416>,
			<-7.264874,107.5,-4.1945>, <-7.264874,107.5,4.1945>, <-7.264874,150.5,-4.1945>, <-7.264874,150.5,4.1945>,
			<-7.249794,109,-2.960674>, <-7.249794,109,2.960674>, <-7.249794,149,-2.960674>, <-7.249794,149,2.960674>,
			<-7.174,100.190002,-2.972>, <-7.174,100.190002,2.972>, <-7,100,0>, <-6.970945,107.613998,-4.687584>,
			<-6.970945,107.613998,4.687584>, <-6.970945,150.386002,-4.687584>, <-6.970945,150.386002,4.687584>, <-6.928,104,-4>,
			<-6.928,104,4>, <-6.928,154,-4>, <-6.928,154,4>, <-6.85006,113,-3.955>,
			<-6.85006,113,3.955>, <-6.85006,145,-3.955>, <-6.85006,145,3.955>, <-6.711858,107.939003,-5.100326>,
			<-6.711858,107.939003,5.100326>, <-6.711858,150.061005,-5.100326>, <-6.711858,150.061005,5.100326>, <-6.705438,107.939003,-3.8715>,
			<-6.705438,107.939003,3.8715>, <-6.705438,150.061005,-3.8715>, <-6.705438,150.061005,3.8715>, <-6.56841,108.426003,-5.392776>,
			<-6.56841,108.426003,5.392776>, <-6.56841,149.574005,-5.392776>, <-6.56841,149.574005,5.392776>, <-6.561638,109,-5.5205>,
			<-6.561638,109,5.5205>, <-6.561638,149,-5.5205>, <-6.561638,149,5.5205>, <-6.474216,109,-3.738>,
			<-6.474216,109,3.738>, <-6.474216,149,-3.738>, <-6.474216,149,3.738>, <-6.467,100,-2.679>,
			<-6.467,100,2.679>, <-6.41706,124,-3.705>, <-6.41706,124,3.705>, <-6.41706,134,-3.705>,
			<-6.41706,134,3.705>, <-6.364,102.5,-6.364>, <-6.364,102.5,6.364>, <-6.30606,113,-6.397142>,
			<-6.30606,113,6.397142>, <-6.30606,145,-6.397142>, <-6.30606,145,6.397142>, <-6.299,124,-7.91>,
			<-6.29856,124,7.910066>, <-6.299,134,-7.91>, <-6.29856,134,7.910066>, <-6.256,101.542999,-6.256>,
			<-6.256,101.542999,6.256>, <-6.256,103.457001,-6.256>, <-6.256,103.457001,6.256>, <-6.19658,113,-5.526808>,
			<-6.19658,113,5.526808>, <-6.19658,145,-5.526808>, <-6.19658,145,5.526808>, <-6.188794,109,-4.798326>,
			<-6.188794,109,4.798326>, <-6.188794,149,-4.798326>, <-6.188794,149,4.798326>, <-6.155,104,-6.155>,
			<-6.155,104,6.155>, <-5.999736,18,-0.999956>, <-5.999736,18,0.999956>, <-5.999736,21,-0.999956>,
			<-5.999736,21,0.999956>, <-5.999736,24,-0.999956>, <-5.999736,24,0.999956>, <-5.999736,94,-0.999956>,
			<-5.999736,94,0.999956>, <-5.999736,97,-0.999956>, <-5.999736,97,0.999956>, <-5.999736,100,-0.999956>,
			<-5.999736,100,0.999956>, <-5.95,100.732002,-5.95>, <-5.95,100.732002,5.95>, <-5.938654,21,-1.151748>,
			<-5.938654,21,1.151748>, <-5.938654,22.851999,-1.151748>, <-5.938654,22.851999,1.151748>, <-5.938654,95.148003,-1.151748>,
			<-5.938654,95.148003,1.151748>, <-5.938654,97,-1.151748>, <-5.938654,97,1.151748>, <-5.799,113,-7.044>,
			<-5.798604,113,7.044065>, <-5.799,145,-7.044>, <-5.798604,145,7.044065>, <-5.76431,21,-1.585706>,
			<-5.76431,21,1.585706>, <-5.76431,21.879,-1.585706>, <-5.76431,21.879,1.585706>, <-5.76431,96.121002,-1.585706>,
			<-5.76431,96.121002,1.585706>, <-5.76431,97,-1.585706>, <-5.76431,97,1.585706>, <-5.616035,124,-6.264322>,
			<-5.616035,124,6.264322>, <-5.616035,134,-6.264322>, <-5.616035,134,6.264322>, <-5.576194,109,-6.659314>,
			<-5.576194,109,6.659314>, <-5.576194,149,-6.659314>, <-5.576194,149,6.659314>, <-5.504044,21,-2.234478>,
			<-5.504044,21,2.234478>, <-5.504044,21.228001,-2.234478>, <-5.504044,21.228001,2.234478>, <-5.504044,96.772003,-2.234478>,
			<-5.504044,96.772003,2.234478>, <-5.504044,97,-2.234478>, <-5.504044,97,2.234478>, <-5.49349,107.5,-6.51457>,
			<-5.49349,107.5,6.51457>, <-5.49349,150.5,-6.51457>, <-5.49349,150.5,6.51457>, <-5.491,100.190002,-5.491>,
			<-5.491,100.190002,5.491>, <-5.299,104,-6.178>, <-5.298648,104,6.178066>, <-5.299,154,-6.178>,
			<-5.298648,154,6.178066>, <-5.196,18,-3>, <-5.196,18,3>, <-5.196,21,-3>,
			<-5.196,21,3>, <-5.196,97,-3>, <-5.196,97,3>, <-5.196,100,-3>,
			<-5.196,100,3>, <-5.06453,24,-1.637776>, <-5.06453,24,1.637776>, <-5.06453,94,-1.637776>,
			<-5.06453,94,1.637776>, <-4.95,100,-4.95>, <-4.95,100,4.95>, <-4.687044,21,-3.649522>,
			<-4.687044,21,3.649522>, <-4.687044,21.228001,-3.649522>, <-4.687044,21.228001,3.649522>, <-4.687044,96.772003,-3.649522>,
			<-4.687044,96.772003,3.649522>, <-4.687044,97,-3.649522>, <-4.687044,97,3.649522>, <-4.5898,21.879,-2.65>,
			<-4.5898,21.879,2.65>, <-4.5898,96.121002,-2.65>, <-4.5898,96.121002,2.65>, <-4.33,24,-2.5>,
			<-4.33,24,2.5>, <-4.33,94,-2.5>, <-4.33,94,2.5>, <-4.25531,21,-4.199294>,
			<-4.25531,21,4.199294>, <-4.25531,21.879,-4.199294>, <-4.25531,21.879,4.199294>, <-4.25531,96.121002,-4.199294>,
			<-4.25531,96.121002,4.199294>, <-4.25531,97,-4.199294>, <-4.25531,97,4.199294>, <-3.966654,21,-4.567252>,
			<-3.966654,21,4.567252>, <-3.966654,22.851999,-4.567252>, <-3.966654,22.851999,4.567252>, <-3.966654,95.148003,-4.567252>,
			<-3.966654,95.148003,4.567252>, <-3.966654,97,-4.567252>, <-3.966654,97,4.567252>, <-3.95053,24,-3.567224>,
			<-3.95053,24,3.567224>, <-3.95053,94,-3.567224>, <-3.95053,94,3.567224>, <-3.865736,18,-4.696044>,
			<-3.866,18,4.696>, <-3.865736,21,-4.696044>, <-3.865736,21,4.696044>, <-3.865736,24,-4.696044>,
			<-3.865736,24,4.696044>, <-3.865736,94,-4.696044>, <-3.865736,94,4.696044>, <-3.865736,97,-4.696044>,
			<-3.865736,97,4.696044>, <-3.865736,100,-4.696044>, <-3.866,100,4.696>, <-3.701,124,-9.41>,
			<-3.70056,124,9.409933>, <-3.701,134,-9.41>, <-3.70056,134,9.409933>, <-3.444,102.5,-8.315>,
			<-3.444,102.5,8.315>, <-3.386,101.542999,-8.174>, <-3.386,101.542999,8.174>, <-3.386,103.457001,-8.174>,
			<-3.386,103.457001,8.174>, <-3.331,104,-8.042>, <-3.331,104,8.042>, <-3.22,100.732002,-7.774>,
			<-3.22,100.732002,7.774>, <-3.201,113,-8.544>, <-3.200604,113,8.543934>, <-3.201,145,-8.544>,
			<-3.200604,145,8.543934>, <-2.979,109,-8.159>, <-2.979,109,8.159>, <-2.979,149,-8.159>,
			<-2.979,149,8.159>, <-2.972,100.190002,-7.174>, <-2.972,100.190002,7.174>, <-2.895,107.5,-8.015>,
			<-2.895,107.5,8.015>, <-2.895,150.5,-8.015>, <-2.895,150.5,8.015>, <-2.701,104,-7.678>,
			<-2.700648,104,7.677934>, <-2.701,154,-7.678>, <-2.700648,154,7.677934>, <-2.679,100,-6.467>,
			<-2.679,100,6.467>, <-2.617,124,-7.996>, <-2.617,124,7.996>, <-2.617,134,-7.996>,
			<-2.617,134,7.996>, <-2.387,113,-8.66>, <-2.387,113,8.66>, <-2.387,145,-8.66>,
			<-2.387,145,8.66>, <-2.134,18,-5.696>, <-2.134,18,5.696>, <-2.134,21,-5.696>,
			<-2.134,21,5.696>, <-2.134,24,-5.696>, <-2.134,24,5.696>, <-2.134,94,-5.696>,
			<-2.134,94,5.696>, <-2.134,97,-5.696>, <-2.134,97,5.696>, <-2.134,100,-5.696>,
			<-2.134,100,5.696>, <-1.972,21,-5.719>, <-1.972,21,5.719>, <-1.972,22.851999,-5.719>,
			<-1.972,22.851999,5.719>, <-1.972,95.148003,-5.719>, <-1.972,95.148003,5.719>, <-1.972,97,-5.719>,
			<-1.972,97,5.719>, <-1.688,113,-8.13>, <-1.688,113,8.13>, <-1.688,145,-8.13>,
			<-1.688,145,8.13>, <-1.509,21,-5.785>, <-1.509,21,5.785>, <-1.509,21.879,-5.785>,
			<-1.509,21.879,5.785>, <-1.509,96.121002,-5.785>, <-1.509,96.121002,5.785>, <-1.509,97,-5.785>,
			<-1.509,97,5.785>, <-1.5,109,-8.443>, <-1.5,109,8.443>, <-1.5,149,-8.443>,
			<-1.5,149,8.443>, <-1.386,108.426003,-8.385>, <-1.386,108.426003,8.385>, <-1.386,149.574005,-8.385>,
			<-1.386,149.574005,8.385>, <-1.114,24,-5.205>, <-1.114,24,5.205>, <-1.114,94,-5.205>,
			<-1.114,94,5.205>, <-1.061,107.939003,-8.363>, <-1.061,107.939003,8.363>, <-1.061,109,-7.759>,
			<-1.061,109,7.759>, <-1.061,149,-7.759>, <-1.061,149,7.759>, <-1.061,150.061005,-8.363>,
			<-1.061,150.061005,8.363>, <-0.817,21,-5.884>, <-0.817,21,5.884>, <-0.817,21.228001,-5.884>,
			<-0.817,21.228001,5.884>, <-0.817,96.772003,-5.884>, <-0.817,96.772003,5.884>, <-0.817,97,-5.884>,
			<-0.817,97,5.884>, <-0.574,107.613998,-8.381>, <-0.574,107.613998,8.381>, <-0.574,150.386002,-8.381>,
			<-0.574,150.386002,8.381>, <0,18,-6>, <0,18,6>, <0,21,-6>,
			<0,21,6>, <0,21.879,-5.3>, <0,21.879,5.3>, <0,24,-5>,
			<0,24,5>, <0,94,-5>, <0,94,5>, <0,96.121002,-5.3>,
			<0,96.121002,5.3>, <0,97,-6>, <0,97,6>, <0,100,-7>,
			<0,100,-6>, <0,100,6>, <0,100,7>, <0,100.190002,-7.765>,
			<0,100.190002,7.765>, <0,100.732002,-8.414>, <0,100.732002,8.414>, <0,101.542999,-8.848>,
			<0,101.542999,8.848>, <0,102.5,-9>, <0,102.5,9>, <0,103.457001,-8.848>,
			<0,103.457001,8.848>, <0,104,-8.705>, <0,104,-8>, <0,104,8>,
			<0,104,8.705>, <0,107.5,-8.389>, <0,107.5,8.389>, <0,107.939003,-7.743>,
			<0,107.939003,7.743>, <0,109,-7.476>, <0,109,7.476>, <0,113,-7.91>,
			<0,113,7.91>, <0,124,-7.41>, <0,124,7.41>, <0,134,-7.41>,
			<0,134,7.41>, <0,145,-7.91>, <0,145,7.91>, <0,149,-7.476>,
			<0,149,7.476>, <0,150.061005,-7.743>, <0,150.061005,7.743>, <0,150.5,-8.389>,
			<0,150.5,8.389>, <0,154,-8>, <0,154,8>, <0.574,107.613998,-8.381>,
			<0.574,107.613998,8.381>, <0.574,150.386002,-8.381>, <0.574,150.386002,8.381>, <0.817,21,-5.884>,
			<0.817,21,5.884>, <0.817,21.228001,-5.884>, <0.817,21.228001,5.884>, <0.817,96.772003,-5.884>,
			<0.817,96.772003,5.884>, <0.817,97,-5.884>, <0.817,97,5.884>, <1.061,107.939003,-8.363>,
			<1.061,107.939003,8.363>, <1.061,109,-7.759>, <1.061,109,7.759>, <1.061,149,-7.759>,
			<1.061,149,7.759>, <1.061,150.061005,-8.363>, <1.061,150.061005,8.363>, <1.114,24,-5.205>,
			<1.114,24,5.205>, <1.114,94,-5.205>, <1.114,94,5.205>, <1.386,108.426003,-8.385>,
			<1.386,108.426003,8.385>, <1.386,149.574005,-8.385>, <1.386,149.574005,8.385>, <1.5,109,-8.443>,
			<1.5,109,8.443>, <1.5,149,-8.443>, <1.5,149,8.443>, <1.509,21,-5.785>,
			<1.509,21,5.785>, <1.509,21.879,-5.785>, <1.509,21.879,5.785>, <1.509,96.121002,-5.785>,
			<1.509,96.121002,5.785>, <1.509,97,-5.785>, <1.509,97,5.785>, <1.688,113,-8.13>,
			<1.688,113,8.13>, <1.688,145,-8.13>, <1.688,145,8.13>, <1.972,21,-5.719>,
			<1.972,21,5.719>, <1.972,22.851999,-5.719>, <1.972,22.851999,5.719>, <1.972,95.148003,-5.719>,
			<1.972,95.148003,5.719>, <1.972,97,-5.719>, <1.972,97,5.719>, <2.134,18,-5.696>,
			<2.134,18,5.696>, <2.134,21,-5.696>, <2.134,21,5.696>, <2.134,24,-5.696>,
			<2.134,24,5.696>, <2.134,94,-5.696>, <2.134,94,5.696>, <2.134,97,-5.696>,
			<2.134,97,5.696>, <2.134,100,-5.696>, <2.134,100,5.696>, <2.387,113,-8.66>,
			<2.387,113,8.66>, <2.387,145,-8.66>, <2.387,145,8.66>, <2.617,124,-7.996>,
			<2.617,124,7.996>, <2.617,134,-7.996>, <2.617,134,7.996>, <2.679,100,-6.467>,
			<2.679,100,6.467>, <2.700648,104,-7.677934>, <2.701,104,7.678>, <2.700648,154,-7.677934>,
			<2.701,154,7.678>, <2.895,107.5,-8.015>, <2.895,107.5,8.015>, <2.895,150.5,-8.015>,
			<2.895,150.5,8.015>, <2.972,100.190002,-7.174>, <2.972,100.190002,7.174>, <2.979,109,-8.159>,
			<2.979,109,8.159>, <2.979,149,-8.159>, <2.979,149,8.159>, <3.200604,113,-8.543934>,
			<3.201,113,8.544>, <3.200604,145,-8.543934>, <3.201,145,8.544>, <3.22,100.732002,-7.774>,
			<3.22,100.732002,7.774>, <3.331,104,-8.042>, <3.331,104,8.042>, <3.386,101.542999,-8.174>,
			<3.386,101.542999,8.174>, <3.386,103.457001,-8.174>, <3.386,103.457001,8.174>, <3.444,102.5,-8.315>,
			<3.444,102.5,8.315>, <3.70056,124,-9.409933>, <3.701,124,9.41>, <3.70056,134,-9.409933>,
			<3.701,134,9.41>, <3.865736,18,-4.696044>, <3.865736,18,4.696044>, <3.865736,21,-4.696044>,
			<3.865736,21,4.696044>, <3.865736,24,-4.696044>, <3.865736,24,4.696044>, <3.865736,94,-4.696044>,
			<3.865736,94,4.696044>, <3.865736,97,-4.696044>, <3.865736,97,4.696044>, <3.865736,100,-4.696044>,
			<3.865736,100,4.696044>, <3.95053,24,-3.567224>, <3.95053,24,3.567224>, <3.95053,94,-3.567224>,
			<3.95053,94,3.567224>, <3.966654,21,-4.567252>, <3.966654,21,4.567252>, <3.966654,22.851999,-4.567252>,
			<3.966654,22.851999,4.567252>, <3.966654,95.148003,-4.567252>, <3.966654,95.148003,4.567252>, <3.966654,97,-4.567252>,
			<3.966654,97,4.567252>, <4.25531,21,-4.199294>, <4.25531,21,4.199294>, <4.25531,21.879,-4.199294>,
			<4.25531,21.879,4.199294>, <4.25531,96.121002,-4.199294>, <4.25531,96.121002,4.199294>, <4.25531,97,-4.199294>,
			<4.25531,97,4.199294>, <4.33,24,-2.5>, <4.33,24,2.5>, <4.33,94,-2.5>,
			<4.33,94,2.5>, <4.5898,21.879,-2.65>, <4.5898,21.879,2.65>, <4.5898,96.121002,-2.65>,
			<4.5898,96.121002,2.65>, <4.687044,21,-3.649522>, <4.687044,21,3.649522>, <4.687044,21.228001,-3.649522>,
			<4.687044,21.228001,3.649522>, <4.687044,96.772003,-3.649522>, <4.687044,96.772003,3.649522>, <4.687044,97,-3.649522>,
			<4.687044,97,3.649522>, <4.95,100,-4.95>, <4.95,100,4.95>, <5.06453,24,-1.637776>,
			<5.06453,24,1.637776>, <5.06453,94,-1.637776>, <5.06453,94,1.637776>, <5.196,18,-3>,
			<5.196,18,3>, <5.196,21,-3>, <5.196,21,3>, <5.196,97,-3>,
			<5.196,97,3>, <5.196,100,-3>, <5.196,100,3>, <5.298648,104,-6.178066>,
			<5.299,104,6.178>, <5.298648,154,-6.178066>, <5.299,154,6.178>, <5.491,100.190002,-5.491>,
			<5.491,100.190002,5.491>, <5.49349,107.5,-6.51457>, <5.49349,107.5,6.51457>, <5.49349,150.5,-6.51457>,
			<5.49349,150.5,6.51457>, <5.504044,21,-2.234478>, <5.504044,21,2.234478>, <5.504044,21.228001,-2.234478>,
			<5.504044,21.228001,2.234478>, <5.504044,96.772003,-2.234478>, <5.504044,96.772003,2.234478>, <5.504044,97,-2.234478>,
			<5.504044,97,2.234478>, <5.576194,109,-6.659314>, <5.576194,109,6.659314>, <5.576194,149,-6.659314>,
			<5.576194,149,6.659314>, <5.616035,124,-6.264322>, <5.616035,124,6.264322>, <5.616035,134,-6.264322>,
			<5.616035,134,6.264322>, <5.76431,21,-1.585706>, <5.76431,21,1.585706>, <5.76431,21.879,-1.585706>,
			<5.76431,21.879,1.585706>, <5.76431,96.121002,-1.585706>, <5.76431,96.121002,1.585706>, <5.76431,97,-1.585706>,
			<5.76431,97,1.585706>, <5.798604,113,-7.044065>, <5.799,113,7.044>, <5.798604,145,-7.044065>,
			<5.799,145,7.044>, <5.938654,21,-1.151748>, <5.938654,21,1.151748>, <5.938654,22.851999,-1.151748>,
			<5.938654,22.851999,1.151748>, <5.938654,95.148003,-1.151748>, <5.938654,95.148003,1.151748>, <5.938654,97,-1.151748>,
			<5.938654,97,1.151748>, <5.95,100.732002,-5.95>, <5.95,100.732002,5.95>, <5.999736,18,-0.999956>,
			<5.999736,18,0.999956>, <5.999736,21,-0.999956>, <5.999736,21,0.999956>, <5.999736,24,-0.999956>,
			<5.999736,24,0.999956>, <5.999736,94,-0.999956>, <5.999736,94,0.999956>, <5.999736,97,-0.999956>,
			<5.999736,97,0.999956>, <5.999736,100,-0.999956>, <5.999736,100,0.999956>, <6.155,104,-6.155>,
			<6.155,104,6.155>, <6.188794,109,-4.798326>, <6.188794,109,4.798326>, <6.188794,149,-4.798326>,
			<6.188794,149,4.798326>, <6.19658,113,-5.526808>, <6.19658,113,5.526808>, <6.19658,145,-5.526808>,
			<6.19658,145,5.526808>, <6.256,101.542999,-6.256>, <6.256,101.542999,6.256>, <6.256,103.457001,-6.256>,
			<6.256,103.457001,6.256>, <6.29856,124,-7.910066>, <6.299,124,7.91>, <6.29856,134,-7.910066>,
			<6.299,134,7.91>, <6.30606,113,-6.397142>, <6.30606,113,6.397142>, <6.30606,145,-6.397142>,
			<6.30606,145,6.397142>, <6.364,102.5,-6.364>, <6.364,102.5,6.364>, <6.41706,124,-3.705>,
			<6.41706,124,3.705>, <6.41706,134,-3.705>, <6.41706,134,3.705>, <6.467,100,-2.679>,
			<6.467,100,2.679>, <6.474216,109,-3.738>, <6.474216,109,3.738>, <6.474216,149,-3.738>,
			<6.474216,149,3.738>, <6.561638,109,-5.5205>, <6.561638,109,5.5205>, <6.561638,149,-5.5205>,
			<6.561638,149,5.5205>, <6.56841,108.426003,-5.392776>, <6.56841,108.426003,5.392776>, <6.56841,149.574005,-5.392776>,
			<6.56841,149.574005,5.392776>, <6.705438,107.939003,-3.8715>, <6.705438,107.939003,3.8715>, <6.705438,150.061005,-3.8715>,
			<6.705438,150.061005,3.8715>, <6.711858,107.939003,-5.100326>, <6.711858,107.939003,5.100326>, <6.711858,150.061005,-5.100326>,
			<6.711858,150.061005,5.100326>, <6.85006,113,-3.955>, <6.85006,113,3.955>, <6.85006,145,-3.955>,
			<6.85006,145,3.955>, <6.928,104,-4>, <6.928,104,4>, <6.928,154,-4>,
			<6.928,154,4>, <6.970945,107.613998,-4.687584>, <6.970945,107.613998,4.687584>, <6.970945,150.386002,-4.687584>,
			<6.970945,150.386002,4.687584>, <7,100,0>, <7.174,100.190002,-2.972>, <7.174,100.190002,2.972>,
			<7.249794,109,-2.960674>, <7.249794,109,2.960674>, <7.249794,149,-2.960674>, <7.249794,149,2.960674>,
			<7.264874,107.5,-4.1945>, <7.264874,107.5,4.1945>, <7.264874,150.5,-4.1945>, <7.264874,150.5,4.1945>,
			<7.544946,107.613998,-3.693416>, <7.544946,107.613998,3.693416>, <7.544946,150.386002,-3.693416>, <7.544946,150.386002,3.693416>,
			<7.765,100.190002,0>, <7.772858,107.939003,-3.262674>, <7.772858,107.939003,3.262674>, <7.772858,150.061005,-3.262674>,
			<7.772858,150.061005,3.262674>, <7.774,100.732002,-3.22>, <7.774,100.732002,3.22>, <7.88458,113,-2.603192>,
			<7.88458,113,2.603192>, <7.88458,145,-2.603192>, <7.88458,145,2.603192>, <7.95441,108.426003,-2.992224>,
			<7.95441,108.426003,2.992224>, <7.95441,149.574005,-2.992224>, <7.95441,149.574005,2.992224>, <7.999648,104,-1.499934>,
			<7.999648,104,1.499934>, <7.999648,154,-1.499934>, <7.999648,154,1.499934>, <8,164,-8>,
			<8,164,8>, <8.042,104,-3.331>, <8.042,104,3.331>, <8.061638,109,-2.9225>,
			<8.061638,109,2.9225>, <8.061638,149,-2.9225>, <8.061638,149,2.9225>, <8.174,101.542999,-3.386>,
			<8.174,101.542999,3.386>, <8.174,103.457001,-3.386>, <8.174,103.457001,3.386>, <8.233036,124,-1.731678>,
			<8.233036,124,1.731678>, <8.233036,134,-1.731678>, <8.233036,134,1.731678>, <8.315,102.5,-3.444>,
			<8.315,102.5,3.444>, <8.388491,107.5,-1.50043>, <8.388491,107.5,1.50043>, <8.388491,150.5,-1.50043>,
			<8.388491,150.5,1.50043>, <8.414,100.732002,0>, <8.555195,109,-1.499686>, <8.555195,109,1.499686>,
			<8.555195,149,-1.499686>, <8.555195,149,1.499686>, <8.69306,113,-2.262858>, <8.69306,113,2.262858>,
			<8.69306,145,-2.262858>, <8.69306,145,2.262858>, <8.705,104,0>, <8.848,101.542999,0>,
			<8.848,103.457001,0>, <9,102.5,0>, <8.999603,113,-1.499934>, <8.999603,113,1.499934>,
			<8.999603,145,-1.499934>, <8.999603,145,1.499934>, <9.99956,124,-1.499934>, <9.99956,124,1.499934>,
			<9.99956,134,-1.499934>, <9.99956,134,1.499934>, <10,160,-10>, <10,160,10>,
			<12,160,-18>, <12,160,-12>, <12,160,12>, <12,160,18>,
			<12,162,-20>, <12,162,20>, <12,164,-16>, <12,164,-12>,
			<12,164,12>, <12,164,16>, <12,168,-20>, <12,168,-16>,
			<12,168,16>, <12,168,20>, <16,164,-12>, <16,164,12>,
			<16,168,-12>, <16,168,12>, <18,160,-12>, <18,160,12>,
			<20,162,-12>, <20,162,12>, <20,168,-12>, <20,168,12>
		}
		normal_vectors {
			908,
			<-1,0,0>, <-0.997628,-0.003542,-0.068742>, <-0.997628,-0.003542,0.068742>, <-0.997628,0.003542,-0.068742>,
			<-0.997628,0.003542,0.068742>, <-0.997191,0,-0.074906>, <-0.997191,0,0.074906>, <-0.996411,-0.039535,-0.074848>,
			<-0.996411,-0.039535,0.074848>, <-0.996411,0.039535,-0.074848>, <-0.996411,0.039535,0.074848>, <-0.993884,-0.110427,0>,
			<-0.993884,0.110427,0>, <-0.990266,-0.059197,-0.125969>, <-0.990266,-0.059197,0.12597>, <-0.990266,0.059197,-0.125969>,
			<-0.990266,0.059197,0.12597>, <-0.978548,-0.20602,-0.000039>, <-0.979177,-0.14099,-0.146064>, <-0.979177,-0.14099,0.146064>,
			<-0.979177,0.14099,-0.146064>, <-0.979177,0.14099,0.146064>, <-0.977804,-0.089128,0.189621>, <-0.977005,-0.098679,-0.18901>,
			<-0.977005,-0.098679,0.189009>, <-0.977005,0.098679,-0.18901>, <-0.977005,0.098679,0.189009>, <-0.974289,-0.196661,-0.109931>,
			<-0.974289,-0.196661,0.109931>, <-0.97429,0.19666,-0.109931>, <-0.97429,0.19666,0.109931>, <-0.972479,-0.103936,-0.208523>,
			<-0.972479,0.103936,-0.208523>, <-0.972479,0.103936,0.208523>, <-0.969049,-0.065705,-0.237963>, <-0.969049,-0.065705,0.237963>,
			<-0.969049,0.065705,-0.237963>, <-0.969049,0.065705,0.237963>, <-0.967028,-0.254668,0.000007>, <-0.9537,-0.030951,-0.299163>,
			<-0.9537,-0.030951,0.299163>, <-0.954114,-0.022161,-0.298622>, <-0.954114,-0.022161,0.298622>, <-0.954114,0.022161,-0.298622>,
			<-0.954114,0.022161,0.298622>, <-0.9537,0.030951,-0.299163>, <-0.9537,0.030951,0.299163>, <-0.952933,-0.02707,-0.301971>,
			<-0.952933,-0.02707,0.301971>, <-0.952933,0.027069,-0.301971>, <-0.952933,0.027069,0.301971>, <-0.944648,-0.022457,-0.327316>,
			<-0.944648,-0.022457,0.327316>, <-0.944648,0.022457,-0.327316>, <-0.944648,0.022457,0.327316>, <-0.93849,-0.277183,-0.205929>,
			<-0.93849,-0.277183,0.205929>, <-0.93849,0.277182,-0.205929>, <-0.93849,0.277182,0.205929>, <-0.935995,-0.109864,-0.334428>,
			<-0.935995,-0.109864,0.334428>, <-0.935995,0.109865,-0.334429>, <-0.935995,0.109865,0.334429>, <-0.935881,0.350515,0.035573>,
			<-0.934632,-0.100526,-0.341112>, <-0.934632,-0.100526,0.341112>, <-0.934632,0.100526,-0.341112>, <-0.934632,0.100526,0.341112>,
			<-0.929648,-0.093789,-0.356313>, <-0.929648,-0.093789,0.356313>, <-0.929648,0.093789,-0.356313>, <-0.929648,0.093789,0.356313>,
			<-0.927881,0,-0.372877>, <-0.927881,0,0.372877>, <-0.924819,-0.137734,-0.354598>, <-0.924819,-0.137734,0.354598>,
			<-0.924818,0.137735,-0.354599>, <-0.924818,0.137735,0.354599>, <-0.923076,-0.037141,-0.382819>, <-0.923076,-0.037141,0.382819>,
			<-0.923076,0.037141,-0.382819>, <-0.923076,0.037141,0.382819>, <-0.92007,-0.154632,-0.359944>, <-0.92007,-0.154632,0.359944>,
			<-0.920071,0.15463,-0.359944>, <-0.920071,0.15463,0.359944>, <-0.915867,-0.105877,-0.38727>, <-0.915867,-0.105877,0.38727>,
			<-0.915867,0.105877,-0.38727>, <-0.915867,0.105877,0.38727>, <-0.914289,-0.192964,-0.356147>, <-0.914289,-0.192965,0.356147>,
			<-0.914289,0.192964,-0.356148>, <-0.914289,0.192964,0.356148>, <-0.907558,-0.253551,-0.334741>, <-0.907558,-0.253551,0.334741>,
			<-0.907558,0.253549,-0.334739>, <-0.907558,0.253549,0.334739>, <-0.907462,-0.031875,-0.418923>, <-0.907473,0.031985,0.418891>,
			<-0.904002,-0.20618,-0.374527>, <-0.893391,-0.254668,-0.370129>, <-0.893382,-0.254668,0.370151>, <-0.890083,-0.196436,0.411298>,
			<-0.880593,-0.133662,-0.454633>, <-0.880593,-0.133662,0.454633>, <-0.880593,0.133662,-0.454633>, <-0.880593,0.133662,0.454633>,
			<-0.875661,0.318751,0.362789>, <-0.874255,0.31906,-0.365895>, <-0.872747,-0.336965,-0.353224>, <-0.872747,-0.336965,0.353224>,
			<-0.872748,0.336963,-0.353224>, <-0.872748,0.336963,0.353224>, <-0.868746,-0.490145,-0.070978>, <-0.868746,-0.490145,0.070978>,
			<-0.868745,0.490148,-0.070977>, <-0.868745,0.490148,0.070977>, <-0.865941,-0.013437,-0.499966>, <-0.865941,-0.013437,0.499966>,
			<-0.866019,0,-0.500011>, <-0.866019,0,0.500011>, <-0.865941,0.013437,-0.499966>, <-0.865941,0.013437,0.499966>,
			<-0.863882,-0.070207,-0.498777>, <-0.863882,-0.070207,0.498777>, <-0.863882,0.070207,-0.498777>, <-0.863882,0.070207,0.498777>,
			<-0.86072,-0.11046,-0.496951>, <-0.86072,-0.11046,0.496951>, <-0.86072,0.11046,-0.496951>, <-0.86072,0.11046,0.496951>,
			<-0.840003,-0.243266,-0.48499>, <-0.840003,-0.243266,0.48499>, <-0.840003,0.243266,-0.48499>, <-0.840003,0.243266,0.484991>,
			<-0.834026,-0.133665,-0.535289>, <-0.834026,-0.133665,0.535289>, <-0.834026,0.133664,-0.535289>, <-0.834026,0.133664,0.535289>,
			<-0.827136,-0.552844,-0.101038>, <-0.827136,-0.552844,0.101038>, <-0.827135,0.552847,-0.101037>, <-0.827135,0.552847,0.101037>,
			<-0.806838,-0.363322,-0.465842>, <-0.806838,-0.363322,0.465842>, <-0.806838,0.363322,-0.465842>, <-0.806838,0.363322,0.465842>,
			<-0.805255,-0.529613,-0.266599>, <-0.805255,-0.529613,0.266599>, <-0.805254,0.529613,-0.2666>, <-0.805254,0.529613,0.2666>,
			<-0.793304,-0.105877,-0.59955>, <-0.793304,-0.105877,0.59955>, <-0.793077,-0.037141,-0.607988>, <-0.793077,-0.037141,0.607988>,
			<-0.793077,0.037141,-0.607988>, <-0.793077,0.037141,0.607988>, <-0.793304,0.105877,-0.59955>, <-0.793304,0.105877,0.59955>,
			<-0.786846,0,-0.61715>, <-0.786846,0,0.61715>, <-0.775186,0.631682,-0.007994>, <-0.773384,-0.093789,-0.626962>,
			<-0.773384,-0.093789,0.626962>, <-0.773384,0.093789,-0.626962>, <-0.773384,0.093789,0.626962>, <-0.77174,-0.154632,-0.616852>,
			<-0.77174,-0.154633,0.616852>, <-0.77174,0.154631,-0.616852>, <-0.77174,0.154631,0.616852>, <-0.769484,-0.137734,-0.623637>,
			<-0.769484,-0.137734,0.623637>, <-0.769485,0.137735,-0.623636>, <-0.769485,0.137735,0.623636>, <-0.765561,-0.192965,-0.613743>,
			<-0.765561,-0.192965,0.613743>, <-0.765562,0.192964,-0.613743>, <-0.765562,0.192964,0.613743>, <-0.762711,-0.100526,-0.638879>,
			<-0.762711,-0.100526,0.638879>, <-0.762711,0.100526,-0.638879>, <-0.762711,0.100526,0.638879>, <-0.757605,-0.109864,-0.643401>,
			<-0.757605,-0.109864,0.643401>, <-0.757605,0.109865,-0.643401>, <-0.757605,0.109865,0.643401>, <-0.755771,-0.022457,-0.654451>,
			<-0.755771,-0.022457,0.654451>, <-0.755771,0.022457,-0.654451>, <-0.755771,0.022457,0.654451>, <-0.751576,0.600611,0.272764>,
			<-0.743679,-0.253555,-0.618587>, <-0.743679,-0.253555,0.618587>, <-0.743679,0.253554,-0.618589>, <-0.743679,0.253554,0.618589>,
			<-0.74226,-0.336965,-0.579228>, <-0.74226,-0.336965,0.579228>, <-0.74226,0.336964,-0.579229>, <-0.74226,0.336964,0.579229>,
			<-0.737964,-0.02707,-0.674297>, <-0.737964,-0.02707,0.674297>, <-0.737964,0.027069,-0.674297>, <-0.737964,0.027069,0.674297>,
			<-0.735941,-0.030952,-0.676338>, <-0.735941,-0.030952,0.676338>, <-0.735654,-0.022161,-0.676995>, <-0.735654,-0.022161,0.676995>,
			<-0.735654,0.022161,-0.676995>, <-0.735654,0.022161,0.676995>, <-0.735941,0.030952,-0.676338>, <-0.735941,0.030952,0.676338>,
			<-0.720563,-0.19642,-0.664987>, <-0.707107,0,-0.707107>, <-0.707107,0,0.707107>, <-0.704928,0.286645,0.648776>,
			<-0.702908,0.660901,-0.262927>, <-0.690615,-0.065706,-0.720231>, <-0.690615,-0.065706,0.720231>, <-0.690615,0.065706,-0.720231>,
			<-0.690615,0.065706,0.720231>, <-0.683822,-0.254395,-0.683865>, <-0.683865,-0.254395,0.683822>, <-0.677946,-0.731692,-0.070831>,
			<-0.677946,-0.731692,0.070831>, <-0.677939,0.731698,-0.070828>, <-0.677939,0.731698,0.070828>, <-0.677454,-0.622949,-0.39114>,
			<-0.677454,-0.622949,0.39114>, <-0.677454,0.62295,-0.39114>, <-0.677454,0.622949,0.39114>, <-0.666807,-0.103936,0.737947>,
			<-0.666807,0.103936,-0.737947>, <-0.666807,0.103936,0.737947>, <-0.664987,-0.19642,0.720563>, <-0.6531,-0.089128,-0.752009>,
			<-0.65217,-0.098679,0.751623>, <-0.652184,0.098679,-0.75161>, <-0.65217,0.098679,0.751623>, <-0.648776,0.286645,-0.704928>,
			<-0.647566,-0.277183,-0.709808>, <-0.647566,-0.277183,0.709808>, <-0.647567,0.277182,-0.709808>, <-0.647567,0.277182,0.709808>,
			<-0.64036,0.766903,-0.042418>, <-0.633495,-0.529613,-0.564088>, <-0.633494,-0.529613,0.564088>, <-0.633495,0.529613,-0.564087>,
			<-0.633495,0.529613,0.564087>, <-0.622505,-0.10136,-0.776024>, <-0.616064,-0.14099,-0.774975>, <-0.616064,-0.14099,0.774975>,
			<-0.616064,0.14099,-0.774975>, <-0.616064,0.14099,0.774975>, <-0.607851,0.766926,0.20577>, <-0.604226,-0.059197,-0.794611>,
			<-0.604206,-0.059197,0.794626>, <-0.604206,0.059197,0.794626>, <-0.592086,0.767656,-0.245231>, <-0.582357,-0.196665,-0.788786>,
			<-0.582357,-0.196665,0.788786>, <-0.582357,0.196664,-0.788786>, <-0.582357,0.196664,0.788786>, <-0.578904,0.044289,-0.814192>,
			<-0.563005,-0.039536,-0.825508>, <-0.563005,-0.039536,0.825508>, <-0.563005,0.039535,-0.825508>, <-0.563005,0.039535,0.825508>,
			<-0.558325,-0.003542,-0.829614>, <-0.558325,-0.003542,0.829614>, <-0.558325,0.003542,-0.829614>, <-0.558325,0.003542,0.829614>,
			<-0.548312,0.631445,-0.548298>, <-0.548298,0.631445,0.548312>, <-0.501052,-0.552845,-0.665815>, <-0.501052,-0.552845,0.665815>,
			<-0.50105,0.552848,-0.665814>, <-0.501051,0.552848,0.665814>, <-0.499978,0,-0.866038>, <-0.500011,0,0.866019>,
			<-0.496953,-0.110429,-0.860722>, <-0.49692,-0.110427,0.860742>, <-0.496953,0.110429,-0.860723>, <-0.496921,0.110427,0.860742>,
			<-0.495848,-0.490154,-0.716857>, <-0.495848,-0.490154,0.716857>, <-0.495847,0.490156,-0.716856>, <-0.495847,0.490156,0.716856>,
			<-0.486768,-0.827086,-0.281044>, <-0.486768,-0.827086,0.281044>, <-0.486763,0.82709,-0.281041>, <-0.486763,0.82709,0.281041>,
			<-0.453205,0.767602,-0.453202>, <-0.453202,0.767602,0.453205>, <-0.439293,-0.003542,-0.898337>, <-0.439293,-0.003542,0.898337>,
			<-0.439293,0.003542,-0.898337>, <-0.439293,0.003542,0.898337>, <-0.433397,-0.039536,-0.900336>, <-0.433397,-0.039536,0.900335>,
			<-0.433397,0.039536,-0.900336>, <-0.433397,0.039536,0.900336>, <-0.418923,-0.031875,0.907462>, <-0.418891,0.031985,-0.907473>,
			<-0.415648,0.044289,0.908447>, <-0.411298,-0.196436,-0.890083>, <-0.4003,-0.731692,-0.551713>, <-0.4003,-0.731692,0.551713>,
			<-0.400294,0.731698,-0.551708>, <-0.400294,0.731698,0.551708>, <-0.391919,-0.196661,-0.898735>, <-0.391919,-0.196661,0.898735>,
			<-0.391919,0.19666,-0.898735>, <-0.391919,0.19666,0.898735>, <-0.386052,-0.059198,-0.920576>, <-0.386028,-0.059197,0.920586>,
			<-0.386052,0.059198,-0.920576>, <-0.374527,-0.20618,0.904002>, <-0.372884,-0.490146,-0.787854>, <-0.372884,-0.490146,0.787854>,
			<-0.372884,0.490148,-0.787853>, <-0.372884,0.490148,0.787853>, <-0.370151,-0.254668,-0.893382>, <-0.370129,-0.254668,0.893391>,
			<-0.365895,0.31906,0.874255>, <-0.363105,-0.140993,-0.921019>, <-0.363105,-0.140993,0.921019>, <-0.363104,0.140993,-0.921019>,
			<-0.363104,0.140993,0.921019>, <-0.362789,0.318751,-0.875661>, <-0.360792,-0.10136,0.927122>, <-0.326075,-0.552852,-0.766831>,
			<-0.326075,-0.552852,0.766831>, <-0.326075,0.552855,-0.766829>, <-0.326075,0.552855,0.766829>, <-0.324827,-0.098681,-0.940611>,
			<-0.324697,-0.08913,0.941609>, <-0.324827,0.098681,-0.940611>, <-0.324809,0.098679,0.940617>, <-0.305666,-0.103938,-0.946449>,
			<-0.305666,0.103938,-0.946449>, <-0.305666,0.103938,0.946449>, <-0.290917,-0.277188,-0.915715>, <-0.290917,-0.277188,0.915715>,
			<-0.290917,0.277188,-0.915715>, <-0.290917,0.277188,0.915715>, <-0.277637,-0.731699,-0.622523>, <-0.277637,-0.731699,0.622523>,
			<-0.278419,-0.065705,-0.95821>, <-0.278419,-0.065705,0.95821>, <-0.278419,0.065705,-0.95821>, <-0.278419,0.065705,0.95821>,
			<-0.277635,0.731705,-0.622516>, <-0.277635,0.731705,0.622516>, <-0.272764,0.600611,-0.751576>, <-0.262927,0.660901,0.702908>,
			<-0.245231,0.767656,0.592086>, <-0.241046,0.970514,0.000012>, <-0.222613,0.970536,-0.092208>, <-0.222622,0.970537,0.092186>,
			<-0.217743,-0.030951,-0.975515>, <-0.217743,-0.030951,0.975515>, <-0.218456,-0.022162,-0.975595>, <-0.218456,-0.022162,0.975595>,
			<-0.218456,0.022162,-0.975595>, <-0.218456,0.022162,0.975595>, <-0.217743,0.030951,-0.975515>, <-0.217743,0.030951,0.975515>,
			<-0.214965,-0.027071,-0.976247>, <-0.214965,-0.027071,0.976247>, <-0.214965,0.02707,-0.976247>, <-0.214965,0.02707,0.976247>,
			<-0.20577,0.766926,-0.607851>, <-0.188873,-0.022458,-0.981745>, <-0.188873,-0.022458,0.981745>, <-0.188873,0.022458,-0.981745>,
			<-0.188873,0.022458,0.981745>, <-0.178387,-0.109867,-0.977808>, <-0.178387,-0.109867,0.977808>, <-0.178386,0.109867,-0.977808>,
			<-0.178386,0.109867,0.977808>, <-0.171756,-0.529621,-0.830663>, <-0.171756,-0.529621,0.830663>, <-0.171917,-0.100529,-0.979969>,
			<-0.171917,-0.100529,0.979969>, <-0.171917,0.100529,-0.979969>, <-0.171917,0.100529,0.979969>, <-0.171754,0.529621,-0.830664>,
			<-0.171754,0.529621,0.830664>, <-0.170434,0.97052,-0.170418>, <-0.170418,0.97052,0.170434>, <-0.163861,-0.25355,-0.953342>,
			<-0.163861,-0.25355,0.953342>, <-0.163862,0.253549,-0.953343>, <-0.163862,0.253549,0.953343>, <-0.15626,-0.093791,-0.983253>,
			<-0.15626,-0.093791,0.983253>, <-0.15626,0.093791,-0.983253>, <-0.15626,0.093791,0.983253>, <-0.155331,-0.137737,-0.978213>,
			<-0.155331,-0.137737,0.978213>, <-0.15533,0.137738,-0.978213>, <-0.15533,0.137738,0.978213>, <-0.148724,-0.192968,-0.969868>,
			<-0.148724,-0.192968,0.969868>, <-0.148724,0.192968,-0.969868>, <-0.148724,0.192968,0.969868>, <-0.148327,-0.154636,-0.976774>,
			<-0.148327,-0.154636,0.976774>, <-0.148327,0.154634,-0.976774>, <-0.148327,0.154634,0.976774>, <-0.141032,0,-0.990005>,
			<-0.141032,0,0.990005>, <-0.130484,-0.336972,-0.932429>, <-0.130484,-0.336972,0.932429>, <-0.129982,-0.03714,-0.99082>,
			<-0.129982,-0.03714,0.99082>, <-0.129982,0.03714,-0.99082>, <-0.129982,0.03714,0.99082>, <-0.130484,0.33697,-0.93243>,
			<-0.130484,0.33697,0.93243>, <-0.122561,-0.105879,-0.986797>, <-0.122561,-0.105879,0.986797>, <-0.122561,0.105879,-0.986797>,
			<-0.122561,0.105879,0.986797>, <-0.092186,0.970537,-0.222622>, <-0.092208,0.970536,0.222613>, <-0.046548,-0.133662,-0.989933>,
			<-0.046548,-0.133662,0.989933>, <-0.046548,0.133661,-0.989933>, <-0.046548,0.133661,0.989933>, <-0.042418,0.766903,0.64036>,
			<-0.035573,0.350515,-0.935881>, <-0.007994,0.631682,0.775186>, <0,-1,0>, <0,-0.827091,-0.562068>,
			<0,-0.827091,0.562068>, <0,-0.622957,-0.782256>, <0,-0.622957,0.782256>, <0,-0.363329,-0.931661>,
			<0,-0.363329,0.931661>, <-0.000007,-0.254668,-0.967028>, <0.000007,-0.254668,0.967028>, <0,-0.243271,-0.969958>,
			<0,-0.243271,0.969958>, <0.000039,-0.20602,-0.978548>, <-0.000039,-0.20602,0.978548>, <0,-0.110463,-0.99388>,
			<0,-0.110463,0.99388>, <0,-0.070209,-0.997532>, <0,-0.070209,0.997532>, <0,-0.013437,-0.99991>,
			<0,-0.013437,0.99991>, <-0.000042,-0.000138,-1>, <0,0,-1>, <0.000042,-0.000138,1>,
			<0,0,1>, <0,0.013437,-0.99991>, <0,0.013437,0.99991>, <0,0.070209,-0.997532>,
			<0,0.070209,0.997532>, <0,0.110463,-0.99388>, <0,0.110463,0.99388>, <0,0.243271,-0.969958>,
			<0,0.243271,0.969958>, <0,0.363328,-0.931661>, <0,0.363328,0.931661>, <0,0.622958,-0.782255>,
			<0,0.622958,0.782255>, <0,0.827096,-0.562061>, <0,0.827096,0.562061>, <-0.000009,0.970525,-0.241002>,
			<0.000012,0.970514,0.241046>, <0,1,0>, <0.007994,0.631682,-0.775186>, <0.035573,0.350515,0.935881>,
			<0.042418,0.766903,-0.64036>, <0.046548,-0.133662,-0.989933>, <0.046548,-0.133662,0.989933>, <0.046548,0.133661,-0.989933>,
			<0.046548,0.133661,0.989933>, <0.092208,0.970536,-0.222613>, <0.092186,0.970537,0.222622>, <0.122561,-0.105879,-0.986797>,
			<0.122561,-0.105879,0.986797>, <0.122561,0.105879,-0.986797>, <0.122561,0.105879,0.986797>, <0.130484,-0.336972,-0.932429>,
			<0.130484,-0.336972,0.932429>, <0.129982,-0.03714,-0.99082>, <0.129982,-0.03714,0.99082>, <0.129982,0.03714,-0.99082>,
			<0.129982,0.03714,0.99082>, <0.130484,0.33697,-0.93243>, <0.130484,0.33697,0.93243>, <0.141032,0,-0.990005>,
			<0.141032,0,0.990005>, <0.148327,-0.154636,-0.976774>, <0.148327,-0.154636,0.976774>, <0.148327,0.154634,-0.976774>,
			<0.148327,0.154634,0.976774>, <0.148724,-0.192968,-0.969868>, <0.148724,-0.192968,0.969868>, <0.148724,0.192968,-0.969868>,
			<0.148724,0.192968,0.969868>, <0.155331,-0.137737,-0.978213>, <0.155331,-0.137737,0.978213>, <0.15533,0.137738,-0.978213>,
			<0.15533,0.137738,0.978213>, <0.15626,-0.093791,-0.983253>, <0.15626,-0.093791,0.983253>, <0.15626,0.093791,-0.983253>,
			<0.15626,0.093791,0.983253>, <0.163861,-0.25355,-0.953342>, <0.163861,-0.25355,0.953342>, <0.163862,0.253549,-0.953343>,
			<0.163862,0.253549,0.953343>, <0.170418,0.97052,-0.170434>, <0.170434,0.97052,0.170418>, <0.171756,-0.529621,-0.830663>,
			<0.171756,-0.529621,0.830663>, <0.171917,-0.100529,-0.979969>, <0.171917,-0.100529,0.979969>, <0.171917,0.100529,-0.979969>,
			<0.171917,0.100529,0.979969>, <0.171754,0.529621,-0.830664>, <0.171754,0.529621,0.830664>, <0.178387,-0.109867,-0.977808>,
			<0.178387,-0.109867,0.977808>, <0.178386,0.109867,-0.977808>, <0.178386,0.109867,0.977808>, <0.188873,-0.022458,-0.981745>,
			<0.188873,-0.022458,0.981745>, <0.188873,0.022458,-0.981745>, <0.188873,0.022458,0.981745>, <0.20577,0.766926,0.607851>,
			<0.214965,-0.027071,-0.976247>, <0.214965,-0.027071,0.976247>, <0.214965,0.02707,-0.976247>, <0.214965,0.02707,0.976247>,
			<0.217743,-0.030951,-0.975515>, <0.217743,-0.030951,0.975515>, <0.218456,-0.022162,-0.975595>, <0.218456,-0.022162,0.975595>,
			<0.218456,0.022162,-0.975595>, <0.218456,0.022162,0.975595>, <0.217743,0.030951,-0.975515>, <0.217743,0.030951,0.975515>,
			<0.222622,0.970537,-0.092186>, <0.222613,0.970536,0.092208>, <0.241046,0.970514,-0.000012>, <0.245231,0.767656,-0.592086>,
			<0.262927,0.660901,-0.702908>, <0.272764,0.600611,0.751576>, <0.277637,-0.731699,-0.622523>, <0.277637,-0.731699,0.622523>,
			<0.278419,-0.065705,-0.95821>, <0.278419,-0.065705,0.95821>, <0.278419,0.065705,-0.95821>, <0.278419,0.065705,0.95821>,
			<0.277635,0.731705,-0.622516>, <0.277635,0.731705,0.622516>, <0.290917,-0.277188,-0.915715>, <0.290917,-0.277188,0.915715>,
			<0.290917,0.277188,-0.915715>, <0.290917,0.277188,0.915715>, <0.305666,-0.103938,0.946449>, <0.305666,0.103938,-0.946449>,
			<0.305666,0.103938,0.946449>, <0.324827,-0.098681,0.940611>, <0.324697,-0.08913,-0.941609>, <0.324809,0.098679,-0.940617>,
			<0.324827,0.098681,0.940611>, <0.326075,-0.552852,-0.766831>, <0.326075,-0.552852,0.766831>, <0.326075,0.552855,-0.766829>,
			<0.326075,0.552855,0.766829>, <0.360792,-0.10136,-0.927122>, <0.363105,-0.140993,-0.921019>, <0.363105,-0.140993,0.921019>,
			<0.363104,0.140993,-0.921019>, <0.363104,0.140993,0.921019>, <0.362789,0.318751,0.875661>, <0.365895,0.31906,-0.874255>,
			<0.370129,-0.254668,-0.893391>, <0.370151,-0.254668,0.893382>, <0.372884,-0.490146,-0.787854>, <0.372884,-0.490146,0.787854>,
			<0.372884,0.490148,-0.787853>, <0.372884,0.490148,0.787853>, <0.374527,-0.20618,-0.904002>, <0.386028,-0.059197,-0.920586>,
			<0.386052,-0.059198,0.920576>, <0.386052,0.059198,0.920576>, <0.391919,-0.196661,-0.898735>, <0.391919,-0.196661,0.898735>,
			<0.391919,0.19666,-0.898735>, <0.391919,0.19666,0.898735>, <0.4003,-0.731692,-0.551713>, <0.4003,-0.731692,0.551713>,
			<0.400294,0.731698,-0.551708>, <0.400294,0.731698,0.551708>, <0.411298,-0.196436,0.890083>, <0.415648,0.044289,-0.908447>,
			<0.418923,-0.031875,-0.907462>, <0.418891,0.031985,0.907473>, <0.433397,-0.039536,-0.900335>, <0.433397,-0.039536,0.900336>,
			<0.433397,0.039536,-0.900336>, <0.433397,0.039536,0.900336>, <0.439293,-0.003542,-0.898337>, <0.439293,-0.003542,0.898337>,
			<0.439293,0.003542,-0.898337>, <0.439293,0.003542,0.898337>, <0.453202,0.767602,-0.453205>, <0.453205,0.767602,0.453202>,
			<0.486768,-0.827086,-0.281044>, <0.486768,-0.827086,0.281044>, <0.486763,0.82709,-0.281041>, <0.486763,0.82709,0.281041>,
			<0.495848,-0.490154,-0.716857>, <0.495848,-0.490154,0.716857>, <0.495847,0.490156,-0.716856>, <0.495847,0.490156,0.716856>,
			<0.49692,-0.110427,-0.860742>, <0.496953,-0.110429,0.860722>, <0.496921,0.110427,-0.860742>, <0.496953,0.110429,0.860723>,
			<0.500011,0,-0.866019>, <0.499978,0,0.866038>, <0.501052,-0.552845,-0.665815>, <0.501052,-0.552845,0.665815>,
			<0.501051,0.552848,-0.665814>, <0.50105,0.552848,0.665814>, <0.548298,0.631445,-0.548312>, <0.548312,0.631445,0.548298>,
			<0.558325,-0.003542,-0.829614>, <0.558325,-0.003542,0.829614>, <0.558325,0.003542,-0.829614>, <0.558325,0.003542,0.829614>,
			<0.563005,-0.039536,-0.825508>, <0.563005,-0.039536,0.825508>, <0.563005,0.039535,-0.825508>, <0.563005,0.039535,0.825508>,
			<0.578904,0.044289,0.814192>, <0.582357,-0.196665,-0.788786>, <0.582357,-0.196665,0.788786>, <0.582357,0.196664,-0.788786>,
			<0.582357,0.196664,0.788786>, <0.592086,0.767656,0.245231>, <0.604206,-0.059197,-0.794626>, <0.604226,-0.059197,0.794611>,
			<0.604206,0.059197,-0.794626>, <0.607851,0.766926,-0.20577>, <0.616064,-0.14099,-0.774975>, <0.616064,-0.14099,0.774975>,
			<0.616064,0.14099,-0.774975>, <0.616064,0.14099,0.774975>, <0.622505,-0.10136,0.776024>, <0.633494,-0.529613,-0.564088>,
			<0.633495,-0.529613,0.564088>, <0.633495,0.529613,-0.564087>, <0.633495,0.529613,0.564087>, <0.64036,0.766903,0.042418>,
			<0.647566,-0.277183,-0.709808>, <0.647566,-0.277183,0.709808>, <0.647567,0.277182,-0.709808>, <0.647567,0.277182,0.709808>,
			<0.648776,0.286645,0.704928>, <0.65217,-0.098679,-0.751623>, <0.65217,0.098679,-0.751623>, <0.652184,0.098679,0.75161>,
			<0.6531,-0.089128,0.752009>, <0.664987,-0.19642,-0.720563>, <0.666807,-0.103936,-0.737947>, <0.666807,0.103936,-0.737947>,
			<0.666807,0.103936,0.737947>, <0.677454,-0.622949,-0.39114>, <0.677454,-0.622949,0.39114>, <0.677454,0.622949,-0.39114>,
			<0.677454,0.62295,0.39114>, <0.677946,-0.731692,-0.070831>, <0.677946,-0.731692,0.070831>, <0.677939,0.731698,-0.070828>,
			<0.677939,0.731698,0.070828>, <0.683865,-0.254395,-0.683822>, <0.683822,-0.254395,0.683865>, <0.690615,-0.065706,-0.720231>,
			<0.690615,-0.065706,0.720231>, <0.690615,0.065706,-0.720231>, <0.690615,0.065706,0.720231>, <0.702908,0.660901,0.262927>,
			<0.704928,0.286645,-0.648776>, <0.707107,0,-0.707107>, <0.707107,0,0.707107>, <0.720563,-0.19642,0.664987>,
			<0.735941,-0.030952,-0.676338>, <0.735941,-0.030952,0.676338>, <0.735654,-0.022161,-0.676995>, <0.735654,-0.022161,0.676995>,
			<0.735654,0.022161,-0.676995>, <0.735654,0.022161,0.676995>, <0.735941,0.030952,-0.676338>, <0.735941,0.030952,0.676338>,
			<0.737964,-0.02707,-0.674297>, <0.737964,-0.02707,0.674297>, <0.737964,0.027069,-0.674297>, <0.737964,0.027069,0.674297>,
			<0.74226,-0.336965,-0.579228>, <0.74226,-0.336965,0.579228>, <0.74226,0.336964,-0.579229>, <0.74226,0.336964,0.579229>,
			<0.743679,-0.253555,-0.618587>, <0.743679,-0.253555,0.618587>, <0.743679,0.253554,-0.618589>, <0.743679,0.253554,0.618589>,
			<0.751576,0.600611,-0.272764>, <0.755771,-0.022457,-0.654451>, <0.755771,-0.022457,0.654451>, <0.755771,0.022457,-0.654451>,
			<0.755771,0.022457,0.654451>, <0.757605,-0.109864,-0.643401>, <0.757605,-0.109864,0.643401>, <0.757605,0.109865,-0.643401>,
			<0.757605,0.109865,0.643401>, <0.762711,-0.100526,-0.638879>, <0.762711,-0.100526,0.638879>, <0.762711,0.100526,-0.638879>,
			<0.762711,0.100526,0.638879>, <0.765561,-0.192965,-0.613743>, <0.765561,-0.192965,0.613743>, <0.765562,0.192964,-0.613743>,
			<0.765562,0.192964,0.613743>, <0.769484,-0.137734,-0.623637>, <0.769484,-0.137734,0.623637>, <0.769485,0.137735,-0.623636>,
			<0.769485,0.137735,0.623636>, <0.77174,-0.154633,-0.616852>, <0.77174,-0.154632,0.616852>, <0.77174,0.154631,-0.616852>,
			<0.77174,0.154631,0.616852>, <0.773384,-0.093789,-0.626962>, <0.773384,-0.093789,0.626962>, <0.773384,0.093789,-0.626962>,
			<0.773384,0.093789,0.626962>, <0.775186,0.631682,0.007994>, <0.786846,0,-0.61715>, <0.786846,0,0.61715>,
			<0.793304,-0.105877,-0.59955>, <0.793304,-0.105877,0.59955>, <0.793077,-0.037141,-0.607988>, <0.793077,-0.037141,0.607988>,
			<0.793077,0.037141,-0.607988>, <0.793077,0.037141,0.607988>, <0.793304,0.105877,-0.59955>, <0.793304,0.105877,0.59955>,
			<0.805255,-0.529613,-0.266599>, <0.805255,-0.529613,0.266599>, <0.805254,0.529613,-0.2666>, <0.805254,0.529613,0.2666>,
			<0.806838,-0.363322,-0.465842>, <0.806838,-0.363322,0.465842>, <0.806838,0.363322,-0.465842>, <0.806838,0.363322,0.465842>,
			<0.827136,-0.552844,-0.101038>, <0.827136,-0.552844,0.101038>, <0.827135,0.552847,-0.101037>, <0.827135,0.552847,0.101037>,
			<0.834026,-0.133665,-0.535289>, <0.834026,-0.133665,0.535289>, <0.834026,0.133664,-0.535289>, <0.834026,0.133664,0.535289>,
			<0.840003,-0.243266,-0.48499>, <0.840003,-0.243266,0.48499>, <0.840003,0.243266,-0.484991>, <0.840003,0.243266,0.48499>,
			<0.86072,-0.11046,-0.496951>, <0.86072,-0.11046,0.496951>, <0.86072,0.11046,-0.496951>, <0.86072,0.11046,0.496951>,
			<0.863882,-0.070207,-0.498777>, <0.863882,-0.070207,0.498777>, <0.863882,0.070207,-0.498777>, <0.863882,0.070207,0.498777>,
			<0.865941,-0.013437,-0.499966>, <0.865941,-0.013437,0.499966>, <0.866019,0,-0.500011>, <0.866019,0,0.500011>,
			<0.865941,0.013437,-0.499966>, <0.865941,0.013437,0.499966>, <0.868746,-0.490145,-0.070978>, <0.868746,-0.490145,0.070978>,
			<0.868745,0.490148,-0.070977>, <0.868745,0.490148,0.070977>, <0.872747,-0.336965,-0.353224>, <0.872747,-0.336965,0.353224>,
			<0.872748,0.336963,-0.353224>, <0.872748,0.336963,0.353224>, <0.874255,0.31906,0.365895>, <0.875661,0.318751,-0.362789>,
			<0.880593,-0.133662,-0.454633>, <0.880593,-0.133662,0.454633>, <0.880593,0.133662,-0.454633>, <0.880593,0.133662,0.454633>,
			<0.890083,-0.196436,-0.411298>, <0.893382,-0.254668,-0.370151>, <0.893391,-0.254668,0.370129>, <0.904002,-0.20618,0.374527>,
			<0.907462,-0.031875,0.418923>, <0.907473,0.031985,-0.418891>, <0.907558,-0.253551,-0.334741>, <0.907558,-0.253551,0.334741>,
			<0.907558,0.253549,-0.334739>, <0.907558,0.253549,0.334739>, <0.914289,-0.192965,-0.356147>, <0.914289,-0.192964,0.356147>,
			<0.914289,0.192964,-0.356148>, <0.914289,0.192964,0.356148>, <0.915867,-0.105877,-0.38727>, <0.915867,-0.105877,0.38727>,
			<0.915867,0.105877,-0.38727>, <0.915867,0.105877,0.38727>, <0.92007,-0.154632,-0.359944>, <0.92007,-0.154632,0.359944>,
			<0.920071,0.15463,-0.359944>, <0.920071,0.15463,0.359944>, <0.923076,-0.037141,-0.382819>, <0.923076,-0.037141,0.382819>,
			<0.923076,0.037141,-0.382819>, <0.923076,0.037141,0.382819>, <0.924819,-0.137734,-0.354598>, <0.924819,-0.137734,0.354598>,
			<0.924818,0.137735,-0.354599>, <0.924818,0.137735,0.354599>, <0.927881,0,-0.372877>, <0.927881,0,0.372877>,
			<0.929648,-0.093789,-0.356313>, <0.929648,-0.093789,0.356313>, <0.929648,0.093789,-0.356313>, <0.929648,0.093789,0.356313>,
			<0.934632,-0.100526,-0.341112>, <0.934632,-0.100526,0.341112>, <0.934632,0.100526,-0.341112>, <0.934632,0.100526,0.341112>,
			<0.935995,-0.109864,-0.334428>, <0.935995,-0.109864,0.334428>, <0.935995,0.109865,-0.334429>, <0.935995,0.109865,0.334429>,
			<0.935881,0.350515,-0.035573>, <0.93849,-0.277183,-0.205929>, <0.93849,-0.277183,0.205929>, <0.93849,0.277182,-0.205929>,
			<0.93849,0.277182,0.205929>, <0.944648,-0.022457,-0.327316>, <0.944648,-0.022457,0.327316>, <0.944648,0.022457,-0.327316>,
			<0.944648,0.022457,0.327316>, <0.952933,-0.02707,-0.301971>, <0.952933,-0.02707,0.301971>, <0.952933,0.027069,-0.301971>,
			<0.952933,0.027069,0.301971>, <0.9537,-0.030951,-0.299163>, <0.9537,-0.030951,0.299163>, <0.954114,-0.022161,-0.298622>,
			<0.954114,-0.022161,0.298622>, <0.954114,0.022161,-0.298622>, <0.954114,0.022161,0.298622>, <0.9537,0.030951,-0.299163>,
			<0.9537,0.030951,0.299163>, <0.967028,-0.254668,-0.000007>, <0.969049,-0.065705,-0.237963>, <0.969049,-0.065705,0.237963>,
			<0.969049,0.065705,-0.237963>, <0.969049,0.065705,0.237963>, <0.972479,-0.103936,0.208523>, <0.972479,0.103936,-0.208523>,
			<0.972479,0.103936,0.208523>, <0.974289,-0.196661,-0.109931>, <0.974289,-0.196661,0.109931>, <0.97429,0.19666,-0.109931>,
			<0.97429,0.19666,0.109931>, <0.977005,-0.098679,0.18901>, <0.977005,0.098679,-0.189009>, <0.977005,0.098679,0.18901>,
			<0.977804,-0.089128,-0.189621>, <0.978548,-0.20602,0.000039>, <0.979177,-0.14099,-0.146064>, <0.979177,-0.14099,0.146064>,
			<0.979177,0.14099,-0.146064>, <0.979177,0.14099,0.146064>, <0.983309,-0.101359,-0.151095>, <0.990266,-0.059197,-0.12597>,
			<0.990266,-0.059197,0.125969>, <0.990266,0.059197,0.125969>, <0.993884,-0.110427,0>, <0.993884,0.110427,0>,
			<0.994563,0.044289,-0.094246>, <0.996411,-0.039535,-0.074848>, <0.996411,-0.039535,0.074848>, <0.996411,0.039535,-0.074848>,
			<0.996411,0.039535,0.074848>, <0.997191,0,-0.074906>, <0.997191,0,0.074906>, <0.997628,-0.003542,-0.068742>,
			<0.997628,-0.003542,0.068742>, <0.997628,0.003542,-0.068742>, <0.997628,0.003542,0.068742>, <1,0,0>
		}
		face_indices {
			1352,
			<276, 330, 340>, <276, 340, 286>, <330, 394, 396>, <330, 396, 332>,
			<394, 500, 502>, <394, 502, 396>, <504, 494, 492>, <504, 492, 502>,
			<494, 482, 480>, <494, 480, 492>, <482, 454, 452>, <482, 452, 480>,
			<454, 396, 452>, <332, 342, 344>, <332, 344, 334>, <342, 354, 356>,
			<342, 356, 344>, <354, 382, 384>, <354, 384, 356>, <382, 396, 384>,
			<396, 454, 398>, <454, 482, 398>, <468, 400, 398>, <494, 504, 468>,
			<482, 494, 468>, <398, 482, 468>, <398, 384, 396>, <398, 356, 384>,
			<398, 400, 370>, <370, 334, 344>, <370, 344, 356>, <370, 356, 398>,
			<334, 370, 372>, <334, 372, 336>, <370, 400, 402>, <370, 402, 372>,
			<400, 468, 470>, <400, 470, 402>, <468, 504, 506>, <468, 506, 470>,
			<508, 498, 496>, <508, 496, 506>, <498, 486, 484>, <498, 484, 496>,
			<486, 458, 456>, <486, 456, 484>, <458, 406, 456>, <336, 346, 348>,
			<336, 348, 338>, <346, 358, 360>, <346, 360, 348>, <358, 386, 388>,
			<358, 388, 360>, <386, 406, 388>, <404, 456, 406>, <404, 484, 456>,
			<404, 402, 470>, <470, 506, 496>, <470, 496, 484>, <470, 484, 404>,
			<406, 386, 404>, <386, 358, 404>, <372, 402, 404>, <346, 336, 372>,
			<358, 346, 372>, <404, 358, 372>, <338, 406, 409>, <338, 409, 340>,
			<406, 508, 510>, <406, 510, 409>, <500, 554, 564>, <500, 564, 510>,
			<554, 608, 610>, <554, 610, 556>, <608, 664, 666>, <608, 666, 610>,
			<668, 656, 654>, <668, 654, 666>, <656, 644, 642>, <656, 642, 654>,
			<644, 628, 626>, <644, 626, 642>, <628, 610, 626>, <556, 570, 572>,
			<556, 572, 558>, <570, 578, 580>, <570, 580, 572>, <578, 594, 596>,
			<578, 596, 580>, <594, 610, 596>, <610, 628, 590>, <628, 644, 590>,
			<604, 586, 590>, <656, 668, 604>, <644, 656, 604>, <590, 644, 604>,
			<590, 596, 610>, <590, 580, 596>, <590, 586, 566>, <566, 558, 572>,
			<566, 572, 580>, <566, 580, 590>, <558, 566, 568>, <558, 568, 560>,
			<566, 586, 588>, <566, 588, 568>, <586, 604, 606>, <586, 606, 588>,
			<604, 668, 670>, <604, 670, 606>, <672, 660, 658>, <672, 658, 670>,
			<660, 648, 646>, <660, 646, 658>, <648, 632, 630>, <648, 630, 646>,
			<632, 612, 630>, <560, 574, 576>, <560, 576, 562>, <574, 582, 584>,
			<574, 584, 576>, <582, 598, 600>, <582, 600, 584>, <598, 612, 600>,
			<592, 630, 612>, <592, 646, 630>, <592, 588, 606>, <606, 670, 658>,
			<606, 658, 646>, <606, 646, 592>, <612, 598, 592>, <598, 582, 592>,
			<568, 588, 592>, <574, 560, 568>, <582, 574, 568>, <592, 582, 568>,
			<562, 612, 614>, <562, 614, 564>, <612, 672, 674>, <612, 674, 614>,
			<664, 663, 673>, <664, 673, 674>, <663, 607, 609>, <663, 609, 665>,
			<607, 553, 555>, <607, 555, 609>, <557, 571, 569>, <557, 569, 555>,
			<571, 579, 577>, <571, 577, 569>, <579, 595, 593>, <579, 593, 577>,
			<595, 609, 593>, <665, 653, 655>, <665, 655, 667>, <653, 641, 643>,
			<653, 643, 655>, <641, 625, 627>, <641, 627, 643>, <625, 609, 627>,
			<609, 595, 589>, <595, 579, 589>, <565, 585, 589>, <571, 557, 565>,
			<579, 571, 565>, <589, 579, 565>, <589, 627, 609>, <589, 643, 627>,
			<589, 585, 603>, <603, 667, 655>, <603, 655, 643>, <603, 643, 589>,
			<667, 603, 605>, <667, 605, 669>, <603, 585, 587>, <603, 587, 605>,
			<585, 565, 567>, <585, 567, 587>, <565, 557, 559>, <565, 559, 567>,
			<561, 575, 573>, <561, 573, 559>, <575, 583, 581>, <575, 581, 573>,
			<583, 599, 597>, <583, 597, 581>, <599, 611, 597>, <669, 657, 659>,
			<669, 659, 671>, <657, 645, 647>, <657, 647, 659>, <645, 629, 631>,
			<645, 631, 647>, <629, 611, 631>, <591, 597, 611>, <591, 581, 597>,
			<591, 587, 567>, <567, 559, 573>, <567, 573, 581>, <567, 581, 591>,
			<611, 629, 591>, <629, 645, 591>, <605, 587, 591>, <657, 669, 605>,
			<645, 657, 605>, <591, 645, 605>, <671, 611, 613>, <671, 613, 673>,
			<611, 561, 563>, <611, 563, 613>, <553, 499, 509>, <553, 509, 563>,
			<499, 393, 395>, <499, 395, 501>, <393, 329, 331>, <393, 331, 395>,
			<333, 343, 341>, <333, 341, 331>, <343, 355, 353>, <343, 353, 341>,
			<355, 383, 381>, <355, 381, 353>, <383, 395, 381>, <501, 491, 493>,
			<501, 493, 503>, <491, 479, 481>, <491, 481, 493>, <479, 451, 453>,
			<479, 453, 481>, <451, 395, 453>, <395, 383, 397>, <383, 355, 397>,
			<369, 399, 397>, <343, 333, 369>, <355, 343, 369>, <397, 355, 369>,
			<397, 453, 395>, <397, 481, 453>, <397, 399, 467>, <467, 503, 493>,
			<467, 493, 481>, <467, 481, 397>, <503, 467, 469>, <503, 469, 505>,
			<467, 399, 401>, <467, 401, 469>, <399, 369, 371>, <399, 371, 401>,
			<369, 333, 335>, <369, 335, 371>, <337, 347, 345>, <337, 345, 335>,
			<347, 359, 357>, <347, 357, 345>, <359, 387, 385>, <359, 385, 357>,
			<387, 405, 385>, <505, 495, 497>, <505, 497, 507>, <495, 483, 485>,
			<495, 485, 497>, <483, 455, 457>, <483, 457, 485>, <455, 405, 457>,
			<403, 385, 405>, <403, 357, 385>, <403, 401, 371>, <371, 335, 345>,
			<371, 345, 357>, <371, 357, 403>, <405, 455, 403>, <455, 483, 403>,
			<469, 401, 403>, <495, 505, 469>, <483, 495, 469>, <403, 483, 469>,
			<507, 405, 408>, <507, 408, 509>, <405, 337, 339>, <405, 339, 408>,
			<329, 275, 285>, <329, 285, 339>, <275, 225, 227>, <275, 227, 277>,
			<225, 165, 167>, <225, 167, 227>, <169, 181, 179>, <169, 179, 167>,
			<181, 193, 191>, <181, 191, 179>, <193, 209, 207>, <193, 207, 191>,
			<209, 227, 207>, <277, 263, 265>, <277, 265, 279>, <263, 255, 257>,
			<263, 257, 265>, <255, 239, 241>, <255, 241, 257>, <239, 227, 241>,
			<227, 209, 247>, <209, 193, 247>, <233, 251, 247>, <181, 169, 233>,
			<193, 181, 233>, <247, 193, 233>, <247, 241, 227>, <247, 257, 241>,
			<247, 251, 271>, <271, 279, 265>, <271, 265, 257>, <271, 257, 247>,
			<279, 271, 273>, <279, 273, 281>, <271, 251, 253>, <271, 253, 273>,
			<251, 233, 235>, <251, 235, 253>, <233, 169, 171>, <233, 171, 235>,
			<173, 185, 183>, <173, 183, 171>, <185, 197, 195>, <185, 195, 183>,
			<197, 213, 211>, <197, 211, 195>, <213, 229, 211>, <281, 267, 269>,
			<281, 269, 283>, <267, 259, 261>, <267, 261, 269>, <259, 243, 245>,
			<259, 245, 261>, <243, 229, 245>, <249, 211, 229>, <249, 195, 211>,
			<249, 253, 235>, <235, 171, 183>, <235, 183, 195>, <235, 195, 249>,
			<229, 243, 249>, <243, 259, 249>, <273, 253, 249>, <267, 281, 273>,
			<259, 267, 273>, <249, 259, 273>, <283, 229, 231>, <283, 231, 285>,
			<229, 173, 175>, <229, 175, 231>, <165, 166, 176>, <165, 176, 175>,
			<166, 226, 228>, <166, 228, 168>, <226, 276, 278>, <226, 278, 228>,
			<280, 266, 264>, <280, 264, 278>, <266, 258, 256>, <266, 256, 264>,
			<258, 242, 240>, <258, 240, 256>, <242, 228, 240>, <168, 180, 182>,
			<168, 182, 170>, <180, 192, 194>, <180, 194, 182>, <192, 208, 210>,
			<192, 210, 194>, <208, 228, 210>, <228, 242, 248>, <242, 258, 248>,
			<272, 252, 248>, <266, 280, 272>, <258, 266, 272>, <248, 258, 272>,
			<248, 210, 228>, <248, 194, 210>, <248, 252, 234>, <234, 170, 182>,
			<234, 182, 194>, <234, 194, 248>, <170, 234, 236>, <170, 236, 172>,
			<234, 252, 254>, <234, 254, 236>, <252, 272, 274>, <252, 274, 254>,
			<272, 280, 282>, <272, 282, 274>, <284, 270, 268>, <284, 268, 282>,
			<270, 262, 260>, <270, 260, 268>, <262, 246, 244>, <262, 244, 260>,
			<246, 230, 244>, <172, 184, 186>, <172, 186, 174>, <184, 196, 198>,
			<184, 198, 186>, <196, 212, 214>, <196, 214, 198>, <212, 230, 214>,
			<250, 244, 230>, <250, 260, 244>, <250, 254, 274>, <274, 282, 268>,
			<274, 268, 260>, <274, 260, 250>, <230, 212, 250>, <212, 196, 250>,
			<236, 254, 250>, <184, 172, 236>, <196, 184, 236>, <250, 196, 236>,
			<174, 230, 232>, <174, 232, 176>, <230, 284, 286>, <230, 286, 232>,
			<310, 320, 410>, <310, 410, 412>, <300, 310, 412>, <300, 412, 414>,
			<294, 300, 414>, <294, 414, 416>, <292, 294, 416>, <292, 416, 418>,
			<296, 292, 418>, <296, 418, 420>, <298, 296, 420>, <298, 420, 424>,
			<220, 238, 320>, <220, 320, 310>, <178, 220, 310>, <178, 310, 300>,
			<152, 178, 300>, <152, 300, 294>, <142, 152, 294>, <142, 294, 292>,
			<154, 142, 292>, <154, 292, 296>, <164, 154, 296>, <164, 296, 298>,
			<101, 136, 238>, <101, 238, 220>, <82, 101, 220>, <82, 220, 178>,
			<58, 82, 178>, <58, 178, 152>, <52, 58, 152>, <52, 152, 142>,
			<60, 52, 142>, <60, 142, 154>, <66, 60, 154>, <66, 154, 164>,
			<87, 102, 136>, <87, 136, 101>, <46, 87, 101>, <46, 101, 82>,
			<35, 46, 82>, <35, 82, 58>, <30, 35, 58>, <30, 58, 52>,
			<36, 30, 52>, <36, 52, 60>, <37, 36, 60>, <37, 60, 66>,
			<100, 135, 102>, <100, 102, 87>, <81, 100, 87>, <81, 87, 46>,
			<57, 81, 46>, <57, 46, 35>, <51, 57, 35>, <51, 35, 30>,
			<59, 51, 30>, <59, 30, 36>, <65, 59, 36>, <65, 36, 37>,
			<219, 237, 135>, <219, 135, 100>, <177, 219, 100>, <177, 100, 81>,
			<151, 177, 81>, <151, 81, 57>, <141, 151, 57>, <141, 57, 51>,
			<153, 141, 51>, <153, 51, 59>, <163, 153, 59>, <163, 59, 65>,
			<309, 319, 237>, <309, 237, 219>, <299, 309, 219>, <299, 219, 177>,
			<293, 299, 177>, <293, 177, 151>, <291, 293, 151>, <291, 151, 141>,
			<295, 291, 141>, <295, 141, 153>, <297, 295, 153>, <297, 153, 163>,
			<411, 407, 319>, <411, 319, 309>, <413, 411, 309>, <413, 309, 299>,
			<415, 413, 299>, <415, 299, 293>, <417, 415, 293>, <417, 293, 291>,
			<419, 417, 291>, <419, 291, 295>, <421, 419, 295>, <421, 295, 297>,
			<529, 519, 407>, <529, 407, 411>, <539, 529, 411>, <539, 411, 413>,
			<543, 539, 413>, <543, 413, 415>, <547, 543, 415>, <547, 415, 417>,
			<545, 547, 417>, <545, 417, 419>, <541, 545, 419>, <541, 419, 421>,
			<619, 601, 519>, <619, 519, 529>, <661, 619, 529>, <661, 529, 539>,
			<685, 661, 539>, <685, 539, 543>, <697, 685, 543>, <697, 543, 547>,
			<687, 697, 547>, <687, 547, 545>, <675, 687, 545>, <675, 545, 541>,
			<738, 703, 601>, <738, 601, 619>, <757, 738, 619>, <757, 619, 661>,
			<779, 757, 661>, <779, 661, 685>, <787, 779, 685>, <787, 685, 697>,
			<781, 787, 697>, <781, 697, 687>, <773, 781, 687>, <773, 687, 675>,
			<752, 737, 703>, <752, 703, 738>, <793, 752, 738>, <793, 738, 757>,
			<803, 793, 757>, <803, 757, 779>, <805, 803, 779>, <805, 779, 787>,
			<804, 805, 787>, <804, 787, 781>, <802, 804, 781>, <802, 781, 773>,
			<739, 704, 737>, <739, 737, 752>, <758, 739, 752>, <758, 752, 793>,
			<780, 758, 793>, <780, 793, 803>, <788, 780, 803>, <788, 803, 805>,
			<782, 788, 805>, <782, 805, 804>, <774, 782, 804>, <774, 804, 802>,
			<620, 602, 704>, <620, 704, 739>, <662, 620, 739>, <662, 739, 758>,
			<686, 662, 758>, <686, 758, 780>, <698, 686, 780>, <698, 780, 788>,
			<688, 698, 788>, <688, 788, 782>, <676, 688, 782>, <676, 782, 774>,
			<530, 520, 602>, <530, 602, 620>, <540, 530, 620>, <540, 620, 662>,
			<544, 540, 662>, <544, 662, 686>, <548, 544, 686>, <548, 686, 698>,
			<546, 548, 698>, <546, 698, 688>, <542, 546, 688>, <542, 688, 676>,
			<412, 410, 520>, <412, 520, 530>, <414, 412, 530>, <414, 530, 540>,
			<416, 414, 540>, <416, 540, 544>, <418, 416, 544>, <418, 544, 548>,
			<420, 418, 548>, <420, 548, 546>, <424, 420, 546>, <424, 546, 542>,
			<521, 535, 649>, <521, 649, 615>, <535, 549, 689>, <535, 689, 649>,
			<549, 551, 691>, <549, 691, 689>, <551, 537, 651>, <551, 651, 691>,
			<537, 523, 617>, <537, 617, 651>, <767, 729, 744>, <767, 744, 789>,
			<789, 744, 748>, <789, 748, 753>, <789, 753, 763>, <789, 763, 775>,
			<789, 775, 794>, <794, 775, 798>, <794, 798, 806>, <806, 798, 810>,
			<759, 783, 810>, <798, 759, 810>, <725, 699, 783>, <759, 725, 783>,
			<740, 759, 798>, <775, 740, 798>, <705, 725, 759>, <740, 705, 759>,
			<717, 748, 744>, <717, 753, 748>, <740, 717, 705>, <763, 740, 775>,
			<753, 740, 763>, <753, 717, 740>, <744, 729, 615>, <621, 744, 615>,
			<733, 744, 621>, <721, 733, 621>, <713, 721, 621>, <709, 713, 621>,
			<633, 709, 621>, <693, 709, 633>, <649, 693, 633>, <689, 693, 649>,
			<689, 637, 681>, <689, 681, 693>, <637, 699, 725>, <637, 725, 681>,
			<693, 681, 677>, <693, 677, 709>, <681, 725, 705>, <681, 705, 677>,
			<744, 733, 717>, <733, 721, 717>, <705, 717, 677>, <709, 677, 713>,
			<713, 677, 721>, <677, 717, 721>, <746, 731, 769>, <791, 746, 769>,
			<750, 746, 791>, <755, 750, 791>, <765, 755, 791>, <777, 765, 791>,
			<796, 777, 791>, <800, 777, 796>, <808, 800, 796>, <812, 800, 808>,
			<812, 785, 761>, <812, 761, 800>, <785, 701, 727>, <785, 727, 761>,
			<800, 761, 742>, <800, 742, 777>, <761, 727, 707>, <761, 707, 742>,
			<746, 750, 719>, <750, 755, 719>, <707, 719, 742>, <777, 742, 765>,
			<765, 742, 755>, <742, 719, 755>, <617, 731, 746>, <617, 746, 623>,
			<623, 746, 735>, <623, 735, 723>, <623, 723, 715>, <623, 715, 711>,
			<623, 711, 635>, <635, 711, 695>, <635, 695, 651>, <651, 695, 691>,
			<683, 639, 691>, <695, 683, 691>, <727, 701, 639>, <683, 727, 639>,
			<679, 683, 695>, <711, 679, 695>, <707, 727, 683>, <679, 707, 683>,
			<719, 735, 746>, <719, 723, 735>, <679, 719, 707>, <715, 679, 711>,
			<723, 679, 715>, <723, 719, 679>, <810, 783, 785>, <810, 785, 812>,
			<783, 699, 701>, <783, 701, 785>, <699, 637, 639>, <699, 639, 701>,
			<637, 689, 691>, <637, 691, 639>, <221, 187, 301>, <221, 301, 315>,
			<187, 147, 287>, <187, 287, 301>, <147, 149, 289>, <147, 289, 287>,
			<149, 189, 303>, <149, 303, 289>, <189, 223, 317>, <189, 317, 303>,
			<521, 422, 425>, <521, 425, 525>, <525, 425, 447>, <525, 447, 459>,
			<525, 459, 471>, <525, 471, 475>, <525, 475, 531>, <531, 475, 511>,
			<531, 511, 535>, <535, 511, 549>, <487, 515, 549>, <511, 487, 549>,
			<431, 433, 515>, <487, 431, 515>, <461, 487, 511>, <475, 461, 511>,
			<429, 431, 487>, <461, 429, 487>, <427, 447, 425>, <427, 459, 447>,
			<461, 427, 429>, <471, 461, 475>, <459, 461, 471>, <459, 427, 461>,
			<425, 422, 315>, <311, 425, 315>, <389, 425, 311>, <373, 389, 311>,
			<365, 373, 311>, <361, 365, 311>, <305, 361, 311>, <325, 361, 305>,
			<301, 325, 305>, <287, 325, 301>, <287, 321, 349>, <287, 349, 325>,
			<321, 433, 431>, <321, 431, 349>, <325, 349, 375>, <325, 375, 361>,
			<349, 431, 429>, <349, 429, 375>, <425, 389, 427>, <389, 373, 427>,
			<429, 427, 375>, <361, 375, 365>, <365, 375, 373>, <375, 427, 373>,
			<443, 445, 523>, <527, 443, 523>, <449, 443, 527>, <465, 449, 527>,
			<473, 465, 527>, <477, 473, 527>, <533, 477, 527>, <513, 477, 533>,
			<537, 513, 533>, <551, 513, 537>, <551, 517, 489>, <551, 489, 513>,
			<517, 435, 437>, <517, 437, 489>, <513, 489, 463>, <513, 463, 477>,
			<489, 437, 439>, <489, 439, 463>, <443, 449, 441>, <449, 465, 441>,
			<439, 441, 463>, <477, 463, 473>, <473, 463, 465>, <463, 441, 465>,
			<317, 445, 443>, <317, 443, 313>, <313, 443, 391>, <313, 391, 379>,
			<313, 379, 367>, <313, 367, 363>, <313, 363, 307>, <307, 363, 327>,
			<307, 327, 303>, <303, 327, 289>, <351, 323, 289>, <327, 351, 289>,
			<437, 435, 323>, <351, 437, 323>, <377, 351, 327>, <363, 377, 327>,
			<439, 437, 351>, <377, 439, 351>, <441, 391, 443>, <441, 379, 391>,
			<377, 441, 439>, <367, 377, 363>, <379, 377, 367>, <379, 441, 377>,
			<549, 515, 517>, <549, 517, 551>, <515, 433, 435>, <515, 435, 517>,
			<433, 321, 323>, <433, 323, 435>, <321, 287, 289>, <321, 289, 323>,
			<70, 32, 31>, <70, 31, 69>, <32, 27, 26>, <32, 26, 31>,
			<27, 29, 28>, <27, 28, 26>, <29, 34, 33>, <29, 33, 28>,
			<34, 72, 71>, <34, 71, 33>, <221, 107, 92>, <221, 92, 215>,
			<215, 92, 103>, <215, 103, 115>, <215, 115, 123>, <215, 123, 127>,
			<215, 127, 203>, <203, 127, 143>, <203, 143, 187>, <187, 143, 147>,
			<155, 199, 147>, <143, 155, 147>, <111, 137, 199>, <155, 111, 199>,
			<159, 155, 143>, <127, 159, 143>, <131, 111, 155>, <159, 131, 155>,
			<119, 103, 92>, <119, 115, 103>, <159, 119, 131>, <123, 159, 127>,
			<115, 159, 123>, <115, 119, 159>, <92, 107, 69>, <47, 92, 69>,
			<88, 92, 47>, <83, 88, 47>, <73, 83, 47>, <61, 73, 47>,
			<42, 61, 47>, <38, 61, 42>, <31, 38, 42>, <26, 38, 31>,
			<26, 53, 77>, <26, 77, 38>, <53, 137, 111>, <53, 111, 77>,
			<38, 77, 96>, <38, 96, 61>, <77, 111, 131>, <77, 131, 96>,
			<92, 88, 119>, <88, 83, 119>, <131, 119, 96>, <61, 96, 73>,
			<73, 96, 83>, <96, 119, 83>, <94, 109, 223>, <217, 94, 223>,
			<105, 94, 217>, <117, 105, 217>, <125, 117, 217>, <129, 125, 217>,
			<205, 129, 217>, <145, 129, 205>, <189, 145, 205>, <149, 145, 189>,
			<149, 201, 157>, <149, 157, 145>, <201, 139, 113>, <201, 113, 157>,
			<145, 157, 161>, <145, 161, 129>, <157, 113, 133>, <157, 133, 161>,
			<94, 105, 121>, <105, 117, 121>, <133, 121, 161>, <129, 161, 125>,
			<125, 161, 117>, <161, 121, 117>, <71, 109, 94>, <71, 94, 49>,
			<49, 94, 90>, <49, 90, 85>, <49, 85, 75>, <49, 75, 63>,
			<49, 63, 44>, <44, 63, 40>, <44, 40, 33>, <33, 40, 28>,
			<79, 55, 28>, <40, 79, 28>, <113, 139, 55>, <79, 113, 55>,
			<98, 79, 40>, <63, 98, 40>, <133, 113, 79>, <98, 133, 79>,
			<121, 90, 94>, <121, 85, 90>, <98, 121, 133>, <75, 98, 63>,
			<85, 98, 75>, <85, 121, 98>, <147, 199, 201>, <147, 201, 149>,
			<199, 137, 139>, <199, 139, 201>, <137, 53, 55>, <137, 55, 139>,
			<53, 26, 28>, <53, 28, 55>, <316, 302, 188>, <316, 188, 222>,
			<302, 288, 148>, <302, 148, 188>, <288, 290, 150>, <288, 150, 148>,
			<290, 304, 190>, <290, 190, 150>, <304, 318, 224>, <304, 224, 190>,
			<70, 108, 93>, <70, 93, 48>, <48, 93, 89>, <48, 89, 84>,
			<48, 84, 74>, <48, 74, 62>, <48, 62, 43>, <43, 62, 39>,
			<43, 39, 32>, <32, 39, 27>, <78, 54, 27>, <39, 78, 27>,
			<112, 138, 54>, <78, 112, 54>, <97, 78, 39>, <62, 97, 39>,
			<132, 112, 78>, <97, 132, 78>, <120, 89, 93>, <120, 84, 89>,
			<97, 120, 132>, <74, 97, 62>, <84, 97, 74>, <84, 120, 97>,
			<93, 108, 222>, <216, 93, 222>, <104, 93, 216>, <116, 104, 216>,
			<124, 116, 216>, <128, 124, 216>, <204, 128, 216>, <144, 128, 204>,
			<188, 144, 204>, <148, 144, 188>, <148, 200, 156>, <148, 156, 144>,
			<200, 138, 112>, <200, 112, 156>, <144, 156, 160>, <144, 160, 128>,
			<156, 112, 132>, <156, 132, 160>, <93, 104, 120>, <104, 116, 120>,
			<132, 120, 160>, <128, 160, 124>, <124, 160, 116>, <160, 120, 116>,
			<95, 110, 72>, <50, 95, 72>, <91, 95, 50>, <86, 91, 50>,
			<76, 86, 50>, <64, 76, 50>, <45, 64, 50>, <41, 64, 45>,
			<34, 41, 45>, <29, 41, 34>, <29, 56, 80>, <29, 80, 41>,
			<56, 140, 114>, <56, 114, 80>, <41, 80, 99>, <41, 99, 64>,
			<80, 114, 134>, <80, 134, 99>, <95, 91, 122>, <91, 86, 122>,
			<134, 122, 99>, <64, 99, 76>, <76, 99, 86>, <99, 122, 86>,
			<224, 110, 95>, <224, 95, 218>, <218, 95, 106>, <218, 106, 118>,
			<218, 118, 126>, <218, 126, 130>, <218, 130, 206>, <206, 130, 146>,
			<206, 146, 190>, <190, 146, 150>, <158, 202, 150>, <146, 158, 150>,
			<114, 140, 202>, <158, 114, 202>, <162, 158, 146>, <130, 162, 146>,
			<134, 114, 158>, <162, 134, 158>, <122, 106, 95>, <122, 118, 106>,
			<162, 122, 134>, <126, 162, 130>, <118, 162, 126>, <118, 122, 162>,
			<27, 54, 56>, <27, 56, 29>, <54, 138, 140>, <54, 140, 56>,
			<138, 200, 202>, <138, 202, 140>, <200, 148, 150>, <200, 150, 202>,
			<616, 650, 536>, <616, 536, 522>, <650, 690, 550>, <650, 550, 536>,
			<690, 692, 552>, <690, 552, 550>, <692, 652, 538>, <692, 538, 552>,
			<652, 618, 524>, <652, 524, 538>, <316, 423, 426>, <316, 426, 312>,
			<312, 426, 390>, <312, 390, 374>, <312, 374, 366>, <312, 366, 362>,
			<312, 362, 306>, <306, 362, 326>, <306, 326, 302>, <302, 326, 288>,
			<350, 322, 288>, <326, 350, 288>, <432, 434, 322>, <350, 432, 322>,
			<376, 350, 326>, <362, 376, 326>, <430, 432, 350>, <376, 430, 350>,
			<428, 390, 426>, <428, 374, 390>, <376, 428, 430>, <366, 376, 362>,
			<374, 376, 366>, <374, 428, 376>, <426, 423, 522>, <526, 426, 522>,
			<448, 426, 526>, <460, 448, 526>, <472, 460, 526>, <476, 472, 526>,
			<532, 476, 526>, <512, 476, 532>, <536, 512, 532>, <550, 512, 536>,
			<550, 516, 488>, <550, 488, 512>, <516, 434, 432>, <516, 432, 488>,
			<512, 488, 462>, <512, 462, 476>, <488, 432, 430>, <488, 430, 462>,
			<426, 448, 428>, <448, 460, 428>, <430, 428, 462>, <476, 462, 472>,
			<472, 462, 460>, <462, 428, 460>, <444, 446, 318>, <314, 444, 318>,
			<392, 444, 314>, <380, 392, 314>, <368, 380, 314>, <364, 368, 314>,
			<308, 364, 314>, <328, 364, 308>, <304, 328, 308>, <290, 328, 304>,
			<290, 324, 352>, <290, 352, 328>, <324, 436, 438>, <324, 438, 352>,
			<328, 352, 378>, <328, 378, 364>, <352, 438, 440>, <352, 440, 378>,
			<444, 392, 442>, <392, 380, 442>, <440, 442, 378>, <364, 378, 368>,
			<368, 378, 380>, <378, 442, 380>, <524, 446, 444>, <524, 444, 528>,
			<528, 444, 450>, <528, 450, 466>, <528, 466, 474>, <528, 474, 478>,
			<528, 478, 534>, <534, 478, 514>, <534, 514, 538>, <538, 514, 552>,
			<490, 518, 552>, <514, 490, 552>, <438, 436, 518>, <490, 438, 518>,
			<464, 490, 514>, <478, 464, 514>, <440, 438, 490>, <464, 440, 490>,
			<442, 450, 444>, <442, 466, 450>, <464, 442, 440>, <474, 464, 478>,
			<466, 464, 474>, <466, 442, 464>, <288, 322, 324>, <288, 324, 290>,
			<322, 434, 436>, <322, 436, 324>, <434, 516, 518>, <434, 518, 436>,
			<516, 550, 552>, <516, 552, 518>, <767, 806, 807>, <767, 807, 768>,
			<806, 810, 811>, <806, 811, 807>, <810, 812, 813>, <810, 813, 811>,
			<812, 808, 809>, <812, 809, 813>, <808, 769, 770>, <808, 770, 809>,
			<616, 730, 745>, <616, 745, 622>, <622, 745, 734>, <622, 734, 722>,
			<622, 722, 714>, <622, 714, 710>, <622, 710, 634>, <634, 710, 694>,
			<634, 694, 650>, <650, 694, 690>, <682, 638, 690>, <694, 682, 690>,
			<726, 700, 638>, <682, 726, 638>, <678, 682, 694>, <710, 678, 694>,
			<706, 726, 682>, <678, 706, 682>, <718, 734, 745>, <718, 722, 734>,
			<678, 718, 706>, <714, 678, 710>, <722, 678, 714>, <722, 718, 678>,
			<745, 730, 768>, <790, 745, 768>, <749, 745, 790>, <754, 749, 790>,
			<764, 754, 790>, <776, 764, 790>, <795, 776, 790>, <799, 776, 795>,
			<807, 799, 795>, <811, 799, 807>, <811, 784, 760>, <811, 760, 799>,
			<784, 700, 726>, <784, 726, 760>, <799, 760, 741>, <799, 741, 776>,
			<760, 726, 706>, <760, 706, 741>, <745, 749, 718>, <749, 754, 718>,
			<706, 718, 741>, <776, 741, 764>, <764, 741, 754>, <741, 718, 754>,
			<747, 732, 618>, <624, 747, 618>, <736, 747, 624>, <724, 736, 624>,
			<716, 724, 624>, <712, 716, 624>, <636, 712, 624>, <696, 712, 636>,
			<652, 696, 636>, <692, 696, 652>, <692, 640, 684>, <692, 684, 696>,
			<640, 702, 728>, <640, 728, 684>, <696, 684, 680>, <696, 680, 712>,
			<684, 728, 708>, <684, 708, 680>, <747, 736, 720>, <736, 724, 720>,
			<708, 720, 680>, <712, 680, 716>, <716, 680, 724>, <680, 720, 724>,
			<770, 732, 747>, <770, 747, 792>, <792, 747, 751>, <792, 751, 756>,
			<792, 756, 766>, <792, 766, 778>, <792, 778, 797>, <797, 778, 801>,
			<797, 801, 809>, <809, 801, 813>, <762, 786, 813>, <801, 762, 813>,
			<728, 702, 786>, <762, 728, 786>, <743, 762, 801>, <778, 743, 801>,
			<708, 728, 762>, <743, 708, 762>, <720, 751, 747>, <720, 756, 751>,
			<743, 720, 708>, <766, 743, 778>, <756, 743, 766>, <756, 720, 743>,
			<690, 638, 640>, <690, 640, 692>, <638, 700, 702>, <638, 702, 640>,
			<700, 784, 786>, <700, 786, 702>, <784, 811, 813>, <784, 813, 786>,
			<815, 818, 12>, <815, 12, 25>, <818, 819, 13>, <818, 13, 12>,
			<23, 15, 821>, <23, 821, 829>, <828, 22, 23>, <828, 23, 829>,
			<825, 19, 22>, <825, 22, 828>, <824, 18, 19>, <824, 19, 825>,
			<772, 68, 18>, <772, 18, 824>, <814, 817, 818>, <814, 818, 815>,
			<817, 834, 835>, <817, 835, 818>, <839, 837, 836>, <839, 836, 838>,
			<832, 833, 839>, <832, 839, 838>, <830, 831, 833>, <830, 833, 832>,
			<823, 824, 831>, <823, 831, 830>, <771, 772, 824>, <771, 824, 823>,
			<24, 11, 817>, <24, 817, 814>, <11, 10, 816>, <11, 816, 817>,
			<826, 820, 14>, <826, 14, 20>, <21, 827, 826>, <21, 826, 20>,
			<16, 822, 827>, <16, 827, 21>, <17, 823, 822>, <17, 822, 16>,
			<67, 771, 823>, <67, 823, 17>, <25, 12, 11>, <25, 11, 24>,
			<12, 5, 4>, <12, 4, 11>, <2, 0, 1>, <2, 1, 3>,
			<9, 8, 2>, <9, 2, 3>, <7, 6, 8>, <7, 8, 9>,
			<18, 17, 6>, <18, 6, 7>, <68, 67, 17>, <68, 17, 18>
		}
		normal_indices {
			1352,
			<628, 628, 628>, <628, 628, 628>, <495, 454, 454>, <495, 454, 495>,
			<454, 411, 411>, <454, 411, 454>, <411, 411, 411>, <411, 411, 411>,
			<411, 411, 411>, <411, 411, 411>, <411, 411, 411>, <411, 411, 411>,
			<411, 411, 411>, <495, 495, 495>, <495, 495, 495>, <495, 495, 495>,
			<495, 495, 495>, <495, 495, 495>, <495, 495, 495>, <495, 495, 495>,
			<437, 519, 439>, <519, 562, 439>, <570, 449, 439>, <578, 606, 570>,
			<562, 578, 570>, <439, 562, 570>, <439, 381, 437>, <439, 342, 381>,
			<439, 449, 339>, <339, 298, 325>, <339, 325, 342>, <339, 342, 439>,
			<298, 339, 340>, <298, 340, 300>, <339, 449, 459>, <339, 459, 340>,
			<449, 570, 567>, <449, 567, 459>, <570, 606, 608>, <570, 608, 567>,
			<411, 411, 411>, <411, 411, 411>, <411, 411, 411>, <411, 411, 411>,
			<411, 411, 411>, <411, 411, 411>, <411, 411, 411>, <495, 495, 495>,
			<495, 495, 495>, <495, 495, 495>, <495, 495, 495>, <495, 495, 495>,
			<495, 495, 495>, <495, 495, 495>, <465, 525, 467>, <465, 564, 525>,
			<465, 459, 567>, <567, 608, 580>, <567, 580, 564>, <567, 564, 465>,
			<467, 387, 465>, <387, 344, 465>, <340, 459, 465>, <327, 300, 340>,
			<344, 327, 340>, <465, 344, 340>, <495, 454, 454>, <495, 454, 495>,
			<454, 411, 411>, <454, 411, 454>, <278, 278, 278>, <278, 278, 278>,
			<160, 120, 120>, <160, 120, 160>, <120, 72, 72>, <120, 72, 120>,
			<72, 72, 72>, <72, 72, 72>, <72, 72, 72>, <72, 72, 72>,
			<72, 72, 72>, <72, 72, 72>, <72, 72, 72>, <160, 160, 160>,
			<160, 160, 160>, <160, 160, 160>, <160, 160, 160>, <160, 160, 160>,
			<160, 160, 160>, <160, 160, 160>, <227, 245, 144>, <245, 240, 144>,
			<235, 124, 144>, <250, 264, 235>, <240, 250, 235>, <144, 240, 235>,
			<144, 148, 227>, <144, 55, 148>, <144, 124, 31>, <31, 7, 18>,
			<31, 18, 55>, <31, 55, 144>, <7, 31, 32>, <5, 32, 9>,
			<31, 124, 126>, <31, 126, 32>, <124, 235, 232>, <124, 232, 126>,
			<235, 264, 266>, <235, 266, 232>, <72, 72, 72>, <72, 72, 72>,
			<72, 72, 72>, <72, 72, 72>, <72, 72, 72>, <72, 72, 72>,
			<72, 72, 72>, <160, 160, 160>, <160, 160, 160>, <160, 160, 160>,
			<160, 160, 160>, <160, 160, 160>, <160, 160, 160>, <160, 160, 160>,
			<146, 247, 229>, <146, 242, 247>, <146, 126, 232>, <232, 266, 252>,
			<232, 252, 242>, <232, 242, 146>, <229, 150, 146>, <150, 57, 146>,
			<32, 126, 146>, <20, 9, 32>, <57, 20, 32>, <146, 57, 32>,
			<160, 120, 120>, <160, 120, 160>, <120, 72, 72>, <120, 72, 120>,
			<0, 0, 0>, <0, 0, 0>, <73, 121, 121>, <73, 121, 73>,
			<121, 161, 161>, <121, 161, 121>, <161, 161, 161>, <161, 161, 161>,
			<161, 161, 161>, <161, 161, 161>, <161, 161, 161>, <161, 161, 161>,
			<161, 161, 161>, <73, 73, 73>, <73, 73, 73>, <73, 73, 73>,
			<73, 73, 73>, <73, 73, 73>, <73, 73, 73>, <73, 73, 73>,
			<228, 149, 145>, <149, 56, 145>, <22, 125, 145>, <19, 8, 22>,
			<56, 19, 22>, <145, 56, 22>, <145, 246, 228>, <145, 241, 246>,
			<145, 125, 231>, <231, 265, 251>, <231, 251, 241>, <231, 241, 145>,
			<265, 231, 233>, <265, 233, 267>, <231, 125, 127>, <231, 127, 233>,
			<125, 22, 33>, <125, 33, 127>, <22, 8, 6>, <22, 10, 33>,
			<161, 161, 161>, <161, 161, 161>, <161, 161, 161>, <161, 161, 161>,
			<161, 161, 161>, <161, 161, 161>, <161, 161, 161>, <73, 73, 73>,
			<73, 73, 73>, <73, 73, 73>, <73, 73, 73>, <73, 73, 73>,
			<73, 73, 73>, <73, 73, 73>, <147, 151, 230>, <147, 58, 151>,
			<147, 127, 33>, <33, 10, 21>, <33, 21, 58>, <33, 58, 147>,
			<230, 248, 147>, <248, 243, 147>, <233, 127, 147>, <253, 267, 233>,
			<243, 253, 233>, <147, 243, 233>, <73, 121, 121>, <73, 121, 73>,
			<121, 161, 161>, <121, 161, 121>, <279, 279, 279>, <279, 279, 279>,
			<412, 456, 456>, <412, 456, 412>, <456, 496, 496>, <456, 496, 456>,
			<496, 496, 496>, <496, 496, 496>, <496, 496, 496>, <496, 496, 496>,
			<496, 496, 496>, <496, 496, 496>, <496, 496, 496>, <412, 412, 412>,
			<412, 412, 412>, <412, 412, 412>, <412, 412, 412>, <412, 412, 412>,
			<412, 412, 412>, <412, 412, 412>, <438, 382, 440>, <382, 343, 440>,
			<336, 450, 440>, <326, 299, 336>, <343, 326, 336>, <440, 343, 336>,
			<440, 520, 438>, <440, 563, 520>, <440, 450, 566>, <566, 607, 579>,
			<566, 579, 563>, <566, 563, 440>, <607, 566, 568>, <607, 568, 609>,
			<566, 450, 460>, <566, 460, 568>, <450, 336, 341>, <450, 341, 460>,
			<336, 299, 301>, <336, 301, 341>, <496, 496, 496>, <496, 496, 496>,
			<496, 496, 496>, <496, 496, 496>, <496, 496, 496>, <496, 496, 496>,
			<496, 496, 496>, <412, 412, 412>, <412, 412, 412>, <412, 412, 412>,
			<412, 412, 412>, <412, 412, 412>, <412, 412, 412>, <412, 412, 412>,
			<466, 388, 468>, <466, 345, 388>, <466, 460, 341>, <341, 301, 328>,
			<341, 328, 345>, <341, 345, 466>, <468, 526, 466>, <526, 565, 466>,
			<568, 460, 466>, <581, 609, 568>, <565, 581, 568>, <466, 565, 568>,
			<412, 456, 456>, <412, 456, 412>, <456, 496, 496>, <456, 496, 456>,
			<629, 629, 629>, <629, 629, 629>, <747, 787, 787>, <747, 787, 747>,
			<787, 835, 835>, <787, 835, 787>, <835, 835, 835>, <835, 835, 835>,
			<835, 835, 835>, <835, 835, 835>, <835, 835, 835>, <835, 835, 835>,
			<835, 835, 835>, <747, 747, 747>, <747, 747, 747>, <747, 747, 747>,
			<747, 747, 747>, <747, 747, 747>, <747, 747, 747>, <747, 747, 747>,
			<678, 660, 761>, <660, 665, 761>, <672, 781, 761>, <655, 641, 672>,
			<665, 655, 672>, <761, 665, 672>, <761, 757, 678>, <761, 850, 757>,
			<761, 781, 874>, <874, 898, 887>, <874, 887, 850>, <874, 850, 761>,
			<898, 874, 876>, <902, 876, 900>, <874, 781, 783>, <874, 783, 876>,
			<781, 672, 676>, <781, 676, 783>, <672, 641, 643>, <672, 643, 676>,
			<835, 835, 835>, <835, 835, 835>, <835, 835, 835>, <835, 835, 835>,
			<835, 835, 835>, <835, 835, 835>, <835, 835, 835>, <747, 747, 747>,
			<747, 747, 747>, <747, 747, 747>, <747, 747, 747>, <747, 747, 747>,
			<747, 747, 747>, <747, 747, 747>, <763, 662, 680>, <763, 667, 662>,
			<763, 783, 676>, <676, 643, 657>, <676, 657, 667>, <676, 667, 763>,
			<680, 759, 763>, <759, 852, 763>, <876, 783, 763>, <889, 900, 876>,
			<852, 889, 876>, <763, 852, 876>, <747, 787, 787>, <747, 787, 747>,
			<787, 835, 835>, <787, 835, 787>, <907, 907, 907>, <907, 907, 907>,
			<834, 786, 786>, <834, 786, 834>, <786, 746, 746>, <786, 746, 786>,
			<746, 746, 746>, <746, 746, 746>, <746, 746, 746>, <746, 746, 746>,
			<746, 746, 746>, <746, 746, 746>, <746, 746, 746>, <834, 834, 834>,
			<834, 834, 834>, <834, 834, 834>, <834, 834, 834>, <834, 834, 834>,
			<834, 834, 834>, <834, 834, 834>, <677, 756, 760>, <756, 849, 760>,
			<884, 780, 760>, <886, 897, 884>, <849, 886, 884>, <760, 849, 884>,
			<760, 659, 677>, <760, 664, 659>, <760, 780, 674>, <674, 640, 654>,
			<674, 654, 664>, <674, 664, 760>, <640, 674, 675>, <640, 675, 642>,
			<674, 780, 782>, <674, 782, 675>, <780, 884, 875>, <780, 875, 782>,
			<884, 897, 901>, <884, 899, 875>, <746, 746, 746>, <746, 746, 746>,
			<746, 746, 746>, <746, 746, 746>, <746, 746, 746>, <746, 746, 746>,
			<746, 746, 746>, <834, 834, 834>, <834, 834, 834>, <834, 834, 834>,
			<834, 834, 834>, <834, 834, 834>, <834, 834, 834>, <834, 834, 834>,
			<762, 758, 679>, <762, 851, 758>, <762, 782, 875>, <875, 899, 888>,
			<875, 888, 851>, <875, 851, 762>, <679, 661, 762>, <661, 666, 762>,
			<675, 782, 762>, <656, 642, 675>, <666, 656, 675>, <762, 666, 675>,
			<834, 786, 786>, <834, 786, 834>, <786, 746, 746>, <786, 746, 786>,
			<481, 481, 471>, <481, 471, 471>, <552, 551, 476>, <552, 476, 474>,
			<583, 552, 474>, <583, 474, 432>, <604, 583, 432>, <604, 432, 453>,
			<590, 604, 453>, <590, 453, 445>, <584, 590, 445>, <584, 445, 441>,
			<517, 517, 481>, <517, 481, 481>, <634, 614, 551>, <634, 551, 552>,
			<692, 634, 552>, <692, 552, 583>, <693, 692, 583>, <693, 583, 604>,
			<673, 693, 604>, <673, 604, 590>, <685, 673, 590>, <685, 590, 584>,
			<548, 548, 517>, <548, 517, 517>, <716, 653, 614>, <716, 614, 634>,
			<799, 716, 634>, <799, 634, 692>, <809, 799, 692>, <809, 692, 693>,
			<804, 809, 693>, <804, 693, 673>, <805, 804, 673>, <805, 673, 685>,
			<550, 550, 548>, <550, 548, 548>, <745, 663, 653>, <745, 653, 716>,
			<848, 745, 716>, <848, 716, 799>, <907, 848, 799>, <907, 799, 809>,
			<885, 907, 809>, <885, 809, 804>, <869, 885, 804>, <869, 804, 805>,
			<549, 549, 550>, <549, 550, 550>, <691, 649, 663>, <691, 663, 745>,
			<798, 691, 745>, <798, 745, 848>, <808, 798, 848>, <808, 848, 907>,
			<807, 808, 907>, <807, 907, 885>, <806, 807, 885>, <806, 885, 869>,
			<518, 518, 549>, <518, 549, 549>, <635, 615, 649>, <635, 649, 691>,
			<668, 635, 691>, <668, 691, 798>, <694, 668, 798>, <694, 798, 808>,
			<695, 694, 808>, <695, 808, 807>, <686, 695, 807>, <686, 807, 806>,
			<482, 482, 518>, <482, 518, 518>, <553, 535, 615>, <553, 615, 635>,
			<582, 553, 635>, <582, 635, 668>, <605, 582, 668>, <605, 668, 694>,
			<602, 605, 694>, <602, 694, 695>, <585, 602, 695>, <585, 695, 686>,
			<472, 472, 482>, <472, 482, 482>, <433, 431, 535>, <433, 535, 553>,
			<475, 433, 553>, <475, 553, 582>, <455, 475, 582>, <455, 582, 605>,
			<446, 455, 605>, <446, 605, 602>, <442, 446, 602>, <442, 602, 585>,
			<426, 426, 472>, <426, 472, 472>, <355, 356, 431>, <355, 431, 433>,
			<324, 355, 433>, <324, 433, 475>, <302, 324, 475>, <302, 475, 455>,
			<317, 302, 455>, <317, 455, 446>, <323, 317, 446>, <323, 446, 442>,
			<390, 390, 426>, <390, 426, 426>, <273, 293, 356>, <273, 356, 355>,
			<215, 273, 355>, <215, 355, 324>, <214, 215, 324>, <214, 324, 302>,
			<234, 214, 302>, <234, 302, 317>, <222, 234, 317>, <222, 317, 323>,
			<359, 359, 390>, <359, 390, 390>, <191, 254, 293>, <191, 293, 273>,
			<108, 191, 273>, <108, 273, 215>, <99, 108, 215>, <99, 215, 214>,
			<103, 99, 214>, <103, 214, 234>, <102, 103, 234>, <102, 234, 222>,
			<357, 357, 359>, <357, 359, 359>, <162, 244, 254>, <162, 254, 191>,
			<63, 162, 191>, <63, 191, 108>, <0, 63, 108>, <0, 108, 99>,
			<17, 0, 99>, <17, 99, 103>, <38, 17, 103>, <38, 103, 102>,
			<358, 358, 357>, <358, 357, 357>, <216, 258, 244>, <216, 244, 162>,
			<109, 216, 162>, <109, 162, 63>, <98, 109, 63>, <98, 63, 0>,
			<100, 98, 0>, <100, 0, 17>, <101, 100, 17>, <101, 17, 38>,
			<389, 389, 358>, <389, 358, 358>, <272, 292, 258>, <272, 258, 216>,
			<239, 272, 216>, <239, 216, 109>, <213, 239, 109>, <213, 109, 98>,
			<212, 213, 98>, <212, 98, 100>, <221, 212, 100>, <221, 100, 101>,
			<425, 425, 389>, <425, 389, 389>, <354, 372, 292>, <354, 292, 272>,
			<329, 354, 272>, <329, 272, 239>, <303, 329, 239>, <303, 239, 213>,
			<305, 303, 213>, <305, 213, 212>, <322, 305, 212>, <322, 212, 221>,
			<471, 471, 425>, <471, 425, 425>, <474, 476, 372>, <474, 372, 354>,
			<432, 474, 354>, <432, 354, 329>, <453, 432, 329>, <453, 329, 303>,
			<445, 453, 303>, <445, 303, 305>, <441, 445, 305>, <441, 305, 322>,
			<283, 338, 238>, <283, 238, 283>, <338, 304, 257>, <338, 257, 238>,
			<304, 315, 256>, <304, 256, 257>, <315, 330, 236>, <315, 236, 256>,
			<330, 281, 281>, <330, 281, 236>, <89, 131, 135>, <89, 135, 93>,
			<93, 135, 113>, <93, 113, 85>, <93, 85, 77>, <93, 77, 62>,
			<93, 62, 67>, <67, 62, 71>, <67, 71, 26>, <26, 71, 16>,
			<271, 416, 361>, <349, 271, 361>, <123, 207, 188>, <271, 123, 188>,
			<311, 271, 349>, <428, 311, 349>, <201, 123, 271>, <311, 201, 271>,
			<275, 307, 289>, <275, 319, 307>, <311, 275, 201>, <392, 311, 428>,
			<319, 311, 392>, <319, 275, 311>, <135, 131, 159>, <178, 135, 159>,
			<199, 135, 178>, <170, 199, 178>, <174, 170, 178>, <186, 174, 178>,
			<182, 186, 178>, <166, 186, 182>, <238, 166, 182>, <257, 166, 238>,
			<39, 78, 4>, <39, 4, 34>, <52, 42, 123>, <52, 123, 4>,
			<34, 4, 27>, <34, 27, 104>, <4, 123, 48>, <4, 48, 27>,
			<289, 224, 141>, <224, 114, 141>, <48, 141, 27>, <104, 27, 94>,
			<94, 27, 114>, <27, 141, 114>, <133, 129, 87>, <91, 133, 87>,
			<111, 133, 91>, <83, 111, 91>, <75, 83, 91>, <60, 75, 91>,
			<65, 60, 91>, <69, 60, 65>, <24, 69, 65>, <14, 69, 24>,
			<367, 418, 269>, <367, 269, 351>, <190, 209, 119>, <190, 119, 269>,
			<351, 269, 313>, <351, 313, 430>, <269, 119, 203>, <269, 203, 313>,
			<291, 309, 277>, <309, 321, 277>, <203, 277, 313>, <430, 313, 394>,
			<394, 313, 321>, <313, 277, 321>, <153, 129, 133>, <153, 133, 176>,
			<176, 133, 197>, <176, 197, 168>, <176, 168, 172>, <176, 172, 184>,
			<176, 184, 180>, <180, 184, 164>, <180, 164, 236>, <236, 164, 256>,
			<2, 80, 45>, <36, 2, 45>, <119, 44, 54>, <2, 119, 54>,
			<29, 2, 36>, <106, 29, 36>, <50, 119, 2>, <29, 50, 2>,
			<143, 226, 291>, <143, 116, 226>, <29, 143, 50>, <96, 29, 106>,
			<116, 29, 96>, <116, 143, 29>, <361, 416, 418>, <361, 418, 367>,
			<188, 207, 209>, <188, 209, 190>, <42, 52, 54>, <42, 54, 44>,
			<78, 39, 45>, <78, 45, 80>, <627, 671, 572>, <627, 572, 627>,
			<671, 644, 593>, <671, 593, 572>, <644, 651, 592>, <644, 592, 593>,
			<651, 658, 569>, <651, 569, 592>, <658, 625, 625>, <658, 625, 569>,
			<424, 462, 464>, <424, 464, 406>, <406, 464, 420>, <406, 420, 410>,
			<406, 410, 402>, <406, 402, 380>, <406, 380, 386>, <386, 380, 398>,
			<386, 398, 338>, <338, 398, 304>, <613, 751, 697>, <688, 613, 697>,
			<458, 543, 532>, <613, 458, 532>, <646, 613, 688>, <769, 646, 688>,
			<537, 458, 613>, <646, 537, 613>, <574, 555, 436>, <574, 621, 555>,
			<646, 574, 537>, <713, 646, 769>, <621, 646, 713>, <621, 574, 646>,
			<464, 462, 486>, <504, 464, 486>, <494, 464, 504>, <500, 494, 504>,
			<508, 500, 504>, <530, 508, 504>, <524, 530, 504>, <512, 530, 524>,
			<572, 512, 524>, <593, 512, 572>, <205, 155, 297>, <205, 297, 218>,
			<374, 363, 458>, <374, 458, 297>, <218, 297, 260>, <218, 260, 137>,
			<297, 458, 369>, <297, 369, 260>, <436, 347, 332>, <347, 285, 332>,
			<369, 332, 260>, <137, 260, 193>, <193, 260, 285>, <260, 332, 285>,
			<444, 448, 422>, <404, 444, 422>, <414, 444, 404>, <408, 414, 404>,
			<400, 408, 404>, <378, 400, 404>, <384, 378, 404>, <396, 378, 384>,
			<330, 396, 384>, <315, 396, 330>, <703, 753, 611>, <703, 611, 690>,
			<534, 545, 452>, <534, 452, 611>, <690, 611, 648>, <690, 648, 771>,
			<611, 452, 539>, <611, 539, 648>, <470, 561, 576>, <561, 623, 576>,
			<539, 576, 648>, <771, 648, 715>, <715, 648, 623>, <648, 576, 623>,
			<484, 448, 444>, <484, 444, 502>, <502, 444, 488>, <502, 488, 498>,
			<502, 498, 506>, <502, 506, 528>, <502, 528, 522>, <522, 528, 510>,
			<522, 510, 569>, <569, 510, 592>, <295, 157, 211>, <220, 295, 211>,
			<452, 365, 376>, <295, 452, 376>, <262, 295, 220>, <139, 262, 220>,
			<371, 452, 295>, <262, 371, 295>, <334, 353, 470>, <334, 287, 353>,
			<262, 334, 371>, <195, 262, 139>, <287, 262, 195>, <287, 334, 262>,
			<697, 751, 753>, <697, 753, 703>, <532, 543, 545>, <532, 545, 534>,
			<363, 374, 376>, <363, 376, 365>, <155, 205, 211>, <155, 211, 157>,
			<895, 882, 883>, <895, 883, 895>, <882, 896, 893>, <882, 893, 883>,
			<896, 891, 892>, <896, 892, 893>, <891, 890, 881>, <891, 881, 892>,
			<890, 894, 894>, <890, 894, 881>, <755, 779, 775>, <755, 775, 732>,
			<732, 775, 711>, <732, 711, 740>, <732, 740, 736>, <732, 736, 724>,
			<732, 724, 728>, <728, 724, 744>, <728, 744, 671>, <671, 744, 644>,
			<906, 826, 861>, <870, 906, 861>, <789, 864, 854>, <906, 789, 854>,
			<877, 906, 870>, <800, 877, 870>, <858, 789, 906>, <877, 858, 906>,
			<765, 682, 617>, <765, 790, 682>, <877, 765, 858>, <810, 877, 800>,
			<790, 877, 810>, <790, 765, 877>, <775, 779, 821>, <817, 775, 821>,
			<797, 775, 817>, <825, 797, 817>, <833, 825, 817>, <847, 833, 817>,
			<843, 847, 817>, <839, 847, 843>, <883, 839, 843>, <893, 839, 883>,
			<541, 490, 639>, <541, 639, 557>, <718, 699, 789>, <718, 789, 639>,
			<557, 639, 595>, <557, 595, 478>, <639, 789, 705>, <639, 705, 595>,
			<617, 599, 631>, <599, 587, 631>, <705, 631, 595>, <478, 595, 514>,
			<514, 595, 587>, <595, 631, 587>, <773, 777, 749>, <730, 773, 749>,
			<709, 773, 730>, <738, 709, 730>, <734, 738, 730>, <722, 734, 730>,
			<726, 722, 730>, <742, 722, 726>, <658, 742, 726>, <651, 742, 658>,
			<867, 828, 904>, <867, 904, 872>, <856, 866, 785>, <856, 785, 904>,
			<872, 904, 879>, <872, 879, 802>, <904, 785, 860>, <904, 860, 879>,
			<619, 684, 767>, <684, 792, 767>, <860, 767, 879>, <802, 879, 812>,
			<812, 879, 792>, <879, 767, 792>, <819, 777, 773>, <819, 773, 815>,
			<815, 773, 795>, <815, 795, 823>, <815, 823, 831>, <815, 831, 845>,
			<815, 845, 841>, <841, 845, 837>, <841, 837, 881>, <881, 837, 892>,
			<637, 492, 547>, <559, 637, 547>, <785, 701, 720>, <637, 785, 720>,
			<597, 637, 559>, <480, 597, 559>, <707, 785, 637>, <597, 707, 637>,
			<633, 601, 619>, <633, 589, 601>, <597, 633, 707>, <516, 597, 480>,
			<589, 597, 516>, <589, 633, 597>, <861, 826, 828>, <861, 828, 867>,
			<854, 864, 866>, <854, 866, 856>, <699, 718, 720>, <699, 720, 701>,
			<490, 541, 547>, <490, 547, 492>, <626, 571, 670>, <626, 670, 626>,
			<571, 603, 652>, <571, 652, 670>, <603, 591, 650>, <603, 650, 652>,
			<591, 577, 669>, <591, 669, 650>, <577, 624, 624>, <577, 624, 669>,
			<820, 778, 774>, <820, 774, 816>, <816, 774, 796>, <816, 796, 824>,
			<816, 824, 832>, <816, 832, 846>, <816, 846, 842>, <842, 846, 838>,
			<842, 838, 882>, <882, 838, 896>, <638, 489, 540>, <556, 638, 540>,
			<788, 698, 717>, <638, 788, 717>, <594, 638, 556>, <477, 594, 556>,
			<704, 788, 638>, <594, 704, 638>, <630, 598, 616>, <630, 586, 598>,
			<594, 630, 704>, <513, 594, 477>, <586, 594, 513>, <586, 630, 594>,
			<774, 778, 754>, <731, 774, 754>, <710, 774, 731>, <739, 710, 731>,
			<735, 739, 731>, <723, 735, 731>, <727, 723, 731>, <743, 723, 727>,
			<670, 743, 727>, <652, 743, 670>, <862, 827, 905>, <862, 905, 871>,
			<853, 863, 788>, <853, 788, 905>, <871, 905, 878>, <871, 878, 801>,
			<905, 788, 857>, <905, 857, 878>, <616, 681, 764>, <681, 791, 764>,
			<857, 764, 878>, <801, 878, 811>, <811, 878, 791>, <878, 764, 791>,
			<772, 776, 818>, <814, 772, 818>, <794, 772, 814>, <822, 794, 814>,
			<830, 822, 814>, <844, 830, 814>, <840, 844, 814>, <836, 844, 840>,
			<890, 836, 840>, <891, 836, 890>, <546, 491, 636>, <546, 636, 558>,
			<719, 700, 784>, <719, 784, 636>, <558, 636, 596>, <558, 596, 479>,
			<636, 784, 706>, <636, 706, 596>, <618, 600, 632>, <600, 588, 632>,
			<706, 632, 596>, <479, 596, 515>, <515, 596, 588>, <596, 632, 588>,
			<748, 776, 772>, <748, 772, 729>, <729, 772, 708>, <729, 708, 737>,
			<729, 737, 733>, <729, 733, 721>, <729, 721, 725>, <725, 721, 741>,
			<725, 741, 669>, <669, 741, 650>, <903, 829, 868>, <873, 903, 868>,
			<784, 865, 855>, <903, 784, 855>, <880, 903, 873>, <803, 880, 873>,
			<859, 784, 903>, <880, 859, 903>, <766, 683, 618>, <766, 793, 683>,
			<880, 766, 859>, <813, 880, 803>, <793, 880, 813>, <793, 766, 880>,
			<540, 489, 491>, <540, 491, 546>, <717, 698, 700>, <717, 700, 719>,
			<863, 853, 855>, <863, 855, 865>, <827, 862, 868>, <827, 868, 829>,
			<282, 237, 337>, <282, 337, 282>, <237, 263, 316>, <237, 316, 337>,
			<263, 255, 314>, <263, 314, 316>, <255, 249, 335>, <255, 335, 314>,
			<249, 280, 280>, <249, 280, 335>, <485, 461, 463>, <485, 463, 503>,
			<503, 463, 493>, <503, 493, 499>, <503, 499, 507>, <503, 507, 529>,
			<503, 529, 523>, <523, 529, 511>, <523, 511, 571>, <571, 511, 603>,
			<296, 154, 204>, <217, 296, 204>, <457, 362, 373>, <296, 457, 373>,
			<259, 296, 217>, <136, 259, 217>, <368, 457, 296>, <259, 368, 296>,
			<331, 346, 435>, <331, 284, 346>, <259, 331, 368>, <192, 259, 136>,
			<284, 259, 192>, <284, 331, 259>, <463, 461, 423>, <405, 463, 423>,
			<419, 463, 405>, <409, 419, 405>, <401, 409, 405>, <379, 401, 405>,
			<385, 379, 405>, <397, 379, 385>, <337, 397, 385>, <316, 397, 337>,
			<696, 750, 612>, <696, 612, 687>, <531, 542, 457>, <531, 457, 612>,
			<687, 612, 645>, <687, 645, 768>, <612, 457, 536>, <612, 536, 645>,
			<435, 554, 573>, <554, 620, 573>, <536, 573, 645>, <768, 645, 712>,
			<712, 645, 620>, <645, 573, 620>, <443, 447, 483>, <501, 443, 483>,
			<487, 443, 501>, <497, 487, 501>, <505, 497, 501>, <527, 505, 501>,
			<521, 527, 501>, <509, 527, 521>, <577, 509, 521>, <591, 509, 577>,
			<210, 156, 294>, <210, 294, 219>, <375, 364, 451>, <375, 451, 294>,
			<219, 294, 261>, <219, 261, 138>, <294, 451, 370>, <294, 370, 261>,
			<469, 352, 333>, <352, 286, 333>, <370, 333, 261>, <138, 261, 194>,
			<194, 261, 286>, <261, 333, 286>, <421, 447, 443>, <421, 443, 403>,
			<403, 443, 413>, <403, 413, 407>, <403, 407, 399>, <403, 399, 377>,
			<403, 377, 383>, <383, 377, 395>, <383, 395, 335>, <335, 395, 314>,
			<610, 752, 702>, <689, 610, 702>, <451, 544, 533>, <610, 451, 533>,
			<647, 610, 689>, <770, 647, 689>, <538, 451, 610>, <647, 538, 610>,
			<575, 560, 469>, <575, 622, 560>, <647, 575, 538>, <714, 647, 770>,
			<622, 647, 714>, <622, 575, 647>, <204, 154, 156>, <204, 156, 210>,
			<373, 362, 364>, <373, 364, 375>, <542, 531, 533>, <542, 533, 544>,
			<750, 696, 702>, <750, 702, 752>, <12, 26, 25>, <12, 25, 12>,
			<26, 16, 15>, <26, 15, 25>, <16, 14, 13>, <16, 13, 15>,
			<14, 24, 23>, <14, 23, 13>, <24, 11, 11>, <24, 11, 23>,
			<158, 130, 134>, <158, 134, 177>, <177, 134, 198>, <177, 198, 169>,
			<177, 169, 173>, <177, 173, 185>, <177, 185, 181>, <181, 185, 165>,
			<181, 165, 237>, <237, 165, 263>, <3, 79, 40>, <35, 3, 40>,
			<122, 41, 51>, <3, 122, 51>, <28, 3, 35>, <105, 28, 35>,
			<47, 122, 3>, <28, 47, 3>, <140, 223, 288>, <140, 115, 223>,
			<28, 140, 47>, <95, 28, 105>, <115, 28, 95>, <115, 140, 28>,
			<134, 130, 88>, <92, 134, 88>, <112, 134, 92>, <84, 112, 92>,
			<76, 84, 92>, <61, 76, 92>, <66, 61, 92>, <70, 61, 66>,
			<25, 70, 66>, <15, 70, 25>, <360, 415, 270>, <360, 270, 348>,
			<187, 206, 122>, <187, 122, 270>, <348, 270, 310>, <348, 310, 427>,
			<270, 122, 200>, <270, 200, 310>, <288, 306, 274>, <306, 318, 274>,
			<200, 274, 310>, <427, 310, 391>, <391, 310, 318>, <310, 274, 318>,
			<132, 128, 152>, <175, 132, 152>, <196, 132, 175>, <167, 196, 175>,
			<171, 167, 175>, <183, 171, 175>, <179, 183, 175>, <163, 183, 179>,
			<249, 163, 179>, <255, 163, 249>, <46, 81, 1>, <46, 1, 37>,
			<53, 43, 118>, <53, 118, 1>, <37, 1, 30>, <37, 30, 107>,
			<1, 118, 49>, <1, 49, 30>, <290, 225, 142>, <225, 117, 142>,
			<49, 142, 30>, <107, 30, 97>, <97, 30, 117>, <30, 142, 117>,
			<86, 128, 132>, <86, 132, 90>, <90, 132, 110>, <90, 110, 82>,
			<90, 82, 74>, <90, 74, 59>, <90, 59, 64>, <64, 59, 68>,
			<64, 68, 23>, <23, 68, 13>, <268, 417, 366>, <350, 268, 366>,
			<118, 208, 189>, <268, 118, 189>, <312, 268, 350>, <429, 312, 350>,
			<202, 118, 268>, <312, 202, 268>, <276, 308, 290>, <276, 320, 308>,
			<312, 276, 202>, <393, 312, 429>, <320, 312, 393>, <320, 276, 312>,
			<40, 79, 81>, <40, 81, 46>, <51, 41, 43>, <51, 43, 53>,
			<206, 187, 189>, <206, 189, 208>, <415, 360, 366>, <415, 366, 417>,
			<473, 473, 473>, <473, 473, 473>, <473, 473, 473>, <473, 473, 473>,
			<453, 453, 453>, <453, 453, 453>, <434, 434, 434>, <434, 434, 434>,
			<455, 455, 455>, <455, 455, 455>, <434, 434, 434>, <434, 434, 434>,
			<434, 434, 434>, <434, 434, 434>, <473, 473, 473>, <473, 473, 473>,
			<473, 473, 473>, <473, 473, 473>, <0, 0, 0>, <0, 0, 0>,
			<434, 434, 434>, <434, 434, 434>, <907, 907, 907>, <907, 907, 907>,
			<434, 434, 434>, <434, 434, 434>, <434, 434, 434>, <434, 434, 434>,
			<473, 473, 473>, <473, 473, 473>, <473, 473, 473>, <473, 473, 473>,
			<455, 455, 455>, <455, 455, 455>, <434, 434, 434>, <434, 434, 434>,
			<453, 453, 453>, <453, 453, 453>, <434, 434, 434>, <434, 434, 434>,
			<434, 434, 434>, <434, 434, 434>, <473, 473, 473>, <473, 473, 473>,
			<473, 473, 473>, <473, 473, 473>, <907, 907, 907>, <907, 907, 907>,
			<434, 434, 434>, <434, 434, 434>, <0, 0, 0>, <0, 0, 0>,
			<434, 434, 434>, <434, 434, 434>, <434, 434, 434>, <434, 434, 434>
		}
	}
}
#end

#include "lg_3062b.inc" // Brick  1 x  1 Round with Hollow Stud

#include "lg_4740.inc" // Dish  2 x  2 Inverted

#declare LDX_infrastructure_streetlamp_2_dot_ldr = union {
// Street Lamp Mk2
// Name: infrastructure_streetlamp_2.ldr
// Author: Michael Horvath
// Unofficial Datsville Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		LDX_2039_dot_dat
		LDXSeamMatrix(40, 172, 40, 0, 82, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-168,0>
	}
	object {
		lg_3062b_clear
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-192,0>
		#if (version >= 3.1) material #else texture #end { LDXColor47 }
	}
	object {
		lg_4740
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		matrix <1,0,0,0,1,0,0,0,1,0,-200,0>
	}
}

#declare LDX_4_dash_4cylc_dot_dat_in_part = union {
// Cylinder Closed 1.0
// Name: 4-4cylc.dat
// Author: Alex Taylor [anathema]
// !LDRAW_ORG Primitive UPDATE 2009-02
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CCW
// !HISTORY 2008-12-29 [cwdee] Removed one disc
// !HISTORY 2009-09-03 [PTadmin] Official Update 2009-02
	object {
		LDX_4_dash_4disc_dot_dat_in_part
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
	}
	object {
		LDX_4_dash_4cyli_dot_dat_in_part
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
	}
}

#declare LDX_4_dash_4ring1_dot_dat_in_part = disc // Ring 1
{
	<0,0,0>,<0,1,0>,2,1
}

#declare LDX_4_dash_4ring1_dot_dat = disc // Ring 1
{
	<0,0,0>,<0,1,0>,2,1
}

#declare LDX_t02i4000_dot_dat_in_part = torus // Torus 0.5
{
	1,0.40000000596046447754
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		cylinder
		{
			<0,0,0>,<0,1,0>,1		}
	}
}

#declare LDX_t02i4000_dot_dat = torus // Torus 0.5
{
	1,0.40000000596046447754
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		cylinder
		{
			<0,0,0>,<0,1,0>,1		}
	}
}

#declare LDX_t04o2000_dot_dat_in_part = torus // Torus 0.25
{
	1,0.20000000298023223877
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o2000_dot_dat = torus // Torus 0.25
{
	1,0.20000000298023223877
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_4_dash_4cylo_dot_dat_in_part = union {
// Cylinder Open 1.0
// Name: 4-4cylo.dat
// Author: Mark Kennedy [mkennedy]
// !LDRAW_ORG Primitive UPDATE 2010-01
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CCW
// !HISTORY 2010-04-05 [PTadmin] Official Update 2010-01
	object {
		LDX_4_dash_4cyli_dot_dat_in_part
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
	}
}

#declare LDX_t02i4000_dot_dat_in_part = torus // Torus 0.5
{
	1,0.40000000596046447754
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		cylinder
		{
			<0,0,0>,<0,1,0>,1		}
	}
}

#declare LDX_t02i4000_dot_dat = torus // Torus 0.5
{
	1,0.40000000596046447754
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		cylinder
		{
			<0,0,0>,<0,1,0>,1		}
	}
}

#declare LDX_t02i4000_dot_dat_in_part = torus // Torus 0.5
{
	1,0.40000000596046447754
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		cylinder
		{
			<0,0,0>,<0,1,0>,1		}
	}
}

#declare LDX_t02i4000_dot_dat = torus // Torus 0.5
{
	1,0.40000000596046447754
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		cylinder
		{
			<0,0,0>,<0,1,0>,1		}
	}
}

#declare LDX_t04o2000_dot_dat_in_part = torus // Torus 0.25
{
	1,0.20000000298023223877
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o2000_dot_dat = torus // Torus 0.25
{
	1,0.20000000298023223877
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o2000_dot_dat_in_part = torus // Torus 0.25
{
	1,0.20000000298023223877
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o2000_dot_dat = torus // Torus 0.25
{
	1,0.20000000298023223877
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o2000_dot_dat_in_part = torus // Torus 0.25
{
	1,0.20000000298023223877
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o2000_dot_dat = torus // Torus 0.25
{
	1,0.20000000298023223877
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o2000_dot_dat_in_part = torus // Torus 0.25
{
	1,0.20000000298023223877
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o2000_dot_dat = torus // Torus 0.25
{
	1,0.20000000298023223877
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_3470_dot_dat =
#if (LDXQual = 0)
box {
	<-42.82,-135.880005,-42.93>,<42.82,8,42.93>
}
#else
union {
// Plant Tree Oval  4 x  4 x  6
// Name: 3470.dat
// Author: Christian M. Angele [cma_1971]
// !LDRAW_ORG Part UPDATE 2012-01
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CCW
// !HISTORY 1997-12-05 [PTadmin] Official Update 1997-17
// !HISTORY 1998-01-12 [PTadmin] Official Update 1998-01
// !HISTORY 1999-03-26 [PTadmin] Official Update 1999-02
// !HISTORY 1999-05-24 [PTadmin] Official Update 1999-04
// !HISTORY 2007-06-25 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
// !HISTORY 2010-06-20 [BlackBrick89] Made BFC compliant
// !HISTORY 2011-02-02 [Philo] Many small improvements
// !HISTORY 2012-03-30 [PTadmin] Official Update 2012-01
// // base plate
	#if (LDXStuds)
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,-1,0,4,0>
		}
	#end // LDXStuds
	object {
		LDX_4_dash_4ring5_dot_dat_in_part
		matrix <4,0,0,0,-1,0,0,0,4,0,8,0>
	}
// BFC INVERTNEXT
	object {
		LDX_4_dash_4cylc_dot_dat_in_part
		matrix <20,0,0,0,4,0,0,0,20,0,4,0>
	}
	object {
		LDX_4_dash_4cyli_dot_dat_in_part
		matrix <24,0,0,0,4,0,0,0,24,0,4,0>
	}
	object {
		LDX_4_dash_4ring1_dot_dat_in_part
		matrix <10,0,0,0,1,0,0,0,10,0,0,0>
	}
// BFC INVERTNEXT
	object {
		LDX_t02i4000_dot_dat_in_part
		matrix <10,0,0,0,10,0,0,0,10,0,-4,0>
	}
// BFC INVERTNEXT
	object {
		LDX_t02i4000_dot_dat_in_part
		matrix <-10,0,0,0,10,0,0,0,-10,0,-4,0>
	}
	object {
		LDX_t04o2000_dot_dat_in_part
		matrix <20,0,0,0,-20,0,0,0,20,0,4,0>
	}
	object {
		LDX_t04o2000_dot_dat_in_part
		matrix <0,0,20,0,-20,0,-20,0,0,0,4,0>
	}
	object {
		LDX_t04o2000_dot_dat_in_part
		matrix <-20,0,0,0,-20,0,0,0,-20,0,4,0>
	}
	object {
		LDX_t04o2000_dot_dat_in_part
		matrix <0,0,-20,0,-20,0,20,0,0,0,4,0>
	}
// //
// // y-axis: stud: 45
// //
	object {
		LDX_4_dash_4cyli_dot_dat_in_part
		matrix <6,0,0,0,32,0,0,0,6,0,-36,0>
	}
// //
	object {
		LDX_4_dash_4cylo_dot_dat_in_part
		matrix <6,0,0,0,6,0,0,0,6,0,-46,0>
	}
	object {
		LDX_4_dash_4cylo_dot_dat_in_part
		matrix <5.5,0,0,0,6,0,0,0,5.5,0,-58,0>
	}
	object {
		LDX_4_dash_4cylo_dot_dat_in_part
		matrix <5.5,0,0,0,6,0,0,0,5.5,0,-70,0>
	}
	object {
		LDX_4_dash_4cylo_dot_dat_in_part
		matrix <5.5,0,0,0,6,0,0,0,5.5,0,-82,0>
	}
	object {
		LDX_4_dash_4cylo_dot_dat_in_part
		matrix <5.5,0,0,0,6,0,0,0,5.5,0,-94,0>
	}
	object {
		LDX_4_dash_4cylo_dot_dat_in_part
		matrix <5,0,0,0,6,0,0,0,5,0,-106,0>
	}
	object {
		LDX_4_dash_4cylo_dot_dat_in_part
		matrix <5,0,0,0,6,0,0,0,5,0,-118,0>
	}
	object {
		LDX_4_dash_4cylo_dot_dat_in_part
		matrix <4,0,0,0,6,0,0,0,4,0,-130,0>
	}
// // z-axis: plate
// //
// //
// //
// // x-axis: box: 45 3
// //
// //
// // z-axis: slope: 45 -11
// //
// //
// // z-axis: slope neg: 45 -11
// //
// //
// // z-axis: box: 45 -11
// //
// //
// // x-axis: box: 45 -11
// //
// //
// // x-axis: box: 33 17
// //
// //
// // z-axis: box: 33 3
// //
// //
// // x-axis: box: 33 3
// //
// //
// // z-axis: box: 33 -11
// //
// //
// // x-axis: box: 33 -11
// //
// //
// // z-axis: slope: 33 -25
// //
// //
// // z-axis: slope neg: 33 -25
// //
// //
// // z-axis: box: 33 -25
// //
// //
// // x-axis: box: 33 -25
// //
// //
// // x-axis: box: 21 31
// //
// //
// // x-axis: slope: 21 31
// //
// //
// // z-axis: box: 21 17
// //
// //
// // x-axis: box: 21 17
// //
// //
// // z-axis: box: 21 3
// //
// //
// // x-axis: box: 21 3
// //
// //
// // z-axis: box: 21 -11
// //
// //
// // x-axis: box: 21 -11
// //
// //
// // z-axis: box: 21 -25
// //
// //
// // x-axis: box: 21 -25
// //
// //
// // z-axis: box: 21 -39
// //
// //
// // x-axis: slope: 21 -39
// //
// //
// // x-axis: box: 21 -39
// //
// //
// // x-axis: box: 9 31
// //
// //
// // x-axis: slope: 9 31
// //
// //
// // z-axis: box: 9 17
// //
// //
// // x-axis: box: 9 17
// //
// //
// // z-axis: box: 9 3
// //
// //
// // x-axis: box: 9 3
// //
// //
// // z-axis: box: 9 -11
// //
// //
// // x-axis: box: 9 -11
// //
// //
// // z-axis: box: 9 -25
// //
// //
// // x-axis: box: 9 -25
// //
// //
// // z-axis: box: 9 -39
// //
// //
// // x-axis: slope: 9 -39
// //
// //
// // x-axis: box: 9 -39
// //
// //
// // x-axis: box: -3 31
// //
// //
// // x-axis: slope: -3 31
// //
// //
// // z-axis: box: -3 17
// //
// //
// // x-axis: box: -3 17
// //
// //
// // z-axis: box: -3 3
// //
// //
// // x-axis: box: -3 3
// //
// //
// // z-axis: box: -3 -11
// //
// //
// // x-axis: box: -3 -11
// //
// //
// // z-axis: box: -3 -25
// //
// //
// // x-axis: box: -3 -25
// //
// //
// // z-axis: box: -3 -39
// //
// //
// // x-axis: slope: -3 -39
// //
// //
// // x-axis: box: -3 -39
// //
// //
// // x-axis: box: -15 31
// //
// //
// // x-axis: slope: -15 31
// //
// //
// // z-axis: box: -15 17
// //
// //
// // x-axis: box: -15 17
// //
// //
// // z-axis: box: -15 3
// //
// //
// // x-axis: box: -15 3
// //
// //
// // z-axis: box: -15 -11
// //
// //
// // x-axis: box: -15 -11
// //
// //
// // z-axis: box: -15 -25
// //
// //
// // x-axis: box: -15 -25
// //
// //
// // z-axis: box: -15 -39
// //
// //
// // x-axis: slope: -15 -39
// //
// //
// // x-axis: box: -15 -39
// //
// //
// // x-axis: box: -27 31
// //
// //
// // x-axis: slope: -27 31
// //
// //
// // z-axis: box: -27 17
// //
// //
// // x-axis: box: -27 17
// //
// //
// // z-axis: box: -27 3
// //
// //
// // x-axis: box: -27 3
// //
// //
// // z-axis: box: -27 -11
// //
// //
// // x-axis: box: -27 -11
// //
// //
// // z-axis: box: -27 -25
// //
// //
// // x-axis: box: -27 -25
// //
// //
// // z-axis: box: -27 -39
// //
// //
// // x-axis: slope: -27 -39
// //
// //
// // x-axis: box: -27 -39
// //
// //
// // x-axis: box: -39 17
// //
// //
// // z-axis: box: -39 3
// //
// //
// // x-axis: box: -39 3
// //
// // z-axis: box: -39 -11
// //
// //
// // x-axis: box: -39 -11
// //
// //
// // z-axis: slope: -39 -25
// //
// //
// // z-axis: slope neg: -39 -25
// //
// //
// // z-axis: box: -39 -25
// //
// //
// // x-axis: box: -39 -25
// //
// //
// // x-axis: box: -51 3
// //
// //
// // z-axis: slope: -51 -11
// //
// //
// // z-axis: slope neg: -51 -11
// //
// //
// // z-axis: box: -51 -11
// //
// //
// // x-axis: box: -51 -11
// //
// //
// //
	mesh2 {
		vertex_vectors {
			802,
			<-42.82,-88,-3>, <-42.82,-88,3>, <-42.82,-82,-3>, <-42.82,-82,3>,
			<-42.220001,-94,-3>, <-42.220001,-94,3>, <-42.220001,-76,-3>, <-42.220001,-76,3>,
			<-41.5,-88,-11>, <-41.5,-88,11>, <-41.5,-82,-11>, <-41.5,-82,11>,
			<-41,-100,-3>, <-41,-100,3>, <-41,-70,-3>, <-41,-70,3>,
			<-40.919998,-94,-11>, <-40.919998,-94,11>, <-40.919998,-76,-11>, <-40.919998,-76,11>,
			<-39.73,-100,-11>, <-39.73,-100,11>, <-39.73,-70,-11>, <-39.73,-70,11>,
			<-39.43,-88,-17>, <-39.43,-88,17>, <-39.43,-82,-17>, <-39.43,-82,17>,
			<-39.09,-106,-3>, <-39.09,-106,3>, <-39.09,-64,-3>, <-39.09,-64,3>,
			<-38.880001,-94,-17>, <-38.880001,-94,17>, <-38.880001,-76,-17>, <-38.880001,-76,17>,
			<-37.880001,-106,-11>, <-37.880001,-106,11>, <-37.880001,-64,-11>, <-37.880001,-64,11>,
			<-37.75,-100,-17>, <-37.75,-100,17>, <-37.75,-70,-17>, <-37.75,-70,17>,
			<-36.389999,-112,-3>, <-36.389999,-112,3>, <-36.389999,-58,-3>, <-36.389999,-58,3>,
			<-35.990002,-106,-17>, <-35.990002,-106,17>, <-35.990002,-64,-17>, <-35.990002,-64,17>,
			<-35.27,-112,-11>, <-35.27,-112,11>, <-35.27,-58,-11>, <-35.27,-58,11>,
			<-34.93,-88,-25>, <-34.93,-88,25>, <-34.93,-82,-25>, <-34.93,-82,25>,
			<-34.439999,-94,-25>, <-34.439999,-94,25>, <-34.439999,-76,-25>, <-34.439999,-76,25>,
			<-33.509998,-112,-17>, <-33.509998,-112,17>, <-33.509998,-58,-17>, <-33.509998,-58,17>,
			<-33.439999,-100,-25>, <-33.439999,-100,25>, <-33.439999,-70,-25>, <-33.439999,-70,25>,
			<-32.709999,-118,-3>, <-32.709999,-118,3>, <-32.709999,-52,-3>, <-32.709999,-52,3>,
			<-31.879999,-106,-25>, <-31.879999,-106,25>, <-31.879999,-64,-25>, <-31.879999,-64,25>,
			<-31.690001,-118,-11>, <-31.690001,-118,11>, <-31.690001,-52,-11>, <-31.690001,-52,11>,
			<-30.110001,-118,-17>, <-30.110001,-118,17>, <-30.110001,-52,-17>, <-30.110001,-52,17>,
			<-29.75,-88,-31>, <-29.75,-88,31>, <-29.75,-82,-31>, <-29.75,-82,31>,
			<-29.68,-112,-25>, <-29.68,-112,25>, <-29.68,-58,-25>, <-29.68,-58,25>,
			<-29.33,-94,-31>, <-29.33,-94,31>, <-29.33,-76,-31>, <-29.33,-76,31>,
			<-28.48,-100,-31>, <-28.48,-100,31>, <-28.48,-70,-31>, <-28.48,-70,31>,
			<-27.639999,-124,-3>, <-27.639999,-124,3>, <-27.639999,-46,-3>, <-27.639999,-46,3>,
			<-27.16,-106,-31>, <-27.16,-106,31>, <-27.16,-64,-31>, <-27.16,-64,31>,
			<-26.790001,-124,-11>, <-26.790001,-124,11>, <-26.790001,-46,-11>, <-26.790001,-46,11>,
			<-26.67,-118,-25>, <-26.67,-118,25>, <-26.67,-52,-25>, <-26.67,-52,25>,
			<-25.450001,-124,-17>, <-25.450001,-124,17>, <-25.450001,-46,-17>, <-25.450001,-46,17>,
			<-25.280001,-112,-31>, <-25.280001,-112,31>, <-25.280001,-58,-31>, <-25.280001,-58,31>,
			<-22.540001,-124,-25>, <-22.540001,-124,25>, <-22.540001,-46,-25>, <-22.540001,-46,25>,
			<-20.190001,-130,-3>, <-20.190001,-130,3>, <-20.190001,-40,-3>, <-20.190001,-40,3>,
			<-19.559999,-130,-11>, <-19.559999,-130,11>, <-19.559999,-40,-11>, <-19.559999,-40,11>,
			<-18.08,-88,-39>, <-18.08,-88,39>, <-18.08,-82,-39>, <-18.08,-82,39>,
			<-17.83,-94,-39>, <-17.83,-94,39>, <-17.83,-76,-39>, <-17.83,-76,39>,
			<-17.309999,-100,-39>, <-17.309999,-100,39>, <-17.309999,-70,-39>, <-17.309999,-70,39>,
			<-16.5,-106,-39>, <-16.5,-106,39>, <-16.5,-64,-39>, <-16.5,-64,39>,
			<-15.36,-112,-36.48>, <-15.36,-112,36.48>, <-15.36,-58,-36.48>, <-15.36,-58,36.48>,
			<-9.5,-124,-3>, <-9.5,-124,3>, <-9.5,-118,-3>, <-9.5,-118,3>,
			<-9.5,-112,-3>, <-9.5,-112,3>, <-9.5,-106,-3>, <-9.5,-106,3>,
			<-9.5,-100,-3>, <-9.5,-100,3>, <-9.5,-94,-3>, <-9.5,-94,3>,
			<-9.5,-88,-3>, <-9.5,-88,3>, <-9.5,-82,-3>, <-9.5,-82,3>,
			<-9.5,-76,-3>, <-9.5,-76,3>, <-9.5,-70,-3>, <-9.5,-70,3>,
			<-9.5,-64,-3>, <-9.5,-64,3>, <-9.5,-58,-3>, <-9.5,-58,3>,
			<-9.5,-52,-3>, <-9.5,-52,3>, <-9.5,-46,-3>, <-9.5,-46,3>,
			<-8,-40,-3>, <-8,-40,3>, <-8,-34.119999,-3>, <-8,-34.119999,3>,
			<-7,-124,-17>, <-7,-124,-11>, <-7,-124,11>, <-7,-124,17>,
			<-7,-118,-17>, <-7,-118,-11>, <-7,-118,11>, <-7,-118,17>,
			<-7,-112,-17>, <-7,-112,-11>, <-7,-112,11>, <-7,-112,17>,
			<-7,-106,-17>, <-7,-106,-11>, <-7,-106,11>, <-7,-106,17>,
			<-7,-100,-17>, <-7,-100,-11>, <-7,-100,11>, <-7,-100,17>,
			<-7,-94,-17>, <-7,-94,-11>, <-7,-94,11>, <-7,-94,17>,
			<-7,-88,-17>, <-7,-88,-11>, <-7,-88,11>, <-7,-88,17>,
			<-7,-82,-17>, <-7,-82,-11>, <-7,-82,11>, <-7,-82,17>,
			<-7,-76,-17>, <-7,-76,-11>, <-7,-76,11>, <-7,-76,17>,
			<-7,-70,-17>, <-7,-70,-11>, <-7,-70,11>, <-7,-70,17>,
			<-7,-64,-17>, <-7,-64,-11>, <-7,-64,11>, <-7,-64,17>,
			<-7,-58,-17>, <-7,-58,-11>, <-7,-58,11>, <-7,-58,17>,
			<-7,-52,-17>, <-7,-52,-11>, <-7,-52,11>, <-7,-52,17>,
			<-7,-46,-17>, <-7,-46,-11>, <-7,-46,11>, <-7,-46,17>,
			<-6,-135.880005,-3>, <-6,-135.880005,3>, <-6,-130,-3>, <-6,-130,3>,
			<-4.5,-112,-31>, <-4.5,-112,-25>, <-4.5,-112,25>, <-4.5,-112,31>,
			<-4.5,-106,-31>, <-4.5,-106,-25>, <-4.5,-106,25>, <-4.5,-106,31>,
			<-4.5,-100,-31>, <-4.5,-100,-25>, <-4.5,-100,25>, <-4.5,-100,31>,
			<-4.5,-94,-31>, <-4.5,-94,-25>, <-4.5,-94,25>, <-4.5,-94,31>,
			<-4.5,-88,-31>, <-4.5,-88,-25>, <-4.5,-88,25>, <-4.5,-88,31>,
			<-4.5,-82,-31>, <-4.5,-82,-25>, <-4.5,-82,25>, <-4.5,-82,31>,
			<-4.5,-76,-31>, <-4.5,-76,-25>, <-4.5,-76,25>, <-4.5,-76,31>,
			<-4.5,-70,-31>, <-4.5,-70,-25>, <-4.5,-70,25>, <-4.5,-70,31>,
			<-4.5,-64,-31>, <-4.5,-64,-25>, <-4.5,-64,25>, <-4.5,-64,31>,
			<-4.5,-58,-31>, <-4.5,-58,-25>, <-4.5,-58,25>, <-4.5,-58,31>,
			<-3.5,-134.300003,-11>, <-3.5,-134.300003,11>, <-3.5,-130,-20.24>, <-3.5,-130,-11>,
			<-3.5,-130,11>, <-3.5,-130,20.24>, <-3.5,-124,-27.709999>, <-3.5,-124,-25>,
			<-3.5,-124,25>, <-3.5,-124,27.709999>, <-3.5,-118,-32.779999>, <-3.5,-118,-25>,
			<-3.5,-118,25>, <-3.5,-118,32.779999>, <-3.5,-52,-32.779999>, <-3.5,-52,-25>,
			<-3.5,-52,25>, <-3.5,-52,32.779999>, <-3.5,-46,-27.709999>, <-3.5,-46,-25>,
			<-3.5,-46,25>, <-3.5,-46,27.709999>, <-3.5,-40,-20.24>, <-3.5,-40,-11>,
			<-3.5,-40,11>, <-3.5,-40,20.24>, <-3.5,-35.700001,-11>, <-3.5,-35.700001,11>,
			<-1,-135,-4.2>, <-1,-135,4.2>, <-1,-134,-8.4>, <-1,-134,8.4>,
			<-1,-133,-12.18>, <-1,-133,12.18>, <-1,-131,-15.96>, <-1,-131,15.96>,
			<-1,-129,-19.74>, <-1,-129,19.74>, <-1,-126.5,-23.52>, <-1,-126.5,23.52>,
			<-1,-123.5,-26.459999>, <-1,-123.5,26.459999>, <-1,-120.5,-29.82>, <-1,-120.5,29.82>,
			<-1,-116.5,-32.34>, <-1,-116.5,32.34>, <-1,-113,-34.860001>, <-1,-113,34.860001>,
			<-1,-108.5,-36.959999>, <-1,-108.5,36.959999>, <-1,-104,-38.639999>, <-1,-104,38.639999>,
			<-1,-99.5,-40.32>, <-1,-99.5,40.32>, <-1,-95,-41.16>, <-1,-95,41.16>,
			<-1,-90,-42>, <-1,-90,42>, <-1,-85,-42>, <-1,-85,0>,
			<-1,-85,42>, <-1,-80,-42>, <-1,-80,42>, <-1,-75,-41.16>,
			<-1,-75,41.16>, <-1,-70.5,-40.32>, <-1,-70.5,40.32>, <-1,-66,-38.639999>,
			<-1,-66,38.639999>, <-1,-61.5,-36.959999>, <-1,-61.5,36.959999>, <-1,-57,-34.860001>,
			<-1,-57,34.860001>, <-1,-53.5,-32.34>, <-1,-53.5,32.34>, <-1,-49.5,-29.82>,
			<-1,-49.5,29.82>, <-1,-46.5,-26.459999>, <-1,-46.5,26.459999>, <-1,-43.5,-23.52>,
			<-1,-43.5,23.52>, <-1,-41,-19.74>, <-1,-41,19.74>, <-1,-39,-15.96>,
			<-1,-39,15.96>, <-1,-37,-12.18>, <-1,-37,12.18>, <-1,-36,-8.4>,
			<-1,-36,8.4>, <-1,-35,-4.2>, <-1,-35,4.2>, <0,-112,-36.48>,
			<0,-112,36.48>, <0,-106,-39.189999>, <0,-106,-39>, <0,-106,39>,
			<0,-106,39.189999>, <0,-100,-41.099998>, <0,-100,-39>, <0,-100,39>,
			<0,-100,41.099998>, <0,-94,-42.330002>, <0,-94,-39>, <0,-94,39>,
			<0,-94,42.330002>, <0,-88,-42.93>, <0,-88,-39>, <0,-88,39>,
			<0,-88,42.93>, <0,-82,-42.93>, <0,-82,-39>, <0,-82,39>,
			<0,-82,42.93>, <0,-76,-42.330002>, <0,-76,-39>, <0,-76,39>,
			<0,-76,42.330002>, <0,-70,-41.099998>, <0,-70,-39>, <0,-70,39>,
			<0,-70,41.099998>, <0,-64,-39.189999>, <0,-64,-39>, <0,-64,39>,
			<0,-64,39.189999>, <0,-58,-36.48>, <0,-58,36.48>, <1,-135,-4.2>,
			<1,-135,4.2>, <1,-134,-8.4>, <1,-134,8.4>, <1,-133,-12.18>,
			<1,-133,12.18>, <1,-131,-15.96>, <1,-131,15.96>, <1,-129,-19.74>,
			<1,-129,19.74>, <1,-126.5,-23.519999>, <1,-126.5,23.52>, <1,-123.5,-26.459999>,
			<1,-123.5,26.459999>, <1,-120.5,-29.82>, <1,-120.5,29.82>, <1,-116.5,-32.34>,
			<1,-116.5,32.34>, <1,-113,-34.859997>, <1,-113,34.860001>, <1,-108.5,-36.959999>,
			<1,-108.5,36.959999>, <1,-104,-38.639999>, <1,-104,38.639999>, <1,-99.5,-40.32>,
			<1,-99.5,40.32>, <1,-95,-41.160004>, <1,-95,41.160004>, <1,-90,-42>,
			<1,-90,42>, <1,-85,-42>, <1,-85,0>, <1,-85,42>,
			<1,-80,-42>, <1,-80,42>, <1,-75,-41.160004>, <1,-75,41.160004>,
			<1,-70.5,-40.32>, <1,-70.5,40.32>, <1,-66,-38.639999>, <1,-66,38.639999>,
			<1,-61.5,-36.959999>, <1,-61.5,36.959999>, <1,-57,-34.860001>, <1,-57,34.859997>,
			<1,-53.5,-32.34>, <1,-53.5,32.34>, <1,-49.5,-29.82>, <1,-49.5,29.82>,
			<1,-46.5,-26.459999>, <1,-46.5,26.459999>, <1,-43.5,-23.52>, <1,-43.5,23.519999>,
			<1,-41,-19.74>, <1,-41,19.74>, <1,-39,-15.96>, <1,-39,15.96>,
			<1,-37,-12.18>, <1,-37,12.18>, <1,-36,-8.4>, <1,-36,8.4>,
			<1,-35,-4.2>, <1,-35,4.2>, <3.5,-134.300003,-11>, <3.5,-134.300003,11>,
			<3.5,-130,-20.24>, <3.5,-130,-11>, <3.5,-130,11>, <3.5,-130,20.24>,
			<3.5,-124,-27.709999>, <3.5,-124,-25>, <3.5,-124,25>, <3.5,-124,27.709999>,
			<3.5,-118,-32.779999>, <3.5,-118,-25>, <3.5,-118,25>, <3.5,-118,32.779999>,
			<3.5,-52,-32.779999>, <3.5,-52,-25>, <3.5,-52,25>, <3.5,-52,32.779999>,
			<3.5,-46,-27.709999>, <3.5,-46,-25>, <3.5,-46,25>, <3.5,-46,27.709999>,
			<3.5,-40,-20.24>, <3.5,-40,-11>, <3.5,-40,11>, <3.5,-40,20.24>,
			<3.5,-35.700001,-11>, <3.5,-35.700001,11>, <4.5,-112,-31>, <4.5,-112,-25>,
			<4.5,-112,25>, <4.5,-112,31>, <4.5,-106,-31>, <4.5,-106,-25>,
			<4.5,-106,25>, <4.5,-106,31>, <4.5,-100,-31>, <4.5,-100,-25>,
			<4.5,-100,25>, <4.5,-100,31>, <4.5,-94,-31>, <4.5,-94,-25>,
			<4.5,-94,25>, <4.5,-94,31>, <4.5,-88,-31>, <4.5,-88,-25>,
			<4.5,-88,25>, <4.5,-88,31>, <4.5,-82,-31>, <4.5,-82,-25>,
			<4.5,-82,25>, <4.5,-82,31>, <4.5,-76,-31>, <4.5,-76,-25>,
			<4.5,-76,25>, <4.5,-76,31>, <4.5,-70,-31>, <4.5,-70,-25>,
			<4.5,-70,25>, <4.5,-70,31>, <4.5,-64,-31>, <4.5,-64,-25>,
			<4.5,-64,25>, <4.5,-64,31>, <4.5,-58,-31>, <4.5,-58,-25>,
			<4.5,-58,25>, <4.5,-58,31>, <6,-135.880005,-3>, <6,-135.880005,3>,
			<6,-130,-3>, <6,-130,3>, <7,-124,-17>, <7,-124,-11>,
			<7,-124,11>, <7,-124,17>, <7,-118,-17>, <7,-118,-11>,
			<7,-118,11>, <7,-118,17>, <7,-112,-17>, <7,-112,-11>,
			<7,-112,11>, <7,-112,17>, <7,-106,-17>, <7,-106,-11>,
			<7,-106,11>, <7,-106,17>, <7,-100,-17>, <7,-100,-11>,
			<7,-100,11>, <7,-100,17>, <7,-94,-17>, <7,-94,-11>,
			<7,-94,11>, <7,-94,17>, <7,-88,-17>, <7,-88,-11>,
			<7,-88,11>, <7,-88,17>, <7,-82,-17>, <7,-82,-11>,
			<7,-82,11>, <7,-82,17>, <7,-76,-17>, <7,-76,-11>,
			<7,-76,11>, <7,-76,17>, <7,-70,-17>, <7,-70,-11>,
			<7,-70,11>, <7,-70,17>, <7,-64,-17>, <7,-64,-11>,
			<7,-64,11>, <7,-64,17>, <7,-58,-17>, <7,-58,-11>,
			<7,-58,11>, <7,-58,17>, <7,-52,-17>, <7,-52,-11>,
			<7,-52,11>, <7,-52,17>, <7,-46,-17>, <7,-46,-11>,
			<7,-46,11>, <7,-46,17>, <8,-40,-3>, <8,-40,3>,
			<8,-34.119999,-3>, <8,-34.119999,3>, <9.5,-124,-3>, <9.5,-124,3>,
			<9.5,-118,-3>, <9.5,-118,3>, <9.5,-112,-3>, <9.5,-112,3>,
			<9.5,-106,-3>, <9.5,-106,3>, <9.5,-100,-3>, <9.5,-100,3>,
			<9.5,-94,-3>, <9.5,-94,3>, <9.5,-88,-3>, <9.5,-88,3>,
			<9.5,-82,-3>, <9.5,-82,3>, <9.5,-76,-3>, <9.5,-76,3>,
			<9.5,-70,-3>, <9.5,-70,3>, <9.5,-64,-3>, <9.5,-64,3>,
			<9.5,-58,-3>, <9.5,-58,3>, <9.5,-52,-3>, <9.5,-52,3>,
			<9.5,-46,-3>, <9.5,-46,3>, <15.36,-112,-36.48>, <15.36,-112,36.48>,
			<15.36,-58,-36.48>, <15.36,-58,36.48>, <16.5,-106,-39>, <16.5,-106,39>,
			<16.5,-64,-39>, <16.5,-64,39>, <17.309999,-100,-39>, <17.309999,-100,39>,
			<17.309999,-70,-39>, <17.309999,-70,39>, <17.83,-94,-39>, <17.83,-94,39>,
			<17.83,-76,-39>, <17.83,-76,39>, <18.08,-88,-39>, <18.080002,-88,39>,
			<18.08,-82,-39>, <18.080002,-82,39>, <19.559999,-130,-11>, <19.559999,-130,11>,
			<19.559999,-40,-11>, <19.559999,-40,11>, <20.190001,-130,-3>, <20.190001,-130,3>,
			<20.190001,-40,-3>, <20.190001,-40,3>, <22.540001,-124,-25>, <22.540001,-124,25>,
			<22.540001,-46,-25>, <22.540001,-46,25>, <25.280001,-112,-31>, <25.280001,-112,31>,
			<25.280001,-58,-31>, <25.280001,-58,31>, <25.450001,-124,-17>, <25.450001,-124,17>,
			<25.450001,-46,-17>, <25.450001,-46,17>, <26.67,-118,-25>, <26.67,-118,25>,
			<26.67,-52,-25>, <26.67,-52,25>, <26.790001,-124,-11>, <26.790001,-124,11>,
			<26.790001,-46,-11>, <26.790001,-46,11>, <27.16,-106,-31>, <27.16,-106,31>,
			<27.16,-64,-31>, <27.16,-64,31>, <27.639999,-124,-3>, <27.639999,-124,3>,
			<27.639999,-46,-3>, <27.639999,-46,3>, <28.48,-100,-31>, <28.48,-100,31>,
			<28.48,-70,-31>, <28.48,-70,31>, <29.33,-94,-31>, <29.33,-94,31>,
			<29.33,-76,-31>, <29.33,-76,31>, <29.68,-112,-25>, <29.68,-112,25>,
			<29.68,-58,-25>, <29.68,-58,25>, <29.75,-88,-31>, <29.75,-88,31>,
			<29.75,-82,-31>, <29.75,-82,31>, <30.110001,-118,-17>, <30.110001,-118,17>,
			<30.110001,-52,-17>, <30.110001,-52,17>, <31.690001,-118,-11>, <31.690001,-118,11>,
			<31.690001,-52,-11>, <31.690001,-52,11>, <31.879999,-106,-25>, <31.879999,-106,25>,
			<31.879999,-64,-25>, <31.879999,-64,25>, <32.709999,-118,-3>, <32.709999,-118,3>,
			<32.709999,-52,-3>, <32.709999,-52,3>, <33.439999,-100,-25>, <33.439999,-100,25>,
			<33.439999,-70,-25>, <33.439999,-70,25>, <33.509998,-112,-17>, <33.509998,-112,17>,
			<33.509998,-58,-17>, <33.509998,-58,17>, <34.439999,-94,-25>, <34.439999,-94,25>,
			<34.439999,-76,-25>, <34.439999,-76,25>, <34.93,-88,-25>, <34.93,-88,25>,
			<34.93,-82,-25>, <34.93,-82,25>, <35.27,-112,-11>, <35.27,-112,11>,
			<35.27,-58,-11>, <35.27,-58,11>, <35.990002,-106,-17>, <35.990002,-106,17>,
			<35.990002,-64,-17>, <35.990002,-64,17>, <36.389999,-112,-3>, <36.389999,-112,3>,
			<36.389999,-58,-3>, <36.389999,-58,3>, <37.75,-100,-17>, <37.75,-100,17>,
			<37.75,-70,-17>, <37.75,-70,17>, <37.880001,-106,-11>, <37.880001,-106,11>,
			<37.880001,-64,-11>, <37.880001,-64,11>, <38.880001,-94,-17>, <38.880001,-94,17>,
			<38.880001,-76,-17>, <38.880001,-76,17>, <39.09,-106,-3>, <39.09,-106,3>,
			<39.09,-64,-3>, <39.09,-64,3>, <39.43,-88,-17>, <39.43,-88,17>,
			<39.43,-82,-17>, <39.43,-82,17>, <39.73,-100,-11>, <39.73,-100,11>,
			<39.73,-70,-11>, <39.73,-70,11>, <40.919998,-94,-11>, <40.919998,-94,11>,
			<40.919998,-76,-11>, <40.919998,-76,11>, <41,-100,-3>, <41,-100,3>,
			<41,-70,-3>, <41,-70,3>, <41.5,-88,-11>, <41.5,-88,11>,
			<41.5,-82,-11>, <41.5,-82,11>, <42.220001,-94,-3>, <42.220001,-94,3>,
			<42.220001,-76,-3>, <42.220001,-76,3>, <42.82,-88,-3>, <42.82,-88,3>,
			<42.82,-82,-3>, <42.82,-82,3>
		}
		normal_vectors {
			348,
			<-1,0,0>, <-1,0,0>, <-0.986659,0,-0.162799>, <-0.986659,0,0.162799>,
			<-0.969214,-0.192227,-0.153863>, <-0.968666,-0.192118,0.157409>, <-0.968666,0.192118,-0.157409>, <-0.969214,0.192227,0.153863>,
			<-0.967754,-0.196777,-0.15726>, <-0.968301,-0.196888,0.153718>, <-0.968488,-0.194503,-0.155562>, <-0.968488,-0.194504,0.155564>,
			<-0.968488,0.194504,-0.155564>, <-0.968488,0.194503,0.155562>, <-0.968301,0.196888,-0.153718>, <-0.967754,0.196777,0.15726>,
			<-0.909533,-0.395647,-0.127334>, <-0.909533,0.395647,0.127334>, <-0.908303,-0.395112,0.137381>, <-0.908303,0.395112,-0.137381>,
			<-0.906478,-0.401094,-0.131988>, <-0.906472,-0.4011,0.132015>, <-0.906472,0.4011,-0.132015>, <-0.906478,0.401094,0.131988>,
			<-0.904579,-0.407061,0.126641>, <-0.904579,0.407061,-0.126641>, <-0.903369,-0.406516,-0.136634>, <-0.903369,0.406516,0.136634>,
			<-0.871576,0,-0.490261>, <-0.871576,0,0.490261>, <-0.871039,-0.145173,-0.469272>, <-0.871039,-0.145173,0.469272>,
			<-0.871039,0.145173,-0.469272>, <-0.871039,0.145173,0.469272>, <-0.866941,-0.153837,-0.474075>, <-0.866941,-0.153837,0.474075>,
			<-0.866941,0.153837,-0.474075>, <-0.866941,0.153837,0.474075>, <-0.862744,-0.162484,-0.478823>, <-0.862744,-0.162484,0.478823>,
			<-0.862744,0.162484,-0.478823>, <-0.862744,0.162484,0.478823>, <-0.856346,-0.313993,-0.409975>, <-0.856346,-0.313993,0.409975>,
			<-0.856346,0.313993,-0.409975>, <-0.856346,0.313993,0.409975>, <-0.845785,-0.329605,-0.419533>, <-0.845785,-0.329605,0.419533>,
			<-0.845785,0.329605,-0.419533>, <-0.845785,0.329605,0.419533>, <-0.834847,-0.34507,-0.428903>, <-0.834847,-0.34507,0.428903>,
			<-0.834847,0.34507,-0.428903>, <-0.834847,0.34507,0.428903>, <-0.789063,-0.543138,-0.287022>, <-0.789063,-0.543138,0.287022>,
			<-0.789063,0.543138,-0.287022>, <-0.789063,0.543138,0.287022>, <-0.771923,-0.630404,-0.082017>, <-0.771923,-0.630404,0.082017>,
			<-0.771923,0.630404,-0.082017>, <-0.771923,0.630404,0.082017>, <-0.768861,-0.562279,-0.304458>, <-0.768861,-0.562279,0.304458>,
			<-0.768861,0.562279,-0.304458>, <-0.768861,0.562279,0.304458>, <-0.766122,-0.636436,-0.089478>, <-0.766122,-0.636436,0.089478>,
			<-0.766122,0.636436,-0.089478>, <-0.766122,0.636436,0.089478>, <-0.760224,-0.642389,-0.096928>, <-0.760224,-0.642389,0.096928>,
			<-0.760224,0.642389,-0.096928>, <-0.760224,0.642389,0.096928>, <-0.74783,-0.580814,-0.321567>, <-0.74783,-0.580814,0.321567>,
			<-0.74783,0.580814,-0.321567>, <-0.74783,0.580814,0.321567>, <-0.589898,-0.184835,-0.786039>, <-0.589898,-0.184835,0.786039>,
			<-0.589898,0.184835,-0.786039>, <-0.589898,0.184835,0.786039>, <-0.58153,-0.050399,-0.811962>, <-0.58153,-0.050399,0.811962>,
			<-0.58153,0.050399,-0.811962>, <-0.58153,0.050399,0.811962>, <-0.575447,-0.065527,-0.81521>, <-0.575447,-0.065527,0.81521>,
			<-0.575447,0.065527,-0.81521>, <-0.575447,0.065527,0.81521>, <-0.569205,-0.080637,-0.818232>, <-0.569205,-0.080637,0.818232>,
			<-0.569205,0.080637,-0.818232>, <-0.569205,0.080637,0.818232>, <-0.565419,0,-0.824804>, <-0.565419,0,0.824804>,
			<-0.519656,-0.304123,-0.798415>, <-0.519656,-0.304123,0.798415>, <-0.519656,0.304123,-0.798415>, <-0.519656,0.304123,0.798415>,
			<-0.454199,-0.050021,0.889495>, <-0.454199,0.050021,-0.889495>, <-0.454199,0.050021,0.889495>, <-0.439377,-0.417537,-0.795369>,
			<-0.439377,-0.417537,0.795369>, <-0.439377,0.417537,-0.795369>, <-0.439377,0.417537,0.795369>, <-0.434206,-0.900165,-0.034194>,
			<-0.434206,-0.900165,0.034194>, <-0.396305,0,-0.918119>, <-0.396305,0,0.918119>, <-0.382638,0.923407,-0.030133>,
			<-0.382638,0.923407,0.030133>, <-0.344753,-0.92145,-0.179097>, <-0.344753,-0.92145,0.179097>, <-0.318983,0.936221,-0.147446>,
			<-0.318983,0.936221,0.147446>, <-0.183566,-0.015909,-0.982879>, <-0.174387,-0.974626,-0.14033>, <-0.174387,-0.974626,0.14033>,
			<-0.161339,0.979075,-0.124022>, <-0.161339,0.979075,0.124022>, <-0.151514,-0.108181,-0.982517>, <-0.151514,-0.108181,0.982517>,
			<-0.151514,0.108181,-0.982517>, <-0.151514,0.108181,0.982517>, <-0.084212,0.951419,-0.296161>, <-0.084212,0.951419,0.296161>,
			<-0.082679,-0.945438,-0.315138>, <-0.082679,-0.945438,0.315138>, <-0.010608,-0.388923,-0.921209>, <-0.010608,-0.388923,0.921209>,
			<-0.010608,0.388923,-0.921209>, <-0.010608,0.388923,0.921209>, <-0.005304,-0.400312,-0.916364>, <-0.005304,-0.400312,0.916364>,
			<-0.005304,0.400312,-0.916364>, <-0.005304,0.400312,0.916364>, <0,-1,0>, <0,-0.906634,-0.421919>,
			<0,-0.906634,0.421919>, <0,-0.883902,-0.467673>, <0,-0.883902,0.467673>, <0,-0.860017,-0.510265>,
			<0,-0.860017,0.510265>, <0,-0.7713,-0.636472>, <0,-0.7713,0.636472>, <0,-0.699928,-0.714213>,
			<0,-0.699928,0.714213>, <0,-0.645429,-0.763821>, <0,-0.645429,0.763821>, <0,-0.558938,-0.829209>,
			<0,-0.558938,0.829209>, <0,-0.533038,-0.846092>, <0,-0.533038,0.846092>, <0,-0.505813,-0.862643>,
			<0,-0.505813,0.862643>, <0,-0.411627,-0.911352>, <0,-0.411627,0.911352>, <0,-0.396533,-0.91802>,
			<0,-0.396533,0.91802>, <0,-0.386624,-0.922238>, <0,-0.386624,0.922238>, <0,-0.349754,-0.936841>,
			<0,-0.349754,0.936841>, <0,-0.200824,-0.979627>, <0,-0.200824,0.979627>, <0,-0.165678,-0.98618>,
			<0,-0.165678,0.98618>, <0,-0.109445,-0.993993>, <0,-0.109445,0.993993>, <0,-0.083126,-0.996539>,
			<0,-0.083126,0.996539>, <0,0,-1>, <0,0,1>, <0,0.083126,-0.996539>,
			<0,0.083126,0.996539>, <0,0.109445,-0.993993>, <0,0.109445,0.993993>, <0,0.165678,-0.98618>,
			<0,0.165678,0.98618>, <0,0.200824,-0.979627>, <0,0.200824,0.979627>, <0,0.349754,-0.936841>,
			<0,0.349754,0.936841>, <0,0.386624,-0.922238>, <0,0.386624,0.922238>, <0,0.396533,-0.91802>,
			<0,0.396533,0.91802>, <0,0.411627,-0.911352>, <0,0.411627,0.911352>, <0,0.505813,-0.862643>,
			<0,0.505813,0.862643>, <0,0.533038,-0.846092>, <0,0.533038,0.846092>, <0,0.558938,-0.829209>,
			<0,0.558938,0.829209>, <0,0.645429,-0.763821>, <0,0.645429,0.763821>, <0,0.699928,-0.714213>,
			<0,0.699928,0.714213>, <0,0.7713,-0.636472>, <0,0.7713,0.636472>, <0,0.860017,-0.510265>,
			<0,0.860017,0.510265>, <0,0.883902,-0.467673>, <0,0.883902,0.467673>, <0,0.906634,-0.421917>,
			<0,0.906634,0.421917>, <0,1,0>, <0.005304,-0.400312,-0.916364>, <0.005304,-0.400312,0.916364>,
			<0.005304,0.400312,-0.916364>, <0.005304,0.400312,0.916364>, <0.010608,-0.388923,-0.921209>, <0.010608,-0.388923,0.921209>,
			<0.010608,0.388923,-0.921209>, <0.010608,0.388923,0.921209>, <0.082679,-0.945438,-0.315138>, <0.082679,-0.945438,0.315138>,
			<0.084212,0.951419,-0.296161>, <0.084212,0.951419,0.296161>, <0.128975,0.986679,-0.099144>, <0.151514,-0.108181,-0.982517>,
			<0.151514,-0.108181,0.982517>, <0.151514,0.108181,-0.982517>, <0.151514,0.108181,0.982517>, <0.161339,0.979075,0.124022>,
			<0.174387,-0.974626,0.14033>, <0.183566,0.015909,-0.982879>, <0.231893,-0.954675,-0.186605>, <0.318983,0.936221,-0.147446>,
			<0.318983,0.936221,0.147446>, <0.344753,-0.92145,-0.179097>, <0.344753,-0.92145,0.179097>, <0.382638,0.923407,-0.030133>,
			<0.382638,0.923407,0.030133>, <0.396305,0,-0.918119>, <0.396305,0,0.918119>, <0.434206,-0.900165,-0.034194>,
			<0.434206,-0.900165,0.034194>, <0.439377,-0.417537,-0.795369>, <0.439377,-0.417537,0.795369>, <0.439377,0.417537,-0.795369>,
			<0.439377,0.417537,0.795369>, <0.454199,-0.050021,-0.889495>, <0.454199,-0.050021,0.889495>, <0.454199,0.050021,0.889495>,
			<0.519656,-0.304123,-0.798415>, <0.519656,-0.304123,0.798415>, <0.519656,0.304123,-0.798415>, <0.519656,0.304123,0.798415>,
			<0.565419,0,-0.824804>, <0.565419,0,0.824804>, <0.569205,-0.080637,-0.818232>, <0.569205,-0.080637,0.818232>,
			<0.569205,0.080637,-0.818232>, <0.569205,0.080637,0.818232>, <0.575447,-0.065527,-0.81521>, <0.575447,-0.065527,0.81521>,
			<0.575447,0.065527,-0.81521>, <0.575447,0.065527,0.81521>, <0.58153,-0.050399,-0.811962>, <0.58153,-0.050399,0.811962>,
			<0.58153,0.050399,-0.811962>, <0.58153,0.050399,0.811962>, <0.589898,-0.184835,-0.786039>, <0.589898,-0.184835,0.786039>,
			<0.589898,0.184835,-0.786039>, <0.589898,0.184835,0.786039>, <0.74783,-0.580814,-0.321567>, <0.74783,-0.580814,0.321567>,
			<0.74783,0.580814,-0.321567>, <0.74783,0.580814,0.321567>, <0.760224,-0.642389,-0.096928>, <0.760224,-0.642389,0.096928>,
			<0.760224,0.642389,-0.096928>, <0.760224,0.642389,0.096928>, <0.766122,-0.636436,-0.089478>, <0.766122,-0.636436,0.089478>,
			<0.766122,0.636436,-0.089478>, <0.766122,0.636436,0.089478>, <0.768861,-0.562279,-0.304458>, <0.768861,-0.562279,0.304458>,
			<0.768861,0.562279,-0.304458>, <0.768861,0.562279,0.304458>, <0.771923,-0.630404,-0.082017>, <0.771923,-0.630404,0.082017>,
			<0.771923,0.630404,-0.082017>, <0.771923,0.630404,0.082017>, <0.789063,-0.543138,-0.287022>, <0.789063,-0.543138,0.287022>,
			<0.789063,0.543138,-0.287022>, <0.789063,0.543138,0.287022>, <0.834847,-0.34507,-0.428903>, <0.834847,-0.34507,0.428903>,
			<0.834847,0.34507,-0.428903>, <0.834847,0.34507,0.428903>, <0.845785,-0.329605,-0.419533>, <0.845785,-0.329605,0.419533>,
			<0.845785,0.329605,-0.419533>, <0.845785,0.329605,0.419533>, <0.856346,-0.313993,-0.409975>, <0.856346,-0.313993,0.409975>,
			<0.856346,0.313993,-0.409975>, <0.856346,0.313993,0.409975>, <0.862744,-0.162484,-0.478823>, <0.862744,-0.162484,0.478823>,
			<0.862744,0.162484,-0.478823>, <0.862744,0.162484,0.478823>, <0.866941,-0.153837,-0.474075>, <0.866941,-0.153837,0.474075>,
			<0.866941,0.153837,-0.474075>, <0.866941,0.153837,0.474075>, <0.871039,-0.145173,-0.469272>, <0.871039,-0.145173,0.469272>,
			<0.871039,0.145173,-0.469272>, <0.871039,0.145173,0.469272>, <0.871576,0,-0.490261>, <0.871576,0,0.490261>,
			<0.903369,-0.406516,0.136634>, <0.903369,0.406516,-0.136634>, <0.904579,-0.407061,-0.126641>, <0.904579,0.407061,0.126641>,
			<0.906472,-0.4011,-0.132015>, <0.906478,-0.401094,0.131988>, <0.906478,0.401094,-0.131988>, <0.906472,0.4011,0.132015>,
			<0.908303,-0.395112,-0.137381>, <0.908303,0.395112,0.137381>, <0.909533,-0.395647,0.127334>, <0.909533,0.395647,-0.127334>,
			<0.968301,-0.196888,-0.153718>, <0.967754,-0.196777,0.15726>, <0.968488,-0.194504,-0.155564>, <0.968488,-0.194503,0.155562>,
			<0.968488,0.194503,-0.155562>, <0.968488,0.194504,0.155564>, <0.967754,0.196777,-0.15726>, <0.968301,0.196888,0.153718>,
			<0.968666,-0.192118,-0.157409>, <0.969214,-0.192227,0.153863>, <0.969214,0.192227,-0.153863>, <0.968666,0.192118,0.157409>,
			<0.986659,0,-0.162799>, <0.986659,0,0.162799>, <1,0,0>, <1,0,0>
		}
		face_indices {
			1216,
			<612, 610, 668>, <640, 638, 728>, <640, 728, 696>, <636, 634, 772>,
			<636, 772, 756>, <632, 630, 796>, <632, 796, 788>, <800, 628, 626>,
			<800, 626, 798>, <624, 622, 786>, <624, 786, 794>, <620, 618, 754>,
			<620, 754, 770>, <616, 614, 694>, <616, 694, 726>, <482, 485, 662>,
			<505, 508, 664>, <603, 607, 688>, <603, 688, 720>, <595, 599, 748>,
			<595, 748, 764>, <587, 591, 780>, <587, 780, 784>, <790, 579, 583>,
			<790, 583, 792>, <571, 575, 782>, <571, 782, 778>, <563, 567, 762>,
			<563, 762, 746>, <555, 559, 718>, <555, 718, 686>, <606, 602, 716>,
			<606, 716, 680>, <598, 594, 752>, <598, 752, 736>, <590, 586, 768>,
			<590, 768, 760>, <776, 582, 578>, <776, 578, 774>, <574, 570, 758>,
			<574, 758, 766>, <566, 562, 734>, <566, 734, 750>, <558, 554, 678>,
			<558, 678, 714>, <497, 501, 672>, <497, 672, 684>, <543, 547, 708>,
			<543, 708, 724>, <535, 539, 732>, <535, 732, 740>, <742, 527, 531>,
			<742, 531, 744>, <519, 523, 738>, <519, 738, 730>, <511, 515, 722>,
			<511, 722, 706>, <489, 493, 682>, <489, 682, 670>, <546, 542, 692>,
			<546, 692, 676>, <538, 534, 704>, <538, 704, 700>, <712, 530, 526>,
			<712, 526, 710>, <522, 518, 698>, <522, 698, 702>, <514, 510, 674>,
			<514, 674, 690>, <134, 188, 190>, <106, 74, 184>, <106, 184, 186>,
			<46, 30, 180>, <46, 180, 182>, <14, 6, 176>, <14, 176, 178>,
			<174, 2, 0>, <174, 0, 172>, <4, 12, 168>, <4, 168, 170>,
			<28, 44, 164>, <28, 164, 166>, <72, 104, 160>, <72, 160, 162>,
			<136, 295, 292>, <138, 318, 315>, <82, 114, 245>, <82, 245, 241>,
			<38, 54, 237>, <38, 237, 233>, <18, 22, 229>, <18, 229, 225>,
			<217, 8, 10>, <217, 10, 221>, <20, 16, 213>, <20, 213, 209>,
			<52, 36, 205>, <52, 205, 201>, <112, 80, 197>, <112, 197, 193>,
			<122, 86, 240>, <122, 240, 244>, <66, 50, 232>, <66, 232, 236>,
			<42, 34, 224>, <42, 224, 228>, <220, 26, 24>, <220, 24, 216>,
			<32, 40, 208>, <32, 208, 212>, <48, 64, 200>, <48, 200, 204>,
			<84, 120, 192>, <84, 192, 196>, <118, 130, 311>, <118, 311, 307>,
			<78, 94, 289>, <78, 289, 285>, <62, 70, 281>, <62, 281, 277>,
			<269, 56, 58>, <269, 58, 273>, <68, 60, 265>, <68, 265, 261>,
			<92, 76, 257>, <92, 257, 253>, <128, 116, 303>, <128, 303, 299>,
			<126, 110, 284>, <126, 284, 288>, <102, 98, 276>, <102, 276, 280>,
			<272, 90, 88>, <272, 88, 268>, <96, 100, 260>, <96, 260, 264>,
			<108, 124, 252>, <108, 252, 256>, <669, 611, 613>, <697, 729, 639>,
			<697, 639, 641>, <757, 773, 635>, <757, 635, 637>, <789, 797, 631>,
			<789, 631, 633>, <629, 801, 799>, <629, 799, 627>, <795, 787, 623>,
			<795, 623, 625>, <771, 755, 619>, <771, 619, 621>, <727, 695, 615>,
			<727, 615, 617>, <663, 486, 483>, <665, 509, 506>, <721, 689, 608>,
			<721, 608, 604>, <765, 749, 600>, <765, 600, 596>, <785, 781, 592>,
			<785, 592, 588>, <580, 791, 793>, <580, 793, 584>, <779, 783, 576>,
			<779, 576, 572>, <747, 763, 568>, <747, 568, 564>, <687, 719, 560>,
			<687, 560, 556>, <681, 717, 605>, <681, 605, 609>, <737, 753, 597>,
			<737, 597, 601>, <761, 769, 589>, <761, 589, 593>, <585, 777, 775>,
			<585, 775, 581>, <767, 759, 573>, <767, 573, 577>, <751, 735, 565>,
			<751, 565, 569>, <715, 679, 557>, <715, 557, 561>, <685, 673, 502>,
			<685, 502, 498>, <725, 709, 548>, <725, 548, 544>, <741, 733, 540>,
			<741, 540, 536>, <528, 743, 745>, <528, 745, 532>, <731, 739, 524>,
			<731, 524, 520>, <707, 723, 516>, <707, 516, 512>, <671, 683, 494>,
			<671, 494, 490>, <677, 693, 545>, <677, 545, 549>, <701, 705, 537>,
			<701, 537, 541>, <533, 713, 711>, <533, 711, 529>, <703, 699, 521>,
			<703, 521, 525>, <691, 675, 513>, <691, 513, 517>, <191, 189, 135>,
			<551, 553, 667>, <666, 552, 550>, <248, 250, 132>, <133, 251, 249>,
			<187, 185, 75>, <187, 75, 107>, <183, 181, 31>, <183, 31, 47>,
			<179, 177, 7>, <179, 7, 15>, <3, 175, 173>, <3, 173, 1>,
			<171, 169, 13>, <171, 13, 5>, <167, 165, 45>, <167, 45, 29>,
			<163, 161, 105>, <163, 105, 73>, <293, 296, 137>, <316, 319, 139>,
			<242, 246, 115>, <242, 115, 83>, <234, 238, 55>, <234, 55, 39>,
			<226, 230, 23>, <226, 23, 19>, <9, 218, 222>, <9, 222, 11>,
			<210, 214, 17>, <210, 17, 21>, <202, 206, 37>, <202, 37, 53>,
			<194, 198, 81>, <194, 81, 113>, <247, 243, 87>, <247, 87, 123>,
			<239, 235, 51>, <239, 51, 67>, <231, 227, 35>, <231, 35, 43>,
			<27, 223, 219>, <27, 219, 25>, <215, 211, 41>, <215, 41, 33>,
			<207, 203, 65>, <207, 65, 49>, <199, 195, 121>, <199, 121, 85>,
			<308, 312, 131>, <308, 131, 119>, <286, 290, 95>, <286, 95, 79>,
			<278, 282, 71>, <278, 71, 63>, <57, 270, 274>, <57, 274, 59>,
			<262, 266, 61>, <262, 61, 69>, <254, 258, 77>, <254, 77, 93>,
			<300, 304, 117>, <300, 117, 129>, <291, 287, 111>, <291, 111, 127>,
			<283, 279, 99>, <283, 99, 103>, <91, 275, 271>, <91, 271, 89>,
			<267, 263, 101>, <267, 101, 97>, <259, 255, 125>, <259, 125, 109>,
			<380, 382, 351>, <380, 351, 378>, <376, 378, 351>, <374, 376, 351>,
			<374, 351, 372>, <370, 372, 351>, <368, 370, 351>, <368, 351, 366>,
			<364, 366, 351>, <364, 351, 362>, <360, 362, 351>, <358, 360, 351>,
			<358, 351, 356>, <354, 356, 351>, <354, 351, 352>, <349, 352, 351>,
			<349, 351, 347>, <345, 347, 351>, <345, 351, 343>, <341, 343, 351>,
			<341, 351, 339>, <337, 339, 351>, <335, 337, 351>, <335, 351, 333>,
			<331, 333, 351>, <331, 351, 329>, <327, 329, 351>, <325, 327, 351>,
			<325, 351, 323>, <321, 323, 351>, <322, 320, 351>, <322, 351, 324>,
			<326, 324, 351>, <328, 326, 351>, <328, 351, 330>, <332, 330, 351>,
			<334, 332, 351>, <334, 351, 336>, <338, 336, 351>, <338, 351, 340>,
			<342, 340, 351>, <344, 342, 351>, <344, 351, 346>, <348, 346, 351>,
			<348, 351, 350>, <353, 350, 351>, <353, 351, 355>, <357, 355, 351>,
			<357, 351, 359>, <361, 359, 351>, <361, 351, 363>, <365, 363, 351>,
			<367, 365, 351>, <367, 351, 369>, <371, 369, 351>, <371, 351, 373>,
			<375, 373, 351>, <377, 375, 351>, <377, 351, 379>, <381, 379, 351>,
			<374, 473, 475>, <374, 475, 376>, <372, 471, 473>, <372, 473, 374>,
			<370, 469, 471>, <370, 471, 372>, <366, 465, 467>, <366, 467, 368>,
			<364, 463, 465>, <364, 465, 366>, <362, 461, 463>, <362, 463, 364>,
			<360, 459, 461>, <360, 461, 362>, <358, 457, 459>, <358, 459, 360>,
			<354, 453, 455>, <354, 455, 356>, <352, 451, 453>, <352, 453, 354>,
			<349, 448, 451>, <349, 451, 352>, <347, 446, 448>, <347, 448, 349>,
			<343, 442, 444>, <343, 444, 345>, <341, 440, 442>, <341, 442, 343>,
			<339, 438, 440>, <339, 440, 341>, <337, 436, 438>, <337, 438, 339>,
			<335, 434, 436>, <335, 436, 337>, <331, 430, 432>, <331, 432, 333>,
			<329, 428, 430>, <329, 430, 331>, <327, 426, 428>, <327, 428, 329>,
			<328, 427, 425>, <328, 425, 326>, <330, 429, 427>, <330, 427, 328>,
			<332, 431, 429>, <332, 429, 330>, <336, 435, 433>, <336, 433, 334>,
			<338, 437, 435>, <338, 435, 336>, <340, 439, 437>, <340, 437, 338>,
			<342, 441, 439>, <342, 439, 340>, <344, 443, 441>, <344, 441, 342>,
			<348, 447, 445>, <348, 445, 346>, <350, 449, 447>, <350, 447, 348>,
			<353, 452, 449>, <353, 449, 350>, <355, 454, 452>, <355, 452, 353>,
			<359, 458, 456>, <359, 456, 357>, <361, 460, 458>, <361, 458, 359>,
			<363, 462, 460>, <363, 460, 361>, <365, 464, 462>, <365, 462, 363>,
			<367, 466, 464>, <367, 464, 365>, <371, 470, 468>, <371, 468, 369>,
			<373, 472, 470>, <373, 470, 371>, <375, 474, 472>, <375, 472, 373>,
			<477, 450, 481>, <477, 481, 479>, <450, 477, 475>, <471, 450, 475>,
			<471, 475, 473>, <450, 471, 469>, <465, 450, 469>, <465, 469, 467>,
			<461, 450, 465>, <461, 465, 463>, <450, 461, 459>, <455, 450, 459>,
			<455, 459, 457>, <451, 450, 455>, <451, 455, 453>, <446, 450, 451>,
			<446, 451, 448>, <442, 450, 446>, <442, 446, 444>, <438, 450, 442>,
			<438, 442, 440>, <450, 438, 436>, <432, 450, 436>, <432, 436, 434>,
			<428, 450, 432>, <428, 432, 430>, <450, 428, 426>, <422, 450, 426>,
			<422, 426, 424>, <450, 422, 420>, <423, 450, 419>, <423, 419, 421>,
			<450, 423, 425>, <429, 450, 425>, <429, 425, 427>, <450, 429, 431>,
			<435, 450, 431>, <435, 431, 433>, <439, 450, 435>, <439, 435, 437>,
			<450, 439, 441>, <445, 450, 441>, <445, 441, 443>, <449, 450, 445>,
			<449, 445, 447>, <454, 450, 449>, <454, 449, 452>, <458, 450, 454>,
			<458, 454, 456>, <462, 450, 458>, <462, 458, 460>, <450, 462, 464>,
			<468, 450, 464>, <468, 464, 466>, <472, 450, 468>, <472, 468, 470>,
			<450, 472, 474>, <478, 450, 474>, <478, 474, 476>, <450, 478, 480>,
			<669, 613, 665>, <613, 509, 665>, <139, 135, 669>, <139, 669, 665>,
			<191, 319, 509>, <191, 509, 613>, <191, 139, 319>, <135, 139, 191>,
			<504, 505, 315>, <504, 315, 314>, <505, 504, 508>, <314, 315, 318>,
			<318, 508, 504>, <318, 504, 314>, <317, 316, 506>, <317, 506, 507>,
			<509, 507, 506>, <319, 316, 317>, <317, 507, 509>, <317, 509, 319>,
			<613, 611, 610>, <613, 610, 612>, <189, 191, 190>, <189, 190, 188>,
			<189, 188, 610>, <189, 610, 611>, <613, 612, 190>, <613, 190, 191>,
			<664, 612, 668>, <508, 612, 664>, <134, 138, 664>, <134, 664, 668>,
			<318, 190, 612>, <318, 612, 508>, <318, 138, 190>, <138, 134, 190>,
			<717, 681, 685>, <681, 673, 685>, <119, 87, 717>, <119, 717, 685>,
			<123, 131, 673>, <123, 673, 681>, <123, 119, 131>, <87, 119, 123>,
			<609, 605, 604>, <609, 604, 608>, <243, 247, 246>, <243, 246, 242>,
			<243, 242, 604>, <243, 604, 605>, <609, 608, 246>, <609, 246, 247>,
			<729, 697, 721>, <697, 689, 721>, <83, 75, 729>, <83, 729, 721>,
			<107, 115, 689>, <107, 689, 697>, <107, 83, 115>, <75, 83, 107>,
			<641, 639, 638>, <641, 638, 640>, <185, 187, 186>, <185, 186, 184>,
			<185, 184, 638>, <185, 638, 639>, <641, 640, 186>, <641, 186, 187>,
			<720, 696, 728>, <688, 696, 720>, <74, 82, 720>, <74, 720, 728>,
			<114, 106, 696>, <114, 696, 688>, <114, 82, 106>, <82, 74, 106>,
			<496, 497, 307>, <496, 307, 306>, <310, 311, 501>, <310, 501, 500>,
			<500, 501, 497>, <500, 497, 496>, <311, 310, 306>, <311, 306, 307>,
			<310, 500, 496>, <310, 496, 306>, <309, 308, 498>, <309, 498, 499>,
			<503, 502, 312>, <503, 312, 313>, <499, 498, 502>, <499, 502, 503>,
			<308, 309, 313>, <308, 313, 312>, <309, 499, 503>, <309, 503, 313>,
			<607, 603, 602>, <607, 602, 606>, <241, 245, 244>, <241, 244, 240>,
			<241, 240, 602>, <241, 602, 603>, <607, 606, 244>, <607, 244, 245>,
			<684, 680, 716>, <672, 680, 684>, <86, 118, 684>, <86, 684, 716>,
			<130, 122, 680>, <130, 680, 672>, <130, 118, 122>, <118, 86, 122>,
			<693, 677, 649>, <677, 645, 649>, <155, 111, 693>, <155, 693, 649>,
			<127, 159, 645>, <127, 645, 677>, <127, 155, 159>, <111, 155, 127>,
			<415, 416, 649>, <649, 645, 416>, <418, 416, 645>, <415, 416, 155>,
			<159, 416, 418>, <416, 159, 155>, <549, 545, 544>, <549, 544, 548>,
			<287, 291, 290>, <287, 290, 286>, <287, 286, 544>, <287, 544, 545>,
			<549, 548, 290>, <549, 290, 291>, <753, 737, 725>, <737, 709, 725>,
			<79, 51, 753>, <79, 753, 725>, <67, 95, 709>, <67, 709, 737>,
			<67, 79, 95>, <51, 79, 67>, <601, 597, 596>, <601, 596, 600>,
			<235, 239, 238>, <235, 238, 234>, <235, 234, 596>, <235, 596, 597>,
			<601, 600, 238>, <601, 238, 239>, <765, 773, 757>, <765, 757, 749>,
			<39, 31, 773>, <39, 773, 765>, <47, 55, 749>, <47, 749, 757>,
			<55, 47, 31>, <55, 31, 39>, <637, 635, 634>, <637, 634, 636>,
			<181, 183, 182>, <181, 182, 180>, <181, 180, 634>, <181, 634, 635>,
			<637, 636, 182>, <637, 182, 183>, <772, 764, 748>, <772, 748, 756>,
			<30, 38, 764>, <30, 764, 772>, <54, 46, 756>, <54, 756, 748>,
			<46, 54, 38>, <46, 38, 30>, <599, 595, 594>, <599, 594, 598>,
			<233, 237, 236>, <233, 236, 232>, <233, 232, 594>, <233, 594, 595>,
			<599, 598, 236>, <599, 236, 237>, <724, 736, 752>, <708, 736, 724>,
			<50, 78, 724>, <50, 724, 752>, <94, 66, 736>, <94, 736, 708>,
			<94, 78, 66>, <78, 50, 66>, <547, 543, 542>, <547, 542, 546>,
			<285, 289, 288>, <285, 288, 284>, <285, 284, 542>, <285, 542, 543>,
			<547, 546, 288>, <547, 288, 289>, <414, 413, 648>, <644, 413, 417>,
			<413, 644, 648>, <414, 413, 154>, <154, 158, 413>, <417, 413, 158>,
			<648, 676, 692>, <644, 676, 648>, <110, 154, 648>, <110, 648, 692>,
			<158, 126, 676>, <158, 676, 644>, <158, 154, 126>, <154, 110, 126>,
			<705, 701, 657>, <701, 653, 657>, <147, 99, 705>, <147, 705, 657>,
			<103, 151, 653>, <103, 653, 701>, <103, 147, 151>, <99, 147, 103>,
			<408, 407, 657>, <657, 653, 408>, <653, 412, 408>, <411, 412, 653>,
			<407, 408, 147>, <151, 408, 412>, <147, 408, 151>, <412, 411, 151>,
			<541, 537, 536>, <541, 536, 540>, <279, 283, 282>, <279, 282, 278>,
			<279, 278, 536>, <279, 536, 537>, <541, 540, 282>, <541, 282, 283>,
			<769, 761, 741>, <761, 733, 741>, <63, 35, 769>, <63, 769, 741>,
			<43, 71, 733>, <43, 733, 761>, <43, 63, 71>, <35, 63, 43>,
			<593, 589, 588>, <593, 588, 592>, <227, 231, 230>, <227, 230, 226>,
			<227, 226, 588>, <227, 588, 589>, <593, 592, 230>, <593, 230, 231>,
			<785, 797, 789>, <785, 789, 781>, <19, 7, 797>, <19, 797, 785>,
			<15, 23, 781>, <15, 781, 789>, <23, 15, 7>, <23, 7, 19>,
			<633, 631, 630>, <633, 630, 632>, <177, 179, 178>, <177, 178, 176>,
			<177, 176, 630>, <177, 630, 631>, <633, 632, 178>, <633, 178, 179>,
			<796, 784, 780>, <796, 780, 788>, <6, 18, 784>, <6, 784, 796>,
			<22, 14, 788>, <22, 788, 780>, <14, 22, 18>, <14, 18, 6>,
			<591, 587, 586>, <591, 586, 590>, <225, 229, 228>, <225, 228, 224>,
			<225, 224, 586>, <225, 586, 587>, <591, 590, 228>, <591, 228, 229>,
			<740, 760, 768>, <732, 760, 740>, <34, 62, 740>, <34, 740, 768>,
			<70, 42, 760>, <70, 760, 732>, <70, 62, 42>, <62, 34, 42>,
			<539, 535, 534>, <539, 534, 538>, <277, 281, 280>, <277, 280, 276>,
			<277, 276, 534>, <277, 534, 535>, <539, 538, 280>, <539, 280, 281>,
			<406, 405, 656>, <652, 405, 409>, <656, 405, 652>, <409, 410, 652>,
			<405, 406, 146>, <146, 150, 405>, <150, 409, 405>, <410, 409, 150>,
			<656, 700, 704>, <652, 700, 656>, <98, 146, 656>, <98, 656, 704>,
			<150, 102, 700>, <150, 700, 652>, <150, 146, 102>, <146, 98, 102>,
			<661, 659, 711>, <661, 711, 713>, <141, 89, 711>, <141, 711, 659>,
			<91, 143, 661>, <91, 661, 713>, <141, 143, 91>, <141, 91, 89>,
			<400, 399, 659>, <404, 400, 659>, <404, 659, 661>, <403, 404, 661>,
			<399, 400, 141>, <400, 404, 143>, <400, 143, 141>, <404, 403, 143>,
			<533, 529, 528>, <533, 528, 532>, <271, 275, 274>, <271, 274, 270>,
			<271, 270, 528>, <271, 528, 529>, <533, 532, 274>, <533, 274, 275>,
			<745, 743, 775>, <745, 775, 777>, <57, 25, 775>, <57, 775, 743>,
			<27, 59, 745>, <27, 745, 777>, <57, 59, 27>, <57, 27, 25>,
			<585, 581, 580>, <585, 580, 584>, <219, 223, 222>, <219, 222, 218>,
			<219, 218, 580>, <219, 580, 581>, <585, 584, 222>, <585, 222, 223>,
			<793, 791, 799>, <793, 799, 801>, <9, 1, 799>, <9, 799, 791>,
			<3, 11, 793>, <3, 793, 801>, <9, 11, 3>, <9, 3, 1>,
			<629, 627, 626>, <629, 626, 628>, <173, 175, 174>, <173, 174, 172>,
			<173, 172, 626>, <173, 626, 627>, <629, 628, 174>, <629, 174, 175>,
			<800, 798, 790>, <800, 790, 792>, <0, 8, 790>, <0, 790, 798>,
			<10, 2, 800>, <10, 800, 792>, <0, 2, 10>, <0, 10, 8>,
			<583, 579, 578>, <583, 578, 582>, <217, 221, 220>, <217, 220, 216>,
			<217, 216, 578>, <217, 578, 579>, <583, 582, 220>, <583, 220, 221>,
			<776, 774, 742>, <776, 742, 744>, <24, 56, 742>, <24, 742, 774>,
			<58, 26, 776>, <58, 776, 744>, <24, 26, 58>, <24, 58, 56>,
			<531, 527, 526>, <531, 526, 530>, <269, 273, 272>, <269, 272, 268>,
			<269, 268, 526>, <269, 526, 527>, <531, 530, 272>, <531, 272, 273>,
			<398, 397, 658>, <397, 401, 660>, <397, 660, 658>, <401, 402, 660>,
			<397, 398, 140>, <401, 397, 140>, <401, 140, 142>, <402, 401, 142>,
			<712, 710, 658>, <712, 658, 660>, <88, 140, 658>, <88, 658, 710>,
			<142, 90, 712>, <142, 712, 660>, <88, 90, 142>, <88, 142, 140>,
			<699, 655, 651>, <703, 655, 699>, <149, 101, 699>, <149, 699, 651>,
			<97, 145, 655>, <97, 655, 703>, <97, 101, 145>, <101, 149, 145>,
			<392, 391, 651>, <651, 396, 392>, <655, 396, 651>, <395, 396, 655>,
			<391, 392, 149>, <145, 149, 396>, <149, 392, 396>, <396, 395, 145>,
			<525, 521, 520>, <525, 520, 524>, <263, 267, 266>, <263, 266, 262>,
			<263, 262, 520>, <263, 520, 521>, <525, 524, 266>, <525, 266, 267>,
			<759, 739, 731>, <767, 739, 759>, <69, 41, 759>, <69, 759, 731>,
			<33, 61, 739>, <33, 739, 767>, <33, 41, 61>, <41, 69, 61>,
			<577, 573, 572>, <577, 572, 576>, <211, 215, 214>, <211, 214, 210>,
			<211, 210, 572>, <211, 572, 573>, <577, 576, 214>, <577, 214, 215>,
			<779, 787, 795>, <779, 795, 783>, <21, 13, 787>, <21, 787, 779>,
			<5, 17, 783>, <5, 783, 795>, <17, 5, 13>, <17, 13, 21>,
			<625, 623, 622>, <625, 622, 624>, <169, 171, 170>, <169, 170, 168>,
			<169, 168, 622>, <169, 622, 623>, <625, 624, 170>, <625, 170, 171>,
			<786, 778, 782>, <786, 782, 794>, <12, 20, 778>, <12, 778, 786>,
			<16, 4, 794>, <16, 794, 782>, <4, 16, 20>, <4, 20, 12>,
			<575, 571, 570>, <575, 570, 574>, <209, 213, 212>, <209, 212, 208>,
			<209, 208, 570>, <209, 570, 571>, <575, 574, 212>, <575, 212, 213>,
			<730, 738, 758>, <738, 766, 758>, <40, 68, 730>, <40, 730, 758>,
			<60, 32, 766>, <60, 766, 738>, <60, 40, 32>, <68, 40, 60>,
			<523, 519, 518>, <523, 518, 522>, <261, 265, 264>, <261, 264, 260>,
			<261, 260, 518>, <261, 518, 519>, <523, 522, 264>, <523, 264, 265>,
			<390, 389, 650>, <650, 389, 393>, <393, 394, 654>, <389, 390, 148>,
			<148, 393, 389>, <144, 393, 148>, <650, 393, 654>, <394, 393, 144>,
			<650, 654, 698>, <654, 702, 698>, <100, 148, 650>, <100, 650, 698>,
			<144, 96, 702>, <144, 702, 654>, <144, 100, 96>, <148, 100, 144>,
			<675, 647, 643>, <691, 647, 675>, <157, 125, 675>, <157, 675, 643>,
			<109, 153, 647>, <109, 647, 691>, <109, 125, 153>, <125, 157, 153>,
			<388, 384, 643>, <388, 643, 647>, <388, 647, 387>, <388, 153, 157>,
			<388, 157, 384>, <153, 387, 388>, <517, 513, 512>, <517, 512, 516>,
			<255, 259, 258>, <255, 258, 254>, <255, 254, 512>, <255, 512, 513>,
			<517, 516, 258>, <517, 258, 259>, <707, 735, 723>, <735, 751, 723>,
			<93, 65, 735>, <93, 735, 707>, <49, 77, 723>, <49, 723, 751>,
			<77, 49, 65>, <77, 65, 93>, <569, 565, 564>, <569, 564, 568>,
			<203, 207, 206>, <203, 206, 202>, <203, 202, 564>, <203, 564, 565>,
			<569, 568, 206>, <569, 206, 207>, <747, 755, 771>, <747, 771, 763>,
			<53, 45, 755>, <53, 755, 747>, <29, 37, 763>, <29, 763, 771>,
			<37, 29, 45>, <37, 45, 53>, <621, 619, 618>, <621, 618, 620>,
			<165, 167, 166>, <165, 166, 164>, <165, 164, 618>, <165, 618, 619>,
			<621, 620, 166>, <621, 166, 167>, <754, 746, 762>, <754, 762, 770>,
			<44, 52, 746>, <44, 746, 754>, <36, 28, 770>, <36, 770, 762>,
			<28, 36, 52>, <28, 52, 44>, <567, 563, 562>, <567, 562, 566>,
			<201, 205, 204>, <201, 204, 200>, <201, 200, 562>, <201, 562, 563>,
			<567, 566, 204>, <567, 204, 205>, <734, 706, 722>, <734, 722, 750>,
			<64, 92, 706>, <64, 706, 734>, <76, 48, 750>, <76, 750, 722>,
			<48, 76, 64>, <76, 92, 64>, <515, 511, 510>, <515, 510, 514>,
			<253, 257, 256>, <253, 256, 252>, <253, 252, 510>, <253, 510, 511>,
			<515, 514, 256>, <515, 256, 257>, <646, 642, 385>, <642, 383, 385>,
			<386, 385, 646>, <385, 383, 156>, <385, 156, 152>, <385, 152, 386>,
			<646, 674, 642>, <690, 674, 646>, <124, 156, 642>, <124, 642, 674>,
			<152, 108, 690>, <152, 690, 646>, <124, 108, 152>, <124, 152, 156>,
			<683, 671, 679>, <683, 679, 715>, <129, 121, 679>, <129, 679, 671>,
			<85, 117, 683>, <85, 683, 715>, <121, 117, 85>, <129, 117, 121>,
			<561, 557, 556>, <561, 556, 560>, <195, 199, 198>, <195, 198, 194>,
			<195, 194, 556>, <195, 556, 557>, <561, 560, 198>, <561, 198, 199>,
			<719, 687, 695>, <719, 695, 727>, <113, 105, 695>, <113, 695, 687>,
			<73, 81, 719>, <73, 719, 727>, <105, 81, 73>, <113, 81, 105>,
			<617, 615, 614>, <617, 614, 616>, <161, 163, 162>, <161, 162, 160>,
			<161, 160, 614>, <161, 614, 615>, <617, 616, 162>, <617, 162, 163>,
			<718, 694, 686>, <726, 694, 718>, <104, 112, 686>, <104, 686, 694>,
			<80, 72, 726>, <80, 726, 718>, <104, 72, 80>, <104, 80, 112>,
			<488, 489, 299>, <488, 299, 298>, <302, 303, 493>, <302, 493, 492>,
			<492, 493, 489>, <492, 489, 488>, <303, 302, 298>, <303, 298, 299>,
			<302, 492, 488>, <302, 488, 298>, <301, 300, 490>, <301, 490, 491>,
			<495, 494, 304>, <495, 304, 305>, <491, 490, 494>, <491, 494, 495>,
			<300, 301, 305>, <300, 305, 304>, <301, 491, 495>, <301, 495, 305>,
			<559, 555, 554>, <559, 554, 558>, <193, 197, 196>, <193, 196, 192>,
			<193, 192, 554>, <193, 554, 555>, <559, 558, 196>, <559, 196, 197>,
			<682, 678, 670>, <714, 678, 682>, <120, 128, 670>, <120, 670, 678>,
			<116, 84, 714>, <116, 714, 682>, <120, 84, 116>, <120, 116, 128>,
			<663, 483, 551>, <663, 551, 667>, <293, 249, 551>, <293, 551, 483>,
			<133, 137, 663>, <133, 663, 667>, <249, 137, 133>, <293, 137, 249>,
			<294, 295, 485>, <294, 485, 484>, <484, 485, 482>, <295, 294, 292>,
			<294, 484, 482>, <294, 482, 292>, <487, 486, 296>, <487, 296, 297>,
			<483, 486, 487>, <293, 297, 296>, <293, 483, 487>, <293, 487, 297>,
			<553, 551, 550>, <553, 550, 552>, <249, 251, 250>, <249, 250, 248>,
			<249, 248, 550>, <249, 550, 551>, <553, 552, 250>, <553, 250, 251>,
			<662, 550, 482>, <666, 550, 662>, <248, 292, 482>, <248, 482, 550>,
			<136, 132, 666>, <136, 666, 662>, <248, 132, 136>, <248, 136, 292>
		}
		normal_indices {
			1216,
			<173, 173, 173>, <173, 173, 173>, <173, 173, 173>, <173, 173, 173>,
			<173, 173, 173>, <173, 173, 173>, <173, 173, 173>, <173, 173, 173>,
			<173, 173, 173>, <173, 173, 173>, <173, 173, 173>, <173, 173, 173>,
			<173, 173, 173>, <173, 173, 173>, <173, 173, 173>, <174, 174, 174>,
			<174, 174, 174>, <174, 174, 174>, <174, 174, 174>, <174, 174, 174>,
			<174, 174, 174>, <174, 174, 174>, <174, 174, 174>, <174, 174, 174>,
			<174, 174, 174>, <174, 174, 174>, <174, 174, 174>, <174, 174, 174>,
			<174, 174, 174>, <174, 174, 174>, <174, 174, 174>, <173, 173, 173>,
			<173, 173, 173>, <173, 173, 173>, <173, 173, 173>, <173, 173, 173>,
			<173, 173, 173>, <173, 173, 173>, <173, 173, 173>, <173, 173, 173>,
			<173, 173, 173>, <173, 173, 173>, <173, 173, 173>, <173, 173, 173>,
			<173, 173, 173>, <174, 174, 174>, <174, 174, 174>, <174, 174, 174>,
			<174, 174, 174>, <174, 174, 174>, <174, 174, 174>, <174, 174, 174>,
			<174, 174, 174>, <174, 174, 174>, <174, 174, 174>, <174, 174, 174>,
			<174, 174, 174>, <174, 174, 174>, <174, 174, 174>, <173, 173, 173>,
			<173, 173, 173>, <173, 173, 173>, <173, 173, 173>, <173, 173, 173>,
			<173, 173, 173>, <173, 173, 173>, <173, 173, 173>, <173, 173, 173>,
			<173, 173, 173>, <173, 173, 173>, <173, 173, 173>, <173, 173, 173>,
			<173, 173, 173>, <173, 173, 173>, <173, 173, 173>, <173, 173, 173>,
			<173, 173, 173>, <173, 173, 173>, <173, 173, 173>, <173, 173, 173>,
			<173, 173, 173>, <173, 173, 173>, <173, 173, 173>, <173, 173, 173>,
			<174, 174, 174>, <174, 174, 174>, <174, 174, 174>, <174, 174, 174>,
			<174, 174, 174>, <174, 174, 174>, <174, 174, 174>, <174, 174, 174>,
			<174, 174, 174>, <174, 174, 174>, <174, 174, 174>, <174, 174, 174>,
			<174, 174, 174>, <174, 174, 174>, <174, 174, 174>, <174, 174, 174>,
			<173, 173, 173>, <173, 173, 173>, <173, 173, 173>, <173, 173, 173>,
			<173, 173, 173>, <173, 173, 173>, <173, 173, 173>, <173, 173, 173>,
			<173, 173, 173>, <173, 173, 173>, <173, 173, 173>, <173, 173, 173>,
			<173, 173, 173>, <173, 173, 173>, <174, 174, 174>, <174, 174, 174>,
			<174, 174, 174>, <174, 174, 174>, <174, 174, 174>, <174, 174, 174>,
			<174, 174, 174>, <174, 174, 174>, <174, 174, 174>, <174, 174, 174>,
			<174, 174, 174>, <174, 174, 174>, <174, 174, 174>, <174, 174, 174>,
			<173, 173, 173>, <173, 173, 173>, <173, 173, 173>, <173, 173, 173>,
			<173, 173, 173>, <173, 173, 173>, <173, 173, 173>, <173, 173, 173>,
			<173, 173, 173>, <173, 173, 173>, <174, 174, 174>, <174, 174, 174>,
			<174, 174, 174>, <174, 174, 174>, <174, 174, 174>, <174, 174, 174>,
			<174, 174, 174>, <174, 174, 174>, <174, 174, 174>, <174, 174, 174>,
			<174, 174, 174>, <174, 174, 174>, <174, 174, 174>, <174, 174, 174>,
			<174, 174, 174>, <173, 173, 173>, <173, 173, 173>, <173, 173, 173>,
			<173, 173, 173>, <173, 173, 173>, <173, 173, 173>, <173, 173, 173>,
			<173, 173, 173>, <173, 173, 173>, <173, 173, 173>, <173, 173, 173>,
			<173, 173, 173>, <173, 173, 173>, <173, 173, 173>, <173, 173, 173>,
			<173, 173, 173>, <174, 174, 174>, <174, 174, 174>, <174, 174, 174>,
			<174, 174, 174>, <174, 174, 174>, <174, 174, 174>, <174, 174, 174>,
			<174, 174, 174>, <174, 174, 174>, <174, 174, 174>, <174, 174, 174>,
			<174, 174, 174>, <174, 174, 174>, <174, 174, 174>, <173, 173, 173>,
			<173, 173, 173>, <173, 173, 173>, <173, 173, 173>, <173, 173, 173>,
			<173, 173, 173>, <173, 173, 173>, <173, 173, 173>, <173, 173, 173>,
			<173, 173, 173>, <173, 173, 173>, <173, 173, 173>, <173, 173, 173>,
			<173, 173, 173>, <174, 174, 174>, <174, 174, 174>, <174, 174, 174>,
			<174, 174, 174>, <174, 174, 174>, <174, 174, 174>, <174, 174, 174>,
			<174, 174, 174>, <174, 174, 174>, <174, 174, 174>, <174, 174, 174>,
			<174, 174, 174>, <173, 173, 173>, <173, 173, 173>, <174, 174, 174>,
			<174, 174, 174>, <174, 174, 174>, <174, 174, 174>, <174, 174, 174>,
			<174, 174, 174>, <174, 174, 174>, <174, 174, 174>, <174, 174, 174>,
			<174, 174, 174>, <174, 174, 174>, <174, 174, 174>, <174, 174, 174>,
			<174, 174, 174>, <174, 174, 174>, <173, 173, 173>, <173, 173, 173>,
			<173, 173, 173>, <173, 173, 173>, <173, 173, 173>, <173, 173, 173>,
			<173, 173, 173>, <173, 173, 173>, <173, 173, 173>, <173, 173, 173>,
			<173, 173, 173>, <173, 173, 173>, <173, 173, 173>, <173, 173, 173>,
			<173, 173, 173>, <173, 173, 173>, <174, 174, 174>, <174, 174, 174>,
			<174, 174, 174>, <174, 174, 174>, <174, 174, 174>, <174, 174, 174>,
			<174, 174, 174>, <174, 174, 174>, <174, 174, 174>, <174, 174, 174>,
			<174, 174, 174>, <174, 174, 174>, <174, 174, 174>, <174, 174, 174>,
			<173, 173, 173>, <173, 173, 173>, <173, 173, 173>, <173, 173, 173>,
			<173, 173, 173>, <173, 173, 173>, <173, 173, 173>, <173, 173, 173>,
			<173, 173, 173>, <173, 173, 173>, <173, 173, 173>, <173, 173, 173>,
			<173, 173, 173>, <173, 173, 173>, <174, 174, 174>, <174, 174, 174>,
			<174, 174, 174>, <174, 174, 174>, <174, 174, 174>, <174, 174, 174>,
			<174, 174, 174>, <174, 174, 174>, <174, 174, 174>, <174, 174, 174>,
			<346, 347, 346>, <346, 346, 346>, <346, 346, 346>, <346, 346, 346>,
			<346, 346, 346>, <346, 346, 346>, <346, 346, 346>, <346, 346, 346>,
			<346, 346, 346>, <346, 346, 346>, <346, 346, 346>, <346, 346, 346>,
			<346, 346, 346>, <346, 346, 346>, <346, 346, 346>, <346, 346, 346>,
			<346, 346, 346>, <346, 346, 346>, <346, 346, 346>, <346, 346, 346>,
			<346, 346, 346>, <346, 346, 346>, <346, 346, 346>, <346, 346, 346>,
			<346, 346, 346>, <346, 346, 346>, <346, 346, 346>, <346, 346, 346>,
			<346, 346, 346>, <347, 346, 346>, <346, 347, 346>, <346, 346, 346>,
			<346, 346, 346>, <346, 346, 346>, <346, 346, 346>, <346, 346, 346>,
			<346, 346, 346>, <346, 346, 346>, <346, 346, 346>, <346, 346, 346>,
			<346, 346, 346>, <346, 346, 346>, <346, 346, 346>, <346, 346, 346>,
			<346, 346, 346>, <346, 346, 346>, <346, 346, 346>, <346, 346, 346>,
			<346, 346, 346>, <346, 346, 346>, <346, 346, 346>, <346, 346, 346>,
			<346, 346, 346>, <346, 346, 346>, <346, 346, 346>, <346, 346, 346>,
			<346, 346, 346>, <346, 346, 346>, <346, 346, 346>, <347, 346, 346>,
			<143, 143, 141>, <143, 141, 141>, <145, 145, 143>, <145, 143, 143>,
			<147, 147, 145>, <147, 145, 145>, <151, 151, 153>, <151, 153, 153>,
			<155, 155, 151>, <155, 151, 151>, <161, 161, 155>, <161, 155, 155>,
			<163, 163, 161>, <163, 161, 161>, <163, 163, 163>, <163, 163, 163>,
			<171, 171, 167>, <171, 167, 167>, <173, 173, 171>, <173, 171, 171>,
			<175, 175, 173>, <175, 173, 173>, <179, 179, 175>, <179, 175, 175>,
			<183, 183, 183>, <183, 183, 183>, <185, 185, 183>, <185, 183, 183>,
			<191, 191, 185>, <191, 185, 185>, <195, 195, 191>, <195, 191, 191>,
			<193, 193, 195>, <193, 195, 195>, <201, 201, 199>, <201, 199, 199>,
			<203, 203, 201>, <203, 201, 201>, <205, 205, 203>, <205, 203, 203>,
			<204, 204, 206>, <204, 206, 206>, <202, 202, 204>, <202, 204, 204>,
			<200, 200, 202>, <200, 202, 202>, <196, 196, 194>, <196, 194, 194>,
			<192, 192, 196>, <192, 196, 196>, <186, 186, 192>, <186, 192, 192>,
			<184, 184, 186>, <184, 186, 186>, <184, 184, 184>, <184, 184, 184>,
			<176, 176, 180>, <176, 180, 180>, <174, 174, 176>, <174, 176, 176>,
			<172, 172, 174>, <172, 174, 174>, <168, 168, 172>, <168, 172, 172>,
			<164, 164, 164>, <164, 164, 164>, <162, 162, 164>, <162, 164, 164>,
			<156, 156, 162>, <156, 162, 162>, <152, 152, 156>, <152, 156, 156>,
			<154, 154, 152>, <154, 152, 152>, <146, 146, 148>, <146, 148, 148>,
			<144, 144, 146>, <144, 146, 146>, <142, 142, 144>, <142, 144, 144>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 1>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 1>,
			<107, 118, 113>, <118, 128, 113>, <209, 209, 209>, <209, 209, 209>,
			<230, 218, 128>, <230, 128, 118>, <230, 233, 218>, <239, 233, 230>,
			<209, 209, 209>, <209, 209, 209>, <0, 0, 0>, <346, 346, 346>,
			<219, 129, 140>, <219, 140, 140>, <209, 209, 209>, <209, 209, 209>,
			<0, 0, 0>, <346, 346, 346>, <139, 139, 128>, <139, 128, 218>,
			<0, 0, 0>, <0, 0, 0>, <346, 346, 346>, <346, 346, 346>,
			<209, 209, 209>, <209, 209, 209>, <118, 119, 228>, <118, 228, 138>,
			<114, 119, 108>, <129, 119, 114>, <209, 209, 209>, <209, 209, 209>,
			<219, 228, 119>, <219, 119, 129>, <219, 234, 228>, <234, 240, 228>,
			<74, 62, 62>, <62, 54, 62>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <282, 282, 290>, <270, 282, 282>,
			<0, 0, 0>, <0, 0, 0>, <346, 346, 346>, <346, 346, 346>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<70, 66, 66>, <66, 58, 66>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <278, 278, 286>, <274, 278, 278>,
			<0, 0, 0>, <0, 0, 0>, <346, 346, 346>, <346, 346, 346>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<67, 67, 71>, <59, 67, 67>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <287, 279, 279>, <279, 275, 279>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<0, 0, 0>, <0, 0, 0>, <346, 346, 346>, <346, 346, 346>,
			<150, 150, 150>, <150, 150, 150>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <0, 0, 0>, <0, 0, 0>,
			<346, 346, 346>, <346, 346, 346>, <149, 149, 149>, <149, 149, 149>,
			<0, 0, 0>, <0, 0, 0>, <346, 346, 346>, <346, 346, 346>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<63, 63, 75>, <55, 63, 63>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <291, 283, 283>, <283, 271, 283>,
			<78, 96, 96>, <96, 103, 96>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <248, 248, 241>, <266, 248, 248>,
			<138, 138, 138>, <130, 134, 159>, <157, 159, 134>, <209, 209, 209>,
			<210, 159, 157>, <159, 210, 214>, <0, 0, 0>, <0, 0, 0>,
			<346, 346, 346>, <346, 346, 346>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <50, 46, 46>, <46, 42, 46>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<298, 298, 302>, <294, 298, 298>, <0, 0, 0>, <0, 0, 0>,
			<346, 346, 346>, <346, 346, 346>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <20, 26, 20>, <20, 20, 16>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<324, 322, 324>, <324, 324, 328>, <0, 0, 0>, <0, 0, 0>,
			<346, 346, 346>, <346, 346, 346>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <21, 18, 21>, <21, 21, 24>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<325, 330, 325>, <325, 325, 320>, <0, 0, 0>, <0, 0, 0>,
			<346, 346, 346>, <346, 346, 346>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <47, 47, 51>, <43, 47, 47>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<303, 299, 299>, <299, 295, 299>, <0, 0, 0>, <0, 0, 0>,
			<346, 346, 346>, <346, 346, 346>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <209, 209, 209>, <135, 160, 158>,
			<160, 135, 131>, <138, 138, 138>, <215, 211, 160>, <158, 160, 211>,
			<97, 97, 79>, <104, 97, 97>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <242, 249, 249>, <249, 267, 249>,
			<90, 86, 86>, <86, 82, 86>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <258, 245, 262>, <254, 245, 258>,
			<209, 209, 209>, <117, 122, 169>, <122, 165, 169>, <138, 138, 138>,
			<209, 209, 209>, <223, 169, 165>, <245, 169, 223>, <138, 138, 138>,
			<0, 0, 0>, <0, 0, 0>, <346, 346, 346>, <346, 346, 346>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<38, 34, 34>, <34, 30, 34>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <310, 310, 314>, <306, 310, 310>,
			<0, 0, 0>, <0, 0, 0>, <346, 346, 346>, <346, 346, 346>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<10, 8, 10>, <10, 10, 4>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <334, 332, 334>, <334, 334, 340>,
			<0, 0, 0>, <0, 0, 0>, <346, 346, 346>, <346, 346, 346>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<11, 5, 11>, <11, 11, 9>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <335, 341, 335>, <335, 335, 333>,
			<0, 0, 0>, <0, 0, 0>, <346, 346, 346>, <346, 346, 346>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<35, 35, 39>, <31, 35, 35>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <315, 311, 311>, <311, 307, 311>,
			<0, 0, 0>, <0, 0, 0>, <346, 346, 346>, <346, 346, 346>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<209, 209, 209>, <123, 170, 166>, <100, 170, 123>, <138, 138, 138>,
			<209, 209, 209>, <246, 224, 170>, <224, 166, 170>, <138, 138, 138>,
			<100, 87, 91>, <83, 87, 100>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <263, 246, 259>, <246, 255, 259>,
			<109, 109, 94>, <109, 94, 94>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <237, 237, 252>, <237, 252, 252>,
			<209, 209, 209>, <173, 173, 109>, <173, 109, 109>, <138, 138, 138>,
			<209, 209, 209>, <173, 173, 237>, <173, 237, 237>, <138, 138, 138>,
			<0, 0, 0>, <0, 0, 0>, <346, 346, 346>, <346, 346, 346>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<28, 28, 28>, <28, 28, 28>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <318, 318, 318>, <318, 318, 318>,
			<0, 0, 0>, <0, 0, 0>, <346, 346, 346>, <346, 346, 346>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<2, 2, 2>, <2, 2, 2>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <344, 344, 344>, <344, 344, 344>,
			<0, 0, 0>, <0, 0, 0>, <346, 346, 346>, <346, 346, 346>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<3, 3, 3>, <3, 3, 3>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <345, 345, 345>, <345, 345, 345>,
			<0, 0, 0>, <0, 0, 0>, <346, 346, 346>, <346, 346, 346>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<29, 29, 29>, <29, 29, 29>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <319, 319, 319>, <319, 319, 319>,
			<0, 0, 0>, <0, 0, 0>, <346, 346, 346>, <346, 346, 346>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<209, 209, 209>, <174, 174, 110>, <174, 110, 110>, <138, 138, 138>,
			<209, 209, 209>, <174, 174, 238>, <174, 238, 238>, <138, 138, 138>,
			<95, 95, 110>, <95, 110, 110>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <253, 253, 238>, <253, 238, 238>,
			<88, 101, 84>, <92, 101, 88>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <256, 260, 260>, <260, 264, 260>,
			<209, 209, 209>, <124, 177, 181>, <101, 177, 124>, <138, 138, 138>,
			<209, 209, 209>, <229, 225, 177>, <225, 181, 177>, <138, 138, 138>,
			<0, 0, 0>, <0, 0, 0>, <346, 346, 346>, <346, 346, 346>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<36, 36, 32>, <40, 36, 36>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <308, 312, 312>, <312, 316, 312>,
			<0, 0, 0>, <0, 0, 0>, <346, 346, 346>, <346, 346, 346>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<12, 14, 12>, <12, 12, 6>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <336, 338, 336>, <336, 336, 342>,
			<0, 0, 0>, <0, 0, 0>, <346, 346, 346>, <346, 346, 346>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<13, 7, 13>, <13, 13, 15>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <337, 343, 337>, <337, 337, 339>,
			<0, 0, 0>, <0, 0, 0>, <346, 346, 346>, <346, 346, 346>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<33, 37, 37>, <37, 41, 37>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <313, 313, 309>, <317, 313, 313>,
			<0, 0, 0>, <0, 0, 0>, <346, 346, 346>, <346, 346, 346>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<209, 209, 209>, <125, 182, 178>, <138, 138, 138>, <209, 209, 209>,
			<226, 178, 182>, <247, 178, 226>, <125, 178, 102>, <138, 138, 138>,
			<85, 102, 89>, <102, 93, 89>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <247, 261, 257>, <265, 261, 247>,
			<98, 98, 105>, <80, 98, 98>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <268, 250, 250>, <250, 243, 250>,
			<187, 189, 136>, <187, 136, 132>, <138, 138, 138>, <187, 216, 212>,
			<187, 212, 189>, <209, 209, 209>, <0, 0, 0>, <0, 0, 0>,
			<346, 346, 346>, <346, 346, 346>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <44, 48, 48>, <48, 52, 48>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<300, 296, 300>, <300, 300, 304>, <0, 0, 0>, <0, 0, 0>,
			<346, 346, 346>, <346, 346, 346>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <22, 25, 22>, <22, 22, 19>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<326, 321, 326>, <326, 326, 331>, <0, 0, 0>, <0, 0, 0>,
			<346, 346, 346>, <346, 346, 346>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <23, 17, 23>, <23, 23, 27>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<327, 329, 327>, <327, 327, 323>, <0, 0, 0>, <0, 0, 0>,
			<346, 346, 346>, <346, 346, 346>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <49, 45, 49>, <49, 49, 53>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<297, 301, 301>, <301, 305, 301>, <0, 0, 0>, <0, 0, 0>,
			<346, 346, 346>, <346, 346, 346>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <133, 137, 188>, <137, 190, 188>,
			<209, 209, 209>, <188, 190, 213>, <188, 213, 217>, <138, 138, 138>,
			<99, 99, 106>, <81, 99, 99>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <251, 269, 251>, <251, 251, 244>,
			<64, 56, 64>, <64, 64, 76>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <284, 284, 272>, <292, 284, 284>,
			<0, 0, 0>, <0, 0, 0>, <346, 346, 346>, <346, 346, 346>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<68, 60, 68>, <68, 68, 72>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <280, 280, 276>, <288, 280, 280>,
			<0, 0, 0>, <0, 0, 0>, <346, 346, 346>, <346, 346, 346>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<69, 69, 61>, <73, 69, 69>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <281, 277, 281>, <281, 281, 289>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<0, 0, 0>, <0, 0, 0>, <346, 346, 346>, <346, 346, 346>,
			<198, 198, 198>, <198, 198, 198>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <0, 0, 0>, <0, 0, 0>,
			<346, 346, 346>, <346, 346, 346>, <197, 197, 197>, <197, 197, 197>,
			<0, 0, 0>, <0, 0, 0>, <346, 346, 346>, <346, 346, 346>,
			<209, 209, 209>, <209, 209, 209>, <138, 138, 138>, <138, 138, 138>,
			<65, 65, 57>, <77, 65, 65>, <209, 209, 209>, <209, 209, 209>,
			<138, 138, 138>, <138, 138, 138>, <285, 273, 285>, <285, 285, 293>,
			<115, 126, 120>, <115, 120, 111>, <220, 222, 120>, <220, 120, 126>,
			<138, 138, 138>, <138, 138, 138>, <222, 231, 235>, <220, 231, 222>,
			<138, 138, 138>, <138, 138, 138>, <0, 0, 0>, <346, 346, 346>,
			<208, 208, 127>, <208, 127, 221>, <138, 138, 138>, <138, 138, 138>,
			<0, 0, 0>, <346, 346, 346>, <220, 126, 207>, <220, 207, 207>,
			<0, 0, 0>, <0, 0, 0>, <346, 346, 346>, <346, 346, 346>,
			<222, 227, 121>, <222, 121, 120>, <138, 138, 138>, <138, 138, 138>,
			<116, 121, 127>, <112, 121, 116>, <227, 221, 127>, <227, 127, 121>,
			<138, 138, 138>, <138, 138, 138>, <227, 236, 232>, <227, 232, 221>
		}
	}
}
#end

#include "lg_41539.inc" // Plate  8 x  8

#include "lg_3034.inc" // Plate  2 x  8

#declare LDX_building_001_park_dot_ldr = union {
// Sidewalk Town Square
// Author: John VanZwieten
// Name: building_001_park.ldr
// Unofficial Datsville Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-280,-8,280>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-240,-8,240>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-200,-8,200>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-160,-8,160>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-120,-8,120>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-280,-8,-280>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-240,-8,-240>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-200,-8,-200>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-160,-8,-160>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-120,-8,-120>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-140,-8,-80>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-160,-8,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-180,-8,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-160,-8,40>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-140,-8,80>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,-8,140>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-40,-8,160>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-8,180>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,40,-8,160>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,-8,140>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-290,-8,310>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-310,-8,290>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-310,-8,310>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-250,-8,270>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-270,-8,250>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-210,-8,230>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-230,-8,210>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-170,-8,190>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-190,-8,170>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-130,-8,150>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-150,-8,130>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-150,-8,-130>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-130,-8,-150>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-190,-8,-170>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-170,-8,-190>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-210,-8,-230>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-230,-8,-210>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-250,-8,-270>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-270,-8,-250>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-310,-8,-290>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-310,-8,-310>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-290,-8,-310>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
// 1 2 -2560 0 640 1 0 0 0 1 0 0 0 1 3811.dat
// 1 0 -3200 0 640 0 0 -1 0 1 0 1 0 0 425p01.dat
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-310,-8,-270>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-270,-8,-310>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-230,-8,-270>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-190,-8,-230>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-150,-8,-190>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,150,-8,-190>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,230,-8,-270>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,270,-8,-310>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,190,-8,-230>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-110,-8,-150>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-230,-8,-190>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-270,-8,-230>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-190,-8,-150>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-150,-8,-110>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3035
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 80, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-240,-8,-100>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3035
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 80, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-100,-8,-240>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3035
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 80, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,100,-8,-240>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3958
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 120, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,0,-8,-260>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,-40,-8,-190>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,40,-8,-190>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3035
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 80, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-240,-8,100>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3035
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 80, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-100,-8,240>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3035
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 80, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,100,-8,240>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3958
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 120, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-260,-8,0>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3958
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 120, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-8,260>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-40,-8,190>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,40,-8,190>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3795
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 40, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-260,-8,-160>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3795
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 40, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-160,-8,-260>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3795
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 40, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-260,-8,160>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3795
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 40, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-160,-8,260>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3020
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 40, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-280,-8,200>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3020
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 40, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-200,-8,280>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3022
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 40, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-300,-8,240>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3022
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 40, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-240,-8,300>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-310,-8,270>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-270,-8,310>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-230,-8,270>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-190,-8,230>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-150,-8,190>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,150,-8,190>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,190,-8,230>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,230,-8,270>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,270,-8,310>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-110,-8,150>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-150,-8,110>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,110,-8,150>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-270,-8,230>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-230,-8,190>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-190,-8,150>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-190,-8,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-190,-8,40>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3022
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 40, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-300,-8,-240>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3022
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 40, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-240,-8,-300>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_2420
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 40, 10, 2, 10)
		matrix <-1,0,0,0,1,0,0,0,-1,-90,-8,-90>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_2420
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 40, 10, 2, 10)
		matrix <0,0,-1,0,1,0,1,0,0,90,-8,-90>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_2420
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 40, 10, 2, 10)
		matrix <1,0,0,0,1,0,0,0,1,90,-8,90>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_2420
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 40, 10, 2, 10)
		matrix <0,0,1,0,1,0,-1,0,0,-90,-8,90>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3666
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 20, 0, 2, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,0,-8,130>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3666
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 20, 0, 2, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,0,-8,-130>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3666
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-130,-8,0>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3666
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,130,-8,0>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-150,-8,0>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,150,-8,0>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-8,-150>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-8,150>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		LDX_infrastructure_streetlamp_2_dot_ldr
		matrix <1,0,0,0,1,0,0,0,1,-180,-8,240>
		#if (version >= 3.1) material #else texture #end { LDXColor8 }
	}
	object {
		LDX_infrastructure_streetlamp_2_dot_ldr
		matrix <1,0,0,0,1,0,0,0,1,-240,-8,180>
		#if (version >= 3.1) material #else texture #end { LDXColor8 }
	}
	object {
		LDX_infrastructure_streetlamp_2_dot_ldr
		matrix <1,0,0,0,1,0,0,0,1,-240,-8,-180>
		#if (version >= 3.1) material #else texture #end { LDXColor8 }
	}
	object {
		LDX_infrastructure_streetlamp_2_dot_ldr
		matrix <1,0,0,0,1,0,0,0,1,-180,-8,-240>
		#if (version >= 3.1) material #else texture #end { LDXColor8 }
	}
// REM Trees
	object {
		LDX_3470_dot_dat
		LDXSeamMatrix(85.639999, 143.880005, 85.860001, 0, -63.940002, 0)
		matrix <1,0,0,0,1,0,0,0,1,-240,-16,80>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		LDX_3470_dot_dat
		LDXSeamMatrix(85.639999, 143.880005, 85.860001, 0, -63.940002, 0)
		matrix <1,0,0,0,1,0,0,0,1,-280,-16,-140>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		LDX_3470_dot_dat
		LDXSeamMatrix(85.639999, 143.880005, 85.860001, 0, -63.940002, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,-16,-260>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3020
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 40, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-280,-8,-200>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3020
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 40, 0, 2, 0)
		matrix <0,0,1,0,1,0,-1,0,0,-200,-8,-280>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
// Other half
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,280,-8,-280>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,240,-8,-240>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,200,-8,-200>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,160,-8,-160>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,120,-8,-120>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,280,-8,280>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,240,-8,240>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,200,-8,200>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,160,-8,160>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,120,-8,120>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,140,-8,80>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,160,-8,40>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,180,-8,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,160,-8,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,140,-8,-80>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,80,-8,-140>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,40,-8,-160>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,0,-8,-180>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,-40,-8,-160>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3068b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 40, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,-80,-8,-140>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,290,-8,-310>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,310,-8,-290>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,310,-8,-310>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,250,-8,-270>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,270,-8,-250>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,210,-8,-230>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,230,-8,-210>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,170,-8,-190>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,190,-8,-170>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,130,-8,-150>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,150,-8,-130>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,150,-8,130>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,130,-8,150>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,190,-8,170>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,170,-8,190>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,210,-8,230>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,230,-8,210>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,250,-8,270>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,270,-8,250>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,310,-8,290>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,310,-8,310>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3070a
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 8, 20, 0, 4, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,290,-8,310>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
// 1 2 -2560 0 640 1 0 0 0 1 0 0 0 1 3811.dat
// 1 0 -3200 0 640 0 0 -1 0 1 0 1 0 0 425p01.dat
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <0,0,1,0,1,0,-1,0,0,310,-8,270>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <0,0,1,0,1,0,-1,0,0,230,-8,190>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <0,0,1,0,1,0,-1,0,0,190,-8,150>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <0,0,1,0,1,0,-1,0,0,150,-8,110>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3035
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 80, 0, 2, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,240,-8,100>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3035
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 80, 0, 2, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,240,-8,-100>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3795
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 40, 0, 2, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,260,-8,160>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3795
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 40, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,160,-8,260>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_41539
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 160, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,0,-8,0>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3034
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 40, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-100,-8,0>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3034
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 40, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,100,-8,0>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3034
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 40, 0, 2, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,0,-8,100>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3034
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 40, 0, 2, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,0,-8,-100>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3795
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 40, 0, 2, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,260,-8,40>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3795
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 40, 0, 2, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,260,-8,0>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3795
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 40, 0, 2, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,260,-8,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3795
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 40, 0, 2, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,260,-8,-160>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3795
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 40, 0, 2, 0)
		matrix <0,0,1,0,1,0,-1,0,0,160,-8,-260>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3020
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 40, 0, 2, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,280,-8,-200>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3020
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 40, 0, 2, 0)
		matrix <0,0,1,0,1,0,-1,0,0,200,-8,-280>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3022
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 40, 0, 2, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,300,-8,-240>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3022
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 40, 0, 2, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,240,-8,-300>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,310,-8,-270>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,270,-8,-230>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,230,-8,-190>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,190,-8,-150>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,150,-8,-110>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,110,-8,-150>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,1,0,1,0,-1,0,0,190,-8,40>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,1,0,1,0,-1,0,0,190,-8,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3022
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 40, 0, 2, 0)
		matrix <0,0,1,0,1,0,-1,0,0,300,-8,240>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3022
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 40, 0, 2, 0)
		matrix <0,0,1,0,1,0,-1,0,0,240,-8,300>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		LDX_infrastructure_streetlamp_2_dot_ldr
		matrix <-1,0,0,0,1,0,0,0,-1,180,-8,-240>
		#if (version >= 3.1) material #else texture #end { LDXColor8 }
	}
	object {
		LDX_infrastructure_streetlamp_2_dot_ldr
		matrix <-1,0,0,0,1,0,0,0,-1,240,-8,-180>
		#if (version >= 3.1) material #else texture #end { LDXColor8 }
	}
	object {
		LDX_infrastructure_streetlamp_2_dot_ldr
		matrix <-1,0,0,0,1,0,0,0,-1,240,-8,180>
		#if (version >= 3.1) material #else texture #end { LDXColor8 }
	}
	object {
		LDX_infrastructure_streetlamp_2_dot_ldr
		matrix <-1,0,0,0,1,0,0,0,-1,180,-8,240>
		#if (version >= 3.1) material #else texture #end { LDXColor8 }
	}
// REM Trees
	object {
		LDX_3470_dot_dat
		LDXSeamMatrix(85.639999, 143.880005, 85.860001, 0, -63.940002, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,240,-16,-80>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		LDX_3470_dot_dat
		LDXSeamMatrix(85.639999, 143.880005, 85.860001, 0, -63.940002, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,280,-16,140>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		LDX_3470_dot_dat
		LDXSeamMatrix(85.639999, 143.880005, 85.860001, 0, -63.940002, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,80,-16,260>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3020
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 40, 0, 2, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,280,-8,200>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3020
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 40, 0, 2, 0)
		matrix <0,0,1,0,1,0,-1,0,0,200,-8,280>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
}

#include "lg_2577.inc" // Brick  4 x  4 Corner Round

#include "lg_2456.inc" // Brick  2 x  6

#include "lg_3010.inc" // Brick  1 x  4

#include "lg_6187.inc" // Bar  1 x  4 x  2

#include "lg_6222.inc" // Brick  4 x  4 Round with Holes

#include "lg_3039.inc" // Slope Brick 45  2 x  2

#declare LDX_4_dash_4edge_dot_dat = union {
// Circle 1.0
// Name: 4-4edge.dat
// Author: James Jessiman
// !LDRAW_ORG Primitive UPDATE 2005-01
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// !HISTORY 1998-12-15 [PTadmin] Official Update 1998-10
// !HISTORY 2005-12-28 [PTadmin] Official Update 2005-01
// !HISTORY 2007-06-24 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
}

#declare LDX_STUD4A_dot_dat = union {
// Stud Tube Open without Base Edges
// Name: stud4a.dat
// Author: James Jessiman
// !LDRAW_ORG Primitive UPDATE 2009-02
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CCW
// !HISTORY 1999-07-05 [PTadmin] Official Update 1999-05
// !HISTORY 2002-04-04 [sbliss] Modified for BFC compliance
// !HISTORY 2002-04-25 [PTadmin] Official Update 2002-02
// !HISTORY 2007-06-24 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
// !HISTORY 2009-06-21 [cwdee] Update ring references to 4-4ring
// !HISTORY 2009-09-03 [PTadmin] Official Update 2009-02
	object {
		LDX_4_dash_4edge_dot_dat
		matrix <6,0,0,0,1,0,0,0,6,0,-4,0>
	}
	object {
		LDX_4_dash_4edge_dot_dat
		matrix <8,0,0,0,1,0,0,0,8,0,-4,0>
	}
// BFC INVERTNEXT
	object {
		LDX_4_dash_4cyli_dot_dat
		matrix <6,0,0,0,4,0,0,0,6,0,-4,0>
	}
	object {
		LDX_4_dash_4cyli_dot_dat
		matrix <8,0,0,0,4,0,0,0,8,0,-4,0>
	}
	object {
		LDX_4_dash_4ring3_dot_dat
		matrix <2,0,0,0,1,0,0,0,2,0,-4,0>
	}
}

#declare LDX_2_dash_4edge_dot_dat = union {
// Circle 0.5
// Name: 2-4edge.dat
// Author: James Jessiman
// !LDRAW_ORG Primitive ORIGINAL
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// !HISTORY 2007-06-24 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
}

#declare LDX_1_dash_4cyls_dot_dat_in_part = cylinder // Sloped Cylinder 0.25
{
	<0,0,0>,<0,2,0>,1 open
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		plane
		{
			<1,1,0>,0.70710678118654757274
		}
	}
}

#declare LDX_1_dash_4cyls_dot_dat = cylinder // Sloped Cylinder 0.25
{
	<0,0,0>,<0,2,0>,1 open
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		plane
		{
			<1,1,0>,0.70710678118654757274
		}
	}
}

#declare LDX_2_dash_4cyli_dot_dat_in_part = cylinder // Cylinder 0.5
{
	<0,0,0>,<0,1,0>,1 open
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
	}
}

#declare LDX_2_dash_4cyli_dot_dat = cylinder // Cylinder 0.5
{
	<0,0,0>,<0,1,0>,1 open
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
	}
}

#declare LDX_building_001_3039p_JJ_dot_dat = union {
// Slope Brick 45 2 x 2 with JJ Pattern
// Name: building_001_3039p_JJ.dat
// Author: John VanZwieten
// Unofficial Datsville Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
// 3039-4t Slope Brick 45 2 x 2 without sloped front
	#if (LDXStuds)
		object {
			LDX_STUD4A_dot_dat
			matrix <0,0,1,0,-1,0,-1,0,0,10,20,0>
			#if (version >= 3.1) material #else texture #end { LDXColor60 }
		}
	#end // LDXStuds
	object {
		LDX_2_dash_4edge_dot_dat
		matrix <0,0,6,0,1,0,-6,0,0,10,4,0>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	object {
		LDX_2_dash_4edge_dot_dat
		matrix <0,0,6,1,0,0,6,6,0,10,4,0>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	object {
		LDX_2_dash_4edge_dot_dat
		matrix <0,0,8,0,1,0,-8,0,0,10,4,0>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	object {
		LDX_2_dash_4edge_dot_dat
		matrix <0,0,8,1,0,0,8,8,0,10,4,0>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	object {
		LDX_1_dash_4cyls_dot_dat
		matrix <6,0,0,0,-6,0,0,0,6,10,10,0>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	object {
		LDX_1_dash_4cyls_dot_dat
		matrix <6,0,0,0,-6,0,0,0,-6,10,10,0>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	object {
		LDX_2_dash_4cyli_dot_dat
		matrix <0,0,6,0,16,0,-6,0,0,10,4,0>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	object {
		LDX_2_dash_4cyli_dot_dat
		matrix <0,0,6,0,10,0,6,0,0,10,10,0>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	object {
		LDX_1_dash_4cyls_dot_dat
		matrix <8,0,0,0,-8,0,0,0,8,10,12,0>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	object {
		LDX_1_dash_4cyls_dot_dat
		matrix <8,0,0,0,-8,0,0,0,-8,10,20,0>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	object {
		LDX_2_dash_4cyli_dot_dat
		matrix <0,0,8,0,16,0,-8,0,0,10,4,0>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	object {
		LDX_2_dash_4cyli_dot_dat
		matrix <0,0,8,0,8,0,8,0,0,10,12,0>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	#if (LDXStuds)
		object {
			lg_knob
			matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		matrix <0,0,1,0,1,0,-1,0,0,0,0,-10>
			#if (version >= 3.1) material #else texture #end { LDXColor60 }
		}
		object {
			lg_knob
			matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		matrix <0,0,1,0,1,0,-1,0,0,0,0,10>
			#if (version >= 3.1) material #else texture #end { LDXColor60 }
		}
	#end // LDXStuds
// /3039-4t Slope Brick 45 2 x 2 without sloped front
	mesh2 {
		vertex_vectors {
			24,
			<12.857,2.857,-18>, <12.857,2.857,-4>, <12.857,2.857,2>, <12.857,2.857,16>,
			<15.714,5.714,-18>, <15.714,5.714,-12>, <15.714,5.714,-8>, <15.714,5.714,-4>,
			<15.714,5.714,2>, <15.714,5.714,8>, <15.714,5.714,12>, <15.714,5.714,16>,
			<22.857,12.857,-12>, <22.857,12.857,8>, <24.285999,14.286,-16>, <24.285999,14.286,-14>,
			<24.285999,14.286,-8>, <24.285999,14.286,4>, <24.285999,14.286,6>, <24.285999,14.286,12>,
			<27.143,17.143,-16>, <27.143,17.143,-12>, <27.143,17.143,4>, <27.143,17.143,8>
		}
		normal_vectors {
			2,
			<-0.707107,0.707107,0>, <0.707107,-0.707107,0>
		}
		face_indices {
			16,
			<0, 1, 7>, <0, 7, 4>, <5, 6, 16>, <5, 16, 12>,
			<16, 12, 15>, <16, 15, 21>, <21, 15, 14>, <21, 14, 20>,
			<2, 3, 11>, <2, 11, 8>, <9, 10, 19>, <9, 19, 13>,
			<13, 19, 23>, <13, 23, 18>, <18, 17, 22>, <18, 22, 23>
		}
		normal_indices {
			16,
			<1, 1, 1>, <1, 1, 1>, <1, 1, 1>, <1, 1, 1>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<1, 1, 1>, <1, 1, 1>, <1, 1, 1>, <1, 1, 1>,
			<1, 1, 1>, <1, 1, 1>, <0, 0, 0>, <0, 0, 0>
		}
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	mesh2 {
		vertex_vectors {
			45,
			<-10,0,-20>, <-10,0,20>, <-10,24,-20>, <-10,24,20>,
			<-6,4,-16>, <-6,4,16>, <-6,24,-16>, <-6,24,16>,
			<10,0,-20>, <10,0,20>, <10,4,-16>, <10,4,16>,
			<12.857,2.857,-18>, <12.857,2.857,-4>, <12.857,2.857,2>, <12.857,2.857,16>,
			<15.714,5.714,-18>, <15.714,5.714,-12>, <15.714,5.714,-8>, <15.714,5.714,-4>,
			<15.714,5.714,2>, <15.714,5.714,8>, <15.714,5.714,12>, <15.714,5.714,16>,
			<20,10,-20>, <22.857,12.857,-12>, <22.857,12.857,8>, <24.285999,14.286,-16>,
			<24.285999,14.286,-14>, <24.285999,14.286,-8>, <24.285999,14.286,4>, <24.285999,14.286,6>,
			<24.285999,14.286,12>, <26,20,-16>, <26,20,16>, <26,24,-16>,
			<26,24,16>, <27.143,17.143,-16>, <27.143,17.143,-12>, <27.143,17.143,4>,
			<27.143,17.143,8>, <30,20,-20>, <30,20,20>, <30,24,-20>,
			<30,24,20>
		}
		normal_vectors {
			5,
			<-1,0,0>, <-0.707107,0.707107,0>, <0,-1,0>, <0,0,-1>,
			<0.707107,-0.707107,0>
		}
		face_indices {
			60,
			<8, 12, 15>, <8, 15, 9>, <9, 42, 23>, <9, 23, 15>,
			<41, 37, 40>, <41, 40, 42>, <41, 37, 27>, <41, 27, 24>,
			<24, 16, 12>, <24, 12, 8>, <24, 16, 28>, <24, 28, 27>,
			<16, 28, 25>, <16, 25, 17>, <38, 29, 30>, <38, 30, 39>,
			<29, 18, 19>, <29, 19, 30>, <19, 30, 31>, <19, 31, 26>,
			<19, 21, 26>, <19, 20, 14>, <19, 14, 13>, <40, 32, 42>,
			<32, 22, 23>, <32, 23, 42>, <3, 7, 6>, <3, 6, 2>,
			<2, 6, 35>, <2, 35, 43>, <43, 35, 36>, <43, 36, 44>,
			<44, 36, 7>, <44, 7, 3>, <5, 11, 10>, <5, 10, 4>,
			<1, 9, 8>, <1, 8, 0>, <3, 1, 0>, <3, 0, 2>,
			<7, 5, 4>, <7, 4, 6>, <36, 34, 33>, <36, 33, 35>,
			<44, 42, 41>, <44, 41, 43>, <3, 1, 42>, <3, 42, 44>,
			<1, 9, 42>, <7, 5, 34>, <7, 34, 36>, <5, 11, 34>,
			<6, 4, 33>, <6, 33, 35>, <4, 10, 33>, <2, 0, 41>,
			<2, 41, 43>, <0, 8, 41>, <34, 11, 10>, <34, 10, 33>
		}
		normal_indices {
			60,
			<1, 1, 1>, <1, 1, 1>, <4, 4, 4>, <4, 4, 4>,
			<4, 4, 4>, <4, 4, 4>, <1, 1, 1>, <1, 1, 1>,
			<1, 1, 1>, <1, 1, 1>, <4, 4, 4>, <4, 4, 4>,
			<1, 1, 1>, <1, 1, 1>, <4, 4, 4>, <4, 4, 4>,
			<4, 4, 4>, <4, 4, 4>, <1, 1, 1>, <1, 1, 1>,
			<4, 4, 4>, <1, 1, 1>, <1, 1, 1>, <4, 4, 4>,
			<4, 4, 4>, <4, 4, 4>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <3, 3, 3>, <3, 3, 3>,
			<3, 3, 3>, <3, 3, 3>, <3, 3, 3>, <3, 3, 3>,
			<3, 3, 3>, <3, 3, 3>, <3, 3, 3>, <3, 3, 3>,
			<3, 3, 3>, <3, 3, 3>, <1, 1, 1>, <1, 1, 1>
		}
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
}

#include "lg_2432.inc" // Tile  1 x  2 with Handle

#declare LDX_stud3_dot_dat_in_part = union {
// Stud Tube Solid
// Name: stud3.dat
// Author: James Jessiman
// !LDRAW_ORG Primitive UPDATE 2012-01
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CCW
// !HISTORY 2002-04-04 [sbliss] Modified for BFC compliance
// !HISTORY 2002-04-25 [PTadmin] Official Update 2002-02
// !HISTORY 2007-06-24 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
// !HISTORY 2012-02-16 [Philo] Changed to CCW
// !HISTORY 2012-03-30 [PTadmin] Official Update 2012-01
	object {
		LDX_4_dash_4disc_dot_dat_in_part
		matrix <4,0,0,0,1,0,0,0,4,0,-4,0>
	}
	object {
		LDX_4_dash_4cyli_dot_dat_in_part
		matrix <4,0,0,0,4,0,0,0,4,0,-4,0>
	}
}

#declare LDX_3794a_dot_dat =
#if (LDXQual = 0)
box {
	<-20,-4,-10>,<20,8,10>
}
#else
union {
// Plate  1 x  2 without Groove with 1 Centre Stud
// Name: 3794a.dat
// Author: James Jessiman
// !LDRAW_ORG Part UPDATE 2011-02
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CCW
// !KEYWORDS jumper, offset, tile, spacer
// !HISTORY 2002-07-16 [fwcain] Added keywords.
// !HISTORY 2002-08-18 [PTadmin] Official Update 2002-04
// !HISTORY 2004-07-25 [guyvivan] Made BFC Compliant
// !HISTORY 2004-11-06 [PTadmin] Official Update 2004-04
// !HISTORY 2007-06-29 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
// !HISTORY 2011-11-12 [PTadmin] Renamed from 3794
// !HISTORY 2011-12-05 [MagFors] Retitled, was "Plate  1 x  2 with 1 Stud"
// !HISTORY 2011-12-29 [PTadmin] Official Update 2011-02
	#if (LDXStuds)
		object {
			LDX_stud3_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,0,4,0>
		}
	#end // LDXStuds
// BFC INVERTNEXT
	#if (LDXStuds)
		object {
			LDX_stud2_dot_dat_in_part
			matrix <1,0,0,0,1,0,0,0,1,0,0,0>
		}
	#end // LDXStuds
	mesh2 {
		vertex_vectors {
			16,
			<-20,0,-10>, <-20,0,10>, <-20,8,-10>, <-20,8,10>,
			<-16,4,-6>, <-16,4,6>, <-16,8,-6>, <-16,8,6>,
			<16,4,-6>, <16,4,6>, <16,8,-6>, <16,8,6>,
			<20,0,-10>, <20,0,10>, <20,8,-10>, <20,8,10>
		}
		normal_vectors {
			5,
			<-1,0,0>, <0,-1,0>, <0,0,-1>, <0,0,1>,
			<1,0,0>
		}
		face_indices {
			28,
			<5, 9, 8>, <5, 8, 4>, <5, 7, 11>, <5, 11, 9>,
			<4, 6, 7>, <4, 7, 5>, <8, 10, 6>, <8, 6, 4>,
			<9, 11, 10>, <9, 10, 8>, <15, 11, 7>, <15, 7, 3>,
			<3, 7, 6>, <3, 6, 2>, <2, 6, 10>, <2, 10, 14>,
			<14, 10, 11>, <14, 11, 15>, <1, 13, 12>, <1, 12, 0>,
			<1, 3, 15>, <1, 15, 13>, <0, 2, 3>, <0, 3, 1>,
			<12, 14, 2>, <12, 2, 0>, <13, 15, 14>, <13, 14, 12>
		}
		normal_indices {
			28,
			<1, 1, 1>, <1, 1, 1>, <3, 3, 3>, <3, 3, 3>,
			<0, 0, 0>, <0, 0, 0>, <2, 2, 2>, <2, 2, 2>,
			<4, 4, 4>, <4, 4, 4>, <1, 1, 1>, <1, 1, 1>,
			<1, 1, 1>, <1, 1, 1>, <1, 1, 1>, <1, 1, 1>,
			<1, 1, 1>, <1, 1, 1>, <1, 1, 1>, <1, 1, 1>,
			<3, 3, 3>, <3, 3, 3>, <0, 0, 0>, <0, 0, 0>,
			<2, 2, 2>, <2, 2, 2>, <4, 4, 4>, <4, 4, 4>
		}
	}
}
#end

#include "lg_2555.inc" // Tile  1 x  1 with Clip

#declare LDX_building_001_3024_dot_dat = union {
// Plate  1 x  1 TransYellow with POV Light
// Name: 3024.dat
// Author: Tore Eriksson
// Unofficial Datsville Model
// // Generated by DatShine v1.02
// // based on work by James Jessiman
// // Credits to Anders Isaksson and Tim Gould
// // http://news.lugnet.com/cad/ray/?n=2764
// orig:
// fade_distance 60.0
// boxes were causing POV-Ray to crash
// WAS L3P IFPOV
// light_source {
// <0, 0, 0>
// color rgb 0.5*<1,0.905882,0.211765>
// fade_distance 500
// fade_power 1.6
// looks_like {_3024_dot_dat texture {
// pigment { rgbf <1,0.905882,0.211765,0.90> }
// finish { ambient 0.6 diffuse 0 phong 0.5 phong_size 40
// reflection 0.9
// refraction 1 ior 1.25
// }
// }
// }    }
// WAS L3P ELSEPOV
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		lg_3024_clear
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
		#if (version >= 3.1) material #else texture #end { LDXColor46 }
	}
// WAS L3P ENDPOV
}

#declare LDX_building_001_jjlite_dot_ldr = union {
// Spotlight
// Name: building_001_jjlite.ldr
// Author: John VanZwieten
// Unofficial Datsville Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		lg_2555
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 18, 20, 0, -1, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,6,0>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		LDX_building_001_3024_dot_dat
		matrix <1,0,0,0,1,0,0,0,1,0,14,0>
		#if (version >= 3.1) material #else texture #end { LDXColor46 }
	}
}

#declare LDX_1_dash_4cylc_dot_dat_in_part = union {
// Cylinder Closed 0.25
// Name: 1-4cylc.dat
// Author: Mark Kennedy [mkennedy]
// !LDRAW_ORG Primitive UPDATE 2010-01
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CCW
// !HISTORY 2010-04-05 [PTadmin] Official Update 2010-01
	object {
		LDX_1_dash_4disc_dot_dat_in_part
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
	}
	object {
		LDX_1_dash_4cyli_dot_dat_in_part
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
	}
}

#declare LDX_3_dash_4ndis_dot_dat_in_part = disc // Not-Disc 0.75
{
	<0,0,0>,<0,1,0>,2,1
	clipped_by
	{
		union
		{
			plane
			{
				<0,0,-1>,0
			}
			plane
			{
				<1,0,0>,0
			}
		}
		box
		{
			<-1,-1,-1>,<1,1,1>
		}
	}
}

#declare LDX_3_dash_4ndis_dot_dat = disc // Not-Disc 0.75
{
	<0,0,0>,<0,1,0>,2,1
	clipped_by
	{
		union
		{
			plane
			{
				<0,0,-1>,0
			}
			plane
			{
				<1,0,0>,0
			}
		}
		box
		{
			<-1,-1,-1>,<1,1,1>
		}
	}
}

#declare LDX_s_slash_3816s02_dot_dat_in_part = union {
// ~Minifig Leg Right without Front and Side Surfaces
// Name: s\3816s02.dat
// Author: Magnus Forsberg [MagFors]
// !LDRAW_ORG Subpart UPDATE 2013-02
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CW
// !HISTORY 2013-12-23 [PTadmin] Official Update 2013-02
// // Interior
// BFC INVERTNEXT
	object {
		LDX_4_dash_4cylo_dot_dat_in_part
		matrix <6,0,0,0,0,4,0,6,0,-10,18,5>
	}
	object {
		LDX_4_dash_4ndis_dot_dat_in_part
		matrix <6,0,0,0,0,1,0,6,0,-10,18,5>
	}
// BFC INVERTNEXT
// BFC INVERTNEXT
// // Bottom
// // Front
// // Side out
// // Side in
// // Side out
// BFC INVERTNEXT
	object {
		LDX_4_dash_4cylo_dot_dat_in_part
		matrix <0,3,0,5.72,0,0,0,0,3,-7.72,0,0>
	}
// // Hole side
// BFC INVERTNEXT
	object {
		LDX_1_dash_4cylc_dot_dat_in_part
		matrix <0,-6,0,6.62,0,0,0,0,-6,-14.34,0,0>
	}
	object {
		LDX_1_dash_4ring1_dot_dat_in_part
		matrix <0,-3,0,1,0,0,0,0,-3,-7.72,0,0>
	}
	object {
		LDX_3_dash_4ndis_dot_dat_in_part
		matrix <0,0,-3,1,0,0,0,3,0,-7.72,0,0>
	}
// // inner cyl
// // topside
// // backside
// // backside bottom
	object {
		LDX_4_dash_4ndis_dot_dat_in_part
		matrix <6,0,0,0,0,-1,0,6,0,-10,18,9>
	}
}

#declare LDX_s_slash_3816s01_dot_dat_in_part = union {
// ~Minifig Leg Right without Front Surfaces
// Name: s\3816s01.dat
// Author: Steve Bliss [sbliss]
// !LDRAW_ORG Subpart UPDATE 2013-02
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CW
// !HISTORY 1999-02-01 [PTadmin] Official Update 1999-01
// !HISTORY 2002-05-29 [fwcain]  removed all front surfaces (put into "main" file[s])...
// !HISTORY 2002-08-18 [PTadmin] Official Update 2002-04
// !HISTORY 2007-09-13 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
// !HISTORY 2008-07-07 [tchang]  Add BFC, partially rebuild
// !HISTORY 2008-12-31 [tchang]  Corrected some conditional lines
// !HISTORY 2009-08-24 [PTadmin] Renamed from s/971s01
// !HISTORY 2009-12-29 [PTadmin] Official Update 2009-03
// !HISTORY 2013-04-01 [tchang]  Suppress overlap faces
// !HISTORY 2013-04-03 [MagFors] Used new file s\3816s02.dat
// !HISTORY 2013-12-23 [PTadmin] Official Update 2013-02
	object {
		LDX_s_slash_3816s02_dot_dat_in_part
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
	}
// // outer side surface
}

#declare LDX_s_slash_3817s01_dot_dat_in_part = union {
// ~Minifig Leg Left without Front Surfaces
// Name: s\3817s01.dat
// Author: Steve Bliss [sbliss]
// !LDRAW_ORG Subpart UPDATE 2009-03
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CW
// !HISTORY 1999-02-01 [PTadmin] Official Update 1999-01
// !HISTORY 2002-05-29 [fwcain]  removed all front surfaces (put into "main" file[s])
// !HISTORY 2002-08-18 [PTadmin] Official Update 2002-04
// !HISTORY 2003-07-01 [sbliss]  Changed to be a mirror reference to 971s01
// !HISTORY 2003-12-19 [PTadmin] Official Update 2003-03
// !HISTORY 2007-09-13 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
// !HISTORY 2009-05-20 [Steffen] BFCed
// !HISTORY 2009-08-24 [PTadmin] Renamed from s/972s01
// !HISTORY 2009-12-29 [PTadmin] Official Update 2009-03
// // Un-Comment these lines for front surfaces:
// // 4 16 2 -6.30 -6.30 2 -3.42 -8.28 18.23 -3.42 -8.28 18.11 -6.30 -6.30
// // 4 16 2 -3.42 -8.28 2 0 -9 18.36 0 -9 18.23 -3.42 -8.28
// // 4 16 2 0 -9 2 3.42 -8.28 18.50 3.42 -8.28 18.36 0 -9
// // 4 16 2 3.42 -8.28 2 6.74 -6 18.64 6.74 -6 18.50 3.42 -8.28
// // 4 16 2 6.74 -6 2 7.70 -6 18.68 7.70 -6 18.64 6.74 -6
// // 4 16 1.50 7.70 -6 1.50 20 -6 19.18 20 -6 18.68 7.70 -6
// // 4 16 1.50 20 -6 1.50 20 -11 19.18 20 -11 19.18 20 -6
// // 4 16 1.50 20 -11 1.50 28 -11 19.50 28 -11 19.18 20 -11
	object {
		LDX_s_slash_3816s01_dot_dat_in_part
		matrix <-1,0,0,0,1,0,0,0,1,0,0,0>
	}
}

#declare LDX_3817_dot_dat =
#if (LDXQual = 0)
box {
	<1.5,-9,-11>,<19.5,28,9>
}
#else
union {
// Minifig Leg Left
// Name: 3817.dat
// Author: Steve Bliss [sbliss]
// !LDRAW_ORG Part UPDATE 2009-03
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CCW
// !HELP Move down 12 units to align with hips
// !HISTORY 1997-10-29 [PTadmin] Official Update 1997-16
// !HISTORY 1999-02-01 [PTadmin] Official Update 1999-01
// !HISTORY 2002-04-10 [fwcain] Fixed overlapping quad...
// !HISTORY 2002-04-25 [PTadmin] Official Update 2002-02
// !HISTORY 2002-05-29 [fwcain] Moved all front surfaces to "main" file (from subfile)...
// !HISTORY 2002-08-18 [PTadmin] Official Update 2002-04
// !HISTORY 2007-07-27 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
// !HISTORY 2008-12-31 [tchang] Add BFC
// !HISTORY 2009-08-24 [PTadmin] Moved from 972
// !HISTORY 2009-12-29 [PTadmin] Official Update 2009-03
	object {
		LDX_s_slash_3817s01_dot_dat_in_part
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
	}
	mesh2 {
		vertex_vectors {
			144,
			<1.5,4.1,9>, <1.5,7,7>, <1.5,7.7,-6>, <1.5,9.2,-3.8>,
			<1.5,9.2,3.8>, <1.5,10,0>, <1.5,20,-11>, <1.5,20,-6>,
			<1.5,28,-11>, <1.5,28,9>, <2,-9,0>, <2,-8.28,-3.42>,
			<2,-8.28,3.42>, <2,-6.3,-6.3>, <2,-6.3,6.3>, <2,-3.42,-8.28>,
			<2,-3.42,8.28>, <2,-3,0>, <2,-2.7717,-1.1481>, <2,-2.7717,1.1481>,
			<2,-2.1213,-2.1213>, <2,-2.1213,2.1213>, <2,-1.1481,-2.7717>, <2,-1.1481,2.7717>,
			<2,0,-9>, <2,0,-3>, <2,0,3>, <2,0,9>,
			<2,1.1481,-2.7717>, <2,1.1481,2.7717>, <2,2.1213,-2.1213>, <2,2.1213,2.1213>,
			<2,2.7717,-1.1481>, <2,2.7717,1.1481>, <2,3,0>, <2,3.42,-8.28>,
			<2,4.1,9>, <2,6.74,-6>, <2,7,7>, <2,7.7,-6>,
			<2,9.2,-3.8>, <2,9.2,3.8>, <2,10,0>, <4,-2,5>,
			<4,-2,8.5789>, <4,8,-3>, <4,8,5>, <4,12,5>,
			<4,12,9>, <4,18,9>, <4,24,-7>, <4,24,-3>,
			<4,24,5>, <4,24,9>, <4,28,-7>, <4,28,5>,
			<4.2824,-3.42,8.28>, <4.3977,0,9>, <4.4566,-4.2962,5>, <4.4566,-4.2962,7.6776>,
			<4.4566,0.2962,5>, <4.4566,0.2962,9>, <5.7574,-6.2426,5>, <5.7574,-6.2426,6.3395>,
			<5.7574,2.2426,5>, <5.7574,2.2426,9>, <5.8433,-6.3,6.3>, <7.1806,-7.1937,5>,
			<7.7038,-7.5434,4.4914>, <7.7038,-7.5434,5>, <7.7038,3.5434,9>, <7.72,-6,0>,
			<7.72,-6,5>, <7.72,-3,0>, <7.72,-3,3>, <7.72,0,-6>,
			<7.72,0,-3>, <7.72,0,3>, <7.72,2.3,-5.54>, <7.72,3,-3>,
			<7.72,3,0>, <7.72,3,3>, <7.72,3.55,-4.71>, <7.72,3.55,5>,
			<10,-8,3.8273>, <10,-8,5>, <10,4,-4.4>, <10,4,9>,
			<10,12,5>, <10,12,9>, <10,24,5>, <10,24,9>,
			<12.2962,-7.5434,4.4914>, <12.2962,-7.5434,5>, <12.2962,3.5434,9>, <12.3,3.54,-4.71>,
			<12.8194,-7.1937,5>, <14.1567,-6.3,6.3>, <14.24,2.24,-5.55>, <14.2426,-6.2426,5>,
			<14.2426,-6.2426,6.3395>, <14.2426,2.2426,9>, <14.34,-6,0>, <14.34,-6,5>,
			<14.34,0,-6>, <14.34,0,0>, <14.34,2.1,-5.58>, <14.34,2.1,5>,
			<15.5434,-4.2962,5>, <15.5434,-4.2962,7.6776>, <15.5434,0.2962,5>, <15.5434,0.2962,9>,
			<15.6023,0,9>, <15.7176,-3.42,8.28>, <16,-2,5>, <16,-2,8.5789>,
			<16,8,-3>, <16,8,5>, <16,12,5>, <16,12,9>,
			<16,18,9>, <16,24,-7>, <16,24,-3>, <16,24,5>,
			<16,24,9>, <16,28,-7>, <16,28,5>, <18,-9,0>,
			<18.030001,-8.28,-3.42>, <18.030001,-8.28,3.42>, <18.110001,-6.3,-6.3>, <18.110001,-6.3,6.3>,
			<18.23,-3.42,-8.28>, <18.23,-3.42,8.28>, <18.360001,0,-9>, <18.360001,0,0>,
			<18.360001,0,9>, <18.5,3.42,-8.28>, <18.639999,6.74,-6>, <18.68,7.7,-6>,
			<19.18,20,-11>, <19.18,20,-6>, <19.5,28,-11>, <19.5,28,9>
		}
		normal_vectors {
			66,
			<-1,0,0>, <-0.999223,0.039404,-0.000587>, <-0.999223,0.039404,0.000587>, <-0.999187,0.040324,-0.00019>,
			<-0.999184,0.040384,0.000734>, <-0.999155,0.041099,-0.000184>, <-0.980804,-0.194997,0>, <-0.980797,0.195031,0>,
			<-0.92388,-0.382681,0>, <-0.923873,0.382698,0>, <-0.7071,-0.707114,0.000002>, <-0.70658,0.707633,0>,
			<-0.658423,0.752648,-0.000298>, <-0.55563,-0.83143,0.000003>, <-0.55569,0.83139,0>, <-0.382722,0.923863,0>,
			<-0.382024,0.924152,-0.000013>, <-0.193633,0.981074,0>, <-0.06566,0.997842,0.000281>, <0,-1,0>,
			<0,-0.566107,0.824332>, <0,-0.393684,0.919246>, <0,0,-1>, <0,0,1>,
			<0,0,1>, <0,0.041349,-0.999145>, <0,0.103573,-0.994622>, <0,0.196116,-0.980581>,
			<0.000216,0.202974,-0.979184>, <0,0.206033,-0.978545>, <0.00001,0.393923,-0.919143>, <0,0.393919,0.919145>,
			<0,0.566537,-0.824036>, <0,0.567733,0.823213>, <0,0.707271,-0.706942>, <0,0.707107,0.707107>,
			<0,0.707623,0.70659>, <0,0.82406,-0.566503>, <0,0.826227,-0.563337>, <0,0.919151,-0.393905>,
			<0,0.919145,0.393919>, <0,0.919905,-0.392141>, <0,1,0>, <0,1,0>,
			<0.001371,0.383264,-0.923638>, <0.001219,0.558127,-0.829755>, <0.001229,0.563073,-0.826406>, <0.002124,0.384694,-0.923042>,
			<0.002061,0.554313,-0.832306>, <0.066967,0.997755,-0.000064>, <0.321057,0.94706,-0.000082>, <0.382722,0.923863,0>,
			<0.443669,0.896191,-0.000166>, <0.555593,-0.831454,0>, <0.55569,0.83139,0>, <0.696419,0.717635,-0.000253>,
			<0.707084,-0.707129,0>, <0.729136,0.684369,-0.000023>, <0.81978,0.572678,-0.000125>, <0.829693,0.558221,0.000145>,
			<0.896639,0.442763,0.000148>, <0.923874,-0.382698,0.000005>, <0.924027,0.382327,0>, <0.980793,-0.195053,0>,
			<0.980797,0.195033,0>, <1,0,0>
		}
		face_indices {
			246,
			<55, 126, 123>, <55, 123, 90>, <55, 90, 52>, <88, 118, 117>,
			<88, 117, 46>, <47, 88, 46>, <122, 51, 45>, <122, 45, 116>,
			<45, 46, 117>, <45, 117, 116>, <51, 52, 46>, <51, 46, 45>,
			<116, 117, 123>, <116, 123, 122>, <122, 123, 126>, <122, 126, 125>,
			<125, 121, 122>, <54, 55, 52>, <54, 52, 51>, <51, 50, 54>,
			<121, 125, 54>, <121, 54, 50>, <121, 50, 51>, <121, 51, 122>,
			<125, 126, 143>, <125, 143, 142>, <126, 55, 9>, <126, 9, 143>,
			<55, 54, 8>, <55, 8, 9>, <54, 125, 142>, <54, 142, 8>,
			<6, 7, 9>, <6, 9, 8>, <2, 3, 7>, <3, 5, 9>,
			<3, 9, 7>, <5, 4, 9>, <4, 1, 9>, <1, 0, 9>,
			<39, 40, 3>, <39, 3, 2>, <40, 42, 5>, <40, 5, 3>,
			<42, 41, 4>, <42, 4, 5>, <41, 38, 1>, <41, 1, 4>,
			<38, 36, 0>, <38, 0, 1>, <27, 36, 31>, <27, 31, 29>,
			<16, 27, 29>, <16, 29, 26>, <14, 16, 26>, <14, 26, 23>,
			<12, 14, 23>, <12, 23, 21>, <10, 12, 21>, <10, 21, 19>,
			<11, 10, 19>, <11, 19, 17>, <13, 11, 17>, <13, 17, 18>,
			<15, 13, 18>, <15, 18, 20>, <24, 15, 20>, <24, 20, 22>,
			<35, 24, 22>, <35, 22, 25>, <37, 35, 25>, <37, 25, 28>,
			<39, 37, 28>, <39, 28, 30>, <40, 39, 30>, <40, 30, 32>,
			<42, 40, 32>, <42, 32, 34>, <41, 42, 34>, <41, 34, 33>,
			<38, 41, 33>, <38, 33, 31>, <38, 31, 36>, <102, 71, 72>,
			<102, 72, 103>, <104, 106, 78>, <104, 78, 75>, <106, 98, 78>,
			<78, 98, 95>, <82, 78, 95>, <82, 95, 86>, <105, 102, 103>,
			<105, 103, 107>, <105, 107, 106>, <105, 106, 104>, <71, 73, 74>,
			<71, 74, 72>, <81, 83, 72>, <81, 72, 77>, <79, 82, 83>,
			<79, 83, 80>, <75, 78, 79>, <75, 79, 76>, <82, 79, 78>,
			<110, 107, 103>, <110, 103, 114>, <108, 114, 103>, <108, 103, 99>,
			<93, 96, 103>, <93, 103, 85>, <85, 103, 72>, <85, 72, 69>,
			<67, 69, 72>, <67, 72, 58>, <43, 58, 72>, <43, 72, 60>,
			<64, 60, 72>, <64, 72, 83>, <94, 87, 86>, <94, 86, 95>,
			<101, 94, 95>, <101, 95, 98>, <101, 98, 106>, <101, 106, 107>,
			<107, 110, 111>, <107, 111, 101>, <112, 111, 110>, <115, 112, 110>,
			<115, 110, 114>, <113, 115, 114>, <113, 114, 108>, <109, 113, 108>,
			<100, 109, 108>, <100, 108, 99>, <97, 100, 99>, <97, 99, 96>,
			<92, 96, 93>, <93, 85, 84>, <93, 84, 92>, <85, 69, 68>,
			<85, 68, 84>, <67, 68, 69>, <66, 67, 62>, <66, 62, 63>,
			<59, 63, 62>, <59, 62, 58>, <56, 59, 58>, <56, 58, 43>,
			<44, 56, 43>, <44, 43, 60>, <44, 60, 57>, <61, 57, 60>,
			<61, 60, 64>, <61, 64, 65>, <65, 64, 83>, <65, 83, 70>,
			<70, 83, 87>, <83, 82, 86>, <83, 86, 87>, <84, 12, 129>,
			<129, 92, 84>, <12, 84, 68>, <12, 68, 67>, <129, 96, 92>,
			<131, 97, 96>, <131, 96, 129>, <67, 66, 14>, <67, 14, 12>,
			<12, 10, 127>, <12, 127, 129>, <10, 11, 128>, <10, 128, 127>,
			<11, 13, 130>, <11, 130, 128>, <136, 112, 115>, <136, 115, 133>,
			<113, 133, 115>, <109, 133, 113>, <133, 109, 100>, <133, 100, 131>,
			<97, 131, 100>, <16, 44, 57>, <16, 57, 27>, <56, 44, 16>,
			<59, 56, 16>, <14, 63, 59>, <14, 59, 16>, <66, 63, 14>,
			<36, 70, 87>, <36, 87, 89>, <27, 65, 70>, <27, 70, 36>,
			<61, 65, 27>, <57, 61, 27>, <136, 111, 112>, <136, 101, 111>,
			<119, 94, 101>, <119, 101, 136>, <87, 94, 119>, <87, 119, 89>,
			<91, 124, 143>, <91, 143, 9>, <91, 9, 53>, <9, 49, 53>,
			<0, 48, 49>, <0, 49, 9>, <36, 89, 48>, <36, 48, 0>,
			<120, 119, 136>, <120, 136, 143>, <120, 143, 124>, <96, 99, 103>,
			<62, 67, 58>, <72, 74, 77>, <83, 81, 80>, <142, 143, 141>,
			<142, 141, 140>, <141, 143, 136>, <141, 136, 138>, <136, 135, 138>,
			<135, 136, 133>, <135, 133, 131>, <135, 131, 129>, <135, 129, 127>,
			<135, 127, 128>, <135, 128, 130>, <135, 130, 132>, <135, 132, 134>,
			<135, 134, 137>, <135, 137, 138>, <7, 6, 140>, <7, 140, 141>,
			<6, 8, 142>, <6, 142, 140>, <139, 2, 7>, <139, 7, 141>,
			<138, 37, 39>, <138, 39, 139>, <35, 37, 138>, <35, 138, 137>,
			<24, 35, 137>, <24, 137, 134>, <132, 15, 24>, <132, 24, 134>,
			<13, 15, 132>, <13, 132, 130>
		}
		normal_indices {
			246,
			<23, 23, 23>, <23, 23, 23>, <23, 23, 23>, <23, 23, 23>,
			<23, 23, 23>, <23, 23, 23>, <22, 22, 22>, <22, 22, 22>,
			<19, 19, 19>, <19, 19, 19>, <0, 0, 0>, <0, 0, 0>,
			<65, 65, 65>, <65, 65, 65>, <65, 65, 65>, <65, 65, 65>,
			<65, 65, 65>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<22, 22, 22>, <22, 22, 22>, <19, 19, 19>, <19, 19, 19>,
			<19, 19, 19>, <19, 19, 19>, <19, 19, 19>, <19, 19, 19>,
			<19, 19, 19>, <19, 19, 19>, <19, 19, 19>, <19, 19, 19>,
			<65, 65, 65>, <65, 65, 65>, <65, 65, 65>, <65, 65, 65>,
			<65, 65, 65>, <65, 65, 65>, <65, 65, 65>, <65, 65, 65>,
			<38, 41, 41>, <38, 41, 38>, <41, 42, 42>, <41, 42, 41>,
			<42, 40, 40>, <42, 40, 42>, <40, 36, 36>, <40, 36, 40>,
			<36, 33, 33>, <36, 33, 36>, <65, 65, 65>, <65, 65, 65>,
			<65, 65, 65>, <65, 65, 65>, <65, 65, 65>, <65, 65, 65>,
			<65, 65, 65>, <65, 65, 65>, <65, 65, 65>, <65, 65, 65>,
			<65, 65, 65>, <65, 65, 65>, <65, 65, 65>, <65, 65, 65>,
			<65, 65, 65>, <65, 65, 65>, <65, 65, 65>, <65, 65, 65>,
			<65, 65, 65>, <65, 65, 65>, <65, 65, 65>, <65, 65, 65>,
			<65, 65, 65>, <65, 65, 65>, <65, 65, 65>, <65, 65, 65>,
			<65, 65, 65>, <65, 65, 65>, <65, 65, 65>, <65, 65, 65>,
			<65, 65, 65>, <65, 65, 65>, <65, 65, 65>, <19, 19, 19>,
			<19, 19, 19>, <27, 28, 44>, <27, 44, 27>, <28, 47, 44>,
			<44, 47, 48>, <45, 44, 48>, <45, 48, 46>, <65, 65, 65>,
			<65, 65, 65>, <65, 65, 65>, <65, 65, 65>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<22, 22, 22>, <22, 22, 22>, <22, 22, 22>, <22, 22, 22>,
			<22, 22, 22>, <22, 22, 22>, <22, 22, 22>, <22, 22, 22>,
			<22, 22, 22>, <22, 22, 22>, <22, 22, 22>, <22, 22, 22>,
			<22, 22, 22>, <22, 22, 22>, <50, 18, 49>, <50, 49, 52>,
			<57, 50, 52>, <57, 52, 55>, <57, 55, 58>, <57, 58, 59>,
			<59, 62, 60>, <59, 60, 57>, <64, 60, 62>, <65, 64, 62>,
			<65, 62, 65>, <63, 65, 65>, <63, 65, 61>, <61, 63, 61>,
			<56, 61, 61>, <56, 61, 56>, <53, 56, 56>, <53, 56, 53>,
			<15, 14, 15>, <15, 43, 43>, <15, 43, 15>, <43, 51, 51>,
			<43, 51, 43>, <54, 51, 51>, <13, 13, 10>, <13, 10, 10>,
			<8, 10, 10>, <8, 10, 8>, <6, 8, 8>, <6, 8, 0>,
			<0, 6, 0>, <0, 0, 9>, <0, 9, 7>, <9, 7, 9>,
			<9, 9, 11>, <9, 11, 12>, <12, 11, 16>, <12, 16, 15>,
			<15, 16, 18>, <16, 17, 49>, <16, 49, 18>, <37, 39, 39>,
			<39, 37, 37>, <39, 37, 37>, <39, 37, 37>, <39, 37, 37>,
			<34, 34, 37>, <34, 37, 39>, <37, 34, 34>, <37, 34, 39>,
			<39, 42, 42>, <39, 42, 39>, <42, 40, 40>, <42, 40, 42>,
			<40, 35, 35>, <40, 35, 40>, <25, 26, 29>, <25, 29, 30>,
			<30, 30, 29>, <32, 30, 30>, <30, 32, 32>, <30, 32, 34>,
			<34, 34, 32>, <30, 29, 26>, <30, 26, 26>, <30, 29, 30>,
			<32, 30, 30>, <34, 32, 32>, <34, 32, 30>, <34, 32, 34>,
			<22, 22, 22>, <22, 22, 22>, <26, 22, 22>, <26, 22, 22>,
			<22, 22, 26>, <26, 22, 26>, <25, 22, 26>, <25, 22, 22>,
			<22, 22, 22>, <22, 22, 25>, <22, 22, 22>, <22, 22, 22>,
			<22, 22, 22>, <22, 22, 22>, <22, 22, 22>, <22, 22, 22>,
			<22, 22, 22>, <22, 22, 22>, <22, 22, 22>, <22, 22, 22>,
			<22, 22, 25>, <22, 25, 22>, <22, 22, 22>, <22, 22, 22>,
			<22, 22, 22>, <0, 0, 0>, <0, 0, 0>, <3, 3, 3>,
			<3, 3, 3>, <3, 3, 3>, <3, 3, 5>, <3, 3, 5>,
			<3, 3, 2>, <3, 2, 4>, <3, 4, 3>, <3, 3, 3>,
			<3, 3, 3>, <3, 3, 3>, <3, 3, 1>, <3, 1, 1>,
			<3, 1, 5>, <3, 5, 5>, <42, 42, 42>, <42, 42, 42>,
			<23, 23, 23>, <23, 23, 23>, <23, 23, 23>, <23, 23, 23>,
			<23, 23, 23>, <23, 23, 23>, <21, 20, 20>, <21, 20, 21>,
			<24, 21, 21>, <24, 21, 24>, <31, 31, 24>, <31, 24, 24>,
			<35, 31, 31>, <35, 31, 35>
		}
	}
}
#end

#declare LDX_3816_dot_dat =
#if (LDXQual = 0)
box {
	<-19.5,-9,-11>,<-1.5,28,9>
}
#else
union {
// Minifig Leg Right
// Name: 3816.dat
// Author: Steve Bliss [sbliss]
// !LDRAW_ORG Part UPDATE 2009-03
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CCW
// !HELP Move down 12 units to align with hips
// !HISTORY 1997-10-29 [PTadmin] Official Update 1997-16
// !HISTORY 1999-02-01 [PTadmin] Official Update 1999-01
// !HISTORY 2000-05-07 [PTadmin] Official Update 2000-01
// !HISTORY 2002-04-10 [fwcain] Fixed overlapping quad...
// !HISTORY 2002-04-25 [PTadmin] Official Update 2002-02
// !HISTORY 2002-05-29 [fwcain] Moved all front surfaces to "main" file (from subfile)...
// !HISTORY 2002-08-18 [PTadmin] Official Update 2002-04
// !HISTORY 2007-07-27 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
// !HISTORY 2008-12-31 [tchang] Add BFC
// !HISTORY 2009-08-24 [PTadmin] Moved from 971
// !HISTORY 2009-12-29 [PTadmin] Official Update 2009-03
	object {
		LDX_s_slash_3816s01_dot_dat_in_part
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
	}
	mesh2 {
		vertex_vectors {
			144,
			<-19.5,28,-11>, <-19.5,28,9>, <-19.18,20,-11>, <-19.18,20,-6>,
			<-18.68,7.7,-6>, <-18.639999,6.74,-6>, <-18.5,3.42,-8.28>, <-18.360001,0,-9>,
			<-18.360001,0,0>, <-18.360001,0,9>, <-18.23,-3.42,-8.28>, <-18.23,-3.42,8.28>,
			<-18.110001,-6.3,-6.3>, <-18.110001,-6.3,6.3>, <-18.030001,-8.28,-3.42>, <-18.030001,-8.28,3.42>,
			<-18,-9,0>, <-16,-2,5>, <-16,-2,8.5789>, <-16,8,-3>,
			<-16,8,5>, <-16,12,5>, <-16,12,9>, <-16,18,9>,
			<-16,24,-7>, <-16,24,-3>, <-16,24,5>, <-16,24,9>,
			<-16,28,-7>, <-16,28,5>, <-15.7176,-3.42,8.28>, <-15.6023,0,9>,
			<-15.5434,-4.2962,5>, <-15.5434,-4.2962,7.6776>, <-15.5434,0.2962,5>, <-15.5434,0.2962,9>,
			<-14.34,-6,0>, <-14.34,-6,5>, <-14.34,0,-6>, <-14.34,0,0>,
			<-14.34,2.1,-5.58>, <-14.34,2.1,5>, <-14.2426,-6.2426,5>, <-14.2426,-6.2426,6.3395>,
			<-14.2426,2.2426,9>, <-14.24,2.24,-5.55>, <-14.1567,-6.3,6.3>, <-12.8194,-7.1937,5>,
			<-12.3,3.54,-4.71>, <-12.2962,-7.5434,4.4914>, <-12.2962,-7.5434,5>, <-12.2962,3.5434,9>,
			<-10,-8,3.8273>, <-10,-8,5>, <-10,4,-4.4>, <-10,4,9>,
			<-10,12,5>, <-10,12,9>, <-10,24,5>, <-10,24,9>,
			<-7.72,-6,0>, <-7.72,-6,5>, <-7.72,-3,0>, <-7.72,-3,3>,
			<-7.72,0,-6>, <-7.72,0,-3>, <-7.72,0,3>, <-7.72,2.3,-5.54>,
			<-7.72,3,-3>, <-7.72,3,0>, <-7.72,3,3>, <-7.72,3.55,-4.71>,
			<-7.72,3.55,5>, <-7.7038,-7.5434,4.4914>, <-7.7038,-7.5434,5>, <-7.7038,3.5434,9>,
			<-7.1806,-7.1937,5>, <-5.8433,-6.3,6.3>, <-5.7574,-6.2426,5>, <-5.7574,-6.2426,6.3395>,
			<-5.7574,2.2426,5>, <-5.7574,2.2426,9>, <-4.4566,-4.2962,5>, <-4.4566,-4.2962,7.6776>,
			<-4.4566,0.2962,5>, <-4.4566,0.2962,9>, <-4.3977,0,9>, <-4.2824,-3.42,8.28>,
			<-4,-2,5>, <-4,-2,8.5789>, <-4,8,-3>, <-4,8,5>,
			<-4,12,5>, <-4,12,9>, <-4,18,9>, <-4,24,-7>,
			<-4,24,-3>, <-4,24,5>, <-4,24,9>, <-4,28,-7>,
			<-4,28,5>, <-2,-9,0>, <-2,-8.28,-3.42>, <-2,-8.28,3.42>,
			<-2,-6.3,-6.3>, <-2,-6.3,6.3>, <-2,-3.42,-8.28>, <-2,-3.42,8.28>,
			<-2,-3,0>, <-2,-2.7717,-1.1481>, <-2,-2.7717,1.1481>, <-2,-2.1213,-2.1213>,
			<-2,-2.1213,2.1213>, <-2,-1.1481,-2.7717>, <-2,-1.1481,2.7717>, <-2,0,-9>,
			<-2,0,-3>, <-2,0,3>, <-2,0,9>, <-2,1.1481,-2.7717>,
			<-2,1.1481,2.7717>, <-2,2.1213,-2.1213>, <-2,2.1213,2.1213>, <-2,2.7717,-1.1481>,
			<-2,2.7717,1.1481>, <-2,3,0>, <-2,3.42,-8.28>, <-2,4.1,9>,
			<-2,6.74,-6>, <-2,7,7>, <-2,7.7,-6>, <-2,9.2,-3.8>,
			<-2,9.2,3.8>, <-2,10,0>, <-1.5,4.1,9>, <-1.5,7,7>,
			<-1.5,7.7,-6>, <-1.5,9.2,-3.8>, <-1.5,9.2,3.8>, <-1.5,10,0>,
			<-1.5,20,-11>, <-1.5,20,-6>, <-1.5,28,-11>, <-1.5,28,9>
		}
		normal_vectors {
			65,
			<-1,0,0>, <-0.999155,-0.041099,0.000184>, <-0.999201,-0.039968,0>, <-0.999184,-0.040384,0.000734>,
			<-0.999223,-0.039404,-0.000587>, <-0.999223,-0.039404,0.000587>, <-0.980797,-0.195031,0>, <-0.980804,0.194997,0>,
			<-0.923873,-0.382698,0>, <-0.92388,0.382681,0>, <-0.70658,-0.707633,0>, <-0.7071,0.707114,-0.000002>,
			<-0.658423,-0.752648,0.000298>, <-0.55569,-0.83139,0>, <-0.55563,0.83143,-0.000003>, <-0.382722,-0.923863,0>,
			<-0.382024,-0.924152,0.000013>, <-0.193633,-0.981074,0>, <-0.06566,-0.997842,-0.000281>, <0,-1,0>,
			<0,-1,0>, <0,-0.919905,0.392141>, <0,-0.919145,-0.393919>, <0,-0.919151,0.393905>,
			<0,-0.826227,0.563337>, <0,-0.82406,0.566503>, <0,-0.707623,-0.70659>, <0,-0.707107,-0.707107>,
			<0,-0.707271,0.706942>, <0,-0.567733,-0.823213>, <0,-0.566537,0.824036>, <0,-0.566107,0.824332>,
			<0.00001,-0.393923,0.919143>, <0,-0.206033,0.978545>, <0.000216,-0.202974,0.979184>, <0,-0.196116,0.980581>,
			<0,-0.103573,0.994622>, <0,0,-1>, <0,0,1>, <0,0,1>,
			<0,0.393919,0.919145>, <0,0.707107,0.707107>, <0,1,0>, <0.001229,-0.563073,0.826406>,
			<0.001219,-0.558127,0.829755>, <0.001371,-0.383264,0.923638>, <0.002061,-0.554313,0.832306>, <0.002124,-0.384694,0.923042>,
			<0.066967,-0.997755,0.000064>, <0.321057,-0.94706,0.000082>, <0.382722,-0.923863,0>, <0.443669,-0.896191,0.000166>,
			<0.55569,-0.83139,0>, <0.555593,0.831454,0>, <0.696419,-0.717635,0.000253>, <0.707084,0.707129,0>,
			<0.729136,-0.684369,0.000023>, <0.81978,-0.572678,0.000125>, <0.829693,-0.558221,-0.000145>, <0.896639,-0.442763,-0.000148>,
			<0.924027,-0.382327,0>, <0.923874,0.382698,-0.000005>, <0.980797,-0.195033,0>, <0.980793,0.195053,0>,
			<1,0,0>
		}
		face_indices {
			246,
			<100, 29, 26>, <100, 26, 58>, <100, 58, 97>, <56, 21, 20>,
			<56, 20, 91>, <92, 56, 91>, <25, 96, 90>, <25, 90, 19>,
			<90, 91, 20>, <90, 20, 19>, <96, 97, 91>, <96, 91, 90>,
			<19, 20, 26>, <19, 26, 25>, <25, 26, 29>, <25, 29, 28>,
			<28, 24, 25>, <99, 100, 97>, <99, 97, 96>, <96, 95, 99>,
			<24, 28, 99>, <24, 99, 95>, <24, 95, 96>, <24, 96, 25>,
			<28, 29, 1>, <28, 1, 0>, <29, 100, 143>, <29, 143, 1>,
			<100, 99, 142>, <100, 142, 143>, <99, 28, 0>, <99, 0, 142>,
			<140, 141, 143>, <140, 143, 142>, <136, 137, 141>, <137, 139, 143>,
			<137, 143, 141>, <139, 138, 143>, <138, 135, 143>, <135, 134, 143>,
			<130, 131, 137>, <130, 137, 136>, <131, 133, 139>, <131, 139, 137>,
			<133, 132, 138>, <133, 138, 139>, <132, 129, 135>, <132, 135, 138>,
			<129, 127, 134>, <129, 134, 135>, <118, 127, 122>, <118, 122, 120>,
			<107, 118, 120>, <107, 120, 117>, <105, 107, 117>, <105, 117, 114>,
			<103, 105, 114>, <103, 114, 112>, <101, 103, 112>, <101, 112, 110>,
			<102, 101, 110>, <102, 110, 108>, <104, 102, 108>, <104, 108, 109>,
			<106, 104, 109>, <106, 109, 111>, <115, 106, 111>, <115, 111, 113>,
			<126, 115, 113>, <126, 113, 116>, <128, 126, 116>, <128, 116, 119>,
			<130, 128, 119>, <130, 119, 121>, <131, 130, 121>, <131, 121, 123>,
			<133, 131, 123>, <133, 123, 125>, <132, 133, 125>, <132, 125, 124>,
			<129, 132, 124>, <129, 124, 122>, <129, 122, 127>, <36, 60, 61>,
			<36, 61, 37>, <38, 40, 67>, <38, 67, 64>, <40, 45, 67>,
			<67, 45, 48>, <71, 67, 48>, <71, 48, 54>, <39, 36, 37>,
			<39, 37, 41>, <39, 41, 40>, <39, 40, 38>, <60, 62, 63>,
			<60, 63, 61>, <70, 72, 61>, <70, 61, 66>, <68, 71, 72>,
			<68, 72, 69>, <64, 67, 68>, <64, 68, 65>, <71, 68, 67>,
			<34, 41, 37>, <34, 37, 17>, <32, 17, 37>, <32, 37, 42>,
			<50, 47, 37>, <50, 37, 53>, <53, 37, 61>, <53, 61, 74>,
			<76, 74, 61>, <76, 61, 82>, <88, 82, 61>, <88, 61, 84>,
			<80, 84, 61>, <80, 61, 72>, <51, 55, 54>, <51, 54, 48>,
			<44, 51, 48>, <44, 48, 45>, <44, 45, 40>, <44, 40, 41>,
			<41, 34, 35>, <41, 35, 44>, <31, 35, 34>, <18, 31, 34>,
			<18, 34, 17>, <30, 18, 17>, <30, 17, 32>, <33, 30, 32>,
			<43, 33, 32>, <43, 32, 42>, <46, 43, 42>, <46, 42, 47>,
			<49, 47, 50>, <50, 53, 52>, <50, 52, 49>, <53, 74, 73>,
			<53, 73, 52>, <76, 73, 74>, <77, 76, 78>, <77, 78, 79>,
			<83, 79, 78>, <83, 78, 82>, <87, 83, 82>, <87, 82, 88>,
			<89, 87, 88>, <89, 88, 84>, <89, 84, 86>, <85, 86, 84>,
			<85, 84, 80>, <85, 80, 81>, <81, 80, 72>, <81, 72, 75>,
			<75, 72, 55>, <72, 71, 54>, <72, 54, 55>, <52, 103, 15>,
			<15, 49, 52>, <103, 52, 73>, <103, 73, 76>, <15, 47, 49>,
			<13, 46, 47>, <13, 47, 15>, <76, 77, 105>, <76, 105, 103>,
			<103, 101, 16>, <103, 16, 15>, <101, 102, 14>, <101, 14, 16>,
			<102, 104, 12>, <102, 12, 14>, <9, 31, 18>, <9, 18, 11>,
			<30, 11, 18>, <33, 11, 30>, <11, 33, 43>, <11, 43, 13>,
			<46, 13, 43>, <107, 89, 86>, <107, 86, 118>, <87, 89, 107>,
			<83, 87, 107>, <105, 79, 83>, <105, 83, 107>, <77, 79, 105>,
			<127, 75, 55>, <127, 55, 57>, <118, 81, 75>, <118, 75, 127>,
			<85, 81, 118>, <86, 85, 118>, <9, 35, 31>, <9, 44, 35>,
			<22, 51, 44>, <22, 44, 9>, <55, 51, 22>, <55, 22, 57>,
			<59, 27, 1>, <59, 1, 143>, <59, 143, 98>, <143, 94, 98>,
			<134, 93, 94>, <134, 94, 143>, <127, 57, 93>, <127, 93, 134>,
			<23, 22, 9>, <23, 9, 1>, <23, 1, 27>, <47, 42, 37>,
			<78, 76, 82>, <61, 63, 66>, <72, 70, 69>, <0, 1, 3>,
			<0, 3, 2>, <3, 1, 9>, <3, 9, 5>, <9, 8, 5>,
			<8, 9, 11>, <8, 11, 13>, <8, 13, 15>, <8, 15, 16>,
			<8, 16, 14>, <8, 14, 12>, <8, 12, 10>, <8, 10, 7>,
			<8, 7, 6>, <8, 6, 5>, <3, 2, 140>, <3, 140, 141>,
			<2, 0, 142>, <2, 142, 140>, <3, 141, 136>, <3, 136, 4>,
			<4, 130, 128>, <4, 128, 5>, <6, 5, 128>, <6, 128, 126>,
			<7, 6, 126>, <7, 126, 115>, <7, 115, 106>, <7, 106, 10>,
			<12, 10, 106>, <12, 106, 104>
		}
		normal_indices {
			246,
			<37, 37, 37>, <37, 37, 37>, <37, 37, 37>, <37, 37, 37>,
			<37, 37, 37>, <37, 37, 37>, <38, 38, 38>, <38, 38, 38>,
			<42, 42, 42>, <42, 42, 42>, <0, 0, 0>, <0, 0, 0>,
			<64, 64, 64>, <64, 64, 64>, <64, 64, 64>, <64, 64, 64>,
			<64, 64, 64>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<38, 38, 38>, <38, 38, 38>, <42, 42, 42>, <42, 42, 42>,
			<42, 42, 42>, <42, 42, 42>, <42, 42, 42>, <42, 42, 42>,
			<42, 42, 42>, <42, 42, 42>, <42, 42, 42>, <42, 42, 42>,
			<64, 64, 64>, <64, 64, 64>, <64, 64, 64>, <64, 64, 64>,
			<64, 64, 64>, <64, 64, 64>, <64, 64, 64>, <64, 64, 64>,
			<24, 21, 21>, <24, 21, 24>, <21, 19, 19>, <21, 19, 21>,
			<19, 22, 22>, <19, 22, 19>, <22, 26, 26>, <22, 26, 22>,
			<26, 29, 29>, <26, 29, 26>, <64, 64, 64>, <64, 64, 64>,
			<64, 64, 64>, <64, 64, 64>, <64, 64, 64>, <64, 64, 64>,
			<64, 64, 64>, <64, 64, 64>, <64, 64, 64>, <64, 64, 64>,
			<64, 64, 64>, <64, 64, 64>, <64, 64, 64>, <64, 64, 64>,
			<64, 64, 64>, <64, 64, 64>, <64, 64, 64>, <64, 64, 64>,
			<64, 64, 64>, <64, 64, 64>, <64, 64, 64>, <64, 64, 64>,
			<64, 64, 64>, <64, 64, 64>, <64, 64, 64>, <64, 64, 64>,
			<64, 64, 64>, <64, 64, 64>, <64, 64, 64>, <64, 64, 64>,
			<64, 64, 64>, <64, 64, 64>, <64, 64, 64>, <42, 42, 42>,
			<42, 42, 42>, <35, 34, 45>, <35, 45, 35>, <34, 47, 45>,
			<45, 47, 46>, <44, 45, 46>, <44, 46, 43>, <64, 64, 64>,
			<64, 64, 64>, <64, 64, 64>, <64, 64, 64>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<38, 38, 38>, <38, 38, 38>, <38, 38, 38>, <38, 38, 38>,
			<38, 38, 38>, <38, 38, 38>, <38, 38, 38>, <38, 38, 38>,
			<38, 38, 38>, <38, 38, 38>, <38, 38, 38>, <38, 38, 38>,
			<38, 38, 38>, <38, 38, 38>, <49, 18, 48>, <49, 48, 51>,
			<56, 49, 51>, <56, 51, 54>, <56, 54, 57>, <56, 57, 58>,
			<58, 60, 59>, <58, 59, 56>, <62, 59, 60>, <64, 62, 60>,
			<64, 60, 64>, <63, 64, 64>, <63, 64, 61>, <61, 63, 61>,
			<55, 61, 61>, <55, 61, 55>, <53, 55, 55>, <53, 55, 53>,
			<15, 13, 15>, <15, 20, 20>, <15, 20, 15>, <20, 50, 50>,
			<20, 50, 20>, <52, 50, 50>, <14, 14, 11>, <14, 11, 11>,
			<9, 11, 11>, <9, 11, 9>, <7, 9, 9>, <7, 9, 0>,
			<0, 7, 0>, <0, 0, 8>, <0, 8, 6>, <8, 6, 8>,
			<8, 8, 10>, <8, 10, 12>, <12, 10, 16>, <12, 16, 15>,
			<15, 16, 18>, <16, 17, 48>, <16, 48, 18>, <25, 23, 23>,
			<23, 25, 25>, <23, 25, 25>, <23, 25, 25>, <23, 25, 25>,
			<28, 28, 25>, <28, 25, 23>, <25, 28, 28>, <25, 28, 23>,
			<23, 19, 19>, <23, 19, 23>, <19, 22, 22>, <19, 22, 19>,
			<22, 27, 27>, <22, 27, 22>, <36, 36, 33>, <36, 33, 32>,
			<32, 32, 33>, <30, 32, 32>, <32, 30, 30>, <32, 30, 28>,
			<28, 28, 30>, <32, 33, 36>, <32, 36, 36>, <32, 33, 32>,
			<30, 32, 32>, <28, 30, 30>, <28, 30, 32>, <28, 30, 28>,
			<38, 38, 38>, <38, 38, 38>, <36, 38, 38>, <36, 38, 38>,
			<38, 38, 36>, <36, 38, 36>, <36, 38, 36>, <36, 38, 38>,
			<38, 38, 38>, <38, 38, 36>, <38, 38, 38>, <38, 38, 38>,
			<38, 38, 38>, <38, 38, 38>, <38, 38, 38>, <38, 38, 38>,
			<38, 38, 38>, <38, 38, 38>, <38, 38, 38>, <38, 38, 38>,
			<38, 38, 36>, <38, 36, 38>, <38, 38, 38>, <38, 38, 38>,
			<38, 38, 38>, <0, 0, 0>, <0, 0, 0>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <2, 2, 1>, <2, 2, 1>,
			<2, 2, 4>, <2, 4, 2>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 3>, <2, 3, 5>, <2, 5, 4>,
			<2, 4, 1>, <2, 1, 1>, <42, 42, 42>, <42, 42, 42>,
			<38, 38, 38>, <38, 38, 38>, <38, 38, 38>, <38, 38, 38>,
			<38, 38, 38>, <38, 38, 38>, <32, 31, 31>, <32, 31, 32>,
			<39, 32, 32>, <39, 32, 39>, <39, 39, 40>, <39, 40, 40>,
			<41, 40, 40>, <41, 40, 41>
		}
	}
}
#end

#declare LDX_5_dash_16cyli_dot_dat_in_part = cylinder // Cylinder 0.3125
{
	<0,0,0>,<0,1,0>,1 open
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-0.92387953251128673848,0,-0.38268343236508967076>,0
		}
	}
}

#declare LDX_5_dash_16cyli_dot_dat = cylinder // Cylinder 0.3125
{
	<0,0,0>,<0,1,0>,1 open
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-0.92387953251128673848,0,-0.38268343236508967076>,0
		}
	}
}

#declare LDX_3_dash_4cyli_dot_dat_in_part = cylinder // Cylinder 0.75
{
	<0,0,0>,<0,1,0>,1 open
	clipped_by
	{
		union
		{
			plane
			{
				<0,0,-1>,0
			}
			plane
			{
				<1,0,0>,0
			}
		}
	}
}

#declare LDX_3_dash_4cyli_dot_dat = cylinder // Cylinder 0.75
{
	<0,0,0>,<0,1,0>,1 open
	clipped_by
	{
		union
		{
			plane
			{
				<0,0,-1>,0
			}
			plane
			{
				<1,0,0>,0
			}
		}
	}
}

#declare LDX_7_dash_16cyli_dot_dat_in_part = cylinder // Cylinder 0.4375
{
	<0,0,0>,<0,1,0>,1 open
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-0.38268343236509033689,0,-0.92387953251128651644>,0
		}
	}
}

#declare LDX_7_dash_16cyli_dot_dat = cylinder // Cylinder 0.4375
{
	<0,0,0>,<0,1,0>,1 open
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-0.38268343236509033689,0,-0.92387953251128651644>,0
		}
	}
}

#declare LDX_s_slash_3815s01_dot_dat_in_part = union {
// ~Minifig Hips without Decorated Surface
// Name: s\3815s01.dat
// Author: Steve Bliss [sbliss]
// !LDRAW_ORG Subpart UPDATE 2010-02
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CW
// !HISTORY 1998-12-11 [cwdee] created subpart
// !HISTORY 1999-02-01 [PTadmin] Official Update 1999-01
// !HISTORY 2002-06-10 [cwdee] updated studs with those developed by Mark Kennedy
// !HISTORY 2002-08-18 [PTadmin] Official Update 2002-04
// !HISTORY 2004-06-15 [nielsk] BFC'd
// !HISTORY 2004-11-06 [PTadmin] Official Update 2004-04
// !HISTORY 2007-09-13 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
// !HISTORY 2009-01-28 [Philo] Moved crotch to main for patterned parts
// !HISTORY 2009-01-28 [Philo] Various shape improvements
// !HISTORY 2009-08-24 [PTadmin] Renamed from s\970s01
// !HISTORY 2010-07-05 [PTadmin] Official Update 2010-02
// //
// //
// //
// BFC INVERTNEXT
	object {
		LDX_3_dash_4cyli_dot_dat_in_part
		matrix <2.8,0,-2.8,0,11,0,-2.8,0,-2.8,10,-11,0>
	}
// //
// //
// //
// BFC INVERTNEXT
	object {
		LDX_3_dash_4cyli_dot_dat_in_part
		matrix <-2.8,0,2.8,0,11,0,2.8,0,2.8,-10,-11,0>
	}
// //
	object {
		LDX_7_dash_16cyli_dot_dat_in_part
		matrix <0,8.3149,-3.4441,4,0,0,0,3.4441,8.3149,-2,12,0>
	}
// BFC INVERTNEXT
	object {
		LDX_1_dash_4cyli_dot_dat_in_part
		matrix <0,-6.364,6.364,36,0,0,0,-6.364,-6.364,-18,12,0>
	}
	object {
		LDX_4_dash_4disc_dot_dat_in_part
		matrix <0,9,0,1,0,0,0,0,-9,-2,12,0>
	}
	object {
		LDX_4_dash_4disc_dot_dat_in_part
		matrix <0,9,0,-1,0,0,0,0,9,2,12,0>
	}
	object {
		LDX_4_dash_4cylc_dot_dat_in_part
		matrix <0,3,0,19.84,0,0,0,0,3,-9.92,12,0>
	}
	object {
		LDX_4_dash_4disc_dot_dat_in_part
		matrix <0,3,0,-1,0,0,0,0,3,9.92,12,0>
	}
// //
// //
// //
// //
// //
// //
// //
}

#declare LDX_3815_dot_dat =
#if (LDXQual = 0)
box {
	<-18,-11,-10>,<18,21.000195,10>
}
#else
union {
// Minifig Hips
// Name: 3815.dat
// Author: Steve Bliss [sbliss]
// !LDRAW_ORG Part UPDATE 2010-02
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CW
// !HISTORY 1997-10-29 [PTadmin] Official Update 1997-16
// !HISTORY 1999-01-01 [cwdee] Modifications
// !HISTORY 1999-02-01 [PTadmin] Official Update 1999-01
// !HISTORY 2004-06-15 [nielsk] BFC'd
// !HISTORY 2004-11-06 [PTadmin] Official Update 2004-04
// !HISTORY 2007-07-27 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
// !HISTORY 2009-01-28 [Philo] Moved crotch to main part
// !HISTORY 2009-08-24 [PTadmin] Renamed from 970
// !HISTORY 2010-07-05 [PTadmin] Official Update 2010-02
	object {
		LDX_5_dash_16cyli_dot_dat_in_part
		matrix <0,-6.364,-6.364,4,0,0,0,6.364,-6.364,-2,12,0>
	}
	object {
		LDX_s_slash_3815s01_dot_dat_in_part
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
	}
// //
	mesh2 {
		vertex_vectors {
			106,
			<-18,0,-10>, <-18,0,10>, <-18,3,0>, <-18,3.685,-3.444>,
			<-18,3.685,3.444>, <-18,5.636,-6.364>, <-18,5.636,6.364>, <-18,6,-10>,
			<-18,6,-6.607>, <-18,6,6.607>, <-18,6,10>, <-16,-4,-3.46>,
			<-16,-4,3.46>, <-16,0,-3.46>, <-16,0,3.46>, <-14.48,-11,-4.48>,
			<-14.48,-11,4.48>, <-14.48,0,-4.48>, <-14.48,0,4.48>, <-13.46,-11,-6>,
			<-13.46,-11,6>, <-13.46,0,-6>, <-13.46,0,6>, <-12.8,-11,-2.8>,
			<-12.8,-11,2.8>, <-12.8,0,-2.8>, <-12.8,0,2.8>, <-11.52,-11,-3.68>,
			<-11.52,-11,3.68>, <-10,-11,-6>, <-10,-11,-4>, <-10,-11,4>,
			<-10,-11,6>, <-8.48,-11,-3.68>, <-8.48,-11,3.68>, <-7.2,-11,-2.8>,
			<-7.2,-11,2.8>, <-6.54,-11,-6>, <-6.54,-11,6>, <-6.54,0,-6>,
			<-6.54,0,6>, <-6.32,-11,-1.52>, <-6.32,-11,1.52>, <-6,-11,0>,
			<-5.52,-11,-4.48>, <-5.52,-11,4.48>, <-5.52,0,-4.48>, <-5.52,0,4.48>,
			<-4,-11,-3.46>, <-4,-11,0>, <-4,-11,3.46>, <-4,0,-3.46>,
			<-4,0,3.46>, <4,-11,-3.46>, <4,-11,0>, <4,-11,3.46>,
			<4,0,-3.46>, <4,0,3.46>, <5.52,-11,-4.48>, <5.52,-11,4.48>,
			<5.52,0,-4.48>, <5.52,0,4.48>, <6,-11,0>, <6.32,-11,-1.52>,
			<6.32,-11,1.52>, <6.54,-11,-6>, <6.54,-11,6>, <6.54,0,-6>,
			<6.54,0,6>, <7.2,-11,-2.8>, <7.2,-11,2.8>, <8.48,-11,-3.68>,
			<8.48,-11,3.68>, <10,-11,-6>, <10,-11,-4>, <10,-11,4>,
			<10,-11,6>, <11.52,-11,-3.68>, <11.52,-11,3.68>, <12.8,-11,-2.8>,
			<12.8,-11,2.8>, <12.8,0,-2.8>, <12.8,0,2.8>, <13.46,-11,-6>,
			<13.46,-11,6>, <13.46,0,-6>, <13.46,0,6>, <14.48,-11,-4.48>,
			<14.48,-11,4.48>, <14.48,0,-4.48>, <14.48,0,4.48>, <16,-4,-3.46>,
			<16,-4,3.46>, <16,0,-3.46>, <16,0,3.46>, <18,0,-10>,
			<18,0,10>, <18,3,0>, <18,3.685,-3.444>, <18,3.685,3.444>,
			<18,5.636,-6.364>, <18,5.636,6.364>, <18,6,-10>, <18,6,-6.607>,
			<18,6,6.607>, <18,6,10>
		}
		normal_vectors {
			22,
			<-1,0,0>, <-0.977227,-0.212198,0>, <-0.830366,0,-0.557219>, <-0.830366,0,0.557219>,
			<-0.707107,0,-0.707107>, <-0.707107,0,0.707107>, <-0.557219,0,-0.830366>, <-0.557219,0,0.830366>,
			<0,-1,0>, <0,0,-1>, <0,0,1>, <0,0.555228,-0.831699>,
			<0,0.555228,0.831699>, <0,1,0>, <0.557219,0,-0.830366>, <0.557219,0,0.830366>,
			<0.707107,0,-0.707107>, <0.707107,0,0.707107>, <0.830366,0,-0.557219>, <0.830366,0,0.557219>,
			<0.977227,-0.212198,0>, <1,0,0>
		}
		face_indices {
			140,
			<95, 102, 7>, <95, 7, 0>, <1, 10, 105>, <1, 105, 96>,
			<1, 0, 95>, <1, 95, 96>, <68, 66, 84>, <68, 84, 86>,
			<56, 53, 55>, <56, 55, 57>, <65, 67, 85>, <65, 85, 83>,
			<94, 92, 91>, <94, 91, 93>, <81, 79, 80>, <81, 80, 82>,
			<89, 85, 83>, <89, 83, 87>, <67, 60, 58>, <67, 58, 65>,
			<60, 56, 53>, <60, 53, 58>, <57, 61, 59>, <57, 59, 55>,
			<61, 68, 66>, <61, 66, 59>, <86, 90, 88>, <86, 88, 84>,
			<90, 94, 92>, <90, 92, 88>, <88, 92, 91>, <88, 91, 87>,
			<93, 89, 87>, <93, 87, 91>, <87, 79, 80>, <87, 80, 88>,
			<80, 78, 84>, <80, 84, 88>, <78, 75, 76>, <78, 76, 84>,
			<75, 72, 66>, <75, 66, 76>, <72, 70, 59>, <72, 59, 66>,
			<70, 64, 55>, <70, 55, 59>, <64, 62, 54>, <64, 54, 55>,
			<62, 63, 53>, <62, 53, 54>, <63, 69, 58>, <63, 58, 53>,
			<69, 71, 65>, <69, 65, 58>, <71, 74, 73>, <71, 73, 65>,
			<74, 77, 83>, <74, 83, 73>, <77, 79, 87>, <77, 87, 83>,
			<22, 20, 38>, <22, 38, 40>, <52, 50, 48>, <52, 48, 51>,
			<19, 21, 39>, <19, 39, 37>, <13, 11, 12>, <13, 12, 14>,
			<26, 24, 23>, <26, 23, 25>, <19, 21, 17>, <19, 17, 15>,
			<44, 46, 39>, <44, 39, 37>, <48, 51, 46>, <48, 46, 44>,
			<45, 47, 52>, <45, 52, 50>, <38, 40, 47>, <38, 47, 45>,
			<16, 18, 22>, <16, 22, 20>, <12, 14, 18>, <12, 18, 16>,
			<11, 12, 16>, <11, 16, 15>, <15, 17, 13>, <15, 13, 11>,
			<24, 23, 15>, <24, 15, 16>, <20, 28, 24>, <20, 24, 16>,
			<32, 31, 28>, <32, 28, 20>, <38, 34, 31>, <38, 31, 32>,
			<45, 36, 34>, <45, 34, 38>, <50, 42, 36>, <50, 36, 45>,
			<49, 43, 42>, <49, 42, 50>, <48, 41, 43>, <48, 43, 49>,
			<44, 35, 41>, <44, 41, 48>, <37, 33, 35>, <37, 35, 44>,
			<29, 30, 33>, <29, 33, 37>, <19, 27, 30>, <19, 30, 29>,
			<15, 23, 27>, <15, 27, 19>, <103, 8, 7>, <103, 7, 102>,
			<100, 5, 8>, <100, 8, 103>, <9, 104, 105>, <9, 105, 10>,
			<6, 101, 104>, <6, 104, 9>, <103, 102, 100>, <98, 100, 102>,
			<98, 102, 95>, <98, 95, 97>, <99, 97, 95>, <99, 95, 96>,
			<101, 99, 96>, <101, 96, 105>, <101, 105, 104>, <9, 10, 6>,
			<4, 6, 10>, <4, 10, 1>, <4, 1, 2>, <3, 2, 1>,
			<3, 1, 0>, <5, 3, 0>, <5, 0, 7>, <5, 7, 8>
		}
		normal_indices {
			140,
			<9, 9, 9>, <9, 9, 9>, <10, 10, 10>, <10, 10, 10>,
			<13, 13, 13>, <13, 13, 13>, <9, 9, 9>, <9, 9, 9>,
			<21, 21, 21>, <21, 21, 21>, <10, 10, 10>, <10, 10, 10>,
			<0, 0, 0>, <0, 0, 0>, <21, 21, 21>, <21, 21, 21>,
			<16, 18, 18>, <16, 18, 16>, <2, 4, 4>, <2, 4, 2>,
			<4, 6, 6>, <4, 6, 4>, <7, 5, 5>, <7, 5, 7>,
			<5, 3, 3>, <5, 3, 5>, <19, 17, 17>, <19, 17, 19>,
			<17, 15, 15>, <17, 15, 17>, <20, 20, 20>, <20, 20, 20>,
			<14, 16, 16>, <14, 16, 14>, <8, 8, 8>, <8, 8, 8>,
			<8, 8, 8>, <8, 8, 8>, <8, 8, 8>, <8, 8, 8>,
			<8, 8, 8>, <8, 8, 8>, <8, 8, 8>, <8, 8, 8>,
			<8, 8, 8>, <8, 8, 8>, <8, 8, 8>, <8, 8, 8>,
			<8, 8, 8>, <8, 8, 8>, <8, 8, 8>, <8, 8, 8>,
			<8, 8, 8>, <8, 8, 8>, <8, 8, 8>, <8, 8, 8>,
			<8, 8, 8>, <8, 8, 8>, <8, 8, 8>, <8, 8, 8>,
			<9, 9, 9>, <9, 9, 9>, <0, 0, 0>, <0, 0, 0>,
			<10, 10, 10>, <10, 10, 10>, <21, 21, 21>, <21, 21, 21>,
			<0, 0, 0>, <0, 0, 0>, <2, 2, 4>, <2, 4, 4>,
			<16, 16, 18>, <16, 18, 18>, <14, 14, 16>, <14, 16, 16>,
			<17, 17, 15>, <17, 15, 15>, <19, 19, 17>, <19, 17, 17>,
			<5, 5, 3>, <5, 3, 3>, <7, 7, 5>, <7, 5, 5>,
			<1, 1, 1>, <1, 1, 1>, <4, 4, 6>, <4, 6, 6>,
			<8, 8, 8>, <8, 8, 8>, <8, 8, 8>, <8, 8, 8>,
			<8, 8, 8>, <8, 8, 8>, <8, 8, 8>, <8, 8, 8>,
			<8, 8, 8>, <8, 8, 8>, <8, 8, 8>, <8, 8, 8>,
			<8, 8, 8>, <8, 8, 8>, <8, 8, 8>, <8, 8, 8>,
			<8, 8, 8>, <8, 8, 8>, <8, 8, 8>, <8, 8, 8>,
			<8, 8, 8>, <8, 8, 8>, <8, 8, 8>, <8, 8, 8>,
			<8, 8, 8>, <8, 8, 8>, <13, 13, 13>, <13, 13, 13>,
			<12, 12, 12>, <12, 12, 12>, <13, 13, 13>, <13, 13, 13>,
			<11, 11, 11>, <11, 11, 11>, <21, 21, 21>, <21, 21, 21>,
			<21, 21, 21>, <21, 21, 21>, <21, 21, 21>, <21, 21, 21>,
			<21, 21, 21>, <21, 21, 21>, <21, 21, 21>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>
		}
	}
}
#end

#include "lg_0973.inc" // Minifig Torso

#include "lg_3626bp01.inc" // Minifig Head with Standard Grin Pattern

#include "lg_4485.inc" // Minifig Cap

#declare LDX_2_dash_4disc_dot_dat_in_part = disc // Disc 0.5
{
	<0,0,0>,<0,1,0>,1
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
	}
}

#declare LDX_2_dash_4disc_dot_dat = disc // Disc 0.5
{
	<0,0,0>,<0,1,0>,1
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
	}
}

#declare LDX_2_dash_4cyls_dot_dat_in_part = cylinder // Sloped Cylinder 0.5
{
	<0,0,0>,<0,2,0>,1 open
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<1,1,0>,0.70710678118654757274
		}
	}
}

#declare LDX_2_dash_4cyls_dot_dat = cylinder // Sloped Cylinder 0.5
{
	<0,0,0>,<0,2,0>,1 open
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<1,1,0>,0.70710678118654757274
		}
	}
}

#declare LDX_3818_dot_dat =
#if (LDXQual = 0)
box {
	<-10,-6.5,-13.436>,<7,22.435999,6.507>
}
#else
union {
// Minifig Arm Right
// Name: 3818.dat
// Author: Chris Dee [cwdee]
// !LDRAW_ORG Part UPDATE 2010-03
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// !HELP Place at -15.552 9 0 relative to torso
// !HELP Then rotate about x axis to give required elevation of arm
// !HELP 0 = upper arm vertical
// !HELP -45 = lower arm horizontal
// !HELP -90 = upper arm horizontal
// !HELP -135 = lower arm vertical
// !HELP Then rotate 9.782 about z axis to align with slope of torso
// BFC CERTIFY CW
// !HISTORY 2002-11-30 [PTadmin] Official Update 2002-05
// !HISTORY 2007-07-29 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
// !HISTORY 2008-07-01 [tchang] Add BFC, some conditional lines
// !HISTORY 2009-05-28 [Eldar] Fix wrong color lines
// !HISTORY 2009-08-24 [PTadmin] Moved from 982
// !HISTORY 2009-12-29 [PTadmin] Official Update 2009-03
// !HISTORY 2010-08-27 [Philo] Increased hand hole to 15LDu; Fixed/added some condline.
// !HISTORY 2010-12-31 [PTadmin] Official Update 2010-03
// // peg
// BFC INVERTNEXT
	object {
		LDX_4_dash_4cyli_dot_dat_in_part
		matrix <0,2,0,7,0,0,0,0,2,0,0,0>
	}
	object {
		LDX_4_dash_4ring1_dot_dat_in_part
		matrix <0,2,0,-1,0,0,0,0,2,7,0,0>
	}
	object {
		LDX_4_dash_4cyli_dot_dat_in_part
		matrix <0,5,0,2,0,0,0,0,5,0,0,0>
	}
// //
// // flat inner arm
	object {
		LDX_2_dash_4disc_dot_dat_in_part
		matrix <0,0,6.5,-1,0,0,0,-6.5,0,0,0,0>
	}
	object {
		LDX_2_dash_4disc_dot_dat_in_part
		matrix <0,0,2,-1,0,0,0,2,0,0,0,0>
	}
// // hand hole
// BFC INVERTNEXT
	object {
		LDX_4_dash_4cylc_dot_dat_in_part
		matrix <2.5,0,0,0,10.6066,-10.6066,0,-1.76777,-1.76777,-5,8.294,0.707>
	}
	object {
		LDX_4_dash_4ring1_dot_dat_in_part
		matrix <2.5,0,0,0,-0.7071,0.7071,0,-1.7678,-1.7678,-5,18.9,-9.9>
	}
// // shoulder
	object {
		LDX_2_dash_4cyli_dot_dat_in_part
		matrix <0,0,-6.5,-3.333,8,0,-5,0,0,-1.666,0,0>
	}
// // upper arm extension (to elbow)
// // lower arm
	object {
		LDX_4_dash_4cyli_dot_dat_in_part
		matrix <5,0,0,0,-6.936,6.936,0,-3.536,-3.536,-5,18.9,-9.9>
	}
	object {
		LDX_2_dash_4cyls_dot_dat_in_part
		matrix <0,-3.5355,-3.5355,0,-2.964,2.964,-5,0,0,-5,11.964,-2.964>
	}
	object {
		LDX_1_dash_4cyli_dot_dat_in_part
		matrix <0,3.5355,3.5355,0,-5.928,5.928,5,0,0,-5,11.964,-2.964>
	}
	object {
		LDX_1_dash_4cyls_dot_dat_in_part
		matrix <0,3.5355,3.5355,0,-3.543,3.543,5,0,0,-5,6.036,2.964>
	}
	object {
		LDX_1_dash_4cyls_dot_dat_in_part
		matrix <0,-3.536,-3.536,0,-2.936,2.936,5,0,0,-5,11.964,-2.964>
	}
// // rear upper arm
// // rear shoulder line
// // crook of elbow
	mesh2 {
		vertex_vectors {
			155,
			<-10,9,0>, <-9.999,8,0>, <-9.6195,8.78129,-2.48736>, <-9.6195,9.21871,2.48736>,
			<-9.6185,8,-2.48755>, <-9.6185,8,2.48755>, <-8.5345,8,-4.59615>, <-8.5345,8,4.59615>,
			<-8.5355,8.59589,-4.5958>, <-8.5355,9.40411,4.5958>, <-6.9135,8.47199,-6.00489>, <-6.9135,9.52801,6.00489>,
			<-6.9125,8,-6.00535>, <-6.9125,8,6.00535>, <-6.666,0,0>, <-6.286,0,-2.488>,
			<-6.286,0,2.488>, <-5.202,0,-4.596>, <-5.202,0,4.596>, <-5,-4,0>,
			<-5,8,-6.5>, <-5,8,6.5>, <-5,8.428,-6.5>, <-5,8.4285,-6.4995>,
			<-5,9.5715,6.4995>, <-5,9.572,6.5>, <-4.999,8,-6.5>, <-4.999,8,6.5>,
			<-4.746,-3.695,-2.487>, <-4.746,-3.695,2.487>, <-4.024,-2.829,-4.596>, <-4.024,-2.829,4.596>,
			<-3.58,0,-6.005>, <-3.58,0,6.005>, <-3.087,8.474,-6.008>, <-3.087,9.034,6.5>,
			<-2.942,-1.53,-6.005>, <-2.942,-1.53,6.005>, <-2.5,-5.75,0>, <-2.31,-5.312,-2.487>,
			<-2.31,-5.312,2.487>, <-1.768,-4.066,-4.596>, <-1.768,-4.066,4.596>, <-1.666,0,-6.5>,
			<-1.666,0,6.5>, <-1.465,7.5,6.5>, <-1.465,8.604,-4.604>, <-0.957,-2.2,-6.005>,
			<-0.957,-2.2,6.005>, <-0.381,5.206,6.5>, <-0.381,8.798,-2.505>, <0,-6.5,0>,
			<0,-6.005,-2.488>, <0,-6.005,2.488>, <0,-4.596,-4.596>, <0,-4.596,4.596>,
			<0,-2.488,-6.005>, <0,-2.488,6.005>, <0,0,-6.5>, <0,0,-5>,
			<0,0,5>, <0,0,6.5>, <0,1.913,-4.619>, <0,1.913,4.619>,
			<0,2.487,-6.005>, <0,2.5,6.5>, <0,3.536,-3.536>, <0,3.536,3.536>,
			<0,4.5,4.5>, <0,4.596,-4.596>, <0,4.619,-1.913>, <0,4.619,1.913>,
			<0,5,0>, <0,6,3>, <0,9.028,-0.028>, <2,-5,0>,
			<2,-4.619,-1.913>, <2,-4.619,1.913>, <2,-3.536,-3.536>, <2,-3.536,3.536>,
			<2,-1.913,-4.619>, <2,-1.913,4.619>, <2,0,-5>, <2,0,5>,
			<2,1.913,-4.619>, <2,1.913,4.619>, <2,3.536,-3.536>, <2,3.536,3.536>,
			<2,4.619,-1.913>, <2,4.619,1.913>, <2,5,0>, <3.5,-5.5,0>,
			<3.5,-5.081,-2.105>, <3.5,-5.081,2.105>, <3.5,-3.889,-3.889>, <3.5,-3.889,3.889>,
			<3.5,-2.105,-5.081>, <3.5,-2.105,5.081>, <3.5,0,-5.5>, <3.5,0,5.5>,
			<3.5,2.105,-5.081>, <3.5,2.105,5.081>, <3.5,3.889,-3.889>, <3.5,3.889,3.889>,
			<3.5,5.081,-2.105>, <3.5,5.081,2.105>, <3.5,5.5,0>, <5,-5.5,0>,
			<5,-5.081,-2.105>, <5,-5.081,2.105>, <5,-3.889,-3.889>, <5,-3.889,3.889>,
			<5,-2.105,-5.081>, <5,-2.105,5.081>, <5,0,-5.5>, <5,0,5.5>,
			<5,2.105,-5.081>, <5,2.105,5.081>, <5,3.889,-3.889>, <5,3.889,3.889>,
			<5,5.081,-2.105>, <5,5.081,2.105>, <5,5.5,0>, <6,-5,0>,
			<6,-4.619,-1.913>, <6,-4.619,1.913>, <6,-3.536,-3.536>, <6,-3.536,3.536>,
			<6,-1.913,-4.619>, <6,-1.913,4.619>, <6,0,-5>, <6,0,5>,
			<6,1.913,-4.619>, <6,1.913,4.619>, <6,3.536,-3.536>, <6,3.536,3.536>,
			<6,4.619,-1.913>, <6,4.619,1.913>, <6,5,0>, <7,-4,0>,
			<7,-3.696,-1.531>, <7,-3.696,1.531>, <7,-2.828,-2.828>, <7,-2.828,2.828>,
			<7,-1.531,-3.696>, <7,-1.531,3.696>, <7,0,-4>, <7,0,4>,
			<7,1.531,-3.696>, <7,1.531,3.696>, <7,2.828,-2.828>, <7,2.828,2.828>,
			<7,3.696,-1.531>, <7,3.696,1.531>, <7,4,0>
		}
		normal_vectors {
			159,
			<-0.999999,-0.001122,0.000096>, <-0.998701,-0.000931,0.050954>, <-0.966617,-0.000821,0.256224>, <-0.95134,-0.001242,-0.308141>,
			<-0.951303,-0.000733,0.308257>, <-0.923079,-0.38461,-0.00001>, <-0.923132,-0.384484,0.000216>, <-0.883984,-0.368504,-0.28771>,
			<-0.884115,-0.368559,0.287236>, <-0.869505,-0.362338,0.335666>, <-0.869474,-0.362325,-0.33576>, <-0.786832,-0.000956,-0.617167>,
			<-0.78677,-0.000477,0.617246>, <-0.778893,-0.324478,-0.536692>, <-0.778822,-0.324448,0.536815>, <-0.710669,-0.29605,-0.638204>,
			<-0.710584,-0.296015,0.638315>, <-0.655851,-0.000653,-0.75489>, <-0.65581,-0.000279,0.754926>, <-0.632572,-0.263778,0.728199>,
			<-0.632226,-0.263634,-0.728552>, <-0.63243,-0.263532,-0.728411>, <-0.573462,-0.819232,0>, <-0.538751,-0.796748,-0.273751>,
			<-0.538751,-0.796748,0.273751>, <-0.476481,-0.879185,0>, <-0.406979,-0.68987,-0.598705>, <-0.406979,-0.68987,0.598706>,
			<-0.401486,-0.827116,-0.393304>, <-0.375607,-0.826404,0.419496>, <-0.316228,-0.948683,0.000052>, <-0.316403,-0.876506,0.362805>,
			<-0.315551,-0.850785,-0.420229>, <-0.315551,-0.420229,0.850785>, <-0.316403,-0.362805,-0.876506>, <-0.316228,-0.000052,-0.948683>,
			<-0.316228,0.000052,0.948683>, <-0.316403,0.362805,0.876506>, <-0.315551,0.420229,-0.850785>, <-0.315551,0.850785,0.420229>,
			<-0.316403,0.876506,-0.362805>, <-0.316228,0.948683,-0.000052>, <-0.315411,-0.713934,0.625151>, <-0.315411,-0.625151,-0.713934>,
			<-0.315411,0.625151,0.713934>, <-0.315411,0.713934,-0.625151>, <-0.287386,-0.957815,0.000002>, <-0.267133,-0.88991,-0.369731>,
			<-0.267113,-0.889843,0.369905>, <-0.265842,-0.652334,-0.70978>, <-0.250263,0.00048,-0.968178>, <-0.250262,0.000128,0.968178>,
			<-0.250247,0.000546,-0.968182>, <-0.24935,-0.636192,0.730126>, <-0.249029,-0.103844,-0.962913>, <-0.249029,-0.103844,0.962913>,
			<-0.247503,-0.555592,-0.793763>, <-0.207078,-0.690781,0.692777>, <-0.195738,-0.459477,0.866353>, <-0.193638,-0.645224,-0.739046>,
			<-0.192105,-0.891388,0.410515>, <-0.191984,-0.720528,-0.666319>, <-0.191984,-0.666319,0.720528>, <-0.192105,-0.410515,-0.891388>,
			<-0.192105,0.410515,0.891388>, <-0.191984,0.666319,-0.720528>, <-0.191984,0.720528,0.666319>, <-0.192105,0.891388,-0.410515>,
			<-0.166676,-0.174937,-0.970369>, <-0.160367,-0.987057,-0.000002>, <-0.160394,-0.911897,-0.37778>, <-0.160394,-0.37778,0.911897>,
			<-0.160367,0.000002,-0.987057>, <-0.160367,-0.000002,0.987057>, <-0.160394,0.37778,-0.911897>, <-0.160394,0.911897,0.37778>,
			<-0.160367,0.987057,0.000002>, <-0.131638,-0.438143,0.889215>, <-0.114108,-0.379172,-0.918263>, <-0.110858,-0.389812,-0.914198>,
			<-0.099458,-0.355769,0.929267>, <-0.083686,-0.14327,-0.986139>, <-0.083686,-0.14327,0.986139>, <-0.019644,-0.138834,0.990121>,
			<0,-1,0>, <0,-0.923856,-0.382739>, <0,-0.923856,0.382739>, <0,-0.707107,-0.707107>,
			<0,-0.707107,0.707107>, <0,-0.382739,-0.923856>, <0,-0.382739,0.923856>, <0,0,-1>,
			<0,0,1>, <0,0,1>, <0,0.382739,-0.923856>, <0,0.382739,0.923856>,
			<0,0.707107,-0.707107>, <0,0.707107,0.707107>, <0,0.923856,-0.382739>, <0,0.923856,0.382739>,
			<0,1,0>, <0.105124,-0.019968,-0.994259>, <0.156114,0.045247,-0.986702>, <0.249082,0,-0.968482>,
			<0.365054,0.16118,-0.916928>, <0.446392,-0.802318,-0.396258>, <0.446153,-0.673422,0.589449>, <0.446153,-0.589449,-0.673422>,
			<0.446392,-0.396258,0.802318>, <0.446392,0.396258,-0.802318>, <0.446153,0.589449,0.673422>, <0.446153,0.673422,-0.589449>,
			<0.446392,0.802318,0.396258>, <0.447214,-0.894427,-0.000049>, <0.446572,-0.847449,0.287059>, <0.446572,-0.287059,-0.847449>,
			<0.447214,0.000049,-0.894427>, <0.447214,-0.000049,0.894427>, <0.446572,0.287059,0.847449>, <0.446572,0.847449,-0.287059>,
			<0.447214,0.894427,0.000049>, <0.585045,-0.810977,0.006183>, <0.584895,-0.747052,0.31593>, <0.585085,-0.577818,-0.569036>,
			<0.585085,-0.569036,0.577818>, <0.584895,-0.31593,-0.747052>, <0.585045,-0.006183,-0.810977>, <0.585045,0.006183,0.810977>,
			<0.584895,0.31593,0.747052>, <0.585085,0.569036,-0.577818>, <0.585085,0.577818,0.569036>, <0.584895,0.747052,-0.31593>,
			<0.585045,0.810977,-0.006183>, <0.610778,-0.720149,-0.329143>, <0.610778,-0.329143,0.720149>, <0.610778,0.329143,-0.720149>,
			<0.610778,0.720149,0.329143>, <0.624234,0.277695,-0.730217>, <0.706193,-0.706463,0.046916>, <0.706099,-0.670651,-0.227271>,
			<0.706264,-0.634743,0.313517>, <0.706454,-0.532598,-0.466113>, <0.706454,-0.466113,0.532598>, <0.706264,-0.313517,-0.634743>,
			<0.706099,-0.227271,0.670651>, <0.706193,-0.046916,-0.706463>, <0.706193,0.046916,0.706463>, <0.706099,0.227271,-0.670651>,
			<0.706264,0.313517,0.634743>, <0.706454,0.466113,-0.532598>, <0.706454,0.532598,0.466113>, <0.706264,0.634743,-0.313517>,
			<0.706099,0.670651,0.227271>, <0.706193,0.706463,-0.046916>, <0.770239,0.311612,-0.556444>, <0.892932,0.263323,-0.365148>,
			<0.917264,0.240971,-0.317112>, <0.971439,0.170306,-0.165236>, <1,0,0>
		}
		face_indices {
			217,
			<77, 93, 91>, <77, 91, 75>, <93, 109, 107>, <93, 107, 91>,
			<109, 125, 123>, <109, 123, 107>, <125, 141, 139>, <125, 139, 123>,
			<79, 95, 93>, <79, 93, 77>, <95, 111, 109>, <95, 109, 93>,
			<111, 127, 125>, <111, 125, 109>, <127, 143, 141>, <127, 141, 125>,
			<81, 97, 95>, <81, 95, 79>, <97, 113, 111>, <97, 111, 95>,
			<113, 129, 127>, <113, 127, 111>, <129, 145, 143>, <129, 143, 127>,
			<83, 99, 97>, <83, 97, 81>, <99, 115, 113>, <99, 113, 97>,
			<115, 131, 129>, <115, 129, 113>, <131, 147, 145>, <131, 145, 129>,
			<85, 101, 99>, <85, 99, 83>, <101, 117, 115>, <101, 115, 99>,
			<117, 133, 131>, <117, 131, 115>, <133, 149, 147>, <133, 147, 131>,
			<87, 103, 101>, <87, 101, 85>, <103, 119, 117>, <103, 117, 101>,
			<119, 135, 133>, <119, 133, 117>, <135, 151, 149>, <135, 149, 133>,
			<89, 105, 103>, <89, 103, 87>, <105, 121, 119>, <105, 119, 103>,
			<121, 137, 135>, <121, 135, 119>, <137, 153, 151>, <137, 151, 135>,
			<90, 106, 105>, <90, 105, 89>, <106, 122, 121>, <106, 121, 105>,
			<122, 138, 137>, <122, 137, 121>, <138, 154, 153>, <138, 153, 137>,
			<88, 104, 106>, <88, 106, 90>, <104, 120, 122>, <104, 122, 106>,
			<120, 136, 138>, <120, 138, 122>, <136, 152, 154>, <136, 154, 138>,
			<86, 102, 104>, <86, 104, 88>, <102, 118, 120>, <102, 120, 104>,
			<118, 134, 136>, <118, 136, 120>, <134, 150, 152>, <134, 152, 136>,
			<84, 100, 102>, <84, 102, 86>, <100, 116, 118>, <100, 118, 102>,
			<116, 132, 134>, <116, 134, 118>, <132, 148, 150>, <132, 150, 134>,
			<82, 98, 100>, <82, 100, 84>, <98, 114, 116>, <98, 116, 100>,
			<114, 130, 132>, <114, 132, 116>, <130, 146, 148>, <130, 148, 132>,
			<80, 96, 98>, <80, 98, 82>, <96, 112, 114>, <96, 114, 98>,
			<112, 128, 130>, <112, 130, 114>, <128, 144, 146>, <128, 146, 130>,
			<78, 94, 96>, <78, 96, 80>, <94, 110, 112>, <94, 112, 96>,
			<110, 126, 128>, <110, 128, 112>, <126, 142, 144>, <126, 144, 128>,
			<76, 92, 94>, <76, 94, 78>, <92, 108, 110>, <92, 110, 94>,
			<108, 124, 126>, <108, 126, 110>, <124, 140, 142>, <124, 142, 126>,
			<75, 91, 92>, <75, 92, 76>, <91, 107, 108>, <91, 108, 92>,
			<107, 123, 124>, <107, 124, 108>, <123, 139, 140>, <123, 140, 124>,
			<65, 63, 60>, <65, 60, 61>, <68, 67, 63>, <68, 63, 65>,
			<73, 71, 67>, <73, 67, 68>, <74, 72, 71>, <74, 71, 73>,
			<70, 72, 74>, <69, 66, 70>, <69, 70, 74>, <64, 62, 66>,
			<64, 66, 69>, <58, 59, 62>, <58, 62, 64>, <51, 52, 39>,
			<51, 39, 38>, <52, 54, 41>, <52, 41, 39>, <54, 56, 47>,
			<54, 47, 41>, <56, 58, 47>, <38, 39, 28>, <39, 41, 30>,
			<41, 47, 36>, <47, 58, 43>, <28, 19, 38>, <30, 28, 39>,
			<36, 30, 41>, <43, 36, 47>, <19, 28, 15>, <19, 15, 14>,
			<28, 30, 17>, <28, 17, 15>, <30, 36, 32>, <30, 32, 17>,
			<36, 43, 32>, <38, 40, 53>, <38, 53, 51>, <40, 42, 55>,
			<40, 55, 53>, <42, 48, 57>, <42, 57, 55>, <48, 61, 57>,
			<48, 37, 44>, <44, 61, 48>, <29, 40, 38>, <31, 42, 40>,
			<37, 48, 42>, <38, 19, 29>, <40, 29, 31>, <42, 31, 37>,
			<14, 16, 29>, <14, 29, 19>, <16, 18, 31>, <16, 31, 29>,
			<18, 33, 37>, <18, 37, 31>, <33, 44, 37>, <26, 23, 10>,
			<26, 10, 12>, <12, 10, 8>, <12, 8, 6>, <6, 8, 2>,
			<6, 2, 4>, <4, 2, 0>, <4, 0, 1>, <1, 0, 3>,
			<1, 3, 5>, <5, 3, 9>, <5, 9, 7>, <7, 9, 11>,
			<7, 11, 13>, <13, 11, 24>, <13, 24, 27>, <21, 25, 35>,
			<21, 35, 45>, <21, 45, 49>, <21, 49, 65>, <21, 65, 61>,
			<21, 61, 44>, <20, 43, 58>, <34, 22, 20>, <58, 34, 20>,
			<34, 58, 64>, <34, 64, 46>, <69, 46, 64>, <46, 69, 50>,
			<74, 50, 69>
		}
		normal_indices {
			217,
			<31, 60, 69>, <31, 69, 30>, <60, 86, 84>, <60, 84, 69>,
			<114, 122, 121>, <114, 121, 113>, <122, 140, 138>, <122, 138, 121>,
			<42, 62, 60>, <42, 60, 31>, <62, 88, 86>, <62, 86, 60>,
			<106, 124, 122>, <106, 122, 114>, <124, 142, 140>, <124, 140, 122>,
			<33, 71, 62>, <33, 62, 42>, <71, 90, 88>, <71, 88, 62>,
			<108, 134, 124>, <108, 124, 106>, <134, 144, 142>, <134, 142, 124>,
			<36, 73, 71>, <36, 71, 33>, <73, 92, 90>, <73, 90, 71>,
			<117, 127, 134>, <117, 134, 108>, <127, 146, 144>, <127, 144, 134>,
			<37, 64, 73>, <37, 73, 36>, <64, 95, 92>, <64, 92, 73>,
			<118, 128, 127>, <118, 127, 117>, <128, 148, 146>, <128, 146, 127>,
			<44, 66, 64>, <44, 64, 37>, <66, 97, 95>, <66, 95, 64>,
			<110, 130, 128>, <110, 128, 118>, <130, 150, 148>, <130, 148, 128>,
			<39, 75, 66>, <39, 66, 44>, <75, 99, 97>, <75, 97, 66>,
			<112, 136, 130>, <112, 130, 110>, <136, 152, 150>, <136, 150, 130>,
			<41, 76, 75>, <41, 75, 39>, <76, 100, 99>, <76, 99, 75>,
			<120, 132, 136>, <120, 136, 112>, <132, 153, 152>, <132, 152, 136>,
			<40, 67, 76>, <40, 76, 41>, <67, 98, 100>, <67, 100, 76>,
			<119, 131, 132>, <119, 132, 120>, <131, 151, 153>, <131, 153, 132>,
			<45, 65, 67>, <45, 67, 40>, <65, 96, 98>, <65, 98, 67>,
			<111, 129, 131>, <111, 131, 119>, <129, 149, 151>, <129, 151, 131>,
			<38, 74, 65>, <38, 65, 45>, <74, 94, 96>, <74, 96, 65>,
			<109, 135, 129>, <109, 129, 111>, <135, 147, 149>, <135, 149, 129>,
			<35, 72, 74>, <35, 74, 38>, <72, 91, 94>, <72, 94, 74>,
			<116, 126, 135>, <116, 135, 109>, <126, 145, 147>, <126, 147, 135>,
			<34, 63, 72>, <34, 72, 35>, <63, 89, 91>, <63, 91, 72>,
			<115, 125, 126>, <115, 126, 116>, <125, 143, 145>, <125, 145, 126>,
			<43, 61, 63>, <43, 63, 34>, <61, 87, 89>, <61, 89, 63>,
			<107, 123, 125>, <107, 125, 115>, <123, 141, 143>, <123, 143, 125>,
			<32, 70, 61>, <32, 61, 43>, <70, 85, 87>, <70, 87, 61>,
			<105, 133, 123>, <105, 123, 107>, <133, 139, 141>, <133, 141, 123>,
			<30, 69, 70>, <30, 70, 32>, <69, 84, 85>, <69, 85, 70>,
			<113, 121, 133>, <113, 133, 105>, <121, 138, 139>, <121, 139, 133>,
			<158, 158, 158>, <158, 158, 158>, <158, 158, 158>, <158, 158, 158>,
			<158, 158, 158>, <158, 158, 158>, <158, 158, 158>, <158, 158, 158>,
			<158, 158, 158>, <158, 158, 158>, <158, 158, 158>, <158, 158, 158>,
			<158, 158, 158>, <158, 158, 158>, <158, 158, 158>, <46, 47, 28>,
			<46, 28, 25>, <47, 59, 49>, <47, 49, 28>, <59, 78, 79>,
			<59, 79, 49>, <78, 101, 79>, <25, 28, 23>, <28, 49, 26>,
			<49, 79, 56>, <79, 101, 81>, <23, 22, 25>, <26, 23, 28>,
			<56, 26, 49>, <81, 68, 79>, <5, 10, 7>, <5, 7, 6>,
			<10, 15, 13>, <10, 13, 7>, <15, 20, 21>, <15, 21, 13>,
			<68, 81, 54>, <25, 29, 48>, <25, 48, 46>, <29, 53, 57>,
			<29, 57, 48>, <53, 80, 77>, <53, 77, 57>, <80, 83, 77>,
			<80, 58, 82>, <82, 83, 80>, <24, 29, 25>, <27, 53, 29>,
			<58, 80, 53>, <25, 22, 24>, <29, 24, 27>, <53, 27, 58>,
			<6, 9, 8>, <6, 8, 5>, <9, 16, 14>, <9, 14, 8>,
			<16, 19, 19>, <16, 19, 14>, <55, 82, 55>, <50, 52, 50>,
			<50, 50, 50>, <17, 17, 11>, <17, 11, 11>, <11, 11, 3>,
			<11, 3, 3>, <3, 3, 0>, <3, 0, 1>, <1, 0, 2>,
			<1, 2, 4>, <4, 2, 12>, <4, 12, 12>, <12, 12, 18>,
			<12, 18, 18>, <51, 51, 51>, <51, 51, 51>, <92, 93, 92>,
			<92, 92, 92>, <92, 92, 92>, <92, 92, 92>, <92, 92, 83>,
			<92, 83, 82>, <102, 81, 101>, <104, 103, 102>, <101, 104, 102>,
			<104, 101, 137>, <104, 137, 154>, <155, 154, 137>, <154, 155, 156>,
			<157, 156, 155>
		}
	}
}
#end

#declare LDX_3818_dot_dat_sub_part =
#if (LDXQual = 0)
box {
	<-10,-6.5,-13.436>,<7,22.435999,6.507>
}
#else
union {
// Minifig Arm Right
// Name: 3818.dat
// Author: Chris Dee [cwdee]
// !LDRAW_ORG Part UPDATE 2010-03
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// !HELP Place at -15.552 9 0 relative to torso
// !HELP Then rotate about x axis to give required elevation of arm
// !HELP 0 = upper arm vertical
// !HELP -45 = lower arm horizontal
// !HELP -90 = upper arm horizontal
// !HELP -135 = lower arm vertical
// !HELP Then rotate 9.782 about z axis to align with slope of torso
// BFC CERTIFY CW
// !HISTORY 2002-11-30 [PTadmin] Official Update 2002-05
// !HISTORY 2007-07-29 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
// !HISTORY 2008-07-01 [tchang] Add BFC, some conditional lines
// !HISTORY 2009-05-28 [Eldar] Fix wrong color lines
// !HISTORY 2009-08-24 [PTadmin] Moved from 982
// !HISTORY 2009-12-29 [PTadmin] Official Update 2009-03
// !HISTORY 2010-08-27 [Philo] Increased hand hole to 15LDu; Fixed/added some condline.
// !HISTORY 2010-12-31 [PTadmin] Official Update 2010-03
// // peg
// BFC INVERTNEXT
	object {
		LDX_4_dash_4cyli_dot_dat_in_part
		matrix <0,2,0,7,0,0,0,0,2,0,0,0>
	}
	object {
		LDX_4_dash_4ring1_dot_dat_in_part
		matrix <0,2,0,-1,0,0,0,0,2,7,0,0>
	}
	object {
		LDX_4_dash_4cyli_dot_dat_in_part
		matrix <0,5,0,2,0,0,0,0,5,0,0,0>
	}
// //
// // flat inner arm
	object {
		LDX_2_dash_4disc_dot_dat_in_part
		matrix <0,0,6.5,-1,0,0,0,-6.5,0,0,0,0>
	}
	object {
		LDX_2_dash_4disc_dot_dat_in_part
		matrix <0,0,2,-1,0,0,0,2,0,0,0,0>
	}
// // hand hole
// BFC INVERTNEXT
	object {
		LDX_4_dash_4cylc_dot_dat_in_part
		matrix <2.5,0,0,0,10.6066,-10.6066,0,-1.76777,-1.76777,-5,8.294,0.707>
	}
	object {
		LDX_4_dash_4ring1_dot_dat_in_part
		matrix <2.5,0,0,0,-0.7071,0.7071,0,-1.7678,-1.7678,-5,18.9,-9.9>
	}
// // shoulder
	object {
		LDX_2_dash_4cyli_dot_dat_in_part
		matrix <0,0,-6.5,-3.333,8,0,-5,0,0,-1.666,0,0>
	}
// // upper arm extension (to elbow)
// // lower arm
	object {
		LDX_4_dash_4cyli_dot_dat_in_part
		matrix <5,0,0,0,-6.936,6.936,0,-3.536,-3.536,-5,18.9,-9.9>
	}
	object {
		LDX_2_dash_4cyls_dot_dat_in_part
		matrix <0,-3.5355,-3.5355,0,-2.964,2.964,-5,0,0,-5,11.964,-2.964>
	}
	object {
		LDX_1_dash_4cyli_dot_dat_in_part
		matrix <0,3.5355,3.5355,0,-5.928,5.928,5,0,0,-5,11.964,-2.964>
	}
	object {
		LDX_1_dash_4cyls_dot_dat_in_part
		matrix <0,3.5355,3.5355,0,-3.543,3.543,5,0,0,-5,6.036,2.964>
	}
	object {
		LDX_1_dash_4cyls_dot_dat_in_part
		matrix <0,-3.536,-3.536,0,-2.936,2.936,5,0,0,-5,11.964,-2.964>
	}
// // rear upper arm
// // rear shoulder line
// // crook of elbow
}
#end

#declare LDX_3819_dot_dat =
#if (LDXQual = 0)
box {
	<-7,-6.5,-13.436>,<10,22.435999,6.507>
}
#else
union {
// Minifig Arm Left
// Name: 3819.dat
// Author: Chris Dee [cwdee]
// !LDRAW_ORG Part UPDATE 2009-03
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CCW
// !HELP Place at 15.552 9 0 relative to torso
// !HELP Then rotate about x axis to give require elevation of arm
// !HELP    0 = upper arm vertical
// !HELP  -45 = lower arm horizontal
// !HELP  -90 = upper arm horizontal
// !HELP -135 = lower arm vertical
// !HELP Then rotate -9.782 about z axis to align with slope of torso
// !HISTORY 2002-11-30 [PTadmin] Official Update 2002-05
// !HISTORY 2007-07-29 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
// !HISTORY 2009-08-24 [PTadmin] Moved from 981
// !HISTORY 2009-12-29 [PTadmin] Official Update 2009-03
	object {
		LDX_3818_dot_dat_sub_part
		matrix <-1,0,0,0,1,0,0,0,1,0,0,0>
	}
	mesh2 {
		vertex_vectors {
			155,
			<-7,-4,0>, <-7,-3.696,-1.531>, <-7,-3.696,1.531>, <-7,-2.828,-2.828>,
			<-7,-2.828,2.828>, <-7,-1.531,-3.696>, <-7,-1.531,3.696>, <-7,0,-4>,
			<-7,0,4>, <-7,1.531,-3.696>, <-7,1.531,3.696>, <-7,2.828,-2.828>,
			<-7,2.828,2.828>, <-7,3.696,-1.531>, <-7,3.696,1.531>, <-7,4,0>,
			<-6,-5,0>, <-6,-4.619,-1.913>, <-6,-4.619,1.913>, <-6,-3.536,-3.536>,
			<-6,-3.536,3.536>, <-6,-1.913,-4.619>, <-6,-1.913,4.619>, <-6,0,-5>,
			<-6,0,5>, <-6,1.913,-4.619>, <-6,1.913,4.619>, <-6,3.536,-3.536>,
			<-6,3.536,3.536>, <-6,4.619,-1.913>, <-6,4.619,1.913>, <-6,5,0>,
			<-5,-5.5,0>, <-5,-5.081,-2.105>, <-5,-5.081,2.105>, <-5,-3.889,-3.889>,
			<-5,-3.889,3.889>, <-5,-2.105,-5.081>, <-5,-2.105,5.081>, <-5,0,-5.5>,
			<-5,0,5.5>, <-5,2.105,-5.081>, <-5,2.105,5.081>, <-5,3.889,-3.889>,
			<-5,3.889,3.889>, <-5,5.081,-2.105>, <-5,5.081,2.105>, <-5,5.5,0>,
			<-3.5,-5.5,0>, <-3.5,-5.081,-2.105>, <-3.5,-5.081,2.105>, <-3.5,-3.889,-3.889>,
			<-3.5,-3.889,3.889>, <-3.5,-2.105,-5.081>, <-3.5,-2.105,5.081>, <-3.5,0,-5.5>,
			<-3.5,0,5.5>, <-3.5,2.105,-5.081>, <-3.5,2.105,5.081>, <-3.5,3.889,-3.889>,
			<-3.5,3.889,3.889>, <-3.5,5.081,-2.105>, <-3.5,5.081,2.105>, <-3.5,5.5,0>,
			<-2,-5,0>, <-2,-4.619,-1.913>, <-2,-4.619,1.913>, <-2,-3.536,-3.536>,
			<-2,-3.536,3.536>, <-2,-1.913,-4.619>, <-2,-1.913,4.619>, <-2,0,-5>,
			<-2,0,5>, <-2,1.913,-4.619>, <-2,1.913,4.619>, <-2,3.536,-3.536>,
			<-2,3.536,3.536>, <-2,4.619,-1.913>, <-2,4.619,1.913>, <-2,5,0>,
			<0,-6.5,0>, <0,-6.005,-2.488>, <0,-6.005,2.488>, <0,-4.596,-4.596>,
			<0,-4.596,4.596>, <0,-2.488,-6.005>, <0,-2.488,6.005>, <0,0,-6.5>,
			<0,0,-5>, <0,0,5>, <0,0,6.5>, <0,1.913,-4.619>,
			<0,1.913,4.619>, <0,2.487,-6.005>, <0,2.5,6.5>, <0,3.536,-3.536>,
			<0,3.536,3.536>, <0,4.5,4.5>, <0,4.596,-4.596>, <0,4.619,-1.913>,
			<0,4.619,1.913>, <0,5,0>, <0,6,3>, <0,9.028,-0.028>,
			<0.381,5.206,6.5>, <0.381,8.798,-2.505>, <0.957,-2.2,-6.005>, <0.957,-2.2,6.005>,
			<1.465,7.5,6.5>, <1.465,8.604,-4.604>, <1.666,0,-6.5>, <1.666,0,6.5>,
			<1.768,-4.066,-4.596>, <1.768,-4.066,4.596>, <2.31,-5.312,-2.487>, <2.31,-5.312,2.487>,
			<2.5,-5.75,0>, <2.942,-1.53,-6.005>, <2.942,-1.53,6.005>, <3.087,8.474,-6.008>,
			<3.087,9.034,6.5>, <3.58,0,-6.005>, <3.58,0,6.005>, <4.024,-2.829,-4.596>,
			<4.024,-2.829,4.596>, <4.746,-3.695,-2.487>, <4.746,-3.695,2.487>, <4.999,8,-6.5>,
			<4.999,8,6.5>, <5,-4,0>, <5,8,-6.5>, <5,8,6.5>,
			<5,8.428,-6.5>, <5,8.4285,-6.4995>, <5,9.5715,6.4995>, <5,9.572,6.5>,
			<5.202,0,-4.596>, <5.202,0,4.596>, <6.286,0,-2.488>, <6.286,0,2.488>,
			<6.666,0,0>, <6.9125,8,-6.00535>, <6.9125,8,6.00535>, <6.9135,8.47199,-6.00489>,
			<6.9135,9.52801,6.00489>, <8.5345,8,-4.59615>, <8.5345,8,4.59615>, <8.5355,8.59589,-4.5958>,
			<8.5355,9.40411,4.5958>, <9.6185,8,-2.48755>, <9.6185,8,2.48755>, <9.6195,8.78129,-2.48736>,
			<9.6195,9.21871,2.48736>, <9.999,8,0>, <10,9,0>
		}
		normal_vectors {
			158,
			<-0.999999,0.001122,-0.000096>, <-0.998701,0.000931,-0.050954>, <-0.966617,0.000821,-0.256224>, <-0.951303,0.000733,-0.308257>,
			<-0.95134,0.001242,0.308141>, <-0.923132,0.384484,-0.000216>, <-0.923079,0.38461,0.00001>, <-0.884115,0.368559,-0.287236>,
			<-0.883984,0.368504,0.28771>, <-0.869505,0.362338,-0.335666>, <-0.869474,0.362325,0.33576>, <-0.78677,0.000477,-0.617246>,
			<-0.786832,0.000956,0.617167>, <-0.778822,0.324448,-0.536815>, <-0.778893,0.324478,0.536692>, <-0.710584,0.296015,-0.638315>,
			<-0.710669,0.29605,0.638204>, <-0.65581,0.000279,-0.754926>, <-0.655851,0.000653,0.75489>, <-0.63251,0.263565,-0.72833>,
			<-0.63243,0.263532,0.728411>, <-0.632226,0.263634,0.728552>, <-0.573462,0.819232,0>, <-0.538751,0.796748,-0.273751>,
			<-0.538751,0.796748,0.273751>, <-0.476481,0.879185,0>, <-0.406979,0.68987,-0.598706>, <-0.406979,0.68987,0.598705>,
			<-0.401486,0.827116,0.393304>, <-0.375607,0.826404,-0.419496>, <-0.316228,-0.948683,0.000052>, <-0.316403,-0.876506,0.362805>,
			<-0.315551,-0.850785,-0.420229>, <-0.315551,-0.420229,0.850785>, <-0.316403,-0.362805,-0.876506>, <-0.316228,-0.000052,-0.948683>,
			<-0.316228,0.000052,0.948683>, <-0.316403,0.362805,0.876506>, <-0.315551,0.420229,-0.850785>, <-0.315551,0.850785,0.420229>,
			<-0.316403,0.876506,-0.362805>, <-0.316228,0.948683,-0.000052>, <-0.315411,-0.713934,0.625151>, <-0.315411,-0.625151,-0.713934>,
			<-0.315411,0.625151,0.713934>, <-0.315411,0.713934,-0.625151>, <-0.287386,0.957815,-0.000002>, <-0.267113,0.889843,-0.369905>,
			<-0.267133,0.88991,0.369731>, <-0.265842,0.652334,0.70978>, <-0.250262,-0.000128,-0.968178>, <-0.250247,-0.000546,0.968182>,
			<-0.249029,0.103844,-0.962913>, <-0.249029,0.103844,0.962913>, <-0.24935,0.636192,-0.730126>, <-0.247503,0.555592,0.793763>,
			<-0.207078,0.690781,-0.692777>, <-0.195738,0.459477,-0.866353>, <-0.193638,0.645224,0.739046>, <-0.192105,-0.891388,0.410515>,
			<-0.191984,-0.720528,-0.666319>, <-0.191984,-0.666319,0.720528>, <-0.192105,-0.410515,-0.891388>, <-0.192105,0.410515,0.891388>,
			<-0.191984,0.666319,-0.720528>, <-0.191984,0.720528,0.666319>, <-0.192105,0.891388,-0.410515>, <-0.166676,0.174937,0.970369>,
			<-0.160367,-0.987057,-0.000002>, <-0.160394,-0.911897,-0.37778>, <-0.160394,-0.37778,0.911897>, <-0.160367,0.000002,-0.987057>,
			<-0.160367,-0.000002,0.987057>, <-0.160394,0.37778,-0.911897>, <-0.160394,0.911897,0.37778>, <-0.160367,0.987057,0.000002>,
			<-0.131638,0.438143,-0.889215>, <-0.114108,0.379172,0.918263>, <-0.110858,0.389812,0.914198>, <-0.099458,0.355769,-0.929267>,
			<-0.083686,0.14327,-0.986139>, <-0.083686,0.14327,0.986139>, <-0.014741,0.104182,-0.994449>, <0,-1,0>,
			<0,-0.923856,-0.382739>, <0,-0.923856,0.382739>, <0,-0.707107,-0.707107>, <0,-0.707107,0.707107>,
			<0,-0.382739,-0.923856>, <0,-0.382739,0.923856>, <0,0,-1>, <0,0,-1>,
			<0,0,1>, <0,0.382739,-0.923856>, <0,0.382739,0.923856>, <0,0.707107,-0.707107>,
			<0,0.707107,0.707107>, <0,0.923856,-0.382739>, <0,0.923856,0.382739>, <0,1,0>,
			<0.105124,0.019968,0.994259>, <0.156114,-0.045247,0.986702>, <0.249082,0,0.968482>, <0.365054,-0.16118,0.916928>,
			<0.446392,-0.802318,-0.396258>, <0.446153,-0.673422,0.589449>, <0.446153,-0.589449,-0.673422>, <0.446392,-0.396258,0.802318>,
			<0.446392,0.396258,-0.802318>, <0.446153,0.589449,0.673422>, <0.446153,0.673422,-0.589449>, <0.446392,0.802318,0.396258>,
			<0.447214,-0.894427,-0.000049>, <0.446572,-0.847449,0.287059>, <0.446572,-0.287059,-0.847449>, <0.447214,0.000049,-0.894427>,
			<0.447214,-0.000049,0.894427>, <0.446572,0.287059,0.847449>, <0.446572,0.847449,-0.287059>, <0.447214,0.894427,0.000049>,
			<0.585045,-0.810977,0.006183>, <0.584895,-0.747052,0.31593>, <0.585085,-0.577818,-0.569036>, <0.585085,-0.569036,0.577818>,
			<0.584895,-0.31593,-0.747052>, <0.585045,-0.006183,-0.810977>, <0.585045,0.006183,0.810977>, <0.584895,0.31593,0.747052>,
			<0.585085,0.569036,-0.577818>, <0.585085,0.577818,0.569036>, <0.584895,0.747052,-0.31593>, <0.585045,0.810977,-0.006183>,
			<0.610778,-0.720149,-0.329143>, <0.610778,-0.329143,0.720149>, <0.610778,0.329143,-0.720149>, <0.610778,0.720149,0.329143>,
			<0.624234,-0.277695,0.730217>, <0.706193,-0.706463,0.046916>, <0.706099,-0.670651,-0.227271>, <0.706264,-0.634743,0.313517>,
			<0.706454,-0.532598,-0.466113>, <0.706454,-0.466113,0.532598>, <0.706264,-0.313517,-0.634743>, <0.706099,-0.227271,0.670651>,
			<0.706193,-0.046916,-0.706463>, <0.706193,0.046916,0.706463>, <0.706099,0.227271,-0.670651>, <0.706264,0.313517,0.634743>,
			<0.706454,0.466113,-0.532598>, <0.706454,0.532598,0.466113>, <0.706264,0.634743,-0.313517>, <0.706099,0.670651,0.227271>,
			<0.706193,0.706463,-0.046916>, <0.770239,-0.311612,0.556444>, <0.892932,-0.263323,0.365148>, <0.917264,-0.240971,0.317112>,
			<0.971439,-0.170306,0.165236>, <1,0,0>
		}
		face_indices {
			217,
			<66, 50, 48>, <66, 48, 64>, <50, 34, 32>, <50, 32, 48>,
			<34, 18, 16>, <34, 16, 32>, <18, 2, 0>, <18, 0, 16>,
			<68, 52, 50>, <68, 50, 66>, <52, 36, 34>, <52, 34, 50>,
			<36, 20, 18>, <36, 18, 34>, <20, 4, 2>, <20, 2, 18>,
			<70, 54, 52>, <70, 52, 68>, <54, 38, 36>, <54, 36, 52>,
			<38, 22, 20>, <38, 20, 36>, <22, 6, 4>, <22, 4, 20>,
			<72, 56, 54>, <72, 54, 70>, <56, 40, 38>, <56, 38, 54>,
			<40, 24, 22>, <40, 22, 38>, <24, 8, 6>, <24, 6, 22>,
			<74, 58, 56>, <74, 56, 72>, <58, 42, 40>, <58, 40, 56>,
			<42, 26, 24>, <42, 24, 40>, <26, 10, 8>, <26, 8, 24>,
			<76, 60, 58>, <76, 58, 74>, <60, 44, 42>, <60, 42, 58>,
			<44, 28, 26>, <44, 26, 42>, <28, 12, 10>, <28, 10, 26>,
			<78, 62, 60>, <78, 60, 76>, <62, 46, 44>, <62, 44, 60>,
			<46, 30, 28>, <46, 28, 44>, <30, 14, 12>, <30, 12, 28>,
			<79, 63, 62>, <79, 62, 78>, <63, 47, 46>, <63, 46, 62>,
			<47, 31, 30>, <47, 30, 46>, <31, 15, 14>, <31, 14, 30>,
			<77, 61, 63>, <77, 63, 79>, <61, 45, 47>, <61, 47, 63>,
			<45, 29, 31>, <45, 31, 47>, <29, 13, 15>, <29, 15, 31>,
			<75, 59, 61>, <75, 61, 77>, <59, 43, 45>, <59, 45, 61>,
			<43, 27, 29>, <43, 29, 45>, <27, 11, 13>, <27, 13, 29>,
			<73, 57, 59>, <73, 59, 75>, <57, 41, 43>, <57, 43, 59>,
			<41, 25, 27>, <41, 27, 43>, <25, 9, 11>, <25, 11, 27>,
			<71, 55, 57>, <71, 57, 73>, <55, 39, 41>, <55, 41, 57>,
			<39, 23, 25>, <39, 25, 41>, <23, 7, 9>, <23, 9, 25>,
			<69, 53, 55>, <69, 55, 71>, <53, 37, 39>, <53, 39, 55>,
			<37, 21, 23>, <37, 23, 39>, <21, 5, 7>, <21, 7, 23>,
			<67, 51, 53>, <67, 53, 69>, <51, 35, 37>, <51, 37, 53>,
			<35, 19, 21>, <35, 21, 37>, <19, 3, 5>, <19, 5, 21>,
			<65, 49, 51>, <65, 51, 67>, <49, 33, 35>, <49, 35, 51>,
			<33, 17, 19>, <33, 19, 35>, <17, 1, 3>, <17, 3, 19>,
			<64, 48, 49>, <64, 49, 65>, <48, 32, 33>, <48, 33, 49>,
			<32, 16, 17>, <32, 17, 33>, <16, 0, 1>, <16, 1, 17>,
			<94, 92, 89>, <94, 89, 90>, <97, 96, 92>, <97, 92, 94>,
			<102, 100, 96>, <102, 96, 97>, <103, 101, 100>, <103, 100, 102>,
			<99, 101, 103>, <98, 95, 99>, <98, 99, 103>, <93, 91, 95>,
			<93, 95, 98>, <87, 88, 91>, <87, 91, 93>, <80, 81, 114>,
			<80, 114, 116>, <81, 83, 112>, <81, 112, 114>, <83, 85, 106>,
			<83, 106, 112>, <85, 87, 106>, <116, 114, 125>, <114, 112, 123>,
			<112, 106, 117>, <106, 87, 110>, <125, 129, 116>, <123, 125, 114>,
			<117, 123, 112>, <110, 117, 106>, <129, 125, 138>, <129, 138, 140>,
			<125, 123, 136>, <125, 136, 138>, <123, 117, 121>, <123, 121, 136>,
			<117, 110, 121>, <116, 115, 82>, <116, 82, 80>, <115, 113, 84>,
			<115, 84, 82>, <113, 107, 86>, <113, 86, 84>, <107, 90, 86>,
			<107, 118, 111>, <111, 90, 107>, <126, 115, 116>, <124, 113, 115>,
			<118, 107, 113>, <116, 129, 126>, <115, 126, 124>, <113, 124, 118>,
			<140, 139, 126>, <140, 126, 129>, <139, 137, 124>, <139, 124, 126>,
			<137, 122, 118>, <137, 118, 124>, <122, 111, 118>, <127, 133, 143>,
			<127, 143, 141>, <141, 143, 147>, <141, 147, 145>, <145, 147, 151>,
			<145, 151, 149>, <149, 151, 154>, <149, 154, 153>, <153, 154, 152>,
			<153, 152, 150>, <150, 152, 148>, <150, 148, 146>, <146, 148, 144>,
			<146, 144, 142>, <142, 144, 134>, <142, 134, 128>, <131, 135, 120>,
			<131, 120, 108>, <131, 108, 104>, <131, 104, 94>, <131, 94, 90>,
			<131, 90, 111>, <130, 110, 87>, <119, 132, 130>, <87, 119, 130>,
			<119, 87, 93>, <119, 93, 109>, <98, 109, 93>, <109, 98, 105>,
			<103, 105, 98>
		}
		normal_indices {
			217,
			<40, 66, 75>, <40, 75, 41>, <66, 97, 99>, <66, 99, 75>,
			<118, 130, 131>, <118, 131, 119>, <130, 150, 152>, <130, 152, 131>,
			<45, 64, 66>, <45, 66, 40>, <64, 95, 97>, <64, 97, 66>,
			<110, 128, 130>, <110, 130, 118>, <128, 148, 150>, <128, 150, 130>,
			<38, 73, 64>, <38, 64, 45>, <73, 93, 95>, <73, 95, 64>,
			<108, 134, 128>, <108, 128, 110>, <134, 146, 148>, <134, 148, 128>,
			<35, 71, 73>, <35, 73, 38>, <71, 90, 93>, <71, 93, 73>,
			<115, 125, 134>, <115, 134, 108>, <125, 144, 146>, <125, 146, 134>,
			<34, 62, 71>, <34, 71, 35>, <62, 88, 90>, <62, 90, 71>,
			<114, 124, 125>, <114, 125, 115>, <124, 142, 144>, <124, 144, 125>,
			<43, 60, 62>, <43, 62, 34>, <60, 86, 88>, <60, 88, 62>,
			<106, 122, 124>, <106, 124, 114>, <122, 140, 142>, <122, 142, 124>,
			<32, 69, 60>, <32, 60, 43>, <69, 84, 86>, <69, 86, 60>,
			<104, 132, 122>, <104, 122, 106>, <132, 138, 140>, <132, 140, 122>,
			<30, 68, 69>, <30, 69, 32>, <68, 83, 84>, <68, 84, 69>,
			<112, 120, 132>, <112, 132, 104>, <120, 137, 138>, <120, 138, 132>,
			<31, 59, 68>, <31, 68, 30>, <59, 85, 83>, <59, 83, 68>,
			<113, 121, 120>, <113, 120, 112>, <121, 139, 137>, <121, 137, 120>,
			<42, 61, 59>, <42, 59, 31>, <61, 87, 85>, <61, 85, 59>,
			<105, 123, 121>, <105, 121, 113>, <123, 141, 139>, <123, 139, 121>,
			<33, 70, 61>, <33, 61, 42>, <70, 89, 87>, <70, 87, 61>,
			<107, 133, 123>, <107, 123, 105>, <133, 143, 141>, <133, 141, 123>,
			<36, 72, 70>, <36, 70, 33>, <72, 92, 89>, <72, 89, 70>,
			<116, 126, 133>, <116, 133, 107>, <126, 145, 143>, <126, 143, 133>,
			<37, 63, 72>, <37, 72, 36>, <63, 94, 92>, <63, 92, 72>,
			<117, 127, 126>, <117, 126, 116>, <127, 147, 145>, <127, 145, 126>,
			<44, 65, 63>, <44, 63, 37>, <65, 96, 94>, <65, 94, 63>,
			<109, 129, 127>, <109, 127, 117>, <129, 149, 147>, <129, 147, 127>,
			<39, 74, 65>, <39, 65, 44>, <74, 98, 96>, <74, 96, 65>,
			<111, 135, 129>, <111, 129, 109>, <135, 151, 149>, <135, 149, 129>,
			<41, 75, 74>, <41, 74, 39>, <75, 99, 98>, <75, 98, 74>,
			<119, 131, 135>, <119, 135, 111>, <131, 152, 151>, <131, 151, 135>,
			<157, 157, 157>, <157, 157, 157>, <157, 157, 157>, <157, 157, 157>,
			<157, 157, 157>, <157, 157, 157>, <157, 157, 157>, <157, 157, 157>,
			<157, 157, 157>, <157, 157, 157>, <157, 157, 157>, <157, 157, 157>,
			<157, 157, 157>, <157, 157, 157>, <157, 157, 157>, <46, 48, 28>,
			<46, 28, 25>, <48, 58, 49>, <48, 49, 28>, <58, 77, 78>,
			<58, 78, 49>, <77, 100, 78>, <25, 28, 24>, <28, 49, 27>,
			<49, 78, 55>, <78, 100, 81>, <24, 22, 25>, <27, 24, 28>,
			<55, 27, 49>, <81, 67, 78>, <6, 10, 8>, <6, 8, 5>,
			<10, 16, 14>, <10, 14, 8>, <16, 21, 20>, <16, 20, 14>,
			<67, 81, 53>, <25, 29, 47>, <25, 47, 46>, <29, 54, 56>,
			<29, 56, 47>, <54, 79, 76>, <54, 76, 56>, <79, 82, 76>,
			<79, 57, 80>, <80, 82, 79>, <23, 29, 25>, <26, 54, 29>,
			<57, 79, 54>, <25, 22, 23>, <29, 23, 26>, <54, 26, 57>,
			<5, 9, 7>, <5, 7, 6>, <9, 15, 13>, <9, 13, 7>,
			<15, 19, 19>, <15, 19, 13>, <52, 80, 52>, <51, 51, 51>,
			<51, 51, 51>, <18, 18, 12>, <18, 12, 12>, <12, 12, 4>,
			<12, 4, 4>, <4, 4, 0>, <4, 0, 1>, <1, 0, 2>,
			<1, 2, 3>, <3, 2, 11>, <3, 11, 11>, <11, 11, 17>,
			<11, 17, 17>, <50, 50, 50>, <50, 50, 50>, <90, 91, 90>,
			<90, 90, 90>, <90, 90, 90>, <90, 90, 90>, <90, 90, 82>,
			<90, 82, 80>, <101, 81, 100>, <103, 102, 101>, <100, 103, 101>,
			<103, 100, 136>, <103, 136, 153>, <154, 153, 136>, <153, 154, 155>,
			<156, 155, 154>
		}
	}
}
#end

#declare LDX_2_dash_4ring2_dot_dat_in_part = disc // Ring 0.5
{
	<0,0,0>,<0,1,0>,3,2
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
	}
}

#declare LDX_2_dash_4ring2_dot_dat = disc // Ring 0.5
{
	<0,0,0>,<0,1,0>,3,2
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
	}
}

#declare LDX_3820_dot_dat =
#if (LDXQual = 0)
box {
	<-6,-8.618401,-16.945999>,<6,4.6934,13>
}
#else
union {
// Minifig Hand
// Name: 3820.dat
// Author: Orion Pobursky [OrionP]
// !LDRAW_ORG Part UPDATE 2009-03
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// !HELP The Hand angle is 14.5 degrees
// !HELP To rotate the hand to 90 degrees horizontal use the following rotation
// !HELP matrix: 1 0 0 0 0.968148 0.25038 0 -0.25038 0.968148
// !HELP After the rotation matrix is applied:
// !HELP The center of the bottom of the hand will be x, y+2.2259, z-9.3739
// !HELP The center of the top of the hand will be x, y-9.7741, z-9.3739
// !HELP where x, y, and z are the origin coordinates of the part
// !HELP Example: for the following DAT line:
// !HELP 1 16 1 1 1 1 0 0 0 0.968148 0.25038 0 -0.25038 0.968148 3820.dat
// !HELP The origin of the part is 1,1,1
// !HELP The center of the bottom of the hand is 1, 3.2259, -8.3739
// BFC CERTIFY CCW
// !HISTORY 2002-11-30 [PTadmin] Official Update 2002-05
// !HISTORY 2002-12-31 [PTadmin] Official Update 2002-06
// !HISTORY 2007-07-29 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
// !HISTORY 2008-07-07 [DeannaEarley] Removed erroneous BFC CERTIFY entries (2005-08-29
// !HISTORY 2008-07-07 [WilliamH] Added conditional lines to underside (2006-08-17)
// !HISTORY 2009-08-24 [PTadmin] Moved from 983
// !HISTORY 2009-12-29 [PTadmin] Official Update 2009-03
// // Post
	object {
		LDX_4_dash_4cyli_dot_dat_in_part
		matrix <2.5,0,0,0,0,13,0,-2.5,0,0,0,0>
	}
// BFC INVERTNEXT
	object {
		LDX_4_dash_4disc_dot_dat_in_part
		matrix <2.5,0,0,0,0,16,0,-2.5,0,0,0,13>
	}
// Hand
	object {
		LDX_2_dash_4cyli_dot_dat_in_part
		matrix <-6,0,0,0,-11.6178,-3.0046,0,-1.5023,5.8089,0,4.502,-8.518>
	}
// BFC INVERTNEXT
	object {
		LDX_2_dash_4cyli_dot_dat_in_part
		matrix <-4,0,0,0,-11.6178,-3.0046,0,-1.0015,3.8726,0,4.502,-8.518>
	}
	object {
		LDX_2_dash_4ring2_dot_dat_in_part
		matrix <-2,0,0,0,-0.9681,-0.2504,0,-0.5008,1.9363,0,4.502,-8.518>
	}
// BFC INVERTNEXT
	object {
		LDX_2_dash_4ring2_dot_dat_in_part
		matrix <-2,0,0,0,-0.9681,-0.2504,0,-0.5008,1.9363,0,-7.116,-11.522>
	}
// Cuff
// Cuff Intersect Lines
// Cuff Ring
// Flat part of Cuff
	mesh2 {
		vertex_vectors {
			125,
			<-6,-7.1155,-11.5224>, <-6,4.5023,-8.5179>, <-5.9999,-7.1155,-11.5224>, <-5.767,4.6838,-9.6794>,
			<-5.543,-6.5406,-13.7453>, <-5.543,4.635,-10.8551>, <-5,4.5023,-8.5179>, <-4.861,4.3639,-11.9808>,
			<-4.243,-6.0531,-15.6303>, <-4.243,3.8636,-13.0657>, <-4,-7.1155,-11.5224>, <-4,4.5023,-8.5179>,
			<-3.847,4.6472,-9.2773>, <-3.703,-5.963,-15.9788>, <-3.703,3.5723,-13.5128>, <-3.696,-6.7322,-13.0047>,
			<-3.6956,-6.7322,-13.0044>, <-3.696,4.6934,-10.0498>, <-3.255,4.6497,-10.7418>, <-3.187,-5.8766,-16.312799>,
			<-3.187,3.2182,-13.9608>, <-3,0,-4.4423>, <-3,0,0>, <-2.8284,-6.4073,-14.2608>,
			<-2.828,-6.4074,-14.2604>, <-2.828,4.5244,-11.4332>, <-2.7717,-1.1481,-4.5817>, <-2.7717,-1.1481,0>,
			<-2.7717,1.1481,-3.9877>, <-2.7717,1.1481,0>, <-2.712,-5.797,-16.620701>, <-2.712,2.7973,-14.3981>,
			<-2.6602,-1.3149,-4.5478>, <-2.5,0,0>, <-2.3098,-0.9567,0>, <-2.3098,0.9567,0>,
			<-2.296,-5.7276,-16.888901>, <-2.2962,-1.3762,-4.3124>, <-2.2962,1.8596,-3.4756>, <-2.2962,1.8596,0>,
			<-2.296,2.3041,-14.8117>, <-2.1213,-2.1213,-1.4641>, <-2.1213,-2.1213,0>, <-2.1213,2.1213,-3.4995>,
			<-2.1213,2.1213,0>, <-2,-6.2687,-14.7967>, <-2,-5.7129,-16.945999>, <-2,1.6198,-12.7566>,
			<-2,2.1756,-14.9059>, <-2,2.8733,-14.3247>, <-2,3.4727,-13.647>, <-2,3.965,-12.8866>,
			<-2,4.3383,-12.0536>, <-1.7678,-1.7678,0>, <-1.7678,1.7677,0>, <-1.5546,-2.5,0>,
			<-1.1481,2.7717,-3.0039>, <-1.1481,2.7717,0>, <-0.9567,-2.3098,0>, <-0.9567,2.3098,0>,
			<0,-2.5,0>, <0,-2.1213,-1.4641>, <0,-1.4914,-3.8706>, <0,2.5,0>,
			<0,3,-2.7094>, <0,3,0>, <0.9567,-2.3098,0>, <0.9567,2.3098,0>,
			<1.1481,2.7717,-3.0039>, <1.1481,2.7717,0>, <1.5546,-2.5,0>, <1.7678,-1.7678,0>,
			<1.7678,1.7677,0>, <2,-6.2687,-14.7967>, <2,-5.7129,-16.945999>, <2,1.6198,-12.7566>,
			<2,2.1756,-14.9059>, <2,2.8733,-14.3247>, <2,3.4727,-13.647>, <2,3.965,-12.8866>,
			<2,4.3383,-12.0536>, <2.1213,-2.1213,-1.4641>, <2.1213,-2.1213,0>, <2.1213,2.1213,-3.4995>,
			<2.1213,2.1213,0>, <2.296,-5.7276,-16.888901>, <2.2962,-1.3762,-4.3124>, <2.2962,1.8596,-3.4756>,
			<2.2962,1.8596,0>, <2.296,2.3041,-14.8117>, <2.3098,-0.9567,0>, <2.3098,0.9567,0>,
			<2.5,0,0>, <2.6602,-1.3149,-4.5478>, <2.712,-5.797,-16.620701>, <2.712,2.7973,-14.3981>,
			<2.7717,-1.1481,-4.5817>, <2.7717,-1.1481,0>, <2.7717,1.1481,-3.9877>, <2.7717,1.1481,0>,
			<2.8284,-6.4073,-14.2608>, <2.828,-6.4074,-14.2604>, <2.828,4.5244,-11.4332>, <3,0,-4.4423>,
			<3,0,0>, <3.187,-5.8766,-16.312799>, <3.187,3.2182,-13.9608>, <3.255,4.6497,-10.7418>,
			<3.696,-6.7322,-13.0047>, <3.6956,-6.7322,-13.0044>, <3.696,4.6934,-10.0498>, <3.703,-5.963,-15.9788>,
			<3.703,3.5723,-13.5128>, <3.847,4.6472,-9.2773>, <4,-7.1155,-11.5224>, <4,4.5023,-8.5179>,
			<4.243,-6.0531,-15.6303>, <4.243,3.8636,-13.0657>, <4.861,4.3639,-11.9808>, <5,4.5023,-8.5179>,
			<5.543,-6.5406,-13.7453>, <5.543,4.635,-10.8551>, <5.767,4.6838,-9.6794>, <6,-7.1155,-11.5224>,
			<6,4.5023,-8.5179>
		}
		normal_vectors {
			100,
			<-1,0,0>, <-1,0,0>, <-0.980762,-0.048875,0.188992>, <-0.980849,0.048751,-0.188567>,
			<-0.980875,0.048718,-0.188445>, <-0.947172,0.080294,-0.310513>, <-0.923874,-0.382697,0>, <-0.923921,-0.09579,0.370397>,
			<-0.923763,0.095888,-0.370765>, <-0.923873,0.382698,0>, <-0.896676,-0.110823,0.428592>, <-0.831662,-0.139005,0.537602>,
			<-0.831421,-0.555644,0>, <-0.831048,0.139263,-0.538484>, <-0.831356,0.55574,0.000042>, <-0.752301,-0.164937,0.637839>,
			<-0.707104,-0.70711,0>, <-0.706734,-0.177136,0.684945>, <-0.707072,0.177057,-0.684617>, <-0.707093,0.70712,0>,
			<-0.555643,-0.208167,0.80494>, <-0.556051,0.208099,-0.804675>, <-0.555614,0.83144,0>, <-0.555224,-0.208243,0.805209>,
			<-0.382698,-0.923873,0>, <-0.382113,-0.231387,0.894679>, <-0.320428,-0.237182,0.917099>, <-0.195352,-0.245555,0.949495>,
			<-0.100798,-0.907908,0.40687>, <-0.052041,-0.923352,0.380411>, <-0.042966,-0.872179,0.487297>, <-0.038835,-0.967545,0.249696>,
			<-0.033319,-0.639688,0.767912>, <-0.028709,-0.973076,0.228691>, <-0.027528,-0.995533,0.09031>, <-0.025611,-0.931946,0.361692>,
			<-0.024091,-0.875449,0.48271>, <-0.021408,-0.643509,0.765139>, <-0.010548,-0.995739,-0.091608>, <-0.010202,-0.997952,0.063153>,
			<-0.010412,-0.680399,0.732768>, <-0.008411,-0.775997,0.63068>, <-0.006808,-0.793793,0.608149>, <-0.006889,-0.711045,0.703112>,
			<-0.005213,-0.985641,-0.168775>, <-0.003691,-0.995511,-0.09457>, <0,-1,0>, <0,-0.98801,-0.15439>,
			<0,-0.982278,-0.187428>, <0,0,-1>, <0,0.967446,0.253079>, <0.000003,0.968152,0.250362>,
			<0,0.967793,0.251748>, <0.000774,0.967434,0.253123>, <0.003691,-0.995511,-0.09457>, <0.005213,-0.985641,-0.168775>,
			<0.006808,-0.793793,0.608149>, <0.006889,-0.711045,0.703112>, <0.008411,-0.775997,0.63068>, <0.010202,-0.997952,0.063153>,
			<0.010412,-0.680399,0.732768>, <0.010548,-0.995739,-0.091608>, <0.021408,-0.643509,0.765139>, <0.024091,-0.875449,0.48271>,
			<0.025611,-0.931946,0.361692>, <0.027528,-0.995533,0.09031>, <0.028709,-0.973076,0.228691>, <0.033319,-0.639688,0.767912>,
			<0.038835,-0.967545,0.249696>, <0.042966,-0.872179,0.487297>, <0.052041,-0.923352,0.380411>, <0.100798,-0.907908,0.40687>,
			<0.195455,-0.245554,0.949474>, <0.320428,-0.237182,0.917099>, <0.382113,-0.231387,0.894679>, <0.382698,-0.923873,0>,
			<0.555224,-0.208243,0.805209>, <0.555643,-0.208167,0.80494>, <0.556051,0.208099,-0.804675>, <0.555614,0.83144,0>,
			<0.707104,-0.70711,0>, <0.706734,-0.177136,0.684945>, <0.707072,0.177057,-0.684617>, <0.707093,0.70712,0>,
			<0.752301,-0.164937,0.637839>, <0.831421,-0.555644,0>, <0.831048,0.139263,-0.538484>, <0.831356,0.55574,0.000043>,
			<0.831662,-0.139005,0.537603>, <0.896676,-0.110823,0.428592>, <0.923874,-0.382697,0>, <0.923921,-0.09579,0.370397>,
			<0.923763,0.095888,-0.370765>, <0.923873,0.382698,0>, <0.947172,0.080294,-0.310513>, <0.980762,-0.048875,0.188992>,
			<0.980849,0.048751,-0.188567>, <0.980875,0.048718,-0.188445>, <1,0,0>, <1,0,0>
		}
		face_indices {
			180,
			<124, 123, 120>, <4, 0, 1>, <122, 124, 120>, <122, 120, 121>,
			<4, 1, 3>, <4, 3, 5>, <113, 110, 108>, <113, 108, 115>,
			<15, 17, 12>, <15, 12, 11>, <114, 115, 108>, <15, 11, 10>,
			<5, 7, 8>, <5, 8, 4>, <116, 118, 121>, <116, 121, 120>,
			<7, 9, 8>, <116, 117, 118>, <24, 25, 18>, <107, 102, 101>,
			<18, 17, 15>, <18, 15, 24>, <108, 110, 107>, <108, 107, 101>,
			<80, 73, 101>, <80, 101, 102>, <24, 45, 52>, <24, 52, 25>,
			<31, 40, 36>, <31, 36, 30>, <85, 89, 95>, <85, 95, 94>,
			<20, 31, 30>, <20, 30, 19>, <94, 95, 106>, <94, 106, 105>,
			<14, 20, 19>, <14, 19, 13>, <105, 106, 112>, <105, 112, 111>,
			<8, 9, 14>, <8, 14, 13>, <112, 117, 116>, <112, 116, 111>,
			<36, 40, 48>, <36, 48, 46>, <85, 74, 76>, <85, 76, 89>,
			<76, 77, 89>, <89, 77, 95>, <78, 95, 77>, <95, 78, 106>,
			<79, 106, 78>, <106, 79, 112>, <102, 112, 79>, <102, 79, 80>,
			<112, 102, 117>, <107, 117, 102>, <117, 107, 118>, <110, 118, 107>,
			<118, 110, 121>, <113, 121, 110>, <121, 113, 122>, <122, 113, 119>,
			<115, 119, 113>, <122, 119, 124>, <14, 51, 20>, <20, 50, 31>,
			<31, 49, 40>, <25, 51, 14>, <25, 9, 18>, <9, 25, 14>,
			<7, 18, 9>, <18, 7, 17>, <5, 17, 7>, <17, 5, 12>,
			<12, 6, 11>, <6, 12, 3>, <3, 12, 5>, <1, 6, 3>,
			<23, 16, 4>, <23, 4, 8>, <16, 10, 2>, <16, 2, 4>,
			<114, 109, 120>, <114, 120, 123>, <109, 100, 116>, <109, 116, 120>,
			<8, 36, 45>, <8, 45, 24>, <73, 85, 116>, <73, 116, 101>,
			<46, 45, 36>, <85, 73, 74>, <47, 45, 46>, <47, 46, 48>,
			<74, 73, 75>, <74, 75, 76>, <40, 49, 48>, <49, 31, 50>,
			<50, 20, 51>, <52, 51, 25>, <48, 49, 50>, <48, 50, 47>,
			<52, 47, 50>, <52, 50, 51>, <78, 77, 76>, <78, 76, 75>,
			<78, 75, 80>, <78, 80, 79>, <82, 70, 81>, <96, 97, 82>,
			<96, 82, 81>, <93, 96, 81>, <103, 104, 97>, <103, 97, 96>,
			<98, 99, 104>, <98, 104, 103>, <87, 88, 99>, <87, 99, 98>,
			<84, 88, 87>, <84, 87, 83>, <68, 69, 84>, <68, 84, 83>,
			<64, 65, 69>, <64, 69, 68>, <41, 55, 42>, <42, 27, 26>,
			<42, 26, 41>, <41, 26, 32>, <27, 22, 21>, <27, 21, 26>,
			<22, 29, 28>, <22, 28, 21>, <29, 39, 38>, <29, 38, 28>,
			<38, 39, 44>, <38, 44, 43>, <44, 57, 56>, <44, 56, 43>,
			<57, 65, 64>, <57, 64, 56>, <60, 58, 55>, <70, 66, 60>,
			<92, 90, 97>, <92, 97, 104>, <90, 71, 82>, <90, 82, 97>,
			<71, 66, 70>, <71, 70, 82>, <58, 53, 42>, <58, 42, 55>,
			<53, 34, 27>, <53, 27, 42>, <34, 33, 22>, <34, 22, 27>,
			<33, 35, 29>, <33, 29, 22>, <35, 54, 44>, <35, 44, 29>,
			<54, 59, 57>, <54, 57, 44>, <59, 63, 65>, <59, 65, 57>,
			<63, 67, 69>, <63, 69, 65>, <67, 72, 84>, <67, 84, 69>,
			<72, 91, 99>, <72, 99, 84>, <91, 92, 104>, <91, 104, 99>,
			<55, 41, 81>, <55, 81, 70>, <61, 41, 37>, <61, 37, 62>,
			<41, 32, 37>, <86, 81, 61>, <86, 61, 62>, <86, 93, 81>
		}
		normal_indices {
			180,
			<2, 2, 7>, <91, 95, 95>, <2, 2, 7>, <2, 7, 10>,
			<91, 95, 95>, <91, 95, 89>, <96, 92, 94>, <96, 94, 97>,
			<5, 8, 3>, <5, 3, 4>, <96, 97, 94>, <5, 4, 3>,
			<89, 88, 84>, <89, 84, 91>, <15, 11, 10>, <15, 10, 7>,
			<88, 81, 84>, <15, 17, 11>, <18, 18, 13>, <86, 82, 82>,
			<13, 8, 5>, <13, 5, 18>, <94, 92, 86>, <94, 86, 82>,
			<78, 78, 82>, <78, 82, 82>, <18, 21, 21>, <18, 21, 18>,
			<76, 74, 73>, <76, 73, 77>, <26, 25, 23>, <26, 23, 20>,
			<77, 76, 77>, <77, 77, 77>, <20, 23, 20>, <20, 20, 20>,
			<76, 77, 77>, <76, 77, 76>, <20, 20, 23>, <20, 23, 23>,
			<84, 81, 76>, <84, 76, 76>, <23, 17, 15>, <23, 15, 23>,
			<73, 74, 72>, <73, 72, 72>, <26, 27, 27>, <26, 27, 25>,
			<67, 60, 62>, <62, 60, 57>, <41, 57, 60>, <57, 41, 56>,
			<30, 56, 41>, <56, 30, 63>, <29, 63, 30>, <29, 30, 28>,
			<63, 29, 64>, <31, 64, 29>, <64, 31, 66>, <34, 66, 31>,
			<66, 34, 59>, <38, 59, 34>, <59, 38, 54>, <54, 38, 44>,
			<48, 44, 38>, <54, 44, 47>, <36, 69, 42>, <42, 58, 43>,
			<43, 40, 37>, <70, 69, 36>, <70, 35, 68>, <35, 70, 36>,
			<33, 68, 35>, <68, 33, 65>, <39, 65, 33>, <65, 39, 61>,
			<61, 55, 48>, <55, 61, 45>, <45, 61, 39>, <47, 55, 45>,
			<51, 51, 51>, <51, 51, 51>, <51, 51, 51>, <51, 51, 51>,
			<51, 51, 51>, <51, 51, 51>, <51, 51, 51>, <51, 51, 51>,
			<51, 51, 51>, <51, 51, 51>, <51, 51, 51>, <51, 51, 51>,
			<51, 51, 51>, <51, 51, 51>, <0, 0, 0>, <0, 0, 0>,
			<98, 98, 98>, <98, 98, 98>, <37, 40, 32>, <40, 43, 58>,
			<58, 42, 69>, <71, 69, 70>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <98, 98, 98>, <98, 98, 98>,
			<98, 98, 98>, <98, 98, 98>, <19, 22, 19>, <9, 9, 19>,
			<9, 19, 19>, <14, 9, 19>, <1, 1, 9>, <1, 9, 9>,
			<6, 6, 1>, <6, 1, 1>, <12, 12, 6>, <12, 6, 6>,
			<16, 12, 12>, <16, 12, 16>, <24, 24, 16>, <24, 16, 16>,
			<46, 46, 24>, <46, 24, 24>, <83, 79, 83>, <83, 93, 93>,
			<83, 93, 83>, <83, 93, 87>, <93, 99, 99>, <93, 99, 93>,
			<99, 90, 90>, <99, 90, 99>, <90, 85, 85>, <90, 85, 90>,
			<85, 85, 80>, <85, 80, 80>, <80, 75, 75>, <80, 75, 80>,
			<75, 46, 46>, <75, 46, 75>, <49, 49, 49>, <49, 49, 49>,
			<49, 49, 49>, <49, 49, 49>, <49, 49, 49>, <49, 49, 49>,
			<49, 49, 49>, <49, 49, 49>, <49, 49, 49>, <49, 49, 49>,
			<49, 49, 49>, <49, 49, 49>, <49, 49, 49>, <49, 49, 49>,
			<49, 49, 49>, <49, 49, 49>, <49, 49, 49>, <49, 49, 49>,
			<49, 49, 49>, <49, 49, 49>, <49, 49, 49>, <49, 49, 49>,
			<49, 49, 49>, <49, 49, 49>, <49, 49, 49>, <49, 49, 49>,
			<49, 49, 49>, <49, 49, 49>, <49, 49, 49>, <49, 49, 49>,
			<51, 52, 52>, <51, 52, 51>, <50, 52, 50>, <50, 50, 50>,
			<52, 50, 50>, <50, 52, 50>, <50, 50, 50>, <50, 53, 52>
		}
	}
}
#end

#declare LDX_building_001_statue_dot_ldr = union {
// Datsville J Jessiman Monument
// Name: building_001_statue.ldr
// Author: Thomas Burger
// Unofficial Datsville Model
// !HISTORY 2009-11-29 TE Replaced spots with Datshine objects
// // INSTRUCTIONS on Camera.dat and look_at.dat information files
// // Uncomment, save, start L3P-AddOn, pick this file,
// // (DON'T click "Run L3P"!),
// // click "Get Camera and Look At settings from Model File",
// // pick this file's Parent or Town.ldr, then click "Run L3P"
// Look at Monument with Town Hall in background.
// 1 16  -2560 -24 640  1 0 0  0 1 0  0 0 1  look_at.dat
// 1 16  -1861.11 -94.11 721.11  1 0 0  0 1 0  0 0 1  camera.dat
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		lg_2577
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 80, 40, 10, -40)
		matrix <1,0,0,0,1,0,0,0,1,0,-24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	object {
		lg_2577
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 80, 40, 10, -40)
		matrix <0,0,-1,0,1,0,1,0,0,0,-24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	object {
		lg_2577
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 80, 40, 10, -40)
		matrix <-1,0,0,0,1,0,0,0,-1,0,-24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	object {
		lg_2577
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 80, 40, 10, -40)
		matrix <0,0,1,0,1,0,-1,0,0,0,-24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	object {
		lg_2456
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-48,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	object {
		lg_2456
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-48,20>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-48,-50>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,0,-48,50>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	object {
		lg_6187
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 48, 20, 0, 24, 0)
		matrix <0,0,-1,0,1,0,1,0,0,70,-72,0>
		#if (version >= 3.1) material #else texture #end { LDXColor87 }
	}
	object {
		lg_6187
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 48, 20, 0, 24, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-70,-72,0>
		#if (version >= 3.1) material #else texture #end { LDXColor87 }
	}
	object {
		lg_6187
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 48, 20, 0, 24, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,0,-72,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor87 }
	}
	object {
		lg_6187
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 48, 20, 0, 24, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,0,-72,70>
		#if (version >= 3.1) material #else texture #end { LDXColor87 }
	}
	object {
		lg_6222
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80.001434, 28, 80.001434, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-72,0>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	object {
		lg_3039
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-10,-96,0>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	object {
		lg_3039_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-10,-96,0>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	object {
		LDX_building_001_3039p_JJ_dot_dat
		matrix <1,0,0,0,1,0,0,0,1,10,-96,0>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	object {
		lg_2432
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 32, 20.000101, 0, 16, 0.000051)
		matrix <1,0,0,0,1,0,0,0,1,0,-104,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	object {
		lg_2432
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 32, 20.000101, 0, 16, 0.000051)
		matrix <-1,0,0,0,1,0,0,0,-1,0,-104,30>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	object {
		LDX_3794a_dot_dat
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-104,10>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	object {
		LDX_3794a_dot_dat
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,0,-104,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	object {
		LDX_building_001_jjlite_dot_ldr
		matrix <0,-0.707107,0.707107,0,-0.707107,-0.707107,1,0,0,20,-68,70>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		LDX_building_001_jjlite_dot_ldr
		matrix <0,0.707107,0.707107,0,-0.707107,0.707107,1,0,0,20,-68,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
// legs & hip
	object {
		LDX_3817_dot_dat
		LDXSeamMatrix(18, 37, 20, 10.5, 9.5, -1)
		matrix <0,0,1,0,1,0,-1,0,0,0,-132,0>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	object {
		LDX_3816_dot_dat
		LDXSeamMatrix(18, 37, 20, -10.5, 9.5, -1)
		matrix <0,0,1,0,1,0,-1,0,0,0,-132,0>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	object {
		LDX_3815_dot_dat
		LDXSeamMatrix(36, 32.000195, 20, 0, 5.000097, 0)
		matrix <0,0,1,0,1,0,-1,0,0,0,-144,0>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
// torso
	object {
		lg_0973
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(38, 44, 20, 0, 10, 0)
		matrix <0,0,1,0,1,0,-1,0,0,0,-176,0>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
// head
	object {
		lg_3626bp01
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(26, 28, 26, 0, 10, 0)
		matrix <0,0,1,0,1,0,-1,0,0,0,-200,0>
		#if (version >= 3.1) material #else texture #end { LDXColor87 }
	}
// hat
	object {
		lg_4485
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(28, 20, 42, 0, -1, -7)
		matrix <0,0,1,0,1,0,-1,0,0,0,-200,0>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
// arms
	object {
		LDX_3818_dot_dat
		matrix <0,0.17,0.9859,0,0.9859,-0.17,-1,0,0,0,-168,-15.552>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
	object {
		LDX_3819_dot_dat
		LDXSeamMatrix(17, 28.935999, 19.943001, 1.5, 7.967999, -3.4645)
		matrix <0,-0.17,0.9859,0,0.9859,0.17,-1,0,0,0,-168,15.552>
		#if (version >= 3.1) material #else texture #end { LDXColor60 }
	}
// hands
	object {
		LDX_3820_dot_dat
		matrix <0,0.17,0.9859,-0.7071,0.6972,-0.1202,-0.7071,-0.6972,0.1202,9.9,-150.216003,-23.6943>
		#if (version >= 3.1) material #else texture #end { LDXColor87 }
	}
	object {
		LDX_3820_dot_dat
		matrix <0,-0.17,0.9859,-0.7071,0.6972,0.1202,-0.7071,-0.6972,-0.1202,9.9,-150.216003,23.6943>
		#if (version >= 3.1) material #else texture #end { LDXColor87 }
	}
// TEST 1 46 60.52 -54.19 -20   0 -0.71 -0.71  0 -0.71 0.71  -1 0 0  3024.dat
}

#declare LDX_building_001_jessimanmemorial_dot_mpd = union {
// FILE building_001.ldr
// James Jessiman Memorial
// Name: building_001.ldr
// Author: Thomas Burger, John VanZwieten, Tore Eriksson
// Unofficial Datsville Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		LDX_building_001_park_dot_ldr
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
	}
	object {
		LDX_building_001_statue_dot_ldr
		matrix <1,0,0,0,1,0,0,0,1,0,-8,0>
	}
}

#declare LDX_block_001_dot_ldr = union {
// Datsville City Block #1
// Name: block_001.ldr
// Author: John VanZwieten, Michael Horvath, Tore Eriksson
// Unofficial Datsville Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		lg_3811
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(640, 8, 640, 0, 0, 0)
		matrix <1,0,0,0,1,0,0,0,1,-320,0,320>
		#if (version >= 3.1) material #else texture #end { LDXColor13 }
	}
	object {
		LDX_building_001_jessimanmemorial_dot_mpd
		matrix <1,0,0,0,1,0,0,0,1,-320,0,320>
		#if (version >= 3.1) material #else texture #end { LDXColor13 }
	}
}

#declare LDX_s_slash_87079s01_dot_dat_in_part = union {
// ~Tile  2 x  4 with Groove without Top
// Name: s\87079s01.dat
// Author: Philippe Hurbain [Philo]
// !LDRAW_ORG Subpart UPDATE 2012-03
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CCW
// !HISTORY 2012-09-30 [Philo] Subparted from Tim Gould's original design
// !HISTORY 2012-12-28 [PTadmin] Official Update 2012-03
// BFC INVERTNEXT
	#if (LDXStuds)
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,0,4,0>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,20,4,0>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-20,4,0>
		}
	#end // LDXStuds
}

#declare LDX_87079_dot_dat =
#if (LDXQual = 0)
box {
	<-40,0,-20>,<40,8,20>
}
#else
union {
// Tile  2 x  4 with Groove
// Name: 87079.dat
// Author: Tim Gould [timgould]
// !LDRAW_ORG Part UPDATE 2012-03
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CCW
// !HISTORY 2010-04-05 [PTadmin] Official Update 2010-01
// !HISTORY 2012-09-30 [Philo] Subparted for patterns
// !HISTORY 2012-12-28 [PTadmin] Official Update 2012-03
	object {
		LDX_s_slash_87079s01_dot_dat_in_part
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
	}
	mesh2 {
		vertex_vectors {
			24,
			<-40,0,-20>, <-40,0,20>, <-40,7,-20>, <-40,7,20>,
			<-39,7,-19>, <-39,7,19>, <-39,8,-19>, <-39,8,19>,
			<-36,4,-16>, <-36,4,16>, <-36,8,-16>, <-36,8,16>,
			<36,4,-16>, <36,4,16>, <36,8,-16>, <36,8,16>,
			<39,7,-19>, <39,7,19>, <39,8,-19>, <39,8,19>,
			<40,0,-20>, <40,0,20>, <40,7,-20>, <40,7,20>
		}
		normal_vectors {
			6,
			<-1,0,0>, <0,-1,0>, <0,0,-1>, <0,0,1>,
			<0,1,0>, <1,0,0>
		}
		face_indices {
			44,
			<0, 20, 21>, <0, 21, 1>, <3, 1, 21>, <3, 21, 23>,
			<2, 0, 1>, <2, 1, 3>, <22, 20, 0>, <22, 0, 2>,
			<23, 21, 20>, <23, 20, 22>, <7, 5, 17>, <7, 17, 19>,
			<6, 4, 5>, <6, 5, 7>, <18, 16, 4>, <18, 4, 6>,
			<19, 17, 16>, <19, 16, 18>, <13, 9, 8>, <13, 8, 12>,
			<13, 15, 11>, <13, 11, 9>, <12, 14, 15>, <12, 15, 13>,
			<8, 10, 14>, <8, 14, 12>, <9, 11, 10>, <9, 10, 8>,
			<2, 4, 16>, <2, 16, 22>, <23, 17, 5>, <23, 5, 3>,
			<2, 3, 5>, <2, 5, 4>, <23, 22, 16>, <23, 16, 17>,
			<6, 10, 14>, <6, 14, 18>, <19, 15, 11>, <19, 11, 7>,
			<6, 7, 11>, <6, 11, 10>, <19, 18, 14>, <19, 14, 15>
		}
		normal_indices {
			44,
			<4, 4, 4>, <4, 4, 4>, <2, 2, 2>, <2, 2, 2>,
			<5, 5, 5>, <5, 5, 5>, <3, 3, 3>, <3, 3, 3>,
			<0, 0, 0>, <0, 0, 0>, <2, 2, 2>, <2, 2, 2>,
			<5, 5, 5>, <5, 5, 5>, <3, 3, 3>, <3, 3, 3>,
			<0, 0, 0>, <0, 0, 0>, <4, 4, 4>, <4, 4, 4>,
			<2, 2, 2>, <2, 2, 2>, <0, 0, 0>, <0, 0, 0>,
			<3, 3, 3>, <3, 3, 3>, <5, 5, 5>, <5, 5, 5>,
			<1, 1, 1>, <1, 1, 1>, <1, 1, 1>, <1, 1, 1>,
			<1, 1, 1>, <1, 1, 1>, <1, 1, 1>, <1, 1, 1>,
			<1, 1, 1>, <1, 1, 1>, <1, 1, 1>, <1, 1, 1>,
			<1, 1, 1>, <1, 1, 1>, <1, 1, 1>, <1, 1, 1>
		}
	}
}
#end

#declare LDX_s_slash_973s01_dot_dat_in_part = union {
// ~Subpart Minifig Torso without Front or Back
// Name: s\973s01.dat
// Author: Steve Bliss [sbliss]
// !LDRAW_ORG Subpart UPDATE 2002-02
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CW
// !HISTORY 1999-04-16 [sbliss] Moved to s\973s01.dat; removed back area; updated comment code
// !HISTORY 1999-04-19 [sbliss] Fixed internal surface error
// !HISTORY 1999-05-17 [PTadmin] Official Update 1999-03
// !HISTORY 1999-05-24 [PTadmin] Official Update 1999-04
// !HISTORY 2000-11-05 [cwdee] Removed hard-coded neck mark; now required in main part
// !HISTORY 2001-10-26 [PTadmin] Official Update 2001-01
// !HISTORY 2002-02-05 [cwdee] Corrected L3P -check warnings; bow-tie quads mainly
// !HISTORY 2002-02-18 [PTadmin] Official Update 2002-01
// !HISTORY 2002-02-19 [sbliss] Made it fully BFC compliant
// !HISTORY 2002-04-25 [PTadmin] Official Update 2002-02
// !HISTORY 2007-09-14 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
// // Uncomment for front shell
// // 4 16 -19     29 -10  19 32 -10 -19     32 -10 19     29 -10
// // 4 16  19     29 -10 -19 29 -10 -14.345  2 -10 14.345  2 -10
// // 4 16 -14.345  2 -10 -12  0 -10  12      0 -10 14.345  2 -10
// // Uncomment for back shell
// // 4 16  19     29 10 -19 32 10  19     32 10 -19     29 10
// // 4 16 -19     29 10  19 29 10 -14.345  2 10  14.345  2 10
// // 4 16 -14.345  2 10  12  0 10 -12      0 10  14.345  2 10
// // Uncomment for neck mark
// // 1 16 0 -4 0 4.243 0 -4.243 0 -8 0 -4.243 0 -4.243 1-4cyli.dat
	object {
		LDX_4_dash_4cyli_dot_dat_in_part
		matrix <6,0,0,0,-4,0,0,0,6,0,0,0>
	}
	object {
		LDX_3_dash_4cyli_dot_dat_in_part
		matrix <4.243,0,-4.243,0,-8,0,4.243,0,4.243,0,-4,0>
	}
	object {
		LDX_4_dash_4disc_dot_dat_in_part
		matrix <6,0,0,0,1,0,0,0,6,0,-12,0>
	}
// BFC INVERTNEXT
	object {
		LDX_4_dash_4cyli_dot_dat_in_part
		matrix <0.85,4.925,0,1.97,-0.34,0,0,0,5,13.558,9.221,0>
	}
// BFC INVERTNEXT
	object {
		LDX_4_dash_4cyli_dot_dat_in_part
		matrix <-0.85,4.925,0,-1.97,-0.34,0,0,0,5,-13.558,9.221,0>
	}
}

#declare LDX_973p18_dot_dat =
#if (LDXQual = 0)
box {
	<-19,-12,-10>,<19,32,10>
}
#else
union {
// Minifig Torso with Suit and Tie Pattern
// Name: 973p18.dat
// Author: Chris Dee [cwdee]
// !LDRAW_ORG Part UPDATE 2005-01
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CW
// !KEYWORDS Town, Trains, business, corporate, professional
// !CMDLINE -c1
// !HISTORY 1999-04-16 [sbliss] Updated 973-4t.dat to s\973s01.dat; added back surface
// !HISTORY 1999-05-17 [PTadmin] Official Update 1999-03
// !HISTORY 2000-11-05 [cwdee] Moved neck mark from s\973s01.dat
// !HISTORY 2001-10-26 [PTadmin] Official Update 2001-01
// !HISTORY 2002-02-16 [Deckard] Closed small gaps in front part
// !HISTORY 2002-02-19 [sbliss] Made it all BFC compliant
// !HISTORY 2002-04-25 [PTadmin] Official Update 2002-02
// !HISTORY 2004-09-11 [tcobbs] Fixed bow-tie quad
// !HISTORY 2005-12-28 [PTadmin] Official Update 2005-01
// !HISTORY 2007-07-28 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
	object {
		LDX_s_slash_973s01_dot_dat_in_part
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
	}
// Plain back
// Neck mark
	object {
		LDX_1_dash_4cyli_dot_dat_in_part
		matrix <4.243,0,-4.243,0,-8,0,-4.243,0,-4.243,0,-4,0>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
// Decoration
	mesh2 {
		vertex_vectors {
			67,
			<-13,23,-10>, <-13,23.5,-10>, <-10.5,0,-10>, <-10.5,10.5,-10>,
			<-10,0,-10>, <-10,10,-10>, <-9.7,13.1,-10>, <-9,13,-10>,
			<-8,0,-10>, <-8,4,-10>, <-8,10.5,-10>, <-7.5,14.5,-10>,
			<-7.5,15.3,-10>, <-7,10,-10>, <-6,10,-10>, <-6,23,-10>,
			<-6,23.5,-10>, <-5,16,-10>, <-5,16.5,-10>, <-3,0,-10>,
			<-3,14,-10>, <-2.789,13.5,-10>, <-2.5,16.4,-10>, <-2.5,16.9,-10>,
			<-1,4,-10>, <-1,4.5,-10>, <-0.75,21,-10>, <-0.75,25,-10>,
			<-0.75,29,-10>, <0,15.5,-10>, <0,16,-10>, <0,16.5,-10>,
			<0,20.25,-10>, <0,21.75,-10>, <0,24.25,-10>, <0,25.75,-10>,
			<0,28.25,-10>, <0,29.75,-10>, <0.75,21,-10>, <0.75,25,-10>,
			<0.75,29,-10>, <1,4,-10>, <1,4.5,-10>, <2.5,16.4,-10>,
			<2.5,16.9,-10>, <2.789,13.5,-10>, <3,0,-10>, <3,14,-10>,
			<5,16,-10>, <5,16.5,-10>, <6,10,-10>, <6,23,-10>,
			<6,23.5,-10>, <7,10,-10>, <7.5,14.5,-10>, <7.5,15.3,-10>,
			<8,0,-10>, <8,4,-10>, <8,10.5,-10>, <9,13,-10>,
			<9.7,13.1,-10>, <10,0,-10>, <10,10,-10>, <10.5,0,-10>,
			<10.5,10.5,-10>, <13,23,-10>, <13,23.5,-10>
		}
		normal_vectors {
			1,
			<0,0,-1>
		}
		face_indices {
			56,
			<61, 63, 64>, <61, 64, 62>, <62, 64, 58>, <62, 58, 53>,
			<53, 58, 60>, <53, 60, 59>, <59, 60, 55>, <59, 55, 54>,
			<54, 55, 49>, <54, 49, 48>, <48, 49, 44>, <48, 44, 43>,
			<43, 44, 31>, <43, 31, 30>, <46, 56, 57>, <46, 57, 41>,
			<41, 57, 50>, <41, 50, 42>, <42, 50, 47>, <30, 29, 45>,
			<30, 45, 47>, <24, 41, 42>, <24, 42, 25>, <2, 4, 5>,
			<2, 5, 3>, <3, 5, 13>, <3, 13, 10>, <10, 13, 7>,
			<10, 7, 6>, <6, 7, 11>, <6, 11, 12>, <12, 11, 17>,
			<12, 17, 18>, <18, 17, 22>, <18, 22, 23>, <23, 22, 30>,
			<23, 30, 31>, <29, 30, 20>, <29, 20, 21>, <25, 20, 14>,
			<21, 20, 25>, <42, 47, 45>, <9, 24, 25>, <9, 25, 14>,
			<8, 19, 24>, <8, 24, 9>, <51, 65, 66>, <51, 66, 52>,
			<0, 15, 16>, <0, 16, 1>, <32, 38, 33>, <32, 33, 26>,
			<34, 39, 35>, <34, 35, 27>, <36, 40, 37>, <36, 37, 28>
		}
		normal_indices {
			56,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>
		}
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	mesh2 {
		vertex_vectors {
			290,
			<-19,29,-10>, <-19,29,10>, <-19,32,-10>, <-19,32,10>,
			<-18.052,23.5,-10>, <-17.966,23,-10>, <-16.378,13.806,-10>, <-16.378,13.806,0>,
			<-16.378,13.806,10>, <-16.309999,13.412,-10>, <-16.309999,13.412,-1.9>, <-16.309999,13.412,1.9>,
			<-16.309999,13.412,10>, <-16.25,13.1,-10>, <-16.122999,12.329,-10>, <-16.122999,12.329,-3.5>,
			<-16.122999,12.329,3.5>, <-16.122999,12.329,10>, <-16,23.370001,-6>, <-16,23.370001,6>,
			<-16,32,-6>, <-16,32,6>, <-15.851,10.753,-10>, <-15.851,10.753,-4.6>,
			<-15.851,10.753,4.6>, <-15.851,10.753,10>, <-15.81,10.5,-10>, <-15.528,8.881,-10>,
			<-15.528,8.881,-5>, <-15.528,8.881,5>, <-15.528,8.881,10>, <-15.205,7.01,-10>,
			<-15.205,7.01,-4.6>, <-15.205,7.01,4.6>, <-15.205,7.01,10>, <-14.933,5.434,-10>,
			<-14.933,5.434,-3.5>, <-14.933,5.434,3.5>, <-14.933,5.434,10>, <-14.746,4.35,-10>,
			<-14.746,4.35,-1.9>, <-14.746,4.35,1.9>, <-14.746,4.35,10>, <-14.678,3.956,-10>,
			<-14.678,3.956,0>, <-14.678,3.956,10>, <-14.408,14.146,-6>, <-14.408,14.146,0>,
			<-14.408,14.146,6>, <-14.345,2,-10>, <-14.345,2,10>, <-14.34,13.752,-6>,
			<-14.34,13.752,-1.9>, <-14.34,13.752,1.9>, <-14.34,13.752,6>, <-14.153,12.669,-6>,
			<-14.153,12.669,-3.5>, <-14.153,12.669,3.5>, <-14.153,12.669,6>, <-14,0,-8>,
			<-14,0,8>, <-13.881,11.093,-6>, <-13.881,11.093,-4.6>, <-13.881,11.093,4.6>,
			<-13.881,11.093,6>, <-13.558,9.221,-6>, <-13.558,9.221,-5>, <-13.558,9.221,5>,
			<-13.558,9.221,6>, <-13.235,7.35,-6>, <-13.235,7.35,-4.6>, <-13.235,7.35,4.6>,
			<-13.235,7.35,6>, <-13,23,-10>, <-13,23.5,-10>, <-12.963,5.774,-6>,
			<-12.963,5.774,-3.5>, <-12.963,5.774,3.5>, <-12.963,5.774,6>, <-12.776,4.69,-6>,
			<-12.776,4.69,-1.9>, <-12.776,4.69,1.9>, <-12.776,4.69,6>, <-12.708,4.296,-6>,
			<-12.708,4.296,0>, <-12.708,4.296,6>, <-12.484,3,-6>, <-12.484,3,6>,
			<-12,0,-10>, <-12,0,10>, <-10.5,0,-10>, <-10.5,2,-10>,
			<-10.5,10.5,-10>, <-10,0,-10>, <-10,4,-10>, <-10,10,-10>,
			<-9.7,13.1,-10>, <-9.7,23,-10>, <-9,13,-10>, <-8,0,-10>,
			<-8,4,-10>, <-8,10.5,-10>, <-7.5,14.5,-10>, <-7.5,15.3,-10>,
			<-7.5,23,-10>, <-7,10,-10>, <-6.536,3,-6>, <-6.536,3,6>,
			<-6.536,32,-6>, <-6.536,32,6>, <-6,10,-10>, <-6,23,-10>,
			<-6,23.5,-10>, <-5,16,-10>, <-5,16.5,-10>, <-5,23,-10>,
			<-4,3,-6>, <-4,3,-3.464>, <-4,3,3.464>, <-4,3,6>,
			<-4,32,-6>, <-4,32,-3.464>, <-4,32,3.464>, <-4,32,6>,
			<-3,0,-10>, <-3,14,-10>, <-2.787,13.5,-10>, <-2.5,16.4,-10>,
			<-2.5,16.9,-10>, <-2.5,20.25,-10>, <-2.5,23,-10>, <-2.5,23.5,-10>,
			<-2.5,29,-10>, <-1,4,-10>, <-1,4.5,-10>, <-0.75,20.25,-10>,
			<-0.75,21,-10>, <-0.75,25,-10>, <-0.75,29,-10>, <-0.75,32,-10>,
			<0,15.5,-10>, <0,16,-10>, <0,16.5,-10>, <0,20.25,-10>,
			<0,21.75,-10>, <0,24.25,-10>, <0,25.75,-10>, <0,28.25,-10>,
			<0,29.75,-10>, <0,32,-10>, <0.75,20.25,-10>, <0.75,21,-10>,
			<0.75,25,-10>, <0.75,29,-10>, <0.75,32,-10>, <1,4,-10>,
			<1,4.5,-10>, <2.5,16.4,-10>, <2.5,16.9,-10>, <2.5,20.25,-10>,
			<2.5,23,-10>, <2.5,23.5,-10>, <2.5,29,-10>, <2.789,13.5,-10>,
			<3,0,-10>, <3,14,-10>, <4,3,-6>, <4,3,-3.464>,
			<4,3,3.464>, <4,3,6>, <4,32,-6>, <4,32,-3.464>,
			<4,32,3.464>, <4,32,6>, <5,16,-10>, <5,16.5,-10>,
			<5,23,-10>, <6,10,-10>, <6,23,-10>, <6,23.5,-10>,
			<6.536,3,-6>, <6.536,3,6>, <6.536,32,-6>, <6.536,32,6>,
			<7,10,-10>, <7.5,14.5,-10>, <7.5,15.3,-10>, <7.5,23,-10>,
			<8,0,-10>, <8,4,-10>, <8,10.5,-10>, <9,13,-10>,
			<9.7,13.1,-10>, <9.7,23,-10>, <10,0,-10>, <10,4,-10>,
			<10,10,-10>, <10.5,0,-10>, <10.5,2,-10>, <10.5,10.5,-10>,
			<12,0,-10>, <12,0,10>, <12.484,3,-6>, <12.484,3,6>,
			<12.708,4.296,-6>, <12.708,4.296,0>, <12.708,4.296,6>, <12.776,4.69,-6>,
			<12.776,4.69,-1.9>, <12.776,4.69,1.9>, <12.776,4.69,6>, <12.963,5.774,-6>,
			<12.963,5.774,-3.5>, <12.963,5.774,3.5>, <12.963,5.774,6>, <13,23,-10>,
			<13,23.5,-10>, <13.235,7.35,-6>, <13.235,7.35,-4.6>, <13.235,7.35,4.6>,
			<13.235,7.35,6>, <13.558,9.221,-6>, <13.558,9.221,-5>, <13.558,9.221,5>,
			<13.558,9.221,6>, <13.881,11.093,-6>, <13.881,11.093,-4.6>, <13.881,11.093,4.6>,
			<13.881,11.093,6>, <14,0,-8>, <14,0,8>, <14.153,12.669,-6>,
			<14.153,12.669,-3.5>, <14.153,12.669,3.5>, <14.153,12.669,6>, <14.34,13.752,-6>,
			<14.34,13.752,-1.9>, <14.34,13.752,1.9>, <14.34,13.752,6>, <14.345,2,-10>,
			<14.345,2,10>, <14.408,14.146,-6>, <14.408,14.146,0>, <14.408,14.146,6>,
			<14.678,3.956,-10>, <14.678,3.956,0>, <14.678,3.956,10>, <14.746,4.35,-10>,
			<14.746,4.35,-1.9>, <14.746,4.35,1.9>, <14.746,4.35,10>, <14.933,5.434,-10>,
			<14.933,5.434,-3.5>, <14.933,5.434,3.5>, <14.933,5.434,10>, <15.205,7.01,-10>,
			<15.205,7.01,-4.6>, <15.205,7.01,4.6>, <15.205,7.01,10>, <15.528,8.881,-10>,
			<15.528,8.881,-5>, <15.528,8.881,5>, <15.528,8.881,10>, <15.81,10.5,-10>,
			<15.851,10.753,-10>, <15.851,10.753,-4.6>, <15.851,10.753,4.6>, <15.851,10.753,10>,
			<16,23.370001,-6>, <16,23.370001,6>, <16,32,-6>, <16,32,6>,
			<16.122999,12.329,-10>, <16.122999,12.329,-3.5>, <16.122999,12.329,3.5>, <16.122999,12.329,10>,
			<16.25,13.1,-10>, <16.309999,13.412,-10>, <16.309999,13.412,-1.9>, <16.309999,13.412,1.9>,
			<16.309999,13.412,10>, <16.378,13.806,-10>, <16.378,13.806,0>, <16.378,13.806,10>,
			<17.966,23,-10>, <18.052,23.5,-10>, <19,29,-10>, <19,29,10>,
			<19,32,-10>, <19,32,10>
		}
		normal_vectors {
			20,
			<-1,0,0>, <-0.985624,-0.168953,0>, <-0.985435,-0.170055,0>, <-0.985431,0.170079,0>,
			<-0.707107,0,-0.707107>, <-0.707107,0,0.707107>, <-0.544351,-0.638251,-0.544351>, <-0.544351,-0.638251,0.544351>,
			<0,-1,0>, <0,0,-1>, <0,0,1>, <0,1,0>,
			<0.544351,-0.638251,-0.544351>, <0.544351,-0.638251,0.544351>, <0.707107,0,-0.707107>, <0.707107,0,0.707107>,
			<0.985435,-0.170055,0>, <0.985431,0.170079,0>, <0.985631,-0.16891,0>, <1,0,0>
		}
		face_indices {
			301,
			<2, 288, 270>, <2, 270, 20>, <288, 289, 271>, <288, 271, 270>,
			<289, 3, 21>, <289, 21, 271>, <3, 2, 20>, <3, 20, 21>,
			<120, 121, 108>, <182, 171, 170>, <109, 122, 123>, <173, 172, 183>,
			<117, 106, 108>, <117, 108, 121>, <116, 117, 121>, <116, 121, 120>,
			<182, 180, 167>, <182, 167, 171>, <171, 167, 166>, <171, 166, 170>,
			<109, 107, 118>, <109, 118, 122>, <122, 118, 119>, <122, 119, 123>,
			<168, 181, 183>, <168, 183, 172>, <169, 168, 172>, <169, 172, 173>,
			<19, 21, 20>, <19, 20, 18>, <270, 271, 269>, <270, 269, 268>,
			<20, 270, 268>, <20, 268, 18>, <271, 21, 19>, <271, 19, 269>,
			<48, 19, 18>, <48, 18, 46>, <87, 85, 83>, <87, 83, 86>,
			<268, 269, 243>, <268, 243, 241>, <204, 206, 203>, <204, 203, 202>,
			<18, 268, 202>, <18, 202, 86>, <269, 19, 87>, <269, 87, 203>,
			<86, 202, 203>, <86, 203, 87>, <287, 289, 288>, <287, 288, 286>,
			<0, 2, 3>, <0, 3, 1>, <0, 1, 8>, <0, 8, 6>,
			<43, 45, 50>, <43, 50, 49>, <49, 50, 60>, <49, 60, 59>,
			<283, 287, 286>, <283, 286, 281>, <240, 246, 244>, <240, 244, 239>,
			<230, 240, 239>, <230, 239, 229>, <89, 88, 59>, <89, 59, 60>,
			<88, 89, 201>, <88, 201, 200>, <200, 201, 230>, <200, 230, 229>,
			<49, 59, 88>, <200, 229, 239>, <240, 230, 201>, <89, 60, 50>,
			<282, 279, 280>, <282, 280, 283>, <279, 274, 275>, <279, 275, 280>,
			<274, 266, 267>, <274, 267, 275>, <266, 261, 262>, <266, 262, 267>,
			<261, 257, 258>, <261, 258, 262>, <257, 253, 254>, <257, 254, 258>,
			<253, 249, 250>, <253, 250, 254>, <249, 245, 246>, <249, 246, 250>,
			<245, 248, 247>, <245, 247, 244>, <248, 252, 251>, <248, 251, 247>,
			<252, 256, 255>, <252, 255, 251>, <256, 260, 259>, <256, 259, 255>,
			<260, 265, 264>, <260, 264, 259>, <265, 273, 272>, <265, 272, 264>,
			<273, 278, 277>, <273, 277, 272>, <278, 282, 281>, <278, 281, 277>,
			<238, 237, 242>, <238, 242, 243>, <234, 233, 237>, <234, 237, 238>,
			<228, 227, 233>, <228, 233, 234>, <224, 223, 227>, <224, 227, 228>,
			<220, 219, 223>, <220, 223, 224>, <214, 213, 219>, <214, 219, 220>,
			<210, 209, 213>, <210, 213, 214>, <206, 205, 209>, <206, 209, 210>,
			<207, 208, 205>, <207, 205, 204>, <211, 212, 208>, <211, 208, 207>,
			<217, 218, 212>, <217, 212, 211>, <221, 222, 218>, <221, 218, 217>,
			<225, 226, 222>, <225, 222, 221>, <231, 232, 226>, <231, 226, 225>,
			<235, 236, 232>, <235, 232, 231>, <241, 242, 236>, <241, 236, 235>,
			<12, 11, 7>, <12, 7, 8>, <17, 16, 11>, <17, 11, 12>,
			<25, 24, 16>, <25, 16, 17>, <30, 29, 24>, <30, 24, 25>,
			<34, 33, 29>, <34, 29, 30>, <38, 37, 33>, <38, 33, 34>,
			<42, 41, 37>, <42, 37, 38>, <45, 44, 41>, <45, 41, 42>,
			<39, 40, 44>, <39, 44, 43>, <35, 36, 40>, <35, 40, 39>,
			<31, 32, 36>, <31, 36, 35>, <27, 28, 32>, <27, 32, 31>,
			<22, 23, 28>, <22, 28, 27>, <14, 15, 23>, <14, 23, 22>,
			<9, 10, 15>, <9, 15, 14>, <6, 7, 10>, <6, 10, 9>,
			<47, 53, 54>, <47, 54, 48>, <53, 57, 58>, <53, 58, 54>,
			<57, 63, 64>, <57, 64, 58>, <63, 67, 68>, <63, 68, 64>,
			<67, 71, 72>, <67, 72, 68>, <71, 77, 78>, <71, 78, 72>,
			<77, 81, 82>, <77, 82, 78>, <81, 84, 85>, <81, 85, 82>,
			<84, 80, 79>, <84, 79, 83>, <80, 76, 75>, <80, 75, 79>,
			<76, 70, 69>, <76, 69, 75>, <70, 66, 65>, <70, 65, 69>,
			<66, 62, 61>, <66, 61, 65>, <62, 56, 55>, <62, 55, 61>,
			<56, 52, 51>, <56, 51, 55>, <52, 47, 46>, <52, 46, 51>,
			<3, 289, 287>, <3, 287, 1>, <50, 1, 287>, <50, 287, 240>,
			<201, 89, 50>, <201, 50, 240>, <188, 194, 195>, <188, 195, 189>,
			<189, 195, 196>, <189, 196, 177>, <177, 184, 191>, <177, 191, 185>,
			<177, 185, 174>, <177, 174, 165>, <165, 174, 157>, <165, 157, 141>,
			<197, 200, 239>, <197, 239, 198>, <198, 239, 263>, <198, 263, 199>,
			<190, 263, 276>, <190, 276, 192>, <192, 276, 284>, <192, 284, 193>,
			<192, 193, 187>, <192, 187, 186>, <186, 187, 176>, <186, 176, 175>,
			<175, 176, 160>, <175, 160, 158>, <158, 159, 143>, <158, 143, 142>,
			<215, 284, 285>, <215, 285, 216>, <160, 178, 179>, <160, 179, 161>,
			<161, 285, 286>, <161, 286, 162>, <153, 286, 288>, <153, 288, 154>,
			<150, 159, 162>, <150, 162, 153>, <124, 164, 155>, <124, 155, 133>,
			<134, 156, 163>, <134, 163, 126>, <126, 163, 140>, <93, 99, 100>,
			<93, 100, 94>, <94, 100, 110>, <94, 110, 95>, <105, 110, 102>,
			<105, 102, 98>, <102, 110, 125>, <102, 125, 113>, <113, 125, 141>,
			<113, 141, 127>, <88, 90, 91>, <88, 91, 49>, <49, 91, 92>,
			<49, 92, 26>, <26, 101, 96>, <26, 96, 13>, <13, 96, 97>,
			<13, 97, 5>, <97, 96, 103>, <97, 103, 104>, <104, 103, 114>,
			<104, 114, 115>, <115, 114, 128>, <115, 128, 130>, <129, 128, 142>,
			<129, 142, 143>, <5, 73, 74>, <5, 74, 4>, <111, 130, 131>,
			<111, 131, 112>, <4, 131, 132>, <4, 132, 0>, <0, 138, 139>,
			<0, 139, 2>, <129, 135, 138>, <129, 138, 132>, <143, 150, 151>,
			<135, 143, 136>, <144, 151, 152>, <144, 152, 145>, <136, 144, 145>,
			<136, 145, 137>, <146, 152, 153>, <146, 153, 147>, <137, 146, 147>,
			<137, 147, 138>, <148, 153, 154>, <148, 154, 149>, <138, 148, 149>,
			<138, 149, 139>
		}
		normal_indices {
			301,
			<11, 11, 11>, <11, 11, 11>, <11, 11, 11>, <11, 11, 11>,
			<11, 11, 11>, <11, 11, 11>, <11, 11, 11>, <11, 11, 11>,
			<11, 11, 11>, <11, 11, 11>, <11, 11, 11>, <11, 11, 11>,
			<5, 5, 5>, <5, 5, 5>, <19, 19, 19>, <19, 19, 19>,
			<15, 15, 15>, <15, 15, 15>, <0, 0, 0>, <0, 0, 0>,
			<4, 4, 4>, <4, 4, 4>, <19, 19, 19>, <19, 19, 19>,
			<14, 14, 14>, <14, 14, 14>, <0, 0, 0>, <0, 0, 0>,
			<19, 19, 19>, <19, 19, 19>, <0, 0, 0>, <0, 0, 0>,
			<10, 10, 10>, <10, 10, 10>, <9, 9, 9>, <9, 9, 9>,
			<17, 17, 17>, <17, 17, 17>, <17, 17, 17>, <17, 17, 17>,
			<3, 3, 3>, <3, 3, 3>, <3, 3, 3>, <3, 3, 3>,
			<10, 10, 10>, <10, 10, 10>, <9, 9, 9>, <9, 9, 9>,
			<11, 11, 11>, <11, 11, 11>, <19, 19, 19>, <19, 19, 19>,
			<0, 0, 0>, <0, 0, 0>, <2, 2, 2>, <2, 2, 2>,
			<1, 1, 1>, <1, 1, 1>, <1, 1, 2>, <1, 2, 2>,
			<16, 16, 16>, <16, 16, 16>, <18, 18, 18>, <18, 18, 18>,
			<16, 18, 18>, <16, 18, 16>, <8, 8, 8>, <8, 8, 8>,
			<8, 8, 8>, <8, 8, 8>, <8, 8, 8>, <8, 8, 8>,
			<6, 6, 6>, <12, 12, 12>, <13, 13, 13>, <7, 7, 7>,
			<16, 16, 16>, <16, 16, 16>, <16, 16, 16>, <16, 16, 16>,
			<16, 16, 16>, <16, 16, 16>, <16, 16, 16>, <16, 16, 16>,
			<16, 16, 16>, <16, 16, 16>, <16, 16, 16>, <16, 16, 16>,
			<16, 16, 16>, <16, 16, 16>, <16, 16, 18>, <16, 18, 16>,
			<16, 16, 16>, <16, 16, 18>, <16, 16, 16>, <16, 16, 16>,
			<16, 16, 16>, <16, 16, 16>, <16, 16, 16>, <16, 16, 16>,
			<16, 16, 16>, <16, 16, 16>, <16, 16, 16>, <16, 16, 16>,
			<16, 16, 16>, <16, 16, 16>, <16, 16, 16>, <16, 16, 16>,
			<3, 3, 3>, <3, 3, 3>, <3, 3, 3>, <3, 3, 3>,
			<3, 3, 3>, <3, 3, 3>, <3, 3, 3>, <3, 3, 3>,
			<3, 3, 3>, <3, 3, 3>, <3, 3, 3>, <3, 3, 3>,
			<3, 3, 3>, <3, 3, 3>, <3, 3, 3>, <3, 3, 3>,
			<3, 3, 3>, <3, 3, 3>, <3, 3, 3>, <3, 3, 3>,
			<3, 3, 3>, <3, 3, 3>, <3, 3, 3>, <3, 3, 3>,
			<3, 3, 3>, <3, 3, 3>, <3, 3, 3>, <3, 3, 3>,
			<3, 3, 3>, <3, 3, 3>, <3, 3, 3>, <3, 3, 3>,
			<2, 2, 2>, <2, 2, 2>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <1, 2, 2>, <1, 2, 2>,
			<2, 2, 2>, <2, 2, 1>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <2, 2, 2>, <2, 2, 2>,
			<17, 17, 17>, <17, 17, 17>, <17, 17, 17>, <17, 17, 17>,
			<17, 17, 17>, <17, 17, 17>, <17, 17, 17>, <17, 17, 17>,
			<17, 17, 17>, <17, 17, 17>, <17, 17, 17>, <17, 17, 17>,
			<17, 17, 17>, <17, 17, 17>, <17, 17, 17>, <17, 17, 17>,
			<17, 17, 17>, <17, 17, 17>, <17, 17, 17>, <17, 17, 17>,
			<17, 17, 17>, <17, 17, 17>, <17, 17, 17>, <17, 17, 17>,
			<17, 17, 17>, <17, 17, 17>, <17, 17, 17>, <17, 17, 17>,
			<17, 17, 17>, <17, 17, 17>, <17, 17, 17>, <17, 17, 17>,
			<10, 10, 10>, <10, 10, 10>, <10, 10, 10>, <10, 10, 10>,
			<10, 10, 10>, <10, 10, 10>, <9, 9, 9>, <9, 9, 9>,
			<9, 9, 9>, <9, 9, 9>, <9, 9, 9>, <9, 9, 9>,
			<9, 9, 9>, <9, 9, 9>, <9, 9, 9>, <9, 9, 9>,
			<9, 9, 9>, <9, 9, 9>, <9, 9, 9>, <9, 9, 9>,
			<9, 9, 9>, <9, 9, 9>, <9, 9, 9>, <9, 9, 9>,
			<9, 9, 9>, <9, 9, 9>, <9, 9, 9>, <9, 9, 9>,
			<9, 9, 9>, <9, 9, 9>, <9, 9, 9>, <9, 9, 9>,
			<9, 9, 9>, <9, 9, 9>, <9, 9, 9>, <9, 9, 9>,
			<9, 9, 9>, <9, 9, 9>, <9, 9, 9>, <9, 9, 9>,
			<9, 9, 9>, <9, 9, 9>, <9, 9, 9>, <9, 9, 9>,
			<9, 9, 9>, <9, 9, 9>, <9, 9, 9>, <9, 9, 9>,
			<9, 9, 9>, <9, 9, 9>, <9, 9, 9>, <9, 9, 9>,
			<9, 9, 9>, <9, 9, 9>, <9, 9, 9>, <9, 9, 9>,
			<9, 9, 9>, <9, 9, 9>, <9, 9, 9>, <9, 9, 9>,
			<9, 9, 9>, <9, 9, 9>, <9, 9, 9>, <9, 9, 9>,
			<9, 9, 9>, <9, 9, 9>, <9, 9, 9>, <9, 9, 9>,
			<9, 9, 9>, <9, 9, 9>, <9, 9, 9>, <9, 9, 9>,
			<9, 9, 9>, <9, 9, 9>, <9, 9, 9>, <9, 9, 9>,
			<9, 9, 9>, <9, 9, 9>, <9, 9, 9>, <9, 9, 9>,
			<9, 9, 9>, <9, 9, 9>, <9, 9, 9>, <9, 9, 9>,
			<9, 9, 9>, <9, 9, 9>, <9, 9, 9>, <9, 9, 9>,
			<9, 9, 9>, <9, 9, 9>, <9, 9, 9>, <9, 9, 9>,
			<9, 9, 9>, <9, 9, 9>, <9, 9, 9>, <9, 9, 9>,
			<9, 9, 9>
		}
	}
}
#end

#declare LDX_stud2a_dot_dat_in_part = union {
// Stud Open without Base Edges
// Name: stud2a.dat
// Author: James Jessiman
// !LDRAW_ORG Primitive UPDATE 2009-02
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CCW
// !HISTORY 1999-07-05 [PTadmin] Official Update 1999-05
// !HISTORY 2002-04-04 [sbliss] Modified for BFC compliance
// !HISTORY 2002-04-25 [PTadmin] Official Update 2002-02
// !HISTORY 2007-06-24 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
// !HISTORY 2009-06-21 [cwdee] Update ring references to 4-4ring
// !HISTORY 2009-09-03 [PTadmin] Official Update 2009-02
// BFC INVERTNEXT
	object {
		LDX_4_dash_4cyli_dot_dat_in_part
		matrix <4,0,0,0,4,0,0,0,4,0,-4,0>
	}
	object {
		LDX_4_dash_4cyli_dot_dat_in_part
		matrix <6,0,0,0,4,0,0,0,6,0,-4,0>
	}
	object {
		LDX_4_dash_4ring2_dot_dat_in_part
		matrix <2,0,0,0,1,0,0,0,2,0,-4,0>
	}
}

#declare LDX_s_slash_3626bs02_dot_dat_in_part = union {
// ~Minifig Head - Stud Hollow without Outer Face
// Name: s\3626bs02.dat
// Author: Andy Westrate [westrate]
// !LDRAW_ORG Subpart UPDATE 2011-02
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CW
// !HISTORY 2005-12-28 [PTadmin] Official Update 2005-01
// !HISTORY 2007-08-31 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
// !HISTORY 2011-12-01 [MagFors] Corrected colour of some conditional lines and use of 'move to'-primitives
// !HISTORY 2011-12-29 [PTadmin] Official Update 2011-02
	#if (LDXStuds)
		object {
			LDX_stud2a_dot_dat_in_part
			matrix <1,0,0,0,1,0,0,0,1,0,0,0>
		}
	#end // LDXStuds
	object {
		LDX_4_dash_4ring3_dot_dat_in_part
		matrix <2,0,0,0,1,0,0,0,2,0,0,0>
	}
	object {
		LDX_4_dash_4ring2_dot_dat_in_part
		matrix <2,0,0,0,-1,0,0,0,-2,0,4,0>
	}
// BFC INVERTNEXT
	object {
		LDX_4_dash_4cyli_dot_dat_in_part
		matrix <6,0,0,0,20,0,0,0,6,0,4,0>
	}
	object {
		LDX_4_dash_4ring3_dot_dat_in_part
		matrix <2,0,0,0,-1,0,0,0,-2,0,24,0>
	}
	object {
		LDX_4_dash_4cyli_dot_dat_in_part
		matrix <8,0,0,0,3,0,0,0,8,0,21,0>
	}
// //
// //
// //
// //
// //
}

#declare LDX_t04o6250_dot_dat_in_part = torus // Torus 0.25
{
	1,0.625
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o6250_dot_dat = torus // Torus 0.25
{
	1,0.625
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_3_dash_16cyli_dot_dat_in_part = cylinder // Cylinder 0.1875
{
	<0,0,0>,<0,1,0>,1 open
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-0.92387953251128673848,0,0.38268343236508983729>,0
		}
	}
}

#declare LDX_3_dash_16cyli_dot_dat = cylinder // Cylinder 0.1875
{
	<0,0,0>,<0,1,0>,1 open
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-0.92387953251128673848,0,0.38268343236508983729>,0
		}
	}
}

#declare LDX_t04o6250_dot_dat_in_part = torus // Torus 0.25
{
	1,0.625
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o6250_dot_dat = torus // Torus 0.25
{
	1,0.625
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o6250_dot_dat_in_part = torus // Torus 0.25
{
	1,0.625
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o6250_dot_dat = torus // Torus 0.25
{
	1,0.625
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o6250_dot_dat_in_part = torus // Torus 0.25
{
	1,0.625
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o6250_dot_dat = torus // Torus 0.25
{
	1,0.625
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o6250_dot_dat_in_part = torus // Torus 0.25
{
	1,0.625
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o6250_dot_dat = torus // Torus 0.25
{
	1,0.625
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o6250_dot_dat_in_part = torus // Torus 0.25
{
	1,0.625
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o6250_dot_dat = torus // Torus 0.25
{
	1,0.625
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o6250_dot_dat_in_part = torus // Torus 0.25
{
	1,0.625
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o6250_dot_dat = torus // Torus 0.25
{
	1,0.625
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o6250_dot_dat_in_part = torus // Torus 0.25
{
	1,0.625
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o6250_dot_dat = torus // Torus 0.25
{
	1,0.625
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o6250_dot_dat_in_part = torus // Torus 0.25
{
	1,0.625
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o6250_dot_dat = torus // Torus 0.25
{
	1,0.625
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_3626bp03_dot_dat =
#if (LDXQual = 0)
box {
	<-13,-4,-13>,<13,24,13>
}
#else
union {
// Minifig Head with Standard Grin and Pointed Moustache Pattern
// Name: 3626bp03.dat
// Author: Chris Dee [cwdee]
// !LDRAW_ORG Part UPDATE 2005-01
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CCW
// !HISTORY 1999-05-24 [PTadmin] Official Update 1999-04
// !HISTORY 2003-11-02 [hmick] corrected overlapping quads
// !HISTORY 2004-04-01 [westrate] added 3-16cyli, bfc'ed
// !HISTORY 2004-04-15 [westrate] added torus primitives
// !HISTORY 2005-12-28 [PTadmin] Official Update 2005-01
// !HISTORY 2007-06-29 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
	object {
		LDX_4_dash_4disc_dot_dat_in_part
		matrix <1.25,0,0.244,0.244,0,1,0,-1.25,0,3.5,10,-12.304>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		LDX_4_dash_4ndis_dot_dat_in_part
		matrix <1.25,0,0.244,0.244,0,1,0,-1.25,0,3.5,10,-12.304>
	}
	object {
		LDX_4_dash_4disc_dot_dat_in_part
		matrix <1.25,0,-0.244,-0.244,0,1,0,-1.25,0,-3.5,10,-12.304>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		LDX_4_dash_4ndis_dot_dat_in_part
		matrix <1.25,0,-0.244,-0.244,0,1,0,-1.25,0,-3.5,10,-12.304>
	}
// // replacing s\3626bs01.dat
	object {
		LDX_s_slash_3626bs02_dot_dat_in_part
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
	}
	object {
		LDX_2_dash_4cyli_dot_dat_in_part
		matrix <13,0,0,0,13,0,0,0,13,0,4,0>
	}
	object {
		LDX_t04o6250_dot_dat_in_part
		matrix <0,0,8,0,-6.4,0,8,0,0,0,4,0>
	}
	object {
		LDX_t04o6250_dot_dat_in_part
		matrix <-8,0,0,0,-6.4,0,0,0,8,0,4,0>
	}
	object {
		LDX_t04o6250_dot_dat_in_part
		matrix <0,0,8,0,6.4,0,-8,0,0,0,17,0>
	}
	object {
		LDX_t04o6250_dot_dat_in_part
		matrix <8,0,0,0,6.4,0,0,0,8,0,17,0>
	}
	object {
		LDX_t04o6250_dot_dat_in_part
		matrix <0,0,-8,0,-6.4,0,-8,0,0,0,4,0>
	}
	object {
		LDX_t04o6250_dot_dat_in_part
		matrix <8,0,0,0,-6.4,0,0,0,-8,0,4,0>
	}
	object {
		LDX_t04o6250_dot_dat_in_part
		matrix <0,0,-8,0,6.4,0,8,0,0,0,17,0>
	}
	object {
		LDX_t04o6250_dot_dat_in_part
		matrix <-8,0,0,0,6.4,0,0,0,-8,0,17,0>
	}
	object {
		LDX_3_dash_16cyli_dot_dat_in_part
		matrix <13,0,0,0,13,0,0,0,-13,0,4,0>
	}
	object {
		LDX_3_dash_16cyli_dot_dat_in_part
		matrix <-13,0,0,0,13,0,0,0,-13,0,4,0>
	}
	mesh2 {
		vertex_vectors {
			18,
			<-4.975,14.2,-12.01>, <-3.5,14.5,-12.304>, <-3.5,15,-12.304>, <-3,14.2,-12.403>,
			<-1.75,14.75,-12.652>, <-1.75,15.75,-12.652>, <-0.5,12,-12.901>, <-0.5,13.8,-12.901>,
			<0,15,-13>, <0,16,-13>, <0.5,12,-12.901>, <0.5,13.8,-12.901>,
			<1.75,14.75,-12.652>, <1.75,15.75,-12.652>, <3,14.2,-12.403>, <3.5,14.5,-12.304>,
			<3.5,15,-12.304>, <4.975,14.2,-12.01>
		}
		normal_vectors {
			5,
			<-0.195273,0,0.980749>, <-0.194229,0,0.980956>, <0,0,1>, <0.194229,0,0.980956>,
			<0.195273,0,0.980749>
		}
		face_indices {
			12,
			<11, 17, 10>, <12, 8, 9>, <12, 9, 13>, <14, 12, 13>,
			<14, 13, 16>, <15, 14, 16>, <6, 0, 7>, <9, 8, 4>,
			<9, 4, 5>, <5, 4, 3>, <5, 3, 2>, <2, 3, 1>
		}
		normal_indices {
			12,
			<0, 0, 0>, <0, 2, 2>, <0, 2, 0>, <0, 0, 0>,
			<0, 0, 0>, <1, 0, 0>, <4, 4, 4>, <2, 2, 4>,
			<2, 4, 4>, <4, 4, 4>, <4, 4, 4>, <4, 4, 3>
		}
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	mesh2 {
		vertex_vectors {
			103,
			<-4.975,4,-12.01>, <-4.975,8.75,-12.01>, <-4.975,11.25,-12.01>, <-4.975,12,-12.01>,
			<-4.975,14.2,-12.01>, <-4.975,16,-12.01>, <-4.975,17,-12.01>, <-4.75,8.75,-12.055>,
			<-4.75,11.25,-12.055>, <-4,0,0>, <-4,4,0>, <-3.79,0,-1.04>,
			<-3.79,4,-1.04>, <-3.6956,0,1.5308>, <-3.6956,4,1.5308>, <-3.6955,0,-1.5307>,
			<-3.6955,4,-1.5307>, <-3.5,14.2,-12.304>, <-3.5,14.5,-12.304>, <-3.5,15,-12.304>,
			<-3.5,16,-12.304>, <-3,14.2,-12.403>, <-2.85,0,-2.8>, <-2.85,4,-2.8>,
			<-2.8284,0,-2.8284>, <-2.8284,0,2.8284>, <-2.8284,4,-2.8284>, <-2.8284,4,2.8284>,
			<-2.25,8.75,-12.552>, <-2.25,11.25,-12.552>, <-1.75,14.2,-12.652>, <-1.75,14.75,-12.652>,
			<-1.75,15.75,-12.652>, <-1.75,16,-12.652>, <-1.5308,0,-3.6956>, <-1.5308,0,3.6956>,
			<-1.5308,4,-3.6956>, <-1.5308,4,3.6956>, <-1,0,0.58>, <-1,0,3.8011>,
			<-1,4,0.58>, <-1,4,3.8011>, <-0.5,12,-12.901>, <-0.5,13.8,-12.901>,
			<0,0,-4>, <0,0,-1.15>, <0,0,0>, <0,0,4>,
			<0,4,-13>, <0,4,-4>, <0,4,-1.15>, <0,4,0>,
			<0,4,4>, <0,8.75,-13>, <0,11.25,-13>, <0,14.2,-13>,
			<0,15,-13>, <0,16,-13>, <0,17,-13>, <0.5,12,-12.901>,
			<0.5,13.8,-12.901>, <1,0,0.58>, <1,0,3.8011>, <1,4,0.58>,
			<1,4,3.8011>, <1.5308,0,-3.6956>, <1.5308,0,3.6956>, <1.5308,4,-3.6956>,
			<1.5308,4,3.6956>, <1.75,14.2,-12.652>, <1.75,14.75,-12.652>, <1.75,15.75,-12.652>,
			<1.75,16,-12.652>, <2.25,8.75,-12.552>, <2.25,11.25,-12.552>, <2.8284,0,-2.8284>,
			<2.8284,0,2.8284>, <2.8284,4,-2.8284>, <2.8284,4,2.8284>, <2.85,0,-2.8>,
			<2.85,4,-2.8>, <3,14.2,-12.403>, <3.5,14.2,-12.304>, <3.5,14.5,-12.304>,
			<3.5,15,-12.304>, <3.5,16,-12.304>, <3.6955,0,-1.5307>, <3.6955,4,-1.5307>,
			<3.6956,0,1.5308>, <3.6956,4,1.5308>, <3.79,0,-1.04>, <3.79,4,-1.04>,
			<4,0,0>, <4,4,0>, <4.75,8.75,-12.055>, <4.75,11.25,-12.055>,
			<4.975,4,-12.01>, <4.975,8.75,-12.01>, <4.975,11.25,-12.01>, <4.975,12,-12.01>,
			<4.975,14.2,-12.01>, <4.975,16,-12.01>, <4.975,17,-12.01>
		}
		normal_vectors {
			36,
			<-1,0,0>, <-0.999999,0,0.001477>, <-0.980217,0,0.197928>, <-0.923873,0,-0.382698>,
			<-0.795946,0,0.605368>, <-0.707107,0,-0.707107>, <-0.685182,0,0.728372>, <-0.502136,0,0.864789>,
			<-0.501036,0,-0.865426>, <-0.382656,0,-0.923891>, <-0.382698,0,0.923873>, <-0.195642,0,0.980675>,
			<-0.194943,0,-0.980815>, <-0.195168,0,0.98077>, <-0.194229,0,0.980956>, <-0.066224,0,0.997805>,
			<-0.039786,0.00028,0.999208>, <0,-1,0>, <0,0,1>, <0,-0.000622,1>,
			<0,1,0>, <0.194229,0,0.980956>, <0.194943,0,-0.980815>, <0.195168,0,0.98077>,
			<0.195642,0,0.980675>, <0.382656,0,-0.923891>, <0.382698,0,0.923873>, <0.501036,0,-0.865426>,
			<0.502136,0,0.864789>, <0.685182,0,0.728372>, <0.707107,0,-0.707107>, <0.795946,0,0.605368>,
			<0.923873,0,-0.382698>, <0.980217,0,0.197928>, <1,0,0>, <0.999999,0,0.001477>
		}
		face_indices {
			114,
			<0, 1, 53>, <0, 53, 48>, <48, 53, 97>, <48, 97, 96>,
			<98, 97, 94>, <98, 94, 95>, <74, 73, 53>, <74, 53, 54>,
			<53, 28, 29>, <53, 29, 54>, <7, 1, 2>, <7, 2, 8>,
			<2, 3, 42>, <2, 42, 54>, <54, 59, 99>, <54, 99, 98>,
			<60, 59, 54>, <60, 54, 55>, <100, 99, 59>, <60, 55, 100>,
			<69, 55, 56>, <69, 56, 70>, <81, 69, 70>, <81, 83, 82>,
			<101, 100, 82>, <101, 82, 85>, <72, 85, 84>, <72, 84, 71>,
			<57, 72, 71>, <54, 42, 43>, <54, 43, 55>, <42, 3, 4>,
			<4, 55, 43>, <56, 55, 30>, <56, 30, 31>, <31, 30, 21>,
			<17, 18, 21>, <17, 4, 5>, <17, 5, 20>, <19, 20, 33>,
			<19, 33, 32>, <32, 33, 57>, <5, 6, 58>, <5, 58, 57>,
			<57, 58, 102>, <57, 102, 101>, <62, 61, 46>, <62, 46, 47>,
			<46, 38, 39>, <46, 39, 47>, <11, 38, 46>, <11, 46, 15>,
			<46, 45, 22>, <46, 22, 15>, <79, 45, 46>, <79, 46, 86>,
			<46, 61, 90>, <46, 90, 86>, <51, 63, 64>, <51, 64, 52>,
			<41, 40, 51>, <41, 51, 52>, <51, 40, 12>, <51, 12, 16>,
			<23, 50, 51>, <23, 51, 16>, <51, 50, 80>, <51, 80, 87>,
			<91, 63, 51>, <91, 51, 87>, <63, 61, 62>, <63, 62, 64>,
			<39, 38, 40>, <39, 40, 41>, <40, 38, 11>, <40, 11, 12>,
			<22, 45, 50>, <22, 50, 23>, <50, 45, 79>, <50, 79, 80>,
			<90, 61, 63>, <90, 63, 91>, <89, 88, 92>, <89, 92, 93>,
			<78, 76, 88>, <78, 88, 89>, <68, 66, 76>, <68, 76, 78>,
			<27, 25, 35>, <27, 35, 37>, <14, 13, 25>, <14, 25, 27>,
			<10, 9, 13>, <10, 13, 14>, <36, 34, 24>, <36, 24, 26>,
			<49, 44, 34>, <49, 34, 36>, <67, 65, 44>, <67, 44, 49>,
			<77, 75, 65>, <77, 65, 67>, <64, 62, 66>, <64, 66, 68>,
			<37, 35, 39>, <37, 39, 41>, <12, 11, 9>, <12, 9, 10>,
			<26, 24, 22>, <26, 22, 23>, <80, 79, 75>, <80, 75, 77>,
			<93, 92, 90>, <93, 90, 91>
		}
		normal_indices {
			114,
			<23, 24, 15>, <23, 15, 18>, <18, 15, 11>, <18, 11, 13>,
			<11, 11, 11>, <11, 11, 11>, <13, 13, 15>, <13, 15, 18>,
			<15, 23, 23>, <15, 23, 18>, <24, 24, 24>, <24, 24, 24>,
			<24, 23, 23>, <24, 23, 16>, <16, 13, 13>, <16, 13, 11>,
			<13, 13, 16>, <13, 16, 19>, <13, 13, 13>, <13, 19, 13>,
			<13, 19, 19>, <13, 19, 13>, <13, 13, 13>, <14, 14, 14>,
			<13, 13, 13>, <13, 13, 13>, <13, 13, 13>, <13, 13, 13>,
			<13, 13, 13>, <16, 23, 23>, <16, 23, 19>, <23, 23, 23>,
			<23, 19, 23>, <19, 19, 23>, <19, 23, 23>, <23, 23, 23>,
			<21, 21, 21>, <23, 23, 23>, <23, 23, 23>, <23, 23, 23>,
			<23, 23, 23>, <23, 23, 23>, <23, 23, 19>, <23, 19, 19>,
			<19, 19, 13>, <19, 13, 13>, <17, 17, 17>, <17, 17, 17>,
			<17, 17, 17>, <17, 17, 17>, <17, 17, 17>, <17, 17, 17>,
			<17, 17, 17>, <17, 17, 17>, <17, 17, 17>, <17, 17, 17>,
			<17, 17, 17>, <17, 17, 17>, <20, 20, 20>, <20, 20, 20>,
			<20, 20, 20>, <20, 20, 20>, <20, 20, 20>, <20, 20, 20>,
			<20, 20, 20>, <20, 20, 20>, <20, 20, 20>, <20, 20, 20>,
			<20, 20, 20>, <20, 20, 20>, <34, 34, 34>, <34, 34, 34>,
			<0, 0, 0>, <0, 0, 0>, <7, 7, 7>, <7, 7, 7>,
			<27, 27, 27>, <27, 27, 27>, <8, 8, 8>, <8, 8, 8>,
			<28, 28, 28>, <28, 28, 28>, <3, 3, 1>, <3, 1, 1>,
			<5, 5, 3>, <5, 3, 3>, <9, 9, 5>, <9, 5, 5>,
			<30, 30, 25>, <30, 25, 25>, <32, 32, 30>, <32, 30, 30>,
			<35, 35, 32>, <35, 32, 32>, <26, 26, 29>, <26, 29, 29>,
			<18, 18, 26>, <18, 26, 26>, <10, 10, 18>, <10, 18, 18>,
			<6, 6, 10>, <6, 10, 10>, <12, 12, 9>, <12, 9, 9>,
			<25, 25, 22>, <25, 22, 22>, <33, 33, 35>, <33, 35, 35>,
			<29, 29, 31>, <29, 31, 31>, <4, 4, 6>, <4, 6, 6>,
			<1, 1, 2>, <1, 2, 2>
		}
	}
}
#end

#declare LDX_4_dash_4ring8_dot_dat_in_part = disc // Ring 1
{
	<0,0,0>,<0,1,0>,9,8
}

#declare LDX_4_dash_4ring8_dot_dat = disc // Ring 1
{
	<0,0,0>,<0,1,0>,9,8
}

#declare LDX_stud4o_dot_dat_in_part = union {
// Stud Tube Open without Outer Cylinder
// Name: stud4o.dat
// Author: Magnus Forsberg [MagFors]
// !LDRAW_ORG Primitive UPDATE 2011-02
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CCW
// !HELP This stud is a "antistud" to be used like a underside stud,
// !HELP but without the outer cylinder.
// !HELP 1 47 0 0 0 1 0 0 0 1 0 0 0 1 stud4.dat
// !HISTORY 2011-12-29 [PTadmin] Official Update 2011-02
	object {
		LDX_4_dash_4ring3_dot_dat_in_part
		matrix <2,0,0,0,1,0,0,0,2,0,-4,0>
	}
// BFC INVERTNEXT
	object {
		LDX_4_dash_4cylc_dot_dat_in_part
		matrix <-6,0,0,0,-4,0,0,0,6,0,0,0>
	}
}

#declare LDX_4_dash_4ring7_dot_dat_in_part = disc // Ring 1
{
	<0,0,0>,<0,1,0>,8,7
}

#declare LDX_4_dash_4ring7_dot_dat = disc // Ring 1
{
	<0,0,0>,<0,1,0>,8,7
}

#declare LDX_4_dash_4rin39_dot_dat_in_part = disc // Ring 1
{
	<0,0,0>,<0,1,0>,40,39
}

#declare LDX_4_dash_4rin39_dot_dat = disc // Ring 1
{
	<0,0,0>,<0,1,0>,40,39
}

#declare LDX_t04o1765_dot_dat_in_part = torus // Torus 0.25
{
	1,0.17649999260902404785
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o1765_dot_dat = torus // Torus 0.25
{
	1,0.17649999260902404785
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o1765_dot_dat_in_part = torus // Torus 0.25
{
	1,0.17649999260902404785
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o1765_dot_dat = torus // Torus 0.25
{
	1,0.17649999260902404785
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o1765_dot_dat_in_part = torus // Torus 0.25
{
	1,0.17649999260902404785
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o1765_dot_dat = torus // Torus 0.25
{
	1,0.17649999260902404785
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o1765_dot_dat_in_part = torus // Torus 0.25
{
	1,0.17649999260902404785
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o1765_dot_dat = torus // Torus 0.25
{
	1,0.17649999260902404785
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o1765_dot_dat_in_part = torus // Torus 0.25
{
	1,0.17649999260902404785
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_t04o1765_dot_dat = torus // Torus 0.25
{
	1,0.17649999260902404785
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
		difference
		{
			cylinder
			{
				<0,0,0>,<0,1,0>,2			}
			cylinder
			{
				<0,0,0>,<0,1,0>,1			}
		}
	}
}

#declare LDX_3878_dot_dat =
#if (LDXQual = 0)
box {
	<-20,-16,-20>,<20,5,20>
}
#else
union {
// Minifig Top Hat
// Name: 3878.dat
// Author: Chris Dee [cwdee]
// !LDRAW_ORG Part UPDATE 2012-03
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CCW
// !CATEGORY Minifig Headwear
// !HISTORY 2000-09-30 [PTadmin] Official Update 2000-02
// !HISTORY 2007-06-30 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
// !HISTORY 2012-03-11 [Steffen] BFCed
// !HISTORY 2012-03-15 [Philo] Used more primitives
// !HISTORY 2012-03-30 [PTadmin] Official Update 2012-01
// !HISTORY 2012-12-24 [cwdee] Add category
// !HISTORY 2012-12-28 [PTadmin] Official Update 2012-03
	object {
		LDX_4_dash_4ring8_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,-1,0,0,0>
	}
	#if (LDXStuds)
		object {
			LDX_stud4o_dot_dat_in_part
			matrix <1,0,0,0,-3.5,0,0,0,1,0,-14,0>
		}
	#end // LDXStuds
	object {
		LDX_4_dash_4cylo_dot_dat_in_part
		matrix <9,0,0,0,14,0,0,0,9,0,-14,0>
	}
// BFC INVERTNEXT
	object {
		LDX_4_dash_4cylo_dot_dat_in_part
		matrix <11.05,0,0,0,15,0,0,0,11.05,0,-14,0>
	}
	object {
		LDX_4_dash_4ring4_dot_dat_in_part
		matrix <2.21,0,0,0,-1,0,0,0,-2.21,0,-14,0>
	}
// BFC INVERTNEXT
	object {
		LDX_4_dash_4cyli_dot_dat_in_part
		matrix <13,0,0,0,1,0,0,0,13,0,4,0>
	}
	object {
		LDX_4_dash_4cylc_dot_dat_in_part
		matrix <14,0,0,0,18,0,0,0,14,0,-16,0>
	}
	object {
		LDX_4_dash_4ring4_dot_dat_in_part
		matrix <3.5,0,0,0,1,0,0,0,3.5,0,2,0>
	}
	object {
		LDX_4_dash_4ring7_dot_dat_in_part
		matrix <2.5,0,0,0,1,0,0,0,2.5,0,2,0>
	}
	object {
		LDX_4_dash_4cylo_dot_dat_in_part
		matrix <20,0,0,0,3,0,0,0,20,0,2,0>
	}
	object {
		LDX_4_dash_4ring2_dot_dat_in_part
		matrix <6.5,0,0,0,-1,0,0,0,-6.5,0,5,0>
	}
	object {
		LDX_4_dash_4rin39_dot_dat_in_part
		matrix <0.5,0,0,0,-1,0,0,0,-0.5,0,5,0>
	}
// BFC INVERTNEXT
	object {
		LDX_t04o1765_dot_dat_in_part
		matrix <11.05,0,0,0,-22.6667,0,0,0,11.05,0,5,0>
	}
// BFC INVERTNEXT
	object {
		LDX_t04o1765_dot_dat_in_part
		matrix <0,0,11.05,0,-22.6667,0,-11.05,0,0,0,5,0>
	}
// BFC INVERTNEXT
	object {
		LDX_t04o1765_dot_dat_in_part
		matrix <0,0,-11.05,0,-22.6667,0,11.05,0,0,0,5,0>
	}
// BFC INVERTNEXT
	object {
		LDX_t04o1765_dot_dat_in_part
		matrix <-11.05,0,0,0,-22.6667,0,0,0,-11.05,0,5,0>
	}
}
#end

#declare LDX_pedestrian_011_manmayortophat_dot_ldr = union {
// Datsville Mayor
// Name: pedestrian_011_manmayortophat.ldr
// Author: Leonardo Zide
// Unofficial Datsville Model
// legs & hip
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		LDX_3817_dot_dat
		LDXSeamMatrix(18, 37, 20, 10.5, 9.5, -1)
		matrix <1,0,0,0,1,0,0,0,1,0,-28,1>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		LDX_3816_dot_dat
		LDXSeamMatrix(18, 37, 20, -10.5, 9.5, -1)
		matrix <1,0,0,0,1,0,0,0,1,0,-28,1>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		LDX_3815_dot_dat
		LDXSeamMatrix(36, 32.000195, 20, 0, 5.000097, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-40,1>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
// torso
	object {
		LDX_973p18_dot_dat
		LDXSeamMatrix(38, 44, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-72,1>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
// head
	object {
		LDX_3626bp03_dot_dat
		LDXSeamMatrix(26, 28, 26, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-96,1>
		#if (version >= 3.1) material #else texture #end { LDXColor14 }
	}
// hat
// 1 0 0 -96 0 1 0 0 0 1 0 0 0 1 3624.dat
// 1 0 0 -100 0 0.7 0 0 0 1 0 0 0 0.7 4740.dat
	object {
		LDX_3878_dot_dat
		matrix <0.7,0,0,0,1,0,0,0,0.7,0,-100,1>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
// Arms and Hands
	object {
		LDX_3819_dot_dat
		LDXSeamMatrix(17, 28.935999, 19.943001, 1.5, 7.967999, -3.4645)
		matrix <0.9855,-0.1699,0,0.1699,0.9855,0,0,0,1,15.552,-63,1>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		LDX_3820_dot_dat
		matrix <0.9855,-0.1699,0,0.1201,0.6968,0.7071,-0.1201,-0.6968,0.7071,23.690399,-45.2243,-8.9>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_3818_dot_dat
		matrix <0.9855,0.1699,0,-0.1699,0.9855,0,0,0,1,-15.552,-63,1>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		LDX_3820_dot_dat
		matrix <0.9855,0.1699,0,-0.1201,0.6968,0.7071,0.1201,-0.6968,0.7071,-23.690399,-45.2243,-8.9>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
}

#include "lg_3579.inc" // Door  1 x  3 x  4 Frame

#include "lg_7930.inc" // Door  1 x  3 x  4

#include "lg_0031cc01.inc" // Window  1 x  3 x  2 Classic with Short Sill (Complete)

#include "lg_4287.inc" // Slope Brick 33  3 x  1 Inverted

#include "lg_3001.inc" // Brick  2 x  4

#include "lg_3300.inc" // Slope Brick 33  2 x  2 Double

#include "lg_3710.inc" // Plate  1 x  4

#include "lg_3005.inc" // Brick  1 x  1

#include "lg_3004.inc" // Brick  1 x  2

#include "lg_3622.inc" // Brick  1 x  3

#include "lg_3937.inc" // Hinge  1 x  2 Base

#include "lg_3938.inc" // Hinge  1 x  2 Top

#include "lg_3021.inc" // Plate  2 x  3

#include "lg_6636.inc" // Tile  1 x  6

#include "lg_4286.inc" // Slope Brick 33  3 x  1

#include "lg_3003.inc" // Brick  2 x  2

#include "lg_3069b.inc" // Tile  1 x  2 with Groove

#declare LDX_building_002_thdoor_dot_ldr = union {
// Untitled
// Name: thdoor.dat
// Author: John VanZwieten
// Unofficial Datsville Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		lg_3579
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 100, 20, 0, 46, 0)
		matrix <1,0,0,0,1,0,0,0,1,-30,0,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3579
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 100, 20, 0, 46, 0)
		matrix <-1,0,0,0,1,0,0,0,1,30,0,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_7930
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 84, 8, 24, 42, -2)
		matrix <1,0,0,0,1,0,0,0,1,-54,4,-28>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_7930
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 84, 8, 24, 42, -2)
		matrix <-1,0,0,0,1,0,0,0,1,56,4,-28>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_0031cc01
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 52, 20, 0, 22, 0)
		matrix <1,0,0,0,1,0,0,0,1,30,-48,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_0031cc01
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 52, 20, 0, 22, 0)
		matrix <1,0,0,0,1,0,0,0,1,-30,-48,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4287
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,-1,0,1,0,1,0,0,70,-48,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4287_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,-1,0,1,0,1,0,0,70,-48,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_4287
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,1,0,1,0,-1,0,0,-70,-48,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4287_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,1,0,1,0,-1,0,0,-70,-48,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,0,-72,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3020
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 40, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-80,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-50,-56,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-50,-64,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,50,-56,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,50,-64,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,50,-72,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-50,-72,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3022
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 40, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-88,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3020
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 40, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,0,-96,-50>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3022
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 40, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,0,-104,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3300
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 14, 40, 0, 17, 0)
		matrix <0,0,-1,0,1,0,1,0,0,0,-128,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_3300_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 14, 40, 0, 17, 0)
		matrix <0,0,-1,0,1,0,1,0,0,0,-128,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor0_slope }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,70,-24,-50>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,70,-16,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,70,-8,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-70,-24,-50>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-70,-16,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-70,-8,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3005
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-70,0,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-70,24,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3005
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-70,48,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-70,72,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,70,72,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3005
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,70,48,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,70,24,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3005
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,70,0,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,90,0,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,90,48,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,90,-48,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-90,-48,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-90,0,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-90,48,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-90,48,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-120,72,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-120,24,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-120,-24,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-120,-72,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-70,-72,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,-96,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-40,-120,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,40,-120,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,40,-120,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,-96,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,120,72,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,120,24,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,120,-24,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,120,-72,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,70,-72,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,100,-48,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,100,0,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,100,48,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-100,48,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-100,0,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-100,-48,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,30,-88,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,30,-96,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-30,-88,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-30,-96,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3937
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 22, 20, 0, 13, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-70,-48,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3937
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 22, 20, 0, 13, 0)
		matrix <0,0,1,0,1,0,-1,0,0,70,-48,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3938
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 20, 20, 0, 6, 0)
		matrix <0,0,-1,-0.6,0.8,0,0.8,0.6,0,76.019997,-45.990002,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3938
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 20, 20, 0, 6, 0)
		matrix <0,0,-1,0.6,0.8,0,0.8,-0.6,0,-76.019997,-45.990002,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3021
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 12, 40, 0, 2, 0)
		matrix <0.8,-0.6,0,0.6,0.8,0,0,0,1,-44.07,-70.059998,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3021
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 12, 40, 0, 2, 0)
		matrix <0.8,0.6,0,-0.6,0.8,0,0,0,1,44.07,-70.059998,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3020
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 40, 0, 2, 0)
		matrix <0.8,0.6,0,-0.6,0.8,0,0,0,1,56.869999,-70.43,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_3020
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 40, 0, 2, 0)
		matrix <0.8,-0.6,0,0.6,0.8,0,0,0,1,-56.869999,-70.43,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
// STEP
	object {
		lg_3666
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,96,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor382 }
	}
	object {
		lg_3795
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 40, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,104,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor382 }
	}
	object {
		lg_6636
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 8, 20, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,96,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor382 }
	}
	object {
		lg_6636
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 8, 20, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,112,-60>
		#if (version >= 3.1) material #else texture #end { LDXColor382 }
	}
	object {
		lg_6636
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 8, 20, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,128,-80>
		#if (version >= 3.1) material #else texture #end { LDXColor382 }
	}
	object {
		lg_6636
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 8, 20, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,144,-100>
		#if (version >= 3.1) material #else texture #end { LDXColor382 }
	}
	object {
		lg_6636
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 8, 20, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,160,-120>
		#if (version >= 3.1) material #else texture #end { LDXColor382 }
	}
	object {
		lg_6636
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 8, 20, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,176,-140>
		#if (version >= 3.1) material #else texture #end { LDXColor382 }
	}
	object {
		lg_3666
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,112,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor382 }
	}
	object {
		lg_3666
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,128,-60>
		#if (version >= 3.1) material #else texture #end { LDXColor382 }
	}
	object {
		lg_3666
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,120,-60>
		#if (version >= 3.1) material #else texture #end { LDXColor382 }
	}
	object {
		lg_3795
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 40, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,136,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor382 }
	}
	object {
		lg_3666
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,144,-80>
		#if (version >= 3.1) material #else texture #end { LDXColor382 }
	}
	object {
		lg_3795
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 40, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,152,-90>
		#if (version >= 3.1) material #else texture #end { LDXColor382 }
	}
	object {
		lg_3666
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,160,-100>
		#if (version >= 3.1) material #else texture #end { LDXColor382 }
	}
	object {
		lg_3795
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 40, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,168,-110>
		#if (version >= 3.1) material #else texture #end { LDXColor382 }
	}
	object {
		lg_3666
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,176,-120>
		#if (version >= 3.1) material #else texture #end { LDXColor382 }
	}
	object {
		lg_3795
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 40, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,184,-130>
		#if (version >= 3.1) material #else texture #end { LDXColor382 }
	}
	object {
		lg_4286
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <1,0,0,0,1,0,0,0,1,70,96,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4286_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <1,0,0,0,1,0,0,0,1,70,96,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_4286
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <1,0,0,0,1,0,0,0,1,70,120,-80>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4286_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <1,0,0,0,1,0,0,0,1,70,120,-80>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_3003
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,144,-110>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3003
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,168,-110>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3069b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 20, 0, 4, 0)
		matrix <0,0,-1,0,1,0,1,0,0,90,136,-110>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3069b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 20, 0, 4, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-90,136,-110>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3003
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,168,-110>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3003
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,144,-110>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4286
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <1,0,0,0,1,0,0,0,1,-70,120,-80>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4286_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <1,0,0,0,1,0,0,0,1,-70,120,-80>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_4286
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <1,0,0,0,1,0,0,0,1,-70,96,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4286_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <1,0,0,0,1,0,0,0,1,-70,96,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_3005
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,70,120,-60>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,70,144,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,70,168,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-70,168,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-70,144,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3005
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-70,120,-60>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3003
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-100,96,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3003
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,100,96,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,120,120,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,40,120,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-40,120,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-120,120,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,144,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,144,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,144,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,120,168,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,40,168,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-40,168,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-120,168,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
}

#declare LDX_1_dash_8sphe_dot_dat_in_part = sphere // Sphere .125
{
	<0,0,0>,1
	clipped_by
	{
		box
		{
			<0,0,0>,<2,2,2>
		}
	}
}

#declare LDX_1_dash_8sphe_dot_dat = sphere // Sphere .125
{
	<0,0,0>,1
	clipped_by
	{
		box
		{
			<0,0,0>,<2,2,2>
		}
	}
}

#declare LDX_4_dash_8sphe_dot_dat_in_part = union {
// Sphere 0.5
// Name: 4-8sphe.dat
// Author: James Jessiman
// !LDRAW_ORG Primitive UPDATE 2003-02
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CCW
// !HISTORY 2002-08-31 [izanette] Modified with WINDZ for BFC compliance
// !HISTORY 2003-08-01 [PTadmin] Official Update 2003-02
// !HISTORY 2007-06-24 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
	object {
		LDX_1_dash_8sphe_dot_dat_in_part
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
	}
	object {
		LDX_1_dash_8sphe_dot_dat_in_part
		matrix <1,0,0,0,1,0,0,0,-1,0,0,0>
	}
	object {
		LDX_1_dash_8sphe_dot_dat_in_part
		matrix <-1,0,0,0,1,0,0,0,1,0,0,0>
	}
	object {
		LDX_1_dash_8sphe_dot_dat_in_part
		matrix <-1,0,0,0,1,0,0,0,-1,0,0,0>
	}
}

#declare LDX_2_dash_4ndis_dot_dat_in_part = disc // Not-Disc 0.5
{
	<0,0,0>,<0,1,0>,2,1
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		box
		{
			<-1,-1,-1>,<1,1,1>
		}
	}
}

#declare LDX_2_dash_4ndis_dot_dat = disc // Not-Disc 0.5
{
	<0,0,0>,<0,1,0>,2,1
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		box
		{
			<-1,-1,-1>,<1,1,1>
		}
	}
}

#declare LDX_4133_dot_dat =
#if (LDXQual = 0)
box {
	<-2.5,-3.074,-61.040001>,<2.5,57.074001,2.545>
}
#else
union {
// Window  2 x  4 x  3 Pane
// Name: 4133.dat
// Author: Willy Tschager [Holly-Wood]
// !LDRAW_ORG Part UPDATE 2009-02
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CCW
// !HISTORY 2007-08-25 {The LEGO Universe Team} Original part shape
// !HISTORY 2007-11-06 [Holly-Wood] File preparation for LDraw Parts Tracker
// !HISTORY 2007-11-07 [Philo] Adjusted size
// !HISTORY 2009-09-03 [PTadmin] Official Update 2009-02
	object {
		LDX_4_dash_8sphe_dot_dat_in_part
		matrix <2,0,0,0,-2.074,0,0,0,-2.035,0,-1,0>
	}
	object {
		LDX_4_dash_4ring4_dot_dat_in_part
		matrix <0.5,0,0,0,1.037,0,0,0,0.509,0,-1,0>
	}
	object {
		LDX_2_dash_4ndis_dot_dat_in_part
		matrix <2.5,0,0,0,1.037,0,0,0,-2.543,0,-1,0>
	}
	object {
		LDX_2_dash_4cyli_dot_dat_in_part
		matrix <2.5,0,0,0,56,0,0,0,2.543,0,-1,0>
	}
	object {
		LDX_4_dash_4ring4_dot_dat_in_part
		matrix <0.5,0,0,0,-1.037,0,0,0,0.509,0,55,0>
	}
	object {
		LDX_2_dash_4ndis_dot_dat_in_part
		matrix <-2.5,0,0,0,-1.037,0,0,0,-2.543,0,55,0>
	}
	object {
		LDX_4_dash_8sphe_dot_dat_in_part
		matrix <-2,0,0,0,2.074,0,0,0,-2.035,0,55,0>
	}
	mesh2 {
		vertex_vectors {
			108,
			<-2.5,-1,-61.040001>, <-2.5,-1,-2.54>, <-2.5,-1,0>, <-2.5,5.479251,-54.169876>,
			<-2.5,5.479251,-32.050125>, <-2.5,5.479251,-26.449875>, <-2.5,5.479251,-4.330126>, <-2.5,5.48,-54.18>,
			<-2.5,5.48,-32.049999>, <-2.5,5.48,-26.450001>, <-2.5,5.48,-4.32>, <-2.5,25.700001,-54.18>,
			<-2.5,25.700001,-32.049999>, <-2.5,25.700001,-26.450001>, <-2.5,25.700001,-4.32>, <-2.5,25.700748,-54.169876>,
			<-2.5,25.700748,-32.050125>, <-2.5,25.700748,-26.449875>, <-2.5,25.700748,-4.330126>, <-2.5,28.299252,-54.169876>,
			<-2.5,28.299252,-32.050125>, <-2.5,28.299252,-26.449875>, <-2.5,28.299252,-4.330126>, <-2.5,28.299999,-54.18>,
			<-2.5,28.299999,-32.049999>, <-2.5,28.299999,-26.450001>, <-2.5,28.299999,-4.32>, <-2.5,48.52,-54.18>,
			<-2.5,48.52,-32.049999>, <-2.5,48.52,-26.450001>, <-2.5,48.52,-4.32>, <-2.5,48.520748,-54.169876>,
			<-2.5,48.520748,-32.050125>, <-2.5,48.520748,-26.449875>, <-2.5,48.520748,-4.330126>, <-2.5,55,-61.040001>,
			<-2.5,55,-2.54>, <-2.5,55,0>, <-1.25,6.7755,-52.898624>, <-1.25,6.7755,-33.321377>,
			<-1.25,6.7755,-25.178625>, <-1.25,6.7755,-5.601376>, <-1.25,24.404499,-52.898624>, <-1.25,24.404499,-33.321377>,
			<-1.25,24.404499,-25.178625>, <-1.25,24.404499,-5.601376>, <-1.25,29.595501,-52.898624>, <-1.25,29.595501,-33.321377>,
			<-1.25,29.595501,-25.178625>, <-1.25,29.595501,-5.601376>, <-1.25,47.224499,-52.898624>, <-1.25,47.224499,-33.321377>,
			<-1.25,47.224499,-25.178625>, <-1.25,47.224499,-5.601376>, <1.25,6.7755,-52.898624>, <1.25,6.7755,-33.321377>,
			<1.25,6.7755,-25.178625>, <1.25,6.7755,-5.601376>, <1.25,24.404499,-52.898624>, <1.25,24.404499,-33.321377>,
			<1.25,24.404499,-25.178625>, <1.25,24.404499,-5.601376>, <1.25,29.595501,-52.898624>, <1.25,29.595501,-33.321377>,
			<1.25,29.595501,-25.178625>, <1.25,29.595501,-5.601376>, <1.25,47.224499,-52.898624>, <1.25,47.224499,-33.321377>,
			<1.25,47.224499,-25.178625>, <1.25,47.224499,-5.601376>, <2.5,-1,-61.040001>, <2.5,-1,-2.54>,
			<2.5,-1,0>, <2.5,5.479251,-54.169876>, <2.5,5.479251,-32.050125>, <2.5,5.479251,-26.449875>,
			<2.5,5.479251,-4.330126>, <2.5,5.48,-54.18>, <2.5,5.48,-32.049999>, <2.5,5.48,-26.450001>,
			<2.5,5.48,-4.32>, <2.5,25.700001,-54.18>, <2.5,25.700001,-32.049999>, <2.5,25.700001,-26.450001>,
			<2.5,25.700001,-4.32>, <2.5,25.700748,-54.169876>, <2.5,25.700748,-32.050125>, <2.5,25.700748,-26.449875>,
			<2.5,25.700748,-4.330126>, <2.5,28.299252,-54.169876>, <2.5,28.299252,-32.050125>, <2.5,28.299252,-26.449875>,
			<2.5,28.299252,-4.330126>, <2.5,28.299999,-54.18>, <2.5,28.299999,-32.049999>, <2.5,28.299999,-26.450001>,
			<2.5,28.299999,-4.32>, <2.5,48.52,-54.18>, <2.5,48.52,-32.049999>, <2.5,48.52,-26.450001>,
			<2.5,48.52,-4.32>, <2.5,48.520748,-54.169876>, <2.5,48.520748,-32.050125>, <2.5,48.520748,-26.449875>,
			<2.5,48.520748,-4.330126>, <2.5,55,-61.040001>, <2.5,55,-2.54>, <2.5,55,0>
		}
		normal_vectors {
			14,
			<-1,0,0>, <-0.719832,-0.694149,0>, <-0.719832,0.694149,0>, <-0.713041,0,-0.701122>,
			<-0.713041,0,0.701122>, <0,-1,0>, <0,0,-1>, <0,0,1>,
			<0,1,0>, <0.713041,0,-0.701122>, <0.713041,0,0.701122>, <0.719832,-0.694149,0>,
			<0.719832,0.694149,0>, <1,0,0>
		}
		face_indices {
			154,
			<0, 35, 105>, <0, 105, 70>, <35, 36, 106>, <35, 106, 105>,
			<70, 71, 1>, <70, 1, 0>, <72, 84, 96>, <72, 96, 107>,
			<72, 80, 84>, <79, 80, 72>, <78, 79, 72>, <78, 72, 70>,
			<70, 77, 78>, <81, 77, 70>, <105, 93, 81>, <105, 81, 70>,
			<105, 97, 93>, <98, 97, 105>, <105, 107, 99>, <105, 99, 98>,
			<107, 100, 99>, <96, 100, 107>, <37, 26, 14>, <37, 14, 2>,
			<14, 10, 2>, <2, 10, 9>, <0, 2, 9>, <0, 9, 8>,
			<8, 7, 0>, <0, 7, 11>, <0, 11, 23>, <0, 23, 35>,
			<23, 27, 35>, <35, 27, 28>, <28, 29, 37>, <28, 37, 35>,
			<29, 30, 37>, <37, 30, 26>, <84, 83, 95>, <84, 95, 96>,
			<83, 79, 78>, <83, 78, 82>, <83, 82, 94>, <83, 94, 95>,
			<98, 99, 95>, <98, 95, 94>, <82, 81, 93>, <82, 93, 94>,
			<14, 26, 25>, <14, 25, 13>, <13, 12, 8>, <13, 8, 9>,
			<25, 24, 12>, <25, 12, 13>, <28, 24, 25>, <28, 25, 29>,
			<24, 23, 11>, <24, 11, 12>, <57, 76, 75>, <57, 75, 56>,
			<56, 75, 87>, <56, 87, 60>, <60, 87, 88>, <60, 88, 61>,
			<61, 88, 76>, <61, 76, 57>, <44, 45, 18>, <44, 18, 17>,
			<41, 6, 18>, <41, 18, 45>, <40, 5, 6>, <40, 6, 41>,
			<5, 40, 44>, <5, 44, 17>, <41, 57, 61>, <41, 61, 45>,
			<40, 56, 57>, <40, 57, 41>, <44, 60, 56>, <44, 56, 40>,
			<45, 61, 60>, <45, 60, 44>, <55, 74, 73>, <55, 73, 54>,
			<54, 73, 85>, <54, 85, 58>, <58, 85, 86>, <58, 86, 59>,
			<59, 86, 74>, <59, 74, 55>, <42, 43, 16>, <42, 16, 15>,
			<39, 4, 16>, <39, 16, 43>, <38, 3, 4>, <38, 4, 39>,
			<3, 38, 42>, <3, 42, 15>, <39, 55, 59>, <39, 59, 43>,
			<38, 54, 55>, <38, 55, 39>, <42, 58, 54>, <42, 54, 38>,
			<43, 59, 58>, <43, 58, 42>, <63, 90, 89>, <63, 89, 62>,
			<62, 89, 101>, <62, 101, 66>, <66, 101, 102>, <66, 102, 67>,
			<67, 102, 90>, <67, 90, 63>, <50, 51, 32>, <50, 32, 31>,
			<47, 20, 32>, <47, 32, 51>, <46, 19, 20>, <46, 20, 47>,
			<19, 46, 50>, <19, 50, 31>, <47, 63, 67>, <47, 67, 51>,
			<46, 62, 63>, <46, 63, 47>, <50, 66, 62>, <50, 62, 46>,
			<51, 67, 66>, <51, 66, 50>, <65, 92, 91>, <65, 91, 64>,
			<64, 91, 103>, <64, 103, 68>, <68, 103, 104>, <68, 104, 69>,
			<69, 104, 92>, <69, 92, 65>, <52, 53, 34>, <52, 34, 33>,
			<49, 22, 34>, <49, 34, 53>, <48, 21, 22>, <48, 22, 49>,
			<21, 48, 52>, <21, 52, 33>, <49, 65, 69>, <49, 69, 53>,
			<48, 64, 65>, <48, 65, 49>, <52, 68, 64>, <52, 64, 48>,
			<53, 69, 68>, <53, 68, 52>
		}
		normal_indices {
			154,
			<7, 7, 7>, <7, 7, 7>, <5, 5, 5>, <5, 5, 5>,
			<8, 8, 8>, <8, 8, 8>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <13, 13, 13>, <13, 13, 13>,
			<13, 13, 13>, <13, 13, 13>, <13, 13, 13>, <13, 13, 13>,
			<13, 13, 13>, <13, 13, 13>, <13, 13, 13>, <13, 13, 13>,
			<13, 13, 13>, <13, 13, 13>, <13, 13, 13>, <13, 13, 13>,
			<13, 13, 13>, <13, 13, 13>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<13, 13, 13>, <13, 13, 13>, <13, 13, 13>, <13, 13, 13>,
			<13, 13, 13>, <13, 13, 13>, <13, 13, 13>, <13, 13, 13>,
			<13, 13, 13>, <13, 13, 13>, <1, 1, 1>, <1, 1, 1>,
			<3, 3, 3>, <3, 3, 3>, <2, 2, 2>, <2, 2, 2>,
			<4, 4, 4>, <4, 4, 4>, <12, 12, 12>, <12, 12, 12>,
			<10, 10, 10>, <10, 10, 10>, <11, 11, 11>, <11, 11, 11>,
			<9, 9, 9>, <9, 9, 9>, <6, 6, 6>, <6, 6, 6>,
			<8, 8, 8>, <8, 8, 8>, <7, 7, 7>, <7, 7, 7>,
			<5, 5, 5>, <5, 5, 5>, <1, 1, 1>, <1, 1, 1>,
			<3, 3, 3>, <3, 3, 3>, <2, 2, 2>, <2, 2, 2>,
			<4, 4, 4>, <4, 4, 4>, <12, 12, 12>, <12, 12, 12>,
			<10, 10, 10>, <10, 10, 10>, <11, 11, 11>, <11, 11, 11>,
			<9, 9, 9>, <9, 9, 9>, <6, 6, 6>, <6, 6, 6>,
			<8, 8, 8>, <8, 8, 8>, <7, 7, 7>, <7, 7, 7>,
			<5, 5, 5>, <5, 5, 5>, <1, 1, 1>, <1, 1, 1>,
			<3, 3, 3>, <3, 3, 3>, <2, 2, 2>, <2, 2, 2>,
			<4, 4, 4>, <4, 4, 4>, <12, 12, 12>, <12, 12, 12>,
			<10, 10, 10>, <10, 10, 10>, <11, 11, 11>, <11, 11, 11>,
			<9, 9, 9>, <9, 9, 9>, <6, 6, 6>, <6, 6, 6>,
			<8, 8, 8>, <8, 8, 8>, <7, 7, 7>, <7, 7, 7>,
			<5, 5, 5>, <5, 5, 5>, <1, 1, 1>, <1, 1, 1>,
			<3, 3, 3>, <3, 3, 3>, <2, 2, 2>, <2, 2, 2>,
			<4, 4, 4>, <4, 4, 4>, <12, 12, 12>, <12, 12, 12>,
			<10, 10, 10>, <10, 10, 10>, <11, 11, 11>, <11, 11, 11>,
			<9, 9, 9>, <9, 9, 9>, <6, 6, 6>, <6, 6, 6>,
			<8, 8, 8>, <8, 8, 8>, <7, 7, 7>, <7, 7, 7>,
			<5, 5, 5>, <5, 5, 5>
		}
	}
}
#end

#include "lg_3455.inc" // Arch  1 x  6

#include "lg_32028.inc" // Plate  1 x  2 with Door Rail

#include "lg_4070.inc" // Brick  1 x  1 with Headlight

#include "lg_3665.inc" // Slope Brick 45  2 x  1 Inverted

#include "lg_3008.inc" // Brick  1 x  8

#declare LDX_building_002_thwind1_dot_ldr = union {
// Untitled
// Name: thwind1.dat
// Author: John VanZwieten
// Unofficial Datsville Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		LDX_4133_dot_dat
		LDXSeamMatrix(5, 60.148003, 63.584999, 0, 27, -29.247501)
		matrix <0,0,1,0,1,0,-1,0,0,-30.5,-143,5>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_4133_dot_dat
		LDXSeamMatrix(5, 60.148003, 63.584999, 0, 27, -29.247501)
		matrix <0,0,-1,0,1,0,1,0,0,30.5,-87,5>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3455
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-168,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_32028
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 29, 0, 2, -4.5)
		matrix <0,1,0,-1,0,0,0,0,1,-28,-128,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_32028
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 29, 0, 2, -4.5)
		matrix <0,1,0,-1,0,0,0,0,1,-28,-88,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_32028
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 29, 0, 2, -4.5)
		matrix <0,1,0,-1,0,0,0,0,1,-28,-48,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3666
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 20, 0, 2, 0)
		matrix <0,1,0,-1,0,0,0,0,1,-36,-88,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_32028
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 29, 0, 2, -4.5)
		matrix <0,-1,0,1,0,0,0,0,1,28,-128,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_32028
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 29, 0, 2, -4.5)
		matrix <0,-1,0,1,0,0,0,0,1,28,-88,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_32028
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 29, 0, 2, -4.5)
		matrix <0,-1,0,1,0,0,0,0,1,28,-48,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3666
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 20, 0, 2, 0)
		matrix <0,-1,0,1,0,0,0,0,1,36,-88,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4070
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,50,-48,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4070
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <0,0,1,0,1,0,-1,0,0,-50,-48,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3455
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-168,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4286
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,-1,0,1,0,1,0,0,-10,-192,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4286_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,-1,0,1,0,1,0,0,-10,-192,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_4286
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,1,0,1,0,-1,0,0,10,-192,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4286_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,1,0,1,0,-1,0,0,10,-192,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_3300
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 14, 40, 0, 17, 0)
		matrix <0,0,-1,0,1,0,1,0,0,0,-216,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3300_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 14, 40, 0, 17, 0)
		matrix <0,0,-1,0,1,0,1,0,0,0,-216,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,50,-144,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3665
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,50,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3665_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,50,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-50,-144,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3665
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,-50,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3665_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,-50,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-60,-96,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,-96,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,-48,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,40,0,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-40,0,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,24,10>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,24,10>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,24,10>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-40,48,10>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,40,48,10>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,72,10>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,72,10>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,72,10>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-60,-48,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3069b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 20, 0, 4, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-30,-32,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3069b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 20, 0, 4, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-10,-32,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3069b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 20, 0, 4, 0)
		matrix <0,0,-1,0,1,0,1,0,0,10,-32,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3069b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 20, 0, 4, 0)
		matrix <0,0,-1,0,1,0,1,0,0,30,-32,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-16,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-8,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		LDX_3794a_dot_dat
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-30,-24,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		LDX_3794a_dot_dat
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-10,-24,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		LDX_3794a_dot_dat
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,10,-24,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		LDX_3794a_dot_dat
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,30,-24,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,-72,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,-72,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,-24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,-24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-90,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,90,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3005
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,70,-144,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3005
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-70,-144,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,90,-168,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,40,-192,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-40,-192,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-90,-168,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-216,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,-216,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,-216,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3008
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-168,20>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
}

#include "lg_4510.inc" // Plate  1 x  8 with Door Rail

#include "lg_3460.inc" // Plate  1 x  8

#declare LDX_building_002_thwind2_dot_ldr = union {
// Untitled
// Name: thwind1.dat
// Author: John VanZwieten
// Unofficial Datsville Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		LDX_4133_dot_dat
		LDXSeamMatrix(5, 60.148003, 63.584999, 0, 27, -29.247501)
		matrix <0,0,1,0,1,0,-1,0,0,-30.5,-149,5>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_4133_dot_dat
		LDXSeamMatrix(5, 60.148003, 63.584999, 0, 27, -29.247501)
		matrix <0,0,1,0,1,0,-1,0,0,-30.5,-39,5>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_4133_dot_dat
		LDXSeamMatrix(5, 60.148003, 63.584999, 0, 27, -29.247501)
		matrix <0,0,-1,0,1,0,1,0,0,30.5,-94,5>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3455
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-168,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4510
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 29, 0, 2, -4.5)
		matrix <0,1,0,-1,0,0,0,0,1,-28,-68,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3460
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 20, 0, 2, 0)
		matrix <0,1,0,-1,0,0,0,0,1,-36,-68,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4510
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 29, 0, 2, -4.5)
		matrix <0,-1,0,1,0,0,0,0,1,28,-68,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3460
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 20, 0, 2, 0)
		matrix <0,-1,0,1,0,0,0,0,1,36,-68,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4070
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,50,-8,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4070
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <0,0,1,0,1,0,-1,0,0,-50,-8,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3455
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-168,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4286
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,-1,0,1,0,1,0,0,-10,-192,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4286_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,-1,0,1,0,1,0,0,-10,-192,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_4286
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,1,0,1,0,-1,0,0,10,-192,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4286_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,1,0,1,0,-1,0,0,10,-192,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_3300
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 14, 40, 0, 17, 0)
		matrix <0,0,-1,0,1,0,1,0,0,0,-216,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3300_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 14, 40, 0, 17, 0)
		matrix <0,0,-1,0,1,0,1,0,0,0,-216,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,50,-144,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3665
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,50,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3665_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,50,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-50,-144,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3665
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,-50,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3665_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,-50,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-60,-96,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,-96,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,-48,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,0,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,40,48,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-60,0,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-40,48,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-60,-48,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-60,-48,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3069b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 20, 0, 4, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-30,16,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3069b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 20, 0, 4, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-10,16,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3069b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 20, 0, 4, 0)
		matrix <0,0,-1,0,1,0,1,0,0,10,16,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3069b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 20, 0, 4, 0)
		matrix <0,0,-1,0,1,0,1,0,0,30,16,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,32,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,40,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		LDX_3794a_dot_dat
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-30,24,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		LDX_3794a_dot_dat
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-10,24,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		LDX_3794a_dot_dat
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,10,24,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		LDX_3794a_dot_dat
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,30,24,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,-72,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,-72,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,-24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,-24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-90,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,90,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,70,-128,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,70,-136,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,70,-144,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-70,-128,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-70,-136,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-70,-144,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,90,-168,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,40,-192,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-40,-192,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-90,-168,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-216,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,-216,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,-216,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3008
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-168,20>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
}

#include "lg_3623.inc" // Plate  1 x  3

#declare LDX_building_002_thwind3_dot_ldr = union {
// Untitled
// Name: building_002_thwind3.ldr
// Author: John VanZwieten
// Unofficial Datsville Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		LDX_4133_dot_dat
		LDXSeamMatrix(5, 60.148003, 63.584999, 0, 27, -29.247501)
		matrix <0,0,1,0,1,0,-1,0,0,-30.5,-221,-5>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_4133_dot_dat
		LDXSeamMatrix(5, 60.148003, 63.584999, 0, 27, -29.247501)
		matrix <0,0,1,0,1,0,-1,0,0,-30.5,-111,-5>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_4133_dot_dat
		LDXSeamMatrix(5, 60.148003, 63.584999, 0, 27, -29.247501)
		matrix <0,0,-1,0,1,0,1,0,0,30.5,-166,-5>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3455
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-240,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4510
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 29, 0, 2, -4.5)
		matrix <0,1,0,-1,0,0,0,0,1,-28,-140,9>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3460
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 20, 0, 2, 0)
		matrix <0,1,0,-1,0,0,0,0,1,-36,-140,9>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4510
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 29, 0, 2, -4.5)
		matrix <0,-1,0,1,0,0,0,0,1,28,-140,9>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3460
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 20, 0, 2, 0)
		matrix <0,-1,0,1,0,0,0,0,1,36,-140,9>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4070
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,50,-80,9>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4070
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <0,0,1,0,1,0,-1,0,0,-50,-80,9>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3455
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-240,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4286
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,-1,0,1,0,1,0,0,-10,-264,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4286_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,-1,0,1,0,1,0,0,-10,-264,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_4286
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,1,0,1,0,-1,0,0,10,-264,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4286_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,1,0,1,0,-1,0,0,10,-264,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_3300
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 14, 40, 0, 17, 0)
		matrix <0,0,-1,0,1,0,1,0,0,0,-288,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3300_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 14, 40, 0, 17, 0)
		matrix <0,0,-1,0,1,0,1,0,0,0,-288,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,50,-216,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3665
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,50,-192,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3665_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,50,-192,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-50,-216,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3665
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,-50,-192,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3665_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,-50,-192,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-60,-144,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,-144,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,-96,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,-48,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,-24,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-24,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,-24,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-60,-96,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-60,-48,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3069b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 20, 0, 4, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-30,-56,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3069b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 20, 0, 4, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-10,-56,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3069b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 20, 0, 4, 0)
		matrix <0,0,-1,0,1,0,1,0,0,10,-56,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3069b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 20, 0, 4, 0)
		matrix <0,0,-1,0,1,0,1,0,0,30,-56,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-40,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-32,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		LDX_3794a_dot_dat
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-30,-48,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		LDX_3794a_dot_dat
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-10,-48,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		LDX_3794a_dot_dat
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,10,-48,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		LDX_3794a_dot_dat
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,30,-48,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,-168,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,-168,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,-120,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,-72,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,-72,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,-120,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3005
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-70,-192,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3005
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,70,-192,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3623
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,90,-200,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3623
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-90,-200,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3623
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,90,-208,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3623
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-90,-208,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3623
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,90,-216,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3623
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-90,-216,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3005
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-70,-240,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3005
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,70,-240,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,-264,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,-264,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-264,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,40,-288,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-40,-288,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3008
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-240,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
}

#include "lg_2357.inc" // Brick  2 x  2 Corner

#declare LDX_building_002_thcorn_dot_ldr = union {
// Untitled
// Name: thcorn.dat
// Author: John VanZwieten
// Unofficial Datsville Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		lg_2357
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, 10)
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
	}
	object {
		lg_3005
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,24,0>
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,40,24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,0,24,40>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
}

#include "lg_0702.inc" // Brick  4 x  4 Corner

#declare LDX_building_002_thall2_dot_ldr = union {
// Untitled
// Name: thall2.dat
// Author: John VanZwieten
// Unofficial Datsville Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		LDX_building_002_thcorn_dot_ldr
		matrix <1,0,0,0,1,0,0,0,1,-330,96,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3003
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-320,144,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_0702
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 80, 20, 10, 20)
		matrix <1,0,0,0,1,0,0,0,1,-320,168,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3003
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-320,192,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		LDX_building_002_thcorn_dot_ldr
		matrix <1,0,0,0,1,0,0,0,1,-330,48,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		LDX_building_002_thcorn_dot_ldr
		matrix <1,0,0,0,1,0,0,0,1,-330,0,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		LDX_building_002_thcorn_dot_ldr
		matrix <1,0,0,0,1,0,0,0,1,-330,-48,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		LDX_building_002_thcorn_dot_ldr
		matrix <1,0,0,0,1,0,0,0,1,-330,-96,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		LDX_building_002_thcorn_dot_ldr
		matrix <1,0,0,0,1,0,0,0,1,-330,-144,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		LDX_building_002_thcorn_dot_ldr
		matrix <1,0,0,0,1,0,0,0,1,-330,-192,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		LDX_building_002_thcorn_dot_ldr
		matrix <1,0,0,0,1,0,0,0,1,-330,-240,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		LDX_building_002_thcorn_dot_ldr
		matrix <1,0,0,0,1,0,0,0,1,-330,-288,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-330,-296,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3623
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-290,-296,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3623
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-290,-312,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3623
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-296,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3623
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-312,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3623
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-304,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-300,-304,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-330,-312,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_2357
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, 10)
		matrix <1,0,0,0,1,0,0,0,1,-330,-336,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		LDX_building_002_thcorn_dot_ldr
		matrix <1,0,0,0,1,0,0,0,1,-330,-384,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
}

#declare LDX_building_002_thcorn_dot_ldr_mirror = union {
// Untitled
// Name: thcorn.dat
// Author: John VanZwieten
// Unofficial Datsville Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		lg_2357
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, 10)
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
	}
	object {
		lg_3005
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,24,0>
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,40,24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,0,24,40>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
}

#declare LDX_building_002_thall2_dot_ldr_mirror = union {
// Untitled
// Name: thall2.dat
// Author: John VanZwieten
// Unofficial Datsville Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		LDX_building_002_thcorn_dot_ldr_mirror
		matrix <1,0,0,0,1,0,0,0,1,-330,96,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3003
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-320,144,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_0702
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 80, 20, 10, 20)
		matrix <1,0,0,0,1,0,0,0,1,-320,168,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3003
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-320,192,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		LDX_building_002_thcorn_dot_ldr_mirror
		matrix <1,0,0,0,1,0,0,0,1,-330,48,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		LDX_building_002_thcorn_dot_ldr_mirror
		matrix <1,0,0,0,1,0,0,0,1,-330,0,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		LDX_building_002_thcorn_dot_ldr_mirror
		matrix <1,0,0,0,1,0,0,0,1,-330,-48,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		LDX_building_002_thcorn_dot_ldr_mirror
		matrix <1,0,0,0,1,0,0,0,1,-330,-96,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		LDX_building_002_thcorn_dot_ldr_mirror
		matrix <1,0,0,0,1,0,0,0,1,-330,-144,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		LDX_building_002_thcorn_dot_ldr_mirror
		matrix <1,0,0,0,1,0,0,0,1,-330,-192,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		LDX_building_002_thcorn_dot_ldr_mirror
		matrix <1,0,0,0,1,0,0,0,1,-330,-240,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		LDX_building_002_thcorn_dot_ldr_mirror
		matrix <1,0,0,0,1,0,0,0,1,-330,-288,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-330,-296,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3623
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-290,-296,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3623
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-290,-312,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3623
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-296,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3623
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-312,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3623
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-304,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-300,-304,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-330,-312,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_2357
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, 10)
		matrix <1,0,0,0,1,0,0,0,1,-330,-336,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		LDX_building_002_thcorn_dot_ldr_mirror
		matrix <1,0,0,0,1,0,0,0,1,-330,-384,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
}

#declare LDX_building_002_thall6_dot_ldr = union {
// Untitled
// Name: thall6.dat
// Author: John VanZwieten
// Unofficial Datsville Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		LDX_building_002_thdoor_dot_ldr
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
	}
	object {
		LDX_building_002_thwind1_dot_ldr
		matrix <1,0,0,0,1,0,0,0,1,-200,96,-40>
	}
	object {
		LDX_building_002_thwind1_dot_ldr
		matrix <1,0,0,0,1,0,0,0,1,200,96,-40>
	}
	object {
		LDX_building_002_thwind2_dot_ldr
		matrix <1,0,0,0,1,0,0,0,1,200,-192,-40>
	}
	object {
		LDX_building_002_thwind3_dot_ldr
		matrix <1,0,0,0,1,0,0,0,1,0,-120,-30>
	}
	object {
		LDX_building_002_thwind2_dot_ldr
		matrix <1,0,0,0,1,0,0,0,1,-200,-192,-40>
	}
	object {
		LDX_building_002_thall2_dot_ldr
		matrix <1,0,0,0,1,0,0,0,1,-20,-24,0>
	}
	object {
		LDX_building_002_thall2_dot_ldr_mirror
		matrix <-1,0,0,0,1,0,0,0,1,20,-24,0>
	}
}

#declare LDX_building_002_thall1_dot_ldr = union {
// Untitled
// Name: thall1.dat
// Author: John VanZwieten
// Unofficial Datsville Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		LDX_building_002_thwind1_dot_ldr
		matrix <0,0,-1,0,1,0,1,0,0,-330,96,90>
	}
	object {
		LDX_building_002_thwind1_dot_ldr
		matrix <0,0,-1,0,1,0,1,0,0,-330,96,330>
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-320,96,210>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-320,144,210>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-320,144,450>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-320,96,450>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,48,210>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,48,450>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,0,450>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-48,450>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-96,450>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,0,210>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-48,210>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-96,210>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		LDX_building_002_thwind1_dot_ldr
		matrix <0,0,-1,0,1,0,1,0,0,-330,96,570>
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-320,96,690>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-320,144,690>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,48,690>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,0,690>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-48,690>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-96,690>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		LDX_building_002_thwind1_dot_ldr
		matrix <0,0,-1,0,1,0,1,0,0,-330,96,810>
	}
	object {
		LDX_building_002_thwind2_dot_ldr
		matrix <0,0,-1,0,1,0,1,0,0,-330,-192,810>
	}
	object {
		LDX_building_002_thwind2_dot_ldr
		matrix <0,0,-1,0,1,0,1,0,0,-330,-192,570>
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-144,690>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-192,690>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-240,690>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-288,690>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-384,690>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-384,450>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-288,450>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-240,450>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-192,450>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-144,450>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-320,690>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-328,690>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-336,690>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-320,450>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-328,450>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-336,450>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		LDX_building_002_thwind2_dot_ldr
		matrix <0,0,-1,0,1,0,1,0,0,-330,-192,330>
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-144,210>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-192,210>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-240,210>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-288,210>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-384,210>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-320,210>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-328,210>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-336,210>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		LDX_building_002_thwind2_dot_ldr
		matrix <0,0,-1,0,1,0,1,0,0,-330,-192,90>
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-432,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-432,910>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-432,850>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-432,770>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-432,690>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-432,610>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-432,530>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-432,450>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-432,370>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-432,290>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-432,210>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-432,130>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-432,50>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-456,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-456,90>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-456,170>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-456,250>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-456,330>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-456,410>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-456,490>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-456,570>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-456,650>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-456,730>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-456,810>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-456,890>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
}

#declare LDX_building_002_thwind1_dot_ldr_mirror = union {
// Untitled
// Name: thwind1.dat
// Author: John VanZwieten
// Unofficial Datsville Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		LDX_4133_dot_dat
		LDXSeamMatrix(5, 60.148003, 63.584999, 0, 27, -29.247501)
		matrix <0,0,1,0,1,0,-1,0,0,-30.5,-143,5>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_4133_dot_dat
		LDXSeamMatrix(5, 60.148003, 63.584999, 0, 27, -29.247501)
		matrix <0,0,-1,0,1,0,1,0,0,30.5,-87,5>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3455
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-168,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_32028
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 29, 0, 2, -4.5)
		matrix <0,1,0,-1,0,0,0,0,1,-28,-128,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_32028
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 29, 0, 2, -4.5)
		matrix <0,1,0,-1,0,0,0,0,1,-28,-88,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_32028
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 29, 0, 2, -4.5)
		matrix <0,1,0,-1,0,0,0,0,1,-28,-48,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3666
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 20, 0, 2, 0)
		matrix <0,1,0,-1,0,0,0,0,1,-36,-88,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_32028
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 29, 0, 2, -4.5)
		matrix <0,-1,0,1,0,0,0,0,1,28,-128,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_32028
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 29, 0, 2, -4.5)
		matrix <0,-1,0,1,0,0,0,0,1,28,-88,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_32028
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 29, 0, 2, -4.5)
		matrix <0,-1,0,1,0,0,0,0,1,28,-48,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3666
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 20, 0, 2, 0)
		matrix <0,-1,0,1,0,0,0,0,1,36,-88,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4070
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,50,-48,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4070
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <0,0,1,0,1,0,-1,0,0,-50,-48,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3455
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-168,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4286
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,-1,0,1,0,1,0,0,-10,-192,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4286_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,-1,0,1,0,1,0,0,-10,-192,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_4286
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,1,0,1,0,-1,0,0,10,-192,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4286_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,1,0,1,0,-1,0,0,10,-192,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_3300
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 14, 40, 0, 17, 0)
		matrix <0,0,-1,0,1,0,1,0,0,0,-216,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3300_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 14, 40, 0, 17, 0)
		matrix <0,0,-1,0,1,0,1,0,0,0,-216,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,50,-144,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3665
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,50,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3665_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,50,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-50,-144,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3665
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,-50,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3665_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,-50,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-60,-96,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,-96,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,-48,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,40,0,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-40,0,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,24,10>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,24,10>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,24,10>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-40,48,10>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,40,48,10>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,72,10>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,72,10>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,72,10>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-60,-48,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3069b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 20, 0, 4, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-30,-32,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3069b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 20, 0, 4, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-10,-32,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3069b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 20, 0, 4, 0)
		matrix <0,0,-1,0,1,0,1,0,0,10,-32,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3069b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 20, 0, 4, 0)
		matrix <0,0,-1,0,1,0,1,0,0,30,-32,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-16,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-8,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		LDX_3794a_dot_dat
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-30,-24,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		LDX_3794a_dot_dat
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-10,-24,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		LDX_3794a_dot_dat
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,10,-24,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		LDX_3794a_dot_dat
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,30,-24,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,-72,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,-72,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,-24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,-24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-90,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,90,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3005
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,70,-144,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3005
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-70,-144,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,90,-168,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,40,-192,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-40,-192,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-90,-168,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-216,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,-216,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,-216,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3008
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-168,20>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
}

#declare LDX_building_002_thwind2_dot_ldr_mirror = union {
// Untitled
// Name: thwind1.dat
// Author: John VanZwieten
// Unofficial Datsville Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		LDX_4133_dot_dat
		LDXSeamMatrix(5, 60.148003, 63.584999, 0, 27, -29.247501)
		matrix <0,0,1,0,1,0,-1,0,0,-30.5,-149,5>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_4133_dot_dat
		LDXSeamMatrix(5, 60.148003, 63.584999, 0, 27, -29.247501)
		matrix <0,0,1,0,1,0,-1,0,0,-30.5,-39,5>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_4133_dot_dat
		LDXSeamMatrix(5, 60.148003, 63.584999, 0, 27, -29.247501)
		matrix <0,0,-1,0,1,0,1,0,0,30.5,-94,5>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3455
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-168,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4510
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 29, 0, 2, -4.5)
		matrix <0,1,0,-1,0,0,0,0,1,-28,-68,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3460
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 20, 0, 2, 0)
		matrix <0,1,0,-1,0,0,0,0,1,-36,-68,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4510
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 29, 0, 2, -4.5)
		matrix <0,-1,0,1,0,0,0,0,1,28,-68,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3460
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 20, 0, 2, 0)
		matrix <0,-1,0,1,0,0,0,0,1,36,-68,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4070
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,50,-8,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4070
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <0,0,1,0,1,0,-1,0,0,-50,-8,19>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3455
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-168,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4286
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,-1,0,1,0,1,0,0,-10,-192,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4286_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,-1,0,1,0,1,0,0,-10,-192,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_4286
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,1,0,1,0,-1,0,0,10,-192,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4286_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,1,0,1,0,-1,0,0,10,-192,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_3300
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 14, 40, 0, 17, 0)
		matrix <0,0,-1,0,1,0,1,0,0,0,-216,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3300_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 14, 40, 0, 17, 0)
		matrix <0,0,-1,0,1,0,1,0,0,0,-216,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,50,-144,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3665
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,50,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3665_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,50,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-50,-144,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3665
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,-50,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3665_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,-50,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15_slope }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-60,-96,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,-96,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,-48,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,0,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,40,48,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-60,0,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-40,48,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-60,-48,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-60,-48,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3069b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 20, 0, 4, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-30,16,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3069b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 20, 0, 4, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-10,16,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3069b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 20, 0, 4, 0)
		matrix <0,0,-1,0,1,0,1,0,0,10,16,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3069b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 20, 0, 4, 0)
		matrix <0,0,-1,0,1,0,1,0,0,30,16,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,32,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,40,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		LDX_3794a_dot_dat
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-30,24,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		LDX_3794a_dot_dat
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-10,24,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		LDX_3794a_dot_dat
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,10,24,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		LDX_3794a_dot_dat
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,30,24,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,-72,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,-72,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,-24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,-24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-90,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,90,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,70,-128,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,70,-136,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,70,-144,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-70,-128,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-70,-136,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-70,-144,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,90,-168,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,40,-192,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-40,-192,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-90,-168,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-216,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,-216,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,-216,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3008
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-168,20>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
}

#declare LDX_building_002_thall1_dot_ldr_mirror = union {
// Untitled
// Name: thall1.dat
// Author: John VanZwieten
// Unofficial Datsville Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		LDX_building_002_thwind1_dot_ldr_mirror
		matrix <0,0,-1,0,1,0,1,0,0,-330,96,90>
	}
	object {
		LDX_building_002_thwind1_dot_ldr_mirror
		matrix <0,0,-1,0,1,0,1,0,0,-330,96,330>
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-320,96,210>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-320,144,210>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-320,144,450>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-320,96,450>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,48,210>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,48,450>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,0,450>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-48,450>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-96,450>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,0,210>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-48,210>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-96,210>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		LDX_building_002_thwind1_dot_ldr_mirror
		matrix <0,0,-1,0,1,0,1,0,0,-330,96,570>
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-320,96,690>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-320,144,690>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,48,690>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,0,690>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-48,690>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-96,690>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		LDX_building_002_thwind1_dot_ldr_mirror
		matrix <0,0,-1,0,1,0,1,0,0,-330,96,810>
	}
	object {
		LDX_building_002_thwind2_dot_ldr_mirror
		matrix <0,0,-1,0,1,0,1,0,0,-330,-192,810>
	}
	object {
		LDX_building_002_thwind2_dot_ldr_mirror
		matrix <0,0,-1,0,1,0,1,0,0,-330,-192,570>
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-144,690>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-192,690>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-240,690>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-288,690>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-384,690>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-384,450>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-288,450>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-240,450>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-192,450>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-144,450>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-320,690>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-328,690>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-336,690>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-320,450>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-328,450>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-336,450>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		LDX_building_002_thwind2_dot_ldr_mirror
		matrix <0,0,-1,0,1,0,1,0,0,-330,-192,330>
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-144,210>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-192,210>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-240,210>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-288,210>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-384,210>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-320,210>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-328,210>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-336,210>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		LDX_building_002_thwind2_dot_ldr_mirror
		matrix <0,0,-1,0,1,0,1,0,0,-330,-192,90>
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-432,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-432,910>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-432,850>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-432,770>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-432,690>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-432,610>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-432,530>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-432,450>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-432,370>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-432,290>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-432,210>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-432,130>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-432,50>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-456,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-456,90>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-456,170>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-456,250>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-456,330>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-456,410>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-456,490>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-456,570>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-456,650>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-456,730>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-456,810>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-330,-456,890>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
}

#include "lg_3857.inc" // Baseplate 16 x 32 with Square Corners

#include "lg_0029c.inc" // Window  1 x  1 x  2 Classic with Short Sill

#include "lg_6005.inc" // Arch  1 x  3 x  2 with Curved Top

#include "lg_2639.inc" // Plate  4 x  4 Corner

#include "lg_3029.inc" // Plate  4 x 12

#include "lg_2445.inc" // Plate  2 x 12

#include "lg_4477.inc" // Plate  1 x 10

#include "lg_4282.inc" // Plate  2 x 16

#include "lg_3832.inc" // Plate  2 x 10

#include "lg_3026.inc" // Plate  6 x 24

#include "lg_3027.inc" // Plate  6 x 16

#declare LDX_building_002_throof1_dot_ldr = union {
// Untitled
// Name: throof1.dat
// Author: John VanZwieten
// Unofficial Datsville Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		lg_3938
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 20, 20, 0, 6, 0)
		matrix <0,0,-1,0,1,0,1,0,0,0,-10,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4282
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(320, 12, 40, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-90,-20,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4282
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(320, 12, 40, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-90,-20,-60>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4282
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(320, 12, 40, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,50,-20,180>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3832
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(200, 12, 40, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,50,-20,440>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3026
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(480, 12, 120, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,30,-28,160>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_3026
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(480, 12, 120, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-90,-28,160>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_3027
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(320, 12, 120, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-70,-28,460>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_3029
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(240, 12, 80, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-190,-28,40>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_3029
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(240, 12, 80, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-190,-28,280>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_4477
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(200, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-240,-28,20>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_4477
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(200, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-240,-28,220>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_4477
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(200, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-240,-28,420>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
}

#declare LDX_building_002_thall3_dot_ldr = union {
// Untitled
// Name: thall3.dat
// Author: John VanZwieten
// Unofficial Datsville Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,0,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,40,-24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3005
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,110,0,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_0029c
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 52, 20, 0, 22, 0)
		matrix <1,0,0,0,1,0,0,0,1,90,-24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,130,-24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,160,0,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,240,0,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,200,-24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_6005
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 48, 60, 0, 24, -20)
		matrix <-1,0,0,0,1,0,0,0,-1,330,-24,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_6005
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 48, 60, 0, 24, -20)
		matrix <0,0,-1,0,1,0,1,0,0,390,-24,20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3005
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,350,0,0>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3005
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,350,-24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,300,0,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,280,-24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,330,-24,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,390,-24,20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_2639
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 80, 20, 2, 20)
		matrix <0,0,1,0,1,0,-1,0,0,140,-32,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,-40,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,-48,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,40,-72,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,-96,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,40,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,-144,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_0029c
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 52, 20, 0, 22, 0)
		matrix <1,0,0,0,1,0,0,0,1,90,-72,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_0029c
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 52, 20, 0, 22, 0)
		matrix <1,0,0,0,1,0,0,0,1,90,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3029
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(240, 12, 80, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,280,-32,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3029
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(240, 12, 80, 0, 2, 0)
		matrix <0,0,1,0,1,0,-1,0,0,360,-32,150>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3029
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(240, 12, 80, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,360,-32,390>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_2445
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(240, 12, 40, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,380,-40,110>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_2445
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(240, 12, 40, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,380,-40,350>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,380,-40,480>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4477
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(200, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,350,-40,90>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4477
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(200, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,350,-40,290>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,350,-40,430>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,350,-40,480>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3022
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 40, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,360,-48,10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3069b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 20, 0, 4, 0)
		matrix <0,0,-1,0,1,0,1,0,0,350,-56,10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_2445
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(240, 12, 40, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,220,-40,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_2445
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(240, 12, 40, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,220,-48,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,130,-72,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,200,-72,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,260,-72,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_4286
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,1,0,1,0,-1,0,0,290,-72,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_4286_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,1,0,1,0,-1,0,0,290,-72,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_4286
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,1,0,1,0,-1,0,0,230,-96,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_4286_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,1,0,1,0,-1,0,0,230,-96,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3005
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,210,-96,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3005
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,110,-96,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,160,-96,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,130,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_4286
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,1,0,1,0,-1,0,0,170,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_4286_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,1,0,1,0,-1,0,0,170,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_4286
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,1,0,1,0,-1,0,0,110,-144,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_4286_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,1,0,1,0,-1,0,0,110,-144,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3937
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 22, 20, 0, 13, 0)
		matrix <0,0,1,0,1,0,-1,0,0,330,-56,30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		LDX_building_002_throof1_dot_ldr
		matrix <0.93,0.36,0,-0.36,0.93,0,0,0,1,330,-46,30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
}

#declare LDX_building_002_throof1_dot_ldr_mirror = union {
// Untitled
// Name: throof1.dat
// Author: John VanZwieten
// Unofficial Datsville Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		lg_3938
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 20, 20, 0, 6, 0)
		matrix <0,0,-1,0,1,0,1,0,0,0,-10,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4282
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(320, 12, 40, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-90,-20,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4282
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(320, 12, 40, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-90,-20,-60>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4282
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(320, 12, 40, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,50,-20,180>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3832
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(200, 12, 40, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,50,-20,440>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3026
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(480, 12, 120, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,30,-28,160>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_3026
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(480, 12, 120, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-90,-28,160>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_3027
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(320, 12, 120, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-70,-28,460>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_3029
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(240, 12, 80, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-190,-28,40>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_3029
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(240, 12, 80, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-190,-28,280>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_4477
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(200, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-240,-28,20>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_4477
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(200, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-240,-28,220>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_4477
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(200, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-240,-28,420>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
}

#declare LDX_building_002_thall3_dot_ldr_mirror = union {
// Untitled
// Name: thall3.dat
// Author: John VanZwieten
// Unofficial Datsville Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,0,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,40,-24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3005
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,110,0,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_0029c
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 52, 20, 0, 22, 0)
		matrix <1,0,0,0,1,0,0,0,1,90,-24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,130,-24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,160,0,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,240,0,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,200,-24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_6005
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 48, 60, 0, 24, -20)
		matrix <-1,0,0,0,1,0,0,0,-1,330,-24,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_6005
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 48, 60, 0, 24, -20)
		matrix <0,0,-1,0,1,0,1,0,0,390,-24,20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3005
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,350,0,0>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3005
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,350,-24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,300,0,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,280,-24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,330,-24,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,390,-24,20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_2639
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 80, 20, 2, 20)
		matrix <0,0,1,0,1,0,-1,0,0,140,-32,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,-40,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,-48,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,40,-72,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,-96,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,40,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,-144,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_0029c
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 52, 20, 0, 22, 0)
		matrix <1,0,0,0,1,0,0,0,1,90,-72,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_0029c
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 52, 20, 0, 22, 0)
		matrix <1,0,0,0,1,0,0,0,1,90,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3029
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(240, 12, 80, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,280,-32,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3029
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(240, 12, 80, 0, 2, 0)
		matrix <0,0,1,0,1,0,-1,0,0,360,-32,150>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3029
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(240, 12, 80, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,360,-32,390>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_2445
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(240, 12, 40, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,380,-40,110>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_2445
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(240, 12, 40, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,380,-40,350>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3023
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,380,-40,480>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4477
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(200, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,350,-40,90>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4477
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(200, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,350,-40,290>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,350,-40,430>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3024
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,350,-40,480>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3022
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 40, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,360,-48,10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3069b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 20, 0, 4, 0)
		matrix <0,0,-1,0,1,0,1,0,0,350,-56,10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_2445
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(240, 12, 40, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,220,-40,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_2445
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(240, 12, 40, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,220,-48,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,130,-72,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,200,-72,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,260,-72,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_4286
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,1,0,1,0,-1,0,0,290,-72,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_4286_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,1,0,1,0,-1,0,0,290,-72,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_4286
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,1,0,1,0,-1,0,0,230,-96,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_4286_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,1,0,1,0,-1,0,0,230,-96,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3005
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,210,-96,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3005
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,110,-96,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,160,-96,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,130,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_4286
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,1,0,1,0,-1,0,0,170,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_4286_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,1,0,1,0,-1,0,0,170,-120,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_4286
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,1,0,1,0,-1,0,0,110,-144,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_4286_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 60, 0, 10, -20)
		matrix <0,0,1,0,1,0,-1,0,0,110,-144,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3937
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 22, 20, 0, 13, 0)
		matrix <0,0,1,0,1,0,-1,0,0,330,-56,30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		LDX_building_002_throof1_dot_ldr_mirror
		matrix <0.93,0.36,0,-0.36,0.93,0,0,0,1,330,-46,30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
}

#declare LDX_s_slash_3005s01_dot_dat_in_part = union {
// ~Brick  1 x  1 without Front Face
// Name: s\3005s01.dat
// Author: John Riley [jriley]
// !LDRAW_ORG Subpart UPDATE 2004-01
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CCW
// !HISTORY 2003-09-07 [jriley] BFCed & Subfiled
// !HISTORY 2004-03-02 [PTadmin] Official Update 2004-01
// !HISTORY 2007-08-29 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
// BFC INVERTNEXT
	#if (LDXStuds)
		object {
			lg_knob
			matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		matrix <0,0,-1,0,1,0,1,0,0,0,0,0>
		}
	#end // LDXStuds
}

#declare LDX_2_dash_4ring5_dot_dat_in_part = disc // Ring 0.5
{
	<0,0,0>,<0,1,0>,6,5
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
	}
}

#declare LDX_2_dash_4ring5_dot_dat = disc // Ring 0.5
{
	<0,0,0>,<0,1,0>,6,5
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
	}
}

#declare LDX_2_dash_4ring6_dot_dat_in_part = disc // Ring 0.5
{
	<0,0,0>,<0,1,0>,7,6
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
	}
}

#declare LDX_2_dash_4ring6_dot_dat = disc // Ring 0.5
{
	<0,0,0>,<0,1,0>,7,6
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
	}
}

#declare LDX_3005ptd_dot_dat =
#if (LDXQual = 0)
box {
	<-10,-4,-10>,<10,24,10>
}
#else
union {
// Brick  1 x  1 with Blue "D" Pattern
// Name: 3005ptd.dat
// Author: Tore Eriksson [Tore_Eriksson]
// !LDRAW_ORG Part UPDATE 2004-03
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CCW
// !HISTORY 2003-12-09 [Steffen] made use of existing subfile
// !HISTORY 2004-03-16 [westrate] added disc, ring, ndis, BFC'ed
// !HISTORY 2004-09-15 [PTadmin] Official Update 2004-03
// !HISTORY 2007-05-11 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
	object {
		LDX_s_slash_3005s01_dot_dat_in_part
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
	}
	object {
		LDX_2_dash_4ring5_dot_dat_in_part
		matrix <0,-1,0,0,0,1,1,0,0,-1,12,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor1 }
	}
	object {
		LDX_2_dash_4ring6_dot_dat_in_part
		matrix <0,-1,0,0,0,1,1,0,0,-1,12,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor1 }
	}
	object {
		LDX_2_dash_4ndis_dot_dat_in_part
		matrix <0,-7,0,0,0,1,7,0,0,-1,12,-10>
	}
	object {
		LDX_2_dash_4disc_dot_dat_in_part
		matrix <0,-5,0,0,0,1,5,0,0,-1,12,-10>
	}
	mesh2 {
		vertex_vectors {
			8,
			<-6,5,-10>, <-6,19,-10>, <-4,7,-10>, <-4,17,-10>,
			<-1,5,-10>, <-1,7,-10>, <-1,17,-10>, <-1,19,-10>
		}
		normal_vectors {
			1,
			<0,0,1>
		}
		face_indices {
			6,
			<3, 2, 0>, <3, 0, 1>, <5, 4, 0>, <5, 0, 2>,
			<3, 1, 7>, <3, 7, 6>
		}
		normal_indices {
			6,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>
		}
		#if (version >= 3.1) material #else texture #end { LDXColor1 }
	}
	mesh2 {
		vertex_vectors {
			24,
			<-10,0,-10>, <-10,0,10>, <-10,24,-10>, <-10,24,10>,
			<-6,4,-6>, <-6,4,6>, <-6,5,-10>, <-6,19,-10>,
			<-6,24,-6>, <-6,24,6>, <-4,7,-10>, <-4,17,-10>,
			<-1,7,-10>, <-1,17,-10>, <6,4,-6>, <6,4,6>,
			<6,5,-10>, <6,19,-10>, <6,24,-6>, <6,24,6>,
			<10,0,-10>, <10,0,10>, <10,24,-10>, <10,24,10>
		}
		normal_vectors {
			5,
			<-1,0,0>, <0,-1,0>, <0,0,-1>, <0,0,1>,
			<1,0,0>
		}
		face_indices {
			36,
			<15, 14, 4>, <15, 4, 5>, <15, 19, 18>, <15, 18, 14>,
			<5, 9, 19>, <5, 19, 15>, <4, 8, 9>, <4, 9, 5>,
			<14, 18, 8>, <14, 8, 4>, <22, 18, 19>, <22, 19, 23>,
			<23, 19, 9>, <23, 9, 3>, <3, 9, 8>, <3, 8, 2>,
			<2, 8, 18>, <2, 18, 22>, <21, 20, 0>, <21, 0, 1>,
			<21, 1, 3>, <21, 3, 23>, <1, 0, 2>, <1, 2, 3>,
			<20, 21, 23>, <20, 23, 22>, <11, 13, 12>, <11, 12, 10>,
			<0, 6, 16>, <0, 16, 20>, <7, 6, 0>, <7, 0, 2>,
			<17, 7, 2>, <17, 2, 22>, <16, 17, 22>, <16, 22, 20>
		}
		normal_indices {
			36,
			<1, 1, 1>, <1, 1, 1>, <4, 4, 4>, <4, 4, 4>,
			<3, 3, 3>, <3, 3, 3>, <0, 0, 0>, <0, 0, 0>,
			<2, 2, 2>, <2, 2, 2>, <1, 1, 1>, <1, 1, 1>,
			<1, 1, 1>, <1, 1, 1>, <1, 1, 1>, <1, 1, 1>,
			<1, 1, 1>, <1, 1, 1>, <1, 1, 1>, <1, 1, 1>,
			<3, 3, 3>, <3, 3, 3>, <0, 0, 0>, <0, 0, 0>,
			<4, 4, 4>, <4, 4, 4>, <3, 3, 3>, <3, 3, 3>,
			<3, 3, 3>, <3, 3, 3>, <3, 3, 3>, <3, 3, 3>,
			<3, 3, 3>, <3, 3, 3>, <3, 3, 3>, <3, 3, 3>
		}
	}
}
#end

#declare LDX_3005pta_dot_dat =
#if (LDXQual = 0)
box {
	<-10,-4,-10>,<10,24,10>
}
#else
union {
// Brick  1 x  1 with Blue "A" Pattern
// Name: 3005pta.dat
// Author: Tore Eriksson [Tore_Eriksson]
// !LDRAW_ORG Part UPDATE 2004-03
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CW
// !HISTORY 2003-12-09 [Steffen] made use of existing subfile
// !HISTORY 2004-09-15 [PTadmin] Official Update 2004-03
// !HISTORY 2007-05-11 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
	object {
		LDX_s_slash_3005s01_dot_dat_in_part
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
	}
	mesh2 {
		vertex_vectors {
			10,
			<-6,19,-10>, <-4,19,-10>, <-3,16.200001,-10>, <-2.25,14.1,-10>,
			<-1,5,-10>, <1,5,-10>, <2.25,14.1,-10>, <3,16.200001,-10>,
			<4,19,-10>, <6,19,-10>
		}
		normal_vectors {
			1,
			<0,0,-1>
		}
		face_indices {
			6,
			<0, 4, 5>, <0, 5, 1>, <8, 4, 5>, <8, 5, 9>,
			<2, 3, 6>, <2, 6, 7>
		}
		normal_indices {
			6,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>
		}
		#if (version >= 3.1) material #else texture #end { LDXColor1 }
	}
	mesh2 {
		vertex_vectors {
			27,
			<-10,0,-10>, <-10,0,10>, <-10,24,-10>, <-10,24,10>,
			<-6,4,-6>, <-6,4,6>, <-6,19,-10>, <-6,24,-6>,
			<-6,24,6>, <-4,19,-10>, <-3,16.200001,-10>, <-2.25,14.1,-10>,
			<-1,5,-10>, <0,7.8,-10>, <1,5,-10>, <2.25,14.1,-10>,
			<3,16.200001,-10>, <4,19,-10>, <6,4,-6>, <6,4,6>,
			<6,19,-10>, <6,24,-6>, <6,24,6>, <10,0,-10>,
			<10,0,10>, <10,24,-10>, <10,24,10>
		}
		normal_vectors {
			5,
			<-1,0,0>, <0,-1,0>, <0,0,-1>, <0,0,1>,
			<1,0,0>
		}
		face_indices {
			37,
			<19, 18, 4>, <19, 4, 5>, <19, 22, 21>, <19, 21, 18>,
			<5, 8, 22>, <5, 22, 19>, <4, 7, 8>, <4, 8, 5>,
			<18, 21, 7>, <18, 7, 4>, <25, 21, 22>, <25, 22, 26>,
			<26, 22, 8>, <26, 8, 3>, <3, 8, 7>, <3, 7, 2>,
			<2, 7, 21>, <2, 21, 25>, <24, 23, 0>, <24, 0, 1>,
			<24, 1, 3>, <24, 3, 26>, <1, 0, 2>, <1, 2, 3>,
			<23, 24, 26>, <23, 26, 25>, <0, 23, 14>, <0, 14, 12>,
			<23, 25, 20>, <23, 20, 14>, <25, 2, 6>, <25, 6, 20>,
			<12, 6, 2>, <12, 2, 0>, <16, 17, 9>, <16, 9, 10>,
			<13, 15, 11>
		}
		normal_indices {
			37,
			<1, 1, 1>, <1, 1, 1>, <4, 4, 4>, <4, 4, 4>,
			<3, 3, 3>, <3, 3, 3>, <0, 0, 0>, <0, 0, 0>,
			<2, 2, 2>, <2, 2, 2>, <1, 1, 1>, <1, 1, 1>,
			<1, 1, 1>, <1, 1, 1>, <1, 1, 1>, <1, 1, 1>,
			<1, 1, 1>, <1, 1, 1>, <1, 1, 1>, <1, 1, 1>,
			<3, 3, 3>, <3, 3, 3>, <0, 0, 0>, <0, 0, 0>,
			<4, 4, 4>, <4, 4, 4>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>
		}
	}
}
#end

#declare LDX_3005ptt_dot_dat =
#if (LDXQual = 0)
box {
	<-10,-4,-10>,<10,24,10>
}
#else
union {
// Brick  1 x  1 with Blue "T" Pattern
// Name: 3005ptt.dat
// Author: Tore Eriksson [Tore_Eriksson]
// !LDRAW_ORG Part UPDATE 2004-02
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CW
// !HISTORY 2003-12-09 [Steffen] BFCed, made use of existing subfile
// !HISTORY 2004-04-22 [PTadmin] Official Update 2004-02
// !HISTORY 2007-05-11 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
	object {
		LDX_s_slash_3005s01_dot_dat_in_part
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
	}
	mesh2 {
		vertex_vectors {
			8,
			<-5,5,-10>, <-5,7,-10>, <-1,7,-10>, <-1,19,-10>,
			<1,7,-10>, <1,19,-10>, <5,5,-10>, <5,7,-10>
		}
		normal_vectors {
			1,
			<0,0,-1>
		}
		face_indices {
			4,
			<0, 6, 7>, <0, 7, 1>, <2, 4, 5>, <2, 5, 3>
		}
		normal_indices {
			4,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>
		}
		#if (version >= 3.1) material #else texture #end { LDXColor1 }
	}
	mesh2 {
		vertex_vectors {
			30,
			<-10,0,-10>, <-10,0,10>, <-10,5,-10>, <-10,24,-10>,
			<-10,24,10>, <-6,4,-6>, <-6,4,6>, <-6,24,-6>,
			<-6,24,6>, <-5,5,-10>, <-5,7,-10>, <-5,24,-10>,
			<-1,7,-10>, <-1,19,-10>, <-1,24,-10>, <1,7,-10>,
			<1,19,-10>, <1,24,-10>, <5,5,-10>, <5,7,-10>,
			<5,24,-10>, <6,4,-6>, <6,4,6>, <6,24,-6>,
			<6,24,6>, <10,0,-10>, <10,0,10>, <10,5,-10>,
			<10,24,-10>, <10,24,10>
		}
		normal_vectors {
			5,
			<-1,0,0>, <0,-1,0>, <0,0,-1>, <0,0,1>,
			<1,0,0>
		}
		face_indices {
			38,
			<22, 21, 5>, <22, 5, 6>, <22, 24, 23>, <22, 23, 21>,
			<6, 8, 24>, <6, 24, 22>, <5, 7, 8>, <5, 8, 6>,
			<21, 23, 7>, <21, 7, 5>, <28, 23, 24>, <28, 24, 29>,
			<29, 24, 8>, <29, 8, 4>, <4, 8, 7>, <4, 7, 3>,
			<3, 7, 23>, <3, 23, 28>, <26, 25, 0>, <26, 0, 1>,
			<26, 1, 4>, <26, 4, 29>, <1, 0, 3>, <1, 3, 4>,
			<25, 26, 29>, <25, 29, 28>, <0, 25, 27>, <0, 27, 2>,
			<2, 9, 11>, <2, 11, 3>, <18, 27, 28>, <18, 28, 20>,
			<10, 12, 14>, <10, 14, 11>, <15, 19, 20>, <15, 20, 17>,
			<13, 16, 17>, <13, 17, 14>
		}
		normal_indices {
			38,
			<1, 1, 1>, <1, 1, 1>, <4, 4, 4>, <4, 4, 4>,
			<3, 3, 3>, <3, 3, 3>, <0, 0, 0>, <0, 0, 0>,
			<2, 2, 2>, <2, 2, 2>, <1, 1, 1>, <1, 1, 1>,
			<1, 1, 1>, <1, 1, 1>, <1, 1, 1>, <1, 1, 1>,
			<1, 1, 1>, <1, 1, 1>, <1, 1, 1>, <1, 1, 1>,
			<3, 3, 3>, <3, 3, 3>, <0, 0, 0>, <0, 0, 0>,
			<4, 4, 4>, <4, 4, 4>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>
		}
	}
}
#end

#declare LDX_3005pts_dot_dat =
#if (LDXQual = 0)
box {
	<-10,-4,-10>,<10,24,10>
}
#else
union {
// Brick  1 x  1 with Blue "S" Pattern
// Name: 3005pts.dat
// Author: Tore Eriksson [Tore_Eriksson]
// !LDRAW_ORG Part UPDATE 2004-03
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// !HISTORY 2003-12-09 [Steffen] made use of existing subfile
// !HISTORY 2004-09-15 [PTadmin] Official Update 2004-03
// !HISTORY 2007-05-11 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
	object {
		LDX_s_slash_3005s01_dot_dat_in_part
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
	}
	mesh2 {
		vertex_vectors {
			38,
			<-5.3,15.55,-10>, <-5.15,9.15,-10>, <-4.7,14.25,-10>, <-4.5,7.6,-10>,
			<-4.35,11.25,-10>, <-3.9,16.1,-10>, <-3.65,14.75,-10>, <-3.45,9.1,-10>,
			<-3.3,10,-10>, <-3.15,8.35,-10>, <-2.8,6.7,-10>, <-2.8,12,-10>,
			<-2.7,15.2,-10>, <-2.45,7.9,-10>, <-2.45,10.65,-10>, <-2.4,16.6,-10>,
			<-0.9,15.6,-10>, <-0.65,12.35,-10>, <-0.6,11.1,-10>, <-0.5,7.6,-10>,
			<-0.3,16.85,-10>, <-0.15,6.35,-10>, <0.7,15.6,-10>, <1.3,16.9,-10>,
			<1.45,15.45,-10>, <1.5,12.8,-10>, <1.9,7.95,-10>, <2.1,11.55,-10>,
			<2.15,6.75,-10>, <2.15,14.95,-10>, <2.35,16.549999,-10>, <2.5,13.2,-10>,
			<2.65,13.9,-10>, <3.2,8.75,-10>, <3.35,15.9,-10>, <3.6,12.3,-10>,
			<3.85,7.4,-10>, <4.25,14.05,-10>
		}
		normal_vectors {
			1,
			<0,0,1>
		}
		face_indices {
			36,
			<36, 28, 26>, <36, 26, 33>, <28, 21, 19>, <28, 19, 26>,
			<21, 10, 13>, <21, 13, 19>, <10, 3, 9>, <10, 9, 13>,
			<3, 1, 7>, <3, 7, 9>, <1, 4, 8>, <1, 8, 7>,
			<4, 11, 14>, <4, 14, 8>, <11, 17, 18>, <11, 18, 14>,
			<17, 25, 27>, <17, 27, 18>, <25, 31, 35>, <25, 35, 27>,
			<31, 32, 37>, <31, 37, 35>, <32, 29, 34>, <32, 34, 37>,
			<29, 24, 30>, <29, 30, 34>, <24, 22, 23>, <24, 23, 30>,
			<22, 16, 20>, <22, 20, 23>, <16, 12, 15>, <16, 15, 20>,
			<12, 6, 5>, <12, 5, 15>, <6, 2, 0>, <6, 0, 5>
		}
		normal_indices {
			36,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>
		}
		#if (version >= 3.1) material #else texture #end { LDXColor1 }
	}
	mesh2 {
		vertex_vectors {
			54,
			<-10,0,-10>, <-10,0,10>, <-10,24,-10>, <-10,24,10>,
			<-6,4,-6>, <-6,4,6>, <-6,24,-6>, <-6,24,6>,
			<-5.3,15.55,-10>, <-5.15,9.15,-10>, <-4.7,14.25,-10>, <-4.5,7.6,-10>,
			<-4.35,11.25,-10>, <-3.9,16.1,-10>, <-3.65,14.75,-10>, <-3.45,9.1,-10>,
			<-3.3,10,-10>, <-3.15,8.35,-10>, <-2.8,6.7,-10>, <-2.8,12,-10>,
			<-2.7,15.2,-10>, <-2.45,7.9,-10>, <-2.45,10.65,-10>, <-2.4,16.6,-10>,
			<-0.9,15.6,-10>, <-0.65,12.35,-10>, <-0.6,11.1,-10>, <-0.5,7.6,-10>,
			<-0.3,16.85,-10>, <-0.15,6.35,-10>, <0.7,15.6,-10>, <1.3,16.9,-10>,
			<1.45,15.45,-10>, <1.5,12.8,-10>, <1.9,7.95,-10>, <2.1,11.55,-10>,
			<2.15,6.75,-10>, <2.15,14.95,-10>, <2.35,16.549999,-10>, <2.5,13.2,-10>,
			<2.65,13.9,-10>, <3.2,8.75,-10>, <3.35,15.9,-10>, <3.6,12.3,-10>,
			<3.85,7.4,-10>, <4.25,14.05,-10>, <6,4,-6>, <6,4,6>,
			<6,24,-6>, <6,24,6>, <10,0,-10>, <10,0,10>,
			<10,24,-10>, <10,24,10>
		}
		normal_vectors {
			5,
			<-1,0,0>, <0,-1,0>, <0,0,-1>, <0,0,1>,
			<1,0,0>
		}
		face_indices {
			68,
			<47, 46, 4>, <47, 4, 5>, <47, 49, 48>, <47, 48, 46>,
			<5, 7, 49>, <5, 49, 47>, <4, 6, 7>, <4, 7, 5>,
			<46, 48, 6>, <46, 6, 4>, <52, 48, 49>, <52, 49, 53>,
			<53, 49, 7>, <53, 7, 3>, <3, 7, 6>, <3, 6, 2>,
			<2, 6, 48>, <2, 48, 52>, <51, 50, 0>, <51, 0, 1>,
			<51, 1, 3>, <51, 3, 53>, <1, 0, 2>, <1, 2, 3>,
			<50, 51, 53>, <50, 53, 52>, <44, 45, 43>, <44, 43, 41>,
			<43, 35, 34>, <43, 34, 41>, <35, 26, 27>, <35, 27, 34>,
			<26, 22, 21>, <26, 21, 27>, <22, 16, 17>, <22, 17, 21>,
			<16, 15, 17>, <12, 19, 14>, <12, 14, 10>, <19, 25, 20>,
			<19, 20, 14>, <25, 33, 24>, <25, 24, 20>, <33, 39, 30>,
			<33, 30, 24>, <39, 40, 32>, <39, 32, 30>, <40, 37, 32>,
			<9, 12, 10>, <9, 10, 8>, <50, 44, 36>, <50, 36, 29>,
			<50, 29, 0>, <0, 29, 18>, <0, 18, 11>, <0, 11, 9>,
			<0, 9, 8>, <0, 8, 2>, <2, 8, 13>, <2, 13, 23>,
			<2, 23, 28>, <2, 28, 31>, <2, 31, 52>, <52, 31, 38>,
			<52, 38, 42>, <52, 42, 45>, <52, 45, 44>, <52, 44, 50>
		}
		normal_indices {
			68,
			<1, 1, 1>, <1, 1, 1>, <4, 4, 4>, <4, 4, 4>,
			<3, 3, 3>, <3, 3, 3>, <0, 0, 0>, <0, 0, 0>,
			<2, 2, 2>, <2, 2, 2>, <1, 1, 1>, <1, 1, 1>,
			<1, 1, 1>, <1, 1, 1>, <1, 1, 1>, <1, 1, 1>,
			<1, 1, 1>, <1, 1, 1>, <1, 1, 1>, <1, 1, 1>,
			<3, 3, 3>, <3, 3, 3>, <0, 0, 0>, <0, 0, 0>,
			<4, 4, 4>, <4, 4, 4>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <2, 2, 2>, <2, 2, 2>
		}
	}
}
#end

#declare LDX_3005ptv_dot_dat =
#if (LDXQual = 0)
box {
	<-10,-4,-10>,<10,24,10>
}
#else
union {
// Brick  1 x  1 with Blue "V" Pattern
// Name: 3005ptv.dat
// Author: Tore Eriksson [Tore_Eriksson]
// !LDRAW_ORG Part UPDATE 2004-02
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// !HISTORY 2003-12-09 [Steffen] made use of existing subfile
// !HISTORY 2004-04-22 [PTadmin] Official Update 2004-02
// !HISTORY 2007-05-11 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
	object {
		LDX_s_slash_3005s01_dot_dat_in_part
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
	}
	mesh2 {
		vertex_vectors {
			7,
			<-5.5,5,-10>, <-3.5,5,-10>, <-1,19,-10>, <0,16,-10>,
			<1,19,-10>, <3.5,5,-10>, <5.5,5,-10>
		}
		normal_vectors {
			2,
			<0,0,-1>, <0,0,1>
		}
		face_indices {
			5,
			<0, 2, 3>, <0, 3, 1>, <2, 4, 3>, <4, 3, 5>,
			<4, 5, 6>
		}
		normal_indices {
			5,
			<1, 1, 1>, <1, 1, 1>, <1, 1, 1>, <0, 0, 0>,
			<0, 0, 0>
		}
		#if (version >= 3.1) material #else texture #end { LDXColor1 }
	}
	mesh2 {
		vertex_vectors {
			23,
			<-10,0,-10>, <-10,0,10>, <-10,24,-10>, <-10,24,10>,
			<-6,4,-6>, <-6,4,6>, <-6,24,-6>, <-6,24,6>,
			<-5.5,5,-10>, <-3.5,5,-10>, <-1,19,-10>, <0,16,-10>,
			<1,19,-10>, <3.5,5,-10>, <5.5,5,-10>, <6,4,-6>,
			<6,4,6>, <6,24,-6>, <6,24,6>, <10,0,-10>,
			<10,0,10>, <10,24,-10>, <10,24,10>
		}
		normal_vectors {
			5,
			<-1,0,0>, <0,-1,0>, <0,0,-1>, <0,0,1>,
			<1,0,0>
		}
		face_indices {
			35,
			<16, 15, 4>, <16, 4, 5>, <16, 18, 17>, <16, 17, 15>,
			<5, 7, 18>, <5, 18, 16>, <4, 6, 7>, <4, 7, 5>,
			<15, 17, 6>, <15, 6, 4>, <21, 17, 18>, <21, 18, 22>,
			<22, 18, 7>, <22, 7, 3>, <3, 7, 6>, <3, 6, 2>,
			<2, 6, 17>, <2, 17, 21>, <20, 19, 0>, <20, 0, 1>,
			<20, 1, 3>, <20, 3, 22>, <1, 0, 2>, <1, 2, 3>,
			<19, 20, 22>, <19, 22, 21>, <0, 8, 14>, <0, 14, 19>,
			<0, 8, 10>, <0, 10, 2>, <2, 10, 12>, <2, 12, 21>,
			<21, 12, 14>, <21, 14, 19>, <11, 13, 9>
		}
		normal_indices {
			35,
			<1, 1, 1>, <1, 1, 1>, <4, 4, 4>, <4, 4, 4>,
			<3, 3, 3>, <3, 3, 3>, <0, 0, 0>, <0, 0, 0>,
			<2, 2, 2>, <2, 2, 2>, <1, 1, 1>, <1, 1, 1>,
			<1, 1, 1>, <1, 1, 1>, <1, 1, 1>, <1, 1, 1>,
			<1, 1, 1>, <1, 1, 1>, <1, 1, 1>, <1, 1, 1>,
			<3, 3, 3>, <3, 3, 3>, <0, 0, 0>, <0, 0, 0>,
			<4, 4, 4>, <4, 4, 4>, <3, 3, 3>, <3, 3, 3>,
			<2, 2, 2>, <2, 2, 2>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <3, 3, 3>
		}
	}
}
#end

#declare LDX_3005pti_dot_dat =
#if (LDXQual = 0)
box {
	<-10,-4,-10>,<10,24,10>
}
#else
union {
// Brick  1 x  1 with Blue "I" Pattern
// Name: 3005pti.dat
// Author: Tore Eriksson [Tore_Eriksson]
// !LDRAW_ORG Part UPDATE 2004-02
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// !HISTORY 2003-12-09 [Steffen] made use of existing subfile
// !HISTORY 2004-04-22 [PTadmin] Official Update 2004-02
// !HISTORY 2007-05-11 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
	object {
		LDX_s_slash_3005s01_dot_dat_in_part
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
	}
	mesh2 {
		vertex_vectors {
			4,
			<-1,5,-10>, <-1,19,-10>, <1,5,-10>, <1,19,-10>
		}
		normal_vectors {
			1,
			<0,0,-1>
		}
		face_indices {
			2,
			<0, 2, 3>, <0, 3, 1>
		}
		normal_indices {
			2,
			<0, 0, 0>, <0, 0, 0>
		}
		#if (version >= 3.1) material #else texture #end { LDXColor1 }
	}
	mesh2 {
		vertex_vectors {
			24,
			<-10,0,-10>, <-10,0,10>, <-10,5,-10>, <-10,24,-10>,
			<-10,24,10>, <-6,4,-6>, <-6,4,6>, <-6,24,-6>,
			<-6,24,6>, <-1,5,-10>, <-1,19,-10>, <-1,24,-10>,
			<1,5,-10>, <1,19,-10>, <1,24,-10>, <6,4,-6>,
			<6,4,6>, <6,24,-6>, <6,24,6>, <10,0,-10>,
			<10,0,10>, <10,5,-10>, <10,24,-10>, <10,24,10>
		}
		normal_vectors {
			5,
			<-1,0,0>, <0,-1,0>, <0,0,-1>, <0,0,1>,
			<1,0,0>
		}
		face_indices {
			34,
			<16, 15, 5>, <16, 5, 6>, <16, 18, 17>, <16, 17, 15>,
			<6, 8, 18>, <6, 18, 16>, <5, 7, 8>, <5, 8, 6>,
			<15, 17, 7>, <15, 7, 5>, <22, 17, 18>, <22, 18, 23>,
			<23, 18, 8>, <23, 8, 4>, <4, 8, 7>, <4, 7, 3>,
			<3, 7, 17>, <3, 17, 22>, <20, 19, 0>, <20, 0, 1>,
			<20, 1, 4>, <20, 4, 23>, <1, 0, 3>, <1, 3, 4>,
			<19, 20, 23>, <19, 23, 22>, <0, 19, 21>, <0, 21, 2>,
			<2, 9, 11>, <2, 11, 3>, <12, 21, 22>, <12, 22, 14>,
			<10, 13, 14>, <10, 14, 11>
		}
		normal_indices {
			34,
			<1, 1, 1>, <1, 1, 1>, <4, 4, 4>, <4, 4, 4>,
			<3, 3, 3>, <3, 3, 3>, <0, 0, 0>, <0, 0, 0>,
			<2, 2, 2>, <2, 2, 2>, <1, 1, 1>, <1, 1, 1>,
			<1, 1, 1>, <1, 1, 1>, <1, 1, 1>, <1, 1, 1>,
			<1, 1, 1>, <1, 1, 1>, <1, 1, 1>, <1, 1, 1>,
			<3, 3, 3>, <3, 3, 3>, <0, 0, 0>, <0, 0, 0>,
			<4, 4, 4>, <4, 4, 4>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>
		}
	}
}
#end

#declare LDX_3005ptl_dot_dat =
#if (LDXQual = 0)
box {
	<-10,-4,-10>,<10,24,10>
}
#else
union {
// Brick  1 x  1 with Blue "L" Pattern
// Name: 3005ptl.dat
// Author: Tore Eriksson [Tore_Eriksson]
// !LDRAW_ORG Part UPDATE 2004-02
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// !HISTORY 2003-12-09 [Steffen] made use of existing subfile
// !HISTORY 2004-04-22 [PTadmin] Official Update 2004-02
// !HISTORY 2007-05-11 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
	object {
		LDX_s_slash_3005s01_dot_dat_in_part
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
	}
	mesh2 {
		vertex_vectors {
			7,
			<-5,5,-10>, <-5,19,-10>, <-3,5,-10>, <-3,17,-10>,
			<-3,19,-10>, <5,17,-10>, <5,19,-10>
		}
		normal_vectors {
			1,
			<0,0,-1>
		}
		face_indices {
			4,
			<0, 2, 4>, <0, 4, 1>, <3, 5, 6>, <3, 6, 4>
		}
		normal_indices {
			4,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>
		}
		#if (version >= 3.1) material #else texture #end { LDXColor1 }
	}
	mesh2 {
		vertex_vectors {
			27,
			<-10,0,-10>, <-10,0,10>, <-10,5,-10>, <-10,24,-10>,
			<-10,24,10>, <-6,4,-6>, <-6,4,6>, <-6,24,-6>,
			<-6,24,6>, <-5,5,-10>, <-5,19,-10>, <-5,24,-10>,
			<-3,5,-10>, <-3,17,-10>, <5,17,-10>, <5,19,-10>,
			<5,24,-10>, <6,4,-6>, <6,4,6>, <6,24,-6>,
			<6,24,6>, <10,0,-10>, <10,0,10>, <10,5,-10>,
			<10,17,-10>, <10,24,-10>, <10,24,10>
		}
		normal_vectors {
			5,
			<-1,0,0>, <0,-1,0>, <0,0,-1>, <0,0,1>,
			<1,0,0>
		}
		face_indices {
			36,
			<18, 17, 5>, <18, 5, 6>, <18, 20, 19>, <18, 19, 17>,
			<6, 8, 20>, <6, 20, 18>, <5, 7, 8>, <5, 8, 6>,
			<17, 19, 7>, <17, 7, 5>, <25, 19, 20>, <25, 20, 26>,
			<26, 20, 8>, <26, 8, 4>, <4, 8, 7>, <4, 7, 3>,
			<3, 7, 19>, <3, 19, 25>, <22, 21, 0>, <22, 0, 1>,
			<22, 1, 4>, <22, 4, 26>, <1, 0, 3>, <1, 3, 4>,
			<21, 22, 26>, <21, 26, 25>, <0, 21, 23>, <0, 23, 2>,
			<2, 9, 11>, <2, 11, 3>, <12, 23, 24>, <12, 24, 13>,
			<14, 24, 25>, <14, 25, 16>, <10, 15, 16>, <10, 16, 11>
		}
		normal_indices {
			36,
			<1, 1, 1>, <1, 1, 1>, <4, 4, 4>, <4, 4, 4>,
			<3, 3, 3>, <3, 3, 3>, <0, 0, 0>, <0, 0, 0>,
			<2, 2, 2>, <2, 2, 2>, <1, 1, 1>, <1, 1, 1>,
			<1, 1, 1>, <1, 1, 1>, <1, 1, 1>, <1, 1, 1>,
			<1, 1, 1>, <1, 1, 1>, <1, 1, 1>, <1, 1, 1>,
			<3, 3, 3>, <3, 3, 3>, <0, 0, 0>, <0, 0, 0>,
			<4, 4, 4>, <4, 4, 4>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <2, 2, 2>, <2, 2, 2>
		}
	}
}
#end

#declare LDX_3005pte_dot_dat =
#if (LDXQual = 0)
box {
	<-10,-4,-10>,<10,24,10>
}
#else
union {
// Brick  1 x  1 with Blue "E" Pattern
// Name: 3005pte.dat
// Author: Tore Eriksson [Tore_Eriksson]
// !LDRAW_ORG Part UPDATE 2004-02
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// !HISTORY 2003-12-09 [Steffen] made use of existing subfile
// !HISTORY 2004-04-22 [PTadmin] Official Update 2004-02
// !HISTORY 2007-05-11 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
	object {
		LDX_s_slash_3005s01_dot_dat_in_part
		matrix <1,0,0,0,1,0,0,0,1,0,0,0>
	}
	mesh2 {
		vertex_vectors {
			14,
			<-5,5,-10>, <-5,7,-10>, <-5,19,-10>, <-3,7,-10>,
			<-3,11,-10>, <-3,13,-10>, <-3,17,-10>, <-3,19,-10>,
			<3,11,-10>, <3,13,-10>, <5,5,-10>, <5,7,-10>,
			<5,17,-10>, <5,19,-10>
		}
		normal_vectors {
			1,
			<0,0,-1>
		}
		face_indices {
			8,
			<0, 10, 11>, <0, 11, 1>, <1, 3, 7>, <1, 7, 2>,
			<4, 8, 9>, <4, 9, 5>, <6, 12, 13>, <6, 13, 7>
		}
		normal_indices {
			8,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>
		}
		#if (version >= 3.1) material #else texture #end { LDXColor1 }
	}
	mesh2 {
		vertex_vectors {
			34,
			<-10,0,-10>, <-10,0,10>, <-10,5,-10>, <-10,24,-10>,
			<-10,24,10>, <-6,4,-6>, <-6,4,6>, <-6,24,-6>,
			<-6,24,6>, <-5,5,-10>, <-5,19,-10>, <-5,24,-10>,
			<-3,7,-10>, <-3,11,-10>, <-3,13,-10>, <-3,17,-10>,
			<3,11,-10>, <3,13,-10>, <3,17,-10>, <5,5,-10>,
			<5,7,-10>, <5,11,-10>, <5,17,-10>, <5,19,-10>,
			<5,24,-10>, <6,4,-6>, <6,4,6>, <6,24,-6>,
			<6,24,6>, <10,0,-10>, <10,0,10>, <10,5,-10>,
			<10,24,-10>, <10,24,10>
		}
		normal_vectors {
			5,
			<-1,0,0>, <0,-1,0>, <0,0,-1>, <0,0,1>,
			<1,0,0>
		}
		face_indices {
			40,
			<26, 25, 5>, <26, 5, 6>, <26, 28, 27>, <26, 27, 25>,
			<6, 8, 28>, <6, 28, 26>, <5, 7, 8>, <5, 8, 6>,
			<25, 27, 7>, <25, 7, 5>, <32, 27, 28>, <32, 28, 33>,
			<33, 28, 8>, <33, 8, 4>, <4, 8, 7>, <4, 7, 3>,
			<3, 7, 27>, <3, 27, 32>, <30, 29, 0>, <30, 0, 1>,
			<30, 1, 4>, <30, 4, 33>, <1, 0, 3>, <1, 3, 4>,
			<29, 30, 33>, <29, 33, 32>, <0, 29, 31>, <0, 31, 2>,
			<2, 9, 11>, <2, 11, 3>, <19, 31, 32>, <19, 32, 24>,
			<12, 20, 21>, <12, 21, 13>, <16, 21, 22>, <16, 22, 18>,
			<14, 17, 18>, <14, 18, 15>, <10, 23, 24>, <10, 24, 11>
		}
		normal_indices {
			40,
			<1, 1, 1>, <1, 1, 1>, <4, 4, 4>, <4, 4, 4>,
			<3, 3, 3>, <3, 3, 3>, <0, 0, 0>, <0, 0, 0>,
			<2, 2, 2>, <2, 2, 2>, <1, 1, 1>, <1, 1, 1>,
			<1, 1, 1>, <1, 1, 1>, <1, 1, 1>, <1, 1, 1>,
			<1, 1, 1>, <1, 1, 1>, <1, 1, 1>, <1, 1, 1>,
			<3, 3, 3>, <3, 3, 3>, <0, 0, 0>, <0, 0, 0>,
			<4, 4, 4>, <4, 4, 4>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <2, 2, 2>, <2, 2, 2>,
			<2, 2, 2>, <2, 2, 2>, <2, 2, 2>, <2, 2, 2>
		}
	}
}
#end

#include "lg_3956.inc" // Bracket  2 x  2 -  2 x  2 Up

#include "lg_2465.inc" // Brick  1 x 16

#declare LDX_building_002_throof2_dot_ldr = union {
// Untitled
// Name: throof2.dat
// Author: John VanZwieten
// Unofficial Datsville Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		LDX_3005ptd_dot_dat
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-20,0,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_3005pta_dot_dat
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,0,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_3005ptt_dot_dat
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,20,0,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_3005pts_dot_dat
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,40,0,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_3005ptv_dot_dat
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,0,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_3005pti_dot_dat
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,0,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_3005ptl_dot_dat
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,100,0,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_3005ptl_dot_dat
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,120,0,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_3005pte_dot_dat
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,140,0,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3021
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 12, 40, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,24,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3021
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 12, 40, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,120,24,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3021
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 12, 40, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,24,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3623
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,32,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3623
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,32,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3623
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,120,32,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_3794a_dot_dat
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-20,32,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_3794a_dot_dat
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,20,32,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_3794a_dot_dat
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,32,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_3794a_dot_dat
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,100,32,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_3794a_dot_dat
		LDXSeamMatrix(40, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,140,32,0>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3956
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 48, 52, 0, -16, -6)
		matrix <0,0,-1,-1,0,0,0,1,0,-30,20,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3956
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 48, 52, 0, -16, -6)
		matrix <0,0,1,1,0,0,0,1,0,150,20,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3021
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 12, 40, 0, 2, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,40,-8,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3022
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 40, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,90,-8,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3026
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(480, 12, 120, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,50,-16,190>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_3958
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 120, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,50,-16,490>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_4477
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(200, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,120,-16,50>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_4477
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(200, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,120,-16,250>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_4477
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(200, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,120,-16,450>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_4510
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 29, 0, 2, -4.5)
		matrix <0,0,-1,0,1,0,1,0,0,-20,-16,30>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_4510
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 29, 0, 2, -4.5)
		matrix <0,0,-1,0,1,0,1,0,0,-20,-16,190>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_4510
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 29, 0, 2, -4.5)
		matrix <0,0,-1,0,1,0,1,0,0,-20,-16,350>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_4510
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 29, 0, 2, -4.5)
		matrix <0,0,1,0,1,0,-1,0,0,140,-16,30>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_4510
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 29, 0, 2, -4.5)
		matrix <0,0,1,0,1,0,-1,0,0,140,-16,190>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_4510
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 29, 0, 2, -4.5)
		matrix <0,0,1,0,1,0,-1,0,0,140,-16,350>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_32028
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 29, 0, 2, -4.5)
		matrix <0,0,1,0,1,0,-1,0,0,140,-16,450>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_32028
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 29, 0, 2, -4.5)
		matrix <0,0,1,0,1,0,-1,0,0,140,-16,490>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_32028
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 29, 0, 2, -4.5)
		matrix <0,0,-1,0,1,0,1,0,0,-20,-16,450>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_32028
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 12, 29, 0, 2, -4.5)
		matrix <0,0,-1,0,1,0,1,0,0,-20,-16,490>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_2465
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(320, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-30,40,150>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_2465
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(320, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,150,40,150>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_4477
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(200, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-30,32,110>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4477
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(200, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,150,32,110>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4477
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(200, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,150,24,110>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_4477
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(200, 12, 20, 0, 2, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-30,24,110>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3069b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 20, 0, 4, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-30,16,10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3069b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 8, 20, 0, 4, 0)
		matrix <0,0,-1,0,1,0,1,0,0,150,16,10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3937
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 22, 20, 0, 13, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-30,-8,10>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3937
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 22, 20, 0, 13, 0)
		matrix <0,0,1,0,1,0,-1,0,0,150,-8,20>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3938
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 20, 20, 0, 6, 0)
		matrix <0,0,-1,1,0,0,0,-1,0,-40,2,10>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_3938
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 20, 20, 0, 6, 0)
		matrix <0,0,-1,-1,0,0,0,1,0,160,2,20>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_4282
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(320, 12, 40, 0, 2, 0)
		matrix <0,0,-1,-1,0,0,0,1,0,168,2,110>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_2445
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(240, 12, 40, 0, 2, 0)
		matrix <0,0,-1,-1,0,0,0,1,0,168,2,390>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_2445
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(240, 12, 40, 0, 2, 0)
		matrix <0,0,-1,1,0,0,0,-1,0,-48,2,390>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
	object {
		lg_4282
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(320, 12, 40, 0, 2, 0)
		matrix <0,0,-1,1,0,0,0,-1,0,-48,2,110>
		#if (version >= 3.1) material #else texture #end { LDXColor0 }
	}
}

#declare LDX_building_002_thall7_dot_ldr = union {
// Untitled
// Name: thall7.dat
// Author: John VanZwieten
// Unofficial Datsville Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		LDX_building_002_thall3_dot_ldr
		matrix <1,0,0,0,1,0,0,0,1,0,-432,-40>
	}
	object {
		LDX_building_002_thall3_dot_ldr_mirror
		matrix <-1,0,0,0,1,0,0,0,1,0,-432,-40>
	}
	object {
		LDX_building_002_throof2_dot_ldr
		matrix <1,0,0,0,1,0,0,0,1,-60,-616,-40>
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-432,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3035
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 80, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-464,-50>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-472,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3710
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 12, 20, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-480,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-528,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-576,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
}

#include "lg_75535.inc" // Technic Pin Joiner Round

#declare LDX_building_002_townhall_dot_mpd = union {
// FILE building_002_townhall.ldr
// Datsville Town Hall
// Name: building_002_townhall.ldr
// Author: John VanZwieten
// Unofficial Datsville Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		LDX_pedestrian_011_manmayortophat_dot_ldr
		matrix <1,0,0,0,1,0,0,0,1,0,-64,-550>
	}
	object {
		LDX_building_002_thall6_dot_ldr
		matrix <1,0,0,0,1,0,0,0,1,0,-192,-470>
	}
	object {
		LDX_building_002_thall1_dot_ldr
		matrix <1,0,0,0,1,0,0,0,1,-20,-192,-450>
	}
	object {
		LDX_building_002_thall1_dot_ldr_mirror
		matrix <-1,0,0,0,1,0,0,0,1,20,-192,-450>
	}
	object {
		lg_3811
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(640, 8, 640, 0, 0, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,0,-102,-180>
		#if (version >= 3.1) material #else texture #end { LDXColor8 }
	}
	object {
		lg_3811
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(640, 8, 640, 0, 0, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-318,-180>
		#if (version >= 3.1) material #else texture #end { LDXColor8 }
	}
	object {
		lg_3811
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(640, 8, 640, 0, 0, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-550,-180>
		#if (version >= 3.1) material #else texture #end { LDXColor8 }
	}
	object {
		lg_3857
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(640, 8, 320, 0, 0, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-102,300>
		#if (version >= 3.1) material #else texture #end { LDXColor8 }
	}
	object {
		lg_3857
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(640, 8, 320, 0, 0, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-318,300>
		#if (version >= 3.1) material #else texture #end { LDXColor8 }
	}
	object {
		lg_3857
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(640, 8, 320, 0, 0, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-550,300>
		#if (version >= 3.1) material #else texture #end { LDXColor8 }
	}
	object {
		LDX_building_002_thall7_dot_ldr
		matrix <1,0,0,0,1,0,0,0,1,0,-192,-470>
	}
	object {
		LDX_building_002_thall7_dot_ldr
		matrix <-1,0,0,0,1,0,0,0,-1,0,-192,470>
	}
	object {
		LDX_building_002_thall6_dot_ldr
		matrix <-1,0,0,0,1,0,0,0,-1,0,-192,470>
	}
	object {
		lg_75535
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 20, 20, 0, 0, 0)
		matrix <0,1,0,-1,0,0,0,0,1,0,-808,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_75535
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 20, 20, 0, 0, 0)
		matrix <0,1,0,-1,0,0,0,0,1,0,-808,100>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
	object {
		lg_75535
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 20, 20, 0, 0, 0)
		matrix <0,1,0,-1,0,0,0,0,1,0,-808,220>
		#if (version >= 3.1) material #else texture #end { LDXColor7 }
	}
}

#declare LDX_block_002_dot_ldr = union {
// Datsville City Block #2
// Name: block_002.ldr
// Author: John VanZwieten, Michael Horvath, Tore Eriksson
// Unofficial Datsville Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		lg_3811
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(640, 8, 640, 0, 0, 0)
		matrix <1,0,0,0,1,0,0,0,1,-2240,0,320>
		#if (version >= 3.1) material #else texture #end { LDXColor13 }
	}
	object {
		lg_3958
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 120, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-2500,-8,580>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3958
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 120, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-2500,-8,60>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3958
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 120, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-2380,-8,60>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3958
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 120, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-2380,-8,180>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3958
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 120, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-2500,-8,180>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3958
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 120, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-2380,-8,460>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3958
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 120, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-2500,-8,460>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		LDX_87079_dot_dat
		LDXSeamMatrix(80, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-2520,-8,380>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_87079_dot_dat
		LDXSeamMatrix(80, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-2520,-8,340>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_87079_dot_dat
		LDXSeamMatrix(80, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-2520,-8,300>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_87079_dot_dat
		LDXSeamMatrix(80, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-2520,-8,260>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_87079_dot_dat
		LDXSeamMatrix(80, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-2440,-8,260>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_87079_dot_dat
		LDXSeamMatrix(80, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-2440,-8,300>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_87079_dot_dat
		LDXSeamMatrix(80, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-2440,-8,340>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_87079_dot_dat
		LDXSeamMatrix(80, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-2440,-8,380>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_87079_dot_dat
		LDXSeamMatrix(80, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-2360,-8,380>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_87079_dot_dat
		LDXSeamMatrix(80, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-2360,-8,340>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_87079_dot_dat
		LDXSeamMatrix(80, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-2360,-8,300>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		LDX_87079_dot_dat
		LDXSeamMatrix(80, 8, 40, 0, 4, 0)
		matrix <1,0,0,0,1,0,0,0,1,-2360,-8,260>
		#if (version >= 3.1) material #else texture #end { LDXColor15 }
	}
	object {
		lg_3958
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 120, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-2380,-8,460>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3958
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 120, 0, 2, 0)
		matrix <1,0,0,0,1,0,0,0,1,-2380,-8,580>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3795
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 40, 0, 2, 0)
		matrix <0,0,1,0,1,0,-1,0,0,-2300,-8,580>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3795
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 40, 0, 2, 0)
		matrix <0,0,1,0,1,0,-1,0,0,-2300,-8,460>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3034
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(160, 12, 40, 0, 2, 0)
		matrix <0,0,1,0,1,0,-1,0,0,-2300,-8,320>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3795
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 40, 0, 2, 0)
		matrix <0,0,1,0,1,0,-1,0,0,-2300,-8,180>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		lg_3795
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(120, 12, 40, 0, 2, 0)
		matrix <0,0,1,0,1,0,-1,0,0,-2300,-8,60>
		#if (version >= 3.1) material #else texture #end { LDXColor2 }
	}
	object {
		LDX_building_002_townhall_dot_mpd
		matrix <0,0,1,0,1,0,-1,0,0,-1780,-8,320>
	}
	object {
		lg_3811
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(640, 8, 640, 0, 0, 0)
		matrix <1,0,0,0,1,0,0,0,1,-1600,0,320>
		#if (version >= 3.1) material #else texture #end { LDXColor13 }
	}
}

#include "lg_3002.inc" // Brick  2 x  3

#include "lg_3040b.inc" // Slope Brick 45  2 x  1

#include "lg_3046.inc" // Slope Brick 45  2 x  2 Double Concave

#include "lg_3045.inc" // Slope Brick 45  2 x  2 Double Convex

#include "lg_3660.inc" // Slope Brick 45  2 x  2 Inverted

#include "lg_3038.inc" // Slope Brick 45  2 x  3

#include "lg_3049b.inc" // Slope Brick 45  1 x  2 Double / Inverted

#include "lg_3043.inc" // Slope Brick 45  2 x  2 Double

#include "lg_3048.inc" // Slope Brick 45  1 x  2 Triple

#declare LDX_building_043_datsvillememorial_dot_ldr = union {
// Datsville Memorial
// Name: building_043.ldr
// Author: Manfred Moolhuysen 1999
// Unofficial Datsville Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		lg_3003
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,-24,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-60,-24,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-50,-24,-90>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3002
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 40, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-120,-24,-50>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3003
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-100,-24,-100>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3002
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-50,-24,-120>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3003
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-40,-24,80>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-70,-24,60>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-90,-24,50>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3002
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-50,-24,120>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3003
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-100,-24,100>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3002
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 40, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-120,-24,50>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3003
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,-24,40>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,-24,70>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,50,-24,90>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3002
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 40, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,120,-24,50>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3003
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,100,-24,100>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3002
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,50,-24,120>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3003
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,40,-24,-80>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,70,-24,-60>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3622
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,90,-24,-50>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3002
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,50,-24,-120>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3003
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,100,-24,-100>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3002
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 40, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,120,-24,-50>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-100,-48,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_2357
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, 10)
		matrix <1,0,0,0,1,0,0,0,1,-70,-48,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-30,-48,-100>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3040b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,-130,-48,-50>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3040b_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,-130,-48,-50>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3046
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-90,-48,-50>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3046_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-90,-48,-50>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3045
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-90,-48,-90>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3045_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-90,-48,-90>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3046
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-50,-48,-90>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3046_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-50,-48,-90>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3040b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-50,-48,-130>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3040b_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-50,-48,-130>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-30,-48,100>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_2357
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, 10)
		matrix <0,0,-1,0,1,0,1,0,0,-70,-48,70>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-100,-48,30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3040b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-50,-48,130>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3040b_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-50,-48,130>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3046
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,-50,-48,90>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3046_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,-50,-48,90>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3045
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,-90,-48,90>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3045_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,-90,-48,90>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3046
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,-90,-48,50>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3046_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,-90,-48,50>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3040b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,-130,-48,50>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3040b_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,-130,-48,50>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,100,-48,30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_2357
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, 10)
		matrix <-1,0,0,0,1,0,0,0,-1,70,-48,70>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,30,-48,100>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3040b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,130,-48,50>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3040b_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,130,-48,50>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3046
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,90,-48,50>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3046_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,90,-48,50>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3045
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,90,-48,90>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3045_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,90,-48,90>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3046
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,50,-48,90>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3046_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,50,-48,90>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3040b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,50,-48,130>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3040b_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,50,-48,130>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,30,-48,-100>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_2357
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, 10)
		matrix <0,0,1,0,1,0,-1,0,0,70,-48,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,100,-48,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3040b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,50,-48,-130>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3040b_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,50,-48,-130>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3046
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,50,-48,-90>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3046_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,50,-48,-90>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3045
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,90,-48,-90>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3045_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,90,-48,-90>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3046
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,90,-48,-50>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3046_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,90,-48,-50>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3040b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,130,-48,-50>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3040b_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,130,-48,-50>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3003
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-120,-72,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-80,-72,-60>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-40,-72,-100>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3003
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-40,-72,120>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-60,-72,80>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-100,-72,40>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3003
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,120,-72,40>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,80,-72,60>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,40,-72,100>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3003
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,40,-72,-120>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,-72,-80>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,100,-72,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-100,-96,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-60,-96,-80>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3003
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-40,-96,-120>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-40,-96,100>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-80,-96,60>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3003
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-120,-96,40>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,100,-96,40>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,-96,80>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3003
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,40,-96,120>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,40,-96,-100>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,80,-96,-60>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3003
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,120,-96,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3660
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,-120,-120,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3660_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,-120,-120,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-120,-120,-50>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-80,-120,-60>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-50,-120,-100>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-30,-120,-80>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3660
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,-30,-120,-120>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3660_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,-30,-120,-120>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3660
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,-30,-120,120>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3660_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,-30,-120,120>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-50,-120,120>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-60,-120,80>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-100,-120,50>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-80,-120,30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3660
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,-120,-120,30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3660_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,-120,-120,30>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3660
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,120,-120,30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3660_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,120,-120,30>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,120,-120,50>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,80,-120,60>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,50,-120,100>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,30,-120,80>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3660
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,30,-120,120>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3660_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,30,-120,120>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3660
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,30,-120,-120>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3660_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,30,-120,-120>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <0,0,-1,0,1,0,1,0,0,50,-120,-120>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3001
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,60,-120,-80>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3010
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(80, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,100,-120,-50>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3004
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 20, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,80,-120,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3660
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,120,-120,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3660_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,120,-120,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3003
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,-120,-144,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3039
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,-120,-144,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3039_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,-120,-144,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3046
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-70,-144,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3046_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-70,-144,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3045
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-70,-144,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3045_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-70,-144,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3046
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-30,-144,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3046_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-30,-144,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3039
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-30,-144,-120>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3039_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-30,-144,-120>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3003
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,0,-144,120>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3039
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-30,-144,120>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3039_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-30,-144,120>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3046
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,-30,-144,70>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3046_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,-30,-144,70>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3045
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,-70,-144,70>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3045_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,-70,-144,70>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3046
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,-70,-144,30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3046_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,-70,-144,30>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3039
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,-120,-144,30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3039_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,-120,-144,30>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3003
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,120,-144,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3039
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,120,-144,30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3039_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,120,-144,30>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3046
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,70,-144,30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3046_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,70,-144,30>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3045
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,70,-144,70>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3045_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,70,-144,70>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3046
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,30,-144,70>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3046_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,30,-144,70>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3039
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,30,-144,120>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3039_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,30,-144,120>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3003
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-144,-120>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3039
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,30,-144,-120>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3039_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,30,-144,-120>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3046
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,30,-144,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3046_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,30,-144,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3045
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,70,-144,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3045_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,70,-144,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3046
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,70,-144,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3046_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,70,-144,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3039
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,120,-144,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3039_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,120,-144,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3038
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,-110,-168,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3038_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,-110,-168,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3046
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-50,-168,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3046_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-50,-168,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3045
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-50,-168,-50>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3045_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-50,-168,-50>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3046
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-10,-168,-50>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3046_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-10,-168,-50>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3038
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 40, 0, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-10,-168,-110>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3038_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 40, 0, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-10,-168,-110>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3038
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 40, 0, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-10,-168,110>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3038_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 40, 0, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-10,-168,110>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3046
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,-10,-168,50>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3046_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,-10,-168,50>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3045
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,-50,-168,50>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3045_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,-50,-168,50>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3046
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,-50,-168,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3046_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,-50,-168,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3038
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 40, 0, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,-110,-168,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3038_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 40, 0, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,-110,-168,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3038
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 40, 0, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,110,-168,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3038_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 40, 0, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,110,-168,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3046
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,50,-168,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3046_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,50,-168,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3045
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,50,-168,50>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3045_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,50,-168,50>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3046
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,10,-168,50>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3046_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,10,-168,50>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3038
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 40, 0, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,10,-168,110>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3038_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 40, 0, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,10,-168,110>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3038
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 40, 0, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,10,-168,-110>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3038_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 40, 0, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,10,-168,-110>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3046
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,10,-168,-50>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3046_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,10,-168,-50>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3045
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,50,-168,-50>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3045_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,50,-168,-50>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3046
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,50,-168,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3046_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,50,-168,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3038
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,110,-168,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3038_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(60, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,110,-168,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3039
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-30,-192,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3039_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-30,-192,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3049b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 24, 40, 0, 12, 10)
		matrix <0,0,-1,0,1,0,1,0,0,-70,-192,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3049b_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 24, 40, 0, 12, 10)
		matrix <0,0,-1,0,1,0,1,0,0,-70,-192,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3043
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 24, 40, 0, 12, 0)
		matrix <1,0,0,0,1,0,0,0,1,-100,-192,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3043_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 24, 40, 0, 12, 0)
		matrix <1,0,0,0,1,0,0,0,1,-100,-192,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3048
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 24, 20, 0, 12, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-130,-192,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3048_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 24, 20, 0, 12, 0)
		matrix <0,0,-1,0,1,0,1,0,0,-130,-192,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3045
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-30,-192,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3045_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-30,-192,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3039
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,0,-192,30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3039_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,0,-192,30>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3049b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 24, 40, 0, 12, 10)
		matrix <-1,0,0,0,1,0,0,0,-1,0,-192,70>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3049b_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 24, 40, 0, 12, 10)
		matrix <-1,0,0,0,1,0,0,0,-1,0,-192,70>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3043
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 24, 40, 0, 12, 0)
		matrix <0,0,-1,0,1,0,1,0,0,0,-192,100>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3043_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 24, 40, 0, 12, 0)
		matrix <0,0,-1,0,1,0,1,0,0,0,-192,100>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3048
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 24, 20, 0, 12, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,0,-192,130>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3048_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 24, 20, 0, 12, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,0,-192,130>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3045
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,-30,-192,30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3045_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,-30,-192,30>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3039
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,30,-192,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3039_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,30,-192,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3049b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 24, 40, 0, 12, 10)
		matrix <0,0,1,0,1,0,-1,0,0,70,-192,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3049b_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 24, 40, 0, 12, 10)
		matrix <0,0,1,0,1,0,-1,0,0,70,-192,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3043
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 24, 40, 0, 12, 0)
		matrix <1,0,0,0,1,0,0,0,1,100,-192,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3043_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 24, 40, 0, 12, 0)
		matrix <1,0,0,0,1,0,0,0,1,100,-192,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3048
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 24, 20, 0, 12, 0)
		matrix <0,0,1,0,1,0,-1,0,0,130,-192,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3048_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 24, 20, 0, 12, 0)
		matrix <0,0,1,0,1,0,-1,0,0,130,-192,0>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3045
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,30,-192,30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3045_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,30,-192,30>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3039
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,0,-192,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3039_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,0,-192,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3049b
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 24, 40, 0, 12, 10)
		matrix <1,0,0,0,1,0,0,0,1,0,-192,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3049b_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 24, 40, 0, 12, 10)
		matrix <1,0,0,0,1,0,0,0,1,0,-192,-70>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3043
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 24, 40, 0, 12, 0)
		matrix <0,0,-1,0,1,0,1,0,0,0,-192,-100>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3043_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 24, 40, 0, 12, 0)
		matrix <0,0,-1,0,1,0,1,0,0,0,-192,-100>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3048
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 24, 20, 0, 12, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-192,-130>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3048_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 24, 20, 0, 12, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-192,-130>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3045
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,30,-192,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3045_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,30,-192,-30>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3045
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-10,-216,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3045_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,-1,0,1,0,1,0,0,-10,-216,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3045
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,-10,-216,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3045_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,-10,-216,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3045
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,10,-216,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3045_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <0,0,1,0,1,0,-1,0,0,10,-216,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3045
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,10,-216,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3045_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 10, 10, -10)
		matrix <1,0,0,0,1,0,0,0,1,10,-216,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3048
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 24, 20, 0, 12, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,0,-240,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3048_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 24, 20, 0, 12, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,0,-240,10>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
	object {
		lg_3048
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 24, 20, 0, 12, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-240,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4 }
	}
	object {
		lg_3048_slope
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 24, 20, 0, 12, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-240,-10>
		#if (version >= 3.1) material #else texture #end { LDXColor4_slope }
	}
}

#include "lg_3941.inc" // Brick  2 x  2 Round

#include "lg_3708.inc" // Technic Axle 12

#include "lg_2712.inc" // Technic Rotor  3 Blade

#include "lg_2423.inc" // Plant Leaves  4 x  3

#include "lg_4589.inc" // Cone  1 x  1

#include "lg_2417.inc" // Plant Leaves  6 x  5

#declare LDX_infrastructure_bigtree01_dot_ldr = union {
// Tree Mk1
// Name: infrastructure_bigtree01.ldr
// Author: Steve Bliss
// Unofficial Datsville Model
// ROTATION CENTER 0 0 0 1 "Custom"
// ROTATION CONFIG 0 0
	object {
		lg_3941
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-24,0>
		#if (version >= 3.1) material #else texture #end { LDXColor6 }
	}
	object {
		lg_3941
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-48,0>
		#if (version >= 3.1) material #else texture #end { LDXColor6 }
	}
	object {
		lg_3941
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-72,0>
		#if (version >= 3.1) material #else texture #end { LDXColor6 }
	}
	object {
		lg_3941
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(40, 28, 40, 0, 10, 0)
		matrix <1,0,0,0,1,0,0,0,1,0,-96,0>
		#if (version >= 3.1) material #else texture #end { LDXColor6 }
	}
	object {
		lg_3708
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(240, 12, 12, 0, 0, 0)
		matrix <0,1,0,-1,0,0,0,0,1,0,-192,0>
		#if (version >= 3.1) material #else texture #end { LDXColor6 }
	}
	object {
		lg_2712
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(89.114914, 12, 79.918839, 0.000383, 2, 10.04258)
		matrix <1,0,0,0,1,0,0,0,1,0,-112,0>
		#if (version >= 3.1) material #else texture #end { LDXColor6 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <-0.422,0,-0.906,0,1,0,0.906,0,-0.422,0,-104,40>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <-0.574,0,0.818,0,1,0,-0.818,0,-0.574,34.640999,-104,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <0.995,0,0.088,0,1,0,-0.088,0,0.995,-34.640999,-104,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <0.422,0,-0.906,0,-1,0,-0.906,0,-0.422,0,-112,40>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <-0.996,0,0.088,0,-1,0,0.088,0,0.996,34.640999,-112,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <0.574,0,0.819,0,-1,0,0.819,0,-0.574,-34.640999,-112,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2712
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(89.114914, 12, 79.918839, 0.000383, 2, 10.04258)
		matrix <-1,0,0,0,1,0,0,0,-1,0,-144,0>
		#if (version >= 3.1) material #else texture #end { LDXColor6 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <0.422,0,0.906,0,1,0,-0.906,0,0.422,0,-136,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <0.574,0,-0.818,0,1,0,0.818,0,0.574,-34.640999,-136,20>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <-0.995,0,-0.088,0,1,0,0.088,0,-0.995,34.640999,-136,20>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <-0.422,0,0.906,0,-1,0,0.906,0,0.422,0,-144,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <0.996,0,-0.088,0,-1,0,-0.088,0,-0.996,-34.640999,-144,20>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <-0.574,0,-0.819,0,-1,0,-0.819,0,0.574,34.640999,-144,20>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2712
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(89.114914, 12, 79.918839, 0.000383, 2, 10.04258)
		matrix <1,0,0,0,1,0,0,0,1,0,-176,0>
		#if (version >= 3.1) material #else texture #end { LDXColor6 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <-0.422,0,-0.906,0,1,0,0.906,0,-0.422,0,-168,40>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <-0.574,0,0.818,0,1,0,-0.818,0,-0.574,34.640999,-168,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <0.995,0,0.088,0,1,0,-0.088,0,0.995,-34.640999,-168,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <0.422,0,-0.906,0,-1,0,-0.906,0,-0.422,0,-176,40>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <-0.996,0,0.088,0,-1,0,0.088,0,0.996,34.640999,-176,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <0.574,0,0.819,0,-1,0,0.819,0,-0.574,-34.640999,-176,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2712
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(89.114914, 12, 79.918839, 0.000383, 2, 10.04258)
		matrix <-1,0,0,0,1,0,0,0,-1,0,-208,0>
		#if (version >= 3.1) material #else texture #end { LDXColor6 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <0.422,0,0.906,0,1,0,-0.906,0,0.422,0,-200,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <0.574,0,-0.818,0,1,0,0.818,0,0.574,-34.640999,-200,20>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <-0.995,0,-0.088,0,1,0,0.088,0,-0.995,34.640999,-200,20>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <-0.422,0,0.906,0,-1,0,0.906,0,0.422,0,-208,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <0.996,0,-0.088,0,-1,0,-0.088,0,-0.996,-34.640999,-208,20>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <-0.574,0,-0.819,0,-1,0,-0.819,0,0.574,34.640999,-208,20>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2712
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(89.114914, 12, 79.918839, 0.000383, 2, 10.04258)
		matrix <1,0,0,0,1,0,0,0,1,0,-232,0>
		#if (version >= 3.1) material #else texture #end { LDXColor6 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <-0.422,0,-0.906,0,1,0,0.906,0,-0.422,0,-224,40>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <-0.574,0,0.818,0,1,0,-0.818,0,-0.574,34.640999,-224,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <0.995,0,0.088,0,1,0,-0.088,0,0.995,-34.640999,-224,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <0.422,0,-0.906,0,-1,0,-0.906,0,-0.422,0,-232,40>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <-0.996,0,0.088,0,-1,0,0.088,0,0.996,34.640999,-232,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <0.574,0,0.819,0,-1,0,0.819,0,-0.574,-34.640999,-232,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2712
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(89.114914, 12, 79.918839, 0.000383, 2, 10.04258)
		matrix <-1,0,0,0,1,0,0,0,-1,0,-264,0>
		#if (version >= 3.1) material #else texture #end { LDXColor6 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <0.422,0,0.906,0,1,0,-0.906,0,0.422,0,-256,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <0.574,0,-0.818,0,1,0,0.818,0,0.574,-34.640999,-256,20>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <-0.995,0,-0.088,0,1,0,0.088,0,-0.995,34.640999,-256,20>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <-0.422,0,0.906,0,-1,0,0.906,0,0.422,0,-264,-40>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <0.996,0,-0.088,0,-1,0,-0.088,0,-0.996,-34.640999,-264,20>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <-0.574,0,-0.819,0,-1,0,-0.819,0,0.574,34.640999,-264,20>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2712
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(89.114914, 12, 79.918839, 0.000383, 2, 10.04258)
		matrix <1,0,0,0,1,0,0,0,1,0,-296,0>
		#if (version >= 3.1) material #else texture #end { LDXColor6 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <-0.422,0,-0.906,0,1,0,0.906,0,-0.422,0,-288,40>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <-0.574,0,0.818,0,1,0,-0.818,0,-0.574,34.640999,-288,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <0.995,0,0.088,0,1,0,-0.088,0,0.995,-34.640999,-288,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <0.422,0,-0.906,0,-1,0,-0.906,0,-0.422,0,-296,40>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <-0.996,0,0.088,0,-1,0,0.088,0,0.996,34.640999,-296,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_2423
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(52, 12, 78, 0, 2, -29)
		matrix <0.574,0,0.819,0,-1,0,0.819,0,-0.574,-34.640999,-296,-20>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
	object {
		lg_4589
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(20, 28, 20, 0, 10, 0)
		matrix <-1,0,0,0,1,0,0,0,-1,0,-320,0>
		#if (version >= 3.1) material #else texture #end { LDXColor6 }
	}
	object {
		lg_2417
		matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		LDXSeamMatrix(96, 12, 116, 0, 2, -10)
		matrix <-1,0,0,0,1,0,0,0,-1,0,-328,0>
		#if (version >= 3.1) material #else texture #end { LDXColor288 }
	}
}

#declare LDX_stug_dash_2x2_dot_dat_in_part = union {
// Stud Group  2 x  2
// Name: stug-2x2.dat
// Author: Steffen [Steffen]
// !LDRAW_ORG Primitive UPDATE 2012-01
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CCW
// !HISTORY 2005-12-28 [PTadmin] Official Update 2005-01
// !HISTORY 2007-05-04 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
// !HISTORY 2011-07-01 [PTadmin] Renamed from stug2
// !HISTORY 2011-07-25 [PTadmin] Official Update 2011-01
// !HISTORY 2012-02-16 [Philo] Changed to CCW
// !HISTORY 2012-03-30 [PTadmin] Official Update 2012-01
	#if (LDXStuds)
		object {
			lg_knob
			matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		matrix <1,0,0,0,1,0,0,0,1,-10,0,-10>
		}
		object {
			lg_knob
			matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		matrix <1,0,0,0,1,0,0,0,1,10,0,-10>
		}
		object {
			lg_knob
			matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		matrix <1,0,0,0,1,0,0,0,1,-10,0,10>
		}
		object {
			lg_knob
			matrix <0,0,-25,-25,0,0,0,-25,0,0,0,0>
		matrix <1,0,0,0,1,0,0,0,1,10,0,10>
		}
	#end // LDXStuds
}

#declare LDX_stug_dash_4x4_dot_dat_in_part = union {
// Stud Group  4 x  4
// Name: stug-4x4.dat
// Author: Tore Eriksson [Tore_Eriksson]
// !LDRAW_ORG Primitive UPDATE 2011-01
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CCW
// !HISTORY 2004-10-31 [Steffen] used stug2.dat
// !HISTORY 2005-12-28 [PTadmin] Official Update 2005-01
// !HISTORY 2007-05-04 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
// !HISTORY 2011-07-01 [PTadmin] Renamed from stug4
// !HISTORY 2011-07-25 [PTadmin] Official Update 2011-01
	#if (LDXStuds)
		object {
			LDX_stug_dash_2x2_dot_dat_in_part
			matrix <1,0,0,0,1,0,0,0,1,-20,0,-20>
		}
		object {
			LDX_stug_dash_2x2_dot_dat_in_part
			matrix <1,0,0,0,1,0,0,0,1,-20,0,20>
		}
		object {
			LDX_stug_dash_2x2_dot_dat_in_part
			matrix <1,0,0,0,1,0,0,0,1,20,0,20>
		}
		object {
			LDX_stug_dash_2x2_dot_dat_in_part
			matrix <1,0,0,0,1,0,0,0,1,20,0,-20>
		}
	#end // LDXStuds
}

#declare LDX_stug_dash_8x8_dot_dat_in_part = union {
// Stud Group  8 x  8
// Name: stug-8x8.dat
// Author: Tore Eriksson [Tore_Eriksson]
// !LDRAW_ORG Primitive UPDATE 2011-01
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CCW
// !HISTORY 2005-12-28 [PTadmin] Official Update 2005-01
// !HISTORY 2007-05-04 [PTadmin] Header formatted for Contributor Agreement
// !HISTORY 2008-07-01 [PTadmin] Official Update 2008-01
// !HISTORY 2011-07-01 [PTadmin] Renamed from stug8
// !HISTORY 2011-07-25 [PTadmin] Official Update 2011-01
	#if (LDXStuds)
		object {
			LDX_stug_dash_4x4_dot_dat_in_part
			matrix <1,0,0,0,1,0,0,0,1,-40,0,-40>
		}
		object {
			LDX_stug_dash_4x4_dot_dat_in_part
			matrix <1,0,0,0,1,0,0,0,1,-40,0,40>
		}
		object {
			LDX_stug_dash_4x4_dot_dat_in_part
			matrix <1,0,0,0,1,0,0,0,1,40,0,-40>
		}
		object {
			LDX_stug_dash_4x4_dot_dat_in_part
			matrix <1,0,0,0,1,0,0,0,1,40,0,40>
		}
	#end // LDXStuds
}

#declare LDX_stug8_dot_dat_in_part = union {
// ~Moved to stug-8x8
// Name: stug8.dat
// Author: [PTadmin]
// !LDRAW_ORG Primitive UPDATE 2011-01
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CCW
// !HISTORY 2011-07-25 [PTadmin] Official Update 2011-01
// // Stud Group  8 x  8
	#if (LDXStuds)
		object {
			LDX_stug_dash_8x8_dot_dat_in_part
			matrix <1,0,0,0,1,0,0,0,1,0,0,0>
		}
	#end // LDXStuds
}

#declare LDX_1_dash_4ring3_dot_dat_in_part = disc // Ring 0.25
{
	<0,0,0>,<0,1,0>,4,3
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
	}
}

#declare LDX_1_dash_4ring3_dot_dat = disc // Ring 0.25
{
	<0,0,0>,<0,1,0>,4,3
	clipped_by
	{
		plane
		{
			<0,0,-1>,0
		}
		plane
		{
			<-1,0,0>,0
		}
	}
}

#declare LDX_s_slash_91405s01_dot_dat_in_part = union {
// ~Plate 16 x 16 Rib with 1 Quarter Stud
// Name: s\91405s01.dat
// Author: Donald Sutter [technog]
// !LDRAW_ORG Subpart UPDATE 2010-03
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CCW
// !HISTORY 2010-12-31 [PTadmin] Official Update 2010-03
	object {
		LDX_1_dash_4ring3_dot_dat_in_part
		matrix <1.414,0,-1.414,0,1,0,1.414,0,1.414,-20,-4,0>
	}
// BFC INVERTNEXT
	object {
		LDX_1_dash_4cyli_dot_dat_in_part
		matrix <4.243,0,-4.243,0,4,0,4.243,0,4.243,-20,-4,0>
	}
// BFC INVERTNEXT
// BFC INVERTNEXT
}

#declare LDX_s_slash_91405s02_dot_dat_in_part = union {
// ~Plate 16 x 16 Rib with 2 Quarter Studs
// Name: s\91405s02.dat
// Author: Donald Sutter [technog]
// !LDRAW_ORG Subpart UPDATE 2010-03
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CCW
// !HISTORY 2010-12-31 [PTadmin] Official Update 2010-03
	object {
		LDX_1_dash_4ring3_dot_dat_in_part
		matrix <1.414,0,-1.414,0,1,0,1.414,0,1.414,-20,-4,0>
	}
// BFC INVERTNEXT
	object {
		LDX_1_dash_4cyli_dot_dat_in_part
		matrix <4.243,0,-4.243,0,4,0,4.243,0,4.243,-20,-4,0>
	}
	object {
		LDX_1_dash_4ring3_dot_dat_in_part
		matrix <-1.414,0,1.414,0,1,0,-1.414,0,-1.414,20,-4,0>
	}
// BFC INVERTNEXT
	object {
		LDX_1_dash_4cyli_dot_dat_in_part
		matrix <-4.243,0,4.243,0,4,0,-4.243,0,-4.243,20,-4,0>
	}
// BFC INVERTNEXT
// BFC INVERTNEXT
// BFC INVERTNEXT
// BFC INVERTNEXT
}

#declare LDX_91405_dot_dat =
#if (LDXQual = 0)
box {
	<-160,-4,-160>,<160,8,160>
}
#else
union {
// Plate 16 x 16 with Underside Ribs
// Name: 91405.dat
// Author: Donald Sutter [technog]
// !LDRAW_ORG Part UPDATE 2010-03
// !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt
// BFC CERTIFY CCW
// !HISTORY 2010-12-31 [PTadmin] Official Update 2010-03
	#if (LDXStuds)
		object {
			LDX_stug8_dot_dat_in_part
			matrix <1,0,0,0,1,0,0,0,1,-80,0,80>
		}
		object {
			LDX_stug8_dot_dat_in_part
			matrix <1,0,0,0,1,0,0,0,1,80,0,80>
		}
		object {
			LDX_stug8_dot_dat_in_part
			matrix <1,0,0,0,1,0,0,0,1,80,0,-80>
		}
		object {
			LDX_stug8_dot_dat_in_part
			matrix <1,0,0,0,1,0,0,0,1,-80,0,-80>
		}
	#end // LDXStuds
// BFC INVERTNEXT
// BFC INVERTNEXT
// BFC INVERTNEXT
// BFC INVERTNEXT
	#if (LDXStuds)
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-140,4,140>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-100,4,140>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-60,4,140>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-20,4,140>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,20,4,140>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,60,4,140>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,100,4,140>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,140,4,140>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-140,4,100>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-100,4,100>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-60,4,100>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-20,4,100>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,20,4,100>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,60,4,100>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,100,4,100>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,140,4,100>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-140,4,60>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-100,4,60>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-60,4,60>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-20,4,60>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,20,4,60>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,60,4,60>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,100,4,60>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,140,4,60>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-140,4,20>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-100,4,20>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-60,4,20>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-20,4,20>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,20,4,20>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,60,4,20>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,100,4,20>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,140,4,20>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-140,4,-20>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-100,4,-20>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-60,4,-20>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-20,4,-20>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,20,4,-20>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,60,4,-20>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,100,4,-20>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,140,4,-20>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-140,4,-60>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-100,4,-60>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-60,4,-60>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-20,4,-60>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,20,4,-60>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,60,4,-60>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,100,4,-60>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,140,4,-60>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-140,4,-100>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-100,4,-100>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-60,4,-100>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-20,4,-100>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,20,4,-100>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,60,4,-100>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,100,4,-100>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,140,4,-100>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-140,4,-140>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-100,4,-140>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-60,4,-140>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,-20,4,-140>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,20,4,-140>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,60,4,-140>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,100,4,-140>
		}
		object {
			LDX_stud4_dot_dat_in_part
			matrix <1,0,0,0,-1,0,0,0,1,140,4,-140>
		}
	#end // LDXStuds
	object {
		LDX_s_slash_91405s01_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,-120,4,140>
	}
	object {
		LDX_s_slash_91405s01_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,-80,4,140>
	}
	object {
		LDX_s_slash_91405s01_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,-40,4,140>
	}
	object {
		LDX_s_slash_91405s01_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,0,4,140>
	}
	object {
		LDX_s_slash_91405s01_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,40,4,140>
	}
	object {
		LDX_s_slash_91405s01_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,80,4,140>
	}
	object {
		LDX_s_slash_91405s01_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,120,4,140>
	}
	object {
		LDX_s_slash_91405s01_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,140,4,120>
	}
	object {
		LDX_s_slash_91405s01_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,140,4,80>
	}
	object {
		LDX_s_slash_91405s01_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,140,4,40>
	}
	object {
		LDX_s_slash_91405s01_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,140,4,0>
	}
	object {
		LDX_s_slash_91405s01_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,140,4,-40>
	}
	object {
		LDX_s_slash_91405s01_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,140,4,-80>
	}
	object {
		LDX_s_slash_91405s01_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,140,4,-120>
	}
	object {
		LDX_s_slash_91405s01_dot_dat_in_part
		matrix <0,0,-1,0,-1,0,1,0,0,120,4,-140>
	}
	object {
		LDX_s_slash_91405s01_dot_dat_in_part
		matrix <0,0,-1,0,-1,0,1,0,0,80,4,-140>
	}
	object {
		LDX_s_slash_91405s01_dot_dat_in_part
		matrix <0,0,-1,0,-1,0,1,0,0,40,4,-140>
	}
	object {
		LDX_s_slash_91405s01_dot_dat_in_part
		matrix <0,0,-1,0,-1,0,1,0,0,0,4,-140>
	}
	object {
		LDX_s_slash_91405s01_dot_dat_in_part
		matrix <0,0,-1,0,-1,0,1,0,0,-40,4,-140>
	}
	object {
		LDX_s_slash_91405s01_dot_dat_in_part
		matrix <0,0,-1,0,-1,0,1,0,0,-80,4,-140>
	}
	object {
		LDX_s_slash_91405s01_dot_dat_in_part
		matrix <0,0,-1,0,-1,0,1,0,0,-120,4,-140>
	}
	object {
		LDX_s_slash_91405s01_dot_dat_in_part
		matrix <-1,0,0,0,-1,0,0,0,-1,-140,4,-120>
	}
	object {
		LDX_s_slash_91405s01_dot_dat_in_part
		matrix <-1,0,0,0,-1,0,0,0,-1,-140,4,-80>
	}
	object {
		LDX_s_slash_91405s01_dot_dat_in_part
		matrix <-1,0,0,0,-1,0,0,0,-1,-140,4,-40>
	}
	object {
		LDX_s_slash_91405s01_dot_dat_in_part
		matrix <-1,0,0,0,-1,0,0,0,-1,-140,4,0>
	}
	object {
		LDX_s_slash_91405s01_dot_dat_in_part
		matrix <-1,0,0,0,-1,0,0,0,-1,-140,4,40>
	}
	object {
		LDX_s_slash_91405s01_dot_dat_in_part
		matrix <-1,0,0,0,-1,0,0,0,-1,-140,4,80>
	}
	object {
		LDX_s_slash_91405s01_dot_dat_in_part
		matrix <-1,0,0,0,-1,0,0,0,-1,-140,4,120>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,-100,4,-120>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,-60,4,-120>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,-20,4,-120>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,20,4,-120>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,60,4,-120>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,100,4,-120>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,-100,4,-80>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,-60,4,-80>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,-20,4,-80>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,20,4,-80>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,60,4,-80>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,100,4,-80>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,-100,4,-40>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,-60,4,-40>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,-20,4,-40>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,20,4,-40>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,60,4,-40>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,100,4,-40>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,-100,4,0>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,-60,4,0>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,-20,4,0>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,20,4,0>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,60,4,0>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,100,4,0>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,-100,4,40>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,-60,4,40>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,-20,4,40>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,20,4,40>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,60,4,40>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,100,4,40>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,-100,4,80>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,-60,4,80>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,-20,4,80>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,20,4,80>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,60,4,80>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,100,4,80>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,-100,4,120>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,-60,4,120>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,-20,4,120>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,20,4,120>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,60,4,120>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <1,0,0,0,-1,0,0,0,1,100,4,120>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,120,4,-100>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,120,4,-60>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,120,4,-20>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,120,4,20>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,120,4,60>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,120,4,100>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,80,4,-100>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,80,4,-60>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,80,4,-20>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,80,4,20>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,80,4,60>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,80,4,100>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,40,4,-100>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,40,4,-60>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,40,4,-20>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,40,4,20>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,40,4,60>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,40,4,100>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,0,4,-100>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,0,4,-60>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,0,4,-20>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,0,4,20>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,0,4,60>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,0,4,100>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,-40,4,-100>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,-40,4,-60>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,-40,4,-20>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,-40,4,20>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,-40,4,60>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,-40,4,100>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,-80,4,-100>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,-80,4,-60>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,-80,4,-20>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,-80,4,20>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,-80,4,60>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,-80,4,100>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,-120,4,-100>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,-120,4,-60>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,-120,4,-20>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,-120,4,20>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,-120,4,60>
	}
	object {
		LDX_s_slash_91405s02_dot_dat_in_part
		matrix <0,0,1,0,-1,0,-1,0,0,-120,4,100>
	}
	mesh2 {
		vertex_vectors {
			6064,
			<-160,0,-160>, <-160,0,160>, <-160,8,-160>, <-160,8,160>,
			<-156,4,-156>, <-156,4,-121>, <-156,4,-119>, <-156,4,-81>,
			<-156,4,-79>, <-156,4,-41>, <-156,4,-39>, <-156,4,-1>,
			<-156,4,1>, <-156,4,39>, <-156,4,41>, <-156,4,79>,
			<-156,4,81>, <-156,4,119>, <-156,4,121>, <-156,4,156>,
			<-156,8,-156>, <-156,8,-121>, <-156,8,-120>, <-156,8,-119>,
			<-156,8,-81>, <-156,8,-80>, <-156,8,-79>, <-156,8,-41>,
			<-156,8,-40>, <-156,8,-39>, <-156,8,-1>, <-156,8,0>,
			<-156,8,1>, <-156,8,39>, <-156,8,40>, <-156,8,41>,
			<-156,8,79>, <-156,8,80>, <-156,8,81>, <-156,8,119>,
			<-156,8,120>, <-156,8,121>, <-156,8,156>, <-151,4,-124>,
			<-151,4,-121>, <-151,4,-119>, <-151,4,-116>, <-151,4,-84>,
			<-151,4,-81>, <-151,4,-79>, <-151,4,-76>, <-151,4,-44>,
			<-151,4,-41>, <-151,4,-39>, <-151,4,-36>, <-151,4,-4>,
			<-151,4,-1>, <-151,4,1>, <-151,4,4>, <-151,4,36>,
			<-151,4,39>, <-151,4,41>, <-151,4,44>, <-151,4,76>,
			<-151,4,79>, <-151,4,81>, <-151,4,84>, <-151,4,116>,
			<-151,4,119>, <-151,4,121>, <-151,4,124>, <-151,8,-124>,
			<-151,8,-121>, <-151,8,-119>, <-151,8,-116>, <-151,8,-84>,
			<-151,8,-81>, <-151,8,-79>, <-151,8,-76>, <-151,8,-44>,
			<-151,8,-41>, <-151,8,-39>, <-151,8,-36>, <-151,8,-4>,
			<-151,8,-1>, <-151,8,1>, <-151,8,4>, <-151,8,36>,
			<-151,8,39>, <-151,8,41>, <-151,8,44>, <-151,8,76>,
			<-151,8,79>, <-151,8,81>, <-151,8,84>, <-151,8,116>,
			<-151,8,119>, <-151,8,121>, <-151,8,124>, <-149,4,-124>,
			<-149,4,-121>, <-149,4,-119>, <-149,4,-116>, <-149,4,-84>,
			<-149,4,-81>, <-149,4,-79>, <-149,4,-76>, <-149,4,-44>,
			<-149,4,-41>, <-149,4,-39>, <-149,4,-36>, <-149,4,-4>,
			<-149,4,-1>, <-149,4,1>, <-149,4,4>, <-149,4,36>,
			<-149,4,39>, <-149,4,41>, <-149,4,44>, <-149,4,76>,
			<-149,4,79>, <-149,4,81>, <-149,4,84>, <-149,4,116>,
			<-149,4,119>, <-149,4,121>, <-149,4,124>, <-149,8,-124>,
			<-149,8,-121>, <-149,8,-119>, <-149,8,-116>, <-149,8,-84>,
			<-149,8,-81>, <-149,8,-79>, <-149,8,-76>, <-149,8,-44>,
			<-149,8,-41>, <-149,8,-39>, <-149,8,-36>, <-149,8,-4>,
			<-149,8,-1>, <-149,8,1>, <-149,8,4>, <-149,8,36>,
			<-149,8,39>, <-149,8,41>, <-149,8,44>, <-149,8,76>,
			<-149,8,79>, <-149,8,81>, <-149,8,84>, <-149,8,116>,
			<-149,8,119>, <-149,8,121>, <-149,8,124>, <-131,4,-124>,
			<-131,4,-121>, <-131,4,-119>, <-131,4,-116>, <-131,4,-84>,
			<-131,4,-81>, <-131,4,-79>, <-131,4,-76>, <-131,4,-44>,
			<-131,4,-41>, <-131,4,-39>, <-131,4,-36>, <-131,4,-4>,
			<-131,4,-1>, <-131,4,1>, <-131,4,4>, <-131,4,36>,
			<-131,4,39>, <-131,4,41>, <-131,4,44>, <-131,4,76>,
			<-131,4,79>, <-131,4,81>, <-131,4,84>, <-131,4,116>,
			<-131,4,119>, <-131,4,121>, <-131,4,124>, <-131,8,-124>,
			<-131,8,-121>, <-131,8,-119>, <-131,8,-116>, <-131,8,-84>,
			<-131,8,-81>, <-131,8,-79>, <-131,8,-76>, <-131,8,-44>,
			<-131,8,-41>, <-131,8,-39>, <-131,8,-36>, <-131,8,-4>,
			<-131,8,-1>, <-131,8,1>, <-131,8,4>, <-131,8,36>,
			<-131,8,39>, <-131,8,41>, <-131,8,44>, <-131,8,76>,
			<-131,8,79>, <-131,8,81>, <-131,8,84>, <-131,8,116>,
			<-131,8,119>, <-131,8,121>, <-131,8,124>, <-129,4,-124>,
			<-129,4,-121>, <-129,4,-119>, <-129,4,-116>, <-129,4,-84>,
			<-129,4,-81>, <-129,4,-79>, <-129,4,-76>, <-129,4,-44>,
			<-129,4,-41>, <-129,4,-39>, <-129,4,-36>, <-129,4,-4>,
			<-129,4,-1>, <-129,4,-1>, <-129,4,1>, <-129,4,1>,
			<-129,4,4>, <-129,4,36>, <-129,4,39>, <-129,4,41>,
			<-129,4,44>, <-129,4,76>, <-129,4,79>, <-129,4,81>,
			<-129,4,84>, <-129,4,116>, <-129,4,119>, <-129,4,121>,
			<-129,4,124>, <-129,8,-124>, <-129,8,-121>, <-129,8,-119>,
			<-129,8,-116>, <-129,8,-84>, <-129,8,-81>, <-129,8,-79>,
			<-129,8,-76>, <-129,8,-44>, <-129,8,-41>, <-129,8,-39>,
			<-129,8,-36>, <-129,8,-4>, <-129,8,-1>, <-129,8,-1>,
			<-129,8,1>, <-129,8,1>, <-129,8,4>, <-129,8,36>,
			<-129,8,39>, <-129,8,41>, <-129,8,44>, <-129,8,76>,
			<-129,8,79>, <-129,8,81>, <-129,8,84>, <-129,8,116>,
			<-129,8,119>, <-129,8,121>, <-129,8,124>, <-128,8,-120>,
			<-128,8,-80>, <-128,8,-40>, <-128,8,0>, <-128,8,40>,
			<-128,8,80>, <-128,8,120>, <-127.800995,4,-121>, <-127.800995,4,-119>,
			<-127.800995,4,-81>, <-127.800995,4,-79>, <-127.800995,4,-41>, <-127.800995,4,-39>,
			<-127.800995,4,-1>, <-127.800995,4,1>, <-127.800995,4,39>, <-127.800995,4,41>,
			<-127.800995,4,79>, <-127.800995,4,81>, <-127.800995,4,119>, <-127.800995,4,121>,
			<-127.801003,8,-121>, <-127.801003,8,-119>, <-127.801003,8,-81>, <-127.801003,8,-79>,
			<-127.801003,8,-41>, <-127.801003,8,-39>, <-127.801003,8,-1>, <-127.800995,8,-1>,
			<-127.801003,8,1>, <-127.800995,8,1>, <-127.801003,8,39>, <-127.801003,8,41>,
			<-127.801003,8,79>, <-127.801003,8,81>, <-127.801003,8,119>, <-127.801003,8,121>,
			<-127.390999,4,-123.061005>, <-127.390999,4,-116.938995>, <-127.390999,4,-83.061005>, <-127.390999,4,-76.938995>,
			<-127.390999,4,-43.060997>, <-127.390999,4,-36.939003>, <-127.390999,4,-3.061>, <-127.390999,4,3.061>,
			<-127.390999,4,36.939003>, <-127.390999,4,43.060997>, <-127.390999,4,76.938995>, <-127.390999,4,83.061005>,
			<-127.390999,4,116.938995>, <-127.390999,4,123.061005>, <-127.390999,8,-123.061005>, <-127.390999,8,-116.938995>,
			<-127.390999,8,-83.061005>, <-127.390999,8,-76.938995>, <-127.390999,8,-43.060997>, <-127.390999,8,-36.939003>,
			<-127.390999,8,-3.061>, <-127.390999,8,3.061>, <-127.390999,8,36.939003>, <-127.390999,8,43.060997>,
			<-127.390999,8,76.938995>, <-127.390999,8,83.061005>, <-127.390999,8,116.938995>, <-127.390999,8,123.061005>,
			<-125.656998,4,-125.657005>, <-125.657005,4,-114.343002>, <-125.657005,4,-85.656998>, <-125.657005,4,-74.343002>,
			<-125.657005,4,-45.657001>, <-125.657005,4,-34.342999>, <-125.657005,4,-5.657>, <-125.657005,4,5.657>,
			<-125.657005,4,34.342999>, <-125.657005,4,45.657001>, <-125.657005,4,74.343002>, <-125.657005,4,85.656998>,
			<-125.657005,4,114.343002>, <-125.656998,4,125.657005>, <-125.656998,8,-125.657005>, <-125.657005,8,-114.343002>,
			<-125.657005,8,-85.656998>, <-125.657005,8,-74.343002>, <-125.657005,8,-45.657001>, <-125.657005,8,-34.342999>,
			<-125.657005,8,-5.657>, <-125.657005,8,5.657>, <-125.657005,8,34.342999>, <-125.657005,8,45.657001>,
			<-125.657005,8,74.343002>, <-125.657005,8,85.656998>, <-125.657005,8,114.343002>, <-125.656998,8,125.657005>,
			<-124,4,-151>, <-124,4,-149>, <-124,4,-131>, <-124,4,-129>,
			<-124,4,-111>, <-124,4,-109>, <-124,4,-91>, <-124,4,-89>,
			<-124,4,-71>, <-124,4,-69>, <-124,4,-51>, <-124,4,-49>,
			<-124,4,-31>, <-124,4,-29>, <-124,4,-11>, <-124,4,-9>,
			<-124,4,9>, <-124,4,11>, <-124,4,29>, <-124,4,31>,
			<-124,4,49>, <-124,4,51>, <-124,4,69>, <-124,4,71>,
			<-124,4,89>, <-124,4,91>, <-124,4,109>, <-124,4,111>,
			<-124,4,129>, <-124,4,131>, <-124,4,149>, <-124,4,151>,
			<-124,8,-151>, <-124,8,-149>, <-124,8,-131>, <-124,8,-129>,
			<-124,8,-111>, <-124,8,-109>, <-124,8,-91>, <-124,8,-89>,
			<-124,8,-71>, <-124,8,-69>, <-124,8,-51>, <-124,8,-49>,
			<-124,8,-31>, <-124,8,-29>, <-124,8,-11>, <-124,8,-9>,
			<-124,8,9>, <-124,8,11>, <-124,8,29>, <-124,8,31>,
			<-124,8,49>, <-124,8,51>, <-124,8,69>, <-124,8,71>,
			<-124,8,89>, <-124,8,91>, <-124,8,109>, <-124,8,111>,
			<-124,8,129>, <-124,8,131>, <-124,8,149>, <-124,8,151>,
			<-123.061005,4,-127.390999>, <-123.061005,4,-112.608994>, <-123.061005,4,-87.391006>, <-123.061005,4,-72.608994>,
			<-123.061005,4,-47.390999>, <-123.061005,4,-32.609001>, <-123.061005,4,-7.391>, <-123.061005,4,7.391>,
			<-123.061005,4,32.609001>, <-123.061005,4,47.390999>, <-123.061005,4,72.608994>, <-123.061005,4,87.391006>,
			<-123.061005,4,112.608994>, <-123.061005,4,127.390999>, <-123.061005,8,-127.390999>, <-123.061005,8,-112.608994>,
			<-123.061005,8,-87.391006>, <-123.061005,8,-72.608994>, <-123.061005,8,-47.390999>, <-123.061005,8,-32.609001>,
			<-123.061005,8,-7.391>, <-123.061005,8,7.391>, <-123.061005,8,32.609001>, <-123.061005,8,47.390999>,
			<-123.061005,8,72.608994>, <-123.061005,8,87.391006>, <-123.061005,8,112.608994>, <-123.061005,8,127.390999>,
			<-121,4,-156>, <-121,4,-151>, <-121,4,-149>, <-121,4,-131>,
			<-121,4,-129>, <-121,4,-127.800995>, <-121,4,-112.198997>, <-121,4,-111>,
			<-121,4,-109>, <-121,4,-91>, <-121,4,-89>, <-121,4,-87.801003>,
			<-121,4,-72.198997>, <-121,4,-71>, <-121,4,-69>, <-121,4,-51>,
			<-121,4,-49>, <-121,4,-47.800999>, <-121,4,-32.199001>, <-121,4,-31>,
			<-121,4,-29>, <-121,4,-11>, <-121,4,-9>, <-121,4,-7.801001>,
			<-121,4,7.801001>, <-121,4,9>, <-121,4,11>, <-121,4,29>,
			<-121,4,31>, <-121,4,32.199001>, <-121,4,47.800999>, <-121,4,49>,
			<-121,4,51>, <-121,4,69>, <-121,4,71>, <-121,4,72.198997>,
			<-121,4,87.801003>, <-121,4,89>, <-121,4,91>, <-121,4,109>,
			<-121,4,111>, <-121,4,112.198997>, <-121,4,127.800995>, <-121,4,129>,
			<-121,4,131>, <-121,4,149>, <-121,4,151>, <-121,4,156>,
			<-121,8,-156>, <-121,8,-151>, <-121,8,-149>, <-121,8,-131>,
			<-121,8,-129>, <-121,8,-127.801003>, <-121,8,-112.198997>, <-121,8,-111>,
			<-121,8,-109>, <-121,8,-91>, <-121,8,-89>, <-121,8,-87.801003>,
			<-121,8,-72.198997>, <-121,8,-71>, <-121,8,-69>, <-121,8,-51>,
			<-121,8,-49>, <-121,8,-47.800999>, <-121,8,-32.199001>, <-121,8,-31>,
			<-121,8,-29>, <-121,8,-11>, <-121,8,-9>, <-121,8,-7.801>,
			<-121,8,7.801>, <-121,8,9>, <-121,8,11>, <-121,8,29>,
			<-121,8,31>, <-121,8,32.199001>, <-121,8,47.800999>, <-121,8,49>,
			<-121,8,51>, <-121,8,69>, <-121,8,71>, <-121,8,72.198997>,
			<-121,8,87.801003>, <-121,8,89>, <-121,8,91>, <-121,8,109>,
			<-121,8,111>, <-121,8,112.198997>, <-121,8,127.801003>, <-121,8,129>,
			<-121,8,131>, <-121,8,149>, <-121,8,151>, <-121,8,156>,
			<-120,8,-156>, <-120,8,-128>, <-120,8,-112>, <-120,8,-88>,
			<-120,8,-72>, <-120,8,-48>, <-120,8,-32>, <-120,8,-8>,
			<-120,8,8>, <-120,8,32>, <-120,8,48>, <-120,8,72>,
			<-120,8,88>, <-120,8,112>, <-120,8,128>, <-120,8,156>,
			<-119,4,-156>, <-119,4,-151>, <-119,4,-149>, <-119,4,-131>,
			<-119,4,-129>, <-119,4,-127.800995>, <-119,4,-112.198997>, <-119,4,-111>,
			<-119,4,-109>, <-119,4,-91>, <-119,4,-89>, <-119,4,-87.801003>,
			<-119,4,-72.198997>, <-119,4,-71>, <-119,4,-69>, <-119,4,-51>,
			<-119,4,-49>, <-119,4,-47.800999>, <-119,4,-32.199001>, <-119,4,-31>,
			<-119,4,-29>, <-119,4,-11>, <-119,4,-9>, <-119,4,-7.801001>,
			<-119,4,7.801001>, <-119,4,9>, <-119,4,11>, <-119,4,29>,
			<-119,4,31>, <-119,4,32.199001>, <-119,4,47.800999>, <-119,4,49>,
			<-119,4,51>, <-119,4,69>, <-119,4,71>, <-119,4,72.198997>,
			<-119,4,87.801003>, <-119,4,89>, <-119,4,91>, <-119,4,109>,
			<-119,4,111>, <-119,4,112.198997>, <-119,4,127.800995>, <-119,4,129>,
			<-119,4,131>, <-119,4,149>, <-119,4,151>, <-119,4,156>,
			<-119,8,-156>, <-119,8,-151>, <-119,8,-149>, <-119,8,-131>,
			<-119,8,-129>, <-119,8,-127.801003>, <-119,8,-112.198997>, <-119,8,-111>,
			<-119,8,-109>, <-119,8,-91>, <-119,8,-89>, <-119,8,-87.801003>,
			<-119,8,-72.198997>, <-119,8,-71>, <-119,8,-69>, <-119,8,-51>,
			<-119,8,-49>, <-119,8,-47.800999>, <-119,8,-32.199001>, <-119,8,-31>,
			<-119,8,-29>, <-119,8,-11>, <-119,8,-9>, <-119,8,-7.801>,
			<-119,8,7.801>, <-119,8,9>, <-119,8,11>, <-119,8,29>,
			<-119,8,31>, <-119,8,32.199001>, <-119,8,47.800999>, <-119,8,49>,
			<-119,8,51>, <-119,8,69>, <-119,8,71>, <-119,8,72.198997>,
			<-119,8,87.801003>, <-119,8,89>, <-119,8,91>, <-119,8,109>,
			<-119,8,111>, <-119,8,112.198997>, <-119,8,127.801003>, <-119,8,129>,
			<-119,8,131>, <-119,8,149>, <-119,8,151>, <-119,8,156>,
			<-116.938995,4,-127.390999>, <-116.938995,4,-112.608994>, <-116.938995,4,-87.391006>, <-116.938995,4,-72.608994>,
			<-116.938995,4,-47.390999>, <-116.938995,4,-32.609001>, <-116.938995,4,-7.391>, <-116.938995,4,7.391>,
			<-116.938995,4,32.609001>, <-116.938995,4,47.390999>, <-116.938995,4,72.608994>, <-116.938995,4,87.391006>,
			<-116.938995,4,112.608994>, <-116.938995,4,127.390999>, <-116.938995,8,-127.390999>, <-116.938995,8,-112.608994>,
			<-116.938995,8,-87.391006>, <-116.938995,8,-72.608994>, <-116.938995,8,-47.390999>, <-116.938995,8,-32.609001>,
			<-116.938995,8,-7.391>, <-116.938995,8,7.391>, <-116.938995,8,32.609001>, <-116.938995,8,47.390999>,
			<-116.938995,8,72.608994>, <-116.938995,8,87.391006>, <-116.938995,8,112.608994>, <-116.938995,8,127.390999>,
			<-116,4,-151>, <-116,4,-149>, <-116,4,-131>, <-116,4,-129>,
			<-116,4,-111>, <-116,4,-109>, <-116,4,-91>, <-116,4,-89>,
			<-116,4,-71>, <-116,4,-69>, <-116,4,-51>, <-116,4,-49>,
			<-116,4,-31>, <-116,4,-29>, <-116,4,-11>, <-116,4,-9>,
			<-116,4,9>, <-116,4,11>, <-116,4,29>, <-116,4,31>,
			<-116,4,49>, <-116,4,51>, <-116,4,69>, <-116,4,71>,
			<-116,4,89>, <-116,4,91>, <-116,4,109>, <-116,4,111>,
			<-116,4,129>, <-116,4,131>, <-116,4,149>, <-116,4,151>,
			<-116,8,-151>, <-116,8,-149>, <-116,8,-131>, <-116,8,-129>,
			<-116,8,-111>, <-116,8,-109>, <-116,8,-91>, <-116,8,-89>,
			<-116,8,-71>, <-116,8,-69>, <-116,8,-51>, <-116,8,-49>,
			<-116,8,-31>, <-116,8,-29>, <-116,8,-11>, <-116,8,-9>,
			<-116,8,9>, <-116,8,11>, <-116,8,29>, <-116,8,31>,
			<-116,8,49>, <-116,8,51>, <-116,8,69>, <-116,8,71>,
			<-116,8,89>, <-116,8,91>, <-116,8,109>, <-116,8,111>,
			<-116,8,129>, <-116,8,131>, <-116,8,149>, <-116,8,151>,
			<-114.343002,4,-125.657005>, <-114.342995,4,-114.343002>, <-114.342995,4,-85.656998>, <-114.342995,4,-74.343002>,
			<-114.342995,4,-45.657001>, <-114.342995,4,-34.342999>, <-114.342995,4,-5.657>, <-114.342995,4,5.657>,
			<-114.342995,4,34.342999>, <-114.342995,4,45.657001>, <-114.342995,4,74.343002>, <-114.342995,4,85.656998>,
			<-114.342995,4,114.343002>, <-114.343002,4,125.657005>, <-114.343002,8,-125.657005>, <-114.342995,8,-114.343002>,
			<-114.342995,8,-85.656998>, <-114.342995,8,-74.343002>, <-114.342995,8,-45.657001>, <-114.342995,8,-34.342999>,
			<-114.342995,8,-5.657>, <-114.342995,8,5.657>, <-114.342995,8,34.342999>, <-114.342995,8,45.657001>,
			<-114.342995,8,74.343002>, <-114.342995,8,85.656998>, <-114.342995,8,114.343002>, <-114.343002,8,125.657005>,
			<-112.608994,4,-123.061005>, <-112.608994,4,-116.938995>, <-112.608994,4,-83.061005>, <-112.608994,4,-76.938995>,
			<-112.608994,4,-43.060997>, <-112.608994,4,-36.939003>, <-112.608994,4,-3.061>, <-112.608994,4,3.061>,
			<-112.608994,4,36.939003>, <-112.608994,4,43.060997>, <-112.608994,4,76.938995>, <-112.608994,4,83.061005>,
			<-112.608994,4,116.938995>, <-112.608994,4,123.061005>, <-112.608994,8,-123.061005>, <-112.608994,8,-116.938995>,
			<-112.608994,8,-83.061005>, <-112.608994,8,-76.938995>, <-112.608994,8,-43.060997>, <-112.608994,8,-36.939003>,
			<-112.608994,8,-3.061>, <-112.608994,8,3.061>, <-112.608994,8,36.939003>, <-112.608994,8,43.060997>,
			<-112.608994,8,76.938995>, <-112.608994,8,83.061005>, <-112.608994,8,116.938995>, <-112.608994,8,123.061005>,
			<-112.198997,4,-121>, <-112.198997,4,-119>, <-112.198997,4,-81>, <-112.198997,4,-79>,
			<-112.198997,4,-41>, <-112.198997,4,-39>, <-112.198997,4,-1>, <-112.198997,4,1>,
			<-112.198997,4,39>, <-112.198997,4,41>, <-112.198997,4,79>, <-112.198997,4,81>,
			<-112.198997,4,119>, <-112.198997,4,121>, <-112.198997,8,-121>, <-112.198997,8,-119>,
			<-112.198997,8,-81>, <-112.198997,8,-79>, <-112.198997,8,-41>, <-112.198997,8,-39>,
			<-112.198997,8,-1>, <-112.198997,8,-1>, <-112.198997,8,1>, <-112.198997,8,1>,
			<-112.198997,8,39>, <-112.198997,8,41>, <-112.198997,8,79>, <-112.198997,8,81>,
			<-112.198997,8,119>, <-112.198997,8,121>, <-112,8,-120>, <-112,8,-80>,
			<-112,8,-40>, <-112,8,0>, <-112,8,40>, <-112,8,80>,
			<-112,8,120>, <-111,4,-124>, <-111,4,-121>, <-111,4,-119>,
			<-111,4,-116>, <-111,4,-84>, <-111,4,-81>, <-111,4,-79>,
			<-111,4,-76>, <-111,4,-44>, <-111,4,-41>, <-111,4,-39>,
			<-111,4,-36>, <-111,4,-4>, <-111,4,-1>, <-111,4,-1>,
			<-111,4,1>, <-111,4,1>, <-111,4,4>, <-111,4,36>,
			<-111,4,39>, <-111,4,41>, <-111,4,44>, <-111,4,76>,
			<-111,4,79>, <-111,4,81>, <-111,4,84>, <-111,4,116>,
			<-111,4,119>, <-111,4,121>, <-111,4,124>, <-111,8,-124>,
			<-111,8,-121>, <-111,8,-119>, <-111,8,-116>, <-111,8,-84>,
			<-111,8,-81>, <-111,8,-79>, <-111,8,-76>, <-111,8,-44>,
			<-111,8,-41>, <-111,8,-39>, <-111,8,-36>, <-111,8,-4>,
			<-111,8,-1>, <-111,8,-1>, <-111,8,1>, <-111,8,1>,
			<-111,8,4>, <-111,8,36>, <-111,8,39>, <-111,8,41>,
			<-111,8,44>, <-111,8,76>, <-111,8,79>, <-111,8,81>,
			<-111,8,84>, <-111,8,116>, <-111,8,119>, <-111,8,121>,
			<-111,8,124>, <-109,4,-124>, <-109,4,-121>, <-109,4,-119>,
			<-109,4,-116>, <-109,4,-84>, <-109,4,-81>, <-109,4,-79>,
			<-109,4,-76>, <-109,4,-44>, <-109,4,-41>, <-109,4,-39>,
			<-109,4,-36>, <-109,4,-4>, <-109,4,-1>, <-109,4,1>,
			<-109,4,4>, <-109,4,36>, <-109,4,39>, <-109,4,41>,
			<-109,4,44>, <-109,4,76>, <-109,4,79>, <-109,4,81>,
			<-109,4,84>, <-109,4,116>, <-109,4,119>, <-109,4,121>,
			<-109,4,124>, <-109,8,-124>, <-109,8,-121>, <-109,8,-119>,
			<-109,8,-116>, <-109,8,-84>, <-109,8,-81>, <-109,8,-79>,
			<-109,8,-76>, <-109,8,-44>, <-109,8,-41>, <-109,8,-39>,
			<-109,8,-36>, <-109,8,-4>, <-109,8,-1>, <-109,8,1>,
			<-109,8,4>, <-109,8,36>, <-109,8,39>, <-109,8,41>,
			<-109,8,44>, <-109,8,76>, <-109,8,79>, <-109,8,81>,
			<-109,8,84>, <-109,8,116>, <-109,8,119>, <-109,8,121>,
			<-109,8,124>, <-91,4,-124>, <-91,4,-121>, <-91,4,-119>,
			<-91,4,-116>, <-91,4,-84>, <-91,4,-81>, <-91,4,-79>,
			<-91,4,-76>, <-91,4,-44>, <-91,4,-41>, <-91,4,-39>,
			<-91,4,-36>, <-91,4,-4>, <-91,4,-1>, <-91,4,1>,
			<-91,4,4>, <-91,4,36>, <-91,4,39>, <-91,4,41>,
			<-91,4,44>, <-91,4,76>, <-91,4,79>, <-91,4,81>,
			<-91,4,84>, <-91,4,116>, <-91,4,119>, <-91,4,121>,
			<-91,4,124>, <-91,8,-124>, <-91,8,-121>, <-91,8,-119>,
			<-91,8,-116>, <-91,8,-84>, <-91,8,-81>, <-91,8,-79>,
			<-91,8,-76>, <-91,8,-44>, <-91,8,-41>, <-91,8,-39>,
			<-91,8,-36>, <-91,8,-4>, <-91,8,-1>, <-91,8,1>,
			<-91,8,4>, <-91,8,36>, <-91,8,39>, <-91,8,41>,
			<-91,8,44>, <-91,8,76>, <-91,8,79>, <-91,8,81>,
			<-91,8,84>, <-91,8,116>, <-91,8,119>, <-91,8,121>,
			<-91,8,124>, <-89,4,-124>, <-89,4,-121>, <-89,4,-119>,
			<-89,4,-116>, <-89,4,-84>, <-89,4,-81>, <-89,4,-79>,
			<-89,4,-76>, <-89,4,-44>, <-89,4,-41>, <-89,4,-39>,
			<-89,4,-36>, <-89,4,-4>, <-89,4,-1>, <-89,4,-1>,
			<-89,4,1>, <-89,4,1>, <-89,4,4>, <-89,4,36>,
			<-89,4,39>, <-89,4,41>, <-89,4,44>, <-89,4,76>,
			<-89,4,79>, <-89,4,81>, <-89,4,84>, <-89,4,116>,
			<-89,4,119>, <-89,4,121>, <-89,4,124>, <-89,8,-124>,
			<-89,8,-121>, <-89,8,-119>, <-89,8,-116>, <-89,8,-84>,
			<-89,8,-81>, <-89,8,-79>, <-89,8,-76>, <-89,8,-44>,
			<-89,8,-41>, <-89,8,-39>, <-89,8,-36>, <-89,8,-4>,
			<-89,8,-1>, <-89,8,-1>, <-89,8,1>, <-89,8,1>,
			<-89,8,4>, <-89,8,36>, <-89,8,39>, <-89,8,41>,
			<-89,8,44>, <-89,8,76>, <-89,8,79>, <-89,8,81>,
			<-89,8,84>, <-89,8,116>, <-89,8,119>, <-89,8,121>,
			<-89,8,124>, <-88,8,-120>, <-88,8,-80>, <-88,8,-40>,
			<-88,8,0>, <-88,8,40>, <-88,8,80>, <-88,8,120>,
			<-87.801003,4,-121>, <-87.801003,4,-119>, <-87.801003,4,-81>, <-87.801003,4,-79>,
			<-87.801003,4,-41>, <-87.801003,4,-39>, <-87.801003,4,-1>, <-87.801003,4,1>,
			<-87.801003,4,39>, <-87.801003,4,41>, <-87.801003,4,79>, <-87.801003,4,81>,
			<-87.801003,4,119>, <-87.801003,4,121>, <-87.801003,8,-121>, <-87.801003,8,-119>,
			<-87.801003,8,-81>, <-87.801003,8,-79>, <-87.801003,8,-41>, <-87.801003,8,-39>,
			<-87.801003,8,-1>, <-87.801003,8,-1>, <-87.801003,8,1>, <-87.801003,8,1>,
			<-87.801003,8,39>, <-87.801003,8,41>, <-87.801003,8,79>, <-87.801003,8,81>,
			<-87.801003,8,119>, <-87.801003,8,121>, <-87.391006,4,-123.061005>, <-87.391006,4,-116.938995>,
			<-87.391006,4,-83.061005>, <-87.391006,4,-76.938995>, <-87.391006,4,-43.060997>, <-87.391006,4,-36.939003>,
			<-87.391006,4,-3.061>, <-87.391006,4,3.061>, <-87.391006,4,36.939003>, <-87.391006,4,43.060997>,
			<-87.391006,4,76.938995>, <-87.391006,4,83.061005>, <-87.391006,4,116.938995>, <-87.391006,4,123.061005>,
			<-87.391006,8,-123.061005>, <-87.391006,8,-116.938995>, <-87.391006,8,-83.061005>, <-87.391006,8,-76.938995>,
			<-87.391006,8,-43.060997>, <-87.391006,8,-36.939003>, <-87.391006,8,-3.061>, <-87.391006,8,3.061>,
			<-87.391006,8,36.939003>, <-87.391006,8,43.060997>, <-87.391006,8,76.938995>, <-87.391006,8,83.061005>,
			<-87.391006,8,116.938995>, <-87.391006,8,123.061005>, <-85.656998,4,-125.657005>, <-85.657005,4,-114.343002>,
			<-85.657005,4,-85.656998>, <-85.657005,4,-74.343002>, <-85.657005,4,-45.657001>, <-85.657005,4,-34.342999>,
			<-85.657005,4,-5.657>, <-85.657005,4,5.657>, <-85.657005,4,34.342999>, <-85.657005,4,45.657001>,
			<-85.657005,4,74.343002>, <-85.657005,4,85.656998>, <-85.657005,4,114.343002>, <-85.656998,4,125.657005>,
			<-85.656998,8,-125.657005>, <-85.657005,8,-114.343002>, <-85.657005,8,-85.656998>, <-85.657005,8,-74.343002>,
			<-85.657005,8,-45.657001>, <-85.657005,8,-34.342999>, <-85.657005,8,-5.657>, <-85.657005,8,5.657>,
			<-85.657005,8,34.342999>, <-85.657005,8,45.657001>, <-85.657005,8,74.343002>, <-85.657005,8,85.656998>,
			<-85.657005,8,114.343002>, <-85.656998,8,125.657005>, <-84,4,-151>, <-84,4,-149>,
			<-84,4,-131>, <-84,4,-129>, <-84,4,-111>, <-84,4,-109>,
			<-84,4,-91>, <-84,4,-89>, <-84,4,-71>, <-84,4,-69>,
			<-84,4,-51>, <-84,4,-49>, <-84,4,-31>, <-84,4,-29>,
			<-84,4,-11>, <-84,4,-9>, <-84,4,9>, <-84,4,11>,
			<-84,4,29>, <-84,4,31>, <-84,4,49>, <-84,4,51>,
			<-84,4,69>, <-84,4,71>, <-84,4,89>, <-84,4,91>,
			<-84,4,109>, <-84,4,111>, <-84,4,129>, <-84,4,131>,
			<-84,4,149>, <-84,4,151>, <-84,8,-151>, <-84,8,-149>,
			<-84,8,-131>, <-84,8,-129>, <-84,8,-111>, <-84,8,-109>,
			<-84,8,-91>, <-84,8,-89>, <-84,8,-71>, <-84,8,-69>,
			<-84,8,-51>, <-84,8,-49>, <-84,8,-31>, <-84,8,-29>,
			<-84,8,-11>, <-84,8,-9>, <-84,8,9>, <-84,8,11>,
			<-84,8,29>, <-84,8,31>, <-84,8,49>, <-84,8,51>,
			<-84,8,69>, <-84,8,71>, <-84,8,89>, <-84,8,91>,
			<-84,8,109>, <-84,8,111>, <-84,8,129>, <-84,8,131>,
			<-84,8,149>, <-84,8,151>, <-83.061005,4,-127.390999>, <-83.061005,4,-112.608994>,
			<-83.061005,4,-87.391006>, <-83.061005,4,-72.608994>, <-83.061005,4,-47.390999>, <-83.061005,4,-32.609001>,
			<-83.061005,4,-7.391>, <-83.061005,4,7.391>, <-83.061005,4,32.609001>, <-83.061005,4,47.390999>,
			<-83.061005,4,72.608994>, <-83.061005,4,87.391006>, <-83.061005,4,112.608994>, <-83.061005,4,127.390999>,
			<-83.061005,8,-127.390999>, <-83.061005,8,-112.608994>, <-83.061005,8,-87.391006>, <-83.061005,8,-72.608994>,
			<-83.061005,8,-47.390999>, <-83.061005,8,-32.609001>, <-83.061005,8,-7.391>, <-83.061005,8,7.391>,
			<-83.061005,8,32.609001>, <-83.061005,8,47.390999>, <-83.061005,8,72.608994>, <-83.061005,8,87.391006>,
			<-83.061005,8,112.608994>, <-83.061005,8,127.390999>, <-81,4,-156>, <-81,4,-151>,
			<-81,4,-149>, <-81,4,-131>, <-81,4,-129>, <-81,4,-127.800995>,
			<-81,4,-112.198997>, <-81,4,-111>, <-81,4,-109>, <-81,4,-91>,
			<-81,4,-89>, <-81,4,-87.801003>, <-81,4,-72.198997>, <-81,4,-71>,
			<-81,4,-69>, <-81,4,-51>, <-81,4,-49>, <-81,4,-47.800999>,
			<-81,4,-32.199001>, <-81,4,-31>, <-81,4,-29>, <-81,4,-11>,
			<-81,4,-9>, <-81,4,-7.801001>, <-81,4,7.801001>, <-81,4,9>,
			<-81,4,11>, <-81,4,29>, <-81,4,31>, <-81,4,32.199001>,
			<-81,4,47.800999>, <-81,4,49>, <-81,4,51>, <-81,4,69>,
			<-81,4,71>, <-81,4,72.198997>, <-81,4,87.801003>, <-81,4,89>,
			<-81,4,91>, <-81,4,109>, <-81,4,111>, <-81,4,112.198997>,
			<-81,4,127.800995>, <-81,4,129>, <-81,4,131>, <-81,4,149>,
			<-81,4,151>, <-81,4,156>, <-81,8,-156>, <-81,8,-151>,
			<-81,8,-149>, <-81,8,-131>, <-81,8,-129>, <-81,8,-127.801003>,
			<-81,8,-112.198997>, <-81,8,-111>, <-81,8,-109>, <-81,8,-91>,
			<-81,8,-89>, <-81,8,-87.801003>, <-81,8,-72.198997>, <-81,8,-71>,
			<-81,8,-69>, <-81,8,-51>, <-81,8,-49>, <-81,8,-47.800999>,
			<-81,8,-32.199001>, <-81,8,-31>, <-81,8,-29>, <-81,8,-11>,
			<-81,8,-9>, <-81,8,-7.801>, <-81,8,7.801>, <-81,8,9>,
			<-81,8,11>, <-81,8,29>, <-81,8,31>, <-81,8,32.199001>,
			<-81,8,47.800999>, <-81,8,49>, <-81,8,51>, <-81,8,69>,
			<-81,8,71>, <-81,8,72.198997>, <-81,8,87.801003>, <-81,8,89>,
			<-81,8,91>, <-81,8,109>, <-81,8,111>, <-81,8,112.198997>,
			<-81,8,127.801003>, <-81,8,129>, <-81,8,131>, <-81,8,149>,
			<-81,8,151>, <-81,8,156>, <-80,8,-156>, <-80,8,-128>,
			<-80,8,-112>, <-80,8,-88>, <-80,8,-72>, <-80,8,-48>,
			<-80,8,-32>, <-80,8,-8>, <-80,8,8>, <-80,8,32>,
			<-80,8,48>, <-80,8,72>, <-80,8,88>, <-80,8,112>,
			<-80,8,128>, <-80,8,156>, <-79,4,-156>, <-79,4,-151>,
			<-79,4,-149>, <-79,4,-131>, <-79,4,-129>, <-79,4,-127.800995>,
			<-79,4,-112.198997>, <-79,4,-111>, <-79,4,-109>, <-79,4,-91>,
			<-79,4,-89>, <-79,4,-87.801003>, <-79,4,-72.198997>, <-79,4,-71>,
			<-79,4,-69>, <-79,4,-51>, <-79,4,-49>, <-79,4,-47.800999>,
			<-79,4,-32.199001>, <-79,4,-31>, <-79,4,-29>, <-79,4,-11>,
			<-79,4,-9>, <-79,4,-7.801001>, <-79,4,7.801001>, <-79,4,9>,
			<-79,4,11>, <-79,4,29>, <-79,4,31>, <-79,4,32.199001>,
			<-79,4,47.800999>, <-79,4,49>, <-79,4,51>, <-79,4,69>,
			<-79,4,71>, <-79,4,72.198997>, <-79,4,87.801003>, <-79,4,89>,
			<-79,4,91>, <-79,4,109>, <-79,4,111>, <-79,4,112.198997>,
			<-79,4,127.800995>, <-79,4,129>, <-79,4,131>, <-79,4,149>,
			<-79,4,151>, <-79,4,156>, <-79,8,-156>, <-79,8,-151>,
			<-79,8,-149>, <-79,8,-131>, <-79,8,-129>, <-79,8,-127.801003>,
			<-79,8,-112.198997>, <-79,8,-111>, <-79,8,-109>, <-79,8,-91>,
			<-79,8,-89>, <-79,8,-87.801003>, <-79,8,-72.198997>, <-79,8,-71>,
			<-79,8,-69>, <-79,8,-51>, <-79,8,-49>, <-79,8,-47.800999>,
			<-79,8,-32.199001>, <-79,8,-31>, <-79,8,-29>, <-79,8,-11>,
			<-79,8,-9>, <-79,8,-7.801>, <-79,8,7.801>, <-79,8,9>,
			<-79,8,11>, <-79,8,29>, <-79,8,31>, <-79,8,32.199001>,
			<-79,8,47.800999>, <-79,8,49>, <-79,8,51>, <-79,8,69>,
			<-79,8,71>, <-79,8,72.198997>, <-79,8,87.801003>, <-79,8,89>,
			<-79,8,91>, <-79,8,109>, <-79,8,111>, <-79,8,112.198997>,
			<-79,8,127.801003>, <-79,8,129>, <-79,8,131>, <-79,8,149>,
			<-79,8,151>, <-79,8,156>, <-76.938995,4,-127.390999>, <-76.938995,4,-112.608994>,
			<-76.938995,4,-87.391006>, <-76.938995,4,-72.608994>, <-76.938995,4,-47.390999>, <-76.938995,4,-32.609001>,
			<-76.938995,4,-7.391>, <-76.938995,4,7.391>, <-76.938995,4,32.609001>, <-76.938995,4,47.390999>,
			<-76.938995,4,72.608994>, <-76.938995,4,87.391006>, <-76.938995,4,112.608994>, <-76.938995,4,127.390999>,
			<-76.938995,8,-127.390999>, <-76.938995,8,-112.608994>, <-76.938995,8,-87.391006>, <-76.938995,8,-72.608994>,
			<-76.938995,8,-47.390999>, <-76.938995,8,-32.609001>, <-76.938995,8,-7.391>, <-76.938995,8,7.391>,
			<-76.938995,8,32.609001>, <-76.938995,8,47.390999>, <-76.938995,8,72.608994>, <-76.938995,8,87.391006>,
			<-76.938995,8,112.608994>, <-76.938995,8,127.390999>, <-76,4,-151>, <-76,4,-149>,
			<-76,4,-131>, <-76,4,-129>, <-76,4,-111>, <-76,4,-109>,
			<-76,4,-91>, <-76,4,-89>, <-76,4,-71>, <-76,4,-69>,
			<-76,4,-51>, <-76,4,-49>, <-76,4,-31>, <-76,4,-29>,
			<-76,4,-11>, <-76,4,-9>, <-76,4,9>, <-76,4,11>,
			<-76,4,29>, <-76,4,31>, <-76,4,49>, <-76,4,51>,
			<-76,4,69>, <-76,4,71>, <-76,4,89>, <-76,4,91>,
			<-76,4,109>, <-76,4,111>, <-76,4,129>, <-76,4,131>,
			<-76,4,149>, <-76,4,151>, <-76,8,-151>, <-76,8,-149>,
			<-76,8,-131>, <-76,8,-129>, <-76,8,-111>, <-76,8,-109>,
			<-76,8,-91>, <-76,8,-89>, <-76,8,-71>, <-76,8,-69>,
			<-76,8,-51>, <-76,8,-49>, <-76,8,-31>, <-76,8,-29>,
			<-76,8,-11>, <-76,8,-9>, <-76,8,9>, <-76,8,11>,
			<-76,8,29>, <-76,8,31>, <-76,8,49>, <-76,8,51>,
			<-76,8,69>, <-76,8,71>, <-76,8,89>, <-76,8,91>,
			<-76,8,109>, <-76,8,111>, <-76,8,129>, <-76,8,131>,
			<-76,8,149>, <-76,8,151>, <-74.343002,4,-125.657005>, <-74.342995,4,-114.343002>,
			<-74.342995,4,-85.656998>, <-74.342995,4,-74.343002>, <-74.342995,4,-45.657001>, <-74.342995,4,-34.342999>,
			<-74.342995,4,-5.657>, <-74.342995,4,5.657>, <-74.342995,4,34.342999>, <-74.342995,4,45.657001>,
			<-74.342995,4,74.343002>, <-74.342995,4,85.656998>, <-74.342995,4,114.343002>, <-74.343002,4,125.657005>,
			<-74.343002,8,-125.657005>, <-74.342995,8,-114.343002>, <-74.342995,8,-85.656998>, <-74.342995,8,-74.343002>,
			<-74.342995,8,-45.657001>, <-74.342995,8,-34.342999>, <-74.342995,8,-5.657>, <-74.342995,8,5.657>,
			<-74.342995,8,34.342999>, <-74.342995,8,45.657001>, <-74.342995,8,74.343002>, <-74.342995,8,85.656998>,
			<-74.342995,8,114.343002>, <-74.343002,8,125.657005>, <-72.608994,4,-123.061005>, <-72.608994,4,-116.938995>,
			<-72.608994,4,-83.061005>, <-72.608994,4,-76.938995>, <-72.608994,4,-43.060997>, <-72.608994,4,-36.939003>,
			<-72.608994,4,-3.061>, <-72.608994,4,3.061>, <-72.608994,4,36.939003>, <-72.608994,4,43.060997>,
			<-72.608994,4,76.938995>, <-72.608994,4,83.061005>, <-72.608994,4,116.938995>, <-72.608994,4,123.061005>,
			<-72.608994,8,-123.061005>, <-72.608994,8,-116.938995>, <-72.608994,8,-83.061005>, <-72.608994,8,-76.938995>,
			<-72.608994,8,-43.060997>, <-72.608994,8,-36.939003>, <-72.608994,8,-3.061>, <-72.608994,8,3.061>,
			<-72.608994,8,36.939003>, <-72.608994,8,43.060997>, <-72.608994,8,76.938995>, <-72.608994,8,83.061005>,
			<-72.608994,8,116.938995>, <-72.608994,8,123.061005>, <-72.198997,4,-121>, <-72.198997,4,-119>,
			<-72.198997,4,-81>, <-72.198997,4,-79>, <-72.198997,4,-41>, <-72.198997,4,-39>,
			<-72.198997,4,-1>, <-72.198997,4,1>, <-72.198997,4,39>, <-72.198997,4,41>,
			<-72.198997,4,79>, <-72.198997,4,81>, <-72.198997,4,119>, <-72.198997,4,121>,
			<-72.198997,8,-121>, <-72.198997,8,-119>, <-72.198997,8,-81>, <-72.198997,8,-79>,
			<-72.198997,8,-41>, <-72.198997,8,-39>, <-72.198997,8,-1>, <-72.198997,8,-1>,
			<-72.198997,8,1>, <-72.198997,8,1>, <-72.198997,8,39>, <-72.198997,8,41>,
			<-72.198997,8,79>, <-72.198997,8,81>, <-72.198997,8,119>, <-72.198997,8,121>,
			<-72,8,-120>, <-72,8,-80>, <-72,8,-40>, <-72,8,0>,
			<-72,8,40>, <-72,8,80>, <-72,8,120>, <-71,4,-124>,
			<-71,4,-121>, <-71,4,-119>, <-71,4,-116>, <-71,4,-84>,
			<-71,4,-81>, <-71,4,-79>, <-71,4,-76>, <-71,4,-44>,
			<-71,4,-41>, <-71,4,-39>, <-71,4,-36>, <-71,4,-4>,
			<-71,4,-1>, <-71,4,-1>, <-71,4,1>, <-71,4,1>,
			<-71,4,4>, <-71,4,36>, <-71,4,39>, <-71,4,41>,
			<-71,4,44>, <-71,4,76>, <-71,4,79>, <-71,4,81>,
			<-71,4,84>, <-71,4,116>, <-71,4,119>, <-71,4,121>,
			<-71,4,124>, <-71,8,-124>, <-71,8,-121>, <-71,8,-119>,
			<-71,8,-116>, <-71,8,-84>, <-71,8,-81>, <-71,8,-79>,
			<-71,8,-76>, <-71,8,-44>, <-71,8,-41>, <-71,8,-39>,
			<-71,8,-36>, <-71,8,-4>, <-71,8,-1>, <-71,8,-1>,
			<-71,8,1>, <-71,8,1>, <-71,8,4>, <-71,8,36>,
			<-71,8,39>, <-71,8,41>, <-71,8,44>, <-71,8,76>,
			<-71,8,79>, <-71,8,81>, <-71,8,84>, <-71,8,116>,
			<-71,8,119>, <-71,8,121>, <-71,8,124>, <-69,4,-124>,
			<-69,4,-121>, <-69,4,-119>, <-69,4,-116>, <-69,4,-84>,
			<-69,4,-81>, <-69,4,-79>, <-69,4,-76>, <-69,4,-44>,
			<-69,4,-41>, <-69,4,-39>, <-69,4,-36>, <-69,4,-4>,
			<-69,4,-1>, <-69,4,1>, <-69,4,4>, <-69,4,36>,
			<-69,4,39>, <-69,4,41>, <-69,4,44>, <-69,4,76>,
			<-69,4,79>, <-69,4,81>, <-69,4,84>, <-69,4,116>,
			<-69,4,119>, <-69,4,121>, <-69,4,124>, <-69,8,-124>,
			<-69,8,-121>, <-69,8,-119>, <-69,8,-116>, <-69,8,-84>,
			<-69,8,-81>, <-69,8,-79>, <-69,8,-76>, <-69,8,-44>,
			<-69,8,-41>, <-69,8,-39>, <-69,8,-36>, <-69,8,-4>,
			<-69,8,-1>, <-69,8,1>, <-69,8,4>, <-69,8,36>,
			<-69,8,39>, <-69,8,41>, <-69,8,44>, <-69,8,76>,
			<-69,8,79>, <-69,8,81>, <-69,8,84>, <-69,8,116>,
			<-69,8,119>, <-69,8,121>, <-69,8,124>, <-51,4,-124>,
			<-51,4,-121>, <-51,4,-119>, <-51,4,-116>, <-51,4,-84>,
			<-51,4,-81>, <-51,4,-79>, <-51,4,-76>, <-51,4,-44>,
			<-51,4,-41>, <-51,4,-39>, <-51,4,-36>, <-51,4,-4>,
			<-51,4,-1>, <-51,4,1>, <-51,4,4>, <-51,4,36>,
			<-51,4,39>, <-51,4,41>, <-51,4,44>, <-51,4,76>,
			<-51,4,79>, <-51,4,81>, <-51,4,84>, <-51,4,116>,
			<-51,4,119>, <-51,4,121>, <-51,4,124>, <-51,8,-124>,
			<-51,8,-121>, <-51,8,-119>, <-51,8,-116>, <-51,8,-84>,
			<-51,8,-81>, <-51,8,-79>, <-51,8,-76>, <-51,8,-44>,
			<-51,8,-41>, <-51,8,-39>, <-51,8,-36>, <-51,8,-4>,
			<-51,8,-1>, <-51,8,1>, <-51,8,4>, <-51,8,36>,
			<-51,8,39>, <-51,8,41>, <-51,8,44>, <-51,8,76>,
			<-51,8,79>, <-51,8,81>, <-51,8,84>, <-51,8,116>,
			<-51,8,119>, <-51,8,121>, <-51,8,124>, <-49,4,-124>,
			<-49,4,-121>, <-49,4,-119>, <-49,4,-116>, <-49,4,-84>,
			<-49,4,-81>, <-49,4,-79>, <-49,4,-76>, <-49,4,-44>,
			<-49,4,-41>, <-49,4,-39>, <-49,4,-36>, <-49,4,-4>,
			<-49,4,-1>, <-49,4,-1>, <-49,4,1>, <-49,4,1>,
			<-49,4,4>, <-49,4,36>, <-49,4,39>, <-49,4,41>,
			<-49,4,44>, <-49,4,76>, <-49,4,79>, <-49,4,81>,
			<-49,4,84>, <-49,4,116>, <-49,4,119>, <-49,4,121>,
			<-49,4,124>, <-49,8,-124>, <-49,8,-121>, <-49,8,-119>,
			<-49,8,-116>, <-49,8,-84>, <-49,8,-81>, <-49,8,-79>,
			<-49,8,-76>, <-49,8,-44>, <-49,8,-41>, <-49,8,-39>,
			<-49,8,-36>, <-49,8,-4>, <-49,8,-1>, <-49,8,-1>,
			<-49,8,1>, <-49,8,1>, <-49,8,4>, <-49,8,36>,
			<-49,8,39>, <-49,8,41>, <-49,8,44>, <-49,8,76>,
			<-49,8,79>, <-49,8,81>, <-49,8,84>, <-49,8,116>,
			<-49,8,119>, <-49,8,121>, <-49,8,124>, <-48,8,-120>,
			<-48,8,-80>, <-48,8,-40>, <-48,8,0>, <-48,8,40>,
			<-48,8,80>, <-48,8,120>, <-47.800999,4,-121>, <-47.800999,4,-119>,
			<-47.800999,4,-81>, <-47.800999,4,-79>, <-47.800999,4,-41>, <-47.800999,4,-39>,
			<-47.800999,4,-1>, <-47.800999,4,1>, <-47.800999,4,39>, <-47.800999,4,41>,
			<-47.800999,4,79>, <-47.800999,4,81>, <-47.800999,4,119>, <-47.800999,4,121>,
			<-47.800999,8,-121>, <-47.800999,8,-119>, <-47.800999,8,-81>, <-47.800999,8,-79>,
			<-47.800999,8,-41>, <-47.800999,8,-39>, <-47.800999,8,-1>, <-47.800999,8,-1>,
			<-47.800999,8,1>, <-47.800999,8,1>, <-47.800999,8,39>, <-47.800999,8,41>,
			<-47.800999,8,79>, <-47.800999,8,81>, <-47.800999,8,119>, <-47.800999,8,121>,
			<-47.390999,4,-123.061005>, <-47.390999,4,-116.938995>, <-47.390999,4,-83.061005>, <-47.390999,4,-76.938995>,
			<-47.390999,4,-43.060997>, <-47.390999,4,-36.939003>, <-47.390999,4,-3.061>, <-47.390999,4,3.061>,
			<-47.390999,4,36.939003>, <-47.390999,4,43.060997>, <-47.390999,4,76.938995>, <-47.390999,4,83.061005>,
			<-47.390999,4,116.938995>, <-47.390999,4,123.061005>, <-47.390999,8,-123.061005>, <-47.390999,8,-116.938995>,
			<-47.390999,8,-83.061005>, <-47.390999,8,-76.938995>, <-47.390999,8,-43.060997>, <-47.390999,8,-36.939003>,
			<-47.390999,8,-3.061>, <-47.390999,8,3.061>, <-47.390999,8,36.939003>, <-47.390999,8,43.060997>,
			<-47.390999,8,76.938995>, <-47.390999,8,83.061005>, <-47.390999,8,116.938995>, <-47.390999,8,123.061005>,
			<-45.657001,4,-125.657005>, <-45.657001,4,-114.343002>, <-45.657001,4,-85.656998>, <-45.657001,4,-74.343002>,
			<-45.657001,4,-45.657001>, <-45.657001,4,-34.342999>, <-45.657001,4,-5.657>, <-45.657001,4,5.657>,
			<-45.657001,4,34.342999>, <-45.657001,4,45.657001>, <-45.657001,4,74.343002>, <-45.657001,4,85.656998>,
			<-45.657001,4,114.343002>, <-45.657001,4,125.657005>, <-45.657001,8,-125.657005>, <-45.657001,8,-114.343002>,
			<-45.657001,8,-85.656998>, <-45.657001,8,-74.343002>, <-45.657001,8,-45.657001>, <-45.657001,8,-34.342999>,
			<-45.657001,8,-5.657>, <-45.657001,8,5.657>, <-45.657001,8,34.342999>, <-45.657001,8,45.657001>,
			<-45.657001,8,74.343002>, <-45.657001,8,85.656998>, <-45.657001,8,114.343002>, <-45.657001,8,125.657005>,
			<-44,4,-151>, <-44,4,-149>, <-44,4,-131>, <-44,4,-129>,
			<-44,4,-111>, <-44,4,-109>, <-44,4,-91>, <-44,4,-89>,
			<-44,4,-71>, <-44,4,-69>, <-44,4,-51>, <-44,4,-49>,
			<-44,4,-31>, <-44,4,-29>, <-44,4,-11>, <-44,4,-9>,
			<-44,4,9>, <-44,4,11>, <-44,4,29>, <-44,4,31>,
			<-44,4,49>, <-44,4,51>, <-44,4,69>, <-44,4,71>,
			<-44,4,89>, <-44,4,91>, <-44,4,109>, <-44,4,111>,
			<-44,4,129>, <-44,4,131>, <-44,4,149>, <-44,4,151>,
			<-44,8,-151>, <-44,8,-149>, <-44,8,-131>, <-44,8,-129>,
			<-44,8,-111>, <-44,8,-109>, <-44,8,-91>, <-44,8,-89>,
			<-44,8,-71>, <-44,8,-69>, <-44,8,-51>, <-44,8,-49>,
			<-44,8,-31>, <-44,8,-29>, <-44,8,-11>, <-44,8,-9>,
			<-44,8,9>, <-44,8,11>, <-44,8,29>, <-44,8,31>,
			<-44,8,49>, <-44,8,51>, <-44,8,69>, <-44,8,71>,
			<-44,8,89>, <-44,8,91>, <-44,8,109>, <-44,8,111>,
			<-44,8,129>, <-44,8,131>, <-44,8,149>, <-44,8,151>,
			<-43.060997,4,-127.390999>, <-43.060997,4,-112.608994>, <-43.060997,4,-87.391006>, <-43.060997,4,-72.608994>,
			<-43.060997,4,-47.390999>, <-43.060997,4,-32.609001>, <-43.060997,4,-7.391>, <-43.060997,4,7.391>,
			<-43.060997,4,32.609001>, <-43.060997,4,47.390999>, <-43.060997,4,72.608994>, <-43.060997,4,87.391006>,
			<-43.060997,4,112.608994>, <-43.060997,4,127.390999>, <-43.060997,8,-127.390999>, <-43.060997,8,-112.608994>,
			<-43.060997,8,-87.391006>, <-43.060997,8,-72.608994>, <-43.060997,8,-47.390999>, <-43.060997,8,-32.609001>,
			<-43.060997,8,-7.391>, <-43.060997,8,7.391>, <-43.060997,8,32.609001>, <-43.060997,8,47.390999>,
			<-43.060997,8,72.608994>, <-43.060997,8,87.391006>, <-43.060997,8,112.608994>, <-43.060997,8,127.390999>,
			<-41,4,-156>, <-41,4,-151>, <-41,4,-149>, <-41,4,-131>,
			<-41,4,-129>, <-41,4,-127.800995>, <-41,4,-112.198997>, <-41,4,-111>,
			<-41,4,-109>, <-41,4,-91>, <-41,4,-89>, <-41,4,-87.801003>,
			<-41,4,-72.198997>, <-41,4,-71>, <-41,4,-69>, <-41,4,-51>,
			<-41,4,-49>, <-41,4,-47.800999>, <-41,4,-32.199001>, <-41,4,-31>,
			<-41,4,-29>, <-41,4,-11>, <-41,4,-9>, <-41,4,-7.801001>,
			<-41,4,7.801001>, <-41,4,9>, <-41,4,11>, <-41,4,29>,
			<-41,4,31>, <-41,4,32.199001>, <-41,4,47.800999>, <-41,4,49>,
			<-41,4,51>, <-41,4,69>, <-41,4,71>, <-41,4,72.198997>,
			<-41,4,87.801003>, <-41,4,89>, <-41,4,91>, <-41,4,109>,
			<-41,4,111>, <-41,4,112.198997>, <-41,4,127.800995>, <-41,4,129>,
			<-41,4,131>, <-41,4,149>, <-41,4,151>, <-41,4,156>,
			<-41,8,-156>, <-41,8,-151>, <-41,8,-149>, <-41,8,-131>,
			<-41,8,-129>, <-41,8,-127.801003>, <-41,8,-112.198997>, <-41,8,-111>,
			<-41,8,-109>, <-41,8,-91>, <-41,8,-89>, <-41,8,-87.801003>,
			<-41,8,-72.198997>, <-41,8,-71>, <-41,8,-69>, <-41,8,-51>,
			<-41,8,-49>, <-41,8,-47.800999>, <-41,8,-32.199001>, <-41,8,-31>,
			<-41,8,-29>, <-41,8,-11>, <-41,8,-9>, <-41,8,-7.801>,
			<-41,8,7.801>, <-41,8,9>, <-41,8,11>, <-41,8,29>,
			<-41,8,31>, <-41,8,32.199001>, <-41,8,47.800999>, <-41,8,49>,
			<-41,8,51>, <-41,8,69>, <-41,8,71>, <-41,8,72.198997>,
			<-41,8,87.801003>, <-41,8,89>, <-41,8,91>, <-41,8,109>,
			<-41,8,111>, <-41,8,112.198997>, <-41,8,127.801003>, <-41,8,129>,
			<-41,8,131>, <-41,8,149>, <-41,8,151>, <-41,8,156>,
			<-40,8,-156>, <-40,8,-128>, <-40,8,-112>, <-40,8,-88>,
			<-40,8,-72>, <-40,8,-48>, <-40,8,-32>, <-40,8,-8>,
			<-40,8,8>, <-40,8,32>, <-40,8,48>, <-40,8,72>,
			<-40,8,88>, <-40,8,112>, <-40,8,128>, <-40,8,156>,
			<-39,4,-156>, <-39,4,-151>, <-39,4,-149>, <-39,4,-131>,
			<-39,4,-129>, <-39,4,-127.800995>, <-39,4,-112.198997>, <-39,4,-111>,
			<-39,4,-109>, <-39,4,-91>, <-39,4,-89>, <-39,4,-87.801003>,
			<-39,4,-72.198997>, <-39,4,-71>, <-39,4,-69>, <-39,4,-51>,
			<-39,4,-49>, <-39,4,-47.800999>, <-39,4,-32.199001>, <-39,4,-31>,
			<-39,4,-29>, <-39,4,-11>, <-39,4,-9>, <-39,4,-7.801001>,
			<-39,4,7.801001>, <-39,4,9>, <-39,4,11>, <-39,4,29>,
			<-39,4,31>, <-39,4,32.199001>, <-39,4,47.800999>, <-39,4,49>,
			<-39,4,51>, <-39,4,69>, <-39,4,71>, <-39,4,72.198997>,
			<-39,4,87.801003>, <-39,4,89>, <-39,4,91>, <-39,4,109>,
			<-39,4,111>, <-39,4,112.198997>, <-39,4,127.800995>, <-39,4,129>,
			<-39,4,131>, <-39,4,149>, <-39,4,151>, <-39,4,156>,
			<-39,8,-156>, <-39,8,-151>, <-39,8,-149>, <-39,8,-131>,
			<-39,8,-129>, <-39,8,-127.801003>, <-39,8,-112.198997>, <-39,8,-111>,
			<-39,8,-109>, <-39,8,-91>, <-39,8,-89>, <-39,8,-87.801003>,
			<-39,8,-72.198997>, <-39,8,-71>, <-39,8,-69>, <-39,8,-51>,
			<-39,8,-49>, <-39,8,-47.800999>, <-39,8,-32.199001>, <-39,8,-31>,
			<-39,8,-29>, <-39,8,-11>, <-39,8,-9>, <-39,8,-7.801>,
			<-39,8,7.801>, <-39,8,9>, <-39,8,11>, <-39,8,29>,
			<-39,8,31>, <-39,8,32.199001>, <-39,8,47.800999>, <-39,8,49>,
			<-39,8,51>, <-39,8,69>, <-39,8,71>, <-39,8,72.198997>,
			<-39,8,87.801003>, <-39,8,89>, <-39,8,91>, <-39,8,109>,
			<-39,8,111>, <-39,8,112.198997>, <-39,8,127.801003>, <-39,8,129>,
			<-39,8,131>, <-39,8,149>, <-39,8,151>, <-39,8,156>,
			<-36.939003,4,-127.390999>, <-36.939003,4,-112.608994>, <-36.939003,4,-87.391006>, <-36.939003,4,-72.608994>,
			<-36.939003,4,-47.390999>, <-36.939003,4,-32.609001>, <-36.939003,4,-7.391>, <-36.939003,4,7.391>,
			<-36.939003,4,32.609001>, <-36.939003,4,47.390999>, <-36.939003,4,72.608994>, <-36.939003,4,87.391006>,
			<-36.939003,4,112.608994>, <-36.939003,4,127.390999>, <-36.939003,8,-127.390999>, <-36.939003,8,-112.608994>,
			<-36.939003,8,-87.391006>, <-36.939003,8,-72.608994>, <-36.939003,8,-47.390999>, <-36.939003,8,-32.609001>,
			<-36.939003,8,-7.391>, <-36.939003,8,7.391>, <-36.939003,8,32.609001>, <-36.939003,8,47.390999>,
			<-36.939003,8,72.608994>, <-36.939003,8,87.391006>, <-36.939003,8,112.608994>, <-36.939003,8,127.390999>,
			<-36,4,-151>, <-36,4,-149>, <-36,4,-131>, <-36,4,-129>,
			<-36,4,-111>, <-36,4,-109>, <-36,4,-91>, <-36,4,-89>,
			<-36,4,-71>, <-36,4,-69>, <-36,4,-51>, <-36,4,-49>,
			<-36,4,-31>, <-36,4,-29>, <-36,4,-11>, <-36,4,-9>,
			<-36,4,9>, <-36,4,11>, <-36,4,29>, <-36,4,31>,
			<-36,4,49>, <-36,4,51>, <-36,4,69>, <-36,4,71>,
			<-36,4,89>, <-36,4,91>, <-36,4,109>, <-36,4,111>,
			<-36,4,129>, <-36,4,131>, <-36,4,149>, <-36,4,151>,
			<-36,8,-151>, <-36,8,-149>, <-36,8,-131>, <-36,8,-129>,
			<-36,8,-111>, <-36,8,-109>, <-36,8,-91>, <-36,8,-89>,
			<-36,8,-71>, <-36,8,-69>, <-36,8,-51>, <-36,8,-49>,
			<-36,8,-31>, <-36,8,-29>, <-36,8,-11>, <-36,8,-9>,
			<-36,8,9>, <-36,8,11>, <-36,8,29>, <-36,8,31>,
			<-36,8,49>, <-36,8,51>, <-36,8,69>, <-36,8,71>,
			<-36,8,89>, <-36,8,91>, <-36,8,109>, <-36,8,111>,
			<-36,8,129>, <-36,8,131>, <-36,8,149>, <-36,8,151>,
			<-34.342999,4,-125.657005>, <-34.342999,4,-114.343002>, <-34.342999,4,-85.656998>, <-34.342999,4,-74.343002>,
			<-34.342999,4,-45.657001>, <-34.342999,4,-34.342999>, <-34.342999,4,-5.657>, <-34.342999,4,5.657>,
			<-34.342999,4,34.342999>, <-34.342999,4,45.657001>, <-34.342999,4,74.343002>, <-34.342999,4,85.656998>,
			<-34.342999,4,114.343002>, <-34.342999,4,125.657005>, <-34.342999,8,-125.657005>, <-34.342999,8,-114.343002>,
			<-34.342999,8,-85.656998>, <-34.342999,8,-74.343002>, <-34.342999,8,-45.657001>, <-34.342999,8,-34.342999>,
			<-34.342999,8,-5.657>, <-34.342999,8,5.657>, <-34.342999,8,34.342999>, <-34.342999,8,45.657001>,
			<-34.342999,8,74.343002>, <-34.342999,8,85.656998>, <-34.342999,8,114.343002>, <-34.342999,8,125.657005>,
			<-32.609001,4,-123.061005>, <-32.609001,4,-116.938995>, <-32.609001,4,-83.061005>, <-32.609001,4,-76.938995>,
			<-32.609001,4,-43.060997>, <-32.609001,4,-36.939003>, <-32.609001,4,-3.061>, <-32.609001,4,3.061>,
			<-32.609001,4,36.939003>, <-32.609001,4,43.060997>, <-32.609001,4,76.938995>, <-32.609001,4,83.061005>,
			<-32.609001,4,116.938995>, <-32.609001,4,123.061005>, <-32.609001,8,-123.061005>, <-32.609001,8,-116.938995>,
			<-32.609001,8,-83.061005>, <-32.609001,8,-76.938995>, <-32.609001,8,-43.060997>, <-32.609001,8,-36.939003>,
			<-32.609001,8,-3.061>, <-32.609001,8,3.061>, <-32.609001,8,36.939003>, <-32.609001,8,43.060997>,
			<-32.609001,8,76.938995>, <-32.609001,8,83.061005>, <-32.609001,8,116.938995>, <-32.609001,8,123.061005>,
			<-32.199001,4,-121>, <-32.199001,4,-119>, <-32.199001,4,-81>, <-32.199001,4,-79>,
			<-32.199001,4,-41>, <-32.199001,4,-39>, <-32.199001,4,-1>, <-32.199001,4,1>,
			<-32.199001,4,39>, <-32.199001,4,41>, <-32.199001,4,79>, <-32.199001,4,81>,
			<-32.199001,4,119>, <-32.199001,4,121>, <-32.199001,8,-121>, <-32.199001,8,-119>,
			<-32.199001,8,-81>, <-32.199001,8,-79>, <-32.199001,8,-41>, <-32.199001,8,-39>,
			<-32.199001,8,-1>, <-32.199001,8,-1>, <-32.199001,8,1>, <-32.199001,8,1>,
			<-32.199001,8,39>, <-32.199001,8,41>, <-32.199001,8,79>, <-32.199001,8,81>,
			<-32.199001,8,119>, <-32.199001,8,121>, <-32,8,-120>, <-32,8,-80>,
			<-32,8,-40>, <-32,8,0>, <-32,8,40>, <-32,8,80>,
			<-32,8,120>, <-31,4,-124>, <-31,4,-121>, <-31,4,-119>,
			<-31,4,-116>, <-31,4,-84>, <-31,4,-81>, <-31,4,-79>,
			<-31,4,-76>, <-31,4,-44>, <-31,4,-41>, <-31,4,-39>,
			<-31,4,-36>, <-31,4,-4>, <-31,4,-1>, <-31,4,-1>,
			<-31,4,1>, <-31,4,1>, <-31,4,4>, <-31,4,36>,
			<-31,4,39>, <-31,4,41>, <-31,4,44>, <-31,4,76>,
			<-31,4,79>, <-31,4,81>, <-31,4,84>, <-31,4,116>,
			<-31,4,119>, <-31,4,121>, <-31,4,124>, <-31,8,-124>,
			<-31,8,-121>, <-31,8,-119>, <-31,8,-116>, <-31,8,-84>,
			<-31,8,-81>, <-31,8,-79>, <-31,8,-76>, <-31,8,-44>,
			<-31,8,-41>, <-31,8,-39>, <-31,8,-36>, <-31,8,-4>,
			<-31,8,-1>, <-31,8,-1>, <-31,8,1>, <-31,8,1>,
			<-31,8,4>, <-31,8,36>, <-31,8,39>, <-31,8,41>,
			<-31,8,44>, <-31,8,76>, <-31,8,79>, <-31,8,81>,
			<-31,8,84>, <-31,8,116>, <-31,8,119>, <-31,8,121>,
			<-31,8,124>, <-29,4,-124>, <-29,4,-121>, <-29,4,-119>,
			<-29,4,-116>, <-29,4,-84>, <-29,4,-81>, <-29,4,-79>,
			<-29,4,-76>, <-29,4,-44>, <-29,4,-41>, <-29,4,-39>,
			<-29,4,-36>, <-29,4,-4>, <-29,4,-1>, <-29,4,1>,
			<-29,4,4>, <-29,4,36>, <-29,4,39>, <-29,4,41>,
			<-29,4,44>, <-29,4,76>, <-29,4,79>, <-29,4,81>,
			<-29,4,84>, <-29,4,116>, <-29,4,119>, <-29,4,121>,
			<-29,4,124>, <-29,8,-124>, <-29,8,-121>, <-29,8,-119>,
			<-29,8,-116>, <-29,8,-84>, <-29,8,-81>, <-29,8,-79>,
			<-29,8,-76>, <-29,8,-44>, <-29,8,-41>, <-29,8,-39>,
			<-29,8,-36>, <-29,8,-4>, <-29,8,-1>, <-29,8,1>,
			<-29,8,4>, <-29,8,36>, <-29,8,39>, <-29,8,41>,
			<-29,8,44>, <-29,8,76>, <-29,8,79>, <-29,8,81>,
			<-29,8,84>, <-29,8,116>, <-29,8,119>, <-29,8,121>,
			<-29,8,124>, <-11,4,-124>, <-11,4,-121>, <-11,4,-119>,
			<-11,4,-116>, <-11,4,-84>, <-11,4,-81>, <-11,4,-79>,
			<-11,4,-76>, <-11,4,-44>, <-11,4,-41>, <-11,4,-39>,
			<-11,4,-36>, <-11,4,-4>, <-11,4,-1>, <-11,4,1>,
			<-11,4,4>, <-11,4,36>, <-11,4,39>, <-11,4,41>,
			<-11,4,44>, <-11,4,76>, <-11,4,79>, <-11,4,81>,
			<-11,4,84>, <-11,4,116>, <-11,4,119>, <-11,4,121>,
			<-11,4,124>, <-11,8,-124>, <-11,8,-121>, <-11,8,-119>,
			<-11,8,-116>, <-11,8,-84>, <-11,8,-81>, <-11,8,-79>,
			<-11,8,-76>, <-11,8,-44>, <-11,8,-41>, <-11,8,-39>,
			<-11,8,-36>, <-11,8,-4>, <-11,8,-1>, <-11,8,1>,
			<-11,8,4>, <-11,8,36>, <-11,8,39>, <-11,8,41>,
			<-11,8,44>, <-11,8,76>, <-11,8,79>, <-11,8,81>,
			<-11,8,84>, <-11,8,116>, <-11,8,119>, <-11,8,121>,
			<-11,8,124>, <-9,4,-124>, <-9,4,-121>, <-9,4,-119>,
			<-9,4,-116>, <-9,4,-84>, <-9,4,-81>, <-9,4,-79>,
			<-9,4,-76>, <-9,4,-44>, <-9,4,-41>, <-9,4,-39>,
			<-9,4,-36>, <-9,4,-4>, <-9,4,-1>, <-9,4,-1>,
			<-9,4,1>, <-9,4,1>, <-9,4,4>, <-9,4,36>,
			<-9,4,39>, <-9,4,41>, <-9,4,44>, <-9,4,76>,
			<-9,4,79>, <-9,4,81>, <-9,4,84>, <-9,4,116>,
			<-9,4,119>, <-9,4,121>, <-9,4,124>, <-9,8,-124>,
			<-9,8,-121>, <-9,8,-119>, <-9,8,-116>, <-9,8,-84>,
			<-9,8,-81>, <-9,8,-79>, <-9,8,-76>, <-9,8,-44>,
			<-9,8,-41>, <-9,8,-39>, <-9,8,-36>, <-9,8,-4>,
			<-9,8,-1>, <-9,8,-1>, <-9,8,1>, <-9,8,1>,
			<-9,8,4>, <-9,8,36>, <-9,8,39>, <-9,8,41>,
			<-9,8,44>, <-9,8,76>, <-9,8,79>, <-9,8,81>,
			<-9,8,84>, <-9,8,116>, <-9,8,119>, <-9,8,121>,
			<-9,8,124>, <-8,8,-120>, <-8,8,-80>, <-8,8,-40>,
			<-8,8,0>, <-8,8,40>, <-8,8,80>, <-8,8,120>,
			<-7.801001,4,-121>, <-7.801001,4,-119>, <-7.801001,4,-81>, <-7.801001,4,-79>,
			<-7.801001,4,-41>, <-7.801001,4,-39>, <-7.801001,4,-1>, <-7.801001,4,1>,
			<-7.801001,4,39>, <-7.801001,4,41>, <-7.801001,4,79>, <-7.801001,4,81>,
			<-7.801001,4,119>, <-7.801001,4,121>, <-7.801,8,-121>, <-7.801,8,-119>,
			<-7.801,8,-81>, <-7.801,8,-79>, <-7.801,8,-41>, <-7.801,8,-39>,
			<-7.801,8,-1>, <-7.801001,8,-1>, <-7.801,8,1>, <-7.801001,8,1>,
			<-7.801,8,39>, <-7.801,8,41>, <-7.801,8,79>, <-7.801,8,81>,
			<-7.801,8,119>, <-7.801,8,121>, <-7.391,4,-123.061005>, <-7.391,4,-116.938995>,
			<-7.391,4,-83.061005>, <-7.391,4,-76.938995>, <-7.391,4,-43.060997>, <-7.391,4,-36.939003>,
			<-7.391,4,-3.061>, <-7.391,4,3.061>, <-7.391,4,36.939003>, <-7.391,4,43.060997>,
			<-7.391,4,76.938995>, <-7.391,4,83.061005>, <-7.391,4,116.938995>, <-7.391,4,123.061005>,
			<-7.391,8,-123.061005>, <-7.391,8,-116.938995>, <-7.391,8,-83.061005>, <-7.391,8,-76.938995>,
			<-7.391,8,-43.060997>, <-7.391,8,-36.939003>, <-7.391,8,-3.061>, <-7.391,8,3.061>,
			<-7.391,8,36.939003>, <-7.391,8,43.060997>, <-7.391,8,76.938995>, <-7.391,8,83.061005>,
			<-7.391,8,116.938995>, <-7.391,8,123.061005>, <-5.657,4,-125.657005>, <-5.657,4,-114.343002>,
			<-5.657,4,-85.656998>, <-5.657,4,-74.343002>, <-5.657,4,-45.657001>, <-5.657,4,-34.342999>,
			<-5.657,4,-5.657>, <-5.657,4,5.657>, <-5.657,4,34.342999>, <-5.657,4,45.657001>,
			<-5.657,4,74.343002>, <-5.657,4,85.656998>, <-5.657,4,114.343002>, <-5.657,4,125.657005>,
			<-5.657,8,-125.657005>, <-5.657,8,-114.343002>, <-5.657,8,-85.656998>, <-5.657,8,-74.343002>,
			<-5.657,8,-45.657001>, <-5.657,8,-34.342999>, <-5.657,8,-5.657>, <-5.657,8,5.657>,
			<-5.657,8,34.342999>, <-5.657,8,45.657001>, <-5.657,8,74.343002>, <-5.657,8,85.656998>,
			<-5.657,8,114.343002>, <-5.657,8,125.657005>, <-4,4,-151>, <-4,4,-149>,
			<-4,4,-131>, <-4,4,-129>, <-4,4,-111>, <-4,4,-109>,
			<-4,4,-91>, <-4,4,-89>, <-4,4,-71>, <-4,4,-69>,
			<-4,4,-51>, <-4,4,-49>, <-4,4,-31>, <-4,4,-29>,
			<-4,4,-11>, <-4,4,-9>, <-4,4,9>, <-4,4,11>,
			<-4,4,29>, <-4,4,31>, <-4,4,49>, <-4,4,51>,
			<-4,4,69>, <-4,4,71>, <-4,4,89>, <-4,4,91>,
			<-4,4,109>, <-4,4,111>, <-4,4,129>, <-4,4,131>,
			<-4,4,149>, <-4,4,151>, <-4,8,-151>, <-4,8,-149>,
			<-4,8,-131>, <-4,8,-129>, <-4,8,-111>, <-4,8,-109>,
			<-4,8,-91>, <-4,8,-89>, <-4,8,-71>, <-4,8,-69>,
			<-4,8,-51>, <-4,8,-49>, <-4,8,-31>, <-4,8,-29>,
			<-4,8,-11>, <-4,8,-9>, <-4,8,9>, <-4,8,11>,
			<-4,8,29>, <-4,8,31>, <-4,8,49>, <-4,8,51>,
			<-4,8,69>, <-4,8,71>, <-4,8,89>, <-4,8,91>,
			<-4,8,109>, <-4,8,111>, <-4,8,129>, <-4,8,131>,
			<-4,8,149>, <-4,8,151>, <-3.061,4,-127.390999>, <-3.061,4,-112.608994>,
			<-3.061,4,-87.391006>, <-3.061,4,-72.608994>, <-3.061,4,-47.390999>, <-3.061,4,-32.609001>,
			<-3.061,4,-7.391>, <-3.061,4,7.391>, <-3.061,4,32.609001>, <-3.061,4,47.390999>,
			<-3.061,4,72.608994>, <-3.061,4,87.391006>, <-3.061,4,112.608994>, <-3.061,4,127.390999>,
			<-3.061,8,-127.390999>, <-3.061,8,-112.608994>, <-3.061,8,-87.391006>, <-3.061,8,-72.608994>,
			<-3.061,8,-47.390999>, <-3.061,8,-32.609001>, <-3.061,8,-7.391>, <-3.061,8,7.391>,
			<-3.061,8,32.609001>, <-3.061,8,47.390999>, <-3.061,8,72.608994>, <-3.061,8,87.391006>,
			<-3.061,8,112.608994>, <-3.061,8,127.390999>, <-1,4,-156>, <-1,4,-151>,
			<-1,4,-149>, <-1,4,-131>, <-1,4,-129>, <-1,4,-111>,
			<-1,4,-109>, <-1,4,-91>, <-1,4,-89>, <-1,4,-71>,
			<-1,4,-69>, <-1,4,-51>, <-1,4,-49>, <-1,4,-31>,
			<-1,4,-29>, <-1,4,-11>, <-1,4,-9>, <-1,4,9>,
			<-1,4,11>, <-1,4,29>, <-1,4,31>, <-1,4,49>,
			<-1,4,51>, <-1,4,69>, <-1,4,71>, <-1,4,89>,
			<-1,4,91>, <-1,4,109>, <-1,4,111>, <-1,4,129>,
			<-1,4,131>, <-1,4,149>, <-1,4,151>, <-1,4,156>,
			<-1,8,-156>, <-1,8,-151>, <-1,8,-149>, <-1,8,-131>,
			<-1,8,-129>, <-1,8,-127.801003>, <-1,8,-112.198997>, <-1,8,-111>,
			<-1,8,-109>, <-1,8,-91>, <-1,8,-89>, <-1,8,-87.801003>,
			<-1,8,-72.198997>, <-1,8,-71>, <-1,8,-69>, <-1,8,-51>,
			<-1,8,-49>, <-1,8,-47.800999>, <-1,8,-32.199001>, <-1,8,-31>,
			<-1,8,-29>, <-1,8,-11>, <-1,8,-9>, <-1,8,-7.801>,
			<-1,8,7.801>, <-1,8,9>, <-1,8,11>, <-1,8,29>,
			<-1,8,31>, <-1,8,32.199001>, <-1,8,47.800999>, <-1,8,49>,
			<-1,8,51>, <-1,8,69>, <-1,8,71>, <-1,8,72.198997>,
			<-1,8,87.801003>, <-1,8,89>, <-1,8,91>, <-1,8,109>,
			<-1,8,111>, <-1,8,112.198997>, <-1,8,127.801003>, <-1,8,129>,
			<-1,8,131>, <-1,8,149>, <-1,8,151>, <-1,8,156>,
			<-1,4,-129>, <-1,4,-127.800995>, <-1,4,-112.198997>, <-1,4,-111>,
			<-1,4,-89>, <-1,4,-87.801003>, <-1,4,-72.198997>, <-1,4,-71>,
			<-1,4,-49>, <-1,4,-47.800999>, <-1,4,-32.199001>, <-1,4,-31>,
			<-1,4,-9>, <-1,4,-7.801001>, <-1,4,7.801001>, <-1,4,9>,
			<-1,4,31>, <-1,4,32.199001>, <-1,4,47.800999>, <-1,4,49>,
			<-1,4,71>, <-1,4,72.198997>, <-1,4,87.801003>, <-1,4,89>,
			<-1,4,111>, <-1,4,112.198997>, <-1,4,127.800995>, <-1,4,129>,
			<-1,8,-129>, <-1,8,-127.800995>, <-1,8,-112.198997>, <-1,8,-111>,
			<-1,8,-89>, <-1,8,-87.801003>, <-1,8,-72.198997>, <-1,8,-71>,
			<-1,8,-49>, <-1,8,-47.800999>, <-1,8,-32.199001>, <-1,8,-31>,
			<-1,8,-9>, <-1,8,-7.801001>, <-1,8,7.801001>, <-1,8,9>,
			<-1,8,31>, <-1,8,32.199001>, <-1,8,47.800999>, <-1,8,49>,
			<-1,8,71>, <-1,8,72.198997>, <-1,8,87.801003>, <-1,8,89>,
			<-1,8,111>, <-1,8,112.198997>, <-1,8,127.800995>, <-1,8,129>,
			<0,8,-156>, <0,8,-128>, <0,8,-112>, <0,8,-88>,
			<0,8,-72>, <0,8,-48>, <0,8,-32>, <0,8,-8>,
			<0,8,8>, <0,8,32>, <0,8,48>, <0,8,72>,
			<0,8,88>, <0,8,112>, <0,8,128>, <0,8,156>,
			<1,4,-156>, <1,4,-151>, <1,4,-149>, <1,4,-131>,
			<1,4,-129>, <1,4,-111>, <1,4,-109>, <1,4,-91>,
			<1,4,-89>, <1,4,-71>, <1,4,-69>, <1,4,-51>,
			<1,4,-49>, <1,4,-31>, <1,4,-29>, <1,4,-11>,
			<1,4,-9>, <1,4,9>, <1,4,11>, <1,4,29>,
			<1,4,31>, <1,4,49>, <1,4,51>, <1,4,69>,
			<1,4,71>, <1,4,89>, <1,4,91>, <1,4,109>,
			<1,4,111>, <1,4,129>, <1,4,131>, <1,4,149>,
			<1,4,151>, <1,4,156>, <1,8,-156>, <1,8,-151>,
			<1,8,-149>, <1,8,-131>, <1,8,-129>, <1,8,-127.801003>,
			<1,8,-112.198997>, <1,8,-111>, <1,8,-109>, <1,8,-91>,
			<1,8,-89>, <1,8,-87.801003>, <1,8,-72.198997>, <1,8,-71>,
			<1,8,-69>, <1,8,-51>, <1,8,-49>, <1,8,-47.800999>,
			<1,8,-32.199001>, <1,8,-31>, <1,8,-29>, <1,8,-11>,
			<1,8,-9>, <1,8,-7.801>, <1,8,7.801>, <1,8,9>,
			<1,8,11>, <1,8,29>, <1,8,31>, <1,8,32.199001>,
			<1,8,47.800999>, <1,8,49>, <1,8,51>, <1,8,69>,
			<1,8,71>, <1,8,72.198997>, <1,8,87.801003>, <1,8,89>,
			<1,8,91>, <1,8,109>, <1,8,111>, <1,8,112.198997>,
			<1,8,127.801003>, <1,8,129>, <1,8,131>, <1,8,149>,
			<1,8,151>, <1,8,156>, <1,4,-129>, <1,4,-127.800995>,
			<1,4,-112.198997>, <1,4,-111>, <1,4,-89>, <1,4,-87.801003>,
			<1,4,-72.198997>, <1,4,-71>, <1,4,-49>, <1,4,-47.800999>,
			<1,4,-32.199001>, <1,4,-31>, <1,4,-9>, <1,4,-7.801001>,
			<1,4,7.801001>, <1,4,9>, <1,4,31>, <1,4,32.199001>,
			<1,4,47.800999>, <1,4,49>, <1,4,71>, <1,4,72.198997>,
			<1,4,87.801003>, <1,4,89>, <1,4,111>, <1,4,112.198997>,
			<1,4,127.800995>, <1,4,129>, <1,8,-129>, <1,8,-127.800995>,
			<1,8,-112.198997>, <1,8,-111>, <1,8,-89>, <1,8,-87.801003>,
			<1,8,-72.198997>, <1,8,-71>, <1,8,-49>, <1,8,-47.800999>,
			<1,8,-32.199001>, <1,8,-31>, <1,8,-9>, <1,8,-7.801001>,
			<1,8,7.801001>, <1,8,9>, <1,8,31>, <1,8,32.199001>,
			<1,8,47.800999>, <1,8,49>, <1,8,71>, <1,8,72.198997>,
			<1,8,87.801003>, <1,8,89>, <1,8,111>, <1,8,112.198997>,
			<1,8,127.800995>, <1,8,129>, <3.061,4,-127.390999>, <3.061,4,-112.608994>,
			<3.061,4,-87.391006>, <3.061,4,-72.608994>, <3.061,4,-47.390999>, <3.061,4,-32.609001>,
			<3.061,4,-7.391>, <3.061,4,7.391>, <3.061,4,32.609001>, <3.061,4,47.390999>,
			<3.061,4,72.608994>, <3.061,4,87.391006>, <3.061,4,112.608994>, <3.061,4,127.390999>,
			<3.061,8,-127.390999>, <3.061,8,-112.608994>, <3.061,8,-87.391006>, <3.061,8,-72.608994>,
			<3.061,8,-47.390999>, <3.061,8,-32.609001>, <3.061,8,-7.391>, <3.061,8,7.391>,
			<3.061,8,32.609001>, <3.061,8,47.390999>, <3.061,8,72.608994>, <3.061,8,87.391006>,
			<3.061,8,112.608994>, <3.061,8,127.390999>, <4,4,-151>, <4,4,-149>,
			<4,4,-131>, <4,4,-129>, <4,4,-111>, <4,4,-109>,
			<4,4,-91>, <4,4,-89>, <4,4,-71>, <4,4,-69>,
			<4,4,-51>, <4,4,-49>, <4,4,-31>, <4,4,-29>,
			<4,4,-11>, <4,4,-9>, <4,4,9>, <4,4,11>,
			<4,4,29>, <4,4,31>, <4,4,49>, <4,4,51>,
			<4,4,69>, <4,4,71>, <4,4,89>, <4,4,91>,
			<4,4,109>, <4,4,111>, <4,4,129>, <4,4,131>,
			<4,4,149>, <4,4,151>, <4,8,-151>, <4,8,-149>,
			<4,8,-131>, <4,8,-129>, <4,8,-111>, <4,8,-109>,
			<4,8,-91>, <4,8,-89>, <4,8,-71>, <4,8,-69>,
			<4,8,-51>, <4,8,-49>, <4,8,-31>, <4,8,-29>,
			<4,8,-11>, <4,8,-9>, <4,8,9>, <4,8,11>,
			<4,8,29>, <4,8,31>, <4,8,49>, <4,8,51>,
			<4,8,69>, <4,8,71>, <4,8,89>, <4,8,91>,
			<4,8,109>, <4,8,111>, <4,8,129>, <4,8,131>,
			<4,8,149>, <4,8,151>, <5.657,4,-125.657005>, <5.657,4,-114.343002>,
			<5.657,4,-85.656998>, <5.657,4,-74.343002>, <5.657,4,-45.657001>, <5.657,4,-34.342999>,
			<5.657,4,-5.657>, <5.657,4,5.657>, <5.657,4,34.342999>, <5.657,4,45.657001>,
			<5.657,4,74.343002>, <5.657,4,85.656998>, <5.657,4,114.343002>, <5.657,4,125.657005>,
			<5.657,8,-125.657005>, <5.657,8,-114.343002>, <5.657,8,-85.656998>, <5.657,8,-74.343002>,
			<5.657,8,-45.657001>, <5.657,8,-34.342999>, <5.657,8,-5.657>, <5.657,8,5.657>,
			<5.657,8,34.342999>, <5.657,8,45.657001>, <5.657,8,74.343002>, <5.657,8,85.656998>,
			<5.657,8,114.343002>, <5.657,8,125.657005>, <7.391,4,-123.061005>, <7.391,4,-116.938995>,
			<7.391,4,-83.061005>, <7.391,4,-76.938995>, <7.391,4,-43.060997>, <7.391,4,-36.939003>,
			<7.391,4,-3.061>, <7.391,4,3.061>, <7.391,4,36.939003>, <7.391,4,43.060997>,
			<7.391,4,76.938995>, <7.391,4,83.061005>, <7.391,4,116.938995>, <7.391,4,123.061005>,
			<7.391,8,-123.061005>, <7.391,8,-116.938995>, <7.391,8,-83.061005>, <7.391,8,-76.938995>,
			<7.391,8,-43.060997>, <7.391,8,-36.939003>, <7.391,8,-3.061>, <7.391,8,3.061>,
			<7.391,8,36.939003>, <7.391,8,43.060997>, <7.391,8,76.938995>, <7.391,8,83.061005>,
			<7.391,8,116.938995>, <7.391,8,123.061005>, <7.801001,4,-121>, <7.801001,4,-119>,
			<7.801001,4,-81>, <7.801001,4,-79>, <7.801001,4,-41>, <7.801001,4,-39>,
			<7.801001,4,-1>, <7.801001,4,1>, <7.801001,4,39>, <7.801001,4,41>,
			<7.801001,4,79>, <7.801001,4,81>, <7.801001,4,119>, <7.801001,4,121>,
			<7.801,8,-121>, <7.801,8,-119>, <7.801,8,-81>, <7.801,8,-79>,
			<7.801,8,-41>, <7.801,8,-39>, <7.801,8,-1>, <7.801001,8,-1>,
			<7.801,8,1>, <7.801001,8,1>, <7.801,8,39>, <7.801,8,41>,
			<7.801,8,79>, <7.801,8,81>, <7.801,8,119>, <7.801,8,121>,
			<8,8,-120>, <8,8,-80>, <8,8,-40>, <8,8,0>,
			<8,8,40>, <8,8,80>, <8,8,120>, <9,4,-124>,
			<9,4,-121>, <9,4,-119>, <9,4,-116>, <9,4,-84>,
			<9,4,-81>, <9,4,-79>, <9,4,-76>, <9,4,-44>,
			<9,4,-41>, <9,4,-39>, <9,4,-36>, <9,4,-4>,
			<9,4,-1>, <9,4,-1>, <9,4,1>, <9,4,1>,
			<9,4,4>, <9,4,36>, <9,4,39>, <9,4,41>,
			<9,4,44>, <9,4,76>, <9,4,79>, <9,4,81>,
			<9,4,84>, <9,4,116>, <9,4,119>, <9,4,121>,
			<9,4,124>, <9,8,-124>, <9,8,-121>, <9,8,-119>,
			<9,8,-116>, <9,8,-84>, <9,8,-81>, <9,8,-79>,
			<9,8,-76>, <9,8,-44>, <9,8,-41>, <9,8,-39>,
			<9,8,-36>, <9,8,-4>, <9,8,-1>, <9,8,-1>,
			<9,8,1>, <9,8,1>, <9,8,4>, <9,8,36>,
			<9,8,39>, <9,8,41>, <9,8,44>, <9,8,76>,
			<9,8,79>, <9,8,81>, <9,8,84>, <9,8,116>,
			<9,8,119>, <9,8,121>, <9,8,124>, <11,4,-124>,
			<11,4,-121>, <11,4,-119>, <11,4,-116>, <11,4,-84>,
			<11,4,-81>, <11,4,-79>, <11,4,-76>, <11,4,-44>,
			<11,4,-41>, <11,4,-39>, <11,4,-36>, <11,4,-4>,
			<11,4,-1>, <11,4,1>, <11,4,4>, <11,4,36>,
			<11,4,39>, <11,4,41>, <11,4,44>, <11,4,76>,
			<11,4,79>, <11,4,81>, <11,4,84>, <11,4,116>,
			<11,4,119>, <11,4,121>, <11,4,124>, <11,8,-124>,
			<11,8,-121>, <11,8,-119>, <11,8,-116>, <11,8,-84>,
			<11,8,-81>, <11,8,-79>, <11,8,-76>, <11,8,-44>,
			<11,8,-41>, <11,8,-39>, <11,8,-36>, <11,8,-4>,
			<11,8,-1>, <11,8,1>, <11,8,4>, <11,8,36>,
			<11,8,39>, <11,8,41>, <11,8,44>, <11,8,76>,
			<11,8,79>, <11,8,81>, <11,8,84>, <11,8,116>,
			<11,8,119>, <11,8,121>, <11,8,124>, <29,4,-124>,
			<29,4,-121>, <29,4,-119>, <29,4,-116>, <29,4,-84>,
			<29,4,-81>, <29,4,-79>, <29,4,-76>, <29,4,-44>,
			<29,4,-41>, <29,4,-39>, <29,4,-36>, <29,4,-4>,
			<29,4,-1>, <29,4,1>, <29,4,4>, <29,4,36>,
			<29,4,39>, <29,4,41>, <29,4,44>, <29,4,76>,
			<29,4,79>, <29,4,81>, <29,4,84>, <29,4,116>,
			<29,4,119>, <29,4,121>, <29,4,124>, <29,8,-124>,
			<29,8,-121>, <29,8,-119>, <29,8,-116>, <29,8,-84>,
			<29,8,-81>, <29,8,-79>, <29,8,-76>, <29,8,-44>,
			<29,8,-41>, <29,8,-39>, <29,8,-36>, <29,8,-4>,
			<29,8,-1>, <29,8,1>, <29,8,4>, <29,8,36>,
			<29,8,39>, <29,8,41>, <29,8,44>, <29,8,76>,
			<29,8,79>, <29,8,81>, <29,8,84>, <29,8,116>,
			<29,8,119>, <29,8,121>, <29,8,124>, <31,4,-124>,
			<31,4,-121>, <31,4,-119>, <31,4,-116>, <31,4,-84>,
			<31,4,-81>, <31,4,-79>, <31,4,-76>, <31,4,-44>,
			<31,4,-41>, <31,4,-39>, <31,4,-36>, <31,4,-4>,
			<31,4,-1>, <31,4,-1>, <31,4,1>, <31,4,1>,
			<31,4,4>, <31,4,36>, <31,4,39>, <31,4,41>,
			<31,4,44>, <31,4,76>, <31,4,79>, <31,4,81>,
			<31,4,84>, <31,4,116>, <31,4,119>, <31,4,121>,
			<31,4,124>, <31,8,-124>, <31,8,-121>, <31,8,-119>,
			<31,8,-116>, <31,8,-84>, <31,8,-81>, <31,8,-79>,
			<31,8,-76>, <31,8,-44>, <31,8,-41>, <31,8,-39>,
			<31,8,-36>, <31,8,-4>, <31,8,-1>, <31,8,-1>,
			<31,8,1>, <31,8,1>, <31,8,4>, <31,8,36>,
			<31,8,39>, <31,8,41>, <31,8,44>, <31,8,76>,
			<31,8,79>, <31,8,81>, <31,8,84>, <31,8,116>,
			<31,8,119>, <31,8,121>, <31,8,124>, <32,8,-120>,
			<32,8,-80>, <32,8,-40>, <32,8,0>, <32,8,40>,
			<32,8,80>, <32,8,120>, <32.199001,4,-121>, <32.199001,4,-119>,
			<32.199001,4,-81>, <32.199001,4,-79>, <32.199001,4,-41>, <32.199001,4,-39>,
			<32.199001,4,-1>, <32.199001,4,1>, <32.199001,4,39>, <32.199001,4,41>,
			<32.199001,4,79>, <32.199001,4,81>, <32.199001,4,119>, <32.199001,4,121>,
			<32.199001,8,-121>, <32.199001,8,-119>, <32.199001,8,-81>, <32.199001,8,-79>,
			<32.199001,8,-41>, <32.199001,8,-39>, <32.199001,8,-1>, <32.199001,8,-1>,
			<32.199001,8,1>, <32.199001,8,1>, <32.199001,8,39>, <32.199001,8,41>,
			<32.199001,8,79>, <32.199001,8,81>, <32.199001,8,119>, <32.199001,8,121>,
			<32.609001,4,-123.061005>, <32.609001,4,-116.938995>, <32.609001,4,-83.061005>, <32.609001,4,-76.938995>,
			<32.609001,4,-43.060997>, <32.609001,4,-36.939003>, <32.609001,4,-3.061>, <32.609001,4,3.061>,
			<32.609001,4,36.939003>, <32.609001,4,43.060997>, <32.609001,4,76.938995>, <32.609001,4,83.061005>,
			<32.609001,4,116.938995>, <32.609001,4,123.061005>, <32.609001,8,-123.061005>, <32.609001,8,-116.938995>,
			<32.609001,8,-83.061005>, <32.609001,8,-76.938995>, <32.609001,8,-43.060997>, <32.609001,8,-36.939003>,
			<32.609001,8,-3.061>, <32.609001,8,3.061>, <32.609001,8,36.939003>, <32.609001,8,43.060997>,
			<32.609001,8,76.938995>, <32.609001,8,83.061005>, <32.609001,8,116.938995>, <32.609001,8,123.061005>,
			<34.342999,4,-125.657005>, <34.342999,4,-114.343002>, <34.342999,4,-85.656998>, <34.342999,4,-74.343002>,
			<34.342999,4,-45.657001>, <34.342999,4,-34.342999>, <34.342999,4,-5.657>, <34.342999,4,5.657>,
			<34.342999,4,34.342999>, <34.342999,4,45.657001>, <34.342999,4,74.343002>, <34.342999,4,85.656998>,
			<34.342999,4,114.343002>, <34.342999,4,125.657005>, <34.342999,8,-125.657005>, <34.342999,8,-114.343002>,
			<34.342999,8,-85.656998>, <34.342999,8,-74.343002>, <34.342999,8,-45.657001>, <34.342999,8,-34.342999>,
			<34.342999,8,-5.657>, <34.342999,8,5.657>, <34.342999,8,34.342999>, <34.342999,8,45.657001>,
			<34.342999,8,74.343002>, <34.342999,8,85.656998>, <34.342999,8,114.343002>, <34.342999,8,125.657005>,
			<36,4,-151>, <36,4,-149>, <36,4,-131>, <36,4,-129>,
			<36,4,-111>, <36,4,-109>, <36,4,-91>, <36,4,-89>,
			<36,4,-71>, <36,4,-69>, <36,4,-51>, <36,4,-49>,
			<36,4,-31>, <36,4,-29>, <36,4,-11>, <36,4,-9>,
			<36,4,9>, <36,4,11>, <36,4,29>, <36,4,31>,
			<36,4,49>, <36,4,51>, <36,4,69>, <36,4,71>,
			<36,4,89>, <36,4,91>, <36,4,109>, <36,4,111>,
			<36,4,129>, <36,4,131>, <36,4,149>, <36,4,151>,
			<36,8,-151>, <36,8,-149>, <36,8,-131>, <36,8,-129>,
			<36,8,-111>, <36,8,-109>, <36,8,-91>, <36,8,-89>,
			<36,8,-71>, <36,8,-69>, <36,8,-51>, <36,8,-49>,
			<36,8,-31>, <36,8,-29>, <36,8,-11>, <36,8,-9>,
			<36,8,9>, <36,8,11>, <36,8,29>, <36,8,31>,
			<36,8,49>, <36,8,51>, <36,8,69>, <36,8,71>,
			<36,8,89>, <36,8,91>, <36,8,109>, <36,8,111>,
			<36,8,129>, <36,8,131>, <36,8,149>, <36,8,151>,
			<36.939003,4,-127.390999>, <36.939003,4,-112.608994>, <36.939003,4,-87.391006>, <36.939003,4,-72.608994>,
			<36.939003,4,-47.390999>, <36.939003,4,-32.609001>, <36.939003,4,-7.391>, <36.939003,4,7.391>,
			<36.939003,4,32.609001>, <36.939003,4,47.390999>, <36.939003,4,72.608994>, <36.939003,4,87.391006>,
			<36.939003,4,112.608994>, <36.939003,4,127.390999>, <36.939003,8,-127.390999>, <36.939003,8,-112.608994>,
			<36.939003,8,-87.391006>, <36.939003,8,-72.608994>, <36.939003,8,-47.390999>, <36.939003,8,-32.609001>,
			<36.939003,8,-7.391>, <36.939003,8,7.391>, <36.939003,8,32.609001>, <36.939003,8,47.390999>,
			<36.939003,8,72.608994>, <36.939003,8,87.391006>, <36.939003,8,112.608994>, <36.939003,8,127.390999>,
			<39,4,-156>, <39,4,-151>, <39,4,-149>, <39,4,-131>,
			<39,4,-129>, <39,4,-127.800995>, <39,4,-112.198997>, <39,4,-111>,
			<39,4,-109>, <39,4,-91>, <39,4,-89>, <39,4,-87.801003>,
			<39,4,-72.198997>, <39,4,-71>, <39,4,-69>, <39,4,-51>,
			<39,4,-49>, <39,4,-47.800999>, <39,4,-32.199001>, <39,4,-31>,
			<39,4,-29>, <39,4,-11>, <39,4,-9>, <39,4,-7.801001>,
			<39,4,7.801001>, <39,4,9>, <39,4,11>, <39,4,29>,
			<39,4,31>, <39,4,32.199001>, <39,4,47.800999>, <39,4,49>,
			<39,4,51>, <39,4,69>, <39,4,71>, <39,4,72.198997>,
			<39,4,87.801003>, <39,4,89>, <39,4,91>, <39,4,109>,
			<39,4,111>, <39,4,112.198997>, <39,4,127.800995>, <39,4,129>,
			<39,4,131>, <39,4,149>, <39,4,151>, <39,4,156>,
			<39,8,-156>, <39,8,-151>, <39,8,-149>, <39,8,-131>,
			<39,8,-129>, <39,8,-127.801003>, <39,8,-112.198997>, <39,8,-111>,
			<39,8,-109>, <39,8,-91>, <39,8,-89>, <39,8,-87.801003>,
			<39,8,-72.198997>, <39,8,-71>, <39,8,-69>, <39,8,-51>,
			<39,8,-49>, <39,8,-47.800999>, <39,8,-32.199001>, <39,8,-31>,
			<39,8,-29>, <39,8,-11>, <39,8,-9>, <39,8,-7.801>,
			<39,8,7.801>, <39,8,9>, <39,8,11>, <39,8,29>,
			<39,8,31>, <39,8,32.199001>, <39,8,47.800999>, <39,8,49>,
			<39,8,51>, <39,8,69>, <39,8,71>, <39,8,72.198997>,
			<39,8,87.801003>, <39,8,89>, <39,8,91>, <39,8,109>,
			<39,8,111>, <39,8,112.198997>, <39,8,127.801003>, <39,8,129>,
			<39,8,131>, <39,8,149>, <39,8,151>, <39,8,156>,
			<40,8,-156>, <40,8,-128>, <40,8,-112>, <40,8,-88>,
			<40,8,-72>, <40,8,-48>, <40,8,-32>, <40,8,-8>,
			<40,8,8>, <40,8,32>, <40,8,48>, <40,8,72>,
			<40,8,88>, <40,8,112>, <40,8,128>, <40,8,156>,
			<41,4,-156>, <41,4,-151>, <41,4,-149>, <41,4,-131>,
			<41,4,-129>, <41,4,-127.800995>, <41,4,-112.198997>, <41,4,-111>,
			<41,4,-109>, <41,4,-91>, <41,4,-89>, <41,4,-87.801003>,
			<41,4,-72.198997>, <41,4,-71>, <41,4,-69>, <41,4,-51>,
			<41,4,-49>, <41,4,-47.800999>, <41,4,-32.199001>, <41,4,-31>,
			<41,4,-29>, <41,4,-11>, <41,4,-9>, <41,4,-7.801001>,
			<41,4,7.801001>, <41,4,9>, <41,4,11>, <41,4,29>,
			<41,4,31>, <41,4,32.199001>, <41,4,47.800999>, <41,4,49>,
			<41,4,51>, <41,4,69>, <41,4,71>, <41,4,72.198997>,
			<41,4,87.801003>, <41,4,89>, <41,4,91>, <41,4,109>,
			<41,4,111>, <41,4,112.198997>, <41,4,127.800995>, <41,4,129>,
			<41,4,131>, <41,4,149>, <41,4,151>, <41,4,156>,
			<41,8,-156>, <41,8,-151>, <41,8,-149>, <41,8,-131>,
			<41,8,-129>, <41,8,-127.801003>, <41,8,-112.198997>, <41,8,-111>,
			<41,8,-109>, <41,8,-91>, <41,8,-89>, <41,8,-87.801003>,
			<41,8,-72.198997>, <41,8,-71>, <41,8,-69>, <41,8,-51>,
			<41,8,-49>, <41,8,-47.800999>, <41,8,-32.199001>, <41,8,-31>,
			<41,8,-29>, <41,8,-11>, <41,8,-9>, <41,8,-7.801>,
			<41,8,7.801>, <41,8,9>, <41,8,11>, <41,8,29>,
			<41,8,31>, <41,8,32.199001>, <41,8,47.800999>, <41,8,49>,
			<41,8,51>, <41,8,69>, <41,8,71>, <41,8,72.198997>,
			<41,8,87.801003>, <41,8,89>, <41,8,91>, <41,8,109>,
			<41,8,111>, <41,8,112.198997>, <41,8,127.801003>, <41,8,129>,
			<41,8,131>, <41,8,149>, <41,8,151>, <41,8,156>,
			<43.060997,4,-127.390999>, <43.060997,4,-112.608994>, <43.060997,4,-87.391006>, <43.060997,4,-72.608994>,
			<43.060997,4,-47.390999>, <43.060997,4,-32.609001>, <43.060997,4,-7.391>, <43.060997,4,7.391>,
			<43.060997,4,32.609001>, <43.060997,4,47.390999>, <43.060997,4,72.608994>, <43.060997,4,87.391006>,
			<43.060997,4,112.608994>, <43.060997,4,127.390999>, <43.060997,8,-127.390999>, <43.060997,8,-112.608994>,
			<43.060997,8,-87.391006>, <43.060997,8,-72.608994>, <43.060997,8,-47.390999>, <43.060997,8,-32.609001>,
			<43.060997,8,-7.391>, <43.060997,8,7.391>, <43.060997,8,32.609001>, <43.060997,8,47.390999>,
			<43.060997,8,72.608994>, <43.060997,8,87.391006>, <43.060997,8,112.608994>, <43.060997,8,127.390999>,
			<44,4,-151>, <44,4,-149>, <44,4,-131>, <44,4,-129>,
			<44,4,-111>, <44,4,-109>, <44,4,-91>, <44,4,-89>,
			<44,4,-71>, <44,4,-69>, <44,4,-51>, <44,4,-49>,
			<44,4,-31>, <44,4,-29>, <44,4,-11>, <44,4,-9>,
			<44,4,9>, <44,4,11>, <44,4,29>, <44,4,31>,
			<44,4,49>, <44,4,51>, <44,4,69>, <44,4,71>,
			<44,4,89>, <44,4,91>, <44,4,109>, <44,4,111>,
			<44,4,129>, <44,4,131>, <44,4,149>, <44,4,151>,
			<44,8,-151>, <44,8,-149>, <44,8,-131>, <44,8,-129>,
			<44,8,-111>, <44,8,-109>, <44,8,-91>, <44,8,-89>,
			<44,8,-71>, <44,8,-69>, <44,8,-51>, <44,8,-49>,
			<44,8,-31>, <44,8,-29>, <44,8,-11>, <44,8,-9>,
			<44,8,9>, <44,8,11>, <44,8,29>, <44,8,31>,
			<44,8,49>, <44,8,51>, <44,8,69>, <44,8,71>,
			<44,8,89>, <44,8,91>, <44,8,109>, <44,8,111>,
			<44,8,129>, <44,8,131>, <44,8,149>, <44,8,151>,
			<45.657001,4,-125.657005>, <45.657001,4,-114.343002>, <45.657001,4,-85.656998>, <45.657001,4,-74.343002>,
			<45.657001,4,-45.657001>, <45.657001,4,-34.342999>, <45.657001,4,-5.657>, <45.657001,4,5.657>,
			<45.657001,4,34.342999>, <45.657001,4,45.657001>, <45.657001,4,74.343002>, <45.657001,4,85.656998>,
			<45.657001,4,114.343002>, <45.657001,4,125.657005>, <45.657001,8,-125.657005>, <45.657001,8,-114.343002>,
			<45.657001,8,-85.656998>, <45.657001,8,-74.343002>, <45.657001,8,-45.657001>, <45.657001,8,-34.342999>,
			<45.657001,8,-5.657>, <45.657001,8,5.657>, <45.657001,8,34.342999>, <45.657001,8,45.657001>,
			<45.657001,8,74.343002>, <45.657001,8,85.656998>, <45.657001,8,114.343002>, <45.657001,8,125.657005>,
			<47.390999,4,-123.061005>, <47.390999,4,-116.938995>, <47.390999,4,-83.061005>, <47.390999,4,-76.938995>,
			<47.390999,4,-43.060997>, <47.390999,4,-36.939003>, <47.390999,4,-3.061>, <47.390999,4,3.061>,
			<47.390999,4,36.939003>, <47.390999,4,43.060997>, <47.390999,4,76.938995>, <47.390999,4,83.061005>,
			<47.390999,4,116.938995>, <47.390999,4,123.061005>, <47.390999,8,-123.061005>, <47.390999,8,-116.938995>,
			<47.390999,8,-83.061005>, <47.390999,8,-76.938995>, <47.390999,8,-43.060997>, <47.390999,8,-36.939003>,
			<47.390999,8,-3.061>, <47.390999,8,3.061>, <47.390999,8,36.939003>, <47.390999,8,43.060997>,
			<47.390999,8,76.938995>, <47.390999,8,83.061005>, <47.390999,8,116.938995>, <47.390999,8,123.061005>,
			<47.800999,4,-121>, <47.800999,4,-119>, <47.800999,4,-81>, <47.800999,4,-79>,
			<47.800999,4,-41>, <47.800999,4,-39>, <47.800999,4,-1>, <47.800999,4,1>,
			<47.800999,4,39>, <47.800999,4,41>, <47.800999,4,79>, <47.800999,4,81>,
			<47.800999,4,119>, <47.800999,4,121>, <47.800999,8,-121>, <47.800999,8,-119>,
			<47.800999,8,-81>, <47.800999,8,-79>, <47.800999,8,-41>, <47.800999,8,-39>,
			<47.800999,8,-1>, <47.800999,8,-1>, <47.800999,8,1>, <47.800999,8,1>,
			<47.800999,8,39>, <47.800999,8,41>, <47.800999,8,79>, <47.800999,8,81>,
			<47.800999,8,119>, <47.800999,8,121>, <48,8,-120>, <48,8,-80>,
			<48,8,-40>, <48,8,0>, <48,8,40>, <48,8,80>,
			<48,8,120>, <49,4,-124>, <49,4,-121>, <49,4,-119>,
			<49,4,-116>, <49,4,-84>, <49,4,-81>, <49,4,-79>,
			<49,4,-76>, <49,4,-44>, <49,4,-41>, <49,4,-39>,
			<49,4,-36>, <49,4,-4>, <49,4,-1>, <49,4,-1>,
			<49,4,1>, <49,4,1>, <49,4,4>, <49,4,36>,
			<49,4,39>, <49,4,41>, <49,4,44>, <49,4,76>,
			<49,4,79>, <49,4,81>, <49,4,84>, <49,4,116>,
			<49,4,119>, <49,4,121>, <49,4,124>, <49,8,-124>,
			<49,8,-121>, <49,8,-119>, <49,8,-116>, <49,8,-84>,
			<49,8,-81>, <49,8,-79>, <49,8,-76>, <49,8,-44>,
			<49,8,-41>, <49,8,-39>, <49,8,-36>, <49,8,-4>,
			<49,8,-1>, <49,8,-1>, <49,8,1>, <49,8,1>,
			<49,8,4>, <49,8,36>, <49,8,39>, <49,8,41>,
			<49,8,44>, <49,8,76>, <49,8,79>, <49,8,81>,
			<49,8,84>, <49,8,116>, <49,8,119>, <49,8,121>,
			<49,8,124>, <51,4,-124>, <51,4,-121>, <51,4,-119>,
			<51,4,-116>, <51,4,-84>, <51,4,-81>, <51,4,-79>,
			<51,4,-76>, <51,4,-44>, <51,4,-41>, <51,4,-39>,
			<51,4,-36>, <51,4,-4>, <51,4,-1>, <51,4,1>,
			<51,4,4>, <51,4,36>, <51,4,39>, <51,4,41>,
			<51,4,44>, <51,4,76>, <51,4,79>, <51,4,81>,
			<51,4,84>, <51,4,116>, <51,4,119>, <51,4,121>,
			<51,4,124>, <51,8,-124>, <51,8,-121>, <51,8,-119>,
			<51,8,-116>, <51,8,-84>, <51,8,-81>, <51,8,-79>,
			<51,8,-76>, <51,8,-44>, <51,8,-41>, <51,8,-39>,
			<51,8,-36>, <51,8,-4>, <51,8,-1>, <51,8,1>,
			<51,8,4>, <51,8,36>, <51,8,39>, <51,8,41>,
			<51,8,44>, <51,8,76>, <51,8,79>, <51,8,81>,
			<51,8,84>, <51,8,116>, <51,8,119>, <51,8,121>,
			<51,8,124>, <69,4,-124>, <69,4,-121>, <69,4,-119>,
			<69,4,-116>, <69,4,-84>, <69,4,-81>, <69,4,-79>,
			<69,4,-76>, <69,4,-44>, <69,4,-41>, <69,4,-39>,
			<69,4,-36>, <69,4,-4>, <69,4,-1>, <69,4,1>,
			<69,4,4>, <69,4,36>, <69,4,39>, <69,4,41>,
			<69,4,44>, <69,4,76>, <69,4,79>, <69,4,81>,
			<69,4,84>, <69,4,116>, <69,4,119>, <69,4,121>,
			<69,4,124>, <69,8,-124>, <69,8,-121>, <69,8,-119>,
			<69,8,-116>, <69,8,-84>, <69,8,-81>, <69,8,-79>,
			<69,8,-76>, <69,8,-44>, <69,8,-41>, <69,8,-39>,
			<69,8,-36>, <69,8,-4>, <69,8,-1>, <69,8,1>,
			<69,8,4>, <69,8,36>, <69,8,39>, <69,8,41>,
			<69,8,44>, <69,8,76>, <69,8,79>, <69,8,81>,
			<69,8,84>, <69,8,116>, <69,8,119>, <69,8,121>,
			<69,8,124>, <71,4,-124>, <71,4,-121>, <71,4,-119>,
			<71,4,-116>, <71,4,-84>, <71,4,-81>, <71,4,-79>,
			<71,4,-76>, <71,4,-44>, <71,4,-41>, <71,4,-39>,
			<71,4,-36>, <71,4,-4>, <71,4,-1>, <71,4,-1>,
			<71,4,1>, <71,4,1>, <71,4,4>, <71,4,36>,
			<71,4,39>, <71,4,41>, <71,4,44>, <71,4,76>,
			<71,4,79>, <71,4,81>, <71,4,84>, <71,4,116>,
			<71,4,119>, <71,4,121>, <71,4,124>, <71,8,-124>,
			<71,8,-121>, <71,8,-119>, <71,8,-116>, <71,8,-84>,
			<71,8,-81>, <71,8,-79>, <71,8,-76>, <71,8,-44>,
			<71,8,-41>, <71,8,-39>, <71,8,-36>, <71,8,-4>,
			<71,8,-1>, <71,8,-1>, <71,8,1>, <71,8,1>,
			<71,8,4>, <71,8,36>, <71,8,39>, <71,8,41>,
			<71,8,44>, <71,8,76>, <71,8,79>, <71,8,81>,
			<71,8,84>, <71,8,116>, <71,8,119>, <71,8,121>,
			<71,8,124>, <72,8,-120>, <72,8,-80>, <72,8,-40>,
			<72,8,0>, <72,8,40>, <72,8,80>, <72,8,120>,
			<72.198997,4,-121>, <72.198997,4,-119>, <72.198997,4,-81>, <72.198997,4,-79>,
			<72.198997,4,-41>, <72.198997,4,-39>, <72.198997,4,-1>, <72.198997,4,1>,
			<72.198997,4,39>, <72.198997,4,41>, <72.198997,4,79>, <72.198997,4,81>,
			<72.198997,4,119>, <72.198997,4,121>, <72.198997,8,-121>, <72.198997,8,-119>,
			<72.198997,8,-81>, <72.198997,8,-79>, <72.198997,8,-41>, <72.198997,8,-39>,
			<72.198997,8,-1>, <72.198997,8,-1>, <72.198997,8,1>, <72.198997,8,1>,
			<72.198997,8,39>, <72.198997,8,41>, <72.198997,8,79>, <72.198997,8,81>,
			<72.198997,8,119>, <72.198997,8,121>, <72.608994,4,-123.061005>, <72.608994,4,-116.938995>,
			<72.608994,4,-83.061005>, <72.608994,4,-76.938995>, <72.608994,4,-43.060997>, <72.608994,4,-36.939003>,
			<72.608994,4,-3.061>, <72.608994,4,3.061>, <72.608994,4,36.939003>, <72.608994,4,43.060997>,
			<72.608994,4,76.938995>, <72.608994,4,83.061005>, <72.608994,4,116.938995>, <72.608994,4,123.061005>,
			<72.608994,8,-123.061005>, <72.608994,8,-116.938995>, <72.608994,8,-83.061005>, <72.608994,8,-76.938995>,
			<72.608994,8,-43.060997>, <72.608994,8,-36.939003>, <72.608994,8,-3.061>, <72.608994,8,3.061>,
			<72.608994,8,36.939003>, <72.608994,8,43.060997>, <72.608994,8,76.938995>, <72.608994,8,83.061005>,
			<72.608994,8,116.938995>, <72.608994,8,123.061005>, <74.343002,4,-125.657005>, <74.342995,4,-114.343002>,
			<74.342995,4,-85.656998>, <74.342995,4,-74.343002>, <74.342995,4,-45.657001>, <74.342995,4,-34.342999>,
			<74.342995,4,-5.657>, <74.342995,4,5.657>, <74.342995,4,34.342999>, <74.342995,4,45.657001>,
			<74.342995,4,74.343002>, <74.342995,4,85.656998>, <74.342995,4,114.343002>, <74.343002,4,125.657005>,
			<74.343002,8,-125.657005>, <74.342995,8,-114.343002>, <74.342995,8,-85.656998>, <74.342995,8,-74.343002>,
			<74.342995,8,-45.657001>, <74.342995,8,-34.342999>, <74.342995,8,-5.657>, <74.342995,8,5.657>,
			<74.342995,8,34.342999>, <74.342995,8,45.657001>, <74.342995,8,74.343002>, <74.342995,8,85.656998>,
			<74.342995,8,114.343002>, <74.343002,8,125.657005>, <76,4,-151>, <76,4,-149>,
			<76,4,-131>, <76,4,-129>, <76,4,-111>, <76,4,-109>,
			<76,4,-91>, <76,4,-89>, <76,4,-71>, <76,4,-69>,
			<76,4,-51>, <76,4,-49>, <76,4,-31>, <76,4,-29>,
			<76,4,-11>, <76,4,-9>, <76,4,9>, <76,4,11>,
			<76,4,29>, <76,4,31>, <76,4,49>, <76,4,51>,
			<76,4,69>, <76,4,71>, <76,4,89>, <76,4,91>,
			<76,4,109>, <76,4,111>, <76,4,129>, <76,4,131>,
			<76,4,149>, <76,4,151>, <76,8,-151>, <76,8,-149>,
			<76,8,-131>, <76,8,-129>, <76,8,-111>, <76,8,-109>,
			<76,8,-91>, <76,8,-89>, <76,8,-71>, <76,8,-69>,
			<76,8,-51>, <76,8,-49>, <76,8,-31>, <76,8,-29>,
			<76,8,-11>, <76,8,-9>, <76,8,9>, <76,8,11>,
			<76,8,29>, <76,8,31>, <76,8,49>, <76,8,51>,
			<76,8,69>, <76,8,71>, <76,8,89>, <76,8,91>,
			<76,8,109>, <76,8,111>, <76,8,129>, <76,8,131>,
			<76,8,149>, <76,8,151>, <76.938995,4,-127.390999>, <76.938995,4,-112.608994>,
			<76.938995,4,-87.391006>, <76.938995,4,-72.608994>, <76.938995,4,-47.390999>, <76.938995,4,-32.609001>,
			<76.938995,4,-7.391>, <76.938995,4,7.391>, <76.938995,4,32.609001>, <76.938995,4,47.390999>,
			<76.938995,4,72.608994>, <76.938995,4,87.391006>, <76.938995,4,112.608994>, <76.938995,4,127.390999>,
			<76.938995,8,-127.390999>, <76.938995,8,-112.608994>, <76.938995,8,-87.391006>, <76.938995,8,-72.608994>,
			<76.938995,8,-47.390999>, <76.938995,8,-32.609001>, <76.938995,8,-7.391>, <76.938995,8,7.391>,
			<76.938995,8,32.609001>, <76.938995,8,47.390999>, <76.938995,8,72.608994>, <76.938995,8,87.391006>,
			<76.938995,8,112.608994>, <76.938995,8,127.390999>, <79,4,-156>, <79,4,-151>,
			<79,4,-149>, <79,4,-131>, <79,4,-129>, <79,4,-127.800995>,
			<79,4,-112.198997>, <79,4,-111>, <79,4,-109>, <79,4,-91>,
			<79,4,-89>, <79,4,-87.801003>, <79,4,-72.198997>, <79,4,-71>,
			<79,4,-69>, <79,4,-51>, <79,4,-49>, <79,4,-47.800999>,
			<79,4,-32.199001>, <79,4,-31>, <79,4,-29>, <79,4,-11>,
			<79,4,-9>, <79,4,-7.801001>, <79,4,7.801001>, <79,4,9>,
			<79,4,11>, <79,4,29>, <79,4,31>, <79,4,32.199001>,
			<79,4,47.800999>, <79,4,49>, <79,4,51>, <79,4,69>,
			<79,4,71>, <79,4,72.198997>, <79,4,87.801003>, <79,4,89>,
			<79,4,91>, <79,4,109>, <79,4,111>, <79,4,112.198997>,
			<79,4,127.800995>, <79,4,129>, <79,4,131>, <79,4,149>,
			<79,4,151>, <79,4,156>, <79,8,-156>, <79,8,-151>,
			<79,8,-149>, <79,8,-131>, <79,8,-129>, <79,8,-127.801003>,
			<79,8,-112.198997>, <79,8,-111>, <79,8,-109>, <79,8,-91>,
			<79,8,-89>, <79,8,-87.801003>, <79,8,-72.198997>, <79,8,-71>,
			<79,8,-69>, <79,8,-51>, <79,8,-49>, <79,8,-47.800999>,
			<79,8,-32.199001>, <79,8,-31>, <79,8,-29>, <79,8,-11>,
			<79,8,-9>, <79,8,-7.801>, <79,8,7.801>, <79,8,9>,
			<79,8,11>, <79,8,29>, <79,8,31>, <79,8,32.199001>,
			<79,8,47.800999>, <79,8,49>, <79,8,51>, <79,8,69>,
			<79,8,71>, <79,8,72.198997>, <79,8,87.801003>, <79,8,89>,
			<79,8,91>, <79,8,109>, <79,8,111>, <79,8,112.198997>,
			<79,8,127.801003>, <79,8,129>, <79,8,131>, <79,8,149>,
			<79,8,151>, <79,8,156>, <80,8,-156>, <80,8,-128>,
			<80,8,-112>, <80,8,-88>, <80,8,-72>, <80,8,-48>,
			<80,8,-32>, <80,8,-8>, <80,8,8>, <80,8,32>,
			<80,8,48>, <80,8,72>, <80,8,88>, <80,8,112>,
			<80,8,128>, <80,8,156>, <81,4,-156>, <81,4,-151>,
			<81,4,-149>, <81,4,-131>, <81,4,-129>, <81,4,-127.800995>,
			<81,4,-112.198997>, <81,4,-111>, <81,4,-109>, <81,4,-91>,
			<81,4,-89>, <81,4,-87.801003>, <81,4,-72.198997>, <81,4,-71>,
			<81,4,-69>, <81,4,-51>, <81,4,-49>, <81,4,-47.800999>,
			<81,4,-32.199001>, <81,4,-31>, <81,4,-29>, <81,4,-11>,
			<81,4,-9>, <81,4,-7.801001>, <81,4,7.801001>, <81,4,9>,
			<81,4,11>, <81,4,29>, <81,4,31>, <81,4,32.199001>,
			<81,4,47.800999>, <81,4,49>, <81,4,51>, <81,4,69>,
			<81,4,71>, <81,4,72.198997>, <81,4,87.801003>, <81,4,89>,
			<81,4,91>, <81,4,109>, <81,4,111>, <81,4,112.198997>,
			<81,4,127.800995>, <81,4,129>, <81,4,131>, <81,4,149>,
			<81,4,151>, <81,4,156>, <81,8,-156>, <81,8,-151>,
			<81,8,-149>, <81,8,-131>, <81,8,-129>, <81,8,-127.801003>,
			<81,8,-112.198997>, <81,8,-111>, <81,8,-109>, <81,8,-91>,
			<81,8,-89>, <81,8,-87.801003>, <81,8,-72.198997>, <81,8,-71>,
			<81,8,-69>, <81,8,-51>, <81,8,-49>, <81,8,-47.800999>,
			<81,8,-32.199001>, <81,8,-31>, <81,8,-29>, <81,8,-11>,
			<81,8,-9>, <81,8,-7.801>, <81,8,7.801>, <81,8,9>,
			<81,8,11>, <81,8,29>, <81,8,31>, <81,8,32.199001>,
			<81,8,47.800999>, <81,8,49>, <81,8,51>, <81,8,69>,
			<81,8,71>, <81,8,72.198997>, <81,8,87.801003>, <81,8,89>,
			<81,8,91>, <81,8,109>, <81,8,111>, <81,8,112.198997>,
			<81,8,127.801003>, <81,8,129>, <81,8,131>, <81,8,149>,
			<81,8,151>, <81,8,156>, <83.061005,4,-127.390999>, <83.061005,4,-112.608994>,
			<83.061005,4,-87.391006>, <83.061005,4,-72.608994>, <83.061005,4,-47.390999>, <83.061005,4,-32.609001>,
			<83.061005,4,-7.391>, <83.061005,4,7.391>, <83.061005,4,32.609001>, <83.061005,4,47.390999>,
			<83.061005,4,72.608994>, <83.061005,4,87.391006>, <83.061005,4,112.608994>, <83.061005,4,127.390999>,
			<83.061005,8,-127.390999>, <83.061005,8,-112.608994>, <83.061005,8,-87.391006>, <83.061005,8,-72.608994>,
			<83.061005,8,-47.390999>, <83.061005,8,-32.609001>, <83.061005,8,-7.391>, <83.061005,8,7.391>,
			<83.061005,8,32.609001>, <83.061005,8,47.390999>, <83.061005,8,72.608994>, <83.061005,8,87.391006>,
			<83.061005,8,112.608994>, <83.061005,8,127.390999>, <84,4,-151>, <84,4,-149>,
			<84,4,-131>, <84,4,-129>, <84,4,-111>, <84,4,-109>,
			<84,4,-91>, <84,4,-89>, <84,4,-71>, <84,4,-69>,
			<84,4,-51>, <84,4,-49>, <84,4,-31>, <84,4,-29>,
			<84,4,-11>, <84,4,-9>, <84,4,9>, <84,4,11>,
			<84,4,29>, <84,4,31>, <84,4,49>, <84,4,51>,
			<84,4,69>, <84,4,71>, <84,4,89>, <84,4,91>,
			<84,4,109>, <84,4,111>, <84,4,129>, <84,4,131>,
			<84,4,149>, <84,4,151>, <84,8,-151>, <84,8,-149>,
			<84,8,-131>, <84,8,-129>, <84,8,-111>, <84,8,-109>,
			<84,8,-91>, <84,8,-89>, <84,8,-71>, <84,8,-69>,
			<84,8,-51>, <84,8,-49>, <84,8,-31>, <84,8,-29>,
			<84,8,-11>, <84,8,-9>, <84,8,9>, <84,8,11>,
			<84,8,29>, <84,8,31>, <84,8,49>, <84,8,51>,
			<84,8,69>, <84,8,71>, <84,8,89>, <84,8,91>,
			<84,8,109>, <84,8,111>, <84,8,129>, <84,8,131>,
			<84,8,149>, <84,8,151>, <85.656998,4,-125.657005>, <85.657005,4,-114.343002>,
			<85.657005,4,-85.656998>, <85.657005,4,-74.343002>, <85.657005,4,-45.657001>, <85.657005,4,-34.342999>,
			<85.657005,4,-5.657>, <85.657005,4,5.657>, <85.657005,4,34.342999>, <85.657005,4,45.657001>,
			<85.657005,4,74.343002>, <85.657005,4,85.656998>, <85.657005,4,114.343002>, <85.656998,4,125.657005>,
			<85.656998,8,-125.657005>, <85.657005,8,-114.343002>, <85.657005,8,-85.656998>, <85.657005,8,-74.343002>,
			<85.657005,8,-45.657001>, <85.657005,8,-34.342999>, <85.657005,8,-5.657>, <85.657005,8,5.657>,
			<85.657005,8,34.342999>, <85.657005,8,45.657001>, <85.657005,8,74.343002>, <85.657005,8,85.656998>,
			<85.657005,8,114.343002>, <85.656998,8,125.657005>, <87.391006,4,-123.061005>, <87.391006,4,-116.938995>,
			<87.391006,4,-83.061005>, <87.391006,4,-76.938995>, <87.391006,4,-43.060997>, <87.391006,4,-36.939003>,
			<87.391006,4,-3.061>, <87.391006,4,3.061>, <87.391006,4,36.939003>, <87.391006,4,43.060997>,
			<87.391006,4,76.938995>, <87.391006,4,83.061005>, <87.391006,4,116.938995>, <87.391006,4,123.061005>,
			<87.391006,8,-123.061005>, <87.391006,8,-116.938995>, <87.391006,8,-83.061005>, <87.391006,8,-76.938995>,
			<87.391006,8,-43.060997>, <87.391006,8,-36.939003>, <87.391006,8,-3.061>, <87.391006,8,3.061>,
			<87.391006,8,36.939003>, <87.391006,8,43.060997>, <87.391006,8,76.938995>, <87.391006,8,83.061005>,
			<87.391006,8,116.938995>, <87.391006,8,123.061005>, <87.801003,4,-121>, <87.801003,4,-119>,
			<87.801003,4,-81>, <87.801003,4,-79>, <87.801003,4,-41>, <87.801003,4,-39>,
			<87.801003,4,-1>, <87.801003,4,1>, <87.801003,4,39>, <87.801003,4,41>,
			<87.801003,4,79>, <87.801003,4,81>, <87.801003,4,119>, <87.801003,4,121>,
			<87.801003,8,-121>, <87.801003,8,-119>, <87.801003,8,-81>, <87.801003,8,-79>,
			<87.801003,8,-41>, <87.801003,8,-39>, <87.801003,8,-1>, <87.801003,8,-1>,
			<87.801003,8,1>, <87.801003,8,1>, <87.801003,8,39>, <87.801003,8,41>,
			<87.801003,8,79>, <87.801003,8,81>, <87.801003,8,119>, <87.801003,8,121>,
			<88,8,-120>, <88,8,-80>, <88,8,-40>, <88,8,0>,
			<88,8,40>, <88,8,80>, <88,8,120>, <89,4,-124>,
			<89,4,-121>, <89,4,-119>, <89,4,-116>, <89,4,-84>,
			<89,4,-81>, <89,4,-79>, <89,4,-76>, <89,4,-44>,
			<89,4,-41>, <89,4,-39>, <89,4,-36>, <89,4,-4>,
			<89,4,-1>, <89,4,-1>, <89,4,1>, <89,4,1>,
			<89,4,4>, <89,4,36>, <89,4,39>, <89,4,41>,
			<89,4,44>, <89,4,76>, <89,4,79>, <89,4,81>,
			<89,4,84>, <89,4,116>, <89,4,119>, <89,4,121>,
			<89,4,124>, <89,8,-124>, <89,8,-121>, <89,8,-119>,
			<89,8,-116>, <89,8,-84>, <89,8,-81>, <89,8,-79>,
			<89,8,-76>, <89,8,-44>, <89,8,-41>, <89,8,-39>,
			<89,8,-36>, <89,8,-4>, <89,8,-1>, <89,8,-1>,
			<89,8,1>, <89,8,1>, <89,8,4>, <89,8,36>,
			<89,8,39>, <89,8,41>, <89,8,44>, <89,8,76>,
			<89,8,79>, <89,8,81>, <89,8,84>, <89,8,116>,
			<89,8,119>, <89,8,121>, <89,8,124>, <91,4,-124>,
			<91,4,-121>, <91,4,-119>, <91,4,-116>, <91,4,-84>,
			<91,4,-81>, <91,4,-79>, <91,4,-76>, <91,4,-44>,
			<91,4,-41>, <91,4,-39>, <91,4,-36>, <91,4,-4>,
			<91,4,-1>, <91,4,1>, <91,4,4>, <91,4,36>,
			<91,4,39>, <91,4,41>, <91,4,44>, <91,4,76>,
			<91,4,79>, <91,4,81>, <91,4,84>, <91,4,116>,
			<91,4,119>, <91,4,121>, <91,4,124>, <91,8,-124>,
			<91,8,-121>, <91,8,-119>, <91,8,-116>, <91,8,-84>,
			<91,8,-81>, <91,8,-79>, <91,8,-76>, <91,8,-44>,
			<91,8,-41>, <91,8,-39>, <91,8,-36>, <91,8,-4>,
			<91,8,-1>, <91,8,1>, <91,8,4>, <91,8,36>,
			<91,8,39>, <91,8,41>, <91,8,44>, <91,8,76>,
			<91,8,79>, <91,8,81>, <91,8,84>, <91,8,116>,
			<91,8,119>, <91,8,121>, <91,8,124>, <109,4,-124>,
			<109,4,-121>, <109,4,-119>, <109,4,-116>, <109,4,-84>,
			<109,4,-81>, <109,4,-79>, <109,4,-76>, <109,4,-44>,
			<109,4,-41>, <109,4,-39>, <109,4,-36>, <109,4,-4>,
			<109,4,-1>, <109,4,1>, <109,4,4>, <109,4,36>,
			<109,4,39>, <109,4,41>, <109,4,44>, <109,4,76>,
			<109,4,79>, <109,4,81>, <109,4,84>, <109,4,116>,
			<109,4,119>, <109,4,121>, <109,4,124>, <109,8,-124>,
			<109,8,-121>, <109,8,-119>, <109,8,-116>, <109,8,-84>,
			<109,8,-81>, <109,8,-79>, <109,8,-76>, <109,8,-44>,
			<109,8,-41>, <109,8,-39>, <109,8,-36>, <109,8,-4>,
			<109,8,-1>, <109,8,1>, <109,8,4>, <109,8,36>,
			<109,8,39>, <109,8,41>, <109,8,44>, <109,8,76>,
			<109,8,79>, <109,8,81>, <109,8,84>, <109,8,116>,
			<109,8,119>, <109,8,121>, <109,8,124>, <111,4,-124>,
			<111,4,-121>, <111,4,-119>, <111,4,-116>, <111,4,-84>,
			<111,4,-81>, <111,4,-79>, <111,4,-76>, <111,4,-44>,
			<111,4,-41>, <111,4,-39>, <111,4,-36>, <111,4,-4>,
			<111,4,-1>, <111,4,-1>, <111,4,1>, <111,4,1>,
			<111,4,4>, <111,4,36>, <111,4,39>, <111,4,41>,
			<111,4,44>, <111,4,76>, <111,4,79>, <111,4,81>,
			<111,4,84>, <111,4,116>, <111,4,119>, <111,4,121>,
			<111,4,124>, <111,8,-124>, <111,8,-121>, <111,8,-119>,
			<111,8,-116>, <111,8,-84>, <111,8,-81>, <111,8,-79>,
			<111,8,-76>, <111,8,-44>, <111,8,-41>, <111,8,-39>,
			<111,8,-36>, <111,8,-4>, <111,8,-1>, <111,8,-1>,
			<111,8,1>, <111,8,1>, <111,8,4>, <111,8,36>,
			<111,8,39>, <111,8,41>, <111,8,44>, <111,8,76>,
			<111,8,79>, <111,8,81>, <111,8,84>, <111,8,116>,
			<111,8,119>, <111,8,121>, <111,8,124>, <112,8,-120>,
			<112,8,-80>, <112,8,-40>, <112,8,0>, <112,8,40>,
			<112,8,80>, <112,8,120>, <112.198997,4,-121>, <112.198997,4,-119>,
			<112.198997,4,-81>, <112.198997,4,-79>, <112.198997,4,-41>, <112.198997,4,-39>,
			<112.198997,4,-1>, <112.198997,4,1>, <112.198997,4,39>, <112.198997,4,41>,
			<112.198997,4,79>, <112.198997,4,81>, <112.198997,4,119>, <112.198997,4,121>,
			<112.198997,8,-121>, <112.198997,8,-119>, <112.198997,8,-81>, <112.198997,8,-79>,
			<112.198997,8,-41>, <112.198997,8,-39>, <112.198997,8,-1>, <112.198997,8,-1>,
			<112.198997,8,1>, <112.198997,8,1>, <112.198997,8,39>, <112.198997,8,41>,
			<112.198997,8,79>, <112.198997,8,81>, <112.198997,8,119>, <112.198997,8,121>,
			<112.608994,4,-123.061005>, <112.608994,4,-116.938995>, <112.608994,4,-83.061005>, <112.608994,4,-76.938995>,
			<112.608994,4,-43.060997>, <112.608994,4,-36.939003>, <112.608994,4,-3.061>, <112.608994,4,3.061>,
			<112.608994,4,36.939003>, <112.608994,4,43.060997>, <112.608994,4,76.938995>, <112.608994,4,83.061005>,
			<112.608994,4,116.938995>, <112.608994,4,123.061005>, <112.608994,8,-123.061005>, <112.608994,8,-116.938995>,
			<112.608994,8,-83.061005>, <112.608994,8,-76.938995>, <112.608994,8,-43.060997>, <112.608994,8,-36.939003>,
			<112.608994,8,-3.061>, <112.608994,8,3.061>, <112.608994,8,36.939003>, <112.608994,8,43.060997>,
			<112.608994,8,76.938995>, <112.608994,8,83.061005>, <112.608994,8,116.938995>, <112.608994,8,123.061005>,
			<114.343002,4,-125.657005>, <114.342995,4,-114.343002>, <114.342995,4,-85.656998>, <114.342995,4,-74.343002>,
			<114.342995,4,-45.657001>, <114.342995,4,-34.342999>, <114.342995,4,-5.657>, <114.342995,4,5.657>,
			<114.342995,4,34.342999>, <114.342995,4,45.657001>, <114.342995,4,74.343002>, <114.342995,4,85.656998>,
			<114.342995,4,114.343002>, <114.343002,4,125.657005>, <114.343002,8,-125.657005>, <114.342995,8,-114.343002>,
			<114.342995,8,-85.656998>, <114.342995,8,-74.343002>, <114.342995,8,-45.657001>, <114.342995,8,-34.342999>,
			<114.342995,8,-5.657>, <114.342995,8,5.657>, <114.342995,8,34.342999>, <114.342995,8,45.657001>,
			<114.342995,8,74.343002>, <114.342995,8,85.656998>, <114.342995,8,114.343002>, <114.343002,8,125.657005>,
			<116,4,-151>, <116,4,-149>, <116,4,-131>, <116,4,-129>,
			<116,4,-111>, <116,4,-109>, <116,4,-91>, <116,4,-89>,
			<116,4,-71>, <116,4,-69>, <116,4,-51>, <116,4,-49>,
			<116,4,-31>, <116,4,-29>, <116,4,-11>, <116,4,-9>,
			<116,4,9>, <116,4,11>, <116,4,29>, <116,4,31>,
			<116,4,49>, <116,4,51>, <116,4,69>, <116,4,71>,
			<116,4,89>, <116,4,91>, <116,4,109>, <116,4,111>,
			<116,4,129>, <116,4,131>, <116,4,149>, <116,4,151>,
			<116,8,-151>, <116,8,-149>, <116,8,-131>, <116,8,-129>,
			<116,8,-111>, <116,8,-109>, <116,8,-91>, <116,8,-89>,
			<116,8,-71>, <116,8,-69>, <116,8,-51>, <116,8,-49>,
			<116,8,-31>, <116,8,-29>, <116,8,-11>, <116,8,-9>,
			<116,8,9>, <116,8,11>, <116,8,29>, <116,8,31>,
			<116,8,49>, <116,8,51>, <116,8,69>, <116,8,71>,
			<116,8,89>, <116,8,91>, <116,8,109>, <116,8,111>,
			<116,8,129>, <116,8,131>, <116,8,149>, <116,8,151>,
			<116.938995,4,-127.390999>, <116.938995,4,-112.608994>, <116.938995,4,-87.391006>, <116.938995,4,-72.608994>,
			<116.938995,4,-47.390999>, <116.938995,4,-32.609001>, <116.938995,4,-7.391>, <116.938995,4,7.391>,
			<116.938995,4,32.609001>, <116.938995,4,47.390999>, <116.938995,4,72.608994>, <116.938995,4,87.391006>,
			<116.938995,4,112.608994>, <116.938995,4,127.390999>, <116.938995,8,-127.390999>, <116.938995,8,-112.608994>,
			<116.938995,8,-87.391006>, <116.938995,8,-72.608994>, <116.938995,8,-47.390999>, <116.938995,8,-32.609001>,
			<116.938995,8,-7.391>, <116.938995,8,7.391>, <116.938995,8,32.609001>, <116.938995,8,47.390999>,
			<116.938995,8,72.608994>, <116.938995,8,87.391006>, <116.938995,8,112.608994>, <116.938995,8,127.390999>,
			<119,4,-156>, <119,4,-151>, <119,4,-149>, <119,4,-131>,
			<119,4,-129>, <119,4,-127.800995>, <119,4,-112.198997>, <119,4,-111>,
			<119,4,-109>, <119,4,-91>, <119,4,-89>, <119,4,-87.801003>,
			<119,4,-72.198997>, <119,4,-71>, <119,4,-69>, <119,4,-51>,
			<119,4,-49>, <119,4,-47.800999>, <119,4,-32.199001>, <119,4,-31>,
			<119,4,-29>, <119,4,-11>, <119,4,-9>, <119,4,-7.801001>,
			<119,4,7.801001>, <119,4,9>, <119,4,11>, <119,4,29>,
			<119,4,31>, <119,4,32.199001>, <119,4,47.800999>, <119,4,49>,
			<119,4,51>, <119,4,69>, <119,4,71>, <119,4,72.198997>,
			<119,4,87.801003>, <119,4,89>, <119,4,91>, <119,4,109>,
			<119,4,111>, <119,4,112.198997>, <119,4,127.800995>, <119,4,129>,
			<119,4,131>, <119,4,149>, <119,4,151>, <119,4,156>,
			<119,8,-156>, <119,8,-151>, <119,8,-149>, <119,8,-131>,
			<119,8,-129>, <119,8,-127.801003>, <119,8,-112.198997>, <119,8,-111>,
			<119,8,-109>, <119,8,-91>, <119,8,-89>, <119,8,-87.801003>,
			<119,8,-72.198997>, <119,8,-71>, <119,8,-69>, <119,8,-51>,
			<119,8,-49>, <119,8,-47.800999>, <119,8,-32.199001>, <119,8,-31>,
			<119,8,-29>, <119,8,-11>, <119,8,-9>, <119,8,-7.801>,
			<119,8,7.801>, <119,8,9>, <119,8,11>, <119,8,29>,
			<119,8,31>, <119,8,32.199001>, <119,8,47.800999>, <119,8,49>,
			<119,8,51>, <119,8,69>, <119,8,71>, <119,8,72.198997>,
			<119,8,87.801003>, <119,8,89>, <119,8,91>, <119,8,109>,
			<119,8,111>, <119,8,112.198997>, <119,8,127.801003>, <119,8,129>,
			<119,8,131>, <119,8,149>, <119,8,151>, <119,8,156>,
			<120,8,-156>, <120,8,-128>, <120,8,-112>, <120,8,-88>,
			<120,8,-72>, <120,8,-48>, <120,8,-32>, <120,8,-8>,
			<120,8,8>, <120,8,32>, <120,8,48>, <120,8,72>,
			<120,8,88>, <120,8,112>, <120,8,128>, <120,8,156>,
			<121,4,-156>, <121,4,-151>, <121,4,-149>, <121,4,-131>,
			<121,4,-129>, <121,4,-127.800995>, <121,4,-112.198997>, <121,4,-111>,
			<121,4,-109>, <121,4,-91>, <121,4,-89>, <121,4,-87.801003>,
			<121,4,-72.198997>, <121,4,-71>, <121,4,-69>, <121,4,-51>,
			<121,4,-49>, <121,4,-47.800999>, <121,4,-32.199001>, <121,4,-31>,
			<121,4,-29>, <121,4,-11>, <121,4,-9>, <121,4,-7.801001>,
			<121,4,7.801001>, <121,4,9>, <121,4,11>, <121,4,29>,
			<121,4,31>, <121,4,32.199001>, <121,4,47.800999>, <121,4,49>,
			<121,4,51>, <121,4,69>, <121,4,71>, <121,4,72.198997>,
			<121,4,87.801003>, <121,4,89>, <121,4,91>, <121,4,109>,
			<121,4,111>, <121,4,112.198997>, <121,4,127.800995>, <121,4,129>,
			<121,4,131>, <121,4,149>, <121,4,151>, <121,4,156>,
			<121,8,-156>, <121,8,-151>, <121,8,-149>, <121,8,-131>,
			<121,8,-129>, <121,8,-127.801003>, <121,8,-112.198997>, <121,8,-111>,
			<121,8,-109>, <121,8,-91>, <121,8,-89>, <121,8,-87.801003>,
			<121,8,-72.198997>, <121,8,-71>, <121,8,-69>, <121,8,-51>,
			<121,8,-49>, <121,8,-47.800999>, <121,8,-32.199001>, <121,8,-31>,
			<121,8,-29>, <121,8,-11>, <121,8,-9>, <121,8,-7.801>,
			<121,8,7.801>, <121,8,9>, <121,8,11>, <121,8,29>,
			<121,8,31>, <121,8,32.199001>, <121,8,47.800999>, <121,8,49>,
			<121,8,51>, <121,8,69>, <121,8,71>, <121,8,72.198997>,
			<121,8,87.801003>, <121,8,89>, <121,8,91>, <121,8,109>,
			<121,8,111>, <121,8,112.198997>, <121,8,127.801003>, <121,8,129>,
			<121,8,131>, <121,8,149>, <121,8,151>, <121,8,156>,
			<123.061005,4,-127.390999>, <123.061005,4,-112.608994>, <123.061005,4,-87.391006>, <123.061005,4,-72.608994>,
			<123.061005,4,-47.390999>, <123.061005,4,-32.609001>, <123.061005,4,-7.391>, <123.061005,4,7.391>,
			<123.061005,4,32.609001>, <123.061005,4,47.390999>, <123.061005,4,72.608994>, <123.061005,4,87.391006>,
			<123.061005,4,112.608994>, <123.061005,4,127.390999>, <123.061005,8,-127.390999>, <123.061005,8,-112.608994>,
			<123.061005,8,-87.391006>, <123.061005,8,-72.608994>, <123.061005,8,-47.390999>, <123.061005,8,-32.609001>,
			<123.061005,8,-7.391>, <123.061005,8,7.391>, <123.061005,8,32.609001>, <123.061005,8,47.390999>,
			<123.061005,8,72.608994>, <123.061005,8,87.391006>, <123.061005,8,112.608994>, <123.061005,8,127.390999>,
			<124,4,-151>, <124,4,-149>, <124,4,-131>, <124,4,-129>,
			<124,4,-111>, <124,4,-109>, <124,4,-91>, <124,4,-89>,
			<124,4,-71>, <124,4,-69>, <124,4,-51>, <124,4,-49>,
			<124,4,-31>, <124,4,-29>, <124,4,-11>, <124,4,-9>,
			<124,4,9>, <124,4,11>, <124,4,29>, <124,4,31>,
			<124,4,49>, <124,4,51>, <124,4,69>, <124,4,71>,
			<124,4,89>, <124,4,91>, <124,4,109>, <124,4,111>,
			<124,4,129>, <124,4,131>, <124,4,149>, <124,4,151>,
			<124,8,-151>, <124,8,-149>, <124,8,-131>, <124,8,-129>,
			<124,8,-111>, <124,8,-109>, <124,8,-91>, <124,8,-89>,
			<124,8,-71>, <124,8,-69>, <124,8,-51>, <124,8,-49>,
			<124,8,-31>, <124,8,-29>, <124,8,-11>, <124,8,-9>,
			<124,8,9>, <124,8,11>, <124,8,29>, <124,8,31>,
			<124,8,49>, <124,8,51>, <124,8,69>, <124,8,71>,
			<124,8,89>, <124,8,91>, <124,8,109>, <124,8,111>,
			<124,8,129>, <124,8,131>, <124,8,149>, <124,8,151>,
			<125.657005,4,-125.656998>, <125.657005,4,-114.343002>, <125.657005,4,-85.656998>, <125.657005,4,-74.343002>,
			<125.657005,4,-45.657001>, <125.657005,4,-34.342999>, <125.657005,4,-5.657>, <125.657005,4,5.657>,
			<125.657005,4,34.342999>, <125.657005,4,45.657001>, <125.657005,4,74.343002>, <125.657005,4,85.656998>,
			<125.657005,4,114.343002>, <125.656998,4,125.657005>, <125.657005,8,-125.656998>, <125.657005,8,-114.343002>,
			<125.657005,8,-85.656998>, <125.657005,8,-74.343002>, <125.657005,8,-45.657001>, <125.657005,8,-34.342999>,
			<125.657005,8,-5.657>, <125.657005,8,5.657>, <125.657005,8,34.342999>, <125.657005,8,45.657001>,
			<125.657005,8,74.343002>, <125.657005,8,85.656998>, <125.657005,8,114.343002>, <125.656998,8,125.657005>,
			<127.390999,4,-123.061005>, <127.390999,4,-116.938995>, <127.390999,4,-83.061005>, <127.390999,4,-76.938995>,
			<127.390999,4,-43.060997>, <127.390999,4,-36.939003>, <127.390999,4,-3.061>, <127.390999,4,3.061>,
			<127.390999,4,36.939003>, <127.390999,4,43.060997>, <127.390999,4,76.938995>, <127.390999,4,83.061005>,
			<127.390999,4,116.938995>, <127.390999,4,123.061005>, <127.390999,8,-123.061005>, <127.390999,8,-116.938995>,
			<127.390999,8,-83.061005>, <127.390999,8,-76.938995>, <127.390999,8,-43.060997>, <127.390999,8,-36.939003>,
			<127.390999,8,-3.061>, <127.390999,8,3.061>, <127.390999,8,36.939003>, <127.390999,8,43.060997>,
			<127.390999,8,76.938995>, <127.390999,8,83.061005>, <127.390999,8,116.938995>, <127.390999,8,123.061005>,
			<127.800995,4,-121>, <127.800995,4,-119>, <127.800995,4,-81>, <127.800995,4,-79>,
			<127.800995,4,-41>, <127.800995,4,-39>, <127.800995,4,-1>, <127.800995,4,1>,
			<127.800995,4,39>, <127.800995,4,41>, <127.800995,4,79>, <127.800995,4,81>,
			<127.800995,4,119>, <127.800995,4,121>, <127.801003,8,-121>, <127.801003,8,-119>,
			<127.801003,8,-81>, <127.801003,8,-79>, <127.801003,8,-41>, <127.801003,8,-39>,
			<127.801003,8,-1>, <127.800995,8,-1>, <127.801003,8,1>, <127.800995,8,1>,
			<127.801003,8,39>, <127.801003,8,41>, <127.801003,8,79>, <127.801003,8,81>,
			<127.801003,8,119>, <127.801003,8,121>, <128,8,-120>, <128,8,-80>,
			<128,8,-40>, <128,8,0>, <128,8,40>, <128,8,80>,
			<128,8,120>, <129,4,-124>, <129,4,-121>, <129,4,-119>,
			<129,4,-116>, <129,4,-84>, <129,4,-81>, <129,4,-79>,
			<129,4,-76>, <129,4,-44>, <129,4,-41>, <129,4,-39>,
			<129,4,-36>, <129,4,-4>, <129,4,-1>, <129,4,-1>,
			<129,4,1>, <129,4,1>, <129,4,4>, <129,4,36>,
			<129,4,39>, <129,4,41>, <129,4,44>, <129,4,76>,
			<129,4,79>, <129,4,81>, <129,4,84>, <129,4,116>,
			<129,4,119>, <129,4,121>, <129,4,124>, <129,8,-124>,
			<129,8,-121>, <129,8,-119>, <129,8,-116>, <129,8,-84>,
			<129,8,-81>, <129,8,-79>, <129,8,-76>, <129,8,-44>,
			<129,8,-41>, <129,8,-39>, <129,8,-36>, <129,8,-4>,
			<129,8,-1>, <129,8,-1>, <129,8,1>, <129,8,1>,
			<129,8,4>, <129,8,36>, <129,8,39>, <129,8,41>,
			<129,8,44>, <129,8,76>, <129,8,79>, <129,8,81>,
			<129,8,84>, <129,8,116>, <129,8,119>, <129,8,121>,
			<129,8,124>, <131,4,-124>, <131,4,-121>, <131,4,-119>,
			<131,4,-116>, <131,4,-84>, <131,4,-81>, <131,4,-79>,
			<131,4,-76>, <131,4,-44>, <131,4,-41>, <131,4,-39>,
			<131,4,-36>, <131,4,-4>, <131,4,-1>, <131,4,1>,
			<131,4,4>, <131,4,36>, <131,4,39>, <131,4,41>,
			<131,4,44>, <131,4,76>, <131,4,79>, <131,4,81>,
			<131,4,84>, <131,4,116>, <131,4,119>, <131,4,121>,
			<131,4,124>, <131,8,-124>, <131,8,-121>, <131,8,-119>,
			<131,8,-116>, <131,8,-84>, <131,8,-81>, <131,8,-79>,
			<131,8,-76>, <131,8,-44>, <131,8,-41>, <131,8,-39>,
			<131,8,-36>, <131,8,-4>, <131,8,-1>, <131,8,1>,
			<131,8,4>, <131,8,36>, <131,8,39>, <131,8,41>,
			<131,8,44>, <131,8,76>, <131,8,79>, <131,8,81>,
			<131,8,84>, <131,8,116>, <131,8,119>, <131,8,121>,
			<131,8,124>, <149,4,-124>, <149,4,-121>, <149,4,-119>,
			<149,4,-116>, <149,4,-84>, <149,4,-81>, <149,4,-79>,
			<149,4,-76>, <149,4,-44>, <149,4,-41>, <149,4,-39>,
			<149,4,-36>, <149,4,-4>, <149,4,-1>, <149,4,1>,
			<149,4,4>, <149,4,36>, <149,4,39>, <149,4,41>,
			<149,4,44>, <149,4,76>, <149,4,79>, <149,4,81>,
			<149,4,84>, <149,4,116>, <149,4,119>, <149,4,121>,
			<149,4,124>, <149,8,-124>, <149,8,-121>, <149,8,-119>,
			<149,8,-116>, <149,8,-84>, <149,8,-81>, <149,8,-79>,
			<149,8,-76>, <149,8,-44>, <149,8,-41>, <149,8,-39>,
			<149,8,-36>, <149,8,-4>, <149,8,-1>, <149,8,1>,
			<149,8,4>, <149,8,36>, <149,8,39>, <149,8,41>,
			<149,8,44>, <149,8,76>, <149,8,79>, <149,8,81>,
			<149,8,84>, <149,8,116>, <149,8,119>, <149,8,121>,
			<149,8,124>, <151,4,-124>, <151,4,-121>, <151,4,-119>,
			<151,4,-116>, <151,4,-84>, <151,4,-81>, <151,4,-79>,
			<151,4,-76>, <151,4,-44>, <151,4,-41>, <151,4,-39>,
			<151,4,-36>, <151,4,-4>, <151,4,-1>, <151,4,1>,
			<151,4,4>, <151,4,36>, <151,4,39>, <151,4,41>,
			<151,4,44>, <151,4,76>, <151,4,79>, <151,4,81>,
			<151,4,84>, <151,4,116>, <151,4,119>, <151,4,121>,
			<151,4,124>, <151,8,-124>, <151,8,-121>, <151,8,-119>,
			<151,8,-116>, <151,8,-84>, <151,8,-81>, <151,8,-79>,
			<151,8,-76>, <151,8,-44>, <151,8,-41>, <151,8,-39>,
			<151,8,-36>, <151,8,-4>, <151,8,-1>, <151,8,1>,
			<151,8,4>, <151,8,36>, <151,8,39>, <151,8,41>,
			<151,8,44>, <151,8,76>, <151,8,79>, <151,8,81>,
			<151,8,84>, <151,8,116>, <151,8,119>, <151,8,121>,
			<151,8,124>, <156,4,-156>, <156,4,-121>, <156,4,-119>,
			<156,4,-81>, <156,4,-79>, <156,4,-41>, <156,4,-39>,
			<156,4,-1>, <156,4,1>, <156,4,39>, <156,4,41>,
			<156,4,79>, <156,4,81>, <156,4,119>, <156,4,121>,
			<156,4,156>, <156,8,-156>, <156,8,-121>, <156,8,-120>,
			<156,8,-119>, <156,8,-81>, <156,8,-80>, <156,8,-79>,
			<156,8,-41>, <156,8,-40>, <156,8,-39>, <156,8,-1>,
			<156,8,0>, <156,8,1>, <156,8,39>, <156,8,40>,
			<156,8,41>, <156,8,79>, <156,8,80>, <156,8,81>,
			<156,8,119>, <156,8,120>, <156,8,121>, <156,8,156>,
			<160,0,-160>, <160,0,160>, <160,8,-160>, <160,8,160>
		}
		normal_vectors {
			27,
			<-1,0,0>, <-0.980782,0,-0.195107>, <-0.980782,0,0.195107>, <-0.923907,0,-0.382618>,
			<-0.923907,0,0.382618>, <-0.707107,0,-0.707107>, <-0.707107,0,0.707107>, <-0.382618,0,-0.923907>,
			<-0.382618,0,0.923907>, <-0.195107,0,-0.980782>, <-0.195107,0,0.980782>, <0,-1,0>,
			<0,0,-1>, <0,0,1>, <0,1,0>, <0,1,0>,
			<0.195107,0,-0.980782>, <0.195107,0,0.980782>, <0.382618,0,-0.923907>, <0.382618,0,0.923907>,
			<0.707107,0,-0.707107>, <0.707107,0,0.707107>, <0.923907,0,-0.382618>, <0.923907,0,0.382618>,
			<0.980782,0,-0.195107>, <0.980782,0,0.195107>, <1,0,0>
		}
		face_indices {
			7028,
			<1, 6061, 6060>, <1, 6060, 0>, <1, 3, 6063>, <1, 6063, 6061>,
			<0, 2, 3>, <0, 3, 1>, <6060, 6062, 2>, <6060, 2, 0>,
			<6061, 6063, 6062>, <6061, 6062, 6060>, <42, 3, 6063>, <42, 6063, 6059>,
			<6059, 6063, 6062>, <6059, 6062, 6037>, <6037, 6062, 2>, <6037, 2, 20>,
			<20, 2, 3>, <20, 3, 42>, <6036, 6021, 4>, <6036, 4, 19>,
			<42, 41, 18>, <42, 18, 19>, <42, 19, 503>, <42, 503, 551>,
			<17, 16, 38>, <17, 38, 39>, <15, 14, 35>, <15, 35, 36>,
			<13, 12, 32>, <13, 32, 33>, <11, 10, 29>, <11, 29, 30>,
			<9, 8, 26>, <9, 26, 27>, <7, 6, 23>, <7, 23, 24>,
			<20, 504, 456>, <20, 456, 4>, <20, 4, 5>, <20, 5, 21>,
			<568, 1266, 1314>, <568, 1314, 616>, <1378, 2076, 2124>, <1378, 2124, 1426>,
			<2188, 2886, 2920>, <2188, 2920, 2236>, <3040, 3780, 3828>, <3040, 3828, 3074>,
			<3892, 4590, 4638>, <3892, 4638, 3940>, <4702, 5400, 5448>, <4702, 5448, 4750>,
			<6037, 6038, 6022>, <6037, 6022, 6021>, <6037, 6021, 5512>, <6037, 5512, 5560>,
			<6023, 6024, 6041>, <6023, 6041, 6040>, <6025, 6026, 6044>, <6025, 6044, 6043>,
			<6027, 6028, 6047>, <6027, 6047, 6046>, <6029, 6030, 6050>, <6029, 6050, 6049>,
			<6031, 6032, 6053>, <6031, 6053, 6052>, <6033, 6034, 6056>, <6033, 6056, 6055>,
			<6059, 5607, 5559>, <6059, 5559, 6036>, <6059, 6036, 6035>, <6059, 6035, 6058>,
			<5447, 4749, 4797>, <5447, 4797, 5495>, <4637, 3939, 3987>, <4637, 3987, 4685>,
			<3827, 3073, 3121>, <3827, 3121, 3875>, <2919, 2235, 2283>, <2919, 2283, 2967>,
			<2123, 1425, 1473>, <2123, 1473, 2171>, <1313, 615, 663>, <1313, 663, 1361>,
			<660, 659, 752>, <660, 752, 753>, <752, 720, 721>, <752, 721, 753>,
			<659, 611, 720>, <659, 720, 752>, <753, 721, 612>, <753, 612, 660>,
			<662, 661, 754>, <662, 754, 755>, <754, 722, 723>, <754, 723, 755>,
			<661, 613, 722>, <661, 722, 754>, <755, 723, 614>, <755, 614, 662>,
			<549, 550, 427>, <549, 427, 426>, <427, 395, 394>, <427, 394, 426>,
			<550, 502, 395>, <550, 395, 427>, <426, 394, 501>, <426, 501, 549>,
			<547, 548, 425>, <547, 425, 424>, <425, 393, 392>, <425, 392, 424>,
			<548, 500, 393>, <548, 393, 425>, <424, 392, 499>, <424, 499, 547>,
			<551, 546, 566>, <551, 566, 567>, <658, 663, 567>, <658, 567, 566>,
			<500, 548, 549>, <500, 549, 501>, <612, 660, 661>, <612, 661, 613>,
			<498, 499, 547>, <498, 547, 546>, <498, 546, 455>, <498, 455, 441>,
			<610, 611, 659>, <610, 659, 658>, <610, 658, 691>, <610, 691, 677>,
			<677, 691, 783>, <677, 783, 769>, <441, 455, 363>, <441, 363, 349>,
			<502, 550, 551>, <502, 551, 503>, <614, 662, 663>, <614, 663, 615>,
			<1470, 1469, 1562>, <1470, 1562, 1563>, <1562, 1530, 1531>, <1562, 1531, 1563>,
			<1469, 1421, 1530>, <1469, 1530, 1562>, <1563, 1531, 1422>, <1563, 1422, 1470>,
			<1472, 1471, 1564>, <1472, 1564, 1565>, <1564, 1532, 1533>, <1564, 1533, 1565>,
			<1471, 1423, 1532>, <1471, 1532, 1564>, <1565, 1533, 1424>, <1565, 1424, 1472>,
			<1359, 1360, 1237>, <1359, 1237, 1236>, <1237, 1205, 1204>, <1237, 1204, 1236>,
			<1360, 1312, 1205>, <1360, 1205, 1237>, <1236, 1204, 1311>, <1236, 1311, 1359>,
			<1357, 1358, 1235>, <1357, 1235, 1234>, <1235, 1203, 1202>, <1235, 1202, 1234>,
			<1358, 1310, 1203>, <1358, 1203, 1235>, <1234, 1202, 1309>, <1234, 1309, 1357>,
			<1361, 1356, 1376>, <1361, 1376, 1377>, <1468, 1473, 1377>, <1468, 1377, 1376>,
			<1310, 1358, 1359>, <1310, 1359, 1311>, <1422, 1470, 1471>, <1422, 1471, 1423>,
			<1308, 1309, 1357>, <1308, 1357, 1356>, <1308, 1356, 1265>, <1308, 1265, 1251>,
			<1420, 1421, 1469>, <1420, 1469, 1468>, <1420, 1468, 1501>, <1420, 1501, 1487>,
			<1487, 1501, 1593>, <1487, 1593, 1579>, <1251, 1265, 1173>, <1251, 1173, 1159>,
			<1312, 1360, 1361>, <1312, 1361, 1313>, <1424, 1472, 1473>, <1424, 1473, 1425>,
			<2280, 2279, 2372>, <2280, 2372, 2373>, <2372, 2340, 2341>, <2372, 2341, 2373>,
			<2279, 2231, 2340>, <2279, 2340, 2372>, <2373, 2341, 2232>, <2373, 2232, 2280>,
			<2282, 2281, 2374>, <2282, 2374, 2375>, <2374, 2342, 2343>, <2374, 2343, 2375>,
			<2281, 2233, 2342>, <2281, 2342, 2374>, <2375, 2343, 2234>, <2375, 2234, 2282>,
			<2169, 2170, 2047>, <2169, 2047, 2046>, <2047, 2015, 2014>, <2047, 2014, 2046>,
			<2170, 2122, 2015>, <2170, 2015, 2047>, <2046, 2014, 2121>, <2046, 2121, 2169>,
			<2167, 2168, 2045>, <2167, 2045, 2044>, <2045, 2013, 2012>, <2045, 2012, 2044>,
			<2168, 2120, 2013>, <2168, 2013, 2045>, <2044, 2012, 2119>, <2044, 2119, 2167>,
			<2171, 2166, 2186>, <2171, 2186, 2187>, <2278, 2283, 2187>, <2278, 2187, 2186>,
			<2120, 2168, 2169>, <2120, 2169, 2121>, <2232, 2280, 2281>, <2232, 2281, 2233>,
			<2118, 2119, 2167>, <2118, 2167, 2166>, <2118, 2166, 2075>, <2118, 2075, 2061>,
			<2230, 2231, 2279>, <2230, 2279, 2278>, <2230, 2278, 2311>, <2230, 2311, 2297>,
			<2297, 2311, 2403>, <2297, 2403, 2389>, <2061, 2075, 1983>, <2061, 1983, 1969>,
			<2122, 2170, 2171>, <2122, 2171, 2123>, <2234, 2282, 2283>, <2234, 2283, 2235>,
			<3118, 3117, 3266>, <3118, 3266, 3267>, <3266, 3234, 3235>, <3266, 3235, 3267>,
			<3117, 3069, 3234>, <3117, 3234, 3266>, <3267, 3235, 3070>, <3267, 3070, 3118>,
			<3120, 3119, 3268>, <3120, 3268, 3269>, <3268, 3236, 3237>, <3268, 3237, 3269>,
			<3119, 3071, 3236>, <3119, 3236, 3268>, <3269, 3237, 3072>, <3269, 3072, 3120>,
			<2965, 2966, 2857>, <2965, 2857, 2856>, <2857, 2825, 2824>, <2857, 2824, 2856>,
			<2966, 2918, 2825>, <2966, 2825, 2857>, <2856, 2824, 2917>, <2856, 2917, 2965>,
			<2963, 2964, 2855>, <2963, 2855, 2854>, <2855, 2823, 2822>, <2855, 2822, 2854>,
			<2964, 2916, 2823>, <2964, 2823, 2855>, <2854, 2822, 2915>, <2854, 2915, 2963>,
			<2967, 2962, 3038>, <2967, 3038, 3039>, <3116, 3121, 3039>, <3116, 3039, 3038>,
			<2916, 2964, 2965>, <2916, 2965, 2917>, <3070, 3118, 3119>, <3070, 3119, 3071>,
			<2994, 2995, 3023>, <2994, 3023, 3022>, <2994, 3022, 2885>, <2994, 2885, 2871>,
			<3148, 3149, 3177>, <3148, 3177, 3176>, <3148, 3176, 3205>, <3148, 3205, 3191>,
			<3191, 3205, 3297>, <3191, 3297, 3283>, <2871, 2885, 2793>, <2871, 2793, 2779>,
			<2918, 2966, 2967>, <2918, 2967, 2919>, <3072, 3120, 3121>, <3072, 3121, 3073>,
			<3984, 3983, 4076>, <3984, 4076, 4077>, <4076, 4044, 4045>, <4076, 4045, 4077>,
			<3983, 3935, 4044>, <3983, 4044, 4076>, <4077, 4045, 3936>, <4077, 3936, 3984>,
			<3986, 3985, 4078>, <3986, 4078, 4079>, <4078, 4046, 4047>, <4078, 4047, 4079>,
			<3985, 3937, 4046>, <3985, 4046, 4078>, <4079, 4047, 3938>, <4079, 3938, 3986>,
			<3873, 3874, 3751>, <3873, 3751, 3750>, <3751, 3719, 3718>, <3751, 3718, 3750>,
			<3874, 3826, 3719>, <3874, 3719, 3751>, <3750, 3718, 3825>, <3750, 3825, 3873>,
			<3871, 3872, 3749>, <3871, 3749, 3748>, <3749, 3717, 3716>, <3749, 3716, 3748>,
			<3872, 3824, 3717>, <3872, 3717, 3749>, <3748, 3716, 3823>, <3748, 3823, 3871>,
			<3875, 3870, 3890>, <3875, 3890, 3891>, <3982, 3987, 3891>, <3982, 3891, 3890>,
			<3824, 3872, 3873>, <3824, 3873, 3825>, <3936, 3984, 3985>, <3936, 3985, 3937>,
			<3822, 3823, 3871>, <3822, 3871, 3870>, <3822, 3870, 3779>, <3822, 3779, 3765>,
			<3934, 3935, 3983>, <3934, 3983, 3982>, <3934, 3982, 4015>, <3934, 4015, 4001>,
			<4001, 4015, 4107>, <4001, 4107, 4093>, <3765, 3779, 3687>, <3765, 3687, 3673>,
			<3826, 3874, 3875>, <3826, 3875, 3827>, <3938, 3986, 3987>, <3938, 3987, 3939>,
			<4794, 4793, 4886>, <4794, 4886, 4887>, <4886, 4854, 4855>, <4886, 4855, 4887>,
			<4793, 4745, 4854>, <4793, 4854, 4886>, <4887, 4855, 4746>, <4887, 4746, 4794>,
			<4796, 4795, 4888>, <4796, 4888, 4889>, <4888, 4856, 4857>, <4888, 4857, 4889>,
			<4795, 4747, 4856>, <4795, 4856, 4888>, <4889, 4857, 4748>, <4889, 4748, 4796>,
			<4683, 4684, 4561>, <4683, 4561, 4560>, <4561, 4529, 4528>, <4561, 4528, 4560>,
			<4684, 4636, 4529>, <4684, 4529, 4561>, <4560, 4528, 4635>, <4560, 4635, 4683>,
			<4681, 4682, 4559>, <4681, 4559, 4558>, <4559, 4527, 4526>, <4559, 4526, 4558>,
			<4682, 4634, 4527>, <4682, 4527, 4559>, <4558, 4526, 4633>, <4558, 4633, 4681>,
			<4685, 4680, 4700>, <4685, 4700, 4701>, <4792, 4797, 4701>, <4792, 4701, 4700>,
			<4634, 4682, 4683>, <4634, 4683, 4635>, <4746, 4794, 4795>, <4746, 4795, 4747>,
			<4632, 4633, 4681>, <4632, 4681, 4680>, <4632, 4680, 4589>, <4632, 4589, 4575>,
			<4744, 4745, 4793>, <4744, 4793, 4792>, <4744, 4792, 4825>, <4744, 4825, 4811>,
			<4811, 4825, 4917>, <4811, 4917, 4903>, <4575, 4589, 4497>, <4575, 4497, 4483>,
			<4636, 4684, 4685>, <4636, 4685, 4637>, <4748, 4796, 4797>, <4748, 4797, 4749>,
			<5604, 5603, 5696>, <5604, 5696, 5697>, <5696, 5664, 5665>, <5696, 5665, 5697>,
			<5603, 5555, 5664>, <5603, 5664, 5696>, <5697, 5665, 5556>, <5697, 5556, 5604>,
			<5606, 5605, 5698>, <5606, 5698, 5699>, <5698, 5666, 5667>, <5698, 5667, 5699>,
			<5605, 5557, 5666>, <5605, 5666, 5698>, <5699, 5667, 5558>, <5699, 5558, 5606>,
			<5493, 5494, 5371>, <5493, 5371, 5370>, <5371, 5339, 5338>, <5371, 5338, 5370>,
			<5494, 5446, 5339>, <5494, 5339, 5371>, <5370, 5338, 5445>, <5370, 5445, 5493>,
			<5491, 5492, 5369>, <5491, 5369, 5368>, <5369, 5337, 5336>, <5369, 5336, 5368>,
			<5492, 5444, 5337>, <5492, 5337, 5369>, <5368, 5336, 5443>, <5368, 5443, 5491>,
			<5495, 5490, 5510>, <5495, 5510, 5511>, <5602, 5607, 5511>, <5602, 5511, 5510>,
			<5444, 5492, 5493>, <5444, 5493, 5445>, <5556, 5604, 5605>, <5556, 5605, 5557>,
			<5442, 5443, 5491>, <5442, 5491, 5490>, <5442, 5490, 5399>, <5442, 5399, 5385>,
			<5554, 5555, 5603>, <5554, 5603, 5602>, <5554, 5602, 5635>, <5554, 5635, 5621>,
			<5621, 5635, 5727>, <5621, 5727, 5713>, <5385, 5399, 5307>, <5385, 5307, 5293>,
			<5446, 5494, 5495>, <5446, 5495, 5447>, <5558, 5606, 5607>, <5558, 5607, 5559>,
			<5906, 5850, 5849>, <5906, 5849, 5905>, <5849, 5819, 5877>, <5849, 5877, 5905>,
			<5850, 5820, 5819>, <5850, 5819, 5849>, <5905, 5877, 5878>, <5905, 5878, 5906>,
			<6018, 5962, 5961>, <6018, 5961, 6017>, <5961, 5933, 5989>, <5961, 5989, 6017>,
			<5962, 5934, 5933>, <5962, 5933, 5961>, <6017, 5989, 5990>, <6017, 5990, 6018>,
			<5963, 6019, 6020>, <5963, 6020, 5964>, <6020, 5992, 5936>, <6020, 5936, 5964>,
			<6019, 5991, 5992>, <6019, 5992, 6020>, <5964, 5936, 5935>, <5964, 5935, 5963>,
			<5851, 5907, 5908>, <5851, 5908, 5852>, <5908, 5880, 5822>, <5908, 5822, 5852>,
			<5907, 5879, 5880>, <5907, 5880, 5908>, <5852, 5822, 5821>, <5852, 5821, 5851>,
			<6058, 5785, 5792>, <6058, 5792, 6057>, <5784, 6056, 6057>, <5784, 6057, 5792>,
			<5879, 5907, 5963>, <5879, 5963, 5935>, <5878, 5906, 5962>, <5878, 5962, 5934>,
			<5769, 5821, 5851>, <5769, 5851, 5785>, <5769, 5785, 5755>, <5769, 5755, 5741>,
			<5768, 5820, 5850>, <5768, 5850, 5784>, <5768, 5784, 5754>, <5768, 5754, 5740>,
			<5740, 5754, 5726>, <5740, 5726, 5712>, <5741, 5755, 5727>, <5741, 5727, 5713>,
			<5991, 6019, 6058>, <5991, 6058, 6035>, <5990, 6018, 6056>, <5990, 6056, 6034>,
			<5902, 5846, 5845>, <5902, 5845, 5901>, <5845, 5815, 5873>, <5845, 5873, 5901>,
			<5846, 5816, 5815>, <5846, 5815, 5845>, <5901, 5873, 5874>, <5901, 5874, 5902>,
			<6014, 5958, 5957>, <6014, 5957, 6013>, <5957, 5929, 5985>, <5957, 5985, 6013>,
			<5958, 5930, 5929>, <5958, 5929, 5957>, <6013, 5985, 5986>, <6013, 5986, 6014>,
			<5959, 6015, 6016>, <5959, 6016, 5960>, <6016, 5988, 5932>, <6016, 5932, 5960>,
			<6015, 5987, 5988>, <6015, 5988, 6016>, <5960, 5932, 5931>, <5960, 5931, 5959>,
			<5847, 5903, 5904>, <5847, 5904, 5848>, <5904, 5876, 5818>, <5904, 5818, 5848>,
			<5903, 5875, 5876>, <5903, 5876, 5904>, <5848, 5818, 5817>, <5848, 5817, 5847>,
			<6055, 5783, 5791>, <6055, 5791, 6054>, <5782, 6053, 6054>, <5782, 6054, 5791>,
			<5875, 5903, 5959>, <5875, 5959, 5931>, <5874, 5902, 5958>, <5874, 5958, 5930>,
			<5767, 5817, 5847>, <5767, 5847, 5783>, <5767, 5783, 5753>, <5767, 5753, 5739>,
			<5766, 5816, 5846>, <5766, 5846, 5782>, <5766, 5782, 5752>, <5766, 5752, 5738>,
			<5738, 5752, 5724>, <5738, 5724, 5710>, <5739, 5753, 5725>, <5739, 5725, 5711>,
			<5987, 6015, 6055>, <5987, 6055, 6033>, <5986, 6014, 6053>, <5986, 6053, 6032>,
			<5898, 5842, 5841>, <5898, 5841, 5897>, <5841, 5811, 5869>, <5841, 5869, 5897>,
			<5842, 5812, 5811>, <5842, 5811, 5841>, <5897, 5869, 5870>, <5897, 5870, 5898>,
			<6010, 5954, 5953>, <6010, 5953, 6009>, <5953, 5925, 5981>, <5953, 5981, 6009>,
			<5954, 5926, 5925>, <5954, 5925, 5953>, <6009, 5981, 5982>, <6009, 5982, 6010>,
			<5955, 6011, 6012>, <5955, 6012, 5956>, <6012, 5984, 5928>, <6012, 5928, 5956>,
			<6011, 5983, 5984>, <6011, 5984, 6012>, <5956, 5928, 5927>, <5956, 5927, 5955>,
			<5843, 5899, 5900>, <5843, 5900, 5844>, <5900, 5872, 5814>, <5900, 5814, 5844>,
			<5899, 5871, 5872>, <5899, 5872, 5900>, <5844, 5814, 5813>, <5844, 5813, 5843>,
			<6052, 5781, 5790>, <6052, 5790, 6051>, <5780, 6050, 6051>, <5780, 6051, 5790>,
			<5871, 5899, 5955>, <5871, 5955, 5927>, <5870, 5898, 5954>, <5870, 5954, 5926>,
			<5765, 5813, 5843>, <5765, 5843, 5781>, <5765, 5781, 5751>, <5765, 5751, 5737>,
			<5764, 5812, 5842>, <5764, 5842, 5780>, <5764, 5780, 5750>, <5764, 5750, 5736>,
			<5736, 5750, 5722>, <5736, 5722, 5708>, <5737, 5751, 5723>, <5737, 5723, 5709>,
			<5983, 6011, 6052>, <5983, 6052, 6031>, <5982, 6010, 6050>, <5982, 6050, 6030>,
			<5894, 5836, 5835>, <5894, 5835, 5893>, <5835, 5805, 5865>, <5835, 5865, 5893>,
			<5836, 5806, 5805>, <5836, 5805, 5835>, <5893, 5865, 5866>, <5893, 5866, 5894>,
			<6006, 5950, 5949>, <6006, 5949, 6005>, <5949, 5921, 5977>, <5949, 5977, 6005>,
			<5950, 5922, 5921>, <5950, 5921, 5949>, <6005, 5977, 5978>, <6005, 5978, 6006>,
			<5951, 6007, 6008>, <5951, 6008, 5952>, <6008, 5980, 5924>, <6008, 5924, 5952>,
			<6007, 5979, 5980>, <6007, 5980, 6008>, <5952, 5924, 5923>, <5952, 5923, 5951>,
			<5838, 5895, 5896>, <5838, 5896, 5840>, <5896, 5868, 5810>, <5896, 5810, 5840>,
			<5895, 5867, 5868>, <5895, 5868, 5896>, <5840, 5810, 5808>, <5840, 5808, 5838>,
			<6049, 5778, 5789>, <6049, 5789, 6048>, <5776, 6047, 6048>, <5776, 6048, 5789>,
			<5867, 5895, 5951>, <5867, 5951, 5923>, <5866, 5894, 5950>, <5866, 5950, 5922>,
			<5763, 5809, 5839>, <5763, 5839, 5779>, <5763, 5779, 5749>, <5763, 5749, 5735>,
			<5762, 5807, 5837>, <5762, 5837, 5777>, <5762, 5777, 5748>, <5762, 5748, 5734>,
			<5734, 5748, 5720>, <5734, 5720, 5706>, <5735, 5749, 5721>, <5735, 5721, 5707>,
			<5979, 6007, 6049>, <5979, 6049, 6029>, <5978, 6006, 6047>, <5978, 6047, 6028>,
			<5890, 5832, 5831>, <5890, 5831, 5889>, <5831, 5801, 5861>, <5831, 5861, 5889>,
			<5832, 5802, 5801>, <5832, 5801, 5831>, <5889, 5861, 5862>, <5889, 5862, 5890>,
			<6002, 5946, 5945>, <6002, 5945, 6001>, <5945, 5917, 5973>, <5945, 5973, 6001>,
			<5946, 5918, 5917>, <5946, 5917, 5945>, <6001, 5973, 5974>, <6001, 5974, 6002>,
			<5947, 6003, 6004>, <5947, 6004, 5948>, <6004, 5976, 5920>, <6004, 5920, 5948>,
			<6003, 5975, 5976>, <6003, 5976, 6004>, <5948, 5920, 5919>, <5948, 5919, 5947>,
			<5833, 5891, 5892>, <5833, 5892, 5834>, <5892, 5864, 5804>, <5892, 5804, 5834>,
			<5891, 5863, 5864>, <5891, 5864, 5892>, <5834, 5804, 5803>, <5834, 5803, 5833>,
			<6046, 5775, 5788>, <6046, 5788, 6045>, <5774, 6044, 6045>, <5774, 6045, 5788>,
			<5863, 5891, 5947>, <5863, 5947, 5919>, <5862, 5890, 5946>, <5862, 5946, 5918>,
			<5761, 5803, 5833>, <5761, 5833, 5775>, <5761, 5775, 5747>, <5761, 5747, 5733>,
			<5760, 5802, 5832>, <5760, 5832, 5774>, <5760, 5774, 5746>, <5760, 5746, 5732>,
			<5732, 5746, 5718>, <5732, 5718, 5704>, <5733, 5747, 5719>, <5733, 5719, 5705>,
			<5975, 6003, 6046>, <5975, 6046, 6027>, <5974, 6002, 6044>, <5974, 6044, 6026>,
			<5886, 5828, 5827>, <5886, 5827, 5885>, <5827, 5797, 5857>, <5827, 5857, 5885>,
			<5828, 5798, 5797>, <5828, 5797, 5827>, <5885, 5857, 5858>, <5885, 5858, 5886>,
			<5998, 5942, 5941>, <5998, 5941, 5997>, <5941, 5913, 5969>, <5941, 5969, 5997>,
			<5942, 5914, 5913>, <5942, 5913, 5941>, <5997, 5969, 5970>, <5997, 5970, 5998>,
			<5943, 5999, 6000>, <5943, 6000, 5944>, <6000, 5972, 5916>, <6000, 5916, 5944>,
			<5999, 5971, 5972>, <5999, 5972, 6000>, <5944, 5916, 5915>, <5944, 5915, 5943>,
			<5829, 5887, 5888>, <5829, 5888, 5830>, <5888, 5860, 5800>, <5888, 5800, 5830>,
			<5887, 5859, 5860>, <5887, 5860, 5888>, <5830, 5800, 5799>, <5830, 5799, 5829>,
			<6043, 5773, 5787>, <6043, 5787, 6042>, <5772, 6041, 6042>, <5772, 6042, 5787>,
			<5859, 5887, 5943>, <5859, 5943, 5915>, <5858, 5886, 5942>, <5858, 5942, 5914>,
			<5759, 5799, 5829>, <5759, 5829, 5773>, <5759, 5773, 5745>, <5759, 5745, 5731>,
			<5758, 5798, 5828>, <5758, 5828, 5772>, <5758, 5772, 5744>, <5758, 5744, 5730>,
			<5730, 5744, 5716>, <5730, 5716, 5702>, <5731, 5745, 5717>, <5731, 5717, 5703>,
			<5971, 5999, 6043>, <5971, 6043, 6025>, <5970, 5998, 6041>, <5970, 6041, 6024>,
			<5882, 5824, 5823>, <5882, 5823, 5881>, <5823, 5793, 5853>, <5823, 5853, 5881>,
			<5824, 5794, 5793>, <5824, 5793, 5823>, <5881, 5853, 5854>, <5881, 5854, 5882>,
			<5994, 5938, 5937>, <5994, 5937, 5993>, <5937, 5909, 5965>, <5937, 5965, 5993>,
			<5938, 5910, 5909>, <5938, 5909, 5937>, <5993, 5965, 5966>, <5993, 5966, 5994>,
			<5939, 5995, 5996>, <5939, 5996, 5940>, <5996, 5968, 5912>, <5996, 5912, 5940>,
			<5995, 5967, 5968>, <5995, 5968, 5996>, <5940, 5912, 5911>, <5940, 5911, 5939>,
			<5825, 5883, 5884>, <5825, 5884, 5826>, <5884, 5856, 5796>, <5884, 5796, 5826>,
			<5883, 5855, 5856>, <5883, 5856, 5884>, <5826, 5796, 5795>, <5826, 5795, 5825>,
			<6040, 5771, 5786>, <6040, 5786, 6039>, <5770, 6038, 6039>, <5770, 6039, 5786>,
			<5855, 5883, 5939>, <5855, 5939, 5911>, <5854, 5882, 5938>, <5854, 5938, 5910>,
			<5757, 5795, 5825>, <5757, 5825, 5771>, <5757, 5771, 5743>, <5757, 5743, 5729>,
			<5756, 5794, 5824>, <5756, 5824, 5770>, <5756, 5770, 5742>, <5756, 5742, 5728>,
			<5728, 5742, 5714>, <5728, 5714, 5700>, <5729, 5743, 5715>, <5729, 5715, 5701>,
			<5967, 5995, 6040>, <5967, 6040, 6023>, <5966, 5994, 6038>, <5966, 6038, 6022>,
			<5451, 5452, 5343>, <5451, 5343, 5342>, <5343, 5311, 5310>, <5343, 5310, 5342>,
			<5452, 5404, 5311>, <5452, 5311, 5343>, <5342, 5310, 5403>, <5342, 5403, 5451>,
			<5449, 5450, 5341>, <5449, 5341, 5340>, <5341, 5309, 5308>, <5341, 5308, 5340>,
			<5450, 5402, 5309>, <5450, 5309, 5341>, <5340, 5308, 5401>, <5340, 5401, 5449>,
			<5562, 5561, 5668>, <5562, 5668, 5669>, <5668, 5636, 5637>, <5668, 5637, 5669>,
			<5561, 5513, 5636>, <5561, 5636, 5668>, <5669, 5637, 5514>, <5669, 5514, 5562>,
			<5564, 5563, 5670>, <5564, 5670, 5671>, <5670, 5638, 5639>, <5670, 5639, 5671>,
			<5563, 5515, 5638>, <5563, 5638, 5670>, <5671, 5639, 5516>, <5671, 5516, 5564>,
			<5560, 5565, 5497>, <5560, 5497, 5496>, <5453, 5448, 5496>, <5453, 5496, 5497>,
			<5515, 5563, 5562>, <5515, 5562, 5514>, <5403, 5451, 5450>, <5403, 5450, 5402>,
			<5517, 5516, 5564>, <5517, 5564, 5565>, <5517, 5565, 5622>, <5517, 5622, 5608>,
			<5405, 5404, 5452>, <5405, 5452, 5453>, <5405, 5453, 5386>, <5405, 5386, 5372>,
			<5372, 5386, 5294>, <5372, 5294, 5280>, <5608, 5622, 5714>, <5608, 5714, 5700>,
			<5513, 5561, 5560>, <5513, 5560, 5512>, <5401, 5449, 5448>, <5401, 5448, 5400>,
			<4641, 4642, 4533>, <4641, 4533, 4532>, <4533, 4501, 4500>, <4533, 4500, 4532>,
			<4642, 4594, 4501>, <4642, 4501, 4533>, <4532, 4500, 4593>, <4532, 4593, 4641>,
			<4639, 4640, 4531>, <4639, 4531, 4530>, <4531, 4499, 4498>, <4531, 4498, 4530>,
			<4640, 4592, 4499>, <4640, 4499, 4531>, <4530, 4498, 4591>, <4530, 4591, 4639>,
			<4752, 4751, 4858>, <4752, 4858, 4859>, <4858, 4826, 4827>, <4858, 4827, 4859>,
			<4751, 4703, 4826>, <4751, 4826, 4858>, <4859, 4827, 4704>, <4859, 4704, 4752>,
			<4754, 4753, 4860>, <4754, 4860, 4861>, <4860, 4828, 4829>, <4860, 4829, 4861>,
			<4753, 4705, 4828>, <4753, 4828, 4860>, <4861, 4829, 4706>, <4861, 4706, 4754>,
			<4750, 4755, 4687>, <4750, 4687, 4686>, <4643, 4638, 4686>, <4643, 4686, 4687>,
			<4705, 4753, 4752>, <4705, 4752, 4704>, <4593, 4641, 4640>, <4593, 4640, 4592>,
			<4707, 4706, 4754>, <4707, 4754, 4755>, <4707, 4755, 4812>, <4707, 4812, 4798>,
			<4595, 4594, 4642>, <4595, 4642, 4643>, <4595, 4643, 4576>, <4595, 4576, 4562>,
			<4562, 4576, 4484>, <4562, 4484, 4470>, <4798, 4812, 4904>, <4798, 4904, 4890>,
			<4703, 4751, 4750>, <4703, 4750, 4702>, <4591, 4639, 4638>, <4591, 4638, 4590>,
			<3831, 3832, 3723>, <3831, 3723, 3722>, <3723, 3691, 3690>, <3723, 3690, 3722>,
			<3832, 3784, 3691>, <3832, 3691, 3723>, <3722, 3690, 3783>, <3722, 3783, 3831>,
			<3829, 3830, 3721>, <3829, 3721, 3720>, <3721, 3689, 3688>, <3721, 3688, 3720>,
			<3830, 3782, 3689>, <3830, 3689, 3721>, <3720, 3688, 3781>, <3720, 3781, 3829>,
			<3942, 3941, 4048>, <3942, 4048, 4049>, <4048, 4016, 4017>, <4048, 4017, 4049>,
			<3941, 3893, 4016>, <3941, 4016, 4048>, <4049, 4017, 3894>, <4049, 3894, 3942>,
			<3944, 3943, 4050>, <3944, 4050, 4051>, <4050, 4018, 4019>, <4050, 4019, 4051>,
			<3943, 3895, 4018>, <3943, 4018, 4050>, <4051, 4019, 3896>, <4051, 3896, 3944>,
			<3940, 3945, 3877>, <3940, 3877, 3876>, <3833, 3828, 3876>, <3833, 3876, 3877>,
			<3895, 3943, 3942>, <3895, 3942, 3894>, <3783, 3831, 3830>, <3783, 3830, 3782>,
			<3897, 3896, 3944>, <3897, 3944, 3945>, <3897, 3945, 4002>, <3897, 4002, 3988>,
			<3785, 3784, 3832>, <3785, 3832, 3833>, <3785, 3833, 3766>, <3785, 3766, 3752>,
			<3752, 3766, 3674>, <3752, 3674, 3660>, <3988, 4002, 4094>, <3988, 4094, 4080>,
			<3893, 3941, 3940>, <3893, 3940, 3892>, <3781, 3829, 3828>, <3781, 3828, 3780>,
			<2923, 2924, 2829>, <2923, 2829, 2828>, <2829, 2797, 2796>, <2829, 2796, 2828>,
			<2924, 2890, 2797>, <2924, 2797, 2829>, <2828, 2796, 2889>, <2828, 2889, 2923>,
			<2921, 2922, 2827>, <2921, 2827, 2826>, <2827, 2795, 2794>, <2827, 2794, 2826>,
			<2922, 2888, 2795>, <2922, 2795, 2827>, <2826, 2794, 2887>, <2826, 2887, 2921>,
			<3076, 3075, 3238>, <3076, 3238, 3239>, <3238, 3206, 3207>, <3238, 3207, 3239>,
			<3075, 3041, 3206>, <3075, 3206, 3238>, <3239, 3207, 3042>, <3239, 3042, 3076>,
			<3078, 3077, 3240>, <3078, 3240, 3241>, <3240, 3208, 3209>, <3240, 3209, 3241>,
			<3077, 3043, 3208>, <3077, 3208, 3240>, <3241, 3209, 3044>, <3241, 3044, 3078>,
			<3074, 3079, 3025>, <3074, 3025, 3024>, <2925, 2920, 3024>, <2925, 3024, 3025>,
			<3043, 3077, 3076>, <3043, 3076, 3042>, <2889, 2923, 2922>, <2889, 2922, 2888>,
			<3123, 3122, 3150>, <3123, 3150, 3151>, <3123, 3151, 3192>, <3123, 3192, 3178>,
			<2969, 2968, 2996>, <2969, 2996, 2997>, <2969, 2997, 2872>, <2969, 2872, 2858>,
			<2858, 2872, 2780>, <2858, 2780, 2766>, <3178, 3192, 3284>, <3178, 3284, 3270>,
			<3041, 3075, 3074>, <3041, 3074, 3040>, <2887, 2921, 2920>, <2887, 2920, 2886>,
			<2127, 2128, 2019>, <2127, 2019, 2018>, <2019, 1987, 1986>, <2019, 1986, 2018>,
			<2128, 2080, 1987>, <2128, 1987, 2019>, <2018, 1986, 2079>, <2018, 2079, 2127>,
			<2125, 2126, 2017>, <2125, 2017, 2016>, <2017, 1985, 1984>, <2017, 1984, 2016>,
			<2126, 2078, 1985>, <2126, 1985, 2017>, <2016, 1984, 2077>, <2016, 2077, 2125>,
			<2238, 2237, 2344>, <2238, 2344, 2345>, <2344, 2312, 2313>, <2344, 2313, 2345>,
			<2237, 2189, 2312>, <2237, 2312, 2344>, <2345, 2313, 2190>, <2345, 2190, 2238>,
			<2240, 2239, 2346>, <2240, 2346, 2347>, <2346, 2314, 2315>, <2346, 2315, 2347>,
			<2239, 2191, 2314>, <2239, 2314, 2346>, <2347, 2315, 2192>, <2347, 2192, 2240>,
			<2236, 2241, 2173>, <2236, 2173, 2172>, <2129, 2124, 2172>, <2129, 2172, 2173>,
			<2191, 2239, 2238>, <2191, 2238, 2190>, <2079, 2127, 2126>, <2079, 2126, 2078>,
			<2193, 2192, 2240>, <2193, 2240, 2241>, <2193, 2241, 2298>, <2193, 2298, 2284>,
			<2081, 2080, 2128>, <2081, 2128, 2129>, <2081, 2129, 2062>, <2081, 2062, 2048>,
			<2048, 2062, 1970>, <2048, 1970, 1956>, <2284, 2298, 2390>, <2284, 2390, 2376>,
			<2189, 2237, 2236>, <2189, 2236, 2188>, <2077, 2125, 2124>, <2077, 2124, 2076>,
			<1317, 1318, 1209>, <1317, 1209, 1208>, <1209, 1177, 1176>, <1209, 1176, 1208>,
			<1318, 1270, 1177>, <1318, 1177, 1209>, <1208, 1176, 1269>, <1208, 1269, 1317>,
			<1315, 1316, 1207>, <1315, 1207, 1206>, <1207, 1175, 1174>, <1207, 1174, 1206>,
			<1316, 1268, 1175>, <1316, 1175, 1207>, <1206, 1174, 1267>, <1206, 1267, 1315>,
			<1428, 1427, 1534>, <1428, 1534, 1535>, <1534, 1502, 1503>, <1534, 1503, 1535>,
			<1427, 1379, 1502>, <1427, 1502, 1534>, <1535, 1503, 1380>, <1535, 1380, 1428>,
			<1430, 1429, 1536>, <1430, 1536, 1537>, <1536, 1504, 1505>, <1536, 1505, 1537>,
			<1429, 1381, 1504>, <1429, 1504, 1536>, <1537, 1505, 1382>, <1537, 1382, 1430>,
			<1426, 1431, 1363>, <1426, 1363, 1362>, <1319, 1314, 1362>, <1319, 1362, 1363>,
			<1381, 1429, 1428>, <1381, 1428, 1380>, <1269, 1317, 1316>, <1269, 1316, 1268>,
			<1383, 1382, 1430>, <1383, 1430, 1431>, <1383, 1431, 1488>, <1383, 1488, 1474>,
			<1271, 1270, 1318>, <1271, 1318, 1319>, <1271, 1319, 1252>, <1271, 1252, 1238>,
			<1238, 1252, 1160>, <1238, 1160, 1146>, <1474, 1488, 1580>, <1474, 1580, 1566>,
			<1379, 1427, 1426>, <1379, 1426, 1378>, <1267, 1315, 1314>, <1267, 1314, 1266>,
			<507, 508, 399>, <507, 399, 398>, <399, 367, 366>, <399, 366, 398>,
			<508, 460, 367>, <508, 367, 399>, <398, 366, 459>, <398, 459, 507>,
			<505, 506, 397>, <505, 397, 396>, <397, 365, 364>, <397, 364, 396>,
			<506, 458, 365>, <506, 365, 397>, <396, 364, 457>, <396, 457, 505>,
			<618, 617, 724>, <618, 724, 725>, <724, 692, 693>, <724, 693, 725>,
			<617, 569, 692>, <617, 692, 724>, <725, 693, 570>, <725, 570, 618>,
			<620, 619, 726>, <620, 726, 727>, <726, 694, 695>, <726, 695, 727>,
			<619, 571, 694>, <619, 694, 726>, <727, 695, 572>, <727, 572, 620>,
			<616, 621, 553>, <616, 553, 552>, <509, 504, 552>, <509, 552, 553>,
			<571, 619, 618>, <571, 618, 570>, <459, 507, 506>, <459, 506, 458>,
			<573, 572, 620>, <573, 620, 621>, <573, 621, 678>, <573, 678, 664>,
			<461, 460, 508>, <461, 508, 509>, <461, 509, 442>, <461, 442, 428>,
			<428, 442, 350>, <428, 350, 336>, <664, 678, 770>, <664, 770, 756>,
			<569, 617, 616>, <569, 616, 568>, <457, 505, 504>, <457, 504, 456>,
			<185, 243, 244>, <185, 244, 186>, <244, 214, 158>, <244, 158, 186>,
			<243, 213, 214>, <243, 214, 244>, <186, 158, 157>, <186, 157, 185>,
			<73, 129, 130>, <73, 130, 74>, <130, 102, 46>, <130, 46, 74>,
			<129, 101, 102>, <129, 102, 130>, <74, 46, 45>, <74, 45, 73>,
			<128, 72, 71>, <128, 71, 127>, <71, 43, 99>, <71, 99, 127>,
			<72, 44, 43>, <72, 43, 71>, <127, 99, 100>, <127, 100, 128>,
			<242, 184, 183>, <242, 183, 241>, <183, 155, 211>, <183, 211, 241>,
			<184, 156, 155>, <184, 155, 183>, <241, 211, 212>, <241, 212, 242>,
			<21, 292, 271>, <21, 271, 22>, <293, 23, 22>, <293, 22, 271>,
			<156, 184, 128>, <156, 128, 100>, <157, 185, 129>, <157, 129, 101>,
			<278, 212, 242>, <278, 242, 292>, <278, 292, 322>, <278, 322, 308>,
			<279, 213, 243>, <279, 243, 293>, <279, 293, 323>, <279, 323, 309>,
			<309, 323, 351>, <309, 351, 337>, <308, 322, 350>, <308, 350, 336>,
			<44, 72, 21>, <44, 21, 5>, <45, 73, 23>, <45, 23, 6>,
			<189, 247, 248>, <189, 248, 190>, <248, 218, 162>, <248, 162, 190>,
			<247, 217, 218>, <247, 218, 248>, <190, 162, 161>, <190, 161, 189>,
			<77, 133, 134>, <77, 134, 78>, <134, 106, 50>, <134, 50, 78>,
			<133, 105, 106>, <133, 106, 134>, <78, 50, 49>, <78, 49, 77>,
			<132, 76, 75>, <132, 75, 131>, <75, 47, 103>, <75, 103, 131>,
			<76, 48, 47>, <76, 47, 75>, <131, 103, 104>, <131, 104, 132>,
			<246, 188, 187>, <246, 187, 245>, <187, 159, 215>, <187, 215, 245>,
			<188, 160, 159>, <188, 159, 187>, <245, 215, 216>, <245, 216, 246>,
			<24, 294, 272>, <24, 272, 25>, <295, 26, 25>, <295, 25, 272>,
			<160, 188, 132>, <160, 132, 104>, <161, 189, 133>, <161, 133, 105>,
			<280, 216, 246>, <280, 246, 294>, <280, 294, 324>, <280, 324, 310>,
			<281, 217, 247>, <281, 247, 295>, <281, 295, 325>, <281, 325, 311>,
			<311, 325, 353>, <311, 353, 339>, <310, 324, 352>, <310, 352, 338>,
			<48, 76, 24>, <48, 24, 7>, <49, 77, 26>, <49, 26, 8>,
			<193, 251, 252>, <193, 252, 194>, <252, 222, 166>, <252, 166, 194>,
			<251, 221, 222>, <251, 222, 252>, <194, 166, 165>, <194, 165, 193>,
			<81, 137, 138>, <81, 138, 82>, <138, 110, 54>, <138, 54, 82>,
			<137, 109, 110>, <137, 110, 138>, <82, 54, 53>, <82, 53, 81>,
			<136, 80, 79>, <136, 79, 135>, <79, 51, 107>, <79, 107, 135>,
			<80, 52, 51>, <80, 51, 79>, <135, 107, 108>, <135, 108, 136>,
			<250, 192, 191>, <250, 191, 249>, <191, 163, 219>, <191, 219, 249>,
			<192, 164, 163>, <192, 163, 191>, <249, 219, 220>, <249, 220, 250>,
			<27, 296, 273>, <27, 273, 28>, <297, 29, 28>, <297, 28, 273>,
			<164, 192, 136>, <164, 136, 108>, <165, 193, 137>, <165, 137, 109>,
			<282, 220, 250>, <282, 250, 296>, <282, 296, 326>, <282, 326, 312>,
			<283, 221, 251>, <283, 251, 297>, <283, 297, 327>, <283, 327, 313>,
			<313, 327, 355>, <313, 355, 341>, <312, 326, 354>, <312, 354, 340>,
			<52, 80, 27>, <52, 27, 9>, <53, 81, 29>, <53, 29, 10>,
			<197, 256, 258>, <197, 258, 198>, <258, 228, 170>, <258, 170, 198>,
			<256, 226, 228>, <256, 228, 258>, <198, 170, 169>, <198, 169, 197>,
			<85, 141, 142>, <85, 142, 86>, <142, 114, 58>, <142, 58, 86>,
			<141, 113, 114>, <141, 114, 142>, <86, 58, 57>, <86, 57, 85>,
			<140, 84, 83>, <140, 83, 139>, <83, 55, 111>, <83, 111, 139>,
			<84, 56, 55>, <84, 55, 83>, <139, 111, 112>, <139, 112, 140>,
			<254, 196, 195>, <254, 195, 253>, <195, 167, 223>, <195, 223, 253>,
			<196, 168, 167>, <196, 167, 195>, <253, 223, 224>, <253, 224, 254>,
			<30, 298, 274>, <30, 274, 31>, <300, 32, 31>, <300, 31, 274>,
			<168, 196, 140>, <168, 140, 112>, <169, 197, 141>, <169, 141, 113>,
			<284, 225, 255>, <284, 255, 299>, <284, 299, 328>, <284, 328, 314>,
			<285, 227, 257>, <285, 257, 301>, <285, 301, 329>, <285, 329, 315>,
			<315, 329, 357>, <315, 357, 343>, <314, 328, 356>, <314, 356, 342>,
			<56, 84, 30>, <56, 30, 11>, <57, 85, 32>, <57, 32, 12>,
			<201, 261, 262>, <201, 262, 202>, <262, 232, 174>, <262, 174, 202>,
			<261, 231, 232>, <261, 232, 262>, <202, 174, 173>, <202, 173, 201>,
			<89, 145, 146>, <89, 146, 90>, <146, 118, 62>, <146, 62, 90>,
			<145, 117, 118>, <145, 118, 146>, <90, 62, 61>, <90, 61, 89>,
			<144, 88, 87>, <144, 87, 143>, <87, 59, 115>, <87, 115, 143>,
			<88, 60, 59>, <88, 59, 87>, <143, 115, 116>, <143, 116, 144>,
			<260, 200, 199>, <260, 199, 259>, <199, 171, 229>, <199, 229, 259>,
			<200, 172, 171>, <200, 171, 199>, <259, 229, 230>, <259, 230, 260>,
			<33, 302, 275>, <33, 275, 34>, <303, 35, 34>, <303, 34, 275>,
			<172, 200, 144>, <172, 144, 116>, <173, 201, 145>, <173, 145, 117>,
			<286, 230, 260>, <286, 260, 302>, <286, 302, 330>, <286, 330, 316>,
			<287, 231, 261>, <287, 261, 303>, <287, 303, 331>, <287, 331, 317>,
			<317, 331, 359>, <317, 359, 345>, <316, 330, 358>, <316, 358, 344>,
			<60, 88, 33>, <60, 33, 13>, <61, 89, 35>, <61, 35, 14>,
			<205, 265, 266>, <205, 266, 206>, <266, 236, 178>, <266, 178, 206>,
			<265, 235, 236>, <265, 236, 266>, <206, 178, 177>, <206, 177, 205>,
			<93, 149, 150>, <93, 150, 94>, <150, 122, 66>, <150, 66, 94>,
			<149, 121, 122>, <149, 122, 150>, <94, 66, 65>, <94, 65, 93>,
			<148, 92, 91>, <148, 91, 147>, <91, 63, 119>, <91, 119, 147>,
			<92, 64, 63>, <92, 63, 91>, <147, 119, 120>, <147, 120, 148>,
			<264, 204, 203>, <264, 203, 263>, <203, 175, 233>, <203, 233, 263>,
			<204, 176, 175>, <204, 175, 203>, <263, 233, 234>, <263, 234, 264>,
			<36, 304, 276>, <36, 276, 37>, <305, 38, 37>, <305, 37, 276>,
			<176, 204, 148>, <176, 148, 120>, <177, 205, 149>, <177, 149, 121>,
			<288, 234, 264>, <288, 264, 304>, <288, 304, 332>, <288, 332, 318>,
			<289, 235, 265>, <289, 265, 305>, <289, 305, 333>, <289, 333, 319>,
			<319, 333, 361>, <319, 361, 347>, <318, 332, 360>, <318, 360, 346>,
			<64, 92, 36>, <64, 36, 15>, <65, 93, 38>, <65, 38, 16>,
			<209, 269, 270>, <209, 270, 210>, <270, 240, 182>, <270, 182, 210>,
			<269, 239, 240>, <269, 240, 270>, <210, 182, 181>, <210, 181, 209>,
			<97, 153, 154>, <97, 154, 98>, <154, 126, 70>, <154, 70, 98>,
			<153, 125, 126>, <153, 126, 154>, <98, 70, 69>, <98, 69, 97>,
			<152, 96, 95>, <152, 95, 151>, <95, 67, 123>, <95, 123, 151>,
			<96, 68, 67>, <96, 67, 95>, <151, 123, 124>, <151, 124, 152>,
			<268, 208, 207>, <268, 207, 267>, <207, 179, 237>, <207, 237, 267>,
			<208, 180, 179>, <208, 179, 207>, <267, 237, 238>, <267, 238, 268>,
			<39, 306, 277>, <39, 277, 40>, <307, 41, 40>, <307, 40, 277>,
			<180, 208, 152>, <180, 152, 124>, <181, 209, 153>, <181, 153, 125>,
			<290, 238, 268>, <290, 268, 306>, <290, 306, 334>, <290, 334, 320>,
			<291, 239, 269>, <291, 269, 307>, <291, 307, 335>, <291, 335, 321>,
			<321, 335, 363>, <321, 363, 349>, <320, 334, 362>, <320, 362, 348>,
			<68, 96, 39>, <68, 39, 17>, <69, 97, 41>, <69, 41, 18>,
			<938, 880, 879>, <938, 879, 937>, <879, 849, 909>, <879, 909, 937>,
			<880, 850, 849>, <880, 849, 879>, <937, 909, 910>, <937, 910, 938>,
			<1052, 994, 993>, <1052, 993, 1051>, <993, 965, 1021>, <993, 1021, 1051>,
			<994, 966, 965>, <994, 965, 993>, <1051, 1021, 1022>, <1051, 1022, 1052>,
			<995, 1053, 1054>, <995, 1054, 996>, <1054, 1024, 968>, <1054, 968, 996>,
			<1053, 1023, 1024>, <1053, 1024, 1054>, <996, 968, 967>, <996, 967, 995>,
			<881, 939, 940>, <881, 940, 882>, <940, 912, 852>, <940, 852, 882>,
			<939, 911, 912>, <939, 912, 940>, <882, 852, 851>, <882, 851, 881>,
			<1103, 827, 842>, <1103, 842, 1081>, <826, 1102, 1081>, <826, 1081, 842>,
			<911, 939, 995>, <911, 995, 967>, <910, 938, 994>, <910, 994, 966>,
			<813, 851, 881>, <813, 881, 827>, <813, 827, 799>, <813, 799, 785>,
			<812, 850, 880>, <812, 880, 826>, <812, 826, 798>, <812, 798, 784>,
			<1088, 1022, 1052>, <1088, 1052, 1102>, <1088, 1102, 1132>, <1088, 1132, 1118>,
			<1089, 1023, 1053>, <1089, 1053, 1103>, <1089, 1103, 1133>, <1089, 1133, 1119>,
			<1119, 1133, 1161>, <1119, 1161, 1147>, <1118, 1132, 1160>, <1118, 1160, 1146>,
			<784, 798, 770>, <784, 770, 756>, <785, 799, 771>, <785, 771, 757>,
			<1748, 1690, 1689>, <1748, 1689, 1747>, <1689, 1659, 1719>, <1689, 1719, 1747>,
			<1690, 1660, 1659>, <1690, 1659, 1689>, <1747, 1719, 1720>, <1747, 1720, 1748>,
			<1862, 1804, 1803>, <1862, 1803, 1861>, <1803, 1775, 1831>, <1803, 1831, 1861>,
			<1804, 1776, 1775>, <1804, 1775, 1803>, <1861, 1831, 1832>, <1861, 1832, 1862>,
			<1805, 1863, 1864>, <1805, 1864, 1806>, <1864, 1834, 1778>, <1864, 1778, 1806>,
			<1863, 1833, 1834>, <1863, 1834, 1864>, <1806, 1778, 1777>, <1806, 1777, 1805>,
			<1691, 1749, 1750>, <1691, 1750, 1692>, <1750, 1722, 1662>, <1750, 1662, 1692>,
			<1749, 1721, 1722>, <1749, 1722, 1750>, <1692, 1662, 1661>, <1692, 1661, 1691>,
			<1913, 1637, 1652>, <1913, 1652, 1891>, <1636, 1912, 1891>, <1636, 1891, 1652>,
			<1721, 1749, 1805>, <1721, 1805, 1777>, <1720, 1748, 1804>, <1720, 1804, 1776>,
			<1623, 1661, 1691>, <1623, 1691, 1637>, <1623, 1637, 1609>, <1623, 1609, 1595>,
			<1622, 1660, 1690>, <1622, 1690, 1636>, <1622, 1636, 1608>, <1622, 1608, 1594>,
			<1898, 1832, 1862>, <1898, 1862, 1912>, <1898, 1912, 1942>, <1898, 1942, 1928>,
			<1899, 1833, 1863>, <1899, 1863, 1913>, <1899, 1913, 1943>, <1899, 1943, 1929>,
			<1929, 1943, 1971>, <1929, 1971, 1957>, <1928, 1942, 1970>, <1928, 1970, 1956>,
			<1594, 1608, 1580>, <1594, 1580, 1566>, <1595, 1609, 1581>, <1595, 1581, 1567>,
			<2558, 2500, 2499>, <2558, 2499, 2557>, <2499, 2469, 2529>, <2499, 2529, 2557>,
			<2500, 2470, 2469>, <2500, 2469, 2499>, <2557, 2529, 2530>, <2557, 2530, 2558>,
			<2672, 2614, 2613>, <2672, 2613, 2671>, <2613, 2585, 2641>, <2613, 2641, 2671>,
			<2614, 2586, 2585>, <2614, 2585, 2613>, <2671, 2641, 2642>, <2671, 2642, 2672>,
			<2615, 2673, 2674>, <2615, 2674, 2616>, <2674, 2644, 2588>, <2674, 2588, 2616>,
			<2673, 2643, 2644>, <2673, 2644, 2674>, <2616, 2588, 2587>, <2616, 2587, 2615>,
			<2501, 2559, 2560>, <2501, 2560, 2502>, <2560, 2532, 2472>, <2560, 2472, 2502>,
			<2559, 2531, 2532>, <2559, 2532, 2560>, <2502, 2472, 2471>, <2502, 2471, 2501>,
			<2723, 2447, 2462>, <2723, 2462, 2701>, <2446, 2722, 2701>, <2446, 2701, 2462>,
			<2531, 2559, 2615>, <2531, 2615, 2587>, <2530, 2558, 2614>, <2530, 2614, 2586>,
			<2433, 2471, 2501>, <2433, 2501, 2447>, <2433, 2447, 2419>, <2433, 2419, 2405>,
			<2432, 2470, 2500>, <2432, 2500, 2446>, <2432, 2446, 2418>, <2432, 2418, 2404>,
			<2708, 2642, 2672>, <2708, 2672, 2722>, <2708, 2722, 2752>, <2708, 2752, 2738>,
			<2709, 2643, 2673>, <2709, 2673, 2723>, <2709, 2723, 2753>, <2709, 2753, 2739>,
			<2739, 2753, 2781>, <2739, 2781, 2767>, <2738, 2752, 2780>, <2738, 2780, 2766>,
			<2404, 2418, 2390>, <2404, 2390, 2376>, <2405, 2419, 2391>, <2405, 2391, 2377>,
			<3452, 3394, 3393>, <3452, 3393, 3451>, <3393, 3363, 3423>, <3393, 3423, 3451>,
			<3394, 3364, 3363>, <3394, 3363, 3393>, <3451, 3423, 3424>, <3451, 3424, 3452>,
			<3566, 3508, 3507>, <3566, 3507, 3565>, <3507, 3479, 3535>, <3507, 3535, 3565>,
			<3508, 3480, 3479>, <3508, 3479, 3507>, <3565, 3535, 3536>, <3565, 3536, 3566>,
			<3509, 3567, 3568>, <3509, 3568, 3510>, <3568, 3538, 3482>, <3568, 3482, 3510>,
			<3567, 3537, 3538>, <3567, 3538, 3568>, <3510, 3482, 3481>, <3510, 3481, 3509>,
			<3395, 3453, 3454>, <3395, 3454, 3396>, <3454, 3426, 3366>, <3454, 3366, 3396>,
			<3453, 3425, 3426>, <3453, 3426, 3454>, <3396, 3366, 3365>, <3396, 3365, 3395>,
			<3617, 3341, 3356>, <3617, 3356, 3595>, <3340, 3616, 3595>, <3340, 3595, 3356>,
			<3425, 3453, 3509>, <3425, 3509, 3481>, <3424, 3452, 3508>, <3424, 3508, 3480>,
			<3327, 3365, 3395>, <3327, 3395, 3341>, <3327, 3341, 3313>, <3327, 3313, 3299>,
			<3326, 3364, 3394>, <3326, 3394, 3340>, <3326, 3340, 3312>, <3326, 3312, 3298>,
			<3602, 3536, 3566>, <3602, 3566, 3616>, <3602, 3616, 3646>, <3602, 3646, 3632>,
			<3603, 3537, 3567>, <3603, 3567, 3617>, <3603, 3617, 3647>, <3603, 3647, 3633>,
			<3633, 3647, 3675>, <3633, 3675, 3661>, <3632, 3646, 3674>, <3632, 3674, 3660>,
			<3298, 3312, 3284>, <3298, 3284, 3270>, <3299, 3313, 3285>, <3299, 3285, 3271>,
			<4262, 4204, 4203>, <4262, 4203, 4261>, <4203, 4173, 4233>, <4203, 4233, 4261>,
			<4204, 4174, 4173>, <4204, 4173, 4203>, <4261, 4233, 4234>, <4261, 4234, 4262>,
			<4376, 4318, 4317>, <4376, 4317, 4375>, <4317, 4289, 4345>, <4317, 4345, 4375>,
			<4318, 4290, 4289>, <4318, 4289, 4317>, <4375, 4345, 4346>, <4375, 4346, 4376>,
			<4319, 4377, 4378>, <4319, 4378, 4320>, <4378, 4348, 4292>, <4378, 4292, 4320>,
			<4377, 4347, 4348>, <4377, 4348, 4378>, <4320, 4292, 4291>, <4320, 4291, 4319>,
			<4205, 4263, 4264>, <4205, 4264, 4206>, <4264, 4236, 4176>, <4264, 4176, 4206>,
			<4263, 4235, 4236>, <4263, 4236, 4264>, <4206, 4176, 4175>, <4206, 4175, 4205>,
			<4427, 4151, 4166>, <4427, 4166, 4405>, <4150, 4426, 4405>, <4150, 4405, 4166>,
			<4235, 4263, 4319>, <4235, 4319, 4291>, <4234, 4262, 4318>, <4234, 4318, 4290>,
			<4137, 4175, 4205>, <4137, 4205, 4151>, <4137, 4151, 4123>, <4137, 4123, 4109>,
			<4136, 4174, 4204>, <4136, 4204, 4150>, <4136, 4150, 4122>, <4136, 4122, 4108>,
			<4412, 4346, 4376>, <4412, 4376, 4426>, <4412, 4426, 4456>, <4412, 4456, 4442>,
			<4413, 4347, 4377>, <4413, 4377, 4427>, <4413, 4427, 4457>, <4413, 4457, 4443>,
			<4443, 4457, 4485>, <4443, 4485, 4471>, <4442, 4456, 4484>, <4442, 4484, 4470>,
			<4108, 4122, 4094>, <4108, 4094, 4080>, <4109, 4123, 4095>, <4109, 4095, 4081>,
			<5072, 5014, 5013>, <5072, 5013, 5071>, <5013, 4983, 5043>, <5013, 5043, 5071>,
			<5014, 4984, 4983>, <5014, 4983, 5013>, <5071, 5043, 5044>, <5071, 5044, 5072>,
			<5186, 5128, 5127>, <5186, 5127, 5185>, <5127, 5099, 5155>, <5127, 5155, 5185>,
			<5128, 5100, 5099>, <5128, 5099, 5127>, <5185, 5155, 5156>, <5185, 5156, 5186>,
			<5129, 5187, 5188>, <5129, 5188, 5130>, <5188, 5158, 5102>, <5188, 5102, 5130>,
			<5187, 5157, 5158>, <5187, 5158, 5188>, <5130, 5102, 5101>, <5130, 5101, 5129>,
			<5015, 5073, 5074>, <5015, 5074, 5016>, <5074, 5046, 4986>, <5074, 4986, 5016>,
			<5073, 5045, 5046>, <5073, 5046, 5074>, <5016, 4986, 4985>, <5016, 4985, 5015>,
			<5237, 4961, 4976>, <5237, 4976, 5215>, <4960, 5236, 5215>, <4960, 5215, 4976>,
			<5045, 5073, 5129>, <5045, 5129, 5101>, <5044, 5072, 5128>, <5044, 5128, 5100>,
			<4947, 4985, 5015>, <4947, 5015, 4961>, <4947, 4961, 4933>, <4947, 4933, 4919>,
			<4946, 4984, 5014>, <4946, 5014, 4960>, <4946, 4960, 4932>, <4946, 4932, 4918>,
			<5222, 5156, 5186>, <5222, 5186, 5236>, <5222, 5236, 5266>, <5222, 5266, 5252>,
			<5223, 5157, 5187>, <5223, 5187, 5237>, <5223, 5237, 5267>, <5223, 5267, 5253>,
			<5253, 5267, 5295>, <5253, 5295, 5281>, <5252, 5266, 5294>, <5252, 5294, 5280>,
			<4918, 4932, 4904>, <4918, 4904, 4890>, <4919, 4933, 4905>, <4919, 4905, 4891>,
			<942, 884, 883>, <942, 883, 941>, <883, 853, 913>, <883, 913, 941>,
			<884, 854, 853>, <884, 853, 883>, <941, 913, 914>, <941, 914, 942>,
			<1056, 998, 997>, <1056, 997, 1055>, <997, 969, 1025>, <997, 1025, 1055>,
			<998, 970, 969>, <998, 969, 997>, <1055, 1025, 1026>, <1055, 1026, 1056>,
			<999, 1057, 1058>, <999, 1058, 1000>, <1058, 1028, 972>, <1058, 972, 1000>,
			<1057, 1027, 1028>, <1057, 1028, 1058>, <1000, 972, 971>, <1000, 971, 999>,
			<885, 943, 944>, <885, 944, 886>, <944, 916, 856>, <944, 856, 886>,
			<943, 915, 916>, <943, 916, 944>, <886, 856, 855>, <886, 855, 885>,
			<1105, 829, 843>, <1105, 843, 1082>, <828, 1104, 1082>, <828, 1082, 843>,
			<915, 943, 999>, <915, 999, 971>, <914, 942, 998>, <914, 998, 970>,
			<815, 855, 885>, <815, 885, 829>, <815, 829, 801>, <815, 801, 787>,
			<814, 854, 884>, <814, 884, 828>, <814, 828, 800>, <814, 800, 786>,
			<1090, 1026, 1056>, <1090, 1056, 1104>, <1090, 1104, 1134>, <1090, 1134, 1120>,
			<1091, 1027, 1057>, <1091, 1057, 1105>, <1091, 1105, 1135>, <1091, 1135, 1121>,
			<1121, 1135, 1163>, <1121, 1163, 1149>, <1120, 1134, 1162>, <1120, 1162, 1148>,
			<786, 800, 772>, <786, 772, 758>, <787, 801, 773>, <787, 773, 759>,
			<1752, 1694, 1693>, <1752, 1693, 1751>, <1693, 1663, 1723>, <1693, 1723, 1751>,
			<1694, 1664, 1663>, <1694, 1663, 1693>, <1751, 1723, 1724>, <1751, 1724, 1752>,
			<1866, 1808, 1807>, <1866, 1807, 1865>, <1807, 1779, 1835>, <1807, 1835, 1865>,
			<1808, 1780, 1779>, <1808, 1779, 1807>, <1865, 1835, 1836>, <1865, 1836, 1866>,
			<1809, 1867, 1868>, <1809, 1868, 1810>, <1868, 1838, 1782>, <1868, 1782, 1810>,
			<1867, 1837, 1838>, <1867, 1838, 1868>, <1810, 1782, 1781>, <1810, 1781, 1809>,
			<1695, 1753, 1754>, <1695, 1754, 1696>, <1754, 1726, 1666>, <1754, 1666, 1696>,
			<1753, 1725, 1726>, <1753, 1726, 1754>, <1696, 1666, 1665>, <1696, 1665, 1695>,
			<1915, 1639, 1653>, <1915, 1653, 1892>, <1638, 1914, 1892>, <1638, 1892, 1653>,
			<1725, 1753, 1809>, <1725, 1809, 1781>, <1724, 1752, 1808>, <1724, 1808, 1780>,
			<1625, 1665, 1695>, <1625, 1695, 1639>, <1625, 1639, 1611>, <1625, 1611, 1597>,
			<1624, 1664, 1694>, <1624, 1694, 1638>, <1624, 1638, 1610>, <1624, 1610, 1596>,
			<1900, 1836, 1866>, <1900, 1866, 1914>, <1900, 1914, 1944>, <1900, 1944, 1930>,
			<1901, 1837, 1867>, <1901, 1867, 1915>, <1901, 1915, 1945>, <1901, 1945, 1931>,
			<1931, 1945, 1973>, <1931, 1973, 1959>, <1930, 1944, 1972>, <1930, 1972, 1958>,
			<1596, 1610, 1582>, <1596, 1582, 1568>, <1597, 1611, 1583>, <1597, 1583, 1569>,
			<2562, 2504, 2503>, <2562, 2503, 2561>, <2503, 2473, 2533>, <2503, 2533, 2561>,
			<2504, 2474, 2473>, <2504, 2473, 2503>, <2561, 2533, 2534>, <2561, 2534, 2562>,
			<2676, 2618, 2617>, <2676, 2617, 2675>, <2617, 2589, 2645>, <2617, 2645, 2675>,
			<2618, 2590, 2589>, <2618, 2589, 2617>, <2675, 2645, 2646>, <2675, 2646, 2676>,
			<2619, 2677, 2678>, <2619, 2678, 2620>, <2678, 2648, 2592>, <2678, 2592, 2620>,
			<2677, 2647, 2648>, <2677, 2648, 2678>, <2620, 2592, 2591>, <2620, 2591, 2619>,
			<2505, 2563, 2564>, <2505, 2564, 2506>, <2564, 2536, 2476>, <2564, 2476, 2506>,
			<2563, 2535, 2536>, <2563, 2536, 2564>, <2506, 2476, 2475>, <2506, 2475, 2505>,
			<2725, 2449, 2463>, <2725, 2463, 2702>, <2448, 2724, 2702>, <2448, 2702, 2463>,
			<2535, 2563, 2619>, <2535, 2619, 2591>, <2534, 2562, 2618>, <2534, 2618, 2590>,
			<2435, 2475, 2505>, <2435, 2505, 2449>, <2435, 2449, 2421>, <2435, 2421, 2407>,
			<2434, 2474, 2504>, <2434, 2504, 2448>, <2434, 2448, 2420>, <2434, 2420, 2406>,
			<2710, 2646, 2676>, <2710, 2676, 2724>, <2710, 2724, 2754>, <2710, 2754, 2740>,
			<2711, 2647, 2677>, <2711, 2677, 2725>, <2711, 2725, 2755>, <2711, 2755, 2741>,
			<2741, 2755, 2783>, <2741, 2783, 2769>, <2740, 2754, 2782>, <2740, 2782, 2768>,
			<2406, 2420, 2392>, <2406, 2392, 2378>, <2407, 2421, 2393>, <2407, 2393, 2379>,
			<3456, 3398, 3397>, <3456, 3397, 3455>, <3397, 3367, 3427>, <3397, 3427, 3455>,
			<3398, 3368, 3367>, <3398, 3367, 3397>, <3455, 3427, 3428>, <3455, 3428, 3456>,
			<3570, 3512, 3511>, <3570, 3511, 3569>, <3511, 3483, 3539>, <3511, 3539, 3569>,
			<3512, 3484, 3483>, <3512, 3483, 3511>, <3569, 3539, 3540>, <3569, 3540, 3570>,
			<3513, 3571, 3572>, <3513, 3572, 3514>, <3572, 3542, 3486>, <3572, 3486, 3514>,
			<3571, 3541, 3542>, <3571, 3542, 3572>, <3514, 3486, 3485>, <3514, 3485, 3513>,
			<3399, 3457, 3458>, <3399, 3458, 3400>, <3458, 3430, 3370>, <3458, 3370, 3400>,
			<3457, 3429, 3430>, <3457, 3430, 3458>, <3400, 3370, 3369>, <3400, 3369, 3399>,
			<3619, 3343, 3357>, <3619, 3357, 3596>, <3342, 3618, 3596>, <3342, 3596, 3357>,
			<3429, 3457, 3513>, <3429, 3513, 3485>, <3428, 3456, 3512>, <3428, 3512, 3484>,
			<3329, 3369, 3399>, <3329, 3399, 3343>, <3329, 3343, 3315>, <3329, 3315, 3301>,
			<3328, 3368, 3398>, <3328, 3398, 3342>, <3328, 3342, 3314>, <3328, 3314, 3300>,
			<3604, 3540, 3570>, <3604, 3570, 3618>, <3604, 3618, 3648>, <3604, 3648, 3634>,
			<3605, 3541, 3571>, <3605, 3571, 3619>, <3605, 3619, 3649>, <3605, 3649, 3635>,
			<3635, 3649, 3677>, <3635, 3677, 3663>, <3634, 3648, 3676>, <3634, 3676, 3662>,
			<3300, 3314, 3286>, <3300, 3286, 3272>, <3301, 3315, 3287>, <3301, 3287, 3273>,
			<4266, 4208, 4207>, <4266, 4207, 4265>, <4207, 4177, 4237>, <4207, 4237, 4265>,
			<4208, 4178, 4177>, <4208, 4177, 4207>, <4265, 4237, 4238>, <4265, 4238, 4266>,
			<4380, 4322, 4321>, <4380, 4321, 4379>, <4321, 4293, 4349>, <4321, 4349, 4379>,
			<4322, 4294, 4293>, <4322, 4293, 4321>, <4379, 4349, 4350>, <4379, 4350, 4380>,
			<4323, 4381, 4382>, <4323, 4382, 4324>, <4382, 4352, 4296>, <4382, 4296, 4324>,
			<4381, 4351, 4352>, <4381, 4352, 4382>, <4324, 4296, 4295>, <4324, 4295, 4323>,
			<4209, 4267, 4268>, <4209, 4268, 4210>, <4268, 4240, 4180>, <4268, 4180, 4210>,
			<4267, 4239, 4240>, <4267, 4240, 4268>, <4210, 4180, 4179>, <4210, 4179, 4209>,
			<4429, 4153, 4167>, <4429, 4167, 4406>, <4152, 4428, 4406>, <4152, 4406, 4167>,
			<4239, 4267, 4323>, <4239, 4323, 4295>, <4238, 4266, 4322>, <4238, 4322, 4294>,
			<4139, 4179, 4209>, <4139, 4209, 4153>, <4139, 4153, 4125>, <4139, 4125, 4111>,
			<4138, 4178, 4208>, <4138, 4208, 4152>, <4138, 4152, 4124>, <4138, 4124, 4110>,
			<4414, 4350, 4380>, <4414, 4380, 4428>, <4414, 4428, 4458>, <4414, 4458, 4444>,
			<4415, 4351, 4381>, <4415, 4381, 4429>, <4415, 4429, 4459>, <4415, 4459, 4445>,
			<4445, 4459, 4487>, <4445, 4487, 4473>, <4444, 4458, 4486>, <4444, 4486, 4472>,
			<4110, 4124, 4096>, <4110, 4096, 4082>, <4111, 4125, 4097>, <4111, 4097, 4083>,
			<5076, 5018, 5017>, <5076, 5017, 5075>, <5017, 4987, 5047>, <5017, 5047, 5075>,
			<5018, 4988, 4987>, <5018, 4987, 5017>, <5075, 5047, 5048>, <5075, 5048, 5076>,
			<5190, 5132, 5131>, <5190, 5131, 5189>, <5131, 5103, 5159>, <5131, 5159, 5189>,
			<5132, 5104, 5103>, <5132, 5103, 5131>, <5189, 5159, 5160>, <5189, 5160, 5190>,
			<5133, 5191, 5192>, <5133, 5192, 5134>, <5192, 5162, 5106>, <5192, 5106, 5134>,
			<5191, 5161, 5162>, <5191, 5162, 5192>, <5134, 5106, 5105>, <5134, 5105, 5133>,
			<5019, 5077, 5078>, <5019, 5078, 5020>, <5078, 5050, 4990>, <5078, 4990, 5020>,
			<5077, 5049, 5050>, <5077, 5050, 5078>, <5020, 4990, 4989>, <5020, 4989, 5019>,
			<5239, 4963, 4977>, <5239, 4977, 5216>, <4962, 5238, 5216>, <4962, 5216, 4977>,
			<5049, 5077, 5133>, <5049, 5133, 5105>, <5048, 5076, 5132>, <5048, 5132, 5104>,
			<4949, 4989, 5019>, <4949, 5019, 4963>, <4949, 4963, 4935>, <4949, 4935, 4921>,
			<4948, 4988, 5018>, <4948, 5018, 4962>, <4948, 4962, 4934>, <4948, 4934, 4920>,
			<5224, 5160, 5190>, <5224, 5190, 5238>, <5224, 5238, 5268>, <5224, 5268, 5254>,
			<5225, 5161, 5191>, <5225, 5191, 5239>, <5225, 5239, 5269>, <5225, 5269, 5255>,
			<5255, 5269, 5297>, <5255, 5297, 5283>, <5254, 5268, 5296>, <5254, 5296, 5282>,
			<4920, 4934, 4906>, <4920, 4906, 4892>, <4921, 4935, 4907>, <4921, 4907, 4893>,
			<946, 888, 887>, <946, 887, 945>, <887, 857, 917>, <887, 917, 945>,
			<888, 858, 857>, <888, 857, 887>, <945, 917, 918>, <945, 918, 946>,
			<1060, 1002, 1001>, <1060, 1001, 1059>, <1001, 973, 1029>, <1001, 1029, 1059>,
			<1002, 974, 973>, <1002, 973, 1001>, <1059, 1029, 1030>, <1059, 1030, 1060>,
			<1003, 1061, 1062>, <1003, 1062, 1004>, <1062, 1032, 976>, <1062, 976, 1004>,
			<1061, 1031, 1032>, <1061, 1032, 1062>, <1004, 976, 975>, <1004, 975, 1003>,
			<889, 947, 948>, <889, 948, 890>, <948, 920, 860>, <948, 860, 890>,
			<947, 919, 920>, <947, 920, 948>, <890, 860, 859>, <890, 859, 889>,
			<1107, 831, 844>, <1107, 844, 1083>, <830, 1106, 1083>, <830, 1083, 844>,
			<919, 947, 1003>, <919, 1003, 975>, <918, 946, 1002>, <918, 1002, 974>,
			<817, 859, 889>, <817, 889, 831>, <817, 831, 803>, <817, 803, 789>,
			<816, 858, 888>, <816, 888, 830>, <816, 830, 802>, <816, 802, 788>,
			<1092, 1030, 1060>, <1092, 1060, 1106>, <1092, 1106, 1136>, <1092, 1136, 1122>,
			<1093, 1031, 1061>, <1093, 1061, 1107>, <1093, 1107, 1137>, <1093, 1137, 1123>,
			<1123, 1137, 1165>, <1123, 1165, 1151>, <1122, 1136, 1164>, <1122, 1164, 1150>,
			<788, 802, 774>, <788, 774, 760>, <789, 803, 775>, <789, 775, 761>,
			<1756, 1698, 1697>, <1756, 1697, 1755>, <1697, 1667, 1727>, <1697, 1727, 1755>,
			<1698, 1668, 1667>, <1698, 1667, 1697>, <1755, 1727, 1728>, <1755, 1728, 1756>,
			<1870, 1812, 1811>, <1870, 1811, 1869>, <1811, 1783, 1839>, <1811, 1839, 1869>,
			<1812, 1784, 1783>, <1812, 1783, 1811>, <1869, 1839, 1840>, <1869, 1840, 1870>,
			<1813, 1871, 1872>, <1813, 1872, 1814>, <1872, 1842, 1786>, <1872, 1786, 1814>,
			<1871, 1841, 1842>, <1871, 1842, 1872>, <1814, 1786, 1785>, <1814, 1785, 1813>,
			<1699, 1757, 1758>, <1699, 1758, 1700>, <1758, 1730, 1670>, <1758, 1670, 1700>,
			<1757, 1729, 1730>, <1757, 1730, 1758>, <1700, 1670, 1669>, <1700, 1669, 1699>,
			<1917, 1641, 1654>, <1917, 1654, 1893>, <1640, 1916, 1893>, <1640, 1893, 1654>,
			<1729, 1757, 1813>, <1729, 1813, 1785>, <1728, 1756, 1812>, <1728, 1812, 1784>,
			<1627, 1669, 1699>, <1627, 1699, 1641>, <1627, 1641, 1613>, <1627, 1613, 1599>,
			<1626, 1668, 1698>, <1626, 1698, 1640>, <1626, 1640, 1612>, <1626, 1612, 1598>,
			<1902, 1840, 1870>, <1902, 1870, 1916>, <1902, 1916, 1946>, <1902, 1946, 1932>,
			<1903, 1841, 1871>, <1903, 1871, 1917>, <1903, 1917, 1947>, <1903, 1947, 1933>,
			<1933, 1947, 1975>, <1933, 1975, 1961>, <1932, 1946, 1974>, <1932, 1974, 1960>,
			<1598, 1612, 1584>, <1598, 1584, 1570>, <1599, 1613, 1585>, <1599, 1585, 1571>,
			<2566, 2508, 2507>, <2566, 2507, 2565>, <2507, 2477, 2537>, <2507, 2537, 2565>,
			<2508, 2478, 2477>, <2508, 2477, 2507>, <2565, 2537, 2538>, <2565, 2538, 2566>,
			<2680, 2622, 2621>, <2680, 2621, 2679>, <2621, 2593, 2649>, <2621, 2649, 2679>,
			<2622, 2594, 2593>, <2622, 2593, 2621>, <2679, 2649, 2650>, <2679, 2650, 2680>,
			<2623, 2681, 2682>, <2623, 2682, 2624>, <2682, 2652, 2596>, <2682, 2596, 2624>,
			<2681, 2651, 2652>, <2681, 2652, 2682>, <2624, 2596, 2595>, <2624, 2595, 2623>,
			<2509, 2567, 2568>, <2509, 2568, 2510>, <2568, 2540, 2480>, <2568, 2480, 2510>,
			<2567, 2539, 2540>, <2567, 2540, 2568>, <2510, 2480, 2479>, <2510, 2479, 2509>,
			<2727, 2451, 2464>, <2727, 2464, 2703>, <2450, 2726, 2703>, <2450, 2703, 2464>,
			<2539, 2567, 2623>, <2539, 2623, 2595>, <2538, 2566, 2622>, <2538, 2622, 2594>,
			<2437, 2479, 2509>, <2437, 2509, 2451>, <2437, 2451, 2423>, <2437, 2423, 2409>,
			<2436, 2478, 2508>, <2436, 2508, 2450>, <2436, 2450, 2422>, <2436, 2422, 2408>,
			<2712, 2650, 2680>, <2712, 2680, 2726>, <2712, 2726, 2756>, <2712, 2756, 2742>,
			<2713, 2651, 2681>, <2713, 2681, 2727>, <2713, 2727, 2757>, <2713, 2757, 2743>,
			<2743, 2757, 2785>, <2743, 2785, 2771>, <2742, 2756, 2784>, <2742, 2784, 2770>,
			<2408, 2422, 2394>, <2408, 2394, 2380>, <2409, 2423, 2395>, <2409, 2395, 2381>,
			<3460, 3402, 3401>, <3460, 3401, 3459>, <3401, 3371, 3431>, <3401, 3431, 3459>,
			<3402, 3372, 3371>, <3402, 3371, 3401>, <3459, 3431, 3432>, <3459, 3432, 3460>,
			<3574, 3516, 3515>, <3574, 3515, 3573>, <3515, 3487, 3543>, <3515, 3543, 3573>,
			<3516, 3488, 3487>, <3516, 3487, 3515>, <3573, 3543, 3544>, <3573, 3544, 3574>,
			<3517, 3575, 3576>, <3517, 3576, 3518>, <3576, 3546, 3490>, <3576, 3490, 3518>,
			<3575, 3545, 3546>, <3575, 3546, 3576>, <3518, 3490, 3489>, <3518, 3489, 3517>,
			<3403, 3461, 3462>, <3403, 3462, 3404>, <3462, 3434, 3374>, <3462, 3374, 3404>,
			<3461, 3433, 3434>, <3461, 3434, 3462>, <3404, 3374, 3373>, <3404, 3373, 3403>,
			<3621, 3345, 3358>, <3621, 3358, 3597>, <3344, 3620, 3597>, <3344, 3597, 3358>,
			<3433, 3461, 3517>, <3433, 3517, 3489>, <3432, 3460, 3516>, <3432, 3516, 3488>,
			<3331, 3373, 3403>, <3331, 3403, 3345>, <3331, 3345, 3317>, <3331, 3317, 3303>,
			<3330, 3372, 3402>, <3330, 3402, 3344>, <3330, 3344, 3316>, <3330, 3316, 3302>,
			<3606, 3544, 3574>, <3606, 3574, 3620>, <3606, 3620, 3650>, <3606, 3650, 3636>,
			<3607, 3545, 3575>, <3607, 3575, 3621>, <3607, 3621, 3651>, <3607, 3651, 3637>,
			<3637, 3651, 3679>, <3637, 3679, 3665>, <3636, 3650, 3678>, <3636, 3678, 3664>,
			<3302, 3316, 3288>, <3302, 3288, 3274>, <3303, 3317, 3289>, <3303, 3289, 3275>,
			<4270, 4212, 4211>, <4270, 4211, 4269>, <4211, 4181, 4241>, <4211, 4241, 4269>,
			<4212, 4182, 4181>, <4212, 4181, 4211>, <4269, 4241, 4242>, <4269, 4242, 4270>,
			<4384, 4326, 4325>, <4384, 4325, 4383>, <4325, 4297, 4353>, <4325, 4353, 4383>,
			<4326, 4298, 4297>, <4326, 4297, 4325>, <4383, 4353, 4354>, <4383, 4354, 4384>,
			<4327, 4385, 4386>, <4327, 4386, 4328>, <4386, 4356, 4300>, <4386, 4300, 4328>,
			<4385, 4355, 4356>, <4385, 4356, 4386>, <4328, 4300, 4299>, <4328, 4299, 4327>,
			<4213, 4271, 4272>, <4213, 4272, 4214>, <4272, 4244, 4184>, <4272, 4184, 4214>,
			<4271, 4243, 4244>, <4271, 4244, 4272>, <4214, 4184, 4183>, <4214, 4183, 4213>,
			<4431, 4155, 4168>, <4431, 4168, 4407>, <4154, 4430, 4407>, <4154, 4407, 4168>,
			<4243, 4271, 4327>, <4243, 4327, 4299>, <4242, 4270, 4326>, <4242, 4326, 4298>,
			<4141, 4183, 4213>, <4141, 4213, 4155>, <4141, 4155, 4127>, <4141, 4127, 4113>,
			<4140, 4182, 4212>, <4140, 4212, 4154>, <4140, 4154, 4126>, <4140, 4126, 4112>,
			<4416, 4354, 4384>, <4416, 4384, 4430>, <4416, 4430, 4460>, <4416, 4460, 4446>,
			<4417, 4355, 4385>, <4417, 4385, 4431>, <4417, 4431, 4461>, <4417, 4461, 4447>,
			<4447, 4461, 4489>, <4447, 4489, 4475>, <4446, 4460, 4488>, <4446, 4488, 4474>,
			<4112, 4126, 4098>, <4112, 4098, 4084>, <4113, 4127, 4099>, <4113, 4099, 4085>,
			<5080, 5022, 5021>, <5080, 5021, 5079>, <5021, 4991, 5051>, <5021, 5051, 5079>,
			<5022, 4992, 4991>, <5022, 4991, 5021>, <5079, 5051, 5052>, <5079, 5052, 5080>,
			<5194, 5136, 5135>, <5194, 5135, 5193>, <5135, 5107, 5163>, <5135, 5163, 5193>,
			<5136, 5108, 5107>, <5136, 5107, 5135>, <5193, 5163, 5164>, <5193, 5164, 5194>,
			<5137, 5195, 5196>, <5137, 5196, 5138>, <5196, 5166, 5110>, <5196, 5110, 5138>,
			<5195, 5165, 5166>, <5195, 5166, 5196>, <5138, 5110, 5109>, <5138, 5109, 5137>,
			<5023, 5081, 5082>, <5023, 5082, 5024>, <5082, 5054, 4994>, <5082, 4994, 5024>,
			<5081, 5053, 5054>, <5081, 5054, 5082>, <5024, 4994, 4993>, <5024, 4993, 5023>,
			<5241, 4965, 4978>, <5241, 4978, 5217>, <4964, 5240, 5217>, <4964, 5217, 4978>,
			<5053, 5081, 5137>, <5053, 5137, 5109>, <5052, 5080, 5136>, <5052, 5136, 5108>,
			<4951, 4993, 5023>, <4951, 5023, 4965>, <4951, 4965, 4937>, <4951, 4937, 4923>,
			<4950, 4992, 5022>, <4950, 5022, 4964>, <4950, 4964, 4936>, <4950, 4936, 4922>,
			<5226, 5164, 5194>, <5226, 5194, 5240>, <5226, 5240, 5270>, <5226, 5270, 5256>,
			<5227, 5165, 5195>, <5227, 5195, 5241>, <5227, 5241, 5271>, <5227, 5271, 5257>,
			<5257, 5271, 5299>, <5257, 5299, 5285>, <5256, 5270, 5298>, <5256, 5298, 5284>,
			<4922, 4936, 4908>, <4922, 4908, 4894>, <4923, 4937, 4909>, <4923, 4909, 4895>,
			<950, 892, 891>, <950, 891, 949>, <891, 861, 921>, <891, 921, 949>,
			<892, 862, 861>, <892, 861, 891>, <949, 921, 922>, <949, 922, 950>,
			<1064, 1006, 1005>, <1064, 1005, 1063>, <1005, 977, 1033>, <1005, 1033, 1063>,
			<1006, 978, 977>, <1006, 977, 1005>, <1063, 1033, 1034>, <1063, 1034, 1064>,
			<1007, 1066, 1068>, <1007, 1068, 1008>, <1068, 1038, 980>, <1068, 980, 1008>,
			<1066, 1036, 1038>, <1066, 1038, 1068>, <1008, 980, 979>, <1008, 979, 1007>,
			<894, 951, 952>, <894, 952, 896>, <952, 924, 866>, <952, 866, 896>,
			<951, 923, 924>, <951, 924, 952>, <896, 866, 864>, <896, 864, 894>,
			<1110, 834, 845>, <1110, 845, 1084>, <832, 1108, 1084>, <832, 1084, 845>,
			<923, 951, 1007>, <923, 1007, 979>, <922, 950, 1006>, <922, 1006, 978>,
			<819, 865, 895>, <819, 895, 835>, <819, 835, 805>, <819, 805, 791>,
			<818, 863, 893>, <818, 893, 833>, <818, 833, 804>, <818, 804, 790>,
			<1094, 1035, 1065>, <1094, 1065, 1109>, <1094, 1109, 1138>, <1094, 1138, 1124>,
			<1095, 1037, 1067>, <1095, 1067, 1111>, <1095, 1111, 1139>, <1095, 1139, 1125>,
			<1125, 1139, 1167>, <1125, 1167, 1153>, <1124, 1138, 1166>, <1124, 1166, 1152>,
			<790, 804, 776>, <790, 776, 762>, <791, 805, 777>, <791, 777, 763>,
			<1760, 1702, 1701>, <1760, 1701, 1759>, <1701, 1671, 1731>, <1701, 1731, 1759>,
			<1702, 1672, 1671>, <1702, 1671, 1701>, <1759, 1731, 1732>, <1759, 1732, 1760>,
			<1874, 1816, 1815>, <1874, 1815, 1873>, <1815, 1787, 1843>, <1815, 1843, 1873>,
			<1816, 1788, 1787>, <1816, 1787, 1815>, <1873, 1843, 1844>, <1873, 1844, 1874>,
			<1817, 1876, 1878>, <1817, 1878, 1818>, <1878, 1848, 1790>, <1878, 1790, 1818>,
			<1876, 1846, 1848>, <1876, 1848, 1878>, <1818, 1790, 1789>, <1818, 1789, 1817>,
			<1704, 1761, 1762>, <1704, 1762, 1706>, <1762, 1734, 1676>, <1762, 1676, 1706>,
			<1761, 1733, 1734>, <1761, 1734, 1762>, <1706, 1676, 1674>, <1706, 1674, 1704>,
			<1920, 1644, 1655>, <1920, 1655, 1894>, <1642, 1918, 1894>, <1642, 1894, 1655>,
			<1733, 1761, 1817>, <1733, 1817, 1789>, <1732, 1760, 1816>, <1732, 1816, 1788>,
			<1629, 1675, 1705>, <1629, 1705, 1645>, <1629, 1645, 1615>, <1629, 1615, 1601>,
			<1628, 1673, 1703>, <1628, 1703, 1643>, <1628, 1643, 1614>, <1628, 1614, 1600>,
			<1904, 1845, 1875>, <1904, 1875, 1919>, <1904, 1919, 1948>, <1904, 1948, 1934>,
			<1905, 1847, 1877>, <1905, 1877, 1921>, <1905, 1921, 1949>, <1905, 1949, 1935>,
			<1935, 1949, 1977>, <1935, 1977, 1963>, <1934, 1948, 1976>, <1934, 1976, 1962>,
			<1600, 1614, 1586>, <1600, 1586, 1572>, <1601, 1615, 1587>, <1601, 1587, 1573>,
			<2570, 2512, 2511>, <2570, 2511, 2569>, <2511, 2481, 2541>, <2511, 2541, 2569>,
			<2512, 2482, 2481>, <2512, 2481, 2511>, <2569, 2541, 2542>, <2569, 2542, 2570>,
			<2684, 2626, 2625>, <2684, 2625, 2683>, <2625, 2597, 2653>, <2625, 2653, 2683>,
			<2626, 2598, 2597>, <2626, 2597, 2625>, <2683, 2653, 2654>, <2683, 2654, 2684>,
			<2627, 2686, 2688>, <2627, 2688, 2628>, <2688, 2658, 2600>, <2688, 2600, 2628>,
			<2686, 2656, 2658>, <2686, 2658, 2688>, <2628, 2600, 2599>, <2628, 2599, 2627>,
			<2514, 2571, 2572>, <2514, 2572, 2516>, <2572, 2544, 2486>, <2572, 2486, 2516>,
			<2571, 2543, 2544>, <2571, 2544, 2572>, <2516, 2486, 2484>, <2516, 2484, 2514>,
			<2730, 2454, 2465>, <2730, 2465, 2704>, <2452, 2728, 2704>, <2452, 2704, 2465>,
			<2543, 2571, 2627>, <2543, 2627, 2599>, <2542, 2570, 2626>, <2542, 2626, 2598>,
			<2439, 2485, 2515>, <2439, 2515, 2455>, <2439, 2455, 2425>, <2439, 2425, 2411>,
			<2438, 2483, 2513>, <2438, 2513, 2453>, <2438, 2453, 2424>, <2438, 2424, 2410>,
			<2714, 2655, 2685>, <2714, 2685, 2729>, <2714, 2729, 2758>, <2714, 2758, 2744>,
			<2715, 2657, 2687>, <2715, 2687, 2731>, <2715, 2731, 2759>, <2715, 2759, 2745>,
			<2745, 2759, 2787>, <2745, 2787, 2773>, <2744, 2758, 2786>, <2744, 2786, 2772>,
			<2410, 2424, 2396>, <2410, 2396, 2382>, <2411, 2425, 2397>, <2411, 2397, 2383>,
			<3464, 3406, 3405>, <3464, 3405, 3463>, <3405, 3375, 3435>, <3405, 3435, 3463>,
			<3406, 3376, 3375>, <3406, 3375, 3405>, <3463, 3435, 3436>, <3463, 3436, 3464>,
			<3578, 3520, 3519>, <3578, 3519, 3577>, <3519, 3491, 3547>, <3519, 3547, 3577>,
			<3520, 3492, 3491>, <3520, 3491, 3519>, <3577, 3547, 3548>, <3577, 3548, 3578>,
			<3521, 3580, 3582>, <3521, 3582, 3522>, <3582, 3552, 3494>, <3582, 3494, 3522>,
			<3580, 3550, 3552>, <3580, 3552, 3582>, <3522, 3494, 3493>, <3522, 3493, 3521>,
			<3408, 3465, 3466>, <3408, 3466, 3410>, <3466, 3438, 3380>, <3466, 3380, 3410>,
			<3465, 3437, 3438>, <3465, 3438, 3466>, <3410, 3380, 3378>, <3410, 3378, 3408>,
			<3624, 3348, 3359>, <3624, 3359, 3598>, <3346, 3622, 3598>, <3346, 3598, 3359>,
			<3437, 3465, 3521>, <3437, 3521, 3493>, <3436, 3464, 3520>, <3436, 3520, 3492>,
			<3333, 3379, 3409>, <3333, 3409, 3349>, <3333, 3349, 3319>, <3333, 3319, 3305>,
			<3332, 3377, 3407>, <3332, 3407, 3347>, <3332, 3347, 3318>, <3332, 3318, 3304>,
			<3608, 3549, 3579>, <3608, 3579, 3623>, <3608, 3623, 3652>, <3608, 3652, 3638>,
			<3609, 3551, 3581>, <3609, 3581, 3625>, <3609, 3625, 3653>, <3609, 3653, 3639>,
			<3639, 3653, 3681>, <3639, 3681, 3667>, <3638, 3652, 3680>, <3638, 3680, 3666>,
			<3304, 3318, 3290>, <3304, 3290, 3276>, <3305, 3319, 3291>, <3305, 3291, 3277>,
			<4274, 4216, 4215>, <4274, 4215, 4273>, <4215, 4185, 4245>, <4215, 4245, 4273>,
			<4216, 4186, 4185>, <4216, 4185, 4215>, <4273, 4245, 4246>, <4273, 4246, 4274>,
			<4388, 4330, 4329>, <4388, 4329, 4387>, <4329, 4301, 4357>, <4329, 4357, 4387>,
			<4330, 4302, 4301>, <4330, 4301, 4329>, <4387, 4357, 4358>, <4387, 4358, 4388>,
			<4331, 4390, 4392>, <4331, 4392, 4332>, <4392, 4362, 4304>, <4392, 4304, 4332>,
			<4390, 4360, 4362>, <4390, 4362, 4392>, <4332, 4304, 4303>, <4332, 4303, 4331>,
			<4218, 4275, 4276>, <4218, 4276, 4220>, <4276, 4248, 4190>, <4276, 4190, 4220>,
			<4275, 4247, 4248>, <4275, 4248, 4276>, <4220, 4190, 4188>, <4220, 4188, 4218>,
			<4434, 4158, 4169>, <4434, 4169, 4408>, <4156, 4432, 4408>, <4156, 4408, 4169>,
			<4247, 4275, 4331>, <4247, 4331, 4303>, <4246, 4274, 4330>, <4246, 4330, 4302>,
			<4143, 4189, 4219>, <4143, 4219, 4159>, <4143, 4159, 4129>, <4143, 4129, 4115>,
			<4142, 4187, 4217>, <4142, 4217, 4157>, <4142, 4157, 4128>, <4142, 4128, 4114>,
			<4418, 4359, 4389>, <4418, 4389, 4433>, <4418, 4433, 4462>, <4418, 4462, 4448>,
			<4419, 4361, 4391>, <4419, 4391, 4435>, <4419, 4435, 4463>, <4419, 4463, 4449>,
			<4449, 4463, 4491>, <4449, 4491, 4477>, <4448, 4462, 4490>, <4448, 4490, 4476>,
			<4114, 4128, 4100>, <4114, 4100, 4086>, <4115, 4129, 4101>, <4115, 4101, 4087>,
			<5084, 5026, 5025>, <5084, 5025, 5083>, <5025, 4995, 5055>, <5025, 5055, 5083>,
			<5026, 4996, 4995>, <5026, 4995, 5025>, <5083, 5055, 5056>, <5083, 5056, 5084>,
			<5198, 5140, 5139>, <5198, 5139, 5197>, <5139, 5111, 5167>, <5139, 5167, 5197>,
			<5140, 5112, 5111>, <5140, 5111, 5139>, <5197, 5167, 5168>, <5197, 5168, 5198>,
			<5141, 5200, 5202>, <5141, 5202, 5142>, <5202, 5172, 5114>, <5202, 5114, 5142>,
			<5200, 5170, 5172>, <5200, 5172, 5202>, <5142, 5114, 5113>, <5142, 5113, 5141>,
			<5028, 5085, 5086>, <5028, 5086, 5030>, <5086, 5058, 5000>, <5086, 5000, 5030>,
			<5085, 5057, 5058>, <5085, 5058, 5086>, <5030, 5000, 4998>, <5030, 4998, 5028>,
			<5244, 4968, 4979>, <5244, 4979, 5218>, <4966, 5242, 5218>, <4966, 5218, 4979>,
			<5057, 5085, 5141>, <5057, 5141, 5113>, <5056, 5084, 5140>, <5056, 5140, 5112>,
			<4953, 4999, 5029>, <4953, 5029, 4969>, <4953, 4969, 4939>, <4953, 4939, 4925>,
			<4952, 4997, 5027>, <4952, 5027, 4967>, <4952, 4967, 4938>, <4952, 4938, 4924>,
			<5228, 5169, 5199>, <5228, 5199, 5243>, <5228, 5243, 5272>, <5228, 5272, 5258>,
			<5229, 5171, 5201>, <5229, 5201, 5245>, <5229, 5245, 5273>, <5229, 5273, 5259>,
			<5259, 5273, 5301>, <5259, 5301, 5287>, <5258, 5272, 5300>, <5258, 5300, 5286>,
			<4924, 4938, 4910>, <4924, 4910, 4896>, <4925, 4939, 4911>, <4925, 4911, 4897>,
			<954, 898, 897>, <954, 897, 953>, <897, 867, 925>, <897, 925, 953>,
			<898, 868, 867>, <898, 867, 897>, <953, 925, 926>, <953, 926, 954>,
			<1070, 1010, 1009>, <1070, 1009, 1069>, <1009, 981, 1039>, <1009, 1039, 1069>,
			<1010, 982, 981>, <1010, 981, 1009>, <1069, 1039, 1040>, <1069, 1040, 1070>,
			<1011, 1071, 1072>, <1011, 1072, 1012>, <1072, 1042, 984>, <1072, 984, 1012>,
			<1071, 1041, 1042>, <1071, 1042, 1072>, <1012, 984, 983>, <1012, 983, 1011>,
			<899, 955, 956>, <899, 956, 900>, <956, 928, 870>, <956, 870, 900>,
			<955, 927, 928>, <955, 928, 956>, <900, 870, 869>, <900, 869, 899>,
			<1113, 837, 846>, <1113, 846, 1085>, <836, 1112, 1085>, <836, 1085, 846>,
			<927, 955, 1011>, <927, 1011, 983>, <926, 954, 1010>, <926, 1010, 982>,
			<821, 869, 899>, <821, 899, 837>, <821, 837, 807>, <821, 807, 793>,
			<820, 868, 898>, <820, 898, 836>, <820, 836, 806>, <820, 806, 792>,
			<1096, 1040, 1070>, <1096, 1070, 1112>, <1096, 1112, 1140>, <1096, 1140, 1126>,
			<1097, 1041, 1071>, <1097, 1071, 1113>, <1097, 1113, 1141>, <1097, 1141, 1127>,
			<1127, 1141, 1169>, <1127, 1169, 1155>, <1126, 1140, 1168>, <1126, 1168, 1154>,
			<792, 806, 778>, <792, 778, 764>, <793, 807, 779>, <793, 779, 765>,
			<1764, 1708, 1707>, <1764, 1707, 1763>, <1707, 1677, 1735>, <1707, 1735, 1763>,
			<1708, 1678, 1677>, <1708, 1677, 1707>, <1763, 1735, 1736>, <1763, 1736, 1764>,
			<1880, 1820, 1819>, <1880, 1819, 1879>, <1819, 1791, 1849>, <1819, 1849, 1879>,
			<1820, 1792, 1791>, <1820, 1791, 1819>, <1879, 1849, 1850>, <1879, 1850, 1880>,
			<1821, 1881, 1882>, <1821, 1882, 1822>, <1882, 1852, 1794>, <1882, 1794, 1822>,
			<1881, 1851, 1852>, <1881, 1852, 1882>, <1822, 1794, 1793>, <1822, 1793, 1821>,
			<1709, 1765, 1766>, <1709, 1766, 1710>, <1766, 1738, 1680>, <1766, 1680, 1710>,
			<1765, 1737, 1738>, <1765, 1738, 1766>, <1710, 1680, 1679>, <1710, 1679, 1709>,
			<1923, 1647, 1656>, <1923, 1656, 1895>, <1646, 1922, 1895>, <1646, 1895, 1656>,
			<1737, 1765, 1821>, <1737, 1821, 1793>, <1736, 1764, 1820>, <1736, 1820, 1792>,
			<1631, 1679, 1709>, <1631, 1709, 1647>, <1631, 1647, 1617>, <1631, 1617, 1603>,
			<1630, 1678, 1708>, <1630, 1708, 1646>, <1630, 1646, 1616>, <1630, 1616, 1602>,
			<1906, 1850, 1880>, <1906, 1880, 1922>, <1906, 1922, 1950>, <1906, 1950, 1936>,
			<1907, 1851, 1881>, <1907, 1881, 1923>, <1907, 1923, 1951>, <1907, 1951, 1937>,
			<1937, 1951, 1979>, <1937, 1979, 1965>, <1936, 1950, 1978>, <1936, 1978, 1964>,
			<1602, 1616, 1588>, <1602, 1588, 1574>, <1603, 1617, 1589>, <1603, 1589, 1575>,
			<2574, 2518, 2517>, <2574, 2517, 2573>, <2517, 2487, 2545>, <2517, 2545, 2573>,
			<2518, 2488, 2487>, <2518, 2487, 2517>, <2573, 2545, 2546>, <2573, 2546, 2574>,
			<2690, 2630, 2629>, <2690, 2629, 2689>, <2629, 2601, 2659>, <2629, 2659, 2689>,
			<2630, 2602, 2601>, <2630, 2601, 2629>, <2689, 2659, 2660>, <2689, 2660, 2690>,
			<2631, 2691, 2692>, <2631, 2692, 2632>, <2692, 2662, 2604>, <2692, 2604, 2632>,
			<2691, 2661, 2662>, <2691, 2662, 2692>, <2632, 2604, 2603>, <2632, 2603, 2631>,
			<2519, 2575, 2576>, <2519, 2576, 2520>, <2576, 2548, 2490>, <2576, 2490, 2520>,
			<2575, 2547, 2548>, <2575, 2548, 2576>, <2520, 2490, 2489>, <2520, 2489, 2519>,
			<2733, 2457, 2466>, <2733, 2466, 2705>, <2456, 2732, 2705>, <2456, 2705, 2466>,
			<2547, 2575, 2631>, <2547, 2631, 2603>, <2546, 2574, 2630>, <2546, 2630, 2602>,
			<2441, 2489, 2519>, <2441, 2519, 2457>, <2441, 2457, 2427>, <2441, 2427, 2413>,
			<2440, 2488, 2518>, <2440, 2518, 2456>, <2440, 2456, 2426>, <2440, 2426, 2412>,
			<2716, 2660, 2690>, <2716, 2690, 2732>, <2716, 2732, 2760>, <2716, 2760, 2746>,
			<2717, 2661, 2691>, <2717, 2691, 2733>, <2717, 2733, 2761>, <2717, 2761, 2747>,
			<2747, 2761, 2789>, <2747, 2789, 2775>, <2746, 2760, 2788>, <2746, 2788, 2774>,
			<2412, 2426, 2398>, <2412, 2398, 2384>, <2413, 2427, 2399>, <2413, 2399, 2385>,
			<3468, 3412, 3411>, <3468, 3411, 3467>, <3411, 3381, 3439>, <3411, 3439, 3467>,
			<3412, 3382, 3381>, <3412, 3381, 3411>, <3467, 3439, 3440>, <3467, 3440, 3468>,
			<3584, 3524, 3523>, <3584, 3523, 3583>, <3523, 3495, 3553>, <3523, 3553, 3583>,
			<3524, 3496, 3495>, <3524, 3495, 3523>, <3583, 3553, 3554>, <3583, 3554, 3584>,
			<3525, 3585, 3586>, <3525, 3586, 3526>, <3586, 3556, 3498>, <3586, 3498, 3526>,
			<3585, 3555, 3556>, <3585, 3556, 3586>, <3526, 3498, 3497>, <3526, 3497, 3525>,
			<3413, 3469, 3470>, <3413, 3470, 3414>, <3470, 3442, 3384>, <3470, 3384, 3414>,
			<3469, 3441, 3442>, <3469, 3442, 3470>, <3414, 3384, 3383>, <3414, 3383, 3413>,
			<3627, 3351, 3360>, <3627, 3360, 3599>, <3350, 3626, 3599>, <3350, 3599, 3360>,
			<3441, 3469, 3525>, <3441, 3525, 3497>, <3440, 3468, 3524>, <3440, 3524, 3496>,
			<3335, 3383, 3413>, <3335, 3413, 3351>, <3335, 3351, 3321>, <3335, 3321, 3307>,
			<3334, 3382, 3412>, <3334, 3412, 3350>, <3334, 3350, 3320>, <3334, 3320, 3306>,
			<3610, 3554, 3584>, <3610, 3584, 3626>, <3610, 3626, 3654>, <3610, 3654, 3640>,
			<3611, 3555, 3585>, <3611, 3585, 3627>, <3611, 3627, 3655>, <3611, 3655, 3641>,
			<3641, 3655, 3683>, <3641, 3683, 3669>, <3640, 3654, 3682>, <3640, 3682, 3668>,
			<3306, 3320, 3292>, <3306, 3292, 3278>, <3307, 3321, 3293>, <3307, 3293, 3279>,
			<4278, 4222, 4221>, <4278, 4221, 4277>, <4221, 4191, 4249>, <4221, 4249, 4277>,
			<4222, 4192, 4191>, <4222, 4191, 4221>, <4277, 4249, 4250>, <4277, 4250, 4278>,
			<4394, 4334, 4333>, <4394, 4333, 4393>, <4333, 4305, 4363>, <4333, 4363, 4393>,
			<4334, 4306, 4305>, <4334, 4305, 4333>, <4393, 4363, 4364>, <4393, 4364, 4394>,
			<4335, 4395, 4396>, <4335, 4396, 4336>, <4396, 4366, 4308>, <4396, 4308, 4336>,
			<4395, 4365, 4366>, <4395, 4366, 4396>, <4336, 4308, 4307>, <4336, 4307, 4335>,
			<4223, 4279, 4280>, <4223, 4280, 4224>, <4280, 4252, 4194>, <4280, 4194, 4224>,
			<4279, 4251, 4252>, <4279, 4252, 4280>, <4224, 4194, 4193>, <4224, 4193, 4223>,
			<4437, 4161, 4170>, <4437, 4170, 4409>, <4160, 4436, 4409>, <4160, 4409, 4170>,
			<4251, 4279, 4335>, <4251, 4335, 4307>, <4250, 4278, 4334>, <4250, 4334, 4306>,
			<4145, 4193, 4223>, <4145, 4223, 4161>, <4145, 4161, 4131>, <4145, 4131, 4117>,
			<4144, 4192, 4222>, <4144, 4222, 4160>, <4144, 4160, 4130>, <4144, 4130, 4116>,
			<4420, 4364, 4394>, <4420, 4394, 4436>, <4420, 4436, 4464>, <4420, 4464, 4450>,
			<4421, 4365, 4395>, <4421, 4395, 4437>, <4421, 4437, 4465>, <4421, 4465, 4451>,
			<4451, 4465, 4493>, <4451, 4493, 4479>, <4450, 4464, 4492>, <4450, 4492, 4478>,
			<4116, 4130, 4102>, <4116, 4102, 4088>, <4117, 4131, 4103>, <4117, 4103, 4089>,
			<5088, 5032, 5031>, <5088, 5031, 5087>, <5031, 5001, 5059>, <5031, 5059, 5087>,
			<5032, 5002, 5001>, <5032, 5001, 5031>, <5087, 5059, 5060>, <5087, 5060, 5088>,
			<5204, 5144, 5143>, <5204, 5143, 5203>, <5143, 5115, 5173>, <5143, 5173, 5203>,
			<5144, 5116, 5115>, <5144, 5115, 5143>, <5203, 5173, 5174>, <5203, 5174, 5204>,
			<5145, 5205, 5206>, <5145, 5206, 5146>, <5206, 5176, 5118>, <5206, 5118, 5146>,
			<5205, 5175, 5176>, <5205, 5176, 5206>, <5146, 5118, 5117>, <5146, 5117, 5145>,
			<5033, 5089, 5090>, <5033, 5090, 5034>, <5090, 5062, 5004>, <5090, 5004, 5034>,
			<5089, 5061, 5062>, <5089, 5062, 5090>, <5034, 5004, 5003>, <5034, 5003, 5033>,
			<5247, 4971, 4980>, <5247, 4980, 5219>, <4970, 5246, 5219>, <4970, 5219, 4980>,
			<5061, 5089, 5145>, <5061, 5145, 5117>, <5060, 5088, 5144>, <5060, 5144, 5116>,
			<4955, 5003, 5033>, <4955, 5033, 4971>, <4955, 4971, 4941>, <4955, 4941, 4927>,
			<4954, 5002, 5032>, <4954, 5032, 4970>, <4954, 4970, 4940>, <4954, 4940, 4926>,
			<5230, 5174, 5204>, <5230, 5204, 5246>, <5230, 5246, 5274>, <5230, 5274, 5260>,
			<5231, 5175, 5205>, <5231, 5205, 5247>, <5231, 5247, 5275>, <5231, 5275, 5261>,
			<5261, 5275, 5303>, <5261, 5303, 5289>, <5260, 5274, 5302>, <5260, 5302, 5288>,
			<4926, 4940, 4912>, <4926, 4912, 4898>, <4927, 4941, 4913>, <4927, 4913, 4899>,
			<958, 902, 901>, <958, 901, 957>, <901, 871, 929>, <901, 929, 957>,
			<902, 872, 871>, <902, 871, 901>, <957, 929, 930>, <957, 930, 958>,
			<1074, 1014, 1013>, <1074, 1013, 1073>, <1013, 985, 1043>, <1013, 1043, 1073>,
			<1014, 986, 985>, <1014, 985, 1013>, <1073, 1043, 1044>, <1073, 1044, 1074>,
			<1015, 1075, 1076>, <1015, 1076, 1016>, <1076, 1046, 988>, <1076, 988, 1016>,
			<1075, 1045, 1046>, <1075, 1046, 1076>, <1016, 988, 987>, <1016, 987, 1015>,
			<903, 959, 960>, <903, 960, 904>, <960, 932, 874>, <960, 874, 904>,
			<959, 931, 932>, <959, 932, 960>, <904, 874, 873>, <904, 873, 903>,
			<1115, 839, 847>, <1115, 847, 1086>, <838, 1114, 1086>, <838, 1086, 847>,
			<931, 959, 1015>, <931, 1015, 987>, <930, 958, 1014>, <930, 1014, 986>,
			<823, 873, 903>, <823, 903, 839>, <823, 839, 809>, <823, 809, 795>,
			<822, 872, 902>, <822, 902, 838>, <822, 838, 808>, <822, 808, 794>,
			<1098, 1044, 1074>, <1098, 1074, 1114>, <1098, 1114, 1142>, <1098, 1142, 1128>,
			<1099, 1045, 1075>, <1099, 1075, 1115>, <1099, 1115, 1143>, <1099, 1143, 1129>,
			<1129, 1143, 1171>, <1129, 1171, 1157>, <1128, 1142, 1170>, <1128, 1170, 1156>,
			<794, 808, 780>, <794, 780, 766>, <795, 809, 781>, <795, 781, 767>,
			<1768, 1712, 1711>, <1768, 1711, 1767>, <1711, 1681, 1739>, <1711, 1739, 1767>,
			<1712, 1682, 1681>, <1712, 1681, 1711>, <1767, 1739, 1740>, <1767, 1740, 1768>,
			<1884, 1824, 1823>, <1884, 1823, 1883>, <1823, 1795, 1853>, <1823, 1853, 1883>,
			<1824, 1796, 1795>, <1824, 1795, 1823>, <1883, 1853, 1854>, <1883, 1854, 1884>,
			<1825, 1885, 1886>, <1825, 1886, 1826>, <1886, 1856, 1798>, <1886, 1798, 1826>,
			<1885, 1855, 1856>, <1885, 1856, 1886>, <1826, 1798, 1797>, <1826, 1797, 1825>,
			<1713, 1769, 1770>, <1713, 1770, 1714>, <1770, 1742, 1684>, <1770, 1684, 1714>,
			<1769, 1741, 1742>, <1769, 1742, 1770>, <1714, 1684, 1683>, <1714, 1683, 1713>,
			<1925, 1649, 1657>, <1925, 1657, 1896>, <1648, 1924, 1896>, <1648, 1896, 1657>,
			<1741, 1769, 1825>, <1741, 1825, 1797>, <1740, 1768, 1824>, <1740, 1824, 1796>,
			<1633, 1683, 1713>, <1633, 1713, 1649>, <1633, 1649, 1619>, <1633, 1619, 1605>,
			<1632, 1682, 1712>, <1632, 1712, 1648>, <1632, 1648, 1618>, <1632, 1618, 1604>,
			<1908, 1854, 1884>, <1908, 1884, 1924>, <1908, 1924, 1952>, <1908, 1952, 1938>,
			<1909, 1855, 1885>, <1909, 1885, 1925>, <1909, 1925, 1953>, <1909, 1953, 1939>,
			<1939, 1953, 1981>, <1939, 1981, 1967>, <1938, 1952, 1980>, <1938, 1980, 1966>,
			<1604, 1618, 1590>, <1604, 1590, 1576>, <1605, 1619, 1591>, <1605, 1591, 1577>,
			<2578, 2522, 2521>, <2578, 2521, 2577>, <2521, 2491, 2549>, <2521, 2549, 2577>,
			<2522, 2492, 2491>, <2522, 2491, 2521>, <2577, 2549, 2550>, <2577, 2550, 2578>,
			<2694, 2634, 2633>, <2694, 2633, 2693>, <2633, 2605, 2663>, <2633, 2663, 2693>,
			<2634, 2606, 2605>, <2634, 2605, 2633>, <2693, 2663, 2664>, <2693, 2664, 2694>,
			<2635, 2695, 2696>, <2635, 2696, 2636>, <2696, 2666, 2608>, <2696, 2608, 2636>,
			<2695, 2665, 2666>, <2695, 2666, 2696>, <2636, 2608, 2607>, <2636, 2607, 2635>,
			<2523, 2579, 2580>, <2523, 2580, 2524>, <2580, 2552, 2494>, <2580, 2494, 2524>,
			<2579, 2551, 2552>, <2579, 2552, 2580>, <2524, 2494, 2493>, <2524, 2493, 2523>,
			<2735, 2459, 2467>, <2735, 2467, 2706>, <2458, 2734, 2706>, <2458, 2706, 2467>,
			<2551, 2579, 2635>, <2551, 2635, 2607>, <2550, 2578, 2634>, <2550, 2634, 2606>,
			<2443, 2493, 2523>, <2443, 2523, 2459>, <2443, 2459, 2429>, <2443, 2429, 2415>,
			<2442, 2492, 2522>, <2442, 2522, 2458>, <2442, 2458, 2428>, <2442, 2428, 2414>,
			<2718, 2664, 2694>, <2718, 2694, 2734>, <2718, 2734, 2762>, <2718, 2762, 2748>,
			<2719, 2665, 2695>, <2719, 2695, 2735>, <2719, 2735, 2763>, <2719, 2763, 2749>,
			<2749, 2763, 2791>, <2749, 2791, 2777>, <2748, 2762, 2790>, <2748, 2790, 2776>,
			<2414, 2428, 2400>, <2414, 2400, 2386>, <2415, 2429, 2401>, <2415, 2401, 2387>,
			<3472, 3416, 3415>, <3472, 3415, 3471>, <3415, 3385, 3443>, <3415, 3443, 3471>,
			<3416, 3386, 3385>, <3416, 3385, 3415>, <3471, 3443, 3444>, <3471, 3444, 3472>,
			<3588, 3528, 3527>, <3588, 3527, 3587>, <3527, 3499, 3557>, <3527, 3557, 3587>,
			<3528, 3500, 3499>, <3528, 3499, 3527>, <3587, 3557, 3558>, <3587, 3558, 3588>,
			<3529, 3589, 3590>, <3529, 3590, 3530>, <3590, 3560, 3502>, <3590, 3502, 3530>,
			<3589, 3559, 3560>, <3589, 3560, 3590>, <3530, 3502, 3501>, <3530, 3501, 3529>,
			<3417, 3473, 3474>, <3417, 3474, 3418>, <3474, 3446, 3388>, <3474, 3388, 3418>,
			<3473, 3445, 3446>, <3473, 3446, 3474>, <3418, 3388, 3387>, <3418, 3387, 3417>,
			<3629, 3353, 3361>, <3629, 3361, 3600>, <3352, 3628, 3600>, <3352, 3600, 3361>,
			<3445, 3473, 3529>, <3445, 3529, 3501>, <3444, 3472, 3528>, <3444, 3528, 3500>,
			<3337, 3387, 3417>, <3337, 3417, 3353>, <3337, 3353, 3323>, <3337, 3323, 3309>,
			<3336, 3386, 3416>, <3336, 3416, 3352>, <3336, 3352, 3322>, <3336, 3322, 3308>,
			<3612, 3558, 3588>, <3612, 3588, 3628>, <3612, 3628, 3656>, <3612, 3656, 3642>,
			<3613, 3559, 3589>, <3613, 3589, 3629>, <3613, 3629, 3657>, <3613, 3657, 3643>,
			<3643, 3657, 3685>, <3643, 3685, 3671>, <3642, 3656, 3684>, <3642, 3684, 3670>,
			<3308, 3322, 3294>, <3308, 3294, 3280>, <3309, 3323, 3295>, <3309, 3295, 3281>,
			<4282, 4226, 4225>, <4282, 4225, 4281>, <4225, 4195, 4253>, <4225, 4253, 4281>,
			<4226, 4196, 4195>, <4226, 4195, 4225>, <4281, 4253, 4254>, <4281, 4254, 4282>,
			<4398, 4338, 4337>, <4398, 4337, 4397>, <4337, 4309, 4367>, <4337, 4367, 4397>,
			<4338, 4310, 4309>, <4338, 4309, 4337>, <4397, 4367, 4368>, <4397, 4368, 4398>,
			<4339, 4399, 4400>, <4339, 4400, 4340>, <4400, 4370, 4312>, <4400, 4312, 4340>,
			<4399, 4369, 4370>, <4399, 4370, 4400>, <4340, 4312, 4311>, <4340, 4311, 4339>,
			<4227, 4283, 4284>, <4227, 4284, 4228>, <4284, 4256, 4198>, <4284, 4198, 4228>,
			<4283, 4255, 4256>, <4283, 4256, 4284>, <4228, 4198, 4197>, <4228, 4197, 4227>,
			<4439, 4163, 4171>, <4439, 4171, 4410>, <4162, 4438, 4410>, <4162, 4410, 4171>,
			<4255, 4283, 4339>, <4255, 4339, 4311>, <4254, 4282, 4338>, <4254, 4338, 4310>,
			<4147, 4197, 4227>, <4147, 4227, 4163>, <4147, 4163, 4133>, <4147, 4133, 4119>,
			<4146, 4196, 4226>, <4146, 4226, 4162>, <4146, 4162, 4132>, <4146, 4132, 4118>,
			<4422, 4368, 4398>, <4422, 4398, 4438>, <4422, 4438, 4466>, <4422, 4466, 4452>,
			<4423, 4369, 4399>, <4423, 4399, 4439>, <4423, 4439, 4467>, <4423, 4467, 4453>,
			<4453, 4467, 4495>, <4453, 4495, 4481>, <4452, 4466, 4494>, <4452, 4494, 4480>,
			<4118, 4132, 4104>, <4118, 4104, 4090>, <4119, 4133, 4105>, <4119, 4105, 4091>,
			<5092, 5036, 5035>, <5092, 5035, 5091>, <5035, 5005, 5063>, <5035, 5063, 5091>,
			<5036, 5006, 5005>, <5036, 5005, 5035>, <5091, 5063, 5064>, <5091, 5064, 5092>,
			<5208, 5148, 5147>, <5208, 5147, 5207>, <5147, 5119, 5177>, <5147, 5177, 5207>,
			<5148, 5120, 5119>, <5148, 5119, 5147>, <5207, 5177, 5178>, <5207, 5178, 5208>,
			<5149, 5209, 5210>, <5149, 5210, 5150>, <5210, 5180, 5122>, <5210, 5122, 5150>,
			<5209, 5179, 5180>, <5209, 5180, 5210>, <5150, 5122, 5121>, <5150, 5121, 5149>,
			<5037, 5093, 5094>, <5037, 5094, 5038>, <5094, 5066, 5008>, <5094, 5008, 5038>,
			<5093, 5065, 5066>, <5093, 5066, 5094>, <5038, 5008, 5007>, <5038, 5007, 5037>,
			<5249, 4973, 4981>, <5249, 4981, 5220>, <4972, 5248, 5220>, <4972, 5220, 4981>,
			<5065, 5093, 5149>, <5065, 5149, 5121>, <5064, 5092, 5148>, <5064, 5148, 5120>,
			<4957, 5007, 5037>, <4957, 5037, 4973>, <4957, 4973, 4943>, <4957, 4943, 4929>,
			<4956, 5006, 5036>, <4956, 5036, 4972>, <4956, 4972, 4942>, <4956, 4942, 4928>,
			<5232, 5178, 5208>, <5232, 5208, 5248>, <5232, 5248, 5276>, <5232, 5276, 5262>,
			<5233, 5179, 5209>, <5233, 5209, 5249>, <5233, 5249, 5277>, <5233, 5277, 5263>,
			<5263, 5277, 5305>, <5263, 5305, 5291>, <5262, 5276, 5304>, <5262, 5304, 5290>,
			<4928, 4942, 4914>, <4928, 4914, 4900>, <4929, 4943, 4915>, <4929, 4915, 4901>,
			<962, 906, 905>, <962, 905, 961>, <905, 875, 933>, <905, 933, 961>,
			<906, 876, 875>, <906, 875, 905>, <961, 933, 934>, <961, 934, 962>,
			<1078, 1018, 1017>, <1078, 1017, 1077>, <1017, 989, 1047>, <1017, 1047, 1077>,
			<1018, 990, 989>, <1018, 989, 1017>, <1077, 1047, 1048>, <1077, 1048, 1078>,
			<1019, 1079, 1080>, <1019, 1080, 1020>, <1080, 1050, 992>, <1080, 992, 1020>,
			<1079, 1049, 1050>, <1079, 1050, 1080>, <1020, 992, 991>, <1020, 991, 1019>,
			<907, 963, 964>, <907, 964, 908>, <964, 936, 878>, <964, 878, 908>,
			<963, 935, 936>, <963, 936, 964>, <908, 878, 877>, <908, 877, 907>,
			<1117, 841, 848>, <1117, 848, 1087>, <840, 1116, 1087>, <840, 1087, 848>,
			<935, 963, 1019>, <935, 1019, 991>, <934, 962, 1018>, <934, 1018, 990>,
			<825, 877, 907>, <825, 907, 841>, <825, 841, 811>, <825, 811, 797>,
			<824, 876, 906>, <824, 906, 840>, <824, 840, 810>, <824, 810, 796>,
			<1100, 1048, 1078>, <1100, 1078, 1116>, <1100, 1116, 1144>, <1100, 1144, 1130>,
			<1101, 1049, 1079>, <1101, 1079, 1117>, <1101, 1117, 1145>, <1101, 1145, 1131>,
			<1131, 1145, 1173>, <1131, 1173, 1159>, <1130, 1144, 1172>, <1130, 1172, 1158>,
			<796, 810, 782>, <796, 782, 768>, <797, 811, 783>, <797, 783, 769>,
			<1772, 1716, 1715>, <1772, 1715, 1771>, <1715, 1685, 1743>, <1715, 1743, 1771>,
			<1716, 1686, 1685>, <1716, 1685, 1715>, <1771, 1743, 1744>, <1771, 1744, 1772>,
			<1888, 1828, 1827>, <1888, 1827, 1887>, <1827, 1799, 1857>, <1827, 1857, 1887>,
			<1828, 1800, 1799>, <1828, 1799, 1827>, <1887, 1857, 1858>, <1887, 1858, 1888>,
			<1829, 1889, 1890>, <1829, 1890, 1830>, <1890, 1860, 1802>, <1890, 1802, 1830>,
			<1889, 1859, 1860>, <1889, 1860, 1890>, <1830, 1802, 1801>, <1830, 1801, 1829>,
			<1717, 1773, 1774>, <1717, 1774, 1718>, <1774, 1746, 1688>, <1774, 1688, 1718>,
			<1773, 1745, 1746>, <1773, 1746, 1774>, <1718, 1688, 1687>, <1718, 1687, 1717>,
			<1927, 1651, 1658>, <1927, 1658, 1897>, <1650, 1926, 1897>, <1650, 1897, 1658>,
			<1745, 1773, 1829>, <1745, 1829, 1801>, <1744, 1772, 1828>, <1744, 1828, 1800>,
			<1635, 1687, 1717>, <1635, 1717, 1651>, <1635, 1651, 1621>, <1635, 1621, 1607>,
			<1634, 1686, 1716>, <1634, 1716, 1650>, <1634, 1650, 1620>, <1634, 1620, 1606>,
			<1910, 1858, 1888>, <1910, 1888, 1926>, <1910, 1926, 1954>, <1910, 1954, 1940>,
			<1911, 1859, 1889>, <1911, 1889, 1927>, <1911, 1927, 1955>, <1911, 1955, 1941>,
			<1941, 1955, 1983>, <1941, 1983, 1969>, <1940, 1954, 1982>, <1940, 1982, 1968>,
			<1606, 1620, 1592>, <1606, 1592, 1578>, <1607, 1621, 1593>, <1607, 1593, 1579>,
			<2582, 2526, 2525>, <2582, 2525, 2581>, <2525, 2495, 2553>, <2525, 2553, 2581>,
			<2526, 2496, 2495>, <2526, 2495, 2525>, <2581, 2553, 2554>, <2581, 2554, 2582>,
			<2698, 2638, 2637>, <2698, 2637, 2697>, <2637, 2609, 2667>, <2637, 2667, 2697>,
			<2638, 2610, 2609>, <2638, 2609, 2637>, <2697, 2667, 2668>, <2697, 2668, 2698>,
			<2639, 2699, 2700>, <2639, 2700, 2640>, <2700, 2670, 2612>, <2700, 2612, 2640>,
			<2699, 2669, 2670>, <2699, 2670, 2700>, <2640, 2612, 2611>, <2640, 2611, 2639>,
			<2527, 2583, 2584>, <2527, 2584, 2528>, <2584, 2556, 2498>, <2584, 2498, 2528>,
			<2583, 2555, 2556>, <2583, 2556, 2584>, <2528, 2498, 2497>, <2528, 2497, 2527>,
			<2737, 2461, 2468>, <2737, 2468, 2707>, <2460, 2736, 2707>, <2460, 2707, 2468>,
			<2555, 2583, 2639>, <2555, 2639, 2611>, <2554, 2582, 2638>, <2554, 2638, 2610>,
			<2445, 2497, 2527>, <2445, 2527, 2461>, <2445, 2461, 2431>, <2445, 2431, 2417>,
			<2444, 2496, 2526>, <2444, 2526, 2460>, <2444, 2460, 2430>, <2444, 2430, 2416>,
			<2720, 2668, 2698>, <2720, 2698, 2736>, <2720, 2736, 2764>, <2720, 2764, 2750>,
			<2721, 2669, 2699>, <2721, 2699, 2737>, <2721, 2737, 2765>, <2721, 2765, 2751>,
			<2751, 2765, 2793>, <2751, 2793, 2779>, <2750, 2764, 2792>, <2750, 2792, 2778>,
			<2416, 2430, 2402>, <2416, 2402, 2388>, <2417, 2431, 2403>, <2417, 2403, 2389>,
			<3476, 3420, 3419>, <3476, 3419, 3475>, <3419, 3389, 3447>, <3419, 3447, 3475>,
			<3420, 3390, 3389>, <3420, 3389, 3419>, <3475, 3447, 3448>, <3475, 3448, 3476>,
			<3592, 3532, 3531>, <3592, 3531, 3591>, <3531, 3503, 3561>, <3531, 3561, 3591>,
			<3532, 3504, 3503>, <3532, 3503, 3531>, <3591, 3561, 3562>, <3591, 3562, 3592>,
			<3533, 3593, 3594>, <3533, 3594, 3534>, <3594, 3564, 3506>, <3594, 3506, 3534>,
			<3593, 3563, 3564>, <3593, 3564, 3594>, <3534, 3506, 3505>, <3534, 3505, 3533>,
			<3421, 3477, 3478>, <3421, 3478, 3422>, <3478, 3450, 3392>, <3478, 3392, 3422>,
			<3477, 3449, 3450>, <3477, 3450, 3478>, <3422, 3392, 3391>, <3422, 3391, 3421>,
			<3631, 3355, 3362>, <3631, 3362, 3601>, <3354, 3630, 3601>, <3354, 3601, 3362>,
			<3449, 3477, 3533>, <3449, 3533, 3505>, <3448, 3476, 3532>, <3448, 3532, 3504>,
			<3339, 3391, 3421>, <3339, 3421, 3355>, <3339, 3355, 3325>, <3339, 3325, 3311>,
			<3338, 3390, 3420>, <3338, 3420, 3354>, <3338, 3354, 3324>, <3338, 3324, 3310>,
			<3614, 3562, 3592>, <3614, 3592, 3630>, <3614, 3630, 3658>, <3614, 3658, 3644>,
			<3615, 3563, 3593>, <3615, 3593, 3631>, <3615, 3631, 3659>, <3615, 3659, 3645>,
			<3645, 3659, 3687>, <3645, 3687, 3673>, <3644, 3658, 3686>, <3644, 3686, 3672>,
			<3310, 3324, 3296>, <3310, 3296, 3282>, <3311, 3325, 3297>, <3311, 3297, 3283>,
			<4286, 4230, 4229>, <4286, 4229, 4285>, <4229, 4199, 4257>, <4229, 4257, 4285>,
			<4230, 4200, 4199>, <4230, 4199, 4229>, <4285, 4257, 4258>, <4285, 4258, 4286>,
			<4402, 4342, 4341>, <4402, 4341, 4401>, <4341, 4313, 4371>, <4341, 4371, 4401>,
			<4342, 4314, 4313>, <4342, 4313, 4341>, <4401, 4371, 4372>, <4401, 4372, 4402>,
			<4343, 4403, 4404>, <4343, 4404, 4344>, <4404, 4374, 4316>, <4404, 4316, 4344>,
			<4403, 4373, 4374>, <4403, 4374, 4404>, <4344, 4316, 4315>, <4344, 4315, 4343>,
			<4231, 4287, 4288>, <4231, 4288, 4232>, <4288, 4260, 4202>, <4288, 4202, 4232>,
			<4287, 4259, 4260>, <4287, 4260, 4288>, <4232, 4202, 4201>, <4232, 4201, 4231>,
			<4441, 4165, 4172>, <4441, 4172, 4411>, <4164, 4440, 4411>, <4164, 4411, 4172>,
			<4259, 4287, 4343>, <4259, 4343, 4315>, <4258, 4286, 4342>, <4258, 4342, 4314>,
			<4149, 4201, 4231>, <4149, 4231, 4165>, <4149, 4165, 4135>, <4149, 4135, 4121>,
			<4148, 4200, 4230>, <4148, 4230, 4164>, <4148, 4164, 4134>, <4148, 4134, 4120>,
			<4424, 4372, 4402>, <4424, 4402, 4440>, <4424, 4440, 4468>, <4424, 4468, 4454>,
			<4425, 4373, 4403>, <4425, 4403, 4441>, <4425, 4441, 4469>, <4425, 4469, 4455>,
			<4455, 4469, 4497>, <4455, 4497, 4483>, <4454, 4468, 4496>, <4454, 4496, 4482>,
			<4120, 4134, 4106>, <4120, 4106, 4092>, <4121, 4135, 4107>, <4121, 4107, 4093>,
			<5096, 5040, 5039>, <5096, 5039, 5095>, <5039, 5009, 5067>, <5039, 5067, 5095>,
			<5040, 5010, 5009>, <5040, 5009, 5039>, <5095, 5067, 5068>, <5095, 5068, 5096>,
			<5212, 5152, 5151>, <5212, 5151, 5211>, <5151, 5123, 5181>, <5151, 5181, 5211>,
			<5152, 5124, 5123>, <5152, 5123, 5151>, <5211, 5181, 5182>, <5211, 5182, 5212>,
			<5153, 5213, 5214>, <5153, 5214, 5154>, <5214, 5184, 5126>, <5214, 5126, 5154>,
			<5213, 5183, 5184>, <5213, 5184, 5214>, <5154, 5126, 5125>, <5154, 5125, 5153>,
			<5041, 5097, 5098>, <5041, 5098, 5042>, <5098, 5070, 5012>, <5098, 5012, 5042>,
			<5097, 5069, 5070>, <5097, 5070, 5098>, <5042, 5012, 5011>, <5042, 5011, 5041>,
			<5251, 4975, 4982>, <5251, 4982, 5221>, <4974, 5250, 5221>, <4974, 5221, 4982>,
			<5069, 5097, 5153>, <5069, 5153, 5125>, <5068, 5096, 5152>, <5068, 5152, 5124>,
			<4959, 5011, 5041>, <4959, 5041, 4975>, <4959, 4975, 4945>, <4959, 4945, 4931>,
			<4958, 5010, 5040>, <4958, 5040, 4974>, <4958, 4974, 4944>, <4958, 4944, 4930>,
			<5234, 5182, 5212>, <5234, 5212, 5250>, <5234, 5250, 5278>, <5234, 5278, 5264>,
			<5235, 5183, 5213>, <5235, 5213, 5251>, <5235, 5251, 5279>, <5235, 5279, 5265>,
			<5265, 5279, 5307>, <5265, 5307, 5293>, <5264, 5278, 5306>, <5264, 5306, 5292>,
			<4930, 4944, 4916>, <4930, 4916, 4902>, <4931, 4945, 4917>, <4931, 4917, 4903>,
			<5568, 5567, 5672>, <5568, 5672, 5673>, <5672, 5640, 5641>, <5672, 5641, 5673>,
			<5567, 5519, 5640>, <5567, 5640, 5672>, <5673, 5641, 5520>, <5673, 5520, 5568>,
			<5570, 5569, 5674>, <5570, 5674, 5675>, <5674, 5642, 5643>, <5674, 5643, 5675>,
			<5569, 5521, 5642>, <5569, 5642, 5674>, <5675, 5643, 5522>, <5675, 5522, 5570>,
			<5457, 5458, 5347>, <5457, 5347, 5346>, <5347, 5315, 5314>, <5347, 5314, 5346>,
			<5458, 5410, 5315>, <5458, 5315, 5347>, <5346, 5314, 5409>, <5346, 5409, 5457>,
			<5455, 5456, 5345>, <5455, 5345, 5344>, <5345, 5313, 5312>, <5345, 5312, 5344>,
			<5456, 5408, 5313>, <5456, 5313, 5345>, <5344, 5312, 5407>, <5344, 5407, 5455>,
			<5459, 5454, 5498>, <5459, 5498, 5499>, <5566, 5571, 5499>, <5566, 5499, 5498>,
			<5408, 5456, 5457>, <5408, 5457, 5409>, <5520, 5568, 5569>, <5520, 5569, 5521>,
			<5406, 5407, 5455>, <5406, 5455, 5454>, <5406, 5454, 5387>, <5406, 5387, 5373>,
			<5518, 5519, 5567>, <5518, 5567, 5566>, <5518, 5566, 5623>, <5518, 5623, 5609>,
			<5523, 5522, 5570>, <5523, 5570, 5571>, <5523, 5571, 5624>, <5523, 5624, 5610>,
			<5411, 5410, 5458>, <5411, 5458, 5459>, <5411, 5459, 5388>, <5411, 5388, 5374>,
			<5374, 5388, 5296>, <5374, 5296, 5282>, <5610, 5624, 5716>, <5610, 5716, 5702>,
			<5609, 5623, 5715>, <5609, 5715, 5701>, <5373, 5387, 5295>, <5373, 5295, 5281>,
			<5574, 5573, 5676>, <5574, 5676, 5677>, <5676, 5644, 5645>, <5676, 5645, 5677>,
			<5573, 5525, 5644>, <5573, 5644, 5676>, <5677, 5645, 5526>, <5677, 5526, 5574>,
			<5576, 5575, 5678>, <5576, 5678, 5679>, <5678, 5646, 5647>, <5678, 5647, 5679>,
			<5575, 5527, 5646>, <5575, 5646, 5678>, <5679, 5647, 5528>, <5679, 5528, 5576>,
			<5463, 5464, 5351>, <5463, 5351, 5350>, <5351, 5319, 5318>, <5351, 5318, 5350>,
			<5464, 5416, 5319>, <5464, 5319, 5351>, <5350, 5318, 5415>, <5350, 5415, 5463>,
			<5461, 5462, 5349>, <5461, 5349, 5348>, <5349, 5317, 5316>, <5349, 5316, 5348>,
			<5462, 5414, 5317>, <5462, 5317, 5349>, <5348, 5316, 5413>, <5348, 5413, 5461>,
			<5465, 5460, 5500>, <5465, 5500, 5501>, <5572, 5577, 5501>, <5572, 5501, 5500>,
			<5414, 5462, 5463>, <5414, 5463, 5415>, <5526, 5574, 5575>, <5526, 5575, 5527>,
			<5412, 5413, 5461>, <5412, 5461, 5460>, <5412, 5460, 5389>, <5412, 5389, 5375>,
			<5524, 5525, 5573>, <5524, 5573, 5572>, <5524, 5572, 5625>, <5524, 5625, 5611>,
			<5529, 5528, 5576>, <5529, 5576, 5577>, <5529, 5577, 5626>, <5529, 5626, 5612>,
			<5417, 5416, 5464>, <5417, 5464, 5465>, <5417, 5465, 5390>, <5417, 5390, 5376>,
			<5376, 5390, 5298>, <5376, 5298, 5284>, <5612, 5626, 5718>, <5612, 5718, 5704>,
			<5611, 5625, 5717>, <5611, 5717, 5703>, <5375, 5389, 5297>, <5375, 5297, 5283>,
			<5580, 5579, 5680>, <5580, 5680, 5681>, <5680, 5648, 5649>, <5680, 5649, 5681>,
			<5579, 5531, 5648>, <5579, 5648, 5680>, <5681, 5649, 5532>, <5681, 5532, 5580>,
			<5582, 5581, 5682>, <5582, 5682, 5683>, <5682, 5650, 5651>, <5682, 5651, 5683>,
			<5581, 5533, 5650>, <5581, 5650, 5682>, <5683, 5651, 5534>, <5683, 5534, 5582>,
			<5469, 5470, 5355>, <5469, 5355, 5354>, <5355, 5323, 5322>, <5355, 5322, 5354>,
			<5470, 5422, 5323>, <5470, 5323, 5355>, <5354, 5322, 5421>, <5354, 5421, 5469>,
			<5467, 5468, 5353>, <5467, 5353, 5352>, <5353, 5321, 5320>, <5353, 5320, 5352>,
			<5468, 5420, 5321>, <5468, 5321, 5353>, <5352, 5320, 5419>, <5352, 5419, 5467>,
			<5471, 5466, 5502>, <5471, 5502, 5503>, <5578, 5583, 5503>, <5578, 5503, 5502>,
			<5420, 5468, 5469>, <5420, 5469, 5421>, <5532, 5580, 5581>, <5532, 5581, 5533>,
			<5418, 5419, 5467>, <5418, 5467, 5466>, <5418, 5466, 5391>, <5418, 5391, 5377>,
			<5530, 5531, 5579>, <5530, 5579, 5578>, <5530, 5578, 5627>, <5530, 5627, 5613>,
			<5535, 5534, 5582>, <5535, 5582, 5583>, <5535, 5583, 5628>, <5535, 5628, 5614>,
			<5423, 5422, 5470>, <5423, 5470, 5471>, <5423, 5471, 5392>, <5423, 5392, 5378>,
			<5378, 5392, 5300>, <5378, 5300, 5286>, <5614, 5628, 5720>, <5614, 5720, 5706>,
			<5613, 5627, 5719>, <5613, 5719, 5705>, <5377, 5391, 5299>, <5377, 5299, 5285>,
			<5586, 5585, 5684>, <5586, 5684, 5685>, <5684, 5652, 5653>, <5684, 5653, 5685>,
			<5585, 5537, 5652>, <5585, 5652, 5684>, <5685, 5653, 5538>, <5685, 5538, 5586>,
			<5588, 5587, 5686>, <5588, 5686, 5687>, <5686, 5654, 5655>, <5686, 5655, 5687>,
			<5587, 5539, 5654>, <5587, 5654, 5686>, <5687, 5655, 5540>, <5687, 5540, 5588>,
			<5475, 5476, 5359>, <5475, 5359, 5358>, <5359, 5327, 5326>, <5359, 5326, 5358>,
			<5476, 5428, 5327>, <5476, 5327, 5359>, <5358, 5326, 5427>, <5358, 5427, 5475>,
			<5473, 5474, 5357>, <5473, 5357, 5356>, <5357, 5325, 5324>, <5357, 5324, 5356>,
			<5474, 5426, 5325>, <5474, 5325, 5357>, <5356, 5324, 5425>, <5356, 5425, 5473>,
			<5477, 5472, 5504>, <5477, 5504, 5505>, <5584, 5589, 5505>, <5584, 5505, 5504>,
			<5426, 5474, 5475>, <5426, 5475, 5427>, <5538, 5586, 5587>, <5538, 5587, 5539>,
			<5424, 5425, 5473>, <5424, 5473, 5472>, <5424, 5472, 5393>, <5424, 5393, 5379>,
			<5536, 5537, 5585>, <5536, 5585, 5584>, <5536, 5584, 5629>, <5536, 5629, 5615>,
			<5541, 5540, 5588>, <5541, 5588, 5589>, <5541, 5589, 5630>, <5541, 5630, 5616>,
			<5429, 5428, 5476>, <5429, 5476, 5477>, <5429, 5477, 5394>, <5429, 5394, 5380>,
			<5380, 5394, 5302>, <5380, 5302, 5288>, <5616, 5630, 5722>, <5616, 5722, 5708>,
			<5615, 5629, 5721>, <5615, 5721, 5707>, <5379, 5393, 5301>, <5379, 5301, 5287>,
			<5592, 5591, 5688>, <5592, 5688, 5689>, <5688, 5656, 5657>, <5688, 5657, 5689>,
			<5591, 5543, 5656>, <5591, 5656, 5688>, <5689, 5657, 5544>, <5689, 5544, 5592>,
			<5594, 5593, 5690>, <5594, 5690, 5691>, <5690, 5658, 5659>, <5690, 5659, 5691>,
			<5593, 5545, 5658>, <5593, 5658, 5690>, <5691, 5659, 5546>, <5691, 5546, 5594>,
			<5481, 5482, 5363>, <5481, 5363, 5362>, <5363, 5331, 5330>, <5363, 5330, 5362>,
			<5482, 5434, 5331>, <5482, 5331, 5363>, <5362, 5330, 5433>, <5362, 5433, 5481>,
			<5479, 5480, 5361>, <5479, 5361, 5360>, <5361, 5329, 5328>, <5361, 5328, 5360>,
			<5480, 5432, 5329>, <5480, 5329, 5361>, <5360, 5328, 5431>, <5360, 5431, 5479>,
			<5483, 5478, 5506>, <5483, 5506, 5507>, <5590, 5595, 5507>, <5590, 5507, 5506>,
			<5432, 5480, 5481>, <5432, 5481, 5433>, <5544, 5592, 5593>, <5544, 5593, 5545>,
			<5430, 5431, 5479>, <5430, 5479, 5478>, <5430, 5478, 5395>, <5430, 5395, 5381>,
			<5542, 5543, 5591>, <5542, 5591, 5590>, <5542, 5590, 5631>, <5542, 5631, 5617>,
			<5547, 5546, 5594>, <5547, 5594, 5595>, <5547, 5595, 5632>, <5547, 5632, 5618>,
			<5435, 5434, 5482>, <5435, 5482, 5483>, <5435, 5483, 5396>, <5435, 5396, 5382>,
			<5382, 5396, 5304>, <5382, 5304, 5290>, <5618, 5632, 5724>, <5618, 5724, 5710>,
			<5617, 5631, 5723>, <5617, 5723, 5709>, <5381, 5395, 5303>, <5381, 5303, 5289>,
			<5598, 5597, 5692>, <5598, 5692, 5693>, <5692, 5660, 5661>, <5692, 5661, 5693>,
			<5597, 5549, 5660>, <5597, 5660, 5692>, <5693, 5661, 5550>, <5693, 5550, 5598>,
			<5600, 5599, 5694>, <5600, 5694, 5695>, <5694, 5662, 5663>, <5694, 5663, 5695>,
			<5599, 5551, 5662>, <5599, 5662, 5694>, <5695, 5663, 5552>, <5695, 5552, 5600>,
			<5487, 5488, 5367>, <5487, 5367, 5366>, <5367, 5335, 5334>, <5367, 5334, 5366>,
			<5488, 5440, 5335>, <5488, 5335, 5367>, <5366, 5334, 5439>, <5366, 5439, 5487>,
			<5485, 5486, 5365>, <5485, 5365, 5364>, <5365, 5333, 5332>, <5365, 5332, 5364>,
			<5486, 5438, 5333>, <5486, 5333, 5365>, <5364, 5332, 5437>, <5364, 5437, 5485>,
			<5489, 5484, 5508>, <5489, 5508, 5509>, <5596, 5601, 5509>, <5596, 5509, 5508>,
			<5438, 5486, 5487>, <5438, 5487, 5439>, <5550, 5598, 5599>, <5550, 5599, 5551>,
			<5436, 5437, 5485>, <5436, 5485, 5484>, <5436, 5484, 5397>, <5436, 5397, 5383>,
			<5548, 5549, 5597>, <5548, 5597, 5596>, <5548, 5596, 5633>, <5548, 5633, 5619>,
			<5553, 5552, 5600>, <5553, 5600, 5601>, <5553, 5601, 5634>, <5553, 5634, 5620>,
			<5441, 5440, 5488>, <5441, 5488, 5489>, <5441, 5489, 5398>, <5441, 5398, 5384>,
			<5384, 5398, 5306>, <5384, 5306, 5292>, <5620, 5634, 5726>, <5620, 5726, 5712>,
			<5619, 5633, 5725>, <5619, 5725, 5711>, <5383, 5397, 5305>, <5383, 5305, 5291>,
			<4758, 4757, 4862>, <4758, 4862, 4863>, <4862, 4830, 4831>, <4862, 4831, 4863>,
			<4757, 4709, 4830>, <4757, 4830, 4862>, <4863, 4831, 4710>, <4863, 4710, 4758>,
			<4760, 4759, 4864>, <4760, 4864, 4865>, <4864, 4832, 4833>, <4864, 4833, 4865>,
			<4759, 4711, 4832>, <4759, 4832, 4864>, <4865, 4833, 4712>, <4865, 4712, 4760>,
			<4647, 4648, 4537>, <4647, 4537, 4536>, <4537, 4505, 4504>, <4537, 4504, 4536>,
			<4648, 4600, 4505>, <4648, 4505, 4537>, <4536, 4504, 4599>, <4536, 4599, 4647>,
			<4645, 4646, 4535>, <4645, 4535, 4534>, <4535, 4503, 4502>, <4535, 4502, 4534>,
			<4646, 4598, 4503>, <4646, 4503, 4535>, <4534, 4502, 4597>, <4534, 4597, 4645>,
			<4649, 4644, 4688>, <4649, 4688, 4689>, <4756, 4761, 4689>, <4756, 4689, 4688>,
			<4598, 4646, 4647>, <4598, 4647, 4599>, <4710, 4758, 4759>, <4710, 4759, 4711>,
			<4596, 4597, 4645>, <4596, 4645, 4644>, <4596, 4644, 4577>, <4596, 4577, 4563>,
			<4708, 4709, 4757>, <4708, 4757, 4756>, <4708, 4756, 4813>, <4708, 4813, 4799>,
			<4713, 4712, 4760>, <4713, 4760, 4761>, <4713, 4761, 4814>, <4713, 4814, 4800>,
			<4601, 4600, 4648>, <4601, 4648, 4649>, <4601, 4649, 4578>, <4601, 4578, 4564>,
			<4564, 4578, 4486>, <4564, 4486, 4472>, <4800, 4814, 4906>, <4800, 4906, 4892>,
			<4799, 4813, 4905>, <4799, 4905, 4891>, <4563, 4577, 4485>, <4563, 4485, 4471>,
			<4764, 4763, 4866>, <4764, 4866, 4867>, <4866, 4834, 4835>, <4866, 4835, 4867>,
			<4763, 4715, 4834>, <4763, 4834, 4866>, <4867, 4835, 4716>, <4867, 4716, 4764>,
			<4766, 4765, 4868>, <4766, 4868, 4869>, <4868, 4836, 4837>, <4868, 4837, 4869>,
			<4765, 4717, 4836>, <4765, 4836, 4868>, <4869, 4837, 4718>, <4869, 4718, 4766>,
			<4653, 4654, 4541>, <4653, 4541, 4540>, <4541, 4509, 4508>, <4541, 4508, 4540>,
			<4654, 4606, 4509>, <4654, 4509, 4541>, <4540, 4508, 4605>, <4540, 4605, 4653>,
			<4651, 4652, 4539>, <4651, 4539, 4538>, <4539, 4507, 4506>, <4539, 4506, 4538>,
			<4652, 4604, 4507>, <4652, 4507, 4539>, <4538, 4506, 4603>, <4538, 4603, 4651>,
			<4655, 4650, 4690>, <4655, 4690, 4691>, <4762, 4767, 4691>, <4762, 4691, 4690>,
			<4604, 4652, 4653>, <4604, 4653, 4605>, <4716, 4764, 4765>, <4716, 4765, 4717>,
			<4602, 4603, 4651>, <4602, 4651, 4650>, <4602, 4650, 4579>, <4602, 4579, 4565>,
			<4714, 4715, 4763>, <4714, 4763, 4762>, <4714, 4762, 4815>, <4714, 4815, 4801>,
			<4719, 4718, 4766>, <4719, 4766, 4767>, <4719, 4767, 4816>, <4719, 4816, 4802>,
			<4607, 4606, 4654>, <4607, 4654, 4655>, <4607, 4655, 4580>, <4607, 4580, 4566>,
			<4566, 4580, 4488>, <4566, 4488, 4474>, <4802, 4816, 4908>, <4802, 4908, 4894>,
			<4801, 4815, 4907>, <4801, 4907, 4893>, <4565, 4579, 4487>, <4565, 4487, 4473>,
			<4770, 4769, 4870>, <4770, 4870, 4871>, <4870, 4838, 4839>, <4870, 4839, 4871>,
			<4769, 4721, 4838>, <4769, 4838, 4870>, <4871, 4839, 4722>, <4871, 4722, 4770>,
			<4772, 4771, 4872>, <4772, 4872, 4873>, <4872, 4840, 4841>, <4872, 4841, 4873>,
			<4771, 4723, 4840>, <4771, 4840, 4872>, <4873, 4841, 4724>, <4873, 4724, 4772>,
			<4659, 4660, 4545>, <4659, 4545, 4544>, <4545, 4513, 4512>, <4545, 4512, 4544>,
			<4660, 4612, 4513>, <4660, 4513, 4545>, <4544, 4512, 4611>, <4544, 4611, 4659>,
			<4657, 4658, 4543>, <4657, 4543, 4542>, <4543, 4511, 4510>, <4543, 4510, 4542>,
			<4658, 4610, 4511>, <4658, 4511, 4543>, <4542, 4510, 4609>, <4542, 4609, 4657>,
			<4661, 4656, 4692>, <4661, 4692, 4693>, <4768, 4773, 4693>, <4768, 4693, 4692>,
			<4610, 4658, 4659>, <4610, 4659, 4611>, <4722, 4770, 4771>, <4722, 4771, 4723>,
			<4608, 4609, 4657>, <4608, 4657, 4656>, <4608, 4656, 4581>, <4608, 4581, 4567>,
			<4720, 4721, 4769>, <4720, 4769, 4768>, <4720, 4768, 4817>, <4720, 4817, 4803>,
			<4725, 4724, 4772>, <4725, 4772, 4773>, <4725, 4773, 4818>, <4725, 4818, 4804>,
			<4613, 4612, 4660>, <4613, 4660, 4661>, <4613, 4661, 4582>, <4613, 4582, 4568>,
			<4568, 4582, 4490>, <4568, 4490, 4476>, <4804, 4818, 4910>, <4804, 4910, 4896>,
			<4803, 4817, 4909>, <4803, 4909, 4895>, <4567, 4581, 4489>, <4567, 4489, 4475>,
			<4776, 4775, 4874>, <4776, 4874, 4875>, <4874, 4842, 4843>, <4874, 4843, 4875>,
			<4775, 4727, 4842>, <4775, 4842, 4874>, <4875, 4843, 4728>, <4875, 4728, 4776>,
			<4778, 4777, 4876>, <4778, 4876, 4877>, <4876, 4844, 4845>, <4876, 4845, 4877>,
			<4777, 4729, 4844>, <4777, 4844, 4876>, <4877, 4845, 4730>, <4877, 4730, 4778>,
			<4665, 4666, 4549>, <4665, 4549, 4548>, <4549, 4517, 4516>, <4549, 4516, 4548>,
			<4666, 4618, 4517>, <4666, 4517, 4549>, <4548, 4516, 4617>, <4548, 4617, 4665>,
			<4663, 4664, 4547>, <4663, 4547, 4546>, <4547, 4515, 4514>, <4547, 4514, 4546>,
			<4664, 4616, 4515>, <4664, 4515, 4547>, <4546, 4514, 4615>, <4546, 4615, 4663>,
			<4667, 4662, 4694>, <4667, 4694, 4695>, <4774, 4779, 4695>, <4774, 4695, 4694>,
			<4616, 4664, 4665>, <4616, 4665, 4617>, <4728, 4776, 4777>, <4728, 4777, 4729>,
			<4614, 4615, 4663>, <4614, 4663, 4662>, <4614, 4662, 4583>, <4614, 4583, 4569>,
			<4726, 4727, 4775>, <4726, 4775, 4774>, <4726, 4774, 4819>, <4726, 4819, 4805>,
			<4731, 4730, 4778>, <4731, 4778, 4779>, <4731, 4779, 4820>, <4731, 4820, 4806>,
			<4619, 4618, 4666>, <4619, 4666, 4667>, <4619, 4667, 4584>, <4619, 4584, 4570>,
			<4570, 4584, 4492>, <4570, 4492, 4478>, <4806, 4820, 4912>, <4806, 4912, 4898>,
			<4805, 4819, 4911>, <4805, 4911, 4897>, <4569, 4583, 4491>, <4569, 4491, 4477>,
			<4782, 4781, 4878>, <4782, 4878, 4879>, <4878, 4846, 4847>, <4878, 4847, 4879>,
			<4781, 4733, 4846>, <4781, 4846, 4878>, <4879, 4847, 4734>, <4879, 4734, 4782>,
			<4784, 4783, 4880>, <4784, 4880, 4881>, <4880, 4848, 4849>, <4880, 4849, 4881>,
			<4783, 4735, 4848>, <4783, 4848, 4880>, <4881, 4849, 4736>, <4881, 4736, 4784>,
			<4671, 4672, 4553>, <4671, 4553, 4552>, <4553, 4521, 4520>, <4553, 4520, 4552>,
			<4672, 4624, 4521>, <4672, 4521, 4553>, <4552, 4520, 4623>, <4552, 4623, 4671>,
			<4669, 4670, 4551>, <4669, 4551, 4550>, <4551, 4519, 4518>, <4551, 4518, 4550>,
			<4670, 4622, 4519>, <4670, 4519, 4551>, <4550, 4518, 4621>, <4550, 4621, 4669>,
			<4673, 4668, 4696>, <4673, 4696, 4697>, <4780, 4785, 4697>, <4780, 4697, 4696>,
			<4622, 4670, 4671>, <4622, 4671, 4623>, <4734, 4782, 4783>, <4734, 4783, 4735>,
			<4620, 4621, 4669>, <4620, 4669, 4668>, <4620, 4668, 4585>, <4620, 4585, 4571>,
			<4732, 4733, 4781>, <4732, 4781, 4780>, <4732, 4780, 4821>, <4732, 4821, 4807>,
			<4737, 4736, 4784>, <4737, 4784, 4785>, <4737, 4785, 4822>, <4737, 4822, 4808>,
			<4625, 4624, 4672>, <4625, 4672, 4673>, <4625, 4673, 4586>, <4625, 4586, 4572>,
			<4572, 4586, 4494>, <4572, 4494, 4480>, <4808, 4822, 4914>, <4808, 4914, 4900>,
			<4807, 4821, 4913>, <4807, 4913, 4899>, <4571, 4585, 4493>, <4571, 4493, 4479>,
			<4788, 4787, 4882>, <4788, 4882, 4883>, <4882, 4850, 4851>, <4882, 4851, 4883>,
			<4787, 4739, 4850>, <4787, 4850, 4882>, <4883, 4851, 4740>, <4883, 4740, 4788>,
			<4790, 4789, 4884>, <4790, 4884, 4885>, <4884, 4852, 4853>, <4884, 4853, 4885>,
			<4789, 4741, 4852>, <4789, 4852, 4884>, <4885, 4853, 4742>, <4885, 4742, 4790>,
			<4677, 4678, 4557>, <4677, 4557, 4556>, <4557, 4525, 4524>, <4557, 4524, 4556>,
			<4678, 4630, 4525>, <4678, 4525, 4557>, <4556, 4524, 4629>, <4556, 4629, 4677>,
			<4675, 4676, 4555>, <4675, 4555, 4554>, <4555, 4523, 4522>, <4555, 4522, 4554>,
			<4676, 4628, 4523>, <4676, 4523, 4555>, <4554, 4522, 4627>, <4554, 4627, 4675>,
			<4679, 4674, 4698>, <4679, 4698, 4699>, <4786, 4791, 4699>, <4786, 4699, 4698>,
			<4628, 4676, 4677>, <4628, 4677, 4629>, <4740, 4788, 4789>, <4740, 4789, 4741>,
			<4626, 4627, 4675>, <4626, 4675, 4674>, <4626, 4674, 4587>, <4626, 4587, 4573>,
			<4738, 4739, 4787>, <4738, 4787, 4786>, <4738, 4786, 4823>, <4738, 4823, 4809>,
			<4743, 4742, 4790>, <4743, 4790, 4791>, <4743, 4791, 4824>, <4743, 4824, 4810>,
			<4631, 4630, 4678>, <4631, 4678, 4679>, <4631, 4679, 4588>, <4631, 4588, 4574>,
			<4574, 4588, 4496>, <4574, 4496, 4482>, <4810, 4824, 4916>, <4810, 4916, 4902>,
			<4809, 4823, 4915>, <4809, 4915, 4901>, <4573, 4587, 4495>, <4573, 4495, 4481>,
			<3948, 3947, 4052>, <3948, 4052, 4053>, <4052, 4020, 4021>, <4052, 4021, 4053>,
			<3947, 3899, 4020>, <3947, 4020, 4052>, <4053, 4021, 3900>, <4053, 3900, 3948>,
			<3950, 3949, 4054>, <3950, 4054, 4055>, <4054, 4022, 4023>, <4054, 4023, 4055>,
			<3949, 3901, 4022>, <3949, 4022, 4054>, <4055, 4023, 3902>, <4055, 3902, 3950>,
			<3837, 3838, 3727>, <3837, 3727, 3726>, <3727, 3695, 3694>, <3727, 3694, 3726>,
			<3838, 3790, 3695>, <3838, 3695, 3727>, <3726, 3694, 3789>, <3726, 3789, 3837>,
			<3835, 3836, 3725>, <3835, 3725, 3724>, <3725, 3693, 3692>, <3725, 3692, 3724>,
			<3836, 3788, 3693>, <3836, 3693, 3725>, <3724, 3692, 3787>, <3724, 3787, 3835>,
			<3839, 3834, 3878>, <3839, 3878, 3879>, <3946, 3951, 3879>, <3946, 3879, 3878>,
			<3788, 3836, 3837>, <3788, 3837, 3789>, <3900, 3948, 3949>, <3900, 3949, 3901>,
			<3786, 3787, 3835>, <3786, 3835, 3834>, <3786, 3834, 3767>, <3786, 3767, 3753>,
			<3898, 3899, 3947>, <3898, 3947, 3946>, <3898, 3946, 4003>, <3898, 4003, 3989>,
			<3903, 3902, 3950>, <3903, 3950, 3951>, <3903, 3951, 4004>, <3903, 4004, 3990>,
			<3791, 3790, 3838>, <3791, 3838, 3839>, <3791, 3839, 3768>, <3791, 3768, 3754>,
			<3754, 3768, 3676>, <3754, 3676, 3662>, <3990, 4004, 4096>, <3990, 4096, 4082>,
			<3989, 4003, 4095>, <3989, 4095, 4081>, <3753, 3767, 3675>, <3753, 3675, 3661>,
			<3954, 3953, 4056>, <3954, 4056, 4057>, <4056, 4024, 4025>, <4056, 4025, 4057>,
			<3953, 3905, 4024>, <3953, 4024, 4056>, <4057, 4025, 3906>, <4057, 3906, 3954>,
			<3956, 3955, 4058>, <3956, 4058, 4059>, <4058, 4026, 4027>, <4058, 4027, 4059>,
			<3955, 3907, 4026>, <3955, 4026, 4058>, <4059, 4027, 3908>, <4059, 3908, 3956>,
			<3843, 3844, 3731>, <3843, 3731, 3730>, <3731, 3699, 3698>, <3731, 3698, 3730>,
			<3844, 3796, 3699>, <3844, 3699, 3731>, <3730, 3698, 3795>, <3730, 3795, 3843>,
			<3841, 3842, 3729>, <3841, 3729, 3728>, <3729, 3697, 3696>, <3729, 3696, 3728>,
			<3842, 3794, 3697>, <3842, 3697, 3729>, <3728, 3696, 3793>, <3728, 3793, 3841>,
			<3845, 3840, 3880>, <3845, 3880, 3881>, <3952, 3957, 3881>, <3952, 3881, 3880>,
			<3794, 3842, 3843>, <3794, 3843, 3795>, <3906, 3954, 3955>, <3906, 3955, 3907>,
			<3792, 3793, 3841>, <3792, 3841, 3840>, <3792, 3840, 3769>, <3792, 3769, 3755>,
			<3904, 3905, 3953>, <3904, 3953, 3952>, <3904, 3952, 4005>, <3904, 4005, 3991>,
			<3909, 3908, 3956>, <3909, 3956, 3957>, <3909, 3957, 4006>, <3909, 4006, 3992>,
			<3797, 3796, 3844>, <3797, 3844, 3845>, <3797, 3845, 3770>, <3797, 3770, 3756>,
			<3756, 3770, 3678>, <3756, 3678, 3664>, <3992, 4006, 4098>, <3992, 4098, 4084>,
			<3991, 4005, 4097>, <3991, 4097, 4083>, <3755, 3769, 3677>, <3755, 3677, 3663>,
			<3960, 3959, 4060>, <3960, 4060, 4061>, <4060, 4028, 4029>, <4060, 4029, 4061>,
			<3959, 3911, 4028>, <3959, 4028, 4060>, <4061, 4029, 3912>, <4061, 3912, 3960>,
			<3962, 3961, 4062>, <3962, 4062, 4063>, <4062, 4030, 4031>, <4062, 4031, 4063>,
			<3961, 3913, 4030>, <3961, 4030, 4062>, <4063, 4031, 3914>, <4063, 3914, 3962>,
			<3849, 3850, 3735>, <3849, 3735, 3734>, <3735, 3703, 3702>, <3735, 3702, 3734>,
			<3850, 3802, 3703>, <3850, 3703, 3735>, <3734, 3702, 3801>, <3734, 3801, 3849>,
			<3847, 3848, 3733>, <3847, 3733, 3732>, <3733, 3701, 3700>, <3733, 3700, 3732>,
			<3848, 3800, 3701>, <3848, 3701, 3733>, <3732, 3700, 3799>, <3732, 3799, 3847>,
			<3851, 3846, 3882>, <3851, 3882, 3883>, <3958, 3963, 3883>, <3958, 3883, 3882>,
			<3800, 3848, 3849>, <3800, 3849, 3801>, <3912, 3960, 3961>, <3912, 3961, 3913>,
			<3798, 3799, 3847>, <3798, 3847, 3846>, <3798, 3846, 3771>, <3798, 3771, 3757>,
			<3910, 3911, 3959>, <3910, 3959, 3958>, <3910, 3958, 4007>, <3910, 4007, 3993>,
			<3915, 3914, 3962>, <3915, 3962, 3963>, <3915, 3963, 4008>, <3915, 4008, 3994>,
			<3803, 3802, 3850>, <3803, 3850, 3851>, <3803, 3851, 3772>, <3803, 3772, 3758>,
			<3758, 3772, 3680>, <3758, 3680, 3666>, <3994, 4008, 4100>, <3994, 4100, 4086>,
			<3993, 4007, 4099>, <3993, 4099, 4085>, <3757, 3771, 3679>, <3757, 3679, 3665>,
			<3966, 3965, 4064>, <3966, 4064, 4065>, <4064, 4032, 4033>, <4064, 4033, 4065>,
			<3965, 3917, 4032>, <3965, 4032, 4064>, <4065, 4033, 3918>, <4065, 3918, 3966>,
			<3968, 3967, 4066>, <3968, 4066, 4067>, <4066, 4034, 4035>, <4066, 4035, 4067>,
			<3967, 3919, 4034>, <3967, 4034, 4066>, <4067, 4035, 3920>, <4067, 3920, 3968>,
			<3855, 3856, 3739>, <3855, 3739, 3738>, <3739, 3707, 3706>, <3739, 3706, 3738>,
			<3856, 3808, 3707>, <3856, 3707, 3739>, <3738, 3706, 3807>, <3738, 3807, 3855>,
			<3853, 3854, 3737>, <3853, 3737, 3736>, <3737, 3705, 3704>, <3737, 3704, 3736>,
			<3854, 3806, 3705>, <3854, 3705, 3737>, <3736, 3704, 3805>, <3736, 3805, 3853>,
			<3857, 3852, 3884>, <3857, 3884, 3885>, <3964, 3969, 3885>, <3964, 3885, 3884>,
			<3806, 3854, 3855>, <3806, 3855, 3807>, <3918, 3966, 3967>, <3918, 3967, 3919>,
			<3804, 3805, 3853>, <3804, 3853, 3852>, <3804, 3852, 3773>, <3804, 3773, 3759>,
			<3916, 3917, 3965>, <3916, 3965, 3964>, <3916, 3964, 4009>, <3916, 4009, 3995>,
			<3921, 3920, 3968>, <3921, 3968, 3969>, <3921, 3969, 4010>, <3921, 4010, 3996>,
			<3809, 3808, 3856>, <3809, 3856, 3857>, <3809, 3857, 3774>, <3809, 3774, 3760>,
			<3760, 3774, 3682>, <3760, 3682, 3668>, <3996, 4010, 4102>, <3996, 4102, 4088>,
			<3995, 4009, 4101>, <3995, 4101, 4087>, <3759, 3773, 3681>, <3759, 3681, 3667>,
			<3972, 3971, 4068>, <3972, 4068, 4069>, <4068, 4036, 4037>, <4068, 4037, 4069>,
			<3971, 3923, 4036>, <3971, 4036, 4068>, <4069, 4037, 3924>, <4069, 3924, 3972>,
			<3974, 3973, 4070>, <3974, 4070, 4071>, <4070, 4038, 4039>, <4070, 4039, 4071>,
			<3973, 3925, 4038>, <3973, 4038, 4070>, <4071, 4039, 3926>, <4071, 3926, 3974>,
			<3861, 3862, 3743>, <3861, 3743, 3742>, <3743, 3711, 3710>, <3743, 3710, 3742>,
			<3862, 3814, 3711>, <3862, 3711, 3743>, <3742, 3710, 3813>, <3742, 3813, 3861>,
			<3859, 3860, 3741>, <3859, 3741, 3740>, <3741, 3709, 3708>, <3741, 3708, 3740>,
			<3860, 3812, 3709>, <3860, 3709, 3741>, <3740, 3708, 3811>, <3740, 3811, 3859>,
			<3863, 3858, 3886>, <3863, 3886, 3887>, <3970, 3975, 3887>, <3970, 3887, 3886>,
			<3812, 3860, 3861>, <3812, 3861, 3813>, <3924, 3972, 3973>, <3924, 3973, 3925>,
			<3810, 3811, 3859>, <3810, 3859, 3858>, <3810, 3858, 3775>, <3810, 3775, 3761>,
			<3922, 3923, 3971>, <3922, 3971, 3970>, <3922, 3970, 4011>, <3922, 4011, 3997>,
			<3927, 3926, 3974>, <3927, 3974, 3975>, <3927, 3975, 4012>, <3927, 4012, 3998>,
			<3815, 3814, 3862>, <3815, 3862, 3863>, <3815, 3863, 3776>, <3815, 3776, 3762>,
			<3762, 3776, 3684>, <3762, 3684, 3670>, <3998, 4012, 4104>, <3998, 4104, 4090>,
			<3997, 4011, 4103>, <3997, 4103, 4089>, <3761, 3775, 3683>, <3761, 3683, 3669>,
			<3978, 3977, 4072>, <3978, 4072, 4073>, <4072, 4040, 4041>, <4072, 4041, 4073>,
			<3977, 3929, 4040>, <3977, 4040, 4072>, <4073, 4041, 3930>, <4073, 3930, 3978>,
			<3980, 3979, 4074>, <3980, 4074, 4075>, <4074, 4042, 4043>, <4074, 4043, 4075>,
			<3979, 3931, 4042>, <3979, 4042, 4074>, <4075, 4043, 3932>, <4075, 3932, 3980>,
			<3867, 3868, 3747>, <3867, 3747, 3746>, <3747, 3715, 3714>, <3747, 3714, 3746>,
			<3868, 3820, 3715>, <3868, 3715, 3747>, <3746, 3714, 3819>, <3746, 3819, 3867>,
			<3865, 3866, 3745>, <3865, 3745, 3744>, <3745, 3713, 3712>, <3745, 3712, 3744>,
			<3866, 3818, 3713>, <3866, 3713, 3745>, <3744, 3712, 3817>, <3744, 3817, 3865>,
			<3869, 3864, 3888>, <3869, 3888, 3889>, <3976, 3981, 3889>, <3976, 3889, 3888>,
			<3818, 3866, 3867>, <3818, 3867, 3819>, <3930, 3978, 3979>, <3930, 3979, 3931>,
			<3816, 3817, 3865>, <3816, 3865, 3864>, <3816, 3864, 3777>, <3816, 3777, 3763>,
			<3928, 3929, 3977>, <3928, 3977, 3976>, <3928, 3976, 4013>, <3928, 4013, 3999>,
			<3933, 3932, 3980>, <3933, 3980, 3981>, <3933, 3981, 4014>, <3933, 4014, 4000>,
			<3821, 3820, 3868>, <3821, 3868, 3869>, <3821, 3869, 3778>, <3821, 3778, 3764>,
			<3764, 3778, 3686>, <3764, 3686, 3672>, <4000, 4014, 4106>, <4000, 4106, 4092>,
			<3999, 4013, 4105>, <3999, 4105, 4091>, <3763, 3777, 3685>, <3763, 3685, 3671>,
			<3082, 3081, 3242>, <3082, 3242, 3243>, <3242, 3210, 3211>, <3242, 3211, 3243>,
			<3081, 3045, 3210>, <3081, 3210, 3242>, <3243, 3211, 3046>, <3243, 3046, 3082>,
			<3084, 3083, 3244>, <3084, 3244, 3245>, <3244, 3212, 3213>, <3244, 3213, 3245>,
			<3083, 3047, 3212>, <3083, 3212, 3244>, <3245, 3213, 3048>, <3245, 3048, 3084>,
			<2929, 2930, 2833>, <2929, 2833, 2832>, <2833, 2801, 2800>, <2833, 2800, 2832>,
			<2930, 2894, 2801>, <2930, 2801, 2833>, <2832, 2800, 2893>, <2832, 2893, 2929>,
			<2927, 2928, 2831>, <2927, 2831, 2830>, <2831, 2799, 2798>, <2831, 2798, 2830>,
			<2928, 2892, 2799>, <2928, 2799, 2831>, <2830, 2798, 2891>, <2830, 2891, 2927>,
			<2931, 2926, 3026>, <2931, 3026, 3027>, <3080, 3085, 3027>, <3080, 3027, 3026>,
			<2892, 2928, 2929>, <2892, 2929, 2893>, <3046, 3082, 3083>, <3046, 3083, 3047>,
			<2970, 2971, 2999>, <2970, 2999, 2998>, <2970, 2998, 2873>, <2970, 2873, 2859>,
			<3124, 3125, 3153>, <3124, 3153, 3152>, <3124, 3152, 3193>, <3124, 3193, 3179>,
			<3127, 3126, 3154>, <3127, 3154, 3155>, <3127, 3155, 3194>, <3127, 3194, 3180>,
			<2973, 2972, 3000>, <2973, 3000, 3001>, <2973, 3001, 2874>, <2973, 2874, 2860>,
			<2860, 2874, 2782>, <2860, 2782, 2768>, <3180, 3194, 3286>, <3180, 3286, 3272>,
			<3179, 3193, 3285>, <3179, 3285, 3271>, <2859, 2873, 2781>, <2859, 2781, 2767>,
			<3088, 3087, 3246>, <3088, 3246, 3247>, <3246, 3214, 3215>, <3246, 3215, 3247>,
			<3087, 3049, 3214>, <3087, 3214, 3246>, <3247, 3215, 3050>, <3247, 3050, 3088>,
			<3090, 3089, 3248>, <3090, 3248, 3249>, <3248, 3216, 3217>, <3248, 3217, 3249>,
			<3089, 3051, 3216>, <3089, 3216, 3248>, <3249, 3217, 3052>, <3249, 3052, 3090>,
			<2935, 2936, 2837>, <2935, 2837, 2836>, <2837, 2805, 2804>, <2837, 2804, 2836>,
			<2936, 2898, 2805>, <2936, 2805, 2837>, <2836, 2804, 2897>, <2836, 2897, 2935>,
			<2933, 2934, 2835>, <2933, 2835, 2834>, <2835, 2803, 2802>, <2835, 2802, 2834>,
			<2934, 2896, 2803>, <2934, 2803, 2835>, <2834, 2802, 2895>, <2834, 2895, 2933>,
			<2937, 2932, 3028>, <2937, 3028, 3029>, <3086, 3091, 3029>, <3086, 3029, 3028>,
			<2896, 2934, 2935>, <2896, 2935, 2897>, <3050, 3088, 3089>, <3050, 3089, 3051>,
			<2974, 2975, 3003>, <2974, 3003, 3002>, <2974, 3002, 2875>, <2974, 2875, 2861>,
			<3128, 3129, 3157>, <3128, 3157, 3156>, <3128, 3156, 3195>, <3128, 3195, 3181>,
			<3131, 3130, 3158>, <3131, 3158, 3159>, <3131, 3159, 3196>, <3131, 3196, 3182>,
			<2977, 2976, 3004>, <2977, 3004, 3005>, <2977, 3005, 2876>, <2977, 2876, 2862>,
			<2862, 2876, 2784>, <2862, 2784, 2770>, <3182, 3196, 3288>, <3182, 3288, 3274>,
			<3181, 3195, 3287>, <3181, 3287, 3273>, <2861, 2875, 2783>, <2861, 2783, 2769>,
			<3094, 3093, 3250>, <3094, 3250, 3251>, <3250, 3218, 3219>, <3250, 3219, 3251>,
			<3093, 3053, 3218>, <3093, 3218, 3250>, <3251, 3219, 3054>, <3251, 3054, 3094>,
			<3096, 3095, 3252>, <3096, 3252, 3253>, <3252, 3220, 3221>, <3252, 3221, 3253>,
			<3095, 3055, 3220>, <3095, 3220, 3252>, <3253, 3221, 3056>, <3253, 3056, 3096>,
			<2941, 2942, 2841>, <2941, 2841, 2840>, <2841, 2809, 2808>, <2841, 2808, 2840>,
			<2942, 2902, 2809>, <2942, 2809, 2841>, <2840, 2808, 2901>, <2840, 2901, 2941>,
			<2939, 2940, 2839>, <2939, 2839, 2838>, <2839, 2807, 2806>, <2839, 2806, 2838>,
			<2940, 2900, 2807>, <2940, 2807, 2839>, <2838, 2806, 2899>, <2838, 2899, 2939>,
			<2943, 2938, 3030>, <2943, 3030, 3031>, <3092, 3097, 3031>, <3092, 3031, 3030>,
			<2900, 2940, 2941>, <2900, 2941, 2901>, <3054, 3094, 3095>, <3054, 3095, 3055>,
			<2978, 2979, 3007>, <2978, 3007, 3006>, <2978, 3006, 2877>, <2978, 2877, 2863>,
			<3132, 3133, 3161>, <3132, 3161, 3160>, <3132, 3160, 3197>, <3132, 3197, 3183>,
			<3135, 3134, 3162>, <3135, 3162, 3163>, <3135, 3163, 3198>, <3135, 3198, 3184>,
			<2981, 2980, 3008>, <2981, 3008, 3009>, <2981, 3009, 2878>, <2981, 2878, 2864>,
			<2864, 2878, 2786>, <2864, 2786, 2772>, <3184, 3198, 3290>, <3184, 3290, 3276>,
			<3183, 3197, 3289>, <3183, 3289, 3275>, <2863, 2877, 2785>, <2863, 2785, 2771>,
			<3100, 3099, 3254>, <3100, 3254, 3255>, <3254, 3222, 3223>, <3254, 3223, 3255>,
			<3099, 3057, 3222>, <3099, 3222, 3254>, <3255, 3223, 3058>, <3255, 3058, 3100>,
			<3102, 3101, 3256>, <3102, 3256, 3257>, <3256, 3224, 3225>, <3256, 3225, 3257>,
			<3101, 3059, 3224>, <3101, 3224, 3256>, <3257, 3225, 3060>, <3257, 3060, 3102>,
			<2947, 2948, 2845>, <2947, 2845, 2844>, <2845, 2813, 2812>, <2845, 2812, 2844>,
			<2948, 2906, 2813>, <2948, 2813, 2845>, <2844, 2812, 2905>, <2844, 2905, 2947>,
			<2945, 2946, 2843>, <2945, 2843, 2842>, <2843, 2811, 2810>, <2843, 2810, 2842>,
			<2946, 2904, 2811>, <2946, 2811, 2843>, <2842, 2810, 2903>, <2842, 2903, 2945>,
			<2949, 2944, 3032>, <2949, 3032, 3033>, <3098, 3103, 3033>, <3098, 3033, 3032>,
			<2904, 2946, 2947>, <2904, 2947, 2905>, <3058, 3100, 3101>, <3058, 3101, 3059>,
			<2982, 2983, 3011>, <2982, 3011, 3010>, <2982, 3010, 2879>, <2982, 2879, 2865>,
			<3136, 3137, 3165>, <3136, 3165, 3164>, <3136, 3164, 3199>, <3136, 3199, 3185>,
			<3139, 3138, 3166>, <3139, 3166, 3167>, <3139, 3167, 3200>, <3139, 3200, 3186>,
			<2985, 2984, 3012>, <2985, 3012, 3013>, <2985, 3013, 2880>, <2985, 2880, 2866>,
			<2866, 2880, 2788>, <2866, 2788, 2774>, <3186, 3200, 3292>, <3186, 3292, 3278>,
			<3185, 3199, 3291>, <3185, 3291, 3277>, <2865, 2879, 2787>, <2865, 2787, 2773>,
			<3106, 3105, 3258>, <3106, 3258, 3259>, <3258, 3226, 3227>, <3258, 3227, 3259>,
			<3105, 3061, 3226>, <3105, 3226, 3258>, <3259, 3227, 3062>, <3259, 3062, 3106>,
			<3108, 3107, 3260>, <3108, 3260, 3261>, <3260, 3228, 3229>, <3260, 3229, 3261>,
			<3107, 3063, 3228>, <3107, 3228, 3260>, <3261, 3229, 3064>, <3261, 3064, 3108>,
			<2953, 2954, 2849>, <2953, 2849, 2848>, <2849, 2817, 2816>, <2849, 2816, 2848>,
			<2954, 2910, 2817>, <2954, 2817, 2849>, <2848, 2816, 2909>, <2848, 2909, 2953>,
			<2951, 2952, 2847>, <2951, 2847, 2846>, <2847, 2815, 2814>, <2847, 2814, 2846>,
			<2952, 2908, 2815>, <2952, 2815, 2847>, <2846, 2814, 2907>, <2846, 2907, 2951>,
			<2955, 2950, 3034>, <2955, 3034, 3035>, <3104, 3109, 3035>, <3104, 3035, 3034>,
			<2908, 2952, 2953>, <2908, 2953, 2909>, <3062, 3106, 3107>, <3062, 3107, 3063>,
			<2986, 2987, 3015>, <2986, 3015, 3014>, <2986, 3014, 2881>, <2986, 2881, 2867>,
			<3140, 3141, 3169>, <3140, 3169, 3168>, <3140, 3168, 3201>, <3140, 3201, 3187>,
			<3143, 3142, 3170>, <3143, 3170, 3171>, <3143, 3171, 3202>, <3143, 3202, 3188>,
			<2989, 2988, 3016>, <2989, 3016, 3017>, <2989, 3017, 2882>, <2989, 2882, 2868>,
			<2868, 2882, 2790>, <2868, 2790, 2776>, <3188, 3202, 3294>, <3188, 3294, 3280>,
			<3187, 3201, 3293>, <3187, 3293, 3279>, <2867, 2881, 2789>, <2867, 2789, 2775>,
			<3112, 3111, 3262>, <3112, 3262, 3263>, <3262, 3230, 3231>, <3262, 3231, 3263>,
			<3111, 3065, 3230>, <3111, 3230, 3262>, <3263, 3231, 3066>, <3263, 3066, 3112>,
			<3114, 3113, 3264>, <3114, 3264, 3265>, <3264, 3232, 3233>, <3264, 3233, 3265>,
			<3113, 3067, 3232>, <3113, 3232, 3264>, <3265, 3233, 3068>, <3265, 3068, 3114>,
			<2959, 2960, 2853>, <2959, 2853, 2852>, <2853, 2821, 2820>, <2853, 2820, 2852>,
			<2960, 2914, 2821>, <2960, 2821, 2853>, <2852, 2820, 2913>, <2852, 2913, 2959>,
			<2957, 2958, 2851>, <2957, 2851, 2850>, <2851, 2819, 2818>, <2851, 2818, 2850>,
			<2958, 2912, 2819>, <2958, 2819, 2851>, <2850, 2818, 2911>, <2850, 2911, 2957>,
			<2961, 2956, 3036>, <2961, 3036, 3037>, <3110, 3115, 3037>, <3110, 3037, 3036>,
			<2912, 2958, 2959>, <2912, 2959, 2913>, <3066, 3112, 3113>, <3066, 3113, 3067>,
			<2990, 2991, 3019>, <2990, 3019, 3018>, <2990, 3018, 2883>, <2990, 2883, 2869>,
			<3144, 3145, 3173>, <3144, 3173, 3172>, <3144, 3172, 3203>, <3144, 3203, 3189>,
			<3147, 3146, 3174>, <3147, 3174, 3175>, <3147, 3175, 3204>, <3147, 3204, 3190>,
			<2993, 2992, 3020>, <2993, 3020, 3021>, <2993, 3021, 2884>, <2993, 2884, 2870>,
			<2870, 2884, 2792>, <2870, 2792, 2778>, <3190, 3204, 3296>, <3190, 3296, 3282>,
			<3189, 3203, 3295>, <3189, 3295, 3281>, <2869, 2883, 2791>, <2869, 2791, 2777>,
			<2244, 2243, 2348>, <2244, 2348, 2349>, <2348, 2316, 2317>, <2348, 2317, 2349>,
			<2243, 2195, 2316>, <2243, 2316, 2348>, <2349, 2317, 2196>, <2349, 2196, 2244>,
			<2246, 2245, 2350>, <2246, 2350, 2351>, <2350, 2318, 2319>, <2350, 2319, 2351>,
			<2245, 2197, 2318>, <2245, 2318, 2350>, <2351, 2319, 2198>, <2351, 2198, 2246>,
			<2133, 2134, 2023>, <2133, 2023, 2022>, <2023, 1991, 1990>, <2023, 1990, 2022>,
			<2134, 2086, 1991>, <2134, 1991, 2023>, <2022, 1990, 2085>, <2022, 2085, 2133>,
			<2131, 2132, 2021>, <2131, 2021, 2020>, <2021, 1989, 1988>, <2021, 1988, 2020>,
			<2132, 2084, 1989>, <2132, 1989, 2021>, <2020, 1988, 2083>, <2020, 2083, 2131>,
			<2135, 2130, 2174>, <2135, 2174, 2175>, <2242, 2247, 2175>, <2242, 2175, 2174>,
			<2084, 2132, 2133>, <2084, 2133, 2085>, <2196, 2244, 2245>, <2196, 2245, 2197>,
			<2082, 2083, 2131>, <2082, 2131, 2130>, <2082, 2130, 2063>, <2082, 2063, 2049>,
			<2194, 2195, 2243>, <2194, 2243, 2242>, <2194, 2242, 2299>, <2194, 2299, 2285>,
			<2199, 2198, 2246>, <2199, 2246, 2247>, <2199, 2247, 2300>, <2199, 2300, 2286>,
			<2087, 2086, 2134>, <2087, 2134, 2135>, <2087, 2135, 2064>, <2087, 2064, 2050>,
			<2050, 2064, 1972>, <2050, 1972, 1958>, <2286, 2300, 2392>, <2286, 2392, 2378>,
			<2285, 2299, 2391>, <2285, 2391, 2377>, <2049, 2063, 1971>, <2049, 1971, 1957>,
			<2250, 2249, 2352>, <2250, 2352, 2353>, <2352, 2320, 2321>, <2352, 2321, 2353>,
			<2249, 2201, 2320>, <2249, 2320, 2352>, <2353, 2321, 2202>, <2353, 2202, 2250>,
			<2252, 2251, 2354>, <2252, 2354, 2355>, <2354, 2322, 2323>, <2354, 2323, 2355>,
			<2251, 2203, 2322>, <2251, 2322, 2354>, <2355, 2323, 2204>, <2355, 2204, 2252>,
			<2139, 2140, 2027>, <2139, 2027, 2026>, <2027, 1995, 1994>, <2027, 1994, 2026>,
			<2140, 2092, 1995>, <2140, 1995, 2027>, <2026, 1994, 2091>, <2026, 2091, 2139>,
			<2137, 2138, 2025>, <2137, 2025, 2024>, <2025, 1993, 1992>, <2025, 1992, 2024>,
			<2138, 2090, 1993>, <2138, 1993, 2025>, <2024, 1992, 2089>, <2024, 2089, 2137>,
			<2141, 2136, 2176>, <2141, 2176, 2177>, <2248, 2253, 2177>, <2248, 2177, 2176>,
			<2090, 2138, 2139>, <2090, 2139, 2091>, <2202, 2250, 2251>, <2202, 2251, 2203>,
			<2088, 2089, 2137>, <2088, 2137, 2136>, <2088, 2136, 2065>, <2088, 2065, 2051>,
			<2200, 2201, 2249>, <2200, 2249, 2248>, <2200, 2248, 2301>, <2200, 2301, 2287>,
			<2205, 2204, 2252>, <2205, 2252, 2253>, <2205, 2253, 2302>, <2205, 2302, 2288>,
			<2093, 2092, 2140>, <2093, 2140, 2141>, <2093, 2141, 2066>, <2093, 2066, 2052>,
			<2052, 2066, 1974>, <2052, 1974, 1960>, <2288, 2302, 2394>, <2288, 2394, 2380>,
			<2287, 2301, 2393>, <2287, 2393, 2379>, <2051, 2065, 1973>, <2051, 1973, 1959>,
			<2256, 2255, 2356>, <2256, 2356, 2357>, <2356, 2324, 2325>, <2356, 2325, 2357>,
			<2255, 2207, 2324>, <2255, 2324, 2356>, <2357, 2325, 2208>, <2357, 2208, 2256>,
			<2258, 2257, 2358>, <2258, 2358, 2359>, <2358, 2326, 2327>, <2358, 2327, 2359>,
			<2257, 2209, 2326>, <2257, 2326, 2358>, <2359, 2327, 2210>, <2359, 2210, 2258>,
			<2145, 2146, 2031>, <2145, 2031, 2030>, <2031, 1999, 1998>, <2031, 1998, 2030>,
			<2146, 2098, 1999>, <2146, 1999, 2031>, <2030, 1998, 2097>, <2030, 2097, 2145>,
			<2143, 2144, 2029>, <2143, 2029, 2028>, <2029, 1997, 1996>, <2029, 1996, 2028>,
			<2144, 2096, 1997>, <2144, 1997, 2029>, <2028, 1996, 2095>, <2028, 2095, 2143>,
			<2147, 2142, 2178>, <2147, 2178, 2179>, <2254, 2259, 2179>, <2254, 2179, 2178>,
			<2096, 2144, 2145>, <2096, 2145, 2097>, <2208, 2256, 2257>, <2208, 2257, 2209>,
			<2094, 2095, 2143>, <2094, 2143, 2142>, <2094, 2142, 2067>, <2094, 2067, 2053>,
			<2206, 2207, 2255>, <2206, 2255, 2254>, <2206, 2254, 2303>, <2206, 2303, 2289>,
			<2211, 2210, 2258>, <2211, 2258, 2259>, <2211, 2259, 2304>, <2211, 2304, 2290>,
			<2099, 2098, 2146>, <2099, 2146, 2147>, <2099, 2147, 2068>, <2099, 2068, 2054>,
			<2054, 2068, 1976>, <2054, 1976, 1962>, <2290, 2304, 2396>, <2290, 2396, 2382>,
			<2289, 2303, 2395>, <2289, 2395, 2381>, <2053, 2067, 1975>, <2053, 1975, 1961>,
			<2262, 2261, 2360>, <2262, 2360, 2361>, <2360, 2328, 2329>, <2360, 2329, 2361>,
			<2261, 2213, 2328>, <2261, 2328, 2360>, <2361, 2329, 2214>, <2361, 2214, 2262>,
			<2264, 2263, 2362>, <2264, 2362, 2363>, <2362, 2330, 2331>, <2362, 2331, 2363>,
			<2263, 2215, 2330>, <2263, 2330, 2362>, <2363, 2331, 2216>, <2363, 2216, 2264>,
			<2151, 2152, 2035>, <2151, 2035, 2034>, <2035, 2003, 2002>, <2035, 2002, 2034>,
			<2152, 2104, 2003>, <2152, 2003, 2035>, <2034, 2002, 2103>, <2034, 2103, 2151>,
			<2149, 2150, 2033>, <2149, 2033, 2032>, <2033, 2001, 2000>, <2033, 2000, 2032>,
			<2150, 2102, 2001>, <2150, 2001, 2033>, <2032, 2000, 2101>, <2032, 2101, 2149>,
			<2153, 2148, 2180>, <2153, 2180, 2181>, <2260, 2265, 2181>, <2260, 2181, 2180>,
			<2102, 2150, 2151>, <2102, 2151, 2103>, <2214, 2262, 2263>, <2214, 2263, 2215>,
			<2100, 2101, 2149>, <2100, 2149, 2148>, <2100, 2148, 2069>, <2100, 2069, 2055>,
			<2212, 2213, 2261>, <2212, 2261, 2260>, <2212, 2260, 2305>, <2212, 2305, 2291>,
			<2217, 2216, 2264>, <2217, 2264, 2265>, <2217, 2265, 2306>, <2217, 2306, 2292>,
			<2105, 2104, 2152>, <2105, 2152, 2153>, <2105, 2153, 2070>, <2105, 2070, 2056>,
			<2056, 2070, 1978>, <2056, 1978, 1964>, <2292, 2306, 2398>, <2292, 2398, 2384>,
			<2291, 2305, 2397>, <2291, 2397, 2383>, <2055, 2069, 1977>, <2055, 1977, 1963>,
			<2268, 2267, 2364>, <2268, 2364, 2365>, <2364, 2332, 2333>, <2364, 2333, 2365>,
			<2267, 2219, 2332>, <2267, 2332, 2364>, <2365, 2333, 2220>, <2365, 2220, 2268>,
			<2270, 2269, 2366>, <2270, 2366, 2367>, <2366, 2334, 2335>, <2366, 2335, 2367>,
			<2269, 2221, 2334>, <2269, 2334, 2366>, <2367, 2335, 2222>, <2367, 2222, 2270>,
			<2157, 2158, 2039>, <2157, 2039, 2038>, <2039, 2007, 2006>, <2039, 2006, 2038>,
			<2158, 2110, 2007>, <2158, 2007, 2039>, <2038, 2006, 2109>, <2038, 2109, 2157>,
			<2155, 2156, 2037>, <2155, 2037, 2036>, <2037, 2005, 2004>, <2037, 2004, 2036>,
			<2156, 2108, 2005>, <2156, 2005, 2037>, <2036, 2004, 2107>, <2036, 2107, 2155>,
			<2159, 2154, 2182>, <2159, 2182, 2183>, <2266, 2271, 2183>, <2266, 2183, 2182>,
			<2108, 2156, 2157>, <2108, 2157, 2109>, <2220, 2268, 2269>, <2220, 2269, 2221>,
			<2106, 2107, 2155>, <2106, 2155, 2154>, <2106, 2154, 2071>, <2106, 2071, 2057>,
			<2218, 2219, 2267>, <2218, 2267, 2266>, <2218, 2266, 2307>, <2218, 2307, 2293>,
			<2223, 2222, 2270>, <2223, 2270, 2271>, <2223, 2271, 2308>, <2223, 2308, 2294>,
			<2111, 2110, 2158>, <2111, 2158, 2159>, <2111, 2159, 2072>, <2111, 2072, 2058>,
			<2058, 2072, 1980>, <2058, 1980, 1966>, <2294, 2308, 2400>, <2294, 2400, 2386>,
			<2293, 2307, 2399>, <2293, 2399, 2385>, <2057, 2071, 1979>, <2057, 1979, 1965>,
			<2274, 2273, 2368>, <2274, 2368, 2369>, <2368, 2336, 2337>, <2368, 2337, 2369>,
			<2273, 2225, 2336>, <2273, 2336, 2368>, <2369, 2337, 2226>, <2369, 2226, 2274>,
			<2276, 2275, 2370>, <2276, 2370, 2371>, <2370, 2338, 2339>, <2370, 2339, 2371>,
			<2275, 2227, 2338>, <2275, 2338, 2370>, <2371, 2339, 2228>, <2371, 2228, 2276>,
			<2163, 2164, 2043>, <2163, 2043, 2042>, <2043, 2011, 2010>, <2043, 2010, 2042>,
			<2164, 2116, 2011>, <2164, 2011, 2043>, <2042, 2010, 2115>, <2042, 2115, 2163>,
			<2161, 2162, 2041>, <2161, 2041, 2040>, <2041, 2009, 2008>, <2041, 2008, 2040>,
			<2162, 2114, 2009>, <2162, 2009, 2041>, <2040, 2008, 2113>, <2040, 2113, 2161>,
			<2165, 2160, 2184>, <2165, 2184, 2185>, <2272, 2277, 2185>, <2272, 2185, 2184>,
			<2114, 2162, 2163>, <2114, 2163, 2115>, <2226, 2274, 2275>, <2226, 2275, 2227>,
			<2112, 2113, 2161>, <2112, 2161, 2160>, <2112, 2160, 2073>, <2112, 2073, 2059>,
			<2224, 2225, 2273>, <2224, 2273, 2272>, <2224, 2272, 2309>, <2224, 2309, 2295>,
			<2229, 2228, 2276>, <2229, 2276, 2277>, <2229, 2277, 2310>, <2229, 2310, 2296>,
			<2117, 2116, 2164>, <2117, 2164, 2165>, <2117, 2165, 2074>, <2117, 2074, 2060>,
			<2060, 2074, 1982>, <2060, 1982, 1968>, <2296, 2310, 2402>, <2296, 2402, 2388>,
			<2295, 2309, 2401>, <2295, 2401, 2387>, <2059, 2073, 1981>, <2059, 1981, 1967>,
			<1434, 1433, 1538>, <1434, 1538, 1539>, <1538, 1506, 1507>, <1538, 1507, 1539>,
			<1433, 1385, 1506>, <1433, 1506, 1538>, <1539, 1507, 1386>, <1539, 1386, 1434>,
			<1436, 1435, 1540>, <1436, 1540, 1541>, <1540, 1508, 1509>, <1540, 1509, 1541>,
			<1435, 1387, 1508>, <1435, 1508, 1540>, <1541, 1509, 1388>, <1541, 1388, 1436>,
			<1323, 1324, 1213>, <1323, 1213, 1212>, <1213, 1181, 1180>, <1213, 1180, 1212>,
			<1324, 1276, 1181>, <1324, 1181, 1213>, <1212, 1180, 1275>, <1212, 1275, 1323>,
			<1321, 1322, 1211>, <1321, 1211, 1210>, <1211, 1179, 1178>, <1211, 1178, 1210>,
			<1322, 1274, 1179>, <1322, 1179, 1211>, <1210, 1178, 1273>, <1210, 1273, 1321>,
			<1325, 1320, 1364>, <1325, 1364, 1365>, <1432, 1437, 1365>, <1432, 1365, 1364>,
			<1274, 1322, 1323>, <1274, 1323, 1275>, <1386, 1434, 1435>, <1386, 1435, 1387>,
			<1272, 1273, 1321>, <1272, 1321, 1320>, <1272, 1320, 1253>, <1272, 1253, 1239>,
			<1384, 1385, 1433>, <1384, 1433, 1432>, <1384, 1432, 1489>, <1384, 1489, 1475>,
			<1389, 1388, 1436>, <1389, 1436, 1437>, <1389, 1437, 1490>, <1389, 1490, 1476>,
			<1277, 1276, 1324>, <1277, 1324, 1325>, <1277, 1325, 1254>, <1277, 1254, 1240>,
			<1240, 1254, 1162>, <1240, 1162, 1148>, <1476, 1490, 1582>, <1476, 1582, 1568>,
			<1475, 1489, 1581>, <1475, 1581, 1567>, <1239, 1253, 1161>, <1239, 1161, 1147>,
			<1440, 1439, 1542>, <1440, 1542, 1543>, <1542, 1510, 1511>, <1542, 1511, 1543>,
			<1439, 1391, 1510>, <1439, 1510, 1542>, <1543, 1511, 1392>, <1543, 1392, 1440>,
			<1442, 1441, 1544>, <1442, 1544, 1545>, <1544, 1512, 1513>, <1544, 1513, 1545>,
			<1441, 1393, 1512>, <1441, 1512, 1544>, <1545, 1513, 1394>, <1545, 1394, 1442>,
			<1329, 1330, 1217>, <1329, 1217, 1216>, <1217, 1185, 1184>, <1217, 1184, 1216>,
			<1330, 1282, 1185>, <1330, 1185, 1217>, <1216, 1184, 1281>, <1216, 1281, 1329>,
			<1327, 1328, 1215>, <1327, 1215, 1214>, <1215, 1183, 1182>, <1215, 1182, 1214>,
			<1328, 1280, 1183>, <1328, 1183, 1215>, <1214, 1182, 1279>, <1214, 1279, 1327>,
			<1331, 1326, 1366>, <1331, 1366, 1367>, <1438, 1443, 1367>, <1438, 1367, 1366>,
			<1280, 1328, 1329>, <1280, 1329, 1281>, <1392, 1440, 1441>, <1392, 1441, 1393>,
			<1278, 1279, 1327>, <1278, 1327, 1326>, <1278, 1326, 1255>, <1278, 1255, 1241>,
			<1390, 1391, 1439>, <1390, 1439, 1438>, <1390, 1438, 1491>, <1390, 1491, 1477>,
			<1395, 1394, 1442>, <1395, 1442, 1443>, <1395, 1443, 1492>, <1395, 1492, 1478>,
			<1283, 1282, 1330>, <1283, 1330, 1331>, <1283, 1331, 1256>, <1283, 1256, 1242>,
			<1242, 1256, 1164>, <1242, 1164, 1150>, <1478, 1492, 1584>, <1478, 1584, 1570>,
			<1477, 1491, 1583>, <1477, 1583, 1569>, <1241, 1255, 1163>, <1241, 1163, 1149>,
			<1446, 1445, 1546>, <1446, 1546, 1547>, <1546, 1514, 1515>, <1546, 1515, 1547>,
			<1445, 1397, 1514>, <1445, 1514, 1546>, <1547, 1515, 1398>, <1547, 1398, 1446>,
			<1448, 1447, 1548>, <1448, 1548, 1549>, <1548, 1516, 1517>, <1548, 1517, 1549>,
			<1447, 1399, 1516>, <1447, 1516, 1548>, <1549, 1517, 1400>, <1549, 1400, 1448>,
			<1335, 1336, 1221>, <1335, 1221, 1220>, <1221, 1189, 1188>, <1221, 1188, 1220>,
			<1336, 1288, 1189>, <1336, 1189, 1221>, <1220, 1188, 1287>, <1220, 1287, 1335>,
			<1333, 1334, 1219>, <1333, 1219, 1218>, <1219, 1187, 1186>, <1219, 1186, 1218>,
			<1334, 1286, 1187>, <1334, 1187, 1219>, <1218, 1186, 1285>, <1218, 1285, 1333>,
			<1337, 1332, 1368>, <1337, 1368, 1369>, <1444, 1449, 1369>, <1444, 1369, 1368>,
			<1286, 1334, 1335>, <1286, 1335, 1287>, <1398, 1446, 1447>, <1398, 1447, 1399>,
			<1284, 1285, 1333>, <1284, 1333, 1332>, <1284, 1332, 1257>, <1284, 1257, 1243>,
			<1396, 1397, 1445>, <1396, 1445, 1444>, <1396, 1444, 1493>, <1396, 1493, 1479>,
			<1401, 1400, 1448>, <1401, 1448, 1449>, <1401, 1449, 1494>, <1401, 1494, 1480>,
			<1289, 1288, 1336>, <1289, 1336, 1337>, <1289, 1337, 1258>, <1289, 1258, 1244>,
			<1244, 1258, 1166>, <1244, 1166, 1152>, <1480, 1494, 1586>, <1480, 1586, 1572>,
			<1479, 1493, 1585>, <1479, 1585, 1571>, <1243, 1257, 1165>, <1243, 1165, 1151>,
			<1452, 1451, 1550>, <1452, 1550, 1551>, <1550, 1518, 1519>, <1550, 1519, 1551>,
			<1451, 1403, 1518>, <1451, 1518, 1550>, <1551, 1519, 1404>, <1551, 1404, 1452>,
			<1454, 1453, 1552>, <1454, 1552, 1553>, <1552, 1520, 1521>, <1552, 1521, 1553>,
			<1453, 1405, 1520>, <1453, 1520, 1552>, <1553, 1521, 1406>, <1553, 1406, 1454>,
			<1341, 1342, 1225>, <1341, 1225, 1224>, <1225, 1193, 1192>, <1225, 1192, 1224>,
			<1342, 1294, 1193>, <1342, 1193, 1225>, <1224, 1192, 1293>, <1224, 1293, 1341>,
			<1339, 1340, 1223>, <1339, 1223, 1222>, <1223, 1191, 1190>, <1223, 1190, 1222>,
			<1340, 1292, 1191>, <1340, 1191, 1223>, <1222, 1190, 1291>, <1222, 1291, 1339>,
			<1343, 1338, 1370>, <1343, 1370, 1371>, <1450, 1455, 1371>, <1450, 1371, 1370>,
			<1292, 1340, 1341>, <1292, 1341, 1293>, <1404, 1452, 1453>, <1404, 1453, 1405>,
			<1290, 1291, 1339>, <1290, 1339, 1338>, <1290, 1338, 1259>, <1290, 1259, 1245>,
			<1402, 1403, 1451>, <1402, 1451, 1450>, <1402, 1450, 1495>, <1402, 1495, 1481>,
			<1407, 1406, 1454>, <1407, 1454, 1455>, <1407, 1455, 1496>, <1407, 1496, 1482>,
			<1295, 1294, 1342>, <1295, 1342, 1343>, <1295, 1343, 1260>, <1295, 1260, 1246>,
			<1246, 1260, 1168>, <1246, 1168, 1154>, <1482, 1496, 1588>, <1482, 1588, 1574>,
			<1481, 1495, 1587>, <1481, 1587, 1573>, <1245, 1259, 1167>, <1245, 1167, 1153>,
			<1458, 1457, 1554>, <1458, 1554, 1555>, <1554, 1522, 1523>, <1554, 1523, 1555>,
			<1457, 1409, 1522>, <1457, 1522, 1554>, <1555, 1523, 1410>, <1555, 1410, 1458>,
			<1460, 1459, 1556>, <1460, 1556, 1557>, <1556, 1524, 1525>, <1556, 1525, 1557>,
			<1459, 1411, 1524>, <1459, 1524, 1556>, <1557, 1525, 1412>, <1557, 1412, 1460>,
			<1347, 1348, 1229>, <1347, 1229, 1228>, <1229, 1197, 1196>, <1229, 1196, 1228>,
			<1348, 1300, 1197>, <1348, 1197, 1229>, <1228, 1196, 1299>, <1228, 1299, 1347>,
			<1345, 1346, 1227>, <1345, 1227, 1226>, <1227, 1195, 1194>, <1227, 1194, 1226>,
			<1346, 1298, 1195>, <1346, 1195, 1227>, <1226, 1194, 1297>, <1226, 1297, 1345>,
			<1349, 1344, 1372>, <1349, 1372, 1373>, <1456, 1461, 1373>, <1456, 1373, 1372>,
			<1298, 1346, 1347>, <1298, 1347, 1299>, <1410, 1458, 1459>, <1410, 1459, 1411>,
			<1296, 1297, 1345>, <1296, 1345, 1344>, <1296, 1344, 1261>, <1296, 1261, 1247>,
			<1408, 1409, 1457>, <1408, 1457, 1456>, <1408, 1456, 1497>, <1408, 1497, 1483>,
			<1413, 1412, 1460>, <1413, 1460, 1461>, <1413, 1461, 1498>, <1413, 1498, 1484>,
			<1301, 1300, 1348>, <1301, 1348, 1349>, <1301, 1349, 1262>, <1301, 1262, 1248>,
			<1248, 1262, 1170>, <1248, 1170, 1156>, <1484, 1498, 1590>, <1484, 1590, 1576>,
			<1483, 1497, 1589>, <1483, 1589, 1575>, <1247, 1261, 1169>, <1247, 1169, 1155>,
			<1464, 1463, 1558>, <1464, 1558, 1559>, <1558, 1526, 1527>, <1558, 1527, 1559>,
			<1463, 1415, 1526>, <1463, 1526, 1558>, <1559, 1527, 1416>, <1559, 1416, 1464>,
			<1466, 1465, 1560>, <1466, 1560, 1561>, <1560, 1528, 1529>, <1560, 1529, 1561>,
			<1465, 1417, 1528>, <1465, 1528, 1560>, <1561, 1529, 1418>, <1561, 1418, 1466>,
			<1353, 1354, 1233>, <1353, 1233, 1232>, <1233, 1201, 1200>, <1233, 1200, 1232>,
			<1354, 1306, 1201>, <1354, 1201, 1233>, <1232, 1200, 1305>, <1232, 1305, 1353>,
			<1351, 1352, 1231>, <1351, 1231, 1230>, <1231, 1199, 1198>, <1231, 1198, 1230>,
			<1352, 1304, 1199>, <1352, 1199, 1231>, <1230, 1198, 1303>, <1230, 1303, 1351>,
			<1355, 1350, 1374>, <1355, 1374, 1375>, <1462, 1467, 1375>, <1462, 1375, 1374>,
			<1304, 1352, 1353>, <1304, 1353, 1305>, <1416, 1464, 1465>, <1416, 1465, 1417>,
			<1302, 1303, 1351>, <1302, 1351, 1350>, <1302, 1350, 1263>, <1302, 1263, 1249>,
			<1414, 1415, 1463>, <1414, 1463, 1462>, <1414, 1462, 1499>, <1414, 1499, 1485>,
			<1419, 1418, 1466>, <1419, 1466, 1467>, <1419, 1467, 1500>, <1419, 1500, 1486>,
			<1307, 1306, 1354>, <1307, 1354, 1355>, <1307, 1355, 1264>, <1307, 1264, 1250>,
			<1250, 1264, 1172>, <1250, 1172, 1158>, <1486, 1500, 1592>, <1486, 1592, 1578>,
			<1485, 1499, 1591>, <1485, 1591, 1577>, <1249, 1263, 1171>, <1249, 1171, 1157>,
			<624, 623, 728>, <624, 728, 729>, <728, 696, 697>, <728, 697, 729>,
			<623, 575, 696>, <623, 696, 728>, <729, 697, 576>, <729, 576, 624>,
			<626, 625, 730>, <626, 730, 731>, <730, 698, 699>, <730, 699, 731>,
			<625, 577, 698>, <625, 698, 730>, <731, 699, 578>, <731, 578, 626>,
			<513, 514, 403>, <513, 403, 402>, <403, 371, 370>, <403, 370, 402>,
			<514, 466, 371>, <514, 371, 403>, <402, 370, 465>, <402, 465, 513>,
			<511, 512, 401>, <511, 401, 400>, <401, 369, 368>, <401, 368, 400>,
			<512, 464, 369>, <512, 369, 401>, <400, 368, 463>, <400, 463, 511>,
			<515, 510, 554>, <515, 554, 555>, <622, 627, 555>, <622, 555, 554>,
			<464, 512, 513>, <464, 513, 465>, <576, 624, 625>, <576, 625, 577>,
			<462, 463, 511>, <462, 511, 510>, <462, 510, 443>, <462, 443, 429>,
			<574, 575, 623>, <574, 623, 622>, <574, 622, 679>, <574, 679, 665>,
			<579, 578, 626>, <579, 626, 627>, <579, 627, 680>, <579, 680, 666>,
			<467, 466, 514>, <467, 514, 515>, <467, 515, 444>, <467, 444, 430>,
			<430, 444, 352>, <430, 352, 338>, <666, 680, 772>, <666, 772, 758>,
			<665, 679, 771>, <665, 771, 757>, <429, 443, 351>, <429, 351, 337>,
			<630, 629, 732>, <630, 732, 733>, <732, 700, 701>, <732, 701, 733>,
			<629, 581, 700>, <629, 700, 732>, <733, 701, 582>, <733, 582, 630>,
			<632, 631, 734>, <632, 734, 735>, <734, 702, 703>, <734, 703, 735>,
			<631, 583, 702>, <631, 702, 734>, <735, 703, 584>, <735, 584, 632>,
			<519, 520, 407>, <519, 407, 406>, <407, 375, 374>, <407, 374, 406>,
			<520, 472, 375>, <520, 375, 407>, <406, 374, 471>, <406, 471, 519>,
			<517, 518, 405>, <517, 405, 404>, <405, 373, 372>, <405, 372, 404>,
			<518, 470, 373>, <518, 373, 405>, <404, 372, 469>, <404, 469, 517>,
			<521, 516, 556>, <521, 556, 557>, <628, 633, 557>, <628, 557, 556>,
			<470, 518, 519>, <470, 519, 471>, <582, 630, 631>, <582, 631, 583>,
			<468, 469, 517>, <468, 517, 516>, <468, 516, 445>, <468, 445, 431>,
			<580, 581, 629>, <580, 629, 628>, <580, 628, 681>, <580, 681, 667>,
			<585, 584, 632>, <585, 632, 633>, <585, 633, 682>, <585, 682, 668>,
			<473, 472, 520>, <473, 520, 521>, <473, 521, 446>, <473, 446, 432>,
			<432, 446, 354>, <432, 354, 340>, <668, 682, 774>, <668, 774, 760>,
			<667, 681, 773>, <667, 773, 759>, <431, 445, 353>, <431, 353, 339>,
			<636, 635, 736>, <636, 736, 737>, <736, 704, 705>, <736, 705, 737>,
			<635, 587, 704>, <635, 704, 736>, <737, 705, 588>, <737, 588, 636>,
			<638, 637, 738>, <638, 738, 739>, <738, 706, 707>, <738, 707, 739>,
			<637, 589, 706>, <637, 706, 738>, <739, 707, 590>, <739, 590, 638>,
			<525, 526, 411>, <525, 411, 410>, <411, 379, 378>, <411, 378, 410>,
			<526, 478, 379>, <526, 379, 411>, <410, 378, 477>, <410, 477, 525>,
			<523, 524, 409>, <523, 409, 408>, <409, 377, 376>, <409, 376, 408>,
			<524, 476, 377>, <524, 377, 409>, <408, 376, 475>, <408, 475, 523>,
			<527, 522, 558>, <527, 558, 559>, <634, 639, 559>, <634, 559, 558>,
			<476, 524, 525>, <476, 525, 477>, <588, 636, 637>, <588, 637, 589>,
			<474, 475, 523>, <474, 523, 522>, <474, 522, 447>, <474, 447, 433>,
			<586, 587, 635>, <586, 635, 634>, <586, 634, 683>, <586, 683, 669>,
			<591, 590, 638>, <591, 638, 639>, <591, 639, 684>, <591, 684, 670>,
			<479, 478, 526>, <479, 526, 527>, <479, 527, 448>, <479, 448, 434>,
			<434, 448, 356>, <434, 356, 342>, <670, 684, 776>, <670, 776, 762>,
			<669, 683, 775>, <669, 775, 761>, <433, 447, 355>, <433, 355, 341>,
			<642, 641, 740>, <642, 740, 741>, <740, 708, 709>, <740, 709, 741>,
			<641, 593, 708>, <641, 708, 740>, <741, 709, 594>, <741, 594, 642>,
			<644, 643, 742>, <644, 742, 743>, <742, 710, 711>, <742, 711, 743>,
			<643, 595, 710>, <643, 710, 742>, <743, 711, 596>, <743, 596, 644>,
			<531, 532, 415>, <531, 415, 414>, <415, 383, 382>, <415, 382, 414>,
			<532, 484, 383>, <532, 383, 415>, <414, 382, 483>, <414, 483, 531>,
			<529, 530, 413>, <529, 413, 412>, <413, 381, 380>, <413, 380, 412>,
			<530, 482, 381>, <530, 381, 413>, <412, 380, 481>, <412, 481, 529>,
			<533, 528, 560>, <533, 560, 561>, <640, 645, 561>, <640, 561, 560>,
			<482, 530, 531>, <482, 531, 483>, <594, 642, 643>, <594, 643, 595>,
			<480, 481, 529>, <480, 529, 528>, <480, 528, 449>, <480, 449, 435>,
			<592, 593, 641>, <592, 641, 640>, <592, 640, 685>, <592, 685, 671>,
			<597, 596, 644>, <597, 644, 645>, <597, 645, 686>, <597, 686, 672>,
			<485, 484, 532>, <485, 532, 533>, <485, 533, 450>, <485, 450, 436>,
			<436, 450, 358>, <436, 358, 344>, <672, 686, 778>, <672, 778, 764>,
			<671, 685, 777>, <671, 777, 763>, <435, 449, 357>, <435, 357, 343>,
			<648, 647, 744>, <648, 744, 745>, <744, 712, 713>, <744, 713, 745>,
			<647, 599, 712>, <647, 712, 744>, <745, 713, 600>, <745, 600, 648>,
			<650, 649, 746>, <650, 746, 747>, <746, 714, 715>, <746, 715, 747>,
			<649, 601, 714>, <649, 714, 746>, <747, 715, 602>, <747, 602, 650>,
			<537, 538, 419>, <537, 419, 418>, <419, 387, 386>, <419, 386, 418>,
			<538, 490, 387>, <538, 387, 419>, <418, 386, 489>, <418, 489, 537>,
			<535, 536, 417>, <535, 417, 416>, <417, 385, 384>, <417, 384, 416>,
			<536, 488, 385>, <536, 385, 417>, <416, 384, 487>, <416, 487, 535>,
			<539, 534, 562>, <539, 562, 563>, <646, 651, 563>, <646, 563, 562>,
			<488, 536, 537>, <488, 537, 489>, <600, 648, 649>, <600, 649, 601>,
			<486, 487, 535>, <486, 535, 534>, <486, 534, 451>, <486, 451, 437>,
			<598, 599, 647>, <598, 647, 646>, <598, 646, 687>, <598, 687, 673>,
			<603, 602, 650>, <603, 650, 651>, <603, 651, 688>, <603, 688, 674>,
			<491, 490, 538>, <491, 538, 539>, <491, 539, 452>, <491, 452, 438>,
			<438, 452, 360>, <438, 360, 346>, <674, 688, 780>, <674, 780, 766>,
			<673, 687, 779>, <673, 779, 765>, <437, 451, 359>, <437, 359, 345>,
			<654, 653, 748>, <654, 748, 749>, <748, 716, 717>, <748, 717, 749>,
			<653, 605, 716>, <653, 716, 748>, <749, 717, 606>, <749, 606, 654>,
			<656, 655, 750>, <656, 750, 751>, <750, 718, 719>, <750, 719, 751>,
			<655, 607, 718>, <655, 718, 750>, <751, 719, 608>, <751, 608, 656>,
			<543, 544, 423>, <543, 423, 422>, <423, 391, 390>, <423, 390, 422>,
			<544, 496, 391>, <544, 391, 423>, <422, 390, 495>, <422, 495, 543>,
			<541, 542, 421>, <541, 421, 420>, <421, 389, 388>, <421, 388, 420>,
			<542, 494, 389>, <542, 389, 421>, <420, 388, 493>, <420, 493, 541>,
			<545, 540, 564>, <545, 564, 565>, <652, 657, 565>, <652, 565, 564>,
			<494, 542, 543>, <494, 543, 495>, <606, 654, 655>, <606, 655, 607>,
			<492, 493, 541>, <492, 541, 540>, <492, 540, 453>, <492, 453, 439>,
			<604, 605, 653>, <604, 653, 652>, <604, 652, 689>, <604, 689, 675>,
			<609, 608, 656>, <609, 656, 657>, <609, 657, 690>, <609, 690, 676>,
			<497, 496, 544>, <497, 544, 545>, <497, 545, 454>, <497, 454, 440>,
			<440, 454, 362>, <440, 362, 348>, <676, 690, 782>, <676, 782, 768>,
			<675, 689, 781>, <675, 781, 767>, <439, 453, 361>, <439, 361, 347>
		}
		normal_indices {
			7028,
			<11, 11, 11>, <11, 11, 11>, <13, 13, 13>, <13, 13, 13>,
			<0, 0, 0>, <0, 0, 0>, <12, 12, 12>, <12, 12, 12>,
			<26, 26, 26>, <26, 26, 26>, <11, 11, 11>, <11, 11, 11>,
			<11, 11, 11>, <11, 11, 11>, <11, 11, 11>, <11, 11, 11>,
			<11, 11, 11>, <11, 11, 11>, <11, 11, 11>, <11, 11, 11>,
			<26, 26, 26>, <26, 26, 26>, <12, 12, 12>, <12, 12, 12>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<13, 13, 13>, <13, 13, 13>, <26, 26, 26>, <26, 26, 26>,
			<12, 12, 12>, <12, 12, 12>, <12, 12, 12>, <12, 12, 12>,
			<12, 12, 12>, <12, 12, 12>, <12, 12, 12>, <12, 12, 12>,
			<12, 12, 12>, <12, 12, 12>, <12, 12, 12>, <12, 12, 12>,
			<0, 0, 0>, <0, 0, 0>, <13, 13, 13>, <13, 13, 13>,
			<26, 26, 26>, <26, 26, 26>, <26, 26, 26>, <26, 26, 26>,
			<26, 26, 26>, <26, 26, 26>, <26, 26, 26>, <26, 26, 26>,
			<26, 26, 26>, <26, 26, 26>, <26, 26, 26>, <26, 26, 26>,
			<12, 12, 12>, <12, 12, 12>, <0, 0, 0>, <0, 0, 0>,
			<13, 13, 13>, <13, 13, 13>, <13, 13, 13>, <13, 13, 13>,
			<13, 13, 13>, <13, 13, 13>, <13, 13, 13>, <13, 13, 13>,
			<13, 13, 13>, <13, 13, 13>, <13, 13, 13>, <13, 13, 13>,
			<14, 14, 14>, <14, 14, 14>, <26, 26, 26>, <26, 26, 26>,
			<12, 12, 12>, <12, 12, 12>, <13, 13, 13>, <13, 13, 13>,
			<14, 14, 14>, <14, 14, 14>, <26, 26, 26>, <26, 26, 26>,
			<12, 12, 12>, <12, 12, 12>, <13, 13, 13>, <13, 13, 13>,
			<14, 14, 14>, <14, 14, 14>, <0, 0, 0>, <0, 0, 0>,
			<13, 13, 13>, <13, 13, 13>, <12, 12, 12>, <12, 12, 12>,
			<14, 14, 14>, <14, 14, 14>, <0, 0, 0>, <0, 0, 0>,
			<13, 13, 13>, <13, 13, 13>, <12, 12, 12>, <12, 12, 12>,
			<14, 14, 14>, <14, 14, 14>, <14, 14, 14>, <14, 14, 14>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<26, 26, 26>, <26, 26, 26>, <16, 16, 18>, <16, 18, 18>,
			<26, 26, 26>, <26, 26, 26>, <17, 17, 19>, <17, 19, 19>,
			<19, 19, 21>, <19, 21, 21>, <18, 18, 20>, <18, 20, 20>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<14, 14, 14>, <14, 14, 14>, <26, 26, 26>, <26, 26, 26>,
			<12, 12, 12>, <12, 12, 12>, <13, 13, 13>, <13, 13, 13>,
			<14, 14, 14>, <14, 14, 14>, <26, 26, 26>, <26, 26, 26>,
			<12, 12, 12>, <12, 12, 12>, <13, 13, 13>, <13, 13, 13>,
			<14, 14, 14>, <14, 14, 14>, <0, 0, 0>, <0, 0, 0>,
			<13, 13, 13>, <13, 13, 13>, <12, 12, 12>, <12, 12, 12>,
			<14, 14, 14>, <14, 14, 14>, <0, 0, 0>, <0, 0, 0>,
			<13, 13, 13>, <13, 13, 13>, <12, 12, 12>, <12, 12, 12>,
			<14, 14, 14>, <14, 14, 14>, <14, 14, 14>, <14, 14, 14>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<26, 26, 26>, <26, 26, 26>, <16, 16, 18>, <16, 18, 18>,
			<26, 26, 26>, <26, 26, 26>, <17, 17, 19>, <17, 19, 19>,
			<19, 19, 21>, <19, 21, 21>, <18, 18, 20>, <18, 20, 20>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<14, 14, 14>, <14, 14, 14>, <26, 26, 26>, <26, 26, 26>,
			<12, 12, 12>, <12, 12, 12>, <13, 13, 13>, <13, 13, 13>,
			<14, 14, 14>, <14, 14, 14>, <26, 26, 26>, <26, 26, 26>,
			<12, 12, 12>, <12, 12, 12>, <13, 13, 13>, <13, 13, 13>,
			<14, 14, 14>, <14, 14, 14>, <0, 0, 0>, <0, 0, 0>,
			<13, 13, 13>, <13, 13, 13>, <12, 12, 12>, <12, 12, 12>,
			<14, 14, 14>, <14, 14, 14>, <0, 0, 0>, <0, 0, 0>,
			<13, 13, 13>, <13, 13, 13>, <12, 12, 12>, <12, 12, 12>,
			<14, 14, 14>, <14, 14, 14>, <14, 14, 14>, <14, 14, 14>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<26, 26, 26>, <26, 26, 26>, <16, 16, 18>, <16, 18, 18>,
			<26, 26, 26>, <26, 26, 26>, <17, 17, 19>, <17, 19, 19>,
			<19, 19, 21>, <19, 21, 21>, <18, 18, 20>, <18, 20, 20>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<14, 14, 14>, <14, 14, 14>, <26, 26, 26>, <26, 26, 26>,
			<12, 12, 12>, <12, 12, 12>, <13, 13, 13>, <13, 13, 13>,
			<14, 14, 14>, <14, 14, 14>, <26, 26, 26>, <26, 26, 26>,
			<12, 12, 12>, <12, 12, 12>, <13, 13, 13>, <13, 13, 13>,
			<14, 14, 14>, <14, 14, 14>, <0, 0, 0>, <0, 0, 0>,
			<13, 13, 13>, <13, 13, 13>, <12, 12, 12>, <12, 12, 12>,
			<14, 14, 14>, <14, 14, 14>, <0, 0, 0>, <0, 0, 0>,
			<13, 13, 13>, <13, 13, 13>, <12, 12, 12>, <12, 12, 12>,
			<14, 14, 14>, <14, 14, 14>, <14, 14, 14>, <14, 14, 14>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<26, 26, 26>, <26, 26, 26>, <16, 16, 18>, <16, 18, 18>,
			<26, 26, 26>, <26, 26, 26>, <17, 17, 19>, <17, 19, 19>,
			<19, 19, 21>, <19, 21, 21>, <18, 18, 20>, <18, 20, 20>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<14, 14, 14>, <14, 14, 14>, <26, 26, 26>, <26, 26, 26>,
			<12, 12, 12>, <12, 12, 12>, <13, 13, 13>, <13, 13, 13>,
			<14, 14, 14>, <14, 14, 14>, <26, 26, 26>, <26, 26, 26>,
			<12, 12, 12>, <12, 12, 12>, <13, 13, 13>, <13, 13, 13>,
			<14, 14, 14>, <14, 14, 14>, <0, 0, 0>, <0, 0, 0>,
			<13, 13, 13>, <13, 13, 13>, <12, 12, 12>, <12, 12, 12>,
			<14, 14, 14>, <14, 14, 14>, <0, 0, 0>, <0, 0, 0>,
			<13, 13, 13>, <13, 13, 13>, <12, 12, 12>, <12, 12, 12>,
			<14, 14, 14>, <14, 14, 14>, <14, 14, 14>, <14, 14, 14>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<26, 26, 26>, <26, 26, 26>, <16, 16, 18>, <16, 18, 18>,
			<26, 26, 26>, <26, 26, 26>, <17, 17, 19>, <17, 19, 19>,
			<19, 19, 21>, <19, 21, 21>, <18, 18, 20>, <18, 20, 20>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<14, 14, 14>, <14, 14, 14>, <26, 26, 26>, <26, 26, 26>,
			<12, 12, 12>, <12, 12, 12>, <13, 13, 13>, <13, 13, 13>,
			<14, 14, 14>, <14, 14, 14>, <26, 26, 26>, <26, 26, 26>,
			<12, 12, 12>, <12, 12, 12>, <13, 13, 13>, <13, 13, 13>,
			<14, 14, 14>, <14, 14, 14>, <0, 0, 0>, <0, 0, 0>,
			<13, 13, 13>, <13, 13, 13>, <12, 12, 12>, <12, 12, 12>,
			<14, 14, 14>, <14, 14, 14>, <0, 0, 0>, <0, 0, 0>,
			<13, 13, 13>, <13, 13, 13>, <12, 12, 12>, <12, 12, 12>,
			<14, 14, 14>, <14, 14, 14>, <14, 14, 14>, <14, 14, 14>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<26, 26, 26>, <26, 26, 26>, <16, 16, 18>, <16, 18, 18>,
			<26, 26, 26>, <26, 26, 26>, <17, 17, 19>, <17, 19, 19>,
			<19, 19, 21>, <19, 21, 21>, <18, 18, 20>, <18, 20, 20>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<14, 14, 14>, <14, 14, 14>, <26, 26, 26>, <26, 26, 26>,
			<12, 12, 12>, <12, 12, 12>, <13, 13, 13>, <13, 13, 13>,
			<14, 14, 14>, <14, 14, 14>, <26, 26, 26>, <26, 26, 26>,
			<12, 12, 12>, <12, 12, 12>, <13, 13, 13>, <13, 13, 13>,
			<14, 14, 14>, <14, 14, 14>, <0, 0, 0>, <0, 0, 0>,
			<13, 13, 13>, <13, 13, 13>, <12, 12, 12>, <12, 12, 12>,
			<14, 14, 14>, <14, 14, 14>, <0, 0, 0>, <0, 0, 0>,
			<13, 13, 13>, <13, 13, 13>, <12, 12, 12>, <12, 12, 12>,
			<14, 14, 14>, <14, 14, 14>, <14, 14, 14>, <14, 14, 14>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<26, 26, 26>, <26, 26, 26>, <16, 16, 18>, <16, 18, 18>,
			<26, 26, 26>, <26, 26, 26>, <17, 17, 19>, <17, 19, 19>,
			<19, 19, 21>, <19, 21, 21>, <18, 18, 20>, <18, 20, 20>,
			<0, 0, 0>, <0, 0, 0>, <0, 0, 0>, <0, 0, 0>,
			<14, 14, 14>, <14, 14, 14>, <12, 12, 12>, <12, 12, 12>,
			<0, 0, 0>, <0, 0, 0>, <26, 26, 26>, <26, 26, 26>,
			<14, 14, 14>, <14, 14, 14>, <12, 12, 12>, <12, 12, 12>,
			<0, 0, 0>, <0, 0, 0>, <26, 26, 26>, <26, 26, 26>,
			<14, 14, 14>, <14, 14, 14>, <13, 13, 13>, <13, 13, 13>,
			<26, 26, 26>, <26, 26, 26>, <0, 0, 0>, <0, 0, 0>,
			<14, 14, 14>, <14, 14, 14>, <13, 13, 13>, <13, 13, 13>,
			<26, 26, 26>, <26, 26, 26>, <0, 0, 0>, <0, 0, 0>,
			<14, 14, 14>, <14, 14, 14>, <14, 14, 14>, <14, 14, 14>,
			<13, 13, 13>, <13, 13, 13>, <13, 13, 13>, <13, 13, 13>,
			<12, 12, 12>, <12, 12, 12>, <1, 1, 3>, <1, 3, 3>,
			<12, 12, 12>, <12, 12, 12>, <24, 24, 22>, <24, 22, 22>,
			<22, 22, 20>, <22, 20, 20>, <3, 3, 5>, <3, 5, 5>,
			<13, 13, 13>, <13, 13, 13>, <13, 13, 13>, <13, 13, 13>,
			<14, 14, 14>, <14, 14, 14>, <12, 12, 12>, <12, 12, 12>,
			<0, 0, 0>, <0, 0, 0>, <26, 26, 26>, <26, 26, 26>,
			<14, 14, 14>, <14, 14, 14>, <12, 12, 12>, <12, 12, 12>,
			<0, 0, 0>, <0, 0, 0>, <26, 26, 26>, <26, 26, 26>,
			<14, 14, 14>, <14, 14, 14>, <13, 13, 13>, <13, 13, 13>,
			<26, 26, 26>, <26, 26, 26>, <0, 0, 0>, <0, 0, 0>,
			<14, 14, 14>, <14, 14, 14>, <13, 13, 13>, <13, 13, 13>,
			<26, 26, 26>, <26, 26, 26>, <0, 0, 0>, <0, 0, 0>,
			<14, 14, 14>, <14, 14, 14>, <14, 14, 14>, <14, 14, 14>,
			<13, 13, 13>, <13, 13, 13>, <13, 13, 13>, <13, 13, 13>,
			<12, 12, 12>, <12, 12, 12>, <1, 1, 3>, <1, 3, 3>,
			<12, 12, 12>, <12, 12, 12>, <24, 24, 22>, <24, 22, 22>,
			<22, 22, 20>, <22, 20, 20>, <3, 3, 5>, <3, 5, 5>,
			<13, 13, 13>, <13, 13, 13>, <13, 13, 13>, <13, 13, 13>,
			<14, 14, 14>, <14, 14, 14>, <12, 12, 12>, <12, 12, 12>,
			<0, 0, 0>, <0, 0, 0>, <26, 26, 26>, <26, 26, 26>,
			<14, 14, 14>, <14, 14, 14>, <12, 12, 12>, <12, 12, 12>,
			<0, 0, 0>, <0, 0, 0>, <26, 26, 26>, <26, 26, 26>,
			<14, 14, 14>, <14, 14, 14>, <13, 13, 13>, <13, 13, 13>,
			<26, 26, 26>, <26, 26, 26>, <0, 0, 0>, <0, 0, 0>,
			<14, 14, 14>, <14, 14, 14>, <13, 13, 13>, <13, 13, 13>,
			<26, 26, 26>, <26, 26, 26>, <0, 0, 0>, <0, 0, 0>,
			<14, 14, 14>, <14, 14, 14>, <14, 14, 14>, <14, 14, 14>,
			<13, 13, 13>, <13, 13, 13>, <13, 13, 13>, <13, 13, 13>,
			<12, 12, 12>, <12, 12, 12>, <1, 1, 3>, <1, 3, 3>,
			<12, 12, 12>, <12, 12, 12>, <24, 24, 22>, <24, 22, 22>,
			<22, 22, 20>, <22, 20, 20>, <3, 3, 5>, <3, 5, 5>,
			<13, 13, 13>, <13, 13, 13>, <13, 13, 13>, <13, 13, 13>,
			<14, 14, 14>, <14, 14, 14>, <12, 12, 12>, <12, 12, 12>,
			<0, 0, 0>, <0, 0, 0>, <26, 26, 26>, <26, 26, 26>,
			<14, 14, 14>, <14, 14, 14>, <12, 12, 12>, <12, 12, 12>,
			<0, 0, 0>, <0, 0, 0>, <26, 26, 26>, <26, 26, 26>,
			<14, 14, 14>, <14, 14, 14>, <13, 13, 13>, <13, 13, 13>,
			<26, 26, 26>, <26, 26, 26>, <0, 0, 0>, <0, 0, 0>,
			<14, 14, 14>, <14, 14, 14>, <13, 13, 13>, <13, 13, 13>,
			<26, 26, 26>, <26, 26, 26>, <0, 0, 0>, <0, 0, 0>,
			<14, 14, 14>, <14, 14, 14>, <14, 14, 14>, <14, 14, 14>,
			<13, 13, 13>, <13, 13, 13>, <13, 13, 13>, <13, 13, 13>,
			<12, 12, 12>, <12, 12, 12>, <1, 1, 3>, <1, 3, 3>,
			<12, 12, 12>, <12, 12, 12>, <24, 24, 22>, <24, 22, 22>,
			<22, 22, 20>, <22, 20, 20>, <3, 3, 5>, <3, 5, 5>,
			<13, 13, 13>, <13, 13, 13>, <13, 13, 13>, <13, 13, 13>,
			<14, 14, 14>, <14, 14, 14>, <12, 12, 12>, <12, 12, 12>,
			<0, 0, 0>, <0, 0, 0>, <26, 26, 26>, <26, 26, 26>,
			<14, 14, 14>, <14, 14, 14>, <12, 12, 12>, <12, 12, 12>,
			<0, 0, 0>, <0, 0, 0>, <26, 26, 26>, <26, 26, 26>,
			<14, 14, 14>, <14, 14, 14>, <13, 13, 13>, <13, 13, 13>,
			<26, 26, 26>, <26, 26, 26>, <0, 0, 0>, <0, 0, 0>,
			<14, 14, 14>, <14, 14, 14>, <13, 13, 13>, <13, 13, 13>,
			<26, 26, 26>, <26, 26, 26>, <0, 0, 0>, <0, 0, 0>,
			<14, 14, 14>, <14, 14, 14>, <14, 14, 14>, <14, 14, 14>,
			<13, 13, 13>, <13, 13, 13>, <13, 13, 13>, <13, 13, 13>,
			<12, 12, 12>, <12, 12, 12>, <1, 1, 3>, <1, 3, 3>,
			<12, 12, 12>, <12, 12, 12>, <24, 24, 22>, <24, 22, 22>,
			<22, 22, 20>, <22, 20, 20>, <3, 3, 5>, <3, 5, 5>,
			<13, 13, 13>, <13, 13, 13>, <13, 13, 13>, <13, 13, 13>,
			<14, 14, 14>, <14, 14, 14>, <12, 12, 12>, <12, 12, 12>,
			<0, 0, 0>, <0, 0, 0>, <26, 26, 26>, <26, 26, 26>,
			<14, 14, 14>, <14, 14, 14>, <12, 12, 12>, <12, 12, 12>,
			<0, 0, 0>, <0, 0, 0>, <26, 26, 26>, <26, 26, 26>,
			<14, 14, 14>, <14, 14, 14>, <13, 13, 13>, <13, 13, 13>,
			<26, 26, 26>, <26, 26, 26>, <0, 0, 0>, <0, 0, 0>,
			<14, 14, 14>, <14, 14, 14>, <13, 13, 13>, <13, 13, 13>,
			<26, 26, 26>, <26, 26, 26>, <0, 0, 0>, <0, 0, 0>,
			<14, 14, 14>, <14, 14, 14>, <14, 14, 14>, <14, 14, 14>,
			<13, 13, 13>, <13, 13, 13>, <13, 13, 13>, <13, 13, 13>,
			<12, 12, 12>, <12, 12, 12>, <1, 1, 3>, <1, 3, 3>,
			<12, 12, 12>, <12, 12, 12>, <24, 24, 22>, <24, 22, 22>,
			<22, 22, 20>, <22, 20, 20>, <3, 3, 5>, <3, 5, 5>,
			<13, 13, 13>, <13, 13, 13>, <13, 13, 13>, <13, 13, 13>,
			<14, 14, 14>, <14, 14, 14>, <12, 12, 12>, <12, 12, 12>,
			<0, 0, 0>, <0, 0, 0>, <26, 26, 26>, <26, 26, 26>,
			<14, 14, 14>, <14, 14, 14>, <12, 12, 12>, <12, 12, 12>,
			<0, 0, 0>, <0, 0, 0>, <26, 26, 26>, <26, 26, 26>,
			<14, 14, 14>, <14, 14, 14>, <13, 13, 13>, <13, 13, 13>,
			<26, 26, 26>, <26, 26, 26>, <0, 0, 0>, <0, 0, 0>,
			<14, 14, 14>, <14, 14, 14>, <13, 13, 13>, <13, 13, 13>,
			<26, 26, 26>, <26, 26, 26>, <0, 0, 0>, <0, 0, 0>,
			<14, 14, 14>, <14, 14, 14>, <14, 14, 14>, <14, 14, 14>,
			<13, 13, 13>, <13, 13, 13>, <13, 13, 13>, <13, 13, 13>,
			<12, 12, 12>, <12, 12, 12>, <1, 1, 3>, <1, 3, 3>,
			<12, 12, 12>, <12, 12, 12>, <24, 24, 22>, <24, 22, 22>,
			<22, 22, 20>, <22, 20, 20>, <3, 3, 5>, <3, 5, 5>,
			<13, 13, 13>, <13, 13, 13>, <13, 13, 13>, <13, 13, 13>,
			<14, 14, 14>, <14, 14, 14>, <0, 0, 0>, <0, 0, 0>,
			<13, 13, 13>, <13, 13, 13>, <12, 12, 12>, <12, 12, 12>,
			<14, 14, 14>, <14, 14, 14>, <0, 0, 0>, <0, 0, 0>,
			<13, 13, 13>, <13, 13, 13>, <12, 12, 12>, <12, 12, 12>,
			<14, 14, 14>, <14, 14, 14>, <26, 26, 26>, <26, 26, 26>,
			<12, 12, 12>, <12, 12, 12>, <13, 13, 13>, <13, 13, 13>,
			<14, 14, 14>, <14, 14, 14>, <26, 26, 26>, <26, 26, 26>,
			<12, 12, 12>, <12, 12, 12>, <13, 13, 13>, <13, 13, 13>,
			<14, 14, 14>, <14,