// This work is licensed under the Attribution-ShareAlike 4.0 International.
//
//    Persistence of Vision Ray Tracer Include File
//
//    File           : farger_crayola.inc
//    Version        : 4.1
//    Created by     : Sven-Erik Andersen
//    Contact        : sven.erik.andersen@gmail.com
//    Created date   : 2014-06-22
//    Last updated   : 2020-07-27
//    Description    : Farger means colors in Norwegian.
//
//

#ifndef(farger_crayola_Inc_Temp)
    #declare farger_crayola_Inc_Temp = version;
    #version 3.7;

    // Where the color definition is the same as in the POV-Ray color.inc include file,
    // the color name will point to the POV-Ray color definition,
    // so we need to make sure that file is included
    #ifndef(Colors_Inc_Temp)
        #include "colors.inc"
    #end

    #ifdef(View_POV_Include_Stack)
        #debug "including farger_crayola.inc\n"
    #end

    // Crayola crayon colors
    #declare Crayola_Absolute_Zero = rgb <0, 0.282352941176471, 0.729411764705882>; // HEX #0048BA
    #declare Crayola_Acid_Wash_Jeans = rgb <0.36078431372549, 0.698039215686274, 0.772549019607843>; // HEX #5CB2C5
    #declare Crayola_Alloy_Orange = rgb <0.768627450980392, 0.384313725490196, 0.0627450980392157>; // HEX #C46210
    #declare Crayola_Almond = rgb <0.933333333333333, 0.850980392156863, 0.768627450980392>; // HEX #EED9C4
    #declare Crayola_Amethyst = rgb <0.392156862745098, 0.376470588235294, 0.603921568627451>; // HEX #64609A
    #declare Crayola_Antique_Brass = rgb <0.784313725490196, 0.541176470588235, 0.396078431372549>; // HEX #C88A65
    #declare Crayola_Apricot = rgb <0.992156862745098, 0.835294117647059, 0.694117647058824>; // HEX #FDD5B1
    #declare Crayola_Aqua_Pearl = rgb <0.372549019607843, 0.745098039215686, 0.843137254901961>; // HEX #5FBED7
    #declare Crayola_Aquamarine = rgb <0.584313725490196, 0.87843137254902, 0.909803921568627>; // HEX #95E0E8
    #declare Crayola_Asparagus = rgb <0.482352941176471, 0.627450980392157, 0.356862745098039>; // HEX #7BA05B
    #declare Crayola_Atomic_Tangerine = rgb <1, 0.6, 0.4>; // HEX #FF9966
    #declare Crayola_Aztec_Gold = rgb <0.764705882352941, 0.6, 0.325490196078431>; // HEX #C39953
    #declare Crayola_Banana_Mania = rgb <0.984313725490196, 0.905882352941176, 0.698039215686274>; // HEX #FBE7B2
    #declare Crayola_Bdazzled_Blue = rgb <0.180392156862745, 0.345098039215686, 0.580392156862745>; // HEX #2E5894
    #declare Crayola_Beaver = rgb <0.572549019607843, 0.435294117647059, 0.356862745098039>; // HEX #926F5B
    #declare Crayola_Big_Dip_O_Ruby = rgb <0.611764705882353, 0.145098039215686, 0.258823529411765>; // HEX #9C2542
    #declare Crayola_Big_Foot_Feet = rgb <0.850980392156863, 0.603921568627451, 0.423529411764706>; // HEX #D99A6C
    #declare Crayola_Bittersweet = rgb <0.996078431372549, 0.435294117647059, 0.368627450980392>; // HEX #FE6F5E
    #declare Crayola_Bittersweet_Shimmer = rgb <0.749019607843137, 0.309803921568627, 0.317647058823529>; // HEX #BF4F51
    #declare Crayola_Black_Coral_Pearl = rgb <0.329411764705882, 0.384313725490196, 0.435294117647059>; // HEX #54626F
    #declare Crayola_Black_Shadows = rgb <0.749019607843137, 0.686274509803922, 0.698039215686274>; // HEX #BFAFB2
    #declare Crayola_Blast_Off_Bronze = rgb <0.647058823529412, 0.443137254901961, 0.392156862745098>; // HEX #A57164
    #declare Crayola_Blue_Bell = rgb <0.6, 0.6, 0.8>; // HEX #9999CC
    #declare Crayola_Blue_Gray = rgb <0.784313725490196, 0.784313725490196, 0.803921568627451>; // HEX #C8C8CD
    #declare Crayola_Blue_Green = rgb <0, 0.584313725490196, 0.717647058823529>; // HEX #0095B7
    #declare Crayola_Blue_I = rgb <0.180392156862745, 0.705882352941177, 0.901960784313726>; // HEX #2EB4E6
    #declare Crayola_Blue_II = rgb <0.270588235294118, 0.43921568627451, 0.901960784313726>; // HEX #4570E6
    #declare Crayola_Blue_III = rgb <0, 0.4, 1>; // HEX #0066FF
    #declare Crayola_Blue_Jeans = rgb <0.364705882352941, 0.67843137254902, 0.925490196078431>; // HEX #5DADEC
    #declare Crayola_Blue_Violet = rgb <0.392156862745098, 0.337254901960784, 0.717647058823529>; // HEX #6456B7
    #declare Crayola_Bluetiful = rgb <0.235294117647059, 0.411764705882353, 0.905882352941176>; // HEX #3C69E7
    #declare Crayola_Blush = rgb <0.858823529411765, 0.313725490196078, 0.474509803921569>; // HEX #DB5079
    #declare Crayola_Booger_Buster = rgb <0.925490196078431, 0.92156862745098, 0.741176470588235>; // HEX #ECEBBD
    #declare Crayola_Brick_Red = rgb <0.776470588235294, 0.176470588235294, 0.258823529411765>; // HEX #C62D42
    #declare Crayola_Bright_Yellow = rgb <1, 0.666666666666667, 0.113725490196078>; // HEX #FFAA1D
    #declare Crayola_Brilliant_Rose = rgb <0.901960784313726, 0.403921568627451, 0.807843137254902>; // HEX #E667CE
    #declare Crayola_Brown = rgb <0.686274509803922, 0.349019607843137, 0.243137254901961>; // HEX #AF593E
    #declare Crayola_Brown_Sugar = rgb <0.686274509803922, 0.431372549019608, 0.301960784313725>; // HEX #AF6E4D
    #declare Crayola_Burnished_Brown = rgb <0.631372549019608, 0.47843137254902, 0.454901960784314>; // HEX #A17A74
    #declare Crayola_Burnt_Orange = rgb <1, 0.43921568627451, 0.203921568627451>; // HEX #FF7034
    #declare Crayola_Burnt_Sienna = rgb <0.913725490196078, 0.454901960784314, 0.317647058823529>; // HEX #E97451
    #declare Crayola_Burnt_Umber = rgb <0.501960784313725, 0.333333333333333, 0.2>; // HEX #805533
    #declare Crayola_Cadet_Blue = rgb <0.662745098039216, 0.698039215686274, 0.764705882352941>; // HEX #A9B2C3
    #declare Crayola_Canary = rgb <1, 1, 0.6>; // HEX #FFFF99
    #declare Crayola_Caribbean_Green = rgb <0, 0.8, 0.6>; // HEX #00CC99
    #declare Crayola_Caribbean_Green_Pearl = rgb <0.415686274509804, 0.854901960784314, 0.556862745098039>; // HEX #6ADA8E
    #declare Crayola_Carmine = rgb <0.901960784313726, 0.180392156862745, 0.419607843137255>; // HEX #E62E6B
    #declare Crayola_Carnation_Pink = rgb <1, 0.650980392156863, 0.788235294117647>; // HEX #FFA6C9
    #declare Crayola_Celestial_Blue = rgb <0.43921568627451, 0.43921568627451, 0.8>; // HEX #7070CC
    #declare Crayola_Cerise = rgb <0.854901960784314, 0.196078431372549, 0.529411764705882>; // HEX #DA3287
    #declare Crayola_Cerulean = rgb <0.00784313725490196, 0.643137254901961, 0.827450980392157>; // HEX #02A4D3
    #declare Crayola_Cerulean_Blue = rgb <0.2, 0.603921568627451, 0.8>; // HEX #339ACC
    #declare Crayola_Cerulean_Frost = rgb <0.427450980392157, 0.607843137254902, 0.764705882352941>; // HEX #6D9BC3
    #declare Crayola_Charcoal_Gray = rgb <0.450980392156863, 0.415686274509804, 0.384313725490196>; // HEX #736A62
    #declare Crayola_Cheese_Grater = rgb <0.784313725490196, 0.623529411764706, 0.337254901960784>; // HEX #C89F56
    #declare Crayola_Cinnamon_Satin = rgb <0.803921568627451, 0.376470588235294, 0.494117647058824>; // HEX #CD607E
    #declare Crayola_Citrine = rgb <0.576470588235294, 0.215686274509804, 0.0352941176470588>; // HEX #933709
    #declare Crayola_Cobalt_Blue = rgb <0.549019607843137, 0.564705882352941, 0.784313725490196>; // HEX #8C90C8
    #declare Crayola_Cobalt_Cool = rgb <0.00784313725490196, 0.541176470588235, 0.682352941176471>; // HEX #028AAE
    #declare Crayola_Copper = rgb <0.854901960784314, 0.541176470588235, 0.403921568627451>; // HEX #DA8A67
    #declare Crayola_Copper_Penny = rgb <0.67843137254902, 0.435294117647059, 0.411764705882353>; // HEX #AD6F69
    #declare Crayola_Cornflower = rgb <0.576470588235294, 0.8, 0.917647058823529>; // HEX #93CCEA
    #declare Crayola_Cosmic_Cobalt = rgb <0.180392156862745, 0.176470588235294, 0.533333333333333>; // HEX #2E2D88
    #declare Crayola_Cotton_Candy = rgb <1, 0.717647058823529, 0.835294117647059>; // HEX #FFB7D5
    #declare Crayola_Cultured_Pearl = rgb <0.96078431372549, 0.96078431372549, 0.96078431372549>; // HEX #F5F5F5
    #declare Crayola_Cyber_Grape = rgb <0.345098039215686, 0.258823529411765, 0.486274509803922>; // HEX #58427C
    #declare Crayola_Dandelion = rgb <0.996078431372549, 0.847058823529412, 0.364705882352941>; // HEX #FED85D
    #declare Crayola_Dark_Venetian_Red = rgb <0.701960784313725, 0.231372549019608, 0.141176470588235>; // HEX #B33B24
    #declare Crayola_Deep_Space_Sparkle = rgb <0.290196078431373, 0.392156862745098, 0.423529411764706>; // HEX #4A646C
    #declare Crayola_Denim = rgb <0.0823529411764706, 0.376470588235294, 0.741176470588235>; // HEX #1560BD
    #declare Crayola_Denim_Blue = rgb <0.133333333333333, 0.262745098039216, 0.713725490196078>; // HEX #2243B6
    #declare Crayola_Desert_Sand = rgb <0.929411764705882, 0.788235294117647, 0.686274509803922>; // HEX #EDC9AF
    #declare Crayola_Eerie_Black = rgb <0.105882352941176, 0.105882352941176, 0.105882352941176>; // HEX #1B1B1B
    #declare Crayola_Eggplant = rgb <0.380392156862745, 0.250980392156863, 0.317647058823529>; // HEX #614051
    #declare Crayola_Electric_Lime = rgb <0.8, 1, 0>; // HEX #CCFF00
    #declare Crayola_Emerald = rgb <0.0784313725490196, 0.662745098039216, 0.537254901960784>; // HEX #14A989
    #declare Crayola_English_Vermilion = rgb <0.8, 0.27843137254902, 0.294117647058824>; // HEX #CC474B
    #declare Crayola_Fern = rgb <0.388235294117647, 0.717647058823529, 0.423529411764706>; // HEX #63B76C
    #declare Crayola_Fiery_Rose = rgb <0.933333333333333, 0.203921568627451, 0.823529411764706>; // HEX #EE34D2
    #declare Crayola_Forest_Green = rgb <0.372549019607843, 0.654901960784314, 0.466666666666667>; // HEX #5FA777
    #declare Crayola_Frostbite = rgb <0.913725490196078, 0.211764705882353, 0.654901960784314>; // HEX #E936A7
    #declare Crayola_Fuchsia = rgb <0.756862745098039, 0.329411764705882, 0.756862745098039>; // HEX #C154C1
    #declare Crayola_Fuzzy_Wuzzy = rgb <0.529411764705882, 0.258823529411765, 0.12156862745098>; // HEX #87421F
    #declare Crayola_Giants_Club = rgb <0.725490196078431, 0.305882352941176, 0.282352941176471>; // HEX #B94E48
    #declare Crayola_Glossy_Grape = rgb <0.670588235294118, 0.572549019607843, 0.701960784313725>; // HEX #AB92B3
    #declare Crayola_Gold_Fusion = rgb <0.52156862745098, 0.458823529411765, 0.305882352941176>; // HEX #85754E
    #declare Crayola_Gold_I = rgb <0.572549019607843, 0.572549019607843, 0.431372549019608>; // HEX #92926E
    #declare Crayola_Gold_II = rgb <0.901960784313726, 0.745098039215686, 0.541176470588235>; // HEX #E6BE8A
    #declare Crayola_Gold_Medal = rgb <0.772549019607843, 0.737254901960784, 0.258823529411765>; // HEX #C5BC42
    #declare Crayola_Goldenrod = rgb <0.988235294117647, 0.83921568627451, 0.403921568627451>; // HEX #FCD667
    #declare Crayola_Granite_Gray = rgb <0.403921568627451, 0.403921568627451, 0.403921568627451>; // HEX #676767
    #declare Crayola_Granny_Smith_Apple = rgb <0.615686274509804, 0.87843137254902, 0.576470588235294>; // HEX #9DE093
    #declare Crayola_Gray = rgb <0.545098039215686, 0.525490196078431, 0.501960784313725>; // HEX #8B8680
    #declare Crayola_Green = rgb <0.227450980392157, 0.650980392156863, 0.333333333333333>; // HEX #3AA655
    #declare Crayola_Green_Blue = rgb <0.156862745098039, 0.529411764705882, 0.784313725490196>; // HEX #2887C8
    #declare Crayola_Green_Lizard = rgb <0.654901960784314, 0.956862745098039, 0.196078431372549>; // HEX #A7F432
    #declare Crayola_Green_Sheen = rgb <0.431372549019608, 0.682352941176471, 0.631372549019608>; // HEX #6EAEA1
    #declare Crayola_Green_Yellow = rgb <0.945098039215686, 0.905882352941176, 0.533333333333333>; // HEX #F1E788
    #declare Crayola_Hot_Magenta = rgb <1, 0, 0.8>; // HEX #FF00CC
    #declare Crayola_Illuminating_Emerald = rgb <0.192156862745098, 0.568627450980392, 0.466666666666667>; // HEX #319177
    #declare Crayola_Inchworm = rgb <0.686274509803922, 0.890196078431372, 0.0745098039215686>; // HEX #AFE313
    #declare Crayola_Indian_Red = rgb <0.725490196078431, 0.305882352941176, 0.282352941176471>; // HEX #B94E48
    #declare Crayola_Indigo = rgb <0.309803921568627, 0.411764705882353, 0.776470588235294>; // HEX #4F69C6
    #declare Crayola_Iron_Indigo = rgb <0.0941176470588235, 0.309803921568627, 0.631372549019608>; // HEX #184FA1
    #declare Crayola_Jade = rgb <0.274509803921569, 0.603921568627451, 0.517647058823529>; // HEX #469A84
    #declare Crayola_Jasper = rgb <0.815686274509804, 0.325490196078431, 0.250980392156863>; // HEX #D05340
    #declare Crayola_Jazzberry_Jam = rgb <0.647058823529412, 0.0431372549019608, 0.368627450980392>; // HEX #A50B5E
    #declare Crayola_Jungle_Green = rgb <0.16078431372549, 0.670588235294118, 0.529411764705882>; // HEX #29AB87
    #declare Crayola_Key_Lime_Pearl = rgb <0.909803921568627, 0.956862745098039, 0.549019607843137>; // HEX #E8F48C
    #declare Crayola_Lapis_Lazuli = rgb <0.262745098039216, 0.423529411764706, 0.725490196078431>; // HEX #436CB9
    #declare Crayola_Laser_Lemon = rgb <1, 1, 0.4>; // HEX #FFFF66
    #declare Crayola_Lavender_I = rgb <0.749019607843137, 0.56078431372549, 0.8>; // HEX #BF8FCC
    #declare Crayola_Lavender_II = rgb <0.984313725490196, 0.682352941176471, 0.823529411764706>; // HEX #FBAED2
    #declare Crayola_Lemon_Yellow_II = rgb <1, 1, 0.623529411764706>; // HEX #FFFF9F
    #declare Crayola_Light_Blue = rgb <0.56078431372549, 0.847058823529412, 0.847058823529412>; // HEX #8FD8D8
    #declare Crayola_Light_Chrome_Green = rgb <0.745098039215686, 0.901960784313726, 0.294117647058824>; // HEX #BEE64B
    #declare Crayola_Light_Venetian_Red = rgb <0.901960784313726, 0.450980392156863, 0.36078431372549>; // HEX #E6735C
    #declare Crayola_Lilac_Luster = rgb <0.682352941176471, 0.596078431372549, 0.666666666666667>; // HEX #AE98AA
    #declare Crayola_Macaroni_and_Cheese = rgb <1, 0.725490196078431, 0.482352941176471>; // HEX #FFB97B
    #declare Crayola_Madder_Lake = rgb <0.8, 0.2, 0.211764705882353>; // HEX #CC3336
    #declare Crayola_Magenta = rgb <0.964705882352941, 0.325490196078431, 0.650980392156863>; // HEX #F653A6
    #declare Crayola_Magnetic_Magenta = rgb <0.749019607843137, 0.223529411764706, 0.505882352941176>; // HEX #BF3981
    #declare Crayola_Mahogany = rgb <0.792156862745098, 0.203921568627451, 0.207843137254902>; // HEX #CA3435
    #declare Crayola_Maize = rgb <0.949019607843137, 0.776470588235294, 0.286274509803922>; // HEX #F2C649
    #declare Crayola_Malachite = rgb <0.274509803921569, 0.580392156862745, 0.588235294117647>; // HEX #469496
    #declare Crayola_Manatee = rgb <0.552941176470588, 0.564705882352941, 0.631372549019608>; // HEX #8D90A1
    #declare Crayola_Mandarin_Pearl = rgb <0.952941176470588, 0.47843137254902, 0.282352941176471>; // HEX #F37A48
    #declare Crayola_Mango_Tango = rgb <0.905882352941176, 0.447058823529412, 0>; // HEX #E77200
    #declare Crayola_Maroon = rgb <0.764705882352941, 0.129411764705882, 0.282352941176471>; // HEX #C32148
    #declare Crayola_Mauvelous = rgb <0.941176470588235, 0.568627450980392, 0.662745098039216>; // HEX #F091A9
    #declare Crayola_Maximum_Blue = rgb <0.27843137254902, 0.670588235294118, 0.8>; // HEX #47ABCC
    #declare Crayola_Maximum_Blue_Green = rgb <0.188235294117647, 0.749019607843137, 0.749019607843137>; // HEX #30BFBF
    #declare Crayola_Maximum_Blue_Purple = rgb <0.674509803921569, 0.674509803921569, 0.901960784313726>; // HEX #ACACE6
    #declare Crayola_Maximum_Green = rgb <0.368627450980392, 0.549019607843137, 0.192156862745098>; // HEX #5E8C31
    #declare Crayola_Maximum_Green_Yellow = rgb <0.850980392156863, 0.901960784313726, 0.313725490196078>; // HEX #D9E650
    #declare Crayola_Maximum_Purple = rgb <0.450980392156863, 0.2, 0.501960784313725>; // HEX #733380
    #declare Crayola_Maximum_Red = rgb <0.850980392156863, 0.129411764705882, 0.129411764705882>; // HEX #D92121
    #declare Crayola_Maximum_Red_Purple = rgb <0.650980392156863, 0.227450980392157, 0.474509803921569>; // HEX #A63A79
    #declare Crayola_Maximum_Yellow = rgb <0.980392156862745, 0.980392156862745, 0.215686274509804>; // HEX #FAFA37
    #declare Crayola_Maximum_Yellow_Red = rgb <0.949019607843137, 0.729411764705882, 0.286274509803922>; // HEX #F2BA49
    #declare Crayola_Medium_Chrome_Green = rgb <0.423529411764706, 0.650980392156863, 0.486274509803922>; // HEX #6CA67C
    #declare Crayola_Medium_Rose = rgb <0.850980392156863, 0.423529411764706, 0.745098039215686>; // HEX #D96CBE
    #declare Crayola_Medium_Violet = rgb <0.56078431372549, 0.27843137254902, 0.701960784313725>; // HEX #8F47B3
    #declare Crayola_Melon = rgb <0.996078431372549, 0.729411764705882, 0.67843137254902>; // HEX #FEBAAD
    #declare Crayola_Metallic_Seaweed = rgb <0.0392156862745098, 0.494117647058824, 0.549019607843137>; // HEX #0A7E8C
    #declare Crayola_Middle_Blue = rgb <0.494117647058824, 0.831372549019608, 0.901960784313726>; // HEX #7ED4E6
    #declare Crayola_Middle_Blue_Green = rgb <0.552941176470588, 0.850980392156863, 0.8>; // HEX #8DD9CC
    #declare Crayola_Middle_Blue_Purple = rgb <0.545098039215686, 0.447058823529412, 0.745098039215686>; // HEX #8B72BE
    #declare Crayola_Middle_Green = rgb <0.301960784313725, 0.549019607843137, 0.341176470588235>; // HEX #4D8C57
    #declare Crayola_Middle_Green_Yellow = rgb <0.674509803921569, 0.749019607843137, 0.376470588235294>; // HEX #ACBF60
    #declare Crayola_Middle_Purple = rgb <0.850980392156863, 0.509803921568627, 0.709803921568627>; // HEX #D982B5
    #declare Crayola_Middle_Red = rgb <0.898039215686275, 0.556862745098039, 0.450980392156863>; // HEX #E58E73
    #declare Crayola_Middle_Red_Purple = rgb <0.647058823529412, 0.325490196078431, 0.325490196078431>; // HEX #A55353
    #declare Crayola_Middle_Yellow = rgb <1, 0.92156862745098, 0>; // HEX #FFEB00
    #declare Crayola_Middle_Yellow_Red = rgb <0.925490196078431, 0.674509803921569, 0.462745098039216>; // HEX #ECAC76
    #declare Crayola_Midnight_Blue = rgb <0, 0.2, 0.4>; // HEX #003366
    #declare Crayola_Midnight_Pearl = rgb <0.43921568627451, 0.149019607843137, 0.43921568627451>; // HEX #702670
    #declare Crayola_Misty_Moss = rgb <0.733333333333333, 0.705882352941177, 0.466666666666667>; // HEX #BBB477
    #declare Crayola_Moonstone = rgb <0.227450980392157, 0.658823529411765, 0.756862745098039>; // HEX #3AA8C1
    #declare Crayola_Mountain_Meadow = rgb <0.101960784313725, 0.701960784313725, 0.52156862745098>; // HEX #1AB385
    #declare Crayola_Mulberry = rgb <0.784313725490196, 0.313725490196078, 0.607843137254902>; // HEX #C8509B
    #declare Crayola_Mummys_Tomb = rgb <0.545098039215686, 0.525490196078431, 0.501960784313725>; // HEX #8B8680
    #declare Crayola_Mystic_Maroon = rgb <0.67843137254902, 0.262745098039216, 0.474509803921569>; // HEX #AD4379
    #declare Crayola_Mystic_Pearl = rgb <0.83921568627451, 0.32156862745098, 0.509803921568627>; // HEX #D65282
    #declare Crayola_Navy_Blue = rgb <0, 0.4, 0.8>; // HEX #0066CC
    #declare Crayola_Neon_Carrot = rgb <1, 0.6, 0.2>; // HEX #FF9933
    #declare Crayola_Ocean_Blue_Pearl = rgb <0.309803921568627, 0.258823529411765, 0.709803921568627>; // HEX #4F42B5
    #declare Crayola_Ocean_Green_Pearl = rgb <0.282352941176471, 0.749019607843137, 0.568627450980392>; // HEX #48BF91
    #declare Crayola_Olive_Green = rgb <0.709803921568627, 0.701960784313725, 0.36078431372549>; // HEX #B5B35C
    #declare Crayola_Onyx = rgb <0.207843137254902, 0.219607843137255, 0.223529411764706>; // HEX #353839
    #declare Crayola_Orange = rgb <1, 0.533333333333333, 0.2>; // HEX #FF8833
    #declare Crayola_Orange_Red = rgb <1, 0.325490196078431, 0.286274509803922>; // HEX #FF5349
    #declare Crayola_Orange_Soda = rgb <0.980392156862745, 0.356862745098039, 0.23921568627451>; // HEX #FA5B3D
    #declare Crayola_Orange_Yellow = rgb <0.972549019607843, 0.835294117647059, 0.407843137254902>; // HEX #F8D568
    #declare Crayola_Orchid = rgb <0.886274509803922, 0.611764705882353, 0.823529411764706>; // HEX #E29CD2
    #declare Crayola_Orchid_Pearl = rgb <0.482352941176471, 0.258823529411765, 0.349019607843137>; // HEX #7B4259
    #declare Crayola_Outer_Space = rgb <0.176470588235294, 0.219607843137255, 0.227450980392157>; // HEX #2D383A
    #declare Crayola_Outrageous_Orange = rgb <1, 0.376470588235294, 0.215686274509804>; // HEX #FF6037
    #declare Crayola_Pacific_Blue = rgb <0, 0.615686274509804, 0.768627450980392>; // HEX #009DC4
    #declare Crayola_Peach = rgb <1, 0.796078431372549, 0.643137254901961>; // HEX #FFCBA4
    #declare Crayola_Pearly_Purple = rgb <0.717647058823529, 0.407843137254902, 0.635294117647059>; // HEX #B768A2
    #declare Crayola_Peridot = rgb <0.670588235294118, 0.67843137254902, 0.282352941176471>; // HEX #ABAD48
    #declare Crayola_Periwinkle = rgb <0.764705882352941, 0.803921568627451, 0.901960784313726>; // HEX #C3CDE6
    #declare Crayola_Permanent_Geranium_Lake = rgb <0.882352941176471, 0.172549019607843, 0.172549019607843>; // HEX #E12C2C
    #declare Crayola_Petrified_Forest = rgb <0, 0.356862745098039, 0.223529411764706>; // HEX #005B39
    #declare Crayola_Pewter_Blue = rgb <0.545098039215686, 0.658823529411765, 0.717647058823529>; // HEX #8BA8B7
    #declare Crayola_Piggy_Pink = rgb <0.992156862745098, 0.843137254901961, 0.894117647058824>; // HEX #FDD7E4
    #declare Crayola_Pine_Green = rgb <0.00392156862745098, 0.470588235294118, 0.435294117647059>; // HEX #01786F
    #declare Crayola_Pink_Flamingo = rgb <0.988235294117647, 0.454901960784314, 0.992156862745098>; // HEX #FC74FD
    #declare Crayola_Pink_Pearl = rgb <0.690196078431373, 0.43921568627451, 0.501960784313725>; // HEX #B07080
    #declare Crayola_Pink_Sherbert = rgb <0.968627450980392, 0.63921568627451, 0.556862745098039>; // HEX #F7A38E
    #declare Crayola_Pixie_Powder = rgb <0.392156862745098, 0.337254901960784, 0.717647058823529>; // HEX #6456B7
    #declare Crayola_Plum = rgb <0.556862745098039, 0.192156862745098, 0.474509803921569>; // HEX #8E3179
    #declare Crayola_Plump_Purple = rgb <0.349019607843137, 0.274509803921569, 0.698039215686274>; // HEX #5946B2
    #declare Crayola_Polished_Pine = rgb <0.364705882352941, 0.643137254901961, 0.576470588235294>; // HEX #5DA493
    #declare Crayola_Purple_Heart = rgb <0.396078431372549, 0.176470588235294, 0.756862745098039>; // HEX #652DC1
    #declare Crayola_Purple_Mountains_Majesty = rgb <0.83921568627451, 0.682352941176471, 0.866666666666667>; // HEX #D6AEDD
    #declare Crayola_Purple_Plum = rgb <0.611764705882353, 0.317647058823529, 0.713725490196078>; // HEX #9C51B6
    #declare Crayola_Radical_Red = rgb <1, 0.207843137254902, 0.368627450980392>; // HEX #FF355E
    #declare Crayola_Raw_Sienna_1 = rgb <0.901960784313726, 0.737254901960784, 0.36078431372549>; // HEX #E6BC5C
    #declare Crayola_Raw_Sienna_2 = rgb <0.823529411764706, 0.490196078431373, 0.274509803921569>; // HEX #D27D46
    #declare Crayola_Raw_Umber = rgb <0.4, 0.32156862745098, 0.2>; // HEX #665233
    #declare Crayola_Razzmatazz = rgb <0.890196078431372, 0.0431372549019608, 0.36078431372549>; // HEX #E30B5C
    #declare Crayola_Razzmic_Berry = rgb <0.552941176470588, 0.305882352941176, 0.52156862745098>; // HEX #8D4E85
    #declare Crayola_Red = rgb <0.929411764705882, 0.0392156862745098, 0.247058823529412>; // HEX #ED0A3F
    #declare Crayola_Red_Orange = rgb <1, 0.407843137254902, 0.12156862745098>; // HEX #FF681F
    #declare Crayola_Red_Salsa = rgb <0.992156862745098, 0.227450980392157, 0.290196078431373>; // HEX #FD3A4A
    #declare Crayola_Red_Violet = rgb <0.733333333333333, 0.2, 0.52156862745098>; // HEX #BB3385
    #declare Crayola_Robins_Egg_Blue = rgb <0, 0.8, 0.8>; // HEX #00CCCC
    #declare Crayola_Robot_Canary = rgb <0.611764705882353, 0.486274509803922, 0.219607843137255>; // HEX #9C7C38
    #declare Crayola_Rose_Dust = rgb <0.619607843137255, 0.368627450980392, 0.435294117647059>; // HEX #9E5E6F
    #declare Crayola_Rose_Gold = rgb <0.784313725490196, 0.549019607843137, 0.643137254901961>; // HEX #C88CA4
    #declare Crayola_Rose_Pearl = rgb <0.941176470588235, 0.219607843137255, 0.396078431372549>; // HEX #F03865
    #declare Crayola_Rose_Quartz = rgb <0.741176470588235, 0.333333333333333, 0.611764705882353>; // HEX #BD559C
    #declare Crayola_Royal_Purple = rgb <0.419607843137255, 0.247058823529412, 0.627450980392157>; // HEX #6B3FA0
    #declare Crayola_Ruby = rgb <0.666666666666667, 0.250980392156863, 0.411764705882353>; // HEX #AA4069
    #declare Crayola_Rusty_Red = rgb <0.854901960784314, 0.172549019607843, 0.262745098039216>; // HEX #DA2C43
    #declare Crayola_Salmon = rgb <1, 0.568627450980392, 0.643137254901961>; // HEX #FF91A4
    #declare Crayola_Salmon_Pearl = rgb <0.945098039215686, 0.266666666666667, 0.290196078431373>; // HEX #F1444A
    #declare Crayola_Sapphire = rgb <0.176470588235294, 0.364705882352941, 0.631372549019608>; // HEX #2D5DA1
    #declare Crayola_Sasquatch_Socks = rgb <0.968627450980392, 0.274509803921569, 0.541176470588235>; // HEX #F7468A
    #declare Crayola_Scarlet = rgb <0.992156862745098, 0.0549019607843137, 0.207843137254902>; // HEX #FD0E35
    #declare Crayola_Screamin_Green = rgb <0.4, 1, 0.4>; // HEX #66FF66
    #declare Crayola_Sea_Green = rgb <0.576470588235294, 0.874509803921569, 0.72156862745098>; // HEX #93DFB8
    #declare Crayola_Sea_Serpent = rgb <0, 0.8, 0.8>; // HEX #00CCCC
    #declare Crayola_Sepia = rgb <0.619607843137255, 0.356862745098039, 0.250980392156863>; // HEX #9E5B40
    #declare Crayola_Shadow = rgb <0.513725490196078, 0.43921568627451, 0.313725490196078>; // HEX #837050
    #declare Crayola_Shadow_Blue = rgb <0.466666666666667, 0.545098039215686, 0.647058823529412>; // HEX #778BA5
    #declare Crayola_Shamrock = rgb <0.2, 0.8, 0.6>; // HEX #33CC99
    #declare Crayola_Sheen_Green = rgb <0.56078431372549, 0.831372549019608, 0>; // HEX #8FD400
    #declare Crayola_Shimmering_Blush = rgb <0.850980392156863, 0.525490196078431, 0.584313725490196>; // HEX #D98695
    #declare Crayola_Shiny_Shamrock = rgb <0.372549019607843, 0.654901960784314, 0.470588235294118>; // HEX #5FA778
    #declare Crayola_Shocking_Pink = rgb <1, 0.431372549019608, 1>; // HEX #FF6EFF
    #declare Crayola_Silver = rgb <0.788235294117647, 0.752941176470588, 0.733333333333333>; // HEX #C9C0BB
    #declare Crayola_Sizzling_Red = rgb <1, 0.219607843137255, 0.333333333333333>; // HEX #FF3855
    #declare Crayola_Sky_Blue = rgb <0.462745098039216, 0.843137254901961, 0.917647058823529>; // HEX #76D7EA
    #declare Crayola_Slimy_Green = rgb <0.16078431372549, 0.588235294117647, 0.0901960784313725>; // HEX #299617
    #declare Crayola_Smokey_Topaz = rgb <0.513725490196078, 0.164705882352941, 0.0509803921568627>; // HEX #832A0D
    #declare Crayola_Sonic_Silver = rgb <0.458823529411765, 0.458823529411765, 0.458823529411765>; // HEX #757575
    #declare Crayola_Spring_Frost = rgb <0.4, 1, 0.4>; // HEX #66FF66
    #declare Crayola_Spring_Green = rgb <0.925490196078431, 0.92156862745098, 0.741176470588235>; // HEX #ECEBBD
    #declare Crayola_Steel_Blue = rgb <0, 0.505882352941176, 0.670588235294118>; // HEX #0081AB
    #declare Crayola_Steel_Teal = rgb <0.372549019607843, 0.541176470588235, 0.545098039215686>; // HEX #5F8A8B
    #declare Crayola_Sugar_Plum = rgb <0.568627450980392, 0.305882352941176, 0.458823529411765>; // HEX #914E75
    #declare Crayola_Sunburnt_Cyclops = rgb <0.905882352941176, 0.447058823529412, 0>; // HEX #E77200
    #declare Crayola_Sunglow = rgb <1, 0.8, 0.2>; // HEX #FFCC33
    #declare Crayola_Sunny_Pearl = rgb <0.949019607843137, 0.949019607843137, 0.47843137254902>; // HEX #F2F27A
    #declare Crayola_Sunset_Orange = rgb <0.996078431372549, 0.298039215686275, 0.250980392156863>; // HEX #FE4C40
    #declare Crayola_Sunset_Pearl = rgb <0.945098039215686, 0.8, 0.474509803921569>; // HEX #F1CC79
    #declare Crayola_Sweet_Brown = rgb <0.658823529411765, 0.215686274509804, 0.192156862745098>; // HEX #A83731
    #declare Crayola_Tan = rgb <0.980392156862745, 0.615686274509804, 0.352941176470588>; // HEX #FA9D5A
    #declare Crayola_Tart_Orange = rgb <0.984313725490196, 0.301960784313725, 0.274509803921569>; // HEX #FB4D46
    #declare Crayola_Teal_Blue = rgb <0, 0.501960784313725, 0.501960784313725>; // HEX #008080
    #declare Crayola_Thistle = rgb <0.92156862745098, 0.690196078431373, 0.843137254901961>; // HEX #EBB0D7
    #declare Crayola_Tickle_Me_Pink = rgb <0.988235294117647, 0.501960784313725, 0.647058823529412>; // HEX #FC80A5
    #declare Crayola_Tickle_Me_Pink = rgb <0.988235294117647, 0.501960784313725, 0.647058823529412>; // HEX #FC80A5
    #declare Crayola_Tigers_Eye = rgb <0.709803921568627, 0.411764705882353, 0.0901960784313725>; // HEX #B56917
    #declare Crayola_Timberwolf = rgb <0.850980392156863, 0.83921568627451, 0.811764705882353>; // HEX #D9D6CF
    #declare Crayola_Tropical_Rain_Forest = rgb <0, 0.458823529411765, 0.368627450980392>; // HEX #00755E
    #declare Crayola_Tumbleweed = rgb <0.870588235294118, 0.650980392156863, 0.505882352941176>; // HEX #DEA681
    #declare Crayola_Turquoise_Blue = rgb <0.423529411764706, 0.854901960784314, 0.905882352941176>; // HEX #6CDAE7
    #declare Crayola_Turquoise_Pearl = rgb <0.231372549019608, 0.737254901960784, 0.815686274509804>; // HEX #3BBCD0
    #declare Crayola_Twilight_Lavender = rgb <0.541176470588235, 0.286274509803922, 0.419607843137255>; // HEX #8A496B
    #declare Crayola_Ultramarine_Blue = rgb <0.247058823529412, 0.149019607843137, 0.749019607843137>; // HEX #3F26BF
    #declare Crayola_Van_Dyke_Brown = rgb <0.4, 0.258823529411765, 0.156862745098039>; // HEX #664228
    #declare Crayola_Venetian_Red = rgb <0.8, 0.333333333333333, 0.23921568627451>; // HEX #CC553D
    #declare Crayola_Violet = rgb <0.513725490196078, 0.349019607843137, 0.63921568627451>; // HEX #8359A3
    #declare Crayola_Violet_Blue = rgb <0.462745098039216, 0.431372549019608, 0.784313725490196>; // HEX #766EC8
    #declare Crayola_Violet_I = rgb <0.450980392156863, 0.180392156862745, 0.423529411764706>; // HEX #732E6C
    #declare Crayola_Violet_Red = rgb <0.968627450980392, 0.274509803921569, 0.541176470588235>; // HEX #F7468A
    #declare Crayola_Vivid_Tangerine = rgb <1, 0.6, 0.501960784313725>; // HEX #FF9980
    #declare Crayola_Vivid_Violet = rgb <0.501960784313725, 0.215686274509804, 0.564705882352941>; // HEX #803790
    #declare Crayola_Wild_Blue_Yonder = rgb <0.47843137254902, 0.537254901960784, 0.72156862745098>; // HEX #7A89B8
    #declare Crayola_Wild_Strawberry = rgb <1, 0.2, 0.6>; // HEX #FF3399
    #declare Crayola_Wild_Watermelon = rgb <0.992156862745098, 0.356862745098039, 0.470588235294118>; // HEX #FD5B78
    #declare Crayola_Winter_Wizard = rgb <0.462745098039216, 0.843137254901961, 0.917647058823529>; // HEX #76D7EA
    #declare Crayola_Wintergreen_Dream = rgb <0.337254901960784, 0.533333333333333, 0.490196078431373>; // HEX #56887D
    #declare Crayola_Wisteria = rgb <0.788235294117647, 0.627450980392157, 0.862745098039216>; // HEX #C9A0DC
    #declare Crayola_Yellow = rgb <0.984313725490196, 0.909803921568627, 0.43921568627451>; // HEX #FBE870
    #declare Crayola_Yellow_Green = rgb <0.772549019607843, 0.882352941176471, 0.47843137254902>; // HEX #C5E17A
    #declare Crayola_Yellow_Orange = rgb <1, 0.682352941176471, 0.258823529411765>; // HEX #FFAE42
    #declare Crayola_Yellow_Sunshine = rgb <1, 0.968627450980392, 0>; // HEX #FFF700


// Alternative Crayola color names
    #declare Crayola_Azure_Blue_1949_1958 = Crayola_Blue_I; // HEX #2EB4E6
    #declare Crayola_Baby_Powder = White  ; // HEX #FFFFFF
    #declare Crayola_Babys_Powder = White  ; // HEX #FFFFFF
    #declare Crayola_Banana = Crayola_Dandelion; // HEX #FED85D
    #declare Crayola_Baseball_Mitt = Crayola_Burnt_Sienna; // HEX #E97451
    #declare Crayola_Black = Black  ; // HEX #000000
    #declare Crayola_Blue_Green_1930_1958 = Crayola_Maximum_Blue; // HEX #47ABCC
    #declare Crayola_Blue_Violet_1930_1958 = Crayola_Violet_Blue; // HEX #766EC8
    #declare Crayola_Blueberry = Crayola_Blue_II; // HEX #4570E6
    #declare Crayola_Brink_Pink_1998_2005 = Crayola_Pink_Sherbert; // HEX #F7A38E
    #declare Crayola_Brown_1903_1935 = Crayola_Van_Dyke_Brown; // HEX #664228
    #declare Crayola_Bubble_Bath = Crayola_Tickle_Me_Pink; // HEX #FC80A5
    #declare Crayola_Bubble_Gum = Crayola_Tickle_Me_Pink; // HEX #FC80A5
    #declare Crayola_Carmine_Red_1949_1958 = Crayola_Carmine; // HEX #E62E6B
    #declare Crayola_Cedar_Chest = Crayola_Mahogany; // HEX #CA3435
    #declare Crayola_Celestial_Blue_1935_1949 = Crayola_Blue_I; // HEX #2EB4E6
    #declare Crayola_Chartreuse_1972_1990 = Crayola_Laser_Lemon; // HEX #FFFF66
    #declare Crayola_Cherry = Crayola_Maroon; // HEX #C32148
    #declare Crayola_Chestnut_1999 = Crayola_Indian_Red; // HEX #B94E48
    #declare Crayola_Chocolate = Crayola_Brown; // HEX #AF593E
    #declare Crayola_Chrome_Green_Dark = Crayola_Pine_Green; // HEX #01786F
    #declare Crayola_Chrome_Green_Light = Crayola_Light_Chrome_Green; // HEX #BEE64B
    #declare Crayola_Chrome_Green_Medium_1903_1939 = Crayola_Medium_Chrome_Green; // HEX #6CA67C
    #declare Crayola_Chrome_Yellow_Light = Crayola_Lemon_Yellow_II; // HEX #FFFF9F
    #declare Crayola_Coconut = White  ; // HEX #FFFFFF
    #declare Crayola_Cranberry_1998_2005 = Crayola_Blush; // HEX #DB5079
    #declare Crayola_Daffodil = Crayola_Yellow; // HEX #FBE870
    #declare Crayola_Dark_Chrome_Green = Crayola_Pine_Green; // HEX #01786F
    #declare Crayola_Dark_Green_1903_1949 = Crayola_Pine_Green; // HEX #01786F
    #declare Crayola_Dark_Green_1949_1958 = Crayola_Forest_Green; // HEX #5FA777
    #declare Crayola_Dark_Red_1949_1958 = Crayola_Maroon; // HEX #C32148
    #declare Crayola_Dirt = Crayola_Sepia; // HEX #9E5B40
    #declare Crayola_Earthworm = Crayola_Brick_Red; // HEX #C62D42
    #declare Crayola_Eucalyptus = Crayola_Jungle_Green; // HEX #29AB87
    #declare Crayola_Flesh_1949_1956 = Crayola_Peach; // HEX #FFCBA4
    #declare Crayola_Flesh_1958_1962 = Crayola_Peach; // HEX #FFCBA4
    #declare Crayola_Flesh_Tint_1903_1949 = Crayola_Peach; // HEX #FFCBA4
    #declare Crayola_Flower_Shop = Crayola_Wisteria; // HEX #C9A0DC
    #declare Crayola_Fresh_Air = Crayola_Sky_Blue; // HEX #76D7EA
    #declare Crayola_Fuzzy_Wuzzy_Brown_1998_2005 = Crayola_Fuzzy_Wuzzy; // HEX #87421F
    #declare Crayola_Gargoyle_Gas = Crayola_Dandelion; // HEX #FED85D
    #declare Crayola_Gold_Ochre_1903_1958 = Crayola_Maize; // HEX #F2C649
    #declare Crayola_Golden_Ochre = Crayola_Maize; // HEX #F2C649
    #declare Crayola_Grandmas_Perfume = Crayola_Orange; // HEX #FF8833
    #declare Crayola_Grape = Crayola_Violet; // HEX #8359A3
    #declare Crayola_Grey = Crayola_Gray; // HEX #8B8680
    #declare Crayola_Heat_Wave = Crayola_Wild_Watermelon; // HEX #FD5B78
    #declare Crayola_Jelly_Bean = Crayola_Orange; // HEX #FF8833
    #declare Crayola_Koala_Tree = Crayola_Jungle_Green; // HEX #29AB87
    #declare Crayola_Leather_Jacket = Black  ; // HEX #000000
    #declare Crayola_Lemon = Crayola_Yellow; // HEX #FBE870
    #declare Crayola_Lemon_Glacier = Crayola_Laser_Lemon; // HEX #FFFF66
    #declare Crayola_Licorice = Black  ; // HEX #000000
    #declare Crayola_Light_Chrome_Yellow = Crayola_Lemon_Yellow_II; // HEX #FFFF9F
    #declare Crayola_Light_Green_1903_1935 = Crayola_Light_Chrome_Green; // HEX #BEE64B
    #declare Crayola_Light_Green_1949_1958 = Crayola_Sea_Green; // HEX #93DFB8
    #declare Crayola_Light_Magenta_1949_1958 = Crayola_Thistle; // HEX #EBB0D7
    #declare Crayola_Light_Turquoise_Blue_1949_1958 = Crayola_Aquamarine; // HEX #95E0E8
    #declare Crayola_Light_Yellow_1903_1958 = Crayola_Lemon_Yellow_II; // HEX #FFFF9F
    #declare Crayola_Lilac = Crayola_Wisteria; // HEX #C9A0DC
    #declare Crayola_Lime = Crayola_Yellow_Green; // HEX #C5E17A
    #declare Crayola_Lumber = Crayola_Apricot; // HEX #FDD5B1
    #declare Crayola_Macaroni_n_Cheese = Crayola_Macaroni_and_Cheese; // HEX #FFB97B
    #declare Crayola_Medium_Blue_1949_1958 = Crayola_Blue_II; // HEX #4570E6
    #declare Crayola_Medium_Chrome_Yellow_1903 = Crayola_Goldenrod; // HEX #FCD667
    #declare Crayola_Medium_Green_1903_1939 = Crayola_Medium_Chrome_Green; // HEX #6CA67C
    #declare Crayola_Medium_Orange_1949_1958 = Crayola_Middle_Yellow_Red; // HEX #ECAC76
    #declare Crayola_Medium_Red_Violet_1949_1958 = Crayola_Orchid; // HEX #E29CD2
    #declare Crayola_Medium_Yellow_1903_1958 = Crayola_Goldenrod; // HEX #FCD667
    #declare Crayola_Middle_Blue_Green_1949_1958 = Crayola_Blue_Green; // HEX #0095B7
    #declare Crayola_Middle_Grey_1926_1944 = Crayola_Gray; // HEX #8B8680
    #declare Crayola_Neutral_Grey_1930_1956 = Crayola_Gray; // HEX #8B8680
    #declare Crayola_New_Car = Crayola_Blue_III; // HEX #0066FF
    #declare Crayola_New_Sneakers = Black  ; // HEX #000000
    #declare Crayola_Ogre_Odor = Crayola_Red_Orange; // HEX #FF681F
    #declare Crayola_Permanent_Magenta_1903 = Crayola_Magenta; // HEX #F653A6
    #declare Crayola_Pet_Shop = Crayola_Brown; // HEX #AF593E
    #declare Crayola_Pig_Pink = Crayola_Piggy_Pink; // HEX #FDD7E4
    #declare Crayola_Pine = Crayola_Pine_Green; // HEX #01786F
    #declare Crayola_Pine_Tree = Crayola_Pine_Green; // HEX #01786F
    #declare Crayola_Pink_1903_1917 = Crayola_Carnation_Pink; // HEX #FFA6C9
    #declare Crayola_Pink_Beige_1956_1958 = Crayola_Peach; // HEX #FFCBA4
    #declare Crayola_Prussian_Blue_1903_1958 = Crayola_Midnight_Blue; // HEX #003366
    #declare Crayola_Purple_1903_1914 = Crayola_Violet_I; // HEX #732E6C
    #declare Crayola_Purple_Mountain_Majesty = Crayola_Purple_Mountains_Majesty; // HEX #D6AEDD
    #declare Crayola_Purple_Pizzazz = Crayola_Hot_Magenta; // HEX #FF00CC
    #declare Crayola_Quick_Silver = Gray65; // HEX #A6A6A6
    #declare Crayola_Rose = Crayola_Red; // HEX #ED0A3F
    #declare Crayola_Rose_Pink_1903_1958 = Crayola_Carnation_Pink; // HEX #FFA6C9
    #declare Crayola_Saw_Dust = Crayola_Peach; // HEX #FFCBA4
    #declare Crayola_Shampoo = Crayola_Carnation_Pink; // HEX #FFA6C9
    #declare Crayola_Sharpening_Pencils = Crayola_Goldenrod; // HEX #FCD667
    #declare Crayola_Sizzling_Sunset = Crayola_Atomic_Tangerine; // HEX #FF9966
    #declare Crayola_Smashed_Pumpkin = Crayola_Orange; // HEX #FF8833
    #declare Crayola_Smell_The_Roses = Crayola_Red; // HEX #ED0A3F
    #declare Crayola_Smoke = Crayola_Gray; // HEX #8B8680
    #declare Crayola_Soap = Crayola_Periwinkle; // HEX #C3CDE6
    #declare Crayola_Strawberry = Crayola_Wild_Strawberry; // HEX #FF3399
    #declare Crayola_Sunny_Day = Crayola_Yellow; // HEX #FBE870
    #declare Crayola_Torch_Red_1998 = Crayola_Scarlet; // HEX #FD0E35
    #declare Crayola_Tulip = Crayola_Orange; // HEX #FF8833
    #declare Crayola_Ultra_Green_1972_1990 = Crayola_Screamin_Green; // HEX #66FF66
    #declare Crayola_Ultra_Orange_1972_1990 = Crayola_Outrageous_Orange; // HEX #FF6037
    #declare Crayola_Ultra_Pink_1972_1990 = Crayola_Shocking_Pink; // HEX #FF6EFF
    #declare Crayola_Ultra_Red_1972_1990 = Crayola_Wild_Watermelon; // HEX #FD5B78
    #declare Crayola_Ultra_Yellow_1972_1990 = Crayola_Atomic_Tangerine; // HEX #FF9966
    #declare Crayola_Unmellow_Yellow = Crayola_Laser_Lemon; // HEX #FFFF66
    #declare Crayola_Venetian_Red_Dark = Crayola_Dark_Venetian_Red; // HEX #B33B24
    #declare Crayola_Venetian_Red_Light = Crayola_Light_Venetian_Red; // HEX #E6735C
    #declare Crayola_Vermillion = Crayola_English_Vermilion; // HEX #CC474B
    #declare Crayola_Violet_1949_1958 = Crayola_Blue_Violet; // HEX #6456B7
    #declare Crayola_Violet_II = Crayola_Violet; // HEX #8359A3
    #declare Crayola_Wash_The_Dog = Crayola_Dandelion; // HEX #FED85D
    #declare Crayola_White = White  ; // HEX #FFFFFF
    #declare Crayola_Winter_Sky = Crayola_Hot_Magenta; // HEX #FF00CC


    #version farger_crayola_Inc_Temp;
#end
