// This work is licensed under the Attribution-ShareAlike 4.0 International.
//
//    Persistence of Vision Ray Tracer Include File
//
//    File           : farger_ral_classic.inc
//    Version        : 4.1
//    Created by     : Sven-Erik Andersen
//    Contact        : sven.erik.andersen@gmail.com
//    Created date   : 2014-06-22
//    Last updated   : 2020-07-27
//    Description    : Farger means colors in Norwegian.
//
//

#ifndef(farger_ral_classic_Inc_Temp)
    #declare farger_ral_classic_Inc_Temp = version;
    #version 3.7;

    // Where the color definition is the same as in the POV-Ray color.inc include file,
    // the color name will point to the POV-Ray color definition,
    // so we need to make sure that file is included
    #ifndef(Colors_Inc_Temp)
        #include "colors.inc"
    #end

    #ifdef(View_POV_Include_Stack)
        #debug "including farger_ral_classic.inc\n"
    #end

    // RAL Classic colors, these are defined in the sRGB colour space
    #declare RAL_1000_Green_beige = srgb <0.803921568627451, 0.729411764705882, 0.533333333333333>; // HEX #CDBA88
    #declare RAL_1001_Beige = srgb <0.815686274509804, 0.690196078431373, 0.517647058823529>; // HEX #D0B084
    #declare RAL_1002_Sand_yellow = srgb <0.823529411764706, 0.666666666666667, 0.427450980392157>; // HEX #D2AA6D
    #declare RAL_1003_Signal_yellow = srgb <0.976470588235294, 0.658823529411765, 0>; // HEX #F9A800
    #declare RAL_1004_Golden_yellow = srgb <0.894117647058824, 0.619607843137255, 0>; // HEX #E49E00
    #declare RAL_1005_Honey_yellow = srgb <0.796078431372549, 0.556862745098039, 0>; // HEX #CB8E00
    #declare RAL_1006_Maize_yellow = srgb <0.886274509803922, 0.564705882352941, 0>; // HEX #E29000
    #declare RAL_1007_Daffodil_yellow = srgb <0.909803921568627, 0.549019607843137, 0>; // HEX #E88C00
    #declare RAL_1011_Brown_beige = srgb <0.686274509803922, 0.501960784313725, 0.309803921568627>; // HEX #AF804F
    #declare RAL_1012_Lemon_yellow = srgb <0.866666666666667, 0.686274509803922, 0.152941176470588>; // HEX #DDAF27
    #declare RAL_1013_Oyster_white = srgb <0.890196078431372, 0.850980392156863, 0.776470588235294>; // HEX #E3D9C6
    #declare RAL_1014_Ivory = srgb <0.866666666666667, 0.768627450980392, 0.603921568627451>; // HEX #DDC49A
    #declare RAL_1015_Light_ivory = srgb <0.901960784313726, 0.823529411764706, 0.709803921568627>; // HEX #E6D2B5
    #declare RAL_1016_Sulfur_yellow = srgb <0.945098039215686, 0.866666666666667, 0.219607843137255>; // HEX #F1DD38
    #declare RAL_1017_Saffron_yellow = srgb <0.964705882352941, 0.662745098039216, 0.313725490196078>; // HEX #F6A950
    #declare RAL_1018_Zinc_yellow = srgb <0.980392156862745, 0.792156862745098, 0.188235294117647>; // HEX #FACA30
    #declare RAL_1019_Grey_beige = srgb <0.643137254901961, 0.56078431372549, 0.47843137254902>; // HEX #A48F7A
    #declare RAL_1020_Olive_yellow = srgb <0.627450980392157, 0.56078431372549, 0.396078431372549>; // HEX #A08F65
    #declare RAL_1021_Rape_yellow = srgb <0.964705882352941, 0.713725490196078, 0>; // HEX #F6B600
    #declare RAL_1023_Traffic_yellow = srgb <0.968627450980392, 0.709803921568627, 0>; // HEX #F7B500
    #declare RAL_1024_Ochre_yellow = srgb <0.729411764705882, 0.56078431372549, 0.298039215686275>; // HEX #BA8F4C
    #declare RAL_1027_Curry = srgb <0.654901960784314, 0.498039215686275, 0.0549019607843137>; // HEX #A77F0E
    #declare RAL_1028_Melon_yellow = srgb <1, 0.607843137254902, 0>; // HEX #FF9B00
    #declare RAL_1032_Broom_yellow = srgb <0.886274509803922, 0.63921568627451, 0>; // HEX #E2A300
    #declare RAL_1033_Dahlia_yellow = srgb <0.976470588235294, 0.603921568627451, 0.109803921568627>; // HEX #F99A1C
    #declare RAL_1034_Pastel_yellow = srgb <0.92156862745098, 0.611764705882353, 0.32156862745098>; // HEX #EB9C52
    #declare RAL_1035_Pearl_beige = srgb <0.564705882352941, 0.513725490196078, 0.43921568627451>; // HEX #908370
    #declare RAL_1036_Pearl_gold = srgb <0.501960784313725, 0.392156862745098, 0.247058823529412>; // HEX #80643F
    #declare RAL_1037_Sun_yellow = srgb <0.941176470588235, 0.572549019607843, 0>; // HEX #F09200
    #declare RAL_2000_Yellow_orange = srgb <0.866666666666667, 0.474509803921569, 0.0274509803921569>; // HEX #DD7907
    #declare RAL_2001_Red_orange = srgb <0.745098039215686, 0.305882352941176, 0.125490196078431>; // HEX #BE4E20
    #declare RAL_2002_Vermilion = srgb <0.776470588235294, 0.223529411764706, 0.152941176470588>; // HEX #C63927
    #declare RAL_2003_Pastel_orange = srgb <0.980392156862745, 0.517647058823529, 0.168627450980392>; // HEX #FA842B
    #declare RAL_2004_Pure_orange = srgb <0.905882352941176, 0.356862745098039, 0.0705882352941176>; // HEX #E75B12
    #declare RAL_2005_Luminous_orange = srgb <1, 0.137254901960784, 0>; // HEX #FF2300
    #declare RAL_2007_Luminous_bright_orange = srgb <1, 0.643137254901961, 0.129411764705882>; // HEX #FFA421
    #declare RAL_2008_Bright_red_orange = srgb <0.952941176470588, 0.458823529411765, 0.172549019607843>; // HEX #F3752C
    #declare RAL_2009_Traffic_orange = srgb <0.882352941176471, 0.333333333333333, 0.00392156862745098>; // HEX #E15501
    #declare RAL_2010_Signal_orange = srgb <0.831372549019608, 0.396078431372549, 0.184313725490196>; // HEX #D4652F
    #declare RAL_2011_Deep_orange = srgb <0.925490196078431, 0.486274509803922, 0.145098039215686>; // HEX #EC7C25
    #declare RAL_2012_Salmon_orange = srgb <0.858823529411765, 0.415686274509804, 0.313725490196078>; // HEX #DB6A50
    #declare RAL_2013_Pearl_orange = srgb <0.584313725490196, 0.270588235294118, 0.152941176470588>; // HEX #954527
    #declare RAL_3000_Flame_red = srgb <0.670588235294118, 0.145098039215686, 0.141176470588235>; // HEX #AB2524
    #declare RAL_3001_Signal_red = srgb <0.627450980392157, 0.129411764705882, 0.156862745098039>; // HEX #A02128
    #declare RAL_3002_Carmine_red = srgb <0.631372549019608, 0.137254901960784, 0.168627450980392>; // HEX #A1232B
    #declare RAL_3003_Ruby_red = srgb <0.552941176470588, 0.113725490196078, 0.172549019607843>; // HEX #8D1D2C
    #declare RAL_3004_Purple_red = srgb <0.43921568627451, 0.12156862745098, 0.16078431372549>; // HEX #701F29
    #declare RAL_3005_Wine_red = srgb <0.368627450980392, 0.125490196078431, 0.156862745098039>; // HEX #5E2028
    #declare RAL_3007_Black_red = srgb <0.250980392156863, 0.133333333333333, 0.145098039215686>; // HEX #402225
    #declare RAL_3009_Oxide_red = srgb <0.43921568627451, 0.215686274509804, 0.192156862745098>; // HEX #703731
    #declare RAL_3011_Brown_red = srgb <0.494117647058824, 0.16078431372549, 0.172549019607843>; // HEX #7E292C
    #declare RAL_3012_Beige_red = srgb <0.796078431372549, 0.552941176470588, 0.450980392156863>; // HEX #CB8D73
    #declare RAL_3013_Tomato_red = srgb <0.611764705882353, 0.196078431372549, 0.180392156862745>; // HEX #9C322E
    #declare RAL_3014_Antique_pink = srgb <0.831372549019608, 0.454901960784314, 0.474509803921569>; // HEX #D47479
    #declare RAL_3015_Light_pink = srgb <0.882352941176471, 0.650980392156863, 0.67843137254902>; // HEX #E1A6AD
    #declare RAL_3016_Coral_red = srgb <0.674509803921569, 0.250980392156863, 0.203921568627451>; // HEX #AC4034
    #declare RAL_3017_Rose = srgb <0.827450980392157, 0.329411764705882, 0.372549019607843>; // HEX #D3545F
    #declare RAL_3018_Strawberry_red = srgb <0.819607843137255, 0.254901960784314, 0.32156862745098>; // HEX #D14152
    #declare RAL_3020_Traffic_red = srgb <0.756862745098039, 0.0705882352941176, 0.109803921568627>; // HEX #C1121C
    #declare RAL_3022_Salmon_pink = srgb <0.835294117647059, 0.427450980392157, 0.337254901960784>; // HEX #D56D56
    #declare RAL_3024_Luminous_red = srgb <0.968627450980392, 0, 0>; // HEX #F70000
    #declare RAL_3027_Raspberry_red = srgb <0.705882352941177, 0.125490196078431, 0.254901960784314>; // HEX #B42041
    #declare RAL_3028_Pure_red = srgb <0.905882352941176, 0.145098039215686, 0.0705882352941176>; // HEX #E72512
    #declare RAL_3031_Orient_red = srgb <0.674509803921569, 0.196078431372549, 0.231372549019608>; // HEX #AC323B
    #declare RAL_3032_Pearl_ruby_red = srgb <0.443137254901961, 0.0823529411764706, 0.129411764705882>; // HEX #711521
    #declare RAL_3033_Pearl_pink = srgb <0.698039215686274, 0.298039215686275, 0.262745098039216>; // HEX #B24C43
    #declare RAL_4001_Red_lilac = srgb <0.541176470588235, 0.352941176470588, 0.513725490196078>; // HEX #8A5A83
    #declare RAL_4002_Red_violet = srgb <0.576470588235294, 0.23921568627451, 0.313725490196078>; // HEX #933D50
    #declare RAL_4003_Heather_violet = srgb <0.819607843137255, 0.356862745098039, 0.56078431372549>; // HEX #D15B8F
    #declare RAL_4004_Claret_violet = srgb <0.411764705882353, 0.0862745098039216, 0.223529411764706>; // HEX #691639
    #declare RAL_4005_Blue_lilac = srgb <0.513725490196078, 0.388235294117647, 0.615686274509804>; // HEX #83639D
    #declare RAL_4006_Traffic_purple = srgb <0.6, 0.145098039215686, 0.447058823529412>; // HEX #992572
    #declare RAL_4007_Purple_violet = srgb <0.290196078431373, 0.125490196078431, 0.231372549019608>; // HEX #4A203B
    #declare RAL_4008_Signal_violet = srgb <0.564705882352941, 0.274509803921569, 0.517647058823529>; // HEX #904684
    #declare RAL_4009_Pastel_violet = srgb <0.63921568627451, 0.537254901960784, 0.584313725490196>; // HEX #A38995
    #declare RAL_4010_Telemagenta = srgb <0.776470588235294, 0.211764705882353, 0.470588235294118>; // HEX #C63678
    #declare RAL_4011_Pearl_violet = srgb <0.529411764705882, 0.450980392156863, 0.631372549019608>; // HEX #8773A1
    #declare RAL_4012_Pearl_blackberry = srgb <0.419607843137255, 0.407843137254902, 0.501960784313725>; // HEX #6B6880
    #declare RAL_5000_Violet_blue = srgb <0.219607843137255, 0.298039215686275, 0.43921568627451>; // HEX #384C70
    #declare RAL_5001_Green_blue = srgb <0.12156862745098, 0.27843137254902, 0.392156862745098>; // HEX #1F4764
    #declare RAL_5002_Ultramarine_blue = srgb <0.168627450980392, 0.172549019607843, 0.486274509803922>; // HEX #2B2C7C
    #declare RAL_5003_Sapphire_blue = srgb <0.164705882352941, 0.215686274509804, 0.337254901960784>; // HEX #2A3756
    #declare RAL_5004_Black_blue = srgb <0.113725490196078, 0.12156862745098, 0.164705882352941>; // HEX #1D1F2A
    #declare RAL_5005_Signal_blue = srgb <0.0823529411764706, 0.282352941176471, 0.537254901960784>; // HEX #154889
    #declare RAL_5007_Brilliant_blue = srgb <0.254901960784314, 0.403921568627451, 0.552941176470588>; // HEX #41678D
    #declare RAL_5008_Grey_blue = srgb <0.192156862745098, 0.235294117647059, 0.282352941176471>; // HEX #313C48
    #declare RAL_5009_Azure_blue = srgb <0.180392156862745, 0.349019607843137, 0.470588235294118>; // HEX #2E5978
    #declare RAL_5010_Gentian_blue = srgb <0.0745098039215686, 0.266666666666667, 0.486274509803922>; // HEX #13447C
    #declare RAL_5011_Steel_blue = srgb <0.137254901960784, 0.172549019607843, 0.247058823529412>; // HEX #232C3F
    #declare RAL_5012_Light_blue = srgb <0.203921568627451, 0.505882352941176, 0.72156862745098>; // HEX #3481B8
    #declare RAL_5013_Cobalt_blue = srgb <0.137254901960784, 0.176470588235294, 0.325490196078431>; // HEX #232D53
    #declare RAL_5014_Pigeon_blue = srgb <0.423529411764706, 0.486274509803922, 0.596078431372549>; // HEX #6C7C98
    #declare RAL_5015_Sky_blue = srgb <0.156862745098039, 0.454901960784314, 0.698039215686274>; // HEX #2874B2
    #declare RAL_5017_Traffic_blue = srgb <0.0549019607843137, 0.317647058823529, 0.552941176470588>; // HEX #0E518D
    #declare RAL_5018_Turquoise_blue = srgb <0.129411764705882, 0.533333333333333, 0.56078431372549>; // HEX #21888F
    #declare RAL_5019_Capri_blue = srgb <0.101960784313725, 0.341176470588235, 0.517647058823529>; // HEX #1A5784
    #declare RAL_5020_Ocean_blue = srgb <0.0431372549019608, 0.254901960784314, 0.317647058823529>; // HEX #0B4151
    #declare RAL_5021_Water_blue = srgb <0.0274509803921569, 0.450980392156863, 0.47843137254902>; // HEX #07737A
    #declare RAL_5022_Night_blue = srgb <0.184313725490196, 0.164705882352941, 0.352941176470588>; // HEX #2F2A5A
    #declare RAL_5023_Distant_blue = srgb <0.301960784313725, 0.4, 0.556862745098039>; // HEX #4D668E
    #declare RAL_5024_Pastel_blue = srgb <0.415686274509804, 0.576470588235294, 0.690196078431373>; // HEX #6A93B0
    #declare RAL_5025_Pearl_Gentian_blue = srgb <0.16078431372549, 0.392156862745098, 0.470588235294118>; // HEX #296478
    #declare RAL_5026_Pearl_night_blue = srgb <0.0627450980392157, 0.172549019607843, 0.329411764705882>; // HEX #102C54
    #declare RAL_6000_Patina_green = srgb <0.196078431372549, 0.462745098039216, 0.384313725490196>; // HEX #327662
    #declare RAL_6001_Emerald_green = srgb <0.156862745098039, 0.443137254901961, 0.243137254901961>; // HEX #28713E
    #declare RAL_6002_Leaf_green = srgb <0.152941176470588, 0.384313725490196, 0.207843137254902>; // HEX #276235
    #declare RAL_6003_Olive_green = srgb <0.294117647058824, 0.341176470588235, 0.243137254901961>; // HEX #4B573E
    #declare RAL_6004_Blue_green = srgb <0.0549019607843137, 0.258823529411765, 0.262745098039216>; // HEX #0E4243
    #declare RAL_6005_Moss_green = srgb <0.0588235294117647, 0.262745098039216, 0.211764705882353>; // HEX #0F4336
    #declare RAL_6006_Grey_olive = srgb <0.250980392156863, 0.262745098039216, 0.231372549019608>; // HEX #40433B
    #declare RAL_6007_Bottle_green = srgb <0.156862745098039, 0.203921568627451, 0.141176470588235>; // HEX #283424
    #declare RAL_6008_Brown_green = srgb <0.207843137254902, 0.219607843137255, 0.180392156862745>; // HEX #35382E
    #declare RAL_6009_Fir_green = srgb <0.149019607843137, 0.223529411764706, 0.184313725490196>; // HEX #26392F
    #declare RAL_6010_Grass_green = srgb <0.243137254901961, 0.458823529411765, 0.231372549019608>; // HEX #3E753B
    #declare RAL_6011_Reseda_green = srgb <0.407843137254902, 0.509803921568627, 0.356862745098039>; // HEX #68825B
    #declare RAL_6012_Black_green = srgb <0.192156862745098, 0.250980392156863, 0.23921568627451>; // HEX #31403D
    #declare RAL_6013_Reed_green = srgb <0.474509803921569, 0.486274509803922, 0.352941176470588>; // HEX #797C5A
    #declare RAL_6014_Yellow_olive = srgb <0.266666666666667, 0.262745098039216, 0.215686274509804>; // HEX #444337
    #declare RAL_6015_Black_olive = srgb <0.23921568627451, 0.250980392156863, 0.227450980392157>; // HEX #3D403A
    #declare RAL_6016_Turquoise_green = srgb <0.00784313725490196, 0.415686274509804, 0.32156862745098>; // HEX #026A52
    #declare RAL_6017_May_green = srgb <0.274509803921569, 0.525490196078431, 0.254901960784314>; // HEX #468641
    #declare RAL_6018_Yellow_green = srgb <0.282352941176471, 0.643137254901961, 0.247058823529412>; // HEX #48A43F
    #declare RAL_6019_Pastel_green = srgb <0.717647058823529, 0.850980392156863, 0.694117647058824>; // HEX #B7D9B1
    #declare RAL_6020_Chrome_green = srgb <0.207843137254902, 0.27843137254902, 0.2>; // HEX #354733
    #declare RAL_6021_Pale_green = srgb <0.525490196078431, 0.643137254901961, 0.486274509803922>; // HEX #86A47C
    #declare RAL_6022_Olive_drab_brown_olive = srgb <0.243137254901961, 0.235294117647059, 0.196078431372549>; // HEX #3E3C32
    #declare RAL_6024_Traffic_green = srgb <0, 0.529411764705882, 0.329411764705882>; // HEX #008754
    #declare RAL_6025_Fern_green = srgb <0.325490196078431, 0.458823529411765, 0.235294117647059>; // HEX #53753C
    #declare RAL_6026_Opal_green = srgb <0, 0.364705882352941, 0.32156862745098>; // HEX #005D52
    #declare RAL_6027_Light_green = srgb <0.505882352941176, 0.752941176470588, 0.733333333333333>; // HEX #81C0BB
    #declare RAL_6028_Pine_green = srgb <0.176470588235294, 0.333333333333333, 0.274509803921569>; // HEX #2D5546
    #declare RAL_6029_Mint_green = srgb <0, 0.447058823529412, 0.262745098039216>; // HEX #007243
    #declare RAL_6032_Signal_green = srgb <0.0588235294117647, 0.52156862745098, 0.345098039215686>; // HEX #0F8558
    #declare RAL_6033_Mint_turquoise = srgb <0.27843137254902, 0.541176470588235, 0.517647058823529>; // HEX #478A84
    #declare RAL_6034_Pastel_turquoise = srgb <0.498039215686275, 0.690196078431373, 0.698039215686274>; // HEX #7FB0B2
    #declare RAL_6035_Pearl_green = srgb <0.105882352941176, 0.329411764705882, 0.172549019607843>; // HEX #1B542C
    #declare RAL_6036_Pearl_opal_green = srgb <0, 0.364705882352941, 0.298039215686275>; // HEX #005D4C
    #declare RAL_6037_Pure_green = srgb <0.145098039215686, 0.905882352941176, 0.0705882352941176>; // HEX #25E712
    #declare RAL_6038_Luminous_green = srgb <0, 0.968627450980392, 0>; // HEX #00F700
    #declare RAL_7000_Squirrel_grey = srgb <0.494117647058824, 0.545098039215686, 0.572549019607843>; // HEX #7E8B92
    #declare RAL_7001_Silver_grey = srgb <0.56078431372549, 0.6, 0.623529411764706>; // HEX #8F999F
    #declare RAL_7002_Olive_grey = srgb <0.505882352941176, 0.498039215686275, 0.407843137254902>; // HEX #817F68
    #declare RAL_7003_Moss_grey = srgb <0.47843137254902, 0.482352941176471, 0.427450980392157>; // HEX #7A7B6D
    #declare RAL_7004_Signal_grey = srgb <0.619607843137255, 0.627450980392157, 0.631372549019608>; // HEX #9EA0A1
    #declare RAL_7005_Mouse_grey = srgb <0.419607843137255, 0.443137254901961, 0.435294117647059>; // HEX #6B716F
    #declare RAL_7006_Beige_grey = srgb <0.458823529411765, 0.435294117647059, 0.380392156862745>; // HEX #756F61
    #declare RAL_7008_Khaki_grey = srgb <0.454901960784314, 0.4, 0.262745098039216>; // HEX #746643
    #declare RAL_7009_Green_grey = srgb <0.356862745098039, 0.384313725490196, 0.349019607843137>; // HEX #5B6259
    #declare RAL_7010_Tarpaulin_grey = srgb <0.341176470588235, 0.364705882352941, 0.341176470588235>; // HEX #575D57
    #declare RAL_7011_Iron_grey = srgb <0.333333333333333, 0.364705882352941, 0.380392156862745>; // HEX #555D61
    #declare RAL_7012_Basalt_grey = srgb <0.349019607843137, 0.380392156862745, 0.388235294117647>; // HEX #596163
    #declare RAL_7013_Brown_grey = srgb <0.333333333333333, 0.333333333333333, 0.282352941176471>; // HEX #555548
    #declare RAL_7015_Slate_grey = srgb <0.317647058823529, 0.337254901960784, 0.36078431372549>; // HEX #51565C
    #declare RAL_7016_Anthracite_grey = srgb <0.215686274509804, 0.247058823529412, 0.262745098039216>; // HEX #373F43
    #declare RAL_7021_Black_grey = srgb <0.180392156862745, 0.196078431372549, 0.203921568627451>; // HEX #2E3234
    #declare RAL_7022_Umbra_grey = srgb <0.294117647058824, 0.301960784313725, 0.274509803921569>; // HEX #4B4D46
    #declare RAL_7023_Concrete_grey = srgb <0.505882352941176, 0.517647058823529, 0.474509803921569>; // HEX #818479
    #declare RAL_7024_Graphite_grey = srgb <0.27843137254902, 0.290196078431373, 0.313725490196078>; // HEX #474A50
    #declare RAL_7026_Granite_grey = srgb <0.215686274509804, 0.266666666666667, 0.27843137254902>; // HEX #374447
    #declare RAL_7030_Stone_grey = srgb <0.576470588235294, 0.576470588235294, 0.533333333333333>; // HEX #939388
    #declare RAL_7031_Blue_grey = srgb <0.364705882352941, 0.411764705882353, 0.43921568627451>; // HEX #5D6970
    #declare RAL_7032_Pebble_grey = srgb <0.725490196078431, 0.725490196078431, 0.658823529411765>; // HEX #B9B9A8
    #declare RAL_7033_Cement_grey = srgb <0.505882352941176, 0.537254901960784, 0.474509803921569>; // HEX #818979
    #declare RAL_7034_Yellow_grey = srgb <0.576470588235294, 0.568627450980392, 0.462745098039216>; // HEX #939176
    #declare RAL_7035_Light_grey = srgb <0.796078431372549, 0.815686274509804, 0.8>; // HEX #CBD0CC
    #declare RAL_7036_Platinum_grey = srgb <0.603921568627451, 0.588235294117647, 0.592156862745098>; // HEX #9A9697
    #declare RAL_7037_Dusty_grey = srgb <0.486274509803922, 0.498039215686275, 0.494117647058824>; // HEX #7C7F7E
    #declare RAL_7038_Agate_grey = srgb <0.705882352941177, 0.72156862745098, 0.690196078431373>; // HEX #B4B8B0
    #declare RAL_7039_Quartz_grey = srgb <0.419607843137255, 0.411764705882353, 0.372549019607843>; // HEX #6B695F
    #declare RAL_7040_Window_grey = srgb <0.615686274509804, 0.63921568627451, 0.650980392156863>; // HEX #9DA3A6
    #declare RAL_7042_Traffic_grey_A = srgb <0.56078431372549, 0.588235294117647, 0.584313725490196>; // HEX #8F9695
    #declare RAL_7043_Traffic_grey_B = srgb <0.305882352941176, 0.329411764705882, 0.317647058823529>; // HEX #4E5451
    #declare RAL_7044_Silk_grey = srgb <0.741176470588235, 0.741176470588235, 0.698039215686274>; // HEX #BDBDB2
    #declare RAL_7045_Telegrey_1 = srgb <0.568627450980392, 0.588235294117647, 0.603921568627451>; // HEX #91969A
    #declare RAL_7046_Telegrey_2 = srgb <0.509803921568627, 0.537254901960784, 0.556862745098039>; // HEX #82898E
    #declare RAL_7047_Telegrey_4 = srgb <0.811764705882353, 0.815686274509804, 0.811764705882353>; // HEX #CFD0CF
    #declare RAL_7048_Pearl_mouse_grey = srgb <0.533333333333333, 0.505882352941176, 0.458823529411765>; // HEX #888175
    #declare RAL_8000_Green_brown = srgb <0.533333333333333, 0.443137254901961, 0.258823529411765>; // HEX #887142
    #declare RAL_8001_Ochre_brown = srgb <0.611764705882353, 0.419607843137255, 0.188235294117647>; // HEX #9C6B30
    #declare RAL_8002_Signal_brown = srgb <0.482352941176471, 0.317647058823529, 0.254901960784314>; // HEX #7B5141
    #declare RAL_8003_Clay_brown = srgb <0.501960784313725, 0.329411764705882, 0.184313725490196>; // HEX #80542F
    #declare RAL_8004_Copper_brown = srgb <0.56078431372549, 0.305882352941176, 0.207843137254902>; // HEX #8F4E35
    #declare RAL_8007_Fawn_brown = srgb <0.435294117647059, 0.290196078431373, 0.184313725490196>; // HEX #6F4A2F
    #declare RAL_8008_Olive_brown = srgb <0.435294117647059, 0.309803921568627, 0.156862745098039>; // HEX #6F4F28
    #declare RAL_8011_Nut_brown = srgb <0.352941176470588, 0.227450980392157, 0.16078431372549>; // HEX #5A3A29
    #declare RAL_8012_Red_brown = srgb <0.403921568627451, 0.219607843137255, 0.192156862745098>; // HEX #673831
    #declare RAL_8014_Sepia_brown = srgb <0.286274509803922, 0.223529411764706, 0.176470588235294>; // HEX #49392D
    #declare RAL_8015_Chestnut_brown = srgb <0.388235294117647, 0.227450980392157, 0.203921568627451>; // HEX #633A34
    #declare RAL_8016_Mahogany_brown = srgb <0.298039215686275, 0.184313725490196, 0.149019607843137>; // HEX #4C2F26
    #declare RAL_8017_Chocolate_brown = srgb <0.266666666666667, 0.196078431372549, 0.176470588235294>; // HEX #44322D
    #declare RAL_8019_Grey_brown = srgb <0.247058823529412, 0.227450980392157, 0.227450980392157>; // HEX #3F3A3A
    #declare RAL_8022_Black_brown = srgb <0.129411764705882, 0.12156862745098, 0.125490196078431>; // HEX #211F20
    #declare RAL_8023_Orange_brown = srgb <0.650980392156863, 0.368627450980392, 0.184313725490196>; // HEX #A65E2F
    #declare RAL_8024_Beige_brown = srgb <0.474509803921569, 0.333333333333333, 0.235294117647059>; // HEX #79553C
    #declare RAL_8025_Pale_brown = srgb <0.458823529411765, 0.36078431372549, 0.286274509803922>; // HEX #755C49
    #declare RAL_8028_Terra_brown = srgb <0.305882352941176, 0.231372549019608, 0.168627450980392>; // HEX #4E3B2B
    #declare RAL_8029_Pearl_copper = srgb <0.466666666666667, 0.235294117647059, 0.152941176470588>; // HEX #773C27
    #declare RAL_9001_Cream = srgb <0.937254901960784, 0.92156862745098, 0.862745098039216>; // HEX #EFEBDC
    #declare RAL_9002_Grey_white = srgb <0.866666666666667, 0.870588235294118, 0.831372549019608>; // HEX #DDDED4
    #declare RAL_9003_Signal_white = srgb <0.956862745098039, 0.972549019607843, 0.956862745098039>; // HEX #F4F8F4
    #declare RAL_9004_Signal_black = srgb <0.180392156862745, 0.188235294117647, 0.196078431372549>; // HEX #2E3032
    #declare RAL_9005_Jet_black = srgb <0.0392156862745098, 0.0392156862745098, 0.0509803921568627>; // HEX #0A0A0D
    #declare RAL_9006_White_aluminium = srgb <0.647058823529412, 0.658823529411765, 0.650980392156863>; // HEX #A5A8A6
    #declare RAL_9007_Grey_aluminium = srgb <0.56078431372549, 0.56078431372549, 0.549019607843137>; // HEX #8F8F8C
    #declare RAL_9010_Pure_white = srgb <0.968627450980392, 0.976470588235294, 0.937254901960784>; // HEX #F7F9EF
    #declare RAL_9011_Graphite_black = srgb <0.16078431372549, 0.172549019607843, 0.184313725490196>; // HEX #292C2F
    #declare RAL_9016_Traffic_white = srgb <0.968627450980392, 0.984313725490196, 0.96078431372549>; // HEX #F7FBF5
    #declare RAL_9017_Traffic_black = srgb <0.164705882352941, 0.176470588235294, 0.184313725490196>; // HEX #2A2D2F
    #declare RAL_9018_Papyrus_white = srgb <0.811764705882353, 0.827450980392157, 0.803921568627451>; // HEX #CFD3CD
    #declare RAL_9022_Pearl_light_grey = srgb <0.611764705882353, 0.611764705882353, 0.611764705882353>; // HEX #9C9C9C
    #declare RAL_9023_Pearl_dark_grey = srgb <0.494117647058824, 0.505882352941176, 0.509803921568627>; // HEX #7E8182


    // Alternative farge color names
    #declare RAL_1026_Luminous_yellow = Yellow; // HEX #FFFF00
    #declare RAL_3026_Luminous_bright_red = Red; // HEX #FF0000


    #version farger_ral_classic_Inc_Temp;
#end
