//    Persistence of Vision Ray Tracer Include File
//
//    File           : Farger_PC.inc
//    Version        : 4.1
//    Created by     : Sven-Erik Andersen
//    Contact        : sven.erik.andersen@gmail.com
//    Created date   : 2014-06-22
//    Last updated   : 2020-07-27
//    Description    : This is based on a list of named colors in a proprietary color space found on the Internet that now has been taken down...
//                     https://en.wikipedia.org/wiki/Pantone#Intellectual_property
//
//

#ifndef(Farger_PC_Inc_Temp)
    #declare Farger_PC_Inc_Temp = version;
    #version 3.7;

    #ifdef(View_POV_Include_Stack)
        #debug "including Farger_PC.inc\n"
    #end

    #declare farge_PC_100_C = rgb <0.964705882352941, 0.92156862745098, 0.380392156862745>; // HEX #F6EB61
    #declare farge_PC_101_C = rgb <0.968627450980392, 0.917647058823529, 0.282352941176471>; // HEX #F7EA48
    #declare farge_PC_102_C = rgb <0.988235294117647, 0.890196078431372, 0>; // HEX #FCE300
    #declare farge_PC_103_C = rgb <0.772549019607843, 0.662745098039216, 0>; // HEX #C5A900
    #declare farge_PC_104_C = rgb <0.686274509803922, 0.596078431372549, 0>; // HEX #AF9800
    #declare farge_PC_105_C = rgb <0.537254901960784, 0.47843137254902, 0.152941176470588>; // HEX #897A27
    #declare farge_PC_106_C = rgb <0.976470588235294, 0.898039215686275, 0.27843137254902>; // HEX #F9E547
    #declare farge_PC_107_C = rgb <0.984313725490196, 0.882352941176471, 0.133333333333333>; // HEX #FBE122
    #declare farge_PC_108_C = rgb <0.996078431372549, 0.858823529411765, 0>; // HEX #FEDB00
    #declare farge_PC_109_C = rgb <1, 0.819607843137255, 0>; // HEX #FFD100
    #declare farge_PC_110_C = rgb <0.854901960784314, 0.666666666666667, 0>; // HEX #DAAA00
    #declare farge_PC_111_C = rgb <0.666666666666667, 0.541176470588235, 0>; // HEX #AA8A00
    #declare farge_PC_112_C = rgb <0.611764705882353, 0.517647058823529, 0.0705882352941176>; // HEX #9C8412
    #declare farge_PC_113_C = rgb <0.980392156862745, 0.87843137254902, 0.325490196078431>; // HEX #FAE053
    #declare farge_PC_114_C = rgb <0.984313725490196, 0.866666666666667, 0.250980392156863>; // HEX #FBDD40
    #declare farge_PC_115_C = rgb <0.992156862745098, 0.854901960784314, 0.141176470588235>; // HEX #FDDA24
    #declare farge_PC_116_C = rgb <1, 0.803921568627451, 0>; // HEX #FFCD00
    #declare farge_PC_117_C = rgb <0.788235294117647, 0.592156862745098, 0>; // HEX #C99700
    #declare farge_PC_118_C = rgb <0.674509803921569, 0.517647058823529, 0>; // HEX #AC8400
    #declare farge_PC_119_C = rgb <0.537254901960784, 0.450980392156863, 0.133333333333333>; // HEX #897322
    #declare farge_PC_120_C = rgb <0.984313725490196, 0.858823529411765, 0.396078431372549>; // HEX #FBDB65
    #declare farge_PC_1205_C = rgb <0.972549019607843, 0.87843137254902, 0.556862745098039>; // HEX #F8E08E
    #declare farge_PC_121_C = rgb <0.992156862745098, 0.843137254901961, 0.341176470588235>; // HEX #FDD757
    #declare farge_PC_1215_C = rgb <0.984313725490196, 0.847058823529412, 0.447058823529412>; // HEX #FBD872
    #declare farge_PC_122_C = rgb <0.996078431372549, 0.819607843137255, 0.254901960784314>; // HEX #FED141
    #declare farge_PC_1225_C = rgb <1, 0.784313725490196, 0.270588235294118>; // HEX #FFC845
    #declare farge_PC_123_C = rgb <1, 0.780392156862745, 0.172549019607843>; // HEX #FFC72C
    #declare farge_PC_1235_C = rgb <1, 0.72156862745098, 0.109803921568627>; // HEX #FFB81C
    #declare farge_PC_124_C = rgb <0.917647058823529, 0.666666666666667, 0>; // HEX #EAAA00
    #declare farge_PC_1245_C = rgb <0.776470588235294, 0.572549019607843, 0.0784313725490196>; // HEX #C69214
    #declare farge_PC_125_C = rgb <0.709803921568627, 0.52156862745098, 0>; // HEX #B58500
    #declare farge_PC_1255_C = rgb <0.67843137254902, 0.517647058823529, 0.12156862745098>; // HEX #AD841F
    #declare farge_PC_126_C = rgb <0.603921568627451, 0.462745098039216, 0.0666666666666667>; // HEX #9A7611
    #declare farge_PC_1265_C = rgb <0.533333333333333, 0.419607843137255, 0.145098039215686>; // HEX #886B25
    #declare farge_PC_127_C = rgb <0.952941176470588, 0.866666666666667, 0.427450980392157>; // HEX #F3DD6D
    #declare farge_PC_128_C = rgb <0.952941176470588, 0.835294117647059, 0.305882352941176>; // HEX #F3D54E
    #declare farge_PC_129_C = rgb <0.952941176470588, 0.815686274509804, 0.243137254901961>; // HEX #F3D03E
    #declare farge_PC_130_C = rgb <0.949019607843137, 0.662745098039216, 0>; // HEX #F2A900
    #declare farge_PC_131_C = rgb <0.8, 0.541176470588235, 0>; // HEX #CC8A00
    #declare farge_PC_132_C = rgb <0.627450980392157, 0.454901960784314, 0>; // HEX #A07400
    #declare farge_PC_133_C = rgb <0.423529411764706, 0.341176470588235, 0.105882352941176>; // HEX #6C571B
    #declare farge_PC_134_C = rgb <0.992156862745098, 0.823529411764706, 0.431372549019608>; // HEX #FDD26E
    #declare farge_PC_1345_C = rgb <0.992156862745098, 0.815686274509804, 0.525490196078431>; // HEX #FDD086
    #declare farge_PC_135_C = rgb <1, 0.776470588235294, 0.345098039215686>; // HEX #FFC658
    #declare farge_PC_1355_C = rgb <1, 0.772549019607843, 0.431372549019608>; // HEX #FFC56E
    #declare farge_PC_136_C = rgb <1, 0.749019607843137, 0.247058823529412>; // HEX #FFBF3F
    #declare farge_PC_1365_C = rgb <1, 0.709803921568627, 0.286274509803922>; // HEX #FFB549
    #declare farge_PC_137_C = rgb <1, 0.63921568627451, 0>; // HEX #FFA300
    #declare farge_PC_1375_C = rgb <1, 0.619607843137255, 0.105882352941176>; // HEX #FF9E1B
    #declare farge_PC_138_C = rgb <0.870588235294118, 0.486274509803922, 0>; // HEX #DE7C00
    #declare farge_PC_1385_C = rgb <0.835294117647059, 0.470588235294118, 0>; // HEX #D57800
    #declare farge_PC_139_C = rgb <0.686274509803922, 0.427450980392157, 0.0156862745098039>; // HEX #AF6D04
    #declare farge_PC_1395_C = rgb <0.6, 0.376470588235294, 0.0901960784313725>; // HEX #996017
    #declare farge_PC_140_C = rgb <0.454901960784314, 0.325490196078431, 0.109803921568627>; // HEX #74531C
    #declare farge_PC_1405_C = rgb <0.431372549019608, 0.298039215686275, 0.117647058823529>; // HEX #6E4C1E
    #declare farge_PC_141_C = rgb <0.949019607843137, 0.780392156862745, 0.36078431372549>; // HEX #F2C75C
    #declare farge_PC_142_C = rgb <0.945098039215686, 0.745098039215686, 0.282352941176471>; // HEX #F1BE48
    #declare farge_PC_143_C = rgb <0.945098039215686, 0.705882352941177, 0.203921568627451>; // HEX #F1B434
    #declare farge_PC_144_C = rgb <0.929411764705882, 0.545098039215686, 0>; // HEX #ED8B00
    #declare farge_PC_145_C = rgb <0.811764705882353, 0.498039215686275, 0>; // HEX #CF7F00
    #declare farge_PC_146_C = rgb <0.654901960784314, 0.427450980392157, 0.0666666666666667>; // HEX #A76D11
    #declare farge_PC_147_C = rgb <0.443137254901961, 0.36078431372549, 0.164705882352941>; // HEX #715C2A
    #declare farge_PC_148_C = rgb <0.996078431372549, 0.796078431372549, 0.545098039215686>; // HEX #FECB8B
    #declare farge_PC_1485_C = rgb <1, 0.682352941176471, 0.384313725490196>; // HEX #FFAE62
    #declare farge_PC_149_C = rgb <1, 0.76078431372549, 0.482352941176471>; // HEX #FFC27B
    #declare farge_PC_1495_C = rgb <1, 0.56078431372549, 0.109803921568627>; // HEX #FF8F1C
    #declare farge_PC_150_C = rgb <1, 0.698039215686274, 0.356862745098039>; // HEX #FFB25B
    #declare farge_PC_1505_C = rgb <1, 0.411764705882353, 0>; // HEX #FF6900
    #declare farge_PC_151_C = rgb <1, 0.509803921568627, 0>; // HEX #FF8200
    #declare farge_PC_152_C = rgb <0.898039215686275, 0.447058823529412, 0>; // HEX #E57200
    #declare farge_PC_1525_C = rgb <0.725490196078431, 0.27843137254902, 0>; // HEX #B94700
    #declare farge_PC_153_C = rgb <0.745098039215686, 0.415686274509804, 0.0784313725490196>; // HEX #BE6A14
    #declare farge_PC_1535_C = rgb <0.580392156862745, 0.270588235294118, 0.0431372549019608>; // HEX #94450B
    #declare farge_PC_154_C = rgb <0.607843137254902, 0.352941176470588, 0.101960784313725>; // HEX #9B5A1A
    #declare farge_PC_1545_C = rgb <0.396078431372549, 0.219607843137255, 0.0980392156862745>; // HEX #653819
    #declare farge_PC_155_C = rgb <0.937254901960784, 0.819607843137255, 0.623529411764706>; // HEX #EFD19F
    #declare farge_PC_1555_C = rgb <1, 0.725490196078431, 0.564705882352941>; // HEX #FFB990
    #declare farge_PC_156_C = rgb <0.937254901960784, 0.745098039215686, 0.490196078431373>; // HEX #EFBE7D
    #declare farge_PC_1565_C = rgb <1, 0.627450980392157, 0.415686274509804>; // HEX #FFA06A
    #declare farge_PC_157_C = rgb <0.925490196078431, 0.631372549019608, 0.329411764705882>; // HEX #ECA154
    #declare farge_PC_1575_C = rgb <1, 0.498039215686275, 0.196078431372549>; // HEX #FF7F32
    #declare farge_PC_158_C = rgb <0.909803921568627, 0.466666666666667, 0.133333333333333>; // HEX #E87722
    #declare farge_PC_1585_C = rgb <1, 0.415686274509804, 0.0745098039215686>; // HEX #FF6A13
    #declare farge_PC_159_C = rgb <0.796078431372549, 0.376470588235294, 0.0823529411764706>; // HEX #CB6015
    #declare farge_PC_1595_C = rgb <0.847058823529412, 0.376470588235294, 0.0941176470588235>; // HEX #D86018
    #declare farge_PC_160_C = rgb <0.631372549019608, 0.337254901960784, 0.109803921568627>; // HEX #A1561C
    #declare farge_PC_1605_C = rgb <0.650980392156863, 0.333333333333333, 0.137254901960784>; // HEX #A65523
    #declare farge_PC_161_C = rgb <0.376470588235294, 0.23921568627451, 0.125490196078431>; // HEX #603D20
    #declare farge_PC_1615_C = rgb <0.545098039215686, 0.27843137254902, 0.125490196078431>; // HEX #8B4720
    #declare farge_PC_162_C = rgb <1, 0.745098039215686, 0.623529411764706>; // HEX #FFBE9F
    #declare farge_PC_1625_C = rgb <1, 0.63921568627451, 0.545098039215686>; // HEX #FFA38B
    #declare farge_PC_163_C = rgb <1, 0.615686274509804, 0.431372549019608>; // HEX #FF9D6E
    #declare farge_PC_1635_C = rgb <1, 0.552941176470588, 0.427450980392157>; // HEX #FF8D6D
    #declare farge_PC_164_C = rgb <1, 0.498039215686275, 0.254901960784314>; // HEX #FF7F41
    #declare farge_PC_1645_C = rgb <1, 0.415686274509804, 0.223529411764706>; // HEX #FF6A39
    #declare farge_PC_165_C = rgb <1, 0.403921568627451, 0.12156862745098>; // HEX #FF671F
    #declare farge_PC_1655_C = rgb <0.988235294117647, 0.298039215686275, 0.00784313725490196>; // HEX #FC4C02
    #declare farge_PC_166_C = rgb <0.890196078431372, 0.32156862745098, 0.0196078431372549>; // HEX #E35205
    #declare farge_PC_1665_C = rgb <0.862745098039216, 0.266666666666667, 0.0196078431372549>; // HEX #DC4405
    #declare farge_PC_167_C = rgb <0.745098039215686, 0.325490196078431, 0.109803921568627>; // HEX #BE531C
    #declare farge_PC_1675_C = rgb <0.662745098039216, 0.262745098039216, 0.117647058823529>; // HEX #A9431E
    #declare farge_PC_168_C = rgb <0.450980392156863, 0.219607843137255, 0.113725490196078>; // HEX #73381D
    #declare farge_PC_1685_C = rgb <0.513725490196078, 0.223529411764706, 0.129411764705882>; // HEX #833921
    #declare farge_PC_169_C = rgb <1, 0.701960784313725, 0.670588235294118>; // HEX #FFB3AB
    #declare farge_PC_170_C = rgb <1, 0.525490196078431, 0.454901960784314>; // HEX #FF8674
    #declare farge_PC_171_C = rgb <1, 0.36078431372549, 0.223529411764706>; // HEX #FF5C39
    #declare farge_PC_172_C = rgb <0.980392156862745, 0.274509803921569, 0.0862745098039216>; // HEX #FA4616
    #declare farge_PC_173_C = rgb <0.811764705882353, 0.270588235294118, 0.125490196078431>; // HEX #CF4520
    #declare farge_PC_174_C = rgb <0.588235294117647, 0.219607843137255, 0.129411764705882>; // HEX #963821
    #declare farge_PC_175_C = rgb <0.419607843137255, 0.207843137254902, 0.16078431372549>; // HEX #6B3529
    #declare farge_PC_176_C = rgb <1, 0.694117647058824, 0.733333333333333>; // HEX #FFB1BB
    #declare farge_PC_1765_C = rgb <1, 0.63921568627451, 0.709803921568627>; // HEX #FFA3B5
    #declare farge_PC_1767_C = rgb <0.988235294117647, 0.686274509803922, 0.752941176470588>; // HEX #FCAFC0
    #declare farge_PC_177_C = rgb <1, 0.501960784313725, 0.545098039215686>; // HEX #FF808B
    #declare farge_PC_1775_C = rgb <1, 0.552941176470588, 0.631372549019608>; // HEX #FF8DA1
    #declare farge_PC_1777_C = rgb <0.984313725490196, 0.388235294117647, 0.494117647058824>; // HEX #FB637E
    #declare farge_PC_178_C = rgb <1, 0.345098039215686, 0.364705882352941>; // HEX #FF585D
    #declare farge_PC_1785_C = rgb <0.972549019607843, 0.282352941176471, 0.368627450980392>; // HEX #F8485E
    #declare farge_PC_1787_C = rgb <0.956862745098039, 0.211764705882353, 0.298039215686275>; // HEX #F4364C
    #declare farge_PC_1788_C = rgb <0.933333333333333, 0.152941176470588, 0.215686274509804>; // HEX #EE2737
    #declare farge_PC_179_C = rgb <0.87843137254902, 0.235294117647059, 0.192156862745098>; // HEX #E03C31
    #declare farge_PC_1795_C = rgb <0.823529411764706, 0.149019607843137, 0.188235294117647>; // HEX #D22630
    #declare farge_PC_1797_C = rgb <0.796078431372549, 0.2, 0.231372549019608>; // HEX #CB333B
    #declare farge_PC_180_C = rgb <0.745098039215686, 0.227450980392157, 0.203921568627451>; // HEX #BE3A34
    #declare farge_PC_1805_C = rgb <0.686274509803922, 0.152941176470588, 0.184313725490196>; // HEX #AF272F
    #declare farge_PC_1807_C = rgb <0.643137254901961, 0.203921568627451, 0.227450980392157>; // HEX #A4343A
    #declare farge_PC_181_C = rgb <0.505882352941176, 0.192156862745098, 0.184313725490196>; // HEX #81312F
    #declare farge_PC_1815_C = rgb <0.486274509803922, 0.145098039215686, 0.16078431372549>; // HEX #7C2529
    #declare farge_PC_1817_C = rgb <0.392156862745098, 0.2, 0.207843137254902>; // HEX #643335
    #declare farge_PC_182_C = rgb <0.980392156862745, 0.733333333333333, 0.796078431372549>; // HEX #FABBCB
    #declare farge_PC_183_C = rgb <0.988235294117647, 0.607843137254902, 0.701960784313725>; // HEX #FC9BB3
    #declare farge_PC_184_C = rgb <0.964705882352941, 0.32156862745098, 0.458823529411765>; // HEX #F65275
    #declare farge_PC_185_C = rgb <0.894117647058824, 0, 0.168627450980392>; // HEX #E4002B
    #declare farge_PC_186_C = rgb <0.784313725490196, 0.0627450980392157, 0.180392156862745>; // HEX #C8102E
    #declare farge_PC_187_C = rgb <0.650980392156863, 0.0980392156862745, 0.180392156862745>; // HEX #A6192E
    #declare farge_PC_188_C = rgb <0.462745098039216, 0.137254901960784, 0.184313725490196>; // HEX #76232F
    #declare farge_PC_189_C = rgb <0.972549019607843, 0.63921568627451, 0.737254901960784>; // HEX #F8A3BC
    #declare farge_PC_1895_C = rgb <0.96078431372549, 0.713725490196078, 0.803921568627451>; // HEX #F5B6CD
    #declare farge_PC_190_C = rgb <0.964705882352941, 0.458823529411765, 0.6>; // HEX #F67599
    #declare farge_PC_1905_C = rgb <0.96078431372549, 0.607843137254902, 0.733333333333333>; // HEX #F59BBB
    #declare farge_PC_191_C = rgb <0.937254901960784, 0.258823529411765, 0.435294117647059>; // HEX #EF426F
    #declare farge_PC_1915_C = rgb <0.937254901960784, 0.290196078431373, 0.505882352941176>; // HEX #EF4A81
    #declare farge_PC_192_C = rgb <0.894117647058824, 0, 0.274509803921569>; // HEX #E40046
    #declare farge_PC_1925_C = rgb <0.87843137254902, 0, 0.301960784313725>; // HEX #E0004D
    #declare farge_PC_193_C = rgb <0.749019607843137, 0.0509803921568627, 0.243137254901961>; // HEX #BF0D3E
    #declare farge_PC_1935_C = rgb <0.772549019607843, 0, 0.243137254901961>; // HEX #C5003E
    #declare farge_PC_194_C = rgb <0.607843137254902, 0.152941176470588, 0.262745098039216>; // HEX #9B2743
    #declare farge_PC_1945_C = rgb <0.650980392156863, 0.0352941176470588, 0.23921568627451>; // HEX #A6093D
    #declare farge_PC_195_C = rgb <0.470588235294118, 0.184313725490196, 0.250980392156863>; // HEX #782F40
    #declare farge_PC_1955_C = rgb <0.541176470588235, 0.0823529411764706, 0.219607843137255>; // HEX #8A1538
    #declare farge_PC_196_C = rgb <0.925490196078431, 0.780392156862745, 0.803921568627451>; // HEX #ECC7CD
    #declare farge_PC_197_C = rgb <0.909803921568627, 0.611764705882353, 0.682352941176471>; // HEX #E89CAE
    #declare farge_PC_198_C = rgb <0.874509803921569, 0.274509803921569, 0.380392156862745>; // HEX #DF4661
    #declare farge_PC_199_C = rgb <0.835294117647059, 0, 0.196078431372549>; // HEX #D50032
    #declare farge_PC_200_C = rgb <0.729411764705882, 0.0470588235294118, 0.184313725490196>; // HEX #BA0C2F
    #declare farge_PC_201_C = rgb <0.615686274509804, 0.133333333333333, 0.207843137254902>; // HEX #9D2235
    #declare farge_PC_202_C = rgb <0.525490196078431, 0.149019607843137, 0.2>; // HEX #862633
    #declare farge_PC_203_C = rgb <0.925490196078431, 0.701960784313725, 0.796078431372549>; // HEX #ECB3CB
    #declare farge_PC_204_C = rgb <0.905882352941176, 0.509803921568627, 0.662745098039216>; // HEX #E782A9
    #declare farge_PC_205_C = rgb <0.87843137254902, 0.270588235294118, 0.482352941176471>; // HEX #E0457B
    #declare farge_PC_206_C = rgb <0.807843137254902, 0, 0.215686274509804>; // HEX #CE0037
    #declare farge_PC_207_C = rgb <0.647058823529412, 0, 0.203921568627451>; // HEX #A50034
    #declare farge_PC_208_C = rgb <0.525490196078431, 0.12156862745098, 0.254901960784314>; // HEX #861F41
    #declare farge_PC_209_C = rgb <0.435294117647059, 0.149019607843137, 0.23921568627451>; // HEX #6F263D
    #declare farge_PC_210_C = rgb <0.976470588235294, 0.623529411764706, 0.788235294117647>; // HEX #F99FC9
    #declare farge_PC_211_C = rgb <0.96078431372549, 0.494117647058824, 0.713725490196078>; // HEX #F57EB6
    #declare farge_PC_212_C = rgb <0.941176470588235, 0.305882352941176, 0.596078431372549>; // HEX #F04E98
    #declare farge_PC_213_C = rgb <0.890196078431372, 0.109803921568627, 0.474509803921569>; // HEX #E31C79
    #declare farge_PC_214_C = rgb <0.807843137254902, 0.0588235294117647, 0.411764705882353>; // HEX #CE0F69
    #declare farge_PC_215_C = rgb <0.674509803921569, 0.0784313725490196, 0.352941176470588>; // HEX #AC145A
    #declare farge_PC_216_C = rgb <0.490196078431373, 0.133333333333333, 0.282352941176471>; // HEX #7D2248
    #declare farge_PC_217_C = rgb <0.917647058823529, 0.745098039215686, 0.858823529411765>; // HEX #EABEDB
    #declare farge_PC_218_C = rgb <0.898039215686275, 0.427450980392157, 0.694117647058824>; // HEX #E56DB1
    #declare farge_PC_219_C = rgb <0.854901960784314, 0.0941176470588235, 0.517647058823529>; // HEX #DA1884
    #declare farge_PC_220_C = rgb <0.647058823529412, 0, 0.313725490196078>; // HEX #A50050
    #declare farge_PC_221_C = rgb <0.568627450980392, 0, 0.282352941176471>; // HEX #910048
    #declare farge_PC_222_C = rgb <0.423529411764706, 0.113725490196078, 0.270588235294118>; // HEX #6C1D45
    #declare farge_PC_223_C = rgb <0.937254901960784, 0.584313725490196, 0.811764705882353>; // HEX #EF95CF
    #declare farge_PC_224_C = rgb <0.92156862745098, 0.435294117647059, 0.741176470588235>; // HEX #EB6FBD
    #declare farge_PC_225_C = rgb <0.874509803921569, 0.0980392156862745, 0.584313725490196>; // HEX #DF1995
    #declare farge_PC_226_C = rgb <0.815686274509804, 0, 0.435294117647059>; // HEX #D0006F
    #declare farge_PC_227_C = rgb <0.666666666666667, 0, 0.380392156862745>; // HEX #AA0061
    #declare farge_PC_228_C = rgb <0.537254901960784, 0.0470588235294118, 0.345098039215686>; // HEX #890C58
    #declare farge_PC_229_C = rgb <0.403921568627451, 0.129411764705882, 0.274509803921569>; // HEX #672146
    #declare farge_PC_230_C = rgb <0.956862745098039, 0.650980392156863, 0.843137254901961>; // HEX #F4A6D7
    #declare farge_PC_231_C = rgb <0.949019607843137, 0.466666666666667, 0.776470588235294>; // HEX #F277C6
    #declare farge_PC_232_C = rgb <0.913725490196078, 0.235294117647059, 0.674509803921569>; // HEX #E93CAC
    #declare farge_PC_233_C = rgb <0.776470588235294, 0, 0.494117647058824>; // HEX #C6007E
    #declare farge_PC_234_C = rgb <0.635294117647059, 0, 0.403921568627451>; // HEX #A20067
    #declare farge_PC_235_C = rgb <0.517647058823529, 0.0431372549019608, 0.333333333333333>; // HEX #840B55
    #declare farge_PC_236_C = rgb <0.945098039215686, 0.654901960784314, 0.862745098039216>; // HEX #F1A7DC
    #declare farge_PC_2365_C = rgb <0.937254901960784, 0.729411764705882, 0.882352941176471>; // HEX #EFBAE1
    #declare farge_PC_237_C = rgb <0.925490196078431, 0.525490196078431, 0.815686274509804>; // HEX #EC86D0
    #declare farge_PC_2375_C = rgb <0.886274509803922, 0.466666666666667, 0.803921568627451>; // HEX #E277CD
    #declare farge_PC_238_C = rgb <0.894117647058824, 0.364705882352941, 0.749019607843137>; // HEX #E45DBF
    #declare farge_PC_2385_C = rgb <0.835294117647059, 0.223529411764706, 0.709803921568627>; // HEX #D539B5
    #declare farge_PC_239_C = rgb <0.858823529411765, 0.243137254901961, 0.694117647058824>; // HEX #DB3EB1
    #declare farge_PC_2395_C = rgb <0.784313725490196, 0, 0.631372549019608>; // HEX #C800A1
    #declare farge_PC_240_C = rgb <0.772549019607843, 0.16078431372549, 0.607843137254902>; // HEX #C5299B
    #declare farge_PC_2405_C = rgb <0.690196078431373, 0, 0.556862745098039>; // HEX #B0008E
    #declare farge_PC_241_C = rgb <0.686274509803922, 0.0862745098039216, 0.52156862745098>; // HEX #AF1685
    #declare farge_PC_2415_C = rgb <0.619607843137255, 0, 0.494117647058824>; // HEX #9E007E
    #declare farge_PC_242_C = rgb <0.501960784313725, 0.133333333333333, 0.372549019607843>; // HEX #80225F
    #declare farge_PC_2425_C = rgb <0.513725490196078, 0, 0.396078431372549>; // HEX #830065
    #declare farge_PC_243_C = rgb <0.917647058823529, 0.72156862745098, 0.894117647058824>; // HEX #EAB8E4
    #declare farge_PC_244_C = rgb <0.898039215686275, 0.607843137254902, 0.862745098039216>; // HEX #E59BDC
    #declare farge_PC_245_C = rgb <0.866666666666667, 0.498039215686275, 0.827450980392157>; // HEX #DD7FD3
    #declare farge_PC_246_C = rgb <0.780392156862745, 0.141176470588235, 0.694117647058824>; // HEX #C724B1
    #declare farge_PC_247_C = rgb <0.733333333333333, 0.0862745098039216, 0.63921568627451>; // HEX #BB16A3
    #declare farge_PC_248_C = rgb <0.647058823529412, 0.0941176470588235, 0.564705882352941>; // HEX #A51890
    #declare farge_PC_249_C = rgb <0.501960784313725, 0.152941176470588, 0.423529411764706>; // HEX #80276C
    #declare farge_PC_250_C = rgb <0.905882352941176, 0.729411764705882, 0.894117647058824>; // HEX #E7BAE4
    #declare farge_PC_251_C = rgb <0.866666666666667, 0.611764705882353, 0.874509803921569>; // HEX #DD9CDF
    #declare farge_PC_252_C = rgb <0.788235294117647, 0.392156862745098, 0.811764705882353>; // HEX #C964CF
    #declare farge_PC_253_C = rgb <0.67843137254902, 0.101960784313725, 0.674509803921569>; // HEX #AD1AAC
    #declare farge_PC_254_C = rgb <0.596078431372549, 0.113725490196078, 0.592156862745098>; // HEX #981D97
    #declare farge_PC_255_C = rgb <0.447058823529412, 0.141176470588235, 0.423529411764706>; // HEX #72246C
    #declare farge_PC_256_C = rgb <0.83921568627451, 0.749019607843137, 0.866666666666667>; // HEX #D6BFDD
    #declare farge_PC_2562_C = rgb <0.843137254901961, 0.662745098039216, 0.890196078431372>; // HEX #D7A9E3
    #declare farge_PC_2563_C = rgb <0.796078431372549, 0.63921568627451, 0.847058823529412>; // HEX #CBA3D8
    #declare farge_PC_2567_C = rgb <0.756862745098039, 0.627450980392157, 0.854901960784314>; // HEX #C1A0DA
    #declare farge_PC_257_C = rgb <0.776470588235294, 0.631372549019608, 0.811764705882353>; // HEX #C6A1CF
    #declare farge_PC_2572_C = rgb <0.788235294117647, 0.545098039215686, 0.858823529411765>; // HEX #C98BDB
    #declare farge_PC_2573_C = rgb <0.72156862745098, 0.517647058823529, 0.796078431372549>; // HEX #B884CB
    #declare farge_PC_2577_C = rgb <0.654901960784314, 0.482352941176471, 0.792156862745098>; // HEX #A77BCA
    #declare farge_PC_258_C = rgb <0.549019607843137, 0.27843137254902, 0.6>; // HEX #8C4799
    #declare farge_PC_2582_C = rgb <0.674509803921569, 0.309803921568627, 0.776470588235294>; // HEX #AC4FC6
    #declare farge_PC_2583_C = rgb <0.627450980392157, 0.368627450980392, 0.709803921568627>; // HEX #A05EB5
    #declare farge_PC_2587_C = rgb <0.509803921568627, 0.274509803921569, 0.686274509803922>; // HEX #8246AF
    #declare farge_PC_259_C = rgb <0.427450980392157, 0.125490196078431, 0.466666666666667>; // HEX #6D2077
    #declare farge_PC_2592_C = rgb <0.607843137254902, 0.149019607843137, 0.713725490196078>; // HEX #9B26B6
    #declare farge_PC_2593_C = rgb <0.517647058823529, 0.196078431372549, 0.607843137254902>; // HEX #84329B
    #declare farge_PC_2597_C = rgb <0.36078431372549, 0.0235294117647059, 0.549019607843137>; // HEX #5C068C
    #declare farge_PC_260_C = rgb <0.392156862745098, 0.149019607843137, 0.403921568627451>; // HEX #642667
    #declare farge_PC_2602_C = rgb <0.529411764705882, 0.0941176470588235, 0.615686274509804>; // HEX #87189D
    #declare farge_PC_2603_C = rgb <0.43921568627451, 0.125490196078431, 0.509803921568627>; // HEX #702082
    #declare farge_PC_2607_C = rgb <0.313725490196078, 0.0274509803921569, 0.470588235294118>; // HEX #500778
    #declare farge_PC_261_C = rgb <0.364705882352941, 0.156862745098039, 0.372549019607843>; // HEX #5D285F
    #declare farge_PC_2612_C = rgb <0.466666666666667, 0.145098039215686, 0.513725490196078>; // HEX #772583
    #declare farge_PC_2613_C = rgb <0.403921568627451, 0.117647058823529, 0.458823529411765>; // HEX #671E75
    #declare farge_PC_2617_C = rgb <0.27843137254902, 0.0392156862745098, 0.407843137254902>; // HEX #470A68
    #declare farge_PC_262_C = rgb <0.317647058823529, 0.156862745098039, 0.309803921568627>; // HEX #51284F
    #declare farge_PC_2622_C = rgb <0.396078431372549, 0.192156862745098, 0.396078431372549>; // HEX #653165
    #declare farge_PC_2623_C = rgb <0.372549019607843, 0.129411764705882, 0.403921568627451>; // HEX #5F2167
    #declare farge_PC_2627_C = rgb <0.235294117647059, 0.0627450980392157, 0.325490196078431>; // HEX #3C1053
    #declare farge_PC_263_C = rgb <0.843137254901961, 0.776470588235294, 0.901960784313726>; // HEX #D7C6E6
    #declare farge_PC_2635_C = rgb <0.772549019607843, 0.705882352941177, 0.890196078431372>; // HEX #C5B4E3
    #declare farge_PC_264_C = rgb <0.756862745098039, 0.654901960784314, 0.886274509803922>; // HEX #C1A7E2
    #declare farge_PC_2645_C = rgb <0.67843137254902, 0.588235294117647, 0.862745098039216>; // HEX #AD96DC
    #declare farge_PC_265_C = rgb <0.564705882352941, 0.388235294117647, 0.803921568627451>; // HEX #9063CD
    #declare farge_PC_2655_C = rgb <0.588235294117647, 0.470588235294118, 0.827450980392157>; // HEX #9678D3
    #declare farge_PC_266_C = rgb <0.458823529411765, 0.231372549019608, 0.741176470588235>; // HEX #753BBD
    #declare farge_PC_2665_C = rgb <0.490196078431373, 0.333333333333333, 0.780392156862745>; // HEX #7D55C7
    #declare farge_PC_267_C = rgb <0.372549019607843, 0.145098039215686, 0.623529411764706>; // HEX #5F259F
    #declare farge_PC_268_C = rgb <0.345098039215686, 0.172549019607843, 0.513725490196078>; // HEX #582C83
    #declare farge_PC_2685_C = rgb <0.2, 0, 0.447058823529412>; // HEX #330072
    #declare farge_PC_269_C = rgb <0.317647058823529, 0.176470588235294, 0.427450980392157>; // HEX #512D6D
    #declare farge_PC_2695_C = rgb <0.180392156862745, 0.101960784313725, 0.27843137254902>; // HEX #2E1A47
    #declare farge_PC_270_C = rgb <0.705882352941177, 0.709803921568627, 0.874509803921569>; // HEX #B4B5DF
    #declare farge_PC_2705_C = rgb <0.654901960784314, 0.643137254901961, 0.87843137254902>; // HEX #A7A4E0
    #declare farge_PC_2706_C = rgb <0.796078431372549, 0.827450980392157, 0.92156862745098>; // HEX #CBD3EB
    #declare farge_PC_2707_C = rgb <0.764705882352941, 0.843137254901961, 0.933333333333333>; // HEX #C3D7EE
    #declare farge_PC_2708_C = rgb <0.72156862745098, 0.8, 0.917647058823529>; // HEX #B8CCEA
    #declare farge_PC_271_C = rgb <0.584313725490196, 0.584313725490196, 0.823529411764706>; // HEX #9595D2
    #declare farge_PC_2715_C = rgb <0.545098039215686, 0.517647058823529, 0.843137254901961>; // HEX #8B84D7
    #declare farge_PC_2716_C = rgb <0.623529411764706, 0.682352941176471, 0.898039215686275>; // HEX #9FAEE5
    #declare farge_PC_2717_C = rgb <0.654901960784314, 0.776470588235294, 0.929411764705882>; // HEX #A7C6ED
    #declare farge_PC_2718_C = rgb <0.36078431372549, 0.533333333333333, 0.854901960784314>; // HEX #5C88DA
    #declare farge_PC_272_C = rgb <0.454901960784314, 0.454901960784314, 0.756862745098039>; // HEX #7474C1
    #declare farge_PC_2725_C = rgb <0.407843137254902, 0.356862745098039, 0.780392156862745>; // HEX #685BC7
    #declare farge_PC_2726_C = rgb <0.282352941176471, 0.36078431372549, 0.780392156862745>; // HEX #485CC7
    #declare farge_PC_2727_C = rgb <0.188235294117647, 0.498039215686275, 0.886274509803922>; // HEX #307FE2
    #declare farge_PC_2728_C = rgb <0, 0.27843137254902, 0.733333333333333>; // HEX #0047BB
    #declare farge_PC_273_C = rgb <0.141176470588235, 0.0745098039215686, 0.372549019607843>; // HEX #24135F
    #declare farge_PC_2735_C = rgb <0.180392156862745, 0, 0.545098039215686>; // HEX #2E008B
    #declare farge_PC_2736_C = rgb <0.117647058823529, 0.133333333333333, 0.666666666666667>; // HEX #1E22AA
    #declare farge_PC_2738_C = rgb <0.0235294117647059, 0.0117647058823529, 0.552941176470588>; // HEX #06038D
    #declare farge_PC_274_C = rgb <0.129411764705882, 0.0823529411764706, 0.317647058823529>; // HEX #211551
    #declare farge_PC_2745_C = rgb <0.156862745098039, 0, 0.443137254901961>; // HEX #280071
    #declare farge_PC_2746_C = rgb <0.0901960784313725, 0.109803921568627, 0.56078431372549>; // HEX #171C8F
    #declare farge_PC_2747_C = rgb <0, 0.101960784313725, 0.447058823529412>; // HEX #001A72
    #declare farge_PC_2748_C = rgb <0, 0.0941176470588235, 0.443137254901961>; // HEX #001871
    #declare farge_PC_275_C = rgb <0.125490196078431, 0.0901960784313725, 0.27843137254902>; // HEX #201747
    #declare farge_PC_2755_C = rgb <0.145098039215686, 0.0549019607843137, 0.384313725490196>; // HEX #250E62
    #declare farge_PC_2756_C = rgb <0.0823529411764706, 0.12156862745098, 0.427450980392157>; // HEX #151F6D
    #declare farge_PC_2757_C = rgb <0, 0.117647058823529, 0.376470588235294>; // HEX #001E60
    #declare farge_PC_2758_C = rgb <0, 0.117647058823529, 0.384313725490196>; // HEX #001E62
    #declare farge_PC_276_C = rgb <0.133333333333333, 0.109803921568627, 0.207843137254902>; // HEX #221C35
    #declare farge_PC_2765_C = rgb <0.125490196078431, 0.0823529411764706, 0.27843137254902>; // HEX #201547
    #declare farge_PC_2766_C = rgb <0.0784313725490196, 0.105882352941176, 0.301960784313725>; // HEX #141B4D
    #declare farge_PC_2767_C = rgb <0.0745098039215686, 0.16078431372549, 0.294117647058824>; // HEX #13294B
    #declare farge_PC_2768_C = rgb <0.0274509803921569, 0.113725490196078, 0.286274509803922>; // HEX #071D49
    #declare farge_PC_277_C = rgb <0.670588235294118, 0.792156862745098, 0.913725490196078>; // HEX #ABCAE9
    #declare farge_PC_278_C = rgb <0.545098039215686, 0.72156862745098, 0.909803921568627>; // HEX #8BB8E8
    #declare farge_PC_279_C = rgb <0.254901960784314, 0.56078431372549, 0.870588235294118>; // HEX #418FDE
    #declare farge_PC_280_C = rgb <0.00392156862745098, 0.129411764705882, 0.411764705882353>; // HEX #012169
    #declare farge_PC_281_C = rgb <0, 0.125490196078431, 0.356862745098039>; // HEX #00205B
    #declare farge_PC_282_C = rgb <0.0156862745098039, 0.117647058823529, 0.258823529411765>; // HEX #041E42
    #declare farge_PC_283_C = rgb <0.572549019607843, 0.756862745098039, 0.913725490196078>; // HEX #92C1E9
    #declare farge_PC_284_C = rgb <0.423529411764706, 0.674509803921569, 0.894117647058824>; // HEX #6CACE4
    #declare farge_PC_285_C = rgb <0, 0.447058823529412, 0.807843137254902>; // HEX #0072CE
    #declare farge_PC_286_C = rgb <0, 0.2, 0.627450980392157>; // HEX #0033A0
    #declare farge_PC_287_C = rgb <0, 0.188235294117647, 0.529411764705882>; // HEX #003087
    #declare farge_PC_288_C = rgb <0, 0.176470588235294, 0.447058823529412>; // HEX #002D72
    #declare farge_PC_289_C = rgb <0.0470588235294118, 0.137254901960784, 0.250980392156863>; // HEX #0C2340
    #declare farge_PC_290_C = rgb <0.725490196078431, 0.850980392156863, 0.92156862745098>; // HEX #B9D9EB
    #declare farge_PC_2905_C = rgb <0.552941176470588, 0.784313725490196, 0.909803921568627>; // HEX #8DC8E8
    #declare farge_PC_291_C = rgb <0.607843137254902, 0.796078431372549, 0.92156862745098>; // HEX #9BCBEB
    #declare farge_PC_2915_C = rgb <0.384313725490196, 0.709803921568627, 0.898039215686275>; // HEX #62B5E5
    #declare farge_PC_292_C = rgb <0.411764705882353, 0.701960784313725, 0.905882352941176>; // HEX #69B3E7
    #declare farge_PC_2925_C = rgb <0, 0.611764705882353, 0.870588235294118>; // HEX #009CDE
    #declare farge_PC_293_C = rgb <0, 0.23921568627451, 0.647058823529412>; // HEX #003DA5
    #declare farge_PC_2935_C = rgb <0, 0.341176470588235, 0.72156862745098>; // HEX #0057B8
    #declare farge_PC_294_C = rgb <0, 0.184313725490196, 0.423529411764706>; // HEX #002F6C
    #declare farge_PC_2945_C = rgb <0, 0.298039215686275, 0.592156862745098>; // HEX #004C97
    #declare farge_PC_295_C = rgb <0, 0.156862745098039, 0.333333333333333>; // HEX #002855
    #declare farge_PC_2955_C = rgb <0, 0.219607843137255, 0.396078431372549>; // HEX #003865
    #declare farge_PC_296_C = rgb <0.0156862745098039, 0.109803921568627, 0.172549019607843>; // HEX #041C2C
    #declare farge_PC_2965_C = rgb <0, 0.149019607843137, 0.243137254901961>; // HEX #00263E
    #declare farge_PC_297_C = rgb <0.443137254901961, 0.772549019607843, 0.909803921568627>; // HEX #71C5E8
    #declare farge_PC_2975_C = rgb <0.6, 0.83921568627451, 0.917647058823529>; // HEX #99D6EA
    #declare farge_PC_298_C = rgb <0.254901960784314, 0.713725490196078, 0.901960784313726>; // HEX #41B6E6
    #declare farge_PC_2985_C = rgb <0.356862745098039, 0.76078431372549, 0.905882352941176>; // HEX #5BC2E7
    #declare farge_PC_299_C = rgb <0, 0.63921568627451, 0.87843137254902>; // HEX #00A3E0
    #declare farge_PC_2995_C = rgb <0, 0.662745098039216, 0.87843137254902>; // HEX #00A9E0
    #declare farge_PC_300_C = rgb <0, 0.368627450980392, 0.72156862745098>; // HEX #005EB8
    #declare farge_PC_3005_C = rgb <0, 0.466666666666667, 0.784313725490196>; // HEX #0077C8
    #declare farge_PC_301_C = rgb <0, 0.294117647058824, 0.529411764705882>; // HEX #004B87
    #declare farge_PC_3015_C = rgb <0, 0.384313725490196, 0.607843137254902>; // HEX #00629B
    #declare farge_PC_302_C = rgb <0, 0.231372549019608, 0.36078431372549>; // HEX #003B5C
    #declare farge_PC_3025_C = rgb <0, 0.309803921568627, 0.443137254901961>; // HEX #004F71
    #declare farge_PC_303_C = rgb <0, 0.164705882352941, 0.227450980392157>; // HEX #002A3A
    #declare farge_PC_3035_C = rgb <0, 0.243137254901961, 0.317647058823529>; // HEX #003E51
    #declare farge_PC_304_C = rgb <0.603921568627451, 0.858823529411765, 0.909803921568627>; // HEX #9ADBE8
    #declare farge_PC_305_C = rgb <0.349019607843137, 0.796078431372549, 0.909803921568627>; // HEX #59CBE8
    #declare farge_PC_306_C = rgb <0, 0.709803921568627, 0.886274509803922>; // HEX #00B5E2
    #declare farge_PC_307_C = rgb <0, 0.419607843137255, 0.650980392156863>; // HEX #006BA6
    #declare farge_PC_308_C = rgb <0, 0.345098039215686, 0.486274509803922>; // HEX #00587C
    #declare farge_PC_309_C = rgb <0, 0.231372549019608, 0.286274509803922>; // HEX #003B49
    #declare farge_PC_310_C = rgb <0.415686274509804, 0.819607843137255, 0.890196078431372>; // HEX #6AD1E3
    #declare farge_PC_3105_C = rgb <0.407843137254902, 0.823529411764706, 0.874509803921569>; // HEX #68D2DF
    #declare farge_PC_311_C = rgb <0.0196078431372549, 0.764705882352941, 0.870588235294118>; // HEX #05C3DE
    #declare farge_PC_3115_C = rgb <0, 0.756862745098039, 0.835294117647059>; // HEX #00C1D5
    #declare farge_PC_312_C = rgb <0, 0.662745098039216, 0.807843137254902>; // HEX #00A9CE
    #declare farge_PC_3125_C = rgb <0, 0.682352941176471, 0.780392156862745>; // HEX #00AEC7
    #declare farge_PC_313_C = rgb <0, 0.572549019607843, 0.737254901960784>; // HEX #0092BC
    #declare farge_PC_3135_C = rgb <0, 0.556862745098039, 0.666666666666667>; // HEX #008EAA
    #declare farge_PC_314_C = rgb <0, 0.498039215686275, 0.63921568627451>; // HEX #007FA3
    #declare farge_PC_3145_C = rgb <0, 0.466666666666667, 0.545098039215686>; // HEX #00778B
    #declare farge_PC_315_C = rgb <0, 0.403921568627451, 0.498039215686275>; // HEX #00677F
    #declare farge_PC_3155_C = rgb <0, 0.384313725490196, 0.447058823529412>; // HEX #006272
    #declare farge_PC_316_C = rgb <0, 0.282352941176471, 0.317647058823529>; // HEX #004851
    #declare farge_PC_3165_C = rgb <0, 0.309803921568627, 0.349019607843137>; // HEX #004F59
    #declare farge_PC_317_C = rgb <0.694117647058824, 0.894117647058824, 0.890196078431372>; // HEX #B1E4E3
    #declare farge_PC_318_C = rgb <0.533333333333333, 0.858823529411765, 0.874509803921569>; // HEX #88DBDF
    #declare farge_PC_319_C = rgb <0.176470588235294, 0.8, 0.827450980392157>; // HEX #2DCCD3
    #declare farge_PC_320_C = rgb <0, 0.611764705882353, 0.650980392156863>; // HEX #009CA6
    #declare farge_PC_321_C = rgb <0, 0.549019607843137, 0.584313725490196>; // HEX #008C95
    #declare farge_PC_322_C = rgb <0, 0.450980392156863, 0.466666666666667>; // HEX #007377
    #declare farge_PC_323_C = rgb <0, 0.372549019607843, 0.380392156862745>; // HEX #005F61
    #declare farge_PC_324_C = rgb <0.611764705882353, 0.858823529411765, 0.850980392156863>; // HEX #9CDBD9
    #declare farge_PC_3242_C = rgb <0.443137254901961, 0.858823529411765, 0.831372549019608>; // HEX #71DBD4
    #declare farge_PC_3245_C = rgb <0.486274509803922, 0.87843137254902, 0.827450980392157>; // HEX #7CE0D3
    #declare farge_PC_3248_C = rgb <0.427450980392157, 0.803921568627451, 0.72156862745098>; // HEX #6DCDB8
    #declare farge_PC_325_C = rgb <0.392156862745098, 0.8, 0.788235294117647>; // HEX #64CCC9
    #declare farge_PC_3252_C = rgb <0.164705882352941, 0.823529411764706, 0.788235294117647>; // HEX #2AD2C9
    #declare farge_PC_3255_C = rgb <0.172549019607843, 0.835294117647059, 0.768627450980392>; // HEX #2CD5C4
    #declare farge_PC_3258_C = rgb <0.286274509803922, 0.772549019607843, 0.694117647058824>; // HEX #49C5B1
    #declare farge_PC_326_C = rgb <0, 0.698039215686274, 0.662745098039216>; // HEX #00B2A9
    #declare farge_PC_3262_C = rgb <0, 0.749019607843137, 0.701960784313725>; // HEX #00BFB3
    #declare farge_PC_3265_C = rgb <0, 0.780392156862745, 0.694117647058824>; // HEX #00C7B1
    #declare farge_PC_3268_C = rgb <0, 0.670588235294118, 0.556862745098039>; // HEX #00AB8E
    #declare farge_PC_327_C = rgb <0, 0.525490196078431, 0.458823529411765>; // HEX #008675
    #declare farge_PC_3272_C = rgb <0, 0.643137254901961, 0.6>; // HEX #00A499
    #declare farge_PC_3275_C = rgb <0, 0.701960784313725, 0.596078431372549>; // HEX #00B398
    #declare farge_PC_3278_C = rgb <0, 0.607843137254902, 0.466666666666667>; // HEX #009B77
    #declare farge_PC_328_C = rgb <0, 0.450980392156863, 0.403921568627451>; // HEX #007367
    #declare farge_PC_3282_C = rgb <0, 0.52156862745098, 0.470588235294118>; // HEX #008578
    #declare farge_PC_3285_C = rgb <0, 0.588235294117647, 0.505882352941176>; // HEX #009681
    #declare farge_PC_3288_C = rgb <0, 0.509803921568627, 0.392156862745098>; // HEX #008264
    #declare farge_PC_329_C = rgb <0, 0.407843137254902, 0.368627450980392>; // HEX #00685E
    #declare farge_PC_3292_C = rgb <0, 0.349019607843137, 0.309803921568627>; // HEX #00594F
    #declare farge_PC_3295_C = rgb <0, 0.470588235294118, 0.392156862745098>; // HEX #007864
    #declare farge_PC_3298_C = rgb <0, 0.415686274509804, 0.32156862745098>; // HEX #006A52
    #declare farge_PC_330_C = rgb <0, 0.325490196078431, 0.298039215686275>; // HEX #00534C
    #declare farge_PC_3302_C = rgb <0, 0.298039215686275, 0.270588235294118>; // HEX #004C45
    #declare farge_PC_3305_C = rgb <0, 0.305882352941176, 0.258823529411765>; // HEX #004E42
    #declare farge_PC_3308_C = rgb <0.0117647058823529, 0.274509803921569, 0.219607843137255>; // HEX #034638
    #declare farge_PC_331_C = rgb <0.654901960784314, 0.901960784313726, 0.843137254901961>; // HEX #A7E6D7
    #declare farge_PC_332_C = rgb <0.549019607843137, 0.886274509803922, 0.815686274509804>; // HEX #8CE2D0
    #declare farge_PC_333_C = rgb <0.235294117647059, 0.858823529411765, 0.752941176470588>; // HEX #3CDBC0
    #declare farge_PC_334_C = rgb <0, 0.592156862745098, 0.458823529411765>; // HEX #009775
    #declare farge_PC_335_C = rgb <0, 0.482352941176471, 0.372549019607843>; // HEX #007B5F
    #declare farge_PC_336_C = rgb <0, 0.4, 0.309803921568627>; // HEX #00664F
    #declare farge_PC_337_C = rgb <0.56078431372549, 0.83921568627451, 0.741176470588235>; // HEX #8FD6BD
    #declare farge_PC_3375_C = rgb <0.47843137254902, 0.882352941176471, 0.749019607843137>; // HEX #7AE1BF
    #declare farge_PC_338_C = rgb <0.431372549019608, 0.807843137254902, 0.698039215686274>; // HEX #6ECEB2
    #declare farge_PC_3385_C = rgb <0.27843137254902, 0.843137254901961, 0.674509803921569>; // HEX #47D7AC
    #declare farge_PC_339_C = rgb <0, 0.701960784313725, 0.533333333333333>; // HEX #00B388
    #declare farge_PC_3395_C = rgb <0, 0.764705882352941, 0.537254901960784>; // HEX #00C389
    #declare farge_PC_340_C = rgb <0, 0.588235294117647, 0.368627450980392>; // HEX #00965E
    #declare farge_PC_3405_C = rgb <0, 0.686274509803922, 0.4>; // HEX #00AF66
    #declare farge_PC_341_C = rgb <0, 0.47843137254902, 0.325490196078431>; // HEX #007A53
    #declare farge_PC_3415_C = rgb <0, 0.466666666666667, 0.286274509803922>; // HEX #007749
    #declare farge_PC_342_C = rgb <0, 0.403921568627451, 0.27843137254902>; // HEX #006747
    #declare farge_PC_3425_C = rgb <0, 0.388235294117647, 0.254901960784314>; // HEX #006341
    #declare farge_PC_343_C = rgb <0.0666666666666667, 0.341176470588235, 0.250980392156863>; // HEX #115740
    #declare farge_PC_3435_C = rgb <0.0823529411764706, 0.27843137254902, 0.203921568627451>; // HEX #154734
    #declare farge_PC_344_C = rgb <0.627450980392157, 0.854901960784314, 0.701960784313725>; // HEX #A0DAB3
    #declare farge_PC_345_C = rgb <0.568627450980392, 0.83921568627451, 0.674509803921569>; // HEX #91D6AC
    #declare farge_PC_346_C = rgb <0.443137254901961, 0.8, 0.596078431372549>; // HEX #71CC98
    #declare farge_PC_347_C = rgb <0, 0.603921568627451, 0.266666666666667>; // HEX #009A44
    #declare farge_PC_348_C = rgb <0, 0.517647058823529, 0.23921568627451>; // HEX #00843D
    #declare farge_PC_349_C = rgb <0.0156862745098039, 0.415686274509804, 0.219607843137255>; // HEX #046A38
    #declare farge_PC_350_C = rgb <0.172549019607843, 0.32156862745098, 0.203921568627451>; // HEX #2C5234
    #declare farge_PC_351_C = rgb <0.635294117647059, 0.894117647058824, 0.72156862745098>; // HEX #A2E4B8
    #declare farge_PC_352_C = rgb <0.56078431372549, 0.886274509803922, 0.690196078431373>; // HEX #8FE2B0
    #declare farge_PC_353_C = rgb <0.501960784313725, 0.87843137254902, 0.654901960784314>; // HEX #80E0A7
    #declare farge_PC_354_C = rgb <0, 0.694117647058824, 0.250980392156863>; // HEX #00B140
    #declare farge_PC_355_C = rgb <0, 0.588235294117647, 0.223529411764706>; // HEX #009639
    #declare farge_PC_356_C = rgb <0, 0.47843137254902, 0.2>; // HEX #007A33
    #declare farge_PC_357_C = rgb <0.129411764705882, 0.341176470588235, 0.196078431372549>; // HEX #215732
    #declare farge_PC_358_C = rgb <0.67843137254902, 0.862745098039216, 0.568627450980392>; // HEX #ADDC91
    #declare farge_PC_359_C = rgb <0.631372549019608, 0.847058823529412, 0.517647058823529>; // HEX #A1D884
    #declare farge_PC_360_C = rgb <0.423529411764706, 0.76078431372549, 0.290196078431373>; // HEX #6CC24A
    #declare farge_PC_361_C = rgb <0.262745098039216, 0.690196078431373, 0.164705882352941>; // HEX #43B02A
    #declare farge_PC_362_C = rgb <0.313725490196078, 0.619607843137255, 0.184313725490196>; // HEX #509E2F
    #declare farge_PC_363_C = rgb <0.298039215686275, 0.549019607843137, 0.168627450980392>; // HEX #4C8C2B
    #declare farge_PC_364_C = rgb <0.290196078431373, 0.466666666666667, 0.16078431372549>; // HEX #4A7729
    #declare farge_PC_365_C = rgb <0.76078431372549, 0.882352941176471, 0.537254901960784>; // HEX #C2E189
    #declare farge_PC_366_C = rgb <0.717647058823529, 0.866666666666667, 0.474509803921569>; // HEX #B7DD79
    #declare farge_PC_367_C = rgb <0.643137254901961, 0.83921568627451, 0.368627450980392>; // HEX #A4D65E
    #declare farge_PC_368_C = rgb <0.470588235294118, 0.745098039215686, 0.125490196078431>; // HEX #78BE20
    #declare farge_PC_369_C = rgb <0.392156862745098, 0.654901960784314, 0.0431372549019608>; // HEX #64A70B
    #declare farge_PC_370_C = rgb <0.396078431372549, 0.552941176470588, 0.105882352941176>; // HEX #658D1B
    #declare farge_PC_371_C = rgb <0.329411764705882, 0.384313725490196, 0.137254901960784>; // HEX #546223
    #declare farge_PC_372_C = rgb <0.831372549019608, 0.92156862745098, 0.556862745098039>; // HEX #D4EB8E
    #declare farge_PC_373_C = rgb <0.803921568627451, 0.917647058823529, 0.501960784313725>; // HEX #CDEA80
    #declare farge_PC_374_C = rgb <0.772549019607843, 0.909803921568627, 0.423529411764706>; // HEX #C5E86C
    #declare farge_PC_375_C = rgb <0.592156862745098, 0.843137254901961, 0>; // HEX #97D700
    #declare farge_PC_376_C = rgb <0.517647058823529, 0.741176470588235, 0>; // HEX #84BD00
    #declare farge_PC_377_C = rgb <0.47843137254902, 0.603921568627451, 0.00392156862745098>; // HEX #7A9A01
    #declare farge_PC_378_C = rgb <0.349019607843137, 0.384313725490196, 0.113725490196078>; // HEX #59621D
    #declare farge_PC_379_C = rgb <0.886274509803922, 0.909803921568627, 0.407843137254902>; // HEX #E2E868
    #declare farge_PC_380_C = rgb <0.858823529411765, 0.894117647058824, 0.258823529411765>; // HEX #DBE442
    #declare farge_PC_381_C = rgb <0.807843137254902, 0.862745098039216, 0>; // HEX #CEDC00
    #declare farge_PC_382_C = rgb <0.768627450980392, 0.83921568627451, 0>; // HEX #C4D600
    #declare farge_PC_383_C = rgb <0.658823529411765, 0.67843137254902, 0>; // HEX #A8AD00
    #declare farge_PC_384_C = rgb <0.580392156862745, 0.576470588235294, 0>; // HEX #949300
    #declare farge_PC_385_C = rgb <0.470588235294118, 0.443137254901961, 0.129411764705882>; // HEX #787121
    #declare farge_PC_386_C = rgb <0.913725490196078, 0.925490196078431, 0.419607843137255>; // HEX #E9EC6B
    #declare farge_PC_387_C = rgb <0.890196078431372, 0.913725490196078, 0.207843137254902>; // HEX #E3E935
    #declare farge_PC_388_C = rgb <0.87843137254902, 0.905882352941176, 0.129411764705882>; // HEX #E0E721
    #declare farge_PC_389_C = rgb <0.815686274509804, 0.874509803921569, 0>; // HEX #D0DF00
    #declare farge_PC_390_C = rgb <0.709803921568627, 0.741176470588235, 0>; // HEX #B5BD00
    #declare farge_PC_391_C = rgb <0.603921568627451, 0.584313725490196, 0>; // HEX #9A9500
    #declare farge_PC_392_C = rgb <0.509803921568627, 0.47843137254902, 0.0156862745098039>; // HEX #827A04
    #declare farge_PC_393_C = rgb <0.941176470588235, 0.925490196078431, 0.454901960784314>; // HEX #F0EC74
    #declare farge_PC_3935_C = rgb <0.952941176470588, 0.917647058823529, 0.364705882352941>; // HEX #F3EA5D
    #declare farge_PC_394_C = rgb <0.929411764705882, 0.913725490196078, 0.223529411764706>; // HEX #EDE939
    #declare farge_PC_3945_C = rgb <0.952941176470588, 0.898039215686275, 0>; // HEX #F3E500
    #declare farge_PC_395_C = rgb <0.925490196078431, 0.909803921568627, 0.101960784313725>; // HEX #ECE81A
    #declare farge_PC_3955_C = rgb <0.937254901960784, 0.874509803921569, 0>; // HEX #EFDF00
    #declare farge_PC_396_C = rgb <0.882352941176471, 0.87843137254902, 0>; // HEX #E1E000
    #declare farge_PC_3965_C = rgb <0.933333333333333, 0.862745098039216, 0>; // HEX #EEDC00
    #declare farge_PC_397_C = rgb <0.749019607843137, 0.72156862745098, 0>; // HEX #BFB800
    #declare farge_PC_3975_C = rgb <0.733333333333333, 0.650980392156863, 0>; // HEX #BBA600
    #declare farge_PC_398_C = rgb <0.67843137254902, 0.643137254901961, 0>; // HEX #ADA400
    #declare farge_PC_3985_C = rgb <0.603921568627451, 0.529411764705882, 0>; // HEX #9A8700
    #declare farge_PC_399_C = rgb <0.627450980392157, 0.572549019607843, 0>; // HEX #A09200
    #declare farge_PC_3995_C = rgb <0.407843137254902, 0.36078431372549, 0.125490196078431>; // HEX #685C20
    #declare farge_PC_400_C = rgb <0.768627450980392, 0.749019607843137, 0.713725490196078>; // HEX #C4BFB6
    #declare farge_PC_401_C = rgb <0.686274509803922, 0.662745098039216, 0.627450980392157>; // HEX #AFA9A0
    #declare farge_PC_402_C = rgb <0.615686274509804, 0.588235294117647, 0.552941176470588>; // HEX #9D968D
    #declare farge_PC_403_C = rgb <0.549019607843137, 0.52156862745098, 0.482352941176471>; // HEX #8C857B
    #declare farge_PC_404_C = rgb <0.466666666666667, 0.431372549019608, 0.392156862745098>; // HEX #776E64
    #declare farge_PC_405_C = rgb <0.411764705882353, 0.380392156862745, 0.345098039215686>; // HEX #696158
    #declare farge_PC_406_C = rgb <0.768627450980392, 0.737254901960784, 0.717647058823529>; // HEX #C4BCB7
    #declare farge_PC_407_C = rgb <0.698039215686274, 0.658823529411765, 0.635294117647059>; // HEX #B2A8A2
    #declare farge_PC_408_C = rgb <0.592156862745098, 0.549019607843137, 0.529411764705882>; // HEX #978C87
    #declare farge_PC_409_C = rgb <0.52156862745098, 0.470588235294118, 0.454901960784314>; // HEX #857874
    #declare farge_PC_410_C = rgb <0.454901960784314, 0.4, 0.380392156862745>; // HEX #746661
    #declare farge_PC_411_C = rgb <0.368627450980392, 0.317647058823529, 0.301960784313725>; // HEX #5E514D
    #declare farge_PC_412_C = rgb <0.219607843137255, 0.184313725490196, 0.176470588235294>; // HEX #382F2D
    #declare farge_PC_413_C = rgb <0.729411764705882, 0.733333333333333, 0.694117647058824>; // HEX #BABBB1
    #declare farge_PC_414_C = rgb <0.658823529411765, 0.662745098039216, 0.619607843137255>; // HEX #A8A99E
    #declare farge_PC_415_C = rgb <0.568627450980392, 0.576470588235294, 0.533333333333333>; // HEX #919388
    #declare farge_PC_416_C = rgb <0.494117647058824, 0.498039215686275, 0.454901960784314>; // HEX #7E7F74
    #declare farge_PC_417_C = rgb <0.396078431372549, 0.4, 0.36078431372549>; // HEX #65665C
    #declare farge_PC_418_C = rgb <0.317647058823529, 0.325490196078431, 0.290196078431373>; // HEX #51534A
    #declare farge_PC_419_C = rgb <0.129411764705882, 0.137254901960784, 0.133333333333333>; // HEX #212322
    #declare farge_PC_420_C = rgb <0.780392156862745, 0.788235294117647, 0.780392156862745>; // HEX #C7C9C7
    #declare farge_PC_421_C = rgb <0.698039215686274, 0.705882352941177, 0.698039215686274>; // HEX #B2B4B2
    #declare farge_PC_422_C = rgb <0.619607843137255, 0.635294117647059, 0.635294117647059>; // HEX #9EA2A2
    #declare farge_PC_423_C = rgb <0.537254901960784, 0.552941176470588, 0.552941176470588>; // HEX #898D8D
    #declare farge_PC_424_C = rgb <0.43921568627451, 0.450980392156863, 0.447058823529412>; // HEX #707372
    #declare farge_PC_425_C = rgb <0.329411764705882, 0.345098039215686, 0.352941176470588>; // HEX #54585A
    #declare farge_PC_426_C = rgb <0.145098039215686, 0.156862745098039, 0.164705882352941>; // HEX #25282A
    #declare farge_PC_427_C = rgb <0.815686274509804, 0.827450980392157, 0.831372549019608>; // HEX #D0D3D4
    #declare farge_PC_428_C = rgb <0.756862745098039, 0.776470588235294, 0.784313725490196>; // HEX #C1C6C8
    #declare farge_PC_429_C = rgb <0.635294117647059, 0.666666666666667, 0.67843137254902>; // HEX #A2AAAD
    #declare farge_PC_430_C = rgb <0.486274509803922, 0.529411764705882, 0.556862745098039>; // HEX #7C878E
    #declare farge_PC_431_C = rgb <0.356862745098039, 0.403921568627451, 0.43921568627451>; // HEX #5B6770
    #declare farge_PC_432_C = rgb <0.2, 0.247058823529412, 0.282352941176471>; // HEX #333F48
    #declare farge_PC_433_C = rgb <0.113725490196078, 0.145098039215686, 0.176470588235294>; // HEX #1D252D
    #declare farge_PC_434_C = rgb <0.815686274509804, 0.768627450980392, 0.772549019607843>; // HEX #D0C4C5
    #declare farge_PC_435_C = rgb <0.756862745098039, 0.698039215686274, 0.713725490196078>; // HEX #C1B2B6
    #declare farge_PC_436_C = rgb <0.670588235294118, 0.596078431372549, 0.615686274509804>; // HEX #AB989D
    #declare farge_PC_437_C = rgb <0.482352941176471, 0.392156862745098, 0.411764705882353>; // HEX #7B6469
    #declare farge_PC_438_C = rgb <0.345098039215686, 0.266666666666667, 0.274509803921569>; // HEX #584446
    #declare farge_PC_439_C = rgb <0.270588235294118, 0.207843137254902, 0.211764705882353>; // HEX #453536
    #declare farge_PC_440_C = rgb <0.219607843137255, 0.180392156862745, 0.172549019607843>; // HEX #382E2C
    #declare farge_PC_441_C = rgb <0.745098039215686, 0.776470588235294, 0.768627450980392>; // HEX #BEC6C4
    #declare farge_PC_442_C = rgb <0.635294117647059, 0.674509803921569, 0.670588235294118>; // HEX #A2ACAB
    #declare farge_PC_443_C = rgb <0.568627450980392, 0.615686274509804, 0.615686274509804>; // HEX #919D9D
    #declare farge_PC_444_C = rgb <0.443137254901961, 0.486274509803922, 0.490196078431373>; // HEX #717C7D
    #declare farge_PC_445_C = rgb <0.313725490196078, 0.341176470588235, 0.349019607843137>; // HEX #505759
    #declare farge_PC_446_C = rgb <0.247058823529412, 0.266666666666667, 0.266666666666667>; // HEX #3F4444
    #declare farge_PC_447_C = rgb <0.215686274509804, 0.227450980392157, 0.211764705882353>; // HEX #373A36
    #declare farge_PC_448_C = rgb <0.290196078431373, 0.254901960784314, 0.164705882352941>; // HEX #4A412A
    #declare farge_PC_4485_C = rgb <0.380392156862745, 0.309803921568627, 0.145098039215686>; // HEX #614F25
    #declare farge_PC_449_C = rgb <0.32156862745098, 0.27843137254902, 0.152941176470588>; // HEX #524727
    #declare farge_PC_4495_C = rgb <0.549019607843137, 0.466666666666667, 0.196078431372549>; // HEX #8C7732
    #declare farge_PC_450_C = rgb <0.349019607843137, 0.290196078431373, 0.145098039215686>; // HEX #594A25
    #declare farge_PC_4505_C = rgb <0.6, 0.52156862745098, 0.258823529411765>; // HEX #998542
    #declare farge_PC_451_C = rgb <0.607843137254902, 0.580392156862745, 0.372549019607843>; // HEX #9B945F
    #declare farge_PC_4515_C = rgb <0.701960784313725, 0.63921568627451, 0.411764705882353>; // HEX #B3A369
    #declare farge_PC_452_C = rgb <0.690196078431373, 0.666666666666667, 0.494117647058824>; // HEX #B0AA7E
    #declare farge_PC_4525_C = rgb <0.772549019607843, 0.717647058823529, 0.513725490196078>; // HEX #C5B783
    #declare farge_PC_453_C = rgb <0.749019607843137, 0.733333333333333, 0.596078431372549>; // HEX #BFBB98
    #declare farge_PC_4535_C = rgb <0.811764705882353, 0.768627450980392, 0.576470588235294>; // HEX #CFC493
    #declare farge_PC_454_C = rgb <0.792156862745098, 0.780392156862745, 0.654901960784314>; // HEX #CAC7A7
    #declare farge_PC_4545_C = rgb <0.835294117647059, 0.796078431372549, 0.623529411764706>; // HEX #D5CB9F
    #declare farge_PC_455_C = rgb <0.411764705882353, 0.356862745098039, 0.141176470588235>; // HEX #695B24
    #declare farge_PC_456_C = rgb <0.635294117647059, 0.556862745098039, 0.164705882352941>; // HEX #A28E2A
    #declare farge_PC_457_C = rgb <0.72156862745098, 0.615686274509804, 0.0941176470588235>; // HEX #B89D18
    #declare farge_PC_458_C = rgb <0.850980392156863, 0.780392156862745, 0.337254901960784>; // HEX #D9C756
    #declare farge_PC_459_C = rgb <0.870588235294118, 0.803921568627451, 0.388235294117647>; // HEX #DECD63
    #declare farge_PC_460_C = rgb <0.894117647058824, 0.843137254901961, 0.494117647058824>; // HEX #E4D77E
    #declare farge_PC_461_C = rgb <0.913725490196078, 0.874509803921569, 0.592156862745098>; // HEX #E9DF97
    #declare farge_PC_462_C = rgb <0.36078431372549, 0.274509803921569, 0.168627450980392>; // HEX #5C462B
    #declare farge_PC_4625_C = rgb <0.309803921568627, 0.172549019607843, 0.113725490196078>; // HEX #4F2C1D
    #declare farge_PC_463_C = rgb <0.454901960784314, 0.309803921568627, 0.156862745098039>; // HEX #744F28
    #declare farge_PC_4635_C = rgb <0.580392156862745, 0.376470588235294, 0.215686274509804>; // HEX #946037
    #declare farge_PC_464_C = rgb <0.545098039215686, 0.356862745098039, 0.16078431372549>; // HEX #8B5B29
    #declare farge_PC_4645_C = rgb <0.67843137254902, 0.486274509803922, 0.349019607843137>; // HEX #AD7C59
    #declare farge_PC_465_C = rgb <0.725490196078431, 0.592156862745098, 0.356862745098039>; // HEX #B9975B
    #declare farge_PC_4655_C = rgb <0.749019607843137, 0.580392156862745, 0.454901960784314>; // HEX #BF9474
    #declare farge_PC_466_C = rgb <0.776470588235294, 0.666666666666667, 0.462745098039216>; // HEX #C6AA76
    #declare farge_PC_4665_C = rgb <0.803921568627451, 0.654901960784314, 0.533333333333333>; // HEX #CDA788
    #declare farge_PC_467_C = rgb <0.827450980392157, 0.737254901960784, 0.552941176470588>; // HEX #D3BC8D
    #declare farge_PC_4675_C = rgb <0.862745098039216, 0.749019607843137, 0.650980392156863>; // HEX #DCBFA6
    #declare farge_PC_468_C = rgb <0.866666666666667, 0.796078431372549, 0.643137254901961>; // HEX #DDCBA4
    #declare farge_PC_4685_C = rgb <0.87843137254902, 0.776470588235294, 0.67843137254902>; // HEX #E0C6AD
    #declare farge_PC_469_C = rgb <0.411764705882353, 0.247058823529412, 0.137254901960784>; // HEX #693F23
    #declare farge_PC_4695_C = rgb <0.356862745098039, 0.203921568627451, 0.152941176470588>; // HEX #5B3427
    #declare farge_PC_470_C = rgb <0.643137254901961, 0.352941176470588, 0.164705882352941>; // HEX #A45A2A
    #declare farge_PC_4705_C = rgb <0.486274509803922, 0.301960784313725, 0.227450980392157>; // HEX #7C4D3A
    #declare farge_PC_471_C = rgb <0.72156862745098, 0.380392156862745, 0.145098039215686>; // HEX #B86125
    #declare farge_PC_4715_C = rgb <0.584313725490196, 0.423529411764706, 0.345098039215686>; // HEX #956C58
    #declare farge_PC_472_C = rgb <0.898039215686275, 0.619607843137255, 0.427450980392157>; // HEX #E59E6D
    #declare farge_PC_4725_C = rgb <0.682352941176471, 0.541176470588235, 0.474509803921569>; // HEX #AE8A79
    #declare farge_PC_473_C = rgb <0.941176470588235, 0.749019607843137, 0.607843137254902>; // HEX #F0BF9B
    #declare farge_PC_4735_C = rgb <0.752941176470588, 0.63921568627451, 0.572549019607843>; // HEX #C0A392
    #declare farge_PC_474_C = rgb <0.945098039215686, 0.776470588235294, 0.654901960784314>; // HEX #F1C6A7
    #declare farge_PC_4745_C = rgb <0.803921568627451, 0.709803921568627, 0.654901960784314>; // HEX #CDB5A7
    #declare farge_PC_475_C = rgb <0.952941176470588, 0.811764705882353, 0.701960784313725>; // HEX #F3CFB3
    #declare farge_PC_4755_C = rgb <0.843137254901961, 0.768627450980392, 0.717647058823529>; // HEX #D7C4B7
    #declare farge_PC_476_C = rgb <0.305882352941176, 0.211764705882353, 0.16078431372549>; // HEX #4E3629
    #declare farge_PC_477_C = rgb <0.384313725490196, 0.231372549019608, 0.164705882352941>; // HEX #623B2A
    #declare farge_PC_478_C = rgb <0.43921568627451, 0.247058823529412, 0.164705882352941>; // HEX #703F2A
    #declare farge_PC_479_C = rgb <0.666666666666667, 0.501960784313725, 0.4>; // HEX #AA8066
    #declare farge_PC_480_C = rgb <0.776470588235294, 0.662745098039216, 0.572549019607843>; // HEX #C6A992
    #declare farge_PC_481_C = rgb <0.827450980392157, 0.733333333333333, 0.658823529411765>; // HEX #D3BBA8
    #declare farge_PC_482_C = rgb <0.858823529411765, 0.784313725490196, 0.713725490196078>; // HEX #DBC8B6
    #declare farge_PC_483_C = rgb <0.396078431372549, 0.188235294117647, 0.141176470588235>; // HEX #653024
    #declare farge_PC_484_C = rgb <0.603921568627451, 0.2, 0.141176470588235>; // HEX #9A3324
    #declare farge_PC_485_C = rgb <0.854901960784314, 0.16078431372549, 0.109803921568627>; // HEX #DA291C
    #declare farge_PC_486_C = rgb <0.909803921568627, 0.572549019607843, 0.486274509803922>; // HEX #E8927C
    #declare farge_PC_487_C = rgb <0.917647058823529, 0.654901960784314, 0.580392156862745>; // HEX #EAA794
    #declare farge_PC_488_C = rgb <0.925490196078431, 0.729411764705882, 0.658823529411765>; // HEX #ECBAA8
    #declare farge_PC_489_C = rgb <0.925490196078431, 0.764705882352941, 0.698039215686274>; // HEX #ECC3B2
    #declare farge_PC_490_C = rgb <0.364705882352941, 0.164705882352941, 0.172549019607843>; // HEX #5D2A2C
    #declare farge_PC_491_C = rgb <0.498039215686275, 0.188235294117647, 0.207843137254902>; // HEX #7F3035
    #declare farge_PC_492_C = rgb <0.56078431372549, 0.196078431372549, 0.215686274509804>; // HEX #8F3237
    #declare farge_PC_493_C = rgb <0.862745098039216, 0.525490196078431, 0.6>; // HEX #DC8699
    #declare farge_PC_494_C = rgb <0.913725490196078, 0.635294117647059, 0.698039215686274>; // HEX #E9A2B2
    #declare farge_PC_495_C = rgb <0.945098039215686, 0.741176470588235, 0.784313725490196>; // HEX #F1BDC8
    #declare farge_PC_496_C = rgb <0.949019607843137, 0.776470588235294, 0.811764705882353>; // HEX #F2C6CF
    #declare farge_PC_497_C = rgb <0.317647058823529, 0.184313725490196, 0.180392156862745>; // HEX #512F2E
    #declare farge_PC_4975_C = rgb <0.247058823529412, 0.125490196078431, 0.129411764705882>; // HEX #3F2021
    #declare farge_PC_498_C = rgb <0.415686274509804, 0.215686274509804, 0.207843137254902>; // HEX #6A3735
    #declare farge_PC_4985_C = rgb <0.529411764705882, 0.294117647058824, 0.32156862745098>; // HEX #874B52
    #declare farge_PC_499_C = rgb <0.47843137254902, 0.243137254901961, 0.227450980392157>; // HEX #7A3E3A
    #declare farge_PC_4995_C = rgb <0.611764705882353, 0.380392156862745, 0.411764705882353>; // HEX #9C6169
    #declare farge_PC_500_C = rgb <0.776470588235294, 0.52156862745098, 0.56078431372549>; // HEX #C6858F
    #declare farge_PC_5005_C = rgb <0.690196078431373, 0.486274509803922, 0.513725490196078>; // HEX #B07C83
    #declare farge_PC_501_C = rgb <0.854901960784314, 0.647058823529412, 0.67843137254902>; // HEX #DAA5AD
    #declare farge_PC_5015_C = rgb <0.8, 0.631372549019608, 0.650980392156863>; // HEX #CCA1A6
    #declare farge_PC_502_C = rgb <0.898039215686275, 0.729411764705882, 0.756862745098039>; // HEX #E5BAC1
    #declare farge_PC_5025_C = rgb <0.858823529411765, 0.717647058823529, 0.733333333333333>; // HEX #DBB7BB
    #declare farge_PC_503_C = rgb <0.913725490196078, 0.768627450980392, 0.780392156862745>; // HEX #E9C4C7
    #declare farge_PC_5035_C = rgb <0.874509803921569, 0.76078431372549, 0.764705882352941>; // HEX #DFC2C3
    #declare farge_PC_504_C = rgb <0.341176470588235, 0.16078431372549, 0.196078431372549>; // HEX #572932
    #declare farge_PC_505_C = rgb <0.435294117647059, 0.172549019607843, 0.247058823529412>; // HEX #6F2C3F
    #declare farge_PC_506_C = rgb <0.517647058823529, 0.203921568627451, 0.305882352941176>; // HEX #84344E
    #declare farge_PC_507_C = rgb <0.835294117647059, 0.572549019607843, 0.666666666666667>; // HEX #D592AA
    #declare farge_PC_508_C = rgb <0.894117647058824, 0.662745098039216, 0.733333333333333>; // HEX #E4A9BB
    #declare farge_PC_509_C = rgb <0.909803921568627, 0.701960784313725, 0.764705882352941>; // HEX #E8B3C3
    #declare farge_PC_510_C = rgb <0.92156862745098, 0.745098039215686, 0.796078431372549>; // HEX #EBBECB
    #declare farge_PC_511_C = rgb <0.380392156862745, 0.172549019607843, 0.317647058823529>; // HEX #612C51
    #declare farge_PC_5115_C = rgb <0.317647058823529, 0.164705882352941, 0.266666666666667>; // HEX #512A44
    #declare farge_PC_512_C = rgb <0.513725490196078, 0.192156862745098, 0.466666666666667>; // HEX #833177
    #declare farge_PC_5125_C = rgb <0.411764705882353, 0.235294117647059, 0.368627450980392>; // HEX #693C5E
    #declare farge_PC_513_C = rgb <0.576470588235294, 0.196078431372549, 0.556862745098039>; // HEX #93328E
    #declare farge_PC_5135_C = rgb <0.494117647058824, 0.329411764705882, 0.458823529411765>; // HEX #7E5475
    #declare farge_PC_514_C = rgb <0.831372549019608, 0.545098039215686, 0.784313725490196>; // HEX #D48BC8
    #declare farge_PC_5145_C = rgb <0.607843137254902, 0.466666666666667, 0.576470588235294>; // HEX #9B7793
    #declare farge_PC_515_C = rgb <0.886274509803922, 0.674509803921569, 0.843137254901961>; // HEX #E2ACD7
    #declare farge_PC_5155_C = rgb <0.749019607843137, 0.647058823529412, 0.72156862745098>; // HEX #BFA5B8
    #declare farge_PC_516_C = rgb <0.901960784313726, 0.745098039215686, 0.866666666666667>; // HEX #E6BEDD
    #declare farge_PC_5165_C = rgb <0.827450980392157, 0.752941176470588, 0.803921568627451>; // HEX #D3C0CD
    #declare farge_PC_517_C = rgb <0.92156862745098, 0.776470588235294, 0.874509803921569>; // HEX #EBC6DF
    #declare farge_PC_5175_C = rgb <0.847058823529412, 0.784313725490196, 0.819607843137255>; // HEX #D8C8D1
    #declare farge_PC_518_C = rgb <0.294117647058824, 0.188235294117647, 0.282352941176471>; // HEX #4B3048
    #declare farge_PC_5185_C = rgb <0.290196078431373, 0.188235294117647, 0.254901960784314>; // HEX #4A3041
    #declare farge_PC_519_C = rgb <0.349019607843137, 0.192156862745098, 0.372549019607843>; // HEX #59315F
    #declare farge_PC_5195_C = rgb <0.4, 0.262745098039216, 0.352941176470588>; // HEX #66435A
    #declare farge_PC_520_C = rgb <0.392156862745098, 0.184313725490196, 0.423529411764706>; // HEX #642F6C
    #declare farge_PC_5205_C = rgb <0.525490196078431, 0.392156862745098, 0.47843137254902>; // HEX #86647A
    #declare farge_PC_521_C = rgb <0.647058823529412, 0.498039215686275, 0.698039215686274>; // HEX #A57FB2
    #declare farge_PC_5215_C = rgb <0.686274509803922, 0.584313725490196, 0.650980392156863>; // HEX #AF95A6
    #declare farge_PC_522_C = rgb <0.729411764705882, 0.611764705882353, 0.772549019607843>; // HEX #BA9CC5
    #declare farge_PC_5225_C = rgb <0.776470588235294, 0.690196078431373, 0.737254901960784>; // HEX #C6B0BC
    #declare farge_PC_523_C = rgb <0.788235294117647, 0.694117647058824, 0.815686274509804>; // HEX #C9B1D0
    #declare farge_PC_5235_C = rgb <0.815686274509804, 0.745098039215686, 0.780392156862745>; // HEX #D0BEC7
    #declare farge_PC_524_C = rgb <0.835294117647059, 0.76078431372549, 0.847058823529412>; // HEX #D5C2D8
    #declare farge_PC_5245_C = rgb <0.858823529411765, 0.803921568627451, 0.827450980392157>; // HEX #DBCDD3
    #declare farge_PC_525_C = rgb <0.341176470588235, 0.172549019607843, 0.372549019607843>; // HEX #572C5F
    #declare farge_PC_5255_C = rgb <0.117647058823529, 0.101960784313725, 0.203921568627451>; // HEX #1E1A34
    #declare farge_PC_526_C = rgb <0.43921568627451, 0.184313725490196, 0.541176470588235>; // HEX #702F8A
    #declare farge_PC_5265_C = rgb <0.250980392156863, 0.227450980392157, 0.376470588235294>; // HEX #403A60
    #declare farge_PC_527_C = rgb <0.501960784313725, 0.192156862745098, 0.654901960784314>; // HEX #8031A7
    #declare farge_PC_5275_C = rgb <0.349019607843137, 0.329411764705882, 0.470588235294118>; // HEX #595478
    #declare farge_PC_528_C = rgb <0.709803921568627, 0.501960784313725, 0.819607843137255>; // HEX #B580D1
    #declare farge_PC_5285_C = rgb <0.552941176470588, 0.537254901960784, 0.647058823529412>; // HEX #8D89A5
    #declare farge_PC_529_C = rgb <0.792156862745098, 0.635294117647059, 0.866666666666667>; // HEX #CAA2DD
    #declare farge_PC_5295_C = rgb <0.701960784313725, 0.690196078431373, 0.768627450980392>; // HEX #B3B0C4
    #declare farge_PC_530_C = rgb <0.843137254901961, 0.725490196078431, 0.894117647058824>; // HEX #D7B9E4
    #declare farge_PC_5305_C = rgb <0.776470588235294, 0.768627450980392, 0.823529411764706>; // HEX #C6C4D2
    #declare farge_PC_531_C = rgb <0.874509803921569, 0.784313725490196, 0.905882352941176>; // HEX #DFC8E7
    #declare farge_PC_5315_C = rgb <0.847058823529412, 0.843137254901961, 0.874509803921569>; // HEX #D8D7DF
    #declare farge_PC_532_C = rgb <0.109803921568627, 0.12156862745098, 0.164705882352941>; // HEX #1C1F2A
    #declare farge_PC_533_C = rgb <0.12156862745098, 0.164705882352941, 0.266666666666667>; // HEX #1F2A44
    #declare farge_PC_534_C = rgb <0.105882352941176, 0.211764705882353, 0.364705882352941>; // HEX #1B365D
    #declare farge_PC_535_C = rgb <0.556862745098039, 0.623529411764706, 0.737254901960784>; // HEX #8E9FBC
    #declare farge_PC_536_C = rgb <0.635294117647059, 0.698039215686274, 0.784313725490196>; // HEX #A2B2C8
    #declare farge_PC_537_C = rgb <0.733333333333333, 0.780392156862745, 0.83921568627451>; // HEX #BBC7D6
    #declare farge_PC_538_C = rgb <0.772549019607843, 0.811764705882353, 0.854901960784314>; // HEX #C5CFDA
    #declare farge_PC_539_C = rgb <0, 0.149019607843137, 0.227450980392157>; // HEX #00263A
    #declare farge_PC_5395_C = rgb <0.0313725490196078, 0.12156862745098, 0.172549019607843>; // HEX #081F2C
    #declare farge_PC_540_C = rgb <0, 0.188235294117647, 0.341176470588235>; // HEX #003057
    #declare farge_PC_5405_C = rgb <0.309803921568627, 0.458823529411765, 0.545098039215686>; // HEX #4F758B
    #declare farge_PC_541_C = rgb <0, 0.235294117647059, 0.443137254901961>; // HEX #003C71
    #declare farge_PC_5415_C = rgb <0.356862745098039, 0.498039215686275, 0.584313725490196>; // HEX #5B7F95
    #declare farge_PC_542_C = rgb <0.482352941176471, 0.686274509803922, 0.831372549019608>; // HEX #7BAFD4
    #declare farge_PC_5425_C = rgb <0.47843137254902, 0.6, 0.674509803921569>; // HEX #7A99AC
    #declare farge_PC_543_C = rgb <0.643137254901961, 0.784313725490196, 0.882352941176471>; // HEX #A4C8E1
    #declare farge_PC_5435_C = rgb <0.650980392156863, 0.733333333333333, 0.784313725490196>; // HEX #A6BBC8
    #declare farge_PC_544_C = rgb <0.741176470588235, 0.83921568627451, 0.901960784313726>; // HEX #BDD6E6
    #declare farge_PC_5445_C = rgb <0.717647058823529, 0.788235294117647, 0.827450980392157>; // HEX #B7C9D3
    #declare farge_PC_545_C = rgb <0.776470588235294, 0.854901960784314, 0.905882352941176>; // HEX #C6DAE7
    #declare farge_PC_5455_C = rgb <0.749019607843137, 0.807843137254902, 0.83921568627451>; // HEX #BFCED6
    #declare farge_PC_546_C = rgb <0.0274509803921569, 0.168627450980392, 0.192156862745098>; // HEX #072B31
    #declare farge_PC_5463_C = rgb <0.0274509803921569, 0.152941176470588, 0.176470588235294>; // HEX #07272D
    #declare farge_PC_5467_C = rgb <0.0941176470588235, 0.2, 0.184313725490196>; // HEX #18332F
    #declare farge_PC_547_C = rgb <0, 0.192156862745098, 0.235294117647059>; // HEX #00313C
    #declare farge_PC_5473_C = rgb <0.0666666666666667, 0.368627450980392, 0.403921568627451>; // HEX #115E67
    #declare farge_PC_5477_C = rgb <0.243137254901961, 0.364705882352941, 0.345098039215686>; // HEX #3E5D58
    #declare farge_PC_548_C = rgb <0, 0.23921568627451, 0.298039215686275>; // HEX #003D4C
    #declare farge_PC_5483_C = rgb <0.309803921568627, 0.525490196078431, 0.556862745098039>; // HEX #4F868E
    #declare farge_PC_5487_C = rgb <0.364705882352941, 0.474509803921569, 0.458823529411765>; // HEX #5D7975
    #declare farge_PC_549_C = rgb <0.419607843137255, 0.643137254901961, 0.72156862745098>; // HEX #6BA4B8
    #declare farge_PC_5493_C = rgb <0.498039215686275, 0.662745098039216, 0.682352941176471>; // HEX #7FA9AE
    #declare farge_PC_5497_C = rgb <0.509803921568627, 0.6, 0.584313725490196>; // HEX #829995
    #declare farge_PC_550_C = rgb <0.552941176470588, 0.725490196078431, 0.792156862745098>; // HEX #8DB9CA
    #declare farge_PC_5503_C = rgb <0.580392156862745, 0.717647058823529, 0.733333333333333>; // HEX #94B7BB
    #declare farge_PC_5507_C = rgb <0.615686274509804, 0.690196078431373, 0.674509803921569>; // HEX #9DB0AC
    #declare farge_PC_551_C = rgb <0.63921568627451, 0.780392156862745, 0.823529411764706>; // HEX #A3C7D2
    #declare farge_PC_5513_C = rgb <0.670588235294118, 0.780392156862745, 0.792156862745098>; // HEX #ABC7CA
    #declare farge_PC_5517_C = rgb <0.694117647058824, 0.752941176470588, 0.737254901960784>; // HEX #B1C0BC
    #declare farge_PC_552_C = rgb <0.725490196078431, 0.827450980392157, 0.862745098039216>; // HEX #B9D3DC
    #declare farge_PC_5523_C = rgb <0.713725490196078, 0.811764705882353, 0.815686274509804>; // HEX #B6CFD0
    #declare farge_PC_5527_C = rgb <0.737254901960784, 0.788235294117647, 0.772549019607843>; // HEX #BCC9C5
    #declare farge_PC_553_C = rgb <0.156862745098039, 0.27843137254902, 0.203921568627451>; // HEX #284734
    #declare farge_PC_5535_C = rgb <0.0941176470588235, 0.188235294117647, 0.156862745098039>; // HEX #183028
    #declare farge_PC_554_C = rgb <0.125490196078431, 0.36078431372549, 0.250980392156863>; // HEX #205C40
    #declare farge_PC_5545_C = rgb <0.262745098039216, 0.411764705882353, 0.356862745098039>; // HEX #43695B
    #declare farge_PC_555_C = rgb <0.156862745098039, 0.447058823529412, 0.309803921568627>; // HEX #28724F
    #declare farge_PC_5555_C = rgb <0.36078431372549, 0.498039215686275, 0.443137254901961>; // HEX #5C7F71
    #declare farge_PC_556_C = rgb <0.435294117647059, 0.635294117647059, 0.529411764705882>; // HEX #6FA287
    #declare farge_PC_5565_C = rgb <0.498039215686275, 0.611764705882353, 0.564705882352941>; // HEX #7F9C90
    #declare farge_PC_557_C = rgb <0.52156862745098, 0.690196078431373, 0.603921568627451>; // HEX #85B09A
    #declare farge_PC_5575_C = rgb <0.572549019607843, 0.674509803921569, 0.627450980392157>; // HEX #92ACA0
    #declare farge_PC_558_C = rgb <0.603921568627451, 0.745098039215686, 0.666666666666667>; // HEX #9ABEAA
    #declare farge_PC_5585_C = rgb <0.654901960784314, 0.741176470588235, 0.694117647058824>; // HEX #A7BDB1
    #declare farge_PC_559_C = rgb <0.67843137254902, 0.792156862745098, 0.72156862745098>; // HEX #ADCAB8
    #declare farge_PC_5595_C = rgb <0.749019607843137, 0.807843137254902, 0.76078431372549>; // HEX #BFCEC2
    #declare farge_PC_560_C = rgb <0.113725490196078, 0.235294117647059, 0.203921568627451>; // HEX #1D3C34
    #declare farge_PC_5605_C = rgb <0.133333333333333, 0.215686274509804, 0.168627450980392>; // HEX #22372B
    #declare farge_PC_561_C = rgb <0, 0.349019607843137, 0.298039215686275>; // HEX #00594C
    #declare farge_PC_5615_C = rgb <0.368627450980392, 0.454901960784314, 0.380392156862745>; // HEX #5E7461
    #declare farge_PC_562_C = rgb <0, 0.435294117647059, 0.384313725490196>; // HEX #006F62
    #declare farge_PC_5625_C = rgb <0.43921568627451, 0.52156862745098, 0.450980392156863>; // HEX #708573
    #declare farge_PC_563_C = rgb <0.419607843137255, 0.733333333333333, 0.682352941176471>; // HEX #6BBBAE
    #declare farge_PC_5635_C = rgb <0.580392156862745, 0.647058823529412, 0.588235294117647>; // HEX #94A596
    #declare farge_PC_564_C = rgb <0.525490196078431, 0.784313725490196, 0.737254901960784>; // HEX #86C8BC
    #declare farge_PC_5645_C = rgb <0.63921568627451, 0.698039215686274, 0.643137254901961>; // HEX #A3B2A4
    #declare farge_PC_565_C = rgb <0.631372549019608, 0.83921568627451, 0.792156862745098>; // HEX #A1D6CA
    #declare farge_PC_5655_C = rgb <0.690196078431373, 0.741176470588235, 0.690196078431373>; // HEX #B0BDB0
    #declare farge_PC_566_C = rgb <0.725490196078431, 0.862745098039216, 0.823529411764706>; // HEX #B9DCD2
    #declare farge_PC_5665_C = rgb <0.729411764705882, 0.772549019607843, 0.725490196078431>; // HEX #BAC5B9
    #declare farge_PC_567_C = rgb <0.0901960784313725, 0.247058823529412, 0.207843137254902>; // HEX #173F35
    #declare farge_PC_568_C = rgb <0, 0.423529411764706, 0.356862745098039>; // HEX #006C5B
    #declare farge_PC_569_C = rgb <0, 0.505882352941176, 0.427450980392157>; // HEX #00816D
    #declare farge_PC_570_C = rgb <0.419607843137255, 0.792156862745098, 0.729411764705882>; // HEX #6BCABA
    #declare farge_PC_571_C = rgb <0.596078431372549, 0.858823529411765, 0.807843137254902>; // HEX #98DBCE
    #declare farge_PC_572_C = rgb <0.647058823529412, 0.874509803921569, 0.827450980392157>; // HEX #A5DFD3
    #declare farge_PC_573_C = rgb <0.709803921568627, 0.890196078431372, 0.847058823529412>; // HEX #B5E3D8
    #declare farge_PC_574_C = rgb <0.305882352941176, 0.356862745098039, 0.192156862745098>; // HEX #4E5B31
    #declare farge_PC_5743_C = rgb <0.243137254901961, 0.282352941176471, 0.152941176470588>; // HEX #3E4827
    #declare farge_PC_5747_C = rgb <0.23921568627451, 0.266666666666667, 0.117647058823529>; // HEX #3D441E
    #declare farge_PC_575_C = rgb <0.403921568627451, 0.509803921568627, 0.227450980392157>; // HEX #67823A
    #declare farge_PC_5753_C = rgb <0.368627450980392, 0.403921568627451, 0.219607843137255>; // HEX #5E6738
    #declare farge_PC_5757_C = rgb <0.427450980392157, 0.443137254901961, 0.180392156862745>; // HEX #6D712E
    #declare farge_PC_576_C = rgb <0.470588235294118, 0.615686274509804, 0.290196078431373>; // HEX #789D4A
    #declare farge_PC_5763_C = rgb <0.450980392156863, 0.482352941176471, 0.298039215686275>; // HEX #737B4C
    #declare farge_PC_5767_C = rgb <0.541176470588235, 0.552941176470588, 0.290196078431373>; // HEX #8A8D4A
    #declare farge_PC_577_C = rgb <0.662745098039216, 0.768627450980392, 0.498039215686275>; // HEX #A9C47F
    #declare farge_PC_5773_C = rgb <0.537254901960784, 0.564705882352941, 0.392156862745098>; // HEX #899064
    #declare farge_PC_5777_C = rgb <0.635294117647059, 0.647058823529412, 0.411764705882353>; // HEX #A2A569
    #declare farge_PC_578_C = rgb <0.717647058823529, 0.807843137254902, 0.584313725490196>; // HEX #B7CE95
    #declare farge_PC_5783_C = rgb <0.63921568627451, 0.666666666666667, 0.513725490196078>; // HEX #A3AA83
    #declare farge_PC_5787_C = rgb <0.729411764705882, 0.741176470588235, 0.545098039215686>; // HEX #BABD8B
    #declare farge_PC_579_C = rgb <0.737254901960784, 0.819607843137255, 0.607843137254902>; // HEX #BCD19B
    #declare farge_PC_5793_C = rgb <0.701960784313725, 0.725490196078431, 0.584313725490196>; // HEX #B3B995
    #declare farge_PC_5797_C = rgb <0.776470588235294, 0.784313725490196, 0.607843137254902>; // HEX #C6C89B
    #declare farge_PC_580_C = rgb <0.768627450980392, 0.83921568627451, 0.643137254901961>; // HEX #C4D6A4
    #declare farge_PC_5803_C = rgb <0.764705882352941, 0.776470588235294, 0.658823529411765>; // HEX #C3C6A8
    #declare farge_PC_5807_C = rgb <0.815686274509804, 0.819607843137255, 0.670588235294118>; // HEX #D0D1AB
    #declare farge_PC_581_C = rgb <0.384313725490196, 0.364705882352941, 0.125490196078431>; // HEX #625D20
    #declare farge_PC_5815_C = rgb <0.333333333333333, 0.313725490196078, 0.145098039215686>; // HEX #555025
    #declare farge_PC_582_C = rgb <0.556862745098039, 0.549019607843137, 0.0745098039215686>; // HEX #8E8C13
    #declare farge_PC_5825_C = rgb <0.537254901960784, 0.505882352941176, 0.23921568627451>; // HEX #89813D
    #declare farge_PC_583_C = rgb <0.717647058823529, 0.749019607843137, 0.0627450980392157>; // HEX #B7BF10
    #declare farge_PC_5835_C = rgb <0.627450980392157, 0.6, 0.345098039215686>; // HEX #A09958
    #declare farge_PC_584_C = rgb <0.823529411764706, 0.843137254901961, 0.333333333333333>; // HEX #D2D755
    #declare farge_PC_5845_C = rgb <0.686274509803922, 0.662745098039216, 0.431372549019608>; // HEX #AFA96E
    #declare farge_PC_585_C = rgb <0.858823529411765, 0.870588235294118, 0.43921568627451>; // HEX #DBDE70
    #declare farge_PC_5855_C = rgb <0.752941176470588, 0.733333333333333, 0.529411764705882>; // HEX #C0BB87
    #declare farge_PC_586_C = rgb <0.87843137254902, 0.886274509803922, 0.486274509803922>; // HEX #E0E27C
    #declare farge_PC_5865_C = rgb <0.796078431372549, 0.780392156862745, 0.576470588235294>; // HEX #CBC793
    #declare farge_PC_587_C = rgb <0.890196078431372, 0.894117647058824, 0.552941176470588>; // HEX #E3E48D
    #declare farge_PC_5875_C = rgb <0.823529411764706, 0.807843137254902, 0.619607843137255>; // HEX #D2CE9E
    #declare farge_PC_600_C = rgb <0.945098039215686, 0.92156862745098, 0.611764705882353>; // HEX #F1EB9C
    #declare farge_PC_601_C = rgb <0.941176470588235, 0.913725490196078, 0.568627450980392>; // HEX #F0E991
    #declare farge_PC_602_C = rgb <0.941176470588235, 0.909803921568627, 0.482352941176471>; // HEX #F0E87B
    #declare farge_PC_603_C = rgb <0.929411764705882, 0.87843137254902, 0.294117647058824>; // HEX #EDE04B
    #declare farge_PC_604_C = rgb <0.917647058823529, 0.854901960784314, 0.141176470588235>; // HEX #EADA24
    #declare farge_PC_605_C = rgb <0.882352941176471, 0.803921568627451, 0>; // HEX #E1CD00
    #declare farge_PC_606_C = rgb <0.811764705882353, 0.709803921568627, 0>; // HEX #CFB500
    #declare farge_PC_607_C = rgb <0.92156862745098, 0.894117647058824, 0.603921568627451>; // HEX #EBE49A
    #declare farge_PC_608_C = rgb <0.913725490196078, 0.882352941176471, 0.525490196078431>; // HEX #E9E186
    #declare farge_PC_609_C = rgb <0.901960784313726, 0.870588235294118, 0.466666666666667>; // HEX #E6DE77
    #declare farge_PC_610_C = rgb <0.882352941176471, 0.835294117647059, 0.333333333333333>; // HEX #E1D555
    #declare farge_PC_611_C = rgb <0.843137254901961, 0.784313725490196, 0.149019607843137>; // HEX #D7C826
    #declare farge_PC_612_C = rgb <0.768627450980392, 0.690196078431373, 0>; // HEX #C4B000
    #declare farge_PC_613_C = rgb <0.701960784313725, 0.607843137254902, 0>; // HEX #B39B00
    #declare farge_PC_614_C = rgb <0.862745098039216, 0.835294117647059, 0.603921568627451>; // HEX #DCD59A
    #declare farge_PC_615_C = rgb <0.83921568627451, 0.811764705882353, 0.552941176470588>; // HEX #D6CF8D
    #declare farge_PC_616_C = rgb <0.815686274509804, 0.784313725490196, 0.513725490196078>; // HEX #D0C883
    #declare farge_PC_617_C = rgb <0.752941176470588, 0.709803921568627, 0.380392156862745>; // HEX #C0B561
    #declare farge_PC_618_C = rgb <0.674509803921569, 0.623529411764706, 0.235294117647059>; // HEX #AC9F3C
    #declare farge_PC_619_C = rgb <0.623529411764706, 0.568627450980392, 0.164705882352941>; // HEX #9F912A
    #declare farge_PC_620_C = rgb <0.541176470588235, 0.482352941176471, 0.0980392156862745>; // HEX #8A7B19
    #declare farge_PC_621_C = rgb <0.819607843137255, 0.87843137254902, 0.843137254901961>; // HEX #D1E0D7
    #declare farge_PC_622_C = rgb <0.717647058823529, 0.803921568627451, 0.76078431372549>; // HEX #B7CDC2
    #declare farge_PC_623_C = rgb <0.603921568627451, 0.725490196078431, 0.67843137254902>; // HEX #9AB9AD
    #declare farge_PC_624_C = rgb <0.470588235294118, 0.623529411764706, 0.564705882352941>; // HEX #789F90
    #declare farge_PC_625_C = rgb <0.313725490196078, 0.498039215686275, 0.43921568627451>; // HEX #507F70
    #declare farge_PC_626_C = rgb <0.156862745098039, 0.36078431372549, 0.301960784313725>; // HEX #285C4D
    #declare farge_PC_627_C = rgb <0.0745098039215686, 0.196078431372549, 0.168627450980392>; // HEX #13322B
    #declare farge_PC_628_C = rgb <0.72156862745098, 0.866666666666667, 0.882352941176471>; // HEX #B8DDE1
    #declare farge_PC_629_C = rgb <0.607843137254902, 0.827450980392157, 0.866666666666667>; // HEX #9BD3DD
    #declare farge_PC_630_C = rgb <0.466666666666667, 0.772549019607843, 0.835294117647059>; // HEX #77C5D5
    #declare farge_PC_631_C = rgb <0.243137254901961, 0.694117647058824, 0.784313725490196>; // HEX #3EB1C8
    #declare farge_PC_632_C = rgb <0, 0.576470588235294, 0.698039215686274>; // HEX #0093B2
    #declare farge_PC_633_C = rgb <0, 0.450980392156863, 0.588235294117647>; // HEX #007396
    #declare farge_PC_634_C = rgb <0, 0.372549019607843, 0.513725490196078>; // HEX #005F83
    #declare farge_PC_635_C = rgb <0.643137254901961, 0.858823529411765, 0.909803921568627>; // HEX #A4DBE8
    #declare farge_PC_636_C = rgb <0.545098039215686, 0.827450980392157, 0.901960784313726>; // HEX #8BD3E6
    #declare farge_PC_637_C = rgb <0.305882352941176, 0.764705882352941, 0.87843137254902>; // HEX #4EC3E0
    #declare farge_PC_638_C = rgb <0, 0.686274509803922, 0.843137254901961>; // HEX #00AFD7
    #declare farge_PC_639_C = rgb <0, 0.584313725490196, 0.784313725490196>; // HEX #0095C8
    #declare farge_PC_640_C = rgb <0, 0.509803921568627, 0.729411764705882>; // HEX #0082BA
    #declare farge_PC_641_C = rgb <0, 0.403921568627451, 0.627450980392157>; // HEX #0067A0
    #declare farge_PC_642_C = rgb <0.819607843137255, 0.866666666666667, 0.901960784313726>; // HEX #D1DDE6
    #declare farge_PC_643_C = rgb <0.776470588235294, 0.83921568627451, 0.890196078431372>; // HEX #C6D6E3
    #declare farge_PC_644_C = rgb <0.607843137254902, 0.72156862745098, 0.827450980392157>; // HEX #9BB8D3
    #declare farge_PC_645_C = rgb <0.490196078431373, 0.631372549019608, 0.768627450980392>; // HEX #7DA1C4
    #declare farge_PC_646_C = rgb <0.368627450980392, 0.541176470588235, 0.705882352941177>; // HEX #5E8AB4
    #declare farge_PC_647_C = rgb <0.137254901960784, 0.380392156862745, 0.572549019607843>; // HEX #236192
    #declare farge_PC_648_C = rgb <0, 0.180392156862745, 0.364705882352941>; // HEX #002E5D
    #declare farge_PC_649_C = rgb <0.858823529411765, 0.886274509803922, 0.913725490196078>; // HEX #DBE2E9
    #declare farge_PC_650_C = rgb <0.807843137254902, 0.850980392156863, 0.898039215686275>; // HEX #CED9E5
    #declare farge_PC_651_C = rgb <0.654901960784314, 0.737254901960784, 0.83921568627451>; // HEX #A7BCD6
    #declare farge_PC_652_C = rgb <0.490196078431373, 0.607843137254902, 0.756862745098039>; // HEX #7D9BC1
    #declare farge_PC_653_C = rgb <0.196078431372549, 0.384313725490196, 0.584313725490196>; // HEX #326295
    #declare farge_PC_654_C = rgb <0, 0.227450980392157, 0.43921568627451>; // HEX #003A70
    #declare farge_PC_655_C = rgb <0, 0.145098039215686, 0.329411764705882>; // HEX #002554
    #declare farge_PC_656_C = rgb <0.866666666666667, 0.898039215686275, 0.929411764705882>; // HEX #DDE5ED
    #declare farge_PC_657_C = rgb <0.784313725490196, 0.847058823529412, 0.92156862745098>; // HEX #C8D8EB
    #declare farge_PC_658_C = rgb <0.694117647058824, 0.788235294117647, 0.909803921568627>; // HEX #B1C9E8
    #declare farge_PC_659_C = rgb <0.482352941176471, 0.643137254901961, 0.858823529411765>; // HEX #7BA4DB
    #declare farge_PC_660_C = rgb <0.250980392156863, 0.494117647058824, 0.788235294117647>; // HEX #407EC9
    #declare farge_PC_661_C = rgb <0, 0.207843137254902, 0.580392156862745>; // HEX #003594
    #declare farge_PC_662_C = rgb <0, 0.101960784313725, 0.43921568627451>; // HEX #001A70
    #declare farge_PC_663_C = rgb <0.898039215686275, 0.882352941176471, 0.901960784313726>; // HEX #E5E1E6
    #declare farge_PC_664_C = rgb <0.87843137254902, 0.858823529411765, 0.890196078431372>; // HEX #E0DBE3
    #declare farge_PC_665_C = rgb <0.776470588235294, 0.737254901960784, 0.815686274509804>; // HEX #C6BCD0
    #declare farge_PC_666_C = rgb <0.631372549019608, 0.572549019607843, 0.698039215686274>; // HEX #A192B2
    #declare farge_PC_667_C = rgb <0.486274509803922, 0.411764705882353, 0.572549019607843>; // HEX #7C6992
    #declare farge_PC_668_C = rgb <0.380392156862745, 0.294117647058824, 0.474509803921569>; // HEX #614B79
    #declare farge_PC_669_C = rgb <0.247058823529412, 0.164705882352941, 0.337254901960784>; // HEX #3F2A56
    #declare farge_PC_670_C = rgb <0.917647058823529, 0.827450980392157, 0.886274509803922>; // HEX #EAD3E2
    #declare farge_PC_671_C = rgb <0.901960784313726, 0.737254901960784, 0.847058823529412>; // HEX #E6BCD8
    #declare farge_PC_672_C = rgb <0.874509803921569, 0.627450980392157, 0.788235294117647>; // HEX #DFA0C9
    #declare farge_PC_673_C = rgb <0.850980392156863, 0.525490196078431, 0.729411764705882>; // HEX #D986BA
    #declare farge_PC_674_C = rgb <0.776470588235294, 0.341176470588235, 0.603921568627451>; // HEX #C6579A
    #declare farge_PC_675_C = rgb <0.682352941176471, 0.145098039215686, 0.450980392156863>; // HEX #AE2573
    #declare farge_PC_676_C = rgb <0.588235294117647, 0, 0.317647058823529>; // HEX #960051
    #declare farge_PC_677_C = rgb <0.898039215686275, 0.807843137254902, 0.858823529411765>; // HEX #E5CEDB
    #declare farge_PC_678_C = rgb <0.890196078431372, 0.784313725490196, 0.847058823529412>; // HEX #E3C8D8
    #declare farge_PC_679_C = rgb <0.870588235294118, 0.745098039215686, 0.823529411764706>; // HEX #DEBED2
    #declare farge_PC_680_C = rgb <0.788235294117647, 0.588235294117647, 0.713725490196078>; // HEX #C996B6
    #declare farge_PC_681_C = rgb <0.690196078431373, 0.423529411764706, 0.588235294117647>; // HEX #B06C96
    #declare farge_PC_682_C = rgb <0.6, 0.282352941176471, 0.470588235294118>; // HEX #994878
    #declare farge_PC_683_C = rgb <0.486274509803922, 0.156862745098039, 0.333333333333333>; // HEX #7C2855
    #declare farge_PC_684_C = rgb <0.894117647058824, 0.776470588235294, 0.831372549019608>; // HEX #E4C6D4
    #declare farge_PC_685_C = rgb <0.862745098039216, 0.713725490196078, 0.788235294117647>; // HEX #DCB6C9
    #declare farge_PC_686_C = rgb <0.815686274509804, 0.631372549019608, 0.729411764705882>; // HEX #D0A1BA
    #declare farge_PC_687_C = rgb <0.745098039215686, 0.517647058823529, 0.63921568627451>; // HEX #BE84A3
    #declare farge_PC_688_C = rgb <0.654901960784314, 0.388235294117647, 0.537254901960784>; // HEX #A76389
    #declare farge_PC_689_C = rgb <0.537254901960784, 0.231372549019608, 0.403921568627451>; // HEX #893B67
    #declare farge_PC_690_C = rgb <0.380392156862745, 0.129411764705882, 0.254901960784314>; // HEX #612141
    #declare farge_PC_691_C = rgb <0.913725490196078, 0.803921568627451, 0.815686274509804>; // HEX #E9CDD0
    #declare farge_PC_692_C = rgb <0.894117647058824, 0.745098039215686, 0.764705882352941>; // HEX #E4BEC3
    #declare farge_PC_693_C = rgb <0.843137254901961, 0.63921568627451, 0.670588235294118>; // HEX #D7A3AB
    #declare farge_PC_694_C = rgb <0.768627450980392, 0.517647058823529, 0.564705882352941>; // HEX #C48490
    #declare farge_PC_695_C = rgb <0.705882352941177, 0.419607843137255, 0.47843137254902>; // HEX #B46B7A
    #declare farge_PC_696_C = rgb <0.596078431372549, 0.282352941176471, 0.337254901960784>; // HEX #984856
    #declare farge_PC_697_C = rgb <0.537254901960784, 0.235294117647059, 0.27843137254902>; // HEX #893C47
    #declare farge_PC_698_C = rgb <0.949019607843137, 0.831372549019608, 0.843137254901961>; // HEX #F2D4D7
    #declare farge_PC_699_C = rgb <0.956862745098039, 0.764705882352941, 0.8>; // HEX #F4C3CC
    #declare farge_PC_700_C = rgb <0.949019607843137, 0.674509803921569, 0.725490196078431>; // HEX #F2ACB9
    #declare farge_PC_701_C = rgb <0.901960784313726, 0.525490196078431, 0.6>; // HEX #E68699
    #declare farge_PC_702_C = rgb <0.823529411764706, 0.356862745098039, 0.450980392156863>; // HEX #D25B73
    #declare farge_PC_703_C = rgb <0.72156862745098, 0.227450980392157, 0.294117647058824>; // HEX #B83A4B
    #declare farge_PC_704_C = rgb <0.619607843137255, 0.164705882352941, 0.184313725490196>; // HEX #9E2A2F
    #declare farge_PC_705_C = rgb <0.96078431372549, 0.854901960784314, 0.874509803921569>; // HEX #F5DADF
    #declare farge_PC_706_C = rgb <0.968627450980392, 0.807843137254902, 0.843137254901961>; // HEX #F7CED7
    #declare farge_PC_707_C = rgb <0.976470588235294, 0.709803921568627, 0.768627450980392>; // HEX #F9B5C4
    #declare farge_PC_708_C = rgb <0.972549019607843, 0.564705882352941, 0.647058823529412>; // HEX #F890A5
    #declare farge_PC_709_C = rgb <0.937254901960784, 0.376470588235294, 0.474509803921569>; // HEX #EF6079
    #declare farge_PC_710_C = rgb <0.87843137254902, 0.243137254901961, 0.32156862745098>; // HEX #E03E52
    #declare farge_PC_711_C = rgb <0.796078431372549, 0.172549019607843, 0.188235294117647>; // HEX #CB2C30
    #declare farge_PC_712_C = rgb <0.988235294117647, 0.784313725490196, 0.607843137254902>; // HEX #FCC89B
    #declare farge_PC_713_C = rgb <0.992156862745098, 0.745098039215686, 0.529411764705882>; // HEX #FDBE87
    #declare farge_PC_714_C = rgb <0.992156862745098, 0.666666666666667, 0.388235294117647>; // HEX #FDAA63
    #declare farge_PC_715_C = rgb <0.964705882352941, 0.552941176470588, 0.180392156862745>; // HEX #F68D2E
    #declare farge_PC_716_C = rgb <0.917647058823529, 0.462745098039216, 0>; // HEX #EA7600
    #declare farge_PC_717_C = rgb <0.831372549019608, 0.364705882352941, 0>; // HEX #D45D00
    #declare farge_PC_718_C = rgb <0.745098039215686, 0.301960784313725, 0>; // HEX #BE4D00
    #declare farge_PC_719_C = rgb <0.929411764705882, 0.784313725490196, 0.63921568627451>; // HEX #EDC8A3
    #declare farge_PC_720_C = rgb <0.905882352941176, 0.717647058823529, 0.541176470588235>; // HEX #E7B78A
    #declare farge_PC_721_C = rgb <0.866666666666667, 0.643137254901961, 0.435294117647059>; // HEX #DDA46F
    #declare farge_PC_722_C = rgb <0.784313725490196, 0.509803921568627, 0.258823529411765>; // HEX #C88242
    #declare farge_PC_723_C = rgb <0.701960784313725, 0.411764705882353, 0.141176470588235>; // HEX #B36924
    #declare farge_PC_724_C = rgb <0.576470588235294, 0.301960784313725, 0.0666666666666667>; // HEX #934D11
    #declare farge_PC_725_C = rgb <0.490196078431373, 0.247058823529412, 0.0862745098039216>; // HEX #7D3F16
    #declare farge_PC_726_C = rgb <0.87843137254902, 0.752941176470588, 0.623529411764706>; // HEX #E0C09F
    #declare farge_PC_727_C = rgb <0.850980392156863, 0.705882352941177, 0.56078431372549>; // HEX #D9B48F
    #declare farge_PC_728_C = rgb <0.803921568627451, 0.627450980392157, 0.466666666666667>; // HEX #CDA077
    #declare farge_PC_729_C = rgb <0.709803921568627, 0.505882352941176, 0.313725490196078>; // HEX #B58150
    #declare farge_PC_730_C = rgb <0.619607843137255, 0.396078431372549, 0.180392156862745>; // HEX #9E652E
    #declare farge_PC_731_C = rgb <0.466666666666667, 0.258823529411765, 0.0705882352941176>; // HEX #774212
    #declare farge_PC_732_C = rgb <0.384313725490196, 0.203921568627451, 0.0705882352941176>; // HEX #623412
    #declare farge_PC_7401_C = rgb <0.96078431372549, 0.882352941176471, 0.643137254901961>; // HEX #F5E1A4
    #declare farge_PC_7402_C = rgb <0.925490196078431, 0.847058823529412, 0.596078431372549>; // HEX #ECD898
    #declare farge_PC_7403_C = rgb <0.933333333333333, 0.831372549019608, 0.517647058823529>; // HEX #EED484
    #declare farge_PC_7404_C = rgb <0.956862745098039, 0.854901960784314, 0.250980392156863>; // HEX #F4DA40
    #declare farge_PC_7405_C = rgb <0.949019607843137, 0.803921568627451, 0>; // HEX #F2CD00
    #declare farge_PC_7406_C = rgb <0.945098039215686, 0.768627450980392, 0>; // HEX #F1C400
    #declare farge_PC_7407_C = rgb <0.796078431372549, 0.627450980392157, 0.32156862745098>; // HEX #CBA052
    #declare farge_PC_7408_C = rgb <0.964705882352941, 0.745098039215686, 0>; // HEX #F6BE00
    #declare farge_PC_7409_C = rgb <0.941176470588235, 0.701960784313725, 0.137254901960784>; // HEX #F0B323
    #declare farge_PC_7410_C = rgb <0.996078431372549, 0.67843137254902, 0.466666666666667>; // HEX #FEAD77
    #declare farge_PC_7411_C = rgb <0.901960784313726, 0.650980392156863, 0.364705882352941>; // HEX #E6A65D
    #declare farge_PC_7412_C = rgb <0.827450980392157, 0.509803921568627, 0.207843137254902>; // HEX #D38235
    #declare farge_PC_7413_C = rgb <0.862745098039216, 0.525490196078431, 0.2>; // HEX #DC8633
    #declare farge_PC_7414_C = rgb <0.756862745098039, 0.423529411764706, 0.0941176470588235>; // HEX #C16C18
    #declare farge_PC_7415_C = rgb <0.901960784313726, 0.729411764705882, 0.658823529411765>; // HEX #E6BAA8
    #declare farge_PC_7416_C = rgb <0.898039215686275, 0.415686274509804, 0.329411764705882>; // HEX #E56A54
    #declare farge_PC_7417_C = rgb <0.87843137254902, 0.305882352941176, 0.223529411764706>; // HEX #E04E39
    #declare farge_PC_7418_C = rgb <0.803921568627451, 0.329411764705882, 0.356862745098039>; // HEX #CD545B
    #declare farge_PC_7419_C = rgb <0.690196078431373, 0.290196078431373, 0.352941176470588>; // HEX #B04A5A
    #declare farge_PC_7420_C = rgb <0.607843137254902, 0.133333333333333, 0.258823529411765>; // HEX #9B2242
    #declare farge_PC_7421_C = rgb <0.396078431372549, 0.113725490196078, 0.196078431372549>; // HEX #651D32
    #declare farge_PC_7422_C = rgb <0.956862745098039, 0.803921568627451, 0.831372549019608>; // HEX #F4CDD4
    #declare farge_PC_7423_C = rgb <0.87843137254902, 0.384313725490196, 0.529411764705882>; // HEX #E06287
    #declare farge_PC_7424_C = rgb <0.886274509803922, 0.270588235294118, 0.52156862745098>; // HEX #E24585
    #declare farge_PC_7425_C = rgb <0.709803921568627, 0.145098039215686, 0.333333333333333>; // HEX #B52555
    #declare farge_PC_7426_C = rgb <0.643137254901961, 0.0705882352941176, 0.247058823529412>; // HEX #A4123F
    #declare farge_PC_7427_C = rgb <0.592156862745098, 0.105882352941176, 0.184313725490196>; // HEX #971B2F
    #declare farge_PC_7428_C = rgb <0.415686274509804, 0.172549019607843, 0.243137254901961>; // HEX #6A2C3E
    #declare farge_PC_7429_C = rgb <0.886274509803922, 0.737254901960784, 0.796078431372549>; // HEX #E2BCCB
    #declare farge_PC_7430_C = rgb <0.862745098039216, 0.662745098039216, 0.749019607843137>; // HEX #DCA9BF
    #declare farge_PC_7431_C = rgb <0.788235294117647, 0.501960784313725, 0.619607843137255>; // HEX #C9809E
    #declare farge_PC_7432_C = rgb <0.709803921568627, 0.36078431372549, 0.501960784313725>; // HEX #B55C80
    #declare farge_PC_7433_C = rgb <0.654901960784314, 0.227450980392157, 0.392156862745098>; // HEX #A73A64
    #declare farge_PC_7434_C = rgb <0.607843137254902, 0.196078431372549, 0.349019607843137>; // HEX #9B3259
    #declare farge_PC_7435_C = rgb <0.529411764705882, 0.149019607843137, 0.317647058823529>; // HEX #872651
    #declare farge_PC_7436_C = rgb <0.933333333333333, 0.854901960784314, 0.917647058823529>; // HEX #EEDAEA
    #declare farge_PC_7437_C = rgb <0.8, 0.682352941176471, 0.815686274509804>; // HEX #CCAED0
    #declare farge_PC_7438_C = rgb <0.835294117647059, 0.619607843137255, 0.843137254901961>; // HEX #D59ED7
    #declare farge_PC_7439_C = rgb <0.698039215686274, 0.533333333333333, 0.725490196078431>; // HEX #B288B9
    #declare farge_PC_7440_C = rgb <0.635294117647059, 0.466666666666667, 0.650980392156863>; // HEX #A277A6
    #declare farge_PC_7441_C = rgb <0.623529411764706, 0.36078431372549, 0.752941176470588>; // HEX #9F5CC0
    #declare farge_PC_7442_C = rgb <0.588235294117647, 0.235294117647059, 0.741176470588235>; // HEX #963CBD
    #declare farge_PC_7443_C = rgb <0.866666666666667, 0.854901960784314, 0.909803921568627>; // HEX #DDDAE8
    #declare farge_PC_7444_C = rgb <0.713725490196078, 0.72156862745098, 0.862745098039216>; // HEX #B6B8DC
    #declare farge_PC_7445_C = rgb <0.654901960784314, 0.635294117647059, 0.764705882352941>; // HEX #A7A2C3
    #declare farge_PC_7446_C = rgb <0.537254901960784, 0.525490196078431, 0.792156862745098>; // HEX #8986CA
    #declare farge_PC_7447_C = rgb <0.364705882352941, 0.27843137254902, 0.466666666666667>; // HEX #5D4777
    #declare farge_PC_7448_C = rgb <0.294117647058824, 0.219607843137255, 0.298039215686275>; // HEX #4B384C
    #declare farge_PC_7449_C = rgb <0.254901960784314, 0.152941176470588, 0.231372549019608>; // HEX #41273B
    #declare farge_PC_7450_C = rgb <0.741176470588235, 0.772549019607843, 0.858823529411765>; // HEX #BDC5DB
    #declare farge_PC_7451_C = rgb <0.537254901960784, 0.670588235294118, 0.890196078431372>; // HEX #89ABE3
    #declare farge_PC_7452_C = rgb <0.501960784313725, 0.580392156862745, 0.866666666666667>; // HEX #8094DD
    #declare farge_PC_7453_C = rgb <0.482352941176471, 0.650980392156863, 0.870588235294118>; // HEX #7BA6DE
    #declare farge_PC_7454_C = rgb <0.372549019607843, 0.56078431372549, 0.705882352941177>; // HEX #5F8FB4
    #declare farge_PC_7455_C = rgb <0.227450980392157, 0.364705882352941, 0.682352941176471>; // HEX #3A5DAE
    #declare farge_PC_7456_C = rgb <0.376470588235294, 0.431372549019608, 0.698039215686274>; // HEX #606EB2
    #declare farge_PC_7457_C = rgb <0.733333333333333, 0.866666666666667, 0.901960784313726>; // HEX #BBDDE6
    #declare farge_PC_7458_C = rgb <0.443137254901961, 0.698039215686274, 0.788235294117647>; // HEX #71B2C9
    #declare farge_PC_7459_C = rgb <0.258823529411765, 0.596078431372549, 0.709803921568627>; // HEX #4298B5
    #declare farge_PC_7460_C = rgb <0, 0.525490196078431, 0.749019607843137>; // HEX #0086BF
    #declare farge_PC_7461_C = rgb <0, 0.490196078431373, 0.729411764705882>; // HEX #007DBA
    #declare farge_PC_7462_C = rgb <0, 0.333333333333333, 0.549019607843137>; // HEX #00558C
    #declare farge_PC_7463_C = rgb <0, 0.168627450980392, 0.286274509803922>; // HEX #002B49
    #declare farge_PC_7464_C = rgb <0.627450980392157, 0.819607843137255, 0.792156862745098>; // HEX #A0D1CA
    #declare farge_PC_7465_C = rgb <0.250980392156863, 0.756862745098039, 0.674509803921569>; // HEX #40C1AC
    #declare farge_PC_7466_C = rgb <0, 0.690196078431373, 0.725490196078431>; // HEX #00B0B9
    #declare farge_PC_7467_C = rgb <0, 0.63921568627451, 0.67843137254902>; // HEX #00A3AD
    #declare farge_PC_7468_C = rgb <0, 0.450980392156863, 0.596078431372549>; // HEX #007398
    #declare farge_PC_7469_C = rgb <0, 0.372549019607843, 0.525490196078431>; // HEX #005F86
    #declare farge_PC_7470_C = rgb <0, 0.352941176470588, 0.43921568627451>; // HEX #005A70
    #declare farge_PC_7471_C = rgb <0.494117647058824, 0.866666666666667, 0.827450980392157>; // HEX #7EDDD3
    #declare farge_PC_7472_C = rgb <0.36078431372549, 0.72156862745098, 0.698039215686274>; // HEX #5CB8B2
    #declare farge_PC_7473_C = rgb <0.152941176470588, 0.6, 0.537254901960784>; // HEX #279989
    #declare farge_PC_7474_C = rgb <0, 0.462745098039216, 0.505882352941176>; // HEX #007681
    #declare farge_PC_7475_C = rgb <0.282352941176471, 0.47843137254902, 0.482352941176471>; // HEX #487A7B
    #declare farge_PC_7476_C = rgb <0.0509803921568627, 0.32156862745098, 0.341176470588235>; // HEX #0D5257
    #declare farge_PC_7477_C = rgb <0.141176470588235, 0.298039215686275, 0.352941176470588>; // HEX #244C5A
    #declare farge_PC_7478_C = rgb <0.607843137254902, 0.890196078431372, 0.749019607843137>; // HEX #9BE3BF
    #declare farge_PC_7479_C = rgb <0.149019607843137, 0.815686274509804, 0.486274509803922>; // HEX #26D07C
    #declare farge_PC_7480_C = rgb <0, 0.749019607843137, 0.435294117647059>; // HEX #00BF6F
    #declare farge_PC_7481_C = rgb <0, 0.717647058823529, 0.309803921568627>; // HEX #00B74F
    #declare farge_PC_7482_C = rgb <0, 0.623529411764706, 0.301960784313725>; // HEX #009F4D
    #declare farge_PC_7483_C = rgb <0.152941176470588, 0.364705882352941, 0.219607843137255>; // HEX #275D38
    #declare farge_PC_7484_C = rgb <0, 0.341176470588235, 0.247058823529412>; // HEX #00573F
    #declare farge_PC_7485_C = rgb <0.815686274509804, 0.870588235294118, 0.733333333333333>; // HEX #D0DEBB
    #declare farge_PC_7486_C = rgb <0.737254901960784, 0.882352941176471, 0.580392156862745>; // HEX #BCE194
    #declare farge_PC_7487_C = rgb <0.556862745098039, 0.866666666666667, 0.396078431372549>; // HEX #8EDD65
    #declare farge_PC_7488_C = rgb <0.470588235294118, 0.83921568627451, 0.294117647058824>; // HEX #78D64B
    #declare farge_PC_7489_C = rgb <0.454901960784314, 0.666666666666667, 0.313725490196078>; // HEX #74AA50
    #declare farge_PC_7490_C = rgb <0.443137254901961, 0.6, 0.286274509803922>; // HEX #719949
    #declare farge_PC_7491_C = rgb <0.474509803921569, 0.525490196078431, 0.235294117647059>; // HEX #79863C
    #declare farge_PC_7492_C = rgb <0.749019607843137, 0.8, 0.501960784313725>; // HEX #BFCC80
    #declare farge_PC_7493_C = rgb <0.733333333333333, 0.772549019607843, 0.572549019607843>; // HEX #BBC592
    #declare farge_PC_7494_C = rgb <0.611764705882353, 0.686274509803922, 0.533333333333333>; // HEX #9CAF88
    #declare farge_PC_7495_C = rgb <0.56078431372549, 0.6, 0.243137254901961>; // HEX #8F993E
    #declare farge_PC_7496_C = rgb <0.462745098039216, 0.533333333333333, 0.113725490196078>; // HEX #76881D
    #declare farge_PC_7497_C = rgb <0.47843137254902, 0.447058823529412, 0.337254901960784>; // HEX #7A7256
    #declare farge_PC_7498_C = rgb <0.356862745098039, 0.384313725490196, 0.211764705882353>; // HEX #5B6236
    #declare farge_PC_7499_C = rgb <0.945098039215686, 0.901960784313726, 0.698039215686274>; // HEX #F1E6B2
    #declare farge_PC_7500_C = rgb <0.874509803921569, 0.819607843137255, 0.654901960784314>; // HEX #DFD1A7
    #declare farge_PC_7501_C = rgb <0.850980392156863, 0.784313725490196, 0.619607843137255>; // HEX #D9C89E
    #declare farge_PC_7502_C = rgb <0.807843137254902, 0.72156862745098, 0.533333333333333>; // HEX #CEB888
    #declare farge_PC_7503_C = rgb <0.658823529411765, 0.6, 0.407843137254902>; // HEX #A89968
    #declare farge_PC_7504_C = rgb <0.580392156862745, 0.474509803921569, 0.364705882352941>; // HEX #94795D
    #declare farge_PC_7505_C = rgb <0.505882352941176, 0.376470588235294, 0.250980392156863>; // HEX #816040
    #declare farge_PC_7506_C = rgb <0.937254901960784, 0.858823529411765, 0.698039215686274>; // HEX #EFDBB2
    #declare farge_PC_7507_C = rgb <0.988235294117647, 0.823529411764706, 0.6>; // HEX #FCD299
    #declare farge_PC_7508_C = rgb <0.882352941176471, 0.72156862745098, 0.498039215686275>; // HEX #E1B87F
    #declare farge_PC_7509_C = rgb <0.83921568627451, 0.643137254901961, 0.380392156862745>; // HEX #D6A461
    #declare farge_PC_7510_C = rgb <0.776470588235294, 0.537254901960784, 0.247058823529412>; // HEX #C6893F
    #declare farge_PC_7511_C = rgb <0.717647058823529, 0.466666666666667, 0.16078431372549>; // HEX #B77729
    #declare farge_PC_7512_C = rgb <0.650980392156863, 0.388235294117647, 0.105882352941176>; // HEX #A6631B
    #declare farge_PC_7513_C = rgb <0.882352941176471, 0.717647058823529, 0.654901960784314>; // HEX #E1B7A7
    #declare farge_PC_7514_C = rgb <0.835294117647059, 0.635294117647059, 0.525490196078431>; // HEX #D5A286
    #declare farge_PC_7515_C = rgb <0.772549019607843, 0.545098039215686, 0.407843137254902>; // HEX #C58B68
    #declare farge_PC_7516_C = rgb <0.6, 0.333333333333333, 0.168627450980392>; // HEX #99552B
    #declare farge_PC_7517_C = rgb <0.52156862745098, 0.262745098039216, 0.117647058823529>; // HEX #85431E
    #declare farge_PC_7518_C = rgb <0.427450980392157, 0.309803921568627, 0.27843137254902>; // HEX #6D4F47
    #declare farge_PC_7519_C = rgb <0.368627450980392, 0.294117647058824, 0.235294117647059>; // HEX #5E4B3C
    #declare farge_PC_7520_C = rgb <0.917647058823529, 0.745098039215686, 0.690196078431373>; // HEX #EABEB0
    #declare farge_PC_7521_C = rgb <0.752941176470588, 0.611764705882353, 0.513725490196078>; // HEX #C09C83
    #declare farge_PC_7522_C = rgb <0.705882352941177, 0.415686274509804, 0.333333333333333>; // HEX #B46A55
    #declare farge_PC_7523_C = rgb <0.670588235294118, 0.36078431372549, 0.341176470588235>; // HEX #AB5C57
    #declare farge_PC_7524_C = rgb <0.643137254901961, 0.32156862745098, 0.282352941176471>; // HEX #A45248
    #declare farge_PC_7525_C = rgb <0.603921568627451, 0.415686274509804, 0.309803921568627>; // HEX #9A6A4F
    #declare farge_PC_7526_C = rgb <0.541176470588235, 0.223529411764706, 0.105882352941176>; // HEX #8A391B
    #declare farge_PC_7527_C = rgb <0.83921568627451, 0.823529411764706, 0.768627450980392>; // HEX #D6D2C4
    #declare farge_PC_7528_C = rgb <0.772549019607843, 0.725490196078431, 0.674509803921569>; // HEX #C5B9AC
    #declare farge_PC_7529_C = rgb <0.717647058823529, 0.662745098039216, 0.603921568627451>; // HEX #B7A99A
    #declare farge_PC_7530_C = rgb <0.63921568627451, 0.576470588235294, 0.509803921568627>; // HEX #A39382
    #declare farge_PC_7531_C = rgb <0.47843137254902, 0.407843137254902, 0.333333333333333>; // HEX #7A6855
    #declare farge_PC_7532_C = rgb <0.388235294117647, 0.317647058823529, 0.23921568627451>; // HEX #63513D
    #declare farge_PC_7533_C = rgb <0.27843137254902, 0.215686274509804, 0.16078431372549>; // HEX #473729
    #declare farge_PC_7534_C = rgb <0.819607843137255, 0.8, 0.741176470588235>; // HEX #D1CCBD
    #declare farge_PC_7535_C = rgb <0.717647058823529, 0.690196078431373, 0.611764705882353>; // HEX #B7B09C
    #declare farge_PC_7536_C = rgb <0.650980392156863, 0.623529411764706, 0.533333333333333>; // HEX #A69F88
    #declare farge_PC_7537_C = rgb <0.654901960784314, 0.674509803921569, 0.635294117647059>; // HEX #A7ACA2
    #declare farge_PC_7538_C = rgb <0.580392156862745, 0.603921568627451, 0.564705882352941>; // HEX #949A90
    #declare farge_PC_7539_C = rgb <0.556862745098039, 0.564705882352941, 0.537254901960784>; // HEX #8E9089
    #declare farge_PC_7540_C = rgb <0.294117647058824, 0.309803921568627, 0.329411764705882>; // HEX #4B4F54
    #declare farge_PC_7541_C = rgb <0.850980392156863, 0.882352941176471, 0.886274509803922>; // HEX #D9E1E2
    #declare farge_PC_7542_C = rgb <0.643137254901961, 0.737254901960784, 0.76078431372549>; // HEX #A4BCC2
    #declare farge_PC_7543_C = rgb <0.596078431372549, 0.643137254901961, 0.682352941176471>; // HEX #98A4AE
    #declare farge_PC_7544_C = rgb <0.462745098039216, 0.525490196078431, 0.572549019607843>; // HEX #768692
    #declare farge_PC_7545_C = rgb <0.258823529411765, 0.333333333333333, 0.388235294117647>; // HEX #425563
    #declare farge_PC_7546_C = rgb <0.145098039215686, 0.215686274509804, 0.274509803921569>; // HEX #253746
    #declare farge_PC_7547_C = rgb <0.0745098039215686, 0.117647058823529, 0.16078431372549>; // HEX #131E29
    #declare farge_PC_7548_C = rgb <1, 0.776470588235294, 0>; // HEX #FFC600
    #declare farge_PC_7549_C = rgb <1, 0.709803921568627, 0>; // HEX #FFB500
    #declare farge_PC_7550_C = rgb <0.819607843137255, 0.564705882352941, 0>; // HEX #D19000
    #declare farge_PC_7551_C = rgb <0.705882352941177, 0.494117647058824, 0>; // HEX #B47E00
    #declare farge_PC_7552_C = rgb <0.450980392156863, 0.325490196078431, 0.113725490196078>; // HEX #73531D
    #declare farge_PC_7553_C = rgb <0.352941176470588, 0.270588235294118, 0.133333333333333>; // HEX #5A4522
    #declare farge_PC_7554_C = rgb <0.294117647058824, 0.23921568627451, 0.164705882352941>; // HEX #4B3D2A
    #declare farge_PC_7555_C = rgb <0.823529411764706, 0.623529411764706, 0.0745098039215686>; // HEX #D29F13
    #declare farge_PC_7556_C = rgb <0.717647058823529, 0.545098039215686, 0.125490196078431>; // HEX #B78B20
    #declare farge_PC_7557_C = rgb <0.623529411764706, 0.490196078431373, 0.137254901960784>; // HEX #9F7D23
    #declare farge_PC_7558_C = rgb <0.588235294117647, 0.443137254901961, 0.149019607843137>; // HEX #967126
    #declare farge_PC_7559_C = rgb <0.56078431372549, 0.415686274509804, 0.164705882352941>; // HEX #8F6A2A
    #declare farge_PC_7560_C = rgb <0.490196078431373, 0.384313725490196, 0.180392156862745>; // HEX #7D622E
    #declare farge_PC_7561_C = rgb <0.423529411764706, 0.364705882352941, 0.203921568627451>; // HEX #6C5D34
    #declare farge_PC_7562_C = rgb <0.741176470588235, 0.607843137254902, 0.376470588235294>; // HEX #BD9B60
    #declare farge_PC_7563_C = rgb <0.83921568627451, 0.603921568627451, 0.176470588235294>; // HEX #D69A2D
    #declare farge_PC_7564_C = rgb <0.858823529411765, 0.541176470588235, 0.0235294117647059>; // HEX #DB8A06
    #declare farge_PC_7565_C = rgb <0.803921568627451, 0.474509803921569, 0.145098039215686>; // HEX #CD7925
    #declare farge_PC_7566_C = rgb <0.67843137254902, 0.392156862745098, 0.2>; // HEX #AD6433
    #declare farge_PC_7567_C = rgb <0.537254901960784, 0.325490196078431, 0.184313725490196>; // HEX #89532F
    #declare farge_PC_7568_C = rgb <0.466666666666667, 0.317647058823529, 0.207843137254902>; // HEX #775135
    #declare farge_PC_7569_C = rgb <0.843137254901961, 0.533333333333333, 0.145098039215686>; // HEX #D78825
    #declare farge_PC_7570_C = rgb <0.827450980392157, 0.513725490196078, 0.168627450980392>; // HEX #D3832B
    #declare farge_PC_7571_C = rgb <0.776470588235294, 0.490196078431373, 0.188235294117647>; // HEX #C67D30
    #declare farge_PC_7572_C = rgb <0.713725490196078, 0.447058823529412, 0.2>; // HEX #B67233
    #declare farge_PC_7573_C = rgb <0.654901960784314, 0.4, 0.168627450980392>; // HEX #A7662B
    #declare farge_PC_7574_C = rgb <0.619607843137255, 0.415686274509804, 0.219607843137255>; // HEX #9E6A38
    #declare farge_PC_7575_C = rgb <0.513725490196078, 0.364705882352941, 0.196078431372549>; // HEX #835D32
    #declare farge_PC_7576_C = rgb <0.858823529411765, 0.525490196078431, 0.305882352941176>; // HEX #DB864E
    #declare farge_PC_7577_C = rgb <0.87843137254902, 0.494117647058824, 0.235294117647059>; // HEX #E07E3C
    #declare farge_PC_7578_C = rgb <0.862745098039216, 0.419607843137255, 0.184313725490196>; // HEX #DC6B2F
    #declare farge_PC_7579_C = rgb <0.862745098039216, 0.345098039215686, 0.164705882352941>; // HEX #DC582A
    #declare farge_PC_7580_C = rgb <0.752941176470588, 0.317647058823529, 0.192156862745098>; // HEX #C05131
    #declare farge_PC_7581_C = rgb <0.525490196078431, 0.290196078431373, 0.2>; // HEX #864A33
    #declare farge_PC_7582_C = rgb <0.403921568627451, 0.27843137254902, 0.211764705882353>; // HEX #674736
    #declare farge_PC_7583_C = rgb <0.768627450980392, 0.384313725490196, 0.176470588235294>; // HEX #C4622D
    #declare farge_PC_7584_C = rgb <0.729411764705882, 0.345098039215686, 0.149019607843137>; // HEX #BA5826
    #declare farge_PC_7585_C = rgb <0.686274509803922, 0.36078431372549, 0.215686274509804>; // HEX #AF5C37
    #declare farge_PC_7586_C = rgb <0.619607843137255, 0.325490196078431, 0.188235294117647>; // HEX #9E5330
    #declare farge_PC_7587_C = rgb <0.572549019607843, 0.298039215686275, 0.180392156862745>; // HEX #924C2E
    #declare farge_PC_7588_C = rgb <0.482352941176471, 0.301960784313725, 0.207843137254902>; // HEX #7B4D35
    #declare farge_PC_7589_C = rgb <0.36078431372549, 0.27843137254902, 0.219607843137255>; // HEX #5C4738
    #declare farge_PC_7590_C = rgb <0.831372549019608, 0.709803921568627, 0.619607843137255>; // HEX #D4B59E
    #declare farge_PC_7591_C = rgb <0.752941176470588, 0.490196078431373, 0.349019607843137>; // HEX #C07D59
    #declare farge_PC_7592_C = rgb <0.694117647058824, 0.333333333333333, 0.2>; // HEX #B15533
    #declare farge_PC_7593_C = rgb <0.615686274509804, 0.262745098039216, 0.172549019607843>; // HEX #9D432C
    #declare farge_PC_7594_C = rgb <0.486274509803922, 0.227450980392157, 0.176470588235294>; // HEX #7C3A2D
    #declare farge_PC_7595_C = rgb <0.419607843137255, 0.23921568627451, 0.180392156862745>; // HEX #6B3D2E
    #declare farge_PC_7596_C = rgb <0.36078431372549, 0.23921568627451, 0.192156862745098>; // HEX #5C3D31
    #declare farge_PC_7597_C = rgb <0.819607843137255, 0.254901960784314, 0.141176470588235>; // HEX #D14124
    #declare farge_PC_7598_C = rgb <0.741176470588235, 0.27843137254902, 0.164705882352941>; // HEX #BD472A
    #declare farge_PC_7599_C = rgb <0.701960784313725, 0.23921568627451, 0.149019607843137>; // HEX #B33D26
    #declare farge_PC_7600_C = rgb <0.552941176470588, 0.247058823529412, 0.168627450980392>; // HEX #8D3F2B
    #declare farge_PC_7601_C = rgb <0.513725490196078, 0.254901960784314, 0.172549019607843>; // HEX #83412C
    #declare farge_PC_7602_C = rgb <0.482352941176471, 0.286274509803922, 0.192156862745098>; // HEX #7B4931
    #declare farge_PC_7603_C = rgb <0.403921568627451, 0.258823529411765, 0.188235294117647>; // HEX #674230
    #declare farge_PC_7604_C = rgb <0.894117647058824, 0.835294117647059, 0.827450980392157>; // HEX #E4D5D3
    #declare farge_PC_7605_C = rgb <0.882352941176471, 0.733333333333333, 0.705882352941177>; // HEX #E1BBB4
    #declare farge_PC_7606_C = rgb <0.83921568627451, 0.576470588235294, 0.541176470588235>; // HEX #D6938A
    #declare farge_PC_7607_C = rgb <0.76078431372549, 0.431372549019608, 0.376470588235294>; // HEX #C26E60
    #declare farge_PC_7608_C = rgb <0.643137254901961, 0.286274509803922, 0.23921568627451>; // HEX #A4493D
    #declare farge_PC_7609_C = rgb <0.509803921568627, 0.231372549019608, 0.203921568627451>; // HEX #823B34
    #declare farge_PC_7610_C = rgb <0.407843137254902, 0.203921568627451, 0.192156862745098>; // HEX #683431
    #declare farge_PC_7611_C = rgb <0.866666666666667, 0.737254901960784, 0.690196078431373>; // HEX #DDBCB0
    #declare farge_PC_7612_C = rgb <0.792156862745098, 0.603921568627451, 0.556862745098039>; // HEX #CA9A8E
    #declare farge_PC_7613_C = rgb <0.737254901960784, 0.541176470588235, 0.494117647058824>; // HEX #BC8A7E
    #declare farge_PC_7614_C = rgb <0.63921568627451, 0.498039215686275, 0.454901960784314>; // HEX #A37F74
    #declare farge_PC_7615_C = rgb <0.525490196078431, 0.403921568627451, 0.380392156862745>; // HEX #866761
    #declare farge_PC_7616_C = rgb <0.419607843137255, 0.298039215686275, 0.298039215686275>; // HEX #6B4C4C
    #declare farge_PC_7617_C = rgb <0.345098039215686, 0.23921568627451, 0.243137254901961>; // HEX #583D3E
    #declare farge_PC_7618_C = rgb <0.776470588235294, 0.431372549019608, 0.305882352941176>; // HEX #C66E4E
    #declare farge_PC_7619_C = rgb <0.752941176470588, 0.298039215686275, 0.211764705882353>; // HEX #C04C36
    #declare farge_PC_7620_C = rgb <0.717647058823529, 0.192156862745098, 0.172549019607843>; // HEX #B7312C
    #declare farge_PC_7621_C = rgb <0.670588235294118, 0.137254901960784, 0.156862745098039>; // HEX #AB2328
    #declare farge_PC_7622_C = rgb <0.576470588235294, 0.152941176470588, 0.172549019607843>; // HEX #93272C
    #declare farge_PC_7623_C = rgb <0.541176470588235, 0.164705882352941, 0.168627450980392>; // HEX #8A2A2B
    #declare farge_PC_7624_C = rgb <0.501960784313725, 0.184313725490196, 0.176470588235294>; // HEX #802F2D
    #declare farge_PC_7625_C = rgb <0.882352941176471, 0.32156862745098, 0.23921568627451>; // HEX #E1523D
    #declare farge_PC_7626_C = rgb <0.776470588235294, 0.207843137254902, 0.152941176470588>; // HEX #C63527
    #declare farge_PC_7627_C = rgb <0.654901960784314, 0.168627450980392, 0.164705882352941>; // HEX #A72B2A
    #declare farge_PC_7628_C = rgb <0.619607843137255, 0.164705882352941, 0.168627450980392>; // HEX #9E2A2B
    #declare farge_PC_7629_C = rgb <0.427450980392157, 0.2, 0.196078431372549>; // HEX #6D3332
    #declare farge_PC_7630_C = rgb <0.388235294117647, 0.196078431372549, 0.192156862745098>; // HEX #633231
    #declare farge_PC_7631_C = rgb <0.341176470588235, 0.176470588235294, 0.176470588235294>; // HEX #572D2D
    #declare farge_PC_7632_C = rgb <0.83921568627451, 0.788235294117647, 0.792156862745098>; // HEX #D6C9CA
    #declare farge_PC_7633_C = rgb <0.768627450980392, 0.643137254901961, 0.654901960784314>; // HEX #C4A4A7
    #declare farge_PC_7634_C = rgb <0.756862745098039, 0.403921568627451, 0.517647058823529>; // HEX #C16784
    #declare farge_PC_7635_C = rgb <0.776470588235294, 0.211764705882353, 0.388235294117647>; // HEX #C63663
    #declare farge_PC_7636_C = rgb <0.737254901960784, 0.125490196078431, 0.294117647058824>; // HEX #BC204B
    #declare farge_PC_7637_C = rgb <0.568627450980392, 0.184313725490196, 0.274509803921569>; // HEX #912F46
    #declare farge_PC_7638_C = rgb <0.494117647058824, 0.176470588235294, 0.250980392156863>; // HEX #7E2D40
    #declare farge_PC_7639_C = rgb <0.576470588235294, 0.427450980392157, 0.450980392156863>; // HEX #936D73
    #declare farge_PC_7640_C = rgb <0.576470588235294, 0.250980392156863, 0.329411764705882>; // HEX #934054
    #declare farge_PC_7641_C = rgb <0.556862745098039, 0.172549019607843, 0.282352941176471>; // HEX #8E2C48
    #declare farge_PC_7642_C = rgb <0.450980392156863, 0.180392156862745, 0.290196078431373>; // HEX #732E4A
    #declare farge_PC_7643_C = rgb <0.403921568627451, 0.180392156862745, 0.270588235294118>; // HEX #672E45
    #declare farge_PC_7644_C = rgb <0.345098039215686, 0.176470588235294, 0.250980392156863>; // HEX #582D40
    #declare farge_PC_7645_C = rgb <0.313725490196078, 0.168627450980392, 0.227450980392157>; // HEX #502B3A
    #declare farge_PC_7646_C = rgb <0.647058823529412, 0.431372549019608, 0.529411764705882>; // HEX #A56E87
    #declare farge_PC_7647_C = rgb <0.658823529411765, 0.23921568627451, 0.447058823529412>; // HEX #A83D72
    #declare farge_PC_7648_C = rgb <0.6, 0.117647058823529, 0.4>; // HEX #991E66
    #declare farge_PC_7649_C = rgb <0.541176470588235, 0.105882352941176, 0.380392156862745>; // HEX #8A1B61
    #declare farge_PC_7650_C = rgb <0.447058823529412, 0.133333333333333, 0.341176470588235>; // HEX #722257
    #declare farge_PC_7651_C = rgb <0.415686274509804, 0.164705882352941, 0.356862745098039>; // HEX #6A2A5B
    #declare farge_PC_7652_C = rgb <0.368627450980392, 0.152941176470588, 0.317647058823529>; // HEX #5E2751
    #declare farge_PC_7653_C = rgb <0.580392156862745, 0.529411764705882, 0.580392156862745>; // HEX #948794
    #declare farge_PC_7654_C = rgb <0.635294117647059, 0.470588235294118, 0.611764705882353>; // HEX #A2789C
    #declare farge_PC_7655_C = rgb <0.631372549019608, 0.352941176470588, 0.584313725490196>; // HEX #A15A95
    #declare farge_PC_7656_C = rgb <0.556862745098039, 0.227450980392157, 0.501960784313725>; // HEX #8E3A80
    #declare farge_PC_7657_C = rgb <0.431372549019608, 0.168627450980392, 0.384313725490196>; // HEX #6E2B62
    #declare farge_PC_7658_C = rgb <0.415686274509804, 0.203921568627451, 0.376470588235294>; // HEX #6A3460
    #declare farge_PC_7659_C = rgb <0.364705882352941, 0.215686274509804, 0.329411764705882>; // HEX #5D3754
    #declare farge_PC_7660_C = rgb <0.6, 0.568627450980392, 0.643137254901961>; // HEX #9991A4
    #declare farge_PC_7661_C = rgb <0.552941176470588, 0.431372549019608, 0.592156862745098>; // HEX #8D6E97
    #declare farge_PC_7662_C = rgb <0.47843137254902, 0.254901960784314, 0.513725490196078>; // HEX #7A4183
    #declare farge_PC_7663_C = rgb <0.419607843137255, 0.188235294117647, 0.466666666666667>; // HEX #6B3077
    #declare farge_PC_7664_C = rgb <0.396078431372549, 0.196078431372549, 0.474509803921569>; // HEX #653279
    #declare farge_PC_7665_C = rgb <0.368627450980392, 0.211764705882353, 0.431372549019608>; // HEX #5E366E
    #declare farge_PC_7666_C = rgb <0.36078431372549, 0.305882352941176, 0.388235294117647>; // HEX #5C4E63
    #declare farge_PC_7667_C = rgb <0.431372549019608, 0.486274509803922, 0.627450980392157>; // HEX #6E7CA0
    #declare farge_PC_7668_C = rgb <0.407843137254902, 0.431372549019608, 0.623529411764706>; // HEX #686E9F
    #declare farge_PC_7669_C = rgb <0.380392156862745, 0.368627450980392, 0.607843137254902>; // HEX #615E9B
    #declare farge_PC_7670_C = rgb <0.337254901960784, 0.32156862745098, 0.580392156862745>; // HEX #565294
    #declare farge_PC_7671_C = rgb <0.317647058823529, 0.274509803921569, 0.537254901960784>; // HEX #514689
    #declare farge_PC_7672_C = rgb <0.298039215686275, 0.254901960784314, 0.517647058823529>; // HEX #4C4184
    #declare farge_PC_7673_C = rgb <0.325490196078431, 0.329411764705882, 0.525490196078431>; // HEX #535486
    #declare farge_PC_7674_C = rgb <0.529411764705882, 0.549019607843137, 0.705882352941177>; // HEX #878CB4
    #declare farge_PC_7675_C = rgb <0.486274509803922, 0.498039215686275, 0.670588235294118>; // HEX #7C7FAB
    #declare farge_PC_7676_C = rgb <0.458823529411765, 0.4, 0.627450980392157>; // HEX #7566A0
    #declare farge_PC_7677_C = rgb <0.435294117647059, 0.313725490196078, 0.568627450980392>; // HEX #6F5091
    #declare farge_PC_7678_C = rgb <0.407843137254902, 0.27843137254902, 0.552941176470588>; // HEX #68478D
    #declare farge_PC_7679_C = rgb <0.337254901960784, 0.23921568627451, 0.509803921568627>; // HEX #563D82
    #declare farge_PC_7680_C = rgb <0.32156862745098, 0.192156862745098, 0.470588235294118>; // HEX #523178
    #declare farge_PC_7681_C = rgb <0.580392156862745, 0.662745098039216, 0.796078431372549>; // HEX #94A9CB
    #declare farge_PC_7682_C = rgb <0.403921568627451, 0.529411764705882, 0.717647058823529>; // HEX #6787B7
    #declare farge_PC_7683_C = rgb <0.258823529411765, 0.427450980392157, 0.662745098039216>; // HEX #426DA9
    #declare farge_PC_7684_C = rgb <0.219607843137255, 0.368627450980392, 0.615686274509804>; // HEX #385E9D
    #declare farge_PC_7685_C = rgb <0.172549019607843, 0.337254901960784, 0.592156862745098>; // HEX #2C5697
    #declare farge_PC_7686_C = rgb <0.113725490196078, 0.309803921568627, 0.568627450980392>; // HEX #1D4F91
    #declare farge_PC_7687_C = rgb <0.113725490196078, 0.258823529411765, 0.541176470588235>; // HEX #1D428A
    #declare farge_PC_7688_C = rgb <0.274509803921569, 0.596078431372549, 0.796078431372549>; // HEX #4698CB
    #declare farge_PC_7689_C = rgb <0.16078431372549, 0.56078431372549, 0.76078431372549>; // HEX #298FC2
    #declare farge_PC_7690_C = rgb <0, 0.462745098039216, 0.658823529411765>; // HEX #0076A8
    #declare farge_PC_7691_C = rgb <0, 0.384313725490196, 0.596078431372549>; // HEX #006298
    #declare farge_PC_7692_C = rgb <0, 0.333333333333333, 0.529411764705882>; // HEX #005587
    #declare farge_PC_7693_C = rgb <0, 0.286274509803922, 0.462745098039216>; // HEX #004976
    #declare farge_PC_7694_C = rgb <0.00392156862745098, 0.258823529411765, 0.415686274509804>; // HEX #01426A
    #declare farge_PC_7695_C = rgb <0.482352941176471, 0.654901960784314, 0.737254901960784>; // HEX #7BA7BC
    #declare farge_PC_7696_C = rgb <0.388235294117647, 0.6, 0.682352941176471>; // HEX #6399AE
    #declare farge_PC_7697_C = rgb <0.305882352941176, 0.529411764705882, 0.627450980392157>; // HEX #4E87A0
    #declare farge_PC_7698_C = rgb <0.254901960784314, 0.454901960784314, 0.552941176470588>; // HEX #41748D
    #declare farge_PC_7699_C = rgb <0.203921568627451, 0.396078431372549, 0.498039215686275>; // HEX #34657F
    #declare farge_PC_7700_C = rgb <0.0862745098039216, 0.36078431372549, 0.490196078431373>; // HEX #165C7D
    #declare farge_PC_7701_C = rgb <0, 0.341176470588235, 0.462745098039216>; // HEX #005776
    #declare farge_PC_7702_C = rgb <0.282352941176471, 0.662745098039216, 0.772549019607843>; // HEX #48A9C5
    #declare farge_PC_7703_C = rgb <0, 0.611764705882353, 0.741176470588235>; // HEX #009CBD
    #declare farge_PC_7704_C = rgb <0, 0.52156862745098, 0.67843137254902>; // HEX #0085AD
    #declare farge_PC_7705_C = rgb <0, 0.43921568627451, 0.588235294117647>; // HEX #007096
    #declare farge_PC_7706_C = rgb <0, 0.415686274509804, 0.556862745098039>; // HEX #006A8E
    #declare farge_PC_7707_C = rgb <0, 0.380392156862745, 0.498039215686275>; // HEX #00617F
    #declare farge_PC_7708_C = rgb <0, 0.337254901960784, 0.43921568627451>; // HEX #005670
    #declare farge_PC_7709_C = rgb <0.388235294117647, 0.694117647058824, 0.737254901960784>; // HEX #63B1BC
    #declare farge_PC_7710_C = rgb <0, 0.654901960784314, 0.709803921568627>; // HEX #00A7B5
    #declare farge_PC_7711_C = rgb <0, 0.592156862745098, 0.662745098039216>; // HEX #0097A9
    #declare farge_PC_7712_C = rgb <0, 0.52156862745098, 0.607843137254902>; // HEX #00859B
    #declare farge_PC_7713_C = rgb <0, 0.490196078431373, 0.541176470588235>; // HEX #007D8A
    #declare farge_PC_7714_C = rgb <0, 0.462745098039216, 0.501960784313725>; // HEX #007680
    #declare farge_PC_7715_C = rgb <0, 0.384313725490196, 0.411764705882353>; // HEX #006269
    #declare farge_PC_7716_C = rgb <0, 0.588235294117647, 0.56078431372549>; // HEX #00968F
    #declare farge_PC_7717_C = rgb <0, 0.52156862745098, 0.490196078431373>; // HEX #00857D
    #declare farge_PC_7718_C = rgb <0, 0.462745098039216, 0.447058823529412>; // HEX #007672
    #declare farge_PC_7719_C = rgb <0, 0.427450980392157, 0.407843137254902>; // HEX #006D68
    #declare farge_PC_7720_C = rgb <0, 0.388235294117647, 0.356862745098039>; // HEX #00635B
    #declare farge_PC_7721_C = rgb <0, 0.368627450980392, 0.364705882352941>; // HEX #005E5D
    #declare farge_PC_7722_C = rgb <0, 0.317647058823529, 0.317647058823529>; // HEX #005151
    #declare farge_PC_7723_C = rgb <0.313725490196078, 0.650980392156863, 0.517647058823529>; // HEX #50A684
    #declare farge_PC_7724_C = rgb <0, 0.588235294117647, 0.423529411764706>; // HEX #00966C
    #declare farge_PC_7725_C = rgb <0, 0.529411764705882, 0.333333333333333>; // HEX #008755
    #declare farge_PC_7726_C = rgb <0, 0.482352941176471, 0.294117647058824>; // HEX #007B4B
    #declare farge_PC_7727_C = rgb <0, 0.435294117647059, 0.266666666666667>; // HEX #006F44
    #declare farge_PC_7728_C = rgb <0, 0.407843137254902, 0.270588235294118>; // HEX #006845
    #declare farge_PC_7729_C = rgb <0, 0.345098039215686, 0.266666666666667>; // HEX #005844
    #declare farge_PC_7730_C = rgb <0.294117647058824, 0.584313725490196, 0.376470588235294>; // HEX #4B9560
    #declare farge_PC_7731_C = rgb <0.133333333333333, 0.533333333333333, 0.282352941176471>; // HEX #228848
    #declare farge_PC_7732_C = rgb <0, 0.47843137254902, 0.243137254901961>; // HEX #007A3E
    #declare farge_PC_7733_C = rgb <0, 0.43921568627451, 0.254901960784314>; // HEX #007041
    #declare farge_PC_7734_C = rgb <0.156862745098039, 0.380392156862745, 0.250980392156863>; // HEX #286140
    #declare farge_PC_7735_C = rgb <0.211764705882353, 0.341176470588235, 0.231372549019608>; // HEX #36573B
    #declare farge_PC_7736_C = rgb <0.223529411764706, 0.333333333333333, 0.258823529411765>; // HEX #395542
    #declare farge_PC_7737_C = rgb <0.419607843137255, 0.647058823529412, 0.223529411764706>; // HEX #6BA539
    #declare farge_PC_7738_C = rgb <0.282352941176471, 0.635294117647059, 0.247058823529412>; // HEX #48A23F
    #declare farge_PC_7739_C = rgb <0.192156862745098, 0.607843137254902, 0.258823529411765>; // HEX #319B42
    #declare farge_PC_7740_C = rgb <0.227450980392157, 0.568627450980392, 0.247058823529412>; // HEX #3A913F
    #declare farge_PC_7741_C = rgb <0.266666666666667, 0.533333333333333, 0.243137254901961>; // HEX #44883E
    #declare farge_PC_7742_C = rgb <0.290196078431373, 0.466666666666667, 0.235294117647059>; // HEX #4A773C
    #declare farge_PC_7743_C = rgb <0.266666666666667, 0.411764705882353, 0.23921568627451>; // HEX #44693D
    #declare farge_PC_7744_C = rgb <0.729411764705882, 0.737254901960784, 0.0862745098039216>; // HEX #BABC16
    #declare farge_PC_7745_C = rgb <0.670588235294118, 0.67843137254902, 0.137254901960784>; // HEX #ABAD23
    #declare farge_PC_7746_C = rgb <0.6, 0.607843137254902, 0.188235294117647>; // HEX #999B30
    #declare farge_PC_7747_C = rgb <0.533333333333333, 0.552941176470588, 0.188235294117647>; // HEX #888D30
    #declare farge_PC_7748_C = rgb <0.486274509803922, 0.501960784313725, 0.203921568627451>; // HEX #7C8034
    #declare farge_PC_7749_C = rgb <0.447058823529412, 0.450980392156863, 0.215686274509804>; // HEX #727337
    #declare farge_PC_7750_C = rgb <0.396078431372549, 0.4, 0.207843137254902>; // HEX #656635
    #declare farge_PC_7751_C = rgb <0.792156862745098, 0.713725490196078, 0.294117647058824>; // HEX #CAB64B
    #declare farge_PC_7752_C = rgb <0.811764705882353, 0.690196078431373, 0.137254901960784>; // HEX #CFB023
    #declare farge_PC_7753_C = rgb <0.756862745098039, 0.627450980392157, 0.117647058823529>; // HEX #C1A01E
    #declare farge_PC_7754_C = rgb <0.627450980392157, 0.525490196078431, 0.16078431372549>; // HEX #A08629
    #declare farge_PC_7755_C = rgb <0.537254901960784, 0.462745098039216, 0.188235294117647>; // HEX #897630
    #declare farge_PC_7756_C = rgb <0.450980392156863, 0.4, 0.207843137254902>; // HEX #736635
    #declare farge_PC_7757_C = rgb <0.403921568627451, 0.368627450980392, 0.2>; // HEX #675E33
    #declare farge_PC_7758_C = rgb <0.831372549019608, 0.764705882352941, 0.0156862745098039>; // HEX #D4C304
    #declare farge_PC_7759_C = rgb <0.768627450980392, 0.698039215686274, 0>; // HEX #C4B200
    #declare farge_PC_7760_C = rgb <0.568627450980392, 0.52156862745098, 0.172549019607843>; // HEX #91852C
    #declare farge_PC_7761_C = rgb <0.454901960784314, 0.443137254901961, 0.211764705882353>; // HEX #747136
    #declare farge_PC_7762_C = rgb <0.364705882352941, 0.392156862745098, 0.223529411764706>; // HEX #5D6439
    #declare farge_PC_7763_C = rgb <0.345098039215686, 0.36078431372549, 0.231372549019608>; // HEX #585C3B
    #declare farge_PC_7764_C = rgb <0.325490196078431, 0.329411764705882, 0.207843137254902>; // HEX #535435
    #declare farge_PC_7765_C = rgb <0.733333333333333, 0.701960784313725, 0.137254901960784>; // HEX #BBB323
    #declare farge_PC_7766_C = rgb <0.705882352941177, 0.662745098039216, 0.12156862745098>; // HEX #B4A91F
    #declare farge_PC_7767_C = rgb <0.666666666666667, 0.615686274509804, 0.180392156862745>; // HEX #AA9D2E
    #declare farge_PC_7768_C = rgb <0.56078431372549, 0.494117647058824, 0.207843137254902>; // HEX #8F7E35
    #declare farge_PC_7769_C = rgb <0.443137254901961, 0.380392156862745, 0.207843137254902>; // HEX #716135
    #declare farge_PC_7770_C = rgb <0.388235294117647, 0.349019607843137, 0.223529411764706>; // HEX #635939
    #declare farge_PC_7771_C = rgb <0.305882352941176, 0.286274509803922, 0.203921568627451>; // HEX #4E4934
    #declare farge_PC_801_C = rgb <0, 0.603921568627451, 0.807843137254902>; // HEX #009ACE
    #declare farge_PC_802_C = rgb <0.266666666666667, 0.83921568627451, 0.172549019607843>; // HEX #44D62C
    #declare farge_PC_803_C = rgb <1, 0.913725490196078, 0>; // HEX #FFE900
    #declare farge_PC_804_C = rgb <1, 0.666666666666667, 0.301960784313725>; // HEX #FFAA4D
    #declare farge_PC_805_C = rgb <1, 0.447058823529412, 0.462745098039216>; // HEX #FF7276
    #declare farge_PC_806_C = rgb <1, 0.243137254901961, 0.709803921568627>; // HEX #FF3EB5
    #declare farge_PC_807_C = rgb <0.917647058823529, 0.152941176470588, 0.76078431372549>; // HEX #EA27C2
    #declare farge_PC_871_C = rgb <0.517647058823529, 0.458823529411765, 0.305882352941176>; // HEX #84754E
    #declare farge_PC_872_C = rgb <0.52156862745098, 0.443137254901961, 0.301960784313725>; // HEX #85714D
    #declare farge_PC_873_C = rgb <0.525490196078431, 0.427450980392157, 0.294117647058824>; // HEX #866D4B
    #declare farge_PC_874_C = rgb <0.545098039215686, 0.435294117647059, 0.305882352941176>; // HEX #8B6F4E
    #declare farge_PC_875_C = rgb <0.529411764705882, 0.403921568627451, 0.309803921568627>; // HEX #87674F
    #declare farge_PC_876_C = rgb <0.545098039215686, 0.388235294117647, 0.294117647058824>; // HEX #8B634B
    #declare farge_PC_877_C = rgb <0.541176470588235, 0.552941176470588, 0.56078431372549>; // HEX #8A8D8F
    #declare farge_PC_Black_0961_C = rgb <0.619607843137255, 0.592156862745098, 0.556862745098039>; // HEX #9E978E
    #declare farge_PC_Black_2_C = rgb <0.2, 0.184313725490196, 0.129411764705882>; // HEX #332F21
    #declare farge_PC_Black_3_C = rgb <0.129411764705882, 0.152941176470588, 0.129411764705882>; // HEX #212721
    #declare farge_PC_Black_4_C = rgb <0.192156862745098, 0.149019607843137, 0.113725490196078>; // HEX #31261D
    #declare farge_PC_Black_5_C = rgb <0.243137254901961, 0.168627450980392, 0.180392156862745>; // HEX #3E2B2E
    #declare farge_PC_Black_6_C = rgb <0.0627450980392157, 0.0941176470588235, 0.125490196078431>; // HEX #101820
    #declare farge_PC_Black_7_C = rgb <0.23921568627451, 0.223529411764706, 0.207843137254902>; // HEX #3D3935
    #declare farge_PC_Black_C = rgb <0.176470588235294, 0.16078431372549, 0.149019607843137>; // HEX #2D2926
    #declare farge_PC_Blue_072_C = rgb <0.0627450980392157, 0.0235294117647059, 0.623529411764706>; // HEX #10069F
    #declare farge_PC_Blue_0821_C = rgb <0.454901960784314, 0.819607843137255, 0.917647058823529>; // HEX #74D1EA
    #declare farge_PC_Bright_Green_C = rgb <0, 0.690196078431373, 0.545098039215686>; // HEX #00B08B
    #declare farge_PC_Bright_Orange_C = rgb <1, 0.368627450980392, 0>; // HEX #FF5E00
    #declare farge_PC_Bright_Red_C = rgb <0.976470588235294, 0.219607843137255, 0.133333333333333>; // HEX #F93822
    #declare farge_PC_Cool_Gray_1_C = rgb <0.850980392156863, 0.850980392156863, 0.83921568627451>; // HEX #D9D9D6
    #declare farge_PC_Cool_Gray_10_C = rgb <0.388235294117647, 0.4, 0.415686274509804>; // HEX #63666A
    #declare farge_PC_Cool_Gray_11_C = rgb <0.325490196078431, 0.337254901960784, 0.352941176470588>; // HEX #53565A
    #declare farge_PC_Cool_Gray_2_C = rgb <0.815686274509804, 0.815686274509804, 0.807843137254902>; // HEX #D0D0CE
    #declare farge_PC_Cool_Gray_3_C = rgb <0.784313725490196, 0.788235294117647, 0.780392156862745>; // HEX #C8C9C7
    #declare farge_PC_Cool_Gray_4_C = rgb <0.733333333333333, 0.737254901960784, 0.737254901960784>; // HEX #BBBCBC
    #declare farge_PC_Cool_Gray_5_C = rgb <0.694117647058824, 0.701960784313725, 0.701960784313725>; // HEX #B1B3B3
    #declare farge_PC_Cool_Gray_6_C = rgb <0.654901960784314, 0.658823529411765, 0.666666666666667>; // HEX #A7A8AA
    #declare farge_PC_Cool_Gray_7_C = rgb <0.592156862745098, 0.6, 0.607843137254902>; // HEX #97999B
    #declare farge_PC_Cool_Gray_8_C = rgb <0.533333333333333, 0.545098039215686, 0.552941176470588>; // HEX #888B8D
    #declare farge_PC_Cool_Gray_9_C = rgb <0.458823529411765, 0.470588235294118, 0.482352941176471>; // HEX #75787B
    #declare farge_PC_Dark_Blue_C = rgb <0, 0.137254901960784, 0.611764705882353>; // HEX #00239C
    #declare farge_PC_Green_0921_C = rgb <0.615686274509804, 0.905882352941176, 0.843137254901961>; // HEX #9DE7D7
    #declare farge_PC_Green_C = rgb <0, 0.670588235294118, 0.517647058823529>; // HEX #00AB84
    #declare farge_PC_Magenta_0521_C = rgb <0.945098039215686, 0.698039215686274, 0.862745098039216>; // HEX #F1B2DC
    #declare farge_PC_Medium_Blue_C = rgb <0, 0.517647058823529, 0.792156862745098>; // HEX #0084CA
    #declare farge_PC_Medium_Purple_C = rgb <0.305882352941176, 0, 0.556862745098039>; // HEX #4E008E
    #declare farge_PC_Medium_Yellow_C = rgb <1, 0.850980392156863, 0>; // HEX #FFD900
    #declare farge_PC_Neutral_Black_C = rgb <0.133333333333333, 0.133333333333333, 0.137254901960784>; // HEX #222223
    #declare farge_PC_Orange_021_C = rgb <0.996078431372549, 0.313725490196078, 0>; // HEX #FE5000
    #declare farge_PC_Pink_C = rgb <0.83921568627451, 0.145098039215686, 0.596078431372549>; // HEX #D62598
    #declare farge_PC_Process_Blue_C = rgb <0, 0.52156862745098, 0.792156862745098>; // HEX #0085CA
    #declare farge_PC_Purple_C = rgb <0.733333333333333, 0.16078431372549, 0.733333333333333>; // HEX #BB29BB
    #declare farge_PC_Red_032_C = rgb <0.937254901960784, 0.2, 0.250980392156863>; // HEX #EF3340
    #declare farge_PC_Red_0331_C = rgb <0.988235294117647, 0.682352941176471, 0.733333333333333>; // HEX #FCAEBB
    #declare farge_PC_Reflex_Blue_C = rgb <0, 0.0784313725490196, 0.537254901960784>; // HEX #001489
    #declare farge_PC_Rhodamine_Red_C = rgb <0.882352941176471, 0, 0.596078431372549>; // HEX #E10098
    #declare farge_PC_Rubine_Red_C = rgb <0.807843137254902, 0, 0.345098039215686>; // HEX #CE0058
    #declare farge_PC_Strong_Red_C = rgb <0.807843137254902, 0, 0.337254901960784>; // HEX #CE0056
    #declare farge_PC_Violet_0631_C = rgb <0.749019607843137, 0.607843137254902, 0.870588235294118>; // HEX #BF9BDE
    #declare farge_PC_Violet_C = rgb <0.266666666666667, 0, 0.6>; // HEX #440099
    #declare farge_PC_Warm_Gray_1_C = rgb <0.843137254901961, 0.823529411764706, 0.796078431372549>; // HEX #D7D2CB
    #declare farge_PC_Warm_Gray_10_C = rgb <0.474509803921569, 0.431372549019608, 0.396078431372549>; // HEX #796E65
    #declare farge_PC_Warm_Gray_11_C = rgb <0.431372549019608, 0.384313725490196, 0.349019607843137>; // HEX #6E6259
    #declare farge_PC_Warm_Gray_2_C = rgb <0.796078431372549, 0.768627450980392, 0.737254901960784>; // HEX #CBC4BC
    #declare farge_PC_Warm_Gray_3_C = rgb <0.749019607843137, 0.72156862745098, 0.686274509803922>; // HEX #BFB8AF
    #declare farge_PC_Warm_Gray_4_C = rgb <0.713725490196078, 0.67843137254902, 0.647058823529412>; // HEX #B6ADA5
    #declare farge_PC_Warm_Gray_5_C = rgb <0.674509803921569, 0.63921568627451, 0.603921568627451>; // HEX #ACA39A
    #declare farge_PC_Warm_Gray_6_C = rgb <0.647058823529412, 0.611764705882353, 0.580392156862745>; // HEX #A59C94
    #declare farge_PC_Warm_Gray_7_C = rgb <0.588235294117647, 0.549019607843137, 0.513725490196078>; // HEX #968C83
    #declare farge_PC_Warm_Gray_8_C = rgb <0.549019607843137, 0.509803921568627, 0.474509803921569>; // HEX #8C8279
    #declare farge_PC_Warm_Gray_9_C = rgb <0.513725490196078, 0.470588235294118, 0.435294117647059>; // HEX #83786F
    #declare farge_PC_Warm_Red_C = rgb <0.976470588235294, 0.258823529411765, 0.227450980392157>; // HEX #F9423A
    #declare farge_PC_Yellow_012_C = rgb <1, 0.843137254901961, 0>; // HEX #FFD700
    #declare farge_PC_Yellow_0131_C = rgb <0.949019607843137, 0.941176470588235, 0.631372549019608>; // HEX #F2F0A1
    #declare farge_PC_Yellow_C = rgb <0.996078431372549, 0.866666666666667, 0>; // HEX #FEDD00

    // P... Color of the Year
    // https://en.wikipedia.org/wiki/Pantone#Color_of_the_Year
    //
    #declare farge_PC_CotY_2000_Cerulean = rgb <0.607843137254902, 0.717647058823529, 0.831372549019608>; // HEX #9BB7D4
    #declare farge_PC_CotY_2001_Fuchsia_Rose = rgb <0.780392156862745, 0.262745098039216, 0.458823529411765>; // HEX #C74375
    #declare farge_PC_CotY_2002_True_Red = rgb <0.749019607843137, 0.0980392156862745, 0.196078431372549>; // HEX #BF1932
    #declare farge_PC_CotY_2003_Aqua_Sky = rgb <0.482352941176471, 0.768627450980392, 0.768627450980392>; // HEX #7BC4C4
    #declare farge_PC_CotY_2004_Tigerlily = rgb <0.886274509803922, 0.345098039215686, 0.243137254901961>; // HEX #E2583E
    #declare farge_PC_CotY_2005_Blue_Turquoise = rgb <0.325490196078431, 0.690196078431373, 0.682352941176471>; // HEX #53B0AE
    #declare farge_PC_CotY_2006_Sand_Dollar = rgb <0.870588235294118, 0.803921568627451, 0.745098039215686>; // HEX #DECDBE
    #declare farge_PC_CotY_2007_Chili_Pepper = rgb <0.607843137254902, 0.105882352941176, 0.188235294117647>; // HEX #9B1B30
    #declare farge_PC_CotY_2008_Blue_Iris = rgb <0.352941176470588, 0.356862745098039, 0.623529411764706>; // HEX #5A5B9F
    #declare farge_PC_CotY_2009_Mimosa = rgb <0.941176470588235, 0.752941176470588, 0.352941176470588>; // HEX #F0C05A
    #declare farge_PC_CotY_2010_Turquoise = rgb <0.270588235294118, 0.709803921568627, 0.666666666666667>; // HEX #45B5AA
    #declare farge_PC_CotY_2011_Honeysuckle = rgb <0.850980392156863, 0.309803921568627, 0.43921568627451>; // HEX #D94F70
    #declare farge_PC_CotY_2012_Tangerine_Tango = rgb <0.866666666666667, 0.254901960784314, 0.141176470588235>; // HEX #DD4124
    #declare farge_PC_CotY_2013_Emerald = rgb <0, 0.580392156862745, 0.450980392156863>; // HEX #009473
    #declare farge_PC_CotY_2014_Radiant_Orchid = rgb <0.694117647058824, 0.388235294117647, 0.63921568627451>; // HEX #B163A3
    #declare farge_PC_CotY_2015_Marsala = rgb <0.584313725490196, 0.32156862745098, 0.317647058823529>; // HEX #955251
    #declare farge_PC_CotY_2016_Rose_Quartz = rgb <0.968627450980392, 0.792156862745098, 0.788235294117647>; // HEX #F7CAC9
    #declare farge_PC_CotY_2016_Serenity = rgb <0.572549019607843, 0.658823529411765, 0.819607843137255>; // HEX #92A8D1
    #declare farge_PC_CotY_2017_Greenery = rgb <0.533333333333333, 0.690196078431373, 0.294117647058824>; // HEX #88B04B
    #declare farge_PC_CotY_2018_Ultra_Violet = rgb <0.372549019607843, 0.294117647058824, 0.545098039215686>; // HEX #5F4B8B
    #declare farge_PC_CotY_2019_Living_Coral = rgb <1, 0.435294117647059, 0.380392156862745>; // HEX #FF6F61
    #declare farge_PC_CotY_2020_Classic_Blue = rgb <0.0588235294117647, 0.298039215686275, 0.505882352941176>; // HEX #0F4C81


    #version Farger_PC_Inc_Temp;
#end
