// This file is licensed under the MIT License, Copyright © 2017 David Aerne <https://github.com/meodai>
//
//    Persistence of Vision Ray Tracer Include File
//
//    File           : farger_color_names.inc
//    Version        : 1.0
//    Created by     : Sven-Erik Andersen
//    Contact        : sven.erik.andersen@gmail.com
//    Created date   : 2021-01-01
//    Last updated   : 2021-01-01
//    Description    : This is based on the
//                     "Massive list of handpicked color names 🌈 https://meodai.github.io/color-names/", release v7.30.0
//                     The csv-file from that repository have been imported into Excel.
//                     The names have been run through a VBA function that (try to) make the color names POV-Ray "safe"
//                     since there are many non-ASCII and Unicode characters used in the names, and some names starts with a number.
//                     Then the #declare-strings gets generated, and then copied and pasted into this file.
//
#ifndef(farger_color_names_Temp)
    #declare farger_color_names_Temp = version;
    #version 3.7;

#declare CN_100_Mph = rgb <201/255, 63/255, 56/255>;
#declare CN_18th_Century_Green = rgb <165/255, 147/255, 68/255>;
#declare CN_1975_Earth_Red = rgb <123/255, 70/255, 59/255>;
#declare CN_1989_Miami_Hotline = rgb <221/255, 51/255, 102/255>;
#declare CN_20000_Leagues_Under_the_Sea = rgb <25/255, 25/255, 112/255>;
#declare CN_24_Karat = rgb <171/255, 127/255, 70/255>;
#declare CN_3AM_in_Shibuya = rgb <34/255, 85/255, 119/255>;
#declare CN_3am_Latte = rgb <192/255, 169/255, 142/255>;
#declare CN_400XT_Film = rgb <210/255, 210/255, 192/255>;
#declare CN_5_Masted_Preusen = rgb <155/255, 175/255, 173/255>;
#declare CN_8_Bit_Eggplant = rgb <153/255, 0/255, 102/255>;
#declare CN_90_Cocoa = rgb <61/255, 28/255, 2/255>;
#declare CN_A_Brand_New_Day = rgb <255/255, 170/255, 187/255>;
#declare CN_A_Certain_Shade_Of_Green = rgb <209/255, 237/255, 238/255>;
#declare CN_A_Dime_a_Dozen = rgb <211/255, 221/255, 228/255>;
#declare CN_A_Hint_of_Incremental_Blue = rgb <69/255, 103/255, 137/255>;
#declare CN_A_La_Mode = rgb <246/255, 236/255, 222/255>;
#declare CN_A_Lot_of_Love = rgb <255/255, 188/255, 197/255>;
#declare CN_A_Pair_of_Brown_Eyes = rgb <191/255, 175/255, 146/255>;
#declare CN_A_Smell_of_Bakery = rgb <243/255, 233/255, 217/255>;
#declare CN_A_State_of_Mint = rgb <136/255, 255/255, 204/255>;
#declare CN_Aare_River = rgb <0/255, 184/255, 159/255>;
#declare CN_Aare_River_Brienz = rgb <5/255, 163/255, 173/255>;
#declare CN_Aarhusian_Sky = rgb <17/255, 80/255, 175/255>;
#declare CN_Abaddon_Black = rgb <35/255, 31/255, 32/255>;
#declare CN_Abaidh_White = rgb <242/255, 241/255, 230/255>;
#declare CN_Abalone = rgb <248/255, 243/255, 246/255>;
#declare CN_Abalone_Shell = rgb <225/255, 222/255, 217/255>;
#declare CN_Abandoned_Mansion = rgb <148/255, 135/255, 126/255>;
#declare CN_Abbey = rgb <76/255, 79/255, 86/255>;
#declare CN_Abbey_Road = rgb <167/255, 159/255, 146/255>;
#declare CN_Abbey_Stone = rgb <171/255, 167/255, 152/255>;
#declare CN_Abbey_White = rgb <236/255, 230/255, 208/255>;
#declare CN_Abbot = rgb <77/255, 60/255, 45/255>;
#declare CN_Abduction = rgb <22/255, 100/255, 97/255>;
#declare CN_Abi_Blue = rgb <91/255, 168/255, 255/255>;
#declare CN_Abilene_Lace = rgb <234/255, 227/255, 210/255>;
#declare CN_Ablaze = rgb <192/255, 70/255, 65/255>;
#declare CN_Abomination = rgb <119/255, 170/255, 119/255>;
#declare CN_Abra_Cadabra = rgb <150/255, 97/255, 101/255>;
#declare CN_Abra_Goldenrod = rgb <238/255, 196/255, 0/255>;
#declare CN_Absence_of_Light = rgb <21/255, 21/255, 28/255>;
#declare CN_Absinthe_Green = rgb <118/255, 181/255, 131/255>;
#declare CN_Absinthe_Turquoise = rgb <0/255, 138/255, 96/255>;
#declare CN_Absolute_Apricot = rgb <255/255, 153/255, 68/255>;
#declare CN_Absolute_Zero = rgb <0/255, 72/255, 186/255>;
#declare CN_Abstract = rgb <228/255, 203/255, 151/255>;
#declare CN_Abstract_White = rgb <237/255, 233/255, 221/255>;
#declare CN_Abundance = rgb <98/255, 151/255, 99/255>;
#declare CN_Abura_Green = rgb <161/255, 147/255, 97/255>;
#declare CN_Abyss = rgb <143/255, 158/255, 157/255>;
#declare CN_Abyssal_Anchorfish_Blue = rgb <27/255, 38/255, 50/255>;
#declare CN_Abyssal_Blue = rgb <0/255, 3/255, 91/255>;
#declare CN_Abyssal_Depths = rgb <16/255, 36/255, 106/255>;
#declare CN_Abyssal_Waters = rgb <0/255, 87/255, 101/255>;
#declare CN_Abysse = rgb <61/255, 87/255, 88/255>;
#declare CN_Abyssopelagic_Water = rgb <0/255, 0/255, 51/255>;
#declare CN_Acacia = rgb <218/255, 205/255, 101/255>;
#declare CN_Acacia_Green = rgb <72/255, 98/255, 65/255>;
#declare CN_Acacia_Haze = rgb <150/255, 156/255, 146/255>;
#declare CN_Academic_Blue = rgb <44/255, 62/255, 86/255>;
#declare CN_Academy_Purple = rgb <82/255, 83/255, 103/255>;
#declare CN_Acadia = rgb <53/255, 49/255, 44/255>;
#declare CN_Acadia_Bloom = rgb <229/255, 183/255, 190/255>;
#declare CN_Acai = rgb <70/255, 41/255, 90/255>;
#declare CN_Acai_Berry = rgb <66/255, 49/255, 75/255>;
#declare CN_Acai_Juice = rgb <148/255, 33/255, 147/255>;
#declare CN_Acajou = rgb <76/255, 47/255, 39/255>;
#declare CN_Acanthus = rgb <152/255, 153/255, 167/255>;
#declare CN_Acanthus_Leaf = rgb <144/255, 151/255, 122/255>;
#declare CN_Acapulco = rgb <117/255, 170/255, 148/255>;
#declare CN_Acapulco_Cliffs = rgb <78/255, 154/255, 168/255>;
#declare CN_Acapulco_Dive = rgb <101/255, 167/255, 221/255>;
#declare CN_Acapulco_Sun = rgb <235/255, 138/255, 68/255>;
#declare CN_Accent_Green_Blue = rgb <32/255, 132/255, 104/255>;
#declare CN_Accent_Orange = rgb <229/255, 109/255, 0/255>;
#declare CN_Accessible_Beige = rgb <210/255, 199/255, 183/255>;
#declare CN_Accolade = rgb <124/255, 148/255, 178/255>;
#declare CN_Accursed_Black = rgb <9/255, 8/255, 7/255>;
#declare CN_Ace = rgb <199/255, 204/255, 231/255>;
#declare CN_Aceituna_Picante = rgb <114/255, 122/255, 95/255>;
#declare CN_Aceto_Balsamico = rgb <78/255, 79/255, 72/255>;
#declare CN_Acid = rgb <0/255, 255/255, 34/255>;
#declare CN_Acid_Blond = rgb <239/255, 237/255, 215/255>;
#declare CN_Acid_Candy = rgb <168/255, 199/255, 77/255>;
#declare CN_Acid_Drop = rgb <17/255, 255/255, 34/255>;
#declare CN_Acid_Green = rgb <143/255, 254/255, 9/255>;
#declare CN_Acid_Lime = rgb <186/255, 223/255, 48/255>;
#declare CN_Acid_Pool = rgb <0/255, 238/255, 34/255>;
#declare CN_Acid_Pops = rgb <51/255, 238/255, 102/255>;
#declare CN_Acid_Sleazebag = rgb <79/255, 193/255, 114/255>;
#declare CN_Acier = rgb <158/255, 153/255, 145/255>;
#declare CN_Acini_di_Pepe = rgb <255/255, 216/255, 177/255>;
#declare CN_Acorn = rgb <126/255, 94/255, 82/255>;
#declare CN_Acorn_Spice = rgb <184/255, 116/255, 57/255>;
#declare CN_Acorn_Squash = rgb <237/255, 167/255, 64/255>;
#declare CN_Acoustic_White = rgb <239/255, 236/255, 225/255>;
#declare CN_Across_the_Bay = rgb <179/255, 225/255, 232/255>;
#declare CN_Actinic_Light = rgb <255/255, 68/255, 238/255>;
#declare CN_Action_Green = rgb <0/255, 80/255, 75/255>;
#declare CN_Active_Green = rgb <0/255, 166/255, 126/255>;
#declare CN_Active_Turquoise = rgb <0/255, 111/255, 114/255>;
#declare CN_Active_Volcano = rgb <187/255, 17/255, 51/255>;
#declare CN_Actors_Star = rgb <167/255, 166/255, 163/255>;
#declare CN_Adamite_Green = rgb <59/255, 132/255, 94/255>;
#declare CN_Adana_Kebabi = rgb <102/255, 17/255, 17/255>;
#declare CN_Adaptive_Shade = rgb <134/255, 126/255, 112/255>;
#declare CN_Addo_Skin = rgb <88/255, 93/255, 88/255>;
#declare CN_Adeline = rgb <204/255, 176/255, 181/255>;
#declare CN_Adept = rgb <41/255, 57/255, 71/255>;
#declare CN_Adeptus_Battlegrey = rgb <124/255, 130/255, 134/255>;
#declare CN_Adhesion = rgb <158/255, 156/255, 171/255>;
#declare CN_Adirondack = rgb <176/255, 185/255, 193/255>;
#declare CN_Adirondack_Blue = rgb <116/255, 133/255, 143/255>;
#declare CN_Admiral_Blue = rgb <80/255, 100/255, 127/255>;
#declare CN_Admiralty = rgb <64/255, 78/255, 97/255>;
#declare CN_Admiration = rgb <246/255, 243/255, 211/255>;
#declare CN_Adobe = rgb <189/255, 108/255, 72/255>;
#declare CN_Adobe_Avenue = rgb <251/255, 149/255, 135/255>;
#declare CN_Adobe_Beige = rgb <220/255, 191/255, 166/255>;
#declare CN_Adobe_Rose = rgb <186/255, 159/255, 153/255>;
#declare CN_Adobe_Sand = rgb <232/255, 222/255, 197/255>;
#declare CN_Adobe_South = rgb <229/255, 193/255, 167/255>;
#declare CN_Adobe_Straw = rgb <195/255, 169/255, 152/255>;
#declare CN_Adobe_White = rgb <230/255, 219/255, 196/255>;
#declare CN_Adonis = rgb <100/255, 181/255, 191/255>;
#declare CN_Adonis_Rose_Yellow = rgb <239/255, 191/255, 77/255>;
#declare CN_Adorable = rgb <227/255, 190/255, 176/255>;
#declare CN_Adriatic_Blue = rgb <92/255, 137/255, 155/255>;
#declare CN_Adriatic_Haze = rgb <150/255, 198/255, 205/255>;
#declare CN_Adriatic_Mist = rgb <211/255, 236/255, 228/255>;
#declare CN_Adriatic_Sea = rgb <1/255, 96/255, 129/255>;
#declare CN_Adrift = rgb <75/255, 144/255, 153/255>;
#declare CN_Advantageous = rgb <32/255, 114/255, 106/255>;
#declare CN_Adventure = rgb <52/255, 120/255, 140/255>;
#declare CN_Adventure_Island_Pink = rgb <248/255, 120/255, 88/255>;
#declare CN_Adventure_Isle = rgb <111/255, 159/255, 185/255>;
#declare CN_Adventure_Orange = rgb <237/255, 163/255, 103/255>;
#declare CN_Adventurer = rgb <114/255, 102/255, 79/255>;
#declare CN_Advertisement_Green = rgb <216/255, 203/255, 75/255>;
#declare CN_Advertising_Blue = rgb <0/255, 129/255, 168/255>;
#declare CN_Advertising_Green = rgb <83/255, 160/255, 121/255>;
#declare CN_Aebleskiver = rgb <230/255, 211/255, 182/255>;
#declare CN_Aegean_Blue = rgb <78/255, 110/255, 129/255>;
#declare CN_Aegean_Green = rgb <76/255, 140/255, 114/255>;
#declare CN_Aegean_Mist = rgb <156/255, 187/255, 226/255>;
#declare CN_Aegean_Sea = rgb <80/255, 143/255, 162/255>;
#declare CN_Aegean_Sky = rgb <228/255, 139/255, 89/255>;
#declare CN_Aegean_Splendor = rgb <155/255, 160/255, 164/255>;
#declare CN_Aerial_View = rgb <160/255, 178/255, 200/255>;
#declare CN_Aero = rgb <124/255, 185/255, 232/255>;
#declare CN_Aero_Blue = rgb <192/255, 232/255, 213/255>;
#declare CN_Aerobic_Fix = rgb <162/255, 195/255, 72/255>;
#declare CN_Aeronautic = rgb <43/255, 52/255, 72/255>;
#declare CN_Aerospace_Orange = rgb <255/255, 79/255, 0/255>;
#declare CN_Aerostatics = rgb <53/255, 83/255, 118/255>;
#declare CN_Aesthetic_White = rgb <227/255, 221/255, 211/255>;
#declare CN_Affair = rgb <116/255, 80/255, 133/255>;
#declare CN_Affen_Turquoise = rgb <170/255, 255/255, 255/255>;
#declare CN_Affinity = rgb <254/255, 210/255, 165/255>;
#declare CN_Afghan_Carpet = rgb <144/255, 94/255, 38/255>;
#declare CN_Afghan_Hound = rgb <226/255, 215/255, 181/255>;
#declare CN_Afghan_Sand = rgb <211/255, 169/255, 92/255>;
#declare CN_Afloat = rgb <120/255, 163/255, 194/255>;
#declare CN_African_Ambush = rgb <142/255, 96/255, 60/255>;
#declare CN_African_Bubinga = rgb <199/255, 146/255, 122/255>;
#declare CN_African_Gray = rgb <147/255, 152/255, 153/255>;
#declare CN_African_Mahogany = rgb <205/255, 74/255, 74/255>;
#declare CN_African_Mud = rgb <130/255, 108/255, 104/255>;
#declare CN_African_Plain = rgb <134/255, 113/255, 74/255>;
#declare CN_African_Queen = rgb <100/255, 94/255, 66/255>;
#declare CN_African_Safari = rgb <177/255, 107/255, 64/255>;
#declare CN_African_Sand = rgb <204/255, 170/255, 136/255>;
#declare CN_African_Violet = rgb <176/255, 133/255, 183/255>;
#declare CN_After_Burn = rgb <253/255, 139/255, 96/255>;
#declare CN_After_Dark = rgb <60/255, 53/255, 53/255>;
#declare CN_After_Dinner_Mint = rgb <227/255, 245/255, 229/255>;
#declare CN_After_Eight_Filling = rgb <214/255, 234/255, 232/255>;
#declare CN_After_Midnight = rgb <56/255, 57/255, 63/255>;
#declare CN_After_Rain = rgb <193/255, 219/255, 234/255>;
#declare CN_After_Shock = rgb <254/255, 198/255, 95/255>;
#declare CN_After_the_Rain = rgb <139/255, 196/255, 209/255>;
#declare CN_After_the_Storm = rgb <51/255, 97/255, 106/255>;
#declare CN_After_Work_Blue = rgb <36/255, 36/255, 109/255>;
#declare CN_After_Party_Pink = rgb <201/255, 94/255, 251/255>;
#declare CN_Aftercare = rgb <133/255, 192/255, 205/255>;
#declare CN_Afterglow = rgb <243/255, 230/255, 201/255>;
#declare CN_Afterlife = rgb <217/255, 31/255, 255/255>;
#declare CN_Afternoon = rgb <251/255, 203/255, 120/255>;
#declare CN_Afternoon_Sky = rgb <135/255, 206/255, 235/255>;
#declare CN_Afternoon_Stroll = rgb <217/255, 197/255, 161/255>;
#declare CN_Afternoon_Tea = rgb <89/255, 78/255, 64/255>;
#declare CN_Agapanthus = rgb <187/255, 197/255, 222/255>;
#declare CN_Agate_Brown = rgb <149/255, 106/255, 96/255>;
#declare CN_Agate_Green = rgb <89/255, 159/255, 153/255>;
#declare CN_Agate_Grey = rgb <177/255, 176/255, 159/255>;
#declare CN_Agate_Violet = rgb <90/255, 91/255, 116/255>;
#declare CN_Agave = rgb <135/255, 157/255, 153/255>;
#declare CN_Agave_Frond = rgb <90/255, 110/255, 106/255>;
#declare CN_Agave_Green = rgb <107/255, 113/255, 105/255>;
#declare CN_Agave_Plant = rgb <135/255, 156/255, 103/255>;
#declare CN_Aged_Beige = rgb <215/255, 207/255, 192/255>;
#declare CN_Aged_Brandy = rgb <135/255, 65/255, 63/255>;
#declare CN_Aged_Chocolate = rgb <95/255, 73/255, 71/255>;
#declare CN_Aged_Cotton = rgb <224/255, 220/255, 218/255>;
#declare CN_Aged_Eucalyptus = rgb <137/255, 130/255, 83/255>;
#declare CN_Aged_Gouda = rgb <221/255, 153/255, 68/255>;
#declare CN_Aged_Jade = rgb <108/255, 105/255, 86/255>;
#declare CN_Aged_Merlot = rgb <115/255, 52/255, 58/255>;
#declare CN_Aged_Mustard_Green = rgb <110/255, 110/255, 48/255>;
#declare CN_Aged_Olive = rgb <126/255, 118/255, 102/255>;
#declare CN_Aged_Parchment = rgb <233/255, 221/255, 202/255>;
#declare CN_Aged_Pewter = rgb <136/255, 153/255, 153/255>;
#declare CN_Aged_Pink = rgb <201/255, 159/255, 153/255>;
#declare CN_Aged_Plastic_Casing = rgb <255/255, 250/255, 134/255>;
#declare CN_Aged_Purple = rgb <164/255, 66/255, 160/255>;
#declare CN_Aged_Teak = rgb <122/255, 65/255, 52/255>;
#declare CN_Aged_to_Perfection = rgb <165/255, 142/255, 169/255>;
#declare CN_Aged_Whisky = rgb <157/255, 113/255, 71/255>;
#declare CN_Aged_White = rgb <232/255, 222/255, 205/255>;
#declare CN_Aged_Wine = rgb <137/255, 84/255, 96/255>;
#declare CN_Ageless = rgb <236/255, 236/255, 223/255>;
#declare CN_Ageless_Beauty = rgb <231/255, 169/255, 149/255>;
#declare CN_Agent_Orange = rgb <238/255, 102/255, 51/255>;
#declare CN_Aggressive_Baby_Blue = rgb <111/255, 255/255, 255/255>;
#declare CN_Aggressive_Salmon = rgb <255/255, 119/255, 153/255>;
#declare CN_Aging_Barrel = rgb <106/255, 91/255, 78/255>;
#declare CN_Agrax_Earthshade = rgb <57/255, 49/255, 33/255>;
#declare CN_Agreeable_Gray = rgb <209/255, 203/255, 193/255>;
#declare CN_Agrellan_Badland = rgb <255/255, 179/255, 71/255>;
#declare CN_Agrellan_Earth = rgb <161/255, 124/255, 89/255>;
#declare CN_Agressive_Aqua = rgb <0/255, 251/255, 255/255>;
#declare CN_Agrodolce = rgb <240/255, 226/255, 211/255>;
#declare CN_Agua_Fria = rgb <159/255, 197/255, 204/255>;
#declare CN_Ahaetulla_Prasina = rgb <0/255, 250/255, 146/255>;
#declare CN_Ahmar_Red = rgb <194/255, 33/255, 71/255>;
#declare CN_Ahoy = rgb <42/255, 49/255, 73/255>;
#declare CN_Ahriman_Blue = rgb <25/255, 158/255, 189/255>;
#declare CN_Ai_Indigo = rgb <39/255, 68/255, 71/255>;
#declare CN_Aida = rgb <180/255, 200/255, 182/255>;
#declare CN_Aijiro_White = rgb <236/255, 247/255, 247/255>;
#declare CN_Aimee = rgb <238/255, 229/255, 225/255>;
#declare CN_Aimiru_Brown = rgb <46/255, 55/255, 46/255>;
#declare CN_Air_Blue = rgb <119/255, 172/255, 199/255>;
#declare CN_Air_Castle = rgb <215/255, 209/255, 233/255>;
#declare CN_Air_Force_Blue = rgb <93/255, 138/255, 168/255>;
#declare CN_Air_of_Mint = rgb <216/255, 242/255, 238/255>;
#declare CN_Air_Superiority_Blue = rgb <114/255, 160/255, 193/255>;
#declare CN_Airborne = rgb <162/255, 194/255, 208/255>;
#declare CN_Airbrushed_Copper = rgb <170/255, 108/255, 81/255>;
#declare CN_Aircraft_Blue = rgb <53/255, 79/255, 88/255>;
#declare CN_Aircraft_Exterior_Grey = rgb <147/255, 148/255, 152/255>;
#declare CN_Aircraft_Green = rgb <42/255, 44/255, 31/255>;
#declare CN_Aircraft_White = rgb <237/255, 242/255, 248/255>;
#declare CN_Airflow = rgb <217/255, 229/255, 228/255>;
#declare CN_Airforce = rgb <54/255, 77/255, 112/255>;
#declare CN_Airline_Green = rgb <140/255, 150/255, 50/255>;
#declare CN_Airy = rgb <218/255, 230/255, 233/255>;
#declare CN_Airy_Blue = rgb <136/255, 204/255, 238/255>;
#declare CN_Airy_Green = rgb <219/255, 224/255, 196/255>;
#declare CN_Ajo_Lily = rgb <250/255, 236/255, 217/255>;
#declare CN_Ajwain_Green = rgb <211/255, 222/255, 123/255>;
#declare CN_Akabeni = rgb <195/255, 39/255, 43/255>;
#declare CN_Akai_Red = rgb <188/255, 1/255, 46/255>;
#declare CN_Akako_Red = rgb <240/255, 127/255, 94/255>;
#declare CN_Akaroa = rgb <190/255, 178/255, 154/255>;
#declare CN_Ake_Blood = rgb <207/255, 58/255, 36/255>;
#declare CN_Akebi_Purple = rgb <152/255, 63/255, 178/255>;
#declare CN_Akebono_Dawn = rgb <250/255, 123/255, 98/255>;
#declare CN_Akhdhar_Green = rgb <176/255, 227/255, 19/255>;
#declare CN_Akihabara_Arcade = rgb <96/255, 30/255, 249/255>;
#declare CN_Akira_Red = rgb <225/255, 33/255, 32/255>;
#declare CN_Akumas_Fury = rgb <135/255, 22/255, 70/255>;
#declare CN_Alabama_Crimson = rgb <163/255, 38/255, 56/255>;
#declare CN_Alabaster = rgb <243/255, 231/255, 219/255>;
#declare CN_Alabaster_Beauty = rgb <233/255, 227/255, 210/255>;
#declare CN_Alabaster_Gleam = rgb <240/255, 222/255, 189/255>;
#declare CN_Alabaster_White = rgb <223/255, 212/255, 191/255>;
#declare CN_Aladdins_Feather = rgb <85/255, 0/255, 255/255>;
#declare CN_Alaea = rgb <129/255, 88/255, 91/255>;
#declare CN_Alaitoc_Blue = rgb <142/255, 140/255, 151/255>;
#declare CN_Alajuela_Toad = rgb <255/255, 174/255, 82/255>;
#declare CN_Alameda_Ochre = rgb <202/255, 146/255, 52/255>;
#declare CN_Alamosa_Green = rgb <147/255, 155/255, 113/255>;
#declare CN_Alarm = rgb <236/255, 0/255, 3/255>;
#declare CN_Alarming_Slime = rgb <44/255, 227/255, 53/255>;
#declare CN_Alaskan_Blue = rgb <109/255, 169/255, 210/255>;
#declare CN_Alaskan_Cruise = rgb <52/255, 70/255, 108/255>;
#declare CN_Alaskan_Grey = rgb <188/255, 190/255, 188/255>;
#declare CN_Alaskan_Ice = rgb <126/255, 158/255, 194/255>;
#declare CN_Alaskan_Mist = rgb <236/255, 240/255, 229/255>;
#declare CN_Alaskan_Moss = rgb <5/255, 71/255, 42/255>;
#declare CN_Alaskan_Skies = rgb <205/255, 220/255, 237/255>;
#declare CN_Alaskan_Wind = rgb <186/255, 227/255, 235/255>;
#declare CN_Albanian_Red = rgb <204/255, 0/255, 1/255>;
#declare CN_Albeit = rgb <56/255, 84/255, 110/255>;
#declare CN_Albert_Green = rgb <79/255, 88/255, 69/255>;
#declare CN_Albescent_White = rgb <225/255, 218/255, 203/255>;
#declare CN_Albino = rgb <251/255, 238/255, 229/255>;
#declare CN_Albuquerque = rgb <204/255, 164/255, 126/255>;
#declare CN_Alchemy = rgb <231/255, 207/255, 140/255>;
#declare CN_Aldabra = rgb <170/255, 164/255, 146/255>;
#declare CN_Alden_Till = rgb <122/255, 75/255, 73/255>;
#declare CN_Alert_Tan = rgb <149/255, 78/255, 44/255>;
#declare CN_Alesan = rgb <241/255, 206/255, 179/255>;
#declare CN_Aleutian = rgb <154/255, 158/255, 179/255>;
#declare CN_Alexandra_Peach = rgb <219/255, 151/255, 133/255>;
#declare CN_Alexandria = rgb <255/255, 143/255, 115/255>;
#declare CN_Alexandrias_Lighthouse = rgb <252/255, 239/255, 193/255>;
#declare CN_Alexandrian_Sky = rgb <188/255, 217/255, 220/255>;
#declare CN_Alexandrite = rgb <89/255, 140/255, 116/255>;
#declare CN_Alexandrite_Green = rgb <118/255, 120/255, 83/255>;
#declare CN_Alexis_Blue = rgb <65/255, 96/255, 130/255>;
#declare CN_Alfalfa = rgb <183/255, 181/255, 159/255>;
#declare CN_Alfalfa_Extract = rgb <84/255, 105/255, 64/255>;
#declare CN_Alga_Moss = rgb <141/255, 169/255, 141/255>;
#declare CN_Algae = rgb <84/255, 172/255, 104/255>;
#declare CN_Algae_Green = rgb <147/255, 223/255, 184/255>;
#declare CN_Algae_Red = rgb <152/255, 61/255, 83/255>;
#declare CN_Algal_Fuel = rgb <33/255, 195/255, 111/255>;
#declare CN_Algen_Gerne = rgb <71/255, 151/255, 132/255>;
#declare CN_Algerian_Coral = rgb <252/255, 90/255, 80/255>;
#declare CN_Algiers_Blue = rgb <0/255, 133/255, 156/255>;
#declare CN_Algodon_Azul = rgb <193/255, 219/255, 236/255>;
#declare CN_Alhambra = rgb <0/255, 135/255, 120/255>;
#declare CN_Alhambra_Cream = rgb <247/255, 242/255, 225/255>;
#declare CN_Alhambra_Green = rgb <0/255, 164/255, 101/255>;
#declare CN_Alibi = rgb <212/255, 203/255, 196/255>;
#declare CN_Alice_Blue = rgb <240/255, 248/255, 255/255>;
#declare CN_Alice_White = rgb <194/255, 206/255, 210/255>;
#declare CN_Alien = rgb <65/255, 87/255, 100/255>;
#declare CN_Alien_Abduction = rgb <12/255, 255/255, 12/255>;
#declare CN_Alien_Armpit = rgb <132/255, 222/255, 2/255>;
#declare CN_Alien_Breed = rgb <185/255, 204/255, 129/255>;
#declare CN_Alien_Parasite = rgb <85/255, 255/255, 51/255>;
#declare CN_Alien_Purple = rgb <73/255, 6/255, 72/255>;
#declare CN_Alienator_Grey = rgb <151/255, 144/255, 164/255>;
#declare CN_Align = rgb <0/255, 114/255, 141/255>;
#declare CN_Alizarin = rgb <227/255, 70/255, 54/255>;
#declare CN_Alizarin_Crimson = rgb <227/255, 38/255, 54/255>;
#declare CN_All_About_Olive = rgb <103/255, 108/255, 88/255>;
#declare CN_All_Dressed_Up = rgb <230/255, 153/255, 157/255>;
#declare CN_All_Made_Up = rgb <239/255, 215/255, 231/255>;
#declare CN_All_Nighter = rgb <69/255, 84/255, 84/255>;
#declare CN_Alls_Ace = rgb <198/255, 136/255, 134/255>;
#declare CN_Allegiance = rgb <90/255, 106/255, 140/255>;
#declare CN_Allegory = rgb <180/255, 178/255, 169/255>;
#declare CN_Allegro = rgb <178/255, 137/255, 89/255>;
#declare CN_Alley = rgb <184/255, 196/255, 217/255>;
#declare CN_Alley_Cat = rgb <101/255, 104/255, 116/255>;
#declare CN_Alliance = rgb <43/255, 101/255, 95/255>;
#declare CN_Alligator = rgb <136/255, 102/255, 0/255>;
#declare CN_Alligator_Egg = rgb <234/255, 238/255, 215/255>;
#declare CN_Alligator_Gladiator = rgb <68/255, 68/255, 17/255>;
#declare CN_Alligator_Skin = rgb <100/255, 96/255, 72/255>;
#declare CN_Allison_Lace = rgb <241/255, 234/255, 212/255>;
#declare CN_Allium = rgb <149/255, 105/255, 163/255>;
#declare CN_Alloy = rgb <152/255, 151/255, 154/255>;
#declare CN_Alloy_Orange = rgb <196/255, 98/255, 16/255>;
#declare CN_Allports = rgb <31/255, 106/255, 125/255>;
#declare CN_Allspice = rgb <248/255, 205/255, 170/255>;
#declare CN_Allura_Red = rgb <237/255, 46/255, 56/255>;
#declare CN_Allure = rgb <114/255, 145/255, 180/255>;
#declare CN_Alluring_Blue = rgb <158/255, 196/255, 205/255>;
#declare CN_Alluring_Gesture = rgb <248/255, 219/255, 194/255>;
#declare CN_Alluring_Light = rgb <255/255, 247/255, 216/255>;
#declare CN_Alluring_Umber = rgb <151/255, 123/255, 77/255>;
#declare CN_Alluring_White = rgb <239/255, 225/255, 210/255>;
#declare CN_Alluvial_Inca = rgb <187/255, 147/255, 75/255>;
#declare CN_Allyson = rgb <203/255, 115/255, 139/255>;
#declare CN_Almeja = rgb <245/255, 224/255, 201/255>;
#declare CN_Almendra_Tostada = rgb <232/255, 214/255, 189/255>;
#declare CN_Almond = rgb <237/255, 220/255, 200/255>;
#declare CN_Almond_Beige = rgb <223/255, 213/255, 202/255>;
#declare CN_Almond_Biscuit = rgb <233/255, 201/255, 169/255>;
#declare CN_Almond_Blossom = rgb <245/255, 190/255, 199/255>;
#declare CN_Almond_Blossom_Pink = rgb <224/255, 210/255, 209/255>;
#declare CN_Almond_Brittle = rgb <229/255, 211/255, 185/255>;
#declare CN_Almond_Buff = rgb <204/255, 179/255, 144/255>;
#declare CN_Almond_Butter = rgb <216/255, 198/255, 168/255>;
#declare CN_Almond_Cookie = rgb <238/255, 200/255, 124/255>;
#declare CN_Almond_Cream = rgb <244/255, 194/255, 159/255>;
#declare CN_Almond_Frost = rgb <154/255, 134/255, 120/255>;
#declare CN_Almond_Green = rgb <89/255, 94/255, 76/255>;
#declare CN_Almond_Icing = rgb <239/255, 227/255, 217/255>;
#declare CN_Almond_Kiss = rgb <246/255, 227/255, 212/255>;
#declare CN_Almond_Latte = rgb <214/255, 192/255, 164/255>;
#declare CN_Almond_Milk = rgb <214/255, 206/255, 190/255>;
#declare CN_Almond_Oil = rgb <244/255, 239/255, 193/255>;
#declare CN_Almond_Paste = rgb <229/255, 219/255, 197/255>;
#declare CN_Almond_Roca = rgb <240/255, 232/255, 224/255>;
#declare CN_Almond_Rose = rgb <204/255, 136/255, 136/255>;
#declare CN_Almond_Silk = rgb <225/255, 207/255, 178/255>;
#declare CN_Almond_Toast = rgb <191/255, 158/255, 119/255>;
#declare CN_Almond_Truffle = rgb <125/255, 102/255, 91/255>;
#declare CN_Almond_Willow = rgb <230/255, 201/255, 188/255>;
#declare CN_Almond_Wisp = rgb <214/255, 202/255, 185/255>;
#declare CN_Almondine = rgb <254/255, 222/255, 188/255>;
#declare CN_Almost_Aloe = rgb <191/255, 229/255, 177/255>;
#declare CN_Almost_Apricot = rgb <229/255, 179/255, 155/255>;
#declare CN_Almost_Aqua = rgb <152/255, 221/255, 197/255>;
#declare CN_Almost_Famous = rgb <58/255, 84/255, 87/255>;
#declare CN_Almost_Mauve = rgb <231/255, 220/255, 217/255>;
#declare CN_Almost_Pink = rgb <240/255, 227/255, 218/255>;
#declare CN_Aloe = rgb <129/255, 122/255, 96/255>;
#declare CN_Aloe_Blossom = rgb <201/255, 120/255, 99/255>;
#declare CN_Aloe_Cream = rgb <219/255, 229/255, 185/255>;
#declare CN_Aloe_Essence = rgb <236/255, 241/255, 226/255>;
#declare CN_Aloe_Leaf = rgb <97/255, 100/255, 63/255>;
#declare CN_Aloe_Mist = rgb <220/255, 242/255, 227/255>;
#declare CN_Aloe_Nectar = rgb <223/255, 226/255, 201/255>;
#declare CN_Aloe_Plant = rgb <184/255, 186/255, 135/255>;
#declare CN_Aloe_Thorn = rgb <136/255, 139/255, 115/255>;
#declare CN_Aloe_Vera = rgb <103/255, 135/255, 121/255>;
#declare CN_Aloe_Vera_Green = rgb <126/255, 155/255, 57/255>;
#declare CN_Aloe_Vera_Tea = rgb <132/255, 139/255, 113/255>;
#declare CN_Aloe_Wash = rgb <208/255, 211/255, 183/255>;
#declare CN_Aloeswood = rgb <106/255, 67/255, 45/255>;
#declare CN_Aloha = rgb <29/255, 179/255, 148/255>;
#declare CN_Aloha_Sunset = rgb <233/255, 170/255, 145/255>;
#declare CN_Alone_in_the_Dark = rgb <0/255, 0/255, 102/255>;
#declare CN_Aloof = rgb <212/255, 226/255, 230/255>;
#declare CN_Aloof_Gray = rgb <201/255, 201/255, 192/255>;
#declare CN_Aloof_Lama = rgb <214/255, 197/255, 160/255>;
#declare CN_Alpaca = rgb <247/255, 229/255, 218/255>;
#declare CN_Alpaca_Blanket = rgb <222/255, 215/255, 197/255>;
#declare CN_Alpaca_Wool = rgb <249/255, 237/255, 226/255>;
#declare CN_Alpenglow = rgb <240/255, 190/255, 184/255>;
#declare CN_Alpha_Blue = rgb <88/255, 139/255, 180/255>;
#declare CN_Alpha_Centauri = rgb <77/255, 87/255, 120/255>;
#declare CN_Alpha_Gold = rgb <174/255, 142/255, 95/255>;
#declare CN_Alpha_Male = rgb <113/255, 90/255, 69/255>;
#declare CN_Alpha_Tango = rgb <98/255, 143/255, 176/255>;
#declare CN_Alphabet_Blue = rgb <171/255, 205/255, 239/255>;
#declare CN_Alpine = rgb <173/255, 138/255, 59/255>;
#declare CN_Alpine_Air = rgb <169/255, 180/255, 169/255>;
#declare CN_Alpine_Alabaster = rgb <186/255, 219/255, 230/255>;
#declare CN_Alpine_Berry_Yellow = rgb <247/255, 224/255, 186/255>;
#declare CN_Alpine_Blue = rgb <219/255, 228/255, 229/255>;
#declare CN_Alpine_Duck_Grey = rgb <64/255, 70/255, 77/255>;
#declare CN_Alpine_Expedition = rgb <153/255, 238/255, 255/255>;
#declare CN_Alpine_Frost = rgb <224/255, 222/255, 210/255>;
#declare CN_Alpine_Goat = rgb <241/255, 242/255, 248/255>;
#declare CN_Alpine_Green = rgb <0/255, 95/255, 86/255>;
#declare CN_Alpine_Haze = rgb <171/255, 190/255, 192/255>;
#declare CN_Alpine_Herbs = rgb <68/255, 153/255, 85/255>;
#declare CN_Alpine_Lake_Green = rgb <79/255, 96/255, 62/255>;
#declare CN_Alpine_Landing = rgb <17/255, 123/255, 135/255>;
#declare CN_Alpine_Moon = rgb <222/255, 211/255, 230/255>;
#declare CN_Alpine_Morning_Blue = rgb <166/255, 204/255, 216/255>;
#declare CN_Alpine_Race = rgb <35/255, 65/255, 98/255>;
#declare CN_Alpine_Salamander = rgb <5/255, 16/255, 9/255>;
#declare CN_Alpine_Summer = rgb <165/255, 169/255, 154/255>;
#declare CN_Alpine_Trail = rgb <81/255, 90/255, 82/255>;
#declare CN_Alsike_Clover_Red = rgb <177/255, 87/255, 95/255>;
#declare CN_Alsot_Olive = rgb <223/255, 213/255, 177/255>;
#declare CN_Altar_of_Heaven = rgb <77/255, 76/255, 128/255>;
#declare CN_Altdorf_Guard_Blue = rgb <31/255, 86/255, 167/255>;
#declare CN_Altdorf_Sky_Blue = rgb <0/255, 161/255, 172/255>;
#declare CN_Alter_Ego = rgb <105/255, 101/255, 109/255>;
#declare CN_Altered_Pink = rgb <239/255, 199/255, 190/255>;
#declare CN_Alto = rgb <205/255, 198/255, 197/255>;
#declare CN_Alu_Gobi = rgb <221/255, 187/255, 0/255>;
#declare CN_Alucards_Night = rgb <0/255, 0/255, 85/255>;
#declare CN_Aluminium = rgb <132/255, 135/255, 137/255>;
#declare CN_Aluminium_Powder = rgb <169/255, 160/255, 169/255>;
#declare CN_Aluminium_Snow = rgb <174/255, 175/255, 180/255>;
#declare CN_Aluminum = rgb <159/255, 149/255, 134/255>;
#declare CN_Aluminum_Foil = rgb <210/255, 217/255, 219/255>;
#declare CN_Aluminum_Silver = rgb <140/255, 141/255, 145/255>;
#declare CN_Aluminum_Sky = rgb <173/255, 175/255, 175/255>;
#declare CN_Alverda = rgb <165/255, 201/255, 112/255>;
#declare CN_Always_Almond = rgb <235/255, 229/255, 210/255>;
#declare CN_Always_Apple = rgb <160/255, 166/255, 103/255>;
#declare CN_Always_Blue = rgb <162/255, 186/255, 203/255>;
#declare CN_Always_Green_Grass = rgb <17/255, 170/255, 0/255>;
#declare CN_Always_Indigo = rgb <102/255, 119/255, 140/255>;
#declare CN_Always_Neutral = rgb <223/255, 215/255, 203/255>;
#declare CN_Always_Rosey = rgb <231/255, 157/255, 179/255>;
#declare CN_Alyssa = rgb <244/255, 226/255, 214/255>;
#declare CN_Alyssum = rgb <242/255, 213/255, 215/255>;
#declare CN_Amalfi = rgb <1/255, 110/255, 133/255>;
#declare CN_Amalfi_Coast = rgb <41/255, 124/255, 191/255>;
#declare CN_Amalfitan_Azure = rgb <3/255, 59/255, 154/255>;
#declare CN_Amaranth = rgb <232/255, 110/255, 173/255>;
#declare CN_Amaranth_Blossom = rgb <123/255, 35/255, 49/255>;
#declare CN_Amaranth_Deep_Purple = rgb <159/255, 43/255, 104/255>;
#declare CN_Amaranth_Pink = rgb <241/255, 156/255, 187/255>;
#declare CN_Amaranth_Purple = rgb <106/255, 57/255, 123/255>;
#declare CN_Amaranth_Red = rgb <211/255, 33/255, 45/255>;
#declare CN_Amarantha_Red = rgb <204/255, 51/255, 17/255>;
#declare CN_Amaranthine = rgb <95/255, 64/255, 83/255>;
#declare CN_Amaretto = rgb <171/255, 111/255, 96/255>;
#declare CN_Amaretto_Sour = rgb <192/255, 152/255, 86/255>;
#declare CN_Amarillo_Bebito = rgb <255/255, 241/255, 212/255>;
#declare CN_Amarillo_Yellow = rgb <251/255, 241/255, 195/255>;
#declare CN_Amarklor_Violet = rgb <85/255, 17/255, 153/255>;
#declare CN_Amaryllis = rgb <184/255, 80/255, 69/255>;
#declare CN_Amaya = rgb <242/255, 193/255, 203/255>;
#declare CN_Amazing_Amethyst = rgb <128/255, 101/255, 104/255>;
#declare CN_Amazing_Boulder = rgb <169/255, 167/255, 151/255>;
#declare CN_Amazing_Gray = rgb <190/255, 181/255, 169/255>;
#declare CN_Amazing_Smoke = rgb <102/255, 128/255, 187/255>;
#declare CN_Amazon = rgb <56/255, 123/255, 84/255>;
#declare CN_Amazon_Breeze = rgb <235/255, 235/255, 214/255>;
#declare CN_Amazon_Depths = rgb <80/255, 83/255, 56/255>;
#declare CN_Amazon_Foliage = rgb <96/255, 101/255, 83/255>;
#declare CN_Amazon_Green = rgb <120/255, 106/255, 74/255>;
#declare CN_Amazon_Jungle = rgb <104/255, 103/255, 71/255>;
#declare CN_Amazon_Mist = rgb <236/255, 236/255, 220/255>;
#declare CN_Amazon_Moss = rgb <126/255, 140/255, 122/255>;
#declare CN_Amazon_Queen = rgb <148/255, 143/255, 84/255>;
#declare CN_Amazon_River = rgb <119/255, 116/255, 98/255>;
#declare CN_Amazon_River_Dolphin = rgb <230/255, 178/255, 184/255>;
#declare CN_Amazon_Stone = rgb <126/255, 120/255, 115/255>;
#declare CN_Amazon_Vine = rgb <171/255, 170/255, 151/255>;
#declare CN_Amazonian = rgb <170/255, 102/255, 68/255>;
#declare CN_Amazonian_Orchid = rgb <167/255, 129/255, 157/255>;
#declare CN_Amazonite = rgb <0/255, 196/255, 176/255>;
#declare CN_Ambassador_Blue = rgb <13/255, 47/255, 90/255>;
#declare CN_Amber = rgb <255/255, 191/255, 0/255>;
#declare CN_Amber_Autumn = rgb <198/255, 156/255, 106/255>;
#declare CN_Amber_Brew = rgb <215/255, 163/255, 97/255>;
#declare CN_Amber_Brown = rgb <166/255, 102/255, 70/255>;
#declare CN_Amber_Dawn = rgb <246/255, 188/255, 119/255>;
#declare CN_Amber_Glass = rgb <199/255, 153/255, 88/255>;
#declare CN_Amber_Glow = rgb <242/255, 154/255, 57/255>;
#declare CN_Amber_Gold = rgb <193/255, 149/255, 82/255>;
#declare CN_Amber_Green = rgb <154/255, 128/255, 58/255>;
#declare CN_Amber_Grey = rgb <208/255, 165/255, 146/255>;
#declare CN_Amber_Leaf = rgb <186/255, 153/255, 113/255>;
#declare CN_Amber_Moon = rgb <238/255, 209/255, 165/255>;
#declare CN_Amber_Romance = rgb <177/255, 129/255, 64/255>;
#declare CN_Amber_Sun = rgb <255/255, 153/255, 136/255>;
#declare CN_Amber_Tide = rgb <255/255, 175/255, 163/255>;
#declare CN_Amber_Wave = rgb <215/255, 139/255, 85/255>;
#declare CN_Amber_Yellow = rgb <250/255, 183/255, 90/255>;
#declare CN_Amberglow = rgb <220/255, 121/255, 62/255>;
#declare CN_Amberlight = rgb <226/255, 190/255, 162/255>;
#declare CN_Ambience_White = rgb <231/255, 231/255, 230/255>;
#declare CN_Ambient_Glow = rgb <248/255, 237/255, 224/255>;
#declare CN_Ambit = rgb <151/255, 101/255, 63/255>;
#declare CN_Ambitious_Amber = rgb <240/255, 203/255, 151/255>;
#declare CN_Ambitious_Rose = rgb <233/255, 104/255, 126/255>;
#declare CN_Ambrosia = rgb <210/255, 231/255, 202/255>;
#declare CN_Ambrosia_Coffee_Cake = rgb <238/255, 233/255, 211/255>;
#declare CN_Ambrosia_Ivory = rgb <255/255, 244/255, 235/255>;
#declare CN_Ambrosia_Salad = rgb <244/255, 222/255, 211/255>;
#declare CN_Ameixa = rgb <106/255, 90/255, 205/255>;
#declare CN_Amelia = rgb <190/255, 204/255, 194/255>;
#declare CN_Amelies_Tutu = rgb <254/255, 167/255, 189/255>;
#declare CN_Americas_Cup = rgb <52/255, 84/255, 109/255>;
#declare CN_American_Anthem = rgb <117/255, 149/255, 171/255>;
#declare CN_American_Beauty = rgb <167/255, 51/255, 64/255>;
#declare CN_American_Blue = rgb <59/255, 59/255, 109/255>;
#declare CN_American_Bronze = rgb <57/255, 24/255, 2/255>;
#declare CN_American_Brown = rgb <128/255, 64/255, 64/255>;
#declare CN_American_Gold = rgb <211/255, 175/255, 55/255>;
#declare CN_American_Green = rgb <52/255, 179/255, 52/255>;
#declare CN_American_Mahogany = rgb <82/255, 53/255, 47/255>;
#declare CN_American_Milking_Devon = rgb <99/255, 64/255, 58/255>;
#declare CN_American_Orange = rgb <255/255, 139/255, 0/255>;
#declare CN_American_Pink = rgb <255/255, 152/255, 153/255>;
#declare CN_American_Purple = rgb <67/255, 28/255, 83/255>;
#declare CN_American_Red = rgb <179/255, 33/255, 52/255>;
#declare CN_American_River = rgb <98/255, 110/255, 113/255>;
#declare CN_American_Roast = rgb <153/255, 85/255, 68/255>;
#declare CN_American_Rose = rgb <255/255, 3/255, 62/255>;
#declare CN_American_Silver = rgb <207/255, 207/255, 207/255>;
#declare CN_American_Violet = rgb <85/255, 27/255, 140/255>;
#declare CN_American_Yellow = rgb <242/255, 180/255, 0/255>;
#declare CN_American_Yorkshire = rgb <239/255, 220/255, 212/255>;
#declare CN_Americana = rgb <4/255, 119/255, 180/255>;
#declare CN_Americano = rgb <70/255, 55/255, 50/255>;
#declare CN_Amethyst = rgb <153/255, 102/255, 204/255>;
#declare CN_Amethyst_Cream = rgb <236/255, 234/255, 236/255>;
#declare CN_Amethyst_Dark_Violet = rgb <79/255, 60/255, 82/255>;
#declare CN_Amethyst_Ganzstar = rgb <143/255, 0/255, 255/255>;
#declare CN_Amethyst_Gem = rgb <119/255, 105/255, 133/255>;
#declare CN_Amethyst_Grey = rgb <144/255, 133/255, 196/255>;
#declare CN_Amethyst_Grey_Violet = rgb <156/255, 137/255, 161/255>;
#declare CN_Amethyst_Haze = rgb <160/255, 160/255, 170/255>;
#declare CN_Amethyst_Ice = rgb <208/255, 201/255, 198/255>;
#declare CN_Amethyst_Light_Violet = rgb <207/255, 194/255, 209/255>;
#declare CN_Amethyst_Orchid = rgb <146/255, 106/255, 166/255>;
#declare CN_Amethyst_Paint = rgb <156/255, 138/255, 164/255>;
#declare CN_Amethyst_Phlox = rgb <155/255, 145/255, 161/255>;
#declare CN_Amethyst_Purple = rgb <86/255, 47/255, 126/255>;
#declare CN_Amethyst_Show = rgb <189/255, 151/255, 207/255>;
#declare CN_Amethyst_Smoke = rgb <149/255, 135/255, 156/255>;
#declare CN_Ametrine_Quartz = rgb <222/255, 209/255, 224/255>;
#declare CN_Amiable_Orange = rgb <223/255, 150/255, 91/255>;
#declare CN_Amish_Bread = rgb <230/255, 221/255, 190/255>;
#declare CN_Amish_Green = rgb <58/255, 95/255, 78/255>;
#declare CN_Amnesia_Blue = rgb <21/255, 96/255, 189/255>;
#declare CN_Amok = rgb <221/255, 204/255, 34/255>;
#declare CN_Amor = rgb <238/255, 51/255, 119/255>;
#declare CN_Amora_Purple = rgb <187/255, 34/255, 170/255>;
#declare CN_Amore = rgb <174/255, 47/255, 72/255>;
#declare CN_Amorphous_Rose = rgb <177/255, 167/255, 183/255>;
#declare CN_Amour = rgb <238/255, 88/255, 81/255>;
#declare CN_Amour_Frais = rgb <245/255, 230/255, 234/255>;
#declare CN_Amourette = rgb <200/255, 197/255, 215/255>;
#declare CN_Amourette_Eternelle = rgb <224/255, 223/255, 232/255>;
#declare CN_Amparo_Blue = rgb <73/255, 96/255, 168/255>;
#declare CN_Amphibian = rgb <38/255, 76/255, 71/255>;
#declare CN_Amphitrite = rgb <56/255, 78/255, 71/255>;
#declare CN_Amphora = rgb <159/255, 134/255, 114/255>;
#declare CN_Amphystine = rgb <63/255, 66/255, 90/255>;
#declare CN_Amulet = rgb <125/255, 157/255, 114/255>;
#declare CN_Amulet_Gem = rgb <1/255, 116/255, 142/255>;
#declare CN_Amygdala_Purple = rgb <105/255, 4/255, 95/255>;
#declare CN_An_Zi_Purple = rgb <148/255, 86/255, 140/255>;
#declare CN_Anaheim_Pepper = rgb <0/255, 187/255, 68/255>;
#declare CN_Anakiwa = rgb <140/255, 206/255, 234/255>;
#declare CN_Analytical_Gray = rgb <191/255, 182/255, 167/255>;
#declare CN_Anarchist = rgb <219/255, 48/255, 74/255>;
#declare CN_Anarchy = rgb <222/255, 3/255, 0/255>;
#declare CN_Ancestral = rgb <208/255, 193/255, 195/255>;
#declare CN_Ancestral_Gold = rgb <221/255, 205/255, 166/255>;
#declare CN_Ancestral_Water = rgb <208/255, 208/255, 208/255>;
#declare CN_Ancestry_Violet = rgb <158/255, 144/255, 167/255>;
#declare CN_Ancho_Pepper = rgb <122/255, 81/255, 69/255>;
#declare CN_Anchor_Grey = rgb <89/255, 96/255, 98/255>;
#declare CN_Anchor_Point = rgb <67/255, 93/255, 139/255>;
#declare CN_Anchorman = rgb <44/255, 54/255, 65/255>;
#declare CN_Anchors_Away = rgb <158/255, 187/255, 205/255>;
#declare CN_Anchors_Aweigh = rgb <43/255, 52/255, 65/255>;
#declare CN_Anchovy = rgb <117/255, 111/255, 107/255>;
#declare CN_Ancient_Bamboo = rgb <218/255, 99/255, 4/255>;
#declare CN_Ancient_Brandy = rgb <170/255, 102/255, 17/255>;
#declare CN_Ancient_Bronze = rgb <156/255, 82/255, 33/255>;
#declare CN_Ancient_Chest = rgb <153/255, 82/255, 43/255>;
#declare CN_Ancient_Copper = rgb <159/255, 84/255, 62/255>;
#declare CN_Ancient_Doeskin = rgb <220/255, 201/255, 168/255>;
#declare CN_Ancient_Earth = rgb <116/255, 101/255, 80/255>;
#declare CN_Ancient_Ice = rgb <115/255, 253/255, 255/255>;
#declare CN_Ancient_Ivory = rgb <241/255, 230/255, 209/255>;
#declare CN_Ancient_Kingdom = rgb <214/255, 216/255, 205/255>;
#declare CN_Ancient_Lavastone = rgb <72/255, 60/255, 50/255>;
#declare CN_Ancient_Magenta = rgb <149/255, 61/255, 85/255>;
#declare CN_Ancient_Marble = rgb <209/255, 204/255, 185/255>;
#declare CN_Ancient_Maze = rgb <149/255, 150/255, 81/255>;
#declare CN_Ancient_Murasaki_Purple = rgb <137/255, 91/255, 138/255>;
#declare CN_Ancient_Olive = rgb <106/255, 85/255, 54/255>;
#declare CN_Ancient_Pages = rgb <221/255, 212/255, 206/255>;
#declare CN_Ancient_Pewter = rgb <137/255, 141/255, 145/255>;
#declare CN_Ancient_Planks = rgb <119/255, 68/255, 17/255>;
#declare CN_Ancient_Pottery = rgb <163/255, 125/255, 94/255>;
#declare CN_Ancient_Prunus = rgb <90/255, 61/255, 63/255>;
#declare CN_Ancient_Red = rgb <146/255, 42/255, 49/255>;
#declare CN_Ancient_Root = rgb <112/255, 85/255, 61/255>;
#declare CN_Ancient_Royal_Banner = rgb <132/255, 63/255, 91/255>;
#declare CN_Ancient_Ruins = rgb <224/255, 202/255, 192/255>;
#declare CN_Ancient_Scroll = rgb <245/255, 230/255, 222/255>;
#declare CN_Ancient_Shelter = rgb <131/255, 105/255, 110/255>;
#declare CN_Ancient_Stone = rgb <222/255, 216/255, 212/255>;
#declare CN_Ancient_Yellow = rgb <238/255, 205/255, 0/255>;
#declare CN_Andean_Opal_Green = rgb <175/255, 205/255, 199/255>;
#declare CN_Andean_Slate = rgb <144/255, 177/255, 157/255>;
#declare CN_Andes_Ash = rgb <193/255, 160/255, 151/255>;
#declare CN_Andes_Sky = rgb <120/255, 216/255, 217/255>;
#declare CN_Andiron = rgb <66/255, 64/255, 54/255>;
#declare CN_Andorra = rgb <96/255, 53/255, 53/255>;
#declare CN_Andouille = rgb <181/255, 131/255, 56/255>;
#declare CN_Andover_Cream = rgb <250/255, 240/255, 211/255>;
#declare CN_Andrea_Blue = rgb <68/255, 119/255, 221/255>;
#declare CN_Android_Green = rgb <164/255, 198/255, 57/255>;
#declare CN_Andromeda_Blue = rgb <171/255, 205/255, 238/255>;
#declare CN_Anemone = rgb <132/255, 44/255, 72/255>;
#declare CN_Anemone_White = rgb <249/255, 239/255, 228/255>;
#declare CN_Anew_Gray = rgb <190/255, 182/255, 171/255>;
#declare CN_Angel_Aura = rgb <175/255, 168/255, 174/255>;
#declare CN_Angel_Blue = rgb <131/255, 197/255, 205/255>;
#declare CN_Angel_Blush = rgb <247/255, 227/255, 218/255>;
#declare CN_Angel_Breath = rgb <220/255, 175/255, 159/255>;
#declare CN_Angel_Face_Rose = rgb <254/255, 131/255, 204/255>;
#declare CN_Angel_Falls = rgb <163/255, 189/255, 211/255>;
#declare CN_Angel_Feather = rgb <244/255, 239/255, 238/255>;
#declare CN_Angel_Finger = rgb <184/255, 172/255, 180/255>;
#declare CN_Angel_Food = rgb <240/255, 232/255, 217/255>;
#declare CN_Angel_Food_Cake = rgb <215/255, 161/255, 79/255>;
#declare CN_Angel_Green = rgb <0/255, 66/255, 37/255>;
#declare CN_Angel_Hair_Silver = rgb <210/255, 214/255, 219/255>;
#declare CN_Angel_Heart = rgb <161/255, 119/255, 145/255>;
#declare CN_Angel_in_Blue_Jeans = rgb <187/255, 198/255, 217/255>;
#declare CN_Angel_Kiss = rgb <206/255, 199/255, 220/255>;
#declare CN_Angel_of_Death_Victorious = rgb <198/255, 240/255, 231/255>;
#declare CN_Angel_Shark = rgb <225/255, 150/255, 64/255>;
#declare CN_Angel_Wing = rgb <243/255, 223/255, 215/255>;
#declare CN_Angels_Face = rgb <238/255, 212/255, 200/255>;
#declare CN_Angels_Feather = rgb <243/255, 241/255, 230/255>;
#declare CN_Angels_Whisper = rgb <219/255, 223/255, 212/255>;
#declare CN_Angela_Bay = rgb <169/255, 193/255, 229/255>;
#declare CN_Angela_Canyon = rgb <201/255, 153/255, 151/255>;
#declare CN_Angelic = rgb <242/255, 220/255, 215/255>;
#declare CN_Angelic_Blue = rgb <187/255, 198/255, 214/255>;
#declare CN_Angelic_Choir = rgb <233/255, 217/255, 220/255>;
#declare CN_Angelic_Descent = rgb <238/255, 204/255, 51/255>;
#declare CN_Angelic_Eyes = rgb <187/255, 209/255, 232/255>;
#declare CN_Angelic_Sent = rgb <227/255, 223/255, 234/255>;
#declare CN_Angelic_Starlet = rgb <235/255, 233/255, 216/255>;
#declare CN_Angelic_White = rgb <244/255, 237/255, 228/255>;
#declare CN_Angelico = rgb <234/255, 207/255, 194/255>;
#declare CN_Angelique_Grey = rgb <216/255, 222/255, 231/255>;
#declare CN_Anger = rgb <221/255, 0/255, 85/255>;
#declare CN_Angora = rgb <223/255, 209/255, 187/255>;
#declare CN_Angora_Blue = rgb <185/255, 198/255, 216/255>;
#declare CN_Angora_Goat = rgb <237/255, 231/255, 222/255>;
#declare CN_Angora_Pink = rgb <235/255, 223/255, 234/255>;
#declare CN_Angraecum_Orchid = rgb <244/255, 246/255, 236/255>;
#declare CN_Angry_Flamingo = rgb <240/255, 78/255, 69/255>;
#declare CN_Angry_Gargoyle = rgb <151/255, 153/255, 166/255>;
#declare CN_Angry_Ghost = rgb <238/255, 187/255, 187/255>;
#declare CN_Angry_Gremlin = rgb <55/255, 80/255, 61/255>;
#declare CN_Angry_Hornet = rgb <238/255, 153/255, 17/255>;
#declare CN_Angry_Ocean = rgb <78/255, 102/255, 101/255>;
#declare CN_Angry_Pasta = rgb <255/255, 204/255, 85/255>;
#declare CN_Aniline_Mauve = rgb <185/255, 171/255, 173/255>;
#declare CN_Animal_Blood = rgb <164/255, 19/255, 19/255>;
#declare CN_Animal_Cracker = rgb <244/255, 230/255, 206/255>;
#declare CN_Animal_Kingdom = rgb <188/255, 192/255, 158/255>;
#declare CN_Animated_Coral = rgb <237/255, 144/255, 128/255>;
#declare CN_Animation = rgb <29/255, 92/255, 131/255>;
#declare CN_Anime = rgb <204/255, 193/255, 77/255>;
#declare CN_Anise_Biscotti = rgb <192/255, 186/255, 175/255>;
#declare CN_Anise_Flower = rgb <244/255, 227/255, 181/255>;
#declare CN_Anise_Grey_Yellow = rgb <176/255, 172/255, 152/255>;
#declare CN_Aniseed_Leaf_Green = rgb <140/255, 182/255, 132/255>;
#declare CN_Anita = rgb <145/255, 160/255, 183/255>;
#declare CN_Anjou_Pear = rgb <205/255, 202/255, 159/255>;
#declare CN_Annabel = rgb <247/255, 239/255, 207/255>;
#declare CN_Annapolis_Blue = rgb <56/255, 74/255, 102/255>;
#declare CN_Annis = rgb <107/255, 71/255, 93/255>;
#declare CN_Annular = rgb <225/255, 120/255, 97/255>;
#declare CN_Anode = rgb <137/255, 164/255, 205/255>;
#declare CN_Anon = rgb <189/255, 191/255, 200/255>;
#declare CN_Anonymous = rgb <218/255, 220/255, 211/255>;
#declare CN_Another_One_Bites_the_Dust = rgb <199/255, 187/255, 164/255>;
#declare CN_Ant_Red = rgb <176/255, 93/255, 74/255>;
#declare CN_Antarctic_Blue = rgb <43/255, 63/255, 92/255>;
#declare CN_Antarctic_Circle = rgb <0/255, 0/255, 187/255>;
#declare CN_Antarctic_Deep = rgb <53/255, 56/255, 63/255>;
#declare CN_Antarctica = rgb <198/255, 197/255, 198/255>;
#declare CN_Antarctica_Lake = rgb <191/255, 210/255, 208/255>;
#declare CN_Antelope = rgb <177/255, 150/255, 100/255>;
#declare CN_Anthill = rgb <127/255, 104/255, 78/255>;
#declare CN_Anthracite = rgb <40/255, 40/255, 45/255>;
#declare CN_Anthracite_Blue = rgb <61/255, 71/255, 94/255>;
#declare CN_Anthracite_Grey = rgb <55/255, 63/255, 66/255>;
#declare CN_Anthracite_Red = rgb <115/255, 41/255, 59/255>;
#declare CN_Anti_Rainbow_Grey = rgb <190/255, 189/255, 188/255>;
#declare CN_Anti_Flash_White = rgb <242/255, 243/255, 244/255>;
#declare CN_Antigua = rgb <37/255, 109/255, 115/255>;
#declare CN_Antigua_Blue = rgb <6/255, 177/255, 196/255>;
#declare CN_Antigua_Sand = rgb <131/255, 194/255, 205/255>;
#declare CN_Antigua_Sunrise = rgb <255/255, 231/255, 200/255>;
#declare CN_Antilles_Blue = rgb <59/255, 94/255, 141/255>;
#declare CN_Antilles_Garden = rgb <138/255, 162/255, 119/255>;
#declare CN_Antimony = rgb <199/255, 200/255, 193/255>;
#declare CN_Antiquarian_Brown = rgb <148/255, 102/255, 68/255>;
#declare CN_Antiquarian_Gold = rgb <186/255, 138/255, 69/255>;
#declare CN_Antiquate = rgb <141/255, 138/255, 160/255>;
#declare CN_Antique = rgb <139/255, 132/255, 109/255>;
#declare CN_Antique_Bear = rgb <156/255, 134/255, 123/255>;
#declare CN_Antique_Bourbon = rgb <146/255, 107/255, 67/255>;
#declare CN_Antique_Brass = rgb <108/255, 70/255, 31/255>;
#declare CN_Antique_Bronze = rgb <112/255, 74/255, 7/255>;
#declare CN_Antique_Brown = rgb <85/255, 63/255, 45/255>;
#declare CN_Antique_Cameo = rgb <240/255, 186/255, 164/255>;
#declare CN_Antique_Candle_Light = rgb <244/255, 225/255, 214/255>;
#declare CN_Antique_Chest = rgb <167/255, 133/255, 109/255>;
#declare CN_Antique_China = rgb <253/255, 246/255, 231/255>;
#declare CN_Antique_Coin = rgb <181/255, 184/255, 168/255>;
#declare CN_Antique_Copper = rgb <158/255, 102/255, 73/255>;
#declare CN_Antique_Coral = rgb <255/255, 199/255, 176/255>;
#declare CN_Antique_Earth = rgb <126/255, 108/255, 95/255>;
#declare CN_Antique_Fuchsia = rgb <145/255, 92/255, 131/255>;
#declare CN_Antique_Garnet = rgb <142/255, 94/255, 94/255>;
#declare CN_Antique_Gold = rgb <181/255, 158/255, 95/255>;
#declare CN_Antique_Green = rgb <41/255, 103/255, 92/255>;
#declare CN_Antique_Grey = rgb <105/255, 87/255, 109/255>;
#declare CN_Antique_Heather = rgb <205/255, 186/255, 203/255>;
#declare CN_Antique_Honey = rgb <179/255, 147/255, 85/255>;
#declare CN_Antique_Hot_Pink = rgb <176/255, 127/255, 158/255>;
#declare CN_Antique_Ivory = rgb <249/255, 236/255, 211/255>;
#declare CN_Antique_Lace = rgb <253/255, 242/255, 219/255>;
#declare CN_Antique_Leather = rgb <158/255, 142/255, 126/255>;
#declare CN_Antique_Linen = rgb <250/255, 238/255, 219/255>;
#declare CN_Antique_Marble = rgb <241/255, 233/255, 215/255>;
#declare CN_Antique_Mauve = rgb <187/255, 176/255, 177/255>;
#declare CN_Antique_Moss = rgb <122/255, 151/255, 59/255>;
#declare CN_Antique_Paper = rgb <244/255, 240/255, 232/255>;
#declare CN_Antique_Parchment = rgb <234/255, 216/255, 193/255>;
#declare CN_Antique_Pearl = rgb <235/255, 215/255, 203/255>;
#declare CN_Antique_Penny = rgb <149/255, 119/255, 71/255>;
#declare CN_Antique_Petal = rgb <232/255, 227/255, 227/255>;
#declare CN_Antique_Pink = rgb <194/255, 122/255, 116/255>;
#declare CN_Antique_Red = rgb <125/255, 79/255, 81/255>;
#declare CN_Antique_Rose = rgb <153/255, 113/255, 101/255>;
#declare CN_Antique_Rosewood = rgb <114/255, 57/255, 63/255>;
#declare CN_Antique_Ruby = rgb <132/255, 27/255, 45/255>;
#declare CN_Antique_Silver = rgb <145/255, 142/255, 140/255>;
#declare CN_Antique_Tin = rgb <110/255, 113/255, 115/255>;
#declare CN_Antique_Treasure = rgb <187/255, 153/255, 115/255>;
#declare CN_Antique_Turquoise = rgb <0/255, 78/255, 78/255>;
#declare CN_Antique_Viola = rgb <146/255, 139/255, 166/255>;
#declare CN_Antique_White = rgb <236/255, 230/255, 213/255>;
#declare CN_Antique_Wicker_Basket = rgb <243/255, 211/255, 161/255>;
#declare CN_Antique_Windmill = rgb <182/255, 163/255, 141/255>;
#declare CN_Antiqued_Aqua = rgb <189/255, 204/255, 193/255>;
#declare CN_Antiquities = rgb <138/255, 108/255, 87/255>;
#declare CN_Antiquity = rgb <193/255, 168/255, 124/255>;
#declare CN_Antler = rgb <149/255, 122/255, 118/255>;
#declare CN_Antler_Moth = rgb <134/255, 79/255, 62/255>;
#declare CN_Antler_Velvet = rgb <192/255, 173/255, 150/255>;
#declare CN_Antoinette = rgb <176/255, 147/255, 145/255>;
#declare CN_Antoinette_Pink = rgb <231/255, 194/255, 180/255>;
#declare CN_Anubis_Black = rgb <49/255, 34/255, 49/255>;
#declare CN_Anzac = rgb <198/255, 142/255, 63/255>;
#declare CN_Ao = rgb <0/255, 128/255, 12/255>;
#declare CN_Aoifes_Green = rgb <39/255, 182/255, 146/255>;
#declare CN_Aotake_Bamboo = rgb <0/255, 100/255, 66/255>;
#declare CN_Apatite_Blue = rgb <49/255, 130/255, 123/255>;
#declare CN_Apatite_Crystal_Green = rgb <187/255, 255/255, 153/255>;
#declare CN_Apeland = rgb <138/255, 132/255, 59/255>;
#declare CN_Aphrodites_Pearls = rgb <238/255, 255/255, 255/255>;
#declare CN_Aphroditean_Fuschia = rgb <221/255, 20/255, 171/255>;
#declare CN_Apium = rgb <181/255, 208/255, 162/255>;
#declare CN_Apnea_Dive = rgb <40/255, 79/255, 189/255>;
#declare CN_Apocalyptic_Orange = rgb <244/255, 113/255, 30/255>;
#declare CN_Apocyan = rgb <153/255, 204/255, 255/255>;
#declare CN_Apollo_Bay = rgb <116/255, 134/255, 151/255>;
#declare CN_Apollo_Landing = rgb <229/255, 229/255, 225/255>;
#declare CN_Apollos_White = rgb <221/255, 255/255, 255/255>;
#declare CN_Appalachian_Forest = rgb <132/255, 139/255, 128/255>;
#declare CN_Appalachian_Trail = rgb <207/255, 185/255, 137/255>;
#declare CN_Appaloosa_Spots = rgb <135/255, 110/255, 82/255>;
#declare CN_Apparition = rgb <194/255, 188/255, 169/255>;
#declare CN_Appetite = rgb <177/255, 229/255, 170/255>;
#declare CN_Appetizing_Asparagus = rgb <102/255, 170/255, 0/255>;
#declare CN_Applause_Please = rgb <133/255, 140/255, 155/255>;
#declare CN_Apple_Blossom = rgb <221/255, 188/255, 160/255>;
#declare CN_Apple_Bob = rgb <213/255, 230/255, 157/255>;
#declare CN_Apple_Brown_Betty = rgb <156/255, 103/255, 87/255>;
#declare CN_Apple_Butter = rgb <132/255, 75/255, 77/255>;
#declare CN_Apple_Cherry = rgb <248/255, 20/255, 4/255>;
#declare CN_Apple_Cider = rgb <218/255, 153/255, 95/255>;
#declare CN_Apple_Cinnamon = rgb <176/255, 136/255, 90/255>;
#declare CN_Apple_Core = rgb <244/255, 238/255, 216/255>;
#declare CN_Apple_Cream = rgb <184/255, 215/255, 166/255>;
#declare CN_Apple_Crisp = rgb <225/255, 156/255, 85/255>;
#declare CN_Apple_Crunch = rgb <254/255, 229/255, 201/255>;
#declare CN_Apple_Cucumber = rgb <219/255, 219/255, 188/255>;
#declare CN_Apple_Custard = rgb <253/255, 223/255, 174/255>;
#declare CN_Apple_Day = rgb <126/255, 151/255, 109/255>;
#declare CN_Apple_Flower = rgb <237/255, 244/255, 235/255>;
#declare CN_Apple_Green = rgb <118/255, 205/255, 38/255>;
#declare CN_Apple_Herb_Black = rgb <75/255, 66/255, 71/255>;
#declare CN_Apple_Hill = rgb <166/255, 159/255, 141/255>;
#declare CN_Apple_Ice = rgb <189/255, 208/255, 177/255>;
#declare CN_Apple_II_Beige = rgb <191/255, 202/255, 135/255>;
#declare CN_Apple_II_Blue = rgb <147/255, 214/255, 191/255>;
#declare CN_Apple_II_Chocolate = rgb <218/255, 104/255, 14/255>;
#declare CN_Apple_II_Green = rgb <4/255, 101/255, 13/255>;
#declare CN_Apple_II_Lime = rgb <37/255, 196/255, 13/255>;
#declare CN_Apple_II_Magenta = rgb <220/255, 65/255, 241/255>;
#declare CN_Apple_II_Rose = rgb <172/255, 102/255, 123/255>;
#declare CN_Apple_Infusion = rgb <221/255, 170/255, 187/255>;
#declare CN_Apple_Jack = rgb <139/255, 151/255, 78/255>;
#declare CN_Apple_Martini = rgb <249/255, 253/255, 217/255>;
#declare CN_Apple_Orchard = rgb <147/255, 201/255, 106/255>;
#declare CN_Apple_Pie = rgb <202/255, 171/255, 148/255>;
#declare CN_Apple_Polish = rgb <136/255, 62/255, 63/255>;
#declare CN_Apple_Sauce = rgb <244/255, 235/255, 210/255>;
#declare CN_Apple_Seed = rgb <167/255, 124/255, 83/255>;
#declare CN_Apple_Slice = rgb <241/255, 240/255, 191/255>;
#declare CN_Apple_Turnover = rgb <232/255, 193/255, 148/255>;
#declare CN_Apple_Valley = rgb <234/255, 131/255, 134/255>;
#declare CN_Apple_Wine = rgb <181/255, 159/255, 98/255>;
#declare CN_Apple_A_Day = rgb <144/255, 63/255, 69/255>;
#declare CN_Appleblossom = rgb <218/255, 181/255, 180/255>;
#declare CN_Applegate = rgb <138/255, 196/255, 121/255>;
#declare CN_Applegate_Park = rgb <174/255, 173/255, 147/255>;
#declare CN_Applemint = rgb <205/255, 234/255, 205/255>;
#declare CN_Applemint_Soda = rgb <243/255, 245/255, 233/255>;
#declare CN_Applesauce = rgb <246/255, 214/255, 153/255>;
#declare CN_Applesauce_Cake = rgb <194/255, 163/255, 119/255>;
#declare CN_Appletini = rgb <146/255, 150/255, 55/255>;
#declare CN_Appleton = rgb <110/255, 180/255, 120/255>;
#declare CN_Approaching_Dusk = rgb <139/255, 151/255, 165/255>;
#declare CN_Approval_Green = rgb <3/255, 148/255, 135/255>;
#declare CN_Apricot = rgb <255/255, 177/255, 109/255>;
#declare CN_Apricot_Appeal = rgb <254/255, 195/255, 130/255>;
#declare CN_Apricot_Blush = rgb <254/255, 174/255, 165/255>;
#declare CN_Apricot_Brandy = rgb <194/255, 106/255, 90/255>;
#declare CN_Apricot_Brown = rgb <204/255, 126/255, 91/255>;
#declare CN_Apricot_Buff = rgb <205/255, 126/255, 77/255>;
#declare CN_Apricot_Chicken = rgb <218/255, 137/255, 35/255>;
#declare CN_Apricot_Cream = rgb <241/255, 189/255, 137/255>;
#declare CN_Apricot_Flower = rgb <255/255, 187/255, 128/255>;
#declare CN_Apricot_Foam = rgb <238/255, 222/255, 216/255>;
#declare CN_Apricot_Fool = rgb <255/255, 210/255, 160/255>;
#declare CN_Apricot_Freeze = rgb <243/255, 207/255, 183/255>;
#declare CN_Apricot_Gelato = rgb <245/255, 215/255, 175/255>;
#declare CN_Apricot_Glazed_Chicken = rgb <238/255, 170/255, 34/255>;
#declare CN_Apricot_Glow = rgb <255/255, 206/255, 121/255>;
#declare CN_Apricot_Ice = rgb <255/255, 246/255, 233/255>;
#declare CN_Apricot_Ice_Cream = rgb <248/255, 204/255, 156/255>;
#declare CN_Apricot_Iced_Tea = rgb <251/255, 190/255, 153/255>;
#declare CN_Apricot_Illusion = rgb <226/255, 196/255, 166/255>;
#declare CN_Apricot_Jam = rgb <238/255, 167/255, 113/255>;
#declare CN_Apricot_Light = rgb <255/255, 202/255, 149/255>;
#declare CN_Apricot_Lily = rgb <254/255, 207/255, 181/255>;
#declare CN_Apricot_Mix = rgb <180/255, 119/255, 86/255>;
#declare CN_Apricot_Mousse = rgb <252/255, 223/255, 175/255>;
#declare CN_Apricot_Nectar = rgb <236/255, 170/255, 121/255>;
#declare CN_Apricot_Obsession = rgb <248/255, 196/255, 180/255>;
#declare CN_Apricot_Orange = rgb <200/255, 107/255, 60/255>;
#declare CN_Apricot_Preserves = rgb <238/255, 177/255, 146/255>;
#declare CN_Apricot_Red = rgb <232/255, 145/255, 125/255>;
#declare CN_Apricot_Sherbet = rgb <250/255, 205/255, 158/255>;
#declare CN_Apricot_Sorbet = rgb <232/255, 167/255, 96/255>;
#declare CN_Apricot_Spring = rgb <241/255, 179/255, 147/255>;
#declare CN_Apricot_Tan = rgb <221/255, 151/255, 96/255>;
#declare CN_Apricot_Wash = rgb <251/255, 172/255, 130/255>;
#declare CN_Apricot_White = rgb <247/255, 240/255, 219/255>;
#declare CN_Apricot_Yellow = rgb <247/255, 189/255, 129/255>;
#declare CN_Apricotta = rgb <216/255, 164/255, 143/255>;
#declare CN_April_Blush = rgb <246/255, 208/255, 216/255>;
#declare CN_April_Fools_Red = rgb <31/255, 181/255, 122/255>;
#declare CN_April_Green = rgb <169/255, 176/255, 98/255>;
#declare CN_April_Love = rgb <139/255, 61/255, 47/255>;
#declare CN_April_Mist = rgb <204/255, 217/255, 201/255>;
#declare CN_April_Showers = rgb <218/255, 222/255, 181/255>;
#declare CN_April_Sunshine = rgb <251/255, 225/255, 152/255>;
#declare CN_April_Tears = rgb <180/255, 203/255, 212/255>;
#declare CN_April_Wedding = rgb <197/255, 207/255, 177/255>;
#declare CN_April_Winds = rgb <213/255, 226/255, 229/255>;
#declare CN_Aqua = rgb <0/255, 255/255, 255/255>;
#declare CN_Aqua_Bay = rgb <181/255, 223/255, 201/255>;
#declare CN_Aqua_Belt = rgb <122/255, 202/255, 208/255>;
#declare CN_Aqua_Bloom = rgb <150/255, 211/255, 216/255>;
#declare CN_Aqua_Blue = rgb <121/255, 182/255, 188/255>;
#declare CN_Aqua_Breeze = rgb <216/255, 232/255, 228/255>;
#declare CN_Aqua_Clear = rgb <139/255, 208/255, 221/255>;
#declare CN_Aqua_Cyan = rgb <1/255, 241/255, 241/255>;
#declare CN_Aqua_Deep = rgb <1/255, 75/255, 67/255>;
#declare CN_Aqua_Eden = rgb <133/255, 199/255, 166/255>;
#declare CN_Aqua_Experience = rgb <3/255, 142/255, 133/255>;
#declare CN_Aqua_Fiesta = rgb <140/255, 195/255, 195/255>;
#declare CN_Aqua_Foam = rgb <173/255, 195/255, 180/255>;
#declare CN_Aqua_Forest = rgb <95/255, 167/255, 119/255>;
#declare CN_Aqua_Fresco = rgb <74/255, 159/255, 163/255>;
#declare CN_Aqua_Frost = rgb <169/255, 209/255, 215/255>;
#declare CN_Aqua_Glass = rgb <210/255, 232/255, 224/255>;
#declare CN_Aqua_Green = rgb <18/255, 225/255, 147/255>;
#declare CN_Aqua_Grey = rgb <136/255, 159/255, 165/255>;
#declare CN_Aqua_Haze = rgb <217/255, 221/255, 213/255>;
#declare CN_Aqua_Island = rgb <161/255, 218/255, 215/255>;
#declare CN_Aqua_Lake = rgb <48/255, 148/255, 157/255>;
#declare CN_Aqua_Mist = rgb <160/255, 201/255, 203/255>;
#declare CN_Aqua_Nation = rgb <8/255, 120/255, 127/255>;
#declare CN_Aqua_Oasis = rgb <188/255, 232/255, 221/255>;
#declare CN_Aqua_Obscura = rgb <5/255, 105/255, 107/255>;
#declare CN_Aqua_Pura = rgb <221/255, 242/255, 238/255>;
#declare CN_Aqua_Rapids = rgb <99/255, 163/255, 156/255>;
#declare CN_Aqua_Revival = rgb <83/255, 159/255, 145/255>;
#declare CN_Aqua_Sea = rgb <107/255, 170/255, 174/255>;
#declare CN_Aqua_Sky = rgb <123/255, 196/255, 196/255>;
#declare CN_Aqua_Smoke = rgb <140/255, 159/255, 160/255>;
#declare CN_Aqua_Sparkle = rgb <211/255, 228/255, 230/255>;
#declare CN_Aqua_Splash = rgb <133/255, 206/255, 209/255>;
#declare CN_Aqua_Spray = rgb <165/255, 221/255, 219/255>;
#declare CN_Aqua_Spring = rgb <232/255, 243/255, 232/255>;
#declare CN_Aqua_Squeeze = rgb <219/255, 228/255, 220/255>;
#declare CN_Aqua_Tint = rgb <229/255, 241/255, 238/255>;
#declare CN_Aqua_Velvet = rgb <0/255, 162/255, 158/255>;
#declare CN_Aqua_Verde = rgb <86/255, 179/255, 195/255>;
#declare CN_Aqua_Vitale = rgb <123/255, 189/255, 199/255>;
#declare CN_Aqua_Waters = rgb <0/255, 147/255, 125/255>;
#declare CN_Aqua_Whisper = rgb <191/255, 223/255, 223/255>;
#declare CN_Aqua_Wish = rgb <160/255, 227/255, 209/255>;
#declare CN_Aqua_Zing = rgb <124/255, 216/255, 214/255>;
#declare CN_Aqua_Sphere = rgb <156/255, 176/255, 179/255>;
#declare CN_Aquacade = rgb <225/255, 240/255, 234/255>;
#declare CN_Aquadazzle = rgb <0/255, 111/255, 73/255>;
#declare CN_Aquadulce = rgb <123/255, 159/255, 130/255>;
#declare CN_Aqualogic = rgb <87/255, 183/255, 197/255>;
#declare CN_Aquamarine = rgb <46/255, 232/255, 187/255>;
#declare CN_Aquamarine_Blue = rgb <113/255, 217/255, 226/255>;
#declare CN_Aquamarine_Dream = rgb <179/255, 196/255, 186/255>;
#declare CN_Aquamarine_Ocean = rgb <130/255, 205/255, 173/255>;
#declare CN_Aquamentus_Green = rgb <0/255, 168/255, 0/255>;
#declare CN_Aquarelle = rgb <97/255, 170/255, 177/255>;
#declare CN_Aquarelle_Beige = rgb <232/255, 224/255, 213/255>;
#declare CN_Aquarelle_Blue = rgb <191/255, 224/255, 228/255>;
#declare CN_Aquarelle_Green = rgb <226/255, 244/255, 228/255>;
#declare CN_Aquarelle_Lilac = rgb <237/255, 200/255, 255/255>;
#declare CN_Aquarelle_Mint = rgb <219/255, 244/255, 216/255>;
#declare CN_Aquarelle_Orange = rgb <251/255, 232/255, 224/255>;
#declare CN_Aquarelle_Pink = rgb <251/255, 233/255, 222/255>;
#declare CN_Aquarelle_Purple = rgb <216/255, 225/255, 241/255>;
#declare CN_Aquarelle_Red = rgb <254/255, 221/255, 221/255>;
#declare CN_Aquarelle_Sky = rgb <188/255, 228/255, 235/255>;
#declare CN_Aquarelle_Yellow = rgb <244/255, 238/255, 218/255>;
#declare CN_Aquarium = rgb <53/255, 107/255, 111/255>;
#declare CN_Aquarium_Blue = rgb <102/255, 205/255, 170/255>;
#declare CN_Aquarium_Diver = rgb <10/255, 152/255, 172/255>;
#declare CN_Aquarius = rgb <60/255, 173/255, 212/255>;
#declare CN_Aquarius_Reef_Base = rgb <85/255, 153/255, 153/255>;
#declare CN_Aquastone = rgb <137/255, 198/255, 183/255>;
#declare CN_Aquatic = rgb <153/255, 193/255, 204/255>;
#declare CN_Aquatic_Cool = rgb <65/255, 160/255, 180/255>;
#declare CN_Aquatic_Green = rgb <73/255, 153/255, 154/255>;
#declare CN_Aquatint = rgb <184/255, 231/255, 222/255>;
#declare CN_Aquatone = rgb <166/255, 181/255, 169/255>;
#declare CN_Aquaverde = rgb <163/255, 192/255, 189/255>;
#declare CN_Aqueduct = rgb <96/255, 179/255, 188/255>;
#declare CN_Aquella = rgb <89/255, 182/255, 217/255>;
#declare CN_Aqueous = rgb <56/255, 141/255, 149/255>;
#declare CN_Aquifer = rgb <226/255, 236/255, 237/255>;
#declare CN_Aquitaine = rgb <136/255, 171/255, 180/255>;
#declare CN_Arabella = rgb <130/255, 172/255, 196/255>;
#declare CN_Arabesque = rgb <209/255, 111/255, 82/255>;
#declare CN_Arabian_Bake = rgb <205/255, 153/255, 69/255>;
#declare CN_Arabian_Red = rgb <161/255, 76/255, 63/255>;
#declare CN_Arabian_Sands = rgb <221/255, 198/255, 177/255>;
#declare CN_Arabian_Silk = rgb <120/255, 110/255, 151/255>;
#declare CN_Arabian_Spice = rgb <136/255, 67/255, 50/255>;
#declare CN_Arabian_Veil = rgb <201/255, 255/255, 250/255>;
#declare CN_Arabic_Coffee = rgb <111/255, 77/255, 63/255>;
#declare CN_Arabica_Mint = rgb <192/255, 255/255, 238/255>;
#declare CN_Arable_Brown = rgb <122/255, 85/255, 46/255>;
#declare CN_Aragon = rgb <176/255, 100/255, 85/255>;
#declare CN_Aragon_Green = rgb <71/255, 186/255, 135/255>;
#declare CN_Aragonite = rgb <228/255, 224/255, 212/255>;
#declare CN_Aragonite_Blue = rgb <106/255, 149/255, 177/255>;
#declare CN_Aragonite_Grey = rgb <148/255, 142/255, 150/255>;
#declare CN_Aragonite_White = rgb <243/255, 241/255, 243/255>;
#declare CN_Araigaki_Orange = rgb <236/255, 130/255, 84/255>;
#declare CN_Arame_Seaweed_Green = rgb <63/255, 70/255, 53/255>;
#declare CN_Arapawa = rgb <39/255, 74/255, 93/255>;
#declare CN_Arathi_Highlands = rgb <147/255, 163/255, 68/255>;
#declare CN_Araucana_Egg = rgb <173/255, 216/255, 225/255>;
#declare CN_Arava = rgb <161/255, 141/255, 113/255>;
#declare CN_Arbol_De_Tamarindo = rgb <205/255, 161/255, 130/255>;
#declare CN_Arbor_Hollow = rgb <193/255, 194/255, 180/255>;
#declare CN_Arbor_Vitae = rgb <187/255, 195/255, 173/255>;
#declare CN_Arboretum = rgb <112/255, 186/255, 159/255>;
#declare CN_Arc_Light = rgb <204/255, 221/255, 255/255>;
#declare CN_Arcade_Fire = rgb <238/255, 51/255, 17/255>;
#declare CN_Arcade_Glow = rgb <0/255, 34/255, 204/255>;
#declare CN_Arcade_White = rgb <237/255, 235/255, 226/255>;
#declare CN_Arcadia = rgb <0/255, 162/255, 138/255>;
#declare CN_Arcadian_Green = rgb <163/255, 200/255, 147/255>;
#declare CN_Arcala_Green = rgb <59/255, 108/255, 63/255>;
#declare CN_Arcane = rgb <152/255, 104/255, 126/255>;
#declare CN_Arcavia_Red = rgb <106/255, 0/255, 2/255>;
#declare CN_Archaeological_Site = rgb <142/255, 120/255, 92/255>;
#declare CN_Archeology = rgb <110/255, 106/255, 94/255>;
#declare CN_Architecture_Blue = rgb <113/255, 149/255, 166/255>;
#declare CN_Architecture_Grey = rgb <107/255, 106/255, 105/255>;
#declare CN_Archivist = rgb <159/255, 140/255, 115/255>;
#declare CN_Arctic = rgb <100/255, 133/255, 137/255>;
#declare CN_Arctic_Blue = rgb <149/255, 214/255, 220/255>;
#declare CN_Arctic_Cotton = rgb <230/255, 227/255, 223/255>;
#declare CN_Arctic_Daisy = rgb <235/255, 228/255, 190/255>;
#declare CN_Arctic_Dawn = rgb <227/255, 229/255, 232/255>;
#declare CN_Arctic_Dusk = rgb <115/255, 91/255, 106/255>;
#declare CN_Arctic_Feelings = rgb <175/255, 190/255, 193/255>;
#declare CN_Arctic_Flow = rgb <218/255, 234/255, 228/255>;
#declare CN_Arctic_Fox = rgb <231/255, 231/255, 226/255>;
#declare CN_Arctic_Glow = rgb <201/255, 209/255, 233/255>;
#declare CN_Arctic_Green = rgb <69/255, 188/255, 179/255>;
#declare CN_Arctic_Grey = rgb <187/255, 204/255, 221/255>;
#declare CN_Arctic_Ice = rgb <191/255, 199/255, 214/255>;
#declare CN_Arctic_Lichen_Green = rgb <111/255, 120/255, 114/255>;
#declare CN_Arctic_Lime = rgb <208/255, 255/255, 20/255>;
#declare CN_Arctic_Nights = rgb <52/255, 92/255, 97/255>;
#declare CN_Arctic_Ocean = rgb <102/255, 195/255, 208/255>;
#declare CN_Arctic_Paradise = rgb <184/255, 223/255, 248/255>;
#declare CN_Arctic_Rose = rgb <183/255, 171/255, 176/255>;
#declare CN_Arctic_Shadow = rgb <217/255, 229/255, 235/255>;
#declare CN_Arctic_Water = rgb <0/255, 252/255, 252/255>;
#declare CN_Arctic_White = rgb <233/255, 234/255, 231/255>;
#declare CN_Ardcoat = rgb <226/255, 222/255, 223/255>;
#declare CN_Ardent_Coral = rgb <229/255, 117/255, 106/255>;
#declare CN_Ardosia = rgb <35/255, 47/255, 44/255>;
#declare CN_Ares_Red = rgb <221/255, 34/255, 0/255>;
#declare CN_Ares_Shadow = rgb <98/255, 88/255, 76/255>;
#declare CN_Argan_Oil = rgb <139/255, 89/255, 62/255>;
#declare CN_Argent = rgb <136/255, 136/255, 136/255>;
#declare CN_Argos = rgb <189/255, 189/255, 183/255>;
#declare CN_Argyle = rgb <52/255, 138/255, 93/255>;
#declare CN_Argyle_Purple = rgb <137/255, 92/255, 121/255>;
#declare CN_Argyle_Rose = rgb <196/255, 134/255, 119/255>;
#declare CN_Aria = rgb <227/255, 228/255, 226/255>;
#declare CN_Aria_Ivory = rgb <249/255, 232/255, 216/255>;
#declare CN_Arid_Landscape = rgb <220/255, 214/255, 198/255>;
#declare CN_Arid_Plains = rgb <182/255, 180/255, 169/255>;
#declare CN_Ariel = rgb <174/255, 215/255, 234/255>;
#declare CN_Ariels_Delight = rgb <178/255, 165/255, 211/255>;
#declare CN_Aristocrat_Ivory = rgb <250/255, 240/255, 223/255>;
#declare CN_Aristocrat_Peach = rgb <236/255, 206/255, 185/255>;
#declare CN_Aristocratic_Pink = rgb <221/255, 170/255, 204/255>;
#declare CN_Arizona = rgb <238/255, 179/255, 119/255>;
#declare CN_Arizona_Clay = rgb <173/255, 115/255, 90/255>;
#declare CN_Arizona_Stone = rgb <0/255, 101/255, 90/255>;
#declare CN_Arizona_Sunrise = rgb <235/255, 188/255, 185/255>;
#declare CN_Arizona_Tan = rgb <229/255, 188/255, 130/255>;
#declare CN_Arizona_Tree_Frog = rgb <102/255, 146/255, 100/255>;
#declare CN_Armada = rgb <83/255, 103/255, 98/255>;
#declare CN_Armadillo = rgb <72/255, 74/255, 70/255>;
#declare CN_Armadillo_Egg = rgb <125/255, 70/255, 56/255>;
#declare CN_Armageddon_Dunes = rgb <146/255, 106/255, 37/255>;
#declare CN_Armageddon_Dust = rgb <211/255, 169/255, 7/255>;
#declare CN_Armagnac = rgb <173/255, 145/255, 108/255>;
#declare CN_Armor = rgb <116/255, 133/255, 127/255>;
#declare CN_Armor_Wash = rgb <3/255, 3/255, 3/255>;
#declare CN_Armored_Steel = rgb <116/255, 119/255, 105/255>;
#declare CN_Armory = rgb <106/255, 107/255, 101/255>;
#declare CN_Army_Canvas = rgb <91/255, 111/255, 97/255>;
#declare CN_Army_Green = rgb <75/255, 83/255, 32/255>;
#declare CN_Army_Issue = rgb <138/255, 128/255, 107/255>;
#declare CN_Army_Issue_Green = rgb <131/255, 130/255, 84/255>;
#declare CN_Arnica = rgb <191/255, 143/255, 55/255>;
#declare CN_Arnica_Yellow = rgb <229/255, 155/255, 0/255>;
#declare CN_Aroma = rgb <211/255, 193/255, 197/255>;
#declare CN_Aroma_Blue = rgb <150/255, 210/255, 214/255>;
#declare CN_Aroma_Garden = rgb <161/255, 196/255, 168/255>;
#declare CN_Aromatic = rgb <112/255, 105/255, 134/255>;
#declare CN_Aromatic_Breeze = rgb <255/255, 206/255, 203/255>;
#declare CN_Arona = rgb <135/255, 155/255, 163/255>;
#declare CN_Arousing_Alligator = rgb <119/255, 102/255, 0/255>;
#declare CN_Arraign = rgb <92/255, 84/255, 110/255>;
#declare CN_Arresting_Auburn = rgb <90/255, 53/255, 50/255>;
#declare CN_Arrow_Creek = rgb <146/255, 114/255, 87/255>;
#declare CN_Arrow_Quiver = rgb <199/255, 169/255, 152/255>;
#declare CN_Arrow_Rock = rgb <162/255, 132/255, 64/255>;
#declare CN_Arrow_Shaft = rgb <92/255, 80/255, 58/255>;
#declare CN_Arrowhead = rgb <81/255, 75/255, 64/255>;
#declare CN_Arrowhead_Lake = rgb <88/255, 114/255, 138/255>;
#declare CN_Arrowhead_White = rgb <249/255, 234/255, 235/255>;
#declare CN_Arrowroot = rgb <248/255, 222/255, 207/255>;
#declare CN_Arrowroote = rgb <228/255, 222/255, 207/255>;
#declare CN_Arrowtown = rgb <130/255, 122/255, 103/255>;
#declare CN_Arrowwood = rgb <188/255, 141/255, 31/255>;
#declare CN_Arsenic = rgb <59/255, 68/255, 75/255>;
#declare CN_Art_and_Craft = rgb <137/255, 105/255, 86/255>;
#declare CN_Art_Deco_Pink = rgb <205/255, 172/255, 160/255>;
#declare CN_Art_Deco_Red = rgb <98/255, 55/255, 69/255>;
#declare CN_Art_District = rgb <148/255, 137/255, 124/255>;
#declare CN_Art_House_Pink = rgb <192/255, 111/255, 112/255>;
#declare CN_Art_Nouveau_Glass = rgb <162/255, 154/255, 160/255>;
#declare CN_Art_Nouveau_Green = rgb <156/255, 147/255, 47/255>;
#declare CN_Art_Nouveau_Violet = rgb <160/255, 137/255, 148/255>;
#declare CN_Artemis = rgb <210/255, 169/255, 110/255>;
#declare CN_Artemis_Silver = rgb <221/255, 221/255, 238/255>;
#declare CN_Artemisia = rgb <227/255, 235/255, 234/255>;
#declare CN_Arterial_Blood_Red = rgb <113/255, 21/255, 24/255>;
#declare CN_Artesian_Pool = rgb <166/255, 190/255, 225/255>;
#declare CN_Artesian_Water = rgb <0/255, 125/255, 182/255>;
#declare CN_Artesian_Well = rgb <94/255, 178/255, 170/255>;
#declare CN_Artful_Aqua = rgb <145/255, 180/255, 179/255>;
#declare CN_Artful_Magenta = rgb <128/255, 80/255, 93/255>;
#declare CN_Artichoke = rgb <143/255, 151/255, 121/255>;
#declare CN_Artichoke_Dip = rgb <161/255, 150/255, 118/255>;
#declare CN_Artichoke_Green = rgb <75/255, 109/255, 65/255>;
#declare CN_Artichoke_Mauve = rgb <193/255, 154/255, 165/255>;
#declare CN_Artifact = rgb <202/255, 157/255, 141/255>;
#declare CN_Artificial_Strawberry = rgb <255/255, 67/255, 164/255>;
#declare CN_Artificial_Turf = rgb <65/255, 180/255, 92/255>;
#declare CN_Artillery = rgb <116/255, 111/255, 103/255>;
#declare CN_Artisan = rgb <143/255, 92/255, 69/255>;
#declare CN_Artisan_Crafts = rgb <185/255, 151/255, 121/255>;
#declare CN_Artisan_Tan = rgb <176/255, 152/255, 121/255>;
#declare CN_Artisan_Tea = rgb <218/255, 194/255, 175/255>;
#declare CN_Artisan_Tile = rgb <132/255, 94/255, 64/255>;
#declare CN_Artisans_Gold = rgb <242/255, 171/255, 70/255>;
#declare CN_Artist_Blue = rgb <1/255, 52/255, 58/255>;
#declare CN_Artists_Canvas = rgb <238/255, 228/255, 210/255>;
#declare CN_Artists_Shadow = rgb <161/255, 150/255, 155/255>;
#declare CN_Artiste = rgb <152/255, 115/255, 135/255>;
#declare CN_Artistic_License = rgb <67/255, 64/255, 83/255>;
#declare CN_Artistic_Stone = rgb <92/255, 107/255, 101/255>;
#declare CN_Artistic_Taupe = rgb <195/255, 177/255, 172/255>;
#declare CN_Artistic_Violet = rgb <208/255, 210/255, 233/255>;
#declare CN_Arts__Crafts_Gold = rgb <245/255, 198/255, 139/255>;
#declare CN_Arts_and_Crafts = rgb <125/255, 101/255, 73/255>;
#declare CN_Aruba_Aqua = rgb <209/255, 222/255, 211/255>;
#declare CN_Aruba_Blue = rgb <129/255, 215/255, 211/255>;
#declare CN_Aruba_Green = rgb <84/255, 180/255, 144/255>;
#declare CN_Arugula = rgb <117/255, 173/255, 91/255>;
#declare CN_Arylide_Yellow = rgb <233/255, 214/255, 107/255>;
#declare CN_Asagi_Blue = rgb <72/255, 146/255, 155/255>;
#declare CN_Asagi_Koi = rgb <69/255, 85/255, 89/255>;
#declare CN_Asagi_Yellow = rgb <247/255, 187/255, 125/255>;
#declare CN_Asfar_Yellow = rgb <252/255, 239/255, 1/255>;
#declare CN_Ash = rgb <190/255, 186/255, 167/255>;
#declare CN_Ash_Blonde = rgb <215/255, 190/255, 165/255>;
#declare CN_Ash_Blue = rgb <192/255, 198/255, 201/255>;
#declare CN_Ash_Brown = rgb <152/255, 98/255, 60/255>;
#declare CN_Ash_Cherry_Blossom = rgb <232/255, 211/255, 209/255>;
#declare CN_Ash_Gold = rgb <140/255, 111/255, 84/255>;
#declare CN_Ash_Grey = rgb <193/255, 181/255, 169/255>;
#declare CN_Ash_Grove = rgb <185/255, 179/255, 191/255>;
#declare CN_Ash_Hollow = rgb <168/255, 142/255, 139/255>;
#declare CN_Ash_in_the_Air = rgb <217/255, 221/255, 229/255>;
#declare CN_Ash_Mauve = rgb <115/255, 116/255, 134/255>;
#declare CN_Ash_Pink = rgb <153/255, 142/255, 145/255>;
#declare CN_Ash_Plum = rgb <232/255, 211/255, 199/255>;
#declare CN_Ash_Rose = rgb <181/255, 129/255, 125/255>;
#declare CN_Ash_to_Ash = rgb <78/255, 78/255, 76/255>;
#declare CN_Ash_Tree = rgb <170/255, 187/255, 153/255>;
#declare CN_Ash_Tree_Bark = rgb <206/255, 207/255, 214/255>;
#declare CN_Ash_Violet = rgb <150/255, 149/255, 164/255>;
#declare CN_Ash_White = rgb <233/255, 228/255, 212/255>;
#declare CN_Ash_Yellow = rgb <240/255, 189/255, 126/255>;
#declare CN_Ashberry = rgb <180/255, 149/255, 164/255>;
#declare CN_Ashen = rgb <201/255, 191/255, 178/255>;
#declare CN_Ashen_Brown = rgb <153/255, 68/255, 68/255>;
#declare CN_Ashen_Plum = rgb <155/255, 144/255, 146/255>;
#declare CN_Ashen_Tan = rgb <211/255, 202/255, 191/255>;
#declare CN_Ashen_Wind = rgb <148/255, 169/255, 183/255>;
#declare CN_Ashenvale_Nights = rgb <16/255, 64/255, 113/255>;
#declare CN_Asher_Benjamin = rgb <69/255, 87/255, 94/255>;
#declare CN_Ashes = rgb <184/255, 181/255, 173/255>;
#declare CN_Ashes_to_Ashes = rgb <187/255, 179/255, 162/255>;
#declare CN_Ashley_Blue = rgb <134/255, 153/255, 171/255>;
#declare CN_Ashlite = rgb <167/255, 164/255, 159/255>;
#declare CN_Ashton_Blue = rgb <74/255, 121/255, 186/255>;
#declare CN_Ashton_Skies = rgb <123/255, 142/255, 176/255>;
#declare CN_Ashwood = rgb <188/255, 196/255, 189/255>;
#declare CN_Asian_Fusion = rgb <236/255, 224/255, 205/255>;
#declare CN_Asian_Ivory = rgb <232/255, 224/255, 205/255>;
#declare CN_Asian_Jute = rgb <212/255, 183/255, 143/255>;
#declare CN_Asian_Pear = rgb <174/255, 145/255, 86/255>;
#declare CN_Asian_Violet = rgb <139/255, 129/255, 140/255>;
#declare CN_Asmani_Sky = rgb <136/255, 221/255, 187/255>;
#declare CN_Aspara = rgb <112/255, 178/255, 204/255>;
#declare CN_Asparagus = rgb <119/255, 171/255, 86/255>;
#declare CN_Asparagus_Cream = rgb <150/255, 175/255, 84/255>;
#declare CN_Asparagus_Fern = rgb <185/255, 203/255, 90/255>;
#declare CN_Asparagus_Green = rgb <210/255, 205/255, 180/255>;
#declare CN_Asparagus_Sprig = rgb <87/255, 111/255, 68/255>;
#declare CN_Asparagus_Yellow = rgb <218/255, 201/255, 142/255>;
#declare CN_Aspen_Aura = rgb <131/255, 164/255, 148/255>;
#declare CN_Aspen_Branch = rgb <198/255, 188/255, 173/255>;
#declare CN_Aspen_Gold = rgb <255/255, 214/255, 98/255>;
#declare CN_Aspen_Green = rgb <126/255, 155/255, 118/255>;
#declare CN_Aspen_Hush = rgb <106/255, 141/255, 136/255>;
#declare CN_Aspen_Mist = rgb <207/255, 215/255, 203/255>;
#declare CN_Aspen_Snow = rgb <240/255, 240/255, 231/255>;
#declare CN_Aspen_Valley = rgb <104/255, 127/255, 122/255>;
#declare CN_Aspen_Whisper = rgb <237/255, 241/255, 227/255>;
#declare CN_Aspen_Yellow = rgb <246/255, 223/255, 159/255>;
#declare CN_Asphalt = rgb <19/255, 10/255, 6/255>;
#declare CN_Asphalt_Blue = rgb <71/255, 76/255, 85/255>;
#declare CN_Asphalt_Grey = rgb <94/255, 94/255, 93/255>;
#declare CN_Aspiring_Blue = rgb <162/255, 193/255, 192/255>;
#declare CN_Assassin = rgb <45/255, 79/255, 131/255>;
#declare CN_Assassins_Red = rgb <246/255, 2/255, 6/255>;
#declare CN_Assateague_Sand = rgb <225/255, 208/255, 178/255>;
#declare CN_Assault = rgb <28/255, 67/255, 116/255>;
#declare CN_Aster = rgb <134/255, 123/255, 169/255>;
#declare CN_Aster_Flower_Blue = rgb <155/255, 172/255, 216/255>;
#declare CN_Aster_Petal = rgb <212/255, 218/255, 226/255>;
#declare CN_Aster_Purple = rgb <125/255, 116/255, 168/255>;
#declare CN_Aster_Violetta = rgb <143/255, 98/255, 154/255>;
#declare CN_Astilbe = rgb <240/255, 145/255, 169/255>;
#declare CN_Astorath_Red = rgb <221/255, 72/255, 43/255>;
#declare CN_Astra = rgb <237/255, 213/255, 166/255>;
#declare CN_Astral = rgb <55/255, 111/255, 137/255>;
#declare CN_Astral_Aura = rgb <54/255, 49/255, 81/255>;
#declare CN_Astral_Spirit = rgb <142/255, 194/255, 231/255>;
#declare CN_Astro_Arcade_Green = rgb <119/255, 255/255, 119/255>;
#declare CN_Astro_Bound = rgb <137/255, 159/255, 185/255>;
#declare CN_Astro_Nautico = rgb <83/255, 131/255, 195/255>;
#declare CN_Astro_Purple = rgb <109/255, 90/255, 207/255>;
#declare CN_Astro_Sunset = rgb <147/255, 120/255, 116/255>;
#declare CN_Astro_Zinger = rgb <121/255, 126/255, 181/255>;
#declare CN_Astrogranite = rgb <117/255, 118/255, 121/255>;
#declare CN_Astrogranite_Debris = rgb <59/255, 66/255, 76/255>;
#declare CN_Astrolabe_Reef = rgb <45/255, 150/255, 206/255>;
#declare CN_Astronaut = rgb <68/255, 81/255, 114/255>;
#declare CN_Astronaut_Blue = rgb <33/255, 69/255, 89/255>;
#declare CN_Astronomer = rgb <232/255, 242/255, 235/255>;
#declare CN_Astronomical = rgb <71/255, 75/255, 74/255>;
#declare CN_Astronomicon_Grey = rgb <107/255, 124/255, 133/255>;
#declare CN_Astroscopus_Grey = rgb <175/255, 180/255, 182/255>;
#declare CN_Astroturf = rgb <103/255, 161/255, 89/255>;
#declare CN_Asurmen_Blue_Wash = rgb <39/255, 62/255, 81/255>;
#declare CN_Aswad_Black = rgb <23/255, 24/255, 28/255>;
#declare CN_At_Ease = rgb <231/255, 238/255, 225/255>;
#declare CN_At_Ease_Soldier = rgb <158/255, 153/255, 133/255>;
#declare CN_At_The_Beach = rgb <231/255, 217/255, 185/255>;
#declare CN_Atelier = rgb <163/255, 171/255, 184/255>;
#declare CN_Ateneo_Blue = rgb <0/255, 58/255, 108/255>;
#declare CN_Athena_Blue = rgb <102/255, 221/255, 255/255>;
#declare CN_Athenian_Green = rgb <146/255, 161/255, 138/255>;
#declare CN_Athens_Grey = rgb <220/255, 221/255, 221/255>;
#declare CN_Athonian_Camoshade = rgb <109/255, 142/255, 68/255>;
#declare CN_Aths_Special = rgb <213/255, 203/255, 178/255>;
#declare CN_Atlantic_Blue = rgb <0/255, 137/255, 151/255>;
#declare CN_Atlantic_Breeze = rgb <203/255, 225/255, 238/255>;
#declare CN_Atlantic_Charter = rgb <43/255, 47/255, 65/255>;
#declare CN_Atlantic_Deep = rgb <39/255, 78/255, 85/255>;
#declare CN_Atlantic_Depths = rgb <0/255, 17/255, 102/255>;
#declare CN_Atlantic_Fig_Snail = rgb <215/255, 206/255, 185/255>;
#declare CN_Atlantic_Gull = rgb <75/255, 142/255, 176/255>;
#declare CN_Atlantic_Mystique = rgb <0/255, 98/255, 154/255>;
#declare CN_Atlantic_Ocean = rgb <167/255, 216/255, 228/255>;
#declare CN_Atlantic_Sand = rgb <220/255, 213/255, 210/255>;
#declare CN_Atlantic_Shoreline = rgb <112/255, 129/255, 137/255>;
#declare CN_Atlantic_Tide = rgb <62/255, 88/255, 110/255>;
#declare CN_Atlantic_Tulip = rgb <181/255, 152/255, 195/255>;
#declare CN_Atlantic_Wave = rgb <61/255, 121/255, 124/255>;
#declare CN_Atlantic_Waves = rgb <38/255, 66/255, 67/255>;
#declare CN_Atlantis = rgb <51/255, 97/255, 114/255>;
#declare CN_Atlantis_Myth = rgb <0/255, 100/255, 119/255>;
#declare CN_Atlas_Cedar_Green = rgb <102/255, 122/255, 110/255>;
#declare CN_Atlas_Red = rgb <130/255, 25/255, 58/255>;
#declare CN_Atlas_White = rgb <237/255, 229/255, 207/255>;
#declare CN_Atmosphere = rgb <0/255, 153/255, 221/255>;
#declare CN_Atmospheric = rgb <137/255, 150/255, 151/255>;
#declare CN_Atmospheric_Pressure = rgb <194/255, 208/255, 225/255>;
#declare CN_Atmospheric_Soft_Blue = rgb <172/255, 225/255, 240/255>;
#declare CN_Atoll = rgb <43/255, 121/255, 122/255>;
#declare CN_Atoll_Sand = rgb <255/255, 207/255, 158/255>;
#declare CN_Atom_Blue = rgb <143/255, 156/255, 172/255>;
#declare CN_Atomic = rgb <61/255, 75/255, 82/255>;
#declare CN_Atomic_Lime = rgb <185/255, 255/255, 3/255>;
#declare CN_Atomic_Pink = rgb <251/255, 126/255, 253/255>;
#declare CN_Atomic_Tangerine = rgb <255/255, 153/255, 102/255>;
#declare CN_Atrium_White = rgb <241/255, 238/255, 228/255>;
#declare CN_Attar_of_Rose = rgb <153/255, 66/255, 64/255>;
#declare CN_Attica = rgb <161/255, 188/255, 169/255>;
#declare CN_Attitude = rgb <164/255, 136/255, 132/255>;
#declare CN_Attitude_Gray = rgb <124/255, 125/255, 117/255>;
#declare CN_Attorney = rgb <63/255, 66/255, 88/255>;
#declare CN_Au_Chico = rgb <158/255, 103/255, 89/255>;
#declare CN_Au_Gratin = rgb <255/255, 157/255, 69/255>;
#declare CN_Au_Natural = rgb <229/255, 225/255, 206/255>;
#declare CN_Au_Naturel = rgb <232/255, 202/255, 192/255>;
#declare CN_Auberge = rgb <63/255, 49/255, 48/255>;
#declare CN_Aubergine = rgb <55/255, 37/255, 40/255>;
#declare CN_Aubergine_Flesh = rgb <242/255, 228/255, 221/255>;
#declare CN_Aubergine_Green = rgb <139/255, 118/255, 44/255>;
#declare CN_Aubergine_Grey = rgb <110/255, 88/255, 97/255>;
#declare CN_Aubergine_Mauve = rgb <59/255, 39/255, 65/255>;
#declare CN_Aubergine_Perl = rgb <85/255, 0/255, 170/255>;
#declare CN_Auburn = rgb <113/255, 47/255, 44/255>;
#declare CN_Auburn_Glaze = rgb <181/255, 130/255, 113/255>;
#declare CN_Auburn_Lights = rgb <120/255, 52/255, 47/255>;
#declare CN_Auburn_Wave = rgb <216/255, 163/255, 148/255>;
#declare CN_Audition = rgb <181/255, 172/255, 183/255>;
#declare CN_Audreys_Blush = rgb <174/255, 128/255, 135/255>;
#declare CN_Auger_Shell = rgb <159/255, 146/255, 146/255>;
#declare CN_August_Moon = rgb <230/255, 225/255, 214/255>;
#declare CN_August_Morning = rgb <255/255, 215/255, 157/255>;
#declare CN_Aumbry = rgb <124/255, 116/255, 105/255>;
#declare CN_Aunt_Violet = rgb <124/255, 0/255, 135/255>;
#declare CN_Aura = rgb <178/255, 168/255, 161/255>;
#declare CN_Aura_Orange = rgb <180/255, 38/255, 42/255>;
#declare CN_Aura_White = rgb <222/255, 226/255, 228/255>;
#declare CN_Aureolin = rgb <253/255, 238/255, 0/255>;
#declare CN_Auric = rgb <196/255, 137/255, 25/255>;
#declare CN_Auric_Armour_Gold = rgb <232/255, 188/255, 109/255>;
#declare CN_Auricula_Purple = rgb <83/255, 53/255, 82/255>;
#declare CN_AuroMetalSaurus = rgb <110/255, 127/255, 128/255>;
#declare CN_Aurora = rgb <237/255, 221/255, 89/255>;
#declare CN_Aurora_Brown = rgb <106/255, 66/255, 56/255>;
#declare CN_Aurora_Green = rgb <106/255, 220/255, 153/255>;
#declare CN_Aurora_Grey = rgb <211/255, 197/255, 196/255>;
#declare CN_Aurora_Magenta = rgb <150/255, 59/255, 96/255>;
#declare CN_Aurora_Orange = rgb <236/255, 112/255, 66/255>;
#declare CN_Aurora_Pink = rgb <232/255, 129/255, 166/255>;
#declare CN_Aurora_Red = rgb <185/255, 58/255, 50/255>;
#declare CN_Aurora_Splendor = rgb <89/255, 86/255, 130/255>;
#declare CN_Austere = rgb <114/255, 104/255, 72/255>;
#declare CN_Austere_Gray = rgb <190/255, 191/255, 178/255>;
#declare CN_Australian_Jade = rgb <132/255, 161/255, 148/255>;
#declare CN_Australian_Mint = rgb <239/255, 248/255, 170/255>;
#declare CN_Australien = rgb <204/255, 153/255, 17/255>;
#declare CN_Austrian_Ice = rgb <222/255, 230/255, 231/255>;
#declare CN_Authentic_Brown = rgb <107/255, 84/255, 70/255>;
#declare CN_Authentic_Tan = rgb <234/255, 221/255, 198/255>;
#declare CN_Autonomous = rgb <198/255, 199/255, 197/255>;
#declare CN_Autumn_Air = rgb <210/255, 168/255, 136/255>;
#declare CN_Autumn_Apple_Yellow = rgb <205/255, 164/255, 73/255>;
#declare CN_Autumn_Arrival = rgb <249/255, 152/255, 111/255>;
#declare CN_Autumn_Ashes = rgb <129/255, 107/255, 104/255>;
#declare CN_Autumn_Avenue = rgb <227/255, 173/255, 89/255>;
#declare CN_Autumn_Bark = rgb <157/255, 111/255, 70/255>;
#declare CN_Autumn_Blaze = rgb <217/255, 146/255, 46/255>;
#declare CN_Autumn_Blonde = rgb <238/255, 208/255, 174/255>;
#declare CN_Autumn_Bloom = rgb <255/255, 224/255, 203/255>;
#declare CN_Autumn_Blush = rgb <228/255, 209/255, 192/255>;
#declare CN_Autumn_Child = rgb <251/255, 230/255, 193/255>;
#declare CN_Autumn_Crocodile = rgb <68/255, 119/255, 68/255>;
#declare CN_Autumn_Fall = rgb <103/255, 66/255, 59/255>;
#declare CN_Autumn_Fern = rgb <80/255, 123/255, 73/255>;
#declare CN_Autumn_Fest = rgb <190/255, 125/255, 51/255>;
#declare CN_Autumn_Festival = rgb <162/255, 139/255, 54/255>;
#declare CN_Autumn_Glaze = rgb <179/255, 87/255, 63/255>;
#declare CN_Autumn_Glory = rgb <255/255, 136/255, 18/255>;
#declare CN_Autumn_Glow = rgb <229/255, 195/255, 130/255>;
#declare CN_Autumn_Gold = rgb <125/255, 98/255, 60/255>;
#declare CN_Autumn_Gourd = rgb <230/255, 174/255, 118/255>;
#declare CN_Autumn_Grey = rgb <178/255, 171/255, 167/255>;
#declare CN_Autumn_Haze = rgb <212/255, 194/255, 177/255>;
#declare CN_Autumn_Hills = rgb <120/255, 79/255, 80/255>;
#declare CN_Autumn_Laurel = rgb <157/255, 141/255, 102/255>;
#declare CN_Autumn_Leaf = rgb <181/255, 106/255, 76/255>;
#declare CN_Autumn_Leaf_Brown = rgb <122/255, 86/255, 14/255>;
#declare CN_Autumn_Leaf_Orange = rgb <208/255, 122/255, 4/255>;
#declare CN_Autumn_Leaf_Red = rgb <98/255, 56/255, 54/255>;
#declare CN_Autumn_Leaves = rgb <110/255, 68/255, 64/255>;
#declare CN_Autumn_Malt = rgb <206/255, 164/255, 142/255>;
#declare CN_Autumn_Maple = rgb <196/255, 98/255, 21/255>;
#declare CN_Autumn_Meadow = rgb <172/255, 183/255, 142/255>;
#declare CN_Autumn_Mist = rgb <247/255, 180/255, 134/255>;
#declare CN_Autumn_Night = rgb <59/255, 88/255, 97/255>;
#declare CN_Autumn_Orange = rgb <238/255, 153/255, 80/255>;
#declare CN_Autumn_Orchid = rgb <157/255, 144/255, 147/255>;
#declare CN_Autumn_Pine_Green = rgb <21/255, 128/255, 120/255>;
#declare CN_Autumn_Red = rgb <153/255, 69/255, 31/255>;
#declare CN_Autumn_Ridge = rgb <155/255, 66/255, 63/255>;
#declare CN_Autumn_Robin = rgb <194/255, 69/255, 45/255>;
#declare CN_Autumn_Russet = rgb <164/255, 116/255, 110/255>;
#declare CN_Autumn_Sage = rgb <174/255, 162/255, 110/255>;
#declare CN_Autumn_Sunset = rgb <243/255, 133/255, 84/255>;
#declare CN_Autumn_Umber = rgb <174/255, 112/255, 79/255>;
#declare CN_Autumn_White = rgb <250/255, 226/255, 207/255>;
#declare CN_Autumn_Wind = rgb <251/255, 209/255, 182/255>;
#declare CN_Autumn_Wisteria = rgb <201/255, 160/255, 220/255>;
#declare CN_Autumn_Yellow = rgb <233/255, 151/255, 0/255>;
#declare CN_Autumns_Hill = rgb <186/255, 122/255, 97/255>;
#declare CN_Autumnal = rgb <161/255, 83/255, 37/255>;
#declare CN_Avagddu_Green = rgb <16/255, 107/255, 33/255>;
#declare CN_Avalon = rgb <121/255, 155/255, 150/255>;
#declare CN_Avant_Garde_Pink = rgb <255/255, 119/255, 238/255>;
#declare CN_Aventurine = rgb <87/255, 110/255, 106/255>;
#declare CN_Avenue_Tan = rgb <210/255, 194/255, 176/255>;
#declare CN_Averland_Sunset = rgb <255/255, 170/255, 29/255>;
#declare CN_Aviary_Blue = rgb <198/255, 227/255, 232/255>;
#declare CN_Avid_Apricot = rgb <244/255, 198/255, 159/255>;
#declare CN_Aviva = rgb <197/255, 180/255, 127/255>;
#declare CN_Avocado = rgb <86/255, 130/255, 3/255>;
#declare CN_Avocado_Cream = rgb <183/255, 191/255, 107/255>;
#declare CN_Avocado_Dark_Green = rgb <62/255, 72/255, 38/255>;
#declare CN_Avocado_Green = rgb <135/255, 169/255, 34/255>;
#declare CN_Avocado_Pear = rgb <85/255, 83/255, 55/255>;
#declare CN_Avocado_Peel = rgb <57/255, 55/255, 59/255>;
#declare CN_Avocado_Toast = rgb <144/255, 177/255, 52/255>;
#declare CN_Avocado_Whip = rgb <205/255, 214/255, 177/255>;
#declare CN_Awaken = rgb <167/255, 163/255, 187/255>;
#declare CN_Awakened = rgb <227/255, 218/255, 233/255>;
#declare CN_Awakening = rgb <187/255, 158/255, 155/255>;
#declare CN_Award_Blue = rgb <49/255, 88/255, 134/255>;
#declare CN_Award_Night = rgb <84/255, 97/255, 125/255>;
#declare CN_Award_Winning_White = rgb <254/255, 240/255, 222/255>;
#declare CN_Awareness = rgb <227/255, 235/255, 177/255>;
#declare CN_Awesome_Aura = rgb <204/255, 193/255, 218/255>;
#declare CN_Awesome_Violet = rgb <167/255, 178/255, 212/255>;
#declare CN_Awkward_Purple = rgb <210/255, 8/255, 204/255>;
#declare CN_Awning_Red = rgb <144/255, 65/255, 62/255>;
#declare CN_Axe_Handle = rgb <107/255, 71/255, 48/255>;
#declare CN_Axinite = rgb <117/255, 96/255, 80/255>;
#declare CN_Axis = rgb <186/255, 182/255, 203/255>;
#declare CN_Axolotl = rgb <255/255, 240/255, 223/255>;
#declare CN_Ayahuasca_Vine = rgb <102/255, 85/255, 0/255>;
#declare CN_Ayame_Iris = rgb <118/255, 53/255, 104/255>;
#declare CN_Ayrshire = rgb <160/255, 114/255, 84/255>;
#declare CN_Azalea = rgb <212/255, 46/255, 91/255>;
#declare CN_Azalea_Flower = rgb <239/255, 192/255, 203/255>;
#declare CN_Azalea_Leaf = rgb <74/255, 104/255, 113/255>;
#declare CN_Azalea_Pink = rgb <249/255, 192/255, 196/255>;
#declare CN_Azeitona = rgb <165/255, 181/255, 70/255>;
#declare CN_Azores_Blue = rgb <0/255, 133/255, 167/255>;
#declare CN_Azraq_Blue = rgb <76/255, 108/255, 179/255>;
#declare CN_Azshara_Vein = rgb <177/255, 57/255, 22/255>;
#declare CN_Aztec = rgb <41/255, 52/255, 50/255>;
#declare CN_Aztec_Aura = rgb <255/255, 239/255, 188/255>;
#declare CN_Aztec_Brick = rgb <158/255, 131/255, 82/255>;
#declare CN_Aztec_Glimmer = rgb <231/255, 179/255, 71/255>;
#declare CN_Aztec_Gold = rgb <195/255, 153/255, 83/255>;
#declare CN_Aztec_Jade = rgb <51/255, 187/255, 136/255>;
#declare CN_Aztec_Sky = rgb <77/255, 181/255, 215/255>;
#declare CN_Aztec_Temple = rgb <132/255, 112/255, 91/255>;
#declare CN_Aztec_Turquoise = rgb <0/255, 214/255, 226/255>;
#declare CN_Aztec_Warrior = rgb <187/255, 0/255, 102/255>;
#declare CN_Azuki_Bean = rgb <150/255, 81/255, 77/255>;
#declare CN_Azuki_Red = rgb <103/255, 36/255, 34/255>;
#declare CN_Azul = rgb <29/255, 93/255, 236/255>;
#declare CN_Azul_Caribe = rgb <0/255, 137/255, 196/255>;
#declare CN_Azul_Cielito_Lindo = rgb <201/255, 227/255, 235/255>;
#declare CN_Azul_Pavo_Real = rgb <83/255, 127/255, 175/255>;
#declare CN_Azul_Petroleo = rgb <54/255, 69/255, 79/255>;
#declare CN_Azul_Primavera = rgb <226/255, 239/255, 242/255>;
#declare CN_Azul_Tequila = rgb <192/255, 207/255, 199/255>;
#declare CN_Azul_Turquesa = rgb <106/255, 186/255, 196/255>;
#declare CN_Azure = rgb <0/255, 127/255, 255/255>;
#declare CN_Azure_Blue = rgb <77/255, 145/255, 198/255>;
#declare CN_Azure_Dragon = rgb <5/255, 57/255, 118/255>;
#declare CN_Azure_Green_Blue = rgb <0/255, 108/255, 129/255>;
#declare CN_Azure_Hint = rgb <221/255, 220/255, 225/255>;
#declare CN_Azure_Lake = rgb <123/255, 187/255, 200/255>;
#declare CN_Azure_Mist = rgb <240/255, 255/255, 241/255>;
#declare CN_Azure_Radiance = rgb <0/255, 127/255, 31/255>;
#declare CN_Azure_Sky = rgb <176/255, 224/255, 246/255>;
#declare CN_Azure_Tide = rgb <43/255, 152/255, 144/255>;
#declare CN_Azurean = rgb <89/255, 186/255, 217/255>;
#declare CN_Azureish_White = rgb <219/255, 233/255, 244/255>;
#declare CN_Azuremyst_Isle = rgb <204/255, 129/255, 240/255>;
#declare CN_Azurite_Water_Green = rgb <73/255, 127/255, 115/255>;
#declare CN_Bdazzled_Blue = rgb <46/255, 88/255, 148/255>;
#declare CN_Baal_Red_Wash = rgb <97/255, 0/255, 35/255>;
#declare CN_Baba_Ganoush = rgb <238/255, 187/255, 136/255>;
#declare CN_Babbling_Brook = rgb <190/255, 207/255, 205/255>;
#declare CN_Babbling_Creek = rgb <167/255, 186/255, 211/255>;
#declare CN_Babe = rgb <220/255, 123/255, 124/255>;
#declare CN_Babiana = rgb <135/255, 111/255, 163/255>;
#declare CN_Baby_Aqua = rgb <171/255, 204/255, 195/255>;
#declare CN_Baby_Artichoke = rgb <233/255, 227/255, 206/255>;
#declare CN_Baby_Barn_Owl = rgb <195/255, 195/255, 184/255>;
#declare CN_Baby_Bear = rgb <111/255, 89/255, 68/255>;
#declare CN_Baby_Berries = rgb <156/255, 74/255, 98/255>;
#declare CN_Baby_Blossom = rgb <250/255, 239/255, 233/255>;
#declare CN_Baby_Blue = rgb <162/255, 207/255, 254/255>;
#declare CN_Baby_Blue_Eyes = rgb <161/255, 202/255, 241/255>;
#declare CN_Baby_Bok_Choy = rgb <187/255, 185/255, 138/255>;
#declare CN_Baby_Breath = rgb <240/255, 208/255, 176/255>;
#declare CN_Baby_Bunting = rgb <171/255, 202/255, 234/255>;
#declare CN_Baby_Burro = rgb <140/255, 102/255, 92/255>;
#declare CN_Baby_Cake = rgb <135/255, 190/255, 163/255>;
#declare CN_Baby_Chick = rgb <255/255, 237/255, 162/255>;
#declare CN_Baby_Fish_Mouth = rgb <243/255, 172/255, 185/255>;
#declare CN_Baby_Frog = rgb <200/255, 186/255, 99/255>;
#declare CN_Baby_Girl = rgb <255/255, 223/255, 232/255>;
#declare CN_Baby_Grass = rgb <138/255, 189/255, 123/255>;
#declare CN_Baby_Green = rgb <140/255, 255/255, 158/255>;
#declare CN_Baby_Jane = rgb <208/255, 167/255, 168/255>;
#declare CN_Baby_Melon = rgb <255/255, 164/255, 104/255>;
#declare CN_Baby_Motive = rgb <143/255, 203/255, 220/255>;
#declare CN_Baby_Pink = rgb <255/255, 183/255, 206/255>;
#declare CN_Baby_Powder = rgb <254/255, 254/255, 250/255>;
#declare CN_Baby_Purple = rgb <202/255, 155/255, 247/255>;
#declare CN_Baby_Seal = rgb <161/255, 165/255, 168/255>;
#declare CN_Baby_Shoes = rgb <0/255, 87/255, 132/255>;
#declare CN_Baby_Spinach = rgb <137/255, 168/255, 130/255>;
#declare CN_Baby_Sprout = rgb <167/255, 139/255, 129/255>;
#declare CN_Baby_Steps = rgb <245/255, 201/255, 218/255>;
#declare CN_Baby_Tears = rgb <102/255, 185/255, 214/255>;
#declare CN_Baby_Tone = rgb <220/255, 194/255, 203/255>;
#declare CN_Baby_Tooth = rgb <238/255, 255/255, 221/255>;
#declare CN_Baby_Vegetable = rgb <93/255, 105/255, 66/255>;
#declare CN_Babys_Blanket = rgb <255/255, 174/255, 193/255>;
#declare CN_Babys_Booties = rgb <232/255, 193/255, 194/255>;
#declare CN_Babys_Breath = rgb <216/255, 228/255, 232/255>;
#declare CN_Babyccino = rgb <238/255, 204/255, 187/255>;
#declare CN_Baca_Berry = rgb <148/255, 87/255, 89/255>;
#declare CN_Bacchanalia_Red = rgb <138/255, 58/255, 60/255>;
#declare CN_Bachelor_Blue = rgb <143/255, 170/255, 202/255>;
#declare CN_Bachelor_Button = rgb <74/255, 187/255, 213/255>;
#declare CN_Bachimitsu_Gold = rgb <253/255, 222/255, 165/255>;
#declare CN_Back_In_Black = rgb <22/255, 20/255, 28/255>;
#declare CN_Back_Stage = rgb <107/255, 98/255, 91/255>;
#declare CN_Back_To_Basics = rgb <114/255, 103/255, 71/255>;
#declare CN_Back_to_Nature = rgb <189/255, 185/255, 143/255>;
#declare CN_Back_to_School = rgb <193/255, 133/255, 59/255>;
#declare CN_Backcountry = rgb <124/255, 114/255, 95/255>;
#declare CN_Backdrop = rgb <167/255, 167/255, 153/255>;
#declare CN_Backlight = rgb <252/255, 240/255, 229/255>;
#declare CN_Backwater = rgb <104/255, 112/255, 120/255>;
#declare CN_Backwoods = rgb <74/255, 101/255, 70/255>;
#declare CN_Backyard = rgb <135/255, 152/255, 119/255>;
#declare CN_Bacon_Strips = rgb <223/255, 63/255, 50/255>;
#declare CN_Bad_Hair_Day = rgb <241/255, 201/255, 131/255>;
#declare CN_Bad_Moon_Yellow = rgb <242/255, 229/255, 180/255>;
#declare CN_Badab_Black_Wash = rgb <10/255, 9/255, 8/255>;
#declare CN_Badass_Grass = rgb <180/255, 218/255, 85/255>;
#declare CN_Badlands_Orange = rgb <255/255, 99/255, 22/255>;
#declare CN_Badlands_Sunset = rgb <147/255, 106/255, 91/255>;
#declare CN_Badshahi_Brown = rgb <211/255, 161/255, 148/255>;
#declare CN_Bag_of_Gold = rgb <225/255, 189/255, 136/255>;
#declare CN_Bagel = rgb <246/255, 205/255, 155/255>;
#declare CN_Bagpiper = rgb <28/255, 85/255, 68/255>;
#declare CN_Baguette = rgb <181/255, 147/255, 106/255>;
#declare CN_Bahama_Blue = rgb <37/255, 89/255, 127/255>;
#declare CN_Bahaman_Bliss = rgb <63/255, 164/255, 155/255>;
#declare CN_Baharroth_Blue = rgb <88/255, 193/255, 205/255>;
#declare CN_Bahia = rgb <169/255, 192/255, 28/255>;
#declare CN_Bahia_Grass = rgb <196/255, 197/255, 173/255>;
#declare CN_Bai_Se_White = rgb <236/255, 239/255, 239/255>;
#declare CN_Baiko_Brown = rgb <136/255, 121/255, 56/255>;
#declare CN_Bailey_Bells = rgb <138/255, 142/255, 201/255>;
#declare CN_Baingani = rgb <130/255, 115/255, 253/255>;
#declare CN_Baize = rgb <75/255, 84/255, 69/255>;
#declare CN_Baize_Green = rgb <199/255, 205/255, 168/255>;
#declare CN_Baja = rgb <210/255, 193/255, 168/255>;
#declare CN_Baja_Blue = rgb <102/255, 166/255, 217/255>;
#declare CN_Baja_White = rgb <255/255, 248/255, 209/255>;
#declare CN_Baked_Apple = rgb <179/255, 70/255, 70/255>;
#declare CN_Baked_Bean = rgb <178/255, 117/255, 77/255>;
#declare CN_Baked_Biscotti = rgb <218/255, 211/255, 204/255>;
#declare CN_Baked_Bread = rgb <218/255, 203/255, 169/255>;
#declare CN_Baked_Brie = rgb <237/255, 233/255, 215/255>;
#declare CN_Baked_Clay = rgb <156/255, 86/255, 66/255>;
#declare CN_Baked_Cookie = rgb <137/255, 103/255, 74/255>;
#declare CN_Baked_Potato = rgb <182/255, 158/255, 135/255>;
#declare CN_Baked_Salmon = rgb <223/255, 152/255, 118/255>;
#declare CN_Baked_Scone = rgb <229/255, 211/255, 188/255>;
#declare CN_Baked_Sienna = rgb <155/255, 119/255, 94/255>;
#declare CN_Bakelite = rgb <230/255, 212/255, 165/255>;
#declare CN_Bakelite_Gold = rgb <215/255, 153/255, 93/255>;
#declare CN_Bakelite_Yellow = rgb <198/255, 183/255, 136/255>;
#declare CN_Baker_Miller_Pink = rgb <255/255, 146/255, 174/255>;
#declare CN_Bakers_Chocolate = rgb <92/255, 51/255, 23/255>;
#declare CN_Bakery_Box = rgb <240/255, 244/255, 242/255>;
#declare CN_Bakery_Brown = rgb <171/255, 144/255, 120/255>;
#declare CN_Baklava = rgb <239/255, 180/255, 53/255>;
#declare CN_Bakos_Blue = rgb <39/255, 63/255, 75/255>;
#declare CN_Balance = rgb <209/255, 219/255, 194/255>;
#declare CN_Balance_Green = rgb <195/255, 197/255, 167/255>;
#declare CN_Balanced = rgb <215/255, 210/255, 209/255>;
#declare CN_Balanced_Beige = rgb <192/255, 178/255, 162/255>;
#declare CN_Balboa = rgb <175/255, 211/255, 218/255>;
#declare CN_Balcony_Rose = rgb <226/255, 188/255, 184/255>;
#declare CN_Balcony_Sunset = rgb <215/255, 142/255, 107/255>;
#declare CN_Baleine_Blue = rgb <21/255, 81/255, 135/255>;
#declare CN_Bali_Batik = rgb <111/255, 89/255, 55/255>;
#declare CN_Bali_Bliss = rgb <94/255, 158/255, 160/255>;
#declare CN_Bali_Deep = rgb <138/255, 142/255, 147/255>;
#declare CN_Bali_Hai = rgb <132/255, 156/255, 169/255>;
#declare CN_Bali_Sand = rgb <246/255, 232/255, 213/255>;
#declare CN_Balinese_Sunset = rgb <241/255, 161/255, 119/255>;
#declare CN_Ball_Blue = rgb <33/255, 171/255, 205/255>;
#declare CN_Ball_Gown = rgb <82/255, 86/255, 97/255>;
#declare CN_Ballad = rgb <202/255, 182/255, 198/255>;
#declare CN_Ballad_Blue = rgb <192/255, 206/255, 218/255>;
#declare CN_Ballerina = rgb <242/255, 207/255, 220/255>;
#declare CN_Ballerina_Beauty = rgb <232/255, 222/255, 214/255>;
#declare CN_Ballerina_Gown = rgb <249/255, 234/255, 234/255>;
#declare CN_Ballerina_Pink = rgb <247/255, 182/255, 186/255>;
#declare CN_Ballerina_Silk = rgb <240/255, 222/255, 224/255>;
#declare CN_Ballerina_Tears = rgb <242/255, 187/255, 177/255>;
#declare CN_Ballerina_Tutu = rgb <200/255, 100/255, 127/255>;
#declare CN_Ballet_Blue = rgb <175/255, 196/255, 217/255>;
#declare CN_Ballet_Cream = rgb <252/255, 130/255, 88/255>;
#declare CN_Ballet_Rose = rgb <211/255, 173/255, 177/255>;
#declare CN_Ballet_Shoes = rgb <237/255, 185/255, 189/255>;
#declare CN_Ballet_Slipper = rgb <235/255, 206/255, 213/255>;
#declare CN_Ballet_White = rgb <242/255, 231/255, 216/255>;
#declare CN_Ballie_Scott_Sage = rgb <178/255, 178/255, 156/255>;
#declare CN_Ballroom_Blue = rgb <166/255, 179/255, 201/255>;
#declare CN_Ballyhoo = rgb <88/255, 168/255, 59/255>;
#declare CN_Balmy = rgb <197/255, 216/255, 222/255>;
#declare CN_Balmy_Seas = rgb <180/255, 220/255, 211/255>;
#declare CN_Balor_Brown = rgb <156/255, 107/255, 8/255>;
#declare CN_Balsa_Stone = rgb <203/255, 187/255, 146/255>;
#declare CN_Balsam = rgb <190/255, 196/255, 183/255>;
#declare CN_Balsam_Fir = rgb <144/255, 158/255, 145/255>;
#declare CN_Balsam_Green = rgb <87/255, 102/255, 100/255>;
#declare CN_Balsam_Pear = rgb <177/255, 147/255, 56/255>;
#declare CN_Balsamic_Reduction = rgb <67/255, 67/255, 64/255>;
#declare CN_Balthasar_Gold = rgb <164/255, 117/255, 82/255>;
#declare CN_Baltic = rgb <39/255, 157/255, 159/255>;
#declare CN_Baltic_Blue = rgb <108/255, 150/255, 154/255>;
#declare CN_Baltic_Bream = rgb <159/255, 187/255, 218/255>;
#declare CN_Baltic_Green = rgb <58/255, 160/255, 152/255>;
#declare CN_Baltic_Prince = rgb <19/255, 89/255, 82/255>;
#declare CN_Baltic_Sea = rgb <60/255, 61/255, 62/255>;
#declare CN_Baltic_Trench = rgb <18/255, 87/255, 97/255>;
#declare CN_Baltic_Turquoise = rgb <0/255, 164/255, 154/255>;
#declare CN_Bambino = rgb <142/255, 218/255, 204/255>;
#declare CN_Bamboo = rgb <227/255, 222/255, 198/255>;
#declare CN_Bamboo_Beige = rgb <193/255, 171/255, 160/255>;
#declare CN_Bamboo_Brown = rgb <200/255, 127/255, 0/255>;
#declare CN_Bamboo_Charcoal = rgb <69/255, 74/255, 72/255>;
#declare CN_Bamboo_Forest = rgb <177/255, 169/255, 121/255>;
#declare CN_Bamboo_Grass_Green = rgb <130/255, 153/255, 76/255>;
#declare CN_Bamboo_Leaf = rgb <153/255, 178/255, 67/255>;
#declare CN_Bamboo_Mat = rgb <229/255, 218/255, 159/255>;
#declare CN_Bamboo_Screen = rgb <188/255, 171/255, 140/255>;
#declare CN_Bamboo_Shoot = rgb <163/255, 182/255, 164/255>;
#declare CN_Bamboo_White = rgb <198/255, 207/255, 173/255>;
#declare CN_Bamboo_Yellow = rgb <174/255, 136/255, 75/255>;
#declare CN_Banafs_Violet = rgb <90/255, 25/255, 145/255>;
#declare CN_Banafsaji_Purple = rgb <165/255, 11/255, 94/255>;
#declare CN_Banana = rgb <255/255, 252/255, 121/255>;
#declare CN_Banana_Bandanna = rgb <248/255, 247/255, 57/255>;
#declare CN_Banana_Biscuit = rgb <255/255, 222/255, 123/255>;
#declare CN_Banana_Blossom = rgb <147/255, 62/255, 73/255>;
#declare CN_Banana_Boat = rgb <253/255, 200/255, 56/255>;
#declare CN_Banana_Bread = rgb <255/255, 207/255, 115/255>;
#declare CN_Banana_Brick = rgb <232/255, 216/255, 44/255>;
#declare CN_Banana_Brulee = rgb <247/255, 234/255, 185/255>;
#declare CN_Banana_Chalk = rgb <214/255, 217/255, 99/255>;
#declare CN_Banana_Clan = rgb <238/255, 221/255, 0/255>;
#declare CN_Banana_Cream = rgb <255/255, 244/255, 156/255>;
#declare CN_Banana_Crepe = rgb <231/255, 211/255, 173/255>;
#declare CN_Banana_Custard = rgb <252/255, 243/255, 197/255>;
#declare CN_Banana_Farm = rgb <255/255, 223/255, 56/255>;
#declare CN_Banana_Flash = rgb <238/255, 255/255, 0/255>;
#declare CN_Banana_Ice_Cream = rgb <241/255, 211/255, 178/255>;
#declare CN_Banana_Leaf = rgb <157/255, 143/255, 58/255>;
#declare CN_Banana_Mania = rgb <251/255, 231/255, 178/255>;
#declare CN_Banana_Mash = rgb <250/255, 254/255, 75/255>;
#declare CN_Banana_Milkshake = rgb <237/255, 230/255, 203/255>;
#declare CN_Banana_Palm = rgb <149/255, 162/255, 99/255>;
#declare CN_Banana_Peel = rgb <255/255, 231/255, 116/255>;
#declare CN_Banana_Pepper = rgb <253/255, 214/255, 48/255>;
#declare CN_Banana_Pie = rgb <247/255, 239/255, 215/255>;
#declare CN_Banana_Powder = rgb <208/255, 193/255, 1/255>;
#declare CN_Banana_Pudding = rgb <244/255, 239/255, 195/255>;
#declare CN_Banana_Puree = rgb <178/255, 151/255, 5/255>;
#declare CN_Banana_Sparkes = rgb <246/255, 245/255, 215/255>;
#declare CN_Banana_Split = rgb <247/255, 238/255, 200/255>;
#declare CN_Banana_Yellow = rgb <255/255, 225/255, 53/255>;
#declare CN_Banana_Yogurt = rgb <250/255, 231/255, 181/255>;
#declare CN_Bananarama = rgb <228/255, 212/255, 102/255>;
#declare CN_Bananas_Foster = rgb <220/255, 190/255, 151/255>;
#declare CN_Bancroft_Village = rgb <129/255, 110/255, 84/255>;
#declare CN_Banded_Tulip = rgb <224/255, 211/255, 189/255>;
#declare CN_Bandicoot = rgb <135/255, 132/255, 102/255>;
#declare CN_Baneblade_Brown = rgb <147/255, 127/255, 109/255>;
#declare CN_Bangalore = rgb <187/255, 170/255, 136/255>;
#declare CN_Bangladesh_Green = rgb <0/255, 106/255, 79/255>;
#declare CN_Banh_Bot_Loc_Dumpling = rgb <210/255, 183/255, 98/255>;
#declare CN_Banished_Brown = rgb <116/255, 94/255, 111/255>;
#declare CN_Bank_Blue = rgb <62/255, 70/255, 82/255>;
#declare CN_Bank_Vault = rgb <117/255, 115/255, 116/255>;
#declare CN_Banksia = rgb <166/255, 178/255, 154/255>;
#declare CN_Banksia_Leaf = rgb <75/255, 85/255, 57/255>;
#declare CN_Banner_Gold = rgb <162/255, 133/255, 87/255>;
#declare CN_Bannister_Brown = rgb <128/255, 107/255, 93/255>;
#declare CN_Bannister_White = rgb <225/255, 224/255, 214/255>;
#declare CN_Banshee = rgb <218/255, 240/255, 230/255>;
#declare CN_Banyan_Serenity = rgb <152/255, 171/255, 140/255>;
#declare CN_Bara_Red = rgb <233/255, 84/255, 107/255>;
#declare CN_Baragon_Brown = rgb <85/255, 17/255, 0/255>;
#declare CN_Barbados = rgb <62/255, 102/255, 118/255>;
#declare CN_Barbados_Bay = rgb <0/255, 102/255, 101/255>;
#declare CN_Barbados_Beige = rgb <184/255, 169/255, 131/255>;
#declare CN_Barbados_Blue = rgb <39/255, 102/255, 172/255>;
#declare CN_Barbados_Cherry = rgb <170/255, 10/255, 39/255>;
#declare CN_Barbarian_Flesh = rgb <247/255, 140/255, 90/255>;
#declare CN_Barbarian_Leather = rgb <161/255, 115/255, 8/255>;
#declare CN_Barbarossa = rgb <168/255, 71/255, 52/255>;
#declare CN_Barbecue = rgb <194/255, 97/255, 87/255>;
#declare CN_Barberry = rgb <238/255, 17/255, 51/255>;
#declare CN_Barberry_Bush = rgb <210/255, 198/255, 31/255>;
#declare CN_Barberry_Sand = rgb <225/255, 212/255, 188/255>;
#declare CN_Barberry_Yellow = rgb <243/255, 189/255, 50/255>;
#declare CN_Barbie_Pink = rgb <254/255, 70/255, 165/255>;
#declare CN_Barcelona_Beige = rgb <196/255, 179/255, 156/255>;
#declare CN_Barcelona_Brown = rgb <146/255, 106/255, 70/255>;
#declare CN_Bare = rgb <129/255, 126/255, 109/255>;
#declare CN_Bare_Beige = rgb <232/255, 211/255, 201/255>;
#declare CN_Bare_Bone = rgb <238/255, 221/255, 204/255>;
#declare CN_Bare_Pink = rgb <242/255, 225/255, 221/255>;
#declare CN_Barely_Aqua = rgb <186/255, 233/255, 224/255>;
#declare CN_Barely_Bloomed = rgb <221/255, 170/255, 221/255>;
#declare CN_Barely_Blue = rgb <221/255, 224/255, 223/255>;
#declare CN_Barely_Brown = rgb <221/255, 102/255, 85/255>;
#declare CN_Barely_Butter = rgb <248/255, 233/255, 194/255>;
#declare CN_Barely_Mauve = rgb <204/255, 189/255, 185/255>;
#declare CN_Barely_Peach = rgb <255/255, 233/255, 199/255>;
#declare CN_Barely_Pear = rgb <237/255, 235/255, 219/255>;
#declare CN_Barely_Pink = rgb <248/255, 215/255, 221/255>;
#declare CN_Barely_Ripe_Apricot = rgb <255/255, 227/255, 203/255>;
#declare CN_Barely_Rose = rgb <237/255, 224/255, 227/255>;
#declare CN_Barely_White = rgb <225/255, 227/255, 221/255>;
#declare CN_Barf_Green = rgb <148/255, 172/255, 2/255>;
#declare CN_Bargeboard_Brown = rgb <104/255, 83/255, 74/255>;
#declare CN_Barista = rgb <188/255, 175/255, 162/255>;
#declare CN_Barite = rgb <158/255, 123/255, 92/255>;
#declare CN_Baritone = rgb <112/255, 142/255, 149/255>;
#declare CN_Barium = rgb <244/255, 225/255, 197/255>;
#declare CN_Barium_Green = rgb <143/255, 255/255, 159/255>;
#declare CN_Bark = rgb <95/255, 88/255, 84/255>;
#declare CN_Bark_Brown = rgb <115/255, 83/255, 42/255>;
#declare CN_Bark_Sawdust = rgb <171/255, 144/255, 4/255>;
#declare CN_Barking_Prairie_Dog = rgb <197/255, 180/255, 151/255>;
#declare CN_Barley_Corn = rgb <182/255, 147/255, 92/255>;
#declare CN_Barley_Field = rgb <199/255, 188/255, 174/255>;
#declare CN_Barley_Groats = rgb <251/255, 242/255, 219/255>;
#declare CN_Barley_White = rgb <247/255, 229/255, 183/255>;
#declare CN_Barn_Door = rgb <142/255, 89/255, 89/255>;
#declare CN_Barn_Red = rgb <139/255, 64/255, 68/255>;
#declare CN_Barney = rgb <172/255, 29/255, 184/255>;
#declare CN_Barney_Purple = rgb <160/255, 4/255, 152/255>;
#declare CN_Barnfloor = rgb <156/255, 148/255, 128/255>;
#declare CN_Barnwood = rgb <85/255, 77/255, 68/255>;
#declare CN_Barnwood_Ash = rgb <135/255, 133/255, 126/255>;
#declare CN_Barnwood_Grey = rgb <158/255, 149/255, 137/255>;
#declare CN_Barnyard_Grass = rgb <93/255, 172/255, 81/255>;
#declare CN_Baroness = rgb <167/255, 133/255, 167/255>;
#declare CN_Baroness_Mauve = rgb <132/255, 112/255, 152/255>;
#declare CN_Baronial_Brown = rgb <90/255, 72/255, 64/255>;
#declare CN_Baroque = rgb <221/255, 170/255, 34/255>;
#declare CN_Baroque_Blue = rgb <149/255, 182/255, 181/255>;
#declare CN_Baroque_Chalk_Soft_Blue = rgb <174/255, 204/255, 203/255>;
#declare CN_Baroque_Grey = rgb <95/255, 93/255, 100/255>;
#declare CN_Baroque_Red = rgb <123/255, 79/255, 93/255>;
#declare CN_Baroque_Rose = rgb <179/255, 90/255, 102/255>;
#declare CN_Barossa = rgb <69/255, 46/255, 57/255>;
#declare CN_Barrel = rgb <240/255, 176/255, 105/255>;
#declare CN_Barrel_Stove = rgb <142/255, 126/255, 103/255>;
#declare CN_Barren = rgb <185/255, 171/255, 163/255>;
#declare CN_Barrett_Quince = rgb <245/255, 209/255, 178/255>;
#declare CN_Barricade = rgb <132/255, 98/255, 62/255>;
#declare CN_Barrier_Reef = rgb <0/255, 132/255, 161/255>;
#declare CN_Barro_Verde = rgb <159/255, 142/255, 113/255>;
#declare CN_Basalt_Black = rgb <77/255, 66/255, 62/255>;
#declare CN_Basalt_Grey = rgb <153/255, 153/255, 153/255>;
#declare CN_Base_Camp = rgb <87/255, 92/255, 58/255>;
#declare CN_Base_Sand = rgb <187/255, 153/255, 85/255>;
#declare CN_Baseball_Base = rgb <244/255, 234/255, 220/255>;
#declare CN_Bashful = rgb <227/255, 237/255, 237/255>;
#declare CN_Bashful_Blue = rgb <105/255, 148/255, 207/255>;
#declare CN_Bashful_Emu = rgb <178/255, 176/255, 172/255>;
#declare CN_Bashful_Pansy = rgb <217/255, 205/255, 229/255>;
#declare CN_Bashful_Rose = rgb <184/255, 134/255, 134/255>;
#declare CN_Basic_Coral = rgb <219/255, 195/255, 182/255>;
#declare CN_Basic_Khaki = rgb <195/255, 182/255, 159/255>;
#declare CN_Basil = rgb <135/255, 159/255, 132/255>;
#declare CN_Basil_Chiffonade = rgb <130/255, 130/255, 73/255>;
#declare CN_Basil_Green = rgb <84/255, 98/255, 46/255>;
#declare CN_Basil_Icing = rgb <226/255, 230/255, 219/255>;
#declare CN_Basil_Mauve = rgb <108/255, 84/255, 114/255>;
#declare CN_Basil_Pesto = rgb <82/255, 157/255, 110/255>;
#declare CN_Basil_Smash = rgb <183/255, 225/255, 161/255>;
#declare CN_Basilica_Blue = rgb <74/255, 159/255, 167/255>;
#declare CN_Basilisk = rgb <154/255, 179/255, 141/255>;
#declare CN_Basilisk_Lizard = rgb <188/255, 236/255, 172/255>;
#declare CN_Basin_Blue = rgb <185/255, 222/255, 228/255>;
#declare CN_Basket_Beige = rgb <192/255, 169/255, 139/255>;
#declare CN_Basket_of_Gold = rgb <244/255, 204/255, 60/255>;
#declare CN_Basketball = rgb <238/255, 103/255, 48/255>;
#declare CN_Basketry = rgb <189/255, 162/255, 134/255>;
#declare CN_Basketweave_Beige = rgb <202/255, 173/255, 146/255>;
#declare CN_Basmati_White = rgb <235/255, 225/255, 201/255>;
#declare CN_Basque_Green = rgb <95/255, 96/255, 51/255>;
#declare CN_Bassinet = rgb <211/255, 193/255, 203/255>;
#declare CN_Basswood = rgb <201/255, 177/255, 150/255>;
#declare CN_Bastard_amber = rgb <255/255, 204/255, 136/255>;
#declare CN_Bastille = rgb <44/255, 44/255, 50/255>;
#declare CN_Bastion_Grey = rgb <77/255, 74/255, 74/255>;
#declare CN_Bat_Wing = rgb <126/255, 116/255, 102/255>;
#declare CN_Bat_Signal = rgb <254/255, 255/255, 0/255>;
#declare CN_Bats_Blood_Soup = rgb <238/255, 51/255, 102/255>;
#declare CN_Batch_Blue = rgb <135/255, 178/255, 201/255>;
#declare CN_Bateau = rgb <27/255, 117/255, 152/255>;
#declare CN_Bateau_Brown = rgb <122/255, 95/255, 90/255>;
#declare CN_Bath_Bubbles = rgb <230/255, 242/255, 234/255>;
#declare CN_Bath_Green = rgb <10/255, 105/255, 106/255>;
#declare CN_Bath_Salt_Green = rgb <187/255, 222/255, 215/255>;
#declare CN_Bath_Turquoise = rgb <98/255, 186/255, 168/255>;
#declare CN_Bath_Water = rgb <136/255, 238/255, 238/255>;
#declare CN_Bathe_Blue = rgb <194/255, 224/255, 227/255>;
#declare CN_Bathing = rgb <147/255, 201/255, 208/255>;
#declare CN_Batik_Lilac = rgb <126/255, 115/255, 139/255>;
#declare CN_Batik_Pink = rgb <156/255, 101/255, 126/255>;
#declare CN_Batman = rgb <101/255, 110/255, 114/255>;
#declare CN_Batmans_NES_Cape = rgb <148/255, 0/255, 132/255>;
#declare CN_Baton = rgb <134/255, 111/255, 90/255>;
#declare CN_Baton_Rouge = rgb <151/255, 60/255, 108/255>;
#declare CN_Bats_Cloak = rgb <31/255, 21/255, 24/255>;
#declare CN_Battered_Sausage = rgb <237/255, 226/255, 212/255>;
#declare CN_Battery_Charged_Blue = rgb <29/255, 172/255, 212/255>;
#declare CN_Battle_Blue = rgb <116/255, 130/255, 143/255>;
#declare CN_Battle_Cat = rgb <43/255, 116/255, 20/255>;
#declare CN_Battle_Dress = rgb <126/255, 130/255, 112/255>;
#declare CN_Battle_Harbor = rgb <156/255, 156/255, 130/255>;
#declare CN_Battleship_Green = rgb <130/255, 143/255, 114/255>;
#declare CN_Battleship_Grey = rgb <111/255, 116/255, 118/255>;
#declare CN_Battletoad = rgb <17/255, 204/255, 85/255>;
#declare CN_Batu_Cave = rgb <89/255, 84/255, 56/255>;
#declare CN_Bauhaus = rgb <63/255, 64/255, 64/255>;
#declare CN_Bauhaus_Blue = rgb <0/255, 99/255, 146/255>;
#declare CN_Bauhaus_Buff = rgb <207/255, 180/255, 158/255>;
#declare CN_Bauhaus_Gold = rgb <176/255, 152/255, 111/255>;
#declare CN_Bauhaus_Tan = rgb <204/255, 196/255, 174/255>;
#declare CN_Bavarian = rgb <77/255, 94/255, 66/255>;
#declare CN_Bavarian_Blue = rgb <28/255, 51/255, 130/255>;
#declare CN_Bavarian_Cream = rgb <255/255, 249/255, 221/255>;
#declare CN_Bavarian_Gentian = rgb <32/255, 0/255, 109/255>;
#declare CN_Bavarian_Green = rgb <116/255, 154/255, 84/255>;
#declare CN_Bavarian_Sweet_Mustard = rgb <77/255, 49/255, 19/255>;
#declare CN_Bay = rgb <186/255, 229/255, 214/255>;
#declare CN_Bay_Area = rgb <175/255, 164/255, 144/255>;
#declare CN_Bay_Brown = rgb <119/255, 51/255, 0/255>;
#declare CN_Bay_Fog = rgb <152/255, 153/255, 176/255>;
#declare CN_Bay_Isle_Pointe = rgb <33/255, 64/255, 72/255>;
#declare CN_Bay_Leaf = rgb <134/255, 121/255, 61/255>;
#declare CN_Bay_of_Hope = rgb <191/255, 201/255, 208/255>;
#declare CN_Bay_of_Many = rgb <53/255, 62/255, 100/255>;
#declare CN_Bay_Salt = rgb <210/255, 205/255, 188/255>;
#declare CN_Bay_Scallop = rgb <251/255, 230/255, 205/255>;
#declare CN_Bay_Site = rgb <50/255, 95/255, 138/255>;
#declare CN_Bay_View = rgb <106/255, 129/255, 158/255>;
#declare CN_Bay_Water = rgb <170/255, 173/255, 148/255>;
#declare CN_Bay_Wharf = rgb <116/255, 127/255, 137/255>;
#declare CN_Bays_Water = rgb <123/255, 154/255, 173/255>;
#declare CN_Bayberry = rgb <37/255, 89/255, 88/255>;
#declare CN_Bayberry_Frost = rgb <208/255, 217/255, 199/255>;
#declare CN_Bayberry_Wax = rgb <182/255, 170/255, 137/255>;
#declare CN_Bayern_Blue = rgb <0/255, 152/255, 212/255>;
#declare CN_Bayou = rgb <32/255, 112/255, 111/255>;
#declare CN_Bayshore = rgb <137/255, 206/255, 224/255>;
#declare CN_Bayside = rgb <95/255, 201/255, 191/255>;
#declare CN_Bazaar = rgb <143/255, 119/255, 119/255>;
#declare CN_Bazooka_Pink = rgb <255/255, 166/255, 201/255>;
#declare CN_BBQ = rgb <163/255, 80/255, 70/255>;
#declare CN_Be_Daring = rgb <255/255, 201/255, 67/255>;
#declare CN_Be_Mine = rgb <244/255, 227/255, 231/255>;
#declare CN_Be_My_Valentine = rgb <236/255, 157/255, 195/255>;
#declare CN_Be_Spontaneous = rgb <165/255, 203/255, 102/255>;
#declare CN_Be_Yourself = rgb <155/255, 152/255, 61/255>;
#declare CN_Beach_Bag = rgb <173/255, 184/255, 100/255>;
#declare CN_Beach_Ball = rgb <239/255, 199/255, 0/255>;
#declare CN_Beach_Blue = rgb <95/255, 156/255, 162/255>;
#declare CN_Beach_Boardwalk = rgb <206/255, 171/255, 144/255>;
#declare CN_Beach_Cabana = rgb <166/255, 144/255, 129/255>;
#declare CN_Beach_Casuarina = rgb <102/255, 90/255, 56/255>;
#declare CN_Beach_Cottage = rgb <148/255, 173/255, 176/255>;
#declare CN_Beach_Dune = rgb <198/255, 187/255, 156/255>;
#declare CN_Beach_Foam = rgb <205/255, 224/255, 225/255>;
#declare CN_Beach_Glass = rgb <150/255, 223/255, 206/255>;
#declare CN_Beach_Grass = rgb <220/255, 221/255, 184/255>;
#declare CN_Beach_House = rgb <237/255, 212/255, 129/255>;
#declare CN_Beach_Lilac = rgb <189/255, 162/255, 196/255>;
#declare CN_Beach_Party = rgb <251/255, 208/255, 92/255>;
#declare CN_Beach_Sand = rgb <251/255, 185/255, 149/255>;
#declare CN_Beach_Towel = rgb <252/255, 227/255, 179/255>;
#declare CN_Beach_Trail = rgb <254/255, 222/255, 202/255>;
#declare CN_Beach_Umbrella = rgb <129/255, 154/255, 170/255>;
#declare CN_Beach_White = rgb <246/255, 238/255, 214/255>;
#declare CN_Beach_Wind = rgb <220/255, 225/255, 226/255>;
#declare CN_Beach_Woods = rgb <202/255, 192/255, 176/255>;
#declare CN_Beachcomber = rgb <217/255, 228/255, 229/255>;
#declare CN_Beachcombing = rgb <228/255, 198/255, 131/255>;
#declare CN_Beachside_Drive = rgb <172/255, 219/255, 219/255>;
#declare CN_Beachside_Villa = rgb <195/255, 178/255, 150/255>;
#declare CN_Beachwalk = rgb <210/255, 177/255, 122/255>;
#declare CN_Beachy_Keen = rgb <230/255, 208/255, 182/255>;
#declare CN_Beacon_Blue = rgb <38/255, 92/255, 152/255>;
#declare CN_Beacon_Yellow = rgb <242/255, 201/255, 138/255>;
#declare CN_Beaded_Blue = rgb <73/255, 77/255, 139/255>;
#declare CN_Beagle_Brown = rgb <141/255, 103/255, 55/255>;
#declare CN_Beaming_Blue = rgb <51/255, 255/255, 255/255>;
#declare CN_Beaming_Sun = rgb <255/255, 248/255, 223/255>;
#declare CN_Bean_Counter = rgb <104/255, 117/255, 93/255>;
#declare CN_Bean_Green = rgb <104/255, 92/255, 39/255>;
#declare CN_Bean_Pot = rgb <139/255, 107/255, 81/255>;
#declare CN_Bean_Shoot = rgb <145/255, 146/255, 58/255>;
#declare CN_Bean_Sprout = rgb <243/255, 249/255, 233/255>;
#declare CN_Bean_White = rgb <235/255, 240/255, 228/255>;
#declare CN_Beanstalk = rgb <49/255, 170/255, 116/255>;
#declare CN_Bear_Brown = rgb <68/255, 56/255, 43/255>;
#declare CN_Bear_Hug = rgb <121/255, 99/255, 89/255>;
#declare CN_Bear_in_Mind = rgb <91/255, 74/255, 68/255>;
#declare CN_Bear_Rug = rgb <90/255, 73/255, 67/255>;
#declare CN_Bearsuit = rgb <125/255, 117/255, 109/255>;
#declare CN_Beastly_Flesh = rgb <104/255, 12/255, 8/255>;
#declare CN_Beasty_Brown = rgb <102/255, 51/255, 0/255>;
#declare CN_Beat_Around_the_Bush = rgb <110/255, 106/255, 68/255>;
#declare CN_Beaten_Copper = rgb <115/255, 55/255, 45/255>;
#declare CN_Beaten_Purple = rgb <78/255, 5/255, 80/255>;
#declare CN_Beaten_Track = rgb <209/255, 190/255, 146/255>;
#declare CN_Beatnik = rgb <95/255, 135/255, 72/255>;
#declare CN_Beatrice = rgb <190/255, 186/255, 217/255>;
#declare CN_Beau_Blue = rgb <188/255, 212/255, 230/255>;
#declare CN_Beaujolais = rgb <128/255, 48/255, 76/255>;
#declare CN_Beaumont_Brown = rgb <146/255, 119/255, 76/255>;
#declare CN_Beauport_Aubergine = rgb <85/255, 63/255, 68/255>;
#declare CN_Beautiful_Blue = rgb <24/255, 109/255, 182/255>;
#declare CN_Beautiful_Darkness = rgb <104/255, 109/255, 112/255>;
#declare CN_Beautiful_Dream = rgb <182/255, 199/255, 227/255>;
#declare CN_Beautiful_Mint = rgb <214/255, 218/255, 214/255>;
#declare CN_Beauty = rgb <134/255, 107/255, 141/255>;
#declare CN_Beauty_Bush = rgb <235/255, 185/255, 179/255>;
#declare CN_Beauty_Patch = rgb <131/255, 79/255, 68/255>;
#declare CN_Beauty_Queen = rgb <190/255, 92/255, 135/255>;
#declare CN_Beauty_Secret = rgb <199/255, 158/255, 162/255>;
#declare CN_Beauty_Spot = rgb <96/255, 73/255, 56/255>;
#declare CN_Beaver = rgb <146/255, 111/255, 91/255>;
#declare CN_Beaver_Fur = rgb <153/255, 120/255, 103/255>;
#declare CN_Beaver_Kit = rgb <159/255, 129/255, 112/255>;
#declare CN_Beaver_Pelt = rgb <96/255, 86/255, 76/255>;
#declare CN_Bechamel = rgb <244/255, 238/255, 224/255>;
#declare CN_Becker_Blue = rgb <96/255, 120/255, 121/255>;
#declare CN_Beckett = rgb <133/255, 166/255, 153/255>;
#declare CN_Becquerel = rgb <75/255, 236/255, 19/255>;
#declare CN_Bed_of_Roses = rgb <184/255, 147/255, 171/255>;
#declare CN_Bedazzled = rgb <211/255, 185/255, 204/255>;
#declare CN_Bedbox = rgb <150/255, 135/255, 117/255>;
#declare CN_Bedford_Brown = rgb <170/255, 136/255, 128/255>;
#declare CN_Bedrock = rgb <158/255, 157/255, 153/255>;
#declare CN_Bedtime_Story = rgb <225/255, 176/255, 144/255>;
#declare CN_Bee = rgb <241/255, 186/255, 85/255>;
#declare CN_Bee_Cluster = rgb <255/255, 170/255, 51/255>;
#declare CN_Bee_Hall = rgb <242/255, 204/255, 100/255>;
#declare CN_Bee_Master = rgb <115/255, 91/255, 59/255>;
#declare CN_Bee_Pollen = rgb <235/255, 202/255, 112/255>;
#declare CN_Bee_Yellow = rgb <254/255, 255/255, 50/255>;
#declare CN_Bees_Knees = rgb <232/255, 217/255, 210/255>;
#declare CN_Bees_Wax = rgb <234/255, 191/255, 134/255>;
#declare CN_Beech = rgb <91/255, 79/255, 59/255>;
#declare CN_Beech_Brown = rgb <87/255, 65/255, 40/255>;
#declare CN_Beech_Fern = rgb <117/255, 128/255, 103/255>;
#declare CN_Beech_Nut = rgb <215/255, 181/255, 154/255>;
#declare CN_Beechnut = rgb <194/255, 193/255, 141/255>;
#declare CN_Beechwood = rgb <110/255, 89/255, 85/255>;
#declare CN_Beef_Bourguignon = rgb <182/255, 71/255, 1/255>;
#declare CN_Beef_Hotpot = rgb <168/255, 93/255, 46/255>;
#declare CN_Beef_Jerky = rgb <162/255, 87/255, 104/255>;
#declare CN_Beef_Patties = rgb <187/255, 85/255, 51/255>;
#declare CN_Beehive = rgb <225/255, 183/255, 129/255>;
#declare CN_Beekeeper = rgb <246/255, 228/255, 145/255>;
#declare CN_Beer = rgb <242/255, 142/255, 28/255>;
#declare CN_Beer_Garden = rgb <68/255, 153/255, 51/255>;
#declare CN_Beer_Glazed_Bacon = rgb <119/255, 51/255, 17/255>;
#declare CN_Beeswax = rgb <233/255, 215/255, 171/255>;
#declare CN_Beeswax_Candle = rgb <191/255, 126/255, 65/255>;
#declare CN_Beeswing = rgb <245/255, 210/255, 151/255>;
#declare CN_Beet_Red = rgb <122/255, 31/255, 61/255>;
#declare CN_Beetle = rgb <85/255, 88/255, 76/255>;
#declare CN_Beetroot = rgb <102/255, 63/255, 68/255>;
#declare CN_Beetroot_Purple = rgb <207/255, 45/255, 113/255>;
#declare CN_Beetroot_Rice = rgb <197/255, 143/255, 157/255>;
#declare CN_Beets = rgb <115/255, 106/255, 134/255>;
#declare CN_Befitting = rgb <150/255, 73/255, 109/255>;
#declare CN_Before_the_Storm = rgb <77/255, 106/255, 119/255>;
#declare CN_Before_Winter = rgb <189/255, 111/255, 86/255>;
#declare CN_Beggar = rgb <90/255, 77/255, 57/255>;
#declare CN_Begonia = rgb <250/255, 110/255, 121/255>;
#declare CN_Begonia_Pink = rgb <236/255, 154/255, 190/255>;
#declare CN_Begonia_Rose = rgb <195/255, 121/255, 127/255>;
#declare CN_Beguiling_Mauve = rgb <175/255, 167/255, 172/255>;
#declare CN_Beige = rgb <230/255, 218/255, 166/255>;
#declare CN_Beige_Ganesh = rgb <207/255, 176/255, 149/255>;
#declare CN_Beige_Green = rgb <224/255, 216/255, 176/255>;
#declare CN_Beige_Intenso = rgb <197/255, 168/255, 141/255>;
#declare CN_Beige_Linen = rgb <226/255, 218/255, 198/255>;
#declare CN_Beige_Red = rgb <222/255, 148/255, 8/255>;
#declare CN_Beige_Royal = rgb <207/255, 200/255, 184/255>;
#declare CN_Beige_Topaz = rgb <255/255, 200/255, 124/255>;
#declare CN_Beijing_Blue = rgb <62/255, 125/255, 170/255>;
#declare CN_Beijing_Moon = rgb <169/255, 162/255, 163/255>;
#declare CN_Bel_Air_Blue = rgb <129/255, 154/255, 193/255>;
#declare CN_Bel_Esprit = rgb <155/255, 188/255, 195/255>;
#declare CN_Belfast = rgb <85/255, 141/255, 79/255>;
#declare CN_Belgian_Block = rgb <163/255, 169/255, 166/255>;
#declare CN_Belgian_Blonde = rgb <247/255, 239/255, 208/255>;
#declare CN_Belgian_Cream = rgb <249/255, 241/255, 226/255>;
#declare CN_Belgian_Sweet = rgb <141/255, 117/255, 96/255>;
#declare CN_Belgian_Waffle = rgb <243/255, 223/255, 182/255>;
#declare CN_Believable_Buff = rgb <219/255, 199/255, 168/255>;
#declare CN_Belize = rgb <127/255, 211/255, 211/255>;
#declare CN_Belize_Green = rgb <185/255, 195/255, 179/255>;
#declare CN_Bell_Blue = rgb <97/255, 139/255, 151/255>;
#declare CN_Bell_Heather = rgb <164/255, 117/255, 177/255>;
#declare CN_Bell_Tower = rgb <218/255, 208/255, 187/255>;
#declare CN_Bella = rgb <87/255, 64/255, 87/255>;
#declare CN_Bella_Green = rgb <147/255, 195/255, 177/255>;
#declare CN_Bella_Mia = rgb <218/255, 197/255, 189/255>;
#declare CN_Bella_Pink = rgb <224/255, 129/255, 148/255>;
#declare CN_Bella_Sera = rgb <64/255, 70/255, 93/255>;
#declare CN_Bella_Vista = rgb <11/255, 105/255, 91/255>;
#declare CN_Belladonna = rgb <34/255, 0/255, 17/255>;
#declare CN_Belladonnas_Leaf = rgb <173/255, 195/255, 167/255>;
#declare CN_Bellagio_Fountains = rgb <183/255, 223/255, 243/255>;
#declare CN_Belle_of_the_Ball = rgb <227/255, 203/255, 192/255>;
#declare CN_Bellflower = rgb <93/255, 102/255, 170/255>;
#declare CN_Bellflower_Blue = rgb <225/255, 233/255, 239/255>;
#declare CN_Bellflower_Violet = rgb <178/255, 165/255, 183/255>;
#declare CN_Bellini = rgb <244/255, 201/255, 177/255>;
#declare CN_Bellini_Fizz = rgb <245/255, 199/255, 142/255>;
#declare CN_Belly_Fire = rgb <119/255, 59/255, 56/255>;
#declare CN_Belly_Flop = rgb <0/255, 129/255, 127/255>;
#declare CN_Beloved_Pink = rgb <233/255, 211/255, 212/255>;
#declare CN_Below_Zero = rgb <135/255, 205/255, 237/255>;
#declare CN_Beluga = rgb <239/255, 242/255, 241/255>;
#declare CN_Belvedere_Cream = rgb <227/255, 219/255, 195/255>;
#declare CN_Belyi_White = rgb <240/255, 241/255, 225/255>;
#declare CN_Benevolence = rgb <105/255, 73/255, 119/255>;
#declare CN_Benevolent_Pink = rgb <221/255, 17/255, 136/255>;
#declare CN_Bengal = rgb <204/255, 151/255, 77/255>;
#declare CN_Bengal_Blue = rgb <56/255, 115/255, 139/255>;
#declare CN_Bengal_Grass = rgb <142/255, 119/255, 63/255>;
#declare CN_Bengala_Red = rgb <143/255, 46/255, 20/255>;
#declare CN_Bengara_Red = rgb <145/255, 50/255, 37/255>;
#declare CN_Beni_Shoga = rgb <184/255, 82/255, 65/255>;
#declare CN_Benifuji = rgb <187/255, 119/255, 150/255>;
#declare CN_Benihi_Red = rgb <243/255, 83/255, 54/255>;
#declare CN_Benikakehana_Purple = rgb <90/255, 79/255, 116/255>;
#declare CN_Benikeshinezumi_Purple = rgb <68/255, 49/255, 46/255>;
#declare CN_Benimidori_Purple = rgb <120/255, 119/255, 155/255>;
#declare CN_Benitoite = rgb <0/255, 123/255, 170/255>;
#declare CN_Beniukon_Bronze = rgb <251/255, 129/255, 54/255>;
#declare CN_Benthic_Black = rgb <0/255, 0/255, 17/255>;
#declare CN_Bento_Box = rgb <204/255, 54/255, 60/255>;
#declare CN_Bergamot = rgb <149/255, 199/255, 3/255>;
#declare CN_Bergamot_Orange = rgb <245/255, 157/255, 89/255>;
#declare CN_Bering_Sea = rgb <75/255, 91/255, 110/255>;
#declare CN_Bering_Wave = rgb <61/255, 109/255, 132/255>;
#declare CN_Berkeley_Hills = rgb <126/255, 97/255, 63/255>;
#declare CN_Berkshire_Lace = rgb <240/255, 225/255, 207/255>;
#declare CN_Berlin_Blue = rgb <85/255, 136/255, 204/255>;
#declare CN_Bermuda = rgb <27/255, 125/255, 141/255>;
#declare CN_Bermuda_Blue = rgb <140/255, 177/255, 194/255>;
#declare CN_Bermuda_Grass = rgb <161/255, 159/255, 121/255>;
#declare CN_Bermuda_Grey = rgb <107/255, 139/255, 162/255>;
#declare CN_Bermuda_Onion = rgb <157/255, 90/255, 143/255>;
#declare CN_Bermuda_Sand = rgb <218/255, 203/255, 191/255>;
#declare CN_Bermuda_Shell = rgb <249/255, 238/255, 227/255>;
#declare CN_Bermuda_Son = rgb <240/255, 233/255, 190/255>;
#declare CN_Bermuda_Triangle = rgb <111/255, 140/255, 159/255>;
#declare CN_Bermudagrass = rgb <107/255, 194/255, 113/255>;
#declare CN_Bermudan_Blue = rgb <56/255, 97/255, 113/255>;
#declare CN_Bern_Red = rgb <226/255, 9/255, 9/255>;
#declare CN_Berries_and_Cream = rgb <158/255, 106/255, 117/255>;
#declare CN_Berries_n_Cream = rgb <242/255, 184/255, 202/255>;
#declare CN_Berry = rgb <153/255, 15/255, 75/255>;
#declare CN_Berry_Blackmail = rgb <102/255, 34/255, 119/255>;
#declare CN_Berry_Bliss = rgb <158/255, 130/255, 149/255>;
#declare CN_Berry_Blue = rgb <50/255, 96/255, 122/255>;
#declare CN_Berry_Blue_Green = rgb <38/255, 75/255, 86/255>;
#declare CN_Berry_Blush = rgb <184/255, 133/255, 145/255>;
#declare CN_Berry_Boost = rgb <187/255, 85/255, 136/255>;
#declare CN_Berry_Bright = rgb <160/255, 132/255, 151/255>;
#declare CN_Berry_Brown = rgb <84/255, 79/255, 76/255>;
#declare CN_Berry_Burst = rgb <172/255, 114/255, 175/255>;
#declare CN_Berry_Bush = rgb <119/255, 66/255, 78/255>;
#declare CN_Berry_Chalk = rgb <166/255, 174/255, 187/255>;
#declare CN_Berry_Charm = rgb <79/255, 71/255, 99/255>;
#declare CN_Berry_Cheesecake = rgb <248/255, 227/255, 221/255>;
#declare CN_Berry_Chocolate = rgb <63/255, 0/255, 15/255>;
#declare CN_Berry_Conserve = rgb <118/255, 82/255, 105/255>;
#declare CN_Berry_Cream = rgb <154/255, 140/255, 162/255>;
#declare CN_Berry_Crush = rgb <170/255, 103/255, 114/255>;
#declare CN_Berry_Frappe = rgb <179/255, 161/255, 198/255>;
#declare CN_Berry_Frost = rgb <235/255, 222/255, 215/255>;
#declare CN_Berry_Jam = rgb <101/255, 88/255, 131/255>;
#declare CN_Berry_Light = rgb <103/255, 59/255, 102/255>;
#declare CN_Berry_Mix = rgb <85/255, 90/255, 144/255>;
#declare CN_Berry_Mojito = rgb <182/255, 202/255, 202/255>;
#declare CN_Berry_Patch = rgb <132/255, 57/255, 93/255>;
#declare CN_Berry_Pie = rgb <79/255, 109/255, 142/255>;
#declare CN_Berry_Popsicle = rgb <214/255, 165/255, 205/255>;
#declare CN_Berry_Riche = rgb <229/255, 162/255, 171/255>;
#declare CN_Berry_Rossi = rgb <153/255, 34/255, 68/255>;
#declare CN_Berry_Smoothie = rgb <137/255, 83/255, 96/255>;
#declare CN_Berry_Syrup = rgb <100/255, 83/255, 124/255>;
#declare CN_Berry_Wine = rgb <98/255, 77/255, 85/255>;
#declare CN_Berta_Blue = rgb <69/255, 220/255, 255/255>;
#declare CN_Beru = rgb <191/255, 228/255, 212/255>;
#declare CN_Beryl_Black_Green = rgb <43/255, 50/255, 45/255>;
#declare CN_Beryl_Green = rgb <188/255, 191/255, 168/255>;
#declare CN_Beryl_Pearl = rgb <226/255, 227/255, 223/255>;
#declare CN_Beryl_Red = rgb <161/255, 99/255, 129/255>;
#declare CN_Beryllonite = rgb <233/255, 229/255, 215/255>;
#declare CN_Bessie = rgb <104/255, 94/255, 91/255>;
#declare CN_Best_Beige = rgb <198/255, 180/255, 156/255>;
#declare CN_Best_Bronze = rgb <93/255, 81/255, 62/255>;
#declare CN_Best_in_Show = rgb <185/255, 183/255, 189/255>;
#declare CN_Best_of_Summer = rgb <247/255, 242/255, 217/255>;
#declare CN_Best_of_the_Bunch = rgb <189/255, 84/255, 66/255>;
#declare CN_Bestial_Brown = rgb <107/255, 57/255, 0/255>;
#declare CN_Bestial_Red = rgb <153/255, 34/255, 17/255>;
#declare CN_Bestigor_Flesh = rgb <211/255, 138/255, 87/255>;
#declare CN_Betalain_Red = rgb <125/255, 101/255, 92/255>;
#declare CN_Betel_Nut_Dye = rgb <53/255, 41/255, 37/255>;
#declare CN_Bethany = rgb <202/255, 219/255, 189/255>;
#declare CN_Bethlehem_Red = rgb <238/255, 0/255, 34/255>;
#declare CN_Bethlehem_Superstar = rgb <234/255, 238/255, 218/255>;
#declare CN_Betsy = rgb <115/255, 201/255, 217/255>;
#declare CN_Betta_Fish = rgb <58/255, 107/255, 102/255>;
#declare CN_Better_Than_Beige = rgb <235/255, 226/255, 203/255>;
#declare CN_Beurre_Blanc = rgb <237/255, 225/255, 190/255>;
#declare CN_Beveled_Glass = rgb <122/255, 204/255, 184/255>;
#declare CN_Bewitching = rgb <117/255, 73/255, 94/255>;
#declare CN_Bewitching_Blue = rgb <187/255, 208/255, 227/255>;
#declare CN_Beyond_the_Clouds = rgb <170/255, 238/255, 255/255>;
#declare CN_Beyond_the_Pines = rgb <104/255, 128/255, 73/255>;
#declare CN_Beyond_the_Wall = rgb <215/255, 224/255, 235/255>;
#declare CN_Bff = rgb <219/255, 176/255, 211/255>;
#declare CN_Bhura_Brown = rgb <148/255, 119/255, 6/255>;
#declare CN_Bialowieza_Forest = rgb <28/255, 80/255, 34/255>;
#declare CN_Bianca = rgb <244/255, 239/255, 224/255>;
#declare CN_Bianchi_Green = rgb <61/255, 207/255, 194/255>;
#declare CN_Bicycle_Yellow = rgb <255/255, 229/255, 140/255>;
#declare CN_Bicyclette = rgb <128/255, 44/255, 58/255>;
#declare CN_Bidwell_Blue = rgb <169/255, 185/255, 181/255>;
#declare CN_Bidwell_Brown = rgb <177/255, 156/255, 143/255>;
#declare CN_Biedermeier_Blue = rgb <80/255, 124/255, 160/255>;
#declare CN_Biel_Tan_Green = rgb <27/255, 161/255, 105/255>;
#declare CN_Bierwurst = rgb <240/255, 144/255, 141/255>;
#declare CN_Big_Band = rgb <175/255, 171/255, 160/255>;
#declare CN_Big_Bang_Pink = rgb <255/255, 0/255, 153/255>;
#declare CN_Big_Bus_Yellow = rgb <255/255, 218/255, 139/255>;
#declare CN_Big_Chill = rgb <126/255, 203/255, 226/255>;
#declare CN_Big_Cypress = rgb <185/255, 134/255, 117/255>;
#declare CN_Big_Daddy_Blue = rgb <93/255, 107/255, 117/255>;
#declare CN_Big_Dip_O_Ruby = rgb <156/255, 37/255, 66/255>;
#declare CN_Big_Dipper = rgb <65/255, 73/255, 75/255>;
#declare CN_Big_Fish = rgb <153/255, 163/255, 142/255>;
#declare CN_Big_Fish_to_Fry = rgb <218/255, 219/255, 225/255>;
#declare CN_Big_Foot_Feet = rgb <232/255, 142/255, 90/255>;
#declare CN_Big_Horn_Mountains = rgb <183/255, 158/255, 148/255>;
#declare CN_Big_Sky = rgb <205/255, 226/255, 222/255>;
#declare CN_Big_Spender = rgb <172/255, 221/255, 175/255>;
#declare CN_Big_Stone = rgb <51/255, 64/255, 70/255>;
#declare CN_Big_Stone_Beach = rgb <136/255, 110/255, 84/255>;
#declare CN_Big_Sur = rgb <179/255, 202/255, 220/255>;
#declare CN_Big_Sur_Blue_Jade = rgb <63/255, 110/255, 142/255>;
#declare CN_Big_Surf = rgb <150/255, 208/255, 209/255>;
#declare CN_Big_Yellow_Streak = rgb <255/255, 238/255, 34/255>;
#declare CN_Big_Yellow_Taxi = rgb <255/255, 255/255, 51/255>;
#declare CN_Bigfoot = rgb <113/255, 81/255, 69/255>;
#declare CN_Bighorn_Sheep = rgb <32/255, 18/255, 14/255>;
#declare CN_Bijou_Blue = rgb <78/255, 94/255, 127/255>;
#declare CN_Bijou_Red = rgb <163/255, 61/255, 59/255>;
#declare CN_Bijoux_Green = rgb <103/255, 107/255, 85/255>;
#declare CN_Biking_Red = rgb <119/255, 33/255, 46/255>;
#declare CN_Biking_Trail = rgb <195/255, 192/255, 177/255>;
#declare CN_Bilbao = rgb <62/255, 128/255, 39/255>;
#declare CN_Bilberry = rgb <113/255, 119/255, 126/255>;
#declare CN_Bile = rgb <181/255, 195/255, 6/255>;
#declare CN_Bilious_Brown = rgb <227/255, 159/255, 8/255>;
#declare CN_Bilious_Green = rgb <169/255, 209/255, 113/255>;
#declare CN_Billabong = rgb <27/255, 111/255, 129/255>;
#declare CN_Billet = rgb <173/255, 124/255, 53/255>;
#declare CN_Billiard = rgb <0/255, 170/255, 146/255>;
#declare CN_Billiard_Ball = rgb <39/255, 107/255, 64/255>;
#declare CN_Billiard_Green = rgb <48/255, 90/255, 74/255>;
#declare CN_Billiard_Room = rgb <80/255, 132/255, 110/255>;
#declare CN_Billiard_Table = rgb <21/255, 88/255, 67/255>;
#declare CN_Billowing_Clouds = rgb <216/255, 222/255, 227/255>;
#declare CN_Billowing_Sail = rgb <216/255, 231/255, 231/255>;
#declare CN_Billowing_Smoke = rgb <110/255, 114/255, 106/255>;
#declare CN_Billowy_Breeze = rgb <175/255, 199/255, 205/255>;
#declare CN_Billowy_Clouds = rgb <246/255, 240/255, 233/255>;
#declare CN_Billowy_Down = rgb <239/255, 240/255, 233/255>;
#declare CN_Billycart_Blue = rgb <76/255, 119/255, 164/255>;
#declare CN_Biloba_Flower = rgb <174/255, 153/255, 210/255>;
#declare CN_Biloxi = rgb <244/255, 228/255, 205/255>;
#declare CN_Biloxi_Blue = rgb <0/255, 117/255, 184/255>;
#declare CN_Biltmore_Buff = rgb <227/255, 201/255, 161/255>;
#declare CN_Biltong = rgb <65/255, 2/255, 0/255>;
#declare CN_Bimini_Blue = rgb <0/255, 122/255, 145/255>;
#declare CN_Binary_Star = rgb <97/255, 103/255, 103/255>;
#declare CN_Bindi_Dot = rgb <139/255, 52/255, 57/255>;
#declare CN_Bindi_Red = rgb <176/255, 0/255, 60/255>;
#declare CN_Bing_Cherry_Pie = rgb <175/255, 73/255, 103/255>;
#declare CN_Binrouji_Black = rgb <67/255, 61/255, 60/255>;
#declare CN_Bio_Blue = rgb <70/255, 95/255, 158/255>;
#declare CN_Biogenic_Sand = rgb <255/255, 239/255, 213/255>;
#declare CN_Biohazard_Suit = rgb <251/255, 251/255, 76/255>;
#declare CN_Biology_Experiments = rgb <145/255, 161/255, 53/255>;
#declare CN_Bioluminescence = rgb <85/255, 238/255, 255/255>;
#declare CN_BioShock = rgb <136/255, 153/255, 0/255>;
#declare CN_Biotic_Grasp = rgb <238/255, 238/255, 68/255>;
#declare CN_Biotic_Orb = rgb <238/255, 221/255, 85/255>;
#declare CN_Birch = rgb <63/255, 55/255, 38/255>;
#declare CN_Birch_Beige = rgb <217/255, 195/255, 161/255>;
#declare CN_Birch_Forest = rgb <137/255, 154/255, 139/255>;
#declare CN_Birch_Leaf_Green = rgb <99/255, 126/255, 29/255>;
#declare CN_Birch_Strain = rgb <223/255, 180/255, 95/255>;
#declare CN_Birch_White = rgb <246/255, 238/255, 223/255>;
#declare CN_Birchwood = rgb <204/255, 190/255, 172/255>;
#declare CN_Birchy_Woods = rgb <128/255, 104/255, 67/255>;
#declare CN_Bird_Blue = rgb <123/255, 146/255, 158/255>;
#declare CN_Bird_Blue_Grey = rgb <127/255, 146/255, 160/255>;
#declare CN_Bird_Flower = rgb <208/255, 193/255, 23/255>;
#declare CN_Bird_Of_Paradise = rgb <0/255, 131/255, 168/255>;
#declare CN_Birds_Child = rgb <255/255, 241/255, 207/255>;
#declare CN_Birds_Egg_Green = rgb <170/255, 204/255, 185/255>;
#declare CN_Birds_Nest = rgb <207/255, 187/255, 155/255>;
#declare CN_Bird_s_Eye = rgb <185/255, 3/255, 10/255>;
#declare CN_Birdhouse_Brown = rgb <108/255, 72/255, 58/255>;
#declare CN_Birdie = rgb <233/255, 228/255, 36/255>;
#declare CN_Birdie_Num_Num = rgb <137/255, 172/255, 218/255>;
#declare CN_Birdseed = rgb <226/255, 194/255, 142/255>;
#declare CN_Birdseye_Maple = rgb <228/255, 196/255, 149/255>;
#declare CN_Biro_Blue = rgb <47/255, 57/255, 70/255>;
#declare CN_Birodo_Green = rgb <34/255, 70/255, 52/255>;
#declare CN_Birth_of_a_Star = rgb <252/255, 233/255, 223/255>;
#declare CN_Birthday_Cake = rgb <233/255, 210/255, 204/255>;
#declare CN_Birthday_Candle = rgb <207/255, 162/255, 173/255>;
#declare CN_Birthday_King = rgb <155/255, 220/255, 185/255>;
#declare CN_Birthday_Suit = rgb <226/255, 199/255, 182/255>;
#declare CN_Birthstone = rgb <121/255, 84/255, 122/255>;
#declare CN_Biscay = rgb <47/255, 60/255, 83/255>;
#declare CN_Biscay_Bay = rgb <9/255, 121/255, 136/255>;
#declare CN_Biscay_Green = rgb <85/255, 198/255, 169/255>;
#declare CN_Biscotti = rgb <218/255, 199/255, 171/255>;
#declare CN_Biscuit = rgb <254/255, 237/255, 202/255>;
#declare CN_Biscuit_Beige = rgb <230/255, 191/255, 166/255>;
#declare CN_Biscuit_Cream = rgb <249/255, 204/255, 183/255>;
#declare CN_Biscuit_Dough = rgb <232/255, 219/255, 189/255>;
#declare CN_Bishop_Red = rgb <196/255, 115/255, 169/255>;
#declare CN_Bismarck = rgb <72/255, 108/255, 122/255>;
#declare CN_Bison = rgb <110/255, 79/255, 58/255>;
#declare CN_Bison_Beige = rgb <159/255, 145/255, 128/255>;
#declare CN_Bison_Brown = rgb <88/255, 73/255, 65/255>;
#declare CN_Bison_Hide = rgb <181/255, 172/255, 148/255>;
#declare CN_Bisque = rgb <255/255, 228/255, 196/255>;
#declare CN_Bisque_Tan = rgb <229/255, 210/255, 176/255>;
#declare CN_Bistre = rgb <61/255, 43/255, 31/255>;
#declare CN_Bistre_Brown = rgb <150/255, 113/255, 23/255>;
#declare CN_Bistro = rgb <112/255, 89/255, 80/255>;
#declare CN_Bistro_Green = rgb <57/255, 85/255, 81/255>;
#declare CN_Bit_of_Berry = rgb <221/255, 85/255, 153/255>;
#declare CN_Bit_of_Blue = rgb <226/255, 234/255, 235/255>;
#declare CN_Bit_of_Heaven = rgb <202/255, 215/255, 222/255>;
#declare CN_Bit_of_Lime = rgb <225/255, 229/255, 172/255>;
#declare CN_Bit_of_Sugar = rgb <244/255, 242/255, 236/255>;
#declare CN_Bitcoin = rgb <255/255, 187/255, 17/255>;
#declare CN_Bite_the_Bullet = rgb <236/255, 235/255, 206/255>;
#declare CN_Bitter = rgb <136/255, 137/255, 108/255>;
#declare CN_Bitter_Briar = rgb <141/255, 116/255, 112/255>;
#declare CN_Bitter_Chocolate = rgb <158/255, 91/255, 64/255>;
#declare CN_Bitter_Clover_Green = rgb <118/255, 151/255, 137/255>;
#declare CN_Bitter_Dandelion = rgb <110/255, 203/255, 60/255>;
#declare CN_Bitter_Lemon = rgb <210/255, 219/255, 50/255>;
#declare CN_Bitter_Lime = rgb <207/255, 255/255, 0/255>;
#declare CN_Bitter_Melon = rgb <207/255, 209/255, 178/255>;
#declare CN_Bitter_Orange = rgb <213/255, 118/255, 43/255>;
#declare CN_Bitter_Sage = rgb <151/255, 161/255, 141/255>;
#declare CN_Bitter_Violet = rgb <133/255, 109/255, 158/255>;
#declare CN_Bittersweet = rgb <254/255, 160/255, 81/255>;
#declare CN_Bittersweet_Shimmer = rgb <191/255, 79/255, 81/255>;
#declare CN_Bittersweet_Stem = rgb <203/255, 180/255, 154/255>;
#declare CN_Bizarre = rgb <231/255, 210/255, 200/255>;
#declare CN_Black = rgb <0/255, 0/255, 0/255>;
#declare CN_Black_Bamboo = rgb <91/255, 93/255, 83/255>;
#declare CN_Black_Bay = rgb <71/255, 74/255, 78/255>;
#declare CN_Black_Bean = rgb <78/255, 75/255, 74/255>;
#declare CN_Black_Beauty = rgb <38/255, 38/255, 42/255>;
#declare CN_Black_Blueberry = rgb <47/255, 47/255, 72/255>;
#declare CN_Black_Boudoir = rgb <69/255, 71/255, 73/255>;
#declare CN_Black_Cat = rgb <46/255, 47/255, 49/255>;
#declare CN_Black_Chestnut_Oak = rgb <37/255, 35/255, 33/255>;
#declare CN_Black_Chocolate = rgb <68/255, 17/255, 0/255>;
#declare CN_Black_Coffee = rgb <59/255, 48/255, 47/255>;
#declare CN_Black_Coral = rgb <84/255, 98/255, 111/255>;
#declare CN_Black_Dahlia = rgb <78/255, 67/255, 77/255>;
#declare CN_Black_Diamond_Apple = rgb <138/255, 119/255, 154/255>;
#declare CN_Black_Dragons_Cauldron = rgb <84/255, 85/255, 98/255>;
#declare CN_Black_Drop = rgb <144/255, 171/255, 217/255>;
#declare CN_Black_Elder = rgb <166/255, 110/255, 122/255>;
#declare CN_Black_Elegance = rgb <80/255, 72/255, 74/255>;
#declare CN_Black_Emerald = rgb <18/255, 34/255, 29/255>;
#declare CN_Black_Evergreen = rgb <69/255, 82/255, 79/255>;
#declare CN_Black_Feather = rgb <17/255, 34/255, 34/255>;
#declare CN_Black_Flame = rgb <72/255, 75/255, 90/255>;
#declare CN_Black_Forest = rgb <94/255, 99/255, 84/255>;
#declare CN_Black_Forest_Blue = rgb <41/255, 72/255, 90/255>;
#declare CN_Black_Forest_Green = rgb <66/255, 71/255, 64/255>;
#declare CN_Black_Fox = rgb <79/255, 72/255, 66/255>;
#declare CN_Black_Garnet = rgb <78/255, 68/255, 68/255>;
#declare CN_Black_Glaze = rgb <0/255, 17/255, 17/255>;
#declare CN_Black_Green = rgb <56/255, 78/255, 73/255>;
#declare CN_Black_Grey = rgb <36/255, 39/255, 46/255>;
#declare CN_Black_Haze = rgb <224/255, 222/255, 215/255>;
#declare CN_Black_Headed_Gull = rgb <156/255, 133/255, 108/255>;
#declare CN_Black_Hills_Gold = rgb <200/255, 145/255, 128/255>;
#declare CN_Black_Hole = rgb <1/255, 2/255, 3/255>;
#declare CN_Black_Htun = rgb <17/255, 0/255, 51/255>;
#declare CN_Black_Ice = rgb <77/255, 80/255, 81/255>;
#declare CN_Black_Ink = rgb <68/255, 65/255, 60/255>;
#declare CN_Black_Iris = rgb <43/255, 48/255, 66/255>;
#declare CN_Black_Is_Beautiful = rgb <85/255, 34/255, 34/255>;
#declare CN_Black_Jasmine_Rice = rgb <116/255, 86/255, 61/255>;
#declare CN_Black_Kite = rgb <53/255, 30/255, 28/255>;
#declare CN_Black_Knight = rgb <1/255, 11/255, 19/255>;
#declare CN_Black_Lacquer = rgb <63/255, 62/255, 62/255>;
#declare CN_Black_Lead = rgb <71/255, 76/255, 77/255>;
#declare CN_Black_Leather_Jacket = rgb <37/255, 53/255, 41/255>;
#declare CN_Black_Licorice = rgb <58/255, 59/255, 59/255>;
#declare CN_Black_Locust = rgb <100/255, 103/255, 99/255>;
#declare CN_Black_Magic = rgb <79/255, 69/255, 84/255>;
#declare CN_Black_Mana = rgb <133/255, 133/255, 133/255>;
#declare CN_Black_Market = rgb <34/255, 34/255, 68/255>;
#declare CN_Black_Marlin = rgb <56/255, 55/255, 64/255>;
#declare CN_Black_Mesa = rgb <34/255, 34/255, 17/255>;
#declare CN_Black_Metal = rgb <6/255, 6/255, 6/255>;
#declare CN_Black_Mocha = rgb <75/255, 71/255, 67/255>;
#declare CN_Black_Oak = rgb <78/255, 79/255, 78/255>;
#declare CN_Black_of_Night = rgb <50/255, 54/255, 57/255>;
#declare CN_Black_Olive = rgb <59/255, 60/255, 54/255>;
#declare CN_Black_Onyx = rgb <43/255, 39/255, 43/255>;
#declare CN_Black_Orchid = rgb <82/255, 84/255, 99/255>;
#declare CN_Black_Out = rgb <34/255, 34/255, 34/255>;
#declare CN_Black_Panther = rgb <66/255, 66/255, 66/255>;
#declare CN_Black_Pearl = rgb <30/255, 39/255, 44/255>;
#declare CN_Black_Pine_Green = rgb <51/255, 101/255, 74/255>;
#declare CN_Black_Plum = rgb <108/255, 87/255, 101/255>;
#declare CN_Black_Pool = rgb <79/255, 85/255, 82/255>;
#declare CN_Black_Powder = rgb <52/255, 52/255, 44/255>;
#declare CN_Black_Power = rgb <101/255, 75/255, 55/255>;
#declare CN_Black_Pudding = rgb <164/255, 74/255, 86/255>;
#declare CN_Black_Queen = rgb <105/255, 77/255, 39/255>;
#declare CN_Black_Raspberry = rgb <22/255, 17/255, 13/255>;
#declare CN_Black_Ribbon = rgb <72/255, 76/255, 81/255>;
#declare CN_Black_River_Falls = rgb <52/255, 62/255, 84/255>;
#declare CN_Black_Rock = rgb <44/255, 45/255, 60/255>;
#declare CN_Black_Rooster = rgb <51/255, 17/255, 17/255>;
#declare CN_Black_Rose = rgb <83/255, 41/255, 52/255>;
#declare CN_Black_Russian = rgb <36/255, 37/255, 43/255>;
#declare CN_Black_Sabbath = rgb <34/255, 0/255, 34/255>;
#declare CN_Black_Sable = rgb <67/255, 75/255, 77/255>;
#declare CN_Black_Safflower = rgb <48/255, 40/255, 51/255>;
#declare CN_Black_Sand = rgb <91/255, 78/255, 75/255>;
#declare CN_Black_Sapphire = rgb <67/255, 69/255, 85/255>;
#declare CN_Black_Shadows = rgb <191/255, 175/255, 178/255>;
#declare CN_Black_Sheep = rgb <15/255, 13/255, 13/255>;
#declare CN_Black_Slug = rgb <51/255, 34/255, 17/255>;
#declare CN_Black_Smoke = rgb <62/255, 62/255, 63/255>;
#declare CN_Black_Soap = rgb <25/255, 68/255, 60/255>;
#declare CN_Black_Space = rgb <84/255, 83/255, 84/255>;
#declare CN_Black_Spruce = rgb <76/255, 87/255, 82/255>;
#declare CN_Black_Squeeze = rgb <229/255, 230/255, 223/255>;
#declare CN_Black_Suede = rgb <67/255, 67/255, 66/255>;
#declare CN_Black_Swan = rgb <51/255, 34/255, 0/255>;
#declare CN_Black_Tie = rgb <70/255, 70/255, 71/255>;
#declare CN_Black_Tortoise = rgb <53/255, 50/255, 53/255>;
#declare CN_Black_Truffle = rgb <70/255, 61/255, 62/255>;
#declare CN_Black_Velvet = rgb <34/255, 34/255, 51/255>;
#declare CN_Black_Violet = rgb <43/255, 44/255, 66/255>;
#declare CN_Black_Walnut = rgb <94/255, 79/255, 70/255>;
#declare CN_Black_Wash = rgb <12/255, 12/255, 12/255>;
#declare CN_Black_Water = rgb <46/255, 72/255, 70/255>;
#declare CN_Black_White = rgb <229/255, 228/255, 219/255>;
#declare CN_Blackadder = rgb <41/255, 44/255, 44/255>;
#declare CN_Blackberry = rgb <67/255, 24/255, 47/255>;
#declare CN_Blackberry_Black = rgb <46/255, 40/255, 72/255>;
#declare CN_Blackberry_Burgundy = rgb <76/255, 57/255, 56/255>;
#declare CN_Blackberry_Cobbler = rgb <64/255, 77/255, 106/255>;
#declare CN_Blackberry_Cordial = rgb <63/255, 42/255, 71/255>;
#declare CN_Blackberry_Cream = rgb <217/255, 211/255, 218/255>;
#declare CN_Blackberry_Deep_Red = rgb <99/255, 54/255, 84/255>;
#declare CN_Blackberry_Farm = rgb <98/255, 80/255, 107/255>;
#declare CN_Blackberry_Harvest = rgb <80/255, 67/255, 88/255>;
#declare CN_Blackberry_Jam = rgb <135/255, 101/255, 126/255>;
#declare CN_Blackberry_Leaf_Green = rgb <80/255, 127/255, 109/255>;
#declare CN_Blackberry_Mocha = rgb <165/255, 136/255, 133/255>;
#declare CN_Blackberry_Pie = rgb <100/255, 36/255, 46/255>;
#declare CN_Blackberry_Sorbet = rgb <193/255, 163/255, 185/255>;
#declare CN_Blackberry_Tint = rgb <143/255, 89/255, 115/255>;
#declare CN_Blackberry_Wine = rgb <77/255, 50/255, 70/255>;
#declare CN_Blackberry_Yogurt = rgb <229/255, 189/255, 223/255>;
#declare CN_Blackbird = rgb <63/255, 68/255, 76/255>;
#declare CN_Blackbirds_Ggg = rgb <252/255, 231/255, 228/255>;
#declare CN_Blackboard_Green = rgb <39/255, 76/255, 67/255>;
#declare CN_Blackcurrant = rgb <46/255, 24/255, 59/255>;
#declare CN_Blackcurrant_Conserve = rgb <82/255, 56/255, 61/255>;
#declare CN_Blackcurrant_Elixir = rgb <92/255, 79/255, 106/255>;
#declare CN_Blackened_Brown = rgb <68/255, 34/255, 0/255>;
#declare CN_Blackened_Pearl = rgb <77/255, 75/255, 80/255>;
#declare CN_Blackest_Berry = rgb <102/255, 34/255, 102/255>;
#declare CN_Blackest_Brown = rgb <64/255, 51/255, 48/255>;
#declare CN_Blackfire_Earth = rgb <122/255, 89/255, 1/255>;
#declare CN_Blackheath = rgb <73/255, 69/255, 75/255>;
#declare CN_Blackish_Brown = rgb <69/255, 59/255, 50/255>;
#declare CN_Blackish_Green = rgb <93/255, 97/255, 97/255>;
#declare CN_Blackish_Grey = rgb <91/255, 92/255, 97/255>;
#declare CN_Blackjack = rgb <81/255, 80/255, 77/255>;
#declare CN_Blacklist = rgb <34/255, 17/255, 51/255>;
#declare CN_Blackmail = rgb <34/255, 0/255, 102/255>;
#declare CN_Blacknt = rgb <2/255, 15/255, 3/255>;
#declare CN_Blackout = rgb <14/255, 7/255, 2/255>;
#declare CN_Blackthorn_Berry = rgb <132/255, 112/255, 255/255>;
#declare CN_Blackthorn_Blue = rgb <76/255, 96/255, 107/255>;
#declare CN_Blackthorn_Green = rgb <115/255, 156/255, 105/255>;
#declare CN_Blackwater = rgb <84/255, 86/255, 99/255>;
#declare CN_Blackwater_Park = rgb <105/255, 98/255, 104/255>;
#declare CN_Blade_Green = rgb <106/255, 146/255, 102/255>;
#declare CN_Bladed_Grass = rgb <117/255, 130/255, 105/255>;
#declare CN_Bladerunner = rgb <106/255, 133/255, 97/255>;
#declare CN_Blair = rgb <161/255, 189/255, 224/255>;
#declare CN_Blanc = rgb <217/255, 208/255, 194/255>;
#declare CN_Blanc_Casse = rgb <241/255, 238/255, 226/255>;
#declare CN_Blanc_De_Blanc = rgb <231/255, 233/255, 231/255>;
#declare CN_Blanca_Peak = rgb <248/255, 249/255, 244/255>;
#declare CN_Blanched_Almond = rgb <255/255, 235/255, 205/255>;
#declare CN_Blanched_Driftwood = rgb <204/255, 190/255, 182/255>;
#declare CN_Bland = rgb <175/255, 168/255, 139/255>;
#declare CN_Blank_Canvas = rgb <255/255, 239/255, 214/255>;
#declare CN_Blanka_Green = rgb <156/255, 211/255, 60/255>;
#declare CN_Blanket_Brown = rgb <158/255, 133/255, 116/255>;
#declare CN_Blarney = rgb <0/255, 167/255, 118/255>;
#declare CN_Blarney_Stone = rgb <2/255, 121/255, 68/255>;
#declare CN_Blast_Off_Bronze = rgb <165/255, 113/255, 100/255>;
#declare CN_Blasted_Lands_Rocks = rgb <108/255, 53/255, 80/255>;
#declare CN_Blaze = rgb <250/255, 140/255, 79/255>;
#declare CN_Blaze_Orange = rgb <254/255, 103/255, 0/255>;
#declare CN_Blazing_Autumn = rgb <243/255, 173/255, 99/255>;
#declare CN_Blazing_Bonfire = rgb <255/255, 160/255, 53/255>;
#declare CN_Blazing_Dragonfruit = rgb <255/255, 0/255, 84/255>;
#declare CN_Blazing_Orange = rgb <255/255, 166/255, 79/255>;
#declare CN_Blazing_Yellow = rgb <254/255, 231/255, 21/255>;
#declare CN_Bleach_White = rgb <235/255, 225/255, 206/255>;
#declare CN_Bleached_Almond = rgb <243/255, 234/255, 213/255>;
#declare CN_Bleached_Apricot = rgb <252/255, 202/255, 172/255>;
#declare CN_Bleached_Aqua = rgb <188/255, 227/255, 223/255>;
#declare CN_Bleached_Bare = rgb <208/255, 199/255, 195/255>;
#declare CN_Bleached_Bark = rgb <139/255, 127/255, 120/255>;
#declare CN_Bleached_Bone = rgb <239/255, 217/255, 168/255>;
#declare CN_Bleached_Cedar = rgb <44/255, 33/255, 51/255>;
#declare CN_Bleached_Coral = rgb <255/255, 214/255, 209/255>;
#declare CN_Bleached_Denim = rgb <100/255, 111/255, 155/255>;
#declare CN_Bleached_Grey = rgb <120/255, 136/255, 120/255>;
#declare CN_Bleached_Jade = rgb <226/255, 230/255, 209/255>;
#declare CN_Bleached_Linen = rgb <243/255, 236/255, 225/255>;
#declare CN_Bleached_Maple = rgb <199/255, 160/255, 108/255>;
#declare CN_Bleached_Meadow = rgb <234/255, 229/255, 213/255>;
#declare CN_Bleached_Sand = rgb <218/255, 204/255, 180/255>;
#declare CN_Bleached_Shell = rgb <246/255, 229/255, 218/255>;
#declare CN_Bleached_Silk = rgb <243/255, 243/255, 242/255>;
#declare CN_Bleached_Spruce = rgb <186/255, 215/255, 174/255>;
#declare CN_Bleached_Wheat = rgb <221/255, 210/255, 169/255>;
#declare CN_Bleached_White = rgb <223/255, 227/255, 232/255>;
#declare CN_Bleaches = rgb <199/255, 199/255, 195/255>;
#declare CN_Bleeding_Heart = rgb <192/255, 46/255, 76/255>;
#declare CN_Blende_Blue = rgb <169/255, 196/255, 196/255>;
#declare CN_Blended_Fruit = rgb <248/255, 227/255, 164/255>;
#declare CN_Blended_Light = rgb <255/255, 251/255, 232/255>;
#declare CN_Blessed_Blue = rgb <68/255, 153/255, 204/255>;
#declare CN_Bleu_Ciel = rgb <0/255, 123/255, 161/255>;
#declare CN_Bleu_De_France = rgb <49/255, 140/255, 231/255>;
#declare CN_Bleu_Nattier = rgb <156/255, 194/255, 191/255>;
#declare CN_Bleuchatel_Blue = rgb <68/255, 136/255, 255/255>;
#declare CN_Blind_Date = rgb <188/255, 174/255, 161/255>;
#declare CN_Blind_Forest = rgb <34/255, 51/255, 0/255>;
#declare CN_Bling_Bling = rgb <238/255, 240/255, 206/255>;
#declare CN_Blinking_Blue = rgb <0/255, 51/255, 255/255>;
#declare CN_Blinking_Terminal = rgb <102/255, 204/255, 0/255>;
#declare CN_Bliss_Blue = rgb <122/255, 199/255, 225/255>;
#declare CN_Blissful = rgb <221/255, 196/255, 212/255>;
#declare CN_Blissful_Berry = rgb <170/255, 17/255, 136/255>;
#declare CN_Blissful_Blue = rgb <178/255, 200/255, 216/255>;
#declare CN_Blissful_Light = rgb <229/255, 210/255, 221/255>;
#declare CN_Blissful_Meditation = rgb <213/255, 218/255, 238/255>;
#declare CN_Blissful_Orange = rgb <255/255, 172/255, 57/255>;
#declare CN_Blissful_Serenity = rgb <234/255, 238/255, 216/255>;
#declare CN_Blissfully_Mine = rgb <218/255, 182/255, 205/255>;
#declare CN_Blister_Pearl = rgb <170/255, 255/255, 238/255>;
#declare CN_Blithe = rgb <0/255, 132/255, 189/255>;
#declare CN_Blithe_Blue = rgb <144/255, 189/255, 189/255>;
#declare CN_Blizzard = rgb <229/255, 235/255, 237/255>;
#declare CN_Blizzard_Blue = rgb <163/255, 227/255, 237/255>;
#declare CN_Blobfish = rgb <255/255, 193/255, 204/255>;
#declare CN_Blockchain_Gold = rgb <232/255, 188/255, 80/255>;
#declare CN_Bloedworst = rgb <86/255, 3/255, 25/255>;
#declare CN_Blond = rgb <250/255, 240/255, 190/255>;
#declare CN_Blonde = rgb <220/255, 189/255, 146/255>;
#declare CN_Blonde_Beauty = rgb <242/255, 239/255, 205/255>;
#declare CN_Blonde_Curl = rgb <239/255, 226/255, 197/255>;
#declare CN_Blonde_Girl = rgb <237/255, 197/255, 88/255>;
#declare CN_Blonde_Lace = rgb <214/255, 177/255, 148/255>;
#declare CN_Blonde_Shell = rgb <246/255, 237/255, 205/255>;
#declare CN_Blonde_Wood = rgb <171/255, 119/255, 65/255>;
#declare CN_Blonde_Wool = rgb <229/255, 208/255, 177/255>;
#declare CN_Blood = rgb <119/255, 0/255, 1/255>;
#declare CN_Blood_Brother = rgb <119/255, 0/255, 17/255>;
#declare CN_Blood_Burst = rgb <255/255, 71/255, 76/255>;
#declare CN_Blood_Donor = rgb <234/255, 24/255, 34/255>;
#declare CN_Blood_God = rgb <103/255, 8/255, 11/255>;
#declare CN_Blood_Mahogany = rgb <84/255, 56/255, 57/255>;
#declare CN_Blood_Moon = rgb <216/255, 52/255, 50/255>;
#declare CN_Blood_Omen = rgb <138/255, 3/255, 3/255>;
#declare CN_Blood_Orange = rgb <209/255, 0/255, 28/255>;
#declare CN_Blood_Orange_Juice = rgb <254/255, 75/255, 3/255>;
#declare CN_Blood_Organ = rgb <99/255, 15/255, 15/255>;
#declare CN_Blood_Pact = rgb <119/255, 17/255, 17/255>;
#declare CN_Blood_Red = rgb <152/255, 0/255, 2/255>;
#declare CN_Blood_Rose = rgb <115/255, 64/255, 77/255>;
#declare CN_Blood_Rush = rgb <170/255, 34/255, 34/255>;
#declare CN_Blood_Thorn = rgb <176/255, 48/255, 96/255>;
#declare CN_Bloodhound = rgb <187/255, 85/255, 17/255>;
#declare CN_Bloodletter = rgb <233/255, 116/255, 81/255>;
#declare CN_Bloodline = rgb <136/255, 34/255, 0/255>;
#declare CN_Bloodmyst_Isle = rgb <240/255, 39/255, 35/255>;
#declare CN_Bloodstain = rgb <119/255, 34/255, 0/255>;
#declare CN_Bloodstone = rgb <65/255, 52/255, 49/255>;
#declare CN_Bloodthirsty = rgb <136/255, 0/255, 17/255>;
#declare CN_Bloodthirsty_Beige = rgb <248/255, 215/255, 208/255>;
#declare CN_Bloodthirsty_Vampire = rgb <155/255, 5/255, 3/255>;
#declare CN_Bloodthirsty_Warlock = rgb <236/255, 24/255, 55/255>;
#declare CN_Bloodtracker_Brown = rgb <112/255, 63/255, 0/255>;
#declare CN_Bloody_Periphylla = rgb <170/255, 17/255, 68/255>;
#declare CN_Bloody_Pico_8 = rgb <255/255, 0/255, 77/255>;
#declare CN_Bloody_Red = rgb <202/255, 31/255, 27/255>;
#declare CN_Bloody_Rust = rgb <218/255, 44/255, 67/255>;
#declare CN_Bloody_Salmon = rgb <204/255, 68/255, 51/255>;
#declare CN_Bloom = rgb <255/255, 175/255, 117/255>;
#declare CN_Blooming_Aster = rgb <215/255, 226/255, 238/255>;
#declare CN_Blooming_Dahlia = rgb <235/255, 150/255, 135/255>;
#declare CN_Blooming_Lilac = rgb <186/255, 147/255, 175/255>;
#declare CN_Blooming_Perfect = rgb <216/255, 150/255, 150/255>;
#declare CN_Blooming_Wisteria = rgb <136/255, 119/255, 126/255>;
#declare CN_Bloomsberry = rgb <165/255, 152/255, 196/255>;
#declare CN_Blossom = rgb <254/255, 233/255, 216/255>;
#declare CN_Blossom_Blue = rgb <170/255, 204/255, 238/255>;
#declare CN_Blossom_Mauve = rgb <163/255, 167/255, 204/255>;
#declare CN_Blossom_Pink = rgb <230/255, 213/255, 206/255>;
#declare CN_Blossom_Powder = rgb <195/255, 179/255, 185/255>;
#declare CN_Blossom_Time = rgb <229/255, 210/255, 201/255>;
#declare CN_Blossom_White = rgb <242/255, 238/255, 228/255>;
#declare CN_Blossom_Yellow = rgb <225/255, 199/255, 125/255>;
#declare CN_Blossoms_in_Spring = rgb <231/255, 154/255, 203/255>;
#declare CN_Blouson_Blue = rgb <103/255, 183/255, 198/255>;
#declare CN_Blowing_Kisses = rgb <246/255, 222/255, 224/255>;
#declare CN_Blowout = rgb <101/255, 132/255, 153/255>;
#declare CN_Blue = rgb <0/255, 0/255, 255/255>;
#declare CN_Blue_Accolade = rgb <37/255, 65/255, 93/255>;
#declare CN_Blue_Agave = rgb <177/255, 198/255, 199/255>;
#declare CN_Blue_Alps = rgb <137/255, 163/255, 174/255>;
#declare CN_Blue_Android_Base = rgb <90/255, 121/255, 186/255>;
#declare CN_Blue_Angel = rgb <0/255, 34/255, 221/255>;
#declare CN_Blue_Angels_Yellow = rgb <248/255, 184/255, 0/255>;
#declare CN_Blue_Angora = rgb <167/255, 207/255, 203/255>;
#declare CN_Blue_Antarctic = rgb <75/255, 120/255, 155/255>;
#declare CN_Blue_Anthracite = rgb <85/255, 94/255, 100/255>;
#declare CN_Blue_Arc = rgb <0/255, 133/255, 161/255>;
#declare CN_Blue_Ash = rgb <65/255, 70/255, 84/255>;
#declare CN_Blue_Ashes = rgb <59/255, 95/255, 120/255>;
#declare CN_Blue_Aster = rgb <0/255, 119/255, 179/255>;
#declare CN_Blue_Astro = rgb <80/255, 167/255, 217/255>;
#declare CN_Blue_Atoll = rgb <0/255, 177/255, 210/255>;
#declare CN_Blue_Aura = rgb <108/255, 115/255, 134/255>;
#declare CN_Blue_Azure = rgb <70/255, 130/255, 191/255>;
#declare CN_Blue_Ballad = rgb <116/255, 152/255, 189/255>;
#declare CN_Blue_Ballerina = rgb <180/255, 199/255, 219/255>;
#declare CN_Blue_Ballet = rgb <87/255, 107/255, 107/255>;
#declare CN_Blue_Bauble = rgb <171/255, 222/255, 227/255>;
#declare CN_Blue_Bay = rgb <97/255, 154/255, 214/255>;
#declare CN_Blue_Bayberry = rgb <45/255, 83/255, 96/255>;
#declare CN_Blue_Bayou = rgb <190/255, 196/255, 211/255>;
#declare CN_Blue_Beads = rgb <90/255, 128/255, 158/255>;
#declare CN_Blue_Beauty = rgb <116/255, 152/255, 191/255>;
#declare CN_Blue_Beetle = rgb <34/255, 0/255, 153/255>;
#declare CN_Blue_Bell = rgb <147/255, 180/255, 215/255>;
#declare CN_Blue_Beret = rgb <64/255, 99/255, 142/255>;
#declare CN_Blue_Beyond = rgb <145/255, 184/255, 217/255>;
#declare CN_Blue_Bikini = rgb <0/255, 187/255, 238/255>;
#declare CN_Blue_Bird_Day = rgb <35/255, 127/255, 172/255>;
#declare CN_Blue_Black_Crayfish = rgb <82/255, 89/255, 59/255>;
#declare CN_Blue_Blood = rgb <107/255, 127/255, 129/255>;
#declare CN_Blue_Blouse = rgb <148/255, 164/255, 185/255>;
#declare CN_Blue_Blue = rgb <34/255, 66/255, 199/255>;
#declare CN_Blue_Blush = rgb <214/255, 219/255, 217/255>;
#declare CN_Blue_Boater = rgb <97/255, 129/255, 163/255>;
#declare CN_Blue_Bobbin = rgb <82/255, 180/255, 202/255>;
#declare CN_Blue_Bolt = rgb <0/255, 185/255, 251/255>;
#declare CN_Blue_Bonnet = rgb <51/255, 85/255, 153/255>;
#declare CN_Blue_Booties = rgb <200/255, 221/255, 238/255>;
#declare CN_Blue_Bottle = rgb <57/255, 78/255, 101/255>;
#declare CN_Blue_Bouquet = rgb <0/255, 51/255, 238/255>;
#declare CN_Blue_Bows = rgb <164/255, 195/255, 215/255>;
#declare CN_Blue_Brocade = rgb <112/255, 184/255, 208/255>;
#declare CN_Blue_Bubble = rgb <166/255, 215/255, 235/255>;
#declare CN_Blue_Buzz = rgb <161/255, 162/255, 189/255>;
#declare CN_Blue_By_You = rgb <160/255, 183/255, 186/255>;
#declare CN_Blue_Calico = rgb <165/255, 205/255, 225/255>;
#declare CN_Blue_Calypso = rgb <85/255, 167/255, 182/255>;
#declare CN_Blue_Carpenter_Bee = rgb <156/255, 208/255, 228/255>;
#declare CN_Blue_Cascade = rgb <123/255, 158/255, 176/255>;
#declare CN_Blue_Catch = rgb <65/255, 120/255, 138/255>;
#declare CN_Blue_Chaise = rgb <75/255, 140/255, 169/255>;
#declare CN_Blue_Chalk = rgb <148/255, 192/255, 204/255>;
#declare CN_Blue_Charcoal = rgb <38/255, 43/255, 47/255>;
#declare CN_Blue_Charm = rgb <130/255, 194/255, 219/255>;
#declare CN_Blue_Chill = rgb <64/255, 143/255, 144/255>;
#declare CN_Blue_Chip = rgb <29/255, 86/255, 153/255>;
#declare CN_Blue_Chrysocolla = rgb <119/255, 183/255, 208/255>;
#declare CN_Blue_Clay = rgb <107/255, 145/255, 148/255>;
#declare CN_Blue_Click = rgb <167/255, 216/255, 232/255>;
#declare CN_Blue_Cloud = rgb <98/255, 113/255, 136/255>;
#declare CN_Blue_Cola = rgb <0/255, 136/255, 220/255>;
#declare CN_Blue_Collar_Man = rgb <0/255, 95/255, 122/255>;
#declare CN_Blue_Copper_Ore = rgb <68/255, 17/255, 221/255>;
#declare CN_Blue_Coral = rgb <27/255, 83/255, 102/255>;
#declare CN_Blue_Crab_Escape = rgb <158/255, 189/255, 214/255>;
#declare CN_Blue_Cruise = rgb <101/255, 145/255, 168/255>;
#declare CN_Blue_Cuddle = rgb <126/255, 180/255, 209/255>;
#declare CN_Blue_Cue = rgb <132/255, 165/255, 220/255>;
#declare CN_Blue_Curacao = rgb <50/255, 190/255, 204/255>;
#declare CN_Blue_Cypress = rgb <203/255, 219/255, 215/255>;
#declare CN_Blue_Dacnis = rgb <68/255, 221/255, 238/255>;
#declare CN_Blue_Dahlia = rgb <65/255, 94/255, 156/255>;
#declare CN_Blue_Dam = rgb <162/255, 198/255, 211/255>;
#declare CN_Blue_Danube = rgb <0/255, 135/255, 182/255>;
#declare CN_Blue_Darknut = rgb <0/255, 120/255, 248/255>;
#declare CN_Blue_Dart = rgb <81/255, 143/255, 209/255>;
#declare CN_Blue_Dart_Frog = rgb <58/255, 122/255, 155/255>;
#declare CN_Blue_Depression = rgb <68/255, 40/255, 188/255>;
#declare CN_Blue_Depths = rgb <38/255, 48/255, 86/255>;
#declare CN_Blue_Diamond = rgb <75/255, 45/255, 114/255>;
#declare CN_Blue_Dianne = rgb <53/255, 81/255, 79/255>;
#declare CN_Blue_Dolphin = rgb <188/255, 197/255, 207/255>;
#declare CN_Blue_Dove = rgb <118/255, 121/255, 158/255>;
#declare CN_Blue_Dude = rgb <74/255, 92/255, 148/255>;
#declare CN_Blue_Dusk = rgb <140/255, 149/255, 157/255>;
#declare CN_Blue_Earth = rgb <55/255, 86/255, 115/255>;
#declare CN_Blue_Echo = rgb <141/255, 187/255, 201/255>;
#declare CN_Blue_Edge = rgb <3/255, 94/255, 123/255>;
#declare CN_Blue_Effervescence = rgb <151/255, 213/255, 234/255>;
#declare CN_Blue_Elemental = rgb <85/255, 136/255, 238/255>;
#declare CN_Blue_Emerald = rgb <15/255, 90/255, 94/255>;
#declare CN_Blue_Emulsion = rgb <209/255, 237/255, 239/255>;
#declare CN_Blue_Estate = rgb <56/255, 72/255, 131/255>;
#declare CN_Blue_et_une_Nuit = rgb <6/255, 82/255, 255/255>;
#declare CN_Blue_Expanse = rgb <37/255, 63/255, 116/255>;
#declare CN_Blue_Exult = rgb <43/255, 47/255, 67/255>;
#declare CN_Blue_Eyed_Boy = rgb <135/255, 189/255, 227/255>;
#declare CN_Blue_Fantastic = rgb <44/255, 59/255, 77/255>;
#declare CN_Blue_Feather = rgb <174/255, 217/255, 236/255>;
#declare CN_Blue_Fin = rgb <87/255, 127/255, 174/255>;
#declare CN_Blue_Fir = rgb <81/255, 100/255, 95/255>;
#declare CN_Blue_Fire = rgb <0/255, 170/255, 221/255>;
#declare CN_Blue_Fjord = rgb <98/255, 141/255, 170/255>;
#declare CN_Blue_Flag = rgb <59/255, 80/255, 111/255>;
#declare CN_Blue_Flame = rgb <0/255, 94/255, 136/255>;
#declare CN_Blue_Flower = rgb <208/255, 217/255, 212/255>;
#declare CN_Blue_Fog = rgb <155/255, 171/255, 187/255>;
#declare CN_Blue_Fox = rgb <185/255, 188/255, 182/255>;
#declare CN_Blue_Frosting = rgb <134/255, 210/255, 193/255>;
#declare CN_Blue_Garter = rgb <162/255, 184/255, 206/255>;
#declare CN_Blue_Gem = rgb <75/255, 60/255, 142/255>;
#declare CN_Blue_Genie = rgb <102/255, 102/255, 255/255>;
#declare CN_Blue_Glass = rgb <198/255, 227/255, 225/255>;
#declare CN_Blue_Glaze = rgb <86/255, 89/255, 124/255>;
#declare CN_Blue_Glint = rgb <146/255, 198/255, 215/255>;
#declare CN_Blue_Glow = rgb <178/255, 212/255, 221/255>;
#declare CN_Blue_Gossamer = rgb <205/255, 215/255, 223/255>;
#declare CN_Blue_Granite = rgb <113/255, 115/255, 136/255>;
#declare CN_Blue_Graphite = rgb <50/255, 49/255, 55/255>;
#declare CN_Blue_Grass = rgb <0/255, 124/255, 122/255>;
#declare CN_Blue_Green = rgb <19/255, 126/255, 109/255>;
#declare CN_Blue_Green_Gem = rgb <124/255, 203/255, 197/255>;
#declare CN_Blue_Green_Rules = rgb <216/255, 238/255, 237/255>;
#declare CN_Blue_Green_Scene = rgb <86/255, 183/255, 143/255>;
#declare CN_Blue_Grey = rgb <117/255, 141/255, 163/255>;
#declare CN_Blue_Grotto = rgb <92/255, 172/255, 206/255>;
#declare CN_Blue_Grouse = rgb <154/255, 188/255, 220/255>;
#declare CN_Blue_Haze = rgb <189/255, 186/255, 206/255>;
#declare CN_Blue_Heath_Butterfly = rgb <85/255, 102/255, 255/255>;
#declare CN_Blue_Heather = rgb <174/255, 187/255, 193/255>;
#declare CN_Blue_Heaven = rgb <91/255, 126/255, 152/255>;
#declare CN_Blue_Heeler = rgb <147/255, 156/255, 171/255>;
#declare CN_Blue_Heist = rgb <0/255, 99/255, 132/255>;
#declare CN_Blue_Hepatica = rgb <102/255, 102/255, 238/255>;
#declare CN_Blue_Heron = rgb <150/255, 163/255, 199/255>;
#declare CN_Blue_Highlight = rgb <50/255, 74/255, 139/255>;
#declare CN_Blue_Hijab = rgb <208/255, 238/255, 251/255>;
#declare CN_Blue_Hill = rgb <30/255, 69/255, 77/255>;
#declare CN_Blue_Horizon = rgb <78/255, 100/255, 130/255>;
#declare CN_Blue_Horror = rgb <162/255, 186/255, 210/255>;
#declare CN_Blue_Hour = rgb <0/255, 52/255, 171/255>;
#declare CN_Blue_Hue = rgb <57/255, 77/255, 96/255>;
#declare CN_Blue_Hyacinth = rgb <131/255, 148/255, 197/255>;
#declare CN_Blue_Hydrangea = rgb <187/255, 195/255, 221/255>;
#declare CN_Blue_Ice = rgb <112/255, 120/255, 155/255>;
#declare CN_Blue_Iguana = rgb <83/255, 156/255, 204/255>;
#declare CN_Blue_Indigo = rgb <73/255, 81/255, 109/255>;
#declare CN_Blue_Insignia = rgb <86/255, 105/255, 119/255>;
#declare CN_Blue_Intrigue = rgb <127/255, 128/255, 156/255>;
#declare CN_Blue_Iolite = rgb <88/255, 126/255, 190/255>;
#declare CN_Blue_Iris = rgb <90/255, 91/255, 159/255>;
#declare CN_Blue_Island = rgb <34/255, 170/255, 170/255>;
#declare CN_Blue_Jacket = rgb <89/255, 113/255, 147/255>;
#declare CN_Blue_Jasmine = rgb <130/255, 133/255, 150/255>;
#declare CN_Blue_Jay = rgb <85/255, 136/255, 221/255>;
#declare CN_Blue_Jeans = rgb <93/255, 173/255, 236/255>;
#declare CN_Blue_Jewel = rgb <70/255, 83/255, 131/255>;
#declare CN_Blue_Karma = rgb <188/255, 230/255, 232/255>;
#declare CN_Blue_Kelp = rgb <29/255, 120/255, 129/255>;
#declare CN_Blue_Lagoon = rgb <0/255, 98/255, 111/255>;
#declare CN_Blue_Lava = rgb <46/255, 81/255, 105/255>;
#declare CN_Blue_League = rgb <0/255, 98/255, 132/255>;
#declare CN_Blue_Lechery = rgb <119/255, 158/255, 203/255>;
#declare CN_Blue_Light = rgb <172/255, 223/255, 221/255>;
#declare CN_Blue_Limewash = rgb <127/255, 204/255, 226/255>;
#declare CN_Blue_Linen = rgb <90/255, 94/255, 106/255>;
#declare CN_Blue_Lips = rgb <166/255, 188/255, 226/255>;
#declare CN_Blue_Lobelia = rgb <40/255, 49/255, 77/255>;
#declare CN_Blue_Lobster = rgb <0/255, 85/255, 170/255>;
#declare CN_Blue_Lullaby = rgb <200/255, 215/255, 210/255>;
#declare CN_Blue_Lust = rgb <1/255, 35/255, 137/255>;
#declare CN_Blue_Luxury = rgb <0/255, 117/255, 147/255>;
#declare CN_Blue_Magenta = rgb <95/255, 52/255, 231/255>;
#declare CN_Blue_Magenta_Violet = rgb <85/255, 53/255, 146/255>;
#declare CN_Blue_Mana = rgb <104/255, 194/255, 245/255>;
#declare CN_Blue_Marble = rgb <101/255, 148/255, 188/255>;
#declare CN_Blue_Marguerite = rgb <106/255, 91/255, 177/255>;
#declare CN_Blue_Martina = rgb <31/255, 206/255, 203/255>;
#declare CN_Blue_Martini = rgb <82/255, 180/255, 211/255>;
#declare CN_Blue_Me_Away = rgb <201/255, 220/255, 231/255>;
#declare CN_Blue_Mediterranean = rgb <30/255, 126/255, 154/255>;
#declare CN_Blue_Mercury = rgb <103/255, 166/255, 172/255>;
#declare CN_Blue_Metal = rgb <90/255, 99/255, 112/255>;
#declare CN_Blue_Mirage = rgb <92/255, 109/255, 124/255>;
#declare CN_Blue_Mist = rgb <91/255, 172/255, 195/255>;
#declare CN_Blue_Monday = rgb <99/255, 121/255, 131/255>;
#declare CN_Blue_Mood = rgb <122/255, 128/255, 141/255>;
#declare CN_Blue_Moon = rgb <54/255, 134/255, 160/255>;
#declare CN_Blue_Moon_Bay = rgb <88/255, 132/255, 150/255>;
#declare CN_Blue_Mosque = rgb <33/255, 66/255, 107/255>;
#declare CN_Blue_Mountain = rgb <117/255, 157/255, 190/255>;
#declare CN_Blue_Nebula = rgb <17/255, 153/255, 255/255>;
#declare CN_Blue_Nights = rgb <54/255, 59/255, 72/255>;
#declare CN_Blue_Nile = rgb <119/255, 159/255, 185/255>;
#declare CN_Blue_Nuance = rgb <210/255, 221/255, 224/255>;
#declare CN_Blue_Nude = rgb <41/255, 81/255, 140/255>;
#declare CN_Blue_Oar = rgb <100/255, 126/255, 156/255>;
#declare CN_Blue_Oasis = rgb <41/255, 109/255, 147/255>;
#declare CN_Blue_Oblivion = rgb <38/255, 66/255, 139/255>;
#declare CN_Blue_Ocean = rgb <0/255, 114/255, 158/255>;
#declare CN_Blue_Odyssey = rgb <79/255, 105/255, 151/255>;
#declare CN_Blue_Opal = rgb <15/255, 59/255, 87/255>;
#declare CN_Blue_Overdose = rgb <0/255, 0/255, 238/255>;
#declare CN_Blue_Oyster_Cult = rgb <85/255, 119/255, 238/255>;
#declare CN_Blue_Paisley = rgb <34/255, 130/255, 168/255>;
#declare CN_Blue_Parlor = rgb <133/255, 171/255, 219/255>;
#declare CN_Blue_Party_Parrot = rgb <128/255, 128/255, 255/255>;
#declare CN_Blue_Pearl = rgb <197/255, 217/255, 227/255>;
#declare CN_Blue_Pencil = rgb <34/255, 0/255, 255/255>;
#declare CN_Blue_Perennial = rgb <188/255, 215/255, 223/255>;
#declare CN_Blue_Period = rgb <7/255, 81/255, 88/255>;
#declare CN_Blue_Phlox = rgb <210/255, 230/255, 232/255>;
#declare CN_Blue_Pink = rgb <181/255, 163/255, 197/255>;
#declare CN_Blue_Planet = rgb <84/255, 94/255, 106/255>;
#declare CN_Blue_Plate = rgb <91/255, 122/255, 156/255>;
#declare CN_Blue_Plaza = rgb <48/255, 54/255, 60/255>;
#declare CN_Blue_Pointer = rgb <149/255, 185/255, 214/255>;
#declare CN_Blue_Potato = rgb <100/255, 97/255, 123/255>;
#declare CN_Blue_Prince = rgb <106/255, 128/255, 143/255>;
#declare CN_Blue_Promise = rgb <114/255, 156/255, 194/255>;
#declare CN_Blue_Purple = rgb <87/255, 41/255, 206/255>;
#declare CN_Blue_Quarry = rgb <67/255, 80/255, 94/255>;
#declare CN_Blue_Racer = rgb <75/255, 164/255, 169/255>;
#declare CN_Blue_Radiance = rgb <88/255, 201/255, 212/255>;
#declare CN_Blue_Ranger = rgb <0/255, 23/255, 125/255>;
#declare CN_Blue_Raspberry = rgb <12/255, 191/255, 233/255>;
#declare CN_Blue_Reflection = rgb <204/255, 215/255, 225/255>;
#declare CN_Blue_Refrain = rgb <176/255, 216/255, 231/255>;
#declare CN_Blue_Regal = rgb <48/255, 48/255, 72/255>;
#declare CN_Blue_Regatta = rgb <55/255, 98/255, 152/255>;
#declare CN_Blue_Regent = rgb <40/255, 89/255, 145/255>;
#declare CN_Blue_Review = rgb <78/255, 88/255, 120/255>;
#declare CN_Blue_Rhapsody = rgb <61/255, 70/255, 85/255>;
#declare CN_Blue_Ribbon = rgb <0/255, 102/255, 255/255>;
#declare CN_Blue_Ribbon_Beauty = rgb <62/255, 100/255, 144/255>;
#declare CN_Blue_Rice = rgb <179/255, 217/255, 243/255>;
#declare CN_Blue_Rinse = rgb <183/255, 189/255, 198/255>;
#declare CN_Blue_Romance = rgb <216/255, 240/255, 210/255>;
#declare CN_Blue_Rose = rgb <41/255, 45/255, 116/255>;
#declare CN_Blue_Royale = rgb <41/255, 33/255, 122/255>;
#declare CN_Blue_Ruin = rgb <0/255, 102/255, 221/255>;
#declare CN_Blue_Sabre = rgb <87/255, 95/255, 106/255>;
#declare CN_Blue_Sage = rgb <87/255, 116/255, 122/255>;
#declare CN_Blue_Sail = rgb <36/255, 84/255, 154/255>;
#declare CN_Blue_Sapphire = rgb <18/255, 97/255, 128/255>;
#declare CN_Blue_Sari = rgb <102/255, 106/255, 118/255>;
#declare CN_Blue_Sarong = rgb <154/255, 214/255, 232/255>;
#declare CN_Blue_Sash = rgb <73/255, 77/255, 88/255>;
#declare CN_Blue_Satin = rgb <158/255, 182/255, 208/255>;
#declare CN_Blue_Screen_of_Death = rgb <0/255, 51/255, 187/255>;
#declare CN_Blue_Shade_Wash = rgb <41/255, 63/255, 84/255>;
#declare CN_Blue_Shadow = rgb <102/255, 130/255, 154/255>;
#declare CN_Blue_Shamrock = rgb <186/255, 203/255, 196/255>;
#declare CN_Blue_Shell = rgb <155/255, 179/255, 188/255>;
#declare CN_Blue_Shimmer = rgb <179/255, 218/255, 226/255>;
#declare CN_Blue_Shutters = rgb <147/255, 189/255, 231/255>;
#declare CN_Blue_Silk = rgb <208/255, 220/255, 232/255>;
#declare CN_Blue_Skies_Today = rgb <149/255, 175/255, 220/255>;
#declare CN_Blue_Slate = rgb <90/255, 95/255, 104/255>;
#declare CN_Blue_Slushie = rgb <0/255, 135/255, 147/255>;
#declare CN_Blue_Smart = rgb <87/255, 134/255, 180/255>;
#declare CN_Blue_Smoke = rgb <215/255, 224/255, 226/255>;
#declare CN_Blue_Sonki = rgb <74/255, 135/255, 203/255>;
#declare CN_Blue_Souwester = rgb <64/255, 73/255, 86/255>;
#declare CN_Blue_Sparkle = rgb <0/255, 119/255, 255/255>;
#declare CN_Blue_Spell = rgb <59/255, 92/255, 108/255>;
#declare CN_Blue_Spruce = rgb <173/255, 197/255, 201/255>;
#declare CN_Blue_Square = rgb <80/255, 138/255, 154/255>;
#declare CN_Blue_Steel = rgb <83/255, 90/255, 97/255>;
#declare CN_Blue_Stone = rgb <87/255, 114/255, 132/255>;
#declare CN_Blue_Streak = rgb <34/255, 102/255, 187/255>;
#declare CN_Blue_Stream = rgb <149/255, 205/255, 216/255>;
#declare CN_Blue_Suede = rgb <104/255, 123/255, 146/255>;
#declare CN_Blue_Suede_Shoes = rgb <72/255, 75/255, 98/255>;
#declare CN_Blue_Surf = rgb <144/255, 168/255, 164/255>;
#declare CN_Blue_Syzygy = rgb <27/255, 69/255, 86/255>;
#declare CN_Blue_Tang = rgb <42/255, 75/255, 110/255>;
#declare CN_Blue_Tapestry = rgb <71/255, 92/255, 98/255>;
#declare CN_Blue_Thistle = rgb <173/255, 192/255, 214/255>;
#declare CN_Blue_Tint = rgb <159/255, 217/255, 215/255>;
#declare CN_Blue_Titmouse = rgb <68/255, 102/255, 255/255>;
#declare CN_Blue_To_You = rgb <186/255, 191/255, 197/255>;
#declare CN_Blue_Tone_Ink = rgb <43/255, 64/255, 87/255>;
#declare CN_Blue_Topaz = rgb <120/255, 189/255, 212/255>;
#declare CN_Blue_Torus = rgb <4/255, 41/255, 147/255>;
#declare CN_Blue_Tourmaline = rgb <73/255, 151/255, 208/255>;
#declare CN_Blue_Tribute = rgb <169/255, 184/255, 200/255>;
#declare CN_Blue_Trust = rgb <18/255, 10/255, 143/255>;
#declare CN_Blue_Tulip = rgb <92/255, 70/255, 113/255>;
#declare CN_Blue_Tuna = rgb <111/255, 149/255, 193/255>;
#declare CN_Blue_Turquoise = rgb <83/255, 176/255, 174/255>;
#declare CN_Blue_Vacation = rgb <30/255, 126/255, 174/255>;
#declare CN_Blue_Vault = rgb <78/255, 131/255, 189/255>;
#declare CN_Blue_Veil = rgb <174/255, 203/255, 229/255>;
#declare CN_Blue_Velvet = rgb <13/255, 97/255, 131/255>;
#declare CN_Blue_Venus = rgb <57/255, 124/255, 128/255>;
#declare CN_Blue_Violet = rgb <50/255, 74/255, 178/255>;
#declare CN_Blue_Vortex = rgb <61/255, 68/255, 87/255>;
#declare CN_Blue_Whale = rgb <30/255, 52/255, 66/255>;
#declare CN_Blue_Willow = rgb <168/255, 187/255, 186/255>;
#declare CN_Blue_Wing_Teal = rgb <44/255, 64/255, 83/255>;
#declare CN_Blue_Winged_Teal = rgb <0/255, 130/255, 124/255>;
#declare CN_Blue_With_A_Hint_Of_Purple = rgb <83/255, 60/255, 198/255>;
#declare CN_Blue_Yonder = rgb <90/255, 119/255, 168/255>;
#declare CN_Blue_Zephyr = rgb <91/255, 102/255, 118/255>;
#declare CN_Blue_Zodiac = rgb <60/255, 67/255, 84/255>;
#declare CN_Blue_Black = rgb <36/255, 49/255, 61/255>;
#declare CN_Blue_Eyed_Boy = rgb <34/255, 119/255, 204/255>;
#declare CN_Bluealicious = rgb <0/255, 0/255, 221/255>;
#declare CN_Bluebeard = rgb <171/255, 181/255, 196/255>;
#declare CN_Bluebell = rgb <51/255, 51/255, 153/255>;
#declare CN_Bluebell_Frost = rgb <153/255, 153/255, 204/255>;
#declare CN_Blueberry = rgb <70/255, 65/255, 150/255>;
#declare CN_Blueberry_Blush = rgb <131/255, 98/255, 104/255>;
#declare CN_Blueberry_Buckle = rgb <140/255, 153/255, 179/255>;
#declare CN_Blueberry_Dream = rgb <88/255, 110/255, 132/255>;
#declare CN_Blueberry_Glaze = rgb <204/255, 102/255, 221/255>;
#declare CN_Blueberry_Lemonade = rgb <208/255, 19/255, 67/255>;
#declare CN_Blueberry_Muffin = rgb <85/255, 136/255, 171/255>;
#declare CN_Blueberry_Patch = rgb <98/255, 112/255, 153/255>;
#declare CN_Blueberry_Pie = rgb <49/255, 77/255, 103/255>;
#declare CN_Blueberry_Popover = rgb <84/255, 136/255, 192/255>;
#declare CN_Blueberry_Soda = rgb <130/255, 144/255, 166/255>;
#declare CN_Blueberry_Soft_Blue = rgb <94/255, 150/255, 195/255>;
#declare CN_Blueberry_Tart = rgb <63/255, 64/255, 80/255>;
#declare CN_Blueberry_Twist = rgb <36/255, 84/255, 125/255>;
#declare CN_Blueberry_Whip = rgb <209/255, 212/255, 219/255>;
#declare CN_Bluebird = rgb <0/255, 157/255, 174/255>;
#declare CN_Bluebird_Feather = rgb <111/255, 157/255, 179/255>;
#declare CN_Bluebirds_Belly = rgb <115/255, 149/255, 184/255>;
#declare CN_Blueblood = rgb <1/255, 80/255, 134/255>;
#declare CN_Bluebonnet = rgb <28/255, 28/255, 240/255>;
#declare CN_Bluebonnet_Frost = rgb <77/255, 110/255, 176/255>;
#declare CN_Bluebottle = rgb <142/255, 207/255, 232/255>;
#declare CN_Bluebound = rgb <79/255, 146/255, 151/255>;
#declare CN_Bluejay = rgb <21/255, 126/255, 160/255>;
#declare CN_Blueprint = rgb <53/255, 99/255, 124/255>;
#declare CN_Blues = rgb <41/255, 106/255, 157/255>;
#declare CN_Blues_White_Shoes = rgb <153/255, 186/255, 221/255>;
#declare CN_Bluesy_Note = rgb <124/255, 154/255, 181/255>;
#declare CN_Bluetiful = rgb <60/255, 105/255, 231/255>;
#declare CN_Bluette = rgb <158/255, 190/255, 216/255>;
#declare CN_Bluewash = rgb <226/255, 230/255, 224/255>;
#declare CN_Bluey = rgb <55/255, 89/255, 120/255>;
#declare CN_Bluff_Stone = rgb <210/255, 189/255, 158/255>;
#declare CN_Bluish = rgb <41/255, 118/255, 187/255>;
#declare CN_Bluish_Black = rgb <65/255, 63/255, 68/255>;
#declare CN_Bluish_Green = rgb <16/255, 166/255, 116/255>;
#declare CN_Bluish_Grey = rgb <116/255, 139/255, 151/255>;
#declare CN_Bluish_Lilac_Purple = rgb <208/255, 213/255, 211/255>;
#declare CN_Bluish_Purple = rgb <112/255, 59/255, 231/255>;
#declare CN_Bluish_Purple_Anemone = rgb <102/255, 102/255, 187/255>;
#declare CN_Bluish_Water = rgb <137/255, 207/255, 219/255>;
#declare CN_Blumine = rgb <48/255, 92/255, 113/255>;
#declare CN_Blunt = rgb <181/255, 187/255, 199/255>;
#declare CN_Blunt_Violet = rgb <141/255, 108/255, 122/255>;
#declare CN_Blurple = rgb <85/255, 57/255, 204/255>;
#declare CN_Blush = rgb <242/255, 158/255, 142/255>;
#declare CN_Blush_Beige = rgb <237/255, 213/255, 199/255>;
#declare CN_Blush_Bomb = rgb <221/255, 153/255, 170/255>;
#declare CN_Blush_dAmour = rgb <222/255, 93/255, 131/255>;
#declare CN_Blush_Essence = rgb <204/255, 136/255, 221/255>;
#declare CN_Blush_Mint = rgb <217/255, 230/255, 224/255>;
#declare CN_Blush_Pink = rgb <255/255, 111/255, 255/255>;
#declare CN_Blush_Rush = rgb <240/255, 188/255, 190/255>;
#declare CN_Blush_Sand = rgb <226/255, 224/255, 216/255>;
#declare CN_Blush_Sky = rgb <222/255, 225/255, 237/255>;
#declare CN_Blush_Tint = rgb <244/255, 225/255, 230/255>;
#declare CN_Blushed_Bombshell = rgb <238/255, 136/255, 204/255>;
#declare CN_Blushed_Cotton = rgb <240/255, 224/255, 210/255>;
#declare CN_Blushed_Velvet = rgb <222/255, 197/255, 211/255>;
#declare CN_Blushing = rgb <240/255, 209/255, 195/255>;
#declare CN_Blushing_Apricot = rgb <251/255, 188/255, 167/255>;
#declare CN_Blushing_Bride = rgb <238/255, 218/255, 209/255>;
#declare CN_Blushing_Bud = rgb <221/255, 153/255, 153/255>;
#declare CN_Blushing_Cherub = rgb <255/255, 205/255, 175/255>;
#declare CN_Blushing_Peach = rgb <255/255, 215/255, 159/255>;
#declare CN_Blushing_Senorita = rgb <243/255, 202/255, 203/255>;
#declare CN_Blushing_Tulip = rgb <227/255, 161/255, 184/255>;
#declare CN_Bluster_Blue = rgb <74/255, 90/255, 111/255>;
#declare CN_Blustery_Day = rgb <214/255, 223/255, 231/255>;
#declare CN_Blustery_Sky = rgb <111/255, 132/255, 140/255>;
#declare CN_Blustery_Wind = rgb <182/255, 197/255, 193/255>;
#declare CN_Bnei_Brak_Bay = rgb <29/255, 91/255, 214/255>;
#declare CN_Boa = rgb <142/255, 133/255, 95/255>;
#declare CN_Boardman = rgb <117/255, 119/255, 96/255>;
#declare CN_Boat_Anchor = rgb <108/255, 107/255, 106/255>;
#declare CN_Boat_Blue = rgb <45/255, 83/255, 132/255>;
#declare CN_Boat_House = rgb <78/255, 137/255, 190/255>;
#declare CN_Boat_Orchid = rgb <192/255, 68/255, 143/255>;
#declare CN_Boathouse = rgb <87/255, 113/255, 144/255>;
#declare CN_Boating_Green = rgb <8/255, 113/255, 112/255>;
#declare CN_Boatswain = rgb <36/255, 50/255, 86/255>;
#declare CN_Bobby_Blue = rgb <151/255, 197/255, 218/255>;
#declare CN_Bobcat_Whiskers = rgb <234/255, 223/255, 208/255>;
#declare CN_Boboli_Gardens = rgb <34/255, 187/255, 17/255>;
#declare CN_Bock = rgb <93/255, 52/255, 26/255>;
#declare CN_Bockwurst = rgb <223/255, 143/255, 103/255>;
#declare CN_Bodacious = rgb <183/255, 107/255, 163/255>;
#declare CN_Bodega_Bay = rgb <94/255, 129/255, 193/255>;
#declare CN_Bodhi_Tree = rgb <176/255, 152/255, 112/255>;
#declare CN_Boeing_Blue = rgb <61/255, 70/255, 82/255>;
#declare CN_Boerewors = rgb <151/255, 52/255, 67/255>;
#declare CN_Bog = rgb <186/255, 182/255, 150/255>;
#declare CN_Bogart = rgb <139/255, 130/255, 116/255>;
#declare CN_Bogey_Green = rgb <17/255, 111/255, 38/255>;
#declare CN_Bogong_Moth = rgb <102/255, 59/255, 58/255>;
#declare CN_Bohemian_Black = rgb <59/255, 55/255, 60/255>;
#declare CN_Bohemian_Blue = rgb <0/255, 0/255, 170/255>;
#declare CN_Bohemian_Jazz = rgb <157/255, 119/255, 124/255>;
#declare CN_Bohemianism = rgb <184/255, 179/255, 200/255>;
#declare CN_Boho = rgb <123/255, 104/255, 77/255>;
#declare CN_Boiling_Acid = rgb <0/255, 238/255, 17/255>;
#declare CN_Boiling_Magma = rgb <255/255, 51/255, 0/255>;
#declare CN_Boiling_Mud = rgb <165/255, 156/255, 155/255>;
#declare CN_Boiling_Point = rgb <215/255, 233/255, 232/255>;
#declare CN_Bok_Choy = rgb <188/255, 202/255, 179/255>;
#declare CN_Bokara_Grey = rgb <42/255, 39/255, 37/255>;
#declare CN_Bold_Avocado = rgb <135/255, 149/255, 80/255>;
#declare CN_Bold_Bolection = rgb <29/255, 101/255, 117/255>;
#declare CN_Bold_Brandy = rgb <121/255, 102/255, 96/255>;
#declare CN_Bold_Brick = rgb <140/255, 94/255, 85/255>;
#declare CN_Bold_Eagle = rgb <70/255, 61/255, 47/255>;
#declare CN_Bold_Irish = rgb <42/255, 129/255, 77/255>;
#declare CN_Bold_Sangria = rgb <122/255, 69/255, 73/255>;
#declare CN_Bole = rgb <121/255, 68/255, 59/255>;
#declare CN_Bolero = rgb <136/255, 70/255, 74/255>;
#declare CN_Bollywood = rgb <222/255, 187/255, 50/255>;
#declare CN_Bollywood_Gold = rgb <255/255, 251/255, 171/255>;
#declare CN_Bologna_Sausage = rgb <255/255, 207/255, 220/255>;
#declare CN_Bolognese = rgb <187/255, 68/255, 0/255>;
#declare CN_Bolt_from_the_Blue = rgb <34/255, 119/255, 255/255>;
#declare CN_Boltgun_Metal = rgb <57/255, 57/255, 57/255>;
#declare CN_Bombay = rgb <174/255, 174/255, 173/255>;
#declare CN_Bombay_Brown = rgb <159/255, 81/255, 48/255>;
#declare CN_Bombay_Pink = rgb <201/255, 115/255, 106/255>;
#declare CN_Bon_Nuit = rgb <58/255, 72/255, 102/255>;
#declare CN_Bon_Voyage = rgb <139/255, 174/255, 178/255>;
#declare CN_Bona_Fide = rgb <48/255, 68/255, 113/255>;
#declare CN_Bona_Fide_Beige = rgb <203/255, 185/255, 171/255>;
#declare CN_Bonaire = rgb <230/255, 226/255, 215/255>;
#declare CN_Bonanza = rgb <82/255, 59/255, 44/255>;
#declare CN_Bonbon_Red = rgb <140/255, 66/255, 104/255>;
#declare CN_Bondi = rgb <22/255, 105/255, 140/255>;
#declare CN_Bondi_Blue = rgb <0/255, 149/255, 182/255>;
#declare CN_Bone = rgb <224/255, 215/255, 198/255>;
#declare CN_Bone_Brown = rgb <157/255, 116/255, 70/255>;
#declare CN_Bone_China = rgb <243/255, 237/255, 222/255>;
#declare CN_Bone_Dust = rgb <231/255, 236/255, 230/255>;
#declare CN_Bone_Trace = rgb <215/255, 208/255, 192/255>;
#declare CN_Bone_White = rgb <241/255, 225/255, 176/255>;
#declare CN_Boneyard = rgb <187/255, 153/255, 119/255>;
#declare CN_Bonfire = rgb <247/255, 128/255, 88/255>;
#declare CN_Bonfire_Flame = rgb <206/255, 78/255, 53/255>;
#declare CN_Bonfire_Night = rgb <222/255, 106/255, 65/255>;
#declare CN_Bongo_Drum = rgb <210/255, 194/255, 178/255>;
#declare CN_Bongo_Skin = rgb <222/255, 206/255, 150/255>;
#declare CN_Bonjour = rgb <223/255, 215/255, 210/255>;
#declare CN_Bonnie_Blue = rgb <141/255, 187/255, 209/255>;
#declare CN_Bonnie_Cream = rgb <253/255, 239/255, 210/255>;
#declare CN_Bonnie_Dune_Beach = rgb <228/255, 209/255, 188/255>;
#declare CN_Bonnies_Bench = rgb <124/255, 100/255, 74/255>;
#declare CN_Bonny_Belle = rgb <197/255, 142/255, 171/255>;
#declare CN_Bonsai = rgb <120/255, 123/255, 84/255>;
#declare CN_Bonsai_Garden = rgb <158/255, 158/255, 124/255>;
#declare CN_Bonsai_Pot = rgb <184/255, 177/255, 154/255>;
#declare CN_Bonsai_Tint = rgb <197/255, 209/255, 178/255>;
#declare CN_Bonsai_Trunk = rgb <108/255, 109/255, 98/255>;
#declare CN_Bonus_Level = rgb <255/255, 160/255, 10/255>;
#declare CN_Bonza_Green = rgb <94/255, 107/255, 68/255>;
#declare CN_Booger = rgb <155/255, 181/255, 60/255>;
#declare CN_Booger_Buster = rgb <0/255, 255/255, 119/255>;
#declare CN_Boogie_Blast = rgb <17/255, 153/255, 68/255>;
#declare CN_Book_Binder = rgb <128/255, 93/255, 91/255>;
#declare CN_Bookstone = rgb <140/255, 52/255, 50/255>;
#declare CN_Bookworm = rgb <235/255, 227/255, 222/255>;
#declare CN_Boot_Cut = rgb <175/255, 194/255, 207/255>;
#declare CN_Boot_Hill_Ghost = rgb <221/255, 175/255, 142/255>;
#declare CN_Bootstrap_Leather = rgb <121/255, 55/255, 33/255>;
#declare CN_Booty_Bay = rgb <127/255, 198/255, 190/255>;
#declare CN_Bora_Bora_Shore = rgb <146/255, 208/255, 208/255>;
#declare CN_Borage = rgb <80/255, 126/255, 164/255>;
#declare CN_Borage_Blue = rgb <85/255, 102/255, 204/255>;
#declare CN_Bordeaux = rgb <123/255, 0/255, 44/255>;
#declare CN_Bordeaux_Hint = rgb <239/255, 188/255, 222/255>;
#declare CN_Bordeaux_Leaf = rgb <92/255, 57/255, 68/255>;
#declare CN_Bordeaux_Red = rgb <111/255, 44/255, 79/255>;
#declare CN_Borderline_Pink = rgb <238/255, 17/255, 102/255>;
#declare CN_Boreal = rgb <113/255, 126/255, 115/255>;
#declare CN_Bored_Accent_Green = rgb <222/255, 221/255, 152/255>;
#declare CN_Boredom = rgb <140/255, 156/255, 156/255>;
#declare CN_Boredom_Buster = rgb <255/255, 142/255, 81/255>;
#declare CN_Borg_Drone = rgb <6/255, 71/255, 12/255>;
#declare CN_Borg_Queen = rgb <5/255, 73/255, 7/255>;
#declare CN_Boring_Green = rgb <99/255, 179/255, 101/255>;
#declare CN_Borlotti_Bean = rgb <217/255, 177/255, 170/255>;
#declare CN_Borscht = rgb <140/255, 44/255, 36/255>;
#declare CN_Bosc_Pear = rgb <192/255, 144/255, 86/255>;
#declare CN_Bosco_Blue = rgb <118/255, 160/255, 175/255>;
#declare CN_Boson_Brown = rgb <85/255, 44/255, 28/255>;
#declare CN_Bosozoku_Pink = rgb <231/255, 219/255, 225/255>;
#declare CN_Bosphorus = rgb <0/255, 117/255, 88/255>;
#declare CN_Bosporus = rgb <1/255, 93/255, 117/255>;
#declare CN_Bossa_Nova = rgb <76/255, 61/255, 78/255>;
#declare CN_Bossa_Nova_Blue = rgb <118/255, 124/255, 158/255>;
#declare CN_Boston_Blue = rgb <67/255, 142/255, 172/255>;
#declare CN_Boston_Brick = rgb <135/255, 84/255, 78/255>;
#declare CN_Boston_Fern = rgb <144/255, 150/255, 109/255>;
#declare CN_Boston_University_Red = rgb <204/255, 0/255, 2/255>;
#declare CN_Botan = rgb <162/255, 52/255, 92/255>;
#declare CN_Botanical_Beauty = rgb <34/255, 119/255, 0/255>;
#declare CN_Botanical_Garden = rgb <68/255, 170/255, 17/255>;
#declare CN_Botanical_Green = rgb <119/255, 151/255, 110/255>;
#declare CN_Botanical_Night = rgb <18/255, 64/255, 60/255>;
#declare CN_Botanical_Tint = rgb <167/255, 230/255, 212/255>;
#declare CN_Botticelli = rgb <146/255, 172/255, 180/255>;
#declare CN_Botticelli_Angel = rgb <251/255, 223/255, 214/255>;
#declare CN_Bottle_Green = rgb <0/255, 106/255, 78/255>;
#declare CN_Bottlebrush_Blossom = rgb <232/255, 237/255, 176/255>;
#declare CN_Boudin = rgb <218/255, 178/255, 125/255>;
#declare CN_Boudoir_Blue = rgb <126/255, 163/255, 210/255>;
#declare CN_Bougainvillea = rgb <152/255, 132/255, 185/255>;
#declare CN_Boulder = rgb <124/255, 129/255, 124/255>;
#declare CN_Boulder_Brown = rgb <101/255, 94/255, 78/255>;
#declare CN_Boulder_Creek = rgb <140/255, 148/255, 150/255>;
#declare CN_Bouncy_Ball_Green = rgb <73/255, 164/255, 98/255>;
#declare CN_Boundless = rgb <91/255, 109/255, 132/255>;
#declare CN_Bouquet = rgb <167/255, 129/255, 153/255>;
#declare CN_Bourbon = rgb <175/255, 108/255, 62/255>;
#declare CN_Bourbon_Spice = rgb <230/255, 190/255, 138/255>;
#declare CN_Bourbon_Truffle = rgb <108/255, 86/255, 84/255>;
#declare CN_Bourgeois = rgb <238/255, 0/255, 102/255>;
#declare CN_Bournonite_Green = rgb <99/255, 122/255, 114/255>;
#declare CN_Boutique_Beige = rgb <225/255, 206/255, 173/255>;
#declare CN_Bovine = rgb <82/255, 88/255, 92/255>;
#declare CN_Bow_Tie = rgb <190/255, 38/255, 51/255>;
#declare CN_Bowen_Blue = rgb <18/255, 109/255, 168/255>;
#declare CN_Bowerbird_Blue = rgb <0/255, 101/255, 133/255>;
#declare CN_Bowling_Green = rgb <191/255, 222/255, 175/255>;
#declare CN_Bowman_Blue = rgb <88/255, 113/255, 118/255>;
#declare CN_Bowser_Shell = rgb <83/255, 107/255, 31/255>;
#declare CN_Bowstring = rgb <214/255, 209/255, 200/255>;
#declare CN_Box_Office = rgb <137/255, 135/255, 144/255>;
#declare CN_Boxcar = rgb <135/255, 61/255, 48/255>;
#declare CN_Boxwood = rgb <112/255, 123/255, 113/255>;
#declare CN_Boxwood_Yellow = rgb <239/255, 228/255, 165/255>;
#declare CN_Boy_Blue = rgb <140/255, 172/255, 214/255>;
#declare CN_Boy_Red = rgb <179/255, 17/255, 29/255>;
#declare CN_Boycott = rgb <99/255, 92/255, 83/255>;
#declare CN_Boynton_Canyon = rgb <159/255, 78/255, 62/255>;
#declare CN_Boysenberry = rgb <135/255, 50/255, 96/255>;
#declare CN_Boysenberry_Shadow = rgb <241/255, 243/255, 249/255>;
#declare CN_Boyzone = rgb <42/255, 150/255, 213/255>;
#declare CN_Bracing_Blue = rgb <1/255, 65/255, 130/255>;
#declare CN_Bracken = rgb <91/255, 61/255, 39/255>;
#declare CN_Bracken_Fern = rgb <49/255, 69/255, 59/255>;
#declare CN_Bracken_Green = rgb <98/255, 111/255, 93/255>;
#declare CN_Bradford_Brown = rgb <132/255, 114/255, 108/255>;
#declare CN_Braid = rgb <119/255, 103/255, 91/255>;
#declare CN_Braided_Raffia = rgb <225/255, 208/255, 175/255>;
#declare CN_Brain_Freeze = rgb <0/255, 238/255, 255/255>;
#declare CN_Brain_Pink = rgb <242/255, 174/255, 177/255>;
#declare CN_Brainstem_Grey = rgb <181/255, 181/255, 181/255>;
#declare CN_Brainstorm = rgb <209/255, 211/255, 192/255>;
#declare CN_Brainstorm_Bronze = rgb <116/255, 104/255, 90/255>;
#declare CN_Braintree = rgb <101/255, 99/255, 91/255>;
#declare CN_Brake_Light_Trails = rgb <238/255, 0/255, 51/255>;
#declare CN_Bramble_Bush = rgb <80/255, 54/255, 41/255>;
#declare CN_Bramble_Jam = rgb <199/255, 21/255, 129/255>;
#declare CN_Brampton_Grey = rgb <155/255, 162/255, 157/255>;
#declare CN_Bran = rgb <166/255, 110/255, 74/255>;
#declare CN_Brandeis_Blue = rgb <0/255, 112/255, 255/255>;
#declare CN_Brandied_Apple = rgb <163/255, 124/255, 121/255>;
#declare CN_Brandied_Apricot = rgb <202/255, 132/255, 138/255>;
#declare CN_Brandied_Melon = rgb <206/255, 123/255, 91/255>;
#declare CN_Brandied_Pears = rgb <234/255, 226/255, 209/255>;
#declare CN_Brandy = rgb <220/255, 182/255, 138/255>;
#declare CN_Brandy_Alexander = rgb <243/255, 226/255, 220/255>;
#declare CN_Brandy_Bear = rgb <170/255, 84/255, 18/255>;
#declare CN_Brandy_Brown = rgb <115/255, 54/255, 42/255>;
#declare CN_Brandy_Butter = rgb <243/255, 187/255, 143/255>;
#declare CN_Brandy_Punch = rgb <192/255, 124/255, 64/255>;
#declare CN_Brandy_Rose = rgb <182/255, 133/255, 122/255>;
#declare CN_Brandy_Snaps = rgb <181/255, 142/255, 139/255>;
#declare CN_Brandywine = rgb <73/255, 2/255, 6/255>;
#declare CN_Brandywine_Raspberry = rgb <85/255, 85/255, 170/255>;
#declare CN_Brandywine_Spritz = rgb <230/255, 157/255, 173/255>;
#declare CN_Brass = rgb <181/255, 166/255, 66/255>;
#declare CN_Brass_Balls = rgb <231/255, 189/255, 66/255>;
#declare CN_Brass_Button = rgb <146/255, 113/255, 73/255>;
#declare CN_Brass_Buttons = rgb <223/255, 172/255, 76/255>;
#declare CN_Brass_Mesh = rgb <225/255, 168/255, 75/255>;
#declare CN_Brass_Nail = rgb <219/255, 189/255, 118/255>;
#declare CN_Brass_Scorpion = rgb <119/255, 59/255, 46/255>;
#declare CN_Brass_Trumpet = rgb <236/255, 174/255, 88/255>;
#declare CN_Brass_Yellow = rgb <181/255, 135/255, 53/255>;
#declare CN_Brassed_Off = rgb <207/255, 167/255, 67/255>;
#declare CN_Brassica = rgb <120/255, 136/255, 121/255>;
#declare CN_Brasso = rgb <243/255, 188/255, 107/255>;
#declare CN_Brassy = rgb <213/255, 171/255, 44/255>;
#declare CN_Brassy_Brass = rgb <119/255, 96/255, 34/255>;
#declare CN_Brattle_Spruce = rgb <69/255, 71/255, 67/255>;
#declare CN_Bratwurst = rgb <88/255, 47/255, 43/255>;
#declare CN_Braun = rgb <137/255, 112/255, 88/255>;
#declare CN_Bravado_Red = rgb <160/255, 82/255, 78/255>;
#declare CN_Brave_Orange = rgb <255/255, 99/255, 28/255>;
#declare CN_Brave_Purple = rgb <150/255, 141/255, 184/255>;
#declare CN_Bravo_Blue = rgb <211/255, 231/255, 233/255>;
#declare CN_Brazen_Brass = rgb <123/255, 102/255, 35/255>;
#declare CN_Brazen_Orange = rgb <206/255, 120/255, 80/255>;
#declare CN_Brazil_Nut = rgb <133/255, 103/255, 101/255>;
#declare CN_Brazilian_Brown = rgb <127/255, 81/255, 49/255>;
#declare CN_Brazilian_Citrine = rgb <175/255, 145/255, 93/255>;
#declare CN_Brazilian_Green = rgb <41/255, 109/255, 35/255>;
#declare CN_Brazilian_Sand = rgb <218/255, 202/255, 183/255>;
#declare CN_Brazilian_Tan = rgb <221/255, 197/255, 175/255>;
#declare CN_Bread_n_Butter = rgb <255/255, 209/255, 130/255>;
#declare CN_Bread_and_Butter = rgb <250/255, 237/255, 210/255>;
#declare CN_Bread_Basket = rgb <171/255, 134/255, 89/255>;
#declare CN_Bread_Crumb = rgb <228/255, 212/255, 190/255>;
#declare CN_Bread_Crust = rgb <183/255, 139/255, 67/255>;
#declare CN_Bread_Flavour = rgb <220/255, 214/255, 210/255>;
#declare CN_Bread_Pudding = rgb <191/255, 162/255, 112/255>;
#declare CN_Break_of_Day = rgb <255/255, 250/255, 189/255>;
#declare CN_Break_the_Ice = rgb <178/255, 225/255, 238/255>;
#declare CN_Breakaway = rgb <206/255, 218/255, 195/255>;
#declare CN_Breakaway_Blue = rgb <66/255, 77/255, 96/255>;
#declare CN_Breaker = rgb <229/255, 237/255, 237/255>;
#declare CN_Breaker_Bay = rgb <81/255, 123/255, 120/255>;
#declare CN_Breakfast_Biscuit = rgb <246/255, 227/255, 211/255>;
#declare CN_Breakfast_Blend = rgb <109/255, 85/255, 66/255>;
#declare CN_Breaking_Wave = rgb <0/255, 160/255, 176/255>;
#declare CN_Breaktime = rgb <196/255, 217/255, 206/255>;
#declare CN_Breakwater = rgb <209/255, 222/255, 228/255>;
#declare CN_Breakwater_White = rgb <235/255, 241/255, 233/255>;
#declare CN_Breakwaters = rgb <217/255, 229/255, 224/255>;
#declare CN_Breath_of_Fire = rgb <238/255, 0/255, 17/255>;
#declare CN_Breath_Of_Spring = rgb <223/255, 238/255, 218/255>;
#declare CN_Breath_of_Spring = rgb <233/255, 225/255, 167/255>;
#declare CN_Breathe = rgb <209/255, 210/255, 184/255>;
#declare CN_Breathless = rgb <223/255, 218/255, 224/255>;
#declare CN_Breathtaking = rgb <83/255, 97/255, 147/255>;
#declare CN_Breathtaking_Evening = rgb <195/255, 172/255, 183/255>;
#declare CN_Breathtaking_View = rgb <128/255, 155/255, 172/255>;
#declare CN_Bredon_Green = rgb <94/255, 153/255, 72/255>;
#declare CN_Breen = rgb <121/255, 93/255, 52/255>;
#declare CN_Breeze = rgb <194/255, 221/255, 230/255>;
#declare CN_Breeze_in_June = rgb <196/255, 223/255, 232/255>;
#declare CN_Breeze_of_Green = rgb <207/255, 253/255, 188/255>;
#declare CN_Breezeway = rgb <214/255, 219/255, 192/255>;
#declare CN_Breezy = rgb <174/255, 201/255, 234/255>;
#declare CN_Breezy_Aqua = rgb <217/255, 228/255, 222/255>;
#declare CN_Breezy_Beige = rgb <247/255, 242/255, 215/255>;
#declare CN_Breezy_Blue = rgb <186/255, 217/255, 229/255>;
#declare CN_Breonne_Blue = rgb <45/255, 86/255, 124/255>;
#declare CN_Bresaola = rgb <169/255, 32/255, 62/255>;
#declare CN_Brescian_Blue = rgb <0/255, 128/255, 255/255>;
#declare CN_Bretzel_Brown = rgb <170/255, 85/255, 85/255>;
#declare CN_Brevity_Brown = rgb <113/255, 82/255, 67/255>;
#declare CN_Brewed_Mustard = rgb <230/255, 131/255, 100/255>;
#declare CN_Brewing_Storm = rgb <119/255, 119/255, 136/255>;
#declare CN_Briar = rgb <116/255, 84/255, 67/255>;
#declare CN_Briar_Rose = rgb <192/255, 114/255, 129/255>;
#declare CN_Briar_Wood = rgb <105/255, 84/255, 81/255>;
#declare CN_Brick = rgb <160/255, 54/255, 35/255>;
#declare CN_Brick_Brown = rgb <119/255, 96/255, 63/255>;
#declare CN_Brick_Dust = rgb <176/255, 112/255, 105/255>;
#declare CN_Brick_Fence = rgb <179/255, 128/255, 112/255>;
#declare CN_Brick_Hearth = rgb <149/255, 97/255, 89/255>;
#declare CN_Brick_Orange = rgb <193/255, 74/255, 9/255>;
#declare CN_Brick_Path = rgb <194/255, 151/255, 124/255>;
#declare CN_Brick_Paver = rgb <147/255, 64/255, 47/255>;
#declare CN_Brick_Red = rgb <143/255, 20/255, 2/255>;
#declare CN_Brick_Yellow = rgb <210/255, 161/255, 97/255>;
#declare CN_Brick_A_Brack = rgb <167/255, 92/255, 61/255>;
#declare CN_Brickhouse = rgb <134/255, 74/255, 54/255>;
#declare CN_Bricks_of_Hope = rgb <219/255, 88/255, 86/255>;
#declare CN_Bricktone = rgb <130/255, 89/255, 67/255>;
#declare CN_Brickwork_Red = rgb <152/255, 105/255, 113/255>;
#declare CN_Bridal_Blush = rgb <238/255, 226/255, 221/255>;
#declare CN_Bridal_Bouquet = rgb <235/255, 189/255, 184/255>;
#declare CN_Bridal_Heath = rgb <248/255, 235/255, 221/255>;
#declare CN_Bridal_Rose = rgb <214/255, 159/255, 162/255>;
#declare CN_Bridal_Veil = rgb <231/255, 225/255, 222/255>;
#declare CN_Brides_Blush = rgb <249/255, 226/255, 225/255>;
#declare CN_Bridesmaid = rgb <250/255, 230/255, 223/255>;
#declare CN_Bridge_Troll_Grey = rgb <129/255, 127/255, 110/255>;
#declare CN_Bridgeport = rgb <0/255, 70/255, 131/255>;
#declare CN_Bridgewater = rgb <82/255, 112/255, 101/255>;
#declare CN_Bridgewater_Bay = rgb <188/255, 215/255, 226/255>;
#declare CN_Bridgewood = rgb <87/255, 81/255, 68/255>;
#declare CN_Bridle_Leather = rgb <143/255, 125/255, 112/255>;
#declare CN_Bridle_Path = rgb <162/255, 150/255, 130/255>;
#declare CN_Brierwood_Green = rgb <84/255, 94/255, 79/255>;
#declare CN_Brig = rgb <79/255, 161/255, 192/255>;
#declare CN_Brig_ODoon = rgb <221/255, 207/255, 191/255>;
#declare CN_Brigade = rgb <54/255, 93/255, 115/255>;
#declare CN_Brigadier_Blue = rgb <0/255, 99/255, 160/255>;
#declare CN_Bright_Aqua = rgb <11/255, 249/255, 234/255>;
#declare CN_Bright_Blue = rgb <1/255, 101/255, 252/255>;
#declare CN_Bright_Blue_Violet = rgb <138/255, 43/255, 226/255>;
#declare CN_Bright_Bluebell = rgb <157/255, 167/255, 207/255>;
#declare CN_Bright_Bluebonnet = rgb <144/255, 179/255, 194/255>;
#declare CN_Bright_Bronze = rgb <160/255, 88/255, 34/255>;
#declare CN_Bright_Brown = rgb <83/255, 59/255, 50/255>;
#declare CN_Bright_Bubble = rgb <255/255, 196/255, 42/255>;
#declare CN_Bright_Camouflage = rgb <28/255, 172/255, 120/255>;
#declare CN_Bright_Cerulean = rgb <29/255, 172/255, 214/255>;
#declare CN_Bright_Chambray = rgb <173/255, 191/255, 200/255>;
#declare CN_Bright_Chartreuse = rgb <223/255, 255/255, 17/255>;
#declare CN_Bright_Citrus = rgb <255/255, 198/255, 165/255>;
#declare CN_Bright_Clove = rgb <239/255, 207/255, 155/255>;
#declare CN_Bright_Cobalt = rgb <56/255, 93/255, 141/255>;
#declare CN_Bright_Cyan = rgb <65/255, 253/255, 254/255>;
#declare CN_Bright_Delight = rgb <205/255, 91/255, 38/255>;
#declare CN_Bright_Dusk = rgb <238/255, 233/255, 249/255>;
#declare CN_Bright_Ecru = rgb <254/255, 255/255, 202/255>;
#declare CN_Bright_Eggplant = rgb <90/255, 78/255, 136/255>;
#declare CN_Bright_Gold = rgb <207/255, 159/255, 82/255>;
#declare CN_Bright_Greek = rgb <56/255, 68/255, 244/255>;
#declare CN_Bright_Green = rgb <102/255, 255/255, 0/255>;
#declare CN_Bright_Grey = rgb <235/255, 236/255, 240/255>;
#declare CN_Bright_Halo = rgb <255/255, 210/255, 102/255>;
#declare CN_Bright_Idea = rgb <236/255, 190/255, 99/255>;
#declare CN_Bright_Indigo = rgb <111/255, 0/255, 254/255>;
#declare CN_Bright_Khaki = rgb <241/255, 231/255, 140/255>;
#declare CN_Bright_Lady = rgb <159/255, 54/255, 69/255>;
#declare CN_Bright_Laughter = rgb <240/255, 237/255, 209/255>;
#declare CN_Bright_Lavender = rgb <191/255, 148/255, 228/255>;
#declare CN_Bright_Lettuce = rgb <141/255, 206/255, 101/255>;
#declare CN_Bright_Light_Green = rgb <45/255, 254/255, 84/255>;
#declare CN_Bright_Lilac = rgb <216/255, 145/255, 239/255>;
#declare CN_Bright_Lime = rgb <135/255, 253/255, 5/255>;
#declare CN_Bright_Lime_Green = rgb <101/255, 254/255, 8/255>;
#declare CN_Bright_Loam = rgb <193/255, 185/255, 170/255>;
#declare CN_Bright_Magenta = rgb <255/255, 8/255, 232/255>;
#declare CN_Bright_Manatee = rgb <151/255, 154/255, 170/255>;
#declare CN_Bright_Mango = rgb <255/255, 136/255, 48/255>;
#declare CN_Bright_Marigold = rgb <255/255, 141/255, 0/255>;
#declare CN_Bright_Maroon = rgb <195/255, 33/255, 72/255>;
#declare CN_Bright_Midnight = rgb <1/255, 25/255, 147/255>;
#declare CN_Bright_Midnight_Blue = rgb <26/255, 72/255, 118/255>;
#declare CN_Bright_Mint = rgb <152/255, 255/255, 152/255>;
#declare CN_Bright_Moon = rgb <246/255, 241/255, 229/255>;
#declare CN_Bright_Nautilus = rgb <34/255, 88/255, 105/255>;
#declare CN_Bright_Navy_Blue = rgb <25/255, 116/255, 210/255>;
#declare CN_Bright_Nori = rgb <45/255, 94/255, 34/255>;
#declare CN_Bright_Ocarina = rgb <240/255, 232/255, 218/255>;
#declare CN_Bright_Olive = rgb <156/255, 187/255, 4/255>;
#declare CN_Bright_Orange = rgb <255/255, 112/255, 52/255>;
#declare CN_Bright_Pink = rgb <254/255, 1/255, 177/255>;
#declare CN_Bright_Purple = rgb <190/255, 3/255, 253/255>;
#declare CN_Bright_Red = rgb <255/255, 0/255, 13/255>;
#declare CN_Bright_Rose = rgb <197/255, 25/255, 89/255>;
#declare CN_Bright_Saffron = rgb <255/255, 207/255, 9/255>;
#declare CN_Bright_Sage = rgb <209/255, 206/255, 180/255>;
#declare CN_Bright_Scarlet = rgb <252/255, 14/255, 52/255>;
#declare CN_Bright_Sea_Green = rgb <159/255, 226/255, 191/255>;
#declare CN_Bright_Sepia = rgb <177/255, 170/255, 156/255>;
#declare CN_Bright_Sienna = rgb <214/255, 138/255, 89/255>;
#declare CN_Bright_Sky_Blue = rgb <2/255, 204/255, 254/255>;
#declare CN_Bright_Spark = rgb <118/255, 193/255, 225/255>;
#declare CN_Bright_Star = rgb <221/255, 226/255, 230/255>;
#declare CN_Bright_Sun = rgb <236/255, 189/255, 44/255>;
#declare CN_Bright_Teal = rgb <1/255, 249/255, 198/255>;
#declare CN_Bright_Turquoise = rgb <8/255, 232/255, 222/255>;
#declare CN_Bright_Ube = rgb <209/255, 159/255, 232/255>;
#declare CN_Bright_Umber = rgb <130/255, 102/255, 68/255>;
#declare CN_Bright_Violet = rgb <173/255, 10/255, 253/255>;
#declare CN_Bright_White = rgb <244/255, 245/255, 240/255>;
#declare CN_Bright_Winter_Cloud = rgb <245/255, 239/255, 232/255>;
#declare CN_Bright_Yarrow = rgb <250/255, 206/255, 109/255>;
#declare CN_Bright_Yellow = rgb <255/255, 253/255, 1/255>;
#declare CN_Bright_Yellow_Green = rgb <157/255, 255/255, 0/255>;
#declare CN_Bright_Zenith = rgb <117/255, 124/255, 174/255>;
#declare CN_Brihaspati_Orange = rgb <226/255, 104/255, 27/255>;
#declare CN_Brik_Dough = rgb <218/255, 183/255, 127/255>;
#declare CN_Brilliance = rgb <253/255, 253/255, 253/255>;
#declare CN_Brilliant = rgb <0/255, 148/255, 167/255>;
#declare CN_Brilliant_Azure = rgb <51/255, 153/255, 255/255>;
#declare CN_Brilliant_Beige = rgb <239/255, 197/255, 181/255>;
#declare CN_Brilliant_Blue = rgb <0/255, 117/255, 179/255>;
#declare CN_Brilliant_Carmine = rgb <173/255, 84/255, 143/255>;
#declare CN_Brilliant_Green = rgb <136/255, 180/255, 7/255>;
#declare CN_Brilliant_Impression = rgb <239/255, 198/255, 0/255>;
#declare CN_Brilliant_Lavender = rgb <244/255, 187/255, 255/255>;
#declare CN_Brilliant_Rose = rgb <254/255, 84/255, 163/255>;
#declare CN_Brilliant_Sea = rgb <0/255, 156/255, 183/255>;
#declare CN_Brilliant_Silver = rgb <169/255, 176/255, 180/255>;
#declare CN_Brilliant_Turquoise = rgb <0/255, 166/255, 139/255>;
#declare CN_Brilliant_White = rgb <237/255, 241/255, 254/255>;
#declare CN_Brilliant_Yellow = rgb <232/255, 229/255, 216/255>;
#declare CN_Brimstone = rgb <255/255, 189/255, 43/255>;
#declare CN_Brimstone_Butterfly = rgb <194/255, 193/255, 144/255>;
#declare CN_Brindle = rgb <130/255, 119/255, 107/255>;
#declare CN_Brink_Pink = rgb <251/255, 96/255, 127/255>;
#declare CN_Briny = rgb <8/255, 128/255, 142/255>;
#declare CN_Brioche = rgb <223/255, 207/255, 195/255>;
#declare CN_Briquette = rgb <225/255, 95/255, 101/255>;
#declare CN_Briquette_Grey = rgb <80/255, 80/255, 80/255>;
#declare CN_Brisa_De_Mar = rgb <210/255, 224/255, 239/255>;
#declare CN_Brisk_Blue = rgb <109/255, 130/255, 157/255>;
#declare CN_Brisket = rgb <110/255, 69/255, 52/255>;
#declare CN_Bristle_Grass = rgb <162/255, 132/255, 80/255>;
#declare CN_Bristol_Beige = rgb <147/255, 131/255, 111/255>;
#declare CN_Bristol_Blue = rgb <85/255, 143/255, 145/255>;
#declare CN_Bristol_Green = rgb <131/255, 164/255, 146/255>;
#declare CN_Britches = rgb <160/255, 144/255, 115/255>;
#declare CN_British_Grey_Mauve = rgb <125/255, 112/255, 129/255>;
#declare CN_British_Khaki = rgb <188/255, 175/255, 151/255>;
#declare CN_British_Mauve = rgb <53/255, 66/255, 123/255>;
#declare CN_British_Racing_Green = rgb <5/255, 72/255, 13/255>;
#declare CN_British_Rose = rgb <244/255, 200/255, 219/255>;
#declare CN_British_Shorthair = rgb <95/255, 102/255, 114/255>;
#declare CN_Brittany_Blue = rgb <76/255, 126/255, 134/255>;
#declare CN_Brittanys_Bow = rgb <243/255, 216/255, 224/255>;
#declare CN_Brittlebush = rgb <234/255, 174/255, 71/255>;
#declare CN_Broad_Daylight = rgb <187/255, 221/255, 255/255>;
#declare CN_Broadleaf_Forest = rgb <1/255, 68/255, 33/255>;
#declare CN_Broadwater_Blue = rgb <3/255, 74/255, 113/255>;
#declare CN_Broadway = rgb <67/255, 68/255, 66/255>;
#declare CN_Broadway_Lights = rgb <254/255, 224/255, 124/255>;
#declare CN_Brocade = rgb <140/255, 135/255, 197/255>;
#declare CN_Brocade_Violet = rgb <123/255, 77/255, 107/255>;
#declare CN_Broccoflower = rgb <143/255, 162/255, 119/255>;
#declare CN_Broccoli_Brown = rgb <155/255, 133/255, 107/255>;
#declare CN_Broccoli_Green = rgb <75/255, 83/255, 56/255>;
#declare CN_Broccoli_Paradise = rgb <0/255, 136/255, 51/255>;
#declare CN_Brochantite_Green = rgb <72/255, 98/255, 98/255>;
#declare CN_Broiled_Flounder = rgb <255/255, 221/255, 136/255>;
#declare CN_Broken_Blue = rgb <116/255, 187/255, 251/255>;
#declare CN_Broken_Tube = rgb <6/255, 3/255, 16/255>;
#declare CN_Broken_White = rgb <238/255, 235/255, 227/255>;
#declare CN_Bronco = rgb <167/255, 151/255, 129/255>;
#declare CN_Bronze = rgb <168/255, 121/255, 0/255>;
#declare CN_Bronze_Blue = rgb <58/255, 72/255, 86/255>;
#declare CN_Bronze_Brown = rgb <130/255, 94/255, 47/255>;
#declare CN_Bronze_Fig = rgb <110/255, 102/255, 84/255>;
#declare CN_Bronze_Flesh = rgb <247/255, 148/255, 74/255>;
#declare CN_Bronze_Green = rgb <141/255, 135/255, 82/255>;
#declare CN_Bronze_Icon = rgb <88/255, 85/255, 56/255>;
#declare CN_Bronze_Medal = rgb <109/255, 98/255, 64/255>;
#declare CN_Bronze_Mist = rgb <156/255, 126/255, 65/255>;
#declare CN_Bronze_Olive = rgb <88/255, 76/255, 37/255>;
#declare CN_Bronze_Sand = rgb <230/255, 190/255, 156/255>;
#declare CN_Bronze_Satin = rgb <204/255, 85/255, 51/255>;
#declare CN_Bronze_Tone = rgb <67/255, 76/255, 40/255>;
#declare CN_Bronze_Treasure = rgb <176/255, 141/255, 87/255>;
#declare CN_Bronze_Yellow = rgb <115/255, 112/255, 0/255>;
#declare CN_Bronzed = rgb <221/255, 102/255, 51/255>;
#declare CN_Bronzed_Brass = rgb <155/255, 126/255, 78/255>;
#declare CN_Bronzed_Flesh = rgb <235/255, 149/255, 82/255>;
#declare CN_Bronzed_Orange = rgb <215/255, 138/255, 108/255>;
#declare CN_Brood = rgb <105/255, 96/255, 90/255>;
#declare CN_Brooding_Storm = rgb <94/255, 109/255, 110/255>;
#declare CN_Brook_Green = rgb <175/255, 221/255, 204/255>;
#declare CN_Brook_Trout = rgb <218/255, 206/255, 205/255>;
#declare CN_Brooklet = rgb <231/255, 238/255, 238/255>;
#declare CN_Brooklyn = rgb <88/255, 103/255, 102/255>;
#declare CN_Brookside = rgb <90/255, 117/255, 98/255>;
#declare CN_Brookview = rgb <153/255, 183/255, 146/255>;
#declare CN_Broom = rgb <238/255, 204/255, 36/255>;
#declare CN_Broom_Butterfly_Blue = rgb <107/255, 179/255, 219/255>;
#declare CN_Broomstick = rgb <116/255, 70/255, 45/255>;
#declare CN_Brother_Blue = rgb <176/255, 183/255, 198/255>;
#declare CN_Brown = rgb <101/255, 55/255, 0/255>;
#declare CN_Brown_383 = rgb <68/255, 55/255, 36/255>;
#declare CN_Brown_Alpaca = rgb <184/255, 109/255, 41/255>;
#declare CN_Brown_Bag = rgb <222/255, 172/255, 110/255>;
#declare CN_Brown_Bear = rgb <74/255, 63/255, 55/255>;
#declare CN_Brown_Beauty = rgb <74/255, 56/255, 50/255>;
#declare CN_Brown_Beige = rgb <204/255, 136/255, 51/255>;
#declare CN_Brown_Bramble = rgb <83/255, 51/255, 30/255>;
#declare CN_Brown_Bread = rgb <212/255, 197/255, 169/255>;
#declare CN_Brown_Butter = rgb <172/255, 124/255, 0/255>;
#declare CN_Brown_Cerberus = rgb <153/255, 85/255, 85/255>;
#declare CN_Brown_Chocolate = rgb <95/255, 25/255, 51/255>;
#declare CN_Brown_Clay = rgb <195/255, 124/255, 89/255>;
#declare CN_Brown_Coffee = rgb <74/255, 44/255, 42/255>;
#declare CN_Brown_Derby = rgb <89/255, 69/255, 55/255>;
#declare CN_Brown_Eyes = rgb <158/255, 107/255, 74/255>;
#declare CN_Brown_Fox = rgb <84/255, 74/255, 66/255>;
#declare CN_Brown_Green = rgb <112/255, 108/255, 17/255>;
#declare CN_Brown_Grey = rgb <141/255, 132/255, 104/255>;
#declare CN_Brown_Knapweed = rgb <244/255, 133/255, 172/255>;
#declare CN_Brown_Labrador = rgb <151/255, 56/255, 44/255>;
#declare CN_Brown_Magenta = rgb <123/255, 32/255, 57/255>;
#declare CN_Brown_Moelleux = rgb <102/255, 34/255, 17/255>;
#declare CN_Brown_Mouse = rgb <216/255, 203/255, 181/255>;
#declare CN_Brown_Mustard = rgb <223/255, 172/255, 89/255>;
#declare CN_Brown_Orange = rgb <185/255, 105/255, 2/255>;
#declare CN_Brown_Patina = rgb <131/255, 79/255, 61/255>;
#declare CN_Brown_Pepper = rgb <78/255, 64/255, 59/255>;
#declare CN_Brown_Pod = rgb <60/255, 36/255, 27/255>;
#declare CN_Brown_Rabbit = rgb <174/255, 142/255, 101/255>;
#declare CN_Brown_Red = rgb <146/255, 43/255, 5/255>;
#declare CN_Brown_Rice = rgb <218/255, 189/255, 132/255>;
#declare CN_Brown_Ridge = rgb <115/255, 88/255, 82/255>;
#declare CN_Brown_Rose = rgb <141/255, 115/255, 108/255>;
#declare CN_Brown_Rum = rgb <188/255, 155/255, 78/255>;
#declare CN_Brown_Rust = rgb <175/255, 89/255, 62/255>;
#declare CN_Brown_Sand = rgb <247/255, 148/255, 95/255>;
#declare CN_Brown_Stone = rgb <89/255, 60/255, 57/255>;
#declare CN_Brown_Suede = rgb <91/255, 79/255, 65/255>;
#declare CN_Brown_Sugar = rgb <161/255, 114/255, 73/255>;
#declare CN_Brown_Sugar_Coating = rgb <200/255, 174/255, 150/255>;
#declare CN_Brown_Teepee = rgb <188/255, 167/255, 146/255>;
#declare CN_Brown_Thrush = rgb <144/255, 97/255, 81/255>;
#declare CN_Brown_Tumbleweed = rgb <55/255, 41/255, 14/255>;
#declare CN_Brown_Velvet = rgb <112/255, 78/255, 64/255>;
#declare CN_Brown_Wood = rgb <180/255, 103/255, 77/255>;
#declare CN_Brown_Yellow = rgb <221/255, 153/255, 102/255>;
#declare CN_Brown_Bag_It = rgb <221/255, 189/255, 163/255>;
#declare CN_Browned_Off = rgb <187/255, 68/255, 51/255>;
#declare CN_Brownie = rgb <150/255, 75/255, 0/255>;
#declare CN_Brownish = rgb <156/255, 109/255, 87/255>;
#declare CN_Brownish_Black = rgb <65/255, 57/255, 54/255>;
#declare CN_Brownish_Green = rgb <106/255, 110/255, 9/255>;
#declare CN_Brownish_Grey = rgb <134/255, 119/255, 95/255>;
#declare CN_Brownish_Orange = rgb <203/255, 119/255, 35/255>;
#declare CN_Brownish_Pink = rgb <194/255, 126/255, 121/255>;
#declare CN_Brownish_Purple = rgb <118/255, 66/255, 78/255>;
#declare CN_Brownish_Purple_Red = rgb <141/255, 116/255, 111/255>;
#declare CN_Brownish_Red = rgb <158/255, 54/255, 35/255>;
#declare CN_Brownish_Yellow = rgb <201/255, 176/255, 3/255>;
#declare CN_Brownstone = rgb <120/255, 84/255, 65/255>;
#declare CN_Browse_Brown = rgb <110/255, 97/255, 95/255>;
#declare CN_Bruin_Spice = rgb <211/255, 185/255, 155/255>;
#declare CN_Bruise = rgb <126/255, 64/255, 113/255>;
#declare CN_Bruised_Bear = rgb <93/255, 57/255, 84/255>;
#declare CN_Bruised_Burgundy = rgb <91/255, 65/255, 72/255>;
#declare CN_Brume = rgb <198/255, 198/255, 194/255>;
#declare CN_Brunette = rgb <102/255, 66/255, 56/255>;
#declare CN_Brunnera_Blue = rgb <155/255, 169/255, 202/255>;
#declare CN_Bruno_Brown = rgb <67/255, 52/255, 48/255>;
#declare CN_Brunswick = rgb <35/255, 102/255, 73/255>;
#declare CN_Brunswick_Green = rgb <27/255, 77/255, 62/255>;
#declare CN_Bruschetta = rgb <167/255, 89/255, 73/255>;
#declare CN_Bruschetta_Tomato = rgb <255/255, 99/255, 71/255>;
#declare CN_Brush = rgb <185/255, 153/255, 132/255>;
#declare CN_Brush_Blue = rgb <212/255, 225/255, 237/255>;
#declare CN_Brushed_Clay = rgb <219/255, 147/255, 81/255>;
#declare CN_Brushed_Nickel = rgb <115/255, 112/255, 111/255>;
#declare CN_Brushstroke = rgb <241/255, 223/255, 186/255>;
#declare CN_Brushwood = rgb <140/255, 89/255, 57/255>;
#declare CN_Brusque_Brown = rgb <204/255, 102/255, 17/255>;
#declare CN_Brusque_Pink = rgb <238/255, 0/255, 255/255>;
#declare CN_Brussels = rgb <108/255, 124/255, 109/255>;
#declare CN_Brussels_Sprout_Green = rgb <102/255, 94/255, 13/255>;
#declare CN_Brutal_Doom = rgb <230/255, 22/255, 38/255>;
#declare CN_Brutal_Pink = rgb <255/255, 0/255, 187/255>;
#declare CN_Bryophyte = rgb <166/255, 190/255, 166/255>;
#declare CN_Bryopsida_Green = rgb <159/255, 224/255, 16/255>;
#declare CN_Bubble = rgb <234/255, 245/255, 231/255>;
#declare CN_Bubble_Algae = rgb <144/255, 228/255, 193/255>;
#declare CN_Bubble_Bath = rgb <232/255, 224/255, 233/255>;
#declare CN_Bubble_Bobble_Green = rgb <0/255, 184/255, 0/255>;
#declare CN_Bubble_Bobble_P2 = rgb <0/255, 132/255, 255/255>;
#declare CN_Bubble_Gum = rgb <255/255, 133/255, 255/255>;
#declare CN_Bubble_Shell = rgb <211/255, 164/255, 154/255>;
#declare CN_Bubble_Turquoise = rgb <67/255, 129/255, 122/255>;
#declare CN_Bubblegum = rgb <234/255, 115/255, 141/255>;
#declare CN_Bubblegum_Baby_Girl = rgb <204/255, 85/255, 238/255>;
#declare CN_Bubblegum_Pink = rgb <246/255, 176/255, 186/255>;
#declare CN_Bubbles = rgb <231/255, 254/255, 255/255>;
#declare CN_Bubbles_in_the_Air = rgb <211/255, 227/255, 229/255>;
#declare CN_Bubbly_Barracuda = rgb <119/255, 204/255, 255/255>;
#declare CN_Bubonic_Brown = rgb <198/255, 132/255, 0/255>;
#declare CN_Bucatini_Noodle = rgb <253/255, 245/255, 215/255>;
#declare CN_Buccaneer = rgb <110/255, 81/255, 80/255>;
#declare CN_Buccaneer_Blue = rgb <3/255, 91/255, 141/255>;
#declare CN_Buchel_Cherry = rgb <170/255, 17/255, 17/255>;
#declare CN_Buckeye = rgb <103/255, 72/255, 52/255>;
#declare CN_Bucking_Bronco = rgb <153/255, 102/255, 85/255>;
#declare CN_Buckingham_Palace = rgb <107/255, 81/255, 64/255>;
#declare CN_Buckram_Binding = rgb <217/255, 195/255, 166/255>;
#declare CN_Buckskin = rgb <212/255, 186/255, 140/255>;
#declare CN_Buckthorn_Brown = rgb <167/255, 111/255, 31/255>;
#declare CN_Buckwheat = rgb <212/255, 220/255, 214/255>;
#declare CN_Buckwheat_Flour = rgb <239/255, 226/255, 207/255>;
#declare CN_Buckwheat_Groats = rgb <224/255, 216/255, 167/255>;
#declare CN_Buckwheat_Mauve = rgb <185/255, 164/255, 176/255>;
#declare CN_Bucolic_Blue = rgb <152/255, 172/255, 176/255>;
#declare CN_Bud = rgb <165/255, 168/255, 143/255>;
#declare CN_Bud_Green = rgb <121/255, 180/255, 101/255>;
#declare CN_Buds_Sails = rgb <233/255, 227/255, 211/255>;
#declare CN_Budapest_Brown = rgb <85/255, 61/255, 62/255>;
#declare CN_Budder_Skin = rgb <252/255, 226/255, 196/255>;
#declare CN_Buddha_Gold = rgb <188/255, 155/255, 27/255>;
#declare CN_Buddha_Green = rgb <55/255, 181/255, 117/255>;
#declare CN_Buddhas_Love_Handles = rgb <255/255, 187/255, 51/255>;
#declare CN_Budding_Bloom = rgb <222/255, 234/255, 189/255>;
#declare CN_Budding_Fern = rgb <237/255, 236/255, 212/255>;
#declare CN_Budding_Leaf = rgb <238/255, 240/255, 215/255>;
#declare CN_Budding_Peach = rgb <243/255, 212/255, 191/255>;
#declare CN_Budgie_Blue = rgb <132/255, 201/255, 225/255>;
#declare CN_Budonezumi_Grape = rgb <99/255, 66/255, 75/255>;
#declare CN_Buenos_Aires = rgb <244/255, 220/255, 193/255>;
#declare CN_Buff = rgb <240/255, 220/255, 130/255>;
#declare CN_Buff_It = rgb <217/255, 207/255, 190/255>;
#declare CN_Buff_Leather = rgb <170/255, 119/255, 51/255>;
#declare CN_Buff_Orange = rgb <255/255, 187/255, 124/255>;
#declare CN_Buff_Tone = rgb <232/255, 208/255, 185/255>;
#declare CN_Buff_Yellow = rgb <241/255, 191/255, 112/255>;
#declare CN_Buffalo_Bill = rgb <174/255, 146/255, 116/255>;
#declare CN_Buffalo_Dance = rgb <105/255, 86/255, 69/255>;
#declare CN_Buffalo_Herd = rgb <112/255, 80/255, 70/255>;
#declare CN_Buffalo_Hide = rgb <187/255, 159/255, 106/255>;
#declare CN_Buffalo_Soldier = rgb <149/255, 120/255, 108/255>;
#declare CN_Buffalo_Trail = rgb <226/255, 172/255, 120/255>;
#declare CN_Buffed_Copper = rgb <221/255, 148/255, 117/255>;
#declare CN_Buffed_Plum = rgb <174/255, 175/255, 185/255>;
#declare CN_Buffhide = rgb <167/255, 156/255, 129/255>;
#declare CN_Bugle_Boy = rgb <187/255, 143/255, 79/255>;
#declare CN_Bugmans_Glow = rgb <205/255, 91/255, 69/255>;
#declare CN_Built_on_Sand = rgb <233/255, 227/255, 218/255>;
#declare CN_Bulbasaur = rgb <115/255, 162/255, 99/255>;
#declare CN_Bulfinch_Blue = rgb <148/255, 177/255, 182/255>;
#declare CN_Bulgarian_Rose = rgb <72/255, 6/255, 7/255>;
#declare CN_Bull_Kelp = rgb <99/255, 97/255, 83/255>;
#declare CN_Bull_Ring = rgb <107/255, 96/255, 91/255>;
#declare CN_Bull_Shot = rgb <117/255, 68/255, 43/255>;
#declare CN_Bullet_Hell = rgb <250/255, 241/255, 200/255>;
#declare CN_Bullfighters_Red = rgb <205/255, 70/255, 70/255>;
#declare CN_Bullfrog = rgb <138/255, 150/255, 106/255>;
#declare CN_Bulma_Hair = rgb <53/255, 158/255, 107/255>;
#declare CN_Bulrush = rgb <109/255, 88/255, 55/255>;
#declare CN_Bumangues_Blue = rgb <7/255, 119/255, 188/255>;
#declare CN_Bumble_Baby = rgb <245/255, 241/255, 222/255>;
#declare CN_Bumblebee = rgb <255/255, 200/255, 42/255>;
#declare CN_Bunchberry = rgb <103/255, 73/255, 97/255>;
#declare CN_Bundaberg_Sand = rgb <255/255, 197/255, 138/255>;
#declare CN_Bungalow_Beige = rgb <203/255, 190/255, 170/255>;
#declare CN_Bungalow_Brown = rgb <173/255, 148/255, 123/255>;
#declare CN_Bungalow_Gold = rgb <173/255, 128/255, 71/255>;
#declare CN_Bungalow_Maple = rgb <228/255, 197/255, 144/255>;
#declare CN_Bungalow_Taupe = rgb <206/255, 190/255, 159/255>;
#declare CN_Bungee_Cord = rgb <105/255, 97/255, 86/255>;
#declare CN_Bunglehouse_Blue = rgb <70/255, 97/255, 110/255>;
#declare CN_Bunglehouse_Gray = rgb <152/255, 143/255, 123/255>;
#declare CN_Bunker = rgb <41/255, 44/255, 47/255>;
#declare CN_Bunni_Brown = rgb <108/255, 69/255, 34/255>;
#declare CN_Bunny_Cake = rgb <241/255, 181/255, 204/255>;
#declare CN_Bunny_Fluff = rgb <251/255, 141/255, 166/255>;
#declare CN_Bunny_Hop = rgb <243/255, 236/255, 234/255>;
#declare CN_Bunny_Pink = rgb <222/255, 195/255, 201/255>;
#declare CN_Bunny_Soft = rgb <211/255, 191/255, 196/255>;
#declare CN_Bunny_Tail = rgb <255/255, 227/255, 244/255>;
#declare CN_Bunnys_Nose = rgb <250/255, 217/255, 221/255>;
#declare CN_Bunting = rgb <43/255, 52/255, 73/255>;
#declare CN_Bunting_Blue = rgb <53/255, 83/255, 124/255>;
#declare CN_Buoyancy = rgb <121/255, 176/255, 182/255>;
#declare CN_Buoyant = rgb <101/255, 112/255, 126/255>;
#declare CN_Buoyant_Blue = rgb <132/255, 173/255, 219/255>;
#declare CN_Burdock = rgb <113/255, 120/255, 103/255>;
#declare CN_Bureaucracy = rgb <116/255, 108/255, 143/255>;
#declare CN_Burgundy = rgb <144/255, 0/255, 32/255>;
#declare CN_Burgundy_Grey = rgb <218/255, 219/255, 160/255>;
#declare CN_Burgundy_Snail = rgb <126/255, 113/255, 80/255>;
#declare CN_Burgundy_Wine = rgb <108/255, 64/255, 62/255>;
#declare CN_Buried_Treasure = rgb <210/255, 139/255, 66/255>;
#declare CN_Burj_Khalifa_Fountain = rgb <212/255, 222/255, 232/255>;
#declare CN_Burka_Black = rgb <53/255, 62/255, 79/255>;
#declare CN_Burlap = rgb <139/255, 119/255, 83/255>;
#declare CN_Burlap_Grey = rgb <129/255, 113/255, 126/255>;
#declare CN_Burlat_Red = rgb <110/255, 49/255, 79/255>;
#declare CN_Burled_Redwood = rgb <143/255, 76/255, 58/255>;
#declare CN_Burley_Wood = rgb <105/255, 86/255, 65/255>;
#declare CN_Burlwood = rgb <155/255, 113/255, 107/255>;
#declare CN_Burma_Jade = rgb <148/255, 177/255, 160/255>;
#declare CN_Burmese_Gold = rgb <188/255, 129/255, 67/255>;
#declare CN_Burned_Brown = rgb <111/255, 75/255, 62/255>;
#declare CN_Burnham = rgb <35/255, 69/255, 55/255>;
#declare CN_Burning_Brier = rgb <136/255, 71/255, 54/255>;
#declare CN_Burning_Bush = rgb <160/255, 64/255, 62/255>;
#declare CN_Burning_Coals = rgb <247/255, 157/255, 114/255>;
#declare CN_Burning_Fireflies = rgb <255/255, 17/255, 102/255>;
#declare CN_Burning_Flame = rgb <255/255, 177/255, 98/255>;
#declare CN_Burning_Gold = rgb <204/255, 170/255, 119/255>;
#declare CN_Burning_Idea = rgb <143/255, 139/255, 114/255>;
#declare CN_Burning_Orange = rgb <255/255, 113/255, 36/255>;
#declare CN_Burning_Sand = rgb <208/255, 131/255, 99/255>;
#declare CN_Burning_Steppes = rgb <116/255, 33/255, 0/255>;
#declare CN_Burning_Tomato = rgb <235/255, 80/255, 48/255>;
#declare CN_Burning_Trail = rgb <238/255, 153/255, 34/255>;
#declare CN_Burning_Ultrablue = rgb <21/255, 10/255, 236/255>;
#declare CN_Burnished_Bark = rgb <106/255, 61/255, 54/255>;
#declare CN_Burnished_Brandy = rgb <139/255, 102/255, 78/255>;
#declare CN_Burnished_Bronze = rgb <156/255, 126/255, 64/255>;
#declare CN_Burnished_Brown = rgb <161/255, 122/255, 116/255>;
#declare CN_Burnished_Caramel = rgb <190/255, 145/255, 103/255>;
#declare CN_Burnished_Clay = rgb <210/255, 204/255, 196/255>;
#declare CN_Burnished_Copper = rgb <187/255, 136/255, 51/255>;
#declare CN_Burnished_Cream = rgb <252/255, 229/255, 191/255>;
#declare CN_Burnished_Gold = rgb <170/255, 152/255, 85/255>;
#declare CN_Burnished_Lilac = rgb <197/255, 174/255, 177/255>;
#declare CN_Burnished_Mahogany = rgb <115/255, 72/255, 66/255>;
#declare CN_Burnished_Metal = rgb <200/255, 203/255, 200/255>;
#declare CN_Burnished_Pewter = rgb <113/255, 106/255, 98/255>;
#declare CN_Burnished_Russet = rgb <121/255, 64/255, 41/255>;
#declare CN_Burns_Cave = rgb <123/255, 88/255, 71/255>;
#declare CN_Burnside = rgb <208/255, 166/255, 100/255>;
#declare CN_Burnt_Almond = rgb <176/255, 114/255, 74/255>;
#declare CN_Burnt_Ash = rgb <116/255, 101/255, 114/255>;
#declare CN_Burnt_Bagel = rgb <154/255, 78/255, 18/255>;
#declare CN_Burnt_Bamboo = rgb <77/255, 59/255, 60/255>;
#declare CN_Burnt_Brick = rgb <161/255, 77/255, 58/255>;
#declare CN_Burnt_Butter = rgb <164/255, 124/255, 83/255>;
#declare CN_Burnt_Caramel = rgb <132/255, 98/255, 66/255>;
#declare CN_Burnt_Coffee = rgb <39/255, 27/255, 16/255>;
#declare CN_Burnt_Coral = rgb <233/255, 137/255, 126/255>;
#declare CN_Burnt_Crimson = rgb <88/255, 33/255, 36/255>;
#declare CN_Burnt_Crust = rgb <136/255, 85/255, 51/255>;
#declare CN_Burnt_Earth = rgb <157/255, 69/255, 49/255>;
#declare CN_Burnt_Grape = rgb <117/255, 98/255, 94/255>;
#declare CN_Burnt_Henna = rgb <126/255, 57/255, 47/255>;
#declare CN_Burnt_Maroon = rgb <66/255, 3/255, 3/255>;
#declare CN_Burnt_Ochre = rgb <187/255, 79/255, 53/255>;
#declare CN_Burnt_Olive = rgb <100/255, 96/255, 73/255>;
#declare CN_Burnt_Orange = rgb <204/255, 85/255, 0/255>;
#declare CN_Burnt_Pumpkin = rgb <202/255, 149/255, 92/255>;
#declare CN_Burnt_Red = rgb <159/255, 35/255, 5/255>;
#declare CN_Burnt_Russet = rgb <126/255, 57/255, 64/255>;
#declare CN_Burnt_Sienna = rgb <183/255, 82/255, 3/255>;
#declare CN_Burnt_Terra = rgb <130/255, 99/255, 78/255>;
#declare CN_Burnt_Tile = rgb <119/255, 70/255, 69/255>;
#declare CN_Burnt_Toffee = rgb <171/255, 126/255, 94/255>;
#declare CN_Burnt_Umber = rgb <138/255, 51/255, 36/255>;
#declare CN_Burnt_Yellow = rgb <213/255, 171/255, 9/255>;
#declare CN_Burple = rgb <104/255, 50/255, 227/255>;
#declare CN_Burrito = rgb <238/255, 215/255, 193/255>;
#declare CN_Burro = rgb <148/255, 119/255, 100/255>;
#declare CN_Burst_of_Gold = rgb <222/255, 179/255, 104/255>;
#declare CN_Bursting_Lemon = rgb <252/255, 226/255, 130/255>;
#declare CN_Burtuqali_Orange = rgb <255/255, 103/255, 0/255>;
#declare CN_Bush = rgb <13/255, 46/255, 28/255>;
#declare CN_Bush_Buck = rgb <162/255, 141/255, 130/255>;
#declare CN_Bush_Viper = rgb <160/255, 188/255, 208/255>;
#declare CN_Bushland_Grey = rgb <127/255, 123/255, 115/255>;
#declare CN_Bussell_Lace = rgb <229/255, 161/255, 160/255>;
#declare CN_Buster = rgb <62/255, 75/255, 105/255>;
#declare CN_Busty_Blue = rgb <51/255, 0/255, 204/255>;
#declare CN_Butter = rgb <255/255, 255/255, 129/255>;
#declare CN_Butter_Base = rgb <194/255, 138/255, 53/255>;
#declare CN_Butter_Cake = rgb <253/255, 255/255, 82/255>;
#declare CN_Butter_Caramel = rgb <166/255, 122/255, 76/255>;
#declare CN_Butter_Cookie = rgb <240/255, 228/255, 178/255>;
#declare CN_Butter_Creme = rgb <254/255, 229/255, 186/255>;
#declare CN_Butter_Cupcake = rgb <255/255, 221/255, 153/255>;
#declare CN_Butter_Fingers = rgb <252/255, 233/255, 173/255>;
#declare CN_Butter_Fudge = rgb <170/255, 102/255, 0/255>;
#declare CN_Butter_Icing = rgb <245/255, 229/255, 218/255>;
#declare CN_Butter_Lettuce = rgb <207/255, 231/255, 203/255>;
#declare CN_Butter_Nut = rgb <203/255, 165/255, 120/255>;
#declare CN_Butter_Ridge = rgb <249/255, 224/255, 151/255>;
#declare CN_Butter_Rum = rgb <195/255, 134/255, 80/255>;
#declare CN_Butter_Tart = rgb <254/255, 233/255, 159/255>;
#declare CN_Butter_Up = rgb <244/255, 224/255, 187/255>;
#declare CN_Butter_White = rgb <253/255, 222/255, 189/255>;
#declare CN_Butter_Yellow = rgb <255/255, 253/255, 116/255>;
#declare CN_Butterball = rgb <255/255, 244/255, 196/255>;
#declare CN_Butterblond = rgb <241/255, 199/255, 102/255>;
#declare CN_Butterbrot = rgb <197/255, 174/255, 124/255>;
#declare CN_Buttercream = rgb <239/255, 224/255, 205/255>;
#declare CN_Buttercream_Frosting = rgb <245/255, 237/255, 215/255>;
#declare CN_Buttercup = rgb <218/255, 148/255, 41/255>;
#declare CN_Buttercup_Yellow = rgb <227/255, 194/255, 163/255>;
#declare CN_Buttered_Popcorn = rgb <255/255, 240/255, 164/255>;
#declare CN_Buttered_Rum = rgb <157/255, 112/255, 46/255>;
#declare CN_Butterfield = rgb <247/255, 190/255, 91/255>;
#declare CN_Butterfly = rgb <202/255, 222/255, 165/255>;
#declare CN_Butterfly_Blue = rgb <32/255, 153/255, 187/255>;
#declare CN_Butterfly_Bush = rgb <104/255, 87/255, 140/255>;
#declare CN_Butterfly_Garden = rgb <144/255, 138/255, 186/255>;
#declare CN_Butterfly_Green = rgb <11/255, 104/255, 99/255>;
#declare CN_Butterfly_Wing = rgb <248/255, 207/255, 180/255>;
#declare CN_Buttermilk = rgb <255/255, 254/255, 228/255>;
#declare CN_Butternut = rgb <255/255, 161/255, 119/255>;
#declare CN_Butternut_Pizazz = rgb <229/255, 151/255, 82/255>;
#declare CN_Butternut_Wood = rgb <126/255, 111/255, 89/255>;
#declare CN_Butterscotch = rgb <253/255, 177/255, 71/255>;
#declare CN_Butterscotch_Amber = rgb <211/255, 176/255, 144/255>;
#declare CN_Butterscotch_Bliss = rgb <215/255, 173/255, 98/255>;
#declare CN_Butterscotch_Glaze = rgb <196/255, 132/255, 70/255>;
#declare CN_Butterscotch_Mousse = rgb <169/255, 125/255, 84/255>;
#declare CN_Butterscotch_Ripple = rgb <176/255, 136/255, 67/255>;
#declare CN_Butterscotch_Sundae = rgb <219/255, 180/255, 134/255>;
#declare CN_Butterscotch_Syrup = rgb <217/255, 160/255, 95/255>;
#declare CN_Butterum = rgb <198/255, 143/255, 101/255>;
#declare CN_Buttery = rgb <255/255, 194/255, 131/255>;
#declare CN_Buttery_Leather = rgb <212/255, 177/255, 133/255>;
#declare CN_Buttery_Salmon = rgb <255/255, 177/255, 154/255>;
#declare CN_Buttery_White = rgb <241/255, 235/255, 218/255>;
#declare CN_Button_Blue = rgb <36/255, 160/255, 237/255>;
#declare CN_Button_Eyes = rgb <79/255, 58/255, 50/255>;
#declare CN_Button_Mushroom = rgb <236/255, 230/255, 200/255>;
#declare CN_Buzz = rgb <240/255, 198/255, 65/255>;
#declare CN_Buzz_In = rgb <255/255, 215/255, 86/255>;
#declare CN_Buzzard = rgb <95/255, 86/255, 63/255>;
#declare CN_Buzzards_Bay = rgb <1/255, 122/255, 121/255>;
#declare CN_By_Gum = rgb <129/255, 106/255, 56/255>;
#declare CN_By_the_Bayou = rgb <0/255, 123/255, 144/255>;
#declare CN_By_The_Sea = rgb <141/255, 153/255, 158/255>;
#declare CN_Byakuroku_Green = rgb <165/255, 186/255, 147/255>;
#declare CN_Bygone = rgb <145/255, 142/255, 138/255>;
#declare CN_Bypass = rgb <182/255, 196/255, 210/255>;
#declare CN_Byron_Place = rgb <49/255, 102/255, 125/255>;
#declare CN_Byte_Blue = rgb <197/255, 220/255, 224/255>;
#declare CN_Byzantine = rgb <189/255, 51/255, 164/255>;
#declare CN_Byzantine_Blue = rgb <0/255, 108/255, 110/255>;
#declare CN_Byzantine_Night_Blue = rgb <106/255, 121/255, 247/255>;
#declare CN_Byzantium = rgb <112/255, 41/255, 99/255>;
#declare CN_C_3PO = rgb <195/255, 49/255, 64/255>;
#declare CN_Cest_La_Vie = rgb <131/255, 188/255, 229/255>;
#declare CN_C64_Blue = rgb <0/255, 58/255, 255/255>;
#declare CN_C64_NTSC = rgb <78/255, 127/255, 255/255>;
#declare CN_C64_Purple = rgb <111/255, 110/255, 209/255>;
#declare CN_Cab_Sav = rgb <74/255, 46/255, 50/255>;
#declare CN_Cabal = rgb <127/255, 100/255, 115/255>;
#declare CN_Cabana_Bay = rgb <142/255, 193/255, 192/255>;
#declare CN_Cabana_Blue = rgb <91/255, 144/255, 153/255>;
#declare CN_Cabana_Melon = rgb <200/255, 133/255, 103/255>;
#declare CN_Cabaret = rgb <205/255, 82/255, 108/255>;
#declare CN_Cabaret_Charm = rgb <124/255, 142/255, 166/255>;
#declare CN_Cabbage = rgb <135/255, 215/255, 190/255>;
#declare CN_Cabbage_Blossom_Violet = rgb <114/255, 76/255, 123/255>;
#declare CN_Cabbage_Green = rgb <128/255, 117/255, 83/255>;
#declare CN_Cabbage_Leaf = rgb <223/255, 232/255, 208/255>;
#declare CN_Cabbage_Patch = rgb <147/255, 196/255, 96/255>;
#declare CN_Cabbage_Pont = rgb <76/255, 85/255, 68/255>;
#declare CN_Cabbage_Rose = rgb <197/255, 159/255, 145/255>;
#declare CN_Cabernet = rgb <142/255, 91/255, 104/255>;
#declare CN_Cabernet_Craving = rgb <109/255, 52/255, 69/255>;
#declare CN_Cabin_Fever = rgb <94/255, 83/255, 73/255>;
#declare CN_Cabin_in_the_Woods = rgb <93/255, 77/255, 71/255>;
#declare CN_Cabo = rgb <206/255, 192/255, 170/255>;
#declare CN_Caboose = rgb <168/255, 164/255, 161/255>;
#declare CN_Cacao = rgb <107/255, 88/255, 72/255>;
#declare CN_Cachet_Cream = rgb <243/255, 217/255, 186/255>;
#declare CN_Cacodemon_Red = rgb <159/255, 0/255, 0/255>;
#declare CN_Cactus = rgb <91/255, 111/255, 85/255>;
#declare CN_Cactus_Blooms = rgb <246/255, 199/255, 157/255>;
#declare CN_Cactus_Blossom = rgb <216/255, 229/255, 221/255>;
#declare CN_Cactus_Flower = rgb <168/255, 62/255, 108/255>;
#declare CN_Cactus_Garden = rgb <123/255, 131/255, 112/255>;
#declare CN_Cactus_Green = rgb <86/255, 96/255, 61/255>;
#declare CN_Cactus_Hill = rgb <177/255, 163/255, 134/255>;
#declare CN_Cactus_Sand = rgb <156/255, 147/255, 105/255>;
#declare CN_Cactus_Spike = rgb <193/255, 224/255, 163/255>;
#declare CN_Cactus_Valley = rgb <136/255, 151/255, 107/255>;
#declare CN_Cactus_Water = rgb <208/255, 247/255, 228/255>;
#declare CN_Cadaverous = rgb <0/255, 153/255, 119/255>;
#declare CN_Caddies_Silk = rgb <62/255, 53/255, 77/255>;
#declare CN_Cadet = rgb <83/255, 104/255, 114/255>;
#declare CN_Cadet_Blue = rgb <95/255, 158/255, 160/255>;
#declare CN_Cadet_Grey = rgb <145/255, 163/255, 176/255>;
#declare CN_Cadian_Fleshtone = rgb <144/255, 118/255, 110/255>;
#declare CN_Cadillac = rgb <152/255, 73/255, 97/255>;
#declare CN_Cadillac_Coupe = rgb <192/255, 54/255, 44/255>;
#declare CN_Cadmium_Blue = rgb <10/255, 17/255, 149/255>;
#declare CN_Cadmium_Green = rgb <0/255, 107/255, 60/255>;
#declare CN_Cadmium_Orange = rgb <237/255, 135/255, 45/255>;
#declare CN_Cadmium_Purple = rgb <182/255, 12/255, 38/255>;
#declare CN_Cadmium_Red = rgb <227/255, 0/255, 34/255>;
#declare CN_Cadmium_Violet = rgb <127/255, 62/255, 152/255>;
#declare CN_Cadmium_Yellow = rgb <255/255, 246/255, 0/255>;
#declare CN_Caduceus_Gold = rgb <255/255, 238/255, 102/255>;
#declare CN_Caduceus_Staff = rgb <238/255, 221/255, 34/255>;
#declare CN_Caen_Stone = rgb <236/255, 208/255, 177/255>;
#declare CN_Cafe_Au_Lait = rgb <165/255, 124/255, 91/255>;
#declare CN_Cafe_Cream = rgb <249/255, 232/255, 211/255>;
#declare CN_Cafe_Creme = rgb <199/255, 150/255, 133/255>;
#declare CN_Cafe_de_Paris = rgb <136/255, 153/255, 68/255>;
#declare CN_Cafe_Expreso = rgb <94/255, 76/255, 72/255>;
#declare CN_Cafe_Latte = rgb <214/255, 198/255, 180/255>;
#declare CN_Cafe_Noir = rgb <75/255, 54/255, 33/255>;
#declare CN_Cafe_Ole = rgb <154/255, 127/255, 121/255>;
#declare CN_Cafe_Pink = rgb <236/255, 193/255, 194/255>;
#declare CN_Cafe_Renverse = rgb <174/255, 135/255, 116/255>;
#declare CN_Cafe_Royale = rgb <106/255, 73/255, 40/255>;
#declare CN_Caffeinated_Cinnamon = rgb <136/255, 85/255, 17/255>;
#declare CN_Caffeine = rgb <138/255, 121/255, 106/255>;
#declare CN_Caicos_Turquoise = rgb <38/255, 183/255, 181/255>;
#declare CN_Cairns = rgb <10/255, 107/255, 146/255>;
#declare CN_Cajun_Brown = rgb <95/255, 62/255, 65/255>;
#declare CN_Cajun_Red = rgb <164/255, 90/255, 74/255>;
#declare CN_Cajun_Spice = rgb <195/255, 112/255, 95/255>;
#declare CN_Cake_Batter = rgb <240/255, 237/255, 219/255>;
#declare CN_Cake_Crumbs = rgb <232/255, 212/255, 187/255>;
#declare CN_Cake_Dough = rgb <252/255, 224/255, 168/255>;
#declare CN_Cake_Frosting = rgb <249/255, 223/255, 229/255>;
#declare CN_Cake_Spice = rgb <214/255, 166/255, 114/255>;
#declare CN_Cal_Poly_Pomona_Green = rgb <30/255, 77/255, 43/255>;
#declare CN_Cala_Benirras_Blue = rgb <10/255, 194/255, 194/255>;
#declare CN_Calabash = rgb <248/255, 235/255, 151/255>;
#declare CN_Calabash_Clash = rgb <114/255, 132/255, 120/255>;
#declare CN_Calabrese = rgb <244/255, 166/255, 163/255>;
#declare CN_Calamansi = rgb <252/255, 255/255, 164/255>;
#declare CN_Calamansi_Green = rgb <196/255, 204/255, 122/255>;
#declare CN_Calc_Sinter = rgb <231/255, 225/255, 221/255>;
#declare CN_Calcareous_Sinter = rgb <221/255, 238/255, 255/255>;
#declare CN_Calcite_Blue = rgb <148/255, 178/255, 178/255>;
#declare CN_Calcite_Grey_Green = rgb <82/255, 96/255, 95/255>;
#declare CN_Calcium = rgb <242/255, 244/255, 232/255>;
#declare CN_Calcium_Rock = rgb <238/255, 233/255, 217/255>;
#declare CN_Calculus = rgb <161/255, 204/255, 177/255>;
#declare CN_Caledor_Sky = rgb <49/255, 99/255, 156/255>;
#declare CN_Calf_Skin = rgb <177/255, 170/255, 157/255>;
#declare CN_Calgar_Blue = rgb <4/255, 133/255, 209/255>;
#declare CN_Caliban_Green = rgb <0/255, 87/255, 38/255>;
#declare CN_Calico = rgb <213/255, 177/255, 133/255>;
#declare CN_Calico_Cat = rgb <196/255, 142/255, 54/255>;
#declare CN_Calico_Dress = rgb <61/255, 78/255, 103/255>;
#declare CN_Calico_Rock = rgb <156/255, 149/255, 132/255>;
#declare CN_Calico_Rose = rgb <229/255, 193/255, 179/255>;
#declare CN_Caliente = rgb <149/255, 89/255, 74/255>;
#declare CN_California = rgb <233/255, 140/255, 58/255>;
#declare CN_California_Chamois = rgb <230/255, 183/255, 108/255>;
#declare CN_California_Coral = rgb <227/255, 170/255, 148/255>;
#declare CN_California_Dreamin = rgb <147/255, 128/255, 127/255>;
#declare CN_California_Dreaming = rgb <222/255, 197/255, 105/255>;
#declare CN_California_Girl = rgb <252/255, 167/255, 22/255>;
#declare CN_California_Gold_Rush = rgb <149/255, 116/255, 63/255>;
#declare CN_California_Lilac = rgb <187/255, 197/255, 226/255>;
#declare CN_California_Peach = rgb <252/255, 190/255, 106/255>;
#declare CN_California_Poppy = rgb <168/255, 60/255, 63/255>;
#declare CN_California_Roll = rgb <160/255, 149/255, 116/255>;
#declare CN_California_Sagebrush = rgb <149/255, 153/255, 136/255>;
#declare CN_California_Stucco = rgb <197/255, 173/255, 154/255>;
#declare CN_California_Sunset = rgb <202/255, 24/255, 80/255>;
#declare CN_California_Wine = rgb <202/255, 75/255, 101/255>;
#declare CN_Calla = rgb <242/255, 223/255, 181/255>;
#declare CN_Calla_Green = rgb <106/255, 111/255, 52/255>;
#declare CN_Calla_Lily = rgb <228/255, 234/255, 237/255>;
#declare CN_Calligraphy = rgb <89/255, 99/255, 106/255>;
#declare CN_Calliope = rgb <200/255, 154/255, 141/255>;
#declare CN_Calliste_Green = rgb <117/255, 122/255, 78/255>;
#declare CN_Calm = rgb <223/255, 233/255, 230/255>;
#declare CN_Calm_Air = rgb <238/255, 210/255, 174/255>;
#declare CN_Calm_Balm = rgb <94/255, 157/255, 71/255>;
#declare CN_Calm_Breeze = rgb <233/255, 236/255, 228/255>;
#declare CN_Calm_Day = rgb <124/255, 170/255, 207/255>;
#declare CN_Calm_Interlude = rgb <167/255, 176/255, 213/255>;
#declare CN_Calm_Thoughts = rgb <229/255, 237/255, 226/255>;
#declare CN_Calm_Tint = rgb <234/255, 227/255, 233/255>;
#declare CN_Calm_Water = rgb <205/255, 217/255, 232/255>;
#declare CN_Calm_Waters = rgb <231/255, 250/255, 250/255>;
#declare CN_Calming_Effect = rgb <207/255, 211/255, 162/255>;
#declare CN_Calming_Retreat = rgb <238/255, 224/255, 209/255>;
#declare CN_Calming_Space = rgb <170/255, 183/255, 193/255>;
#declare CN_Calmness = rgb <104/255, 168/255, 149/255>;
#declare CN_Calthan_Brown = rgb <109/255, 80/255, 68/255>;
#declare CN_Calypso = rgb <61/255, 113/255, 136/255>;
#declare CN_Calypso_Berry = rgb <197/255, 58/255, 75/255>;
#declare CN_Calypso_Blue = rgb <52/255, 125/255, 139/255>;
#declare CN_Calypso_Coral = rgb <238/255, 92/255, 108/255>;
#declare CN_Calypso_Green = rgb <46/255, 95/255, 96/255>;
#declare CN_Calypso_Red = rgb <222/255, 107/255, 102/255>;
#declare CN_Camaron_Pink = rgb <254/255, 130/255, 140/255>;
#declare CN_Camarone = rgb <32/255, 105/255, 55/255>;
#declare CN_Cambridge_Blue = rgb <163/255, 193/255, 173/255>;
#declare CN_Cambridge_Leather = rgb <140/255, 99/255, 60/255>;
#declare CN_Camel = rgb <198/255, 159/255, 89/255>;
#declare CN_Camel_Brown = rgb <165/255, 102/255, 57/255>;
#declare CN_Camel_Cardinal = rgb <204/255, 153/255, 68/255>;
#declare CN_Camel_Cord = rgb <224/255, 203/255, 130/255>;
#declare CN_Camel_Fur = rgb <187/255, 102/255, 0/255>;
#declare CN_Camel_Hair = rgb <219/255, 184/255, 164/255>;
#declare CN_Camel_Hair_Coat = rgb <245/255, 183/255, 132/255>;
#declare CN_Camel_Hide = rgb <193/255, 170/255, 145/255>;
#declare CN_Camel_Red = rgb <229/255, 116/255, 59/255>;
#declare CN_Camel_Spider = rgb <175/255, 135/255, 81/255>;
#declare CN_Camel_Toe = rgb <172/255, 138/255, 42/255>;
#declare CN_Camel_Train = rgb <186/255, 174/255, 157/255>;
#declare CN_Camels_Hump = rgb <129/255, 118/255, 103/255>;
#declare CN_Camelback = rgb <197/255, 170/255, 133/255>;
#declare CN_Camelback_Mountain = rgb <211/255, 181/255, 135/255>;
#declare CN_Camellia = rgb <246/255, 116/255, 95/255>;
#declare CN_Camellia_Pink = rgb <205/255, 115/255, 157/255>;
#declare CN_Camellia_Rose = rgb <235/255, 96/255, 129/255>;
#declare CN_Camelot = rgb <128/255, 58/255, 75/255>;
#declare CN_Camembert = rgb <251/255, 243/255, 223/255>;
#declare CN_Cameo = rgb <242/255, 222/255, 188/255>;
#declare CN_Cameo_Appearance = rgb <223/255, 193/255, 195/255>;
#declare CN_Cameo_Blue = rgb <118/255, 157/255, 166/255>;
#declare CN_Cameo_Brown = rgb <192/255, 138/255, 128/255>;
#declare CN_Cameo_Green = rgb <220/255, 230/255, 229/255>;
#declare CN_Cameo_Peach = rgb <235/255, 207/255, 201/255>;
#declare CN_Cameo_Pink = rgb <239/255, 187/255, 204/255>;
#declare CN_Cameo_Role = rgb <221/255, 202/255, 175/255>;
#declare CN_Cameo_Rose = rgb <247/255, 223/255, 215/255>;
#declare CN_Cameo_Stone = rgb <235/255, 223/255, 216/255>;
#declare CN_Cameroon_Green = rgb <96/255, 116/255, 109/255>;
#declare CN_Camisole = rgb <252/255, 217/255, 199/255>;
#declare CN_Camo = rgb <127/255, 143/255, 78/255>;
#declare CN_Camo_Beige = rgb <140/255, 132/255, 117/255>;
#declare CN_Camo_Clay = rgb <116/255, 127/255, 113/255>;
#declare CN_Camo_Green = rgb <165/255, 165/255, 66/255>;
#declare CN_Camouflage = rgb <60/255, 57/255, 16/255>;
#declare CN_Camouflage_Green = rgb <75/255, 97/255, 19/255>;
#declare CN_Camouflage_Olive = rgb <162/255, 143/255, 92/255>;
#declare CN_Campanelle_Noodle = rgb <252/255, 247/255, 219/255>;
#declare CN_Campanula = rgb <50/255, 114/255, 175/255>;
#declare CN_Campanula_Purple = rgb <108/255, 109/255, 148/255>;
#declare CN_Campfire = rgb <206/255, 95/255, 56/255>;
#declare CN_Campfire_Ash = rgb <221/255, 217/255, 206/255>;
#declare CN_Campfire_Blaze = rgb <182/255, 118/255, 86/255>;
#declare CN_Campfire_Smoke = rgb <213/255, 209/255, 203/255>;
#declare CN_Campground = rgb <208/255, 165/255, 105/255>;
#declare CN_Camping_Tent = rgb <182/255, 175/255, 160/255>;
#declare CN_Camping_Trip = rgb <103/255, 120/255, 110/255>;
#declare CN_Can_Can = rgb <208/255, 138/255, 155/255>;
#declare CN_Canada_Goose_Eggs = rgb <234/255, 226/255, 221/255>;
#declare CN_Canadian_Lake = rgb <143/255, 154/255, 164/255>;
#declare CN_Canadian_Maple = rgb <202/255, 178/255, 102/255>;
#declare CN_Canadian_Pancake = rgb <237/255, 216/255, 195/255>;
#declare CN_Canadian_Pine = rgb <46/255, 123/255, 82/255>;
#declare CN_Canadian_Voodoo_Grey = rgb <184/255, 183/255, 163/255>;
#declare CN_Canal_Blue = rgb <156/255, 194/255, 197/255>;
#declare CN_Canal_Street = rgb <150/255, 146/255, 129/255>;
#declare CN_Canaletto = rgb <129/255, 140/255, 114/255>;
#declare CN_Canary = rgb <253/255, 255/255, 99/255>;
#declare CN_Canary_Diamond = rgb <255/255, 206/255, 82/255>;
#declare CN_Canary_Feather = rgb <239/255, 222/255, 117/255>;
#declare CN_Canary_Grass = rgb <208/255, 204/255, 169/255>;
#declare CN_Canary_Green = rgb <214/255, 222/255, 201/255>;
#declare CN_Canary_Island = rgb <233/255, 212/255, 169/255>;
#declare CN_Canary_Wharf = rgb <145/255, 161/255, 181/255>;
#declare CN_Canary_Yellow = rgb <255/255, 223/255, 1/255>;
#declare CN_Cancun_Sand = rgb <251/255, 237/255, 215/255>;
#declare CN_Candela = rgb <186/255, 196/255, 213/255>;
#declare CN_Candelabra = rgb <225/255, 193/255, 97/255>;
#declare CN_Candid_Blue = rgb <108/255, 195/255, 224/255>;
#declare CN_Candidate = rgb <195/255, 188/255, 144/255>;
#declare CN_Candied_Apple = rgb <185/255, 91/255, 109/255>;
#declare CN_Candied_Blueberry = rgb <51/255, 17/255, 102/255>;
#declare CN_Candied_Ginger = rgb <191/255, 163/255, 135/255>;
#declare CN_Candied_Snow = rgb <216/255, 255/255, 243/255>;
#declare CN_Candied_Yam = rgb <244/255, 147/255, 91/255>;
#declare CN_Candied_Yams = rgb <249/255, 167/255, 101/255>;
#declare CN_Candle_Bark = rgb <195/255, 189/255, 170/255>;
#declare CN_Candle_Flame = rgb <255/255, 244/255, 161/255>;
#declare CN_Candle_Glow = rgb <255/255, 232/255, 195/255>;
#declare CN_Candle_in_the_Wind = rgb <249/255, 235/255, 191/255>;
#declare CN_Candle_Light = rgb <221/255, 193/255, 166/255>;
#declare CN_Candle_Wax = rgb <242/255, 234/255, 207/255>;
#declare CN_Candle_Yellow = rgb <224/255, 155/255, 110/255>;
#declare CN_Candlelight = rgb <252/255, 217/255, 23/255>;
#declare CN_Candlelight_Dinner = rgb <206/255, 179/255, 190/255>;
#declare CN_Candlelight_Ivory = rgb <252/255, 244/255, 226/255>;
#declare CN_Candlelight_Peach = rgb <248/255, 163/255, 157/255>;
#declare CN_Candlelight_Yellow = rgb <247/255, 240/255, 199/255>;
#declare CN_Candlelit_Beige = rgb <241/255, 237/255, 224/255>;
#declare CN_Candlestick_Point = rgb <255/255, 241/255, 213/255>;
#declare CN_Candlewick = rgb <242/255, 235/255, 211/255>;
#declare CN_Candy = rgb <255/255, 155/255, 135/255>;
#declare CN_Candy_Apple_Red = rgb <255/255, 8/255, 0/255>;
#declare CN_Candy_Bar = rgb <255/255, 183/255, 213/255>;
#declare CN_Candy_Cane = rgb <247/255, 191/255, 194/255>;
#declare CN_Candy_Coated = rgb <239/255, 159/255, 170/255>;
#declare CN_Candy_Corn = rgb <252/255, 252/255, 93/255>;
#declare CN_Candy_Drop = rgb <194/255, 93/255, 106/255>;
#declare CN_Candy_Floss = rgb <232/255, 167/255, 226/255>;
#declare CN_Candy_Grape_Fizz = rgb <119/255, 85/255, 238/255>;
#declare CN_Candy_Grass = rgb <51/255, 170/255, 0/255>;
#declare CN_Candy_Green = rgb <51/255, 204/255, 0/255>;
#declare CN_Candy_Heart_Pink = rgb <245/255, 162/255, 161/255>;
#declare CN_Candy_Mix = rgb <243/255, 223/255, 227/255>;
#declare CN_Candy_Pink = rgb <255/255, 99/255, 233/255>;
#declare CN_Candy_Tuft = rgb <241/255, 215/255, 228/255>;
#declare CN_Candy_Violet = rgb <137/255, 93/255, 139/255>;
#declare CN_Candyman = rgb <255/255, 158/255, 118/255>;
#declare CN_Candytuft = rgb <237/255, 201/255, 216/255>;
#declare CN_Cane_Sugar = rgb <227/255, 185/255, 130/255>;
#declare CN_Cane_Sugar_Glaze = rgb <221/255, 187/255, 153/255>;
#declare CN_Cane_Toad = rgb <151/255, 112/255, 66/255>;
#declare CN_Caneel_Bay = rgb <0/255, 132/255, 159/255>;
#declare CN_Canewood = rgb <215/255, 182/255, 154/255>;
#declare CN_Cannery_Park = rgb <188/255, 176/255, 158/255>;
#declare CN_Cannoli_Cream = rgb <240/255, 239/255, 226/255>;
#declare CN_Cannon_Ball = rgb <72/255, 67/255, 53/255>;
#declare CN_Cannon_Barrel = rgb <60/255, 65/255, 66/255>;
#declare CN_Cannon_Black = rgb <37/255, 23/255, 6/255>;
#declare CN_Cannon_Grey = rgb <100/255, 108/255, 100/255>;
#declare CN_Cannon_Pink = rgb <142/255, 81/255, 100/255>;
#declare CN_Canoe = rgb <221/255, 196/255, 158/255>;
#declare CN_Canoe_Blue = rgb <29/255, 86/255, 113/255>;
#declare CN_Canopy = rgb <114/255, 143/255, 2/255>;
#declare CN_Cantaloupe = rgb <255/255, 212/255, 121/255>;
#declare CN_Cantaloupe_Slice = rgb <254/255, 176/255, 121/255>;
#declare CN_Cantankerous_Coyote = rgb <172/255, 141/255, 116/255>;
#declare CN_Canteen = rgb <94/255, 83/255, 71/255>;
#declare CN_Canter_Peach = rgb <246/255, 211/255, 187/255>;
#declare CN_Cantera = rgb <206/255, 197/255, 175/255>;
#declare CN_Canterbury_Bells = rgb <185/255, 195/255, 230/255>;
#declare CN_Canterbury_Cathedral = rgb <178/255, 171/255, 148/255>;
#declare CN_Canton = rgb <109/255, 162/255, 158/255>;
#declare CN_Canton_Jade = rgb <186/255, 231/255, 199/255>;
#declare CN_Canvas = rgb <187/255, 136/255, 85/255>;
#declare CN_Canvas_Cloth = rgb <230/255, 223/255, 210/255>;
#declare CN_Canvas_Luggage = rgb <226/255, 215/255, 198/255>;
#declare CN_Canvas_Satchel = rgb <204/255, 184/255, 141/255>;
#declare CN_Canvas_Tan = rgb <221/255, 214/255, 198/255>;
#declare CN_Canyon_Blue = rgb <96/255, 123/255, 142/255>;
#declare CN_Canyon_Clay = rgb <206/255, 132/255, 119/255>;
#declare CN_Canyon_Cliffs = rgb <236/255, 227/255, 209/255>;
#declare CN_Canyon_Cloud = rgb <174/255, 175/255, 187/255>;
#declare CN_Canyon_Dusk = rgb <221/255, 195/255, 183/255>;
#declare CN_Canyon_Echo = rgb <229/255, 225/255, 204/255>;
#declare CN_Canyon_Falls = rgb <151/255, 152/255, 127/255>;
#declare CN_Canyon_Iris = rgb <73/255, 84/255, 143/255>;
#declare CN_Canyon_Mist = rgb <167/255, 164/255, 192/255>;
#declare CN_Canyon_Peach = rgb <238/255, 218/255, 203/255>;
#declare CN_Canyon_Rose = rgb <175/255, 108/255, 103/255>;
#declare CN_Canyon_Sand = rgb <242/255, 214/255, 170/255>;
#declare CN_Canyon_Stone = rgb <147/255, 98/255, 91/255>;
#declare CN_Canyon_Sunset = rgb <225/255, 146/255, 122/255>;
#declare CN_Canyon_Trail = rgb <214/255, 184/255, 169/255>;
#declare CN_Canyon_Verde = rgb <138/255, 126/255, 92/255>;
#declare CN_Canyon_View = rgb <195/255, 179/255, 159/255>;
#declare CN_Canyon_Wind = rgb <227/255, 229/255, 223/255>;
#declare CN_Canyonville = rgb <245/255, 222/255, 209/255>;
#declare CN_Cao_Lu_Grass = rgb <31/255, 167/255, 116/255>;
#declare CN_Cape_Cod = rgb <78/255, 85/255, 82/255>;
#declare CN_Cape_Cod_Bay = rgb <85/255, 112/255, 128/255>;
#declare CN_Cape_Cod_Blue = rgb <145/255, 162/255, 166/255>;
#declare CN_Cape_Honey = rgb <254/255, 224/255, 165/255>;
#declare CN_Cape_Hope = rgb <216/255, 214/255, 215/255>;
#declare CN_Cape_Jasmine = rgb <255/255, 185/255, 90/255>;
#declare CN_Cape_Lee = rgb <80/255, 129/255, 139/255>;
#declare CN_Cape_Palliser = rgb <117/255, 72/255, 47/255>;
#declare CN_Cape_Pond = rgb <0/255, 146/255, 173/255>;
#declare CN_Cape_Verde = rgb <1/255, 85/255, 79/255>;
#declare CN_Capella = rgb <217/255, 206/255, 210/255>;
#declare CN_Caper = rgb <175/255, 193/255, 130/255>;
#declare CN_Caper_Green = rgb <132/255, 118/255, 64/255>;
#declare CN_Capercaillie_Mauve = rgb <120/255, 114/255, 140/255>;
#declare CN_Capers = rgb <105/255, 94/255, 75/255>;
#declare CN_Capetown_Cream = rgb <252/255, 235/255, 206/255>;
#declare CN_Capital_Blue = rgb <26/255, 65/255, 87/255>;
#declare CN_Capital_Grains = rgb <219/255, 208/255, 168/255>;
#declare CN_Capital_Yellow = rgb <230/255, 186/255, 69/255>;
#declare CN_Capitalino_Cactus = rgb <0/255, 143/255, 76/255>;
#declare CN_Capocollo = rgb <217/255, 84/255, 77/255>;
#declare CN_Caponata = rgb <130/255, 42/255, 16/255>;
#declare CN_Cappuccino = rgb <99/255, 63/255, 51/255>;
#declare CN_Cappuccino_Bombe = rgb <180/255, 137/255, 125/255>;
#declare CN_Cappuccino_Froth = rgb <200/255, 176/255, 137/255>;
#declare CN_Capri = rgb <0/255, 191/255, 255/255>;
#declare CN_Capri_Breeze = rgb <0/255, 135/255, 153/255>;
#declare CN_Capri_Cream = rgb <241/255, 240/255, 214/255>;
#declare CN_Capri_Fashion_Pink = rgb <172/255, 131/255, 156/255>;
#declare CN_Capri_Isle = rgb <79/255, 88/255, 85/255>;
#declare CN_Capri_Water_Blue = rgb <171/255, 226/255, 214/255>;
#declare CN_Capricious_Purple = rgb <187/255, 0/255, 221/255>;
#declare CN_Caps = rgb <126/255, 122/255, 117/255>;
#declare CN_Capsella = rgb <109/255, 138/255, 116/255>;
#declare CN_Capsicum_Red = rgb <118/255, 57/255, 46/255>;
#declare CN_Capstan = rgb <0/255, 126/255, 176/255>;
#declare CN_Captain_Blue = rgb <0/255, 81/255, 113/255>;
#declare CN_Captain_Kirk = rgb <155/255, 135/255, 12/255>;
#declare CN_Captain_Nemo = rgb <130/255, 128/255, 128/255>;
#declare CN_Captains_Blue = rgb <85/255, 112/255, 136/255>;
#declare CN_Captivated = rgb <148/255, 124/255, 174/255>;
#declare CN_Captivating_Cream = rgb <244/255, 217/255, 177/255>;
#declare CN_Captive = rgb <0/255, 91/255, 106/255>;
#declare CN_Capture = rgb <44/255, 186/255, 163/255>;
#declare CN_Capulet_Olive = rgb <101/255, 99/255, 68/255>;
#declare CN_Caput_Mortuum = rgb <89/255, 39/255, 32/255>;
#declare CN_Caput_Mortuum_Grey_Red = rgb <111/255, 88/255, 91/255>;
#declare CN_Carafe = rgb <93/255, 71/255, 58/255>;
#declare CN_Caraibe = rgb <121/255, 95/255, 77/255>;
#declare CN_Carambar = rgb <85/255, 34/255, 51/255>;
#declare CN_Carambola = rgb <239/255, 235/255, 209/255>;
#declare CN_Caramel = rgb <175/255, 111/255, 9/255>;
#declare CN_Caramel_Apple = rgb <184/255, 122/255, 89/255>;
#declare CN_Caramel_Bar = rgb <204/255, 134/255, 84/255>;
#declare CN_Caramel_Brown = rgb <177/255, 135/255, 117/255>;
#declare CN_Caramel_Cafe = rgb <134/255, 76/255, 36/255>;
#declare CN_Caramel_Candy = rgb <179/255, 113/255, 93/255>;
#declare CN_Caramel_Cloud = rgb <212/255, 175/255, 133/255>;
#declare CN_Caramel_Coating = rgb <187/255, 119/255, 17/255>;
#declare CN_Caramel_Cream = rgb <244/255, 186/255, 148/255>;
#declare CN_Caramel_Crumb = rgb <195/255, 147/255, 85/255>;
#declare CN_Caramel_Cupcake = rgb <185/255, 140/255, 93/255>;
#declare CN_Caramel_Finish = rgb <255/255, 213/255, 154/255>;
#declare CN_Caramel_Ice = rgb <238/255, 201/255, 170/255>;
#declare CN_Caramel_Infused = rgb <204/255, 119/255, 85/255>;
#declare CN_Caramel_Kiss = rgb <176/255, 138/255, 97/255>;
#declare CN_Caramel_Latte = rgb <140/255, 99/255, 66/255>;
#declare CN_Caramel_Macchiato = rgb <197/255, 141/255, 75/255>;
#declare CN_Caramel_Milk = rgb <221/255, 194/255, 131/255>;
#declare CN_Caramel_Powder = rgb <238/255, 187/255, 153/255>;
#declare CN_Caramel_Sauce = rgb <179/255, 128/255, 77/255>;
#declare CN_Caramel_Sundae = rgb <169/255, 135/255, 106/255>;
#declare CN_Caramel_Swirl = rgb <143/255, 106/255, 79/255>;
#declare CN_Caramelized = rgb <186/255, 148/255, 127/255>;
#declare CN_Caramelized_Orange = rgb <239/255, 146/255, 74/255>;
#declare CN_Caramelized_Pears = rgb <231/255, 213/255, 173/255>;
#declare CN_Caramelized_Pecan = rgb <161/255, 123/255, 77/255>;
#declare CN_Caramelized_Walnut = rgb <110/255, 86/255, 74/255>;
#declare CN_Caramelo_Dulce = rgb <214/255, 158/255, 107/255>;
#declare CN_Caraquenian_Crimson = rgb <156/255, 0/255, 19/255>;
#declare CN_Caravel_Brown = rgb <140/255, 110/255, 84/255>;
#declare CN_Caraway = rgb <161/255, 148/255, 115/255>;
#declare CN_Caraway_Brown = rgb <109/255, 86/255, 60/255>;
#declare CN_Caraway_Seeds = rgb <223/255, 213/255, 187/255>;
#declare CN_Carbon = rgb <51/255, 51/255, 51/255>;
#declare CN_Carbon_Copy = rgb <84/255, 85/255, 84/255>;
#declare CN_Carbon_Dating = rgb <86/255, 91/255, 88/255>;
#declare CN_Carbon_Footprint = rgb <123/255, 128/255, 139/255>;
#declare CN_Card_Table_Green = rgb <0/255, 81/255, 44/255>;
#declare CN_Cardamom = rgb <170/255, 170/255, 119/255>;
#declare CN_Cardamom_Green = rgb <152/255, 144/255, 87/255>;
#declare CN_Cardamom_Spice = rgb <131/255, 113/255, 101/255>;
#declare CN_Cardboard = rgb <193/255, 154/255, 108/255>;
#declare CN_Cardin_Green = rgb <27/255, 52/255, 39/255>;
#declare CN_Cardinal = rgb <196/255, 30/255, 58/255>;
#declare CN_Cardinal_Mauve = rgb <44/255, 40/255, 76/255>;
#declare CN_Cardinal_Pink = rgb <140/255, 5/255, 94/255>;
#declare CN_Cardinal_Red = rgb <155/255, 54/255, 94/255>;
#declare CN_Cardoon = rgb <154/255, 174/255, 140/255>;
#declare CN_Cardueline_Finch = rgb <149/255, 123/255, 56/255>;
#declare CN_Carefree = rgb <220/255, 233/255, 233/255>;
#declare CN_Carefree_Sky = rgb <166/255, 205/255, 222/255>;
#declare CN_Careys_Pink = rgb <201/255, 154/255, 160/255>;
#declare CN_Cargo = rgb <143/255, 117/255, 91/255>;
#declare CN_Cargo_Green = rgb <200/255, 197/255, 167/255>;
#declare CN_Cargo_Pants = rgb <205/255, 196/255, 174/255>;
#declare CN_Cargo_River = rgb <207/255, 205/255, 187/255>;
#declare CN_Caribbean_Blue = rgb <26/255, 193/255, 221/255>;
#declare CN_Caribbean_Coast = rgb <147/255, 197/255, 221/255>;
#declare CN_Caribbean_Coral = rgb <192/255, 119/255, 97/255>;
#declare CN_Caribbean_Cruise = rgb <63/255, 157/255, 169/255>;
#declare CN_Caribbean_Current = rgb <0/255, 110/255, 110/255>;
#declare CN_Caribbean_Green = rgb <0/255, 204/255, 153/255>;
#declare CN_Caribbean_Mist = rgb <202/255, 222/255, 234/255>;
#declare CN_Caribbean_Pleasure = rgb <213/255, 220/255, 206/255>;
#declare CN_Caribbean_Sea = rgb <0/255, 129/255, 157/255>;
#declare CN_Caribbean_Sky = rgb <129/255, 158/255, 203/255>;
#declare CN_Caribbean_Splash = rgb <0/255, 105/255, 124/255>;
#declare CN_Caribbean_Sunrise = rgb <245/255, 218/255, 170/255>;
#declare CN_Caribbean_Swim = rgb <18/255, 99/255, 102/255>;
#declare CN_Caribbean_Turquoise = rgb <0/255, 157/255, 148/255>;
#declare CN_Caribe = rgb <20/255, 125/255, 135/255>;
#declare CN_Caribou = rgb <129/255, 109/255, 94/255>;
#declare CN_Caribou_Herd = rgb <205/255, 165/255, 99/255>;
#declare CN_Carissima = rgb <230/255, 128/255, 149/255>;
#declare CN_Carla = rgb <245/255, 249/255, 203/255>;
#declare CN_Carleys_Rose = rgb <168/255, 115/255, 118/255>;
#declare CN_Carlisle = rgb <69/255, 134/255, 124/255>;
#declare CN_Carmel = rgb <145/255, 95/255, 61/255>;
#declare CN_Carmel_Mission = rgb <146/255, 127/255, 118/255>;
#declare CN_Carmel_Woods = rgb <141/255, 107/255, 59/255>;
#declare CN_Carmelite = rgb <185/255, 137/255, 112/255>;
#declare CN_Carmen = rgb <124/255, 56/255, 63/255>;
#declare CN_Carmen_Miranda = rgb <144/255, 62/255, 47/255>;
#declare CN_Carmim = rgb <161/255, 57/255, 5/255>;
#declare CN_Carmine = rgb <157/255, 2/255, 22/255>;
#declare CN_Carmine_Carnation = rgb <173/255, 75/255, 83/255>;
#declare CN_Carmine_Pink = rgb <235/255, 76/255, 66/255>;
#declare CN_Carmine_Red = rgb <255/255, 0/255, 56/255>;
#declare CN_Carmine_Rose = rgb <227/255, 91/255, 143/255>;
#declare CN_Carmoisine = rgb <179/255, 28/255, 69/255>;
#declare CN_Carnaby_Tan = rgb <91/255, 58/255, 36/255>;
#declare CN_Carnage_Red = rgb <148/255, 0/255, 8/255>;
#declare CN_Carnal_Brown = rgb <187/255, 136/255, 102/255>;
#declare CN_Carnal_Pink = rgb <239/255, 156/255, 181/255>;
#declare CN_Carnation = rgb <253/255, 121/255, 143/255>;
#declare CN_Carnation_Bloom = rgb <249/255, 192/255, 190/255>;
#declare CN_Carnation_Bouquet = rgb <245/255, 192/255, 208/255>;
#declare CN_Carnation_Coral = rgb <237/255, 185/255, 173/255>;
#declare CN_Carnation_Festival = rgb <145/255, 88/255, 112/255>;
#declare CN_Carnation_Pink = rgb <255/255, 127/255, 167/255>;
#declare CN_Carnation_Rose = rgb <206/255, 148/255, 194/255>;
#declare CN_Carnelian = rgb <179/255, 27/255, 27/255>;
#declare CN_Carnival = rgb <235/255, 136/255, 44/255>;
#declare CN_Carnival_Night = rgb <0/255, 110/255, 122/255>;
#declare CN_Carnivore = rgb <153/255, 17/255, 17/255>;
#declare CN_Caro = rgb <255/255, 202/255, 195/255>;
#declare CN_Carob_Brown = rgb <133/255, 92/255, 76/255>;
#declare CN_Carob_Chip = rgb <90/255, 72/255, 75/255>;
#declare CN_Carol = rgb <51/255, 141/255, 174/255>;
#declare CN_Carols_Purr = rgb <119/255, 161/255, 53/255>;
#declare CN_Carolina = rgb <203/255, 239/255, 203/255>;
#declare CN_Carolina_Blue = rgb <138/255, 184/255, 254/255>;
#declare CN_Carolina_Green = rgb <0/255, 139/255, 109/255>;
#declare CN_Carolina_Parakeet = rgb <216/255, 223/255, 128/255>;
#declare CN_Carolina_Reaper = rgb <255/255, 21/255, 0/255>;
#declare CN_Carona = rgb <251/255, 165/255, 46/255>;
#declare CN_Carotene = rgb <253/255, 183/255, 147/255>;
#declare CN_Carousel_Pink = rgb <248/255, 219/255, 224/255>;
#declare CN_Carpaccio = rgb <227/255, 66/255, 52/255>;
#declare CN_Carpe_Diem = rgb <144/255, 87/255, 85/255>;
#declare CN_Carpet_Moss = rgb <0/255, 170/255, 51/255>;
#declare CN_Carrageen_Moss = rgb <144/255, 93/255, 54/255>;
#declare CN_Carrara = rgb <238/255, 235/255, 228/255>;
#declare CN_Carrara_Marble = rgb <232/255, 231/255, 215/255>;
#declare CN_Carriage = rgb <108/255, 99/255, 88/255>;
#declare CN_Carriage_Door = rgb <149/255, 141/255, 121/255>;
#declare CN_Carriage_Green = rgb <37/255, 77/255, 72/255>;
#declare CN_Carriage_Red = rgb <140/255, 64/255, 61/255>;
#declare CN_Carriage_Ride = rgb <138/255, 141/255, 196/255>;
#declare CN_Carriage_Stone = rgb <126/255, 114/255, 101/255>;
#declare CN_Carriage_Yellow = rgb <255/255, 183/255, 86/255>;
#declare CN_Carrier_Pigeon_Blue = rgb <136/255, 147/255, 152/255>;
#declare CN_Carroburg_Crimson = rgb <168/255, 42/255, 112/255>;
#declare CN_Carrot = rgb <253/255, 111/255, 59/255>;
#declare CN_Carrot_Cake = rgb <191/255, 111/255, 49/255>;
#declare CN_Carrot_Curl = rgb <254/255, 140/255, 24/255>;
#declare CN_Carrot_Flower = rgb <203/255, 211/255, 193/255>;
#declare CN_Carrot_Orange = rgb <237/255, 145/255, 33/255>;
#declare CN_Carrot_Stick = rgb <223/255, 120/255, 54/255>;
#declare CN_Carte_Blanche = rgb <238/255, 238/255, 255/255>;
#declare CN_Carters_Scroll = rgb <64/255, 89/255, 120/255>;
#declare CN_Carton = rgb <187/255, 158/255, 126/255>;
#declare CN_Cartwheel = rgb <102/255, 85/255, 55/255>;
#declare CN_Carved_Wood = rgb <147/255, 122/255, 98/255>;
#declare CN_Carving_Party = rgb <240/255, 195/255, 159/255>;
#declare CN_Casa_Blanca = rgb <244/255, 236/255, 216/255>;
#declare CN_Casa_De_Oro = rgb <207/255, 104/255, 55/255>;
#declare CN_Casa_del_Mar = rgb <202/255, 207/255, 230/255>;
#declare CN_Casa_Talec = rgb <196/255, 156/255, 165/255>;
#declare CN_Casa_Verde = rgb <171/255, 183/255, 144/255>;
#declare CN_Casablanca = rgb <240/255, 178/255, 83/255>;
#declare CN_Casal = rgb <63/255, 84/255, 90/255>;
#declare CN_Casandora_Yellow = rgb <254/255, 206/255, 90/255>;
#declare CN_Casandra = rgb <124/255, 69/255, 73/255>;
#declare CN_Cascade = rgb <212/255, 237/255, 230/255>;
#declare CN_Cascade_Beige = rgb <231/255, 219/255, 202/255>;
#declare CN_Cascade_Green = rgb <161/255, 194/255, 185/255>;
#declare CN_Cascade_Tour = rgb <105/255, 127/255, 142/255>;
#declare CN_Cascade_White = rgb <236/255, 242/255, 236/255>;
#declare CN_Cascades = rgb <39/255, 62/255, 62/255>;
#declare CN_Cascading_White = rgb <247/255, 245/255, 246/255>;
#declare CN_Cascara = rgb <238/255, 68/255, 51/255>;
#declare CN_Cashew = rgb <164/255, 113/255, 73/255>;
#declare CN_Cashew_Cheese = rgb <252/255, 249/255, 189/255>;
#declare CN_Cashew_Nut = rgb <237/255, 204/255, 179/255>;
#declare CN_Cashmere = rgb <209/255, 179/255, 153/255>;
#declare CN_Cashmere_Blue = rgb <165/255, 184/255, 208/255>;
#declare CN_Cashmere_Rose = rgb <206/255, 135/255, 159/255>;
#declare CN_Cashmere_Sweater = rgb <254/255, 242/255, 210/255>;
#declare CN_Casket = rgb <164/255, 145/255, 134/255>;
#declare CN_Casper = rgb <170/255, 181/255, 184/255>;
#declare CN_Caspian_Sea = rgb <79/255, 111/255, 145/255>;
#declare CN_Caspian_Tide = rgb <174/255, 199/255, 219/255>;
#declare CN_Cassandras_Curse = rgb <187/255, 119/255, 0/255>;
#declare CN_Cassava_Cake = rgb <231/255, 192/255, 132/255>;
#declare CN_Cassia_Buds = rgb <224/255, 205/255, 218/255>;
#declare CN_Cassiopeia = rgb <174/255, 208/255, 201/255>;
#declare CN_Cassiterite_Brown = rgb <98/255, 60/255, 31/255>;
#declare CN_Cast_Iron = rgb <100/255, 100/255, 90/255>;
#declare CN_Castaway = rgb <109/255, 186/255, 192/255>;
#declare CN_Castaway_Beach = rgb <208/255, 193/255, 159/255>;
#declare CN_Castaway_Cove = rgb <122/255, 146/255, 145/255>;
#declare CN_Castaway_Lagoon = rgb <96/255, 115/255, 116/255>;
#declare CN_Castellan_Green = rgb <69/255, 84/255, 64/255>;
#declare CN_Castellina = rgb <162/255, 112/255, 64/255>;
#declare CN_Caster_Sugar = rgb <255/255, 255/255, 232/255>;
#declare CN_Castilian_Pink = rgb <212/255, 179/255, 170/255>;
#declare CN_Casting_Sea = rgb <69/255, 134/255, 199/255>;
#declare CN_Casting_Shadow = rgb <157/255, 167/255, 160/255>;
#declare CN_Castle_Beige = rgb <224/255, 213/255, 202/255>;
#declare CN_Castle_Hill = rgb <149/255, 130/255, 123/255>;
#declare CN_Castle_In_The_Clouds = rgb <239/255, 220/255, 202/255>;
#declare CN_Castle_in_the_Sky = rgb <209/255, 234/255, 237/255>;
#declare CN_Castle_Mist = rgb <189/255, 174/255, 183/255>;
#declare CN_Castle_Moat = rgb <139/255, 107/255, 71/255>;
#declare CN_Castle_Path = rgb <197/255, 186/255, 170/255>;
#declare CN_Castle_Ridge = rgb <234/255, 222/255, 199/255>;
#declare CN_Castle_Stone = rgb <82/255, 87/255, 70/255>;
#declare CN_Castle_Wall = rgb <200/255, 193/255, 171/255>;
#declare CN_Castlegate = rgb <160/255, 165/255, 165/255>;
#declare CN_Castlerock = rgb <95/255, 94/255, 98/255>;
#declare CN_Castleton_Green = rgb <0/255, 86/255, 79/255>;
#declare CN_Castlevania_Heart = rgb <168/255, 0/255, 32/255>;
#declare CN_Castor_Grey = rgb <100/255, 103/255, 98/255>;
#declare CN_Castro = rgb <68/255, 35/255, 47/255>;
#declare CN_Casual_Blue = rgb <73/255, 128/255, 144/255>;
#declare CN_Casual_Day = rgb <149/255, 186/255, 194/255>;
#declare CN_Casual_Elegance = rgb <223/255, 213/255, 200/255>;
#declare CN_Casual_Grey = rgb <160/255, 157/255, 152/255>;
#declare CN_Casual_Khaki = rgb <211/255, 197/255, 175/255>;
#declare CN_Cat_Person = rgb <99/255, 109/255, 112/255>;
#declare CN_Cats_Eye_Marble = rgb <214/255, 167/255, 93/255>;
#declare CN_Cats_Purr = rgb <0/255, 113/255, 160/255>;
#declare CN_Catachan_Green = rgb <71/255, 87/255, 66/255>;
#declare CN_Catacomb_Bone = rgb <226/255, 220/255, 204/255>;
#declare CN_Catacomb_Walls = rgb <219/255, 215/255, 208/255>;
#declare CN_Catalan = rgb <66/255, 147/255, 149/255>;
#declare CN_Catalina = rgb <114/255, 164/255, 159/255>;
#declare CN_Catalina_Blue = rgb <6/255, 42/255, 120/255>;
#declare CN_Catalina_Coast = rgb <92/255, 120/255, 132/255>;
#declare CN_Catalina_Green = rgb <133/255, 148/255, 117/255>;
#declare CN_Catalina_Tile = rgb <239/255, 172/255, 115/255>;
#declare CN_Catarina_Green = rgb <144/255, 196/255, 180/255>;
#declare CN_Catawba = rgb <112/255, 54/255, 66/255>;
#declare CN_Catawba_Grape = rgb <93/255, 60/255, 67/255>;
#declare CN_Catch_The_Wave = rgb <181/255, 220/255, 216/255>;
#declare CN_Caterpillar = rgb <102/255, 165/255, 69/255>;
#declare CN_Caterpillar_Green = rgb <20/255, 107/255, 71/255>;
#declare CN_Catfish = rgb <101/255, 125/255, 130/255>;
#declare CN_Cathay_Spice = rgb <153/255, 100/255, 44/255>;
#declare CN_Cathedral = rgb <172/255, 170/255, 167/255>;
#declare CN_Cathedral_Glass = rgb <122/255, 153/255, 156/255>;
#declare CN_Cathedral_Grey = rgb <171/255, 169/255, 167/255>;
#declare CN_Cathedral_Stone = rgb <128/255, 121/255, 110/255>;
#declare CN_Cathode_Green = rgb <0/255, 255/255, 85/255>;
#declare CN_Catkin_Yellow = rgb <204/255, 168/255, 0/255>;
#declare CN_Catmint = rgb <201/255, 168/255, 206/255>;
#declare CN_Catnap = rgb <159/255, 195/255, 172/255>;
#declare CN_Catnip = rgb <128/255, 170/255, 149/255>;
#declare CN_Catnip_Wood = rgb <111/255, 96/255, 102/255>;
#declare CN_Catskill_Brown = rgb <89/255, 84/255, 82/255>;
#declare CN_Catskill_White = rgb <224/255, 228/255, 220/255>;
#declare CN_Cattail_Brown = rgb <145/255, 117/255, 70/255>;
#declare CN_Cattail_Red = rgb <182/255, 73/255, 37/255>;
#declare CN_Catwalk = rgb <74/255, 70/255, 73/255>;
#declare CN_Caulerpa_Lentillifera = rgb <89/255, 156/255, 153/255>;
#declare CN_Cauliflower = rgb <235/255, 229/255, 208/255>;
#declare CN_Cauliflower_Cream = rgb <242/255, 228/255, 199/255>;
#declare CN_Caustic_Green = rgb <17/255, 221/255, 0/255>;
#declare CN_Cautious_Blue = rgb <213/255, 221/255, 229/255>;
#declare CN_Cautious_Grey = rgb <223/255, 216/255, 217/255>;
#declare CN_Cautious_Jade = rgb <218/255, 228/255, 222/255>;
#declare CN_Cavalry = rgb <63/255, 76/255, 90/255>;
#declare CN_Cavalry_Brown = rgb <153/255, 0/255, 3/255>;
#declare CN_Cavan = rgb <220/255, 226/255, 206/255>;
#declare CN_Cave_Lake = rgb <82/255, 183/255, 198/255>;
#declare CN_Cave_of_the_Winds = rgb <134/255, 115/255, 110/255>;
#declare CN_Cave_Painting = rgb <170/255, 17/255, 0/255>;
#declare CN_Cave_Pearl = rgb <214/255, 229/255, 226/255>;
#declare CN_Caveman = rgb <98/255, 92/255, 88/255>;
#declare CN_Cavendish = rgb <254/255, 210/255, 0/255>;
#declare CN_Cavern_Clay = rgb <182/255, 153/255, 129/255>;
#declare CN_Cavern_Echo = rgb <206/255, 195/255, 179/255>;
#declare CN_Cavern_Moss = rgb <146/255, 152/255, 125/255>;
#declare CN_Cavern_Pink = rgb <224/255, 184/255, 177/255>;
#declare CN_Cavern_Sand = rgb <148/255, 112/255, 84/255>;
#declare CN_Cavernous = rgb <81/255, 82/255, 82/255>;
#declare CN_Caviar = rgb <41/255, 42/255, 45/255>;
#declare CN_Caviar_Black = rgb <83/255, 62/255, 57/255>;
#declare CN_Caviar_Couture = rgb <119/255, 34/255, 68/255>;
#declare CN_Cavolo_Nero = rgb <114/255, 147/255, 158/255>;
#declare CN_Cay = rgb <166/255, 208/255, 214/255>;
#declare CN_Cayenne = rgb <148/255, 17/255, 0/255>;
#declare CN_Cayman_Bay = rgb <82/255, 121/255, 141/255>;
#declare CN_Cayman_Green = rgb <73/255, 90/255, 68/255>;
#declare CN_Ce_Soir = rgb <146/255, 113/255, 167/255>;
#declare CN_Cedar = rgb <70/255, 52/255, 48/255>;
#declare CN_Cedar_Chest = rgb <201/255, 90/255, 73/255>;
#declare CN_Cedar_Forest = rgb <120/255, 128/255, 120/255>;
#declare CN_Cedar_Glen = rgb <104/255, 102/255, 71/255>;
#declare CN_Cedar_Green = rgb <94/255, 103/255, 55/255>;
#declare CN_Cedar_Grove = rgb <191/255, 105/255, 85/255>;
#declare CN_Cedar_Plank = rgb <139/255, 120/255, 111/255>;
#declare CN_Cedar_Plank_Salmon = rgb <169/255, 106/255, 80/255>;
#declare CN_Cedar_Ridge = rgb <155/255, 102/255, 99/255>;
#declare CN_Cedar_Staff = rgb <145/255, 73/255, 62/255>;
#declare CN_Cedar_Wood = rgb <161/255, 101/255, 91/255>;
#declare CN_Cedar_Wood_Finish = rgb <113/255, 26/255, 0/255>;
#declare CN_Cedarville = rgb <221/255, 168/255, 150/255>;
#declare CN_Ceil = rgb <146/255, 161/255, 207/255>;
#declare CN_Ceiling_Bright_White = rgb <233/255, 235/255, 231/255>;
#declare CN_Celadon = rgb <172/255, 225/255, 175/255>;
#declare CN_Celadon_Blue = rgb <0/255, 123/255, 167/255>;
#declare CN_Celadon_Glaze = rgb <204/255, 212/255, 203/255>;
#declare CN_Celadon_Green = rgb <47/255, 132/255, 124/255>;
#declare CN_Celadon_Porcelain = rgb <126/255, 190/255, 165/255>;
#declare CN_Celadon_Sorbet = rgb <177/255, 218/255, 198/255>;
#declare CN_Celadon_Tint = rgb <203/255, 206/255, 190/255>;
#declare CN_Celandine = rgb <235/255, 223/255, 103/255>;
#declare CN_Celandine_Green = rgb <184/255, 191/255, 175/255>;
#declare CN_Celeb_City = rgb <157/255, 134/255, 173/255>;
#declare CN_Celebration = rgb <230/255, 193/255, 122/255>;
#declare CN_Celebration_Blue = rgb <0/255, 139/255, 196/255>;
#declare CN_Celery = rgb <180/255, 192/255, 76/255>;
#declare CN_Celery_Bunch = rgb <212/255, 224/255, 179/255>;
#declare CN_Celery_Green = rgb <197/255, 204/255, 123/255>;
#declare CN_Celery_Ice = rgb <234/255, 235/255, 209/255>;
#declare CN_Celery_Mousse = rgb <193/255, 253/255, 149/255>;
#declare CN_Celery_Powder = rgb <197/255, 189/255, 165/255>;
#declare CN_Celery_Satin = rgb <208/255, 216/255, 190/255>;
#declare CN_Celery_Sprig = rgb <158/255, 214/255, 134/255>;
#declare CN_Celery_Stick = rgb <202/255, 237/255, 208/255>;
#declare CN_Celery_Victor = rgb <204/255, 238/255, 194/255>;
#declare CN_Celery_White = rgb <219/255, 217/255, 205/255>;
#declare CN_Celeste = rgb <178/255, 255/255, 255/255>;
#declare CN_Celeste_Blue = rgb <64/255, 99/255, 116/255>;
#declare CN_Celestial = rgb <0/255, 99/255, 128/255>;
#declare CN_Celestial_Alien = rgb <17/255, 204/255, 0/255>;
#declare CN_Celestial_Blue = rgb <44/255, 77/255, 105/255>;
#declare CN_Celestial_Coral = rgb <221/255, 68/255, 85/255>;
#declare CN_Celestial_Dragon = rgb <153/255, 34/255, 102/255>;
#declare CN_Celestial_Glow = rgb <234/255, 235/255, 233/255>;
#declare CN_Celestial_Green = rgb <45/255, 223/255, 193/255>;
#declare CN_Celestial_Horizon = rgb <124/255, 148/255, 179/255>;
#declare CN_Celestial_Indigo = rgb <9/255, 31/255, 146/255>;
#declare CN_Celestial_Light = rgb <199/255, 218/255, 232/255>;
#declare CN_Celestial_Moon = rgb <227/255, 212/255, 185/255>;
#declare CN_Celestial_Pink = rgb <156/255, 0/255, 74/255>;
#declare CN_Celestial_Plum = rgb <60/255, 122/255, 194/255>;
#declare CN_Celestine = rgb <133/255, 193/255, 196/255>;
#declare CN_Celestine_Spring = rgb <36/255, 164/255, 200/255>;
#declare CN_Celestra_Grey = rgb <153/255, 167/255, 171/255>;
#declare CN_Celestyn = rgb <181/255, 199/255, 210/255>;
#declare CN_Celine = rgb <130/255, 97/255, 103/255>;
#declare CN_Cellar_Door = rgb <117/255, 85/255, 63/255>;
#declare CN_Cellini_Gold = rgb <221/255, 181/255, 130/255>;
#declare CN_Cello = rgb <58/255, 78/255, 95/255>;
#declare CN_Celluloid = rgb <81/255, 81/255, 83/255>;
#declare CN_Celosia_Orange = rgb <232/255, 112/255, 58/255>;
#declare CN_Celtic = rgb <43/255, 63/255, 54/255>;
#declare CN_Celtic_Blue = rgb <36/255, 107/255, 206/255>;
#declare CN_Celtic_Clover = rgb <0/255, 105/255, 64/255>;
#declare CN_Celtic_Green = rgb <31/255, 105/255, 84/255>;
#declare CN_Celtic_Grey = rgb <197/255, 212/255, 206/255>;
#declare CN_Celtic_Linen = rgb <245/255, 229/255, 206/255>;
#declare CN_Celtic_Queen = rgb <0/255, 136/255, 107/255>;
#declare CN_Celtic_Rush = rgb <46/255, 76/255, 91/255>;
#declare CN_Celtic_Spring = rgb <170/255, 222/255, 178/255>;
#declare CN_Celuce = rgb <139/255, 171/255, 104/255>;
#declare CN_Cembra_Blossom = rgb <114/255, 86/255, 113/255>;
#declare CN_Cement = rgb <165/255, 163/255, 145/255>;
#declare CN_Cement_Feet = rgb <123/255, 115/255, 123/255>;
#declare CN_Cement_Greige = rgb <181/255, 171/255, 164/255>;
#declare CN_Cemetery_Ash = rgb <192/255, 199/255, 208/255>;
#declare CN_Cendre_Blue = rgb <62/255, 127/255, 165/255>;
#declare CN_Census = rgb <50/255, 122/255, 104/255>;
#declare CN_Centaur = rgb <144/255, 103/255, 63/255>;
#declare CN_Centaur_Brown = rgb <139/255, 106/255, 79/255>;
#declare CN_Centennial_Rose = rgb <179/255, 167/255, 166/255>;
#declare CN_Centeotl_Yellow = rgb <247/255, 224/255, 119/255>;
#declare CN_Center_Earth = rgb <104/255, 85/255, 73/255>;
#declare CN_Center_Ridge = rgb <129/255, 122/255, 105/255>;
#declare CN_Center_Stage = rgb <255/255, 193/255, 0/255>;
#declare CN_Centipede_Brown = rgb <109/255, 36/255, 0/255>;
#declare CN_Centra = rgb <192/255, 143/255, 69/255>;
#declare CN_Centre_Stage = rgb <200/255, 199/255, 203/255>;
#declare CN_Centurys_Last_Sunset = rgb <156/255, 123/255, 135/255>;
#declare CN_Ceramic = rgb <252/255, 255/255, 249/255>;
#declare CN_Ceramic_Beige = rgb <237/255, 209/255, 172/255>;
#declare CN_Ceramic_Blue_Turquoise = rgb <22/255, 162/255, 154/255>;
#declare CN_Ceramic_Brown = rgb <160/255, 88/255, 67/255>;
#declare CN_Ceramic_Glaze = rgb <232/255, 167/255, 132/255>;
#declare CN_Ceramic_Green = rgb <59/255, 183/255, 115/255>;
#declare CN_Ceramic_Pot = rgb <144/255, 130/255, 104/255>;
#declare CN_Ceramite_White = rgb <254/255, 254/255, 224/255>;
#declare CN_Cereal_Flake = rgb <239/255, 215/255, 171/255>;
#declare CN_Cerebellum_Grey = rgb <203/255, 203/255, 203/255>;
#declare CN_Cerebral_Grey = rgb <204/255, 204/255, 204/255>;
#declare CN_Ceremonial_Gold = rgb <214/255, 158/255, 89/255>;
#declare CN_Ceremonial_Grey = rgb <145/255, 153/255, 142/255>;
#declare CN_Ceremonial_Purple = rgb <42/255, 39/255, 86/255>;
#declare CN_Cerise = rgb <164/255, 18/255, 71/255>;
#declare CN_Cerise_Pink = rgb <236/255, 59/255, 131/255>;
#declare CN_Cerise_Red = rgb <222/255, 49/255, 99/255>;
#declare CN_Certain_Peach = rgb <242/255, 189/255, 162/255>;
#declare CN_Cerulean = rgb <85/255, 170/255, 238/255>;
#declare CN_Cerulean_Blue = rgb <42/255, 82/255, 190/255>;
#declare CN_Cerulean_Frost = rgb <109/255, 155/255, 195/255>;
#declare CN_Cetacean_Blue = rgb <0/255, 20/255, 64/255>;
#declare CN_Ceylanite = rgb <51/255, 67/255, 30/255>;
#declare CN_Ceylon_Cream = rgb <243/255, 233/255, 214/255>;
#declare CN_Ceylon_Yellow = rgb <212/255, 174/255, 64/255>;
#declare CN_Ceylonese = rgb <117/255, 104/255, 88/255>;
#declare CN_CG_Blue = rgb <0/255, 122/255, 165/255>;
#declare CN_CG_Red = rgb <224/255, 60/255, 49/255>;
#declare CN_CGA_Blue = rgb <86/255, 255/255, 255/255>;
#declare CN_CGA_Pink = rgb <252/255, 15/255, 192/255>;
#declare CN_Cha_Lu_Green = rgb <119/255, 146/255, 111/255>;
#declare CN_Chaat_Masala = rgb <236/255, 125/255, 44/255>;
#declare CN_Chablis = rgb <253/255, 233/255, 224/255>;
#declare CN_Chafed_Wheat = rgb <246/255, 224/255, 207/255>;
#declare CN_Chagall_Green = rgb <0/255, 139/255, 98/255>;
#declare CN_Chai = rgb <235/255, 207/255, 174/255>;
#declare CN_Chai_Latte = rgb <249/255, 203/255, 160/255>;
#declare CN_Chai_Spice = rgb <189/255, 124/255, 79/255>;
#declare CN_Chai_Tea = rgb <177/255, 131/255, 47/255>;
#declare CN_Chai_Tea_Latte = rgb <239/255, 215/255, 179/255>;
#declare CN_Chain_Gang_Grey = rgb <112/255, 128/255, 144/255>;
#declare CN_Chain_Mail = rgb <129/255, 119/255, 127/255>;
#declare CN_Chain_Reaction = rgb <164/255, 166/255, 164/255>;
#declare CN_Chaise_Mauve = rgb <193/255, 178/255, 179/255>;
#declare CN_Chakra = rgb <139/255, 94/255, 143/255>;
#declare CN_Chalcedony = rgb <221/255, 221/255, 153/255>;
#declare CN_Chalcedony_Green = rgb <75/255, 96/255, 87/255>;
#declare CN_Chalcedony_Violet = rgb <103/255, 112/255, 174/255>;
#declare CN_Chalet = rgb <194/255, 152/255, 103/255>;
#declare CN_Chalet_Green = rgb <90/255, 110/255, 65/255>;
#declare CN_Chalk = rgb <237/255, 234/255, 229/255>;
#declare CN_Chalk_Beige = rgb <214/255, 197/255, 180/255>;
#declare CN_Chalk_Blue = rgb <204/255, 218/255, 215/255>;
#declare CN_Chalk_Dust = rgb <234/255, 235/255, 230/255>;
#declare CN_Chalk_Pink = rgb <230/255, 197/255, 202/255>;
#declare CN_Chalk_Violet = rgb <143/255, 125/255, 165/255>;
#declare CN_Chalkware = rgb <224/255, 206/255, 183/255>;
#declare CN_Chalky = rgb <223/255, 194/255, 129/255>;
#declare CN_Chalky_Blue_White = rgb <208/255, 235/255, 241/255>;
#declare CN_Challah_Bread = rgb <205/255, 122/255, 80/255>;
#declare CN_Chambray = rgb <71/255, 88/255, 119/255>;
#declare CN_Chambray_Blue = rgb <158/255, 180/255, 211/255>;
#declare CN_Chameleon = rgb <182/255, 160/255, 99/255>;
#declare CN_Chameleon_Skin = rgb <206/255, 218/255, 172/255>;
#declare CN_Chameleon_Tango = rgb <192/255, 194/255, 160/255>;
#declare CN_Chamois = rgb <232/255, 205/255, 154/255>;
#declare CN_Chamois_Cloth = rgb <240/255, 225/255, 208/255>;
#declare CN_Chamois_Leather = rgb <173/255, 136/255, 103/255>;
#declare CN_Chamois_Tan = rgb <179/255, 163/255, 133/255>;
#declare CN_Chamois_Yellow = rgb <152/255, 110/255, 25/255>;
#declare CN_Chamoisee = rgb <160/255, 120/255, 90/255>;
#declare CN_Chamomile = rgb <232/255, 208/255, 167/255>;
#declare CN_Chamomile_Tea = rgb <218/255, 195/255, 149/255>;
#declare CN_Champagne = rgb <233/255, 210/255, 172/255>;
#declare CN_Champagne_Beige = rgb <212/255, 196/255, 158/255>;
#declare CN_Champagne_Bliss = rgb <240/255, 225/255, 197/255>;
#declare CN_Champagne_Bubbles = rgb <221/255, 206/255, 173/255>;
#declare CN_Champagne_Burst = rgb <241/255, 228/255, 203/255>;
#declare CN_Champagne_Cocktail = rgb <227/255, 215/255, 174/255>;
#declare CN_Champagne_Elegance = rgb <235/255, 211/255, 228/255>;
#declare CN_Champagne_Flute = rgb <246/255, 236/255, 226/255>;
#declare CN_Champagne_Gold = rgb <232/255, 214/255, 179/255>;
#declare CN_Champagne_Grape = rgb <197/255, 176/255, 103/255>;
#declare CN_Champagne_Ice = rgb <243/255, 229/255, 221/255>;
#declare CN_Champagne_Pink = rgb <241/255, 221/255, 207/255>;
#declare CN_Champagne_Rose = rgb <227/255, 214/255, 204/255>;
#declare CN_Champagne_Wishes = rgb <239/255, 212/255, 174/255>;
#declare CN_Champignon = rgb <148/255, 144/255, 137/255>;
#declare CN_Champion = rgb <123/255, 89/255, 134/255>;
#declare CN_Champion_Blue = rgb <96/255, 103/255, 136/255>;
#declare CN_Champlain_Blue = rgb <67/255, 85/255, 114/255>;
#declare CN_Chance_of_Rain = rgb <160/255, 166/255, 169/255>;
#declare CN_Chandra_Cream = rgb <236/255, 186/255, 93/255>;
#declare CN_Changeling_Pink = rgb <244/255, 175/255, 205/255>;
#declare CN_Channel = rgb <241/255, 195/255, 194/255>;
#declare CN_Channel_Marker_Green = rgb <4/255, 216/255, 178/255>;
#declare CN_Chanoyu = rgb <238/255, 232/255, 210/255>;
#declare CN_Chanterelle = rgb <218/255, 165/255, 32/255>;
#declare CN_Chanterelle_Sauce = rgb <162/255, 135/255, 118/255>;
#declare CN_Chanterelles = rgb <255/255, 198/255, 110/255>;
#declare CN_Chanticleer = rgb <135/255, 0/255, 0/255>;
#declare CN_Chantilly = rgb <237/255, 184/255, 199/255>;
#declare CN_Chantilly_Lace = rgb <241/255, 226/255, 222/255>;
#declare CN_Chaos_Black = rgb <15/255, 15/255, 15/255>;
#declare CN_Chaotic_Red = rgb <116/255, 6/255, 0/255>;
#declare CN_Chaotic_Roses = rgb <187/255, 34/255, 102/255>;
#declare CN_Chaparral = rgb <229/255, 208/255, 176/255>;
#declare CN_Chapeau_Violet = rgb <222/255, 229/255, 236/255>;
#declare CN_Chapel_Wall = rgb <237/255, 226/255, 172/255>;
#declare CN_Chaps = rgb <100/255, 75/255, 65/255>;
#declare CN_Chapter = rgb <159/255, 147/255, 105/255>;
#declare CN_Charade = rgb <57/255, 64/255, 67/255>;
#declare CN_Charadon_Granite = rgb <80/255, 77/255, 76/255>;
#declare CN_Charcoal = rgb <52/255, 56/255, 55/255>;
#declare CN_Charcoal_Blue = rgb <103/255, 119/255, 138/255>;
#declare CN_Charcoal_Briquette = rgb <93/255, 98/255, 92/255>;
#declare CN_Charcoal_Dust = rgb <148/255, 151/255, 179/255>;
#declare CN_Charcoal_Grey = rgb <110/255, 105/255, 105/255>;
#declare CN_Charcoal_Light = rgb <114/255, 110/255, 104/255>;
#declare CN_Charcoal_Plum = rgb <106/255, 106/255, 111/255>;
#declare CN_Charcoal_Sketch = rgb <93/255, 91/255, 86/255>;
#declare CN_Charcoal_Smoke = rgb <71/255, 79/255, 67/255>;
#declare CN_Charcoal_Smudge = rgb <96/255, 96/255, 94/255>;
#declare CN_Chard = rgb <72/255, 85/255, 63/255>;
#declare CN_Chardon = rgb <248/255, 234/255, 223/255>;
#declare CN_Chardonnay = rgb <239/255, 232/255, 188/255>;
#declare CN_Charisma = rgb <99/255, 42/255, 96/255>;
#declare CN_Charismatic = rgb <231/255, 193/255, 128/255>;
#declare CN_Charismatic_Red = rgb <238/255, 34/255, 68/255>;
#declare CN_Charismatic_Sky = rgb <154/255, 193/255, 220/255>;
#declare CN_Charleston_Cherry = rgb <159/255, 65/255, 75/255>;
#declare CN_Charleston_Chocolate = rgb <192/255, 146/255, 120/255>;
#declare CN_Charleston_Green = rgb <35/255, 43/255, 43/255>;
#declare CN_Charlie_Brown = rgb <153/255, 85/255, 0/255>;
#declare CN_Charlie_Horse = rgb <148/255, 130/255, 99/255>;
#declare CN_Charlock = rgb <229/255, 231/255, 144/255>;
#declare CN_Charlotte = rgb <164/255, 220/255, 230/255>;
#declare CN_Charm = rgb <208/255, 116/255, 139/255>;
#declare CN_Charm_Pink = rgb <230/255, 143/255, 172/255>;
#declare CN_Charmed_Green = rgb <0/255, 127/255, 58/255>;
#declare CN_Charming = rgb <212/255, 224/255, 146/255>;
#declare CN_Charming_Cherry = rgb <255/255, 144/255, 162/255>;
#declare CN_Charming_Nature = rgb <17/255, 187/255, 68/255>;
#declare CN_Charming_Pink = rgb <237/255, 211/255, 210/255>;
#declare CN_Charming_Violet = rgb <140/255, 114/255, 129/255>;
#declare CN_Charoite_Violet = rgb <106/255, 87/255, 127/255>;
#declare CN_Charolais_Cattle = rgb <241/255, 235/255, 234/255>;
#declare CN_Charred_Brown = rgb <62/255, 0/255, 7/255>;
#declare CN_Charred_Chocolate = rgb <85/255, 59/255, 61/255>;
#declare CN_Charred_Clay = rgb <136/255, 81/255, 50/255>;
#declare CN_Charred_Hickory = rgb <91/255, 78/255, 74/255>;
#declare CN_Charter = rgb <105/255, 178/255, 207/255>;
#declare CN_Charter_Blue = rgb <84/255, 110/255, 145/255>;
#declare CN_Chartreuse = rgb <193/255, 248/255, 10/255>;
#declare CN_Chartreuse_Frost = rgb <228/255, 220/255, 198/255>;
#declare CN_Chartreuse_Shot = rgb <218/255, 208/255, 0/255>;
#declare CN_Charybdis = rgb <22/255, 163/255, 203/255>;
#declare CN_Chasm = rgb <135/255, 96/255, 68/255>;
#declare CN_Chasm_Green = rgb <99/255, 181/255, 33/255>;
#declare CN_Chaste_Blossoms = rgb <153/255, 68/255, 238/255>;
#declare CN_Chat_Orange = rgb <247/255, 154/255, 62/255>;
#declare CN_Chateau = rgb <181/255, 162/255, 138/255>;
#declare CN_Chateau_Brown = rgb <91/255, 75/255, 68/255>;
#declare CN_Chateau_de_Chillon = rgb <162/255, 170/255, 179/255>;
#declare CN_Chateau_Green = rgb <65/255, 159/255, 89/255>;
#declare CN_Chateau_Grey = rgb <187/255, 177/255, 168/255>;
#declare CN_Chateau_Rose = rgb <219/255, 163/255, 206/255>;
#declare CN_Chatelle = rgb <179/255, 171/255, 182/255>;
#declare CN_Chathams_Blue = rgb <44/255, 89/255, 113/255>;
#declare CN_Chatroom = rgb <176/255, 171/255, 156/255>;
#declare CN_Chatty_Cricket = rgb <137/255, 179/255, 134/255>;
#declare CN_Chatura_Gray = rgb <160/255, 146/255, 135/255>;
#declare CN_Chayote = rgb <199/255, 226/255, 198/255>;
#declare CN_Che_Guevara_Red = rgb <237/255, 33/255, 77/255>;
#declare CN_Cheater = rgb <238/255, 177/255, 93/255>;
#declare CN_Cheddar_Biscuit = rgb <210/255, 173/255, 135/255>;
#declare CN_Cheddar_Cheese = rgb <240/255, 132/255, 58/255>;
#declare CN_Cheddar_Chunk = rgb <249/255, 201/255, 130/255>;
#declare CN_Cheddar_Corn = rgb <245/255, 212/255, 181/255>;
#declare CN_Cheddar_Pink_Mauve = rgb <182/255, 125/255, 175/255>;
#declare CN_Cheek_Red = rgb <182/255, 124/255, 162/255>;
#declare CN_Cheeky_Chestnut = rgb <123/255, 77/255, 58/255>;
#declare CN_Cheerful = rgb <255/255, 199/255, 35/255>;
#declare CN_Cheerful_Heart = rgb <220/255, 199/255, 192/255>;
#declare CN_Cheerful_Hue = rgb <255/255, 225/255, 149/255>;
#declare CN_Cheerful_Tangerine = rgb <253/255, 164/255, 113/255>;
#declare CN_Cheerful_Whisper = rgb <211/255, 215/255, 231/255>;
#declare CN_Cheerful_Wine = rgb <126/255, 66/255, 88/255>;
#declare CN_Cheers_ = rgb <192/255, 153/255, 98/255>;
#declare CN_Cheery = rgb <240/255, 138/255, 136/255>;
#declare CN_Cheese = rgb <255/255, 166/255, 0/255>;
#declare CN_Cheese_Please = rgb <255/255, 150/255, 19/255>;
#declare CN_Cheese_Powder = rgb <255/255, 228/255, 190/255>;
#declare CN_Cheese_Puff = rgb <255/255, 185/255, 111/255>;
#declare CN_Cheesecake = rgb <255/255, 252/255, 218/255>;
#declare CN_Cheesus = rgb <255/255, 204/255, 119/255>;
#declare CN_Cheesy_Frittata = rgb <240/255, 224/255, 147/255>;
#declare CN_Cheesy_Grin = rgb <250/255, 225/255, 149/255>;
#declare CN_Chefchaouen_Blue = rgb <163/255, 209/255, 232/255>;
#declare CN_Chelsea_Cucumber = rgb <136/255, 169/255, 91/255>;
#declare CN_Chelsea_Garden = rgb <84/255, 109/255, 102/255>;
#declare CN_Chelsea_Gem = rgb <149/255, 83/255, 47/255>;
#declare CN_Chelsea_Gray = rgb <182/255, 183/255, 176/255>;
#declare CN_Chelsea_Mauve = rgb <190/255, 172/255, 159/255>;
#declare CN_Cheng_Hong_Se_Orange = rgb <249/255, 64/255, 9/255>;
#declare CN_Chenille = rgb <166/255, 205/255, 145/255>;
#declare CN_Chenille_Spread = rgb <241/255, 231/255, 214/255>;
#declare CN_Chenille_White = rgb <249/255, 239/255, 226/255>;
#declare CN_Chenin = rgb <222/255, 195/255, 113/255>;
#declare CN_Cherenkov_Radiation = rgb <34/255, 187/255, 255/255>;
#declare CN_Cherish_Cream = rgb <244/255, 227/255, 203/255>;
#declare CN_Cherish_is_the_Word = rgb <230/255, 228/255, 218/255>;
#declare CN_Cherish_the_Moment = rgb <204/255, 172/255, 215/255>;
#declare CN_Cherished = rgb <186/255, 151/255, 177/255>;
#declare CN_Cherished_One = rgb <252/255, 146/255, 147/255>;
#declare CN_Chernobog = rgb <172/255, 1/255, 50/255>;
#declare CN_Chernobog_Breath = rgb <227/255, 220/255, 218/255>;
#declare CN_Cherokee = rgb <245/255, 205/255, 130/255>;
#declare CN_Cherokee_Dignity = rgb <221/255, 119/255, 34/255>;
#declare CN_Cherokee_Red = rgb <130/255, 78/255, 74/255>;
#declare CN_Cherries_Jubilee = rgb <162/255, 36/255, 82/255>;
#declare CN_Cherry = rgb <207/255, 2/255, 52/255>;
#declare CN_Cherry_Bark = rgb <144/255, 130/255, 121/255>;
#declare CN_Cherry_Berry = rgb <159/255, 77/255, 101/255>;
#declare CN_Cherry_Black = rgb <66/255, 35/255, 41/255>;
#declare CN_Cherry_Blink = rgb <173/255, 83/255, 68/255>;
#declare CN_Cherry_Blossom = rgb <247/255, 206/255, 224/255>;
#declare CN_Cherry_Blossom_Pink = rgb <255/255, 183/255, 197/255>;
#declare CN_Cherry_Blush = rgb <255/255, 201/255, 221/255>;
#declare CN_Cherry_Bomb = rgb <183/255, 61/255, 63/255>;
#declare CN_Cherry_Brandy = rgb <226/255, 107/255, 129/255>;
#declare CN_Cherry_Chip = rgb <255/255, 187/255, 180/255>;
#declare CN_Cherry_Cobbler = rgb <136/255, 63/255, 65/255>;
#declare CN_Cherry_Cocoa = rgb <142/255, 94/255, 101/255>;
#declare CN_Cherry_Cola = rgb <137/255, 76/255, 59/255>;
#declare CN_Cherry_Cordial = rgb <235/255, 190/255, 211/255>;
#declare CN_Cherry_Fizz = rgb <189/255, 105/255, 115/255>;
#declare CN_Cherry_Flower = rgb <251/255, 218/255, 232/255>;
#declare CN_Cherry_Foam = rgb <243/255, 146/255, 160/255>;
#declare CN_Cherry_Hill = rgb <204/255, 81/255, 96/255>;
#declare CN_Cherry_Juice = rgb <189/255, 144/255, 149/255>;
#declare CN_Cherry_Juice_Red = rgb <108/255, 44/255, 69/255>;
#declare CN_Cherry_Kiss = rgb <163/255, 46/255, 57/255>;
#declare CN_Cherry_Lolly = rgb <200/255, 56/255, 90/255>;
#declare CN_Cherry_Mahogany = rgb <102/255, 53/255, 43/255>;
#declare CN_Cherry_On_Top = rgb <172/255, 73/255, 92/255>;
#declare CN_Cherry_Paddle_Pop = rgb <254/255, 49/255, 75/255>;
#declare CN_Cherry_Pearl = rgb <249/255, 231/255, 244/255>;
#declare CN_Cherry_Pie = rgb <55/255, 45/255, 82/255>;
#declare CN_Cherry_Pink = rgb <199/255, 96/255, 123/255>;
#declare CN_Cherry_Plum = rgb <161/255, 0/255, 71/255>;
#declare CN_Cherry_Race = rgb <166/255, 65/255, 55/255>;
#declare CN_Cherry_Red = rgb <247/255, 2/255, 42/255>;
#declare CN_Cherry_Tart = rgb <147/255, 61/255, 62/255>;
#declare CN_Cherry_Tomato = rgb <242/255, 1/255, 63/255>;
#declare CN_Cherry_Tree = rgb <223/255, 183/255, 180/255>;
#declare CN_Cherry_Velvet = rgb <225/255, 6/255, 70/255>;
#declare CN_Cherry_Wine = rgb <176/255, 69/255, 86/255>;
#declare CN_Cherrywood = rgb <101/255, 26/255, 20/255>;
#declare CN_Chert = rgb <132/255, 129/255, 130/255>;
#declare CN_Cherub = rgb <245/255, 215/255, 220/255>;
#declare CN_Cherubic = rgb <255/255, 230/255, 241/255>;
#declare CN_Chervil_Leaves = rgb <171/255, 189/255, 144/255>;
#declare CN_Chess_Ivory = rgb <255/255, 233/255, 197/255>;
#declare CN_Chester_Brown = rgb <135/255, 107/255, 75/255>;
#declare CN_Chestnut = rgb <116/255, 40/255, 2/255>;
#declare CN_Chestnut_Bisque = rgb <193/255, 156/255, 134/255>;
#declare CN_Chestnut_Brown = rgb <109/255, 16/255, 8/255>;
#declare CN_Chestnut_Butter = rgb <188/255, 164/255, 134/255>;
#declare CN_Chestnut_Chest = rgb <142/255, 86/255, 55/255>;
#declare CN_Chestnut_Gold = rgb <171/255, 133/255, 8/255>;
#declare CN_Chestnut_Green = rgb <42/255, 79/255, 33/255>;
#declare CN_Chestnut_Leather = rgb <96/255, 40/255, 30/255>;
#declare CN_Chestnut_Peel = rgb <109/255, 60/255, 50/255>;
#declare CN_Chestnut_Plum = rgb <133/255, 46/255, 25/255>;
#declare CN_Chestnut_Red = rgb <108/255, 51/255, 63/255>;
#declare CN_Chestnut_Rose = rgb <205/255, 82/255, 82/255>;
#declare CN_Chestnut_Shell = rgb <173/255, 255/255, 47/255>;
#declare CN_Chestnut_Stallion = rgb <153/255, 93/255, 59/255>;
#declare CN_Chestnut_White = rgb <234/255, 241/255, 230/255>;
#declare CN_Chesty_Bond = rgb <81/255, 111/255, 160/255>;
#declare CN_Chetwode_Blue = rgb <102/255, 111/255, 180/255>;
#declare CN_Cheviot = rgb <246/255, 242/255, 232/255>;
#declare CN_Chewing_Gum = rgb <230/255, 176/255, 175/255>;
#declare CN_Chewing_Gum_Pink = rgb <226/255, 146/255, 182/255>;
#declare CN_Chewy_Caramel = rgb <151/255, 112/255, 67/255>;
#declare CN_Cheyenne_Rock = rgb <159/255, 145/255, 138/255>;
#declare CN_Chi_Gong = rgb <213/255, 43/255, 45/255>;
#declare CN_Chianti = rgb <115/255, 67/255, 66/255>;
#declare CN_Chic_Brick = rgb <164/255, 114/255, 90/255>;
#declare CN_Chic_Green = rgb <216/255, 235/255, 214/255>;
#declare CN_Chic_Grey = rgb <207/255, 204/255, 197/255>;
#declare CN_Chic_Magnet = rgb <237/255, 225/255, 200/255>;
#declare CN_Chic_Peach = rgb <240/255, 209/255, 200/255>;
#declare CN_Chic_Shade = rgb <124/255, 146/255, 112/255>;
#declare CN_Chic_Taupe = rgb <170/255, 151/255, 136/255>;
#declare CN_Chicago = rgb <91/255, 93/255, 86/255>;
#declare CN_Chicago_Blue = rgb <182/255, 219/255, 233/255>;
#declare CN_Chicago_Fog = rgb <202/255, 194/255, 189/255>;
#declare CN_Chicago_Skyline = rgb <150/255, 173/255, 186/255>;
#declare CN_Chicha_Morada = rgb <126/255, 96/255, 114/255>;
#declare CN_Chick_Flick = rgb <191/255, 125/255, 128/255>;
#declare CN_Chickadee = rgb <255/255, 207/255, 101/255>;
#declare CN_Chicken_Comb = rgb <221/255, 34/255, 34/255>;
#declare CN_Chicken_Masala = rgb <204/255, 136/255, 34/255>;
#declare CN_Chickpea = rgb <239/255, 231/255, 223/255>;
#declare CN_Chickweed = rgb <217/255, 223/255, 227/255>;
#declare CN_Chicon = rgb <217/255, 238/255, 180/255>;
#declare CN_Chicory = rgb <167/255, 134/255, 88/255>;
#declare CN_Chicory_Coffee = rgb <74/255, 52/255, 46/255>;
#declare CN_Chicory_Flower = rgb <102/255, 120/255, 154/255>;
#declare CN_Chicory_Green = rgb <187/255, 171/255, 117/255>;
#declare CN_Chicory_Root = rgb <95/255, 66/255, 63/255>;
#declare CN_Chieftain = rgb <106/255, 86/255, 55/255>;
#declare CN_Chiffon = rgb <240/255, 245/255, 187/255>;
#declare CN_Chifle_Yellow = rgb <219/255, 201/255, 99/255>;
#declare CN_Child_of_Heaven = rgb <234/255, 229/255, 197/255>;
#declare CN_Child_of_Light = rgb <240/255, 244/255, 248/255>;
#declare CN_Child_of_the_Moon = rgb <198/255, 141/255, 55/255>;
#declare CN_Child_of_the_Night = rgb <34/255, 0/255, 119/255>;
#declare CN_Childs_Play = rgb <231/255, 188/255, 212/255>;
#declare CN_Childhood_Crush = rgb <226/255, 109/255, 104/255>;
#declare CN_Childish_Wonder = rgb <165/255, 168/255, 214/255>;
#declare CN_Childlike = rgb <232/255, 192/255, 207/255>;
#declare CN_Childrens_Soft_Blue = rgb <161/255, 206/255, 215/255>;
#declare CN_Chilean_Fire = rgb <208/255, 94/255, 52/255>;
#declare CN_Chilean_Heath = rgb <249/255, 247/255, 222/255>;
#declare CN_Chili = rgb <190/255, 81/255, 65/255>;
#declare CN_Chili_Con_Carne = rgb <152/255, 94/255, 43/255>;
#declare CN_Chili_Green = rgb <141/255, 112/255, 64/255>;
#declare CN_Chili_Oil = rgb <142/255, 60/255, 54/255>;
#declare CN_Chili_Pepper = rgb <155/255, 27/255, 48/255>;
#declare CN_Chili_Sauce = rgb <188/255, 78/255, 64/255>;
#declare CN_Chili_Soda = rgb <202/255, 124/255, 116/255>;
#declare CN_Chill_in_the_Air = rgb <209/255, 213/255, 231/255>;
#declare CN_Chilled_Cucumber = rgb <203/255, 205/255, 178/255>;
#declare CN_Chilled_Lemonade = rgb <255/255, 230/255, 150/255>;
#declare CN_Chilled_Mint = rgb <228/255, 239/255, 222/255>;
#declare CN_Chilled_Wine = rgb <109/255, 64/255, 82/255>;
#declare CN_Chilli_Black_Red = rgb <75/255, 28/255, 53/255>;
#declare CN_Chilli_Cashew = rgb <204/255, 85/255, 68/255>;
#declare CN_Chilly_Blue = rgb <138/255, 174/255, 195/255>;
#declare CN_Chilly_Spice = rgb <253/255, 153/255, 137/255>;
#declare CN_Chilly_White = rgb <229/255, 241/255, 237/255>;
#declare CN_Chimayo_Red = rgb <177/255, 99/255, 85/255>;
#declare CN_Chimera = rgb <116/255, 98/255, 109/255>;
#declare CN_Chimera_Brown = rgb <200/255, 155/255, 117/255>;
#declare CN_Chimes = rgb <199/255, 202/255, 134/255>;
#declare CN_Chimney = rgb <74/255, 82/255, 87/255>;
#declare CN_Chimney_Sweep = rgb <39/255, 47/255, 56/255>;
#declare CN_Chin_Chin_Cherry = rgb <221/255, 51/255, 85/255>;
#declare CN_China_Aster = rgb <68/255, 76/255, 96/255>;
#declare CN_China_Blue = rgb <84/255, 100/255, 119/255>;
#declare CN_China_Cinnamon = rgb <138/255, 112/255, 84/255>;
#declare CN_China_Clay = rgb <113/255, 139/255, 154/255>;
#declare CN_China_Cup = rgb <248/255, 240/255, 229/255>;
#declare CN_China_Doll = rgb <243/255, 228/255, 213/255>;
#declare CN_China_Green_Blue = rgb <58/255, 100/255, 104/255>;
#declare CN_China_Ivory = rgb <251/255, 243/255, 211/255>;
#declare CN_China_Light_Green = rgb <188/255, 201/255, 199/255>;
#declare CN_China_Pattern = rgb <61/255, 92/255, 119/255>;
#declare CN_China_Pink = rgb <223/255, 110/255, 161/255>;
#declare CN_China_Red = rgb <173/255, 43/255, 16/255>;
#declare CN_China_Rose = rgb <168/255, 81/255, 110/255>;
#declare CN_China_Seas = rgb <3/255, 79/255, 124/255>;
#declare CN_China_Silk = rgb <227/255, 209/255, 204/255>;
#declare CN_China_White = rgb <234/255, 230/255, 217/255>;
#declare CN_Chinaberry = rgb <70/255, 73/255, 96/255>;
#declare CN_Chinchilla = rgb <156/255, 142/255, 123/255>;
#declare CN_Chinchilla_Chenille = rgb <208/255, 187/255, 167/255>;
#declare CN_Chinchilla_Grey = rgb <127/255, 116/255, 110/255>;
#declare CN_Chinese_Bellflower = rgb <77/255, 90/255, 175/255>;
#declare CN_Chinese_Black = rgb <17/255, 17/255, 0/255>;
#declare CN_Chinese_Blue = rgb <54/255, 81/255, 148/255>;
#declare CN_Chinese_Bronze = rgb <205/255, 128/255, 50/255>;
#declare CN_Chinese_Brown = rgb <171/255, 56/255, 31/255>;
#declare CN_Chinese_Cherry = rgb <241/255, 215/255, 203/255>;
#declare CN_Chinese_Dragon = rgb <203/255, 82/255, 81/255>;
#declare CN_Chinese_Garden = rgb <0/255, 105/255, 103/255>;
#declare CN_Chinese_Gold = rgb <221/255, 170/255, 0/255>;
#declare CN_Chinese_Goldfish = rgb <243/255, 71/255, 35/255>;
#declare CN_Chinese_Green = rgb <208/255, 219/255, 97/255>;
#declare CN_Chinese_Hamster = rgb <235/255, 219/255, 202/255>;
#declare CN_Chinese_Ibis_Brown = rgb <224/255, 158/255, 135/255>;
#declare CN_Chinese_Ink = rgb <63/255, 49/255, 43/255>;
#declare CN_Chinese_Jade = rgb <203/255, 209/255, 186/255>;
#declare CN_Chinese_Lacquer = rgb <96/255, 199/255, 194/255>;
#declare CN_Chinese_Lantern = rgb <240/255, 144/255, 86/255>;
#declare CN_Chinese_Leaf = rgb <204/255, 214/255, 176/255>;
#declare CN_Chinese_Money_Plant = rgb <164/255, 190/255, 92/255>;
#declare CN_Chinese_New_Year = rgb <255/255, 51/255, 102/255>;
#declare CN_Chinese_Night = rgb <170/255, 56/255, 30/255>;
#declare CN_Chinese_Orange = rgb <243/255, 112/255, 66/255>;
#declare CN_Chinese_Pink = rgb <222/255, 112/255, 161/255>;
#declare CN_Chinese_Porcelain = rgb <58/255, 95/255, 125/255>;
#declare CN_Chinese_Purple = rgb <114/255, 11/255, 152/255>;
#declare CN_Chinese_Red = rgb <205/255, 7/255, 30/255>;
#declare CN_Chinese_Safflower = rgb <185/255, 64/255, 71/255>;
#declare CN_Chinese_Silver = rgb <221/255, 220/255, 239/255>;
#declare CN_Chinese_Tea_Green = rgb <172/255, 173/255, 152/255>;
#declare CN_Chinese_Tzu = rgb <143/255, 191/255, 189/255>;
#declare CN_Chinese_Violet = rgb <131/255, 94/255, 129/255>;
#declare CN_Chinese_White = rgb <226/255, 229/255, 222/255>;
#declare CN_Chinese_Yellow = rgb <255/255, 178/255, 0/255>;
#declare CN_Chino = rgb <184/255, 173/255, 138/255>;
#declare CN_Chino_Green = rgb <217/255, 202/255, 165/255>;
#declare CN_Chinois_Green = rgb <124/255, 140/255, 135/255>;
#declare CN_Chinook = rgb <157/255, 211/255, 168/255>;
#declare CN_Chinook_Salmon = rgb <200/255, 152/255, 126/255>;
#declare CN_Chinotto = rgb <85/255, 71/255, 71/255>;
#declare CN_Chintz = rgb <213/255, 199/255, 185/255>;
#declare CN_Chintz_Rose = rgb <238/255, 196/255, 190/255>;
#declare CN_Chipmunk = rgb <207/255, 161/255, 74/255>;
#declare CN_Chipolata = rgb <170/255, 68/255, 51/255>;
#declare CN_Chipotle_Paste = rgb <104/255, 62/255, 59/255>;
#declare CN_Chips_Provencale = rgb <221/255, 214/255, 24/255>;
#declare CN_Chitin_Green = rgb <2/255, 107/255, 103/255>;
#declare CN_Chivalrous = rgb <174/255, 178/255, 192/255>;
#declare CN_Chivalry_Copper = rgb <191/255, 120/255, 78/255>;
#declare CN_Chive = rgb <74/255, 83/255, 53/255>;
#declare CN_Chive_Bloom = rgb <79/255, 54/255, 80/255>;
#declare CN_Chive_Blossom = rgb <125/255, 93/255, 153/255>;
#declare CN_Chive_Flower = rgb <161/255, 147/255, 191/255>;
#declare CN_Chlorella_Green = rgb <86/255, 174/255, 87/255>;
#declare CN_Chloride = rgb <147/255, 216/255, 194/255>;
#declare CN_Chlorite = rgb <94/255, 142/255, 130/255>;
#declare CN_Chlorophyll = rgb <68/255, 137/255, 26/255>;
#declare CN_Chlorophyll_Cream = rgb <179/255, 214/255, 195/255>;
#declare CN_Chlorophyll_Green = rgb <74/255, 255/255, 0/255>;
#declare CN_Chlorosis = rgb <117/255, 135/255, 110/255>;
#declare CN_Choco_Biscuit = rgb <180/255, 131/255, 91/255>;
#declare CN_Choco_Chic = rgb <153/255, 51/255, 17/255>;
#declare CN_Choco_Death = rgb <99/255, 73/255, 62/255>;
#declare CN_Choco_Loco = rgb <125/255, 95/255, 83/255>;
#declare CN_Chocobo_Feather = rgb <249/255, 188/255, 8/255>;
#declare CN_Chocoholic = rgb <153/255, 51/255, 0/255>;
#declare CN_Chocolate = rgb <210/255, 105/255, 30/255>;
#declare CN_Chocolate_Bar = rgb <119/255, 51/255, 51/255>;
#declare CN_Chocolate_Bells = rgb <119/255, 81/255, 48/255>;
#declare CN_Chocolate_Bhut_Jolokia = rgb <120/255, 42/255, 46/255>;
#declare CN_Chocolate_Brown = rgb <65/255, 25/255, 0/255>;
#declare CN_Chocolate_Caliente = rgb <118/255, 88/255, 65/255>;
#declare CN_Chocolate_Castle = rgb <69/255, 34/255, 7/255>;
#declare CN_Chocolate_Chiffon = rgb <146/255, 129/255, 120/255>;
#declare CN_Chocolate_Chip = rgb <104/255, 90/255, 78/255>;
#declare CN_Chocolate_Chunk = rgb <107/255, 87/255, 74/255>;
#declare CN_Chocolate_Coco = rgb <100/255, 77/255, 66/255>;
#declare CN_Chocolate_Cosmos = rgb <88/255, 17/255, 26/255>;
#declare CN_Chocolate_Cupcake = rgb <96/255, 86/255, 71/255>;
#declare CN_Chocolate_Curl = rgb <145/255, 109/255, 94/255>;
#declare CN_Chocolate_Delight = rgb <150/255, 120/255, 109/255>;
#declare CN_Chocolate_Eclair = rgb <103/255, 72/255, 72/255>;
#declare CN_Chocolate_Escape = rgb <98/255, 61/255, 46/255>;
#declare CN_Chocolate_Explosion = rgb <142/255, 71/255, 59/255>;
#declare CN_Chocolate_Fondant = rgb <86/255, 53/255, 45/255>;
#declare CN_Chocolate_Fondue = rgb <154/255, 48/255, 1/255>;
#declare CN_Chocolate_Froth = rgb <222/255, 213/255, 200/255>;
#declare CN_Chocolate_Hazelnut = rgb <116/255, 39/255, 25/255>;
#declare CN_Chocolate_Heart = rgb <143/255, 120/255, 108/255>;
#declare CN_Chocolate_Kiss = rgb <60/255, 20/255, 33/255>;
#declare CN_Chocolate_Lab = rgb <92/255, 62/255, 53/255>;
#declare CN_Chocolate_Lust = rgb <153/255, 51/255, 34/255>;
#declare CN_Chocolate_Magma = rgb <122/255, 70/255, 58/255>;
#declare CN_Chocolate_Melange = rgb <51/255, 17/255, 0/255>;
#declare CN_Chocolate_Milk = rgb <151/255, 111/255, 76/255>;
#declare CN_Chocolate_Moment = rgb <153/255, 128/255, 105/255>;
#declare CN_Chocolate_Oatmeal_Cookie = rgb <187/255, 85/255, 68/255>;
#declare CN_Chocolate_Pancakes = rgb <136/255, 68/255, 0/255>;
#declare CN_Chocolate_Plum = rgb <60/255, 45/255, 46/255>;
#declare CN_Chocolate_Powder = rgb <165/255, 140/255, 123/255>;
#declare CN_Chocolate_Praline = rgb <102/255, 66/255, 77/255>;
#declare CN_Chocolate_Pretzel = rgb <96/255, 80/255, 75/255>;
#declare CN_Chocolate_Pudding = rgb <111/255, 102/255, 101/255>;
#declare CN_Chocolate_Rain = rgb <113/255, 79/255, 41/255>;
#declare CN_Chocolate_Red = rgb <77/255, 54/255, 53/255>;
#declare CN_Chocolate_Ripple = rgb <118/255, 96/255, 78/255>;
#declare CN_Chocolate_Soul = rgb <92/255, 73/255, 69/255>;
#declare CN_Chocolate_Sparkle = rgb <140/255, 108/255, 111/255>;
#declare CN_Chocolate_Sprinkle = rgb <111/255, 78/255, 67/255>;
#declare CN_Chocolate_Stain = rgb <132/255, 86/255, 60/255>;
#declare CN_Chocolate_Swirl = rgb <104/255, 87/255, 75/255>;
#declare CN_Chocolate_Temptation = rgb <149/255, 110/255, 95/255>;
#declare CN_Chocolate_Therapy = rgb <95/255, 73/255, 64/255>;
#declare CN_Chocolate_Torte = rgb <56/255, 46/255, 45/255>;
#declare CN_Chocolate_Truffle = rgb <97/255, 46/255, 53/255>;
#declare CN_Chocolate_Velvet = rgb <127/255, 116/255, 83/255>;
#declare CN_Choice_Cream = rgb <242/255, 225/255, 209/255>;
#declare CN_Chojicha_Brown = rgb <143/255, 88/255, 60/255>;
#declare CN_Chokecherry = rgb <146/255, 0/255, 10/255>;
#declare CN_Choo_Choo = rgb <134/255, 117/255, 120/255>;
#declare CN_Chopped_Chive = rgb <51/255, 107/255, 75/255>;
#declare CN_Chopped_Dill = rgb <182/255, 194/255, 161/255>;
#declare CN_Chopsticks = rgb <224/255, 209/255, 184/255>;
#declare CN_Choral_Singer = rgb <183/255, 119/255, 149/255>;
#declare CN_Chorizo = rgb <170/255, 0/255, 17/255>;
#declare CN_Choshun_Red = rgb <185/255, 87/255, 84/255>;
#declare CN_Chowder_Bowl = rgb <229/255, 210/255, 178/255>;
#declare CN_Christalle = rgb <56/255, 33/255, 97/255>;
#declare CN_Christi = rgb <113/255, 169/255, 29/255>;
#declare CN_Christina_Brown = rgb <0/255, 144/255, 148/255>;
#declare CN_Christmas_Blue = rgb <42/255, 143/255, 189/255>;
#declare CN_Christmas_Brown = rgb <93/255, 43/255, 44/255>;
#declare CN_Christmas_Gold = rgb <202/255, 169/255, 6/255>;
#declare CN_Christmas_Green = rgb <60/255, 141/255, 13/255>;
#declare CN_Christmas_Holly = rgb <104/255, 132/255, 106/255>;
#declare CN_Christmas_Ivy = rgb <71/255, 114/255, 102/255>;
#declare CN_Christmas_Orange = rgb <213/255, 108/255, 43/255>;
#declare CN_Christmas_Ornament = rgb <110/255, 90/255, 73/255>;
#declare CN_Christmas_Pink = rgb <227/255, 66/255, 133/255>;
#declare CN_Christmas_Purple = rgb <77/255, 8/255, 75/255>;
#declare CN_Christmas_Red = rgb <176/255, 27/255, 46/255>;
#declare CN_Christmas_Rose = rgb <255/255, 221/255, 187/255>;
#declare CN_Christmas_Silver = rgb <225/255, 223/255, 224/255>;
#declare CN_Christobel = rgb <212/255, 197/255, 186/255>;
#declare CN_Christys_Smile = rgb <246/255, 187/255, 202/255>;
#declare CN_Chrome_Aluminum = rgb <168/255, 169/255, 173/255>;
#declare CN_Chrome_Chalice = rgb <205/255, 200/255, 210/255>;
#declare CN_Chrome_White = rgb <202/255, 199/255, 183/255>;
#declare CN_Chrome_Yellow = rgb <255/255, 167/255, 0/255>;
#declare CN_Chromis_Damsel_Blue = rgb <130/255, 202/255, 252/255>;
#declare CN_Chromophobia_Green = rgb <6/255, 180/255, 139/255>;
#declare CN_Chronicle = rgb <62/255, 66/255, 101/255>;
#declare CN_Chronus_Blue = rgb <114/255, 168/255, 209/255>;
#declare CN_Chrysanthemum = rgb <190/255, 69/255, 79/255>;
#declare CN_Chrysanthemum_Leaf = rgb <157/255, 184/255, 171/255>;
#declare CN_Chrysocolla_Dark_Green = rgb <0/255, 79/255, 57/255>;
#declare CN_Chrysocolla_Green = rgb <55/255, 134/255, 97/255>;
#declare CN_Chrysocolla_Medium_Green = rgb <0/255, 107/255, 87/255>;
#declare CN_Chrysolite = rgb <142/255, 152/255, 73/255>;
#declare CN_Chrysomela_Goettingensis = rgb <57/255, 51/255, 74/255>;
#declare CN_Chrysopal_Light_Green = rgb <143/255, 178/255, 163/255>;
#declare CN_Chrysoprase = rgb <173/255, 186/255, 152/255>;
#declare CN_Chuckles = rgb <191/255, 65/255, 58/255>;
#declare CN_Chuff_Blue = rgb <145/255, 193/255, 198/255>;
#declare CN_Chun_Li_Blue = rgb <21/255, 89/255, 219/255>;
#declare CN_Chunky_Bee = rgb <255/255, 200/255, 75/255>;
#declare CN_Chupacabra_Grey = rgb <207/255, 205/255, 207/255>;
#declare CN_Church_Blue = rgb <61/255, 65/255, 97/255>;
#declare CN_Church_Mouse = rgb <179/255, 181/255, 175/255>;
#declare CN_Churchill = rgb <77/255, 77/255, 88/255>;
#declare CN_Chutney = rgb <152/255, 89/255, 75/255>;
#declare CN_Chutney_Brown = rgb <169/255, 119/255, 101/255>;
#declare CN_Chyornyi_Black = rgb <15/255, 8/255, 9/255>;
#declare CN_Cider_Mill = rgb <147/255, 138/255, 67/255>;
#declare CN_Cider_Pear_Green = rgb <138/255, 148/255, 111/255>;
#declare CN_Cider_Spice = rgb <174/255, 129/255, 103/255>;
#declare CN_Cider_Toddy = rgb <185/255, 128/255, 51/255>;
#declare CN_Cider_Yellow = rgb <231/255, 214/255, 175/255>;
#declare CN_Cielo = rgb <165/255, 206/255, 232/255>;
#declare CN_Cigar = rgb <125/255, 78/255, 56/255>;
#declare CN_Cigar_Box = rgb <156/255, 115/255, 81/255>;
#declare CN_Cigar_Smoke = rgb <120/255, 133/255, 122/255>;
#declare CN_Cigarette_Glow = rgb <238/255, 85/255, 0/255>;
#declare CN_Cilantro = rgb <67/255, 84/255, 75/255>;
#declare CN_Cilantro_Cream = rgb <206/255, 203/255, 174/255>;
#declare CN_Cimarron = rgb <107/255, 61/255, 56/255>;
#declare CN_Cinder = rgb <36/255, 42/255, 46/255>;
#declare CN_Cinderella = rgb <251/255, 215/255, 204/255>;
#declare CN_Cinderella_Pink = rgb <255/255, 198/255, 196/255>;
#declare CN_Cinema_Screen = rgb <149/255, 135/255, 142/255>;
#declare CN_Cinereous = rgb <152/255, 129/255, 123/255>;
#declare CN_Cinnabar = rgb <115/255, 1/255, 19/255>;
#declare CN_Cinnabark = rgb <99/255, 77/255, 69/255>;
#declare CN_Cinnamon = rgb <210/255, 105/255, 17/255>;
#declare CN_Cinnamon_Brandy = rgb <207/255, 141/255, 108/255>;
#declare CN_Cinnamon_Brown = rgb <158/255, 106/255, 25/255>;
#declare CN_Cinnamon_Bun = rgb <172/255, 79/255, 6/255>;
#declare CN_Cinnamon_Cake = rgb <232/255, 221/255, 207/255>;
#declare CN_Cinnamon_Candle = rgb <177/255, 93/255, 99/255>;
#declare CN_Cinnamon_Cherry = rgb <121/255, 67/255, 68/255>;
#declare CN_Cinnamon_Cocoa = rgb <209/255, 167/255, 156/255>;
#declare CN_Cinnamon_Crumble = rgb <112/255, 87/255, 66/255>;
#declare CN_Cinnamon_Crunch = rgb <163/255, 125/255, 90/255>;
#declare CN_Cinnamon_Diamonds = rgb <169/255, 118/255, 115/255>;
#declare CN_Cinnamon_Frost = rgb <211/255, 177/255, 145/255>;
#declare CN_Cinnamon_Ice = rgb <219/255, 187/255, 167/255>;
#declare CN_Cinnamon_Milk = rgb <235/255, 218/255, 181/255>;
#declare CN_Cinnamon_Roast = rgb <187/255, 153/255, 136/255>;
#declare CN_Cinnamon_Roll = rgb <192/255, 115/255, 122/255>;
#declare CN_Cinnamon_Sand = rgb <183/255, 129/255, 83/255>;
#declare CN_Cinnamon_Satin = rgb <205/255, 96/255, 126/255>;
#declare CN_Cinnamon_Spice = rgb <147/255, 95/255, 67/255>;
#declare CN_Cinnamon_Stick = rgb <155/255, 71/255, 34/255>;
#declare CN_Cinnamon_Stone = rgb <201/255, 84/255, 58/255>;
#declare CN_Cinnamon_Tea = rgb <222/255, 192/255, 173/255>;
#declare CN_Cinnamon_Toast = rgb <141/255, 125/255, 119/255>;
#declare CN_Cinnamon_Twist = rgb <159/255, 114/255, 80/255>;
#declare CN_Cinnamon_Whip = rgb <218/255, 178/255, 164/255>;
#declare CN_Cinnapink = rgb <166/255, 100/255, 111/255>;
#declare CN_Cinque_Foil = rgb <255/255, 255/255, 136/255>;
#declare CN_Cioccolato = rgb <93/255, 59/255, 46/255>;
#declare CN_Cipher = rgb <170/255, 118/255, 145/255>;
#declare CN_Cipollino = rgb <200/255, 206/255, 195/255>;
#declare CN_Circumorbital_Ring = rgb <98/255, 88/255, 196/255>;
#declare CN_Circus = rgb <252/255, 94/255, 48/255>;
#declare CN_Circus_Peanut = rgb <173/255, 131/255, 92/255>;
#declare CN_Circus_Red = rgb <149/255, 74/255, 76/255>;
#declare CN_Cistern = rgb <169/255, 176/255, 182/255>;
#declare CN_Citadel = rgb <116/255, 137/255, 149/255>;
#declare CN_Citadel_Blue = rgb <158/255, 171/255, 173/255>;
#declare CN_Citrine = rgb <228/255, 208/255, 10/255>;
#declare CN_Citrine_Brown = rgb <147/255, 55/255, 9/255>;
#declare CN_Citrine_White = rgb <250/255, 247/255, 214/255>;
#declare CN_Citrino = rgb <233/255, 232/255, 155/255>;
#declare CN_Citron = rgb <213/255, 199/255, 87/255>;
#declare CN_Citron_Goby = rgb <222/255, 255/255, 0/255>;
#declare CN_Citronella = rgb <102/255, 187/255, 119/255>;
#declare CN_Citronelle = rgb <184/255, 175/255, 35/255>;
#declare CN_Citronette = rgb <196/255, 170/255, 39/255>;
#declare CN_Citronne = rgb <205/255, 156/255, 43/255>;
#declare CN_Citrus = rgb <159/255, 183/255, 10/255>;
#declare CN_Citrus_Blast = rgb <225/255, 121/255, 58/255>;
#declare CN_Citrus_Butter = rgb <228/255, 222/255, 142/255>;
#declare CN_Citrus_Delight = rgb <208/255, 213/255, 87/255>;
#declare CN_Citrus_Hill = rgb <249/255, 167/255, 141/255>;
#declare CN_Citrus_Honey = rgb <246/255, 185/255, 107/255>;
#declare CN_Citrus_Leaf = rgb <179/255, 209/255, 87/255>;
#declare CN_Citrus_Lime = rgb <195/255, 220/255, 104/255>;
#declare CN_Citrus_Mist = rgb <247/255, 237/255, 222/255>;
#declare CN_Citrus_Notes = rgb <210/255, 102/255, 67/255>;
#declare CN_Citrus_Peel = rgb <183/255, 187/255, 107/255>;
#declare CN_Citrus_Punch = rgb <253/255, 234/255, 131/255>;
#declare CN_Citrus_Sachet = rgb <242/255, 198/255, 167/255>;
#declare CN_Citrus_Spice = rgb <226/255, 205/255, 82/255>;
#declare CN_Citrus_Splash = rgb <255/255, 196/255, 0/255>;
#declare CN_Citrus_Sugar = rgb <230/255, 217/255, 67/255>;
#declare CN_Citrus_Yellow = rgb <215/255, 194/255, 117/255>;
#declare CN_Citrus_Zest = rgb <237/255, 200/255, 90/255>;
#declare CN_City_Bench = rgb <103/255, 92/255, 73/255>;
#declare CN_City_Brume = rgb <224/255, 224/255, 220/255>;
#declare CN_City_Dweller = rgb <192/255, 185/255, 172/255>;
#declare CN_City_Hunter_Blue = rgb <0/255, 34/255, 170/255>;
#declare CN_City_Lights = rgb <223/255, 230/255, 234/255>;
#declare CN_City_Loft = rgb <167/255, 155/255, 138/255>;
#declare CN_City_of_Bridges = rgb <179/255, 173/255, 164/255>;
#declare CN_City_of_Diamonds = rgb <250/255, 230/255, 203/255>;
#declare CN_City_of_Pink_Angels = rgb <230/255, 180/255, 166/255>;
#declare CN_City_Rain = rgb <82/255, 92/255, 97/255>;
#declare CN_City_Roast = rgb <102/255, 51/255, 51/255>;
#declare CN_City_Street = rgb <186/255, 178/255, 171/255>;
#declare CN_City_Sunrise = rgb <209/255, 166/255, 125/255>;
#declare CN_City_Tower = rgb <174/255, 171/255, 165/255>;
#declare CN_Cityscape = rgb <218/255, 227/255, 231/255>;
#declare CN_Civara = rgb <197/255, 97/255, 56/255>;
#declare CN_Clair_De_Lune = rgb <219/255, 233/255, 223/255>;
#declare CN_Clairvoyance = rgb <131/255, 132/255, 147/255>;
#declare CN_Clairvoyant = rgb <72/255, 6/255, 86/255>;
#declare CN_Clam = rgb <218/255, 209/255, 192/255>;
#declare CN_Clam_Chowder = rgb <244/255, 217/255, 175/255>;
#declare CN_Clam_Shell = rgb <210/255, 179/255, 169/255>;
#declare CN_Clam_Up = rgb <235/255, 219/255, 193/255>;
#declare CN_Clambake = rgb <224/255, 209/255, 187/255>;
#declare CN_Clamshell = rgb <237/255, 208/255, 182/255>;
#declare CN_Claret = rgb <104/255, 0/255, 24/255>;
#declare CN_Claret_Red = rgb <200/255, 76/255, 97/255>;
#declare CN_Clarified_Butter = rgb <230/255, 156/255, 35/255>;
#declare CN_Clarified_Orange = rgb <254/255, 161/255, 91/255>;
#declare CN_Clarinet = rgb <0/255, 34/255, 85/255>;
#declare CN_Clarity = rgb <234/255, 240/255, 224/255>;
#declare CN_Clary = rgb <104/255, 73/255, 118/255>;
#declare CN_Clary_Sage = rgb <199/255, 192/255, 206/255>;
#declare CN_Classic = rgb <187/255, 170/255, 161/255>;
#declare CN_Classic_Avocado = rgb <110/255, 112/255, 66/255>;
#declare CN_Classic_Berry = rgb <124/255, 82/255, 97/255>;
#declare CN_Classic_Blue = rgb <15/255, 76/255, 129/255>;
#declare CN_Classic_Bouquet = rgb <163/255, 139/255, 191/255>;
#declare CN_Classic_Bronze = rgb <109/255, 98/255, 78/255>;
#declare CN_Classic_Brown = rgb <106/255, 73/255, 61/255>;
#declare CN_Classic_Calm = rgb <107/255, 136/255, 133/255>;
#declare CN_Classic_Chalk = rgb <244/255, 244/255, 240/255>;
#declare CN_Classic_Cherry = rgb <151/255, 65/255, 70/255>;
#declare CN_Classic_Cloud = rgb <145/255, 151/255, 163/255>;
#declare CN_Classic_Cool = rgb <183/255, 178/255, 172/255>;
#declare CN_Classic_French_Gray = rgb <136/255, 135/255, 130/255>;
#declare CN_Classic_Gold = rgb <201/255, 163/255, 103/255>;
#declare CN_Classic_Green = rgb <57/255, 168/255, 69/255>;
#declare CN_Classic_Ivory = rgb <242/255, 224/255, 195/255>;
#declare CN_Classic_Light_Buff = rgb <240/255, 234/255, 220/255>;
#declare CN_Classic_Olive = rgb <104/255, 94/255, 63/255>;
#declare CN_Classic_Rose = rgb <251/255, 204/255, 231/255>;
#declare CN_Classic_Sand = rgb <214/255, 188/255, 170/255>;
#declare CN_Classic_Silver = rgb <185/255, 185/255, 180/255>;
#declare CN_Classic_Taupe = rgb <211/255, 188/255, 164/255>;
#declare CN_Classic_Terra = rgb <228/255, 206/255, 174/255>;
#declare CN_Classic_Waltz = rgb <113/255, 88/255, 141/255>;
#declare CN_Classical_Gold = rgb <235/255, 184/255, 117/255>;
#declare CN_Classical_White = rgb <236/255, 225/255, 203/255>;
#declare CN_Classical_Yellow = rgb <248/255, 212/255, 146/255>;
#declare CN_Classy = rgb <174/255, 172/255, 173/255>;
#declare CN_Classy_Mauve = rgb <187/255, 153/255, 170/255>;
#declare CN_Classy_Plum = rgb <136/255, 126/255, 130/255>;
#declare CN_Classy_Red = rgb <145/255, 31/255, 33/255>;
#declare CN_Clay = rgb <182/255, 106/255, 80/255>;
#declare CN_Clay_Ash = rgb <189/255, 200/255, 179/255>;
#declare CN_Clay_Bake = rgb <225/255, 198/255, 143/255>;
#declare CN_Clay_Bath = rgb <138/255, 125/255, 105/255>;
#declare CN_Clay_Beige = rgb <213/255, 209/255, 195/255>;
#declare CN_Clay_Brown = rgb <178/255, 113/255, 61/255>;
#declare CN_Clay_Court = rgb <169/255, 118/255, 93/255>;
#declare CN_Clay_Creek = rgb <137/255, 126/255, 89/255>;
#declare CN_Clay_Dust = rgb <248/255, 220/255, 163/255>;
#declare CN_Clay_Fire = rgb <216/255, 166/255, 134/255>;
#declare CN_Clay_Ground = rgb <189/255, 133/255, 108/255>;
#declare CN_Clay_Mug = rgb <211/255, 121/255, 89/255>;
#declare CN_Clay_Ochre = rgb <174/255, 137/255, 93/255>;
#declare CN_Clay_Pebble = rgb <189/255, 178/255, 152/255>;
#declare CN_Clay_Pipe = rgb <217/255, 200/255, 183/255>;
#declare CN_Clay_Play = rgb <119/255, 68/255, 51/255>;
#declare CN_Clay_Pot = rgb <195/255, 102/255, 63/255>;
#declare CN_Clay_Red = rgb <175/255, 96/255, 77/255>;
#declare CN_Clay_Ridge = rgb <149/255, 106/255, 102/255>;
#declare CN_Clay_Slate_Wacke = rgb <205/255, 202/255, 206/255>;
#declare CN_Clay_Terrace = rgb <212/255, 130/255, 60/255>;
#declare CN_Clayton = rgb <131/255, 117/255, 108/255>;
#declare CN_Clean_Air = rgb <216/255, 221/255, 182/255>;
#declare CN_Clean_Canvas = rgb <246/255, 233/255, 211/255>;
#declare CN_Clean_Green = rgb <143/255, 224/255, 198/255>;
#declare CN_Clean_N_Crisp = rgb <208/255, 231/255, 152/255>;
#declare CN_Clean_Slate = rgb <87/255, 115/255, 150/255>;
#declare CN_Clear_Aqua = rgb <196/255, 234/255, 224/255>;
#declare CN_Clear_Blue = rgb <36/255, 122/255, 253/255>;
#declare CN_Clear_Brook = rgb <96/255, 148/255, 155/255>;
#declare CN_Clear_Calamine = rgb <246/255, 230/255, 228/255>;
#declare CN_Clear_Camouflage_Green = rgb <218/255, 232/255, 225/255>;
#declare CN_Clear_Chill = rgb <30/255, 144/255, 255/255>;
#declare CN_Clear_Cinnamon = rgb <223/255, 219/255, 216/255>;
#declare CN_Clear_Concrete = rgb <186/255, 182/255, 178/255>;
#declare CN_Clear_Day = rgb <223/255, 239/255, 234/255>;
#declare CN_Clear_Green = rgb <18/255, 115/255, 43/255>;
#declare CN_Clear_Lake_Trail = rgb <163/255, 187/255, 218/255>;
#declare CN_Clear_Mauve = rgb <118/255, 108/255, 176/255>;
#declare CN_Clear_Moon = rgb <250/255, 246/255, 234/255>;
#declare CN_Clear_Orange = rgb <238/255, 136/255, 0/255>;
#declare CN_Clear_Plum = rgb <100/255, 0/255, 94/255>;
#declare CN_Clear_Pond = rgb <180/255, 204/255, 203/255>;
#declare CN_Clear_Purple = rgb <65/255, 42/255, 122/255>;
#declare CN_Clear_Red = rgb <206/255, 38/255, 28/255>;
#declare CN_Clear_Sand = rgb <234/255, 231/255, 218/255>;
#declare CN_Clear_Skies = rgb <232/255, 247/255, 253/255>;
#declare CN_Clear_Turquoise = rgb <0/255, 138/255, 129/255>;
#declare CN_Clear_View = rgb <226/255, 234/255, 231/255>;
#declare CN_Clear_Viridian = rgb <54/255, 117/255, 136/255>;
#declare CN_Clear_Vision = rgb <231/255, 240/255, 247/255>;
#declare CN_Clear_Vista = rgb <163/255, 190/255, 196/255>;
#declare CN_Clear_Water = rgb <170/255, 213/255, 219/255>;
#declare CN_Clear_Weather = rgb <102/255, 187/255, 221/255>;
#declare CN_Clear_Yellow = rgb <241/255, 241/255, 230/255>;
#declare CN_Clearly_Aqua = rgb <206/255, 225/255, 212/255>;
#declare CN_Clearview = rgb <251/255, 251/255, 229/255>;
#declare CN_Clematis = rgb <126/255, 101/255, 150/255>;
#declare CN_Clematis_Blue = rgb <54/255, 59/255, 124/255>;
#declare CN_Clematis_Green = rgb <152/255, 182/255, 82/255>;
#declare CN_Clematis_Magenta = rgb <224/255, 90/255, 236/255>;
#declare CN_Clementine = rgb <233/255, 110/255, 0/255>;
#declare CN_Clementine_Jelly = rgb <255/255, 173/255, 1/255>;
#declare CN_Cleos_Bath = rgb <0/255, 80/255, 127/255>;
#declare CN_Cleopatra = rgb <0/255, 117/255, 144/255>;
#declare CN_Cleopatras_Gown = rgb <121/255, 80/255, 136/255>;
#declare CN_Clichy_White = rgb <246/255, 235/255, 238/255>;
#declare CN_Cliff_Brown = rgb <208/255, 171/255, 140/255>;
#declare CN_Cliff_Ridge = rgb <197/255, 174/255, 128/255>;
#declare CN_Cliff_Rock = rgb <177/255, 148/255, 117/255>;
#declare CN_Cliff_Swallow = rgb <236/255, 221/255, 212/255>;
#declare CN_Cliffs_View = rgb <221/255, 197/255, 170/255>;
#declare CN_Cliffside_Park = rgb <111/255, 129/255, 101/255>;
#declare CN_Climate_Change = rgb <229/255, 225/255, 205/255>;
#declare CN_Climate_Control = rgb <70/255, 96/255, 130/255>;
#declare CN_Climbing_Ivy = rgb <88/255, 113/255, 74/255>;
#declare CN_Clinical_Soft_Blue = rgb <178/255, 207/255, 211/255>;
#declare CN_Clinker = rgb <70/255, 54/255, 35/255>;
#declare CN_Clinker_Red = rgb <102/255, 49/255, 69/255>;
#declare CN_Clipped_Grass = rgb <161/255, 184/255, 65/255>;
#declare CN_Clippership_Twill = rgb <166/255, 147/255, 125/255>;
#declare CN_Cloak_and_Dagger = rgb <85/255, 0/255, 85/255>;
#declare CN_Cloak_Gray = rgb <96/255, 94/255, 99/255>;
#declare CN_Clock_Chimes_Thirteen = rgb <0/255, 34/255, 17/255>;
#declare CN_Clockworks = rgb <114/255, 87/255, 61/255>;
#declare CN_Cloisonne = rgb <0/255, 117/255, 175/255>;
#declare CN_Cloisonne_Blue = rgb <132/255, 161/255, 173/255>;
#declare CN_Cloistered_Garden = rgb <153/255, 176/255, 144/255>;
#declare CN_Clooney = rgb <95/255, 108/255, 132/255>;
#declare CN_Close_Knit = rgb <213/255, 214/255, 207/255>;
#declare CN_Closed_Shutter = rgb <37/255, 37/255, 44/255>;
#declare CN_Clotted_Cream = rgb <243/255, 239/255, 205/255>;
#declare CN_Clotted_Red = rgb <153/255, 17/255, 21/255>;
#declare CN_Cloud_Abyss = rgb <223/255, 231/255, 235/255>;
#declare CN_Cloud_Blue = rgb <162/255, 182/255, 185/255>;
#declare CN_Cloud_Burst = rgb <137/255, 156/255, 150/255>;
#declare CN_Cloud_Cream = rgb <230/255, 221/255, 197/255>;
#declare CN_Cloud_Dancer = rgb <240/255, 238/255, 233/255>;
#declare CN_Cloud_Grey = rgb <184/255, 169/255, 175/255>;
#declare CN_Cloud_Nine = rgb <233/255, 224/255, 219/255>;
#declare CN_Cloud_Number_Nine = rgb <249/255, 206/255, 198/255>;
#declare CN_Cloud_Over_London = rgb <194/255, 188/255, 177/255>;
#declare CN_Cloud_Pink = rgb <245/255, 209/255, 200/255>;
#declare CN_Cloud_White = rgb <242/255, 242/255, 237/255>;
#declare CN_Cloudberry = rgb <255/255, 161/255, 104/255>;
#declare CN_Cloudburst = rgb <131/255, 127/255, 127/255>;
#declare CN_Clouded_Blue = rgb <31/255, 117/255, 254/255>;
#declare CN_Clouded_Sky = rgb <125/255, 147/255, 162/255>;
#declare CN_Clouded_Vision = rgb <209/255, 208/255, 209/255>;
#declare CN_Cloudless = rgb <214/255, 234/255, 252/255>;
#declare CN_Cloudless_Day = rgb <154/255, 177/255, 191/255>;
#declare CN_Cloudy = rgb <216/255, 215/255, 211/255>;
#declare CN_Cloudy_Blue = rgb <172/255, 194/255, 217/255>;
#declare CN_Cloudy_Camouflage = rgb <23/255, 114/255, 69/255>;
#declare CN_Cloudy_Carrot = rgb <255/255, 168/255, 18/255>;
#declare CN_Cloudy_Cinnamon = rgb <135/255, 113/255, 95/255>;
#declare CN_Cloudy_Day = rgb <223/255, 230/255, 218/255>;
#declare CN_Cloudy_Desert = rgb <176/255, 169/255, 159/255>;
#declare CN_Cloudy_Grey = rgb <236/255, 227/255, 225/255>;
#declare CN_Cloudy_Plum = rgb <157/255, 122/255, 172/255>;
#declare CN_Cloudy_Sea = rgb <102/255, 153/255, 170/255>;
#declare CN_Cloudy_Sky = rgb <194/255, 213/255, 218/255>;
#declare CN_Cloudy_Today = rgb <166/255, 160/255, 150/255>;
#declare CN_Cloudy_Viridian = rgb <75/255, 95/255, 86/255>;
#declare CN_Clove = rgb <135/255, 97/255, 85/255>;
#declare CN_Clove_Brown = rgb <118/255, 96/255, 81/255>;
#declare CN_Clove_Dye = rgb <169/255, 98/255, 50/255>;
#declare CN_Clove_Yellow_Brown = rgb <82/255, 63/255, 33/255>;
#declare CN_Clovedust = rgb <176/255, 112/255, 93/255>;
#declare CN_Clover = rgb <0/255, 143/255, 0/255>;
#declare CN_Clover_Brook = rgb <28/255, 106/255, 83/255>;
#declare CN_Clover_Green = rgb <0/255, 108/255, 68/255>;
#declare CN_Clover_Honey = rgb <240/255, 226/255, 188/255>;
#declare CN_Clover_Mist = rgb <111/255, 194/255, 136/255>;
#declare CN_Clover_Patch = rgb <74/255, 157/255, 91/255>;
#declare CN_Clover_Pink = rgb <205/255, 155/255, 196/255>;
#declare CN_Clown_Green = rgb <196/255, 208/255, 86/255>;
#declare CN_Clown_Nose = rgb <233/255, 66/255, 87/255>;
#declare CN_Club_Cruise = rgb <139/255, 195/255, 225/255>;
#declare CN_Club_Grey = rgb <70/255, 65/255, 89/255>;
#declare CN_Club_Mauve = rgb <131/255, 67/255, 112/255>;
#declare CN_Club_Moss = rgb <107/255, 151/255, 122/255>;
#declare CN_Club_Navy = rgb <62/255, 74/255, 84/255>;
#declare CN_Club_Soda = rgb <226/255, 237/255, 235/255>;
#declare CN_Club_Mate = rgb <248/255, 222/255, 126/255>;
#declare CN_Clumsy_Caramel = rgb <211/255, 182/255, 131/255>;
#declare CN_Clytemnestra = rgb <232/255, 226/255, 224/255>;
#declare CN_Co_Pilot = rgb <73/255, 120/255, 169/255>;
#declare CN_CO2 = rgb <202/255, 223/255, 236/255>;
#declare CN_Coach_Green = rgb <0/255, 53/255, 39/255>;
#declare CN_Coal_Mine = rgb <84/255, 85/255, 93/255>;
#declare CN_Coal_Miner = rgb <119/255, 120/255, 114/255>;
#declare CN_Coalmine = rgb <34/255, 0/255, 51/255>;
#declare CN_Coarse_Wool = rgb <24/255, 27/255, 38/255>;
#declare CN_Coast_Cream = rgb <246/255, 230/255, 219/255>;
#declare CN_Coastal_Beige = rgb <240/255, 235/255, 217/255>;
#declare CN_Coastal_Breeze = rgb <224/255, 246/255, 251/255>;
#declare CN_Coastal_Calm = rgb <83/255, 143/255, 148/255>;
#declare CN_Coastal_Crush = rgb <180/255, 192/255, 175/255>;
#declare CN_Coastal_Fjord = rgb <80/255, 93/255, 126/255>;
#declare CN_Coastal_Foam = rgb <176/255, 229/255, 201/255>;
#declare CN_Coastal_Fog = rgb <229/255, 232/255, 228/255>;
#declare CN_Coastal_Fringe = rgb <128/255, 185/255, 192/255>;
#declare CN_Coastal_Jetty = rgb <0/255, 110/255, 127/255>;
#declare CN_Coastal_Mist = rgb <210/255, 232/255, 236/255>;
#declare CN_Coastal_Plain = rgb <159/255, 166/255, 148/255>;
#declare CN_Coastal_Sand = rgb <201/255, 169/255, 133/255>;
#declare CN_Coastal_Storm = rgb <125/255, 128/255, 123/255>;
#declare CN_Coastal_Surf = rgb <45/255, 73/255, 130/255>;
#declare CN_Coastal_Trim = rgb <189/255, 255/255, 202/255>;
#declare CN_Coastal_Vista = rgb <130/255, 147/255, 160/255>;
#declare CN_Coastline_Trail = rgb <110/255, 108/255, 91/255>;
#declare CN_Coated = rgb <46/255, 47/255, 48/255>;
#declare CN_Cobalite = rgb <153/255, 153/255, 255/255>;
#declare CN_Cobalt = rgb <3/255, 10/255, 167/255>;
#declare CN_Cobalt_Flame = rgb <78/255, 113/255, 157/255>;
#declare CN_Cobalt_Glaze = rgb <0/255, 114/255, 181/255>;
#declare CN_Cobalt_Night = rgb <53/255, 55/255, 57/255>;
#declare CN_Cobalt_Stone = rgb <2/255, 100/255, 174/255>;
#declare CN_Cobble_Brown = rgb <122/255, 100/255, 85/255>;
#declare CN_Cobbler = rgb <196/255, 171/255, 125/255>;
#declare CN_Cobblestone = rgb <168/255, 154/255, 142/255>;
#declare CN_Cobblestone_Path = rgb <158/255, 135/255, 121/255>;
#declare CN_Cobblestone_Street = rgb <207/255, 199/255, 185/255>;
#declare CN_Cobra_Leather = rgb <176/255, 142/255, 8/255>;
#declare CN_Cobre = rgb <153/255, 101/255, 21/255>;
#declare CN_Cobrizo = rgb <181/255, 109/255, 93/255>;
#declare CN_Coca_Mocha = rgb <189/255, 157/255, 149/255>;
#declare CN_Cochin_Chicken = rgb <248/255, 184/255, 98/255>;
#declare CN_Cochineal_Red = rgb <122/255, 72/255, 72/255>;
#declare CN_Cochineal_Red_Rouge = rgb <157/255, 41/255, 51/255>;
#declare CN_Cochise = rgb <221/255, 205/255, 179/255>;
#declare CN_Cochonnet = rgb <255/255, 136/255, 187/255>;
#declare CN_Cockatoo = rgb <88/255, 200/255, 182/255>;
#declare CN_Cockatrice_Brown = rgb <164/255, 100/255, 34/255>;
#declare CN_Cockleshell = rgb <227/255, 198/255, 175/255>;
#declare CN_Cockscomb_Red = rgb <188/255, 83/255, 120/255>;
#declare CN_Cocktail_Blue = rgb <90/255, 122/255, 162/255>;
#declare CN_Cocktail_Green = rgb <142/255, 184/255, 38/255>;
#declare CN_Cocktail_Hour = rgb <253/255, 154/255, 82/255>;
#declare CN_Cocktail_Olive = rgb <159/255, 163/255, 108/255>;
#declare CN_Coco = rgb <209/255, 187/255, 161/255>;
#declare CN_Coco_Malt = rgb <228/255, 220/255, 201/255>;
#declare CN_Coco_Rum = rgb <155/255, 119/255, 87/255>;
#declare CN_Coco_Lemon_Tart = rgb <238/255, 221/255, 136/255>;
#declare CN_Cocoa = rgb <135/255, 95/255, 66/255>;
#declare CN_Cocoa_Bean = rgb <79/255, 56/255, 53/255>;
#declare CN_Cocoa_Berry = rgb <160/255, 136/255, 130/255>;
#declare CN_Cocoa_Brown = rgb <53/255, 40/255, 30/255>;
#declare CN_Cocoa_Butter = rgb <245/255, 244/255, 193/255>;
#declare CN_Cocoa_Craving = rgb <185/255, 163/255, 154/255>;
#declare CN_Cocoa_Cream = rgb <219/255, 200/255, 182/255>;
#declare CN_Cocoa_Cupcake = rgb <150/255, 120/255, 89/255>;
#declare CN_Cocoa_Delight = rgb <141/255, 114/255, 90/255>;
#declare CN_Cocoa_Milk = rgb <125/255, 103/255, 93/255>;
#declare CN_Cocoa_Nib = rgb <188/255, 159/255, 126/255>;
#declare CN_Cocoa_Nutmeg = rgb <168/255, 129/255, 111/255>;
#declare CN_Cocoa_Parfait = rgb <223/255, 206/255, 194/255>;
#declare CN_Cocoa_Pecan = rgb <150/255, 123/255, 93/255>;
#declare CN_Cocoa_Powder = rgb <118/255, 106/255, 95/255>;
#declare CN_Cocoa_Shell = rgb <126/255, 102/255, 87/255>;
#declare CN_Cocoa_Whip = rgb <160/255, 142/255, 126/255>;
#declare CN_Cocobolo = rgb <120/255, 72/255, 72/255>;
#declare CN_Cocoloco = rgb <170/255, 143/255, 122/255>;
#declare CN_Coconut = rgb <150/255, 90/255, 62/255>;
#declare CN_Coconut_Aroma = rgb <238/255, 238/255, 221/255>;
#declare CN_Coconut_Butter = rgb <242/255, 239/255, 225/255>;
#declare CN_Coconut_Cream = rgb <225/255, 218/255, 187/255>;
#declare CN_Coconut_Crumble = rgb <226/255, 206/255, 166/255>;
#declare CN_Coconut_Grove = rgb <103/255, 109/255, 67/255>;
#declare CN_Coconut_Husk = rgb <125/255, 96/255, 68/255>;
#declare CN_Coconut_Ice = rgb <221/255, 212/255, 199/255>;
#declare CN_Coconut_Macaroon = rgb <218/255, 202/255, 192/255>;
#declare CN_Coconut_Milk = rgb <240/255, 237/255, 229/255>;
#declare CN_Coconut_Pulp = rgb <251/255, 249/255, 225/255>;
#declare CN_Coconut_Shell = rgb <145/255, 122/255, 86/255>;
#declare CN_Coconut_Twist = rgb <247/255, 241/255, 225/255>;
#declare CN_Coconut_White = rgb <233/255, 237/255, 246/255>;
#declare CN_Cocoon = rgb <222/255, 219/255, 204/255>;
#declare CN_Cod_Grey = rgb <45/255, 48/255, 50/255>;
#declare CN_Codex_Grey = rgb <156/255, 156/255, 156/255>;
#declare CN_Codium_Fragile = rgb <82/255, 75/255, 42/255>;
#declare CN_Codman_Claret = rgb <140/255, 64/255, 64/255>;
#declare CN_Coelia_Greenshade = rgb <14/255, 127/255, 120/255>;
#declare CN_Coelin_Blue = rgb <73/255, 125/255, 147/255>;
#declare CN_Coffee = rgb <111/255, 78/255, 55/255>;
#declare CN_Coffee_Addiction = rgb <136/255, 51/255, 0/255>;
#declare CN_Coffee_Adept = rgb <119/255, 85/255, 17/255>;
#declare CN_Coffee_Bag = rgb <219/255, 214/255, 211/255>;
#declare CN_Coffee_Bar = rgb <130/255, 92/255, 67/255>;
#declare CN_Coffee_Bean = rgb <54/255, 45/255, 38/255>;
#declare CN_Coffee_Bean_Brown = rgb <118/255, 86/255, 64/255>;
#declare CN_Coffee_Beans = rgb <110/255, 84/255, 75/255>;
#declare CN_Coffee_Clay = rgb <183/255, 153/255, 124/255>;
#declare CN_Coffee_Cream = rgb <255/255, 242/255, 215/255>;
#declare CN_Coffee_Custard = rgb <171/255, 155/255, 156/255>;
#declare CN_Coffee_Diva = rgb <190/255, 168/255, 141/255>;
#declare CN_Coffee_House = rgb <108/255, 91/255, 77/255>;
#declare CN_Coffee_Kiss = rgb <177/255, 149/255, 118/255>;
#declare CN_Coffee_Liqueur = rgb <106/255, 81/255, 59/255>;
#declare CN_Coffee_Rose = rgb <169/255, 137/255, 141/255>;
#declare CN_Coffee_Shop = rgb <114/255, 80/255, 66/255>;
#declare CN_Coffee_With_Cream = rgb <166/255, 137/255, 102/255>;
#declare CN_Cognac = rgb <212/255, 140/255, 70/255>;
#declare CN_Cognac_Brown = rgb <185/255, 133/255, 99/255>;
#declare CN_Cogswell_Cedar = rgb <144/255, 83/255, 74/255>;
#declare CN_Coin_Purse = rgb <224/255, 213/255, 227/255>;
#declare CN_Coin_Slot = rgb <255/255, 68/255, 17/255>;
#declare CN_Coincidence = rgb <199/255, 222/255, 136/255>;
#declare CN_Cola = rgb <60/255, 47/255, 35/255>;
#declare CN_Cola_Bubble = rgb <60/255, 48/255, 36/255>;
#declare CN_Cold_Air_Turquoise = rgb <193/255, 220/255, 219/255>;
#declare CN_Cold_Blooded = rgb <187/255, 238/255, 238/255>;
#declare CN_Cold_Blue = rgb <136/255, 221/255, 221/255>;
#declare CN_Cold_Brew_Coffee = rgb <120/255, 87/255, 54/255>;
#declare CN_Cold_Canada = rgb <219/255, 255/255, 254/255>;
#declare CN_Cold_Current = rgb <35/255, 66/255, 114/255>;
#declare CN_Cold_Foam = rgb <239/255, 236/255, 227/255>;
#declare CN_Cold_Front_Green = rgb <133/255, 179/255, 178/255>;
#declare CN_Cold_Green = rgb <0/255, 139/255, 60/255>;
#declare CN_Cold_Grey = rgb <159/255, 159/255, 159/255>;
#declare CN_Cold_Heights = rgb <34/255, 221/255, 238/255>;
#declare CN_Cold_Light = rgb <221/255, 227/255, 230/255>;
#declare CN_Cold_Light_of_Day = rgb <0/255, 238/255, 238/255>;
#declare CN_Cold_Lips = rgb <155/255, 160/255, 239/255>;
#declare CN_Cold_Morning = rgb <230/255, 229/255, 228/255>;
#declare CN_Cold_North = rgb <85/255, 156/255, 155/255>;
#declare CN_Cold_Pack = rgb <0/255, 51/255, 221/255>;
#declare CN_Cold_Pilsner = rgb <208/255, 147/255, 81/255>;
#declare CN_Cold_Pink = rgb <188/255, 165/255, 173/255>;
#declare CN_Cold_Purple = rgb <157/255, 138/255, 191/255>;
#declare CN_Cold_Sea_Currents = rgb <50/255, 84/255, 94/255>;
#declare CN_Cold_Shoulder = rgb <212/255, 224/255, 239/255>;
#declare CN_Cold_Soft_Blue = rgb <217/255, 231/255, 230/255>;
#declare CN_Cold_Spring = rgb <136/255, 187/255, 102/255>;
#declare CN_Cold_Steel = rgb <38/255, 35/255, 53/255>;
#declare CN_Cold_Turbulence = rgb <207/255, 225/255, 239/255>;
#declare CN_Cold_Turkey = rgb <202/255, 181/255, 178/255>;
#declare CN_Cold_Turquoise = rgb <165/255, 208/255, 203/255>;
#declare CN_Cold_Water = rgb <217/255, 223/255, 224/255>;
#declare CN_Cold_Wave = rgb <194/255, 226/255, 227/255>;
#declare CN_Cold_Well_Water = rgb <193/255, 226/255, 227/255>;
#declare CN_Cold_White = rgb <237/255, 252/255, 251/255>;
#declare CN_Cold_Wind = rgb <225/255, 227/255, 228/255>;
#declare CN_Cold_Winters_Morn = rgb <180/255, 188/255, 209/255>;
#declare CN_Coliseum_Marble = rgb <206/255, 200/255, 182/255>;
#declare CN_Collard_Green = rgb <83/255, 104/255, 97/255>;
#declare CN_Collectible = rgb <155/255, 132/255, 103/255>;
#declare CN_Colleen_Green = rgb <235/255, 236/255, 218/255>;
#declare CN_Collensia = rgb <189/255, 183/255, 205/255>;
#declare CN_Cologne = rgb <117/255, 191/255, 210/255>;
#declare CN_Colombo_Red_Mauve = rgb <186/255, 122/255, 179/255>;
#declare CN_Colonel_Mustard = rgb <182/255, 130/255, 56/255>;
#declare CN_Colonial_Aqua = rgb <161/255, 189/255, 191/255>;
#declare CN_Colonial_Blue = rgb <45/255, 100/255, 113/255>;
#declare CN_Colonial_Brick = rgb <173/255, 105/255, 97/255>;
#declare CN_Colonial_Revival_Gray = rgb <180/255, 185/255, 185/255>;
#declare CN_Colonial_Revival_Green_Stone = rgb <163/255, 155/255, 126/255>;
#declare CN_Colonial_Revival_Sea_Green = rgb <174/255, 190/255, 166/255>;
#declare CN_Colonial_Revival_Stone = rgb <167/255, 148/255, 124/255>;
#declare CN_Colonial_Revival_Tan = rgb <211/255, 182/255, 153/255>;
#declare CN_Colonial_Rose = rgb <231/255, 182/255, 188/255>;
#declare CN_Colonial_White = rgb <255/255, 237/255, 188/255>;
#declare CN_Colonial_Yellow = rgb <239/255, 196/255, 136/255>;
#declare CN_Colonnade_Gray = rgb <198/255, 192/255, 182/255>;
#declare CN_Colonnade_Grey = rgb <178/255, 177/255, 173/255>;
#declare CN_Colony = rgb <103/255, 161/255, 149/255>;
#declare CN_Colony_Blue = rgb <101/255, 118/255, 154/255>;
#declare CN_Colony_Buff = rgb <221/255, 198/255, 171/255>;
#declare CN_Color_Blind = rgb <198/255, 210/255, 222/255>;
#declare CN_Color_Me_Green = rgb <124/255, 183/255, 123/255>;
#declare CN_Colorado_Bronze = rgb <238/255, 119/255, 102/255>;
#declare CN_Colorado_Dawn = rgb <224/255, 156/255, 171/255>;
#declare CN_Colorado_Peach = rgb <230/255, 153/255, 76/255>;
#declare CN_Colorado_Peak = rgb <156/255, 155/255, 167/255>;
#declare CN_Colorado_Springs = rgb <136/255, 170/255, 196/255>;
#declare CN_Colorado_Trail = rgb <180/255, 147/255, 117/255>;
#declare CN_Colorful_Leaves = rgb <170/255, 92/255, 67/255>;
#declare CN_Colossus = rgb <98/255, 92/255, 145/255>;
#declare CN_Columbia = rgb <0/255, 146/255, 136/255>;
#declare CN_Columbia_Blue = rgb <155/255, 221/255, 255/255>;
#declare CN_Columbine = rgb <245/255, 218/255, 227/255>;
#declare CN_Columbos_Coat = rgb <208/255, 203/255, 206/255>;
#declare CN_Columbus = rgb <95/255, 117/255, 143/255>;
#declare CN_Column_Of_Oak_Green = rgb <0/255, 111/255, 55/255>;
#declare CN_Colusa_Wetlands = rgb <127/255, 114/255, 92/255>;
#declare CN_Combed_Cotton = rgb <244/255, 240/255, 222/255>;
#declare CN_Come_Sail_Away = rgb <92/255, 146/255, 197/255>;
#declare CN_Comet = rgb <99/255, 99/255, 115/255>;
#declare CN_Comfort = rgb <227/255, 206/255, 184/255>;
#declare CN_Comfort_Gray = rgb <190/255, 195/255, 187/255>;
#declare CN_Comforting = rgb <214/255, 192/255, 171/255>;
#declare CN_Comforting_Cherry = rgb <204/255, 17/255, 68/255>;
#declare CN_Comforting_Green = rgb <213/255, 224/255, 207/255>;
#declare CN_Comforting_Grey = rgb <197/255, 195/255, 180/255>;
#declare CN_Comfrey = rgb <91/255, 121/255, 97/255>;
#declare CN_Comfy_Beige = rgb <227/255, 210/255, 182/255>;
#declare CN_Comical_Coral = rgb <243/255, 209/255, 200/255>;
#declare CN_Coming_up_Roses = rgb <222/255, 116/255, 133/255>;
#declare CN_Commandes = rgb <11/255, 89/255, 124/255>;
#declare CN_Commercial_White = rgb <237/255, 236/255, 230/255>;
#declare CN_Commodore = rgb <37/255, 71/255, 106/255>;
#declare CN_Common_Chalcedony = rgb <200/255, 173/255, 127/255>;
#declare CN_Common_Chestnut = rgb <205/255, 92/255, 92/255>;
#declare CN_Common_Dandelion = rgb <254/255, 216/255, 93/255>;
#declare CN_Common_Feldspar = rgb <133/255, 143/255, 148/255>;
#declare CN_Common_Jasper = rgb <148/255, 105/255, 67/255>;
#declare CN_Common_Teal = rgb <0/255, 145/255, 147/255>;
#declare CN_Communist = rgb <204/255, 0/255, 0/255>;
#declare CN_Community = rgb <208/255, 185/255, 151/255>;
#declare CN_Como = rgb <76/255, 120/255, 92/255>;
#declare CN_Compact_Disc_Grey = rgb <205/255, 205/255, 205/255>;
#declare CN_Compass = rgb <138/255, 135/255, 123/255>;
#declare CN_Compass_Blue = rgb <53/255, 71/255, 91/255>;
#declare CN_Compatible_Cream = rgb <232/255, 200/255, 158/255>;
#declare CN_Complex_Grey = rgb <132/255, 121/255, 117/255>;
#declare CN_Composed = rgb <187/255, 200/255, 178/255>;
#declare CN_Composers_Magic = rgb <122/255, 110/255, 126/255>;
#declare CN_Composite_Artefact_Green = rgb <85/255, 204/255, 0/255>;
#declare CN_Concealed_Green = rgb <38/255, 49/255, 48/255>;
#declare CN_Concealment = rgb <64/255, 88/255, 82/255>;
#declare CN_Concept_Beige = rgb <213/255, 189/255, 163/255>;
#declare CN_Conceptual = rgb <122/255, 195/255, 79/255>;
#declare CN_Concerto = rgb <158/255, 107/255, 117/255>;
#declare CN_Conch = rgb <160/255, 177/255, 174/255>;
#declare CN_Conch_Pink = rgb <219/255, 164/255, 150/255>;
#declare CN_Conch_Shell = rgb <252/255, 143/255, 155/255>;
#declare CN_Conclave = rgb <171/255, 185/255, 215/255>;
#declare CN_Concord = rgb <130/255, 127/255, 121/255>;
#declare CN_Concord_Buff = rgb <226/255, 206/255, 176/255>;
#declare CN_Concord_Grape = rgb <124/255, 83/255, 121/255>;
#declare CN_Concord_Jam = rgb <105/255, 90/255, 130/255>;
#declare CN_Concrete = rgb <210/255, 209/255, 205/255>;
#declare CN_Concrete_Jungle = rgb <153/255, 153/255, 136/255>;
#declare CN_Concrete_Sidewalk = rgb <141/255, 138/255, 129/255>;
#declare CN_Condiment = rgb <185/255, 129/255, 66/255>;
#declare CN_Conditioner = rgb <255/255, 255/255, 204/255>;
#declare CN_Cone_Green_Blue = rgb <74/255, 97/255, 105/255>;
#declare CN_Coney_Island = rgb <109/255, 126/255, 125/255>;
#declare CN_Confection = rgb <244/255, 236/255, 218/255>;
#declare CN_Confederate = rgb <92/255, 98/255, 114/255>;
#declare CN_Confetti = rgb <221/255, 203/255, 70/255>;
#declare CN_Confidence = rgb <169/255, 138/255, 107/255>;
#declare CN_Confident_White = rgb <228/255, 223/255, 206/255>;
#declare CN_Confident_Yellow = rgb <255/255, 204/255, 19/255>;
#declare CN_Cong_Lu_Green = rgb <1/255, 192/255, 141/255>;
#declare CN_Congo = rgb <232/255, 195/255, 190/255>;
#declare CN_Congo_Brown = rgb <101/255, 77/255, 73/255>;
#declare CN_Congo_Capture = rgb <119/255, 105/255, 89/255>;
#declare CN_Congo_Green = rgb <0/255, 164/255, 131/255>;
#declare CN_Congo_Pink = rgb <249/255, 131/255, 121/255>;
#declare CN_Congress_Blue = rgb <2/255, 71/255, 142/255>;
#declare CN_Congressional_Navy = rgb <16/255, 4/255, 56/255>;
#declare CN_Conifer = rgb <177/255, 221/255, 82/255>;
#declare CN_Conifer_Blossom = rgb <255/255, 221/255, 73/255>;
#declare CN_Conifer_Cone = rgb <136/255, 85/255, 85/255>;
#declare CN_Conifer_Green = rgb <116/255, 119/255, 103/255>;
#declare CN_Conker = rgb <185/255, 78/255, 65/255>;
#declare CN_Conker_Brown = rgb <85/255, 34/255, 0/255>;
#declare CN_Connaisseur = rgb <101/255, 78/255, 68/255>;
#declare CN_Connect_Red = rgb <235/255, 102/255, 81/255>;
#declare CN_Connected_Gray = rgb <137/255, 132/255, 115/255>;
#declare CN_Connecticut_Lilac = rgb <204/255, 187/255, 238/255>;
#declare CN_Connors_Lakefront = rgb <23/255, 90/255, 108/255>;
#declare CN_Cono_De_Vainilla = rgb <242/255, 217/255, 184/255>;
#declare CN_Conservation = rgb <121/255, 110/255, 84/255>;
#declare CN_Conservative_Gray = rgb <209/255, 208/255, 198/255>;
#declare CN_Conspiracy_Velvet = rgb <87/255, 70/255, 93/255>;
#declare CN_Constant_Coral = rgb <205/255, 142/255, 127/255>;
#declare CN_Constellation = rgb <188/255, 206/255, 219/255>;
#declare CN_Constellation_Blue = rgb <60/255, 70/255, 112/255>;
#declare CN_Construction_Zone = rgb <238/255, 132/255, 66/255>;
#declare CN_Contemplation = rgb <190/255, 198/255, 187/255>;
#declare CN_Contented = rgb <189/255, 192/255, 179/255>;
#declare CN_Contessa = rgb <193/255, 111/255, 104/255>;
#declare CN_Continental_Waters = rgb <152/255, 198/255, 203/255>;
#declare CN_Contrail = rgb <222/255, 222/255, 255/255>;
#declare CN_Contrasting_Yellow = rgb <242/255, 194/255, 0/255>;
#declare CN_Convivial_Yellow = rgb <233/255, 214/255, 176/255>;
#declare CN_Cooks_Bay = rgb <1/255, 78/255, 131/255>;
#declare CN_Cookie = rgb <255/255, 226/255, 183/255>;
#declare CN_Cookie_Crumb = rgb <177/255, 151/255, 120/255>;
#declare CN_Cookie_Crust = rgb <227/255, 178/255, 88/255>;
#declare CN_Cookie_Dough = rgb <171/255, 113/255, 0/255>;
#declare CN_Cookies_And_Cream = rgb <238/255, 224/255, 177/255>;
#declare CN_Cool = rgb <150/255, 179/255, 179/255>;
#declare CN_Cool_Aloe = rgb <169/255, 217/255, 156/255>;
#declare CN_Cool_Ashes = rgb <146/255, 146/255, 145/255>;
#declare CN_Cool_Avocado = rgb <196/255, 180/255, 125/255>;
#declare CN_Cool_Beige = rgb <198/255, 181/255, 167/255>;
#declare CN_Cool_Black = rgb <0/255, 46/255, 99/255>;
#declare CN_Cool_Blue = rgb <73/255, 132/255, 184/255>;
#declare CN_Cool_Camel = rgb <174/255, 153/255, 107/255>;
#declare CN_Cool_Camo = rgb <130/255, 117/255, 102/255>;
#declare CN_Cool_Cantaloupe = rgb <241/255, 211/255, 202/255>;
#declare CN_Cool_Charcoal = rgb <128/255, 123/255, 118/255>;
#declare CN_Cool_Clay = rgb <186/255, 148/255, 123/255>;
#declare CN_Cool_Concrete = rgb <217/255, 208/255, 193/255>;
#declare CN_Cool_Copper = rgb <173/255, 132/255, 88/255>;
#declare CN_Cool_Crayon = rgb <176/255, 230/255, 227/255>;
#declare CN_Cool_Cream = rgb <251/255, 229/255, 217/255>;
#declare CN_Cool_Current = rgb <40/255, 60/255, 68/255>;
#declare CN_Cool_December = rgb <253/255, 251/255, 248/255>;
#declare CN_Cool_Dive = rgb <0/255, 96/255, 111/255>;
#declare CN_Cool_Dusk = rgb <123/255, 157/255, 173/255>;
#declare CN_Cool_Elegance = rgb <207/255, 207/255, 208/255>;
#declare CN_Cool_Frost = rgb <231/255, 230/255, 237/255>;
#declare CN_Cool_Granite = rgb <171/255, 172/255, 168/255>;
#declare CN_Cool_Green = rgb <51/255, 184/255, 100/255>;
#declare CN_Cool_Grey = rgb <140/255, 147/255, 173/255>;
#declare CN_Cool_Icicle = rgb <225/255, 238/255, 230/255>;
#declare CN_Cool_Jazz = rgb <190/255, 231/255, 224/255>;
#declare CN_Cool_Lava = rgb <233/255, 124/255, 107/255>;
#declare CN_Cool_Lavender = rgb <179/255, 166/255, 165/255>;
#declare CN_Cool_Melon = rgb <235/255, 209/255, 205/255>;
#declare CN_Cool_Pink = rgb <229/255, 204/255, 209/255>;
#declare CN_Cool_Purple = rgb <170/255, 35/255, 255/255>;
#declare CN_Cool_Quiet = rgb <203/255, 181/255, 198/255>;
#declare CN_Cool_Reflection = rgb <234/255, 240/255, 235/255>;
#declare CN_Cool_Sky = rgb <207/255, 224/255, 228/255>;
#declare CN_Cool_Slate = rgb <208/255, 204/255, 197/255>;
#declare CN_Cool_Spring = rgb <187/255, 217/255, 195/255>;
#declare CN_Cool_Touch = rgb <114/255, 149/255, 201/255>;
#declare CN_Cool_Water_Lake = rgb <155/255, 217/255, 229/255>;
#declare CN_Cool_Waters = rgb <72/255, 118/255, 120/255>;
#declare CN_Cool_White = rgb <218/255, 230/255, 226/255>;
#declare CN_Cool_Yellow = rgb <234/255, 239/255, 206/255>;
#declare CN_Coolbox_Ice_Turquoise = rgb <73/255, 156/255, 157/255>;
#declare CN_Cooled_Blue = rgb <117/255, 185/255, 174/255>;
#declare CN_Cooled_Cream = rgb <250/255, 220/255, 151/255>;
#declare CN_Cooler_Than_Ever = rgb <119/255, 187/255, 255/255>;
#declare CN_Cooling_Trend = rgb <230/255, 226/255, 228/255>;
#declare CN_Copacabana = rgb <0/255, 108/255, 141/255>;
#declare CN_Copacabana_Sand = rgb <229/255, 214/255, 142/255>;
#declare CN_Copen_Blue = rgb <81/255, 107/255, 132/255>;
#declare CN_Copenhagen = rgb <173/255, 200/255, 192/255>;
#declare CN_Copenhagen_Blue = rgb <33/255, 99/255, 139/255>;
#declare CN_Copper = rgb <184/255, 115/255, 51/255>;
#declare CN_Copper_Beech = rgb <177/255, 113/255, 90/255>;
#declare CN_Copper_Blush = rgb <232/255, 193/255, 171/255>;
#declare CN_Copper_Brown = rgb <154/255, 96/255, 81/255>;
#declare CN_Copper_Canyon = rgb <119/255, 66/255, 44/255>;
#declare CN_Copper_Coin = rgb <218/255, 138/255, 103/255>;
#declare CN_Copper_Cove = rgb <216/255, 145/255, 102/255>;
#declare CN_Copper_Creek = rgb <163/255, 93/255, 49/255>;
#declare CN_Copper_Harbor = rgb <213/255, 126/255, 82/255>;
#declare CN_Copper_Lake = rgb <192/255, 144/255, 120/255>;
#declare CN_Copper_Mine = rgb <178/255, 118/255, 76/255>;
#declare CN_Copper_Mineral_Green = rgb <57/255, 129/255, 116/255>;
#declare CN_Copper_Mining = rgb <148/255, 92/255, 84/255>;
#declare CN_Copper_Moon = rgb <194/255, 153/255, 120/255>;
#declare CN_Copper_Mountain = rgb <171/255, 113/255, 74/255>;
#declare CN_Copper_Patina = rgb <157/255, 180/255, 160/255>;
#declare CN_Copper_Penny = rgb <173/255, 111/255, 105/255>;
#declare CN_Copper_Pink = rgb <148/255, 104/255, 119/255>;
#declare CN_Copper_Pipe = rgb <218/255, 143/255, 103/255>;
#declare CN_Copper_Pot = rgb <147/255, 102/255, 71/255>;
#declare CN_Copper_Pyrite_Green = rgb <62/255, 73/255, 57/255>;
#declare CN_Copper_Red = rgb <203/255, 109/255, 81/255>;
#declare CN_Copper_River = rgb <247/255, 162/255, 112/255>;
#declare CN_Copper_Roof_Green = rgb <111/255, 151/255, 142/255>;
#declare CN_Copper_Rose = rgb <153/255, 102/255, 102/255>;
#declare CN_Copper_Rust = rgb <149/255, 82/255, 76/255>;
#declare CN_Copper_Tan = rgb <222/255, 142/255, 101/255>;
#declare CN_Copper_Trail = rgb <193/255, 137/255, 120/255>;
#declare CN_Copper_Turquoise = rgb <56/255, 136/255, 127/255>;
#declare CN_Copper_Wire = rgb <219/255, 139/255, 103/255>;
#declare CN_Copper_Metal_Red = rgb <173/255, 99/255, 66/255>;
#declare CN_Copperfield = rgb <218/255, 138/255, 136/255>;
#declare CN_Copperleaf = rgb <207/255, 136/255, 116/255>;
#declare CN_Coppersmith = rgb <217/255, 138/255, 63/255>;
#declare CN_Coppery_Orange = rgb <127/255, 67/255, 48/255>;
#declare CN_Copra = rgb <101/255, 70/255, 54/255>;
#declare CN_Coquelicot = rgb <255/255, 56/255, 0/255>;
#declare CN_Coquette = rgb <229/255, 220/255, 220/255>;
#declare CN_Coquina = rgb <157/255, 141/255, 142/255>;
#declare CN_Cor_de_pele = rgb <244/255, 194/255, 194/255>;
#declare CN_Coral = rgb <255/255, 127/255, 80/255>;
#declare CN_Coral_Almond = rgb <226/255, 157/255, 148/255>;
#declare CN_Coral_Atoll = rgb <220/255, 147/255, 141/255>;
#declare CN_Coral_Bay = rgb <221/255, 184/255, 163/255>;
#declare CN_Coral_Beach = rgb <255/255, 187/255, 170/255>;
#declare CN_Coral_Bead = rgb <239/255, 154/255, 147/255>;
#declare CN_Coral_Bells = rgb <251/255, 197/255, 187/255>;
#declare CN_Coral_Bisque = rgb <247/255, 198/255, 177/255>;
#declare CN_Coral_Blossom = rgb <247/255, 190/255, 162/255>;
#declare CN_Coral_Blush = rgb <229/255, 160/255, 144/255>;
#declare CN_Coral_Burst = rgb <221/255, 85/255, 68/255>;
#declare CN_Coral_Candy = rgb <245/255, 208/255, 201/255>;
#declare CN_Coral_Clay = rgb <194/255, 177/255, 161/255>;
#declare CN_Coral_Cloud = rgb <226/255, 169/255, 161/255>;
#declare CN_Coral_Coast = rgb <6/255, 142/255, 158/255>;
#declare CN_Coral_Commander = rgb <238/255, 102/255, 102/255>;
#declare CN_Coral_Confection = rgb <252/255, 204/255, 167/255>;
#declare CN_Coral_Corn_Snake = rgb <233/255, 173/255, 202/255>;
#declare CN_Coral_Cove = rgb <221/255, 166/255, 159/255>;
#declare CN_Coral_Cream = rgb <234/255, 214/255, 206/255>;
#declare CN_Coral_Dune = rgb <252/255, 213/255, 197/255>;
#declare CN_Coral_Dusk = rgb <255/255, 180/255, 138/255>;
#declare CN_Coral_Dust = rgb <237/255, 170/255, 134/255>;
#declare CN_Coral_Expression = rgb <215/255, 106/255, 105/255>;
#declare CN_Coral_Fountain = rgb <227/255, 169/255, 162/255>;
#declare CN_Coral_Garden = rgb <207/255, 129/255, 121/255>;
#declare CN_Coral_Gold = rgb <210/255, 125/255, 86/255>;
#declare CN_Coral_Green = rgb <171/255, 226/255, 207/255>;
#declare CN_Coral_Haze = rgb <227/255, 142/255, 132/255>;
#declare CN_Coral_Kiss = rgb <255/255, 221/255, 199/255>;
#declare CN_Coral_Mantle = rgb <252/255, 214/255, 203/255>;
#declare CN_Coral_Orange = rgb <228/255, 105/255, 76/255>;
#declare CN_Coral_Pink = rgb <248/255, 131/255, 121/255>;
#declare CN_Coral_Quartz = rgb <247/255, 116/255, 100/255>;
#declare CN_Coral_Red = rgb <255/255, 64/255, 64/255>;
#declare CN_Coral_Reef = rgb <199/255, 188/255, 162/255>;
#declare CN_Coral_Rose = rgb <243/255, 119/255, 77/255>;
#declare CN_Coral_Sand = rgb <202/255, 136/255, 78/255>;
#declare CN_Coral_Serenade = rgb <249/255, 164/255, 142/255>;
#declare CN_Coral_Silk = rgb <242/255, 163/255, 125/255>;
#declare CN_Coral_Springs = rgb <171/255, 209/255, 175/255>;
#declare CN_Coral_Stone = rgb <221/255, 195/255, 182/255>;
#declare CN_Coral_Trails = rgb <255/255, 139/255, 135/255>;
#declare CN_Coral_Tree = rgb <171/255, 110/255, 103/255>;
#declare CN_Coralette = rgb <240/255, 134/255, 116/255>;
#declare CN_Corallite = rgb <240/255, 223/255, 205/255>;
#declare CN_Corally = rgb <254/255, 168/255, 159/255>;
#declare CN_Corazon = rgb <157/255, 102/255, 99/255>;
#declare CN_Corbeau = rgb <17/255, 17/255, 34/255>;
#declare CN_Cordial = rgb <134/255, 76/255, 82/255>;
#declare CN_Cordite = rgb <97/255, 102/255, 101/255>;
#declare CN_Cordon_Bleu_Crust = rgb <235/255, 224/255, 200/255>;
#declare CN_Cordova_Burgundy = rgb <124/255, 55/255, 68/255>;
#declare CN_Cordovan = rgb <137/255, 63/255, 69/255>;
#declare CN_Cordovan_Leather = rgb <87/255, 68/255, 61/255>;
#declare CN_Corduroy = rgb <64/255, 77/255, 73/255>;
#declare CN_Corfu_Shallows = rgb <0/255, 142/255, 141/255>;
#declare CN_Corfu_Sky = rgb <137/255, 147/255, 195/255>;
#declare CN_Corfu_Waters = rgb <0/255, 138/255, 173/255>;
#declare CN_Coriander = rgb <187/255, 181/255, 141/255>;
#declare CN_Coriander_Ochre = rgb <126/255, 116/255, 99/255>;
#declare CN_Coriander_Powder = rgb <186/255, 156/255, 117/255>;
#declare CN_Coriander_Seed = rgb <189/255, 170/255, 111/255>;
#declare CN_Corinthian_Column = rgb <222/255, 222/255, 207/255>;
#declare CN_Corinthian_Pillar = rgb <225/255, 209/255, 177/255>;
#declare CN_Cork = rgb <90/255, 76/255, 66/255>;
#declare CN_Cork_Bark = rgb <126/255, 107/255, 67/255>;
#declare CN_Cork_Brown = rgb <204/255, 136/255, 85/255>;
#declare CN_Cork_Wedge = rgb <193/255, 169/255, 138/255>;
#declare CN_Cork_Wood = rgb <204/255, 119/255, 68/255>;
#declare CN_Corkboard = rgb <157/255, 128/255, 93/255>;
#declare CN_Corkscrew_Willow = rgb <209/255, 185/255, 171/255>;
#declare CN_Corn = rgb <251/255, 236/255, 93/255>;
#declare CN_Corn_Bread = rgb <238/255, 198/255, 87/255>;
#declare CN_Corn_Chowder = rgb <225/255, 197/255, 149/255>;
#declare CN_Corn_Field = rgb <248/255, 243/255, 196/255>;
#declare CN_Corn_Harvest = rgb <141/255, 112/255, 42/255>;
#declare CN_Corn_Husk = rgb <242/255, 214/255, 174/255>;
#declare CN_Corn_Husk_Green = rgb <206/255, 205/255, 149/255>;
#declare CN_Corn_Kernel = rgb <255/255, 203/255, 164/255>;
#declare CN_Corn_Maze = rgb <222/255, 170/255, 110/255>;
#declare CN_Corn_Poppy_Cherry = rgb <238/255, 68/255, 17/255>;
#declare CN_Corn_Snake = rgb <171/255, 97/255, 52/255>;
#declare CN_Corn_Stalk = rgb <252/255, 219/255, 166/255>;
#declare CN_Cornell_Red = rgb <179/255, 27/255, 17/255>;
#declare CN_Cornerstone = rgb <227/255, 215/255, 187/255>;
#declare CN_Cornflake = rgb <240/255, 230/255, 140/255>;
#declare CN_Cornflower = rgb <81/255, 112/255, 215/255>;
#declare CN_Cornflower_Blue = rgb <115/255, 145/255, 200/255>;
#declare CN_Cornflower_Lilac = rgb <255/255, 176/255, 172/255>;
#declare CN_Cornmeal = rgb <255/255, 214/255, 145/255>;
#declare CN_Cornmeal_Beige = rgb <235/255, 213/255, 197/255>;
#declare CN_Cornsilk = rgb <255/255, 248/255, 220/255>;
#declare CN_Cornsilk_Yellow = rgb <244/255, 201/255, 108/255>;
#declare CN_Cornstalk = rgb <169/255, 148/255, 122/255>;
#declare CN_Cornucopia = rgb <237/255, 155/255, 68/255>;
#declare CN_Cornwall_Slate = rgb <148/255, 148/255, 136/255>;
#declare CN_Corona = rgb <255/255, 180/255, 55/255>;
#declare CN_Coronado_Dunes = rgb <213/255, 166/255, 141/255>;
#declare CN_Coronado_Moss = rgb <155/255, 165/255, 145/255>;
#declare CN_Coronation = rgb <237/255, 236/255, 236/255>;
#declare CN_Coronation_Blue = rgb <89/255, 82/255, 156/255>;
#declare CN_Coronet_Blue = rgb <89/255, 114/255, 142/255>;
#declare CN_Corporate_Green = rgb <120/255, 164/255, 134/255>;
#declare CN_Corral = rgb <97/255, 81/255, 61/255>;
#declare CN_Corral_Brown = rgb <147/255, 115/255, 96/255>;
#declare CN_Corrosion_Red = rgb <119/255, 47/255, 33/255>;
#declare CN_Corsair = rgb <24/255, 87/255, 108/255>;
#declare CN_Corsican = rgb <133/255, 172/255, 157/255>;
#declare CN_Corsican_Blue = rgb <100/255, 96/255, 147/255>;
#declare CN_Corsican_Purple = rgb <122/255, 133/255, 175/255>;
#declare CN_Cortex = rgb <169/255, 149/255, 146/255>;
#declare CN_Cortez_Chocolate = rgb <164/255, 137/255, 106/255>;
#declare CN_Corundum_Blue = rgb <74/255, 98/255, 103/255>;
#declare CN_Corundum_Red = rgb <149/255, 104/255, 125/255>;
#declare CN_Corvette = rgb <233/255, 186/255, 129/255>;
#declare CN_Corydalis_Blue = rgb <169/255, 202/255, 218/255>;
#declare CN_Cos = rgb <164/255, 196/255, 142/255>;
#declare CN_Cosmetic_Blush = rgb <246/255, 231/255, 226/255>;
#declare CN_Cosmetic_Mauve = rgb <211/255, 190/255, 213/255>;
#declare CN_Cosmetic_Peach = rgb <243/255, 193/255, 171/255>;
#declare CN_Cosmetic_Red = rgb <165/255, 96/255, 120/255>;
#declare CN_Cosmic = rgb <184/255, 185/255, 203/255>;
#declare CN_Cosmic_Aura = rgb <207/255, 179/255, 166/255>;
#declare CN_Cosmic_Bit_Flip = rgb <0/255, 16/255, 0/255>;
#declare CN_Cosmic_Blue = rgb <147/255, 195/255, 203/255>;
#declare CN_Cosmic_Cobalt = rgb <46/255, 45/255, 136/255>;
#declare CN_Cosmic_Coral = rgb <231/255, 126/255, 108/255>;
#declare CN_Cosmic_Dust = rgb <220/255, 226/255, 229/255>;
#declare CN_Cosmic_Energy = rgb <147/255, 146/255, 171/255>;
#declare CN_Cosmic_Explorer = rgb <85/255, 17/255, 85/255>;
#declare CN_Cosmic_Latte = rgb <255/255, 248/255, 231/255>;
#declare CN_Cosmic_Quest = rgb <158/255, 161/255, 159/255>;
#declare CN_Cosmic_Ray = rgb <202/255, 218/255, 218/255>;
#declare CN_Cosmic_Sky = rgb <170/255, 170/255, 196/255>;
#declare CN_Cosmo_Purple = rgb <160/255, 155/255, 198/255>;
#declare CN_Cosmopolitan = rgb <82/255, 139/255, 171/255>;
#declare CN_Cosmos = rgb <252/255, 213/255, 207/255>;
#declare CN_Cosmos_Blue = rgb <0/255, 50/255, 73/255>;
#declare CN_Cossack_Dancer = rgb <77/255, 138/255, 161/255>;
#declare CN_Costa_Del_Sol = rgb <98/255, 93/255, 42/255>;
#declare CN_Costa_Rica_Blue = rgb <119/255, 188/255, 226/255>;
#declare CN_Costa_Rican_Palm = rgb <196/255, 64/255, 65/255>;
#declare CN_Costume_Blue = rgb <100/255, 119/255, 160/255>;
#declare CN_Cote_DAzur = rgb <1/255, 124/255, 133/255>;
#declare CN_Cotswold_Dill = rgb <219/255, 205/255, 173/255>;
#declare CN_Cottage_Cream = rgb <237/255, 219/255, 189/255>;
#declare CN_Cottage_Green = rgb <220/255, 236/255, 220/255>;
#declare CN_Cottage_Hill = rgb <172/255, 179/255, 151/255>;
#declare CN_Cottage_Rose = rgb <217/255, 168/255, 154/255>;
#declare CN_Cottage_Walk = rgb <160/255, 142/255, 119/255>;
#declare CN_Cottage_White = rgb <247/255, 239/255, 221/255>;
#declare CN_Cottingley_Fairies = rgb <237/255, 219/255, 215/255>;
#declare CN_Cotton = rgb <238/255, 235/255, 225/255>;
#declare CN_Cotton_Ball = rgb <242/255, 247/255, 253/255>;
#declare CN_Cotton_Blossom = rgb <245/255, 241/255, 228/255>;
#declare CN_Cotton_Boll = rgb <231/255, 239/255, 251/255>;
#declare CN_Cotton_Candy = rgb <255/255, 188/255, 217/255>;
#declare CN_Cotton_Candy_Explosions = rgb <221/255, 34/255, 255/255>;
#declare CN_Cotton_Candy_Grape = rgb <222/255, 199/255, 75/255>;
#declare CN_Cotton_Cardigan = rgb <117/255, 150/255, 184/255>;
#declare CN_Cotton_Cloth = rgb <250/255, 244/255, 212/255>;
#declare CN_Cotton_Club = rgb <243/255, 228/255, 211/255>;
#declare CN_Cotton_Denim = rgb <145/255, 171/255, 190/255>;
#declare CN_Cotton_Field = rgb <242/255, 240/255, 232/255>;
#declare CN_Cotton_Flannel = rgb <144/255, 144/255, 162/255>;
#declare CN_Cotton_Fluff = rgb <249/255, 244/255, 229/255>;
#declare CN_Cotton_Grey = rgb <209/255, 204/255, 195/255>;
#declare CN_Cotton_Indigo = rgb <6/255, 105/255, 118/255>;
#declare CN_Cotton_Knit = rgb <229/255, 223/255, 210/255>;
#declare CN_Cotton_Puff = rgb <255/255, 255/255, 231/255>;
#declare CN_Cotton_Ridge = rgb <241/255, 235/255, 219/255>;
#declare CN_Cotton_Seed = rgb <191/255, 186/255, 175/255>;
#declare CN_Cotton_Sheets = rgb <247/255, 235/255, 221/255>;
#declare CN_Cotton_Tail = rgb <255/255, 248/255, 215/255>;
#declare CN_Cotton_Whisper = rgb <250/255, 241/255, 223/255>;
#declare CN_Cotton_White = rgb <228/255, 227/255, 216/255>;
#declare CN_Cotton_Wool_Blue = rgb <131/255, 171/255, 210/255>;
#declare CN_Cottonseed = rgb <245/255, 230/255, 199/255>;
#declare CN_Cougar = rgb <154/255, 127/255, 120/255>;
#declare CN_Counts_Wardrobe = rgb <119/255, 34/255, 119/255>;
#declare CN_Country_Air = rgb <159/255, 182/255, 198/255>;
#declare CN_Country_Beige = rgb <234/255, 225/255, 203/255>;
#declare CN_Country_Blue = rgb <113/255, 127/255, 155/255>;
#declare CN_Country_Breeze = rgb <224/255, 217/255, 213/255>;
#declare CN_Country_Charm = rgb <199/255, 192/255, 167/255>;
#declare CN_Country_Club = rgb <148/255, 134/255, 117/255>;
#declare CN_Country_Cork = rgb <184/255, 165/255, 132/255>;
#declare CN_Country_Cottage = rgb <217/255, 193/255, 183/255>;
#declare CN_Country_Dairy = rgb <241/255, 233/255, 210/255>;
#declare CN_Country_Dweller = rgb <176/255, 150/255, 124/255>;
#declare CN_Country_House_Green = rgb <65/255, 70/255, 52/255>;
#declare CN_Country_Lake = rgb <93/255, 122/255, 133/255>;
#declare CN_Country_Lane = rgb <252/255, 234/255, 209/255>;
#declare CN_Country_Lane_Red = rgb <137/255, 67/255, 64/255>;
#declare CN_Country_Linens = rgb <215/255, 194/255, 166/255>;
#declare CN_Country_Mist = rgb <223/255, 235/255, 226/255>;
#declare CN_Country_Rubble = rgb <208/255, 188/255, 162/255>;
#declare CN_Country_Sky = rgb <73/255, 84/255, 90/255>;
#declare CN_Country_Sleigh = rgb <126/255, 67/255, 55/255>;
#declare CN_Country_Squire = rgb <18/255, 74/255, 66/255>;
#declare CN_Country_Summer = rgb <255/255, 251/255, 215/255>;
#declare CN_Country_Tweed = rgb <131/255, 123/255, 104/255>;
#declare CN_Country_Weekend = rgb <136/255, 192/255, 150/255>;
#declare CN_County_Green = rgb <27/255, 75/255, 53/255>;
#declare CN_Courgette_Yellow = rgb <218/255, 161/255, 53/255>;
#declare CN_Court_Green = rgb <185/255, 183/255, 160/255>;
#declare CN_Court_Jester = rgb <146/255, 109/255, 157/255>;
#declare CN_Court_Bouillon = rgb <206/255, 203/255, 151/255>;
#declare CN_Courteous = rgb <210/255, 211/255, 222/255>;
#declare CN_Courtly_Purple = rgb <187/255, 175/255, 193/255>;
#declare CN_Courtyard = rgb <200/255, 189/255, 164/255>;
#declare CN_Courtyard_Blue = rgb <113/255, 128/255, 132/255>;
#declare CN_Courtyard_Green = rgb <151/255, 141/255, 113/255>;
#declare CN_Couscous = rgb <255/255, 226/255, 155/255>;
#declare CN_Cousteau = rgb <85/255, 169/255, 214/255>;
#declare CN_Cover_of_Night = rgb <73/255, 78/255, 79/255>;
#declare CN_Covered_Bridge = rgb <106/255, 60/255, 59/255>;
#declare CN_Covered_in_Platinum = rgb <185/255, 186/255, 186/255>;
#declare CN_Covered_Wagon = rgb <114/255, 100/255, 73/255>;
#declare CN_Covert_Green = rgb <128/255, 118/255, 95/255>;
#declare CN_Coverts_Wood_Pigeon = rgb <212/255, 205/255, 210/255>;
#declare CN_Coveted_Gem = rgb <182/255, 179/255, 191/255>;
#declare CN_Cows_Milk = rgb <241/255, 237/255, 229/255>;
#declare CN_Cowardly_Custard = rgb <251/255, 241/255, 192/255>;
#declare CN_Cowbell = rgb <255/255, 228/255, 129/255>;
#declare CN_Cowboy = rgb <68/255, 55/255, 54/255>;
#declare CN_Cowboy_Boots = rgb <105/255, 82/255, 57/255>;
#declare CN_Cowboy_Hat = rgb <178/255, 125/255, 80/255>;
#declare CN_Cowboy_Trails = rgb <141/255, 107/255, 75/255>;
#declare CN_Cowgirl_Blue = rgb <106/255, 135/255, 171/255>;
#declare CN_Cowgirl_Boots = rgb <158/255, 124/255, 96/255>;
#declare CN_Cowhide = rgb <136/255, 67/255, 68/255>;
#declare CN_Cowpeas = rgb <102/255, 17/255, 0/255>;
#declare CN_Coy = rgb <255/255, 244/255, 243/255>;
#declare CN_Coy_Pink = rgb <249/255, 218/255, 216/255>;
#declare CN_Coyote = rgb <220/255, 155/255, 104/255>;
#declare CN_Coyote_Brown = rgb <129/255, 97/255, 60/255>;
#declare CN_Coyote_Tracks = rgb <176/255, 143/255, 127/255>;
#declare CN_Cozumel = rgb <10/255, 175/255, 164/255>;
#declare CN_Cozy_Blanket = rgb <195/255, 165/255, 152/255>;
#declare CN_Cozy_Cocoa = rgb <170/255, 143/255, 125/255>;
#declare CN_Cozy_Cottage = rgb <242/255, 221/255, 216/255>;
#declare CN_Cozy_Cover = rgb <228/255, 195/255, 143/255>;
#declare CN_Cozy_Cream = rgb <224/255, 219/255, 199/255>;
#declare CN_Cozy_Wool = rgb <209/255, 185/255, 155/255>;
#declare CN_Crab_Bisque = rgb <240/255, 181/255, 153/255>;
#declare CN_Crab_Nebula = rgb <0/255, 68/255, 85/255>;
#declare CN_Crab_Apple = rgb <240/255, 230/255, 129/255>;
#declare CN_Crabapple = rgb <135/255, 56/255, 47/255>;
#declare CN_Crabby_Apple = rgb <117/255, 53/255, 49/255>;
#declare CN_Crack_Willow = rgb <176/255, 164/255, 112/255>;
#declare CN_Cracked_Earth = rgb <197/255, 177/255, 160/255>;
#declare CN_Cracked_Pepper = rgb <79/255, 81/255, 82/255>;
#declare CN_Cracked_Slate = rgb <105/255, 101/255, 106/255>;
#declare CN_Cracked_Wheat = rgb <244/255, 223/255, 189/255>;
#declare CN_Cracker_Bitz = rgb <209/255, 176/255, 136/255>;
#declare CN_Cracker_Crumbs = rgb <211/255, 185/255, 176/255>;
#declare CN_Crackled_Leather = rgb <162/255, 124/255, 79/255>;
#declare CN_Crackling_Lake = rgb <179/255, 197/255, 204/255>;
#declare CN_Cradle_Pillow = rgb <241/255, 211/255, 217/255>;
#declare CN_Cradle_Pink = rgb <237/255, 208/255, 221/255>;
#declare CN_Craft = rgb <41/255, 59/255, 74/255>;
#declare CN_Craft_Brown = rgb <183/255, 160/255, 131/255>;
#declare CN_Craft_Juggler = rgb <227/255, 200/255, 170/255>;
#declare CN_Craft_Paper = rgb <138/255, 102/255, 69/255>;
#declare CN_Craftsman_Blue = rgb <0/255, 129/255, 147/255>;
#declare CN_Craftsman_Brown = rgb <174/255, 146/255, 120/255>;
#declare CN_Craftsman_Gold = rgb <211/255, 183/255, 139/255>;
#declare CN_Craggy_Skin = rgb <247/255, 189/255, 123/255>;
#declare CN_Crail = rgb <166/255, 86/255, 72/255>;
#declare CN_Cranach_Blue = rgb <43/255, 130/255, 136/255>;
#declare CN_Cranapple = rgb <219/255, 128/255, 121/255>;
#declare CN_Cranapple_Cream = rgb <230/255, 196/255, 197/255>;
#declare CN_Cranberry = rgb <158/255, 0/255, 58/255>;
#declare CN_Cranberry_Blue = rgb <116/255, 148/255, 177/255>;
#declare CN_Cranberry_Jam = rgb <163/255, 79/255, 85/255>;
#declare CN_Cranberry_Pie = rgb <194/255, 114/255, 119/255>;
#declare CN_Cranberry_Red = rgb <126/255, 83/255, 80/255>;
#declare CN_Cranberry_Sauce = rgb <165/255, 55/255, 86/255>;
#declare CN_Cranberry_Splash = rgb <218/255, 82/255, 101/255>;
#declare CN_Cranberry_Tart = rgb <137/255, 62/255, 64/255>;
#declare CN_Cranberry_Whip = rgb <142/255, 69/255, 65/255>;
#declare CN_Cranberry_Zing = rgb <148/255, 73/255, 68/255>;
#declare CN_Cranbrook = rgb <166/255, 85/255, 112/255>;
#declare CN_Crantini = rgb <149/255, 76/255, 82/255>;
#declare CN_Crash_Dummy = rgb <238/255, 238/255, 102/255>;
#declare CN_Crash_Pink = rgb <204/255, 136/255, 255/255>;
#declare CN_Crashing_Waves = rgb <62/255, 111/255, 135/255>;
#declare CN_Crater_Brown = rgb <77/255, 62/255, 60/255>;
#declare CN_Crater_Crawler = rgb <200/255, 206/255, 214/255>;
#declare CN_Crater_Lake = rgb <99/255, 121/255, 126/255>;
#declare CN_Cray = rgb <188/255, 118/255, 60/255>;
#declare CN_Crayola_Green = rgb <29/255, 172/255, 120/255>;
#declare CN_Crayola_Orange = rgb <254/255, 116/255, 56/255>;
#declare CN_Crazy = rgb <229/255, 203/255, 63/255>;
#declare CN_Crazy_Eyes = rgb <94/255, 182/255, 141/255>;
#declare CN_Crazy_Horse = rgb <165/255, 118/255, 72/255>;
#declare CN_Crazy_Horse_Mountain = rgb <233/255, 219/255, 210/255>;
#declare CN_Cream = rgb <255/255, 255/255, 194/255>;
#declare CN_Cream_and_Sugar = rgb <221/255, 207/255, 185/255>;
#declare CN_Cream_Blush = rgb <248/255, 193/255, 154/255>;
#declare CN_Cream_Cake = rgb <227/255, 208/255, 173/255>;
#declare CN_Cream_Can = rgb <238/255, 192/255, 81/255>;
#declare CN_Cream_Cheese_Avocado = rgb <215/255, 211/255, 166/255>;
#declare CN_Cream_Cheese_Frosting = rgb <244/255, 239/255, 226/255>;
#declare CN_Cream_Clear = rgb <241/255, 243/255, 218/255>;
#declare CN_Cream_Custard = rgb <242/255, 215/255, 176/255>;
#declare CN_Cream_Filling = rgb <245/255, 241/255, 218/255>;
#declare CN_Cream_Gold = rgb <222/255, 192/255, 95/255>;
#declare CN_Cream_of_Mushroom = rgb <235/255, 209/255, 190/255>;
#declare CN_Cream_Pink = rgb <246/255, 228/255, 217/255>;
#declare CN_Cream_Puff = rgb <255/255, 187/255, 153/255>;
#declare CN_Cream_Rose = rgb <247/255, 228/255, 223/255>;
#declare CN_Cream_Silk = rgb <238/255, 227/255, 198/255>;
#declare CN_Cream_Tan = rgb <228/255, 199/255, 184/255>;
#declare CN_Cream_Violet = rgb <169/255, 170/255, 189/255>;
#declare CN_Cream_Washed = rgb <242/255, 224/255, 197/255>;
#declare CN_Cream_Wave = rgb <232/255, 219/255, 197/255>;
#declare CN_Cream_White = rgb <242/255, 238/255, 226/255>;
#declare CN_Cream_Yellow = rgb <243/255, 218/255, 167/255>;
#declare CN_Creamed_Avocado = rgb <112/255, 128/255, 77/255>;
#declare CN_Creamed_Butter = rgb <255/255, 252/255, 211/255>;
#declare CN_Creamed_Caramel = rgb <183/255, 156/255, 148/255>;
#declare CN_Creamed_Muscat = rgb <139/255, 105/255, 98/255>;
#declare CN_Creamed_Raspberry = rgb <189/255, 104/255, 131/255>;
#declare CN_Creamery = rgb <237/255, 210/255, 183/255>;
#declare CN_Creamy = rgb <239/255, 232/255, 219/255>;
#declare CN_Creamy_Apricot = rgb <255/255, 232/255, 189/255>;
#declare CN_Creamy_Axolotl = rgb <255/255, 218/255, 232/255>;
#declare CN_Creamy_Beige = rgb <253/255, 225/255, 197/255>;
#declare CN_Creamy_Cameo = rgb <249/255, 238/255, 220/255>;
#declare CN_Creamy_Cappuccino = rgb <219/255, 204/255, 181/255>;
#declare CN_Creamy_Caramel = rgb <179/255, 149/255, 108/255>;
#declare CN_Creamy_Chenille = rgb <225/255, 207/255, 175/255>;
#declare CN_Creamy_Coral = rgb <221/255, 119/255, 136/255>;
#declare CN_Creamy_Corn = rgb <255/255, 242/255, 194/255>;
#declare CN_Creamy_Custard = rgb <249/255, 231/255, 191/255>;
#declare CN_Creamy_Freesia = rgb <235/255, 208/255, 219/255>;
#declare CN_Creamy_Gelato = rgb <240/255, 226/255, 197/255>;
#declare CN_Creamy_Ivory = rgb <238/255, 221/255, 170/255>;
#declare CN_Creamy_Mauve = rgb <220/255, 202/255, 216/255>;
#declare CN_Creamy_Mint = rgb <170/255, 255/255, 170/255>;
#declare CN_Creamy_Mushroom = rgb <202/255, 189/255, 174/255>;
#declare CN_Creamy_Nougat = rgb <212/255, 184/255, 143/255>;
#declare CN_Creamy_Orange = rgb <252/255, 233/255, 209/255>;
#declare CN_Creamy_Orange_Blush = rgb <254/255, 156/255, 123/255>;
#declare CN_Creamy_Peach = rgb <244/255, 163/255, 132/255>;
#declare CN_Creamy_Spinach = rgb <178/255, 191/255, 166/255>;
#declare CN_Creamy_Strawberry = rgb <252/255, 210/255, 223/255>;
#declare CN_Creamy_White = rgb <240/255, 233/255, 214/255>;
#declare CN_Crease = rgb <122/255, 109/255, 68/255>;
#declare CN_Create = rgb <201/255, 202/255, 191/255>;
#declare CN_Credo = rgb <220/255, 186/255, 66/255>;
#declare CN_Creed = rgb <193/255, 164/255, 74/255>;
#declare CN_Creek_Bay = rgb <171/255, 157/255, 137/255>;
#declare CN_Creek_Bend = rgb <146/255, 140/255, 135/255>;
#declare CN_Creek_Pebble = rgb <219/255, 215/255, 217/255>;
#declare CN_Creeping_Bellflower = rgb <180/255, 138/255, 194/255>;
#declare CN_Crema = rgb <193/255, 97/255, 4/255>;
#declare CN_Creme = rgb <255/255, 255/255, 182/255>;
#declare CN_Creme_Angels = rgb <248/255, 237/255, 226/255>;
#declare CN_Creme_Brulee = rgb <245/255, 233/255, 206/255>;
#declare CN_Creme_Brulee = rgb <255/255, 227/255, 155/255>;
#declare CN_Creme_De_Caramel = rgb <212/255, 179/255, 143/255>;
#declare CN_Creme_De_La_Creme = rgb <226/255, 222/255, 215/255>;
#declare CN_Creme_de_la_Creme = rgb <243/255, 231/255, 180/255>;
#declare CN_Creme_de_Menthe = rgb <241/255, 253/255, 233/255>;
#declare CN_Creme_De_Peche = rgb <245/255, 214/255, 198/255>;
#declare CN_Creme_Fraiche = rgb <234/255, 219/255, 201/255>;
#declare CN_Creme_Fraiche = rgb <247/255, 240/255, 226/255>;
#declare CN_Cremini = rgb <207/255, 163/255, 59/255>;
#declare CN_Creole = rgb <57/255, 50/255, 39/255>;
#declare CN_Creole_Cottage = rgb <231/255, 184/255, 154/255>;
#declare CN_Creole_Pink = rgb <247/255, 213/255, 204/255>;
#declare CN_Creole_Sauce = rgb <238/255, 136/255, 51/255>;
#declare CN_Crepe = rgb <212/255, 188/255, 148/255>;
#declare CN_Crepe_Myrtle = rgb <227/255, 153/255, 202/255>;
#declare CN_Crepe_Papier = rgb <219/255, 215/255, 196/255>;
#declare CN_Crepe_Silk_White = rgb <240/255, 238/255, 227/255>;
#declare CN_Crescendo = rgb <227/255, 223/255, 132/255>;
#declare CN_Crescent_Cream = rgb <237/255, 209/255, 177/255>;
#declare CN_Crescent_Moon = rgb <241/255, 233/255, 207/255>;
#declare CN_Cress_Green = rgb <188/255, 169/255, 73/255>;
#declare CN_Cress_Vinaigrette = rgb <188/255, 181/255, 138/255>;
#declare CN_Cressida = rgb <138/255, 174/255, 124/255>;
#declare CN_Crestline = rgb <180/255, 188/255, 191/255>;
#declare CN_Cretan_Green = rgb <89/255, 135/255, 132/255>;
#declare CN_Crete = rgb <119/255, 113/255, 43/255>;
#declare CN_Crete_Shore = rgb <150/255, 144/255, 139/255>;
#declare CN_Crewel_Tan = rgb <203/255, 185/255, 155/255>;
#declare CN_Cria_Wool = rgb <228/255, 213/255, 188/255>;
#declare CN_Cricket = rgb <166/255, 160/255, 129/255>;
#declare CN_Cricket_Chirping = rgb <199/255, 193/255, 12/255>;
#declare CN_Cricket_Field = rgb <195/255, 210/255, 156/255>;
#declare CN_Cricket_Green = rgb <106/255, 123/255, 107/255>;
#declare CN_Crickets_Cross = rgb <144/255, 138/255, 120/255>;
#declare CN_Crimson = rgb <140/255, 0/255, 15/255>;
#declare CN_Crimson_Glory = rgb <190/255, 0/255, 50/255>;
#declare CN_Crimson_Red = rgb <152/255, 0/255, 1/255>;
#declare CN_Crimson_Silk = rgb <181/255, 65/255, 59/255>;
#declare CN_Crimson_Strawberry = rgb <159/255, 45/255, 71/255>;
#declare CN_Crisis_Red = rgb <187/255, 34/255, 34/255>;
#declare CN_Crisp = rgb <234/255, 235/255, 175/255>;
#declare CN_Crisp_Candlelight = rgb <244/255, 235/255, 208/255>;
#declare CN_Crisp_Capsicum = rgb <93/255, 110/255, 59/255>;
#declare CN_Crisp_Celery = rgb <205/255, 204/255, 166/255>;
#declare CN_Crisp_Cyan = rgb <34/255, 255/255, 255/255>;
#declare CN_Crisp_Green = rgb <171/255, 196/255, 58/255>;
#declare CN_Crisp_Lettuce = rgb <79/255, 151/255, 133/255>;
#declare CN_Crisp_Linen = rgb <231/255, 225/255, 211/255>;
#declare CN_Crisp_Muslin = rgb <233/255, 226/255, 215/255>;
#declare CN_Crisp_Wonton = rgb <243/255, 220/255, 198/255>;
#declare CN_Crispa = rgb <231/255, 223/255, 193/255>;
#declare CN_Crispy_Chicken_Skin = rgb <221/255, 170/255, 68/255>;
#declare CN_Crispy_Crust = rgb <235/255, 224/255, 207/255>;
#declare CN_Crispy_Gingersnap = rgb <187/255, 120/255, 56/255>;
#declare CN_Crispy_Gold = rgb <196/255, 152/255, 50/255>;
#declare CN_Crispy_Samosa = rgb <255/255, 187/255, 102/255>;
#declare CN_Crocker_Grove = rgb <177/255, 166/255, 133/255>;
#declare CN_Crockery = rgb <164/255, 152/255, 135/255>;
#declare CN_Crocodile = rgb <112/255, 105/255, 80/255>;
#declare CN_Crocodile_Eye = rgb <119/255, 119/255, 34/255>;
#declare CN_Crocodile_Green = rgb <183/255, 172/255, 135/255>;
#declare CN_Crocodile_Smile = rgb <137/255, 142/255, 88/255>;
#declare CN_Crocodile_Tears = rgb <214/255, 214/255, 155/255>;
#declare CN_Crocodile_Tooth = rgb <209/255, 204/255, 194/255>;
#declare CN_Crocus = rgb <198/255, 127/255, 174/255>;
#declare CN_Crocus_Petal = rgb <185/255, 155/255, 197/255>;
#declare CN_Crocus_Tint = rgb <253/255, 241/255, 199/255>;
#declare CN_Croissant = rgb <196/255, 171/255, 134/255>;
#declare CN_Croissant_Crumbs = rgb <248/255, 239/255, 216/255>;
#declare CN_Crooked_River = rgb <121/255, 120/255, 105/255>;
#declare CN_Crop_Circle = rgb <233/255, 191/255, 99/255>;
#declare CN_Cropper_Blue = rgb <92/255, 123/255, 151/255>;
#declare CN_Croque_Monsieur = rgb <172/255, 152/255, 119/255>;
#declare CN_Croquet_Blue = rgb <73/255, 113/255, 173/255>;
#declare CN_Cross_My_Heart = rgb <173/255, 42/255, 45/255>;
#declare CN_Crossbow = rgb <96/255, 84/255, 63/255>;
#declare CN_Crossed_Fingers = rgb <221/255, 181/255, 150/255>;
#declare CN_Crossroads = rgb <237/255, 210/255, 163/255>;
#declare CN_Crow = rgb <24/255, 6/255, 20/255>;
#declare CN_Crow_Black = rgb <38/255, 49/255, 69/255>;
#declare CN_Crow_Black_Blue = rgb <17/255, 47/255, 75/255>;
#declare CN_Crowberry = rgb <34/255, 0/255, 85/255>;
#declare CN_Crowberry_Blue = rgb <0/255, 52/255, 71/255>;
#declare CN_Crowd_Pleaser = rgb <91/255, 68/255, 89/255>;
#declare CN_Crown_Blue = rgb <70/255, 75/255, 101/255>;
#declare CN_Crown_Gold = rgb <180/255, 140/255, 96/255>;
#declare CN_Crown_Jewel = rgb <72/255, 45/255, 84/255>;
#declare CN_Crown_Jewels = rgb <148/255, 109/255, 173/255>;
#declare CN_Crown_of_Thorns = rgb <118/255, 60/255, 51/255>;
#declare CN_Crown_Point_Cream = rgb <255/255, 240/255, 193/255>;
#declare CN_Crowned_One = rgb <212/255, 181/255, 151/255>;
#declare CN_Crowning = rgb <90/255, 79/255, 108/255>;
#declare CN_Crowshead = rgb <28/255, 18/255, 8/255>;
#declare CN_Crucified_Red = rgb <204/255, 0/255, 68/255>;
#declare CN_Crude_Banana = rgb <33/255, 196/255, 14/255>;
#declare CN_Cruel_Ruby = rgb <221/255, 51/255, 68/255>;
#declare CN_Cruel_Sea = rgb <33/255, 54/255, 56/255>;
#declare CN_Cruise = rgb <180/255, 226/255, 213/255>;
#declare CN_Cruising = rgb <1/255, 132/255, 152/255>;
#declare CN_Crumble_Topping = rgb <239/255, 206/255, 160/255>;
#declare CN_Crumbling_Statue = rgb <202/255, 191/255, 180/255>;
#declare CN_Crunch = rgb <242/255, 185/255, 95/255>;
#declare CN_Crusade_King = rgb <219/255, 195/255, 100/255>;
#declare CN_Crushed_Almond = rgb <212/255, 202/255, 197/255>;
#declare CN_Crushed_Berries = rgb <209/255, 91/255, 155/255>;
#declare CN_Crushed_Berry = rgb <128/255, 79/255, 90/255>;
#declare CN_Crushed_Cashew = rgb <255/255, 237/255, 213/255>;
#declare CN_Crushed_Cinnamon = rgb <183/255, 115/255, 94/255>;
#declare CN_Crushed_Clay = rgb <174/255, 127/255, 113/255>;
#declare CN_Crushed_Grape = rgb <122/255, 84/255, 127/255>;
#declare CN_Crushed_Ice = rgb <196/255, 255/255, 247/255>;
#declare CN_Crushed_Limestone = rgb <214/255, 221/255, 211/255>;
#declare CN_Crushed_Orange = rgb <227/255, 119/255, 48/255>;
#declare CN_Crushed_Oregano = rgb <99/255, 93/255, 70/255>;
#declare CN_Crushed_Peony = rgb <228/255, 221/255, 216/255>;
#declare CN_Crushed_Pineapple = rgb <239/255, 204/255, 68/255>;
#declare CN_Crushed_Raspberry = rgb <176/255, 104/255, 128/255>;
#declare CN_Crushed_Silk = rgb <216/255, 207/255, 190/255>;
#declare CN_Crushed_Stone = rgb <188/255, 170/255, 159/255>;
#declare CN_Crushed_Velvet = rgb <68/255, 83/255, 151/255>;
#declare CN_Crushed_Violets = rgb <100/255, 58/255, 76/255>;
#declare CN_Crusoe = rgb <22/255, 91/255, 49/255>;
#declare CN_Crust = rgb <137/255, 128/255, 118/255>;
#declare CN_Crusta = rgb <243/255, 134/255, 83/255>;
#declare CN_Crustose_Lichen = rgb <192/255, 78/255, 1/255>;
#declare CN_Cry_Baby_Blue = rgb <195/255, 212/255, 231/255>;
#declare CN_Cryo_Freeze = rgb <221/255, 236/255, 224/255>;
#declare CN_Crypt = rgb <55/255, 59/255, 64/255>;
#declare CN_Cryptic_Light = rgb <109/255, 67/255, 78/255>;
#declare CN_Crystal = rgb <167/255, 216/255, 222/255>;
#declare CN_Crystal_Apple = rgb <206/255, 233/255, 160/255>;
#declare CN_Crystal_Ball = rgb <54/255, 89/255, 85/255>;
#declare CN_Crystal_Bell = rgb <239/255, 238/255, 239/255>;
#declare CN_Crystal_Blue = rgb <104/255, 160/255, 176/255>;
#declare CN_Crystal_Brooke = rgb <228/255, 230/255, 220/255>;
#declare CN_Crystal_Clear = rgb <244/255, 233/255, 234/255>;
#declare CN_Crystal_Cut = rgb <248/255, 244/255, 237/255>;
#declare CN_Crystal_Dark_Red = rgb <109/255, 44/255, 50/255>;
#declare CN_Crystal_Falls = rgb <225/255, 230/255, 242/255>;
#declare CN_Crystal_Gem = rgb <121/255, 208/255, 167/255>;
#declare CN_Crystal_Glass = rgb <221/255, 255/255, 238/255>;
#declare CN_Crystal_Glass_Green = rgb <177/255, 226/255, 203/255>;
#declare CN_Crystal_Green = rgb <164/255, 213/255, 121/255>;
#declare CN_Crystal_Grey = rgb <215/255, 203/255, 196/255>;
#declare CN_Crystal_Haze = rgb <231/255, 226/255, 214/255>;
#declare CN_Crystal_Lake = rgb <136/255, 181/255, 196/255>;
#declare CN_Crystal_Oasis = rgb <175/255, 199/255, 191/255>;
#declare CN_Crystal_Palace = rgb <211/255, 207/255, 171/255>;
#declare CN_Crystal_Pink = rgb <237/255, 208/255, 206/255>;
#declare CN_Crystal_Rapids = rgb <178/255, 228/255, 208/255>;
#declare CN_Crystal_River = rgb <177/255, 226/255, 238/255>;
#declare CN_Crystal_Rose = rgb <253/255, 195/255, 198/255>;
#declare CN_Crystal_Salt_White = rgb <217/255, 229/255, 221/255>;
#declare CN_Crystal_Seas = rgb <93/255, 175/255, 206/255>;
#declare CN_Crystal_Teal = rgb <0/255, 99/255, 124/255>;
#declare CN_Crystal_Waters = rgb <180/255, 206/255, 223/255>;
#declare CN_Crystal_Yellow = rgb <228/255, 217/255, 159/255>;
#declare CN_Crystalline = rgb <233/255, 227/255, 222/255>;
#declare CN_Crystalline_Falls = rgb <217/255, 230/255, 226/255>;
#declare CN_Crystalsong_Blue = rgb <79/255, 179/255, 179/255>;
#declare CN_Cub = rgb <110/255, 92/255, 75/255>;
#declare CN_Cub_Scout = rgb <78/255, 99/255, 65/255>;
#declare CN_Cuba_Brown = rgb <98/255, 61/255, 61/255>;
#declare CN_Cuba_Libre = rgb <115/255, 56/255, 60/255>;
#declare CN_Cuban_Cigar = rgb <146/255, 114/255, 71/255>;
#declare CN_Cuban_Rhythm = rgb <155/255, 85/255, 93/255>;
#declare CN_Cuban_Sand = rgb <193/255, 166/255, 141/255>;
#declare CN_Cucumber = rgb <0/255, 100/255, 0/255>;
#declare CN_Cucumber_Cream = rgb <228/255, 235/255, 177/255>;
#declare CN_Cucumber_Crush = rgb <162/255, 172/255, 134/255>;
#declare CN_Cucumber_Green = rgb <70/255, 99/255, 83/255>;
#declare CN_Cucumber_Ice = rgb <205/255, 215/255, 157/255>;
#declare CN_Cucumber_Milk = rgb <194/255, 241/255, 119/255>;
#declare CN_Cucuzza_Verde = rgb <155/255, 163/255, 115/255>;
#declare CN_Cuddle = rgb <188/255, 202/255, 232/255>;
#declare CN_Cuddlepot = rgb <173/255, 128/255, 104/255>;
#declare CN_Cuddly_Yarn = rgb <255/255, 252/255, 228/255>;
#declare CN_Culinary_Blue = rgb <123/255, 182/255, 193/255>;
#declare CN_Culpeo = rgb <230/255, 155/255, 58/255>;
#declare CN_Cultured = rgb <246/255, 244/255, 245/255>;
#declare CN_Cultured_Pearl = rgb <229/255, 220/255, 214/255>;
#declare CN_Cultured_Rose = rgb <229/255, 134/255, 123/255>;
#declare CN_Cumberland_Fog = rgb <218/255, 219/255, 223/255>;
#declare CN_Cumberland_Sausage = rgb <229/255, 223/255, 220/255>;
#declare CN_Cumin = rgb <165/255, 132/255, 89/255>;
#declare CN_Cumin_Ochre = rgb <160/255, 102/255, 0/255>;
#declare CN_Cummings_Oak = rgb <105/255, 90/255, 69/255>;
#declare CN_Cumquat_Cream = rgb <241/255, 155/255, 125/255>;
#declare CN_Cumulus = rgb <243/255, 243/255, 230/255>;
#declare CN_Cumulus_Cloud = rgb <176/255, 198/255, 223/255>;
#declare CN_Cup_of_Cocoa = rgb <186/255, 160/255, 135/255>;
#declare CN_Cup_of_Tea = rgb <202/255, 174/255, 123/255>;
#declare CN_Cupcake = rgb <138/255, 110/255, 83/255>;
#declare CN_Cupcake_Pink = rgb <246/255, 216/255, 210/255>;
#declare CN_Cupcake_Rose = rgb <230/255, 199/255, 183/255>;
#declare CN_Cupid = rgb <245/255, 178/255, 197/255>;
#declare CN_Cupid_Arrow = rgb <245/255, 226/255, 226/255>;
#declare CN_Cupids_Arrow = rgb <238/255, 107/255, 139/255>;
#declare CN_Cupids_Eye = rgb <255/255, 34/255, 221/255>;
#declare CN_Cupids_Revenge = rgb <238/255, 220/255, 223/255>;
#declare CN_Cupola_Yellow = rgb <220/255, 188/255, 142/255>;
#declare CN_Cuppa_Coffee = rgb <176/255, 159/255, 143/255>;
#declare CN_Curacao_Blue = rgb <0/255, 136/255, 148/255>;
#declare CN_Curd = rgb <248/255, 225/255, 186/255>;
#declare CN_Curds_and_Whey = rgb <188/255, 164/255, 131/255>;
#declare CN_Cure_All = rgb <170/255, 105/255, 136/255>;
#declare CN_Cured_Eggplant = rgb <56/255, 8/255, 53/255>;
#declare CN_Curio = rgb <211/255, 216/255, 210/255>;
#declare CN_Curio_Gray = rgb <152/255, 137/255, 119/255>;
#declare CN_Curious = rgb <217/255, 228/255, 158/255>;
#declare CN_Curious_Blue = rgb <61/255, 133/255, 184/255>;
#declare CN_Curious_Chipmunk = rgb <218/255, 191/255, 164/255>;
#declare CN_Curious_Collection = rgb <210/255, 187/255, 152/255>;
#declare CN_Curlew = rgb <118/255, 104/255, 89/255>;
#declare CN_Curly_Maple = rgb <216/255, 200/255, 190/255>;
#declare CN_Curly_Willow = rgb <177/255, 163/255, 135/255>;
#declare CN_Currant_Jam = rgb <136/255, 74/255, 80/255>;
#declare CN_Currant_Violet = rgb <85/255, 62/255, 81/255>;
#declare CN_Curry = rgb <214/255, 163/255, 50/255>;
#declare CN_Curry_Brown = rgb <132/255, 80/255, 56/255>;
#declare CN_Curry_Bubbels = rgb <245/255, 183/255, 0/255>;
#declare CN_Curry_Powder = rgb <204/255, 102/255, 0/255>;
#declare CN_Curry_Sauce = rgb <190/255, 158/255, 111/255>;
#declare CN_Currywurst = rgb <221/255, 170/255, 51/255>;
#declare CN_Curtain_Call = rgb <112/255, 102/255, 106/255>;
#declare CN_Curtsy = rgb <255/255, 214/255, 184/255>;
#declare CN_Cushion_Bush = rgb <193/255, 200/255, 175/255>;
#declare CN_Custard = rgb <255/255, 253/255, 120/255>;
#declare CN_Custard_Cream = rgb <251/255, 239/255, 208/255>;
#declare CN_Custard_Powder = rgb <248/255, 220/255, 170/255>;
#declare CN_Custard_Puff = rgb <252/255, 238/255, 174/255>;
#declare CN_Customs_Green = rgb <0/255, 56/255, 57/255>;
#declare CN_Cut_Heather = rgb <158/255, 144/255, 158/255>;
#declare CN_Cut_of_Mustard = rgb <188/255, 145/255, 77/255>;
#declare CN_Cut_the_Mustard = rgb <186/255, 127/255, 56/255>;
#declare CN_Cut_Velvet = rgb <179/255, 145/255, 200/255>;
#declare CN_Cute_Crab = rgb <221/255, 68/255, 68/255>;
#declare CN_Cute_Little_Pink = rgb <244/255, 226/255, 225/255>;
#declare CN_Cute_Pixie = rgb <141/255, 141/255, 64/255>;
#declare CN_Cuticle_Pink = rgb <227/255, 164/255, 154/255>;
#declare CN_Cutlery_Polish = rgb <244/255, 221/255, 165/255>;
#declare CN_Cuttlefish = rgb <127/255, 187/255, 194/255>;
#declare CN_Cutty_Sark = rgb <92/255, 129/255, 115/255>;
#declare CN_Cyan = rgb <15/255, 240/255, 254/255>;
#declare CN_Cyan_Azure = rgb <78/255, 130/255, 180/255>;
#declare CN_Cyan_Blue = rgb <20/255, 163/255, 199/255>;
#declare CN_Cyan_Cobalt_Blue = rgb <40/255, 88/255, 156/255>;
#declare CN_Cyan_Cornflower_Blue = rgb <24/255, 139/255, 194/255>;
#declare CN_Cyan_Sky = rgb <0/255, 181/255, 184/255>;
#declare CN_Cyanara = rgb <119/255, 144/255, 128/255>;
#declare CN_Cyanite = rgb <0/255, 183/255, 235/255>;
#declare CN_Cyber_Grape = rgb <88/255, 66/255, 124/255>;
#declare CN_Cyber_Lavender = rgb <230/255, 230/255, 250/255>;
#declare CN_Cyber_Yellow = rgb <255/255, 212/255, 0/255>;
#declare CN_Cyberpink = rgb <255/255, 32/255, 119/255>;
#declare CN_Cyberspace = rgb <68/255, 72/255, 77/255>;
#declare CN_Cyclamen = rgb <214/255, 135/255, 186/255>;
#declare CN_Cyclamen_Red = rgb <167/255, 89/255, 141/255>;
#declare CN_Cymophane_Yellow = rgb <243/255, 228/255, 167/255>;
#declare CN_Cynical_Black = rgb <23/255, 23/255, 23/255>;
#declare CN_Cypress = rgb <84/255, 90/255, 62/255>;
#declare CN_Cypress_Bark_Red = rgb <111/255, 48/255, 40/255>;
#declare CN_Cypress_Garden = rgb <102/255, 124/255, 113/255>;
#declare CN_Cypress_Green = rgb <158/255, 143/255, 87/255>;
#declare CN_Cypress_Grey_Blue = rgb <106/255, 119/255, 134/255>;
#declare CN_Cypress_Vine = rgb <94/255, 101/255, 82/255>;
#declare CN_Cyprus = rgb <15/255, 70/255, 69/255>;
#declare CN_Cyprus_Green = rgb <105/255, 154/255, 136/255>;
#declare CN_Cyprus_Spring = rgb <172/255, 183/255, 176/255>;
#declare CN_Cyrus_Grass = rgb <207/255, 197/255, 167/255>;
#declare CN_Czarina = rgb <119/255, 88/255, 89/255>;
#declare CN_Czech_Bakery = rgb <222/255, 201/255, 169/255>;
#declare CN_D_Darx_Blue = rgb <3/255, 7/255, 100/255>;
#declare CN_Da_Blues = rgb <81/255, 97/255, 114/255>;
#declare CN_Daah_Ling = rgb <170/255, 97/255, 121/255>;
#declare CN_Dachshund = rgb <112/255, 79/255, 55/255>;
#declare CN_Dads_Coupe = rgb <47/255, 72/255, 78/255>;
#declare CN_Daddy_O = rgb <176/255, 175/255, 138/255>;
#declare CN_Daemonette_Hide = rgb <105/255, 102/255, 132/255>;
#declare CN_Daffodil = rgb <255/255, 255/255, 49/255>;
#declare CN_Daffodil_Yellow = rgb <255/255, 226/255, 133/255>;
#declare CN_Dagger_Moth = rgb <232/255, 225/255, 213/255>;
#declare CN_Dahlia = rgb <132/255, 62/255, 131/255>;
#declare CN_Dahlia_Delight = rgb <248/255, 187/255, 211/255>;
#declare CN_Dahlia_Matte_Red = rgb <118/255, 80/255, 103/255>;
#declare CN_Dahlia_Mauve = rgb <166/255, 79/255, 130/255>;
#declare CN_Dahlia_Purple = rgb <126/255, 110/255, 172/255>;
#declare CN_Daikon_White = rgb <212/255, 212/255, 196/255>;
#declare CN_Daintree = rgb <1/255, 39/255, 49/255>;
#declare CN_Dainty_Apricot = rgb <253/255, 197/255, 146/255>;
#declare CN_Dainty_Debutante = rgb <244/255, 189/255, 179/255>;
#declare CN_Dainty_Flower = rgb <233/255, 223/255, 229/255>;
#declare CN_Dainty_Lace = rgb <222/255, 207/255, 187/255>;
#declare CN_Dainty_Pink = rgb <236/255, 188/255, 206/255>;
#declare CN_Daiquiri_Green = rgb <201/255, 215/255, 126/255>;
#declare CN_Dairy_Cream = rgb <237/255, 210/255, 164/255>;
#declare CN_Dairy_Made = rgb <240/255, 179/255, 60/255>;
#declare CN_Daisy = rgb <254/255, 211/255, 64/255>;
#declare CN_Daisy_Bush = rgb <91/255, 62/255, 144/255>;
#declare CN_Daisy_Chain = rgb <255/255, 240/255, 155/255>;
#declare CN_Daisy_Desi = rgb <252/255, 223/255, 138/255>;
#declare CN_Daisy_Field = rgb <244/255, 243/255, 232/255>;
#declare CN_Daisy_Leaf = rgb <85/255, 100/255, 59/255>;
#declare CN_Daisy_White = rgb <248/255, 243/255, 227/255>;
#declare CN_Dakota_Wheat = rgb <225/255, 189/255, 142/255>;
#declare CN_Dallas = rgb <102/255, 74/255, 45/255>;
#declare CN_Dallas_Dust = rgb <236/255, 224/255, 214/255>;
#declare CN_Dallol_Yellow = rgb <253/255, 220/255, 0/255>;
#declare CN_Dalmatian_Sage = rgb <151/255, 163/255, 218/255>;
#declare CN_Daly_Waters = rgb <175/255, 218/255, 223/255>;
#declare CN_Damask = rgb <252/255, 242/255, 223/255>;
#declare CN_Dame_Dignity = rgb <153/255, 155/255, 168/255>;
#declare CN_Damp_Basement = rgb <95/255, 97/255, 113/255>;
#declare CN_Damsel = rgb <198/255, 158/255, 174/255>;
#declare CN_Damson = rgb <133/255, 76/255, 101/255>;
#declare CN_Damson_Mauve = rgb <88/255, 53/255, 99/255>;
#declare CN_Damson_Plum = rgb <221/255, 160/255, 221/255>;
#declare CN_Dana = rgb <87/255, 103/255, 128/255>;
#declare CN_Dance_Studio = rgb <6/255, 77/255, 131/255>;
#declare CN_Dancer = rgb <220/255, 147/255, 153/255>;
#declare CN_Dancing_Butterfly = rgb <252/255, 243/255, 198/255>;
#declare CN_Dancing_Crocodiles = rgb <37/255, 74/255, 71/255>;
#declare CN_Dancing_Daisy = rgb <239/255, 200/255, 87/255>;
#declare CN_Dancing_Dogs = rgb <110/255, 73/255, 61/255>;
#declare CN_Dancing_Dolphin = rgb <196/255, 186/255, 161/255>;
#declare CN_Dancing_Dragonfly = rgb <0/255, 102/255, 88/255>;
#declare CN_Dancing_Green = rgb <197/255, 205/255, 143/255>;
#declare CN_Dancing_in_the_Rain = rgb <171/255, 197/255, 214/255>;
#declare CN_Dancing_in_the_Spring = rgb <123/255, 114/255, 137/255>;
#declare CN_Dancing_Jewel = rgb <66/255, 155/255, 119/255>;
#declare CN_Dancing_Kite = rgb <200/255, 204/255, 158/255>;
#declare CN_Dancing_Mist = rgb <191/255, 200/255, 216/255>;
#declare CN_Dancing_Sea = rgb <28/255, 77/255, 143/255>;
#declare CN_Dancing_Wand = rgb <200/255, 164/255, 189/255>;
#declare CN_Dancing_Lady_Orchid = rgb <223/255, 255/255, 0/255>;
#declare CN_Dandelion = rgb <254/255, 223/255, 8/255>;
#declare CN_Dandelion_Floatie = rgb <234/255, 232/255, 236/255>;
#declare CN_Dandelion_Tea = rgb <247/255, 234/255, 193/255>;
#declare CN_Dandelion_Tincture = rgb <240/255, 225/255, 48/255>;
#declare CN_Dandelion_Whisper = rgb <255/255, 240/255, 181/255>;
#declare CN_Dandelion_Wine = rgb <252/255, 242/255, 185/255>;
#declare CN_Dandelion_Wish = rgb <227/255, 187/255, 101/255>;
#declare CN_Dandelion_Yellow = rgb <252/255, 217/255, 59/255>;
#declare CN_Dandy_Lion = rgb <250/255, 204/255, 81/255>;
#declare CN_Danger = rgb <255/255, 14/255, 14/255>;
#declare CN_Danger_Ridge = rgb <89/255, 85/255, 57/255>;
#declare CN_Dangerous_Robot = rgb <203/255, 197/255, 198/255>;
#declare CN_Dangerously_Elegant = rgb <97/255, 107/255, 137/255>;
#declare CN_Dangerously_Red = rgb <216/255, 65/255, 57/255>;
#declare CN_Daniel_Boone = rgb <94/255, 66/255, 53/255>;
#declare CN_Danish_Pine = rgb <186/255, 153/255, 103/255>;
#declare CN_Dante_Peak = rgb <180/255, 213/255, 213/255>;
#declare CN_Danube = rgb <91/255, 137/255, 192/255>;
#declare CN_Daphne = rgb <15/255, 95/255, 154/255>;
#declare CN_Daphne_Rose = rgb <195/255, 124/255, 179/255>;
#declare CN_Dapper = rgb <113/255, 91/255, 73/255>;
#declare CN_Dapper_Dingo = rgb <226/255, 194/255, 153/255>;
#declare CN_Dapper_Greyhound = rgb <105/255, 112/255, 120/255>;
#declare CN_Dapper_Tan = rgb <148/255, 127/255, 101/255>;
#declare CN_Dapple_Grey = rgb <149/255, 148/255, 134/255>;
#declare CN_Dappled_Sunlight = rgb <242/255, 227/255, 201/255>;
#declare CN_Dard_Hunter_Green = rgb <58/255, 74/255, 63/255>;
#declare CN_Daredevil = rgb <171/255, 67/255, 67/255>;
#declare CN_Daring = rgb <223/255, 100/255, 78/255>;
#declare CN_Daring_Deception = rgb <240/255, 223/255, 224/255>;
#declare CN_Daring_Indigo = rgb <55/255, 72/255, 116/255>;
#declare CN_Dark = rgb <27/255, 36/255, 49/255>;
#declare CN_Dark__Stormy = rgb <53/255, 63/255, 81/255>;
#declare CN_Dark_Ages = rgb <150/255, 152/255, 163/255>;
#declare CN_Dark_as_Night = rgb <73/255, 82/255, 82/255>;
#declare CN_Dark_Ash = rgb <106/255, 109/255, 109/255>;
#declare CN_Dark_Berry = rgb <92/255, 70/255, 74/255>;
#declare CN_Dark_Blackberry = rgb <83/255, 57/255, 88/255>;
#declare CN_Dark_Blond = rgb <166/255, 138/255, 110/255>;
#declare CN_Dark_Blue = rgb <48/255, 86/255, 121/255>;
#declare CN_Dark_Brazilian_Topaz = rgb <146/255, 70/255, 47/255>;
#declare CN_Dark_Burgundy_Wine = rgb <75/255, 65/255, 70/255>;
#declare CN_Dark_Cavern = rgb <85/255, 80/255, 77/255>;
#declare CN_Dark_Cherry_Mocha = rgb <119/255, 77/255, 65/255>;
#declare CN_Dark_Citron = rgb <170/255, 187/255, 0/255>;
#declare CN_Dark_Clove = rgb <76/255, 61/255, 49/255>;
#declare CN_Dark_Cobalt_Blue = rgb <51/255, 87/255, 138/255>;
#declare CN_Dark_Crimson = rgb <132/255, 60/255, 65/255>;
#declare CN_Dark_Crypt = rgb <63/255, 69/255, 81/255>;
#declare CN_Dark_Cyan = rgb <0/255, 139/255, 139/255>;
#declare CN_Dark_Denim = rgb <0/255, 85/255, 136/255>;
#declare CN_Dark_Denim_Blue = rgb <0/255, 51/255, 79/255>;
#declare CN_Dark_Dreams = rgb <51/255, 34/255, 102/255>;
#declare CN_Dark_Earth = rgb <136/255, 68/255, 85/255>;
#declare CN_Dark_Eclipse = rgb <17/255, 34/255, 68/255>;
#declare CN_Dark_Elf = rgb <59/255, 63/255, 66/255>;
#declare CN_Dark_Emerald = rgb <0/255, 131/255, 78/255>;
#declare CN_Dark_Energy = rgb <80/255, 61/255, 77/255>;
#declare CN_Dark_Engine = rgb <62/255, 63/255, 65/255>;
#declare CN_Dark_Envy = rgb <164/255, 165/255, 130/255>;
#declare CN_Dark_Everglade = rgb <62/255, 85/255, 79/255>;
#declare CN_Dark_Fern = rgb <10/255, 72/255, 13/255>;
#declare CN_Dark_Fig_Violet = rgb <87/255, 59/255, 76/255>;
#declare CN_Dark_Forest = rgb <85/255, 105/255, 98/255>;
#declare CN_Dark_Galaxy = rgb <0/255, 24/255, 168/255>;
#declare CN_Dark_Granite = rgb <79/255, 68/255, 63/255>;
#declare CN_Dark_Green = rgb <3/255, 53/255, 0/255>;
#declare CN_Dark_Grey = rgb <54/255, 55/255, 55/255>;
#declare CN_Dark_Grey_Mauve = rgb <78/255, 68/255, 89/255>;
#declare CN_Dark_Horizon = rgb <102/255, 102/255, 153/255>;
#declare CN_Dark_Imperial_Blue = rgb <0/255, 65/255, 106/255>;
#declare CN_Dark_Iris = rgb <77/255, 90/255, 126/255>;
#declare CN_Dark_Ivy = rgb <91/255, 119/255, 99/255>;
#declare CN_Dark_Jade = rgb <92/255, 135/255, 116/255>;
#declare CN_Dark_Knight = rgb <21/255, 25/255, 49/255>;
#declare CN_Dark_Lagoon = rgb <106/255, 127/255, 125/255>;
#declare CN_Dark_Lavender = rgb <133/255, 103/255, 152/255>;
#declare CN_Dark_Lemon_Lime = rgb <139/255, 190/255, 27/255>;
#declare CN_Dark_Lilac = rgb <156/255, 109/255, 165/255>;
#declare CN_Dark_Lime = rgb <132/255, 183/255, 1/255>;
#declare CN_Dark_Lime_Green = rgb <126/255, 189/255, 1/255>;
#declare CN_Dark_Limestone = rgb <152/255, 154/255, 152/255>;
#declare CN_Dark_LUA_Console = rgb <95/255, 87/255, 79/255>;
#declare CN_Dark_Magenta = rgb <139/255, 0/255, 139/255>;
#declare CN_Dark_Mahogany = rgb <72/255, 32/255, 41/255>;
#declare CN_Dark_Marmalade = rgb <153/255, 73/255, 57/255>;
#declare CN_Dark_Maroon = rgb <60/255, 0/255, 8/255>;
#declare CN_Dark_Matter = rgb <17/255, 1/255, 1/255>;
#declare CN_Dark_Midnight_Blue = rgb <0/255, 51/255, 119/255>;
#declare CN_Dark_Mountain_Meadow = rgb <26/255, 179/255, 133/255>;
#declare CN_Dark_Navy = rgb <64/255, 73/255, 91/255>;
#declare CN_Dark_Night = rgb <64/255, 75/255, 87/255>;
#declare CN_Dark_Olive = rgb <55/255, 62/255, 2/255>;
#declare CN_Dark_Olive_Green = rgb <69/255, 70/255, 54/255>;
#declare CN_Dark_Olive_Paste = rgb <110/255, 81/255, 96/255>;
#declare CN_Dark_Onyx = rgb <46/255, 45/255, 48/255>;
#declare CN_Dark_Orange = rgb <198/255, 81/255, 2/255>;
#declare CN_Dark_Pansy = rgb <101/255, 61/255, 124/255>;
#declare CN_Dark_Periwinkle = rgb <102/255, 95/255, 209/255>;
#declare CN_Dark_Pewter = rgb <96/255, 104/255, 101/255>;
#declare CN_Dark_Pine_Green = rgb <25/255, 50/255, 50/255>;
#declare CN_Dark_Pink = rgb <203/255, 65/255, 107/255>;
#declare CN_Dark_Potion = rgb <96/255, 62/255, 83/255>;
#declare CN_Dark_Princess_Pink = rgb <217/255, 48/255, 138/255>;
#declare CN_Dark_Puce = rgb <79/255, 58/255, 60/255>;
#declare CN_Dark_Purple = rgb <53/255, 6/255, 62/255>;
#declare CN_Dark_Purple_Grey = rgb <110/255, 87/255, 107/255>;
#declare CN_Dark_Rainforest = rgb <80/255, 88/255, 56/255>;
#declare CN_Dark_Raspberry = rgb <135/255, 38/255, 87/255>;
#declare CN_Dark_Reaper = rgb <59/255, 81/255, 80/255>;
#declare CN_Dark_Red = rgb <132/255, 0/255, 0/255>;
#declare CN_Dark_Red_Brown = rgb <74/255, 33/255, 37/255>;
#declare CN_Dark_River = rgb <62/255, 68/255, 69/255>;
#declare CN_Dark_Room = rgb <98/255, 109/255, 123/255>;
#declare CN_Dark_Rose = rgb <181/255, 72/255, 93/255>;
#declare CN_Dark_Royalty = rgb <2/255, 6/255, 111/255>;
#declare CN_Dark_Rum = rgb <69/255, 54/255, 43/255>;
#declare CN_Dark_Sage = rgb <109/255, 118/255, 91/255>;
#declare CN_Dark_Sakura = rgb <162/255, 100/255, 111/255>;
#declare CN_Dark_Salmon = rgb <200/255, 90/255, 83/255>;
#declare CN_Dark_Sanctuary = rgb <63/255, 1/255, 44/255>;
#declare CN_Dark_Sand = rgb <168/255, 143/255, 89/255>;
#declare CN_Dark_Sapphire = rgb <8/255, 37/255, 103/255>;
#declare CN_Dark_Sea = rgb <76/255, 85/255, 96/255>;
#declare CN_Dark_Seagreen = rgb <102/255, 102/255, 85/255>;
#declare CN_Dark_Seashore_Night = rgb <17/255, 54/255, 145/255>;
#declare CN_Dark_Secret = rgb <62/255, 83/255, 97/255>;
#declare CN_Dark_Shadow = rgb <74/255, 75/255, 77/255>;
#declare CN_Dark_Shadows = rgb <91/255, 89/255, 93/255>;
#declare CN_Dark_Shamrock = rgb <51/255, 204/255, 153/255>;
#declare CN_Dark_Side = rgb <0/255, 68/255, 68/255>;
#declare CN_Dark_Side_of_the_Moon = rgb <7/255, 13/255, 13/255>;
#declare CN_Dark_Sienna = rgb <60/255, 20/255, 20/255>;
#declare CN_Dark_Sky = rgb <144/255, 153/255, 137/255>;
#declare CN_Dark_Slate = rgb <70/255, 83/255, 82/255>;
#declare CN_Dark_Slate_Blue = rgb <33/255, 71/255, 97/255>;
#declare CN_Dark_Slate_Grey = rgb <47/255, 79/255, 79/255>;
#declare CN_Dark_Slimelime = rgb <102/255, 170/255, 17/255>;
#declare CN_Dark_Sorrel = rgb <88/255, 122/255, 101/255>;
#declare CN_Dark_Soul = rgb <17/255, 34/255, 85/255>;
#declare CN_Dark_Souls = rgb <163/255, 163/255, 162/255>;
#declare CN_Dark_Spell = rgb <48/255, 59/255, 76/255>;
#declare CN_Dark_Sting = rgb <126/255, 115/255, 109/255>;
#declare CN_Dark_Storm_Cloud = rgb <129/255, 144/255, 148/255>;
#declare CN_Dark_Strawberry = rgb <128/255, 68/255, 76/255>;
#declare CN_Dark_Summoning = rgb <56/255, 56/255, 57/255>;
#declare CN_Dark_Taupe = rgb <72/255, 60/255, 60/255>;
#declare CN_Dark_Tavern = rgb <99/255, 78/255, 67/255>;
#declare CN_Dark_Teal = rgb <1/255, 77/255, 78/255>;
#declare CN_Dark_Tone_Ink = rgb <18/255, 18/255, 18/255>;
#declare CN_Dark_Topaz = rgb <129/255, 124/255, 135/255>;
#declare CN_Dark_Truffle = rgb <89/255, 77/255, 70/255>;
#declare CN_Dark_Turquoise = rgb <4/255, 92/255, 90/255>;
#declare CN_Dark_Veil = rgb <20/255, 19/255, 17/255>;
#declare CN_Dark_Violet = rgb <52/255, 1/255, 63/255>;
#declare CN_Dark_Void = rgb <21/255, 21/255, 23/255>;
#declare CN_Dark_Walnut = rgb <86/255, 68/255, 62/255>;
#declare CN_Dark_Wood = rgb <133/255, 94/255, 66/255>;
#declare CN_Dark_Wood_Grain = rgb <79/255, 48/255, 31/255>;
#declare CN_Dark_Yellow = rgb <231/255, 191/255, 142/255>;
#declare CN_Darkest_Dungeon = rgb <102/255, 0/255, 17/255>;
#declare CN_Darkest_Grape = rgb <98/255, 87/255, 104/255>;
#declare CN_Darkest_Navy = rgb <67/255, 69/255, 94/255>;
#declare CN_Darkest_Spruce = rgb <48/255, 63/255, 61/255>;
#declare CN_Darkness = rgb <22/255, 22/255, 14/255>;
#declare CN_Darkness_Green = rgb <58/255, 70/255, 69/255>;
#declare CN_Darkout = rgb <45/255, 22/255, 8/255>;
#declare CN_Darkroom = rgb <68/255, 62/255, 64/255>;
#declare CN_Darkshore = rgb <70/255, 73/255, 100/255>;
#declare CN_Darlak = rgb <79/255, 73/255, 105/255>;
#declare CN_Darling_Bud = rgb <255/255, 136/255, 255/255>;
#declare CN_Darling_Clementine = rgb <210/255, 159/255, 122/255>;
#declare CN_Darling_Lilac = rgb <201/255, 172/255, 214/255>;
#declare CN_Darth_Torus = rgb <29/255, 4/255, 93/255>;
#declare CN_Darth_Umber = rgb <147/255, 41/255, 4/255>;
#declare CN_Darth_Vader = rgb <11/255, 11/255, 11/255>;
#declare CN_Dartmoor_Mist = rgb <205/255, 220/255, 227/255>;
#declare CN_Dartmouth_Green = rgb <0/255, 112/255, 60/255>;
#declare CN_Dash_of_Curry = rgb <202/255, 110/255, 95/255>;
#declare CN_Dash_of_Oregano = rgb <146/255, 132/255, 89/255>;
#declare CN_Dashing = rgb <234/255, 235/255, 232/255>;
#declare CN_Date_Fruit_Brown = rgb <175/255, 100/255, 43/255>;
#declare CN_DaVanzo_Beige = rgb <204/255, 172/255, 134/255>;
#declare CN_DaVanzo_Green = rgb <88/255, 147/255, 109/255>;
#declare CN_Davao_Green = rgb <177/255, 210/255, 123/255>;
#declare CN_Daves_Den = rgb <195/255, 191/255, 174/255>;
#declare CN_Davys_Grey = rgb <85/255, 85/255, 85/255>;
#declare CN_Dawn = rgb <159/255, 157/255, 145/255>;
#declare CN_Dawn_Blue = rgb <202/255, 204/255, 203/255>;
#declare CN_Dawn_Departs = rgb <204/255, 255/255, 255/255>;
#declare CN_Dawn_Grey = rgb <109/255, 114/255, 115/255>;
#declare CN_Dawn_of_the_Fairies = rgb <119/255, 0/255, 68/255>;
#declare CN_Dawn_Pink = rgb <230/255, 214/255, 205/255>;
#declare CN_Dawnstone = rgb <112/255, 117/255, 110/255>;
#declare CN_Day_At_The_Zoo = rgb <255/255, 163/255, 115/255>;
#declare CN_Day_Dreamer = rgb <217/255, 205/255, 196/255>;
#declare CN_Day_Glow = rgb <234/255, 221/255, 130/255>;
#declare CN_Day_Glow_Orange = rgb <235/255, 92/255, 52/255>;
#declare CN_Day_Lily = rgb <255/255, 249/255, 236/255>;
#declare CN_Day_On_Mercury = rgb <213/255, 210/255, 209/255>;
#declare CN_Day_Spa = rgb <234/255, 239/255, 237/255>;
#declare CN_Daybreak = rgb <137/255, 129/255, 160/255>;
#declare CN_Daybreak_Sun = rgb <247/255, 238/255, 203/255>;
#declare CN_Daydream = rgb <227/255, 235/255, 174/255>;
#declare CN_Daydreaming = rgb <244/255, 240/255, 225/255>;
#declare CN_Dayflower = rgb <56/255, 161/255, 219/255>;
#declare CN_Daylight_Lilac = rgb <163/255, 133/255, 179/255>;
#declare CN_Daylily_Yellow = rgb <248/255, 240/255, 210/255>;
#declare CN_Daystar = rgb <255/255, 248/255, 218/255>;
#declare CN_Dazzle = rgb <82/255, 135/255, 185/255>;
#declare CN_Dazzle_and_Delight = rgb <217/255, 155/255, 123/255>;
#declare CN_Dazzle_Me = rgb <237/255, 235/255, 234/255>;
#declare CN_Dazzling_Blue = rgb <56/255, 80/255, 160/255>;
#declare CN_De_York = rgb <133/255, 202/255, 135/255>;
#declare CN_Dead_99 = rgb <153/255, 222/255, 173/255>;
#declare CN_Dead_Blue_Eyes = rgb <0/255, 85/255, 204/255>;
#declare CN_Dead_Flesh = rgb <132/255, 155/255, 99/255>;
#declare CN_Dead_Forest = rgb <67/255, 75/255, 79/255>;
#declare CN_Dead_Grass = rgb <228/255, 220/255, 138/255>;
#declare CN_Dead_Lake = rgb <46/255, 90/255, 136/255>;
#declare CN_Dead_Nettle_White = rgb <210/255, 218/255, 208/255>;
#declare CN_Dead_Pixel = rgb <59/255, 58/255, 58/255>;
#declare CN_Dead_Sea = rgb <119/255, 238/255, 238/255>;
#declare CN_Dead_Sea_Mud = rgb <58/255, 64/255, 59/255>;
#declare CN_Deadlock = rgb <143/255, 102/255, 106/255>;
#declare CN_Deadly_Depths = rgb <17/255, 17/255, 68/255>;
#declare CN_Deadsy = rgb <194/255, 168/255, 75/255>;
#declare CN_Deadwind_Pass = rgb <89/255, 109/255, 127/255>;
#declare CN_Death_by_Chocolate = rgb <96/255, 68/255, 63/255>;
#declare CN_Death_Cap = rgb <231/255, 217/255, 219/255>;
#declare CN_Death_Guard = rgb <158/255, 179/255, 123/255>;
#declare CN_Death_Valley_Beige = rgb <221/255, 187/255, 136/255>;
#declare CN_Deathclaw_Brown = rgb <179/255, 104/255, 83/255>;
#declare CN_Deathworld_Forest = rgb <92/255, 103/255, 48/255>;
#declare CN_Deauville_Mauve = rgb <175/255, 146/255, 148/255>;
#declare CN_Debian_Red = rgb <215/255, 10/255, 83/255>;
#declare CN_Debonair = rgb <144/255, 160/255, 166/255>;
#declare CN_Debonaire = rgb <203/255, 208/255, 221/255>;
#declare CN_Debrito = rgb <238/255, 119/255, 68/255>;
#declare CN_Debutante_Ball = rgb <110/255, 141/255, 187/255>;
#declare CN_Decadence = rgb <115/255, 102/255, 123/255>;
#declare CN_Decadent_Chocolate = rgb <81/255, 50/255, 53/255>;
#declare CN_Decadial_Pink = rgb <222/255, 202/255, 222/255>;
#declare CN_Decanter = rgb <173/255, 163/255, 187/255>;
#declare CN_Decanting = rgb <191/255, 161/255, 173/255>;
#declare CN_Decaying_Leave = rgb <213/255, 120/255, 53/255>;
#declare CN_December_Dawn = rgb <223/255, 226/255, 234/255>;
#declare CN_December_Eve = rgb <65/255, 80/255, 100/255>;
#declare CN_December_Forest = rgb <224/255, 232/255, 219/255>;
#declare CN_December_Rain = rgb <214/255, 221/255, 220/255>;
#declare CN_December_Sky = rgb <213/255, 215/255, 217/255>;
#declare CN_Decency = rgb <191/255, 181/255, 202/255>;
#declare CN_Dechala_Lilac = rgb <182/255, 159/255, 204/255>;
#declare CN_Dechant_Pear_Yellow = rgb <215/255, 158/255, 98/255>;
#declare CN_Decisive_Yellow = rgb <253/255, 204/255, 78/255>;
#declare CN_Deck_Crew = rgb <94/255, 124/255, 172/255>;
#declare CN_Deco = rgb <204/255, 207/255, 130/255>;
#declare CN_Deco_Grey = rgb <137/255, 151/255, 142/255>;
#declare CN_Deco_Pink = rgb <246/255, 194/255, 204/255>;
#declare CN_Deco_Red = rgb <130/255, 73/255, 66/255>;
#declare CN_Deco_Rose = rgb <152/255, 95/255, 104/255>;
#declare CN_Deco_Shell = rgb <249/255, 213/255, 201/255>;
#declare CN_Deco_Rate = rgb <143/255, 203/255, 192/255>;
#declare CN_Deconstruction = rgb <123/255, 115/255, 107/255>;
#declare CN_Decor_White = rgb <242/255, 229/255, 207/255>;
#declare CN_Decor_Yellow = rgb <246/255, 187/255, 0/255>;
#declare CN_Decoration_Blue = rgb <63/255, 116/255, 163/255>;
#declare CN_Decorative_Iris = rgb <129/255, 113/255, 129/255>;
#declare CN_Decorator_White = rgb <246/255, 244/255, 236/255>;
#declare CN_Decore_Splash = rgb <0/255, 130/255, 158/255>;
#declare CN_Decorous_Amber = rgb <172/255, 117/255, 89/255>;
#declare CN_Decorum = rgb <179/255, 154/255, 160/255>;
#declare CN_Dedication = rgb <254/255, 226/255, 200/255>;
#declare CN_Deduction = rgb <212/255, 203/255, 131/255>;
#declare CN_Deep_Amethyst = rgb <91/255, 48/255, 130/255>;
#declare CN_Deep_Aquamarine = rgb <120/255, 219/255, 226/255>;
#declare CN_Deep_Atlantic_Blue = rgb <0/255, 79/255, 87/255>;
#declare CN_Deep_Aubergine = rgb <92/255, 74/255, 77/255>;
#declare CN_Deep_Azure = rgb <62/255, 85/255, 128/255>;
#declare CN_Deep_Bamboo_Yellow = rgb <217/255, 159/255, 80/255>;
#declare CN_Deep_Bloom = rgb <197/255, 119/255, 118/255>;
#declare CN_Deep_Blue = rgb <4/255, 2/255, 115/255>;
#declare CN_Deep_Blue_Sea = rgb <26/255, 93/255, 114/255>;
#declare CN_Deep_Blush = rgb <227/255, 111/255, 138/255>;
#declare CN_Deep_Bottlebrush = rgb <94/255, 103/255, 90/255>;
#declare CN_Deep_Breath = rgb <39/255, 39/255, 95/255>;
#declare CN_Deep_Bronze = rgb <81/255, 65/255, 45/255>;
#declare CN_Deep_Brown = rgb <52/255, 42/255, 42/255>;
#declare CN_Deep_Cerulean = rgb <0/255, 123/255, 187/255>;
#declare CN_Deep_Champagne = rgb <250/255, 214/255, 197/255>;
#declare CN_Deep_Cherrywood = rgb <107/255, 71/255, 61/255>;
#declare CN_Deep_Chestnut = rgb <185/255, 78/255, 72/255>;
#declare CN_Deep_Claret = rgb <119/255, 17/255, 51/255>;
#declare CN_Deep_Cobalt = rgb <64/255, 68/255, 102/255>;
#declare CN_Deep_Coral = rgb <218/255, 124/255, 85/255>;
#declare CN_Deep_Cove = rgb <5/255, 16/255, 64/255>;
#declare CN_Deep_Current = rgb <0/255, 115/255, 129/255>;
#declare CN_Deep_Denim = rgb <102/255, 136/255, 255/255>;
#declare CN_Deep_Depths = rgb <70/255, 72/255, 60/255>;
#declare CN_Deep_Dive = rgb <41/255, 73/255, 92/255>;
#declare CN_Deep_Diving = rgb <94/255, 151/255, 169/255>;
#declare CN_Deep_Dungeon = rgb <85/255, 61/255, 58/255>;
#declare CN_Deep_Earth = rgb <77/255, 75/255, 75/255>;
#declare CN_Deep_Emerald = rgb <85/255, 101/255, 81/255>;
#declare CN_Deep_Evergreen = rgb <76/255, 87/255, 75/255>;
#declare CN_Deep_Exquisite = rgb <97/255, 68/255, 84/255>;
#declare CN_Deep_Fir = rgb <25/255, 57/255, 37/255>;
#declare CN_Deep_Fire = rgb <191/255, 92/255, 66/255>;
#declare CN_Deep_Forest = rgb <55/255, 65/255, 58/255>;
#declare CN_Deep_Forest_Brown = rgb <57/255, 52/255, 55/255>;
#declare CN_Deep_Garnet = rgb <95/255, 66/255, 70/255>;
#declare CN_Deep_Green = rgb <2/255, 89/255, 15/255>;
#declare CN_Deep_Indigo = rgb <76/255, 86/255, 122/255>;
#declare CN_Deep_into_the_Jungle = rgb <0/255, 75/255, 73/255>;
#declare CN_Deep_into_the_Wood = rgb <48/255, 96/255, 48/255>;
#declare CN_Deep_Jungle = rgb <63/255, 86/255, 74/255>;
#declare CN_Deep_Koamaru = rgb <52/255, 52/255, 103/255>;
#declare CN_Deep_Lagoon = rgb <0/255, 82/255, 101/255>;
#declare CN_Deep_Lake = rgb <0/255, 101/255, 107/255>;
#declare CN_Deep_Lavender = rgb <86/255, 90/255, 125/255>;
#declare CN_Deep_Loch = rgb <46/255, 87/255, 103/255>;
#declare CN_Deep_Magenta = rgb <160/255, 2/255, 92/255>;
#declare CN_Deep_Marine = rgb <46/255, 100/255, 105/255>;
#declare CN_Deep_Maroon = rgb <98/255, 63/255, 69/255>;
#declare CN_Deep_Marsh = rgb <147/255, 133/255, 101/255>;
#declare CN_Deep_Merlot = rgb <87/255, 73/255, 88/255>;
#declare CN_Deep_Mint = rgb <85/255, 170/255, 102/255>;
#declare CN_Deep_Mulberry = rgb <84/255, 73/255, 84/255>;
#declare CN_Deep_Mystery = rgb <73/255, 76/255, 89/255>;
#declare CN_Deep_Night = rgb <73/255, 76/255, 85/255>;
#declare CN_Deep_Ocean = rgb <42/255, 75/255, 95/255>;
#declare CN_Deep_Orange = rgb <220/255, 77/255, 1/255>;
#declare CN_Deep_Orange_coloured_Brown = rgb <134/255, 71/255, 53/255>;
#declare CN_Deep_Orchid = rgb <82/255, 84/255, 118/255>;
#declare CN_Deep_Pacific = rgb <0/255, 110/255, 98/255>;
#declare CN_Deep_Peacock_Blue = rgb <0/255, 131/255, 129/255>;
#declare CN_Deep_Periwinkle = rgb <124/255, 131/255, 188/255>;
#declare CN_Deep_Pond = rgb <1/255, 68/255, 32/255>;
#declare CN_Deep_Purple = rgb <54/255, 1/255, 63/255>;
#declare CN_Deep_Red = rgb <154/255, 2/255, 0/255>;
#declare CN_Deep_Reddish_Orange = rgb <187/255, 96/255, 60/255>;
#declare CN_Deep_Reservoir = rgb <66/255, 79/255, 95/255>;
#declare CN_Deep_Rhubarb = rgb <127/255, 81/255, 83/255>;
#declare CN_Deep_Rift = rgb <76/255, 106/255, 104/255>;
#declare CN_Deep_River = rgb <0/255, 121/255, 179/255>;
#declare CN_Deep_Royal = rgb <54/255, 76/255, 104/255>;
#declare CN_Deep_Saffron = rgb <255/255, 153/255, 50/255>;
#declare CN_Deep_Sanction = rgb <25/255, 81/255, 85/255>;
#declare CN_Deep_Sea = rgb <22/255, 126/255, 101/255>;
#declare CN_Deep_Sea_Base = rgb <44/255, 44/255, 87/255>;
#declare CN_Deep_Sea_Blue = rgb <42/255, 75/255, 90/255>;
#declare CN_Deep_Sea_Coral = rgb <217/255, 97/255, 91/255>;
#declare CN_Deep_Sea_Dive = rgb <55/255, 97/255, 103/255>;
#declare CN_Deep_Sea_Diver = rgb <37/255, 92/255, 97/255>;
#declare CN_Deep_Sea_Dolphin = rgb <106/255, 104/255, 115/255>;
#declare CN_Deep_Sea_Dream = rgb <0/255, 45/255, 105/255>;
#declare CN_Deep_Sea_Exploration = rgb <32/255, 0/255, 177/255>;
#declare CN_Deep_Sea_Green = rgb <9/255, 88/255, 89/255>;
#declare CN_Deep_Sea_Grey = rgb <135/255, 146/255, 148/255>;
#declare CN_Deep_Sea_Nightmare = rgb <0/255, 35/255, 102/255>;
#declare CN_Deep_Sea_Shadow = rgb <79/255, 90/255, 76/255>;
#declare CN_Deep_Sea_Turtle = rgb <94/255, 87/255, 73/255>;
#declare CN_Deep_Seagrass = rgb <149/255, 152/255, 137/255>;
#declare CN_Deep_Seaweed = rgb <55/255, 65/255, 42/255>;
#declare CN_Deep_Serenity = rgb <127/255, 105/255, 104/255>;
#declare CN_Deep_Shadow = rgb <81/255, 74/255, 61/255>;
#declare CN_Deep_Shale = rgb <115/255, 124/255, 132/255>;
#declare CN_Deep_Sky_Blue = rgb <13/255, 117/255, 248/255>;
#declare CN_Deep_Smoke_Signal = rgb <125/255, 131/255, 146/255>;
#declare CN_Deep_South = rgb <180/255, 152/255, 159/255>;
#declare CN_Deep_Space = rgb <63/255, 65/255, 67/255>;
#declare CN_Deep_Space_Rodeo = rgb <51/255, 34/255, 119/255>;
#declare CN_Deep_Space_Sparkle = rgb <74/255, 100/255, 108/255>;
#declare CN_Deep_Tan = rgb <114/255, 103/255, 81/255>;
#declare CN_Deep_Taupe = rgb <123/255, 102/255, 96/255>;
#declare CN_Deep_Teal = rgb <0/255, 85/255, 90/255>;
#declare CN_Deep_Terra_Cotta = rgb <139/255, 72/255, 61/255>;
#declare CN_Deep_Velvet = rgb <49/255, 50/255, 72/255>;
#declare CN_Deep_Violet = rgb <51/255, 0/255, 102/255>;
#declare CN_Deep_Viridian = rgb <75/255, 100/255, 67/255>;
#declare CN_Deep_Walnut = rgb <97/255, 93/255, 88/255>;
#declare CN_Deep_Water = rgb <38/255, 102/255, 145/255>;
#declare CN_Deep_Well = rgb <44/255, 42/255, 51/255>;
#declare CN_Deep_Wisteria = rgb <68/255, 63/255, 111/255>;
#declare CN_Deepest_Mauve = rgb <109/255, 89/255, 90/255>;
#declare CN_Deepest_Sea = rgb <68/255, 77/255, 86/255>;
#declare CN_Deepest_Water = rgb <70/255, 97/255, 116/255>;
#declare CN_Deeply_Embarrassed = rgb <236/255, 178/255, 179/255>;
#declare CN_Deepsea_Kraken = rgb <8/255, 37/255, 153/255>;
#declare CN_Deer = rgb <186/255, 135/255, 89/255>;
#declare CN_Deer_God = rgb <150/255, 132/255, 122/255>;
#declare CN_Deer_Leather = rgb <172/255, 116/255, 52/255>;
#declare CN_Deer_Run = rgb <178/255, 166/255, 154/255>;
#declare CN_Deer_Tracks = rgb <161/255, 97/255, 76/255>;
#declare CN_Deer_Trail = rgb <106/255, 99/255, 76/255>;
#declare CN_Deer_Valley = rgb <199/255, 164/255, 133/255>;
#declare CN_Defenestration = rgb <198/255, 213/255, 228/255>;
#declare CN_Defense_Matrix = rgb <136/255, 255/255, 238/255>;
#declare CN_Degas_Pink = rgb <179/255, 126/255, 140/255>;
#declare CN_Deja_Vu = rgb <190/255, 209/255, 204/255>;
#declare CN_Del_Rio = rgb <181/255, 153/255, 142/255>;
#declare CN_Del_Sol_Maize = rgb <218/255, 191/255, 146/255>;
#declare CN_Delaunay_Green = rgb <170/255, 179/255, 80/255>;
#declare CN_Delaware_Blue_Hen = rgb <118/255, 160/255, 158/255>;
#declare CN_Delayed_Yellow = rgb <253/255, 249/255, 1/255>;
#declare CN_Delectable = rgb <154/255, 146/255, 167/255>;
#declare CN_Delft = rgb <61/255, 94/255, 140/255>;
#declare CN_Delft_Blue = rgb <51/255, 17/255, 238/255>;
#declare CN_Delhi_Dance_Pink = rgb <253/255, 193/255, 197/255>;
#declare CN_Delhi_Spice = rgb <163/255, 106/255, 109/255>;
#declare CN_Delicacy = rgb <245/255, 227/255, 226/255>;
#declare CN_Delicacy_White = rgb <235/255, 226/255, 229/255>;
#declare CN_Delicate_Ballet_Blue = rgb <194/255, 209/255, 226/255>;
#declare CN_Delicate_Bloom = rgb <219/255, 191/255, 206/255>;
#declare CN_Delicate_Blue = rgb <188/255, 223/255, 232/255>;
#declare CN_Delicate_Blue_Mist = rgb <190/255, 215/255, 240/255>;
#declare CN_Delicate_Blush = rgb <239/255, 215/255, 209/255>;
#declare CN_Delicate_Brown = rgb <167/255, 140/255, 139/255>;
#declare CN_Delicate_Cloud = rgb <221/255, 223/255, 232/255>;
#declare CN_Delicate_Daisy = rgb <233/255, 237/255, 192/255>;
#declare CN_Delicate_Dawn = rgb <254/255, 217/255, 188/255>;
#declare CN_Delicate_Girl_Blue = rgb <106/255, 178/255, 202/255>;
#declare CN_Delicate_Green = rgb <147/255, 176/255, 169/255>;
#declare CN_Delicate_Honeysweet = rgb <188/255, 171/255, 153/255>;
#declare CN_Delicate_Ice = rgb <183/255, 210/255, 227/255>;
#declare CN_Delicate_Lace = rgb <243/255, 230/255, 212/255>;
#declare CN_Delicate_Lemon = rgb <238/255, 221/255, 119/255>;
#declare CN_Delicate_Lilac_Crystal = rgb <215/255, 210/255, 226/255>;
#declare CN_Delicate_Mauve = rgb <197/255, 181/255, 202/255>;
#declare CN_Delicate_Mint = rgb <221/255, 243/255, 230/255>;
#declare CN_Delicate_Mist = rgb <225/255, 235/255, 229/255>;
#declare CN_Delicate_Pink = rgb <228/255, 207/255, 211/255>;
#declare CN_Delicate_Prunus = rgb <169/255, 92/255, 104/255>;
#declare CN_Delicate_Rose = rgb <247/255, 224/255, 214/255>;
#declare CN_Delicate_Sapling = rgb <215/255, 243/255, 221/255>;
#declare CN_Delicate_Seashell = rgb <255/255, 239/255, 221/255>;
#declare CN_Delicate_Snow_Goose = rgb <209/255, 226/255, 216/255>;
#declare CN_Delicate_Sweet_Apricot = rgb <253/255, 205/255, 189/255>;
#declare CN_Delicate_Truffle = rgb <170/255, 156/255, 139/255>;
#declare CN_Delicate_Turquoise = rgb <192/255, 223/255, 226/255>;
#declare CN_Delicate_Viola = rgb <215/255, 214/255, 220/255>;
#declare CN_Delicate_Violet = rgb <140/255, 141/255, 168/255>;
#declare CN_Delicate_White = rgb <241/255, 242/255, 238/255>;
#declare CN_Delicieux = rgb <65/255, 32/255, 16/255>;
#declare CN_Delicioso = rgb <63/255, 53/255, 47/255>;
#declare CN_Delicious = rgb <88/255, 94/255, 70/255>;
#declare CN_Delicious_Berry = rgb <101/255, 66/255, 84/255>;
#declare CN_Delicious_Dill = rgb <119/255, 204/255, 0/255>;
#declare CN_Delicious_Mandarin = rgb <255/255, 170/255, 17/255>;
#declare CN_Delicious_Melon = rgb <255/255, 215/255, 176/255>;
#declare CN_Delightful = rgb <210/255, 182/255, 190/255>;
#declare CN_Delightful_Camouflage = rgb <165/255, 169/255, 67/255>;
#declare CN_Delightful_Dandelion = rgb <238/255, 238/255, 51/255>;
#declare CN_Delightful_Green = rgb <0/255, 238/255, 0/255>;
#declare CN_Delightful_Pastry = rgb <249/255, 231/255, 200/255>;
#declare CN_Delightful_Peach = rgb <255/255, 235/255, 209/255>;
#declare CN_Delirious_Donkey = rgb <221/255, 204/255, 204/255>;
#declare CN_Dell = rgb <72/255, 101/255, 49/255>;
#declare CN_Della_Robbia_Blue = rgb <122/255, 157/255, 203/255>;
#declare CN_Delltone = rgb <142/255, 195/255, 158/255>;
#declare CN_Delos_Blue = rgb <22/255, 158/255, 192/255>;
#declare CN_Delphinium_Blue = rgb <97/255, 152/255, 174/255>;
#declare CN_Delta = rgb <153/255, 155/255, 149/255>;
#declare CN_Delta_Break = rgb <151/255, 145/255, 71/255>;
#declare CN_Delta_Green = rgb <45/255, 74/255, 76/255>;
#declare CN_Delta_Waters = rgb <196/255, 194/255, 171/255>;
#declare CN_Deluge = rgb <0/255, 119/255, 170/255>;
#declare CN_Delusional_Dragonfly = rgb <102/255, 187/255, 204/255>;
#declare CN_Deluxe_Days = rgb <139/255, 199/255, 230/255>;
#declare CN_Demerara_Sugar = rgb <225/255, 178/255, 112/255>;
#declare CN_Demeter = rgb <236/255, 218/255, 158/255>;
#declare CN_Demeter_Green = rgb <0/255, 204/255, 0/255>;
#declare CN_Demitasse = rgb <64/255, 52/255, 43/255>;
#declare CN_Democrat = rgb <0/255, 174/255, 243/255>;
#declare CN_Demon = rgb <34/255, 67/255, 118/255>;
#declare CN_Demonic = rgb <187/255, 34/255, 51/255>;
#declare CN_Demonic_Presence = rgb <124/255, 10/255, 2/255>;
#declare CN_Demonic_Purple = rgb <215/255, 37/255, 222/255>;
#declare CN_Demonic_Yellow = rgb <255/255, 231/255, 0/255>;
#declare CN_Demure = rgb <232/255, 212/255, 213/255>;
#declare CN_Demure_Pink = rgb <247/255, 210/255, 196/255>;
#declare CN_Denali_Green = rgb <125/255, 119/255, 93/255>;
#declare CN_Denim = rgb <34/255, 67/255, 182/255>;
#declare CN_Denim_Blue = rgb <47/255, 100/255, 121/255>;
#declare CN_Denim_Drift = rgb <124/255, 141/255, 150/255>;
#declare CN_Denim_Light = rgb <184/255, 202/255, 213/255>;
#declare CN_Denim_Tradition = rgb <127/255, 151/255, 181/255>;
#declare CN_Dense_Shrub = rgb <99/255, 109/255, 101/255>;
#declare CN_Dent_Corn = rgb <242/255, 183/255, 23/255>;
#declare CN_Dentist_Green = rgb <153/255, 213/255, 144/255>;
#declare CN_Denver_River = rgb <119/255, 149/255, 193/255>;
#declare CN_Depaysement = rgb <231/255, 216/255, 199/255>;
#declare CN_Depth_Charge = rgb <53/255, 88/255, 89/255>;
#declare CN_Derby = rgb <249/255, 228/255, 198/255>;
#declare CN_Derby_Brown = rgb <138/255, 114/255, 101/255>;
#declare CN_Derby_Green = rgb <89/255, 156/255, 137/255>;
#declare CN_Derbyshire = rgb <36/255, 94/255, 54/255>;
#declare CN_Derry_Coast_Sunrise = rgb <249/255, 225/255, 207/255>;
#declare CN_Desaturated_Cyan = rgb <102/255, 153/255, 153/255>;
#declare CN_Descent_to_the_Catacombs = rgb <68/255, 81/255, 85/255>;
#declare CN_Desert = rgb <204/255, 173/255, 96/255>;
#declare CN_Desert_Bud = rgb <194/255, 137/255, 150/255>;
#declare CN_Desert_Cactus = rgb <175/255, 202/255, 157/255>;
#declare CN_Desert_Camel = rgb <194/255, 174/255, 136/255>;
#declare CN_Desert_Caravan = rgb <211/255, 161/255, 105/255>;
#declare CN_Desert_Chaparral = rgb <114/255, 122/255, 96/255>;
#declare CN_Desert_Clay = rgb <158/255, 110/255, 67/255>;
#declare CN_Desert_Convoy = rgb <247/255, 212/255, 151/255>;
#declare CN_Desert_Coral = rgb <209/255, 100/255, 89/255>;
#declare CN_Desert_Cover = rgb <208/255, 200/255, 169/255>;
#declare CN_Desert_Dawn = rgb <237/255, 219/255, 232/255>;
#declare CN_Desert_Dune = rgb <181/255, 171/255, 156/255>;
#declare CN_Desert_Dusk = rgb <173/255, 154/255, 145/255>;
#declare CN_Desert_Dust = rgb <227/255, 188/255, 142/255>;
#declare CN_Desert_Echo = rgb <182/255, 162/255, 157/255>;
#declare CN_Desert_Field = rgb <239/255, 205/255, 184/255>;
#declare CN_Desert_Floor = rgb <198/255, 177/255, 131/255>;
#declare CN_Desert_Flower = rgb <255/255, 150/255, 135/255>;
#declare CN_Desert_Grey = rgb <184/255, 164/255, 135/255>;
#declare CN_Desert_Hot_Springs = rgb <196/255, 200/255, 170/255>;
#declare CN_Desert_Iguana = rgb <243/255, 242/255, 225/255>;
#declare CN_Desert_Khaki = rgb <214/255, 205/255, 183/255>;
#declare CN_Desert_Lights = rgb <189/255, 156/255, 157/255>;
#declare CN_Desert_Lily = rgb <254/255, 245/255, 219/255>;
#declare CN_Desert_Locust = rgb <169/255, 164/255, 80/255>;
#declare CN_Desert_Mauve = rgb <232/255, 210/255, 214/255>;
#declare CN_Desert_Mesa = rgb <239/255, 207/255, 188/255>;
#declare CN_Desert_Mirage = rgb <185/255, 224/255, 207/255>;
#declare CN_Desert_Mist = rgb <224/255, 181/255, 137/255>;
#declare CN_Desert_Morning = rgb <208/255, 187/255, 176/255>;
#declare CN_Desert_Moss = rgb <190/255, 161/255, 102/255>;
#declare CN_Desert_Night = rgb <95/255, 114/255, 122/255>;
#declare CN_Desert_Palm = rgb <90/255, 70/255, 50/255>;
#declare CN_Desert_Panzer = rgb <192/255, 202/255, 188/255>;
#declare CN_Desert_Pear = rgb <170/255, 174/255, 154/255>;
#declare CN_Desert_Pebble = rgb <202/255, 182/255, 152/255>;
#declare CN_Desert_Plain = rgb <229/255, 221/255, 201/255>;
#declare CN_Desert_Powder = rgb <251/255, 239/255, 218/255>;
#declare CN_Desert_Red = rgb <179/255, 131/255, 127/255>;
#declare CN_Desert_Riverbed = rgb <213/255, 168/255, 132/255>;
#declare CN_Desert_Rock = rgb <213/255, 198/255, 189/255>;
#declare CN_Desert_Rose = rgb <207/255, 105/255, 119/255>;
#declare CN_Desert_Sage = rgb <144/255, 146/255, 111/255>;
#declare CN_Desert_Sand = rgb <237/255, 201/255, 175/255>;
#declare CN_Desert_Sandstorm = rgb <185/255, 167/255, 149/255>;
#declare CN_Desert_Shadow = rgb <64/255, 60/255, 57/255>;
#declare CN_Desert_Shadows = rgb <159/255, 146/255, 122/255>;
#declare CN_Desert_Soil = rgb <161/255, 95/255, 59/255>;
#declare CN_Desert_Spice = rgb <198/255, 107/255, 48/255>;
#declare CN_Desert_Springs = rgb <220/255, 221/255, 203/255>;
#declare CN_Desert_Star = rgb <249/255, 240/255, 225/255>;
#declare CN_Desert_Storm = rgb <237/255, 231/255, 224/255>;
#declare CN_Desert_Suede = rgb <213/255, 199/255, 179/255>;
#declare CN_Desert_Sun = rgb <200/255, 118/255, 41/255>;
#declare CN_Desert_Sunrise = rgb <252/255, 181/255, 141/255>;
#declare CN_Desert_Tan = rgb <163/255, 140/255, 108/255>;
#declare CN_Desert_Taupe = rgb <141/255, 126/255, 113/255>;
#declare CN_Desert_Temple = rgb <221/255, 204/255, 153/255>;
#declare CN_Desert_Willow = rgb <137/255, 115/255, 75/255>;
#declare CN_Desert_Wind = rgb <229/255, 210/255, 149/255>;
#declare CN_Desert_Yellow = rgb <162/255, 146/255, 89/255>;
#declare CN_Deserted_Beach = rgb <231/255, 219/255, 191/255>;
#declare CN_Deserted_Island = rgb <133/255, 124/255, 100/255>;
#declare CN_Deserted_Path = rgb <231/255, 191/255, 123/255>;
#declare CN_Design_Delight = rgb <164/255, 123/255, 172/255>;
#declare CN_Designer_Cream_Yellow = rgb <239/255, 229/255, 187/255>;
#declare CN_Designer_Pink = rgb <225/255, 188/255, 216/255>;
#declare CN_Designer_White = rgb <231/255, 222/255, 209/255>;
#declare CN_Desire = rgb <234/255, 60/255, 83/255>;
#declare CN_Desire_Pink = rgb <238/255, 197/255, 210/255>;
#declare CN_Desired_Dawn = rgb <216/255, 215/255, 217/255>;
#declare CN_Desiree = rgb <196/255, 173/255, 184/255>;
#declare CN_Desolace_Dew = rgb <181/255, 193/255, 169/255>;
#declare CN_Desolate_Field = rgb <211/255, 203/255, 198/255>;
#declare CN_Dessert_Cream = rgb <246/255, 228/255, 208/255>;
#declare CN_Destiny = rgb <207/255, 201/255, 198/255>;
#declare CN_Destroyer_Grey = rgb <152/255, 150/255, 141/255>;
#declare CN_Destroying_Angels = rgb <233/255, 233/255, 225/255>;
#declare CN_Detailed_Devil = rgb <255/255, 51/255, 85/255>;
#declare CN_Detective_Coat = rgb <139/255, 134/255, 133/255>;
#declare CN_Determined_Orange = rgb <197/255, 102/255, 57/255>;
#declare CN_Detroit = rgb <189/255, 208/255, 209/255>;
#declare CN_Deutzia_White = rgb <247/255, 252/255, 254/255>;
#declare CN_Device_Green = rgb <0/255, 107/255, 77/255>;
#declare CN_Devil_Blue = rgb <39/255, 117/255, 148/255>;
#declare CN_Devils_Advocate = rgb <255/255, 51/255, 68/255>;
#declare CN_Devils_Flower_Mantis = rgb <143/255, 152/255, 5/255>;
#declare CN_Devils_Grass = rgb <68/255, 170/255, 85/255>;
#declare CN_Devils_Lip = rgb <102/255, 42/255, 44/255>;
#declare CN_Devils_Plum = rgb <66/255, 52/255, 80/255>;
#declare CN_Devil_s_Butterfly = rgb <187/255, 68/255, 34/255>;
#declare CN_Deviled_Egg = rgb <253/255, 215/255, 122/255>;
#declare CN_Devilish = rgb <221/255, 51/255, 34/255>;
#declare CN_Devilish_Diva = rgb <206/255, 119/255, 144/255>;
#declare CN_Devlan_Mud = rgb <90/255, 87/255, 63/255>;
#declare CN_Devlan_Mud_Wash = rgb <60/255, 53/255, 35/255>;
#declare CN_Devon_Rex = rgb <113/255, 126/255, 111/255>;
#declare CN_Devonshire = rgb <245/255, 239/255, 231/255>;
#declare CN_Dew = rgb <231/255, 242/255, 233/255>;
#declare CN_Dew_Drop = rgb <232/255, 238/255, 229/255>;
#declare CN_Dew_Green = rgb <151/255, 179/255, 145/255>;
#declare CN_Dew_Not_Disturb = rgb <206/255, 227/255, 220/255>;
#declare CN_Dew_Pointe = rgb <215/255, 237/255, 232/255>;
#declare CN_Dewberry = rgb <139/255, 89/255, 135/255>;
#declare CN_Dewdrop = rgb <221/255, 228/255, 227/255>;
#declare CN_Dewkist = rgb <196/255, 209/255, 194/255>;
#declare CN_Dewmist_Delight = rgb <220/255, 238/255, 219/255>;
#declare CN_Dewpoint = rgb <178/255, 206/255, 210/255>;
#declare CN_Dewy = rgb <214/255, 225/255, 216/255>;
#declare CN_Dexter = rgb <107/255, 177/255, 180/255>;
#declare CN_Dhalsims_Yoga_Flame = rgb <250/255, 228/255, 50/255>;
#declare CN_Dhurrie_Beige = rgb <202/255, 186/255, 168/255>;
#declare CN_Dhusar_Grey = rgb <170/255, 170/255, 170/255>;
#declare CN_Di_Sierra = rgb <219/255, 153/255, 94/255>;
#declare CN_Diablo_Red = rgb <205/255, 13/255, 1/255>;
#declare CN_Diamond = rgb <250/255, 247/255, 226/255>;
#declare CN_Diamond_Black = rgb <43/255, 48/255, 62/255>;
#declare CN_Diamond_Blue = rgb <207/255, 228/255, 238/255>;
#declare CN_Diamond_Dust = rgb <248/255, 245/255, 229/255>;
#declare CN_Diamond_Grey = rgb <62/255, 71/255, 75/255>;
#declare CN_Diamond_Light = rgb <223/255, 231/255, 236/255>;
#declare CN_Diamond_Soft_Blue = rgb <188/255, 218/255, 236/255>;
#declare CN_Diamond_Stud = rgb <220/255, 219/255, 220/255>;
#declare CN_Diamond_White = rgb <226/255, 239/255, 243/255>;
#declare CN_Diamonds_In_The_Sky = rgb <229/255, 226/255, 225/255>;
#declare CN_Diamonds_Therapy = rgb <233/255, 232/255, 224/255>;
#declare CN_Diantha = rgb <252/255, 246/255, 220/255>;
#declare CN_Dianthus_Mauve = rgb <141/255, 109/255, 137/255>;
#declare CN_Dickie_Bird = rgb <96/255, 184/255, 190/255>;
#declare CN_Diesel = rgb <50/255, 44/255, 43/255>;
#declare CN_Different_Gold = rgb <188/255, 147/255, 77/255>;
#declare CN_Diffused_Light = rgb <235/255, 229/255, 213/255>;
#declare CN_Diffused_Orchid = rgb <152/255, 121/255, 162/255>;
#declare CN_Diggers_Gold = rgb <163/255, 115/255, 54/255>;
#declare CN_Digital = rgb <99/255, 99/255, 101/255>;
#declare CN_Digital_Garage = rgb <183/255, 179/255, 164/255>;
#declare CN_Digital_Violets = rgb <170/255, 0/255, 255/255>;
#declare CN_Digital_Yellow = rgb <255/255, 235/255, 126/255>;
#declare CN_Dignified = rgb <59/255, 105/255, 95/255>;
#declare CN_Dignified_Purple = rgb <113/255, 98/255, 100/255>;
#declare CN_Dignity_Blue = rgb <9/255, 76/255, 115/255>;
#declare CN_Diisha_Green = rgb <0/255, 112/255, 68/255>;
#declare CN_Dijon = rgb <151/255, 117/255, 76/255>;
#declare CN_Dijon_Mustard = rgb <226/255, 202/255, 115/255>;
#declare CN_Dijonnaise = rgb <155/255, 143/255, 85/255>;
#declare CN_Dill = rgb <111/255, 119/255, 85/255>;
#declare CN_Dill_Grass = rgb <162/255, 165/255, 123/255>;
#declare CN_Dill_Green = rgb <182/255, 172/255, 75/255>;
#declare CN_Dill_Pickle = rgb <103/255, 116/255, 74/255>;
#declare CN_Dill_Powder = rgb <157/255, 160/255, 115/255>;
#declare CN_Dill_Seed = rgb <179/255, 178/255, 149/255>;
#declare CN_Dillards_Blue = rgb <214/255, 233/255, 228/255>;
#declare CN_Dilly_Blue = rgb <53/255, 73/255, 90/255>;
#declare CN_Dilly_Dally = rgb <246/255, 219/255, 93/255>;
#declare CN_Diluno_Red = rgb <244/255, 104/255, 96/255>;
#declare CN_Diluted_Blue = rgb <184/255, 222/255, 242/255>;
#declare CN_Diluted_Green = rgb <221/255, 234/255, 224/255>;
#declare CN_Diluted_Lilac = rgb <218/255, 223/255, 234/255>;
#declare CN_Diluted_Lime = rgb <232/255, 239/255, 219/255>;
#declare CN_Diluted_Mint = rgb <218/255, 244/255, 234/255>;
#declare CN_Diluted_Orange = rgb <251/255, 232/255, 226/255>;
#declare CN_Diluted_Pink = rgb <233/255, 223/255, 232/255>;
#declare CN_Diluted_Red = rgb <232/255, 221/255, 226/255>;
#declare CN_Dim = rgb <200/255, 194/255, 190/255>;
#declare CN_Dim_Grey = rgb <105/255, 105/255, 105/255>;
#declare CN_Diminished_Blue = rgb <188/255, 225/255, 235/255>;
#declare CN_Diminished_Brown = rgb <231/255, 222/255, 215/255>;
#declare CN_Diminished_Green = rgb <227/255, 230/255, 214/255>;
#declare CN_Diminished_Lime = rgb <237/255, 245/255, 221/255>;
#declare CN_Diminished_Mint = rgb <233/255, 243/255, 221/255>;
#declare CN_Diminished_Orange = rgb <250/255, 233/255, 225/255>;
#declare CN_Diminished_Pink = rgb <241/255, 229/255, 224/255>;
#declare CN_Diminished_Red = rgb <232/255, 216/255, 218/255>;
#declare CN_Diminished_Sky = rgb <211/255, 242/255, 237/255>;
#declare CN_Diminishing_Green = rgb <6/255, 46/255, 3/255>;
#declare CN_Diminutive_Pink = rgb <241/255, 222/255, 222/255>;
#declare CN_Dimple = rgb <233/255, 128/255, 139/255>;
#declare CN_Dingley = rgb <96/255, 124/255, 71/255>;
#declare CN_Dingy_Dungeon = rgb <197/255, 49/255, 81/255>;
#declare CN_Dingy_Sticky_Note = rgb <230/255, 242/255, 162/255>;
#declare CN_Dinner_Mint = rgb <232/255, 243/255, 228/255>;
#declare CN_Dinosaur = rgb <127/255, 153/255, 125/255>;
#declare CN_Dinosaur_Bone = rgb <130/255, 117/255, 99/255>;
#declare CN_Dinosaur_Egg = rgb <202/255, 186/255, 169/255>;
#declare CN_Diopside_Blue = rgb <131/255, 145/255, 160/255>;
#declare CN_Dioptase_Green = rgb <67/255, 158/255, 141/255>;
#declare CN_Diorite = rgb <157/255, 191/255, 177/255>;
#declare CN_Diplomatic = rgb <58/255, 68/255, 93/255>;
#declare CN_Dire_Wolf = rgb <40/255, 40/255, 40/255>;
#declare CN_Direct_Green = rgb <63/255, 138/255, 36/255>;
#declare CN_Directoire_Blue = rgb <0/255, 97/255, 163/255>;
#declare CN_Diroset = rgb <90/255, 202/255, 164/255>;
#declare CN_Dirt = rgb <155/255, 118/255, 83/255>;
#declare CN_Dirt_Brown = rgb <131/255, 101/255, 57/255>;
#declare CN_Dirt_Track = rgb <187/255, 102/255, 68/255>;
#declare CN_Dirt_Yellow = rgb <146/255, 110/255, 46/255>;
#declare CN_Dirty_Blonde = rgb <223/255, 195/255, 147/255>;
#declare CN_Dirty_Blue = rgb <63/255, 130/255, 157/255>;
#declare CN_Dirty_Brown = rgb <181/255, 101/255, 30/255>;
#declare CN_Dirty_Green = rgb <102/255, 126/255, 44/255>;
#declare CN_Dirty_Leather = rgb <67/255, 0/255, 5/255>;
#declare CN_Dirty_Martini = rgb <221/255, 208/255, 182/255>;
#declare CN_Dirty_Orange = rgb <200/255, 118/255, 6/255>;
#declare CN_Dirty_Pink = rgb <202/255, 123/255, 128/255>;
#declare CN_Dirty_Purple = rgb <115/255, 74/255, 101/255>;
#declare CN_Dirty_Snow = rgb <205/255, 206/255, 213/255>;
#declare CN_Dirty_White = rgb <232/255, 228/255, 201/255>;
#declare CN_Dirty_Yellow = rgb <205/255, 197/255, 10/255>;
#declare CN_Disappearing_Island = rgb <187/255, 222/255, 229/255>;
#declare CN_Disappearing_Memories = rgb <234/255, 227/255, 224/255>;
#declare CN_Disappearing_Purple = rgb <63/255, 49/255, 58/255>;
#declare CN_Disarm = rgb <0/255, 110/255, 157/255>;
#declare CN_Disc_Jockey = rgb <71/255, 198/255, 172/255>;
#declare CN_Disco = rgb <137/255, 45/255, 79/255>;
#declare CN_Discover = rgb <189/255, 176/255, 160/255>;
#declare CN_Discover_Deco = rgb <74/255, 147/255, 78/255>;
#declare CN_Discovery_Bay = rgb <39/255, 104/255, 120/255>;
#declare CN_Discreet_Orange = rgb <255/255, 173/255, 152/255>;
#declare CN_Discreet_Romance = rgb <245/255, 229/255, 225/255>;
#declare CN_Discreet_White = rgb <223/255, 220/255, 219/255>;
#declare CN_Discrete_Pink = rgb <235/255, 219/255, 221/255>;
#declare CN_Discretion = rgb <159/255, 111/255, 98/255>;
#declare CN_Disembark = rgb <91/255, 180/255, 215/255>;
#declare CN_Disguise = rgb <183/255, 182/255, 152/255>;
#declare CN_Dishy_Coral = rgb <237/255, 145/255, 144/255>;
#declare CN_Dissolved_Denim = rgb <226/255, 236/255, 242/255>;
#declare CN_Distance = rgb <86/255, 106/255, 115/255>;
#declare CN_Distant_Blue = rgb <44/255, 102/255, 160/255>;
#declare CN_Distant_Cloud = rgb <229/255, 234/255, 230/255>;
#declare CN_Distant_Flare = rgb <234/255, 209/255, 218/255>;
#declare CN_Distant_Haze = rgb <223/255, 228/255, 218/255>;
#declare CN_Distant_Homeworld = rgb <172/255, 220/255, 238/255>;
#declare CN_Distant_Horizon = rgb <241/255, 248/255, 250/255>;
#declare CN_Distant_Land = rgb <166/255, 138/255, 113/255>;
#declare CN_Distant_Landscape = rgb <225/255, 239/255, 221/255>;
#declare CN_Distant_Searchlight = rgb <242/255, 243/255, 206/255>;
#declare CN_Distant_Shore = rgb <194/255, 216/255, 227/255>;
#declare CN_Distant_Sky = rgb <111/255, 141/255, 175/255>;
#declare CN_Distant_Star = rgb <186/255, 193/255, 195/255>;
#declare CN_Distant_Tan = rgb <207/255, 189/255, 165/255>;
#declare CN_Distant_Thunder = rgb <127/255, 134/255, 136/255>;
#declare CN_Distant_Valley = rgb <194/255, 183/255, 154/255>;
#declare CN_Distant_Wind_Chime = rgb <234/255, 239/255, 242/255>;
#declare CN_Distilled_Moss = rgb <204/255, 255/255, 204/255>;
#declare CN_Distilled_Rose = rgb <255/255, 187/255, 255/255>;
#declare CN_Distilled_Venom = rgb <199/255, 253/255, 181/255>;
#declare CN_Distilled_Watermelon = rgb <237/255, 227/255, 224/255>;
#declare CN_Distinct_Purple = rgb <162/255, 148/255, 201/255>;
#declare CN_Dithered_Amber = rgb <254/255, 179/255, 8/255>;
#declare CN_Dithered_Sky = rgb <188/255, 223/255, 255/255>;
#declare CN_Diva = rgb <201/255, 160/255, 255/255>;
#declare CN_Diva_Blue = rgb <0/255, 123/255, 178/255>;
#declare CN_Diva_Girl = rgb <225/255, 203/255, 218/255>;
#declare CN_Diva_Glam = rgb <178/255, 78/255, 118/255>;
#declare CN_Diva_Mecha = rgb <238/255, 153/255, 238/255>;
#declare CN_Diva_Rouge = rgb <232/255, 185/255, 165/255>;
#declare CN_Diva_Violet = rgb <80/255, 119/255, 186/255>;
#declare CN_Dive_In = rgb <60/255, 77/255, 133/255>;
#declare CN_Diver_Lady = rgb <39/255, 84/255, 110/255>;
#declare CN_Divers_Eden = rgb <58/255, 121/255, 126/255>;
#declare CN_Diverse_Beige = rgb <194/255, 180/255, 167/255>;
#declare CN_Diversion = rgb <169/255, 154/255, 137/255>;
#declare CN_Divine = rgb <154/255, 122/255, 160/255>;
#declare CN_Divine_Dove = rgb <238/255, 221/255, 238/255>;
#declare CN_Divine_Inspiration = rgb <216/255, 226/255, 225/255>;
#declare CN_Divine_Pleasure = rgb <244/255, 239/255, 225/255>;
#declare CN_Divine_Purple = rgb <105/255, 0/255, 95/255>;
#declare CN_Divine_White = rgb <230/255, 220/255, 205/255>;
#declare CN_Divine_Wine = rgb <88/255, 62/255, 62/255>;
#declare CN_Dixie = rgb <205/255, 132/255, 49/255>;
#declare CN_Dizzy_Days = rgb <209/255, 78/255, 47/255>;
#declare CN_Do_Not_Disturb = rgb <153/255, 164/255, 86/255>;
#declare CN_Dobunezumi_Brown = rgb <75/255, 60/255, 57/255>;
#declare CN_Dockside = rgb <149/255, 174/255, 208/255>;
#declare CN_Dockside_Blue = rgb <160/255, 179/255, 188/255>;
#declare CN_Doctor = rgb <249/255, 249/255, 249/255>;
#declare CN_Dodge_Pole = rgb <163/255, 115/255, 85/255>;
#declare CN_Dodger_Blue = rgb <62/255, 130/255, 252/255>;
#declare CN_DodgeRoll_Gold = rgb <247/255, 154/255, 18/255>;
#declare CN_Dodie_Yellow = rgb <254/255, 246/255, 91/255>;
#declare CN_Doe = rgb <185/255, 142/255, 104/255>;
#declare CN_Doeskin = rgb <255/255, 242/255, 228/255>;
#declare CN_Doeskin_Grey = rgb <204/255, 195/255, 186/255>;
#declare CN_Dogwood = rgb <250/255, 234/255, 226/255>;
#declare CN_Dogwood_Bloom = rgb <197/255, 143/255, 148/255>;
#declare CN_Dogwood_Rose = rgb <215/255, 24/255, 104/255>;
#declare CN_Doll_House = rgb <250/255, 207/255, 193/255>;
#declare CN_Dollar = rgb <125/255, 135/255, 116/255>;
#declare CN_Dollar_Bill = rgb <133/255, 187/255, 101/255>;
#declare CN_Dollie = rgb <245/255, 144/255, 160/255>;
#declare CN_Dollop_of_Cream = rgb <248/255, 235/255, 212/255>;
#declare CN_Dolly = rgb <245/255, 241/255, 113/255>;
#declare CN_Dolomite_Crystal = rgb <254/255, 232/255, 245/255>;
#declare CN_Dolomite_Red = rgb <197/255, 118/255, 155/255>;
#declare CN_Dolphin = rgb <134/255, 196/255, 218/255>;
#declare CN_Dolphin_Blue = rgb <125/255, 157/255, 169/255>;
#declare CN_Dolphin_Daze = rgb <101/255, 159/255, 181/255>;
#declare CN_Dolphin_Dream = rgb <107/255, 111/255, 120/255>;
#declare CN_Dolphin_Fin = rgb <204/255, 202/255, 193/255>;
#declare CN_Dolphin_Grey = rgb <154/255, 153/255, 151/255>;
#declare CN_Dolphin_Tales = rgb <199/255, 199/255, 194/255>;
#declare CN_Domain = rgb <156/255, 156/255, 110/255>;
#declare CN_Dominant_Grey = rgb <90/255, 86/255, 81/255>;
#declare CN_Domino = rgb <108/255, 91/255, 76/255>;
#declare CN_Don_Juan = rgb <90/255, 79/255, 81/255>;
#declare CN_Donegal_Green = rgb <17/255, 85/255, 0/255>;
#declare CN_Donegal_Tweed = rgb <193/255, 153/255, 100/255>;
#declare CN_Doener_Kebab = rgb <187/255, 119/255, 102/255>;
#declare CN_Donkey_Brown = rgb <129/255, 110/255, 92/255>;
#declare CN_Donkey_Kong = rgb <171/255, 66/255, 16/255>;
#declare CN_Donnegal = rgb <140/255, 174/255, 163/255>;
#declare CN_Doodle = rgb <251/255, 220/255, 168/255>;
#declare CN_Doombull_Brown = rgb <124/255, 30/255, 8/255>;
#declare CN_Dorado = rgb <110/255, 95/255, 86/255>;
#declare CN_Dorian_Gray = rgb <172/255, 167/255, 158/255>;
#declare CN_Doric_White = rgb <213/255, 207/255, 189/255>;
#declare CN_Dormer_Brown = rgb <173/255, 148/255, 124/255>;
#declare CN_Dormitory = rgb <93/255, 113/255, 169/255>;
#declare CN_Dorn_Yellow = rgb <255/255, 242/255, 0/255>;
#declare CN_Dorset_Naga = rgb <157/255, 44/255, 49/255>;
#declare CN_Dotted_Dove = rgb <108/255, 104/255, 104/255>;
#declare CN_Dou_Lu_Green = rgb <0/255, 146/255, 118/255>;
#declare CN_Dou_Sha_Se_Red = rgb <165/255, 41/255, 57/255>;
#declare CN_Double_Chocolate = rgb <111/255, 82/255, 69/255>;
#declare CN_Double_Click = rgb <208/255, 210/255, 209/255>;
#declare CN_Double_Colonial_White = rgb <228/255, 207/255, 153/255>;
#declare CN_Double_Cream = rgb <243/255, 224/255, 172/255>;
#declare CN_Double_Dragon_Skin = rgb <252/255, 160/255, 68/255>;
#declare CN_Double_Duty = rgb <104/255, 104/255, 88/255>;
#declare CN_Double_Espresso = rgb <84/255, 66/255, 62/255>;
#declare CN_Double_Fudge = rgb <109/255, 84/255, 75/255>;
#declare CN_Double_Jeopardy = rgb <77/255, 120/255, 108/255>;
#declare CN_Double_Latte = rgb <167/255, 140/255, 113/255>;
#declare CN_Double_Pearl_Lusta = rgb <233/255, 220/255, 190/255>;
#declare CN_Double_Spanish_White = rgb <210/255, 195/255, 163/255>;
#declare CN_Dough_Yellow = rgb <246/255, 208/255, 182/255>;
#declare CN_Douglas_Fir_Green = rgb <111/255, 152/255, 129/255>;
#declare CN_Douro = rgb <85/255, 85/255, 0/255>;
#declare CN_Dove = rgb <179/255, 173/255, 167/255>;
#declare CN_Dove_Feather = rgb <117/255, 93/255, 91/255>;
#declare CN_Dove_Grey = rgb <109/255, 108/255, 108/255>;
#declare CN_Dove_Tail = rgb <145/255, 176/255, 197/255>;
#declare CN_Dove_White = rgb <230/255, 226/255, 216/255>;
#declare CN_Doves_Wing = rgb <244/255, 242/255, 234/255>;
#declare CN_Dover_Cliffs = rgb <240/255, 233/255, 216/255>;
#declare CN_Dover_Grey = rgb <132/255, 133/255, 133/255>;
#declare CN_Dover_Plains = rgb <204/255, 175/255, 146/255>;
#declare CN_Dover_Straits = rgb <50/255, 106/255, 177/255>;
#declare CN_Dover_White = rgb <241/255, 235/255, 221/255>;
#declare CN_Dovetail = rgb <144/255, 138/255, 131/255>;
#declare CN_Dowager = rgb <131/255, 140/255, 130/255>;
#declare CN_Down_Dog = rgb <186/255, 175/255, 185/255>;
#declare CN_Down_Feathers = rgb <255/255, 249/255, 231/255>;
#declare CN_Down_Home = rgb <203/255, 192/255, 186/255>;
#declare CN_Down_Pour = rgb <67/255, 113/255, 139/255>;
#declare CN_Down_to_Earth = rgb <92/255, 98/255, 66/255>;
#declare CN_Downing_Earth = rgb <136/255, 123/255, 103/255>;
#declare CN_Downing_Sand = rgb <203/255, 188/255, 165/255>;
#declare CN_Downing_Slate = rgb <119/255, 127/255, 134/255>;
#declare CN_Downing_Stone = rgb <166/255, 163/255, 151/255>;
#declare CN_Downing_Straw = rgb <202/255, 171/255, 125/255>;
#declare CN_Downing_to_Earth = rgb <99/255, 90/255, 79/255>;
#declare CN_Download_Progress = rgb <88/255, 211/255, 50/255>;
#declare CN_Downpour = rgb <155/255, 158/255, 162/255>;
#declare CN_Downriver = rgb <9/255, 34/255, 86/255>;
#declare CN_Downtown_Benny_Brown = rgb <125/255, 106/255, 88/255>;
#declare CN_Downtown_Grey = rgb <173/255, 170/255, 162/255>;
#declare CN_Downwell = rgb <0/255, 17/255, 0/255>;
#declare CN_Downy = rgb <111/255, 210/255, 190/255>;
#declare CN_Downy_Feather = rgb <254/255, 170/255, 102/255>;
#declare CN_Downy_Fluff = rgb <237/255, 233/255, 228/255>;
#declare CN_Dozen_Roses = rgb <128/255, 63/255, 63/255>;
#declare CN_Dr_Who = rgb <120/255, 88/255, 125/255>;
#declare CN_Dr_White = rgb <250/255, 250/255, 250/255>;
#declare CN_Drab = rgb <130/255, 131/255, 68/255>;
#declare CN_Drab_Green = rgb <116/255, 149/255, 81/255>;
#declare CN_Dracula_Orchid = rgb <44/255, 53/255, 57/255>;
#declare CN_Dragon_Ball = rgb <255/255, 153/255, 34/255>;
#declare CN_Dragon_Bay = rgb <93/255, 169/255, 159/255>;
#declare CN_Dragon_Fire = rgb <252/255, 100/255, 45/255>;
#declare CN_Dragon_Fruit = rgb <215/255, 89/255, 105/255>;
#declare CN_Dragon_Red = rgb <158/255, 2/255, 0/255>;
#declare CN_Dragon_Scale = rgb <0/255, 168/255, 119/255>;
#declare CN_Dragons_Blood = rgb <184/255, 64/255, 72/255>;
#declare CN_Dragons_Breath = rgb <212/255, 16/255, 3/255>;
#declare CN_Dragons_Fire = rgb <156/255, 45/255, 93/255>;
#declare CN_Dragonfly = rgb <49/255, 74/255, 118/255>;
#declare CN_Dragonfly_Blue = rgb <69/255, 171/255, 202/255>;
#declare CN_Dragonlord_Purple = rgb <98/255, 65/255, 199/255>;
#declare CN_Dragons_Lair = rgb <213/255, 12/255, 21/255>;
#declare CN_Drake_Tooth = rgb <187/255, 176/255, 164/255>;
#declare CN_Drake_s_Neck = rgb <49/255, 102/255, 138/255>;
#declare CN_Drakenhof_Nightshade = rgb <31/255, 93/255, 160/255>;
#declare CN_Drama_Queen = rgb <163/255, 114/255, 152/255>;
#declare CN_Drama_Violet = rgb <184/255, 131/255, 176/255>;
#declare CN_Dramatical_Red = rgb <153/255, 17/255, 0/255>;
#declare CN_Dramatist = rgb <75/255, 71/255, 117/255>;
#declare CN_Draw_Your_Sword = rgb <108/255, 113/255, 121/255>;
#declare CN_Dream_Blue = rgb <215/255, 230/255, 238/255>;
#declare CN_Dream_Catcher = rgb <229/255, 235/255, 234/255>;
#declare CN_Dream_Dust = rgb <235/255, 226/255, 232/255>;
#declare CN_Dream_Green = rgb <53/255, 131/255, 106/255>;
#declare CN_Dream_Seascape = rgb <213/255, 222/255, 195/255>;
#declare CN_Dream_Setting = rgb <255/255, 119/255, 187/255>;
#declare CN_Dream_State = rgb <239/255, 221/255, 225/255>;
#declare CN_Dream_Sunset = rgb <155/255, 134/255, 141/255>;
#declare CN_Dream_Vapor = rgb <204/255, 153/255, 238/255>;
#declare CN_Dreamcatcher = rgb <165/255, 178/255, 169/255>;
#declare CN_Dreaming_Blue = rgb <138/255, 194/255, 214/255>;
#declare CN_Dreaming_of_the_Day = rgb <171/255, 193/255, 189/255>;
#declare CN_Dreamland = rgb <181/255, 177/255, 191/255>;
#declare CN_Dreamless_Sleep = rgb <17/255, 17/255, 17/255>;
#declare CN_Dreams_of_Peach = rgb <255/255, 210/255, 157/255>;
#declare CN_Dreamscape_Grey = rgb <198/255, 197/255, 197/255>;
#declare CN_Dreamsicle = rgb <245/255, 213/255, 194/255>;
#declare CN_Dreamweaver = rgb <204/255, 198/255, 215/255>;
#declare CN_Dreamy_Cloud = rgb <229/255, 230/255, 235/255>;
#declare CN_Dreamy_Heaven = rgb <89/255, 65/255, 88/255>;
#declare CN_Dreamy_White = rgb <227/255, 216/255, 213/255>;
#declare CN_Drenched_Rain = rgb <193/255, 209/255, 226/255>;
#declare CN_Dresden_Blue = rgb <0/255, 134/255, 187/255>;
#declare CN_Dresden_Doll = rgb <140/255, 168/255, 198/255>;
#declare CN_Dresden_Dream = rgb <142/255, 167/255, 185/255>;
#declare CN_Dress_Blues = rgb <42/255, 50/255, 68/255>;
#declare CN_Dress_Pink = rgb <244/255, 235/255, 239/255>;
#declare CN_Dress_Up = rgb <250/255, 199/255, 191/255>;
#declare CN_Dressed_to_Impress = rgb <113/255, 70/255, 64/255>;
#declare CN_Dressy_Rose = rgb <184/255, 157/255, 154/255>;
#declare CN_Dreyfus = rgb <178/255, 171/255, 161/255>;
#declare CN_Dried_Basil = rgb <137/255, 137/255, 115/255>;
#declare CN_Dried_Blood = rgb <75/255, 1/255, 1/255>;
#declare CN_Dried_Chamomile = rgb <209/255, 179/255, 117/255>;
#declare CN_Dried_Chervil = rgb <181/255, 189/255, 163/255>;
#declare CN_Dried_Chive = rgb <123/255, 125/255, 105/255>;
#declare CN_Dried_Coconut = rgb <235/255, 231/255, 217/255>;
#declare CN_Dried_Dates = rgb <74/255, 66/255, 58/255>;
#declare CN_Dried_Edamame = rgb <177/255, 159/255, 128/255>;
#declare CN_Dried_Flower_Purple = rgb <117/255, 38/255, 83/255>;
#declare CN_Dried_Goldenrod = rgb <226/255, 168/255, 41/255>;
#declare CN_Dried_Grass = rgb <172/255, 160/255, 141/255>;
#declare CN_Dried_Herb = rgb <132/255, 122/255, 89/255>;
#declare CN_Dried_Lavender = rgb <235/255, 233/255, 236/255>;
#declare CN_Dried_Lavender_Flowers = rgb <119/255, 116/255, 127/255>;
#declare CN_Dried_Leaf = rgb <92/255, 80/255, 67/255>;
#declare CN_Dried_Lilac = rgb <187/255, 187/255, 255/255>;
#declare CN_Dried_Magenta = rgb <255/255, 64/255, 255/255>;
#declare CN_Dried_Moss = rgb <204/255, 185/255, 126/255>;
#declare CN_Dried_Mustard = rgb <128/255, 74/255, 0/255>;
#declare CN_Dried_Palm = rgb <225/255, 219/255, 172/255>;
#declare CN_Dried_Pipe_Clay = rgb <216/255, 214/255, 204/255>;
#declare CN_Dried_Plantain = rgb <229/255, 206/255, 169/255>;
#declare CN_Dried_Plum = rgb <104/255, 51/255, 50/255>;
#declare CN_Dried_Thyme = rgb <187/255, 188/255, 161/255>;
#declare CN_Dried_Tobacco = rgb <153/255, 123/255, 56/255>;
#declare CN_Dried_Tomatoes = rgb <171/255, 96/255, 87/255>;
#declare CN_Drift_of_Mist = rgb <220/255, 216/255, 208/255>;
#declare CN_Drift_on_the_Sea = rgb <135/255, 206/255, 250/255>;
#declare CN_Drifting = rgb <190/255, 180/255, 168/255>;
#declare CN_Drifting_Cloud = rgb <219/255, 224/255, 225/255>;
#declare CN_Drifting_Downstream = rgb <97/255, 115/255, 111/255>;
#declare CN_Drifting_Dream = rgb <204/255, 187/255, 227/255>;
#declare CN_Drifting_Sand = rgb <168/255, 159/255, 147/255>;
#declare CN_Drifting_Tide = rgb <223/255, 239/255, 235/255>;
#declare CN_Driftwood = rgb <166/255, 122/255, 69/255>;
#declare CN_Drip = rgb <166/255, 204/255, 214/255>;
#declare CN_Dripping_Ice = rgb <210/255, 223/255, 237/255>;
#declare CN_Drippy_Honey = rgb <238/255, 187/255, 34/255>;
#declare CN_Drisheen = rgb <162/255, 72/255, 87/255>;
#declare CN_Drive_In_Cherry = rgb <166/255, 46/255, 48/255>;
#declare CN_Drizzle = rgb <160/255, 175/255, 157/255>;
#declare CN_Droewors = rgb <82/255, 56/255, 57/255>;
#declare CN_Dromedary = rgb <227/255, 194/255, 149/255>;
#declare CN_Dromedary_Camel = rgb <202/255, 173/255, 135/255>;
#declare CN_Drop_Green = rgb <105/255, 189/255, 90/255>;
#declare CN_Drop_of_Lemon = rgb <252/255, 241/255, 189/255>;
#declare CN_Droplet = rgb <170/255, 221/255, 255/255>;
#declare CN_Dropped_Brick = rgb <187/255, 51/255, 0/255>;
#declare CN_Drops_of_Honey = rgb <212/255, 174/255, 118/255>;
#declare CN_Drought = rgb <213/255, 209/255, 204/255>;
#declare CN_Drover = rgb <251/255, 235/255, 155/255>;
#declare CN_Drowsy_Lavender = rgb <212/255, 219/255, 225/255>;
#declare CN_Druchii_Violet = rgb <132/255, 41/255, 148/255>;
#declare CN_Druid_Green = rgb <66/255, 113/255, 49/255>;
#declare CN_Drum_Solo = rgb <166/255, 110/255, 75/255>;
#declare CN_Drunk_Tank_Pink = rgb <221/255, 17/255, 221/255>;
#declare CN_Drunken_Dragonfly = rgb <51/255, 221/255, 136/255>;
#declare CN_Drunken_Flamingo = rgb <255/255, 85/255, 204/255>;
#declare CN_Dry_Bone = rgb <234/255, 223/255, 206/255>;
#declare CN_Dry_Brown = rgb <150/255, 131/255, 116/255>;
#declare CN_Dry_Catmint = rgb <185/255, 189/255, 174/255>;
#declare CN_Dry_Clay = rgb <189/255, 92/255, 0/255>;
#declare CN_Dry_Creek = rgb <216/255, 199/255, 182/255>;
#declare CN_Dry_Dock = rgb <129/255, 118/255, 101/255>;
#declare CN_Dry_Dune = rgb <239/255, 223/255, 207/255>;
#declare CN_Dry_Grass = rgb <158/255, 162/255, 107/255>;
#declare CN_Dry_Hemlock = rgb <144/255, 147/255, 115/255>;
#declare CN_Dry_Highlighter_Green = rgb <43/255, 167/255, 39/255>;
#declare CN_Dry_Lichen = rgb <199/255, 217/255, 204/255>;
#declare CN_Dry_Moss = rgb <118/255, 153/255, 88/255>;
#declare CN_Dry_Mud = rgb <119/255, 118/255, 114/255>;
#declare CN_Dry_Pasture = rgb <148/255, 137/255, 113/255>;
#declare CN_Dry_Peach = rgb <222/255, 126/255, 93/255>;
#declare CN_Dry_Riverbed = rgb <210/255, 197/255, 174/255>;
#declare CN_Dry_Rose = rgb <194/255, 47/255, 77/255>;
#declare CN_Dry_Sand = rgb <234/255, 228/255, 214/255>;
#declare CN_Dry_Sea_Grass = rgb <204/255, 178/255, 122/255>;
#declare CN_Dry_Season = rgb <212/255, 206/255, 205/255>;
#declare CN_Dry_Seedlings = rgb <199/255, 220/255, 104/255>;
#declare CN_Dry_Starfish = rgb <176/255, 154/255, 119/255>;
#declare CN_Dryad_Bark = rgb <51/255, 49/255, 45/255>;
#declare CN_Drying_Grass_Green = rgb <123/255, 179/255, 105/255>;
#declare CN_Dubarry = rgb <242/255, 95/255, 102/255>;
#declare CN_Dubbin = rgb <174/255, 139/255, 100/255>;
#declare CN_Dublin = rgb <115/255, 190/255, 110/255>;
#declare CN_Dublin_Jack = rgb <111/255, 171/255, 146/255>;
#declare CN_Dubloon = rgb <213/255, 182/255, 136/255>;
#declare CN_Dubuffet_Green = rgb <111/255, 119/255, 102/255>;
#declare CN_Ducal = rgb <118/255, 61/255, 53/255>;
#declare CN_Ducal_Pink = rgb <206/255, 144/255, 150/255>;
#declare CN_Ducati = rgb <22/255, 160/255, 166/255>;
#declare CN_Duchamp_Light_Green = rgb <209/255, 219/255, 199/255>;
#declare CN_Duchess_Lilac = rgb <155/255, 144/255, 157/255>;
#declare CN_Duchess_Rose = rgb <247/255, 170/255, 151/255>;
#declare CN_Duck_Butter = rgb <221/255, 199/255, 91/255>;
#declare CN_Duck_Egg_Blue = rgb <195/255, 251/255, 244/255>;
#declare CN_Duck_Egg_Cream = rgb <200/255, 227/255, 210/255>;
#declare CN_Duck_Green = rgb <83/255, 102/255, 92/255>;
#declare CN_Duck_Hunt = rgb <0/255, 88/255, 0/255>;
#declare CN_Duck_Sauce = rgb <204/255, 153/255, 34/255>;
#declare CN_Duck_Tail = rgb <233/255, 214/255, 177/255>;
#declare CN_Duck_Willow = rgb <106/255, 105/255, 90/255>;
#declare CN_Ducks_Egg_Blue = rgb <204/255, 223/255, 232/255>;
#declare CN_Duckie_Yellow = rgb <255/255, 255/255, 17/255>;
#declare CN_Duckling = rgb <252/255, 176/255, 87/255>;
#declare CN_Duckling_Fluff = rgb <250/255, 252/255, 93/255>;
#declare CN_Duct_Tape_Grey = rgb <174/255, 172/255, 172/255>;
#declare CN_Duffel_Bag = rgb <57/255, 64/255, 52/255>;
#declare CN_Dugong = rgb <113/255, 112/255, 110/255>;
#declare CN_Duke_Blue = rgb <0/255, 0/255, 156/255>;
#declare CN_Dulcet = rgb <154/255, 212/255, 216/255>;
#declare CN_Dulcet_Violet = rgb <89/255, 57/255, 76/255>;
#declare CN_Dull = rgb <114/255, 113/255, 113/255>;
#declare CN_Dull_Apricot = rgb <208/255, 156/255, 151/255>;
#declare CN_Dull_Blue = rgb <73/255, 117/255, 156/255>;
#declare CN_Dull_Brown = rgb <135/255, 110/255, 75/255>;
#declare CN_Dull_Desert = rgb <220/255, 214/255, 211/255>;
#declare CN_Dull_Dusky_Pink = rgb <143/255, 109/255, 115/255>;
#declare CN_Dull_Gold = rgb <138/255, 111/255, 72/255>;
#declare CN_Dull_Green = rgb <116/255, 166/255, 98/255>;
#declare CN_Dull_Lavender = rgb <168/255, 153/255, 230/255>;
#declare CN_Dull_Light_Yellow = rgb <229/255, 217/255, 180/255>;
#declare CN_Dull_Magenta = rgb <141/255, 72/255, 86/255>;
#declare CN_Dull_Mauve = rgb <125/255, 116/255, 133/255>;
#declare CN_Dull_Olive = rgb <122/255, 117/255, 100/255>;
#declare CN_Dull_Orange = rgb <216/255, 134/255, 59/255>;
#declare CN_Dull_Pink = rgb <213/255, 134/255, 157/255>;
#declare CN_Dull_Purple = rgb <132/255, 89/255, 126/255>;
#declare CN_Dull_Red = rgb <187/255, 63/255, 63/255>;
#declare CN_Dull_Sage = rgb <219/255, 212/255, 171/255>;
#declare CN_Dull_Teal = rgb <95/255, 158/255, 143/255>;
#declare CN_Dull_Turquoise = rgb <85/255, 125/255, 115/255>;
#declare CN_Dull_Violet = rgb <128/255, 55/255, 144/255>;
#declare CN_Dull_Yellow = rgb <238/255, 220/255, 91/255>;
#declare CN_Dumpling = rgb <247/255, 221/255, 170/255>;
#declare CN_Dun_Morogh_Blue = rgb <128/255, 180/255, 220/255>;
#declare CN_Dune = rgb <213/255, 192/255, 161/255>;
#declare CN_Dune_Drift = rgb <184/255, 141/255, 112/255>;
#declare CN_Dune_Grass = rgb <203/255, 197/255, 177/255>;
#declare CN_Dune_Shadow = rgb <134/255, 118/255, 101/255>;
#declare CN_Dunes_Manor = rgb <81/255, 79/255, 74/255>;
#declare CN_Dungeon_Keeper = rgb <239/255, 48/255, 56/255>;
#declare CN_Dunnock_Egg = rgb <217/255, 236/255, 230/255>;
#declare CN_Duomo = rgb <110/255, 96/255, 100/255>;
#declare CN_Dupain = rgb <88/255, 160/255, 188/255>;
#declare CN_Duqqa_Brown = rgb <68/255, 34/255, 17/255>;
#declare CN_Durango_Blue = rgb <86/255, 103/255, 119/255>;
#declare CN_Durango_Dust = rgb <251/255, 227/255, 161/255>;
#declare CN_Durazno_Maduro = rgb <255/255, 185/255, 120/255>;
#declare CN_Durazno_Palido = rgb <255/255, 216/255, 187/255>;
#declare CN_Durban_Sky = rgb <93/255, 138/255, 155/255>;
#declare CN_Durian = rgb <176/255, 121/255, 57/255>;
#declare CN_Durian_Smell = rgb <229/255, 224/255, 219/255>;
#declare CN_Durian_White = rgb <230/255, 208/255, 171/255>;
#declare CN_Durian_Yellow = rgb <225/255, 189/255, 39/255>;
#declare CN_Durotar_Fire = rgb <240/255, 97/255, 38/255>;
#declare CN_Dusk = rgb <78/255, 84/255, 129/255>;
#declare CN_Dusk_Blue = rgb <123/255, 160/255, 192/255>;
#declare CN_Dusk_Green = rgb <110/255, 122/255, 119/255>;
#declare CN_Dusk_Mauve = rgb <84/255, 88/255, 131/255>;
#declare CN_Dusk_Orange = rgb <254/255, 76/255, 64/255>;
#declare CN_Duskwood = rgb <18/255, 61/255, 85/255>;
#declare CN_Dusky = rgb <195/255, 171/255, 168/255>;
#declare CN_Dusky_Alpine_Blue = rgb <41/255, 103/255, 103/255>;
#declare CN_Dusky_Citron = rgb <227/255, 204/255, 129/255>;
#declare CN_Dusky_Cyclamen = rgb <125/255, 109/255, 112/255>;
#declare CN_Dusky_Damask = rgb <185/255, 132/255, 120/255>;
#declare CN_Dusky_Dawn = rgb <229/255, 225/255, 222/255>;
#declare CN_Dusky_Flesh = rgb <119/255, 68/255, 0/255>;
#declare CN_Dusky_Grape = rgb <135/255, 127/255, 149/255>;
#declare CN_Dusky_Green = rgb <116/255, 108/255, 87/255>;
#declare CN_Dusky_Grouse = rgb <142/255, 150/255, 158/255>;
#declare CN_Dusky_Haze = rgb <167/255, 117/255, 114/255>;
#declare CN_Dusky_Lilac = rgb <214/255, 203/255, 218/255>;
#declare CN_Dusky_Mood = rgb <151/255, 155/255, 168/255>;
#declare CN_Dusky_Moon = rgb <237/255, 236/255, 215/255>;
#declare CN_Dusky_Orchid = rgb <154/255, 113/255, 130/255>;
#declare CN_Dusky_Pink = rgb <204/255, 122/255, 139/255>;
#declare CN_Dusky_Purple = rgb <137/255, 91/255, 123/255>;
#declare CN_Dusky_Rose = rgb <186/255, 104/255, 115/255>;
#declare CN_Dusky_Taupe = rgb <201/255, 189/255, 183/255>;
#declare CN_Dusky_Violet = rgb <208/255, 191/255, 190/255>;
#declare CN_Dusky_Yellow = rgb <255/255, 255/255, 5/255>;
#declare CN_Dust = rgb <178/255, 153/255, 110/255>;
#declare CN_Dust_Bowl = rgb <226/255, 216/255, 211/255>;
#declare CN_Dust_Green = rgb <198/255, 200/255, 190/255>;
#declare CN_Dust_of_the_Moon = rgb <207/255, 201/255, 223/255>;
#declare CN_Dust_Storm = rgb <231/255, 211/255, 183/255>;
#declare CN_Dust_to_Dust = rgb <187/255, 188/255, 188/255>;
#declare CN_Dustblu = rgb <149/255, 155/255, 160/255>;
#declare CN_Dusted_Clay = rgb <204/255, 115/255, 87/255>;
#declare CN_Dusted_Olive = rgb <190/255, 167/255, 117/255>;
#declare CN_Dusted_Peri = rgb <105/255, 107/255, 160/255>;
#declare CN_Dusted_Truffle = rgb <156/255, 131/255, 115/255>;
#declare CN_Dusting_Powder = rgb <231/255, 236/255, 232/255>;
#declare CN_Dustwallow_Marsh = rgb <104/255, 82/255, 67/255>;
#declare CN_Dusty_Aqua = rgb <192/255, 220/255, 205/255>;
#declare CN_Dusty_Attic = rgb <191/255, 182/255, 163/255>;
#declare CN_Dusty_Blue = rgb <140/255, 157/255, 173/255>;
#declare CN_Dusty_Cedar = rgb <221/255, 149/255, 146/255>;
#declare CN_Dusty_Chestnut = rgb <132/255, 113/255, 99/255>;
#declare CN_Dusty_Chimney = rgb <136/255, 136/255, 153/255>;
#declare CN_Dusty_Coral = rgb <210/255, 155/255, 131/255>;
#declare CN_Dusty_Dream = rgb <151/255, 162/255, 160/255>;
#declare CN_Dusty_Gold = rgb <215/255, 185/255, 153/255>;
#declare CN_Dusty_Green = rgb <118/255, 169/255, 115/255>;
#declare CN_Dusty_Grey = rgb <205/255, 204/255, 208/255>;
#declare CN_Dusty_Heather = rgb <137/255, 144/255, 163/255>;
#declare CN_Dusty_Ivory = rgb <241/255, 221/255, 190/255>;
#declare CN_Dusty_Jade_Green = rgb <123/255, 181/255, 163/255>;
#declare CN_Dusty_Lavender = rgb <172/255, 134/255, 168/255>;
#declare CN_Dusty_Lilac = rgb <211/255, 202/255, 205/255>;
#declare CN_Dusty_Mountain = rgb <113/255, 109/255, 99/255>;
#declare CN_Dusty_Olive = rgb <100/255, 99/255, 86/255>;
#declare CN_Dusty_Orange = rgb <226/255, 122/255, 83/255>;
#declare CN_Dusty_Path = rgb <140/255, 119/255, 99/255>;
#declare CN_Dusty_Pink = rgb <213/255, 138/255, 148/255>;
#declare CN_Dusty_Plum = rgb <215/255, 208/255, 225/255>;
#declare CN_Dusty_Purple = rgb <130/255, 95/255, 135/255>;
#declare CN_Dusty_Red = rgb <185/255, 72/255, 78/255>;
#declare CN_Dusty_Rose = rgb <186/255, 121/255, 125/255>;
#declare CN_Dusty_Rosewood = rgb <192/255, 170/255, 159/255>;
#declare CN_Dusty_Sand = rgb <189/255, 186/255, 174/255>;
#declare CN_Dusty_Sky = rgb <149/255, 163/255, 166/255>;
#declare CN_Dusty_Teal = rgb <76/255, 144/255, 133/255>;
#declare CN_Dusty_Trail = rgb <201/255, 187/255, 163/255>;
#declare CN_Dusty_Trail_Rider = rgb <195/255, 185/255, 166/255>;
#declare CN_Dusty_Turquoise = rgb <100/255, 155/255, 158/255>;
#declare CN_Dusty_Warrior = rgb <186/255, 183/255, 179/255>;
#declare CN_Dusty_Yellow = rgb <212/255, 204/255, 154/255>;
#declare CN_Dutch_Blue = rgb <74/255, 99/255, 141/255>;
#declare CN_Dutch_Cocoa = rgb <140/255, 112/255, 106/255>;
#declare CN_Dutch_Jug = rgb <165/255, 171/255, 182/255>;
#declare CN_Dutch_Orange = rgb <223/255, 168/255, 55/255>;
#declare CN_Dutch_Tile_Blue = rgb <154/255, 171/255, 171/255>;
#declare CN_Dutch_White = rgb <240/255, 223/255, 187/255>;
#declare CN_Dutchess_Dawn = rgb <201/255, 167/255, 172/255>;
#declare CN_Duvall = rgb <15/255, 139/255, 142/255>;
#declare CN_Dwarf_Fortress = rgb <29/255, 2/255, 0/255>;
#declare CN_Dwarf_Pony = rgb <175/255, 123/255, 87/255>;
#declare CN_Dwarf_Rabbit = rgb <200/255, 172/255, 137/255>;
#declare CN_Dwarf_Spruce = rgb <113/255, 132/255, 125/255>;
#declare CN_Dwarven_Bronze = rgb <191/255, 101/255, 46/255>;
#declare CN_Dwarven_Flesh = rgb <255/255, 160/255, 122/255>;
#declare CN_Dwindling_Damon = rgb <239/255, 223/255, 231/255>;
#declare CN_Dwindling_Dandelion = rgb <249/255, 233/255, 215/255>;
#declare CN_Dwindling_Denim = rgb <204/255, 225/255, 238/255>;
#declare CN_Dyers_Woad = rgb <123/255, 153/255, 176/255>;
#declare CN_Dying_Light = rgb <54/255, 65/255, 65/255>;
#declare CN_Dying_Moss = rgb <102/255, 156/255, 125/255>;
#declare CN_Dynamic = rgb <109/255, 81/255, 96/255>;
#declare CN_Dynamic_Blue = rgb <1/255, 146/255, 198/255>;
#declare CN_Dynamic_Green = rgb <167/255, 225/255, 66/255>;
#declare CN_Dynamic_Magenta = rgb <138/255, 84/255, 127/255>;
#declare CN_Dynamic_Yellow = rgb <255/255, 227/255, 109/255>;
#declare CN_Dynamite = rgb <255/255, 68/255, 34/255>;
#declare CN_Dynamite_Red = rgb <221/255, 51/255, 17/255>;
#declare CN_Dynamo = rgb <149/255, 61/255, 104/255>;
#declare CN_Dynasty_Celadon = rgb <199/255, 203/255, 190/255>;
#declare CN_Dynasty_Green = rgb <0/255, 142/255, 128/255>;
#declare CN_E_Honda_Beige = rgb <248/255, 215/255, 127/255>;
#declare CN_Eagle = rgb <176/255, 172/255, 148/255>;
#declare CN_Eagle_Eye = rgb <115/255, 102/255, 101/255>;
#declare CN_Eagle_Ridge = rgb <125/255, 119/255, 108/255>;
#declare CN_Eagle_Rock = rgb <92/255, 82/255, 66/255>;
#declare CN_Eagles_Meadow = rgb <141/255, 125/255, 104/255>;
#declare CN_Eagles_View = rgb <212/255, 203/255, 204/255>;
#declare CN_Eagles_Nest = rgb <138/255, 105/255, 63/255>;
#declare CN_Eaglet_Beige = rgb <233/255, 217/255, 192/255>;
#declare CN_Eames_for_Blue = rgb <70/255, 107/255, 130/255>;
#declare CN_Earhart_Emerald = rgb <65/255, 102/255, 89/255>;
#declare CN_Earl_Grey = rgb <166/255, 151/255, 138/255>;
#declare CN_Earls_Green = rgb <184/255, 167/255, 34/255>;
#declare CN_Early_Blossom = rgb <255/255, 229/255, 237/255>;
#declare CN_Early_Crocus = rgb <234/255, 231/255, 231/255>;
#declare CN_Early_Dawn = rgb <121/255, 114/255, 135/255>;
#declare CN_Early_Dew = rgb <68/255, 170/255, 0/255>;
#declare CN_Early_Dog_Violet = rgb <211/255, 214/255, 233/255>;
#declare CN_Early_Evening = rgb <202/255, 199/255, 191/255>;
#declare CN_Early_Forget_Me_Not = rgb <186/255, 229/255, 238/255>;
#declare CN_Early_Frost = rgb <218/255, 227/255, 233/255>;
#declare CN_Early_Harvest = rgb <185/255, 190/255, 130/255>;
#declare CN_Early_July = rgb <165/255, 221/255, 234/255>;
#declare CN_Early_June = rgb <177/255, 210/255, 223/255>;
#declare CN_Early_September = rgb <173/255, 205/255, 220/255>;
#declare CN_Early_Snow = rgb <253/255, 243/255, 228/255>;
#declare CN_Early_Spring = rgb <150/255, 188/255, 74/255>;
#declare CN_Early_Spring_Night = rgb <60/255, 63/255, 177/255>;
#declare CN_Early_Sunset = rgb <243/255, 227/255, 216/255>;
#declare CN_Earth = rgb <162/255, 101/255, 62/255>;
#declare CN_Earth_Black = rgb <73/255, 67/255, 59/255>;
#declare CN_Earth_Brown = rgb <79/255, 21/255, 7/255>;
#declare CN_Earth_Brown_Violet = rgb <112/255, 83/255, 100/255>;
#declare CN_Earth_Chi = rgb <199/255, 175/255, 136/255>;
#declare CN_Earth_Chicory = rgb <102/255, 75/255, 64/255>;
#declare CN_Earth_Crust = rgb <140/255, 79/255, 66/255>;
#declare CN_Earth_Eclipse = rgb <113/255, 186/255, 180/255>;
#declare CN_Earth_Fired_Red = rgb <120/255, 82/255, 64/255>;
#declare CN_Earth_Green = rgb <84/255, 95/255, 91/255>;
#declare CN_Earth_Happiness = rgb <227/255, 237/255, 200/255>;
#declare CN_Earth_Red = rgb <149/255, 66/255, 78/255>;
#declare CN_Earth_Rose = rgb <181/255, 119/255, 112/255>;
#declare CN_Earth_Tone = rgb <160/255, 110/255, 87/255>;
#declare CN_Earth_Warming = rgb <191/255, 159/255, 145/255>;
#declare CN_Earth_Yellow = rgb <225/255, 169/255, 95/255>;
#declare CN_Earthbound = rgb <164/255, 138/255, 128/255>;
#declare CN_Earthen_Cheer = rgb <102/255, 121/255, 113/255>;
#declare CN_Earthen_Jug = rgb <168/255, 94/255, 57/255>;
#declare CN_Earthenware = rgb <168/255, 147/255, 115/255>;
#declare CN_Earthling = rgb <222/255, 214/255, 199/255>;
#declare CN_Earthly_Delight = rgb <171/255, 138/255, 104/255>;
#declare CN_Earthly_Pleasure = rgb <105/255, 60/255, 59/255>;
#declare CN_Earthly_Pleasures = rgb <159/255, 136/255, 99/255>;
#declare CN_Earthnut = rgb <157/255, 134/255, 117/255>;
#declare CN_Earthtone = rgb <93/255, 58/255, 26/255>;
#declare CN_Earthworm = rgb <195/255, 129/255, 110/255>;
#declare CN_Earthy_Cane = rgb <197/255, 178/255, 139/255>;
#declare CN_Earthy_Khaki_Green = rgb <102/255, 102/255, 0/255>;
#declare CN_Earthy_Ocher = rgb <184/255, 158/255, 120/255>;
#declare CN_Earthy_Ochre = rgb <190/255, 174/255, 136/255>;
#declare CN_Eased_Pink = rgb <250/255, 227/255, 227/255>;
#declare CN_Easily_Suede = rgb <178/255, 157/255, 138/255>;
#declare CN_East_Bay = rgb <71/255, 82/255, 110/255>;
#declare CN_East_Cape = rgb <176/255, 238/255, 226/255>;
#declare CN_East_Side = rgb <170/255, 140/255, 188/255>;
#declare CN_Easter_Bunny = rgb <235/255, 229/255, 235/255>;
#declare CN_Easter_Egg = rgb <145/255, 155/255, 201/255>;
#declare CN_Easter_Green = rgb <140/255, 253/255, 126/255>;
#declare CN_Easter_Purple = rgb <192/255, 113/255, 254/255>;
#declare CN_Easter_Rabbit = rgb <199/255, 191/255, 195/255>;
#declare CN_Eastern_Amber = rgb <235/255, 182/255, 126/255>;
#declare CN_Eastern_Bamboo = rgb <94/255, 93/255, 61/255>;
#declare CN_Eastern_Blue = rgb <0/255, 135/255, 159/255>;
#declare CN_Eastern_Bluebird = rgb <116/255, 134/255, 149/255>;
#declare CN_Eastern_Breeze = rgb <218/255, 224/255, 230/255>;
#declare CN_Eastern_Gold = rgb <184/255, 155/255, 108/255>;
#declare CN_Eastern_Sky = rgb <143/255, 193/255, 210/255>;
#declare CN_Eastern_Spice = rgb <219/255, 168/255, 127/255>;
#declare CN_Eastern_Wind = rgb <237/255, 230/255, 213/255>;
#declare CN_Eastern_Wolf = rgb <219/255, 215/255, 210/255>;
#declare CN_Eastlake_Gold = rgb <194/255, 142/255, 97/255>;
#declare CN_Eastlake_Lavender = rgb <136/255, 125/255, 121/255>;
#declare CN_Eastlake_Olive = rgb <169/255, 164/255, 130/255>;
#declare CN_Easy = rgb <190/255, 179/255, 148/255>;
#declare CN_Easy_Breezy_Blue = rgb <158/255, 177/255, 174/255>;
#declare CN_Easy_Green = rgb <159/255, 178/255, 137/255>;
#declare CN_Easy_On_The_Eyes = rgb <249/255, 236/255, 182/255>;
#declare CN_Eat_Your_Greens = rgb <105/255, 104/255, 69/255>;
#declare CN_Eat_Your_Peas = rgb <128/255, 152/255, 122/255>;
#declare CN_Eaton_Gold = rgb <187/255, 159/255, 96/255>;
#declare CN_Eaves = rgb <206/255, 205/255, 173/255>;
#declare CN_Ebb = rgb <230/255, 216/255, 212/255>;
#declare CN_Ebbing_Tide = rgb <104/255, 141/255, 138/255>;
#declare CN_Ebbtide = rgb <132/255, 180/255, 190/255>;
#declare CN_Ebi_Brown = rgb <119/255, 60/255, 48/255>;
#declare CN_Ebicha_Brown = rgb <94/255, 40/255, 36/255>;
#declare CN_Ebizome_Purple = rgb <109/255, 43/255, 80/255>;
#declare CN_Ebony = rgb <49/255, 51/255, 55/255>;
#declare CN_Ebony_Clay = rgb <50/255, 52/255, 56/255>;
#declare CN_Ebony_Lips = rgb <176/255, 106/255, 64/255>;
#declare CN_Ebony_Wood = rgb <44/255, 50/255, 39/255>;
#declare CN_Eburnean = rgb <255/255, 255/255, 238/255>;
#declare CN_Eccentric_Magenta = rgb <181/255, 118/255, 167/255>;
#declare CN_Eccentricity = rgb <150/255, 138/255, 159/255>;
#declare CN_Echelon_Ecru = rgb <231/255, 216/255, 190/255>;
#declare CN_Echinoderm = rgb <255/255, 165/255, 101/255>;
#declare CN_Echinoidea_Thorns = rgb <255/255, 167/255, 86/255>;
#declare CN_Echo = rgb <215/255, 231/255, 224/255>;
#declare CN_Echo_Blue = rgb <164/255, 175/255, 205/255>;
#declare CN_Echo_Iris = rgb <182/255, 223/255, 244/255>;
#declare CN_Echo_Isles_Water = rgb <149/255, 181/255, 219/255>;
#declare CN_Echo_Mist = rgb <216/255, 223/255, 223/255>;
#declare CN_Echo_One = rgb <98/255, 157/255, 166/255>;
#declare CN_Echo_Park = rgb <117/255, 136/255, 131/255>;
#declare CN_Echo_Valley = rgb <230/255, 226/255, 214/255>;
#declare CN_Echoes_of_Love = rgb <238/255, 222/255, 221/255>;
#declare CN_Eclectic = rgb <170/255, 175/255, 189/255>;
#declare CN_Eclectic_Plum = rgb <140/255, 110/255, 103/255>;
#declare CN_Eclectic_Purple = rgb <72/255, 62/255, 69/255>;
#declare CN_Eclipse = rgb <63/255, 57/255, 57/255>;
#declare CN_Eclipse_Blue = rgb <69/255, 96/255, 116/255>;
#declare CN_Eco_Green = rgb <168/255, 151/255, 104/255>;
#declare CN_Ecological = rgb <103/255, 127/255, 112/255>;
#declare CN_Ecru = rgb <194/255, 178/255, 128/255>;
#declare CN_Ecru_Ochre = rgb <164/255, 141/255, 131/255>;
#declare CN_Ecru_Olive = rgb <146/255, 123/255, 60/255>;
#declare CN_Ecru_Wealth = rgb <213/255, 205/255, 180/255>;
#declare CN_Ecru_White = rgb <214/255, 209/255, 192/255>;
#declare CN_Ecstasy = rgb <201/255, 97/255, 56/255>;
#declare CN_Ecstatic_Red = rgb <170/255, 17/255, 34/255>;
#declare CN_Ecuadorian_Banana = rgb <255/255, 255/255, 126/255>;
#declare CN_Edamame = rgb <156/255, 163/255, 137/255>;
#declare CN_Edelweiss = rgb <238/255, 232/255, 217/255>;
#declare CN_Eden = rgb <38/255, 98/255, 85/255>;
#declare CN_Eden_Prairie = rgb <149/255, 134/255, 60/255>;
#declare CN_Edge_of_Black = rgb <84/255, 88/255, 94/255>;
#declare CN_Edge_of_Space = rgb <51/255, 0/255, 68/255>;
#declare CN_Edge_of_the_Galaxy = rgb <48/255, 61/255, 60/255>;
#declare CN_Edgewater = rgb <193/255, 216/255, 197/255>;
#declare CN_Edgy_Gold = rgb <177/255, 151/255, 95/255>;
#declare CN_Edgy_Red = rgb <186/255, 61/255, 60/255>;
#declare CN_Edocha = rgb <161/255, 61/255, 45/255>;
#declare CN_Edward = rgb <94/255, 126/255, 125/255>;
#declare CN_Edwardian_Lace = rgb <246/255, 237/255, 224/255>;
#declare CN_Eerie_Black = rgb <27/255, 27/255, 27/255>;
#declare CN_Effervescent = rgb <251/255, 244/255, 209/255>;
#declare CN_Effervescent_Blue = rgb <0/255, 49/255, 90/255>;
#declare CN_Effervescent_Lime = rgb <152/255, 218/255, 44/255>;
#declare CN_EGA_Green = rgb <1/255, 255/255, 7/255>;
#declare CN_Egg_Blue = rgb <193/255, 231/255, 235/255>;
#declare CN_Egg_Cream = rgb <255/255, 217/255, 140/255>;
#declare CN_Egg_Liqueur = rgb <220/255, 202/255, 168/255>;
#declare CN_Egg_Noodle = rgb <241/255, 227/255, 189/255>;
#declare CN_Egg_Sour = rgb <249/255, 228/255, 197/255>;
#declare CN_Egg_Toast = rgb <242/255, 201/255, 17/255>;
#declare CN_Egg_Wash = rgb <226/255, 225/255, 200/255>;
#declare CN_Egg_White = rgb <255/255, 239/255, 193/255>;
#declare CN_Egg_Yolk = rgb <255/255, 206/255, 129/255>;
#declare CN_Eggnog = rgb <253/255, 234/255, 159/255>;
#declare CN_Eggplant = rgb <67/255, 5/255, 65/255>;
#declare CN_Eggplant_Ash = rgb <101/255, 101/255, 121/255>;
#declare CN_Eggplant_Tint = rgb <83/255, 27/255, 147/255>;
#declare CN_Eggshell = rgb <240/255, 234/255, 214/255>;
#declare CN_Eggshell_Blue = rgb <163/255, 204/255, 201/255>;
#declare CN_Eggshell_Cream = rgb <245/255, 238/255, 219/255>;
#declare CN_Eggshell_Paper = rgb <226/255, 190/255, 159/255>;
#declare CN_Eggshell_White = rgb <243/255, 228/255, 220/255>;
#declare CN_Eggwhite = rgb <243/255, 229/255, 210/255>;
#declare CN_Egret = rgb <243/255, 236/255, 224/255>;
#declare CN_Egret_White = rgb <223/255, 217/255, 207/255>;
#declare CN_Egyptian_Blue = rgb <16/255, 52/255, 166/255>;
#declare CN_Egyptian_Enamel = rgb <0/255, 92/255, 105/255>;
#declare CN_Egyptian_Gold = rgb <239/255, 168/255, 76/255>;
#declare CN_Egyptian_Green = rgb <8/255, 132/255, 124/255>;
#declare CN_Egyptian_Jasper = rgb <122/255, 75/255, 58/255>;
#declare CN_Egyptian_Javelin = rgb <254/255, 188/255, 173/255>;
#declare CN_Egyptian_Nile = rgb <112/255, 119/255, 92/255>;
#declare CN_Egyptian_Pyramid = rgb <193/255, 154/255, 125/255>;
#declare CN_Egyptian_Red = rgb <152/255, 63/255, 74/255>;
#declare CN_Egyptian_Sand = rgb <190/255, 172/255, 144/255>;
#declare CN_Egyptian_Teal = rgb <0/255, 140/255, 141/255>;
#declare CN_Egyptian_Temple = rgb <214/255, 179/255, 120/255>;
#declare CN_Egyptian_Violet = rgb <61/255, 73/255, 109/255>;
#declare CN_Egyptian_White = rgb <229/255, 241/255, 236/255>;
#declare CN_Eider_White = rgb <225/255, 222/255, 215/255>;
#declare CN_Eiffel_Tower = rgb <153/255, 142/255, 131/255>;
#declare CN_Eigengrau = rgb <22/255, 22/255, 29/255>;
#declare CN_Eiger_Nordwand = rgb <119/255, 153/255, 187/255>;
#declare CN_El_Capitan = rgb <183/255, 166/255, 150/255>;
#declare CN_El_Caramelo = rgb <148/255, 110/255, 72/255>;
#declare CN_El_Nino = rgb <208/255, 202/255, 205/255>;
#declare CN_El_Paso = rgb <57/255, 57/255, 44/255>;
#declare CN_El_Salva = rgb <143/255, 78/255, 69/255>;
#declare CN_Elastic_Pink = rgb <236/255, 166/255, 202/255>;
#declare CN_Elation = rgb <223/255, 220/255, 229/255>;
#declare CN_Eldar_Flesh = rgb <236/255, 192/255, 131/255>;
#declare CN_Elder_Creek = rgb <175/255, 168/255, 146/255>;
#declare CN_Elderberry = rgb <46/255, 34/255, 73/255>;
#declare CN_Elderberry_Black = rgb <30/255, 50/255, 59/255>;
#declare CN_Elderberry_Grey = rgb <174/255, 168/255, 176/255>;
#declare CN_Elderberry_White = rgb <234/255, 229/255, 207/255>;
#declare CN_Elderflower = rgb <251/255, 249/255, 232/255>;
#declare CN_Eleanor_Ann = rgb <64/255, 55/255, 62/255>;
#declare CN_Election_Night = rgb <17/255, 3/255, 32/255>;
#declare CN_Electra = rgb <85/255, 180/255, 146/255>;
#declare CN_Electric_Blue = rgb <125/255, 249/255, 255/255>;
#declare CN_Electric_Brown = rgb <181/255, 98/255, 87/255>;
#declare CN_Electric_Crimson = rgb <255/255, 0/255, 63/255>;
#declare CN_Electric_Cyan = rgb <15/255, 240/255, 252/255>;
#declare CN_Electric_Eel = rgb <136/255, 187/255, 238/255>;
#declare CN_Electric_Energy = rgb <201/255, 228/255, 35/255>;
#declare CN_Electric_Flamingo = rgb <252/255, 116/255, 253/255>;
#declare CN_Electric_Glow = rgb <255/255, 209/255, 0/255>;
#declare CN_Electric_Green = rgb <33/255, 252/255, 13/255>;
#declare CN_Electric_Indigo = rgb <102/255, 0/255, 255/255>;
#declare CN_Electric_Lavender = rgb <244/255, 191/255, 255/255>;
#declare CN_Electric_Leaf = rgb <137/255, 221/255, 1/255>;
#declare CN_Electric_Lime = rgb <204/255, 255/255, 0/255>;
#declare CN_Electric_Orange = rgb <255/255, 53/255, 3/255>;
#declare CN_Electric_Pink = rgb <255/255, 4/255, 144/255>;
#declare CN_Electric_Purple = rgb <191/255, 0/255, 255/255>;
#declare CN_Electric_Red = rgb <230/255, 0/255, 0/255>;
#declare CN_Electric_Sheep = rgb <85/255, 255/255, 255/255>;
#declare CN_Electric_Slide = rgb <157/255, 176/255, 185/255>;
#declare CN_Electric_Ultramarine = rgb <63/255, 0/255, 255/255>;
#declare CN_Electric_Violet = rgb <143/255, 0/255, 241/255>;
#declare CN_Electric_Yellow = rgb <255/255, 252/255, 0/255>;
#declare CN_Electrify = rgb <86/255, 101/255, 160/255>;
#declare CN_Electromagnetic = rgb <46/255, 56/255, 64/255>;
#declare CN_Electron_Blue = rgb <8/255, 129/255, 209/255>;
#declare CN_Electronic = rgb <85/255, 109/255, 136/255>;
#declare CN_Electrum = rgb <231/255, 198/255, 151/255>;
#declare CN_Elegant_Ice = rgb <196/255, 185/255, 183/255>;
#declare CN_Elegant_Ivory = rgb <241/255, 230/255, 214/255>;
#declare CN_Elegant_Light_Rose = rgb <253/255, 202/255, 202/255>;
#declare CN_Elegant_Midnight = rgb <85/255, 0/255, 187/255>;
#declare CN_Elegant_Navy = rgb <72/255, 81/255, 106/255>;
#declare CN_Elegant_White = rgb <245/255, 240/255, 225/255>;
#declare CN_Elemental = rgb <208/255, 211/255, 211/255>;
#declare CN_Elemental_Green = rgb <150/255, 151/255, 131/255>;
#declare CN_Elemental_Grey = rgb <160/255, 160/255, 159/255>;
#declare CN_Elemental_Tan = rgb <202/255, 183/255, 156/255>;
#declare CN_Elephant = rgb <36/255, 54/255, 64/255>;
#declare CN_Elephant_Ear = rgb <152/255, 143/255, 133/255>;
#declare CN_Elephant_Grey = rgb <149/255, 145/255, 140/255>;
#declare CN_Elephant_in_the_Room = rgb <168/255, 169/255, 168/255>;
#declare CN_Elephant_Skin = rgb <143/255, 137/255, 130/255>;
#declare CN_Elevated = rgb <179/255, 195/255, 212/255>;
#declare CN_Elf_Flesh = rgb <247/255, 195/255, 128/255>;
#declare CN_Elf_Green = rgb <27/255, 138/255, 107/255>;
#declare CN_Elf_Shoe = rgb <104/255, 176/255, 130/255>;
#declare CN_Elf_Skintone = rgb <247/255, 201/255, 133/255>;
#declare CN_Elf_Slippers = rgb <166/255, 168/255, 101/255>;
#declare CN_Elfin_Games = rgb <157/255, 209/255, 150/255>;
#declare CN_Elfin_Herb = rgb <202/255, 180/255, 212/255>;
#declare CN_Elfin_Magic = rgb <237/255, 219/255, 233/255>;
#declare CN_Elfin_Yellow = rgb <238/255, 234/255, 151/255>;
#declare CN_Elise = rgb <216/255, 215/255, 185/255>;
#declare CN_Elite_Blue = rgb <27/255, 48/255, 83/255>;
#declare CN_Elite_Green = rgb <19/255, 55/255, 0/255>;
#declare CN_Elite_Pink = rgb <187/255, 141/255, 168/255>;
#declare CN_Elite_Teal = rgb <19/255, 51/255, 55/255>;
#declare CN_Elite_Wisteria = rgb <152/255, 127/255, 169/255>;
#declare CN_Elizabeth_Blue = rgb <161/255, 184/255, 210/255>;
#declare CN_Elizabeth_Rose = rgb <250/255, 223/255, 210/255>;
#declare CN_Elk_Horn = rgb <233/255, 226/255, 211/255>;
#declare CN_Elk_Skin = rgb <234/255, 230/255, 220/255>;
#declare CN_Elkhound = rgb <137/255, 114/255, 105/255>;
#declare CN_Ellen = rgb <226/255, 200/255, 183/255>;
#declare CN_Ellie_Gray = rgb <170/255, 169/255, 164/255>;
#declare CN_Ellis_Mist = rgb <119/255, 128/255, 112/255>;
#declare CN_Elm = rgb <41/255, 123/255, 118/255>;
#declare CN_Elm_Brown_Red = rgb <178/255, 91/255, 9/255>;
#declare CN_Elm_Green = rgb <84/255, 112/255, 83/255>;
#declare CN_Elmers_Echo = rgb <38/255, 64/255, 102/255>;
#declare CN_Elmwood = rgb <140/255, 124/255, 97/255>;
#declare CN_Elote = rgb <255/255, 232/255, 171/255>;
#declare CN_Elusion = rgb <210/255, 207/255, 204/255>;
#declare CN_Elusive = rgb <254/255, 215/255, 207/255>;
#declare CN_Elusive_Blue = rgb <221/255, 228/255, 232/255>;
#declare CN_Elusive_Dawn = rgb <213/255, 191/255, 173/255>;
#declare CN_Elusive_Dream = rgb <205/255, 191/255, 198/255>;
#declare CN_Elusive_Mauve = rgb <222/255, 196/255, 210/255>;
#declare CN_Elusive_Violet = rgb <212/255, 192/255, 197/255>;
#declare CN_Elusive_White = rgb <232/255, 227/255, 214/255>;
#declare CN_Elven_Flesh = rgb <247/255, 207/255, 138/255>;
#declare CN_Elwynn_Forest_Olive = rgb <122/255, 135/255, 22/255>;
#declare CN_Elysia_Chlorotica = rgb <154/255, 174/255, 7/255>;
#declare CN_Elysian_Green = rgb <165/255, 177/255, 69/255>;
#declare CN_Elysium_Gold = rgb <206/255, 149/255, 0/255>;
#declare CN_Emanation = rgb <180/255, 163/255, 187/255>;
#declare CN_Embarcadero = rgb <93/255, 70/255, 67/255>;
#declare CN_Embarrassed_Frog = rgb <153/255, 102/255, 17/255>;
#declare CN_Embarrassment = rgb <255/255, 119/255, 119/255>;
#declare CN_Embellished_Blue = rgb <139/255, 199/255, 200/255>;
#declare CN_Embellishment = rgb <203/255, 222/255, 226/255>;
#declare CN_Ember_Red = rgb <121/255, 36/255, 69/255>;
#declare CN_Emberglow = rgb <234/255, 103/255, 89/255>;
#declare CN_Embrace = rgb <232/255, 184/255, 167/255>;
#declare CN_Embracing = rgb <36/255, 100/255, 83/255>;
#declare CN_Embroidered_Silk = rgb <184/255, 220/255, 167/255>;
#declare CN_Embroidery = rgb <212/255, 190/255, 191/255>;
#declare CN_Emerald = rgb <2/255, 143/255, 30/255>;
#declare CN_Emerald_City = rgb <106/255, 126/255, 95/255>;
#declare CN_Emerald_Clear_Green = rgb <79/255, 129/255, 41/255>;
#declare CN_Emerald_Coast = rgb <0/255, 145/255, 133/255>;
#declare CN_Emerald_Dream = rgb <0/255, 122/255, 94/255>;
#declare CN_Emerald_Forest = rgb <34/255, 67/255, 71/255>;
#declare CN_Emerald_Glitter = rgb <102/255, 187/255, 0/255>;
#declare CN_Emerald_Green = rgb <4/255, 99/255, 7/255>;
#declare CN_Emerald_Lake = rgb <6/255, 146/255, 97/255>;
#declare CN_Emerald_Light_Green = rgb <0/255, 162/255, 103/255>;
#declare CN_Emerald_Pool = rgb <21/255, 94/255, 96/255>;
#declare CN_Emerald_Reflection = rgb <80/255, 200/255, 120/255>;
#declare CN_Emerald_Ring = rgb <87/255, 135/255, 88/255>;
#declare CN_Emerald_Spring = rgb <9/255, 81/255, 85/255>;
#declare CN_Emerald_Starling = rgb <17/255, 187/255, 17/255>;
#declare CN_Emerald_Stone = rgb <1/255, 99/255, 96/255>;
#declare CN_Emerald_Succulent = rgb <85/255, 170/255, 170/255>;
#declare CN_Emerald_Wave = rgb <79/255, 179/255, 169/255>;
#declare CN_Emerald_Crested_Manakin = rgb <92/255, 107/255, 143/255>;
#declare CN_Emergency = rgb <145/255, 25/255, 17/255>;
#declare CN_Emergency_Zone = rgb <227/255, 105/255, 64/255>;
#declare CN_Emerging_Leaf = rgb <225/255, 225/255, 207/255>;
#declare CN_Emerging_Taupe = rgb <184/255, 161/255, 150/255>;
#declare CN_Emerson = rgb <62/255, 96/255, 88/255>;
#declare CN_Emilies_Dream = rgb <236/255, 206/255, 229/255>;
#declare CN_Emily = rgb <171/255, 209/255, 225/255>;
#declare CN_Emily_Ann_Tan = rgb <213/255, 199/255, 182/255>;
#declare CN_Eminence = rgb <110/255, 57/255, 116/255>;
#declare CN_Eminent_Bronze = rgb <122/255, 104/255, 65/255>;
#declare CN_Emoji_Yellow = rgb <255/255, 222/255, 52/255>;
#declare CN_Emotional = rgb <198/255, 95/255, 71/255>;
#declare CN_Emotive_Ring = rgb <133/255, 109/255, 112/255>;
#declare CN_Emperador = rgb <104/255, 72/255, 50/255>;
#declare CN_Emperor = rgb <80/255, 73/255, 74/255>;
#declare CN_Emperor_Cherry_Red = rgb <172/255, 44/255, 50/255>;
#declare CN_Emperor_Jade = rgb <0/255, 123/255, 117/255>;
#declare CN_Emperor_Jewel = rgb <113/255, 90/255, 141/255>;
#declare CN_Emperors_Children = rgb <240/255, 160/255, 182/255>;
#declare CN_Emperors_Gold = rgb <176/255, 151/255, 109/255>;
#declare CN_Emperors_Robe = rgb <153/255, 149/255, 157/255>;
#declare CN_Emperors_Silk = rgb <0/255, 129/255, 106/255>;
#declare CN_Emperors_Children = rgb <185/255, 66/255, 120/255>;
#declare CN_Empire_Blue = rgb <97/255, 147/255, 180/255>;
#declare CN_Empire_Gold = rgb <193/255, 159/255, 110/255>;
#declare CN_Empire_Porcelain = rgb <224/255, 219/255, 211/255>;
#declare CN_Empire_Ranch = rgb <147/255, 130/255, 106/255>;
#declare CN_Empire_Rose = rgb <231/255, 197/255, 193/255>;
#declare CN_Empire_State_Grey = rgb <217/255, 219/255, 223/255>;
#declare CN_Empire_Violet = rgb <146/255, 100/255, 162/255>;
#declare CN_Empire_Yellow = rgb <247/255, 208/255, 0/255>;
#declare CN_Empower = rgb <181/255, 70/255, 68/255>;
#declare CN_Empress = rgb <124/255, 113/255, 115/255>;
#declare CN_Empress_Envy = rgb <42/255, 156/255, 160/255>;
#declare CN_Empress_Teal = rgb <16/255, 96/255, 90/255>;
#declare CN_Emptiness = rgb <252/255, 253/255, 252/255>;
#declare CN_Emu = rgb <117/255, 110/255, 109/255>;
#declare CN_Emu_Egg = rgb <61/255, 132/255, 129/255>;
#declare CN_En_Plein_Air = rgb <208/255, 197/255, 190/255>;
#declare CN_Enamel_Antique_Green = rgb <66/255, 127/255, 133/255>;
#declare CN_Enamel_Blue = rgb <0/255, 122/255, 142/255>;
#declare CN_Enamel_Green = rgb <186/255, 204/255, 168/255>;
#declare CN_Enamelled_Dragon = rgb <84/255, 197/255, 137/255>;
#declare CN_Enamelled_Jewel = rgb <4/255, 92/255, 97/255>;
#declare CN_Enamored = rgb <198/255, 125/255, 132/255>;
#declare CN_Encaje_Aperlado = rgb <247/255, 235/255, 214/255>;
#declare CN_Encarnado = rgb <253/255, 2/255, 2/255>;
#declare CN_Enchant = rgb <209/255, 198/255, 210/255>;
#declare CN_Enchanted = rgb <201/255, 226/255, 207/255>;
#declare CN_Enchanted_Blue = rgb <4/255, 116/255, 149/255>;
#declare CN_Enchanted_Eve = rgb <121/255, 131/255, 127/255>;
#declare CN_Enchanted_Evening = rgb <211/255, 233/255, 236/255>;
#declare CN_Enchanted_Meadow = rgb <177/255, 212/255, 183/255>;
#declare CN_Enchanted_Silver = rgb <181/255, 181/255, 189/255>;
#declare CN_Enchanted_Wells = rgb <38/255, 173/255, 141/255>;
#declare CN_Enchanted_Wood = rgb <148/255, 137/255, 95/255>;
#declare CN_Enchanting = rgb <130/255, 186/255, 223/255>;
#declare CN_Enchanting_Ginger = rgb <172/255, 116/255, 53/255>;
#declare CN_Enchanting_Ivy = rgb <49/255, 89/255, 85/255>;
#declare CN_Enchanting_Sapphire = rgb <39/255, 109/255, 214/255>;
#declare CN_Enchanting_Sky = rgb <120/255, 134/255, 170/255>;
#declare CN_Enchantress = rgb <93/255, 58/255, 71/255>;
#declare CN_Encore = rgb <109/255, 115/255, 131/255>;
#declare CN_Encore_Teal = rgb <48/255, 82/255, 91/255>;
#declare CN_Encounter = rgb <255/255, 149/255, 82/255>;
#declare CN_End_of_Summer = rgb <204/255, 143/255, 21/255>;
#declare CN_End_of_the_Rainbow = rgb <210/255, 238/255, 214/255>;
#declare CN_Endearment = rgb <255/255, 216/255, 161/255>;
#declare CN_Endeavour = rgb <41/255, 89/255, 139/255>;
#declare CN_Ending_Autumn = rgb <139/255, 111/255, 100/255>;
#declare CN_Ending_Dawn = rgb <252/255, 201/255, 185/255>;
#declare CN_Ending_Navy_Blue = rgb <28/255, 48/255, 92/255>;
#declare CN_Endive = rgb <206/255, 225/255, 200/255>;
#declare CN_Endless = rgb <91/255, 151/255, 106/255>;
#declare CN_Endless_Galaxy = rgb <0/255, 0/255, 68/255>;
#declare CN_Endless_Possibilities = rgb <224/255, 65/255, 58/255>;
#declare CN_Endless_Sea = rgb <50/255, 88/255, 110/255>;
#declare CN_Endless_Silk = rgb <221/255, 221/255, 187/255>;
#declare CN_Endless_Sky = rgb <202/255, 227/255, 234/255>;
#declare CN_Endless_Slumber = rgb <177/255, 170/255, 179/255>;
#declare CN_Endo = rgb <93/255, 164/255, 100/255>;
#declare CN_Enduring = rgb <88/255, 102/255, 131/255>;
#declare CN_Enduring_Bronze = rgb <85/255, 76/255, 62/255>;
#declare CN_Enduring_Ice = rgb <235/255, 232/255, 219/255>;
#declare CN_Energetic_Orange = rgb <216/255, 87/255, 57/255>;
#declare CN_Energetic_Pink = rgb <243/255, 198/255, 204/255>;
#declare CN_Energic_Eggplant = rgb <179/255, 0/255, 179/255>;
#declare CN_Energise = rgb <124/255, 202/255, 107/255>;
#declare CN_Energized = rgb <210/255, 210/255, 90/255>;
#declare CN_Energos = rgb <192/255, 231/255, 64/255>;
#declare CN_Energy_Green = rgb <28/255, 163/255, 80/255>;
#declare CN_Energy_Orange = rgb <255/255, 149/255, 50/255>;
#declare CN_Energy_Peak = rgb <187/255, 95/255, 96/255>;
#declare CN_Energy_Yellow = rgb <245/255, 215/255, 82/255>;
#declare CN_Enfield_Brown = rgb <167/255, 50/255, 17/255>;
#declare CN_Engagement_Silver = rgb <194/255, 198/255, 192/255>;
#declare CN_English_Bartlett = rgb <161/255, 117/255, 72/255>;
#declare CN_English_Breakfast = rgb <68/255, 17/255, 17/255>;
#declare CN_English_Channel = rgb <78/255, 97/255, 115/255>;
#declare CN_English_Channel_Fog = rgb <203/255, 211/255, 230/255>;
#declare CN_English_Coral = rgb <198/255, 74/255, 85/255>;
#declare CN_English_Custard = rgb <226/255, 182/255, 108/255>;
#declare CN_English_Daisy = rgb <255/255, 202/255, 70/255>;
#declare CN_English_Forest = rgb <96/255, 98/255, 86/255>;
#declare CN_English_Green = rgb <27/255, 77/255, 63/255>;
#declare CN_English_Holly = rgb <39/255, 66/255, 52/255>;
#declare CN_English_Hollyhock = rgb <181/255, 201/255, 211/255>;
#declare CN_English_Ivy = rgb <97/255, 132/255, 91/255>;
#declare CN_English_Lavender = rgb <157/255, 123/255, 176/255>;
#declare CN_English_Manor = rgb <113/255, 129/255, 164/255>;
#declare CN_English_Meadow = rgb <2/255, 138/255, 82/255>;
#declare CN_English_Red = rgb <171/255, 75/255, 82/255>;
#declare CN_English_River = rgb <60/255, 118/255, 138/255>;
#declare CN_English_Rose = rgb <244/255, 198/255, 195/255>;
#declare CN_English_Rose_Bud = rgb <233/255, 201/255, 203/255>;
#declare CN_English_Saddle = rgb <142/255, 105/255, 71/255>;
#declare CN_English_Scone = rgb <233/255, 207/255, 187/255>;
#declare CN_English_Vermillion = rgb <204/255, 71/255, 75/255>;
#declare CN_English_Violet = rgb <86/255, 61/255, 93/255>;
#declare CN_English_Walnut = rgb <62/255, 43/255, 35/255>;
#declare CN_Enhance = rgb <210/255, 165/255, 190/255>;
#declare CN_Enigma = rgb <189/255, 191/255, 53/255>;
#declare CN_Enigmatic = rgb <126/255, 114/255, 117/255>;
#declare CN_Enjoy = rgb <234/255, 212/255, 196/255>;
#declare CN_Enjoyable_Yellow = rgb <245/255, 214/255, 169/255>;
#declare CN_Enlightened_Lime = rgb <227/255, 234/255, 214/255>;
#declare CN_Enoki = rgb <248/255, 250/255, 238/255>;
#declare CN_Enokitake_Mushroom = rgb <255/255, 238/255, 221/255>;
#declare CN_Enough_Is_Enough = rgb <137/255, 140/255, 74/255>;
#declare CN_Enraged = rgb <238/255, 0/255, 68/255>;
#declare CN_Enshucha_Red = rgb <203/255, 102/255, 73/255>;
#declare CN_Ensign_Blue = rgb <56/255, 76/255, 103/255>;
#declare CN_Entan_Red = rgb <236/255, 109/255, 81/255>;
#declare CN_Enterprise = rgb <101/255, 120/255, 140/255>;
#declare CN_Enthroned_Above = rgb <172/255, 146/255, 176/255>;
#declare CN_Enthusiasm = rgb <0/255, 255/255, 170/255>;
#declare CN_Enticing_Red = rgb <183/255, 78/255, 79/255>;
#declare CN_Entrapment = rgb <0/255, 89/255, 97/255>;
#declare CN_Enviable = rgb <83/255, 152/255, 60/255>;
#declare CN_Envious_Pastel = rgb <221/255, 243/255, 194/255>;
#declare CN_Environmental = rgb <177/255, 181/255, 160/255>;
#declare CN_Environmental_Green = rgb <0/255, 108/255, 75/255>;
#declare CN_Environmental_Study = rgb <136/255, 187/255, 0/255>;
#declare CN_Envisage = rgb <150/255, 191/255, 183/255>;
#declare CN_Envy = rgb <139/255, 165/255, 143/255>;
#declare CN_Eon = rgb <212/255, 211/255, 201/255>;
#declare CN_Ephemera = rgb <111/255, 89/255, 101/255>;
#declare CN_Ephemeral_Blue = rgb <203/255, 212/255, 223/255>;
#declare CN_Ephemeral_Fog = rgb <214/255, 206/255, 211/255>;
#declare CN_Ephemeral_Mist = rgb <199/255, 205/255, 211/255>;
#declare CN_Ephemeral_Peach = rgb <252/255, 226/255, 212/255>;
#declare CN_Ephemeral_Red = rgb <228/255, 207/255, 215/255>;
#declare CN_Ephren_Blue = rgb <17/255, 100/255, 180/255>;
#declare CN_Epic_Blue = rgb <0/255, 102/255, 238/255>;
#declare CN_Epicurean_Orange = rgb <234/255, 106/255, 10/255>;
#declare CN_Epidote_Olvene_Ore = rgb <171/255, 146/255, 75/255>;
#declare CN_Epimetheus = rgb <75/255, 178/255, 213/255>;
#declare CN_Epink = rgb <221/255, 51/255, 255/255>;
#declare CN_Epiphany = rgb <219/255, 193/255, 222/255>;
#declare CN_Epsom = rgb <132/255, 145/255, 97/255>;
#declare CN_Equanimity = rgb <131/255, 169/255, 179/255>;
#declare CN_Equator = rgb <218/255, 177/255, 96/255>;
#declare CN_Equator_Glow = rgb <255/255, 230/255, 160/255>;
#declare CN_Equatorial = rgb <255/255, 206/255, 132/255>;
#declare CN_Equatorial_Forest = rgb <112/255, 133/255, 94/255>;
#declare CN_Equestrian = rgb <190/255, 167/255, 129/255>;
#declare CN_Equestrian_Green = rgb <84/255, 101/255, 79/255>;
#declare CN_Equestrian_Leather = rgb <91/255, 86/255, 82/255>;
#declare CN_Equilibrium = rgb <164/255, 159/255, 159/255>;
#declare CN_Equinox = rgb <98/255, 105/255, 107/255>;
#declare CN_Era = rgb <215/255, 227/255, 229/255>;
#declare CN_Erebus_Blue = rgb <6/255, 0/255, 48/255>;
#declare CN_Ermine = rgb <131/255, 107/255, 79/255>;
#declare CN_Eros_Pink = rgb <200/255, 79/255, 104/255>;
#declare CN_Erosion = rgb <221/255, 209/255, 191/255>;
#declare CN_Errigal_White = rgb <242/255, 242/255, 244/255>;
#declare CN_Erythrosine = rgb <252/255, 122/255, 176/255>;
#declare CN_Escalope = rgb <204/255, 136/255, 102/255>;
#declare CN_Escapade_Gold = rgb <184/255, 155/255, 89/255>;
#declare CN_Escape_from_Columbia = rgb <210/255, 226/255, 239/255>;
#declare CN_Escape_Gray = rgb <171/255, 172/255, 159/255>;
#declare CN_Escargot = rgb <255/255, 241/255, 216/255>;
#declare CN_Escarpment = rgb <213/255, 183/255, 155/255>;
#declare CN_Eshin_Grey = rgb <74/255, 79/255, 82/255>;
#declare CN_Eskimo = rgb <85/255, 160/255, 183/255>;
#declare CN_Eskimo_White = rgb <194/255, 189/255, 194/255>;
#declare CN_Esmeralda = rgb <69/255, 190/255, 118/255>;
#declare CN_Espalier = rgb <47/255, 95/255, 58/255>;
#declare CN_Espers_Fungus_Green = rgb <128/255, 249/255, 173/255>;
#declare CN_Esplanade = rgb <213/255, 189/255, 164/255>;
#declare CN_Espresso = rgb <78/255, 49/255, 45/255>;
#declare CN_Espresso_Beans = rgb <76/255, 68/255, 62/255>;
#declare CN_Espresso_Macchiato = rgb <79/255, 71/255, 68/255>;
#declare CN_Espresso_Martini = rgb <170/255, 156/255, 142/255>;
#declare CN_Esprit = rgb <190/255, 189/255, 153/255>;
#declare CN_Essence_of_Violet = rgb <239/255, 237/255, 238/255>;
#declare CN_Essential_Brown = rgb <125/255, 104/255, 72/255>;
#declare CN_Essential_Gray = rgb <188/255, 184/255, 182/255>;
#declare CN_Essential_Teal = rgb <0/255, 115/255, 119/255>;
#declare CN_Essentially_Bright = rgb <255/255, 222/255, 159/255>;
#declare CN_Essex_Blue = rgb <176/255, 204/255, 218/255>;
#declare CN_Establish_Mint = rgb <226/255, 237/255, 221/255>;
#declare CN_Estate_Blue = rgb <35/255, 54/255, 88/255>;
#declare CN_Estate_Limestone = rgb <220/255, 205/255, 180/255>;
#declare CN_Estate_Vineyard = rgb <104/255, 69/255, 75/255>;
#declare CN_Estragon = rgb <165/255, 175/255, 118/255>;
#declare CN_Estroruby = rgb <155/255, 16/255, 31/255>;
#declare CN_Estuary_Blue = rgb <112/255, 165/255, 183/255>;
#declare CN_Etcetera = rgb <225/255, 198/255, 212/255>;
#declare CN_Etched_Glass = rgb <221/255, 226/255, 226/255>;
#declare CN_Eternal_Cherry = rgb <221/255, 0/255, 68/255>;
#declare CN_Eternal_Elegance = rgb <179/255, 195/255, 221/255>;
#declare CN_Eternal_Flame = rgb <161/255, 63/255, 73/255>;
#declare CN_Eternal_White = rgb <250/255, 243/255, 220/255>;
#declare CN_Eternity = rgb <45/255, 47/255, 40/255>;
#declare CN_Ether = rgb <158/255, 182/255, 184/255>;
#declare CN_Etherea = rgb <165/255, 149/255, 143/255>;
#declare CN_Ethereal = rgb <249/255, 238/255, 203/255>;
#declare CN_Ethereal_Blue = rgb <92/255, 166/255, 206/255>;
#declare CN_Ethereal_Green = rgb <241/255, 236/255, 202/255>;
#declare CN_Ethereal_Mood = rgb <204/255, 231/255, 235/255>;
#declare CN_Ethereal_White = rgb <230/255, 241/255, 241/255>;
#declare CN_Etherium_Blue = rgb <185/255, 196/255, 222/255>;
#declare CN_Ethiopia = rgb <150/255, 135/255, 119/255>;
#declare CN_Ethiopian_Wolf = rgb <152/255, 86/255, 41/255>;
#declare CN_Etiquette = rgb <226/255, 208/255, 214/255>;
#declare CN_Eton_Blue = rgb <150/255, 200/255, 162/255>;
#declare CN_Etruscan_Red = rgb <162/255, 87/255, 75/255>;
#declare CN_Etude_Lilac = rgb <213/255, 210/255, 215/255>;
#declare CN_Eucalipto = rgb <75/255, 195/255, 168/255>;
#declare CN_Eucalyptus = rgb <50/255, 151/255, 96/255>;
#declare CN_Eucalyptus_Green = rgb <30/255, 103/255, 90/255>;
#declare CN_Eucalyptus_Leaf = rgb <186/255, 210/255, 184/255>;
#declare CN_Eucalyptus_Wreath = rgb <136/255, 146/255, 126/255>;
#declare CN_Eugenia = rgb <242/255, 232/255, 212/255>;
#declare CN_Eunry = rgb <205/255, 165/255, 156/255>;
#declare CN_Euphoria = rgb <238/255, 187/255, 255/255>;
#declare CN_Euphoric_Lilac = rgb <218/255, 199/255, 218/255>;
#declare CN_Euphoric_Magenta = rgb <127/255, 87/255, 109/255>;
#declare CN_Euro_Linen = rgb <242/255, 232/255, 219/255>;
#declare CN_Eurolinen = rgb <238/255, 226/255, 211/255>;
#declare CN_Europe_Blue = rgb <0/255, 103/255, 150/255>;
#declare CN_European_Pine = rgb <117/255, 101/255, 86/255>;
#declare CN_Eva_Green = rgb <54/255, 255/255, 154/255>;
#declare CN_Evaporation = rgb <209/255, 213/255, 211/255>;
#declare CN_Even_Evan = rgb <153/255, 131/255, 113/255>;
#declare CN_Even_Growth = rgb <178/255, 170/255, 122/255>;
#declare CN_Evening_Blue = rgb <42/255, 41/255, 62/255>;
#declare CN_Evening_Blush = rgb <196/255, 144/255, 135/255>;
#declare CN_Evening_Canyon = rgb <69/255, 67/255, 65/255>;
#declare CN_Evening_Cityscape = rgb <75/255, 83/255, 92/255>;
#declare CN_Evening_Crimson = rgb <142/255, 107/255, 118/255>;
#declare CN_Evening_Dove = rgb <194/255, 190/255, 173/255>;
#declare CN_Evening_Dress = rgb <209/255, 161/255, 155/255>;
#declare CN_Evening_East = rgb <88/255, 94/255, 106/255>;
#declare CN_Evening_Emerald = rgb <86/255, 115/255, 111/255>;
#declare CN_Evening_Fizz = rgb <77/255, 73/255, 112/255>;
#declare CN_Evening_Fog = rgb <140/255, 153/255, 151/255>;
#declare CN_Evening_Glory = rgb <58/255, 74/255, 98/255>;
#declare CN_Evening_Glow = rgb <253/255, 215/255, 146/255>;
#declare CN_Evening_Green = rgb <124/255, 122/255, 58/255>;
#declare CN_Evening_Haze = rgb <189/255, 184/255, 199/255>;
#declare CN_Evening_Hush = rgb <123/255, 140/255, 168/255>;
#declare CN_Evening_in_Paris = rgb <147/255, 143/255, 159/255>;
#declare CN_Evening_Lagoon = rgb <88/255, 104/255, 174/255>;
#declare CN_Evening_Lavender = rgb <77/255, 68/255, 105/255>;
#declare CN_Evening_Mauve = rgb <70/255, 63/255, 103/255>;
#declare CN_Evening_Mist = rgb <227/255, 233/255, 232/255>;
#declare CN_Evening_Pink = rgb <167/255, 135/255, 154/255>;
#declare CN_Evening_Primrose = rgb <204/255, 219/255, 30/255>;
#declare CN_Evening_Sand = rgb <221/255, 182/255, 171/255>;
#declare CN_Evening_Sea = rgb <38/255, 96/255, 79/255>;
#declare CN_Evening_Shadow = rgb <161/255, 131/255, 139/255>;
#declare CN_Evening_Slipper = rgb <169/255, 158/255, 193/255>;
#declare CN_Evening_Star = rgb <255/255, 209/255, 96/255>;
#declare CN_Evening_Storm = rgb <70/255, 80/255, 88/255>;
#declare CN_Evening_Sunset = rgb <237/255, 176/255, 109/255>;
#declare CN_Evening_Symphony = rgb <81/255, 99/255, 123/255>;
#declare CN_Evening_White = rgb <216/255, 219/255, 215/255>;
#declare CN_Eventide = rgb <101/255, 100/255, 112/255>;
#declare CN_Everblooming = rgb <240/255, 200/255, 182/255>;
#declare CN_Everest = rgb <160/255, 227/255, 224/255>;
#declare CN_Everglade = rgb <38/255, 67/255, 52/255>;
#declare CN_Everglade_Mist = rgb <183/255, 215/255, 222/255>;
#declare CN_Evergreen = rgb <17/255, 87/255, 74/255>;
#declare CN_Evergreen_Bough = rgb <83/255, 92/255, 85/255>;
#declare CN_Evergreen_Boughs = rgb <80/255, 89/255, 79/255>;
#declare CN_Evergreen_Field = rgb <71/255, 83/255, 79/255>;
#declare CN_Evergreen_Fog = rgb <149/255, 151/255, 138/255>;
#declare CN_Evergreen_Forest = rgb <14/255, 105/255, 95/255>;
#declare CN_Evergreen_Trail = rgb <111/255, 117/255, 104/255>;
#declare CN_Evergreens = rgb <64/255, 88/255, 64/255>;
#declare CN_Everlasting = rgb <161/255, 190/255, 217/255>;
#declare CN_Everlasting_Ice = rgb <246/255, 253/255, 250/255>;
#declare CN_Everlasting_Sage = rgb <148/255, 149/255, 135/255>;
#declare CN_Evermore = rgb <70/255, 62/255, 59/255>;
#declare CN_Eversong_Orange = rgb <255/255, 166/255, 45/255>;
#declare CN_Everyday_White = rgb <228/255, 220/255, 212/255>;
#declare CN_Everythings_Rosy = rgb <216/255, 172/255, 160/255>;
#declare CN_Evil_Centipede = rgb <170/255, 34/255, 17/255>;
#declare CN_Evil_Eye = rgb <17/255, 0/255, 204/255>;
#declare CN_Evil_Forces = rgb <119/255, 0/255, 34/255>;
#declare CN_Evil_Sunz_Scarlet = rgb <194/255, 25/255, 31/255>;
#declare CN_Evil_Lyn = rgb <254/255, 217/255, 3/255>;
#declare CN_Evolution = rgb <112/255, 74/255, 61/255>;
#declare CN_Evora = rgb <83/255, 139/255, 137/255>;
#declare CN_Ewa = rgb <69/255, 64/255, 66/255>;
#declare CN_Exaggerated_Blush = rgb <181/255, 80/255, 103/255>;
#declare CN_Excalibur = rgb <103/255, 97/255, 104/255>;
#declare CN_Excelsior = rgb <144/255, 139/255, 133/255>;
#declare CN_Exciting_Orange = rgb <240/255, 176/255, 122/255>;
#declare CN_Exclusive_Elixir = rgb <249/255, 241/255, 221/255>;
#declare CN_Exclusive_Green = rgb <56/255, 73/255, 62/255>;
#declare CN_Exclusive_Ivory = rgb <226/255, 216/255, 195/255>;
#declare CN_Exclusive_Plum = rgb <115/255, 111/255, 120/255>;
#declare CN_Exclusive_Violet = rgb <185/255, 173/255, 187/255>;
#declare CN_Exclusively = rgb <107/255, 81/255, 95/255>;
#declare CN_Exclusively_Yours = rgb <242/255, 174/255, 184/255>;
#declare CN_Executive_Course = rgb <143/255, 138/255, 112/255>;
#declare CN_Existential_Angst = rgb <10/255, 10/255, 10/255>;
#declare CN_Exit_Light = rgb <85/255, 187/255, 51/255>;
#declare CN_Exodus_Fruit = rgb <98/255, 100/255, 220/255>;
#declare CN_Exotic_Bloom = rgb <172/255, 98/255, 146/255>;
#declare CN_Exotic_Blossom = rgb <253/255, 157/255, 67/255>;
#declare CN_Exotic_Eggplant = rgb <112/255, 86/255, 96/255>;
#declare CN_Exotic_Escape = rgb <150/255, 217/255, 223/255>;
#declare CN_Exotic_Evening = rgb <88/255, 81/255, 110/255>;
#declare CN_Exotic_Flower = rgb <255/255, 162/255, 76/255>;
#declare CN_Exotic_Flowers = rgb <131/255, 63/255, 81/255>;
#declare CN_Exotic_Honey = rgb <196/255, 127/255, 51/255>;
#declare CN_Exotic_Incense = rgb <184/255, 111/255, 115/255>;
#declare CN_Exotic_Life = rgb <174/255, 117/255, 67/255>;
#declare CN_Exotic_Lilac = rgb <209/255, 152/255, 181/255>;
#declare CN_Exotic_Liras = rgb <222/255, 12/255, 98/255>;
#declare CN_Exotic_Orange = rgb <249/255, 101/255, 49/255>;
#declare CN_Exotic_Orchid = rgb <117/255, 86/255, 108/255>;
#declare CN_Exotic_Palm = rgb <144/255, 153/255, 105/255>;
#declare CN_Exotic_Purple = rgb <106/255, 80/255, 120/255>;
#declare CN_Exotic_Violet = rgb <225/255, 160/255, 207/255>;
#declare CN_Exotica = rgb <147/255, 133/255, 134/255>;
#declare CN_Expanse = rgb <119/255, 126/255, 101/255>;
#declare CN_Expedition_Khaki = rgb <219/255, 191/255, 144/255>;
#declare CN_Experience = rgb <100/255, 172/255, 181/255>;
#declare CN_Exploding_Star = rgb <254/255, 216/255, 58/255>;
#declare CN_Exploration_Green = rgb <85/255, 168/255, 96/255>;
#declare CN_Explore_Blue = rgb <48/255, 170/255, 188/255>;
#declare CN_Explorer_Blue = rgb <87/255, 163/255, 179/255>;
#declare CN_Explorer_Khaki = rgb <182/255, 172/255, 149/255>;
#declare CN_Exploring_Khaki = rgb <170/255, 154/255, 121/255>;
#declare CN_Explosive_Purple = rgb <204/255, 17/255, 187/255>;
#declare CN_Express_Blue = rgb <57/255, 90/255, 115/255>;
#declare CN_Expressionism = rgb <57/255, 73/255, 123/255>;
#declare CN_Expressionism_Green = rgb <82/255, 188/255, 154/255>;
#declare CN_Expressive_Plum = rgb <105/255, 92/255, 98/255>;
#declare CN_Exquisite = rgb <200/255, 163/255, 187/255>;
#declare CN_Exquisite_Eggplant = rgb <51/255, 0/255, 51/255>;
#declare CN_Exquisite_Emerald = rgb <51/255, 136/255, 96/255>;
#declare CN_Exquisite_Turquoise = rgb <17/255, 204/255, 187/255>;
#declare CN_Extinct = rgb <148/255, 144/255, 178/255>;
#declare CN_Extinct_Volcano = rgb <74/255, 79/255, 90/255>;
#declare CN_Extra_Life = rgb <106/255, 180/255, 23/255>;
#declare CN_Extra_Mile = rgb <145/255, 145/255, 109/255>;
#declare CN_Extra_White = rgb <238/255, 239/255, 234/255>;
#declare CN_Extraordinaire = rgb <189/255, 166/255, 197/255>;
#declare CN_Extravagance = rgb <78/255, 72/255, 80/255>;
#declare CN_Extravehicular_Activity = rgb <0/255, 17/255, 170/255>;
#declare CN_Extraviolet = rgb <102/255, 17/255, 136/255>;
#declare CN_Extreme = rgb <83/255, 96/255, 120/255>;
#declare CN_Extreme_Lavender = rgb <223/255, 197/255, 213/255>;
#declare CN_Extreme_Yellow = rgb <255/255, 183/255, 41/255>;
#declare CN_Exuberance = rgb <232/255, 104/255, 0/255>;
#declare CN_Exuberant_Orange = rgb <240/255, 98/255, 47/255>;
#declare CN_Exuberant_Pink = rgb <181/255, 77/255, 127/255>;
#declare CN_Eye_Blue = rgb <30/255, 128/255, 199/255>;
#declare CN_Eye_Catching = rgb <221/255, 184/255, 53/255>;
#declare CN_Eye_Grey = rgb <96/255, 123/255, 123/255>;
#declare CN_Eye_Of_Newt = rgb <174/255, 61/255, 59/255>;
#declare CN_Eye_of_the_Storm = rgb <217/255, 227/255, 217/255>;
#declare CN_Eye_Patch = rgb <35/255, 33/255, 33/255>;
#declare CN_Eye_Popping_Cherry = rgb <187/255, 0/255, 119/255>;
#declare CN_Eyeball = rgb <255/255, 251/255, 248/255>;
#declare CN_Eyefull = rgb <141/255, 182/255, 183/255>;
#declare CN_Eyelash_Camel = rgb <85/255, 51/255, 0/255>;
#declare CN_Eyelash_Viper = rgb <244/255, 197/255, 75/255>;
#declare CN_Eyelids = rgb <68/255, 0/255, 0/255>;
#declare CN_Eyeshadow = rgb <217/255, 217/255, 234/255>;
#declare CN_Eyeshadow_Blue = rgb <107/255, 148/255, 197/255>;
#declare CN_Eyeshadow_Turquoise = rgb <0/255, 137/255, 128/255>;
#declare CN_Eyeshadow_Viola = rgb <173/255, 166/255, 194/255>;
#declare CN_Eyre = rgb <143/255, 148/255, 130/255>;
#declare CN_Fabric_of_Space = rgb <52/255, 23/255, 88/255>;
#declare CN_Fabulous_Fantasy = rgb <186/255, 144/255, 173/255>;
#declare CN_Fabulous_Fawn = rgb <229/255, 193/255, 163/255>;
#declare CN_Fabulous_Find = rgb <171/255, 227/255, 201/255>;
#declare CN_Fabulous_Forties = rgb <221/255, 205/255, 171/255>;
#declare CN_Fabulous_Frog = rgb <136/255, 204/255, 0/255>;
#declare CN_Fabulous_Fuchsia = rgb <238/255, 17/255, 136/255>;
#declare CN_Fabulous_Grape = rgb <144/255, 131/255, 165/255>;
#declare CN_Facemark = rgb <247/255, 207/255, 137/255>;
#declare CN_Fade_to_Black = rgb <103/255, 105/255, 101/255>;
#declare CN_Faded_Blue = rgb <101/255, 140/255, 187/255>;
#declare CN_Faded_Denim = rgb <121/255, 142/255, 164/255>;
#declare CN_Faded_Firebrick = rgb <229/255, 217/255, 220/255>;
#declare CN_Faded_Flaxflower = rgb <158/255, 180/255, 192/255>;
#declare CN_Faded_Forest = rgb <227/255, 226/255, 215/255>;
#declare CN_Faded_Fuchsia = rgb <237/255, 226/255, 238/255>;
#declare CN_Faded_Green = rgb <123/255, 178/255, 116/255>;
#declare CN_Faded_Grey = rgb <234/255, 232/255, 228/255>;
#declare CN_Faded_Jade = rgb <66/255, 121/255, 119/255>;
#declare CN_Faded_Jeans = rgb <93/255, 189/255, 203/255>;
#declare CN_Faded_Khaki = rgb <165/255, 151/255, 91/255>;
#declare CN_Faded_Light = rgb <245/255, 228/255, 222/255>;
#declare CN_Faded_Orange = rgb <240/255, 148/255, 77/255>;
#declare CN_Faded_Pink = rgb <222/255, 157/255, 172/255>;
#declare CN_Faded_Poster = rgb <128/255, 219/255, 235/255>;
#declare CN_Faded_Purple = rgb <145/255, 110/255, 153/255>;
#declare CN_Faded_Red = rgb <211/255, 73/255, 78/255>;
#declare CN_Faded_Rose = rgb <191/255, 100/255, 100/255>;
#declare CN_Faded_Sea = rgb <141/255, 156/255, 174/255>;
#declare CN_Faded_Shells = rgb <235/255, 220/255, 215/255>;
#declare CN_Faded_Violet = rgb <221/255, 190/255, 221/255>;
#declare CN_Faded_Yellow = rgb <254/255, 255/255, 127/255>;
#declare CN_Fading_Ember = rgb <223/255, 105/255, 30/255>;
#declare CN_Fading_Fog = rgb <232/255, 228/255, 224/255>;
#declare CN_Fading_Horizon = rgb <68/255, 34/255, 102/255>;
#declare CN_Fading_Love = rgb <201/255, 115/255, 162/255>;
#declare CN_Fading_Night = rgb <51/255, 119/255, 204/255>;
#declare CN_Fading_Parchment = rgb <236/255, 230/255, 220/255>;
#declare CN_Fading_Rose = rgb <250/255, 208/255, 209/255>;
#declare CN_Fading_Sunset = rgb <179/255, 179/255, 194/255>;
#declare CN_Fahrenheit = rgb <251/255, 210/255, 187/255>;
#declare CN_Faience = rgb <42/255, 106/255, 139/255>;
#declare CN_Faience_Green = rgb <129/255, 118/255, 43/255>;
#declare CN_Fail_Whale = rgb <153/255, 204/255, 238/255>;
#declare CN_Faint_Clover = rgb <178/255, 238/255, 211/255>;
#declare CN_Faint_Coral = rgb <238/255, 222/255, 213/255>;
#declare CN_Faint_Fawn = rgb <226/255, 197/255, 156/255>;
#declare CN_Faint_Fern = rgb <218/255, 219/255, 224/255>;
#declare CN_Faint_Fuchsia = rgb <230/255, 222/255, 234/255>;
#declare CN_Faint_Gold = rgb <181/255, 148/255, 16/255>;
#declare CN_Faint_Green = rgb <165/255, 139/255, 44/255>;
#declare CN_Faint_Peach = rgb <245/255, 221/255, 197/255>;
#declare CN_Fainting_Light = rgb <31/255, 40/255, 71/255>;
#declare CN_Fair_Aqua = rgb <184/255, 226/255, 220/255>;
#declare CN_Fair_Green = rgb <146/255, 175/255, 136/255>;
#declare CN_Fair_Ivory = rgb <252/255, 231/255, 207/255>;
#declare CN_Fair_Maiden = rgb <241/255, 231/255, 220/255>;
#declare CN_Fair_Orchid = rgb <192/255, 170/255, 192/255>;
#declare CN_Fair_Pink = rgb <243/255, 229/255, 220/255>;
#declare CN_Fair_Spring = rgb <147/255, 151/255, 127/255>;
#declare CN_Fair_Winds = rgb <243/255, 230/255, 214/255>;
#declare CN_Fairbank_Green = rgb <157/255, 156/255, 126/255>;
#declare CN_Fairest_Jade = rgb <216/255, 227/255, 215/255>;
#declare CN_Fairfax_Brown = rgb <97/255, 70/255, 58/255>;
#declare CN_Fairstar = rgb <107/255, 165/255, 169/255>;
#declare CN_Fairview_Taupe = rgb <218/255, 199/255, 196/255>;
#declare CN_Fairway = rgb <71/255, 112/255, 80/255>;
#declare CN_Fairway_Green = rgb <38/255, 98/255, 63/255>;
#declare CN_Fairway_Mist = rgb <205/255, 232/255, 182/255>;
#declare CN_Fairy_Dust = rgb <255/255, 232/255, 244/255>;
#declare CN_Fairy_Pink = rgb <238/255, 211/255, 203/255>;
#declare CN_Fairy_Princess = rgb <246/255, 219/255, 221/255>;
#declare CN_Fairy_Sparkles = rgb <176/255, 224/255, 247/255>;
#declare CN_Fairy_Tail = rgb <236/255, 221/255, 229/255>;
#declare CN_Fairy_Tale = rgb <242/255, 193/255, 209/255>;
#declare CN_Fairy_Wand = rgb <174/255, 164/255, 193/255>;
#declare CN_Fairy_White = rgb <222/255, 212/255, 216/255>;
#declare CN_Fairy_Wings = rgb <255/255, 235/255, 242/255>;
#declare CN_Fairy_Wren = rgb <148/255, 121/255, 175/255>;
#declare CN_Fairy_Nuff = rgb <226/255, 215/255, 218/255>;
#declare CN_Fairytale = rgb <229/255, 219/255, 235/255>;
#declare CN_Fairytale_Blue = rgb <62/255, 154/255, 189/255>;
#declare CN_Fairytale_Dream = rgb <250/255, 207/255, 204/255>;
#declare CN_Faith = rgb <213/255, 235/255, 172/255>;
#declare CN_Fake_Jade = rgb <19/255, 234/255, 201/255>;
#declare CN_Fake_Love = rgb <204/255, 119/255, 238/255>;
#declare CN_Falafel = rgb <170/255, 119/255, 17/255>;
#declare CN_Falcon = rgb <110/255, 90/255, 91/255>;
#declare CN_Falcon_Grey = rgb <137/255, 136/255, 135/255>;
#declare CN_Falcon_Turquoise = rgb <0/255, 112/255, 98/255>;
#declare CN_Fall_Canyon = rgb <198/255, 152/255, 150/255>;
#declare CN_Fall_Chill = rgb <225/255, 221/255, 219/255>;
#declare CN_Fall_Foliage = rgb <194/255, 131/255, 89/255>;
#declare CN_Fall_Gold = rgb <255/255, 188/255, 53/255>;
#declare CN_Fall_Green = rgb <236/255, 252/255, 189/255>;
#declare CN_Fall_Harvest = rgb <167/255, 138/255, 89/255>;
#declare CN_Fall_Heliotrope = rgb <164/255, 148/255, 145/255>;
#declare CN_Fall_in_Season = rgb <127/255, 97/255, 68/255>;
#declare CN_Fall_Leaf = rgb <229/255, 183/255, 165/255>;
#declare CN_Fall_Leaves = rgb <193/255, 122/255, 60/255>;
#declare CN_Fall_Mood = rgb <194/255, 172/255, 155/255>;
#declare CN_Fall_Straw = rgb <254/255, 227/255, 197/255>;
#declare CN_Fallen_Leaves = rgb <145/255, 115/255, 71/255>;
#declare CN_Fallen_Rock = rgb <128/255, 118/255, 105/255>;
#declare CN_Falling_Leaves = rgb <165/255, 90/255, 59/255>;
#declare CN_Falling_Snow = rgb <240/255, 241/255, 231/255>;
#declare CN_Falling_Star = rgb <202/255, 213/255, 200/255>;
#declare CN_Falling_Tears = rgb <194/255, 215/255, 223/255>;
#declare CN_Fallout_Green = rgb <182/255, 193/255, 33/255>;
#declare CN_Fallow = rgb <193/255, 154/255, 81/255>;
#declare CN_Fallow_Deer = rgb <159/255, 141/255, 87/255>;
#declare CN_False_Cypress = rgb <147/255, 155/255, 136/255>;
#declare CN_False_Morel = rgb <120/255, 77/255, 76/255>;
#declare CN_False_Puce = rgb <165/255, 126/255, 82/255>;
#declare CN_Falu_Red = rgb <128/255, 24/255, 24/255>;
#declare CN_Fame_Orange = rgb <219/255, 156/255, 123/255>;
#declare CN_Familiar_Beige = rgb <202/255, 179/255, 160/255>;
#declare CN_Family_Tree = rgb <167/255, 177/255, 145/255>;
#declare CN_Fanatic_Fuchsia = rgb <238/255, 17/255, 153/255>;
#declare CN_Fancy_Flamingo = rgb <255/255, 177/255, 176/255>;
#declare CN_Fancy_Flirt = rgb <180/255, 183/255, 128/255>;
#declare CN_Fancy_Fuchsia = rgb <255/255, 0/255, 136/255>;
#declare CN_Fancy_Pants = rgb <243/255, 218/255, 225/255>;
#declare CN_Fancy_Pink = rgb <246/255, 233/255, 232/255>;
#declare CN_Fandangle = rgb <228/255, 222/255, 101/255>;
#declare CN_Fandango = rgb <181/255, 51/255, 137/255>;
#declare CN_Fandango_Pink = rgb <224/255, 79/255, 128/255>;
#declare CN_Fanfare = rgb <0/255, 109/255, 112/255>;
#declare CN_Fangtooth_Fish = rgb <187/255, 170/255, 151/255>;
#declare CN_Fanlight = rgb <242/255, 238/255, 175/255>;
#declare CN_Fantan = rgb <159/255, 126/255, 83/255>;
#declare CN_Fantasia = rgb <115/255, 120/255, 139/255>;
#declare CN_Fantastic_Pink = rgb <230/255, 200/255, 201/255>;
#declare CN_Fantasy = rgb <242/255, 230/255, 221/255>;
#declare CN_Fantasy_Console_Sky = rgb <41/255, 173/255, 255/255>;
#declare CN_Fantasy_Grey = rgb <133/255, 145/255, 162/255>;
#declare CN_Far_Away_Grey = rgb <45/255, 56/255, 58/255>;
#declare CN_Faraway_Blue = rgb <229/255, 238/255, 238/255>;
#declare CN_Faraway_Sky = rgb <137/255, 128/255, 193/255>;
#declare CN_Farfalle_Noodle = rgb <229/255, 212/255, 201/255>;
#declare CN_Farm_Fresh = rgb <142/255, 155/255, 136/255>;
#declare CN_Farm_House = rgb <239/255, 232/255, 215/255>;
#declare CN_Farm_Straw = rgb <213/255, 181/255, 76/255>;
#declare CN_Farmers_Market = rgb <143/255, 145/255, 124/255>;
#declare CN_Farmers_Green = rgb <150/255, 166/255, 159/255>;
#declare CN_Farmers_Milk = rgb <238/255, 227/255, 214/255>;
#declare CN_Farmhouse_Ochre = rgb <189/255, 131/255, 57/255>;
#declare CN_Farmhouse_Red = rgb <163/255, 75/255, 65/255>;
#declare CN_Farmyard = rgb <166/255, 145/255, 125/255>;
#declare CN_Farrago = rgb <69/255, 111/255, 110/255>;
#declare CN_Farro = rgb <193/255, 164/255, 133/255>;
#declare CN_Farsighted = rgb <229/255, 227/255, 239/255>;
#declare CN_Fashion_Blue = rgb <0/255, 107/255, 100/255>;
#declare CN_Fashion_Fuchsia = rgb <244/255, 0/255, 161/255>;
#declare CN_Fashion_Green = rgb <179/255, 210/255, 109/255>;
#declare CN_Fashion_Grey = rgb <162/255, 156/255, 148/255>;
#declare CN_Fashion_Mauve = rgb <181/255, 168/255, 168/255>;
#declare CN_Fashion_Week = rgb <153/255, 137/255, 136/255>;
#declare CN_Fashion_Yellow = rgb <237/255, 197/255, 55/255>;
#declare CN_Fashionable_Gray = rgb <189/255, 184/255, 184/255>;
#declare CN_Fashionably_Plum = rgb <178/255, 140/255, 169/255>;
#declare CN_Fashionista = rgb <102/255, 97/255, 111/255>;
#declare CN_Fast_as_the_Wind = rgb <199/255, 203/255, 200/255>;
#declare CN_Fast_Velvet = rgb <139/255, 148/255, 199/255>;
#declare CN_Fat_Tuesday = rgb <53/255, 34/255, 53/255>;
#declare CN_Fatal_Fields = rgb <0/255, 136/255, 34/255>;
#declare CN_Fatback = rgb <255/255, 247/255, 237/255>;
#declare CN_Fate = rgb <107/255, 160/255, 191/255>;
#declare CN_Fatty_Fuchsia = rgb <238/255, 0/255, 119/255>;
#declare CN_Favored_One = rgb <250/255, 230/255, 204/255>;
#declare CN_Favorite_Fudge = rgb <135/255, 114/255, 82/255>;
#declare CN_Favorite_Jeans = rgb <138/255, 163/255, 177/255>;
#declare CN_Favorite_Lavender = rgb <211/255, 165/255, 214/255>;
#declare CN_Favorite_Tan = rgb <193/255, 174/255, 145/255>;
#declare CN_Favourite_Lady = rgb <227/255, 197/255, 214/255>;
#declare CN_Fawn = rgb <207/255, 175/255, 123/255>;
#declare CN_Fawn_Brindle = rgb <167/255, 160/255, 148/255>;
#declare CN_Fawn_Brown = rgb <113/255, 69/255, 42/255>;
#declare CN_Feasty_Fuchsia = rgb <238/255, 0/255, 136/255>;
#declare CN_Feather_Boa = rgb <241/255, 201/255, 205/255>;
#declare CN_Feather_Falls = rgb <96/255, 105/255, 114/255>;
#declare CN_Feather_Fern = rgb <213/255, 220/255, 208/255>;
#declare CN_Feather_Gold = rgb <237/255, 211/255, 130/255>;
#declare CN_Feather_Green = rgb <163/255, 208/255, 182/255>;
#declare CN_Feather_Grey = rgb <184/255, 173/255, 158/255>;
#declare CN_Feather_Plume = rgb <255/255, 220/255, 178/255>;
#declare CN_Feather_Soft_Blue = rgb <162/255, 174/255, 191/255>;
#declare CN_Feather_Stone = rgb <227/255, 222/255, 210/255>;
#declare CN_Feather_White = rgb <231/255, 234/255, 229/255>;
#declare CN_Featherbed = rgb <175/255, 203/255, 229/255>;
#declare CN_Featherstone = rgb <205/255, 199/255, 187/255>;
#declare CN_Feathery_Blue = rgb <171/255, 194/255, 199/255>;
#declare CN_Feathery_Lilac = rgb <236/255, 231/255, 237/255>;
#declare CN_February_Frost = rgb <224/255, 222/255, 227/255>;
#declare CN_Federal_Blue = rgb <67/255, 98/255, 139/255>;
#declare CN_Federal_Fund = rgb <48/255, 89/255, 75/255>;
#declare CN_Federation_Brown = rgb <99/255, 64/255, 65/255>;
#declare CN_Fedora = rgb <98/255, 86/255, 101/255>;
#declare CN_Fei_Hong_Scarlet = rgb <254/255, 66/255, 15/255>;
#declare CN_Feijoa = rgb <165/255, 215/255, 133/255>;
#declare CN_Feijoa_Flower = rgb <237/255, 242/255, 195/255>;
#declare CN_Feldgrau = rgb <77/255, 93/255, 83/255>;
#declare CN_Feldspar = rgb <209/255, 146/255, 117/255>;
#declare CN_Feldspar_Grey = rgb <188/255, 168/255, 133/255>;
#declare CN_Feldspar_Silver = rgb <160/255, 173/255, 169/255>;
#declare CN_Felicia = rgb <145/255, 114/255, 146/255>;
#declare CN_Felicity = rgb <229/255, 228/255, 223/255>;
#declare CN_Felix = rgb <0/255, 96/255, 143/255>;
#declare CN_Felt = rgb <36/255, 115/255, 69/255>;
#declare CN_Felt_Green = rgb <111/255, 195/255, 145/255>;
#declare CN_Felted_Wool = rgb <151/255, 144/255, 131/255>;
#declare CN_Felwood_Leaves = rgb <43/255, 197/255, 27/255>;
#declare CN_Feminin_Nightshade = rgb <79/255, 67/255, 82/255>;
#declare CN_Feminine_Fancy = rgb <196/255, 168/255, 207/255>;
#declare CN_Femininity = rgb <199/255, 194/255, 206/255>;
#declare CN_Feminism = rgb <157/255, 87/255, 131/255>;
#declare CN_Femme_Fatale = rgb <148/255, 133/255, 147/255>;
#declare CN_Fen_Hong_Pink = rgb <255/255, 108/255, 181/255>;
#declare CN_Fence_Green = rgb <9/255, 51/255, 44/255>;
#declare CN_Feng_Shui = rgb <215/255, 217/255, 194/255>;
#declare CN_Fenland = rgb <172/255, 157/255, 131/255>;
#declare CN_Fennec_Fox = rgb <218/255, 215/255, 200/255>;
#declare CN_Fennel_Bulb = rgb <221/255, 238/255, 187/255>;
#declare CN_Fennel_Flower = rgb <119/255, 170/255, 255/255>;
#declare CN_Fennel_Seed = rgb <153/255, 132/255, 86/255>;
#declare CN_Fennel_Stem = rgb <177/255, 182/255, 163/255>;
#declare CN_Fennel_Tea = rgb <210/255, 244/255, 221/255>;
#declare CN_Fennelly = rgb <154/255, 158/255, 128/255>;
#declare CN_Fenrisian_Grey = rgb <206/255, 222/255, 231/255>;
#declare CN_Fenugreek = rgb <192/255, 145/255, 108/255>;
#declare CN_Feralas_Lime = rgb <141/255, 224/255, 124/255>;
#declare CN_Fern = rgb <84/255, 141/255, 68/255>;
#declare CN_Fern_Canopy = rgb <117/255, 138/255, 95/255>;
#declare CN_Fern_Flower = rgb <87/255, 106/255, 125/255>;
#declare CN_Fern_Frond = rgb <101/255, 114/255, 32/255>;
#declare CN_Fern_Green = rgb <0/255, 140/255, 69/255>;
#declare CN_Fern_Grove = rgb <131/255, 123/255, 83/255>;
#declare CN_Fern_Gully = rgb <89/255, 86/255, 70/255>;
#declare CN_Fern_Leaf = rgb <153/255, 167/255, 135/255>;
#declare CN_Fern_Shade = rgb <121/255, 116/255, 71/255>;
#declare CN_Ferocious_Flamingo = rgb <238/255, 0/255, 204/255>;
#declare CN_Ferocious_Fuchsia = rgb <170/255, 0/255, 204/255>;
#declare CN_Ferra = rgb <135/255, 106/255, 104/255>;
#declare CN_Ferrari_Red = rgb <255/255, 40/255, 0/255>;
#declare CN_Ferris_Wheel = rgb <173/255, 125/255, 118/255>;
#declare CN_Ferrous = rgb <204/255, 146/255, 108/255>;
#declare CN_Ferry = rgb <56/255, 62/255, 68/255>;
#declare CN_Fertile_Green = rgb <139/255, 135/255, 87/255>;
#declare CN_Fertility_Green = rgb <102/255, 252/255, 0/255>;
#declare CN_Fervent_Brass = rgb <188/255, 144/255, 66/255>;
#declare CN_Fervent_Green = rgb <70/255, 159/255, 78/255>;
#declare CN_Festering_Brown = rgb <203/255, 142/255, 0/255>;
#declare CN_Festival = rgb <234/255, 204/255, 74/255>;
#declare CN_Festival_De_Verano = rgb <181/255, 225/255, 219/255>;
#declare CN_Festival_Fuchsia = rgb <158/255, 44/255, 106/255>;
#declare CN_Festival_Green = rgb <110/255, 164/255, 60/255>;
#declare CN_Festive_Fennec = rgb <255/255, 85/255, 102/255>;
#declare CN_Festive_Ferret = rgb <223/255, 223/255, 229/255>;
#declare CN_Festive_Green = rgb <0/255, 140/255, 108/255>;
#declare CN_Festoon_Aqua = rgb <160/255, 187/255, 184/255>;
#declare CN_Feta = rgb <219/255, 224/255, 208/255>;
#declare CN_Feverish = rgb <221/255, 102/255, 119/255>;
#declare CN_Feverish_Pink = rgb <203/255, 62/255, 80/255>;
#declare CN_Fibre_Moss = rgb <190/255, 192/255, 175/255>;
#declare CN_Ficus = rgb <59/255, 89/255, 58/255>;
#declare CN_Ficus_Elastica = rgb <0/255, 97/255, 49/255>;
#declare CN_Fiddle_Leaf = rgb <95/255, 103/255, 75/255>;
#declare CN_Fiddle_Leaf_Fig = rgb <166/255, 200/255, 117/255>;
#declare CN_Fiddlehead_Fern = rgb <200/255, 195/255, 135/255>;
#declare CN_Fiddler = rgb <90/255, 149/255, 137/255>;
#declare CN_Fiddlesticks = rgb <187/255, 159/255, 177/255>;
#declare CN_Field_Blue = rgb <68/255, 119/255, 170/255>;
#declare CN_Field_Day = rgb <197/255, 230/255, 164/255>;
#declare CN_Field_Drab = rgb <108/255, 84/255, 30/255>;
#declare CN_Field_Green = rgb <96/255, 185/255, 34/255>;
#declare CN_Field_Khaki = rgb <177/255, 168/255, 145/255>;
#declare CN_Field_Maple = rgb <128/255, 136/255, 78/255>;
#declare CN_Field_of_Wheat = rgb <222/255, 182/255, 153/255>;
#declare CN_Field_Poppy = rgb <216/255, 111/255, 60/255>;
#declare CN_Fieldstone = rgb <128/255, 126/255, 119/255>;
#declare CN_Fierce_Mantis = rgb <127/255, 193/255, 92/255>;
#declare CN_Fiery_Brown = rgb <93/255, 56/255, 49/255>;
#declare CN_Fiery_Coral = rgb <226/255, 96/255, 88/255>;
#declare CN_Fiery_Flamingo = rgb <249/255, 109/255, 123/255>;
#declare CN_Fiery_Fuchsia = rgb <183/255, 56/255, 110/255>;
#declare CN_Fiery_Glow = rgb <240/255, 83/255, 28/255>;
#declare CN_Fiery_Orange = rgb <177/255, 89/255, 47/255>;
#declare CN_Fiery_Red = rgb <208/255, 28/255, 31/255>;
#declare CN_Fiery_Rose = rgb <255/255, 84/255, 112/255>;
#declare CN_Fiery_Salmon = rgb <247/255, 101/255, 100/255>;
#declare CN_Fiesta = rgb <237/255, 216/255, 210/255>;
#declare CN_Fiesta_Blue = rgb <111/255, 192/255, 177/255>;
#declare CN_Fiesta_Pink = rgb <212/255, 113/255, 148/255>;
#declare CN_Fiesta_Rojo = rgb <182/255, 124/255, 128/255>;
#declare CN_Fife = rgb <169/255, 165/255, 194/255>;
#declare CN_Fifth_Olive_Nue = rgb <142/255, 135/255, 121/255>;
#declare CN_Fig = rgb <83/255, 45/255, 59/255>;
#declare CN_Fig_Balsamic = rgb <85/255, 0/255, 34/255>;
#declare CN_Fig_Branches = rgb <122/255, 99/255, 77/255>;
#declare CN_Fig_Fruit_Mauve = rgb <169/255, 134/255, 145/255>;
#declare CN_Fig_Leaf = rgb <85/255, 107/255, 47/255>;
#declare CN_Fig_Mustard_Yellow = rgb <187/255, 134/255, 16/255>;
#declare CN_Fig_Preserves = rgb <167/255, 152/255, 158/255>;
#declare CN_Fig_Tree = rgb <96/255, 95/255, 75/255>;
#declare CN_Fight_the_Sunrise = rgb <255/255, 153/255, 170/255>;
#declare CN_Figue = rgb <148/255, 105/255, 162/255>;
#declare CN_Figue_Pulp = rgb <150/255, 44/255, 84/255>;
#declare CN_Figure_Stone = rgb <238/255, 218/255, 195/255>;
#declare CN_Figurine = rgb <228/255, 213/255, 192/255>;
#declare CN_Fiji = rgb <0/255, 170/255, 172/255>;
#declare CN_Fiji_Coral = rgb <107/255, 95/255, 104/255>;
#declare CN_Fiji_Green = rgb <99/255, 111/255, 34/255>;
#declare CN_Fiji_Palm = rgb <82/255, 141/255, 60/255>;
#declare CN_Fiji_Sands = rgb <216/255, 202/255, 169/255>;
#declare CN_Filigree = rgb <223/255, 231/255, 232/255>;
#declare CN_Filigree_Green = rgb <165/255, 175/255, 137/255>;
#declare CN_Film_Fest = rgb <147/255, 135/255, 124/255>;
#declare CN_Film_Noir = rgb <71/255, 57/255, 51/255>;
#declare CN_Filmy_Green = rgb <209/255, 211/255, 199/255>;
#declare CN_Filtered_Forest = rgb <183/255, 225/255, 210/255>;
#declare CN_Filtered_Light = rgb <177/255, 178/255, 196/255>;
#declare CN_Filtered_Moon = rgb <236/255, 202/255, 154/255>;
#declare CN_Filtered_Rays = rgb <208/255, 176/255, 100/255>;
#declare CN_Filthy_Brown = rgb <232/255, 170/255, 8/255>;
#declare CN_Final_Straw = rgb <208/255, 191/255, 158/255>;
#declare CN_Finch = rgb <117/255, 120/255, 90/255>;
#declare CN_Fine_Alabaster = rgb <236/255, 211/255, 203/255>;
#declare CN_Fine_Blue = rgb <182/255, 225/255, 225/255>;
#declare CN_Fine_Burgundy = rgb <129/255, 81/255, 88/255>;
#declare CN_Fine_Grain = rgb <216/255, 207/255, 193/255>;
#declare CN_Fine_Greige = rgb <181/255, 169/255, 152/255>;
#declare CN_Fine_Linen = rgb <250/255, 245/255, 195/255>;
#declare CN_Fine_Pine = rgb <0/255, 136/255, 0/255>;
#declare CN_Fine_Porcelain = rgb <250/255, 240/255, 225/255>;
#declare CN_Fine_Purple = rgb <94/255, 84/255, 141/255>;
#declare CN_Fine_Sand = rgb <241/255, 213/255, 174/255>;
#declare CN_Fine_White = rgb <250/255, 237/255, 225/255>;
#declare CN_Fine_White_Sand = rgb <228/255, 212/255, 192/255>;
#declare CN_Fine_Wine = rgb <116/255, 78/255, 91/255>;
#declare CN_Finesse = rgb <150/255, 168/255, 200/255>;
#declare CN_Finest_Blush = rgb <221/255, 136/255, 136/255>;
#declare CN_Finest_Silk = rgb <241/255, 229/255, 215/255>;
#declare CN_Finger_Banana = rgb <225/255, 193/255, 47/255>;
#declare CN_Fingerpaint = rgb <138/255, 126/255, 97/255>;
#declare CN_Fingerprint = rgb <85/255, 83/255, 86/255>;
#declare CN_Finishing_Touch = rgb <203/255, 191/255, 179/255>;
#declare CN_Finlandia = rgb <97/255, 117/255, 91/255>;
#declare CN_Finn = rgb <105/255, 69/255, 84/255>;
#declare CN_Finnish_Fiord = rgb <93/255, 176/255, 190/255>;
#declare CN_Fioletowy_Beige = rgb <255/255, 252/255, 227/255>;
#declare CN_Fioletowy_Purple = rgb <252/255, 68/255, 163/255>;
#declare CN_Fiord = rgb <75/255, 90/255, 98/255>;
#declare CN_Fiorito = rgb <191/255, 191/255, 175/255>;
#declare CN_Fir = rgb <58/255, 114/255, 95/255>;
#declare CN_Fir_Blue = rgb <70/255, 128/255, 123/255>;
#declare CN_Fir_Green = rgb <103/255, 89/255, 42/255>;
#declare CN_Fir_Spruce_Green = rgb <109/255, 121/255, 105/255>;
#declare CN_Fire = rgb <143/255, 63/255, 42/255>;
#declare CN_Fire_Ant = rgb <190/255, 100/255, 0/255>;
#declare CN_Fire_Axe_Red = rgb <206/255, 22/255, 32/255>;
#declare CN_Fire_Bolt = rgb <204/255, 68/255, 17/255>;
#declare CN_Fire_Bush = rgb <224/255, 152/255, 66/255>;
#declare CN_Fire_Chalk = rgb <210/255, 128/255, 108/255>;
#declare CN_Fire_Chi = rgb <146/255, 53/255, 58/255>;
#declare CN_Fire_Coral = rgb <227/255, 180/255, 111/255>;
#declare CN_Fire_Dance = rgb <227/255, 213/255, 144/255>;
#declare CN_Fire_Dragon_Bright = rgb <249/255, 115/255, 6/255>;
#declare CN_Fire_Dust = rgb <185/255, 141/255, 104/255>;
#declare CN_Fire_Engine = rgb <254/255, 0/255, 2/255>;
#declare CN_Fire_Flower = rgb <246/255, 143/255, 55/255>;
#declare CN_Fire_Hydrant = rgb <255/255, 13/255, 0/255>;
#declare CN_Fire_Island = rgb <217/255, 81/255, 55/255>;
#declare CN_Fire_Lord = rgb <187/255, 119/255, 51/255>;
#declare CN_Fire_Mist = rgb <251/255, 217/255, 196/255>;
#declare CN_Fire_Opal = rgb <253/255, 60/255, 6/255>;
#declare CN_Fire_Orange = rgb <255/255, 142/255, 87/255>;
#declare CN_Fire_Roasted = rgb <121/255, 72/255, 62/255>;
#declare CN_Fire_Yellow = rgb <255/255, 183/255, 11/255>;
#declare CN_Fireball = rgb <206/255, 32/255, 41/255>;
#declare CN_Firebird_Tail_Lights = rgb <221/255, 85/255, 34/255>;
#declare CN_Firebrick = rgb <178/255, 34/255, 34/255>;
#declare CN_Firebug = rgb <205/255, 92/255, 81/255>;
#declare CN_Firecracker = rgb <243/255, 105/255, 68/255>;
#declare CN_Firecracker_Salmon = rgb <243/255, 99/255, 99/255>;
#declare CN_Fired_Brick = rgb <106/255, 46/255, 42/255>;
#declare CN_Fired_Clay = rgb <136/255, 68/255, 68/255>;
#declare CN_Fired_Up = rgb <211/255, 122/255, 56/255>;
#declare CN_Fireflies = rgb <246/255, 218/255, 167/255>;
#declare CN_Firefly = rgb <49/255, 70/255, 67/255>;
#declare CN_Firefly_Glow = rgb <255/255, 243/255, 161/255>;
#declare CN_Fireglow = rgb <214/255, 94/255, 64/255>;
#declare CN_Firelight = rgb <249/255, 217/255, 123/255>;
#declare CN_Fireplace_Glow = rgb <208/255, 139/255, 115/255>;
#declare CN_Fireplace_Kitten = rgb <197/255, 201/255, 199/255>;
#declare CN_Fireplace_Mantel = rgb <132/255, 124/255, 112/255>;
#declare CN_Fireside = rgb <110/255, 74/255, 68/255>;
#declare CN_Firewatch = rgb <238/255, 136/255, 102/255>;
#declare CN_Fireweed = rgb <179/255, 132/255, 145/255>;
#declare CN_Fireworks = rgb <68/255, 54/255, 61/255>;
#declare CN_Firm_Green = rgb <71/255, 101/255, 74/255>;
#declare CN_Firm_Pink = rgb <218/255, 147/255, 193/255>;
#declare CN_Firmament_Blue = rgb <17/255, 53/255, 63/255>;
#declare CN_First_Blush = rgb <244/255, 237/255, 236/255>;
#declare CN_First_Colors_of_Spring = rgb <219/255, 230/255, 76/255>;
#declare CN_First_Crush = rgb <246/255, 226/255, 234/255>;
#declare CN_First_Date = rgb <245/255, 177/255, 162/255>;
#declare CN_First_Daughter = rgb <247/255, 210/255, 216/255>;
#declare CN_First_Day_of_School = rgb <250/255, 219/255, 160/255>;
#declare CN_First_Day_of_Summer = rgb <241/255, 231/255, 152/255>;
#declare CN_First_Frost = rgb <207/255, 229/255, 240/255>;
#declare CN_First_Impression = rgb <244/255, 229/255, 231/255>;
#declare CN_First_Lady = rgb <196/255, 121/255, 103/255>;
#declare CN_First_Landing = rgb <89/255, 166/255, 207/255>;
#declare CN_First_Light = rgb <217/255, 230/255, 238/255>;
#declare CN_First_Lilac = rgb <231/255, 214/255, 237/255>;
#declare CN_First_Love = rgb <207/255, 117/255, 138/255>;
#declare CN_First_of_July = rgb <188/255, 230/255, 239/255>;
#declare CN_First_Peach = rgb <244/255, 202/255, 198/255>;
#declare CN_First_Plum = rgb <184/255, 117/255, 146/255>;
#declare CN_First_Post = rgb <47/255, 189/255, 161/255>;
#declare CN_First_Rain = rgb <189/255, 216/255, 236/255>;
#declare CN_First_Shade_of_Blue = rgb <203/255, 225/255, 242/255>;
#declare CN_First_Snow = rgb <232/255, 239/255, 248/255>;
#declare CN_First_Star = rgb <218/255, 217/255, 212/255>;
#declare CN_First_Timer_Green = rgb <0/255, 232/255, 216/255>;
#declare CN_First_Tulip = rgb <255/255, 231/255, 156/255>;
#declare CN_First_Waltz = rgb <213/255, 188/255, 178/255>;
#declare CN_Fischer_Blue = rgb <50/255, 160/255, 177/255>;
#declare CN_Fish_Bone = rgb <228/255, 217/255, 197/255>;
#declare CN_Fish_Boy = rgb <17/255, 221/255, 221/255>;
#declare CN_Fish_Camp_Woods = rgb <122/255, 150/255, 130/255>;
#declare CN_Fish_Ceviche = rgb <225/255, 225/255, 213/255>;
#declare CN_Fish_Finger = rgb <238/255, 204/255, 85/255>;
#declare CN_Fish_Net_Blue = rgb <30/255, 68/255, 110/255>;
#declare CN_Fish_Pond = rgb <134/255, 200/255, 237/255>;
#declare CN_Fisher_King = rgb <81/255, 130/255, 185/255>;
#declare CN_Fishy_House = rgb <27/255, 165/255, 144/255>;
#declare CN_Fist_of_the_North_Star = rgb <34/255, 85/255, 153/255>;
#declare CN_Fistfull_of_Green = rgb <162/255, 164/255, 21/255>;
#declare CN_Fitness_Blue = rgb <91/255, 185/255, 210/255>;
#declare CN_Fitzgerald_Smoke = rgb <179/255, 182/255, 176/255>;
#declare CN_Five_Star = rgb <255/255, 170/255, 74/255>;
#declare CN_Fizz = rgb <177/255, 219/255, 170/255>;
#declare CN_Fizzing_Whizbees = rgb <221/255, 188/255, 188/255>;
#declare CN_Fizzle = rgb <216/255, 228/255, 222/255>;
#declare CN_Fjord = rgb <97/255, 98/255, 66/255>;
#declare CN_Fjord_Blue = rgb <0/255, 114/255, 144/255>;
#declare CN_Fjord_Green = rgb <0/255, 80/255, 67/255>;
#declare CN_Flag_Green = rgb <113/255, 124/255, 0/255>;
#declare CN_Flagstaff_Green = rgb <179/255, 191/255, 176/255>;
#declare CN_Flagstone = rgb <172/255, 173/255, 173/255>;
#declare CN_Flagstone_Quartzite = rgb <154/255, 158/255, 136/255>;
#declare CN_Flamboyant = rgb <18/255, 156/255, 139/255>;
#declare CN_Flamboyant_Plum = rgb <105/255, 78/255, 82/255>;
#declare CN_Flame = rgb <226/255, 88/255, 34/255>;
#declare CN_Flame_Hawkfish = rgb <150/255, 0/255, 24/255>;
#declare CN_Flame_Orange = rgb <251/255, 139/255, 35/255>;
#declare CN_Flame_Pea = rgb <190/255, 92/255, 72/255>;
#declare CN_Flame_Red = rgb <134/255, 40/255, 46/255>;
#declare CN_Flame_Scarlet = rgb <205/255, 33/255, 42/255>;
#declare CN_Flame_Yellow = rgb <255/255, 207/255, 73/255>;
#declare CN_Flamenco = rgb <234/255, 134/255, 69/255>;
#declare CN_Flaming_Flamingo = rgb <221/255, 85/255, 255/255>;
#declare CN_Flaming_June = rgb <238/255, 187/255, 102/255>;
#declare CN_Flaming_Torch = rgb <210/255, 134/255, 78/255>;
#declare CN_Flamingo = rgb <225/255, 99/255, 79/255>;
#declare CN_Flamingo_Diva = rgb <255/255, 68/255, 221/255>;
#declare CN_Flamingo_Dream = rgb <238/255, 136/255, 139/255>;
#declare CN_Flamingo_Feather = rgb <248/255, 189/255, 217/255>;
#declare CN_Flamingo_Fury = rgb <223/255, 1/255, 240/255>;
#declare CN_Flamingo_Peach = rgb <246/255, 226/255, 216/255>;
#declare CN_Flamingo_Pink = rgb <252/255, 142/255, 172/255>;
#declare CN_Flamingo_Queen = rgb <204/255, 51/255, 255/255>;
#declare CN_Flamingo_Red = rgb <239/255, 142/255, 135/255>;
#declare CN_Flan = rgb <246/255, 227/255, 180/255>;
#declare CN_Flannel_Grey = rgb <174/255, 173/255, 172/255>;
#declare CN_Flannel_Pajamas = rgb <139/255, 141/255, 152/255>;
#declare CN_Flapper_Dance = rgb <73/255, 87/255, 98/255>;
#declare CN_Flare_Gun = rgb <255/255, 69/255, 25/255>;
#declare CN_Flash_Gitz_Yellow = rgb <255/255, 251/255, 5/255>;
#declare CN_Flash_in_the_Pan = rgb <255/255, 153/255, 119/255>;
#declare CN_Flash_of_Orange = rgb <255/255, 170/255, 0/255>;
#declare CN_Flashlight = rgb <249/255, 238/255, 214/255>;
#declare CN_Flashman = rgb <124/255, 189/255, 133/255>;
#declare CN_Flashpoint = rgb <249/255, 242/255, 209/255>;
#declare CN_Flashy_Sapphire = rgb <44/255, 83/255, 138/255>;
#declare CN_Flat_Aluminum = rgb <195/255, 198/255, 205/255>;
#declare CN_Flat_Blue = rgb <60/255, 115/255, 168/255>;
#declare CN_Flat_Brown = rgb <117/255, 70/255, 0/255>;
#declare CN_Flat_Earth = rgb <170/255, 85/255, 51/255>;
#declare CN_Flat_Flesh = rgb <247/255, 212/255, 143/255>;
#declare CN_Flat_Green = rgb <105/255, 157/255, 76/255>;
#declare CN_Flat_Yellow = rgb <255/255, 240/255, 5/255>;
#declare CN_Flattered_Flamingo = rgb <238/255, 102/255, 85/255>;
#declare CN_Flattering_Peach = rgb <244/255, 211/255, 179/255>;
#declare CN_Flattery = rgb <107/255, 68/255, 36/255>;
#declare CN_Flavescent = rgb <247/255, 233/255, 142/255>;
#declare CN_Flavoparmelia_Caperata = rgb <143/255, 182/255, 123/255>;
#declare CN_Flax = rgb <238/255, 220/255, 130/255>;
#declare CN_Flax_Beige = rgb <212/255, 195/255, 179/255>;
#declare CN_Flax_Bloom = rgb <210/255, 216/255, 244/255>;
#declare CN_Flax_Fiber = rgb <224/255, 214/255, 142/255>;
#declare CN_Flax_Fibre_Grey = rgb <183/255, 169/255, 154/255>;
#declare CN_Flax_Flower = rgb <85/255, 119/255, 170/255>;
#declare CN_Flax_Flower_Blue = rgb <68/255, 153/255, 221/255>;
#declare CN_Flax_Smoke = rgb <123/255, 130/255, 101/255>;
#declare CN_Flax_Straw = rgb <203/255, 170/255, 125/255>;
#declare CN_Flax_Flower_Blue = rgb <111/255, 136/255, 175/255>;
#declare CN_Flaxen = rgb <251/255, 236/255, 201/255>;
#declare CN_Flaxen_Fair = rgb <227/255, 221/255, 189/255>;
#declare CN_Flaxen_Field = rgb <187/255, 166/255, 132/255>;
#declare CN_Flaxseed = rgb <247/255, 230/255, 198/255>;
#declare CN_Flayed_One_Flesh = rgb <252/255, 252/255, 222/255>;
#declare CN_Fleck = rgb <151/255, 187/255, 225/255>;
#declare CN_Fleeting_Green = rgb <216/255, 226/255, 216/255>;
#declare CN_Flemish_Blue = rgb <173/255, 208/255, 224/255>;
#declare CN_Flesh = rgb <255/255, 203/255, 196/255>;
#declare CN_Flesh_Fly = rgb <137/255, 69/255, 133/255>;
#declare CN_Flesh_Grey = rgb <170/255, 161/255, 151/255>;
#declare CN_Flesh_Pink = rgb <249/255, 203/255, 211/255>;
#declare CN_Flesh_Red = rgb <233/255, 196/255, 157/255>;
#declare CN_Flesh_Wash = rgb <206/255, 140/255, 66/255>;
#declare CN_Fleshtone_Shade_Wash = rgb <207/255, 147/255, 70/255>;
#declare CN_Fleur_de_Sel = rgb <220/255, 221/255, 216/255>;
#declare CN_Fleur_De_Lis = rgb <176/255, 144/255, 199/255>;
#declare CN_Flexible_Gray = rgb <177/255, 163/255, 161/255>;
#declare CN_Flickering_Firefly = rgb <248/255, 246/255, 230/255>;
#declare CN_Flickering_Flame = rgb <170/255, 110/255, 73/255>;
#declare CN_Flickering_Gold = rgb <198/255, 166/255, 104/255>;
#declare CN_Flickering_Light = rgb <255/255, 241/255, 220/255>;
#declare CN_Flickering_Sea = rgb <85/255, 102/255, 238/255>;
#declare CN_Flickery_C64 = rgb <79/255, 129/255, 255/255>;
#declare CN_Flickery_CRT_Green = rgb <144/255, 242/255, 21/255>;
#declare CN_Flickr_Blue = rgb <33/255, 107/255, 214/255>;
#declare CN_Flickr_Pink = rgb <251/255, 0/255, 129/255>;
#declare CN_Flier_Lie = rgb <205/255, 184/255, 145/255>;
#declare CN_Flight_Time = rgb <163/255, 184/255, 206/255>;
#declare CN_Flinders_Green = rgb <109/255, 112/255, 88/255>;
#declare CN_Fling_Green = rgb <142/255, 207/255, 208/255>;
#declare CN_Flint = rgb <113/255, 110/255, 97/255>;
#declare CN_Flint_Corn_Red = rgb <217/255, 98/255, 59/255>;
#declare CN_Flint_Grey = rgb <160/255, 156/255, 152/255>;
#declare CN_Flint_Purple = rgb <66/255, 66/255, 77/255>;
#declare CN_Flint_Rock = rgb <152/255, 148/255, 147/255>;
#declare CN_Flint_Shard = rgb <143/255, 147/255, 149/255>;
#declare CN_Flint_Smoke = rgb <168/255, 178/255, 177/255>;
#declare CN_Flintstone = rgb <103/255, 114/255, 131/255>;
#declare CN_Flintstone_Blue = rgb <67/255, 66/255, 82/255>;
#declare CN_Flip = rgb <69/255, 116/255, 126/255>;
#declare CN_Flip_a_Coin = rgb <204/255, 221/255, 204/255>;
#declare CN_Flip_Flop = rgb <242/255, 196/255, 167/255>;
#declare CN_Flipper = rgb <127/255, 114/255, 107/255>;
#declare CN_Flirt = rgb <122/255, 46/255, 77/255>;
#declare CN_Flirt_Alert = rgb <190/255, 60/255, 55/255>;
#declare CN_Flirtatious = rgb <255/255, 214/255, 55/255>;
#declare CN_Flirtatious_Flamingo = rgb <204/255, 34/255, 255/255>;
#declare CN_Flirtatious_Indigo_Tea = rgb <71/255, 63/255, 45/255>;
#declare CN_Flirty_Pink = rgb <158/255, 136/255, 177/255>;
#declare CN_Flirty_Salmon = rgb <250/255, 112/255, 105/255>;
#declare CN_Floating_Blue = rgb <176/255, 201/255, 205/255>;
#declare CN_Floating_Feather = rgb <233/255, 216/255, 194/255>;
#declare CN_Floating_Island = rgb <236/255, 229/255, 207/255>;
#declare CN_Floating_Lily = rgb <237/255, 235/255, 206/255>;
#declare CN_Floating_Lily_Pad = rgb <204/255, 199/255, 161/255>;
#declare CN_Flood = rgb <102/255, 119/255, 187/255>;
#declare CN_Flood_Mud = rgb <135/255, 121/255, 102/255>;
#declare CN_Flood_Out = rgb <87/255, 157/255, 171/255>;
#declare CN_Floppy_Disk = rgb <17/255, 0/255, 68/255>;
#declare CN_Flor_Lila = rgb <224/255, 224/255, 235/255>;
#declare CN_Flora = rgb <115/255, 250/255, 121/255>;
#declare CN_Flora_Green = rgb <145/255, 173/255, 138/255>;
#declare CN_Floral_Arrangement = rgb <198/255, 172/255, 159/255>;
#declare CN_Floral_Bluff = rgb <231/255, 207/255, 185/255>;
#declare CN_Floral_Bouquet = rgb <186/255, 203/255, 124/255>;
#declare CN_Floral_Leaf = rgb <255/255, 185/255, 78/255>;
#declare CN_Floral_Linen = rgb <245/255, 226/255, 222/255>;
#declare CN_Floral_Scent = rgb <238/255, 237/255, 233/255>;
#declare CN_Floral_Tapestry = rgb <195/255, 145/255, 145/255>;
#declare CN_Floral_White = rgb <255/255, 250/255, 240/255>;
#declare CN_Florence = rgb <150/255, 181/255, 118/255>;
#declare CN_Florence_Brown = rgb <131/255, 87/255, 64/255>;
#declare CN_Florence_Red = rgb <117/255, 63/255, 56/255>;
#declare CN_Florentine_Brown = rgb <122/255, 85/255, 68/255>;
#declare CN_Florentine_Clay = rgb <193/255, 147/255, 122/255>;
#declare CN_Florentine_Lapis = rgb <28/255, 87/255, 152/255>;
#declare CN_Florida_Grey = rgb <190/255, 164/255, 162/255>;
#declare CN_Florida_Keys = rgb <86/255, 190/255, 171/255>;
#declare CN_Florida_Mango = rgb <237/255, 159/255, 108/255>;
#declare CN_Florida_Sunrise = rgb <247/255, 170/255, 111/255>;
#declare CN_Florida_Turquoise = rgb <107/255, 184/255, 177/255>;
#declare CN_Florida_Waters = rgb <42/255, 73/255, 131/255>;
#declare CN_Floriography = rgb <165/255, 64/255, 73/255>;
#declare CN_Floss = rgb <215/255, 179/255, 185/255>;
#declare CN_Flotation = rgb <123/255, 176/255, 186/255>;
#declare CN_Flounce = rgb <74/255, 135/255, 145/255>;
#declare CN_Flour_Sack = rgb <185/255, 178/255, 151/255>;
#declare CN_Flourish = rgb <235/255, 220/255, 156/255>;
#declare CN_Flower_Bulb = rgb <217/255, 232/255, 201/255>;
#declare CN_Flower_Centre = rgb <253/255, 230/255, 198/255>;
#declare CN_Flower_Field = rgb <217/255, 169/255, 111/255>;
#declare CN_Flower_Girl = rgb <244/255, 152/255, 173/255>;
#declare CN_Flower_Girl_Dress = rgb <237/255, 231/255, 230/255>;
#declare CN_Flower_Hat_Jellyfish = rgb <249/255, 213/255, 147/255>;
#declare CN_Flower_of_Oahu = rgb <245/255, 223/255, 197/255>;
#declare CN_Flower_Pot = rgb <143/255, 68/255, 56/255>;
#declare CN_Flower_Spell = rgb <255/255, 201/255, 215/255>;
#declare CN_Flower_Stem = rgb <181/255, 213/255, 176/255>;
#declare CN_Flower_Wood = rgb <152/255, 131/255, 120/255>;
#declare CN_Flowerbed = rgb <255/255, 235/255, 218/255>;
#declare CN_Flowering_Cactus = rgb <162/255, 212/255, 189/255>;
#declare CN_Flowering_Chestnut = rgb <135/255, 86/255, 87/255>;
#declare CN_Flowering_Raspberry = rgb <161/255, 108/255, 148/255>;
#declare CN_Flowering_Reed = rgb <225/255, 216/255, 184/255>;
#declare CN_Flowerpot = rgb <216/255, 176/255, 160/255>;
#declare CN_Flowers_of_May = rgb <227/255, 215/255, 227/255>;
#declare CN_Flowery = rgb <228/255, 220/255, 191/255>;
#declare CN_Flowing_Breeze = rgb <185/255, 198/255, 203/255>;
#declare CN_Flowing_River = rgb <51/255, 94/255, 111/255>;
#declare CN_Fluffy_Duckling = rgb <252/255, 223/255, 57/255>;
#declare CN_Fluffy_Pink = rgb <247/255, 214/255, 203/255>;
#declare CN_Fluid_Blue = rgb <197/255, 214/255, 235/255>;
#declare CN_Fluor_Spar = rgb <167/255, 125/255, 53/255>;
#declare CN_Fluorescence = rgb <137/255, 209/255, 120/255>;
#declare CN_Fluorescent_Fire = rgb <152/255, 68/255, 39/255>;
#declare CN_Fluorescent_Green = rgb <8/255, 255/255, 8/255>;
#declare CN_Fluorescent_Lime = rgb <189/255, 194/255, 51/255>;
#declare CN_Fluorescent_Orange = rgb <255/255, 207/255, 0/255>;
#declare CN_Fluorescent_Pink = rgb <254/255, 20/255, 147/255>;
#declare CN_Fluorescent_Red = rgb <255/255, 85/255, 85/255>;
#declare CN_Fluorescent_Red_Orange = rgb <252/255, 132/255, 39/255>;
#declare CN_Fluorescent_Turquoise = rgb <0/255, 253/255, 255/255>;
#declare CN_Fluorescent_Yellow = rgb <204/255, 255/255, 2/255>;
#declare CN_Fluorite_Blue = rgb <180/255, 204/255, 194/255>;
#declare CN_Fluorite_Green = rgb <105/255, 145/255, 88/255>;
#declare CN_Fluro_Green = rgb <10/255, 255/255, 2/255>;
#declare CN_Flurries = rgb <242/255, 237/255, 227/255>;
#declare CN_Flush_Mahogany = rgb <202/255, 36/255, 37/255>;
#declare CN_Flush_Orange = rgb <255/255, 111/255, 1/255>;
#declare CN_Flush_Pink = rgb <248/255, 203/255, 196/255>;
#declare CN_Flushed = rgb <221/255, 85/255, 85/255>;
#declare CN_Fly_a_Kite = rgb <200/255, 218/255, 245/255>;
#declare CN_Fly_Agaric = rgb <255/255, 32/255, 82/255>;
#declare CN_Fly_by_Night = rgb <28/255, 30/255, 77/255>;
#declare CN_Flying_Carpet = rgb <120/255, 116/255, 137/255>;
#declare CN_Flying_Fish = rgb <83/255, 118/255, 171/255>;
#declare CN_Flying_Fish_Blue = rgb <2/255, 74/255, 202/255>;
#declare CN_Flyway = rgb <93/255, 179/255, 212/255>;
#declare CN_Foam = rgb <208/255, 234/255, 232/255>;
#declare CN_Foam_Green = rgb <144/255, 253/255, 169/255>;
#declare CN_Foaming_Surf = rgb <144/255, 209/255, 221/255>;
#declare CN_Foamy_Milk = rgb <247/255, 244/255, 247/255>;
#declare CN_Focus = rgb <229/255, 224/255, 210/255>;
#declare CN_Focus_on_Light = rgb <254/255, 249/255, 211/255>;
#declare CN_Focus_Point = rgb <145/255, 195/255, 189/255>;
#declare CN_Fog = rgb <214/255, 215/255, 210/255>;
#declare CN_Fog_Beacon = rgb <216/255, 214/255, 209/255>;
#declare CN_Fog_Green = rgb <194/255, 203/255, 180/255>;
#declare CN_Fog_of_War = rgb <17/255, 34/255, 51/255>;
#declare CN_Fog_White = rgb <241/255, 239/255, 228/255>;
#declare CN_Foggy_Amethyst = rgb <87/255, 49/255, 126/255>;
#declare CN_Foggy_Blue = rgb <153/255, 174/255, 187/255>;
#declare CN_Foggy_Day = rgb <231/255, 227/255, 219/255>;
#declare CN_Foggy_Dew = rgb <209/255, 213/255, 208/255>;
#declare CN_Foggy_Grey = rgb <167/255, 166/255, 157/255>;
#declare CN_Foggy_Heath = rgb <226/255, 201/255, 255/255>;
#declare CN_Foggy_London = rgb <92/255, 86/255, 88/255>;
#declare CN_Foggy_Love = rgb <213/255, 199/255, 232/255>;
#declare CN_Foggy_Mist = rgb <200/255, 209/255, 204/255>;
#declare CN_Foggy_Morn = rgb <202/255, 208/255, 206/255>;
#declare CN_Foggy_Night = rgb <167/255, 156/255, 142/255>;
#declare CN_Foggy_Quartz = rgb <191/255, 162/255, 161/255>;
#declare CN_Fogtown = rgb <238/255, 240/255, 231/255>;
#declare CN_Foil = rgb <192/255, 195/255, 196/255>;
#declare CN_Foille = rgb <176/255, 185/255, 156/255>;
#declare CN_Foliage = rgb <149/255, 179/255, 136/255>;
#declare CN_Foliage_Green = rgb <62/255, 111/255, 88/255>;
#declare CN_Folk_Guitar = rgb <122/255, 99/255, 79/255>;
#declare CN_Folk_Song = rgb <101/255, 161/255, 159/255>;
#declare CN_Folk_Tale = rgb <178/255, 225/255, 188/255>;
#declare CN_Folk_Tales = rgb <165/255, 193/255, 182/255>;
#declare CN_Folklore = rgb <104/255, 65/255, 65/255>;
#declare CN_Folkstone = rgb <109/255, 101/255, 98/255>;
#declare CN_Folkstone_Grey = rgb <98/255, 104/255, 121/255>;
#declare CN_Folksy_Gold = rgb <214/255, 153/255, 105/255>;
#declare CN_Follow_the_Leader = rgb <247/255, 229/255, 208/255>;
#declare CN_Folly = rgb <253/255, 0/255, 77/255>;
#declare CN_Fond_de_Teint = rgb <255/255, 170/255, 170/255>;
#declare CN_Fond_Memory = rgb <200/255, 188/255, 183/255>;
#declare CN_Fondue = rgb <201/255, 159/255, 151/255>;
#declare CN_Fondue_Fudge = rgb <93/255, 66/255, 54/255>;
#declare CN_Fools_Gold = rgb <202/255, 209/255, 117/255>;
#declare CN_Football = rgb <130/255, 87/255, 54/255>;
#declare CN_Football_Field = rgb <126/255, 175/255, 52/255>;
#declare CN_Foothill_Drive = rgb <202/255, 180/255, 142/255>;
#declare CN_Foothills = rgb <225/255, 207/255, 165/255>;
#declare CN_Footie_Pajamas = rgb <230/255, 206/255, 230/255>;
#declare CN_For_the_Love_of_Hue = rgb <69/255, 126/255, 135/255>;
#declare CN_Forbidden_Blackberry = rgb <50/255, 63/255, 117/255>;
#declare CN_Forbidden_Forest = rgb <33/255, 83/255, 84/255>;
#declare CN_Forbidden_Fruit = rgb <254/255, 123/255, 124/255>;
#declare CN_Forbidden_Red = rgb <138/255, 70/255, 70/255>;
#declare CN_Forbidden_Thrill = rgb <133/255, 99/255, 99/255>;
#declare CN_Force_of_Nature = rgb <213/255, 206/255, 105/255>;
#declare CN_Forceful_Orange = rgb <242/255, 147/255, 18/255>;
#declare CN_Foresight = rgb <148/255, 168/255, 211/255>;
#declare CN_Forest = rgb <11/255, 85/255, 9/255>;
#declare CN_Forest_Berry = rgb <149/255, 99/255, 120/255>;
#declare CN_Forest_Biome = rgb <24/255, 74/255, 69/255>;
#declare CN_Forest_Blues = rgb <13/255, 68/255, 98/255>;
#declare CN_Forest_Bound = rgb <115/255, 143/255, 80/255>;
#declare CN_Forest_Canopy = rgb <150/255, 149/255, 130/255>;
#declare CN_Forest_Edge = rgb <98/255, 123/255, 114/255>;
#declare CN_Forest_Fern = rgb <99/255, 183/255, 108/255>;
#declare CN_Forest_Floor = rgb <85/255, 81/255, 66/255>;
#declare CN_Forest_Floor_Khaki = rgb <120/255, 118/255, 109/255>;
#declare CN_Forest_Found = rgb <225/255, 223/255, 187/255>;
#declare CN_Forest_Frolic = rgb <136/255, 187/255, 149/255>;
#declare CN_Forest_Fruit_Pink = rgb <104/255, 57/255, 59/255>;
#declare CN_Forest_Fruit_Red = rgb <110/255, 39/255, 89/255>;
#declare CN_Forest_Green = rgb <21/255, 68/255, 6/255>;
#declare CN_Forest_Greenery = rgb <62/255, 100/255, 91/255>;
#declare CN_Forest_Lichen = rgb <154/255, 162/255, 43/255>;
#declare CN_Forest_Maid = rgb <82/255, 185/255, 99/255>;
#declare CN_Forest_Moss = rgb <133/255, 143/255, 131/255>;
#declare CN_Forest_Night = rgb <67/255, 66/255, 55/255>;
#declare CN_Forest_Path = rgb <112/255, 141/255, 108/255>;
#declare CN_Forest_Rain = rgb <33/255, 105/255, 87/255>;
#declare CN_Forest_Ride = rgb <0/255, 104/255, 0/255>;
#declare CN_Forest_Ridge = rgb <85/255, 93/255, 70/255>;
#declare CN_Forest_Shade = rgb <145/255, 172/255, 128/255>;
#declare CN_Forest_Spirit = rgb <102/255, 112/255, 40/255>;
#declare CN_Forest_Splendor = rgb <1/255, 110/255, 97/255>;
#declare CN_Forest_Tapestry = rgb <164/255, 186/255, 138/255>;
#declare CN_Forest_Tent = rgb <187/255, 167/255, 72/255>;
#declare CN_Forester = rgb <154/255, 167/255, 124/255>;
#declare CN_Forestwood = rgb <77/255, 83/255, 70/255>;
#declare CN_Forever_Blue = rgb <137/255, 155/255, 184/255>;
#declare CN_Forever_Denim = rgb <119/255, 133/255, 144/255>;
#declare CN_Forever_Fairytale = rgb <210/255, 187/255, 178/255>;
#declare CN_Forever_Faithful = rgb <239/255, 230/255, 225/255>;
#declare CN_Forever_Green = rgb <170/255, 180/255, 167/255>;
#declare CN_Forever_Lilac = rgb <175/255, 165/255, 199/255>;
#declare CN_Forged_Iron = rgb <72/255, 70/255, 74/255>;
#declare CN_Forged_Steel = rgb <91/255, 91/255, 89/255>;
#declare CN_Forget_Me_Not = rgb <0/255, 135/255, 189/255>;
#declare CN_Forget_Me_Not_Blue = rgb <53/255, 128/255, 148/255>;
#declare CN_Forgive_Quickly = rgb <225/255, 225/255, 190/255>;
#declare CN_Forgiven_Sin = rgb <255/255, 17/255, 153/255>;
#declare CN_Forgotten_Blue = rgb <192/255, 229/255, 236/255>;
#declare CN_Forgotten_Gold = rgb <199/255, 184/255, 159/255>;
#declare CN_Forgotten_Mosque = rgb <226/255, 217/255, 219/255>;
#declare CN_Forgotten_Pink = rgb <255/255, 217/255, 214/255>;
#declare CN_Forgotten_Purple = rgb <152/255, 120/255, 248/255>;
#declare CN_Forgotten_Sunset = rgb <253/255, 213/255, 177/255>;
#declare CN_Formal_Affair = rgb <132/255, 131/255, 145/255>;
#declare CN_Formal_Garden = rgb <58/255, 152/255, 77/255>;
#declare CN_Formal_Grey = rgb <151/255, 150/255, 154/255>;
#declare CN_Formal_Maroon = rgb <112/255, 71/255, 75/255>;
#declare CN_Forsythia = rgb <255/255, 200/255, 1/255>;
#declare CN_Forsythia_Blossom = rgb <246/255, 215/255, 110/255>;
#declare CN_Forsythia_Bud = rgb <187/255, 204/255, 85/255>;
#declare CN_Fortitude = rgb <198/255, 197/255, 193/255>;
#declare CN_Fortress_Grey = rgb <184/255, 184/255, 184/255>;
#declare CN_Fortress_Stone = rgb <197/255, 192/255, 176/255>;
#declare CN_Fortune = rgb <159/255, 151/255, 163/255>;
#declare CN_Fortune_Cookie = rgb <224/255, 197/255, 161/255>;
#declare CN_Fortune_Red = rgb <176/255, 83/255, 77/255>;
#declare CN_Fortunes_Prize = rgb <218/255, 169/255, 148/255>;
#declare CN_Forward_Fuchsia = rgb <146/255, 52/255, 91/255>;
#declare CN_Fossil = rgb <128/255, 111/255, 99/255>;
#declare CN_Fossil_Butte = rgb <167/255, 143/255, 101/255>;
#declare CN_Fossil_Green = rgb <108/255, 106/255, 67/255>;
#declare CN_Fossil_Sand = rgb <210/255, 200/255, 187/255>;
#declare CN_Fossil_Stone = rgb <227/255, 221/255, 204/255>;
#declare CN_Fossil_Tan = rgb <209/255, 175/255, 144/255>;
#declare CN_Fossilized = rgb <182/255, 184/255, 176/255>;
#declare CN_Fossilized_Leaf = rgb <117/255, 106/255, 67/255>;
#declare CN_Foul_Green = rgb <133/255, 199/255, 161/255>;
#declare CN_Foundation = rgb <248/255, 232/255, 197/255>;
#declare CN_Foundation_White = rgb <239/255, 238/255, 255/255>;
#declare CN_Fountain = rgb <86/255, 181/255, 202/255>;
#declare CN_Fountain_Blue = rgb <101/255, 173/255, 178/255>;
#declare CN_Fountain_City = rgb <156/255, 212/255, 207/255>;
#declare CN_Fountain_Frolic = rgb <228/255, 228/255, 197/255>;
#declare CN_Fountain_Spout = rgb <205/255, 235/255, 236/255>;
#declare CN_Fountains_of_Budapest = rgb <185/255, 222/255, 240/255>;
#declare CN_Four_Leaf_Clover = rgb <115/255, 143/255, 93/255>;
#declare CN_Fox = rgb <195/255, 135/255, 67/255>;
#declare CN_Fox_Hill = rgb <200/255, 170/255, 146/255>;
#declare CN_Fox_Red = rgb <202/255, 78/255, 51/255>;
#declare CN_Fox_Tails = rgb <221/255, 136/255, 0/255>;
#declare CN_Foxen = rgb <191/255, 142/255, 127/255>;
#declare CN_Foxfire_Brown = rgb <159/255, 105/255, 73/255>;
#declare CN_Foxflower_Viola = rgb <162/255, 172/255, 197/255>;
#declare CN_Foxglove = rgb <185/255, 131/255, 145/255>;
#declare CN_Foxgloves = rgb <198/255, 192/255, 202/255>;
#declare CN_Foxhall_Green = rgb <69/255, 75/255, 64/255>;
#declare CN_Foxtail = rgb <188/255, 137/255, 110/255>;
#declare CN_Foxy = rgb <168/255, 94/255, 83/255>;
#declare CN_Foxy_Fuchsia = rgb <159/255, 0/255, 197/255>;
#declare CN_Foxy_Lady = rgb <213/255, 166/255, 173/255>;
#declare CN_Foxy_Pink = rgb <219/255, 149/255, 171/255>;
#declare CN_Fozzie_Bear = rgb <112/255, 98/255, 92/255>;
#declare CN_Fragile = rgb <187/255, 184/255, 208/255>;
#declare CN_Fragile_Beauty = rgb <231/255, 215/255, 198/255>;
#declare CN_Fragile_Fern = rgb <239/255, 242/255, 219/255>;
#declare CN_Fragrant_Cherry = rgb <142/255, 84/255, 92/255>;
#declare CN_Fragrant_Cloves = rgb <172/255, 94/255, 58/255>;
#declare CN_Fragrant_Jasmine = rgb <251/255, 246/255, 231/255>;
#declare CN_Fragrant_Lilac = rgb <206/255, 173/255, 190/255>;
#declare CN_Fragrant_Satchel = rgb <169/255, 159/255, 186/255>;
#declare CN_Fragrant_Snowbell = rgb <213/255, 197/255, 212/255>;
#declare CN_Fragrant_Wand = rgb <173/255, 177/255, 193/255>;
#declare CN_Frail_Fuchsia = rgb <238/255, 136/255, 238/255>;
#declare CN_Framboise = rgb <228/255, 0/255, 88/255>;
#declare CN_Frangipane = rgb <244/255, 213/255, 178/255>;
#declare CN_Frangipani = rgb <255/255, 215/255, 160/255>;
#declare CN_Frank_Blue = rgb <34/255, 82/255, 136/255>;
#declare CN_Frank_Lloyd_White = rgb <239/255, 235/255, 219/255>;
#declare CN_Frankenstein = rgb <123/255, 160/255, 91/255>;
#declare CN_Frankly_Earnest = rgb <226/255, 219/255, 202/255>;
#declare CN_Frappe = rgb <209/255, 183/255, 160/255>;
#declare CN_Freckles = rgb <215/255, 135/255, 117/255>;
#declare CN_Free_Green = rgb <116/255, 166/255, 144/255>;
#declare CN_Free_Reign = rgb <209/255, 205/255, 202/255>;
#declare CN_Free_Speech_Aquamarine = rgb <2/255, 157/255, 116/255>;
#declare CN_Free_Speech_Blue = rgb <65/255, 86/255, 197/255>;
#declare CN_Free_Speech_Green = rgb <9/255, 249/255, 17/255>;
#declare CN_Free_Speech_Magenta = rgb <227/255, 91/255, 216/255>;
#declare CN_Free_Speech_Red = rgb <192/255, 0/255, 0/255>;
#declare CN_Free_Spirit = rgb <222/255, 238/255, 237/255>;
#declare CN_Freedom = rgb <59/255, 94/255, 104/255>;
#declare CN_Freedom_Found = rgb <101/255, 118/255, 130/255>;
#declare CN_Freefall = rgb <86/255, 82/255, 102/255>;
#declare CN_Freesia = rgb <243/255, 193/255, 44/255>;
#declare CN_Freesia_Purple = rgb <179/255, 176/255, 212/255>;
#declare CN_Freezing_Vapor = rgb <212/255, 233/255, 245/255>;
#declare CN_Freezy_Breezy = rgb <153/255, 238/255, 238/255>;
#declare CN_Freezy_Wind = rgb <153/255, 255/255, 221/255>;
#declare CN_Freinacht_Black = rgb <35/255, 47/255, 54/255>;
#declare CN_French_75 = rgb <249/255, 243/255, 213/255>;
#declare CN_French_Beige = rgb <166/255, 123/255, 80/255>;
#declare CN_French_Bistre = rgb <133/255, 109/255, 77/255>;
#declare CN_French_Blue = rgb <0/255, 114/255, 187/255>;
#declare CN_French_Bustle = rgb <242/255, 213/255, 212/255>;
#declare CN_French_Castle = rgb <205/255, 192/255, 183/255>;
#declare CN_French_Colony = rgb <144/255, 161/255, 170/255>;
#declare CN_French_Court = rgb <106/255, 142/255, 162/255>;
#declare CN_French_Creme = rgb <242/255, 230/255, 207/255>;
#declare CN_French_Diamond = rgb <89/255, 113/255, 145/255>;
#declare CN_French_Fuchsia = rgb <253/255, 63/255, 146/255>;
#declare CN_French_Grey = rgb <191/255, 189/255, 193/255>;
#declare CN_French_Grey_Linen = rgb <202/255, 200/255, 182/255>;
#declare CN_French_Heirloom = rgb <233/255, 226/255, 224/255>;
#declare CN_French_Lavender = rgb <223/255, 201/255, 209/255>;
#declare CN_French_Lilac = rgb <222/255, 183/255, 217/255>;
#declare CN_French_Lilac_Blue = rgb <173/255, 186/255, 227/255>;
#declare CN_French_Lime = rgb <192/255, 255/255, 0/255>;
#declare CN_French_Limestone = rgb <201/255, 214/255, 194/255>;
#declare CN_French_Manicure = rgb <254/255, 230/255, 220/255>;
#declare CN_French_Market = rgb <162/255, 199/255, 163/255>;
#declare CN_French_Mauve = rgb <212/255, 115/255, 212/255>;
#declare CN_French_Mirage_Blue = rgb <68/255, 102/255, 136/255>;
#declare CN_French_Moire = rgb <159/255, 187/255, 195/255>;
#declare CN_French_Oak = rgb <187/255, 158/255, 124/255>;
#declare CN_French_Pale_Gold = rgb <212/255, 171/255, 96/255>;
#declare CN_French_Parsley = rgb <158/255, 160/255, 125/255>;
#declare CN_French_Pass = rgb <164/255, 210/255, 224/255>;
#declare CN_French_Pastry = rgb <196/255, 170/255, 146/255>;
#declare CN_French_Pear = rgb <158/255, 159/255, 125/255>;
#declare CN_French_Pink = rgb <253/255, 108/255, 158/255>;
#declare CN_French_Plum = rgb <129/255, 20/255, 83/255>;
#declare CN_French_Porcelain = rgb <246/255, 244/255, 246/255>;
#declare CN_French_Porcelain_Clay = rgb <250/255, 241/255, 215/255>;
#declare CN_French_Puce = rgb <78/255, 22/255, 9/255>;
#declare CN_French_Raspberry = rgb <199/255, 44/255, 72/255>;
#declare CN_French_Roast = rgb <88/255, 66/255, 63/255>;
#declare CN_French_Rose = rgb <246/255, 74/255, 138/255>;
#declare CN_French_Shutter = rgb <186/255, 182/255, 160/255>;
#declare CN_French_Silver = rgb <184/255, 188/255, 188/255>;
#declare CN_French_Sky_Blue = rgb <119/255, 181/255, 254/255>;
#declare CN_French_Tarragon = rgb <102/255, 114/255, 85/255>;
#declare CN_French_Taupe = rgb <211/255, 194/255, 191/255>;
#declare CN_French_Toast = rgb <221/255, 136/255, 34/255>;
#declare CN_French_Truffle = rgb <137/255, 109/255, 97/255>;
#declare CN_French_Vanilla = rgb <239/255, 225/255, 167/255>;
#declare CN_French_Vanilla_Sorbet = rgb <251/255, 232/255, 206/255>;
#declare CN_French_Violet = rgb <136/255, 6/255, 206/255>;
#declare CN_French_White = rgb <241/255, 231/255, 219/255>;
#declare CN_French_Wine = rgb <172/255, 30/255, 68/255>;
#declare CN_French_Winery = rgb <153/255, 17/255, 51/255>;
#declare CN_Frenzied_Red = rgb <129/255, 74/255, 92/255>;
#declare CN_Frenzy = rgb <254/255, 177/255, 1/255>;
#declare CN_Fresco = rgb <244/255, 219/255, 217/255>;
#declare CN_Fresco_Blue = rgb <3/255, 76/255, 103/255>;
#declare CN_Fresco_Cream = rgb <252/255, 201/255, 166/255>;
#declare CN_Fresco_Green = rgb <123/255, 217/255, 173/255>;
#declare CN_Fresh_Acorn = rgb <210/255, 105/255, 62/255>;
#declare CN_Fresh_Air = rgb <166/255, 231/255, 255/255>;
#declare CN_Fresh_Apple = rgb <151/255, 163/255, 70/255>;
#declare CN_Fresh_Apricot = rgb <255/255, 215/255, 165/255>;
#declare CN_Fresh_Artichoke = rgb <124/255, 132/255, 71/255>;
#declare CN_Fresh_Auburn = rgb <165/255, 42/255, 36/255>;
#declare CN_Fresh_Baked_Bread = rgb <248/255, 215/255, 190/255>;
#declare CN_Fresh_Basil = rgb <92/255, 95/255, 75/255>;
#declare CN_Fresh_Blue = rgb <139/255, 214/255, 226/255>;
#declare CN_Fresh_Blue_of_Bel_Air = rgb <6/255, 154/255, 243/255>;
#declare CN_Fresh_Breeze = rgb <190/255, 237/255, 220/255>;
#declare CN_Fresh_Brew = rgb <184/255, 170/255, 125/255>;
#declare CN_Fresh_Cantaloupe = rgb <255/255, 156/255, 104/255>;
#declare CN_Fresh_Cedar = rgb <167/255, 127/255, 116/255>;
#declare CN_Fresh_Cinnamon = rgb <153/255, 85/255, 17/255>;
#declare CN_Fresh_Clay = rgb <190/255, 128/255, 53/255>;
#declare CN_Fresh_Cream = rgb <252/255, 247/255, 224/255>;
#declare CN_Fresh_Croissant = rgb <204/255, 159/255, 118/255>;
#declare CN_Fresh_Cut = rgb <242/255, 0/255, 60/255>;
#declare CN_Fresh_Cut_Grass = rgb <145/255, 203/255, 125/255>;
#declare CN_Fresh_Day = rgb <223/255, 233/255, 229/255>;
#declare CN_Fresh_Dew = rgb <240/255, 244/255, 229/255>;
#declare CN_Fresh_Dough = rgb <242/255, 235/255, 230/255>;
#declare CN_Fresh_Eggplant = rgb <79/255, 70/255, 126/255>;
#declare CN_Fresh_Eggs = rgb <250/255, 244/255, 206/255>;
#declare CN_Fresh_Eucalyptus = rgb <173/255, 188/255, 180/255>;
#declare CN_Fresh_Frappe = rgb <219/255, 230/255, 157/255>;
#declare CN_Fresh_Gingerbread = rgb <211/255, 105/255, 31/255>;
#declare CN_Fresh_Granny_Smith = rgb <127/255, 242/255, 23/255>;
#declare CN_Fresh_Green = rgb <105/255, 216/255, 79/255>;
#declare CN_Fresh_Greens = rgb <63/255, 173/255, 113/255>;
#declare CN_Fresh_Grown = rgb <240/255, 247/255, 196/255>;
#declare CN_Fresh_Guacamole = rgb <162/255, 176/255, 126/255>;
#declare CN_Fresh_Gum = rgb <255/255, 170/255, 221/255>;
#declare CN_Fresh_Heather = rgb <209/255, 193/255, 221/255>;
#declare CN_Fresh_Herb = rgb <119/255, 145/255, 59/255>;
#declare CN_Fresh_Herbs = rgb <58/255, 95/255, 73/255>;
#declare CN_Fresh_Honeydew = rgb <246/255, 239/255, 197/255>;
#declare CN_Fresh_Ivy_Green = rgb <0/255, 106/255, 91/255>;
#declare CN_Fresh_Lavender = rgb <142/255, 144/255, 180/255>;
#declare CN_Fresh_Lawn = rgb <136/255, 170/255, 0/255>;
#declare CN_Fresh_Leaf = rgb <147/255, 239/255, 16/255>;
#declare CN_Fresh_Lemonade = rgb <236/255, 230/255, 120/255>;
#declare CN_Fresh_Lettuce = rgb <178/255, 213/255, 140/255>;
#declare CN_Fresh_Lime = rgb <216/255, 241/255, 203/255>;
#declare CN_Fresh_Linen = rgb <235/255, 232/255, 218/255>;
#declare CN_Fresh_Mint = rgb <42/255, 84/255, 67/255>;
#declare CN_Fresh_Nectar = rgb <218/255, 166/255, 116/255>;
#declare CN_Fresh_Neon_Pink = rgb <255/255, 17/255, 255/255>;
#declare CN_Fresh_Olive = rgb <166/255, 158/255, 115/255>;
#declare CN_Fresh_Onion = rgb <91/255, 137/255, 48/255>;
#declare CN_Fresh_Oregano = rgb <79/255, 170/255, 108/255>;
#declare CN_Fresh_Peaches = rgb <246/255, 185/255, 138/255>;
#declare CN_Fresh_Piglet = rgb <253/255, 221/255, 230/255>;
#declare CN_Fresh_Pine = rgb <79/255, 91/255, 73/255>;
#declare CN_Fresh_Pineapple = rgb <243/255, 214/255, 79/255>;
#declare CN_Fresh_Pink = rgb <225/255, 144/255, 145/255>;
#declare CN_Fresh_Pink_Lemonade = rgb <210/255, 173/255, 181/255>;
#declare CN_Fresh_Popcorn = rgb <244/255, 243/255, 233/255>;
#declare CN_Fresh_Praline = rgb <231/255, 187/255, 149/255>;
#declare CN_Fresh_Salmon = rgb <255/255, 127/255, 106/255>;
#declare CN_Fresh_Sawdust = rgb <200/255, 162/255, 120/255>;
#declare CN_Fresh_Scent = rgb <241/255, 193/255, 28/255>;
#declare CN_Fresh_Snow = rgb <246/255, 239/255, 225/255>;
#declare CN_Fresh_Sod = rgb <145/255, 160/255, 133/255>;
#declare CN_Fresh_Soft_Blue = rgb <106/255, 185/255, 187/255>;
#declare CN_Fresh_Sprout = rgb <199/255, 193/255, 118/255>;
#declare CN_Fresh_Squeezed = rgb <255/255, 173/255, 0/255>;
#declare CN_Fresh_Start = rgb <207/255, 212/255, 164/255>;
#declare CN_Fresh_Straw = rgb <238/255, 204/255, 102/255>;
#declare CN_Fresh_Take = rgb <80/255, 91/255, 147/255>;
#declare CN_Fresh_Thyme = rgb <174/255, 189/255, 168/255>;
#declare CN_Fresh_Tone = rgb <178/255, 199/255, 192/255>;
#declare CN_Fresh_Turquoise = rgb <64/255, 224/255, 208/255>;
#declare CN_Fresh_Up = rgb <223/255, 235/255, 177/255>;
#declare CN_Fresh_Water = rgb <198/255, 227/255, 247/255>;
#declare CN_Fresh_Watermelon = rgb <223/255, 150/255, 137/255>;
#declare CN_Fresh_Willow = rgb <225/255, 217/255, 170/255>;
#declare CN_Fresh_Wood_Ashes = rgb <234/255, 230/255, 204/255>;
#declare CN_Fresh_Yellow = rgb <247/255, 225/255, 144/255>;
#declare CN_Fresh_Zest = rgb <245/255, 233/255, 207/255>;
#declare CN_Freshly_Roasted_Coffee = rgb <102/255, 51/255, 34/255>;
#declare CN_Freshman = rgb <230/255, 242/255, 196/255>;
#declare CN_Freshmint = rgb <217/255, 244/255, 234/255>;
#declare CN_Freshwater = rgb <77/255, 166/255, 178/255>;
#declare CN_Freshwater_Marsh = rgb <83/255, 86/255, 68/255>;
#declare CN_Fretwire = rgb <178/255, 164/255, 144/255>;
#declare CN_Friar_Brown = rgb <110/255, 73/255, 58/255>;
#declare CN_Friar_Grey = rgb <128/255, 126/255, 121/255>;
#declare CN_Friar_Tuck = rgb <221/255, 185/255, 148/255>;
#declare CN_Friars_Brown = rgb <94/255, 82/255, 65/255>;
#declare CN_Fricassee = rgb <255/255, 230/255, 194/255>;
#declare CN_Friend_Flesh = rgb <241/255, 164/255, 183/255>;
#declare CN_Friendly_Basilisk = rgb <226/255, 245/255, 225/255>;
#declare CN_Friendly_Homestead = rgb <200/255, 169/255, 146/255>;
#declare CN_Friendly_Yellow = rgb <245/255, 224/255, 177/255>;
#declare CN_Friends = rgb <232/255, 197/255, 193/255>;
#declare CN_Friendship = rgb <254/255, 216/255, 194/255>;
#declare CN_Fright_Night = rgb <0/255, 68/255, 153/255>;
#declare CN_Frijid_Pink = rgb <238/255, 119/255, 255/255>;
#declare CN_Frilled_Shark = rgb <147/255, 159/255, 169/255>;
#declare CN_Frills = rgb <143/255, 166/255, 193/255>;
#declare CN_Fringy_Flower = rgb <180/255, 225/255, 187/255>;
#declare CN_Frisky = rgb <204/255, 221/255, 161/255>;
#declare CN_Frisky_Blue = rgb <123/255, 177/255, 201/255>;
#declare CN_Frittata = rgb <254/255, 235/255, 200/255>;
#declare CN_Frivolous_Folly = rgb <207/255, 210/255, 199/255>;
#declare CN_Frog = rgb <88/255, 188/255, 8/255>;
#declare CN_Frog_Green = rgb <0/255, 105/255, 60/255>;
#declare CN_Frog_Hollow = rgb <125/255, 162/255, 112/255>;
#declare CN_Frog_Prince = rgb <187/255, 215/255, 90/255>;
#declare CN_Frogs_Legs = rgb <140/255, 132/255, 73/255>;
#declare CN_Frogger = rgb <140/255, 214/255, 18/255>;
#declare CN_Frolic = rgb <249/255, 231/255, 225/255>;
#declare CN_Froly = rgb <229/255, 109/255, 117/255>;
#declare CN_Frond = rgb <123/255, 127/255, 86/255>;
#declare CN_Front_Porch = rgb <205/255, 204/255, 197/255>;
#declare CN_Frontier = rgb <49/255, 74/255, 73/255>;
#declare CN_Frontier_Brown = rgb <154/255, 129/255, 114/255>;
#declare CN_Frontier_Fort = rgb <195/255, 177/255, 159/255>;
#declare CN_Frontier_Land = rgb <188/255, 165/255, 154/255>;
#declare CN_Frontier_Shadow = rgb <101/255, 90/255, 74/255>;
#declare CN_Frontier_Shingle = rgb <123/255, 95/255, 70/255>;
#declare CN_Frost = rgb <225/255, 228/255, 197/255>;
#declare CN_Frost_Bite = rgb <246/255, 240/255, 229/255>;
#declare CN_Frost_Blue = rgb <93/255, 154/255, 166/255>;
#declare CN_Frost_Grey = rgb <132/255, 130/255, 131/255>;
#declare CN_Frost_Gum = rgb <142/255, 203/255, 158/255>;
#declare CN_Frost_Wind = rgb <218/255, 235/255, 239/255>;
#declare CN_Frostbite = rgb <172/255, 255/255, 252/255>;
#declare CN_Frosted_Almond = rgb <210/255, 194/255, 172/255>;
#declare CN_Frosted_Blueberries = rgb <0/255, 85/255, 221/255>;
#declare CN_Frosted_Cocoa = rgb <168/255, 156/255, 145/255>;
#declare CN_Frosted_Emerald = rgb <120/255, 177/255, 133/255>;
#declare CN_Frosted_Fern = rgb <167/255, 167/255, 150/255>;
#declare CN_Frosted_Garden = rgb <226/255, 247/255, 217/255>;
#declare CN_Frosted_Glass = rgb <234/255, 240/255, 240/255>;
#declare CN_Frosted_Grape = rgb <212/255, 196/255, 210/255>;
#declare CN_Frosted_Iris = rgb <177/255, 185/255, 217/255>;
#declare CN_Frosted_Jade = rgb <194/255, 209/255, 196/255>;
#declare CN_Frosted_Juniper = rgb <240/255, 244/255, 235/255>;
#declare CN_Frosted_Lemon = rgb <255/255, 237/255, 199/255>;
#declare CN_Frosted_Lilac = rgb <211/255, 209/255, 220/255>;
#declare CN_Frosted_Mint = rgb <226/255, 242/255, 228/255>;
#declare CN_Frosted_Pomegranate = rgb <173/255, 61/255, 70/255>;
#declare CN_Frosted_Sage = rgb <198/255, 209/255, 196/255>;
#declare CN_Frosted_Silver = rgb <197/255, 201/255, 197/255>;
#declare CN_Frosted_Sugar = rgb <213/255, 188/255, 194/255>;
#declare CN_Frosted_Toffee = rgb <241/255, 219/255, 191/255>;
#declare CN_Frosted_Tulip = rgb <246/255, 216/255, 215/255>;
#declare CN_Frostee = rgb <219/255, 229/255, 210/255>;
#declare CN_Frosting_Cream = rgb <255/255, 251/255, 238/255>;
#declare CN_Frostini = rgb <219/255, 242/255, 217/255>;
#declare CN_Frostproof = rgb <209/255, 240/255, 246/255>;
#declare CN_Frostwork = rgb <239/255, 241/255, 227/255>;
#declare CN_Frosty_Dawn = rgb <203/255, 233/255, 201/255>;
#declare CN_Frosty_Day = rgb <204/255, 235/255, 245/255>;
#declare CN_Frosty_Fog = rgb <222/255, 225/255, 233/255>;
#declare CN_Frosty_Glade = rgb <160/255, 192/255, 191/255>;
#declare CN_Frosty_Green = rgb <163/255, 181/255, 166/255>;
#declare CN_Frosty_Mint = rgb <226/255, 247/255, 241/255>;
#declare CN_Frosty_Morning = rgb <239/255, 232/255, 232/255>;
#declare CN_Frosty_Pine = rgb <199/255, 207/255, 190/255>;
#declare CN_Frosty_Soft_Blue = rgb <180/255, 224/255, 222/255>;
#declare CN_Frosty_Spruce = rgb <87/255, 130/255, 112/255>;
#declare CN_Frosty_White = rgb <221/255, 221/255, 214/255>;
#declare CN_Frosty_White_Blue = rgb <204/255, 233/255, 228/255>;
#declare CN_Froth = rgb <198/255, 184/255, 174/255>;
#declare CN_Frothy_Milk = rgb <250/255, 237/255, 230/255>;
#declare CN_Frothy_Surf = rgb <231/255, 235/255, 230/255>;
#declare CN_Frozen_Banana = rgb <251/255, 245/255, 214/255>;
#declare CN_Frozen_Blue = rgb <165/255, 197/255, 217/255>;
#declare CN_Frozen_Civilization = rgb <225/255, 245/255, 229/255>;
#declare CN_Frozen_Custard = rgb <251/255, 234/255, 189/255>;
#declare CN_Frozen_Dew = rgb <216/255, 207/255, 178/255>;
#declare CN_Frozen_Edamame = rgb <156/255, 164/255, 138/255>;
#declare CN_Frozen_Forest = rgb <207/255, 232/255, 182/255>;
#declare CN_Frozen_Frappe = rgb <221/255, 197/255, 210/255>;
#declare CN_Frozen_Fruit = rgb <225/255, 202/255, 153/255>;
#declare CN_Frozen_Grass = rgb <222/255, 234/255, 220/255>;
#declare CN_Frozen_Lake = rgb <123/255, 156/255, 179/255>;
#declare CN_Frozen_Mammoth = rgb <223/255, 217/255, 218/255>;
#declare CN_Frozen_Margarita = rgb <219/255, 226/255, 204/255>;
#declare CN_Frozen_Mint = rgb <216/255, 232/255, 230/255>;
#declare CN_Frozen_Moss_Green = rgb <173/255, 223/255, 173/255>;
#declare CN_Frozen_Pea = rgb <196/255, 234/255, 213/255>;
#declare CN_Frozen_Pond = rgb <165/255, 180/255, 174/255>;
#declare CN_Frozen_Salmon = rgb <254/255, 169/255, 147/255>;
#declare CN_Frozen_State = rgb <38/255, 247/255, 253/255>;
#declare CN_Frozen_Statues = rgb <225/255, 222/255, 229/255>;
#declare CN_Frozen_Stream = rgb <48/255, 85/255, 93/255>;
#declare CN_Frozen_Tomato = rgb <221/255, 85/255, 51/255>;
#declare CN_Frozen_Tundra = rgb <163/255, 191/255, 203/255>;
#declare CN_Frozen_Turquoise = rgb <83/255, 246/255, 255/255>;
#declare CN_Frozen_Wave = rgb <86/255, 172/255, 202/255>;
#declare CN_Frugal = rgb <165/255, 215/255, 178/255>;
#declare CN_Fruit_Bowl = rgb <253/255, 201/255, 208/255>;
#declare CN_Fruit_Cocktail = rgb <208/255, 137/255, 149/255>;
#declare CN_Fruit_Dove = rgb <206/255, 91/255, 120/255>;
#declare CN_Fruit_Of_Passion = rgb <148/255, 105/255, 133/255>;
#declare CN_Fruit_Red = rgb <250/255, 137/255, 112/255>;
#declare CN_Fruit_Salad = rgb <75/255, 163/255, 81/255>;
#declare CN_Fruit_Shake = rgb <243/255, 157/255, 141/255>;
#declare CN_Fruit_Yard = rgb <96/255, 66/255, 65/255>;
#declare CN_Fruit_Yellow = rgb <234/255, 192/255, 100/255>;
#declare CN_Fruitful_Orchard = rgb <119/255, 59/255, 62/255>;
#declare CN_Fruitless_Fig_Tree = rgb <68/255, 136/255, 34/255>;
#declare CN_Fruity_Licious = rgb <246/255, 144/255, 146/255>;
#declare CN_Fuchsia = rgb <237/255, 13/255, 217/255>;
#declare CN_Fuchsia_Berries = rgb <51/255, 51/255, 34/255>;
#declare CN_Fuchsia_Blue = rgb <122/255, 88/255, 193/255>;
#declare CN_Fuchsia_Blush = rgb <228/255, 124/255, 184/255>;
#declare CN_Fuchsia_Fever = rgb <255/255, 85/255, 153/255>;
#declare CN_Fuchsia_Flair = rgb <187/255, 34/255, 187/255>;
#declare CN_Fuchsia_Flash = rgb <221/255, 85/255, 204/255>;
#declare CN_Fuchsia_Flock = rgb <171/255, 68/255, 107/255>;
#declare CN_Fuchsia_Flourish = rgb <187/255, 34/255, 153/255>;
#declare CN_Fuchsia_Intenso = rgb <216/255, 0/255, 204/255>;
#declare CN_Fuchsia_Kiss = rgb <203/255, 110/255, 152/255>;
#declare CN_Fuchsia_Nebula = rgb <119/255, 34/255, 170/255>;
#declare CN_Fuchsia_Pink = rgb <255/255, 119/255, 255/255>;
#declare CN_Fuchsia_Purple = rgb <211/255, 52/255, 121/255>;
#declare CN_Fuchsia_Red = rgb <171/255, 52/255, 117/255>;
#declare CN_Fuchsia_Rose = rgb <199/255, 67/255, 117/255>;
#declare CN_Fuchsia_Tint = rgb <194/255, 85/255, 193/255>;
#declare CN_Fuchsite = rgb <195/255, 217/255, 206/255>;
#declare CN_Fuchsite_Green = rgb <91/255, 126/255, 112/255>;
#declare CN_Fudge = rgb <73/255, 51/255, 56/255>;
#declare CN_Fudge_Bar = rgb <153/255, 121/255, 100/255>;
#declare CN_Fudge_Truffle = rgb <96/255, 74/255, 63/255>;
#declare CN_Fudgesicle = rgb <212/255, 107/255, 172/255>;
#declare CN_Fuegan_Orange = rgb <199/255, 126/255, 77/255>;
#declare CN_Fuego = rgb <238/255, 85/255, 51/255>;
#declare CN_Fuego_Nuevo = rgb <238/255, 102/255, 34/255>;
#declare CN_Fuego_Verde = rgb <194/255, 214/255, 46/255>;
#declare CN_Fuel_Town = rgb <89/255, 100/255, 114/255>;
#declare CN_Fuel_Yellow = rgb <209/255, 144/255, 51/255>;
#declare CN_Fugitive_Flamingo = rgb <238/255, 102/255, 170/255>;
#declare CN_Fuji_Peak = rgb <246/255, 238/255, 226/255>;
#declare CN_Fuji_Purple = rgb <137/255, 114/255, 158/255>;
#declare CN_Fuji_Snow = rgb <241/255, 239/255, 232/255>;
#declare CN_Fujinezumi = rgb <118/255, 105/255, 128/255>;
#declare CN_Fulgrim_Pink = rgb <245/255, 179/255, 206/255>;
#declare CN_Fulgurite_Copper = rgb <230/255, 183/255, 126/255>;
#declare CN_Full_Bloom = rgb <251/255, 205/255, 195/255>;
#declare CN_Full_City_Roast = rgb <102/255, 34/255, 34/255>;
#declare CN_Full_Cream = rgb <250/255, 228/255, 206/255>;
#declare CN_Full_Glass = rgb <145/255, 107/255, 119/255>;
#declare CN_Full_Moon = rgb <244/255, 243/255, 224/255>;
#declare CN_Full_Moon_Grey = rgb <207/255, 234/255, 233/255>;
#declare CN_Full_Of_Life = rgb <222/255, 95/255, 47/255>;
#declare CN_Full_Yellow = rgb <249/255, 188/255, 79/255>;
#declare CN_Fully_Purple = rgb <81/255, 76/255, 126/255>;
#declare CN_Fulvous = rgb <228/255, 132/255, 0/255>;
#declare CN_Fun_and_Games = rgb <51/255, 120/255, 156/255>;
#declare CN_Fun_Blue = rgb <51/255, 80/255, 131/255>;
#declare CN_Fun_Green = rgb <21/255, 99/255, 61/255>;
#declare CN_Fun_Yellow = rgb <247/255, 229/255, 148/255>;
#declare CN_Funchal_Yellow = rgb <182/255, 136/255, 77/255>;
#declare CN_Functional_Blue = rgb <63/255, 96/255, 134/255>;
#declare CN_Functional_Gray = rgb <171/255, 163/255, 154/255>;
#declare CN_Fundy_Bay = rgb <205/255, 210/255, 201/255>;
#declare CN_Fungal_Hallucinations = rgb <204/255, 0/255, 221/255>;
#declare CN_Fungi = rgb <143/255, 129/255, 119/255>;
#declare CN_Funhouse = rgb <243/255, 217/255, 220/255>;
#declare CN_Funk = rgb <62/255, 163/255, 128/255>;
#declare CN_Funki_Porcini = rgb <238/255, 153/255, 153/255>;
#declare CN_Funkie_Friday = rgb <74/255, 60/255, 74/255>;
#declare CN_Funky_Frog = rgb <152/255, 189/255, 60/255>;
#declare CN_Funky_Yellow = rgb <237/255, 210/255, 111/255>;
#declare CN_Funnel_Cloud = rgb <17/255, 51/255, 102/255>;
#declare CN_Funny_Face = rgb <237/255, 200/255, 206/255>;
#declare CN_Furious_Frog = rgb <85/255, 238/255, 0/255>;
#declare CN_Furious_Fuchsia = rgb <238/255, 34/255, 119/255>;
#declare CN_Furious_Red = rgb <255/255, 17/255, 0/255>;
#declare CN_Furnace = rgb <221/255, 65/255, 36/255>;
#declare CN_Furry_Lady = rgb <245/255, 239/255, 235/255>;
#declare CN_Furry_Lion = rgb <240/255, 147/255, 56/255>;
#declare CN_Fury = rgb <255/255, 0/255, 17/255>;
#declare CN_Fuschia_Flair = rgb <164/255, 71/255, 105/255>;
#declare CN_Fuscia_Fizz = rgb <181/255, 110/255, 145/255>;
#declare CN_Fuscous_Grey = rgb <84/255, 83/255, 77/255>;
#declare CN_Fusilli = rgb <241/255, 232/255, 214/255>;
#declare CN_Fusion = rgb <176/255, 174/255, 38/255>;
#declare CN_Fusion_Coral = rgb <255/255, 133/255, 118/255>;
#declare CN_Fusion_Red = rgb <255/255, 97/255, 99/255>;
#declare CN_Fussy_Pink = rgb <230/255, 163/255, 185/255>;
#declare CN_Futaai_Indigo = rgb <97/255, 78/255, 110/255>;
#declare CN_Futon = rgb <237/255, 246/255, 219/255>;
#declare CN_Future = rgb <21/255, 171/255, 190/255>;
#declare CN_Future_Hair = rgb <32/255, 181/255, 98/255>;
#declare CN_Future_Vision = rgb <188/255, 182/255, 188/255>;
#declare CN_Futuristic = rgb <153/255, 141/255, 168/255>;
#declare CN_Fuzzy_Duckling = rgb <255/255, 234/255, 112/255>;
#declare CN_Fuzzy_Navel = rgb <255/255, 214/255, 159/255>;
#declare CN_Fuzzy_Peach = rgb <255/255, 187/255, 143/255>;
#declare CN_Fuzzy_Sheep = rgb <240/255, 233/255, 209/255>;
#declare CN_Fuzzy_Unicorn = rgb <234/255, 227/255, 219/255>;
#declare CN_Fuzzy_Wuzzy = rgb <204/255, 102/255, 102/255>;
#declare CN_Fuzzy_Wuzzy_Brown = rgb <196/255, 86/255, 85/255>;
#declare CN_Fynbos_Leaf = rgb <174/255, 177/255, 172/255>;
#declare CN_Gable_Green = rgb <44/255, 70/255, 65/255>;
#declare CN_Gaboon_Viper = rgb <140/255, 100/255, 80/255>;
#declare CN_Gabriels_Light = rgb <218/255, 204/255, 168/255>;
#declare CN_Gabriels_Torch = rgb <248/255, 230/255, 198/255>;
#declare CN_Gadabout = rgb <255/255, 196/255, 174/255>;
#declare CN_Gaelic_Garden = rgb <165/255, 179/255, 171/255>;
#declare CN_Gahara_Lal = rgb <172/255, 12/255, 32/255>;
#declare CN_Gaia = rgb <211/255, 188/255, 158/255>;
#declare CN_Gaiety = rgb <244/255, 228/255, 229/255>;
#declare CN_Gainsboro = rgb <220/255, 220/255, 220/255>;
#declare CN_Gala_Ball = rgb <120/255, 93/255, 122/255>;
#declare CN_Gala_Pink = rgb <176/255, 75/255, 99/255>;
#declare CN_Galactic_Civilization = rgb <68/255, 34/255, 136/255>;
#declare CN_Galactic_Federation = rgb <51/255, 0/255, 119/255>;
#declare CN_Galactic_Highway = rgb <51/255, 17/255, 187/255>;
#declare CN_Galactic_Mediator = rgb <224/255, 223/255, 219/255>;
#declare CN_Galactic_Tint = rgb <192/255, 196/255, 198/255>;
#declare CN_Galactic_Wonder = rgb <68/255, 34/255, 85/255>;
#declare CN_Galactica = rgb <196/255, 221/255, 226/255>;
#declare CN_Galago = rgb <149/255, 166/255, 159/255>;
#declare CN_Galah = rgb <210/255, 128/255, 131/255>;
#declare CN_Galapagos = rgb <8/255, 95/255, 109/255>;
#declare CN_Galapagos_Green = rgb <41/255, 104/255, 95/255>;
#declare CN_Galaxy_Blue = rgb <42/255, 75/255, 124/255>;
#declare CN_Galaxy_Green = rgb <121/255, 175/255, 173/255>;
#declare CN_Gale_Force = rgb <53/255, 69/255, 78/255>;
#declare CN_Gale_of_the_Wind = rgb <0/255, 120/255, 68/255>;
#declare CN_Galenite_Blue = rgb <55/255, 75/255, 82/255>;
#declare CN_Gallant_Gold = rgb <164/255, 118/255, 60/255>;
#declare CN_Gallant_Green = rgb <153/255, 170/255, 102/255>;
#declare CN_Galleon_Blue = rgb <63/255, 149/255, 191/255>;
#declare CN_Gallery = rgb <220/255, 215/255, 209/255>;
#declare CN_Gallery_Blue = rgb <155/255, 188/255, 228/255>;
#declare CN_Gallery_Green = rgb <136/255, 163/255, 133/255>;
#declare CN_Gallery_Grey = rgb <197/255, 194/255, 190/255>;
#declare CN_Gallery_Red = rgb <147/255, 90/255, 89/255>;
#declare CN_Gallery_Taupe = rgb <208/255, 197/255, 184/255>;
#declare CN_Gallery_White = rgb <234/255, 235/255, 228/255>;
#declare CN_Galley_Gold = rgb <213/255, 170/255, 94/255>;
#declare CN_Galliano = rgb <216/255, 167/255, 35/255>;
#declare CN_Gallstone_Yellow = rgb <163/255, 102/255, 41/255>;
#declare CN_Galveston_Tan = rgb <232/255, 200/255, 184/255>;
#declare CN_Galway = rgb <196/255, 221/255, 187/255>;
#declare CN_Galway_Bay = rgb <149/255, 167/255, 164/255>;
#declare CN_Gamboge = rgb <228/255, 155/255, 15/255>;
#declare CN_Gamboge_Brown = rgb <153/255, 102/255, 0/255>;
#declare CN_Gamboge_Yellow = rgb <230/255, 208/255, 88/255>;
#declare CN_Gambol_Gold = rgb <225/255, 176/255, 71/255>;
#declare CN_Game_Over = rgb <126/255, 129/255, 129/255>;
#declare CN_Gameboy_Contrast = rgb <15/255, 56/255, 15/255>;
#declare CN_Gameboy_Light = rgb <155/255, 188/255, 15/255>;
#declare CN_Gameboy_Screen = rgb <139/255, 172/255, 15/255>;
#declare CN_Gameboy_Shade = rgb <48/255, 98/255, 48/255>;
#declare CN_Gamin = rgb <191/255, 209/255, 175/255>;
#declare CN_Gan_Lan_Huang_Olive = rgb <201/255, 255/255, 39/255>;
#declare CN_Gan_Lan_Lu_Green = rgb <101/255, 139/255, 56/255>;
#declare CN_Ganache = rgb <52/255, 41/255, 42/255>;
#declare CN_Gangsters_Gold = rgb <255/255, 221/255, 34/255>;
#declare CN_Ganon_Blue = rgb <164/255, 228/255, 252/255>;
#declare CN_Ganymede = rgb <139/255, 125/255, 130/255>;
#declare CN_Garbanzo_Bean = rgb <241/255, 213/255, 165/255>;
#declare CN_Garbanzo_Paste = rgb <238/255, 198/255, 132/255>;
#declare CN_Garden_Aroma = rgb <156/255, 105/255, 137/255>;
#declare CN_Garden_Country = rgb <213/255, 197/255, 168/255>;
#declare CN_Garden_Cucumber = rgb <80/255, 106/255, 72/255>;
#declare CN_Garden_Dawn = rgb <241/255, 248/255, 236/255>;
#declare CN_Garden_Fairy = rgb <204/255, 212/255, 236/255>;
#declare CN_Garden_Flower = rgb <168/255, 146/255, 168/255>;
#declare CN_Garden_Fountain = rgb <114/255, 149/255, 136/255>;
#declare CN_Garden_Gate = rgb <218/255, 220/255, 193/255>;
#declare CN_Garden_Gazebo = rgb <171/255, 192/255, 187/255>;
#declare CN_Garden_Glade = rgb <220/255, 216/255, 168/255>;
#declare CN_Garden_Glory = rgb <255/255, 193/255, 208/255>;
#declare CN_Garden_Glow = rgb <125/255, 204/255, 152/255>;
#declare CN_Garden_Gnome_Red = rgb <155/255, 32/255, 2/255>;
#declare CN_Garden_Goddess = rgb <153/255, 206/255, 160/255>;
#declare CN_Garden_Green = rgb <73/255, 94/255, 53/255>;
#declare CN_Garden_Greenery = rgb <101/255, 131/255, 105/255>;
#declare CN_Garden_Grove = rgb <94/255, 127/255, 87/255>;
#declare CN_Garden_Hedge = rgb <111/255, 125/255, 109/255>;
#declare CN_Garden_Lattice = rgb <225/255, 212/255, 180/255>;
#declare CN_Garden_Lettuce_Green = rgb <135/255, 118/255, 43/255>;
#declare CN_Garden_Medley = rgb <40/255, 168/255, 115/255>;
#declare CN_Garden_of_Eden = rgb <127/255, 167/255, 113/255>;
#declare CN_Garden_Pansy = rgb <168/255, 144/255, 184/255>;
#declare CN_Garden_Party = rgb <227/255, 164/255, 184/255>;
#declare CN_Garden_Path = rgb <66/255, 67/255, 48/255>;
#declare CN_Garden_Pebble = rgb <228/255, 228/255, 213/255>;
#declare CN_Garden_Picket = rgb <228/255, 209/255, 149/255>;
#declare CN_Garden_Plum = rgb <157/255, 130/255, 146/255>;
#declare CN_Garden_Pond = rgb <175/255, 192/255, 158/255>;
#declare CN_Garden_Promenade = rgb <164/255, 169/255, 155/255>;
#declare CN_Garden_Room = rgb <172/255, 207/255, 169/255>;
#declare CN_Garden_Rose_White = rgb <247/255, 234/255, 212/255>;
#declare CN_Garden_Salt_Green = rgb <161/255, 139/255, 98/255>;
#declare CN_Garden_Seat = rgb <235/255, 230/255, 199/255>;
#declare CN_Garden_Shadow = rgb <51/255, 68/255, 0/255>;
#declare CN_Garden_Shed = rgb <214/255, 239/255, 218/255>;
#declare CN_Garden_Snail = rgb <205/255, 177/255, 171/255>;
#declare CN_Garden_Spot = rgb <177/255, 202/255, 149/255>;
#declare CN_Garden_Sprout = rgb <171/255, 134/255, 58/255>;
#declare CN_Garden_Statue = rgb <191/255, 212/255, 196/255>;
#declare CN_Garden_Stroll = rgb <125/255, 198/255, 131/255>;
#declare CN_Garden_Swing = rgb <140/255, 189/255, 151/255>;
#declare CN_Garden_Topiary = rgb <62/255, 82/255, 75/255>;
#declare CN_Garden_Twilight = rgb <163/255, 187/255, 179/255>;
#declare CN_Garden_View = rgb <137/255, 184/255, 154/255>;
#declare CN_Garden_Vista = rgb <159/255, 177/255, 171/255>;
#declare CN_Garden_Wall = rgb <174/255, 164/255, 146/255>;
#declare CN_Garden_Weed = rgb <120/255, 110/255, 56/255>;
#declare CN_Gardener_Green = rgb <94/255, 96/255, 42/255>;
#declare CN_Gardeners_Soil = rgb <92/255, 83/255, 77/255>;
#declare CN_Gardenia = rgb <241/255, 232/255, 223/255>;
#declare CN_Gardening = rgb <172/255, 186/255, 141/255>;
#declare CN_Gardens_Sericourt = rgb <51/255, 119/255, 0/255>;
#declare CN_Garfield = rgb <167/255, 84/255, 41/255>;
#declare CN_Gargantua = rgb <238/255, 238/255, 85/255>;
#declare CN_Gargoyle = rgb <171/255, 179/255, 158/255>;
#declare CN_Gargoyle_Gas = rgb <255/255, 223/255, 70/255>;
#declare CN_Garish_Blue = rgb <0/255, 164/255, 177/255>;
#declare CN_Garish_Green = rgb <81/255, 191/255, 138/255>;
#declare CN_Garland = rgb <105/255, 136/255, 123/255>;
#declare CN_Garlic_Beige = rgb <176/255, 170/255, 161/255>;
#declare CN_Garlic_Clove = rgb <226/255, 215/255, 193/255>;
#declare CN_Garlic_Pesto = rgb <191/255, 207/255, 0/255>;
#declare CN_Garlic_Suede = rgb <205/255, 210/255, 188/255>;
#declare CN_Garlic_Toast = rgb <221/255, 221/255, 136/255>;
#declare CN_Garnet = rgb <115/255, 54/255, 53/255>;
#declare CN_Garnet_Black_Green = rgb <53/255, 74/255, 65/255>;
#declare CN_Garnet_Evening = rgb <118/255, 59/255, 66/255>;
#declare CN_Garnet_Rose = rgb <172/255, 75/255, 85/255>;
#declare CN_Garnet_Sand = rgb <204/255, 116/255, 70/255>;
#declare CN_Garnet_Shadow = rgb <200/255, 144/255, 149/255>;
#declare CN_Garnet_Stone_Blue = rgb <56/255, 72/255, 102/255>;
#declare CN_Garnish = rgb <30/255, 151/255, 82/255>;
#declare CN_Garret_Gray = rgb <117/255, 104/255, 97/255>;
#declare CN_Garrison_Grey = rgb <123/255, 133/255, 136/255>;
#declare CN_Garuda_Gold = rgb <255/255, 187/255, 49/255>;
#declare CN_Gas_Giant = rgb <152/255, 220/255, 255/255>;
#declare CN_Gaslight = rgb <254/255, 255/255, 234/255>;
#declare CN_Gates_of_Gold = rgb <210/255, 147/255, 93/255>;
#declare CN_Gateway_Gray = rgb <178/255, 172/255, 156/255>;
#declare CN_Gateway_Grey = rgb <160/255, 160/255, 156/255>;
#declare CN_Gathering_Field = rgb <171/255, 143/255, 85/255>;
#declare CN_Gathering_Place = rgb <173/255, 148/255, 102/255>;
#declare CN_Gatsby_Brick = rgb <142/255, 59/255, 47/255>;
#declare CN_Gatsby_Glitter = rgb <238/255, 214/255, 131/255>;
#declare CN_Gauntlet_Gray = rgb <120/255, 115/255, 110/255>;
#declare CN_Gauss_Blaster_Green = rgb <132/255, 195/255, 170/255>;
#declare CN_Gauzy_White = rgb <227/255, 219/255, 212/255>;
#declare CN_Gazebo_Green = rgb <118/255, 130/255, 108/255>;
#declare CN_Gazebo_Grey = rgb <209/255, 208/255, 203/255>;
#declare CN_Gazelle = rgb <148/255, 126/255, 104/255>;
#declare CN_Gazpacho = rgb <194/255, 59/255, 34/255>;
#declare CN_Gecko = rgb <157/255, 145/255, 60/255>;
#declare CN_Gedeon_Brown = rgb <127/255, 95/255, 0/255>;
#declare CN_Gedney_Green = rgb <64/255, 83/255, 78/255>;
#declare CN_Geebung = rgb <197/255, 131/255, 46/255>;
#declare CN_Gehennas_Gold = rgb <219/255, 166/255, 116/255>;
#declare CN_Gellibrand = rgb <181/255, 172/255, 178/255>;
#declare CN_Gem = rgb <77/255, 91/255, 138/255>;
#declare CN_Gem_Silica = rgb <115/255, 196/255, 164/255>;
#declare CN_Gem_Turquoise = rgb <83/255, 194/255, 195/255>;
#declare CN_Gemstone_Blue = rgb <0/255, 79/255, 109/255>;
#declare CN_Gemstone_Green = rgb <75/255, 99/255, 49/255>;
#declare CN_Generic_Viridian = rgb <0/255, 127/255, 102/255>;
#declare CN_Genestealer_Purple = rgb <119/255, 97/255, 171/255>;
#declare CN_Genetic_Code = rgb <24/255, 81/255, 93/255>;
#declare CN_Geneva_Green = rgb <31/255, 127/255, 118/255>;
#declare CN_Geneva_Morn = rgb <186/255, 183/255, 184/255>;
#declare CN_Genever_Green = rgb <51/255, 103/255, 63/255>;
#declare CN_Genevieve = rgb <188/255, 196/255, 224/255>;
#declare CN_Gengiana = rgb <95/255, 72/255, 113/255>;
#declare CN_Genie = rgb <62/255, 67/255, 100/255>;
#declare CN_Genoa = rgb <49/255, 121/255, 109/255>;
#declare CN_Genoa_Lemon = rgb <253/255, 233/255, 16/255>;
#declare CN_Genteel_Blue = rgb <105/255, 142/255, 179/255>;
#declare CN_Genteel_Lavender = rgb <226/255, 230/255, 236/255>;
#declare CN_Gentian = rgb <144/255, 121/255, 173/255>;
#declare CN_Gentian_Blue = rgb <49/255, 34/255, 151/255>;
#declare CN_Gentian_Flower = rgb <51/255, 102/255, 255/255>;
#declare CN_Gentian_Violet = rgb <84/255, 66/255, 117/255>;
#declare CN_Gentle_Aquamarine = rgb <151/255, 203/255, 210/255>;
#declare CN_Gentle_Blue = rgb <205/255, 210/255, 222/255>;
#declare CN_Gentle_Calm = rgb <196/255, 206/255, 191/255>;
#declare CN_Gentle_Caress = rgb <252/255, 215/255, 186/255>;
#declare CN_Gentle_Cold = rgb <195/255, 236/255, 233/255>;
#declare CN_Gentle_Doe = rgb <232/255, 183/255, 147/255>;
#declare CN_Gentle_Frost = rgb <220/255, 224/255, 205/255>;
#declare CN_Gentle_Giant = rgb <179/255, 235/255, 224/255>;
#declare CN_Gentle_Glow = rgb <246/255, 229/255, 185/255>;
#declare CN_Gentle_Grape = rgb <144/255, 138/255, 155/255>;
#declare CN_Gentle_Mauve = rgb <149/255, 140/255, 158/255>;
#declare CN_Gentle_Rain = rgb <203/255, 201/255, 197/255>;
#declare CN_Gentle_Sea = rgb <176/255, 200/255, 208/255>;
#declare CN_Gentle_Sky = rgb <153/255, 189/255, 210/255>;
#declare CN_Gentle_Touch = rgb <227/255, 213/255, 184/255>;
#declare CN_Gentle_Yellow = rgb <255/255, 245/255, 190/255>;
#declare CN_Gentlemans_Suit = rgb <193/255, 190/255, 205/255>;
#declare CN_Geode = rgb <75/255, 63/255, 105/255>;
#declare CN_Georgia_Clay = rgb <176/255, 97/255, 68/255>;
#declare CN_Georgia_On_My_Mind = rgb <253/255, 212/255, 197/255>;
#declare CN_Georgia_Peach = rgb <249/255, 114/255, 114/255>;
#declare CN_Georgian_Bay = rgb <34/255, 101/255, 127/255>;
#declare CN_Georgian_Leather = rgb <207/255, 135/255, 94/255>;
#declare CN_Georgian_Pink = rgb <198/255, 184/255, 180/255>;
#declare CN_Georgian_Revival_Blue = rgb <91/255, 141/255, 159/255>;
#declare CN_Georgian_Yellow = rgb <209/255, 151/255, 76/255>;
#declare CN_Geraldine = rgb <231/255, 123/255, 117/255>;
#declare CN_Geranium = rgb <218/255, 61/255, 88/255>;
#declare CN_Geranium_Bud = rgb <207/255, 161/255, 199/255>;
#declare CN_Geranium_Leaf = rgb <144/255, 172/255, 116/255>;
#declare CN_Geranium_Pink = rgb <246/255, 144/255, 157/255>;
#declare CN_Geranium_Red = rgb <215/255, 105/255, 104/255>;
#declare CN_Gerbera_Red = rgb <246/255, 97/255, 26/255>;
#declare CN_German_Camouflage_Beige = rgb <155/255, 140/255, 123/255>;
#declare CN_German_Grey = rgb <83/255, 80/255, 78/255>;
#declare CN_German_Hop = rgb <137/255, 172/255, 39/255>;
#declare CN_German_Liquorice = rgb <46/255, 55/255, 73/255>;
#declare CN_German_Mustard = rgb <205/255, 122/255, 0/255>;
#declare CN_Germander_Speedwell = rgb <0/255, 148/255, 200/255>;
#declare CN_Germania = rgb <221/255, 196/255, 126/255>;
#declare CN_Get_Up_and_Go = rgb <26/255, 157/255, 73/255>;
#declare CN_Gettysburg_Grey = rgb <199/255, 193/255, 183/255>;
#declare CN_Geyser = rgb <196/255, 215/255, 207/255>;
#declare CN_Geyser_Basin = rgb <227/255, 202/255, 181/255>;
#declare CN_Geyser_Steam = rgb <203/255, 208/255, 207/255>;
#declare CN_Ghee_Yellow = rgb <216/255, 188/255, 35/255>;
#declare CN_Ghost = rgb <192/255, 191/255, 199/255>;
#declare CN_Ghost_Grey = rgb <156/255, 155/255, 152/255>;
#declare CN_Ghost_Pepper = rgb <193/255, 1/255, 2/255>;
#declare CN_Ghost_Ship = rgb <136/255, 123/255, 110/255>;
#declare CN_Ghost_Town = rgb <190/255, 182/255, 168/255>;
#declare CN_Ghost_Whisperer = rgb <203/255, 209/255, 208/255>;
#declare CN_Ghost_White = rgb <248/255, 248/255, 255/255>;
#declare CN_Ghost_Writer = rgb <188/255, 183/255, 173/255>;
#declare CN_Ghosted = rgb <226/255, 224/255, 220/255>;
#declare CN_Ghosting = rgb <202/255, 198/255, 186/255>;
#declare CN_Ghostlands_Coal = rgb <17/255, 60/255, 66/255>;
#declare CN_Ghostly = rgb <167/255, 160/255, 159/255>;
#declare CN_Ghostly_Green = rgb <217/255, 215/255, 184/255>;
#declare CN_Ghostly_Grey = rgb <204/255, 204/255, 211/255>;
#declare CN_Ghostly_Purple = rgb <123/255, 93/255, 146/255>;
#declare CN_Ghostwaver = rgb <226/255, 219/255, 219/255>;
#declare CN_Ghoul = rgb <102/255, 119/255, 68/255>;
#declare CN_Giant_Cactus_Green = rgb <136/255, 118/255, 63/255>;
#declare CN_Giant_Onion = rgb <102/255, 93/255, 158/255>;
#declare CN_Giants_Club = rgb <176/255, 92/255, 82/255>;
#declare CN_Giants_Orange = rgb <254/255, 90/255, 29/255>;
#declare CN_Gibraltar = rgb <98/255, 105/255, 112/255>;
#declare CN_Gibraltar_Grey = rgb <111/255, 106/255, 104/255>;
#declare CN_Gibraltar_Sea = rgb <18/255, 56/255, 80/255>;
#declare CN_Gigas = rgb <86/255, 71/255, 134/255>;
#declare CN_Giggle = rgb <239/255, 240/255, 211/255>;
#declare CN_Gilded = rgb <244/255, 219/255, 79/255>;
#declare CN_Gilded_Beige = rgb <179/255, 159/255, 141/255>;
#declare CN_Gilded_Glamour = rgb <149/255, 104/255, 65/255>;
#declare CN_Gilded_Leaves = rgb <235/255, 161/255, 60/255>;
#declare CN_Gilded_Pear = rgb <192/255, 158/255, 108/255>;
#declare CN_Gilneas_Grey = rgb <108/255, 131/255, 150/255>;
#declare CN_Gimblet = rgb <185/255, 173/255, 97/255>;
#declare CN_Gin = rgb <217/255, 223/255, 205/255>;
#declare CN_Gin_Fizz = rgb <248/255, 234/255, 202/255>;
#declare CN_Gin_Tonic = rgb <236/255, 235/255, 229/255>;
#declare CN_Ginger = rgb <176/255, 101/255, 0/255>;
#declare CN_Ginger_Ale = rgb <201/255, 168/255, 106/255>;
#declare CN_Ginger_Ale_Fizz = rgb <245/255, 223/255, 188/255>;
#declare CN_Ginger_Beer = rgb <194/255, 127/255, 56/255>;
#declare CN_Ginger_Cream = rgb <239/255, 224/255, 215/255>;
#declare CN_Ginger_Crunch = rgb <206/255, 170/255, 100/255>;
#declare CN_Ginger_Dough = rgb <176/255, 109/255, 59/255>;
#declare CN_Ginger_Dy = rgb <151/255, 101/255, 60/255>;
#declare CN_Ginger_Flower = rgb <207/255, 82/255, 78/255>;
#declare CN_Ginger_Grey_Yellow = rgb <184/255, 168/255, 153/255>;
#declare CN_Ginger_Jar = rgb <198/255, 160/255, 94/255>;
#declare CN_Ginger_Lemon_Tea = rgb <255/255, 255/255, 170/255>;
#declare CN_Ginger_Milk = rgb <247/255, 164/255, 84/255>;
#declare CN_Ginger_Peach = rgb <249/255, 208/255, 159/255>;
#declare CN_Ginger_Pie = rgb <154/255, 125/255, 97/255>;
#declare CN_Ginger_Root = rgb <193/255, 116/255, 68/255>;
#declare CN_Ginger_Rose = rgb <190/255, 135/255, 116/255>;
#declare CN_Ginger_Shortbread = rgb <227/255, 206/255, 198/255>;
#declare CN_Ginger_Snap = rgb <151/255, 125/255, 112/255>;
#declare CN_Ginger_Spice = rgb <182/255, 93/255, 72/255>;
#declare CN_Ginger_Sugar = rgb <221/255, 218/255, 206/255>;
#declare CN_Ginger_Tea = rgb <177/255, 157/255, 119/255>;
#declare CN_Ginger_Whisper = rgb <204/255, 136/255, 119/255>;
#declare CN_Gingerbread = rgb <140/255, 74/255, 47/255>;
#declare CN_Gingerbread_Crumble = rgb <156/255, 94/255, 51/255>;
#declare CN_Gingerbread_House = rgb <202/255, 153/255, 78/255>;
#declare CN_Gingerbread_Latte = rgb <179/255, 148/255, 121/255>;
#declare CN_Gingerline = rgb <255/255, 221/255, 17/255>;
#declare CN_Gingersnap = rgb <199/255, 158/255, 115/255>;
#declare CN_Gingery = rgb <176/255, 108/255, 62/255>;
#declare CN_Gingko = rgb <163/255, 200/255, 153/255>;
#declare CN_Gingko_Tree = rgb <145/255, 130/255, 96/255>;
#declare CN_Ginkgo_Green = rgb <165/255, 172/255, 164/255>;
#declare CN_Ginnezumi = rgb <151/255, 134/255, 124/255>;
#declare CN_Ginninderra = rgb <179/255, 213/255, 192/255>;
#declare CN_Ginseng_Root = rgb <230/255, 205/255, 181/255>;
#declare CN_Ginshu = rgb <188/255, 45/255, 41/255>;
#declare CN_Gio_Ponti_Green = rgb <179/255, 206/255, 171/255>;
#declare CN_Giraffe = rgb <254/255, 254/255, 51/255>;
#declare CN_Girl_Power = rgb <211/255, 155/255, 203/255>;
#declare CN_Girl_Talk = rgb <228/255, 199/255, 200/255>;
#declare CN_Girlie = rgb <255/255, 211/255, 207/255>;
#declare CN_Girls_Night_Out = rgb <255/255, 105/255, 180/255>;
#declare CN_Girly_Nursery = rgb <246/255, 230/255, 229/255>;
#declare CN_Give_Me_Your_Love = rgb <238/255, 136/255, 255/255>;
#declare CN_Givry = rgb <235/255, 212/255, 174/255>;
#declare CN_Gizmo = rgb <212/255, 161/255, 181/255>;
#declare CN_Glacial_Green = rgb <111/255, 183/255, 168/255>;
#declare CN_Glacial_Ice = rgb <234/255, 233/255, 231/255>;
#declare CN_Glacial_Stream = rgb <188/255, 216/255, 226/255>;
#declare CN_Glacial_Tint = rgb <234/255, 242/255, 237/255>;
#declare CN_Glacial_Water_Green = rgb <201/255, 234/255, 212/255>;
#declare CN_Glacier = rgb <120/255, 177/255, 191/255>;
#declare CN_Glacier_Bay = rgb <222/255, 242/255, 238/255>;
#declare CN_Glacier_Blue = rgb <169/255, 193/255, 192/255>;
#declare CN_Glacier_Green = rgb <62/255, 158/255, 172/255>;
#declare CN_Glacier_Grey = rgb <197/255, 198/255, 199/255>;
#declare CN_Glacier_Ivy = rgb <234/255, 243/255, 230/255>;
#declare CN_Glacier_Lake = rgb <98/255, 180/255, 192/255>;
#declare CN_Glacier_Pearl = rgb <209/255, 210/255, 220/255>;
#declare CN_Glacier_Point = rgb <179/255, 216/255, 229/255>;
#declare CN_Glacier_Valley = rgb <226/255, 227/255, 215/255>;
#declare CN_Glad_Yellow = rgb <245/255, 225/255, 172/255>;
#declare CN_Glade = rgb <156/255, 166/255, 135/255>;
#declare CN_Glade_Green = rgb <95/255, 129/255, 81/255>;
#declare CN_Gladeye = rgb <122/255, 140/255, 166/255>;
#declare CN_Gladiator_Grey = rgb <110/255, 108/255, 94/255>;
#declare CN_Gladiator_Leather = rgb <169/255, 92/255, 62/255>;
#declare CN_Gladiola = rgb <213/255, 79/255, 67/255>;
#declare CN_Gladiola_Blue = rgb <99/255, 112/255, 182/255>;
#declare CN_Gladiola_Violet = rgb <110/255, 81/255, 120/255>;
#declare CN_Glam = rgb <207/255, 116/255, 140/255>;
#declare CN_Glamorgan_Sausage = rgb <218/255, 203/255, 167/255>;
#declare CN_Glamorous = rgb <183/255, 78/255, 100/255>;
#declare CN_Glamorous_White = rgb <240/255, 234/255, 224/255>;
#declare CN_Glamour = rgb <219/255, 157/255, 167/255>;
#declare CN_Glamour_Pink = rgb <255/255, 29/255, 205/255>;
#declare CN_Glamour_White = rgb <255/255, 252/255, 236/255>;
#declare CN_Glasgow_Fog = rgb <189/255, 184/255, 174/255>;
#declare CN_Glass_Bead = rgb <199/255, 190/255, 196/255>;
#declare CN_Glass_Bottle = rgb <147/255, 186/255, 89/255>;
#declare CN_Glass_Bull = rgb <136/255, 0/255, 0/255>;
#declare CN_Glass_Green = rgb <220/255, 223/255, 176/255>;
#declare CN_Glass_Jar_Blue = rgb <32/255, 178/255, 170/255>;
#declare CN_Glass_Of_Milk = rgb <252/255, 243/255, 221/255>;
#declare CN_Glass_Sand = rgb <205/255, 182/255, 155/255>;
#declare CN_Glass_Sapphire = rgb <88/255, 123/255, 155/255>;
#declare CN_Glass_Sea = rgb <9/255, 93/255, 117/255>;
#declare CN_Glass_Tile = rgb <205/255, 208/255, 192/255>;
#declare CN_Glass_Violet = rgb <183/255, 162/255, 204/255>;
#declare CN_Glassine = rgb <215/255, 226/255, 229/255>;
#declare CN_Glaucous = rgb <96/255, 130/255, 182/255>;
#declare CN_Glaze_White = rgb <234/255, 225/255, 223/255>;
#declare CN_Glazed_Carrot = rgb <233/255, 105/255, 44/255>;
#declare CN_Glazed_Chestnut = rgb <150/255, 114/255, 23/255>;
#declare CN_Glazed_Ginger = rgb <145/255, 85/255, 43/255>;
#declare CN_Glazed_Granite = rgb <91/255, 94/255, 97/255>;
#declare CN_Glazed_Pears = rgb <239/255, 227/255, 210/255>;
#declare CN_Glazed_Pecan = rgb <209/255, 149/255, 100/255>;
#declare CN_Glazed_Persimmon = rgb <211/255, 78/255, 54/255>;
#declare CN_Glazed_Pot = rgb <173/255, 115/255, 86/255>;
#declare CN_Glazed_Raspberry = rgb <164/255, 75/255, 98/255>;
#declare CN_Glazed_Ringlet = rgb <137/255, 98/255, 109/255>;
#declare CN_Glazed_Sugar = rgb <255/255, 220/255, 204/255>;
#declare CN_Gleam = rgb <191/255, 209/255, 173/255>;
#declare CN_Gleaming_Shells = rgb <248/255, 222/255, 209/255>;
#declare CN_Gleeful = rgb <157/255, 187/255, 125/255>;
#declare CN_Glen = rgb <74/255, 172/255, 114/255>;
#declare CN_Glen_Falls = rgb <172/255, 184/255, 193/255>;
#declare CN_Glendale = rgb <161/255, 187/255, 139/255>;
#declare CN_Glenwood_Green = rgb <167/255, 211/255, 183/255>;
#declare CN_Glide_Time = rgb <93/255, 111/255, 128/255>;
#declare CN_Glimmer = rgb <225/255, 232/255, 227/255>;
#declare CN_Glimpse = rgb <79/255, 185/255, 206/255>;
#declare CN_Glimpse_into_Space = rgb <18/255, 18/255, 16/255>;
#declare CN_Glimpse_of_Pink = rgb <255/255, 243/255, 244/255>;
#declare CN_Glimpse_of_Void = rgb <51/255, 85/255, 136/255>;
#declare CN_Glisten_Green = rgb <242/255, 239/255, 220/255>;
#declare CN_Glisten_Yellow = rgb <245/255, 230/255, 172/255>;
#declare CN_Glistening = rgb <238/255, 210/255, 136/255>;
#declare CN_Glistening_Grey = rgb <177/255, 179/255, 190/255>;
#declare CN_Glitch = rgb <44/255, 84/255, 99/255>;
#declare CN_Glitchy_Shader_Blue = rgb <153/255, 255/255, 255/255>;
#declare CN_Glitter = rgb <230/255, 232/255, 250/255>;
#declare CN_Glitter_is_not_Gold = rgb <254/255, 220/255, 87/255>;
#declare CN_Glitter_Lake = rgb <68/255, 187/255, 255/255>;
#declare CN_Glitter_Shower = rgb <136/255, 255/255, 255/255>;
#declare CN_Glitter_Yellow = rgb <248/255, 215/255, 90/255>;
#declare CN_Glitterati = rgb <148/255, 74/255, 99/255>;
#declare CN_Glittering_Gemstone = rgb <222/255, 192/255, 226/255>;
#declare CN_Glittering_Sun = rgb <211/255, 173/255, 119/255>;
#declare CN_Glittery_Glow = rgb <238/255, 237/255, 219/255>;
#declare CN_Glittery_Yellow = rgb <249/255, 238/255, 205/255>;
#declare CN_Glitz_and_Glamour = rgb <150/255, 95/255, 115/255>;
#declare CN_Glitzy_Gold = rgb <214/255, 160/255, 43/255>;
#declare CN_Glitzy_Red = rgb <175/255, 65/255, 59/255>;
#declare CN_Global_Green = rgb <105/255, 110/255, 81/255>;
#declare CN_Global_Warming = rgb <241/255, 215/255, 211/255>;
#declare CN_Globe_Artichoke = rgb <95/255, 108/255, 60/255>;
#declare CN_Globe_Thistle = rgb <46/255, 3/255, 41/255>;
#declare CN_Globe_Thistle_Grey_Rose = rgb <153/255, 141/255, 141/255>;
#declare CN_Gloomy_Blue = rgb <60/255, 65/255, 106/255>;
#declare CN_Gloomy_Purple = rgb <135/255, 86/255, 228/255>;
#declare CN_Gloomy_Sea = rgb <74/255, 101/255, 122/255>;
#declare CN_Glorious_Gold = rgb <203/255, 169/255, 86/255>;
#declare CN_Glorious_Green_Glitter = rgb <170/255, 238/255, 17/255>;
#declare CN_Glossy_Black = rgb <17/255, 0/255, 17/255>;
#declare CN_Glossy_Gold = rgb <255/255, 221/255, 119/255>;
#declare CN_Glossy_Grape = rgb <171/255, 146/255, 179/255>;
#declare CN_Glossy_Kiss = rgb <238/255, 227/255, 222/255>;
#declare CN_Glossy_Olive = rgb <99/255, 99/255, 64/255>;
#declare CN_Glow = rgb <249/255, 242/255, 218/255>;
#declare CN_Glow_in_the_Dark = rgb <190/255, 253/255, 183/255>;
#declare CN_Glow_Pink = rgb <216/255, 151/255, 158/255>;
#declare CN_Glow_Worm = rgb <190/255, 213/255, 101/255>;
#declare CN_Glowing_Brake_Disc = rgb <238/255, 68/255, 68/255>;
#declare CN_Glowing_Coals = rgb <188/255, 77/255, 57/255>;
#declare CN_Glowing_Firelight = rgb <175/255, 89/255, 65/255>;
#declare CN_Glowing_Lantern = rgb <251/255, 183/255, 54/255>;
#declare CN_Glowing_Meteor = rgb <238/255, 68/255, 0/255>;
#declare CN_Glowing_Scarlet = rgb <189/255, 70/255, 73/255>;
#declare CN_Glowlight = rgb <255/255, 246/255, 185/255>;
#declare CN_Gloxinia = rgb <98/255, 46/255, 90/255>;
#declare CN_Gluon_Grey = rgb <26/255, 27/255, 28/255>;
#declare CN_Gluten = rgb <221/255, 204/255, 102/255>;
#declare CN_Gnarls_Green = rgb <0/255, 117/255, 75/255>;
#declare CN_Gnocchi_Beige = rgb <255/255, 238/255, 187/255>;
#declare CN_Gnome = rgb <129/255, 161/255, 155/255>;
#declare CN_Gnome_Green = rgb <196/255, 188/255, 132/255>;
#declare CN_Gnu_Tan = rgb <176/255, 159/255, 132/255>;
#declare CN_Go_Alpha = rgb <0/255, 127/255, 135/255>;
#declare CN_Go_Bananas = rgb <247/255, 202/255, 80/255>;
#declare CN_Go_Ben = rgb <120/255, 110/255, 76/255>;
#declare CN_Go_Go_Glow = rgb <252/255, 236/255, 213/255>;
#declare CN_Go_Go_Green = rgb <0/255, 138/255, 125/255>;
#declare CN_Go_Go_Lime = rgb <198/255, 190/255, 107/255>;
#declare CN_Go_Go_Mango = rgb <254/255, 184/255, 126/255>;
#declare CN_Go_Go_Pink = rgb <253/255, 216/255, 212/255>;
#declare CN_Go_Green_ = rgb <0/255, 171/255, 102/255>;
#declare CN_Go_To_Grey = rgb <220/255, 216/255, 215/255>;
#declare CN_Goat = rgb <168/255, 154/255, 145/255>;
#declare CN_Gobelin_Mauve = rgb <94/255, 90/255, 106/255>;
#declare CN_Gobi_Desert = rgb <205/255, 187/255, 162/255>;
#declare CN_Gobi_Sand = rgb <212/255, 170/255, 111/255>;
#declare CN_Gobi_Tan = rgb <187/255, 165/255, 135/255>;
#declare CN_Goblin = rgb <52/255, 83/255, 61/255>;
#declare CN_Goblin_Blue = rgb <95/255, 114/255, 120/255>;
#declare CN_Goblin_Eyes = rgb <235/255, 137/255, 49/255>;
#declare CN_Goblin_Green = rgb <118/255, 255/255, 122/255>;
#declare CN_Goblin_Warboss = rgb <78/255, 253/255, 84/255>;
#declare CN_Gobo_Brown = rgb <99/255, 81/255, 71/255>;
#declare CN_Gochujang_Red = rgb <119/255, 0/255, 0/255>;
#declare CN_God_of_Nights = rgb <85/255, 0/255, 102/255>;
#declare CN_God_of_Rain = rgb <68/255, 102/255, 204/255>;
#declare CN_God_Given = rgb <250/255, 244/255, 224/255>;
#declare CN_God_s_Own_Junkyard_Pink = rgb <245/255, 105/255, 145/255>;
#declare CN_Goddess = rgb <208/255, 225/255, 232/255>;
#declare CN_Goddess_Green = rgb <118/255, 173/255, 131/255>;
#declare CN_Goddess_of_Dawn = rgb <168/255, 212/255, 176/255>;
#declare CN_Godzilla = rgb <60/255, 77/255, 3/255>;
#declare CN_Gogo_Blue = rgb <0/255, 135/255, 161/255>;
#declare CN_Going_Grey = rgb <131/255, 128/255, 122/255>;
#declare CN_Goji_Berry = rgb <185/255, 18/255, 40/255>;
#declare CN_Goku_Orange = rgb <240/255, 131/255, 58/255>;
#declare CN_Gold = rgb <255/255, 215/255, 0/255>;
#declare CN_Gold_Black = rgb <42/255, 36/255, 36/255>;
#declare CN_Gold_Buff = rgb <236/255, 196/255, 129/255>;
#declare CN_Gold_Bullion = rgb <238/255, 221/255, 153/255>;
#declare CN_Gold_Buttercup = rgb <255/255, 232/255, 187/255>;
#declare CN_Gold_Canyon = rgb <174/255, 151/255, 105/255>;
#declare CN_Gold_Coast = rgb <199/255, 133/255, 56/255>;
#declare CN_Gold_Crest = rgb <223/255, 153/255, 56/255>;
#declare CN_Gold_Deposit = rgb <224/255, 206/255, 87/255>;
#declare CN_Gold_Digger = rgb <209/255, 176/255, 117/255>;
#declare CN_Gold_Drop = rgb <213/255, 108/255, 48/255>;
#declare CN_Gold_Dust = rgb <164/255, 128/255, 63/255>;
#declare CN_Gold_Earth = rgb <221/255, 156/255, 107/255>;
#declare CN_Gold_Estate = rgb <151/255, 122/255, 65/255>;
#declare CN_Gold_Flame = rgb <180/255, 84/255, 34/255>;
#declare CN_Gold_Foil = rgb <217/255, 159/255, 77/255>;
#declare CN_Gold_Fusion = rgb <255/255, 176/255, 0/255>;
#declare CN_Gold_Gleam = rgb <207/255, 179/255, 82/255>;
#declare CN_Gold_Hearted = rgb <230/255, 194/255, 140/255>;
#declare CN_Gold_Metal = rgb <177/255, 119/255, 67/255>;
#declare CN_Gold_of_Midas = rgb <255/255, 234/255, 199/255>;
#declare CN_Gold_Orange = rgb <219/255, 114/255, 16/255>;
#declare CN_Gold_Pheasant = rgb <198/255, 121/255, 95/255>;
#declare CN_Gold_Plate = rgb <230/255, 189/255, 143/255>;
#declare CN_Gold_Plated = rgb <176/255, 131/255, 79/255>;
#declare CN_Gold_Ransom = rgb <179/255, 146/255, 96/255>;
#declare CN_Gold_Red = rgb <235/255, 84/255, 6/255>;
#declare CN_Gold_Rush = rgb <196/255, 167/255, 119/255>;
#declare CN_Gold_Sand = rgb <247/255, 229/255, 169/255>;
#declare CN_Gold_Season = rgb <177/255, 153/255, 113/255>;
#declare CN_Gold_Sparkle = rgb <120/255, 107/255, 61/255>;
#declare CN_Gold_Spell = rgb <193/255, 157/255, 97/255>;
#declare CN_Gold_Spike = rgb <144/255, 112/255, 71/255>;
#declare CN_Gold_Strand = rgb <243/255, 223/255, 166/255>;
#declare CN_Gold_Taffeta = rgb <187/255, 154/255, 57/255>;
#declare CN_Gold_Tangiers = rgb <158/255, 134/255, 94/255>;
#declare CN_Gold_Thread = rgb <254/255, 232/255, 176/255>;
#declare CN_Gold_Tips = rgb <226/255, 178/255, 39/255>;
#declare CN_Gold_Tooth = rgb <219/255, 180/255, 12/255>;
#declare CN_Gold_Torch = rgb <189/255, 149/255, 94/255>;
#declare CN_Gold_Tweed = rgb <201/255, 171/255, 115/255>;
#declare CN_Gold_Varnish_Brown = rgb <185/255, 94/255, 51/255>;
#declare CN_Gold_Vein = rgb <214/255, 185/255, 86/255>;
#declare CN_Gold_Vessel = rgb <234/255, 186/255, 138/255>;
#declare CN_Gold_Wash = rgb <212/255, 193/255, 158/255>;
#declare CN_Golds_Great_Touch = rgb <255/255, 194/255, 101/255>;
#declare CN_Goldbrown = rgb <156/255, 138/255, 83/255>;
#declare CN_Golden = rgb <245/255, 191/255, 3/255>;
#declare CN_Golden_Age = rgb <206/255, 171/255, 119/255>;
#declare CN_Golden_Appeal = rgb <230/255, 190/255, 89/255>;
#declare CN_Golden_Apricot = rgb <221/255, 167/255, 88/255>;
#declare CN_Golden_Aura = rgb <210/255, 158/255, 104/255>;
#declare CN_Golden_Aurelia = rgb <255/255, 238/255, 119/255>;
#declare CN_Golden_Banner = rgb <252/255, 198/255, 42/255>;
#declare CN_Golden_Bear = rgb <186/255, 152/255, 95/255>;
#declare CN_Golden_Beige = rgb <206/255, 162/255, 119/255>;
#declare CN_Golden_Bell = rgb <202/255, 129/255, 54/255>;
#declare CN_Golden_Beryl_Yellow = rgb <217/255, 164/255, 0/255>;
#declare CN_Golden_Blond = rgb <204/255, 170/255, 85/255>;
#declare CN_Golden_Blood = rgb <255/255, 17/255, 85/255>;
#declare CN_Golden_Boy = rgb <255/255, 221/255, 68/255>;
#declare CN_Golden_Brown = rgb <178/255, 122/255, 1/255>;
#declare CN_Golden_Buddha_Belly = rgb <255/255, 204/255, 34/255>;
#declare CN_Golden_Buff = rgb <248/255, 230/255, 200/255>;
#declare CN_Golden_Cadillac = rgb <172/255, 134/255, 75/255>;
#declare CN_Golden_Cartridge = rgb <189/255, 183/255, 107/255>;
#declare CN_Golden_Chalice = rgb <231/255, 192/255, 104/255>;
#declare CN_Golden_Chandelier = rgb <221/255, 221/255, 17/255>;
#declare CN_Golden_Coin = rgb <252/255, 217/255, 117/255>;
#declare CN_Golden_Cream = rgb <247/255, 183/255, 104/255>;
#declare CN_Golden_Crest = rgb <246/255, 202/255, 105/255>;
#declare CN_Golden_Crested_Wren = rgb <204/255, 221/255, 187/255>;
#declare CN_Golden_Cricket = rgb <215/255, 176/255, 86/255>;
#declare CN_Golden_Delicious = rgb <210/255, 216/255, 143/255>;
#declare CN_Golden_Dream = rgb <241/255, 204/255, 43/255>;
#declare CN_Golden_Ecru = rgb <216/255, 195/255, 159/255>;
#declare CN_Golden_Egg = rgb <178/255, 145/255, 85/255>;
#declare CN_Golden_Elm = rgb <189/255, 213/255, 177/255>;
#declare CN_Golden_Field = rgb <195/255, 158/255, 68/255>;
#declare CN_Golden_Fizz = rgb <235/255, 222/255, 49/255>;
#declare CN_Golden_Fleece = rgb <237/255, 217/255, 170/255>;
#declare CN_Golden_Fog = rgb <240/255, 234/255, 210/255>;
#declare CN_Golden_Foil = rgb <204/255, 204/255, 0/255>;
#declare CN_Golden_Foliage = rgb <189/255, 208/255, 67/255>;
#declare CN_Golden_Fragrance = rgb <238/255, 238/255, 153/255>;
#declare CN_Golden_Freesia = rgb <135/255, 111/255, 77/255>;
#declare CN_Golden_Gate = rgb <217/255, 192/255, 156/255>;
#declare CN_Golden_Gate_Bridge = rgb <192/255, 54/255, 45/255>;
#declare CN_Golden_Ginkgo = rgb <249/255, 245/255, 37/255>;
#declare CN_Golden_Glam = rgb <238/255, 187/255, 68/255>;
#declare CN_Golden_Glitter = rgb <251/255, 229/255, 115/255>;
#declare CN_Golden_Glove = rgb <158/255, 117/255, 81/255>;
#declare CN_Golden_Glow = rgb <249/255, 215/255, 126/255>;
#declare CN_Golden_Grain = rgb <197/255, 145/255, 55/255>;
#declare CN_Golden_Granola = rgb <184/255, 153/255, 107/255>;
#declare CN_Golden_Grass = rgb <218/255, 166/255, 49/255>;
#declare CN_Golden_Green = rgb <189/255, 179/255, 105/255>;
#declare CN_Golden_Griffon = rgb <169/255, 144/255, 88/255>;
#declare CN_Golden_Guernsey = rgb <225/255, 195/255, 187/255>;
#declare CN_Golden_Gun = rgb <221/255, 221/255, 0/255>;
#declare CN_Golden_Hamster = rgb <218/255, 158/255, 56/255>;
#declare CN_Golden_Handshake = rgb <255/255, 204/255, 68/255>;
#declare CN_Golden_Harmony = rgb <159/255, 128/255, 70/255>;
#declare CN_Golden_Harvest = rgb <204/255, 204/255, 17/255>;
#declare CN_Golden_Haystack = rgb <237/255, 223/255, 193/255>;
#declare CN_Golden_Haze = rgb <251/255, 216/255, 151/255>;
#declare CN_Golden_Hermes = rgb <255/255, 255/255, 187/255>;
#declare CN_Golden_Hind = rgb <163/255, 113/255, 17/255>;
#declare CN_Golden_History = rgb <187/255, 153/255, 58/255>;
#declare CN_Golden_Hominy = rgb <237/255, 194/255, 131/255>;
#declare CN_Golden_Hop = rgb <207/255, 221/255, 123/255>;
#declare CN_Golden_Impression = rgb <255/255, 239/255, 203/255>;
#declare CN_Golden_Key = rgb <221/255, 153/255, 17/255>;
#declare CN_Golden_Kiwi = rgb <243/255, 221/255, 62/255>;
#declare CN_Golden_Koi = rgb <234/255, 163/255, 75/255>;
#declare CN_Golden_Lake = rgb <216/255, 199/255, 162/255>;
#declare CN_Golden_Leaf = rgb <196/255, 139/255, 66/255>;
#declare CN_Golden_Lime = rgb <154/255, 151/255, 56/255>;
#declare CN_Golden_Lion_Tamarin = rgb <202/255, 96/255, 42/255>;
#declare CN_Golden_Lock = rgb <245/255, 188/255, 29/255>;
#declare CN_Golden_Lotus = rgb <233/255, 219/255, 196/255>;
#declare CN_Golden_Marguerite = rgb <253/255, 204/255, 55/255>;
#declare CN_Golden_Mary = rgb <240/255, 190/255, 58/255>;
#declare CN_Golden_Mist = rgb <213/255, 205/255, 148/255>;
#declare CN_Golden_Moray_Eel = rgb <255/255, 207/255, 96/255>;
#declare CN_Golden_Mushroom = rgb <244/255, 232/255, 209/255>;
#declare CN_Golden_Nectar = rgb <255/255, 218/255, 104/255>;
#declare CN_Golden_Nugget = rgb <219/255, 155/255, 89/255>;
#declare CN_Golden_Oak = rgb <190/255, 117/255, 45/255>;
#declare CN_Golden_Oat_Coloured = rgb <236/255, 190/255, 145/255>;
#declare CN_Golden_Ochre = rgb <199/255, 121/255, 67/255>;
#declare CN_Golden_Olive = rgb <175/255, 152/255, 65/255>;
#declare CN_Golden_Opportunity = rgb <247/255, 192/255, 112/255>;
#declare CN_Golden_Orange = rgb <215/255, 148/255, 45/255>;
#declare CN_Golden_Palm = rgb <170/255, 136/255, 5/255>;
#declare CN_Golden_Passionfruit = rgb <180/255, 187/255, 49/255>;
#declare CN_Golden_Pastel = rgb <244/255, 217/255, 185/255>;
#declare CN_Golden_Pheasant = rgb <207/255, 150/255, 50/255>;
#declare CN_Golden_Pilsner = rgb <149/255, 111/255, 63/255>;
#declare CN_Golden_Plumeria = rgb <251/255, 208/255, 115/255>;
#declare CN_Golden_Pop = rgb <235/255, 206/255, 189/255>;
#declare CN_Golden_Poppy = rgb <252/255, 194/255, 0/255>;
#declare CN_Golden_Pumpkin = rgb <202/255, 136/255, 75/255>;
#declare CN_Golden_Quartz_Ochre = rgb <170/255, 138/255, 88/255>;
#declare CN_Golden_Rain_Yellow = rgb <255/255, 182/255, 87/255>;
#declare CN_Golden_Raspberry = rgb <248/255, 216/255, 120/255>;
#declare CN_Golden_Rays = rgb <246/255, 218/255, 116/255>;
#declare CN_Golden_Relic = rgb <232/255, 206/255, 73/255>;
#declare CN_Golden_Retriever = rgb <238/255, 222/255, 199/255>;
#declare CN_Golden_Rice = rgb <227/255, 212/255, 116/255>;
#declare CN_Golden_Rule = rgb <218/255, 174/255, 73/255>;
#declare CN_Golden_Sage = rgb <176/255, 157/255, 115/255>;
#declare CN_Golden_Sand = rgb <234/255, 206/255, 106/255>;
#declare CN_Golden_Schnitzel = rgb <221/255, 187/255, 17/255>;
#declare CN_Golden_Slumber = rgb <185/255, 136/255, 65/255>;
#declare CN_Golden_Snitch = rgb <241/255, 227/255, 70/255>;
#declare CN_Golden_Spice = rgb <198/255, 151/255, 63/255>;
#declare CN_Golden_Staff = rgb <247/255, 235/255, 131/255>;
#declare CN_Golden_Straw = rgb <245/255, 237/255, 174/255>;
#declare CN_Golden_Summer = rgb <129/255, 105/255, 69/255>;
#declare CN_Golden_Syrup = rgb <235/255, 216/255, 179/255>;
#declare CN_Golden_Tainoi = rgb <255/255, 193/255, 82/255>;
#declare CN_Golden_Thistle_Yellow = rgb <202/255, 163/255, 117/255>;
#declare CN_Golden_Thread = rgb <232/255, 196/255, 122/255>;
#declare CN_Golden_Wash = rgb <255/255, 254/255, 198/255>;
#declare CN_Golden_Weave = rgb <234/255, 220/255, 192/255>;
#declare CN_Golden_West = rgb <233/255, 202/255, 148/255>;
#declare CN_Golden_Yarrow = rgb <226/255, 199/255, 79/255>;
#declare CN_Golden_Yellow = rgb <255/255, 223/255, 0/255>;
#declare CN_Goldenrod = rgb <253/255, 203/255, 24/255>;
#declare CN_Goldenrod_Field = rgb <240/255, 176/255, 83/255>;
#declare CN_Goldenrod_Tea = rgb <161/255, 120/255, 65/255>;
#declare CN_Goldenrod_Yellow = rgb <255/255, 206/255, 143/255>;
#declare CN_Goldfinch = rgb <248/255, 220/255, 108/255>;
#declare CN_Goldfinger = rgb <238/255, 187/255, 17/255>;
#declare CN_Goldfish = rgb <242/255, 173/255, 98/255>;
#declare CN_Goldie = rgb <200/255, 157/255, 63/255>;
#declare CN_Goldie_Oldie = rgb <186/255, 173/255, 117/255>;
#declare CN_Goldilocks = rgb <255/255, 243/255, 154/255>;
#declare CN_Goldvreneli_1882 = rgb <231/255, 222/255, 84/255>;
#declare CN_Golem = rgb <131/255, 110/255, 89/255>;
#declare CN_Golf_Blazer = rgb <83/255, 163/255, 145/255>;
#declare CN_Golf_Course = rgb <90/255, 158/255, 75/255>;
#declare CN_Golf_Day = rgb <90/255, 139/255, 63/255>;
#declare CN_Golf_Green = rgb <0/255, 135/255, 99/255>;
#declare CN_Golfer_Green = rgb <94/255, 104/255, 65/255>;
#declare CN_Golgfag_Brown = rgb <215/255, 126/255, 112/255>;
#declare CN_Goluboy_Blue = rgb <139/255, 185/255, 221/255>;
#declare CN_Gomashio_Yellow = rgb <204/255, 153/255, 51/255>;
#declare CN_Gondola = rgb <55/255, 51/255, 50/255>;
#declare CN_Gondolier = rgb <93/255, 177/255, 197/255>;
#declare CN_Gone_Giddy = rgb <217/255, 199/255, 55/255>;
#declare CN_Gonzo_Violet = rgb <93/255, 6/255, 233/255>;
#declare CN_Good_Graces = rgb <243/255, 240/255, 214/255>;
#declare CN_Good_Karma = rgb <51/255, 60/255, 118/255>;
#declare CN_Good_Life = rgb <196/255, 158/255, 105/255>;
#declare CN_Good_Luck = rgb <134/255, 201/255, 148/255>;
#declare CN_Good_Luck_Charm = rgb <157/255, 134/255, 92/255>;
#declare CN_Good_Morning = rgb <252/255, 252/255, 218/255>;
#declare CN_Good_Morning_Akihabara = rgb <244/255, 234/255, 213/255>;
#declare CN_Good_Night_ = rgb <70/255, 86/255, 95/255>;
#declare CN_Good_Samaritan = rgb <63/255, 103/255, 130/255>;
#declare CN_Good_Looking = rgb <237/255, 210/255, 167/255>;
#declare CN_Goodbye_Kiss = rgb <217/255, 202/255, 195/255>;
#declare CN_Goody_Gumdrop = rgb <204/255, 216/255, 122/255>;
#declare CN_Goody_Two_Shoes = rgb <194/255, 186/255, 142/255>;
#declare CN_Goose_Bill = rgb <255/255, 186/255, 128/255>;
#declare CN_Goose_Down = rgb <244/255, 231/255, 223/255>;
#declare CN_Goose_Pond_Green = rgb <98/255, 155/255, 146/255>;
#declare CN_Goose_Wing_Grey = rgb <168/255, 157/255, 172/255>;
#declare CN_Gooseberry_Fool = rgb <172/255, 183/255, 95/255>;
#declare CN_Gooseberry_Yellow = rgb <199/255, 169/255, 74/255>;
#declare CN_Gora_White = rgb <240/255, 240/255, 224/255>;
#declare CN_Gordons_Green = rgb <41/255, 51/255, 43/255>;
#declare CN_Gorgeous_Green = rgb <40/255, 124/255, 55/255>;
#declare CN_Gorgeous_Hydrangea = rgb <164/255, 149/255, 203/255>;
#declare CN_Gorgeous_White = rgb <231/255, 219/255, 211/255>;
#declare CN_Gorgonzola_Blue = rgb <68/255, 85/255, 204/255>;
#declare CN_Gorse = rgb <253/255, 227/255, 54/255>;
#declare CN_Gorse_Yellow_Orange = rgb <233/255, 154/255, 60/255>;
#declare CN_Gorthor_Brown = rgb <101/255, 71/255, 65/255>;
#declare CN_Gory_Movie = rgb <180/255, 36/255, 53/255>;
#declare CN_Gory_Red = rgb <163/255, 8/255, 0/255>;
#declare CN_Goshawk_Grey = rgb <68/255, 68/255, 68/255>;
#declare CN_Gossamer = rgb <57/255, 159/255, 134/255>;
#declare CN_Gossamer_Green = rgb <178/255, 207/255, 190/255>;
#declare CN_Gossamer_Pink = rgb <250/255, 200/255, 195/255>;
#declare CN_Gossamer_Veil = rgb <211/255, 206/255, 196/255>;
#declare CN_Gossamer_Wings = rgb <232/255, 238/255, 233/255>;
#declare CN_Gossip = rgb <159/255, 211/255, 133/255>;
#declare CN_Gotham_Grey = rgb <138/255, 145/255, 146/255>;
#declare CN_Gothic = rgb <105/255, 136/255, 144/255>;
#declare CN_Gothic_Amethyst = rgb <163/255, 139/255, 147/255>;
#declare CN_Gothic_Gold = rgb <187/255, 133/255, 47/255>;
#declare CN_Gothic_Grape = rgb <71/255, 57/255, 81/255>;
#declare CN_Gothic_Olive = rgb <124/255, 110/255, 79/255>;
#declare CN_Gothic_Purple = rgb <146/255, 131/255, 138/255>;
#declare CN_Gothic_Revival_Green = rgb <160/255, 161/255, 96/255>;
#declare CN_Gothic_Spire = rgb <124/255, 107/255, 111/255>;
#declare CN_Gotta_Have_It = rgb <208/255, 194/255, 180/255>;
#declare CN_Gouda_Gold = rgb <238/255, 204/255, 17/255>;
#declare CN_Goulash = rgb <141/255, 100/255, 73/255>;
#declare CN_Gould_Blue = rgb <125/255, 158/255, 162/255>;
#declare CN_Gould_Gold = rgb <188/255, 157/255, 112/255>;
#declare CN_Gourmet_Honey = rgb <227/255, 203/255, 168/255>;
#declare CN_Gourmet_Mushroom = rgb <150/255, 141/255, 140/255>;
#declare CN_Government_Green = rgb <50/255, 73/255, 62/255>;
#declare CN_Governor_Bay = rgb <81/255, 85/255, 155/255>;
#declare CN_Graceful = rgb <168/255, 192/255, 206/255>;
#declare CN_Graceful_Ballerina = rgb <221/255, 137/255, 124/255>;
#declare CN_Graceful_Flower = rgb <189/255, 223/255, 178/255>;
#declare CN_Graceful_Garden = rgb <203/255, 169/255, 208/255>;
#declare CN_Graceful_Gazelle = rgb <167/255, 138/255, 80/255>;
#declare CN_Graceful_Green = rgb <172/255, 183/255, 168/255>;
#declare CN_Graceful_Grey = rgb <190/255, 182/255, 172/255>;
#declare CN_Graceful_Mint = rgb <218/255, 238/255, 213/255>;
#declare CN_Graceland_Grass = rgb <84/255, 108/255, 70/255>;
#declare CN_Gracilis = rgb <196/255, 213/255, 203/255>;
#declare CN_Gracious = rgb <248/255, 237/255, 215/255>;
#declare CN_Gracious_Glow = rgb <186/255, 176/255, 120/255>;
#declare CN_Gracious_Rose = rgb <227/255, 183/255, 177/255>;
#declare CN_Graham_Cracker = rgb <192/255, 164/255, 128/255>;
#declare CN_Graham_Crust = rgb <128/255, 98/255, 64/255>;
#declare CN_Grain_Brown = rgb <202/255, 184/255, 162/255>;
#declare CN_Grain_Mill = rgb <216/255, 192/255, 149/255>;
#declare CN_Grain_of_Salt = rgb <216/255, 219/255, 225/255>;
#declare CN_Grain_White = rgb <239/255, 227/255, 216/255>;
#declare CN_Grainfield = rgb <183/255, 158/255, 102/255>;
#declare CN_Grams_Hair = rgb <245/255, 246/255, 247/255>;
#declare CN_Gran_Torino_Red = rgb <238/255, 51/255, 0/255>;
#declare CN_Granada_Sky = rgb <93/255, 129/255, 187/255>;
#declare CN_Grand_Avenue = rgb <102/255, 90/255, 72/255>;
#declare CN_Grand_Bleu = rgb <1/255, 84/255, 130/255>;
#declare CN_Grand_Canal = rgb <60/255, 121/255, 125/255>;
#declare CN_Grand_Grape = rgb <100/255, 87/255, 100/255>;
#declare CN_Grand_Gusto = rgb <134/255, 187/255, 157/255>;
#declare CN_Grand_Heron = rgb <236/255, 236/255, 225/255>;
#declare CN_Grand_Piano = rgb <216/255, 208/255, 189/255>;
#declare CN_Grand_Plum = rgb <108/255, 86/255, 87/255>;
#declare CN_Grand_Poobah = rgb <134/255, 71/255, 100/255>;
#declare CN_Grand_Purple = rgb <83/255, 71/255, 120/255>;
#declare CN_Grand_Rapids = rgb <56/255, 112/255, 126/255>;
#declare CN_Grand_Soiree = rgb <217/255, 194/255, 168/255>;
#declare CN_Grand_Sunset = rgb <195/255, 141/255, 135/255>;
#declare CN_Grandeur_Plum = rgb <146/255, 87/255, 111/255>;
#declare CN_Grandiflora_Rose = rgb <224/255, 235/255, 175/255>;
#declare CN_Grandiose = rgb <202/255, 168/255, 76/255>;
#declare CN_Grandis = rgb <255/255, 205/255, 115/255>;
#declare CN_Grandmas_Cameo = rgb <247/255, 231/255, 221/255>;
#declare CN_Grandview = rgb <107/255, 146/255, 127/255>;
#declare CN_Grange_Hall = rgb <133/255, 119/255, 103/255>;
#declare CN_Granita = rgb <165/255, 35/255, 80/255>;
#declare CN_Granite = rgb <116/255, 106/255, 94/255>;
#declare CN_Granite_Black = rgb <49/255, 50/255, 56/255>;
#declare CN_Granite_Boulder = rgb <129/255, 111/255, 107/255>;
#declare CN_Granite_Brown = rgb <61/255, 45/255, 36/255>;
#declare CN_Granite_Canyon = rgb <108/255, 111/255, 120/255>;
#declare CN_Granite_Dust = rgb <215/255, 206/255, 196/255>;
#declare CN_Granite_Falls = rgb <99/255, 132/255, 150/255>;
#declare CN_Granite_Green = rgb <139/255, 130/255, 101/255>;
#declare CN_Granite_Grey = rgb <97/255, 94/255, 95/255>;
#declare CN_Granite_Peak = rgb <96/255, 107/255, 117/255>;
#declare CN_Granny_Apple = rgb <197/255, 231/255, 205/255>;
#declare CN_Granny_Smith = rgb <123/255, 148/255, 140/255>;
#declare CN_Granny_Smith_Apple = rgb <157/255, 224/255, 147/255>;
#declare CN_Granola = rgb <245/255, 206/255, 159/255>;
#declare CN_Grant_Drab = rgb <143/255, 132/255, 97/255>;
#declare CN_Grant_Grey = rgb <145/255, 143/255, 138/255>;
#declare CN_Grant_Village = rgb <108/255, 144/255, 178/255>;
#declare CN_Grant_Wood_Ivy = rgb <168/255, 185/255, 137/255>;
#declare CN_Granular_Limestone = rgb <227/255, 224/255, 218/255>;
#declare CN_Granulated_Sugar = rgb <255/255, 253/255, 242/255>;
#declare CN_Grape = rgb <108/255, 52/255, 97/255>;
#declare CN_Grape_Arbor = rgb <165/255, 152/255, 199/255>;
#declare CN_Grape_Blue = rgb <36/255, 72/255, 108/255>;
#declare CN_Grape_Candy = rgb <144/255, 82/255, 132/255>;
#declare CN_Grape_Cassata = rgb <223/255, 227/255, 132/255>;
#declare CN_Grape_Compote = rgb <107/255, 88/255, 118/255>;
#declare CN_Grape_Creme = rgb <190/255, 187/255, 187/255>;
#declare CN_Grape_Expectations = rgb <106/255, 88/255, 126/255>;
#declare CN_Grape_Fizz = rgb <100/255, 67/255, 95/255>;
#declare CN_Grape_Gatsby = rgb <161/255, 154/255, 189/255>;
#declare CN_Grape_Glimmer = rgb <220/255, 202/255, 224/255>;
#declare CN_Grape_Green = rgb <168/255, 228/255, 160/255>;
#declare CN_Grape_Grey = rgb <109/255, 97/255, 102/255>;
#declare CN_Grape_Harvest = rgb <128/255, 118/255, 151/255>;
#declare CN_Grape_Haze = rgb <96/255, 106/255, 136/255>;
#declare CN_Grape_Hyacinth = rgb <85/255, 51/255, 204/255>;
#declare CN_Grape_Illusion = rgb <180/255, 166/255, 213/255>;
#declare CN_Grape_Jam = rgb <127/255, 119/255, 154/255>;
#declare CN_Grape_Jelly = rgb <126/255, 102/255, 127/255>;
#declare CN_Grape_Juice = rgb <104/255, 41/255, 97/255>;
#declare CN_Grape_Kiss = rgb <123/255, 67/255, 104/255>;
#declare CN_Grape_Lavender = rgb <194/255, 196/255, 212/255>;
#declare CN_Grape_Leaf = rgb <84/255, 81/255, 68/255>;
#declare CN_Grape_Leaves = rgb <87/255, 96/255, 73/255>;
#declare CN_Grape_Mist = rgb <197/255, 192/255, 201/255>;
#declare CN_Grape_Nectar = rgb <141/255, 92/255, 116/255>;
#declare CN_Grape_Oil_Green = rgb <211/255, 217/255, 206/255>;
#declare CN_Grape_Parfait = rgb <134/255, 119/255, 169/255>;
#declare CN_Grape_Popsicle = rgb <96/255, 64/255, 109/255>;
#declare CN_Grape_Purple = rgb <93/255, 20/255, 81/255>;
#declare CN_Grape_Royale = rgb <79/255, 45/255, 84/255>;
#declare CN_Grape_Shake = rgb <136/255, 105/255, 113/255>;
#declare CN_Grape_Soda = rgb <174/255, 148/255, 166/255>;
#declare CN_Grape_Taffy = rgb <244/255, 218/255, 241/255>;
#declare CN_Grape_Vine = rgb <121/255, 127/255, 90/255>;
#declare CN_Grape_Wine = rgb <90/255, 47/255, 67/255>;
#declare CN_Grapes_Treasure = rgb <190/255, 174/255, 207/255>;
#declare CN_Grapeade = rgb <170/255, 159/255, 178/255>;
#declare CN_Grapefruit = rgb <253/255, 89/255, 86/255>;
#declare CN_Grapefruit_Juice = rgb <238/255, 109/255, 138/255>;
#declare CN_Grapefruit_Pulp = rgb <254/255, 111/255, 94/255>;
#declare CN_Grapefruit_Yellow = rgb <223/255, 160/255, 26/255>;
#declare CN_Grapemist = rgb <131/255, 152/255, 202/255>;
#declare CN_Grapes_of_Wrath = rgb <88/255, 66/255, 76/255>;
#declare CN_Grapeshot = rgb <113/255, 56/255, 75/255>;
#declare CN_Grapest = rgb <136/255, 0/255, 102/255>;
#declare CN_Grapevine = rgb <177/255, 148/255, 166/255>;
#declare CN_Grapevine_Canyon = rgb <98/255, 83/255, 79/255>;
#declare CN_Graphic_Charcoal = rgb <92/255, 94/255, 95/255>;
#declare CN_Graphic_Grape = rgb <130/255, 78/255, 120/255>;
#declare CN_Graphical_80s_Sky = rgb <0/255, 0/255, 252/255>;
#declare CN_Graphite = rgb <56/255, 52/255, 40/255>;
#declare CN_Graphite_Black = rgb <38/255, 42/255, 43/255>;
#declare CN_Graphite_Black_Green = rgb <50/255, 73/255, 75/255>;
#declare CN_Graphite_Grey_Green = rgb <124/255, 118/255, 102/255>;
#declare CN_Grapple = rgb <146/255, 120/255, 106/255>;
#declare CN_Grapy = rgb <120/255, 110/255, 112/255>;
#declare CN_Grasping_Grass = rgb <146/255, 179/255, 0/255>;
#declare CN_Grass = rgb <92/255, 172/255, 45/255>;
#declare CN_Grass_Blade = rgb <99/255, 111/255, 70/255>;
#declare CN_Grass_Cloth = rgb <184/255, 185/255, 126/255>;
#declare CN_Grass_Court = rgb <8/255, 141/255, 70/255>;
#declare CN_Grass_Daisy = rgb <206/255, 176/255, 42/255>;
#declare CN_Grass_Green = rgb <63/255, 155/255, 11/255>;
#declare CN_Grass_Root = rgb <195/255, 193/255, 117/255>;
#declare CN_Grass_Sands = rgb <161/255, 175/255, 160/255>;
#declare CN_Grass_Skirt = rgb <226/255, 218/255, 194/255>;
#declare CN_Grass_Stain_Green = rgb <192/255, 251/255, 45/255>;
#declare CN_Grass_Valley = rgb <244/255, 247/255, 238/255>;
#declare CN_Grasshopper = rgb <119/255, 130/255, 74/255>;
#declare CN_Grasshopper_Wing = rgb <135/255, 134/255, 111/255>;
#declare CN_Grassland = rgb <193/255, 188/255, 167/255>;
#declare CN_Grasslands = rgb <64/255, 117/255, 72/255>;
#declare CN_Grassroots = rgb <216/255, 196/255, 117/255>;
#declare CN_Grassy_Field = rgb <92/255, 125/255, 71/255>;
#declare CN_Grassy_Glade = rgb <216/255, 221/255, 202/255>;
#declare CN_Grassy_Green = rgb <65/255, 156/255, 3/255>;
#declare CN_Grassy_Meadow = rgb <118/255, 165/255, 91/255>;
#declare CN_Grassy_Savannah = rgb <155/255, 146/255, 121/255>;
#declare CN_Grated_Beet = rgb <166/255, 14/255, 70/255>;
#declare CN_Gratefully_Grass = rgb <113/255, 113/255, 78/255>;
#declare CN_Gratifying_Green = rgb <218/255, 226/255, 205/255>;
#declare CN_Gratin_Dauphinois = rgb <224/255, 210/255, 169/255>;
#declare CN_Gratitude = rgb <224/255, 234/255, 215/255>;
#declare CN_Grauzone = rgb <133/255, 163/255, 178/255>;
#declare CN_Gravel = rgb <74/255, 75/255, 70/255>;
#declare CN_Gravel_Dust = rgb <186/255, 185/255, 169/255>;
#declare CN_Gravel_Fint = rgb <187/255, 187/255, 187/255>;
#declare CN_Gravel_Grey_Blue = rgb <99/255, 122/255, 130/255>;
#declare CN_Gravelstone = rgb <211/255, 199/255, 184/255>;
#declare CN_Graveyard_Earth = rgb <104/255, 85/255, 58/255>;
#declare CN_Gravlax = rgb <236/255, 131/255, 79/255>;
#declare CN_Gray_Area = rgb <175/255, 166/255, 150/255>;
#declare CN_Gray_Clouds = rgb <183/255, 183/255, 178/255>;
#declare CN_Gray_Matters = rgb <167/255, 168/255, 162/255>;
#declare CN_Gray_Screen = rgb <198/255, 202/255, 202/255>;
#declare CN_Gray_Shingle = rgb <148/255, 147/255, 146/255>;
#declare CN_Grayish = rgb <207/255, 202/255, 199/255>;
#declare CN_Grays_Harbor = rgb <89/255, 99/255, 104/255>;
#declare CN_Grayve_Yard = rgb <161/255, 161/255, 159/255>;
#declare CN_Great_Blue_Heron = rgb <213/255, 224/255, 238/255>;
#declare CN_Great_Coat_Grey = rgb <127/255, 132/255, 136/255>;
#declare CN_Great_Dane = rgb <209/255, 163/255, 105/255>;
#declare CN_Great_Falls = rgb <159/255, 166/255, 179/255>;
#declare CN_Great_Fennel_Flower = rgb <113/255, 155/255, 162/255>;
#declare CN_Great_Frontier = rgb <144/255, 134/255, 117/255>;
#declare CN_Great_Grape = rgb <107/255, 109/255, 133/255>;
#declare CN_Great_Graphite = rgb <165/255, 166/255, 161/255>;
#declare CN_Great_Green = rgb <171/255, 180/255, 134/255>;
#declare CN_Great_Joy = rgb <216/255, 230/255, 203/255>;
#declare CN_Great_Serpent = rgb <74/255, 114/255, 163/255>;
#declare CN_Great_Tit_Eggs = rgb <233/255, 226/255, 219/255>;
#declare CN_Great_Void = rgb <59/255, 87/255, 96/255>;
#declare CN_Great_White = rgb <189/255, 189/255, 198/255>;
#declare CN_Grecian_Gold = rgb <158/255, 126/255, 84/255>;
#declare CN_Grecian_Isle = rgb <0/255, 164/255, 155/255>;
#declare CN_Grecian_Ivory = rgb <214/255, 207/255, 190/255>;
#declare CN_Greedo_Green = rgb <0/255, 170/255, 102/255>;
#declare CN_Greedy_Gecko = rgb <170/255, 153/255, 34/255>;
#declare CN_Greedy_Gold = rgb <196/255, 206/255, 59/255>;
#declare CN_Greedy_Green = rgb <209/255, 255/255, 189/255>;
#declare CN_Greek_Aubergine = rgb <61/255, 7/255, 52/255>;
#declare CN_Greek_Blue = rgb <0/255, 159/255, 189/255>;
#declare CN_Greek_Flag_Blue = rgb <13/255, 94/255, 175/255>;
#declare CN_Greek_Garden = rgb <140/255, 206/255, 134/255>;
#declare CN_Greek_Isles = rgb <187/255, 220/255, 240/255>;
#declare CN_Greek_Lavender = rgb <155/255, 143/255, 176/255>;
#declare CN_Greek_Sea = rgb <114/255, 167/255, 225/255>;
#declare CN_Greek_Villa = rgb <240/255, 236/255, 226/255>;
#declare CN_Green = rgb <0/255, 255/255, 0/255>;
#declare CN_Green_383 = rgb <62/255, 61/255, 41/255>;
#declare CN_Green_Acres = rgb <83/255, 161/255, 68/255>;
#declare CN_Green_Adirondack = rgb <104/255, 136/255, 120/255>;
#declare CN_Green_Agate = rgb <63/255, 98/255, 83/255>;
#declare CN_Green_Alabaster = rgb <200/255, 204/255, 186/255>;
#declare CN_Green_Amazons = rgb <152/255, 168/255, 147/255>;
#declare CN_Green_Apple = rgb <94/255, 220/255, 31/255>;
#declare CN_Green_Apple_Martini = rgb <210/255, 199/255, 133/255>;
#declare CN_Green_Aqua = rgb <208/255, 232/255, 219/255>;
#declare CN_Green_Ash = rgb <160/255, 218/255, 169/255>;
#declare CN_Green_Balloon = rgb <128/255, 196/255, 169/255>;
#declare CN_Green_Balsam = rgb <160/255, 172/255, 158/255>;
#declare CN_Green_Banana = rgb <168/255, 180/255, 83/255>;
#declare CN_Green_Bank = rgb <121/255, 176/255, 136/255>;
#declare CN_Green_Bark = rgb <169/255, 196/255, 166/255>;
#declare CN_Green_Bay = rgb <126/255, 146/255, 133/255>;
#declare CN_Green_Bayou = rgb <86/255, 110/255, 87/255>;
#declare CN_Green_Bean_Casserole = rgb <176/255, 163/255, 110/255>;
#declare CN_Green_Bell_Pepper = rgb <34/255, 136/255, 0/255>;
#declare CN_Green_Belt = rgb <45/255, 127/255, 108/255>;
#declare CN_Green_Beret = rgb <81/255, 106/255, 98/255>;
#declare CN_Green_Blob = rgb <34/255, 221/255, 0/255>;
#declare CN_Green_Blue = rgb <66/255, 179/255, 149/255>;
#declare CN_Green_Blue_Slate = rgb <53/255, 128/255, 130/255>;
#declare CN_Green_Bonnet = rgb <139/255, 180/255, 144/255>;
#declare CN_Green_Bottle = rgb <68/255, 106/255, 75/255>;
#declare CN_Green_Brocade = rgb <218/255, 241/255, 224/255>;
#declare CN_Green_Brown = rgb <105/255, 96/255, 6/255>;
#declare CN_Green_Buoy = rgb <50/255, 167/255, 181/255>;
#declare CN_Green_Bush = rgb <127/255, 136/255, 102/255>;
#declare CN_Green_Cacophony = rgb <187/255, 238/255, 17/255>;
#declare CN_Green_Cape = rgb <137/255, 206/255, 1/255>;
#declare CN_Green_Cast = rgb <145/255, 147/255, 101/255>;
#declare CN_Green_Caterpillar = rgb <152/255, 190/255, 60/255>;
#declare CN_Green_Chalk = rgb <188/255, 223/255, 138/255>;
#declare CN_Green_Charm = rgb <231/255, 221/255, 167/255>;
#declare CN_Green_Coconut = rgb <134/255, 142/255, 101/255>;
#declare CN_Green_Column = rgb <70/255, 81/255, 73/255>;
#declare CN_Green_Cow = rgb <190/255, 239/255, 105/255>;
#declare CN_Green_Crush = rgb <98/255, 174/255, 158/255>;
#declare CN_Green_Cyan = rgb <0/255, 153/255, 102/255>;
#declare CN_Green_Darner_Tail = rgb <117/255, 187/255, 253/255>;
#declare CN_Green_Day = rgb <187/255, 238/255, 136/255>;
#declare CN_Green_Daze = rgb <139/255, 211/255, 198/255>;
#declare CN_Green_Dragon = rgb <0/255, 108/255, 103/255>;
#declare CN_Green_Dragon_Spring = rgb <193/255, 202/255, 176/255>;
#declare CN_Green_Dynasty = rgb <114/255, 137/255, 66/255>;
#declare CN_Green_Eggs = rgb <227/255, 236/255, 197/255>;
#declare CN_Green_Eggs_and_Ham = rgb <124/255, 182/255, 142/255>;
#declare CN_Green_Elliott = rgb <0/255, 187/255, 102/255>;
#declare CN_Green_Emulsion = rgb <218/255, 234/255, 226/255>;
#declare CN_Green_Energy = rgb <128/255, 144/255, 95/255>;
#declare CN_Green_Envy = rgb <119/255, 170/255, 0/255>;
#declare CN_Green_Epiphany = rgb <126/255, 251/255, 179/255>;
#declare CN_Green_Essence = rgb <233/255, 234/255, 200/255>;
#declare CN_Green_Eyes = rgb <125/255, 149/255, 109/255>;
#declare CN_Green_Fiasco = rgb <170/255, 238/255, 0/255>;
#declare CN_Green_Field = rgb <136/255, 170/255, 119/255>;
#declare CN_Green_Fig = rgb <179/255, 164/255, 118/255>;
#declare CN_Green_Fingers = rgb <41/255, 126/255, 107/255>;
#declare CN_Green_Flash = rgb <121/255, 199/255, 83/255>;
#declare CN_Green_Flavor = rgb <187/255, 170/255, 34/255>;
#declare CN_Green_Fluorite = rgb <85/255, 187/255, 170/255>;
#declare CN_Green_Fog = rgb <152/255, 154/255, 135/255>;
#declare CN_Green_Frost = rgb <208/255, 214/255, 191/255>;
#declare CN_Green_Frosting = rgb <216/255, 241/255, 235/255>;
#declare CN_Green_Gables = rgb <50/255, 66/255, 65/255>;
#declare CN_Green_Gamora = rgb <17/255, 187/255, 0/255>;
#declare CN_Green_Gardens = rgb <0/255, 153/255, 17/255>;
#declare CN_Green_Garlands = rgb <0/255, 129/255, 118/255>;
#declare CN_Green_Garter = rgb <97/255, 186/255, 133/255>;
#declare CN_Green_Gas = rgb <0/255, 255/255, 153/255>;
#declare CN_Green_Gate = rgb <103/255, 105/255, 87/255>;
#declare CN_Green_Gecko = rgb <205/255, 212/255, 127/255>;
#declare CN_Green_Glacier = rgb <231/255, 240/255, 194/255>;
#declare CN_Green_Glaze = rgb <234/255, 241/255, 228/255>;
#declare CN_Green_Glimmer = rgb <0/255, 187/255, 0/255>;
#declare CN_Green_Glimpse = rgb <231/255, 234/255, 227/255>;
#declare CN_Green_Glint = rgb <220/255, 241/255, 199/255>;
#declare CN_Green_Glitter = rgb <221/255, 226/255, 106/255>;
#declare CN_Green_Globe = rgb <121/255, 170/255, 135/255>;
#declare CN_Green_Gloss = rgb <0/255, 149/255, 94/255>;
#declare CN_Green_Glow = rgb <176/255, 201/255, 101/255>;
#declare CN_Green_Glutton = rgb <0/255, 119/255, 34/255>;
#declare CN_Green_Goanna = rgb <80/255, 90/255, 57/255>;
#declare CN_Green_Goblin = rgb <17/255, 187/255, 51/255>;
#declare CN_Green_Gold = rgb <197/255, 176/255, 136/255>;
#declare CN_Green_Gone_Wild = rgb <115/255, 162/255, 54/255>;
#declare CN_Green_Gooseberry = rgb <176/255, 223/255, 164/255>;
#declare CN_Green_Granite = rgb <124/255, 151/255, 147/255>;
#declare CN_Green_Grapple = rgb <61/255, 185/255, 178/255>;
#declare CN_Green_Grass = rgb <57/255, 133/255, 74/255>;
#declare CN_Green_Grey = rgb <126/255, 160/255, 122/255>;
#declare CN_Green_Grey_Mist = rgb <175/255, 169/255, 132/255>;
#declare CN_Green_Gum = rgb <149/255, 227/255, 192/255>;
#declare CN_Green_Haze = rgb <1/255, 163/255, 104/255>;
#declare CN_Green_Herb = rgb <164/255, 192/255, 138/255>;
#declare CN_Green_Hills = rgb <0/255, 120/255, 0/255>;
#declare CN_Green_Hour = rgb <88/255, 125/255, 121/255>;
#declare CN_Green_Iced_Tea = rgb <232/255, 232/255, 212/255>;
#declare CN_Green_Illude = rgb <110/255, 111/255, 86/255>;
#declare CN_Green_Incandescence = rgb <196/255, 254/255, 130/255>;
#declare CN_Green_Ink = rgb <17/255, 136/255, 123/255>;
#declare CN_Green_Jelly = rgb <52/255, 155/255, 130/255>;
#declare CN_Green_Jewel = rgb <149/255, 218/255, 189/255>;
#declare CN_Green_Juice = rgb <59/255, 222/255, 57/255>;
#declare CN_Green_Katamari = rgb <83/255, 254/255, 92/255>;
#declare CN_Green_Kelp = rgb <57/255, 61/255, 42/255>;
#declare CN_Green_Knoll = rgb <100/255, 127/255, 74/255>;
#declare CN_Green_Lacewing = rgb <138/255, 211/255, 112/255>;
#declare CN_Green_Lane = rgb <202/255, 214/255, 196/255>;
#declare CN_Green_Lantern = rgb <156/255, 208/255, 59/255>;
#declare CN_Green_Lapis = rgb <0/255, 134/255, 132/255>;
#declare CN_Green_Leaf = rgb <82/255, 107/255, 45/255>;
#declare CN_Green_Lentils = rgb <156/255, 148/255, 99/255>;
#declare CN_Green_Lily = rgb <193/255, 206/255, 193/255>;
#declare CN_Green_Lizard = rgb <167/255, 244/255, 50/255>;
#declare CN_Green_Mallard = rgb <69/255, 95/255, 95/255>;
#declare CN_Green_Mana = rgb <38/255, 180/255, 103/255>;
#declare CN_Green_McQuarrie = rgb <85/255, 93/255, 80/255>;
#declare CN_Green_Me = rgb <178/255, 181/255, 95/255>;
#declare CN_Green_Meets_Blue = rgb <142/255, 168/255, 160/255>;
#declare CN_Green_Mesh = rgb <215/255, 215/255, 173/255>;
#declare CN_Green_Milieu = rgb <138/255, 153/255, 146/255>;
#declare CN_Green_Minions = rgb <153/255, 221/255, 0/255>;
#declare CN_Green_Mirror = rgb <215/255, 226/255, 213/255>;
#declare CN_Green_Mist = rgb <191/255, 194/255, 152/255>;
#declare CN_Green_Moblin = rgb <0/255, 136/255, 136/255>;
#declare CN_Green_Moonstone = rgb <51/255, 86/255, 94/255>;
#declare CN_Green_Moray = rgb <58/255, 121/255, 104/255>;
#declare CN_Green_Moss = rgb <133/255, 121/255, 70/255>;
#declare CN_Green_Myth = rgb <197/255, 225/255, 195/255>;
#declare CN_Green_Neon = rgb <178/255, 172/255, 49/255>;
#declare CN_Green_not_Found = rgb <64/255, 68/255, 4/255>;
#declare CN_Green_Oasis = rgb <176/255, 180/255, 84/255>;
#declare CN_Green_Oblivion = rgb <0/255, 82/255, 73/255>;
#declare CN_Green_Ochre = rgb <159/255, 143/255, 85/255>;
#declare CN_Green_Olive = rgb <141/255, 139/255, 85/255>;
#declare CN_Green_Olive_Pit = rgb <189/255, 170/255, 137/255>;
#declare CN_Green_Onion = rgb <193/255, 224/255, 137/255>;
#declare CN_Green_Onyx = rgb <152/255, 154/255, 130/255>;
#declare CN_Green_Papaya = rgb <229/255, 206/255, 119/255>;
#declare CN_Green_Parakeet = rgb <123/255, 213/255, 191/255>;
#declare CN_Green_Parlor = rgb <207/255, 221/255, 185/255>;
#declare CN_Green_Patina = rgb <102/255, 208/255, 192/255>;
#declare CN_Green_Paw_Paw = rgb <13/255, 99/255, 73/255>;
#declare CN_Green_Pea = rgb <38/255, 98/255, 66/255>;
#declare CN_Green_Pear = rgb <121/255, 190/255, 88/255>;
#declare CN_Green_People = rgb <56/255, 128/255, 4/255>;
#declare CN_Green_Pepper = rgb <151/255, 188/255, 98/255>;
#declare CN_Green_Pigment = rgb <0/255, 165/255, 80/255>;
#declare CN_Green_Plaza = rgb <152/255, 167/255, 110/255>;
#declare CN_Green_Power = rgb <226/255, 225/255, 198/255>;
#declare CN_Green_Priestess = rgb <17/255, 221/255, 85/255>;
#declare CN_Green_Revolution = rgb <0/255, 153/255, 68/255>;
#declare CN_Green_Room = rgb <128/255, 174/255, 164/255>;
#declare CN_Green_Savage = rgb <136/255, 136/255, 102/255>;
#declare CN_Green_Scene = rgb <133/255, 131/255, 101/255>;
#declare CN_Green_Screen = rgb <34/255, 255/255, 0/255>;
#declare CN_Green_Shade_Wash = rgb <69/255, 82/255, 58/255>;
#declare CN_Green_Sheen = rgb <217/255, 206/255, 82/255>;
#declare CN_Green_Shimmer = rgb <204/255, 253/255, 127/255>;
#declare CN_Green_Silk = rgb <162/255, 194/255, 176/255>;
#declare CN_Green_Sky = rgb <133/255, 157/255, 102/255>;
#declare CN_Green_Sleeves = rgb <161/255, 150/255, 117/255>;
#declare CN_Green_Smoke = rgb <156/255, 166/255, 100/255>;
#declare CN_Green_Snow = rgb <158/255, 183/255, 136/255>;
#declare CN_Green_Song = rgb <209/255, 233/255, 196/255>;
#declare CN_Green_Spool = rgb <0/255, 100/255, 116/255>;
#declare CN_Green_Spring = rgb <169/255, 175/255, 153/255>;
#declare CN_Green_Spruce = rgb <88/255, 159/255, 126/255>;
#declare CN_Green_Stain = rgb <43/255, 85/255, 62/255>;
#declare CN_Green_Suede = rgb <115/255, 136/255, 77/255>;
#declare CN_Green_Sulphur = rgb <174/255, 142/255, 44/255>;
#declare CN_Green_Tea = rgb <181/255, 182/255, 143/255>;
#declare CN_Green_Tea_Candy = rgb <101/255, 171/255, 124/255>;
#declare CN_Green_Tea_Ice_Cream = rgb <147/255, 177/255, 61/255>;
#declare CN_Green_Tea_Leaf = rgb <147/255, 154/255, 137/255>;
#declare CN_Green_Tea_Mochi = rgb <144/255, 169/255, 110/255>;
#declare CN_Green_Teal = rgb <12/255, 181/255, 119/255>;
#declare CN_Green_Tease = rgb <227/255, 237/255, 224/255>;
#declare CN_Green_Thumb = rgb <119/255, 153/255, 0/255>;
#declare CN_Green_Tilberi = rgb <213/255, 224/255, 208/255>;
#declare CN_Green_Tint = rgb <197/255, 204/255, 192/255>;
#declare CN_Green_Tone_Ink = rgb <71/255, 85/255, 60/255>;
#declare CN_Green_Tourmaline = rgb <94/255, 171/255, 129/255>;
#declare CN_Green_Trance = rgb <160/255, 217/255, 163/255>;
#declare CN_Green_Trellis = rgb <153/255, 167/255, 152/255>;
#declare CN_Green_Turquoise = rgb <103/255, 149/255, 145/255>;
#declare CN_Green_Valley = rgb <63/255, 73/255, 72/255>;
#declare CN_Green_Veil = rgb <224/255, 241/255, 196/255>;
#declare CN_Green_Velvet = rgb <18/255, 116/255, 83/255>;
#declare CN_Green_Venom = rgb <184/255, 248/255, 24/255>;
#declare CN_Green_Vibes = rgb <212/255, 231/255, 195/255>;
#declare CN_Green_Vogue = rgb <35/255, 65/255, 78/255>;
#declare CN_Green_Wash = rgb <198/255, 221/255, 205/255>;
#declare CN_Green_Waterloo = rgb <44/255, 45/255, 36/255>;
#declare CN_Green_Wave = rgb <195/255, 220/255, 213/255>;
#declare CN_Green_Weed = rgb <84/255, 143/255, 111/255>;
#declare CN_Green_Whisper = rgb <227/255, 238/255, 227/255>;
#declare CN_Green_White = rgb <222/255, 221/255, 203/255>;
#declare CN_Green_Woodpecker_Olive = rgb <125/255, 120/255, 83/255>;
#declare CN_Green_Yellow = rgb <198/255, 248/255, 8/255>;
#declare CN_Greenalicious = rgb <0/255, 221/255, 0/255>;
#declare CN_Greenbelt = rgb <68/255, 125/255, 95/255>;
#declare CN_Greenblack = rgb <55/255, 58/255, 58/255>;
#declare CN_Greenbrier = rgb <75/255, 155/255, 105/255>;
#declare CN_Greenday = rgb <153/255, 255/255, 0/255>;
#declare CN_Greene__Greene = rgb <68/255, 85/255, 68/255>;
#declare CN_Greenella = rgb <96/255, 133/255, 122/255>;
#declare CN_Greener_Grass = rgb <47/255, 131/255, 81/255>;
#declare CN_Greener_Pastures = rgb <73/255, 90/255, 76/255>;
#declare CN_Greenery = rgb <136/255, 176/255, 75/255>;
#declare CN_Greenette = rgb <218/255, 236/255, 197/255>;
#declare CN_Greenfield = rgb <96/255, 114/255, 79/255>;
#declare CN_Greenfinch = rgb <189/255, 169/255, 40/255>;
#declare CN_Greengage = rgb <139/255, 194/255, 140/255>;
#declare CN_Greengrass = rgb <114/255, 163/255, 85/255>;
#declare CN_Greenhouse = rgb <62/255, 99/255, 52/255>;
#declare CN_Greenhouse_Glass = rgb <215/255, 231/255, 205/255>;
#declare CN_Greening = rgb <223/255, 228/255, 213/255>;
#declare CN_Greenish = rgb <64/255, 163/255, 104/255>;
#declare CN_Greenish_Beige = rgb <201/255, 209/255, 121/255>;
#declare CN_Greenish_Black = rgb <69/255, 68/255, 69/255>;
#declare CN_Greenish_Blue = rgb <11/255, 139/255, 135/255>;
#declare CN_Greenish_Brown = rgb <105/255, 97/255, 18/255>;
#declare CN_Greenish_Cyan = rgb <42/255, 254/255, 183/255>;
#declare CN_Greenish_Grey = rgb <150/255, 174/255, 141/255>;
#declare CN_Greenish_Grey_Bark = rgb <102/255, 103/255, 90/255>;
#declare CN_Greenish_Tan = rgb <188/255, 203/255, 122/255>;
#declare CN_Greenish_Teal = rgb <50/255, 191/255, 132/255>;
#declare CN_Greenish_Turquoise = rgb <0/255, 251/255, 176/255>;
#declare CN_Greenish_White = rgb <209/255, 241/255, 222/255>;
#declare CN_Greenish_Yellow = rgb <205/255, 253/255, 2/255>;
#declare CN_Greenlake = rgb <0/255, 125/255, 105/255>;
#declare CN_Greenland = rgb <115/255, 125/255, 106/255>;
#declare CN_Greenland_Blue = rgb <54/255, 127/255, 154/255>;
#declare CN_Greenland_Green = rgb <34/255, 172/255, 174/255>;
#declare CN_Greenland_Ice = rgb <185/255, 215/255, 214/255>;
#declare CN_Greens = rgb <1/255, 104/255, 68/255>;
#declare CN_Greensleeves = rgb <57/255, 118/255, 108/255>;
#declare CN_Greenway = rgb <65/255, 154/255, 125/255>;
#declare CN_Greenwich_Village = rgb <175/255, 191/255, 190/255>;
#declare CN_Greenwood = rgb <188/255, 186/255, 171/255>;
#declare CN_Greeny_Glaze = rgb <6/255, 115/255, 118/255>;
#declare CN_Gregorio_Garden = rgb <203/255, 200/255, 221/255>;
#declare CN_Greige = rgb <176/255, 169/255, 153/255>;
#declare CN_Greige_Violet = rgb <156/255, 140/255, 154/255>;
#declare CN_Gremlin = rgb <167/255, 153/255, 84/255>;
#declare CN_Gremolata = rgb <82/255, 126/255, 109/255>;
#declare CN_Grenache = rgb <142/255, 98/255, 104/255>;
#declare CN_Grenade = rgb <195/255, 33/255, 73/255>;
#declare CN_Grenadier = rgb <193/255, 77/255, 54/255>;
#declare CN_Grenadine = rgb <172/255, 84/255, 94/255>;
#declare CN_Gretchin_Green = rgb <93/255, 103/255, 50/255>;
#declare CN_Gretna_Green = rgb <89/255, 100/255, 66/255>;
#declare CN_Grey = rgb <128/255, 128/255, 128/255>;
#declare CN_Grey_Aqua = rgb <136/255, 182/255, 159/255>;
#declare CN_Grey_Area = rgb <143/255, 147/255, 148/255>;
#declare CN_Grey_Ashlar = rgb <202/255, 186/255, 177/255>;
#declare CN_Grey_Asparagus = rgb <70/255, 89/255, 69/255>;
#declare CN_Grey_Blue = rgb <119/255, 161/255, 181/255>;
#declare CN_Grey_Blueberry = rgb <108/255, 128/255, 150/255>;
#declare CN_Grey_Brown = rgb <127/255, 112/255, 83/255>;
#declare CN_Grey_By_Me = rgb <161/255, 152/255, 139/255>;
#declare CN_Grey_Carmine = rgb <122/255, 80/255, 99/255>;
#declare CN_Grey_Chateau = rgb <159/255, 163/255, 167/255>;
#declare CN_Grey_Cloth = rgb <204/255, 201/255, 197/255>;
#declare CN_Grey_Cloud = rgb <116/255, 120/255, 128/255>;
#declare CN_Grey_Dawn = rgb <187/255, 193/255, 204/255>;
#declare CN_Grey_Dolphin = rgb <200/255, 199/255, 197/255>;
#declare CN_Grey_Dusk = rgb <137/255, 127/255, 152/255>;
#declare CN_Grey_Flannel = rgb <141/255, 154/255, 158/255>;
#declare CN_Grey_Frost = rgb <184/255, 191/255, 194/255>;
#declare CN_Grey_Ghost = rgb <221/255, 220/255, 218/255>;
#declare CN_Grey_Glimpse = rgb <224/255, 228/255, 226/255>;
#declare CN_Grey_Gloss = rgb <163/255, 162/255, 155/255>;
#declare CN_Grey_Grain = rgb <169/255, 189/255, 191/255>;
#declare CN_Grey_Green = rgb <134/255, 161/255, 125/255>;
#declare CN_Grey_Heather = rgb <134/255, 135/255, 144/255>;
#declare CN_Grey_Heron = rgb <137/255, 146/255, 138/255>;
#declare CN_Grey_Jade = rgb <185/255, 187/255, 173/255>;
#declare CN_Grey_Lilac = rgb <212/255, 202/255, 205/255>;
#declare CN_Grey_Linnet_Egg = rgb <242/255, 232/255, 215/255>;
#declare CN_Grey_Locks = rgb <114/255, 105/255, 94/255>;
#declare CN_Grey_Marble = rgb <185/255, 180/255, 177/255>;
#declare CN_Grey_Matter = rgb <200/255, 127/255, 137/255>;
#declare CN_Grey_Mauve = rgb <202/255, 184/255, 171/255>;
#declare CN_Grey_Mist = rgb <153/255, 174/255, 174/255>;
#declare CN_Grey_Monument = rgb <112/255, 124/255, 120/255>;
#declare CN_Grey_Morn = rgb <202/255, 190/255, 181/255>;
#declare CN_Grey_Morning = rgb <158/255, 176/255, 170/255>;
#declare CN_Grey_Nickel = rgb <195/255, 195/255, 189/255>;
#declare CN_Grey_Nurse = rgb <209/255, 211/255, 204/255>;
#declare CN_Grey_of_Darkness = rgb <162/255, 162/255, 162/255>;
#declare CN_Grey_Olive = rgb <161/255, 154/255, 127/255>;
#declare CN_Grey_Owl = rgb <119/255, 111/255, 103/255>;
#declare CN_Grey_Pearl = rgb <206/255, 208/255, 207/255>;
#declare CN_Grey_Pebble = rgb <207/255, 202/255, 193/255>;
#declare CN_Grey_Pepper = rgb <132/255, 130/255, 125/255>;
#declare CN_Grey_Pink = rgb <195/255, 144/255, 155/255>;
#declare CN_Grey_Pinstripe = rgb <73/255, 73/255, 77/255>;
#declare CN_Grey_Placidity = rgb <221/255, 221/255, 226/255>;
#declare CN_Grey_Porcelain = rgb <134/255, 131/255, 122/255>;
#declare CN_Grey_Purple = rgb <130/255, 109/255, 140/255>;
#declare CN_Grey_Ridge = rgb <132/255, 121/255, 134/255>;
#declare CN_Grey_River_Rock = rgb <153/255, 161/255, 161/255>;
#declare CN_Grey_Roads = rgb <195/255, 192/255, 187/255>;
#declare CN_Grey_Rose = rgb <198/255, 182/255, 178/255>;
#declare CN_Grey_Russian = rgb <142/255, 149/255, 152/255>;
#declare CN_Grey_Sand = rgb <229/255, 204/255, 175/255>;
#declare CN_Grey_Scape = rgb <184/255, 176/255, 175/255>;
#declare CN_Grey_Shadows = rgb <194/255, 189/255, 186/255>;
#declare CN_Grey_Shimmer = rgb <214/255, 217/255, 216/255>;
#declare CN_Grey_Spell = rgb <200/255, 199/255, 194/255>;
#declare CN_Grey_Squirrel = rgb <152/255, 144/255, 129/255>;
#declare CN_Grey_Suit = rgb <147/255, 145/255, 160/255>;
#declare CN_Grey_Teal = rgb <94/255, 155/255, 138/255>;
#declare CN_Grey_Timber_Wolf = rgb <172/255, 174/255, 177/255>;
#declare CN_Grey_Violet = rgb <155/255, 142/255, 142/255>;
#declare CN_Grey_Whisper = rgb <230/255, 228/255, 228/255>;
#declare CN_Grey_White = rgb <215/255, 213/255, 203/255>;
#declare CN_Grey_Wolf = rgb <156/255, 160/255, 166/255>;
#declare CN_Grey_Wonder = rgb <229/255, 232/255, 230/255>;
#declare CN_Grey_Wool = rgb <169/255, 187/255, 188/255>;
#declare CN_Grey_Headed_Woodpecker_Green = rgb <152/255, 145/255, 108/255>;
#declare CN_Greybeard = rgb <212/255, 208/255, 197/255>;
#declare CN_Greyed_Jade = rgb <155/255, 190/255, 169/255>;
#declare CN_Greyhound = rgb <178/255, 172/255, 162/255>;
#declare CN_Greyish = rgb <168/255, 164/255, 149/255>;
#declare CN_Greyish_Black = rgb <85/255, 81/255, 82/255>;
#declare CN_Greyish_Blue = rgb <94/255, 129/255, 157/255>;
#declare CN_Greyish_Brown = rgb <122/255, 106/255, 79/255>;
#declare CN_Greyish_Green = rgb <130/255, 166/255, 125/255>;
#declare CN_Greyish_Pink = rgb <200/255, 141/255, 148/255>;
#declare CN_Greyish_Purple = rgb <136/255, 113/255, 145/255>;
#declare CN_Greyish_Teal = rgb <113/255, 159/255, 145/255>;
#declare CN_Greyish_White = rgb <214/255, 222/255, 233/255>;
#declare CN_Greyish_Yellow = rgb <135/255, 114/255, 84/255>;
#declare CN_Greylac = rgb <148/255, 140/255, 141/255>;
#declare CN_Greystoke = rgb <133/255, 131/255, 126/255>;
#declare CN_Greystone = rgb <183/255, 185/255, 181/255>;
#declare CN_Greywacke = rgb <170/255, 204/255, 187/255>;
#declare CN_Greywood = rgb <157/255, 149/255, 134/255>;
#declare CN_Griffin = rgb <141/255, 143/255, 143/255>;
#declare CN_Griffon_Brown = rgb <112/255, 57/255, 63/255>;
#declare CN_Grill_Master = rgb <134/255, 59/255, 44/255>;
#declare CN_Grilled = rgb <99/255, 63/255, 46/255>;
#declare CN_Grilled_Cheese = rgb <255/255, 200/255, 95/255>;
#declare CN_Grim_Grey = rgb <227/255, 220/255, 214/255>;
#declare CN_Grim_Pink = rgb <222/255, 173/255, 175/255>;
#declare CN_Grim_Purple = rgb <68/255, 17/255, 136/255>;
#declare CN_Grim_Reaper = rgb <15/255, 16/255, 57/255>;
#declare CN_Grim_White = rgb <246/255, 241/255, 244/255>;
#declare CN_Grimace = rgb <80/255, 49/255, 76/255>;
#declare CN_Grime = rgb <86/255, 81/255, 67/255>;
#declare CN_Gris = rgb <165/255, 169/255, 168/255>;
#declare CN_Gris_Morado = rgb <143/255, 138/255, 145/255>;
#declare CN_Gris_Nautico = rgb <188/255, 199/255, 203/255>;
#declare CN_Gris_Volcanico = rgb <121/255, 115/255, 113/255>;
#declare CN_Grisaille = rgb <88/255, 94/255, 111/255>;
#declare CN_Gristmill = rgb <162/255, 147/255, 113/255>;
#declare CN_Grizzle_Gray = rgb <99/255, 101/255, 98/255>;
#declare CN_Grizzly = rgb <136/255, 88/255, 24/255>;
#declare CN_Grog_Yellow = rgb <147/255, 112/255, 67/255>;
#declare CN_Groovy = rgb <222/255, 100/255, 145/255>;
#declare CN_Groovy_Giraffe = rgb <238/255, 170/255, 17/255>;
#declare CN_Gropius_Grey = rgb <99/255, 97/255, 93/255>;
#declare CN_Gross_Green = rgb <160/255, 191/255, 22/255>;
#declare CN_Grotesque_Green = rgb <100/255, 233/255, 134/255>;
#declare CN_Grouchy_Badger = rgb <111/255, 103/255, 92/255>;
#declare CN_Ground_Bean = rgb <96/255, 78/255, 66/255>;
#declare CN_Ground_Coffee = rgb <99/255, 85/255, 75/255>;
#declare CN_Ground_Cover = rgb <168/255, 191/255, 139/255>;
#declare CN_Ground_Cumin = rgb <138/255, 108/255, 66/255>;
#declare CN_Ground_Fog = rgb <207/255, 203/255, 196/255>;
#declare CN_Ground_Ginger = rgb <217/255, 202/255, 159/255>;
#declare CN_Ground_Nutmeg = rgb <160/255, 90/255, 59/255>;
#declare CN_Ground_Pepper = rgb <118/255, 101/255, 81/255>;
#declare CN_Groundcover = rgb <100/255, 99/255, 77/255>;
#declare CN_Grounded = rgb <209/255, 140/255, 98/255>;
#declare CN_Groundwater = rgb <17/255, 0/255, 170/255>;
#declare CN_Growing_Nature = rgb <136/255, 204/255, 17/255>;
#declare CN_Growing_Season = rgb <195/255, 205/255, 176/255>;
#declare CN_Growth = rgb <108/255, 161/255, 120/255>;
#declare CN_Grubenwald = rgb <74/255, 91/255, 81/255>;
#declare CN_Grullo = rgb <169/255, 154/255, 134/255>;
#declare CN_Grunervetliner = rgb <192/255, 207/255, 63/255>;
#declare CN_Gruyere_Cheese = rgb <245/255, 222/255, 179/255>;
#declare CN_Gryphonne_Sepia_Wash = rgb <136/255, 63/255, 17/255>;
#declare CN_Gu_Tong_Hei_Copper = rgb <99/255, 73/255, 80/255>;
#declare CN_Guacamole = rgb <149/255, 152/255, 107/255>;
#declare CN_Guardian_Angel = rgb <228/255, 225/255, 234/255>;
#declare CN_Guardsman_Red = rgb <149/255, 46/255, 49/255>;
#declare CN_Guava_Green = rgb <161/255, 141/255, 13/255>;
#declare CN_Guava_Jam = rgb <224/255, 135/255, 113/255>;
#declare CN_Guava_Jelly = rgb <238/255, 150/255, 133/255>;
#declare CN_Guava_Juice = rgb <244/255, 182/255, 148/255>;
#declare CN_Guerrilla_Forest = rgb <20/255, 45/255, 37/255>;
#declare CN_Guesthouse = rgb <227/255, 224/255, 210/255>;
#declare CN_Guide_Pink = rgb <235/255, 73/255, 98/255>;
#declare CN_Guiding_Star = rgb <254/255, 233/255, 218/255>;
#declare CN_Guild_Grey = rgb <210/255, 209/255, 203/255>;
#declare CN_Guilliman_Blue = rgb <100/255, 149/255, 237/255>;
#declare CN_Guinea_Pig = rgb <152/255, 118/255, 84/255>;
#declare CN_Guinea_Pig_White = rgb <232/255, 228/255, 214/255>;
#declare CN_Guinean_Green = rgb <74/255, 129/255, 64/255>;
#declare CN_Guitar = rgb <107/255, 76/255, 55/255>;
#declare CN_Gulab_Brown = rgb <139/255, 46/255, 25/255>;
#declare CN_Gulabi_Pink = rgb <199/255, 114/255, 192/255>;
#declare CN_Gulf_Blue = rgb <52/255, 63/255, 92/255>;
#declare CN_Gulf_Breeze = rgb <221/255, 222/255, 211/255>;
#declare CN_Gulf_Harbour = rgb <34/255, 94/255, 100/255>;
#declare CN_Gulf_Stream = rgb <116/255, 178/255, 168/255>;
#declare CN_Gulf_Waters = rgb <45/255, 166/255, 191/255>;
#declare CN_Gulf_Weed = rgb <104/255, 110/255, 67/255>;
#declare CN_Gulf_Wind = rgb <188/255, 201/255, 205/255>;
#declare CN_Gulf_Winds = rgb <147/255, 178/255, 178/255>;
#declare CN_Gulfstream = rgb <1/255, 133/255, 139/255>;
#declare CN_Gull = rgb <145/255, 140/255, 143/255>;
#declare CN_Gull_Feather = rgb <194/255, 194/255, 188/255>;
#declare CN_Gull_Grey = rgb <164/255, 173/255, 176/255>;
#declare CN_Gully = rgb <119/255, 118/255, 97/255>;
#declare CN_Gully_Green = rgb <75/255, 110/255, 59/255>;
#declare CN_Gum_Leaf = rgb <172/255, 201/255, 178/255>;
#declare CN_Gumball = rgb <231/255, 178/255, 208/255>;
#declare CN_Gumbo = rgb <113/255, 143/255, 138/255>;
#declare CN_Gumdrop = rgb <222/255, 150/255, 193/255>;
#declare CN_Gumdrop_Green = rgb <46/255, 167/255, 133/255>;
#declare CN_Gumdrops = rgb <255/255, 198/255, 157/255>;
#declare CN_Gun_Barrel = rgb <151/255, 157/255, 154/255>;
#declare CN_Gun_Corps_Brown = rgb <107/255, 89/255, 60/255>;
#declare CN_Gun_Powder = rgb <72/255, 71/255, 83/255>;
#declare CN_Gundaroo_Green = rgb <149/255, 153/255, 132/255>;
#declare CN_Gunjo_Blue = rgb <93/255, 140/255, 174/255>;
#declare CN_Gunmetal = rgb <83/255, 98/255, 103/255>;
#declare CN_Gunmetal_Beige = rgb <144/255, 137/255, 130/255>;
#declare CN_Gunmetal_Green = rgb <119/255, 118/255, 72/255>;
#declare CN_Gunmetal_Grey = rgb <128/255, 140/255, 140/255>;
#declare CN_Gunny_Sack = rgb <220/255, 211/255, 188/255>;
#declare CN_Guns_N_Roses = rgb <255/255, 0/255, 119/255>;
#declare CN_Gunsmoke = rgb <122/255, 124/255, 118/255>;
#declare CN_Guo_Tie_Dumpling = rgb <189/255, 126/255, 8/255>;
#declare CN_Guppie_Green = rgb <0/255, 255/255, 127/255>;
#declare CN_Guppy_Violet = rgb <174/255, 88/255, 131/255>;
#declare CN_Gurkha = rgb <152/255, 145/255, 113/255>;
#declare CN_Gustav = rgb <164/255, 150/255, 145/255>;
#declare CN_Gusto_Gold = rgb <248/255, 172/255, 29/255>;
#declare CN_Gutsy_Grape = rgb <112/255, 82/255, 132/255>;
#declare CN_Guy = rgb <137/255, 122/255, 104/255>;
#declare CN_Gyoza_Dumpling = rgb <223/255, 180/255, 111/255>;
#declare CN_Gypsum = rgb <238/255, 237/255, 228/255>;
#declare CN_Gypsum_Rose = rgb <226/255, 196/255, 175/255>;
#declare CN_Gypsum_Sand = rgb <214/255, 207/255, 191/255>;
#declare CN_Gypsy = rgb <229/255, 147/255, 104/255>;
#declare CN_Gypsy_Canvas = rgb <183/255, 164/255, 103/255>;
#declare CN_Gypsy_Caravan = rgb <209/255, 200/255, 215/255>;
#declare CN_Gypsy_Dancer = rgb <192/255, 124/255, 123/255>;
#declare CN_Gypsy_Jewels = rgb <97/255, 58/255, 87/255>;
#declare CN_Gypsy_Magic = rgb <145/255, 125/255, 130/255>;
#declare CN_Gypsy_Red = rgb <182/255, 54/255, 59/255>;
#declare CN_Gypsys_Gown = rgb <166/255, 152/255, 168/255>;
#declare CN_H2O = rgb <191/255, 225/255, 230/255>;
#declare CN_Habanero = rgb <249/255, 133/255, 19/255>;
#declare CN_Habanero_Chile = rgb <184/255, 71/255, 61/255>;
#declare CN_Habanero_Gold = rgb <254/255, 212/255, 80/255>;
#declare CN_Habitat = rgb <137/255, 125/255, 109/255>;
#declare CN_Hacienda = rgb <158/255, 128/255, 34/255>;
#declare CN_Hacienda_Blue = rgb <0/255, 135/255, 168/255>;
#declare CN_Hacienda_Tile = rgb <184/255, 109/255, 100/255>;
#declare CN_Hacienda_White = rgb <240/255, 237/255, 231/255>;
#declare CN_Haddocks_Sweater = rgb <39/255, 122/255, 186/255>;
#declare CN_Hadfield_Blue = rgb <17/255, 119/255, 255/255>;
#declare CN_Hadopelagic_Water = rgb <0/255, 0/255, 34/255>;
#declare CN_Haggis = rgb <195/255, 199/255, 178/255>;
#declare CN_Hailey_Blue = rgb <44/255, 117/255, 255/255>;
#declare CN_Hailstorm = rgb <208/255, 209/255, 225/255>;
#declare CN_Hailstorm_Grey = rgb <189/255, 190/255, 185/255>;
#declare CN_Hair_Blonde = rgb <253/255, 207/255, 161/255>;
#declare CN_Hair_Brown = rgb <139/255, 120/255, 89/255>;
#declare CN_Hair_Ribbon = rgb <147/255, 156/255, 201/255>;
#declare CN_Hairy_Brown = rgb <115/255, 74/255, 18/255>;
#declare CN_Hairy_Heath = rgb <99/255, 53/255, 40/255>;
#declare CN_Haiti = rgb <44/255, 42/255, 53/255>;
#declare CN_Haitian_Flower = rgb <151/255, 73/255, 90/255>;
#declare CN_Hakusai_Green = rgb <136/255, 179/255, 120/255>;
#declare CN_Halaka_Pila = rgb <240/255, 228/255, 131/255>;
#declare CN_Halation = rgb <209/255, 209/255, 206/255>;
#declare CN_Halaya_Ube = rgb <102/255, 56/255, 84/255>;
#declare CN_Halcyon_Green = rgb <155/255, 170/255, 162/255>;
#declare CN_Half_Baked = rgb <85/255, 143/255, 147/255>;
#declare CN_Half_Colonial_White = rgb <242/255, 229/255, 191/255>;
#declare CN_Half_Dutch_White = rgb <251/255, 240/255, 214/255>;
#declare CN_Half_Moon_Bay_Blush = rgb <205/255, 168/255, 148/255>;
#declare CN_Half_Orc_Highlight = rgb <151/255, 111/255, 60/255>;
#declare CN_Half_Pearl_Lusta = rgb <241/255, 234/255, 215/255>;
#declare CN_Half_Sea_Fog = rgb <169/255, 184/255, 187/255>;
#declare CN_Half_Spanish_White = rgb <230/255, 219/255, 199/255>;
#declare CN_Half_Caff = rgb <96/255, 76/255, 61/255>;
#declare CN_Half_Smoke = rgb <238/255, 136/255, 85/255>;
#declare CN_Halite_Blue = rgb <9/255, 50/255, 74/255>;
#declare CN_Hallowed_Hush = rgb <226/255, 235/255, 229/255>;
#declare CN_Halloween_Orange = rgb <235/255, 97/255, 35/255>;
#declare CN_Halloween_Punch = rgb <221/255, 34/255, 17/255>;
#declare CN_Halo = rgb <226/255, 195/255, 146/255>;
#declare CN_Halogen_Blue = rgb <189/255, 198/255, 220/255>;
#declare CN_Halt_and_Catch_Fire = rgb <255/255, 102/255, 51/255>;
#declare CN_Halt_Red = rgb <255/255, 0/255, 79/255>;
#declare CN_Hamilton_Blue = rgb <138/255, 153/255, 164/255>;
#declare CN_Hammam_Blue = rgb <101/255, 220/255, 214/255>;
#declare CN_Hammered_Copper = rgb <131/255, 72/255, 49/255>;
#declare CN_Hammered_Gold = rgb <203/255, 157/255, 94/255>;
#declare CN_Hammered_Pewter = rgb <126/255, 117/255, 103/255>;
#declare CN_Hammered_Silver = rgb <151/255, 138/255, 127/255>;
#declare CN_Hammerhead_Shark = rgb <78/255, 116/255, 150/255>;
#declare CN_Hammock = rgb <109/255, 134/255, 135/255>;
#declare CN_Hampton = rgb <232/255, 212/255, 162/255>;
#declare CN_Hampton_Beach = rgb <157/255, 96/255, 59/255>;
#declare CN_Hampton_Green = rgb <79/255, 96/255, 79/255>;
#declare CN_Hampton_Surf = rgb <89/255, 118/255, 129/255>;
#declare CN_Hamster_Fur = rgb <166/255, 129/255, 76/255>;
#declare CN_Hamster_Habitat = rgb <196/255, 214/255, 175/255>;
#declare CN_Hamtaro_Brown = rgb <176/255, 116/255, 38/255>;
#declare CN_Han_Blue = rgb <68/255, 108/255, 207/255>;
#declare CN_Han_Purple = rgb <82/255, 24/255, 250/255>;
#declare CN_Hanaasagi_Blue = rgb <29/255, 105/255, 124/255>;
#declare CN_Hanada_Blue = rgb <4/255, 79/255, 103/255>;
#declare CN_Hanami_Pink = rgb <242/255, 171/255, 225/255>;
#declare CN_Hancock = rgb <77/255, 105/255, 104/255>;
#declare CN_Hand_Sanitizer = rgb <206/255, 236/255, 238/255>;
#declare CN_Handmade_Linen = rgb <221/255, 214/255, 183/255>;
#declare CN_Handmade_Red = rgb <168/255, 118/255, 120/255>;
#declare CN_Handsome_Hue = rgb <82/255, 134/255, 186/255>;
#declare CN_Handwoven = rgb <191/255, 169/255, 132/255>;
#declare CN_Hanging_Gardens_of_Babylon = rgb <17/255, 170/255, 68/255>;
#declare CN_Hannover_Hills = rgb <104/255, 93/255, 74/255>;
#declare CN_Hanover = rgb <218/255, 197/255, 177/255>;
#declare CN_Hanover_Pewter = rgb <132/255, 132/255, 114/255>;
#declare CN_Hansa_Yellow = rgb <233/255, 214/255, 108/255>;
#declare CN_Hanuman_Green = rgb <85/255, 255/255, 170/255>;
#declare CN_Hanyauku = rgb <227/255, 214/255, 199/255>;
#declare CN_Happy = rgb <248/255, 214/255, 100/255>;
#declare CN_Happy_Camper = rgb <107/255, 131/255, 80/255>;
#declare CN_Happy_Days = rgb <80/255, 110/255, 130/255>;
#declare CN_Happy_Daze = rgb <247/255, 207/255, 27/255>;
#declare CN_Happy_Face = rgb <255/255, 209/255, 11/255>;
#declare CN_Happy_Hippo = rgb <129/255, 133/255, 129/255>;
#declare CN_Happy_Piglets = rgb <246/255, 203/255, 202/255>;
#declare CN_Happy_Prawn = rgb <255/255, 190/255, 152/255>;
#declare CN_Happy_Thoughts = rgb <209/255, 223/255, 235/255>;
#declare CN_Happy_Trails = rgb <182/255, 122/255, 99/255>;
#declare CN_Happy_Tune = rgb <150/255, 185/255, 87/255>;
#declare CN_Happy_Yipee = rgb <255/255, 194/255, 23/255>;
#declare CN_Hapsburg_Court = rgb <226/255, 212/255, 214/255>;
#declare CN_Hara_Green = rgb <85/255, 170/255, 85/255>;
#declare CN_Harajuku_Girl = rgb <80/255, 74/255, 111/255>;
#declare CN_Harbor = rgb <91/255, 144/255, 154/255>;
#declare CN_Harbor_Blue = rgb <85/255, 102/255, 153/255>;
#declare CN_Harbor_Mist = rgb <136/255, 170/255, 170/255>;
#declare CN_Harbour = rgb <73/255, 88/255, 103/255>;
#declare CN_Harbour_Afternoon = rgb <224/255, 233/255, 243/255>;
#declare CN_Harbour_Blue = rgb <65/255, 116/255, 145/255>;
#declare CN_Harbour_Fog = rgb <175/255, 177/255, 180/255>;
#declare CN_Harbour_Grey = rgb <168/255, 192/255, 187/255>;
#declare CN_Harbour_Light = rgb <215/255, 224/255, 231/255>;
#declare CN_Harbour_Mist = rgb <218/255, 225/255, 227/255>;
#declare CN_Harbour_Mist_Grey = rgb <119/255, 128/255, 113/255>;
#declare CN_Harbour_Rat = rgb <117/255, 125/255, 117/255>;
#declare CN_Harbour_Sky = rgb <126/255, 182/255, 208/255>;
#declare CN_Harbourmaster = rgb <78/255, 83/255, 107/255>;
#declare CN_Hard_Candy = rgb <255/255, 187/255, 187/255>;
#declare CN_Hard_Coal = rgb <101/255, 100/255, 100/255>;
#declare CN_Hardware = rgb <139/255, 131/255, 114/255>;
#declare CN_Harem_Silk = rgb <0/255, 99/255, 131/255>;
#declare CN_Harissa_Red = rgb <165/255, 42/255, 42/255>;
#declare CN_Harlequin = rgb <63/255, 255/255, 0/255>;
#declare CN_Harlequin_Green = rgb <70/255, 203/255, 24/255>;
#declare CN_Harley_Davidson_Orange = rgb <201/255, 52/255, 19/255>;
#declare CN_Harlocks_Cape = rgb <187/255, 0/255, 0/255>;
#declare CN_Harmonic_Tan = rgb <193/255, 178/255, 135/255>;
#declare CN_Harmonious = rgb <175/255, 193/255, 149/255>;
#declare CN_Harmonious_Gold = rgb <234/255, 207/255, 163/255>;
#declare CN_Harmonious_Rose = rgb <242/255, 156/255, 183/255>;
#declare CN_Harold = rgb <109/255, 99/255, 83/255>;
#declare CN_Harp = rgb <203/255, 206/255, 192/255>;
#declare CN_Harpoon = rgb <40/255, 59/255, 76/255>;
#declare CN_Harpy_Brown = rgb <73/255, 60/255, 43/255>;
#declare CN_Harrison_Grey = rgb <152/255, 155/255, 158/255>;
#declare CN_Harrison_Rust = rgb <154/255, 95/255, 63/255>;
#declare CN_Harrow_Gate = rgb <219/255, 212/255, 199/255>;
#declare CN_Harrows_Gate = rgb <126/255, 142/255, 144/255>;
#declare CN_Harvard_Crimson = rgb <201/255, 0/255, 22/255>;
#declare CN_Harvest_at_Dusk = rgb <203/255, 134/255, 44/255>;
#declare CN_Harvest_Blessing = rgb <186/255, 142/255, 78/255>;
#declare CN_Harvest_Brown = rgb <185/255, 165/255, 137/255>;
#declare CN_Harvest_Dance = rgb <165/255, 153/255, 124/255>;
#declare CN_Harvest_Eve_Gold = rgb <218/255, 145/255, 0/255>;
#declare CN_Harvest_Gold = rgb <234/255, 183/255, 106/255>;
#declare CN_Harvest_Home = rgb <203/255, 174/255, 132/255>;
#declare CN_Harvest_Night = rgb <85/255, 68/255, 136/255>;
#declare CN_Harvest_Oak = rgb <101/255, 86/255, 79/255>;
#declare CN_Harvest_Pumpkin = rgb <213/255, 98/255, 49/255>;
#declare CN_Harvest_Time = rgb <207/255, 135/255, 95/255>;
#declare CN_Harvest_Wreath = rgb <247/255, 215/255, 196/255>;
#declare CN_Harvester = rgb <237/255, 195/255, 142/255>;
#declare CN_Hashibami_Brown = rgb <191/255, 164/255, 111/255>;
#declare CN_Hashita_Purple = rgb <141/255, 96/255, 140/255>;
#declare CN_Hashut_Copper = rgb <201/255, 100/255, 59/255>;
#declare CN_Hassan_II_Mosque = rgb <0/255, 158/255, 109/255>;
#declare CN_Hat_Box_Brown = rgb <143/255, 119/255, 93/255>;
#declare CN_Hatching_Chameleon = rgb <207/255, 235/255, 222/255>;
#declare CN_Hatoba_Pigeon = rgb <149/255, 133/255, 156/255>;
#declare CN_Hatoba_Nezumi_Grey = rgb <158/255, 139/255, 142/255>;
#declare CN_Haunted_Dreams = rgb <51/255, 51/255, 85/255>;
#declare CN_Haunted_Hills = rgb <0/255, 51/255, 17/255>;
#declare CN_Haunting_Hue = rgb <211/255, 224/255, 236/255>;
#declare CN_Haunting_Melody = rgb <130/255, 72/255, 85/255>;
#declare CN_Haute_Couture = rgb <160/255, 37/255, 42/255>;
#declare CN_Haute_Pink = rgb <216/255, 153/255, 177/255>;
#declare CN_Haute_Red = rgb <161/255, 23/255, 41/255>;
#declare CN_Havana = rgb <59/255, 43/255, 44/255>;
#declare CN_Havana_Blue = rgb <165/255, 219/255, 229/255>;
#declare CN_Havana_Cigar = rgb <175/255, 136/255, 74/255>;
#declare CN_Havana_Coffee = rgb <85/255, 73/255, 65/255>;
#declare CN_Havana_Cream = rgb <249/255, 229/255, 194/255>;
#declare CN_Havasu = rgb <0/255, 121/255, 147/255>;
#declare CN_Havasupai_Falls = rgb <15/255, 175/255, 198/255>;
#declare CN_Havelock_Blue = rgb <87/255, 132/255, 193/255>;
#declare CN_Haven = rgb <163/255, 180/255, 140/255>;
#declare CN_Hawaii_Morning = rgb <0/255, 187/255, 255/255>;
#declare CN_Hawaiian_Breeze = rgb <117/255, 199/255, 224/255>;
#declare CN_Hawaiian_Cinder = rgb <111/255, 69/255, 66/255>;
#declare CN_Hawaiian_Coconut = rgb <153/255, 82/255, 44/255>;
#declare CN_Hawaiian_Cream = rgb <250/255, 232/255, 184/255>;
#declare CN_Hawaiian_Ocean = rgb <0/255, 141/255, 185/255>;
#declare CN_Hawaiian_Passion = rgb <255/255, 160/255, 62/255>;
#declare CN_Hawaiian_Pineapple = rgb <253/255, 215/255, 115/255>;
#declare CN_Hawaiian_Shell = rgb <243/255, 219/255, 217/255>;
#declare CN_Hawaiian_Sky = rgb <131/255, 162/255, 189/255>;
#declare CN_Hawaiian_Sunset = rgb <187/255, 92/255, 20/255>;
#declare CN_Hawaiian_Surf = rgb <0/255, 120/255, 167/255>;
#declare CN_Hawaiian_Vacation = rgb <119/255, 202/255, 189/255>;
#declare CN_Hawk_Grey = rgb <119/255, 117/255, 125/255>;
#declare CN_Hawk_Turquoise = rgb <0/255, 117/255, 106/255>;
#declare CN_Hawk_s_Eye = rgb <52/255, 54/255, 58/255>;
#declare CN_Hawkbit = rgb <253/255, 219/255, 109/255>;
#declare CN_Hawkers_Gold = rgb <244/255, 194/255, 108/255>;
#declare CN_Hawkes_Blue = rgb <210/255, 218/255, 237/255>;
#declare CN_Hawkesbury = rgb <114/255, 145/255, 131/255>;
#declare CN_Hawthorn_Berry = rgb <204/255, 17/255, 17/255>;
#declare CN_Hawthorn_Blossom = rgb <238/255, 255/255, 170/255>;
#declare CN_Hawthorn_Rose = rgb <136/255, 76/255, 94/255>;
#declare CN_Hawthorne = rgb <206/255, 215/255, 193/255>;
#declare CN_Hay = rgb <211/255, 204/255, 163/255>;
#declare CN_Hay_Day = rgb <218/255, 205/255, 129/255>;
#declare CN_Hay_Wain = rgb <205/255, 173/255, 89/255>;
#declare CN_Hay_Yellow = rgb <194/255, 167/255, 112/255>;
#declare CN_Hayden_Valley = rgb <95/255, 93/255, 80/255>;
#declare CN_Hayloft = rgb <205/255, 186/255, 150/255>;
#declare CN_Hayride = rgb <212/255, 172/255, 153/255>;
#declare CN_Haystack = rgb <241/255, 227/255, 199/255>;
#declare CN_Haystacks = rgb <207/255, 172/255, 71/255>;
#declare CN_Haze = rgb <200/255, 194/255, 198/255>;
#declare CN_Haze_Blue = rgb <183/255, 192/255, 190/255>;
#declare CN_Hazed_Nuts = rgb <195/255, 158/255, 109/255>;
#declare CN_Hazel = rgb <174/255, 114/255, 80/255>;
#declare CN_Hazel_Blush = rgb <234/255, 226/255, 222/255>;
#declare CN_Hazel_Gaze = rgb <184/255, 191/255, 177/255>;
#declare CN_Hazel_Woods = rgb <74/255, 86/255, 77/255>;
#declare CN_Hazelnut = rgb <168/255, 113/255, 90/255>;
#declare CN_Hazelnut_Chocolate = rgb <123/255, 63/255, 0/255>;
#declare CN_Hazelnut_Cream = rgb <230/255, 223/255, 207/255>;
#declare CN_Hazelnut_Milk = rgb <238/255, 170/255, 119/255>;
#declare CN_Hazelnut_Turkish_Delight = rgb <252/255, 233/255, 116/255>;
#declare CN_Hazelwood = rgb <255/255, 243/255, 213/255>;
#declare CN_Hazy_Blue = rgb <188/255, 200/255, 204/255>;
#declare CN_Hazy_Daze = rgb <165/255, 184/255, 197/255>;
#declare CN_Hazy_Grove = rgb <242/255, 241/255, 220/255>;
#declare CN_Hazy_Mauve = rgb <200/255, 198/255, 206/255>;
#declare CN_Hazy_Moon = rgb <241/255, 220/255, 161/255>;
#declare CN_Hazy_Rose = rgb <179/255, 152/255, 151/255>;
#declare CN_Hazy_Skies = rgb <173/255, 187/255, 196/255>;
#declare CN_Hazy_Sky = rgb <183/255, 189/255, 214/255>;
#declare CN_Hazy_Taupe = rgb <213/255, 195/255, 181/255>;
#declare CN_Hazy_Trail = rgb <220/255, 218/255, 206/255>;
#declare CN_He_Loves_Me = rgb <225/255, 219/255, 227/255>;
#declare CN_He_Se_Brown = rgb <127/255, 94/255, 0/255>;
#declare CN_Head_in_the_Clouds = rgb <209/255, 221/255, 225/255>;
#declare CN_Head_in_the_Sand = rgb <235/255, 226/255, 222/255>;
#declare CN_Healing_Aloe = rgb <185/255, 202/255, 179/255>;
#declare CN_Healing_Plant = rgb <108/255, 125/255, 66/255>;
#declare CN_Healing_Retreat = rgb <186/255, 194/255, 170/255>;
#declare CN_Heart_Gold = rgb <128/255, 128/255, 0/255>;
#declare CN_Heart_of_Gold = rgb <157/255, 127/255, 76/255>;
#declare CN_Heart_Stone = rgb <237/255, 227/255, 223/255>;
#declare CN_Heart_Throb = rgb <203/255, 61/255, 60/255>;
#declare CN_Heart_to_Heart = rgb <212/255, 169/255, 195/255>;
#declare CN_Hearts_Content = rgb <226/255, 181/255, 189/255>;
#declare CN_Hearts_Desire = rgb <172/255, 62/255, 95/255>;
#declare CN_Heartbeat = rgb <170/255, 0/255, 0/255>;
#declare CN_Heartbreaker = rgb <204/255, 118/255, 163/255>;
#declare CN_Heartfelt = rgb <255/255, 173/255, 201/255>;
#declare CN_Hearth = rgb <225/255, 204/255, 166/255>;
#declare CN_Hearth_Gold = rgb <161/255, 113/255, 53/255>;
#declare CN_Hearthstone = rgb <199/255, 190/255, 178/255>;
#declare CN_Heartless = rgb <98/255, 59/255, 112/255>;
#declare CN_Hearts_of_Palm = rgb <207/255, 194/255, 145/255>;
#declare CN_Heartthrob = rgb <168/255, 46/255, 51/255>;
#declare CN_Heartwood = rgb <111/255, 66/255, 50/255>;
#declare CN_Hearty_Hosta = rgb <150/255, 191/255, 131/255>;
#declare CN_Hearty_Orange = rgb <180/255, 75/255, 52/255>;
#declare CN_Heat_of_Summer = rgb <233/255, 141/255, 91/255>;
#declare CN_Heat_Signature = rgb <227/255, 0/255, 14/255>;
#declare CN_Heat_Wave = rgb <255/255, 122/255, 0/255>;
#declare CN_Heath = rgb <79/255, 42/255, 44/255>;
#declare CN_Heath_Green = rgb <154/255, 205/255, 169/255>;
#declare CN_Heath_Grey = rgb <201/255, 203/255, 194/255>;
#declare CN_Heath_Spotted_Orchid = rgb <159/255, 95/255, 159/255>;
#declare CN_Heather = rgb <164/255, 132/255, 172/255>;
#declare CN_Heather_Berry = rgb <231/255, 84/255, 128/255>;
#declare CN_Heather_Feather = rgb <195/255, 173/255, 197/255>;
#declare CN_Heather_Field = rgb <144/255, 144/255, 149/255>;
#declare CN_Heather_Grey = rgb <156/255, 157/255, 164/255>;
#declare CN_Heather_Hill = rgb <187/255, 176/255, 187/255>;
#declare CN_Heather_Moor = rgb <153/255, 142/255, 143/255>;
#declare CN_Heather_Plume = rgb <163/255, 150/255, 153/255>;
#declare CN_Heather_Red_Grey = rgb <152/255, 142/255, 148/255>;
#declare CN_Heather_Rose = rgb <173/255, 109/255, 127/255>;
#declare CN_Heather_Sachet = rgb <123/255, 113/255, 115/255>;
#declare CN_Heather_Violet = rgb <177/255, 131/255, 152/255>;
#declare CN_Heathered_Grey = rgb <182/255, 176/255, 149/255>;
#declare CN_Heating_Lamp = rgb <238/255, 68/255, 34/255>;
#declare CN_Heaven_Sent = rgb <238/255, 225/255, 235/255>;
#declare CN_Heaven_Sent_Storm = rgb <202/255, 214/255, 222/255>;
#declare CN_Heavenly = rgb <126/255, 178/255, 197/255>;
#declare CN_Heavenly_Aromas = rgb <238/255, 223/255, 213/255>;
#declare CN_Heavenly_Blue = rgb <163/255, 187/255, 205/255>;
#declare CN_Heavenly_Cocoa = rgb <190/255, 167/255, 157/255>;
#declare CN_Heavenly_Garden = rgb <147/255, 163/255, 148/255>;
#declare CN_Heavenly_Haze = rgb <216/255, 213/255, 227/255>;
#declare CN_Heavenly_Pink = rgb <244/255, 222/255, 222/255>;
#declare CN_Heavenly_Sky = rgb <107/255, 144/255, 179/255>;
#declare CN_Heavenly_Song = rgb <251/255, 217/255, 198/255>;
#declare CN_Heavenly_White = rgb <235/255, 232/255, 230/255>;
#declare CN_Heavy_Black_Green = rgb <58/255, 81/255, 77/255>;
#declare CN_Heavy_Blue_Grey = rgb <159/255, 171/255, 175/255>;
#declare CN_Heavy_Brown = rgb <115/255, 98/255, 74/255>;
#declare CN_Heavy_Charcoal = rgb <86/255, 83/255, 80/255>;
#declare CN_Heavy_Cream = rgb <232/255, 221/255, 198/255>;
#declare CN_Heavy_Gluten = rgb <221/255, 204/255, 170/255>;
#declare CN_Heavy_Goldbrown = rgb <186/255, 171/255, 116/255>;
#declare CN_Heavy_Green = rgb <73/255, 88/255, 62/255>;
#declare CN_Heavy_Grey = rgb <130/255, 134/255, 138/255>;
#declare CN_Heavy_Hammock = rgb <190/255, 185/255, 162/255>;
#declare CN_Heavy_Heart = rgb <119/255, 17/255, 34/255>;
#declare CN_Heavy_Khaki = rgb <94/255, 106/255, 52/255>;
#declare CN_Heavy_Metal = rgb <70/255, 71/255, 62/255>;
#declare CN_Heavy_Metal_Armor = rgb <136/255, 138/255, 142/255>;
#declare CN_Heavy_Ochre = rgb <155/255, 117/255, 61/255>;
#declare CN_Heavy_Orange = rgb <238/255, 67/255, 40/255>;
#declare CN_Heavy_Rain = rgb <137/255, 138/255, 134/255>;
#declare CN_Heavy_Red = rgb <158/255, 18/255, 18/255>;
#declare CN_Heavy_Siena = rgb <115/255, 88/255, 72/255>;
#declare CN_Heavy_Skintone = rgb <146/255, 122/255, 113/255>;
#declare CN_Heavy_Sugar = rgb <239/255, 245/255, 241/255>;
#declare CN_Heavy_Violet = rgb <79/255, 86/255, 108/255>;
#declare CN_Heavy_Warm_Grey = rgb <189/255, 179/255, 167/255>;
#declare CN_Hectorite = rgb <240/255, 228/255, 210/255>;
#declare CN_Hedge_Garden = rgb <0/255, 170/255, 17/255>;
#declare CN_Hedge_Green = rgb <118/255, 138/255, 117/255>;
#declare CN_Hedgehog_Cactus_Yellow_Green = rgb <196/255, 170/255, 94/255>;
#declare CN_Hedgehog_Mushroom = rgb <250/255, 240/255, 218/255>;
#declare CN_Hei_Se_Black = rgb <20/255, 32/255, 48/255>;
#declare CN_Heidelberg_Red = rgb <150/255, 1/255, 23/255>;
#declare CN_Heifer = rgb <195/255, 189/255, 177/255>;
#declare CN_Heirloom = rgb <182/255, 123/255, 113/255>;
#declare CN_Heirloom_Apricot = rgb <244/255, 190/255, 166/255>;
#declare CN_Heirloom_Hydrangea = rgb <50/255, 124/255, 203/255>;
#declare CN_Heirloom_Lace = rgb <245/255, 230/255, 214/255>;
#declare CN_Heirloom_Lilac = rgb <157/255, 150/255, 178/255>;
#declare CN_Heirloom_Orchid = rgb <174/255, 153/255, 153/255>;
#declare CN_Heirloom_Quilt = rgb <171/255, 151/255, 154/255>;
#declare CN_Heirloom_Rose = rgb <209/255, 130/255, 160/255>;
#declare CN_Heirloom_Shade = rgb <220/255, 216/255, 212/255>;
#declare CN_Heirloom_Silver = rgb <181/255, 182/255, 173/255>;
#declare CN_Heirloom_Tomato = rgb <131/255, 54/255, 51/255>;
#declare CN_Heisenberg_Blue = rgb <112/255, 212/255, 251/255>;
#declare CN_Helen_of_Troy = rgb <195/255, 184/255, 159/255>;
#declare CN_Helena_Rose = rgb <210/255, 139/255, 114/255>;
#declare CN_Heliotrope = rgb <217/255, 79/255, 245/255>;
#declare CN_Heliotrope_Grey = rgb <171/255, 152/255, 169/255>;
#declare CN_Heliotrope_Magenta = rgb <170/255, 0/255, 187/255>;
#declare CN_Heliotropic_Mauve = rgb <145/255, 135/255, 189/255>;
#declare CN_Helium = rgb <234/255, 229/255, 216/255>;
#declare CN_Hellebore = rgb <100/255, 105/255, 68/255>;
#declare CN_Hellion_Green = rgb <135/255, 197/255, 174/255>;
#declare CN_Hello_Darkness_My_Old_Friend = rgb <128/255, 34/255, 128/255>;
#declare CN_Hello_Fall = rgb <153/255, 85/255, 51/255>;
#declare CN_Hello_Spring = rgb <68/255, 221/255, 102/255>;
#declare CN_Hello_Summer = rgb <85/255, 187/255, 255/255>;
#declare CN_Hello_Winter = rgb <153/255, 255/255, 238/255>;
#declare CN_Hello_Yellow = rgb <255/255, 229/255, 157/255>;
#declare CN_Helvetia_Red = rgb <240/255, 0/255, 0/255>;
#declare CN_Hematite = rgb <95/255, 97/255, 95/255>;
#declare CN_Hematitic_Sand = rgb <220/255, 140/255, 89/255>;
#declare CN_Hemisphere = rgb <82/255, 133/255, 164/255>;
#declare CN_Hemlock = rgb <105/255, 104/255, 75/255>;
#declare CN_Hemlock_Bud = rgb <236/255, 238/255, 223/255>;
#declare CN_Hemoglobin_Red = rgb <198/255, 26/255, 27/255>;
#declare CN_Hemp = rgb <152/255, 125/255, 115/255>;
#declare CN_Hemp_Fabric = rgb <181/255, 173/255, 136/255>;
#declare CN_Hemp_Rope = rgb <185/255, 163/255, 121/255>;
#declare CN_Hemp_Tea = rgb <181/255, 179/255, 92/255>;
#declare CN_Hen_of_the_Woods = rgb <238/255, 217/255, 196/255>;
#declare CN_Henna = rgb <124/255, 66/255, 60/255>;
#declare CN_Henna_Red = rgb <110/255, 53/255, 48/255>;
#declare CN_Henna_Shade = rgb <179/255, 103/255, 93/255>;
#declare CN_Hep_Green = rgb <196/255, 177/255, 70/255>;
#declare CN_Hepatica = rgb <251/255, 229/255, 234/255>;
#declare CN_Hephaestus = rgb <225/255, 212/255, 182/255>;
#declare CN_Hephaestus_Gold = rgb <255/255, 153/255, 17/255>;
#declare CN_Hera_Blue = rgb <119/255, 119/255, 238/255>;
#declare CN_Herald_of_Spring = rgb <164/255, 99/255, 102/255>;
#declare CN_Heralds_Trumpet = rgb <206/255, 159/255, 47/255>;
#declare CN_Heraldic = rgb <68/255, 65/255, 97/255>;
#declare CN_Herare_White = rgb <231/255, 224/255, 211/255>;
#declare CN_Herb_Cornucopia = rgb <110/255, 115/255, 87/255>;
#declare CN_Herb_Garden = rgb <233/255, 243/255, 225/255>;
#declare CN_Herb_Robert = rgb <221/255, 160/255, 223/255>;
#declare CN_Herbal = rgb <41/255, 171/255, 135/255>;
#declare CN_Herbal_Garden = rgb <156/255, 173/255, 96/255>;
#declare CN_Herbal_Mist = rgb <210/255, 230/255, 211/255>;
#declare CN_Herbal_Scent = rgb <142/255, 155/255, 124/255>;
#declare CN_Herbal_Tea = rgb <249/255, 254/255, 233/255>;
#declare CN_Herbal_Vapors = rgb <221/255, 255/255, 204/255>;
#declare CN_Herbal_Wash = rgb <164/255, 155/255, 130/255>;
#declare CN_Herbalist = rgb <150/255, 158/255, 134/255>;
#declare CN_Herbery_Honey = rgb <238/255, 238/255, 34/255>;
#declare CN_Herbivore = rgb <136/255, 238/255, 119/255>;
#declare CN_Here_Comes_the_Sun = rgb <252/255, 223/255, 99/255>;
#declare CN_Hereford_Bull = rgb <95/255, 59/255, 54/255>;
#declare CN_Hereford_Cow_Brown = rgb <108/255, 46/255, 31/255>;
#declare CN_Heritage = rgb <176/255, 186/255, 204/255>;
#declare CN_Heritage_Blue = rgb <93/255, 150/255, 188/255>;
#declare CN_Heritage_Oak = rgb <92/255, 69/255, 61/255>;
#declare CN_Heritage_Park = rgb <105/255, 117/255, 108/255>;
#declare CN_Heritage_Taffeta = rgb <149/255, 111/255, 123/255>;
#declare CN_Hermosa_Pink = rgb <138/255, 71/255, 76/255>;
#declare CN_Hero = rgb <0/255, 93/255, 106/255>;
#declare CN_Heroic_Blue = rgb <17/255, 102/255, 255/255>;
#declare CN_Heron = rgb <98/255, 97/255, 126/255>;
#declare CN_Heron_Plume = rgb <229/255, 225/255, 216/255>;
#declare CN_Herring_Silver = rgb <198/255, 200/255, 207/255>;
#declare CN_Hesperide_Apple_Gold = rgb <255/255, 226/255, 150/255>;
#declare CN_Hestia_Red = rgb <238/255, 34/255, 0/255>;
#declare CN_Hexed_Lichen = rgb <110/255, 0/255, 96/255>;
#declare CN_Hexos_Palesun = rgb <251/255, 255/255, 10/255>;
#declare CN_Hey_Blue_ = rgb <22/255, 248/255, 255/255>;
#declare CN_Hi_Def_Lime = rgb <187/255, 180/255, 101/255>;
#declare CN_Hibernate = rgb <172/255, 166/255, 159/255>;
#declare CN_Hibernation = rgb <111/255, 81/255, 102/255>;
#declare CN_Hibiscus = rgb <182/255, 49/255, 108/255>;
#declare CN_Hibiscus_Delight = rgb <254/255, 151/255, 115/255>;
#declare CN_Hibiscus_Flower = rgb <188/255, 85/255, 94/255>;
#declare CN_Hibiscus_Leaf = rgb <110/255, 130/255, 110/255>;
#declare CN_Hibiscus_Petal = rgb <237/255, 170/255, 172/255>;
#declare CN_Hibiscus_Pop = rgb <221/255, 119/255, 221/255>;
#declare CN_Hibiscus_Punch = rgb <92/255, 61/255, 69/255>;
#declare CN_Hibiscus_Red = rgb <163/255, 55/255, 55/255>;
#declare CN_Hickory = rgb <183/255, 162/255, 142/255>;
#declare CN_Hickory_Branch = rgb <171/255, 130/255, 116/255>;
#declare CN_Hickory_Cliff = rgb <124/255, 110/255, 109/255>;
#declare CN_Hickory_Grove = rgb <101/255, 83/255, 65/255>;
#declare CN_Hickory_Nut = rgb <120/255, 97/255, 76/255>;
#declare CN_Hickory_Stick = rgb <153/255, 119/255, 114/255>;
#declare CN_Hidcote = rgb <156/255, 148/255, 155/255>;
#declare CN_Hidden_Cottage = rgb <141/255, 127/255, 100/255>;
#declare CN_Hidden_Cove = rgb <206/255, 198/255, 189/255>;
#declare CN_Hidden_Creek = rgb <213/255, 218/255, 224/255>;
#declare CN_Hidden_Depths = rgb <48/255, 84/255, 81/255>;
#declare CN_Hidden_Diary = rgb <237/255, 228/255, 204/255>;
#declare CN_Hidden_Forest = rgb <79/255, 90/255, 81/255>;
#declare CN_Hidden_Glade = rgb <152/255, 173/255, 142/255>;
#declare CN_Hidden_Hills = rgb <197/255, 210/255, 177/255>;
#declare CN_Hidden_Jade = rgb <235/255, 241/255, 226/255>;
#declare CN_Hidden_Mask = rgb <150/255, 116/255, 138/255>;
#declare CN_Hidden_Meadow = rgb <187/255, 204/255, 90/255>;
#declare CN_Hidden_Paradise = rgb <94/255, 139/255, 61/255>;
#declare CN_Hidden_Peak = rgb <114/255, 125/255, 127/255>;
#declare CN_Hidden_Sapphire = rgb <68/255, 87/255, 113/255>;
#declare CN_Hidden_Sea_Glass = rgb <111/255, 209/255, 201/255>;
#declare CN_Hidden_Trail = rgb <95/255, 91/255, 77/255>;
#declare CN_Hidden_Treasure = rgb <165/255, 144/255, 116/255>;
#declare CN_Hidden_Tribe = rgb <187/255, 153/255, 0/255>;
#declare CN_Hidden_Waters = rgb <34/255, 82/255, 88/255>;
#declare CN_Hideaway = rgb <200/255, 192/255, 170/255>;
#declare CN_Hideout = rgb <83/255, 134/255, 183/255>;
#declare CN_Hierba_Santa = rgb <119/255, 163/255, 115/255>;
#declare CN_High_Altar = rgb <51/255, 79/255, 123/255>;
#declare CN_High_Blue = rgb <76/255, 168/255, 224/255>;
#declare CN_High_Chaparral = rgb <117/255, 96/255, 61/255>;
#declare CN_High_Dive = rgb <89/255, 185/255, 204/255>;
#declare CN_High_Drama = rgb <154/255, 56/255, 67/255>;
#declare CN_High_Elf_Blue = rgb <140/255, 190/255, 214/255>;
#declare CN_High_Forest_Green = rgb <102/255, 93/255, 37/255>;
#declare CN_High_Grass = rgb <187/255, 221/255, 0/255>;
#declare CN_High_Hopes = rgb <222/255, 234/255, 170/255>;
#declare CN_High_Maintenance = rgb <216/255, 140/255, 181/255>;
#declare CN_High_Noon = rgb <207/255, 185/255, 153/255>;
#declare CN_High_Plateau = rgb <228/255, 179/255, 122/255>;
#declare CN_High_Point = rgb <188/255, 216/255, 210/255>;
#declare CN_High_Priest = rgb <100/255, 57/255, 73/255>;
#declare CN_High_Profile = rgb <0/255, 90/255, 133/255>;
#declare CN_High_Rank = rgb <100/255, 84/255, 83/255>;
#declare CN_High_Reflective_White = rgb <247/255, 247/255, 241/255>;
#declare CN_High_Rise = rgb <174/255, 178/255, 181/255>;
#declare CN_High_Risk_Red = rgb <199/255, 31/255, 45/255>;
#declare CN_High_Salute = rgb <68/255, 80/255, 86/255>;
#declare CN_High_Sierra = rgb <206/255, 222/255, 226/255>;
#declare CN_High_Society = rgb <202/255, 183/255, 192/255>;
#declare CN_High_Speed_Access = rgb <189/255, 190/255, 191/255>;
#declare CN_High_Strung = rgb <172/255, 152/255, 37/255>;
#declare CN_High_Style = rgb <168/255, 177/255, 215/255>;
#declare CN_High_Style_Beige = rgb <228/255, 215/255, 195/255>;
#declare CN_High_Tea = rgb <127/255, 111/255, 87/255>;
#declare CN_High_Tea_Green = rgb <86/255, 112/255, 99/255>;
#declare CN_High_Voltage = rgb <238/255, 255/255, 17/255>;
#declare CN_Highball = rgb <146/255, 140/255, 60/255>;
#declare CN_Highland = rgb <122/255, 148/255, 97/255>;
#declare CN_Highland_Green = rgb <48/255, 81/255, 68/255>;
#declare CN_Highland_Ridge = rgb <143/255, 113/255, 75/255>;
#declare CN_Highland_Thistle = rgb <185/255, 161/255, 174/255>;
#declare CN_Highlander = rgb <58/255, 83/255, 61/255>;
#declare CN_Highlands_Moss = rgb <68/255, 85/255, 0/255>;
#declare CN_Highlands_Twilight = rgb <72/255, 74/255, 128/255>;
#declare CN_Highlight = rgb <238/255, 240/255, 222/255>;
#declare CN_Highlight_Gold = rgb <223/255, 193/255, 109/255>;
#declare CN_Highlighter = rgb <255/255, 229/255, 54/255>;
#declare CN_Highlighter_Blue = rgb <58/255, 175/255, 220/255>;
#declare CN_Highlighter_Green = rgb <27/255, 252/255, 6/255>;
#declare CN_Highlighter_Lavender = rgb <133/255, 86/255, 156/255>;
#declare CN_Highlighter_Lilac = rgb <215/255, 46/255, 131/255>;
#declare CN_Highlighter_Orange = rgb <243/255, 149/255, 57/255>;
#declare CN_Highlighter_Pink = rgb <234/255, 90/255, 121/255>;
#declare CN_Highlighter_Red = rgb <233/255, 79/255, 88/255>;
#declare CN_Highlighter_Turquoise = rgb <0/255, 158/255, 108/255>;
#declare CN_Highlighter_Yellow = rgb <241/255, 231/255, 64/255>;
#declare CN_Highway = rgb <189/255, 179/255, 136/255>;
#declare CN_Highway_to_Hell = rgb <205/255, 17/255, 2/255>;
#declare CN_Hihada_Brown = rgb <117/255, 46/255, 35/255>;
#declare CN_Hikers_Delight = rgb <210/255, 179/255, 149/255>;
#declare CN_Hiking_Boots = rgb <94/255, 84/255, 64/255>;
#declare CN_Hiking_Trail = rgb <169/255, 145/255, 112/255>;
#declare CN_Hill_Giant = rgb <224/255, 238/255, 223/255>;
#declare CN_Hillary = rgb <167/255, 160/255, 126/255>;
#declare CN_Hills_of_Ireland = rgb <65/255, 123/255, 66/255>;
#declare CN_Hillsbrad_Grass = rgb <127/255, 169/255, 31/255>;
#declare CN_Hillside_Green = rgb <143/255, 151/255, 131/255>;
#declare CN_Hillside_View = rgb <141/255, 160/255, 144/255>;
#declare CN_Hilltop = rgb <88/255, 115/255, 102/255>;
#declare CN_Hilo_Bay = rgb <118/255, 138/255, 161/255>;
#declare CN_Himalaya = rgb <115/255, 99/255, 48/255>;
#declare CN_Himalaya_Blue = rgb <174/255, 205/255, 224/255>;
#declare CN_Himalaya_Peaks = rgb <226/255, 234/255, 240/255>;
#declare CN_Himalaya_Sky = rgb <118/255, 149/255, 194/255>;
#declare CN_Himalaya_White_Blue = rgb <185/255, 222/255, 233/255>;
#declare CN_Himalayan_Balsam = rgb <255/255, 153/255, 204/255>;
#declare CN_Himalayan_Mist = rgb <225/255, 240/255, 237/255>;
#declare CN_Himalayan_Poppy = rgb <190/255, 198/255, 214/255>;
#declare CN_Himalayan_Salt = rgb <192/255, 119/255, 101/255>;
#declare CN_Himawari_Yellow = rgb <252/255, 200/255, 0/255>;
#declare CN_Hindsight = rgb <189/255, 201/255, 227/255>;
#declare CN_Hindu_Lotus = rgb <142/255, 128/255, 98/255>;
#declare CN_Hinoki = rgb <248/255, 221/255, 183/255>;
#declare CN_Hinomaru_Red = rgb <188/255, 0/255, 45/255>;
#declare CN_Hint_of_Blue = rgb <206/255, 225/255, 242/255>;
#declare CN_Hint_of_Green = rgb <223/255, 234/255, 222/255>;
#declare CN_Hint_of_Mauve = rgb <225/255, 219/255, 213/255>;
#declare CN_Hint_of_Mint = rgb <223/255, 241/255, 214/255>;
#declare CN_Hint_of_Orange = rgb <248/255, 230/255, 217/255>;
#declare CN_Hint_of_Pink = rgb <241/255, 228/255, 225/255>;
#declare CN_Hint_of_Red = rgb <246/255, 223/255, 224/255>;
#declare CN_Hint_of_Vanilla = rgb <238/255, 232/255, 220/255>;
#declare CN_Hint_of_Violet = rgb <210/255, 213/255, 225/255>;
#declare CN_Hint_of_Yellow = rgb <250/255, 241/255, 205/255>;
#declare CN_Hinterland = rgb <97/255, 108/255, 81/255>;
#declare CN_Hinterlands_Green = rgb <48/255, 65/255, 18/255>;
#declare CN_Hinting_Blue = rgb <206/255, 217/255, 221/255>;
#declare CN_Hip_Hop = rgb <228/255, 232/255, 167/255>;
#declare CN_Hip_Waders = rgb <116/255, 106/255, 81/255>;
#declare CN_Hippie_Blue = rgb <73/255, 136/255, 154/255>;
#declare CN_Hippie_Green = rgb <96/255, 138/255, 90/255>;
#declare CN_Hippie_Pink = rgb <171/255, 73/255, 92/255>;
#declare CN_Hippie_Trail = rgb <198/255, 170/255, 43/255>;
#declare CN_Hippogriff_Brown = rgb <92/255, 60/255, 13/255>;
#declare CN_Hippolyta = rgb <207/255, 194/255, 148/255>;
#declare CN_Hippy = rgb <234/255, 229/255, 131/255>;
#declare CN_Hipster = rgb <242/255, 241/255, 217/255>;
#declare CN_Hipster_Hippo = rgb <191/255, 179/255, 171/255>;
#declare CN_Hipster_Salmon = rgb <253/255, 124/255, 110/255>;
#declare CN_Hipsterfication = rgb <136/255, 81/255, 62/255>;
#declare CN_Hiroshima_Aquamarine = rgb <127/255, 255/255, 212/255>;
#declare CN_His_Eyes = rgb <155/255, 185/255, 225/255>;
#declare CN_Hisoku_Blue = rgb <171/255, 206/255, 216/255>;
#declare CN_Historic_Cream = rgb <253/255, 243/255, 227/255>;
#declare CN_Historic_Shade = rgb <173/255, 167/255, 145/255>;
#declare CN_Historic_Town = rgb <161/255, 138/255, 100/255>;
#declare CN_Historic_White = rgb <235/255, 230/255, 215/255>;
#declare CN_Historical_Grey = rgb <167/255, 166/255, 153/255>;
#declare CN_Historical_Ruins = rgb <191/255, 185/255, 167/255>;
#declare CN_Hisui_Kingfisher = rgb <56/255, 180/255, 139/255>;
#declare CN_Hit_Grey = rgb <161/255, 173/255, 181/255>;
#declare CN_Hit_Pink = rgb <253/255, 164/255, 112/255>;
#declare CN_Hitchcock_Milk = rgb <238/255, 255/255, 169/255>;
#declare CN_Hitching_Post = rgb <196/255, 141/255, 105/255>;
#declare CN_Hitsujiyama_Pink = rgb <238/255, 102/255, 255/255>;
#declare CN_Hive = rgb <255/255, 255/255, 119/255>;
#declare CN_Hobgoblin = rgb <1/255, 173/255, 143/255>;
#declare CN_Hockham_Green = rgb <89/255, 104/255, 95/255>;
#declare CN_Hoeth_Blue = rgb <87/255, 169/255, 212/255>;
#declare CN_Hog_Bristle = rgb <220/255, 209/255, 187/255>;
#declare CN_Hog_Maw = rgb <251/255, 232/255, 228/255>;
#declare CN_Hogs_Pudding = rgb <218/255, 213/255, 199/255>;
#declare CN_Hokey_Pokey = rgb <187/255, 142/255, 52/255>;
#declare CN_Hoki = rgb <100/255, 125/255, 134/255>;
#declare CN_Hokkaido_Lavender = rgb <119/255, 54/255, 217/255>;
#declare CN_Holbein_Blue_Grey = rgb <84/255, 125/255, 134/255>;
#declare CN_Hold_Your_Horses = rgb <112/255, 84/255, 70/255>;
#declare CN_Hole_In_One = rgb <74/255, 174/255, 151/255>;
#declare CN_Holenso = rgb <89/255, 128/255, 105/255>;
#declare CN_Holiday = rgb <129/255, 195/255, 180/255>;
#declare CN_Holiday_Blue = rgb <50/255, 188/255, 209/255>;
#declare CN_Holiday_Camp = rgb <109/255, 158/255, 122/255>;
#declare CN_Holiday_Road = rgb <177/255, 209/255, 226/255>;
#declare CN_Holiday_Turquoise = rgb <138/255, 198/255, 189/255>;
#declare CN_Holland_Red = rgb <203/255, 69/255, 67/255>;
#declare CN_Holland_Tile = rgb <221/255, 151/255, 137/255>;
#declare CN_Holland_Tulip = rgb <248/255, 152/255, 81/255>;
#declare CN_Hollandaise = rgb <255/255, 238/255, 68/255>;
#declare CN_Hollow_Knight = rgb <51/255, 0/255, 85/255>;
#declare CN_Holly = rgb <37/255, 52/255, 43/255>;
#declare CN_Holly_Berry = rgb <180/255, 78/255, 93/255>;
#declare CN_Holly_Bush = rgb <53/255, 93/255, 81/255>;
#declare CN_Holly_Fern = rgb <140/255, 178/255, 153/255>;
#declare CN_Holly_Glen = rgb <162/255, 183/255, 181/255>;
#declare CN_Holly_Green = rgb <15/255, 157/255, 118/255>;
#declare CN_Holly_Jolly_Christmas = rgb <181/255, 7/255, 41/255>;
#declare CN_Holly_Leaf = rgb <46/255, 90/255, 80/255>;
#declare CN_Hollyhock = rgb <130/255, 50/255, 112/255>;
#declare CN_Hollyhock_Bloom = rgb <183/255, 115/255, 125/255>;
#declare CN_Hollyhock_Blossom_Pink = rgb <189/255, 121/255, 165/255>;
#declare CN_Hollyhock_Pink = rgb <194/255, 161/255, 181/255>;
#declare CN_Hollywood_Asparagus = rgb <222/255, 231/255, 212/255>;
#declare CN_Hollywood_Cerise = rgb <244/255, 0/255, 160/255>;
#declare CN_Hollywood_Golden_Age = rgb <236/255, 216/255, 177/255>;
#declare CN_Hollywood_Starlet = rgb <242/255, 208/255, 130/255>;
#declare CN_Holy_Crow = rgb <51/255, 47/255, 44/255>;
#declare CN_Holy_Grail = rgb <232/255, 215/255, 32/255>;
#declare CN_Holy_Water = rgb <70/255, 110/255, 119/255>;
#declare CN_Holy_White = rgb <245/255, 245/255, 220/255>;
#declare CN_Homburg_Gray = rgb <102/255, 109/255, 105/255>;
#declare CN_Home_Body = rgb <243/255, 210/255, 178/255>;
#declare CN_Home_Brew = rgb <137/255, 123/255, 102/255>;
#declare CN_Home_Plate = rgb <247/255, 238/255, 219/255>;
#declare CN_Home_Song = rgb <242/255, 238/255, 199/255>;
#declare CN_Home_Sweet_Home = rgb <155/255, 126/255, 101/255>;
#declare CN_Homebush = rgb <114/255, 110/255, 105/255>;
#declare CN_Homeland = rgb <177/255, 141/255, 117/255>;
#declare CN_Homeopathic = rgb <95/255, 124/255, 71/255>;
#declare CN_Homeopathic_Blue = rgb <219/255, 231/255, 227/255>;
#declare CN_Homeopathic_Green = rgb <225/255, 235/255, 216/255>;
#declare CN_Homeopathic_Lavender = rgb <229/255, 224/255, 236/255>;
#declare CN_Homeopathic_Lilac = rgb <225/255, 224/255, 235/255>;
#declare CN_Homeopathic_Lime = rgb <233/255, 246/255, 226/255>;
#declare CN_Homeopathic_Mint = rgb <229/255, 234/255, 216/255>;
#declare CN_Homeopathic_Orange = rgb <242/255, 230/255, 225/255>;
#declare CN_Homeopathic_Red = rgb <236/255, 219/255, 224/255>;
#declare CN_Homeopathic_Rose = rgb <232/255, 219/255, 221/255>;
#declare CN_Homeopathic_Yellow = rgb <237/255, 231/255, 215/255>;
#declare CN_Homestead = rgb <172/255, 134/255, 116/255>;
#declare CN_Homestead_Brown = rgb <111/255, 95/255, 82/255>;
#declare CN_Homestead_Red = rgb <152/255, 110/255, 110/255>;
#declare CN_Homeworld = rgb <34/255, 153/255, 221/255>;
#declare CN_Honed_Soapstone = rgb <157/255, 152/255, 135/255>;
#declare CN_Honed_Steel = rgb <134/255, 124/255, 131/255>;
#declare CN_Honest = rgb <155/255, 184/255, 226/255>;
#declare CN_Honest_Blue = rgb <90/255, 131/255, 158/255>;
#declare CN_Honesty = rgb <223/255, 235/255, 233/255>;
#declare CN_Honey = rgb <186/255, 146/255, 56/255>;
#declare CN_Honey_and_Thyme = rgb <170/255, 170/255, 0/255>;
#declare CN_Honey_Baked_Ham = rgb <255/255, 170/255, 153/255>;
#declare CN_Honey_Bear = rgb <232/255, 194/255, 129/255>;
#declare CN_Honey_Bee = rgb <252/255, 223/255, 164/255>;
#declare CN_Honey_Beehive = rgb <211/255, 159/255, 95/255>;
#declare CN_Honey_Bees = rgb <251/255, 214/255, 130/255>;
#declare CN_Honey_Beige = rgb <243/255, 226/255, 198/255>;
#declare CN_Honey_Bird = rgb <255/255, 210/255, 141/255>;
#declare CN_Honey_Blush = rgb <245/255, 207/255, 155/255>;
#declare CN_Honey_Bunny = rgb <219/255, 184/255, 129/255>;
#declare CN_Honey_Butter = rgb <245/255, 210/255, 155/255>;
#declare CN_Honey_Carrot_Cake = rgb <255/255, 153/255, 85/255>;
#declare CN_Honey_Chili = rgb <136/255, 51/255, 68/255>;
#declare CN_Honey_Cream = rgb <250/255, 232/255, 202/255>;
#declare CN_Honey_Crusted_Chicken = rgb <255/255, 187/255, 85/255>;
#declare CN_Honey_Do = rgb <237/255, 237/255, 199/255>;
#declare CN_Honey_Flower = rgb <92/255, 60/255, 109/255>;
#declare CN_Honey_Fungus = rgb <209/255, 142/255, 84/255>;
#declare CN_Honey_Garlic_Beef = rgb <136/255, 68/255, 34/255>;
#declare CN_Honey_Ginger = rgb <168/255, 98/255, 23/255>;
#declare CN_Honey_Glow = rgb <232/255, 180/255, 71/255>;
#declare CN_Honey_Gold = rgb <209/255, 160/255, 84/255>;
#declare CN_Honey_Graham = rgb <188/255, 136/255, 106/255>;
#declare CN_Honey_Grove = rgb <220/255, 177/255, 73/255>;
#declare CN_Honey_Haven = rgb <188/255, 146/255, 99/255>;
#declare CN_Honey_Lime_Chicken = rgb <221/255, 204/255, 187/255>;
#declare CN_Honey_Locust = rgb <255/255, 195/255, 103/255>;
#declare CN_Honey_Mist = rgb <229/255, 217/255, 178/255>;
#declare CN_Honey_Moth = rgb <251/255, 236/255, 204/255>;
#declare CN_Honey_Mustard = rgb <182/255, 143/255, 82/255>;
#declare CN_Honey_N_Cream = rgb <241/255, 220/255, 183/255>;
#declare CN_Honey_Nectar = rgb <241/255, 221/255, 162/255>;
#declare CN_Honey_Nougat = rgb <224/255, 187/255, 150/255>;
#declare CN_Honey_Oat_Bread = rgb <250/255, 238/255, 217/255>;
#declare CN_Honey_Peach = rgb <220/255, 189/255, 158/255>;
#declare CN_Honey_Pink = rgb <204/255, 153/255, 170/255>;
#declare CN_Honey_Pot = rgb <255/255, 200/255, 99/255>;
#declare CN_Honey_Robber = rgb <223/255, 187/255, 134/255>;
#declare CN_Honey_Tea = rgb <216/255, 190/255, 137/255>;
#declare CN_Honey_Teriyaki = rgb <238/255, 102/255, 17/255>;
#declare CN_Honey_Tone = rgb <248/255, 220/255, 155/255>;
#declare CN_Honey_Wax = rgb <255/255, 170/255, 34/255>;
#declare CN_Honey_Yellow = rgb <202/255, 148/255, 86/255>;
#declare CN_Honey_Yellow_Green = rgb <147/255, 112/255, 22/255>;
#declare CN_Honey_Yogurt_Popsicles = rgb <243/255, 240/255, 217/255>;
#declare CN_Honeycomb = rgb <221/255, 170/255, 17/255>;
#declare CN_Honeycomb_Yellow = rgb <222/255, 156/255, 82/255>;
#declare CN_Honeydew = rgb <240/255, 255/255, 240/255>;
#declare CN_Honeydew_Melon = rgb <230/255, 236/255, 204/255>;
#declare CN_Honeydew_Peel = rgb <212/255, 251/255, 121/255>;
#declare CN_Honeypot = rgb <246/255, 222/255, 179/255>;
#declare CN_Honeysuckle = rgb <232/255, 237/255, 105/255>;
#declare CN_Honeysuckle_Blast = rgb <179/255, 131/255, 63/255>;
#declare CN_Honeysuckle_Vine = rgb <251/255, 241/255, 200/255>;
#declare CN_Honeysuckle_White = rgb <248/255, 236/255, 211/255>;
#declare CN_Honeysweet = rgb <233/255, 207/255, 200/255>;
#declare CN_Hong_Bao_Shu_Red = rgb <224/255, 32/255, 6/255>;
#declare CN_Hong_Kong_Mist = rgb <148/255, 142/255, 144/255>;
#declare CN_Hong_Kong_Skyline = rgb <103/255, 110/255, 122/255>;
#declare CN_Hong_Kong_Taxi = rgb <168/255, 16/255, 42/255>;
#declare CN_Hong_Lou_Meng_Red = rgb <207/255, 63/255, 79/255>;
#declare CN_Hong_Se_Red = rgb <255/255, 8/255, 9/255>;
#declare CN_Hong_Zong_Brown = rgb <86/255, 74/255, 51/255>;
#declare CN_Honied_White = rgb <252/255, 239/255, 209/255>;
#declare CN_Honky_Tonk_Blue = rgb <68/255, 106/255, 141/255>;
#declare CN_Honolulu_Blue = rgb <0/255, 127/255, 191/255>;
#declare CN_Honorable_Blue = rgb <22/255, 69/255, 118/255>;
#declare CN_Hooked_Mimosa = rgb <255/255, 201/255, 196/255>;
#declare CN_Hookers_Green = rgb <73/255, 121/255, 107/255>;
#declare CN_Hooloovoo_Blue = rgb <68/255, 85/255, 255/255>;
#declare CN_Hopbush = rgb <205/255, 109/255, 147/255>;
#declare CN_Hope = rgb <229/255, 129/255, 160/255>;
#declare CN_Hope_Chest = rgb <135/255, 89/255, 66/255>;
#declare CN_Hopeful = rgb <242/255, 212/255, 226/255>;
#declare CN_Hopeful_Blue = rgb <162/255, 185/255, 191/255>;
#declare CN_Hopeful_Dream = rgb <149/255, 169/255, 205/255>;
#declare CN_Hopi_Blue_Corn = rgb <23/255, 72/255, 113/255>;
#declare CN_Hopi_Moccasin = rgb <255/255, 228/255, 181/255>;
#declare CN_Hopsack = rgb <158/255, 129/255, 99/255>;
#declare CN_Hopscotch = rgb <175/255, 187/255, 66/255>;
#declare CN_Horchata = rgb <242/255, 233/255, 217/255>;
#declare CN_Horenso_Green = rgb <120/255, 155/255, 115/255>;
#declare CN_Horizon = rgb <100/255, 136/255, 148/255>;
#declare CN_Horizon_Blue = rgb <40/255, 157/255, 190/255>;
#declare CN_Horizon_Glow = rgb <173/255, 113/255, 113/255>;
#declare CN_Horizon_Grey = rgb <156/255, 169/255, 170/255>;
#declare CN_Horizon_Haze = rgb <128/255, 193/255, 226/255>;
#declare CN_Horizon_Island = rgb <205/255, 212/255, 198/255>;
#declare CN_Horizon_Sky = rgb <194/255, 195/255, 211/255>;
#declare CN_Hormagaunt_Purple = rgb <81/255, 87/255, 111/255>;
#declare CN_Horn_of_Plenty = rgb <187/255, 164/255, 109/255>;
#declare CN_Hornblende = rgb <51/255, 34/255, 34/255>;
#declare CN_Hornblende_Green = rgb <35/255, 78/255, 77/255>;
#declare CN_Horned_Frog = rgb <194/255, 174/255, 135/255>;
#declare CN_Horned_Lizard = rgb <232/255, 234/255, 213/255>;
#declare CN_Hornet_Nest = rgb <213/255, 223/255, 211/255>;
#declare CN_Hornet_Sting = rgb <255/255, 0/255, 51/255>;
#declare CN_Hornet_Yellow = rgb <166/255, 124/255, 8/255>;
#declare CN_Horror_Snob = rgb <211/255, 77/255, 77/255>;
#declare CN_Horse_Liver = rgb <84/255, 61/255, 55/255>;
#declare CN_Horseradish = rgb <230/255, 223/255, 196/255>;
#declare CN_Horseradish_Cream = rgb <238/255, 234/255, 221/255>;
#declare CN_Horseradish_Yellow = rgb <255/255, 222/255, 169/255>;
#declare CN_Horses_Neck = rgb <109/255, 86/255, 44/255>;
#declare CN_Horsetail = rgb <61/255, 93/255, 66/255>;
#declare CN_Hortensia = rgb <85/255, 59/255, 80/255>;
#declare CN_Hosanna = rgb <219/255, 184/255, 191/255>;
#declare CN_Hospital_Green = rgb <155/255, 229/255, 170/255>;
#declare CN_Hosta_Flower = rgb <220/255, 221/255, 231/255>;
#declare CN_Hostaleaf = rgb <71/255, 90/255, 86/255>;
#declare CN_Hot = rgb <172/255, 67/255, 98/255>;
#declare CN_Hot_and_Spicy = rgb <179/255, 85/255, 71/255>;
#declare CN_Hot_Aquarelle_Pink = rgb <255/255, 179/255, 222/255>;
#declare CN_Hot_Beach = rgb <255/255, 246/255, 217/255>;
#declare CN_Hot_Bolognese = rgb <204/255, 85/255, 17/255>;
#declare CN_Hot_Butter = rgb <230/255, 157/255, 0/255>;
#declare CN_Hot_Cacao = rgb <165/255, 105/255, 79/255>;
#declare CN_Hot_Calypso = rgb <250/255, 141/255, 124/255>;
#declare CN_Hot_Chili = rgb <173/255, 117/255, 107/255>;
#declare CN_Hot_Chilli = rgb <183/255, 81/255, 58/255>;
#declare CN_Hot_Chocolate = rgb <104/255, 59/255, 57/255>;
#declare CN_Hot_Cinnamon = rgb <209/255, 105/255, 28/255>;
#declare CN_Hot_Cocoa = rgb <128/255, 98/255, 87/255>;
#declare CN_Hot_Coral = rgb <243/255, 91/255, 83/255>;
#declare CN_Hot_Cuba = rgb <187/255, 0/255, 51/255>;
#declare CN_Hot_Curry = rgb <129/255, 91/255, 40/255>;
#declare CN_Hot_Desert = rgb <234/255, 228/255, 218/255>;
#declare CN_Hot_Dog_Relish = rgb <113/255, 124/255, 62/255>;
#declare CN_Hot_Embers = rgb <245/255, 89/255, 49/255>;
#declare CN_Hot_Fever = rgb <212/255, 3/255, 1/255>;
#declare CN_Hot_Flamingo = rgb <179/255, 89/255, 102/255>;
#declare CN_Hot_Ginger = rgb <163/255, 103/255, 54/255>;
#declare CN_Hot_Gossip = rgb <224/255, 124/255, 137/255>;
#declare CN_Hot_Green = rgb <37/255, 255/255, 41/255>;
#declare CN_Hot_Hazel = rgb <221/255, 102/255, 34/255>;
#declare CN_Hot_Hibiscus = rgb <187/255, 34/255, 68/255>;
#declare CN_Hot_Jazz = rgb <188/255, 48/255, 51/255>;
#declare CN_Hot_Lava = rgb <170/255, 0/255, 51/255>;
#declare CN_Hot_Lips = rgb <201/255, 49/255, 43/255>;
#declare CN_Hot_Magenta = rgb <255/255, 0/255, 204/255>;
#declare CN_Hot_Mustard = rgb <115/255, 92/255, 18/255>;
#declare CN_Hot_Orange = rgb <244/255, 137/255, 61/255>;
#declare CN_Hot_Pepper_Green = rgb <89/255, 128/255, 57/255>;
#declare CN_Hot_Pink = rgb <255/255, 2/255, 141/255>;
#declare CN_Hot_Purple = rgb <203/255, 0/255, 245/255>;
#declare CN_Hot_Sand = rgb <204/255, 170/255, 0/255>;
#declare CN_Hot_Sauce = rgb <171/255, 79/255, 65/255>;
#declare CN_Hot_Sauna = rgb <63/255, 63/255, 117/255>;
#declare CN_Hot_Spice = rgb <204/255, 34/255, 17/255>;
#declare CN_Hot_Spot = rgb <255/255, 229/255, 151/255>;
#declare CN_Hot_Stone = rgb <171/255, 168/255, 158/255>;
#declare CN_Hot_Sun = rgb <249/255, 184/255, 43/255>;
#declare CN_Hot_Toddy = rgb <167/255, 117/255, 44/255>;
#declare CN_Hothouse_Orchid = rgb <117/255, 84/255, 104/255>;
#declare CN_Hotot_Bunny = rgb <241/255, 243/255, 242/255>;
#declare CN_Hotspot = rgb <255/255, 68/255, 51/255>;
#declare CN_Hotter_Butter = rgb <230/255, 138/255, 0/255>;
#declare CN_Hotter_Than_Hell = rgb <255/255, 68/255, 85/255>;
#declare CN_Hottest_Of_Pinks = rgb <255/255, 128/255, 255/255>;
#declare CN_Hourglass = rgb <229/255, 224/255, 213/255>;
#declare CN_House_Martin_Eggs = rgb <226/255, 224/255, 219/255>;
#declare CN_House_Sparrows_Egg = rgb <214/255, 217/255, 221/255>;
#declare CN_House_Stark_Grey = rgb <77/255, 73/255, 91/255>;
#declare CN_Houseplant = rgb <88/255, 113/255, 63/255>;
#declare CN_How_Handsome = rgb <160/255, 174/255, 184/255>;
#declare CN_How_Now = rgb <136/255, 97/255, 80/255>;
#declare CN_Howdy_Neighbor = rgb <249/255, 228/255, 200/255>;
#declare CN_Howdy_Partner = rgb <198/255, 166/255, 152/255>;
#declare CN_Howling_Coyote = rgb <156/255, 127/255, 90/255>;
#declare CN_Hu_Lan_Blue = rgb <29/255, 172/255, 209/255>;
#declare CN_Huang_Di_Yellow = rgb <248/255, 255/255, 115/255>;
#declare CN_Huang_Jin_Zhou_Gold = rgb <250/255, 218/255, 106/255>;
#declare CN_Huang_Se_Yellow = rgb <240/255, 242/255, 12/255>;
#declare CN_Hubbard_Squash = rgb <233/255, 191/255, 140/255>;
#declare CN_Huberts_Truck_Green = rgb <85/255, 153/255, 51/255>;
#declare CN_Huckleberry = rgb <91/255, 67/255, 73/255>;
#declare CN_Huckleberry_Brown = rgb <113/255, 86/255, 59/255>;
#declare CN_Hudson = rgb <234/255, 219/255, 210/255>;
#declare CN_Hudson_Bee = rgb <253/255, 239/255, 2/255>;
#declare CN_Huelveno_Horizon = rgb <23/255, 169/255, 229/255>;
#declare CN_Hughs_Hue = rgb <159/255, 160/255, 159/255>;
#declare CN_Hugo = rgb <230/255, 207/255, 204/255>;
#declare CN_Hui_Se_Grey = rgb <193/255, 198/255, 211/255>;
#declare CN_Hula_Girl = rgb <146/255, 146/255, 100/255>;
#declare CN_Hulett_Ore = rgb <114/255, 111/255, 108/255>;
#declare CN_Hulk = rgb <0/255, 128/255, 0/255>;
#declare CN_Hull_Red = rgb <77/255, 20/255, 11/255>;
#declare CN_Humble_Blush = rgb <227/255, 205/255, 194/255>;
#declare CN_Humble_Gold = rgb <237/255, 199/255, 150/255>;
#declare CN_Humble_Hippo = rgb <170/255, 170/255, 153/255>;
#declare CN_Humboldt_Redwoods = rgb <31/255, 99/255, 87/255>;
#declare CN_Humid_Cave = rgb <201/255, 204/255, 210/255>;
#declare CN_Hummingbird = rgb <206/255, 239/255, 228/255>;
#declare CN_Hummingbird_Green = rgb <91/255, 114/255, 74/255>;
#declare CN_Hummus = rgb <238/255, 204/255, 153/255>;
#declare CN_Humorous_Green = rgb <198/255, 184/255, 54/255>;
#declare CN_Humpback_Whale = rgb <71/255, 59/255, 59/255>;
#declare CN_Humus = rgb <183/255, 167/255, 147/255>;
#declare CN_Hunky_Hummingbird = rgb <187/255, 17/255, 255/255>;
#declare CN_Hunt_Club = rgb <42/255, 79/255, 67/255>;
#declare CN_Hunt_Club_Brown = rgb <147/255, 131/255, 112/255>;
#declare CN_Hunter_Green = rgb <11/255, 64/255, 8/255>;
#declare CN_Hunters_Hollow = rgb <152/255, 154/255, 141/255>;
#declare CN_Hunters_Orange = rgb <219/255, 71/255, 44/255>;
#declare CN_Huntington_Garden = rgb <150/255, 167/255, 130/255>;
#declare CN_Huntington_Woods = rgb <70/255, 85/255, 76/255>;
#declare CN_Hurricane = rgb <139/255, 126/255, 119/255>;
#declare CN_Hurricane_Green_Blue = rgb <37/255, 77/255, 84/255>;
#declare CN_Hurricane_Haze = rgb <189/255, 187/255, 173/255>;
#declare CN_Hurricane_Mist = rgb <235/255, 238/255, 232/255>;
#declare CN_Hush = rgb <196/255, 189/255, 186/255>;
#declare CN_Hush_Grey = rgb <225/255, 222/255, 216/255>;
#declare CN_Hush_Pink = rgb <248/255, 233/255, 226/255>;
#declare CN_Hush_Puppy = rgb <228/255, 176/255, 149/255>;
#declare CN_Hush_White = rgb <229/255, 218/255, 212/255>;
#declare CN_Hush_A_Bye = rgb <83/255, 151/255, 183/255>;
#declare CN_Hushed_Auburn = rgb <168/255, 133/255, 122/255>;
#declare CN_Hushed_Green = rgb <216/255, 233/255, 229/255>;
#declare CN_Hushed_Violet = rgb <209/255, 192/255, 191/255>;
#declare CN_Hushed_White = rgb <241/255, 242/255, 228/255>;
#declare CN_Husk = rgb <178/255, 153/255, 75/255>;
#declare CN_Husky = rgb <224/255, 235/255, 250/255>;
#declare CN_Husky_Orange = rgb <187/255, 97/255, 62/255>;
#declare CN_Hutchins_Plaza = rgb <174/255, 149/255, 124/255>;
#declare CN_Hyacinth = rgb <147/255, 108/255, 167/255>;
#declare CN_Hyacinth_Arbor = rgb <108/255, 103/255, 131/255>;
#declare CN_Hyacinth_Dream = rgb <128/255, 115/255, 136/255>;
#declare CN_Hyacinth_Mauve = rgb <111/255, 114/255, 159/255>;
#declare CN_Hyacinth_Red = rgb <167/255, 85/255, 54/255>;
#declare CN_Hyacinth_Tint = rgb <185/255, 196/255, 211/255>;
#declare CN_Hyacinth_Violet = rgb <141/255, 70/255, 135/255>;
#declare CN_Hyacinth_White_Soft_Blue = rgb <193/255, 199/255, 215/255>;
#declare CN_Hybrid = rgb <208/255, 205/255, 169/255>;
#declare CN_Hydra = rgb <0/255, 105/255, 149/255>;
#declare CN_Hydra_Turquoise = rgb <0/255, 122/255, 115/255>;
#declare CN_Hydrangea = rgb <132/255, 155/255, 204/255>;
#declare CN_Hydrangea_Blossom = rgb <166/255, 174/255, 190/255>;
#declare CN_Hydrangea_Bouquet = rgb <202/255, 166/255, 169/255>;
#declare CN_Hydrangea_Floret = rgb <230/255, 234/255, 224/255>;
#declare CN_Hydrangea_Pink = rgb <231/255, 182/255, 200/255>;
#declare CN_Hydrangea_Purple = rgb <202/255, 160/255, 255/255>;
#declare CN_Hydrargyrum = rgb <155/255, 155/255, 155/255>;
#declare CN_Hydro = rgb <66/255, 105/255, 114/255>;
#declare CN_Hydrogen_Blue = rgb <51/255, 71/255, 109/255>;
#declare CN_Hydrology = rgb <137/255, 172/255, 172/255>;
#declare CN_Hydroport = rgb <94/255, 156/255, 161/255>;
#declare CN_Hygge_Green = rgb <224/255, 225/255, 216/255>;
#declare CN_Hygiene_Green = rgb <93/255, 188/255, 180/255>;
#declare CN_Hyper_Blue = rgb <1/255, 95/255, 151/255>;
#declare CN_Hyper_Green = rgb <85/255, 255/255, 0/255>;
#declare CN_Hyper_Light_Drifter = rgb <237/255, 219/255, 218/255>;
#declare CN_Hypnotic = rgb <104/255, 119/255, 131/255>;
#declare CN_Hypnotic_Sea = rgb <0/255, 120/255, 127/255>;
#declare CN_Hypnotism = rgb <50/255, 88/255, 76/255>;
#declare CN_Hypothalamus_Grey = rgb <65/255, 93/255, 102/255>;
#declare CN_Hyssop = rgb <109/255, 73/255, 118/255>;
#declare CN_I_Heart_Potion = rgb <169/255, 127/255, 177/255>;
#declare CN_I_Love_To_Boogie = rgb <255/255, 169/255, 23/255>;
#declare CN_I_Miss_You = rgb <221/255, 219/255, 197/255>;
#declare CN_I_Pink_I_Can = rgb <212/255, 127/255, 141/255>;
#declare CN_I_R_Dark_Green = rgb <64/255, 64/255, 52/255>;
#declare CN_Im_a_Local = rgb <235/255, 191/255, 92/255>;
#declare CN_Ibex_Brown = rgb <72/255, 36/255, 0/255>;
#declare CN_Ibis = rgb <244/255, 179/255, 194/255>;
#declare CN_Ibis_Mouse = rgb <228/255, 210/255, 216/255>;
#declare CN_Ibis_Rose = rgb <202/255, 98/255, 143/255>;
#declare CN_Ibis_White = rgb <242/255, 236/255, 230/255>;
#declare CN_Ibis_Wing = rgb <245/255, 143/255, 132/255>;
#declare CN_Ibiza_Blue = rgb <0/255, 124/255, 183/255>;
#declare CN_Ice = rgb <214/255, 255/255, 250/255>;
#declare CN_Ice_Age = rgb <198/255, 228/255, 233/255>;
#declare CN_Ice_Ballet = rgb <234/255, 222/255, 232/255>;
#declare CN_Ice_Blue = rgb <115/255, 155/255, 208/255>;
#declare CN_Ice_Blue_Grey = rgb <113/255, 119/255, 135/255>;
#declare CN_Ice_Bomb = rgb <204/255, 226/255, 221/255>;
#declare CN_Ice_Boutique_Turquoise = rgb <162/255, 205/255, 203/255>;
#declare CN_Ice_Breaker = rgb <212/255, 231/255, 231/255>;
#declare CN_Ice_Cap_Green = rgb <185/255, 231/255, 221/255>;
#declare CN_Ice_Castle = rgb <213/255, 237/255, 251/255>;
#declare CN_Ice_Cave = rgb <160/255, 190/255, 218/255>;
#declare CN_Ice_Climber = rgb <37/255, 226/255, 205/255>;
#declare CN_Ice_Cold = rgb <210/255, 234/255, 241/255>;
#declare CN_Ice_Cold_Green = rgb <217/255, 235/255, 172/255>;
#declare CN_Ice_Cold_Stare = rgb <177/255, 209/255, 252/255>;
#declare CN_Ice_Cream_Cone = rgb <227/255, 208/255, 191/255>;
#declare CN_Ice_Cream_Parlour = rgb <247/255, 211/255, 173/255>;
#declare CN_Ice_Crystal_Blue = rgb <166/255, 227/255, 224/255>;
#declare CN_Ice_Cube = rgb <175/255, 227/255, 214/255>;
#declare CN_Ice_Dagger = rgb <206/255, 229/255, 223/255>;
#declare CN_Ice_Dark_Turquoise = rgb <0/255, 84/255, 86/255>;
#declare CN_Ice_Dream = rgb <234/255, 235/255, 225/255>;
#declare CN_Ice_Drop = rgb <211/255, 226/255, 238/255>;
#declare CN_Ice_Effect = rgb <187/255, 238/255, 255/255>;
#declare CN_Ice_Fishing = rgb <220/255, 236/255, 245/255>;
#declare CN_Ice_Floe = rgb <216/255, 231/255, 225/255>;
#declare CN_Ice_Flow = rgb <198/255, 210/255, 210/255>;
#declare CN_Ice_Flower = rgb <195/255, 231/255, 236/255>;
#declare CN_Ice_Folly = rgb <219/255, 236/255, 233/255>;
#declare CN_Ice_Glow = rgb <255/255, 255/255, 233/255>;
#declare CN_Ice_Green = rgb <135/255, 216/255, 195/255>;
#declare CN_Ice_Grey = rgb <202/255, 199/255, 196/255>;
#declare CN_Ice_Gull_Grey_Blue = rgb <155/255, 178/255, 186/255>;
#declare CN_Ice_Hot_Pink = rgb <228/255, 189/255, 194/255>;
#declare CN_Ice_Ice_Baby = rgb <0/255, 255/255, 221/255>;
#declare CN_Ice_Lemon = rgb <255/255, 251/255, 193/255>;
#declare CN_Ice_Mauve = rgb <201/255, 194/255, 221/255>;
#declare CN_Ice_Mist = rgb <182/255, 219/255, 191/255>;
#declare CN_Ice_Pack = rgb <165/255, 219/255, 227/255>;
#declare CN_Ice_Palace = rgb <226/255, 228/255, 215/255>;
#declare CN_Ice_Plant = rgb <207/255, 126/255, 173/255>;
#declare CN_Ice_Rink = rgb <187/255, 221/255, 238/255>;
#declare CN_Ice_Sculpture = rgb <225/255, 230/255, 229/255>;
#declare CN_Ice_Shard_Soft_Blue = rgb <193/255, 222/255, 226/255>;
#declare CN_Ice_Temple = rgb <17/255, 255/255, 238/255>;
#declare CN_Ice_Water_Green = rgb <205/255, 235/255, 225/255>;
#declare CN_Ice_Yellow = rgb <254/255, 254/255, 205/255>;
#declare CN_Ice_Cold_White = rgb <223/255, 240/255, 226/255>;
#declare CN_Iceberg = rgb <218/255, 228/255, 238/255>;
#declare CN_Iceberg_Green = rgb <140/255, 156/255, 146/255>;
#declare CN_Iced_Almond = rgb <254/255, 244/255, 221/255>;
#declare CN_Iced_Aniseed = rgb <203/255, 211/255, 195/255>;
#declare CN_Iced_Apricot = rgb <239/255, 214/255, 192/255>;
#declare CN_Iced_Aqua = rgb <171/255, 211/255, 219/255>;
#declare CN_Iced_Avocado = rgb <200/255, 228/255, 185/255>;
#declare CN_Iced_Cappuccino = rgb <156/255, 136/255, 102/255>;
#declare CN_Iced_Celery = rgb <229/255, 233/255, 183/255>;
#declare CN_Iced_Cherry = rgb <232/255, 199/255, 191/255>;
#declare CN_Iced_Coffee = rgb <177/255, 143/255, 106/255>;
#declare CN_Iced_Copper = rgb <208/255, 174/255, 154/255>;
#declare CN_Iced_Espresso = rgb <90/255, 74/255, 66/255>;
#declare CN_Iced_Green_Apple = rgb <236/255, 235/255, 201/255>;
#declare CN_Iced_Lavender = rgb <194/255, 199/255, 219/255>;
#declare CN_Iced_Mauve = rgb <232/255, 220/255, 227/255>;
#declare CN_Iced_Mocha = rgb <163/255, 132/255, 108/255>;
#declare CN_Iced_Orchid = rgb <142/255, 125/255, 137/255>;
#declare CN_Iced_Slate = rgb <214/255, 220/255, 215/255>;
#declare CN_Iced_Tea = rgb <184/255, 114/255, 83/255>;
#declare CN_Iced_Tulip = rgb <175/255, 169/255, 175/255>;
#declare CN_Iced_Vovo = rgb <225/255, 164/255, 178/255>;
#declare CN_Iced_Watermelon = rgb <209/255, 175/255, 183/255>;
#declare CN_Iceland_Green = rgb <0/255, 139/255, 82/255>;
#declare CN_Iceland_Poppy = rgb <244/255, 150/255, 58/255>;
#declare CN_Icelandic = rgb <218/255, 228/255, 236/255>;
#declare CN_Icelandic_Blue = rgb <169/255, 173/255, 194/255>;
#declare CN_Icelandic_Water = rgb <0/255, 17/255, 255/255>;
#declare CN_Icelandic_Winds = rgb <215/255, 222/255, 235/255>;
#declare CN_Icelandic_Winter = rgb <217/255, 231/255, 227/255>;
#declare CN_Icepick = rgb <218/255, 220/255, 208/255>;
#declare CN_Icewind_Dale = rgb <232/255, 236/255, 238/255>;
#declare CN_Icicle = rgb <221/255, 231/255, 223/255>;
#declare CN_Icicle_Mint = rgb <207/255, 232/255, 230/255>;
#declare CN_Icicles = rgb <188/255, 197/255, 201/255>;
#declare CN_Icing_Flower = rgb <213/255, 183/255, 203/255>;
#declare CN_Icing_Rose = rgb <245/255, 238/255, 231/255>;
#declare CN_Icky_Green = rgb <143/255, 174/255, 34/255>;
#declare CN_Icterine = rgb <252/255, 247/255, 94/255>;
#declare CN_Icy = rgb <187/255, 199/255, 210/255>;
#declare CN_Icy_Bay = rgb <224/255, 229/255, 226/255>;
#declare CN_Icy_Brook = rgb <193/255, 202/255, 217/255>;
#declare CN_Icy_Lavender = rgb <226/255, 226/255, 237/255>;
#declare CN_Icy_Lemonade = rgb <244/255, 232/255, 178/255>;
#declare CN_Icy_Life = rgb <85/255, 255/255, 238/255>;
#declare CN_Icy_Lilac = rgb <230/255, 233/255, 249/255>;
#declare CN_Icy_Morn = rgb <176/255, 211/255, 209/255>;
#declare CN_Icy_Teal = rgb <214/255, 223/255, 232/255>;
#declare CN_Icy_Tundra = rgb <247/255, 245/255, 236/255>;
#declare CN_Icy_Water = rgb <188/255, 226/255, 232/255>;
#declare CN_Icy_Waterfall = rgb <192/255, 210/255, 208/255>;
#declare CN_Icy_Wind = rgb <211/255, 241/255, 238/255>;
#declare CN_Identity = rgb <120/255, 144/255, 172/255>;
#declare CN_Idol = rgb <100/255, 90/255, 139/255>;
#declare CN_Idyllic_Isle = rgb <148/255, 200/255, 210/255>;
#declare CN_Idyllic_Pink = rgb <200/255, 158/255, 183/255>;
#declare CN_Igloo = rgb <253/255, 252/255, 250/255>;
#declare CN_Igloo_Blue = rgb <201/255, 229/255, 235/255>;
#declare CN_Iguacuense_Waterfall = rgb <46/255, 119/255, 109/255>;
#declare CN_Iguana = rgb <129/255, 132/255, 85/255>;
#declare CN_Iguana_Green = rgb <113/255, 188/255, 119/255>;
#declare CN_Ikkonzome_Pink = rgb <240/255, 143/255, 144/255>;
#declare CN_Illicit_Darkness = rgb <0/255, 2/255, 46/255>;
#declare CN_Illicit_Green = rgb <86/255, 252/255, 162/255>;
#declare CN_Illicit_Pink = rgb <255/255, 92/255, 205/255>;
#declare CN_Illicit_Purple = rgb <191/255, 119/255, 246/255>;
#declare CN_Illuminated = rgb <249/255, 229/255, 216/255>;
#declare CN_Illuminati_Green = rgb <65/255, 145/255, 104/255>;
#declare CN_Illuminating = rgb <238/255, 238/255, 119/255>;
#declare CN_Illuminating_Emerald = rgb <49/255, 145/255, 119/255>;
#declare CN_Illuminating_Experience = rgb <222/255, 228/255, 224/255>;
#declare CN_Illusion = rgb <239/255, 149/255, 174/255>;
#declare CN_Illusion_Blue = rgb <201/255, 211/255, 220/255>;
#declare CN_Illusionist = rgb <87/255, 79/255, 100/255>;
#declare CN_Illusive_Dream = rgb <225/255, 213/255, 194/255>;
#declare CN_Illusive_Green = rgb <146/255, 148/255, 141/255>;
#declare CN_Illustrious_Indigo = rgb <85/255, 51/255, 187/255>;
#declare CN_Ilvaite_Black = rgb <51/255, 0/255, 17/255>;
#declare CN_Imagery = rgb <122/255, 110/255, 112/255>;
#declare CN_Imaginary_Mauve = rgb <137/255, 104/255, 125/255>;
#declare CN_Imagination = rgb <223/255, 224/255, 238/255>;
#declare CN_Imagine = rgb <175/255, 148/255, 104/255>;
#declare CN_Imagine_That = rgb <148/255, 124/255, 152/255>;
#declare CN_Imam_Ali_Gold = rgb <250/255, 225/255, 153/255>;
#declare CN_Imayou_Pink = rgb <208/255, 87/255, 107/255>;
#declare CN_Immaculate_Iguana = rgb <170/255, 204/255, 0/255>;
#declare CN_Immersed = rgb <32/255, 79/255, 84/255>;
#declare CN_Immortal = rgb <192/255, 169/255, 204/255>;
#declare CN_Immortal_Indigo = rgb <216/255, 183/255, 207/255>;
#declare CN_Immortality = rgb <148/255, 91/255, 127/255>;
#declare CN_Immortelle_Yellow = rgb <212/255, 162/255, 7/255>;
#declare CN_Impala = rgb <248/255, 206/255, 151/255>;
#declare CN_Impatiens_Petal = rgb <241/255, 210/255, 215/255>;
#declare CN_Impatiens_Pink = rgb <255/255, 196/255, 188/255>;
#declare CN_Impatient_Heart = rgb <196/255, 125/255, 124/255>;
#declare CN_Impatient_Pink = rgb <219/255, 123/255, 151/255>;
#declare CN_Imperial = rgb <96/255, 47/255, 107/255>;
#declare CN_Imperial_Blue = rgb <0/255, 35/255, 149/255>;
#declare CN_Imperial_Dynasty = rgb <51/255, 116/255, 107/255>;
#declare CN_Imperial_Grey = rgb <103/255, 106/255, 106/255>;
#declare CN_Imperial_Ivory = rgb <241/255, 232/255, 210/255>;
#declare CN_Imperial_Jewel = rgb <105/255, 62/255, 66/255>;
#declare CN_Imperial_Palace = rgb <96/255, 78/255, 122/255>;
#declare CN_Imperial_Palm = rgb <89/255, 100/255, 88/255>;
#declare CN_Imperial_Primer = rgb <33/255, 48/255, 62/255>;
#declare CN_Imperial_Purple = rgb <84/255, 44/255, 93/255>;
#declare CN_Imperial_Red = rgb <236/255, 41/255, 56/255>;
#declare CN_Impetuous = rgb <228/255, 214/255, 140/255>;
#declare CN_Impression_of_Obscurity = rgb <26/255, 37/255, 120/255>;
#declare CN_Impressionist_Blue = rgb <167/255, 202/255, 201/255>;
#declare CN_Impressionist_Sky = rgb <185/255, 206/255, 224/255>;
#declare CN_Impressive_Ivory = rgb <244/255, 222/255, 195/255>;
#declare CN_Improbable = rgb <110/255, 115/255, 118/255>;
#declare CN_Impromptu = rgb <112/255, 95/255, 99/255>;
#declare CN_Impulse = rgb <0/255, 91/255, 135/255>;
#declare CN_Impulsive_Purple = rgb <98/255, 73/255, 119/255>;
#declare CN_Impure_White = rgb <245/255, 231/255, 227/255>;
#declare CN_Imrik_Blue = rgb <103/255, 174/255, 208/255>;
#declare CN_In_A_Pickle = rgb <151/255, 140/255, 89/255>;
#declare CN_In_for_a_Penny = rgb <238/255, 136/255, 119/255>;
#declare CN_In_Good_Taste = rgb <182/255, 212/255, 160/255>;
#declare CN_In_the_Blue = rgb <158/255, 176/255, 187/255>;
#declare CN_In_the_Buff = rgb <214/255, 203/255, 191/255>;
#declare CN_In_the_Hills = rgb <174/255, 166/255, 155/255>;
#declare CN_In_the_Moment = rgb <133/255, 152/255, 147/255>;
#declare CN_In_the_Navy = rgb <40/255, 56/255, 73/255>;
#declare CN_In_the_Pink = rgb <244/255, 196/255, 208/255>;
#declare CN_In_the_Red = rgb <255/255, 34/255, 51/255>;
#declare CN_In_the_Shadows = rgb <203/255, 196/255, 192/255>;
#declare CN_In_The_Slip = rgb <226/255, 195/255, 207/255>;
#declare CN_In_the_Spotlight = rgb <237/255, 230/255, 237/255>;
#declare CN_In_the_Tropics = rgb <163/255, 188/255, 58/255>;
#declare CN_In_the_Woods = rgb <114/255, 120/255, 111/255>;
#declare CN_Inca_Gold = rgb <187/255, 122/255, 44/255>;
#declare CN_Inca_Temple = rgb <140/255, 123/255, 108/255>;
#declare CN_Inca_Yellow = rgb <255/255, 211/255, 1/255>;
#declare CN_Incan_Treasure = rgb <249/255, 221/255, 196/255>;
#declare CN_Incandescence = rgb <255/255, 187/255, 34/255>;
#declare CN_Incarnadine = rgb <170/255, 0/255, 34/255>;
#declare CN_Incense = rgb <175/255, 154/255, 126/255>;
#declare CN_Inchworm = rgb <178/255, 236/255, 93/255>;
#declare CN_Incision = rgb <255/255, 0/255, 34/255>;
#declare CN_Incognito = rgb <142/255, 142/255, 130/255>;
#declare CN_Incredible_White = rgb <227/255, 222/255, 215/255>;
#declare CN_Incremental_Blue = rgb <18/255, 52/255, 86/255>;
#declare CN_Incubi_Darkness = rgb <11/255, 71/255, 74/255>;
#declare CN_Incubus = rgb <119/255, 34/255, 34/255>;
#declare CN_Independence = rgb <76/255, 81/255, 109/255>;
#declare CN_Independent_Gold = rgb <210/255, 186/255, 131/255>;
#declare CN_India_Blue = rgb <0/255, 138/255, 142/255>;
#declare CN_India_Green = rgb <19/255, 136/255, 8/255>;
#declare CN_India_Ink = rgb <60/255, 61/255, 76/255>;
#declare CN_India_Trade = rgb <224/255, 163/255, 98/255>;
#declare CN_Indian_Brass = rgb <165/255, 130/255, 61/255>;
#declare CN_Indian_Clay = rgb <242/255, 208/255, 192/255>;
#declare CN_Indian_Dance = rgb <244/255, 148/255, 118/255>;
#declare CN_Indian_Green = rgb <145/255, 149/255, 95/255>;
#declare CN_Indian_Ink = rgb <60/255, 63/255, 74/255>;
#declare CN_Indian_Khaki = rgb <211/255, 176/255, 156/255>;
#declare CN_Indian_Maize = rgb <228/255, 193/255, 77/255>;
#declare CN_Indian_Mesa = rgb <213/255, 161/255, 147/255>;
#declare CN_Indian_Muslin = rgb <234/255, 227/255, 216/255>;
#declare CN_Indian_Ocean = rgb <134/255, 183/255, 161/255>;
#declare CN_Indian_Paintbrush = rgb <250/255, 151/255, 97/255>;
#declare CN_Indian_Pale_Ale = rgb <213/255, 188/255, 38/255>;
#declare CN_Indian_Peafowl = rgb <0/255, 68/255, 170/255>;
#declare CN_Indian_Pink = rgb <173/255, 91/255, 120/255>;
#declare CN_Indian_Princess = rgb <218/255, 132/255, 109/255>;
#declare CN_Indian_Red = rgb <133/255, 14/255, 4/255>;
#declare CN_Indian_Reed = rgb <159/255, 112/255, 96/255>;
#declare CN_Indian_Silk = rgb <138/255, 87/255, 115/255>;
#declare CN_Indian_Spice = rgb <174/255, 136/255, 69/255>;
#declare CN_Indian_Summer = rgb <168/255, 81/255, 67/255>;
#declare CN_Indian_Sunset = rgb <217/255, 138/255, 125/255>;
#declare CN_Indian_Teal = rgb <60/255, 88/255, 107/255>;
#declare CN_Indian_White = rgb <239/255, 218/255, 194/255>;
#declare CN_Indian_Yellow = rgb <227/255, 168/255, 87/255>;
#declare CN_Indiana_Clay = rgb <232/255, 138/255, 91/255>;
#declare CN_Indica = rgb <88/255, 140/255, 58/255>;
#declare CN_Indifferent = rgb <152/255, 146/255, 184/255>;
#declare CN_Indigo = rgb <75/255, 0/255, 130/255>;
#declare CN_Indigo_Batik = rgb <68/255, 103/255, 167/255>;
#declare CN_Indigo_Black = rgb <0/255, 46/255, 81/255>;
#declare CN_Indigo_Blue = rgb <58/255, 24/255, 177/255>;
#declare CN_Indigo_Bunting = rgb <0/255, 108/255, 169/255>;
#declare CN_Indigo_Carmine = rgb <0/255, 110/255, 199/255>;
#declare CN_Indigo_Child = rgb <160/255, 159/255, 204/255>;
#declare CN_Indigo_Dye = rgb <0/255, 65/255, 108/255>;
#declare CN_Indigo_Hamlet = rgb <31/255, 71/255, 136/255>;
#declare CN_Indigo_Ink = rgb <71/255, 74/255, 77/255>;
#declare CN_Indigo_Ink_Brown = rgb <57/255, 52/255, 50/255>;
#declare CN_Indigo_Iron = rgb <57/255, 63/255, 76/255>;
#declare CN_Indigo_Light = rgb <93/255, 118/255, 203/255>;
#declare CN_Indigo_Mouse = rgb <108/255, 132/255, 141/255>;
#declare CN_Indigo_Navy_Blue = rgb <76/255, 94/255, 135/255>;
#declare CN_Indigo_Night = rgb <50/255, 70/255, 128/255>;
#declare CN_Indigo_Purple = rgb <102/255, 0/255, 153/255>;
#declare CN_Indigo_Red = rgb <105/255, 90/255, 120/255>;
#declare CN_Indigo_Sloth = rgb <31/255, 9/255, 84/255>;
#declare CN_Indigo_White = rgb <235/255, 246/255, 247/255>;
#declare CN_Indiscreet = rgb <172/255, 59/255, 59/255>;
#declare CN_Individual_White = rgb <212/255, 205/255, 202/255>;
#declare CN_Indiviolet_Sunset = rgb <102/255, 17/255, 170/255>;
#declare CN_Indochine = rgb <156/255, 91/255, 52/255>;
#declare CN_Indocile_Indochine = rgb <185/255, 107/255, 0/255>;
#declare CN_Indolence = rgb <162/255, 157/255, 173/255>;
#declare CN_Indonesian_Jungle = rgb <0/255, 140/255, 105/255>;
#declare CN_Indonesian_Rattan = rgb <209/255, 178/255, 114/255>;
#declare CN_Indulgence = rgb <83/255, 61/255, 71/255>;
#declare CN_Indulgent = rgb <102/255, 86/255, 95/255>;
#declare CN_Indulgent_Mocha = rgb <209/255, 197/255, 183/255>;
#declare CN_Industrial_Age = rgb <174/255, 173/255, 173/255>;
#declare CN_Industrial_Black = rgb <50/255, 43/255, 38/255>;
#declare CN_Industrial_Blue = rgb <0/255, 137/255, 140/255>;
#declare CN_Industrial_Green = rgb <17/255, 68/255, 0/255>;
#declare CN_Industrial_Grey = rgb <91/255, 90/255, 87/255>;
#declare CN_Industrial_Revolution = rgb <115/255, 115/255, 115/255>;
#declare CN_Industrial_Rose = rgb <224/255, 152/255, 135/255>;
#declare CN_Industrial_Strength = rgb <135/255, 122/255, 101/255>;
#declare CN_Industrial_Turquoise = rgb <0/255, 138/255, 112/255>;
#declare CN_Ineffable_Forest = rgb <79/255, 145/255, 83/255>;
#declare CN_Ineffable_Green = rgb <99/255, 247/255, 180/255>;
#declare CN_Ineffable_Ice_Cap = rgb <202/255, 237/255, 228/255>;
#declare CN_Ineffable_Linen = rgb <230/255, 225/255, 199/255>;
#declare CN_Ineffable_Magenta = rgb <204/255, 153/255, 204/255>;
#declare CN_Infamous = rgb <119/255, 121/255, 133/255>;
#declare CN_Infatuation = rgb <240/255, 213/255, 234/255>;
#declare CN_Inferno = rgb <218/255, 87/255, 54/255>;
#declare CN_Infinite_Deep_Sea = rgb <67/255, 90/255, 111/255>;
#declare CN_Infinitesimal_Blue = rgb <189/255, 221/255, 225/255>;
#declare CN_Infinitesimal_Green = rgb <215/255, 228/255, 204/255>;
#declare CN_Infinity = rgb <34/255, 40/255, 49/255>;
#declare CN_Infinity_and_Beyond = rgb <110/255, 126/255, 153/255>;
#declare CN_Informal_Ivory = rgb <241/255, 231/255, 208/255>;
#declare CN_Informative_Pink = rgb <254/255, 133/255, 171/255>;
#declare CN_Infra_Red = rgb <254/255, 72/255, 108/255>;
#declare CN_Infra_White = rgb <255/255, 204/255, 238/255>;
#declare CN_Infrared_Burn = rgb <221/255, 51/255, 51/255>;
#declare CN_Infrared_Flush = rgb <204/255, 51/255, 68/255>;
#declare CN_Infrared_Gloze = rgb <204/255, 51/255, 85/255>;
#declare CN_Infrared_Tang = rgb <221/255, 34/255, 68/255>;
#declare CN_Infusion = rgb <200/255, 208/255, 202/255>;
#declare CN_Inglenook_Olive = rgb <170/255, 163/255, 128/255>;
#declare CN_Inheritance = rgb <215/255, 174/255, 119/255>;
#declare CN_Ink_Black = rgb <37/255, 32/255, 36/255>;
#declare CN_Ink_Blotch = rgb <0/255, 96/255, 139/255>;
#declare CN_Ink_Blue = rgb <11/255, 83/255, 105/255>;
#declare CN_Inked = rgb <59/255, 80/255, 102/255>;
#declare CN_Inked_Silk = rgb <217/255, 220/255, 228/255>;
#declare CN_Inkjet = rgb <68/255, 85/255, 107/255>;
#declare CN_Inkwell = rgb <49/255, 54/255, 58/255>;
#declare CN_Inky_Blue = rgb <78/255, 114/255, 135/255>;
#declare CN_Inky_Storm = rgb <83/255, 82/255, 102/255>;
#declare CN_Inland = rgb <96/255, 107/255, 84/255>;
#declare CN_Inlet_Harbor = rgb <63/255, 88/255, 110/255>;
#declare CN_Inner_Cervela = rgb <187/255, 170/255, 126/255>;
#declare CN_Inner_Child = rgb <241/255, 189/255, 178/255>;
#declare CN_Inner_Journey = rgb <109/255, 105/255, 161/255>;
#declare CN_Inner_Space = rgb <40/255, 91/255, 95/255>;
#declare CN_Inner_Touch = rgb <187/255, 175/255, 186/255>;
#declare CN_Inness_Sage = rgb <149/255, 146/255, 114/255>;
#declare CN_Innisfree_Garden = rgb <34/255, 153/255, 0/255>;
#declare CN_Innocence = rgb <235/255, 209/255, 207/255>;
#declare CN_Innocent_Pink = rgb <133/255, 111/255, 121/255>;
#declare CN_Innuendo = rgb <164/255, 176/255, 196/255>;
#declare CN_Inoffensive_Blue = rgb <17/255, 68/255, 119/255>;
#declare CN_Inside = rgb <34/255, 17/255, 34/255>;
#declare CN_Inside_Passage = rgb <224/255, 207/255, 181/255>;
#declare CN_Insightful_Rose = rgb <201/255, 176/255, 171/255>;
#declare CN_Insignia_Blue = rgb <47/255, 62/255, 85/255>;
#declare CN_Insignia_White = rgb <236/255, 243/255, 249/255>;
#declare CN_Inspiration_Peak = rgb <79/255, 161/255, 131/255>;
#declare CN_Inspired_Lilac = rgb <223/255, 217/255, 228/255>;
#declare CN_Instant = rgb <217/255, 206/255, 199/255>;
#declare CN_Instant_Classic = rgb <227/255, 218/255, 198/255>;
#declare CN_Instant_Noodles = rgb <244/255, 212/255, 147/255>;
#declare CN_Instant_Orange = rgb <255/255, 141/255, 40/255>;
#declare CN_Instant_Relief = rgb <237/255, 231/255, 210/255>;
#declare CN_Instigate = rgb <173/255, 167/255, 200/255>;
#declare CN_Integra = rgb <64/255, 94/255, 149/255>;
#declare CN_Integrity = rgb <35/255, 62/255, 87/255>;
#declare CN_Intellectual = rgb <63/255, 65/255, 76/255>;
#declare CN_Intellectual_Gray = rgb <168/255, 160/255, 147/255>;
#declare CN_Intense_Brown = rgb <127/255, 84/255, 0/255>;
#declare CN_Intense_Green = rgb <18/255, 51/255, 40/255>;
#declare CN_Intense_Jade = rgb <104/255, 200/255, 157/255>;
#declare CN_Intense_Mauve = rgb <104/255, 45/255, 99/255>;
#declare CN_Intense_Passion = rgb <223/255, 49/255, 99/255>;
#declare CN_Intense_Purple = rgb <77/255, 74/255, 111/255>;
#declare CN_Intense_Teal = rgb <0/255, 151/255, 140/255>;
#declare CN_Intense_Yellow = rgb <225/255, 156/255, 53/255>;
#declare CN_Inter_Galactic_Blue = rgb <175/255, 224/255, 239/255>;
#declare CN_Interactive_Cream = rgb <228/255, 202/255, 173/255>;
#declare CN_Intercoastal_Grey = rgb <168/255, 181/255, 188/255>;
#declare CN_Interdimensional_Blue = rgb <54/255, 12/255, 204/255>;
#declare CN_Interdimensional_Portal = rgb <214/255, 230/255, 230/255>;
#declare CN_Interesting_Aqua = rgb <155/255, 175/255, 178/255>;
#declare CN_Interface_Tan = rgb <193/255, 163/255, 146/255>;
#declare CN_Intergalactic = rgb <77/255, 81/255, 108/255>;
#declare CN_Intergalactic_Cowboy = rgb <34/255, 34/255, 102/255>;
#declare CN_Intergalactic_Ray = rgb <87/255, 57/255, 53/255>;
#declare CN_Interior_Green = rgb <83/255, 100/255, 55/255>;
#declare CN_Interlude = rgb <86/255, 67/255, 85/255>;
#declare CN_Intermediate_Blue = rgb <86/255, 98/255, 110/255>;
#declare CN_Intermediate_Green = rgb <19/255, 119/255, 48/255>;
#declare CN_International = rgb <55/255, 98/255, 165/255>;
#declare CN_International_Blue = rgb <0/255, 47/255, 167/255>;
#declare CN_International_Klein_Blue = rgb <0/255, 47/255, 166/255>;
#declare CN_International_Orange = rgb <186/255, 22/255, 12/255>;
#declare CN_Interstellar_Blue = rgb <0/255, 17/255, 85/255>;
#declare CN_Intimate_Journal = rgb <204/255, 187/255, 153/255>;
#declare CN_Intimate_White = rgb <240/255, 225/255, 216/255>;
#declare CN_Into_the_Stratosphere = rgb <66/255, 82/255, 103/255>;
#declare CN_Intoxicate = rgb <17/255, 187/255, 85/255>;
#declare CN_Intoxication = rgb <161/255, 172/255, 77/255>;
#declare CN_Intrepid_Grey = rgb <224/255, 226/255, 224/255>;
#declare CN_Intricate_Ivory = rgb <237/255, 221/255, 202/255>;
#declare CN_Intrigue = rgb <99/255, 89/255, 81/255>;
#declare CN_Intrigue_Red = rgb <178/255, 70/255, 72/255>;
#declare CN_Introspective = rgb <109/255, 96/255, 83/255>;
#declare CN_Intuitive = rgb <207/255, 198/255, 188/255>;
#declare CN_Inuit_Blue = rgb <216/255, 228/255, 231/255>;
#declare CN_Inuit_White = rgb <209/255, 205/255, 208/255>;
#declare CN_Inventive_Orange = rgb <232/255, 157/255, 111/255>;
#declare CN_Inverness = rgb <87/255, 98/255, 56/255>;
#declare CN_Inverness_Grey = rgb <220/255, 227/255, 226/255>;
#declare CN_Invigorate = rgb <228/255, 114/255, 55/255>;
#declare CN_Invigorating = rgb <241/255, 234/255, 180/255>;
#declare CN_Invitation_Gold = rgb <166/255, 119/255, 63/255>;
#declare CN_Inviting_Gesture = rgb <205/255, 194/255, 157/255>;
#declare CN_Inviting_Ivory = rgb <242/255, 213/255, 176/255>;
#declare CN_Inviting_Veranda = rgb <185/255, 196/255, 188/255>;
#declare CN_Iolite = rgb <112/255, 123/255, 180/255>;
#declare CN_Ionian = rgb <54/255, 137/255, 118/255>;
#declare CN_Ionic_Ivory = rgb <231/255, 223/255, 197/255>;
#declare CN_Ionic_Sky = rgb <208/255, 237/255, 233/255>;
#declare CN_Ionized_air_Glow = rgb <85/255, 221/255, 255/255>;
#declare CN_Iqaluit_Ice = rgb <147/255, 207/255, 227/255>;
#declare CN_Ireland_Green = rgb <0/255, 108/255, 46/255>;
#declare CN_Iridescent = rgb <58/255, 91/255, 82/255>;
#declare CN_Iridescent_Green = rgb <72/255, 192/255, 114/255>;
#declare CN_Iridescent_Peacock = rgb <0/255, 112/255, 125/255>;
#declare CN_Iridescent_Purple = rgb <150/255, 111/255, 214/255>;
#declare CN_Iridescent_Red = rgb <204/255, 78/255, 92/255>;
#declare CN_Iridescent_Turquoise = rgb <123/255, 253/255, 199/255>;
#declare CN_Iris = rgb <90/255, 79/255, 207/255>;
#declare CN_Iris_Bloom = rgb <91/255, 96/255, 158/255>;
#declare CN_Iris_Blue = rgb <3/255, 180/255, 200/255>;
#declare CN_Iris_Eyes = rgb <118/255, 118/255, 148/255>;
#declare CN_Iris_Ice = rgb <224/255, 227/255, 239/255>;
#declare CN_Iris_Isle = rgb <232/255, 229/255, 236/255>;
#declare CN_Iris_Mauve = rgb <179/255, 155/255, 148/255>;
#declare CN_Iris_Orchid = rgb <167/255, 103/255, 162/255>;
#declare CN_Iris_Petal = rgb <107/255, 98/255, 115/255>;
#declare CN_Iris_Pink = rgb <202/255, 185/255, 190/255>;
#declare CN_Irish_Beauty = rgb <0/255, 127/255, 89/255>;
#declare CN_Irish_Charm = rgb <105/255, 144/255, 91/255>;
#declare CN_Irish_Clover = rgb <83/255, 115/255, 76/255>;
#declare CN_Irish_Coffee = rgb <98/255, 66/255, 43/255>;
#declare CN_Irish_Cream = rgb <233/255, 219/255, 190/255>;
#declare CN_Irish_Folklore = rgb <211/255, 227/255, 191/255>;
#declare CN_Irish_Green = rgb <1/255, 149/255, 41/255>;
#declare CN_Irish_Hedge = rgb <124/255, 179/255, 134/255>;
#declare CN_Irish_Jig = rgb <102/255, 204/255, 17/255>;
#declare CN_Irish_Linen = rgb <238/255, 228/255, 224/255>;
#declare CN_Irish_Mist = rgb <231/255, 229/255, 219/255>;
#declare CN_Irish_Moor = rgb <181/255, 192/255, 179/255>;
#declare CN_Irogon_Blue = rgb <157/255, 172/255, 181/255>;
#declare CN_Iroko = rgb <67/255, 49/255, 32/255>;
#declare CN_Iron = rgb <94/255, 94/255, 94/255>;
#declare CN_Iron_Creek = rgb <80/255, 103/255, 107/255>;
#declare CN_Iron_Earth = rgb <138/255, 161/255, 166/255>;
#declare CN_Iron_Fist = rgb <203/255, 205/255, 205/255>;
#declare CN_Iron_Fixture = rgb <93/255, 91/255, 91/255>;
#declare CN_Iron_Flint = rgb <110/255, 59/255, 49/255>;
#declare CN_Iron_Gate = rgb <78/255, 80/255, 85/255>;
#declare CN_Iron_Grey = rgb <124/255, 127/255, 124/255>;
#declare CN_Iron_Head = rgb <52/255, 77/255, 86/255>;
#declare CN_Iron_Maiden = rgb <214/255, 209/255, 220/255>;
#declare CN_Iron_Mountain = rgb <117/255, 117/255, 116/255>;
#declare CN_Iron_Ore = rgb <175/255, 91/255, 70/255>;
#declare CN_Iron_Oxide = rgb <131/255, 89/255, 73/255>;
#declare CN_Iron_River = rgb <77/255, 80/255, 75/255>;
#declare CN_Iron_Wood = rgb <160/255, 166/255, 168/255>;
#declare CN_Iron_ic = rgb <106/255, 107/255, 103/255>;
#declare CN_Ironbreaker = rgb <136/255, 127/255, 133/255>;
#declare CN_Ironbreaker_Metal = rgb <161/255, 166/255, 169/255>;
#declare CN_Ironclad = rgb <97/255, 92/255, 85/255>;
#declare CN_Ironside_Grey = rgb <112/255, 110/255, 102/255>;
#declare CN_Ironstone = rgb <134/255, 80/255, 64/255>;
#declare CN_Ironwood = rgb <161/255, 149/255, 131/255>;
#declare CN_Irradiant_Iris = rgb <218/255, 222/255, 230/255>;
#declare CN_Irradiated_Green = rgb <170/255, 255/255, 85/255>;
#declare CN_Irresistible = rgb <179/255, 68/255, 108/255>;
#declare CN_Irresistible_Beige = rgb <230/255, 221/255, 198/255>;
#declare CN_Irrigation = rgb <120/255, 108/255, 87/255>;
#declare CN_Irrigo_Purple = rgb <153/255, 85/255, 255/255>;
#declare CN_Irritated_Ibis = rgb <238/255, 17/255, 34/255>;
#declare CN_Is_It_Cold = rgb <0/255, 34/255, 255/255>;
#declare CN_Isabellas_Aqua = rgb <155/255, 216/255, 196/255>;
#declare CN_Isabelline = rgb <244/255, 240/255, 236/255>;
#declare CN_Ishtar = rgb <72/255, 68/255, 80/255>;
#declare CN_Islamic_Green = rgb <0/255, 153/255, 0/255>;
#declare CN_Island_Aqua = rgb <43/255, 185/255, 175/255>;
#declare CN_Island_Breeze = rgb <138/255, 218/255, 207/255>;
#declare CN_Island_Coral = rgb <216/255, 135/255, 122/255>;
#declare CN_Island_Dream = rgb <19/255, 155/255, 162/255>;
#declare CN_Island_Embrace = rgb <222/255, 217/255, 180/255>;
#declare CN_Island_Girl = rgb <255/255, 181/255, 154/255>;
#declare CN_Island_Green = rgb <43/255, 174/255, 102/255>;
#declare CN_Island_Hopping = rgb <246/255, 227/255, 214/255>;
#declare CN_Island_Light = rgb <167/255, 201/255, 235/255>;
#declare CN_Island_Lush = rgb <0/255, 130/255, 146/255>;
#declare CN_Island_Moment = rgb <63/255, 178/255, 168/255>;
#declare CN_Island_Monkey = rgb <173/255, 78/255, 26/255>;
#declare CN_Island_Oasis = rgb <136/255, 217/255, 216/255>;
#declare CN_Island_Palm = rgb <108/255, 126/255, 113/255>;
#declare CN_Island_Paradise = rgb <149/255, 222/255, 227/255>;
#declare CN_Island_Sea = rgb <129/255, 215/255, 208/255>;
#declare CN_Island_Spice = rgb <248/255, 237/255, 219/255>;
#declare CN_Island_View = rgb <195/255, 221/255, 238/255>;
#declare CN_Isle_of_Capri = rgb <0/255, 153/255, 201/255>;
#declare CN_Isle_of_Dreams = rgb <188/255, 204/255, 181/255>;
#declare CN_Isle_of_Pines = rgb <62/255, 102/255, 85/255>;
#declare CN_Isle_of_Sand = rgb <249/255, 221/255, 19/255>;
#declare CN_Isle_Royale = rgb <128/255, 215/255, 207/255>;
#declare CN_Isolation = rgb <73/255, 77/255, 85/255>;
#declare CN_Isotonic_Water = rgb <221/255, 255/255, 85/255>;
#declare CN_Issey_San = rgb <207/255, 218/255, 195/255>;
#declare CN_It_Works = rgb <175/255, 138/255, 91/255>;
#declare CN_Its_a_Girl = rgb <222/255, 149/255, 174/255>;
#declare CN_Its_A_Girl_ = rgb <255/255, 218/255, 226/255>;
#declare CN_Its_My_Party = rgb <204/255, 115/255, 101/255>;
#declare CN_Its_Your_Mauve = rgb <188/255, 152/255, 158/255>;
#declare CN_Italian_Basil = rgb <95/255, 105/255, 87/255>;
#declare CN_Italian_Buckthorn = rgb <107/255, 140/255, 35/255>;
#declare CN_Italian_Clay = rgb <215/255, 153/255, 121/255>;
#declare CN_Italian_Fitch = rgb <208/255, 200/255, 230/255>;
#declare CN_Italian_Grape = rgb <65/255, 61/255, 75/255>;
#declare CN_Italian_Ice = rgb <226/255, 224/255, 211/255>;
#declare CN_Italian_Lace = rgb <237/255, 233/255, 212/255>;
#declare CN_Italian_Olive = rgb <128/255, 114/255, 67/255>;
#declare CN_Italian_Plum = rgb <83/255, 49/255, 70/255>;
#declare CN_Italian_Roast = rgb <34/255, 17/255, 17/255>;
#declare CN_Italian_Sky_Blue = rgb <178/255, 252/255, 255/255>;
#declare CN_Italian_Straw = rgb <231/255, 209/255, 161/255>;
#declare CN_Italian_Villa = rgb <173/255, 93/255, 93/255>;
#declare CN_Italiano_Rose = rgb <209/255, 97/255, 105/255>;
#declare CN_Ivalo_River = rgb <204/255, 229/255, 232/255>;
#declare CN_Ivoire = rgb <228/255, 206/255, 172/255>;
#declare CN_Ivory = rgb <255/255, 255/255, 240/255>;
#declare CN_Ivory_Charm = rgb <255/255, 246/255, 218/255>;
#declare CN_Ivory_Coast = rgb <250/255, 245/255, 222/255>;
#declare CN_Ivory_Cream = rgb <218/255, 192/255, 167/255>;
#declare CN_Ivory_Invitation = rgb <252/255, 239/255, 214/255>;
#declare CN_Ivory_Keys = rgb <248/255, 247/255, 230/255>;
#declare CN_Ivory_Lace = rgb <236/255, 226/255, 204/255>;
#declare CN_Ivory_Lashes = rgb <230/255, 230/255, 216/255>;
#declare CN_Ivory_Memories = rgb <230/255, 221/255, 205/255>;
#declare CN_Ivory_Mist = rgb <239/255, 234/255, 222/255>;
#declare CN_Ivory_Oats = rgb <249/255, 228/255, 193/255>;
#declare CN_Ivory_Palace = rgb <238/255, 234/255, 220/255>;
#declare CN_Ivory_Paper = rgb <230/255, 222/255, 202/255>;
#declare CN_Ivory_Parchment = rgb <239/255, 227/255, 202/255>;
#declare CN_Ivory_Ridge = rgb <217/255, 201/255, 184/255>;
#declare CN_Ivory_Steam = rgb <240/255, 234/255, 218/255>;
#declare CN_Ivory_Stone = rgb <238/255, 225/255, 204/255>;
#declare CN_Ivory_Tassel = rgb <248/255, 234/255, 216/255>;
#declare CN_Ivory_Tower = rgb <251/255, 243/255, 241/255>;
#declare CN_Ivy = rgb <34/255, 108/255, 99/255>;
#declare CN_Ivy_Enchantment = rgb <147/255, 162/255, 114/255>;
#declare CN_Ivy_Garden = rgb <129/255, 128/255, 104/255>;
#declare CN_Ivy_Green = rgb <88/255, 84/255, 66/255>;
#declare CN_Ivy_League = rgb <0/255, 121/255, 88/255>;
#declare CN_Ivy_Topiary = rgb <103/255, 97/255, 79/255>;
#declare CN_Ivy_Wreath = rgb <112/255, 141/255, 118/255>;
#declare CN_Iwai_Brown = rgb <107/255, 111/255, 89/255>;
#declare CN_Iwaicha_Brown = rgb <94/255, 85/255, 69/255>;
#declare CN_Iyanden_Darksun = rgb <165/255, 154/255, 89/255>;
#declare CN_Izmir_Pink = rgb <206/255, 176/255, 181/255>;
#declare CN_Izmir_Purple = rgb <77/255, 66/255, 110/255>;
#declare CN_Js_Big_Heart = rgb <160/255, 104/255, 86/255>;
#declare CN_Jablonski_Brown = rgb <173/255, 109/255, 104/255>;
#declare CN_Jablonski_Grey = rgb <83/255, 104/255, 113/255>;
#declare CN_Jacaranda = rgb <249/255, 215/255, 238/255>;
#declare CN_Jacaranda_Jazz = rgb <108/255, 112/255, 169/255>;
#declare CN_Jacaranda_Light = rgb <168/255, 172/255, 183/255>;
#declare CN_Jacaranda_Pink = rgb <199/255, 96/255, 255/255>;
#declare CN_Jacarta = rgb <68/255, 0/255, 68/255>;
#declare CN_Jaceys_Favorite = rgb <188/255, 172/255, 205/255>;
#declare CN_Jack_and_Coke = rgb <146/255, 15/255, 14/255>;
#declare CN_Jack_Bone = rgb <134/255, 159/255, 105/255>;
#declare CN_Jack_Frost = rgb <218/255, 230/255, 227/255>;
#declare CN_Jack_Rabbit = rgb <192/255, 178/255, 177/255>;
#declare CN_Jack_o = rgb <251/255, 153/255, 2/255>;
#declare CN_Jack_O_Lantern = rgb <211/255, 122/255, 81/255>;
#declare CN_Jackal = rgb <169/255, 160/255, 147/255>;
#declare CN_Jackfruit = rgb <247/255, 198/255, 128/255>;
#declare CN_Jacko_Bean = rgb <65/255, 54/255, 40/255>;
#declare CN_Jackpot = rgb <209/255, 148/255, 49/255>;
#declare CN_Jackson_Antique = rgb <195/255, 189/255, 169/255>;
#declare CN_Jacksons_Purple = rgb <61/255, 63/255, 125/255>;
#declare CN_Jacobean_Lace = rgb <228/255, 204/255, 176/255>;
#declare CN_Jacqueline = rgb <93/255, 78/255, 80/255>;
#declare CN_Jacuzzi = rgb <0/255, 124/255, 172/255>;
#declare CN_Jade = rgb <0/255, 168/255, 107/255>;
#declare CN_Jade_Bracelet = rgb <194/255, 215/255, 173/255>;
#declare CN_Jade_Cream = rgb <96/255, 184/255, 146/255>;
#declare CN_Jade_Dragon = rgb <106/255, 161/255, 147/255>;
#declare CN_Jade_Dust = rgb <206/255, 221/255, 218/255>;
#declare CN_Jade_Glass = rgb <0/255, 206/255, 209/255>;
#declare CN_Jade_Gravel = rgb <10/255, 186/255, 181/255>;
#declare CN_Jade_Green = rgb <119/255, 153/255, 119/255>;
#declare CN_Jade_Jewel = rgb <36/255, 126/255, 129/255>;
#declare CN_Jade_Light_Green = rgb <193/255, 202/255, 183/255>;
#declare CN_Jade_Lime = rgb <161/255, 202/255, 123/255>;
#declare CN_Jade_Mist = rgb <214/255, 233/255, 215/255>;
#declare CN_Jade_Mountain = rgb <52/255, 194/255, 167/255>;
#declare CN_Jade_Mussel_Green = rgb <22/255, 106/255, 69/255>;
#declare CN_Jade_Orchid = rgb <0/255, 170/255, 170/255>;
#declare CN_Jade_Powder = rgb <43/255, 175/255, 106/255>;
#declare CN_Jade_Shard = rgb <1/255, 123/255, 146/255>;
#declare CN_Jade_Spell = rgb <193/255, 229/255, 213/255>;
#declare CN_Jade_Stone_Green = rgb <116/255, 187/255, 131/255>;
#declare CN_Jade_Tinge = rgb <187/255, 204/255, 188/255>;
#declare CN_Jaded = rgb <0/255, 146/255, 161/255>;
#declare CN_Jaded_Clouds = rgb <174/255, 221/255, 211/255>;
#declare CN_Jaded_Ginger = rgb <204/255, 119/255, 102/255>;
#declare CN_Jadeite = rgb <56/255, 198/255, 161/255>;
#declare CN_Jadesheen = rgb <119/255, 162/255, 118/255>;
#declare CN_Jadite = rgb <97/255, 130/255, 108/255>;
#declare CN_Jaffa = rgb <226/255, 121/255, 69/255>;
#declare CN_Jaffa_Orange = rgb <216/255, 109/255, 57/255>;
#declare CN_Jagdwurst = rgb <255/255, 204/255, 203/255>;
#declare CN_Jagged_Ice = rgb <202/255, 231/255, 226/255>;
#declare CN_Jagger = rgb <63/255, 46/255, 76/255>;
#declare CN_Jaguar = rgb <41/255, 41/255, 47/255>;
#declare CN_Jaguar_Rose = rgb <241/255, 179/255, 182/255>;
#declare CN_Jaipur_Pink = rgb <208/255, 65/255, 126/255>;
#declare CN_Jakarta = rgb <239/255, 221/255, 195/255>;
#declare CN_Jakarta_Skyline = rgb <61/255, 50/255, 93/255>;
#declare CN_Jalapeno = rgb <154/255, 141/255, 63/255>;
#declare CN_Jalapeno_Bouquet = rgb <87/255, 102/255, 72/255>;
#declare CN_Jalapeno_Red = rgb <178/255, 16/255, 60/255>;
#declare CN_Jam_Session = rgb <212/255, 207/255, 214/255>;
#declare CN_Jama_Masjid_Taupe = rgb <179/255, 139/255, 109/255>;
#declare CN_Jamaica_Bay = rgb <149/255, 203/255, 196/255>;
#declare CN_Jamaican_Dream = rgb <4/255, 98/255, 122/255>;
#declare CN_Jamaican_Jade = rgb <100/255, 209/255, 190/255>;
#declare CN_Jamaican_Sea = rgb <38/255, 165/255, 186/255>;
#declare CN_Jambalaya = rgb <247/255, 181/255, 114/255>;
#declare CN_James_Blonde = rgb <242/255, 227/255, 181/255>;
#declare CN_Janemba_Red = rgb <255/255, 34/255, 17/255>;
#declare CN_Janeys_Party = rgb <206/255, 181/255, 200/255>;
#declare CN_Janitor = rgb <34/255, 102/255, 204/255>;
#declare CN_Janna = rgb <244/255, 235/255, 211/255>;
#declare CN_January_Blue = rgb <0/255, 161/255, 185/255>;
#declare CN_January_Dawn = rgb <223/255, 226/255, 229/255>;
#declare CN_January_Frost = rgb <153/255, 193/255, 220/255>;
#declare CN_January_Garnet = rgb <123/255, 65/255, 65/255>;
#declare CN_Japan_Blush = rgb <221/255, 214/255, 243/255>;
#declare CN_Japanese_Bonsai = rgb <130/255, 159/255, 150/255>;
#declare CN_Japanese_Carmine = rgb <159/255, 40/255, 50/255>;
#declare CN_Japanese_Coral = rgb <196/255, 122/255, 136/255>;
#declare CN_Japanese_Cypress = rgb <150/255, 80/255, 54/255>;
#declare CN_Japanese_Fern = rgb <181/255, 185/255, 76/255>;
#declare CN_Japanese_Horseradish = rgb <168/255, 191/255, 147/255>;
#declare CN_Japanese_Indigo = rgb <38/255, 67/255, 72/255>;
#declare CN_Japanese_Iris = rgb <127/255, 93/255, 59/255>;
#declare CN_Japanese_Kimono = rgb <204/255, 99/255, 88/255>;
#declare CN_Japanese_Koi = rgb <219/255, 120/255, 66/255>;
#declare CN_Japanese_Laurel = rgb <47/255, 117/255, 50/255>;
#declare CN_Japanese_Maple = rgb <120/255, 1/255, 9/255>;
#declare CN_Japanese_Poet = rgb <196/255, 186/255, 183/255>;
#declare CN_Japanese_Rose_Garden = rgb <228/255, 182/255, 196/255>;
#declare CN_Japanese_Sable = rgb <49/255, 55/255, 57/255>;
#declare CN_Japanese_Violet = rgb <91/255, 50/255, 86/255>;
#declare CN_Japanese_Wax_Tree = rgb <183/255, 123/255, 87/255>;
#declare CN_Japanese_White = rgb <238/255, 230/255, 217/255>;
#declare CN_Japanese_Wineberry = rgb <82/255, 44/255, 53/255>;
#declare CN_Japanese_Yew = rgb <216/255, 163/255, 115/255>;
#declare CN_Japonica = rgb <206/255, 114/255, 89/255>;
#declare CN_Jardin = rgb <189/255, 208/255, 171/255>;
#declare CN_Jardin_De_Hierbas = rgb <198/255, 202/255, 167/255>;
#declare CN_Jargon_Jade = rgb <83/255, 163/255, 143/255>;
#declare CN_Jarrah = rgb <130/255, 112/255, 88/255>;
#declare CN_Jasmine = rgb <255/255, 244/255, 187/255>;
#declare CN_Jasmine_Flower = rgb <244/255, 232/255, 225/255>;
#declare CN_Jasmine_Green = rgb <126/255, 200/255, 69/255>;
#declare CN_Jasmine_Hollow = rgb <126/255, 116/255, 104/255>;
#declare CN_Jasper = rgb <215/255, 59/255, 62/255>;
#declare CN_Jasper_Cane = rgb <231/255, 200/255, 159/255>;
#declare CN_Jasper_Green = rgb <87/255, 96/255, 90/255>;
#declare CN_Jasper_Orange = rgb <222/255, 143/255, 78/255>;
#declare CN_Jasper_Park = rgb <74/255, 101/255, 88/255>;
#declare CN_Jasper_Stone = rgb <141/255, 158/255, 151/255>;
#declare CN_Java = rgb <37/255, 151/255, 151/255>;
#declare CN_Jay_Bird = rgb <80/255, 133/255, 158/255>;
#declare CN_Jay_Wing_Feathers = rgb <121/255, 148/255, 181/255>;
#declare CN_Jazlyn = rgb <70/255, 65/255, 82/255>;
#declare CN_Jazz = rgb <95/255, 44/255, 47/255>;
#declare CN_Jazz_Age_Blues = rgb <59/255, 74/255, 108/255>;
#declare CN_Jazz_Age_Coral = rgb <241/255, 191/255, 177/255>;
#declare CN_Jazz_Blue = rgb <26/255, 106/255, 159/255>;
#declare CN_Jazz_Tune = rgb <152/255, 146/255, 168/255>;
#declare CN_Jazzberry_Jam = rgb <103/255, 66/255, 71/255>;
#declare CN_Jazzercise = rgb <182/255, 225/255, 42/255>;
#declare CN_Jazzy = rgb <182/255, 28/255, 80/255>;
#declare CN_Jazzy_Jade = rgb <85/255, 221/255, 204/255>;
#declare CN_Jealous_Jellyfish = rgb <187/255, 0/255, 153/255>;
#declare CN_Jealousy = rgb <127/255, 171/255, 96/255>;
#declare CN_Jean_Jacket_Blue = rgb <123/255, 144/255, 162/255>;
#declare CN_Jeans_Indigo = rgb <109/255, 137/255, 148/255>;
#declare CN_Jedi_Night = rgb <4/255, 17/255, 8/255>;
#declare CN_Jefferson_Cream = rgb <241/255, 228/255, 200/255>;
#declare CN_Jelly_Bean = rgb <68/255, 121/255, 142/255>;
#declare CN_Jelly_Berry = rgb <238/255, 17/255, 119/255>;
#declare CN_Jelly_Slug = rgb <222/255, 102/255, 70/255>;
#declare CN_Jelly_Yogurt = rgb <237/255, 230/255, 217/255>;
#declare CN_Jellybean_Pink = rgb <155/255, 101/255, 117/255>;
#declare CN_Jellyfish_Blue = rgb <149/255, 202/255, 208/255>;
#declare CN_Jellyfish_Sting = rgb <238/255, 102/255, 136/255>;
#declare CN_Jemima = rgb <246/255, 214/255, 127/255>;
#declare CN_Jerboa = rgb <222/255, 184/255, 135/255>;
#declare CN_Jericho_Jade = rgb <77/255, 134/255, 129/255>;
#declare CN_Jersey_Cream = rgb <245/255, 222/255, 187/255>;
#declare CN_Jess = rgb <37/255, 179/255, 135/255>;
#declare CN_Jester_Red = rgb <158/255, 16/255, 48/255>;
#declare CN_Jet = rgb <52/255, 52/255, 52/255>;
#declare CN_Jet_Black = rgb <45/255, 44/255, 47/255>;
#declare CN_Jet_dEau = rgb <209/255, 234/255, 236/255>;
#declare CN_Jet_Fuel = rgb <87/255, 86/255, 84/255>;
#declare CN_Jet_Grey = rgb <157/255, 154/255, 154/255>;
#declare CN_Jet_Set = rgb <38/255, 44/255, 42/255>;
#declare CN_Jet_Ski = rgb <84/255, 146/255, 175/255>;
#declare CN_Jet_Stream = rgb <187/255, 208/255, 201/255>;
#declare CN_Jet_White = rgb <242/255, 237/255, 226/255>;
#declare CN_Jetski_Race = rgb <0/255, 93/255, 150/255>;
#declare CN_Jetstream = rgb <176/255, 210/255, 214/255>;
#declare CN_Jewel = rgb <19/255, 104/255, 67/255>;
#declare CN_Jewel_Caterpillar = rgb <211/255, 116/255, 213/255>;
#declare CN_Jewel_Cave = rgb <60/255, 65/255, 115/255>;
#declare CN_Jewel_Weed = rgb <70/255, 167/255, 149/255>;
#declare CN_Jewellery_White = rgb <206/255, 214/255, 230/255>;
#declare CN_Jewett_White = rgb <230/255, 221/255, 202/255>;
#declare CN_Jigglypuff = rgb <255/255, 170/255, 255/255>;
#declare CN_Jimbaran_Bay = rgb <61/255, 93/255, 100/255>;
#declare CN_Jin_Huang_Gold = rgb <245/255, 213/255, 101/255>;
#declare CN_Jin_Se_Gold = rgb <165/255, 165/255, 2/255>;
#declare CN_Jin_Zong_Gold = rgb <142/255, 118/255, 24/255>;
#declare CN_Jinza_Safflower = rgb <238/255, 130/255, 124/255>;
#declare CN_Jinzamomi_Pink = rgb <247/255, 102/255, 90/255>;
#declare CN_Jitterbug = rgb <186/255, 192/255, 138/255>;
#declare CN_Jitterbug_Jade = rgb <1/255, 157/255, 110/255>;
#declare CN_Jitterbug_Lure = rgb <141/255, 176/255, 173/255>;
#declare CN_Jittery_Jade = rgb <119/255, 238/255, 187/255>;
#declare CN_Jobs_Tears = rgb <0/255, 91/255, 122/255>;
#declare CN_Jocose_Jade = rgb <119/255, 204/255, 153/255>;
#declare CN_Jocular_Green = rgb <204/255, 226/255, 202/255>;
#declare CN_Jodhpur_Blue = rgb <155/255, 215/255, 233/255>;
#declare CN_Jodhpur_Tan = rgb <218/255, 209/255, 200/255>;
#declare CN_Jodhpurs = rgb <235/255, 220/255, 182/255>;
#declare CN_Jogging_Path = rgb <192/255, 185/255, 169/255>;
#declare CN_John_Lemon = rgb <238/255, 255/255, 34/255>;
#declare CN_Joie_De_Vivre = rgb <188/255, 134/255, 175/255>;
#declare CN_Jojoba = rgb <218/255, 190/255, 129/255>;
#declare CN_Jokaero_Orange = rgb <234/255, 85/255, 5/255>;
#declare CN_Jokers_Smile = rgb <215/255, 1/255, 65/255>;
#declare CN_Jolly_Green = rgb <94/255, 119/255, 74/255>;
#declare CN_Jolly_Jade = rgb <119/255, 204/255, 187/255>;
#declare CN_Jonquil = rgb <238/255, 242/255, 147/255>;
#declare CN_Jonquil_Trail = rgb <247/255, 211/255, 149/255>;
#declare CN_Jordan_Jazz = rgb <3/255, 122/255, 59/255>;
#declare CN_Jordy_Blue = rgb <122/255, 170/255, 224/255>;
#declare CN_Josephine = rgb <211/255, 195/255, 190/255>;
#declare CN_Joshua_Tree = rgb <127/255, 179/255, 119/255>;
#declare CN_Journal_White = rgb <230/255, 211/255, 178/255>;
#declare CN_Journey_to_the_Sky = rgb <205/255, 236/255, 237/255>;
#declare CN_Journeys_End = rgb <186/255, 201/255, 212/255>;
#declare CN_Joust_Blue = rgb <85/255, 170/255, 255/255>;
#declare CN_Jovial = rgb <238/255, 185/255, 167/255>;
#declare CN_Jovial_Jade = rgb <136/255, 221/255, 170/255>;
#declare CN_Joyful = rgb <246/255, 238/255, 192/255>;
#declare CN_Joyful_Lilac = rgb <228/255, 212/255, 226/255>;
#declare CN_Joyful_Orange = rgb <250/255, 147/255, 53/255>;
#declare CN_Joyful_Poppy = rgb <235/255, 173/255, 165/255>;
#declare CN_Joyful_Ruby = rgb <80/255, 49/255, 54/255>;
#declare CN_Joyful_Tears = rgb <0/255, 102/255, 105/255>;
#declare CN_Joyous = rgb <255/255, 238/255, 176/255>;
#declare CN_Joyous_Song = rgb <91/255, 54/255, 94/255>;
#declare CN_Ju_Huang_Tangerine = rgb <249/255, 144/255, 15/255>;
#declare CN_Jube = rgb <75/255, 55/255, 60/255>;
#declare CN_Jube_Green = rgb <120/255, 207/255, 134/255>;
#declare CN_Jubilant_Jade = rgb <68/255, 170/255, 119/255>;
#declare CN_Jubilation = rgb <251/255, 221/255, 36/255>;
#declare CN_Jubilee = rgb <126/255, 96/255, 153/255>;
#declare CN_Jubilee_Grey = rgb <124/255, 115/255, 121/255>;
#declare CN_Judah_Silk = rgb <71/255, 55/255, 57/255>;
#declare CN_Judge_Grey = rgb <93/255, 83/255, 70/255>;
#declare CN_Jugendstil_Green = rgb <195/255, 200/255, 179/255>;
#declare CN_Jugendstil_Pink = rgb <157/255, 99/255, 117/255>;
#declare CN_Jugendstil_Turquoise = rgb <95/255, 155/255, 156/255>;
#declare CN_Juggernaut = rgb <37/255, 83/255, 103/255>;
#declare CN_Juice_Violet = rgb <68/255, 34/255, 56/255>;
#declare CN_Juicy_Details = rgb <217/255, 120/255, 124/255>;
#declare CN_Juicy_Fig = rgb <125/255, 108/255, 74/255>;
#declare CN_Juicy_Jackfruit = rgb <238/255, 221/255, 51/255>;
#declare CN_Juicy_Lime = rgb <177/255, 207/255, 93/255>;
#declare CN_Juicy_Mango = rgb <255/255, 208/255, 141/255>;
#declare CN_Juicy_Passionfruit = rgb <241/255, 136/255, 112/255>;
#declare CN_Julep = rgb <87/255, 170/255, 128/255>;
#declare CN_Julep_Green = rgb <199/255, 219/255, 217/255>;
#declare CN_Jules = rgb <167/255, 57/255, 64/255>;
#declare CN_July = rgb <139/255, 210/255, 227/255>;
#declare CN_July_Ruby = rgb <119/255, 59/255, 74/255>;
#declare CN_Jumbo = rgb <135/255, 135/255, 133/255>;
#declare CN_June = rgb <155/255, 196/255, 212/255>;
#declare CN_June_Berry = rgb <155/255, 150/255, 182/255>;
#declare CN_June_Bud = rgb <189/255, 218/255, 87/255>;
#declare CN_June_Bug = rgb <38/255, 74/255, 72/255>;
#declare CN_June_Bugs = rgb <187/255, 102/255, 51/255>;
#declare CN_June_Day = rgb <255/255, 225/255, 130/255>;
#declare CN_June_Vision = rgb <241/255, 241/255, 218/255>;
#declare CN_Juneberry = rgb <119/255, 84/255, 150/255>;
#declare CN_Jungle = rgb <0/255, 164/255, 102/255>;
#declare CN_Jungle_Adventure = rgb <68/255, 109/255, 70/255>;
#declare CN_Jungle_Book_Green = rgb <54/255, 108/255, 78/255>;
#declare CN_Jungle_Camouflage = rgb <83/255, 102/255, 90/255>;
#declare CN_Jungle_Civilization = rgb <105/255, 103/255, 58/255>;
#declare CN_Jungle_Cloak = rgb <104/255, 105/255, 89/255>;
#declare CN_Jungle_Cover = rgb <86/255, 80/255, 66/255>;
#declare CN_Jungle_Expedition = rgb <180/255, 147/255, 86/255>;
#declare CN_Jungle_Green = rgb <4/255, 130/255, 67/255>;
#declare CN_Jungle_Juice = rgb <164/255, 193/255, 97/255>;
#declare CN_Jungle_Khaki = rgb <199/255, 190/255, 167/255>;
#declare CN_Jungle_King = rgb <79/255, 77/255, 50/255>;
#declare CN_Jungle_Mist = rgb <176/255, 196/255, 196/255>;
#declare CN_Jungle_Moss = rgb <189/255, 195/255, 172/255>;
#declare CN_Jungle_Noises = rgb <54/255, 113/255, 111/255>;
#declare CN_Jungle_Trail = rgb <109/255, 111/255, 66/255>;
#declare CN_Juniper = rgb <116/255, 145/255, 142/255>;
#declare CN_Juniper_Ash = rgb <121/255, 136/255, 132/255>;
#declare CN_Juniper_Berries = rgb <84/255, 113/255, 116/255>;
#declare CN_Juniper_Berry = rgb <185/255, 179/255, 194/255>;
#declare CN_Juniper_Berry_Blue = rgb <63/255, 98/255, 110/255>;
#declare CN_Juniper_Breeze = rgb <217/255, 224/255, 216/255>;
#declare CN_Juniper_Green = rgb <86/255, 127/255, 105/255>;
#declare CN_Juniper_Oil = rgb <107/255, 139/255, 117/255>;
#declare CN_Junket = rgb <251/255, 236/255, 211/255>;
#declare CN_Junkrat = rgb <153/255, 135/255, 120/255>;
#declare CN_Jupiter = rgb <225/255, 225/255, 226/255>;
#declare CN_Jupiter_Brown = rgb <172/255, 129/255, 129/255>;
#declare CN_Jurassic_Gold = rgb <231/255, 170/255, 86/255>;
#declare CN_Jurassic_Park = rgb <60/255, 102/255, 62/255>;
#declare CN_Just_a_Fairytale = rgb <108/255, 93/255, 151/255>;
#declare CN_Just_a_Little = rgb <219/255, 224/255, 214/255>;
#declare CN_Just_A_Tease = rgb <251/255, 214/255, 210/255>;
#declare CN_Just_About_Green = rgb <226/255, 231/255, 211/255>;
#declare CN_Just_About_White = rgb <232/255, 232/255, 224/255>;
#declare CN_Just_Blush = rgb <250/255, 180/255, 164/255>;
#declare CN_Just_Gorgeous = rgb <214/255, 196/255, 193/255>;
#declare CN_Just_Peachy = rgb <248/255, 194/255, 117/255>;
#declare CN_Just_Perfect = rgb <234/255, 236/255, 211/255>;
#declare CN_Just_Pink_Enough = rgb <255/255, 235/255, 238/255>;
#declare CN_Just_Right = rgb <220/255, 191/255, 172/255>;
#declare CN_Just_Rosey = rgb <196/255, 162/255, 149/255>;
#declare CN_Justice = rgb <96/255, 107/255, 142/255>;
#declare CN_Jute = rgb <173/255, 151/255, 115/255>;
#declare CN_Jute_Brown = rgb <129/255, 93/255, 64/255>;
#declare CN_Juzcar_Blue = rgb <161/255, 213/255, 241/255>;
#declare CN_Ka_Fei_Se_Brown = rgb <115/255, 99/255, 84/255>;
#declare CN_Kabacha_Brown = rgb <177/255, 74/255, 48/255>;
#declare CN_Kabalite_Green = rgb <3/255, 140/255, 103/255>;
#declare CN_Kabocha_Green = rgb <4/255, 74/255, 5/255>;
#declare CN_Kabul = rgb <108/255, 94/255, 83/255>;
#declare CN_Kaceys_Pink = rgb <233/255, 75/255, 126/255>;
#declare CN_Kachi_Indigo = rgb <57/255, 62/255, 79/255>;
#declare CN_Kaffee = rgb <129/255, 109/255, 90/255>;
#declare CN_Kaffir_Lime = rgb <185/255, 171/255, 133/255>;
#declare CN_Kahili = rgb <183/255, 191/255, 176/255>;
#declare CN_Kahlua_Milk = rgb <186/255, 176/255, 153/255>;
#declare CN_Kahu_Blue = rgb <0/255, 147/255, 214/255>;
#declare CN_Kaitoke_Green = rgb <36/255, 83/255, 54/255>;
#declare CN_Kakadu_Trail = rgb <125/255, 128/255, 110/255>;
#declare CN_Kakariki_Green = rgb <41/255, 130/255, 86/255>;
#declare CN_Kakitsubata_Blue = rgb <62/255, 98/255, 173/255>;
#declare CN_Kala_Black = rgb <32/255, 24/255, 25/255>;
#declare CN_Kala_Namak = rgb <70/255, 68/255, 76/255>;
#declare CN_Kalahari_Sunset = rgb <159/255, 84/255, 64/255>;
#declare CN_Kalamata = rgb <95/255, 91/255, 76/255>;
#declare CN_Kale = rgb <90/255, 114/255, 71/255>;
#declare CN_Kale_Green = rgb <79/255, 106/255, 86/255>;
#declare CN_Kaleidoscope = rgb <141/255, 168/255, 190/255>;
#declare CN_Kali_Blue = rgb <0/255, 80/255, 90/255>;
#declare CN_Kalish_Violet = rgb <85/255, 34/255, 136/255>;
#declare CN_Kalliene_Yellow = rgb <181/255, 152/255, 8/255>;
#declare CN_Kaltes_Klares_Wasser = rgb <15/255, 254/255, 249/255>;
#declare CN_Kamenozoki_Grey = rgb <198/255, 194/255, 182/255>;
#declare CN_Kamut = rgb <204/255, 164/255, 131/255>;
#declare CN_Kanafeh = rgb <221/255, 136/255, 51/255>;
#declare CN_Kandinsky_Turquoise = rgb <45/255, 130/255, 132/255>;
#declare CN_Kangaroo = rgb <197/255, 195/255, 176/255>;
#declare CN_Kangaroo_Fur = rgb <196/255, 173/255, 146/255>;
#declare CN_Kangaroo_Paw = rgb <222/255, 202/255, 197/255>;
#declare CN_Kangaroo_Pouch = rgb <189/255, 162/255, 137/255>;
#declare CN_Kangaroo_Tan = rgb <228/255, 215/255, 206/255>;
#declare CN_Kansas_Grain = rgb <254/255, 231/255, 203/255>;
#declare CN_Kantor_Blue = rgb <0/255, 17/255, 70/255>;
#declare CN_Kanzo_Orange = rgb <255/255, 137/255, 54/255>;
#declare CN_Kaolin = rgb <173/255, 125/255, 64/255>;
#declare CN_Kappa_Green = rgb <197/255, 222/255, 209/255>;
#declare CN_Kara_Cha_Brown = rgb <120/255, 60/255, 29/255>;
#declare CN_Karacha_Red = rgb <179/255, 92/255, 68/255>;
#declare CN_Karak_Stone = rgb <187/255, 150/255, 98/255>;
#declare CN_Karaka = rgb <45/255, 45/255, 36/255>;
#declare CN_Karaka_Orange = rgb <240/255, 73/255, 37/255>;
#declare CN_Karakurenai_Red = rgb <201/255, 31/255, 55/255>;
#declare CN_Kariyasu_Green = rgb <110/255, 121/255, 85/255>;
#declare CN_Karma = rgb <178/255, 164/255, 132/255>;
#declare CN_Karma_Chameleon = rgb <159/255, 120/255, 169/255>;
#declare CN_Karry = rgb <254/255, 220/255, 193/255>;
#declare CN_Kashmir = rgb <111/255, 141/255, 106/255>;
#declare CN_Kashmir_Blue = rgb <87/255, 109/255, 142/255>;
#declare CN_Kashmir_Pink = rgb <233/255, 200/255, 195/255>;
#declare CN_Kasugai_Peach = rgb <243/255, 223/255, 213/255>;
#declare CN_Kathleens_Garden = rgb <143/255, 160/255, 153/255>;
#declare CN_Kathmandu = rgb <173/255, 154/255, 93/255>;
#declare CN_Katsura = rgb <201/255, 227/255, 204/255>;
#declare CN_Katy_Berry = rgb <170/255, 0/255, 119/255>;
#declare CN_Katydid = rgb <102/255, 188/255, 145/255>;
#declare CN_Kauai = rgb <90/255, 199/255, 172/255>;
#declare CN_Kawaii = rgb <234/255, 171/255, 188/255>;
#declare CN_Kazakhstan_Yellow = rgb <254/255, 197/255, 12/255>;
#declare CN_Keel_Joy = rgb <212/255, 149/255, 149/255>;
#declare CN_Keemun = rgb <164/255, 148/255, 99/255>;
#declare CN_Keen_Green = rgb <34/255, 102/255, 0/255>;
#declare CN_Keepsake = rgb <192/255, 206/255, 214/255>;
#declare CN_Keepsake_Lilac = rgb <192/255, 165/255, 174/255>;
#declare CN_Keepsake_Rose = rgb <176/255, 134/255, 147/255>;
#declare CN_Keese_Blue = rgb <0/255, 0/255, 188/255>;
#declare CN_Kefir = rgb <213/255, 213/255, 206/255>;
#declare CN_Kelley_Green = rgb <2/255, 171/255, 46/255>;
#declare CN_Kellie_Belle = rgb <222/255, 199/255, 207/255>;
#declare CN_Kelly_Green = rgb <51/255, 156/255, 94/255>;
#declare CN_Kellys_Flower = rgb <186/255, 189/255, 108/255>;
#declare CN_Kelp = rgb <77/255, 80/255, 60/255>;
#declare CN_Kelp_Brown = rgb <113/255, 98/255, 70/255>;
#declare CN_Kelp_Forest = rgb <68/255, 136/255, 17/255>;
#declare CN_Kelpthar_Forest_Blue = rgb <0/255, 146/255, 174/255>;
#declare CN_Kemp_Kelly = rgb <67/255, 123/255, 72/255>;
#declare CN_Ken_Masters_Red = rgb <236/255, 44/255, 37/255>;
#declare CN_Kendal_Green = rgb <84/255, 120/255, 103/255>;
#declare CN_Kendall_Rose = rgb <247/255, 204/255, 205/255>;
#declare CN_Kennys_Kiss = rgb <212/255, 88/255, 113/255>;
#declare CN_Kenpo_Brown = rgb <84/255, 63/255, 50/255>;
#declare CN_Kenpozome_Black = rgb <46/255, 33/255, 27/255>;
#declare CN_Kentucky = rgb <99/255, 149/255, 191/255>;
#declare CN_Kentucky_Blue = rgb <165/255, 179/255, 204/255>;
#declare CN_Kentucky_Bluegrass = rgb <34/255, 170/255, 187/255>;
#declare CN_Kenya = rgb <204/255, 161/255, 121/255>;
#declare CN_Kenyan_Copper = rgb <108/255, 50/255, 46/255>;
#declare CN_Kenyan_Sand = rgb <187/255, 136/255, 0/255>;
#declare CN_Keppel = rgb <95/255, 182/255, 156/255>;
#declare CN_Kermit_Green = rgb <92/255, 178/255, 0/255>;
#declare CN_Kernel = rgb <236/255, 185/255, 118/255>;
#declare CN_Kerrs_Pink_Potato = rgb <181/255, 114/255, 129/255>;
#declare CN_Keshizumi_Cinder = rgb <82/255, 78/255, 77/255>;
#declare CN_Kestrel_White = rgb <224/255, 214/255, 200/255>;
#declare CN_Ketchup = rgb <154/255, 56/255, 45/255>;
#declare CN_Kettle_Black = rgb <19/255, 19/255, 19/255>;
#declare CN_Kettle_Corn = rgb <246/255, 226/255, 189/255>;
#declare CN_Kettle_Drum = rgb <155/255, 203/255, 150/255>;
#declare CN_Kettleman = rgb <96/255, 96/255, 97/255>;
#declare CN_Key_Keeper = rgb <236/255, 209/255, 165/255>;
#declare CN_Key_Largo = rgb <127/255, 182/255, 164/255>;
#declare CN_Key_Lime = rgb <174/255, 255/255, 110/255>;
#declare CN_Key_Lime_Pie = rgb <191/255, 201/255, 33/255>;
#declare CN_Key_Lime_Water = rgb <232/255, 244/255, 140/255>;
#declare CN_Key_to_the_City = rgb <187/255, 155/255, 124/255>;
#declare CN_Key_West_Zenith = rgb <117/255, 159/255, 193/255>;
#declare CN_Keystone = rgb <179/255, 147/255, 114/255>;
#declare CN_Keystone_Gray = rgb <158/255, 146/255, 132/255>;
#declare CN_Keystone_Grey = rgb <182/255, 187/255, 178/255>;
#declare CN_Khaki = rgb <195/255, 176/255, 145/255>;
#declare CN_Khaki_Brown = rgb <149/255, 78/255, 42/255>;
#declare CN_Khaki_Core = rgb <251/255, 228/255, 175/255>;
#declare CN_Khaki_Green = rgb <114/255, 134/255, 57/255>;
#declare CN_Khaki_Shade = rgb <212/255, 197/255, 172/255>;
#declare CN_Khardic_Flesh = rgb <177/255, 104/255, 64/255>;
#declare CN_Khemri_Brown = rgb <118/255, 102/255, 76/255>;
#declare CN_Khmer_Curry = rgb <238/255, 85/255, 85/255>;
#declare CN_Khorne_Red = rgb <106/255, 0/255, 1/255>;
#declare CN_Kickstart_Purple = rgb <119/255, 119/255, 204/255>;
#declare CN_Kid_Gloves = rgb <182/255, 174/255, 174/255>;
#declare CN_Kid_Icarus = rgb <168/255, 16/255, 0/255>;
#declare CN_Kids_Stuff = rgb <237/255, 135/255, 50/255>;
#declare CN_Kidnapper = rgb <191/255, 192/255, 171/255>;
#declare CN_Kihada_Yellow = rgb <254/255, 242/255, 99/255>;
#declare CN_Kikorangi_Blue = rgb <46/255, 78/255, 191/255>;
#declare CN_Kikuchiba_Gold = rgb <226/255, 156/255, 69/255>;
#declare CN_Kikyo_Purple = rgb <93/255, 63/255, 106/255>;
#declare CN_Kilauea_Lava = rgb <132/255, 61/255, 56/255>;
#declare CN_Kilim_Beige = rgb <215/255, 197/255, 174/255>;
#declare CN_Kilimanjaro = rgb <58/255, 53/255, 50/255>;
#declare CN_Kilkenny = rgb <73/255, 133/255, 85/255>;
#declare CN_Killarney = rgb <73/255, 118/255, 79/255>;
#declare CN_Killer_Fog = rgb <201/255, 210/255, 209/255>;
#declare CN_Kiln_Dried = rgb <168/255, 152/255, 135/255>;
#declare CN_Kimberley_Sea = rgb <56/255, 107/255, 125/255>;
#declare CN_Kimberley_Tree = rgb <184/255, 193/255, 177/255>;
#declare CN_Kimberlite = rgb <105/255, 111/255, 165/255>;
#declare CN_Kimberly = rgb <105/255, 93/255, 135/255>;
#declare CN_Kimchi = rgb <237/255, 75/255, 0/255>;
#declare CN_Kimirucha_Brown = rgb <137/255, 108/255, 57/255>;
#declare CN_Kimono = rgb <109/255, 134/255, 182/255>;
#declare CN_Kimono_Grey = rgb <61/255, 76/255, 81/255>;
#declare CN_Kimono_Violet = rgb <117/255, 118/255, 155/255>;
#declare CN_Kin_Gold = rgb <243/255, 152/255, 0/255>;
#declare CN_Kincha_Brown = rgb <198/255, 107/255, 39/255>;
#declare CN_Kind_Green = rgb <170/255, 194/255, 179/255>;
#declare CN_Kind_Magenta = rgb <255/255, 29/255, 206/255>;
#declare CN_Kinder = rgb <184/255, 191/255, 202/255>;
#declare CN_Kindleflame = rgb <233/255, 150/255, 122/255>;
#declare CN_Kindling = rgb <122/255, 112/255, 104/255>;
#declare CN_Kindness = rgb <212/255, 178/255, 192/255>;
#declare CN_King_Creek_Falls = rgb <95/255, 104/255, 111/255>;
#declare CN_King_Ghidorah = rgb <170/255, 153/255, 119/255>;
#declare CN_King_Kong = rgb <22/255, 20/255, 16/255>;
#declare CN_King_Lime = rgb <173/255, 217/255, 0/255>;
#declare CN_King_Lizard = rgb <119/255, 221/255, 34/255>;
#declare CN_King_Nacho = rgb <255/255, 184/255, 0/255>;
#declare CN_King_Neptune = rgb <119/255, 148/255, 192/255>;
#declare CN_King_of_Waves = rgb <198/255, 220/255, 231/255>;
#declare CN_King_Salmon = rgb <216/255, 134/255, 104/255>;
#declare CN_King_Tide = rgb <42/255, 114/255, 121/255>;
#declare CN_King_Triton = rgb <60/255, 133/255, 190/255>;
#declare CN_Kings_Cloak = rgb <196/255, 134/255, 146/255>;
#declare CN_Kings_Court = rgb <112/255, 109/255, 94/255>;
#declare CN_Kings_Ransom = rgb <181/255, 157/255, 119/255>;
#declare CN_Kings_Robe = rgb <98/255, 116/255, 171/255>;
#declare CN_Kingdom_Gold = rgb <209/255, 164/255, 54/255>;
#declare CN_Kingdoms_Keys = rgb <233/255, 207/255, 183/255>;
#declare CN_Kingfisher = rgb <58/255, 87/255, 96/255>;
#declare CN_Kingfisher_Blue = rgb <0/255, 100/255, 145/255>;
#declare CN_Kingfisher_Bright = rgb <9/255, 104/255, 114/255>;
#declare CN_Kingfisher_Daisy = rgb <88/255, 53/255, 128/255>;
#declare CN_Kingfisher_Grey = rgb <126/255, 150/255, 159/255>;
#declare CN_Kingfisher_Sheen = rgb <0/255, 127/255, 162/255>;
#declare CN_Kingfisher_Turquoise = rgb <122/255, 182/255, 182/255>;
#declare CN_Kings_Yellow = rgb <234/255, 214/255, 101/255>;
#declare CN_Kingston = rgb <212/255, 220/255, 211/255>;
#declare CN_Kingston_Aqua = rgb <143/255, 188/255, 196/255>;
#declare CN_Kinky_Koala = rgb <187/255, 0/255, 187/255>;
#declare CN_Kinky_Pinky = rgb <238/255, 85/255, 204/255>;
#declare CN_Kinlock = rgb <127/255, 119/255, 147/255>;
#declare CN_Kinsusutake_Brown = rgb <125/255, 78/255, 45/255>;
#declare CN_Kir_Royale_Rose = rgb <180/255, 88/255, 119/255>;
#declare CN_Kirby = rgb <215/255, 72/255, 148/255>;
#declare CN_Kirchner_Green = rgb <92/255, 97/255, 22/255>;
#declare CN_Kiri_Mist = rgb <197/255, 197/255, 211/255>;
#declare CN_Kiriume_Red = rgb <139/255, 53/255, 45/255>;
#declare CN_Kirsch = rgb <178/255, 19/255, 43/255>;
#declare CN_Kirsch_Red = rgb <151/255, 73/255, 83/255>;
#declare CN_Kislev_Flesh = rgb <239/255, 205/255, 203/255>;
#declare CN_Kismet = rgb <161/255, 138/255, 183/255>;
#declare CN_Kiss = rgb <210/255, 140/255, 167/255>;
#declare CN_Kiss_A_Frog = rgb <190/255, 193/255, 135/255>;
#declare CN_Kiss_and_Tell = rgb <216/255, 103/255, 115/255>;
#declare CN_Kiss_Candy = rgb <170/255, 133/255, 74/255>;
#declare CN_Kiss_Good_Night = rgb <229/255, 200/255, 217/255>;
#declare CN_Kiss_Me_Kate = rgb <231/255, 238/255, 236/255>;
#declare CN_Kissable = rgb <253/255, 143/255, 121/255>;
#declare CN_Kissed_by_Mist = rgb <252/255, 204/255, 245/255>;
#declare CN_Kitchen_Blue = rgb <138/255, 181/255, 189/255>;
#declare CN_Kite_Brown = rgb <149/255, 72/255, 63/255>;
#declare CN_Kitsilano_Cookie = rgb <208/255, 200/255, 176/255>;
#declare CN_Kitsurubami_Brown = rgb <187/255, 129/255, 65/255>;
#declare CN_Kittens_Paw = rgb <218/255, 168/255, 155/255>;
#declare CN_Kittiwake_Gull = rgb <204/255, 204/255, 187/255>;
#declare CN_Kiwi = rgb <122/255, 171/255, 85/255>;
#declare CN_Kiwi_Fruit = rgb <157/255, 170/255, 77/255>;
#declare CN_Kiwi_Green = rgb <142/255, 229/255, 63/255>;
#declare CN_Kiwi_Ice_Cream_Green = rgb <229/255, 231/255, 167/255>;
#declare CN_Kiwi_Kiss = rgb <238/255, 249/255, 193/255>;
#declare CN_Kiwi_Pulp = rgb <156/255, 239/255, 67/255>;
#declare CN_Kiwi_Sorbet_Green = rgb <222/255, 232/255, 190/255>;
#declare CN_Kiwi_Squeeze = rgb <209/255, 237/255, 205/255>;
#declare CN_Kiwikiwi_Grey = rgb <144/255, 148/255, 149/255>;
#declare CN_Klimt_Green = rgb <63/255, 162/255, 130/255>;
#declare CN_Knapsack = rgb <149/255, 137/255, 108/255>;
#declare CN_Knarloc_Green = rgb <75/255, 91/255, 64/255>;
#declare CN_Knight_Elf = rgb <146/255, 108/255, 172/255>;
#declare CN_Knight_Rider = rgb <15/255, 7/255, 7/255>;
#declare CN_Knights_Armor = rgb <92/255, 93/255, 93/255>;
#declare CN_Knights_Tale = rgb <170/255, 145/255, 174/255>;
#declare CN_Knighthood = rgb <60/255, 63/255, 82/255>;
#declare CN_Knightley_Straw = rgb <237/255, 204/255, 153/255>;
#declare CN_Knit_Cardigan = rgb <109/255, 108/255, 95/255>;
#declare CN_Knitting_Needles = rgb <195/255, 193/255, 188/255>;
#declare CN_Knock_On_Wood = rgb <159/255, 155/255, 132/255>;
#declare CN_Knockout_Orange = rgb <225/255, 111/255, 62/255>;
#declare CN_Knot = rgb <152/255, 130/255, 102/255>;
#declare CN_Knotweed = rgb <131/255, 127/255, 103/255>;
#declare CN_Koala_Bear = rgb <189/255, 183/255, 163/255>;
#declare CN_Kobai_Red = rgb <219/255, 90/255, 107/255>;
#declare CN_Kobe = rgb <136/255, 45/255, 23/255>;
#declare CN_Kobi = rgb <224/255, 147/255, 171/255>;
#declare CN_Kobicha = rgb <107/255, 68/255, 35/255>;
#declare CN_Kobold_Skin = rgb <240/255, 210/255, 207/255>;
#declare CN_Kobra_Khan = rgb <0/255, 170/255, 34/255>;
#declare CN_Kodama_White = rgb <232/255, 245/255, 252/255>;
#declare CN_Koeksister = rgb <233/255, 117/255, 81/255>;
#declare CN_Kofta_Brown = rgb <136/255, 51/255, 34/255>;
#declare CN_Koefte_Brown = rgb <119/255, 54/255, 68/255>;
#declare CN_Kogane_Gold = rgb <229/255, 179/255, 33/255>;
#declare CN_Kohaku_Amber = rgb <202/255, 105/255, 36/255>;
#declare CN_Kohlrabi_Green = rgb <217/255, 217/255, 177/255>;
#declare CN_Koi = rgb <209/255, 88/255, 55/255>;
#declare CN_Koi_Pond = rgb <121/255, 127/255, 99/255>;
#declare CN_Koji_Orange = rgb <246/255, 173/255, 73/255>;
#declare CN_Koke_Moss = rgb <139/255, 125/255, 58/255>;
#declare CN_Kokiake_Brown = rgb <123/255, 59/255, 58/255>;
#declare CN_Kokimurasaki_Purple = rgb <58/255, 36/255, 59/255>;
#declare CN_Kokoda = rgb <123/255, 120/255, 90/255>;
#declare CN_Kokushoku_Black = rgb <23/255, 20/255, 18/255>;
#declare CN_Kolibri_Blue = rgb <0/255, 71/255, 122/255>;
#declare CN_Komatsuna_Green = rgb <123/255, 141/255, 66/255>;
#declare CN_Kombu = rgb <126/255, 114/255, 109/255>;
#declare CN_Kombu_Green = rgb <58/255, 64/255, 50/255>;
#declare CN_Kombucha = rgb <216/255, 159/255, 102/255>;
#declare CN_Kommando_Khaki = rgb <157/255, 144/255, 126/255>;
#declare CN_Komodo_Dragon = rgb <179/255, 128/255, 82/255>;
#declare CN_Komorebi = rgb <187/255, 197/255, 178/255>;
#declare CN_Kon = rgb <25/255, 34/255, 54/255>;
#declare CN_Kona = rgb <87/255, 75/255, 80/255>;
#declare CN_Konjo_Blue = rgb <0/255, 49/255, 113/255>;
#declare CN_Konkikyo_Blue = rgb <25/255, 31/255, 69/255>;
#declare CN_Koopa_Green_Shell = rgb <88/255, 216/255, 84/255>;
#declare CN_Kopi_Luwak = rgb <131/255, 61/255, 62/255>;
#declare CN_Korainando_Green = rgb <32/255, 56/255, 56/255>;
#declare CN_Koral_Kicks = rgb <242/255, 209/255, 195/255>;
#declare CN_Korean_Mint = rgb <93/255, 125/255, 97/255>;
#declare CN_Korichnewyi_Brown = rgb <141/255, 69/255, 18/255>;
#declare CN_Korila = rgb <215/255, 233/255, 200/255>;
#declare CN_Korma = rgb <128/255, 78/255, 44/255>;
#declare CN_Koromiko = rgb <254/255, 181/255, 82/255>;
#declare CN_Korozen = rgb <89/255, 43/255, 31/255>;
#declare CN_Kosher_Khaki = rgb <136/255, 136/255, 119/255>;
#declare CN_Kournikova = rgb <249/255, 208/255, 84/255>;
#declare CN_Kowhai_Yellow = rgb <225/255, 176/255, 41/255>;
#declare CN_Kowloon = rgb <225/255, 217/255, 86/255>;
#declare CN_Kraft_Paper = rgb <213/255, 181/255, 156/255>;
#declare CN_Krasnyi_Red = rgb <235/255, 46/255, 40/255>;
#declare CN_Kremlin_Red = rgb <99/255, 54/255, 57/255>;
#declare CN_Krieg_Khaki = rgb <192/255, 189/255, 129/255>;
#declare CN_Krishna_Blue = rgb <1/255, 171/255, 253/255>;
#declare CN_Krypton = rgb <184/255, 192/255, 195/255>;
#declare CN_KSU_Purple = rgb <81/255, 40/255, 136/255>;
#declare CN_KU_Crimson = rgb <232/255, 0/255, 13/255>;
#declare CN_Kuchinashi_Yellow = rgb <255/255, 219/255, 79/255>;
#declare CN_Kul_Sharif_Blue = rgb <135/255, 211/255, 248/255>;
#declare CN_Kumera = rgb <136/255, 98/255, 33/255>;
#declare CN_Kumquat = rgb <251/255, 170/255, 76/255>;
#declare CN_Kundalini_Bliss = rgb <210/255, 204/255, 218/255>;
#declare CN_Kung_Fu = rgb <100/255, 59/255, 66/255>;
#declare CN_Kurenai_Red = rgb <215/255, 0/255, 58/255>;
#declare CN_Kuretake_Black_Manga = rgb <0/255, 17/255, 34/255>;
#declare CN_Kuri_Black = rgb <85/255, 71/255, 56/255>;
#declare CN_Kuro_Brown = rgb <88/255, 56/255, 34/255>;
#declare CN_Kuro_Green = rgb <27/255, 43/255, 27/255>;
#declare CN_Kurobeni = rgb <35/255, 25/255, 30/255>;
#declare CN_Kuroi_Black = rgb <20/255, 21/255, 29/255>;
#declare CN_Kurumizome_Brown = rgb <159/255, 116/255, 98/255>;
#declare CN_Kuta_Surf = rgb <87/255, 137/255, 165/255>;
#declare CN_Kuwanomi_Purple = rgb <85/255, 41/255, 91/255>;
#declare CN_Kuwazome_Red = rgb <89/255, 41/255, 44/255>;
#declare CN_Kvass = rgb <199/255, 97/255, 15/255>;
#declare CN_Kyo_Purple = rgb <157/255, 91/255, 139/255>;
#declare CN_Kyoto = rgb <190/255, 227/255, 234/255>;
#declare CN_Kyoto_House = rgb <80/255, 48/255, 0/255>;
#declare CN_Kyoto_Pearl = rgb <223/255, 214/255, 209/255>;
#declare CN_Kyuri_Green = rgb <75/255, 93/255, 22/255>;
#declare CN_La_Grange = rgb <122/255, 122/255, 96/255>;
#declare CN_La_Jiao_Hong_Red = rgb <252/255, 38/255, 71/255>;
#declare CN_La_Luna = rgb <255/255, 255/255, 229/255>;
#declare CN_La_Luna_Amarilla = rgb <253/255, 223/255, 160/255>;
#declare CN_La_Minute = rgb <245/255, 229/255, 220/255>;
#declare CN_La_Palma = rgb <66/255, 137/255, 41/255>;
#declare CN_La_Paz_Siesta = rgb <193/255, 229/255, 234/255>;
#declare CN_La_Pineta = rgb <87/255, 126/255, 136/255>;
#declare CN_La_Rioja = rgb <186/255, 192/255, 14/255>;
#declare CN_La_Salle_Green = rgb <8/255, 120/255, 48/255>;
#declare CN_La_Terra = rgb <234/255, 147/255, 110/255>;
#declare CN_LA_Vibes = rgb <238/255, 204/255, 221/255>;
#declare CN_La_Vie_en_Rose = rgb <210/255, 165/255, 163/255>;
#declare CN_La_De_Dah = rgb <195/255, 177/255, 190/255>;
#declare CN_Labrador = rgb <242/255, 236/255, 217/255>;
#declare CN_Labradorite = rgb <101/255, 123/255, 131/255>;
#declare CN_Labradorite_Green = rgb <84/255, 125/255, 128/255>;
#declare CN_Labyrinth_Walk = rgb <201/255, 164/255, 135/255>;
#declare CN_Lace_Cap = rgb <235/255, 234/255, 237/255>;
#declare CN_Lace_Veil = rgb <236/255, 235/255, 234/255>;
#declare CN_Lace_Wisteria = rgb <194/255, 187/255, 192/255>;
#declare CN_Laced_Green = rgb <204/255, 238/255, 153/255>;
#declare CN_Lacewing = rgb <215/255, 227/255, 202/255>;
#declare CN_Lacey = rgb <202/255, 174/255, 171/255>;
#declare CN_Lacquer_Green = rgb <27/255, 50/255, 44/255>;
#declare CN_Lacquer_Mauve = rgb <240/255, 207/255, 225/255>;
#declare CN_Lacquered_Licorice = rgb <56/255, 56/255, 56/255>;
#declare CN_Lacrosse = rgb <46/255, 92/255, 88/255>;
#declare CN_Lacustral = rgb <25/255, 80/255, 76/255>;
#declare CN_Lacy_Mist = rgb <167/255, 132/255, 144/255>;
#declare CN_Laddu_Orange = rgb <255/255, 142/255, 19/255>;
#declare CN_Ladoga_Bottom = rgb <217/255, 222/255, 216/255>;
#declare CN_Lady_Anne = rgb <253/255, 226/255, 222/255>;
#declare CN_Lady_Banksia = rgb <253/255, 229/255, 167/255>;
#declare CN_Lady_Fern = rgb <143/255, 161/255, 116/255>;
#declare CN_Lady_Fingers = rgb <204/255, 187/255, 192/255>;
#declare CN_Lady_Flower = rgb <208/255, 164/255, 174/255>;
#declare CN_Lady_Guinevere = rgb <202/255, 160/255, 158/255>;
#declare CN_Lady_in_Red = rgb <179/255, 75/255, 71/255>;
#declare CN_Lady_Luck = rgb <71/255, 97/255, 60/255>;
#declare CN_Lady_Nicole = rgb <214/255, 214/255, 205/255>;
#declare CN_Lady_of_the_Sea = rgb <0/255, 0/255, 204/255>;
#declare CN_Lady_Pink = rgb <243/255, 210/255, 207/255>;
#declare CN_Lady_S_Cushions_Pink = rgb <201/255, 155/255, 176/255>;
#declare CN_Ladys_Slipper = rgb <227/255, 227/255, 234/255>;
#declare CN_Ladylike = rgb <255/255, 195/255, 191/255>;
#declare CN_Lager = rgb <246/255, 245/255, 19/255>;
#declare CN_Lagoon = rgb <77/255, 158/255, 154/255>;
#declare CN_Lagoon_Blue = rgb <128/255, 164/255, 177/255>;
#declare CN_Lagoon_Mirror = rgb <234/255, 237/255, 238/255>;
#declare CN_Lagoon_Moss = rgb <139/255, 126/255, 100/255>;
#declare CN_Lagoon_Rock = rgb <67/255, 188/255, 190/255>;
#declare CN_Lagoona_Teal = rgb <118/255, 198/255, 211/255>;
#declare CN_Laguna_Beach = rgb <233/255, 215/255, 192/255>;
#declare CN_Laguna_Blue = rgb <90/255, 116/255, 144/255>;
#declare CN_Lahar = rgb <95/255, 88/255, 85/255>;
#declare CN_Lahmian_Medium = rgb <226/255, 218/255, 209/255>;
#declare CN_Lahn_Yellow = rgb <255/255, 248/255, 10/255>;
#declare CN_Laid_Back_Grey = rgb <179/255, 175/255, 167/255>;
#declare CN_Laird = rgb <121/255, 133/255, 60/255>;
#declare CN_Lake_Baikal = rgb <21/255, 80/255, 132/255>;
#declare CN_Lake_Blue = rgb <0/255, 140/255, 150/255>;
#declare CN_Lake_Green = rgb <46/255, 139/255, 87/255>;
#declare CN_Lake_Lucerne = rgb <104/255, 157/255, 183/255>;
#declare CN_Lake_Placid = rgb <174/255, 185/255, 188/255>;
#declare CN_Lake_Red = rgb <183/255, 74/255, 112/255>;
#declare CN_Lake_Reflection = rgb <157/255, 216/255, 219/255>;
#declare CN_Lake_Retba_Pink = rgb <238/255, 85/255, 238/255>;
#declare CN_Lake_Stream = rgb <62/255, 107/255, 131/255>;
#declare CN_Lake_Tahoe_Turquoise = rgb <52/255, 177/255, 178/255>;
#declare CN_Lake_Thun = rgb <68/255, 187/255, 221/255>;
#declare CN_Lake_View = rgb <46/255, 73/255, 103/255>;
#declare CN_Lake_Water = rgb <134/255, 171/255, 165/255>;
#declare CN_Lake_Winnipeg = rgb <128/255, 161/255, 176/255>;
#declare CN_Lakelike = rgb <48/255, 111/255, 115/255>;
#declare CN_Lakeshore = rgb <91/255, 150/255, 162/255>;
#declare CN_Lakeside = rgb <173/255, 184/255, 192/255>;
#declare CN_Lakeside_Mist = rgb <215/255, 238/255, 239/255>;
#declare CN_Lakeside_Pine = rgb <86/255, 101/255, 82/255>;
#declare CN_Lakeview = rgb <129/255, 154/255, 160/255>;
#declare CN_Lakeville = rgb <108/255, 132/255, 155/255>;
#declare CN_Laksa = rgb <230/255, 191/255, 149/255>;
#declare CN_Lal_Red = rgb <216/255, 85/255, 37/255>;
#declare CN_Lama = rgb <224/255, 187/255, 149/255>;
#declare CN_Lamb_Chop = rgb <130/255, 80/255, 44/255>;
#declare CN_Lambs_Ears = rgb <200/255, 204/255, 188/255>;
#declare CN_Lambs_Wool = rgb <255/255, 255/255, 227/255>;
#declare CN_Lambent_Lagoon = rgb <59/255, 91/255, 146/255>;
#declare CN_Lambs_Wool = rgb <230/255, 209/255, 178/255>;
#declare CN_Lambskin = rgb <235/255, 220/255, 202/255>;
#declare CN_Lamenters_Yellow = rgb <255/255, 254/255, 182/255>;
#declare CN_Lamina = rgb <187/255, 217/255, 188/255>;
#declare CN_Laminated_Wood = rgb <148/255, 140/255, 126/255>;
#declare CN_Lamp_Post = rgb <74/255, 79/255, 85/255>;
#declare CN_Lamplit = rgb <228/255, 175/255, 101/255>;
#declare CN_Lampoon = rgb <128/255, 85/255, 87/255>;
#declare CN_Lan_Se_Blue = rgb <77/255, 77/255, 255/255>;
#declare CN_Land_Before_Time = rgb <191/255, 190/255, 173/255>;
#declare CN_Land_Light = rgb <223/255, 202/255, 170/255>;
#declare CN_Land_of_Trees = rgb <224/255, 213/255, 185/255>;
#declare CN_Land_Rush_Bone = rgb <201/255, 187/255, 161/255>;
#declare CN_Landing = rgb <238/255, 225/255, 217/255>;
#declare CN_Landjaeger = rgb <175/255, 64/255, 60/255>;
#declare CN_Landmark = rgb <116/255, 104/255, 84/255>;
#declare CN_Landmark_Brown = rgb <117/255, 102/255, 87/255>;
#declare CN_Langdon_Dove = rgb <181/255, 171/255, 154/255>;
#declare CN_Langoustine = rgb <220/255, 82/255, 38/255>;
#declare CN_Langoustino = rgb <202/255, 108/255, 86/255>;
#declare CN_Languid_Blue = rgb <164/255, 183/255, 189/255>;
#declare CN_Languid_Lavender = rgb <214/255, 202/255, 221/255>;
#declare CN_Lannister_Red = rgb <205/255, 1/255, 1/255>;
#declare CN_Lantana = rgb <218/255, 126/255, 122/255>;
#declare CN_Lantana_Lime = rgb <215/255, 236/255, 205/255>;
#declare CN_Lantern_Light = rgb <246/255, 235/255, 185/255>;
#declare CN_Lanyard = rgb <192/255, 153/255, 114/255>;
#declare CN_Lap_Dog = rgb <166/255, 146/255, 127/255>;
#declare CN_Lap_of_Luxury = rgb <81/255, 83/255, 102/255>;
#declare CN_Lap_Pool_Blue = rgb <152/255, 187/255, 183/255>;
#declare CN_Lapis_Blue = rgb <0/255, 75/255, 141/255>;
#declare CN_Lapis_Jewel = rgb <22/255, 93/255, 149/255>;
#declare CN_Lapis_Lazuli = rgb <38/255, 97/255, 156/255>;
#declare CN_Lapis_Lazuli_Blue = rgb <33/255, 95/255, 150/255>;
#declare CN_Lapwing_Grey_Green = rgb <122/255, 117/255, 98/255>;
#declare CN_Larb_Gai = rgb <223/255, 198/255, 170/255>;
#declare CN_Larch_Bolete = rgb <255/255, 170/255, 119/255>;
#declare CN_Larchmere = rgb <112/255, 186/255, 167/255>;
#declare CN_Laredo_Road = rgb <199/255, 153/255, 79/255>;
#declare CN_Large_Wild_Convolvulus = rgb <228/255, 226/255, 214/255>;
#declare CN_Largest_Black_Slug = rgb <85/255, 31/255, 47/255>;
#declare CN_Larimar_Blue = rgb <29/255, 120/255, 171/255>;
#declare CN_Larimar_Green = rgb <147/255, 211/255, 188/255>;
#declare CN_Lark = rgb <184/255, 155/255, 114/255>;
#declare CN_Lark_Green = rgb <138/255, 193/255, 161/255>;
#declare CN_Larkspur = rgb <60/255, 125/255, 144/255>;
#declare CN_Larkspur_Blue = rgb <32/255, 174/255, 177/255>;
#declare CN_Larkspur_Bouquet = rgb <121/255, 139/255, 189/255>;
#declare CN_Larkspur_Bud = rgb <183/255, 192/255, 234/255>;
#declare CN_Larkspur_Violet = rgb <146/255, 138/255, 174/255>;
#declare CN_Las_Palmas = rgb <198/255, 218/255, 54/255>;
#declare CN_Laser = rgb <198/255, 169/255, 94/255>;
#declare CN_Laser_Lemon = rgb <255/255, 255/255, 102/255>;
#declare CN_Last_Light_Blue = rgb <71/255, 95/255, 148/255>;
#declare CN_Last_of_Lettuce = rgb <170/255, 221/255, 102/255>;
#declare CN_Last_Straw = rgb <227/255, 219/255, 205/255>;
#declare CN_Last_Warning = rgb <211/255, 15/255, 63/255>;
#declare CN_Lasting_Impression = rgb <179/255, 102/255, 99/255>;
#declare CN_Lasting_Lime = rgb <136/255, 255/255, 0/255>;
#declare CN_Lasting_Thoughts = rgb <212/255, 230/255, 177/255>;
#declare CN_Later_Gator = rgb <0/255, 138/255, 81/255>;
#declare CN_Latigo_Bay = rgb <55/255, 145/255, 144/255>;
#declare CN_Latin_Charm = rgb <41/255, 46/255, 68/255>;
#declare CN_Latte = rgb <197/255, 165/255, 130/255>;
#declare CN_Latte_Froth = rgb <243/255, 240/255, 232/255>;
#declare CN_Lattice = rgb <206/255, 206/255, 198/255>;
#declare CN_Lattice_Work = rgb <185/255, 225/255, 194/255>;
#declare CN_Laudable_Lime = rgb <140/255, 191/255, 111/255>;
#declare CN_Laughing_Jack = rgb <201/255, 195/255, 210/255>;
#declare CN_Laughing_Orange = rgb <244/255, 152/255, 7/255>;
#declare CN_Launderette_Blue = rgb <192/255, 231/255, 235/255>;
#declare CN_Laundry_Blue = rgb <162/255, 173/255, 179/255>;
#declare CN_Laundry_White = rgb <246/255, 247/255, 241/255>;
#declare CN_Laura = rgb <166/255, 151/255, 154/255>;
#declare CN_Laura_Potato = rgb <128/255, 0/255, 8/255>;
#declare CN_Laurel = rgb <110/255, 141/255, 113/255>;
#declare CN_Laurel_Garland = rgb <104/255, 112/255, 92/255>;
#declare CN_Laurel_Green = rgb <169/255, 186/255, 157/255>;
#declare CN_Laurel_Grey = rgb <170/255, 172/255, 162/255>;
#declare CN_Laurel_Leaf = rgb <150/255, 155/255, 139/255>;
#declare CN_Laurel_Mist = rgb <172/255, 181/255, 161/255>;
#declare CN_Laurel_Nut_Brown = rgb <85/255, 64/255, 62/255>;
#declare CN_Laurel_Oak = rgb <145/255, 140/255, 126/255>;
#declare CN_Laurel_Pink = rgb <247/255, 225/255, 220/255>;
#declare CN_Laurel_Tree = rgb <136/255, 151/255, 121/255>;
#declare CN_Laurel_Woods = rgb <68/255, 73/255, 61/255>;
#declare CN_Laurel_Wreath = rgb <82/255, 167/255, 134/255>;
#declare CN_Laurens_Lace = rgb <239/255, 234/255, 231/255>;
#declare CN_Laurens_Surprise = rgb <213/255, 229/255, 231/255>;
#declare CN_Lauriston_Stone = rgb <134/255, 129/255, 114/255>;
#declare CN_Lava = rgb <207/255, 16/255, 32/255>;
#declare CN_Lava_Black = rgb <53/255, 47/255, 54/255>;
#declare CN_Lava_Core = rgb <118/255, 64/255, 49/255>;
#declare CN_Lava_Geyser = rgb <219/255, 208/255, 206/255>;
#declare CN_Lava_Grey = rgb <94/255, 104/255, 109/255>;
#declare CN_Lava_Lamp = rgb <235/255, 113/255, 53/255>;
#declare CN_Lava_Pit = rgb <228/255, 111/255, 52/255>;
#declare CN_Lava_Stone = rgb <60/255, 65/255, 81/255>;
#declare CN_Lavenbrun = rgb <175/255, 152/255, 148/255>;
#declare CN_Lavendaire = rgb <143/255, 129/255, 139/255>;
#declare CN_Lavendar_Wisp = rgb <233/255, 235/255, 238/255>;
#declare CN_Lavender = rgb <181/255, 110/255, 220/255>;
#declare CN_Lavender_Ash = rgb <153/255, 152/255, 167/255>;
#declare CN_Lavender_Aura = rgb <159/255, 153/255, 170/255>;
#declare CN_Lavender_Bikini = rgb <229/255, 217/255, 218/255>;
#declare CN_Lavender_Blessing = rgb <211/255, 184/255, 197/255>;
#declare CN_Lavender_Bliss = rgb <206/255, 195/255, 221/255>;
#declare CN_Lavender_Blossom = rgb <181/255, 126/255, 220/255>;
#declare CN_Lavender_Blossom_Grey = rgb <140/255, 141/255, 161/255>;
#declare CN_Lavender_Blue = rgb <204/255, 204/255, 255/255>;
#declare CN_Lavender_Blue_Shadow = rgb <139/255, 136/255, 248/255>;
#declare CN_Lavender_Blush = rgb <255/255, 240/255, 245/255>;
#declare CN_Lavender_Bonnet = rgb <153/255, 148/255, 192/255>;
#declare CN_Lavender_Bouquet = rgb <199/255, 194/255, 208/255>;
#declare CN_Lavender_Breeze = rgb <228/255, 225/255, 227/255>;
#declare CN_Lavender_Candy = rgb <252/255, 180/255, 213/255>;
#declare CN_Lavender_Cloud = rgb <184/255, 171/255, 177/255>;
#declare CN_Lavender_Cream = rgb <199/255, 159/255, 239/255>;
#declare CN_Lavender_Crystal = rgb <147/255, 106/255, 152/255>;
#declare CN_Lavender_Dream = rgb <180/255, 174/255, 204/255>;
#declare CN_Lavender_Dust = rgb <196/255, 195/255, 208/255>;
#declare CN_Lavender_Earl = rgb <175/255, 146/255, 189/255>;
#declare CN_Lavender_Elan = rgb <157/255, 147/255, 153/255>;
#declare CN_Lavender_Elegance = rgb <120/255, 108/255, 117/255>;
#declare CN_Lavender_Essence = rgb <223/255, 218/255, 217/255>;
#declare CN_Lavender_Fog = rgb <210/255, 196/255, 214/255>;
#declare CN_Lavender_Fragrance = rgb <221/255, 187/255, 255/255>;
#declare CN_Lavender_Frost = rgb <189/255, 171/255, 190/255>;
#declare CN_Lavender_Grey = rgb <189/255, 187/255, 215/255>;
#declare CN_Lavender_Haze = rgb <211/255, 208/255, 221/255>;
#declare CN_Lavender_Herb = rgb <177/255, 142/255, 170/255>;
#declare CN_Lavender_Honor = rgb <192/255, 194/255, 210/255>;
#declare CN_Lavender_Illusion = rgb <169/255, 155/255, 167/255>;
#declare CN_Lavender_Indigo = rgb <148/255, 87/255, 235/255>;
#declare CN_Lavender_Lace = rgb <223/255, 221/255, 224/255>;
#declare CN_Lavender_Lake = rgb <161/255, 152/255, 162/255>;
#declare CN_Lavender_Leaf_Green = rgb <140/255, 145/255, 128/255>;
#declare CN_Lavender_Lily = rgb <165/255, 150/255, 156/255>;
#declare CN_Lavender_Lustre = rgb <140/255, 156/255, 193/255>;
#declare CN_Lavender_Magenta = rgb <238/255, 130/255, 237/255>;
#declare CN_Lavender_Mauve = rgb <104/255, 118/255, 152/255>;
#declare CN_Lavender_Memory = rgb <211/255, 211/255, 226/255>;
#declare CN_Lavender_Mist = rgb <229/255, 229/255, 250/255>;
#declare CN_Lavender_Mosaic = rgb <133/255, 126/255, 134/255>;
#declare CN_Lavender_Oil = rgb <192/255, 192/255, 202/255>;
#declare CN_Lavender_Pearl = rgb <237/255, 229/255, 232/255>;
#declare CN_Lavender_Phlox = rgb <166/255, 186/255, 223/255>;
#declare CN_Lavender_Pillow = rgb <197/255, 185/255, 211/255>;
#declare CN_Lavender_Pink = rgb <221/255, 133/255, 215/255>;
#declare CN_Lavender_Pizzazz = rgb <233/255, 226/255, 229/255>;
#declare CN_Lavender_Princess = rgb <233/255, 210/255, 239/255>;
#declare CN_Lavender_Purple = rgb <150/255, 123/255, 182/255>;
#declare CN_Lavender_Quartz = rgb <189/255, 136/255, 171/255>;
#declare CN_Lavender_Rose = rgb <251/255, 160/255, 227/255>;
#declare CN_Lavender_Sachet = rgb <190/255, 194/255, 218/255>;
#declare CN_Lavender_Savor = rgb <238/255, 221/255, 255/255>;
#declare CN_Lavender_Scent = rgb <191/255, 172/255, 177/255>;
#declare CN_Lavender_Sky = rgb <219/255, 215/255, 242/255>;
#declare CN_Lavender_Soap = rgb <241/255, 191/255, 226/255>;
#declare CN_Lavender_Sparkle = rgb <207/255, 206/255, 220/255>;
#declare CN_Lavender_Spectacle = rgb <147/255, 146/255, 173/255>;
#declare CN_Lavender_Steel = rgb <198/255, 203/255, 219/255>;
#declare CN_Lavender_Suede = rgb <180/255, 165/255, 160/255>;
#declare CN_Lavender_Sweater = rgb <189/255, 131/255, 190/255>;
#declare CN_Lavender_Syrup = rgb <230/255, 230/255, 241/255>;
#declare CN_Lavender_Tea = rgb <215/255, 131/255, 255/255>;
#declare CN_Lavender_Tonic = rgb <204/255, 187/255, 255/255>;
#declare CN_Lavender_Twilight = rgb <231/255, 223/255, 227/255>;
#declare CN_Lavender_Veil = rgb <217/255, 187/255, 211/255>;
#declare CN_Lavender_Violet = rgb <118/255, 123/255, 165/255>;
#declare CN_Lavender_Vista = rgb <227/255, 215/255, 229/255>;
#declare CN_Lavender_Wash = rgb <170/255, 176/255, 212/255>;
#declare CN_Lavender_Water = rgb <210/255, 201/255, 223/255>;
#declare CN_Lavendula = rgb <188/255, 164/255, 203/255>;
#declare CN_Lavish_Gold = rgb <163/255, 129/255, 84/255>;
#declare CN_Lavish_Lavender = rgb <194/255, 174/255, 195/255>;
#declare CN_Lavish_Lemon = rgb <249/255, 239/255, 202/255>;
#declare CN_Lavish_Lime = rgb <176/255, 193/255, 117/255>;
#declare CN_Lavish_Spending = rgb <132/255, 105/255, 188/255>;
#declare CN_Lawn_Green = rgb <77/255, 164/255, 9/255>;
#declare CN_Lawn_Party = rgb <94/255, 181/255, 106/255>;
#declare CN_Layers_of_Ocean = rgb <92/255, 113/255, 134/255>;
#declare CN_Laylock = rgb <171/255, 155/255, 165/255>;
#declare CN_Lazurite_Blue = rgb <23/255, 76/255, 96/255>;
#declare CN_Lazy_Afternoon = rgb <151/255, 146/255, 139/255>;
#declare CN_Lazy_Caterpillar = rgb <226/255, 229/255, 199/255>;
#declare CN_Lazy_Daisy = rgb <246/255, 235/255, 161/255>;
#declare CN_Lazy_Day = rgb <149/255, 174/255, 209/255>;
#declare CN_Lazy_Gray = rgb <190/255, 193/255, 195/255>;
#declare CN_Lazy_Lavender = rgb <163/255, 160/255, 179/255>;
#declare CN_Lazy_Lichen = rgb <110/255, 110/255, 92/255>;
#declare CN_Lazy_Lizard = rgb <156/255, 156/255, 75/255>;
#declare CN_Lazy_Shell_Red = rgb <204/255, 0/255, 17/255>;
#declare CN_Lazy_Summer_Day = rgb <254/255, 243/255, 195/255>;
#declare CN_Lazy_Sunday = rgb <202/255, 211/255, 231/255>;
#declare CN_Le_Corbusier_Crush = rgb <191/255, 78/255, 70/255>;
#declare CN_Le_Luxe = rgb <94/255, 104/255, 105/255>;
#declare CN_Le_Max = rgb <133/255, 178/255, 161/255>;
#declare CN_Lead = rgb <33/255, 33/255, 33/255>;
#declare CN_Lead_Cast = rgb <108/255, 128/255, 156/255>;
#declare CN_Lead_Glass = rgb <255/255, 250/255, 229/255>;
#declare CN_Lead_Grey = rgb <138/255, 121/255, 99/255>;
#declare CN_Lead_Ore = rgb <153/255, 170/255, 187/255>;
#declare CN_Leadbelcher = rgb <202/255, 202/255, 203/255>;
#declare CN_Leadbelcher_Metal = rgb <136/255, 141/255, 143/255>;
#declare CN_Leaf = rgb <113/255, 170/255, 52/255>;
#declare CN_Leaf_Bud = rgb <239/255, 241/255, 157/255>;
#declare CN_Leaf_Green = rgb <92/255, 169/255, 4/255>;
#declare CN_Leaf_Print = rgb <225/255, 211/255, 142/255>;
#declare CN_Leaf_Tea = rgb <105/255, 125/255, 76/255>;
#declare CN_Leaf_Yellow = rgb <233/255, 215/255, 158/255>;
#declare CN_Leaflet = rgb <139/255, 152/255, 123/255>;
#declare CN_Leafy = rgb <103/255, 155/255, 106/255>;
#declare CN_Leafy_Lemon = rgb <192/255, 240/255, 0/255>;
#declare CN_Leafy_Seadragon = rgb <182/255, 196/255, 6/255>;
#declare CN_Leamington_Spa = rgb <160/255, 183/255, 168/255>;
#declare CN_Leap_of_Faith = rgb <196/255, 211/255, 227/255>;
#declare CN_Leapfrog = rgb <65/255, 169/255, 79/255>;
#declare CN_Leather = rgb <144/255, 106/255, 84/255>;
#declare CN_Leather_Bound = rgb <145/255, 110/255, 82/255>;
#declare CN_Leather_Brown = rgb <151/255, 87/255, 43/255>;
#declare CN_Leather_Chair = rgb <163/255, 117/255, 76/255>;
#declare CN_Leather_Clutch = rgb <116/255, 78/255, 66/255>;
#declare CN_Leather_Loafers = rgb <134/255, 115/255, 84/255>;
#declare CN_Leather_Satchel = rgb <124/255, 79/255, 58/255>;
#declare CN_Leather_Tan = rgb <164/255, 132/255, 84/255>;
#declare CN_Leather_Work = rgb <138/255, 99/255, 71/255>;
#declare CN_Leaves_of_Spring = rgb <197/255, 230/255, 204/255>;
#declare CN_Lebanon_Cedar = rgb <60/255, 52/255, 31/255>;
#declare CN_LeChucks_Beard = rgb <60/255, 53/255, 31/255>;
#declare CN_LED_Blue = rgb <0/255, 102/255, 163/255>;
#declare CN_LED_Green = rgb <216/255, 203/255, 50/255>;
#declare CN_Leek = rgb <152/255, 217/255, 142/255>;
#declare CN_Leek_Blossom_Pink = rgb <188/255, 163/255, 184/255>;
#declare CN_Leek_Green = rgb <151/255, 156/255, 132/255>;
#declare CN_Leek_Powder = rgb <183/255, 177/255, 122/255>;
#declare CN_Leek_Soup = rgb <122/255, 156/255, 88/255>;
#declare CN_Leek_White = rgb <206/255, 220/255, 202/255>;
#declare CN_Leery_Lemon = rgb <245/255, 199/255, 26/255>;
#declare CN_Legacy = rgb <94/255, 90/255, 103/255>;
#declare CN_Legal_Eagle = rgb <109/255, 117/255, 143/255>;
#declare CN_Legal_Ribbon = rgb <111/255, 67/255, 74/255>;
#declare CN_Legendary = rgb <198/255, 186/255, 175/255>;
#declare CN_Legendary_Grey = rgb <120/255, 121/255, 118/255>;
#declare CN_Legendary_Lilac = rgb <173/255, 150/255, 157/255>;
#declare CN_Legendary_Purple = rgb <78/255, 78/255, 99/255>;
#declare CN_Legendary_Sword = rgb <127/255, 131/255, 132/255>;
#declare CN_Legion_Blue = rgb <31/255, 73/255, 91/255>;
#declare CN_Lei_Flower = rgb <216/255, 123/255, 106/255>;
#declare CN_Leisure = rgb <193/255, 150/255, 52/255>;
#declare CN_Leisure_Blue = rgb <106/255, 142/255, 161/255>;
#declare CN_Leisure_Green = rgb <67/255, 130/255, 97/255>;
#declare CN_Leisure_Time = rgb <117/255, 140/255, 143/255>;
#declare CN_Lemon = rgb <255/255, 247/255, 0/255>;
#declare CN_Lemon_Appeal = rgb <239/255, 228/255, 174/255>;
#declare CN_Lemon_Balm = rgb <229/255, 217/255, 182/255>;
#declare CN_Lemon_Balm_Green = rgb <0/255, 82/255, 40/255>;
#declare CN_Lemon_Bar = rgb <206/255, 160/255, 47/255>;
#declare CN_Lemon_Blast = rgb <252/255, 236/255, 173/255>;
#declare CN_Lemon_Bubble = rgb <252/255, 235/255, 191/255>;
#declare CN_Lemon_Bundt_Cake = rgb <254/255, 245/255, 159/255>;
#declare CN_Lemon_Burst = rgb <254/255, 214/255, 126/255>;
#declare CN_Lemon_Caipirinha = rgb <247/255, 222/255, 157/255>;
#declare CN_Lemon_Candy = rgb <250/255, 232/255, 171/255>;
#declare CN_Lemon_Chiffon = rgb <255/255, 250/255, 205/255>;
#declare CN_Lemon_Chiffon_Pie = rgb <255/255, 247/255, 196/255>;
#declare CN_Lemon_Chrome = rgb <255/255, 195/255, 0/255>;
#declare CN_Lemon_Cream = rgb <254/255, 225/255, 147/255>;
#declare CN_Lemon_Curd = rgb <255/255, 238/255, 17/255>;
#declare CN_Lemon_Curry = rgb <205/255, 163/255, 35/255>;
#declare CN_Lemon_Delicious = rgb <252/255, 230/255, 153/255>;
#declare CN_Lemon_Dream = rgb <238/255, 163/255, 0/255>;
#declare CN_Lemon_Drizzle = rgb <254/255, 228/255, 131/255>;
#declare CN_Lemon_Drop = rgb <253/255, 216/255, 120/255>;
#declare CN_Lemon_Drops = rgb <255/255, 228/255, 157/255>;
#declare CN_Lemon_Essence = rgb <226/255, 174/255, 77/255>;
#declare CN_Lemon_Filling = rgb <249/255, 228/255, 166/255>;
#declare CN_Lemon_Flesh = rgb <240/255, 232/255, 145/255>;
#declare CN_Lemon_Gate = rgb <150/255, 251/255, 196/255>;
#declare CN_Lemon_Gelato = rgb <248/255, 236/255, 158/255>;
#declare CN_Lemon_Ginger = rgb <150/255, 132/255, 40/255>;
#declare CN_Lemon_Glacier = rgb <253/255, 255/255, 0/255>;
#declare CN_Lemon_Grass = rgb <153/255, 154/255, 134/255>;
#declare CN_Lemon_Green = rgb <173/255, 248/255, 2/255>;
#declare CN_Lemon_Ice = rgb <255/255, 254/255, 230/255>;
#declare CN_Lemon_Ice_Yellow = rgb <246/255, 226/255, 167/255>;
#declare CN_Lemon_Icing = rgb <246/255, 235/255, 200/255>;
#declare CN_Lemon_Juice = rgb <255/255, 255/255, 236/255>;
#declare CN_Lemon_Lily = rgb <250/255, 244/255, 217/255>;
#declare CN_Lemon_Lime = rgb <191/255, 254/255, 40/255>;
#declare CN_Lemon_Lime_Mojito = rgb <203/255, 186/255, 97/255>;
#declare CN_Lemon_Meringue = rgb <246/255, 225/255, 153/255>;
#declare CN_Lemon_Pearl = rgb <249/255, 241/255, 219/255>;
#declare CN_Lemon_Peel = rgb <255/255, 237/255, 128/255>;
#declare CN_Lemon_Pepper = rgb <235/255, 236/255, 167/255>;
#declare CN_Lemon_Pie = rgb <241/255, 255/255, 98/255>;
#declare CN_Lemon_Poppy = rgb <225/255, 174/255, 88/255>;
#declare CN_Lemon_Popsicle = rgb <250/255, 242/255, 209/255>;
#declare CN_Lemon_Pound_Cake = rgb <255/255, 221/255, 147/255>;
#declare CN_Lemon_Punch = rgb <254/255, 207/255, 36/255>;
#declare CN_Lemon_Rose = rgb <251/255, 233/255, 172/255>;
#declare CN_Lemon_Sachet = rgb <250/255, 240/255, 207/255>;
#declare CN_Lemon_Sherbet = rgb <241/255, 255/255, 168/255>;
#declare CN_Lemon_Slice = rgb <255/255, 251/255, 168/255>;
#declare CN_Lemon_Soap = rgb <255/255, 252/255, 196/255>;
#declare CN_Lemon_Sorbet = rgb <255/255, 250/255, 192/255>;
#declare CN_Lemon_Sorbet_Yellow = rgb <220/255, 198/255, 142/255>;
#declare CN_Lemon_Souffle = rgb <255/255, 232/255, 173/255>;
#declare CN_Lemon_Splash = rgb <249/255, 246/255, 222/255>;
#declare CN_Lemon_Sponge_Cake = rgb <247/255, 240/255, 225/255>;
#declare CN_Lemon_Stick = rgb <251/255, 247/255, 224/255>;
#declare CN_Lemon_Sugar = rgb <240/255, 246/255, 221/255>;
#declare CN_Lemon_Surprise = rgb <225/255, 188/255, 92/255>;
#declare CN_Lemon_Tart = rgb <255/255, 221/255, 102/255>;
#declare CN_Lemon_Tint = rgb <252/255, 243/255, 203/255>;
#declare CN_Lemon_Twist = rgb <254/255, 217/255, 93/255>;
#declare CN_Lemon_Verbena = rgb <243/255, 231/255, 121/255>;
#declare CN_Lemon_Whip = rgb <255/255, 230/255, 186/255>;
#declare CN_Lemon_Whisper = rgb <255/255, 177/255, 13/255>;
#declare CN_Lemon_White = rgb <251/255, 246/255, 224/255>;
#declare CN_Lemon_Zest = rgb <249/255, 216/255, 87/255>;
#declare CN_Lemonade = rgb <240/255, 231/255, 157/255>;
#declare CN_Lemonade_Stand = rgb <242/255, 202/255, 59/255>;
#declare CN_Lemongrass = rgb <197/255, 166/255, 88/255>;
#declare CN_Lemonwood_Place = rgb <249/255, 243/255, 215/255>;
#declare CN_Lemur = rgb <105/255, 95/255, 79/255>;
#declare CN_Lemures = rgb <191/255, 185/255, 212/255>;
#declare CN_Lens_Flare_Blue = rgb <206/255, 226/255, 226/255>;
#declare CN_Lens_Flare_Green = rgb <176/255, 255/255, 157/255>;
#declare CN_Lens_Flare_Pink = rgb <228/255, 203/255, 255/255>;
#declare CN_Lenticular_Ore = rgb <111/255, 181/255, 168/255>;
#declare CN_Lentil = rgb <220/255, 200/255, 176/255>;
#declare CN_Lentil_Sprout = rgb <171/255, 164/255, 77/255>;
#declare CN_Lenurple = rgb <186/255, 147/255, 216/255>;
#declare CN_Leopard = rgb <208/255, 152/255, 0/255>;
#declare CN_Lepidolite_Purple = rgb <148/255, 126/255, 148/255>;
#declare CN_Leprechaun = rgb <41/255, 144/255, 109/255>;
#declare CN_Leprechaun_Green = rgb <57/255, 85/255, 73/255>;
#declare CN_Leprous_Brown = rgb <217/255, 150/255, 49/255>;
#declare CN_Lepton_Gold = rgb <208/255, 160/255, 0/255>;
#declare CN_Leroy = rgb <113/255, 99/255, 90/255>;
#declare CN_Les_Cavaliers_Beach = rgb <15/255, 99/255, 179/255>;
#declare CN_Less_Brown = rgb <117/255, 103/255, 97/255>;
#declare CN_Less_Traveled = rgb <93/255, 105/255, 87/255>;
#declare CN_Lester = rgb <175/255, 209/255, 196/255>;
#declare CN_Let_It_Rain = rgb <182/255, 184/255, 189/255>;
#declare CN_Let_It_Ring = rgb <207/255, 174/255, 116/255>;
#declare CN_Let_it_Snow = rgb <216/255, 241/255, 244/255>;
#declare CN_Lethal_Lime = rgb <136/255, 255/255, 17/255>;
#declare CN_Leticiaz = rgb <149/255, 190/255, 118/255>;
#declare CN_Letter_Grey = rgb <143/255, 143/255, 139/255>;
#declare CN_Letter_Jacket = rgb <184/255, 134/255, 11/255>;
#declare CN_Lettuce_Alone = rgb <206/255, 221/255, 162/255>;
#declare CN_Lettuce_Green = rgb <190/255, 211/255, 142/255>;
#declare CN_Lettuce_Mound = rgb <146/255, 167/255, 114/255>;
#declare CN_Leukocyte_White = rgb <242/255, 241/255, 237/255>;
#declare CN_Level_Up = rgb <70/255, 135/255, 65/255>;
#declare CN_Leverkaas = rgb <237/255, 205/255, 194/255>;
#declare CN_Leviathan_Purple_Wash = rgb <139/255, 42/255, 152/255>;
#declare CN_Lewisham = rgb <103/255, 90/255, 73/255>;
#declare CN_Lexaloffle_Green = rgb <0/255, 228/255, 54/255>;
#declare CN_Lexington_Blue = rgb <125/255, 146/255, 148/255>;
#declare CN_Liaison = rgb <140/255, 63/255, 82/255>;
#declare CN_Lian_Hong_Lotus_Pink = rgb <240/255, 117/255, 230/255>;
#declare CN_Liberace = rgb <204/255, 184/255, 210/255>;
#declare CN_Liberal_Lilac = rgb <153/255, 85/255, 187/255>;
#declare CN_Liberalist = rgb <12/255, 71/255, 146/255>;
#declare CN_Liberated_Lime = rgb <216/255, 221/255, 204/255>;
#declare CN_Liberator_Gold = rgb <232/255, 196/255, 71/255>;
#declare CN_Liberia = rgb <239/255, 226/255, 219/255>;
#declare CN_Liberty = rgb <77/255, 68/255, 138/255>;
#declare CN_Liberty_Bell_Grey = rgb <105/255, 107/255, 109/255>;
#declare CN_Liberty_Blue = rgb <14/255, 21/255, 49/255>;
#declare CN_Liberty_Green = rgb <22/255, 167/255, 78/255>;
#declare CN_Liberty_Grey = rgb <175/255, 191/255, 201/255>;
#declare CN_Library_Leather = rgb <104/255, 85/255, 78/255>;
#declare CN_Library_Oak = rgb <143/255, 116/255, 89/255>;
#declare CN_Library_Pewter = rgb <127/255, 114/255, 99/255>;
#declare CN_Library_Red = rgb <91/255, 53/255, 48/255>;
#declare CN_Lich_Grey = rgb <169/255, 166/255, 148/255>;
#declare CN_Liche_Purple = rgb <115/255, 0/255, 97/255>;
#declare CN_Lichen = rgb <155/255, 194/255, 177/255>;
#declare CN_Lichen_Blue = rgb <93/255, 137/255, 179/255>;
#declare CN_Lichen_Green = rgb <157/255, 166/255, 147/255>;
#declare CN_Lichtenstein_Yellow = rgb <253/255, 255/255, 56/255>;
#declare CN_Lick_and_Kiss = rgb <238/255, 85/255, 119/255>;
#declare CN_Lickedy_Lick = rgb <180/255, 73/255, 108/255>;
#declare CN_Lickety_Split = rgb <195/255, 217/255, 151/255>;
#declare CN_Licorice = rgb <26/255, 17/255, 16/255>;
#declare CN_Licorice_Stick = rgb <181/255, 62/255, 61/255>;
#declare CN_Liddell = rgb <201/255, 156/255, 89/255>;
#declare CN_Liebermann_Green = rgb <146/255, 180/255, 152/255>;
#declare CN_Life_Aquatic = rgb <162/255, 176/255, 168/255>;
#declare CN_Life_at_Sea = rgb <175/255, 201/255, 220/255>;
#declare CN_Life_Force = rgb <111/255, 183/255, 224/255>;
#declare CN_Life_Is_a_Peach = rgb <229/255, 205/255, 190/255>;
#declare CN_Life_Is_Good = rgb <225/255, 155/255, 66/255>;
#declare CN_Life_Lesson = rgb <197/255, 202/255, 190/255>;
#declare CN_Lifeboat_Blue = rgb <129/255, 182/255, 188/255>;
#declare CN_Lifeguard = rgb <229/255, 0/255, 0/255>;
#declare CN_Lifeless_Green = rgb <0/255, 222/255, 173/255>;
#declare CN_Lifeless_Planet = rgb <230/255, 214/255, 153/255>;
#declare CN_Lifeline = rgb <153/255, 0/255, 51/255>;
#declare CN_Ligado = rgb <205/255, 214/255, 194/255>;
#declare CN_Light_Aluminium = rgb <195/255, 197/255, 197/255>;
#declare CN_Light_Amber_Orange = rgb <237/255, 154/255, 118/255>;
#declare CN_Light_Amourette = rgb <212/255, 211/255, 224/255>;
#declare CN_Light_Angel_Kiss = rgb <218/255, 212/255, 228/255>;
#declare CN_Light_Angora_Blue = rgb <201/255, 212/255, 225/255>;
#declare CN_Light_Apricot = rgb <242/255, 218/255, 214/255>;
#declare CN_Light_Aroma = rgb <222/255, 207/255, 210/255>;
#declare CN_Light_Ash_Brown = rgb <194/255, 164/255, 135/255>;
#declare CN_Light_Bassinet = rgb <222/255, 208/255, 216/255>;
#declare CN_Light_Bathing = rgb <171/255, 213/255, 220/255>;
#declare CN_Light_Beige = rgb <229/255, 222/255, 202/255>;
#declare CN_Light_Birch_Green = rgb <157/255, 181/255, 103/255>;
#declare CN_Light_Bleaches = rgb <213/255, 212/255, 208/255>;
#declare CN_Light_Blond = rgb <232/255, 211/255, 175/255>;
#declare CN_Light_Blossom_Time = rgb <236/255, 221/255, 214/255>;
#declare CN_Light_Blue = rgb <173/255, 216/255, 230/255>;
#declare CN_Light_Blue_Cloud = rgb <210/255, 211/255, 225/255>;
#declare CN_Light_Blue_Glint = rgb <168/255, 211/255, 225/255>;
#declare CN_Light_Blue_Grey = rgb <183/255, 201/255, 226/255>;
#declare CN_Light_Blue_Sloth = rgb <198/255, 221/255, 228/255>;
#declare CN_Light_Blue_Veil = rgb <192/255, 216/255, 235/255>;
#declare CN_Light_Bluish_Water = rgb <164/255, 219/255, 228/255>;
#declare CN_Light_Blush = rgb <233/255, 196/255, 204/255>;
#declare CN_Light_Bobby_Blue = rgb <173/255, 210/255, 227/255>;
#declare CN_Light_Breeze = rgb <207/255, 224/255, 242/255>;
#declare CN_Light_Bright_Spark = rgb <148/255, 208/255, 233/255>;
#declare CN_Light_Brown = rgb <181/255, 101/255, 29/255>;
#declare CN_Light_Brume = rgb <214/255, 213/255, 210/255>;
#declare CN_Light_Budgie_Blue = rgb <158/255, 214/255, 232/255>;
#declare CN_Light_Bunny_Soft = rgb <222/255, 206/255, 209/255>;
#declare CN_Light_Cameo_Blue = rgb <198/255, 212/255, 225/255>;
#declare CN_Light_Candela = rgb <201/255, 210/255, 223/255>;
#declare CN_Light_Capri_Green = rgb <139/255, 212/255, 195/255>;
#declare CN_Light_Caramel = rgb <163/255, 138/255, 131/255>;
#declare CN_Light_Cargo_River = rgb <219/255, 217/255, 201/255>;
#declare CN_Light_Carob = rgb <249/255, 219/255, 207/255>;
#declare CN_Light_Carolina = rgb <216/255, 243/255, 215/255>;
#declare CN_Light_Carrot_Flower = rgb <216/255, 222/255, 207/255>;
#declare CN_Light_Celery_Stick = rgb <216/255, 242/255, 220/255>;
#declare CN_Light_Chamois_Beige = rgb <209/255, 198/255, 190/255>;
#declare CN_Light_Chiffon = rgb <244/255, 231/255, 229/255>;
#declare CN_Light_Chintz = rgb <224/255, 213/255, 201/255>;
#declare CN_Light_Christobel = rgb <223/255, 211/255, 202/255>;
#declare CN_Light_Cipollino = rgb <213/255, 218/255, 209/255>;
#declare CN_Light_Continental_Waters = rgb <175/255, 213/255, 216/255>;
#declare CN_Light_Copper = rgb <196/255, 143/255, 75/255>;
#declare CN_Light_Corn = rgb <243/255, 226/255, 209/255>;
#declare CN_Light_Corn_Yellow = rgb <224/255, 195/255, 162/255>;
#declare CN_Light_Cornflower_Blue = rgb <147/255, 204/255, 234/255>;
#declare CN_Light_Crushed_Almond = rgb <221/255, 215/255, 209/255>;
#declare CN_Light_Cuddle = rgb <203/255, 215/255, 237/255>;
#declare CN_Light_Curd = rgb <249/255, 233/255, 201/255>;
#declare CN_Light_Cyan = rgb <224/255, 255/255, 255/255>;
#declare CN_Light_Daly_Waters = rgb <194/255, 228/255, 231/255>;
#declare CN_Light_Dante_Peak = rgb <198/255, 222/255, 223/255>;
#declare CN_Light_Daydreamer = rgb <226/255, 217/255, 210/255>;
#declare CN_Light_Dedication = rgb <252/255, 233/255, 213/255>;
#declare CN_Light_Delphin = rgb <158/255, 209/255, 227/255>;
#declare CN_Light_Deluxe_Days = rgb <164/255, 212/255, 236/255>;
#declare CN_Light_Detroit = rgb <205/255, 219/255, 220/255>;
#declare CN_Light_Dewpoint = rgb <196/255, 218/255, 221/255>;
#declare CN_Light_Drizzle = rgb <167/255, 174/255, 165/255>;
#declare CN_Light_Dry_Lichen = rgb <212/255, 227/255, 215/255>;
#declare CN_Light_Duck_Egg_Cream = rgb <213/255, 235/255, 221/255>;
#declare CN_Light_Easter_Rabbit = rgb <212/255, 206/255, 209/255>;
#declare CN_Light_Eggshell_Pink = rgb <217/255, 210/255, 201/255>;
#declare CN_Light_Ellen = rgb <234/255, 213/255, 199/255>;
#declare CN_Light_Elusive_Dream = rgb <216/255, 205/255, 211/255>;
#declare CN_Light_Enchanted = rgb <214/255, 234/255, 219/255>;
#declare CN_Light_Fairy_Pink = rgb <243/255, 222/255, 215/255>;
#declare CN_Light_Favourite_Lady = rgb <234/255, 211/255, 224/255>;
#declare CN_Light_Feather_Green = rgb <211/255, 217/255, 197/255>;
#declare CN_Light_Featherbed = rgb <193/255, 216/255, 235/255>;
#declare CN_Light_Fern_Green = rgb <230/255, 230/255, 208/255>;
#declare CN_Light_First_Love = rgb <252/255, 230/255, 219/255>;
#declare CN_Light_Flamingo_Pink = rgb <231/255, 209/255, 221/255>;
#declare CN_Light_French_Gray = rgb <194/255, 192/255, 187/255>;
#declare CN_Light_French_Grey = rgb <201/255, 207/255, 204/255>;
#declare CN_Light_Fresh_Lime = rgb <226/255, 244/255, 215/255>;
#declare CN_Light_Freshman = rgb <236/255, 244/255, 210/255>;
#declare CN_Light_Frost = rgb <237/255, 232/255, 215/255>;
#declare CN_Light_Frosty_Dawn = rgb <215/255, 239/255, 213/255>;
#declare CN_Light_Frozen_Frappe = rgb <230/255, 210/255, 220/255>;
#declare CN_Light_Gentle_Calm = rgb <210/255, 217/255, 205/255>;
#declare CN_Light_Ghosting = rgb <215/255, 211/255, 202/255>;
#declare CN_Light_Ginger_Yellow = rgb <247/255, 210/255, 140/255>;
#declare CN_Light_Glaze = rgb <192/255, 181/255, 170/255>;
#declare CN_Light_Granite = rgb <226/255, 221/255, 207/255>;
#declare CN_Light_Green = rgb <118/255, 255/255, 123/255>;
#declare CN_Light_Green_Alabaster = rgb <213/255, 216/255, 201/255>;
#declare CN_Light_Green_Ash = rgb <215/255, 221/255, 205/255>;
#declare CN_Light_Green_Glint = rgb <229/255, 244/255, 213/255>;
#declare CN_Light_Green_Veil = rgb <232/255, 244/255, 210/255>;
#declare CN_Light_Green_Wash = rgb <212/255, 230/255, 217/255>;
#declare CN_Light_Greenette = rgb <226/255, 240/255, 210/255>;
#declare CN_Light_Gregorio_Garden = rgb <215/255, 212/255, 228/255>;
#declare CN_Light_Grey = rgb <216/255, 220/255, 214/255>;
#declare CN_Light_Hindsight = rgb <205/255, 214/255, 234/255>;
#declare CN_Light_Hint_Of_Lavender = rgb <220/255, 207/255, 206/255>;
#declare CN_Light_Hog_Bristle = rgb <229/255, 221/255, 203/255>;
#declare CN_Light_Horizon_Sky = rgb <208/255, 210/255, 222/255>;
#declare CN_Light_Iced_Aniseed = rgb <216/255, 222/255, 208/255>;
#declare CN_Light_Iced_Lavender = rgb <208/255, 212/255, 227/255>;
#declare CN_Light_Imagine = rgb <174/255, 212/255, 216/255>;
#declare CN_Light_Incense = rgb <239/255, 220/255, 190/255>;
#declare CN_Light_Instant = rgb <226/255, 217/255, 212/255>;
#declare CN_Light_Issey_San = rgb <219/255, 228/255, 209/255>;
#declare CN_Light_Jellyfish_Blue = rgb <172/255, 214/255, 219/255>;
#declare CN_Light_Katsura = rgb <214/255, 234/255, 216/255>;
#declare CN_Light_Khaki = rgb <153/255, 141/255, 124/255>;
#declare CN_Light_Kiri_Mist = rgb <211/255, 210/255, 221/255>;
#declare CN_Light_Lambs_Ears = rgb <214/255, 217/255, 203/255>;
#declare CN_Light_Lavender = rgb <239/255, 192/255, 254/255>;
#declare CN_Light_Lavender_Blush = rgb <227/255, 210/255, 207/255>;
#declare CN_Light_Lavender_Water = rgb <221/255, 214/255, 231/255>;
#declare CN_Light_Lichen = rgb <191/255, 182/255, 169/255>;
#declare CN_Light_Ligado = rgb <217/255, 224/255, 208/255>;
#declare CN_Light_Light_Blush = rgb <238/255, 210/255, 215/255>;
#declare CN_Light_Light_Lichen = rgb <211/255, 231/255, 220/255>;
#declare CN_Light_Lilac = rgb <220/255, 198/255, 210/255>;
#declare CN_Light_Lime_Sherbet = rgb <216/255, 230/255, 206/255>;
#declare CN_Light_Limed_White = rgb <219/255, 213/255, 206/255>;
#declare CN_Light_Limpid_Light = rgb <218/255, 209/255, 215/255>;
#declare CN_Light_Lip_Gloss = rgb <231/255, 217/255, 212/255>;
#declare CN_Light_Livingstone = rgb <216/255, 215/255, 202/255>;
#declare CN_Light_Lost_Lace = rgb <209/255, 240/255, 221/255>;
#declare CN_Light_Lunette = rgb <220/255, 213/255, 211/255>;
#declare CN_Light_Magnolia_Rose = rgb <219/255, 213/255, 218/255>;
#declare CN_Light_Mahogany = rgb <155/255, 139/255, 124/255>;
#declare CN_Light_Maidens_Blush = rgb <246/255, 221/255, 206/255>;
#declare CN_Light_Male = rgb <227/255, 219/255, 208/255>;
#declare CN_Light_Marsh_Fog = rgb <211/255, 225/255, 211/255>;
#declare CN_Light_Marshmallow_Magic = rgb <244/255, 221/255, 219/255>;
#declare CN_Light_Martian_Moon = rgb <209/255, 239/255, 221/255>;
#declare CN_Light_Mauve = rgb <194/255, 146/255, 161/255>;
#declare CN_Light_Meadow_Lane = rgb <206/255, 225/255, 217/255>;
#declare CN_Light_Mint = rgb <182/255, 255/255, 187/255>;
#declare CN_Light_Mint_Green = rgb <166/255, 251/255, 178/255>;
#declare CN_Light_Mist = rgb <220/255, 225/255, 213/255>;
#declare CN_Light_Mocha = rgb <177/255, 134/255, 115/255>;
#declare CN_Light_Modesty = rgb <222/255, 213/255, 226/255>;
#declare CN_Light_Morality = rgb <196/255, 217/255, 235/255>;
#declare CN_Light_Mosque = rgb <216/255, 205/255, 208/255>;
#declare CN_Light_Mulberry = rgb <209/255, 202/255, 225/255>;
#declare CN_Light_Mystified = rgb <214/255, 228/255, 212/255>;
#declare CN_Light_Naked_Pink = rgb <226/255, 212/255, 225/255>;
#declare CN_Light_Nougat = rgb <251/255, 230/255, 199/255>;
#declare CN_Light_Nursery = rgb <244/255, 220/255, 220/255>;
#declare CN_Light_Nut_Milk = rgb <227/255, 216/255, 212/255>;
#declare CN_Light_Oak = rgb <210/255, 177/255, 131/255>;
#declare CN_Light_Oak_Brown = rgb <175/255, 133/255, 92/255>;
#declare CN_Light_of_New_Hope = rgb <234/255, 243/255, 208/255>;
#declare CN_Light_Olive = rgb <172/255, 191/255, 105/255>;
#declare CN_Light_Opale = rgb <193/255, 232/255, 234/255>;
#declare CN_Light_Opus = rgb <218/255, 215/255, 232/255>;
#declare CN_Light_Orchid = rgb <230/255, 168/255, 215/255>;
#declare CN_Light_Orchid_Haze = rgb <214/255, 205/255, 208/255>;
#declare CN_Light_Oriental_Blush = rgb <225/255, 212/255, 232/255>;
#declare CN_Light_Otto_Ice = rgb <205/255, 231/255, 221/255>;
#declare CN_Light_Pale_Icelandish = rgb <204/255, 223/255, 220/255>;
#declare CN_Light_Pale_Lilac = rgb <206/255, 213/255, 228/255>;
#declare CN_Light_Pale_Pearl = rgb <212/255, 203/255, 206/255>;
#declare CN_Light_Pale_Tendril = rgb <219/255, 218/255, 203/255>;
#declare CN_Light_Pastel_Green = rgb <178/255, 251/255, 165/255>;
#declare CN_Light_Pax = rgb <213/255, 211/255, 227/255>;
#declare CN_Light_Peach_Rose = rgb <255/255, 230/255, 216/255>;
#declare CN_Light_Pearl_Ash = rgb <220/255, 214/255, 209/255>;
#declare CN_Light_Pearl_Soft_Blue = rgb <190/255, 200/255, 216/255>;
#declare CN_Light_Pecan_Pine = rgb <241/255, 234/255, 226/255>;
#declare CN_Light_Pelican_Bill = rgb <225/255, 206/255, 212/255>;
#declare CN_Light_Penna = rgb <200/255, 212/255, 231/255>;
#declare CN_Light_Pensive = rgb <208/255, 208/255, 215/255>;
#declare CN_Light_Periwinkle = rgb <193/255, 198/255, 252/255>;
#declare CN_Light_Perk_Up = rgb <224/255, 213/255, 205/255>;
#declare CN_Light_Petite_Pink = rgb <240/255, 215/255, 215/255>;
#declare CN_Light_Pianissimo = rgb <236/255, 219/255, 214/255>;
#declare CN_Light_Picnic_Bay = rgb <205/255, 229/255, 222/255>;
#declare CN_Light_Pink = rgb <255/255, 209/255, 223/255>;
#declare CN_Light_Pink_Clay = rgb <254/255, 223/255, 220/255>;
#declare CN_Light_Pink_Linen = rgb <221/255, 206/255, 209/255>;
#declare CN_Light_Pink_Pandora = rgb <233/255, 211/255, 213/255>;
#declare CN_Light_Pink_Polar = rgb <216/255, 201/255, 204/255>;
#declare CN_Light_Pink_Tone = rgb <250/255, 217/255, 218/255>;
#declare CN_Light_Pistachio_Tang = rgb <226/255, 222/255, 200/255>;
#declare CN_Light_Placid_Blue = rgb <200/255, 216/255, 232/255>;
#declare CN_Light_Pollinate = rgb <235/255, 225/255, 203/255>;
#declare CN_Light_Poolside = rgb <190/255, 224/255, 226/255>;
#declare CN_Light_Porcelain = rgb <231/255, 218/255, 215/255>;
#declare CN_Light_Powder_Blue = rgb <196/255, 217/255, 239/255>;
#declare CN_Light_Powdered_Granite = rgb <209/255, 214/255, 235/255>;
#declare CN_Light_Pre_School = rgb <197/255, 208/255, 217/255>;
#declare CN_Light_Pretty_Pale = rgb <234/255, 212/255, 224/255>;
#declare CN_Light_Puffball = rgb <217/255, 206/255, 213/255>;
#declare CN_Light_Pumpkin_Brown = rgb <194/255, 165/255, 133/255>;
#declare CN_Light_Pure_Blue = rgb <194/255, 210/255, 216/255>;
#declare CN_Light_Purity = rgb <224/255, 213/255, 233/255>;
#declare CN_Light_Quaver = rgb <205/255, 222/255, 215/255>;
#declare CN_Light_Quilt = rgb <253/255, 225/255, 212/255>;
#declare CN_Light_Radar = rgb <198/255, 213/255, 234/255>;
#declare CN_Light_Rattan = rgb <209/255, 193/255, 170/255>;
#declare CN_Light_Raw_Cotton = rgb <236/255, 223/255, 202/255>;
#declare CN_Light_Red = rgb <243/255, 211/255, 217/255>;
#declare CN_Light_Relax = rgb <202/255, 221/255, 222/255>;
#declare CN_Light_Ridge_Light = rgb <195/255, 213/255, 229/255>;
#declare CN_Light_Roast = rgb <97/255, 85/255, 68/255>;
#declare CN_Light_Rose = rgb <244/255, 212/255, 214/255>;
#declare CN_Light_Rose_Beige = rgb <249/255, 235/255, 228/255>;
#declare CN_Light_Rose_Romantic = rgb <243/255, 220/255, 216/255>;
#declare CN_Light_Saffron_Orange = rgb <255/255, 204/255, 165/255>;
#declare CN_Light_Sage = rgb <179/255, 176/255, 163/255>;
#declare CN_Light_Salome = rgb <204/255, 241/255, 227/255>;
#declare CN_Light_Salt_Spray = rgb <187/255, 211/255, 218/255>;
#declare CN_Light_Sandbank = rgb <222/255, 220/255, 198/255>;
#declare CN_Light_Sandy_Day = rgb <225/255, 218/255, 207/255>;
#declare CN_Light_Sea_Breeze = rgb <183/255, 205/255, 217/255>;
#declare CN_Light_Sea_Cliff = rgb <185/255, 212/255, 231/255>;
#declare CN_Light_Sea_Spray = rgb <171/255, 214/255, 222/255>;
#declare CN_Light_Sea_Foam = rgb <160/255, 254/255, 191/255>;
#declare CN_Light_Seafoam_Green = rgb <167/255, 255/255, 181/255>;
#declare CN_Light_Security = rgb <224/255, 233/255, 208/255>;
#declare CN_Light_Shell_Haven = rgb <241/255, 232/255, 206/255>;
#declare CN_Light_Shell_Tint = rgb <252/255, 224/255, 214/255>;
#declare CN_Light_Shetland_Lace = rgb <231/255, 220/255, 207/255>;
#declare CN_Light_Shimmer = rgb <163/255, 212/255, 239/255>;
#declare CN_Light_Short_Phase = rgb <203/255, 232/255, 223/255>;
#declare CN_Light_Shutterbug = rgb <206/255, 242/255, 228/255>;
#declare CN_Light_Silver_Grass = rgb <212/255, 219/255, 209/255>;
#declare CN_Light_Silverton = rgb <206/255, 227/255, 217/255>;
#declare CN_Light_Sky_Babe = rgb <161/255, 208/255, 226/255>;
#declare CN_Light_Sky_Bus = rgb <175/255, 207/255, 224/255>;
#declare CN_Light_Sky_Chase = rgb <186/255, 215/255, 220/255>;
#declare CN_Light_Skyway = rgb <194/255, 227/255, 232/255>;
#declare CN_Light_Slipper_Satin = rgb <207/255, 209/255, 216/255>;
#declare CN_Light_Soft_Celadon = rgb <206/255, 220/255, 212/255>;
#declare CN_Light_Soft_Fresco = rgb <207/255, 224/255, 215/255>;
#declare CN_Light_Soft_Kind = rgb <220/255, 221/255, 204/255>;
#declare CN_Light_Spearmint_Ice = rgb <207/255, 222/255, 215/255>;
#declare CN_Light_Spirit = rgb <195/255, 202/255, 211/255>;
#declare CN_Light_Spirited = rgb <216/255, 238/255, 231/255>;
#declare CN_Light_Sprig_Muslin = rgb <224/255, 207/255, 210/255>;
#declare CN_Light_Spring_Burst = rgb <214/255, 232/255, 213/255>;
#declare CN_Light_Sprinkle = rgb <227/255, 227/255, 215/255>;
#declare CN_Light_Stargate = rgb <199/255, 210/255, 221/255>;
#declare CN_Light_Starlight = rgb <203/255, 208/255, 215/255>;
#declare CN_Light_Stately_Frills = rgb <210/255, 204/255, 209/255>;
#declare CN_Light_Steel_Blue = rgb <176/255, 196/255, 222/255>;
#declare CN_Light_Stone = rgb <220/255, 209/255, 204/255>;
#declare CN_Light_Subpoena = rgb <228/255, 218/255, 211/255>;
#declare CN_Light_Supernova = rgb <205/255, 229/255, 226/255>;
#declare CN_Light_Tactile = rgb <222/255, 237/255, 212/255>;
#declare CN_Light_Taupe = rgb <177/255, 157/255, 141/255>;
#declare CN_Light_Taupe_White = rgb <213/255, 208/255, 203/255>;
#declare CN_Light_Teal = rgb <177/255, 204/255, 197/255>;
#declare CN_Light_Template = rgb <187/255, 214/255, 234/255>;
#declare CN_Light_Terracotta = rgb <223/255, 155/255, 129/255>;
#declare CN_Light_Thought = rgb <226/255, 216/255, 212/255>;
#declare CN_Light_Tidal_Foam = rgb <188/255, 214/255, 233/255>;
#declare CN_Light_Time_Travel = rgb <197/255, 210/255, 223/255>;
#declare CN_Light_Tinge_Of_Mauve = rgb <223/255, 210/255, 217/255>;
#declare CN_Light_Tip_Toes = rgb <225/255, 208/255, 216/255>;
#declare CN_Light_Tomato = rgb <208/255, 117/255, 111/255>;
#declare CN_Light_Topaz_Ochre = rgb <176/255, 137/255, 113/255>;
#declare CN_Light_Topaz_Soft_Blue = rgb <181/255, 205/255, 215/255>;
#declare CN_Light_Touch = rgb <245/255, 236/255, 223/255>;
#declare CN_Light_Turquoise = rgb <126/255, 244/255, 204/255>;
#declare CN_Light_Vandamint = rgb <191/255, 231/255, 234/255>;
#declare CN_Light_Vanilla_Ice = rgb <184/255, 206/255, 217/255>;
#declare CN_Light_Vanilla_Quake = rgb <216/255, 213/255, 208/255>;
#declare CN_Light_Violet = rgb <214/255, 180/255, 252/255>;
#declare CN_Light_Vision = rgb <220/255, 217/255, 235/255>;
#declare CN_Light_Wallis = rgb <212/255, 204/255, 206/255>;
#declare CN_Light_Washed_Blue = rgb <172/255, 220/255, 231/255>;
#declare CN_Light_Water_Wash = rgb <191/255, 213/255, 235/255>;
#declare CN_Light_Water_Wings = rgb <194/255, 240/255, 230/255>;
#declare CN_Light_Watermark = rgb <183/255, 218/255, 221/255>;
#declare CN_Light_Watermelon_Milk = rgb <230/255, 218/255, 214/255>;
#declare CN_Light_Wavecrest = rgb <181/255, 209/255, 223/255>;
#declare CN_Light_Weathered_Hide = rgb <224/255, 212/255, 208/255>;
#declare CN_Light_Whimsy = rgb <153/255, 208/255, 231/255>;
#declare CN_Light_White_Box = rgb <206/255, 220/255, 214/255>;
#declare CN_Light_Year = rgb <191/255, 191/255, 180/255>;
#declare CN_Light_Yellow = rgb <255/255, 254/255, 122/255>;
#declare CN_Light_Yellowish_Green = rgb <194/255, 255/255, 137/255>;
#declare CN_Light_Youth = rgb <234/255, 215/255, 213/255>;
#declare CN_Light_Zen = rgb <209/255, 219/255, 210/255>;
#declare CN_Lighter_Green = rgb <117/255, 253/255, 99/255>;
#declare CN_Lighter_Mint = rgb <223/255, 235/255, 221/255>;
#declare CN_Lighter_Purple = rgb <165/255, 90/255, 244/255>;
#declare CN_Lightest_Sky = rgb <228/255, 234/255, 223/255>;
#declare CN_Lighthearted = rgb <247/255, 224/255, 225/255>;
#declare CN_Lighthearted_Pink = rgb <237/255, 213/255, 221/255>;
#declare CN_Lighthearted_Rose = rgb <199/255, 161/255, 169/255>;
#declare CN_Lighthouse = rgb <243/255, 244/255, 244/255>;
#declare CN_Lighthouse_Glow = rgb <248/255, 213/255, 104/255>;
#declare CN_Lighthouse_View = rgb <217/255, 220/255, 213/255>;
#declare CN_Lightish_Blue = rgb <61/255, 122/255, 253/255>;
#declare CN_Lightish_Green = rgb <97/255, 225/255, 96/255>;
#declare CN_Lightish_Purple = rgb <165/255, 82/255, 230/255>;
#declare CN_Lightish_Red = rgb <254/255, 47/255, 74/255>;
#declare CN_Lightning_Bolt = rgb <229/255, 235/255, 230/255>;
#declare CN_Lightning_Bolt_Blue = rgb <147/255, 185/255, 223/255>;
#declare CN_Lightning_Bug = rgb <239/255, 222/255, 116/255>;
#declare CN_Lightning_White = rgb <248/255, 237/255, 209/255>;
#declare CN_Lightning_Yellow = rgb <247/255, 162/255, 51/255>;
#declare CN_Lights_of_Shibuya = rgb <248/255, 242/255, 222/255>;
#declare CN_Lights_Out = rgb <61/255, 71/255, 75/255>;
#declare CN_Lightsaber_Blue = rgb <21/255, 242/255, 253/255>;
#declare CN_Lightweight_Beige = rgb <246/255, 229/255, 197/255>;
#declare CN_Lignum_Vitae_Foliage = rgb <103/255, 118/255, 91/255>;
#declare CN_Ligonier_Tan = rgb <210/255, 177/255, 143/255>;
#declare CN_Likeable_Sand = rgb <209/255, 183/255, 168/255>;
#declare CN_Lilac = rgb <206/255, 162/255, 253/255>;
#declare CN_Lilac_Ash = rgb <215/255, 205/255, 205/255>;
#declare CN_Lilac_Bisque = rgb <198/255, 205/255, 224/255>;
#declare CN_Lilac_Bloom = rgb <175/255, 171/255, 184/255>;
#declare CN_Lilac_Blossom = rgb <154/255, 147/255, 169/255>;
#declare CN_Lilac_Blue = rgb <130/255, 147/255, 172/255>;
#declare CN_Lilac_Breeze = rgb <179/255, 160/255, 201/255>;
#declare CN_Lilac_Bush = rgb <148/255, 112/255, 196/255>;
#declare CN_Lilac_Champagne = rgb <223/255, 225/255, 230/255>;
#declare CN_Lilac_Chiffon = rgb <222/255, 155/255, 196/255>;
#declare CN_Lilac_Cotton_Candy = rgb <205/255, 215/255, 236/255>;
#declare CN_Lilac_Crystal = rgb <203/255, 197/255, 217/255>;
#declare CN_Lilac_Fields = rgb <143/255, 147/255, 157/255>;
#declare CN_Lilac_Flare = rgb <178/255, 186/255, 219/255>;
#declare CN_Lilac_Fluff = rgb <200/255, 164/255, 191/255>;
#declare CN_Lilac_Frost = rgb <232/255, 222/255, 234/255>;
#declare CN_Lilac_Geode = rgb <187/255, 136/255, 255/255>;
#declare CN_Lilac_Grey = rgb <152/255, 150/255, 164/255>;
#declare CN_Lilac_Haze = rgb <213/255, 182/255, 212/255>;
#declare CN_Lilac_Hint = rgb <208/255, 208/255, 218/255>;
#declare CN_Lilac_Intuition = rgb <154/255, 126/255, 167/255>;
#declare CN_Lilac_Light = rgb <215/255, 193/255, 186/255>;
#declare CN_Lilac_Lotion = rgb <255/255, 51/255, 136/255>;
#declare CN_Lilac_Lust = rgb <195/255, 185/255, 216/255>;
#declare CN_Lilac_Luster = rgb <174/255, 152/255, 170/255>;
#declare CN_Lilac_Marble = rgb <195/255, 186/255, 191/255>;
#declare CN_Lilac_Mauve = rgb <214/255, 208/255, 214/255>;
#declare CN_Lilac_Mist = rgb <228/255, 228/255, 231/255>;
#declare CN_Lilac_Murmur = rgb <229/255, 230/255, 234/255>;
#declare CN_Lilac_Paradise = rgb <220/255, 187/255, 186/255>;
#declare CN_Lilac_Pink = rgb <192/255, 157/255, 200/255>;
#declare CN_Lilac_Purple = rgb <161/255, 131/255, 192/255>;
#declare CN_Lilac_Rose = rgb <189/255, 66/255, 117/255>;
#declare CN_Lilac_Sachet = rgb <171/255, 182/255, 215/255>;
#declare CN_Lilac_Scent_Soft_Blue = rgb <158/255, 171/255, 208/255>;
#declare CN_Lilac_Smoke = rgb <182/255, 163/255, 160/255>;
#declare CN_Lilac_Snow = rgb <224/255, 199/255, 215/255>;
#declare CN_Lilac_Spring = rgb <136/255, 34/255, 204/255>;
#declare CN_Lilac_Suede = rgb <186/255, 155/255, 151/255>;
#declare CN_Lilac_Tan = rgb <212/255, 199/255, 196/255>;
#declare CN_Lilac_Time = rgb <164/255, 171/255, 191/255>;
#declare CN_Lilac_Violet = rgb <117/255, 74/255, 128/255>;
#declare CN_Lilacs_in_Spring = rgb <233/255, 207/255, 229/255>;
#declare CN_Lilas = rgb <184/255, 137/255, 149/255>;
#declare CN_Lilas = rgb <204/255, 153/255, 255/255>;
#declare CN_Liliac = rgb <196/255, 142/255, 253/255>;
#declare CN_Lilliputian_Lime = rgb <136/255, 221/255, 85/255>;
#declare CN_Lilting_Laughter = rgb <252/255, 235/255, 216/255>;
#declare CN_Lily = rgb <193/255, 159/255, 179/255>;
#declare CN_Lily_Green = rgb <197/255, 207/255, 152/255>;
#declare CN_Lily_Lavender = rgb <230/255, 230/255, 232/255>;
#declare CN_Lily_Legs = rgb <238/255, 199/255, 214/255>;
#declare CN_Lily_of_the_Nile = rgb <145/255, 145/255, 187/255>;
#declare CN_Lily_of_The_Valley_White = rgb <226/255, 227/255, 214/255>;
#declare CN_Lily_Pad = rgb <129/255, 143/255, 132/255>;
#declare CN_Lily_Pads = rgb <109/255, 176/255, 131/255>;
#declare CN_Lily_Pond = rgb <222/255, 234/255, 216/255>;
#declare CN_Lily_Pond_Blue = rgb <85/255, 112/255, 127/255>;
#declare CN_Lily_Scent_Green = rgb <230/255, 230/255, 188/255>;
#declare CN_Lily_The_Pink = rgb <245/255, 222/255, 226/255>;
#declare CN_Lily_White = rgb <240/255, 231/255, 211/255>;
#declare CN_Lilylock = rgb <224/255, 225/255, 193/255>;
#declare CN_Lima = rgb <169/255, 249/255, 113/255>;
#declare CN_Lima_Bean = rgb <225/255, 213/255, 144/255>;
#declare CN_Lima_Bean_Green = rgb <136/255, 190/255, 105/255>;
#declare CN_Lima_Green = rgb <177/255, 183/255, 135/255>;
#declare CN_Lima_Sombrio = rgb <122/255, 172/255, 33/255>;
#declare CN_Limbert_Leather = rgb <152/255, 136/255, 112/255>;
#declare CN_Lime = rgb <170/255, 255/255, 50/255>;
#declare CN_Lime_Acid = rgb <175/255, 255/255, 1/255>;
#declare CN_Lime_Blossom = rgb <244/255, 242/255, 211/255>;
#declare CN_Lime_Bright = rgb <241/255, 228/255, 176/255>;
#declare CN_Lime_Cake = rgb <218/255, 227/255, 208/255>;
#declare CN_Lime_Candy_Pearl = rgb <170/255, 255/255, 0/255>;
#declare CN_Lime_Chalk = rgb <229/255, 221/255, 200/255>;
#declare CN_Lime_Coco_Cake = rgb <230/255, 239/255, 204/255>;
#declare CN_Lime_Cream = rgb <215/255, 232/255, 188/255>;
#declare CN_Lime_Daiquiri = rgb <221/255, 230/255, 215/255>;
#declare CN_Lime_Dream = rgb <194/255, 236/255, 188/255>;
#declare CN_Lime_Fizz = rgb <207/255, 232/255, 56/255>;
#declare CN_Lime_Flip = rgb <210/255, 227/255, 204/255>;
#declare CN_Lime_Glow = rgb <225/255, 236/255, 217/255>;
#declare CN_Lime_Granita = rgb <220/255, 225/255, 184/255>;
#declare CN_Lime_Green = rgb <159/255, 193/255, 49/255>;
#declare CN_Lime_Hawk_Moth = rgb <205/255, 174/255, 165/255>;
#declare CN_Lime_Ice = rgb <209/255, 221/255, 134/255>;
#declare CN_Lime_Jelly = rgb <227/255, 255/255, 0/255>;
#declare CN_Lime_Juice = rgb <231/255, 228/255, 211/255>;
#declare CN_Lime_Juice_Green = rgb <229/255, 232/255, 150/255>;
#declare CN_Lime_Lightning = rgb <190/255, 253/255, 115/255>;
#declare CN_Lime_Lizard = rgb <171/255, 211/255, 93/255>;
#declare CN_Lime_Lollipop = rgb <180/255, 189/255, 122/255>;
#declare CN_Lime_Meringue = rgb <230/255, 236/255, 214/255>;
#declare CN_Lime_Mist = rgb <221/255, 255/255, 170/255>;
#declare CN_Lime_Parfait = rgb <149/255, 197/255, 119/255>;
#declare CN_Lime_Peel = rgb <198/255, 193/255, 145/255>;
#declare CN_Lime_Pink = rgb <182/255, 132/255, 140/255>;
#declare CN_Lime_Pop = rgb <204/255, 203/255, 47/255>;
#declare CN_Lime_Popsicle = rgb <192/255, 219/255, 58/255>;
#declare CN_Lime_Punch = rgb <192/255, 215/255, 37/255>;
#declare CN_Lime_Rasp = rgb <181/255, 206/255, 8/255>;
#declare CN_Lime_Rickey = rgb <175/255, 185/255, 106/255>;
#declare CN_Lime_Sherbet = rgb <205/255, 215/255, 138/255>;
#declare CN_Lime_Shot = rgb <29/255, 249/255, 20/255>;
#declare CN_Lime_Slice = rgb <240/255, 253/255, 237/255>;
#declare CN_Lime_Soap = rgb <122/255, 249/255, 171/255>;
#declare CN_Lime_Sorbet = rgb <190/255, 229/255, 190/255>;
#declare CN_Lime_Sorbet_Green = rgb <198/255, 205/255, 125/255>;
#declare CN_Lime_Splash = rgb <207/255, 219/255, 141/255>;
#declare CN_Lime_Spritz = rgb <218/255, 225/255, 207/255>;
#declare CN_Lime_Taffy = rgb <186/255, 209/255, 181/255>;
#declare CN_Lime_Time = rgb <235/255, 231/255, 52/255>;
#declare CN_Lime_Tree = rgb <216/255, 208/255, 107/255>;
#declare CN_Lime_Twist = rgb <198/255, 214/255, 36/255>;
#declare CN_Lime_Wash = rgb <223/255, 227/255, 208/255>;
#declare CN_Lime_Yellow = rgb <208/255, 254/255, 29/255>;
#declare CN_Lime_Zest = rgb <221/255, 255/255, 0/255>;
#declare CN_Limeade = rgb <95/255, 151/255, 39/255>;
#declare CN_Limed_Ash = rgb <116/255, 125/255, 99/255>;
#declare CN_Limed_Oak = rgb <172/255, 138/255, 86/255>;
#declare CN_Limed_Spruce = rgb <57/255, 72/255, 81/255>;
#declare CN_Limed_White = rgb <207/255, 201/255, 192/255>;
#declare CN_Limelight = rgb <240/255, 232/255, 125/255>;
#declare CN_Limeno_Limon = rgb <248/255, 177/255, 9/255>;
#declare CN_Limerick = rgb <118/255, 133/255, 123/255>;
#declare CN_Limescent = rgb <224/255, 212/255, 183/255>;
#declare CN_Limesicle = rgb <242/255, 234/255, 191/255>;
#declare CN_Limestone = rgb <220/255, 216/255, 199/255>;
#declare CN_Limestone_Green = rgb <165/255, 175/255, 157/255>;
#declare CN_Limestone_Mauve = rgb <214/255, 215/255, 219/255>;
#declare CN_Limestone_Quarry = rgb <249/255, 246/255, 219/255>;
#declare CN_Limestone_Slate = rgb <197/255, 224/255, 189/255>;
#declare CN_Limetta = rgb <142/255, 154/255, 33/255>;
#declare CN_Limewash = rgb <219/255, 213/255, 203/255>;
#declare CN_Limited_Lime = rgb <234/255, 236/255, 185/255>;
#declare CN_Limitless = rgb <240/255, 221/255, 184/255>;
#declare CN_Limo_Scene = rgb <75/255, 73/255, 80/255>;
#declare CN_Limoge_Pink = rgb <243/255, 224/255, 219/255>;
#declare CN_Limoges = rgb <36/255, 63/255, 108/255>;
#declare CN_Limon_Fresco = rgb <206/255, 188/255, 85/255>;
#declare CN_Limonana = rgb <17/255, 221/255, 102/255>;
#declare CN_Limoncello = rgb <191/255, 255/255, 0/255>;
#declare CN_Limone = rgb <214/255, 196/255, 67/255>;
#declare CN_Limonite = rgb <190/255, 127/255, 81/255>;
#declare CN_Limonite_Brown = rgb <75/255, 68/255, 51/255>;
#declare CN_Limousine_Grey_Blue = rgb <83/255, 95/255, 98/255>;
#declare CN_Limousine_Leather = rgb <59/255, 60/255, 59/255>;
#declare CN_Limpet_Shell = rgb <152/255, 221/255, 222/255>;
#declare CN_Limpid_Light = rgb <205/255, 194/255, 202/255>;
#declare CN_Limuyi_Yellow = rgb <254/255, 252/255, 126/255>;
#declare CN_Lincoln_Green = rgb <25/255, 89/255, 5/255>;
#declare CN_Lincolnshire_Sausage = rgb <227/255, 230/255, 218/255>;
#declare CN_Linden_Green = rgb <196/255, 191/255, 113/255>;
#declare CN_Linden_Spear = rgb <142/255, 153/255, 133/255>;
#declare CN_Linderhof_Garden = rgb <34/255, 153/255, 34/255>;
#declare CN_Lindworm_Green = rgb <23/255, 40/255, 8/255>;
#declare CN_Line_Dried_Sheets = rgb <245/255, 237/255, 237/255>;
#declare CN_Lineage = rgb <76/255, 52/255, 48/255>;
#declare CN_Linear = rgb <22/255, 73/255, 117/255>;
#declare CN_Linen = rgb <250/255, 240/255, 230/255>;
#declare CN_Linen_Grey = rgb <70/255, 97/255, 99/255>;
#declare CN_Linen_Ruffle = rgb <239/255, 235/255, 227/255>;
#declare CN_Linen_White = rgb <233/255, 220/255, 209/255>;
#declare CN_Lingering_Lilac = rgb <230/255, 222/255, 240/255>;
#declare CN_Lingonberry = rgb <255/255, 37/255, 92/255>;
#declare CN_Lingonberry_Punch = rgb <169/255, 86/255, 87/255>;
#declare CN_Lingonberry_Red = rgb <206/255, 68/255, 88/255>;
#declare CN_Link = rgb <119/255, 130/255, 144/255>;
#declare CN_Link_Gray = rgb <127/255, 126/255, 114/255>;
#declare CN_Link_Green = rgb <1/255, 160/255, 73/255>;
#declare CN_Link_to_the_Past = rgb <210/255, 180/255, 140/255>;
#declare CN_Link_Water = rgb <199/255, 205/255, 216/255>;
#declare CN_Links_Awakening = rgb <62/255, 175/255, 118/255>;
#declare CN_Linnet = rgb <195/255, 188/255, 179/255>;
#declare CN_Linnet_Egg_Red = rgb <255/255, 204/255, 221/255>;
#declare CN_Linoleum_Blue = rgb <66/255, 124/255, 157/255>;
#declare CN_Linoleum_Green = rgb <58/255, 163/255, 114/255>;
#declare CN_Linseed = rgb <176/255, 168/255, 149/255>;
#declare CN_Lint = rgb <182/255, 186/255, 153/255>;
#declare CN_Lion = rgb <193/255, 154/255, 98/255>;
#declare CN_Lion_Cub = rgb <249/255, 205/255, 164/255>;
#declare CN_Lion_King = rgb <221/255, 153/255, 51/255>;
#declare CN_Lion_Mane = rgb <186/255, 142/255, 79/255>;
#declare CN_Lion_of_Menecrates = rgb <238/255, 170/255, 102/255>;
#declare CN_Lions_Lair = rgb <129/255, 82/255, 46/255>;
#declare CN_Lions_Mane = rgb <232/255, 175/255, 73/255>;
#declare CN_Lions_Mane_Blonde = rgb <148/255, 107/255, 65/255>;
#declare CN_Lioness = rgb <224/255, 175/255, 71/255>;
#declare CN_Lionfish_Red = rgb <224/255, 60/255, 40/255>;
#declare CN_Lionhead = rgb <213/255, 182/255, 10/255>;
#declare CN_Lionheart = rgb <204/255, 34/255, 34/255>;
#declare CN_Lip_Gloss = rgb <223/255, 205/255, 199/255>;
#declare CN_Lippie = rgb <209/255, 106/255, 104/255>;
#declare CN_Lips_of_Apricot = rgb <251/255, 206/255, 177/255>;
#declare CN_Lipstick = rgb <201/255, 91/255, 131/255>;
#declare CN_Lipstick_Pink = rgb <189/255, 127/255, 138/255>;
#declare CN_Lipstick_Red = rgb <192/255, 2/255, 47/255>;
#declare CN_Liqueur_Red = rgb <97/255, 57/255, 75/255>;
#declare CN_Liquid_Blue = rgb <85/255, 183/255, 206/255>;
#declare CN_Liquid_Gold = rgb <253/255, 198/255, 117/255>;
#declare CN_Liquid_Green_Stuff = rgb <59/255, 122/255, 95/255>;
#declare CN_Liquid_Lime = rgb <205/255, 248/255, 12/255>;
#declare CN_Liquid_Mercury = rgb <117/255, 122/255, 128/255>;
#declare CN_Liquid_Nitrogen = rgb <243/255, 243/255, 244/255>;
#declare CN_Liquorice = rgb <10/255, 5/255, 2/255>;
#declare CN_Liquorice_Black = rgb <53/255, 45/255, 50/255>;
#declare CN_Liquorice_Green = rgb <42/255, 64/255, 65/255>;
#declare CN_Liquorice_Red = rgb <116/255, 9/255, 0/255>;
#declare CN_Liquorice_Root = rgb <34/255, 34/255, 0/255>;
#declare CN_Lira = rgb <226/255, 194/255, 141/255>;
#declare CN_Lisbon_Brown = rgb <66/255, 57/255, 33/255>;
#declare CN_Lisbon_Lemon = rgb <255/255, 251/255, 0/255>;
#declare CN_Liselotte_Syrup = rgb <221/255, 85/255, 17/255>;
#declare CN_Liseran_Purple = rgb <222/255, 111/255, 161/255>;
#declare CN_Lit = rgb <255/255, 254/255, 216/255>;
#declare CN_LitL_Buoy_Blew = rgb <214/255, 232/255, 225/255>;
#declare CN_Lite_Cocoa = rgb <181/255, 154/255, 141/255>;
#declare CN_Lite_Lavender = rgb <224/255, 218/255, 223/255>;
#declare CN_Lithic_Sand = rgb <83/255, 98/255, 110/255>;
#declare CN_Litmus = rgb <152/255, 149/255, 197/255>;
#declare CN_Little_Baby_Girl = rgb <248/255, 185/255, 212/255>;
#declare CN_Little_Bear = rgb <96/255, 75/255, 66/255>;
#declare CN_Little_Beaux_Blue = rgb <182/255, 211/255, 197/255>;
#declare CN_Little_Black_Dress = rgb <67/255, 72/255, 75/255>;
#declare CN_Little_Blue_Box = rgb <138/255, 197/255, 186/255>;
#declare CN_Little_Blue_Heron = rgb <60/255, 67/255, 120/255>;
#declare CN_Little_Bow_Pink = rgb <211/255, 124/255, 153/255>;
#declare CN_Little_Boy_Blu = rgb <199/255, 216/255, 219/255>;
#declare CN_Little_Boy_Blue = rgb <108/255, 160/255, 220/255>;
#declare CN_Little_Dipper = rgb <228/255, 230/255, 234/255>;
#declare CN_Little_Dove = rgb <235/255, 224/255, 206/255>;
#declare CN_Little_Lamb = rgb <234/255, 230/255, 215/255>;
#declare CN_Little_League = rgb <106/255, 154/255, 142/255>;
#declare CN_Little_Lilac = rgb <224/255, 216/255, 223/255>;
#declare CN_Little_Mermaid = rgb <45/255, 69/255, 74/255>;
#declare CN_Little_Pinky = rgb <244/255, 239/255, 237/255>;
#declare CN_Little_Pond = rgb <166/255, 209/255, 235/255>;
#declare CN_Little_Princess = rgb <230/255, 170/255, 193/255>;
#declare CN_Little_Red_Corvette = rgb <229/255, 1/255, 2/255>;
#declare CN_Little_Smile = rgb <248/255, 208/255, 232/255>;
#declare CN_Little_Sun_Dress = rgb <247/255, 200/255, 95/255>;
#declare CN_Little_Theater = rgb <115/255, 119/255, 143/255>;
#declare CN_Little_Touch = rgb <231/255, 207/255, 232/255>;
#declare CN_Little_Valley = rgb <164/255, 161/255, 145/255>;
#declare CN_Live_Jazz = rgb <135/255, 129/255, 155/255>;
#declare CN_Liveable_Green = rgb <206/255, 206/255, 189/255>;
#declare CN_Liveliness = rgb <255/255, 223/255, 185/255>;
#declare CN_Lively_Coral = rgb <230/255, 124/255, 122/255>;
#declare CN_Lively_Ivy = rgb <179/255, 174/255, 135/255>;
#declare CN_Lively_Laugh = rgb <225/255, 221/255, 142/255>;
#declare CN_Lively_Lavender = rgb <129/255, 111/255, 122/255>;
#declare CN_Lively_Light = rgb <161/255, 136/255, 153/255>;
#declare CN_Lively_Lilac = rgb <144/255, 150/255, 183/255>;
#declare CN_Lively_Tune = rgb <200/255, 216/255, 229/255>;
#declare CN_Lively_White = rgb <247/255, 243/255, 224/255>;
#declare CN_Lively_Yellow = rgb <255/255, 233/255, 177/255>;
#declare CN_Liver = rgb <83/255, 75/255, 79/255>;
#declare CN_Liver_Brown = rgb <81/255, 62/255, 50/255>;
#declare CN_Liver_Chestnut = rgb <152/255, 116/255, 86/255>;
#declare CN_Livery_Green = rgb <168/255, 210/255, 117/255>;
#declare CN_Livid = rgb <102/255, 136/255, 204/255>;
#declare CN_Livid_Brown = rgb <49/255, 42/255, 41/255>;
#declare CN_Livid_Lime = rgb <184/255, 225/255, 0/255>;
#declare CN_Living_Coral = rgb <255/255, 111/255, 97/255>;
#declare CN_Living_Large = rgb <200/255, 113/255, 99/255>;
#declare CN_Living_Stream = rgb <55/255, 112/255, 140/255>;
#declare CN_Livingston = rgb <163/255, 152/255, 128/255>;
#declare CN_Livingstone = rgb <203/255, 203/255, 187/255>;
#declare CN_Lizard = rgb <113/255, 100/255, 62/255>;
#declare CN_Lizard_Belly = rgb <204/255, 204/255, 51/255>;
#declare CN_Lizard_Breath = rgb <237/255, 187/255, 50/255>;
#declare CN_Lizard_Brown = rgb <121/255, 84/255, 25/255>;
#declare CN_Lizard_Green = rgb <129/255, 130/255, 110/255>;
#declare CN_Lizard_Legs = rgb <127/255, 105/255, 68/255>;
#declare CN_Llama_Wool = rgb <145/255, 120/255, 100/255>;
#declare CN_Loafer = rgb <219/255, 217/255, 194/255>;
#declare CN_Lobaria_Lichen = rgb <159/255, 200/255, 178/255>;
#declare CN_Lobby_Lilac = rgb <167/255, 128/255, 178/255>;
#declare CN_Lobelia = rgb <116/255, 152/255, 190/255>;
#declare CN_Loblolly = rgb <179/255, 187/255, 183/255>;
#declare CN_Lobster = rgb <187/255, 36/255, 12/255>;
#declare CN_Lobster_Bisque = rgb <221/255, 146/255, 137/255>;
#declare CN_Lobster_Brown = rgb <167/255, 56/255, 54/255>;
#declare CN_Lobster_Butter_Sauce = rgb <204/255, 136/255, 17/255>;
#declare CN_Local_Curry = rgb <203/255, 158/255, 52/255>;
#declare CN_Loch_Blue = rgb <96/255, 151/255, 149/255>;
#declare CN_Loch_Modan_Moss = rgb <223/255, 229/255, 191/255>;
#declare CN_Loch_Ness = rgb <95/255, 109/255, 176/255>;
#declare CN_Lochinvar = rgb <72/255, 144/255, 132/255>;
#declare CN_Lochmara = rgb <49/255, 110/255, 160/255>;
#declare CN_Lockhart = rgb <190/255, 154/255, 162/255>;
#declare CN_Locomotion = rgb <152/255, 129/255, 113/255>;
#declare CN_Locust = rgb <162/255, 165/255, 128/255>;
#declare CN_Loden_Frost = rgb <120/255, 143/255, 116/255>;
#declare CN_Loden_Green = rgb <110/255, 113/255, 83/255>;
#declare CN_Loden_Purple = rgb <85/255, 58/255, 118/255>;
#declare CN_Loden_Yellow = rgb <182/255, 139/255, 19/255>;
#declare CN_Lodgepole_Pines = rgb <172/255, 166/255, 144/255>;
#declare CN_Loft_Light = rgb <220/255, 202/255, 183/255>;
#declare CN_Loft_Space = rgb <203/255, 206/255, 205/255>;
#declare CN_Log_Cabin = rgb <112/255, 90/255, 70/255>;
#declare CN_Logan = rgb <157/255, 156/255, 180/255>;
#declare CN_Loganberry = rgb <90/255, 71/255, 105/255>;
#declare CN_Loggia = rgb <196/255, 183/255, 165/255>;
#declare CN_Loggia_Lights = rgb <225/255, 235/255, 222/255>;
#declare CN_Lol_Yellow = rgb <231/255, 205/255, 139/255>;
#declare CN_Lola = rgb <185/255, 172/255, 187/255>;
#declare CN_Lolita = rgb <191/255, 39/255, 53/255>;
#declare CN_Lollipop = rgb <204/255, 28/255, 59/255>;
#declare CN_Lolly = rgb <253/255, 151/255, 143/255>;
#declare CN_Lolly_Ice = rgb <166/255, 218/255, 208/255>;
#declare CN_London_Fog = rgb <162/255, 158/255, 146/255>;
#declare CN_London_Grey = rgb <102/255, 102/255, 119/255>;
#declare CN_London_Hue = rgb <174/255, 148/255, 171/255>;
#declare CN_London_Rain = rgb <0/255, 85/255, 187/255>;
#declare CN_London_Road = rgb <127/255, 135/255, 138/255>;
#declare CN_London_Square = rgb <127/255, 144/255, 157/255>;
#declare CN_Lone_Pine = rgb <87/255, 90/255, 68/255>;
#declare CN_Lone_Star = rgb <192/255, 148/255, 88/255>;
#declare CN_Lonely_Road = rgb <148/255, 119/255, 84/255>;
#declare CN_Lonestar = rgb <82/255, 36/255, 38/255>;
#declare CN_Long_Beach = rgb <250/255, 239/255, 223/255>;
#declare CN_Long_Forgotten_Purple = rgb <161/255, 117/255, 156/255>;
#declare CN_Long_Island_Sound = rgb <149/255, 208/255, 252/255>;
#declare CN_Long_Lake = rgb <104/255, 117/255, 126/255>;
#declare CN_Long_Spring = rgb <201/255, 117/255, 134/255>;
#declare CN_Long_Haul_Flight = rgb <0/255, 34/255, 119/255>;
#declare CN_Longans_Kernel = rgb <68/255, 33/255, 23/255>;
#declare CN_Longbeard_Grey = rgb <206/255, 206/255, 175/255>;
#declare CN_Longboat = rgb <96/255, 81/255, 58/255>;
#declare CN_Longfellow = rgb <144/255, 177/255, 163/255>;
#declare CN_Longlure_Frogfish = rgb <235/255, 216/255, 75/255>;
#declare CN_Longmeadow = rgb <119/255, 146/255, 138/255>;
#declare CN_Loofah = rgb <227/255, 211/255, 181/255>;
#declare CN_Look_At_Me_ = rgb <166/255, 126/255, 75/255>;
#declare CN_Look_at_the_Bright_Side = rgb <254/255, 191/255, 1/255>;
#declare CN_Looking_Glass = rgb <136/255, 135/255, 134/255>;
#declare CN_Loom_of_Fate = rgb <69/255, 65/255, 81/255>;
#declare CN_Loon_Turquoise = rgb <46/255, 102/255, 118/255>;
#declare CN_Looney_Blue = rgb <17/255, 255/255, 255/255>;
#declare CN_Loophole = rgb <203/255, 192/255, 179/255>;
#declare CN_Loose_Leather = rgb <132/255, 97/255, 61/255>;
#declare CN_Loquat_Brown = rgb <174/255, 124/255, 79/255>;
#declare CN_Lord_Baltimore = rgb <183/255, 103/255, 100/255>;
#declare CN_Lords_of_the_Night = rgb <102/255, 68/255, 136/255>;
#declare CN_Loren_Forest = rgb <80/255, 112/255, 45/255>;
#declare CN_Lorian = rgb <142/255, 188/255, 189/255>;
#declare CN_Lorna = rgb <101/255, 132/255, 119/255>;
#declare CN_Lost_at_Sea = rgb <141/255, 156/255, 167/255>;
#declare CN_Lost_Atlantis = rgb <95/255, 115/255, 136/255>;
#declare CN_Lost_Canyon = rgb <153/255, 142/255, 122/255>;
#declare CN_Lost_Golfer = rgb <116/255, 175/255, 84/255>;
#declare CN_Lost_in_Heaven = rgb <0/255, 36/255, 137/255>;
#declare CN_Lost_in_Istanbul = rgb <222/255, 232/255, 225/255>;
#declare CN_Lost_in_the_Woods = rgb <1/255, 68/255, 38/255>;
#declare CN_Lost_Lace = rgb <194/255, 235/255, 209/255>;
#declare CN_Lost_Lake = rgb <181/255, 173/255, 181/255>;
#declare CN_Lost_Lavender_Somewhere = rgb <141/255, 130/255, 140/255>;
#declare CN_Lost_Love = rgb <229/255, 215/255, 212/255>;
#declare CN_Lost_River = rgb <8/255, 69/255, 126/255>;
#declare CN_Lost_Soul_Grey = rgb <146/255, 149/255, 145/255>;
#declare CN_Lost_Summit = rgb <136/255, 122/255, 110/255>;
#declare CN_Lothern_Blue = rgb <102/255, 153/255, 204/255>;
#declare CN_Lotion = rgb <254/255, 253/255, 250/255>;
#declare CN_Lots_of_Bubbles = rgb <229/255, 236/255, 183/255>;
#declare CN_Lottery_Winnings = rgb <118/255, 131/255, 113/255>;
#declare CN_Lotti_Red = rgb <228/255, 0/255, 70/255>;
#declare CN_Lotus = rgb <139/255, 80/255, 75/255>;
#declare CN_Lotus_Flower = rgb <244/255, 240/255, 218/255>;
#declare CN_Lotus_Leaf = rgb <147/255, 167/255, 158/255>;
#declare CN_Lotus_Petal = rgb <242/255, 233/255, 220/255>;
#declare CN_Lotus_Pod = rgb <231/255, 215/255, 194/255>;
#declare CN_Lotus_Red = rgb <209/255, 113/255, 123/255>;
#declare CN_Loud_Lime = rgb <136/255, 255/255, 34/255>;
#declare CN_Loudicious_Pink = rgb <217/255, 47/255, 180/255>;
#declare CN_Louisiana_Mud = rgb <101/255, 88/255, 86/255>;
#declare CN_Loulou = rgb <76/255, 51/255, 71/255>;
#declare CN_Lounge_Green = rgb <139/255, 169/255, 127/255>;
#declare CN_Lounge_Leather = rgb <86/255, 62/255, 49/255>;
#declare CN_Lounge_Violet = rgb <94/255, 51/255, 109/255>;
#declare CN_Louvre = rgb <221/255, 195/255, 164/255>;
#declare CN_Lovable = rgb <200/255, 117/255, 112/255>;
#declare CN_Lovage_Green = rgb <152/255, 177/255, 166/255>;
#declare CN_Love_Affair = rgb <255/255, 190/255, 200/255>;
#declare CN_Love_at_First_Sight = rgb <229/255, 165/255, 177/255>;
#declare CN_Love_Bird = rgb <186/255, 91/255, 106/255>;
#declare CN_Love_In_A_Mist = rgb <225/255, 185/255, 194/255>;
#declare CN_Love_Juice = rgb <204/255, 17/255, 85/255>;
#declare CN_Love_Letter = rgb <228/255, 101/255, 142/255>;
#declare CN_Love_Poem = rgb <160/255, 101/255, 130/255>;
#declare CN_Love_Potion = rgb <192/255, 19/255, 82/255>;
#declare CN_Love_Priestess = rgb <187/255, 85/255, 204/255>;
#declare CN_Love_Red = rgb <255/255, 73/255, 108/255>;
#declare CN_Love_Spell = rgb <248/255, 180/255, 196/255>;
#declare CN_Love_Struck_Chinchilla = rgb <174/255, 174/255, 183/255>;
#declare CN_Loveable = rgb <240/255, 193/255, 198/255>;
#declare CN_Lovebirds = rgb <199/255, 106/255, 119/255>;
#declare CN_Lovecloud = rgb <238/255, 187/255, 238/255>;
#declare CN_Loveliest_Leaves = rgb <166/255, 154/255, 92/255>;
#declare CN_Lovelight = rgb <247/255, 214/255, 216/255>;
#declare CN_Lovely_Euphoric_Delight = rgb <255/255, 238/255, 255/255>;
#declare CN_Lovely_Harmony = rgb <244/255, 219/255, 220/255>;
#declare CN_Lovely_Lavender = rgb <214/255, 210/255, 221/255>;
#declare CN_Lovely_Lemonade = rgb <233/255, 221/255, 34/255>;
#declare CN_Lovely_Lilac = rgb <167/255, 176/255, 204/255>;
#declare CN_Lovely_Linen = rgb <219/255, 206/255, 172/255>;
#declare CN_Lovely_Pink = rgb <216/255, 191/255, 212/255>;
#declare CN_Lovers_Hideaway = rgb <208/255, 198/255, 181/255>;
#declare CN_Lovers_Kiss = rgb <143/255, 59/255, 61/255>;
#declare CN_Lovers_Knot = rgb <242/255, 219/255, 219/255>;
#declare CN_Lovers_Leap = rgb <149/255, 126/255, 104/255>;
#declare CN_Lovers_Retreat = rgb <244/255, 206/255, 216/255>;
#declare CN_Lovers_Tryst = rgb <180/255, 140/255, 163/255>;
#declare CN_Lower_Green = rgb <224/255, 239/255, 227/255>;
#declare CN_Lower_Lavender = rgb <220/255, 223/255, 239/255>;
#declare CN_Lower_Lilac = rgb <226/255, 214/255, 216/255>;
#declare CN_Lower_Lime = rgb <230/255, 241/255, 222/255>;
#declare CN_Lower_Linen = rgb <224/255, 220/255, 216/255>;
#declare CN_Lower_Lip = rgb <247/255, 70/255, 138/255>;
#declare CN_Loyal = rgb <210/255, 225/255, 240/255>;
#declare CN_Loyal_Blue = rgb <1/255, 69/255, 94/255>;
#declare CN_Loyalty = rgb <78/255, 97/255, 117/255>;
#declare CN_Lu_Se_Green = rgb <2/255, 193/255, 77/255>;
#declare CN_Luau_Green = rgb <152/255, 151/255, 70/255>;
#declare CN_Lucario_Blue = rgb <11/255, 131/255, 181/255>;
#declare CN_Lucea = rgb <124/255, 175/255, 225/255>;
#declare CN_Lucent_Lime = rgb <0/255, 255/255, 51/255>;
#declare CN_Lucent_Yellow = rgb <228/255, 208/255, 165/255>;
#declare CN_Lucerne = rgb <119/255, 184/255, 124/255>;
#declare CN_Lucid_Blue = rgb <126/255, 141/255, 159/255>;
#declare CN_Lucidity = rgb <30/255, 68/255, 105/255>;
#declare CN_Lucinda = rgb <166/255, 187/255, 183/255>;
#declare CN_Lucius_Lilac = rgb <186/255, 162/255, 206/255>;
#declare CN_Luck_of_the_Irish = rgb <84/255, 120/255, 57/255>;
#declare CN_Lucky = rgb <171/255, 154/255, 28/255>;
#declare CN_Lucky_Bamboo = rgb <147/255, 131/255, 75/255>;
#declare CN_Lucky_Clover = rgb <0/255, 132/255, 0/255>;
#declare CN_Lucky_Day = rgb <146/255, 154/255, 125/255>;
#declare CN_Lucky_Dog = rgb <211/255, 200/255, 186/255>;
#declare CN_Lucky_Duck = rgb <244/255, 236/255, 215/255>;
#declare CN_Lucky_Green = rgb <35/255, 134/255, 82/255>;
#declare CN_Lucky_Lime = rgb <154/255, 205/255, 50/255>;
#declare CN_Lucky_Lobster = rgb <204/255, 51/255, 34/255>;
#declare CN_Lucky_Orange = rgb <255/255, 119/255, 0/255>;
#declare CN_Lucky_Penny = rgb <188/255, 111/255, 55/255>;
#declare CN_Lucky_Point = rgb <41/255, 45/255, 79/255>;
#declare CN_Lucky_Potato = rgb <239/255, 234/255, 216/255>;
#declare CN_Lucky_Shamrock = rgb <72/255, 122/255, 123/255>;
#declare CN_Ludicrous_Lemming = rgb <187/255, 136/255, 119/255>;
#declare CN_Lugganath_Orange = rgb <247/255, 165/255, 139/255>;
#declare CN_Luigi = rgb <76/255, 187/255, 23/255>;
#declare CN_Lull_Wind = rgb <195/255, 213/255, 232/255>;
#declare CN_Lullaby = rgb <203/255, 212/255, 212/255>;
#declare CN_Lumber = rgb <255/255, 228/255, 205/255>;
#declare CN_Lumberjack = rgb <157/255, 69/255, 66/255>;
#declare CN_Luminary = rgb <255/255, 254/255, 237/255>;
#declare CN_Luminary_Green = rgb <227/255, 234/255, 165/255>;
#declare CN_Luminescent_Blue = rgb <164/255, 221/255, 233/255>;
#declare CN_Luminescent_Green = rgb <118/255, 156/255, 24/255>;
#declare CN_Luminescent_Lime = rgb <185/255, 255/255, 102/255>;
#declare CN_Luminescent_Pink = rgb <249/255, 132/255, 239/255>;
#declare CN_Luminescent_Sky = rgb <202/255, 255/255, 251/255>;
#declare CN_Luminous_Light = rgb <187/255, 174/255, 185/255>;
#declare CN_Luminous_Pink = rgb <220/255, 108/255, 132/255>;
#declare CN_Luminous_Yellow = rgb <254/255, 227/255, 127/255>;
#declare CN_Lump_of_Coal = rgb <78/255, 81/255, 84/255>;
#declare CN_Luna_Light = rgb <194/255, 206/255, 202/255>;
#declare CN_Luna_Moon = rgb <236/255, 234/255, 225/255>;
#declare CN_Luna_Moona = rgb <112/255, 193/255, 201/255>;
#declare CN_Luna_Pier = rgb <65/255, 77/255, 98/255>;
#declare CN_Lunar_Basalt = rgb <104/255, 107/255, 103/255>;
#declare CN_Lunar_Base = rgb <135/255, 135/255, 134/255>;
#declare CN_Lunar_Dust = rgb <204/255, 204/255, 221/255>;
#declare CN_Lunar_Eclipse = rgb <65/255, 80/255, 83/255>;
#declare CN_Lunar_Federation = rgb <134/255, 131/255, 129/255>;
#declare CN_Lunar_Green = rgb <78/255, 85/255, 65/255>;
#declare CN_Lunar_Lander = rgb <222/255, 206/255, 158/255>;
#declare CN_Lunar_Landing = rgb <210/255, 207/255, 193/255>;
#declare CN_Lunar_Launch_Site = rgb <147/255, 134/255, 115/255>;
#declare CN_Lunar_Light = rgb <155/255, 149/255, 156/255>;
#declare CN_Lunar_Lite = rgb <224/255, 221/255, 216/255>;
#declare CN_Lunar_Outpost = rgb <130/255, 130/255, 135/255>;
#declare CN_Lunar_Rays = rgb <202/255, 206/255, 210/255>;
#declare CN_Lunar_Rock = rgb <197/255, 197/255, 197/255>;
#declare CN_Lunar_Shadow = rgb <112/255, 118/255, 133/255>;
#declare CN_Lunar_Surface = rgb <182/255, 185/255, 182/255>;
#declare CN_Lunar_Tide = rgb <111/255, 150/255, 139/255>;
#declare CN_Lunaria = rgb <247/255, 231/255, 205/255>;
#declare CN_Lunatic_Lynx = rgb <221/255, 170/255, 136/255>;
#declare CN_Lunatic_Sky_Dancer = rgb <118/255, 253/255, 168/255>;
#declare CN_Lunch_Box = rgb <242/255, 202/255, 149/255>;
#declare CN_Lunette = rgb <208/255, 200/255, 198/255>;
#declare CN_Lupin_Grey = rgb <209/255, 224/255, 233/255>;
#declare CN_Lupine = rgb <190/255, 156/255, 193/255>;
#declare CN_Lupine_Blue = rgb <106/255, 150/255, 186/255>;
#declare CN_Lurid_Lettuce = rgb <180/255, 243/255, 25/255>;
#declare CN_Lurid_Pink = rgb <255/255, 51/255, 238/255>;
#declare CN_Lurid_Red = rgb <255/255, 68/255, 0/255>;
#declare CN_Luscious = rgb <144/255, 61/255, 73/255>;
#declare CN_Luscious_Lavender = rgb <105/255, 105/255, 135/255>;
#declare CN_Luscious_Leek = rgb <187/255, 204/255, 34/255>;
#declare CN_Luscious_Lemon = rgb <238/255, 189/255, 106/255>;
#declare CN_Luscious_Lemongrass = rgb <81/255, 121/255, 51/255>;
#declare CN_Luscious_Lime = rgb <145/255, 166/255, 115/255>;
#declare CN_Luscious_Lobster = rgb <197/255, 132/255, 124/255>;
#declare CN_Luscious_Purple = rgb <96/255, 92/255, 113/255>;
#declare CN_Lush = rgb <197/255, 189/255, 160/255>;
#declare CN_Lush_Aqua = rgb <0/255, 68/255, 102/255>;
#declare CN_Lush_Bamboo = rgb <175/255, 187/255, 51/255>;
#declare CN_Lush_Garden = rgb <0/255, 136/255, 17/255>;
#declare CN_Lush_Grass = rgb <68/255, 82/255, 67/255>;
#declare CN_Lush_Green = rgb <187/255, 238/255, 0/255>;
#declare CN_Lush_Greenery = rgb <127/255, 242/255, 62/255>;
#declare CN_Lush_Honeycomb = rgb <252/255, 168/255, 27/255>;
#declare CN_Lush_Hosta = rgb <108/255, 118/255, 92/255>;
#declare CN_Lush_Life = rgb <233/255, 246/255, 224/255>;
#declare CN_Lush_Lilac = rgb <157/255, 126/255, 183/255>;
#declare CN_Lush_Mauve = rgb <160/255, 145/255, 183/255>;
#declare CN_Lush_Meadow = rgb <0/255, 110/255, 81/255>;
#declare CN_Lush_Plains = rgb <34/255, 187/255, 34/255>;
#declare CN_Lush_Ungoro_Crater = rgb <84/255, 166/255, 77/255>;
#declare CN_Lust = rgb <230/255, 32/255, 32/255>;
#declare CN_Lust_Priestess = rgb <187/255, 51/255, 136/255>;
#declare CN_Luster_Green = rgb <190/255, 206/255, 97/255>;
#declare CN_Luster_White = rgb <244/255, 241/255, 236/255>;
#declare CN_Lustful_Wishes = rgb <204/255, 68/255, 153/255>;
#declare CN_Lustrian_Undergrowth = rgb <65/255, 90/255, 9/255>;
#declare CN_Lustrous_Yellow = rgb <230/255, 218/255, 120/255>;
#declare CN_Lusty_Lavender = rgb <141/255, 94/255, 183/255>;
#declare CN_Lusty_Lips = rgb <213/255, 23/255, 78/255>;
#declare CN_Lusty_Lizard = rgb <0/255, 187/255, 17/255>;
#declare CN_Lusty_Orange = rgb <239/255, 175/255, 167/255>;
#declare CN_Lusty_Red = rgb <177/255, 56/255, 61/255>;
#declare CN_Lusty_Gallant = rgb <255/255, 204/255, 204/255>;
#declare CN_Luxe_Blue = rgb <81/255, 101/255, 130/255>;
#declare CN_Luxe_Lilac = rgb <168/255, 163/255, 177/255>;
#declare CN_Luxor_Blue = rgb <189/255, 233/255, 229/255>;
#declare CN_Luxor_Gold = rgb <171/255, 141/255, 63/255>;
#declare CN_Luxurious_Lime = rgb <136/255, 238/255, 34/255>;
#declare CN_Luxurious_Red = rgb <134/255, 58/255, 66/255>;
#declare CN_Luxury = rgb <129/255, 142/255, 177/255>;
#declare CN_Lviv_Blue = rgb <56/255, 65/255, 114/255>;
#declare CN_Lvivian_Rain = rgb <1/255, 130/255, 204/255>;
#declare CN_Lyceum_Was_Lycra_Strip_ = rgb <173/255, 207/255, 67/255>;
#declare CN_Lychee = rgb <186/255, 11/255, 50/255>;
#declare CN_Lychee_Pulp = rgb <247/255, 242/255, 218/255>;
#declare CN_Lye = rgb <158/255, 148/255, 120/255>;
#declare CN_Lye_Tinted = rgb <127/255, 107/255, 93/255>;
#declare CN_Lyman_Camellia = rgb <229/255, 199/255, 185/255>;
#declare CN_Lynch = rgb <105/255, 125/255, 137/255>;
#declare CN_Lynx = rgb <96/255, 77/255, 71/255>;
#declare CN_Lynx_Screen_Blue = rgb <44/255, 177/255, 235/255>;
#declare CN_Lynx_White = rgb <247/255, 247/255, 247/255>;
#declare CN_Lyons_Blue = rgb <0/255, 88/255, 113/255>;
#declare CN_Lyrebird = rgb <0/255, 135/255, 173/255>;
#declare CN_Lyric_Blue = rgb <114/255, 135/255, 145/255>;
#declare CN_Lythrum = rgb <114/255, 105/255, 111/255>;
#declare CN_M_Bison = rgb <180/255, 2/255, 61/255>;
#declare CN_Ma_White = rgb <244/255, 247/255, 253/255>;
#declare CN_Maastricht_Blue = rgb <0/255, 28/255, 61/255>;
#declare CN_Mabel = rgb <203/255, 232/255, 232/255>;
#declare CN_Mac_N_Cheese = rgb <228/255, 176/255, 112/255>;
#declare CN_Macabre = rgb <136/255, 0/255, 51/255>;
#declare CN_Macadamia = rgb <228/255, 207/255, 182/255>;
#declare CN_Macadamia_Beige = rgb <247/255, 223/255, 186/255>;
#declare CN_Macadamia_Brown = rgb <187/255, 167/255, 145/255>;
#declare CN_Macadamia_Nut = rgb <238/255, 227/255, 221/255>;
#declare CN_Macaroni = rgb <243/255, 208/255, 133/255>;
#declare CN_Macaroni_and_Cheese = rgb <255/255, 185/255, 123/255>;
#declare CN_Macaroon = rgb <179/255, 139/255, 113/255>;
#declare CN_Macaroon_Cream = rgb <254/255, 232/255, 214/255>;
#declare CN_Macaroon_Rose = rgb <247/255, 82/255, 128/255>;
#declare CN_Macau = rgb <70/255, 194/255, 153/255>;
#declare CN_Macaw = rgb <255/255, 189/255, 36/255>;
#declare CN_Macaw_Green = rgb <155/255, 181/255, 62/255>;
#declare CN_Macchiato = rgb <146/255, 129/255, 104/255>;
#declare CN_Macharius_Solar_Orange = rgb <221/255, 68/255, 0/255>;
#declare CN_Machine_Green = rgb <166/255, 162/255, 63/255>;
#declare CN_Machine_Gun_Metal = rgb <69/255, 69/255, 69/255>;
#declare CN_Machine_Oil = rgb <241/255, 231/255, 130/255>;
#declare CN_Machinery = rgb <153/255, 153/255, 170/255>;
#declare CN_Machu_Picchu_Gardens = rgb <153/255, 187/255, 51/255>;
#declare CN_Mack_Creek = rgb <191/255, 174/255, 91/255>;
#declare CN_MacKintosh_Midnight = rgb <65/255, 67/255, 78/255>;
#declare CN_Macquarie = rgb <0/255, 125/255, 130/255>;
#declare CN_Macragge_Blue = rgb <0/255, 69/255, 119/255>;
#declare CN_Maculata_Bark = rgb <173/255, 165/255, 163/255>;
#declare CN_Mad_For_Mango = rgb <248/255, 162/255, 0/255>;
#declare CN_Madagascar = rgb <157/255, 133/255, 68/255>;
#declare CN_Madagascar_Pink = rgb <209/255, 148/255, 161/255>;
#declare CN_Madam_Butterfly = rgb <124/255, 167/255, 203/255>;
#declare CN_Madame_Mauve = rgb <181/255, 173/255, 180/255>;
#declare CN_Madang = rgb <183/255, 227/255, 168/255>;
#declare CN_Madder = rgb <117/255, 76/255, 80/255>;
#declare CN_Madder_Blue = rgb <181/255, 182/255, 206/255>;
#declare CN_Madder_Brown = rgb <106/255, 51/255, 49/255>;
#declare CN_Madder_Lake = rgb <204/255, 51/255, 54/255>;
#declare CN_Madder_Magenta = rgb <128/255, 73/255, 110/255>;
#declare CN_Madder_Orange = rgb <241/255, 190/255, 176/255>;
#declare CN_Madder_Red = rgb <183/255, 40/255, 46/255>;
#declare CN_Madder_Rose = rgb <238/255, 187/255, 203/255>;
#declare CN_Made_of_Steel = rgb <91/255, 104/255, 111/255>;
#declare CN_Madeira_Brown = rgb <143/255, 72/255, 38/255>;
#declare CN_Mademoiselle_Pink = rgb <245/255, 4/255, 201/255>;
#declare CN_Madera = rgb <238/255, 208/255, 157/255>;
#declare CN_Madison = rgb <45/255, 60/255, 84/255>;
#declare CN_Madison_Avenue = rgb <61/255, 62/255, 62/255>;
#declare CN_Madonna = rgb <63/255, 66/255, 80/255>;
#declare CN_Madonna_Blue = rgb <113/255, 181/255, 209/255>;
#declare CN_Madonna_Lily = rgb <238/255, 230/255, 219/255>;
#declare CN_Madras = rgb <71/255, 62/255, 35/255>;
#declare CN_Madras_Blue = rgb <154/255, 195/255, 218/255>;
#declare CN_Madrid_Beige = rgb <236/255, 191/255, 159/255>;
#declare CN_Madrileno_Maroon = rgb <143/255, 0/255, 58/255>;
#declare CN_Magenta = rgb <255/255, 0/255, 255/255>;
#declare CN_Magenta_Affair = rgb <170/255, 68/255, 221/255>;
#declare CN_Magenta_Crayon = rgb <255/255, 85/255, 163/255>;
#declare CN_Magenta_Dye = rgb <202/255, 31/255, 123/255>;
#declare CN_Magenta_Elephant = rgb <222/255, 1/255, 112/255>;
#declare CN_Magenta_Haze = rgb <157/255, 68/255, 110/255>;
#declare CN_Magenta_Ink = rgb <81/255, 61/255, 60/255>;
#declare CN_Magenta_Pink = rgb <204/255, 51/255, 139/255>;
#declare CN_Magenta_Purple = rgb <107/255, 38/255, 75/255>;
#declare CN_Magenta_Red = rgb <145/255, 57/255, 119/255>;
#declare CN_Magenta_Red_Lips = rgb <98/255, 65/255, 109/255>;
#declare CN_Magenta_Stream = rgb <250/255, 95/255, 247/255>;
#declare CN_Magenta_Twilight = rgb <187/255, 152/255, 159/255>;
#declare CN_Magenta_Violet = rgb <108/255, 83/255, 137/255>;
#declare CN_Magentarama = rgb <207/255, 52/255, 118/255>;
#declare CN_Magentella = rgb <213/255, 33/255, 184/255>;
#declare CN_Magentle = rgb <170/255, 17/255, 170/255>;
#declare CN_Maggies_Magic = rgb <221/255, 238/255, 226/255>;
#declare CN_Magic = rgb <101/255, 107/255, 120/255>;
#declare CN_Magic_Blade = rgb <68/255, 221/255, 0/255>;
#declare CN_Magic_Blue = rgb <62/255, 139/255, 170/255>;
#declare CN_Magic_Carpet = rgb <148/255, 136/255, 190/255>;
#declare CN_Magic_Dust = rgb <129/255, 124/255, 133/255>;
#declare CN_Magic_Fountain = rgb <31/255, 117/255, 255/255>;
#declare CN_Magic_Gem = rgb <142/255, 114/255, 130/255>;
#declare CN_Magic_Ink = rgb <2/255, 71/255, 254/255>;
#declare CN_Magic_Lamp = rgb <194/255, 162/255, 96/255>;
#declare CN_Magic_Magenta = rgb <127/255, 71/255, 116/255>;
#declare CN_Magic_Malt = rgb <165/255, 136/255, 126/255>;
#declare CN_Magic_Melon = rgb <222/255, 152/255, 81/255>;
#declare CN_Magic_Metal = rgb <63/255, 57/255, 37/255>;
#declare CN_Magic_Mint = rgb <170/255, 240/255, 209/255>;
#declare CN_Magic_Moment = rgb <117/255, 124/255, 175/255>;
#declare CN_Magic_Moments = rgb <233/255, 219/255, 224/255>;
#declare CN_Magic_Mountain = rgb <113/255, 116/255, 98/255>;
#declare CN_Magic_Night = rgb <58/255, 59/255, 91/255>;
#declare CN_Magic_Potion = rgb <255/255, 68/255, 102/255>;
#declare CN_Magic_Sage = rgb <89/255, 133/255, 86/255>;
#declare CN_Magic_Sail = rgb <224/255, 210/255, 186/255>;
#declare CN_Magic_Scent = rgb <204/255, 201/255, 215/255>;
#declare CN_Magic_Spell = rgb <84/255, 79/255, 102/255>;
#declare CN_Magic_Wand = rgb <195/255, 217/255, 228/255>;
#declare CN_Magic_Whale = rgb <23/255, 3/255, 74/255>;
#declare CN_Magical = rgb <193/255, 206/255, 218/255>;
#declare CN_Magical_Malachite = rgb <34/255, 204/255, 136/255>;
#declare CN_Magical_Mauve = rgb <186/255, 163/255, 169/255>;
#declare CN_Magical_Melon = rgb <233/255, 233/255, 208/255>;
#declare CN_Magical_Merlin = rgb <61/255, 142/255, 208/255>;
#declare CN_Magical_Moonlight = rgb <240/255, 238/255, 235/255>;
#declare CN_Magical_Stardust = rgb <234/255, 234/255, 219/255>;
#declare CN_Magma = rgb <255/255, 78/255, 1/255>;
#declare CN_Magna_Cum_Laude = rgb <221/255, 0/255, 102/255>;
#declare CN_Magnesia_Bay = rgb <100/255, 191/255, 220/255>;
#declare CN_Magnesium = rgb <193/255, 194/255, 195/255>;
#declare CN_Magnet = rgb <77/255, 75/255, 79/255>;
#declare CN_Magnetic_Blue = rgb <5/255, 76/255, 138/255>;
#declare CN_Magnetic_Gray = rgb <178/255, 181/255, 175/255>;
#declare CN_Magnetic_Green = rgb <43/255, 104/255, 103/255>;
#declare CN_Magnetic_Grey = rgb <131/255, 135/255, 137/255>;
#declare CN_Magnetic_Magic = rgb <63/255, 187/255, 178/255>;
#declare CN_Magnetos = rgb <191/255, 60/255, 255/255>;
#declare CN_Magnificence = rgb <127/255, 85/255, 111/255>;
#declare CN_Magnificent_Magenta = rgb <238/255, 34/255, 170/255>;
#declare CN_Magnitude = rgb <174/255, 141/255, 123/255>;
#declare CN_Magnolia = rgb <255/255, 249/255, 228/255>;
#declare CN_Magnolia_Blossom = rgb <244/255, 231/255, 206/255>;
#declare CN_Magnolia_Petal = rgb <247/255, 238/255, 227/255>;
#declare CN_Magnolia_Pink = rgb <236/255, 185/255, 179/255>;
#declare CN_Magnolia_Spray = rgb <246/255, 230/255, 203/255>;
#declare CN_Magnolia_Spring = rgb <244/255, 242/255, 231/255>;
#declare CN_Magnolia_White = rgb <216/255, 191/255, 200/255>;
#declare CN_Magnus_Blue = rgb <0/255, 54/255, 134/255>;
#declare CN_Magos = rgb <105/255, 71/255, 90/255>;
#declare CN_Maharaja = rgb <63/255, 53/255, 79/255>;
#declare CN_Mahogany = rgb <192/255, 64/255, 0/255>;
#declare CN_Mahogany_Brown = rgb <129/255, 35/255, 8/255>;
#declare CN_Mahogany_Cherry = rgb <130/255, 73/255, 90/255>;
#declare CN_Mahogany_Finish = rgb <170/255, 85/255, 17/255>;
#declare CN_Mahogany_Rose = rgb <197/255, 161/255, 147/255>;
#declare CN_Mahogany_Spice = rgb <91/255, 70/255, 70/255>;
#declare CN_Mahonia_Berry_Blue = rgb <98/255, 120/255, 142/255>;
#declare CN_Mai_Tai = rgb <165/255, 101/255, 49/255>;
#declare CN_Maiden_Hair = rgb <245/255, 233/255, 202/255>;
#declare CN_Maiden_Mist = rgb <185/255, 192/255, 192/255>;
#declare CN_Maiden_of_the_Mist = rgb <239/255, 220/255, 235/255>;
#declare CN_Maiden_Pink = rgb <255/255, 47/255, 235/255>;
#declare CN_Maiden_Voyage = rgb <138/255, 199/255, 212/255>;
#declare CN_Maidens_Blush = rgb <243/255, 211/255, 191/255>;
#declare CN_Maidenhair_Fern = rgb <68/255, 118/255, 74/255>;
#declare CN_Maiko = rgb <216/255, 186/255, 166/255>;
#declare CN_Main_Mast_Gold = rgb <183/255, 148/255, 0/255>;
#declare CN_Maine_Anjou_Cattle = rgb <169/255, 82/255, 73/255>;
#declare CN_Mainsail = rgb <217/255, 223/255, 226/255>;
#declare CN_Maire = rgb <42/255, 41/255, 34/255>;
#declare CN_Maison_Blanche = rgb <223/255, 210/255, 191/255>;
#declare CN_Maison_De_Campagne = rgb <187/255, 155/255, 125/255>;
#declare CN_Maison_Verte = rgb <229/255, 240/255, 217/255>;
#declare CN_Maize = rgb <244/255, 208/255, 84/255>;
#declare CN_Maizena = rgb <251/255, 236/255, 94/255>;
#declare CN_Majestic = rgb <93/255, 66/255, 80/255>;
#declare CN_Majestic_Blue = rgb <63/255, 66/255, 92/255>;
#declare CN_Majestic_Eggplant = rgb <68/255, 51/255, 136/255>;
#declare CN_Majestic_Magenta = rgb <238/255, 68/255, 136/255>;
#declare CN_Majestic_Magic = rgb <85/255, 85/255, 112/255>;
#declare CN_Majestic_Mount = rgb <124/255, 128/255, 145/255>;
#declare CN_Majestic_Mountain = rgb <68/255, 119/255, 136/255>;
#declare CN_Majestic_Orchid = rgb <141/255, 87/255, 109/255>;
#declare CN_Majestic_Plum = rgb <128/255, 97/255, 115/255>;
#declare CN_Majestic_Purple = rgb <101/255, 96/255, 140/255>;
#declare CN_Majestic_Violet = rgb <157/255, 154/255, 196/255>;
#declare CN_Majesty = rgb <89/255, 55/255, 97/255>;
#declare CN_Majin_Bu_Pink = rgb <255/255, 170/255, 204/255>;
#declare CN_Majolica_Blue = rgb <39/255, 67/255, 87/255>;
#declare CN_Majolica_Earthenware = rgb <151/255, 99/255, 82/255>;
#declare CN_Majolica_Green = rgb <174/255, 176/255, 143/255>;
#declare CN_Majolica_Mauve = rgb <160/255, 137/255, 144/255>;
#declare CN_Major_Blue = rgb <40/255, 158/255, 196/255>;
#declare CN_Major_Brown = rgb <91/255, 81/255, 73/255>;
#declare CN_Major_Tom = rgb <0/255, 17/255, 119/255>;
#declare CN_Majorca_Blue = rgb <74/255, 156/255, 149/255>;
#declare CN_Majorelle_Blue = rgb <96/255, 80/255, 220/255>;
#declare CN_Majorelle_Gardens = rgb <51/255, 119/255, 102/255>;
#declare CN_Makara = rgb <105/255, 95/255, 80/255>;
#declare CN_Make_Up_Blue = rgb <51/255, 95/255, 141/255>;
#declare CN_Makin_it_Rain = rgb <136/255, 187/255, 85/255>;
#declare CN_Mako = rgb <80/255, 85/255, 85/255>;
#declare CN_Makore_Veneer_Red = rgb <110/255, 47/255, 44/255>;
#declare CN_Malabar = rgb <207/255, 190/255, 169/255>;
#declare CN_Malachite = rgb <11/255, 218/255, 81/255>;
#declare CN_Malachite_Blue_Turquoise = rgb <14/255, 79/255, 79/255>;
#declare CN_Malachite_Green = rgb <0/255, 78/255, 0/255>;
#declare CN_Malaga = rgb <159/255, 80/255, 105/255>;
#declare CN_Malarca = rgb <110/255, 125/255, 110/255>;
#declare CN_Malaysian_Mist = rgb <184/255, 209/255, 208/255>;
#declare CN_Maldives = rgb <0/255, 187/255, 221/255>;
#declare CN_Male = rgb <214/255, 206/255, 195/255>;
#declare CN_Male_Betta = rgb <52/255, 118/255, 153/255>;
#declare CN_Malevolent_Mauve = rgb <187/255, 102/255, 136/255>;
#declare CN_Malibu = rgb <102/255, 183/255, 225/255>;
#declare CN_Malibu_Beige = rgb <201/255, 192/255, 177/255>;
#declare CN_Malibu_Blue = rgb <0/255, 140/255, 193/255>;
#declare CN_Malibu_Coast = rgb <231/255, 207/255, 194/255>;
#declare CN_Malibu_Dune = rgb <231/255, 206/255, 181/255>;
#declare CN_Malibu_Peach = rgb <253/255, 200/255, 179/255>;
#declare CN_Malibu_Sun = rgb <255/255, 242/255, 217/255>;
#declare CN_Mallard = rgb <37/255, 72/255, 85/255>;
#declare CN_Mallard_Blue = rgb <58/255, 92/255, 110/255>;
#declare CN_Mallard_Green = rgb <71/255, 136/255, 101/255>;
#declare CN_Mallard_Lake = rgb <145/255, 185/255, 194/255>;
#declare CN_Mallards_Egg = rgb <248/255, 242/255, 216/255>;
#declare CN_Mallardish = rgb <58/255, 69/255, 49/255>;
#declare CN_Mallorca_Blue = rgb <81/255, 123/255, 149/255>;
#declare CN_Malmoe_FF = rgb <167/255, 215/255, 255/255>;
#declare CN_Malt = rgb <221/255, 207/255, 188/255>;
#declare CN_Malt_Shake = rgb <187/255, 168/255, 127/255>;
#declare CN_Malta = rgb <165/255, 151/255, 132/255>;
#declare CN_Malted = rgb <219/255, 200/255, 192/255>;
#declare CN_Malted_Milk = rgb <232/255, 217/255, 206/255>;
#declare CN_Malted_Mint = rgb <191/255, 214/255, 200/255>;
#declare CN_Malted_Mint_Madness = rgb <17/255, 221/255, 170/255>;
#declare CN_Mama_Africa = rgb <85/255, 17/255, 17/255>;
#declare CN_Mama_Racoon = rgb <89/255, 79/255, 64/255>;
#declare CN_Mamala_Bay = rgb <0/255, 94/255, 140/255>;
#declare CN_Mamba = rgb <118/255, 109/255, 124/255>;
#declare CN_Mamba_Green = rgb <119/255, 173/255, 59/255>;
#declare CN_Mamey = rgb <235/255, 161/255, 128/255>;
#declare CN_Mamie_Pink = rgb <238/255, 130/255, 238/255>;
#declare CN_Mammary_Red = rgb <176/255, 11/255, 30/255>;
#declare CN_Mammoth_Mountain = rgb <59/255, 106/255, 122/255>;
#declare CN_Mammoth_Wool = rgb <153/255, 85/255, 34/255>;
#declare CN_Man_Cave = rgb <129/255, 96/255, 69/255>;
#declare CN_Man_Friday = rgb <60/255, 76/255, 93/255>;
#declare CN_Mana = rgb <176/255, 151/255, 55/255>;
#declare CN_Mana_Tree = rgb <79/255, 121/255, 66/255>;
#declare CN_Manakin = rgb <148/255, 187/255, 218/255>;
#declare CN_Manatee = rgb <141/255, 144/255, 161/255>;
#declare CN_Manchester = rgb <101/255, 145/255, 109/255>;
#declare CN_Manchester_Brown = rgb <80/255, 68/255, 64/255>;
#declare CN_Manchester_Nights = rgb <153/255, 34/255, 34/255>;
#declare CN_Mandalay = rgb <181/255, 123/255, 46/255>;
#declare CN_Mandalay_Road = rgb <160/255, 95/255, 69/255>;
#declare CN_Mandarin = rgb <243/255, 122/255, 72/255>;
#declare CN_Mandarin_Essence = rgb <238/255, 153/255, 68/255>;
#declare CN_Mandarin_Jelly = rgb <255/255, 136/255, 0/255>;
#declare CN_Mandarin_Orange = rgb <236/255, 106/255, 55/255>;
#declare CN_Mandarin_Peel = rgb <255/255, 159/255, 0/255>;
#declare CN_Mandarin_Red = rgb <231/255, 74/255, 51/255>;
#declare CN_Mandarin_Sorbet = rgb <255/255, 174/255, 66/255>;
#declare CN_Mandarin_Sugar = rgb <246/255, 231/255, 225/255>;
#declare CN_Mandarin_Tusk = rgb <216/255, 212/255, 211/255>;
#declare CN_Mandrake = rgb <136/255, 137/255, 160/255>;
#declare CN_Mandu_Dumpling = rgb <198/255, 192/255, 166/255>;
#declare CN_Mandy = rgb <205/255, 82/255, 91/255>;
#declare CN_Mandys_Pink = rgb <245/255, 183/255, 153/255>;
#declare CN_Mangala_Pink = rgb <231/255, 129/255, 166/255>;
#declare CN_Manganese_Black = rgb <32/255, 47/255, 75/255>;
#declare CN_Manganese_Red = rgb <229/255, 43/255, 80/255>;
#declare CN_Maangata = rgb <157/255, 188/255, 212/255>;
#declare CN_Mango = rgb <255/255, 166/255, 43/255>;
#declare CN_Mango_Brown = rgb <187/255, 132/255, 52/255>;
#declare CN_Mango_Cheesecake = rgb <251/255, 237/255, 218/255>;
#declare CN_Mango_Green = rgb <150/255, 255/255, 0/255>;
#declare CN_Mango_Loco = rgb <254/255, 184/255, 28/255>;
#declare CN_Mango_Madness = rgb <253/255, 140/255, 35/255>;
#declare CN_Mango_Margarita = rgb <247/255, 183/255, 78/255>;
#declare CN_Mango_Mojito = rgb <214/255, 156/255, 47/255>;
#declare CN_Mango_Nectar = rgb <255/255, 212/255, 157/255>;
#declare CN_Mango_Orange = rgb <255/255, 139/255, 88/255>;
#declare CN_Mango_Salsa = rgb <255/255, 176/255, 102/255>;
#declare CN_Mango_Squash = rgb <142/255, 108/255, 57/255>;
#declare CN_Mango_Tango = rgb <255/255, 130/255, 67/255>;
#declare CN_Mangosteen = rgb <56/255, 62/255, 93/255>;
#declare CN_Mangosteen_Violet = rgb <58/255, 39/255, 50/255>;
#declare CN_Mangrove = rgb <117/255, 116/255, 97/255>;
#declare CN_Mangrove_Leaf = rgb <96/255, 124/255, 61/255>;
#declare CN_Mangu_Black = rgb <41/255, 41/255, 56/255>;
#declare CN_Mangy_Moose = rgb <178/255, 137/255, 108/255>;
#declare CN_Manhattan = rgb <226/255, 175/255, 128/255>;
#declare CN_Manhattan_Blue = rgb <64/255, 68/255, 87/255>;
#declare CN_Manhattan_Mist = rgb <204/255, 207/255, 207/255>;
#declare CN_Mani = rgb <151/255, 144/255, 142/255>;
#declare CN_Maniac_Green = rgb <0/255, 144/255, 0/255>;
#declare CN_Maniac_Mansion = rgb <0/255, 64/255, 88/255>;
#declare CN_Manifest = rgb <137/255, 152/255, 136/255>;
#declare CN_Manila = rgb <231/255, 201/255, 169/255>;
#declare CN_Manila_Tint = rgb <255/255, 226/255, 167/255>;
#declare CN_Manitou_Blue = rgb <91/255, 146/255, 162/255>;
#declare CN_Mannequin = rgb <238/255, 223/255, 221/255>;
#declare CN_Mannequin_Cream = rgb <246/255, 229/255, 206/255>;
#declare CN_Mannered_Gold = rgb <193/255, 151/255, 99/255>;
#declare CN_Manor_House = rgb <102/255, 93/255, 87/255>;
#declare CN_Mantella_Frog = rgb <255/255, 187/255, 0/255>;
#declare CN_Manticore_Brown = rgb <149/255, 120/255, 64/255>;
#declare CN_Manticore_Wing = rgb <221/255, 119/255, 17/255>;
#declare CN_Mantis = rgb <116/255, 195/255, 101/255>;
#declare CN_Mantle = rgb <150/255, 167/255, 147/255>;
#declare CN_Mantra = rgb <220/255, 226/255, 223/255>;
#declare CN_Manually_Pressed_Grapes = rgb <136/255, 17/255, 68/255>;
#declare CN_Manure = rgb <173/255, 144/255, 13/255>;
#declare CN_Manuscript = rgb <209/255, 201/255, 186/255>;
#declare CN_Manuscript_Ink = rgb <130/255, 126/255, 113/255>;
#declare CN_Manz = rgb <228/255, 219/255, 85/255>;
#declare CN_Manzanilla_Olive = rgb <158/255, 143/255, 107/255>;
#declare CN_Maple = rgb <184/255, 142/255, 114/255>;
#declare CN_Maple_Beige = rgb <250/255, 208/255, 161/255>;
#declare CN_Maple_Brown_Sugar = rgb <163/255, 142/255, 111/255>;
#declare CN_Maple_Elixir = rgb <246/255, 209/255, 147/255>;
#declare CN_Maple_Glaze = rgb <167/255, 105/255, 68/255>;
#declare CN_Maple_Leaf = rgb <209/255, 123/255, 65/255>;
#declare CN_Maple_Pecan = rgb <227/255, 209/255, 187/255>;
#declare CN_Maple_Red = rgb <191/255, 81/255, 78/255>;
#declare CN_Maple_Sugar = rgb <201/255, 163/255, 141/255>;
#declare CN_Maple_Syrup = rgb <187/255, 147/255, 81/255>;
#declare CN_Maple_Syrup_Brown = rgb <200/255, 133/255, 84/255>;
#declare CN_Maple_View = rgb <180/255, 145/255, 97/255>;
#declare CN_Maraschino = rgb <255/255, 38/255, 0/255>;
#declare CN_Marble_Dust = rgb <243/255, 229/255, 203/255>;
#declare CN_Marble_Garden = rgb <100/255, 98/255, 85/255>;
#declare CN_Marble_Green = rgb <143/255, 159/255, 151/255>;
#declare CN_Marble_Green_Grey = rgb <133/255, 146/255, 143/255>;
#declare CN_Marble_Red = rgb <169/255, 96/255, 110/255>;
#declare CN_Marble_White = rgb <242/255, 240/255, 230/255>;
#declare CN_March_Green = rgb <212/255, 204/255, 0/255>;
#declare CN_March_Hare_Orange = rgb <255/255, 117/255, 15/255>;
#declare CN_March_Pink = rgb <154/255, 114/255, 118/255>;
#declare CN_March_Tulip_Green = rgb <212/255, 201/255, 120/255>;
#declare CN_March_Wind = rgb <186/255, 185/255, 182/255>;
#declare CN_March_Yellow = rgb <241/255, 212/255, 138/255>;
#declare CN_Mardi_Gras = rgb <136/255, 0/255, 133/255>;
#declare CN_Marea_Baja = rgb <46/255, 84/255, 100/255>;
#declare CN_Marfil = rgb <249/255, 236/255, 218/255>;
#declare CN_Margarine = rgb <242/255, 217/255, 48/255>;
#declare CN_Margarita = rgb <181/255, 195/255, 142/255>;
#declare CN_Mariana_Trench = rgb <68/255, 89/255, 86/255>;
#declare CN_Marigold = rgb <252/255, 192/255, 6/255>;
#declare CN_Marigold_Yellow = rgb <251/255, 232/255, 112/255>;
#declare CN_Marilyn_Monroe = rgb <231/255, 195/255, 172/255>;
#declare CN_Marina = rgb <79/255, 132/255, 196/255>;
#declare CN_Marina_Isle = rgb <177/255, 200/255, 191/255>;
#declare CN_Marine = rgb <4/255, 46/255, 96/255>;
#declare CN_Marine_Blue = rgb <1/255, 56/255, 106/255>;
#declare CN_Marine_Green = rgb <64/255, 164/255, 142/255>;
#declare CN_Marine_Grey = rgb <165/255, 178/255, 170/255>;
#declare CN_Marine_Ink = rgb <99/255, 132/255, 184/255>;
#declare CN_Marine_Layer = rgb <165/255, 180/255, 182/255>;
#declare CN_Marine_Magic = rgb <81/255, 94/255, 98/255>;
#declare CN_Marine_Teal = rgb <0/255, 131/255, 132/255>;
#declare CN_Marine_Tinge = rgb <51/255, 163/255, 179/255>;
#declare CN_Marine_Wonder = rgb <31/255, 112/255, 115/255>;
#declare CN_Mariner = rgb <66/255, 99/255, 159/255>;
#declare CN_Mario = rgb <228/255, 0/255, 15/255>;
#declare CN_Marionberry = rgb <56/255, 2/255, 130/255>;
#declare CN_Maritime = rgb <189/255, 207/255, 234/255>;
#declare CN_Maritime_Blue = rgb <39/255, 41/255, 61/255>;
#declare CN_Maritime_Soft_Blue = rgb <105/255, 184/255, 192/255>;
#declare CN_Maritime_White = rgb <229/255, 230/255, 224/255>;
#declare CN_Marjoram = rgb <191/255, 203/255, 162/255>;
#declare CN_Marker_Blue = rgb <0/255, 134/255, 154/255>;
#declare CN_Marker_Green = rgb <157/255, 175/255, 0/255>;
#declare CN_Marker_Pink = rgb <227/255, 150/255, 155/255>;
#declare CN_Market_Melon = rgb <251/255, 179/255, 119/255>;
#declare CN_Marlin = rgb <81/255, 91/255, 135/255>;
#declare CN_Marlin_Green = rgb <65/255, 161/255, 170/255>;
#declare CN_Marmalade = rgb <193/255, 101/255, 18/255>;
#declare CN_Marmalade_Glaze = rgb <194/255, 117/255, 69/255>;
#declare CN_Marmot = rgb <146/255, 132/255, 117/255>;
#declare CN_Maroon = rgb <128/255, 0/255, 0/255>;
#declare CN_Maroon_Flush = rgb <195/255, 34/255, 73/255>;
#declare CN_Maroon_Light = rgb <191/255, 49/255, 96/255>;
#declare CN_Maroon_Oak = rgb <82/255, 12/255, 23/255>;
#declare CN_Marooned = rgb <134/255, 205/255, 171/255>;
#declare CN_Marquee_White = rgb <245/255, 234/255, 214/255>;
#declare CN_Marquis_Orange = rgb <210/255, 120/255, 58/255>;
#declare CN_Marrakech_Brown = rgb <145/255, 115/255, 76/255>;
#declare CN_Marrakesh_Red = rgb <120/255, 59/255, 60/255>;
#declare CN_Marrett_Apple = rgb <202/255, 202/255, 163/255>;
#declare CN_Marron = rgb <110/255, 76/255, 75/255>;
#declare CN_Marron_Canela = rgb <167/255, 115/255, 90/255>;
#declare CN_Marrs_Green = rgb <0/255, 140/255, 140/255>;
#declare CN_Mars = rgb <173/255, 98/255, 66/255>;
#declare CN_Mars_Red = rgb <188/255, 39/255, 49/255>;
#declare CN_Marsala = rgb <150/255, 79/255, 76/255>;
#declare CN_Marseilles = rgb <183/255, 187/255, 187/255>;
#declare CN_Marsh = rgb <92/255, 83/255, 55/255>;
#declare CN_Marsh_Creek = rgb <107/255, 135/255, 129/255>;
#declare CN_Marsh_Fern = rgb <182/255, 202/255, 144/255>;
#declare CN_Marsh_Field = rgb <212/255, 196/255, 119/255>;
#declare CN_Marsh_Fog = rgb <198/255, 216/255, 199/255>;
#declare CN_Marsh_Grass = rgb <130/255, 118/255, 61/255>;
#declare CN_Marsh_Marigold = rgb <255/255, 239/255, 23/255>;
#declare CN_Marsh_Mix = rgb <90/255, 101/255, 58/255>;
#declare CN_Marsh_Orchid = rgb <196/255, 163/255, 191/255>;
#declare CN_Marshal_Blue = rgb <62/255, 67/255, 85/255>;
#declare CN_Marshland = rgb <43/255, 46/255, 38/255>;
#declare CN_Marshmallow = rgb <240/255, 238/255, 228/255>;
#declare CN_Marshmallow_Cream = rgb <243/255, 224/255, 214/255>;
#declare CN_Marshmallow_Fluff = rgb <250/255, 243/255, 222/255>;
#declare CN_Marshmallow_Magic = rgb <239/255, 210/255, 208/255>;
#declare CN_Marshmallow_Mist = rgb <224/255, 202/255, 170/255>;
#declare CN_Marshmallow_Rose = rgb <247/255, 229/255, 230/255>;
#declare CN_Marshmallow_Whip = rgb <249/255, 239/255, 224/255>;
#declare CN_Marshy_Green = rgb <142/255, 113/255, 46/255>;
#declare CN_Marshy_Habitat = rgb <184/255, 174/255, 162/255>;
#declare CN_Marsupilami = rgb <253/255, 242/255, 0/255>;
#declare CN_Martian = rgb <174/255, 161/255, 50/255>;
#declare CN_Martian_Colony = rgb <229/255, 117/255, 15/255>;
#declare CN_Martian_Green = rgb <19/255, 108/255, 81/255>;
#declare CN_Martian_Haze = rgb <173/255, 234/255, 206/255>;
#declare CN_Martian_Ironcrust = rgb <183/255, 65/255, 14/255>;
#declare CN_Martian_Ironearth = rgb <193/255, 90/255, 75/255>;
#declare CN_Martian_Moon = rgb <195/255, 233/255, 211/255>;
#declare CN_Martica = rgb <244/255, 229/255, 183/255>;
#declare CN_Martina_Olive = rgb <142/255, 142/255, 65/255>;
#declare CN_Martini = rgb <183/255, 168/255, 163/255>;
#declare CN_Martini_East = rgb <206/255, 140/255, 141/255>;
#declare CN_Martini_Olive = rgb <205/255, 199/255, 150/255>;
#declare CN_Martinique = rgb <60/255, 55/255, 72/255>;
#declare CN_Marvellous = rgb <106/255, 127/255, 180/255>;
#declare CN_Marvelous_Magic = rgb <225/255, 198/255, 214/255>;
#declare CN_Mary_Blue = rgb <0/255, 106/255, 119/255>;
#declare CN_Mary_Poppins = rgb <209/255, 181/255, 202/255>;
#declare CN_Mary_Rose = rgb <215/255, 177/255, 176/255>;
#declare CN_Marys_Garden = rgb <105/255, 145/255, 61/255>;
#declare CN_Marys_Rose = rgb <247/255, 209/255, 212/255>;
#declare CN_Marzena_Dream = rgb <166/255, 208/255, 236/255>;
#declare CN_Marzipan = rgb <235/255, 200/255, 129/255>;
#declare CN_Marzipan_Pink = rgb <238/255, 186/255, 188/255>;
#declare CN_Marzipan_White = rgb <235/255, 229/255, 216/255>;
#declare CN_Masala = rgb <87/255, 83/255, 75/255>;
#declare CN_Masala_Chai = rgb <238/255, 204/255, 170/255>;
#declare CN_Mascarpone = rgb <236/255, 230/255, 212/255>;
#declare CN_Mask = rgb <171/255, 135/255, 141/255>;
#declare CN_Masked_Mauve = rgb <198/255, 178/255, 190/255>;
#declare CN_Masoho_Red = rgb <213/255, 124/255, 107/255>;
#declare CN_Master = rgb <58/255, 75/255, 97/255>;
#declare CN_Master_Chief = rgb <80/255, 125/255, 42/255>;
#declare CN_Master_Key = rgb <221/255, 204/255, 136/255>;
#declare CN_Master_Round_Yellow = rgb <231/255, 131/255, 3/255>;
#declare CN_Master_Sword_Blue = rgb <0/255, 255/255, 238/255>;
#declare CN_Masterpiece = rgb <161/255, 162/255, 171/255>;
#declare CN_Masuhana_Blue = rgb <77/255, 100/255, 108/255>;
#declare CN_Mat_Dazzle_Rose = rgb <255/255, 72/255, 208/255>;
#declare CN_Mata_Hari = rgb <84/255, 72/255, 89/255>;
#declare CN_Matadors_Cape = rgb <207/255, 110/255, 102/255>;
#declare CN_Match_Head = rgb <214/255, 55/255, 86/255>;
#declare CN_Match_Strike = rgb <255/255, 170/255, 68/255>;
#declare CN_Matcha_Picchu = rgb <153/255, 187/255, 0/255>;
#declare CN_Matcha_Powder = rgb <160/255, 212/255, 4/255>;
#declare CN_Mate_Tea = rgb <123/255, 177/255, 141/255>;
#declare CN_Matisse = rgb <54/255, 92/255, 125/255>;
#declare CN_Matriarch = rgb <126/255, 104/255, 132/255>;
#declare CN_Matrix = rgb <142/255, 77/255, 69/255>;
#declare CN_Matsuba_Green = rgb <69/255, 77/255, 50/255>;
#declare CN_Matt_Black = rgb <21/255, 21/255, 21/255>;
#declare CN_Matt_Blue = rgb <44/255, 111/255, 187/255>;
#declare CN_Matt_Demon = rgb <221/255, 68/255, 51/255>;
#declare CN_Matt_Green = rgb <57/255, 173/255, 72/255>;
#declare CN_Matt_Lilac = rgb <222/255, 198/255, 211/255>;
#declare CN_Matt_Pink = rgb <255/255, 182/255, 193/255>;
#declare CN_Matt_Purple = rgb <147/255, 112/255, 219/255>;
#declare CN_Matt_Sage = rgb <178/255, 185/255, 165/255>;
#declare CN_Matt_White = rgb <255/255, 255/255, 212/255>;
#declare CN_Mattar_Paneer = rgb <136/255, 68/255, 51/255>;
#declare CN_Matte_Blue = rgb <143/255, 176/255, 206/255>;
#declare CN_Matte_Carmine = rgb <160/255, 101/255, 112/255>;
#declare CN_Matte_Grey = rgb <180/255, 168/255, 164/255>;
#declare CN_Matte_Jade_Green = rgb <181/255, 203/255, 189/255>;
#declare CN_Matte_Olive = rgb <153/255, 143/255, 127/255>;
#declare CN_Matte_Sage_Green = rgb <138/255, 147/255, 129/255>;
#declare CN_Matterhorn = rgb <82/255, 75/255, 75/255>;
#declare CN_Matterhorn_Snow = rgb <224/255, 254/255, 254/255>;
#declare CN_Mature = rgb <196/255, 175/255, 179/255>;
#declare CN_Mature_Cognac = rgb <154/255, 70/255, 61/255>;
#declare CN_Mature_Grape = rgb <95/255, 63/255, 84/255>;
#declare CN_Maud = rgb <152/255, 130/255, 134/255>;
#declare CN_Maui = rgb <33/255, 165/255, 190/255>;
#declare CN_Maui_Blue = rgb <82/255, 162/255, 180/255>;
#declare CN_Maui_Mai_Tai = rgb <182/255, 96/255, 68/255>;
#declare CN_Maui_Mist = rgb <238/255, 242/255, 243/255>;
#declare CN_Mauve = rgb <224/255, 176/255, 255/255>;
#declare CN_Mauve_Aquarelle = rgb <227/255, 210/255, 219/255>;
#declare CN_Mauve_Brown = rgb <98/255, 89/255, 95/255>;
#declare CN_Mauve_Chalk = rgb <229/255, 208/255, 207/255>;
#declare CN_Mauve_Day = rgb <172/255, 140/255, 140/255>;
#declare CN_Mauve_Finery = rgb <203/255, 184/255, 192/255>;
#declare CN_Mauve_Glow = rgb <209/255, 132/255, 137/255>;
#declare CN_Mauve_It = rgb <187/255, 68/255, 102/255>;
#declare CN_Mauve_Jazz = rgb <144/255, 129/255, 134/255>;
#declare CN_Mauve_Madness = rgb <170/255, 121/255, 130/255>;
#declare CN_Mauve_Magic = rgb <191/255, 145/255, 178/255>;
#declare CN_Mauve_Melody = rgb <166/255, 159/255, 154/255>;
#declare CN_Mauve_Mist = rgb <196/255, 155/255, 212/255>;
#declare CN_Mauve_Mole = rgb <125/255, 113/255, 110/255>;
#declare CN_Mauve_Morn = rgb <236/255, 214/255, 214/255>;
#declare CN_Mauve_Morning = rgb <217/255, 208/255, 207/255>;
#declare CN_Mauve_Musk = rgb <169/255, 140/255, 161/255>;
#declare CN_Mauve_Muslin = rgb <181/255, 158/255, 173/255>;
#declare CN_Mauve_Mystery = rgb <104/255, 92/255, 97/255>;
#declare CN_Mauve_Mystique = rgb <187/255, 68/255, 119/255>;
#declare CN_Mauve_Nymph = rgb <192/255, 173/255, 166/255>;
#declare CN_Mauve_Orchid = rgb <181/255, 130/255, 153/255>;
#declare CN_Mauve_Organdie = rgb <217/255, 196/255, 208/255>;
#declare CN_Mauve_Pansy = rgb <190/255, 187/255, 192/255>;
#declare CN_Mauve_Seductress = rgb <187/255, 119/255, 136/255>;
#declare CN_Mauve_Shadows = rgb <181/255, 152/255, 163/255>;
#declare CN_Mauve_Stone = rgb <196/255, 186/255, 182/255>;
#declare CN_Mauve_Taupe = rgb <145/255, 95/255, 109/255>;
#declare CN_Mauve_Tinge = rgb <231/255, 225/255, 225/255>;
#declare CN_Mauve_White = rgb <222/255, 227/255, 228/255>;
#declare CN_Mauve_Wine = rgb <91/255, 54/255, 68/255>;
#declare CN_Mauve_Wisp = rgb <234/255, 221/255, 225/255>;
#declare CN_Mauve_a_Lish = rgb <144/255, 104/255, 108/255>;
#declare CN_Mauvelous = rgb <214/255, 179/255, 192/255>;
#declare CN_Mauverine = rgb <157/255, 136/255, 136/255>;
#declare CN_Mauvette = rgb <196/255, 178/255, 169/255>;
#declare CN_Mauvewood = rgb <167/255, 93/255, 103/255>;
#declare CN_Mauvey_Nude = rgb <187/255, 136/255, 153/255>;
#declare CN_Mauvey_Pink = rgb <140/255, 129/255, 136/255>;
#declare CN_Maverick = rgb <200/255, 177/255, 192/255>;
#declare CN_Mawmaws_Pearls = rgb <239/255, 233/255, 221/255>;
#declare CN_Maxi_Teal = rgb <1/255, 116/255, 120/255>;
#declare CN_Maximum_Blue = rgb <71/255, 171/255, 204/255>;
#declare CN_Maximum_Blue_Green = rgb <48/255, 191/255, 191/255>;
#declare CN_Maximum_Blue_Purple = rgb <172/255, 172/255, 230/255>;
#declare CN_Maximum_Green = rgb <94/255, 140/255, 49/255>;
#declare CN_Maximum_Green_Yellow = rgb <217/255, 230/255, 80/255>;
#declare CN_Maximum_Mocha = rgb <107/255, 74/255, 64/255>;
#declare CN_Maximum_Orange = rgb <255/255, 91/255, 0/255>;
#declare CN_Maximum_Purple = rgb <115/255, 51/255, 128/255>;
#declare CN_Maximum_Red = rgb <217/255, 33/255, 33/255>;
#declare CN_Maximum_Red_Purple = rgb <166/255, 58/255, 121/255>;
#declare CN_Maximum_Yellow = rgb <250/255, 250/255, 55/255>;
#declare CN_Maximum_Yellow_Red = rgb <242/255, 186/255, 73/255>;
#declare CN_May_Apple = rgb <146/255, 213/255, 153/255>;
#declare CN_May_Green = rgb <76/255, 145/255, 65/255>;
#declare CN_May_Mist = rgb <161/255, 159/255, 200/255>;
#declare CN_May_Sun = rgb <250/255, 234/255, 208/255>;
#declare CN_Maya_Blue = rgb <115/255, 194/255, 251/255>;
#declare CN_Maya_Green = rgb <152/255, 210/255, 217/255>;
#declare CN_Mayan_Blue = rgb <0/255, 107/255, 108/255>;
#declare CN_Mayan_Chocolate = rgb <101/255, 80/255, 70/255>;
#declare CN_Mayan_Gold = rgb <182/255, 140/255, 55/255>;
#declare CN_Mayan_Red = rgb <108/255, 74/255, 67/255>;
#declare CN_Mayan_Ruins = rgb <125/255, 105/255, 80/255>;
#declare CN_Mayan_Treasure = rgb <206/255, 152/255, 68/255>;
#declare CN_Maybe_Maui = rgb <246/255, 212/255, 141/255>;
#declare CN_Maybe_Mushroom = rgb <226/255, 216/255, 203/255>;
#declare CN_Maybeck_Muslin = rgb <237/255, 223/255, 201/255>;
#declare CN_Mayfair_White = rgb <230/255, 240/255, 222/255>;
#declare CN_Mayfly = rgb <101/255, 102/255, 63/255>;
#declare CN_Maypole = rgb <190/255, 232/255, 211/255>;
#declare CN_Mazarine_Blue = rgb <39/255, 60/255, 118/255>;
#declare CN_Maze = rgb <92/255, 86/255, 56/255>;
#declare CN_Mazzone = rgb <176/255, 144/255, 124/255>;
#declare CN_Mazzy_Star = rgb <191/255, 91/255, 176/255>;
#declare CN_McKenzie = rgb <140/255, 99/255, 56/255>;
#declare CN_McNuke = rgb <51/255, 255/255, 17/255>;
#declare CN_Mead = rgb <255/255, 200/255, 120/255>;
#declare CN_Meadow = rgb <139/255, 186/255, 148/255>;
#declare CN_Meadow_Blossom_Blue = rgb <122/255, 178/255, 212/255>;
#declare CN_Meadow_Flower = rgb <152/255, 113/255, 132/255>;
#declare CN_Meadow_Glen = rgb <204/255, 209/255, 178/255>;
#declare CN_Meadow_Grass = rgb <193/255, 214/255, 177/255>;
#declare CN_Meadow_Green = rgb <115/255, 153/255, 87/255>;
#declare CN_Meadow_Lane = rgb <192/255, 215/255, 205/255>;
#declare CN_Meadow_Light = rgb <223/255, 233/255, 222/255>;
#declare CN_Meadow_Mauve = rgb <169/255, 86/255, 140/255>;
#declare CN_Meadow_Mist = rgb <211/255, 222/255, 196/255>;
#declare CN_Meadow_Phlox = rgb <168/255, 175/255, 199/255>;
#declare CN_Meadow_Trail = rgb <141/255, 129/255, 104/255>;
#declare CN_Meadow_Violet = rgb <118/255, 79/255, 130/255>;
#declare CN_Meadow_Yellow = rgb <247/255, 218/255, 144/255>;
#declare CN_Meadowbrook = rgb <96/255, 160/255, 163/255>;
#declare CN_Meadowland = rgb <128/255, 122/255, 85/255>;
#declare CN_Meadowlark = rgb <234/255, 217/255, 78/255>;
#declare CN_Meadowood = rgb <157/255, 162/255, 142/255>;
#declare CN_Meadowsweet_Mist = rgb <212/255, 227/255, 226/255>;
#declare CN_Meander = rgb <143/255, 140/255, 121/255>;
#declare CN_Meander_Blue = rgb <190/255, 219/255, 216/255>;
#declare CN_Meat = rgb <240/255, 128/255, 128/255>;
#declare CN_Meat_Brown = rgb <229/255, 183/255, 59/255>;
#declare CN_Meatbun = rgb <248/255, 238/255, 211/255>;
#declare CN_Meatloaf = rgb <102/255, 51/255, 17/255>;
#declare CN_Mecca_Gold = rgb <200/255, 145/255, 52/255>;
#declare CN_Mecca_Orange = rgb <189/255, 87/255, 69/255>;
#declare CN_Mecca_Red = rgb <102/255, 63/255, 63/255>;
#declare CN_Mech_Suit = rgb <187/255, 221/255, 221/255>;
#declare CN_Mecha_Grey = rgb <141/255, 132/255, 127/255>;
#declare CN_Mechagodzilla = rgb <222/255, 220/255, 226/255>;
#declare CN_Mechanicus_Standard_Grey = rgb <61/255, 75/255, 77/255>;
#declare CN_Mechrite_Red = rgb <163/255, 23/255, 19/255>;
#declare CN_Medal_Bronze = rgb <151/255, 117/255, 71/255>;
#declare CN_Medallion = rgb <195/255, 166/255, 121/255>;
#declare CN_Medical_Mask = rgb <149/255, 204/255, 228/255>;
#declare CN_Medici_Blue = rgb <16/255, 71/255, 115/255>;
#declare CN_Medici_Ivory = rgb <243/255, 233/255, 215/255>;
#declare CN_Medicine_Man = rgb <105/255, 85/255, 109/255>;
#declare CN_Medicine_Wheel = rgb <153/255, 162/255, 140/255>;
#declare CN_Medieval = rgb <105/255, 109/255, 176/255>;
#declare CN_Medieval_Blue = rgb <41/255, 48/255, 78/255>;
#declare CN_Medieval_Cobblestone = rgb <135/255, 133/255, 115/255>;
#declare CN_Medieval_Forest = rgb <0/255, 126/255, 107/255>;
#declare CN_Medieval_Gold = rgb <172/255, 127/255, 72/255>;
#declare CN_Medieval_Wine = rgb <140/255, 125/255, 136/255>;
#declare CN_Meditation = rgb <169/255, 172/255, 157/255>;
#declare CN_Meditation_Time = rgb <167/255, 169/255, 135/255>;
#declare CN_Meditative = rgb <150/255, 170/255, 176/255>;
#declare CN_Mediterranea = rgb <50/255, 87/255, 93/255>;
#declare CN_Mediterranean = rgb <96/255, 121/255, 125/255>;
#declare CN_Mediterranean_Blue = rgb <0/255, 144/255, 168/255>;
#declare CN_Mediterranean_Charm = rgb <161/255, 207/255, 236/255>;
#declare CN_Mediterranean_Cove = rgb <0/255, 123/255, 132/255>;
#declare CN_Mediterranean_Green = rgb <224/255, 233/255, 211/255>;
#declare CN_Mediterranean_Mist = rgb <188/255, 233/255, 214/255>;
#declare CN_Mediterranean_Sea = rgb <30/255, 140/255, 171/255>;
#declare CN_Mediterranean_Swirl = rgb <41/255, 153/255, 162/255>;
#declare CN_Medium_Aquamarine = rgb <102/255, 221/255, 170/255>;
#declare CN_Medium_Black = rgb <68/255, 68/255, 67/255>;
#declare CN_Medium_Blue = rgb <0/255, 0/255, 205/255>;
#declare CN_Medium_Brown = rgb <127/255, 81/255, 18/255>;
#declare CN_Medium_Candy_Apple_Red = rgb <226/255, 6/255, 44/255>;
#declare CN_Medium_Carmine = rgb <175/255, 64/255, 53/255>;
#declare CN_Medium_Champagne = rgb <243/255, 229/255, 172/255>;
#declare CN_Medium_Electric_Blue = rgb <3/255, 80/255, 150/255>;
#declare CN_Medium_Goldenrod = rgb <234/255, 234/255, 174/255>;
#declare CN_Medium_Green = rgb <60/255, 130/255, 78/255>;
#declare CN_Medium_Grey = rgb <125/255, 127/255, 124/255>;
#declare CN_Medium_Grey_Green = rgb <77/255, 107/255, 83/255>;
#declare CN_Medium_Gunship_Grey = rgb <63/255, 73/255, 82/255>;
#declare CN_Medium_Jungle_Green = rgb <28/255, 53/255, 45/255>;
#declare CN_Medium_Lavender_Magenta = rgb <221/255, 160/255, 253/255>;
#declare CN_Medium_Orchid = rgb <186/255, 85/255, 211/255>;
#declare CN_Medium_Persian_Blue = rgb <0/255, 103/255, 165/255>;
#declare CN_Medium_Pink = rgb <243/255, 97/255, 150/255>;
#declare CN_Medium_Purple = rgb <158/255, 67/255, 162/255>;
#declare CN_Medium_Red_Violet = rgb <187/255, 51/255, 133/255>;
#declare CN_Medium_Roast = rgb <60/255, 32/255, 5/255>;
#declare CN_Medium_Ruby = rgb <170/255, 64/255, 105/255>;
#declare CN_Medium_Scarlet = rgb <252/255, 40/255, 71/255>;
#declare CN_Medium_Sea_Green = rgb <60/255, 179/255, 113/255>;
#declare CN_Medium_Sky_Blue = rgb <128/255, 218/255, 235/255>;
#declare CN_Medium_Slate_Blue = rgb <123/255, 104/255, 238/255>;
#declare CN_Medium_Spring_Bud = rgb <201/255, 220/255, 135/255>;
#declare CN_Medium_Spring_Green = rgb <0/255, 250/255, 154/255>;
#declare CN_Medium_Taupe = rgb <103/255, 76/255, 71/255>;
#declare CN_Medium_Terracotta = rgb <220/255, 157/255, 139/255>;
#declare CN_Medium_Turquoise = rgb <72/255, 209/255, 204/255>;
#declare CN_Medium_Tuscan_Red = rgb <121/255, 68/255, 49/255>;
#declare CN_Medium_Vermilion = rgb <217/255, 96/255, 59/255>;
#declare CN_Medium_Violet_Red = rgb <199/255, 21/255, 133/255>;
#declare CN_Medium_Wood = rgb <166/255, 128/255, 100/255>;
#declare CN_Medlar = rgb <213/255, 215/255, 191/255>;
#declare CN_Medusa_Green = rgb <153/255, 136/255, 0/255>;
#declare CN_Medusas_Snakes = rgb <119/255, 119/255, 17/255>;
#declare CN_Mee_hua_Sunset = rgb <238/255, 119/255, 0/255>;
#declare CN_Meek_Moss_Green = rgb <134/255, 159/255, 152/255>;
#declare CN_Meerkat = rgb <164/255, 111/255, 68/255>;
#declare CN_Meetinghouse_Blue = rgb <115/255, 157/255, 173/255>;
#declare CN_Mega_Blue = rgb <54/255, 111/255, 166/255>;
#declare CN_Mega_Greige = rgb <173/255, 162/255, 149/255>;
#declare CN_Mega_Magenta = rgb <215/255, 103/255, 173/255>;
#declare CN_Mega_Metal_Mecha = rgb <223/255, 203/255, 207/255>;
#declare CN_Mega_Metal_Phoenix = rgb <198/255, 204/255, 212/255>;
#declare CN_Megadrive_Screen = rgb <74/255, 64/255, 173/255>;
#declare CN_Megaman = rgb <60/255, 188/255, 252/255>;
#declare CN_Megaman_Helmet = rgb <0/255, 88/255, 248/255>;
#declare CN_Mei_Gui_Hong_Red = rgb <254/255, 2/255, 60/255>;
#declare CN_Mei_Gui_Zi_Purple = rgb <224/255, 63/255, 216/255>;
#declare CN_Mei_Hei_Coal = rgb <18/255, 49/255, 32/255>;
#declare CN_Meissen_Blue = rgb <0/255, 127/255, 185/255>;
#declare CN_Melancholia = rgb <18/255, 57/255, 13/255>;
#declare CN_Melancholic_Macaw = rgb <170/255, 17/255, 51/255>;
#declare CN_Melancholic_Sea = rgb <83/255, 119/255, 143/255>;
#declare CN_Melancholy = rgb <221/255, 136/255, 153/255>;
#declare CN_Melange_Green = rgb <196/255, 196/255, 118/255>;
#declare CN_Melanie = rgb <224/255, 183/255, 194/255>;
#declare CN_Melanite_Black_Green = rgb <40/255, 46/255, 39/255>;
#declare CN_Melanzane = rgb <52/255, 41/255, 49/255>;
#declare CN_Melbourne = rgb <76/255, 124/255, 75/255>;
#declare CN_Melbourne_Cup = rgb <69/255, 195/255, 173/255>;
#declare CN_Melissa = rgb <181/255, 217/255, 107/255>;
#declare CN_Mella_Yella = rgb <240/255, 221/255, 162/255>;
#declare CN_Mellifluous_Blue = rgb <201/255, 225/255, 224/255>;
#declare CN_Mellow_Apricot = rgb <248/255, 184/255, 120/255>;
#declare CN_Mellow_Blue = rgb <215/255, 226/255, 221/255>;
#declare CN_Mellow_Buff = rgb <216/255, 185/255, 152/255>;
#declare CN_Mellow_Coral = rgb <224/255, 137/255, 126/255>;
#declare CN_Mellow_Flower = rgb <241/255, 223/255, 233/255>;
#declare CN_Mellow_Glow = rgb <255/255, 207/255, 173/255>;
#declare CN_Mellow_Green = rgb <213/255, 213/255, 147/255>;
#declare CN_Mellow_Mango = rgb <204/255, 68/255, 0/255>;
#declare CN_Mellow_Mauve = rgb <153/255, 99/255, 120/255>;
#declare CN_Mellow_Melon = rgb <238/255, 34/255, 102/255>;
#declare CN_Mellow_Mint = rgb <221/255, 237/255, 189/255>;
#declare CN_Mellow_Mood = rgb <177/255, 183/255, 161/255>;
#declare CN_Mellow_Rose = rgb <217/255, 166/255, 161/255>;
#declare CN_Mellow_Yellow = rgb <248/255, 222/255, 127/255>;
#declare CN_Melmac_Silver = rgb <182/255, 178/255, 161/255>;
#declare CN_Melodic_White = rgb <238/255, 232/255, 232/255>;
#declare CN_Melodious = rgb <123/255, 181/255, 174/255>;
#declare CN_Melody = rgb <190/255, 203/255, 215/255>;
#declare CN_Melon = rgb <255/255, 120/255, 85/255>;
#declare CN_Melon_Baby = rgb <244/255, 120/255, 105/255>;
#declare CN_Melon_Balls = rgb <242/255, 189/255, 133/255>;
#declare CN_Melon_Green = rgb <116/255, 172/255, 141/255>;
#declare CN_Melon_Ice = rgb <244/255, 217/255, 200/255>;
#declare CN_Melon_Melody = rgb <249/255, 194/255, 145/255>;
#declare CN_Melon_Meloso = rgb <242/255, 184/255, 140/255>;
#declare CN_Melon_Mist = rgb <232/255, 128/255, 146/255>;
#declare CN_Melon_Orange = rgb <240/255, 143/255, 72/255>;
#declare CN_Melon_Pink = rgb <241/255, 212/255, 196/255>;
#declare CN_Melon_Red = rgb <246/255, 146/255, 104/255>;
#declare CN_Melon_Seed = rgb <51/255, 44/255, 34/255>;
#declare CN_Melon_Sorbet = rgb <248/255, 183/255, 151/255>;
#declare CN_Melon_Sprinkle = rgb <255/255, 205/255, 157/255>;
#declare CN_Melon_Tint = rgb <248/255, 231/255, 212/255>;
#declare CN_Melon_Twist = rgb <170/255, 104/255, 100/255>;
#declare CN_Melon_Water = rgb <253/255, 188/255, 180/255>;
#declare CN_Melrose = rgb <195/255, 185/255, 221/255>;
#declare CN_Melt_Ice = rgb <180/255, 203/255, 227/255>;
#declare CN_Melt_with_You = rgb <227/255, 207/255, 171/255>;
#declare CN_Melted_Butter = rgb <255/255, 207/255, 83/255>;
#declare CN_Melted_Chocolate = rgb <120/255, 95/255, 76/255>;
#declare CN_Melted_Copper = rgb <206/255, 133/255, 68/255>;
#declare CN_Melted_Ice_Cream = rgb <220/255, 183/255, 166/255>;
#declare CN_Melted_Marshmallow = rgb <254/255, 226/255, 204/255>;
#declare CN_Melted_Wax = rgb <246/255, 230/255, 197/255>;
#declare CN_Melting_Glacier = rgb <233/255, 249/255, 245/255>;
#declare CN_Melting_Ice = rgb <202/255, 225/255, 217/255>;
#declare CN_Melting_Icicles = rgb <236/255, 235/255, 228/255>;
#declare CN_Melting_Moment = rgb <187/255, 162/255, 182/255>;
#declare CN_Melting_Point = rgb <203/255, 225/255, 228/255>;
#declare CN_Melting_Snowman = rgb <218/255, 229/255, 224/255>;
#declare CN_Melting_Violet = rgb <212/255, 184/255, 191/255>;
#declare CN_Meltwater = rgb <121/255, 192/255, 204/255>;
#declare CN_Melville = rgb <149/255, 169/255, 158/255>;
#declare CN_Memoir = rgb <236/255, 240/255, 218/255>;
#declare CN_Memorable_Rose = rgb <207/255, 138/255, 141/255>;
#declare CN_Memories = rgb <232/255, 222/255, 218/255>;
#declare CN_Memorize = rgb <145/255, 151/255, 164/255>;
#declare CN_Memory_Lane = rgb <199/255, 209/255, 219/255>;
#declare CN_Memphis_Green = rgb <94/255, 157/255, 123/255>;
#declare CN_Men_Brown = rgb <94/255, 82/255, 57/255>;
#declare CN_Mendocino_Hills = rgb <131/255, 122/255, 100/255>;
#declare CN_Menoth_White_Base = rgb <243/255, 232/255, 184/255>;
#declare CN_Menoth_White_Highlight = rgb <240/255, 241/255, 206/255>;
#declare CN_Mental_Floss = rgb <222/255, 180/255, 197/255>;
#declare CN_Mental_Note = rgb <234/255, 238/255, 222/255>;
#declare CN_Menthol = rgb <193/255, 249/255, 162/255>;
#declare CN_Menthol_Green = rgb <156/255, 210/255, 180/255>;
#declare CN_Mephiston_Red = rgb <154/255, 17/255, 21/255>;
#declare CN_Mercer_Charcoal = rgb <172/255, 164/255, 149/255>;
#declare CN_Merchant_Marine_Blue = rgb <3/255, 67/255, 223/255>;
#declare CN_Mercurial = rgb <182/255, 176/255, 169/255>;
#declare CN_Mercury = rgb <235/255, 235/255, 235/255>;
#declare CN_Mercury_Mist = rgb <137/255, 200/255, 195/255>;
#declare CN_Merguez = rgb <101/255, 0/255, 33/255>;
#declare CN_Meridian_Star = rgb <123/255, 200/255, 178/255>;
#declare CN_Merins_Fire = rgb <255/255, 148/255, 8/255>;
#declare CN_Meringue = rgb <243/255, 228/255, 179/255>;
#declare CN_Meringue_Tips = rgb <194/255, 160/255, 128/255>;
#declare CN_Merino = rgb <225/255, 219/255, 208/255>;
#declare CN_Merino_Wool = rgb <207/255, 193/255, 174/255>;
#declare CN_Meristem = rgb <170/255, 225/255, 206/255>;
#declare CN_Merlin = rgb <79/255, 78/255, 72/255>;
#declare CN_Merlins_Beard = rgb <239/255, 226/255, 217/255>;
#declare CN_Merlins_Choice = rgb <159/255, 136/255, 152/255>;
#declare CN_Merlins_Cloak = rgb <137/255, 85/255, 110/255>;
#declare CN_Merlot = rgb <115/255, 0/255, 57/255>;
#declare CN_Merlot_Fields = rgb <113/255, 39/255, 53/255>;
#declare CN_Mermaid = rgb <129/255, 122/255, 101/255>;
#declare CN_Mermaid_Blues = rgb <0/255, 68/255, 119/255>;
#declare CN_Mermaid_Harbor = rgb <0/255, 119/255, 111/255>;
#declare CN_Mermaid_Net = rgb <34/255, 204/255, 204/255>;
#declare CN_Mermaid_Sea = rgb <41/255, 127/255, 109/255>;
#declare CN_Mermaid_Song = rgb <37/255, 174/255, 142/255>;
#declare CN_Mermaid_Tears = rgb <217/255, 230/255, 166/255>;
#declare CN_Mermaid_Treasure = rgb <31/255, 175/255, 180/255>;
#declare CN_Mermaids_Cove = rgb <138/255, 167/255, 134/255>;
#declare CN_Mermaids_Kiss = rgb <89/255, 200/255, 165/255>;
#declare CN_Mermaids_Tail = rgb <51/255, 123/255, 53/255>;
#declare CN_Merry_Music = rgb <206/255, 211/255, 193/255>;
#declare CN_Merry_Pink = rgb <234/255, 200/255, 218/255>;
#declare CN_Merrylyn = rgb <165/255, 208/255, 175/255>;
#declare CN_Mesa = rgb <188/255, 161/255, 119/255>;
#declare CN_Mesa_Beige = rgb <242/255, 235/255, 214/255>;
#declare CN_Mesa_Peach = rgb <193/255, 145/255, 128/255>;
#declare CN_Mesa_Pink = rgb <221/255, 177/255, 168/255>;
#declare CN_Mesa_Red = rgb <146/255, 85/255, 91/255>;
#declare CN_Mesa_Rose = rgb <238/255, 181/255, 175/255>;
#declare CN_Mesa_Sunrise = rgb <234/255, 129/255, 96/255>;
#declare CN_Mesa_Tan = rgb <167/255, 139/255, 113/255>;
#declare CN_Mesclun_Green = rgb <157/255, 182/255, 130/255>;
#declare CN_Meski_Black = rgb <31/255, 11/255, 30/255>;
#declare CN_Mesmerize = rgb <142/255, 144/255, 116/255>;
#declare CN_Mesquite_Powder = rgb <227/255, 200/255, 177/255>;
#declare CN_Message_Green = rgb <55/255, 184/255, 175/255>;
#declare CN_Messenger_Bag = rgb <125/255, 116/255, 94/255>;
#declare CN_Messinesi = rgb <254/255, 226/255, 190/255>;
#declare CN_Metal = rgb <186/255, 191/255, 188/255>;
#declare CN_Metal_Chi = rgb <156/255, 156/255, 155/255>;
#declare CN_Metal_Construction_Green = rgb <47/255, 46/255, 31/255>;
#declare CN_Metal_Deluxe = rgb <36/255, 67/255, 67/255>;
#declare CN_Metal_Flake = rgb <131/255, 135/255, 130/255>;
#declare CN_Metal_Fringe = rgb <131/255, 126/255, 116/255>;
#declare CN_Metal_Gear = rgb <162/255, 195/255, 219/255>;
#declare CN_Metal_Grey = rgb <103/255, 121/255, 134/255>;
#declare CN_Metal_Petal = rgb <176/255, 144/255, 178/255>;
#declare CN_Metal_Spark = rgb <238/255, 255/255, 153/255>;
#declare CN_Metalise = rgb <52/255, 55/255, 60/255>;
#declare CN_Metallic_Blue = rgb <79/255, 115/255, 142/255>;
#declare CN_Metallic_Bronze = rgb <85/255, 74/255, 60/255>;
#declare CN_Metallic_Copper = rgb <110/255, 61/255, 52/255>;
#declare CN_Metallic_Gold = rgb <212/255, 175/255, 55/255>;
#declare CN_Metallic_Green = rgb <36/255, 133/255, 91/255>;
#declare CN_Metallic_Mist = rgb <205/255, 204/255, 190/255>;
#declare CN_Metallic_Seaweed = rgb <10/255, 126/255, 140/255>;
#declare CN_Metallic_Sunburst = rgb <156/255, 124/255, 56/255>;
#declare CN_Meteor = rgb <187/255, 116/255, 49/255>;
#declare CN_Meteor_Shower = rgb <85/255, 51/255, 255/255>;
#declare CN_Meteorite = rgb <74/255, 59/255, 106/255>;
#declare CN_Meteorite_Black_Blue = rgb <65/255, 71/255, 86/255>;
#declare CN_Meteorological = rgb <89/255, 109/255, 105/255>;
#declare CN_Methadone = rgb <204/255, 34/255, 51/255>;
#declare CN_Methyl_Blue = rgb <0/255, 116/255, 168/255>;
#declare CN_Metro = rgb <130/255, 131/255, 147/255>;
#declare CN_Metroid_Red = rgb <248/255, 56/255, 0/255>;
#declare CN_Metropolis = rgb <97/255, 88/255, 79/255>;
#declare CN_Metropolis_Mood = rgb <153/255, 161/255, 165/255>;
#declare CN_Mette_Penne = rgb <249/255, 225/255, 212/255>;
#declare CN_Mettwurst = rgb <223/255, 113/255, 99/255>;
#declare CN_Mexican_Chile = rgb <209/255, 109/255, 118/255>;
#declare CN_Mexican_Chocolate = rgb <111/255, 90/255, 72/255>;
#declare CN_Mexican_Milk = rgb <255/255, 185/255, 178/255>;
#declare CN_Mexican_Moonlight = rgb <201/255, 147/255, 135/255>;
#declare CN_Mexican_Mudkip = rgb <252/255, 216/255, 220/255>;
#declare CN_Mexican_Pink = rgb <228/255, 0/255, 124/255>;
#declare CN_Mexican_Purple = rgb <90/255, 60/255, 85/255>;
#declare CN_Mexican_Red = rgb <155/255, 61/255, 61/255>;
#declare CN_Mexican_Red_Papaya = rgb <198/255, 69/255, 47/255>;
#declare CN_Mexican_Sand = rgb <175/255, 151/255, 129/255>;
#declare CN_Mexican_Sand_Dollar = rgb <218/255, 212/255, 197/255>;
#declare CN_Mexican_Silver = rgb <206/255, 206/255, 200/255>;
#declare CN_Mexican_Spirit = rgb <214/255, 131/255, 57/255>;
#declare CN_Mexican_Standoff = rgb <236/255, 159/255, 118/255>;
#declare CN_Mi_Bai_Beige = rgb <218/255, 215/255, 173/255>;
#declare CN_Mi_Cheng_Honey = rgb <232/255, 175/255, 69/255>;
#declare CN_Miami_Jade = rgb <23/255, 145/255, 127/255>;
#declare CN_Miami_Marmalade = rgb <247/255, 147/255, 26/255>;
#declare CN_Miami_Spice = rgb <144/255, 122/255, 110/255>;
#declare CN_Miami_Stucco = rgb <245/255, 213/255, 184/255>;
#declare CN_Miami_Weiss = rgb <237/255, 228/255, 211/255>;
#declare CN_Miami_White = rgb <204/255, 204/255, 238/255>;
#declare CN_Mica_Creek = rgb <112/255, 130/255, 143/255>;
#declare CN_Micaceous_Green = rgb <197/255, 218/255, 204/255>;
#declare CN_Micaceous_Light_Grey = rgb <205/255, 199/255, 189/255>;
#declare CN_Microchip = rgb <186/255, 188/255, 192/255>;
#declare CN_Micropolis = rgb <85/255, 110/255, 107/255>;
#declare CN_MicroProse_Red = rgb <238/255, 23/255, 43/255>;
#declare CN_Microwave_Blue = rgb <45/255, 82/255, 84/255>;
#declare CN_Mid_Blue = rgb <39/255, 106/255, 179/255>;
#declare CN_Mid_Century = rgb <85/255, 51/255, 51/255>;
#declare CN_Mid_Century_Furniture = rgb <174/255, 92/255, 27/255>;
#declare CN_Mid_Cypress = rgb <119/255, 151/255, 129/255>;
#declare CN_Mid_Green = rgb <80/255, 167/255, 71/255>;
#declare CN_Mid_Grey = rgb <95/255, 95/255, 110/255>;
#declare CN_Mid_Spring_Morning = rgb <207/255, 247/255, 239/255>;
#declare CN_Mid_Tan = rgb <196/255, 145/255, 94/255>;
#declare CN_Mid_century_Gem = rgb <129/255, 179/255, 156/255>;
#declare CN_Midas_Finger_Gold = rgb <246/255, 180/255, 4/255>;
#declare CN_Midas_Touch = rgb <232/255, 189/255, 69/255>;
#declare CN_Midday = rgb <247/255, 215/255, 138/255>;
#declare CN_Midday_Sun = rgb <255/255, 225/255, 163/255>;
#declare CN_Middle_Blue = rgb <126/255, 212/255, 230/255>;
#declare CN_Middle_Blue_Green = rgb <141/255, 217/255, 204/255>;
#declare CN_Middle_Blue_Purple = rgb <139/255, 114/255, 190/255>;
#declare CN_Middle_Ditch = rgb <124/255, 105/255, 66/255>;
#declare CN_Middle_Green = rgb <77/255, 140/255, 87/255>;
#declare CN_Middle_Green_Yellow = rgb <172/255, 191/255, 96/255>;
#declare CN_Middle_Purple = rgb <217/255, 130/255, 181/255>;
#declare CN_Middle_Red = rgb <229/255, 142/255, 115/255>;
#declare CN_Middle_Red_Purple = rgb <33/255, 8/255, 55/255>;
#declare CN_Middle_Safflower = rgb <200/255, 81/255, 121/255>;
#declare CN_Middle_Yellow = rgb <255/255, 235/255, 0/255>;
#declare CN_Middle_Yellow_Red = rgb <236/255, 177/255, 118/255>;
#declare CN_Middle_Earth = rgb <162/255, 148/255, 141/255>;
#declare CN_Middlestone = rgb <199/255, 171/255, 132/255>;
#declare CN_Middys_Purple = rgb <170/255, 142/255, 214/255>;
#declare CN_Midnight = rgb <3/255, 1/255, 45/255>;
#declare CN_Midnight_Badger = rgb <88/255, 89/255, 96/255>;
#declare CN_Midnight_Blue = rgb <2/255, 0/255, 53/255>;
#declare CN_Midnight_Blush = rgb <151/255, 159/255, 191/255>;
#declare CN_Midnight_Brown = rgb <112/255, 96/255, 72/255>;
#declare CN_Midnight_Clover = rgb <60/255, 87/255, 78/255>;
#declare CN_Midnight_Dream = rgb <57/255, 72/255, 87/255>;
#declare CN_Midnight_Dreams = rgb <0/255, 34/255, 51/255>;
#declare CN_Midnight_Escape = rgb <64/255, 60/255, 64/255>;
#declare CN_Midnight_Express = rgb <33/255, 38/255, 58/255>;
#declare CN_Midnight_Garden = rgb <99/255, 112/255, 87/255>;
#declare CN_Midnight_Green = rgb <0/255, 73/255, 83/255>;
#declare CN_Midnight_Grey = rgb <102/255, 106/255, 109/255>;
#declare CN_Midnight_Haze = rgb <62/255, 80/255, 95/255>;
#declare CN_Midnight_Hour = rgb <59/255, 72/255, 79/255>;
#declare CN_Midnight_in_NY = rgb <78/255, 90/255, 89/255>;
#declare CN_Midnight_in_Saigon = rgb <221/255, 136/255, 102/255>;
#declare CN_Midnight_in_the_Tropics = rgb <67/255, 89/255, 100/255>;
#declare CN_Midnight_in_Tokyo = rgb <0/255, 0/255, 136/255>;
#declare CN_Midnight_Magic = rgb <70/255, 71/255, 74/255>;
#declare CN_Midnight_Melancholia = rgb <0/255, 34/255, 102/255>;
#declare CN_Midnight_Merlot = rgb <136/255, 0/255, 68/255>;
#declare CN_Midnight_Mosaic = rgb <61/255, 82/255, 103/255>;
#declare CN_Midnight_Moss = rgb <36/255, 46/255, 40/255>;
#declare CN_Midnight_Navy = rgb <52/255, 65/255, 78/255>;
#declare CN_Midnight_Pearl = rgb <95/255, 108/255, 116/255>;
#declare CN_Midnight_Purple = rgb <40/255, 1/255, 55/255>;
#declare CN_Midnight_Sea = rgb <86/255, 91/255, 141/255>;
#declare CN_Midnight_Show = rgb <84/255, 100/255, 115/255>;
#declare CN_Midnight_Sky = rgb <66/255, 71/255, 83/255>;
#declare CN_Midnight_Spruce = rgb <85/255, 91/255, 83/255>;
#declare CN_Midnight_Sun = rgb <78/255, 90/255, 109/255>;
#declare CN_Midnight_Violet = rgb <106/255, 117/255, 173/255>;
#declare CN_Midori = rgb <42/255, 96/255, 59/255>;
#declare CN_Midori_Green = rgb <62/255, 179/255, 112/255>;
#declare CN_Midsummer = rgb <246/255, 217/255, 169/255>;
#declare CN_Midsummer_Dream = rgb <183/255, 165/255, 173/255>;
#declare CN_Midsummer_Gold = rgb <234/255, 176/255, 52/255>;
#declare CN_Midsummer_Nights = rgb <0/255, 17/255, 238/255>;
#declare CN_Midsummers_Dream = rgb <180/255, 208/255, 217/255>;
#declare CN_Midtown = rgb <181/255, 161/255, 138/255>;
#declare CN_Midwinter_Fire = rgb <221/255, 17/255, 0/255>;
#declare CN_Midwinter_Mist = rgb <165/255, 212/255, 220/255>;
#declare CN_Mighty_Mauve = rgb <143/255, 127/255, 133/255>;
#declare CN_Mighty_Midnight = rgb <0/255, 1/255, 51/255>;
#declare CN_Migol_Blue = rgb <40/255, 52/255, 130/255>;
#declare CN_Mikado = rgb <63/255, 54/255, 35/255>;
#declare CN_Mikado_Yellow = rgb <255/255, 196/255, 12/255>;
#declare CN_Mikan_Orange = rgb <240/255, 131/255, 0/255>;
#declare CN_Mike_Wazowski_Green = rgb <17/255, 238/255, 85/255>;
#declare CN_Milady = rgb <238/255, 225/255, 220/255>;
#declare CN_Milan = rgb <246/255, 244/255, 147/255>;
#declare CN_Milano = rgb <193/255, 161/255, 129/255>;
#declare CN_Milano_Red = rgb <158/255, 51/255, 50/255>;
#declare CN_Mild_Blue = rgb <203/255, 213/255, 219/255>;
#declare CN_Mild_Blue_Yonder = rgb <162/255, 173/255, 208/255>;
#declare CN_Mild_Evergreen = rgb <142/255, 187/255, 172/255>;
#declare CN_Mild_Green = rgb <120/255, 152/255, 133/255>;
#declare CN_Mild_Mint = rgb <220/255, 230/255, 227/255>;
#declare CN_Mild_Orange = rgb <243/255, 187/255, 147/255>;
#declare CN_Mildura = rgb <102/255, 121/255, 96/255>;
#declare CN_Miles = rgb <130/255, 155/255, 160/255>;
#declare CN_Milestone = rgb <127/255, 132/255, 138/255>;
#declare CN_Militant_Vegan = rgb <34/255, 153/255, 85/255>;
#declare CN_Military_Green = rgb <102/255, 124/255, 62/255>;
#declare CN_Military_Olive = rgb <99/255, 86/255, 59/255>;
#declare CN_Milk = rgb <253/255, 255/255, 245/255>;
#declare CN_Milk_and_Cookies = rgb <233/255, 225/255, 223/255>;
#declare CN_Milk_Blue = rgb <220/255, 227/255, 231/255>;
#declare CN_Milk_Brownie_Dough = rgb <143/255, 114/255, 101/255>;
#declare CN_Milk_Chocolate = rgb <127/255, 78/255, 30/255>;
#declare CN_Milk_Coffee_Brown = rgb <150/255, 111/255, 93/255>;
#declare CN_Milk_Froth = rgb <255/255, 238/255, 204/255>;
#declare CN_Milk_Glass = rgb <250/255, 247/255, 240/255>;
#declare CN_Milk_Mustache = rgb <250/255, 243/255, 230/255>;
#declare CN_Milk_Paint = rgb <239/255, 233/255, 217/255>;
#declare CN_Milk_Punch = rgb <255/255, 244/255, 211/255>;
#declare CN_Milk_Quartz = rgb <245/255, 222/255, 174/255>;
#declare CN_Milk_Star_White = rgb <245/255, 237/255, 226/255>;
#declare CN_Milk_Thistle = rgb <158/255, 155/255, 136/255>;
#declare CN_Milk_Tooth = rgb <250/255, 235/255, 215/255>;
#declare CN_Milk_White = rgb <220/255, 217/255, 205/255>;
#declare CN_Milkshake_Pink = rgb <240/255, 205/255, 210/255>;
#declare CN_Milkweed = rgb <227/255, 232/255, 217/255>;
#declare CN_Milkweed_Pod = rgb <149/255, 152/255, 126/255>;
#declare CN_Milkwort_Red = rgb <145/255, 105/255, 129/255>;
#declare CN_Milky = rgb <226/255, 220/255, 212/255>;
#declare CN_Milky_Aquamarine = rgb <3/255, 132/255, 135/255>;
#declare CN_Milky_Blue = rgb <114/255, 168/255, 186/255>;
#declare CN_Milky_Green = rgb <207/255, 219/255, 209/255>;
#declare CN_Milky_Maize = rgb <249/255, 217/255, 160/255>;
#declare CN_Milky_Skies = rgb <195/255, 177/255, 175/255>;
#declare CN_Milky_Way = rgb <232/255, 244/255, 247/255>;
#declare CN_Milky_Way_Galaxy = rgb <250/255, 239/255, 213/255>;
#declare CN_Milky_Yellow = rgb <248/255, 221/255, 116/255>;
#declare CN_Mill_Creek = rgb <135/255, 110/255, 89/255>;
#declare CN_Millbrook = rgb <89/255, 86/255, 72/255>;
#declare CN_Mille_Feuille = rgb <239/255, 200/255, 125/255>;
#declare CN_Millennium_Silver = rgb <140/255, 149/255, 149/255>;
#declare CN_Millionaire = rgb <182/255, 132/255, 60/255>;
#declare CN_Millstream = rgb <185/255, 212/255, 222/255>;
#declare CN_Milly_Green = rgb <153/255, 189/255, 145/255>;
#declare CN_Milpa = rgb <104/255, 150/255, 99/255>;
#declare CN_Milton = rgb <180/255, 180/255, 152/255>;
#declare CN_Milvus_Milvus_Orange = rgb <187/255, 119/255, 34/255>;
#declare CN_Mimesia_Blue = rgb <34/255, 105/255, 202/255>;
#declare CN_Mimi_Pink = rgb <255/255, 218/255, 233/255>;
#declare CN_Mimolette_Orange = rgb <238/255, 136/255, 17/255>;
#declare CN_Mimosa = rgb <245/255, 233/255, 213/255>;
#declare CN_Mimosa_Yellow = rgb <223/255, 198/255, 51/255>;
#declare CN_Minced_Ginger = rgb <189/255, 179/255, 135/255>;
#declare CN_Mincemeat = rgb <182/255, 106/255, 60/255>;
#declare CN_Mindaro = rgb <218/255, 234/255, 111/255>;
#declare CN_Mindful_Gray = rgb <189/255, 181/255, 173/255>;
#declare CN_Mine_Rock = rgb <142/255, 133/255, 131/255>;
#declare CN_Mine_Shaft = rgb <55/255, 62/255, 65/255>;
#declare CN_Mined_Coal = rgb <108/255, 107/255, 101/255>;
#declare CN_Miners_Dust = rgb <211/255, 206/255, 197/255>;
#declare CN_Mineral = rgb <215/255, 209/255, 197/255>;
#declare CN_Mineral_Beige = rgb <216/255, 196/255, 159/255>;
#declare CN_Mineral_Blue = rgb <109/255, 145/255, 146/255>;
#declare CN_Mineral_Brown = rgb <77/255, 63/255, 51/255>;
#declare CN_Mineral_Deposit = rgb <171/255, 176/255, 172/255>;
#declare CN_Mineral_Glow = rgb <252/255, 232/255, 206/255>;
#declare CN_Mineral_Gray = rgb <81/255, 87/255, 99/255>;
#declare CN_Mineral_Green = rgb <80/255, 99/255, 85/255>;
#declare CN_Mineral_Grey = rgb <178/255, 182/255, 172/255>;
#declare CN_Mineral_Red = rgb <179/255, 84/255, 87/255>;
#declare CN_Mineral_Spring = rgb <237/255, 242/255, 236/255>;
#declare CN_Mineral_Umber = rgb <177/255, 139/255, 50/255>;
#declare CN_Mineral_Water = rgb <223/255, 235/255, 214/255>;
#declare CN_Mineral_White = rgb <220/255, 229/255, 217/255>;
#declare CN_Mineral_Yellow = rgb <211/255, 156/255, 67/255>;
#declare CN_Minerva = rgb <181/255, 222/255, 218/255>;
#declare CN_Minestrone = rgb <199/255, 38/255, 22/255>;
#declare CN_Ming = rgb <64/255, 117/255, 119/255>;
#declare CN_Ming_Green = rgb <58/255, 162/255, 120/255>;
#declare CN_Mini_Bay = rgb <138/255, 173/255, 207/255>;
#declare CN_Mini_Blue = rgb <150/255, 215/255, 219/255>;
#declare CN_Mini_Cake = rgb <251/255, 246/255, 222/255>;
#declare CN_Mini_Green = rgb <159/255, 197/255, 170/255>;
#declare CN_Miniature_Posey = rgb <229/255, 190/255, 186/255>;
#declare CN_Minified_Ballerina_Blue = rgb <211/255, 223/255, 234/255>;
#declare CN_Minified_Blue = rgb <179/255, 219/255, 234/255>;
#declare CN_Minified_Blush = rgb <242/255, 221/255, 225/255>;
#declare CN_Minified_Cinnamon = rgb <222/255, 217/255, 219/255>;
#declare CN_Minified_Green = rgb <221/255, 232/255, 224/255>;
#declare CN_Minified_Jade = rgb <193/255, 227/255, 233/255>;
#declare CN_Minified_Lime = rgb <235/255, 245/255, 222/255>;
#declare CN_Minified_Magenta = rgb <230/255, 223/255, 232/255>;
#declare CN_Minified_Malachite = rgb <221/255, 243/255, 229/255>;
#declare CN_Minified_Maroon = rgb <229/255, 219/255, 218/255>;
#declare CN_Minified_Mauve = rgb <224/255, 220/255, 228/255>;
#declare CN_Minified_Mint = rgb <228/255, 235/255, 220/255>;
#declare CN_Minified_Moss = rgb <227/255, 232/255, 219/255>;
#declare CN_Minified_Mustard = rgb <233/255, 230/255, 212/255>;
#declare CN_Minified_Purple = rgb <225/255, 222/255, 231/255>;
#declare CN_Minified_Yellow = rgb <244/255, 235/255, 212/255>;
#declare CN_Minimal = rgb <243/255, 238/255, 205/255>;
#declare CN_Minimal_Grey = rgb <148/255, 141/255, 153/255>;
#declare CN_Minimal_Rose = rgb <242/255, 207/255, 224/255>;
#declare CN_Minimalist = rgb <202/255, 190/255, 173/255>;
#declare CN_Minimalistic = rgb <233/255, 236/255, 229/255>;
#declare CN_Minimum_Beige = rgb <232/255, 211/255, 186/255>;
#declare CN_Minion_Yellow = rgb <254/255, 213/255, 93/255>;
#declare CN_Mink = rgb <138/255, 117/255, 97/255>;
#declare CN_Mink_Brown = rgb <103/255, 89/255, 76/255>;
#declare CN_Mink_Haze = rgb <197/255, 178/255, 159/255>;
#declare CN_Minnesota_April = rgb <155/255, 159/255, 181/255>;
#declare CN_Minor_Blue = rgb <183/255, 223/255, 232/255>;
#declare CN_Minotaur_Red = rgb <115/255, 75/255, 66/255>;
#declare CN_Minotaurus_Brown = rgb <136/255, 34/255, 17/255>;
#declare CN_Minsk = rgb <62/255, 50/255, 103/255>;
#declare CN_Minstrel_of_the_Woods = rgb <17/255, 136/255, 0/255>;
#declare CN_Minstrel_Rose = rgb <200/255, 150/255, 151/255>;
#declare CN_Mint = rgb <62/255, 180/255, 137/255>;
#declare CN_Mint_Blossom_Rose = rgb <215/255, 194/255, 206/255>;
#declare CN_Mint_Blue = rgb <188/255, 224/255, 223/255>;
#declare CN_Mint_Bonbon_Green = rgb <125/255, 182/255, 168/255>;
#declare CN_Mint_Chiffon = rgb <230/255, 253/255, 241/255>;
#declare CN_Mint_Circle = rgb <169/255, 206/255, 170/255>;
#declare CN_Mint_Cocktail_Green = rgb <184/255, 226/255, 176/255>;
#declare CN_Mint_Cold_Green = rgb <108/255, 187/255, 160/255>;
#declare CN_Mint_Condition = rgb <223/255, 251/255, 243/255>;
#declare CN_Mint_Cream = rgb <245/255, 255/255, 250/255>;
#declare CN_Mint_Emulsion = rgb <223/255, 234/255, 219/255>;
#declare CN_Mint_Fizz = rgb <230/255, 243/255, 231/255>;
#declare CN_Mint_Flash = rgb <220/255, 244/255, 230/255>;
#declare CN_Mint_Frappe = rgb <208/255, 235/255, 200/255>;
#declare CN_Mint_Gloss = rgb <200/255, 243/255, 205/255>;
#declare CN_Mint_Grasshopper = rgb <226/255, 240/255, 224/255>;
#declare CN_Mint_Green = rgb <72/255, 125/255, 73/255>;
#declare CN_Mint_Hint = rgb <236/255, 244/255, 226/255>;
#declare CN_Mint_Ice = rgb <189/255, 232/255, 216/255>;
#declare CN_Mint_Ice_Cream = rgb <152/255, 205/255, 181/255>;
#declare CN_Mint_Ice_Green = rgb <201/255, 202/255, 161/255>;
#declare CN_Mint_Jelly = rgb <69/255, 206/255, 162/255>;
#declare CN_Mint_Julep = rgb <222/255, 240/255, 163/255>;
#declare CN_Mint_Leaf = rgb <0/255, 182/255, 148/255>;
#declare CN_Mint_Leaves = rgb <106/255, 125/255, 78/255>;
#declare CN_Mint_Macaron = rgb <175/255, 238/255, 238/255>;
#declare CN_Mint_Majesty = rgb <125/255, 215/255, 192/255>;
#declare CN_Mint_Morning = rgb <0/255, 221/255, 204/255>;
#declare CN_Mint_Mousse = rgb <180/255, 204/255, 189/255>;
#declare CN_Mint_Parfait = rgb <187/255, 230/255, 187/255>;
#declare CN_Mint_Shake = rgb <218/255, 238/255, 211/255>;
#declare CN_Mint_Smoothie = rgb <197/255, 230/255, 209/255>;
#declare CN_Mint_Soap = rgb <203/255, 213/255, 177/255>;
#declare CN_Mint_Sprig = rgb <0/255, 156/255, 110/255>;
#declare CN_Mint_Tea = rgb <175/255, 238/255, 225/255>;
#declare CN_Mint_Tonic = rgb <153/255, 238/255, 170/255>;
#declare CN_Mint_Tulip = rgb <198/255, 234/255, 221/255>;
#declare CN_Mint_Twist = rgb <152/255, 203/255, 186/255>;
#declare CN_Mint_Wafer = rgb <220/255, 229/255, 216/255>;
#declare CN_Mint_Zest = rgb <207/255, 236/255, 238/255>;
#declare CN_Mint_o_licious = rgb <182/255, 233/255, 200/255>;
#declare CN_Mintage = rgb <120/255, 191/255, 178/255>;
#declare CN_Minted = rgb <224/255, 234/255, 216/255>;
#declare CN_Minted_Blue = rgb <38/255, 166/255, 190/255>;
#declare CN_Minted_Blueberry_Lemonade = rgb <179/255, 38/255, 81/255>;
#declare CN_Minted_Ice = rgb <216/255, 243/255, 235/255>;
#declare CN_Minted_Lemon = rgb <193/255, 198/255, 168/255>;
#declare CN_Mintie = rgb <171/255, 244/255, 210/255>;
#declare CN_Mintos = rgb <128/255, 217/255, 204/255>;
#declare CN_Minty_Fresh = rgb <210/255, 242/255, 231/255>;
#declare CN_Minty_Frosting = rgb <219/255, 232/255, 207/255>;
#declare CN_Minty_Green = rgb <11/255, 247/255, 125/255>;
#declare CN_Minty_Paradise = rgb <0/255, 255/255, 187/255>;
#declare CN_Minuet = rgb <165/255, 182/255, 207/255>;
#declare CN_Minuet_Rose = rgb <179/255, 128/255, 129/255>;
#declare CN_Minuet_White = rgb <232/255, 230/255, 231/255>;
#declare CN_Minuette = rgb <212/255, 119/255, 145/255>;
#declare CN_Minute_Mauve = rgb <207/255, 201/255, 200/255>;
#declare CN_Mirabella = rgb <136/255, 103/255, 147/255>;
#declare CN_Mirabelle_Yellow = rgb <243/255, 190/255, 103/255>;
#declare CN_Miracle = rgb <137/255, 134/255, 150/255>;
#declare CN_Miracle_Bay = rgb <121/255, 146/255, 146/255>;
#declare CN_Miracle_Elixir = rgb <97/255, 123/255, 166/255>;
#declare CN_Mirador = rgb <188/255, 220/255, 205/255>;
#declare CN_Mirage = rgb <55/255, 63/255, 67/255>;
#declare CN_Mirage_Blue = rgb <99/255, 108/255, 119/255>;
#declare CN_Mirage_Grey = rgb <171/255, 175/255, 174/255>;
#declare CN_Mirage_Lake = rgb <79/255, 147/255, 143/255>;
#declare CN_Mirage_White = rgb <245/255, 244/255, 230/255>;
#declare CN_Mirandas_Spike = rgb <97/255, 66/255, 81/255>;
#declare CN_Mirror_Ball = rgb <214/255, 212/255, 215/255>;
#declare CN_Mirror_Lake = rgb <122/255, 168/255, 203/255>;
#declare CN_Mirror_Mirror = rgb <168/255, 176/255, 178/255>;
#declare CN_Mirrored_Willow = rgb <142/255, 135/255, 110/255>;
#declare CN_Mischief_Maker = rgb <149/255, 71/255, 56/255>;
#declare CN_Mischief_Mouse = rgb <183/255, 186/255, 185/255>;
#declare CN_Mischievous = rgb <223/255, 242/255, 221/255>;
#declare CN_Mischka = rgb <165/255, 169/255, 178/255>;
#declare CN_Missed = rgb <239/255, 240/255, 192/255>;
#declare CN_Missing_Link = rgb <111/255, 93/255, 87/255>;
#declare CN_Mission_Bay_Blue = rgb <155/255, 169/255, 171/255>;
#declare CN_Mission_Brown = rgb <119/255, 92/255, 71/255>;
#declare CN_Mission_Control = rgb <129/255, 131/255, 135/255>;
#declare CN_Mission_Courtyard = rgb <243/255, 209/255, 179/255>;
#declare CN_Mission_Gold = rgb <183/255, 141/255, 97/255>;
#declare CN_Mission_Hills = rgb <178/255, 156/255, 127/255>;
#declare CN_Mission_Jewel = rgb <69/255, 98/255, 82/255>;
#declare CN_Mission_Stone = rgb <218/255, 197/255, 182/255>;
#declare CN_Mission_Tan = rgb <218/255, 198/255, 168/255>;
#declare CN_Mission_Tile = rgb <135/255, 76/255, 62/255>;
#declare CN_Mission_Trail = rgb <133/255, 122/255, 100/255>;
#declare CN_Mission_White = rgb <226/255, 216/255, 194/255>;
#declare CN_Mission_Wildflower = rgb <158/255, 85/255, 102/255>;
#declare CN_Mississippi_Mud = rgb <153/255, 136/255, 111/255>;
#declare CN_Mississippi_River = rgb <59/255, 99/255, 140/255>;
#declare CN_Missouri_Mud = rgb <166/255, 161/255, 155/255>;
#declare CN_Mist_Green = rgb <170/255, 206/255, 188/255>;
#declare CN_Mist_Grey = rgb <196/255, 196/255, 188/255>;
#declare CN_Mist_of_Green = rgb <227/255, 241/255, 235/255>;
#declare CN_Mist_Spirit = rgb <228/255, 235/255, 231/255>;
#declare CN_Mist_Yellow = rgb <248/255, 238/255, 214/255>;
#declare CN_Misted_Eve = rgb <162/255, 183/255, 207/255>;
#declare CN_Misted_Fern = rgb <225/255, 236/255, 209/255>;
#declare CN_Misted_Yellow = rgb <218/255, 185/255, 101/255>;
#declare CN_Mistletoe = rgb <138/255, 162/255, 130/255>;
#declare CN_Mistletoe_Kiss = rgb <152/255, 180/255, 137/255>;
#declare CN_Mistral = rgb <184/255, 191/255, 204/255>;
#declare CN_Misty = rgb <205/255, 210/255, 210/255>;
#declare CN_Misty_Afternoon = rgb <198/255, 220/255, 199/255>;
#declare CN_Misty_Aqua = rgb <188/255, 219/255, 219/255>;
#declare CN_Misty_Beach_Cattle = rgb <241/255, 238/255, 223/255>;
#declare CN_Misty_Bead = rgb <210/255, 213/255, 155/255>;
#declare CN_Misty_Blue = rgb <191/255, 205/255, 204/255>;
#declare CN_Misty_Blush = rgb <221/255, 201/255, 198/255>;
#declare CN_Misty_Coast = rgb <213/255, 217/255, 211/255>;
#declare CN_Misty_Dawn = rgb <228/255, 229/255, 224/255>;
#declare CN_Misty_Grape = rgb <101/255, 67/255, 77/255>;
#declare CN_Misty_Hillside = rgb <220/255, 229/255, 204/255>;
#declare CN_Misty_Isle = rgb <197/255, 228/255, 220/255>;
#declare CN_Misty_Jade = rgb <188/255, 217/255, 200/255>;
#declare CN_Misty_Lake = rgb <194/255, 213/255, 196/255>;
#declare CN_Misty_Lavender = rgb <219/255, 217/255, 225/255>;
#declare CN_Misty_Lawn = rgb <223/255, 250/255, 225/255>;
#declare CN_Misty_Lilac = rgb <188/255, 180/255, 196/255>;
#declare CN_Misty_Meadow = rgb <190/255, 192/255, 176/255>;
#declare CN_Misty_Moonstone = rgb <229/255, 224/255, 204/255>;
#declare CN_Misty_Moor = rgb <113/255, 137/255, 129/255>;
#declare CN_Misty_Morn = rgb <231/255, 225/255, 227/255>;
#declare CN_Misty_Morning = rgb <178/255, 200/255, 189/255>;
#declare CN_Misty_Moss = rgb <187/255, 180/255, 119/255>;
#declare CN_Misty_Mustard = rgb <247/255, 235/255, 209/255>;
#declare CN_Misty_Rose = rgb <255/255, 228/255, 225/255>;
#declare CN_Misty_Surf = rgb <181/255, 200/255, 201/255>;
#declare CN_Misty_Valley = rgb <189/255, 195/255, 137/255>;
#declare CN_Misty_Violet = rgb <219/255, 215/255, 228/255>;
#declare CN_Mitchell_Blue = rgb <13/255, 120/255, 159/255>;
#declare CN_Mithril = rgb <135/255, 135/255, 135/255>;
#declare CN_Mithril_Silver = rgb <187/255, 187/255, 193/255>;
#declare CN_Mix_Or_Match = rgb <204/255, 204/255, 186/255>;
#declare CN_Mixed_Berries = rgb <150/255, 129/255, 154/255>;
#declare CN_Mixed_Berry_Jam = rgb <106/255, 70/255, 82/255>;
#declare CN_Mixed_Fruit = rgb <249/255, 186/255, 178/255>;
#declare CN_Mixed_Veggies = rgb <113/255, 145/255, 102/255>;
#declare CN_Miyamoto_Red = rgb <228/255, 3/255, 15/255>;
#declare CN_Miyazaki_Verdant = rgb <111/255, 234/255, 62/255>;
#declare CN_Mizu = rgb <112/255, 193/255, 224/255>;
#declare CN_Mizu_Cyan = rgb <167/255, 219/255, 237/255>;
#declare CN_Mizuasagi_Green = rgb <116/255, 159/255, 141/255>;
#declare CN_Moat = rgb <62/255, 106/255, 107/255>;
#declare CN_Mobster = rgb <96/255, 90/255, 103/255>;
#declare CN_Moby_Dick = rgb <221/255, 232/255, 237/255>;
#declare CN_Moccasin = rgb <251/255, 235/255, 214/255>;
#declare CN_Mocha = rgb <157/255, 118/255, 81/255>;
#declare CN_Mocha_Accent = rgb <141/255, 129/255, 113/255>;
#declare CN_Mocha_Bisque = rgb <140/255, 84/255, 58/255>;
#declare CN_Mocha_Black = rgb <111/255, 91/255, 82/255>;
#declare CN_Mocha_Brown = rgb <107/255, 86/255, 94/255>;
#declare CN_Mocha_Dandelion = rgb <241/255, 217/255, 110/255>;
#declare CN_Mocha_Foam = rgb <187/255, 162/255, 142/255>;
#declare CN_Mocha_Glow = rgb <119/255, 51/255, 34/255>;
#declare CN_Mocha_Ice = rgb <223/255, 210/255, 202/255>;
#declare CN_Mocha_Latte = rgb <130/255, 113/255, 95/255>;
#declare CN_Mocha_Light = rgb <215/255, 207/255, 194/255>;
#declare CN_Mocha_Magic = rgb <136/255, 121/255, 109/255>;
#declare CN_Mocha_Mousse = rgb <164/255, 120/255, 100/255>;
#declare CN_Mocha_Tan = rgb <172/255, 150/255, 128/255>;
#declare CN_Mocha_Wisp = rgb <145/255, 130/255, 120/255>;
#declare CN_Mochaccino = rgb <148/255, 82/255, 0/255>;
#declare CN_Mochachino = rgb <190/255, 175/255, 147/255>;
#declare CN_Mochito = rgb <142/255, 250/255, 0/255>;
#declare CN_Mock_Orange = rgb <255/255, 163/255, 104/255>;
#declare CN_Mod_Orange = rgb <216/255, 88/255, 60/255>;
#declare CN_Modal = rgb <49/255, 166/255, 209/255>;
#declare CN_Modal_Blue = rgb <64/255, 166/255, 172/255>;
#declare CN_Mode_Beige = rgb <150/255, 113/255, 31/255>;
#declare CN_Moderate_White = rgb <233/255, 222/255, 207/255>;
#declare CN_Modern_Blue = rgb <186/255, 209/255, 233/255>;
#declare CN_Modern_Gray = rgb <213/255, 206/255, 194/255>;
#declare CN_Modern_History = rgb <190/255, 162/255, 125/255>;
#declare CN_Modern_Ivory = rgb <245/255, 236/255, 220/255>;
#declare CN_Modern_Lavender = rgb <168/255, 170/255, 179/255>;
#declare CN_Modern_Mint = rgb <136/255, 163/255, 149/255>;
#declare CN_Modern_Mocha = rgb <157/255, 131/255, 118/255>;
#declare CN_Modern_Monument = rgb <214/255, 214/255, 209/255>;
#declare CN_Modern_Zen = rgb <224/255, 222/255, 178/255>;
#declare CN_Moderne_Class = rgb <116/255, 91/255, 73/255>;
#declare CN_Modest_Mauve = rgb <131/255, 132/255, 146/255>;
#declare CN_Modest_Violet = rgb <233/255, 228/255, 239/255>;
#declare CN_Modest_White = rgb <230/255, 221/255, 212/255>;
#declare CN_Modestly_Peach = rgb <238/255, 165/255, 157/255>;
#declare CN_Modesty = rgb <212/255, 199/255, 217/255>;
#declare CN_Modish_Moss = rgb <195/255, 182/255, 139/255>;
#declare CN_Moegi_Green = rgb <241/255, 145/255, 114/255>;
#declare CN_Moelleux_Au_Chocolat = rgb <85/255, 51/255, 17/255>;
#declare CN_Moenkopi_Soil = rgb <200/255, 166/255, 146/255>;
#declare CN_Mogwa_Cheong_Yellow = rgb <221/255, 204/255, 0/255>;
#declare CN_Mohair_Mauve = rgb <191/255, 165/255, 158/255>;
#declare CN_Mohair_Pink = rgb <167/255, 133/255, 148/255>;
#declare CN_Mohair_Soft_Blue_Grey = rgb <151/255, 178/255, 183/255>;
#declare CN_Mohalla = rgb <167/255, 155/255, 126/255>;
#declare CN_Moire = rgb <190/255, 173/255, 176/255>;
#declare CN_Moire_Satin = rgb <102/255, 93/255, 99/255>;
#declare CN_Moist_Gold = rgb <219/255, 219/255, 112/255>;
#declare CN_Moist_Silver = rgb <224/255, 231/255, 221/255>;
#declare CN_Moisty_Mire = rgb <0/255, 68/255, 34/255>;
#declare CN_Mojave_Desert = rgb <199/255, 181/255, 149/255>;
#declare CN_Mojave_Dusk = rgb <185/255, 145/255, 120/255>;
#declare CN_Mojave_Gold = rgb <191/255, 156/255, 101/255>;
#declare CN_Mojave_Sunset = rgb <170/255, 106/255, 83/255>;
#declare CN_Mojito = rgb <228/255, 243/255, 224/255>;
#declare CN_Mojo = rgb <151/255, 70/255, 60/255>;
#declare CN_Molasses = rgb <87/255, 74/255, 71/255>;
#declare CN_Molasses_Cookie = rgb <139/255, 113/255, 75/255>;
#declare CN_Moldy_Ochre = rgb <213/255, 163/255, 0/255>;
#declare CN_Mole = rgb <57/255, 45/255, 43/255>;
#declare CN_Mole_Grey = rgb <147/255, 143/255, 138/255>;
#declare CN_Moleskin = rgb <176/255, 161/255, 150/255>;
#declare CN_Molly_Green = rgb <227/255, 239/255, 227/255>;
#declare CN_Molly_Robins = rgb <77/255, 139/255, 114/255>;
#declare CN_Molten_Bronze = rgb <198/255, 156/255, 4/255>;
#declare CN_Molten_Core = rgb <255/255, 88/255, 0/255>;
#declare CN_Molten_Ice = rgb <225/255, 237/255, 230/255>;
#declare CN_Molten_Lava = rgb <181/255, 51/255, 46/255>;
#declare CN_Molten_Lead = rgb <104/255, 106/255, 105/255>;
#declare CN_Moms_Apple_Pie = rgb <234/255, 183/255, 129/255>;
#declare CN_Moms_Love = rgb <255/255, 212/255, 187/255>;
#declare CN_Momentum = rgb <116/255, 111/255, 92/255>;
#declare CN_Momo_Peach = rgb <244/255, 121/255, 131/255>;
#declare CN_Momoshio_Brown = rgb <84/255, 45/255, 36/255>;
#declare CN_Mona_Lisa = rgb <255/255, 152/255, 137/255>;
#declare CN_Monaco = rgb <171/255, 212/255, 230/255>;
#declare CN_Monaco_Blue = rgb <39/255, 67/255, 116/255>;
#declare CN_Monarch = rgb <107/255, 37/255, 44/255>;
#declare CN_Monarch_Gold = rgb <183/255, 129/255, 60/255>;
#declare CN_Monarch_Migration = rgb <191/255, 118/255, 76/255>;
#declare CN_Monarch_Orange = rgb <239/255, 160/255, 107/255>;
#declare CN_Monarch_Wing = rgb <255/255, 141/255, 37/255>;
#declare CN_Monarchs_Cocoon = rgb <140/255, 178/255, 147/255>;
#declare CN_Monarchist = rgb <75/255, 98/255, 210/255>;
#declare CN_Monarchy = rgb <144/255, 147/255, 173/255>;
#declare CN_Monastery_Mantle = rgb <65/255, 54/255, 58/255>;
#declare CN_Monastic = rgb <171/255, 169/255, 210/255>;
#declare CN_Monastir = rgb <183/255, 137/255, 153/255>;
#declare CN_Moncur = rgb <155/255, 185/255, 174/255>;
#declare CN_Mondo = rgb <85/255, 77/255, 66/255>;
#declare CN_Mondrian_Blue = rgb <15/255, 71/255, 140/255>;
#declare CN_Monet = rgb <195/255, 207/255, 220/255>;
#declare CN_Monet_Lily = rgb <205/255, 215/255, 230/255>;
#declare CN_Monet_Magic = rgb <193/255, 172/255, 195/255>;
#declare CN_Monet_Moonrise = rgb <238/255, 240/255, 209/255>;
#declare CN_Monets_Lavender = rgb <221/255, 224/255, 234/255>;
#declare CN_Money = rgb <123/255, 154/255, 109/255>;
#declare CN_Money_Banks = rgb <170/255, 190/255, 73/255>;
#declare CN_Money_Tree = rgb <201/255, 147/255, 122/255>;
#declare CN_Mongolian_Plateau = rgb <119/255, 119/255, 0/255>;
#declare CN_Mongoose = rgb <165/255, 139/255, 111/255>;
#declare CN_Monks_Cloth = rgb <110/255, 99/255, 85/255>;
#declare CN_Monkey_Island = rgb <85/255, 59/255, 57/255>;
#declare CN_Monkey_Madness = rgb <99/255, 88/255, 76/255>;
#declare CN_Monks_Robe = rgb <112/255, 72/255, 34/255>;
#declare CN_Monogram = rgb <89/255, 87/255, 71/255>;
#declare CN_Monologue = rgb <161/255, 188/255, 216/255>;
#declare CN_Monorail_Silver = rgb <184/255, 188/255, 187/255>;
#declare CN_Monroe_Kiss = rgb <222/255, 193/255, 184/255>;
#declare CN_Monsoon = rgb <122/255, 118/255, 121/255>;
#declare CN_Monstera_Deliciosa = rgb <117/255, 191/255, 10/255>;
#declare CN_Monstrous_Green = rgb <34/255, 204/255, 17/255>;
#declare CN_Mont_Blanc = rgb <158/255, 182/255, 216/255>;
#declare CN_Mont_Blanc_Peak = rgb <242/255, 231/255, 231/255>;
#declare CN_Montage = rgb <129/255, 144/255, 164/255>;
#declare CN_Montana = rgb <57/255, 59/255, 60/255>;
#declare CN_Montana_Grape = rgb <108/255, 89/255, 113/255>;
#declare CN_Montana_Sky = rgb <106/255, 176/255, 185/255>;
#declare CN_Montauk_Sands = rgb <187/255, 173/255, 158/255>;
#declare CN_Monte_Carlo = rgb <122/255, 197/255, 180/255>;
#declare CN_Montecito = rgb <182/255, 161/255, 128/255>;
#declare CN_Montego_Bay = rgb <63/255, 186/255, 189/255>;
#declare CN_Monterey_Brown = rgb <148/255, 110/255, 92/255>;
#declare CN_Monterey_Chestnut = rgb <125/255, 66/255, 53/255>;
#declare CN_Montezuma = rgb <210/255, 205/255, 182/255>;
#declare CN_Montezuma_Gold = rgb <238/255, 204/255, 68/255>;
#declare CN_Montezuma_Hills = rgb <166/255, 178/255, 164/255>;
#declare CN_Montezumas_Castle = rgb <217/255, 173/255, 158/255>;
#declare CN_Montreux_Blue = rgb <88/255, 121/255, 162/255>;
#declare CN_Montrose_Rose = rgb <157/255, 106/255, 115/255>;
#declare CN_Monument = rgb <132/255, 137/255, 140/255>;
#declare CN_Monument_Grey = rgb <122/255, 128/255, 122/255>;
#declare CN_Monza = rgb <199/255, 3/255, 30/255>;
#declare CN_Moo = rgb <251/255, 229/255, 189/255>;
#declare CN_Mood_Indigo = rgb <53/255, 58/255, 76/255>;
#declare CN_Mood_Lighting = rgb <255/255, 231/255, 213/255>;
#declare CN_Mood_Mode = rgb <127/255, 144/255, 203/255>;
#declare CN_Moody_Black = rgb <73/255, 85/255, 93/255>;
#declare CN_Moody_Blue = rgb <131/255, 120/255, 199/255>;
#declare CN_Moody_Blues = rgb <88/255, 110/255, 117/255>;
#declare CN_Mooloolaba = rgb <199/255, 184/255, 169/255>;
#declare CN_Moon_Base = rgb <125/255, 125/255, 119/255>;
#declare CN_Moon_Buggy = rgb <199/255, 189/255, 193/255>;
#declare CN_Moon_Dance = rgb <250/255, 239/255, 190/255>;
#declare CN_Moon_Drop = rgb <221/255, 213/255, 201/255>;
#declare CN_Moon_Dust = rgb <224/255, 230/255, 240/255>;
#declare CN_Moon_Glass = rgb <188/255, 209/255, 199/255>;
#declare CN_Moon_Glow = rgb <245/255, 243/255, 206/255>;
#declare CN_Moon_Goddess = rgb <207/255, 199/255, 213/255>;
#declare CN_Moon_Jellyfish = rgb <142/255, 184/255, 206/255>;
#declare CN_Moon_Lily = rgb <230/255, 230/255, 231/255>;
#declare CN_Moon_Mist = rgb <206/255, 205/255, 184/255>;
#declare CN_Moon_Rise = rgb <244/255, 244/255, 232/255>;
#declare CN_Moon_Rock = rgb <149/255, 139/255, 132/255>;
#declare CN_Moon_Rose = rgb <185/255, 171/255, 165/255>;
#declare CN_Moon_Shell = rgb <233/255, 227/255, 216/255>;
#declare CN_Moon_Valley = rgb <252/255, 241/255, 222/255>;
#declare CN_Moon_White = rgb <234/255, 244/255, 252/255>;
#declare CN_Moon_Yellow = rgb <240/255, 196/255, 32/255>;
#declare CN_Moonbeam = rgb <205/255, 198/255, 189/255>;
#declare CN_Moondance = rgb <229/255, 222/255, 204/255>;
#declare CN_Moondoggie = rgb <243/255, 222/255, 191/255>;
#declare CN_Moonglade_Water = rgb <101/255, 255/255, 255/255>;
#declare CN_Moonglow = rgb <248/255, 228/255, 196/255>;
#declare CN_Moonless_Night = rgb <47/255, 45/255, 48/255>;
#declare CN_Moonlight = rgb <246/255, 238/255, 213/255>;
#declare CN_Moonlight_Blue = rgb <80/255, 104/255, 134/255>;
#declare CN_Moonlight_Green = rgb <210/255, 232/255, 216/255>;
#declare CN_Moonlight_Jade = rgb <199/255, 229/255, 223/255>;
#declare CN_Moonlight_Melody = rgb <175/255, 115/255, 176/255>;
#declare CN_Moonlight_White = rgb <249/255, 240/255, 222/255>;
#declare CN_Moonlight_Yellow = rgb <225/255, 195/255, 139/255>;
#declare CN_Moonlit_Beach = rgb <249/255, 240/255, 230/255>;
#declare CN_Moonlit_Mauve = rgb <210/255, 143/255, 176/255>;
#declare CN_Moonlit_Ocean = rgb <41/255, 59/255, 77/255>;
#declare CN_Moonlit_Orchid = rgb <148/255, 145/255, 148/255>;
#declare CN_Moonlit_Pool = rgb <32/255, 90/255, 97/255>;
#declare CN_Moonlit_Snow = rgb <234/255, 238/255, 236/255>;
#declare CN_Moonmist = rgb <201/255, 217/255, 224/255>;
#declare CN_Moonquake = rgb <141/255, 149/255, 150/255>;
#declare CN_Moonraker = rgb <192/255, 178/255, 215/255>;
#declare CN_Moonrose = rgb <165/255, 63/255, 72/255>;
#declare CN_Moonscape = rgb <114/255, 95/255, 105/255>;
#declare CN_Moonshade = rgb <90/255, 110/255, 156/255>;
#declare CN_Moonshadow = rgb <152/255, 69/255, 176/255>;
#declare CN_Moonstone = rgb <58/255, 168/255, 193/255>;
#declare CN_Moonstone_Blue = rgb <115/255, 169/255, 194/255>;
#declare CN_Moonstruck = rgb <252/255, 240/255, 194/255>;
#declare CN_Moonwalk = rgb <190/255, 190/255, 196/255>;
#declare CN_Moonwort = rgb <165/255, 174/255, 159/255>;
#declare CN_Moor_Oak_Grey = rgb <106/255, 88/255, 77/255>;
#declare CN_Moor_Pond_Green = rgb <60/255, 100/255, 97/255>;
#declare CN_Moorland = rgb <166/255, 171/255, 155/255>;
#declare CN_Moorland_Heather = rgb <204/255, 148/255, 190/255>;
#declare CN_Moorstone = rgb <207/255, 209/255, 202/255>;
#declare CN_Moose_Fur = rgb <114/255, 84/255, 64/255>;
#declare CN_Moose_Trail = rgb <107/255, 84/255, 69/255>;
#declare CN_Moosewood = rgb <93/255, 87/255, 68/255>;
#declare CN_Moot_Green = rgb <162/255, 219/255, 16/255>;
#declare CN_Moping_Green = rgb <0/255, 238/255, 51/255>;
#declare CN_Morado_Purple = rgb <153/255, 85/255, 204/255>;
#declare CN_Morality = rgb <180/255, 205/255, 229/255>;
#declare CN_Morass = rgb <114/255, 97/255, 56/255>;
#declare CN_Moray = rgb <200/255, 189/255, 106/255>;
#declare CN_Moray_Eel = rgb <0/255, 167/255, 139/255>;
#declare CN_Mordant_Blue = rgb <42/255, 102/255, 113/255>;
#declare CN_Mordant_Red_19 = rgb <174/255, 12/255, 0/255>;
#declare CN_Mordian_Blue = rgb <47/255, 86/255, 132/255>;
#declare CN_More_Maple = rgb <208/255, 171/255, 112/255>;
#declare CN_More_Melon = rgb <224/255, 227/255, 200/255>;
#declare CN_More_Mint = rgb <230/255, 232/255, 197/255>;
#declare CN_More_Than_A_Week = rgb <141/255, 141/255, 141/255>;
#declare CN_Morel = rgb <104/255, 92/255, 83/255>;
#declare CN_Morganite = rgb <223/255, 205/255, 198/255>;
#declare CN_Morning_at_Sea = rgb <130/255, 151/255, 155/255>;
#declare CN_Morning_Blue = rgb <141/255, 163/255, 153/255>;
#declare CN_Morning_Blush = rgb <249/255, 232/255, 223/255>;
#declare CN_Morning_Bread = rgb <231/255, 230/255, 222/255>;
#declare CN_Morning_Breeze = rgb <213/255, 227/255, 222/255>;
#declare CN_Morning_Calm = rgb <206/255, 238/255, 239/255>;
#declare CN_Morning_Dew = rgb <176/255, 185/255, 172/255>;
#declare CN_Morning_Dew_White = rgb <198/255, 219/255, 214/255>;
#declare CN_Morning_Fog = rgb <208/255, 219/255, 215/255>;
#declare CN_Morning_Forest = rgb <109/255, 174/255, 129/255>;
#declare CN_Morning_Frost = rgb <235/255, 244/255, 223/255>;
#declare CN_Morning_Glory = rgb <158/255, 209/255, 211/255>;
#declare CN_Morning_Glory_Pink = rgb <202/255, 153/255, 183/255>;
#declare CN_Morning_Glow = rgb <238/255, 240/255, 214/255>;
#declare CN_Morning_Green = rgb <137/255, 186/255, 178/255>;
#declare CN_Morning_Haze = rgb <224/255, 232/255, 237/255>;
#declare CN_Morning_Light_Wave = rgb <224/255, 239/255, 233/255>;
#declare CN_Morning_Mist = rgb <229/255, 237/255, 241/255>;
#declare CN_Morning_Mist_Grey = rgb <173/255, 167/255, 185/255>;
#declare CN_Morning_Moon = rgb <247/255, 238/255, 207/255>;
#declare CN_Morning_Moor = rgb <218/255, 214/255, 174/255>;
#declare CN_Morning_Parlor = rgb <172/255, 192/255, 189/255>;
#declare CN_Morning_Rush = rgb <222/255, 228/255, 220/255>;
#declare CN_Morning_Shine = rgb <248/255, 234/255, 237/255>;
#declare CN_Morning_Sigh = rgb <252/255, 233/255, 222/255>;
#declare CN_Morning_Sky = rgb <199/255, 236/255, 234/255>;
#declare CN_Morning_Snow = rgb <245/255, 244/255, 237/255>;
#declare CN_Morning_Song = rgb <228/255, 236/255, 233/255>;
#declare CN_Morning_Sun = rgb <243/255, 230/255, 206/255>;
#declare CN_Morning_Sunlight = rgb <253/255, 239/255, 204/255>;
#declare CN_Morning_Tea = rgb <202/255, 189/255, 148/255>;
#declare CN_Morning_Wheat = rgb <231/255, 210/255, 169/255>;
#declare CN_Morning_Zen = rgb <203/255, 205/255, 185/255>;
#declare CN_Mornings_Egg = rgb <217/255, 190/255, 119/255>;
#declare CN_Morningside = rgb <243/255, 226/255, 223/255>;
#declare CN_Mornington = rgb <220/255, 198/255, 185/255>;
#declare CN_Moroccan_Blue = rgb <15/255, 78/255, 103/255>;
#declare CN_Moroccan_Blunt = rgb <117/255, 88/255, 61/255>;
#declare CN_Moroccan_Brown = rgb <124/255, 114/255, 108/255>;
#declare CN_Moroccan_Dusk = rgb <107/255, 94/255, 93/255>;
#declare CN_Moroccan_Henna = rgb <110/255, 80/255, 67/255>;
#declare CN_Moroccan_Leather = rgb <109/255, 68/255, 68/255>;
#declare CN_Moroccan_Moonlight = rgb <234/255, 224/255, 212/255>;
#declare CN_Moroccan_Ruby = rgb <141/255, 80/255, 75/255>;
#declare CN_Moroccan_Sky = rgb <191/255, 119/255, 86/255>;
#declare CN_Moroccan_Spice = rgb <143/255, 98/255, 59/255>;
#declare CN_Morocco = rgb <182/255, 114/255, 103/255>;
#declare CN_Morocco_Brown = rgb <68/255, 45/255, 33/255>;
#declare CN_Morocco_Red = rgb <150/255, 69/255, 59/255>;
#declare CN_Morocco_Sand = rgb <236/255, 227/255, 204/255>;
#declare CN_Morris_Artichoke = rgb <140/255, 178/255, 149/255>;
#declare CN_Morris_Leaf = rgb <194/255, 211/255, 175/255>;
#declare CN_Morris_Room_Grey = rgb <173/255, 161/255, 147/255>;
#declare CN_Morro_Bay = rgb <84/255, 107/255, 120/255>;
#declare CN_Morrow_White = rgb <252/255, 252/255, 207/255>;
#declare CN_Mortar = rgb <86/255, 80/255, 81/255>;
#declare CN_Mortar_Grey = rgb <158/255, 159/255, 158/255>;
#declare CN_Mosaic_Blue = rgb <0/255, 117/255, 143/255>;
#declare CN_Mosaic_Green = rgb <89/255, 159/255, 104/255>;
#declare CN_Mosaic_Tile = rgb <28/255, 107/255, 105/255>;
#declare CN_Moscow_Midnight = rgb <32/255, 70/255, 82/255>;
#declare CN_Moscow_Mule = rgb <238/255, 204/255, 119/255>;
#declare CN_Moscow_Papyrus = rgb <147/255, 124/255, 0/255>;
#declare CN_Moselle_Green = rgb <46/255, 78/255, 54/255>;
#declare CN_Mosque = rgb <0/255, 95/255, 91/255>;
#declare CN_Moss = rgb <0/255, 144/255, 81/255>;
#declare CN_Moss_Beach = rgb <107/255, 112/255, 97/255>;
#declare CN_Moss_Brown = rgb <113/255, 91/255, 46/255>;
#declare CN_Moss_Cottage = rgb <66/255, 84/255, 76/255>;
#declare CN_Moss_Covered = rgb <122/255, 126/255, 102/255>;
#declare CN_Moss_Glen = rgb <74/255, 71/255, 63/255>;
#declare CN_Moss_Green = rgb <99/255, 139/255, 39/255>;
#declare CN_Moss_Grey = rgb <175/255, 171/255, 151/255>;
#declare CN_Moss_Ink = rgb <199/255, 202/255, 193/255>;
#declare CN_Moss_Island = rgb <200/255, 198/255, 180/255>;
#declare CN_Moss_Landing = rgb <109/255, 126/255, 64/255>;
#declare CN_Moss_Mist = rgb <222/255, 225/255, 211/255>;
#declare CN_Moss_Point_Green = rgb <126/255, 141/255, 96/255>;
#declare CN_Moss_Print = rgb <175/255, 183/255, 150/255>;
#declare CN_Moss_Ring = rgb <114/255, 144/255, 103/255>;
#declare CN_Moss_Rock = rgb <94/255, 91/255, 77/255>;
#declare CN_Moss_Rose = rgb <143/255, 109/255, 107/255>;
#declare CN_Moss_Stone = rgb <180/255, 165/255, 75/255>;
#declare CN_Moss_Vale = rgb <56/255, 97/255, 76/255>;
#declare CN_Mossa = rgb <180/255, 194/255, 182/255>;
#declare CN_Mosslands = rgb <119/255, 153/255, 102/255>;
#declare CN_Mossleaf = rgb <140/255, 157/255, 143/255>;
#declare CN_Mosstone = rgb <133/255, 137/255, 97/255>;
#declare CN_Mossy = rgb <133/255, 115/255, 73/255>;
#declare CN_Mossy_Bank = rgb <139/255, 135/255, 112/255>;
#declare CN_Mossy_Bench = rgb <131/255, 162/255, 143/255>;
#declare CN_Mossy_Bronze = rgb <82/255, 95/255, 72/255>;
#declare CN_Mossy_Cavern = rgb <164/255, 169/255, 123/255>;
#declare CN_Mossy_Gold = rgb <156/255, 146/255, 115/255>;
#declare CN_Mossy_Green = rgb <90/255, 124/255, 70/255>;
#declare CN_Mossy_Oak = rgb <132/255, 129/255, 120/255>;
#declare CN_Mossy_Pavement = rgb <144/255, 140/255, 126/255>;
#declare CN_Mossy_Rock = rgb <169/255, 150/255, 93/255>;
#declare CN_Mossy_Shade = rgb <126/255, 108/255, 68/255>;
#declare CN_Mossy_Statue = rgb <130/255, 142/255, 116/255>;
#declare CN_Mossy_White = rgb <231/255, 242/255, 222/255>;
#declare CN_Mossy_Woods = rgb <122/255, 151/255, 3/255>;
#declare CN_Mostly_Metal = rgb <87/255, 94/255, 95/255>;
#declare CN_Mote_of_Dust = rgb <193/255, 193/255, 197/255>;
#declare CN_Moth = rgb <210/255, 203/255, 175/255>;
#declare CN_Moth_Green = rgb <0/255, 119/255, 0/255>;
#declare CN_Moth_Grey = rgb <218/255, 211/255, 203/255>;
#declare CN_Moth_Mist = rgb <237/255, 235/255, 222/255>;
#declare CN_Moth_Orchid = rgb <200/255, 117/255, 196/255>;
#declare CN_Moth_Pink = rgb <207/255, 189/255, 186/255>;
#declare CN_Moth_Wing = rgb <204/255, 188/255, 169/255>;
#declare CN_Moths_Wing = rgb <237/255, 241/255, 219/255>;
#declare CN_Mother_Earth = rgb <132/255, 156/255, 141/255>;
#declare CN_Mother_Lode = rgb <162/255, 135/255, 97/255>;
#declare CN_Mother_Nature = rgb <189/255, 225/255, 196/255>;
#declare CN_Mother_of_Pearl = rgb <233/255, 212/255, 195/255>;
#declare CN_Mother_Of_Pearl_Green = rgb <143/255, 216/255, 159/255>;
#declare CN_Mother_Of_Pearl_Pink = rgb <209/255, 196/255, 198/255>;
#declare CN_Mother_Of_Pearl_Silver = rgb <204/255, 214/255, 230/255>;
#declare CN_Motherland = rgb <188/255, 182/255, 103/255>;
#declare CN_Mothra_Wing = rgb <238/255, 221/255, 130/255>;
#declare CN_Mothy = rgb <206/255, 187/255, 179/255>;
#declare CN_Motto = rgb <145/255, 124/255, 111/255>;
#declare CN_Mount_Eden = rgb <231/255, 239/255, 224/255>;
#declare CN_Mount_Etna = rgb <61/255, 72/255, 76/255>;
#declare CN_Mount_Hyjal = rgb <61/255, 112/255, 62/255>;
#declare CN_Mount_Olive = rgb <113/255, 102/255, 70/255>;
#declare CN_Mount_Olympus = rgb <212/255, 255/255, 255/255>;
#declare CN_Mount_Sterling = rgb <202/255, 211/255, 212/255>;
#declare CN_Mount_Tam = rgb <124/255, 123/255, 106/255>;
#declare CN_Mountain_Air = rgb <230/255, 224/255, 224/255>;
#declare CN_Mountain_Ash = rgb <204/255, 119/255, 0/255>;
#declare CN_Mountain_Blueberry = rgb <60/255, 75/255, 108/255>;
#declare CN_Mountain_Bluebird = rgb <76/255, 152/255, 194/255>;
#declare CN_Mountain_Crystal_Silver = rgb <226/255, 239/255, 232/255>;
#declare CN_Mountain_Dew = rgb <207/255, 226/255, 224/255>;
#declare CN_Mountain_Elk = rgb <134/255, 121/255, 101/255>;
#declare CN_Mountain_Falls = rgb <189/255, 202/255, 192/255>;
#declare CN_Mountain_Fern = rgb <148/255, 180/255, 145/255>;
#declare CN_Mountain_Fig = rgb <56/255, 60/255, 73/255>;
#declare CN_Mountain_Flower_Mauve = rgb <108/255, 113/255, 166/255>;
#declare CN_Mountain_Fog = rgb <244/255, 219/255, 199/255>;
#declare CN_Mountain_Forest = rgb <77/255, 102/255, 62/255>;
#declare CN_Mountain_Green = rgb <178/255, 181/255, 153/255>;
#declare CN_Mountain_Grey = rgb <232/255, 227/255, 219/255>;
#declare CN_Mountain_Haze = rgb <108/255, 110/255, 126/255>;
#declare CN_Mountain_Heather = rgb <238/255, 218/255, 230/255>;
#declare CN_Mountain_Lake = rgb <45/255, 89/255, 117/255>;
#declare CN_Mountain_Lake_Azure = rgb <76/255, 188/255, 167/255>;
#declare CN_Mountain_Lake_Blue = rgb <133/255, 212/255, 212/255>;
#declare CN_Mountain_Lake_Green = rgb <117/255, 185/255, 150/255>;
#declare CN_Mountain_Laurel = rgb <244/255, 200/255, 213/255>;
#declare CN_Mountain_Lichen = rgb <167/255, 174/255, 158/255>;
#declare CN_Mountain_Main = rgb <141/255, 184/255, 208/255>;
#declare CN_Mountain_Maize = rgb <239/255, 204/255, 124/255>;
#declare CN_Mountain_Meadow = rgb <48/255, 186/255, 143/255>;
#declare CN_Mountain_Meadow_Green = rgb <65/255, 134/255, 56/255>;
#declare CN_Mountain_Mint = rgb <167/255, 224/255, 194/255>;
#declare CN_Mountain_Mist = rgb <160/255, 159/255, 156/255>;
#declare CN_Mountain_Morn = rgb <212/255, 220/255, 209/255>;
#declare CN_Mountain_Moss = rgb <148/255, 162/255, 147/255>;
#declare CN_Mountain_Pass = rgb <92/255, 106/255, 106/255>;
#declare CN_Mountain_Pine = rgb <59/255, 82/255, 87/255>;
#declare CN_Mountain_Range_Blue = rgb <83/255, 184/255, 201/255>;
#declare CN_Mountain_Range_Green = rgb <40/255, 49/255, 35/255>;
#declare CN_Mountain_Ridge = rgb <117/255, 102/255, 94/255>;
#declare CN_Mountain_Road = rgb <134/255, 133/255, 120/255>;
#declare CN_Mountain_Sage = rgb <163/255, 170/255, 140/255>;
#declare CN_Mountain_Shade = rgb <177/255, 171/255, 154/255>;
#declare CN_Mountain_Spring = rgb <217/255, 225/255, 193/255>;
#declare CN_Mountain_Stream = rgb <150/255, 175/255, 183/255>;
#declare CN_Mountain_Trail = rgb <97/255, 87/255, 66/255>;
#declare CN_Mountain_View = rgb <46/255, 61/255, 48/255>;
#declare CN_Mountains_Majesty = rgb <216/255, 208/255, 227/255>;
#declare CN_Mountbatten_Pink = rgb <153/255, 122/255, 141/255>;
#declare CN_Mourn_Mountain_Snow = rgb <233/255, 234/255, 235/255>;
#declare CN_Mournfang_Brown = rgb <111/255, 87/255, 73/255>;
#declare CN_Mourning_Dove = rgb <148/255, 144/255, 139/255>;
#declare CN_Mourning_Violet = rgb <71/255, 67/255, 84/255>;
#declare CN_Mouse_Catcher = rgb <158/255, 146/255, 143/255>;
#declare CN_Mouse_Nose = rgb <255/255, 229/255, 180/255>;
#declare CN_Mouse_Tail = rgb <114/255, 118/255, 100/255>;
#declare CN_Mouse_Trap = rgb <190/255, 177/255, 176/255>;
#declare CN_Moussaka = rgb <109/255, 42/255, 19/255>;
#declare CN_Mousy_Brown = rgb <92/255, 73/255, 57/255>;
#declare CN_Mousy_Indigo = rgb <92/255, 84/255, 78/255>;
#declare CN_Moutarde_de_Benichon = rgb <191/255, 144/255, 5/255>;
#declare CN_Move_Mint = rgb <78/255, 255/255, 205/255>;
#declare CN_Mover__Shaker = rgb <156/255, 206/255, 158/255>;
#declare CN_Mover_and_Shaker = rgb <133/255, 93/255, 68/255>;
#declare CN_Movie_Magic = rgb <178/255, 191/255, 213/255>;
#declare CN_Movie_Star = rgb <197/255, 32/255, 51/255>;
#declare CN_Mow_the_Lawn = rgb <169/255, 180/255, 154/255>;
#declare CN_Mown_Grass = rgb <98/255, 121/255, 72/255>;
#declare CN_Mown_Hay = rgb <230/255, 211/255, 187/255>;
#declare CN_Moxie = rgb <229/255, 218/255, 216/255>;
#declare CN_Mozart = rgb <72/255, 84/255, 128/255>;
#declare CN_Mozzarella_Covered_Chorizo = rgb <227/255, 155/255, 122/255>;
#declare CN_Mr_Frosty = rgb <163/255, 197/255, 219/255>;
#declare CN_Mr_Mustard = rgb <228/255, 184/255, 87/255>;
#declare CN_Mr_Glass = rgb <192/255, 213/255, 239/255>;
#declare CN_Ms_Pac_Man_Kiss = rgb <255/255, 0/255, 170/255>;
#declare CN_MSU_Green = rgb <24/255, 69/255, 59/255>;
#declare CN_Mt_Burleigh = rgb <89/255, 119/255, 102/255>;
#declare CN_Mt_Hood_White = rgb <231/255, 233/255, 230/255>;
#declare CN_Mt_Rushmore = rgb <127/255, 129/255, 129/255>;
#declare CN_Mu_Li_Bai_Oyster = rgb <241/255, 242/255, 211/255>;
#declare CN_Mud = rgb <112/255, 84/255, 62/255>;
#declare CN_Mud_Ball = rgb <150/255, 101/255, 68/255>;
#declare CN_Mud_Bath = rgb <124/255, 104/255, 65/255>;
#declare CN_Mud_Berry = rgb <208/255, 200/255, 196/255>;
#declare CN_Mud_Brown = rgb <96/255, 70/255, 15/255>;
#declare CN_Mud_Green = rgb <96/255, 102/255, 2/255>;
#declare CN_Mud_House = rgb <132/255, 113/255, 70/255>;
#declare CN_Mud_Pack = rgb <157/255, 149/255, 136/255>;
#declare CN_Mud_Pink = rgb <220/255, 192/255, 195/255>;
#declare CN_Mud_Pots = rgb <182/255, 181/255, 177/255>;
#declare CN_Mud_Puddle = rgb <157/255, 149/255, 139/255>;
#declare CN_Mud_Room = rgb <96/255, 88/255, 75/255>;
#declare CN_Mud_Yellow = rgb <193/255, 129/255, 54/255>;
#declare CN_Mud_Dell = rgb <160/255, 139/255, 118/255>;
#declare CN_Mudbrick = rgb <164/255, 105/255, 96/255>;
#declare CN_Muddled_Basil = rgb <90/255, 82/255, 67/255>;
#declare CN_Muddy_Brown = rgb <136/255, 104/255, 6/255>;
#declare CN_Muddy_Green = rgb <101/255, 116/255, 50/255>;
#declare CN_Muddy_Mauve = rgb <228/255, 179/255, 204/255>;
#declare CN_Muddy_Olive = rgb <75/255, 93/255, 70/255>;
#declare CN_Muddy_Quicksand = rgb <195/255, 152/255, 139/255>;
#declare CN_Muddy_River = rgb <113/255, 93/255, 61/255>;
#declare CN_Muddy_Rose = rgb <226/255, 190/255, 180/255>;
#declare CN_Muddy_Waters = rgb <169/255, 132/255, 79/255>;
#declare CN_Muddy_Yellow = rgb <191/255, 172/255, 5/255>;
#declare CN_Mudra = rgb <184/255, 208/255, 218/255>;
#declare CN_Mudskipper = rgb <137/255, 122/255, 105/255>;
#declare CN_Mudslide = rgb <132/255, 115/255, 95/255>;
#declare CN_Mudstone = rgb <132/255, 132/255, 111/255>;
#declare CN_Muesli = rgb <158/255, 126/255, 83/255>;
#declare CN_Muffin_Magic = rgb <249/255, 221/255, 199/255>;
#declare CN_Muffin_Mix = rgb <245/255, 224/255, 208/255>;
#declare CN_Mughal_Green = rgb <68/255, 136/255, 0/255>;
#declare CN_Mukluks = rgb <163/255, 137/255, 97/255>;
#declare CN_Mulberry = rgb <146/255, 10/255, 78/255>;
#declare CN_Mulberry_Brown = rgb <149/255, 111/255, 41/255>;
#declare CN_Mulberry_Bush = rgb <173/255, 110/255, 160/255>;
#declare CN_Mulberry_Mauve_Black = rgb <70/255, 63/255, 96/255>;
#declare CN_Mulberry_Mix = rgb <159/255, 85/255, 108/255>;
#declare CN_Mulberry_Purple = rgb <73/255, 60/255, 98/255>;
#declare CN_Mulberry_Silk = rgb <148/255, 118/255, 108/255>;
#declare CN_Mulberry_Stain = rgb <198/255, 186/255, 190/255>;
#declare CN_Mulberry_Thorn = rgb <197/255, 127/255, 46/255>;
#declare CN_Mulberry_Wine = rgb <153/255, 124/255, 133/255>;
#declare CN_Mulberry_Wood = rgb <92/255, 5/255, 54/255>;
#declare CN_Mulberry_Yogurt = rgb <197/255, 75/255, 140/255>;
#declare CN_Mulch = rgb <67/255, 57/255, 55/255>;
#declare CN_Mule = rgb <130/255, 123/255, 119/255>;
#declare CN_Mule_Fawn = rgb <136/255, 79/255, 64/255>;
#declare CN_Mulgore_Mustard = rgb <194/255, 179/255, 50/255>;
#declare CN_Mulled_Cider = rgb <161/255, 129/255, 98/255>;
#declare CN_Mulled_Grape = rgb <103/255, 90/255, 116/255>;
#declare CN_Mulled_Wine = rgb <82/255, 77/255, 91/255>;
#declare CN_Mulled_Wine_Red = rgb <59/255, 41/255, 50/255>;
#declare CN_Mullen_Pink = rgb <202/255, 64/255, 66/255>;
#declare CN_Mulling_Spice = rgb <193/255, 134/255, 84/255>;
#declare CN_Multnomah_Falls = rgb <204/255, 208/255, 221/255>;
#declare CN_Mulu_Frog = rgb <85/255, 187/255, 0/255>;
#declare CN_Mummys_Tomb = rgb <130/255, 142/255, 132/255>;
#declare CN_Munch_On_Melon = rgb <242/255, 62/255, 103/255>;
#declare CN_Munchkin = rgb <155/255, 177/255, 57/255>;
#declare CN_Munsell_Blue = rgb <0/255, 147/255, 175/255>;
#declare CN_Munsell_Yellow = rgb <239/255, 204/255, 0/255>;
#declare CN_Muntok_White_Pepper = rgb <210/255, 161/255, 114/255>;
#declare CN_Murano_Soft_Blue = rgb <197/255, 214/255, 238/255>;
#declare CN_Murasaki = rgb <79/255, 40/255, 75/255>;
#declare CN_Murasaki_Purple = rgb <136/255, 72/255, 152/255>;
#declare CN_Murdoch = rgb <91/255, 141/255, 107/255>;
#declare CN_Murex = rgb <132/255, 126/255, 177/255>;
#declare CN_Murky_Green = rgb <108/255, 122/255, 14/255>;
#declare CN_Murmur = rgb <210/255, 216/255, 210/255>;
#declare CN_Murray_Red = rgb <107/255, 60/255, 57/255>;
#declare CN_Muscat_Blanc = rgb <235/255, 226/255, 207/255>;
#declare CN_Muscat_Grape = rgb <94/255, 80/255, 103/255>;
#declare CN_Muscatel = rgb <123/255, 106/255, 104/255>;
#declare CN_Muscovado_Sugar = rgb <155/255, 105/255, 87/255>;
#declare CN_Muse = rgb <165/255, 133/255, 127/255>;
#declare CN_Museum = rgb <104/255, 89/255, 81/255>;
#declare CN_Mushiao_Green = rgb <45/255, 68/255, 54/255>;
#declare CN_Mushroom = rgb <189/255, 172/255, 163/255>;
#declare CN_Mushroom_Basket = rgb <151/255, 122/255, 118/255>;
#declare CN_Mushroom_Bisque = rgb <202/255, 180/255, 155/255>;
#declare CN_Mushroom_Brown = rgb <144/255, 110/255, 88/255>;
#declare CN_Mushroom_Risotto = rgb <219/255, 208/255, 202/255>;
#declare CN_Mushroom_White = rgb <240/255, 225/255, 205/255>;
#declare CN_Musical_Mist = rgb <248/255, 234/255, 230/255>;
#declare CN_Musk = rgb <204/255, 161/255, 149/255>;
#declare CN_Musk_Deer = rgb <126/255, 91/255, 88/255>;
#declare CN_Musk_Dusk = rgb <207/255, 191/255, 185/255>;
#declare CN_Musk_Memory = rgb <119/255, 69/255, 72/255>;
#declare CN_Musket = rgb <125/255, 109/255, 57/255>;
#declare CN_Muskmelon = rgb <236/255, 147/255, 94/255>;
#declare CN_Muskrat = rgb <126/255, 111/255, 79/255>;
#declare CN_Muslin = rgb <211/255, 209/255, 196/255>;
#declare CN_Muslin_Tint = rgb <224/255, 205/255, 177/255>;
#declare CN_Mussel_Green = rgb <36/255, 52/255, 42/255>;
#declare CN_Mussel_White = rgb <240/255, 226/255, 222/255>;
#declare CN_Mustang = rgb <94/255, 74/255, 71/255>;
#declare CN_Mustard = rgb <206/255, 179/255, 1/255>;
#declare CN_Mustard_Brown = rgb <172/255, 126/255, 4/255>;
#declare CN_Mustard_Crusted_Salmon = rgb <239/255, 129/255, 68/255>;
#declare CN_Mustard_Field = rgb <216/255, 176/255, 118/255>;
#declare CN_Mustard_Flower = rgb <210/255, 189/255, 10/255>;
#declare CN_Mustard_Gold = rgb <176/255, 142/255, 81/255>;
#declare CN_Mustard_Green = rgb <168/255, 181/255, 4/255>;
#declare CN_Mustard_Magic = rgb <133/255, 113/255, 57/255>;
#declare CN_Mustard_Musketeers = rgb <213/255, 161/255, 41/255>;
#declare CN_Mustard_Oil = rgb <213/255, 189/255, 102/255>;
#declare CN_Mustard_On_Toast = rgb <221/255, 204/255, 51/255>;
#declare CN_Mustard_Sauce = rgb <237/255, 189/255, 104/255>;
#declare CN_Mustard_Seed = rgb <198/255, 159/255, 38/255>;
#declare CN_Mustard_Seed_Beige = rgb <197/255, 165/255, 116/255>;
#declare CN_Mustard_Yellow = rgb <225/255, 173/255, 1/255>;
#declare CN_Mutabilis = rgb <194/255, 149/255, 148/255>;
#declare CN_Muted_Berry = rgb <145/255, 120/255, 140/255>;
#declare CN_Muted_Blue = rgb <59/255, 113/255, 159/255>;
#declare CN_Muted_Clay = rgb <210/255, 147/255, 128/255>;
#declare CN_Muted_Green = rgb <95/255, 160/255, 82/255>;
#declare CN_Muted_Lime = rgb <209/255, 200/255, 124/255>;
#declare CN_Muted_Mauve = rgb <179/255, 169/255, 163/255>;
#declare CN_Muted_Mulberry = rgb <102/255, 98/255, 109/255>;
#declare CN_Muted_Pink = rgb <209/255, 118/255, 143/255>;
#declare CN_Muted_Purple = rgb <128/255, 91/255, 135/255>;
#declare CN_Muted_Sage = rgb <147/255, 144/255, 126/255>;
#declare CN_MVS_Red = rgb <238/255, 0/255, 0/255>;
#declare CN_My_Fair_Lady = rgb <243/255, 196/255, 194/255>;
#declare CN_My_Love = rgb <225/255, 198/255, 168/255>;
#declare CN_My_Pink = rgb <214/255, 139/255, 128/255>;
#declare CN_My_Place_or_Yours_ = rgb <79/255, 67/255, 78/255>;
#declare CN_My_Sin = rgb <253/255, 174/255, 69/255>;
#declare CN_My_Sweetheart = rgb <248/255, 231/255, 223/255>;
#declare CN_Mykonos = rgb <56/255, 122/255, 190/255>;
#declare CN_Mykonos_Blue = rgb <0/255, 87/255, 128/255>;
#declare CN_Myoga_Purple = rgb <224/255, 33/255, 138/255>;
#declare CN_Myrtle = rgb <33/255, 66/255, 30/255>;
#declare CN_Myrtle_Deep_Green = rgb <0/255, 82/255, 76/255>;
#declare CN_Myrtle_Green = rgb <49/255, 120/255, 115/255>;
#declare CN_Myrtle_Pepper = rgb <183/255, 121/255, 97/255>;
#declare CN_Myself = rgb <142/255, 111/255, 118/255>;
#declare CN_Mystere = rgb <152/255, 129/255, 124/255>;
#declare CN_Mysteria = rgb <130/255, 111/255, 122/255>;
#declare CN_Mysterioso = rgb <70/255, 57/255, 75/255>;
#declare CN_Mysterious = rgb <83/255, 94/255, 99/255>;
#declare CN_Mysterious_Blue = rgb <62/255, 122/255, 133/255>;
#declare CN_Mysterious_Mauve = rgb <166/255, 163/255, 169/255>;
#declare CN_Mysterious_Moss = rgb <111/255, 106/255, 82/255>;
#declare CN_Mysterious_Night = rgb <92/255, 96/255, 112/255>;
#declare CN_Mystery = rgb <164/255, 205/255, 204/255>;
#declare CN_Mystic = rgb <216/255, 221/255, 218/255>;
#declare CN_Mystic_Blue = rgb <72/255, 168/255, 208/255>;
#declare CN_Mystic_Fog = rgb <234/255, 233/255, 225/255>;
#declare CN_Mystic_Green = rgb <216/255, 248/255, 120/255>;
#declare CN_Mystic_Harbor = rgb <210/255, 228/255, 238/255>;
#declare CN_Mystic_Iris = rgb <133/255, 150/255, 210/255>;
#declare CN_Mystic_Light = rgb <221/255, 229/255, 236/255>;
#declare CN_Mystic_Magenta = rgb <224/255, 46/255, 130/255>;
#declare CN_Mystic_Maroon = rgb <173/255, 67/255, 121/255>;
#declare CN_Mystic_Mauve = rgb <219/255, 183/255, 186/255>;
#declare CN_Mystic_Melon = rgb <237/255, 235/255, 180/255>;
#declare CN_Mystic_Opal = rgb <251/255, 221/255, 190/255>;
#declare CN_Mystic_Pool = rgb <213/255, 221/255, 226/255>;
#declare CN_Mystic_Red = rgb <255/255, 85/255, 0/255>;
#declare CN_Mystic_River = rgb <183/255, 202/255, 224/255>;
#declare CN_Mystic_Tulip = rgb <249/255, 179/255, 163/255>;
#declare CN_Mystic_Turquoise = rgb <0/255, 135/255, 123/255>;
#declare CN_Mystical = rgb <95/255, 78/255, 114/255>;
#declare CN_Mystical_Mist = rgb <229/255, 226/255, 227/255>;
#declare CN_Mystical_Purple = rgb <116/255, 93/255, 131/255>;
#declare CN_Mystical_Sea = rgb <220/255, 227/255, 209/255>;
#declare CN_Mystical_Shade = rgb <76/255, 83/255, 100/255>;
#declare CN_Mystical_Trip = rgb <122/255, 106/255, 117/255>;
#declare CN_Mystification = rgb <42/255, 64/255, 113/255>;
#declare CN_Mystified = rgb <201/255, 219/255, 199/255>;
#declare CN_Mystique = rgb <165/255, 152/255, 160/255>;
#declare CN_Myth = rgb <101/255, 113/255, 117/255>;
#declare CN_Mythic_Forest = rgb <74/255, 104/255, 108/255>;
#declare CN_Mythical = rgb <126/255, 119/255, 142/255>;
#declare CN_Mythical_Blue = rgb <147/255, 168/255, 167/255>;
#declare CN_Mythical_Forest = rgb <57/255, 132/255, 103/255>;
#declare CN_Mythical_Orange = rgb <255/255, 127/255, 73/255>;
#declare CN_Nacre = rgb <232/255, 226/255, 212/255>;
#declare CN_Nadeshiko_Pink = rgb <246/255, 173/255, 198/255>;
#declare CN_Nadia = rgb <175/255, 201/255, 192/255>;
#declare CN_Naga_Morich = rgb <201/255, 4/255, 6/255>;
#declare CN_Naga_Viper_Pepper = rgb <237/255, 41/255, 43/255>;
#declare CN_Naggaroth_Night = rgb <61/255, 51/255, 84/255>;
#declare CN_Nai_You_Se_Cream = rgb <253/255, 237/255, 195/255>;
#declare CN_Nail_Polish_Pink = rgb <189/255, 78/255, 132/255>;
#declare CN_Nairobi_Dusk = rgb <217/255, 167/255, 135/255>;
#declare CN_Naive_Peach = rgb <252/255, 231/255, 211/255>;
#declare CN_Nakabeni_Pink = rgb <201/255, 55/255, 86/255>;
#declare CN_Naked_Lady = rgb <214/255, 179/255, 169/255>;
#declare CN_Naked_Light = rgb <233/255, 182/255, 193/255>;
#declare CN_Naked_Pink = rgb <216/255, 198/255, 214/255>;
#declare CN_Naked_Rose = rgb <235/255, 181/255, 179/255>;
#declare CN_Namakabe_Brown = rgb <120/255, 94/255, 73/255>;
#declare CN_Namara_Grey = rgb <123/255, 124/255, 125/255>;
#declare CN_Namaste = rgb <189/255, 216/255, 192/255>;
#declare CN_Namibia = rgb <124/255, 109/255, 97/255>;
#declare CN_Nana = rgb <160/255, 141/255, 167/255>;
#declare CN_Nancy = rgb <87/255, 184/255, 220/255>;
#declare CN_Nandi_Bear = rgb <143/255, 66/255, 61/255>;
#declare CN_Nandor = rgb <78/255, 93/255, 78/255>;
#declare CN_Nankeen = rgb <184/255, 158/255, 130/255>;
#declare CN_Nano_White = rgb <242/255, 240/255, 234/255>;
#declare CN_Nanohanacha_Gold = rgb <227/255, 177/255, 48/255>;
#declare CN_Nantucket_Dune = rgb <208/255, 191/255, 170/255>;
#declare CN_Nantucket_Mist = rgb <202/255, 191/255, 191/255>;
#declare CN_Nantucket_Sands = rgb <180/255, 168/255, 154/255>;
#declare CN_Napa = rgb <163/255, 154/255, 135/255>;
#declare CN_Napa_Grape = rgb <91/255, 81/255, 98/255>;
#declare CN_Napa_Harvest = rgb <83/255, 72/255, 83/255>;
#declare CN_Napa_Sunset = rgb <205/255, 145/255, 92/255>;
#declare CN_Napa_Wine = rgb <93/255, 65/255, 73/255>;
#declare CN_Napa_Winery = rgb <106/255, 92/255, 125/255>;
#declare CN_Napery = rgb <239/255, 221/255, 193/255>;
#declare CN_Napier_Green = rgb <42/255, 128/255, 0/255>;
#declare CN_Naples_Yellow = rgb <250/255, 218/255, 95/255>;
#declare CN_Napoleon = rgb <64/255, 65/255, 73/255>;
#declare CN_Narangi_Orange = rgb <255/255, 128/255, 80/255>;
#declare CN_Narcissus = rgb <195/255, 148/255, 73/255>;
#declare CN_Narcomedusae = rgb <230/255, 227/255, 216/255>;
#declare CN_Narenji_Orange = rgb <255/255, 193/255, 75/255>;
#declare CN_Narvik = rgb <233/255, 230/255, 220/255>;
#declare CN_Narwhal_Grey = rgb <8/255, 8/255, 19/255>;
#declare CN_Nasake = rgb <116/255, 96/255, 98/255>;
#declare CN_Nashi_Pear_Beige = rgb <237/255, 212/255, 177/255>;
#declare CN_Nasturtium = rgb <254/255, 99/255, 71/255>;
#declare CN_Nasturtium_Flower = rgb <230/255, 77/255, 29/255>;
#declare CN_Nasturtium_Leaf = rgb <135/255, 179/255, 105/255>;
#declare CN_Nasturtium_Shoot = rgb <134/255, 159/255, 73/255>;
#declare CN_Nasty_Green = rgb <112/255, 178/255, 63/255>;
#declare CN_Nasu_Purple = rgb <93/255, 33/255, 208/255>;
#declare CN_Nataneyu_Gold = rgb <161/255, 121/255, 23/255>;
#declare CN_Natchez = rgb <186/255, 159/255, 149/255>;
#declare CN_Natchez_Moss = rgb <177/255, 167/255, 111/255>;
#declare CN_National_Anthem = rgb <63/255, 111/255, 152/255>;
#declare CN_Native_Berry = rgb <220/255, 107/255, 103/255>;
#declare CN_Native_Flora = rgb <154/255, 160/255, 153/255>;
#declare CN_Native_Hue_of_Resolution = rgb <211/255, 51/255, 0/255>;
#declare CN_Native_Soil = rgb <136/255, 123/255, 105/255>;
#declare CN_Nato_Blue = rgb <21/255, 48/255, 67/255>;
#declare CN_NATO_Olive = rgb <85/255, 85/255, 72/255>;
#declare CN_Natrolite = rgb <235/255, 188/255, 113/255>;
#declare CN_Natural = rgb <170/255, 144/255, 125/255>;
#declare CN_Natural_Almond = rgb <222/255, 210/255, 187/255>;
#declare CN_Natural_Bark = rgb <109/255, 87/255, 77/255>;
#declare CN_Natural_Bridge = rgb <162/255, 145/255, 113/255>;
#declare CN_Natural_Candy_Pink = rgb <228/255, 113/255, 122/255>;
#declare CN_Natural_Chamois = rgb <187/255, 168/255, 139/255>;
#declare CN_Natural_Choice = rgb <227/255, 222/255, 208/255>;
#declare CN_Natural_Copper = rgb <139/255, 101/255, 90/255>;
#declare CN_Natural_Green = rgb <188/255, 205/255, 145/255>;
#declare CN_Natural_Grey = rgb <196/255, 192/255, 187/255>;
#declare CN_Natural_Indigo = rgb <0/255, 55/255, 64/255>;
#declare CN_Natural_Instinct_Green = rgb <1/255, 115/255, 116/255>;
#declare CN_Natural_Leather = rgb <168/255, 14/255, 0/255>;
#declare CN_Natural_Light = rgb <241/255, 235/255, 200/255>;
#declare CN_Natural_Linen = rgb <236/255, 223/255, 207/255>;
#declare CN_Natural_Pumice = rgb <74/255, 74/255, 67/255>;
#declare CN_Natural_Radiance = rgb <231/255, 220/255, 193/255>;
#declare CN_Natural_Rice_Beige = rgb <220/255, 195/255, 159/255>;
#declare CN_Natural_Silk_Grey = rgb <211/255, 197/255, 192/255>;
#declare CN_Natural_Spring = rgb <170/255, 131/255, 139/255>;
#declare CN_Natural_Steel = rgb <138/255, 130/255, 135/255>;
#declare CN_Natural_Stone = rgb <174/255, 162/255, 149/255>;
#declare CN_Natural_Tan = rgb <220/255, 210/255, 195/255>;
#declare CN_Natural_Twine = rgb <219/255, 195/255, 155/255>;
#declare CN_Natural_Whisper = rgb <240/255, 232/255, 207/255>;
#declare CN_Natural_White = rgb <251/255, 237/255, 226/255>;
#declare CN_Natural_Wool = rgb <255/255, 246/255, 215/255>;
#declare CN_Natural_Yellow = rgb <238/255, 216/255, 139/255>;
#declare CN_Natural_Youth = rgb <215/255, 229/255, 180/255>;
#declare CN_Naturale = rgb <241/255, 224/255, 207/255>;
#declare CN_Naturalism = rgb <104/255, 104/255, 93/255>;
#declare CN_Naturalist_Grey = rgb <139/255, 140/255, 131/255>;
#declare CN_Naturally_Calm = rgb <206/255, 208/255, 217/255>;
#declare CN_Nature = rgb <191/255, 213/255, 179/255>;
#declare CN_Nature_Apricot = rgb <254/255, 183/255, 165/255>;
#declare CN_Nature_Green = rgb <125/255, 175/255, 148/255>;
#declare CN_Nature_Retreat = rgb <123/255, 135/255, 135/255>;
#declare CN_Nature_Spirits = rgb <200/255, 200/255, 180/255>;
#declare CN_Nature_Surrounds = rgb <82/255, 99/255, 75/255>;
#declare CN_Nature_Trail = rgb <230/255, 215/255, 187/255>;
#declare CN_Natures_Delight = rgb <166/255, 210/255, 146/255>;
#declare CN_Natures_Gate = rgb <102/255, 106/255, 96/255>;
#declare CN_Natures_Gift = rgb <153/255, 163/255, 153/255>;
#declare CN_Natures_Reflection = rgb <197/255, 212/255, 205/255>;
#declare CN_Natures_Strength = rgb <17/255, 119/255, 51/255>;
#declare CN_Naturel = rgb <203/255, 192/255, 173/255>;
#declare CN_Naughty_Hottie = rgb <186/255, 64/255, 58/255>;
#declare CN_Naughty_Marietta = rgb <227/255, 204/255, 220/255>;
#declare CN_Nauseous_Blue = rgb <72/255, 61/255, 139/255>;
#declare CN_Nautical = rgb <46/255, 74/255, 125/255>;
#declare CN_Nautical_Blue = rgb <26/255, 80/255, 145/255>;
#declare CN_Nautical_Star = rgb <170/255, 181/255, 183/255>;
#declare CN_Nautilus = rgb <39/255, 60/255, 90/255>;
#declare CN_Navagio_Bay = rgb <49/255, 131/255, 160/255>;
#declare CN_Navajo = rgb <239/255, 220/255, 195/255>;
#declare CN_Navajo_Turquoise = rgb <0/255, 124/255, 120/255>;
#declare CN_Navajo_White = rgb <255/255, 222/255, 173/255>;
#declare CN_Naval = rgb <65/255, 114/255, 159/255>;
#declare CN_Naval_Passage = rgb <56/255, 103/255, 130/255>;
#declare CN_Navel = rgb <236/255, 132/255, 48/255>;
#declare CN_Navigate = rgb <0/255, 133/255, 131/255>;
#declare CN_Navigator = rgb <93/255, 131/255, 171/255>;
#declare CN_Navy = rgb <1/255, 21/255, 62/255>;
#declare CN_Navy_Black = rgb <38/255, 48/255, 50/255>;
#declare CN_Navy_Blazer = rgb <40/255, 45/255, 60/255>;
#declare CN_Navy_Blue = rgb <0/255, 0/255, 128/255>;
#declare CN_Navy_Cosmos = rgb <80/255, 59/255, 83/255>;
#declare CN_Navy_Damask = rgb <66/255, 81/255, 102/255>;
#declare CN_Navy_Dark_Blue = rgb <0/255, 76/255, 106/255>;
#declare CN_Navy_Green = rgb <53/255, 83/255, 10/255>;
#declare CN_Navy_Peony = rgb <34/255, 58/255, 94/255>;
#declare CN_Navy_Purple = rgb <149/255, 86/255, 235/255>;
#declare CN_Navy_Teal = rgb <32/255, 87/255, 110/255>;
#declare CN_Navy_Trim = rgb <32/255, 52/255, 98/255>;
#declare CN_Neapolitan = rgb <155/255, 122/255, 120/255>;
#declare CN_Neapolitan_Blue = rgb <77/255, 127/255, 170/255>;
#declare CN_Near_Moon = rgb <94/255, 231/255, 223/255>;
#declare CN_Nearly_Brown = rgb <168/255, 142/255, 118/255>;
#declare CN_Nearly_Peach = rgb <239/255, 222/255, 209/255>;
#declare CN_Nearsighted = rgb <200/255, 213/255, 221/255>;
#declare CN_Nebula = rgb <161/255, 4/255, 195/255>;
#declare CN_Nebula_Outpost = rgb <146/255, 43/255, 156/255>;
#declare CN_Nebulas_Blue = rgb <45/255, 98/255, 163/255>;
#declare CN_Nebulous = rgb <196/255, 185/255, 184/255>;
#declare CN_Nebulous_White = rgb <222/255, 223/255, 220/255>;
#declare CN_Necklace_Pearl = rgb <246/255, 238/255, 237/255>;
#declare CN_Necron_Compound = rgb <130/255, 139/255, 142/255>;
#declare CN_Necrotic_Flesh = rgb <159/255, 175/255, 108/255>;
#declare CN_Nectar_of_the_Gods = rgb <81/255, 52/255, 57/255>;
#declare CN_Nectar_Red = rgb <127/255, 76/255, 100/255>;
#declare CN_Nectarina = rgb <211/255, 141/255, 114/255>;
#declare CN_Nectarine = rgb <255/255, 134/255, 86/255>;
#declare CN_Nectarous_Nectarine = rgb <221/255, 85/255, 102/255>;
#declare CN_Needlepoint_Navy = rgb <84/255, 102/255, 112/255>;
#declare CN_Nefarious_Blue = rgb <197/255, 206/255, 216/255>;
#declare CN_Nefarious_Mauve = rgb <230/255, 209/255, 220/255>;
#declare CN_Negishi_Green = rgb <147/255, 139/255, 75/255>;
#declare CN_Negroni = rgb <238/255, 199/255, 162/255>;
#declare CN_Neighborly_Peach = rgb <243/255, 193/255, 163/255>;
#declare CN_Nelsons_Milk_Snake = rgb <147/255, 61/255, 65/255>;
#declare CN_Neo_Mint = rgb <170/255, 255/255, 204/255>;
#declare CN_Neo_Tokyo_Grey = rgb <190/255, 192/255, 194/255>;
#declare CN_Neon_Blue = rgb <4/255, 217/255, 255/255>;
#declare CN_Neon_Boneyard = rgb <223/255, 197/255, 254/255>;
#declare CN_Neon_Carrot = rgb <255/255, 153/255, 51/255>;
#declare CN_Neon_Fuchsia = rgb <254/255, 65/255, 100/255>;
#declare CN_Neon_Green = rgb <57/255, 255/255, 20/255>;
#declare CN_Neon_Light = rgb <255/255, 223/255, 94/255>;
#declare CN_Neon_Pink = rgb <254/255, 1/255, 154/255>;
#declare CN_Neon_Purple = rgb <188/255, 19/255, 254/255>;
#declare CN_Neon_Red = rgb <255/255, 7/255, 58/255>;
#declare CN_Neon_Violet = rgb <103/255, 72/255, 118/255>;
#declare CN_Neon_Yellow = rgb <207/255, 255/255, 4/255>;
#declare CN_Nepal = rgb <147/255, 170/255, 185/255>;
#declare CN_Nephrite = rgb <109/255, 146/255, 136/255>;
#declare CN_Neptune = rgb <0/255, 125/255, 172/255>;
#declare CN_Neptune_Blue = rgb <46/255, 93/255, 157/255>;
#declare CN_Neptune_Green = rgb <127/255, 187/255, 158/255>;
#declare CN_Neptunes_Wrath = rgb <17/255, 66/255, 93/255>;
#declare CN_Nereus = rgb <76/255, 121/255, 60/255>;
#declare CN_Nero = rgb <37/255, 37/255, 37/255>;
#declare CN_Neros_Green = rgb <49/255, 129/255, 129/255>;
#declare CN_Nervous_Neon_Pink = rgb <255/255, 110/255, 199/255>;
#declare CN_Nervy_Hue = rgb <215/255, 198/255, 91/255>;
#declare CN_Nessie = rgb <113/255, 103/255, 72/255>;
#declare CN_Nesting_Dove = rgb <238/255, 234/255, 218/255>;
#declare CN_Net_Worker = rgb <182/255, 161/255, 148/255>;
#declare CN_Netherworld = rgb <136/255, 17/255, 17/255>;
#declare CN_Netsuke = rgb <224/255, 207/255, 176/255>;
#declare CN_Nettle = rgb <187/255, 172/255, 125/255>;
#declare CN_Nettle_Green = rgb <54/255, 76/255, 46/255>;
#declare CN_Nettle_Rash = rgb <228/255, 247/255, 231/255>;
#declare CN_Network_Gray = rgb <160/255, 165/255, 167/255>;
#declare CN_Neutral_Buff = rgb <157/255, 146/255, 143/255>;
#declare CN_Neutral_Green = rgb <170/255, 165/255, 131/255>;
#declare CN_Neutral_Grey = rgb <142/255, 145/255, 143/255>;
#declare CN_Neutral_Ground = rgb <226/255, 218/255, 202/255>;
#declare CN_Neutral_Peach = rgb <255/255, 230/255, 195/255>;
#declare CN_Neutral_Valley = rgb <139/255, 105/255, 77/255>;
#declare CN_Neutrino_Blue = rgb <1/255, 36/255, 143/255>;
#declare CN_Nevada = rgb <102/255, 111/255, 111/255>;
#declare CN_Nevada_Morning = rgb <255/255, 213/255, 167/255>;
#declare CN_Nevada_Sand = rgb <234/255, 213/255, 185/255>;
#declare CN_Nevada_Sky = rgb <161/255, 217/255, 231/255>;
#declare CN_Never_Cry_Wolf = rgb <110/255, 100/255, 85/255>;
#declare CN_Never_Forget = rgb <166/255, 114/255, 131/255>;
#declare CN_Nevergreen = rgb <102/255, 101/255, 86/255>;
#declare CN_Neverland = rgb <156/255, 229/255, 214/255>;
#declare CN_Nevermind_Nirvana = rgb <123/255, 200/255, 246/255>;
#declare CN_New_Age_Blue = rgb <73/255, 110/255, 173/255>;
#declare CN_New_Amber = rgb <109/255, 59/255, 36/255>;
#declare CN_New_Bamboo = rgb <173/255, 172/255, 132/255>;
#declare CN_New_Brick = rgb <147/255, 76/255, 61/255>;
#declare CN_New_Brick_Red = rgb <203/255, 65/255, 84/255>;
#declare CN_New_Bulgarian_Rose = rgb <72/255, 36/255, 39/255>;
#declare CN_New_Car = rgb <33/255, 79/255, 198/255>;
#declare CN_New_Chestnut = rgb <162/255, 131/255, 103/255>;
#declare CN_New_Clay = rgb <239/255, 193/255, 181/255>;
#declare CN_New_Colonial_Yellow = rgb <217/255, 173/255, 127/255>;
#declare CN_New_Cork = rgb <184/255, 155/255, 107/255>;
#declare CN_New_Cream = rgb <237/255, 224/255, 192/255>;
#declare CN_New_England_Brick = rgb <173/255, 112/255, 101/255>;
#declare CN_New_England_Roast = rgb <170/255, 119/255, 85/255>;
#declare CN_New_Fawn = rgb <201/255, 161/255, 113/255>;
#declare CN_New_Foliage = rgb <194/255, 188/255, 144/255>;
#declare CN_New_Forest = rgb <71/255, 81/255, 77/255>;
#declare CN_New_Frond = rgb <186/255, 204/255, 160/255>;
#declare CN_New_Gold = rgb <234/255, 209/255, 81/255>;
#declare CN_New_Green = rgb <181/255, 172/255, 49/255>;
#declare CN_New_Harvest_Moon = rgb <237/255, 223/255, 199/255>;
#declare CN_New_Hope = rgb <226/255, 239/255, 194/255>;
#declare CN_New_House_White = rgb <241/255, 237/255, 231/255>;
#declare CN_New_Hunter = rgb <74/255, 95/255, 88/255>;
#declare CN_New_Kenyan_Copper = rgb <124/255, 28/255, 5/255>;
#declare CN_New_Khaki = rgb <217/255, 199/255, 170/255>;
#declare CN_New_Life = rgb <124/255, 145/255, 110/255>;
#declare CN_New_Limerick = rgb <157/255, 194/255, 9/255>;
#declare CN_New_Love = rgb <198/255, 187/255, 219/255>;
#declare CN_New_Moss = rgb <198/255, 214/255, 199/255>;
#declare CN_New_Navy_Blue = rgb <59/255, 74/255, 85/255>;
#declare CN_New_Neutral = rgb <190/255, 192/255, 170/255>;
#declare CN_New_Orleans = rgb <228/255, 195/255, 133/255>;
#declare CN_New_Penny = rgb <162/255, 125/255, 102/255>;
#declare CN_New_Roof = rgb <135/255, 82/255, 81/255>;
#declare CN_New_Shoot = rgb <134/255, 158/255, 62/255>;
#declare CN_New_Sled = rgb <147/255, 60/255, 60/255>;
#declare CN_New_Steel = rgb <115/255, 133/255, 149/255>;
#declare CN_New_Violet = rgb <214/255, 193/255, 221/255>;
#declare CN_New_Wave_Green = rgb <17/255, 255/255, 17/255>;
#declare CN_New_Wave_Pink = rgb <255/255, 34/255, 255/255>;
#declare CN_New_Wheat = rgb <215/255, 181/255, 127/255>;
#declare CN_New_Wool = rgb <214/255, 195/255, 185/255>;
#declare CN_New_Yellow = rgb <232/255, 194/255, 71/255>;
#declare CN_New_York_Pink = rgb <221/255, 131/255, 116/255>;
#declare CN_New_Youth = rgb <240/255, 225/255, 223/255>;
#declare CN_Newbury_Moss = rgb <97/255, 101/255, 80/255>;
#declare CN_Newburyport = rgb <68/255, 90/255, 121/255>;
#declare CN_Newmans_Eye = rgb <178/255, 199/255, 225/255>;
#declare CN_Newmarket_Sausage = rgb <234/255, 226/255, 220/255>;
#declare CN_Newport_Blue = rgb <28/255, 138/255, 201/255>;
#declare CN_Newport_Indigo = rgb <49/255, 61/255, 108/255>;
#declare CN_Newsprint = rgb <117/255, 111/255, 109/255>;
#declare CN_Niagara = rgb <41/255, 169/255, 139/255>;
#declare CN_Niagara_Falls = rgb <203/255, 227/255, 238/255>;
#declare CN_Niagara_Mist = rgb <197/255, 232/255, 238/255>;
#declare CN_Niblet_Green = rgb <125/255, 199/255, 52/255>;
#declare CN_Nice_Blue = rgb <16/255, 122/255, 176/255>;
#declare CN_Nice_Cream = rgb <250/255, 236/255, 209/255>;
#declare CN_Nice_White = rgb <230/255, 221/255, 213/255>;
#declare CN_Niche = rgb <101/255, 117/255, 143/255>;
#declare CN_Nicks_Nook = rgb <144/255, 144/255, 98/255>;
#declare CN_Nickel = rgb <146/255, 146/255, 146/255>;
#declare CN_Nickel_Ore_Green = rgb <83/255, 126/255, 126/255>;
#declare CN_Nicotine_Gold = rgb <238/255, 187/255, 51/255>;
#declare CN_Niebla_Azul = rgb <182/255, 195/255, 196/255>;
#declare CN_Nifty_Turquoise = rgb <1/255, 145/255, 135/255>;
#declare CN_Night_Black = rgb <49/255, 47/255, 54/255>;
#declare CN_Night_Bloom = rgb <97/255, 62/255, 61/255>;
#declare CN_Night_Blooming_Jasmine = rgb <249/255, 247/255, 236/255>;
#declare CN_Night_Blue = rgb <4/255, 3/255, 72/255>;
#declare CN_Night_Brown = rgb <68/255, 40/255, 27/255>;
#declare CN_Night_Brown_Black = rgb <50/255, 45/255, 37/255>;
#declare CN_Night_Club = rgb <73/255, 75/255, 78/255>;
#declare CN_Night_Dive = rgb <0/255, 51/255, 85/255>;
#declare CN_Night_Flight = rgb <67/255, 77/255, 92/255>;
#declare CN_Night_Fog = rgb <45/255, 25/255, 98/255>;
#declare CN_Night_Green = rgb <48/255, 47/255, 39/255>;
#declare CN_Night_Grey = rgb <69/255, 68/255, 77/255>;
#declare CN_Night_Gull_Grey = rgb <97/255, 93/255, 92/255>;
#declare CN_Night_in_the_Woods = rgb <68/255, 51/255, 0/255>;
#declare CN_Night_Kite = rgb <0/255, 85/255, 114/255>;
#declare CN_Night_Market = rgb <76/255, 97/255, 119/255>;
#declare CN_Night_Mauve = rgb <93/255, 59/255, 65/255>;
#declare CN_Night_Mission = rgb <94/255, 92/255, 80/255>;
#declare CN_Night_Mode = rgb <35/255, 78/255, 134/255>;
#declare CN_Night_Music = rgb <156/255, 150/255, 175/255>;
#declare CN_Night_Night = rgb <79/255, 79/255, 94/255>;
#declare CN_Night_Out = rgb <101/255, 106/255, 110/255>;
#declare CN_Night_Owl = rgb <93/255, 123/255, 137/255>;
#declare CN_Night_Pearl = rgb <17/255, 255/255, 187/255>;
#declare CN_Night_Red = rgb <60/255, 39/255, 39/255>;
#declare CN_Night_Rendezvous = rgb <102/255, 120/255, 126/255>;
#declare CN_Night_Rider = rgb <51/255, 46/255, 46/255>;
#declare CN_Night_Romance = rgb <113/255, 80/255, 85/255>;
#declare CN_Night_Rose = rgb <176/255, 128/255, 122/255>;
#declare CN_Night_Shadz = rgb <162/255, 61/255, 84/255>;
#declare CN_Night_Shift = rgb <42/255, 92/255, 106/255>;
#declare CN_Night_Sky = rgb <42/255, 42/255, 53/255>;
#declare CN_Night_Snow = rgb <170/255, 204/255, 255/255>;
#declare CN_Night_Tan = rgb <171/255, 150/255, 123/255>;
#declare CN_Night_Thistle = rgb <107/255, 123/255, 167/255>;
#declare CN_Night_Tide = rgb <69/255, 83/255, 96/255>;
#declare CN_Night_Turquoise = rgb <0/255, 56/255, 51/255>;
#declare CN_Night_Watch = rgb <60/255, 79/255, 78/255>;
#declare CN_Night_White = rgb <225/255, 225/255, 221/255>;
#declare CN_Night_Wind = rgb <215/255, 226/255, 219/255>;
#declare CN_Night_Wizard = rgb <49/255, 55/255, 64/255>;
#declare CN_Nightfall = rgb <67/255, 83/255, 94/255>;
#declare CN_Nightfall_in_Suburbia = rgb <0/255, 17/255, 221/255>;
#declare CN_Nighthawk = rgb <97/255, 84/255, 82/255>;
#declare CN_Nightingale = rgb <92/255, 72/255, 39/255>;
#declare CN_Nightingale_Grey = rgb <186/255, 174/255, 163/255>;
#declare CN_Nightlife = rgb <39/255, 66/255, 107/255>;
#declare CN_Nightly_Aurora = rgb <155/255, 238/255, 193/255>;
#declare CN_Nightly_Blade = rgb <90/255, 125/255, 154/255>;
#declare CN_Nightly_Escapade = rgb <4/255, 51/255, 255/255>;
#declare CN_Nightly_Expedition = rgb <34/255, 17/255, 136/255>;
#declare CN_Nightly_Ivy = rgb <68/255, 73/255, 64/255>;
#declare CN_Nightly_Silhouette = rgb <79/255, 91/255, 147/255>;
#declare CN_Nightly_Violet = rgb <120/255, 67/255, 132/255>;
#declare CN_Nightly_Woods = rgb <1/255, 50/255, 32/255>;
#declare CN_Nightmare = rgb <17/255, 34/255, 17/255>;
#declare CN_Nightshade = rgb <60/255, 70/255, 75/255>;
#declare CN_Nightshade_Berries = rgb <27/255, 24/255, 17/255>;
#declare CN_Nightshade_Blue = rgb <41/255, 49/255, 53/255>;
#declare CN_Nightshade_Purple = rgb <83/255, 88/255, 114/255>;
#declare CN_Nightshade_Violet = rgb <163/255, 131/255, 172/255>;
#declare CN_Nightshadow_Blue = rgb <78/255, 83/255, 104/255>;
#declare CN_Nihilakh_Oxide = rgb <160/255, 214/255, 180/255>;
#declare CN_Nila_Blue = rgb <0/255, 85/255, 255/255>;
#declare CN_Nile = rgb <180/255, 187/255, 133/255>;
#declare CN_Nile_Blue = rgb <37/255, 63/255, 78/255>;
#declare CN_Nile_Clay = rgb <139/255, 129/255, 116/255>;
#declare CN_Nile_Green = rgb <167/255, 199/255, 150/255>;
#declare CN_Nile_Reed = rgb <150/255, 143/255, 95/255>;
#declare CN_Nile_River = rgb <154/255, 182/255, 169/255>;
#declare CN_Nile_Sand = rgb <187/255, 173/255, 148/255>;
#declare CN_Nile_Stone = rgb <97/255, 201/255, 193/255>;
#declare CN_Nilla_Vanilla = rgb <241/255, 235/255, 224/255>;
#declare CN_Nimbus_Blue = rgb <68/255, 34/255, 255/255>;
#declare CN_Nimbus_Cloud = rgb <213/255, 213/255, 216/255>;
#declare CN_Nina = rgb <245/255, 227/255, 234/255>;
#declare CN_Nine_Iron = rgb <70/255, 67/255, 74/255>;
#declare CN_Ning_Meng_Huang_Lemon = rgb <255/255, 239/255, 25/255>;
#declare CN_Ninja = rgb <2/255, 3/255, 8/255>;
#declare CN_Ninja_Turtle = rgb <148/255, 177/255, 169/255>;
#declare CN_Ninjin_Orange = rgb <229/255, 170/255, 112/255>;
#declare CN_Nipple = rgb <187/255, 119/255, 119/255>;
#declare CN_Nippon = rgb <188/255, 0/255, 44/255>;
#declare CN_Nirvana = rgb <162/255, 145/255, 155/255>;
#declare CN_Nirvana_Jewel = rgb <100/255, 165/255, 173/255>;
#declare CN_Nisemurasaki_Purple = rgb <67/255, 36/255, 42/255>;
#declare CN_Niu_Zai_Se_Denim = rgb <5/255, 110/255, 238/255>;
#declare CN_No_More_Drama = rgb <163/255, 63/255, 64/255>;
#declare CN_No_Need_to_Blush = rgb <255/255, 214/255, 221/255>;
#declare CN_No_Way_Rose = rgb <251/255, 170/255, 149/255>;
#declare CN_No_GMB_Yellow = rgb <248/255, 232/255, 136/255>;
#declare CN_Nobel = rgb <169/255, 157/255, 157/255>;
#declare CN_Nobility_Blue = rgb <65/255, 73/255, 105/255>;
#declare CN_Noble_Blue = rgb <105/255, 121/255, 145/255>;
#declare CN_Noble_Blush = rgb <232/255, 185/255, 178/255>;
#declare CN_Noble_Cause_Purple = rgb <126/255, 30/255, 156/255>;
#declare CN_Noble_Crown = rgb <141/255, 117/255, 93/255>;
#declare CN_Noble_Fir = rgb <90/255, 115/255, 109/255>;
#declare CN_Noble_Grey = rgb <193/255, 190/255, 185/255>;
#declare CN_Noble_Honor = rgb <105/255, 53/255, 79/255>;
#declare CN_Noble_Knight = rgb <57/255, 77/255, 120/255>;
#declare CN_Noble_Lilac = rgb <178/255, 131/255, 146/255>;
#declare CN_Noble_Plum = rgb <135/255, 31/255, 120/255>;
#declare CN_Noble_Purple = rgb <175/255, 177/255, 197/255>;
#declare CN_Noble_Robe = rgb <128/255, 112/255, 112/255>;
#declare CN_Noble_Silver = rgb <115/255, 119/255, 127/255>;
#declare CN_Noble_Tone = rgb <136/255, 73/255, 103/255>;
#declare CN_Noblesse = rgb <82/255, 75/255, 80/255>;
#declare CN_Noctis = rgb <100/255, 107/255, 119/255>;
#declare CN_Nocturnal_Flight = rgb <103/255, 87/255, 84/255>;
#declare CN_Nocturnal_Rose = rgb <204/255, 102/255, 153/255>;
#declare CN_Nocturnal_Sea = rgb <14/255, 96/255, 113/255>;
#declare CN_Nocturne = rgb <122/255, 75/255, 86/255>;
#declare CN_Nocturne_Blue = rgb <52/255, 77/255, 88/255>;
#declare CN_Nocturne_Shade = rgb <53/255, 111/255, 173/255>;
#declare CN_Noghrei_Silver = rgb <189/255, 190/255, 189/255>;
#declare CN_Nomad = rgb <161/255, 153/255, 134/255>;
#declare CN_Nomad_Grey = rgb <126/255, 115/255, 111/255>;
#declare CN_Nomadic = rgb <175/255, 148/255, 121/255>;
#declare CN_Nomadic_Desert = rgb <199/255, 177/255, 152/255>;
#declare CN_Nomadic_Dream = rgb <219/255, 222/255, 219/255>;
#declare CN_Nomadic_Taupe = rgb <210/255, 198/255, 174/255>;
#declare CN_Nomadic_Travels = rgb <224/255, 201/255, 151/255>;
#declare CN_Nominee = rgb <53/255, 117/255, 103/255>;
#declare CN_Non_Skid_Grey = rgb <138/255, 141/255, 170/255>;
#declare CN_Non_Photo_Blue = rgb <164/255, 221/255, 237/255>;
#declare CN_Non_Stop_Orange = rgb <221/255, 136/255, 17/255>;
#declare CN_Nonchalant_White = rgb <222/255, 221/255, 209/255>;
#declare CN_Nonpareil_Apple = rgb <193/255, 166/255, 92/255>;
#declare CN_Noodle_Arms = rgb <245/255, 221/255, 196/255>;
#declare CN_Noodles = rgb <249/255, 227/255, 180/255>;
#declare CN_Norwester = rgb <153/255, 169/255, 173/255>;
#declare CN_Noras_Forest = rgb <0/255, 51/255, 51/255>;
#declare CN_Nordic = rgb <29/255, 57/255, 60/255>;
#declare CN_Nordic_Breeze = rgb <211/255, 221/255, 231/255>;
#declare CN_Nordic_Grass_Green = rgb <31/255, 171/255, 88/255>;
#declare CN_Nordic_Noir = rgb <0/255, 51/255, 68/255>;
#declare CN_Nordland_Blue = rgb <126/255, 149/255, 171/255>;
#declare CN_Nordland_Light_Blue = rgb <150/255, 174/255, 197/255>;
#declare CN_Norfolk_Green = rgb <46/255, 75/255, 60/255>;
#declare CN_Norfolk_Sky = rgb <108/255, 186/255, 231/255>;
#declare CN_Nori_Green = rgb <17/255, 42/255, 18/255>;
#declare CN_Nori_Seaweed_Green = rgb <70/255, 72/255, 38/255>;
#declare CN_Norman_Shaw_Goldspar = rgb <233/255, 198/255, 142/255>;
#declare CN_Norse_Blue = rgb <76/255, 165/255, 199/255>;
#declare CN_North_Atlantic = rgb <83/255, 109/255, 112/255>;
#declare CN_North_Beach_Blue = rgb <132/255, 156/255, 157/255>;
#declare CN_North_Cape_Grey = rgb <122/255, 149/255, 149/255>;
#declare CN_North_Grey = rgb <106/255, 119/255, 119/255>;
#declare CN_North_Island = rgb <188/255, 182/255, 180/255>;
#declare CN_North_Rim = rgb <216/255, 168/255, 146/255>;
#declare CN_North_Sea = rgb <49/255, 108/255, 107/255>;
#declare CN_North_Sea_Blue = rgb <52/255, 60/255, 76/255>;
#declare CN_North_Star = rgb <242/255, 222/255, 164/255>;
#declare CN_North_Star_Blue = rgb <34/255, 51/255, 153/255>;
#declare CN_North_Texas_Green = rgb <5/255, 144/255, 51/255>;
#declare CN_North_Wind = rgb <72/255, 189/255, 193/255>;
#declare CN_North_Woods = rgb <85/255, 90/255, 81/255>;
#declare CN_Northampton_Trees = rgb <118/255, 121/255, 98/255>;
#declare CN_Northeast_Trail = rgb <148/255, 134/255, 102/255>;
#declare CN_Northern_Barrens_Dust = rgb <222/255, 116/255, 60/255>;
#declare CN_Northern_Beach = rgb <233/255, 218/255, 210/255>;
#declare CN_Northern_Exposure = rgb <191/255, 199/255, 212/255>;
#declare CN_Northern_Glen = rgb <83/255, 98/255, 85/255>;
#declare CN_Northern_Landscape = rgb <197/255, 193/255, 163/255>;
#declare CN_Northern_Light_Grey = rgb <167/255, 174/255, 180/255>;
#declare CN_Northern_Lights = rgb <230/255, 240/255, 234/255>;
#declare CN_Northern_Pond = rgb <163/255, 185/255, 205/255>;
#declare CN_Northern_Sky = rgb <141/255, 172/255, 204/255>;
#declare CN_Northern_Star = rgb <255/255, 255/255, 234/255>;
#declare CN_Northern_Territory = rgb <94/255, 70/255, 60/255>;
#declare CN_Northgate_Green = rgb <170/255, 163/255, 136/255>;
#declare CN_Northpointe = rgb <158/255, 145/255, 129/255>;
#declare CN_Northrend = rgb <185/255, 242/255, 255/255>;
#declare CN_Norway = rgb <164/255, 184/255, 143/255>;
#declare CN_Norwegian_Blue = rgb <120/255, 136/255, 142/255>;
#declare CN_Norwich_Green = rgb <172/255, 181/255, 151/255>;
#declare CN_Nosegay = rgb <255/255, 230/255, 236/255>;
#declare CN_Nosferatu = rgb <169/255, 168/255, 168/255>;
#declare CN_Noshime_Flower = rgb <66/255, 101/255, 121/255>;
#declare CN_Nostalgia = rgb <214/255, 184/255, 189/255>;
#declare CN_Nostalgia_Rose = rgb <164/255, 119/255, 126/255>;
#declare CN_Nostalgic = rgb <102/255, 108/255, 126/255>;
#declare CN_Nostalgic_Evening = rgb <71/255, 98/255, 111/255>;
#declare CN_Not_a_Cloud_in_Sight = rgb <133/255, 200/255, 211/255>;
#declare CN_Not_My_Fault = rgb <126/255, 125/255, 120/255>;
#declare CN_Not_So_Innocent = rgb <106/255, 105/255, 104/255>;
#declare CN_Not_Yo_Cheese = rgb <255/255, 193/255, 44/255>;
#declare CN_Notable_Hue = rgb <139/255, 167/255, 187/255>;
#declare CN_Notebook_Paper = rgb <232/255, 235/255, 230/255>;
#declare CN_Notes_of_Plum = rgb <119/255, 15/255, 5/255>;
#declare CN_Noteworthy = rgb <217/255, 186/255, 204/255>;
#declare CN_Nothing_Less = rgb <242/255, 222/255, 185/255>;
#declare CN_Notice_Me = rgb <186/255, 134/255, 134/255>;
#declare CN_Notorious = rgb <189/255, 169/255, 152/255>;
#declare CN_Notorious_Neanderthal = rgb <102/255, 68/255, 0/255>;
#declare CN_Nottingham_Forest = rgb <88/255, 93/255, 78/255>;
#declare CN_Nougat = rgb <182/255, 152/255, 133/255>;
#declare CN_Nougat_Brown = rgb <124/255, 80/255, 63/255>;
#declare CN_Nouveau_Copper = rgb <160/255, 91/255, 66/255>;
#declare CN_Nouveau_Rose = rgb <153/255, 104/255, 114/255>;
#declare CN_Nouveau_Riche = rgb <255/255, 187/255, 119/255>;
#declare CN_Nouvelle_White = rgb <225/255, 220/255, 218/255>;
#declare CN_Novel_Lilac = rgb <194/255, 164/255, 194/255>;
#declare CN_Novelle_Peach = rgb <231/255, 207/255, 189/255>;
#declare CN_Novelty_Navy = rgb <81/255, 91/255, 98/255>;
#declare CN_November = rgb <190/255, 119/255, 103/255>;
#declare CN_November_Gold = rgb <246/255, 178/255, 101/255>;
#declare CN_November_Green = rgb <118/255, 119/255, 100/255>;
#declare CN_November_Leaf = rgb <241/255, 182/255, 144/255>;
#declare CN_November_Pink = rgb <237/255, 230/255, 232/255>;
#declare CN_November_Skies = rgb <124/255, 175/255, 185/255>;
#declare CN_November_Storms = rgb <66/255, 63/255, 59/255>;
#declare CN_Noxious = rgb <137/255, 162/255, 3/255>;
#declare CN_Nuance = rgb <226/255, 224/255, 214/255>;
#declare CN_Nuclear_Blast = rgb <187/255, 255/255, 0/255>;
#declare CN_Nuclear_Fallout = rgb <170/255, 153/255, 0/255>;
#declare CN_Nuclear_Mango = rgb <238/255, 153/255, 51/255>;
#declare CN_Nuclear_Meltdown = rgb <68/255, 238/255, 0/255>;
#declare CN_Nuclear_Throne = rgb <0/255, 222/255, 0/255>;
#declare CN_Nuclear_Waste = rgb <124/255, 252/255, 0/255>;
#declare CN_Nude = rgb <242/255, 211/255, 188/255>;
#declare CN_Nude_Flamingo = rgb <229/255, 143/255, 124/255>;
#declare CN_Nude_Lips = rgb <181/255, 148/255, 141/255>;
#declare CN_Nugget = rgb <188/255, 146/255, 41/255>;
#declare CN_Nugget_Gold = rgb <200/255, 151/255, 32/255>;
#declare CN_Nuisette = rgb <180/255, 131/255, 149/255>;
#declare CN_Nuit_Blanche = rgb <30/255, 72/255, 143/255>;
#declare CN_Nuln_Oil = rgb <20/255, 16/255, 14/255>;
#declare CN_Nuln_Oil_Gloss = rgb <23/255, 19/255, 16/255>;
#declare CN_Numbers = rgb <146/255, 155/255, 172/255>;
#declare CN_Numero_Uno = rgb <226/255, 230/255, 222/255>;
#declare CN_Nurgles_Rot = rgb <155/255, 143/255, 34/255>;
#declare CN_Nurgling_Green = rgb <184/255, 204/255, 130/255>;
#declare CN_Nursery = rgb <239/255, 208/255, 210/255>;
#declare CN_Nursery_Green = rgb <237/255, 240/255, 222/255>;
#declare CN_Nursery_Pink = rgb <244/255, 216/255, 232/255>;
#declare CN_Nurture = rgb <215/255, 220/255, 213/255>;
#declare CN_Nurture_Green = rgb <152/255, 176/255, 146/255>;
#declare CN_Nurturing = rgb <161/255, 169/255, 123/255>;
#declare CN_Nurude_Brown = rgb <157/255, 137/255, 108/255>;
#declare CN_Nut = rgb <158/255, 138/255, 109/255>;
#declare CN_Nut_Brown = rgb <134/255, 105/255, 94/255>;
#declare CN_Nut_Cracker = rgb <129/255, 108/255, 91/255>;
#declare CN_Nut_Flavor = rgb <215/255, 190/255, 164/255>;
#declare CN_Nut_Milk = rgb <217/255, 204/255, 200/255>;
#declare CN_Nut_Oil = rgb <119/255, 93/255, 56/255>;
#declare CN_Nuthatch = rgb <142/255, 114/255, 95/255>;
#declare CN_Nuthatch_Back = rgb <68/255, 85/255, 153/255>;
#declare CN_Nutmeg = rgb <126/255, 74/255, 59/255>;
#declare CN_Nutmeg_Frost = rgb <236/255, 217/255, 202/255>;
#declare CN_Nutmeg_Glow = rgb <216/255, 182/255, 145/255>;
#declare CN_Nutmeg_Wood_Finish = rgb <104/255, 54/255, 0/255>;
#declare CN_Nutria = rgb <117/255, 102/255, 62/255>;
#declare CN_Nutria_Fur_Brown = rgb <81/255, 64/255, 53/255>;
#declare CN_Nutshell = rgb <169/255, 133/255, 107/255>;
#declare CN_Nutter_Butter = rgb <247/255, 212/255, 198/255>;
#declare CN_Nutty_Beige = rgb <212/255, 188/255, 163/255>;
#declare CN_Nutty_Brown = rgb <138/255, 111/255, 68/255>;
#declare CN_Nyanza = rgb <233/255, 255/255, 219/255>;
#declare CN_NYC_Taxi = rgb <247/255, 183/255, 49/255>;
#declare CN_Nyctophobia_Blue = rgb <77/255, 88/255, 122/255>;
#declare CN_Nylon = rgb <233/255, 227/255, 203/255>;
#declare CN_Nymph_Green = rgb <174/255, 194/255, 165/255>;
#declare CN_Nymphs_Delight = rgb <123/255, 108/255, 142/255>;
#declare CN_Nymphaeaceae = rgb <206/255, 224/255, 227/255>;
#declare CN_Nypd = rgb <95/255, 110/255, 119/255>;
#declare CN_O_Fortuna = rgb <225/255, 184/255, 181/255>;
#declare CN_O_Tannenbaum = rgb <0/255, 85/255, 34/255>;
#declare CN_OBrien_Orange = rgb <243/255, 163/255, 71/255>;
#declare CN_Ogrady_Green = rgb <88/255, 172/255, 143/255>;
#declare CN_ONeal_Green = rgb <57/255, 86/255, 67/255>;
#declare CN_Oak_Barrel = rgb <113/255, 86/255, 54/255>;
#declare CN_Oak_Brown = rgb <161/255, 141/255, 128/255>;
#declare CN_Oak_Buff = rgb <207/255, 156/255, 99/255>;
#declare CN_Oak_Creek = rgb <93/255, 80/255, 74/255>;
#declare CN_Oak_Harbour = rgb <205/255, 179/255, 134/255>;
#declare CN_Oak_Plank = rgb <93/255, 79/255, 57/255>;
#declare CN_Oak_Ridge = rgb <192/255, 176/255, 171/255>;
#declare CN_Oak_Shaving = rgb <238/255, 216/255, 194/255>;
#declare CN_Oak_Tone = rgb <208/255, 199/255, 182/255>;
#declare CN_Oakley_Apricot = rgb <224/255, 182/255, 149/255>;
#declare CN_Oakmoss = rgb <109/255, 114/255, 68/255>;
#declare CN_Oakwood = rgb <189/255, 165/255, 139/255>;
#declare CN_Oakwood_Brown = rgb <143/255, 113/255, 110/255>;
#declare CN_Oarsman_Blue = rgb <100/255, 141/255, 149/255>;
#declare CN_Oasis = rgb <0/255, 146/255, 163/255>;
#declare CN_Oasis_Sand = rgb <252/255, 237/255, 197/255>;
#declare CN_Oasis_Spring = rgb <71/255, 163/255, 198/255>;
#declare CN_Oasis_Stream = rgb <162/255, 235/255, 216/255>;
#declare CN_Oat_Cake = rgb <225/255, 202/255, 179/255>;
#declare CN_Oat_Field = rgb <192/255, 173/255, 137/255>;
#declare CN_Oat_Flour = rgb <247/255, 228/255, 205/255>;
#declare CN_Oat_Milk = rgb <222/255, 218/255, 205/255>;
#declare CN_Oat_Straw = rgb <241/255, 214/255, 148/255>;
#declare CN_Oath = rgb <74/255, 70/255, 90/255>;
#declare CN_Oatmeal = rgb <203/255, 195/255, 180/255>;
#declare CN_Oatmeal_Bath = rgb <221/255, 199/255, 162/255>;
#declare CN_Oatmeal_Biscuit = rgb <183/255, 168/255, 109/255>;
#declare CN_Oatmeal_Cookie = rgb <234/255, 218/255, 198/255>;
#declare CN_Obi_Lilac = rgb <176/255, 163/255, 182/255>;
#declare CN_Object_of_Desire = rgb <183/255, 168/255, 168/255>;
#declare CN_Objectivity = rgb <187/255, 198/255, 222/255>;
#declare CN_Obligation = rgb <84/255, 100/255, 92/255>;
#declare CN_Oblivion = rgb <0/255, 4/255, 53/255>;
#declare CN_Obscure_Ochre = rgb <136/255, 101/255, 78/255>;
#declare CN_Obscure_Ogre = rgb <119/255, 25/255, 8/255>;
#declare CN_Obscure_Olive = rgb <74/255, 93/255, 35/255>;
#declare CN_Obscure_Orange = rgb <187/255, 85/255, 0/255>;
#declare CN_Obscure_Orchid = rgb <157/255, 7/255, 89/255>;
#declare CN_Observatory = rgb <0/255, 143/255, 112/255>;
#declare CN_Obsession = rgb <174/255, 149/255, 80/255>;
#declare CN_Obsidian = rgb <68/255, 80/255, 85/255>;
#declare CN_Obsidian_Brown = rgb <82/255, 62/255, 53/255>;
#declare CN_Obsidian_Lava_Black = rgb <56/255, 43/255, 70/255>;
#declare CN_Obsidian_Red = rgb <55/255, 42/255, 56/255>;
#declare CN_Obsidian_Shard = rgb <6/255, 3/255, 19/255>;
#declare CN_Obsidian_Shell = rgb <68/255, 17/255, 102/255>;
#declare CN_Obsidian_Stone = rgb <60/255, 63/255, 64/255>;
#declare CN_Obstinate_Orange = rgb <215/255, 85/255, 42/255>;
#declare CN_Obtrusive_Orange = rgb <255/255, 176/255, 119/255>;
#declare CN_Ocean = rgb <0/255, 84/255, 147/255>;
#declare CN_Ocean_Abyss = rgb <34/255, 17/255, 102/255>;
#declare CN_Ocean_Air = rgb <218/255, 228/255, 237/255>;
#declare CN_Ocean_Blue = rgb <0/255, 157/255, 196/255>;
#declare CN_Ocean_Boat_Blue = rgb <0/255, 119/255, 190/255>;
#declare CN_Ocean_Boulevard = rgb <164/255, 200/255, 200/255>;
#declare CN_Ocean_Breeze = rgb <211/255, 229/255, 235/255>;
#declare CN_Ocean_Bubble = rgb <140/255, 173/255, 205/255>;
#declare CN_Ocean_Call = rgb <43/255, 108/255, 142/255>;
#declare CN_Ocean_City = rgb <120/255, 150/255, 186/255>;
#declare CN_Ocean_Crest = rgb <214/255, 221/255, 221/255>;
#declare CN_Ocean_Cruise = rgb <156/255, 212/255, 225/255>;
#declare CN_Ocean_Current = rgb <83/255, 119/255, 131/255>;
#declare CN_Ocean_Depths = rgb <0/255, 97/255, 117/255>;
#declare CN_Ocean_Dream = rgb <212/255, 221/255, 226/255>;
#declare CN_Ocean_Drive = rgb <176/255, 190/255, 197/255>;
#declare CN_Ocean_Droplet = rgb <175/255, 195/255, 188/255>;
#declare CN_Ocean_Foam = rgb <202/255, 200/255, 180/255>;
#declare CN_Ocean_Frigate = rgb <122/255, 120/255, 120/255>;
#declare CN_Ocean_Front = rgb <184/255, 227/255, 237/255>;
#declare CN_Ocean_Green = rgb <61/255, 153/255, 115/255>;
#declare CN_Ocean_Kiss = rgb <164/255, 195/255, 197/255>;
#declare CN_Ocean_Liner = rgb <24/255, 144/255, 134/255>;
#declare CN_Ocean_Melody = rgb <125/255, 153/255, 159/255>;
#declare CN_Ocean_Mirage = rgb <0/255, 116/255, 143/255>;
#declare CN_Ocean_Night = rgb <99/255, 113/255, 149/255>;
#declare CN_Ocean_Oasis = rgb <0/255, 108/255, 104/255>;
#declare CN_Ocean_Pearl = rgb <211/255, 207/255, 189/255>;
#declare CN_Ocean_Ridge = rgb <117/255, 148/255, 179/255>;
#declare CN_Ocean_Sand = rgb <228/255, 213/255, 205/255>;
#declare CN_Ocean_Shadow = rgb <91/255, 120/255, 134/255>;
#declare CN_Ocean_Spray = rgb <0/255, 83/255, 121/255>;
#declare CN_Ocean_Storm = rgb <63/255, 103/255, 126/255>;
#declare CN_Ocean_Surf = rgb <121/255, 162/255, 189/255>;
#declare CN_Ocean_Swell = rgb <114/255, 124/255, 126/255>;
#declare CN_Ocean_Trapeze = rgb <46/255, 82/255, 106/255>;
#declare CN_Ocean_Trip = rgb <98/255, 174/255, 186/255>;
#declare CN_Ocean_Tropic = rgb <103/255, 166/255, 212/255>;
#declare CN_Ocean_View = rgb <114/255, 155/255, 179/255>;
#declare CN_Ocean_Wave = rgb <142/255, 197/255, 182/255>;
#declare CN_Ocean_Weed = rgb <108/255, 101/255, 65/255>;
#declare CN_Oceanic = rgb <79/255, 109/255, 130/255>;
#declare CN_Oceanic_Climate = rgb <187/255, 200/255, 201/255>;
#declare CN_Oceano = rgb <154/255, 214/255, 229/255>;
#declare CN_Oceanside = rgb <1/255, 90/255, 107/255>;
#declare CN_Oceanus = rgb <144/255, 171/255, 168/255>;
#declare CN_Ocelot = rgb <241/255, 226/255, 201/255>;
#declare CN_Ocher = rgb <191/255, 155/255, 12/255>;
#declare CN_Ochre = rgb <204/255, 119/255, 34/255>;
#declare CN_Ochre_Brown = rgb <159/255, 123/255, 62/255>;
#declare CN_Ochre_Maroon = rgb <204/255, 119/255, 51/255>;
#declare CN_Ochre_Revival = rgb <238/255, 201/255, 135/255>;
#declare CN_Ochre_Spice = rgb <233/255, 109/255, 3/255>;
#declare CN_Ochre_Yellow = rgb <239/255, 204/255, 131/255>;
#declare CN_Octagon_Ocean = rgb <8/255, 91/255, 115/255>;
#declare CN_Octarine = rgb <204/255, 221/255, 0/255>;
#declare CN_Octavius = rgb <55/255, 57/255, 62/255>;
#declare CN_October = rgb <198/255, 117/255, 51/255>;
#declare CN_October_Bounty = rgb <227/255, 198/255, 163/255>;
#declare CN_October_Harvest = rgb <209/255, 187/255, 152/255>;
#declare CN_October_Haze = rgb <248/255, 172/255, 140/255>;
#declare CN_October_Leaves = rgb <133/255, 87/255, 67/255>;
#declare CN_October_Sky = rgb <143/255, 162/255, 162/255>;
#declare CN_Odd_Pea_Pod = rgb <53/255, 121/255, 17/255>;
#declare CN_Ode_to_Green = rgb <182/255, 229/255, 214/255>;
#declare CN_Ode_to_Joy = rgb <157/255, 64/255, 74/255>;
#declare CN_Ode_to_Purple = rgb <167/255, 152/255, 194/255>;
#declare CN_Odious_Orange = rgb <255/255, 223/255, 191/255>;
#declare CN_Odyssey = rgb <55/255, 74/255, 90/255>;
#declare CN_Odyssey_Grey = rgb <67/255, 68/255, 82/255>;
#declare CN_Odyssey_Lilac = rgb <213/255, 198/255, 204/255>;
#declare CN_Odyssey_Plum = rgb <225/255, 194/255, 197/255>;
#declare CN_Off_Blue = rgb <86/255, 132/255, 174/255>;
#declare CN_Off_Broadway = rgb <67/255, 63/255, 61/255>;
#declare CN_Off_Green = rgb <107/255, 163/255, 83/255>;
#declare CN_Off_Shore = rgb <209/255, 204/255, 203/255>;
#declare CN_Off_the_Grid = rgb <159/255, 144/255, 73/255>;
#declare CN_Off_The_Grid = rgb <184/255, 174/255, 164/255>;
#declare CN_Off_White = rgb <255/255, 255/255, 228/255>;
#declare CN_Off_Yellow = rgb <241/255, 243/255, 63/255>;
#declare CN_Off_Road_Green = rgb <0/255, 55/255, 35/255>;
#declare CN_Offbeat = rgb <214/255, 208/255, 198/255>;
#declare CN_Offbeat_Green = rgb <156/255, 139/255, 31/255>;
#declare CN_Office_Blue_Green = rgb <0/255, 108/255, 101/255>;
#declare CN_Office_Green = rgb <0/255, 128/255, 15/255>;
#declare CN_Office_Grey = rgb <99/255, 93/255, 84/255>;
#declare CN_Office_Neon_Light = rgb <255/255, 34/255, 119/255>;
#declare CN_Official_Violet = rgb <46/255, 65/255, 130/255>;
#declare CN_Offshore_Mist = rgb <202/255, 216/255, 216/255>;
#declare CN_Often_Orange = rgb <255/255, 113/255, 78/255>;
#declare CN_Ogen_Melon = rgb <215/255, 178/255, 53/255>;
#declare CN_Ogre_Odor = rgb <253/255, 82/255, 64/255>;
#declare CN_Ogryn_Camo = rgb <157/255, 169/255, 75/255>;
#declare CN_Ogryn_Flesh_Wash = rgb <209/255, 161/255, 78/255>;
#declare CN_Oh_Boy_ = rgb <187/255, 218/255, 248/255>;
#declare CN_Oh_Dahling = rgb <237/255, 238/255, 197/255>;
#declare CN_Oh_My_Gold = rgb <238/255, 187/255, 85/255>;
#declare CN_Oh_Pistachio = rgb <171/255, 202/255, 153/255>;
#declare CN_Oh_So_Pretty = rgb <234/255, 199/255, 203/255>;
#declare CN_Oil = rgb <49/255, 51/255, 48/255>;
#declare CN_Oil_Blue = rgb <101/255, 140/255, 136/255>;
#declare CN_Oil_Green = rgb <128/255, 133/255, 109/255>;
#declare CN_Oil_Of_Lavender = rgb <199/255, 190/255, 190/255>;
#declare CN_Oil_on_Fire = rgb <255/255, 85/255, 17/255>;
#declare CN_Oil_Rush = rgb <51/255, 49/255, 68/255>;
#declare CN_Oil_Slick = rgb <3/255, 22/255, 2/255>;
#declare CN_Oil_Yellow = rgb <196/255, 166/255, 71/255>;
#declare CN_Oilcloth_Green = rgb <131/255, 186/255, 142/255>;
#declare CN_Oiled_Teak = rgb <108/255, 90/255, 81/255>;
#declare CN_Oiled_Up_Kardashian = rgb <153/255, 102/255, 68/255>;
#declare CN_Oilseed_Crops = rgb <194/255, 190/255, 14/255>;
#declare CN_Oily_Steel = rgb <153/255, 170/255, 170/255>;
#declare CN_Oitake_Green = rgb <94/255, 100/255, 79/255>;
#declare CN_OK_Corral = rgb <208/255, 115/255, 96/255>;
#declare CN_Oklahoma_Wheat = rgb <245/255, 224/255, 186/255>;
#declare CN_Okra = rgb <253/255, 239/255, 233/255>;
#declare CN_Okroshka = rgb <64/255, 83/255, 61/255>;
#declare CN_Old_Amethyst = rgb <135/255, 134/255, 143/255>;
#declare CN_Old_Army_Helmet = rgb <97/255, 102/255, 82/255>;
#declare CN_Old_Asparagus = rgb <146/255, 144/255, 0/255>;
#declare CN_Old_Bamboo = rgb <118/255, 145/255, 100/255>;
#declare CN_Old_Benchmark = rgb <2/255, 147/255, 134/255>;
#declare CN_Old_Bone = rgb <219/255, 194/255, 171/255>;
#declare CN_Old_Boot = rgb <124/255, 100/255, 75/255>;
#declare CN_Old_Botanical_Garden = rgb <94/255, 98/255, 74/255>;
#declare CN_Old_Brick = rgb <138/255, 51/255, 53/255>;
#declare CN_Old_Brown_Crayon = rgb <51/255, 0/255, 0/255>;
#declare CN_Old_Burgundy = rgb <67/255, 48/255, 46/255>;
#declare CN_Old_Celadon = rgb <168/255, 168/255, 157/255>;
#declare CN_Old_Chalk = rgb <227/255, 214/255, 233/255>;
#declare CN_Old_Cheddar = rgb <221/255, 102/255, 68/255>;
#declare CN_Old_Coffee = rgb <112/255, 66/255, 65/255>;
#declare CN_Old_Copper = rgb <115/255, 80/255, 59/255>;
#declare CN_Old_Cumin = rgb <120/255, 68/255, 48/255>;
#declare CN_Old_Doeskin = rgb <189/255, 171/255, 155/255>;
#declare CN_Old_Driftwood = rgb <151/255, 105/255, 79/255>;
#declare CN_Old_Eggplant = rgb <97/255, 64/255, 81/255>;
#declare CN_Old_Eggshell = rgb <205/255, 196/255, 186/255>;
#declare CN_Old_Faithful = rgb <130/255, 162/255, 190/255>;
#declare CN_Old_Fashioned_Pink = rgb <244/255, 198/255, 204/255>;
#declare CN_Old_Fashioned_Purple = rgb <115/255, 72/255, 107/255>;
#declare CN_Old_Flame = rgb <242/255, 183/255, 181/255>;
#declare CN_Old_Four_Leaf_Clover = rgb <117/255, 125/255, 67/255>;
#declare CN_Old_Geranium = rgb <198/255, 103/255, 135/255>;
#declare CN_Old_Glory_Blue = rgb <0/255, 40/255, 104/255>;
#declare CN_Old_Glory_Red = rgb <191/255, 10/255, 48/255>;
#declare CN_Old_Gold = rgb <207/255, 181/255, 59/255>;
#declare CN_Old_Green = rgb <131/255, 149/255, 115/255>;
#declare CN_Old_Grey_Mare = rgb <180/255, 182/255, 173/255>;
#declare CN_Old_Gungeon_Red = rgb <0/255, 99/255, 236/255>;
#declare CN_Old_Heart = rgb <230/255, 106/255, 119/255>;
#declare CN_Old_Heliotrope = rgb <86/255, 60/255, 92/255>;
#declare CN_Old_Ivory = rgb <255/255, 255/255, 203/255>;
#declare CN_Old_Kitchen_White = rgb <239/255, 245/255, 220/255>;
#declare CN_Old_Lace = rgb <253/255, 245/255, 230/255>;
#declare CN_Old_Laser_Lemon = rgb <253/255, 252/255, 116/255>;
#declare CN_Old_Lavender = rgb <121/255, 104/255, 120/255>;
#declare CN_Old_Leather = rgb <168/255, 139/255, 102/255>;
#declare CN_Old_Lime = rgb <174/255, 197/255, 113/255>;
#declare CN_Old_Mahogany = rgb <74/255, 1/255, 0/255>;
#declare CN_Old_Mandarin = rgb <142/255, 35/255, 35/255>;
#declare CN_Old_Map = rgb <213/255, 201/255, 188/255>;
#declare CN_Old_Mauve = rgb <103/255, 49/255, 71/255>;
#declare CN_Old_Mill = rgb <52/255, 59/255, 78/255>;
#declare CN_Old_Mill_Blue = rgb <110/255, 111/255, 130/255>;
#declare CN_Old_Mission_Pink = rgb <216/255, 194/255, 202/255>;
#declare CN_Old_Money = rgb <44/255, 92/255, 79/255>;
#declare CN_Old_Moss_Green = rgb <134/255, 126/255, 54/255>;
#declare CN_Old_Nan_Yarn = rgb <94/255, 88/255, 150/255>;
#declare CN_Old_Pearls = rgb <246/255, 235/255, 215/255>;
#declare CN_Old_Pink = rgb <199/255, 121/255, 134/255>;
#declare CN_Old_Porch = rgb <116/255, 89/255, 71/255>;
#declare CN_Old_Prune = rgb <130/255, 114/255, 164/255>;
#declare CN_Old_Red_Crest = rgb <216/255, 203/255, 207/255>;
#declare CN_Old_Rose = rgb <192/255, 128/255, 129/255>;
#declare CN_Old_Ruin = rgb <145/255, 123/255, 83/255>;
#declare CN_Old_School = rgb <53/255, 60/255, 61/255>;
#declare CN_Old_Silver = rgb <132/255, 132/255, 130/255>;
#declare CN_Old_Trail = rgb <187/255, 136/255, 17/255>;
#declare CN_Old_Treasure_Chest = rgb <84/255, 67/255, 51/255>;
#declare CN_Old_Truck = rgb <10/255, 136/255, 138/255>;
#declare CN_Old_Vine = rgb <104/255, 119/255, 96/255>;
#declare CN_Old_Whiskey = rgb <221/255, 170/255, 85/255>;
#declare CN_Old_Willow_Leaf = rgb <117/255, 105/255, 71/255>;
#declare CN_Old_Wine = rgb <144/255, 9/255, 31/255>;
#declare CN_Old_World = rgb <178/255, 183/255, 2