// This work is licensed under the Attribution-ShareAlike 4.0 International.
//
//    Persistence of Vision Ray Tracer Include File
//
//    File           : farger_ams595.inc
//    Version        : 4.0
//    Created by     : Sven-Erik Andersen
//    Contact        : sven.erik.andersen@gmail.com
//    Created date   : 2014-06-22
//    Last updated   : 2020-01-18
//    Description    : Farger means colors in Norwegian.
//                     
//

#ifndef(farger_ams595_Inc_Temp)
    #declare farger_ams595_Inc_Temp = version;
    #version 3.7;

    // Where the color definition is the same as in the POV-Ray color.inc include file,
    // the color name will point to the POV-Ray color definition,
    // so we need to make sure that file is included
    #ifndef(Colors_Inc_Temp)
        #include "colors.inc"
    #end

    #ifdef(View_POV_Include_Stack)
        #debug "including farger_ams595.inc\n"
    #end

    // Official farger_ams595
    #declare FS_10032 = rgb <0.215686274509804, 0.152941176470588, 0.149019607843137>; // HEX #372726
    #declare FS_10045 = rgb <0.372549019607843, 0.309803921568627, 0.290196078431373>; // HEX #5F4F4A
    #declare FS_10049 = rgb <0.309803921568627, 0.164705882352941, 0.145098039215686>; // HEX #4F2A25
    #declare FS_10055 = rgb <0.435294117647059, 0.274509803921569, 0.145098039215686>; // HEX #6F4625
    #declare FS_10059 = rgb <0.27843137254902, 0.211764705882353, 0.172549019607843>; // HEX #47362C
    #declare FS_10075 = rgb <0.396078431372549, 0.250980392156863, 0.215686274509804>; // HEX #654037
    #declare FS_10076 = rgb <0.486274509803922, 0.223529411764706, 0.145098039215686>; // HEX #7C3925
    #declare FS_10080 = rgb <0.380392156862745, 0.290196078431373, 0.211764705882353>; // HEX #614A36
    #declare FS_10091 = rgb <0.509803921568627, 0.27843137254902, 0.145098039215686>; // HEX #824725
    #declare FS_10115 = rgb <0.650980392156863, 0.431372549019608, 0.266666666666667>; // HEX #A66E44
    #declare FS_10129 = rgb <0.529411764705882, 0.435294117647059, 0.333333333333333>; // HEX #876F55
    #declare FS_10219 = rgb <0.603921568627451, 0.494117647058824, 0.403921568627451>; // HEX #9A7E67
    #declare FS_10233 = rgb <0.674509803921569, 0.490196078431373, 0.427450980392157>; // HEX #AC7D6D
    #declare FS_10260 = rgb <0.815686274509804, 0.690196078431373, 0.447058823529412>; // HEX #D0B072
    #declare FS_10266 = rgb <0.694117647058824, 0.56078431372549, 0.345098039215686>; // HEX #B18F58
    #declare FS_10324 = rgb <0.709803921568627, 0.607843137254902, 0.533333333333333>; // HEX #B59B88
    #declare FS_10371 = rgb <0.8, 0.603921568627451, 0.388235294117647>; // HEX #CC9A63
    #declare FS_11086 = rgb <0.67843137254902, 0.137254901960784, 0.156862745098039>; // HEX #AD2328
    #declare FS_11105 = rgb <0.682352941176471, 0.156862745098039, 0.145098039215686>; // HEX #AE2825
    #declare FS_11120 = rgb <0.76078431372549, 0.231372549019608, 0.192156862745098>; // HEX #C23B31
    #declare FS_11136_Insignia_Red = rgb <0.63921568627451, 0.168627450980392, 0.145098039215686>; // HEX #A32B25
    #declare FS_11140 = rgb <0.682352941176471, 0.168627450980392, 0.16078431372549>; // HEX #AE2B29
    #declare FS_11302 = rgb <0.803921568627451, 0.309803921568627, 0.227450980392157>; // HEX #CD4F3A
    #declare FS_11328 = rgb <0.745098039215686, 0.290196078431373, 0.32156862745098>; // HEX #BE4A52
    #declare FS_11400 = rgb <0.83921568627451, 0.313725490196078, 0.188235294117647>; // HEX #D65030
    #declare FS_11630_Pink = rgb <0.905882352941176, 0.756862745098039, 0.733333333333333>; // HEX #E7C1BB
    #declare FS_11670 = rgb <0.972549019607843, 0.831372549019608, 0.733333333333333>; // HEX #F8D4BB
    #declare FS_12160 = rgb <0.701960784313725, 0.4, 0.27843137254902>; // HEX #B36647
    #declare FS_12197_International_Orange = rgb <0.823529411764706, 0.305882352941176, 0>; // HEX #D24E00
    #declare FS_12199 = rgb <0.925490196078431, 0.262745098039216, 0>; // HEX #EC4300
    #declare FS_12215 = rgb <0.843137254901961, 0.380392156862745, 0.0901960784313725>; // HEX #D76117
    #declare FS_12243 = rgb <0.890196078431372, 0.450980392156863, 0>; // HEX #E37300
    #declare FS_12246 = rgb <0.874509803921569, 0.380392156862745, 0>; // HEX #DF6100
    #declare FS_12300 = rgb <0.874509803921569, 0.541176470588235, 0.498039215686275>; // HEX #DF8A7F
    #declare FS_12473 = rgb <0.929411764705882, 0.47843137254902, 0>; // HEX #ED7A00
    #declare FS_12648 = rgb <0.933333333333333, 0.788235294117647, 0.635294117647059>; // HEX #EEC9A2
    #declare FS_13275 = rgb <0.670588235294118, 0.501960784313725, 0>; // HEX #AB8000
    #declare FS_13415 = rgb <0.937254901960784, 0.643137254901961, 0>; // HEX #EFA400
    #declare FS_13432 = rgb <0.96078431372549, 0.643137254901961, 0>; // HEX #F5A400
    #declare FS_13507 = rgb <1, 0.717647058823529, 0>; // HEX #FFB700
    #declare FS_13522 = rgb <0.823529411764706, 0.756862745098039, 0.643137254901961>; // HEX #D2C1A4
    #declare FS_13523 = rgb <0.870588235294118, 0.784313725490196, 0.0352941176470588>; // HEX #DEC809
    #declare FS_13531 = rgb <0.843137254901961, 0.756862745098039, 0.658823529411765>; // HEX #D7C1A8
    #declare FS_13538_Orange_Yellow = rgb <0.976470588235294, 0.690196078431373, 0>; // HEX #F9B000
    #declare FS_13578 = rgb <0.874509803921569, 0.8, 0.654901960784314>; // HEX #DFCCA7
    #declare FS_13591 = rgb <0.968627450980392, 0.819607843137255, 0>; // HEX #F7D100
    #declare FS_13594 = rgb <0.949019607843137, 0.803921568627451, 0.533333333333333>; // HEX #F2CD88
    #declare FS_13596 = rgb <0.905882352941176, 0.776470588235294, 0.525490196078431>; // HEX #E7C686
    #declare FS_13613 = rgb <0.945098039215686, 0.823529411764706, 0.666666666666667>; // HEX #F1D2AA
    #declare FS_13618 = rgb <0.964705882352941, 0.823529411764706, 0.427450980392157>; // HEX #F6D26D
    #declare FS_13637 = rgb <0.886274509803922, 0.705882352941177, 0.117647058823529>; // HEX #E2B41E
    #declare FS_13655_Blue_Angels_Yellow = rgb <1, 0.780392156862745, 0>; // HEX #FFC700
    #declare FS_13670_Lime_Yellow = rgb <1, 0.866666666666667, 0.407843137254902>; // HEX #FFDD68
    #declare FS_13690 = rgb <0.925490196078431, 0.854901960784314, 0.717647058823529>; // HEX #ECDAB7
    #declare FS_13695 = rgb <0.964705882352941, 0.831372549019608, 0.533333333333333>; // HEX #F6D488
    #declare FS_13711 = rgb <0.937254901960784, 0.843137254901961, 0.694117647058824>; // HEX #EFD7B1
    #declare FS_14036 = rgb <0.149019607843137, 0.23921568627451, 0.215686274509804>; // HEX #263D37
    #declare FS_14050 = rgb <0.258823529411765, 0.274509803921569, 0.235294117647059>; // HEX #42463C
    #declare FS_14052_Green = rgb <0.262745098039216, 0.266666666666667, 0.219607843137255>; // HEX #434438
    #declare FS_14056 = rgb <0.517647058823529, 0.2, 0.0470588235294118>; // HEX #84330C
    #declare FS_14062_Dark_Green = rgb <0.12156862745098, 0.337254901960784, 0.231372549019608>; // HEX #1F563B
    #declare FS_14064 = rgb <0.298039215686275, 0.294117647058824, 0.235294117647059>; // HEX #4C4B3C
    #declare FS_14066 = rgb <0, 0.356862745098039, 0.250980392156863>; // HEX #005B40
    #declare FS_14077 = rgb <0.274509803921569, 0.305882352941176, 0.266666666666667>; // HEX #464E44
    #declare FS_14079 = rgb <0.317647058823529, 0.32156862745098, 0.250980392156863>; // HEX #515240
    #declare FS_14084 = rgb <0.235294117647059, 0.215686274509804, 0.156862745098039>; // HEX #3C3728
    #declare FS_14087_Olive_Drab = rgb <0.235294117647059, 0.215686274509804, 0.152941176470588>; // HEX #3C3727
    #declare FS_14090 = rgb <0, 0.443137254901961, 0.270588235294118>; // HEX #007145
    #declare FS_14097 = rgb <0.376470588235294, 0.407843137254902, 0.290196078431373>; // HEX #60684A
    #declare FS_14108 = rgb <0.164705882352941, 0.337254901960784, 0.247058823529412>; // HEX #2A563F
    #declare FS_14109 = rgb <0, 0.372549019607843, 0.270588235294118>; // HEX #005F45
    #declare FS_14110 = rgb <0.152941176470588, 0.435294117647059, 0.227450980392157>; // HEX #276F3A
    #declare FS_14115_Green = rgb <0, 0.47843137254902, 0.349019607843137>; // HEX #007A59
    #declare FS_14120 = rgb <0, 0.494117647058824, 0.376470588235294>; // HEX #007E60
    #declare FS_14158 = rgb <0.419607843137255, 0.474509803921569, 0.462745098039216>; // HEX #6B7976
    #declare FS_14159 = rgb <0.454901960784314, 0.482352941176471, 0.431372549019608>; // HEX #747B6E
    #declare FS_14187 = rgb <0.32156862745098, 0.517647058823529, 0.192156862745098>; // HEX #528431
    #declare FS_14223 = rgb <0.372549019607843, 0.549019607843137, 0.415686274509804>; // HEX #5F8C6A
    #declare FS_14241 = rgb <0.529411764705882, 0.635294117647059, 0.596078431372549>; // HEX #87A298
    #declare FS_14255 = rgb <0.596078431372549, 0.556862745098039, 0.376470588235294>; // HEX #988E60
    #declare FS_14257 = rgb <0.580392156862745, 0.568627450980392, 0.4>; // HEX #949166
    #declare FS_14260 = rgb <0.388235294117647, 0.619607843137255, 0.494117647058824>; // HEX #639E7E
    #declare FS_14272 = rgb <0.47843137254902, 0.623529411764706, 0.505882352941176>; // HEX #7A9F81
    #declare FS_14277 = rgb <0.545098039215686, 0.619607843137255, 0.588235294117647>; // HEX #8B9E96
    #declare FS_14325 = rgb <0.517647058823529, 0.674509803921569, 0.607843137254902>; // HEX #84AC9B
    #declare FS_14449 = rgb <0.666666666666667, 0.741176470588235, 0.611764705882353>; // HEX #AABD9C
    #declare FS_14491 = rgb <0.682352941176471, 0.76078431372549, 0.67843137254902>; // HEX #AEC2AD
    #declare FS_14516 = rgb <0.72156862745098, 0.784313725490196, 0.717647058823529>; // HEX #B8C8B7
    #declare FS_14533 = rgb <0.698039215686274, 0.749019607843137, 0.596078431372549>; // HEX #B2BF98
    #declare FS_14672 = rgb <0.835294117647059, 0.858823529411765, 0.752941176470588>; // HEX #D5DBC0
    #declare FS_15042_Sea_Blue = rgb <0.176470588235294, 0.215686274509804, 0.23921568627451>; // HEX #2D373D
    #declare FS_15044_Insignia_Blue = rgb <0.149019607843137, 0.188235294117647, 0.258823529411765>; // HEX #263042
    #declare FS_15045 = rgb <0.129411764705882, 0.231372549019608, 0.290196078431373>; // HEX #213B4A
    #declare FS_15050_Blue_Angels_Blue = rgb <0.129411764705882, 0.250980392156863, 0.380392156862745>; // HEX #214061
    #declare FS_15052 = rgb <0.12156862745098, 0.184313725490196, 0.376470588235294>; // HEX #1F2F60
    #declare FS_15053 = rgb <0.149019607843137, 0.231372549019608, 0.337254901960784>; // HEX #263B56
    #declare FS_15056_Blue = rgb <0.145098039215686, 0.196078431372549, 0.450980392156863>; // HEX #253273
    #declare FS_15065 = rgb <0, 0.337254901960784, 0.525490196078431>; // HEX #005686
    #declare FS_15080 = rgb <0.117647058823529, 0.32156862745098, 0.43921568627451>; // HEX #1E5270
    #declare FS_15090 = rgb <0, 0.325490196078431, 0.482352941176471>; // HEX #00537B
    #declare FS_15092 = rgb <0, 0.458823529411765, 0.666666666666667>; // HEX #0075AA
    #declare FS_15102_Dark_Blue = rgb <0.0941176470588235, 0.392156862745098, 0.576470588235294>; // HEX #186493
    #declare FS_15107 = rgb <0.384313725490196, 0.517647058823529, 0.596078431372549>; // HEX #628498
    #declare FS_15123 = rgb <0.227450980392157, 0.423529411764706, 0.654901960784314>; // HEX #3A6CA7
    #declare FS_15125 = rgb <0, 0.431372549019608, 0.556862745098039>; // HEX #006E8E
    #declare FS_15177 = rgb <0.380392156862745, 0.505882352941176, 0.603921568627451>; // HEX #61819A
    #declare FS_15180 = rgb <0, 0.450980392156863, 0.705882352941177>; // HEX #0073B4
    #declare FS_15182 = rgb <0, 0.501960784313725, 0.690196078431373>; // HEX #0080B0
    #declare FS_15187 = rgb <0, 0.611764705882353, 0.784313725490196>; // HEX #009CC8
    #declare FS_15193 = rgb <0.345098039215686, 0.549019607843137, 0.584313725490196>; // HEX #588C95
    #declare FS_15200_Sky_Blue = rgb <0.329411764705882, 0.717647058823529, 0.831372549019608>; // HEX #54B7D4
    #declare FS_15450_Air_Superiority_Blue = rgb <0.592156862745098, 0.737254901960784, 0.835294117647059>; // HEX #97BCD5
    #declare FS_15526 = rgb <0.705882352941177, 0.772549019607843, 0.8>; // HEX #B4C5CC
    #declare FS_16081_Engine_Gray = rgb <0.333333333333333, 0.345098039215686, 0.337254901960784>; // HEX #555856
    #declare FS_16099 = rgb <0.337254901960784, 0.368627450980392, 0.384313725490196>; // HEX #565E62
    #declare FS_16152 = rgb <0.36078431372549, 0.388235294117647, 0.411764705882353>; // HEX #5C6369
    #declare FS_16160 = rgb <0.541176470588235, 0.466666666666667, 0.32156862745098>; // HEX #8A7752
    #declare FS_16165 = rgb <0.482352941176471, 0.470588235294118, 0.403921568627451>; // HEX #7B7867
    #declare FS_16187 = rgb <0.43921568627451, 0.505882352941176, 0.56078431372549>; // HEX #70818F
    #declare FS_16231 = rgb <0.462745098039216, 0.482352941176471, 0.498039215686275>; // HEX #767B7F
    #declare FS_16251 = rgb <0.556862745098039, 0.56078431372549, 0.556862745098039>; // HEX #8E8F8E
    #declare FS_16307 = rgb <0.615686274509804, 0.615686274509804, 0.584313725490196>; // HEX #9D9D95
    #declare FS_16314 = rgb <0.607843137254902, 0.623529411764706, 0.607843137254902>; // HEX #9B9F9B
    #declare FS_16350 = rgb <0.72156862745098, 0.52156862745098, 0.482352941176471>; // HEX #B8857B
    #declare FS_16357 = rgb <0.686274509803922, 0.666666666666667, 0.592156862745098>; // HEX #AFAA97
    #declare FS_16360 = rgb <0.713725490196078, 0.686274509803922, 0.607843137254902>; // HEX #B6AF9B
    #declare FS_16376 = rgb <0.662745098039216, 0.662745098039216, 0.619607843137255>; // HEX #A9A99E
    #declare FS_16405 = rgb <0.784313725490196, 0.745098039215686, 0.658823529411765>; // HEX #C8BEA8
    #declare FS_16440_Light_Gull_Gray = rgb <0.737254901960784, 0.729411764705882, 0.698039215686274>; // HEX #BCBAB2
    #declare FS_16473_Aircraft_Gray = rgb <0.666666666666667, 0.698039215686274, 0.690196078431373>; // HEX #AAB2B0
    #declare FS_16492 = rgb <0.772549019607843, 0.764705882352941, 0.737254901960784>; // HEX #C5C3BC
    #declare FS_16515_Canadian_Voodoo_Gray = rgb <0.780392156862745, 0.788235294117647, 0.780392156862745>; // HEX #C7C9C7
    #declare FS_16555 = rgb <0.823529411764706, 0.776470588235294, 0.662745098039216>; // HEX #D2C6A9
    #declare FS_17038_Black = rgb <0.172549019607843, 0.16078431372549, 0.149019607843137>; // HEX #2C2926
    #declare FS_17043_Gold = rgb <0.592156862745098, 0.517647058823529, 0.286274509803922>; // HEX #978449
    #declare FS_17100_Purple = rgb <0.454901960784314, 0.305882352941176, 0.47843137254902>; // HEX #744E7A
    #declare FS_17142 = rgb <0.631372549019608, 0.349019607843137, 0.529411764705882>; // HEX #A15987
    #declare FS_17155 = rgb <0.619607843137255, 0.384313725490196, 0.580392156862745>; // HEX #9E6294
    #declare FS_17178_Aluminum_Silver = rgb <0.607843137254902, 0.615686274509804, 0.623529411764706>; // HEX #9B9D9F
    #declare FS_17200 = rgb <0.568627450980392, 0.588235294117647, 0.6>; // HEX #919699
    #declare FS_17773 = rgb <0.901960784313726, 0.917647058823529, 0.882352941176471>; // HEX #E6EAE1
    #declare FS_17778 = rgb <0.945098039215686, 0.913725490196078, 0.823529411764706>; // HEX #F1E9D2
    #declare FS_17855 = rgb <0.96078431372549, 0.905882352941176, 0.772549019607843>; // HEX #F5E7C5
    #declare FS_17875_Insignia_White = rgb <0.945098039215686, 0.941176470588235, 0.917647058823529>; // HEX #F1F0EA
    #declare FS_17886 = rgb <0.968627450980392, 0.945098039215686, 0.890196078431372>; // HEX #F7F1E3
    #declare FS_17925_Insignia_White = rgb <0.980392156862745, 0.968627450980392, 0.945098039215686>; // HEX #FAF7F1
    #declare FS_20040 = rgb <0.313725490196078, 0.262745098039216, 0.215686274509804>; // HEX #504337
    #declare FS_20045 = rgb <0.380392156862745, 0.313725490196078, 0.298039215686275>; // HEX #61504C
    #declare FS_20059 = rgb <0.364705882352941, 0.282352941176471, 0.243137254901961>; // HEX #5D483E
    #declare FS_20061_Maroon = rgb <0.423529411764706, 0.266666666666667, 0.266666666666667>; // HEX #6C4444
    #declare FS_20062_Brown = rgb <0.337254901960784, 0.286274509803922, 0.266666666666667>; // HEX #564944
    #declare FS_20095 = rgb <0.486274509803922, 0.415686274509804, 0.337254901960784>; // HEX #7C6A56
    #declare FS_20100_Brown_Yellow = rgb <0.56078431372549, 0.349019607843137, 0.219607843137255>; // HEX #8F5938
    #declare FS_20109_Red_Brown = rgb <0.549019607843137, 0.313725490196078, 0.247058823529412>; // HEX #8C503F
    #declare FS_20117 = rgb <0.525490196078431, 0.376470588235294, 0.274509803921569>; // HEX #866046
    #declare FS_20122 = rgb <0.462745098039216, 0.341176470588235, 0.235294117647059>; // HEX #76573C
    #declare FS_20129 = rgb <0.529411764705882, 0.435294117647059, 0.333333333333333>; // HEX #876F55
    #declare FS_20140_Brown_Special = rgb <0.529411764705882, 0.431372549019608, 0.356862745098039>; // HEX #876E5B
    #declare FS_20152 = rgb <0.584313725490196, 0.290196078431373, 0.231372549019608>; // HEX #954A3B
    #declare FS_20206 = rgb <0.623529411764706, 0.498039215686275, 0.474509803921569>; // HEX #9F7F79
    #declare FS_20219 = rgb <0.607843137254902, 0.498039215686275, 0.4>; // HEX #9B7F66
    #declare FS_20227 = rgb <0.63921568627451, 0.545098039215686, 0.470588235294118>; // HEX #A38B78
    #declare FS_20233 = rgb <0.674509803921569, 0.498039215686275, 0.443137254901961>; // HEX #AC7F71
    #declare FS_20252_Tan = rgb <0.729411764705882, 0.505882352941176, 0.415686274509804>; // HEX #BA816A
    #declare FS_20260_Tan = rgb <0.819607843137255, 0.686274509803922, 0.435294117647059>; // HEX #D1AF6F
    #declare FS_20266_Yellow_Sand = rgb <0.686274509803922, 0.568627450980392, 0.341176470588235>; // HEX #AF9157
    #declare FS_20313 = rgb <0.701960784313725, 0.607843137254902, 0.541176470588235>; // HEX #B39B8A
    #declare FS_20318 = rgb <0.690196078431373, 0.623529411764706, 0.52156862745098>; // HEX #B09F85
    #declare FS_20372 = rgb <0.72156862745098, 0.654901960784314, 0.568627450980392>; // HEX #B8A791
    #declare FS_20400_Tan = rgb <0.819607843137255, 0.654901960784314, 0.474509803921569>; // HEX #D1A779
    #declare FS_20450_Night_Tan = rgb <0.8, 0.694117647058824, 0.603921568627451>; // HEX #CCB19A
    #declare FS_21105_Red = rgb <0.725490196078431, 0.0588235294117647, 0.129411764705882>; // HEX #B90F21
    #declare FS_21136 = rgb <0.63921568627451, 0.188235294117647, 0.164705882352941>; // HEX #A3302A
    #declare FS_21158 = rgb <0.76078431372549, 0.356862745098039, 0.392156862745098>; // HEX #C25B64
    #declare FS_21302 = rgb <0.792156862745098, 0.305882352941176, 0.247058823529412>; // HEX #CA4E3F
    #declare FS_21310_Red = rgb <0.764705882352941, 0.145098039215686, 0.00784313725490196>; // HEX #C32502
    #declare FS_21400_Red = rgb <0.843137254901961, 0.301960784313725, 0.172549019607843>; // HEX #D74D2C
    #declare FS_21433 = rgb <0.823529411764706, 0.627450980392157, 0.545098039215686>; // HEX #D2A08B
    #declare FS_21575 = rgb <0.909803921568627, 0.752941176470588, 0.666666666666667>; // HEX #E8C0AA
    #declare FS_21643 = rgb <0.937254901960784, 0.835294117647059, 0.733333333333333>; // HEX #EFD5BB
    #declare FS_21667 = rgb <0.945098039215686, 0.831372549019608, 0.705882352941177>; // HEX #F1D4B4
    #declare FS_21668 = rgb <0.941176470588235, 0.827450980392157, 0.792156862745098>; // HEX #F0D3CA
    #declare FS_21670 = rgb <0.956862745098039, 0.823529411764706, 0.729411764705882>; // HEX #F4D2BA
    #declare FS_22144 = rgb <0.686274509803922, 0.345098039215686, 0.227450980392157>; // HEX #AF583A
    #declare FS_22190_Red = rgb <0.858823529411765, 0.274509803921569, 0.0705882352941176>; // HEX #DB4612
    #declare FS_22203 = rgb <0.764705882352941, 0.4, 0.243137254901961>; // HEX #C3663E
    #declare FS_22246 = rgb <0.882352941176471, 0.0509803921568627, 0.156862745098039>; // HEX #E10D28
    #declare FS_22276 = rgb <0.803921568627451, 0.490196078431373, 0.376470588235294>; // HEX #CD7D60
    #declare FS_22356 = rgb <0.870588235294118, 0.537254901960784, 0.43921568627451>; // HEX #DE8970
    #declare FS_22510 = rgb <1, 0.482352941176471, 0>; // HEX #FF7B00
    #declare FS_22516_Tan = rgb <0.882352941176471, 0.635294117647059, 0.474509803921569>; // HEX #E1A279
    #declare FS_22519 = rgb <0.874509803921569, 0.729411764705882, 0.619607843137255>; // HEX #DFBA9E
    #declare FS_22544 = rgb <0.976470588235294, 0.635294117647059, 0.301960784313725>; // HEX #F9A24D
    #declare FS_22563 = rgb <0.87843137254902, 0.76078431372549, 0.635294117647059>; // HEX #E0C2A2
    #declare FS_22630 = rgb <0.925490196078431, 0.788235294117647, 0.670588235294118>; // HEX #ECC9AB
    #declare FS_22648 = rgb <0.949019607843137, 0.807843137254902, 0.670588235294118>; // HEX #F2CEAB
    #declare FS_23448 = rgb <0.756862745098039, 0.666666666666667, 0.505882352941176>; // HEX #C1AA81
    #declare FS_23522 = rgb <0.823529411764706, 0.752941176470588, 0.643137254901961>; // HEX #D2C0A4
    #declare FS_23531 = rgb <0.843137254901961, 0.764705882352941, 0.662745098039216>; // HEX #D7C3A9
    #declare FS_23538 = rgb <0.996078431372549, 0.709803921568627, 0>; // HEX #FEB500
    #declare FS_23564 = rgb <0.882352941176471, 0.811764705882353, 0.643137254901961>; // HEX #E1CFA4
    #declare FS_23578_Cream = rgb <0.866666666666667, 0.803921568627451, 0.666666666666667>; // HEX #DDCDAA
    #declare FS_23594_Beige = rgb <0.949019607843137, 0.803921568627451, 0.549019607843137>; // HEX #F2CD8C
    #declare FS_23613 = rgb <0.937254901960784, 0.815686274509804, 0.654901960784314>; // HEX #EFD0A7
    #declare FS_23617 = rgb <0.913725490196078, 0.815686274509804, 0.650980392156863>; // HEX #E9D0A6
    #declare FS_23619 = rgb <0.913725490196078, 0.815686274509804, 0.650980392156863>; // HEX #E9D0A6
    #declare FS_23655_Yellow = rgb <1, 0.8, 0>; // HEX #FFCC00
    #declare FS_23685 = rgb <0.925490196078431, 0.890196078431372, 0.666666666666667>; // HEX #ECE3AA
    #declare FS_23690 = rgb <0.917647058823529, 0.847058823529412, 0.713725490196078>; // HEX #EAD8B6
    #declare FS_23695 = rgb <0.972549019607843, 0.835294117647059, 0.545098039215686>; // HEX #F8D58B
    #declare FS_23697_Yellow_Sand = rgb <0.96078431372549, 0.843137254901961, 0.556862745098039>; // HEX #F5D78E
    #declare FS_23711 = rgb <0.956862745098039, 0.858823529411765, 0.705882352941177>; // HEX #F4DBB4
    #declare FS_23717 = rgb <0.937254901960784, 0.866666666666667, 0.729411764705882>; // HEX #EFDDBA
    #declare FS_23722_Sand = rgb <0.933333333333333, 0.858823529411765, 0.686274509803922>; // HEX #EEDBAF
    #declare FS_23727 = rgb <0.949019607843137, 0.882352941176471, 0.682352941176471>; // HEX #F2E1AE
    #declare FS_23785 = rgb <0.956862745098039, 0.83921568627451, 0.309803921568627>; // HEX #F4D64F
    #declare FS_23793 = rgb <0.972549019607843, 0.913725490196078, 0.580392156862745>; // HEX #F8E994
    #declare FS_23814 = rgb <0.909803921568627, 0.905882352941176, 0.643137254901961>; // HEX #E8E7A4
    #declare FS_24052_Green = rgb <0.286274509803922, 0.290196078431373, 0.247058823529412>; // HEX #494A3F
    #declare FS_24064 = rgb <0.313725490196078, 0.301960784313725, 0.250980392156863>; // HEX #504D40
    #declare FS_24079_Forest_Green = rgb <0.341176470588235, 0.345098039215686, 0.286274509803922>; // HEX #575849
    #declare FS_24084 = rgb <0.274509803921569, 0.254901960784314, 0.196078431372549>; // HEX #464132
    #declare FS_24087 = rgb <0.270588235294118, 0.250980392156863, 0.192156862745098>; // HEX #454031
    #declare FS_24091 = rgb <0.392156862745098, 0.368627450980392, 0.352941176470588>; // HEX #645E5A
    #declare FS_24097 = rgb <0.380392156862745, 0.411764705882353, 0.305882352941176>; // HEX #61694E
    #declare FS_24098 = rgb <0.407843137254902, 0.396078431372549, 0.254901960784314>; // HEX #686541
    #declare FS_24108 = rgb <0.258823529411765, 0.411764705882353, 0.325490196078431>; // HEX #426953
    #declare FS_24148 = rgb <0.380392156862745, 0.470588235294118, 0.462745098039216>; // HEX #617876
    #declare FS_24158 = rgb <0.423529411764706, 0.474509803921569, 0.462745098039216>; // HEX #6C7976
    #declare FS_24159 = rgb <0.466666666666667, 0.490196078431373, 0.43921568627451>; // HEX #777D70
    #declare FS_24172 = rgb <0.427450980392157, 0.494117647058824, 0.407843137254902>; // HEX #6D7E68
    #declare FS_24201 = rgb <0.552941176470588, 0.52156862745098, 0.419607843137255>; // HEX #8D856B
    #declare FS_24226 = rgb <0.517647058823529, 0.56078431372549, 0.498039215686275>; // HEX #848F7F
    #declare FS_24227 = rgb <0.498039215686275, 0.572549019607843, 0.443137254901961>; // HEX #7F9271
    #declare FS_24233 = rgb <0.513725490196078, 0.588235294117647, 0.576470588235294>; // HEX #839693
    #declare FS_24241 = rgb <0.537254901960784, 0.643137254901961, 0.6>; // HEX #89A499
    #declare FS_24260 = rgb <0.427450980392157, 0.623529411764706, 0.513725490196078>; // HEX #6D9F83
    #declare FS_24272_Green = rgb <0.458823529411765, 0.611764705882353, 0.494117647058824>; // HEX #759C7E
    #declare FS_24277 = rgb <0.545098039215686, 0.615686274509804, 0.584313725490196>; // HEX #8B9D95
    #declare FS_24300 = rgb <0.549019607843137, 0.643137254901961, 0.580392156862745>; // HEX #8CA494
    #declare FS_24325 = rgb <0.509803921568627, 0.670588235294118, 0.603921568627451>; // HEX #82AB9A
    #declare FS_24373 = rgb <0.631372549019608, 0.690196078431373, 0.584313725490196>; // HEX #A1B095
    #declare FS_24410_Green = rgb <0.654901960784314, 0.72156862745098, 0.658823529411765>; // HEX #A7B8A8
    #declare FS_24417 = rgb <0.694117647058824, 0.725490196078431, 0.643137254901961>; // HEX #B1B9A4
    #declare FS_24424 = rgb <0.701960784313725, 0.713725490196078, 0.619607843137255>; // HEX #B3B69E
    #declare FS_24432 = rgb <0.698039215686274, 0.72156862745098, 0.650980392156863>; // HEX #B2B8A6
    #declare FS_24441 = rgb <0.694117647058824, 0.737254901960784, 0.631372549019608>; // HEX #B1BCA1
    #declare FS_24449 = rgb <0.658823529411765, 0.733333333333333, 0.603921568627451>; // HEX #A8BB9A
    #declare FS_24466 = rgb <0.654901960784314, 0.741176470588235, 0.643137254901961>; // HEX #A7BDA4
    #declare FS_24491 = rgb <0.67843137254902, 0.764705882352941, 0.690196078431373>; // HEX #ADC3B0
    #declare FS_24504 = rgb <0.698039215686274, 0.756862745098039, 0.658823529411765>; // HEX #B2C1A8
    #declare FS_24516 = rgb <0.717647058823529, 0.772549019607843, 0.709803921568627>; // HEX #B7C5B5
    #declare FS_24518 = rgb <0.698039215686274, 0.756862745098039, 0.686274509803922>; // HEX #B2C1AF
    #declare FS_24525 = rgb <0.725490196078431, 0.776470588235294, 0.674509803921569>; // HEX #B9C6AC
    #declare FS_24533 = rgb <0.701960784313725, 0.752941176470588, 0.596078431372549>; // HEX #B3C098
    #declare FS_24552 = rgb <0.819607843137255, 0.807843137254902, 0.549019607843137>; // HEX #D1CE8C
    #declare FS_24554 = rgb <0.843137254901961, 0.843137254901961, 0.729411764705882>; // HEX #D7D7BA
    #declare FS_24558 = rgb <0.756862745098039, 0.819607843137255, 0.698039215686274>; // HEX #C1D1B2
    #declare FS_24583 = rgb <0.796078431372549, 0.862745098039216, 0.72156862745098>; // HEX #CBDCB8
    #declare FS_24585 = rgb <0.807843137254902, 0.886274509803922, 0.780392156862745>; // HEX #CEE2C7
    #declare FS_24664 = rgb <0.772549019607843, 0.850980392156863, 0.752941176470588>; // HEX #C5D9C0
    #declare FS_24670 = rgb <0.831372549019608, 0.866666666666667, 0.796078431372549>; // HEX #D4DDCB
    #declare FS_24672 = rgb <0.843137254901961, 0.866666666666667, 0.756862745098039>; // HEX #D7DDC1
    #declare FS_25042 = rgb <0.207843137254902, 0.247058823529412, 0.270588235294118>; // HEX #353F45
    #declare FS_25045 = rgb <0.172549019607843, 0.247058823529412, 0.309803921568627>; // HEX #2C3F4F
    #declare FS_25051 = rgb <0.274509803921569, 0.305882352941176, 0.388235294117647>; // HEX #464E63
    #declare FS_25052 = rgb <0.0117647058823529, 0.149019607843137, 0.368627450980392>; // HEX #03265E
    #declare FS_25053 = rgb <0.203921568627451, 0.290196078431373, 0.396078431372549>; // HEX #344A65
    #declare FS_25056 = rgb <0.145098039215686, 0.203921568627451, 0.458823529411765>; // HEX #253475
    #declare FS_25102 = rgb <0.184313725490196, 0.384313725490196, 0.549019607843137>; // HEX #2F628C
    #declare FS_25109 = rgb <0.317647058823529, 0.447058823529412, 0.529411764705882>; // HEX #517287
    #declare FS_25177 = rgb <0.392156862745098, 0.490196078431373, 0.6>; // HEX #647D99
    #declare FS_25183 = rgb <0.168627450980392, 0.494117647058824, 0.694117647058824>; // HEX #2B7EB1
    #declare FS_25184 = rgb <0.32156862745098, 0.525490196078431, 0.615686274509804>; // HEX #52869D
    #declare FS_25189 = rgb <0.454901960784314, 0.541176470588235, 0.576470588235294>; // HEX #748A93
    #declare FS_25190 = rgb <0.392156862745098, 0.564705882352941, 0.654901960784314>; // HEX #6490A7
    #declare FS_25193 = rgb <0.364705882352941, 0.556862745098039, 0.588235294117647>; // HEX #5D8E96
    #declare FS_25237 = rgb <0.517647058823529, 0.564705882352941, 0.584313725490196>; // HEX #849095
    #declare FS_25240 = rgb <0.498039215686275, 0.6, 0.733333333333333>; // HEX #7F99BB
    #declare FS_25299 = rgb <0.47843137254902, 0.654901960784314, 0.631372549019608>; // HEX #7AA7A1
    #declare FS_25352_Blue = rgb <0.572549019607843, 0.654901960784314, 0.631372549019608>; // HEX #92A7A1
    #declare FS_25414 = rgb <0.596078431372549, 0.698039215686274, 0.690196078431373>; // HEX #98B2B0
    #declare FS_25466 = rgb <0.513725490196078, 0.76078431372549, 0.898039215686275>; // HEX #83C2E5
    #declare FS_25488 = rgb <0.635294117647059, 0.749019607843137, 0.850980392156863>; // HEX #A2BFD9
    #declare FS_25526 = rgb <0.717647058823529, 0.776470588235294, 0.803921568627451>; // HEX #B7C6CD
    #declare FS_25550_Light_Blue = rgb <0.819607843137255, 0.874509803921569, 0.901960784313726>; // HEX #D1DFE6
    #declare FS_25622 = rgb <0.831372549019608, 0.854901960784314, 0.823529411764706>; // HEX #D4DAD2
    #declare FS_25630 = rgb <0.866666666666667, 0.862745098039216, 0.83921568627451>; // HEX #DDDCD6
    #declare FS_26008_Dark_Gray = rgb <0.329411764705882, 0.341176470588235, 0.356862745098039>; // HEX #54575B
    #declare FS_26044_Gray = rgb <0.243137254901961, 0.266666666666667, 0.294117647058824>; // HEX #3E444B
    #declare FS_26081_Seaplane_Gray = rgb <0.345098039215686, 0.356862745098039, 0.356862745098039>; // HEX #585B5B
    #declare FS_26120 = rgb <0.376470588235294, 0.325490196078431, 0.290196078431373>; // HEX #60534A
    #declare FS_26122 = rgb <0.427450980392157, 0.415686274509804, 0.411764705882353>; // HEX #6D6A69
    #declare FS_26132 = rgb <0.435294117647059, 0.443137254901961, 0.447058823529412>; // HEX #6F7172
    #declare FS_26134 = rgb <0.454901960784314, 0.454901960784314, 0.435294117647059>; // HEX #74746F
    #declare FS_26152_Gray = rgb <0.447058823529412, 0.466666666666667, 0.474509803921569>; // HEX #727779
    #declare FS_26173 = rgb <0.498039215686275, 0.517647058823529, 0.545098039215686>; // HEX #7F848B
    #declare FS_26176 = rgb <0.462745098039216, 0.501960784313725, 0.541176470588235>; // HEX #76808A
    #declare FS_26187 = rgb <0.482352941176471, 0.509803921568627, 0.517647058823529>; // HEX #7B8284
    #declare FS_26231 = rgb <0.537254901960784, 0.552941176470588, 0.56078431372549>; // HEX #898D8F
    #declare FS_26250 = rgb <0.549019607843137, 0.572549019607843, 0.564705882352941>; // HEX #8C9290
    #declare FS_26251 = rgb <0.572549019607843, 0.576470588235294, 0.572549019607843>; // HEX #929392
    #declare FS_26270_Medium_Gray = rgb <0.568627450980392, 0.584313725490196, 0.592156862745098>; // HEX #919597
    #declare FS_26280 = rgb <0.588235294117647, 0.596078431372549, 0.588235294117647>; // HEX #969896
    #declare FS_26293 = rgb <0.6, 0.607843137254902, 0.611764705882353>; // HEX #999B9C
    #declare FS_26306 = rgb <0.643137254901961, 0.603921568627451, 0.56078431372549>; // HEX #A49A8F
    #declare FS_26307 = rgb <0.615686274509804, 0.615686274509804, 0.576470588235294>; // HEX #9D9D93
    #declare FS_26314 = rgb <0.603921568627451, 0.623529411764706, 0.611764705882353>; // HEX #9A9F9C
    #declare FS_26329 = rgb <0.596078431372549, 0.650980392156863, 0.654901960784314>; // HEX #98A6A7
    #declare FS_26357 = rgb <0.674509803921569, 0.658823529411765, 0.607843137254902>; // HEX #ACA89B
    #declare FS_26360 = rgb <0.709803921568627, 0.686274509803922, 0.607843137254902>; // HEX #B5AF9B
    #declare FS_26373 = rgb <0.674509803921569, 0.686274509803922, 0.690196078431373>; // HEX #ACAFB0
    #declare FS_26400 = rgb <0.831372549019608, 0.792156862745098, 0.690196078431373>; // HEX #D4CAB0
    #declare FS_26405 = rgb <0.764705882352941, 0.729411764705882, 0.647058823529412>; // HEX #C3BAA5
    #declare FS_26408 = rgb <0.764705882352941, 0.756862745098039, 0.705882352941177>; // HEX #C3C1B4
    #declare FS_26424 = rgb <0.780392156862745, 0.741176470588235, 0.698039215686274>; // HEX #C7BDB2
    #declare FS_26440_Light_Gull_Gray = rgb <0.725490196078431, 0.717647058823529, 0.694117647058824>; // HEX #B9B7B1
    #declare FS_26492 = rgb <0.772549019607843, 0.768627450980392, 0.745098039215686>; // HEX #C5C4BE
    #declare FS_26493 = rgb <0.756862745098039, 0.76078431372549, 0.756862745098039>; // HEX #C1C2C1
    #declare FS_26496 = rgb <0.733333333333333, 0.733333333333333, 0.686274509803922>; // HEX #BBBBAF
    #declare FS_26521 = rgb <0.811764705882353, 0.756862745098039, 0.698039215686274>; // HEX #CFC1B2
    #declare FS_26555 = rgb <0.835294117647059, 0.788235294117647, 0.674509803921569>; // HEX #D5C9AC
    #declare FS_26559 = rgb <0.8, 0.784313725490196, 0.725490196078431>; // HEX #CCC8B9
    #declare FS_26586 = rgb <0.835294117647059, 0.8, 0.698039215686274>; // HEX #D5CCB2
    #declare FS_26595 = rgb <0.796078431372549, 0.792156862745098, 0.741176470588235>; // HEX #CBCABD
    #declare FS_26622 = rgb <0.815686274509804, 0.8, 0.76078431372549>; // HEX #D0CCC2
    #declare FS_27038_Black = rgb <0.168627450980392, 0.176470588235294, 0.188235294117647>; // HEX #2B2D30
    #declare FS_27040 = rgb <0.192156862745098, 0.196078431372549, 0.207843137254902>; // HEX #313235
    #declare FS_27043 = rgb <0.623529411764706, 0.545098039215686, 0.317647058823529>; // HEX #9F8B51
    #declare FS_27142 = rgb <0.635294117647059, 0.356862745098039, 0.52156862745098>; // HEX #A25B85
    #declare FS_27144 = rgb <0.541176470588235, 0.415686274509804, 0.56078431372549>; // HEX #8A6A8F
    #declare FS_27722 = rgb <0.905882352941176, 0.882352941176471, 0.827450980392157>; // HEX #E7E1D3
    #declare FS_27769 = rgb <0, 0.862745098039216, 0.768627450980392>; // HEX #00DCC4
    #declare FS_27778 = rgb <0.941176470588235, 0.913725490196078, 0.827450980392157>; // HEX #F0E9D3
    #declare FS_27780_White = rgb <0.952941176470588, 0.925490196078431, 0.866666666666667>; // HEX #F3ECDD
    #declare FS_27855 = rgb <0.949019607843137, 0.901960784313726, 0.768627450980392>; // HEX #F2E6C4
    #declare FS_27875_Insignia_White = rgb <0.952941176470588, 0.949019607843137, 0.925490196078431>; // HEX #F3F2EC
    #declare FS_27880 = rgb <0.984313725490196, 0.96078431372549, 0.909803921568627>; // HEX #FBF5E8
    #declare FS_27886 = rgb <0.980392156862745, 0.952941176470588, 0.894117647058824>; // HEX #FAF3E4
    #declare FS_27925 = rgb <0.980392156862745, 0.968627450980392, 0.949019607843137>; // HEX #FAF7F2
    #declare FS_30040 = rgb <0.372549019607843, 0.333333333333333, 0.301960784313725>; // HEX #5F554D
    #declare FS_30045_Brown = rgb <0.396078431372549, 0.333333333333333, 0.317647058823529>; // HEX #655551
    #declare FS_30051_Leather_Brown = rgb <0.309803921568627, 0.258823529411765, 0.223529411764706>; // HEX #4F4239
    #declare FS_30076 = rgb <0.384313725490196, 0, 0>; // HEX #620000
    #declare FS_30097_Brown = rgb <0.415686274509804, 0.36078431372549, 0.309803921568627>; // HEX #6A5C4F
    #declare FS_30099_Brown = rgb <0.454901960784314, 0.384313725490196, 0.32156862745098>; // HEX #746252
    #declare FS_30108_Red_Brown = rgb <0.423529411764706, 0.329411764705882, 0.27843137254902>; // HEX #6C5447
    #declare FS_30109 = rgb <0.564705882352941, 0.352941176470588, 0.298039215686275>; // HEX #905A4C
    #declare FS_30111_Brown = rgb <0.490196078431373, 0.356862745098039, 0.32156862745098>; // HEX #7D5B52
    #declare FS_30117_Earth_Red = rgb <0.537254901960784, 0.403921568627451, 0.313725490196078>; // HEX #896750
    #declare FS_30118_Field_Drab = rgb <0.482352941176471, 0.411764705882353, 0.305882352941176>; // HEX #7B694E
    #declare FS_30129 = rgb <0.529411764705882, 0.435294117647059, 0.333333333333333>; // HEX #876F55
    #declare FS_30140_Brown_Special = rgb <0.533333333333333, 0.419607843137255, 0.345098039215686>; // HEX #886B58
    #declare FS_30145 = rgb <0.545098039215686, 0.447058823529412, 0.345098039215686>; // HEX #8B7258
    #declare FS_30152 = rgb <0.517647058823529, 0.2, 0.125490196078431>; // HEX #843320
    #declare FS_30160_Brown = rgb <0.529411764705882, 0.325490196078431, 0.352941176470588>; // HEX #87535A
    #declare FS_30166 = rgb <0.56078431372549, 0.36078431372549, 0.317647058823529>; // HEX #8F5C51
    #declare FS_30206 = rgb <0.623529411764706, 0.494117647058824, 0.466666666666667>; // HEX #9F7E77
    #declare FS_30215_Brown = rgb <0.619607843137255, 0.462745098039216, 0.333333333333333>; // HEX #9E7655
    #declare FS_30219_Tan = rgb <0.631372549019608, 0.513725490196078, 0.423529411764706>; // HEX #A1836C
    #declare FS_30227_Tan = rgb <0.63921568627451, 0.545098039215686, 0.47843137254902>; // HEX #A38B7A
    #declare FS_30233 = rgb <0.670588235294118, 0.494117647058824, 0.43921568627451>; // HEX #AB7E70
    #declare FS_30252 = rgb <0.733333333333333, 0.513725490196078, 0.411764705882353>; // HEX #BB8369
    #declare FS_30257_Tan = rgb <0.764705882352941, 0.607843137254902, 0.411764705882353>; // HEX #C39B69
    #declare FS_30266_Yellow_Sand = rgb <0.690196078431373, 0.576470588235294, 0.36078431372549>; // HEX #B0935C
    #declare FS_30277_Sand_Brown = rgb <0.650980392156863, 0.592156862745098, 0.490196078431373>; // HEX #A6977D
    #declare FS_30279_Sand = rgb <0.717647058823529, 0.615686274509804, 0.541176470588235>; // HEX #B79D8A
    #declare FS_30313 = rgb <0.717647058823529, 0.611764705882353, 0.545098039215686>; // HEX #B79C8B
    #declare FS_30315 = rgb <0.709803921568627, 0.611764705882353, 0.541176470588235>; // HEX #B59C8A
    #declare FS_30318 = rgb <0.698039215686274, 0.631372549019608, 0.525490196078431>; // HEX #B2A186
    #declare FS_30324 = rgb <0.717647058823529, 0.623529411764706, 0.545098039215686>; // HEX #B79F8B
    #declare FS_30372_Sand = rgb <0.713725490196078, 0.650980392156863, 0.564705882352941>; // HEX #B6A690
    #declare FS_30400_Yellow_Sand = rgb <0.76078431372549, 0.6, 0.388235294117647>; // HEX #C29963
    #declare FS_30450 = rgb <0.811764705882353, 0.705882352941177, 0.615686274509804>; // HEX #CFB49D
    #declare FS_31090_Brown = rgb <0.517647058823529, 0.388235294117647, 0.286274509803922>; // HEX #846349
    #declare FS_31136_Insignia_Red = rgb <0.658823529411765, 0.286274509803922, 0.274509803921569>; // HEX #A84946
    #declare FS_31158 = rgb <0.76078431372549, 0.341176470588235, 0.372549019607843>; // HEX #C2575F
    #declare FS_31302_Red = rgb <0.807843137254902, 0.294117647058824, 0.250980392156863>; // HEX #CE4B40
    #declare FS_31350_Red = rgb <0.729411764705882, 0.109803921568627, 0>; // HEX #BA1C00
    #declare FS_31400_Red = rgb <0.831372549019608, 0.345098039215686, 0.243137254901961>; // HEX #D4583E
    #declare FS_31433 = rgb <0.815686274509804, 0.631372549019608, 0.545098039215686>; // HEX #D0A18B
    #declare FS_31575 = rgb <0.905882352941176, 0.745098039215686, 0.654901960784314>; // HEX #E7BEA7
    #declare FS_31638 = rgb <0.949019607843137, 0.725490196078431, 0.725490196078431>; // HEX #F2B9B9
    #declare FS_31643 = rgb <0.929411764705882, 0.827450980392157, 0.729411764705882>; // HEX #EDD3BA
    #declare FS_31667 = rgb <0.949019607843137, 0.835294117647059, 0.705882352941177>; // HEX #F2D5B4
    #declare FS_31668 = rgb <0.929411764705882, 0.823529411764706, 0.788235294117647>; // HEX #EDD2C9
    #declare FS_31669 = rgb <0.964705882352941, 0.831372549019608, 0.819607843137255>; // HEX #F6D4D1
    #declare FS_31670 = rgb <0.952941176470588, 0.827450980392157, 0.741176470588235>; // HEX #F3D3BD
    #declare FS_32169 = rgb <0.713725490196078, 0.4, 0.266666666666667>; // HEX #B66644
    #declare FS_32246 = rgb <0.917647058823529, 0.447058823529412, 0.23921568627451>; // HEX #EA723D
    #declare FS_32276 = rgb <0.823529411764706, 0.505882352941176, 0.392156862745098>; // HEX #D28164
    #declare FS_32356 = rgb <0.870588235294118, 0.537254901960784, 0.443137254901961>; // HEX #DE8971
    #declare FS_32473_Orange = rgb <0.913725490196078, 0.525490196078431, 0.305882352941176>; // HEX #E9864E
    #declare FS_32516 = rgb <0.874509803921569, 0.635294117647059, 0.466666666666667>; // HEX #DFA277
    #declare FS_32544 = rgb <0.988235294117647, 0.650980392156863, 0.372549019607843>; // HEX #FCA65F
    #declare FS_32555 = rgb <0.992156862745098, 0.713725490196078, 0.4>; // HEX #FDB666
    #declare FS_32630 = rgb <0.917647058823529, 0.784313725490196, 0.658823529411765>; // HEX #EAC8A8
    #declare FS_32648_Sand = rgb <0.949019607843137, 0.807843137254902, 0.662745098039216>; // HEX #F2CEA9
    #declare FS_33070 = rgb <0.396078431372549, 0.376470588235294, 0.301960784313725>; // HEX #65604D
    #declare FS_33105_Brown = rgb <0.498039215686275, 0.423529411764706, 0.32156862745098>; // HEX #7F6C52
    #declare FS_33245_Tan = rgb <0.701960784313725, 0.549019607843137, 0.368627450980392>; // HEX #B38C5E
    #declare FS_33275 = rgb <0.662745098039216, 0.505882352941176, 0>; // HEX #A98100
    #declare FS_33303_Sand = rgb <0.690196078431373, 0.631372549019608, 0.513725490196078>; // HEX #B0A183
    #declare FS_33432 = rgb <0.898039215686275, 0.603921568627451, 0>; // HEX #E59A00
    #declare FS_33434_Ochre = rgb <0.850980392156863, 0.662745098039216, 0.352941176470588>; // HEX #D9A95A
    #declare FS_33440_Tan = rgb <0.654901960784314, 0.564705882352941, 0.396078431372549>; // HEX #A79065
    #declare FS_33446_Dessert_Tan = rgb <0.694117647058824, 0.623529411764706, 0.482352941176471>; // HEX #B19F7B
    #declare FS_33448_Dark_Yellow = rgb <0.764705882352941, 0.674509803921569, 0.517647058823529>; // HEX #C3AC84
    #declare FS_33481 = rgb <0.835294117647059, 0.729411764705882, 0.341176470588235>; // HEX #D5BA57
    #declare FS_33522 = rgb <0.827450980392157, 0.756862745098039, 0.63921568627451>; // HEX #D3C1A3
    #declare FS_33531_Middlestone = rgb <0.83921568627451, 0.756862745098039, 0.666666666666667>; // HEX #D6C1AA
    #declare FS_33538_Orange_Yellow = rgb <1, 0.717647058823529, 0>; // HEX #FFB700
    #declare FS_33564 = rgb <0.866666666666667, 0.803921568627451, 0.631372549019608>; // HEX #DDCDA1
    #declare FS_33578 = rgb <0.862745098039216, 0.8, 0.666666666666667>; // HEX #DCCCAA
    #declare FS_33591 = rgb <0.909803921568627, 0.827450980392157, 0>; // HEX #E8D300
    #declare FS_33613_Radome_Tan = rgb <0.937254901960784, 0.815686274509804, 0.658823529411765>; // HEX #EFD0A8
    #declare FS_33617_Sand = rgb <0.890196078431372, 0.819607843137255, 0.725490196078431>; // HEX #E3D1B9
    #declare FS_33637 = rgb <0.937254901960784, 0.76078431372549, 0.349019607843137>; // HEX #EFC259
    #declare FS_33655 = rgb <1, 0.792156862745098, 0>; // HEX #FFCA00
    #declare FS_33685 = rgb <0.917647058823529, 0.882352941176471, 0.662745098039216>; // HEX #EAE1A9
    #declare FS_33690_Sand = rgb <0.937254901960784, 0.858823529411765, 0.713725490196078>; // HEX #EFDBB6
    #declare FS_33695_Yellow_Sand = rgb <0.992156862745098, 0.725490196078431, 0.572549019607843>; // HEX #FDB992
    #declare FS_33696 = rgb <1, 0.847058823529412, 0.447058823529412>; // HEX #FFD872
    #declare FS_33711_Sand = rgb <0.941176470588235, 0.847058823529412, 0.690196078431373>; // HEX #F0D8B0
    #declare FS_33717_Sand = rgb <0.937254901960784, 0.862745098039216, 0.733333333333333>; // HEX #EFDCBB
    #declare FS_33722 = rgb <0.929411764705882, 0.854901960784314, 0.694117647058824>; // HEX #EDDAB1
    #declare FS_33727 = rgb <0.949019607843137, 0.87843137254902, 0.686274509803922>; // HEX #F2E0AF
    #declare FS_33793 = rgb <0.976470588235294, 0.929411764705882, 0.568627450980392>; // HEX #F9ED91
    #declare FS_33798 = rgb <0.980392156862745, 0.901960784313726, 0.654901960784314>; // HEX #FAE6A7
    #declare FS_33814 = rgb <0.913725490196078, 0.917647058823529, 0.643137254901961>; // HEX #E9EAA4
    #declare FS_34031_Dark_Green = rgb <0.341176470588235, 0.329411764705882, 0.313725490196078>; // HEX #575450
    #declare FS_34052_USMC_Green = rgb <0.333333333333333, 0.337254901960784, 0.309803921568627>; // HEX #55564F
    #declare FS_34056 = rgb <0.137254901960784, 0.176470588235294, 0.141176470588235>; // HEX #232D24
    #declare FS_34058_Sea_Blue = rgb <0.23921568627451, 0.368627450980392, 0.364705882352941>; // HEX #3D5E5D
    #declare FS_34062 = rgb <0, 0.250980392156863, 0.117647058823529>; // HEX #00401E
    #declare FS_34064_Dark_Green = rgb <0.368627450980392, 0.36078431372549, 0.337254901960784>; // HEX #5E5C56
    #declare FS_34077_Green = rgb <0.180392156862745, 0.223529411764706, 0.2>; // HEX #2E3933
    #declare FS_34079_Forest_Green = rgb <0.349019607843137, 0.36078431372549, 0.305882352941176>; // HEX #595C4E
    #declare FS_34082_Green = rgb <0.376470588235294, 0.392156862745098, 0.298039215686275>; // HEX #60644C
    #declare FS_34083_Green = rgb <0.364705882352941, 0.364705882352941, 0.313725490196078>; // HEX #5D5D50
    #declare FS_34084_Green = rgb <0.337254901960784, 0.32156862745098, 0.282352941176471>; // HEX #565248
    #declare FS_34086_I_R_Dark_Green = rgb <0.380392156862745, 0.372549019607843, 0.337254901960784>; // HEX #615F56
    #declare FS_34087_Olive_Drab = rgb <0.333333333333333, 0.309803921568627, 0.266666666666667>; // HEX #554F44
    #declare FS_34088_Olive_Drab = rgb <0.333333333333333, 0.309803921568627, 0.266666666666667>; // HEX #554F44
    #declare FS_34089 = rgb <0.435294117647059, 0.435294117647059, 0.290196078431373>; // HEX #6F6F4A
    #declare FS_34090 = rgb <0.137254901960784, 0.509803921568627, 0.349019607843137>; // HEX #238259
    #declare FS_34092_Dark_Green = rgb <0.325490196078431, 0.392156862745098, 0.352941176470588>; // HEX #53645A
    #declare FS_34094_Green = rgb <0.243137254901961, 0.294117647058824, 0.223529411764706>; // HEX #3E4B39
    #declare FS_34095_Field_Green = rgb <0.349019607843137, 0.372549019607843, 0.262745098039216>; // HEX #595F43
    #declare FS_34096_Dark_Green = rgb <0.380392156862745, 0.388235294117647, 0.32156862745098>; // HEX #616352
    #declare FS_34097_Field_Green = rgb <0.388235294117647, 0.415686274509804, 0.317647058823529>; // HEX #636A51
    #declare FS_34098_Green = rgb <0.435294117647059, 0.423529411764706, 0.298039215686275>; // HEX #6F6C4C
    #declare FS_34102_Light_Green = rgb <0.388235294117647, 0.403921568627451, 0.313725490196078>; // HEX #636750
    #declare FS_34108_Medium_Green = rgb <0.27843137254902, 0.431372549019608, 0.337254901960784>; // HEX #476E56
    #declare FS_34115 = rgb <0, 0.364705882352941, 0.223529411764706>; // HEX #005D39
    #declare FS_34127_Green = rgb <0.435294117647059, 0.427450980392157, 0.294117647058824>; // HEX #6F6D4B
    #declare FS_34128_Deep_Green = rgb <0.396078431372549, 0.450980392156863, 0.368627450980392>; // HEX #65735E
    #declare FS_34130 = rgb <0.411764705882353, 0.403921568627451, 0.282352941176471>; // HEX #696748
    #declare FS_34138_Green = rgb <0.368627450980392, 0.517647058823529, 0.313725490196078>; // HEX #5E8450
    #declare FS_34148 = rgb <0.396078431372549, 0.47843137254902, 0.466666666666667>; // HEX #657A77
    #declare FS_34151_Interior_Green = rgb <0.443137254901961, 0.43921568627451, 0.282352941176471>; // HEX #717048
    #declare FS_34158 = rgb <0.423529411764706, 0.474509803921569, 0.466666666666667>; // HEX #6C7977
    #declare FS_34159_Green = rgb <0.450980392156863, 0.47843137254902, 0.423529411764706>; // HEX #737A6C
    #declare FS_34172 = rgb <0.333333333333333, 0.435294117647059, 0.337254901960784>; // HEX #556F56
    #declare FS_34201_Tan_Green = rgb <0.549019607843137, 0.517647058823529, 0.415686274509804>; // HEX #8C846A
    #declare FS_34226 = rgb <0.517647058823529, 0.556862745098039, 0.490196078431373>; // HEX #848E7D
    #declare FS_34227_Medium_Gray_Green = rgb <0.498039215686275, 0.568627450980392, 0.43921568627451>; // HEX #7F9170
    #declare FS_34230_Green = rgb <0.349019607843137, 0.615686274509804, 0.352941176470588>; // HEX #599D5A
    #declare FS_34233 = rgb <0.509803921568627, 0.592156862745098, 0.584313725490196>; // HEX #829795
    #declare FS_34241 = rgb <0.505882352941176, 0.650980392156863, 0.596078431372549>; // HEX #81A698
    #declare FS_34258_Green = rgb <0.564705882352941, 0.580392156862745, 0.407843137254902>; // HEX #909468
    #declare FS_34259_Yellow_Green = rgb <0.556862745098039, 0.513725490196078, 0.258823529411765>; // HEX #8E8342
    #declare FS_34272 = rgb <0.466666666666667, 0.615686274509804, 0.501960784313725>; // HEX #779D80
    #declare FS_34277 = rgb <0.533333333333333, 0.615686274509804, 0.584313725490196>; // HEX #889D95
    #declare FS_34300 = rgb <0.545098039215686, 0.63921568627451, 0.584313725490196>; // HEX #8BA395
    #declare FS_34325 = rgb <0.501960784313725, 0.662745098039216, 0.596078431372549>; // HEX #80A998
    #declare FS_34373 = rgb <0.627450980392157, 0.705882352941177, 0.647058823529412>; // HEX #A0B4A5
    #declare FS_34410 = rgb <0.635294117647059, 0.705882352941177, 0.647058823529412>; // HEX #A2B4A5
    #declare FS_34414_Green = rgb <0.72156862745098, 0.768627450980392, 0.67843137254902>; // HEX #B8C4AD
    #declare FS_34424_Light_Gray_Green = rgb <0.701960784313725, 0.713725490196078, 0.623529411764706>; // HEX #B3B69F
    #declare FS_34432 = rgb <0.694117647058824, 0.717647058823529, 0.643137254901961>; // HEX #B1B7A4
    #declare FS_34441 = rgb <0.686274509803922, 0.733333333333333, 0.623529411764706>; // HEX #AFBB9F
    #declare FS_34449 = rgb <0.654901960784314, 0.741176470588235, 0.607843137254902>; // HEX #A7BD9B
    #declare FS_34491 = rgb <0.694117647058824, 0.768627450980392, 0.682352941176471>; // HEX #B1C4AE
    #declare FS_34504 = rgb <0.713725490196078, 0.768627450980392, 0.670588235294118>; // HEX #B6C4AB
    #declare FS_34516 = rgb <0.713725490196078, 0.776470588235294, 0.705882352941177>; // HEX #B6C6B4
    #declare FS_34518 = rgb <0.698039215686274, 0.76078431372549, 0.701960784313725>; // HEX #B2C2B3
    #declare FS_34524 = rgb <0.733333333333333, 0.776470588235294, 0.611764705882353>; // HEX #BBC69C
    #declare FS_34533 = rgb <0.709803921568627, 0.768627450980392, 0.619607843137255>; // HEX #B5C49E
    #declare FS_34540 = rgb <0.631372549019608, 0.823529411764706, 0.545098039215686>; // HEX #A1D28B
    #declare FS_34552_Light_Green = rgb <0.831372549019608, 0.811764705882353, 0.564705882352941>; // HEX #D4CF90
    #declare FS_34554_Sky = rgb <0.823529411764706, 0.835294117647059, 0.725490196078431>; // HEX #D2D5B9
    #declare FS_34558 = rgb <0.752941176470588, 0.815686274509804, 0.690196078431373>; // HEX #C0D0B0
    #declare FS_34583 = rgb <0.76078431372549, 0.764705882352941, 0.643137254901961>; // HEX #C2C3A4
    #declare FS_34666_Green = rgb <0.858823529411765, 0.905882352941176, 0.670588235294118>; // HEX #DBE7AB
    #declare FS_34670 = rgb <0.815686274509804, 0.854901960784314, 0.788235294117647>; // HEX #D0DAC9
    #declare FS_34672 = rgb <0.835294117647059, 0.858823529411765, 0.749019607843137>; // HEX #D5DBBF
    #declare FS_35042_Sea_Blue = rgb <0.270588235294118, 0.290196078431373, 0.305882352941176>; // HEX #454A4E
    #declare FS_35044_Insignia_Blue = rgb <0.266666666666667, 0.282352941176471, 0.329411764705882>; // HEX #444854
    #declare FS_35045_Dark_Blue = rgb <0.254901960784314, 0.313725490196078, 0.364705882352941>; // HEX #41505D
    #declare FS_35050 = rgb <0.0941176470588235, 0.196078431372549, 0.301960784313725>; // HEX #18324D
    #declare FS_35052_Blue = rgb <0, 0.156862745098039, 0.36078431372549>; // HEX #00285C
    #declare FS_35053 = rgb <0.149019607843137, 0.231372549019608, 0.337254901960784>; // HEX #263B56
    #declare FS_35056 = rgb <0.2, 0.274509803921569, 0.52156862745098>; // HEX #334685
    #declare FS_35109_Dark_Blue = rgb <0.270588235294118, 0.447058823529412, 0.52156862745098>; // HEX #457285
    #declare FS_35115 = rgb <0.0117647058823529, 0.36078431372549, 0.235294117647059>; // HEX #035C3C
    #declare FS_35164_Intermediate_Blue = rgb <0.435294117647059, 0.486274509803922, 0.541176470588235>; // HEX #6F7C8A
    #declare FS_35177_Medium_Blue = rgb <0.396078431372549, 0.509803921568627, 0.603921568627451>; // HEX #65829A
    #declare FS_35180 = rgb <0.0745098039215686, 0.47843137254902, 0.733333333333333>; // HEX #137ABB
    #declare FS_35182 = rgb <0.164705882352941, 0.427450980392157, 0.635294117647059>; // HEX #2A6DA2
    #declare FS_35183 = rgb <0.133333333333333, 0.501960784313725, 0.698039215686274>; // HEX #2280B2
    #declare FS_35189_Blue_Gray = rgb <0.435294117647059, 0.541176470588235, 0.568627450980392>; // HEX #6F8A91
    #declare FS_35190_Dark_Blue = rgb <0.388235294117647, 0.564705882352941, 0.662745098039216>; // HEX #6390A9
    #declare FS_35193 = rgb <0.349019607843137, 0.56078431372549, 0.596078431372549>; // HEX #598F98
    #declare FS_35231_Azure_Blue = rgb <0.490196078431373, 0.568627450980392, 0.725490196078431>; // HEX #7D91B9
    #declare FS_35237_Gray_Blue = rgb <0.529411764705882, 0.572549019607843, 0.592156862745098>; // HEX #879297
    #declare FS_35240_Blue = rgb <0.498039215686275, 0.611764705882353, 0.749019607843137>; // HEX #7F9CBF
    #declare FS_35250_Blue = rgb <0.356862745098039, 0.650980392156863, 0.83921568627451>; // HEX #5BA6D6
    #declare FS_35275 = rgb <0.207843137254902, 0.643137254901961, 0.619607843137255>; // HEX #35A49E
    #declare FS_35299 = rgb <0.466666666666667, 0.647058823529412, 0.619607843137255>; // HEX #77A59E
    #declare FS_35352_Blue = rgb <0.580392156862745, 0.658823529411765, 0.643137254901961>; // HEX #94A8A4
    #declare FS_35414_Blue = rgb <0.615686274509804, 0.701960784313725, 0.682352941176471>; // HEX #9DB3AE
    #declare FS_35450_Air_Superiority_Blue = rgb <0.572549019607843, 0.713725490196078, 0.819607843137255>; // HEX #92B6D1
    #declare FS_35466 = rgb <0.525490196078431, 0.796078431372549, 0.894117647058824>; // HEX #86CBE4
    #declare FS_35488 = rgb <0.631372549019608, 0.733333333333333, 0.819607843137255>; // HEX #A1BBD1
    #declare FS_35526_Light_Sky_Blue = rgb <0.713725490196078, 0.768627450980392, 0.8>; // HEX #B6C4CC
    #declare FS_35550 = rgb <0.807843137254902, 0.858823529411765, 0.886274509803922>; // HEX #CEDBE2
    #declare FS_35622_Light_Blue = rgb <0.803921568627451, 0.847058823529412, 0.803921568627451>; // HEX #CDD8CD
    #declare FS_35630 = rgb <0.858823529411765, 0.858823529411765, 0.835294117647059>; // HEX #DBDBD5
    #declare FS_36076_Gray = rgb <0.341176470588235, 0.356862745098039, 0.384313725490196>; // HEX #575B62
    #declare FS_36081_Dark_Gunship_Gray = rgb <0.356862745098039, 0.368627450980392, 0.372549019607843>; // HEX #5B5E5F
    #declare FS_36099_Dark_Gray = rgb <0.372549019607843, 0.396078431372549, 0.415686274509804>; // HEX #5F656A
    #declare FS_36118_Medium_Gunship_Gray = rgb <0.403921568627451, 0.423529411764706, 0.450980392156863>; // HEX #676C73
    #declare FS_36134 = rgb <0.337254901960784, 0.337254901960784, 0.329411764705882>; // HEX #565654
    #declare FS_36152_Gray = rgb <0.454901960784314, 0.474509803921569, 0.482352941176471>; // HEX #74797B
    #declare FS_36173_Neutral_Gray = rgb <0.498039215686275, 0.517647058823529, 0.541176470588235>; // HEX #7F848A
    #declare FS_36176_Dark_Gull_Gray = rgb <0.466666666666667, 0.501960784313725, 0.537254901960784>; // HEX #778089
    #declare FS_36187 = rgb <0.411764705882353, 0.450980392156863, 0.454901960784314>; // HEX #697374
    #declare FS_36231_Dark_Gull_Gray = rgb <0.533333333333333, 0.545098039215686, 0.552941176470588>; // HEX #888B8D
    #declare FS_36251_Gray = rgb <0.556862745098039, 0.564705882352941, 0.56078431372549>; // HEX #8E908F
    #declare FS_36270_Medium_Gray = rgb <0.56078431372549, 0.576470588235294, 0.588235294117647>; // HEX #8F9396
    #declare FS_36280_Dark_Gray = rgb <0.56078431372549, 0.576470588235294, 0.588235294117647>; // HEX #8F9396
    #declare FS_36293 = rgb <0.596078431372549, 0.603921568627451, 0.607843137254902>; // HEX #989A9B
    #declare FS_36300_Aircraft_Exterior_Gray = rgb <0.615686274509804, 0.635294117647059, 0.658823529411765>; // HEX #9DA2A8
    #declare FS_36306 = rgb <0.662745098039216, 0.619607843137255, 0.576470588235294>; // HEX #A99E93
    #declare FS_36307_Gray = rgb <0.623529411764706, 0.627450980392157, 0.592156862745098>; // HEX #9FA097
    #declare FS_36314_Flint_Gray = rgb <0.607843137254902, 0.623529411764706, 0.607843137254902>; // HEX #9B9F9B
    #declare FS_36320_Dark_Compass_Ghost_Gray = rgb <0.596078431372549, 0.631372549019608, 0.662745098039216>; // HEX #98A1A9
    #declare FS_36329_Light_Gray = rgb <0.517647058823529, 0.596078431372549, 0.6>; // HEX #849899
    #declare FS_36357 = rgb <0.674509803921569, 0.662745098039216, 0.611764705882353>; // HEX #ACA99C
    #declare FS_36373_Light_Gray = rgb <0.682352941176471, 0.694117647058824, 0.698039215686274>; // HEX #AEB1B2
    #declare FS_36375_Light_Compass_Ghost_Gray = rgb <0.650980392156863, 0.67843137254902, 0.705882352941177>; // HEX #A6ADB4
    #declare FS_36400 = rgb <0.764705882352941, 0.756862745098039, 0.607843137254902>; // HEX #C3C19B
    #declare FS_36405 = rgb <0.776470588235294, 0.745098039215686, 0.658823529411765>; // HEX #C6BEA8
    #declare FS_36415 = rgb <0.776470588235294, 0.713725490196078, 0.611764705882353>; // HEX #C6B69C
    #declare FS_36424_Medium_Gray = rgb <0.768627450980392, 0.729411764705882, 0.686274509803922>; // HEX #C4BAAF
    #declare FS_36440_Light_Gull_Gray = rgb <0.713725490196078, 0.709803921568627, 0.690196078431373>; // HEX #B6B5B0
    #declare FS_36463_Gray = rgb <0.694117647058824, 0.701960784313725, 0.698039215686274>; // HEX #B1B3B2
    #declare FS_36473_Sky_Gray = rgb <0.67843137254902, 0.709803921568627, 0.701960784313725>; // HEX #ADB5B3
    #declare FS_36492_Gray = rgb <0.76078431372549, 0.752941176470588, 0.749019607843137>; // HEX #C2C0BF
    #declare FS_36495_Light_Gray = rgb <0.811764705882353, 0.819607843137255, 0.823529411764706>; // HEX #CFD1D2
    #declare FS_36521_Tan = rgb <0.823529411764706, 0.772549019607843, 0.705882352941177>; // HEX #D2C5B4
    #declare FS_36555_Tan = rgb <0.831372549019608, 0.776470588235294, 0.658823529411765>; // HEX #D4C6A8
    #declare FS_36559_Gray = rgb <0.788235294117647, 0.768627450980392, 0.701960784313725>; // HEX #C9C4B3
    #declare FS_36586 = rgb <0.827450980392157, 0.8, 0.717647058823529>; // HEX #D3CCB7
    #declare FS_36595 = rgb <0.803921568627451, 0.792156862745098, 0.745098039215686>; // HEX #CDCABE
    #declare FS_36622_Gray = rgb <0.831372549019608, 0.815686274509804, 0.780392156862745>; // HEX #D4D0C7
    #declare FS_36628_Flat_Aluminum = rgb <0.847058823529412, 0.847058823529412, 0.831372549019608>; // HEX #D8D8D4
    #declare FS_36642 = rgb <0.913725490196078, 0.843137254901961, 0.764705882352941>; // HEX #E9D7C3
    #declare FS_37030 = rgb <0.270588235294118, 0.266666666666667, 0.270588235294118>; // HEX #454445
    #declare FS_37031_Black_Gray = rgb <0.262745098039216, 0.258823529411765, 0.266666666666667>; // HEX #434244
    #declare FS_37038_Black = rgb <0.258823529411765, 0.258823529411765, 0.262745098039216>; // HEX #424243
    #declare FS_37043 = rgb <0.501960784313725, 0.458823529411765, 0.215686274509804>; // HEX #807537
    #declare FS_37056 = rgb <0.337254901960784, 0.305882352941176, 0.290196078431373>; // HEX #564E4A
    #declare FS_37100_Purple = rgb <0.474509803921569, 0.325490196078431, 0.498039215686275>; // HEX #79537F
    #declare FS_37142 = rgb <0.623529411764706, 0.364705882352941, 0.529411764705882>; // HEX #9F5D87
    #declare FS_37144 = rgb <0.545098039215686, 0.423529411764706, 0.56078431372549>; // HEX #8B6C8F
    #declare FS_37150 = rgb <0.870588235294118, 0.827450980392157, 0.768627450980392>; // HEX #DED3C4
    #declare FS_37178 = rgb <0.529411764705882, 0.572549019607843, 0.588235294117647>; // HEX #879296
    #declare FS_37200 = rgb <0.627450980392157, 0.623529411764706, 0.623529411764706>; // HEX #A09F9F
    #declare FS_37722 = rgb <0.92156862745098, 0.890196078431372, 0.831372549019608>; // HEX #EBE3D4
    #declare FS_37769 = rgb <0.886274509803922, 0.83921568627451, 0.752941176470588>; // HEX #E2D6C0
    #declare FS_37778 = rgb <0.945098039215686, 0.905882352941176, 0.811764705882353>; // HEX #F1E7CF
    #declare FS_37855_White = rgb <0.964705882352941, 0.92156862745098, 0.784313725490196>; // HEX #F6EBC8
    #declare FS_37875_Insignia_White = rgb <0.949019607843137, 0.945098039215686, 0.917647058823529>; // HEX #F2F1EA
    #declare FS_37886 = rgb <0.972549019607843, 0.945098039215686, 0.882352941176471>; // HEX #F8F1E1
    #declare FS_37925_Insignia_White = rgb <0.984313725490196, 0.972549019607843, 0.964705882352941>; // HEX #FBF8F6
    #declare FS_38903 = rgb <1, 0.333333333333333, 0>; // HEX #FF5500
    #declare FS_38913 = rgb <1, 0.176470588235294, 0>; // HEX #FF2D00


    #version farger_ams595_Inc_Temp;
#end
