// This work is licensed under the Attribution-ShareAlike 4.0 International.
//
//    Persistence of Vision Ray Tracer Include File
//
//    File           : farger_f.inc
//    Version        : 3.0
//    Created by     : Sven-Erik Andersen
//    Contact        : sven.erik.andersen@gmail.com
//    Created date   : 2014-06-22
//    Last updated   : 2019-10-26
//    Description    : Farger means colors in Norwegian.
//                     
//

#ifndef(farger_f_Inc_Temp)
    #declare farger_f_Inc_Temp = version;
    #version 3.7;

    // Where the color definition is the same as in the POV-Ray color.inc include file,
    // the color name will point to the POV-Ray color definition,
    // so we need to make sure that file is included
    #ifndef(Colors_Inc_Temp)
        #include "colors.inc"
    #end

    #ifdef(View_POV_Include_Stack)
        #debug "including farger_f.inc\n"
    #end

    // farge colors
    #declare farge_Acajou = rgb <0.298039215686275, 0.184313725490196, 0.152941176470588>; // HEX #4C2F27
    #declare farge_Acid_Green = rgb <0.690196078431373, 0.749019607843137, 0.101960784313725>; // HEX #B0BF1A
    #declare farge_Aero = rgb <0.486274509803922, 0.725490196078431, 0.909803921568627>; // HEX #7CB9E8
    #declare farge_Aero_Blue = rgb <0.788235294117647, 1, 0.898039215686275>; // HEX #C9FFE5
    #declare farge_African_Violet = rgb <0.698039215686274, 0.517647058823529, 0.745098039215686>; // HEX #B284BE
    #declare farge_Air_Force_Academy_Blue_USAFA = rgb <0, 0.309803921568627, 0.596078431372549>; // HEX #004F98
    #declare farge_Air_Force_Blue_RAF = rgb <0.364705882352941, 0.541176470588235, 0.658823529411765>; // HEX #5D8AA8
    #declare farge_Air_Force_Blue_USAF = rgb <0, 0.188235294117647, 0.56078431372549>; // HEX #00308F
    #declare farge_Air_Superiority_Blue = rgb <0.447058823529412, 0.627450980392157, 0.756862745098039>; // HEX #72A0C1
    #declare farge_Alabama_Crimson = rgb <0.686274509803922, 0, 0.164705882352941>; // HEX #AF002A
    #declare farge_Alabaster = rgb <0.929411764705882, 0.917647058823529, 0.87843137254902>; // HEX #EDEAE0
    #declare farge_Alice_Blue = rgb <0.941176470588235, 0.972549019607843, 1>; // HEX #F0F8FF
    #declare farge_Alizarin_Crimson = rgb <0.886274509803922, 0.149019607843137, 0.211764705882353>; // HEX #E22636
    #declare farge_Almond = rgb <0.937254901960784, 0.870588235294118, 0.803921568627451>; // HEX #EFDECD
    #declare farge_Aloeswood_brown_Tonocha = rgb <0.352941176470588, 0.392156862745098, 0.341176470588235>; // HEX #5A6457
    #declare farge_Aloewood_color_Kyara_iro = rgb <0.415686274509804, 0.262745098039216, 0.176470588235294>; // HEX #6A432D
    #declare farge_Aluminum = rgb <0.83921568627451, 0.83921568627451, 0.83921568627451>; // HEX #D6D6D6
    #declare farge_Aluminum_foil = rgb <0.823529411764706, 0.850980392156863, 0.858823529411765>; // HEX #D2D9DB
    #declare farge_Amaranth = rgb <0.898039215686275, 0.168627450980392, 0.313725490196078>; // HEX #E52B50
    #declare farge_Amaranth_M_n_P = rgb <0.623529411764706, 0.168627450980392, 0.407843137254902>; // HEX #9F2B68
    #declare farge_Amaranth_Pink = rgb <0.945098039215686, 0.611764705882353, 0.733333333333333>; // HEX #F19CBB
    #declare farge_Amaranth_Purple = rgb <0.670588235294118, 0.152941176470588, 0.309803921568627>; // HEX #AB274F
    #declare farge_Amaranth_Red = rgb <0.827450980392157, 0.129411764705882, 0.176470588235294>; // HEX #D3212D
    #declare farge_Amazon = rgb <0.231372549019608, 0.47843137254902, 0.341176470588235>; // HEX #3B7A57
    #declare farge_Amber = rgb <1, 0.749019607843137, 0>; // HEX #FFBF00
    #declare farge_Amber_Kohaku_iro = rgb <0.792156862745098, 0.411764705882353, 0.141176470588235>; // HEX #CA6924
    #declare farge_Amber_SAE_ECE = rgb <1, 0.494117647058824, 0>; // HEX #FF7E00
    #declare farge_American_blue = rgb <0.231372549019608, 0.231372549019608, 0.427450980392157>; // HEX #3B3B6D
    #declare farge_American_bronze = rgb <0.223529411764706, 0.0941176470588235, 0.00784313725490196>; // HEX #391802
    #declare farge_American_brown = rgb <0.501960784313725, 0.250980392156863, 0.250980392156863>; // HEX #804040
    #declare farge_American_green = rgb <0.203921568627451, 0.701960784313725, 0.203921568627451>; // HEX #34B334
    #declare farge_American_orange = rgb <1, 0.545098039215686, 0>; // HEX #FF8B00
    #declare farge_American_pink = rgb <1, 0.596078431372549, 0.6>; // HEX #FF9899
    #declare farge_American_purple = rgb <0.262745098039216, 0.109803921568627, 0.325490196078431>; // HEX #431C53
    #declare farge_American_red = rgb <0.701960784313725, 0.129411764705882, 0.203921568627451>; // HEX #B32134
    #declare farge_American_Rose = rgb <1, 0.0117647058823529, 0.243137254901961>; // HEX #FF033E
    #declare farge_American_silver = rgb <0.811764705882353, 0.811764705882353, 0.811764705882353>; // HEX #CFCFCF
    #declare farge_American_violet = rgb <0.333333333333333, 0.105882352941176, 0.549019607843137>; // HEX #551B8C
    #declare farge_American_yellow = rgb <0.949019607843137, 0.705882352941177, 0>; // HEX #F2B400
    #declare farge_Amethyst = rgb <0.6, 0.4, 0.8>; // HEX #9966CC
    #declare farge_Amur_cork_tree_Kihada = rgb <0.952941176470588, 0.756862745098039, 0.227450980392157>; // HEX #F3C13A
    #declare farge_Android_Green = rgb <0.643137254901961, 0.776470588235294, 0.223529411764706>; // HEX #A4C639
    #declare farge_Anti_Flash_White = rgb <0.949019607843137, 0.952941176470588, 0.956862745098039>; // HEX #F2F3F4
    #declare farge_Antique_Brass = rgb <0.803921568627451, 0.584313725490196, 0.458823529411765>; // HEX #CD9575
    #declare farge_Antique_Bronze = rgb <0.4, 0.364705882352941, 0.117647058823529>; // HEX #665D1E
    #declare farge_Antique_Fuchsia = rgb <0.568627450980392, 0.36078431372549, 0.513725490196078>; // HEX #915C83
    #declare farge_Antique_Ruby = rgb <0.517647058823529, 0.105882352941176, 0.176470588235294>; // HEX #841B2D
    #declare farge_Antique_White = rgb <0.980392156862745, 0.92156862745098, 0.843137254901961>; // HEX #FAEBD7
    #declare farge_AO_English = rgb <0, 0.501960784313725, 0>; // HEX #008000
    #declare farge_Apple = rgb <0.4, 0.705882352941177, 0.27843137254902>; // HEX #66B447
    #declare farge_Apple_Green = rgb <0.552941176470588, 0.713725490196078, 0>; // HEX #8DB600
    #declare farge_Apricot = rgb <0.984313725490196, 0.807843137254902, 0.694117647058824>; // HEX #FBCEB1
    #declare farge_Aqua_Blue_color_Mizu_iro = rgb <0.525490196078431, 0.670588235294118, 0.647058823529412>; // HEX #86ABA5
    #declare farge_Aquamarine = rgb <0.498039215686275, 1, 0.831372549019608>; // HEX #7FFFD4
    #declare farge_Arctic_Lime = rgb <0.815686274509804, 1, 0.0784313725490196>; // HEX #D0FF14
    #declare farge_Argentinian_Blue = rgb <0.423529411764706, 0.705882352941177, 0.933333333333333>; // HEX #6CB4EE
    #declare farge_Army_Green = rgb <0.294117647058824, 0.325490196078431, 0.125490196078431>; // HEX #4B5320
    #declare farge_Arsenic = rgb <0.227450980392157, 0.266666666666667, 0.290196078431373>; // HEX #3A444A
    #declare farge_Artichoke = rgb <0.56078431372549, 0.592156862745098, 0.474509803921569>; // HEX #8F9779
    #declare farge_Arylide_Yellow = rgb <0.913725490196078, 0.83921568627451, 0.419607843137255>; // HEX #E9D66B
    #declare farge_Asda_Green = rgb <0.490196078431373, 0.76078431372549, 0.258823529411765>; // HEX #7DC242
    #declare farge_Asda_Green_1985 = rgb <0, 0.870588235294118, 0.643137254901961>; // HEX #00DEA4
    #declare farge_Asda_Green_1994 = rgb <0.501960784313725, 0.756862745098039, 0.592156862745098>; // HEX #80C197
    #declare farge_Asda_Green_1999 = rgb <0.4, 0.788235294117647, 0.572549019607843>; // HEX #66C992
    #declare farge_Asda_Green_2002 = rgb <0.196078431372549, 0.67843137254902, 0.380392156862745>; // HEX #32AD61
    #declare farge_Asda_Orange = rgb <0.784313725490196, 0.396078431372549, 0>; // HEX #C86500
    #declare farge_Asda_Orange_1968 = rgb <0.792156862745098, 0.450980392156863, 0.0352941176470588>; // HEX #CA7309
    #declare farge_Ash_Gray = rgb <0.698039215686274, 0.745098039215686, 0.709803921568627>; // HEX #B2BEB5
    #declare farge_Asparagus = rgb <0.529411764705882, 0.662745098039216, 0.419607843137255>; // HEX #87A96B
    #declare farge_Ateneo_blue = rgb <0, 0.227450980392157, 0.423529411764706>; // HEX #003A6C
    #declare farge_Aureolin = rgb <0.992156862745098, 0.933333333333333, 0>; // HEX #FDEE00
    #declare farge_AuroMetalSaurus = rgb <0.431372549019608, 0.498039215686275, 0.501960784313725>; // HEX #6E7F80
    #declare farge_Avocado = rgb <0.337254901960784, 0.509803921568627, 0.0117647058823529>; // HEX #568203
    #declare farge_Awesome = rgb <1, 0.125490196078431, 0.32156862745098>; // HEX #FF2052
    #declare farge_Axolotl = rgb <0.388235294117647, 0.466666666666667, 0.356862745098039>; // HEX #63775B
    #declare farge_Azure_Mist = rgb <0.941176470588235, 1, 1>; // HEX #F0FFFF
    #declare farge_Azureish_White = rgb <0.858823529411765, 0.913725490196078, 0.956862745098039>; // HEX #DBE9F4
    #declare farge_Baby_Blue = rgb <0.537254901960784, 0.811764705882353, 0.941176470588235>; // HEX #89CFF0
    #declare farge_Baby_Blue_Eyes = rgb <0.631372549019608, 0.792156862745098, 0.945098039215686>; // HEX #A1CAF1
    #declare farge_Baby_Pink = rgb <0.956862745098039, 0.76078431372549, 0.76078431372549>; // HEX #F4C2C2
    #declare farge_Baby_Powder = rgb <0.996078431372549, 0.996078431372549, 0.980392156862745>; // HEX #FEFEFA
    #declare farge_Baiko_brown_Baikocha = rgb <0.52156862745098, 0.486274509803922, 0.333333333333333>; // HEX #857C55
    #declare farge_Baker_Miller_Pink = rgb <1, 0.568627450980392, 0.686274509803922>; // HEX #FF91AF
    #declare farge_Ball_Blue = rgb <0.129411764705882, 0.670588235294118, 0.803921568627451>; // HEX #21ABCD
    #declare farge_Banana_Mania = rgb <0.980392156862745, 0.905882352941176, 0.709803921568627>; // HEX #FAE7B5
    #declare farge_Banana_Yellow = rgb <1, 0.882352941176471, 0.207843137254902>; // HEX #FFE135
    #declare farge_Bangladesh_Green = rgb <0, 0.415686274509804, 0.305882352941176>; // HEX #006A4E
    #declare farge_Barbie_Pink_1 = rgb <0.854901960784314, 0.0941176470588235, 0.517647058823529>; // HEX #DA1884
    #declare farge_Barbie_Pink_1959_1975 = rgb <0.909803921568627, 0.325490196078431, 0.584313725490196>; // HEX #E85395
    #declare farge_Barbie_Pink_1975_1990 = rgb <0.827450980392157, 0.254901960784314, 0.615686274509804>; // HEX #D3419D
    #declare farge_Barbie_Pink_1990_1999 = rgb <0.952941176470588, 0.392156862745098, 0.635294117647059>; // HEX #F364A2
    #declare farge_Barbie_Pink_1999_2004 = rgb <0.968627450980392, 0.137254901960784, 0.541176470588235>; // HEX #F7238A
    #declare farge_Barbie_Pink_2 = rgb <0.913725490196078, 0.254901960784314, 0.588235294117647>; // HEX #E94196
    #declare farge_Barbie_Pink_2004_2005 = rgb <1, 0.223529411764706, 0.533333333333333>; // HEX #FF3988
    #declare farge_Barbie_Pink_2005_2009 = rgb <0.988235294117647, 0.254901960784314, 0.603921568627451>; // HEX #FC419A
    #declare farge_Barbie_Pink_Pantone = rgb <0.87843137254902, 0.129411764705882, 0.541176470588235>; // HEX #E0218A
    #declare farge_Barn_Red = rgb <0.486274509803922, 0.0392156862745098, 0.00784313725490196>; // HEX #7C0A02
    #declare farge_Battleship_Grey = rgb <0.517647058823529, 0.517647058823529, 0.509803921568627>; // HEX #848482
    #declare farge_Bayside = rgb <0.372549019607843, 0.788235294117647, 0.749019607843137>; // HEX #5FC9BF
    #declare farge_Bazaar = rgb <0.596078431372549, 0.466666666666667, 0.482352941176471>; // HEX #98777B
    #declare farge_Beau_Blue = rgb <0.737254901960784, 0.831372549019608, 0.901960784313726>; // HEX #BCD4E6
    #declare farge_Beaver = rgb <0.623529411764706, 0.505882352941176, 0.43921568627451>; // HEX #9F8170
    #declare farge_Beer = rgb <0.949019607843137, 0.556862745098039, 0.109803921568627>; // HEX #F28E1C
    #declare farge_Begonia = rgb <0.980392156862745, 0.431372549019608, 0.474509803921569>; // HEX #FA6E79
    #declare farge_Beige = rgb <0.96078431372549, 0.96078431372549, 0.862745098039216>; // HEX #F5F5DC
    #declare farge_Bellflower_color_Kikyo_iro = rgb <0.364705882352941, 0.247058823529412, 0.415686274509804>; // HEX #5D3F6A
    #declare farge_Betel_nut_dye_Binrojizome = rgb <0.207843137254902, 0.16078431372549, 0.145098039215686>; // HEX #352925
    #declare farge_Big_Foot_Feet = rgb <0.909803921568627, 0.556862745098039, 0.352941176470588>; // HEX #E88E5A
    #declare farge_Birch_brown_Kabacha = rgb <0.694117647058824, 0.290196078431373, 0.188235294117647>; // HEX #B14A30
    #declare farge_Bisque = rgb <1, 0.894117647058824, 0.768627450980392>; // HEX #FFE4C4
    #declare farge_Bistre = rgb <0.23921568627451, 0.168627450980392, 0.12156862745098>; // HEX #3D2B1F
    #declare farge_Bistre_Brown = rgb <0.588235294117647, 0.443137254901961, 0.0901960784313725>; // HEX #967117
    #declare farge_Bitter_Lemon = rgb <0.792156862745098, 0.87843137254902, 0.0509803921568627>; // HEX #CAE00D
    #declare farge_Bitter_Lime = rgb <0.749019607843137, 1, 0>; // HEX #BFFF00
    #declare farge_Black_Bean = rgb <0.23921568627451, 0.0470588235294118, 0.00784313725490196>; // HEX #3D0C02
    #declare farge_Black_chestnut_oak_Kurotsurubami = rgb <0.145098039215686, 0.137254901960784, 0.129411764705882>; // HEX #252321
    #declare farge_Black_Chocolate = rgb <0.105882352941176, 0.0941176470588235, 0.0666666666666667>; // HEX #1B1811
    #declare farge_Black_Coffee = rgb <0.231372549019608, 0.184313725490196, 0.184313725490196>; // HEX #3B2F2F
    #declare farge_Black_kite_Kurotobi = rgb <0.207843137254902, 0.117647058823529, 0.109803921568627>; // HEX #351E1C
    #declare farge_Black_Kokushoku = rgb <0.0901960784313725, 0.0784313725490196, 0.0705882352941176>; // HEX #171412
    #declare farge_Black_Leather_Jacket = rgb <0.145098039215686, 0.207843137254902, 0.16078431372549>; // HEX #253529
    #declare farge_Black_Olive = rgb <0.231372549019608, 0.235294117647059, 0.211764705882353>; // HEX #3B3C36
    #declare farge_Blanched_Almond = rgb <1, 0.92156862745098, 0.803921568627451>; // HEX #FFEBCD
    #declare farge_Bleu_De_France = rgb <0.192156862745098, 0.549019607843137, 0.905882352941176>; // HEX #318CE7
    #declare farge_Blizzard_Blue = rgb <0.674509803921569, 0.898039215686275, 0.933333333333333>; // HEX #ACE5EE
    #declare farge_Blond = rgb <0.980392156862745, 0.941176470588235, 0.745098039215686>; // HEX #FAF0BE
    #declare farge_Blood = rgb <0.541176470588235, 0.0117647058823529, 0.0117647058823529>; // HEX #8A0303
    #declare farge_Blood_Animal = rgb <0.643137254901961, 0.0745098039215686, 0.0745098039215686>; // HEX #A41313
    #declare farge_Blood_orange = rgb <0.819607843137255, 0, 0.109803921568627>; // HEX #D1001C
    #declare farge_Blood_organ = rgb <0.388235294117647, 0.0588235294117647, 0.0588235294117647>; // HEX #630F0F
    #declare farge_Blood_Red = rgb <0.4, 0, 0>; // HEX #660000
    #declare farge_Blood_red_Benihi = rgb <0.952941176470588, 0.325490196078431, 0.211764705882353>; // HEX #F35336
    #declare farge_Blue_Bell = rgb <0.635294117647059, 0.635294117647059, 0.815686274509804>; // HEX #A2A2D0
    #declare farge_Blue_Black_Crayfish_Aoni = rgb <0.32156862745098, 0.349019607843137, 0.231372549019608>; // HEX #52593B
    #declare farge_Blue_bolt = rgb <0, 0.725490196078431, 0.984313725490196>; // HEX #00B9FB
    #declare farge_Blue_cola = rgb <0, 0.533333333333333, 0.862745098039216>; // HEX #0088DC
    #declare farge_Blue_Gray = rgb <0.4, 0.6, 0.8>; // HEX #6699CC
    #declare farge_Blue_Green = rgb <0.0509803921568627, 0.596078431372549, 0.729411764705882>; // HEX #0D98BA
    #declare farge_Blue_green_Seiheki = rgb <0.227450980392157, 0.411764705882353, 0.376470588235294>; // HEX #3A6960
    #declare farge_Blue_lagoon = rgb <0.298039215686275, 0.717647058823529, 0.647058823529412>; // HEX #4CB7A5
    #declare farge_Blue_Magenta_Violet = rgb <0.333333333333333, 0.207843137254902, 0.572549019607843>; // HEX #553592
    #declare farge_Blue_Munsell = rgb <0, 0.576470588235294, 0.686274509803922>; // HEX #0093AF
    #declare farge_Blue_NCS = rgb <0, 0.529411764705882, 0.741176470588235>; // HEX #0087BD
    #declare farge_Blue_Pantone = rgb <0, 0.0941176470588235, 0.658823529411765>; // HEX #0018A8
    #declare farge_Blue_Pigment = rgb <0.2, 0.2, 0.6>; // HEX #333399
    #declare farge_Blue_raspberry = rgb <0.0470588235294118, 0.749019607843137, 0.913725490196078>; // HEX #0CBFE9
    #declare farge_Blue_RYB = rgb <0.00784313725490196, 0.27843137254902, 0.996078431372549>; // HEX #0247FE
    #declare farge_Blue_Sapphire = rgb <0.0705882352941176, 0.380392156862745, 0.501960784313725>; // HEX #126180
    #declare farge_Blue_Violet = rgb <0.541176470588235, 0.168627450980392, 0.886274509803922>; // HEX #8A2BE2
    #declare farge_Blue_violet_Shikon = rgb <0.168627450980392, 0.125490196078431, 0.156862745098039>; // HEX #2B2028
    #declare farge_Blue_Yonder = rgb <0.313725490196078, 0.447058823529412, 0.654901960784314>; // HEX #5072A7
    #declare farge_Blueberry = rgb <0.309803921568627, 0.525490196078431, 0.968627450980392>; // HEX #4F86F7
    #declare farge_Bluebonnet = rgb <0.109803921568627, 0.109803921568627, 0.941176470588235>; // HEX #1C1CF0
    #declare farge_Blush = rgb <0.870588235294118, 0.364705882352941, 0.513725490196078>; // HEX #DE5D83
    #declare farge_Boiled_red_bean_brown_Momoshiocha = rgb <0.329411764705882, 0.176470588235294, 0.141176470588235>; // HEX #542D24
    #declare farge_Bole = rgb <0.474509803921569, 0.266666666666667, 0.231372549019608>; // HEX #79443B
    #declare farge_Bondi_Blue = rgb <0, 0.584313725490196, 0.713725490196078>; // HEX #0095B6
    #declare farge_Bone = rgb <0.890196078431372, 0.854901960784314, 0.788235294117647>; // HEX #E3DAC9
    #declare farge_Bored_accent_green = rgb <0.866666666666667, 0.886274509803922, 0.415686274509804>; // HEX #DDE26A
    #declare farge_Boston_University_Red = rgb <0.8, 0, 0>; // HEX #CC0000
    #declare farge_Bottle_Green = rgb <0, 0.415686274509804, 0.305882352941176>; // HEX #006A4E
    #declare farge_Boy_red = rgb <0.0549019607843137, 0.611764705882353, 0.647058823529412>; // HEX #0E9CA5
    #declare farge_Boysenberry = rgb <0.529411764705882, 0.196078431372549, 0.376470588235294>; // HEX #873260
    #declare farge_Brandeis_Blue = rgb <0, 0.43921568627451, 1>; // HEX #0070FF
    #declare farge_Brandy = rgb <0.529411764705882, 0.254901960784314, 0.247058823529412>; // HEX #87413F
    #declare farge_Brave_orange = rgb <1, 0.388235294117647, 0.109803921568627>; // HEX #FF631C
    #declare farge_Brewed_mustard_brown_Tokigaracha = rgb <0.901960784313726, 0.513725490196078, 0.392156862745098>; // HEX #E68364
    #declare farge_Brick_Red = rgb <0.796078431372549, 0.254901960784314, 0.329411764705882>; // HEX #CB4154
    #declare farge_Bright_Cerulean = rgb <0.109803921568627, 0.674509803921569, 0.835294117647059>; // HEX #1CACD5
    #declare farge_Bright_gray = rgb <0.92156862745098, 0.925490196078431, 0.941176470588235>; // HEX #EBECF0
    #declare farge_Bright_Green = rgb <0.4, 1, 0>; // HEX #66FF00
    #declare farge_Bright_Lavender = rgb <0.749019607843137, 0.580392156862745, 0.894117647058824>; // HEX #BF94E4
    #declare farge_Bright_Lilac = rgb <0.847058823529412, 0.568627450980392, 0.937254901960784>; // HEX #D891EF
    #declare farge_Bright_Maroon = rgb <0.764705882352941, 0.129411764705882, 0.282352941176471>; // HEX #C32148
    #declare farge_Bright_Navy_Blue = rgb <0.0980392156862745, 0.454901960784314, 0.823529411764706>; // HEX #1974D2
    #declare farge_Bright_Pink = rgb <1, 0, 0.498039215686275>; // HEX #FF007F
    #declare farge_Bright_Turquoise = rgb <0.0313725490196078, 0.909803921568627, 0.870588235294118>; // HEX #08E8DE
    #declare farge_Bright_Ube = rgb <0.819607843137255, 0.623529411764706, 0.909803921568627>; // HEX #D19FE8
    #declare farge_Brilliant_Azure = rgb <0.2, 0.6, 1>; // HEX #3399FF
    #declare farge_Brilliant_Lavender = rgb <0.956862745098039, 0.733333333333333, 1>; // HEX #F4BBFF
    #declare farge_Brilliant_Rose = rgb <1, 0.333333333333333, 0.63921568627451>; // HEX #FF55A3
    #declare farge_Brink_Pink = rgb <0.984313725490196, 0.376470588235294, 0.498039215686275>; // HEX #FB607F
    #declare farge_British_Racing_Green = rgb <0, 0.258823529411765, 0.145098039215686>; // HEX #004225
    #declare farge_Bronze = rgb <0.803921568627451, 0.498039215686275, 0.196078431372549>; // HEX #CD7F32
    #declare farge_Bronze_metallic = rgb <0.690196078431373, 0.552941176470588, 0.341176470588235>; // HEX #B08D57
    #declare farge_Bronze_Yellow = rgb <0.450980392156863, 0.43921568627451, 0>; // HEX #737000
    #declare farge_Brown_1 = rgb <0.533333333333333, 0.329411764705882, 0.0431372549019608>; // HEX #88540B
    #declare farge_Brown_2 = rgb <0.6, 0.2, 0>; // HEX #993300
    #declare farge_Brown_Chocolate = rgb <0.372549019607843, 0.0980392156862745, 0.2>; // HEX #5F1933
    #declare farge_Brown_Coffee = rgb <0.290196078431373, 0.172549019607843, 0.164705882352941>; // HEX #4A2C2A
    #declare farge_Brown_Nose = rgb <0.415686274509804, 0.266666666666667, 0.137254901960784>; // HEX #6A4423
    #declare farge_Brown_rat_grey_Dobunezumi = rgb <0.294117647058824, 0.235294117647059, 0.223529411764706>; // HEX #4B3C39
    #declare farge_Brown_Traditional = rgb <0.588235294117647, 0.294117647058824, 0>; // HEX #964B00
    #declare farge_Brown_Web = rgb <0.647058823529412, 0.16078431372549, 0.16078431372549>; // HEX #A52929
    #declare farge_Brown_Yellow = rgb <0.8, 0.6, 0.4>; // HEX #CC9966
    #declare farge_Brunswick_Green = rgb <0.105882352941176, 0.301960784313725, 0.243137254901961>; // HEX #1B4D3E
    #declare farge_Brushwood_dyed_Fushizome = rgb <0.549019607843137, 0.349019607843137, 0.223529411764706>; // HEX #8C5939
    #declare farge_Bubble_Gum = rgb <1, 0.756862745098039, 0.8>; // HEX #FFC1CC
    #declare farge_Bubbles = rgb <0.905882352941176, 0.996078431372549, 1>; // HEX #E7FEFF
    #declare farge_Bud_Green = rgb <0.482352941176471, 0.713725490196078, 0.380392156862745>; // HEX #7BB661
    #declare farge_Buff = rgb <0.941176470588235, 0.862745098039216, 0.509803921568627>; // HEX #F0DC82
    #declare farge_Bulgarian_Rose = rgb <0.282352941176471, 0.0235294117647059, 0.0274509803921569>; // HEX #480607
    #declare farge_Burgundy = rgb <0.501960784313725, 0, 0.125490196078431>; // HEX #800020
    #declare farge_Burlywood = rgb <0.870588235294118, 0.72156862745098, 0.529411764705882>; // HEX #DEB887
    #declare farge_Burnt_Orange = rgb <0.8, 0.333333333333333, 0>; // HEX #CC5500
    #declare farge_Burnt_Umber = rgb <0.541176470588235, 0.2, 0.141176470588235>; // HEX #8A3324
    #declare farge_Button_blue = rgb <0.141176470588235, 0.627450980392157, 0.929411764705882>; // HEX #24A0ED
    #declare farge_Byzantine = rgb <0.741176470588235, 0.2, 0.643137254901961>; // HEX #BD33A4
    #declare farge_Byzantium = rgb <0.43921568627451, 0.16078431372549, 0.388235294117647>; // HEX #702963
    #declare farge_Cadet = rgb <0.325490196078431, 0.407843137254902, 0.447058823529412>; // HEX #536872
    #declare farge_Cadet_Blue = rgb <0.372549019607843, 0.619607843137255, 0.627450980392157>; // HEX #5F9EA0
    #declare farge_Cadet_Grey = rgb <0.568627450980392, 0.63921568627451, 0.690196078431373>; // HEX #91A3B0
    #declare farge_Cadmium_blue = rgb <0.0392156862745098, 0.0666666666666667, 0.584313725490196>; // HEX #0A1195
    #declare farge_Cadmium_Green = rgb <0, 0.419607843137255, 0.235294117647059>; // HEX #006B3C
    #declare farge_Cadmium_Orange = rgb <0.929411764705882, 0.529411764705882, 0.176470588235294>; // HEX #ED872D
    #declare farge_Cadmium_purple = rgb <0.713725490196078, 0.0470588235294118, 0.149019607843137>; // HEX #B60C26
    #declare farge_Cadmium_Red = rgb <0.890196078431372, 0, 0.133333333333333>; // HEX #E30022
    #declare farge_Cadmium_violet = rgb <0.498039215686275, 0.243137254901961, 0.596078431372549>; // HEX #7F3E98
    #declare farge_Cadmium_Yellow = rgb <1, 0.964705882352941, 0>; // HEX #FFF600
    #declare farge_Cafe_Au_Lait = rgb <0.650980392156863, 0.482352941176471, 0.356862745098039>; // HEX #A67B5B
    #declare farge_Cafe_Noir = rgb <0.294117647058824, 0.211764705882353, 0.129411764705882>; // HEX #4B3621
    #declare farge_Cal_Poly_Pomona_Green = rgb <0.117647058823529, 0.301960784313725, 0.168627450980392>; // HEX #1E4D2B
    #declare farge_Calamansi = rgb <0.988235294117647, 1, 0.643137254901961>; // HEX #FCFFA4
    #declare farge_Cambridge_Blue = rgb <0.63921568627451, 0.756862745098039, 0.67843137254902>; // HEX #A3C1AD
    #declare farge_Camel = rgb <0.756862745098039, 0.603921568627451, 0.419607843137255>; // HEX #C19A6B
    #declare farge_Cameo_Pink = rgb <0.937254901960784, 0.733333333333333, 0.8>; // HEX #EFBBCC
    #declare farge_Camouflage_Green = rgb <0.470588235294118, 0.525490196078431, 0.419607843137255>; // HEX #78866B
    #declare farge_Canary_Yellow = rgb <1, 0.937254901960784, 0>; // HEX #FFEF00
    #declare farge_Candy_Apple_Red = rgb <1, 0.0313725490196078, 0>; // HEX #FF0800
    #declare farge_Candy_Pink = rgb <0.894117647058824, 0.443137254901961, 0.47843137254902>; // HEX #E4717A
    #declare farge_Cape_jasmine_Kuchinashi = rgb <1, 0.725490196078431, 0.352941176470588>; // HEX #FFB95A
    #declare farge_Capri = rgb <0, 0.749019607843137, 1>; // HEX #00BFFF
    #declare farge_Caput_Mortuum = rgb <0.349019607843137, 0.152941176470588, 0.125490196078431>; // HEX #592720
    #declare farge_Caramel = rgb <1, 0.835294117647059, 0.603921568627451>; // HEX #FFD59A
    #declare farge_Cardinal = rgb <0.768627450980392, 0.117647058823529, 0.227450980392157>; // HEX #C41E3A
    #declare farge_Caribbean_blue = rgb <0.101960784313725, 0.756862745098039, 0.866666666666667>; // HEX #1AC1DD
    #declare farge_Carmine = rgb <0.588235294117647, 0, 0.0941176470588235>; // HEX #960018
    #declare farge_Carmine_M_and_P = rgb <0.843137254901961, 0, 0.250980392156863>; // HEX #D70040
    #declare farge_Carmine_Pink = rgb <0.92156862745098, 0.298039215686275, 0.258823529411765>; // HEX #EB4C42
    #declare farge_Carmine_Red = rgb <1, 0, 0.219607843137255>; // HEX #FF0038
    #declare farge_Carnelian = rgb <0.701960784313725, 0.105882352941176, 0.105882352941176>; // HEX #B31B1B
    #declare farge_Carolina_Blue = rgb <0.337254901960784, 0.627450980392157, 0.827450980392157>; // HEX #56A0D3
    #declare farge_Carrot_Orange = rgb <0.929411764705882, 0.568627450980392, 0.129411764705882>; // HEX #ED9121
    #declare farge_Castleton_Green = rgb <0, 0.337254901960784, 0.247058823529412>; // HEX #00563F
    #declare farge_Catalina_Blue = rgb <0.0235294117647059, 0.164705882352941, 0.470588235294118>; // HEX #062A78
    #declare farge_Catawba = rgb <0.43921568627451, 0.211764705882353, 0.258823529411765>; // HEX #703642
    #declare farge_Cattail_color_Kaba_iro = rgb <0.713725490196078, 0.286274509803922, 0.145098039215686>; // HEX #B64925
    #declare farge_Cedar_Chest = rgb <0.788235294117647, 0.352941176470588, 0.286274509803922>; // HEX #C95A49
    #declare farge_Ceil = rgb <0.572549019607843, 0.631372549019608, 0.811764705882353>; // HEX #92A1CF
    #declare farge_Celadon = rgb <0.674509803921569, 0.882352941176471, 0.686274509803922>; // HEX #ACE1AF
    #declare farge_Celadon_Blue = rgb <0, 0.482352941176471, 0.654901960784314>; // HEX #007BA7
    #declare farge_Celadon_color_Seiji_iro = rgb <0.505882352941176, 0.611764705882353, 0.545098039215686>; // HEX #819C8B
    #declare farge_Celadon_Green = rgb <0.184313725490196, 0.517647058823529, 0.486274509803922>; // HEX #2F847C
    #declare farge_Celeste = rgb <0.698039215686274, 1, 1>; // HEX #B2FFFF
    #declare farge_Celestial_Blue = rgb <0.286274509803922, 0.592156862745098, 0.815686274509804>; // HEX #4997D0
    #declare farge_Celtic_Blue = rgb <0.141176470588235, 0.419607843137255, 0.807843137254902>; // HEX #246BCE
    #declare farge_Cerise = rgb <0.870588235294118, 0.192156862745098, 0.388235294117647>; // HEX #DE3163
    #declare farge_Cerise_Pink = rgb <0.925490196078431, 0.231372549019608, 0.513725490196078>; // HEX #EC3B83
    #declare farge_Cerulean = rgb <0, 0.482352941176471, 0.654901960784314>; // HEX #007BA7
    #declare farge_Cerulean_Blue = rgb <0.164705882352941, 0.32156862745098, 0.745098039215686>; // HEX #2A52BE
    #declare farge_Cetacean_blue = rgb <0, 0.0784313725490196, 0.250980392156863>; // HEX #001440
    #declare farge_CG_Blue = rgb <0, 0.47843137254902, 0.647058823529412>; // HEX #007AA5
    #declare farge_CG_Red = rgb <0.87843137254902, 0.235294117647059, 0.192156862745098>; // HEX #E03C31
    #declare farge_Chamoisee = rgb <0.627450980392157, 0.470588235294118, 0.352941176470588>; // HEX #A0785A
    #declare farge_Champagne = rgb <0.968627450980392, 0.905882352941176, 0.807843137254902>; // HEX #F7E7CE
    #declare farge_Champagne_Pink = rgb <0.945098039215686, 0.866666666666667, 0.811764705882353>; // HEX #F1DDCF
    #declare farge_Charcoal = rgb <0.211764705882353, 0.270588235294118, 0.309803921568627>; // HEX #36454F
    #declare farge_Charleston_Green = rgb <0.137254901960784, 0.168627450980392, 0.168627450980392>; // HEX #232B2B
    #declare farge_Charm = rgb <0.815686274509804, 0.454901960784314, 0.545098039215686>; // HEX #D0748B
    #declare farge_Charm_Pink = rgb <0.901960784313726, 0.56078431372549, 0.674509803921569>; // HEX #E68FAC
    #declare farge_Chartreuse_Traditional = rgb <0.874509803921569, 1, 0>; // HEX #DFFF00
    #declare farge_Cheese = rgb <1, 0.650980392156863, 0>; // HEX #FFA600
    #declare farge_Cherry = rgb <0.866666666666667, 0.192156862745098, 0.384313725490196>; // HEX #DD3162
    #declare farge_Cherry_blossom_color_Sakura_iro = rgb <0.988235294117647, 0.788235294117647, 0.725490196078431>; // HEX #FCC9B9
    #declare farge_Cherry_blossom_mouse_Sakuranezumi = rgb <0.674509803921569, 0.505882352941176, 0.505882352941176>; // HEX #AC8181
    #declare farge_Cherry_Blossom_Pink = rgb <1, 0.717647058823529, 0.772549019607843>; // HEX #FFB7C5
    #declare farge_Chestnut = rgb <0.584313725490196, 0.270588235294118, 0.207843137254902>; // HEX #954535
    #declare farge_Chestnut_leather_brown_Kurikawacha = rgb <0.376470588235294, 0.156862745098039, 0.117647058823529>; // HEX #60281E
    #declare farge_Chickadee = rgb <1, 0.764705882352941, 0.301960784313725>; // HEX #FFC34D
    #declare farge_China_Pink = rgb <0.870588235294118, 0.435294117647059, 0.631372549019608>; // HEX #DE6FA1
    #declare farge_China_Rose = rgb <0.658823529411765, 0.317647058823529, 0.431372549019608>; // HEX #A8516E
    #declare farge_Chinese_black = rgb <0.0784313725490196, 0.0784313725490196, 0.0784313725490196>; // HEX #141414
    #declare farge_Chinese_blue = rgb <0.211764705882353, 0.317647058823529, 0.580392156862745>; // HEX #365194
    #declare farge_Chinese_bronze = rgb <0.803921568627451, 0.501960784313725, 0.196078431372549>; // HEX #CD8032
    #declare farge_Chinese_brown = rgb <0.670588235294118, 0.219607843137255, 0.12156862745098>; // HEX #AB381F
    #declare farge_Chinese_gold = rgb <0.8, 0.6, 0>; // HEX #CC9900
    #declare farge_Chinese_green = rgb <0.815686274509804, 0.858823529411765, 0.380392156862745>; // HEX #D0DB61
    #declare farge_Chinese_orange = rgb <0.952941176470588, 0.43921568627451, 0.258823529411765>; // HEX #F37042
    #declare farge_Chinese_pink = rgb <0.870588235294118, 0.43921568627451, 0.631372549019608>; // HEX #DE70A1
    #declare farge_Chinese_purple = rgb <0.447058823529412, 0.0431372549019608, 0.596078431372549>; // HEX #720B98
    #declare farge_Chinese_Red_1 = rgb <0.666666666666667, 0.219607843137255, 0.117647058823529>; // HEX #AA381E
    #declare farge_Chinese_Red_2 = rgb <0.803921568627451, 0.0274509803921569, 0.117647058823529>; // HEX #CD071E
    #declare farge_Chinese_Violet = rgb <0.52156862745098, 0.376470588235294, 0.533333333333333>; // HEX #856088
    #declare farge_Chinese_white = rgb <0.886274509803922, 0.898039215686275, 0.870588235294118>; // HEX #E2E5DE
    #declare farge_Chinese_Yellow = rgb <1, 0.698039215686274, 0>; // HEX #FFB200
    #declare farge_Chinese_yellow_tea_colored_Kigaracha = rgb <0.717647058823529, 0.43921568627451, 0.176470588235294>; // HEX #B7702D
    #declare farge_Chlorophyll_green = rgb <0.290196078431373, 1, 0>; // HEX #4AFF00
    #declare farge_Chocolate_brown = rgb <0.247058823529412, 0, 0.0588235294117647>; // HEX #3F000F
    #declare farge_Chocolate_cosmos = rgb <0.345098039215686, 0.0666666666666667, 0.101960784313725>; // HEX #58111A
    #declare farge_Chocolate_Kisses = rgb <0.235294117647059, 0.0784313725490196, 0.129411764705882>; // HEX #3C1421
    #declare farge_Chocolate_Traditional = rgb <0.482352941176471, 0.247058823529412, 0>; // HEX #7B3F00
    #declare farge_Chocolate_Web = rgb <0.823529411764706, 0.411764705882353, 0.117647058823529>; // HEX #D2691E
    #declare farge_Chrome_aluminum = rgb <0.658823529411765, 0.662745098039216, 0.67843137254902>; // HEX #A8A9AD
    #declare farge_Chrome_Yellow = rgb <1, 0.654901960784314, 0>; // HEX #FFA700
    #declare farge_Cinereous = rgb <0.596078431372549, 0.505882352941176, 0.482352941176471>; // HEX #98817B
    #declare farge_Cinnabar = rgb <0.890196078431372, 0.258823529411765, 0.203921568627451>; // HEX #E34234
    #declare farge_Cinnamon = rgb <0.823529411764706, 0.411764705882353, 0.117647058823529>; // HEX #D2691E
    #declare farge_Citrine = rgb <0.894117647058824, 0.815686274509804, 0.0392156862745098>; // HEX #E4D00A
    #declare farge_Citron = rgb <0.623529411764706, 0.662745098039216, 0.12156862745098>; // HEX #9FA91F
    #declare farge_Claret = rgb <0.498039215686275, 0.0901960784313725, 0.203921568627451>; // HEX #7F1734
    #declare farge_Classic_Rose = rgb <0.984313725490196, 0.8, 0.905882352941176>; // HEX #FBCCE7
    #declare farge_Clove_brown_Chojicha = rgb <0.56078431372549, 0.345098039215686, 0.235294117647059>; // HEX #8F583C
    #declare farge_Clove_dyed_Chojizome = rgb <0.662745098039216, 0.384313725490196, 0.196078431372549>; // HEX #A96232
    #declare farge_Coarse_wool_color_Kachi_iro = rgb <0.0941176470588235, 0.105882352941176, 0.149019607843137>; // HEX #181B26
    #declare farge_Cobalt = rgb <0, 0.27843137254902, 0.666666666666667>; // HEX #0047AA
    #declare farge_Cobalt_Blue = rgb <0, 0.27843137254902, 0.670588235294118>; // HEX #0047AB
    #declare farge_Cocoa_Brown = rgb <0.823529411764706, 0.411764705882353, 0.117647058823529>; // HEX #D2691E
    #declare farge_Coconut = rgb <0.588235294117647, 0.352941176470588, 0.243137254901961>; // HEX #965A3E
    #declare farge_Coconut_White = rgb <0.913725490196078, 0.929411764705882, 0.964705882352941>; // HEX #E9EDF6
    #declare farge_Codium_fragile_seaweed_color_Miru_iro = rgb <0.32156862745098, 0.294117647058824, 0.164705882352941>; // HEX #524B2A
    #declare farge_Coffee = rgb <0.435294117647059, 0.305882352941176, 0.215686274509804>; // HEX #6F4E37
    #declare farge_Cola = rgb <0.235294117647059, 0.188235294117647, 0.141176470588235>; // HEX #3C3024
    #declare farge_Color_Wheel_Blue_Green = rgb <0.0235294117647059, 0.305882352941176, 0.247058823529412>; // HEX #064E3F
    #declare farge_Color_Wheel_Blue_Violet = rgb <0.298039215686275, 0.0980392156862745, 0.498039215686275>; // HEX #4C197F
    #declare farge_Color_Wheel_Lime = rgb <0.749019607843137, 1, 0>; // HEX #BFFF00
    #declare farge_Color_Wheel_Red_Orange = rgb <1, 0.266666666666667, 0>; // HEX #FF4400
    #declare farge_Color_Wheel_Red_Violet = rgb <0.572549019607843, 0.168627450980392, 0.243137254901961>; // HEX #922B3E
    #declare farge_Color_Wheel_Yellow_Green = rgb <0.184313725490196, 0.698039215686274, 0.0980392156862745>; // HEX #2FB219
    #declare farge_Color_Wheel_Yellow_Orange = rgb <1, 0.580392156862745, 0.0156862745098039>; // HEX #FF9404
    #declare farge_Columbia_Blue_1 = rgb <0.725490196078431, 0.850980392156863, 0.92156862745098>; // HEX #B9D9EB
    #declare farge_Columbia_Blue_2 = rgb <0.768627450980392, 0.847058823529412, 0.886274509803922>; // HEX #C4D8E2
    #declare farge_Conditioner = rgb <1, 1, 0.8>; // HEX #FFFFCC
    #declare farge_Congo_Pink = rgb <0.972549019607843, 0.513725490196078, 0.474509803921569>; // HEX #F88379
    #declare farge_Contemplation_in_a_tea_garden_Rokocha = rgb <0.4, 0.325490196078431, 0.262745098039216>; // HEX #665343
    #declare farge_Cookies_and_cream = rgb <0.933333333333333, 0.87843137254902, 0.694117647058824>; // HEX #EEE0B1
    #declare farge_Cool_Black = rgb <0, 0.180392156862745, 0.388235294117647>; // HEX #002E63
    #declare farge_Cool_Grey = rgb <0.549019607843137, 0.572549019607843, 0.674509803921569>; // HEX #8C92AC
    #declare farge_Copper_Red = rgb <0.796078431372549, 0.427450980392157, 0.317647058823529>; // HEX #CB6D51
    #declare farge_Copper_Rose = rgb <0.6, 0.4, 0.4>; // HEX #996666
    #declare farge_Coquelicot = rgb <1, 0.219607843137255, 0>; // HEX #FF3800
    #declare farge_Coral = rgb <1, 0.498039215686275, 0.313725490196078>; // HEX #FF7F50
    #declare farge_Coral_color_Sango_iro = rgb <0.972549019607843, 0.403921568627451, 0.309803921568627>; // HEX #F8674F
    #declare farge_Coral_Pink = rgb <0.972549019607843, 0.513725490196078, 0.474509803921569>; // HEX #F88379
    #declare farge_Coral_Red = rgb <1, 0.250980392156863, 0.250980392156863>; // HEX #FF4040
    #declare farge_Coral_Reef = rgb <0.992156862745098, 0.486274509803922, 0.431372549019608>; // HEX #FD7C6E
    #declare farge_Coral_Reef_Valspar_Paint_Color = rgb <0.964705882352941, 0.643137254901961, 0.580392156862745>; // HEX #F6A494
    #declare farge_Cordovan = rgb <0.537254901960784, 0.247058823529412, 0.270588235294118>; // HEX #893F45
    #declare farge_Corn = rgb <0.984313725490196, 0.925490196078431, 0.364705882352941>; // HEX #FBEC5D
    #declare farge_Corn_colored_Tomorokoshi_iro = rgb <0.980392156862745, 0.662745098039216, 0.270588235294118>; // HEX #FAA945
    #declare farge_Cornell_Red = rgb <0.698039215686274, 0.105882352941176, 0.105882352941176>; // HEX #B21B1B
    #declare farge_Cornflower_Blue = rgb <0.392156862745098, 0.584313725490196, 0.929411764705882>; // HEX #6495ED
    #declare farge_Cornsilk = rgb <1, 0.972549019607843, 0.862745098039216>; // HEX #FFF8DC
    #declare farge_Cosmic_Latte = rgb <1, 0.972549019607843, 0.905882352941176>; // HEX #FFF8E7
    #declare farge_Cotton_Candy = rgb <1, 0.737254901960784, 0.850980392156863>; // HEX #FFBCD9
    #declare farge_Coyote_Brown = rgb <0.505882352941176, 0.380392156862745, 0.235294117647059>; // HEX #81613C
    #declare farge_Cream = rgb <1, 0.992156862745098, 0.815686274509804>; // HEX #FFFDD0
    #declare farge_Crimson = rgb <0.862745098039216, 0.0784313725490196, 0.235294117647059>; // HEX #DC143C
    #declare farge_Crimson_Glory = rgb <0.745098039215686, 0, 0.196078431372549>; // HEX #BE0032
    #declare farge_Crimson_Red = rgb <0.6, 0, 0>; // HEX #990000
    #declare farge_Crimson_UA = rgb <0.619607843137255, 0.105882352941176, 0.196078431372549>; // HEX #9E1B32
    #declare farge_Crystal = rgb <0.654901960784314, 0.847058823529412, 0.870588235294118>; // HEX #A7D8DE
    #declare farge_Crystal_Blue = rgb <0.407843137254902, 0.627450980392157, 0.690196078431373>; // HEX #68A0B0
    #declare farge_Cyan_Azure = rgb <0.305882352941176, 0.509803921568627, 0.705882352941177>; // HEX #4E82B4
    #declare farge_Cyan_Blue_Azure = rgb <0.274509803921569, 0.509803921568627, 0.749019607843137>; // HEX #4682BF
    #declare farge_Cyan_Cobalt_Blue = rgb <0.156862745098039, 0.345098039215686, 0.611764705882353>; // HEX #28589C
    #declare farge_Cyan_Cornflower_Blue = rgb <0.0941176470588235, 0.545098039215686, 0.76078431372549>; // HEX #188BC2
    #declare farge_Cyan_Process = rgb <0, 0.717647058823529, 0.92156862745098>; // HEX #00B7EB
    #declare farge_Cyber_Yellow = rgb <1, 0.827450980392157, 0>; // HEX #FFD300
    #declare farge_Cyclamen = rgb <0.96078431372549, 0.435294117647059, 0.631372549019608>; // HEX #F56FA1
    #declare farge_Cypress_bark_color_Hihada_iro = rgb <0.458823529411765, 0.180392156862745, 0.137254901960784>; // HEX #752E23
    #declare farge_Cypress_bark_red_Benihibata = rgb <0.435294117647059, 0.188235294117647, 0.156862745098039>; // HEX #6F3028
    #declare farge_Daffodil = rgb <1, 1, 0.192156862745098>; // HEX #FFFF31
    #declare farge_Dandelion = rgb <0.941176470588235, 0.882352941176471, 0.188235294117647>; // HEX #F0E130
    #declare farge_Dandelion_Crayola = rgb <0.992156862745098, 0.858823529411765, 0.427450980392157>; // HEX #FDDB6D
    #declare farge_Dark_Blue = rgb <0, 0, 0.545098039215686>; // HEX #00008B
    #declare farge_Dark_Blue_Gray = rgb <0.4, 0.4, 0.6>; // HEX #666699
    #declare farge_Dark_blue_Kon = rgb <0.0980392156862745, 0.133333333333333, 0.211764705882353>; // HEX #192236
    #declare farge_Dark_blue_lapis_lazuli_Rurikon = rgb <0.105882352941176, 0.16078431372549, 0.294117647058824>; // HEX #1B294B
    #declare farge_Dark_bronze = rgb <0.501960784313725, 0.290196078431373, 0>; // HEX #804A00
    #declare farge_Dark_bronze_Coin = rgb <0.317647058823529, 0.254901960784314, 0>; // HEX #514100
    #declare farge_Dark_Brown = rgb <0.396078431372549, 0.262745098039216, 0.129411764705882>; // HEX #654321
    #declare farge_Dark_brown_tangelo = rgb <0.533333333333333, 0.396078431372549, 0.305882352941176>; // HEX #88654E
    #declare farge_Dark_Byzantium = rgb <0.364705882352941, 0.223529411764706, 0.329411764705882>; // HEX #5D3954
    #declare farge_Dark_Candy_Apple_Red = rgb <0.643137254901961, 0, 0>; // HEX #A40000
    #declare farge_Dark_Cerulean = rgb <0.0313725490196078, 0.270588235294118, 0.494117647058824>; // HEX #08457E
    #declare farge_Dark_Chestnut = rgb <0.596078431372549, 0.411764705882353, 0.376470588235294>; // HEX #986960
    #declare farge_Dark_Chocolate = rgb <0.286274509803922, 0.00784313725490196, 0.0235294117647059>; // HEX #490206
    #declare farge_Dark_Chocolate_Hersheys = rgb <0.235294117647059, 0.0745098039215686, 0.129411764705882>; // HEX #3C1321
    #declare farge_Dark_Coral = rgb <0.803921568627451, 0.356862745098039, 0.270588235294118>; // HEX #CD5B45
    #declare farge_Dark_Cornflower_Blue = rgb <0.149019607843137, 0.258823529411765, 0.545098039215686>; // HEX #26428B
    #declare farge_Dark_Cyan = rgb <0, 0.545098039215686, 0.545098039215686>; // HEX #008B8B
    #declare farge_Dark_Electric_Blue = rgb <0.325490196078431, 0.407843137254902, 0.470588235294118>; // HEX #536878
    #declare farge_Dark_Gold = rgb <0.666666666666667, 0.423529411764706, 0.223529411764706>; // HEX #AA6C39
    #declare farge_Dark_Goldenrod = rgb <0.72156862745098, 0.525490196078431, 0.0431372549019608>; // HEX #B8860B
    #declare farge_Dark_Green = rgb <0.00392156862745098, 0.196078431372549, 0.125490196078431>; // HEX #013220
    #declare farge_Dark_Gunmetal = rgb <0.12156862745098, 0.149019607843137, 0.164705882352941>; // HEX #1F262A
    #declare farge_Dark_Imperial_Blue = rgb <0, 0.0784313725490196, 0.494117647058824>; // HEX #00147E
    #declare farge_Dark_Indigo_Futaai = rgb <0.380392156862745, 0.305882352941176, 0.431372549019608>; // HEX #614E6E
    #declare farge_Dark_Jungle_Green = rgb <0.101960784313725, 0.141176470588235, 0.129411764705882>; // HEX #1A2421
    #declare farge_Dark_Khaki = rgb <0.741176470588235, 0.717647058823529, 0.419607843137255>; // HEX #BDB76B
    #declare farge_Dark_Lava = rgb <0.282352941176471, 0.235294117647059, 0.196078431372549>; // HEX #483C32
    #declare farge_Dark_Lavender = rgb <0.450980392156863, 0.309803921568627, 0.588235294117647>; // HEX #734F96
    #declare farge_Dark_Lemon_Lime = rgb <0.545098039215686, 0.745098039215686, 0.105882352941176>; // HEX #8BBE1B
    #declare farge_Dark_Liver = rgb <0.325490196078431, 0.294117647058824, 0.309803921568627>; // HEX #534B4F
    #declare farge_Dark_Liver_Horses = rgb <0.329411764705882, 0.23921568627451, 0.215686274509804>; // HEX #543D37
    #declare farge_Dark_Magenta = rgb <0.545098039215686, 0, 0.545098039215686>; // HEX #8B008B
    #declare farge_Dark_Midnight_Blue = rgb <0, 0.2, 0.4>; // HEX #003366
    #declare farge_Dark_Moss_Green = rgb <0.290196078431373, 0.364705882352941, 0.137254901960784>; // HEX #4A5D23
    #declare farge_Dark_Navy = rgb <0.00784313725490196, 0.0274509803921569, 0.364705882352941>; // HEX #02075D
    #declare farge_Dark_Olive_Green = rgb <0.333333333333333, 0.419607843137255, 0.184313725490196>; // HEX #556B2F
    #declare farge_Dark_Orange = rgb <1, 0.549019607843137, 0>; // HEX #FF8C00
    #declare farge_Dark_Pastel_Blue = rgb <0.466666666666667, 0.619607843137255, 0.796078431372549>; // HEX #779ECB
    #declare farge_Dark_Pastel_Green = rgb <0.0117647058823529, 0.752941176470588, 0.235294117647059>; // HEX #03C03C
    #declare farge_Dark_Pastel_Purple = rgb <0.588235294117647, 0.435294117647059, 0.83921568627451>; // HEX #966FD6
    #declare farge_Dark_Pastel_Red = rgb <0.76078431372549, 0.231372549019608, 0.133333333333333>; // HEX #C23B22
    #declare farge_Dark_Pink = rgb <0.905882352941176, 0.329411764705882, 0.501960784313725>; // HEX #E75480
    #declare farge_Dark_Powder_Blue = rgb <0, 0.2, 0.6>; // HEX #003399
    #declare farge_Dark_Puce = rgb <0.309803921568627, 0.227450980392157, 0.235294117647059>; // HEX #4F3A3C
    #declare farge_Dark_Purple = rgb <0.188235294117647, 0.0980392156862745, 0.203921568627451>; // HEX #301934
    #declare farge_Dark_Raspberry = rgb <0.529411764705882, 0.149019607843137, 0.341176470588235>; // HEX #872657
    #declare farge_Dark_Red = rgb <0.545098039215686, 0, 0>; // HEX #8B0000
    #declare farge_Dark_Red_Kurobeni = rgb <0.137254901960784, 0.0980392156862745, 0.117647058823529>; // HEX #23191E
    #declare farge_Dark_Salmon = rgb <0.913725490196078, 0.588235294117647, 0.47843137254902>; // HEX #E9967A
    #declare farge_Dark_Scarlet = rgb <0.337254901960784, 0.0117647058823529, 0.0980392156862745>; // HEX #560319
    #declare farge_Dark_Sienna = rgb <0.235294117647059, 0.0784313725490196, 0.0784313725490196>; // HEX #3C1414
    #declare farge_Dark_Silver = rgb <0.443137254901961, 0.43921568627451, 0.431372549019608>; // HEX #71706E
    #declare farge_Dark_Sky_Blue = rgb <0.549019607843137, 0.745098039215686, 0.83921568627451>; // HEX #8CBED6
    #declare farge_Dark_Slate_Blue = rgb <0.282352941176471, 0.23921568627451, 0.545098039215686>; // HEX #483D8B
    #declare farge_Dark_Spring_Green = rgb <0.0901960784313725, 0.447058823529412, 0.270588235294118>; // HEX #177245
    #declare farge_Dark_Tan = rgb <0.568627450980392, 0.505882352941176, 0.317647058823529>; // HEX #918151
    #declare farge_Dark_Tangerine = rgb <1, 0.658823529411765, 0.0705882352941176>; // HEX #FFA812
    #declare farge_Dark_Taupe = rgb <0.27843137254902, 0.235294117647059, 0.192156862745098>; // HEX #473C31
    #declare farge_Dark_Terra_Cotta = rgb <0.8, 0.305882352941176, 0.36078431372549>; // HEX #CC4E5C
    #declare farge_Dark_Turquoise = rgb <0, 0.807843137254902, 0.819607843137255>; // HEX #00CED1
    #declare farge_Dark_Vanilla = rgb <0.819607843137255, 0.745098039215686, 0.658823529411765>; // HEX #D1BEA8
    #declare farge_Dark_Violet = rgb <0.580392156862745, 0, 0.827450980392157>; // HEX #9400D3
    #declare farge_Dark_Yellow = rgb <0.607843137254902, 0.529411764705882, 0.0470588235294118>; // HEX #9B870C
    #declare farge_Dartmouth_Green = rgb <0, 0.43921568627451, 0.235294117647059>; // HEX #00703C
    #declare farge_Dawn_color_Akebono_iro = rgb <0.980392156862745, 0.482352941176471, 0.384313725490196>; // HEX #FA7B62
    #declare farge_Daylily_colored_Kanzo_iro = rgb <1, 0.537254901960784, 0.211764705882353>; // HEX #FF8936
    #declare farge_Debian_Red = rgb <0.843137254901961, 0.0392156862745098, 0.325490196078431>; // HEX #D70A53
    #declare farge_Decaying_leaves_color_Kuchiba_iro = rgb <0.835294117647059, 0.470588235294118, 0.207843137254902>; // HEX #D57835
    #declare farge_Deep_Amethyst = rgb <0.611764705882353, 0.541176470588235, 0.643137254901961>; // HEX #9C8AA4
    #declare farge_Deep_Carmine = rgb <0.662745098039216, 0.125490196078431, 0.243137254901961>; // HEX #A9203E
    #declare farge_Deep_Carmine_Pink = rgb <0.937254901960784, 0.188235294117647, 0.219607843137255>; // HEX #EF3038
    #declare farge_Deep_Carrot_Orange = rgb <0.913725490196078, 0.411764705882353, 0.172549019607843>; // HEX #E9692C
    #declare farge_Deep_Champagne = rgb <0.980392156862745, 0.83921568627451, 0.647058823529412>; // HEX #FAD6A5
    #declare farge_Deep_Chestnut = rgb <0.725490196078431, 0.305882352941176, 0.282352941176471>; // HEX #B94E48
    #declare farge_Deep_Coffee = rgb <0.43921568627451, 0.258823529411765, 0.254901960784314>; // HEX #704241
    #declare farge_Deep_Dumpling = rgb <0.607843137254902, 0.207843137254902, 0.105882352941176>; // HEX #9B351B
    #declare farge_Deep_Fuchsia = rgb <0.752941176470588, 0.329411764705882, 0.752941176470588>; // HEX #C054C0
    #declare farge_Deep_Green = rgb <0.0196078431372549, 0.4, 0.0313725490196078>; // HEX #056608
    #declare farge_Deep_Green_Cyan_Turquoise = rgb <0.0549019607843137, 0.486274509803922, 0.380392156862745>; // HEX #0E7C61
    #declare farge_Deep_Jungle_Green = rgb <0, 0.294117647058824, 0.286274509803922>; // HEX #004B49
    #declare farge_Deep_Koamaru = rgb <0.2, 0.2, 0.4>; // HEX #333366
    #declare farge_Deep_Lemon = rgb <0.96078431372549, 0.780392156862745, 0.101960784313725>; // HEX #F5C71A
    #declare farge_Deep_Lilac = rgb <0.6, 0.333333333333333, 0.733333333333333>; // HEX #9955BB
    #declare farge_Deep_Magenta = rgb <0.8, 0, 0.8>; // HEX #CC00CC
    #declare farge_Deep_Maroon = rgb <0.509803921568627, 0, 0>; // HEX #820000
    #declare farge_Deep_Mauve = rgb <0.827450980392157, 0.447058823529412, 0.827450980392157>; // HEX #D372D3
    #declare farge_Deep_Moss_Green = rgb <0.203921568627451, 0.368627450980392, 0.227450980392157>; // HEX #345E3A
    #declare farge_Deep_Peach = rgb <1, 0.792156862745098, 0.643137254901961>; // HEX #FFCAA4
    #declare farge_Deep_Pink = rgb <1, 0.0784313725490196, 0.576470588235294>; // HEX #FF1493
    #declare farge_Deep_Puce = rgb <0.662745098039216, 0.36078431372549, 0.407843137254902>; // HEX #A95C68
    #declare farge_Deep_Purple_Kokimurasaki = rgb <0.227450980392157, 0.141176470588235, 0.231372549019608>; // HEX #3A243B
    #declare farge_Deep_Red = rgb <0.52156862745098, 0.00392156862745098, 0.00392156862745098>; // HEX #850101
    #declare farge_Deep_Ruby = rgb <0.517647058823529, 0.247058823529412, 0.356862745098039>; // HEX #843F5B
    #declare farge_Deep_Saffron = rgb <1, 0.6, 0.2>; // HEX #FF9933
    #declare farge_Deep_Scarlet_Kokiake = rgb <0.482352941176471, 0.231372549019608, 0.227450980392157>; // HEX #7B3B3A
    #declare farge_Deep_Sky_Blue = rgb <0, 0.749019607843137, 1>; // HEX #00BFFF
    #declare farge_Deep_Spring_Bud = rgb <0.329411764705882, 0.415686274509804, 0.180392156862745>; // HEX #546A2E
    #declare farge_Deep_Taupe = rgb <0.494117647058824, 0.368627450980392, 0.376470588235294>; // HEX #7E5E60
    #declare farge_Deep_Tuscan_Red = rgb <0.4, 0.258823529411765, 0.301960784313725>; // HEX #66424D
    #declare farge_Deep_violet = rgb <0.2, 0, 0.4>; // HEX #330066
    #declare farge_Deer = rgb <0.729411764705882, 0.529411764705882, 0.349019607843137>; // HEX #BA8759
    #declare farge_Delft_Blue = rgb <0.12156862745098, 0.188235294117647, 0.368627450980392>; // HEX #1F305E
    #declare farge_Delicate_Girl_Blue = rgb <0.415686274509804, 0.698039215686274, 0.792156862745098>; // HEX #6AB2CA
    #declare farge_Desaturated_Cyan = rgb <0.4, 0.6, 0.6>; // HEX #669999
    #declare farge_Desert = rgb <0.756862745098039, 0.603921568627451, 0.419607843137255>; // HEX #C19A6B
    #declare farge_Desire = rgb <0.917647058823529, 0.235294117647059, 0.325490196078431>; // HEX #EA3C53
    #declare farge_Diamond = rgb <0.725490196078431, 0.949019607843137, 1>; // HEX #B9F2FF
    #declare farge_Dim_Gray = rgb <0.411764705882353, 0.411764705882353, 0.411764705882353>; // HEX #696969
    #declare farge_Dingy_Dungeon = rgb <0.772549019607843, 0.192156862745098, 0.317647058823529>; // HEX #C53151
    #declare farge_Dirt = rgb <0.607843137254902, 0.462745098039216, 0.325490196078431>; // HEX #9B7653
    #declare farge_Dirty_brown = rgb <0.709803921568627, 0.396078431372549, 0.117647058823529>; // HEX #B5651E
    #declare farge_Dirty_white = rgb <0.909803921568627, 0.894117647058824, 0.788235294117647>; // HEX #E8E4C9
    #declare farge_Disappearing_purple_Metsushi = rgb <0.247058823529412, 0.192156862745098, 0.227450980392157>; // HEX #3F313A
    #declare farge_Dodger_Blue = rgb <0.117647058823529, 0.564705882352941, 1>; // HEX #1E90FF
    #declare farge_Dodie_yellow = rgb <0.996078431372549, 0.964705882352941, 0.356862745098039>; // HEX #FEF65B
    #declare farge_Dogwood_Rose = rgb <0.843137254901961, 0.0941176470588235, 0.407843137254902>; // HEX #D71868
    #declare farge_Dollar_Bill = rgb <0.52156862745098, 0.733333333333333, 0.396078431372549>; // HEX #85BB65
    #declare farge_Dolphin_gray = rgb <0.509803921568627, 0.556862745098039, 0.517647058823529>; // HEX #828E84
    #declare farge_Donkey_Brown = rgb <0.4, 0.298039215686275, 0.152941176470588>; // HEX #664C27
    #declare farge_Douban_Blue = rgb <0.141176470588235, 0.588235294117647, 0.803921568627451>; // HEX #2496CD
    #declare farge_Douban_Green = rgb <0.180392156862745, 0.588235294117647, 0.23921568627451>; // HEX #2E963D
    #declare farge_Douban_Light_Yellow = rgb <0.968627450980392, 0.772549019607843, 0.556862745098039>; // HEX #F7C58E
    #declare farge_Dove_feather_grey_Hatobanezumi = rgb <0.458823529411765, 0.364705882352941, 0.356862745098039>; // HEX #755D5B
    #declare farge_Drab = rgb <0.588235294117647, 0.443137254901961, 0.0901960784313725>; // HEX #967117
    #declare farge_Duck_Blue = rgb <0, 0.466666666666667, 0.568627450980392>; // HEX #007791
    #declare farge_Dull_blue_Aonibi = rgb <0.309803921568627, 0.286274509803922, 0.266666666666667>; // HEX #4F4944
    #declare farge_Durian = rgb <0.690196078431373, 0.474509803921569, 0.223529411764706>; // HEX #B07939
    #declare farge_Durian_White = rgb <0.901960784313726, 0.815686274509804, 0.670588235294118>; // HEX #E6D0AB
    #declare farge_Durian_Yellow = rgb <0.882352941176471, 0.741176470588235, 0.152941176470588>; // HEX #E1BD27
    #declare farge_Dust_Storm = rgb <0.898039215686275, 0.8, 0.788235294117647>; // HEX #E5CCC9
    #declare farge_Dutch_White = rgb <0.937254901960784, 0.874509803921569, 0.733333333333333>; // HEX #EFDFBB
    #declare farge_Dyestalk_red_Bengara_iro = rgb <0.568627450980392, 0.196078431372549, 0.145098039215686>; // HEX #913225
    #declare farge_Earth_Yellow = rgb <0.882352941176471, 0.662745098039216, 0.372549019607843>; // HEX #E1A95F
    #declare farge_Earthtone = rgb <0.364705882352941, 0.227450980392157, 0.101960784313725>; // HEX #5D3A1A
    #declare farge_Ebony = rgb <0.333333333333333, 0.364705882352941, 0.313725490196078>; // HEX #555D50
    #declare farge_Ecru = rgb <0.76078431372549, 0.698039215686274, 0.501960784313725>; // HEX #C2B280
    #declare farge_Egg_colored_Tamago_iro = rgb <1, 0.650980392156863, 0.192156862745098>; // HEX #FFA631
    #declare farge_Eggshell = rgb <0.941176470588235, 0.917647058823529, 0.83921568627451>; // HEX #F0EAD6
    #declare farge_Eggshell_paper_colored_Torinoko_iro = rgb <0.886274509803922, 0.745098039215686, 0.623529411764706>; // HEX #E2BE9F
    #declare farge_Egyptian_Blue = rgb <0.0627450980392157, 0.203921568627451, 0.650980392156863>; // HEX #1034A6
    #declare farge_Elderberry = rgb <0.0901960784313725, 0.0941176470588235, 0.168627450980392>; // HEX #17182B
    #declare farge_Electric_Blue = rgb <0.490196078431373, 0.976470588235294, 1>; // HEX #7DF9FF
    #declare farge_Electric_brown = rgb <0.709803921568627, 0.384313725490196, 0.341176470588235>; // HEX #B56257
    #declare farge_Electric_Crimson = rgb <1, 0, 0.247058823529412>; // HEX #FF003F
    #declare farge_Electric_Indigo = rgb <0.435294117647059, 0, 1>; // HEX #6F00FF
    #declare farge_Electric_Lavender = rgb <0.952941176470588, 0.729411764705882, 1>; // HEX #F3BAFF
    #declare farge_Electric_orange = rgb <1, 0.207843137254902, 0.0117647058823529>; // HEX #FF3503
    #declare farge_Electric_pink = rgb <0.964705882352941, 0.149019607843137, 0.505882352941176>; // HEX #F62681
    #declare farge_Electric_Purple = rgb <0.749019607843137, 0, 1>; // HEX #BF00FF
    #declare farge_Electric_red = rgb <0.901960784313726, 0, 0>; // HEX #E60000
    #declare farge_Electric_Violet = rgb <0.56078431372549, 0, 1>; // HEX #8F00FF
    #declare farge_Electric_Yellow = rgb <1, 1, 0.2>; // HEX #FFFF33
    #declare farge_Emerald = rgb <0.313725490196078, 0.784313725490196, 0.470588235294118>; // HEX #50C878
    #declare farge_Emerald_green = rgb <0.0156862745098039, 0.388235294117647, 0.0274509803921569>; // HEX #046307
    #declare farge_Eminence = rgb <0.423529411764706, 0.188235294117647, 0.509803921568627>; // HEX #6C3082
    #declare farge_English_Green = rgb <0.105882352941176, 0.301960784313725, 0.243137254901961>; // HEX #1B4D3E
    #declare farge_English_Lavender = rgb <0.705882352941177, 0.513725490196078, 0.584313725490196>; // HEX #B48395
    #declare farge_English_Red = rgb <0.670588235294118, 0.294117647058824, 0.32156862745098>; // HEX #AB4B52
    #declare farge_English_Violet = rgb <0.337254901960784, 0.235294117647059, 0.36078431372549>; // HEX #563C5C
    #declare farge_Erin = rgb <0, 1, 0.250980392156863>; // HEX #00FF40
    #declare farge_Eton_Blue = rgb <0.588235294117647, 0.784313725490196, 0.635294117647059>; // HEX #96C8A2
    #declare farge_Eucalyptus = rgb <0.266666666666667, 0.843137254901961, 0.658823529411765>; // HEX #44D7A8
    #declare farge_Facebook_Blue = rgb <0.223529411764706, 0.337254901960784, 0.611764705882353>; // HEX #39569C
    #declare farge_Faded_Sen_no_Rikyus_tea_Rikyushiracha = rgb <0.690196078431373, 0.572549019607843, 0.47843137254902>; // HEX #B0927A
    #declare farge_Faded_spicy_red_brown_Sodenkaracha = rgb <0.607843137254902, 0.325490196078431, 0.247058823529412>; // HEX #9B533F
    #declare farge_Fake_purple_Nisemurasaki = rgb <0.262745098039216, 0.141176470588235, 0.164705882352941>; // HEX #43242A
    #declare farge_Fallow = rgb <0.756862745098039, 0.603921568627451, 0.419607843137255>; // HEX #C19A6B
    #declare farge_Falu_Red = rgb <0.501960784313725, 0.0941176470588235, 0.0941176470588235>; // HEX #801818
    #declare farge_Fandango = rgb <0.709803921568627, 0.2, 0.537254901960784>; // HEX #B53389
    #declare farge_Fandango_Pink = rgb <0.870588235294118, 0.32156862745098, 0.52156862745098>; // HEX #DE5285
    #declare farge_Fashion_Fuchsia = rgb <0.956862745098039, 0, 0.631372549019608>; // HEX #F400A1
    #declare farge_Fawn = rgb <0.898039215686275, 0.666666666666667, 0.43921568627451>; // HEX #E5AA70
    #declare farge_Feldgrau = rgb <0.301960784313725, 0.364705882352941, 0.325490196078431>; // HEX #4D5D53
    #declare farge_Feldspar = rgb <0.992156862745098, 0.835294117647059, 0.690196078431373>; // HEX #FDD5B0
    #declare farge_Fern_Green = rgb <0.309803921568627, 0.474509803921569, 0.258823529411765>; // HEX #4F7942
    #declare farge_Ferrari_Red = rgb <1, 0.156862745098039, 0>; // HEX #FF2800
    #declare farge_Field_Drab = rgb <0.423529411764706, 0.329411764705882, 0.117647058823529>; // HEX #6C541E
    #declare farge_Fiery_Rose = rgb <1, 0.329411764705882, 0.43921568627451>; // HEX #FF5470
    #declare farge_Finch_brown_Hiwacha = rgb <0.584313725490196, 0.482352941176471, 0.219607843137255>; // HEX #957B38
    #declare farge_Fire_Engine_Red = rgb <0.807843137254902, 0.125490196078431, 0.16078431372549>; // HEX #CE2029
    #declare farge_Fire_Opal = rgb <0.913725490196078, 0.36078431372549, 0.294117647058824>; // HEX #E95C4B
    #declare farge_Firebrick = rgb <0.698039215686274, 0.133333333333333, 0.133333333333333>; // HEX #B22222
    #declare farge_Flame = rgb <0.886274509803922, 0.345098039215686, 0.133333333333333>; // HEX #E25822
    #declare farge_Flamingo_Pink = rgb <0.988235294117647, 0.556862745098039, 0.674509803921569>; // HEX #FC8EAC
    #declare farge_Flattery = rgb <0.415686274509804, 0.266666666666667, 0.137254901960784>; // HEX #6A4423
    #declare farge_Flavescent = rgb <0.968627450980392, 0.913725490196078, 0.556862745098039>; // HEX #F7E98E
    #declare farge_Flax = rgb <0.933333333333333, 0.862745098039216, 0.509803921568627>; // HEX #EEDC82
    #declare farge_Flesh = rgb <1, 0.913725490196078, 0.819607843137255>; // HEX #FFE9D1
    #declare farge_Flickr_Blue_1 = rgb <0, 0.388235294117647, 0.862745098039216>; // HEX #0063DC
    #declare farge_Flickr_Blue_2 = rgb <0.129411764705882, 0.419607843137255, 0.83921568627451>; // HEX #216BD6
    #declare farge_Flickr_Pink = rgb <0.984313725490196, 0, 0.505882352941176>; // HEX #FB0081
    #declare farge_Flirt = rgb <0.635294117647059, 0, 0.427450980392157>; // HEX #A2006D
    #declare farge_Flirtatious_indigo_tea_Aikobicha = rgb <0.27843137254902, 0.247058823529412, 0.176470588235294>; // HEX #473F2D
    #declare farge_Floral_leaf_colored_Hanaba_iro = rgb <1, 0.725490196078431, 0.305882352941176>; // HEX #FFB94E
    #declare farge_Floral_White = rgb <1, 0.980392156862745, 0.941176470588235>; // HEX #FFFAF0
    #declare farge_Flower_girl = rgb <0.956862745098039, 0.596078431372549, 0.67843137254902>; // HEX #F498AD
    #declare farge_Fluorescent_Blue = rgb <0.0823529411764706, 0.956862745098039, 0.933333333333333>; // HEX #15F4EE
    #declare farge_Fluorescent_Orange = rgb <1, 0.749019607843137, 0>; // HEX #FFBF00
    #declare farge_Fluorescent_Pink = rgb <1, 0.0784313725490196, 0.572549019607843>; // HEX #FF1492
    #declare farge_Fluorescent_Yellow = rgb <0.8, 1, 0>; // HEX #CCFF00
    #declare farge_Folly = rgb <1, 0, 0.309803921568627>; // HEX #FF004F
    #declare farge_Foreign_crimson_Karakurenai = rgb <0.788235294117647, 0.12156862745098, 0.215686274509804>; // HEX #C91F37
    #declare farge_Forest_Green_Traditional = rgb <0.00392156862745098, 0.266666666666667, 0.129411764705882>; // HEX #014421
    #declare farge_Forest_Green_Web = rgb <0.133333333333333, 0.545098039215686, 0.133333333333333>; // HEX #228B22
    #declare farge_Fox_color_Kitsune_iro = rgb <0.596078431372549, 0.337254901960784, 0.16078431372549>; // HEX #985629
    #declare farge_French_Beige = rgb <0.650980392156863, 0.482352941176471, 0.356862745098039>; // HEX #A67B5B
    #declare farge_French_Bistre = rgb <0.52156862745098, 0.427450980392157, 0.301960784313725>; // HEX #856D4D
    #declare farge_French_Blue = rgb <0, 0.447058823529412, 0.733333333333333>; // HEX #0072BB
    #declare farge_French_Fuchsia = rgb <0.992156862745098, 0.247058823529412, 0.572549019607843>; // HEX #FD3F92
    #declare farge_French_Lilac = rgb <0.525490196078431, 0.376470588235294, 0.556862745098039>; // HEX #86608E
    #declare farge_French_Lime = rgb <0.619607843137255, 0.992156862745098, 0.219607843137255>; // HEX #9EFD38
    #declare farge_French_Mauve = rgb <0.831372549019608, 0.450980392156863, 0.831372549019608>; // HEX #D473D4
    #declare farge_French_Pink = rgb <0.992156862745098, 0.423529411764706, 0.619607843137255>; // HEX #FD6C9E
    #declare farge_French_Plum = rgb <0.505882352941176, 0.0784313725490196, 0.325490196078431>; // HEX #811453
    #declare farge_French_Puce = rgb <0.305882352941176, 0.0862745098039216, 0.0352941176470588>; // HEX #4E1609
    #declare farge_French_Raspberry = rgb <0.780392156862745, 0.172549019607843, 0.282352941176471>; // HEX #C72C48
    #declare farge_French_Rose = rgb <0.964705882352941, 0.290196078431373, 0.541176470588235>; // HEX #F64A8A
    #declare farge_French_Sky_Blue = rgb <0.466666666666667, 0.709803921568627, 0.996078431372549>; // HEX #77B5FE
    #declare farge_French_Violet = rgb <0.533333333333333, 0.0235294117647059, 0.807843137254902>; // HEX #8806CE
    #declare farge_French_Wine = rgb <0.674509803921569, 0.117647058823529, 0.266666666666667>; // HEX #AC1E44
    #declare farge_Fresh_Air = rgb <0.650980392156863, 0.905882352941176, 1>; // HEX #A6E7FF
    #declare farge_Fresh_onion_Moegi = rgb <0.356862745098039, 0.537254901960784, 0.188235294117647>; // HEX #5B8930
    #declare farge_Fuchsia_Pink = rgb <1, 0.466666666666667, 1>; // HEX #FF77FF
    #declare farge_Fuchsia_Purple = rgb <0.8, 0.223529411764706, 0.482352941176471>; // HEX #CC397B
    #declare farge_Fuchsia_Rose = rgb <0.780392156862745, 0.262745098039216, 0.458823529411765>; // HEX #C74375
    #declare farge_Fulvous = rgb <0.894117647058824, 0.517647058823529, 0>; // HEX #E48400
    #declare farge_Fuzzy_Wuzzy = rgb <0.8, 0.4, 0.4>; // HEX #CC6666
    #declare farge_Gainsboro = rgb <0.862745098039216, 0.862745098039216, 0.862745098039216>; // HEX #DCDCDC
    #declare farge_Gamboge = rgb <0.894117647058824, 0.607843137254902, 0.0588235294117647>; // HEX #E49B0F
    #declare farge_Gamboge_Orange_Brown = rgb <0.6, 0.4, 0>; // HEX #996600
    #declare farge_Gamboge_Too = rgb <1, 0.713725490196078, 0.117647058823529>; // HEX #FFB61E
    #declare farge_Gargoyle_Gas = rgb <1, 0.874509803921569, 0.274509803921569>; // HEX #FFDF46
    #declare farge_Garnet = rgb <0.450980392156863, 0.211764705882353, 0.207843137254902>; // HEX #733635
    #declare farge_Generic_Viridian = rgb <0, 0.498039215686275, 0.4>; // HEX #007F66
    #declare farge_Ghost_White = rgb <0.972549019607843, 0.972549019607843, 1>; // HEX #F8F8FF
    #declare farge_Giants_Club = rgb <0.690196078431373, 0.36078431372549, 0.32156862745098>; // HEX #B05C52
    #declare farge_Giants_Orange = rgb <0.996078431372549, 0.352941176470588, 0.113725490196078>; // HEX #FE5A1D
    #declare farge_Gin = rgb <0.847058823529412, 0.894117647058824, 0.737254901960784>; // HEX #D8E4BC
    #declare farge_Ginger = rgb <0.686274509803922, 0.392156862745098, 0>; // HEX #AF6400
    #declare farge_Glaucous = rgb <0.376470588235294, 0.509803921568627, 0.713725490196078>; // HEX #6082B6
    #declare farge_Glazed_persimmon_Terigaki = rgb <0.827450980392157, 0.305882352941176, 0.211764705882353>; // HEX #D34E36
    #declare farge_Glitter = rgb <0.898039215686275, 0.909803921568627, 0.980392156862745>; // HEX #E5E8FA
    #declare farge_Go_Green = rgb <0, 0.670588235294118, 0.4>; // HEX #00AB66
    #declare farge_Gold = rgb <0.647058823529412, 0.486274509803922, 0>; // HEX #A57C00
    #declare farge_Gold_brown_Yamabukicha = rgb <0.796078431372549, 0.494117647058824, 0.12156862745098>; // HEX #CB7E1F
    #declare farge_Gold_foil = rgb <0.741176470588235, 0.607843137254902, 0.0862745098039216>; // HEX #BD9B16
    #declare farge_Gold_Metallic = rgb <0.831372549019608, 0.686274509803922, 0.215686274509804>; // HEX #D4AF37
    #declare farge_Gold_Web_Golden = rgb <1, 0.843137254901961, 0>; // HEX #FFD700
    #declare farge_Golden_Brown = rgb <0.6, 0.396078431372549, 0.0823529411764706>; // HEX #996515
    #declare farge_Golden_brown_Kincha = rgb <0.776470588235294, 0.419607843137255, 0.152941176470588>; // HEX #C66B27
    #declare farge_Golden_fallen_leaves_Kikuchiba = rgb <0.886274509803922, 0.611764705882353, 0.270588235294118>; // HEX #E29C45
    #declare farge_Golden_grey_bamboo_Kinsusutake = rgb <0.490196078431373, 0.305882352941176, 0.176470588235294>; // HEX #7D4E2D
    #declare farge_Golden_oak_Kitsurubami = rgb <0.733333333333333, 0.505882352941176, 0.254901960784314>; // HEX #BB8141
    #declare farge_Golden_Poppy = rgb <0.988235294117647, 0.76078431372549, 0>; // HEX #FCC200
    #declare farge_Golden_Yellow = rgb <1, 0.874509803921569, 0>; // HEX #FFDF00
    #declare farge_Golden_yellow_Yamabuki_iro = rgb <1, 0.643137254901961, 0>; // HEX #FFA400
    #declare farge_Goldenrod = rgb <0.854901960784314, 0.647058823529412, 0.125490196078431>; // HEX #DAA520
    #declare farge_Google_Chrome_blue = rgb <0.298039215686275, 0.545098039215686, 0.96078431372549>; // HEX #4C8BF5
    #declare farge_Google_Chrome_green = rgb <0.101960784313725, 0.635294117647059, 0.376470588235294>; // HEX #1AA260
    #declare farge_Google_Chrome_red = rgb <0.870588235294118, 0.32156862745098, 0.274509803921569>; // HEX #DE5246
    #declare farge_Google_Chrome_yellow = rgb <1, 0.807843137254902, 0.266666666666667>; // HEX #FFCE44
    #declare farge_Goryeo_storeroom_Korainando = rgb <0.125490196078431, 0.219607843137255, 0.219607843137255>; // HEX #203838
    #declare farge_Granny_Smith_Apple = rgb <0.658823529411765, 0.894117647058824, 0.627450980392157>; // HEX #A8E4A0
    #declare farge_Grape = rgb <0.435294117647059, 0.176470588235294, 0.658823529411765>; // HEX #6F2DA8
    #declare farge_Grape_mouse_Budonezumi = rgb <0.388235294117647, 0.258823529411765, 0.294117647058824>; // HEX #63424B
    #declare farge_Gray_Asparagus = rgb <0.274509803921569, 0.349019607843137, 0.270588235294118>; // HEX #465945
    #declare farge_Gray_Blue = rgb <0.549019607843137, 0.572549019607843, 0.674509803921569>; // HEX #8C92AC
    #declare farge_Green = rgb <0, 0.501960784313725, 0.00392156862745098>; // HEX #008001
    #declare farge_Green_bamboo_color_Aotake_iro = rgb <0, 0.392156862745098, 0.258823529411765>; // HEX #006442
    #declare farge_Green_Blue = rgb <0.0666666666666667, 0.392156862745098, 0.705882352941177>; // HEX #1164B4
    #declare farge_Green_Cola = rgb <0.298039215686275, 0.447058823529412, 0.113725490196078>; // HEX #4C721D
    #declare farge_Green_Cyan = rgb <0, 0.6, 0.4>; // HEX #009966
    #declare farge_Green_Midori = rgb <0.164705882352941, 0.376470588235294, 0.231372549019608>; // HEX #2A603B
    #declare farge_Green_Munsell = rgb <0, 0.658823529411765, 0.466666666666667>; // HEX #00A877
    #declare farge_Green_NCS = rgb <0, 0.623529411764706, 0.419607843137255>; // HEX #009F6B
    #declare farge_Green_Pantone = rgb <0, 0.67843137254902, 0.262745098039216>; // HEX #00AD43
    #declare farge_Green_Pigment = rgb <0, 0.647058823529412, 0.313725490196078>; // HEX #00A550
    #declare farge_Green_RYB = rgb <0.4, 0.690196078431373, 0.196078431372549>; // HEX #66B032
    #declare farge_Green_slime = rgb <0.396078431372549, 1, 0>; // HEX #65FF00
    #declare farge_Green_tea_colored_Sencha_iro = rgb <0.509803921568627, 0.294117647058824, 0.207843137254902>; // HEX #824B35
    #declare farge_Green_Web = rgb <0, 0.501960784313725, 0>; // HEX #008000
    #declare farge_Green_Yellow = rgb <0.67843137254902, 1, 0.184313725490196>; // HEX #ADFF2F
    #declare farge_Greenfinch_color_Hiwa_iro = rgb <0.741176470588235, 0.662745098039216, 0.156862745098039>; // HEX #BDA928
    #declare farge_Greyed_red_Ginshu = rgb <0.737254901960784, 0.176470588235294, 0.16078431372549>; // HEX #BC2D29
    #declare farge_Greyish_dark_green_Rikyunezumi = rgb <0.396078431372549, 0.384313725490196, 0.333333333333333>; // HEX #656255
    #declare farge_Grizzly = rgb <0.529411764705882, 0.341176470588235, 0.0901960784313725>; // HEX #875717
    #declare farge_Grullo = rgb <0.662745098039216, 0.603921568627451, 0.525490196078431>; // HEX #A99A86
    #declare farge_Gunmetal = rgb <0.164705882352941, 0.203921568627451, 0.223529411764706>; // HEX #2A3439
    #declare farge_Guyabano = rgb <0.972549019607843, 0.972549019607843, 0.972549019607843>; // HEX #F8F8F8
    #declare farge_Halaya_Ube = rgb <0.4, 0.219607843137255, 0.329411764705882>; // HEX #663854
    #declare farge_Half_color_Hashita_iro = rgb <0.552941176470588, 0.376470588235294, 0.549019607843137>; // HEX #8D608C
    #declare farge_Halloween_orange = rgb <0.92156862745098, 0.380392156862745, 0.137254901960784>; // HEX #EB6123
    #declare farge_Han_Blue = rgb <0.266666666666667, 0.423529411764706, 0.811764705882353>; // HEX #446CCF
    #declare farge_Han_Purple = rgb <0.32156862745098, 0.0941176470588235, 0.980392156862745>; // HEX #5218FA
    #declare farge_Hansa_Yellow = rgb <0.913725490196078, 0.83921568627451, 0.419607843137255>; // HEX #E9D66B
    #declare farge_Harbor_rat_Minatonezumi = rgb <0.458823529411765, 0.490196078431373, 0.458823529411765>; // HEX #757D75
    #declare farge_Harlequin = rgb <0.247058823529412, 1, 0>; // HEX #3FFF00
    #declare farge_Harlequin_Green = rgb <0.274509803921569, 0.796078431372549, 0.0941176470588235>; // HEX #46CB18
    #declare farge_Harmonious_rose = rgb <0.949019607843137, 0.611764705882353, 0.717647058823529>; // HEX #F29CB7
    #declare farge_Harvard_Crimson = rgb <0.784313725490196, 0, 0.0862745098039216>; // HEX #C80016
    #declare farge_Harvest_Gold = rgb <0.854901960784314, 0.568627450980392, 0>; // HEX #DA9100
    #declare farge_Hawaii_blue = rgb <0, 0.764705882352941, 0.890196078431372>; // HEX #00C3E3
    #declare farge_Heart_Gold = rgb <0.498039215686275, 0.498039215686275, 0>; // HEX #7F7F00
    #declare farge_Heat_Wave = rgb <1, 0.47843137254902, 0>; // HEX #FF7A00
    #declare farge_Heliotrope = rgb <0.874509803921569, 0.450980392156863, 1>; // HEX #DF73FF
    #declare farge_Heliotrope_Gray = rgb <0.666666666666667, 0.596078431372549, 0.662745098039216>; // HEX #AA98A9
    #declare farge_Heliotrope_Magenta = rgb <0.666666666666667, 0, 0.733333333333333>; // HEX #AA00BB
    #declare farge_Hollywood_Cerise = rgb <0.956862745098039, 0, 0.631372549019608>; // HEX #F400A1
    #declare farge_Honeydew = rgb <0.941176470588235, 1, 0.941176470588235>; // HEX #F0FFF0
    #declare farge_Honolulu_Blue = rgb <0, 0.427450980392157, 0.690196078431373>; // HEX #006DB0
    #declare farge_Hookers_Green = rgb <0.286274509803922, 0.474509803921569, 0.419607843137255>; // HEX #49796B
    #declare farge_Horsetail_color_Tokusa_iro = rgb <0.23921568627451, 0.364705882352941, 0.258823529411765>; // HEX #3D5D42
    #declare farge_Hot_Magenta = rgb <1, 0.113725490196078, 0.807843137254902>; // HEX #FF1DCE
    #declare farge_Hot_Pink = rgb <1, 0.411764705882353, 0.705882352941177>; // HEX #FF69B4
    #declare farge_Huawei_Red = rgb <0.811764705882353, 0.0392156862745098, 0.172549019607843>; // HEX #CF0A2C
    #declare farge_Hunter_Green = rgb <0.207843137254902, 0.368627450980392, 0.231372549019608>; // HEX #355E3B
    #declare farge_Ibis_wing_color_Tokiha_iro = rgb <0.96078431372549, 0.56078431372549, 0.517647058823529>; // HEX #F58F84
    #declare farge_Iceberg = rgb <0.443137254901961, 0.650980392156863, 0.823529411764706>; // HEX #71A6D2
    #declare farge_Iced_tea = rgb <0.572549019607843, 0.235294117647059, 0.00392156862745098>; // HEX #923C01
    #declare farge_Icterine = rgb <0.988235294117647, 0.968627450980392, 0.368627450980392>; // HEX #FCF75E
    #declare farge_Iguana_green = rgb <0.443137254901961, 0.737254901960784, 0.470588235294118>; // HEX #71BC78
    #declare farge_Imperial = rgb <0.376470588235294, 0.184313725490196, 0.419607843137255>; // HEX #602F6B
    #declare farge_Imperial_Blue = rgb <0, 0.137254901960784, 0.584313725490196>; // HEX #002395
    #declare farge_Imperial_Purple = rgb <0.4, 0.00392156862745098, 0.235294117647059>; // HEX #66013C
    #declare farge_Imperial_Red = rgb <0.929411764705882, 0.16078431372549, 0.223529411764706>; // HEX #ED2939
    #declare farge_Inchworm = rgb <0.698039215686274, 0.925490196078431, 0.364705882352941>; // HEX #B2EC5D
    #declare farge_Independence = rgb <0.298039215686275, 0.317647058823529, 0.427450980392157>; // HEX #4C516D
    #declare farge_India_Green = rgb <0.0745098039215686, 0.533333333333333, 0.0313725490196078>; // HEX #138808
    #declare farge_Indian_Red = rgb <0.803921568627451, 0.36078431372549, 0.36078431372549>; // HEX #CD5C5C
    #declare farge_Indian_Yellow = rgb <0.890196078431372, 0.658823529411765, 0.341176470588235>; // HEX #E3A857
    #declare farge_Indigo = rgb <0.294117647058824, 0, 0.509803921568627>; // HEX #4B0082
    #declare farge_Indigo_Codium_fragile_seaweed_brown_Aimirucha = rgb <0.180392156862745, 0.215686274509804, 0.180392156862745>; // HEX #2E372E
    #declare farge_Indigo_Dye = rgb <0, 0.254901960784314, 0.415686274509804>; // HEX #00416A
    #declare farge_Indigo_ink_brown_Aisumicha = rgb <0.223529411764706, 0.203921568627451, 0.196078431372549>; // HEX #393432
    #declare farge_Indigo_rainbow = rgb <0.137254901960784, 0.188235294117647, 0.403921568627451>; // HEX #233067
    #declare farge_Indigo_Web = rgb <0.290196078431373, 0, 0.509803921568627>; // HEX #4A0082
    #declare farge_Indigo_white_Aijiro = rgb <0.92156862745098, 0.964705882352941, 0.968627450980392>; // HEX #EBF6F7
    #declare farge_Infra_red = rgb <1, 0.286274509803922, 0.423529411764706>; // HEX #FF496C
    #declare farge_Ink_color_Sumi_iro = rgb <0.152941176470588, 0.133333333333333, 0.12156862745098>; // HEX #27221F
    #declare farge_Insect_screen_Mushiao = rgb <0.176470588235294, 0.266666666666667, 0.211764705882353>; // HEX #2D4436
    #declare farge_Inside_of_a_bottle_Kamenozoki = rgb <0.776470588235294, 0.76078431372549, 0.713725490196078>; // HEX #C6C2B6
    #declare farge_Interdimensional_blue = rgb <0.211764705882353, 0.0470588235294118, 0.8>; // HEX #360CCC
    #declare farge_International_Klein_Blue = rgb <0, 0.184313725490196, 0.654901960784314>; // HEX #002FA7
    #declare farge_International_Orange_Aerospace = rgb <1, 0.309803921568627, 0>; // HEX #FF4F00
    #declare farge_International_Orange_Engineering = rgb <0.729411764705882, 0.0862745098039216, 0.0470588235294118>; // HEX #BA160C
    #declare farge_International_Orange_Golden_Gate_Bridge = rgb <0.752941176470588, 0.211764705882353, 0.172549019607843>; // HEX #C0362C
    #declare farge_Iris = rgb <0.352941176470588, 0.309803921568627, 0.811764705882353>; // HEX #5A4FCF
    #declare farge_Iris_color_Ayame_iro = rgb <0.462745098039216, 0.207843137254902, 0.407843137254902>; // HEX #763568
    #declare farge_Iron = rgb <0.631372549019608, 0.615686274509804, 0.580392156862745>; // HEX #A19D94
    #declare farge_Iron_color_Tetsu_iro = rgb <0.168627450980392, 0.215686274509804, 0.2>; // HEX #2B3733
    #declare farge_Iron_head_flower_color_Noshimehana_iro = rgb <0.203921568627451, 0.301960784313725, 0.337254901960784>; // HEX #344D56
    #declare farge_Iron_storage_Tetsuonando = rgb <0.168627450980392, 0.215686274509804, 0.211764705882353>; // HEX #2B3736
    #declare farge_Irresistible = rgb <0.701960784313725, 0.266666666666667, 0.423529411764706>; // HEX #B3446C
    #declare farge_Isabelline = rgb <0.956862745098039, 0.941176470588235, 0.925490196078431>; // HEX #F4F0EC
    #declare farge_Islamic_Green = rgb <0, 0.564705882352941, 0>; // HEX #009000
    #declare farge_Italian_ice = rgb <0.913725490196078, 0.964705882352941, 0.937254901960784>; // HEX #E9F6EF
    #declare farge_Italian_leather = rgb <0.388235294117647, 0.352941176470588, 0.32156862745098>; // HEX #635A52
    #declare farge_Italian_roast = rgb <0.564705882352941, 0.4, 0.32156862745098>; // HEX #906652
    #declare farge_Italian_Sky_Blue = rgb <0.698039215686274, 1, 1>; // HEX #B2FFFF
    #declare farge_Ivory = rgb <1, 1, 0.941176470588235>; // HEX #FFFFF0
    #declare farge_Iwai_brown_Iwaicha = rgb <0.368627450980392, 0.333333333333333, 0.270588235294118>; // HEX #5E5545
    #declare farge_Jacarta = rgb <0.23921568627451, 0.196078431372549, 0.364705882352941>; // HEX #3D325D
    #declare farge_Jacko_bean = rgb <0.254901960784314, 0.211764705882353, 0.156862745098039>; // HEX #413628
    #declare farge_Jade = rgb <0, 0.658823529411765, 0.419607843137255>; // HEX #00A86B
    #declare farge_Japanese_Carmine = rgb <0.615686274509804, 0.16078431372549, 0.2>; // HEX #9D2933
    #declare farge_Japanese_Indigo = rgb <0.149019607843137, 0.262745098039216, 0.282352941176471>; // HEX #264348
    #declare farge_Japanese_iris_and_sooty_bamboo_Higosusutake = rgb <0.498039215686275, 0.364705882352941, 0.231372549019608>; // HEX #7F5D3B
    #declare farge_Japanese_laurel = rgb <0.184313725490196, 0.458823529411765, 0.196078431372549>; // HEX #2F7532
    #declare farge_Japanese_triandra_grass_Themeda_japonica_Kariyasu = rgb <0.886274509803922, 0.694117647058824, 0.235294117647059>; // HEX #E2B13C
    #declare farge_Japanese_Violet = rgb <0.356862745098039, 0.196078431372549, 0.337254901960784>; // HEX #5B3256
    #declare farge_Jasmine = rgb <0.972549019607843, 0.870588235294118, 0.494117647058824>; // HEX #F8DE7E
    #declare farge_Jasper = rgb <0.843137254901961, 0.231372549019608, 0.243137254901961>; // HEX #D73B3E
    #declare farge_Jasper_orange = rgb <0.870588235294118, 0.56078431372549, 0.305882352941176>; // HEX #DE8F4E
    #declare farge_Jawad_Chicken_Color = rgb <0.76078431372549, 0.686274509803922, 0.568627450980392>; // HEX #C2AF91
    #declare farge_Jelly_Bean = rgb <0.854901960784314, 0.380392156862745, 0.305882352941176>; // HEX #DA614E
    #declare farge_Jelly_bean_blue = rgb <0.266666666666667, 0.474509803921569, 0.556862745098039>; // HEX #44798E
    #declare farge_Jet = rgb <0.203921568627451, 0.203921568627451, 0.203921568627451>; // HEX #343434
    #declare farge_Jet_stream = rgb <0.733333333333333, 0.815686274509804, 0.788235294117647>; // HEX #BBD0C9
    #declare farge_Jonquil = rgb <0.956862745098039, 0.792156862745098, 0.0862745098039216>; // HEX #F4CA16
    #declare farge_Jordy_Blue = rgb <0.541176470588235, 0.725490196078431, 0.945098039215686>; // HEX #8AB9F1
    #declare farge_June_Bud = rgb <0.741176470588235, 0.854901960784314, 0.341176470588235>; // HEX #BDDA57
    #declare farge_Kelly_Green = rgb <0.298039215686275, 0.733333333333333, 0.0901960784313725>; // HEX #4CBB17
    #declare farge_Kenyan_Copper = rgb <0.486274509803922, 0.109803921568627, 0.0196078431372549>; // HEX #7C1C05
    #declare farge_Keppel = rgb <0.227450980392157, 0.690196078431373, 0.619607843137255>; // HEX #3AB09E
    #declare farge_Khaki_Web = rgb <0.764705882352941, 0.690196078431373, 0.568627450980392>; // HEX #C3B091
    #declare farge_Kimono_storage_Omeshionando = rgb <0.23921568627451, 0.298039215686275, 0.317647058823529>; // HEX #3D4C51
    #declare farge_Kiwi = rgb <0.556862745098039, 0.898039215686275, 0.247058823529412>; // HEX #8EE53F
    #declare farge_Kobe = rgb <0.533333333333333, 0.176470588235294, 0.0901960784313725>; // HEX #882D17
    #declare farge_Kobi = rgb <0.905882352941176, 0.623529411764706, 0.768627450980392>; // HEX #E79FC4
    #declare farge_Kobicha = rgb <0.419607843137255, 0.266666666666667, 0.137254901960784>; // HEX #6B4423
    #declare farge_Kombu_Green = rgb <0.207843137254902, 0.258823529411765, 0.188235294117647>; // HEX #354230
    #declare farge_Ksu_Purple = rgb <0.317647058823529, 0.156862745098039, 0.533333333333333>; // HEX #512888
    #declare farge_KU_Crimson = rgb <0.909803921568627, 0, 0.0509803921568627>; // HEX #E8000D
    #declare farge_Kumquat = rgb <0.984313725490196, 0.6, 0.0705882352941176>; // HEX #FB9912
    #declare farge_La_Salle_Green = rgb <0.0274509803921569, 0.466666666666667, 0.184313725490196>; // HEX #07772F
    #declare farge_Languid_Lavender = rgb <0.83921568627451, 0.792156862745098, 0.866666666666667>; // HEX #D6CADD
    #declare farge_Lanzones = rgb <0.87843137254902, 0.737254901960784, 0.356862745098039>; // HEX #E0BC5B
    #declare farge_Lapis_Lazuli = rgb <0.149019607843137, 0.380392156862745, 0.611764705882353>; // HEX #26619C
    #declare farge_Lapis_lazuli_color_Ruri_iro = rgb <0.12156862745098, 0.27843137254902, 0.533333333333333>; // HEX #1F4788
    #declare farge_Laurel_Green = rgb <0.662745098039216, 0.729411764705882, 0.615686274509804>; // HEX #A9BA9D
    #declare farge_Lava = rgb <0.811764705882353, 0.0627450980392157, 0.125490196078431>; // HEX #CF1020
    #declare farge_Lavender_Blue = rgb <0.8, 0.8, 1>; // HEX #CCCCFF
    #declare farge_Lavender_Blush = rgb <1, 0.941176470588235, 0.96078431372549>; // HEX #FFF0F5
    #declare farge_Lavender_Floral = rgb <0.709803921568627, 0.494117647058824, 0.862745098039216>; // HEX #B57EDC
    #declare farge_Lavender_Gray = rgb <0.768627450980392, 0.764705882352941, 0.815686274509804>; // HEX #C4C3D0
    #declare farge_Lavender_Indigo = rgb <0.580392156862745, 0.341176470588235, 0.92156862745098>; // HEX #9457EB
    #declare farge_Lavender_Magenta = rgb <0.929411764705882, 0.509803921568627, 0.929411764705882>; // HEX #ED82ED
    #declare farge_Lavender_Mist = rgb <0.898039215686275, 0.898039215686275, 0.980392156862745>; // HEX #E5E5FA
    #declare farge_Lavender_Pink = rgb <0.980392156862745, 0.67843137254902, 0.823529411764706>; // HEX #FAADD2
    #declare farge_Lavender_Purple = rgb <0.588235294117647, 0.482352941176471, 0.713725490196078>; // HEX #967BB6
    #declare farge_Lavender_Rose = rgb <0.984313725490196, 0.627450980392157, 0.890196078431372>; // HEX #FBA0E3
    #declare farge_Lavender_Web = rgb <0.901960784313726, 0.901960784313726, 0.980392156862745>; // HEX #E6E6FA
    #declare farge_Lawn_Green = rgb <0.486274509803922, 0.988235294117647, 0>; // HEX #7CFC00
    #declare farge_Legal_dye_Kenpozome = rgb <0.180392156862745, 0.129411764705882, 0.105882352941176>; // HEX #2E211B
    #declare farge_Lemon = rgb <1, 0.968627450980392, 0>; // HEX #FFF700
    #declare farge_Lemon_Chiffon = rgb <1, 0.980392156862745, 0.803921568627451>; // HEX #FFFACD
    #declare farge_Lemon_Curry = rgb <0.8, 0.627450980392157, 0.113725490196078>; // HEX #CCA01D
    #declare farge_Lemon_Glacier = rgb <0.992156862745098, 1, 0>; // HEX #FDFF00
    #declare farge_Lemon_iced_tea = rgb <0.741176470588235, 0.188235294117647, 0>; // HEX #BD3000
    #declare farge_Lemon_Lime_1 = rgb <0.36078431372549, 1, 0.403921568627451>; // HEX #5CFF67
    #declare farge_Lemon_Lime_2 = rgb <0.890196078431372, 1, 0>; // HEX #E3FF00
    #declare farge_Lemon_Meringue = rgb <0.964705882352941, 0.917647058823529, 0.745098039215686>; // HEX #F6EABE
    #declare farge_Lemon_Yellow = rgb <1, 0.956862745098039, 0.309803921568627>; // HEX #FFF44F
    #declare farge_Lenurple = rgb <0.729411764705882, 0.576470588235294, 0.847058823529412>; // HEX #BA93D8
    #declare farge_Liberty = rgb <0.329411764705882, 0.352941176470588, 0.654901960784314>; // HEX #545AA7
    #declare farge_Licorice = rgb <0.101960784313725, 0.0666666666666667, 0.0627450980392157>; // HEX #1A1110
    #declare farge_Light_Apricot = rgb <0.992156862745098, 0.835294117647059, 0.690196078431373>; // HEX #FDD5B0
    #declare farge_Light_Blue = rgb <0.67843137254902, 0.847058823529412, 0.901960784313726>; // HEX #ADD8E6
    #declare farge_Light_blue_color_Asagi_iro = rgb <0.282352941176471, 0.572549019607843, 0.607843137254902>; // HEX #48929B
    #declare farge_Light_blue_flower_Hanaasagi = rgb <0.113725490196078, 0.411764705882353, 0.486274509803922>; // HEX #1D697C
    #declare farge_Light_blue_silk_Hanada = rgb <0.0156862745098039, 0.309803921568627, 0.403921568627451>; // HEX #044F67
    #declare farge_Light_Brown = rgb <0.709803921568627, 0.396078431372549, 0.113725490196078>; // HEX #B5651D
    #declare farge_Light_Carmine_Pink = rgb <0.901960784313726, 0.403921568627451, 0.443137254901961>; // HEX #E66771
    #declare farge_Light_chocolate_cosmos = rgb <0.333333333333333, 0.12156862745098, 0.184313725490196>; // HEX #551F2F
    #declare farge_Light_cobalt_blue = rgb <0.533333333333333, 0.674509803921569, 0.87843137254902>; // HEX #88ACE0
    #declare farge_Light_Coral = rgb <0.941176470588235, 0.501960784313725, 0.501960784313725>; // HEX #F08080
    #declare farge_Light_Cornflower_Blue = rgb <0.576470588235294, 0.8, 0.917647058823529>; // HEX #93CCEA
    #declare farge_Light_Crimson = rgb <0.96078431372549, 0.411764705882353, 0.568627450980392>; // HEX #F56991
    #declare farge_Light_Cyan = rgb <0.87843137254902, 1, 1>; // HEX #E0FFFF
    #declare farge_Light_Deep_Pink = rgb <1, 0.36078431372549, 0.803921568627451>; // HEX #FF5CCD
    #declare farge_Light_French_Beige = rgb <0.784313725490196, 0.67843137254902, 0.498039215686275>; // HEX #C8AD7F
    #declare farge_Light_Fuchsia_Pink = rgb <0.976470588235294, 0.517647058823529, 0.937254901960784>; // HEX #F984EF
    #declare farge_Light_gold = rgb <0.698039215686274, 0.592156862745098, 0>; // HEX #B29700
    #declare farge_Light_Goldenrod_Yellow = rgb <0.980392156862745, 0.980392156862745, 0.823529411764706>; // HEX #FAFAD2
    #declare farge_Light_Gray = rgb <0.827450980392157, 0.827450980392157, 0.827450980392157>; // HEX #D3D3D3
    #declare farge_Light_Grayish_Magenta = rgb <0.8, 0.6, 0.8>; // HEX #CC99CC
    #declare farge_Light_Green = rgb <0.564705882352941, 0.933333333333333, 0.564705882352941>; // HEX #90EE90
    #declare farge_Light_Hot_Pink = rgb <1, 0.701960784313725, 0.870588235294118>; // HEX #FFB3DE
    #declare farge_Light_Khaki = rgb <0.941176470588235, 0.898039215686275, 0.549019607843137>; // HEX #F0E58C
    #declare farge_Light_magenta = rgb <1, 0.501960784313725, 1>; // HEX #FF80FF
    #declare farge_Light_Medium_Orchid = rgb <0.827450980392157, 0.607843137254902, 0.796078431372549>; // HEX #D39BCB
    #declare farge_Light_Moss_Green = rgb <0.67843137254902, 0.874509803921569, 0.67843137254902>; // HEX #ADDFAD
    #declare farge_Light_Orange = rgb <0.996078431372549, 0.847058823529412, 0.694117647058824>; // HEX #FED8B1
    #declare farge_Light_Orchid = rgb <0.901960784313726, 0.658823529411765, 0.843137254901961>; // HEX #E6A8D7
    #declare farge_Light_Pastel_Purple = rgb <0.694117647058824, 0.611764705882353, 0.850980392156863>; // HEX #B19CD9
    #declare farge_Light_Periwinkle = rgb <0.772549019607843, 0.796078431372549, 0.882352941176471>; // HEX #C5CBE1
    #declare farge_Light_Pink = rgb <1, 0.713725490196078, 0.756862745098039>; // HEX #FFB6C1
    #declare farge_Light_red = rgb <1, 0.8, 0.796078431372549>; // HEX #FFCCCB
    #declare farge_Light_Red_Ochre = rgb <0.909803921568627, 0.454901960784314, 0.317647058823529>; // HEX #E87451
    #declare farge_Light_Salmon = rgb <1, 0.627450980392157, 0.47843137254902>; // HEX #FFA07A
    #declare farge_Light_Salmon_Pink = rgb <1, 0.6, 0.6>; // HEX #FF9999
    #declare farge_Light_Sea_Green = rgb <0.125490196078431, 0.698039215686274, 0.666666666666667>; // HEX #20B2AA
    #declare farge_Light_silver = rgb <0.847058823529412, 0.847058823529412, 0.847058823529412>; // HEX #D8D8D8
    #declare farge_Light_Sky_Blue = rgb <0.529411764705882, 0.807843137254902, 0.980392156862745>; // HEX #87CEFA
    #declare farge_Light_Slate_Gray = rgb <0.466666666666667, 0.533333333333333, 0.6>; // HEX #778899
    #declare farge_Light_Steel_Blue = rgb <0.690196078431373, 0.768627450980392, 0.870588235294118>; // HEX #B0C4DE
    #declare farge_Light_Taupe = rgb <0.701960784313725, 0.545098039215686, 0.427450980392157>; // HEX #B38B6D
    #declare farge_Light_Thulian_Pink = rgb <0.898039215686275, 0.56078431372549, 0.674509803921569>; // HEX #E58FAC
    #declare farge_Light_Yellow = rgb <1, 1, 0.87843137254902>; // HEX #FFFFE0
    #declare farge_Light_yellow_Asagi = rgb <0.968627450980392, 0.733333333333333, 0.490196078431373>; // HEX #F7BB7D
    #declare farge_Lilac = rgb <0.784313725490196, 0.635294117647059, 0.784313725490196>; // HEX #C8A2C8
    #declare farge_Lime_Green = rgb <0.196078431372549, 0.803921568627451, 0.196078431372549>; // HEX #32CD32
    #declare farge_Lime_pulp = rgb <0.819607843137255, 0.882352941176471, 0.537254901960784>; // HEX #D1E189
    #declare farge_Limerick = rgb <0.615686274509804, 0.76078431372549, 0.0352941176470588>; // HEX #9DC209
    #declare farge_Lincoln_Green = rgb <0.0980392156862745, 0.349019607843137, 0.0196078431372549>; // HEX #195905
    #declare farge_Linen = rgb <0.980392156862745, 0.941176470588235, 0.901960784313726>; // HEX #FAF0E6
    #declare farge_Linkedin_Blue = rgb <0, 0.447058823529412, 0.694117647058824>; // HEX #0072B1
    #declare farge_Lion = rgb <0.756862745098039, 0.603921568627451, 0.419607843137255>; // HEX #C19A6B
    #declare farge_Liseran_Purple = rgb <0.870588235294118, 0.435294117647059, 0.631372549019608>; // HEX #DE6FA1
    #declare farge_Little_Boy_Blue = rgb <0.423529411764706, 0.627450980392157, 0.862745098039216>; // HEX #6CA0DC
    #declare farge_Little_girl_pink = rgb <0.972549019607843, 0.725490196078431, 0.831372549019608>; // HEX #F8B9D4
    #declare farge_Liver = rgb <0.403921568627451, 0.298039215686275, 0.27843137254902>; // HEX #674C47
    #declare farge_Liver_Chestnut = rgb <0.596078431372549, 0.454901960784314, 0.337254901960784>; // HEX #987456
    #declare farge_Liver_Dogs = rgb <0.72156862745098, 0.427450980392157, 0.16078431372549>; // HEX #B86D29
    #declare farge_Liver_Organ = rgb <0.423529411764706, 0.180392156862745, 0.12156862745098>; // HEX #6C2E1F
    #declare farge_Livid = rgb <0.4, 0.6, 0.8>; // HEX #6699CC
    #declare farge_Long_spring_color_Choshun_iro = rgb <0.725490196078431, 0.341176470588235, 0.329411764705882>; // HEX #B95754
    #declare farge_Loquat_brown_Biwacha = rgb <0.670588235294118, 0.380392156862745, 0.203921568627451>; // HEX #AB6134
    #declare farge_Lotion = rgb <0.996078431372549, 0.992156862745098, 0.980392156862745>; // HEX #FEFDFA
    #declare farge_Lotion_blue = rgb <0.0823529411764706, 0.949019607843137, 0.992156862745098>; // HEX #15F2FD
    #declare farge_Lotion_pink = rgb <0.925490196078431, 0.811764705882353, 0.811764705882353>; // HEX #ECCFCF
    #declare farge_Lumber = rgb <1, 0.894117647058824, 0.803921568627451>; // HEX #FFE4CD
    #declare farge_Lust = rgb <0.901960784313726, 0.125490196078431, 0.125490196078431>; // HEX #E62020
    #declare farge_Lychee = rgb <0.862745098039216, 0.325490196078431, 0.286274509803922>; // HEX #DC5349
    #declare farge_Lye_colored_Aku_iro = rgb <0.498039215686275, 0.419607843137255, 0.364705882352941>; // HEX #7F6B5D
    #declare farge_Macaroni_And_Cheese = rgb <1, 0.741176470588235, 0.533333333333333>; // HEX #FFBD88
    #declare farge_Magenta_Dye = rgb <0.792156862745098, 0.12156862745098, 0.482352941176471>; // HEX #CA1F7B
    #declare farge_Magenta_Haze = rgb <0.623529411764706, 0.270588235294118, 0.462745098039216>; // HEX #9F4576
    #declare farge_Magenta_Pantone = rgb <0.815686274509804, 0.254901960784314, 0.494117647058824>; // HEX #D0417E
    #declare farge_Magenta_Pink = rgb <0.8, 0.2, 0.545098039215686>; // HEX #CC338B
    #declare farge_Magenta_Process = rgb <1, 0, 0.564705882352941>; // HEX #FF0090
    #declare farge_Magic_Mint = rgb <0.666666666666667, 0.941176470588235, 0.819607843137255>; // HEX #AAF0D1
    #declare farge_Magic_Potion = rgb <1, 0.266666666666667, 0.4>; // HEX #FF4466
    #declare farge_Magnolia = rgb <0.972549019607843, 0.956862745098039, 1>; // HEX #F8F4FF
    #declare farge_Mahogany = rgb <0.752941176470588, 0.250980392156863, 0>; // HEX #C04000
    #declare farge_Maize = rgb <0.984313725490196, 0.925490196078431, 0.364705882352941>; // HEX #FBEC5D
    #declare farge_Majorelle_Blue = rgb <0.376470588235294, 0.313725490196078, 0.862745098039216>; // HEX #6050DC
    #declare farge_Malachite = rgb <0.0431372549019608, 0.854901960784314, 0.317647058823529>; // HEX #0BDA51
    #declare farge_Manatee = rgb <0.592156862745098, 0.603921568627451, 0.666666666666667>; // HEX #979AAA
    #declare farge_Mango = rgb <0.992156862745098, 0.745098039215686, 0.00784313725490196>; // HEX #FDBE02
    #declare farge_Mango_green = rgb <0.588235294117647, 1, 0>; // HEX #96FF00
    #declare farge_Mango_Tango = rgb <1, 0.509803921568627, 0.262745098039216>; // HEX #FF8243
    #declare farge_Manila = rgb <0.905882352941176, 0.788235294117647, 0.662745098039216>; // HEX #E7C9A9
    #declare farge_Mantis = rgb <0.454901960784314, 0.764705882352941, 0.396078431372549>; // HEX #74C365
    #declare farge_Maple_syrup = rgb <0.733333333333333, 0.576470588235294, 0.317647058823529>; // HEX #BB9351
    #declare farge_Mardi_Gras = rgb <0.533333333333333, 0, 0.52156862745098>; // HEX #880085
    #declare farge_Margarine = rgb <0.949019607843137, 0.850980392156863, 0.188235294117647>; // HEX #F2D930
    #declare farge_Margarita = rgb <0.690196078431373, 0.76078431372549, 0.290196078431373>; // HEX #B0C24A
    #declare farge_Marigold = rgb <0.917647058823529, 0.635294117647059, 0.129411764705882>; // HEX #EAA221
    #declare farge_Maroon_Shrimp_brown_Ebicha = rgb <0.368627450980392, 0.156862745098039, 0.141176470588235>; // HEX #5E2824
    #declare farge_Maroon_Web = rgb <0.501960784313725, 0, 0>; // HEX #800000
    #declare farge_Mauve = rgb <0.87843137254902, 0.690196078431373, 1>; // HEX #E0B0FF
    #declare farge_Mauve_Taupe = rgb <0.568627450980392, 0.372549019607843, 0.427450980392157>; // HEX #915F6D
    #declare farge_Mauvelous = rgb <0.937254901960784, 0.596078431372549, 0.666666666666667>; // HEX #EF98AA
    #declare farge_Maximum_orange = rgb <1, 0.356862745098039, 0>; // HEX #FF5B00
    #declare farge_May_Green = rgb <0.298039215686275, 0.568627450980392, 0.254901960784314>; // HEX #4C9141
    #declare farge_Maya_Blue = rgb <0.450980392156863, 0.76078431372549, 0.984313725490196>; // HEX #73C2FB
    #declare farge_Meat_Brown = rgb <0.898039215686275, 0.717647058823529, 0.231372549019608>; // HEX #E5B73B
    #declare farge_Meat_color_Shishi_iro = rgb <0.976470588235294, 0.564705882352941, 0.435294117647059>; // HEX #F9906F
    #declare farge_Medium_Aquamarine = rgb <0.4, 0.866666666666667, 0.666666666666667>; // HEX #66DDAA
    #declare farge_Medium_Blue = rgb <0, 0, 0.803921568627451>; // HEX #0000CD
    #declare farge_Medium_Candy_Apple_Red = rgb <0.886274509803922, 0.0235294117647059, 0.172549019607843>; // HEX #E2062C
    #declare farge_Medium_Carmine = rgb <0.686274509803922, 0.250980392156863, 0.207843137254902>; // HEX #AF4035
    #declare farge_Medium_Champagne = rgb <0.952941176470588, 0.898039215686275, 0.670588235294118>; // HEX #F3E5AB
    #declare farge_Medium_crimson_dye_Nakabeni = rgb <0.788235294117647, 0.215686274509804, 0.337254901960784>; // HEX #C93756
    #declare farge_Medium_Electric_Blue = rgb <0.0117647058823529, 0.313725490196078, 0.588235294117647>; // HEX #035096
    #declare farge_Medium_Jungle_Green = rgb <0.109803921568627, 0.207843137254902, 0.176470588235294>; // HEX #1C352D
    #declare farge_Medium_Lavender_Magenta = rgb <0.866666666666667, 0.623529411764706, 0.866666666666667>; // HEX #DD9FDD
    #declare farge_Medium_Orchid = rgb <0.729411764705882, 0.333333333333333, 0.827450980392157>; // HEX #BA55D3
    #declare farge_Medium_Persian_Blue = rgb <0, 0.403921568627451, 0.647058823529412>; // HEX #0067A5
    #declare farge_Medium_Red_Violet = rgb <0.729411764705882, 0.2, 0.517647058823529>; // HEX #BA3384
    #declare farge_Medium_Ruby = rgb <0.666666666666667, 0.247058823529412, 0.411764705882353>; // HEX #AA3F69
    #declare farge_Medium_Sea_Green = rgb <0.235294117647059, 0.701960784313725, 0.443137254901961>; // HEX #3CB371
    #declare farge_Medium_Sky_Blue = rgb <0.501960784313725, 0.854901960784314, 0.92156862745098>; // HEX #80DAEB
    #declare farge_Medium_Slate_Blue = rgb <0.482352941176471, 0.407843137254902, 0.933333333333333>; // HEX #7B68EE
    #declare farge_Medium_Spring_Bud = rgb <0.788235294117647, 0.862745098039216, 0.529411764705882>; // HEX #C9DC87
    #declare farge_Medium_Spring_Green = rgb <0, 0.980392156862745, 0.603921568627451>; // HEX #00FA9A
    #declare farge_Medium_Taupe = rgb <0.403921568627451, 0.298039215686275, 0.27843137254902>; // HEX #674C47
    #declare farge_Medium_Turquoise = rgb <0.282352941176471, 0.819607843137255, 0.8>; // HEX #48D1CC
    #declare farge_Medium_Tuscan_Red = rgb <0.474509803921569, 0.266666666666667, 0.227450980392157>; // HEX #79443A
    #declare farge_Medium_Vermilion = rgb <0.850980392156863, 0.376470588235294, 0.231372549019608>; // HEX #D9603B
    #declare farge_Medium_Violet_Red = rgb <0.780392156862745, 0.0823529411764706, 0.52156862745098>; // HEX #C71585
    #declare farge_Melancholy = rgb <0.992156862745098, 0.737254901960784, 0.705882352941177>; // HEX #FDBCB4
    #declare farge_Mellow_Apricot = rgb <0.972549019607843, 0.72156862745098, 0.470588235294118>; // HEX #F8B878
    #declare farge_Mellow_Yellow = rgb <0.972549019607843, 0.870588235294118, 0.494117647058824>; // HEX #F8DE7E
    #declare farge_Menthol = rgb <0.756862745098039, 0.976470588235294, 0.635294117647059>; // HEX #C1F9A2
    #declare farge_Metallic_blue = rgb <0.196078431372549, 0.32156862745098, 0.482352941176471>; // HEX #32527B
    #declare farge_Metallic_bronze = rgb <0.662745098039216, 0.443137254901961, 0.258823529411765>; // HEX #A97142
    #declare farge_Metallic_brown = rgb <0.674509803921569, 0.262745098039216, 0.0745098039215686>; // HEX #AC4313
    #declare farge_Metallic_Gold = rgb <0.827450980392157, 0.686274509803922, 0.215686274509804>; // HEX #D3AF37
    #declare farge_Metallic_green = rgb <0.16078431372549, 0.431372549019608, 0.00392156862745098>; // HEX #296E01
    #declare farge_Metallic_orange = rgb <0.854901960784314, 0.407843137254902, 0.0588235294117647>; // HEX #DA680F
    #declare farge_Metallic_pink = rgb <0.929411764705882, 0.650980392156863, 0.768627450980392>; // HEX #EDA6C4
    #declare farge_Metallic_red = rgb <0.650980392156863, 0.172549019607843, 0.168627450980392>; // HEX #A62C2B
    #declare farge_Metallic_Sunburst = rgb <0.611764705882353, 0.486274509803922, 0.219607843137255>; // HEX #9C7C38
    #declare farge_Metallic_violet = rgb <0.356862745098039, 0.0392156862745098, 0.568627450980392>; // HEX #5B0A91
    #declare farge_Metallic_yellow = rgb <0.992156862745098, 0.8, 0.0509803921568627>; // HEX #FDCC0D
    #declare farge_Mexican_Pink = rgb <0.894117647058824, 0, 0.486274509803922>; // HEX #E4007C
    #declare farge_Microsoft_blue = rgb <0, 0.635294117647059, 0.929411764705882>; // HEX #00A2ED
    #declare farge_Microsoft_Edge_blue = rgb <0, 0.470588235294118, 0.843137254901961>; // HEX #0078D7
    #declare farge_Microsoft_green = rgb <0.490196078431373, 0.717647058823529, 0>; // HEX #7DB700
    #declare farge_Microsoft_red = rgb <0.941176470588235, 0.305882352941176, 0.12156862745098>; // HEX #F04E1F
    #declare farge_Microsoft_yellow = rgb <0.992156862745098, 0.725490196078431, 0>; // HEX #FDB900
    #declare farge_Middle_Yellow_Red = rgb <0.925490196078431, 0.694117647058824, 0.462745098039216>; // HEX #ECB176
    #declare farge_Midnight_Blue_1 = rgb <0, 0.274509803921569, 0.549019607843137>; // HEX #00468C
    #declare farge_Midnight_Blue_2 = rgb <0.0980392156862745, 0.0980392156862745, 0.43921568627451>; // HEX #191970
    #declare farge_Midnight_Green_Eagle_Green = rgb <0, 0.286274509803922, 0.325490196078431>; // HEX #004953
    #declare farge_Mikado_Yellow = rgb <1, 0.768627450980392, 0.0470588235294118>; // HEX #FFC40C
    #declare farge_Milk = rgb <0.992156862745098, 1, 0.96078431372549>; // HEX #FDFFF5
    #declare farge_Milk_chocolate = rgb <0.517647058823529, 0.337254901960784, 0.235294117647059>; // HEX #84563C
    #declare farge_Mimi_Pink = rgb <1, 0.854901960784314, 0.913725490196078>; // HEX #FFDAE9
    #declare farge_Mindaro = rgb <0.890196078431372, 0.976470588235294, 0.533333333333333>; // HEX #E3F988
    #declare farge_Ming = rgb <0.211764705882353, 0.454901960784314, 0.490196078431373>; // HEX #36747D
    #declare farge_Minion_Yellow = rgb <0.96078431372549, 0.87843137254902, 0.313725490196078>; // HEX #F5E050
    #declare farge_Mint = rgb <0.243137254901961, 0.705882352941177, 0.537254901960784>; // HEX #3EB489
    #declare farge_Mint_Cream = rgb <0.96078431372549, 1, 0.980392156862745>; // HEX #F5FFFA
    #declare farge_Mint_Green = rgb <0.596078431372549, 1, 0.596078431372549>; // HEX #98FF98
    #declare farge_Misty_Rose = rgb <1, 0.894117647058824, 0.882352941176471>; // HEX #FFE4E1
    #declare farge_Moccasin = rgb <0.980392156862745, 0.917647058823529, 0.843137254901961>; // HEX #FAEAD7
    #declare farge_Mocha = rgb <0.745098039215686, 0.643137254901961, 0.576470588235294>; // HEX #BEA493
    #declare farge_Mode_Beige = rgb <0.588235294117647, 0.443137254901961, 0.0901960784313725>; // HEX #967117
    #declare farge_Moonstone_Blue = rgb <0.450980392156863, 0.662745098039216, 0.76078431372549>; // HEX #73A9C2
    #declare farge_Mordant_Red_19 = rgb <0.682352941176471, 0.0470588235294118, 0>; // HEX #AE0C00
    #declare farge_Morning_Blue = rgb <0.552941176470588, 0.63921568627451, 0.6>; // HEX #8DA399
    #declare farge_Moss_color_Koke_iro = rgb <0.545098039215686, 0.490196078431373, 0.227450980392157>; // HEX #8B7D3A
    #declare farge_Moss_Green = rgb <0.541176470588235, 0.603921568627451, 0.356862745098039>; // HEX #8A9A5B
    #declare farge_Mountain_Meadow = rgb <0.188235294117647, 0.729411764705882, 0.56078431372549>; // HEX #30BA8F
    #declare farge_Mountbatten_Pink = rgb <0.6, 0.47843137254902, 0.552941176470588>; // HEX #997A8D
    #declare farge_Mousy_indigo_Ainezumi = rgb <0.36078431372549, 0.329411764705882, 0.305882352941176>; // HEX #5C544E
    #declare farge_Mousy_wisteria_Fujinezumi = rgb <0.462745098039216, 0.411764705882353, 0.501960784313725>; // HEX #766980
    #declare farge_Msu_Green = rgb <0.0941176470588235, 0.270588235294118, 0.231372549019608>; // HEX #18453B
    #declare farge_Mud = rgb <0.43921568627451, 0.329411764705882, 0.243137254901961>; // HEX #70543E
    #declare farge_Muddy_brown_river_Enshucha = rgb <0.796078431372549, 0.4, 0.286274509803922>; // HEX #CB6649
    #declare farge_Mughal_Green = rgb <0.188235294117647, 0.376470588235294, 0.188235294117647>; // HEX #306030
    #declare farge_Mulberry = rgb <0.772549019607843, 0.294117647058824, 0.549019607843137>; // HEX #C54B8C
    #declare farge_Mulberry_dye_Kuwazome = rgb <0.349019607843137, 0.16078431372549, 0.172549019607843>; // HEX #59292C
    #declare farge_Mulberry_dyed_Kuwazome = rgb <0.772549019607843, 0.498039215686275, 0.180392156862745>; // HEX #C57F2E
    #declare farge_Mustard = rgb <1, 0.858823529411765, 0.345098039215686>; // HEX #FFDB58
    #declare farge_Mustard_brown = rgb <0.803921568627451, 0.47843137254902, 0>; // HEX #CD7A00
    #declare farge_Mustard_green = rgb <0.431372549019608, 0.431372549019608, 0.188235294117647>; // HEX #6E6E30
    #declare farge_Mustard_yellow = rgb <0.882352941176471, 0.67843137254902, 0.00392156862745098>; // HEX #E1AD01
    #declare farge_Myrtle_Green = rgb <0.192156862745098, 0.470588235294118, 0.450980392156863>; // HEX #317873
    #declare farge_Mystic_red = rgb <1, 0.333333333333333, 0>; // HEX #FF5500
    #declare farge_Nadeshiko_Pink = rgb <0.964705882352941, 0.67843137254902, 0.776470588235294>; // HEX #F6ADC6
    #declare farge_Napier_Green = rgb <0.164705882352941, 0.501960784313725, 0>; // HEX #2A8000
    #declare farge_Naples_Yellow = rgb <0.980392156862745, 0.854901960784314, 0.368627450980392>; // HEX #FADA5E
    #declare farge_Navajo_White = rgb <1, 0.870588235294118, 0.67843137254902>; // HEX #FFDEAD
    #declare farge_Navy_Blue = rgb <0, 0, 0.501960784313725>; // HEX #000080
    #declare farge_Navy_blue_bellflower_Konkikyo = rgb <0.0980392156862745, 0.12156862745098, 0.270588235294118>; // HEX #191F45
    #declare farge_Navy_Purple = rgb <0.580392156862745, 0.341176470588235, 0.917647058823529>; // HEX #9457EA
    #declare farge_Neon_Blue_1 = rgb <0.105882352941176, 0.0117647058823529, 0.63921568627451>; // HEX #1B03A3
    #declare farge_Neon_Blue_2 = rgb <0.274509803921569, 0.4, 1>; // HEX #4666FF
    #declare farge_Neon_Carrot = rgb <1, 0.63921568627451, 0.262745098039216>; // HEX #FFA343
    #declare farge_Neon_Fuchsia = rgb <0.996078431372549, 0.254901960784314, 0.392156862745098>; // HEX #FE4164
    #declare farge_Neon_Green = rgb <0.223529411764706, 1, 0.0784313725490196>; // HEX #39FF14
    #declare farge_New_Bridge_color_Shinbashi_iro = rgb <0, 0.423529411764706, 0.498039215686275>; // HEX #006C7F
    #declare farge_New_Car = rgb <0.129411764705882, 0.309803921568627, 0.776470588235294>; // HEX #214FC6
    #declare farge_New_York_Pink = rgb <0.843137254901961, 0.513725490196078, 0.498039215686275>; // HEX #D7837F
    #declare farge_Nickel = rgb <0.447058823529412, 0.454901960784314, 0.447058823529412>; // HEX #727472
    #declare farge_Nightingale_brown_greenish_brown_Uguisucha = rgb <0.36078431372549, 0.282352941176471, 0.152941176470588>; // HEX #5C4827
    #declare farge_Nintendo_red = rgb <0.894117647058824, 0, 0.0588235294117647>; // HEX #E4000F
    #declare farge_Non_Photo_Blue = rgb <0.643137254901961, 0.866666666666667, 0.929411764705882>; // HEX #A4DDED
    #declare farge_North_Texas_Green = rgb <0.0196078431372549, 0.564705882352941, 0.2>; // HEX #059033
    #declare farge_Nyanza = rgb <0.913725490196078, 1, 0.858823529411765>; // HEX #E9FFDB
    #declare farge_Ocean_Boat_Blue = rgb <0, 0.466666666666667, 0.745098039215686>; // HEX #0077BE
    #declare farge_Ochre = rgb <0.8, 0.466666666666667, 0.133333333333333>; // HEX #CC7722
    #declare farge_Ochre_Odo_iro = rgb <0.745098039215686, 0.498039215686275, 0.317647058823529>; // HEX #BE7F51
    #declare farge_Ochre_Otan = rgb <1, 0.305882352941176, 0.125490196078431>; // HEX #FF4E20
    #declare farge_Office_Green = rgb <0, 0.498039215686275, 0>; // HEX #007F00
    #declare farge_Ogre_Odor = rgb <0.992156862745098, 0.32156862745098, 0.250980392156863>; // HEX #FD5240
    #declare farge_Old_bamboo_color_Oitake_iro = rgb <0.368627450980392, 0.392156862745098, 0.309803921568627>; // HEX #5E644F
    #declare farge_Old_Burgundy = rgb <0.262745098039216, 0.188235294117647, 0.180392156862745>; // HEX #43302E
    #declare farge_Old_Heliotrope = rgb <0.337254901960784, 0.235294117647059, 0.36078431372549>; // HEX #563C5C
    #declare farge_Old_Lace = rgb <0.992156862745098, 0.96078431372549, 0.901960784313726>; // HEX #FDF5E6
    #declare farge_Old_Lavender = rgb <0.474509803921569, 0.407843137254902, 0.470588235294118>; // HEX #796878
    #declare farge_Old_Mauve = rgb <0.403921568627451, 0.192156862745098, 0.27843137254902>; // HEX #673147
    #declare farge_Old_Moss_Green = rgb <0.525490196078431, 0.494117647058824, 0.211764705882353>; // HEX #867E36
    #declare farge_Old_Rose = rgb <0.752941176470588, 0.501960784313725, 0.505882352941176>; // HEX #C08081
    #declare farge_Old_Silver = rgb <0.517647058823529, 0.517647058823529, 0.509803921568627>; // HEX #848482
    #declare farge_Olive = rgb <0.501960784313725, 0.501960784313725, 0>; // HEX #808000
    #declare farge_Olive_Drab_No7 = rgb <0.235294117647059, 0.203921568627451, 0.12156862745098>; // HEX #3C341F
    #declare farge_Olivine = rgb <0.603921568627451, 0.725490196078431, 0.450980392156863>; // HEX #9AB973
    #declare farge_Onando_color_Onando_iro = rgb <0.211764705882353, 0.254901960784314, 0.254901960784314>; // HEX #364141
    #declare farge_One_kin_dye_Ikkonzome = rgb <0.941176470588235, 0.56078431372549, 0.564705882352941>; // HEX #F08F90
    #declare farge_Opal = rgb <0.658823529411765, 0.764705882352941, 0.737254901960784>; // HEX #A8C3BC
    #declare farge_Opera_Mauve = rgb <0.717647058823529, 0.517647058823529, 0.654901960784314>; // HEX #B784A7
    #declare farge_Opera_Red = rgb <1, 0.105882352941176, 0.176470588235294>; // HEX #FF1B2D
    #declare farge_Opposite_flower_color_Masuhana_iro = rgb <0.301960784313725, 0.392156862745098, 0.423529411764706>; // HEX #4D646C
    #declare farge_Orange = rgb <1, 0.4, 0>; // HEX #FF6600
    #declare farge_Orange_Pantone = rgb <1, 0.345098039215686, 0>; // HEX #FF5800
    #declare farge_Orange_Peel = rgb <1, 0.623529411764706, 0>; // HEX #FF9F00
    #declare farge_Orange_Red = rgb <1, 0.407843137254902, 0.12156862745098>; // HEX #FF681F
    #declare farge_Orange_RYB = rgb <0.984313725490196, 0.6, 0.00784313725490196>; // HEX #FB9902
    #declare farge_Orange_soda = rgb <0.92156862745098, 0.349019607843137, 0.23921568627451>; // HEX #EB593D
    #declare farge_Orange_Web = rgb <1, 0.647058823529412, 0>; // HEX #FFA500
    #declare farge_Orange_Yellow = rgb <0.96078431372549, 0.741176470588235, 0.12156862745098>; // HEX #F5BD1F
    #declare farge_Orchid = rgb <0.854901960784314, 0.43921568627451, 0.83921568627451>; // HEX #DA70D6
    #declare farge_Orchid_Pink = rgb <0.949019607843137, 0.741176470588235, 0.803921568627451>; // HEX #F2BDCD
    #declare farge_Orioles_Orange = rgb <0.984313725490196, 0.309803921568627, 0.0784313725490196>; // HEX #FB4F14
    #declare farge_Otter_Brown = rgb <0.392156862745098, 0.258823529411765, 0.129411764705882>; // HEX #644221
    #declare farge_OU_Crimson_red = rgb <0.517647058823529, 0.0862745098039216, 0.0901960784313725>; // HEX #841617
    #declare farge_Outer_Space = rgb <0.254901960784314, 0.290196078431373, 0.298039215686275>; // HEX #414A4C
    #declare farge_Outrageous_Orange = rgb <1, 0.431372549019608, 0.290196078431373>; // HEX #FF6E4A
    #declare farge_Overdyed_refreshed_red_brown_Sohi = rgb <0.890196078431372, 0.36078431372549, 0.219607843137255>; // HEX #E35C38
    #declare farge_Oxblood = rgb <0.501960784313725, 0, 0.125490196078431>; // HEX #800020
    #declare farge_Oxford_Blue = rgb <0, 0.129411764705882, 0.27843137254902>; // HEX #002147
    #declare farge_Oxley = rgb <0.427450980392157, 0.603921568627451, 0.474509803921569>; // HEX #6D9A79
    #declare farge_Pacific_Blue = rgb <0.109803921568627, 0.662745098039216, 0.788235294117647>; // HEX #1CA9C9
    #declare farge_Painite = rgb <0.419607843137255, 0.286274509803922, 0.27843137254902>; // HEX #6B4947
    #declare farge_Pakistan_Green = rgb <0, 0.4, 0>; // HEX #006600
    #declare farge_Palatinate_Blue = rgb <0.152941176470588, 0.231372549019608, 0.886274509803922>; // HEX #273BE2
    #declare farge_Palatinate_Purple = rgb <0.407843137254902, 0.156862745098039, 0.376470588235294>; // HEX #682860
    #declare farge_Pale_Aqua = rgb <0.737254901960784, 0.831372549019608, 0.901960784313726>; // HEX #BCD4E6
    #declare farge_Pale_Blue = rgb <0.686274509803922, 0.929411764705882, 0.929411764705882>; // HEX #AFEDED
    #declare farge_Pale_Blue_Pale_Turquoise = rgb <0.686274509803922, 0.933333333333333, 0.933333333333333>; // HEX #AFEEEE
    #declare farge_Pale_blue_Usuao = rgb <0.549019607843137, 0.611764705882353, 0.462745098039216>; // HEX #8C9C76
    #declare farge_Pale_Brown = rgb <0.596078431372549, 0.462745098039216, 0.329411764705882>; // HEX #987654
    #declare farge_Pale_Carmine = rgb <0.686274509803922, 0.247058823529412, 0.203921568627451>; // HEX #AF3F34
    #declare farge_Pale_Cerulean = rgb <0.607843137254902, 0.768627450980392, 0.886274509803922>; // HEX #9BC4E2
    #declare farge_Pale_Chestnut = rgb <0.866666666666667, 0.67843137254902, 0.686274509803922>; // HEX #DDADAF
    #declare farge_Pale_Copper = rgb <0.854901960784314, 0.541176470588235, 0.403921568627451>; // HEX #DA8A67
    #declare farge_Pale_Cornflower_Blue = rgb <0.670588235294118, 0.803921568627451, 0.937254901960784>; // HEX #ABCDEF
    #declare farge_Pale_Cyan = rgb <0.529411764705882, 0.827450980392157, 0.972549019607843>; // HEX #87D3F8
    #declare farge_Pale_fallen_leaves_Aokuchiba = rgb <0.666666666666667, 0.529411764705882, 0.211764705882353>; // HEX #AA8736
    #declare farge_Pale_Gold = rgb <0.898039215686275, 0.741176470588235, 0.541176470588235>; // HEX #E5BD8A
    #declare farge_Pale_Goldenrod = rgb <0.933333333333333, 0.909803921568627, 0.666666666666667>; // HEX #EEE8AA
    #declare farge_Pale_Green = rgb <0.596078431372549, 0.984313725490196, 0.596078431372549>; // HEX #98FB98
    #declare farge_Pale_green_onion_Mizuasagi = rgb <0.454901960784314, 0.623529411764706, 0.552941176470588>; // HEX #749F8D
    #declare farge_Pale_incense_Usuko = rgb <1, 0.647058823529412, 0.396078431372549>; // HEX #FFA565
    #declare farge_Pale_Lavender = rgb <0.862745098039216, 0.815686274509804, 1>; // HEX #DCD0FF
    #declare farge_Pale_Magenta = rgb <0.976470588235294, 0.517647058823529, 0.898039215686275>; // HEX #F984E5
    #declare farge_Pale_Magenta_Pink = rgb <1, 0.6, 0.8>; // HEX #FF99CC
    #declare farge_Pale_oak_Aoshirotsurubami = rgb <0.733333333333333, 0.643137254901961, 0.427450980392157>; // HEX #BBA46D
    #declare farge_Pale_persimmon_Usugaki = rgb <0.988235294117647, 0.643137254901961, 0.454901960784314>; // HEX #FCA474
    #declare farge_Pale_Pink = rgb <0.980392156862745, 0.854901960784314, 0.866666666666667>; // HEX #FADADD
    #declare farge_Pale_Plum = rgb <0.866666666666667, 0.623529411764706, 0.866666666666667>; // HEX #DD9FDD
    #declare farge_Pale_Purple_Pantone = rgb <0.980392156862745, 0.901960784313726, 0.980392156862745>; // HEX #FAE6FA
    #declare farge_Pale_Robin_Egg_Blue = rgb <0.588235294117647, 0.870588235294118, 0.819607843137255>; // HEX #96DED1
    #declare farge_Pale_Silver = rgb <0.788235294117647, 0.752941176470588, 0.733333333333333>; // HEX #C9C0BB
    #declare farge_Pale_Spring_Bud = rgb <0.925490196078431, 0.92156862745098, 0.741176470588235>; // HEX #ECEBBD
    #declare farge_Pale_Taupe = rgb <0.737254901960784, 0.596078431372549, 0.494117647058824>; // HEX #BC987E
    #declare farge_Pale_Turquoise = rgb <0.686274509803922, 0.929411764705882, 0.929411764705882>; // HEX #AFEDED
    #declare farge_Pale_Violet = rgb <0.8, 0.6, 1>; // HEX #CC99FF
    #declare farge_Pale_Violet_Red = rgb <0.854901960784314, 0.435294117647059, 0.572549019607843>; // HEX #DA6F92
    #declare farge_Pale_young_green_onion_Usumoegi = rgb <0.552941176470588, 0.698039215686274, 0.333333333333333>; // HEX #8DB255
    #declare farge_Palm_Leaf = rgb <0.435294117647059, 0.6, 0.250980392156863>; // HEX #6F9940
    #declare farge_Panasonic_blue = rgb <0, 0.250980392156863, 0.745098039215686>; // HEX #0040BE
    #declare farge_Pansy_Purple = rgb <0.470588235294118, 0.0941176470588235, 0.290196078431373>; // HEX #78184A
    #declare farge_Paolo_Veronese_Green = rgb <0, 0.607843137254902, 0.490196078431373>; // HEX #009B7D
    #declare farge_Papaya_Whip = rgb <1, 0.937254901960784, 0.835294117647059>; // HEX #FFEFD5
    #declare farge_Paradise_Pink = rgb <0.901960784313726, 0.243137254901961, 0.384313725490196>; // HEX #E63E62
    #declare farge_Parakeet_Blue = rgb <0.494117647058824, 0.713725490196078, 1>; // HEX #7EB6FF
    #declare farge_Paris_Green = rgb <0.313725490196078, 0.784313725490196, 0.470588235294118>; // HEX #50C878
    #declare farge_Parrot_Pink = rgb <0.850980392156863, 0.596078431372549, 0.627450980392157>; // HEX #D998A0
    #declare farge_Pastel_Blue = rgb <0.682352941176471, 0.776470588235294, 0.811764705882353>; // HEX #AEC6CF
    #declare farge_Pastel_Brown = rgb <0.513725490196078, 0.411764705882353, 0.325490196078431>; // HEX #836953
    #declare farge_Pastel_Gray = rgb <0.811764705882353, 0.811764705882353, 0.768627450980392>; // HEX #CFCFC4
    #declare farge_Pastel_Green = rgb <0.466666666666667, 0.866666666666667, 0.466666666666667>; // HEX #77DD77
    #declare farge_Pastel_Magenta = rgb <0.956862745098039, 0.603921568627451, 0.76078431372549>; // HEX #F49AC2
    #declare farge_Pastel_Orange = rgb <1, 0.701960784313725, 0.27843137254902>; // HEX #FFB347
    #declare farge_Pastel_Pink = rgb <0.870588235294118, 0.647058823529412, 0.643137254901961>; // HEX #DEA5A4
    #declare farge_Pastel_Purple = rgb <0.701960784313725, 0.619607843137255, 0.709803921568627>; // HEX #B39EB5
    #declare farge_Pastel_Red = rgb <1, 0.411764705882353, 0.380392156862745>; // HEX #FF6961
    #declare farge_Pastel_Violet = rgb <0.796078431372549, 0.6, 0.788235294117647>; // HEX #CB99C9
    #declare farge_Pastel_Yellow = rgb <0.992156862745098, 0.992156862745098, 0.588235294117647>; // HEX #FDFD96
    #declare farge_Patina_Rokusho = rgb <0.250980392156863, 0.47843137254902, 0.32156862745098>; // HEX #407A52
    #declare farge_Patriarch = rgb <0.501960784313725, 0, 0.501960784313725>; // HEX #800080
    #declare farge_Patrinia_flowers_Ominaeshi = rgb <0.850980392156863, 0.713725490196078, 0.0666666666666667>; // HEX #D9B611
    #declare farge_Paynes_Grey = rgb <0.325490196078431, 0.407843137254902, 0.470588235294118>; // HEX #536878
    #declare farge_Peach = rgb <1, 0.898039215686275, 0.705882352941177>; // HEX #FFE5B4
    #declare farge_Peach_Burst = rgb <0.952941176470588, 0.6, 0.596078431372549>; // HEX #F39998
    #declare farge_Peach_colored_Momo_iro = rgb <0.956862745098039, 0.474509803921569, 0.513725490196078>; // HEX #F47983
    #declare farge_Peach_Orange = rgb <1, 0.8, 0.6>; // HEX #FFCC99
    #declare farge_Peach_Puff = rgb <1, 0.854901960784314, 0.725490196078431>; // HEX #FFDAB9
    #declare farge_Peach_Yellow = rgb <0.980392156862745, 0.874509803921569, 0.67843137254902>; // HEX #FADFAD
    #declare farge_Pear = rgb <0.819607843137255, 0.886274509803922, 0.192156862745098>; // HEX #D1E231
    #declare farge_Pearl = rgb <0.917647058823529, 0.87843137254902, 0.784313725490196>; // HEX #EAE0C8
    #declare farge_Pearl_Aqua = rgb <0.533333333333333, 0.847058823529412, 0.752941176470588>; // HEX #88D8C0
    #declare farge_Penguin_White = rgb <0.96078431372549, 0.952941176470588, 0.937254901960784>; // HEX #F5F3EF
    #declare farge_Peridot = rgb <0.901960784313726, 0.886274509803922, 0>; // HEX #E6E200
    #declare farge_Periwinkle = rgb <0.8, 0.8, 1>; // HEX #CCCCFF
    #declare farge_Persian_Blue = rgb <0.109803921568627, 0.223529411764706, 0.733333333333333>; // HEX #1C39BB
    #declare farge_Persian_Green = rgb <0, 0.650980392156863, 0.576470588235294>; // HEX #00A693
    #declare farge_Persian_Indigo = rgb <0.196078431372549, 0.0705882352941176, 0.47843137254902>; // HEX #32127A
    #declare farge_Persian_Orange = rgb <0.850980392156863, 0.564705882352941, 0.345098039215686>; // HEX #D99058
    #declare farge_Persian_Pink = rgb <0.968627450980392, 0.498039215686275, 0.745098039215686>; // HEX #F77FBE
    #declare farge_Persian_Plum = rgb <0.43921568627451, 0.109803921568627, 0.109803921568627>; // HEX #701C1C
    #declare farge_Persian_Red = rgb <0.8, 0.2, 0.2>; // HEX #CC3333
    #declare farge_Persian_Rose = rgb <0.996078431372549, 0.156862745098039, 0.635294117647059>; // HEX #FE28A2
    #declare farge_Persimmon = rgb <0.925490196078431, 0.345098039215686, 0>; // HEX #EC5800
    #declare farge_Persimmon_juice_color_Kakishibu_iro = rgb <0.576470588235294, 0.262745098039216, 0.215686274509804>; // HEX #934337
    #declare farge_Peru = rgb <0.803921568627451, 0.52156862745098, 0.247058823529412>; // HEX #CD853F
    #declare farge_Philippine_blue = rgb <0, 0.219607843137255, 0.654901960784314>; // HEX #0038A7
    #declare farge_Philippine_bronze = rgb <0.431372549019608, 0.227450980392157, 0.0274509803921569>; // HEX #6E3A07
    #declare farge_Philippine_brown = rgb <0.364705882352941, 0.0980392156862745, 0.0862745098039216>; // HEX #5D1916
    #declare farge_Philippine_gold = rgb <0.694117647058824, 0.450980392156863, 0.0156862745098039>; // HEX #B17304
    #declare farge_Philippine_green = rgb <0, 0.52156862745098, 0.262745098039216>; // HEX #008543
    #declare farge_Philippine_orange = rgb <1, 0.450980392156863, 0>; // HEX #FF7300
    #declare farge_Philippine_pink = rgb <0.980392156862745, 0.101960784313725, 0.556862745098039>; // HEX #FA1A8E
    #declare farge_Philippine_red = rgb <0.807843137254902, 0.0666666666666667, 0.152941176470588>; // HEX #CE1127
    #declare farge_Philippine_violet = rgb <0.505882352941176, 0, 0.498039215686275>; // HEX #81007F
    #declare farge_Philippine_yellow = rgb <0.996078431372549, 0.796078431372549, 0>; // HEX #FECB00
    #declare farge_Phlox = rgb <0.874509803921569, 0, 1>; // HEX #DF00FF
    #declare farge_Phthalo_Blue = rgb <0, 0.0588235294117647, 0.537254901960784>; // HEX #000F89
    #declare farge_Phthalo_Green = rgb <0.0705882352941176, 0.207843137254902, 0.141176470588235>; // HEX #123524
    #declare farge_Picotee_Blue = rgb <0.180392156862745, 0.152941176470588, 0.529411764705882>; // HEX #2E2787
    #declare farge_Picton_Blue = rgb <0.270588235294118, 0.694117647058824, 0.909803921568627>; // HEX #45B1E8
    #declare farge_Pictorial_Carmine = rgb <0.764705882352941, 0.0431372549019608, 0.305882352941176>; // HEX #C30B4E
    #declare farge_Piggy_Pink = rgb <0.992156862745098, 0.866666666666667, 0.901960784313726>; // HEX #FDDDE6
    #declare farge_Pine_Green = rgb <0.00392156862745098, 0.474509803921569, 0.435294117647059>; // HEX #01796F
    #declare farge_Pine_needle_color_Matsuba_iro = rgb <0.270588235294118, 0.301960784313725, 0.196078431372549>; // HEX #454D32
    #declare farge_Pine_Tree = rgb <0.164705882352941, 0.184313725490196, 0.137254901960784>; // HEX #2A2F23
    #declare farge_Pineapple = rgb <0.337254901960784, 0.235294117647059, 0.0509803921568627>; // HEX #563C0D
    #declare farge_Pink = rgb <1, 0.752941176470588, 0.796078431372549>; // HEX #FFC0CB
    #declare farge_Pink_Lace = rgb <1, 0.866666666666667, 0.956862745098039>; // HEX #FFDDF4
    #declare farge_Pink_Lavender = rgb <0.847058823529412, 0.698039215686274, 0.819607843137255>; // HEX #D8B2D1
    #declare farge_Pink_Orange = rgb <1, 0.6, 0.4>; // HEX #FF9966
    #declare farge_Pink_Pantone = rgb <0.843137254901961, 0.282352941176471, 0.580392156862745>; // HEX #D74894
    #declare farge_Pink_Pearl = rgb <0.905882352941176, 0.674509803921569, 0.811764705882353>; // HEX #E7ACCF
    #declare farge_Pink_raspberry = rgb <0.596078431372549, 0, 0.211764705882353>; // HEX #980036
    #declare farge_Pink_Sherbet = rgb <0.968627450980392, 0.56078431372549, 0.654901960784314>; // HEX #F78FA7
    #declare farge_Pistachio = rgb <0.576470588235294, 0.772549019607843, 0.447058823529412>; // HEX #93C572
    #declare farge_Pixie_Powder = rgb <0.223529411764706, 0.0705882352941176, 0.52156862745098>; // HEX #391285
    #declare farge_Plain_mouse_Sunezumi = rgb <0.431372549019608, 0.372549019607843, 0.341176470588235>; // HEX #6E5F57
    #declare farge_Platinum = rgb <0.898039215686275, 0.894117647058824, 0.886274509803922>; // HEX #E5E4E2
    #declare farge_Plum = rgb <0.556862745098039, 0.270588235294118, 0.52156862745098>; // HEX #8E4585
    #declare farge_Plum_blossom_mouse_Umenezumi = rgb <0.592156862745098, 0.392156862745098, 0.352941176470588>; // HEX #97645A
    #declare farge_Plum_dyed_Umezome = rgb <0.980392156862745, 0.572549019607843, 0.345098039215686>; // HEX #FA9258
    #declare farge_Plum_purple_Umemurasaki = rgb <0.56078431372549, 0.254901960784314, 0.333333333333333>; // HEX #8F4155
    #declare farge_Plum_Web = rgb <0.866666666666667, 0.627450980392157, 0.866666666666667>; // HEX #DDA0DD
    #declare farge_Poker_Green = rgb <0.207843137254902, 0.396078431372549, 0.301960784313725>; // HEX #35654D
    #declare farge_Polished_brown_Tonocha = rgb <0.596078431372549, 0.333333333333333, 0.219607843137255>; // HEX #985538
    #declare farge_Polynesian_blue = rgb <0.133333333333333, 0.298039215686275, 0.596078431372549>; // HEX #224C98
    #declare farge_Pomegranate = rgb <0.4, 0.0470588235294118, 0.129411764705882>; // HEX #660C21
    #declare farge_Pomelo = rgb <0.588235294117647, 0.647058823529412, 0.235294117647059>; // HEX #96A53C
    #declare farge_Pomelo_Olive = rgb <0.749019607843137, 0.741176470588235, 0.43921568627451>; // HEX #BFBD70
    #declare farge_Pomelo_White = rgb <0.976470588235294, 1, 0.890196078431372>; // HEX #F9FFE3
    #declare farge_Pomp_And_Power = rgb <0.525490196078431, 0.376470588235294, 0.556862745098039>; // HEX #86608E
    #declare farge_Poppy_Petal = rgb <0.964705882352941, 0.627450980392157, 0.549019607843137>; // HEX #F6A08C
    #declare farge_Popstar = rgb <0.745098039215686, 0.309803921568627, 0.384313725490196>; // HEX #BE4F62
    #declare farge_Porcupine = rgb <0.576470588235294, 0.411764705882353, 0>; // HEX #936900
    #declare farge_Portland_Orange = rgb <1, 0.352941176470588, 0.211764705882353>; // HEX #FF5A36
    #declare farge_Powder_Blue = rgb <0.690196078431373, 0.87843137254902, 0.901960784313726>; // HEX #B0E0E6
    #declare farge_Princess_Perfume = rgb <1, 0.52156862745098, 0.811764705882353>; // HEX #FF85CF
    #declare farge_Princeton_Orange = rgb <0.96078431372549, 0.501960784313725, 0.145098039215686>; // HEX #F58025
    #declare farge_Prune = rgb <0.43921568627451, 0.109803921568627, 0.109803921568627>; // HEX #701C1C
    #declare farge_Prussian_Blue = rgb <0, 0.192156862745098, 0.325490196078431>; // HEX #003153
    #declare farge_Prussian_blue_color_Konjo_iro = rgb <0, 0.192156862745098, 0.443137254901961>; // HEX #003171
    #declare farge_Psychedelic_Purple = rgb <0.874509803921569, 0, 1>; // HEX #DF00FF
    #declare farge_Puce = rgb <0.8, 0.533333333333333, 0.6>; // HEX #CC8899
    #declare farge_Puce_Red = rgb <0.447058823529412, 0.180392156862745, 0.215686274509804>; // HEX #722E37
    #declare farge_Pullman_Brown_UPS_Brown = rgb <0.392156862745098, 0.254901960784314, 0.0901960784313725>; // HEX #644117
    #declare farge_Pullman_Green = rgb <0.231372549019608, 0.2, 0.109803921568627>; // HEX #3B331C
    #declare farge_Pumpkin = rgb <1, 0.458823529411765, 0.0941176470588235>; // HEX #FF7518
    #declare farge_Pure_crimson_dye_Akabeni = rgb <0.764705882352941, 0.152941176470588, 0.168627450980392>; // HEX #C3272B
    #declare farge_Purple = rgb <0.415686274509804, 0.0509803921568627, 0.67843137254902>; // HEX #6A0DAD
    #declare farge_Purple_Heart = rgb <0.411764705882353, 0.207843137254902, 0.611764705882353>; // HEX #69359C
    #declare farge_Purple_kite_Murasakitobi = rgb <0.317647058823529, 0.172549019607843, 0.192156862745098>; // HEX #512C31
    #declare farge_Purple_Mountain_Majesty = rgb <0.588235294117647, 0.470588235294118, 0.713725490196078>; // HEX #9678B6
    #declare farge_Purple_Munsell = rgb <0.623529411764706, 0, 0.772549019607843>; // HEX #9F00C5
    #declare farge_Purple_Murasaki = rgb <0.309803921568627, 0.156862745098039, 0.294117647058824>; // HEX #4F284B
    #declare farge_Purple_Navy = rgb <0.305882352941176, 0.317647058823529, 0.501960784313725>; // HEX #4E5180
    #declare farge_Purple_Pizzazz = rgb <0.996078431372549, 0.305882352941176, 0.854901960784314>; // HEX #FE4EDA
    #declare farge_Purple_Taupe = rgb <0.313725490196078, 0.250980392156863, 0.301960784313725>; // HEX #50404D
    #declare farge_Purple_Web = rgb <0.501960784313725, 0, 0.501960784313725>; // HEX #800080
    #declare farge_Purpureus = rgb <0.603921568627451, 0.305882352941176, 0.682352941176471>; // HEX #9A4EAE
    #declare farge_Quartz = rgb <0.317647058823529, 0.282352941176471, 0.309803921568627>; // HEX #51484F
    #declare farge_Queen_Blue = rgb <0.262745098039216, 0.419607843137255, 0.584313725490196>; // HEX #436B95
    #declare farge_Queen_Pink = rgb <0.909803921568627, 0.8, 0.843137254901961>; // HEX #E8CCD7
    #declare farge_Quinacridone_Magenta = rgb <0.556862745098039, 0.227450980392157, 0.349019607843137>; // HEX #8E3A59
    #declare farge_Quincy = rgb <0.415686274509804, 0.329411764705882, 0.270588235294118>; // HEX #6A5445
    #declare farge_Rabbit_ear_iris_Kakitsubata = rgb <0.286274509803922, 0.117647058823529, 0.235294117647059>; // HEX #491E3C
    #declare farge_Rackley = rgb <0.36078431372549, 0.541176470588235, 0.654901960784314>; // HEX #5C8AA7
    #declare farge_Raisin_Black = rgb <0.141176470588235, 0.129411764705882, 0.141176470588235>; // HEX #242124
    #declare farge_Rajah = rgb <0.984313725490196, 0.670588235294118, 0.376470588235294>; // HEX #FBAB60
    #declare farge_Rambutan = rgb <0.780392156862745, 0.0705882352941176, 0.196078431372549>; // HEX #C71232
    #declare farge_Rambutan_Red = rgb <0.654901960784314, 0.129411764705882, 0.152941176470588>; // HEX #A72127
    #declare farge_Rape_blossom_brown_Nanohanacha = rgb <0.890196078431372, 0.694117647058824, 0.188235294117647>; // HEX #E3B130
    #declare farge_Rapeseed_oil_colored_Nataneyu_iro = rgb <0.631372549019608, 0.474509803921569, 0.0901960784313725>; // HEX #A17917
    #declare farge_Raspberry = rgb <0.890196078431372, 0.0431372549019608, 0.364705882352941>; // HEX #E30B5D
    #declare farge_Raspberry_Glace = rgb <0.568627450980392, 0.372549019607843, 0.427450980392157>; // HEX #915F6D
    #declare farge_Raspberry_Pink = rgb <0.886274509803922, 0.313725490196078, 0.596078431372549>; // HEX #E25098
    #declare farge_Raspberry_Rose = rgb <0.701960784313725, 0.266666666666667, 0.423529411764706>; // HEX #B3446C
    #declare farge_Raw_Sienna = rgb <0.83921568627451, 0.541176470588235, 0.349019607843137>; // HEX #D68A59
    #declare farge_Raw_Umber = rgb <0.509803921568627, 0.4, 0.266666666666667>; // HEX #826644
    #declare farge_Razzle_Dazzle_Rose = rgb <1, 0.2, 0.8>; // HEX #FF33CC
    #declare farge_Razzmatazz = rgb <0.890196078431372, 0.145098039215686, 0.419607843137255>; // HEX #E3256B
    #declare farge_Rebecca_Purple = rgb <0.4, 0.2, 0.6>; // HEX #663399
    #declare farge_Red_bean_color_Azuki_iro = rgb <0.403921568627451, 0.141176470588235, 0.133333333333333>; // HEX #672422
    #declare farge_Red_birch_Benikaba = rgb <0.615686274509804, 0.168627450980392, 0.133333333333333>; // HEX #9D2B22
    #declare farge_Red_bronze_Beniukon = rgb <0.984313725490196, 0.505882352941176, 0.211764705882353>; // HEX #FB8136
    #declare farge_Red_Brown = rgb <0.647058823529412, 0.16078431372549, 0.16078431372549>; // HEX #A52929
    #declare farge_Red_brown_Edo_brown_Edocha = rgb <0.631372549019608, 0.23921568627451, 0.176470588235294>; // HEX #A13D2D
    #declare farge_Red_brown_Kiriume = rgb <0.545098039215686, 0.207843137254902, 0.176470588235294>; // HEX #8B352D
    #declare farge_Red_cola = rgb <0.713725490196078, 0.125490196078431, 0.125490196078431>; // HEX #B62020
    #declare farge_Red_Devil = rgb <0.525490196078431, 0.00392156862745098, 0.0666666666666667>; // HEX #860111
    #declare farge_Red_incense_colored_Akako_iro = rgb <0.941176470588235, 0.498039215686275, 0.368627450980392>; // HEX #F07F5E
    #declare farge_Red_kite_Benitobi = rgb <0.568627450980392, 0.196078431372549, 0.156862745098039>; // HEX #913228
    #declare farge_Red_Munsell = rgb <0.949019607843137, 0, 0.235294117647059>; // HEX #F2003C
    #declare farge_Red_NCS = rgb <0.768627450980392, 0.00784313725490196, 0.2>; // HEX #C40233
    #declare farge_Red_ochre_color_Taisha_iro = rgb <0.623529411764706, 0.32156862745098, 0.2>; // HEX #9F5233
    #declare farge_Red_orange_Shojohi = rgb <0.862745098039216, 0.188235294117647, 0.137254901960784>; // HEX #DC3023
    #declare farge_Red_Pantone = rgb <0.929411764705882, 0.16078431372549, 0.223529411764706>; // HEX #ED2939
    #declare farge_Red_Pigment = rgb <0.929411764705882, 0.109803921568627, 0.141176470588235>; // HEX #ED1C24
    #declare farge_Red_plum_colored_Kobai_iro = rgb <0.858823529411765, 0.352941176470588, 0.419607843137255>; // HEX #DB5A6B
    #declare farge_Red_Purple = rgb <0.894117647058824, 0, 0.470588235294118>; // HEX #E40078
    #declare farge_Red_RYB = rgb <0.996078431372549, 0.152941176470588, 0.0705882352941176>; // HEX #FE2712
    #declare farge_Red_Violet = rgb <0.780392156862745, 0.0823529411764706, 0.52156862745098>; // HEX #C71585
    #declare farge_Red_wisteria_Benifuji = rgb <0.733333333333333, 0.466666666666667, 0.588235294117647>; // HEX #BB7796
    #declare farge_Redwood = rgb <0.643137254901961, 0.352941176470588, 0.32156862745098>; // HEX #A45A52
    #declare farge_Regalia = rgb <0.32156862745098, 0.176470588235294, 0.501960784313725>; // HEX #522D80
    #declare farge_Resolution_Blue = rgb <0, 0.137254901960784, 0.529411764705882>; // HEX #002387
    #declare farge_Rhythm = rgb <0.466666666666667, 0.462745098039216, 0.588235294117647>; // HEX #777696
    #declare farge_Rich_Black = rgb <0, 0.250980392156863, 0.250980392156863>; // HEX #004040
    #declare farge_Rich_Black_FOGRA29 = rgb <0.00392156862745098, 0.0431372549019608, 0.0745098039215686>; // HEX #010B13
    #declare farge_Rich_Black_FOGRA39 = rgb <0.00392156862745098, 0.00784313725490196, 0.0117647058823529>; // HEX #010203
    #declare farge_Rich_Brilliant_Lavender = rgb <0.945098039215686, 0.654901960784314, 0.996078431372549>; // HEX #F1A7FE
    #declare farge_Rich_Carmine = rgb <0.843137254901961, 0, 0.247058823529412>; // HEX #D7003F
    #declare farge_Rich_Electric_Blue = rgb <0.0313725490196078, 0.572549019607843, 0.815686274509804>; // HEX #0892D0
    #declare farge_Rich_gardenia_Kokikuchinashi = rgb <0.96078431372549, 0.498039215686275, 0.309803921568627>; // HEX #F57F4F
    #declare farge_Rich_Lavender = rgb <0.654901960784314, 0.419607843137255, 0.811764705882353>; // HEX #A76BCF
    #declare farge_Rich_Lilac = rgb <0.713725490196078, 0.4, 0.823529411764706>; // HEX #B666D2
    #declare farge_Rich_Maroon = rgb <0.686274509803922, 0.184313725490196, 0.372549019607843>; // HEX #AF2F5F
    #declare farge_Rifle_Green = rgb <0.266666666666667, 0.298039215686275, 0.219607843137255>; // HEX #444C38
    #declare farge_Rikan_brown_Rikancha = rgb <0.325490196078431, 0.290196078431373, 0.196078431372549>; // HEX #534A32
    #declare farge_Rinsed_out_red_Araishu = rgb <1, 0.474509803921569, 0.32156862745098>; // HEX #FF7952
    #declare farge_Ripe_mango = rgb <1, 0.764705882352941, 0.141176470588235>; // HEX #FFC324
    #declare farge_Roast_Coffee = rgb <0.435294117647059, 0.254901960784314, 0.254901960784314>; // HEX #6F4141
    #declare farge_Rocket_Metallic = rgb <0.541176470588235, 0.498039215686275, 0.501960784313725>; // HEX #8A7F80
    #declare farge_Roman_Silver = rgb <0.513725490196078, 0.537254901960784, 0.588235294117647>; // HEX #838996
    #declare farge_Root_beer = rgb <0.16078431372549, 0.0549019607843137, 0.0196078431372549>; // HEX #290E05
    #declare farge_Rose = rgb <1, 0, 0.498039215686275>; // HEX #FF007F
    #declare farge_Rose_Bonbon = rgb <0.976470588235294, 0.258823529411765, 0.619607843137255>; // HEX #F9429E
    #declare farge_Rose_Ebony = rgb <0.403921568627451, 0.282352941176471, 0.274509803921569>; // HEX #674846
    #declare farge_Rose_garnet = rgb <0.588235294117647, 0.00392156862745098, 0.270588235294118>; // HEX #960145
    #declare farge_Rose_Gold = rgb <0.717647058823529, 0.431372549019608, 0.474509803921569>; // HEX #B76E79
    #declare farge_Rose_Madder = rgb <0.890196078431372, 0.149019607843137, 0.211764705882353>; // HEX #E32636
    #declare farge_Rose_Pink = rgb <1, 0.4, 0.8>; // HEX #FF66CC
    #declare farge_Rose_Quartz = rgb <0.666666666666667, 0.596078431372549, 0.662745098039216>; // HEX #AA98A9
    #declare farge_Rose_Red = rgb <0.76078431372549, 0.117647058823529, 0.337254901960784>; // HEX #C21E56
    #declare farge_Rose_Taupe = rgb <0.564705882352941, 0.364705882352941, 0.364705882352941>; // HEX #905D5D
    #declare farge_Rose_Vale = rgb <0.670588235294118, 0.305882352941176, 0.32156862745098>; // HEX #AB4E52
    #declare farge_Rosewood = rgb <0.396078431372549, 0, 0.0431372549019608>; // HEX #65000B
    #declare farge_Rosso_Corsa = rgb <0.831372549019608, 0, 0>; // HEX #D40000
    #declare farge_Royal_Azure = rgb <0, 0.219607843137255, 0.658823529411765>; // HEX #0038A8
    #declare farge_Royal_Blue_2 = rgb <0.254901960784314, 0.411764705882353, 0.87843137254902>; // HEX #4169E0
    #declare farge_Royal_Blue_Dark = rgb <0, 0.137254901960784, 0.4>; // HEX #002366
    #declare farge_Royal_Blue_Light = rgb <0.254901960784314, 0.411764705882353, 0.882352941176471>; // HEX #4169E1
    #declare farge_Royal_brown = rgb <0.32156862745098, 0.231372549019608, 0.207843137254902>; // HEX #523B35
    #declare farge_Royal_Fuchsia = rgb <0.792156862745098, 0.172549019607843, 0.572549019607843>; // HEX #CA2C92
    #declare farge_Royal_green = rgb <0.0745098039215686, 0.384313725490196, 0.0274509803921569>; // HEX #136207
    #declare farge_Royal_orange = rgb <0.976470588235294, 0.572549019607843, 0.270588235294118>; // HEX #F99245
    #declare farge_Royal_pink = rgb <0.905882352941176, 0.219607843137255, 0.584313725490196>; // HEX #E73895
    #declare farge_Royal_Purple = rgb <0.470588235294118, 0.317647058823529, 0.662745098039216>; // HEX #7851A9
    #declare farge_Royal_Red_1 = rgb <0.607843137254902, 0.109803921568627, 0.192156862745098>; // HEX #9B1C31
    #declare farge_Royal_Red_2 = rgb <0.815686274509804, 0, 0.376470588235294>; // HEX #D00060
    #declare farge_Royal_Yellow = rgb <0.980392156862745, 0.854901960784314, 0.368627450980392>; // HEX #FADA5E
    #declare farge_Ruber = rgb <0.807843137254902, 0.274509803921569, 0.462745098039216>; // HEX #CE4676
    #declare farge_Rubine_Red = rgb <0.819607843137255, 0, 0.337254901960784>; // HEX #D10056
    #declare farge_Ruby = rgb <0.87843137254902, 0.0666666666666667, 0.372549019607843>; // HEX #E0115F
    #declare farge_Ruby_Red = rgb <0.607843137254902, 0.0666666666666667, 0.117647058823529>; // HEX #9B111E
    #declare farge_Ruddy = rgb <1, 0, 0.156862745098039>; // HEX #FF0028
    #declare farge_Ruddy_Blue = rgb <0.462745098039216, 0.670588235294118, 0.874509803921569>; // HEX #76ABDF
    #declare farge_Ruddy_Brown = rgb <0.733333333333333, 0.396078431372549, 0.156862745098039>; // HEX #BB6528
    #declare farge_Ruddy_Pink = rgb <0.882352941176471, 0.556862745098039, 0.588235294117647>; // HEX #E18E96
    #declare farge_Rufous = rgb <0.658823529411765, 0.109803921568627, 0.0274509803921569>; // HEX #A81C07
    #declare farge_Rum = rgb <0.443137254901961, 0.4, 0.458823529411765>; // HEX #716675
    #declare farge_Russet = rgb <0.501960784313725, 0.274509803921569, 0.105882352941176>; // HEX #80461B
    #declare farge_Russian_Green = rgb <0.403921568627451, 0.572549019607843, 0.403921568627451>; // HEX #679267
    #declare farge_Russian_Violet = rgb <0.196078431372549, 0.0901960784313725, 0.301960784313725>; // HEX #32174D
    #declare farge_Rust = rgb <0.717647058823529, 0.254901960784314, 0.0549019607843137>; // HEX #B7410E
    #declare farge_Rusted_light_blue_Sabiasagi = rgb <0.415686274509804, 0.498039215686275, 0.47843137254902>; // HEX #6A7F7A
    #declare farge_Rusty_celadon_Sabiseiji = rgb <0.537254901960784, 0.541176470588235, 0.454901960784314>; // HEX #898A74
    #declare farge_Rusty_storage_Sabionando = rgb <0.270588235294118, 0.345098039215686, 0.349019607843137>; // HEX #455859
    #declare farge_Rusty_storeroom_Sabitetsuonando = rgb <0.227450980392157, 0.250980392156863, 0.231372549019608>; // HEX #3A403B
    #declare farge_Sacramento_State_Green = rgb <0.0156862745098039, 0.223529411764706, 0.152941176470588>; // HEX #043927
    #declare farge_Saddle_Brown = rgb <0.545098039215686, 0.270588235294118, 0.0745098039215686>; // HEX #8B4513
    #declare farge_Safety_Orange = rgb <1, 0.470588235294118, 0>; // HEX #FF7800
    #declare farge_Safety_Orange_Blaze_Orange = rgb <1, 0.403921568627451, 0>; // HEX #FF6700
    #declare farge_Safety_Yellow = rgb <0.933333333333333, 0.823529411764706, 0.00784313725490196>; // HEX #EED202
    #declare farge_Safflower_color_Benikakehana_iro = rgb <0.352941176470588, 0.309803921568627, 0.454901960784314>; // HEX #5A4F74
    #declare farge_Saffron = rgb <0.956862745098039, 0.768627450980392, 0.188235294117647>; // HEX #F4C430
    #declare farge_Sage = rgb <0.737254901960784, 0.72156862745098, 0.541176470588235>; // HEX #BCB88A
    #declare farge_Salmon = rgb <0.980392156862745, 0.501960784313725, 0.447058823529412>; // HEX #FA8072
    #declare farge_Salmon_Pink = rgb <1, 0.568627450980392, 0.643137254901961>; // HEX #FF91A4
    #declare farge_Salmon_Rose = rgb <0.905882352941176, 0.588235294117647, 0.545098039215686>; // HEX #E7968B
    #declare farge_Samsung_blue = rgb <0.0705882352941176, 0.152941176470588, 0.619607843137255>; // HEX #12279E
    #declare farge_Sand = rgb <0.76078431372549, 0.698039215686274, 0.501960784313725>; // HEX #C2B280
    #declare farge_Sand_Dune = rgb <0.588235294117647, 0.443137254901961, 0.0901960784313725>; // HEX #967117
    #declare farge_Sandstorm = rgb <0.925490196078431, 0.835294117647059, 0.250980392156863>; // HEX #ECD540
    #declare farge_Sandy_Brown = rgb <0.956862745098039, 0.643137254901961, 0.376470588235294>; // HEX #F4A460
    #declare farge_Sandy_Tan = rgb <0.992156862745098, 0.850980392156863, 0.709803921568627>; // HEX #FDD9B5
    #declare farge_Sandy_Taupe = rgb <0.584313725490196, 0.443137254901961, 0.0862745098039216>; // HEX #957116
    #declare farge_Sangria = rgb <0.572549019607843, 0, 0.0392156862745098>; // HEX #92000A
    #declare farge_Sap_Green = rgb <0.313725490196078, 0.490196078431373, 0.164705882352941>; // HEX #507D2A
    #declare farge_Sappanwood_incense_Suoko = rgb <0.635294117647059, 0.309803921568627, 0.274509803921569>; // HEX #A24F46
    #declare farge_Sappanwood_Suo = rgb <0.494117647058824, 0.149019607843137, 0.223529411764706>; // HEX #7E2639
    #declare farge_Sapphire_1 = rgb <0.0588235294117647, 0.32156862745098, 0.729411764705882>; // HEX #0F52BA
    #declare farge_Sapphire_2 = rgb <0.0313725490196078, 0.145098039215686, 0.403921568627451>; // HEX #082567
    #declare farge_Sapphire_Blue = rgb <0, 0.403921568627451, 0.647058823529412>; // HEX #0067A5
    #declare farge_Sasquatch_Socks = rgb <1, 0.274509803921569, 0.505882352941176>; // HEX #FF4681
    #declare farge_Satin_Sheen_Gold = rgb <0.796078431372549, 0.631372549019608, 0.207843137254902>; // HEX #CBA135
    #declare farge_Savoy_Blue = rgb <0.294117647058824, 0.380392156862745, 0.819607843137255>; // HEX #4B61D1
    #declare farge_Sawtooth_oak_Akashirotsurubami = rgb <0.925490196078431, 0.584313725490196, 0.423529411764706>; // HEX #EC956C
    #declare farge_Scarlet = rgb <1, 0.141176470588235, 0>; // HEX #FF2400
    #declare farge_Scarlet_blood_Ake = rgb <0.811764705882353, 0.227450980392157, 0.141176470588235>; // HEX #CF3A24
    #declare farge_Schauss_Pink = rgb <1, 0.568627450980392, 0.686274509803922>; // HEX #FF91AF
    #declare farge_School_Bus_Yellow = rgb <1, 0.847058823529412, 0>; // HEX #FFD800
    #declare farge_Scorched_brown_Kogecha = rgb <0.207843137254902, 0.12156862745098, 0.0980392156862745>; // HEX #351F19
    #declare farge_Screamin_Green = rgb <0.458823529411765, 1, 0.47843137254902>; // HEX #75FF7A
    #declare farge_Sea_Blue = rgb <0, 0.411764705882353, 0.580392156862745>; // HEX #006994
    #declare farge_Sea_Foam_Green = rgb <0.623529411764706, 0.886274509803922, 0.749019607843137>; // HEX #9FE2BF
    #declare farge_Sea_Green = rgb <0.180392156862745, 0.545098039215686, 0.341176470588235>; // HEX #2E8B57
    #declare farge_Sea_Serpent = rgb <0.294117647058824, 0.780392156862745, 0.811764705882353>; // HEX #4BC7CF
    #declare farge_Seal_Brown = rgb <0.349019607843137, 0.149019607843137, 0.0431372549019608>; // HEX #59260B
    #declare farge_Seashell = rgb <1, 0.96078431372549, 0.933333333333333>; // HEX #FFF5EE
    #declare farge_Selective_Yellow = rgb <1, 0.729411764705882, 0>; // HEX #FFBA00
    #declare farge_Sen_no_Rikyus_tea_Rikyucha = rgb <0.509803921568627, 0.419607843137255, 0.345098039215686>; // HEX #826B58
    #declare farge_Sepia = rgb <0.43921568627451, 0.258823529411765, 0.0784313725490196>; // HEX #704214
    #declare farge_Sesame_Street_Green = rgb <0, 0.658823529411765, 0.43921568627451>; // HEX #00A870
    #declare farge_Shadow = rgb <0.541176470588235, 0.474509803921569, 0.364705882352941>; // HEX #8A795D
    #declare farge_Shampoo = rgb <1, 0.811764705882353, 0.945098039215686>; // HEX #FFCFF1
    #declare farge_Shamrock_Green = rgb <0, 0.619607843137255, 0.376470588235294>; // HEX #009E60
    #declare farge_Shandy = rgb <1, 0.901960784313726, 0.43921568627451>; // HEX #FFE670
    #declare farge_Shocking_Pink = rgb <0.988235294117647, 0.0588235294117647, 0.752941176470588>; // HEX #FC0FC0
    #declare farge_Sienna = rgb <0.533333333333333, 0.176470588235294, 0.0901960784313725>; // HEX #882D17
    #declare farge_Silk_crepe_brown_Omeshicha = rgb <0.207843137254902, 0.305882352941176, 0.294117647058824>; // HEX #354E4B
    #declare farge_Silver_Chalice = rgb <0.674509803921569, 0.674509803921569, 0.674509803921569>; // HEX #ACACAC
    #declare farge_Silver_foil = rgb <0.686274509803922, 0.694117647058824, 0.682352941176471>; // HEX #AFB1AE
    #declare farge_Silver_grey_Ginnezumi = rgb <0.592156862745098, 0.525490196078431, 0.486274509803922>; // HEX #97867C
    #declare farge_Silver_Lake_Blue = rgb <0.364705882352941, 0.537254901960784, 0.729411764705882>; // HEX #5D89BA
    #declare farge_Silver_Metallic = rgb <0.666666666666667, 0.662745098039216, 0.67843137254902>; // HEX #AAA9AD
    #declare farge_Silver_Pink = rgb <0.768627450980392, 0.682352941176471, 0.67843137254902>; // HEX #C4AEAD
    #declare farge_Silver_Sand = rgb <0.749019607843137, 0.756862745098039, 0.76078431372549>; // HEX #BFC1C2
    #declare farge_Simmered_seaweed_Mirucha = rgb <0.298039215686275, 0.23921568627451, 0.188235294117647>; // HEX #4C3D30
    #declare farge_Sinopia = rgb <0.796078431372549, 0.254901960784314, 0.0431372549019608>; // HEX #CB410B
    #declare farge_Siskin_sprout_yellow_Hiwamoegi = rgb <0.47843137254902, 0.580392156862745, 0.180392156862745>; // HEX #7A942E
    #declare farge_Sizzling_Sunrise = rgb <1, 0.858823529411765, 0>; // HEX #FFDB00
    #declare farge_Skobeloff = rgb <0, 0.454901960784314, 0.454901960784314>; // HEX #007474
    #declare farge_Sky_Blue = rgb <0.529411764705882, 0.807843137254902, 0.92156862745098>; // HEX #87CEEB
    #declare farge_Sky_Blue_color_Sora_iro = rgb <0.301960784313725, 0.56078431372549, 0.674509803921569>; // HEX #4D8FAC
    #declare farge_Sky_Magenta = rgb <0.811764705882353, 0.443137254901961, 0.686274509803922>; // HEX #CF71AF
    #declare farge_Slate_Blue = rgb <0.415686274509804, 0.352941176470588, 0.803921568627451>; // HEX #6A5ACD
    #declare farge_Slate_Gray = rgb <0.43921568627451, 0.501960784313725, 0.564705882352941>; // HEX #708090
    #declare farge_Smalt_Dark_Powder_Blue = rgb <0, 0.2, 0.6>; // HEX #003399
    #declare farge_Smashed_Pumpkin = rgb <1, 0.427450980392157, 0.227450980392157>; // HEX #FF6D3A
    #declare farge_Smitten = rgb <0.784313725490196, 0.254901960784314, 0.525490196078431>; // HEX #C84186
    #declare farge_Smoke = rgb <0.450980392156863, 0.509803921568627, 0.462745098039216>; // HEX #738276
    #declare farge_Smoky_Black = rgb <0.0627450980392157, 0.0470588235294118, 0.0313725490196078>; // HEX #100C08
    #declare farge_Smoky_Topaz = rgb <0.576470588235294, 0.23921568627451, 0.254901960784314>; // HEX #933D41
    #declare farge_Snow = rgb <1, 0.980392156862745, 0.980392156862745>; // HEX #FFFAFA
    #declare farge_Soap = rgb <0.807843137254902, 0.784313725490196, 0.937254901960784>; // HEX #CEC8EF
    #declare farge_Soldier_Green = rgb <0.329411764705882, 0.352941176470588, 0.172549019607843>; // HEX #545A2C
    #declare farge_Solid_Pink = rgb <0.537254901960784, 0.219607843137255, 0.262745098039216>; // HEX #893843
    #declare farge_Sooty_willow_bamboo_Yanagisusutake = rgb <0.301960784313725, 0.294117647058824, 0.227450980392157>; // HEX #4D4B3A
    #declare farge_Space_Cadet = rgb <0.113725490196078, 0.16078431372549, 0.317647058823529>; // HEX #1D2951
    #declare farge_Spanish_Bistre = rgb <0.501960784313725, 0.458823529411765, 0.196078431372549>; // HEX #807532
    #declare farge_Spanish_Blue = rgb <0, 0.43921568627451, 0.72156862745098>; // HEX #0070B8
    #declare farge_Spanish_Carmine = rgb <0.819607843137255, 0, 0.27843137254902>; // HEX #D10047
    #declare farge_Spanish_Crimson = rgb <0.898039215686275, 0.101960784313725, 0.298039215686275>; // HEX #E51A4C
    #declare farge_Spanish_Gray = rgb <0.596078431372549, 0.596078431372549, 0.596078431372549>; // HEX #989898
    #declare farge_Spanish_Green = rgb <0, 0.568627450980392, 0.313725490196078>; // HEX #009150
    #declare farge_Spanish_Orange = rgb <0.909803921568627, 0.380392156862745, 0>; // HEX #E86100
    #declare farge_Spanish_Pink = rgb <0.968627450980392, 0.749019607843137, 0.745098039215686>; // HEX #F7BFBE
    #declare farge_Spanish_purple = rgb <0.4, 0.0117647058823529, 0.235294117647059>; // HEX #66033C
    #declare farge_Spanish_Red = rgb <0.901960784313726, 0, 0.149019607843137>; // HEX #E60026
    #declare farge_Spanish_Violet = rgb <0.298039215686275, 0.156862745098039, 0.509803921568627>; // HEX #4C2882
    #declare farge_Spanish_Viridian = rgb <0, 0.498039215686275, 0.36078431372549>; // HEX #007F5C
    #declare farge_Spanish_yellow = rgb <0.964705882352941, 0.709803921568627, 0.0666666666666667>; // HEX #F6B511
    #declare farge_Sparrow_brown_Suzumecha = rgb <0.549019607843137, 0.27843137254902, 0.211764705882353>; // HEX #8C4736
    #declare farge_Spartan_Crimson = rgb <0.619607843137255, 0.0745098039215686, 0.0862745098039216>; // HEX #9E1316
    #declare farge_Spicy_mix = rgb <0.545098039215686, 0.372549019607843, 0.301960784313725>; // HEX #8B5F4D
    #declare farge_Spicy_red_brown_Chinese_tea_brown_Karacha = rgb <0.701960784313725, 0.36078431372549, 0.266666666666667>; // HEX #B35C44
    #declare farge_Spiro_Disco_Ball = rgb <0.0588235294117647, 0.752941176470588, 0.988235294117647>; // HEX #0FC0FC
    #declare farge_Sponge = rgb <0.992156862745098, 0.996078431372549, 0.0117647058823529>; // HEX #FDFE03
    #declare farge_Spring_Bud = rgb <0.654901960784314, 0.988235294117647, 0>; // HEX #A7FC00
    #declare farge_Spring_Frost = rgb <0.529411764705882, 1, 0.164705882352941>; // HEX #87FF2A
    #declare farge_Sprint_Red = rgb <0.925490196078431, 0.129411764705882, 0.192156862745098>; // HEX #EC2131
    #declare farge_Sprint_Yellow = rgb <1, 0.866666666666667, 0.0196078431372549>; // HEX #FFDD05
    #declare farge_St_Patricks_Blue = rgb <0.137254901960784, 0.16078431372549, 0.47843137254902>; // HEX #23297A
    #declare farge_Stained_red_Benimidori = rgb <0.470588235294118, 0.466666666666667, 0.607843137254902>; // HEX #78779B
    #declare farge_Star_Command_Blue = rgb <0, 0.482352941176471, 0.72156862745098>; // HEX #007BB8
    #declare farge_Steamed_chestnut_color_Mushikuri_iro = rgb <0.827450980392157, 0.694117647058824, 0.490196078431373>; // HEX #D3B17D
    #declare farge_Steel_Blue = rgb <0.274509803921569, 0.509803921568627, 0.705882352941177>; // HEX #4682B4
    #declare farge_Steel_Pink = rgb <0.8, 0.2, 0.8>; // HEX #CC33CC
    #declare farge_Stil_de_Grain_Yellow = rgb <0.980392156862745, 0.854901960784314, 0.368627450980392>; // HEX #FADA5E
    #declare farge_Stizza = rgb <0.6, 0, 0>; // HEX #990000
    #declare farge_Stone_Terrace = rgb <0.627450980392157, 0.580392156862745, 0.517647058823529>; // HEX #A09484
    #declare farge_Stop_red = rgb <0.811764705882353, 0.0784313725490196, 0.168627450980392>; // HEX #CF142B
    #declare farge_Storeroom_brown_Onandocha = rgb <0.23921568627451, 0.250980392156863, 0.207843137254902>; // HEX #3D4035
    #declare farge_Stormcloud = rgb <0.309803921568627, 0.4, 0.415686274509804>; // HEX #4F666A
    #declare farge_Straw = rgb <0.894117647058824, 0.850980392156863, 0.435294117647059>; // HEX #E4D96F
    #declare farge_Strawberry = rgb <0.988235294117647, 0.352941176470588, 0.552941176470588>; // HEX #FC5A8D
    #declare farge_Strawberry_Daiquiri = rgb <0.850980392156863, 0.274509803921569, 0.243137254901961>; // HEX #D9463E
    #declare farge_Strawberry_Jam = rgb <0.545098039215686, 0.0901960784313725, 0.101960784313725>; // HEX #8B171A
    #declare farge_Strawberry_red = rgb <0.784313725490196, 0.247058823529412, 0.286274509803922>; // HEX #C83F49
    #declare farge_Strong_boy_pink = rgb <0.913725490196078, 0.223529411764706, 0.619607843137255>; // HEX #E9399E
    #declare farge_Stylish_persimmon_Sharegaki = rgb <1, 0.635294117647059, 0.419607843137255>; // HEX #FFA26B
    #declare farge_Sumac_dyed_Hajizome = rgb <0.87843137254902, 0.541176470588235, 0.117647058823529>; // HEX #E08A1E
    #declare farge_Sumac_dyed_Korozen = rgb <0.349019607843137, 0.168627450980392, 0.12156862745098>; // HEX #592B1F
    #declare farge_Sunburnt_Cyclops = rgb <1, 0.250980392156863, 0.298039215686275>; // HEX #FF404C
    #declare farge_Sunray = rgb <0.890196078431372, 0.670588235294118, 0.341176470588235>; // HEX #E3AB57
    #declare farge_Sunset = rgb <0.980392156862745, 0.83921568627451, 0.647058823529412>; // HEX #FAD6A5
    #declare farge_Sunset_Orange = rgb <0.992156862745098, 0.368627450980392, 0.325490196078431>; // HEX #FD5E53
    #declare farge_Sunset_Yellow = rgb <1, 0.788235294117647, 0.133333333333333>; // HEX #FFC922
    #declare farge_Super_Pink = rgb <0.811764705882353, 0.419607843137255, 0.662745098039216>; // HEX #CF6BA9
    #declare farge_Sweet_Sixteen = rgb <0.949019607843137, 0.619607843137255, 0.670588235294118>; // HEX #F29EAB
    #declare farge_Tan = rgb <0.823529411764706, 0.705882352941177, 0.549019607843137>; // HEX #D2B48C
    #declare farge_Tangelo = rgb <0.976470588235294, 0.301960784313725, 0>; // HEX #F94D00
    #declare farge_Tangerine = rgb <0.949019607843137, 0.52156862745098, 0>; // HEX #F28500
    #declare farge_Tangerine_Yellow = rgb <1, 0.8, 0>; // HEX #FFCC00
    #declare farge_Tango_Pink = rgb <0.894117647058824, 0.443137254901961, 0.47843137254902>; // HEX #E4717A
    #declare farge_Taobao_Orange = rgb <1, 0.258823529411765, 0>; // HEX #FF4200
    #declare farge_Tardis_blue = rgb <0, 0.231372549019608, 0.435294117647059>; // HEX #003B6F
    #declare farge_Tatarian_aster_color_Shion_iro = rgb <0.592156862745098, 0.431372549019608, 0.603921568627451>; // HEX #976E9A
    #declare farge_Taupe = rgb <0.282352941176471, 0.235294117647059, 0.196078431372549>; // HEX #483C32
    #declare farge_Taupe_Gray = rgb <0.545098039215686, 0.52156862745098, 0.537254901960784>; // HEX #8B8589
    #declare farge_Tea_Green = rgb <0.815686274509804, 0.941176470588235, 0.752941176470588>; // HEX #D0F0C0
    #declare farge_Tea_Rose = rgb <0.956862745098039, 0.76078431372549, 0.76078431372549>; // HEX #F4C2C2
    #declare farge_Teal = rgb <0, 0.501960784313725, 0.501960784313725>; // HEX #008080
    #declare farge_Teal_Blue = rgb <0.211764705882353, 0.458823529411765, 0.533333333333333>; // HEX #367588
    #declare farge_Teal_Deer = rgb <0.6, 0.901960784313726, 0.701960784313725>; // HEX #99E6B3
    #declare farge_Teal_Green = rgb <0, 0.509803921568627, 0.498039215686275>; // HEX #00827F
    #declare farge_Telemagenta = rgb <0.811764705882353, 0.203921568627451, 0.462745098039216>; // HEX #CF3476
    #declare farge_Temptress = rgb <0.235294117647059, 0.129411764705882, 0.149019607843137>; // HEX #3C2126
    #declare farge_Tenne_Tawny = rgb <0.803921568627451, 0.341176470588235, 0>; // HEX #CD5700
    #declare farge_Terra_Cotta = rgb <0.886274509803922, 0.447058823529412, 0.356862745098039>; // HEX #E2725B
    #declare farge_The_color_of_an_undried_wall_Namakabe_iro = rgb <0.470588235294118, 0.368627450980392, 0.286274509803922>; // HEX #785E49
    #declare farge_Thin_color_Usu_iro = rgb <0.658823529411765, 0.486274509803922, 0.627450980392157>; // HEX #A87CA0
    #declare farge_Thousand_herb_color_Chigusa_iro = rgb <0.192156862745098, 0.458823529411765, 0.537254901960784>; // HEX #317589
    #declare farge_Thousand_year_old_brown_Sensaicha = rgb <0.231372549019608, 0.203921568627451, 0.16078431372549>; // HEX #3B3429
    #declare farge_Thousand_year_old_green_Sensaimidori = rgb <0.215686274509804, 0.258823529411765, 0.192156862745098>; // HEX #374231
    #declare farge_Thrice_dyed_crimson_Jinzamomi = rgb <0.968627450980392, 0.4, 0.352941176470588>; // HEX #F7665A
    #declare farge_Thulian_Pink = rgb <0.870588235294118, 0.435294117647059, 0.631372549019608>; // HEX #DE6FA1
    #declare farge_Tickle_Me_Pink = rgb <0.988235294117647, 0.537254901960784, 0.674509803921569>; // HEX #FC89AC
    #declare farge_Tiffany_Blue = rgb <0.0392156862745098, 0.729411764705882, 0.709803921568627>; // HEX #0ABAB5
    #declare farge_Tigers_Eye = rgb <0.87843137254902, 0.552941176470588, 0.235294117647059>; // HEX #E08D3C
    #declare farge_Timberwolf = rgb <0.858823529411765, 0.843137254901961, 0.823529411764706>; // HEX #DBD7D2
    #declare farge_Titanium = rgb <0.529411764705882, 0.525490196078431, 0.505882352941176>; // HEX #878681
    #declare farge_Titanium_Yellow = rgb <0.933333333333333, 0.901960784313726, 0>; // HEX #EEE600
    #declare farge_Tomato = rgb <1, 0.388235294117647, 0.27843137254902>; // HEX #FF6347
    #declare farge_Tomato_sauce = rgb <0.698039215686274, 0.0941176470588235, 0.0274509803921569>; // HEX #B21807
    #declare farge_Toolbox = rgb <0.454901960784314, 0.423529411764706, 0.752941176470588>; // HEX #746CC0
    #declare farge_Topaz = rgb <1, 0.784313725490196, 0.486274509803922>; // HEX #FFC87C
    #declare farge_Tractor_Red = rgb <0.992156862745098, 0.0549019607843137, 0.203921568627451>; // HEX #FD0E34
    #declare farge_Tree_peony_Botan = rgb <0.643137254901961, 0.203921568627451, 0.364705882352941>; // HEX #A4345D
    #declare farge_Trolley_Grey = rgb <0.498039215686275, 0.498039215686275, 0.498039215686275>; // HEX #7F7F7F
    #declare farge_Tropical_violet = rgb <0.803921568627451, 0.643137254901961, 0.870588235294118>; // HEX #CDA4DE
    #declare farge_True_Blue_1 = rgb <0, 0.450980392156863, 0.811764705882353>; // HEX #0073CF
    #declare farge_True_Blue_2 = rgb <0.176470588235294, 0.407843137254902, 0.768627450980392>; // HEX #2D68C4
    #declare farge_True_red_Shinshu = rgb <0.56078431372549, 0.113725490196078, 0.129411764705882>; // HEX #8F1D21
    #declare farge_Trypan_Blue = rgb <0.109803921568627, 0.0196078431372549, 0.701960784313725>; // HEX #1C05B3
    #declare farge_Tufts_Blue = rgb <0.243137254901961, 0.556862745098039, 0.870588235294118>; // HEX #3E8EDE
    #declare farge_Tulip = rgb <1, 0.529411764705882, 0.552941176470588>; // HEX #FF878D
    #declare farge_Tumbleweed = rgb <0.870588235294118, 0.666666666666667, 0.533333333333333>; // HEX #DEAA88
    #declare farge_Tumblr = rgb <0.172549019607843, 0.27843137254902, 0.380392156862745>; // HEX #2C4761
    #declare farge_Turkish_Rose = rgb <0.709803921568627, 0.447058823529412, 0.505882352941176>; // HEX #B57281
    #declare farge_Turmeric_colored_Ukon_iro = rgb <0.901960784313726, 0.607843137254902, 0.227450980392157>; // HEX #E69B3A
    #declare farge_Turquoise = rgb <0.250980392156863, 0.87843137254902, 0.815686274509804>; // HEX #40E0D0
    #declare farge_Turquoise_Blue = rgb <0, 1, 0.937254901960784>; // HEX #00FFEF
    #declare farge_Turquoise_Green = rgb <0.627450980392157, 0.83921568627451, 0.705882352941177>; // HEX #A0D6B4
    #declare farge_Turquoise_Surf = rgb <0, 0.772549019607843, 0.803921568627451>; // HEX #00C5CD
    #declare farge_Turtle_Green = rgb <0.541176470588235, 0.603921568627451, 0.356862745098039>; // HEX #8A9A5B
    #declare farge_Tuscan = rgb <0.980392156862745, 0.83921568627451, 0.647058823529412>; // HEX #FAD6A5
    #declare farge_Tuscan_Brown = rgb <0.435294117647059, 0.305882352941176, 0.215686274509804>; // HEX #6F4E37
    #declare farge_Tuscan_Red = rgb <0.486274509803922, 0.282352941176471, 0.282352941176471>; // HEX #7C4848
    #declare farge_Tuscan_Tan = rgb <0.650980392156863, 0.482352941176471, 0.356862745098039>; // HEX #A67B5B
    #declare farge_Tuscany = rgb <0.752941176470588, 0.6, 0.6>; // HEX #C09999
    #declare farge_Twitter_blue = rgb <0.149019607843137, 0.654901960784314, 0.870588235294118>; // HEX #26A7DE
    #declare farge_Tyrian_Purple = rgb <0.4, 0.00784313725490196, 0.235294117647059>; // HEX #66023C
    #declare farge_UA_Blue = rgb <0, 0.2, 0.666666666666667>; // HEX #0033AA
    #declare farge_UA_Red = rgb <0.850980392156863, 0, 0.298039215686275>; // HEX #D9004C
    #declare farge_Ube = rgb <0.533333333333333, 0.470588235294118, 0.764705882352941>; // HEX #8878C3
    #declare farge_UCLA_Blue = rgb <0.325490196078431, 0.407843137254902, 0.584313725490196>; // HEX #536895
    #declare farge_UCLA_Gold = rgb <1, 0.701960784313725, 0>; // HEX #FFB300
    #declare farge_UE_red = rgb <0.729411764705882, 0, 0.00392156862745098>; // HEX #BA0001
    #declare farge_UFO_Green = rgb <0.235294117647059, 0.815686274509804, 0.43921568627451>; // HEX #3CD070
    #declare farge_Ultra_Pink = rgb <1, 0.435294117647059, 1>; // HEX #FF6FFF
    #declare farge_Ultra_Red = rgb <0.988235294117647, 0.423529411764706, 0.52156862745098>; // HEX #FC6C85
    #declare farge_Ultramarine_1 = rgb <0.247058823529412, 0, 1>; // HEX #3F00FF
    #declare farge_Ultramarine_2 = rgb <0.250980392156863, 0, 1>; // HEX #4000FF
    #declare farge_Ultramarine_Blue = rgb <0.254901960784314, 0.4, 0.96078431372549>; // HEX #4166F5
    #declare farge_Ultramarine_color_Gunjo_iro = rgb <0.364705882352941, 0.549019607843137, 0.682352941176471>; // HEX #5D8CAE
    #declare farge_Umber = rgb <0.388235294117647, 0.317647058823529, 0.27843137254902>; // HEX #635147
    #declare farge_Unbleached_Silk = rgb <1, 0.866666666666667, 0.792156862745098>; // HEX #FFDDCA
    #declare farge_Underside_of_willow_leaves_Urahayanagi = rgb <0.737254901960784, 0.709803921568627, 0.549019607843137>; // HEX #BCB58C
    #declare farge_United_Nations_Blue = rgb <0.356862745098039, 0.572549019607843, 0.898039215686275>; // HEX #5B92E5
    #declare farge_University_of_California_Gold = rgb <0.717647058823529, 0.529411764705882, 0.152941176470588>; // HEX #B78727
    #declare farge_University_of_Tennessee_Orange = rgb <0.968627450980392, 0.498039215686275, 0>; // HEX #F77F00
    #declare farge_Unmellow_Yellow = rgb <1, 1, 0.4>; // HEX #FFFF66
    #declare farge_UP_Forest_Green = rgb <0.00392156862745098, 0.266666666666667, 0.129411764705882>; // HEX #014421
    #declare farge_UP_Maroon = rgb <0.482352941176471, 0.0666666666666667, 0.0745098039215686>; // HEX #7B1113
    #declare farge_Upsdell_Red = rgb <0.682352941176471, 0.125490196078431, 0.16078431372549>; // HEX #AE2029
    #declare farge_Uranian_Blue = rgb <0.686274509803922, 0.858823529411765, 0.96078431372549>; // HEX #AFDBF5
    #declare farge_Urobilin = rgb <0.882352941176471, 0.67843137254902, 0.129411764705882>; // HEX #E1AD21
    #declare farge_USAFA_Blue = rgb <0, 0.309803921568627, 0.596078431372549>; // HEX #004F98
    #declare farge_USC_Cardinal = rgb <0.6, 0, 0>; // HEX #990000
    #declare farge_USC_Gold = rgb <1, 0.8, 0>; // HEX #FFCC00
    #declare farge_Utah_Crimson = rgb <0.827450980392157, 0, 0.247058823529412>; // HEX #D3003F
    #declare farge_Vampire_black = rgb <0.0313725490196078, 0.0313725490196078, 0.0313725490196078>; // HEX #080808
    #declare farge_Vanilla = rgb <0.952941176470588, 0.898039215686275, 0.670588235294118>; // HEX #F3E5AB
    #declare farge_Vanilla_Ice = rgb <0.952941176470588, 0.56078431372549, 0.662745098039216>; // HEX #F38FA9
    #declare farge_Vegas_Gold = rgb <0.772549019607843, 0.701960784313725, 0.345098039215686>; // HEX #C5B358
    #declare farge_Velvet_Birodo = rgb <0.133333333333333, 0.274509803921569, 0.203921568627451>; // HEX #224634
    #declare farge_Venetian_Red = rgb <0.784313725490196, 0.0313725490196078, 0.0823529411764706>; // HEX #C80815
    #declare farge_Verdigris = rgb <0.262745098039216, 0.701960784313725, 0.682352941176471>; // HEX #43B3AE
    #declare farge_Verizon_Red = rgb <0.803921568627451, 0.0156862745098039, 0.0431372549019608>; // HEX #CD040B
    #declare farge_Verizon_Red_2000_2015 = rgb <0.925490196078431, 0.109803921568627, 0.141176470588235>; // HEX #EC1C24
    #declare farge_Vermilion = rgb <0.850980392156863, 0.219607843137255, 0.117647058823529>; // HEX #D9381E
    #declare farge_Veronica = rgb <0.627450980392157, 0.125490196078431, 0.941176470588235>; // HEX #A020F0
    #declare farge_Verse_green = rgb <0.0941176470588235, 0.533333333333333, 0.0509803921568627>; // HEX #18880D
    #declare farge_Very_light_azure = rgb <0.454901960784314, 0.733333333333333, 0.984313725490196>; // HEX #74BBFB
    #declare farge_Very_Light_Blue = rgb <0.4, 0.4, 1>; // HEX #6666FF
    #declare farge_Very_Light_Malachite_Green = rgb <0.392156862745098, 0.913725490196078, 0.525490196078431>; // HEX #64E986
    #declare farge_Very_light_tangelo = rgb <1, 0.690196078431373, 0.466666666666667>; // HEX #FFB077
    #declare farge_Very_Pale_Orange = rgb <1, 0.874509803921569, 0.749019607843137>; // HEX #FFDFBF
    #declare farge_Very_Pale_Yellow = rgb <1, 1, 0.749019607843137>; // HEX #FFFFBF
    #declare farge_Vine_grape_Ebizome = rgb <0.427450980392157, 0.168627450980392, 0.313725490196078>; // HEX #6D2B50
    #declare farge_Vine_Green = rgb <0.219607843137255, 0.63921568627451, 0.164705882352941>; // HEX #38A32A
    #declare farge_Violet = rgb <0.56078431372549, 0, 1>; // HEX #8F00FF
    #declare farge_Violet_Blue = rgb <0.196078431372549, 0.290196078431373, 0.698039215686274>; // HEX #324AB2
    #declare farge_Violet_Red_1 = rgb <0.537254901960784, 0.0784313725490196, 0.274509803921569>; // HEX #891446
    #declare farge_Violet_Red_2 = rgb <0.968627450980392, 0.325490196078431, 0.580392156862745>; // HEX #F75394
    #declare farge_Violet_RYB = rgb <0.525490196078431, 0.00392156862745098, 0.686274509803922>; // HEX #8601AF
    #declare farge_Violet_Web = rgb <0.933333333333333, 0.509803921568627, 0.933333333333333>; // HEX #EE82EE
    #declare farge_Violets_Are_Blue = rgb <0.513725490196078, 0.4, 0.956862745098039>; // HEX #8366F4
    #declare farge_Violin_Brown = rgb <0.403921568627451, 0.266666666666667, 0.0117647058823529>; // HEX #674403
    #declare farge_Viridian = rgb <0.250980392156863, 0.509803921568627, 0.427450980392157>; // HEX #40826D
    #declare farge_Viridian_Green = rgb <0, 0.588235294117647, 0.596078431372549>; // HEX #009698
    #declare farge_Vista_Blue = rgb <0.486274509803922, 0.619607843137255, 0.850980392156863>; // HEX #7C9ED9
    #declare farge_Vivaldi_Red = rgb <0.937254901960784, 0.223529411764706, 0.223529411764706>; // HEX #EF3939
    #declare farge_Vivid_Auburn = rgb <0.572549019607843, 0.152941176470588, 0.141176470588235>; // HEX #922724
    #declare farge_Vivid_Burgundy = rgb <0.623529411764706, 0.113725490196078, 0.207843137254902>; // HEX #9F1D35
    #declare farge_Vivid_Cerise = rgb <0.854901960784314, 0.113725490196078, 0.505882352941176>; // HEX #DA1D81
    #declare farge_Vivid_cerulean = rgb <0, 0.666666666666667, 0.933333333333333>; // HEX #00AAEE
    #declare farge_Vivid_crimson = rgb <0.8, 0, 0.2>; // HEX #CC0033
    #declare farge_Vivid_Gamboge = rgb <1, 0.6, 0>; // HEX #FF9900
    #declare farge_Vivid_lime_green = rgb <0.650980392156863, 0.83921568627451, 0.0313725490196078>; // HEX #A6D608
    #declare farge_Vivid_malachite = rgb <0, 0.8, 0.2>; // HEX #00CC33
    #declare farge_Vivid_Mulberry = rgb <0.72156862745098, 0.0470588235294118, 0.890196078431372>; // HEX #B80CE3
    #declare farge_Vivid_Orange = rgb <1, 0.372549019607843, 0>; // HEX #FF5F00
    #declare farge_Vivid_orange_peel = rgb <1, 0.627450980392157, 0>; // HEX #FFA000
    #declare farge_Vivid_Orchid = rgb <0.8, 0, 1>; // HEX #CC00FF
    #declare farge_Vivid_Raspberry = rgb <1, 0, 0.423529411764706>; // HEX #FF006C
    #declare farge_Vivid_Red = rgb <0.968627450980392, 0.0509803921568627, 0.101960784313725>; // HEX #F70D1A
    #declare farge_Vivid_Red_Tangelo = rgb <0.874509803921569, 0.380392156862745, 0.141176470588235>; // HEX #DF6124
    #declare farge_Vivid_Sky_Blue = rgb <0, 0.8, 1>; // HEX #00CCFF
    #declare farge_Vivid_Tangelo = rgb <0.941176470588235, 0.454901960784314, 0.152941176470588>; // HEX #F07427
    #declare farge_Vivid_Tangerine = rgb <1, 0.627450980392157, 0.537254901960784>; // HEX #FFA089
    #declare farge_Vivid_vermilion = rgb <0.898039215686275, 0.376470588235294, 0.141176470588235>; // HEX #E56024
    #declare farge_Vivid_Violet = rgb <0.623529411764706, 0, 1>; // HEX #9F00FF
    #declare farge_Vivid_Yellow = rgb <1, 0.890196078431372, 0.00784313725490196>; // HEX #FFE302
    #declare farge_Vodka = rgb <0.749019607843137, 0.752941176470588, 0.933333333333333>; // HEX #BFC0EE
    #declare farge_Volt = rgb <0.807843137254902, 1, 0>; // HEX #CEFF00
    #declare farge_Wageningen_Green = rgb <0.203921568627451, 0.698039215686274, 0.2>; // HEX #34B233
    #declare farge_Walnut_dyed_Kurumizome = rgb <0.623529411764706, 0.454901960784314, 0.384313725490196>; // HEX #9F7462
    #declare farge_Warm_Black = rgb <0, 0.258823529411765, 0.258823529411765>; // HEX #004242
    #declare farge_Washed_out_crimson_Arazome = rgb <1, 0.701960784313725, 0.654901960784314>; // HEX #FFB3A7
    #declare farge_Washed_out_persimmon_Araigaki = rgb <0.925490196078431, 0.509803921568627, 0.329411764705882>; // HEX #EC8254
    #declare farge_Water = rgb <0.831372549019608, 0.945098039215686, 0.976470588235294>; // HEX #D4F1F9
    #declare farge_Water_persimmon_Mizugaki = rgb <0.709803921568627, 0.423529411764706, 0.376470588235294>; // HEX #B56C60
    #declare farge_Watermelon_Yellow = rgb <0.933333333333333, 1, 0.105882352941176>; // HEX #EEFF1B
    #declare farge_Waterspout = rgb <0.643137254901961, 0.956862745098039, 0.976470588235294>; // HEX #A4F4F9
    #declare farge_Weathered_bamboo_Susutake_iro = rgb <0.349019607843137, 0.227450980392157, 0.152941176470588>; // HEX #593A27
    #declare farge_Weebly_Blue = rgb <0.12156862745098, 0.556862745098039, 0.929411764705882>; // HEX #1F8EED
    #declare farge_Weebly_Orange = rgb <1, 0.603921568627451, 0>; // HEX #FF9A00
    #declare farge_Weldon_Blue = rgb <0.486274509803922, 0.596078431372549, 0.670588235294118>; // HEX #7C98AB
    #declare farge_Wenge = rgb <0.392156862745098, 0.329411764705882, 0.32156862745098>; // HEX #645452
    #declare farge_Wheat = rgb <0.96078431372549, 0.870588235294118, 0.701960784313725>; // HEX #F5DEB3
    #declare farge_White_chocolate = rgb <0.929411764705882, 0.901960784313726, 0.83921568627451>; // HEX #EDE6D6
    #declare farge_White_coffee = rgb <0.901960784313726, 0.87843137254902, 0.831372549019608>; // HEX #E6E0D4
    #declare farge_White_mouse_Shironezumi = rgb <0.725490196078431, 0.631372549019608, 0.576470588235294>; // HEX #B9A193
    #declare farge_White_oak_Shirotsurubami = rgb <0.807843137254902, 0.623529411764706, 0.435294117647059>; // HEX #CE9F6F
    #declare farge_White_Smoke = rgb <0.96078431372549, 0.96078431372549, 0.96078431372549>; // HEX #F5F5F5
    #declare farge_White_tea_colored_Shiracha = rgb <0.768627450980392, 0.556862745098039, 0.411764705882353>; // HEX #C48E69
    #declare farge_Whitish_green_Byakuroku = rgb <0.647058823529412, 0.729411764705882, 0.576470588235294>; // HEX #A5BA93
    #declare farge_Wild_Blue_Yonder = rgb <0.635294117647059, 0.67843137254902, 0.815686274509804>; // HEX #A2ADD0
    #declare farge_Wild_Orchid = rgb <0.831372549019608, 0.43921568627451, 0.635294117647059>; // HEX #D470A2
    #declare farge_Wild_Strawberry = rgb <1, 0.262745098039216, 0.643137254901961>; // HEX #FF43A4
    #declare farge_Wild_Watermelon = rgb <0.988235294117647, 0.423529411764706, 0.52156862745098>; // HEX #FC6C85
    #declare farge_Willow_dye_Yanagizome = rgb <0.549019607843137, 0.619607843137255, 0.368627450980392>; // HEX #8C9E5E
    #declare farge_Willow_grey_Yanaginezumi = rgb <0.505882352941176, 0.482352941176471, 0.411764705882353>; // HEX #817B69
    #declare farge_Willow_tea_Yanagicha = rgb <0.611764705882353, 0.541176470588235, 0.301960784313725>; // HEX #9C8A4D
    #declare farge_Willpower_Orange = rgb <0.992156862745098, 0.345098039215686, 0>; // HEX #FD5800
    #declare farge_Wilted_brown_Shikancha = rgb <0.670588235294118, 0.298039215686275, 0.23921568627451>; // HEX #AB4C3D
    #declare farge_Windsor_Tan = rgb <0.654901960784314, 0.333333333333333, 0.00784313725490196>; // HEX #A75502
    #declare farge_Wine = rgb <0.447058823529412, 0.184313725490196, 0.215686274509804>; // HEX #722F37
    #declare farge_Wine_Dregs = rgb <0.403921568627451, 0.192156862745098, 0.27843137254902>; // HEX #673147
    #declare farge_Wine_red = rgb <0.694117647058824, 0.0705882352941176, 0.149019607843137>; // HEX #B11226
    #declare farge_Winter_Wizard = rgb <0.627450980392157, 0.901960784313726, 1>; // HEX #A0E6FF
    #declare farge_Wisteria_and_burnt_bamboo_Fujisusutake = rgb <0.301960784313725, 0.231372549019608, 0.235294117647059>; // HEX #4D3B3C
    #declare farge_Wisteria_color_Fuji_iro = rgb <0.537254901960784, 0.447058823529412, 0.619607843137255>; // HEX #89729E
    #declare farge_Wisteria_purple_Fujimurasaki = rgb <0.529411764705882, 0.372549019607843, 0.603921568627451>; // HEX #875F9A
    #declare farge_Wood_Brown = rgb <0.756862745098039, 0.603921568627451, 0.419607843137255>; // HEX #C19A6B
    #declare farge_Xanadu = rgb <0.450980392156863, 0.525490196078431, 0.470588235294118>; // HEX #738678
    #declare farge_Xanthic = rgb <0.933333333333333, 0.929411764705882, 0.0352941176470588>; // HEX #EEED09
    #declare farge_Xbox_Green = rgb <0.0549019607843137, 0.47843137254902, 0.0509803921568627>; // HEX #0E7A0D
    #declare farge_Xiaomi_Orange = rgb <0.992156862745098, 0.286274509803922, 0>; // HEX #FD4900
    #declare farge_Xiketic = rgb <0.0470588235294118, 0.00784313725490196, 0.0588235294117647>; // HEX #0C020F
    #declare farge_Yale_Blue = rgb <0.0588235294117647, 0.301960784313725, 0.572549019607843>; // HEX #0F4D92
    #declare farge_Yankees_Blue = rgb <0.109803921568627, 0.156862745098039, 0.254901960784314>; // HEX #1C2841
    #declare farge_Yellow_Green = rgb <0.603921568627451, 0.803921568627451, 0.196078431372549>; // HEX #9ACD32
    #declare farge_Yellow_Munsell = rgb <0.937254901960784, 0.8, 0>; // HEX #EFCC00
    #declare farge_Yellow_NCS = rgb <1, 0.827450980392157, 0>; // HEX #FFD300
    #declare farge_Yellow_Pantone = rgb <0.996078431372549, 0.874509803921569, 0>; // HEX #FEDF00
    #declare farge_Yellow_Process = rgb <1, 0.937254901960784, 0>; // HEX #FFEF00
    #declare farge_Yellow_Rose = rgb <1, 0.941176470588235, 0>; // HEX #FFF000
    #declare farge_Yellow_RYB = rgb <0.996078431372549, 0.996078431372549, 0.2>; // HEX #FEFE33
    #declare farge_Yellow_Sea_pine_brown_Kimirucha = rgb <0.537254901960784, 0.423529411764706, 0.223529411764706>; // HEX #896C39
    #declare farge_YInMn_Blue = rgb <0.180392156862745, 0.313725490196078, 0.564705882352941>; // HEX #2E5090
    #declare farge_Young_bamboo_color_Wakatake_iro = rgb <0.419607843137255, 0.576470588235294, 0.384313725490196>; // HEX #6B9362
    #declare farge_Youtube_red = rgb <0.698039215686274, 0.0274509803921569, 0.113725490196078>; // HEX #B2071D
    #declare farge_Zaffre = rgb <0, 0.0784313725490196, 0.658823529411765>; // HEX #0014A8
    #declare farge_Zinnwaldite = rgb <0.92156862745098, 0.76078431372549, 0.686274509803922>; // HEX #EBC2AF
    #declare farge_Zinnwaldite_Brown = rgb <0.172549019607843, 0.0862745098039216, 0.0313725490196078>; // HEX #2C1608
    #declare farge_Zomp = rgb <0.223529411764706, 0.654901960784314, 0.556862745098039>; // HEX #39A78E

    // Alternative farge color names
    #declare farge_Aqua = Cyan   ; // HEX #00FFFF
    #declare farge_Ash_Grey = farge_Ash_Gray; // HEX #B2BDB5
    #declare farge_Auburn = Brown; // HEX #A52A2A
    #declare farge_Azure = SlateBlue; // HEX #007FFF
    #declare farge_Brass = Brass; // HEX #B5A642
    #declare farge_Chartreuse_Web = MediumSpringGreen; // HEX #7FFF00
    #declare farge_Chinese_Silver = Gray80; // HEX #CCCCCC
    #declare farge_Color_Wheel_Violet = MediumSlateBlue; // HEX #7F00FF
    #declare farge_Copper = Copper; // HEX #B87333
    #declare farge_Dark_charcoal = Gray20; // HEX #333333
    #declare farge_Dark_Medium_Gray = LightGray; // HEX #A8A8A8
    #declare farge_Dark_Orchid = DarkOrchid; // HEX #9932CC
    #declare farge_Dark_Sea_Green = PaleGreen; // HEX #8FBC8F
    #declare farge_Dark_Slate_Gray = DarkSlateGray; // HEX #2F4F4F
    #declare farge_Davys_Grey = DimGray; // HEX #545454
    #declare farge_Duke_Blue = NewMidnightBlue; // HEX #00009C
    #declare farge_Electric_Green = Green  ; // HEX #00FF00
    #declare farge_Fuchsia = Magenta; // HEX #FF00FF
    #declare farge_Gray_Web = Gray50; // HEX #808080
    #declare farge_Guppie_Green = SpringGreen; // HEX #00FF7F
    #declare farge_Italian_blue = farge_Savoy_Blue; // HEX #4B61D1
    #declare farge_Medium_Purple = MediumOrchid; // HEX #9370DB
    #declare farge_Old_Gold = OldGold; // HEX #CFB53B
    #declare farge_Olive_Drab_No3 = MediumForestGreen; // HEX #6B8E23
    #declare farge_Orange_color_wheel = Coral; // HEX #FF7F00
    #declare farge_Pale_red_violet = MediumVioletRed; // HEX #DB7093
    #declare farge_Philippine_gray = Gray55; // HEX #8C8C8C
    #declare farge_Philippine_silver = Gray70; // HEX #B3B3B3
    #declare farge_Rosy_Brown = Pink; // HEX #BC8F8F
    #declare farge_Savoy_Azure = farge_Savoy_Blue; // HEX #4B61D1
    #declare farge_Silver = Gray; // HEX #C0C0C0
    #declare farge_Spanish_Sky_Blue = Cyan   ; // HEX #00FFFF
    #declare farge_Spring_Green = SpringGreen; // HEX #00FF7F
    #declare farge_Thistle = Thistle; // HEX #D8BFD8


    #version farger_f_Inc_Temp;
#end
