// This work is licensed under the Attribution-ShareAlike 4.0 International.
//
//    Persistence of Vision Ray Tracer Include File
//
//    File           : farger_Xona.inc
//    Version        : 4.0
//    Created by     : Sven-Erik Andersen
//    Contact        : sven.erik.andersen@gmail.com
//    Created date   : 2014-06-22
//    Last updated   : 2020-01-19
//    Repository     : https://github.com/SvenErik1968/Farger.inc/
//    Description    : Farger means colors in Norwegian.
//                     
//

#ifndef(farger_Xona_Inc_Temp)
    #declare farger_Xona_Inc_Temp = version;
    #version 3.7;

    // Where the color definition is the same as in the POV-Ray color.inc include file,
    // the color name will point to the POV-Ray color definition,
    // so we need to make sure that file is included
    #ifndef(Colors_Inc_Temp)
        #include "colors.inc"
    #end

    #ifdef(View_POV_Include_Stack)
        #debug "including farger.inc\n"
    #end

    //
    // Colors from the non-gamma Corrected Xona.com color list
    // http://xona.com/misc/colorlist/
    //
    #declare Xona_com_Acadia = rgb <0.105882352941176, 0.0784313725490196, 0.0156862745098039>; // HEX #1B1404
    #declare Xona_com_Acapulco = rgb <0.486274509803922, 0.690196078431373, 0.631372549019608>; // HEX #7CB0A1
    #declare Xona_com_Acorn = rgb <0.415686274509804, 0.364705882352941, 0.105882352941176>; // HEX #6A5D1B
    #declare Xona_com_Aero_Blue = rgb <0.788235294117647, 1, 0.898039215686275>; // HEX #C9FFE5
    #declare Xona_com_Affair = rgb <0.443137254901961, 0.274509803921569, 0.576470588235294>; // HEX #714693
    #declare Xona_com_Afghan_Tan = rgb <0.525490196078431, 0.337254901960784, 0.0392156862745098>; // HEX #86560A
    #declare Xona_com_Akaroa = rgb <0.831372549019608, 0.768627450980392, 0.658823529411765>; // HEX #D4C4A8
    #declare Xona_com_Albescent_White = rgb <0.96078431372549, 0.913725490196078, 0.827450980392157>; // HEX #F5E9D3
    #declare Xona_com_Alert_Tan = rgb <0.607843137254902, 0.27843137254902, 0.0117647058823529>; // HEX #9B4703
    #declare Xona_com_Alice_Blue = rgb <0.941176470588235, 0.972549019607843, 1>; // HEX #F0F8FF
    #declare Xona_com_Alizarin_Crimson = rgb <0.890196078431372, 0.149019607843137, 0.211764705882353>; // HEX #E32636
    #declare Xona_com_Allports = rgb <0, 0.462745098039216, 0.63921568627451>; // HEX #0076A3
    #declare Xona_com_Almond_Frost = rgb <0.564705882352941, 0.482352941176471, 0.443137254901961>; // HEX #907B71
    #declare Xona_com_Alpine = rgb <0.686274509803922, 0.56078431372549, 0.172549019607843>; // HEX #AF8F2C
    #declare Xona_com_Alto = rgb <0.858823529411765, 0.858823529411765, 0.858823529411765>; // HEX #DBDBDB
    #declare Xona_com_Aluminium = rgb <0.662745098039216, 0.674509803921569, 0.713725490196078>; // HEX #A9ACB6
    #declare Xona_com_Amazon = rgb <0.231372549019608, 0.47843137254902, 0.341176470588235>; // HEX #3B7A57
    #declare Xona_com_Americano = rgb <0.529411764705882, 0.458823529411765, 0.431372549019608>; // HEX #87756E
    #declare Xona_com_Amethyst_Smoke = rgb <0.63921568627451, 0.592156862745098, 0.705882352941177>; // HEX #A397B4
    #declare Xona_com_Amour = rgb <0.976470588235294, 0.917647058823529, 0.952941176470588>; // HEX #F9EAF3
    #declare Xona_com_Amulet = rgb <0.482352941176471, 0.623529411764706, 0.501960784313725>; // HEX #7B9F80
    #declare Xona_com_Anakiwa = rgb <0.615686274509804, 0.898039215686275, 1>; // HEX #9DE5FF
    #declare Xona_com_Antique_Brass = rgb <0.43921568627451, 0.290196078431373, 0.0274509803921569>; // HEX #704A07
    #declare Xona_com_Antique_White = rgb <0.980392156862745, 0.92156862745098, 0.843137254901961>; // HEX #FAEBD7
    #declare Xona_com_Antique_White_2 = rgb <1, 0.937254901960784, 0.858823529411765>; // HEX #FFEFDB
    #declare Xona_com_Antique_White_3 = rgb <0.933333333333333, 0.874509803921569, 0.8>; // HEX #EEDFCC
    #declare Xona_com_Antique_White_4 = rgb <0.803921568627451, 0.752941176470588, 0.690196078431373>; // HEX #CDC0B0
    #declare Xona_com_Antique_White_5 = rgb <0.545098039215686, 0.513725490196078, 0.470588235294118>; // HEX #8B8378
    #declare Xona_com_Anzac = rgb <0.87843137254902, 0.713725490196078, 0.274509803921569>; // HEX #E0B646
    #declare Xona_com_Apache = rgb <0.874509803921569, 0.745098039215686, 0.435294117647059>; // HEX #DFBE6F
    #declare Xona_com_Apple = rgb <0.309803921568627, 0.658823529411765, 0.23921568627451>; // HEX #4FA83D
    #declare Xona_com_Apple_Blossom = rgb <0.686274509803922, 0.301960784313725, 0.262745098039216>; // HEX #AF4D43
    #declare Xona_com_Apple_Green = rgb <0.886274509803922, 0.952941176470588, 0.925490196078431>; // HEX #E2F3EC
    #declare Xona_com_Apricot = rgb <0.92156862745098, 0.576470588235294, 0.450980392156863>; // HEX #EB9373
    #declare Xona_com_Apricot_White = rgb <1, 0.996078431372549, 0.925490196078431>; // HEX #FFFEEC
    #declare Xona_com_Aqua = rgb <0.631372549019608, 0.854901960784314, 0.843137254901961>; // HEX #A1DAD7
    #declare Xona_com_Aqua_Haze = rgb <0.929411764705882, 0.96078431372549, 0.96078431372549>; // HEX #EDF5F5
    #declare Xona_com_Aqua_Spring = rgb <0.917647058823529, 0.976470588235294, 0.96078431372549>; // HEX #EAF9F5
    #declare Xona_com_Aqua_Squeeze = rgb <0.909803921568627, 0.96078431372549, 0.949019607843137>; // HEX #E8F5F2
    #declare Xona_com_Aquamarine_1 = rgb <0.498039215686275, 1, 0.831372549019608>; // HEX #7FFFD4
    #declare Xona_com_Aquamarine_2 = rgb <0.462745098039216, 0.933333333333333, 0.776470588235294>; // HEX #76EEC6
    #declare Xona_com_Aquamarine_3 = rgb <0.4, 0.803921568627451, 0.666666666666667>; // HEX #66CDAA
    #declare Xona_com_Aquamarine_4 = rgb <0.270588235294118, 0.545098039215686, 0.454901960784314>; // HEX #458B74
    #declare Xona_com_Aquamarine_Dark = rgb <0.00392156862745098, 0.294117647058824, 0.262745098039216>; // HEX #014B43
    #declare Xona_com_Arapawa = rgb <0.0666666666666667, 0.0470588235294118, 0.423529411764706>; // HEX #110C6C
    #declare Xona_com_Armadillo = rgb <0.262745098039216, 0.243137254901961, 0.215686274509804>; // HEX #433E37
    #declare Xona_com_Arrowtown = rgb <0.580392156862745, 0.529411764705882, 0.443137254901961>; // HEX #948771
    #declare Xona_com_Ash = rgb <0.776470588235294, 0.764705882352941, 0.709803921568627>; // HEX #C6C3B5
    #declare Xona_com_Ash_Brown = rgb <0.180392156862745, 0.0980392156862745, 0.0196078431372549>; // HEX #2E1905
    #declare Xona_com_Asphalt = rgb <0.0745098039215686, 0.0392156862745098, 0.0235294117647059>; // HEX #130A06
    #declare Xona_com_Astra = rgb <0.980392156862745, 0.917647058823529, 0.725490196078431>; // HEX #FAEAB9
    #declare Xona_com_Astral = rgb <0.196078431372549, 0.490196078431373, 0.627450980392157>; // HEX #327DA0
    #declare Xona_com_Astronaut = rgb <0.156862745098039, 0.227450980392157, 0.466666666666667>; // HEX #283A77
    #declare Xona_com_Astronaut_Blue = rgb <0.00392156862745098, 0.243137254901961, 0.384313725490196>; // HEX #013E62
    #declare Xona_com_Athens_Gray = rgb <0.933333333333333, 0.941176470588235, 0.952941176470588>; // HEX #EEF0F3
    #declare Xona_com_Aths_Special = rgb <0.925490196078431, 0.92156862745098, 0.807843137254902>; // HEX #ECEBCE
    #declare Xona_com_Atlantis = rgb <0.592156862745098, 0.803921568627451, 0.176470588235294>; // HEX #97CD2D
    #declare Xona_com_Atoll = rgb <0.0392156862745098, 0.435294117647059, 0.458823529411765>; // HEX #0A6F75
    #declare Xona_com_Atomic = rgb <0.192156862745098, 0.266666666666667, 0.349019607843137>; // HEX #314459
    #declare Xona_com_Au_Chico = rgb <0.592156862745098, 0.376470588235294, 0.364705882352941>; // HEX #97605D
    #declare Xona_com_Aubergine = rgb <0.231372549019608, 0.0352941176470588, 0.0627450980392157>; // HEX #3B0910
    #declare Xona_com_Aureoline_Yellow = rgb <1, 0.658823529411765, 0.141176470588235>; // HEX #FFA824
    #declare Xona_com_Australian_Mint = rgb <0.96078431372549, 1, 0.745098039215686>; // HEX #F5FFBE
    #declare Xona_com_Avocado = rgb <0.533333333333333, 0.552941176470588, 0.396078431372549>; // HEX #888D65
    #declare Xona_com_Axolotl = rgb <0.305882352941176, 0.4, 0.286274509803922>; // HEX #4E6649
    #declare Xona_com_Azalea = rgb <0.968627450980392, 0.784313725490196, 0.854901960784314>; // HEX #F7C8DA
    #declare Xona_com_Aztec = rgb <0.0509803921568627, 0.109803921568627, 0.0980392156862745>; // HEX #0D1C19
    #declare Xona_com_Azure = rgb <0.941176470588235, 1, 1>; // HEX #F0FFFF
    #declare Xona_com_Azure_Blue = rgb <0.192156862745098, 0.356862745098039, 0.631372549019608>; // HEX #315BA1
    #declare Xona_com_Azure2 = rgb <0.87843137254902, 0.933333333333333, 0.933333333333333>; // HEX #E0EEEE
    #declare Xona_com_Azure3 = rgb <0.756862745098039, 0.803921568627451, 0.803921568627451>; // HEX #C1CDCD
    #declare Xona_com_Azure4 = rgb <0.513725490196078, 0.545098039215686, 0.545098039215686>; // HEX #838B8B
    #declare Xona_com_Bahama_Blue = rgb <0.00784313725490196, 0.388235294117647, 0.584313725490196>; // HEX #026395
    #declare Xona_com_Bahia = rgb <0.647058823529412, 0.796078431372549, 0.0470588235294118>; // HEX #A5CB0C
    #declare Xona_com_Baja_White = rgb <1, 0.972549019607843, 0.819607843137255>; // HEX #FFF8D1
    #declare Xona_com_Bali_Hai = rgb <0.52156862745098, 0.623529411764706, 0.686274509803922>; // HEX #859FAF
    #declare Xona_com_Baltic_Sea = rgb <0.164705882352941, 0.149019607843137, 0.188235294117647>; // HEX #2A2630
    #declare Xona_com_Bamboo = rgb <0.854901960784314, 0.388235294117647, 0.0156862745098039>; // HEX #DA6304
    #declare Xona_com_Banana = rgb <0.890196078431372, 0.811764705882353, 0.341176470588235>; // HEX #E3CF57
    #declare Xona_com_Bandicoot = rgb <0.52156862745098, 0.517647058823529, 0.43921568627451>; // HEX #858470
    #declare Xona_com_Banjul = rgb <0.0745098039215686, 0.0392156862745098, 0.0235294117647059>; // HEX #130A06
    #declare Xona_com_Barberry = rgb <0.870588235294118, 0.843137254901961, 0.0901960784313725>; // HEX #DED717
    #declare Xona_com_Barley_Corn = rgb <0.650980392156863, 0.545098039215686, 0.356862745098039>; // HEX #A68B5B
    #declare Xona_com_Barley_White = rgb <1, 0.956862745098039, 0.807843137254902>; // HEX #FFF4CE
    #declare Xona_com_Barossa = rgb <0.266666666666667, 0.00392156862745098, 0.176470588235294>; // HEX #44012D
    #declare Xona_com_Bastille = rgb <0.16078431372549, 0.129411764705882, 0.188235294117647>; // HEX #292130
    #declare Xona_com_Battleship_Gray = rgb <0.509803921568627, 0.56078431372549, 0.447058823529412>; // HEX #828F72
    #declare Xona_com_Bay_Leaf = rgb <0.490196078431373, 0.662745098039216, 0.552941176470588>; // HEX #7DA98D
    #declare Xona_com_Bay_Of_Many = rgb <0.152941176470588, 0.227450980392157, 0.505882352941176>; // HEX #273A81
    #declare Xona_com_Bazaar = rgb <0.596078431372549, 0.466666666666667, 0.482352941176471>; // HEX #98777B
    #declare Xona_com_Bean = rgb <0.23921568627451, 0.0470588235294118, 0.00784313725490196>; // HEX #3D0C02
    #declare Xona_com_Beauty_Bush = rgb <0.933333333333333, 0.756862745098039, 0.745098039215686>; // HEX #EEC1BE
    #declare Xona_com_Beeswax = rgb <0.996078431372549, 0.949019607843137, 0.780392156862745>; // HEX #FEF2C7
    #declare Xona_com_Beige = rgb <0.63921568627451, 0.580392156862745, 0.501960784313725>; // HEX #A39480
    #declare Xona_com_Beige2 = rgb <0.96078431372549, 0.96078431372549, 0.862745098039216>; // HEX #F5F5DC
    #declare Xona_com_Bermuda = rgb <0.490196078431373, 0.847058823529412, 0.776470588235294>; // HEX #7DD8C6
    #declare Xona_com_Bermuda_Gray = rgb <0.419607843137255, 0.545098039215686, 0.635294117647059>; // HEX #6B8BA2
    #declare Xona_com_Beryl_Green = rgb <0.870588235294118, 0.898039215686275, 0.752941176470588>; // HEX #DEE5C0
    #declare Xona_com_Bianca = rgb <0.988235294117647, 0.984313725490196, 0.952941176470588>; // HEX #FCFBF3
    #declare Xona_com_Big_Stone = rgb <0.0862745098039216, 0.164705882352941, 0.250980392156863>; // HEX #162A40
    #declare Xona_com_Bilbao = rgb <0.196078431372549, 0.486274509803922, 0.0784313725490196>; // HEX #327C14
    #declare Xona_com_Biloba_Flower = rgb <0.698039215686274, 0.631372549019608, 0.917647058823529>; // HEX #B2A1EA
    #declare Xona_com_Birch = rgb <0.215686274509804, 0.188235294117647, 0.129411764705882>; // HEX #373021
    #declare Xona_com_Bird_Flower = rgb <0.831372549019608, 0.803921568627451, 0.0862745098039216>; // HEX #D4CD16
    #declare Xona_com_Biscay = rgb <0.105882352941176, 0.192156862745098, 0.384313725490196>; // HEX #1B3162
    #declare Xona_com_Bismark = rgb <0.286274509803922, 0.443137254901961, 0.513725490196078>; // HEX #497183
    #declare Xona_com_Bison_Hide = rgb <0.756862745098039, 0.717647058823529, 0.643137254901961>; // HEX #C1B7A4
    #declare Xona_com_Bisque_1 = rgb <1, 0.894117647058824, 0.768627450980392>; // HEX #FFE4C4
    #declare Xona_com_Bisque_2 = rgb <0.933333333333333, 0.835294117647059, 0.717647058823529>; // HEX #EED5B7
    #declare Xona_com_Bisque_3 = rgb <0.803921568627451, 0.717647058823529, 0.619607843137255>; // HEX #CDB79E
    #declare Xona_com_Bisque_4 = rgb <0.545098039215686, 0.490196078431373, 0.419607843137255>; // HEX #8B7D6B
    #declare Xona_com_Bitter = rgb <0.525490196078431, 0.537254901960784, 0.454901960784314>; // HEX #868974
    #declare Xona_com_Bitter_Lemon = rgb <0.792156862745098, 0.87843137254902, 0.0509803921568627>; // HEX #CAE00D
    #declare Xona_com_Bizarre = rgb <0.933333333333333, 0.870588235294118, 0.854901960784314>; // HEX #EEDEDA
    #declare Xona_com_Black_Bean = rgb <0.0313725490196078, 0.0980392156862745, 0.0627450980392157>; // HEX #081910
    #declare Xona_com_Black_Forest = rgb <0.0431372549019608, 0.0745098039215686, 0.0156862745098039>; // HEX #0B1304
    #declare Xona_com_Black_Haze = rgb <0.964705882352941, 0.968627450980392, 0.968627450980392>; // HEX #F6F7F7
    #declare Xona_com_Black_Magic = rgb <0.145098039215686, 0.0901960784313725, 0.0235294117647059>; // HEX #251706
    #declare Xona_com_Black_Marlin = rgb <0.243137254901961, 0.172549019607843, 0.109803921568627>; // HEX #3E2C1C
    #declare Xona_com_Black_Pearl = rgb <0.0156862745098039, 0.0745098039215686, 0.133333333333333>; // HEX #041322
    #declare Xona_com_Black_Pepper = rgb <0.0549019607843137, 0.0549019607843137, 0.0941176470588235>; // HEX #0E0E18
    #declare Xona_com_Black_Rock = rgb <0.0509803921568627, 0.0117647058823529, 0.196078431372549>; // HEX #0D0332
    #declare Xona_com_Black_Rose = rgb <0.403921568627451, 0.0117647058823529, 0.176470588235294>; // HEX #67032D
    #declare Xona_com_Black_Russian = rgb <0.0392156862745098, 0, 0.109803921568627>; // HEX #0A001C
    #declare Xona_com_Black_Squeeze = rgb <0.949019607843137, 0.980392156862745, 0.980392156862745>; // HEX #F2FAFA
    #declare Xona_com_Black_White = rgb <1, 0.996078431372549, 0.964705882352941>; // HEX #FFFEF6
    #declare Xona_com_Blackberry = rgb <0.301960784313725, 0.00392156862745098, 0.207843137254902>; // HEX #4D0135
    #declare Xona_com_Blackcurrant = rgb <0.196078431372549, 0.16078431372549, 0.227450980392157>; // HEX #32293A
    #declare Xona_com_Blackwood = rgb <0.149019607843137, 0.0666666666666667, 0.0196078431372549>; // HEX #261105
    #declare Xona_com_Blanc = rgb <0.96078431372549, 0.913725490196078, 0.827450980392157>; // HEX #F5E9D3
    #declare Xona_com_Blanched_Almond = rgb <1, 0.92156862745098, 0.803921568627451>; // HEX #FFEBCD
    #declare Xona_com_Bleach_White = rgb <0.996078431372549, 0.952941176470588, 0.847058823529412>; // HEX #FEF3D8
    #declare Xona_com_Bleached_Cedar = rgb <0.172549019607843, 0.129411764705882, 0.2>; // HEX #2C2133
    #declare Xona_com_Blossom = rgb <0.862745098039216, 0.705882352941177, 0.737254901960784>; // HEX #DCB4BC
    #declare Xona_com_Blue_2 = rgb <0, 0, 0.933333333333333>; // HEX #0000EE
    #declare Xona_com_Blue_3 = rgb <0, 0, 0.803921568627451>; // HEX #0000CD
    #declare Xona_com_Blue_4 = rgb <0, 0, 0.545098039215686>; // HEX #00008B
    #declare Xona_com_Blue_Bark = rgb <0.0156862745098039, 0.0745098039215686, 0.133333333333333>; // HEX #041322
    #declare Xona_com_Blue_Bayoux = rgb <0.286274509803922, 0.4, 0.474509803921569>; // HEX #496679
    #declare Xona_com_Blue_Bell = rgb <0.133333333333333, 0.0313725490196078, 0.470588235294118>; // HEX #220878
    #declare Xona_com_Blue_Chalk = rgb <0.945098039215686, 0.913725490196078, 1>; // HEX #F1E9FF
    #declare Xona_com_Blue_Charcoal = rgb <0.00392156862745098, 0.0509803921568627, 0.101960784313725>; // HEX #010D1A
    #declare Xona_com_Blue_Chill = rgb <0.0470588235294118, 0.537254901960784, 0.564705882352941>; // HEX #0C8990
    #declare Xona_com_Blue_Diamond = rgb <0.219607843137255, 0.0156862745098039, 0.454901960784314>; // HEX #380474
    #declare Xona_com_Blue_Dianne = rgb <0.125490196078431, 0.282352941176471, 0.32156862745098>; // HEX #204852
    #declare Xona_com_Blue_Gem = rgb <0.172549019607843, 0.0549019607843137, 0.549019607843137>; // HEX #2C0E8C
    #declare Xona_com_Blue_Haze = rgb <0.749019607843137, 0.745098039215686, 0.847058823529412>; // HEX #BFBED8
    #declare Xona_com_Blue_Lagoon = rgb <0.00392156862745098, 0.474509803921569, 0.529411764705882>; // HEX #017987
    #declare Xona_com_Blue_Light = rgb <0.67843137254902, 0.847058823529412, 0.901960784313726>; // HEX #ADD8E6
    #declare Xona_com_Blue_Marguerite = rgb <0.462745098039216, 0.4, 0.776470588235294>; // HEX #7666C6
    #declare Xona_com_Blue_Romance = rgb <0.823529411764706, 0.964705882352941, 0.870588235294118>; // HEX #D2F6DE
    #declare Xona_com_Blue_Smoke = rgb <0.454901960784314, 0.533333333333333, 0.505882352941176>; // HEX #748881
    #declare Xona_com_Blue_Stone = rgb <0.00392156862745098, 0.380392156862745, 0.384313725490196>; // HEX #016162
    #declare Xona_com_Blue_Violet = rgb <0.541176470588235, 0.168627450980392, 0.886274509803922>; // HEX #8A2BE2
    #declare Xona_com_Blue_Whale = rgb <0.0156862745098039, 0.180392156862745, 0.298039215686275>; // HEX #042E4C
    #declare Xona_com_Blue_Zodiac = rgb <0.0745098039215686, 0.149019607843137, 0.301960784313725>; // HEX #13264D
    #declare Xona_com_Blumine = rgb <0.0941176470588235, 0.345098039215686, 0.47843137254902>; // HEX #18587A
    #declare Xona_com_Blush = rgb <0.705882352941177, 0.274509803921569, 0.407843137254902>; // HEX #B44668
    #declare Xona_com_Bokara_Gray = rgb <0.109803921568627, 0.0705882352941176, 0.0313725490196078>; // HEX #1C1208
    #declare Xona_com_Bombay = rgb <0.686274509803922, 0.694117647058824, 0.72156862745098>; // HEX #AFB1B8
    #declare Xona_com_Bon_Jour = rgb <0.898039215686275, 0.87843137254902, 0.882352941176471>; // HEX #E5E0E1
    #declare Xona_com_Bondi_Blue = rgb <0.00784313725490196, 0.27843137254902, 0.556862745098039>; // HEX #02478E
    #declare Xona_com_Bone = rgb <0.894117647058824, 0.819607843137255, 0.752941176470588>; // HEX #E4D1C0
    #declare Xona_com_Bordeaux = rgb <0.36078431372549, 0.00392156862745098, 0.125490196078431>; // HEX #5C0120
    #declare Xona_com_Bossanova = rgb <0.305882352941176, 0.164705882352941, 0.352941176470588>; // HEX #4E2A5A
    #declare Xona_com_Boston_Blue = rgb <0.231372549019608, 0.568627450980392, 0.705882352941177>; // HEX #3B91B4
    #declare Xona_com_Botticelli = rgb <0.780392156862745, 0.866666666666667, 0.898039215686275>; // HEX #C7DDE5
    #declare Xona_com_Bottle_Green = rgb <0.0352941176470588, 0.211764705882353, 0.141176470588235>; // HEX #093624
    #declare Xona_com_Boulder = rgb <0.47843137254902, 0.47843137254902, 0.47843137254902>; // HEX #7A7A7A
    #declare Xona_com_Bouquet = rgb <0.682352941176471, 0.501960784313725, 0.619607843137255>; // HEX #AE809E
    #declare Xona_com_Bourbon = rgb <0.729411764705882, 0.435294117647059, 0.117647058823529>; // HEX #BA6F1E
    #declare Xona_com_Bracken = rgb <0.290196078431373, 0.164705882352941, 0.0156862745098039>; // HEX #4A2A04
    #declare Xona_com_Brandy = rgb <0.870588235294118, 0.756862745098039, 0.588235294117647>; // HEX #DEC196
    #declare Xona_com_Brandy_Punch = rgb <0.803921568627451, 0.517647058823529, 0.16078431372549>; // HEX #CD8429
    #declare Xona_com_Brandy_Rose = rgb <0.733333333333333, 0.537254901960784, 0.513725490196078>; // HEX #BB8983
    #declare Xona_com_Brazil = rgb <0.533333333333333, 0.384313725490196, 0.129411764705882>; // HEX #886221
    #declare Xona_com_Breaker_Bay = rgb <0.364705882352941, 0.631372549019608, 0.623529411764706>; // HEX #5DA19F
    #declare Xona_com_Brick = rgb <0.611764705882353, 0.4, 0.12156862745098>; // HEX #9C661F
    #declare Xona_com_Bridal_Heath = rgb <1, 0.980392156862745, 0.956862745098039>; // HEX #FFFAF4
    #declare Xona_com_Bridesmaid = rgb <0.996078431372549, 0.941176470588235, 0.925490196078431>; // HEX #FEF0EC
    #declare Xona_com_Bright_Gray = rgb <0.235294117647059, 0.254901960784314, 0.317647058823529>; // HEX #3C4151
    #declare Xona_com_Bright_Red = rgb <0.694117647058824, 0, 0>; // HEX #B10000
    #declare Xona_com_Bright_Sun = rgb <0.996078431372549, 0.827450980392157, 0.235294117647059>; // HEX #FED33C
    #declare Xona_com_Bronco = rgb <0.670588235294118, 0.631372549019608, 0.588235294117647>; // HEX #ABA196
    #declare Xona_com_Bronze = rgb <0.247058823529412, 0.129411764705882, 0.0352941176470588>; // HEX #3F2109
    #declare Xona_com_Bronze_Olive = rgb <0.305882352941176, 0.258823529411765, 0.0470588235294118>; // HEX #4E420C
    #declare Xona_com_Bronzetone = rgb <0.301960784313725, 0.250980392156863, 0.0588235294117647>; // HEX #4D400F
    #declare Xona_com_Broom = rgb <1, 0.925490196078431, 0.0745098039215686>; // HEX #FFEC13
    #declare Xona_com_Brown_1 = rgb <1, 0.250980392156863, 0.250980392156863>; // HEX #FF4040
    #declare Xona_com_Brown_2 = rgb <0.933333333333333, 0.231372549019608, 0.231372549019608>; // HEX #EE3B3B
    #declare Xona_com_Brown_3 = rgb <0.803921568627451, 0.2, 0.2>; // HEX #CD3333
    #declare Xona_com_Brown_4 = rgb <0.501960784313725, 0.164705882352941, 0.164705882352941>; // HEX #802A2A
    #declare Xona_com_Brown_5 = rgb <0.545098039215686, 0.137254901960784, 0.137254901960784>; // HEX #8B2323
    #declare Xona_com_Brown_Bramble = rgb <0.349019607843137, 0.156862745098039, 0.0156862745098039>; // HEX #592804
    #declare Xona_com_Brown_Derby = rgb <0.286274509803922, 0.149019607843137, 0.0823529411764706>; // HEX #492615
    #declare Xona_com_Brown_Madder = rgb <0.858823529411765, 0.16078431372549, 0.16078431372549>; // HEX #DB2929
    #declare Xona_com_Brown_Ochre = rgb <0.529411764705882, 0.258823529411765, 0.12156862745098>; // HEX #87421F
    #declare Xona_com_Brown_Pod = rgb <0.250980392156863, 0.0941176470588235, 0.00392156862745098>; // HEX #401801
    #declare Xona_com_Bubbles = rgb <0.905882352941176, 0.996078431372549, 1>; // HEX #E7FEFF
    #declare Xona_com_Buccaneer = rgb <0.384313725490196, 0.184313725490196, 0.188235294117647>; // HEX #622F30
    #declare Xona_com_Bud = rgb <0.658823529411765, 0.682352941176471, 0.611764705882353>; // HEX #A8AE9C
    #declare Xona_com_Buddha_Gold = rgb <0.756862745098039, 0.627450980392157, 0.0156862745098039>; // HEX #C1A004
    #declare Xona_com_Bulgarian_Rose = rgb <0.282352941176471, 0.0235294117647059, 0.0274509803921569>; // HEX #480607
    #declare Xona_com_Bull_Shot = rgb <0.525490196078431, 0.301960784313725, 0.117647058823529>; // HEX #864D1E
    #declare Xona_com_Bunker = rgb <0.0509803921568627, 0.0666666666666667, 0.0901960784313725>; // HEX #0D1117
    #declare Xona_com_Bunting = rgb <0.0823529411764706, 0.12156862745098, 0.298039215686275>; // HEX #151F4C
    #declare Xona_com_Burgundy = rgb <0.466666666666667, 0.0588235294117647, 0.0196078431372549>; // HEX #770F05
    #declare Xona_com_Burlywood = rgb <0.870588235294118, 0.72156862745098, 0.529411764705882>; // HEX #DEB887
    #declare Xona_com_Burlywood_1 = rgb <1, 0.827450980392157, 0.607843137254902>; // HEX #FFD39B
    #declare Xona_com_Burlywood_2 = rgb <0.933333333333333, 0.772549019607843, 0.568627450980392>; // HEX #EEC591
    #declare Xona_com_Burlywood_3 = rgb <0.803921568627451, 0.666666666666667, 0.490196078431373>; // HEX #CDAA7D
    #declare Xona_com_Burlywood_4 = rgb <0.545098039215686, 0.450980392156863, 0.333333333333333>; // HEX #8B7355
    #declare Xona_com_Burnham = rgb <0, 0.180392156862745, 0.125490196078431>; // HEX #002E20
    #declare Xona_com_Burning_Sand = rgb <0.850980392156863, 0.576470588235294, 0.462745098039216>; // HEX #D99376
    #declare Xona_com_Burnt_Crimson = rgb <0.396078431372549, 0, 0.0431372549019608>; // HEX #65000B
    #declare Xona_com_Burnt_Sienna = rgb <0.541176470588235, 0.211764705882353, 0.0588235294117647>; // HEX #8A360F
    #declare Xona_com_Burnt_Umber = rgb <0.541176470588235, 0.2, 0.141176470588235>; // HEX #8A3324
    #declare Xona_com_Bush = rgb <0.0509803921568627, 0.180392156862745, 0.109803921568627>; // HEX #0D2E1C
    #declare Xona_com_Buttercup = rgb <0.952941176470588, 0.67843137254902, 0.0862745098039216>; // HEX #F3AD16
    #declare Xona_com_Buttered_Rum = rgb <0.631372549019608, 0.458823529411765, 0.0509803921568627>; // HEX #A1750D
    #declare Xona_com_Butterfly_Bush = rgb <0.384313725490196, 0.305882352941176, 0.603921568627451>; // HEX #624E9A
    #declare Xona_com_Buttermilk = rgb <1, 0.945098039215686, 0.709803921568627>; // HEX #FFF1B5
    #declare Xona_com_Buttery_White = rgb <1, 0.988235294117647, 0.917647058823529>; // HEX #FFFCEA
    #declare Xona_com_Cab_Sav = rgb <0.301960784313725, 0.0392156862745098, 0.0941176470588235>; // HEX #4D0A18
    #declare Xona_com_Cabaret = rgb <0.850980392156863, 0.286274509803922, 0.447058823529412>; // HEX #D94972
    #declare Xona_com_Cabbage_Pont = rgb <0.247058823529412, 0.298039215686275, 0.227450980392157>; // HEX #3F4C3A
    #declare Xona_com_Cactus = rgb <0.345098039215686, 0.443137254901961, 0.337254901960784>; // HEX #587156
    #declare Xona_com_Cadet = rgb <0.372549019607843, 0.619607843137255, 0.627450980392157>; // HEX #5F9EA0
    #declare Xona_com_Cadet_Blue = rgb <0.372549019607843, 0.619607843137255, 0.627450980392157>; // HEX #5F9EA0
    #declare Xona_com_Cadet_Blue_1 = rgb <0.596078431372549, 0.96078431372549, 1>; // HEX #98F5FF
    #declare Xona_com_Cadet_Blue_2 = rgb <0.556862745098039, 0.898039215686275, 0.933333333333333>; // HEX #8EE5EE
    #declare Xona_com_Cadet_Blue_3 = rgb <0.47843137254902, 0.772549019607843, 0.803921568627451>; // HEX #7AC5CD
    #declare Xona_com_Cadet_Blue_4 = rgb <0.325490196078431, 0.525490196078431, 0.545098039215686>; // HEX #53868B
    #declare Xona_com_Cadillac = rgb <0.690196078431373, 0.298039215686275, 0.415686274509804>; // HEX #B04C6A
    #declare Xona_com_Cadmium_Lemon = rgb <1, 0.890196078431372, 0.0117647058823529>; // HEX #FFE303
    #declare Xona_com_Cadmium_Orange = rgb <1, 0.380392156862745, 0.0117647058823529>; // HEX #FF6103
    #declare Xona_com_Cadmium_Red_Deep = rgb <0.890196078431372, 0.0901960784313725, 0.0509803921568627>; // HEX #E3170D
    #declare Xona_com_Cadmium_Red_Light = rgb <1, 0.0117647058823529, 0.0509803921568627>; // HEX #FF030D
    #declare Xona_com_Cadmium_Yellow = rgb <1, 0.6, 0.0705882352941176>; // HEX #FF9912
    #declare Xona_com_Cadmium_Yellow_Light = rgb <1, 0.690196078431373, 0.0588235294117647>; // HEX #FFB00F
    #declare Xona_com_Cafe_Royale = rgb <0.435294117647059, 0.266666666666667, 0.0470588235294118>; // HEX #6F440C
    #declare Xona_com_Calico = rgb <0.87843137254902, 0.752941176470588, 0.584313725490196>; // HEX #E0C095
    #declare Xona_com_California = rgb <0.996078431372549, 0.615686274509804, 0.0156862745098039>; // HEX #FE9D04
    #declare Xona_com_Calypso = rgb <0.192156862745098, 0.447058823529412, 0.552941176470588>; // HEX #31728D
    #declare Xona_com_Camarone = rgb <0, 0.345098039215686, 0.101960784313725>; // HEX #00581A
    #declare Xona_com_Camelot = rgb <0.537254901960784, 0.203921568627451, 0.337254901960784>; // HEX #893456
    #declare Xona_com_Cameo = rgb <0.850980392156863, 0.725490196078431, 0.607843137254902>; // HEX #D9B99B
    #declare Xona_com_Camouflage = rgb <0.235294117647059, 0.223529411764706, 0.0627450980392157>; // HEX #3C3910
    #declare Xona_com_Can_Can = rgb <0.835294117647059, 0.568627450980392, 0.643137254901961>; // HEX #D591A4
    #declare Xona_com_Canary = rgb <0.952941176470588, 0.984313725490196, 0.384313725490196>; // HEX #F3FB62
    #declare Xona_com_Candlelight = rgb <0.988235294117647, 0.850980392156863, 0.0901960784313725>; // HEX #FCD917
    #declare Xona_com_Cannon_Black = rgb <0.145098039215686, 0.0901960784313725, 0.0235294117647059>; // HEX #251706
    #declare Xona_com_Cannon_Pink = rgb <0.537254901960784, 0.262745098039216, 0.403921568627451>; // HEX #894367
    #declare Xona_com_Canvas = rgb <0.658823529411765, 0.647058823529412, 0.537254901960784>; // HEX #A8A589
    #declare Xona_com_Cape_Cod = rgb <0.235294117647059, 0.266666666666667, 0.262745098039216>; // HEX #3C4443
    #declare Xona_com_Cape_Honey = rgb <0.996078431372549, 0.898039215686275, 0.674509803921569>; // HEX #FEE5AC
    #declare Xona_com_Cape_Palliser = rgb <0.635294117647059, 0.4, 0.270588235294118>; // HEX #A26645
    #declare Xona_com_Caper = rgb <0.862745098039216, 0.929411764705882, 0.705882352941177>; // HEX #DCEDB4
    #declare Xona_com_Capri = rgb <0.0235294117647059, 0.164705882352941, 0.470588235294118>; // HEX #062A78
    #declare Xona_com_Caramel = rgb <1, 0.866666666666667, 0.686274509803922>; // HEX #FFDDAF
    #declare Xona_com_Cararra = rgb <0.933333333333333, 0.933333333333333, 0.909803921568627>; // HEX #EEEEE8
    #declare Xona_com_Cardin_Green = rgb <0.00392156862745098, 0.211764705882353, 0.109803921568627>; // HEX #01361C
    #declare Xona_com_Cardinal = rgb <0.549019607843137, 0.0196078431372549, 0.368627450980392>; // HEX #8C055E
    #declare Xona_com_Careys_Pink = rgb <0.823529411764706, 0.619607843137255, 0.666666666666667>; // HEX #D29EAA
    #declare Xona_com_Carissma = rgb <0.917647058823529, 0.533333333333333, 0.658823529411765>; // HEX #EA88A8
    #declare Xona_com_Carla = rgb <0.952941176470588, 1, 0.847058823529412>; // HEX #F3FFD8
    #declare Xona_com_Carnaby_Tan = rgb <0.36078431372549, 0.180392156862745, 0.00392156862745098>; // HEX #5C2E01
    #declare Xona_com_Carousel_Pink = rgb <0.976470588235294, 0.87843137254902, 0.929411764705882>; // HEX #F9E0ED
    #declare Xona_com_Carrot = rgb <0.929411764705882, 0.568627450980392, 0.129411764705882>; // HEX #ED9121
    #declare Xona_com_Casablanca = rgb <0.972549019607843, 0.72156862745098, 0.325490196078431>; // HEX #F8B853
    #declare Xona_com_Casal = rgb <0.184313725490196, 0.380392156862745, 0.407843137254902>; // HEX #2F6168
    #declare Xona_com_Cascade = rgb <0.545098039215686, 0.662745098039216, 0.647058823529412>; // HEX #8BA9A5
    #declare Xona_com_Cashmere = rgb <0.901960784313726, 0.745098039215686, 0.647058823529412>; // HEX #E6BEA5
    #declare Xona_com_Casper = rgb <0.67843137254902, 0.745098039215686, 0.819607843137255>; // HEX #ADBED1
    #declare Xona_com_Castro = rgb <0.32156862745098, 0, 0.12156862745098>; // HEX #52001F
    #declare Xona_com_Catalina_Blue = rgb <0.0235294117647059, 0.164705882352941, 0.470588235294118>; // HEX #062A78
    #declare Xona_com_Catskill_White = rgb <0.933333333333333, 0.964705882352941, 0.968627450980392>; // HEX #EEF6F7
    #declare Xona_com_Cavern_Pink = rgb <0.890196078431372, 0.745098039215686, 0.745098039215686>; // HEX #E3BEBE
    #declare Xona_com_Ce_Soir = rgb <0.592156862745098, 0.443137254901961, 0.709803921568627>; // HEX #9771B5
    #declare Xona_com_Cedar = rgb <0.243137254901961, 0.109803921568627, 0.0784313725490196>; // HEX #3E1C14
    #declare Xona_com_Cedar_Wood_Finish = rgb <0.443137254901961, 0.101960784313725, 0>; // HEX #711A00
    #declare Xona_com_Celery = rgb <0.72156862745098, 0.76078431372549, 0.364705882352941>; // HEX #B8C25D
    #declare Xona_com_Celeste = rgb <0.819607843137255, 0.823529411764706, 0.792156862745098>; // HEX #D1D2CA
    #declare Xona_com_Cello = rgb <0.117647058823529, 0.219607843137255, 0.356862745098039>; // HEX #1E385B
    #declare Xona_com_Celtic = rgb <0.0862745098039216, 0.196078431372549, 0.133333333333333>; // HEX #163222
    #declare Xona_com_Cement = rgb <0.552941176470588, 0.462745098039216, 0.384313725490196>; // HEX #8D7662
    #declare Xona_com_Ceramic = rgb <0.988235294117647, 1, 0.976470588235294>; // HEX #FCFFF9
    #declare Xona_com_Cerulean = rgb <0.0196078431372549, 0.72156862745098, 0.8>; // HEX #05B8CC
    #declare Xona_com_Chablis = rgb <1, 0.956862745098039, 0.952941176470588>; // HEX #FFF4F3
    #declare Xona_com_Chalet_Green = rgb <0.317647058823529, 0.431372549019608, 0.23921568627451>; // HEX #516E3D
    #declare Xona_com_Chalky = rgb <0.933333333333333, 0.843137254901961, 0.580392156862745>; // HEX #EED794
    #declare Xona_com_Chambray = rgb <0.207843137254902, 0.305882352941176, 0.549019607843137>; // HEX #354E8C
    #declare Xona_com_Chamois = rgb <0.929411764705882, 0.862745098039216, 0.694117647058824>; // HEX #EDDCB1
    #declare Xona_com_Champagne = rgb <0.980392156862745, 0.925490196078431, 0.8>; // HEX #FAECCC
    #declare Xona_com_Chantilly = rgb <0.972549019607843, 0.764705882352941, 0.874509803921569>; // HEX #F8C3DF
    #declare Xona_com_Charade = rgb <0.16078431372549, 0.16078431372549, 0.215686274509804>; // HEX #292937
    #declare Xona_com_Chardon = rgb <1, 0.952941176470588, 0.945098039215686>; // HEX #FFF3F1
    #declare Xona_com_Chardonnay = rgb <1, 0.803921568627451, 0.549019607843137>; // HEX #FFCD8C
    #declare Xona_com_Charlotte = rgb <0.729411764705882, 0.933333333333333, 0.976470588235294>; // HEX #BAEEF9
    #declare Xona_com_Charm = rgb <0.831372549019608, 0.454901960784314, 0.580392156862745>; // HEX #D47494
    #declare Xona_com_Chartreuse_2 = rgb <0.462745098039216, 0.933333333333333, 0>; // HEX #76EE00
    #declare Xona_com_Chartreuse_3 = rgb <0.4, 0.803921568627451, 0>; // HEX #66CD00
    #declare Xona_com_Chartreuse_4 = rgb <0.270588235294118, 0.545098039215686, 0>; // HEX #458B00
    #declare Xona_com_Chateau_Green = rgb <0.250980392156863, 0.658823529411765, 0.376470588235294>; // HEX #40A860
    #declare Xona_com_Chatelle = rgb <0.741176470588235, 0.701960784313725, 0.780392156862745>; // HEX #BDB3C7
    #declare Xona_com_Chathams_Blue = rgb <0.0901960784313725, 0.333333333333333, 0.474509803921569>; // HEX #175579
    #declare Xona_com_Chelsea_Cucumber = rgb <0.513725490196078, 0.666666666666667, 0.364705882352941>; // HEX #83AA5D
    #declare Xona_com_Chelsea_Gem = rgb <0.619607843137255, 0.325490196078431, 0.00784313725490196>; // HEX #9E5302
    #declare Xona_com_Chenin = rgb <0.874509803921569, 0.803921568627451, 0.435294117647059>; // HEX #DFCD6F
    #declare Xona_com_Cherokee = rgb <0.988235294117647, 0.854901960784314, 0.596078431372549>; // HEX #FCDA98
    #declare Xona_com_Cherry_Pie = rgb <0.164705882352941, 0.0117647058823529, 0.349019607843137>; // HEX #2A0359
    #declare Xona_com_Cherrywood = rgb <0.396078431372549, 0.101960784313725, 0.0784313725490196>; // HEX #651A14
    #declare Xona_com_Cherub = rgb <0.972549019607843, 0.850980392156863, 0.913725490196078>; // HEX #F8D9E9
    #declare Xona_com_Chetwode_Blue = rgb <0.52156862745098, 0.505882352941176, 0.850980392156863>; // HEX #8581D9
    #declare Xona_com_Chicago = rgb <0.364705882352941, 0.36078431372549, 0.345098039215686>; // HEX #5D5C58
    #declare Xona_com_Chiffon = rgb <0.945098039215686, 1, 0.784313725490196>; // HEX #F1FFC8
    #declare Xona_com_Chilean_Fire = rgb <0.968627450980392, 0.466666666666667, 0.0117647058823529>; // HEX #F77703
    #declare Xona_com_Chilean_Heath = rgb <1, 0.992156862745098, 0.901960784313726>; // HEX #FFFDE6
    #declare Xona_com_China_Ivory = rgb <0.988235294117647, 1, 0.905882352941176>; // HEX #FCFFE7
    #declare Xona_com_Chino = rgb <0.807843137254902, 0.780392156862745, 0.654901960784314>; // HEX #CEC7A7
    #declare Xona_com_Chinook = rgb <0.658823529411765, 0.890196078431372, 0.741176470588235>; // HEX #A8E3BD
    #declare Xona_com_Chocolate = rgb <0.823529411764706, 0.411764705882353, 0.117647058823529>; // HEX #D2691E
    #declare Xona_com_Chocolate_1 = rgb <1, 0.498039215686275, 0.141176470588235>; // HEX #FF7F24
    #declare Xona_com_Chocolate_2 = rgb <0.933333333333333, 0.462745098039216, 0.129411764705882>; // HEX #EE7621
    #declare Xona_com_Chocolate_3 = rgb <0.803921568627451, 0.4, 0.113725490196078>; // HEX #CD661D
    #declare Xona_com_Chocolate_4 = rgb <0.545098039215686, 0.270588235294118, 0.0745098039215686>; // HEX #8B4513
    #declare Xona_com_Chocolate_Dark = rgb <0.215686274509804, 0.00784313725490196, 0.00784313725490196>; // HEX #370202
    #declare Xona_com_Christalle = rgb <0.2, 0.0117647058823529, 0.419607843137255>; // HEX #33036B
    #declare Xona_com_Christi = rgb <0.403921568627451, 0.654901960784314, 0.0705882352941176>; // HEX #67A712
    #declare Xona_com_Christine = rgb <0.905882352941176, 0.450980392156863, 0.0392156862745098>; // HEX #E7730A
    #declare Xona_com_Chrome_Oxide_Green = rgb <0.4, 0.501960784313725, 0.0784313725490196>; // HEX #668014
    #declare Xona_com_Chrome_White = rgb <0.909803921568627, 0.945098039215686, 0.831372549019608>; // HEX #E8F1D4
    #declare Xona_com_Cigar = rgb <0.466666666666667, 0.247058823529412, 0.101960784313725>; // HEX #773F1A
    #declare Xona_com_Cinder = rgb <0.0549019607843137, 0.0549019607843137, 0.0941176470588235>; // HEX #0E0E18
    #declare Xona_com_Cinderella = rgb <0.992156862745098, 0.882352941176471, 0.862745098039216>; // HEX #FDE1DC
    #declare Xona_com_Cinnabar_Green = rgb <0.380392156862745, 0.701960784313725, 0.16078431372549>; // HEX #61B329
    #declare Xona_com_Cinnamon = rgb <0.482352941176471, 0.247058823529412, 0>; // HEX #7B3F00
    #declare Xona_com_Cioccolato = rgb <0.333333333333333, 0.156862745098039, 0.0470588235294118>; // HEX #55280C
    #declare Xona_com_Citrine_White = rgb <0, 0.968627450980392, 0.83921568627451>; // HEX #00F7D6
    #declare Xona_com_Citron = rgb <0.619607843137255, 0.662745098039216, 0.12156862745098>; // HEX #9EA91F
    #declare Xona_com_Citrus = rgb <0.631372549019608, 0.772549019607843, 0.0392156862745098>; // HEX #A1C50A
    #declare Xona_com_Clairvoyant = rgb <0.282352941176471, 0.0235294117647059, 0.337254901960784>; // HEX #480656
    #declare Xona_com_Clam_Shell = rgb <0.831372549019608, 0.713725490196078, 0.686274509803922>; // HEX #D4B6AF
    #declare Xona_com_Claret = rgb <0.498039215686275, 0.0901960784313725, 0.203921568627451>; // HEX #7F1734
    #declare Xona_com_Classic_Rose = rgb <0.984313725490196, 0.8, 0.905882352941176>; // HEX #FBCCE7
    #declare Xona_com_Clay_Creek = rgb <0.541176470588235, 0.513725490196078, 0.376470588235294>; // HEX #8A8360
    #declare Xona_com_Clear_Day = rgb <0.913725490196078, 1, 0.992156862745098>; // HEX #E9FFFD
    #declare Xona_com_Clementine = rgb <0.913725490196078, 0.431372549019608, 0>; // HEX #E96E00
    #declare Xona_com_Clinker = rgb <0.215686274509804, 0.113725490196078, 0.0352941176470588>; // HEX #371D09
    #declare Xona_com_Cloud = rgb <0.780392156862745, 0.768627450980392, 0.749019607843137>; // HEX #C7C4BF
    #declare Xona_com_Cloud_Burst = rgb <0.125490196078431, 0.180392156862745, 0.329411764705882>; // HEX #202E54
    #declare Xona_com_Cloudy = rgb <0.674509803921569, 0.647058823529412, 0.623529411764706>; // HEX #ACA59F
    #declare Xona_com_Clover = rgb <0.219607843137255, 0.286274509803922, 0.0627450980392157>; // HEX #384910
    #declare Xona_com_Cobalt = rgb <0.23921568627451, 0.349019607843137, 0.670588235294118>; // HEX #3D59AB
    #declare Xona_com_Cobalt_Dark = rgb <0.0235294117647059, 0.164705882352941, 0.470588235294118>; // HEX #062A78
    #declare Xona_com_Cobalt_Green = rgb <0.23921568627451, 0.568627450980392, 0.250980392156863>; // HEX #3D9140
    #declare Xona_com_Cobalt_Violet_Deep = rgb <0.568627450980392, 0.129411764705882, 0.619607843137255>; // HEX #91219E
    #declare Xona_com_Cocoa_Bean = rgb <0.282352941176471, 0.109803921568627, 0.109803921568627>; // HEX #481C1C
    #declare Xona_com_Cocoa_Brown = rgb <0.188235294117647, 0.12156862745098, 0.117647058823529>; // HEX #301F1E
    #declare Xona_com_Coconut_Cream = rgb <0.972549019607843, 0.968627450980392, 0.862745098039216>; // HEX #F8F7DC
    #declare Xona_com_Cod_Gray = rgb <0.0431372549019608, 0.0431372549019608, 0.0431372549019608>; // HEX #0B0B0B
    #declare Xona_com_Coffee = rgb <0.43921568627451, 0.396078431372549, 0.333333333333333>; // HEX #706555
    #declare Xona_com_Coffee_Bean = rgb <0.164705882352941, 0.0784313725490196, 0.0549019607843137>; // HEX #2A140E
    #declare Xona_com_Cognac = rgb <0.623529411764706, 0.219607843137255, 0.113725490196078>; // HEX #9F381D
    #declare Xona_com_Cola = rgb <0.247058823529412, 0.145098039215686, 0>; // HEX #3F2500
    #declare Xona_com_Cold_Gray = rgb <0.501960784313725, 0.541176470588235, 0.529411764705882>; // HEX #808A87
    #declare Xona_com_Cold_Purple = rgb <0.670588235294118, 0.627450980392157, 0.850980392156863>; // HEX #ABA0D9
    #declare Xona_com_Cold_Turkey = rgb <0.807843137254902, 0.729411764705882, 0.729411764705882>; // HEX #CEBABA
    #declare Xona_com_Colonial_White = rgb <1, 0.929411764705882, 0.737254901960784>; // HEX #FFEDBC
    #declare Xona_com_Comet = rgb <0.36078431372549, 0.364705882352941, 0.458823529411765>; // HEX #5C5D75
    #declare Xona_com_Como = rgb <0.317647058823529, 0.486274509803922, 0.4>; // HEX #517C66
    #declare Xona_com_Conch = rgb <0.788235294117647, 0.850980392156863, 0.823529411764706>; // HEX #C9D9D2
    #declare Xona_com_Concord = rgb <0.486274509803922, 0.482352941176471, 0.47843137254902>; // HEX #7C7B7A
    #declare Xona_com_Confetti = rgb <0.913725490196078, 0.843137254901961, 0.352941176470588>; // HEX #E9D75A
    #declare Xona_com_Congo_Brown = rgb <0.349019607843137, 0.215686274509804, 0.215686274509804>; // HEX #593737
    #declare Xona_com_Conifer = rgb <0.674509803921569, 0.866666666666667, 0.301960784313725>; // HEX #ACDD4D
    #declare Xona_com_Contessa = rgb <0.776470588235294, 0.447058823529412, 0.419607843137255>; // HEX #C6726B
    #declare Xona_com_Copper_Canyon = rgb <0.494117647058824, 0.227450980392157, 0.0823529411764706>; // HEX #7E3A15
    #declare Xona_com_Copper_Rust = rgb <0.580392156862745, 0.27843137254902, 0.27843137254902>; // HEX #944747
    #declare Xona_com_Coral = rgb <1, 0.498039215686275, 0.313725490196078>; // HEX #FF7F50
    #declare Xona_com_Coral_1 = rgb <1, 0.447058823529412, 0.337254901960784>; // HEX #FF7256
    #declare Xona_com_Coral_2 = rgb <0.933333333333333, 0.415686274509804, 0.313725490196078>; // HEX #EE6A50
    #declare Xona_com_Coral_3 = rgb <0.803921568627451, 0.356862745098039, 0.270588235294118>; // HEX #CD5B45
    #declare Xona_com_Coral_4 = rgb <0.545098039215686, 0.243137254901961, 0.184313725490196>; // HEX #8B3E2F
    #declare Xona_com_Coral_Bright = rgb <0.780392156862745, 0.737254901960784, 0.635294117647059>; // HEX #C7BCA2
    #declare Xona_com_Coral_Candy = rgb <1, 0.862745098039216, 0.83921568627451>; // HEX #FFDCD6
    #declare Xona_com_Coral_Light = rgb <0.941176470588235, 0.501960784313725, 0.501960784313725>; // HEX #F08080
    #declare Xona_com_Coral_Tree = rgb <0.658823529411765, 0.419607843137255, 0.419607843137255>; // HEX #A86B6B
    #declare Xona_com_Corduroy = rgb <0.376470588235294, 0.431372549019608, 0.407843137254902>; // HEX #606E68
    #declare Xona_com_Coriander = rgb <0.768627450980392, 0.815686274509804, 0.690196078431373>; // HEX #C4D0B0
    #declare Xona_com_Cork = rgb <0.250980392156863, 0.16078431372549, 0.113725490196078>; // HEX #40291D
    #declare Xona_com_Corn = rgb <0.905882352941176, 0.749019607843137, 0.0196078431372549>; // HEX #E7BF05
    #declare Xona_com_Corn_Field = rgb <0.972549019607843, 0.980392156862745, 0.803921568627451>; // HEX #F8FACD
    #declare Xona_com_Corn_Harvest = rgb <0.545098039215686, 0.419607843137255, 0.0431372549019608>; // HEX #8B6B0B
    #declare Xona_com_Cornflower = rgb <0.392156862745098, 0.584313725490196, 0.929411764705882>; // HEX #6495ED
    #declare Xona_com_Cornflower_Blue = rgb <0.392156862745098, 0.584313725490196, 0.929411764705882>; // HEX #6495ED
    #declare Xona_com_Cornflower_Bright = rgb <1, 0.690196078431373, 0.674509803921569>; // HEX #FFB0AC
    #declare Xona_com_Cornsilk = rgb <1, 0.972549019607843, 0.862745098039216>; // HEX #FFF8DC
    #declare Xona_com_Cornsilk_1 = rgb <1, 0.972549019607843, 0.862745098039216>; // HEX #FFF8DC
    #declare Xona_com_Cornsilk_2 = rgb <0.933333333333333, 0.909803921568627, 0.803921568627451>; // HEX #EEE8CD
    #declare Xona_com_Cornsilk_3 = rgb <0.803921568627451, 0.784313725490196, 0.694117647058824>; // HEX #CDC8B1
    #declare Xona_com_Cornsilk_4 = rgb <0.545098039215686, 0.533333333333333, 0.470588235294118>; // HEX #8B8878
    #declare Xona_com_Corvette = rgb <0.980392156862745, 0.827450980392157, 0.635294117647059>; // HEX #FAD3A2
    #declare Xona_com_Cosmic = rgb <0.462745098039216, 0.223529411764706, 0.364705882352941>; // HEX #76395D
    #declare Xona_com_Cosmos = rgb <1, 0.847058823529412, 0.850980392156863>; // HEX #FFD8D9
    #declare Xona_com_Costa_Del_Sol = rgb <0.380392156862745, 0.364705882352941, 0.188235294117647>; // HEX #615D30
    #declare Xona_com_Cotton_Seed = rgb <0.76078431372549, 0.741176470588235, 0.713725490196078>; // HEX #C2BDB6
    #declare Xona_com_County_Green = rgb <0.00392156862745098, 0.215686274509804, 0.101960784313725>; // HEX #01371A
    #declare Xona_com_Cove_Gray = rgb <0.0196078431372549, 0.0862745098039216, 0.341176470588235>; // HEX #051657
    #declare Xona_com_Cowboy = rgb <0.301960784313725, 0.156862745098039, 0.176470588235294>; // HEX #4D282D
    #declare Xona_com_Crab_Apple = rgb <0.627450980392157, 0.152941176470588, 0.0705882352941176>; // HEX #A02712
    #declare Xona_com_Crail = rgb <0.725490196078431, 0.317647058823529, 0.250980392156863>; // HEX #B95140
    #declare Xona_com_Cranberry = rgb <0.713725490196078, 0.192156862745098, 0.423529411764706>; // HEX #B6316C
    #declare Xona_com_Crater_Brown = rgb <0.274509803921569, 0.141176470588235, 0.145098039215686>; // HEX #462425
    #declare Xona_com_Cream_Brulee = rgb <1, 0.898039215686275, 0.627450980392157>; // HEX #FFE5A0
    #declare Xona_com_Cream_Can = rgb <0.96078431372549, 0.784313725490196, 0.36078431372549>; // HEX #F5C85C
    #declare Xona_com_Creme_De_Banane = rgb <1, 0.988235294117647, 0.6>; // HEX #FFFC99
    #declare Xona_com_Creole = rgb <0.117647058823529, 0.0588235294117647, 0.0156862745098039>; // HEX #1E0F04
    #declare Xona_com_Crete = rgb <0.450980392156863, 0.470588235294118, 0.16078431372549>; // HEX #737829
    #declare Xona_com_Crocodile = rgb <0.450980392156863, 0.427450980392157, 0.345098039215686>; // HEX #736D58
    #declare Xona_com_Crown_Of_Thorns = rgb <0.466666666666667, 0.12156862745098, 0.12156862745098>; // HEX #771F1F
    #declare Xona_com_Crowshead = rgb <0.109803921568627, 0.0705882352941176, 0.0313725490196078>; // HEX #1C1208
    #declare Xona_com_Cruise = rgb <0.709803921568627, 0.925490196078431, 0.874509803921569>; // HEX #B5ECDF
    #declare Xona_com_Crusoe = rgb <0, 0.282352941176471, 0.0862745098039216>; // HEX #004816
    #declare Xona_com_Crusta = rgb <0.992156862745098, 0.482352941176471, 0.2>; // HEX #FD7B33
    #declare Xona_com_Cuban_Tan = rgb <0.164705882352941, 0.0784313725490196, 0.0549019607843137>; // HEX #2A140E
    #declare Xona_com_Cumin = rgb <0.572549019607843, 0.262745098039216, 0.129411764705882>; // HEX #924321
    #declare Xona_com_Cumulus = rgb <0.992156862745098, 1, 0.835294117647059>; // HEX #FDFFD5
    #declare Xona_com_Cupid = rgb <0.984313725490196, 0.745098039215686, 0.854901960784314>; // HEX #FBBEDA
    #declare Xona_com_Curious_Blue = rgb <0.145098039215686, 0.588235294117647, 0.819607843137255>; // HEX #2596D1
    #declare Xona_com_Cutty_Sark = rgb <0.313725490196078, 0.462745098039216, 0.447058823529412>; // HEX #507672
    #declare Xona_com_Cyan_2 = rgb <0, 0.933333333333333, 0.933333333333333>; // HEX #00EEEE
    #declare Xona_com_Cyan_3 = rgb <0, 0.803921568627451, 0.803921568627451>; // HEX #00CDCD
    #declare Xona_com_Cyan_4 = rgb <0, 0.545098039215686, 0.545098039215686>; // HEX #008B8B
    #declare Xona_com_Cyan_White = rgb <0.87843137254902, 1, 1>; // HEX #E0FFFF
    #declare Xona_com_Cyprus = rgb <0, 0.243137254901961, 0.250980392156863>; // HEX #003E40
    #declare Xona_com_Daintree = rgb <0.00392156862745098, 0.152941176470588, 0.192156862745098>; // HEX #012731
    #declare Xona_com_Dairy_Cream = rgb <0.976470588235294, 0.894117647058824, 0.737254901960784>; // HEX #F9E4BC
    #declare Xona_com_Daisy_Bush = rgb <0.309803921568627, 0.137254901960784, 0.596078431372549>; // HEX #4F2398
    #declare Xona_com_Dallas = rgb <0.431372549019608, 0.294117647058824, 0.149019607843137>; // HEX #6E4B26
    #declare Xona_com_Danube = rgb <0.376470588235294, 0.576470588235294, 0.819607843137255>; // HEX #6093D1
    #declare Xona_com_Dark_Blue = rgb <0, 0, 0.545098039215686>; // HEX #00008B
    #declare Xona_com_Dark_Cyan = rgb <0, 0.545098039215686, 0.545098039215686>; // HEX #008B8B
    #declare Xona_com_Dark_Ebony = rgb <0.235294117647059, 0.125490196078431, 0.0196078431372549>; // HEX #3C2005
    #declare Xona_com_Dark_Goldenrod = rgb <0.72156862745098, 0.525490196078431, 0.0431372549019608>; // HEX #B8860B
    #declare Xona_com_Dark_Goldenrod_1 = rgb <1, 0.725490196078431, 0.0588235294117647>; // HEX #FFB90F
    #declare Xona_com_Dark_Goldenrod_2 = rgb <0.933333333333333, 0.67843137254902, 0.0549019607843137>; // HEX #EEAD0E
    #declare Xona_com_Dark_Goldenrod_3 = rgb <0.803921568627451, 0.584313725490196, 0.0470588235294118>; // HEX #CD950C
    #declare Xona_com_Dark_Goldenrod_4 = rgb <0.545098039215686, 0.396078431372549, 0.0313725490196078>; // HEX #8B6508
    #declare Xona_com_Dark_Gray = rgb <0.662745098039216, 0.662745098039216, 0.662745098039216>; // HEX #A9A9A9
    #declare Xona_com_Dark_Green = rgb <0, 0.392156862745098, 0>; // HEX #006400
    #declare Xona_com_Dark_Khaki = rgb <0.741176470588235, 0.717647058823529, 0.419607843137255>; // HEX #BDB76B
    #declare Xona_com_Dark_Magenta = rgb <0.545098039215686, 0, 0.545098039215686>; // HEX #8B008B
    #declare Xona_com_Dark_Oak = rgb <0.380392156862745, 0.152941176470588, 0.0941176470588235>; // HEX #612718
    #declare Xona_com_Dark_Olive_Green = rgb <0.333333333333333, 0.419607843137255, 0.184313725490196>; // HEX #556B2F
    #declare Xona_com_Dark_Olive_Green_1 = rgb <0.792156862745098, 1, 0.43921568627451>; // HEX #CAFF70
    #declare Xona_com_Dark_Olive_Green_2 = rgb <0.737254901960784, 0.933333333333333, 0.407843137254902>; // HEX #BCEE68
    #declare Xona_com_Dark_Olive_Green_3 = rgb <0.635294117647059, 0.803921568627451, 0.352941176470588>; // HEX #A2CD5A
    #declare Xona_com_Dark_Olive_Green_4 = rgb <0.431372549019608, 0.545098039215686, 0.23921568627451>; // HEX #6E8B3D
    #declare Xona_com_Dark_Orange = rgb <1, 0.549019607843137, 0>; // HEX #FF8C00
    #declare Xona_com_Dark_Orange_2 = rgb <0.933333333333333, 0.462745098039216, 0>; // HEX #EE7600
    #declare Xona_com_Dark_Orange_3 = rgb <0.803921568627451, 0.4, 0>; // HEX #CD6600
    #declare Xona_com_Dark_Orange_4 = rgb <0.545098039215686, 0.270588235294118, 0>; // HEX #8B4500
    #declare Xona_com_Dark_Orchid_1 = rgb <0.749019607843137, 0.243137254901961, 1>; // HEX #BF3EFF
    #declare Xona_com_Dark_Orchid_2 = rgb <0.698039215686274, 0.227450980392157, 0.933333333333333>; // HEX #B23AEE
    #declare Xona_com_Dark_Orchid_3 = rgb <0.603921568627451, 0.196078431372549, 0.803921568627451>; // HEX #9A32CD
    #declare Xona_com_Dark_Orchid_4 = rgb <0.407843137254902, 0.133333333333333, 0.545098039215686>; // HEX #68228B
    #declare Xona_com_Dark_Red = rgb <0.545098039215686, 0, 0>; // HEX #8B0000
    #declare Xona_com_Dark_Rimu = rgb <0.372549019607843, 0.23921568627451, 0.149019607843137>; // HEX #5F3D26
    #declare Xona_com_Dark_Rum = rgb <0.254901960784314, 0.125490196078431, 0.0627450980392157>; // HEX #412010
    #declare Xona_com_Dark_Salmon = rgb <0.913725490196078, 0.588235294117647, 0.47843137254902>; // HEX #E9967A
    #declare Xona_com_Dark_Sea_Green_1 = rgb <0.756862745098039, 1, 0.756862745098039>; // HEX #C1FFC1
    #declare Xona_com_Dark_Sea_Green_2 = rgb <0.705882352941177, 0.933333333333333, 0.705882352941177>; // HEX #B4EEB4
    #declare Xona_com_Dark_Sea_Green_3 = rgb <0.607843137254902, 0.803921568627451, 0.607843137254902>; // HEX #9BCD9B
    #declare Xona_com_Dark_Sea_Green_4 = rgb <0.411764705882353, 0.545098039215686, 0.411764705882353>; // HEX #698B69
    #declare Xona_com_Dark_Slate = rgb <0.223529411764706, 0.282352941176471, 0.317647058823529>; // HEX #394851
    #declare Xona_com_Dark_Slate_Blue = rgb <0.282352941176471, 0.23921568627451, 0.545098039215686>; // HEX #483D8B
    #declare Xona_com_Dark_Slate_Gray_1 = rgb <0.592156862745098, 1, 1>; // HEX #97FFFF
    #declare Xona_com_Dark_Slate_Gray_2 = rgb <0.552941176470588, 0.933333333333333, 0.933333333333333>; // HEX #8DEEEE
    #declare Xona_com_Dark_Slate_Gray_3 = rgb <0.474509803921569, 0.803921568627451, 0.803921568627451>; // HEX #79CDCD
    #declare Xona_com_Dark_Slate_Gray_4 = rgb <0.32156862745098, 0.545098039215686, 0.545098039215686>; // HEX #528B8B
    #declare Xona_com_Dark_Tan = rgb <0.4, 0.0627450980392157, 0.0627450980392157>; // HEX #661010
    #declare Xona_com_Dark_Turquoise = rgb <0, 0.807843137254902, 0.819607843137255>; // HEX #00CED1
    #declare Xona_com_Dark_Violet = rgb <0.580392156862745, 0, 0.827450980392157>; // HEX #9400D3
    #declare Xona_com_Dawn = rgb <0.650980392156863, 0.635294117647059, 0.603921568627451>; // HEX #A6A29A
    #declare Xona_com_Dawn_Pink = rgb <0.952941176470588, 0.913725490196078, 0.898039215686275>; // HEX #F3E9E5
    #declare Xona_com_De_York = rgb <0.47843137254902, 0.768627450980392, 0.533333333333333>; // HEX #7AC488
    #declare Xona_com_Deco = rgb <0.823529411764706, 0.854901960784314, 0.592156862745098>; // HEX #D2DA97
    #declare Xona_com_Deep_Blush = rgb <0.894117647058824, 0.462745098039216, 0.596078431372549>; // HEX #E47698
    #declare Xona_com_Deep_Bronze = rgb <0.290196078431373, 0.188235294117647, 0.0156862745098039>; // HEX #4A3004
    #declare Xona_com_Deep_Cove = rgb <0.0196078431372549, 0.0627450980392157, 0.250980392156863>; // HEX #051040
    #declare Xona_com_Deep_Fir = rgb <0, 0.16078431372549, 0>; // HEX #002900
    #declare Xona_com_Deep_Koamaru = rgb <0.105882352941176, 0.0705882352941176, 0.482352941176471>; // HEX #1B127B
    #declare Xona_com_Deep_Oak = rgb <0.254901960784314, 0.125490196078431, 0.0627450980392157>; // HEX #412010
    #declare Xona_com_Deep_Ochre = rgb <0.450980392156863, 0.23921568627451, 0.101960784313725>; // HEX #733D1A
    #declare Xona_com_Deep_Pink = rgb <1, 0.0784313725490196, 0.576470588235294>; // HEX #FF1493
    #declare Xona_com_Deep_Pink_2 = rgb <0.933333333333333, 0.0705882352941176, 0.537254901960784>; // HEX #EE1289
    #declare Xona_com_Deep_Pink_3 = rgb <0.803921568627451, 0.0627450980392157, 0.462745098039216>; // HEX #CD1076
    #declare Xona_com_Deep_Pink_4 = rgb <0.545098039215686, 0.0392156862745098, 0.313725490196078>; // HEX #8B0A50
    #declare Xona_com_Deep_Sea = rgb <0.00392156862745098, 0.509803921568627, 0.419607843137255>; // HEX #01826B
    #declare Xona_com_Deep_Sky_Blue = rgb <0, 0.749019607843137, 1>; // HEX #00BFFF
    #declare Xona_com_Deep_Sky_Blue_1 = rgb <0, 0.749019607843137, 1>; // HEX #00BFFF
    #declare Xona_com_Deep_Sky_Blue_2 = rgb <0, 0.698039215686274, 0.933333333333333>; // HEX #00B2EE
    #declare Xona_com_Deep_Sky_Blue_3 = rgb <0, 0.603921568627451, 0.803921568627451>; // HEX #009ACD
    #declare Xona_com_Deep_Sky_Blue_4 = rgb <0, 0.407843137254902, 0.545098039215686>; // HEX #00688B
    #declare Xona_com_Deep_Teal = rgb <0, 0.207843137254902, 0.196078431372549>; // HEX #003532
    #declare Xona_com_Del_Rio = rgb <0.690196078431373, 0.603921568627451, 0.584313725490196>; // HEX #B09A95
    #declare Xona_com_Dell = rgb <0.223529411764706, 0.392156862745098, 0.0745098039215686>; // HEX #396413
    #declare Xona_com_Delta = rgb <0.643137254901961, 0.643137254901961, 0.615686274509804>; // HEX #A4A49D
    #declare Xona_com_Deluge = rgb <0.458823529411765, 0.388235294117647, 0.658823529411765>; // HEX #7563A8
    #declare Xona_com_Derby = rgb <1, 0.933333333333333, 0.847058823529412>; // HEX #FFEED8
    #declare Xona_com_Desert = rgb <0.682352941176471, 0.376470588235294, 0.125490196078431>; // HEX #AE6020
    #declare Xona_com_Desert_Storm = rgb <0.972549019607843, 0.972549019607843, 0.968627450980392>; // HEX #F8F8F7
    #declare Xona_com_Dew = rgb <0.917647058823529, 1, 0.996078431372549>; // HEX #EAFFFE
    #declare Xona_com_Di_Serria = rgb <0.858823529411765, 0.6, 0.368627450980392>; // HEX #DB995E
    #declare Xona_com_Diesel = rgb <0.0745098039215686, 0, 0>; // HEX #130000
    #declare Xona_com_Dim_Gray = rgb <0.411764705882353, 0.411764705882353, 0.411764705882353>; // HEX #696969
    #declare Xona_com_Dingley = rgb <0.364705882352941, 0.466666666666667, 0.27843137254902>; // HEX #5D7747
    #declare Xona_com_Disco = rgb <0.529411764705882, 0.0823529411764706, 0.313725490196078>; // HEX #871550
    #declare Xona_com_Dixie = rgb <0.886274509803922, 0.580392156862745, 0.0941176470588235>; // HEX #E29418
    #declare Xona_com_Dodger_Blue = rgb <0.117647058823529, 0.564705882352941, 1>; // HEX #1E90FF
    #declare Xona_com_Dodger_Blue_1 = rgb <0.117647058823529, 0.564705882352941, 1>; // HEX #1E90FF
    #declare Xona_com_Dodger_Blue_2 = rgb <0.109803921568627, 0.525490196078431, 0.933333333333333>; // HEX #1C86EE
    #declare Xona_com_Dodger_Blue_3 = rgb <0.0941176470588235, 0.454901960784314, 0.803921568627451>; // HEX #1874CD
    #declare Xona_com_Dodger_Blue_4 = rgb <0.0627450980392157, 0.305882352941176, 0.545098039215686>; // HEX #104E8B
    #declare Xona_com_Dolly = rgb <0.976470588235294, 1, 0.545098039215686>; // HEX #F9FF8B
    #declare Xona_com_Dolphin = rgb <0.392156862745098, 0.376470588235294, 0.466666666666667>; // HEX #646077
    #declare Xona_com_Domino = rgb <0.556862745098039, 0.466666666666667, 0.368627450980392>; // HEX #8E775E
    #declare Xona_com_Don_Juan = rgb <0.364705882352941, 0.298039215686275, 0.317647058823529>; // HEX #5D4C51
    #declare Xona_com_Donkey_Brown = rgb <0.650980392156863, 0.572549019607843, 0.474509803921569>; // HEX #A69279
    #declare Xona_com_Dorado = rgb <0.419607843137255, 0.341176470588235, 0.333333333333333>; // HEX #6B5755
    #declare Xona_com_Double_Colonial_White = rgb <0.933333333333333, 0.890196078431372, 0.67843137254902>; // HEX #EEE3AD
    #declare Xona_com_Double_Pearl_Lusta = rgb <0.988235294117647, 0.956862745098039, 0.815686274509804>; // HEX #FCF4D0
    #declare Xona_com_Double_Spanish_White = rgb <0.901960784313726, 0.843137254901961, 0.725490196078431>; // HEX #E6D7B9
    #declare Xona_com_Dove_Gray = rgb <0.427450980392157, 0.423529411764706, 0.423529411764706>; // HEX #6D6C6C
    #declare Xona_com_Downriver = rgb <0.0352941176470588, 0.133333333333333, 0.337254901960784>; // HEX #092256
    #declare Xona_com_Downy = rgb <0.435294117647059, 0.815686274509804, 0.772549019607843>; // HEX #6FD0C5
    #declare Xona_com_Driftwood = rgb <0.686274509803922, 0.529411764705882, 0.317647058823529>; // HEX #AF8751
    #declare Xona_com_Drover = rgb <0.992156862745098, 0.968627450980392, 0.67843137254902>; // HEX #FDF7AD
    #declare Xona_com_Dune = rgb <0.219607843137255, 0.207843137254902, 0.2>; // HEX #383533
    #declare Xona_com_Dust_Storm = rgb <0.898039215686275, 0.8, 0.788235294117647>; // HEX #E5CCC9
    #declare Xona_com_Dusty_Gray = rgb <0.658823529411765, 0.596078431372549, 0.607843137254902>; // HEX #A8989B
    #declare Xona_com_Dutch_White = rgb <1, 0.972549019607843, 0.819607843137255>; // HEX #FFF8D1
    #declare Xona_com_Eagle = rgb <0.713725490196078, 0.729411764705882, 0.643137254901961>; // HEX #B6BAA4
    #declare Xona_com_Earls_Green = rgb <0.788235294117647, 0.725490196078431, 0.231372549019608>; // HEX #C9B93B
    #declare Xona_com_Early_Dawn = rgb <1, 0.976470588235294, 0.901960784313726>; // HEX #FFF9E6
    #declare Xona_com_East_Bay = rgb <0.254901960784314, 0.298039215686275, 0.490196078431373>; // HEX #414C7D
    #declare Xona_com_East_Side = rgb <0.674509803921569, 0.568627450980392, 0.807843137254902>; // HEX #AC91CE
    #declare Xona_com_Eastern_Blue = rgb <0.117647058823529, 0.603921568627451, 0.690196078431373>; // HEX #1E9AB0
    #declare Xona_com_Ebb = rgb <0.913725490196078, 0.890196078431372, 0.890196078431372>; // HEX #E9E3E3
    #declare Xona_com_Ebony = rgb <0.0470588235294118, 0.0431372549019608, 0.113725490196078>; // HEX #0C0B1D
    #declare Xona_com_Ebony_Clay = rgb <0.149019607843137, 0.156862745098039, 0.231372549019608>; // HEX #26283B
    #declare Xona_com_Echo_Blue = rgb <0.686274509803922, 0.741176470588235, 0.850980392156863>; // HEX #AFBDD9
    #declare Xona_com_Eclipse = rgb <0.192156862745098, 0.109803921568627, 0.0901960784313725>; // HEX #311C17
    #declare Xona_com_Ecru_White = rgb <0.96078431372549, 0.952941176470588, 0.898039215686275>; // HEX #F5F3E5
    #declare Xona_com_Ecstasy = rgb <0.980392156862745, 0.470588235294118, 0.0784313725490196>; // HEX #FA7814
    #declare Xona_com_Eden = rgb <0.0627450980392157, 0.345098039215686, 0.32156862745098>; // HEX #105852
    #declare Xona_com_Edgewater = rgb <0.784313725490196, 0.890196078431372, 0.843137254901961>; // HEX #C8E3D7
    #declare Xona_com_Edward = rgb <0.635294117647059, 0.682352941176471, 0.670588235294118>; // HEX #A2AEAB
    #declare Xona_com_Egg_Sour = rgb <1, 0.956862745098039, 0.866666666666667>; // HEX #FFF4DD
    #declare Xona_com_Egg_White = rgb <1, 0.937254901960784, 0.756862745098039>; // HEX #FFEFC1
    #declare Xona_com_Eggshell = rgb <0.988235294117647, 0.901960784313726, 0.788235294117647>; // HEX #FCE6C9
    #declare Xona_com_El_Paso = rgb <0.117647058823529, 0.0901960784313725, 0.0313725490196078>; // HEX #1E1708
    #declare Xona_com_El_Salva = rgb <0.56078431372549, 0.243137254901961, 0.2>; // HEX #8F3E33
    #declare Xona_com_Elephant = rgb <0.0705882352941176, 0.203921568627451, 0.27843137254902>; // HEX #123447
    #declare Xona_com_Elf_Green = rgb <0.0313725490196078, 0.513725490196078, 0.43921568627451>; // HEX #088370
    #declare Xona_com_Elm = rgb <0.109803921568627, 0.486274509803922, 0.490196078431373>; // HEX #1C7C7D
    #declare Xona_com_Embers = rgb <0.627450980392157, 0.152941176470588, 0.0705882352941176>; // HEX #A02712
    #declare Xona_com_Emerald_Green = rgb <0, 0.788235294117647, 0.341176470588235>; // HEX #00C957
    #declare Xona_com_Eminence = rgb <0.423529411764706, 0.188235294117647, 0.509803921568627>; // HEX #6C3082
    #declare Xona_com_Emperor = rgb <0.317647058823529, 0.274509803921569, 0.286274509803922>; // HEX #514649
    #declare Xona_com_Empress = rgb <0.505882352941176, 0.450980392156863, 0.466666666666667>; // HEX #817377
    #declare Xona_com_Endeavour = rgb <0, 0.337254901960784, 0.654901960784314>; // HEX #0056A7
    #declare Xona_com_Energy_Yellow = rgb <0.972549019607843, 0.866666666666667, 0.36078431372549>; // HEX #F8DD5C
    #declare Xona_com_English_Holly = rgb <0.00784313725490196, 0.176470588235294, 0.0823529411764706>; // HEX #022D15
    #declare Xona_com_English_Red = rgb <0.831372549019608, 0.23921568627451, 0.101960784313725>; // HEX #D43D1A
    #declare Xona_com_English_Walnut = rgb <0.243137254901961, 0.168627450980392, 0.137254901960784>; // HEX #3E2B23
    #declare Xona_com_Envy = rgb <0.545098039215686, 0.650980392156863, 0.564705882352941>; // HEX #8BA690
    #declare Xona_com_Equator = rgb <0.882352941176471, 0.737254901960784, 0.392156862745098>; // HEX #E1BC64
    #declare Xona_com_Espresso = rgb <0.380392156862745, 0.152941176470588, 0.0941176470588235>; // HEX #612718
    #declare Xona_com_Eternity = rgb <0.129411764705882, 0.101960784313725, 0.0549019607843137>; // HEX #211A0E
    #declare Xona_com_Eucalyptus = rgb <0.152941176470588, 0.541176470588235, 0.356862745098039>; // HEX #278A5B
    #declare Xona_com_Eunry = rgb <0.811764705882353, 0.63921568627451, 0.615686274509804>; // HEX #CFA39D
    #declare Xona_com_Evening_Sea = rgb <0.00784313725490196, 0.305882352941176, 0.274509803921569>; // HEX #024E46
    #declare Xona_com_Everglade = rgb <0.109803921568627, 0.250980392156863, 0.180392156862745>; // HEX #1C402E
    #declare Xona_com_Fair_Pink = rgb <1, 0.937254901960784, 0.925490196078431>; // HEX #FFEFEC
    #declare Xona_com_Falcon = rgb <0.498039215686275, 0.384313725490196, 0.427450980392157>; // HEX #7F626D
    #declare Xona_com_Fantasy = rgb <0.980392156862745, 0.952941176470588, 0.941176470588235>; // HEX #FAF3F0
    #declare Xona_com_Fedora = rgb <0.474509803921569, 0.415686274509804, 0.470588235294118>; // HEX #796A78
    #declare Xona_com_Feijoa = rgb <0.623529411764706, 0.866666666666667, 0.549019607843137>; // HEX #9FDD8C
    #declare Xona_com_Fern = rgb <0.0392156862745098, 0.282352941176471, 0.0509803921568627>; // HEX #0A480D
    #declare Xona_com_Fern_Frond = rgb <0.396078431372549, 0.447058823529412, 0.125490196078431>; // HEX #657220
    #declare Xona_com_Ferra = rgb <0.43921568627451, 0.309803921568627, 0.313725490196078>; // HEX #704F50
    #declare Xona_com_Festival = rgb <0.984313725490196, 0.913725490196078, 0.423529411764706>; // HEX #FBE96C
    #declare Xona_com_Feta = rgb <0.941176470588235, 0.988235294117647, 0.917647058823529>; // HEX #F0FCEA
    #declare Xona_com_Fiery_Orange = rgb <0.701960784313725, 0.32156862745098, 0.0745098039215686>; // HEX #B35213
    #declare Xona_com_Fiji_Green = rgb <0.396078431372549, 0.447058823529412, 0.125490196078431>; // HEX #657220
    #declare Xona_com_Finch = rgb <0.384313725490196, 0.4, 0.286274509803922>; // HEX #626649
    #declare Xona_com_Finlandia = rgb <0.333333333333333, 0.427450980392157, 0.337254901960784>; // HEX #556D56
    #declare Xona_com_Finn = rgb <0.411764705882353, 0.176470588235294, 0.329411764705882>; // HEX #692D54
    #declare Xona_com_Fiord = rgb <0.250980392156863, 0.317647058823529, 0.411764705882353>; // HEX #405169
    #declare Xona_com_Fire = rgb <0.666666666666667, 0.258823529411765, 0.0117647058823529>; // HEX #AA4203
    #declare Xona_com_Fire_Bush = rgb <0.909803921568627, 0.6, 0.156862745098039>; // HEX #E89928
    #declare Xona_com_Firebrick = rgb <0.698039215686274, 0.133333333333333, 0.133333333333333>; // HEX #B22222
    #declare Xona_com_Firebrick_1 = rgb <1, 0.188235294117647, 0.188235294117647>; // HEX #FF3030
    #declare Xona_com_Firebrick_2 = rgb <0.933333333333333, 0.172549019607843, 0.172549019607843>; // HEX #EE2C2C
    #declare Xona_com_Firebrick_3 = rgb <0.803921568627451, 0.149019607843137, 0.149019607843137>; // HEX #CD2626
    #declare Xona_com_Firebrick_4 = rgb <0.545098039215686, 0.101960784313725, 0.101960784313725>; // HEX #8B1A1A
    #declare Xona_com_Firefly = rgb <0.0549019607843137, 0.164705882352941, 0.188235294117647>; // HEX #0E2A30
    #declare Xona_com_Flame_Pea = rgb <0.854901960784314, 0.356862745098039, 0.219607843137255>; // HEX #DA5B38
    #declare Xona_com_Flame_Red = rgb <0.780392156862745, 0.0117647058823529, 0.117647058823529>; // HEX #C7031E
    #declare Xona_com_Flamenco = rgb <1, 0.490196078431373, 0.0274509803921569>; // HEX #FF7D07
    #declare Xona_com_Flamingo = rgb <0.949019607843137, 0.333333333333333, 0.164705882352941>; // HEX #F2552A
    #declare Xona_com_Flax = rgb <0.482352941176471, 0.509803921568627, 0.396078431372549>; // HEX #7B8265
    #declare Xona_com_Flesh = rgb <1, 0.490196078431373, 0.250980392156863>; // HEX #FF7D40
    #declare Xona_com_Flesh_Ochre = rgb <1, 0.341176470588235, 0.129411764705882>; // HEX #FF5721
    #declare Xona_com_Flint = rgb <0.435294117647059, 0.415686274509804, 0.380392156862745>; // HEX #6F6A61
    #declare Xona_com_Flirt = rgb <0.635294117647059, 0, 0.427450980392157>; // HEX #A2006D
    #declare Xona_com_Floral_White = rgb <1, 0.980392156862745, 0.941176470588235>; // HEX #FFFAF0
    #declare Xona_com_Foam = rgb <0.847058823529412, 0.988235294117647, 0.980392156862745>; // HEX #D8FCFA
    #declare Xona_com_Fog = rgb <0.843137254901961, 0.815686274509804, 1>; // HEX #D7D0FF
    #declare Xona_com_Foggy_Gray = rgb <0.796078431372549, 0.792156862745098, 0.713725490196078>; // HEX #CBCAB6
    #declare Xona_com_Forest_Green = rgb <0.133333333333333, 0.545098039215686, 0.133333333333333>; // HEX #228B22
    #declare Xona_com_Forest_Green_Dark = rgb <0.0941176470588235, 0.176470588235294, 0.0352941176470588>; // HEX #182D09
    #declare Xona_com_Forget_Me_Not = rgb <1, 0.945098039215686, 0.933333333333333>; // HEX #FFF1EE
    #declare Xona_com_Fountain_Blue = rgb <0.337254901960784, 0.705882352941177, 0.745098039215686>; // HEX #56B4BE
    #declare Xona_com_Frangipani = rgb <1, 0.870588235294118, 0.701960784313725>; // HEX #FFDEB3
    #declare Xona_com_French_Gray = rgb <0.741176470588235, 0.741176470588235, 0.776470588235294>; // HEX #BDBDC6
    #declare Xona_com_French_Lilac = rgb <0.925490196078431, 0.780392156862745, 0.933333333333333>; // HEX #ECC7EE
    #declare Xona_com_French_Pass = rgb <0.741176470588235, 0.929411764705882, 0.992156862745098>; // HEX #BDEDFD
    #declare Xona_com_Friar_Gray = rgb <0.501960784313725, 0.494117647058824, 0.474509803921569>; // HEX #807E79
    #declare Xona_com_Fringy_Flower = rgb <0.694117647058824, 0.886274509803922, 0.756862745098039>; // HEX #B1E2C1
    #declare Xona_com_Froly = rgb <0.96078431372549, 0.458823529411765, 0.517647058823529>; // HEX #F57584
    #declare Xona_com_Frost = rgb <0.929411764705882, 0.96078431372549, 0.866666666666667>; // HEX #EDF5DD
    #declare Xona_com_Frosted_Mint = rgb <0.858823529411765, 1, 0.972549019607843>; // HEX #DBFFF8
    #declare Xona_com_Frostee = rgb <0.894117647058824, 0.964705882352941, 0.905882352941176>; // HEX #E4F6E7
    #declare Xona_com_Fruit_Salad = rgb <0.309803921568627, 0.615686274509804, 0.364705882352941>; // HEX #4F9D5D
    #declare Xona_com_Fuchsia = rgb <0.47843137254902, 0.345098039215686, 0.756862745098039>; // HEX #7A58C1
    #declare Xona_com_Fuego = rgb <0.745098039215686, 0.870588235294118, 0.0509803921568627>; // HEX #BEDE0D
    #declare Xona_com_Fuel_Yellow = rgb <0.925490196078431, 0.662745098039216, 0.152941176470588>; // HEX #ECA927
    #declare Xona_com_Fun_Blue = rgb <0.0980392156862745, 0.349019607843137, 0.658823529411765>; // HEX #1959A8
    #declare Xona_com_Fun_Green = rgb <0.00392156862745098, 0.427450980392157, 0.223529411764706>; // HEX #016D39
    #declare Xona_com_Fuscous_Gray = rgb <0.329411764705882, 0.325490196078431, 0.301960784313725>; // HEX #54534D
    #declare Xona_com_Gable_Green = rgb <0.0862745098039216, 0.207843137254902, 0.192156862745098>; // HEX #163531
    #declare Xona_com_Gainsboro = rgb <0.862745098039216, 0.862745098039216, 0.862745098039216>; // HEX #DCDCDC
    #declare Xona_com_Gallery = rgb <0.937254901960784, 0.937254901960784, 0.937254901960784>; // HEX #EFEFEF
    #declare Xona_com_Galliano = rgb <0.862745098039216, 0.698039215686274, 0.0470588235294118>; // HEX #DCB20C
    #declare Xona_com_Geebung = rgb <0.819607843137255, 0.56078431372549, 0.105882352941176>; // HEX #D18F1B
    #declare Xona_com_Genoa = rgb <0.0823529411764706, 0.450980392156863, 0.419607843137255>; // HEX #15736B
    #declare Xona_com_Geraldine = rgb <0.984313725490196, 0.537254901960784, 0.537254901960784>; // HEX #FB8989
    #declare Xona_com_Geranium_Lake = rgb <0.890196078431372, 0.0705882352941176, 0.188235294117647>; // HEX #E31230
    #declare Xona_com_Geyser = rgb <0.831372549019608, 0.874509803921569, 0.886274509803922>; // HEX #D4DFE2
    #declare Xona_com_Ghost = rgb <0.780392156862745, 0.788235294117647, 0.835294117647059>; // HEX #C7C9D5
    #declare Xona_com_Ghost_White = rgb <0.972549019607843, 0.972549019607843, 1>; // HEX #F8F8FF
    #declare Xona_com_Gigas = rgb <0.32156862745098, 0.235294117647059, 0.580392156862745>; // HEX #523C94
    #declare Xona_com_Gimblet = rgb <0.72156862745098, 0.709803921568627, 0.415686274509804>; // HEX #B8B56A
    #declare Xona_com_Gin = rgb <0.909803921568627, 0.949019607843137, 0.92156862745098>; // HEX #E8F2EB
    #declare Xona_com_Gin_Fizz = rgb <1, 0.976470588235294, 0.886274509803922>; // HEX #FFF9E2
    #declare Xona_com_Givry = rgb <0.972549019607843, 0.894117647058824, 0.749019607843137>; // HEX #F8E4BF
    #declare Xona_com_Glacier = rgb <0.501960784313725, 0.701960784313725, 0.768627450980392>; // HEX #80B3C4
    #declare Xona_com_Glade_Green = rgb <0.380392156862745, 0.517647058823529, 0.372549019607843>; // HEX #61845F
    #declare Xona_com_Go_Ben = rgb <0.447058823529412, 0.427450980392157, 0.305882352941176>; // HEX #726D4E
    #declare Xona_com_Goblin = rgb <0.23921568627451, 0.490196078431373, 0.32156862745098>; // HEX #3D7D52
    #declare Xona_com_Gold = rgb <1, 0.843137254901961, 0>; // HEX #FFD700
    #declare Xona_com_Gold_1 = rgb <1, 0.843137254901961, 0>; // HEX #FFD700
    #declare Xona_com_Gold_2 = rgb <0.933333333333333, 0.788235294117647, 0>; // HEX #EEC900
    #declare Xona_com_Gold_3 = rgb <0.803921568627451, 0.67843137254902, 0>; // HEX #CDAD00
    #declare Xona_com_Gold_4 = rgb <0.545098039215686, 0.458823529411765, 0>; // HEX #8B7500
    #declare Xona_com_Gold_Drop = rgb <0.945098039215686, 0.509803921568627, 0>; // HEX #F18200
    #declare Xona_com_Gold_Ochre = rgb <0.780392156862745, 0.470588235294118, 0.149019607843137>; // HEX #C77826
    #declare Xona_com_Gold_Tips = rgb <0.870588235294118, 0.729411764705882, 0.0745098039215686>; // HEX #DEBA13
    #declare Xona_com_Golden_Bell = rgb <0.886274509803922, 0.537254901960784, 0.0745098039215686>; // HEX #E28913
    #declare Xona_com_Golden_Dream = rgb <0.941176470588235, 0.835294117647059, 0.176470588235294>; // HEX #F0D52D
    #declare Xona_com_Golden_Fizz = rgb <0.96078431372549, 0.984313725490196, 0.23921568627451>; // HEX #F5FB3D
    #declare Xona_com_Golden_Glow = rgb <0.992156862745098, 0.886274509803922, 0.584313725490196>; // HEX #FDE295
    #declare Xona_com_Golden_Sand = rgb <0.941176470588235, 0.858823529411765, 0.490196078431373>; // HEX #F0DB7D
    #declare Xona_com_Golden_Tainoi = rgb <1, 0.8, 0.36078431372549>; // HEX #FFCC5C
    #declare Xona_com_Goldenrod = rgb <0.854901960784314, 0.647058823529412, 0.125490196078431>; // HEX #DAA520
    #declare Xona_com_Goldenrod_1 = rgb <1, 0.756862745098039, 0.145098039215686>; // HEX #FFC125
    #declare Xona_com_Goldenrod_2 = rgb <0.933333333333333, 0.705882352941177, 0.133333333333333>; // HEX #EEB422
    #declare Xona_com_Goldenrod_3 = rgb <0.803921568627451, 0.607843137254902, 0.113725490196078>; // HEX #CD9B1D
    #declare Xona_com_Goldenrod_4 = rgb <0.545098039215686, 0.411764705882353, 0.0784313725490196>; // HEX #8B6914
    #declare Xona_com_Goldenrod_Dark = rgb <0.72156862745098, 0.525490196078431, 0.0431372549019608>; // HEX #B8860B
    #declare Xona_com_Goldenrod_Light = rgb <0.980392156862745, 0.980392156862745, 0.823529411764706>; // HEX #FAFAD2
    #declare Xona_com_Goldenrod_Pale = rgb <0.933333333333333, 0.909803921568627, 0.666666666666667>; // HEX #EEE8AA
    #declare Xona_com_Gondola = rgb <0.149019607843137, 0.0784313725490196, 0.0784313725490196>; // HEX #261414
    #declare Xona_com_Gordons_Green = rgb <0.0431372549019608, 0.0666666666666667, 0.0274509803921569>; // HEX #0B1107
    #declare Xona_com_Gorse = rgb <1, 0.945098039215686, 0.309803921568627>; // HEX #FFF14F
    #declare Xona_com_Gossamer = rgb <0.0235294117647059, 0.607843137254902, 0.505882352941176>; // HEX #069B81
    #declare Xona_com_Gossip = rgb <0.823529411764706, 0.972549019607843, 0.690196078431373>; // HEX #D2F8B0
    #declare Xona_com_Gothic = rgb <0.427450980392157, 0.572549019607843, 0.631372549019608>; // HEX #6D92A1
    #declare Xona_com_Governor_Bay = rgb <0.184313725490196, 0.235294117647059, 0.701960784313725>; // HEX #2F3CB3
    #declare Xona_com_Grain_Brown = rgb <0.894117647058824, 0.835294117647059, 0.717647058823529>; // HEX #E4D5B7
    #declare Xona_com_Grandis = rgb <1, 0.827450980392157, 0.549019607843137>; // HEX #FFD38C
    #declare Xona_com_Granite_Green = rgb <0.552941176470588, 0.537254901960784, 0.454901960784314>; // HEX #8D8974
    #declare Xona_com_Granny_Apple = rgb <0.835294117647059, 0.964705882352941, 0.890196078431372>; // HEX #D5F6E3
    #declare Xona_com_Granny_Smith = rgb <0.517647058823529, 0.627450980392157, 0.627450980392157>; // HEX #84A0A0
    #declare Xona_com_Grape = rgb <0.219607843137255, 0.101960784313725, 0.317647058823529>; // HEX #381A51
    #declare Xona_com_Graphite = rgb <0.145098039215686, 0.0862745098039216, 0.0274509803921569>; // HEX #251607
    #declare Xona_com_Grass_Hopper = rgb <0.486274509803922, 0.462745098039216, 0.192156862745098>; // HEX #7C7631
    #declare Xona_com_Gravel = rgb <0.290196078431373, 0.266666666666667, 0.294117647058824>; // HEX #4A444B
    #declare Xona_com_Gray = rgb <0.745098039215686, 0.745098039215686, 0.745098039215686>; // HEX #BEBEBE
    #declare Xona_com_Gray_001 = rgb <0.0117647058823529, 0.0117647058823529, 0.0117647058823529>; // HEX #030303
    #declare Xona_com_Gray_002 = rgb <0.0196078431372549, 0.0196078431372549, 0.0196078431372549>; // HEX #050505
    #declare Xona_com_Gray_003 = rgb <0.0313725490196078, 0.0313725490196078, 0.0313725490196078>; // HEX #080808
    #declare Xona_com_Gray_004 = rgb <0.0392156862745098, 0.0392156862745098, 0.0392156862745098>; // HEX #0A0A0A
    #declare Xona_com_Gray_006 = rgb <0.0588235294117647, 0.0588235294117647, 0.0588235294117647>; // HEX #0F0F0F
    #declare Xona_com_Gray_007 = rgb <0.0705882352941176, 0.0705882352941176, 0.0705882352941176>; // HEX #121212
    #declare Xona_com_Gray_008 = rgb <0.0784313725490196, 0.0784313725490196, 0.0784313725490196>; // HEX #141414
    #declare Xona_com_Gray_009 = rgb <0.0901960784313725, 0.0901960784313725, 0.0901960784313725>; // HEX #171717
    #declare Xona_com_Gray_011 = rgb <0.109803921568627, 0.109803921568627, 0.109803921568627>; // HEX #1C1C1C
    #declare Xona_com_Gray_012 = rgb <0.12156862745098, 0.12156862745098, 0.12156862745098>; // HEX #1F1F1F
    #declare Xona_com_Gray_013 = rgb <0.129411764705882, 0.129411764705882, 0.129411764705882>; // HEX #212121
    #declare Xona_com_Gray_014 = rgb <0.141176470588235, 0.141176470588235, 0.141176470588235>; // HEX #242424
    #declare Xona_com_Gray_016 = rgb <0.16078431372549, 0.16078431372549, 0.16078431372549>; // HEX #292929
    #declare Xona_com_Gray_017 = rgb <0.168627450980392, 0.168627450980392, 0.168627450980392>; // HEX #2B2B2B
    #declare Xona_com_Gray_018 = rgb <0.180392156862745, 0.180392156862745, 0.180392156862745>; // HEX #2E2E2E
    #declare Xona_com_Gray_019 = rgb <0.188235294117647, 0.188235294117647, 0.188235294117647>; // HEX #303030
    #declare Xona_com_Gray_021 = rgb <0.211764705882353, 0.211764705882353, 0.211764705882353>; // HEX #363636
    #declare Xona_com_Gray_022 = rgb <0.219607843137255, 0.219607843137255, 0.219607843137255>; // HEX #383838
    #declare Xona_com_Gray_023 = rgb <0.231372549019608, 0.231372549019608, 0.231372549019608>; // HEX #3B3B3B
    #declare Xona_com_Gray_024 = rgb <0.23921568627451, 0.23921568627451, 0.23921568627451>; // HEX #3D3D3D
    #declare Xona_com_Gray_026 = rgb <0.258823529411765, 0.258823529411765, 0.258823529411765>; // HEX #424242
    #declare Xona_com_Gray_027 = rgb <0.270588235294118, 0.270588235294118, 0.270588235294118>; // HEX #454545
    #declare Xona_com_Gray_028 = rgb <0.27843137254902, 0.27843137254902, 0.27843137254902>; // HEX #474747
    #declare Xona_com_Gray_029 = rgb <0.290196078431373, 0.290196078431373, 0.290196078431373>; // HEX #4A4A4A
    #declare Xona_com_Gray_031 = rgb <0.309803921568627, 0.309803921568627, 0.309803921568627>; // HEX #4F4F4F
    #declare Xona_com_Gray_032 = rgb <0.32156862745098, 0.32156862745098, 0.32156862745098>; // HEX #525252
    #declare Xona_com_Gray_034 = rgb <0.341176470588235, 0.341176470588235, 0.341176470588235>; // HEX #575757
    #declare Xona_com_Gray_036 = rgb <0.36078431372549, 0.36078431372549, 0.36078431372549>; // HEX #5C5C5C
    #declare Xona_com_Gray_037 = rgb <0.368627450980392, 0.368627450980392, 0.368627450980392>; // HEX #5E5E5E
    #declare Xona_com_Gray_038 = rgb <0.380392156862745, 0.380392156862745, 0.380392156862745>; // HEX #616161
    #declare Xona_com_Gray_039 = rgb <0.388235294117647, 0.388235294117647, 0.388235294117647>; // HEX #636363
    #declare Xona_com_Gray_041 = rgb <0.411764705882353, 0.411764705882353, 0.411764705882353>; // HEX #696969
    #declare Xona_com_Gray_042 = rgb <0.419607843137255, 0.419607843137255, 0.419607843137255>; // HEX #6B6B6B
    #declare Xona_com_Gray_043 = rgb <0.431372549019608, 0.431372549019608, 0.431372549019608>; // HEX #6E6E6E
    #declare Xona_com_Gray_044 = rgb <0.43921568627451, 0.43921568627451, 0.43921568627451>; // HEX #707070
    #declare Xona_com_Gray_046 = rgb <0.458823529411765, 0.458823529411765, 0.458823529411765>; // HEX #757575
    #declare Xona_com_Gray_047 = rgb <0.470588235294118, 0.470588235294118, 0.470588235294118>; // HEX #787878
    #declare Xona_com_Gray_048 = rgb <0.47843137254902, 0.47843137254902, 0.47843137254902>; // HEX #7A7A7A
    #declare Xona_com_Gray_049 = rgb <0.490196078431373, 0.490196078431373, 0.490196078431373>; // HEX #7D7D7D
    #declare Xona_com_Gray_050 = rgb <0.498039215686275, 0.498039215686275, 0.498039215686275>; // HEX #7F7F7F
    #declare Xona_com_Gray_051 = rgb <0.509803921568627, 0.509803921568627, 0.509803921568627>; // HEX #828282
    #declare Xona_com_Gray_052 = rgb <0.52156862745098, 0.52156862745098, 0.52156862745098>; // HEX #858585
    #declare Xona_com_Gray_053 = rgb <0.529411764705882, 0.529411764705882, 0.529411764705882>; // HEX #878787
    #declare Xona_com_Gray_054 = rgb <0.541176470588235, 0.541176470588235, 0.541176470588235>; // HEX #8A8A8A
    #declare Xona_com_Gray_056 = rgb <0.56078431372549, 0.56078431372549, 0.56078431372549>; // HEX #8F8F8F
    #declare Xona_com_Gray_057 = rgb <0.568627450980392, 0.568627450980392, 0.568627450980392>; // HEX #919191
    #declare Xona_com_Gray_058 = rgb <0.580392156862745, 0.580392156862745, 0.580392156862745>; // HEX #949494
    #declare Xona_com_Gray_059 = rgb <0.588235294117647, 0.588235294117647, 0.588235294117647>; // HEX #969696
    #declare Xona_com_Gray_061 = rgb <0.611764705882353, 0.611764705882353, 0.611764705882353>; // HEX #9C9C9C
    #declare Xona_com_Gray_062 = rgb <0.619607843137255, 0.619607843137255, 0.619607843137255>; // HEX #9E9E9E
    #declare Xona_com_Gray_063 = rgb <0.631372549019608, 0.631372549019608, 0.631372549019608>; // HEX #A1A1A1
    #declare Xona_com_Gray_064 = rgb <0.63921568627451, 0.63921568627451, 0.63921568627451>; // HEX #A3A3A3
    #declare Xona_com_Gray_067 = rgb <0.670588235294118, 0.670588235294118, 0.670588235294118>; // HEX #ABABAB
    #declare Xona_com_Gray_068 = rgb <0.67843137254902, 0.67843137254902, 0.67843137254902>; // HEX #ADADAD
    #declare Xona_com_Gray_069 = rgb <0.690196078431373, 0.690196078431373, 0.690196078431373>; // HEX #B0B0B0
    #declare Xona_com_Gray_071 = rgb <0.709803921568627, 0.709803921568627, 0.709803921568627>; // HEX #B5B5B5
    #declare Xona_com_Gray_072 = rgb <0.72156862745098, 0.72156862745098, 0.72156862745098>; // HEX #B8B8B8
    #declare Xona_com_Gray_073 = rgb <0.729411764705882, 0.729411764705882, 0.729411764705882>; // HEX #BABABA
    #declare Xona_com_Gray_074 = rgb <0.741176470588235, 0.741176470588235, 0.741176470588235>; // HEX #BDBDBD
    #declare Xona_com_Gray_076 = rgb <0.76078431372549, 0.76078431372549, 0.76078431372549>; // HEX #C2C2C2
    #declare Xona_com_Gray_077 = rgb <0.768627450980392, 0.768627450980392, 0.768627450980392>; // HEX #C4C4C4
    #declare Xona_com_Gray_078 = rgb <0.780392156862745, 0.780392156862745, 0.780392156862745>; // HEX #C7C7C7
    #declare Xona_com_Gray_079 = rgb <0.788235294117647, 0.788235294117647, 0.788235294117647>; // HEX #C9C9C9
    #declare Xona_com_Gray_081 = rgb <0.811764705882353, 0.811764705882353, 0.811764705882353>; // HEX #CFCFCF
    #declare Xona_com_Gray_082 = rgb <0.819607843137255, 0.819607843137255, 0.819607843137255>; // HEX #D1D1D1
    #declare Xona_com_Gray_083 = rgb <0.831372549019608, 0.831372549019608, 0.831372549019608>; // HEX #D4D4D4
    #declare Xona_com_Gray_084 = rgb <0.83921568627451, 0.83921568627451, 0.83921568627451>; // HEX #D6D6D6
    #declare Xona_com_Gray_086 = rgb <0.858823529411765, 0.858823529411765, 0.858823529411765>; // HEX #DBDBDB
    #declare Xona_com_Gray_087 = rgb <0.870588235294118, 0.870588235294118, 0.870588235294118>; // HEX #DEDEDE
    #declare Xona_com_Gray_088 = rgb <0.87843137254902, 0.87843137254902, 0.87843137254902>; // HEX #E0E0E0
    #declare Xona_com_Gray_089 = rgb <0.890196078431372, 0.890196078431372, 0.890196078431372>; // HEX #E3E3E3
    #declare Xona_com_Gray_090 = rgb <0.898039215686275, 0.898039215686275, 0.898039215686275>; // HEX #E5E5E5
    #declare Xona_com_Gray_091 = rgb <0.909803921568627, 0.909803921568627, 0.909803921568627>; // HEX #E8E8E8
    #declare Xona_com_Gray_092 = rgb <0.92156862745098, 0.92156862745098, 0.92156862745098>; // HEX #EBEBEB
    #declare Xona_com_Gray_093 = rgb <0.929411764705882, 0.929411764705882, 0.929411764705882>; // HEX #EDEDED
    #declare Xona_com_Gray_094 = rgb <0.941176470588235, 0.941176470588235, 0.941176470588235>; // HEX #F0F0F0
    #declare Xona_com_Gray_096 = rgb <0.96078431372549, 0.96078431372549, 0.96078431372549>; // HEX #F5F5F5
    #declare Xona_com_Gray_097 = rgb <0.968627450980392, 0.968627450980392, 0.968627450980392>; // HEX #F7F7F7
    #declare Xona_com_Gray_098 = rgb <0.980392156862745, 0.980392156862745, 0.980392156862745>; // HEX #FAFAFA
    #declare Xona_com_Gray_099 = rgb <0.988235294117647, 0.988235294117647, 0.988235294117647>; // HEX #FCFCFC
    #declare Xona_com_Gray_Chateau = rgb <0.635294117647059, 0.666666666666667, 0.701960784313725>; // HEX #A2AAB3
    #declare Xona_com_Gray_Green = rgb <0.270588235294118, 0.286274509803922, 0.211764705882353>; // HEX #454936
    #declare Xona_com_Gray_Nickel = rgb <0.764705882352941, 0.764705882352941, 0.741176470588235>; // HEX #C3C3BD
    #declare Xona_com_Gray_Nurse = rgb <0.905882352941176, 0.925490196078431, 0.901960784313726>; // HEX #E7ECE6
    #declare Xona_com_Gray_Olive = rgb <0.662745098039216, 0.643137254901961, 0.568627450980392>; // HEX #A9A491
    #declare Xona_com_Gray_Suit = rgb <0.756862745098039, 0.745098039215686, 0.803921568627451>; // HEX #C1BECD
    #declare Xona_com_Green_2 = rgb <0, 0.933333333333333, 0>; // HEX #00EE00
    #declare Xona_com_Green_3 = rgb <0, 0.803921568627451, 0>; // HEX #00CD00
    #declare Xona_com_Green_4 = rgb <0, 0.545098039215686, 0>; // HEX #008B00
    #declare Xona_com_Green_Dark = rgb <0, 0.392156862745098, 0>; // HEX #006400
    #declare Xona_com_Green_House = rgb <0.141176470588235, 0.313725490196078, 0.0588235294117647>; // HEX #24500F
    #declare Xona_com_Green_Kelp = rgb <0.145098039215686, 0.192156862745098, 0.109803921568627>; // HEX #25311C
    #declare Xona_com_Green_Leaf = rgb <0.262745098039216, 0.415686274509804, 0.0509803921568627>; // HEX #436A0D
    #declare Xona_com_Green_Mist = rgb <0.796078431372549, 0.827450980392157, 0.690196078431373>; // HEX #CBD3B0
    #declare Xona_com_Green_Pale = rgb <0.596078431372549, 0.984313725490196, 0.596078431372549>; // HEX #98FB98
    #declare Xona_com_Green_Pea = rgb <0.113725490196078, 0.380392156862745, 0.258823529411765>; // HEX #1D6142
    #declare Xona_com_Green_Smoke = rgb <0.643137254901961, 0.686274509803922, 0.431372549019608>; // HEX #A4AF6E
    #declare Xona_com_Green_Spring = rgb <0.72156862745098, 0.756862745098039, 0.694117647058824>; // HEX #B8C1B1
    #declare Xona_com_Green_Vogue = rgb <0.0117647058823529, 0.168627450980392, 0.32156862745098>; // HEX #032B52
    #declare Xona_com_Green_Waterloo = rgb <0.0627450980392157, 0.0784313725490196, 0.0196078431372549>; // HEX #101405
    #declare Xona_com_Green_White = rgb <0.909803921568627, 0.92156862745098, 0.87843137254902>; // HEX #E8EBE0
    #declare Xona_com_Green_Yellow = rgb <0.67843137254902, 1, 0.184313725490196>; // HEX #ADFF2F
    #declare Xona_com_Greenish_Umber = rgb <1, 0.23921568627451, 0.0509803921568627>; // HEX #FF3D0D
    #declare Xona_com_Greenstone = rgb <0, 0.243137254901961, 0.250980392156863>; // HEX #003E40
    #declare Xona_com_Grenadier = rgb <0.835294117647059, 0.274509803921569, 0>; // HEX #D54600
    #declare Xona_com_Guardsman_Red = rgb <0.729411764705882, 0.00392156862745098, 0.00392156862745098>; // HEX #BA0101
    #declare Xona_com_Gulf_Blue = rgb <0.0196078431372549, 0.0862745098039216, 0.341176470588235>; // HEX #051657
    #declare Xona_com_Gulf_Stream = rgb <0.501960784313725, 0.701960784313725, 0.682352941176471>; // HEX #80B3AE
    #declare Xona_com_Gull_Gray = rgb <0.615686274509804, 0.674509803921569, 0.717647058823529>; // HEX #9DACB7
    #declare Xona_com_Gum_Leaf = rgb <0.713725490196078, 0.827450980392157, 0.749019607843137>; // HEX #B6D3BF
    #declare Xona_com_Gumbo = rgb <0.486274509803922, 0.631372549019608, 0.650980392156863>; // HEX #7CA1A6
    #declare Xona_com_Gun_Powder = rgb <0.254901960784314, 0.258823529411765, 0.341176470588235>; // HEX #414257
    #declare Xona_com_Gunmetal = rgb <0.00784313725490196, 0.0509803921568627, 0.0823529411764706>; // HEX #020D15
    #declare Xona_com_Gunsmoke = rgb <0.509803921568627, 0.525490196078431, 0.52156862745098>; // HEX #828685
    #declare Xona_com_Gurkha = rgb <0.603921568627451, 0.584313725490196, 0.466666666666667>; // HEX #9A9577
    #declare Xona_com_Hacienda = rgb <0.596078431372549, 0.505882352941176, 0.105882352941176>; // HEX #98811B
    #declare Xona_com_Hairy_Heath = rgb <0.419607843137255, 0.164705882352941, 0.0784313725490196>; // HEX #6B2A14
    #declare Xona_com_Haiti = rgb <0.105882352941176, 0.0627450980392157, 0.207843137254902>; // HEX #1B1035
    #declare Xona_com_Half_And_Half = rgb <1, 0.996078431372549, 0.882352941176471>; // HEX #FFFEE1
    #declare Xona_com_Half_Baked = rgb <0.52156862745098, 0.768627450980392, 0.8>; // HEX #85C4CC
    #declare Xona_com_Half_Colonial_White = rgb <0.992156862745098, 0.964705882352941, 0.827450980392157>; // HEX #FDF6D3
    #declare Xona_com_Half_Dutch_White = rgb <0.996078431372549, 0.968627450980392, 0.870588235294118>; // HEX #FEF7DE
    #declare Xona_com_Half_Pearl_Lusta = rgb <1, 0.988235294117647, 0.917647058823529>; // HEX #FFFCEA
    #declare Xona_com_Half_Spanish_White = rgb <0.996078431372549, 0.956862745098039, 0.858823529411765>; // HEX #FEF4DB
    #declare Xona_com_Hampton = rgb <0.898039215686275, 0.847058823529412, 0.686274509803922>; // HEX #E5D8AF
    #declare Xona_com_Harp = rgb <0.901960784313726, 0.949019607843137, 0.917647058823529>; // HEX #E6F2EA
    #declare Xona_com_Harvest_Gold = rgb <0.87843137254902, 0.725490196078431, 0.454901960784314>; // HEX #E0B974
    #declare Xona_com_Havana = rgb <0.203921568627451, 0.0823529411764706, 0.0823529411764706>; // HEX #341515
    #declare Xona_com_Havelock_Blue = rgb <0.333333333333333, 0.564705882352941, 0.850980392156863>; // HEX #5590D9
    #declare Xona_com_Hawaiian_Tan = rgb <0.615686274509804, 0.337254901960784, 0.0862745098039216>; // HEX #9D5616
    #declare Xona_com_Hawkes_Blue = rgb <0.831372549019608, 0.886274509803922, 0.988235294117647>; // HEX #D4E2FC
    #declare Xona_com_Heath = rgb <0.329411764705882, 0.0627450980392157, 0.0705882352941176>; // HEX #541012
    #declare Xona_com_Heather = rgb <0.717647058823529, 0.764705882352941, 0.815686274509804>; // HEX #B7C3D0
    #declare Xona_com_Heathered_Gray = rgb <0.713725490196078, 0.690196078431373, 0.584313725490196>; // HEX #B6B095
    #declare Xona_com_Heavy_Metal = rgb <0.168627450980392, 0.196078431372549, 0.156862745098039>; // HEX #2B3228
    #declare Xona_com_Hemlock = rgb <0.368627450980392, 0.364705882352941, 0.231372549019608>; // HEX #5E5D3B
    #declare Xona_com_Hemp = rgb <0.564705882352941, 0.470588235294118, 0.454901960784314>; // HEX #907874
    #declare Xona_com_Hibiscus = rgb <0.713725490196078, 0.192156862745098, 0.423529411764706>; // HEX #B6316C
    #declare Xona_com_Highball = rgb <0.564705882352941, 0.552941176470588, 0.223529411764706>; // HEX #908D39
    #declare Xona_com_Highland = rgb <0.435294117647059, 0.556862745098039, 0.388235294117647>; // HEX #6F8E63
    #declare Xona_com_Hillary = rgb <0.674509803921569, 0.647058823529412, 0.525490196078431>; // HEX #ACA586
    #declare Xona_com_Himalaya = rgb <0.415686274509804, 0.364705882352941, 0.105882352941176>; // HEX #6A5D1B
    #declare Xona_com_Hint_Of_Gray = rgb <0.988235294117647, 1, 0.976470588235294>; // HEX #FCFFF9
    #declare Xona_com_Hint_Of_Green = rgb <0.901960784313726, 1, 0.913725490196078>; // HEX #E6FFE9
    #declare Xona_com_Hint_Of_Red = rgb <0.976470588235294, 0.976470588235294, 0.976470588235294>; // HEX #F9F9F9
    #declare Xona_com_Hint_Of_Yellow = rgb <0.980392156862745, 0.992156862745098, 0.894117647058824>; // HEX #FAFDE4
    #declare Xona_com_Hippie_Blue = rgb <0.345098039215686, 0.603921568627451, 0.686274509803922>; // HEX #589AAF
    #declare Xona_com_Hippie_Green = rgb <0.325490196078431, 0.509803921568627, 0.294117647058824>; // HEX #53824B
    #declare Xona_com_Hippie_Pink = rgb <0.682352941176471, 0.270588235294118, 0.376470588235294>; // HEX #AE4560
    #declare Xona_com_Hit_Gray = rgb <0.631372549019608, 0.67843137254902, 0.709803921568627>; // HEX #A1ADB5
    #declare Xona_com_Hit_Pink = rgb <1, 0.670588235294118, 0.505882352941176>; // HEX #FFAB81
    #declare Xona_com_Hokey_Pokey = rgb <0.784313725490196, 0.647058823529412, 0.156862745098039>; // HEX #C8A528
    #declare Xona_com_Hoki = rgb <0.396078431372549, 0.525490196078431, 0.623529411764706>; // HEX #65869F
    #declare Xona_com_Holly = rgb <0.00392156862745098, 0.113725490196078, 0.0745098039215686>; // HEX #011D13
    #declare Xona_com_Honey_Flower = rgb <0.309803921568627, 0.109803921568627, 0.43921568627451>; // HEX #4F1C70
    #declare Xona_com_Honeydew = rgb <0.941176470588235, 1, 0.941176470588235>; // HEX #F0FFF0
    #declare Xona_com_Honeydew_1 = rgb <0.941176470588235, 1, 0.941176470588235>; // HEX #F0FFF0
    #declare Xona_com_Honeydew_2 = rgb <0.87843137254902, 0.933333333333333, 0.87843137254902>; // HEX #E0EEE0
    #declare Xona_com_Honeydew_3 = rgb <0.756862745098039, 0.803921568627451, 0.756862745098039>; // HEX #C1CDC1
    #declare Xona_com_Honeydew_4 = rgb <0.513725490196078, 0.545098039215686, 0.513725490196078>; // HEX #838B83
    #declare Xona_com_Honeysuckle = rgb <0.929411764705882, 0.988235294117647, 0.517647058823529>; // HEX #EDFC84
    #declare Xona_com_Hopbush = rgb <0.815686274509804, 0.427450980392157, 0.631372549019608>; // HEX #D06DA1
    #declare Xona_com_Horizon = rgb <0.352941176470588, 0.529411764705882, 0.627450980392157>; // HEX #5A87A0
    #declare Xona_com_Horses_Neck = rgb <0.376470588235294, 0.286274509803922, 0.0745098039215686>; // HEX #604913
    #declare Xona_com_Hot_Chile = rgb <0.545098039215686, 0.0274509803921569, 0.137254901960784>; // HEX #8B0723
    #declare Xona_com_Hot_Curry = rgb <0.533333333333333, 0.384313725490196, 0.129411764705882>; // HEX #886221
    #declare Xona_com_Hot_Pink = rgb <1, 0.411764705882353, 0.705882352941177>; // HEX #FF69B4
    #declare Xona_com_Hot_Pink_1 = rgb <1, 0.431372549019608, 0.705882352941177>; // HEX #FF6EB4
    #declare Xona_com_Hot_Pink_2 = rgb <0.933333333333333, 0.415686274509804, 0.654901960784314>; // HEX #EE6AA7
    #declare Xona_com_Hot_Pink_3 = rgb <0.803921568627451, 0.376470588235294, 0.564705882352941>; // HEX #CD6090
    #declare Xona_com_Hot_Pink_4 = rgb <0.545098039215686, 0.227450980392157, 0.384313725490196>; // HEX #8B3A62
    #declare Xona_com_Hot_Purple = rgb <0.282352941176471, 0.0235294117647059, 0.337254901960784>; // HEX #480656
    #declare Xona_com_Hot_Toddy = rgb <0.701960784313725, 0.501960784313725, 0.0274509803921569>; // HEX #B38007
    #declare Xona_com_Humming_Bird = rgb <0.811764705882353, 0.976470588235294, 0.952941176470588>; // HEX #CFF9F3
    #declare Xona_com_Hunter_Green = rgb <0.0862745098039216, 0.113725490196078, 0.0627450980392157>; // HEX #161D10
    #declare Xona_com_Hurricane = rgb <0.529411764705882, 0.486274509803922, 0.482352941176471>; // HEX #877C7B
    #declare Xona_com_Husk = rgb <0.717647058823529, 0.643137254901961, 0.345098039215686>; // HEX #B7A458
    #declare Xona_com_Ice_Cold = rgb <0.694117647058824, 0.956862745098039, 0.905882352941176>; // HEX #B1F4E7
    #declare Xona_com_Iceberg = rgb <0.854901960784314, 0.956862745098039, 0.941176470588235>; // HEX #DAF4F0
    #declare Xona_com_Illusion = rgb <0.964705882352941, 0.643137254901961, 0.788235294117647>; // HEX #F6A4C9
    #declare Xona_com_Indian_Red = rgb <0.803921568627451, 0.36078431372549, 0.36078431372549>; // HEX #CD5C5C
    #declare Xona_com_Indian_Red_1 = rgb <1, 0.415686274509804, 0.415686274509804>; // HEX #FF6A6A
    #declare Xona_com_Indian_Red_2 = rgb <0.933333333333333, 0.388235294117647, 0.388235294117647>; // HEX #EE6363
    #declare Xona_com_Indian_Red_3 = rgb <0.803921568627451, 0.333333333333333, 0.333333333333333>; // HEX #CD5555
    #declare Xona_com_Indian_Red_4 = rgb <0.545098039215686, 0.227450980392157, 0.227450980392157>; // HEX #8B3A3A
    #declare Xona_com_Indian_Red_Dark = rgb <0.690196078431373, 0.0901960784313725, 0.12156862745098>; // HEX #B0171F
    #declare Xona_com_Indian_Tan = rgb <0.301960784313725, 0.117647058823529, 0.00392156862745098>; // HEX #4D1E01
    #declare Xona_com_Indigo = rgb <0.0313725490196078, 0.180392156862745, 0.329411764705882>; // HEX #082E54
    #declare Xona_com_Indochine = rgb <0.76078431372549, 0.419607843137255, 0.0117647058823529>; // HEX #C26B03
    #declare Xona_com_Irish_Coffee = rgb <0.372549019607843, 0.23921568627451, 0.149019607843137>; // HEX #5F3D26
    #declare Xona_com_Iroko = rgb <0.262745098039216, 0.192156862745098, 0.125490196078431>; // HEX #433120
    #declare Xona_com_Iron = rgb <0.831372549019608, 0.843137254901961, 0.850980392156863>; // HEX #D4D7D9
    #declare Xona_com_Ironbark = rgb <0.254901960784314, 0.12156862745098, 0.0627450980392157>; // HEX #411F10
    #declare Xona_com_Ironside_Gray = rgb <0.403921568627451, 0.4, 0.384313725490196>; // HEX #676662
    #declare Xona_com_Ironstone = rgb <0.525490196078431, 0.282352941176471, 0.235294117647059>; // HEX #86483C
    #declare Xona_com_Island_Spice = rgb <1, 0.988235294117647, 0.933333333333333>; // HEX #FFFCEE
    #declare Xona_com_Ivory = rgb <1, 1, 0.941176470588235>; // HEX #FFFFF0
    #declare Xona_com_Ivory_1 = rgb <1, 1, 0.941176470588235>; // HEX #FFFFF0
    #declare Xona_com_Ivory_2 = rgb <0.933333333333333, 0.933333333333333, 0.87843137254902>; // HEX #EEEEE0
    #declare Xona_com_Ivory_3 = rgb <0.803921568627451, 0.803921568627451, 0.756862745098039>; // HEX #CDCDC1
    #declare Xona_com_Ivory_4 = rgb <0.545098039215686, 0.545098039215686, 0.513725490196078>; // HEX #8B8B83
    #declare Xona_com_Ivory_Black = rgb <0.16078431372549, 0.141176470588235, 0.129411764705882>; // HEX #292421
    #declare Xona_com_Jacaranda = rgb <0.180392156862745, 0.0117647058823529, 0.16078431372549>; // HEX #2E0329
    #declare Xona_com_Jacarta = rgb <0.227450980392157, 0.164705882352941, 0.415686274509804>; // HEX #3A2A6A
    #declare Xona_com_Jacko_Bean = rgb <0.180392156862745, 0.0980392156862745, 0.0196078431372549>; // HEX #2E1905
    #declare Xona_com_Jacksons_Purple = rgb <0.125490196078431, 0.125490196078431, 0.552941176470588>; // HEX #20208D
    #declare Xona_com_Jade = rgb <0.258823529411765, 0.474509803921569, 0.466666666666667>; // HEX #427977
    #declare Xona_com_Jaffa = rgb <0.937254901960784, 0.525490196078431, 0.247058823529412>; // HEX #EF863F
    #declare Xona_com_Jagged_Ice = rgb <0.76078431372549, 0.909803921568627, 0.898039215686275>; // HEX #C2E8E5
    #declare Xona_com_Jagger = rgb <0.207843137254902, 0.0549019607843137, 0.341176470588235>; // HEX #350E57
    #declare Xona_com_Jaguar = rgb <0.0313725490196078, 0.00392156862745098, 0.0627450980392157>; // HEX #080110
    #declare Xona_com_Jambalaya = rgb <0.356862745098039, 0.188235294117647, 0.0745098039215686>; // HEX #5B3013
    #declare Xona_com_Janna = rgb <0.956862745098039, 0.92156862745098, 0.827450980392157>; // HEX #F4EBD3
    #declare Xona_com_Japanese_Laurel = rgb <0.0392156862745098, 0.411764705882353, 0.0235294117647059>; // HEX #0A6906
    #declare Xona_com_Japanese_Maple = rgb <0.470588235294118, 0.00392156862745098, 0.0352941176470588>; // HEX #780109
    #declare Xona_com_Japonica = rgb <0.847058823529412, 0.486274509803922, 0.388235294117647>; // HEX #D87C63
    #declare Xona_com_Jarrah = rgb <0.203921568627451, 0.0823529411764706, 0.0823529411764706>; // HEX #341515
    #declare Xona_com_Java = rgb <0.12156862745098, 0.76078431372549, 0.76078431372549>; // HEX #1FC2C2
    #declare Xona_com_Jazz = rgb <0.470588235294118, 0.00392156862745098, 0.0352941176470588>; // HEX #780109
    #declare Xona_com_Jelly_Bean = rgb <0.16078431372549, 0.482352941176471, 0.603921568627451>; // HEX #297B9A
    #declare Xona_com_Jet_Stream = rgb <0.709803921568627, 0.823529411764706, 0.807843137254902>; // HEX #B5D2CE
    #declare Xona_com_Jewel = rgb <0.0705882352941176, 0.419607843137255, 0.250980392156863>; // HEX #126B40
    #declare Xona_com_Joanna = rgb <0.96078431372549, 0.952941176470588, 0.898039215686275>; // HEX #F5F3E5
    #declare Xona_com_Jon = rgb <0.231372549019608, 0.12156862745098, 0.12156862745098>; // HEX #3B1F1F
    #declare Xona_com_Jonquil = rgb <0.933333333333333, 1, 0.603921568627451>; // HEX #EEFF9A
    #declare Xona_com_Jordy_Blue = rgb <0.541176470588235, 0.725490196078431, 0.945098039215686>; // HEX #8AB9F1
    #declare Xona_com_Judge_Gray = rgb <0.329411764705882, 0.262745098039216, 0.2>; // HEX #544333
    #declare Xona_com_Jumbo = rgb <0.486274509803922, 0.482352941176471, 0.509803921568627>; // HEX #7C7B82
    #declare Xona_com_Jungle_Green = rgb <0.156862745098039, 0.117647058823529, 0.0823529411764706>; // HEX #281E15
    #declare Xona_com_Jungle_Mist = rgb <0.705882352941177, 0.811764705882353, 0.827450980392157>; // HEX #B4CFD3
    #declare Xona_com_Juniper = rgb <0.427450980392157, 0.572549019607843, 0.572549019607843>; // HEX #6D9292
    #declare Xona_com_Just_Right = rgb <0.925490196078431, 0.803921568627451, 0.725490196078431>; // HEX #ECCDB9
    #declare Xona_com_Kabul = rgb <0.368627450980392, 0.282352941176471, 0.243137254901961>; // HEX #5E483E
    #declare Xona_com_Kaitoke_Green = rgb <0, 0.274509803921569, 0.125490196078431>; // HEX #004620
    #declare Xona_com_Kangaroo = rgb <0.776470588235294, 0.784313725490196, 0.741176470588235>; // HEX #C6C8BD
    #declare Xona_com_Karaka = rgb <0.117647058823529, 0.0862745098039216, 0.0352941176470588>; // HEX #1E1609
    #declare Xona_com_Karry = rgb <1, 0.917647058823529, 0.831372549019608>; // HEX #FFEAD4
    #declare Xona_com_Kashmir_Blue = rgb <0.313725490196078, 0.43921568627451, 0.588235294117647>; // HEX #507096
    #declare Xona_com_Kelp = rgb <0.270588235294118, 0.286274509803922, 0.211764705882353>; // HEX #454936
    #declare Xona_com_Kenyan_Copper = rgb <0.486274509803922, 0.109803921568627, 0.0196078431372549>; // HEX #7C1C05
    #declare Xona_com_Keppel = rgb <0.227450980392157, 0.690196078431373, 0.619607843137255>; // HEX #3AB09E
    #declare Xona_com_Khaki = rgb <0.941176470588235, 0.901960784313726, 0.549019607843137>; // HEX #F0E68C
    #declare Xona_com_Khaki_1 = rgb <1, 0.964705882352941, 0.56078431372549>; // HEX #FFF68F
    #declare Xona_com_Khaki_2 = rgb <0.933333333333333, 0.901960784313726, 0.52156862745098>; // HEX #EEE685
    #declare Xona_com_Khaki_3 = rgb <0.803921568627451, 0.776470588235294, 0.450980392156863>; // HEX #CDC673
    #declare Xona_com_Khaki_4 = rgb <0.545098039215686, 0.525490196078431, 0.305882352941176>; // HEX #8B864E
    #declare Xona_com_Khaki_Dark = rgb <0.741176470588235, 0.717647058823529, 0.419607843137255>; // HEX #BDB76B
    #declare Xona_com_Kidnapper = rgb <0.882352941176471, 0.917647058823529, 0.831372549019608>; // HEX #E1EAD4
    #declare Xona_com_Kilamanjaro = rgb <0.141176470588235, 0.0470588235294118, 0.00784313725490196>; // HEX #240C02
    #declare Xona_com_Killarney = rgb <0.227450980392157, 0.415686274509804, 0.27843137254902>; // HEX #3A6A47
    #declare Xona_com_Kimberly = rgb <0.450980392156863, 0.423529411764706, 0.623529411764706>; // HEX #736C9F
    #declare Xona_com_Kingfisher_Daisy = rgb <0.243137254901961, 0.0156862745098039, 0.501960784313725>; // HEX #3E0480
    #declare Xona_com_Kobi = rgb <0.905882352941176, 0.623529411764706, 0.768627450980392>; // HEX #E79FC4
    #declare Xona_com_Kokoda = rgb <0.431372549019608, 0.427450980392157, 0.341176470588235>; // HEX #6E6D57
    #declare Xona_com_Korma = rgb <0.56078431372549, 0.294117647058824, 0.0549019607843137>; // HEX #8F4B0E
    #declare Xona_com_Koromiko = rgb <1, 0.741176470588235, 0.372549019607843>; // HEX #FFBD5F
    #declare Xona_com_Kournikova = rgb <1, 0.905882352941176, 0.447058823529412>; // HEX #FFE772
    #declare Xona_com_Kumera = rgb <0.533333333333333, 0.384313725490196, 0.129411764705882>; // HEX #886221
    #declare Xona_com_La_Palma = rgb <0.211764705882353, 0.529411764705882, 0.0862745098039216>; // HEX #368716
    #declare Xona_com_La_Rioja = rgb <0.701960784313725, 0.756862745098039, 0.0627450980392157>; // HEX #B3C110
    #declare Xona_com_Lamp_Black = rgb <0.180392156862745, 0.27843137254902, 0.231372549019608>; // HEX #2E473B
    #declare Xona_com_Las_Palmas = rgb <0.776470588235294, 0.901960784313726, 0.0627450980392157>; // HEX #C6E610
    #declare Xona_com_Laser = rgb <0.784313725490196, 0.709803921568627, 0.407843137254902>; // HEX #C8B568
    #declare Xona_com_Laurel = rgb <0.454901960784314, 0.576470588235294, 0.470588235294118>; // HEX #749378
    #declare Xona_com_Lavender = rgb <0.658823529411765, 0.6, 0.901960784313726>; // HEX #A899E6
    #declare Xona_com_Lavender_Blush = rgb <1, 0.941176470588235, 0.96078431372549>; // HEX #FFF0F5
    #declare Xona_com_Lavender_Blush_1 = rgb <1, 0.941176470588235, 0.96078431372549>; // HEX #FFF0F5
    #declare Xona_com_Lavender_Blush_2 = rgb <0.933333333333333, 0.87843137254902, 0.898039215686275>; // HEX #EEE0E5
    #declare Xona_com_Lavender_Blush_3 = rgb <0.803921568627451, 0.756862745098039, 0.772549019607843>; // HEX #CDC1C5
    #declare Xona_com_Lavender_Blush_4 = rgb <0.545098039215686, 0.513725490196078, 0.525490196078431>; // HEX #8B8386
    #declare Xona_com_Lavender_Light = rgb <0.901960784313726, 0.901960784313726, 0.980392156862745>; // HEX #E6E6FA
    #declare Xona_com_Lawn_Green = rgb <0.486274509803922, 0.988235294117647, 0>; // HEX #7CFC00
    #declare Xona_com_Leather = rgb <0.588235294117647, 0.43921568627451, 0.349019607843137>; // HEX #967059
    #declare Xona_com_Lemon = rgb <0.956862745098039, 0.847058823529412, 0.109803921568627>; // HEX #F4D81C
    #declare Xona_com_Lemon_Chiffon = rgb <1, 0.980392156862745, 0.803921568627451>; // HEX #FFFACD
    #declare Xona_com_Lemon_Chiffon_1 = rgb <1, 0.980392156862745, 0.803921568627451>; // HEX #FFFACD
    #declare Xona_com_Lemon_Chiffon_2 = rgb <0.933333333333333, 0.913725490196078, 0.749019607843137>; // HEX #EEE9BF
    #declare Xona_com_Lemon_Chiffon_3 = rgb <0.803921568627451, 0.788235294117647, 0.647058823529412>; // HEX #CDC9A5
    #declare Xona_com_Lemon_Chiffon_4 = rgb <0.545098039215686, 0.537254901960784, 0.43921568627451>; // HEX #8B8970
    #declare Xona_com_Lemon_Ginger = rgb <0.674509803921569, 0.619607843137255, 0.133333333333333>; // HEX #AC9E22
    #declare Xona_com_Lemon_Grass = rgb <0.607843137254902, 0.619607843137255, 0.56078431372549>; // HEX #9B9E8F
    #declare Xona_com_Licorice = rgb <0.0352941176470588, 0.133333333333333, 0.337254901960784>; // HEX #092256
    #declare Xona_com_Light_Beige = rgb <0.96078431372549, 0.96078431372549, 0.862745098039216>; // HEX #F5F5DC
    #declare Xona_com_Light_Blue = rgb <0.67843137254902, 0.847058823529412, 0.901960784313726>; // HEX #ADD8E6
    #declare Xona_com_Light_Blue_1 = rgb <0.749019607843137, 0.937254901960784, 1>; // HEX #BFEFFF
    #declare Xona_com_Light_Blue_2 = rgb <0.698039215686274, 0.874509803921569, 0.933333333333333>; // HEX #B2DFEE
    #declare Xona_com_Light_Blue_3 = rgb <0.603921568627451, 0.752941176470588, 0.803921568627451>; // HEX #9AC0CD
    #declare Xona_com_Light_Blue_4 = rgb <0.407843137254902, 0.513725490196078, 0.545098039215686>; // HEX #68838B
    #declare Xona_com_Light_Coral = rgb <0.941176470588235, 0.501960784313725, 0.501960784313725>; // HEX #F08080
    #declare Xona_com_Light_Cyan = rgb <0.87843137254902, 1, 1>; // HEX #E0FFFF
    #declare Xona_com_Light_Cyan_1 = rgb <0.87843137254902, 1, 1>; // HEX #E0FFFF
    #declare Xona_com_Light_Cyan_2 = rgb <0.819607843137255, 0.933333333333333, 0.933333333333333>; // HEX #D1EEEE
    #declare Xona_com_Light_Cyan_3 = rgb <0.705882352941177, 0.803921568627451, 0.803921568627451>; // HEX #B4CDCD
    #declare Xona_com_Light_Cyan_4 = rgb <0.47843137254902, 0.545098039215686, 0.545098039215686>; // HEX #7A8B8B
    #declare Xona_com_Light_Goldenrod = rgb <0.933333333333333, 0.866666666666667, 0.509803921568627>; // HEX #EEDD82
    #declare Xona_com_Light_Goldenrod_1 = rgb <1, 0.925490196078431, 0.545098039215686>; // HEX #FFEC8B
    #declare Xona_com_Light_Goldenrod_2 = rgb <0.933333333333333, 0.862745098039216, 0.509803921568627>; // HEX #EEDC82
    #declare Xona_com_Light_Goldenrod_3 = rgb <0.803921568627451, 0.745098039215686, 0.43921568627451>; // HEX #CDBE70
    #declare Xona_com_Light_Goldenrod_4 = rgb <0.545098039215686, 0.505882352941176, 0.298039215686275>; // HEX #8B814C
    #declare Xona_com_Light_Goldenrod_Yellow = rgb <0.980392156862745, 0.980392156862745, 0.823529411764706>; // HEX #FAFAD2
    #declare Xona_com_Light_Gray = rgb <0.827450980392157, 0.827450980392157, 0.827450980392157>; // HEX #D3D3D3
    #declare Xona_com_Light_Green = rgb <0.564705882352941, 0.933333333333333, 0.564705882352941>; // HEX #90EE90
    #declare Xona_com_Light_Pink = rgb <1, 0.713725490196078, 0.756862745098039>; // HEX #FFB6C1
    #declare Xona_com_Light_Pink_1 = rgb <1, 0.682352941176471, 0.725490196078431>; // HEX #FFAEB9
    #declare Xona_com_Light_Pink_2 = rgb <0.933333333333333, 0.635294117647059, 0.67843137254902>; // HEX #EEA2AD
    #declare Xona_com_Light_Pink_3 = rgb <0.803921568627451, 0.549019607843137, 0.584313725490196>; // HEX #CD8C95
    #declare Xona_com_Light_Pink_4 = rgb <0.545098039215686, 0.372549019607843, 0.396078431372549>; // HEX #8B5F65
    #declare Xona_com_Light_Salmon = rgb <1, 0.627450980392157, 0.47843137254902>; // HEX #FFA07A
    #declare Xona_com_Light_Salmon_1 = rgb <1, 0.627450980392157, 0.47843137254902>; // HEX #FFA07A
    #declare Xona_com_Light_Salmon_2 = rgb <0.933333333333333, 0.584313725490196, 0.447058823529412>; // HEX #EE9572
    #declare Xona_com_Light_Salmon_3 = rgb <0.803921568627451, 0.505882352941176, 0.384313725490196>; // HEX #CD8162
    #declare Xona_com_Light_Salmon_4 = rgb <0.545098039215686, 0.341176470588235, 0.258823529411765>; // HEX #8B5742
    #declare Xona_com_Light_Sea_Green = rgb <0.125490196078431, 0.698039215686274, 0.666666666666667>; // HEX #20B2AA
    #declare Xona_com_Light_Sky_Blue = rgb <0.529411764705882, 0.807843137254902, 0.980392156862745>; // HEX #87CEFA
    #declare Xona_com_Light_Sky_Blue_1 = rgb <0.690196078431373, 0.886274509803922, 1>; // HEX #B0E2FF
    #declare Xona_com_Light_Sky_Blue_2 = rgb <0.643137254901961, 0.827450980392157, 0.933333333333333>; // HEX #A4D3EE
    #declare Xona_com_Light_Sky_Blue_3 = rgb <0.552941176470588, 0.713725490196078, 0.803921568627451>; // HEX #8DB6CD
    #declare Xona_com_Light_Sky_Blue_4 = rgb <0.376470588235294, 0.482352941176471, 0.545098039215686>; // HEX #607B8B
    #declare Xona_com_Light_Slate_Blue = rgb <0.517647058823529, 0.43921568627451, 1>; // HEX #8470FF
    #declare Xona_com_Light_Slate_Gray = rgb <0.466666666666667, 0.533333333333333, 0.6>; // HEX #778899
    #declare Xona_com_Light_Steel_Blue = rgb <0.690196078431373, 0.768627450980392, 0.870588235294118>; // HEX #B0C4DE
    #declare Xona_com_Light_Steel_Blue_1 = rgb <0.792156862745098, 0.882352941176471, 1>; // HEX #CAE1FF
    #declare Xona_com_Light_Steel_Blue_2 = rgb <0.737254901960784, 0.823529411764706, 0.933333333333333>; // HEX #BCD2EE
    #declare Xona_com_Light_Steel_Blue_3 = rgb <0.635294117647059, 0.709803921568627, 0.803921568627451>; // HEX #A2B5CD
    #declare Xona_com_Light_Steel_Blue_4 = rgb <0.431372549019608, 0.482352941176471, 0.545098039215686>; // HEX #6E7B8B
    #declare Xona_com_Light_Yellow = rgb <1, 1, 0.87843137254902>; // HEX #FFFFE0
    #declare Xona_com_Light_Yellow_1 = rgb <1, 1, 0.87843137254902>; // HEX #FFFFE0
    #declare Xona_com_Light_Yellow_2 = rgb <0.933333333333333, 0.933333333333333, 0.819607843137255>; // HEX #EEEED1
    #declare Xona_com_Light_Yellow_3 = rgb <0.803921568627451, 0.803921568627451, 0.705882352941177>; // HEX #CDCDB4
    #declare Xona_com_Light_Yellow_4 = rgb <0.545098039215686, 0.545098039215686, 0.47843137254902>; // HEX #8B8B7A
    #declare Xona_com_Lightning_Yellow = rgb <0.988235294117647, 0.752941176470588, 0.117647058823529>; // HEX #FCC01E
    #declare Xona_com_Lilac_Bush = rgb <0.596078431372549, 0.454901960784314, 0.827450980392157>; // HEX #9874D3
    #declare Xona_com_Lily = rgb <0.784313725490196, 0.666666666666667, 0.749019607843137>; // HEX #C8AABF
    #declare Xona_com_Lily_White = rgb <0.905882352941176, 0.972549019607843, 1>; // HEX #E7F8FF
    #declare Xona_com_Lima = rgb <0.462745098039216, 0.741176470588235, 0.0901960784313725>; // HEX #76BD17
    #declare Xona_com_Lime = rgb <0.749019607843137, 0.788235294117647, 0.129411764705882>; // HEX #BFC921
    #declare Xona_com_Lime_Green = rgb <0.196078431372549, 0.803921568627451, 0.196078431372549>; // HEX #32CD32
    #declare Xona_com_Limeade = rgb <0.435294117647059, 0.615686274509804, 0.00784313725490196>; // HEX #6F9D02
    #declare Xona_com_Limed_Ash = rgb <0.454901960784314, 0.490196078431373, 0.388235294117647>; // HEX #747D63
    #declare Xona_com_Limed_Gum = rgb <0.258823529411765, 0.223529411764706, 0.129411764705882>; // HEX #423921
    #declare Xona_com_Limed_Oak = rgb <0.674509803921569, 0.541176470588235, 0.337254901960784>; // HEX #AC8A56
    #declare Xona_com_Limed_Spruce = rgb <0.223529411764706, 0.282352941176471, 0.317647058823529>; // HEX #394851
    #declare Xona_com_Limerick = rgb <0.615686274509804, 0.76078431372549, 0.0352941176470588>; // HEX #9DC209
    #declare Xona_com_Linen = rgb <0.901960784313726, 0.894117647058824, 0.831372549019608>; // HEX #E6E4D4
    #declare Xona_com_Linen_Light = rgb <0.980392156862745, 0.941176470588235, 0.901960784313726>; // HEX #FAF0E6
    #declare Xona_com_Link_Water = rgb <0.850980392156863, 0.894117647058824, 0.96078431372549>; // HEX #D9E4F5
    #declare Xona_com_Lipstick = rgb <0.670588235294118, 0.0196078431372549, 0.388235294117647>; // HEX #AB0563
    #declare Xona_com_Lisbon_Brown = rgb <0.258823529411765, 0.223529411764706, 0.129411764705882>; // HEX #423921
    #declare Xona_com_Livid_Brown = rgb <0.301960784313725, 0.156862745098039, 0.180392156862745>; // HEX #4D282E
    #declare Xona_com_Loafer = rgb <0.933333333333333, 0.956862745098039, 0.870588235294118>; // HEX #EEF4DE
    #declare Xona_com_Loblolly = rgb <0.741176470588235, 0.788235294117647, 0.807843137254902>; // HEX #BDC9CE
    #declare Xona_com_Lochinvar = rgb <0.172549019607843, 0.549019607843137, 0.517647058823529>; // HEX #2C8C84
    #declare Xona_com_Lochmara = rgb <0, 0.494117647058824, 0.780392156862745>; // HEX #007EC7
    #declare Xona_com_Locust = rgb <0.658823529411765, 0.686274509803922, 0.556862745098039>; // HEX #A8AF8E
    #declare Xona_com_Log_Cabin = rgb <0.141176470588235, 0.164705882352941, 0.113725490196078>; // HEX #242A1D
    #declare Xona_com_Logan = rgb <0.666666666666667, 0.662745098039216, 0.803921568627451>; // HEX #AAA9CD
    #declare Xona_com_Lola = rgb <0.874509803921569, 0.811764705882353, 0.858823529411765>; // HEX #DFCFDB
    #declare Xona_com_London_Hue = rgb <0.745098039215686, 0.650980392156863, 0.764705882352941>; // HEX #BEA6C3
    #declare Xona_com_Lonestar = rgb <0.427450980392157, 0.00392156862745098, 0.00392156862745098>; // HEX #6D0101
    #declare Xona_com_Lotus = rgb <0.525490196078431, 0.235294117647059, 0.235294117647059>; // HEX #863C3C
    #declare Xona_com_Loulou = rgb <0.274509803921569, 0.0431372549019608, 0.254901960784314>; // HEX #460B41
    #declare Xona_com_Lucky = rgb <0.686274509803922, 0.623529411764706, 0.109803921568627>; // HEX #AF9F1C
    #declare Xona_com_Lucky_Point = rgb <0.101960784313725, 0.101960784313725, 0.407843137254902>; // HEX #1A1A68
    #declare Xona_com_Lunar_Green = rgb <0.235294117647059, 0.286274509803922, 0.227450980392157>; // HEX #3C493A
    #declare Xona_com_Lusty = rgb <0.6, 0.105882352941176, 0.0274509803921569>; // HEX #991B07
    #declare Xona_com_Luxor_Gold = rgb <0.654901960784314, 0.533333333333333, 0.172549019607843>; // HEX #A7882C
    #declare Xona_com_Lynch = rgb <0.411764705882353, 0.494117647058824, 0.603921568627451>; // HEX #697E9A
    #declare Xona_com_Mabel = rgb <0.850980392156863, 0.968627450980392, 1>; // HEX #D9F7FF
    #declare Xona_com_Madang = rgb <0.717647058823529, 0.941176470588235, 0.745098039215686>; // HEX #B7F0BE
    #declare Xona_com_Madder_Lake_Deep = rgb <0.890196078431372, 0.180392156862745, 0.188235294117647>; // HEX #E32E30
    #declare Xona_com_Madison = rgb <0.0352941176470588, 0.145098039215686, 0.364705882352941>; // HEX #09255D
    #declare Xona_com_Madras = rgb <0.247058823529412, 0.188235294117647, 0.00784313725490196>; // HEX #3F3002
    #declare Xona_com_Magenta_2 = rgb <0.933333333333333, 0, 0.933333333333333>; // HEX #EE00EE
    #declare Xona_com_Magenta_3 = rgb <0.803921568627451, 0, 0.803921568627451>; // HEX #CD00CD
    #declare Xona_com_Magenta_4 = rgb <0.545098039215686, 0, 0.545098039215686>; // HEX #8B008B
    #declare Xona_com_Magnolia = rgb <0.972549019607843, 0.956862745098039, 1>; // HEX #F8F4FF
    #declare Xona_com_Mahogany = rgb <0.305882352941176, 0.0235294117647059, 0.0235294117647059>; // HEX #4E0606
    #declare Xona_com_Mai_Tai = rgb <0.690196078431373, 0.4, 0.0313725490196078>; // HEX #B06608
    #declare Xona_com_Maire = rgb <0.0745098039215686, 0.0392156862745098, 0.0235294117647059>; // HEX #130A06
    #declare Xona_com_Maize = rgb <0.96078431372549, 0.835294117647059, 0.627450980392157>; // HEX #F5D5A0
    #declare Xona_com_Makara = rgb <0.537254901960784, 0.490196078431373, 0.427450980392157>; // HEX #897D6D
    #declare Xona_com_Mako = rgb <0.266666666666667, 0.286274509803922, 0.329411764705882>; // HEX #444954
    #declare Xona_com_Malachite_Green = rgb <0.533333333333333, 0.552941176470588, 0.396078431372549>; // HEX #888D65
    #declare Xona_com_Malibu = rgb <0.490196078431373, 0.784313725490196, 0.968627450980392>; // HEX #7DC8F7
    #declare Xona_com_Mallard = rgb <0.137254901960784, 0.203921568627451, 0.0941176470588235>; // HEX #233418
    #declare Xona_com_Malta = rgb <0.741176470588235, 0.698039215686274, 0.631372549019608>; // HEX #BDB2A1
    #declare Xona_com_Mamba = rgb <0.556862745098039, 0.505882352941176, 0.564705882352941>; // HEX #8E8190
    #declare Xona_com_Mandalay = rgb <0.67843137254902, 0.470588235294118, 0.105882352941176>; // HEX #AD781B
    #declare Xona_com_Mandy = rgb <0.886274509803922, 0.329411764705882, 0.396078431372549>; // HEX #E25465
    #declare Xona_com_Mandys_Pink = rgb <0.949019607843137, 0.764705882352941, 0.698039215686274>; // HEX #F2C3B2
    #declare Xona_com_Manganese_Blue = rgb <0.0117647058823529, 0.658823529411765, 0.619607843137255>; // HEX #03A89E
    #declare Xona_com_Manhattan = rgb <0.96078431372549, 0.788235294117647, 0.6>; // HEX #F5C999
    #declare Xona_com_Mantis = rgb <0.454901960784314, 0.764705882352941, 0.396078431372549>; // HEX #74C365
    #declare Xona_com_Mantle = rgb <0.545098039215686, 0.611764705882353, 0.564705882352941>; // HEX #8B9C90
    #declare Xona_com_Manz = rgb <0.933333333333333, 0.937254901960784, 0.470588235294118>; // HEX #EEEF78
    #declare Xona_com_Mardi_Gras = rgb <0.207843137254902, 0, 0.211764705882353>; // HEX #350036
    #declare Xona_com_Marigold = rgb <0.725490196078431, 0.552941176470588, 0.156862745098039>; // HEX #B98D28
    #declare Xona_com_Mariner = rgb <0.156862745098039, 0.415686274509804, 0.803921568627451>; // HEX #286ACD
    #declare Xona_com_Marlin = rgb <0.164705882352941, 0.0784313725490196, 0.0549019607843137>; // HEX #2A140E
    #declare Xona_com_Maroon = rgb <0.690196078431373, 0.188235294117647, 0.376470588235294>; // HEX #B03060
    #declare Xona_com_Maroon_1 = rgb <1, 0.203921568627451, 0.701960784313725>; // HEX #FF34B3
    #declare Xona_com_Maroon_2 = rgb <0.933333333333333, 0.188235294117647, 0.654901960784314>; // HEX #EE30A7
    #declare Xona_com_Maroon_3 = rgb <0.803921568627451, 0.16078431372549, 0.564705882352941>; // HEX #CD2990
    #declare Xona_com_Maroon_4 = rgb <0.545098039215686, 0.109803921568627, 0.384313725490196>; // HEX #8B1C62
    #declare Xona_com_Maroon_Dark = rgb <0.258823529411765, 0.0117647058823529, 0.0117647058823529>; // HEX #420303
    #declare Xona_com_Mars_Orange = rgb <0.588235294117647, 0.270588235294118, 0.0784313725490196>; // HEX #964514
    #declare Xona_com_Mars_Yellow = rgb <0.890196078431372, 0.43921568627451, 0.101960784313725>; // HEX #E3701A
    #declare Xona_com_Marshland = rgb <0.0431372549019608, 0.0588235294117647, 0.0313725490196078>; // HEX #0B0F08
    #declare Xona_com_Martini = rgb <0.686274509803922, 0.627450980392157, 0.619607843137255>; // HEX #AFA09E
    #declare Xona_com_Martinique = rgb <0.211764705882353, 0.188235294117647, 0.313725490196078>; // HEX #363050
    #declare Xona_com_Marzipan = rgb <0.972549019607843, 0.858823529411765, 0.615686274509804>; // HEX #F8DB9D
    #declare Xona_com_Masala = rgb <0.250980392156863, 0.231372549019608, 0.219607843137255>; // HEX #403B38
    #declare Xona_com_Mash = rgb <0.250980392156863, 0.16078431372549, 0.113725490196078>; // HEX #40291D
    #declare Xona_com_Matisse = rgb <0.105882352941176, 0.396078431372549, 0.615686274509804>; // HEX #1B659D
    #declare Xona_com_Matrix = rgb <0.690196078431373, 0.364705882352941, 0.329411764705882>; // HEX #B05D54
    #declare Xona_com_Matterhorn = rgb <0.305882352941176, 0.231372549019608, 0.254901960784314>; // HEX #4E3B41
    #declare Xona_com_Maverick = rgb <0.847058823529412, 0.76078431372549, 0.835294117647059>; // HEX #D8C2D5
    #declare Xona_com_Mc_Kenzie = rgb <0.686274509803922, 0.529411764705882, 0.317647058823529>; // HEX #AF8751
    #declare Xona_com_Medium_Aquamarine = rgb <0.4, 0.803921568627451, 0.666666666666667>; // HEX #66CDAA
    #declare Xona_com_Medium_Blue = rgb <0, 0, 0.803921568627451>; // HEX #0000CD
    #declare Xona_com_Medium_Orchid = rgb <0.729411764705882, 0.333333333333333, 0.827450980392157>; // HEX #BA55D3
    #declare Xona_com_Medium_Orchid_1 = rgb <0.87843137254902, 0.4, 1>; // HEX #E066FF
    #declare Xona_com_Medium_Orchid_2 = rgb <0.819607843137255, 0.372549019607843, 0.933333333333333>; // HEX #D15FEE
    #declare Xona_com_Medium_Orchid_3 = rgb <0.705882352941177, 0.32156862745098, 0.803921568627451>; // HEX #B452CD
    #declare Xona_com_Medium_Orchid_4 = rgb <0.47843137254902, 0.215686274509804, 0.545098039215686>; // HEX #7A378B
    #declare Xona_com_Medium_Purple_1 = rgb <0.670588235294118, 0.509803921568627, 1>; // HEX #AB82FF
    #declare Xona_com_Medium_Purple_2 = rgb <0.623529411764706, 0.474509803921569, 0.933333333333333>; // HEX #9F79EE
    #declare Xona_com_Medium_Purple_3 = rgb <0.537254901960784, 0.407843137254902, 0.803921568627451>; // HEX #8968CD
    #declare Xona_com_Medium_Purple_4 = rgb <0.364705882352941, 0.27843137254902, 0.545098039215686>; // HEX #5D478B
    #declare Xona_com_Medium_Sea_Green = rgb <0.235294117647059, 0.701960784313725, 0.443137254901961>; // HEX #3CB371
    #declare Xona_com_Medium_Slate_Blue = rgb <0.482352941176471, 0.407843137254902, 0.933333333333333>; // HEX #7B68EE
    #declare Xona_com_Medium_Spring_Green = rgb <0, 0.980392156862745, 0.603921568627451>; // HEX #00FA9A
    #declare Xona_com_Medium_Turquoise = rgb <0.282352941176471, 0.819607843137255, 0.8>; // HEX #48D1CC
    #declare Xona_com_Medium_Violet_Red = rgb <0.780392156862745, 0.0823529411764706, 0.52156862745098>; // HEX #C71585
    #declare Xona_com_Melanie = rgb <0.894117647058824, 0.76078431372549, 0.835294117647059>; // HEX #E4C2D5
    #declare Xona_com_Melanzane = rgb <0.188235294117647, 0.0196078431372549, 0.16078431372549>; // HEX #300529
    #declare Xona_com_Melon = rgb <0.890196078431372, 0.658823529411765, 0.411764705882353>; // HEX #E3A869
    #declare Xona_com_Melrose = rgb <0.780392156862745, 0.756862745098039, 1>; // HEX #C7C1FF
    #declare Xona_com_Meranti = rgb <0.364705882352941, 0.117647058823529, 0.0588235294117647>; // HEX #5D1E0F
    #declare Xona_com_Mercury = rgb <0.898039215686275, 0.898039215686275, 0.898039215686275>; // HEX #E5E5E5
    #declare Xona_com_Merino = rgb <0.964705882352941, 0.941176470588235, 0.901960784313726>; // HEX #F6F0E6
    #declare Xona_com_Merlin = rgb <0.254901960784314, 0.235294117647059, 0.215686274509804>; // HEX #413C37
    #declare Xona_com_Merlot = rgb <0.513725490196078, 0.0980392156862745, 0.137254901960784>; // HEX #831923
    #declare Xona_com_Metallic_Bronze = rgb <0.286274509803922, 0.215686274509804, 0.105882352941176>; // HEX #49371B
    #declare Xona_com_Metallic_Copper = rgb <0.443137254901961, 0.16078431372549, 0.113725490196078>; // HEX #71291D
    #declare Xona_com_Meteor = rgb <0.815686274509804, 0.490196078431373, 0.0705882352941176>; // HEX #D07D12
    #declare Xona_com_Meteorite = rgb <0.235294117647059, 0.12156862745098, 0.462745098039216>; // HEX #3C1F76
    #declare Xona_com_Mexican_Red = rgb <0.654901960784314, 0.145098039215686, 0.145098039215686>; // HEX #A72525
    #declare Xona_com_Mid_Gray = rgb <0.372549019607843, 0.372549019607843, 0.431372549019608>; // HEX #5F5F6E
    #declare Xona_com_Midnight = rgb <0.00392156862745098, 0.0862745098039216, 0.207843137254902>; // HEX #011635
    #declare Xona_com_Midnight_Blue = rgb <0.0980392156862745, 0.0980392156862745, 0.43921568627451>; // HEX #191970
    #declare Xona_com_Midnight_Express = rgb <0, 0.0274509803921569, 0.254901960784314>; // HEX #000741
    #declare Xona_com_Midnight_Moss = rgb <0.0156862745098039, 0.0627450980392157, 0.0156862745098039>; // HEX #041004
    #declare Xona_com_Mikado = rgb <0.176470588235294, 0.145098039215686, 0.0627450980392157>; // HEX #2D2510
    #declare Xona_com_Milan = rgb <0.980392156862745, 1, 0.643137254901961>; // HEX #FAFFA4
    #declare Xona_com_Milano_Red = rgb <0.72156862745098, 0.0666666666666667, 0.0156862745098039>; // HEX #B81104
    #declare Xona_com_Milk_Punch = rgb <1, 0.964705882352941, 0.831372549019608>; // HEX #FFF6D4
    #declare Xona_com_Milk_White = rgb <0.964705882352941, 0.941176470588235, 0.901960784313726>; // HEX #F6F0E6
    #declare Xona_com_Millbrook = rgb <0.349019607843137, 0.266666666666667, 0.2>; // HEX #594433
    #declare Xona_com_Mimosa = rgb <0.972549019607843, 0.992156862745098, 0.827450980392157>; // HEX #F8FDD3
    #declare Xona_com_Mindaro = rgb <0.890196078431372, 0.976470588235294, 0.533333333333333>; // HEX #E3F988
    #declare Xona_com_Mine_Shaft = rgb <0.196078431372549, 0.196078431372549, 0.196078431372549>; // HEX #323232
    #declare Xona_com_Mineral_Green = rgb <0.247058823529412, 0.364705882352941, 0.325490196078431>; // HEX #3F5D53
    #declare Xona_com_Ming = rgb <0.211764705882353, 0.454901960784314, 0.490196078431373>; // HEX #36747D
    #declare Xona_com_Minsk = rgb <0.247058823529412, 0.188235294117647, 0.498039215686275>; // HEX #3F307F
    #declare Xona_com_Mint = rgb <0.741176470588235, 0.988235294117647, 0.788235294117647>; // HEX #BDFCC9
    #declare Xona_com_Mint_Cream = rgb <0.96078431372549, 1, 0.980392156862745>; // HEX #F5FFFA
    #declare Xona_com_Mint_Julep = rgb <0.945098039215686, 0.933333333333333, 0.756862745098039>; // HEX #F1EEC1
    #declare Xona_com_Mint_Tulip = rgb <0.768627450980392, 0.956862745098039, 0.92156862745098>; // HEX #C4F4EB
    #declare Xona_com_Mirage = rgb <0.0862745098039216, 0.0980392156862745, 0.156862745098039>; // HEX #161928
    #declare Xona_com_Mischka = rgb <0.819607843137255, 0.823529411764706, 0.866666666666667>; // HEX #D1D2DD
    #declare Xona_com_Mist_Gray = rgb <0.768627450980392, 0.768627450980392, 0.737254901960784>; // HEX #C4C4BC
    #declare Xona_com_Misty_Rose = rgb <1, 0.894117647058824, 0.882352941176471>; // HEX #FFE4E1
    #declare Xona_com_Misty_Rose_1 = rgb <1, 0.894117647058824, 0.882352941176471>; // HEX #FFE4E1
    #declare Xona_com_Misty_Rose_2 = rgb <0.933333333333333, 0.835294117647059, 0.823529411764706>; // HEX #EED5D2
    #declare Xona_com_Misty_Rose_3 = rgb <0.803921568627451, 0.717647058823529, 0.709803921568627>; // HEX #CDB7B5
    #declare Xona_com_Misty_Rose_4 = rgb <0.545098039215686, 0.490196078431373, 0.482352941176471>; // HEX #8B7D7B
    #declare Xona_com_Mobster = rgb <0.498039215686275, 0.458823529411765, 0.537254901960784>; // HEX #7F7589
    #declare Xona_com_Moccaccino = rgb <0.431372549019608, 0.113725490196078, 0.0784313725490196>; // HEX #6E1D14
    #declare Xona_com_Moccasin = rgb <1, 0.894117647058824, 0.709803921568627>; // HEX #FFE4B5
    #declare Xona_com_Mocha = rgb <0.470588235294118, 0.176470588235294, 0.0980392156862745>; // HEX #782D19
    #declare Xona_com_Mojo = rgb <0.752941176470588, 0.27843137254902, 0.215686274509804>; // HEX #C04737
    #declare Xona_com_Mona_Lisa = rgb <1, 0.631372549019608, 0.580392156862745>; // HEX #FFA194
    #declare Xona_com_Monarch = rgb <0.545098039215686, 0.0274509803921569, 0.137254901960784>; // HEX #8B0723
    #declare Xona_com_Mondo = rgb <0.290196078431373, 0.235294117647059, 0.188235294117647>; // HEX #4A3C30
    #declare Xona_com_Mongoose = rgb <0.709803921568627, 0.635294117647059, 0.498039215686275>; // HEX #B5A27F
    #declare Xona_com_Monsoon = rgb <0.541176470588235, 0.513725490196078, 0.537254901960784>; // HEX #8A8389
    #declare Xona_com_Montana = rgb <0.16078431372549, 0.117647058823529, 0.188235294117647>; // HEX #291E30
    #declare Xona_com_Monte_Carlo = rgb <0.513725490196078, 0.815686274509804, 0.776470588235294>; // HEX #83D0C6
    #declare Xona_com_Monza = rgb <0.780392156862745, 0.0117647058823529, 0.117647058823529>; // HEX #C7031E
    #declare Xona_com_Moody_Blue = rgb <0.498039215686275, 0.462745098039216, 0.827450980392157>; // HEX #7F76D3
    #declare Xona_com_Moon_Glow = rgb <0.988235294117647, 0.996078431372549, 0.854901960784314>; // HEX #FCFEDA
    #declare Xona_com_Moon_Mist = rgb <0.862745098039216, 0.866666666666667, 0.8>; // HEX #DCDDCC
    #declare Xona_com_Moon_Raker = rgb <0.83921568627451, 0.807843137254902, 0.964705882352941>; // HEX #D6CEF6
    #declare Xona_com_Moon_Yellow = rgb <0.988235294117647, 0.850980392156863, 0.0901960784313725>; // HEX #FCD917
    #declare Xona_com_Morning_Glory = rgb <0.619607843137255, 0.870588235294118, 0.87843137254902>; // HEX #9EDEE0
    #declare Xona_com_Morocco_Brown = rgb <0.266666666666667, 0.113725490196078, 0>; // HEX #441D00
    #declare Xona_com_Mortar = rgb <0.313725490196078, 0.262745098039216, 0.317647058823529>; // HEX #504351
    #declare Xona_com_Mosaic = rgb <0.0705882352941176, 0.203921568627451, 0.27843137254902>; // HEX #123447
    #declare Xona_com_Mosque = rgb <0.0117647058823529, 0.415686274509804, 0.431372549019608>; // HEX #036A6E
    #declare Xona_com_Mountain_Mist = rgb <0.584313725490196, 0.576470588235294, 0.588235294117647>; // HEX #959396
    #declare Xona_com_Muddy_Waters = rgb <0.717647058823529, 0.556862745098039, 0.36078431372549>; // HEX #B78E5C
    #declare Xona_com_Muesli = rgb <0.666666666666667, 0.545098039215686, 0.356862745098039>; // HEX #AA8B5B
    #declare Xona_com_Mulberry = rgb <0.36078431372549, 0.0196078431372549, 0.211764705882353>; // HEX #5C0536
    #declare Xona_com_Mule_Fawn = rgb <0.549019607843137, 0.27843137254902, 0.184313725490196>; // HEX #8C472F
    #declare Xona_com_Mulled_Wine = rgb <0.305882352941176, 0.270588235294118, 0.384313725490196>; // HEX #4E4562
    #declare Xona_com_Mustard = rgb <0.454901960784314, 0.392156862745098, 0.0509803921568627>; // HEX #74640D
    #declare Xona_com_My_Pink = rgb <0.83921568627451, 0.568627450980392, 0.533333333333333>; // HEX #D69188
    #declare Xona_com_My_Sin = rgb <1, 0.701960784313725, 0.12156862745098>; // HEX #FFB31F
    #declare Xona_com_Mystic = rgb <0.886274509803922, 0.92156862745098, 0.929411764705882>; // HEX #E2EBED
    #declare Xona_com_Nandor = rgb <0.294117647058824, 0.364705882352941, 0.32156862745098>; // HEX #4B5D52
    #declare Xona_com_Napa = rgb <0.674509803921569, 0.643137254901961, 0.580392156862745>; // HEX #ACA494
    #declare Xona_com_Naples_Yellow_Deep = rgb <1, 0.658823529411765, 0.0705882352941176>; // HEX #FFA812
    #declare Xona_com_Narvik = rgb <0.929411764705882, 0.976470588235294, 0.945098039215686>; // HEX #EDF9F1
    #declare Xona_com_Natural = rgb <0.525490196078431, 0.337254901960784, 0.0392156862745098>; // HEX #86560A
    #declare Xona_com_Navajo_White = rgb <1, 0.870588235294118, 0.67843137254902>; // HEX #FFDEAD
    #declare Xona_com_Navajo_White_1 = rgb <1, 0.870588235294118, 0.67843137254902>; // HEX #FFDEAD
    #declare Xona_com_Navajo_White_2 = rgb <0.933333333333333, 0.811764705882353, 0.631372549019608>; // HEX #EECFA1
    #declare Xona_com_Navajo_White_3 = rgb <0.803921568627451, 0.701960784313725, 0.545098039215686>; // HEX #CDB38B
    #declare Xona_com_Navajo_White_4 = rgb <0.545098039215686, 0.474509803921569, 0.368627450980392>; // HEX #8B795E
    #declare Xona_com_Navy = rgb <0, 0, 0.501960784313725>; // HEX #000080
    #declare Xona_com_Navy_Blue = rgb <0, 0, 0.501960784313725>; // HEX #000080
    #declare Xona_com_Nebula = rgb <0.796078431372549, 0.858823529411765, 0.83921568627451>; // HEX #CBDBD6
    #declare Xona_com_Negroni = rgb <1, 0.886274509803922, 0.772549019607843>; // HEX #FFE2C5
    #declare Xona_com_Nepal = rgb <0.556862745098039, 0.670588235294118, 0.756862745098039>; // HEX #8EABC1
    #declare Xona_com_Neptune = rgb <0.486274509803922, 0.717647058823529, 0.733333333333333>; // HEX #7CB7BB
    #declare Xona_com_Nero = rgb <0.0784313725490196, 0.0235294117647059, 0>; // HEX #140600
    #declare Xona_com_Neutral_Green = rgb <0.674509803921569, 0.647058823529412, 0.525490196078431>; // HEX #ACA586
    #declare Xona_com_Nevada = rgb <0.392156862745098, 0.431372549019608, 0.458823529411765>; // HEX #646E75
    #declare Xona_com_New_Amber = rgb <0.482352941176471, 0.219607843137255, 0.00392156862745098>; // HEX #7B3801
    #declare Xona_com_New_Orleans = rgb <0.952941176470588, 0.83921568627451, 0.615686274509804>; // HEX #F3D69D
    #declare Xona_com_New_York_Pink = rgb <0.843137254901961, 0.513725490196078, 0.498039215686275>; // HEX #D7837F
    #declare Xona_com_Niagara = rgb <0.0235294117647059, 0.631372549019608, 0.537254901960784>; // HEX #06A189
    #declare Xona_com_Night_Rider = rgb <0.12156862745098, 0.0705882352941176, 0.0588235294117647>; // HEX #1F120F
    #declare Xona_com_Night_Shadz = rgb <0.666666666666667, 0.215686274509804, 0.352941176470588>; // HEX #AA375A
    #declare Xona_com_Nightclub = rgb <0.4, 0, 0.270588235294118>; // HEX #660045
    #declare Xona_com_Nile_Blue = rgb <0.0980392156862745, 0.215686274509804, 0.317647058823529>; // HEX #193751
    #declare Xona_com_Nobel = rgb <0.717647058823529, 0.694117647058824, 0.694117647058824>; // HEX #B7B1B1
    #declare Xona_com_Nomad = rgb <0.729411764705882, 0.694117647058824, 0.635294117647059>; // HEX #BAB1A2
    #declare Xona_com_Nordic = rgb <0.00392156862745098, 0.152941176470588, 0.192156862745098>; // HEX #012731
    #declare Xona_com_Norway = rgb <0.658823529411765, 0.741176470588235, 0.623529411764706>; // HEX #A8BD9F
    #declare Xona_com_Nugget = rgb <0.772549019607843, 0.6, 0.133333333333333>; // HEX #C59922
    #declare Xona_com_Nutmeg = rgb <0.505882352941176, 0.258823529411765, 0.172549019607843>; // HEX #81422C
    #declare Xona_com_Nutmeg_Wood_Finish = rgb <0.407843137254902, 0.211764705882353, 0>; // HEX #683600
    #declare Xona_com_Oasis = rgb <0.996078431372549, 0.937254901960784, 0.807843137254902>; // HEX #FEEFCE
    #declare Xona_com_Observatory = rgb <0.00784313725490196, 0.525490196078431, 0.435294117647059>; // HEX #02866F
    #declare Xona_com_Ocean_Green = rgb <0.254901960784314, 0.666666666666667, 0.470588235294118>; // HEX #41AA78
    #declare Xona_com_Off_Green = rgb <0.901960784313726, 0.972549019607843, 0.952941176470588>; // HEX #E6F8F3
    #declare Xona_com_Off_Yellow = rgb <0.996078431372549, 0.976470588235294, 0.890196078431372>; // HEX #FEF9E3
    #declare Xona_com_Oil = rgb <0.156862745098039, 0.117647058823529, 0.0823529411764706>; // HEX #281E15
    #declare Xona_com_Oiled_Cedar = rgb <0.486274509803922, 0.109803921568627, 0.0196078431372549>; // HEX #7C1C05
    #declare Xona_com_Old_Brick = rgb <0.564705882352941, 0.117647058823529, 0.117647058823529>; // HEX #901E1E
    #declare Xona_com_Old_Copper = rgb <0.447058823529412, 0.290196078431373, 0.184313725490196>; // HEX #724A2F
    #declare Xona_com_Old_Lace = rgb <0.992156862745098, 0.96078431372549, 0.901960784313726>; // HEX #FDF5E6
    #declare Xona_com_Olive = rgb <0.231372549019608, 0.368627450980392, 0.168627450980392>; // HEX #3B5E2B
    #declare Xona_com_Olive_Drab_1 = rgb <0.752941176470588, 1, 0.243137254901961>; // HEX #C0FF3E
    #declare Xona_com_Olive_Drab_2 = rgb <0.701960784313725, 0.933333333333333, 0.227450980392157>; // HEX #B3EE3A
    #declare Xona_com_Olive_Drab_3 = rgb <0.603921568627451, 0.803921568627451, 0.196078431372549>; // HEX #9ACD32
    #declare Xona_com_Olive_Drab_4 = rgb <0.411764705882353, 0.545098039215686, 0.133333333333333>; // HEX #698B22
    #declare Xona_com_Olive_Green = rgb <0.141176470588235, 0.180392156862745, 0.0862745098039216>; // HEX #242E16
    #declare Xona_com_Olive_Green_Dark = rgb <0.333333333333333, 0.419607843137255, 0.184313725490196>; // HEX #556B2F
    #declare Xona_com_Olive_Haze = rgb <0.545098039215686, 0.517647058823529, 0.43921568627451>; // HEX #8B8470
    #declare Xona_com_Olivetone = rgb <0.443137254901961, 0.431372549019608, 0.0627450980392157>; // HEX #716E10
    #declare Xona_com_Onahau = rgb <0.803921568627451, 0.956862745098039, 1>; // HEX #CDF4FF
    #declare Xona_com_Onion = rgb <0.184313725490196, 0.152941176470588, 0.0549019607843137>; // HEX #2F270E
    #declare Xona_com_Opal = rgb <0.662745098039216, 0.776470588235294, 0.76078431372549>; // HEX #A9C6C2
    #declare Xona_com_Opium = rgb <0.556862745098039, 0.435294117647059, 0.43921568627451>; // HEX #8E6F70
    #declare Xona_com_Oracle = rgb <0.215686274509804, 0.454901960784314, 0.458823529411765>; // HEX #377475
    #declare Xona_com_Orange = rgb <1, 0.647058823529412, 0>; // HEX #FFA500
    #declare Xona_com_Orange_1 = rgb <1, 0.647058823529412, 0>; // HEX #FFA500
    #declare Xona_com_Orange_2 = rgb <0.933333333333333, 0.603921568627451, 0>; // HEX #EE9A00
    #declare Xona_com_Orange_3 = rgb <0.803921568627451, 0.52156862745098, 0>; // HEX #CD8500
    #declare Xona_com_Orange_4 = rgb <0.545098039215686, 0.352941176470588, 0>; // HEX #8B5A00
    #declare Xona_com_Orange_Red = rgb <1, 0.270588235294118, 0>; // HEX #FF4500
    #declare Xona_com_Orange_Red_1 = rgb <1, 0.270588235294118, 0>; // HEX #FF4500
    #declare Xona_com_Orange_Red_2 = rgb <0.933333333333333, 0.250980392156863, 0>; // HEX #EE4000
    #declare Xona_com_Orange_Red_3 = rgb <0.803921568627451, 0.215686274509804, 0>; // HEX #CD3700
    #declare Xona_com_Orange_Red_4 = rgb <0.545098039215686, 0.145098039215686, 0>; // HEX #8B2500
    #declare Xona_com_Orange_Roughy = rgb <0.768627450980392, 0.341176470588235, 0.0980392156862745>; // HEX #C45719
    #declare Xona_com_Orange_White = rgb <0.996078431372549, 0.988235294117647, 0.929411764705882>; // HEX #FEFCED
    #declare Xona_com_Orchid = rgb <0.854901960784314, 0.43921568627451, 0.83921568627451>; // HEX #DA70D6
    #declare Xona_com_Orchid_1 = rgb <1, 0.513725490196078, 0.980392156862745>; // HEX #FF83FA
    #declare Xona_com_Orchid_2 = rgb <0.933333333333333, 0.47843137254902, 0.913725490196078>; // HEX #EE7AE9
    #declare Xona_com_Orchid_3 = rgb <0.803921568627451, 0.411764705882353, 0.788235294117647>; // HEX #CD69C9
    #declare Xona_com_Orchid_4 = rgb <0.545098039215686, 0.27843137254902, 0.537254901960784>; // HEX #8B4789
    #declare Xona_com_Orchid_Medium = rgb <0.729411764705882, 0.333333333333333, 0.827450980392157>; // HEX #BA55D3
    #declare Xona_com_Orchid_White = rgb <1, 0.992156862745098, 0.952941176470588>; // HEX #FFFDF3
    #declare Xona_com_Oregon = rgb <0.607843137254902, 0.27843137254902, 0.0117647058823529>; // HEX #9B4703
    #declare Xona_com_Orient = rgb <0.00392156862745098, 0.368627450980392, 0.52156862745098>; // HEX #015E85
    #declare Xona_com_Oriental_Pink = rgb <0.776470588235294, 0.568627450980392, 0.568627450980392>; // HEX #C69191
    #declare Xona_com_Orinoco = rgb <0.952941176470588, 0.984313725490196, 0.831372549019608>; // HEX #F3FBD4
    #declare Xona_com_Oslo_Gray = rgb <0.529411764705882, 0.552941176470588, 0.568627450980392>; // HEX #878D91
    #declare Xona_com_Ottoman = rgb <0.913725490196078, 0.972549019607843, 0.929411764705882>; // HEX #E9F8ED
    #declare Xona_com_Outer_Space = rgb <0.0196078431372549, 0.0627450980392157, 0.250980392156863>; // HEX #051040
    #declare Xona_com_Oxford_Blue = rgb <0.219607843137255, 0.270588235294118, 0.333333333333333>; // HEX #384555
    #declare Xona_com_Oxley = rgb <0.466666666666667, 0.619607843137255, 0.525490196078431>; // HEX #779E86
    #declare Xona_com_Oyster_Bay = rgb <0.854901960784314, 0.980392156862745, 1>; // HEX #DAFAFF
    #declare Xona_com_Oyster_Pink = rgb <0.913725490196078, 0.807843137254902, 0.803921568627451>; // HEX #E9CECD
    #declare Xona_com_Paarl = rgb <0.650980392156863, 0.333333333333333, 0.16078431372549>; // HEX #A65529
    #declare Xona_com_Pablo = rgb <0.466666666666667, 0.435294117647059, 0.380392156862745>; // HEX #776F61
    #declare Xona_com_Pacifika = rgb <0.466666666666667, 0.505882352941176, 0.125490196078431>; // HEX #778120
    #declare Xona_com_Paco = rgb <0.254901960784314, 0.12156862745098, 0.0627450980392157>; // HEX #411F10
    #declare Xona_com_Padua = rgb <0.67843137254902, 0.901960784313726, 0.768627450980392>; // HEX #ADE6C4
    #declare Xona_com_Pale_Goldenrod = rgb <0.933333333333333, 0.909803921568627, 0.666666666666667>; // HEX #EEE8AA
    #declare Xona_com_Pale_Green = rgb <0.596078431372549, 0.984313725490196, 0.596078431372549>; // HEX #98FB98
    #declare Xona_com_Pale_Green_1 = rgb <0.603921568627451, 1, 0.603921568627451>; // HEX #9AFF9A
    #declare Xona_com_Pale_Green_2 = rgb <0.564705882352941, 0.933333333333333, 0.564705882352941>; // HEX #90EE90
    #declare Xona_com_Pale_Green_3 = rgb <0.486274509803922, 0.803921568627451, 0.486274509803922>; // HEX #7CCD7C
    #declare Xona_com_Pale_Green_4 = rgb <0.329411764705882, 0.545098039215686, 0.329411764705882>; // HEX #548B54
    #declare Xona_com_Pale_Leaf = rgb <0.752941176470588, 0.827450980392157, 0.725490196078431>; // HEX #C0D3B9
    #declare Xona_com_Pale_Oyster = rgb <0.596078431372549, 0.552941176470588, 0.466666666666667>; // HEX #988D77
    #declare Xona_com_Pale_Prim = rgb <0.992156862745098, 0.996078431372549, 0.72156862745098>; // HEX #FDFEB8
    #declare Xona_com_Pale_Rose = rgb <1, 0.882352941176471, 0.949019607843137>; // HEX #FFE1F2
    #declare Xona_com_Pale_Sky = rgb <0.431372549019608, 0.466666666666667, 0.513725490196078>; // HEX #6E7783
    #declare Xona_com_Pale_Slate = rgb <0.764705882352941, 0.749019607843137, 0.756862745098039>; // HEX #C3BFC1
    #declare Xona_com_Pale_Turquoise = rgb <0.686274509803922, 0.933333333333333, 0.933333333333333>; // HEX #AFEEEE
    #declare Xona_com_Pale_Turquoise_1 = rgb <0.733333333333333, 1, 1>; // HEX #BBFFFF
    #declare Xona_com_Pale_Turquoise_2 = rgb <0.682352941176471, 0.933333333333333, 0.933333333333333>; // HEX #AEEEEE
    #declare Xona_com_Pale_Turquoise_3 = rgb <0.588235294117647, 0.803921568627451, 0.803921568627451>; // HEX #96CDCD
    #declare Xona_com_Pale_Turquoise_4 = rgb <0.4, 0.545098039215686, 0.545098039215686>; // HEX #668B8B
    #declare Xona_com_Pale_Violet_Red_1 = rgb <1, 0.509803921568627, 0.670588235294118>; // HEX #FF82AB
    #declare Xona_com_Pale_Violet_Red_2 = rgb <0.933333333333333, 0.474509803921569, 0.623529411764706>; // HEX #EE799F
    #declare Xona_com_Pale_Violet_Red_3 = rgb <0.803921568627451, 0.407843137254902, 0.537254901960784>; // HEX #CD6889
    #declare Xona_com_Pale_Violet_Red_4 = rgb <0.545098039215686, 0.27843137254902, 0.364705882352941>; // HEX #8B475D
    #declare Xona_com_Palm_Green = rgb <0.0352941176470588, 0.137254901960784, 0.0588235294117647>; // HEX #09230F
    #declare Xona_com_Palm_Leaf = rgb <0.0980392156862745, 0.2, 0.0549019607843137>; // HEX #19330E
    #declare Xona_com_Pampas = rgb <0.956862745098039, 0.949019607843137, 0.933333333333333>; // HEX #F4F2EE
    #declare Xona_com_Panache = rgb <0.917647058823529, 0.964705882352941, 0.933333333333333>; // HEX #EAF6EE
    #declare Xona_com_Pancho = rgb <0.929411764705882, 0.803921568627451, 0.670588235294118>; // HEX #EDCDAB
    #declare Xona_com_Panda = rgb <0.258823529411765, 0.223529411764706, 0.129411764705882>; // HEX #423921
    #declare Xona_com_Papaya_Whip = rgb <1, 0.937254901960784, 0.835294117647059>; // HEX #FFEFD5
    #declare Xona_com_Paprika = rgb <0.552941176470588, 0.00784313725490196, 0.149019607843137>; // HEX #8D0226
    #declare Xona_com_Paradiso = rgb <0.192156862745098, 0.490196078431373, 0.509803921568627>; // HEX #317D82
    #declare Xona_com_Parchment = rgb <0.945098039215686, 0.913725490196078, 0.823529411764706>; // HEX #F1E9D2
    #declare Xona_com_Paris_Daisy = rgb <1, 0.956862745098039, 0.431372549019608>; // HEX #FFF46E
    #declare Xona_com_Paris_M = rgb <0.149019607843137, 0.0196078431372549, 0.415686274509804>; // HEX #26056A
    #declare Xona_com_Paris_White = rgb <0.792156862745098, 0.862745098039216, 0.831372549019608>; // HEX #CADCD4
    #declare Xona_com_Parsley = rgb <0.0745098039215686, 0.309803921568627, 0.0980392156862745>; // HEX #134F19
    #declare Xona_com_Patina = rgb <0.388235294117647, 0.603921568627451, 0.56078431372549>; // HEX #639A8F
    #declare Xona_com_Pattens_Blue = rgb <0.870588235294118, 0.96078431372549, 1>; // HEX #DEF5FF
    #declare Xona_com_Paua = rgb <0.149019607843137, 0.0117647058823529, 0.407843137254902>; // HEX #260368
    #declare Xona_com_Pavlova = rgb <0.843137254901961, 0.768627450980392, 0.596078431372549>; // HEX #D7C498
    #declare Xona_com_Pea_Soup = rgb <0.811764705882353, 0.898039215686275, 0.823529411764706>; // HEX #CFE5D2
    #declare Xona_com_Peach = rgb <1, 0.941176470588235, 0.858823529411765>; // HEX #FFF0DB
    #declare Xona_com_Peach_Puff = rgb <1, 0.854901960784314, 0.725490196078431>; // HEX #FFDAB9
    #declare Xona_com_Peach_Puff_1 = rgb <1, 0.854901960784314, 0.725490196078431>; // HEX #FFDAB9
    #declare Xona_com_Peach_Puff_2 = rgb <0.933333333333333, 0.796078431372549, 0.67843137254902>; // HEX #EECBAD
    #declare Xona_com_Peach_Puff_3 = rgb <0.803921568627451, 0.686274509803922, 0.584313725490196>; // HEX #CDAF95
    #declare Xona_com_Peach_Puff_4 = rgb <0.545098039215686, 0.466666666666667, 0.396078431372549>; // HEX #8B7765
    #declare Xona_com_Peach_Schnapps = rgb <1, 0.862745098039216, 0.83921568627451>; // HEX #FFDCD6
    #declare Xona_com_Peacock = rgb <0.2, 0.631372549019608, 0.788235294117647>; // HEX #33A1C9
    #declare Xona_com_Peanut = rgb <0.470588235294118, 0.184313725490196, 0.0862745098039216>; // HEX #782F16
    #declare Xona_com_Pearl_Bush = rgb <0.909803921568627, 0.87843137254902, 0.835294117647059>; // HEX #E8E0D5
    #declare Xona_com_Pearl_Lusta = rgb <0.988235294117647, 0.956862745098039, 0.862745098039216>; // HEX #FCF4DC
    #declare Xona_com_Peat = rgb <0.443137254901961, 0.419607843137255, 0.337254901960784>; // HEX #716B56
    #declare Xona_com_Pelorous = rgb <0.243137254901961, 0.670588235294118, 0.749019607843137>; // HEX #3EABBF
    #declare Xona_com_Peppermint = rgb <0.890196078431372, 0.96078431372549, 0.882352941176471>; // HEX #E3F5E1
    #declare Xona_com_Perano = rgb <0.662745098039216, 0.745098039215686, 0.949019607843137>; // HEX #A9BEF2
    #declare Xona_com_Perfume = rgb <0.815686274509804, 0.745098039215686, 0.972549019607843>; // HEX #D0BEF8
    #declare Xona_com_Periglacial_Blue = rgb <0.882352941176471, 0.901960784313726, 0.83921568627451>; // HEX #E1E6D6
    #declare Xona_com_Permanent_Green = rgb <0.0392156862745098, 0.788235294117647, 0.168627450980392>; // HEX #0AC92B
    #declare Xona_com_Permanent_Red_Violet = rgb <0.858823529411765, 0.149019607843137, 0.270588235294118>; // HEX #DB2645
    #declare Xona_com_Persian_Plum = rgb <0.43921568627451, 0.109803921568627, 0.109803921568627>; // HEX #701C1C
    #declare Xona_com_Persian_Red = rgb <0.32156862745098, 0.0470588235294118, 0.0901960784313725>; // HEX #520C17
    #declare Xona_com_Persimmon = rgb <1, 0.419607843137255, 0.325490196078431>; // HEX #FF6B53
    #declare Xona_com_Peru = rgb <0.803921568627451, 0.52156862745098, 0.247058823529412>; // HEX #CD853F
    #declare Xona_com_Peru_Tan = rgb <0.498039215686275, 0.227450980392157, 0.00784313725490196>; // HEX #7F3A02
    #declare Xona_com_Pesto = rgb <0.486274509803922, 0.462745098039216, 0.192156862745098>; // HEX #7C7631
    #declare Xona_com_Petite_Orchid = rgb <0.858823529411765, 0.588235294117647, 0.564705882352941>; // HEX #DB9690
    #declare Xona_com_Pewter = rgb <0.588235294117647, 0.658823529411765, 0.631372549019608>; // HEX #96A8A1
    #declare Xona_com_Pharlap = rgb <0.63921568627451, 0.501960784313725, 0.482352941176471>; // HEX #A3807B
    #declare Xona_com_Picasso = rgb <1, 0.952941176470588, 0.615686274509804>; // HEX #FFF39D
    #declare Xona_com_Pickled_Aspen = rgb <0.247058823529412, 0.298039215686275, 0.227450980392157>; // HEX #3F4C3A
    #declare Xona_com_Pickled_Bean = rgb <0.431372549019608, 0.282352941176471, 0.149019607843137>; // HEX #6E4826
    #declare Xona_com_Pickled_Bluewood = rgb <0.192156862745098, 0.266666666666667, 0.349019607843137>; // HEX #314459
    #declare Xona_com_Picton_Blue = rgb <0.270588235294118, 0.694117647058824, 0.909803921568627>; // HEX #45B1E8
    #declare Xona_com_Pigeon_Post = rgb <0.686274509803922, 0.741176470588235, 0.850980392156863>; // HEX #AFBDD9
    #declare Xona_com_Pine_Cone = rgb <0.427450980392157, 0.368627450980392, 0.329411764705882>; // HEX #6D5E54
    #declare Xona_com_Pine_Glade = rgb <0.780392156862745, 0.803921568627451, 0.564705882352941>; // HEX #C7CD90
    #declare Xona_com_Pine_Tree = rgb <0.0901960784313725, 0.12156862745098, 0.0156862745098039>; // HEX #171F04
    #declare Xona_com_Pink = rgb <1, 0.752941176470588, 0.796078431372549>; // HEX #FFC0CB
    #declare Xona_com_Pink_1 = rgb <1, 0.709803921568627, 0.772549019607843>; // HEX #FFB5C5
    #declare Xona_com_Pink_2 = rgb <0.933333333333333, 0.662745098039216, 0.72156862745098>; // HEX #EEA9B8
    #declare Xona_com_Pink_3 = rgb <0.803921568627451, 0.568627450980392, 0.619607843137255>; // HEX #CD919E
    #declare Xona_com_Pink_4 = rgb <0.545098039215686, 0.388235294117647, 0.423529411764706>; // HEX #8B636C
    #declare Xona_com_Pink_Flare = rgb <0.882352941176471, 0.752941176470588, 0.784313725490196>; // HEX #E1C0C8
    #declare Xona_com_Pink_Lace = rgb <1, 0.866666666666667, 0.956862745098039>; // HEX #FFDDF4
    #declare Xona_com_Pink_Lady = rgb <1, 0.945098039215686, 0.847058823529412>; // HEX #FFF1D8
    #declare Xona_com_Pink_Light = rgb <1, 0.713725490196078, 0.756862745098039>; // HEX #FFB6C1
    #declare Xona_com_Pink_Swan = rgb <0.745098039215686, 0.709803921568627, 0.717647058823529>; // HEX #BEB5B7
    #declare Xona_com_Piper = rgb <0.788235294117647, 0.388235294117647, 0.137254901960784>; // HEX #C96323
    #declare Xona_com_Pipi = rgb <0.996078431372549, 0.956862745098039, 0.8>; // HEX #FEF4CC
    #declare Xona_com_Pippin = rgb <1, 0.882352941176471, 0.874509803921569>; // HEX #FFE1DF
    #declare Xona_com_Pirate_Gold = rgb <0.729411764705882, 0.498039215686275, 0.0117647058823529>; // HEX #BA7F03
    #declare Xona_com_Pistachio = rgb <0.615686274509804, 0.76078431372549, 0.0352941176470588>; // HEX #9DC209
    #declare Xona_com_Pixie_Green = rgb <0.752941176470588, 0.847058823529412, 0.713725490196078>; // HEX #C0D8B6
    #declare Xona_com_Pizazz = rgb <1, 0.564705882352941, 0>; // HEX #FF9000
    #declare Xona_com_Pizza = rgb <0.788235294117647, 0.580392156862745, 0.0823529411764706>; // HEX #C99415
    #declare Xona_com_Plantation = rgb <0.152941176470588, 0.313725490196078, 0.294117647058824>; // HEX #27504B
    #declare Xona_com_Planter = rgb <0.380392156862745, 0.364705882352941, 0.188235294117647>; // HEX #615D30
    #declare Xona_com_Plum = rgb <0.866666666666667, 0.627450980392157, 0.866666666666667>; // HEX #DDA0DD
    #declare Xona_com_Plum_1 = rgb <1, 0.733333333333333, 1>; // HEX #FFBBFF
    #declare Xona_com_Plum_2 = rgb <0.933333333333333, 0.682352941176471, 0.933333333333333>; // HEX #EEAEEE
    #declare Xona_com_Plum_3 = rgb <0.803921568627451, 0.588235294117647, 0.803921568627451>; // HEX #CD96CD
    #declare Xona_com_Plum_4 = rgb <0.545098039215686, 0.4, 0.545098039215686>; // HEX #8B668B
    #declare Xona_com_Plum_Dark = rgb <0.254901960784314, 0, 0.337254901960784>; // HEX #410056
    #declare Xona_com_Pohutukawa = rgb <0.56078431372549, 0.00784313725490196, 0.109803921568627>; // HEX #8F021C
    #declare Xona_com_Polar = rgb <0.898039215686275, 0.976470588235294, 0.964705882352941>; // HEX #E5F9F6
    #declare Xona_com_Polo_Blue = rgb <0.552941176470588, 0.658823529411765, 0.8>; // HEX #8DA8CC
    #declare Xona_com_Pompadour = rgb <0.4, 0, 0.270588235294118>; // HEX #660045
    #declare Xona_com_Porcelain = rgb <0.937254901960784, 0.949019607843137, 0.952941176470588>; // HEX #EFF2F3
    #declare Xona_com_Porsche = rgb <0.917647058823529, 0.682352941176471, 0.411764705882353>; // HEX #EAAE69
    #declare Xona_com_Port_Gore = rgb <0.145098039215686, 0.12156862745098, 0.309803921568627>; // HEX #251F4F
    #declare Xona_com_Portafino = rgb <1, 1, 0.705882352941177>; // HEX #FFFFB4
    #declare Xona_com_Portage = rgb <0.545098039215686, 0.623529411764706, 0.933333333333333>; // HEX #8B9FEE
    #declare Xona_com_Portica = rgb <0.976470588235294, 0.901960784313726, 0.388235294117647>; // HEX #F9E663
    #declare Xona_com_Pot_Pourri = rgb <0.96078431372549, 0.905882352941176, 0.886274509803922>; // HEX #F5E7E2
    #declare Xona_com_Potters_Clay = rgb <0.549019607843137, 0.341176470588235, 0.219607843137255>; // HEX #8C5738
    #declare Xona_com_Powder_Blue = rgb <0.737254901960784, 0.788235294117647, 0.76078431372549>; // HEX #BCC9C2
    #declare Xona_com_Powder_Blue_Light = rgb <0.690196078431373, 0.87843137254902, 0.901960784313726>; // HEX #B0E0E6
    #declare Xona_com_Prairie_Sand = rgb <0.603921568627451, 0.219607843137255, 0.125490196078431>; // HEX #9A3820
    #declare Xona_com_Prelude = rgb <0.815686274509804, 0.752941176470588, 0.898039215686275>; // HEX #D0C0E5
    #declare Xona_com_Prim = rgb <0.941176470588235, 0.886274509803922, 0.925490196078431>; // HEX #F0E2EC
    #declare Xona_com_Primrose = rgb <0.929411764705882, 0.917647058823529, 0.6>; // HEX #EDEA99
    #declare Xona_com_Promenade = rgb <0.988235294117647, 1, 0.905882352941176>; // HEX #FCFFE7
    #declare Xona_com_Provincial_Pink = rgb <0.996078431372549, 0.96078431372549, 0.945098039215686>; // HEX #FEF5F1
    #declare Xona_com_Prussian_Blue = rgb <0, 0.192156862745098, 0.325490196078431>; // HEX #003153
    #declare Xona_com_Pueblo = rgb <0.490196078431373, 0.172549019607843, 0.0784313725490196>; // HEX #7D2C14
    #declare Xona_com_Puerto_Rico = rgb <0.247058823529412, 0.756862745098039, 0.666666666666667>; // HEX #3FC1AA
    #declare Xona_com_Pumice = rgb <0.76078431372549, 0.792156862745098, 0.768627450980392>; // HEX #C2CAC4
    #declare Xona_com_Pumpkin = rgb <0.694117647058824, 0.380392156862745, 0.0431372549019608>; // HEX #B1610B
    #declare Xona_com_Punch = rgb <0.862745098039216, 0.262745098039216, 0.2>; // HEX #DC4333
    #declare Xona_com_Punga = rgb <0.301960784313725, 0.23921568627451, 0.0784313725490196>; // HEX #4D3D14
    #declare Xona_com_Purple = rgb <0.627450980392157, 0.125490196078431, 0.941176470588235>; // HEX #A020F0
    #declare Xona_com_Purple_1 = rgb <0.607843137254902, 0.188235294117647, 1>; // HEX #9B30FF
    #declare Xona_com_Purple_2 = rgb <0.568627450980392, 0.172549019607843, 0.933333333333333>; // HEX #912CEE
    #declare Xona_com_Purple_3 = rgb <0.490196078431373, 0.149019607843137, 0.803921568627451>; // HEX #7D26CD
    #declare Xona_com_Purple_4 = rgb <0.333333333333333, 0.101960784313725, 0.545098039215686>; // HEX #551A8B
    #declare Xona_com_Putty = rgb <0.905882352941176, 0.803921568627451, 0.549019607843137>; // HEX #E7CD8C
    #declare Xona_com_Quarter_Pearl_Lusta = rgb <1, 0.992156862745098, 0.956862745098039>; // HEX #FFFDF4
    #declare Xona_com_Quarter_Spanish_White = rgb <0.968627450980392, 0.949019607843137, 0.882352941176471>; // HEX #F7F2E1
    #declare Xona_com_Quicksand = rgb <0.741176470588235, 0.592156862745098, 0.556862745098039>; // HEX #BD978E
    #declare Xona_com_Quill_Gray = rgb <0.83921568627451, 0.83921568627451, 0.819607843137255>; // HEX #D6D6D1
    #declare Xona_com_Quincy = rgb <0.384313725490196, 0.247058823529412, 0.176470588235294>; // HEX #623F2D
    #declare Xona_com_Racing_Green = rgb <0.0470588235294118, 0.0980392156862745, 0.0666666666666667>; // HEX #0C1911
    #declare Xona_com_Raffia = rgb <0.917647058823529, 0.854901960784314, 0.72156862745098>; // HEX #EADAB8
    #declare Xona_com_Rain_Forest = rgb <0.466666666666667, 0.505882352941176, 0.125490196078431>; // HEX #778120
    #declare Xona_com_Raincloud = rgb <0.482352941176471, 0.486274509803922, 0.580392156862745>; // HEX #7B7C94
    #declare Xona_com_Rainee = rgb <0.725490196078431, 0.784313725490196, 0.674509803921569>; // HEX #B9C8AC
    #declare Xona_com_Rajah = rgb <0.968627450980392, 0.713725490196078, 0.407843137254902>; // HEX #F7B668
    #declare Xona_com_Rangitoto = rgb <0.180392156862745, 0.196078431372549, 0.133333333333333>; // HEX #2E3222
    #declare Xona_com_Rangoon_Green = rgb <0.109803921568627, 0.117647058823529, 0.0745098039215686>; // HEX #1C1E13
    #declare Xona_com_Raspberry = rgb <0.529411764705882, 0.149019607843137, 0.341176470588235>; // HEX #872657
    #declare Xona_com_Raven = rgb <0.447058823529412, 0.482352941176471, 0.537254901960784>; // HEX #727B89
    #declare Xona_com_Raw_Sienna = rgb <0.780392156862745, 0.380392156862745, 0.0784313725490196>; // HEX #C76114
    #declare Xona_com_Raw_Umber = rgb <0.450980392156863, 0.290196078431373, 0.0705882352941176>; // HEX #734A12
    #declare Xona_com_Rebel = rgb <0.235294117647059, 0.0705882352941176, 0.0235294117647059>; // HEX #3C1206
    #declare Xona_com_Red_2 = rgb <0.933333333333333, 0, 0>; // HEX #EE0000
    #declare Xona_com_Red_3 = rgb <0.803921568627451, 0, 0>; // HEX #CD0000
    #declare Xona_com_Red_4 = rgb <0.545098039215686, 0, 0>; // HEX #8B0000
    #declare Xona_com_Red_Beech = rgb <0.482352941176471, 0.219607843137255, 0.00392156862745098>; // HEX #7B3801
    #declare Xona_com_Red_Berry = rgb <0.556862745098039, 0, 0>; // HEX #8E0000
    #declare Xona_com_Red_Damask = rgb <0.854901960784314, 0.415686274509804, 0.254901960784314>; // HEX #DA6A41
    #declare Xona_com_Red_Devil = rgb <0.525490196078431, 0.00392156862745098, 0.0666666666666667>; // HEX #860111
    #declare Xona_com_Red_Oxide = rgb <0.431372549019608, 0.0352941176470588, 0.00784313725490196>; // HEX #6E0902
    #declare Xona_com_Red_Robin = rgb <0.501960784313725, 0.203921568627451, 0.12156862745098>; // HEX #80341F
    #declare Xona_com_Red_Stage = rgb <0.815686274509804, 0.372549019607843, 0.0156862745098039>; // HEX #D05F04
    #declare Xona_com_Redwood = rgb <0.364705882352941, 0.117647058823529, 0.0588235294117647>; // HEX #5D1E0F
    #declare Xona_com_Reef = rgb <0.788235294117647, 1, 0.635294117647059>; // HEX #C9FFA2
    #declare Xona_com_Reef_Gold = rgb <0.623529411764706, 0.509803921568627, 0.109803921568627>; // HEX #9F821C
    #declare Xona_com_Regal_Blue = rgb <0.00392156862745098, 0.247058823529412, 0.415686274509804>; // HEX #013F6A
    #declare Xona_com_Regent_Gray = rgb <0.525490196078431, 0.580392156862745, 0.623529411764706>; // HEX #86949F
    #declare Xona_com_Regent_St_Blue = rgb <0.666666666666667, 0.83921568627451, 0.901960784313726>; // HEX #AAD6E6
    #declare Xona_com_Remy = rgb <0.996078431372549, 0.92156862745098, 0.952941176470588>; // HEX #FEEBF3
    #declare Xona_com_Reno_Sand = rgb <0.658823529411765, 0.396078431372549, 0.0823529411764706>; // HEX #A86515
    #declare Xona_com_Resolution_Blue = rgb <0, 0.137254901960784, 0.529411764705882>; // HEX #002387
    #declare Xona_com_Revolver = rgb <0.172549019607843, 0.0862745098039216, 0.196078431372549>; // HEX #2C1632
    #declare Xona_com_Rhino = rgb <0.180392156862745, 0.247058823529412, 0.384313725490196>; // HEX #2E3F62
    #declare Xona_com_Ribbon = rgb <0.4, 0, 0.270588235294118>; // HEX #660045
    #declare Xona_com_Rice_Cake = rgb <1, 0.996078431372549, 0.941176470588235>; // HEX #FFFEF0
    #declare Xona_com_Rice_Flower = rgb <0.933333333333333, 1, 0.886274509803922>; // HEX #EEFFE2
    #declare Xona_com_Rich_Gold = rgb <0.658823529411765, 0.325490196078431, 0.0274509803921569>; // HEX #A85307
    #declare Xona_com_Rio_Grande = rgb <0.733333333333333, 0.815686274509804, 0.0352941176470588>; // HEX #BBD009
    #declare Xona_com_Riptide = rgb <0.545098039215686, 0.901960784313726, 0.847058823529412>; // HEX #8BE6D8
    #declare Xona_com_River_Bed = rgb <0.262745098039216, 0.298039215686275, 0.349019607843137>; // HEX #434C59
    #declare Xona_com_Rob_Roy = rgb <0.917647058823529, 0.776470588235294, 0.454901960784314>; // HEX #EAC674
    #declare Xona_com_Robins_Egg_Blue = rgb <0.741176470588235, 0.784313725490196, 0.701960784313725>; // HEX #BDC8B3
    #declare Xona_com_Rock = rgb <0.301960784313725, 0.219607843137255, 0.2>; // HEX #4D3833
    #declare Xona_com_Rock_Blue = rgb <0.619607843137255, 0.694117647058824, 0.803921568627451>; // HEX #9EB1CD
    #declare Xona_com_Rock_Spray = rgb <0.729411764705882, 0.270588235294118, 0.0470588235294118>; // HEX #BA450C
    #declare Xona_com_Rodeo_Dust = rgb <0.788235294117647, 0.698039215686274, 0.607843137254902>; // HEX #C9B29B
    #declare Xona_com_Rolling_Stone = rgb <0.454901960784314, 0.490196078431373, 0.513725490196078>; // HEX #747D83
    #declare Xona_com_Roman = rgb <0.870588235294118, 0.388235294117647, 0.376470588235294>; // HEX #DE6360
    #declare Xona_com_Roman_Coffee = rgb <0.474509803921569, 0.364705882352941, 0.298039215686275>; // HEX #795D4C
    #declare Xona_com_Romance = rgb <1, 0.996078431372549, 0.992156862745098>; // HEX #FFFEFD
    #declare Xona_com_Romantic = rgb <1, 0.823529411764706, 0.717647058823529>; // HEX #FFD2B7
    #declare Xona_com_Ronchi = rgb <0.925490196078431, 0.772549019607843, 0.305882352941176>; // HEX #ECC54E
    #declare Xona_com_Roof_Terracotta = rgb <0.650980392156863, 0.184313725490196, 0.125490196078431>; // HEX #A62F20
    #declare Xona_com_Rope = rgb <0.556862745098039, 0.301960784313725, 0.117647058823529>; // HEX #8E4D1E
    #declare Xona_com_Rose = rgb <0.905882352941176, 0.737254901960784, 0.705882352941177>; // HEX #E7BCB4
    #declare Xona_com_Rose_Bud = rgb <0.984313725490196, 0.698039215686274, 0.63921568627451>; // HEX #FBB2A3
    #declare Xona_com_Rose_Bud_Cherry = rgb <0.501960784313725, 0.0431372549019608, 0.27843137254902>; // HEX #800B47
    #declare Xona_com_Rose_Madder = rgb <0.890196078431372, 0.211764705882353, 0.219607843137255>; // HEX #E33638
    #declare Xona_com_Rose_Of_Sharon = rgb <0.749019607843137, 0.333333333333333, 0>; // HEX #BF5500
    #declare Xona_com_Rose_White = rgb <1, 0.964705882352941, 0.96078431372549>; // HEX #FFF6F5
    #declare Xona_com_Rosewood = rgb <0.396078431372549, 0, 0.0431372549019608>; // HEX #65000B
    #declare Xona_com_Rosy_Brown_1 = rgb <1, 0.756862745098039, 0.756862745098039>; // HEX #FFC1C1
    #declare Xona_com_Rosy_Brown_2 = rgb <0.933333333333333, 0.705882352941177, 0.705882352941177>; // HEX #EEB4B4
    #declare Xona_com_Rosy_Brown_3 = rgb <0.803921568627451, 0.607843137254902, 0.607843137254902>; // HEX #CD9B9B
    #declare Xona_com_Rosy_Brown_4 = rgb <0.545098039215686, 0.411764705882353, 0.411764705882353>; // HEX #8B6969
    #declare Xona_com_Roti = rgb <0.776470588235294, 0.658823529411765, 0.294117647058824>; // HEX #C6A84B
    #declare Xona_com_Rouge = rgb <0.635294117647059, 0.231372549019608, 0.423529411764706>; // HEX #A23B6C
    #declare Xona_com_Royal_Blue = rgb <0.254901960784314, 0.411764705882353, 0.882352941176471>; // HEX #4169E1
    #declare Xona_com_Royal_Blue_1 = rgb <0.282352941176471, 0.462745098039216, 1>; // HEX #4876FF
    #declare Xona_com_Royal_Blue_2 = rgb <0.262745098039216, 0.431372549019608, 0.933333333333333>; // HEX #436EEE
    #declare Xona_com_Royal_Blue_3 = rgb <0.227450980392157, 0.372549019607843, 0.803921568627451>; // HEX #3A5FCD
    #declare Xona_com_Royal_Blue_4 = rgb <0.152941176470588, 0.250980392156863, 0.545098039215686>; // HEX #27408B
    #declare Xona_com_Royal_Heath = rgb <0.670588235294118, 0.203921568627451, 0.447058823529412>; // HEX #AB3472
    #declare Xona_com_Rum = rgb <0.474509803921569, 0.411764705882353, 0.537254901960784>; // HEX #796989
    #declare Xona_com_Rum_Swizzle = rgb <0.976470588235294, 0.972549019607843, 0.894117647058824>; // HEX #F9F8E4
    #declare Xona_com_Russett = rgb <0.458823529411765, 0.352941176470588, 0.341176470588235>; // HEX #755A57
    #declare Xona_com_Rustic_Red = rgb <0.282352941176471, 0.0156862745098039, 0.0156862745098039>; // HEX #480404
    #declare Xona_com_Rusty_Nail = rgb <0.525490196078431, 0.337254901960784, 0.0392156862745098>; // HEX #86560A
    #declare Xona_com_Saddle = rgb <0.298039215686275, 0.188235294117647, 0.141176470588235>; // HEX #4C3024
    #declare Xona_com_Saddle_Brown = rgb <0.545098039215686, 0.270588235294118, 0.0745098039215686>; // HEX #8B4513
    #declare Xona_com_Saddle_Brown_Dark = rgb <0.345098039215686, 0.203921568627451, 0.00392156862745098>; // HEX #583401
    #declare Xona_com_Saffron = rgb <0.976470588235294, 0.749019607843137, 0.345098039215686>; // HEX #F9BF58
    #declare Xona_com_Sage = rgb <0.619607843137255, 0.647058823529412, 0.529411764705882>; // HEX #9EA587
    #declare Xona_com_Sahara = rgb <0.717647058823529, 0.635294117647059, 0.0784313725490196>; // HEX #B7A214
    #declare Xona_com_Sail = rgb <0.72156862745098, 0.87843137254902, 0.976470588235294>; // HEX #B8E0F9
    #declare Xona_com_Salem = rgb <0.0352941176470588, 0.498039215686275, 0.294117647058824>; // HEX #097F4B
    #declare Xona_com_Salmon = rgb <0.980392156862745, 0.501960784313725, 0.447058823529412>; // HEX #FA8072
    #declare Xona_com_Salmon_1 = rgb <1, 0.549019607843137, 0.411764705882353>; // HEX #FF8C69
    #declare Xona_com_Salmon_2 = rgb <0.933333333333333, 0.509803921568627, 0.384313725490196>; // HEX #EE8262
    #declare Xona_com_Salmon_3 = rgb <0.803921568627451, 0.43921568627451, 0.329411764705882>; // HEX #CD7054
    #declare Xona_com_Salmon_4 = rgb <0.545098039215686, 0.298039215686275, 0.223529411764706>; // HEX #8B4C39
    #declare Xona_com_Salomie = rgb <0.996078431372549, 0.858823529411765, 0.552941176470588>; // HEX #FEDB8D
    #declare Xona_com_Salt_Box = rgb <0.407843137254902, 0.368627450980392, 0.431372549019608>; // HEX #685E6E
    #declare Xona_com_Saltpan = rgb <0.945098039215686, 0.968627450980392, 0.949019607843137>; // HEX #F1F7F2
    #declare Xona_com_Sambuca = rgb <0.227450980392157, 0.125490196078431, 0.0627450980392157>; // HEX #3A2010
    #declare Xona_com_San_Felix = rgb <0.0431372549019608, 0.384313725490196, 0.0274509803921569>; // HEX #0B6207
    #declare Xona_com_San_Juan = rgb <0.188235294117647, 0.294117647058824, 0.415686274509804>; // HEX #304B6A
    #declare Xona_com_San_Marino = rgb <0.270588235294118, 0.423529411764706, 0.674509803921569>; // HEX #456CAC
    #declare Xona_com_Sand_Dune = rgb <0.509803921568627, 0.435294117647059, 0.396078431372549>; // HEX #826F65
    #declare Xona_com_Sandal = rgb <0.666666666666667, 0.552941176470588, 0.435294117647059>; // HEX #AA8D6F
    #declare Xona_com_Sandrift = rgb <0.670588235294118, 0.568627450980392, 0.47843137254902>; // HEX #AB917A
    #declare Xona_com_Sandstone = rgb <0.474509803921569, 0.427450980392157, 0.384313725490196>; // HEX #796D62
    #declare Xona_com_Sandwisp = rgb <0.96078431372549, 0.905882352941176, 0.635294117647059>; // HEX #F5E7A2
    #declare Xona_com_Sandy_Beach = rgb <1, 0.917647058823529, 0.784313725490196>; // HEX #FFEAC8
    #declare Xona_com_Sandy_Brown = rgb <0.956862745098039, 0.643137254901961, 0.376470588235294>; // HEX #F4A460
    #declare Xona_com_Sangria = rgb <0.572549019607843, 0, 0.0392156862745098>; // HEX #92000A
    #declare Xona_com_Sanguine_Brown = rgb <0.552941176470588, 0.23921568627451, 0.219607843137255>; // HEX #8D3D38
    #declare Xona_com_Santa_Fe = rgb <0.694117647058824, 0.427450980392157, 0.32156862745098>; // HEX #B16D52
    #declare Xona_com_Santas_Gray = rgb <0.623529411764706, 0.627450980392157, 0.694117647058824>; // HEX #9FA0B1
    #declare Xona_com_Sap_Green = rgb <0.188235294117647, 0.501960784313725, 0.0784313725490196>; // HEX #308014
    #declare Xona_com_Sapling = rgb <0.870588235294118, 0.831372549019608, 0.643137254901961>; // HEX #DED4A4
    #declare Xona_com_Sapphire = rgb <0.184313725490196, 0.317647058823529, 0.619607843137255>; // HEX #2F519E
    #declare Xona_com_Saratoga = rgb <0.333333333333333, 0.356862745098039, 0.0627450980392157>; // HEX #555B10
    #declare Xona_com_Sauvignon = rgb <1, 0.96078431372549, 0.952941176470588>; // HEX #FFF5F3
    #declare Xona_com_Sazerac = rgb <1, 0.956862745098039, 0.87843137254902>; // HEX #FFF4E0
    #declare Xona_com_Scampi = rgb <0.403921568627451, 0.372549019607843, 0.650980392156863>; // HEX #675FA6
    #declare Xona_com_Scandal = rgb <0.811764705882353, 0.980392156862745, 0.956862745098039>; // HEX #CFFAF4
    #declare Xona_com_Scarlet_Gum = rgb <0.262745098039216, 0.0823529411764706, 0.376470588235294>; // HEX #431560
    #declare Xona_com_Scarlett = rgb <0.584313725490196, 0, 0.0823529411764706>; // HEX #950015
    #declare Xona_com_Scarpa_Flow = rgb <0.345098039215686, 0.333333333333333, 0.384313725490196>; // HEX #585562
    #declare Xona_com_Schist = rgb <0.662745098039216, 0.705882352941177, 0.592156862745098>; // HEX #A9B497
    #declare Xona_com_Schooner = rgb <0.545098039215686, 0.517647058823529, 0.494117647058824>; // HEX #8B847E
    #declare Xona_com_Scooter = rgb <0.180392156862745, 0.749019607843137, 0.831372549019608>; // HEX #2EBFD4
    #declare Xona_com_Scorpion = rgb <0.411764705882353, 0.372549019607843, 0.384313725490196>; // HEX #695F62
    #declare Xona_com_Scotch_Mist = rgb <1, 0.984313725490196, 0.862745098039216>; // HEX #FFFBDC
    #declare Xona_com_Scrub = rgb <0.180392156862745, 0.196078431372549, 0.133333333333333>; // HEX #2E3222
    #declare Xona_com_Sea_Buckthorn = rgb <0.984313725490196, 0.631372549019608, 0.16078431372549>; // HEX #FBA129
    #declare Xona_com_Sea_Fog = rgb <0.988235294117647, 1, 0.976470588235294>; // HEX #FCFFF9
    #declare Xona_com_Sea_Green_1 = rgb <0.329411764705882, 1, 0.623529411764706>; // HEX #54FF9F
    #declare Xona_com_Sea_Green_2 = rgb <0.305882352941176, 0.933333333333333, 0.580392156862745>; // HEX #4EEE94
    #declare Xona_com_Sea_Green_3 = rgb <0.262745098039216, 0.803921568627451, 0.501960784313725>; // HEX #43CD80
    #declare Xona_com_Sea_Green_4 = rgb <0.180392156862745, 0.545098039215686, 0.341176470588235>; // HEX #2E8B57
    #declare Xona_com_Sea_Green_Black = rgb <0.0352941176470588, 0.345098039215686, 0.349019607843137>; // HEX #095859
    #declare Xona_com_Sea_Green_Dark = rgb <0.180392156862745, 0.545098039215686, 0.341176470588235>; // HEX #2E8B57
    #declare Xona_com_Sea_Green_Light = rgb <0.125490196078431, 0.698039215686274, 0.666666666666667>; // HEX #20B2AA
    #declare Xona_com_Sea_Green_Medium = rgb <0.235294117647059, 0.701960784313725, 0.443137254901961>; // HEX #3CB371
    #declare Xona_com_Sea_Mist = rgb <0.772549019607843, 0.858823529411765, 0.792156862745098>; // HEX #C5DBCA
    #declare Xona_com_Sea_Nymph = rgb <0.470588235294118, 0.63921568627451, 0.611764705882353>; // HEX #78A39C
    #declare Xona_com_Sea_Pink = rgb <0.929411764705882, 0.596078431372549, 0.619607843137255>; // HEX #ED989E
    #declare Xona_com_Seagull = rgb <0.501960784313725, 0.8, 0.917647058823529>; // HEX #80CCEA
    #declare Xona_com_Seance = rgb <0.450980392156863, 0.117647058823529, 0.56078431372549>; // HEX #731E8F
    #declare Xona_com_Seashell = rgb <1, 0.96078431372549, 0.933333333333333>; // HEX #FFF5EE
    #declare Xona_com_Seashell_1 = rgb <1, 0.96078431372549, 0.933333333333333>; // HEX #FFF5EE
    #declare Xona_com_Seashell_2 = rgb <0.933333333333333, 0.898039215686275, 0.870588235294118>; // HEX #EEE5DE
    #declare Xona_com_Seashell_3 = rgb <0.803921568627451, 0.772549019607843, 0.749019607843137>; // HEX #CDC5BF
    #declare Xona_com_Seashell_4 = rgb <0.545098039215686, 0.525490196078431, 0.509803921568627>; // HEX #8B8682
    #declare Xona_com_Seashell_Medium = rgb <0.945098039215686, 0.945098039215686, 0.945098039215686>; // HEX #F1F1F1
    #declare Xona_com_Seaweed = rgb <0.105882352941176, 0.184313725490196, 0.0666666666666667>; // HEX #1B2F11
    #declare Xona_com_Selago = rgb <0.941176470588235, 0.933333333333333, 0.992156862745098>; // HEX #F0EEFD
    #declare Xona_com_Sepia = rgb <0.368627450980392, 0.149019607843137, 0.0705882352941176>; // HEX #5E2612
    #declare Xona_com_Sepia_Dark = rgb <0.168627450980392, 0.00784313725490196, 0.00784313725490196>; // HEX #2B0202
    #declare Xona_com_Serenade = rgb <1, 0.956862745098039, 0.909803921568627>; // HEX #FFF4E8
    #declare Xona_com_Shadow_Green = rgb <0.603921568627451, 0.76078431372549, 0.72156862745098>; // HEX #9AC2B8
    #declare Xona_com_Shady_Lady = rgb <0.666666666666667, 0.647058823529412, 0.662745098039216>; // HEX #AAA5A9
    #declare Xona_com_Shakespeare = rgb <0.305882352941176, 0.670588235294118, 0.819607843137255>; // HEX #4EABD1
    #declare Xona_com_Shalimar = rgb <0.984313725490196, 1, 0.729411764705882>; // HEX #FBFFBA
    #declare Xona_com_Shark = rgb <0.145098039215686, 0.152941176470588, 0.172549019607843>; // HEX #25272C
    #declare Xona_com_Sherpa_Blue = rgb <0, 0.286274509803922, 0.313725490196078>; // HEX #004950
    #declare Xona_com_Sherwood_Green = rgb <0.00784313725490196, 0.250980392156863, 0.172549019607843>; // HEX #02402C
    #declare Xona_com_Shilo = rgb <0.909803921568627, 0.725490196078431, 0.701960784313725>; // HEX #E8B9B3
    #declare Xona_com_Shingle_Fawn = rgb <0.419607843137255, 0.305882352941176, 0.192156862745098>; // HEX #6B4E31
    #declare Xona_com_Ship_Cove = rgb <0.470588235294118, 0.545098039215686, 0.729411764705882>; // HEX #788BBA
    #declare Xona_com_Ship_Gray = rgb <0.243137254901961, 0.227450980392157, 0.266666666666667>; // HEX #3E3A44
    #declare Xona_com_Shiraz = rgb <0.698039215686274, 0.0352941176470588, 0.192156862745098>; // HEX #B20931
    #declare Xona_com_Shocking = rgb <0.886274509803922, 0.572549019607843, 0.752941176470588>; // HEX #E292C0
    #declare Xona_com_Shuttle_Gray = rgb <0.372549019607843, 0.4, 0.447058823529412>; // HEX #5F6672
    #declare Xona_com_Siam = rgb <0.392156862745098, 0.415686274509804, 0.329411764705882>; // HEX #646A54
    #declare Xona_com_Sidecar = rgb <0.952941176470588, 0.905882352941176, 0.733333333333333>; // HEX #F3E7BB
    #declare Xona_com_Sienna = rgb <0.627450980392157, 0.32156862745098, 0.176470588235294>; // HEX #A0522D
    #declare Xona_com_Sienna_1 = rgb <1, 0.509803921568627, 0.27843137254902>; // HEX #FF8247
    #declare Xona_com_Sienna_2 = rgb <0.933333333333333, 0.474509803921569, 0.258823529411765>; // HEX #EE7942
    #declare Xona_com_Sienna_3 = rgb <0.803921568627451, 0.407843137254902, 0.223529411764706>; // HEX #CD6839
    #declare Xona_com_Sienna_4 = rgb <0.545098039215686, 0.27843137254902, 0.149019607843137>; // HEX #8B4726
    #declare Xona_com_Silk = rgb <0.741176470588235, 0.694117647058824, 0.658823529411765>; // HEX #BDB1A8
    #declare Xona_com_Silver_Chalice = rgb <0.674509803921569, 0.674509803921569, 0.674509803921569>; // HEX #ACACAC
    #declare Xona_com_Silver_Sand = rgb <0.749019607843137, 0.756862745098039, 0.76078431372549>; // HEX #BFC1C2
    #declare Xona_com_Silver_Tree = rgb <0.4, 0.709803921568627, 0.56078431372549>; // HEX #66B58F
    #declare Xona_com_Sinbad = rgb <0.623529411764706, 0.843137254901961, 0.827450980392157>; // HEX #9FD7D3
    #declare Xona_com_Siren = rgb <0.47843137254902, 0.00392156862745098, 0.227450980392157>; // HEX #7A013A
    #declare Xona_com_Sirocco = rgb <0.443137254901961, 0.501960784313725, 0.501960784313725>; // HEX #718080
    #declare Xona_com_Sisal = rgb <0.827450980392157, 0.796078431372549, 0.729411764705882>; // HEX #D3CBBA
    #declare Xona_com_Skeptic = rgb <0.792156862745098, 0.901960784313726, 0.854901960784314>; // HEX #CAE6DA
    #declare Xona_com_Sky_Blue = rgb <0.529411764705882, 0.807843137254902, 0.92156862745098>; // HEX #87CEEB
    #declare Xona_com_Sky_Blue_1 = rgb <0.529411764705882, 0.807843137254902, 1>; // HEX #87CEFF
    #declare Xona_com_Sky_Blue_2 = rgb <0.494117647058824, 0.752941176470588, 0.933333333333333>; // HEX #7EC0EE
    #declare Xona_com_Sky_Blue_3 = rgb <0.423529411764706, 0.650980392156863, 0.803921568627451>; // HEX #6CA6CD
    #declare Xona_com_Sky_Blue_4 = rgb <0.290196078431373, 0.43921568627451, 0.545098039215686>; // HEX #4A708B
    #declare Xona_com_Sky_Blue_Deep = rgb <0, 0.749019607843137, 1>; // HEX #00BFFF
    #declare Xona_com_Sky_Blue_Light = rgb <0.529411764705882, 0.807843137254902, 0.980392156862745>; // HEX #87CEFA
    #declare Xona_com_Slate_Blue = rgb <0.415686274509804, 0.352941176470588, 0.803921568627451>; // HEX #6A5ACD
    #declare Xona_com_Slate_Blue_1 = rgb <0.513725490196078, 0.435294117647059, 1>; // HEX #836FFF
    #declare Xona_com_Slate_Blue_2 = rgb <0.47843137254902, 0.403921568627451, 0.933333333333333>; // HEX #7A67EE
    #declare Xona_com_Slate_Blue_3 = rgb <0.411764705882353, 0.349019607843137, 0.803921568627451>; // HEX #6959CD
    #declare Xona_com_Slate_Blue_4 = rgb <0.27843137254902, 0.235294117647059, 0.545098039215686>; // HEX #473C8B
    #declare Xona_com_Slate_Blue_Dark = rgb <0.282352941176471, 0.23921568627451, 0.545098039215686>; // HEX #483D8B
    #declare Xona_com_Slate_Blue_Light = rgb <0.517647058823529, 0.43921568627451, 1>; // HEX #8470FF
    #declare Xona_com_Slate_Blue_Medium = rgb <0.482352941176471, 0.407843137254902, 0.933333333333333>; // HEX #7B68EE
    #declare Xona_com_Slate_Gray = rgb <0.43921568627451, 0.501960784313725, 0.564705882352941>; // HEX #708090
    #declare Xona_com_Slate_Gray_1 = rgb <0.776470588235294, 0.886274509803922, 1>; // HEX #C6E2FF
    #declare Xona_com_Slate_Gray_2 = rgb <0.725490196078431, 0.827450980392157, 0.933333333333333>; // HEX #B9D3EE
    #declare Xona_com_Slate_Gray_3 = rgb <0.623529411764706, 0.713725490196078, 0.803921568627451>; // HEX #9FB6CD
    #declare Xona_com_Slate_Gray_4 = rgb <0.423529411764706, 0.482352941176471, 0.545098039215686>; // HEX #6C7B8B
    #declare Xona_com_Slate_Gray_Light = rgb <0.466666666666667, 0.533333333333333, 0.6>; // HEX #778899
    #declare Xona_com_Slugger = rgb <0.254901960784314, 0.125490196078431, 0.0627450980392157>; // HEX #412010
    #declare Xona_com_Smalt_Blue = rgb <0.317647058823529, 0.501960784313725, 0.56078431372549>; // HEX #51808F
    #declare Xona_com_Smoke_Tree = rgb <0.854901960784314, 0.388235294117647, 0.0156862745098039>; // HEX #DA6304
    #declare Xona_com_Smokey_Ash = rgb <0.254901960784314, 0.235294117647059, 0.215686274509804>; // HEX #413C37
    #declare Xona_com_Smoky = rgb <0.376470588235294, 0.356862745098039, 0.450980392156863>; // HEX #605B73
    #declare Xona_com_Snow = rgb <1, 0.980392156862745, 0.980392156862745>; // HEX #FFFAFA
    #declare Xona_com_Snow_1 = rgb <1, 0.980392156862745, 0.980392156862745>; // HEX #FFFAFA
    #declare Xona_com_Snow_2 = rgb <0.933333333333333, 0.913725490196078, 0.913725490196078>; // HEX #EEE9E9
    #declare Xona_com_Snow_3 = rgb <0.803921568627451, 0.788235294117647, 0.788235294117647>; // HEX #CDC9C9
    #declare Xona_com_Snow_4 = rgb <0.545098039215686, 0.537254901960784, 0.537254901960784>; // HEX #8B8989
    #declare Xona_com_Snow_Drift = rgb <0.968627450980392, 0.980392156862745, 0.968627450980392>; // HEX #F7FAF7
    #declare Xona_com_Snow_Flurry = rgb <0.894117647058824, 1, 0.819607843137255>; // HEX #E4FFD1
    #declare Xona_com_Snowy_Mint = rgb <0.83921568627451, 1, 0.858823529411765>; // HEX #D6FFDB
    #declare Xona_com_Snuff = rgb <0.886274509803922, 0.847058823529412, 0.929411764705882>; // HEX #E2D8ED
    #declare Xona_com_Soapstone = rgb <1, 0.984313725490196, 0.976470588235294>; // HEX #FFFBF9
    #declare Xona_com_Soft_Amber = rgb <0.819607843137255, 0.776470588235294, 0.705882352941177>; // HEX #D1C6B4
    #declare Xona_com_Soft_Peach = rgb <0.96078431372549, 0.929411764705882, 0.937254901960784>; // HEX #F5EDEF
    #declare Xona_com_Solid_Pink = rgb <0.537254901960784, 0.219607843137255, 0.262745098039216>; // HEX #893843
    #declare Xona_com_Solitaire = rgb <0.996078431372549, 0.972549019607843, 0.886274509803922>; // HEX #FEF8E2
    #declare Xona_com_Solitude = rgb <0.917647058823529, 0.964705882352941, 1>; // HEX #EAF6FF
    #declare Xona_com_Sorbus = rgb <0.992156862745098, 0.486274509803922, 0.0274509803921569>; // HEX #FD7C07
    #declare Xona_com_Sorrell_Brown = rgb <0.807843137254902, 0.725490196078431, 0.56078431372549>; // HEX #CEB98F
    #declare Xona_com_Sour_Dough = rgb <0.819607843137255, 0.745098039215686, 0.658823529411765>; // HEX #D1BEA8
    #declare Xona_com_Soya_Bean = rgb <0.415686274509804, 0.376470588235294, 0.317647058823529>; // HEX #6A6051
    #declare Xona_com_Space_Shuttle = rgb <0.262745098039216, 0.192156862745098, 0.125490196078431>; // HEX #433120
    #declare Xona_com_Spanish_Green = rgb <0.505882352941176, 0.596078431372549, 0.52156862745098>; // HEX #819885
    #declare Xona_com_Spanish_White = rgb <0.956862745098039, 0.92156862745098, 0.827450980392157>; // HEX #F4EBD3
    #declare Xona_com_Spectra = rgb <0.184313725490196, 0.352941176470588, 0.341176470588235>; // HEX #2F5A57
    #declare Xona_com_Spice = rgb <0.415686274509804, 0.266666666666667, 0.180392156862745>; // HEX #6A442E
    #declare Xona_com_Spicy_Mix = rgb <0.533333333333333, 0.325490196078431, 0.258823529411765>; // HEX #885342
    #declare Xona_com_Spicy_Pink = rgb <0.505882352941176, 0.431372549019608, 0.443137254901961>; // HEX #816E71
    #declare Xona_com_Spindle = rgb <0.713725490196078, 0.819607843137255, 0.917647058823529>; // HEX #B6D1EA
    #declare Xona_com_Splash = rgb <1, 0.937254901960784, 0.756862745098039>; // HEX #FFEFC1
    #declare Xona_com_Spray = rgb <0.474509803921569, 0.870588235294118, 0.925490196078431>; // HEX #79DEEC
    #declare Xona_com_Spring_Green = rgb <0, 0.980392156862745, 0.603921568627451>; // HEX #00FA9A
    #declare Xona_com_Spring_Green_2 = rgb <0, 0.933333333333333, 0.462745098039216>; // HEX #00EE76
    #declare Xona_com_Spring_Green_3 = rgb <0, 0.803921568627451, 0.4>; // HEX #00CD66
    #declare Xona_com_Spring_Green_4 = rgb <0, 0.545098039215686, 0.270588235294118>; // HEX #008B45
    #declare Xona_com_Spring_Green_Dark = rgb <0.341176470588235, 0.513725490196078, 0.388235294117647>; // HEX #578363
    #declare Xona_com_Spring_Rain = rgb <0.674509803921569, 0.796078431372549, 0.694117647058824>; // HEX #ACCBB1
    #declare Xona_com_Spring_Sun = rgb <0.964705882352941, 1, 0.862745098039216>; // HEX #F6FFDC
    #declare Xona_com_Spring_Wood = rgb <0.972549019607843, 0.964705882352941, 0.945098039215686>; // HEX #F8F6F1
    #declare Xona_com_Sprout = rgb <0.756862745098039, 0.843137254901961, 0.690196078431373>; // HEX #C1D7B0
    #declare Xona_com_Spun_Pearl = rgb <0.666666666666667, 0.670588235294118, 0.717647058823529>; // HEX #AAABB7
    #declare Xona_com_Squirrel = rgb <0.56078431372549, 0.505882352941176, 0.462745098039216>; // HEX #8F8176
    #declare Xona_com_St_Tropaz = rgb <0.176470588235294, 0.337254901960784, 0.607843137254902>; // HEX #2D569B
    #declare Xona_com_Stack = rgb <0.541176470588235, 0.56078431372549, 0.541176470588235>; // HEX #8A8F8A
    #declare Xona_com_Star_Dust = rgb <0.623529411764706, 0.623529411764706, 0.611764705882353>; // HEX #9F9F9C
    #declare Xona_com_Stark_White = rgb <0.898039215686275, 0.843137254901961, 0.741176470588235>; // HEX #E5D7BD
    #declare Xona_com_Starship = rgb <0.925490196078431, 0.949019607843137, 0.270588235294118>; // HEX #ECF245
    #declare Xona_com_Steel_Blue = rgb <0.274509803921569, 0.509803921568627, 0.705882352941177>; // HEX #4682B4
    #declare Xona_com_Steel_Blue_1 = rgb <0.388235294117647, 0.72156862745098, 1>; // HEX #63B8FF
    #declare Xona_com_Steel_Blue_2 = rgb <0.36078431372549, 0.674509803921569, 0.933333333333333>; // HEX #5CACEE
    #declare Xona_com_Steel_Blue_3 = rgb <0.309803921568627, 0.580392156862745, 0.803921568627451>; // HEX #4F94CD
    #declare Xona_com_Steel_Blue_4 = rgb <0.211764705882353, 0.392156862745098, 0.545098039215686>; // HEX #36648B
    #declare Xona_com_Steel_Blue_Light = rgb <0.690196078431373, 0.768627450980392, 0.870588235294118>; // HEX #B0C4DE
    #declare Xona_com_Steel_Gray = rgb <0.149019607843137, 0.137254901960784, 0.207843137254902>; // HEX #262335
    #declare Xona_com_Stiletto = rgb <0.611764705882353, 0.2, 0.211764705882353>; // HEX #9C3336
    #declare Xona_com_Stinger = rgb <0.545098039215686, 0.419607843137255, 0.0431372549019608>; // HEX #8B6B0B
    #declare Xona_com_Stonewall = rgb <0.572549019607843, 0.52156862745098, 0.450980392156863>; // HEX #928573
    #declare Xona_com_Storm_Dust = rgb <0.392156862745098, 0.392156862745098, 0.388235294117647>; // HEX #646463
    #declare Xona_com_Storm_Gray = rgb <0.443137254901961, 0.454901960784314, 0.525490196078431>; // HEX #717486
    #declare Xona_com_Stratos = rgb <0, 0.0274509803921569, 0.254901960784314>; // HEX #000741
    #declare Xona_com_Straw = rgb <0.831372549019608, 0.749019607843137, 0.552941176470588>; // HEX #D4BF8D
    #declare Xona_com_Strikemaster = rgb <0.584313725490196, 0.388235294117647, 0.529411764705882>; // HEX #956387
    #declare Xona_com_Stromboli = rgb <0.196078431372549, 0.364705882352941, 0.32156862745098>; // HEX #325D52
    #declare Xona_com_Studio = rgb <0.443137254901961, 0.290196078431373, 0.698039215686274>; // HEX #714AB2
    #declare Xona_com_Submarine = rgb <0.729411764705882, 0.780392156862745, 0.788235294117647>; // HEX #BAC7C9
    #declare Xona_com_Sugar_Cane = rgb <0.976470588235294, 1, 0.964705882352941>; // HEX #F9FFF6
    #declare Xona_com_Sulu = rgb <0.756862745098039, 0.941176470588235, 0.486274509803922>; // HEX #C1F07C
    #declare Xona_com_Summer_Green = rgb <0.588235294117647, 0.733333333333333, 0.670588235294118>; // HEX #96BBAB
    #declare Xona_com_Sun = rgb <0.984313725490196, 0.674509803921569, 0.0745098039215686>; // HEX #FBAC13
    #declare Xona_com_Sundance = rgb <0.788235294117647, 0.701960784313725, 0.356862745098039>; // HEX #C9B35B
    #declare Xona_com_Sundown = rgb <1, 0.694117647058824, 0.701960784313725>; // HEX #FFB1B3
    #declare Xona_com_Sunflower = rgb <0.894117647058824, 0.831372549019608, 0.133333333333333>; // HEX #E4D422
    #declare Xona_com_Sunglo = rgb <0.882352941176471, 0.407843137254902, 0.396078431372549>; // HEX #E16865
    #declare Xona_com_Sunset = rgb <0.862745098039216, 0.262745098039216, 0.2>; // HEX #DC4333
    #declare Xona_com_Sunshade = rgb <1, 0.619607843137255, 0.172549019607843>; // HEX #FF9E2C
    #declare Xona_com_Supernova = rgb <1, 0.788235294117647, 0.00392156862745098>; // HEX #FFC901
    #declare Xona_com_Surf = rgb <0.733333333333333, 0.843137254901961, 0.756862745098039>; // HEX #BBD7C1
    #declare Xona_com_Surf_Crest = rgb <0.811764705882353, 0.898039215686275, 0.823529411764706>; // HEX #CFE5D2
    #declare Xona_com_Surfie_Green = rgb <0.0470588235294118, 0.47843137254902, 0.474509803921569>; // HEX #0C7A79
    #declare Xona_com_Sushi = rgb <0.529411764705882, 0.670588235294118, 0.223529411764706>; // HEX #87AB39
    #declare Xona_com_Suva_Gray = rgb <0.533333333333333, 0.513725490196078, 0.529411764705882>; // HEX #888387
    #declare Xona_com_Swamp = rgb <0, 0.105882352941176, 0.109803921568627>; // HEX #001B1C
    #declare Xona_com_Swans_Down = rgb <0.862745098039216, 0.941176470588235, 0.917647058823529>; // HEX #DCF0EA
    #declare Xona_com_Sweet_Corn = rgb <0.984313725490196, 0.917647058823529, 0.549019607843137>; // HEX #FBEA8C
    #declare Xona_com_Sweet_Pink = rgb <0.992156862745098, 0.623529411764706, 0.635294117647059>; // HEX #FD9FA2
    #declare Xona_com_Swirl = rgb <0.827450980392157, 0.803921568627451, 0.772549019607843>; // HEX #D3CDC5
    #declare Xona_com_Swiss_Coffee = rgb <0.866666666666667, 0.83921568627451, 0.835294117647059>; // HEX #DDD6D5
    #declare Xona_com_Sycamore = rgb <0.564705882352941, 0.552941176470588, 0.223529411764706>; // HEX #908D39
    #declare Xona_com_Tabasco = rgb <0.627450980392157, 0.152941176470588, 0.0705882352941176>; // HEX #A02712
    #declare Xona_com_Tacao = rgb <0.929411764705882, 0.701960784313725, 0.505882352941176>; // HEX #EDB381
    #declare Xona_com_Tacha = rgb <0.83921568627451, 0.772549019607843, 0.384313725490196>; // HEX #D6C562
    #declare Xona_com_Tahiti_Gold = rgb <0.913725490196078, 0.486274509803922, 0.0274509803921569>; // HEX #E97C07
    #declare Xona_com_Tahuna_Sands = rgb <0.933333333333333, 0.941176470588235, 0.784313725490196>; // HEX #EEF0C8
    #declare Xona_com_Tall_Poppy = rgb <0.701960784313725, 0.176470588235294, 0.16078431372549>; // HEX #B32D29
    #declare Xona_com_Tallow = rgb <0.658823529411765, 0.647058823529412, 0.537254901960784>; // HEX #A8A589
    #declare Xona_com_Tamarillo = rgb <0.6, 0.0862745098039216, 0.0745098039215686>; // HEX #991613
    #declare Xona_com_Tamarind = rgb <0.203921568627451, 0.0823529411764706, 0.0823529411764706>; // HEX #341515
    #declare Xona_com_Tan = rgb <0.823529411764706, 0.705882352941177, 0.549019607843137>; // HEX #D2B48C
    #declare Xona_com_Tan_1 = rgb <1, 0.647058823529412, 0.309803921568627>; // HEX #FFA54F
    #declare Xona_com_Tan_2 = rgb <0.933333333333333, 0.603921568627451, 0.286274509803922>; // HEX #EE9A49
    #declare Xona_com_Tan_3 = rgb <0.803921568627451, 0.52156862745098, 0.247058823529412>; // HEX #CD853F
    #declare Xona_com_Tan_4 = rgb <0.545098039215686, 0.352941176470588, 0.168627450980392>; // HEX #8B5A2B
    #declare Xona_com_Tana = rgb <0.850980392156863, 0.862745098039216, 0.756862745098039>; // HEX #D9DCC1
    #declare Xona_com_Tangaroa = rgb <0.0117647058823529, 0.0862745098039216, 0.235294117647059>; // HEX #03163C
    #declare Xona_com_Tangerine = rgb <0.913725490196078, 0.431372549019608, 0>; // HEX #E96E00
    #declare Xona_com_Tango = rgb <0.929411764705882, 0.47843137254902, 0.109803921568627>; // HEX #ED7A1C
    #declare Xona_com_Tapa = rgb <0.482352941176471, 0.470588235294118, 0.454901960784314>; // HEX #7B7874
    #declare Xona_com_Tapestry = rgb <0.690196078431373, 0.368627450980392, 0.505882352941176>; // HEX #B05E81
    #declare Xona_com_Tara = rgb <0.882352941176471, 0.964705882352941, 0.909803921568627>; // HEX #E1F6E8
    #declare Xona_com_Tarawera = rgb <0.0274509803921569, 0.227450980392157, 0.313725490196078>; // HEX #073A50
    #declare Xona_com_Tasman = rgb <0.811764705882353, 0.862745098039216, 0.811764705882353>; // HEX #CFDCCF
    #declare Xona_com_Taupe_Gray = rgb <0.701960784313725, 0.686274509803922, 0.584313725490196>; // HEX #B3AF95
    #declare Xona_com_Tawny_Port = rgb <0.411764705882353, 0.145098039215686, 0.270588235294118>; // HEX #692545
    #declare Xona_com_Tax_Break = rgb <0.317647058823529, 0.501960784313725, 0.56078431372549>; // HEX #51808F
    #declare Xona_com_Te_Papa_Green = rgb <0.117647058823529, 0.262745098039216, 0.235294117647059>; // HEX #1E433C
    #declare Xona_com_Tea = rgb <0.756862745098039, 0.729411764705882, 0.690196078431373>; // HEX #C1BAB0
    #declare Xona_com_Teak = rgb <0.694117647058824, 0.580392156862745, 0.380392156862745>; // HEX #B19461
    #declare Xona_com_Teak_Wood_Finish = rgb <0.419607843137255, 0.164705882352941, 0.0784313725490196>; // HEX #6B2A14
    #declare Xona_com_Teal_Blue = rgb <0.0156862745098039, 0.258823529411765, 0.349019607843137>; // HEX #044259
    #declare Xona_com_Temptress = rgb <0.231372549019608, 0, 0.0431372549019608>; // HEX #3B000B
    #declare Xona_com_Tequila = rgb <1, 0.901960784313726, 0.780392156862745>; // HEX #FFE6C7
    #declare Xona_com_Terre_Verte = rgb <0.219607843137255, 0.368627450980392, 0.0588235294117647>; // HEX #385E0F
    #declare Xona_com_Texas = rgb <0.972549019607843, 0.976470588235294, 0.611764705882353>; // HEX #F8F99C
    #declare Xona_com_Texas_Rose = rgb <1, 0.709803921568627, 0.333333333333333>; // HEX #FFB555
    #declare Xona_com_Thatch = rgb <0.713725490196078, 0.615686274509804, 0.596078431372549>; // HEX #B69D98
    #declare Xona_com_Thatch_Green = rgb <0.250980392156863, 0.23921568627451, 0.0980392156862745>; // HEX #403D19
    #declare Xona_com_Thistle = rgb <0.8, 0.792156862745098, 0.658823529411765>; // HEX #CCCAA8
    #declare Xona_com_Thistle_1 = rgb <1, 0.882352941176471, 1>; // HEX #FFE1FF
    #declare Xona_com_Thistle_2 = rgb <0.933333333333333, 0.823529411764706, 0.933333333333333>; // HEX #EED2EE
    #declare Xona_com_Thistle_3 = rgb <0.803921568627451, 0.709803921568627, 0.803921568627451>; // HEX #CDB5CD
    #declare Xona_com_Thistle_4 = rgb <0.545098039215686, 0.482352941176471, 0.545098039215686>; // HEX #8B7B8B
    #declare Xona_com_Thunder = rgb <0.2, 0.16078431372549, 0.184313725490196>; // HEX #33292F
    #declare Xona_com_Thunderbird = rgb <0.752941176470588, 0.168627450980392, 0.0941176470588235>; // HEX #C02B18
    #declare Xona_com_Tia_Maria = rgb <0.756862745098039, 0.266666666666667, 0.0549019607843137>; // HEX #C1440E
    #declare Xona_com_Tiara = rgb <0.764705882352941, 0.819607843137255, 0.819607843137255>; // HEX #C3D1D1
    #declare Xona_com_Tiber = rgb <0.0235294117647059, 0.207843137254902, 0.215686274509804>; // HEX #063537
    #declare Xona_com_Tidal = rgb <0.945098039215686, 1, 0.67843137254902>; // HEX #F1FFAD
    #declare Xona_com_Tide = rgb <0.749019607843137, 0.72156862745098, 0.690196078431373>; // HEX #BFB8B0
    #declare Xona_com_Timber_Green = rgb <0.0862745098039216, 0.196078431372549, 0.172549019607843>; // HEX #16322C
    #declare Xona_com_Titan_White = rgb <0.941176470588235, 0.933333333333333, 1>; // HEX #F0EEFF
    #declare Xona_com_Titanium_White = rgb <0.988235294117647, 1, 0.941176470588235>; // HEX #FCFFF0
    #declare Xona_com_Toast = rgb <0.603921568627451, 0.431372549019608, 0.380392156862745>; // HEX #9A6E61
    #declare Xona_com_Tobacco_Brown = rgb <0.443137254901961, 0.364705882352941, 0.27843137254902>; // HEX #715D47
    #declare Xona_com_Tobago = rgb <0.243137254901961, 0.168627450980392, 0.137254901960784>; // HEX #3E2B23
    #declare Xona_com_Toledo = rgb <0.227450980392157, 0, 0.125490196078431>; // HEX #3A0020
    #declare Xona_com_Tolopea = rgb <0.105882352941176, 0.00784313725490196, 0.270588235294118>; // HEX #1B0245
    #declare Xona_com_Tom_Thumb = rgb <0.247058823529412, 0.345098039215686, 0.231372549019608>; // HEX #3F583B
    #declare Xona_com_Tomato = rgb <1, 0.388235294117647, 0.27843137254902>; // HEX #FF6347
    #declare Xona_com_Tomato_1 = rgb <1, 0.388235294117647, 0.27843137254902>; // HEX #FF6347
    #declare Xona_com_Tomato_2 = rgb <0.933333333333333, 0.36078431372549, 0.258823529411765>; // HEX #EE5C42
    #declare Xona_com_Tomato_3 = rgb <0.803921568627451, 0.309803921568627, 0.223529411764706>; // HEX #CD4F39
    #declare Xona_com_Tomato_4 = rgb <0.545098039215686, 0.211764705882353, 0.149019607843137>; // HEX #8B3626
    #declare Xona_com_Tonys_Pink = rgb <0.905882352941176, 0.623529411764706, 0.549019607843137>; // HEX #E79F8C
    #declare Xona_com_Topaz = rgb <0.486274509803922, 0.466666666666667, 0.541176470588235>; // HEX #7C778A
    #declare Xona_com_Torea_Bay = rgb <0.0588235294117647, 0.176470588235294, 0.619607843137255>; // HEX #0F2D9E
    #declare Xona_com_Tory_Blue = rgb <0.0784313725490196, 0.313725490196078, 0.666666666666667>; // HEX #1450AA
    #declare Xona_com_Tosca = rgb <0.552941176470588, 0.247058823529412, 0.247058823529412>; // HEX #8D3F3F
    #declare Xona_com_Totem_Pole = rgb <0.6, 0.105882352941176, 0.0274509803921569>; // HEX #991B07
    #declare Xona_com_Touch_Wood = rgb <0.215686274509804, 0.188235294117647, 0.129411764705882>; // HEX #373021
    #declare Xona_com_Tower_Gray = rgb <0.662745098039216, 0.741176470588235, 0.749019607843137>; // HEX #A9BDBF
    #declare Xona_com_Tradewind = rgb <0.372549019607843, 0.701960784313725, 0.674509803921569>; // HEX #5FB3AC
    #declare Xona_com_Tranquil = rgb <0.901960784313726, 1, 1>; // HEX #E6FFFF
    #declare Xona_com_Travertine = rgb <1, 0.992156862745098, 0.909803921568627>; // HEX #FFFDE8
    #declare Xona_com_Tree_Poppy = rgb <0.988235294117647, 0.611764705882353, 0.113725490196078>; // HEX #FC9C1D
    #declare Xona_com_Treehouse = rgb <0.231372549019608, 0.156862745098039, 0.125490196078431>; // HEX #3B2820
    #declare Xona_com_Trendy_Green = rgb <0.486274509803922, 0.533333333333333, 0.101960784313725>; // HEX #7C881A
    #declare Xona_com_Trendy_Pink = rgb <0.549019607843137, 0.392156862745098, 0.584313725490196>; // HEX #8C6495
    #declare Xona_com_Trinidad = rgb <0.901960784313726, 0.305882352941176, 0.0117647058823529>; // HEX #E64E03
    #declare Xona_com_Tropical_Blue = rgb <0.764705882352941, 0.866666666666667, 0.976470588235294>; // HEX #C3DDF9
    #declare Xona_com_Trout = rgb <0.290196078431373, 0.305882352941176, 0.352941176470588>; // HEX #4A4E5A
    #declare Xona_com_True_V = rgb <0.541176470588235, 0.450980392156863, 0.83921568627451>; // HEX #8A73D6
    #declare Xona_com_Tuatara = rgb <0.211764705882353, 0.207843137254902, 0.203921568627451>; // HEX #363534
    #declare Xona_com_Tuft_Bush = rgb <1, 0.866666666666667, 0.803921568627451>; // HEX #FFDDCD
    #declare Xona_com_Tulip_Tree = rgb <0.917647058823529, 0.701960784313725, 0.231372549019608>; // HEX #EAB33B
    #declare Xona_com_Tumbleweed = rgb <0.215686274509804, 0.16078431372549, 0.0549019607843137>; // HEX #37290E
    #declare Xona_com_Tuna = rgb <0.207843137254902, 0.207843137254902, 0.258823529411765>; // HEX #353542
    #declare Xona_com_Tundora = rgb <0.290196078431373, 0.258823529411765, 0.266666666666667>; // HEX #4A4244
    #declare Xona_com_Turbo = rgb <0.980392156862745, 0.901960784313726, 0>; // HEX #FAE600
    #declare Xona_com_Turkish_Rose = rgb <0.709803921568627, 0.447058823529412, 0.505882352941176>; // HEX #B57281
    #declare Xona_com_Turmeric = rgb <0.792156862745098, 0.733333333333333, 0.282352941176471>; // HEX #CABB48
    #declare Xona_com_Turquoise = rgb <0.250980392156863, 0.87843137254902, 0.815686274509804>; // HEX #40E0D0
    #declare Xona_com_Turquoise_1 = rgb <0, 0.96078431372549, 1>; // HEX #00F5FF
    #declare Xona_com_Turquoise_2 = rgb <0, 0.898039215686275, 0.933333333333333>; // HEX #00E5EE
    #declare Xona_com_Turquoise_3 = rgb <0, 0.772549019607843, 0.803921568627451>; // HEX #00C5CD
    #declare Xona_com_Turquoise_4 = rgb <0, 0.525490196078431, 0.545098039215686>; // HEX #00868B
    #declare Xona_com_Turquoise_Blue = rgb <0, 0.780392156862745, 0.549019607843137>; // HEX #00C78C
    #declare Xona_com_Turquoise_Dark = rgb <0, 0.807843137254902, 0.819607843137255>; // HEX #00CED1
    #declare Xona_com_Turquoise_Medium = rgb <0.282352941176471, 0.819607843137255, 0.8>; // HEX #48D1CC
    #declare Xona_com_Turquoise_Pale = rgb <0.686274509803922, 0.933333333333333, 0.933333333333333>; // HEX #AFEEEE
    #declare Xona_com_Turtle_Green = rgb <0.164705882352941, 0.219607843137255, 0.0431372549019608>; // HEX #2A380B
    #declare Xona_com_Tuscany = rgb <0.741176470588235, 0.368627450980392, 0.180392156862745>; // HEX #BD5E2E
    #declare Xona_com_Tusk = rgb <0.933333333333333, 0.952941176470588, 0.764705882352941>; // HEX #EEF3C3
    #declare Xona_com_Tussock = rgb <0.772549019607843, 0.6, 0.294117647058824>; // HEX #C5994B
    #declare Xona_com_Tutu = rgb <1, 0.945098039215686, 0.976470588235294>; // HEX #FFF1F9
    #declare Xona_com_Twilight = rgb <0.894117647058824, 0.811764705882353, 0.870588235294118>; // HEX #E4CFDE
    #declare Xona_com_Twilight_Blue = rgb <0.933333333333333, 0.992156862745098, 1>; // HEX #EEFDFF
    #declare Xona_com_Twine = rgb <0.76078431372549, 0.584313725490196, 0.364705882352941>; // HEX #C2955D
    #declare Xona_com_Ultramarine = rgb <0.0705882352941176, 0.0392156862745098, 0.56078431372549>; // HEX #120A8F
    #declare Xona_com_Ultramarine_Violet = rgb <0.36078431372549, 0.141176470588235, 0.431372549019608>; // HEX #5C246E
    #declare Xona_com_Valencia = rgb <0.847058823529412, 0.266666666666667, 0.215686274509804>; // HEX #D84437
    #declare Xona_com_Valentino = rgb <0.207843137254902, 0.0549019607843137, 0.258823529411765>; // HEX #350E42
    #declare Xona_com_Valhalla = rgb <0.168627450980392, 0.0980392156862745, 0.309803921568627>; // HEX #2B194F
    #declare Xona_com_Van_Cleef = rgb <0.286274509803922, 0.0901960784313725, 0.0470588235294118>; // HEX #49170C
    #declare Xona_com_Van_Dyke_Brown = rgb <0.368627450980392, 0.149019607843137, 0.0196078431372549>; // HEX #5E2605
    #declare Xona_com_Vanilla = rgb <0.819607843137255, 0.745098039215686, 0.658823529411765>; // HEX #D1BEA8
    #declare Xona_com_Vanilla_Ice = rgb <0.952941176470588, 0.850980392156863, 0.874509803921569>; // HEX #F3D9DF
    #declare Xona_com_Varden = rgb <1, 0.964705882352941, 0.874509803921569>; // HEX #FFF6DF
    #declare Xona_com_Venetian_Red = rgb <0.831372549019608, 0.101960784313725, 0.12156862745098>; // HEX #D41A1F
    #declare Xona_com_Venetian_Red_Dark = rgb <0.447058823529412, 0.00392156862745098, 0.0588235294117647>; // HEX #72010F
    #declare Xona_com_Venice_Blue = rgb <0.0196078431372549, 0.349019607843137, 0.537254901960784>; // HEX #055989
    #declare Xona_com_Venus = rgb <0.572549019607843, 0.52156862745098, 0.564705882352941>; // HEX #928590
    #declare Xona_com_Verdigris = rgb <0.364705882352941, 0.368627450980392, 0.215686274509804>; // HEX #5D5E37
    #declare Xona_com_Verdun_Green = rgb <0.286274509803922, 0.329411764705882, 0>; // HEX #495400
    #declare Xona_com_Vesuvius = rgb <0.694117647058824, 0.290196078431373, 0.0431372549019608>; // HEX #B14A0B
    #declare Xona_com_Victoria = rgb <0.325490196078431, 0.266666666666667, 0.568627450980392>; // HEX #534491
    #declare Xona_com_Vida_Loca = rgb <0.329411764705882, 0.564705882352941, 0.0980392156862745>; // HEX #549019
    #declare Xona_com_Viking = rgb <0.392156862745098, 0.8, 0.858823529411765>; // HEX #64CCDB
    #declare Xona_com_Vin_Rouge = rgb <0.596078431372549, 0.23921568627451, 0.380392156862745>; // HEX #983D61
    #declare Xona_com_Viola = rgb <0.796078431372549, 0.56078431372549, 0.662745098039216>; // HEX #CB8FA9
    #declare Xona_com_Violent_Violet = rgb <0.16078431372549, 0.0470588235294118, 0.368627450980392>; // HEX #290C5E
    #declare Xona_com_Violet = rgb <0.56078431372549, 0.368627450980392, 0.6>; // HEX #8F5E99
    #declare Xona_com_Violet_Dark = rgb <0.580392156862745, 0, 0.827450980392157>; // HEX #9400D3
    #declare Xona_com_Violet_Dark_2 = rgb <0.141176470588235, 0.0392156862745098, 0.250980392156863>; // HEX #240A40
    #declare Xona_com_Violet_Light = rgb <0.933333333333333, 0.509803921568627, 0.933333333333333>; // HEX #EE82EE
    #declare Xona_com_Violet_Red = rgb <0.815686274509804, 0.125490196078431, 0.564705882352941>; // HEX #D02090
    #declare Xona_com_Violet_Red_1 = rgb <1, 0.243137254901961, 0.588235294117647>; // HEX #FF3E96
    #declare Xona_com_Violet_Red_2 = rgb <0.933333333333333, 0.227450980392157, 0.549019607843137>; // HEX #EE3A8C
    #declare Xona_com_Violet_Red_3 = rgb <0.803921568627451, 0.196078431372549, 0.470588235294118>; // HEX #CD3278
    #declare Xona_com_Violet_Red_4 = rgb <0.545098039215686, 0.133333333333333, 0.32156862745098>; // HEX #8B2252
    #declare Xona_com_Violet_Red_Medium = rgb <0.780392156862745, 0.0823529411764706, 0.52156862745098>; // HEX #C71585
    #declare Xona_com_Viridian_Green = rgb <0.403921568627451, 0.537254901960784, 0.458823529411765>; // HEX #678975
    #declare Xona_com_Viridian_Light = rgb <0.431372549019608, 1, 0.43921568627451>; // HEX #6EFF70
    #declare Xona_com_Vis_Vis = rgb <1, 0.937254901960784, 0.631372549019608>; // HEX #FFEFA1
    #declare Xona_com_Vista_Blue = rgb <0.56078431372549, 0.83921568627451, 0.705882352941177>; // HEX #8FD6B4
    #declare Xona_com_Vista_White = rgb <0.988235294117647, 0.972549019607843, 0.968627450980392>; // HEX #FCF8F7
    #declare Xona_com_Volcano = rgb <0.396078431372549, 0.101960784313725, 0.0784313725490196>; // HEX #651A14
    #declare Xona_com_Voodoo = rgb <0.325490196078431, 0.203921568627451, 0.333333333333333>; // HEX #533455
    #declare Xona_com_Vulcan = rgb <0.0627450980392157, 0.0705882352941176, 0.113725490196078>; // HEX #10121D
    #declare Xona_com_Wafer = rgb <0.870588235294118, 0.796078431372549, 0.776470588235294>; // HEX #DECBC6
    #declare Xona_com_Waikawa_Gray = rgb <0.352941176470588, 0.431372549019608, 0.611764705882353>; // HEX #5A6E9C
    #declare Xona_com_Waiouru = rgb <0.211764705882353, 0.235294117647059, 0.0509803921568627>; // HEX #363C0D
    #declare Xona_com_Walnut = rgb <0.466666666666667, 0.247058823529412, 0.101960784313725>; // HEX #773F1A
    #declare Xona_com_Wan_White = rgb <0.988235294117647, 1, 0.976470588235294>; // HEX #FCFFF9
    #declare Xona_com_Warm_Gray = rgb <0.501960784313725, 0.501960784313725, 0.411764705882353>; // HEX #808069
    #declare Xona_com_Wasabi = rgb <0.470588235294118, 0.541176470588235, 0.145098039215686>; // HEX #788A25
    #declare Xona_com_Water_Leaf = rgb <0.631372549019608, 0.913725490196078, 0.870588235294118>; // HEX #A1E9DE
    #declare Xona_com_Watercourse = rgb <0.0196078431372549, 0.435294117647059, 0.341176470588235>; // HEX #056F57
    #declare Xona_com_Waterloo = rgb <0.482352941176471, 0.486274509803922, 0.580392156862745>; // HEX #7B7C94
    #declare Xona_com_Wattle = rgb <0.862745098039216, 0.843137254901961, 0.27843137254902>; // HEX #DCD747
    #declare Xona_com_Watusi = rgb <1, 0.866666666666667, 0.811764705882353>; // HEX #FFDDCF
    #declare Xona_com_Wax_Flower = rgb <1, 0.752941176470588, 0.658823529411765>; // HEX #FFC0A8
    #declare Xona_com_We_Peep = rgb <0.968627450980392, 0.858823529411765, 0.901960784313726>; // HEX #F7DBE6
    #declare Xona_com_Wedgewood = rgb <0.305882352941176, 0.498039215686275, 0.619607843137255>; // HEX #4E7F9E
    #declare Xona_com_Well_Read = rgb <0.705882352941177, 0.2, 0.196078431372549>; // HEX #B43332
    #declare Xona_com_West_Coast = rgb <0.384313725490196, 0.317647058823529, 0.0980392156862745>; // HEX #625119
    #declare Xona_com_West_Side = rgb <1, 0.568627450980392, 0.0588235294117647>; // HEX #FF910F
    #declare Xona_com_Westar = rgb <0.862745098039216, 0.850980392156863, 0.823529411764706>; // HEX #DCD9D2
    #declare Xona_com_Western_Red = rgb <0.545098039215686, 0.0274509803921569, 0.137254901960784>; // HEX #8B0723
    #declare Xona_com_Wewak = rgb <0.945098039215686, 0.607843137254902, 0.670588235294118>; // HEX #F19BAB
    #declare Xona_com_Wheat = rgb <0.96078431372549, 0.870588235294118, 0.701960784313725>; // HEX #F5DEB3
    #declare Xona_com_Wheat_1 = rgb <1, 0.905882352941176, 0.729411764705882>; // HEX #FFE7BA
    #declare Xona_com_Wheat_2 = rgb <0.933333333333333, 0.847058823529412, 0.682352941176471>; // HEX #EED8AE
    #declare Xona_com_Wheat_3 = rgb <0.803921568627451, 0.729411764705882, 0.588235294117647>; // HEX #CDBA96
    #declare Xona_com_Wheat_4 = rgb <0.545098039215686, 0.494117647058824, 0.4>; // HEX #8B7E66
    #declare Xona_com_Wheatfield = rgb <0.952941176470588, 0.929411764705882, 0.811764705882353>; // HEX #F3EDCF
    #declare Xona_com_Whiskey = rgb <0.835294117647059, 0.603921568627451, 0.435294117647059>; // HEX #D59A6F
    #declare Xona_com_Whiskey_Sour = rgb <0.858823529411765, 0.6, 0.368627450980392>; // HEX #DB995E
    #declare Xona_com_Whisper = rgb <0.968627450980392, 0.96078431372549, 0.980392156862745>; // HEX #F7F5FA
    #declare Xona_com_White_Ice = rgb <0.866666666666667, 0.976470588235294, 0.945098039215686>; // HEX #DDF9F1
    #declare Xona_com_White_Lilac = rgb <0.972549019607843, 0.968627450980392, 0.988235294117647>; // HEX #F8F7FC
    #declare Xona_com_White_Linen = rgb <0.972549019607843, 0.941176470588235, 0.909803921568627>; // HEX #F8F0E8
    #declare Xona_com_White_Nectar = rgb <0.988235294117647, 1, 0.905882352941176>; // HEX #FCFFE7
    #declare Xona_com_White_Pointer = rgb <0.996078431372549, 0.972549019607843, 1>; // HEX #FEF8FF
    #declare Xona_com_White_Rock = rgb <0.917647058823529, 0.909803921568627, 0.831372549019608>; // HEX #EAE8D4
    #declare Xona_com_White_Smoke = rgb <0.96078431372549, 0.96078431372549, 0.96078431372549>; // HEX #F5F5F5
    #declare Xona_com_Wild_Rice = rgb <0.925490196078431, 0.87843137254902, 0.564705882352941>; // HEX #ECE090
    #declare Xona_com_Wild_Sand = rgb <0.956862745098039, 0.956862745098039, 0.956862745098039>; // HEX #F4F4F4
    #declare Xona_com_Wild_Willow = rgb <0.725490196078431, 0.768627450980392, 0.415686274509804>; // HEX #B9C46A
    #declare Xona_com_William = rgb <0.227450980392157, 0.407843137254902, 0.423529411764706>; // HEX #3A686C
    #declare Xona_com_Willow_Brook = rgb <0.874509803921569, 0.925490196078431, 0.854901960784314>; // HEX #DFECDA
    #declare Xona_com_Willow_Grove = rgb <0.396078431372549, 0.454901960784314, 0.364705882352941>; // HEX #65745D
    #declare Xona_com_Windsor = rgb <0.235294117647059, 0.0313725490196078, 0.470588235294118>; // HEX #3C0878
    #declare Xona_com_Wine_Berry = rgb <0.349019607843137, 0.113725490196078, 0.207843137254902>; // HEX #591D35
    #declare Xona_com_Winter_Hazel = rgb <0.835294117647059, 0.819607843137255, 0.584313725490196>; // HEX #D5D195
    #declare Xona_com_Wisp_Pink = rgb <0.996078431372549, 0.956862745098039, 0.972549019607843>; // HEX #FEF4F8
    #declare Xona_com_Wisteria = rgb <0.592156862745098, 0.443137254901961, 0.709803921568627>; // HEX #9771B5
    #declare Xona_com_Wistful = rgb <0.643137254901961, 0.650980392156863, 0.827450980392157>; // HEX #A4A6D3
    #declare Xona_com_Witch_Haze = rgb <1, 0.988235294117647, 0.6>; // HEX #FFFC99
    #declare Xona_com_Wood_Bark = rgb <0.149019607843137, 0.0666666666666667, 0.0196078431372549>; // HEX #261105
    #declare Xona_com_Woodburn = rgb <0.235294117647059, 0.125490196078431, 0.0196078431372549>; // HEX #3C2005
    #declare Xona_com_Woodland = rgb <0.301960784313725, 0.325490196078431, 0.156862745098039>; // HEX #4D5328
    #declare Xona_com_Woodrush = rgb <0.188235294117647, 0.164705882352941, 0.0588235294117647>; // HEX #302A0F
    #declare Xona_com_Woodsmoke = rgb <0.0470588235294118, 0.0509803921568627, 0.0588235294117647>; // HEX #0C0D0F
    #declare Xona_com_Woody_Bay = rgb <0.16078431372549, 0.129411764705882, 0.188235294117647>; // HEX #292130
    #declare Xona_com_Woody_Brown = rgb <0.282352941176471, 0.192156862745098, 0.192156862745098>; // HEX #483131
    #declare Xona_com_Xanadu = rgb <0.450980392156863, 0.525490196078431, 0.470588235294118>; // HEX #738678
    #declare Xona_com_Yellow_2 = rgb <0.933333333333333, 0.933333333333333, 0>; // HEX #EEEE00
    #declare Xona_com_Yellow_3 = rgb <0.803921568627451, 0.803921568627451, 0>; // HEX #CDCD00
    #declare Xona_com_Yellow_4 = rgb <0.545098039215686, 0.545098039215686, 0>; // HEX #8B8B00
    #declare Xona_com_Yellow_Green = rgb <0.603921568627451, 0.803921568627451, 0.196078431372549>; // HEX #9ACD32
    #declare Xona_com_Yellow_Light = rgb <1, 1, 0.87843137254902>; // HEX #FFFFE0
    #declare Xona_com_Yellow_Metal = rgb <0.443137254901961, 0.388235294117647, 0.219607843137255>; // HEX #716338
    #declare Xona_com_Yellow_Ochre = rgb <0.890196078431372, 0.509803921568627, 0.0901960784313725>; // HEX #E38217
    #declare Xona_com_Yellow_Sea = rgb <0.996078431372549, 0.662745098039216, 0.0156862745098039>; // HEX #FEA904
    #declare Xona_com_Your_Pink = rgb <1, 0.764705882352941, 0.752941176470588>; // HEX #FFC3C0
    #declare Xona_com_Yukon_Gold = rgb <0.482352941176471, 0.4, 0.0313725490196078>; // HEX #7B6608
    #declare Xona_com_Yuma = rgb <0.807843137254902, 0.76078431372549, 0.568627450980392>; // HEX #CEC291
    #declare Xona_com_Zambezi = rgb <0.407843137254902, 0.333333333333333, 0.345098039215686>; // HEX #685558
    #declare Xona_com_Zanah = rgb <0.854901960784314, 0.925490196078431, 0.83921568627451>; // HEX #DAECD6
    #declare Xona_com_Zest = rgb <0.898039215686275, 0.517647058823529, 0.105882352941176>; // HEX #E5841B
    #declare Xona_com_Zeus = rgb <0.16078431372549, 0.137254901960784, 0.0980392156862745>; // HEX #292319
    #declare Xona_com_Ziggurat = rgb <0.749019607843137, 0.858823529411765, 0.886274509803922>; // HEX #BFDBE2
    #declare Xona_com_Zinc_White = rgb <0.992156862745098, 0.972549019607843, 1>; // HEX #FDF8FF
    #declare Xona_com_Zinc_White_2 = rgb <0.988235294117647, 0.968627450980392, 1>; // HEX #FCF7FF
    #declare Xona_com_Zircon = rgb <0.956862745098039, 0.972549019607843, 1>; // HEX #F4F8FF
    #declare Xona_com_Zombie = rgb <0.894117647058824, 0.83921568627451, 0.607843137254902>; // HEX #E4D69B
    #declare Xona_com_Zorba = rgb <0.647058823529412, 0.607843137254902, 0.568627450980392>; // HEX #A59B91
    #declare Xona_com_Zuccini = rgb <0.0156862745098039, 0.250980392156863, 0.133333333333333>; // HEX #044022
    #declare Xona_com_Zumthor = rgb <0.929411764705882, 0.964705882352941, 1>; // HEX #EDF6FF
    #declare Xona_com_Zydeco = rgb <0.00784313725490196, 0.250980392156863, 0.172549019607843>; // HEX #02402C


    // Alternative Xona.com colors
    #declare Xona_com_Alabaster = White  ; // HEX #FFFFFF
    #declare Xona_com_Black = Black  ; // HEX #000000
    #declare Xona_com_Blue = Blue   ; // HEX #0000FF
    #declare Xona_com_Blue_1 = Blue   ; // HEX #0000FF
    #declare Xona_com_Brown = Brown; // HEX #A52A2A
    #declare Xona_com_Chartreuse = MediumSpringGreen; // HEX #7FFF00
    #declare Xona_com_Chartreuse_1 = MediumSpringGreen; // HEX #7FFF00
    #declare Xona_com_Concrete = Gray95; // HEX #F2F2F2
    #declare Xona_com_Cyan = Cyan   ; // HEX #00FFFF
    #declare Xona_com_Cyan_1 = Cyan   ; // HEX #00FFFF
    #declare Xona_com_Dark_Orange_1 = Coral; // HEX #FF7F00
    #declare Xona_com_Dark_Orchid = DarkOrchid; // HEX #9932CC
    #declare Xona_com_Dark_Sea_Green = PaleGreen; // HEX #8FBC8F
    #declare Xona_com_Dark_Slate_Gray = DarkSlateGray; // HEX #2F4F4F
    #declare Xona_com_Gray_000 = Black  ; // HEX #000000
    #declare Xona_com_Gray_005 = Gray05; // HEX #0D0D0D
    #declare Xona_com_Gray_010 = Gray10; // HEX #1A1A1A
    #declare Xona_com_Gray_015 = Gray15; // HEX #262626
    #declare Xona_com_Gray_020 = Gray20; // HEX #333333
    #declare Xona_com_Gray_025 = Gray25; // HEX #404040
    #declare Xona_com_Gray_030 = Gray30; // HEX #4D4D4D
    #declare Xona_com_Gray_033 = DimGray; // HEX #545454
    #declare Xona_com_Gray_035 = Gray35; // HEX #595959
    #declare Xona_com_Gray_040 = Gray40; // HEX #666666
    #declare Xona_com_Gray_045 = Gray45; // HEX #737373
    #declare Xona_com_Gray_055 = Gray55; // HEX #8C8C8C
    #declare Xona_com_Gray_060 = Gray60; // HEX #999999
    #declare Xona_com_Gray_065 = Gray65; // HEX #A6A6A6
    #declare Xona_com_Gray_066 = LightGray; // HEX #A8A8A8
    #declare Xona_com_Gray_070 = Gray70; // HEX #B3B3B3
    #declare Xona_com_Gray_075 = Gray75; // HEX #BFBFBF
    #declare Xona_com_Gray_080 = Gray80; // HEX #CCCCCC
    #declare Xona_com_Gray_085 = Gray85; // HEX #D9D9D9
    #declare Xona_com_Gray_095 = Gray95; // HEX #F2F2F2
    #declare Xona_com_Gray_100 = White  ; // HEX #FFFFFF
    #declare Xona_com_Gray_2 = Gray; // HEX #C0C0C0
    #declare Xona_com_Green = Green  ; // HEX #00FF00
    #declare Xona_com_Green_1 = Green  ; // HEX #00FF00
    #declare Xona_com_Magenta_1 = Magenta; // HEX #FF00FF
    #declare Xona_com_Medium_Purple = MediumOrchid; // HEX #9370DB
    #declare Xona_com_Olive_Drab = MediumForestGreen; // HEX #6B8E23
    #declare Xona_com_Orange_Dark = Orange; // HEX #FF8000
    #declare Xona_com_Orchid_Dark = DarkOrchid; // HEX #9932CC
    #declare Xona_com_Pale_Violet_Red = MediumVioletRed; // HEX #DB7093
    #declare Xona_com_Purple_Medium = MediumOrchid; // HEX #9370DB
    #declare Xona_com_Red = Red    ; // HEX #FF0000
    #declare Xona_com_Red_1 = Red    ; // HEX #FF0000
    #declare Xona_com_Rock_Salt = White  ; // HEX #FFFFFF
    #declare Xona_com_Rosy_Brown = Pink; // HEX #BC8F8F
    #declare Xona_com_Sea_Green_Bright = PaleGreen; // HEX #8FBC8F
    #declare Xona_com_Slate_Gray_Dark = DarkSlateGray; // HEX #2F4F4F
    #declare Xona_com_Spring_Green_1 = SpringGreen; // HEX #00FF7F
    #declare Xona_com_Spring_Green_Light = SpringGreen; // HEX #00FF7F
    #declare Xona_com_Thistle_5 = Thistle; // HEX #D8BFD8
    #declare Xona_com_Violet_Red_Pale = MediumVioletRed; // HEX #DB7093
    #declare Xona_com_White = White  ; // HEX #FFFFFF
    #declare Xona_com_Yellow = Yellow ; // HEX #FFFF00
    #declare Xona_com_Yellow_1 = Yellow ; // HEX #FFFF00


#version farger_Xona_Inc_Temp;
#end
