#local SplLibTmpVersion = version;
#version 3.1;

// Genera un poligono di n lati con raggio circoscritto 1
#macro splPolygon(N)
	#local V = array[N+1]
	#local I=0;
	#while(I <= N)
		#local V[I] = <cos(I/N*2*pi), sin(I/N*2*pi), 0>;
		#local I=I+1;
	#end
	splLinearSpline(V)
#end

#macro splRect(V1, V2)
	splLinearSpline(array[5] {V1, <V2.x, V1.y, V1.z>, <V2.x, V2.y, V1.z>,
	                          <V1.x, V2.y, V1.z>, V1})
#end

// Genera un arco di cerchio, con un nodo per ogni angolo 
// indicato nel vettore (in gradi)
#macro splArc(V)
	#local Ctrl = 2 * (sqrt(2) - 1) / 135;
	#local A = array[4*(dimension_size(V,1)-1)]
	#local I=0;
	#while(I < dimension_size(V,1)-1)
		#local A[4*I] = <cos(radians(V[I])), sin(radians(V[I])), 0>;
		#local A[4*I+3] = <cos(radians(V[I+1])), sin(radians(V[I+1])), 0>;
		#local A[4*I+1] = A[4*I] + <-sin(radians(V[I])), cos(radians(V[I])), 0> * Ctrl * (V[I+1]-V[I]);
		#local A[4*I+2] = A[4*I+3] - <-sin(radians(V[I+1])), cos(radians(V[I+1])), 0> * Ctrl * (V[I+1]-V[I]);
		#local I=I+1; 
	#end 
	splBezierSpline(A)
#end

#macro splCircle(N)
	#local A = array[N+1]
	#local I = 0;
	#while(I <= N)
		#local A[I] = I / N * 360;
		#local I=I+1;
	#end
	splArc(A)
#end

#version SplLibTmpVersion;
