// example/template scene file for using p_surf.inc

#include "colors.inc"

global_settings { max_trace_level 8 }

#declare MakeTriangles=1; //**
// Set MakeTriangles to 1 to make surface from scratch.
// Set MakeTriangles to 0 to force reading triangles from TriangleDataFileName

// The name of a file to write/read triangles to/from
#declare TriangleDataFileName="hnnbrg.dat" //**

// If use_smooth_triangles is set to 0, only triangles (no normals) are generated
// There is currently no checking of what type of triangles they are when
// reading, so you have to either remember how this was set when/if the
// triangles were written, or just don't change use_smooth_triangles.
#declare use_smooth_triangles=1;//**

/* -------------- Textures -------------------------------*/
#include "snog.inc" // put textures in separate file to keep
                    // this file a little cleaner

/*--------------------------------------------------------*/
//** required by p_surf.inc if we are making new triangles
#declare uusteps = 40;		//**
#declare vvsteps = 80;		//**

#declare uumin   =  0;		//**
#declare uumax   =  1;          //**
#declare vvmin   =  0; 		//**
#declare vvmax   =  2*pi; 	//**


/* ------ Parametric equations -------- */
     
#macro Cosh(b)
	(exp(b)+exp(-b))/2
#end
#macro Sinh(b)
	(exp(b)-exp(-b))/2
#end

// the surface
#macro Henneberg(uu,vv)
<
	2*Sinh(uu)*cos(vv)-2/3*Sinh(3*uu)*cos(3*vv),
	2*Sinh(uu)*cos(vv)-2/3*Sinh(3*uu)*sin(3*vv),
	2*Cosh(2*uu)*cos(2*vv)	
>
#end

#macro XYZ(uu,vv)	//**
	Henneberg(uu,vv)
#end

/* --------Constructing the surface------------------------------------*/
#if(MakeTriangles)
	// to *not* write out a triangle datafile,
	// just make sure WriteTrianglesTo is not defined.
        // E.g. comment out the next line
	#declare WriteTrianglesTo=TriangleDataFileName
#else
	#declare ReadTrianglesFrom=TriangleDataFileName
#end

#include "p_surf.inc" //**

object{
	union{
          object{
			p_surface
			texture {snog scale 3}

          }
          // just to demonstrate the p_edge macro:
          object{p_edge(MAXUU,100,.1) texture{pigment{Red}}}
	}
	rotate <0,70,0>
	scale 1
}

camera
{ 
	location  < 16, 11,-16>
	look_at   < 0, 0, 0>
} 

light_source { <20, 10, -20> color rgb 1 }

sky_sphere{pigment{skypigment scale .005}}
 
