// This is an example of what an POV animation file might look like.
// As you may notice there are no changes from the standard POV Scene file
// The need is for persistent variables that could be declared.
// Notice what happens when we move from frame 9 to frame 10 and the
// Direction of an object changes


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions


#declare Box1_TransOrigX = 0          // Original Values are placed here
#declare Box1_TransOrigY = 0
#declare Box1_TransOrigZ = 0

#declare POVGLOBAL Box1_GCurPosX = 0  // What we need are persistent globals
#declare POVGLOBAL Box1_GCurPosY = 0  // that we could replace the above 
#declare POVGLOBAL Box1_GCurPosZ = 0  // vars with - like these

#declare Box1_RotOrigX = 0            // Same here
#declare Box1_RotOrigY = 0
#declare Box1_RotOrigZ = 0



#if(clock > -1)  // For frames 0 - 9
   #if(clock < 10) 
     #declare Box1_TransX = .5    // Stepsize -  factor for each vector component
     #declare Box1_TransY = .5
     #declare Box1_TransZ = .5
     #declare Box1_RotX= .5       // Of each declare statement that is vector based
     #declare Box1_RotY = .5
     #declare Box1_RotZ = .5
     #declare Box1_Trans = <clock * Box1_TransX + Box1_TransOrigX,  // translate the vector
                            clock * Box1_TransY + Box1_TransOrigY,
                            clock * Box1_TransZ + Box1_TransOrigZ>
                          
     #declare Box1_Rot  = <clock * Box1_RotX + Box1_RotOrigX,       // translate the other vector
                           clock * Box1_RotY + Box1_RotOrigX,
                           clock * Box1_RotZ + Box1_TransOrigX>
   #end
 #end
 
#if(clock > 9)  // for frames 10 - 18
   #if(clock < 19) 
     #declare Box1_TransX = -.5
     #declare Box1_TransY = -.5
     #declare Box1_TransZ = -.5
     #declare Box1_RotX= -.5
     #declare Box1_RotY = -.5
     #declare Box1_RotZ = -.5
     #declare Box1_Trans = <clock * Box1_TransX + Box1_TransOrigX,
                            clock * Box1_TransY + Box1_TransOrigY,
                            clock * Box1_TransZ + Box1_TransOrigZ>
                          
     #declare Box1_Rot  = <clock * Box1_RotX + Box1_RotOrigX,
                           clock * Box1_RotY + Box1_RotOrigX,
                           clock * Box1_RotZ + Box1_TransOrigX>
  #end
#end



// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <0, 10, -5>
}

camera
{
  location  <0.0 , 0.0 ,0.0>
  look_at   <0.0 , 0.0 , 1.0>
  translate<0,0,-5>
  
}


// create a box that extends between the 2 specified points
box
{
  <-1, -1, -1>  // one corner position <X1 Y1 Z1>
  < 1,  1,  1>  // other corner position <X2 Y2 Z2>
  pigment { color Yellow }
    rotate Box1_Rot
    translate Box1_Trans
  
}


    
