// This file is an example of how one would write the initial
// frame of the animation. This file would be read by POVAnim and
// be output in a file similiar to animtest.pov.


#include "colors.inc"
#include "textures.inc"
#include "stones.inc"

#declare SPHERE1_TRANS = <0.46667,1.08889,0.62222> 
#declare SPHERE1_ROTATE = <-304.00000,0.00000,0.00000> 
#declare SPHERE2_TRANS = <0.77778,0.00000,0.31111> 
#declare SPHERE2_ROTATE = <345.92179,691.84358,0.00000> 
#declare SPHERE3_TRANS = <-0.00000,0.58333,0.93333> 
#declare SPHERE3_ROTATE = <2767.37430,2767.37430,-2767.37430> 
#declare SPHERE4_TRANS = <0.00000,0.77778,0.93333> 
#declare SPHERE4_ROTATE = <157.33333,549.33333,36.40000> 
#declare SPHERE5_TRANS = <-0.93333,0.11667,-0.58333> 
#declare SPHERE5_ROTATE = <43.24022,43.24022,43.24022> 
#declare CAM_ROTATE = <-9.75000,0.00000,-27.00000> 
#declare CAM_TRANS = <0.00000,3.36364,-6.63636> 
#declare PLANEX_ROTATE = <2767.37430,0.00000,0.00000> 
#declare PLANEY_ROTATE = <0.00000,2767.37430,0.00000> 
#declare PLANEZ_ROTATE = <0.00000,0.00000,1383.68715> 



camera { location <0,0,0>
         look_at <0,0,.1>
         rotate CAM_ROTATE
         translate CAM_TRANS
}


// Create an infinite sphere around scene and allow any texture on it
sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}


// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane
{
  z, // <X Y Z> unit surface normal, vector points "away from surface"
  10.0 // distance from the origin in the direction of the surface normal

// texture pigment/normal pattern
// cube checker pattern, alternates color1 and color2
pigment {
  checker
    color Black
    color White
    }
    finish { Shiny }
    rotate PLANEZ_ROTATE

}

// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane
{
  y, // <X Y Z> unit surface normal, vector points "away from surface"
  -1 // distance from the origin in the direction of the surface normal

// texture pigment/normal pattern
// cube checker pattern, alternates color1 and color2
pigment {
  checker
    color Black
    color White
    }
    finish { Shiny }
    rotate PLANEY_ROTATE

}

// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane
{
  x, // <X Y Z> unit surface normal, vector points "away from surface"
  10.0 // distance from the origin in the direction of the surface normal

// texture pigment/normal pattern
// cube checker pattern, alternates color1 and color2
pigment {
  checker
    color Black
    color White
    }
    finish { Shiny }
    rotate PLANEX_ROTATE

}

// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane
{
  x, // <X Y Z> unit surface normal, vector points "away from surface"
  -10.0 // distance from the origin in the direction of the surface normal

// texture pigment/normal pattern
// cube checker pattern, alternates color1 and color2
pigment {
  checker
    color Black
    color White
    }
    finish { Shiny }
  rotate PLANEX_ROTATE
}


light_source { <1,1,-2> color White }

sphere { <0,0,0>, 1   texture { T_Stone21 Shiny }
  rotate SPHERE1_ROTATE translate SPHERE1_TRANS
}
sphere { <0,0,0>, 1   texture { T_Stone20 Shiny }
  rotate SPHERE2_ROTATE translate SPHERE2_TRANS
}
sphere { <0,0,0>, 1   texture { T_Stone19 Shiny }
  rotate SPHERE3_ROTATE translate SPHERE3_TRANS
}
sphere { <0,0,0>, 1   texture { T_Stone18 Shiny }
  rotate SPHERE3_ROTATE translate SPHERE3_TRANS
}
sphere { <0,0,0>, 1   texture { T_Stone17 Shiny }
  rotate SPHERE4_ROTATE translate SPHERE4_TRANS
  }
sphere { <0,0,0>, 1   texture { T_Stone16 Shiny }
  rotate SPHERE5_ROTATE translate SPHERE5_TRANS
}
