// This file is an example of how one would write the initial
// frame of the animation. This file would be read by POVAnim and
// be output in a file similiar to animtest.pov.


#include "colors.inc"
#include "textures.inc"
#include "stones.inc"

#declare SPHERE1_TRANS = <0.93333,2.17778,1.24444> 
#declare SPHERE1_ROTATE = <-248.00000,0.00000,0.00000> 
#declare SPHERE2_TRANS = <1.55556,0.00000,0.62222> 
#declare SPHERE2_ROTATE = <331.84358,663.68715,0.00000> 
#declare SPHERE3_TRANS = <-0.00000,1.16667,1.86667> 
#declare SPHERE3_ROTATE = <2654.74860,2654.74860,-2654.74860> 
#declare SPHERE4_TRANS = <0.00000,1.55556,1.86667> 
#declare SPHERE4_ROTATE = <194.66667,978.66667,72.80000> 
#declare SPHERE5_TRANS = <-1.86667,0.23333,-1.16667> 
#declare SPHERE5_ROTATE = <41.48045,41.48045,41.48045> 
#declare CAM_ROTATE = <-4.50000,0.00000,36.00000> 
#declare CAM_TRANS = <0.00000,2.72727,-7.27273> 
#declare PLANEX_ROTATE = <2654.74860,0.00000,0.00000> 
#declare PLANEY_ROTATE = <0.00000,2654.74860,0.00000> 
#declare PLANEZ_ROTATE = <0.00000,0.00000,1327.37430> 



camera { location <0,0,0>
         look_at <0,0,.1>
         rotate CAM_ROTATE
         translate CAM_TRANS
}


// Create an infinite sphere around scene and allow any texture on it
sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}


// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane
{
  z, // <X Y Z> unit surface normal, vector points "away from surface"
  10.0 // distance from the origin in the direction of the surface normal

// texture pigment/normal pattern
// cube checker pattern, alternates color1 and color2
pigment {
  checker
    color Black
    color White
    }
    finish { Shiny }
    rotate PLANEZ_ROTATE

}

// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane
{
  y, // <X Y Z> unit surface normal, vector points "away from surface"
  -1 // distance from the origin in the direction of the surface normal

// texture pigment/normal pattern
// cube checker pattern, alternates color1 and color2
pigment {
  checker
    color Black
    color White
    }
    finish { Shiny }
    rotate PLANEY_ROTATE

}

// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane
{
  x, // <X Y Z> unit surface normal, vector points "away from surface"
  10.0 // distance from the origin in the direction of the surface normal

// texture pigment/normal pattern
// cube checker pattern, alternates color1 and color2
pigment {
  checker
    color Black
    color White
    }
    finish { Shiny }
    rotate PLANEX_ROTATE

}

// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane
{
  x, // <X Y Z> unit surface normal, vector points "away from surface"
  -10.0 // distance from the origin in the direction of the surface normal

// texture pigment/normal pattern
// cube checker pattern, alternates color1 and color2
pigment {
  checker
    color Black
    color White
    }
    finish { Shiny }
  rotate PLANEX_ROTATE
}


light_source { <1,1,-2> color White }

sphere { <0,0,0>, 1   texture { T_Stone21 Shiny }
  rotate SPHERE1_ROTATE translate SPHERE1_TRANS
}
sphere { <0,0,0>, 1   texture { T_Stone20 Shiny }
  rotate SPHERE2_ROTATE translate SPHERE2_TRANS
}
sphere { <0,0,0>, 1   texture { T_Stone19 Shiny }
  rotate SPHERE3_ROTATE translate SPHERE3_TRANS
}
sphere { <0,0,0>, 1   texture { T_Stone18 Shiny }
  rotate SPHERE3_ROTATE translate SPHERE3_TRANS
}
sphere { <0,0,0>, 1   texture { T_Stone17 Shiny }
  rotate SPHERE4_ROTATE translate SPHERE4_TRANS
  }
sphere { <0,0,0>, 1   texture { T_Stone16 Shiny }
  rotate SPHERE5_ROTATE translate SPHERE5_TRANS
}
