// This file is an example of how one would write the initial
// frame of the animation. This file would be read by POVAnim and
// be output in a file similiar to animtest.pov.


#include "colors.inc"
#include "textures.inc"
#include "stones.inc"

#declare SPHERE1_TRANS = <1.00000,2.33333,1.33333> 
#declare SPHERE1_ROTATE = <-240.00000,0.00000,0.00000> 
#declare SPHERE2_TRANS = <1.66667,0.00000,0.66667> 
#declare SPHERE2_ROTATE = <329.83240,659.66480,0.00000> 
#declare SPHERE3_TRANS = <-0.00000,1.25000,2.00000> 
#declare SPHERE3_ROTATE = <2638.65922,2638.65922,-2638.65922> 
#declare SPHERE4_TRANS = <0.00000,1.66667,2.00000> 
#declare SPHERE4_ROTATE = <200.00000,1040.00000,78.00000> 
#declare SPHERE5_TRANS = <-2.00000,0.25000,-1.25000> 
#declare SPHERE5_ROTATE = <41.22905,41.22905,41.22905> 
#declare CAM_ROTATE = <-3.75000,0.00000,45.00000> 
#declare CAM_TRANS = <0.00000,2.63636,-7.36364> 
#declare PLANEX_ROTATE = <2638.65922,0.00000,0.00000> 
#declare PLANEY_ROTATE = <0.00000,2638.65922,0.00000> 
#declare PLANEZ_ROTATE = <0.00000,0.00000,1319.32961> 



camera { location <0,0,0>
         look_at <0,0,.1>
         rotate CAM_ROTATE
         translate CAM_TRANS
}


// Create an infinite sphere around scene and allow any texture on it
sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}


// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane
{
  z, // <X Y Z> unit surface normal, vector points "away from surface"
  10.0 // distance from the origin in the direction of the surface normal

// texture pigment/normal pattern
// cube checker pattern, alternates color1 and color2
pigment {
  checker
    color Black
    color White
    }
    finish { Shiny }
    rotate PLANEZ_ROTATE

}

// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane
{
  y, // <X Y Z> unit surface normal, vector points "away from surface"
  -1 // distance from the origin in the direction of the surface normal

// texture pigment/normal pattern
// cube checker pattern, alternates color1 and color2
pigment {
  checker
    color Black
    color White
    }
    finish { Shiny }
    rotate PLANEY_ROTATE

}

// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane
{
  x, // <X Y Z> unit surface normal, vector points "away from surface"
  10.0 // distance from the origin in the direction of the surface normal

// texture pigment/normal pattern
// cube checker pattern, alternates color1 and color2
pigment {
  checker
    color Black
    color White
    }
    finish { Shiny }
    rotate PLANEX_ROTATE

}

// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane
{
  x, // <X Y Z> unit surface normal, vector points "away from surface"
  -10.0 // distance from the origin in the direction of the surface normal

// texture pigment/normal pattern
// cube checker pattern, alternates color1 and color2
pigment {
  checker
    color Black
    color White
    }
    finish { Shiny }
  rotate PLANEX_ROTATE
}


light_source { <1,1,-2> color White }

sphere { <0,0,0>, 1   texture { T_Stone21 Shiny }
  rotate SPHERE1_ROTATE translate SPHERE1_TRANS
}
sphere { <0,0,0>, 1   texture { T_Stone20 Shiny }
  rotate SPHERE2_ROTATE translate SPHERE2_TRANS
}
sphere { <0,0,0>, 1   texture { T_Stone19 Shiny }
  rotate SPHERE3_ROTATE translate SPHERE3_TRANS
}
sphere { <0,0,0>, 1   texture { T_Stone18 Shiny }
  rotate SPHERE3_ROTATE translate SPHERE3_TRANS
}
sphere { <0,0,0>, 1   texture { T_Stone17 Shiny }
  rotate SPHERE4_ROTATE translate SPHERE4_TRANS
  }
sphere { <0,0,0>, 1   texture { T_Stone16 Shiny }
  rotate SPHERE5_ROTATE translate SPHERE5_TRANS
}
