// This file is an example of how one would write the initial
// frame of the animation. This file would be read by POVAnim and
// be output in a file similiar to animtest.pov.


#include "colors.inc"
#include "textures.inc"
#include "stones.inc"

#declare SPHERE1_TRANS = <-7.40000,8.73333,8.33333> 
#declare SPHERE1_ROTATE = <312.00000,0.00000,0.00000> 
#declare SPHERE2_TRANS = <9.33333,0.00000,3.73333> 
#declare SPHERE2_ROTATE = <191.06145,382.12291,0.00000> 
#declare SPHERE3_TRANS = <3.20000,3.80000,2.40000> 
#declare SPHERE3_ROTATE = <1528.49162,1528.49162,-1528.49162> 
#declare SPHERE4_TRANS = <0.00000,5.00000,6.00000> 
#declare SPHERE4_ROTATE = <360.00000,1684.00000,152.10000> 
#declare SPHERE5_TRANS = <-4.77311,1.60504,-2.78151> 
#declare SPHERE5_ROTATE = <23.88268,23.88268,23.88268> 
#declare CAM_ROTATE = <0.00000,0.00000,0.00000> 
#declare CAM_TRANS = <0.00000,0.00000,-10.00000> 
#declare PLANEX_ROTATE = <1528.49162,0.00000,0.00000> 
#declare PLANEY_ROTATE = <0.00000,1528.49162,0.00000> 
#declare PLANEZ_ROTATE = <0.00000,0.00000,764.24581> 



camera { location <0,0,0>
         look_at <0,0,.1>
         rotate CAM_ROTATE
         translate CAM_TRANS
}


// Create an infinite sphere around scene and allow any texture on it
sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}


// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane
{
  z, // <X Y Z> unit surface normal, vector points "away from surface"
  10.0 // distance from the origin in the direction of the surface normal

// texture pigment/normal pattern
// cube checker pattern, alternates color1 and color2
pigment {
  checker
    color Black
    color White
    }
    finish { Shiny }
    rotate PLANEZ_ROTATE

}

// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane
{
  y, // <X Y Z> unit surface normal, vector points "away from surface"
  -1 // distance from the origin in the direction of the surface normal

// texture pigment/normal pattern
// cube checker pattern, alternates color1 and color2
pigment {
  checker
    color Black
    color White
    }
    finish { Shiny }
    rotate PLANEY_ROTATE

}

// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane
{
  x, // <X Y Z> unit surface normal, vector points "away from surface"
  10.0 // distance from the origin in the direction of the surface normal

// texture pigment/normal pattern
// cube checker pattern, alternates color1 and color2
pigment {
  checker
    color Black
    color White
    }
    finish { Shiny }
    rotate PLANEX_ROTATE

}

// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane
{
  x, // <X Y Z> unit surface normal, vector points "away from surface"
  -10.0 // distance from the origin in the direction of the surface normal

// texture pigment/normal pattern
// cube checker pattern, alternates color1 and color2
pigment {
  checker
    color Black
    color White
    }
    finish { Shiny }
  rotate PLANEX_ROTATE
}


light_source { <1,1,-2> color White }

sphere { <0,0,0>, 1   texture { T_Stone21 Shiny }
  rotate SPHERE1_ROTATE translate SPHERE1_TRANS
}
sphere { <0,0,0>, 1   texture { T_Stone20 Shiny }
  rotate SPHERE2_ROTATE translate SPHERE2_TRANS
}
sphere { <0,0,0>, 1   texture { T_Stone19 Shiny }
  rotate SPHERE3_ROTATE translate SPHERE3_TRANS
}
sphere { <0,0,0>, 1   texture { T_Stone18 Shiny }
  rotate SPHERE3_ROTATE translate SPHERE3_TRANS
}
sphere { <0,0,0>, 1   texture { T_Stone17 Shiny }
  rotate SPHERE4_ROTATE translate SPHERE4_TRANS
  }
sphere { <0,0,0>, 1   texture { T_Stone16 Shiny }
  rotate SPHERE5_ROTATE translate SPHERE5_TRANS
}
