// This file is an example of how one would write the initial
// frame of the animation. This file would be read by POVAnim and
// be output in a file similiar to animtest.pov.


#include "colors.inc"
#include "textures.inc"
#include "stones.inc"

#declare SPHERE1_TRANS = <-4.20000,9.00000,9.00000> 
#declare SPHERE1_ROTATE = <311.46067,0.00000,0.00000> 
#declare SPHERE2_TRANS = <7.30337,0.00000,3.46067> 
#declare SPHERE2_ROTATE = <154.86034,309.72067,0.00000> 
#declare SPHERE3_TRANS = <5.60000,2.90000,-1.80000> 
#declare SPHERE3_ROTATE = <1238.88268,1238.88268,-1238.88268> 
#declare SPHERE4_TRANS = <0.00000,5.00000,6.00000> 
#declare SPHERE4_ROTATE = <360.00000,1132.00000,114.30000> 
#declare SPHERE5_TRANS = <-2.35294,2.05882,-1.11765> 
#declare SPHERE5_ROTATE = <19.35754,19.35754,19.35754> 
#declare CAM_ROTATE = <0.00000,0.00000,0.00000> 
#declare CAM_TRANS = <0.00000,0.00000,-10.00000> 
#declare PLANEX_ROTATE = <1238.88268,0.00000,0.00000> 
#declare PLANEY_ROTATE = <0.00000,1238.88268,0.00000> 
#declare PLANEZ_ROTATE = <0.00000,0.00000,619.44134> 



camera { location <0,0,0>
         look_at <0,0,.1>
         rotate CAM_ROTATE
         translate CAM_TRANS
}


// Create an infinite sphere around scene and allow any texture on it
sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}


// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane
{
  z, // <X Y Z> unit surface normal, vector points "away from surface"
  10.0 // distance from the origin in the direction of the surface normal

// texture pigment/normal pattern
// cube checker pattern, alternates color1 and color2
pigment {
  checker
    color Black
    color White
    }
    finish { Shiny }
    rotate PLANEZ_ROTATE

}

// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane
{
  y, // <X Y Z> unit surface normal, vector points "away from surface"
  -1 // distance from the origin in the direction of the surface normal

// texture pigment/normal pattern
// cube checker pattern, alternates color1 and color2
pigment {
  checker
    color Black
    color White
    }
    finish { Shiny }
    rotate PLANEY_ROTATE

}

// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane
{
  x, // <X Y Z> unit surface normal, vector points "away from surface"
  10.0 // distance from the origin in the direction of the surface normal

// texture pigment/normal pattern
// cube checker pattern, alternates color1 and color2
pigment {
  checker
    color Black
    color White
    }
    finish { Shiny }
    rotate PLANEX_ROTATE

}

// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane
{
  x, // <X Y Z> unit surface normal, vector points "away from surface"
  -10.0 // distance from the origin in the direction of the surface normal

// texture pigment/normal pattern
// cube checker pattern, alternates color1 and color2
pigment {
  checker
    color Black
    color White
    }
    finish { Shiny }
  rotate PLANEX_ROTATE
}


light_source { <1,1,-2> color White }

sphere { <0,0,0>, 1   texture { T_Stone21 Shiny }
  rotate SPHERE1_ROTATE translate SPHERE1_TRANS
}
sphere { <0,0,0>, 1   texture { T_Stone20 Shiny }
  rotate SPHERE2_ROTATE translate SPHERE2_TRANS
}
sphere { <0,0,0>, 1   texture { T_Stone19 Shiny }
  rotate SPHERE3_ROTATE translate SPHERE3_TRANS
}
sphere { <0,0,0>, 1   texture { T_Stone18 Shiny }
  rotate SPHERE3_ROTATE translate SPHERE3_TRANS
}
sphere { <0,0,0>, 1   texture { T_Stone17 Shiny }
  rotate SPHERE4_ROTATE translate SPHERE4_TRANS
  }
sphere { <0,0,0>, 1   texture { T_Stone16 Shiny }
  rotate SPHERE5_ROTATE translate SPHERE5_TRANS
}
