/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* * This scene is designed for 16:9 aspect ratio.                                                                   * */
/* *                                                                                                                 * */
/* * The purpose of this file is to provide a template that you can copy and paste into your own scenes, as well as  * */
/* * provide a basic explanation of how to use the BorderChars features.                                             * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

//-f

//Set up the scene. Include "BorderChars.inc."

#version 3.7;

global_settings {assumed_gamma 2.2}

#include "colors.inc"
#include "BorderChars.inc"

camera {
   orthographic
   location <0, 0, -5.3>
   direction <0, 0, 1>
   scale <16/9, 4/3, 1>
   look_at <0, 0, 0>
} //camera

//Define the textures to be used for the outer and inner portions of the characters, as well as the back faces. These
//textures will be passed to the SetFontStyle () macro. You can use any variable names you want, just make sure if you
//use different names that the names match the corresponding names in the SetFontStyle () macro parameter list.

#local TextColor_Outer = texture {pigment {color White} finish {emission 1}}

#local TextColor_Inner = texture {pigment {color <.6196, .6941, .0706>} finish {emission 1}}

#local TextColor_Back = texture {TextColor_Outer}

//Select a "Font Variation" from "Demo_FontVariations.pov" and copy and paste the corresponding code. Set the variables
//according to your needs. Note that high quality images showing all the "Font Variations" can be downloaded from the
//POV newsgroups website (povray.binaries.images). You can also render the images yourself by following the instructions
//in the "Demo_FontVariations.pov" file if you prefer.

#local FontVariationNumber = 26;
#local TextDepth = .08;
#local InvisibleBorderWidth = 0;
#local BorderWidth = .03;
#local BorderDepth = .01;
#local DarkBorderWidth = .05;
#local NSteps = 15;

//Call the SetFontStyle () macro. The parameter names will be different for each "Font Variation," so copy and paste this
//line along with the code above. No adjustments need to be made to this line.

SetFontStyle (0, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, BorderDepth, DarkBorderWidth, NSteps, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)

//Set the spacing for your Paragraph object. These variable names cannot be changed.

#declare GAP_Width = .05;   //Distance between characters
#declare SPACE_Width = .26; //Distance between words
#declare LineSpacing = .5;  //Distance between lines

//See the "BorderChars_Instructions.pov" file for detailed instructions regarding the following variables.

#declare LineAlignment = LEFT; //Choices are LEFT, RIGHT, CENTERED, or JUSTIFIED
#declare MaxMicroJustificationScale = 1; //Set to 1 for no scaling, > 1 for limited scaling, or UNLIMITED
#declare MaxAdditionalGAP_WidthPercentage = UNLIMITED; //Set to 0 to maintain constant gap width, any percentage, or UNLIMITED
#declare SPACE_ExpansionRate = 1.5; //Values > 1 will cause SPACE_Width to increase faster than GAP_Width
#declare JustifyLastLinePercentage = 95; //Minimum percentage of paragraph width to justify last line
#declare MinJustifiedParagraphWidth = 0; //Minimum width of paragraph when justified

//The variable [TextScale] affects the x and y dimensions of the characters only. See the "BorderChars_Instructions.pov"
//file for further details and for instructions regarding the [UseActualParagraphHeight] variable, as well as the
//"Demo_ParagraphHeight.pov" file for a visual demonstration.

#local TextScale = 1;
#local UseActualParagraphHeight = no;

//Call the InitializeVariables () macro. The only parameter is the number of lines your Paragraph will contain.

#local NLines = 1;

InitializeVariables (NLines)

//The macros will create an array for you called [LineText]. You must fill each array element with one line of text. The
//number of lines must match the number you used in the previous step. The text may include formatting codes as described
//in the "BorderChars_Instructions.pov" file.

//Use   \"   for DOUBLE QUOTE MARKS.
//Use   &    for a HEART.
//Use   ^    for a STAR.
//Use   @    for a BULLET.

#declare LineText [0] = "~0~Greetings, Earthling!";

//Call the CreateParagraph () macro to create an object called "Paragraph" according to your specifications.

CreateParagraph (NLines, TextScale, UseActualParagraphHeight)

//The Paragraph object is now ready for your scene, and some useful variables have been set for your use.

object {Paragraph translate <-ParagraphWidth / 2, ParagraphHeight / 2, 0>}
