/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* * This scene is designed for 16:9 aspect ratio.                                                                   * */
/* *                                                                                                                 * */
/* * The purpose of this file is to demonstrate the use of the variable [UseActualParagraphHeight].                  * */
/* *                                                                                                                 * */
/* * Set the value of [TestString] to see how [UseActualParagraphHeight] works.                                      * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

//-f

#version 3.7;

//Use   \"   for DOUBLE QUOTE MARKS.
//Use   &    for a HEART.
//Use   ^    for a STAR.
//Use   @    for a BULLET.

#local TestString = "Cg*"; //Change this variable to see how [UseActualParagraphHeight] works.

global_settings {assumed_gamma 2.2}

#include "colors.inc"
#include "BorderChars.inc"

camera {
   orthographic
   location <0, 0, -20>
   direction <0, 0, 1>
   scale <16/9, 4/3, 1>
   look_at <0, 0, 0>
} //camera

background {color Blue * .7}

#declare TextColor_Outer = texture {pigment {color White} finish {emission 1}}

#declare TextColor_Inner = texture {TextColor_Outer}

#declare TextColor_Back = texture {pigment {color Black}}

#local FontVariationNumber = 0;
#local TextDepth = .03;
#local InvisibleBorderWidth = 0;

SetFontStyle (0, FontVariationNumber, TextDepth, InvisibleBorderWidth, 999, 999, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)

#local FontVariationNumber = 0;
#local TextDepth = .03;
#local InvisibleBorderWidth = .03;

SetFontStyle (1, FontVariationNumber, TextDepth, InvisibleBorderWidth, 999, 999, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)

#declare GAP_Width = .06;   //Distance between characters
#declare SPACE_Width = .25; //Distance between words
#declare LineSpacing = .5;  //Distance between lines

#declare LineAlignment = JUSTIFIED; //Choices are LEFT, RIGHT, CENTERED, or JUSTIFIED
#declare MaxMicroJustificationScale = 1; //Set to 1 for no scaling, > 1 for limited scaling, or UNLIMITED
#declare MaxAdditionalGAP_WidthPercentage = UNLIMITED; //Set to 0 to maintain constant gap width, any percentage, or UNLIMITED
#declare SPACE_ExpansionRate = 1.5; //Values > 1 will cause SPACE_Width to increase faster than GAP_Width
#declare JustifyLastLinePercentage = 95; //Minimum percentage of paragraph width to justify last line
#declare MinJustifiedParagraphWidth = 0; //Minimum width of paragraph when justified

#local TextScale = 8;
#local UseActualParagraphHeight = no;

#local NLines = 1;

InitializeVariables (NLines)

#declare LineText [0] = concat ("~0~", TestString);

CreateParagraph (NLines, TextScale, UseActualParagraphHeight)

#declare Paragraph1 = object {
   union {
      object {Paragraph}
      box {<0, 0, -.02> <ParagraphWidth, -ParagraphHeight, 0> texture {pigment {color DarkOrchid} finish {emission 1}}}
      box {<-.4, .4, -.01> <ParagraphWidth + .4, -ParagraphHeight - .4, 0> texture {pigment {color MediumOrchid * 1.5} finish {emission 1}}}
   } //union
   translate <-ParagraphWidth / 2, 0, 0>
} //object

#local TextScale = 1;
#local UseActualParagraphHeight = no;

#local NLines = 1;

InitializeVariables (NLines)

#declare LineText [0] = "~1~UseActualParagraphHeight = no";

CreateParagraph (NLines, TextScale, UseActualParagraphHeight)

#declare Paragraph1 = object {
   union {
      object {Paragraph1}
      object {Paragraph translate <-ParagraphWidth / 2, 2.5, 0>}
   } //union
} //object

#local TextScale = 8;
#local UseActualParagraphHeight = yes;

#local NLines = 1;

InitializeVariables (NLines)

#declare LineText [0] = concat ("~0~", TestString);

CreateParagraph (NLines, TextScale, UseActualParagraphHeight)

#declare Paragraph2 = object {
   union {
      object {Paragraph}
      box {<0, 0, -.02> <ParagraphWidth, -ParagraphHeight, 0> texture {pigment {color DarkOrchid} finish {emission 1}}}
      box {<-.4, .4, -.01> <ParagraphWidth + .4, -ParagraphHeight - .4, 0> texture {pigment {color MediumOrchid * 1.5} finish {emission 1}}}
   } //union
   translate <-ParagraphWidth / 2, 0, 0>
} //object

#local TextScale = 1;
#local UseActualParagraphHeight = no;

#local NLines = 1;

InitializeVariables (NLines)

#declare LineText [0] = "~1~UseActualParagraphHeight = yes";

CreateParagraph (NLines, TextScale, UseActualParagraphHeight)

#declare Paragraph2 = object {
   union {
      object {Paragraph2}
      object {Paragraph translate <-ParagraphWidth / 2, 2.5, 0>}
   } //union
} //object

#local TextScale = 1;
#local UseActualParagraphHeight = no;

#local NLines = 4;

InitializeVariables (NLines)

#declare LineText [0] = "~1~In both examples, the upper-left corner of the dark purple box represents";
#declare LineText [1] = "(x = 0, y = 0) and the lower-right corner represents (x = ParagraphWidth, y =";
#declare LineText [2] = "-ParagraphHeight). You can experiment by changing the value of the variable";
#declare LineText [3] = "{\"TestString\"} in this file.";

CreateParagraph (NLines, TextScale, UseActualParagraphHeight)

object {Paragraph1 translate <-11.5, 9, 0>}
object {Paragraph2 translate <11.5, 9, 0>}
object {Paragraph translate <-ParagraphWidth / 2, -6, 0>}
