/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* * This scene is designed for 16:9 screen ratio.                                                                   * */
/* *                                                                                                                 * */
/* * The purpose of this file is to show a close-up view of each font variation, and assist with the design of new   * */
/* * font variations.                                                                                                * */
/* *                                                                                                                 * */
/* * Set the value of [FontVariationNumber] to select a font variation to view.                                      * */
/* *                                                                                                                 * */
/* * Set the value of [UseRadiosity] to "yes" for a quick render, or "no" for a higher-quality render.               * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

//-f

#version 3.7;

#local FontVariationNumber = 0;

#local UseRadiosity = no;

#local TestCharacter = "P";

global_settings {
   assumed_gamma 2.2
   charset utf8
   max_trace_level 20
   #if (UseRadiosity)
      radiosity {
         pretrace_start .08
         pretrace_end .004
         count 60
         error_bound .002
         adc_bailout .1
         recursion_limit 2
         normal on
      } //radiosity
   #end //#if
} //global_settings

#include "colors.inc"
#include "BorderChars.inc"

camera {
   location <0, 0, -3>
   direction <0, 0, 1>
   right (16/9) * x
   rotate -65 * x
   look_at <0, -3.5, 0>
} //camera

#local LightingAngle_X = -15;
#local LightingAngle_Y = -30;

#if (UseRadiosity)
   #local DomeColor = texture {
      #local Color0 = White * 6.73;
      #local Color1 = White;
      #local Color2 = White * .6;
      #local T1 = .1;
      #local T2 = .2;
      pigment {
         gradient z
         color_map {
            [0 Color0]
            [T1 Color1]
            [T2 Color2]
            [1 Color2]
         } //color_map
      } //pigment
      scale <1, 1, 2>
      translate -1 * z
      finish {emission 1 diffuse 0}
   } //texture
   #local Dome = object {
      difference {
         sphere {0, 20001}
         sphere {0, 20000}
      } //difference
      texture {DomeColor scale <1, 1, 20000>}
      rotate LightingAngle_X * x
      rotate LightingAngle_Y * y
   } //object
   #local Dome = object {
      intersection {
         object {Dome}
         plane {z, 15300 texture {pigment {color White}}}
      } //intersection
      no_reflection
   } //object
   object {Dome}
#else
   light_source {<0, 0, -200> color White * 1.7 rotate LightingAngle_X * x rotate LightingAngle_Y * y shadowless}
#end //#if

#local TextColor_Outer = texture {pigment {color White}}
#local TextColor_Inner = texture {pigment {color White}}

#switch (FontVariationNumber)
   #case (28)
      #local TextColor_Inner = texture {
         #local Color0 = color <0.0000, 0.8894, 0.7535>;
         #local Color1 = color <0.6341, 0.0124, 0.8235>;
         pigment {
            gradient x
            color_map {
               #for (I, 0, 1, 5/360)
                  #local A = I * 360;
                  #local S = sin (radians (A));
                  #local Fraction0 = .5 + S / 2;
                  #local Fraction1 = .5 - S / 2;
                  #if (A < 1 | (A > 74 & A < 106) | (A > 179 & A < 181) | (A > 254 & A < 286) | A > 359)
                     [I color Color0 * Fraction0 + Color1 * Fraction1]
                  #end //#if
               #end //#for
            } //color_map
         } //pigment
         translate .5 * x
      } //texture
   #break //#case
   #case (29)
      #include "stones.inc"
      #local TextColor_Inner = texture {T_Stone11}
   #break //#case
   #case (33)
   #case (34)
   #case (35)
      #local TextColor_Outer = texture {
         pigment {
            granite
            turbulence .5
            pigment_map {
               [0 SkyBlue * 1.4]
               [1 Navy * 1.2]
            } //pigment_map
         } //pigment
         #local S = .01;
         scale <S, S, S>
      } //texture
   #break //#case
   #case (41)
      #local TextColor_Inner = texture {
         pigment {
            granite
            turbulence .5
            pigment_map {
               [0 SkyBlue * 1.4]
               [1 Navy * 1.2]
            } //pigment_map
         } //pigment
         #local S = .01;
         scale <S, S, S>
      } //texture
   #break //#case
   #else
      #local TextColor_Inner = texture {
         #local Color0 = color <0.0000, 0.8894, 0.7535>;
         #local Color1 = color <0.6341, 0.0124, 0.8235>;
         pigment {
            gradient y
            color_map {
               [0 color Color0]
               [.6 (Color0 + Color1) / 2]
               [1 color Color1]
            } //color_map
         } //pigment
      } //texture
   #break //#case
#end //#if

#local TextColor_Back = texture {pigment {color Black}}

#local BackgroundColor = texture {
   pigment {checker color <0.8834, 0.8494, 0.7747> color <0.9639, 0.9419, 0.9021>}
   #local S = 1.5;
   scale <S, S, 1>
} //texture

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* *                                                                                                                 * */
/* * THE SCENE                                                                                                       * */
/* *                                                                                                                 * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#declare GAP_Width = .1;

#local Grid = object {
   union {
      #switch (FontVariationNumber)
         #case (0) //Plain
            #local FontVariationNumber = 0;
            #local TextDepth = .08;
            #local InvisibleBorderWidth = 0;
            SetFontStyle (0, FontVariationNumber, TextDepth, InvisibleBorderWidth, 999, 999, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (1) //Raised center (use when border and center are the same height)
            #local FontVariationNumber = 1;
            #local TextDepth = .08;
            #local InvisibleBorderWidth = 0;
            #local BorderWidth = .03;
            #local BorderHeight = .025;
            SetFontStyle (0, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, BorderHeight, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (2) //Lowered center
            #local FontVariationNumber = 2;
            #local TextDepth = .08;
            #local InvisibleBorderWidth = 0;
            #local BorderWidth = .03;
            #local BorderDepth = .025;
            SetFontStyle (0, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, BorderDepth, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (3) //Striped
            #local FontVariationNumber = 3;
            #local TextDepth = .08;
            #local InvisibleBorderWidth = 0;
            #local BorderWidth = .03;
            #local StripeWidth = .02;
            #local StripeHeight = .02; //Can be negative, 0, or positive
            SetFontStyle (0, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, StripeWidth, StripeHeight, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (4) //Color gradient
            #local FontVariationNumber = 4;
            #local TextDepth = .08;
            #local InvisibleBorderWidth = .0;
            #local BorderWidth = .03;
            #local StripeWidth = .04;
            #local NSteps = 15;
            #declare ExtraParameter_Color0 = color <0.0000, 0.8894, 0.7535>;
            #declare ExtraParameter_Color1 = color <0.6341, 0.0124, 0.8235>;
            SetFontStyle (0, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, StripeWidth, NSteps, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (5) //Hollow stripe
            #local FontVariationNumber = 5;
            #local TextDepth = .08;
            #local InvisibleBorderWidth = 0;
            #local BorderWidth = .03;
            #local StripeWidth = .02;
            #local StripeDepth = .015;
            SetFontStyle (0, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, StripeWidth, StripeDepth, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (6) //Hollow inside
            #local FontVariationNumber = 6;
            #local TextDepth = .08;
            #local InvisibleBorderWidth = 0;
            #local BorderWidth = .03;
            SetFontStyle (0, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, 999, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (7) //Angled bevel
            #local FontVariationNumber = 7;
            #local TextDepth = .08;
            #local BorderHeight = .05;
            #local NSteps = 5;
            SetFontStyle (0, FontVariationNumber, TextDepth, BorderHeight, NSteps, 999, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (8) //Rounded bevel
            #local FontVariationNumber = 8;
            #local TextDepth = .08;
            #local BorderHeight = .05;
            #local NSteps = 7;
            SetFontStyle (0, FontVariationNumber, TextDepth, BorderHeight, NSteps, 999, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (9) //Solid hourglass (convex)
            #local FontVariationNumber = 9;
            #local TextDepth = .2;
            #local EffectWidth = .04;
            #local NSteps = 17;
            SetFontStyle (0, FontVariationNumber, TextDepth, EffectWidth, NSteps, 999, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (10) //Hollow hourglass (convex)
            #local FontVariationNumber = 10;
            #local TextDepth = .2;
            #local EffectWidth = .04;
            #local WallThickness = .02;
            #local NSteps = 17;
            SetFontStyle (0, FontVariationNumber, TextDepth, EffectWidth, WallThickness, NSteps, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (11) //Solid hourglass (concave)
            #local FontVariationNumber = 11;
            #local TextDepth = .2;
            #local EffectWidth = .04;
            #local NSteps = 17;
            SetFontStyle (0, FontVariationNumber, TextDepth, EffectWidth, NSteps, 999, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (12) //Hollow hourglass (concave)
            #local FontVariationNumber = 12;
            #local TextDepth = .2;
            #local EffectWidth = .04;
            #local WallThickness = .02;
            #local NSteps = 17;
            SetFontStyle (0, FontVariationNumber, TextDepth, EffectWidth, WallThickness, NSteps, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (13) //Solid half-hourglass (concave)
            #local FontVariationNumber = 13;
            #local TextDepth = .08;
            #local EffectWidth = .04;
            #local NSteps = 9;
            SetFontStyle (0, FontVariationNumber, TextDepth, EffectWidth, NSteps, 999, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (14) //Striped, Hollow inside
            #local FontVariationNumber = 14;
            #local TextDepth = .08;
            #local InvisibleBorderWidth = 0;
            #local BorderWidth = .025;
            #local StripeWidth = .0125;
            #local StripeHeight = .0125; //Can be negative, 0, or positive
            #local SecondBorderWidth = .02;
            SetFontStyle (0, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, StripeWidth, StripeHeight, SecondBorderWidth, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (15) //Hollow stripe with raised center
            #local FontVariationNumber = 15;
            #local TextDepth = .08;
            #local InvisibleBorderWidth = 0;
            #local BorderWidth = .03;
            #local StripeWidth = .02;
            #local StripeDepth = .02;
            #local InnerHeight = .03;
            SetFontStyle (0, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, StripeWidth, StripeDepth, InnerHeight, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (16) //Angled reverse bevel
            #local FontVariationNumber = 16;
            #local TextDepth = .2;
            #local BorderDepth = .05;
            #local NSteps = 5;
            SetFontStyle (0, FontVariationNumber, TextDepth, BorderDepth, NSteps, 999, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (17) //Rounded reverse bevel/concave
            #local FontVariationNumber = 17;
            #local TextDepth = .2;
            #local BorderDepth = .05;
            #local NSteps = 7;
            SetFontStyle (0, FontVariationNumber, TextDepth, BorderDepth, NSteps, 999, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (18) //Rounded reverse bevel/convex
            #local FontVariationNumber = 18;
            #local TextDepth = .2;
            #local BorderDepth = .05;
            #local NSteps = 7;
            SetFontStyle (0, FontVariationNumber, TextDepth, BorderDepth, NSteps, 999, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (19) //Rounded top outline
            #local FontVariationNumber = 19;
            #local TextDepth = .08;
            #local Radius = .02;
            #local NSteps = 5;
            SetFontStyle (0, FontVariationNumber, TextDepth, Radius, NSteps, 999, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (20) //Raised inner border
            #local FontVariationNumber = 20;
            #local TextDepth = .04;
            #local InvisibleBorderWidth = 0;
            #local BorderWidth = .03;
            #local RaisedBorderWidth = .03;
            #local RaisedBorderHeight = .04;
            SetFontStyle (0, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, RaisedBorderWidth, RaisedBorderHeight, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (21) //Specular highlights
            #local FontVariationNumber = 21;
            #local TextDepth = .08;
            #local InvisibleBorderWidth = 0;
            #local BorderWidth = .03;
            #local BorderDepth = .025;
            #local Angle = 160;
            SetFontStyle (0, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, BorderDepth, Angle, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (22) //Drop shadow
            #local FontVariationNumber = 22;
            #local TextDepth = .02;
            #local InvisibleBorderWidth = 0;
            #local Quadrant = 4; //1, 2, 3, or 4
            #local XYOffset_Solid = .035;
            #local XYOffset_Space = 0;
            #local LeaveInOffsetPosition = yes; //Set to "yes" if used as drop shadows, set to "no" if used as stand-alone characters.
            SetFontStyle (0, FontVariationNumber, TextDepth, InvisibleBorderWidth, Quadrant, XYOffset_Solid, XYOffset_Space, LeaveInOffsetPosition, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (23) //Raised center (use when border and center are the same height)
            #local FontVariationNumber = 23;
            #local TextDepth = .08;
            #local InvisibleBorderWidth = 0;
            #local BorderWidth = .03;
            #local BorderHeight = .025;
            SetFontStyle (0, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, BorderHeight, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (24) //Lowered center version 2
            #local FontVariationNumber = 24;
            #local TextDepth = .08;
            #local InvisibleBorderWidth = 0;
            #local BorderWidth = .03;
            #local BorderDepth = .025;
            SetFontStyle (0, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, BorderDepth, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (25) //Lowered center with invisible radiosity wall
            #local FontVariationNumber = 25;
            #local TextDepth = .08;
            #local InvisibleBorderWidth = 0;
            #local BorderWidth = .03;
            #local BorderDepth = .01;
            #local InvisibleWallHeight = .03;
            SetFontStyle (0, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, BorderDepth, InvisibleWallHeight, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (26) //Lowered center with dark inner border
            #local FontVariationNumber = 26;
            #local TextDepth = .08;
            #local InvisibleBorderWidth = 0;
            #local BorderWidth = .03;
            #local BorderDepth = .01;
            #local DarkBorderWidth = .03;
            #local NSteps = 15;
            SetFontStyle (0, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, BorderDepth, DarkBorderWidth, NSteps, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (27) //Hollow inside
            #local FontVariationNumber = 27;
            #local TextDepth = .08;
            #local InvisibleBorderWidth = 0;
            #local BorderWidth = .04;
            #local WallThickness = .02;
            #local AirGap = .035;
            SetFontStyle (0, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, WallThickness, AirGap, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (28) //Interior object
            #local FontVariationNumber = 28;
            #local TextDepth = .08;
            #local InvisibleBorderWidth = 0;
            #local BorderWidth = .01;
            #declare ExtraParameter_InteriorObject = object { //Define any object to fill the interior of the characters
               #local NWaves = 50;
               #local Wave = object {
                  #local Seconds = 2; //Don't change this
                  #local Hertz = 4; //Horizontal
                  #local DeltaTheta = 30; //Must be a factor of 90; lower values give better results (30 or 45 are good)
                  #local Y0 = -.35625 + InvisibleBorderWidth + BorderWidth;
                  #local Y1 = 1.075 - InvisibleBorderWidth - BorderWidth;
                  #local R = (Y1 - Y0) / NWaves / 2;
                  #local Amplitude = TextDepth / 2 - R;
                  sphere_sweep {
                     b_spline
                     360 * Seconds * Hertz / DeltaTheta + 1 + 2
                     #for (A, -DeltaTheta, 360 * Seconds * Hertz + DeltaTheta, DeltaTheta)
                        <A / 360 / Hertz, 0, sin (radians (A)) * Amplitude>, R
                     #end //#for
                  } //sphere_sweep
                  texture {TextColor_Inner scale <1 / Hertz, 1, 1>}
                  translate (TextDepth / 2) * z
               } //object
               #local Hertz = 2; //Vertical
               #local Amplitude = .1;
               #local DeltaTheta = 360 * Hertz / NWaves;
               #local Theta = 0;
               union {
                  #for (CurY, Y0 + R, Y1, R * 2)
                     #local XOffset = -Amplitude + sin (radians (Theta)) * Amplitude;
                     object {Wave translate <XOffset, CurY, 0>}
                     #local Theta = Theta + DeltaTheta;
                  #end //#for
               } //union
            } //object
            SetFontStyle (0, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, 999, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (29) //Interior object, no outer border
            #local FontVariationNumber = 29;
            #local TextDepth = .08;
            #local Randomizer = seed (1);
            #declare ExtraParameter_InteriorObject = object { //Define any object to fill the interior of the characters
               #local NOrbs = 10000;
               #local CenterLocation = array [NOrbs]
               #local R = array [NOrbs]
               #local OrbitR = array [NOrbs]
               #local StartAngle = array [NOrbs]
               #local RotationAxis = array [NOrbs]
               #local Polarity = array [NOrbs]
               #for (K, 0, NOrbs - 1)
                  #local CenterLocation [K] = <rand (Randomizer) * 2, rand (Randomizer) * (.35625 + 1.075) - .35625, rand (Randomizer) * .02 + .02>;
                  #local R [K] = rand (Randomizer) * .03 + .03;
                  #local OrbitR [K] = rand (Randomizer) * .02 + .02;
                  #local StartAngle [K] = rand (Randomizer) * 360;
                  #local RotationAxis [K] = int (rand (Randomizer) + .5);
                  #if (rand (Randomizer) < .20) //Percentage of negative attractors
                     #local Polarity [K] = -1;
                  #else
                     #local Polarity [K] = 1;
                  #end //#if
               #end //#for
               intersection {
                  blob {
                     threshold .3
                     #for (K, 0, NOrbs - 1)
                        sphere {
                           <0, 0, OrbitR [K]>, R [K], Polarity [K]
                           #switch (RotationAxis [K])
                              #case (0)
                                 rotate StartAngle [K] * x
                              #break //#case
                              #case (1)
                                 rotate StartAngle [K] * y
                              #break //#case
                           #end //#switch
                           translate CenterLocation [K]
                        } //sphere
                     #end //#for
                     translate .052 * z
                  } //blob
                  plane {z, TextDepth}
               } //intersection
               texture {TextColor_Inner}
            } //object
            SetFontStyle (0, FontVariationNumber, TextDepth, 999, 999, 999, 999, 999, 999, 999, 999, TextColor_Inner, TextColor_Inner, TextColor_Inner)
         #break //#case
         #case (30) //Framework with empty center
            #local FontVariationNumber = 30;
            #local TextDepth = .08;
            #local BorderWidth = .02;
            SetFontStyle (0, FontVariationNumber, TextDepth, BorderWidth, 999, 999, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (31) //Framework with solid center
            #local FontVariationNumber = 31;
            #local TextDepth = .08;
            #local BorderWidth = .02;
            #local AirGap = 0;
            SetFontStyle (0, FontVariationNumber, TextDepth, BorderWidth, AirGap, 999, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (32) //Stack
            #local FontVariationNumber = 32;
            #local TextDepth = .12;
            #local InvisibleBorderWidth = 0;
            #local BorderWidth = .03;
            #local SpacerDepth = .005;
            SetFontStyle (0, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, SpacerDepth, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (33) //Rounded
            #local FontVariationNumber = 33;
            #local TextDepth = .08;
            #local NSteps = 19;
            SetFontStyle (0, FontVariationNumber, TextDepth, NSteps, 999, 999, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (34) //Flat inner, rounded outer
            #local FontVariationNumber = 34;
            #local TextDepth = .08;
            #local NSteps = 19;
            SetFontStyle (0, FontVariationNumber, TextDepth, NSteps, 999, 999, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (35) //Rounded inner, flat outer
            #local FontVariationNumber = 35;
            #local TextDepth = .08;
            #local NSteps = 19;
            SetFontStyle (0, FontVariationNumber, TextDepth, NSteps, 999, 999, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (36) //Curved sides * * * This Font Variation will break some characters and cause automatic kerning to fail.
            #local FontVariationNumber = 36;
            #local TextDepth = .08;
            #local EffectWidth = .04;
            #local StartAngle = 0;
            #local EndAngle = 450;
            #local NSteps = 601;
            SetFontStyle (0, FontVariationNumber, TextDepth, EffectWidth, StartAngle, EndAngle, NSteps, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (37) //Curved sides with lowered center * * * This Font Variation will break some characters and cause automatic kerning to fail.
            #local FontVariationNumber = 37;
            #local TextDepth = .08;
            #local BorderWidth = .03;
            #local BorderDepth = .025;
            #local EffectWidth = .04;
            #local StartAngle = 0;
            #local EndAngle = 450;
            #local NSteps = 601;
            SetFontStyle (0, FontVariationNumber, TextDepth, BorderWidth, BorderDepth, EffectWidth, StartAngle, EndAngle, NSteps, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (38) //Curved sides and back * * * This Font Variation will break some characters and cause automatic kerning to fail.
            #local FontVariationNumber = 38;
            #local TextDepth = .08;
            #local EffectWidth = .04;
            #local WallThickness = .02;
            #local StartAngle_Y = 0; //Bottom
            #local EndAngle_Y = 450; //Top
            #local NSteps_Y = 121;
            #local StartAngle_Z = -90; //Back
            #local EndAngle_Z = 90; //Front
            #local NSteps_Z = 25;
            SetFontStyle (0, FontVariationNumber, TextDepth, EffectWidth, WallThickness, StartAngle_Y, EndAngle_Y, NSteps_Y, StartAngle_Z, EndAngle_Z, NSteps_Z, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (39) //Raised border with hollow center
            #local FontVariationNumber = 39;
            #local TextDepth = .08;
            #local InvisibleBorderWidth = 0;
            #local BorderWidth_Outer = .025;
            #local BorderWidth_Total = .07; //Can be less than BorderWidth_Outer
            #local BorderDepth = .025;
            SetFontStyle (0, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth_Outer, BorderWidth_Total, BorderDepth, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (40) //Offset shadow
            #local FontVariationNumber = 40;
            #local TextDepth = .08; //Each layer will be half this amount
            #local InvisibleBorderWidth = 0;
            #local Octant = 8; //1, 2, 3, 4, 5, 6, 7, or 8
            #local Offset = .035;
            SetFontStyle (0, FontVariationNumber, TextDepth, InvisibleBorderWidth, Octant, Offset, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #case (41) //Sine wave center
            #local FontVariationNumber = 41;
            #local TextDepth = .08;
            #local InvisibleBorderWidth = 0;
            #local BorderWidth = .03;
            #local BorderDepth = .01;
            #local StartAngle = 0;
            #local EndAngle = 450 - 60;
            #local Amplitude = .015;
            #local NSteps = 51; //Must be > 1
            #local CrossSection = false; //Binary (true/false); for testing purposes (use with "P" as the test character) 
            SetFontStyle (0, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, BorderDepth, StartAngle, EndAngle, Amplitude, NSteps, CrossSection, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#case
         #else
            #local TextDepth = .08;
            #local InvisibleBorderWidth = 0;
            SetFontStyle (0, 0, TextDepth, InvisibleBorderWidth, 999, 999, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
         #break //#else
      #end //#switch
      #local TextColor_Outer = texture {pigment {color White}}
      InitializeVariables (1)
      #declare LineText [0] = TestCharacter;
      CreateParagraph (1, 1, no)
      #local TestCharacterASCII = asc (substr (TestCharacter, 1, 1));
      object {Paragraph translate <-BorderCharacterWidth [ASCIIToIndex (TestCharacterASCII)] / 2, 1, 0>}
      #local TextDepth = .04;
      #local InvisibleBorderWidth = .025;
      SetFontStyle (0, 0, TextDepth, InvisibleBorderWidth, 999, 999, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
      InitializeVariables (1)
      #declare LineText [0] = str (FontVariationNumber, 0, 0);
      CreateParagraph (1, 1, no)
      object {Paragraph scale <.3, .3, 1> translate <.05, .3, 0>}
   } //union
} //object

#local Background = object {
   plane {
      z, 0 inverse
      texture {BackgroundColor translate .5 * x}
   } //plane
} //object

#local LeftMargin = -.25;
#local TopMargin = -2.85;
#local ZOffset = -.1;

object {Grid translate <LeftMargin, TopMargin, ZOffset>}

object {Background}
