/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* * This scene is designed for 16:9 aspect ratio.                                                                   * */
/* *                                                                                                                 * */
/* * The purpose of this file is to demonstrate all the major capabilities of the BORDERED CHARACTERS macros.        * */
/* *                                                                                                                 * */
/* * Set the value of [UseRadiosity] to "no" for a quick render, or "yes" for a higher-quality render.               * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#version 3.7;

#local UseRadiosity = yes;

global_settings {
   assumed_gamma 2.2
   charset utf8
   max_trace_level 20
   #if (UseRadiosity)
      radiosity {
         pretrace_start .08
         pretrace_end .004
         count 200
         error_bound .002
         recursion_limit 2
         normal on
      } //radiosity
   #end //#if
} //global_settings

#include "colors.inc"
#include "BorderChars.inc"

#local CameraZ = 12.4;

camera {
   location <0, 0, -CameraZ>
   direction <0, 0, 1>
   right (16/9) * x
   look_at <0, 0, 0>
} //camera

#if (UseRadiosity)
   #local Dome = object {
      difference {
         sphere {0, 20001}
         sphere {0, 20000}
      } //difference
      texture {
         pigment {
            gradient z
            color_map {
               [0, 1 color White * 2.21 color White * .6]
            } //color_map
         } //pigment
         finish {emission 1 diffuse 0}
         scale <1, 1, 20000>
      } //texture
      no_reflection
   } //object
   object {Dome}
#else
   light_source {<60, 80, -200> color White * 1.65 shadowless}
#end //#if

#local TextColor_Outer = texture {pigment {color White}}

#local TextColor_Inner = texture {TextColor_Outer}

#local TextColor_Back = texture {pigment {color Black}}

#local BackgroundColor = texture {pigment {color <0.8834, 0.8494, 0.7747>}}

#macro CreateTexture_Gradient_Y (Color0, Color1)

   texture {
      pigment {
         gradient y
         color_map {
            [0 color Color0]
            [.4 color (Color0 * 75 + Color1 * 25) / 100]
            [.6 color (Color0 + Color1) / 2]
            [1 color Color1]
         } //color_map
      } //pigment
      #local YScaleAdd_Bottom = .75 / 2 * .95; //Height of the bottom of the "g"
      #local YScaleAdd_Top = .075; //Height of the top of the "*"
      scale <1, 1 + YScaleAdd_Bottom + YScaleAdd_Top, 1>
      translate -YScaleAdd_Bottom * y
   } //texture

#end //#macro CreateTexture_Gradient_Y

#macro CreateTexture_Gradient_X (Color0, Color1, Width)

   #local Color0_ = (Color0 + White * 2) / 3;
   #local Color1_ = (Color1 + White * 2) / 3;

   texture {
      pigment {
         gradient x
         color_map {
            [0 color Color0_]
            [1 color Color1_]
         } //color_map
      } //pigment
      scale <Width + .02, 1, 1>
      translate -.01 * x
   } //texture

#end //#macro CreateTexture_Gradient_Y

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* *                                                                                                                 * */
/* * SET UP FONT STYLES                                                                                              * */
/* *                                                                                                                 * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#local FontVariationNumber = 0;
#local TextDepth = .08;
#local InvisibleBorderWidth0 = 0;
#local InvisibleBorderWidth1 = .06;
SetFontStyle (0, FontVariationNumber, TextDepth, InvisibleBorderWidth0, 999, 999, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
SetFontStyle (1, FontVariationNumber, TextDepth, InvisibleBorderWidth1, 999, 999, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)

#for (I, 0, 5)
   #local InvisibleBorderWidth = (5 - I) / 5 * InvisibleBorderWidth1;
   SetFontStyle (I + 32, FontVariationNumber, TextDepth, InvisibleBorderWidth, 999, 999, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
#end //#for

#local FontVariationNumber = 2;
#local TextDepth = .08;
#local InvisibleBorderWidth = 0;
#local BorderWidth = .03;
#local BorderDepth = .05;

#local TextColor_Inner = CreateTexture_Gradient_Y (<0.9671, 0.6440, 0.6228>, <0.5376, 0.0436, 0.0674>) //Red
SetFontStyle (2, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, BorderDepth, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)

#local TextColor_Inner = CreateTexture_Gradient_Y (<0.6280, 0.8939, 0.8723>, <0.1405, 0.4175, 0.1519>) //Green
SetFontStyle (3, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, BorderDepth, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)

#local TextColor_Inner = CreateTexture_Gradient_Y (<0.5607, 0.6878, 0.9814>, <0.1811, 0.2305, 0.2083>); //Blue
SetFontStyle (4, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, BorderDepth, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)

#local TextColor_Inner = CreateTexture_Gradient_Y (<0.8196, 0.6339, 0.8780>, <0.0965, 0.1283, 0.3460>) //Purple
SetFontStyle (5, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, BorderDepth, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)

#local TextColor_Inner = CreateTexture_Gradient_Y (<0.9295, 0.9816, 0.7871>, <0.8464, 0.6731, 0.1741>) //Yellow
SetFontStyle (6, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, BorderDepth, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)

#local TextColor_Inner = CreateTexture_Gradient_Y (<0.9461, 0.8010, 0.6769>, <0.8800, 0.3794, 0.0642>) //Orange
SetFontStyle (7, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, BorderDepth, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)

#local NSteps = 9;
#local MinBorder = .03;
#local MaxBorder = .075; //Start with wide border and thin center
#local MinInvisibleBorder = 0;
#local MaxInvisibleBorder = .05; //End with thin stroke width
#local IndexCounter = 8;

#for (I, 0, NSteps - 1)
   #local CurBorder = MaxBorder - (MaxBorder - MinBorder) * (I / (NSteps - 1));
   SetFontStyle (IndexCounter, FontVariationNumber, TextDepth, MinInvisibleBorder, CurBorder, BorderDepth, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
   #local IndexCounter = IndexCounter + 1;
#end //#for

#for (I, 1, NSteps - 1)
   #local CurInvisibleBorder = MaxInvisibleBorder * (I / (NSteps - 1));
   SetFontStyle (IndexCounter, FontVariationNumber, TextDepth, CurInvisibleBorder, MinBorder, BorderDepth, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)
   #local IndexCounter = IndexCounter + 1;
#end //#for

#local TextColor_Inner = CreateTexture_Gradient_Y (<0.9766, 0.6792, 0.9913>, <0.9645, 0.2563, 0.4112>) //Pink
SetFontStyle (25, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, BorderDepth, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)

#local FontVariationNumber = 10;
#local TextDepth = .2;
#local EffectWidth = .04;
#local WallThickness = .02;
#local NSteps = 13;

MakeG1 (0) //Only necessary to get current character width for texture scaling purposes
#local TextColor_Outer = CreateTexture_Gradient_X (Red, Orange, CharacterWidth)
SetFontStyle (26, FontVariationNumber, TextDepth, EffectWidth, WallThickness, NSteps, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)

MakeR2 (0)
#local TextColor_Outer = CreateTexture_Gradient_X (Orange, Yellow, CharacterWidth)
SetFontStyle (27, FontVariationNumber, TextDepth, EffectWidth, WallThickness, NSteps, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)

MakeO2 (0)
#local TextColor_Outer = CreateTexture_Gradient_X (Yellow, Green, CharacterWidth)
SetFontStyle (28, FontVariationNumber, TextDepth, EffectWidth, WallThickness, NSteps, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)

#local TextColor_Outer = CreateTexture_Gradient_X (Green, Blue, CharacterWidth)
SetFontStyle (29, FontVariationNumber, TextDepth, EffectWidth, WallThickness, NSteps, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)

MakeV2 (0)
#local TextColor_Outer = CreateTexture_Gradient_X (Blue, DarkOrchid, CharacterWidth)
SetFontStyle (30, FontVariationNumber, TextDepth, EffectWidth, WallThickness, NSteps, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)

MakeY2 (0)
#local TextColor_Outer = CreateTexture_Gradient_X (DarkOrchid, Red, CharacterWidth)
SetFontStyle (31, FontVariationNumber, TextDepth, EffectWidth, WallThickness, NSteps, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)

#local TextColor_Outer = texture {pigment {color White}}

#local TextColor_Inner = texture {
   #local Color0 = color <0.0000, 0.8894, 0.7535>;
   #local Color1 = color <0.6341, 0.0124, 0.8235>;
   pigment {
      gradient y
      color_map {
         [0 color Color0]
         [.6 (Color0 + Color1) / 2]
         [1 color Color1]
      } //color_map
   } //pigment
} //texture

#local FontVariationNumber = 3;
#local TextDepth = .08;
#local InvisibleBorderWidth = 0;
#local BorderWidth = .02;
#local StripeWidth = .02;
#local StripeHeight = -.0125; //Can be negative, 0, or positive
SetFontStyle (38, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, StripeWidth, StripeHeight, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)

#local FontVariationNumber = 14;
#local TextDepth = .08;
#local InvisibleBorderWidth = 0;
#local BorderWidth = .02;
#local StripeWidth = .02;
#local StripeHeight = -.0125; //Can be negative, 0, or positive
#local SecondBorderWidth = BorderWidth;
SetFontStyle (39, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, StripeWidth, StripeHeight, SecondBorderWidth, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)

#local FontVariationNumber = 15;
#local TextDepth = .08;
#local InvisibleBorderWidth = 0;
#local BorderWidth = .02;
#local StripeWidth = .02;
#local StripeDepth = .02;
#local InnerHeight = .03;
SetFontStyle (40, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, StripeWidth, StripeDepth, InnerHeight, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)

#local FontVariationNumber = 8;
#local TextDepth = .08;
#local BorderHeight = .05;
#local NSteps = 7;
SetFontStyle (41, FontVariationNumber, TextDepth, BorderHeight, NSteps, 999, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)

#local TextColor_Inner = texture {
   #local Color0 = color <0.0000, 0.8894, 0.7535>;
   #local Color1 = color <0.6341, 0.0124, 0.8235>;
   pigment {
      gradient x
      color_map {
         #for (I, 0, 1, 5/360)
            #local A = I * 360;
            #local S = sin (radians (A));
            #local Fraction0 = .5 + S / 2;
            #local Fraction1 = .5 - S / 2;
            #if (A < 1 | (A > 74 & A < 106) | (A > 179 & A < 181) | (A > 254 & A < 286) | A > 359)
               [I color Color0 * Fraction0 + Color1 * Fraction1]
            #end //#if
         #end //#for
      } //color_map
   } //pigment
   translate .5 * x
} //texture

#local FontVariationNumber = 28;
#local TextDepth = .08;
#local InvisibleBorderWidth = 0;
#local BorderWidth = .02;
#declare ExtraParameter_InteriorObject = object { //Define any object to fill the interior of the characters
   #local NWaves = 30;
   #local Wave = object {
      #local Seconds = 2; //Don't change this
      #local Hertz = 4; //Horizontal
      #local DeltaTheta = 30; //Must be a factor of 90; lower values give better results (30 or 45 are good)
      #local Y0 = -.35625 + InvisibleBorderWidth + BorderWidth;
      #local Y1 = 1.075 - InvisibleBorderWidth - BorderWidth;
      #local R = (Y1 - Y0) / NWaves / 2;
      #local Amplitude = TextDepth / 2 - R;
      sphere_sweep {
         b_spline
         360 * Seconds * Hertz / DeltaTheta + 1 + 2
         #for (A, -DeltaTheta, 360 * Seconds * Hertz + DeltaTheta, DeltaTheta)
            <A / 360 / Hertz, 0, sin (radians (A)) * Amplitude>, R
         #end //#for
      } //sphere_sweep
      texture {TextColor_Inner scale <1 / Hertz, 1, 1>}
      translate (TextDepth / 2) * z
   } //object
   #local Hertz = 2; //Vertical
   #local Amplitude = .1;
   #local DeltaTheta = 360 * Hertz / NWaves;
   #local Theta = 0;
   union {
      #for (CurY, Y0 + R, Y1, R * 2)
         #local XOffset = -Amplitude + sin (radians (Theta)) * Amplitude;
         object {Wave translate <XOffset, CurY, 0>}
         #local Theta = Theta + DeltaTheta;
      #end //#for
   } //union
} //object
SetFontStyle (42, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, 999, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* *                                                                                                                 * */
/* * THE SCENE                                                                                                       * */
/* *                                                                                                                 * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#local TextScale = 1;
#local UseActualParagraphHeight = no;

#local LeftMargin = -CameraZ / 1.125 + .6;
#local TopMargin = CameraZ / 2 - .4;
#local ZOffset = -.1;

#declare GAP_Width = .06;  //Distance between characters
#declare SPACE_Width = .2; //Distance between words
#declare LineSpacing = .5; //Distance between lines

#declare LineAlignment = LEFT; //Choices are LEFT, RIGHT, CENTERED, or JUSTIFIED
#declare MaxMicroJustificationScale = 1; //Set to 1 for no scaling, > 1 for limited scaling, or UNLIMITED
#declare MaxAdditionalGAP_WidthPercentage = UNLIMITED; //Set to 0 to maintain constant gap width, any percentage, or UNLIMITED
#declare SPACE_ExpansionRate = 1.5; //Values > 1 will cause SPACE_Width to increase faster than GAP_Width
#declare JustifyLastLinePercentage = 95; //Minimum percentage of paragraph width to justify last line
#declare MinJustifiedParagraphWidth = 0; //Minimum width of paragraph when justified

#local NLines = 1;

InitializeVariables (NLines)

//Use   \"   for DOUBLE QUOTE MARKS.
//Use   &    for a HEART.
//Use   ^    for a STAR.
//Use   @    for a BULLET.

#declare LineText [0] = "~0~Normal ~1~Thin {~32~I~33~t~34~a~35~l~36~i~37~c} ~26~G~27~r~28~o~29~o~30~v~31~y";

CreateParagraph (NLines, TextScale, UseActualParagraphHeight)

#local Message1 = object {Paragraph translate <LeftMargin, TopMargin, ZOffset>}

//Next...

#declare LineAlignment = LEFT; //Choices are LEFT, RIGHT, CENTERED, or JUSTIFIED
#declare MaxMicroJustificationScale = 1; //Set to 1 for no scaling, > 1 for limited scaling, or UNLIMITED
#declare MaxAdditionalGAP_WidthPercentage = UNLIMITED; //Set to 0 to maintain constant gap width, any percentage, or UNLIMITED
#declare SPACE_ExpansionRate = 1.5; //Values > 1 will cause SPACE_Width to increase faster than GAP_Width
#declare JustifyLastLinePercentage = 95; //Minimum percentage of paragraph width to justify last line
#declare MinJustifiedParagraphWidth = 0; //Minimum width of paragraph when justified

#local NLines = 1;

InitializeVariables (NLines)

#declare LineText [0] = "~38~^~39~^~40~^~41~^~42~^";

CreateParagraph (NLines, TextScale, UseActualParagraphHeight)

#local LeftMargin = CameraZ / 1.125 - ParagraphWidth - .6;

#local Message1A = object {Paragraph translate <LeftMargin, TopMargin, ZOffset>}

//Next...

#local LeftMargin = -CameraZ / 1.125 + .6;
#local TopMargin = TopMargin - ParagraphHeight - LineSpacing;

#declare LineAlignment = LEFT; //Choices are LEFT, RIGHT, CENTERED, or JUSTIFIED
#declare MaxMicroJustificationScale = 1; //Set to 1 for no scaling, > 1 for limited scaling, or UNLIMITED
#declare MaxAdditionalGAP_WidthPercentage = UNLIMITED; //Set to 0 to maintain constant gap width, any percentage, or UNLIMITED
#declare SPACE_ExpansionRate = 1.5; //Values > 1 will cause SPACE_Width to increase faster than GAP_Width
#declare JustifyLastLinePercentage = 95; //Minimum percentage of paragraph width to justify last line
#declare MinJustifiedParagraphWidth = 0; //Minimum width of paragraph when justified

#local NLines = 2;

InitializeVariables (NLines)

#declare LineText [0] = "~2~Left";
#declare LineText [1] = "Alignment";

CreateParagraph (NLines, TextScale, UseActualParagraphHeight)

#local Message2 = object {Paragraph translate <LeftMargin, TopMargin, ZOffset>}

//Next...

#declare LineAlignment = CENTERED; //Choices are LEFT, RIGHT, CENTERED, or JUSTIFIED
#declare MaxMicroJustificationScale = 1; //Set to 1 for no scaling, > 1 for limited scaling, or UNLIMITED
#declare MaxAdditionalGAP_WidthPercentage = UNLIMITED; //Set to 0 to maintain constant gap width, any percentage, or UNLIMITED
#declare SPACE_ExpansionRate = 1.5; //Values > 1 will cause SPACE_Width to increase faster than GAP_Width
#declare JustifyLastLinePercentage = 95; //Minimum percentage of paragraph width to justify last line
#declare MinJustifiedParagraphWidth = 0; //Minimum width of paragraph when justified

#local NLines = 2;

InitializeVariables (NLines)

#declare LineText [0] = "~3~Center";
#declare LineText [1] = "Alignment";

CreateParagraph (NLines, TextScale, UseActualParagraphHeight)

#local LeftMargin = -ParagraphWidth / 2;

#local Message3 = object {Paragraph translate <LeftMargin, TopMargin, ZOffset>}

//Next...

#declare LineAlignment = RIGHT; //Choices are LEFT, RIGHT, CENTERED, or JUSTIFIED
#declare MaxMicroJustificationScale = 1; //Set to 1 for no scaling, > 1 for limited scaling, or UNLIMITED
#declare MaxAdditionalGAP_WidthPercentage = UNLIMITED; //Set to 0 to maintain constant gap width, any percentage, or UNLIMITED
#declare SPACE_ExpansionRate = 1.5; //Values > 1 will cause SPACE_Width to increase faster than GAP_Width
#declare JustifyLastLinePercentage = 95; //Minimum percentage of paragraph width to justify last line
#declare MinJustifiedParagraphWidth = 0; //Minimum width of paragraph when justified

#local NLines = 2;

InitializeVariables (NLines)

#declare LineText [0] = "~4~Right";
#declare LineText [1] = "Alignment";

CreateParagraph (NLines, TextScale, UseActualParagraphHeight)

#local LeftMargin = CameraZ / 1.125 - ParagraphWidth - .6;

#local Message4 = object {Paragraph translate <LeftMargin, TopMargin, ZOffset>}

//Next...

#local LeftMargin = -CameraZ / 1.125 + .6;
#local TopMargin = TopMargin - ParagraphHeight - LineSpacing;
#local TopMargin_Save = TopMargin;

#declare LineAlignment = LEFT; //Choices are LEFT, RIGHT, CENTERED, or JUSTIFIED
#declare MaxMicroJustificationScale = 1; //Set to 1 for no scaling, > 1 for limited scaling, or UNLIMITED
#declare MaxAdditionalGAP_WidthPercentage = UNLIMITED; //Set to 0 to maintain constant gap width, any percentage, or UNLIMITED
#declare SPACE_ExpansionRate = 1.5; //Values > 1 will cause SPACE_Width to increase faster than GAP_Width
#declare JustifyLastLinePercentage = 95; //Minimum percentage of paragraph width to justify last line
#declare MinJustifiedParagraphWidth = 0; //Minimum width of paragraph when justified

#local NLines = 1;

InitializeVariables (NLines)

#declare LineText [0] = "~5~Automatic kerning";

CreateParagraph (NLines, TextScale, UseActualParagraphHeight)

#local Message6 = object {Paragraph translate <LeftMargin, TopMargin, ZOffset>}

//Next...

#local LeftMargin = -CameraZ / 1.125 + .6;
#local TopMargin = TopMargin - ParagraphHeight - LineSpacing;

#declare LineAlignment = JUSTIFIED; //Choices are LEFT, RIGHT, CENTERED, or JUSTIFIED
#declare MaxMicroJustificationScale = 1; //Set to 1 for no scaling, > 1 for limited scaling, or UNLIMITED
#declare MaxAdditionalGAP_WidthPercentage = UNLIMITED; //Set to 0 to maintain constant gap width, any percentage, or UNLIMITED
#declare SPACE_ExpansionRate = 1.5; //Values > 1 will cause SPACE_Width to increase faster than GAP_Width
#declare JustifyLastLinePercentage = 0; //Minimum percentage of paragraph width to justify last line
#declare MinJustifiedParagraphWidth = ParagraphHistory_Width [CurrentParagraphNumber - 1]; //Minimum width of paragraph when justified

#local NLines = 2;

InitializeVariables (NLines)

#declare LineText [0] = "~6~Two methods of";
#declare LineText [1] = "micro-justification";

CreateParagraph (NLines, TextScale, UseActualParagraphHeight)

#local Message5 = object {Paragraph translate <LeftMargin, TopMargin, ZOffset>}

//Next...

#local LeftMargin = -CameraZ / 1.125 + .6;
#local TopMargin = TopMargin - ParagraphHeight - LineSpacing;

#declare LineAlignment = LEFT; //Choices are LEFT, RIGHT, CENTERED, or JUSTIFIED
#declare MaxMicroJustificationScale = 1; //Set to 1 for no scaling, > 1 for limited scaling, or UNLIMITED
#declare MaxAdditionalGAP_WidthPercentage = UNLIMITED; //Set to 0 to maintain constant gap width, any percentage, or UNLIMITED
#declare SPACE_ExpansionRate = 1.5; //Values > 1 will cause SPACE_Width to increase faster than GAP_Width
#declare JustifyLastLinePercentage = 95; //Minimum percentage of paragraph width to justify last line
#declare MinJustifiedParagraphWidth = 0; //Minimum width of paragraph when justified

#local NLines = 1;

InitializeVariables (NLines)

#declare LineText [0] = "~7~Adjustable border/stroke widths:";

CreateParagraph (NLines, TextScale, UseActualParagraphHeight)

#local Message7 = object {Paragraph translate <LeftMargin, TopMargin, ZOffset>}

//Next...

#local LeftMargin = -CameraZ / 1.125 + .6;
#local TopMargin = TopMargin - ParagraphHeight - LineSpacing;

#declare LineAlignment = LEFT; //Choices are LEFT, RIGHT, CENTERED, or JUSTIFIED
#declare MaxMicroJustificationScale = 1; //Set to 1 for no scaling, > 1 for limited scaling, or UNLIMITED
#declare MaxAdditionalGAP_WidthPercentage = UNLIMITED; //Set to 0 to maintain constant gap width, any percentage, or UNLIMITED
#declare SPACE_ExpansionRate = 1.5; //Values > 1 will cause SPACE_Width to increase faster than GAP_Width
#declare JustifyLastLinePercentage = 95; //Minimum percentage of paragraph width to justify last line
#declare MinJustifiedParagraphWidth = 0; //Minimum width of paragraph when justified

#local NLines = 1;

InitializeVariables (NLines)

#declare LineText [0] = "~8~O~9~O~10~O~11~O~12~O~13~O~14~O~15~O~16~O~17~O~18~O~19~O~20~O~21~O~22~O~23~O~24~O";

CreateParagraph (NLines, TextScale, UseActualParagraphHeight)

#local Message8 = object {Paragraph translate <LeftMargin, TopMargin, ZOffset>}

//Next...

#declare LineSpacing = 0; //Distance between lines

#declare LineAlignment = JUSTIFIED; //Choices are LEFT, RIGHT, CENTERED, or JUSTIFIED
#declare MaxMicroJustificationScale = UNLIMITED; //Set to 1 for no scaling, > 1 for limited scaling, or UNLIMITED
#declare MaxAdditionalGAP_WidthPercentage = UNLIMITED; //Set to 0 to maintain constant gap width, any percentage, or UNLIMITED
#declare SPACE_ExpansionRate = 1.5; //Values > 1 will cause SPACE_Width to increase faster than GAP_Width
#declare JustifyLastLinePercentage = 95; //Minimum percentage of paragraph width to justify last line
#declare MinJustifiedParagraphWidth = 0; //Minimum width of paragraph when justified

#local TextScale = 1;
#local UseActualParagraphHeight = no;

#local NLines = 2;

InitializeVariables (NLines)

#declare LineText [0] = "~25~I LOVE";
#declare LineText [1] = "POV-RAY!";

CreateParagraph (NLines, TextScale, UseActualParagraphHeight)

#declare LineSpacing = .25; //Distance between lines

#local ParagraphHeight_Desired = 4; //3 * Height_Upper * TextScale + 1 * LineSpacing; Refering to the paragraph to match
#local TextScale = (ParagraphHeight_Desired - LineSpacing * (NLines - 1)) / ParagraphHeight;

CreateParagraph (NLines, TextScale, UseActualParagraphHeight)

#local LeftMargin = CameraZ / 1.125 - ParagraphWidth - .6;
#local TopMargin = TopMargin_Save;

#local Message9 = object {Paragraph translate <LeftMargin, TopMargin, ZOffset>}

object {Message1}
object {Message1A}
object {Message2}
object {Message3}
object {Message4}
object {Message5}
object {Message6}
object {Message7}
object {Message8}
object {Message9}

#local Background = object {
   plane {
      z, 0 inverse
      texture {BackgroundColor}
   } //plane
} //object

object {Background}
