/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* * This scene is designed for 16:9 screen ratio.                                                                   * */
/* *                                                                                                                 * */
/* * The purpose of this file is to demonstrate Font Variation #28 by animating the interior object. The completed   * */
/* * animation is cyclical.                                                                                          * */
/* *                                                                                                                 * */
/* * Set the value of [UseRadiosity] to "no" for a quick render, or "yes" for a higher-quality render.               * */
/* *                                                                                                                 * */
/* * Copy the command line options to the command line by right-clicking over them and select "Copy to Command-      * */
/* * Line." The command line options are set to create 360 frames numbered 0 through 359. To select a different      * */
/* * number of frames, change the "359" to the desired number of frames minus one.                                   * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

//+kc +kfi0 +kff359

#version 3.7;

#local UseRadiosity = yes;

global_settings {
   assumed_gamma 2.2
   charset utf8
   max_trace_level 20
   #if (UseRadiosity)
      radiosity {
         pretrace_start .08
         pretrace_end .004
         count 120
         error_bound .002
         adc_bailout .1
         recursion_limit 2
         normal on
      } //radiosity
   #end //#if
} //global_settings

#include "colors.inc"
#include "stones.inc"
#include "BorderChars.inc"

camera {
   location <0, 0, -3.6>
   direction <0, 0, 1>
   right (16/9) * x
   rotate -50 * x
   look_at <0, -.075, 0>
} //camera

#if (UseRadiosity)
   #local Dome = object {
      difference {
         sphere {0, 20001}
         sphere {0, 20000}
      } //difference
      texture {
         pigment {
            gradient z
            color_map {
               [0, 1 color White * 1.25 color White * .4]
            } //color_map
         } //pigment
         finish {emission 1 diffuse 0}
         scale <1, 1, 20000>
      } //texture
      no_image
      no_reflection
   } //object
   object {Dome}
   light_source {<60, 80, -200> color White * .8}
#else
   light_source {<60, 80, -200> color White * 1.65}
#end //#if

#local TextColor_Outer = texture {
   pigment {
      granite
      color_map {
         [0 color MediumForestGreen]
         [1 color YellowGreen]
      } //color_map
   } //pigment
   normal {crackle scale .2}
   finish {phong .3}
   #local S = .06;
   scale <S, S, S>
} //texture

#local TextColor_Inner = texture {T_Stone11}

#local TextColor_Back = texture {TextColor_Outer}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* *                                                                                                                 * */
/* * THE SCENE                                                                                                       * */
/* *                                                                                                                 * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#local Randomizer = seed (0);

#local FontVariationNumber = 28;
#local TextDepth = .08;
#local InvisibleBorderWidth = 0;
#local BorderWidth = .015;
#declare ExtraParameter_InteriorObject = object { //Define any object to fill the interior of the characters
   #local NOrbs = 10000;
   #local CenterLocation = array [NOrbs]
   #local R = array [NOrbs]
   #local OrbitR = array [NOrbs]
   #local StartAngle = array [NOrbs]
   #local Direction = array [NOrbs]
   #local NRotations = array [NOrbs]
   #local RotationAxis = array [NOrbs]
   #local Polarity = array [NOrbs]
   #for (I, 0, NOrbs - 1)
      #local CenterLocation [I] = <rand (Randomizer) * 2, rand (Randomizer) * (.35625 + 1.075) - .35625, rand (Randomizer) * .02 + .02>;
      #local R [I] = rand (Randomizer) * .03 + .03;
      #local OrbitR [I] = rand (Randomizer) * .02 + .02;
      #local StartAngle [I] = rand (Randomizer) * 360;
      #local Direction [I] = int (rand (Randomizer) + .5) * 2 - 1;
      #local NRotations [I] = int (rand (Randomizer) * 3) + 1;
      #local RotationAxis [I] = int (rand (Randomizer) + .5);
      #if (rand (Randomizer) < .12) //Percentage of negative attractors
         #local Polarity [I] = -1;
      #else
         #local Polarity [I] = 1;
      #end //#if
   #end //#for
   intersection {
      blob {
         threshold .3
         #for (I, 0, NOrbs - 1)
            sphere {
               <0, 0, OrbitR [I]>, R [I], Polarity [I]
               #switch (RotationAxis [I])
                  #case (0)
                     rotate (StartAngle [I] + clock * 360 * NRotations [I] * Direction [I]) * x
                  #break //#case
                  #case (1)
                     rotate (StartAngle [I] + clock * 360 * NRotations [I] * Direction [I]) * y
                  #break //#case
               #end //#switch
               translate CenterLocation [I]
            } //sphere
         #end //#for
         translate .052 * z
      } //blob
      plane {z, TextDepth}
   } //intersection
   texture {TextColor_Inner}
} //object

SetFontStyle (0, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, 999, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* *                                                                                                                 * */
/* * MESSAGE                                                                                                         * */
/* *                                                                                                                 * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#declare GAP_Width = .06;   //Distance between characters
#declare SPACE_Width = .28; //Distance between words
#declare LineSpacing = .5;  //Distance between lines

#declare LineAlignment = CENTERED; //Choices are LEFT, RIGHT, CENTERED, or JUSTIFIED
#declare MaxMicroJustificationScale = 1; //Set to 1 for no scaling, > 1 for limited scaling, or UNLIMITED
#declare MaxAdditionalGAP_WidthPercentage = UNLIMITED; //Set to 0 to maintain constant gap width, any percentage, or UNLIMITED
#declare SPACE_ExpansionRate = 1.5; //Values > 1 will cause SPACE_Width to increase faster than GAP_Width
#declare JustifyLastLinePercentage = 95; //Minimum percentage of paragraph width to justify last line
#declare MinJustifiedParagraphWidth = 0; //Minimum width of paragraph when justified

#local TextScale = 1;
#local UseActualParagraphHeight = no;

#local NLines = 2;

InitializeVariables (NLines)

//Use   \"   for DOUBLE QUOTE MARKS.
//Use   &    for a HEART.
//Use   ^    for a STAR.
//Use   @    for a BULLET.

#declare LineText [0] = "~0~Zombie";
#declare LineText [1] = "Attack!";

CreateParagraph (NLines, TextScale, UseActualParagraphHeight)

#local LeftMargin = -ParagraphWidth / 2;
#local TopMargin = ParagraphHeight / 2;
#local ZOffset = -.1;

#local Message = object {Paragraph translate <LeftMargin, TopMargin, ZOffset>}

object {Message}
