/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* * [BORDERED CHARACTERS VERSION 1.8a]                                                                              * */
/* *                                                                                                                 * */
/* * INTRODUCTION:                                                                                                   * */
/* *                                                                                                                 * */
/* * Hello Friend! Out of all the billions of people on Earth, you are one of only a miniscule fraction who is       * */
/* * interested in using my files. I worked very hard on this project and I hope you find it useful. I would be very * */
/* * happy to hear from you if you would take a moment to write and say Hi! My e-mail address is                     * */
/* * davswa1967@yahoo.com. I look forward to hearing from you, since you will probably be the only person on this    * */
/* * whole planet to write! Feel free to mention any comments or suggestions.                                        * */
/* *                                                                                                                 * */
/* * GENERAL OVERVIEW:                                                                                               * */
/* *                                                                                                                 * */
/* * The purpose of these files is to provide a set of bordered character objects and macros to manage them. The     * */
/* * characters are similar to the Arial font. The biggest practical difference between these character objects and  * */
/* * a standard text object is the bordering capability. As you can see from the "Demo_FontVariations.pov" file,     * */
/* * this capability allows one to create unlimited and interesting three-dimensional font variations.               * */
/* *                                                                                                                 * */
/* * The best way to learn to use these files is to read these instructions and examine the "Demo_*.pov" files. The  * */
/* * file "Demo_QuickStart.pov" is a great place to start. You can copy and paste from this file to make your own    * */
/* * scene very easily.                                                                                              * */
/* *                                                                                                                 * */
/* * I've tried to provide as much flexibility as my little brain could possibly think of while keeping the features * */
/* * as easy to use as possible.                                                                                     * */
/* *                                                                                                                 * */
/* * Here's a basic explanation of what the macros do: The heart of this utility is the character object             * */
/* * definitions. The objects are created in such a manner that a border width can be specified, and the stroke      * */
/* * width of the characters will be reduced by that amount. Therefore, multiple copies of the character objects     * */
/* * with different stroke widths and textures can be combined using various CSG operations.                         * */
/* *                                                                                                                 * */
/* * Macros are included to help manage the character objects as lines of text. The end product of the macros is an  * */
/* * object called "Paragraph" which is a union of characters styled, textured, formatted, spaced, aligned, and      * */
/* * scaled according to your specifications.                                                                        * */
/* *                                                                                                                 * */
/* * The macros provide automatic kerning, two types of micro-justification, and the ability to embed formatting     * */
/* * codes within the text.                                                                                          * */
/* *                                                                                                                 * */
/* * BASIC INSTRUCTIONS FOR USE:                                                                                     * */
/* *                                                                                                                 * */
/* * 1: Include the file "BorderChars.inc" in your scene.                                                            * */
/* * 2: Set textures for the inner and outer parts of the characters you wish to create.                             * */
/* * 3: Define one or more "Font Styles" using the SetFontStyle () macro. (Copy and paste font style definitions     * */
/* *    from the "Demo_FontVariations.pov" file.)                                                                    * */
/* * 4: Set the various formatting variables according to your desired results using #declare statements.            * */
/* * 5: Call the InitializeVariables () macro specifying the number of lines of text in your message.                * */
/* * 6: Assign string values to the specified number of LineText [] array elements using #declare statements. Note   * */
/* *    that there are four characters that require special attention: The DOUBLE-QUOTE mark is represented by a     * */
/* *    BACKSLASH followed immediately by a DOUBLE QUOTE MARK (\"). A HEART shape is represented by the AMPERSAND    * */
/* *    symbol (&). A STAR shape is represented by the CARET symbol (^). A BULLET is represented by the AT symbol    * */
/* *    (@). Also, text can be italicized by enclosing it between curly brackets ("{" and "}").                      * */
/* * 7: Call the CreateParagraph () macro.                                                                           * */
/* * 8: The "Paragraph" object is now ready to use in your scene, and some useful variables have been set for you    * */
/* *    to aid in positioning and manipulating the object.                                                           * */
/* *                                                                                                                 * */
/* * This may sound a little complicated but in reality using these macros is mostly just an exercise in copying and * */
/* * pasting.                                                                                                        * */
/* *                                                                                                                 * */
/* * Detailed instructions can be found below. There are three .inc files that have distinct purposes, so the        * */
/* * documentation will be divided into three corresponding sections.                                                * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */





/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* * SECTION 1: THE "BorderChars_Definitions.inc" FILE                                                               * */
/* *                                                                                                                 * */
/* * This file contains the actual character definitions as well as some useful variables and macros to help you     * */
/* * incorporate them in scenes. Under normal circumstances you will not call the macros in this file directly.      * */
/* *                                                                                                                 * */
/* * The macros create characters that are one unit in depth (front-to-back) in the z direction, from z = 0 to z =   * */
/* * 1. The width and height of the characters varies. In general, the bottom of the characters is at y = 0.         * */
/* * However, some characters extend below y = 0. The lowest y value of any character is -.35625. Similarly, the     * */
/* * maximum height of most characters is y = 1, but the ASTERISK and DOLLAR sign extend to y = 1.075. This is       * */
/* * useful to know for purposes of creating properly scaled textures.                                               * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */





/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* * SECTION 2: THE "BorderChars_Macros.inc" FILE                                                                    * */
/* *                                                                                                                 * */
/* * This file contains some useful macros to help you manage the character objects as lines of text.                * */
/* *                                                                                                                 * */
/* * The macros in this file work together to create an object called "Paragraph." The Paragraph object consists of  * */
/* * one or more lines of characters arranged vertically. Each line can consist of one or more characters. It's what * */
/* * an actual written paragraph is.                                                                                 * */
/* *                                                                                                                 * */
/* * Under most circumstances, the only macros you will need to call are SetFontStyle (), InitializeVariables (),    * */
/* * and CreateParagraph (). The rest of the macros are called internally by these macros.                           * */
/* *                                                                                                                 * */
/* * Note that some characters fit "inside" other characters. For example, in the sequence "P." the top of the       * */
/* * letter "P" extends beyond the right edge of the period. This greatly complicates the task of applying the       * */
/* * kerning values. These macros are not perfect, but the character combinations that will cause them to fail are   * */
/* * not commonly used in normal writing.                                                                            * */
/* *                                                                                                                 * */
/* * SetFontStyle () Macro:                                                                                          * */
/* * ----------------------                                                                                          * */
/* *                                                                                                                 * */
/* * The term "Font Style" refers to indexed records of settings that partially control the appearance of the        * */
/* * characters. The "Font Style Index" identifies a specific "Font Style" record. There can be 100 "Font Style"     * */
/* * records within any scene, numbered 0 - 99.                                                                      * */
/* *                                                                                                                 * */
/* * "Font Styles" are applied to the characters within the Paragraph object by embedding formatting codes within    * */
/* * the text of your message. The formatting code consists of a "Font Style Index" number surrounded by TILDES      * */
/* * ("~"). The index number indicates which predefined "Font Style" to apply to the characters following the        * */
/* * formatting code. For example:                                                                                   * */
/* *                                                                                                                 * */
/* *    #declare LineText [0] = "~0~This text uses Font Style #0. ~1~This text uses Font Style #1.";                 * */
/* *                                                                                                                 * */
/* * The SetFontStyle () macro has the following parameters:                                                         * */
/* *                                                                                                                 * */
/* *    1: [FontStyleIndex] Indicates which "Font Style" record is to be set using the remaining parameters. Valid   * */
/* *    values are 0 - 99.                                                                                           * */
/* *                                                                                                                 * */
/* *    2: [FontVariationNumber] This variable refers to the font variations defined in the                          * */
/* *    "BorderChars_FontVariations.inc" file.                                                                       * */
/* *                                                                                                                 * */
/* *    3: [P0], [P1],... [P8] Variation-specific variables. Copy and paste from "Demo_FontVariations.pov." [P0] is  * */
/* *    generally used for the depth of the characters along the z axis.                                             * */
/* *                                                                                                                 * */
/* *    4: [TextColor_Outer] This texture that will be applied to the "outside" of the characters.                   * */
/* *                                                                                                                 * */
/* *    5: [TextColor_Inner] This texture that will be applied to the "inside" of the characters.                    * */
/* *                                                                                                                 * */
/* *    6: [TextColor_Back] This texture that will be applied to the back face of the characters.                    * */
/* *                                                                                                                 * */
/* * In addition to the settings contained in the "Font Style" records, the appearance of the characters is affected * */
/* * by three additional factors:                                                                                    * */
/* *                                                                                                                 * */
/* *    1: Any additional font variation-specific elements defined as global variables. (See font variation number 4 * */
/* *    for an example.)                                                                                             * */
/* *                                                                                                                 * */
/* *    2: Italicization. Text bracketed by CURLY BRACKETS ("{" and "}") will be italicized. If the end of a line    * */
/* *    containing italicized text is reached and no closing CURLY BRACKET is located, the next line will be reset   * */
/* *    to non-italicized.                                                                                           * */
/* *                                                                                                                 * */
/* *    3: Scale. See [TextScale] and [MaxMicroJustificationScale] below.                                            * */
/* *                                                                                                                 * */
/* * InitializeVariables () Macro:                                                                                   * */
/* * -----------------------------                                                                                   * */
/* *                                                                                                                 * */
/* * This is a "housekeeping" macro that initializes several arrays that are used during the creation of the         * */
/* * Paragraph object. Its only parameter is the number of lines of text in your paragraph.                          * */
/* *                                                                                                                 * */
/* * CreateParagraph () Macro:                                                                                       * */
/* * -------------------------                                                                                       * */
/* *                                                                                                                 * */
/* * This macro creates an object called "Paragraph" which is a graphical representation of the lines of text you    * */
/* * specified in the LineText [] array elements, using all the formatting and styling tools available.              * */
/* *                                                                                                                 * */
/* * The appearance of the Paragraph object is controlled by a number of things including the parameters of the      * */
/* * CreateParagraph () macro, some global variables that should be set with #declare statements prior to calling    * */
/* * the CreateParagraph () macro, the selected "Font Style(s)," and any formatting codes within the text.           * */
/* * Technically, the global variables should all be macro parameters but I compromised good programming practice.   * */
/* *                                                                                                                 * */
/* * The CreateParagraph () macro has the following parameters:                                                      * */
/* *                                                                                                                 * */
/* *    1: [NLines] The number of lines of text that the Paragraph object will consist of.                           * */
/* *                                                                                                                 * */
/* *    2: [TextScale] The Paragraph object will be scaled along the x and y axes by [TextScale].                    * */
/* *                                                                                                                 * */
/* *    3: [UseActualParagraphHeight] This is a boolean variable that determines the final vertical location of the  * */
/* *    Paragraph object, as well as the meaning of the [ParagraphHeight] variable (see below).                      * */
/* *                                                                                                                 * */
/* * The CreateParagraph () macro utilizes the following global variables which you can set:                         * */
/* *                                                                                                                 * */
/* *    [GAP_Width] This is the horizontal distance between characters. The default value is .06.                    * */
/* *                                                                                                                 * */
/* *    [SPACE_Width] This is the horizontal distance between words. The default value is .26.                       * */
/* *                                                                                                                 * */
/* *    [LineSpacing] This is the vertical distance between lines. The default value is .5. Note that portions of    * */
/* *    any characters which ascend above the normal upper character boundary (the ASTERISK and DOLLAR sign) or      * */
/* *    descend below the normal character boundary will intrude into this space. Note also that vertical spacing    * */
/* *    and horizontal spacing operate differently in that horizontal spacing will change according to [TextScale]   * */
/* *    while vertical spacing will remain constant. This is required for consistency when using the "scaled"        * */
/* *    micro-justification method. If you need vertical spacing to change with [TextScale], simply multiply your    * */
/* *    desired [LineSpacing] value by [TextScale]. Similarly, if you need horizontal spacing to remain constant     * */
/* *    then divide your desired [SPACE_Width] and [GAP_Width] by [TextScale].                                       * */
/* *                                                                                                                 * */
/* *    [LineAlignment] Paragraphs can be left aligned, right aligned, center aligned, or justified. The             * */
/* *    corresponding values are LEFT, RIGHT, CENTERED, or JUSTIFIED. The default value is LEFT. Micro-justification * */
/* *    is activated when you set [LineAlignment] = JUSTIFIED. It can be controlled very precisely to give different * */
/* *    results.                                                                                                     * */
/* *                                                                                                                 * */
/* *    [MaxMicroJustificationScale] There are two different methods available to accomplish the task of equalizing  * */
/* *    the widths of the lines of the Paragraph object (micro-justification). The first method is to scale the      * */
/* *    entire lines, both horizontally and vertically, so that they are all the same width. This will produce lines * */
/* *    of varying heights, creating an interesting visual effect. This method can be invoked by setting the         * */
/* *    variable [MaxMicroJustificationScale] = UNLIMITED. What this means is that each line will be scaled as much  * */
/* *    as necessary to achieve the correct width. If one or more lines are extremely narrow compared to the widest  * */
/* *    line, however, you will end up with very tall lines as a result. In this case you may want to limit the      * */
/* *    amount that the lines can be scaled. Set [MaxMicroJustificationScale] to some value greater than 1 in order  * */
/* *    to do this. For best results when using larger values, especially UNLIMITED, use all capital letters in your * */
/* *    Paragraph text.                                                                                              * */
/* *                                                                                                                 * */
/* *    The second method to widen lines is to increase the distance between characters and/or words. Set            * */
/* *    [MaxMicroJustificationScale] = 1 to invoke this method. Note that if you limit the amount that lines can be  * */
/* *    scaled to some value less than the required amount (by setting [MaxMicroJustificationScale] greater than 1   * */
/* *    but less than the required amount), then the second method will be utilized in combination with the first    * */
/* *    method to make up the difference. The default value is 1. Values less than 1 are undefined.                  * */
/* *                                                                                                                 * */
/* *    [MaxAdditionalGAP_WidthPercentage] The value of this variable represents a maximum percentage that           * */
/* *    [GAP_Width] can be increased to justify a line. As described above, the second method of micro-justification * */
/* *    works by expanding [GAP_Width] and [SPACE_Width] to widen any lines that are shorter than the longest line   * */
/* *    of the paragraph.                                                                                            * */ 
/* *                                                                                                                 * */
/* *    Set [MaxAdditionalGAP_WidthPercentage] to 0 to retain constant spacing between characters and widen lines    * */
/* *    when necessary by only increasing [SPACE_Width].                                                             * */
/* *                                                                                                                 * */
/* *    Setting [MaxAdditionalGAP_WidthPercentage] to something less than UNLIMITED means that as [GAP_Width] and    * */
/* *    [SPACE_Width] increase, [GAP_Width] will be limited to [GAP_Width] plus some percentage of [GAP_Width]. Any  * */
/* *    additional space that must be added to the line beyond that limited amount will be distributed among the     * */
/* *    spaces between words. If no spaces are present in the line then the value of the variable                    * */
/* *    [MaxAdditionalGAP_WidthPercentage] will be over-ridden.                                                      * */
/* *                                                                                                                 * */
/* *    Setting the value to UNLIMITED means that there will be no limit to the amount that [GAP_Width] can be       * */
/* *    increased in order to justify a line. This will allow the micro-justification feature to balance the values  * */
/* *    of [GAP_Width] and [SPACE_Width] automatically, giving an emphasis (controlled by [SPACE_ExpansionRate]) to  * */
/* *    [SPACE_Width].                                                                                               * */
/* *                                                                                                                 * */
/* *    The default value is UNLIMITED. This variable is only meaningful when [LineAlignment] = JUSTIFIED and        * */
/* *    [MaxMicroJustificationScale] is less than UNLIMITED.                                                         * */
/* *                                                                                                                 * */
/* *    [SPACE_ExpansionRate] Spaces can be expanded at a rate greater than the gap expansion rate. A value of 1     * */
/* *    will cause [SPACE_Width] to increase at the same rate as [GAP_Width] in order to justify a line. Values      * */
/* *    greater than 1 will cause [SPACE_Width] to increase more than [GAP_Width]. The default value is 1.5, meaning * */
/* *    that [SPACE_Width] will increase 1.5 times more than [GAP_Width]. This variable is only meaningful when      * */
/* *    [LineAlignment] = JUSTIFIED and [MaxMicroJustificationScale] is set to something less than UNLIMITED.        * */
/* *    Setting [SPACE_ExpansionRate] greater than 1 is most effective when [MaxAdditionalGAP_WidthPercentage] =     * */
/* *    UNLIMITED.                                                                                                   * */
/* *                                                                                                                 * */
/* *    [JustifyLastLinePercentage] This variable determines whether or not the last line of a multi-line paragraph  * */
/* *    will be justified when [LineAlignment] is set to JUSTIFIED and [MaxMicroJustificationScale] is set to 1.     * */
/* *    If [MaxMicroJustificationScale] is set to something greater than 1 then all the lines will always be         * */
/* *    justified. The value represents a percentage of the width of the last line to the width of the widest line   * */
/* *    of the Paragraph object. If the percentage is greater than or equal to the value of                          * */
/* *    [JustifyLastLinePercentage], the last line will be justified. Otherwise, it won't be. Therefore, a value of  * */
/* *    0 will cause the last line to always be justified and a value of 100 will cause the last line to never be    * */
/* *    justified. The default value is 95.                                                                          * */
/* *                                                                                                                 * */
/* *    [MinJustifiedParagraphWidth] This variable specifies the minimum width of a justified paragraph. If          * */
/* *    [LineAlignment] is not set to JUSTIFIED then this variable will have no effect. The default value is 0. You  * */
/* *    can use this feature to match the width of a Paragraph object to some other scene element, such as another   * */
/* *    Paragraph object.                                                                                            * */
/* *                                                                                                                 * */
/* *    [LineText] This is an array that will be created for you by the InitializeVariables () macro. Set each array * */
/* *    element equal to a line of characters. You must provide the InitializeVariables () macro with the number of  * */
/* *    lines that your paragraph will consist of, and you must assign values to a corresponding number of           * */
/* *    [LineText] array elements prior to calling the CreateParagraph () macro. Note that POV-Ray has an            * */
/* *    unfortunate string variable length limit of 255 characters.                                                  * */
/* *                                                                                                                 * */
/* *    [ApplyTextures] There may be occasions where untextured character objects need to be integrated with other   * */
/* *    objects and then have textures applied afterward. The [ApplyTextures] setting provides the ability to create * */
/* *    untextured characters. Set this variable to "false" to leave characters untextured. The default setting is   * */
/* *    "true." Note that currently only Font Variation #0 supports this feature, but it's there for anyone who      * */
/* *    needs to use it.                                                                                             * */
/* *                                                                                                                 * */
/* * Additionally, there are some useful variables that will be set for you by the CreateParagraph () macro:         * */
/* *                                                                                                                 * */
/* *    [ParagraphWidth] This variable represents the total width of the Paragraph object (the object will extend    * */
/* *    from x = 0 to x = [ParagraphWidth]). This value is useful when positioning the Paragraph object.             * */
/* *                                                                                                                 * */
/* *    [ParagraphHeight] This variable behaves differently based on the setting of the variable                     * */
/* *    [UseActualParagraphHeight] (see above). If [UseActualParagraphHeight] is set to "yes" or "true,"             * */
/* *    [ParagraphHeight] represents the total height of the Paragraph object adjusted for any characters that       * */
/* *    ascend above, descend below, or otherwise do not conform to the normal character boundaries of y = 0 to y =  * */
/* *    1. In this case, the vertical location of the Paragraph object will be adjusted so that the top of the       * */
/* *    tallest character on the first line will be at y = 0. If [UseActualParagraphHeight] is set to "no" or        * */
/* *    "false," [ParagraphHeight] represents the height of the Paragraph object ignoring any characters that do not * */
/* *    conform to the normal character boundaries of y = 0 to y = 1. Run the sample file                            * */
/* *    "Demo_ParagraphHeight.pov" for a visual demonstration of this variable. Note that [ParagraphHeight] is a     * */
/* *    positive value, but the top of the Paragraph object is at y = 0 and the bottom of the object is at y =       * */
/* *    -[ParagraphHeight]. This value is useful when positioning the Paragraph object.                              * */
/* *                                                                                                                 * */
/* *    [ParagraphHistory_Width] This array will contain the widths of all the Paragraph objects created up to this  * */
/* *    point in your scene. These values are useful for aligning or sizing multiple Paragraph objects. Note that    * */
/* *    one element is added to the array each time the CreateParagraph () macro is called. Therefore, if you create * */
/* *    a Paragraph object just to measure its width, the re-create it with a computed [TextScale] value, this will  * */
/* *    add two entries to the [ParagraphHistory_Width] array. The first value in the array is numbered "0."         * */
/* *                                                                                                                 * */
/* *    [ParagraphHistory_Height] This array works like the [ParagraphHistory_Width] array, but contains the heights * */
/* *    of all the Paragraph objects created up to this point in your scene.                                         * */
/* *                                                                                                                 * */
/* *    [CurrentParagraphNumber] This variable indicates the current Paragraph number; that is, the one that will be * */
/* *    created next. Note that this variable refers to a Paragraph that hasn't actually been created yet, therefore * */
/* *    you will always be accessing array elements in the range of [0 .. CurrentParagraphNumber - 1], after at      * */
/* *    least one paragraph has been created. Chances are, if you want to match the width or height of a previous    * */
/* *    Paragraph it's probably the last one created. For example:                                                   * */
/* *                                                                                                                 * */
/* *       #declare MinJustifiedParagraphWidth = ParagraphHistory_Width [CurrentParagraphNumber - 1];                * */
/* *                                                                                                                 * */
/* *    As long as LineAlignment = JUSTIFIED, this will create a Paragraph object that is at least as wide as the    * */
/* *    previous Paragraph object. Another example would be comparing the heights of the last two Paragraph objects  * */
/* *    that have been created. In this case you would compare [ParagraphHistory_Height                              * */
/* *    [CurrentParagraphNumber - 2]]with [ParagraphHistory_Height [CurrentParagraphNumber - 1]].                    * */
/* *                                                                                                                 * */
/* *    [LineScale] This array will contain the scale value of each line of the Paragraph object. These values will  * */
/* *    always be 1 unless [MaxMicroJustificationScale] is set to greater than 1. The first value is numbered "0."   * */
/* *                                                                                                                 * */
/* *    [SumOfAllScales] The sum of all the [LineScale] array elements. Only useful when                             * */
/* *    [MaxMicroJustificationScale] is set to a value greater than 1.                                               * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */





/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* * SECTION 3: THE "BorderChars_FontVariations.inc" FILE                                                            * */
/* *                                                                                                                 * */
/* * This file defines some example font variations to demonstrate the many possible ways that characters with       * */
/* * different border widths can be combined in interesting ways. Upon original creation, the characters occupy the  * */
/* * space from z = 0 to z = 1. The finished "stylized" characters produced by the Stylize () macro in this file     * */
/* * occupy the space from z = -TextDepth to z = 0.                                                                  * */
/* *                                                                                                                 * */
/* * The "Demo_FontVariations.pov" file demonstrates each of the styles defined in this file. Render the file to see * */
/* * what the predefined sample font variations look like. Note that you'll need to set the variable                 * */
/* * [StartFontVariationNumber] as explained in the comments and re-render the file to see all the available font    * */
/* * variations. Also note that high quality images showing all the "Font Variations" can be downloaded from the POV * */
/* * newsgroups website (povray.binaries.images).                                                                    * */
/* *                                                                                                                 * */
/* * You'll need to define at least one "Font Style" prior to using these font variations. See the instructions for  * */
/* * the SetFontStyle () macro in SECTION 2 above.                                                                   * */
/* *                                                                                                                 * */
/* * Font variation #4 also requires two global colors, named [ExtraParameter_Color0] and [ExtraParameter_Color1].   * */
/* * Similarly, font variations #28 and #29 require an object called [ExtraParameter_InteriorObject]. This object    * */
/* * will fill the interior of the characters. It should minimally fill an area from <0, -.35625, 0> to <~2, 1.075,  * */
/* * [TextDepth]>. The object can extend less than 0 or greater than [TextDepth] along the z axis if desired.        * */
/* *                                                                                                                 * */
/* * The easiest way to use these font variations in your own scenes is to copy and paste the variable names and     * */
/* * example values from "Demo_FontVariations.pov" into your scene then adjust the values as necessary. For example, * */
/* * if you wanted to use font variation #15, you would scroll down until you find the line "#case (15)" then copy   * */
/* * and past the following code:                                                                                    * */
/* *                                                                                                                 * */
/* *    #local FontVariationNumber = 15;                                                                             * */
/* *    #local TextDepth = .08;                                                                                      * */
/* *    #local InvisibleBorderWidth = 0;                                                                             * */
/* *    #local BorderWidth = .03;                                                                                    * */
/* *    #local StripeWidth = .02;                                                                                    * */
/* *    #local StripeDepth = .02;                                                                                    * */
/* *    #local InnerHeight = .03;                                                                                    * */
/* *    SetFontStyle (FontStyleIndex, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth,             * */ 
/* *       StripeWidth, StripeDepth, InnerHeight, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)   * */
/* *                                                                                                                 * */
/* * In this example, the variable names "TextDepth," "InvisibleBorderWidth," etc. represent the parameters "P0,"    * */
/* * "P1," etc. and the arbitrary value 999 is assigned to "P6" through "P8" since they aren't used.                 * */
/* *                                                                                                                 * */
/* * There is one variable used within these samples that requires special explanation:                              * */
/* *                                                                                                                 * */
/* *    [InvisibleBorderWidth] This variable can be used to decrease the stroke width of some of the font            * */
/* *    variations. Good values are 0 (no reduction in stroke width) to around .05.                                  * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */





/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* * KNOWN ISSUES:                                                                                                   * */
/* *                                                                                                                 * */
/* * Changing stroke widths within a paragraph by varying the [InvisibleBorderWidth] setting will result in          * */
/* * incorrect line width computations. This will cause right, center, and micro-justification to fail. Left         * */
/* * justification will still work properly. Fixing this would require re-writing quite a bit of code, which I don't * */
/* * have the time for.                                                                                              * */
/* *                                                                                                                 * */
/* * There are a few four-character combinations in which the two characters in the middle are narrow and short      * */
/* * enough that the right edge of the leftmost character should abut the left edge of the rightmost character       * */
/* * ("P..T" for example). The kerning macro only considers up to three characters at a time, so this condition will * */
/* * cause the macro to fail. I don't anticipate that any character combinations that cause this problem would ever  * */
/* * be used in normal text. I could be wrong, of course, but the cost in time and effort required to correct this   * */
/* * is too great for the limited potential benefit. There are other conditions that will cause the kerning macro to * */
/* * fail but are also not used in normal text.                                                                      * */
/* *                                                                                                                 * */
/* * Reducing the stroke width by using the [InvisibleBorderWidth] variable reduces the height of the lower-case     * */
/* * "t." This is a side-effect of the mathematical method used to reduce the stroke width. This also causes the     * */
/* * height measurement of the Paragraph object to be inaccurate.                                                    * */
/* *                                                                                                                 * */
/* * Note to self: Reducing [StrokeWidth] produces a different effect than using [InvisibleBorderWidth] but breaks   * */
/* * some of the characters ("s" for example). Re-designing or fixing the broken characters would allow this option. * */
/* * This is a low-priority project since [InvisibleBorderWidth] produces more visually appealing results anyway.    * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
