/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* *                                                                                                                 * */
/* * CREATE THE VARIOUS FONT VARIATIONS                                                                              * */
/* *                                                                                                                 * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#macro Stylize (FontStyleIndex, TextScale_Final)

   #declare FontStyleRecord_Valid [FontStyleIndex] = true;

   #local FontVariationNumber = FontStyleRecord_FontVariationNumber [FontStyleIndex];
   #local P0 = FontStyleRecord_P0 [FontStyleIndex];
   #local P1 = FontStyleRecord_P1 [FontStyleIndex];
   #local P2 = FontStyleRecord_P2 [FontStyleIndex];
   #local P3 = FontStyleRecord_P3 [FontStyleIndex];
   #local P4 = FontStyleRecord_P4 [FontStyleIndex];
   #local P5 = FontStyleRecord_P5 [FontStyleIndex];
   #local P6 = FontStyleRecord_P6 [FontStyleIndex];
   #local P7 = FontStyleRecord_P7 [FontStyleIndex];
   #local P8 = FontStyleRecord_P8 [FontStyleIndex];
   #local TextColor_Outer = texture {FontStyleRecord_TextColor_Outer [FontStyleIndex]}
   #local TextColor_Inner = texture {FontStyleRecord_TextColor_Inner [FontStyleIndex]}
   #local TextColor_Back = texture {FontStyleRecord_TextColor_Back [FontStyleIndex]}

   #local MeasureWidths = false;

   #for (I, 0, NDefinedCharacters - 1)
      #if (CharacterInUse [I])
         #switch (FontVariationNumber)
            #case (0) //Plain
               #local TextDepth = P0;
               #if (I = 83 | I = 84) //HEART or STAR
                  #local InvisibleBorderWidth = 0;
               #else
                  #local InvisibleBorderWidth = P1;
               #end //#if
               #if (P1 > 0)
                  #local MeasureWidths = true;
                  #local MeasurementDepthFactor = .5;
               #end //#if
               #local S = 1 / (1 - InvisibleBorderWidth * 2);
               MakeCharacter (I, InvisibleBorderWidth)
               #declare Character = object {
                  intersection {
                     object {Character scale <1, 1, 1.1> #if (ApplyTextures) texture {TextColor_Outer} #end}
                     plane {z, TextDepth #if (ApplyTextures) texture {TextColor_Back} #end}
                  } //intersection
                  scale <S, S, 1>
                  translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               } //object
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            #break //#case
            #case (1) //Raised center (use when border and center are the same height)
               #local TextDepth = P0;
               #if (I = 83 | I = 84) //HEART or STAR
                  #local InvisibleBorderWidth = 0;
               #else
                  #local InvisibleBorderWidth = P1;
               #end //#if
               #local BorderWidth = P2 / TextScale_Final;
               #local BorderHeight = P3 / 1.1;
               #if (P1 > 0)
                  #local MeasureWidths = true;
                  #local MeasurementDepthFactor = .5;
               #end //#if
               #local S = 1 / (1 - InvisibleBorderWidth * 2);
               #local BorderWidth = BorderWidth / S;
               MakeCharacter (I, InvisibleBorderWidth)
               #local Character_Outer = object {Character texture {TextColor_Outer}}
               MakeCharacter (I, BorderWidth + InvisibleBorderWidth)
               #local Character_Inner = object {Character texture {TextColor_Inner}}
               #if (BorderHeight = 0)
                  #local Character_Outer = object {
                     difference {
                        object {Character_Outer}
                        object {Character_Inner translate -.1 * z}
                     } //difference
                  } //object
               #end //#if
               #declare Character = object {
                  union {
                     object {Character_Outer}
                     object {Character_Inner translate -BorderHeight * z}
                  } //union
               } //object
               #declare Character = object {
                  intersection {
                     object {Character scale <1, 1, 1.1>}
                     plane {z, TextDepth texture {TextColor_Back}}
                  } //intersection
                  scale <S, S, 1>
                  translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               } //object
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            #break //#case
            #case (2) //Lowered center
               #local TextDepth = P0;
               #if (I = 83 | I = 84) //HEART or STAR
                  #local InvisibleBorderWidth = 0;
               #else
                  #local InvisibleBorderWidth = P1;
               #end //#if
               #local BorderWidth = P2 / TextScale_Final;
               #local BorderDepth = P3;
               #if (P1 > 0)
                  #local MeasureWidths = true;
                  #local MeasurementDepthFactor = .5;
               #end //#if
               #local S = 1 / (1 - InvisibleBorderWidth * 2);
               #local BorderWidth = BorderWidth / S;
               MakeCharacter (I, InvisibleBorderWidth)
               #local Character_Outer = object {
                  intersection {
                     object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
                     plane {z, TextDepth texture {TextColor_Back}}
                  } //intersection
               } //object
               MakeCharacter (I, BorderWidth + InvisibleBorderWidth)
               #local Character_Inner = object {
                  intersection {
                     object {Character scale <1, 1, 1.1>}
                     plane {z, 1}
                  } //intersection
                  texture {TextColor_Inner}
               } //object
               #declare Character = object {
                  difference {
                     object {Character_Outer}
                     object {Character_Inner translate (-1 + BorderDepth) * z}
                  } //difference
                  scale <S, S, 1>
                  translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               } //object
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            #break //#case
            #case (3) //Striped
               #local TextDepth = P0;
               #if (I = 83 | I = 84) //HEART or STAR
                  #local InvisibleBorderWidth = 0;
               #else
                  #local InvisibleBorderWidth = P1;
               #end //#if
               #local BorderWidth = P2 / TextScale_Final;
               #local StripeWidth = P3 / TextScale_Final;
               #local StripeHeight = P4;
               #if (P1 > 0)
                  #local MeasureWidths = true;
                  #local MeasurementDepthFactor = .5;
               #end //#if
               #local S = 1 / (1 - InvisibleBorderWidth * 2);
               #local BorderWidth = BorderWidth / S;
               #local StripeWidth = StripeWidth / S;
               MakeCharacter (I, InvisibleBorderWidth)
               #local Character_Outer = object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
               MakeCharacter (I, BorderWidth + StripeWidth + InvisibleBorderWidth)
               #local Character_Inner2 = object {Character scale <1, 1, 1.2>}
               MakeCharacter (I, BorderWidth + InvisibleBorderWidth)
               #local Character_Inner = object {
                  difference {
                     object {Character}
                     object {Character_Inner2 translate -.1 * z}
                  } //difference
                  texture {TextColor_Outer}
               } //object
               #local Character_Inner = object {
                  intersection {
                     object {Character_Inner scale <1, 1, 1.1> translate -.1 * z}
                     plane {z, 0 inverse texture {TextColor_Inner}}
                  } //intersection
               } //object
               #declare Character = object {
                  intersection {
                     union {
                        difference {
                           object {Character_Outer}
                           object {Character_Inner translate -.1 * z}
                        } //difference
                        object {Character_Inner translate -StripeHeight * z}
                     } //union
                     plane {z, TextDepth texture {TextColor_Back}}
                  } //intersection
                  scale <S, S, 1>
                  translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               } //object
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            #break //#case
            #case (4) //Color gradient
               #local TextDepth = P0;
               #if (I = 83 | I = 84) //HEART or STAR
                  #local InvisibleBorderWidth = 0;
               #else
                  #local InvisibleBorderWidth = P1;
               #end //#if
               #local BorderWidth = P2 / TextScale_Final;
               #local StripeWidth = P3 / TextScale_Final;
               #local NSteps = P4;
               #if (P1 > 0)
                  #local MeasureWidths = true;
                  #local MeasurementDepthFactor = .5;
               #end //#if
               #local S = 1 / (1 - InvisibleBorderWidth * 2);
               #local BorderWidth = BorderWidth / S;
               #local StripeWidth = StripeWidth / S;
               MakeCharacter (I, InvisibleBorderWidth)
               #local Character_Outer = object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
               #local StripeWidthIncrement = StripeWidth / NSteps;
               #for (J, 0, NSteps)
                  #local ColorRatio = J / (NSteps - 1);
                  #local CurColor = ExtraParameter_Color1 * ColorRatio + ExtraParameter_Color0 * (1 - ColorRatio);
                  #local CurBorderWidth = BorderWidth + J * StripeWidthIncrement;
                  MakeCharacter (I, CurBorderWidth + InvisibleBorderWidth)
                  #if (J < NSteps)
                     #local CurTexture = texture {pigment {color CurColor}}
                  #else
                     #local CurTexture = texture {TextColor_Outer}
                  #end //#if
                  #local Character_Inner = object {Character scale <1, 1, 1.3> texture {CurTexture}}
                  #local Character_Outer = object {
                     union {
                        difference {
                           object {Character_Outer}
                           object {Character_Inner translate -.1 * z}
                        } //difference
                        object {Character_Inner}
                     } //union
                  } //object
               #end //#for
               #declare Character = object {
                  intersection {
                     object {Character_Outer}
                     plane {z, TextDepth texture {TextColor_Back}}
                  } //intersection
                  scale <S, S, 1>
                  translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               } //object
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            #break //#case
            #case (5) //Hollow stripe
               #local TextDepth = P0;
               #if (I = 83 | I = 84) //HEART or STAR
                  #local InvisibleBorderWidth = 0;
               #else
                  #local InvisibleBorderWidth = P1;
               #end //#if
               #local BorderWidth = P2 / TextScale_Final;
               #local StripeWidth = P3 / TextScale_Final;
               #local StripeDepth = P4;
               #if (P1 > 0)
                  #local MeasureWidths = true;
                  #local MeasurementDepthFactor = .5;
               #end //#if
               #local S = 1 / (1 - InvisibleBorderWidth * 2);
               #local BorderWidth = BorderWidth / S;
               #local StripeWidth = StripeWidth / S;
               MakeCharacter (I, InvisibleBorderWidth)
               #local Character_Outer = object {Character scale <1, 1, 1.1>}
               MakeCharacter (I, BorderWidth + StripeWidth + InvisibleBorderWidth)
               #local Character_Inner2 = object {Character scale <1, 1, 1.2>}
               MakeCharacter (I, BorderWidth + InvisibleBorderWidth)
               #local Character_Inner = object {
                  difference {
                     object {Character}
                     object {Character_Inner2 translate -.1 * z}
                  } //difference
               } //object
               #declare Character = object {
                  intersection {
                     difference {
                        object {Character_Outer}
                        object {Character_Inner translate (-1 + StripeDepth) * z}
                        texture {TextColor_Outer}
                     } //difference
                     plane {z, TextDepth texture {TextColor_Back}}
                  } //intersection
                  scale <S, S, 1>
                  translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               } //object
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            #break //#case
            #case (6) //Hollow inside
               #local TextDepth = P0;
               #if (I = 83 | I = 84) //HEART or STAR
                  #local InvisibleBorderWidth = 0;
               #else
                  #local InvisibleBorderWidth = P1;
               #end //#if
               #local BorderWidth = P2 / TextScale_Final;
               #if (P1 > 0)
                  #local MeasureWidths = true;
                  #local MeasurementDepthFactor = .5;
               #end //#if
               #local S = 1 / (1 - InvisibleBorderWidth * 2);
               #local BorderWidth = BorderWidth / S;
               MakeCharacter (I, InvisibleBorderWidth)
               #local Character_Outer = object {Character scale <1, 1, 1.1>}
               MakeCharacter (I, BorderWidth + InvisibleBorderWidth)
               #local Character_Inner = object {Character scale <1, 1, 1.3>}
               #declare Character = object {
                  difference {
                     object {Character_Outer}
                     object {Character_Inner translate -.1 * z}
                  } //difference
                  texture {TextColor_Outer}
               } //object
               #declare Character = object {
                  intersection {
                     object {Character}
                     plane {z, TextDepth texture {TextColor_Back}}
                  } //intersection
                  scale <S, S, 1>
                  translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               } //object
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            #break //#case
            #case (7) //Angled bevel
               #local TextDepth = P0;
               #local BorderHeight = P1;
               #local NSteps = P2;
               MakeCharacter (I, 0)
               #local Character_Outer = object {
                  intersection {
                     object {Character scale <1, 1, 1.2> translate -.1 * z texture {TextColor_Outer}}
                     plane {z, TextDepth texture {TextColor_Back}}
                     plane {z, 0 inverse texture {TextColor_Inner}}
                  } //intersection
               } //object
               #local Character_Inner = object {
                  intersection {
                     union {
                        #local Increment = BorderHeight / NSteps;
                        #for (J, 1, NSteps)
                           MakeCharacter (I, Increment * J)
                           #if (J = NSteps)
                              #declare Character = object {
                                 intersection {
                                    object {Character translate -.1 * z}
                                    plane {z, 0 inverse texture {TextColor_Outer}}
                                 } //intersection
                              } //object
                           #end //#if
                           object {Character translate (-Increment * J) * z}
                        #end //#for
                     } //union
                     plane {z, 0}
                  } //intersection
                  texture {TextColor_Inner}
               } //object
               #declare Character = object {
                  union {
                     object {Character_Outer}
                     object {Character_Inner}
                  } //union
                  translate -TextDepth * z //Back is at z = 0
               } //object
            #break //#case
            #case (8) //Rounded bevel
               #local TextDepth = P0;
               #local BorderHeight = P1;
               #local NSteps = P2;
               #local R = BorderHeight;
               MakeCharacter (I, 0)
               #local Character_Outer = object {
                  intersection {
                     object {Character scale <1, 1, 1.2> translate -.1 * z texture {TextColor_Outer}}
                     plane {z, TextDepth texture {TextColor_Back}}
                     plane {z, 0 inverse texture {TextColor_Inner}}
                  } //intersection
               } //object
               #local Character_Inner = object {
                  intersection {
                     union {
                        #local Increment = 90 / NSteps;
                        #for (J, 1, NSteps)
                           #local CurAngle = J * Increment;
                           #local CurBorderWidth = R * (1 + cos (radians (CurAngle + 180)));
                           #local CurBorderHeight = R * sin (radians (CurAngle));
                           MakeCharacter (I, CurBorderWidth)
                           #if (J = NSteps)
                              #declare Character = object {
                                 intersection {
                                    object {Character translate -.1 * z}
                                    plane {z, 0 inverse texture {TextColor_Outer}}
                                 } //intersection
                              } //object
                           #end //#if
                           object {Character translate -CurBorderHeight * z}
                        #end //#for
                     } //union
                     plane {z, 0}
                  } //intersection
                  texture {TextColor_Inner}
               } //object
               #declare Character = object {
                  union {
                     object {Character_Outer}
                     object {Character_Inner}
                  } //union
                  translate -TextDepth * z //Back is at z = 0
               } //object
            #break //#case
            #case (9) //Solid hourglass (convex)
               #local TextDepth = P0;
               #local EffectWidth = P1;
               #local NSteps = P2;
               #local TempCharacter = object {
                  union {
                     #local SegmentDepth = TextDepth / NSteps;
                     #local DeltaTheta = 180 / (NSteps - 1);
                     #local CurZ = TextDepth;
                     #local Theta = 0;
                     #for (J, 1, NSteps)
                        #local CurBorder = EffectWidth - EffectWidth * sin (radians (Theta));
                        MakeCharacter (I, CurBorder)
                        #local Segment = object {Character translate -1 * z scale <1, 1, SegmentDepth>}
                        object {Segment translate CurZ * z}
                        #local CurZ = CurZ - SegmentDepth;
                        #local Theta = Theta + DeltaTheta;
                     #end //#for
                  } //union
                  texture {TextColor_Outer}
                  translate -TextDepth * z //Back is at z = 0
               } //object
               #declare Character = object {TempCharacter}
            #break //#case
            #case (10) //Hollow hourglass (convex)
               #local TextDepth = P0;
               #local EffectWidth = P1;
               #local WallThickness = P2 / TextScale_Final;
               #local NSteps = P3;
               #local TempCharacter = object {
                  union {
                     #local SegmentDepth = TextDepth / NSteps;
                     #local DeltaTheta = 180 / (NSteps - 1);
                     #local CurZ = TextDepth;
                     #local Theta = 0;
                     #for (J, 1, NSteps)
                        #local CurBorder = EffectWidth - EffectWidth * sin (radians (Theta));
                        MakeCharacter (I, CurBorder)
                        #local Character_Outer = object {Character}
                        MakeCharacter (I, CurBorder + WallThickness)
                        #local Character_Inner = object {Character scale <1, 1, 1.2>}
                        #local Segment = object {
                           difference {
                              object {Character_Outer}
                              object {Character_Inner translate -.1 * z}
                           } //difference
                           translate -1 * z
                           scale <1, 1, SegmentDepth>
                        } //object
                        object {Segment translate CurZ * z}
                        #local CurZ = CurZ - SegmentDepth;
                        #local Theta = Theta + DeltaTheta;
                     #end //#for
                  } //union
                  texture {TextColor_Outer}
                  translate -TextDepth * z //Back is at z = 0
               } //object
               #declare Character = object {TempCharacter}
            #break //#case
            #case (11) //Solid hourglass (concave)
               #local TextDepth = P0;
               #local EffectWidth = P1;
               #local NSteps = P2;
               #local TempCharacter = object {
                  union {
                     #local SegmentDepth = TextDepth / NSteps;
                     #local DeltaTheta = 180 / (NSteps - 1);
                     #local CurZ = TextDepth;
                     #local Theta = 0;
                     #for (J, 1, NSteps)
                        #local CurBorder = EffectWidth * sin (radians (Theta));
                        MakeCharacter (I, CurBorder)
                        #local Segment = object {Character translate -1 * z scale <1, 1, SegmentDepth>}
                        object {Segment translate CurZ * z}
                        #local CurZ = CurZ - SegmentDepth;
                        #local Theta = Theta + DeltaTheta;
                     #end //#for
                  } //union
                  texture {TextColor_Outer}
                  translate -TextDepth * z //Back is at z = 0
               } //object
               #declare Character = object {TempCharacter}
            #break //#case
            #case (12) //Hollow hourglass (concave)
               #local TextDepth = P0;
               #local EffectWidth = P1;
               #local WallThickness = P2 / TextScale_Final;
               #local NSteps = P3;
               #local TempCharacter = object {
                  union {
                     #local SegmentDepth = TextDepth / NSteps;
                     #local DeltaTheta = 180 / (NSteps - 1);
                     #local CurZ = TextDepth;
                     #local Theta = 0;
                     #for (J, 1, NSteps)
                        #local CurBorder = EffectWidth * sin (radians (Theta));
                        MakeCharacter (I, CurBorder)
                        #local Character_Outer = object {Character}
                        MakeCharacter (I, CurBorder + WallThickness)
                        #local Character_Inner = object {Character scale <1, 1, 1.2>}
                        #local Segment = object {
                           difference {
                              object {Character_Outer}
                              object {Character_Inner translate -.1 * z}
                           } //difference
                           translate -1 * z
                           scale <1, 1, SegmentDepth>
                        } //object
                        object {Segment translate CurZ * z}
                        #local CurZ = CurZ - SegmentDepth;
                        #local Theta = Theta + DeltaTheta;
                     #end //#for
                  } //union
                  texture {TextColor_Outer}
                  translate -TextDepth * z //Back is at z = 0
               } //object
               #declare Character = object {TempCharacter}
            #break //#case
            #case (13) //Solid hourglass (concave)
               #local TextDepth = P0;
               #local EffectWidth = P1;
               #local NSteps = P2;
               #local TempCharacter = object {
                  union {
                     #local SegmentDepth = TextDepth / NSteps;
                     #local DeltaTheta = 90 / (NSteps - 1);
                     #local CurZ = TextDepth;
                     #local Theta = 0;
                     #for (J, 1, NSteps)
                        #local CurBorder = EffectWidth * sin (radians (Theta));
                        MakeCharacter (I, CurBorder)
                        #local Segment = object {Character translate -1 * z scale <1, 1, SegmentDepth>}
                        object {Segment translate CurZ * z}
                        #local CurZ = CurZ - SegmentDepth;
                        #local Theta = Theta + DeltaTheta;
                     #end //#for
                  } //union
                  texture {TextColor_Outer}
                  translate -TextDepth * z //Back is at z = 0
               } //object
               #declare Character = object {TempCharacter}
            #break //#case
            #case (14) //Striped, Hollow inside
               #local TextDepth = P0;
               #if (I = 83 | I = 84) //HEART or STAR
                  #local InvisibleBorderWidth = 0;
               #else
                  #local InvisibleBorderWidth = P1;
               #end //#if
               #local BorderWidth = P2 / TextScale_Final;
               #local StripeWidth = P3 / TextScale_Final;
               #local StripeHeight = P4;
               #local SecondBorderWidth = P5;
               #if (P1 > 0)
                  #local MeasureWidths = true;
                  #local MeasurementDepthFactor = .5;
               #end //#if
               #local S = 1 / (1 - InvisibleBorderWidth * 2);
               #local BorderWidth = BorderWidth / S;
               #local StripeWidth = StripeWidth / S;
               #local SecondBorderWidth = SecondBorderWidth / S;
               MakeCharacter (I, InvisibleBorderWidth)
               #local Character_Outer = object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
               MakeCharacter (I, BorderWidth + StripeWidth + InvisibleBorderWidth)
               #local Character_Inner2 = object {Character scale <1, 1, 1.2>}
               MakeCharacter (I, BorderWidth + InvisibleBorderWidth)
               #local Character_Inner = object {
                  difference {
                     object {Character}
                     object {Character_Inner2 translate -.1 * z}
                  } //difference
                  texture {TextColor_Outer}
               } //object
               #local Character_Inner = object {
                  intersection {
                     object {Character_Inner scale <1, 1, 1.1> translate -.1 * z}
                     plane {z, 0 inverse texture {TextColor_Inner}}
                  } //intersection
               } //object
               MakeCharacter (I, BorderWidth + StripeWidth + SecondBorderWidth + InvisibleBorderWidth)
               #local Character_Inner2 = object {Character scale <1, 1, 1.2> texture {TextColor_Outer}}
               #declare Character = object {
                  intersection {
                     union {
                        difference {
                           object {Character_Outer}
                           object {Character_Inner translate -.1 * z}
                           object {Character_Inner2 translate -.1 * z}
                        } //difference
                        object {Character_Inner translate -StripeHeight * z}
                     } //union
                     plane {z, TextDepth texture {TextColor_Back}}
                  } //intersection
                  scale <S, S, 1>
                  translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               } //object
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            #break //#case
            #case (15) //Hollow stripe with raised center
               #local TextDepth = P0;
               #if (I = 83 | I = 84) //HEART or STAR
                  #local InvisibleBorderWidth = 0;
               #else
                  #local InvisibleBorderWidth = P1;
               #end //#if
               #local BorderWidth = P2 / TextScale_Final;
               #local StripeWidth = P3 / TextScale_Final;
               #local StripeDepth = P4;
               #local InnerHeight = P5;
               #if (P1 > 0)
                  #local MeasureWidths = true;
                  #local MeasurementDepthFactor = .5;
               #end //#if
               #local S = 1 / (1 - InvisibleBorderWidth * 2);
               #local BorderWidth = BorderWidth / S;
               #local StripeWidth = StripeWidth / S;
               MakeCharacter (I, InvisibleBorderWidth)
               #local Character_Outer = object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
               MakeCharacter (I, BorderWidth + InvisibleBorderWidth)
               #declare Character = object {Character scale <1, 1, StripeDepth + .1> texture {TextColor_Outer}}
               #local Character_Outer = object {
                  difference {
                     object {Character_Outer}
                     object {Character translate -.1 * z}
                  } //difference
               } //object
               MakeCharacter (I, BorderWidth + StripeWidth + InvisibleBorderWidth)
               #declare Character = object {
                  intersection {
                     union {
                        object {Character_Outer}
                        object {Character translate -InnerHeight * z texture {TextColor_Inner}}
                     } //union
                     plane {z, TextDepth texture {TextColor_Back}}
                  } //intersection
                  scale <S, S, 1>
                  translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               } //object
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            #break //#case
            #case (16) //Angled reverse bevel
               #local TextDepth = P0;
               #local BorderDepth = P1;
               #local NSteps = P2;
               MakeCharacter (I, 0)
               #local Character_Outer = object {
                  intersection {
                     object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
                     plane {z, TextDepth texture {TextColor_Back}}
                  } //intersection
               } //object
               #local Character_Inner = object {
                  union {
                     #local Increment = BorderDepth / NSteps;
                     #for (J, 1, NSteps)
                        MakeCharacter (I, Increment * J)
                        #declare Character = object {
                           intersection {
                              object {Character translate .1 * z}
                              plane {z, 1}
                           } //intersection
                        } //object
                        object {Character translate (Increment * J) * z}
                     #end //#for
                  } //union
                  texture {TextColor_Outer}
                  translate -1 * z
               } //object
               #declare Character = object {
                  difference {
                     object {Character_Outer}
                     object {Character_Inner}
                  } //difference
                  translate -TextDepth * z //Back is at z = 0
               } //object
            #break //#case
            #case (17) //Rounded reverse bevel/concave
               #local TextDepth = P0;
               #local BorderDepth = P1;
               #local NSteps = P2;
               #local R = BorderDepth;
               MakeCharacter (I, 0)
               #local Character_Outer = object {
                  intersection {
                     object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
                     plane {z, TextDepth texture {TextColor_Back}}
                  } //intersection
               } //object
               #local Character_Inner = object {
                  union {
                     #local Increment = 90 / NSteps;
                     #for (J, 1, NSteps)
                        #local CurAngle = J * Increment;
                        #local CurBorderWidth = R * (1 + cos (radians (CurAngle + 180)));
                        #local CurBorderDepth = R * sin (radians (CurAngle));
                        MakeCharacter (I, CurBorderWidth)
                        #declare Character = object {
                           intersection {
                              object {Character translate .1 * z}
                              plane {z, 1}
                           } //intersection
                        } //object
                        object {Character translate CurBorderDepth * z}
                     #end //#for
                  } //union
                  texture {TextColor_Outer}
                  translate -1 * z
               } //object
               #declare Character = object {
                  difference {
                     object {Character_Outer}
                     object {Character_Inner}
                  } //difference
                  translate -TextDepth * z //Back is at z = 0
               } //object
            #break //#case
            #case (18) //Rounded reverse bevel/convex
               #local TextDepth = P0;
               #local BorderDepth = P1;
               #local NSteps = P2;
               #local R = BorderDepth;
               MakeCharacter (I, 0)
               #local Character_Outer = object {
                  intersection {
                     object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
                     plane {z, TextDepth texture {TextColor_Back}}
                  } //intersection
               } //object
               #local Character_Inner = object {
                  union {
                     #local Increment = 90 / NSteps;
                     #for (J, 1, NSteps)
                        #local CurAngle = J * Increment;
                        #local CurBorderDepth = R * (1 + cos (radians (CurAngle + 180)));
                        #local CurBorderWidth = R * sin (radians (CurAngle));
                        MakeCharacter (I, CurBorderWidth)
                        #declare Character = object {
                           intersection {
                              object {Character translate .1 * z}
                              plane {z, 1}
                           } //intersection
                        } //object
                        object {Character translate CurBorderDepth * z}
                     #end //#for
                  } //union
                  texture {TextColor_Outer}
                  translate -1 * z
               } //object
               #declare Character = object {
                  difference {
                     object {Character_Outer}
                     object {Character_Inner}
                  } //difference
                  translate -TextDepth * z //Back is at z = 0
               } //object
            #break //#case
            #case (19) //Rounded top outline
               #local TextDepth = P0;
               #local R = P1;
               #local NSteps = P2;
               MakeCharacter (I, 0)
               #declare Character_Back = object {
                  intersection {
                     object {Character scale <1, 1, 1.2> translate -.1 * z texture {TextColor_Outer}}
                     plane {z, TextDepth texture {TextColor_Back}}
                     plane {z, 0 inverse texture {TextColor_Inner}}
                  } //intersection
               } //object
               #local Top = object {
                  union {
                     #local Increment = 90 / NSteps;
                     #for (J, 0, NSteps - 1)
                        #local CurAngle_X = J * Increment;
                        #local CurAngle_Y = (J + 1) * Increment;
                        #local CurX = cos (radians (CurAngle_X));
                        #local CurY = sin (radians (CurAngle_Y));
                        MakeCharacter (I, R * (1 - CurX))
                        #local Character_Outer = object {Character translate - .5 * z scale <1, 1, R * CurY>}
                        MakeCharacter (I, R + R * CurX)
                        #local Character_Inner = object {Character translate -.5 * z}
                        #local Character_Segment = object {
                           difference {
                              object {Character_Outer}
                              object {Character_Inner}
                           } //difference
                        } //object
                        object {Character_Segment}
                     #end //#for
                  } //union
                  texture {TextColor_Outer}
               } //object
               #declare Character = object {
                  union {
                     object {Character_Back}
                     object {Top}
                  } //union
                  translate -TextDepth * z //Back is at z = 0
               } //object
            #break //#case
            #case (20) //Raised inner border
               #local TextDepth = P0;
               #if (I = 83 | I = 84) //HEART or STAR
                  #local InvisibleBorderWidth = 0;
               #else
                  #local InvisibleBorderWidth = P1;
               #end //#if
               #local BorderWidth = P2 / TextScale_Final;
               #local RaisedBorderWidth = P3 / TextScale_Final;
               #local RaisedBorderHeight = P4;
               #if (P1 > 0)
                  #local MeasureWidths = true;
                  #local MeasurementDepthFactor = .5;
               #end //#if
               #local S = 1 / (1 - InvisibleBorderWidth * 2);
               #local BorderWidth = BorderWidth / S;
               #local RaisedBorderWidth = RaisedBorderWidth / S;
               MakeCharacter (I, InvisibleBorderWidth)
               #local Character_Outer = object {Character scale <1, 1, 1.1> texture {TextColor_Inner}}
               MakeCharacter (I, BorderWidth + InvisibleBorderWidth)
               #local Character_Inner = object {Character}
               MakeCharacter (I, BorderWidth + RaisedBorderWidth + InvisibleBorderWidth)
               #local Character_Inner = object {
                  difference {
                     object {Character_Inner}
                     object {Character scale <1, 1, 1.2> translate -.1 * z}
                  } //difference
                  texture {TextColor_Outer}
               } //object
               #declare Character = object {
                  intersection {
                     union {
                        object {Character_Outer}
                        object {Character_Inner translate -RaisedBorderHeight * z}
                     } //union
                     plane {z, TextDepth texture {TextColor_Back}}
                  } //intersection
                  scale <S, S, 1>
                  translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               } //object
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            #break //#case
            #case (21) //Specular highlights
               #local TextDepth = P0;
               #if (I = 83 | I = 84) //HEART or STAR
                  #local InvisibleBorderWidth = 0;
               #else
                  #local InvisibleBorderWidth = P1;
               #end //#if
               #local BorderWidth = P2 / TextScale_Final;
               #local BorderDepth = P3 / 1.1;
               #local Angle = P4;
               #if (P1 > 0)
                  #local MeasureWidths = true;
                  #local MeasurementDepthFactor = .5;
               #end //#if
               #local S = 1 / (1 - InvisibleBorderWidth * 2);
               #local BorderWidth = BorderWidth / S;
               #local R = BorderWidth * 2.5;
               #local XOffset = R * sin (radians (Angle));
               #local YOffset = R * cos (radians (Angle));
               MakeCharacter (I, InvisibleBorderWidth)
               #local Character_Outer = object {Character texture {TextColor_Outer}}
               MakeCharacter (I, BorderWidth + InvisibleBorderWidth)
               #local Character_Inner = object {
                  intersection {
                     object {Character scale <1, 1, 1.1>}
                     plane {z, 1}
                  } //intersection
                  texture {TextColor_Inner}
               } //object
               #declare Character_Outer = object {
                  difference {
                     object {Character_Outer}
                     object {Character_Inner translate (-1 + BorderDepth) * z}
                  } //difference
               } //object
               MakeCharacter (I, BorderWidth * 2 + InvisibleBorderWidth)
               #local Character_Inner = object {Character}
               MakeCharacter (I, BorderWidth * 1 + InvisibleBorderWidth)
               #local Character_Inner = object {
                  difference {
                     object {Character_Inner}
                     object {Character scale <1, 1, 1.2> translate <XOffset, YOffset, -.1>}
                  } //difference
                  texture {TextColor_Outer}
               } //object
               #declare Character = object {
                  union {
                     object {Character_Outer}
                     object {Character_Inner}
                  } //union
               } //object
               #declare Character = object {
                  intersection {
                     object {Character scale <1, 1, 1.1>}
                     plane {z, TextDepth texture {TextColor_Back}}
                  } //intersection
                  scale <S, S, 1>
                  translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               } //object
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            #break //#case
            #case (22) //Drop shadow
               #local TextDepth = P0;
               #if (I = 83 | I = 84) //HEART or STAR
                  #local InvisibleBorderWidth = 0;
               #else
                  #local InvisibleBorderWidth = P1;
               #end //#if
               #local Quadrant = P2; //1, 2, 3, or 4
               #local XYOffset_Solid = P3;
               #local XYOffset_Space = P4;
               #local LeaveInOffsetPosition = P5; //Set to "yes" if used as drop shadows, set to "no" if used as stand-alone characters.
               #local S = 1 / (1 - InvisibleBorderWidth * 2);
               #local Angle = (Quadrant - 1) * 90 + 45;
               #switch (Quadrant)
                  #case (1)
                     #local XSign = 1;
                     #local YSign = 1;
                  #break //#case
                  #case (2)
                     #local XSign = -1;
                     #local YSign = 1;
                  #break //#case
                  #case (3)
                     #local XSign = -1;
                     #local YSign = -1;
                  #break //#case
                  #case (4)
                     #local XSign = 1;
                     #local YSign = -1;
                  #break //#case
               #end //#switch
               #local XOffset_Solid = XYOffset_Solid * XSign;
               #local YOffset_Solid = XYOffset_Solid * YSign;
               #local XOffset_Space = XYOffset_Space * XSign;
               #local YOffset_Space = XYOffset_Space * YSign;
               MakeCharacter (I, InvisibleBorderWidth)
               #declare Character = object {
                  Character
                  scale <S, S, 1>
                  translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, 0>
               } //object
               #declare Character = object {
                  intersection {
                     difference {
                        object {Character scale <1, 1, 1.1> translate <XOffset_Solid, YOffset_Solid, 0>}
                        object {Character scale <1, 1, 1.2> translate -.1 * z}
                        texture {TextColor_Outer}
                     } //difference
                     plane {z, TextDepth texture {TextColor_Back}}
                  } //intersection
                  #if (LeaveInOffsetPosition)
                     translate <XOffset_Space, YOffset_Space, 0>
                  #else
                     translate <-XOffset_Solid, -YOffset_Solid, 0>
                  #end //#if
                  translate -TextDepth * z //Back is at z = 0
               } //object
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            #break //#case
            #case (23) //Raised center version 2
               #local TextDepth = P0;
               #if (I = 83 | I = 84) //HEART or STAR
                  #local InvisibleBorderWidth = 0;
               #else
                  #local InvisibleBorderWidth = P1;
               #end //#if
               #local BorderWidth = P2 / TextScale_Final;
               #local BorderHeight = P3 / 1.1;
               #if (P1 > 0)
                  #local MeasureWidths = true;
                  #local MeasurementDepthFactor = .5;
               #end //#if
               #local S = 1 / (1 - InvisibleBorderWidth * 2);
               #local BorderWidth = BorderWidth / S;
               MakeCharacter (I, InvisibleBorderWidth)
               #local Character_Outer = object {Character texture {TextColor_Outer}}
               MakeCharacter (I, BorderWidth + InvisibleBorderWidth)
               #local Character_Inner = object {
                  intersection {
                     object {Character scale <1, 1, 1.1> translate -.1 * z texture {TextColor_Outer}}
                     plane {z, 0 inverse texture {TextColor_Inner}}
                  } //intersection
               } //object
               #declare Character = object {
                  union {
                     object {Character_Outer}
                     object {Character_Inner translate -BorderHeight * z}
                  } //union
               } //object
               #declare Character = object {
                  intersection {
                     object {Character scale <1, 1, 1.1>}
                     plane {z, TextDepth texture {TextColor_Back}}
                  } //intersection
                  scale <S, S, 1>
                  translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               } //object
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            #break //#case
            #case (24) //Lowered center version 2
               #local TextDepth = P0;
               #if (I = 83 | I = 84) //HEART or STAR
                  #local InvisibleBorderWidth = 0;
               #else
                  #local InvisibleBorderWidth = P1;
               #end //#if
               #local BorderWidth = P2 / TextScale_Final;
               #local BorderDepth = P3;
               #if (P1 > 0)
                  #local MeasureWidths = true;
                  #local MeasurementDepthFactor = .5;
               #end //#if
               #local S = 1 / (1 - InvisibleBorderWidth * 2);
               #local BorderWidth = BorderWidth / S;
               MakeCharacter (I, InvisibleBorderWidth)
               #local Character_Outer = object {
                  intersection {
                     object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
                     plane {z, TextDepth texture {TextColor_Back}}
                  } //intersection
               } //object
               MakeCharacter (I, BorderWidth + InvisibleBorderWidth)
               #local Character_Inner = object {
                  intersection {
                     object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
                     plane {z, 1 texture {TextColor_Inner}}
                  } //intersection
               } //object
               #declare Character = object {
                  difference {
                     object {Character_Outer}
                     object {Character_Inner translate (-1 + BorderDepth) * z}
                  } //difference
                  scale <S, S, 1>
                  translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               } //object
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            #break //#case
            #case (25) //Lowered center with invisible radiosity wall
               #local TextDepth = P0;
               #if (I = 83 | I = 84) //HEART or STAR
                  #local InvisibleBorderWidth = 0;
               #else
                  #local InvisibleBorderWidth = P1;
               #end //#if
               #local BorderWidth = P2 / TextScale_Final;
               #local BorderDepth = P3;
               #local InvisibleWallHeight = P4;
               #if (P1 > 0)
                  #local MeasureWidths = true;
                  #local MeasurementDepthFactor = .5;
               #end //#if
               #local S = 1 / (1 - InvisibleBorderWidth * 2);
               #local BorderWidth = BorderWidth / S;
               MakeCharacter (I, InvisibleBorderWidth)
               #local Character_Outer = object {
                  intersection {
                     object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
                     plane {z, TextDepth texture {TextColor_Back}}
                  } //intersection
               } //object
               MakeCharacter (I, BorderWidth + InvisibleBorderWidth)
               #local Character_Inner = object {
                  intersection {
                     object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
                     plane {z, 1 texture {TextColor_Inner}}
                  } //intersection
               } //object
               #local BaseCharacter = object {
                  difference {
                     object {Character_Outer}
                     object {Character_Inner translate (-1 + BorderDepth) * z}
                  } //difference
               } //object
               #local BorderWidth = InvisibleBorderWidth + BorderWidth;
               MakeCharacter (I, BorderWidth)
               #local Character_Outer = object {Character}
               MakeCharacter (I, BorderWidth + .0001)
               #local Character_Inner = object {Character scale <1, 1, 1.2>}
               #local RadiosityWall = object {
                  intersection {
                     difference {
                        object {Character_Outer}
                        object {Character_Inner translate -.1 * z}
                     } //difference
                     plane {z, InvisibleWallHeight}
                  } //intersection
                  texture {TextColor_Outer}
                  translate -InvisibleWallHeight * z
                  no_image
                  no_shadow
                  no_reflection
               } //object
               #declare Character = object {
                  union {
                     object {BaseCharacter}
                     object {RadiosityWall}
                  } //union
                  scale <S, S, 1>
                  translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               } //object
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            #break //#case
            #case (26) //Lowered center with dark inner border
               #local TextDepth = P0;
               #if (I = 83 | I = 84) //HEART or STAR
                  #local InvisibleBorderWidth = 0;
               #else
                  #local InvisibleBorderWidth = P1;
               #end //#if
               #local BorderWidth = P2 / TextScale_Final;
               #local BorderDepth = P3;
               #local DarkBorderWidth = P4 / TextScale_Final;
               #local NSteps = P5;
               #if (P1 > 0)
                  #local MeasureWidths = true;
                  #local MeasurementDepthFactor = .5;
               #end //#if
               #local S = 1 / (1 - InvisibleBorderWidth * 2);
               #local BorderWidth = BorderWidth / S;
               #local DarkBorderWidth = DarkBorderWidth / S;
               MakeCharacter (I, InvisibleBorderWidth)
               #local Character_Outer = object {
                  intersection {
                     object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
                     plane {z, TextDepth texture {TextColor_Back}}
                  } //intersection
               } //object
               MakeCharacter (I, BorderWidth + InvisibleBorderWidth)
               #local Character_Inner = object {
                  intersection {
                     object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
                     plane {z, 1 texture {TextColor_Inner}}
                  } //intersection
               } //object
               #declare BaseCharacter = object {
                  difference {
                     object {Character_Outer}
                     object {Character_Inner translate (-1 + BorderDepth) * z}
                  } //difference
               } //object
               #declare DarkBorder = object {
                  #local Transparency_Outer = .6;
                  #local Transparency_Inner = 1;
                  union {
                     #for (J, 0, NSteps - 1)
                        #local BorderWidth_Outer = InvisibleBorderWidth + BorderWidth + DarkBorderWidth / NSteps * J;
                        #local BorderWidth_Inner = BorderWidth_Outer + DarkBorderWidth / NSteps;
                        #local A = J / NSteps * 90;
                        //#local CurTransparency = Transparency_Outer + (Transparency_Inner - Transparency_Outer) * (J / NSteps); //Linear
                        #local CurTransparency = Transparency_Outer + (Transparency_Inner - Transparency_Outer) * sin (radians (A)); //Non-linear
                        MakeCharacter (I, BorderWidth_Outer)
                        #local Character_Outer = object {Character}
                        MakeCharacter (I, BorderWidth_Inner)
                        #local Character_Inner = object {Character scale <1, 1, 1.2>}
                        object {
                           intersection {
                              difference {
                                 object {Character_Outer}
                                 object {Character_Inner translate -.1 * z}
                              } //difference
                              plane {z, .0002}
                           } //intersection
                           texture {pigment {color <0, 0, 0> transmit CurTransparency}}
                           translate (BorderDepth - .0001) * z
                           no_radiosity
                           no_shadow
                           no_reflection
                        } //object
                     #end //#for
                  } //union
               } //object
               #declare Character = object {
                  union {
                     object {BaseCharacter}
                     object {DarkBorder}
                  } //union
                  scale <S, S, 1>
                  translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               } //object
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            #break //#case
            #case (27) //Hollow inside
               #local TextDepth = P0;
               #if (I = 83 | I = 84) //HEART or STAR
                  #local InvisibleBorderWidth = 0;
               #else
                  #local InvisibleBorderWidth = P1;
               #end //#if
               #local BorderWidth = P2 / TextScale_Final;
               #local WallThickness = P3;
               #local AirGap = P4;
               #if (WallThickness + AirGap >= TextDepth)
                  #error "Font Style settings are incorrect. TextDepth must be greater than WallThickness + AirGap."
               #end //#if
               #if (P1 > 0)
                  #local MeasureWidths = true;
                  #local MeasurementDepthFactor = .5;
               #end //#if
               #local S = 1 / (1 - InvisibleBorderWidth * 2);
               #local BorderWidth = BorderWidth / S;
               MakeCharacter (I, InvisibleBorderWidth)
               #local Character_Outer = object {
                  intersection {
                     object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
                     plane {z, TextDepth texture {TextColor_Back}}
                  } //intersection
               } //object
               MakeCharacter (I, (InvisibleBorderWidth + .0001) / TextScale_Final)
               #local Character_Inner = object {
                  intersection {
                     object {Character texture {TextColor_Outer}}
                     plane {z, AirGap texture {TextColor_Inner}}
                  } //intersection
                  translate WallThickness * z
               } //object
               MakeCharacter (I, BorderWidth + InvisibleBorderWidth)
               #local Character_Top = object {Character texture {TextColor_Outer} translate (-1 + WallThickness + AirGap / 2) * z}
               #declare Character = object {
                  difference {
                     object {Character_Outer}
                     object {Character_Inner}
                     object {Character_Top}
                  } //difference
                  scale <S, S, 1>
                  translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               } //object
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            #break //#case
            #case (28) //Interior object
               #local TextDepth = P0;
               #if (I = 83 | I = 84) //HEART or STAR
                  #local InvisibleBorderWidth = 0;
               #else
                  #local InvisibleBorderWidth = P1;
               #end //#if
               #local BorderWidth = P2 / TextScale_Final;
               #if (P1 > 0)
                  #local MeasureWidths = true;
                  #local MeasurementDepthFactor = .5;
               #end //#if
               #local S = 1 / (1 - InvisibleBorderWidth * 2);
               #local BorderWidth = BorderWidth / S;
               MakeCharacter (I, InvisibleBorderWidth)
               #local Character_Outer = object {Character}
               MakeCharacter (I, BorderWidth + InvisibleBorderWidth)
               #local Character_Inner = object {Character}
               #local Character_Outer = object {
                  difference {
                     object {Character_Outer}
                     object {Character_Inner scale <1, 1, 1.2> translate -.1 * z}
                  } //difference
               } //object
               #local Character_Outer = object {
                  intersection {
                     object {Character_Outer scale <1, 1, 1.1> texture {TextColor_Outer}}
                     plane {z, TextDepth texture {TextColor_Back}}
                  } //intersection
               } //object
               #local Character_Inner = object {
                  intersection {
                     object {Character_Inner scale <1, 1, 3> translate -1 * z texture {TextColor_Inner}}
                     object {ExtraParameter_InteriorObject}
                  } //intersection
               } //object
               #declare Character = object {
                  union {
                     object {Character_Outer}
                     object {Character_Inner}
                  } //union
                  scale <S, S, 1>
                  translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               } //object
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            #break //#case
            #case (29) //Interior object, no outer border
               #local TextDepth = P0;
               MakeCharacter (I, 0)
               #declare Character = object {
                  intersection {
                     object {Character scale <1, 1, 3> translate -1 * z texture {TextColor_Inner}}
                     object {ExtraParameter_InteriorObject}
                  } //intersection
                  translate -TextDepth * z //Back is at z = 0
               } //object
            #break //#case
            #case (30) //Framework with empty center
               #local TextDepth = P0;
               #local BorderWidth = P1 / TextScale_Final;
               MakeCharacter (I, 0)
               #local Character_Outer = object {Character}
               MakeCharacter (I, BorderWidth)
               #local Character_Inner = object {Character}
               #local Character_Outer = object {
                  difference {
                     object {Character_Outer}
                     object {Character_Inner scale <1, 1, 1.2> translate -.1 * z}
                  } //difference
               } //object
               #local Character_Inner = object {
                  intersection {
                     object {Character_Inner}
                     plane {z, TextDepth - BorderWidth * 2}
                  } //intersection
                  translate BorderWidth * z
               } //object
               #declare Character = object {
                  intersection {
                     difference {
                        object {Character_Outer}
                        object {Character_Inner translate (-BorderWidth - .015) * y} //Bottom
                        object {Character_Inner translate (BorderWidth + .015) * y} //Top
                        object {Character_Inner translate (-BorderWidth - .015) * x} //Left
                        object {Character_Inner translate (BorderWidth + .015) * x} //Right
                        texture {TextColor_Outer}
                     } //difference
                     plane {z, TextDepth texture {TextColor_Back}}
                  } //intersection
                  translate -TextDepth * z //Back is at z = 0
               } //object
            #break //#case
            #case (31) //Framework with solid center
               #local TextDepth = P0;
               #local BorderWidth = P1 / TextScale_Final;
               #local AirGap = P2 / TextScale_Final;
               #if (BorderWidth + AirGap >= TextDepth / 2)
                  #error "Font Style settings are incorrect. TextDepth must be greater than 2 * (BorderWidth + AirGap)."
               #end //#if
               MakeCharacter (I, 0)
               #local Character_Outer = object {Character}
               MakeCharacter (I, BorderWidth)
               #local Character_Inner = object {Character}
               #local Character_Outer = object {
                  difference {
                     object {Character_Outer}
                     object {Character_Inner scale <1, 1, 1.2> translate -.1 * z}
                  } //difference
               } //object
               #local Character_Inner = object {
                  intersection {
                     object {Character_Inner}
                     plane {z, TextDepth - BorderWidth * 2}
                  } //intersection
                  translate BorderWidth * z
               } //object
               #local Character_Outer = object {
                  intersection {
                     difference {
                        object {Character_Outer}
                        object {Character_Inner translate (-BorderWidth - .015) * y} //Bottom
                        object {Character_Inner translate (BorderWidth + .015) * y} //Top
                        object {Character_Inner translate (-BorderWidth - .015) * x} //Left
                        object {Character_Inner translate (BorderWidth + .015) * x} //Right
                        texture {TextColor_Outer}
                     } //difference
                     plane {z, TextDepth texture {TextColor_Back}}
                  } //intersection
               } //object
               #if (AirGap > 0)
                  MakeCharacter (I, BorderWidth + AirGap)
                  #local Character_Inner = object {
                     intersection {
                        object {Character}
                        plane {z, TextDepth - BorderWidth * 2 - AirGap * 2}
                     } //intersection
                     translate (BorderWidth + AirGap) * z
                  } //object
               #end //#if
               #declare Character = object {
                  union {
                     object {Character_Outer}
                     object {Character_Inner texture {TextColor_Inner}}
                  } //union
                  translate -TextDepth * z //Back is at z = 0
               } //object
            #break //#case
            #case (32) //Stack
               #local TextDepth = P0;
               #if (I = 83 | I = 84) //HEART or STAR
                  #local InvisibleBorderWidth = 0;
               #else
                  #local InvisibleBorderWidth = P1;
               #end //#if
               #local BorderWidth = P2 / TextScale_Final;
               #local SpacerDepth = P3;
               #local TextDepth_Segment = TextDepth / 3 - SpacerDepth * 2;
               #if (TextDepth_Segment <= 0)
                  #error "* * * SpacerDepth is too great."
               #end //#if
               #if (P1 > 0)
                  #local MeasureWidths = true;
                  #local MeasurementDepthFactor = .5;
               #end //#if
               #local S = 1 / (1 - InvisibleBorderWidth * 2);
               #local BorderWidth = BorderWidth / S;
               MakeCharacter (I, BorderWidth + InvisibleBorderWidth)
               #local Character_Inner = object {Character scale <1, 1, 1.2>}
               MakeCharacter (I, InvisibleBorderWidth)
               #local Character_Back = object {
                  difference {
                     intersection {
                        object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
                        plane {z, TextDepth_Segment texture {TextColor_Back}}
                     } //intersection
                     object {Character_Inner translate -.1 * z texture {TextColor_Outer}}
                  } //difference
                  translate -TextDepth_Segment * z //Back is at z = 0
               } //object
               #local Character_Middle = object {
                  difference {
                     object {Character scale <1, 1, TextDepth_Segment>}
                     object {Character_Inner translate -.1 * z}
                  } //difference
                  texture {TextColor_Inner}
                  translate (-TextDepth_Segment * 2 - SpacerDepth) * z
               } //object
               #local Character_Front = object {
                  difference {
                     object {Character scale <1, 1, TextDepth_Segment>}
                     object {Character_Inner translate -.1 * z}
                  } //difference
                  texture {TextColor_Outer}
                  translate (-TextDepth_Segment * 3 - SpacerDepth * 2) * z
               } //object
               #declare Character = object {
                  union {
                     object {Character_Back}
                     object {Character_Middle}
                     object {Character_Front}
                  } //union
                  scale <S, S, 1>
                  translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, 0> //Back is at z = 0
               } //object
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            #break //#case
            #case (33) //Rounded
               #local R = P0 / 2;
               #local NSteps = P1;
               #local TempCharacter = object {
                  union {
                     #local Increment = 90 / NSteps;
                     #for (J, 0, NSteps - 1)
                        #local CurAngle_X = J * Increment;
                        #local CurAngle_Y = (J + 1) * Increment;
                        #local CurX = cos (radians (CurAngle_X));
                        #local CurY = sin (radians (CurAngle_Y));
                        MakeCharacter (I, R * (1 - CurX))
                        #local Character_Outer = object {Character translate - .5 * z scale <1, 1, R * CurY * 2>}
                        MakeCharacter (I, R + R * CurX)
                        #local Character_Inner = object {Character translate -.5 * z}
                        #local Character_Segment = object {
                           difference {
                              object {Character_Outer}
                              object {Character_Inner}
                           } //difference
                        } //object
                        object {Character_Segment}
                     #end //#for
                  } //union
               } //object
               #declare Character = object {
                  TempCharacter
                  texture {TextColor_Outer}
                  translate -R * z //Back is at z = 0
               } //object
            #break //#case
            #case (34) //Flat inner, rounded outer
               #local R = P0 / 2;
               #local NSteps = P1;
               #local Character_ = object {
                  union {
                     #local Increment = 90 / NSteps;
                     #for (J, 0, NSteps - 1)
                        #local CurAngle_X = J * Increment;
                        #local CurAngle_Y = (J + 1) * Increment;
                        #local CurX = cos (radians (CurAngle_X));
                        #local CurY = sin (radians (CurAngle_Y));
                        MakeCharacter (I, R * (1 - CurX))
                        #local Character_Outer = object {Character translate - .5 * z scale <1, 1, R * CurY * 2>}
                        MakeCharacter (I, R)
                        #local Character_Inner = object {Character translate -.5 * z}
                        #local Character_Segment = object {
                           difference {
                              object {Character_Outer}
                              object {Character_Inner}
                           } //difference
                        } //object
                        object {Character_Segment}
                     #end //#for
                  } //union
               } //object
               #declare Character = object {
                  Character_
                  texture {TextColor_Outer}
                  translate -R * z //Back is at z = 0
               } //object
            #break //#case
            #case (35) //Rounded inner, flat outer
               #local R = P0 / 2;
               #local NSteps = P1;
               #local Character_ = object {
                  union {
                     #local Increment = 90 / NSteps;
                     #for (J, 0, NSteps - 1)
                        #local CurAngle_X = J * Increment;
                        #local CurAngle_Y = (J + 1) * Increment;
                        #local CurX = cos (radians (CurAngle_X));
                        #local CurY = sin (radians (CurAngle_Y));
                        MakeCharacter (I, R)
                        #local Character_Outer = object {Character translate - .5 * z scale <1, 1, R * CurY * 2>}
                        MakeCharacter (I, R + R * CurX)
                        #local Character_Inner = object {Character translate -.5 * z}
                        #local Character_Segment = object {
                           difference {
                              object {Character_Outer}
                              object {Character_Inner}
                           } //difference
                        } //object
                        object {Character_Segment}
                     #end //#for
                  } //union
               } //object
               #declare Character = object {
                  Character_
                  texture {TextColor_Outer}
                  translate -R * z //Back is at z = 0
               } //object
            #break //#case
            #case (36) //Curved sides
               #local TextDepth = P0;
               #local EffectWidth = P1;
               #local StartAngle = P2;
               #local EndAngle = P3;
               #local NSteps = P4;
               #local YOffset = 1 / NSteps / 2;
               #local TempCharacter = object {
                  union {
                     #for (J, 0, NSteps - 1)
                        #local CurAngle = StartAngle + J / (NSteps - 1) * (EndAngle - StartAngle);
                        #local SegmentY = 1 / NSteps / 2 + J / NSteps;
                        #local Segment = object {
                           intersection {
                              #local CurBorder = EffectWidth * sin (radians (CurAngle));
                              MakeCharacter (I, CurBorder)
                              object {Character}
                              #if (J > 0)
                                 plane {y, SegmentY - YOffset inverse}
                              #end //#if
                              #if (J < NSteps - 1)
                                 plane {y, SegmentY + YOffset}
                              #end //#if
                           } //intersection
                        } //object
                        object {Segment}
                     #end //#for
                  } //union
                  scale <1, 1, 1.1>
                  texture {TextColor_Outer}
               } //object
               #declare Character = object {
                  intersection {
                     object {TempCharacter}
                     plane {z, TextDepth texture {TextColor_Back}}
                  } //intersection
                  translate -TextDepth * z //Back is at z = 0
               } //object
            #break //#case
            #case (37) //Curved sides with lowered center
               #local TextDepth = P0;
               #local BorderWidth = P1 / TextScale_Final;
               #local BorderDepth = P2;
               #local EffectWidth = P3;
               #local StartAngle = P4;
               #local EndAngle = P5;
               #local NSteps = P6;
               #local YOffset = 1 / NSteps / 2;
               #local TempCharacter = object {
                  union {
                     #for (J, 0, NSteps - 1)
                        #local CurAngle = StartAngle + J / (NSteps - 1) * (EndAngle - StartAngle);
                        #local SegmentY = 1 / NSteps / 2 + J / NSteps;
                        #local Segment = object {
                           intersection {
                              #local CurBorder = EffectWidth * sin (radians (CurAngle));
                              #local CurCharacter = object {
                                 MakeCharacter (I, CurBorder)
                                 #local Character_Outer = object {
                                    intersection {
                                       object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
                                       plane {z, TextDepth texture {TextColor_Back}}
                                    } //intersection
                                 } //object
                                 MakeCharacter (I, CurBorder + BorderWidth)
                                 #local Character_Inner = object {
                                    intersection {
                                       object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
                                       plane {z, 1 texture {TextColor_Inner}}
                                    } //intersection
                                 } //object
                                 difference {
                                    object {Character_Outer}
                                    object {Character_Inner translate (-1 + BorderDepth) * z}
                                 } //difference
                                 translate -TextDepth * z //Back is at z = 0
                              } //object
                              object {CurCharacter}
                              #if (J > 0)
                                 plane {y, SegmentY - YOffset inverse texture {TextColor_Outer}}
                              #end //#if
                              #if (J < NSteps - 1)
                                 plane {y, SegmentY + YOffset texture {TextColor_Outer}}
                              #end //#if
                           } //intersection
                        } //object
                        object {Segment}
                     #end //#for
                  } //union
               } //object
               #declare Character = object {TempCharacter bounded_by {box {<-EffectWidth - .4, BorderCharacterHeight_Bottom [I] - EffectWidth - .01, -TextDepth - .01> <BorderCharacterWidth [I] + EffectWidth + .21, 1.08, .01>}}}
            #break //#case
            #case (38) //Curved sides and back
               #local TextDepth = P0;
               #local EffectWidth = P1;
               #local WallThickness = P2 / TextScale_Final;
               #local StartAngle_Y = P3;
               #local EndAngle_Y = P4;
               #local NSteps_Y = P5;
               #local StartAngle_Z = P6;
               #local EndAngle_Z = P7;
               #local NSteps_Z = P8;
               #local YOffset = 1 / NSteps_Y / 2;
               #local TempCharacter = object {
                  union {
                     #local SegmentDepth = TextDepth / NSteps_Z;
                     #for (J, 0, NSteps_Z - 1)
                        #local CurAngle_Z = StartAngle_Z + J / (NSteps_Z - 1) * (EndAngle_Z - StartAngle_Z); //Back to front
                        #local CurBorder_Z = sin (radians (CurAngle_Z));
                        #for (K, 0, NSteps_Y - 1)
                           #local CurAngle_Y = StartAngle_Y + K / (NSteps_Y - 1) * (EndAngle_Y - StartAngle_Y); //Bottom to top
                           #local SegmentY = 1 / NSteps_Y / 2 + K / NSteps_Y;
                           #local Segment = object {
                              intersection {
                                 #local CurBorder_Y = sin (radians (CurAngle_Y));
                                 #local CurBorder = EffectWidth * CurBorder_Z * CurBorder_Y;
                                 MakeCharacter (I, CurBorder)
                                 #local Character_Outer = object {Character}
                                 MakeCharacter (I, CurBorder + WallThickness)
                                 #local Character_Inner = object {Character scale <1, 1, 1.2>}
                                 #local Slice = object {
                                    difference {
                                       object {Character_Outer}
                                       object {Character_Inner translate -.1 * z}
                                    } //difference
                                    translate -1 * z
                                    scale <1, 1, SegmentDepth>
                                    translate (-J * SegmentDepth) * z //Back is at z = 0
                                 } //object
                                 object {Slice}
                                 #if (K > 0)
                                    plane {y, SegmentY - YOffset inverse}
                                 #end //#if
                                 #if (K < NSteps_Y - 1)
                                    plane {y, SegmentY + YOffset}
                                 #end //#if
                              } //intersection
                           } //object
                           object {Segment}
                        #end //#for
                     #end //#for
                  } //union
                  texture {TextColor_Outer}
               } //object
               #declare Character = object {TempCharacter bounded_by {box {<-EffectWidth - .4, BorderCharacterHeight_Bottom [I] - EffectWidth - .01, -TextDepth - .01> <BorderCharacterWidth [I] + EffectWidth + .21, 1.08, .01>}}}
            #break //#case
            #case (39) //Raised border with hollow center
               #local TextDepth = P0;
               #if (I = 83 | I = 84) //HEART or STAR
                  #local InvisibleBorderWidth = 0;
               #else
                  #local InvisibleBorderWidth = P1;
               #end //#if
               #local BorderWidth_Outer = P2 / TextScale_Final;
               #local BorderWidth_Total = P3 / TextScale_Final;
               #local BorderDepth = P4;
               #if (P1 > 0)
                  #local MeasureWidths = true;
                  #local MeasurementDepthFactor = .5;
               #end //#if
               #local S = 1 / (1 - InvisibleBorderWidth * 2);
               #local BorderWidth_Outer = BorderWidth_Outer / S;
               #local BorderWidth_Total = BorderWidth_Total / S;
               MakeCharacter (I, InvisibleBorderWidth)
               #local Character_Outer = object {
                  intersection {
                     object {Character scale <1, 1, 1.1> texture {TextColor_Outer}}
                     plane {z, TextDepth texture {TextColor_Back}}
                  } //intersection
               } //object
               #local BorderWidth = min (BorderWidth_Total, BorderWidth_Outer);
               MakeCharacter (I, BorderWidth + InvisibleBorderWidth)
               #local Character_Inner = object {
                  object {Character scale <1, 1, 1.2> texture {TextColor_Outer}}
               } //object
               #declare Character = object {
                  difference {
                     object {Character_Outer}
                     object {Character_Inner translate -.1 * z}
                  } //difference
               } //object
               #if (BorderWidth_Total > BorderWidth_Outer)
                  #local TempCharacter = object {Character}
                  MakeCharacter (I, BorderWidth_Outer + InvisibleBorderWidth)
                  #local Character_Outer = object {
                     intersection {
                        object {Character scale <1, 1, 1.1> texture {TextColor_Inner} translate BorderDepth * z}
                        plane {z, TextDepth texture {TextColor_Back}}
                     } //intersection
                  } //object
                  MakeCharacter (I, BorderWidth_Total + InvisibleBorderWidth)
                  #local Character_Inner = object {
                     object {Character scale <1, 1, 1.2> texture {TextColor_Inner}}
                  } //object
                  #declare Character = object {
                     union {
                        object {TempCharacter}
                        difference {
                           object {Character_Outer}
                           object {Character_Inner translate -.1 * z}
                        } //difference
                     } //union
                  } //object
               #end //#if
               #declare Character = object {
                  Character
                  scale <S, S, 1>
                  translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               } //object
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            #break //#case
            #case (40) //Offset shadow
               #local TextDepth = P0;
               #if (I = 83 | I = 84) //HEART or STAR
                  #local InvisibleBorderWidth = 0;
               #else
                  #local InvisibleBorderWidth = P1;
               #end //#if
               #local Octant = P2;
               #local Offset = P3;
               #if (P1 > 0)
                  #local MeasureWidths = true;
                  #local MeasurementDepthFactor = .75;
               #end //#if
               #local S = 1 / (1 - InvisibleBorderWidth * 2);
               MakeCharacter (I, InvisibleBorderWidth)
               #local Character_Top = object {
                  Character
                  scale <1, 1, 1.1>
                  texture {TextColor_Inner}
                  scale <S, S, 1>
                  translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               } //object
               #local Character_Bottom = object {
                  Character
                  scale <1, 1, 1.1>
                  texture {TextColor_Outer}
                  scale <S, S, 1>
                  translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth / 2> //Back is at z = 0
               } //object
               #switch (Octant)
                  #case (1)
                     #local XSign = 1;
                     #local YSign = 0;
                  #break //#case
                  #case (2)
                     #local XSign = 1;
                     #local YSign = 1;
                  #break //#case
                  #case (3)
                     #local XSign = 0;
                     #local YSign = 1;
                  #break //#case
                  #case (4)
                     #local XSign = -1;
                     #local YSign = 1;
                  #break //#case
                  #case (5)
                     #local XSign = -1;
                     #local YSign = 0;
                  #break //#case
                  #case (6)
                     #local XSign = -1;
                     #local YSign = -1;
                  #break //#case
                  #case (7)
                     #local XSign = 0;
                     #local YSign = -1;
                  #break //#case
                  #case (8)
                     #local XSign = 1;
                     #local YSign = -1;
                  #break //#case
               #end //#switch
               #declare Character = object {
                  intersection {
                     union {
                        object {Character_Top}
                        object {Character_Bottom translate <XSign * Offset, YSign * Offset, 0>}
                     } //union
                     plane {z, 0 texture {TextColor_Back}}
                  } //intersection
               } //object
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            #break //#case
            #case (41) //Sine wave center
               #local TextDepth = P0;
               #if (I = 83 | I = 84) //HEART or STAR
                  #local InvisibleBorderWidth = 0;
               #else
                  #local InvisibleBorderWidth = P1;
               #end //#if
               #local BorderWidth = P2 / TextScale_Final;
               #local BorderDepth = P3;
               #local StartAngle = P4;
               #local EndAngle = P5;
               #local Amplitude = P6;
               #local NSteps = P7;
               #local CrossSection = P8;
               #if (P1 > 0)
                  #local MeasureWidths = true;
                  #local MeasurementDepthFactor = .5;
               #end //#if
               #local S = 1 / (1 - InvisibleBorderWidth * 2);
               #local BorderWidth = BorderWidth / S;
               #while (StartAngle < 0 | EndAngle < 0)
                  #local StartAngle = StartAngle + 360;
                  #local EndAngle = EndAngle + 360;
               #end //#while
               MakeCharacter (I, InvisibleBorderWidth)
               #local Character_Outer = object {Character scale <1, 1, 1.1>}
               MakeCharacter (I, BorderWidth + InvisibleBorderWidth)
               #local Character_Inner = object {Character scale <1, 1, 1.3>}
               #local Character_Outer = object {
                  difference {
                     object {Character_Outer}
                     object {Character_Inner translate -.1 * z}
                  } //difference
                  texture {TextColor_Outer}
               } //object
               #local StripeWidth = (StrokeWidth - BorderWidth * 2 - InvisibleBorderWidth * 2) / (NSteps * 2);
               #local DeltaAngle = (EndAngle - StartAngle) / (NSteps - 1);
               #local BorderDepth = BorderDepth + sin (radians (StartAngle)) * Amplitude;
               #for (J, 0, NSteps - 1)
                  #local CurAngle = StartAngle + DeltaAngle * J;
                  #local CurBorderWidth = BorderWidth + InvisibleBorderWidth + J * StripeWidth;
                  MakeCharacter (I, CurBorderWidth)
                  #local Character_Segment = object {Character scale <1, 1, 3>}
                  #if (J = 0)
                     #local CurZOffset = -sin (radians (CurAngle)) * Amplitude;
                     #local Character_Inner = object {Character_Segment translate CurZOffset * z}
                     #local LastZOffset = CurZOffset;
                  #else
                     #local CurZOffset = -sin (radians (CurAngle)) * Amplitude;
                     #if (CurZOffset < LastZOffset)
                        #local Character_Inner = object {
                           union {
                              object {Character_Inner}
                              object {Character_Segment translate CurZOffset * z}
                           } //union
                        } //object
                     #else
                        #local Character_Inner = object {
                           union {
                              difference {
                                 object {Character_Inner}
                                 object {Character_Segment translate -1 * z}
                              } //difference
                              object {Character_Segment translate CurZOffset * z}
                           } //union
                        } //object
                     #end //#if
                     #local LastZOffset = CurZOffset;
                  #end //#if
               #end //#for
               #declare Character = object {
                  intersection {
                     union {
                        object {Character_Outer}
                        object {Character_Inner texture {TextColor_Inner} translate BorderDepth * z}
                     } //union
                     plane {z, TextDepth texture {TextColor_Back}}
                  } //intersection
                  scale <S, S, 1>
                  translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
               } //object
               #if (CrossSection)
                  #declare Character = object {
                     union {
                        intersection {
                           object {Character_Outer}
                           plane {z, TextDepth texture {TextColor_Back}}
                           plane {y, .25 inverse texture {pigment {color Navy} finish {emission 1}}}
                           plane {y, .2501 texture {pigment {color Navy} finish {emission 1}}}
                        } //intersection
                        intersection {
                           object {Character_Inner texture {TextColor_Inner} translate BorderDepth * z}
                           plane {z, TextDepth texture {TextColor_Back}}
                           plane {y, .25 inverse texture {pigment {color Red} finish {emission 1}}}
                           plane {y, .2501 texture {pigment {color Red} finish {emission 1}}}
                        } //intersection
                     } //union
                     scale <S, S, 1>
                     translate <-InvisibleBorderWidth * S, -InvisibleBorderWidth * S, -TextDepth> //Back is at z = 0
                     translate -.25 * y
                     rotate 70 * x
                     translate <.4, .2, -.8>
                  } //object
                  #local MeasureWidths = false;
               #end //#if
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] * S - InvisibleBorderWidth * S * 2;
            #break //#case
         #end //#switch
         #declare BorderCharacter [I] = object {Character}
      #end //#if
   #end //#for

   #if (MeasureWidths)
      #local TestZ = -TextDepth * MeasurementDepthFactor;
      #local Accuracy = 1/1000000;
      #for (I, 0, NDefinedCharacters - 1)
         #if (CharacterInUse [I])
            #local TestIntersection = trace (BorderCharacter [I], <Accuracy, 10, TestZ>, -y);
            #if (TestIntersection.z = 0)
               #local X0 = 0;
               #local X1 = BorderCharacterWidth [I];
               #while (X1 - X0 > Accuracy)
                  #local Midpoint = (X0 + X1) / 2;
                  #local TestIntersection = trace (BorderCharacter [I], <Midpoint, 10, TestZ>, -y);
                  #if (TestIntersection.z = 0)
                     #local X0 = Midpoint;
                  #else
                     #local X1 = Midpoint;
                  #end //#if
               #end //#while
               #local LeftEdge = (X0 + X1) / 2;
               #declare BorderCharacter [I] = object {BorderCharacter [I] translate -LeftEdge * x}
               #declare BorderCharacterWidth [I] = BorderCharacterWidth [I] - LeftEdge;
            #end //#if
            #local TestIntersection = trace (BorderCharacter [I], <BorderCharacterWidth [I] - Accuracy, 10, TestZ>, -y);
            #if (TestIntersection.z = 0)
               #local X0 = 0;
               #local X1 = BorderCharacterWidth [I];
               #while (X1 - X0 > Accuracy)
                  #local Midpoint = (X0 + X1) / 2;
                  #local TestIntersection = trace (BorderCharacter [I], <Midpoint, 10, TestZ>, -y);
                  #if (TestIntersection.z = 0)
                     #local X1 = Midpoint;
                  #else
                     #local X0 = Midpoint;
                  #end //#if
               #end //#while
               #local RightEdge = (X0 + X1) / 2;
               #declare BorderCharacterWidth [I] = RightEdge;
            #end //#if
         #end //#if
      #end //#for
   #end //#if

#end //#macro Stylize
