// Fabien HENON * 1997

// a render I did when I was working on SAP  (ERP) back in 1997
// to render with povray 3.0

global_settings {
  max_trace_level 15

  max_intersections 500
  }

#declare mem=1

//background { color <0.847,0.847,0.847> }

camera {  //  Camera StdCam
  location  <-6,2.3,-10 >
  direction <0.0,0.0,  3.5687>


                                                             #switch (mem)
                                                            #case (1)

//  blur_samples 100
//  confidence 1
//  variance 1/518
//  focal_point <-0.4,1,-1>
//  aperture 0.2
                                                            #end

   look_at   <-0.4, 1, -0.6>  // <-0.7, 1.4, -0.6>
}

// *******  L I G H T S *******
light_source {   // Light1
  <16, 45.316, -79>
  color rgb <0.98, 0.98, 1>*0.95
//area_light <-0.2, 1.7, 1>,
//<2, -0.1, 0.5>, 4, 4  adaptive 1
//jitter
}


light_source {   // Light1
  <-34, 30.316, -51>
  color rgb <1,0.98,0.98>*0.3
//area_light <-0.2009821, 1.93403, 1.10414>,
//<2.16497, -0.09019843, 0.5520716>, 6, 6  adaptive 1
//jitter
shadowless }



#declare tour=-20


// ********  TEXTURES  *******
//

#include "sap2.inc"



// ********  REFERENCED OBJECTS  *******




// ********  OBJECTS  *******





#declare bas=
lathe {                                      // flacon
  cubic_spline
  12  // control points
  <0.063483, -0.09065>,
  <0.005917, 0.00348>,
  <0.591551, 0.03462>,
  <0.703982, 0.48465>,
  <0.553988, 1.324492>,
  <0.654176, 1.640098>,
  <0.574024, 1.86902>,
  <0.244646, 1.943551>,
  <0.20971, 2.06>,
  <0.14491, 2.047883>,
  <0.13101, 2.2>, // 1.90
  <0.224601, 2.188174> //2.188174
  rotate <0,0,0>
  texture {
    Texture02
    scale <1 , 2 , 1>
  }
  scale <1 , 1 , 0.6>
rotate y*tour
translate <-0.6,0,-0.3>
}



#declare coin=
merge {
        cylinder { <0,0,0>,<0,1,0>,0.1 }
        sphere { <0,1,0>,0.1 }
scale <0.4,1,1>
}

#declare coins=
union {
#declare rot=0
#while (rot<360)
object { coin translate <1,0,0> rotate y*rot }
#declare rot=rot+360/15
#end }


#include "colors.inc"
#include "stones.inc"


#declare plancher=
plane { y,0
clipped_by { cylinder { <0,-0.5,0>,<0,0.5,0>,1.55*1.2 inverse
  scale <1.74484, 1, 2.936583>
  rotate <0,90,0>
  translate  <6.0, 0, 2.702064> }}
clipped_by { plane { z,-20 inverse }}
}




#declare basin=                         // lavabo
object {
lathe {
  cubic_spline
  10  // control points
  <1.0, -1.0>,
  <1.408, -0.851683>,
  <1.563, 0.533884>,
  <1.571, 1.057707>,
  <1.493, 1.00417>,
  <1.351, 0.97932>,
  <1.29045, 0.824644>,
  <1.135, -0.203866>,
  <0.075, -0.411752>,
  <0.0206, -0.4068>
  scale <1.74484*1.2, 5, 2.936583*1.2>
  rotate <0,90,0>
  translate  <6.0, -5.2, 2.702064>
}

}


union {
        object { basin }  // translate <8,0,10>
        object { plancher }
texture { T_Stone11 scale 2
finish { reflection 0.08 phong 0.7 phong_size 80}
}
}

#declare Texture01 = texture {
   pigment {
     color rgbf<0.96, 0.96, 0.96, 0.96>
   }
   finish {
     diffuse 0.600
     ambient 0.100
     refraction on
     ior 1.002
     phong 0.25
     phong_size 18
   }

}


#declare haut=
lathe {                                 // bouchon du flacon
  cubic_spline
  17  // control points
  <0.001744, 0.60837>,
  <0.009946, 0.739785>,
  <0.393369, 0.680107>,
  <0.76195, 0.595548>,
  <0.937276, 0.453703>,
  <1.003543, 0.213378>,
  <1.010348, -0.022744>,
  <0.992806, -0.659907>,
  <0.956587, -0.925234>,
  <1.011032, -0.981007>,
  <1.056006, -0.455258>,
  <1.067344, 0.015826>,
  <1.020753, 0.421243>,
  <0.827667, 0.64068>,
  <0.416577, 0.749732>,
  <0.0, 0.8>,
  <0.0, 0.8>
  //rotate <90,0,90>
  texture {
    Texture01
  }
  scale <0.33, 0.25, 0.198>
rotate y*tour
  translate  <-0.6,2.15,-0.3>
}


union {
      object { haut }
      object { bas }
      translate <0.4,0,-0.7>
      }



// mur du fond





#include "robinet.inc"

object { tuyaux
scale 0.5
rotate <-90,90,0>
translate <8,0,9> }


sphere { // Sphere001
  <0,0,0>,0.5
  texture {
    rouge
  }
  scale <0.15, 0.05, 0.15>
  translate y*0.91
  rotate x*-15
  translate  <5, 0,9>
}


sphere { // Sphere001
  <0,0,0>,0.5
  texture {
          bleu
          }
  scale <0.15, 0.05, 0.15>
  translate y*0.91
  rotate x*-15
  translate  <8, 0,9>
}

#include "puddle.inc"

object { Puddle
scale <0.5,0.35,0.5>
translate <-1.2,0,-0.97> }



////////// L i Q u I d E   v E r T ///////

#declare bulles=
union {
#declare R1 = seed(3)
#declare R2 = seed(12345)
#declare xx=0
#while (xx<65)
sphere { <0,0,0>,0.5
scale <0.1,0.06,0.1>
rotate y*rand(R2)*360
translate <rand(R1)*0.4,-1+rand(R1)*1, rand(R1)*0.4>
rotate y*rand(R2)*360
pigment { color rgbf 0.95 }
finish { refraction on ior 1 ambient 0 diffuse 0.1
phong 0.2 phong_size 20 }
}
#declare xx=xx+1
#end
}


#declare liquid=
intersection {
height_field {
          tga "fond.tga"
              water_level 0.0
                                                #switch (mem)
                                                    #case (1)

                  smooth
                                                #end
      translate <-0.5,0,-0.5>
      scale <1.0000001,0.5,1.0000001>
      translate y*-0.54
      }
sphere { <0,0,0>,1 scale <0.5,1,0.5>*0.967 }
object { bulles inverse }
bounded_by { sphere { <0,0,0>,1 scale <0.5,1,0.5>}}
translate y*2.244
}


#declare liquide=
          object { liquid

pigment {
color rgbf <0.4,0.7,0.2,0.97> }
finish { ambient 0.0 phong 0.2 phong_size 20
refraction on ior 1.33 reflection 0.05
fade_distance 2
fade_power 0.7
caustics 0.9
}
//bounded_by { sphere { <0,0,0>,1 scale <0.5,1,0.5> translate y*2.244467 }}
}




plane { y,-0.1
pigment { color rgbf <0.95,0.9,0.9,0.9> }
finish { phong 0.1 phong_size 150 refraction on ior 1.33 reflection 0.05 }
normal { waves 0.08 scale 0.05 turbulence 0.05
translate <6.5,0,5> }
clipped_by { plane { z,-20 inverse }}
}


#declare Smoke =
sphere { 0,1
    hollow
    no_shadow
    pigment { color rgbf 1 }
    halo {
        linear
        max_value 0.15
        cylindrical_mapping
        attenuating
        turbulence 1
        octaves 6
        omega (1/1.618)
        lambda 1.618
        color_map {
             [0.0 color rgbt <0.1, 0.1, 0.1,1>]
             [0.11 color rgbt <0.1, 0.15, 0.1, 0.43>] // 0.6
             [1.0 color rgbt <0, 0, 0, 0>]
        }
        scale <0.4, 0.4, 0.4>
        samples 10
        aa_level 0
        aa_threshold 0.3
    }
    scale <0.8, 1.4, 0.8>
    translate <0, 0, 0>
}



#declare fumee=
intersection {
object { Smoke
translate <-1.4,2,-1>
}
plane { y,1.4 inverse
pigment { color rgbf <1,1,1,1> }
}
bounded_by { sphere { 0,1 scale <0.8, 1.4, 0.8> translate <-1.4,2,-1> }}
}

object { fumee }

#declare carreau=
union {
      sphere { <0,0,0>,0.1 }
      sphere { <1,0,0>,0.1 }
      sphere { <1,1,0>,0.1 }
      sphere { <0,1,0>,0.1 }
cylinder { <0,0,0>,<1,0,0>,0.1 }
cylinder { <1,0,0>,<1,1,0>,0.1 }
cylinder { <1,1,0>,<0,1,0>,0.1 }
cylinder { <0,1,0>,<0,0,0>,0.1 }
box { <0,0,-0.1>,<1,1,0> }
}


#declare suite=union {
#declare xx=-20
#while (xx<20)
object { carreau
translate <xx,0,0>}
#declare xx=xx+1.2
#end
}




#declare mur=union {
#declare yy=0
#while (yy<20)
object { suite
translate <0,yy,0>}
#declare yy=yy+1.2
#end
pigment { color rgb <0.92,0.92,0.92> }
finish { reflection 0.0 ambient 0.23 diffuse 0.6
specular 0.7 roughness 0.01 }
normal { bumps 0.0 scale 0.4 turbulence 0.4 }
}


plane { z,15 inverse
pigment { color rgb 0.2 }}

object { mur
translate <0,0.1,15> }

plane { z,0
pigment {
        image_map { gif "kmap.gif" }}
finish { ambient 0.1 diffuse 0.8 }

scale 5
translate z*-160 }


background { color rgb 0.8 }

//////////////

#declare bout=
intersection {
prism {
  linear_sweep
  quadratic_spline
  -1,1
  10  // control points
  <-0.02225, 0.269763>,
  <-0.021647, -0.157002>,
  <0.089384, -0.149374>,
  <0.121799, -0.043406>,
  <0.058418, 0.087513>,
  <0.184124, 0.203498>,
  <0.091152, 0.291299>,
  <0.01924, 0.385224>,
  <-0.02225, 0.269763>,
  <-0.021647, -0.157002>
  scale <1,1000,1>
  rotate -x*90
  translate  <0.005134, 0.349621,0 >
}
plane { z,0 rotate y*30 inverse }
plane { z,0 rotate y*-30  }
bounded_by { box { <0,0.13,-0.5>,<0.2,0.7,0.5> } }
}


#declare segment2=merge {
#declare rot=0
#while (rot<360)
object { bout rotate y*rot }
#declare rot=rot+360/6
#end
}


#declare vase=
difference {
sphere { 0,1
  scale <0.5, 1.0, 0.5>
   }
sphere { 0,1
  scale <0.5, 1.0, 0.5>*0.97
  }
plane { y,0 inverse }
bounded_by { box { <-0.6,-1,-0.6>,<0.6,0,0.6> }}
translate  2.244467*y
}


#declare tor=
torus { 0.4925,0.0075 sturm
      scale <1,1.5,1>
      translate 2.244467*y
}


#declare rond=
difference {
lathe {
  quadratic_spline
  8  // control points
  <0.110726, 0.195978>,
  <0.12032, 0.632324>,
  <0.180939, 0.882599>,
  <0.131064, 1.178663>,
  <0.196814, 1.300194>,
  <0.099606, 1.413934>,
  <0.041514, 1.336066>,
  <0.015973, 1.186076>
  scale <0.8,1,0.8>
  }
 sphere { <0,0,0>,1
  scale <0.5, 1.0, 0.5>*0.98
  translate  2.244467*y }
bounded_by { box { <-0.2,0.15,-0.2>,<0.2,1.4,0.2> }}
  }

#declare pied=
lathe { //  pied du bas
  cubic_spline
  8  // control points
  <0.984986, 0.005238>,
  <0.000083, 0.000253>,
  <0.676386, 0.010586>,
  <0.647544, 0.107139>,
  <0.522368, 0.149945>,
  <0.250289, 0.159668>,
  <0.00271, 0.239448>,
  <0.17498, 0.428194>
  scale <0.8,0.8,0.8>
}

#declare ensemble=merge {
object { segment2 scale <0.9,1,0.9>}
object { pied }
object { rond scale <0.9,1,0.9>}
object { vase }
object { tor }
}

#declare glass=
texture {
        pigment { color rgbf <0.98, 0.98, 0.98, 0.94 > }

finish  {
    ambient 0.07
    diffuse 0.05
    reflection 0.11
    refraction on
    ior 1.6
    specular 0.8
    roughness 0.001
    phong 0.8
    phong_size 470
    fade_distance 2
    fade_power 0.7
    caustics 0.9
 }
normal { bump_map { gif "kmap1.gif" interpolate 2 map_type 2 once }
                }
                     }

#include"golds.inc"

#declare OR=
texture { T_Gold_3E
normal { bump_map { gif "kmap1.gif" interpolate 2 map_type 2 once }}
}


#declare verre=
object { ensemble
texture {
        material_map { gif "kmap1.gif" interpolate 2 map_type 2 once
                     texture { glass }
                     texture { OR }}
                     scale <1,0.8,1>
                     translate y*1.5
                     rotate y*-65
                     }
}


union {
      object { liquide }
      object { verre }
scale 0.7
translate <-1.4,0,-1>
}





////////////// M i R o I r  //////////////////////



#declare plast = texture {
   pigment {
     color rgb<0.701, 0.407, 0.314>
   }
   finish {
     diffuse 0.670
     ambient 0.210
     phong 0.350
     phong_size 11.600
     brilliance 1.001
   }

}


#declare mir=
union {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    scale <7.02357, 12.219548, 0.05>*1.05
pigment { color rgb 1 }
finish { reflection 0.98 ambient 0 diffuse 0 phong 1 phong_size 10}
  }


lathe {
  cubic_spline
  10  // control points
  <1.745246, -0.881584>,
  <4.26429, -0.49424>,
  <4.804781, -0.157477>,
  <4.96771, 0.169377>,
  <4.82894, 0.47501>,
  <4.641945, 0.331451>,
  <4.52229, -0.018477>,
  <4.484086, -0.197255>,
  <4.201359, -0.380069>,
  <4.093345, -1.178368>
  rotate <90,0,90>
  texture {
    plast
  }
  scale <1.7, 3.0, 1.0>
  translate  0.510727*z
}
}

object { mir
scale <0.22,0.17,0.17>*1.3
rotate x*-180
translate <8,4,14.8>
}
