/*



global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <7.352, -8.255, 3.504>
  direction <0.0,     0.0,  2.8396>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <-0.506, 3.046, 0.660>
}

// *******  L I G H T S *******
light_source {   // Light1
  <0.376, -6.266, 10.316>
  color rgb <1.000, 1.000, 1.000>
}


// ********  TEXTURES  *******
//


*/

#include "rob.inc"

#declare tuyaux= union {   ////// ensemble de tuyaux


// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******



#declare BzPtch001 = union {



  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <0.299982, 0.000000, 0.000000>, <0.299982, -0.158666, 0.000000>, <0.164990, -0.288483, 0.000000>, <0.000000, -0.288483, 0.000000>,
      <0.299982, 0.000000, 0.137343>, <0.299982, -0.158666, 0.137343>, <0.164990, -0.288483, 0.137343>, <0.000000, -0.288483, 0.137343>,
      <0.478257, 0.000000, 0.274686>, <0.478257, -0.238530, 0.274686>, <0.263041, -0.433690, 0.274686>, <0.000000, -0.433690, 0.274686>,
      <0.478257, 0.000000, 0.412029>, <0.478257, -0.238530, 0.412029>, <0.263041, -0.433690, 0.412029>, <0.000000, -0.433690, 0.412029>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <0.000000, -0.288483, 0.000000>, <-0.164990, -0.288483, 0.000000>, <-0.299982, -0.158666, 0.000000>, <-0.299982, 0.000000, 0.000000>,
      <0.000000, -0.288483, 0.137343>, <-0.164990, -0.288483, 0.137343>, <-0.299982, -0.158666, 0.137343>, <-0.299982, 0.000000, 0.137343>,
      <0.000000, -0.433690, 0.274686>, <-0.263041, -0.433690, 0.274686>, <-0.478257, -0.238530, 0.274686>, <-0.478257, 0.000000, 0.274686>,
      <0.000000, -0.433690, 0.412029>, <-0.263041, -0.433690, 0.412029>, <-0.478257, -0.238530, 0.412029>, <-0.478257, 0.000000, 0.412029>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <-0.299982, 0.000000, 0.000000>, <-0.299982, 0.158666, 0.000000>, <-0.164990, 0.288483, 0.000000>, <0.000000, 0.288483, 0.000000>,
      <-0.299982, 0.000000, 0.137343>, <-0.299982, 0.158666, 0.137343>, <-0.164990, 0.288483, 0.137343>, <0.000000, 0.288483, 0.137343>,
      <-0.478257, 0.000000, 0.274686>, <-0.478257, 0.238530, 0.274686>, <-0.263041, 0.433690, 0.274686>, <0.000000, 0.433690, 0.274686>,
      <-0.478257, 0.000000, 0.412029>, <-0.478257, 0.238530, 0.412029>, <-0.263041, 0.433690, 0.412029>, <0.000000, 0.433690, 0.412029>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <0.000000, 0.288483, 0.000000>, <0.164990, 0.288483, 0.000000>, <0.299982, 0.158666, 0.000000>, <0.299982, 0.000000, 0.000000>,
      <0.000000, 0.288483, 0.137343>, <0.164990, 0.288483, 0.137343>, <0.299982, 0.158666, 0.137343>, <0.299982, 0.000000, 0.137343>,
      <0.000000, 0.433690, 0.274686>, <0.263041, 0.433690, 0.274686>, <0.478257, 0.238530, 0.274686>, <0.478257, 0.000000, 0.274686>,
      <0.000000, 0.433690, 0.412029>, <0.263041, 0.433690, 0.412029>, <0.478257, 0.238530, 0.412029>, <0.478257, 0.000000, 0.412029>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <0.478257, 0.000000, 0.412029>, <0.478257, -0.238530, 0.412029>, <0.263041, -0.433690, 0.412029>, <0.000000, -0.433690, 0.412029>,
      <0.478257, 0.000000, 0.549371>, <0.478257, -0.238530, 0.549371>, <0.263041, -0.433690, 0.549371>, <0.000000, -0.433690, 0.549371>,
      <0.478257, 0.000000, 0.686714>, <0.478257, -0.238530, 0.686714>, <0.263041, -0.433690, 0.686714>, <0.000000, -0.433690, 0.686714>,
      <0.535951, 0.000000, 0.824057>, <0.501031, -0.252639, 0.824057>, <0.275567, -0.459344, 0.824057>, <0.000000, -0.459344, 0.824057>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <0.000000, -0.433690, 0.412029>, <-0.263041, -0.433690, 0.412029>, <-0.478257, -0.238530, 0.412029>, <-0.478257, 0.000000, 0.412029>,
      <0.000000, -0.433690, 0.549371>, <-0.263041, -0.433690, 0.549371>, <-0.478257, -0.238530, 0.549371>, <-0.478257, 0.000000, 0.549371>,
      <0.000000, -0.433690, 0.686714>, <-0.263041, -0.433690, 0.686714>, <-0.478257, -0.238530, 0.686714>, <-0.478257, 0.000000, 0.686714>,
      <0.000000, -0.459344, 0.824057>, <-0.275567, -0.459344, 0.824057>, <-0.501031, -0.252639, 0.824057>, <-0.535951, 0.000000, 0.824057>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <-0.478257, 0.000000, 0.412029>, <-0.478257, 0.238530, 0.412029>, <-0.263041, 0.433690, 0.412029>, <0.000000, 0.433690, 0.412029>,
      <-0.478257, 0.000000, 0.549371>, <-0.478257, 0.238530, 0.549371>, <-0.263041, 0.433690, 0.549371>, <0.000000, 0.433690, 0.549371>,
      <-0.478257, 0.000000, 0.686714>, <-0.478257, 0.238530, 0.686714>, <-0.263041, 0.433690, 0.686714>, <0.000000, 0.433690, 0.686714>,
      <-0.535951, 0.000000, 0.824057>, <-0.501031, 0.252639, 0.824057>, <-0.275567, 0.459344, 0.824057>, <0.000000, 0.459344, 0.824057>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <0.000000, 0.433690, 0.412029>, <0.263041, 0.433690, 0.412029>, <0.478257, 0.238530, 0.412029>, <0.478257, 0.000000, 0.412029>,
      <0.000000, 0.433690, 0.549371>, <0.263041, 0.433690, 0.549371>, <0.478257, 0.238530, 0.549371>, <0.478257, 0.000000, 0.549371>,
      <0.000000, 0.433690, 0.686714>, <0.263041, 0.433690, 0.686714>, <0.478257, 0.238530, 0.686714>, <0.478257, 0.000000, 0.686714>,
      <0.000000, 0.459344, 0.824057>, <0.275567, 0.459344, 0.824057>, <0.501031, 0.252639, 0.824057>, <0.535951, 0.000000, 0.824057>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <0.535951, 0.000000, 0.824057>, <0.501031, -0.252639, 0.824057>, <0.275567, -0.459344, 0.824057>, <0.000000, -0.459344, 0.824057>,
      <0.523805, 0.000000, 0.961400>, <0.523805, -0.266749, 0.961400>, <0.288093, -0.484998, 0.961400>, <0.000000, -0.484998, 0.961400>,
      <0.911817, -0.251828, 1.098743>, <1.369308, -0.776999, 1.098743>, <0.249880, -0.496986, 1.098743>, <-0.251620, -0.954855, 1.098743>,
      <0.911817, -0.251828, 1.236086>, <1.369308, -0.776999, 1.236086>, <0.249880, -0.496986, 1.236086>, <-0.251620, -0.954855, 1.236086>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <0.000000, -0.459344, 0.824057>, <-0.275567, -0.459344, 0.824057>, <-0.501031, -0.252639, 0.824057>, <-0.535951, 0.000000, 0.824057>,
      <0.000000, -0.484998, 0.961400>, <-0.288093, -0.484998, 0.961400>, <-0.523805, -0.266749, 0.961400>, <-0.523805, 0.000000, 0.961400>,
      <-0.251620, -0.954855, 1.098743>, <-0.753120, -1.412725, 1.098743>, <-0.454326, -0.273342, 1.098743>, <-0.911817, 0.251828, 1.098743>,
      <-0.251620, -0.954855, 1.236086>, <-0.753120, -1.412725, 1.236086>, <-0.454326, -0.273342, 1.236086>, <-0.911817, 0.251828, 1.236086>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <-0.535951, 0.000000, 0.824057>, <-0.501031, 0.252639, 0.824057>, <-0.275567, 0.459344, 0.824057>, <0.000000, 0.459344, 0.824057>,
      <-0.523805, 0.000000, 0.961400>, <-0.523805, 0.266749, 0.961400>, <-0.288093, 0.484998, 0.961400>, <0.000000, 0.484998, 0.961400>,
      <-0.911817, 0.251828, 1.098743>, <-1.369308, 0.776999, 1.098743>, <-0.249880, 0.496986, 1.098743>, <0.251620, 0.954855, 1.098743>,
      <-0.911817, 0.251828, 1.236086>, <-1.369308, 0.776999, 1.236086>, <-0.249880, 0.496986, 1.236086>, <0.251620, 0.954855, 1.236086>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <0.000000, 0.459344, 0.824057>, <0.275567, 0.459344, 0.824057>, <0.501031, 0.252639, 0.824057>, <0.535951, 0.000000, 0.824057>,
      <0.000000, 0.484998, 0.961400>, <0.288093, 0.484998, 0.961400>, <0.523805, 0.266749, 0.961400>, <0.523805, 0.000000, 0.961400>,
      <0.251620, 0.954855, 1.098743>, <0.753120, 1.412725, 1.098743>, <0.454326, 0.273342, 1.098743>, <0.911817, -0.251828, 1.098743>,
      <0.251620, 0.954855, 1.236086>, <0.753120, 1.412725, 1.236086>, <0.454326, 0.273342, 1.236086>, <0.911817, -0.251828, 1.236086>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <0.911817, -0.251828, 1.236086>, <1.369308, -0.776999, 1.236086>, <0.249880, -0.496986, 1.236086>, <-0.251620, -0.954855, 1.236086>,
      <0.911817, -0.251828, 1.373428>, <1.369308, -0.776999, 1.373428>, <0.249880, -0.496986, 1.373428>, <-0.251620, -0.954855, 1.373428>,
      <0.911817, -0.251828, 1.676667>, <1.369308, -0.776999, 1.676667>, <0.249880, -0.496986, 1.676667>, <-0.251620, -0.954855, 1.676667>,
      <0.011565, 0.000000, 1.648114>, <0.011565, -0.006667, 1.648114>, <0.006361, -0.012122, 1.648114>, <0.000000, -0.012122, 1.648114>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <-0.251620, -0.954855, 1.236086>, <-0.753120, -1.412725, 1.236086>, <-0.454326, -0.273342, 1.236086>, <-0.911817, 0.251828, 1.236086>,
      <-0.251620, -0.954855, 1.373428>, <-0.753120, -1.412725, 1.373428>, <-0.454326, -0.273342, 1.373428>, <-0.911817, 0.251828, 1.373428>,
      <-0.251620, -0.954855, 1.676667>, <-0.753120, -1.412725, 1.676667>, <-0.454326, -0.273342, 1.676667>, <-0.911817, 0.251828, 1.676667>,
      <0.000000, -0.012122, 1.648114>, <-0.006361, -0.012122, 1.648114>, <-0.011565, -0.006667, 1.648114>, <-0.011565, 0.000000, 1.648114>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <-0.911817, 0.251828, 1.236086>, <-1.369308, 0.776999, 1.236086>, <-0.249880, 0.496986, 1.236086>, <0.251620, 0.954855, 1.236086>,
      <-0.911817, 0.251828, 1.373428>, <-1.369308, 0.776999, 1.373428>, <-0.249880, 0.496986, 1.373428>, <0.251620, 0.954855, 1.373428>,
      <-0.911817, 0.251828, 1.676667>, <-1.369308, 0.776999, 1.676667>, <-0.249880, 0.496986, 1.676667>, <0.251620, 0.954855, 1.676667>,
      <-0.011565, 0.000000, 1.648114>, <-0.011565, 0.006667, 1.648114>, <-0.006361, 0.012122, 1.648114>, <0.000000, 0.012122, 1.648114>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <0.251620, 0.954855, 1.236086>, <0.753120, 1.412725, 1.236086>, <0.454326, 0.273342, 1.236086>, <0.911817, -0.251828, 1.236086>,
      <0.251620, 0.954855, 1.373428>, <0.753120, 1.412725, 1.373428>, <0.454326, 0.273342, 1.373428>, <0.911817, -0.251828, 1.373428>,
      <0.251620, 0.954855, 1.676667>, <0.753120, 1.412725, 1.676667>, <0.454326, 0.273342, 1.676667>, <0.911817, -0.251828, 1.676667>,
      <0.000000, 0.012122, 1.648114>, <0.006361, 0.012122, 1.648114>, <0.011565, 0.006667, 1.648114>, <0.011565, 0.000000, 1.648114>
    }
  }
  texture {
    Chrome_Textur1
  }
  translate  0.15*z
}
union { // CSG002
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    texture {
      noir
    }
    scale <0.3, 0.3, 1.0>
    translate  -0.2*z
  }
  object { BzPtch001 }
  rotate 15.0*y
}                           //gauche


#declare BzPtch2 = union {
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <0.299982, 0.000000, 0.000000>, <0.299982, -0.158666, 0.000000>, <0.164990, -0.288483, 0.000000>, <0.000000, -0.288483, 0.000000>,
      <0.299982, 0.000000, 0.137343>, <0.299982, -0.158666, 0.137343>, <0.164990, -0.288483, 0.137343>, <0.000000, -0.288483, 0.137343>,
      <0.478257, 0.000000, 0.274686>, <0.478257, -0.238530, 0.274686>, <0.263041, -0.433690, 0.274686>, <0.000000, -0.433690, 0.274686>,
      <0.478257, 0.000000, 0.412029>, <0.478257, -0.238530, 0.412029>, <0.263041, -0.433690, 0.412029>, <0.000000, -0.433690, 0.412029>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <0.000000, -0.288483, 0.000000>, <-0.164990, -0.288483, 0.000000>, <-0.299982, -0.158666, 0.000000>, <-0.299982, 0.000000, 0.000000>,
      <0.000000, -0.288483, 0.137343>, <-0.164990, -0.288483, 0.137343>, <-0.299982, -0.158666, 0.137343>, <-0.299982, 0.000000, 0.137343>,
      <0.000000, -0.433690, 0.274686>, <-0.263041, -0.433690, 0.274686>, <-0.478257, -0.238530, 0.274686>, <-0.478257, 0.000000, 0.274686>,
      <0.000000, -0.433690, 0.412029>, <-0.263041, -0.433690, 0.412029>, <-0.478257, -0.238530, 0.412029>, <-0.478257, 0.000000, 0.412029>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <-0.299982, 0.000000, 0.000000>, <-0.299982, 0.158666, 0.000000>, <-0.164990, 0.288483, 0.000000>, <0.000000, 0.288483, 0.000000>,
      <-0.299982, 0.000000, 0.137343>, <-0.299982, 0.158666, 0.137343>, <-0.164990, 0.288483, 0.137343>, <0.000000, 0.288483, 0.137343>,
      <-0.478257, 0.000000, 0.274686>, <-0.478257, 0.238530, 0.274686>, <-0.263041, 0.433690, 0.274686>, <0.000000, 0.433690, 0.274686>,
      <-0.478257, 0.000000, 0.412029>, <-0.478257, 0.238530, 0.412029>, <-0.263041, 0.433690, 0.412029>, <0.000000, 0.433690, 0.412029>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <0.000000, 0.288483, 0.000000>, <0.164990, 0.288483, 0.000000>, <0.299982, 0.158666, 0.000000>, <0.299982, 0.000000, 0.000000>,
      <0.000000, 0.288483, 0.137343>, <0.164990, 0.288483, 0.137343>, <0.299982, 0.158666, 0.137343>, <0.299982, 0.000000, 0.137343>,
      <0.000000, 0.433690, 0.274686>, <0.263041, 0.433690, 0.274686>, <0.478257, 0.238530, 0.274686>, <0.478257, 0.000000, 0.274686>,
      <0.000000, 0.433690, 0.412029>, <0.263041, 0.433690, 0.412029>, <0.478257, 0.238530, 0.412029>, <0.478257, 0.000000, 0.412029>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <0.478257, 0.000000, 0.412029>, <0.478257, -0.238530, 0.412029>, <0.263041, -0.433690, 0.412029>, <0.000000, -0.433690, 0.412029>,
      <0.478257, 0.000000, 0.549371>, <0.478257, -0.238530, 0.549371>, <0.263041, -0.433690, 0.549371>, <0.000000, -0.433690, 0.549371>,
      <0.478257, 0.000000, 0.686714>, <0.478257, -0.238530, 0.686714>, <0.263041, -0.433690, 0.686714>, <0.000000, -0.433690, 0.686714>,
      <0.535951, 0.000000, 0.824057>, <0.501031, -0.252639, 0.824057>, <0.275567, -0.459344, 0.824057>, <0.000000, -0.459344, 0.824057>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <0.000000, -0.433690, 0.412029>, <-0.263041, -0.433690, 0.412029>, <-0.478257, -0.238530, 0.412029>, <-0.478257, 0.000000, 0.412029>,
      <0.000000, -0.433690, 0.549371>, <-0.263041, -0.433690, 0.549371>, <-0.478257, -0.238530, 0.549371>, <-0.478257, 0.000000, 0.549371>,
      <0.000000, -0.433690, 0.686714>, <-0.263041, -0.433690, 0.686714>, <-0.478257, -0.238530, 0.686714>, <-0.478257, 0.000000, 0.686714>,
      <0.000000, -0.459344, 0.824057>, <-0.275567, -0.459344, 0.824057>, <-0.501031, -0.252639, 0.824057>, <-0.535951, 0.000000, 0.824057>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <-0.478257, 0.000000, 0.412029>, <-0.478257, 0.238530, 0.412029>, <-0.263041, 0.433690, 0.412029>, <0.000000, 0.433690, 0.412029>,
      <-0.478257, 0.000000, 0.549371>, <-0.478257, 0.238530, 0.549371>, <-0.263041, 0.433690, 0.549371>, <0.000000, 0.433690, 0.549371>,
      <-0.478257, 0.000000, 0.686714>, <-0.478257, 0.238530, 0.686714>, <-0.263041, 0.433690, 0.686714>, <0.000000, 0.433690, 0.686714>,
      <-0.535951, 0.000000, 0.824057>, <-0.501031, 0.252639, 0.824057>, <-0.275567, 0.459344, 0.824057>, <0.000000, 0.459344, 0.824057>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <0.000000, 0.433690, 0.412029>, <0.263041, 0.433690, 0.412029>, <0.478257, 0.238530, 0.412029>, <0.478257, 0.000000, 0.412029>,
      <0.000000, 0.433690, 0.549371>, <0.263041, 0.433690, 0.549371>, <0.478257, 0.238530, 0.549371>, <0.478257, 0.000000, 0.549371>,
      <0.000000, 0.433690, 0.686714>, <0.263041, 0.433690, 0.686714>, <0.478257, 0.238530, 0.686714>, <0.478257, 0.000000, 0.686714>,
      <0.000000, 0.459344, 0.824057>, <0.275567, 0.459344, 0.824057>, <0.501031, 0.252639, 0.824057>, <0.535951, 0.000000, 0.824057>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <0.535951, 0.000000, 0.824057>, <0.501031, -0.252639, 0.824057>, <0.275567, -0.459344, 0.824057>, <0.000000, -0.459344, 0.824057>,
      <0.523805, 0.000000, 0.961400>, <0.523805, -0.266749, 0.961400>, <0.288093, -0.484998, 0.961400>, <0.000000, -0.484998, 0.961400>,
      <0.911817, -0.251828, 1.098743>, <1.369308, -0.776999, 1.098743>, <0.249880, -0.496986, 1.098743>, <-0.251620, -0.954855, 1.098743>,
      <0.911817, -0.251828, 1.236086>, <1.369308, -0.776999, 1.236086>, <0.249880, -0.496986, 1.236086>, <-0.251620, -0.954855, 1.236086>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <0.000000, -0.459344, 0.824057>, <-0.275567, -0.459344, 0.824057>, <-0.501031, -0.252639, 0.824057>, <-0.535951, 0.000000, 0.824057>,
      <0.000000, -0.484998, 0.961400>, <-0.288093, -0.484998, 0.961400>, <-0.523805, -0.266749, 0.961400>, <-0.523805, 0.000000, 0.961400>,
      <-0.251620, -0.954855, 1.098743>, <-0.753120, -1.412725, 1.098743>, <-0.454326, -0.273342, 1.098743>, <-0.911817, 0.251828, 1.098743>,
      <-0.251620, -0.954855, 1.236086>, <-0.753120, -1.412725, 1.236086>, <-0.454326, -0.273342, 1.236086>, <-0.911817, 0.251828, 1.236086>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <-0.535951, 0.000000, 0.824057>, <-0.501031, 0.252639, 0.824057>, <-0.275567, 0.459344, 0.824057>, <0.000000, 0.459344, 0.824057>,
      <-0.523805, 0.000000, 0.961400>, <-0.523805, 0.266749, 0.961400>, <-0.288093, 0.484998, 0.961400>, <0.000000, 0.484998, 0.961400>,
      <-0.911817, 0.251828, 1.098743>, <-1.369308, 0.776999, 1.098743>, <-0.249880, 0.496986, 1.098743>, <0.251620, 0.954855, 1.098743>,
      <-0.911817, 0.251828, 1.236086>, <-1.369308, 0.776999, 1.236086>, <-0.249880, 0.496986, 1.236086>, <0.251620, 0.954855, 1.236086>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <0.000000, 0.459344, 0.824057>, <0.275567, 0.459344, 0.824057>, <0.501031, 0.252639, 0.824057>, <0.535951, 0.000000, 0.824057>,
      <0.000000, 0.484998, 0.961400>, <0.288093, 0.484998, 0.961400>, <0.523805, 0.266749, 0.961400>, <0.523805, 0.000000, 0.961400>,
      <0.251620, 0.954855, 1.098743>, <0.753120, 1.412725, 1.098743>, <0.454326, 0.273342, 1.098743>, <0.911817, -0.251828, 1.098743>,
      <0.251620, 0.954855, 1.236086>, <0.753120, 1.412725, 1.236086>, <0.454326, 0.273342, 1.236086>, <0.911817, -0.251828, 1.236086>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <0.911817, -0.251828, 1.236086>, <1.369308, -0.776999, 1.236086>, <0.249880, -0.496986, 1.236086>, <-0.251620, -0.954855, 1.236086>,
      <0.911817, -0.251828, 1.373428>, <1.369308, -0.776999, 1.373428>, <0.249880, -0.496986, 1.373428>, <-0.251620, -0.954855, 1.373428>,
      <0.911817, -0.251828, 1.676667>, <1.369308, -0.776999, 1.676667>, <0.249880, -0.496986, 1.676667>, <-0.251620, -0.954855, 1.676667>,
      <0.011565, 0.000000, 1.648114>, <0.011565, -0.006667, 1.648114>, <0.006361, -0.012122, 1.648114>, <0.000000, -0.012122, 1.648114>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <-0.251620, -0.954855, 1.236086>, <-0.753120, -1.412725, 1.236086>, <-0.454326, -0.273342, 1.236086>, <-0.911817, 0.251828, 1.236086>,
      <-0.251620, -0.954855, 1.373428>, <-0.753120, -1.412725, 1.373428>, <-0.454326, -0.273342, 1.373428>, <-0.911817, 0.251828, 1.373428>,
      <-0.251620, -0.954855, 1.676667>, <-0.753120, -1.412725, 1.676667>, <-0.454326, -0.273342, 1.676667>, <-0.911817, 0.251828, 1.676667>,
      <0.000000, -0.012122, 1.648114>, <-0.006361, -0.012122, 1.648114>, <-0.011565, -0.006667, 1.648114>, <-0.011565, 0.000000, 1.648114>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <-0.911817, 0.251828, 1.236086>, <-1.369308, 0.776999, 1.236086>, <-0.249880, 0.496986, 1.236086>, <0.251620, 0.954855, 1.236086>,
      <-0.911817, 0.251828, 1.373428>, <-1.369308, 0.776999, 1.373428>, <-0.249880, 0.496986, 1.373428>, <0.251620, 0.954855, 1.373428>,
      <-0.911817, 0.251828, 1.676667>, <-1.369308, 0.776999, 1.676667>, <-0.249880, 0.496986, 1.676667>, <0.251620, 0.954855, 1.676667>,
      <-0.011565, 0.000000, 1.648114>, <-0.011565, 0.006667, 1.648114>, <-0.006361, 0.012122, 1.648114>, <0.000000, 0.012122, 1.648114>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0000 u_steps 4 v_steps 4,
      <0.251620, 0.954855, 1.236086>, <0.753120, 1.412725, 1.236086>, <0.454326, 0.273342, 1.236086>, <0.911817, -0.251828, 1.236086>,
      <0.251620, 0.954855, 1.373428>, <0.753120, 1.412725, 1.373428>, <0.454326, 0.273342, 1.373428>, <0.911817, -0.251828, 1.373428>,
      <0.251620, 0.954855, 1.676667>, <0.753120, 1.412725, 1.676667>, <0.454326, 0.273342, 1.676667>, <0.911817, -0.251828, 1.676667>,
      <0.000000, 0.012122, 1.648114>, <0.006361, 0.012122, 1.648114>, <0.011565, 0.006667, 1.648114>, <0.011565, 0.000000, 1.648114>
    }
  }
  texture {
    Chrome_Textur1
  }
  rotate -45.0*z
  translate  <0.0, 6.0, 0.15>
}
union { // CSG001
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    texture {
      noir
    }
    scale <0.3, 0.3, 1.0>
    translate  <0.0, 6.0, -0.2>
  }
  object { BzPtch2 }
  rotate 15.0*y
}                               //droite ?





union { // BzPtch002
  object {
    bicubic_patch { type mem flatness 0.0100 u_steps 3 v_steps 3,
      <-0.483871, 0.000000, 0.000000>, <-0.483871, -0.460619, 0.000000>, <-0.266129, -0.837488, 0.000000>, <0.000000, -0.837488, 0.000000>,
      <-0.483871, 0.000000, 0.500000>, <-0.483871, -0.460619, 0.500000>, <-0.266129, -0.837488, 0.500000>, <0.000000, -0.837488, 0.500000>,
      <-0.483871, 0.000000, 1.000000>, <-0.483871, -0.460619, 1.000000>, <-0.266129, -0.837488, 1.000000>, <0.000000, -0.837488, 1.000000>,
      <-0.468428, 0.000000, 1.587132>, <-0.468428, -0.460619, 1.587132>, <-0.251104, -0.837488, 1.577605>, <0.014515, -0.837488, 1.565960>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.837488, 0.000000>, <0.266129, -0.837488, 0.000000>, <0.483871, -0.460619, 0.000000>, <0.483871, 0.000000, 0.000000>,
      <0.000000, -0.837488, 0.500000>, <0.266129, -0.837488, 0.500000>, <0.483871, -0.460619, 0.500000>, <0.483871, 0.000000, 0.500000>,
      <0.000000, -0.837488, 1.000000>, <0.266129, -0.837488, 1.000000>, <0.483871, -0.460619, 1.000000>, <0.483871, 0.000000, 1.000000>,
      <0.014515, -0.837488, 1.565960>, <0.280134, -0.837488, 1.554316>, <0.497458, -0.460619, 1.544789>, <0.497458, 0.000000, 1.544789>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0100 u_steps 3 v_steps 3,
      <0.483871, 0.000000, 0.000000>, <0.483871, 0.460619, 0.000000>, <0.266129, 0.837488, 0.000000>, <0.000000, 0.837488, 0.000000>,
      <0.483871, 0.000000, 0.500000>, <0.483871, 0.460619, 0.500000>, <0.266129, 0.837488, 0.500000>, <0.000000, 0.837488, 0.500000>,
      <0.483871, 0.000000, 1.000000>, <0.483871, 0.460619, 1.000000>, <0.266129, 0.837488, 1.000000>, <0.000000, 0.837488, 1.000000>,
      <0.497458, 0.000000, 1.544789>, <0.497458, 0.460619, 1.544789>, <0.280134, 0.837488, 1.554316>, <0.014515, 0.837488, 1.565960>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.837488, 0.000000>, <-0.266129, 0.837488, 0.000000>, <-0.483871, 0.460619, 0.000000>, <-0.483871, 0.000000, 0.000000>,
      <0.000000, 0.837488, 0.500000>, <-0.266129, 0.837488, 0.500000>, <-0.483871, 0.460619, 0.500000>, <-0.483871, 0.000000, 0.500000>,
      <0.000000, 0.837488, 1.000000>, <-0.266129, 0.837488, 1.000000>, <-0.483871, 0.460619, 1.000000>, <-0.483871, 0.000000, 1.000000>,
      <0.014515, 0.837488, 1.565960>, <-0.251104, 0.837488, 1.577605>, <-0.468428, 0.460619, 1.587132>, <-0.468428, 0.000000, 1.587132>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0100 u_steps 3 v_steps 3,
      <-0.468428, 0.000000, 1.587132>, <-0.468428, -0.460619, 1.587132>, <-0.251104, -0.837488, 1.577605>, <0.014515, -0.837488, 1.565960>,
      <-0.452985, 0.000000, 2.174264>, <-0.452985, -0.460619, 2.174264>, <-0.236078, -0.837488, 2.155209>, <0.029030, -0.837488, 2.131921>,
      <-0.318493, 0.000000, 2.916602>, <-0.318493, -0.460619, 2.916602>, <-0.106237, -0.837488, 2.868034>, <0.153187, -0.837488, 2.808674>,
      <0.011499, 0.000000, 4.162595>, <0.011499, -0.460619, 4.162595>, <0.214937, -0.837488, 4.089489>, <0.463584, -0.837488, 4.000138>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0100 u_steps 3 v_steps 3,
      <0.014515, -0.837488, 1.565960>, <0.280134, -0.837488, 1.554316>, <0.497458, -0.460619, 1.544789>, <0.497458, 0.000000, 1.544789>,
      <0.029030, -0.837488, 2.131921>, <0.294138, -0.837488, 2.108632>, <0.511045, -0.460619, 2.089578>, <0.511045, 0.000000, 2.089578>,
      <0.153187, -0.837488, 2.808674>, <0.412612, -0.837488, 2.749314>, <0.624868, -0.460619, 2.700746>, <0.624868, 0.000000, 2.700746>,
      <0.463584, -0.837488, 4.000138>, <0.712231, -0.837488, 3.910786>, <0.915670, -0.460619, 3.837680>, <0.915670, 0.000000, 3.837680>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0100 u_steps 3 v_steps 3,
      <0.497458, 0.000000, 1.544789>, <0.497458, 0.460619, 1.544789>, <0.280134, 0.837488, 1.554316>, <0.014515, 0.837488, 1.565960>,
      <0.511045, 0.000000, 2.089578>, <0.511045, 0.460619, 2.089578>, <0.294138, 0.837488, 2.108632>, <0.029030, 0.837488, 2.131921>,
      <0.624868, 0.000000, 2.700746>, <0.624868, 0.460619, 2.700746>, <0.412612, 0.837488, 2.749314>, <0.153187, 0.837488, 2.808674>,
      <0.915670, 0.000000, 3.837680>, <0.915670, 0.460619, 3.837680>, <0.712231, 0.837488, 3.910786>, <0.463584, 0.837488, 4.000138>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0100 u_steps 3 v_steps 3,
      <0.014515, 0.837488, 1.565960>, <-0.251104, 0.837488, 1.577605>, <-0.468428, 0.460619, 1.587132>, <-0.468428, 0.000000, 1.587132>,
      <0.029030, 0.837488, 2.131921>, <-0.236078, 0.837488, 2.155209>, <-0.452985, 0.460619, 2.174264>, <-0.452985, 0.000000, 2.174264>,
      <0.153187, 0.837488, 2.808674>, <-0.106237, 0.837488, 2.868034>, <-0.318493, 0.460619, 2.916602>, <-0.318493, 0.000000, 2.916602>,
      <0.463584, 0.837488, 4.000138>, <0.214937, 0.837488, 4.089489>, <0.011499, 0.460619, 4.162595>, <0.011499, 0.000000, 4.162595>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0100 u_steps 3 v_steps 3,
      <0.011499, 0.000000, 4.162595>, <0.011499, -0.460619, 4.162595>, <0.214937, -0.837488, 4.089489>, <0.463584, -0.837488, 4.000138>,
      <0.341491, 0.000000, 5.408589>, <0.341491, -0.460619, 5.408589>, <0.536111, -0.837488, 5.310945>, <0.773981, -0.837488, 5.191602>,
      <0.565711, 0.000000, 5.855495>, <0.565711, -0.460619, 5.855495>, <0.760331, -0.837488, 5.757851>, <0.998201, -0.837488, 5.638508>,
      <1.042948, 0.000000, 6.478293>, <1.042948, -0.460619, 6.478293>, <1.202209, -0.837488, 6.339945>, <1.396862, -0.837488, 6.170852>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0100 u_steps 3 v_steps 3,
      <0.463584, -0.837488, 4.000138>, <0.712231, -0.837488, 3.910786>, <0.915670, -0.460619, 3.837680>, <0.915670, 0.000000, 3.837680>,
      <0.773981, -0.837488, 5.191602>, <1.011850, -0.837488, 5.072259>, <1.206471, -0.460619, 4.974615>, <1.206471, 0.000000, 4.974615>,
      <0.998201, -0.837488, 5.638508>, <1.236070, -0.837488, 5.519165>, <1.430691, -0.460619, 5.421521>, <1.430691, 0.000000, 5.421521>,
      <1.396862, -0.837488, 6.170852>, <1.591514, -0.837488, 6.001759>, <1.750775, -0.460619, 5.863411>, <1.750775, 0.000000, 5.863411>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0100 u_steps 3 v_steps 3,
      <0.915670, 0.000000, 3.837680>, <0.915670, 0.460619, 3.837680>, <0.712231, 0.837488, 3.910786>, <0.463584, 0.837488, 4.000138>,
      <1.206471, 0.000000, 4.974615>, <1.206471, 0.460619, 4.974615>, <1.011850, 0.837488, 5.072259>, <0.773981, 0.837488, 5.191602>,
      <1.430691, 0.000000, 5.421521>, <1.430691, 0.460619, 5.421521>, <1.236070, 0.837488, 5.519165>, <0.998201, 0.837488, 5.638508>,
      <1.750775, 0.000000, 5.863411>, <1.750775, 0.460619, 5.863411>, <1.591514, 0.837488, 6.001759>, <1.396862, 0.837488, 6.170852>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0100 u_steps 3 v_steps 3,
      <0.463584, 0.837488, 4.000138>, <0.214937, 0.837488, 4.089489>, <0.011499, 0.460619, 4.162595>, <0.011499, 0.000000, 4.162595>,
      <0.773981, 0.837488, 5.191602>, <0.536111, 0.837488, 5.310945>, <0.341491, 0.460619, 5.408589>, <0.341491, 0.000000, 5.408589>,
      <0.998201, 0.837488, 5.638508>, <0.760331, 0.837488, 5.757851>, <0.565711, 0.460619, 5.855495>, <0.565711, 0.000000, 5.855495>,
      <1.396862, 0.837488, 6.170852>, <1.202209, 0.837488, 6.339945>, <1.042948, 0.460619, 6.478293>, <1.042948, 0.000000, 6.478293>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0100 u_steps 3 v_steps 3,
      <1.042948, 0.000000, 6.478293>, <1.042948, -0.460619, 6.478293>, <1.202209, -0.837488, 6.339945>, <1.396862, -0.837488, 6.170852>,
      <1.520186, 0.000000, 7.101092>, <1.520186, -0.460619, 7.101092>, <1.644087, -0.837488, 6.922038>, <1.795522, -0.837488, 6.703196>,
      <1.931345, 0.000000, 7.385606>, <1.931345, -0.460619, 7.385606>, <2.055246, -0.837488, 7.206553>, <2.206681, -0.837488, 6.987710>,
      <2.379890, 0.000000, 7.556429>, <2.379890, -0.460619, 7.556429>, <2.458053, -0.837488, 7.359245>, <2.553586, -0.837488, 7.118243>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0100 u_steps 3 v_steps 3,
      <1.396862, -0.837488, 6.170852>, <1.591514, -0.837488, 6.001759>, <1.750775, -0.460619, 5.863411>, <1.750775, 0.000000, 5.863411>,
      <1.795522, -0.837488, 6.703196>, <1.946957, -0.837488, 6.484353>, <2.070859, -0.460619, 6.305300>, <2.070859, 0.000000, 6.305300>,
      <2.206681, -0.837488, 6.987710>, <2.358116, -0.837488, 6.768868>, <2.363446, -0.460619, 6.649655>, <2.363446, 0.000000, 6.649655>,
      <2.553586, -0.837488, 7.118243>, <2.649118, -0.837488, 6.877241>, <2.667996, -0.460619, 6.709977>, <2.667996, 0.000000, 6.709977>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0100 u_steps 3 v_steps 3,
      <1.750775, 0.000000, 5.863411>, <1.750775, 0.460619, 5.863411>, <1.591514, 0.837488, 6.001759>, <1.396862, 0.837488, 6.170852>,
      <2.070859, 0.000000, 6.305300>, <2.070859, 0.460619, 6.305300>, <1.946957, 0.837488, 6.484353>, <1.795522, 0.837488, 6.703196>,
      <2.363446, 0.000000, 6.649655>, <2.363446, 0.460619, 6.649655>, <2.358116, 0.837488, 6.768868>, <2.206681, 0.837488, 6.987710>,
      <2.667996, 0.000000, 6.709977>, <2.667996, 0.460619, 6.709977>, <2.649118, 0.837488, 6.877241>, <2.553586, 0.837488, 7.118243>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0100 u_steps 3 v_steps 3,
      <1.396862, 0.837488, 6.170852>, <1.202209, 0.837488, 6.339945>, <1.042948, 0.460619, 6.478293>, <1.042948, 0.000000, 6.478293>,
      <1.795522, 0.837488, 6.703196>, <1.644087, 0.837488, 6.922038>, <1.520186, 0.460619, 7.101092>, <1.520186, 0.000000, 7.101092>,
      <2.206681, 0.837488, 6.987710>, <2.055246, 0.837488, 7.206553>, <1.931345, 0.460619, 7.385606>, <1.931345, 0.000000, 7.385606>,
      <2.553586, 0.837488, 7.118243>, <2.458053, 0.837488, 7.359245>, <2.379890, 0.460619, 7.556429>, <2.379890, 0.000000, 7.556429>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0100 u_steps 3 v_steps 3,
      <2.379890, 0.000000, 7.556429>, <2.379890, -0.460619, 7.556429>, <2.458053, -0.837488, 7.359245>, <2.553586, -0.837488, 7.118243>,
      <2.828435, 0.000000, 7.727251>, <2.828435, -0.460619, 7.727251>, <2.860860, -0.837488, 7.511937>, <2.900490, -0.837488, 7.248775>,
      <3.752190, 0.000000, 7.488380>, <3.752190, -0.460619, 7.488380>, <3.612914, -0.837488, 7.321007>, <3.442688, -0.837488, 7.116440>,
      <4.282356, 0.000000, 6.755042>, <4.282356, -0.341780, 6.755042>, <4.081979, -0.621418, 6.681941>, <3.892967, -0.621418, 6.624774>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0100 u_steps 3 v_steps 3,
      <2.553586, -0.837488, 7.118243>, <2.649118, -0.837488, 6.877241>, <2.667996, -0.460619, 6.709977>, <2.667996, 0.000000, 6.709977>,
      <2.900490, -0.837488, 7.248775>, <2.940121, -0.837488, 6.985614>, <2.972545, -0.460619, 6.770300>, <2.972545, 0.000000, 6.770300>,
      <3.442688, -0.837488, 7.116440>, <3.272461, -0.837488, 6.911872>, <3.133185, -0.460619, 6.744499>, <3.133185, 0.000000, 6.744499>,
      <3.892967, -0.621418, 6.624774>, <3.703955, -0.621418, 6.567606>, <3.549309, -0.341780, 6.520833>, <3.549309, 0.000000, 6.520833>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0100 u_steps 3 v_steps 3,
      <2.667996, 0.000000, 6.709977>, <2.667996, 0.460619, 6.709977>, <2.649118, 0.837488, 6.877241>, <2.553586, 0.837488, 7.118243>,
      <2.972545, 0.000000, 6.770300>, <2.972545, 0.460619, 6.770300>, <2.940121, 0.837488, 6.985614>, <2.900490, 0.837488, 7.248775>,
      <3.133185, 0.000000, 6.744499>, <3.133185, 0.460619, 6.744499>, <3.272461, 0.837488, 6.911872>, <3.442688, 0.837488, 7.116440>,
      <3.549309, 0.000000, 6.520833>, <3.549309, 0.341780, 6.520833>, <3.703955, 0.621418, 6.567606>, <3.892967, 0.621418, 6.624774>
    }
  }
  object {
    bicubic_patch { type mem flatness 0.0100 u_steps 3 v_steps 3,
      <2.553586, 0.837488, 7.118243>, <2.458053, 0.837488, 7.359245>, <2.379890, 0.460619, 7.556429>, <2.379890, 0.000000, 7.556429>,
      <2.900490, 0.837488, 7.248775>, <2.860860, 0.837488, 7.511937>, <2.828435, 0.460619, 7.727251>, <2.828435, 0.000000, 7.727251>,
      <3.442688, 0.837488, 7.116440>, <3.612914, 0.837488, 7.321007>, <3.752190, 0.460619, 7.488380>, <3.752190, 0.000000, 7.488380>,
      <3.892967, 0.621418, 6.624774>, <4.081979, 0.621418, 6.681941>, <4.282356, 0.341780, 6.755042>, <4.282356, 0.000000, 6.755042>
    }
  }
  texture {
    Chrome_Textur1
  }
  translate  3.0*y
}

}

//          fin des tuyaux








/*

lathe {
  cubic_spline
  10  // control points
  <1.0, -1.0>,
  <2.817555, -0.851683>,
  <3.126373, 0.533884>,
  <3.142194, 1.057707>,
  <2.986283, 1.00417>,
  <2.703504, 0.97932>,
  <2.580938, 0.824644>,
  <2.270058, -0.203866>,
  <0.150732, -0.411752>,
  <0.041292, -0.4068>
  rotate <90,0,90>
  texture {
    White_Marble1
  }
  scale <1.74484, 2.936583, 1.0>
  translate  <6.0, 2.702064, -1.0>
}



plane { // Plane001
    z,0
clipped_by {  cylinder { <0,0,1>, <0,0,0>, 1 inverse
    scale <5.049, 9.1016, 1.0>
    translate  <6.0, 2.702064, -0.5> }}
  texture {
    White_Marble1

}
}



*/
