/*camera {
        location <4,4,-4>
        look_at  <0,0,0> }

light_source { <100,100,-100> color rgb 1 }


plane { y,0
pigment { color rgb <1,0,0> }
}

*/

// A blob that is scaled quite thin, translated just slightly higher than
// y=0 to give a slight undercut to model surface tension.
// Note that both the "surface tension" and the glass texture are really
// wrong to model water... looks more like glue or varnish.

// For quick testing, use this
#declare Glass = texture { pigment { color rgbf <0.95,0.95,0.95,0.98>
quick_color rgb <0,0,1> }

finish { phong 0.3 phong_size 150 refraction on ior 1.33 reflection 0.05 }
 }

#declare Puddle = blob  {
  threshold 0.6
  component  1, 0.957195, <-0.00843882, -0.00843882, 0>
  component  1, 1.04069, <0.261603, -0.0253165, -0.49789>
  component  1, 1.07592, <0.801688, -0.0759494, 0>
  component  1, 0.935157, <0.953587, -0.00843882, 0.767932>
  component  1, 0.983246, <-1.08861, -0.0253165, -0.548523>
  component  1, 0.879442, <-0.481013, -0.0253165, -0.565401>
  component  1, 1.01798, <1.19831, -0.118143, 0>
  component  1, 1.03521, <1.60338, -0.219409, 0>
  component  1, 0.948575, <2.17722, -0.151899, 0.253165>
  component  1, 0.476944, <1.67089, -0.253165, 0.658228>
  component  1, 1.55282, <-1.77215, -0.0168776, 0>
  component  1, 1.28175, <-1.36709, -0.0843882, 0.759494>
  component  1, 1.6213, <-0.253165, 0.0506329, 0.962025>
  component  1, 1.36761, <-2.00844, -0.0506329, -0.759494>
  component  1, 1.24372, <-1.70464, 0, -1.1308>
  component  1, 1.1106, <-1.53586, 0, -1.80591>
  component  1, 0.700241, <-1.1308, 0, -1.26582>
  component  1, 1.01798, <0.489451, 0, 1.4346>
  component  1, 0.670744, <0.894515, 0, 1.70464>
  component  1, 0.611614, <1.09705, 0, 1.90717>
  component  1, 0.794907, <0.759494, 0, -2.00844>
  component  1, 1.04976, <2.31224, 0, -1.40084>
  component  1, 0.832189, <2.48101, 0, -0.92827>
  component  1, 0.355493, <2.91983, 0, -0.92827>
  component  1, 0.0710987, <1.77215, 0, -1.36709>
  component  1, 0.953888, <-2.78481, 0, -0.219409>
  component  1, 0.700241, <-3.39241, 0, 0.0168776>
  component  1, 0.655497, <-3.18987, 0, -0.0506329>
  component  1, 0.603292, <0.894515, 0, 1.33333>
  component  1, 0.455254, <-0.0506329, 0, 1.67089>
  component  1, 0.25635, <-2.04219, 0, 0.759494>
  component  1, 0.573216, <-2.34599, 0, 2.95359>
  component  1, 0.213296, <-1.50211, 0, 2.7173>
  component  1, 0.355493, <-2.64979, 0, 2.48101>
  component  1, 0.402195, <2.1097, 0, 2.58228>
  component  1, 0.502744, <-3.25738, 0, -1.70464>
  component  1, 0.502744, <-3.18987, 0, -1.87342>

  texture { Glass }
  scale <1, 0.2, 1>
  translate y*0.055
}



