/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* * This scene is designed for 16:9 aspect ratio.                                                                   * */
/* *                                                                                                                 * */
/* * The purpose of this file is to demonstrate the entire character set available.                                  * */
/* *                                                                                                                 * */
/* * Set the value of [UseRadiosity] to "false" for a quick render, or "true" for a high-quality render.             * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#version 3.7;

#local UseRadiosity = yes;

global_settings {
   assumed_gamma 2.2
   charset utf8
   max_trace_level 20
   #if (UseRadiosity)
      radiosity {
         pretrace_start .08
         pretrace_end .004
         count 600
         error_bound .002
         recursion_limit 2
         normal on
      } //radiosity
   #end //#if
} //global_settings

#include "colors.inc"
#include "BorderChars.inc"

#local CameraZ = 9.5;

camera {
   location <0, 0, -CameraZ>
   direction <0, 0, 1>
   right (16/9) * x
   look_at <0, 0, 0>
} //camera

#if (UseRadiosity)
   #local Dome = object {
      difference {
         sphere {0, 20001}
         sphere {0, 20000}
      } //difference
      texture {
         pigment {
            gradient z
            color_map {
               [0, 1 color White * 2.21 color White * .6]
            } //color_map
         } //pigment
         finish {emission 1 diffuse 0}
         scale <1, 1, 20000>
      } //texture
      no_reflection
   } //object
   object {Dome}
#else
   light_source {<60, 80, -200> color White * 1.65 shadowless}
#end //#if

#local TextColor_Outer = texture {pigment {color White}}

#local TextColor_Inner = texture {
   #local Color0 = color <0.0000, 0.8894, 0.7535>;
   #local Color1 = color <0.6341, 0.0124, 0.8235>;
   pigment {
      gradient y
      color_map {
         [0 color Color0]
         [.4 color (Color0 * 75 + Color1 * 25) / 100]
         [.6 (Color0 + Color1) / 2]
         [1 color Color1]
      } //color_map
   } //pigment
   finish {emission .1}
   #local YScaleAdd_Bottom = .75 / 2 * .95; //Height of the bottom of the "g"
   #local YScaleAdd_Top = .075; //Height of the top of the "*"
   scale <1, 1 + YScaleAdd_Bottom + YScaleAdd_Top, 1>
   translate -YScaleAdd_Bottom * y
} //texture

#local TextColor_Back = texture {pigment {color Black}}

#local BackgroundColor = texture {pigment {color <0.8834, 0.8494, 0.7747>}}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* *                                                                                                                 * */
/* * THE SCENE                                                                                                       * */
/* *                                                                                                                 * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#local FontVariationNumber = 2;
#local TextDepth = .08;
#local InvisibleBorderWidth = 0;
#local BorderWidth = .03;
#local BorderDepth = .05;

SetFontStyle (0, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, BorderDepth, 999, 999, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)

#declare GAP_Width = .06;   //Distance between characters
#declare SPACE_Width = .25; //Distance between words
#declare LineSpacing = .5;  //Distance between lines

#declare LineAlignment = LEFT; //Choices are LEFT, RIGHT, CENTERED, or JUSTIFIED
#declare MaxMicroJustificationScale = 1; //Set to 1 for no scaling, > 1 for limited scaling, or UNLIMITED
#declare MaxAdditionalGAP_WidthPercentage = UNLIMITED; //Set to 0 to maintain constant gap width, any percentage, or UNLIMITED
#declare SPACE_ExpansionRate = 1.5; //Values > 1 will cause SPACE_Width to increase faster than GAP_Width
#declare JustifyLastLinePercentage = 95; //Minimum percentage of paragraph width to justify last line
#declare MinJustifiedParagraphWidth = 0; //Minimum width of paragraph when justified

#local TextScale = 1;
#local UseActualParagraphHeight = no;

#local NLines = 6;

InitializeVariables (NLines)

//Use   \"   for QUOTE MARKS.
//Use   &    for a HEART.
//Use   ^    for a STAR.
//Use   @    for a BULLET.

#declare LineText [0] = "~0~.,:;-'\"!?/()[]<>+=%#*$_&^@";
#declare LineText [1] = "0123456789";
#declare LineText [2] = "ABCDEFGHIJKLMN";
#declare LineText [3] = "OPQRSTUVWXYZ";
#declare LineText [4] = "abcdefghijklmnopq";
#declare LineText [5] = "rstuvwxyz";

CreateParagraph (NLines, TextScale, UseActualParagraphHeight)

#local LeftMargin = -CameraZ / 1.125 + .6;
#local TopMargin = ParagraphHeight / 2;
#local ZOffset = -.1;

object {Paragraph translate <LeftMargin, TopMargin, ZOffset>}

#local Background = object {
   plane {
      z, 0 inverse
      texture {BackgroundColor}
   } //plane
} //object

object {Background}
