/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* * This scene is designed for 16:9 aspect ratio.                                                                   * */
/* *                                                                                                                 * */
/* * The purpose of this file is to provide a template that you can copy and paste into your own scenes.             * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

//-f

#version 3.7;

global_settings {assumed_gamma 2.2}

#include "colors.inc"
#include "BorderChars.inc"

camera {
   orthographic
   location <0, 0, -5.3>
   direction <0, 0, 1>
   scale <16/9, 4/3, 1>
   look_at <0, 0, 0>
} //camera

#local TextColor_Outer = texture {pigment {color White} finish {emission 1}}

#local TextColor_Inner = texture {pigment {color <.6196, .6941, .0706>} finish {emission 1}}

#local TextColor_Back = texture {TextColor_Outer}

#local FontVariationNumber = 26;
#local TextDepth = .08;
#local InvisibleBorderWidth = 0;
#local BorderWidth = .03;
#local BorderDepth = .01;
#local DarkBorderWidth = .05;
#local NSteps = 15;

SetFontStyle (0, FontVariationNumber, TextDepth, InvisibleBorderWidth, BorderWidth, BorderDepth, DarkBorderWidth, NSteps, 999, 999, 999, TextColor_Outer, TextColor_Inner, TextColor_Back)

#declare GAP_Width = .05;   //Distance between characters
#declare SPACE_Width = .26; //Distance between words
#declare LineSpacing = .5;  //Distance between lines

#declare LineAlignment = LEFT; //Choices are LEFT, RIGHT, CENTERED, or JUSTIFIED
#declare MaxMicroJustificationScale = 1; //Set to 1 for no scaling, > 1 for limited scaling, or UNLIMITED
#declare MaxAdditionalGAP_WidthPercentage = UNLIMITED; //Set to 0 to maintain constant gap width, any percentage, or UNLIMITED
#declare SPACE_ExpansionRate = 1.5; //Values > 1 will cause SPACE_Width to increase faster than GAP_Width
#declare JustifyLastLinePercentage = 95; //Minimum percentage of paragraph width to justify last line
#declare MinJustifiedParagraphWidth = 0; //Minimum width of paragraph when justified

#local TextScale = 1;
#local UseActualParagraphHeight = no;

#local NLines = 1;

InitializeVariables (NLines)

//Use   \"   for QUOTE MARKS.
//Use   &    for a HEART.
//Use   ^    for a STAR.
//Use   @    for a BULLET.

#declare LineText [0] = "~0~Greetings, Earthling!";

CreateParagraph (NLines, TextScale, UseActualParagraphHeight)

object {Paragraph translate <-ParagraphWidth / 2, ParagraphHeight / 2, 0>}
