/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* * [BORDERED CHARACTERS VERSION 1.8]                                                                               * */
/* *                                                                                                                 * */
/* * INTRODUCTION:                                                                                                   * */
/* *                                                                                                                 * */
/* * Hello Friend! Out of all the billions of people on Earth, you are one of only a miniscule fraction who is       * */
/* * interested in using my files. I worked very hard on this project and I hope you find it useful. I would be very * */
/* * happy to hear from you if you would take a moment to write and say Hi! My e-mail address is                     * */
/* * davswa1967@yahoo.com. I look forward to hearing from you, since you will probably be the only person on this    * */
/* * whole planet to write! Feel free to mention any comments or suggestions.                                        * */
/* *                                                                                                                 * */
/* * GENERAL OVERVIEW:                                                                                               * */
/* *                                                                                                                 * */
/* * The purpose of these files is to provide a set of bordered character objects and macros to manage them. The     * */
/* * characters are based on the Arial font. The biggest practical difference between these character objects and a  * */
/* * standard text object is the bordering capability. As you can see from the "Demo_FontVariations.pov" file, this  * */
/* * capability allows one to create unlimited and interesting three-dimensional font variations.                    * */
/* *                                                                                                                 * */
/* * The best way to learn to use these files is to read the instructions and examine the "Demo_*.pov" files. I've   * */
/* * tried to provide as much flexibility as my little brain could possibly think of while keeping the features as   * */
/* * easy to use as possible.                                                                                        * */
/* *                                                                                                                 * */
/* * Here's a basic explanation of what the macros do: The heart of this utility is the character object             * */
/* * definitions. The objects are created in such a manner that a border width can be specified, and the stroke      * */
/* * width of the characters will be reduced by that amount. Therefore, multiple copies of the character objects     * */
/* * with different stroke widths and textures can be combined using various CSG operations.                         * */
/* *                                                                                                                 * */
/* * Macros are included to help manage the character objects as lines of text. The end product of the macros is an  * */
/* * object called "Paragraph" which is a union of characters styled, textured, formatted, spaced, aligned, and      * */
/* * scaled according to your specifications.                                                                        * */
/* *                                                                                                                 * */
/* * The macros provide automatic kerning, two types of micro-justification, and the ability to embed formatting     * */
/* * codes within the text.                                                                                          * */
/* *                                                                                                                 * */
/* * INSTRUCTIONS FOR USE:                                                                                           * */
/* *                                                                                                                 * */
/* * 1: Include this file ("BorderChars.inc") in your scene file.                                                    * */
/* * 2: Define one or more "Font Styles" using the SetFontStyle () macro.                                            * */
/* * 3: Set the various formatting variables according to your desired results using #declare statements.            * */
/* * 4: Call the InitializeVariables () macro specifying the number of lines of text in your message.                * */
/* * 5: Assign string values to the specified number of LineText [] array elements using #declare statements. Note   * */
/* *    that there are four characters that require special attention: The DOUBLE-QUOTE mark is represented by a     * */
/* *    BACKSLASH followed immediately by a DOUBLE-QUOTE (\"). A HEART shape is represented by the AMPERSAND symbol  * */
/* *    (&). A STAR shape is represented by the CARET symbol (^). A BULLET is represented by the AT symbol (@).      * */
/* *    Also, text can be italicized by enclosing it between curly brackets ("{" and "}").                           * */
/* * 6: Call the CreateParagraph () macro.                                                                           * */
/* * 7: The "Paragraph" object is now ready to use in your scene!                                                    * */
/* *                                                                                                                 * */
/* * For more specific information and instructions refer to these files:                                            * */
/* *                                                                                                                 * */
/* *    "BorderChars_Definitions.inc"                                                                                * */
/* *    "BorderChars_Macros.inc"                                                                                     * */
/* *    "BorderChars_FontVariations.inc"                                                                             * */
/* *                                                                                                                 * */
/* * KNOWN ISSUES:                                                                                                   * */
/* *                                                                                                                 * */
/* * Changing stroke widths within a paragraph by varying the [InvisibleBorderWidth] setting will result in          * */
/* * incorrect line width computations. This will cause right, center, and micro-justification to fail. Left         * */
/* * justification will still work properly. Fixing this would require re-writing quite a bit of code, which I don't * */
/* * have the time for.                                                                                              * */
/* *                                                                                                                 * */
/* * There are a few four-character combinations in which the two characters in the middle are narrow and short      * */
/* * enough that the right edge of the leftmost character should abut the left edge of the rightmost character       * */
/* * ("P..T" for example). The kerning macro only considers up to three characters at a time, so this condition will * */
/* * cause the macro to fail. I don't anticipate that any character combinations that cause this problem would ever  * */
/* * be used in normal text. I could be wrong, of course, but the cost in time and effort required to correct this   * */
/* * is too great for the limited potential benefit.                                                                 * */
/* *                                                                                                                 * */
/* * Reducing the stroke width by using the [InvisibleBorderWidth] setting reduces the height of the lower-case "t." * */
/* * This is a side-effect of the mathematical method used to reduce the stroke width. This could be corrected by    * */
/* * taking some programming shortcuts but I prefer not to.                                                          * */
/* *                                                                                                                 * */
/* * Note to self: Reducing [StrokeWidth] produces a different effect than using [InvisibleBorderWidth] but breaks   * */
/* * some of the characters ("s" for example). Re-designing or fixing the broken characters would allow this option. * */
/* * This is a low-priority project since [InvisibleBorderWidth] produces more visually appealing results anyway.    * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "BorderChars_Definitions.inc"
#include "BorderChars_Macros.inc"
#include "BorderChars_FontVariations.inc"

#debug "\n\n* * * * * * * * * * * * * * * * * * * * * * * * * * * * *\n"
#debug "*                                                       *\n"
#debug "*            Bordered Characters version 1.8            *\n"
#debug "*                   By Dave Blandston                   *\n"
#debug "*                                                       *\n"
#debug "*   See the file \"BorderChars.inc\" for documentation.   *\n"
#debug "*                                                       *\n"
#debug "* * * * * * * * * * * * * * * * * * * * * * * * * * * * *\n\n"
