#version 3.7;

#local UseRadiosity = yes;

global_settings {
   assumed_gamma 2.2
   charset utf8
   max_trace_level 20
   #if (UseRadiosity)
      radiosity {
         pretrace_start .08
         pretrace_end .004
         count 600
         error_bound .002
         recursion_limit 2
         normal on
      } //radiosity
   #end //#if
} //global_settings

#include "colors.inc"
#include "BorderChars.inc"

#local CameraX = 0;
#local CameraY = 0;
#local CameraZ = 9.5;

camera {
   location <CameraX, CameraY, -CameraZ>
   direction <0, 0, 1>
   look_at <CameraX, CameraY, 0>
} //camera

#if (UseRadiosity)
   #local Dome = object {
      difference {
         sphere {0, 20001}
         sphere {0, 20000}
      } //difference
      texture {
         pigment {
            gradient z
            color_map {
               [0, 1 color White * 2.21 color White * .6]
            } //color_map
         } //pigment
         finish {emission 1 diffuse 0}
         scale <1, 1, 20000>
      } //texture
      no_reflection
   } //object
   object {Dome}
#else
   light_source {<60, 80, -200> color White * 1.65 shadowless}
#end //#if

#declare TextColor_Outer = texture {pigment {color White}}

#declare TextColor_Inner = texture {
   #declare Color0 = color <0, 216, 183> / 255 * 1.05; //Bottom
   #declare Color1 = color <154, 3, 200> / 255 * 1.05; //Top
   pigment {
      gradient y
      color_map {
         [0 color Color0]
         [.4 color (Color0 * 75 + Color1 * 25) / 100]
         [.6 (Color0 + Color1) / 2]
         [1 color Color1]
      } //color_map
   } //pigment
   finish {emission .1}
   #local YScaleAdd_Bottom = .75 / 2 * .95; //Height of the bottom of the "g"
   #local YScaleAdd_Top = .075; //Height of the top of the "*"
   scale <1, 1 + YScaleAdd_Bottom + YScaleAdd_Top, 1>
   translate -YScaleAdd_Bottom * y
} //texture

#declare TextColor_Back = texture {pigment {color Black}}

#local BackgroundColor = texture {pigment {color (<96, 56, 13> / 255 * 1.5 + White * 4) / 5}}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* *                                                                                                                 * */
/* * THE SCENE                                                                                                       * */
/* *                                                                                                                 * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#local LeftMargin = -CameraZ * 2/3 + .4;
#local TopMargin = CameraZ / 2 - 1 - .4;
#local ZOffset = -.1;

#declare TextScale = 1;

#local Style = 2;
#local InvisibleBorderWidth = 0;
#local TextDepth = .08;
#local BorderWidth = .03;
#local BorderDepth = .05;

Stylize (Style, TextDepth, InvisibleBorderWidth, BorderWidth, BorderDepth, -999, -999, -999)

#declare GAP_Width = .06;   //Distance between characters
#declare SPACE_Width = .2;  //Distance between words
#declare LineSpacing = 1.5; //Distance between lines

#declare LineAlignment = LEFT; //Choices are LEFT, RIGHT, CENTERED, or JUSTIFIED
#declare MicroJustificationMethod = UNLIMITED; //Choices are LIMITED or UNLIMITED
#declare SPACE_ExpansionRate = 1.5; //Values > 1 will cause SPACE_Width to increase faster than GAP_Width
#declare AdditionalGAP_WidthPercentage = 60; //Only meaningful when LineAlignment = JUSTIFIED
#declare JustifyLastLinePercentage = 95; //Only meaningful when LineAlignment = JUSTIFIED

#local NLines = 6;

InitializeVariables (NLines)

//Use   \"   for quote marks.
//Use   ^    for a heart.

#declare LineText [0] = ".,:;-'\"!?/()[]+=%#*^";
#declare LineText [1] = "0123456789";
#declare LineText [2] = "ABCDEFGHIJKLMN";
#declare LineText [3] = "OPQRSTUVWXYZ";
#declare LineText [4] = "abcdefghijklmnopq";
#declare LineText [5] = "rstuvwxyz";

CreateParagraph (NLines)

object {Paragraph translate <LeftMargin, TopMargin, ZOffset>}

#local Background = object {
   plane {
      z, 0 inverse
      texture {BackgroundColor}
   } //plane
} //object

object {Background}
