/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* * [VERSION 1.3]                                                                                                   * */
/* *                                                                                                                 * */
/* * INSTRUCTIONS FOR USE:                                                                                           * */
/* *                                                                                                                 * */
/* * This file contains the actual character definitions as well as some useful variables and macros to help you     * */
/* * incorporate them in scenes.                                                                                     * */
/* *                                                                                                                 * */
/* * Do not change any variables in this file.                                                                       * */
/* *                                                                                                                 * */
/* * You will probably want to fill the array "BorderCharacter [0..81]" with character objects. The macros below     * */
/* * will help you. To do this, you will probably also want to combine two or more copies of each character with     * */
/* * different border widths in some unique and exciting way.                                                        * */
/* *                                                                                                                 * */
/* * The macros create characters that are one unit in depth in the z direction, from z = 0 to z = 1. The width      * */
/* * and height of the characters varies. In general, the bottom of the characters is at y = 0. However, some        * */
/* * characters extend to y = -.35625. Similarly, the maximum height of most characters is y = 1, but the asterisk   * */
/* * extends to y = 1.075.                                                                                           * */
/* *                                                                                                                 * */
/* * Useful macros included in this file:                                                                            * */
/* *                                                                                                                 * */
/* *    #macro ASCIIToIndex (ASCIIValue)                                                                             * */
/* *       Returns the index value of the character that matches the ASCII value "ASCIIValue," if there is a match.  * */
/* *       Returns -1 if the character is a SPACE or undefined.                                                      * */
/* *       Note that the "^" is used to represent a heart-shaped character and "\"" is used to represent a double-   * */
/* *       quote mark.                                                                                               * */
/* *                                                                                                                 * */
/* *    #macro MakeCharacter (IndexValue, Border)                                                                    * */
/* *       Creates an object called "Character."                                                                     * */
/* *       Sets the variable "BorderCharacterWidth [IndexValue]" equal to the width of the character.                * */
/* *                                                                                                                 * */
/* *    #macro Italicize ()                                                                                          * */
/* *       Italicizes a character.                                                                                   * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* *                                                                                                                 * */
/* * INITIALIZE VARIABLES                                                                                            * */
/* *                                                                                                                 * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#declare StrokeWidth = .195;
#declare SW2 = StrokeWidth / 2;
#declare Height_Upper = 1;
#declare Height_Lower = .75;
#declare BorderCharacter = array [82]
#declare BorderCharacterWidth = array [82]
#declare Kerning = array [82] [82] {
   //          A    B    C    D    E    F    G    H    I    J    K    L    M    N    O    P    Q    R    S    T    U    V    W    X    Y    Z    a    b    c    d    e    f    g    h    i    j     k    l    m    n    o    p    q    r    s    t    u    v    w    x    y    z    0    1    2    3    4    5    6    7    8    9    .    ,    :    ;    -    '    "    !    ?    /    (    )    [    ]    +    =    %    #    *    HEART
   /* 0 A*/ {  0,   0, .15,   0,   0,   0, .15,   0,   0, .09,   0,   0,   0,   0, .15,   0, .15,   0, .11, .29, .12, .36, .29,   0, .36,   0, .07,   0, .11, .11, .11, .09, .11,   0,   0, .135,   0,   0,   0,   0, .11,   0, .11,   0, .09, .15, .10, .27, .21,   0, .27,   0, .10, .21,   0, .09, .09, .10, .11, .15, .10, .22,   0,   0,   0,   0, .10, .24, .24,   0, .24,   0, .04, .12,   0, .19, .15, .09, .15, .09, .28, .22}, /* 0 A*/
   /* 1 B*/ {.10,   0, .02,   0,   0,   0, .02,   0,   0,   0,   0,   0,   0,   0, .02,   0, .02,   0,   0, .06,   0, .13, .11, .16, .17, .03, .01,   0,   0,   0,   0, .04,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0, .01, .04,   0, .04, .04, .05, .04, .02,   0, .03, .04,   0,   0,   0,   0, .06,   0, .04, .03, .03, .03, .03,   0, .05, .05, .02, .04, .08,   0, .13,   0, .05, .01,   0, .04,   0, .06, .04}, /* 1 B*/
   /* 2 C*/ {.10,   0, .05,   0,   0,   0, .06,   0,   0, .01,   0,   0,   0,   0, .05,   0, .05,   0, .01, .05, .02, .11, .09, .19, .18, .05,   0,   0, .02, .02, .02, .08, .02,   0,   0, .135,   0,   0,   0,   0, .02,   0, .02,   0, .02, .08, .01, .07, .08, .09, .08, .05, .01, .06, .05, .01,   0, .01, .01, .05, .01, .05, .05, .05, .05, .05, .03, .03, .03, .02, .04, .08, .01, .12,   0, .05, .14,   0, .03,   0, .04, .03}, /* 2 C*/
   /* 3 D*/ {.15,   0,   0,   0,   0,   0,   0,   0,   0, .02,   0,   0,   0,   0,   0,   0,   0,   0, .02, .12,   0, .15, .12, .24, .23, .10, .03,   0, .01, .01, .01, .01, .01,   0,   0, .135,   0,   0,   0,   0, .01,   0, .01,   0, .05, .01,   0, .06, .05, .07, .06, .01,   0, .01, .05, .04,   0, .02, .01, .11, .02, .02, .11, .11,   0,   0,   0, .04, .04, .01, .02, .12, .01, .15,   0, .10,   0, .01, .04, .01, .07, .02}, /* 3 D*/
   /* 4 E*/ {  0,   0, .03,   0,   0,   0, .03,   0,   0, .03,   0,   0,   0,   0, .03,   0, .03,   0, .04,   0,   0,   0,   0,   0,   0,   0, .01,   0, .03, .03, .03, .03, .03,   0,   0, .135,   0,   0,   0,   0, .03,   0, .03,   0, .02, .03, .03, .08, .07,   0, .08,   0, .03, .03,   0, .03, .03, .04, .04,   0, .03, .03,   0,   0,   0,   0, .03,   0,   0,   0, .02,   0, .01,   0,   0,   0, .03, .03,   0, .03, .01, .01}, /* 4 E*/
   /* 5 F*/ {.23,   0, .08,   0,   0,   0, .08,   0,   0, .06,   0,   0,   0,   0, .08,   0, .08,   0, .04,   0,   0,   0,   0,   0,   0,   0, .11,   0, .08, .08, .08, .02, .08,   0,   0, .135,   0,   0, .08, .08, .08, .08, .08, .08, .13, .02, .08, .03, .02, .08, .03, .03, .02,   0, .04, .04, .08, .08, .09,   0, .05, .04, .44, .44, .08, .08, .08,   0,   0,   0, .03, .20, .08,   0,   0,   0, .08, .02,   0, .02, .01, .01}, /* 5 F*/
   /* 6 G*/ {.06,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .02,   0, .08, .07, .12, .15,   0,   0,   0,   0,   0,   0, .02,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0,   0, .02,   0, .06, .05, .05, .05,   0,   0, .01,   0,   0,   0,   0,   0, .02,   0, .02,   0,   0,   0,   0,   0, .02, .02,   0, .05, .05,   0, .09,   0, .02,   0,   0, .02,   0, .02, .02}, /* 6 G*/
   /* 7 H*/ {  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, /* 7 H*/
   /* 8 I*/ {  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, /* 8 I*/
   /* 9 J*/ {.09,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .01,   0,   0,   0,   0,   0,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .03,   0,   0,   0,   0,   0,   0,   0, .03, .03,   0,   0,   0,   0,   0,   0,   0, .08,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, /* 9 J*/
   /*10 K*/ {  0,   0, .23,   0,   0,   0, .23,   0,   0, .15,   0,   0,   0,   0, .23,   0, .23,   0, .17, .02, .02, .02, .02,   0, .02,   0, .11,   0, .17, .17, .17, .08, .17,   0,   0, .135,   0,   0,   0,   0, .17,   0, .17,   0, .13, .13, .08, .21, .20,   0, .20,   0, .16, .23,   0, .15, .16, .13, .16, .02, .15, .22,   0,   0,   0,   0, .19, .02, .02,   0, .20,   0, .04, .02,   0, .02, .28, .17, .14, .09, .13, .17}, /*10 K*/
   /*11 L*/ {  0,   0, .11,   0,   0,   0, .11,   0,   0, .03,   0,   0,   0,   0, .11,   0, .11,   0, .04, .29, .06, .29, .23,   0, .40,   0, .01,   0, .05, .05, .05, .09, .05,   0,   0, .135,   0,   0,   0,   0, .05,   0, .05,   0, .02, .09, .03, .20, .16,   0, .20,   0, .03, .23,   0, .03, .08, .03, .04, .15, .03, .26,   0,   0,   0,   0, .08, .19, .19,   0, .25,   0, .01, .13,   0, .21, .08, .02, .13, .02, .19, .24}, /*11 L*/
   /*12 M*/ {  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, /*12 M*/
   /*13 N*/ {  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, /*13 N*/
   /*14 O*/ {.15,   0,   0,   0,   0,   0,   0,   0,   0, .02,   0,   0,   0,   0,   0,   0,   0,   0, .02, .12,   0, .15, .12, .24, .23, .10, .03,   0, .01, .01, .01, .01, .01,   0,   0, .135,   0,   0,   0,   0, .01,   0, .01,   0, .05, .01,   0, .06, .05, .07, .06, .01,   0, .01, .05, .04,   0, .02, .01, .12, .02, .01, .11, .11,   0,   0,   0, .04, .04, .01, .02, .12, .01, .15,   0, .10,   0, .01, .04, .01, .07, .02}, /*14 O*/
   /*15 P*/ {.23,   0, .02,   0,   0,   0, .02,   0,   0, .20,   0,   0,   0,   0, .02,   0, .02,   0, .04, .03,   0, .09, .08, .16, .15, .03, .06,   0, .07, .07, .07,   0, .07,   0,   0, .135,   0,   0,   0,   0, .07,   0, .07,   0, .07,   0,   0, .01, .01,   0,   0,   0,   0,   0, .02, .04, .10, .04, .06, .03, .04,   0, .51, .51,   0,   0, .08, .01, .01,   0,   0, .18, .04, .11,   0, .03, .01,   0,   0,   0, .02,   0}, /*15 P*/
   /*16 Q*/ {.02,   0, .02,   0,   0,   0, .02,   0,   0, .04,   0,   0,   0,   0, .02,   0, .02,   0, .04, .12, .02, .17, .14, .01, .25,   0, .02,   0, .03, .03, .03, .03, .03,   0,   0, .135,   0,   0,   0,   0, .03,   0, .03,   0, .04, .03, .02, .08, .07, .01, .08,   0, .02, .02, .01, .05, .02, .04, .03, .12, .04, .03, .01, .01,   0,   0, .02, .06, .06,   0, .05, .02, .01, .14,   0, .12, .02, .03, .06, .03, .09, .04}, /*16 Q*/
   /*17 R*/ {  0,   0, .12,   0,   0,   0, .12,   0,   0, .15,   0,   0,   0,   0, .12,   0, .12,   0, .14, .12, .10, .19, .18,   0, .25,   0, .11,   0, .17, .17, .17, .09, .17,   0,   0, .135,   0,   0,   0,   0, .17,   0, .17,   0, .14, .10, .10, .10, .10,   0, .10,   0, .10, .10,   0, .13, .18, .15, .15, .12, .13, .10,   0,   0,   0,   0, .05, .11, .11,   0, .10,   0, .04, .12,   0, .13, .11, .10, .10, .09, .12, .10}, /*17 R*/
   /*18 S*/ {.09,   0, .03,   0,   0,   0, .03,   0,   0,   0,   0,   0,   0,   0, .03,   0, .03,   0,   0, .07, .01, .14, .12, .15, .19, .02,   0,   0, .01, .01, .01, .04, .01,   0,   0, .135,   0,   0,   0,   0, .01,   0, .01,   0,   0, .04,   0, .05, .05, .05, .05, .02,   0, .04, .03,   0,   0,   0,   0, .07,   0, .04, .02, .02, .02, .02,   0, .05, .05, .02, .05, .07,   0, .15,   0, .07, .03,   0, .05,   0, .06, .04}, /*18 S*/
   /*19 T*/ {.29,   0, .09,   0,   0,   0, .11,   0,   0, .29,   0,   0,   0,   0, .09,   0, .09,   0, .04,   0,   0,   0,   0,   0,   0,   0, .29,   0, .29, .29, .29, .09, .29,   0,   0, .135,   0,   0, .29, .29, .29, .29, .29, .29, .29, .08, .29, .29, .29, .29, .29, .29, .03, .08, .04, .05, .26, .08, .12,   0, .04, .03, .29, .29, .29, .29, .29,   0,   0,   0, .02, .23, .10,   0,   0,   0, .21, .29,   0, .08,   0, .01}, /*19 T*/
   /*20 U*/ {.12,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .02,   0,   0,   0,   0,   0,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0, .03,   0,   0,   0,   0,   0,   0,   0,   0,   0, .03, .01,   0, .02,   0,   0,   0,   0, .06, .06,   0,   0,   0,   0,   0,   0,   0, .10,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, /*20 U*/
   /*21 V*/ {.36,   0, .15,   0,   0,   0, .15,   0,   0, .23,   0,   0,   0,   0, .15,   0, .15,   0, .12,   0,   0,   0,   0,   0,   0,   0, .19,   0, .20, .20, .20, .09, .20,   0,   0, .135,   0,   0, .09, .09, .20, .09, .20, .09, .21, .09, .09, .09, .09, .09, .09, .09, .10, .09, .12, .11, .20, .12, .19,   0, .11, .10, .29, .29, .09, .09, .19,   0,   0,   0, .09, .29, .17,   0,   0,   0, .15, .09, .06, .08, .07, .08}, /*21 V*/
   /*22 W*/ {.28,   0, .12,   0,   0,   0, .12,   0,   0, .17,   0,   0,   0,   0, .12,   0, .12,   0, .10,   0,   0,   0,   0,   0,   0,   0, .15,   0, .16, .16, .16, .08, .16,   0,   0, .135,   0,   0, .07, .07, .16, .07, .16, .07, .18, .07, .07, .07, .07, .07, .07, .07, .08, .07, .10, .10, .16, .11, .16,   0, .10, .09, .23, .23, .07, .07, .15,   0,   0,   0, .07, .28, .14,   0,   0,   0, .12, .07, .05, .06, .06, .06}, /*22 W*/
   /*23 X*/ {  0,   0, .24,   0,   0,   0, .24,   0,   0, .16,   0,   0,   0,   0, .24,   0, .24,   0, .18,   0,   0,   0,   0,   0,   0,   0, .11,   0, .18, .18, .18, .09, .18,   0,   0, .135,   0,   0,   0,   0, .18,   0, .18,   0, .14, .05, .05, .08, .08,   0, .08,   0, .16, .08,   0, .15, .18, .12, .17,   0, .15, .17,   0,   0,   0,   0, .21,   0,   0,   0, .15,   0, .04,   0,   0,   0, .18, .18, .10, .08, .09, .13}, /*23 X*/
   /*24 Y*/ {.36,   0, .23,   0,   0,   0, .24,   0,   0, .40,   0,   0,   0,   0, .23,   0, .23,   0, .17,   0,   0,   0,   0,   0,   0,   0, .32,   0, .35, .35, .35, .18, .35,   0,   0, .135,   0,   0, .18, .18, .35, .18, .35, .18, .33, .17, .18, .18, .18, .18, .18, .18, .16, .18, .18, .17, .39, .11, .21,   0, .17, .17, .40, .40, .18, .18, .37,   0,   0,   0, .15, .29, .21,   0,   0,   0, .29, .18, .10, .17, .10, .13}, /*24 Y*/
   /*25 Z*/ {  0,   0, .10,   0,   0,   0, .10,   0,   0, .03,   0,   0,   0,   0, .10,   0, .10,   0, .04,   0,   0,   0,   0,   0,   0,   0, .01,   0, .05, .05, .05, .05, .05,   0,   0, .135,   0,   0,   0,   0, .05,   0, .05,   0, .02, .05, .03, .05, .05, .05, .05,   0, .03, .05,   0, .03, .08, .03, .04,   0, .03, .03,   0,   0,   0,   0, .08,   0,   0,   0, .02,   0, .01,   0,   0,   0, .18, .05,   0, .04,   0, .02}, /*25 Z*/
   /*26 a*/ {  0,   0, .04,   0,   0,   0, .04,   0,   0, .04,   0,   0,   0,   0, .04,   0, .04,   0, .04, .29, .04, .21, .18,   0, .34,   0, .04,   0, .04, .04, .04, .06, .04,   0,   0, .135,   0,   0,   0,   0, .04,   0, .04,   0, .04, .06, .04, .12, .11,   0, .12,   0, .04, .06,   0, .04, .04, .04, .04, .15, .04, .07,   0,   0,   0,   0, .04, .09, .09,   0, .09,   0, .04, .12,   0, .20, .04, .04, .10, .04, .12, .07}, /*26 a*/
   /*27 b*/ {.11,   0, .01,   0,   0,   0, .01,   0,   0,   0,   0,   0,   0,   0, .01,   0, .01,   0,   0, .29,   0, .20, .16, .18, .35, .05, .01,   0,   0,   0,   0, .07,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0, .02, .07,   0, .12, .09, .18, .11, .05,   0, .06, .05, .01,   0, .01,   0, .21,   0, .06, .05, .05, .05, .05,   0, .11, .11, .02, .12, .09,   0, .16,   0, .21,   0,   0, .11,   0, .13, .06}, /*27 b*/
   /*28 c*/ {.08,   0,   0,   0,   0,   0,   0,   0,   0, .02,   0,   0,   0,   0,   0,   0,   0,   0, .03, .29,   0, .17, .14, .15, .32, .01,   0,   0, .03, .03, .03, .03, .03,   0,   0, .135,   0,   0,   0,   0, .03,   0, .03,   0, .01, .03,   0, .08, .06, .15, .08, .01,   0, .03, .02, .02, .04, .02, .03, .19, .02, .02, .02, .02, .02, .02, .08, .07, .07, .02, .09, .07, .01, .15,   0, .20,   0, .02, .07, .03, .10, .03}, /*28 c*/
   /*29 d*/ {  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, /*29 d*/
   /*30 e*/ {.11,   0, .01,   0,   0,   0, .01,   0,   0,   0,   0,   0,   0,   0, .01,   0, .01,   0,   0, .29,   0, .20, .16, .18, .35, .05, .01,   0,   0,   0,   0, .07,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0, .05, .07,   0, .12, .09, .18, .11, .05,   0, .06, .06, .01,   0, .01,   0, .21,   0, .06, .05, .05, .05, .05,   0, .11, .11, .02, .12, .09,   0, .16,   0, .21,   0,   0, .11,   0, .13, .06}, /*30 e*/
   /*31 f*/ {.19,   0, .08,   0,   0,   0, .08,   0,   0, .19,   0,   0,   0,   0, .07,   0, .07,   0, .08,   0,   0,   0,   0,   0,   0,   0, .11,   0, .12, .12, .12, .07, .12,   0,   0, .135,   0,   0, .07, .07, .12, .07, .12, .07, .12, .07, .07, .07, .07, .07, .07, .07, .06, .07, .09, .08, .17, .10, .11,   0, .08, .07, .19, .19, .07, .07, .19,   0,   0,   0, .06, .19, .10,   0,   0,   0, .07, .07, .03, .07, .04, .05}, /*31 f*/
   /*32 g*/ {  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .29,   0, .09, .07,   0, .18,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .080,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .15,   0,   0,   0,   0,   0,   0,   0, .01, .01,   0,   0,   0,   0, .10,   0, .04,   0,   0,   0,   0, .07,   0}, /*32 g*/
   /*33 h*/ {  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .29,   0, .19, .15,   0, .33,   0,   0,   0,   0,   0,   0, .04,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0,   0, .04,   0, .10, .08,   0, .10,   0,   0, .04,   0,   0,   0,   0,   0, .15,   0, .04,   0,   0,   0,   0,   0, .08, .08,   0, .09,   0,   0, .12,   0, .20,   0,   0, .08,   0, .11, .05}, /*33 h*/
   /*34 i*/ {  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, /*34 i*/
   /*35 j*/ {  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .030,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, /*35 j*/
   /*36 k*/ {  0,   0, .08,   0,   0,   0, .08,   0,   0, .15,   0,   0,   0,   0, .08,   0, .08,   0, .06, .29, .02, .11, .09,   0, .20,   0, .11,   0, .17, .17, .17, .02, .17,   0,   0, .135,   0,   0,   0,   0, .17,   0, .17,   0, .14, .02, .02, .02, .02,   0, .02,   0, .02, .02,   0, .05, .16, .08, .11, .15, .05, .03,   0,   0,   0,   0, .19, .03, .03,   0, .02,   0, .04, .12,   0, .19, .18, .02, .02, .02, .08, .02}, /*36 k*/
   /*37 l*/ {  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, /*37 l*/
   /*38 m*/ {  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .29,   0, .19, .15,   0, .33,   0,   0,   0,   0,   0,   0, .04,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0,   0, .04,   0, .10, .08,   0, .10,   0,   0, .04,   0,   0,   0,   0,   0, .15,   0, .04,   0,   0,   0,   0,   0, .08, .08,   0, .08,   0,   0, .13,   0, .21,   0,   0, .08,   0, .11, .05}, /*38 m*/
   /*39 n*/ {  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .29,   0, .19, .15,   0, .33,   0,   0,   0,   0,   0,   0, .04,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0,   0, .04,   0, .10, .08,   0, .10,   0,   0, .04,   0,   0,   0,   0,   0, .15,   0, .04,   0,   0,   0,   0,   0, .08, .08,   0, .09,   0,   0, .12,   0, .20,   0,   0, .08,   0, .11, .05}, /*39 n*/
   /*40 o*/ {.11,   0, .01,   0,   0,   0, .01,   0,   0,   0,   0,   0,   0,   0, .01,   0, .01,   0,   0, .29,   0, .20, .16, .18, .35, .05, .02,   0,   0,   0,   0, .07,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0, .02, .07,   0, .12, .09, .18, .11, .05,   0, .06, .05, .01,   0, .01,   0, .21,   0, .06, .05, .05, .05, .05,   0, .11, .11, .02, .12, .09,   0, .16,   0, .21,   0,   0, .11,   0, .13, .06}, /*40 o*/
   /*41 p*/ {.11,   0, .01,   0,   0,   0, .01,   0,   0,   0,   0,   0,   0,   0, .01,   0, .01,   0,   0, .29,   0, .20, .16, .18, .35, .05, .02,   0,   0,   0,   0, .07,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0, .02, .07,   0, .12, .09, .18, .11, .05,   0, .06, .05, .01,   0, .01,   0, .21,   0, .06, .05, .05, .05, .05,   0, .11, .11, .02, .12, .09,   0, .16,   0, .21,   0,   0, .11,   0, .13, .06}, /*41 p*/
   /*42 q*/ {  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .29,   0, .09, .07,   0, .18,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .15,   0,   0,   0,   0,   0,   0,   0, .01, .01,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .07,   0}, /*42 q*/
   /*43 r*/ {.24,   0, .05,   0,   0,   0, .05,   0,   0, .25,   0,   0,   0,   0, .05,   0, .05,   0, .04, .29,   0, .10, .08, .20, .19, .17, .09,   0, .11, .11, .11,   0, .11,   0,   0, .135,   0,   0,   0,   0, .11,   0, .11,   0, .11,   0,   0,   0,   0,   0,   0,   0,   0,   0, .03, .03, .14, .06, .09, .35, .03, .01, .24, .24,   0,   0, .25, .01, .01,   0,   0, .21, .07, .11,   0, .21, .05,   0,   0,   0, .11,   0}, /*43 r*/
   /*44 s*/ {.08,   0, .02,   0,   0,   0, .02,   0,   0, .01,   0,   0,   0,   0, .02,   0, .02,   0, .01, .30, .02, .19, .16, .13, .32,   0,   0,   0, .02, .02, .02, .04, .02,   0,   0, .135,   0,   0,   0,   0, .02,   0, .02,   0,   0, .04, .01, .10, .08, .13, .10, .01, .01, .04, .02,   0,   0,   0, .01, .19, .01, .04, .01, .01, .01, .01, .01, .07, .07, .01, .07, .06, .01, .16,   0, .20, .02, .01, .08,   0, .10, .05}, /*44 s*/
   /*45 t*/ {  0,   0, .04,   0,   0,   0, .04,   0,   0, .06,   0,   0,   0,   0, .04,   0, .04,   0, .06, .13, .02, .12, .10,   0, .14,   0, .04,   0, .08, .08, .08, .02, .08,   0,   0, .135,   0,   0,   0,   0, .08,   0, .08,   0, .05, .02, .02, .02, .02,   0, .02,   0, .02, .02,   0, .06, .13, .06, .07, .13, .06, .03,   0,   0,   0,   0, .13, .03, .03,   0, .02,   0, .04, .12,   0, .13, .03, .02, .03, .02, .09, .02}, /*45 t*/
   /*46 u*/ {  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .29,   0, .09, .07,   0, .18,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .15,   0,   0,   0,   0,   0,   0,   0, .01, .01,   0,   0,   0,   0, .10,   0, .21,   0,   0,   0,   0, .07,   0}, /*46 u*/
   /*47 v*/ {.27,   0, .06,   0,   0,   0, .06,   0,   0, .14,   0,   0,   0,   0, .06,   0, .06,   0, .03, .29,   0, .09, .07, .18, .18, .20, .10,   0, .11, .11, .11,   0, .11,   0,   0, .135,   0,   0,   0,   0, .11,   0, .11,   0, .12,   0,   0,   0,   0,   0,   0,   0,   0,   0, .02, .03, .11, .06, .10, .36, .03,   0, .20, .20,   0,   0, .10, .01, .01,   0,   0, .22, .08, .10,   0, .21, .06,   0,   0,   0, .07,   0}, /*47 v*/
   /*48 w*/ {.21,   0, .05,   0,   0,   0, .05,   0,   0, .11,   0,   0,   0,   0, .05,   0, .05,   0, .03, .29,   0, .09, .07, .18, .18, .15, .09,   0, .09, .09, .09,   0, .09,   0,   0, .135,   0,   0,   0,   0, .09,   0, .09,   0, .10,   0,   0,   0,   0,   0,   0,   0,   0,   0, .03, .03, .08, .07, .09, .33, .03,   0, .16, .16,   0,   0, .08, .01, .01,   0,   0, .21, .07, .10,   0, .20, .04,   0,   0,   0, .07,   0}, /*48 w*/
   /*49 x*/ {  0,   0, .06,   0,   0,   0, .06,   0,   0, .15,   0,   0,   0,   0, .06,   0, .06,   0, .03, .29,   0, .09, .07,   0, .18,   0, .11,   0, .18, .18, .18,   0, .18,   0,   0, .135,   0,   0,   0,   0, .18,   0, .18,   0, .14,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .03, .18, .07, .10, .15, .03,   0,   0,   0,   0,   0, .20, .01, .01,   0,   0,   0, .04, .10,   0, .20, .12,   0,   0,   0, .07,   0}, /*49 x*/
   /*50 y*/ {.27,   0, .06,   0,   0,   0, .06,   0,   0, .14,   0,   0,   0,   0, .06,   0, .06,   0, .03, .29,   0, .09, .07, .18, .18, .20, .11,   0, .11, .11, .11,   0, .11,   0,   0, .135,   0,   0,   0,   0, .11,   0, .11,   0, .12,   0,   0,   0,   0,   0,   0,   0,   0,   0, .02, .03, .11, .06, .10, .36, .03,   0, .20, .20,   0,   0, .10, .01, .01,   0,   0, .21, .08, .10,   0, .21, .05,   0,   0,   0, .07,   0}, /*50 y*/
   /*51 z*/ {  0,   0, .01,   0,   0,   0,   0,   0,   0, .03,   0,   0,   0,   0, .01,   0, .01,   0, .04, .29,   0, .09, .07,   0, .18,   0, .01,   0, .04, .04, .04,   0, .04,   0,   0, .135,   0,   0,   0,   0, .04,   0, .04,   0, .01,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .03, .08, .03, .04, .15, .03,   0,   0,   0,   0,   0, .09, .01, .01,   0,   0,   0, .01, .10,   0, .21,   0,   0,   0,   0, .07,   0}, /*51 z*/
   /*52 0*/ {.10,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .03,   0, .10, .08, .16, .16, .03, .01,   0,   0,   0,   0,   0,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0, .01,   0,   0, .01, .01, .01, .01,   0,   0,   0, .02,   0,   0,   0,   0, .03,   0,   0, .03, .03,   0,   0,   0, .01, .01,   0,   0, .08,   0, .11,   0, .03,   0,   0,   0,   0, .02,   0}, /*52 0*/
   /*53 1*/ {  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, /*53 1*/
   /*54 2*/ {  0,   0, .02,   0,   0,   0, .02,   0,   0, .03,   0,   0,   0,   0, .02,   0, .02,   0, .04, .03,   0, .10, .08,   0, .15,   0, .02,   0, .05, .05, .05,   0, .05,   0,   0, .135,   0,   0,   0,   0, .05,   0, .05,   0, .02,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .03, .10, .04, .04, .03, .03,   0,   0,   0,   0,   0, .08, .01, .01,   0,   0,   0, .01, .11,   0, .03, .02,   0,   0,   0, .02,   0}, /*54 2*/
   /*55 3*/ {.09,   0, .02,   0,   0,   0, .02,   0,   0,   0,   0,   0,   0,   0, .02,   0, .02,   0,   0, .05,   0, .12, .10, .15, .17, .02,   0,   0,   0,   0,   0, .03,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0, .01, .03,   0, .03, .03, .03, .03, .02,   0, .03, .03,   0,   0,   0,   0, .05,   0, .04, .03, .03, .03, .03,   0, .04, .04, .02, .03, .08,   0, .13,   0, .05, .01,   0, .03,   0, .04, .03}, /*55 3*/
   /*56 4*/ {.09,   0, .01,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .01,   0, .01,   0,   0, .15,   0, .15, .15, .15, .15, .04,   0,   0,   0,   0,   0, .09,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0,   0, .08,   0, .11, .09, .15, .11, .05,   0, .15, .03,   0,   0,   0,   0, .16,   0, .08, .15, .15, .15, .15,   0, .15, .15, .01, .15, .07,   0, .15,   0, .15,   0,   0, .15,   0, .15, .07}, /*56 4*/
   /*57 5*/ {.10,   0, .01,   0,   0,   0, .01,   0,   0,   0,   0,   0,   0,   0, .01,   0, .01,   0,   0, .08,   0, .08, .08, .08, .08, .03, .01,   0,   0,   0,   0, .09,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0, .01, .09,   0, .12, .10, .16, .12, .03,   0, .09, .04,   0,   0,   0,   0, .08,   0, .07, .04, .04, .04, .04,   0, .07, .07, .01, .10, .08,   0, .08,   0, .08, .01,   0, .08,   0, .09, .08}, /*57 5*/
   /*58 6*/ {.10,   0, .01,   0,   0,   0, .01,   0,   0,   0,   0,   0,   0,   0, .01,   0, .01,   0,   0, .26,   0, .22, .18, .17, .27, .04, .01,   0,   0,   0,   0, .09,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0, .02, .08,   0, .12, .10, .17, .12, .03,   0, .09, .04,   0,   0,   0,   0, .20,   0, .07, .04, .04, .04, .04,   0, .14, .14, .02, .17, .08,   0, .16,   0, .20, .01,   0, .14,   0, .16, .08}, /*58 6*/
   /*59 7*/ {.31,   0, .12,   0,   0,   0, .12,   0,   0, .24,   0,   0,   0,   0, .12,   0, .12,   0, .07,   0,   0,   0,   0,   0,   0,   0, .19,   0, .21, .21, .21, .07, .21,   0,   0, .135,   0,   0, .06, .06, .21, .06, .21, .06, .20, .07, .06, .06, .06, .06, .06, .07, .05, .06, .06, .06, .21, .08, .13,   0, .06, .05, .29, .29, .07, .07, .20,   0,   0,   0, .04, .24, .12,   0,   0,   0, .15, .06,   0, .05, .02, .02}, /*59 7*/
   /*60 8*/ {.09,   0, .02,   0,   0,   0, .02,   0,   0,   0,   0,   0,   0,   0, .02,   0, .02,   0,   0, .05,   0, .12, .10, .15, .17, .03, .01,   0,   0,   0,   0, .03,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0, .01, .03,   0, .03, .03, .03, .03, .02,   0, .03, .03,   0,   0,   0,   0, .05,   0, .04, .02, .02, .02, .02,   0, .04, .04, .02, .03, .08,   0, .13,   0, .05, .02,   0, .03,   0, .04, .03}, /*60 8*/
   /*61 9*/ {.19,   0, .01,   0,   0,   0, .01,   0,   0, .06,   0,   0,   0,   0, .01,   0, .01,   0, .04, .04,   0, .10, .08, .17, .17, .04, .04,   0, .04, .04, .04,   0, .04,   0,   0, .135,   0,   0,   0,   0, .04,   0, .04,   0, .06,   0,   0, .01, .01, .01, .01,   0,   0,   0, .02, .04, .04, .04, .04, .04, .04,   0, .12, .12,   0,   0, .03, .01, .01,   0,   0, .16, .03, .11,   0, .04, .01,   0,   0,   0, .03,   0}, /*61 9*/
   /*62 .*/ {  0,   0, .11,   0,   0,   0, .11,   0,   0, .03,   0,   0,   0,   0, .11,   0, .11,   0, .04, .29, .06, .30, .24,   0, .40,   0, .01,   0, .05, .05, .05, .08, .05,   0,   0, .135,   0,   0,   0,   0, .05,   0, .05,   0, .02, .09, .03, .20, .17,   0, .20,   0, .03, .23,   0, .03, .08, .03, .04, .15, .03, .25,   0,   0,   0,   0, .08, .08, .08,   0, .25,   0, .01, .13,   0, .20, .08, .08, .14, .08, .19, .25}, /*62 .*/
   /*63 ,*/ {  0,   0, .11,   0,   0,   0, .11,   0,   0, .03,   0,   0,   0,   0, .11,   0, .11,   0, .04, .29, .06, .30, .24,   0, .40,   0, .01,   0, .05, .05, .05, .08, .05,   0,   0, .110,   0,   0,   0,   0, .05,   0, .05,   0, .02, .09, .03, .20, .17,   0, .16,   0, .03, .23,   0, .03, .08, .03, .04, .15, .03, .25,   0,   0,   0,   0, .08, .08, .08,   0, .25,   0, .01, .12,   0, .07, .08, .08, .14, .08, .19, .25}, /*63 ,*/
   /*64 :*/ {  0,   0,   0,   0,   0,   0,   0,   0,   0, .03,   0,   0,   0,   0,   0,   0,   0,   0, .04, .29,   0, .09, .07,   0, .18,   0, .01,   0, .05, .05, .05,   0, .05,   0,   0, .135,   0,   0,   0,   0, .05,   0, .05,   0, .02,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .03, .08, .03, .04, .15, .03,   0,   0,   0,   0,   0,   0, .01, .01,   0,   0,   0, .01, .10,   0, .21,   0,   0,   0,   0, .06,   0}, /*64 :*/
   /*65 ;*/ {  0,   0,   0,   0,   0,   0,   0,   0,   0, .03,   0,   0,   0,   0,   0,   0,   0,   0, .04, .29,   0, .09, .07,   0, .18,   0, .01,   0, .05, .05, .05,   0, .05,   0,   0, .110,   0,   0,   0,   0, .05,   0, .05,   0, .02,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .03, .08, .03, .04, .15, .03,   0,   0,   0,   0,   0,   0, .01, .01,   0,   0,   0, .01, .10,   0, .08,   0,   0,   0,   0, .06,   0}, /*65 ;*/
   /*66 -*/ {.10,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .29,   0, .20, .15, .19, .37, .07, .01,   0,   0,   0,   0, .09,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0, .06, .08,   0, .10, .08, .20, .10, .09,   0, .23, .06,   0,   0,   0,   0, .20,   0, .06, .08, .08, .08, .08,   0, .08, .08, .01, .26, .09,   0, .16,   0, .20,   0,   0, .08,   0, .19, .06}, /*66 -*/
   /*67 '*/ {.24,   0, .03,   0,   0,   0, .03,   0,   0, .24,   0,   0,   0,   0, .03,   0, .03,   0, .05,   0,   0,   0,   0,   0,   0,   0, .07,   0, .10, .10, .10, .01, .10,   0,   0, .135,   0,   0, .01, .01, .10, .01, .10, .01, .09, .01, .01, .01, .01, .01, .01, .01, .01,   0, .04, .04, .14, .06, .07,   0, .04, .01, .02, .02,   0,   0, .02,   0,   0,   0, .01, .20, .06,   0,   0,   0, .02,   0,   0,   0,   0, .01}, /*67 '*/
   /*68 "*/ {.24,   0, .03,   0,   0,   0, .03,   0,   0, .24,   0,   0,   0,   0, .03,   0, .03,   0, .05,   0,   0,   0,   0,   0,   0,   0, .07,   0, .10, .10, .10, .01, .10,   0,   0, .135,   0,   0, .01, .01, .10, .01, .10, .01, .09, .01, .01, .01, .01, .01, .01, .01, .01,   0, .04, .04, .14, .06, .07,   0, .04, .01, .02, .02,   0,   0, .02,   0,   0,   0, .01, .20, .06,   0,   0,   0, .02,   0,   0,   0,   0, .01}, /*68 "*/
   /*69 !*/ {  0,   0, .01,   0,   0,   0, .01,   0,   0, .02,   0,   0,   0,   0, .01,   0, .01,   0, .02,   0,   0,   0,   0,   0,   0,   0, .01,   0, .02, .02, .02,   0, .02,   0,   0, .135,   0,   0,   0,   0, .02,   0, .02,   0, .02,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .02, .01, .02, .02,   0, .02,   0,   0,   0,   0,   0, .01,   0,   0,   0,   0,   0, .01,   0,   0,   0, .01,   0,   0,   0,   0,   0}, /*69 !*/
   /*70 ?*/ {.18,   0, .02,   0,   0,   0, .02,   0,   0, .18,   0,   0,   0,   0, .02,   0, .02,   0, .04, .03,   0, .09, .08, .15, .15, .03, .06,   0, .07, .07, .07,   0, .07,   0,   0, .135,   0,   0,   0,   0, .07,   0, .07,   0, .08,   0,   0,   0,   0,   0,   0,   0,   0,   0, .03, .04, .10, .05, .06, .03, .04,   0, .18, .18,   0,   0, .09, .01, .01,   0,   0, .18, .04, .10,   0, .03, .02,   0,   0,   0, .03,   0}, /*70 ?*/
   /*71 |*/ {.29,   0, .12,   0,   0,   0, .12,   0,   0, .18,   0,   0,   0,   0, .12,   0, .12,   0, .11,   0,   0,   0,   0,   0,   0,   0, .16,   0, .16, .16, .16, .07, .16,   0,   0, .135,   0,   0, .07, .07, .16, .07, .16, .07, .17, .07, .07, .07, .07, .08, .07, .07, .08, .07, .10, .10, .16, .11, .16,   0, .10, .08, .23, .23, .07, .07, .15,   0,   0,   0, .07, .28, .14,   0,   0,   0, .11, .07, .05, .07, .06, .07}, /*71 |*/
   /*72 (*/ {.12,   0, .14,   0,   0,   0, .14,   0,   0, .16,   0,   0,   0,   0, .14,   0, .14,   0, .13,   0,   0,   0,   0,   0,   0,   0, .16,   0, .16, .16, .16, .10, .15,   0,   0,    0,   0,   0, .10, .10, .16,   0, .16, .10, .16, .10, .10, .10, .10, .10, .10, .10, .11, .10, .13, .13, .16, .12, .16,   0, .13, .11, .13, .13, .10, .10, .15,   0,   0,   0, .10, .13, .16,   0,   0,   0, .13, .10, .07, .09, .08, .09}, /*72 (*/
   /*73 )*/ {.04,   0, .01,   0,   0,   0, .01,   0,   0,   0,   0,   0,   0,   0, .01,   0, .01,   0,   0, .10,   0, .17, .15, .04, .21, .01, .01,   0,   0,   0,   0, .03,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0, .01, .03,   0, .08, .07, .04, .08,   0,   0, .03, .01,   0,   0,   0,   0, .11,   0, .03, .01, .01, .01, .01,   0, .06, .06, .01, .05, .04,   0, .16,   0, .10,   0,   0, .06,   0, .09, .04}, /*73 )*/
   /*74 [*/ {.20,   0, .09,   0,   0,   0, .11,   0,   0, .20,   0,   0,   0,   0, .09,   0, .09,   0, .05,   0,   0,   0,   0,   0,   0,   0, .21,   0, .20, .20, .20, .09, .08,   0,   0,    0,   0,   0, .20, .20, .20,   0, .20, .20, .20, .08, .20, .20, .20, .20, .09, .20, .03, .10, .05, .05, .20, .08, .12,   0, .05, .04, .20, .07, .20, .07, .20,   0,   0,   0, .03, .20, .10,   0,   0,   0, .20, .20,   0, .20,   0, .02}, /*74 [*/
   /*75 ]*/ {  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0}, /*75 ]*/
   /*76 +*/ {.15,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .07, .22,   0, .14, .12, .18, .29, .18, .03,   0,   0,   0,   0,   0,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0, .05,   0,   0, .06, .05, .12, .06,   0,   0,   0, .10, .10,   0, .02,   0, .21, .02,   0, .08, .08,   0,   0,   0, .02, .02,   0, .08, .12,   0, .14,   0, .20,   0,   0, .04,   0, .06, .01}, /*76 +*/
   /*77 =*/ {.09,   0, .01,   0,   0,   0, .01,   0,   0,   0,   0,   0,   0,   0, .01,   0, .01,   0,   0, .29,   0, .09, .07, .18, .18, .04,   0,   0,   0,   0,   0,   0,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .02,   0,   0,   0,   0, .20,   0,   0,   0,   0,   0,   0,   0, .01, .01,   0,   0, .07,   0, .10,   0, .08,   0,   0,   0,   0, .07,   0}, /*77 =*/
   /*78 %*/ {.06,   0, .03,   0,   0,   0, .03,   0,   0,   0,   0,   0,   0,   0, .03,   0, .03,   0,   0, .14, .01, .14, .14, .10, .14,   0,   0,   0,   0,   0,   0, .09,   0,   0,   0, .135,   0,   0,   0,   0, .01,   0, .01,   0,   0, .08,   0, .16, .13, .10, .15,   0,   0, .23, .01,   0,   0,   0,   0, .18,   0, .14,   0,   0,   0,   0,   0, .14, .14,   0, .25, .05,   0, .14,   0, .14, .04,   0, .22,   0, .22, .12}, /*78 %*/
   /*79 #*/ {.09,   0, .01,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .01,   0, .01,   0,   0, .08,   0, .09, .07, .09, .09, .04,   0,   0,   0,   0,   0,   0,   0,   0,   0, .135,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, .02,   0,   0,   0,   0, .08,   0,   0, .08, .08,   0,   0,   0,   0,   0,   0,   0, .07,   0, .09,   0, .08,   0,   0,   0,   0, .04,   0}, /*79 #*/
   /*80 **/ {.28,   0, .07,   0,   0,   0, .07,   0,   0, .33,   0,   0,   0,   0, .07,   0, .07,   0, .04, .01,   0, .07, .06, .09, .10, .01, .11,   0, .13, .13, .13, .06, .13,   0,   0, .135,   0,   0, .06, .06, .13, .06, .13, .06, .12, .06, .06, .08, .08, .08, .08, .06, .02, .06, .04, .04, .17, .07, .11, .01, .04, .03, .08, .08, .06, .06, .08,   0,   0,   0, .01, .22, .09, .08,   0, .01, .06, .06,   0, .06,   0, .01}, /*80 **/
   /*81 ^*/ {.22,   0, .02,   0,   0,   0, .02,   0,   0, .11,   0,   0,   0,   0, .02,   0, .02,   0, .03, .01,   0, .08, .07, .13, .13, .01, .05,   0, .06, .06, .06,   0, .06,   0,   0, .135,   0,   0,   0,   0, .06,   0, .06,   0, .07,   0,   0,   0,   0,   0,   0,   0,   0,   0, .02, .03, .07, .05, .05, .01, .03,   0, .25, .25,   0,   0, .05, .01, .01,   0,   0, .18, .04, .09,   0, .01, .01,   0,   0,   0,   0,   0}  /*81 ^*/
   //          A    B    C    D    E    F    G    H    I    J    K    L    M    N    O    P    Q    R    S    T    U    V    W    X    Y    Z    a    b    c    d    e    f    g    h    i    j     k    l    m    n    o    p    q    r    s    t    u    v    w    x    y    z    0    1    2    3    4    5    6    7    8    9    .    ,    :    ;    -    '    "    !    ?    /    (    )    [    ]    +    =    %    #    *    HEART
} //array

#for (I, 0, 81)
   #for (J, 0, 81)
      #declare Kerning [I] [J] = -Kerning [I] [J];
   #end //#for
#end //#for

#declare ItalicOffset = array [164] {
   //The first number is how much to shift left if the character is at the start of a line,
   //the second number is how much extra line width is added if it's at the end of a line.
   /* 0 A*/     0,    0,
   /* 1 B*/     0, .110,
   /* 2 C*/ -.090, .164,
   /* 3 D*/     0, .110,
   /* 4 E*/     0, .200,
   /* 5 F*/     0, .200,
   /* 6 G*/ -.090, .148,
   /* 7 H*/     0, .200,
   /* 8 I*/     0, .200,
   /* 9 J*/ -.058, .200,
   /*10 K*/     0, .180,
   /*11 L*/     0, .039,
   /*12 M*/     0, .200,
   /*13 N*/     0, .200,
   /*14 O*/ -.090, .110,
   /*15 P*/     0, .143,
   /*16 Q*/ -.090, .110,
   /*17 R*/     0, .043,
   /*18 S*/ -.064, .102,
   /*19 T*/ -.161, .200,
   /*20 U*/ -.072, .200,
   /*21 V*/ -.200, .200,
   /*22 W*/ -.200, .200,
   /*23 X*/     0, .200,
   /*24 Y*/ -.200, .200,
   /*25 Z*/     0, .200,
   /*26 a*/ -.041, .062,
   /*27 b*/     0, .083,
   /*28 c*/ -.067, .107,
   /*29 d*/ -.067, .200,
   /*30 e*/ -.067, .083,
   /*31 f*/ -.088, .200,
   /*32 g*/ -.067, .150,
   /*33 h*/     0, .092,
   /*34 i*/     0, .200,
   /*35 j*/  .072, .200,
   /*36 k*/     0, .130,
   /*37 l*/     0, .200,
   /*38 m*/     0, .096,
   /*39 n*/     0, .092,
   /*40 o*/ -.067, .083,
   /*41 p*/  .071, .083,
   /*42 q*/ -.067, .150,
   /*43 r*/     0, .146,
   /*44 s*/ -.049, .086,
   /*45 t*/ -.125, .124,
   /*46 u*/ -.057, .150,
   /*47 v*/ -.150, .150,
   /*48 w*/ -.150, .150,
   /*49 x*/     0, .150,
   /*50 y*/ -.054, .150,
   /*51 z*/     0, .150,
   /*52 0*/ -.059, .140,
   /*53 1*/ -.113, .200,
   /*54 2*/     0, .143,
   /*55 3*/ -.056, .117,
   /*56 4*/ -.048, .087,
   /*57 5*/ -.056, .120,
   /*58 6*/ -.062, .076,
   /*59 7*/ -.152, .200,
   /*60 8*/ -.057, .117,
   /*61 9*/ -.124, .138,
   /*62 .*/     0, .039,
   /*63 ,*/     0, .039,
   /*64 :*/     0, .150,
   /*65 ;*/     0, .150,
   /*66 -*/ -.056, .095,
   /*67 '*/ -.144, .200,
   /*68 "*/ -.144, .200,
   /*69 !*/     0, .200,
   /*70 ?*/ -.129, .143,
   /*71 |*/     0, .200,
   /*72 (*/ -.040, .200,
   /*73 )*/  .074, .088,
   /*74 [*/  .071, .200,
   /*75 ]*/  .071, .200,
   /*76 +*/ -.081, .119,
   /*77 =*/ -.048, .152,
   /*78 %*/ -.139, .061,
   /*79 #*/ -.047, .153,
   /*80 **/ -.157, .157,
   /*81 ^*/ -.131, .150
} //array

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* *                                                                                                                 * */
/* * USEFUL MACROS                                                                                                   * */
/* *                                                                                                                 * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#macro ASCIIToIndex (ASCIIValue)

   #switch (ASCIIValue)
      #range (asc ("A"), asc ("Z")) #local IndexValue = ASCIIValue - asc ("A"); #break
      #range (asc ("a"), asc ("z")) #local IndexValue = ASCIIValue - asc ("a") + 26; #break
      #range (asc ("0"), asc ("9")) #local IndexValue = ASCIIValue - asc ("0") + 52; #break
      #case (asc (".")) #local IndexValue = 62; #break
      #case (asc (",")) #local IndexValue = 63; #break
      #case (asc (":")) #local IndexValue = 64; #break
      #case (asc (";")) #local IndexValue = 65; #break
      #case (asc ("-")) #local IndexValue = 66; #break
      #case (asc ("'")) #local IndexValue = 67; #break
      #case (asc ("\"")) #local IndexValue = 68; #break
      #case (asc ("!")) #local IndexValue = 69; #break
      #case (asc ("?")) #local IndexValue = 70; #break
      #case (asc ("/")) #local IndexValue = 71; #break
      #case (asc ("(")) #local IndexValue = 72; #break
      #case (asc (")")) #local IndexValue = 73; #break
      #case (asc ("[")) #local IndexValue = 74; #break
      #case (asc ("]")) #local IndexValue = 75; #break
      #case (asc ("+")) #local IndexValue = 76; #break
      #case (asc ("=")) #local IndexValue = 77; #break
      #case (asc ("%")) #local IndexValue = 78; #break
      #case (asc ("#")) #local IndexValue = 79; #break
      #case (asc ("*")) #local IndexValue = 80; #break
      #case (asc ("^")) #local IndexValue = 81; #break //Heart
      #else #local IndexValue = -1; #break //Space
   #end //#switch

   (IndexValue)

#end //#macro ASCIIToIndex

#macro MakeCharacter (IndexValue, Border)

   #switch (IndexValue)
      #case (0) MakeA1 (Border) #break
      #case (1) MakeB1 (Border) #break
      #case (2) MakeC1 (Border) #break
      #case (3) MakeD1 (Border) #break
      #case (4) MakeE1 (Border) #break
      #case (5) MakeF1 (Border) #break
      #case (6) MakeG1 (Border) #break
      #case (7) MakeH1 (Border) #break
      #case (8) MakeI1 (Border) #break
      #case (9) MakeJ1 (Border) #break
      #case (10) MakeK1 (Border) #break
      #case (11) MakeL1 (Border) #break
      #case (12) MakeM1 (Border) #break
      #case (13) MakeN1 (Border) #break
      #case (14) MakeO1 (Border) #break
      #case (15) MakeP1 (Border) #break
      #case (16) MakeQ1 (Border) #break
      #case (17) MakeR1 (Border) #break
      #case (18) MakeS1 (Border) #break
      #case (19) MakeT1 (Border) #break
      #case (20) MakeU1 (Border) #break
      #case (21) MakeV1 (Border) #break
      #case (22) MakeW1 (Border) #break
      #case (23) MakeX1 (Border) #break
      #case (24) MakeY1 (Border) #break
      #case (25) MakeZ1 (Border) #break
      #case (26) MakeA2 (Border) #break
      #case (27) MakeB2 (Border) #break
      #case (28) MakeC2 (Border) #break
      #case (29) MakeD2 (Border) #break
      #case (30) MakeE2 (Border) #break
      #case (31) MakeF2 (Border) #break
      #case (32) MakeG2 (Border) #break
      #case (33) MakeH2 (Border) #break
      #case (34) MakeI2 (Border) #break
      #case (35) MakeJ2 (Border) #break
      #case (36) MakeK2 (Border) #break
      #case (37) MakeL2 (Border) #break
      #case (38) MakeM2 (Border) #break
      #case (39) MakeN2 (Border) #break
      #case (40) MakeO2 (Border) #break
      #case (41) MakeP2 (Border) #break
      #case (42) MakeQ2 (Border) #break
      #case (43) MakeR2 (Border) #break
      #case (44) MakeS2 (Border) #break
      #case (45) MakeT2 (Border) #break
      #case (46) MakeU2 (Border) #break
      #case (47) MakeV2 (Border) #break
      #case (48) MakeW2 (Border) #break
      #case (49) MakeX2 (Border) #break
      #case (50) MakeY2 (Border) #break
      #case (51) MakeZ2 (Border) #break
      #case (52) MakeDigit_0 (Border) #break
      #case (53) MakeDigit_1 (Border) #break
      #case (54) MakeDigit_2 (Border) #break
      #case (55) MakeDigit_3 (Border) #break
      #case (56) MakeDigit_4 (Border) #break
      #case (57) MakeDigit_5 (Border) #break
      #case (58) MakeDigit_6 (Border) #break
      #case (59) MakeDigit_7 (Border) #break
      #case (60) MakeDigit_8 (Border) #break
      #case (61) MakeDigit_9 (Border) #break
      #case (62) MakePERIOD (Border) #break
      #case (63) MakeCOMMA (Border) #break
      #case (64) MakeCOLON (Border) #break
      #case (65) MakeSEMICOLON (Border) #break
      #case (66) MakeDASH (Border) #break
      #case (67) MakeAPOSTROPHE (Border) #break
      #case (68) MakeQUOTE (Border) #break
      #case (69) MakeEXCLAMATION (Border) #break
      #case (70) MakeQUESTION (Border) #break
      #case (71) MakeSLASH (Border) #break
      #case (72) MakePARENTHESIS_LEFT (Border) #break
      #case (73) MakePARENTHESIS_RIGHT (Border) #break
      #case (74) MakeBRACKET_LEFT (Border) #break
      #case (75) MakeBRACKET_RIGHT (Border) #break
      #case (76) MakePLUS (Border) #break
      #case (77) MakeEQUAL (Border) #break
      #case (78) MakePERCENT (Border) #break
      #case (79) MakeNUMBER (Border) #break
      #case (80) MakeASTERISK (Border) #break
      #case (81) MakeHEART (Border) #break
   #end //#switch

   #declare BorderCharacterWidth [IndexValue] = CharacterWidth;

#end //#macro MakeCharacter

#macro Italicize ()

   matrix < 1,  0,  0,
           .2,  1,  0,
            0,  0,  1,
            0,  0,  0>

#end //macro Italicize

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* *                                                                                                                 * */
/* * CHARACTER DEFINITION MACROS                                                                                     * */
/* *                                                                                                                 * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#macro MakeGenericComma (Border)

   #declare Character = object {
      #local R = .22;
      #local TailSW = StrokeWidth * 2/3;
      #local ClipAngle = 30;
      #local Top = object {
         difference {
            box {<Border, 0, 0> <StrokeWidth - Border, StrokeWidth - Border, 1>}
            box {<-.1, -.1, -.1> <StrokeWidth + Border - TailSW, Border, 1.1>}
         } //difference
      } //object
      #local Tail = object {
         union {
            intersection {
               difference {
                  cylinder {<0, 0, 0> <0, 0, 1>, R - Border}
                  cylinder {<0, 0, -.1> <0, 0, 1.1>, R - TailSW + Border}
               } //difference
               plane {y, 0}
               plane {x, Border inverse rotate ClipAngle * z}
            } //intersection
            cylinder {<R - TailSW / 2, 0, 0> <R - TailSW / 2, 0, 1>, TailSW / 2 - Border}
         } //union
         translate (-R + StrokeWidth) * x
      } //object
      union {
         object {Top}
         object {Tail}
      } //union
   } //object

   #declare CharacterWidth = StrokeWidth;

#end //#macro MakeGenericComma

#macro MakeGenericQUOTE (Border, Elevation, Angle)

   #local Elevation_ = Elevation;
   #local Angle_ = Angle;

   #declare Character = object {
      #local BaseWidth = StrokeWidth * .75;
      intersection {
         box {<-SW2 + Border, Elevation_ + Border, 0> <SW2 - Border, Height_Upper - Border, 1>}
         plane {x, Border inverse rotate Angle_ * z translate <-BaseWidth / 2, Elevation_, 0>}
         plane {x, -Border rotate -Angle_ * z translate <BaseWidth / 2, Elevation_, 0>}
      } //intersection
      translate SW2 * x
   } //object

#end //#macro MakeGenericQUOTE

#macro MakeGenericDigit_0 (Border, R, Height, TempSW)

   #local R_ = R;
   #local Height_ = Height;
   #local TempSW_ = TempSW;
   #local TempSW2 = TempSW_ / 2;

   #declare Character = object {
      #local Y1 = Height_ - R_;
      #local Y2 = R_;
      #local RoundPart = object {
         intersection {
            difference {
               cylinder {<0, 0, 0> <0, 0, 1>, R_ - Border}
               cylinder {<0, 0, -.1> <0, 0, 1.1>, R_ - TempSW_ + Border}
            } //difference
            plane {y, 0}
         } //intersection
      } //object
      #local VerticalBar = object {
         union {
            box {<Border, 0, 0> <TempSW_ - Border, Height - R_ * 2, 1>}
            cylinder {<TempSW2, 0, 0> <TempSW2, 0, 1>, TempSW2 - Border}
            cylinder {<TempSW2, Height - R_ * 2, 0> <TempSW2, Height - R_ * 2, 1>, TempSW2 - Border}
         } //union
         translate R_ * y
      } //object
      union {
         object {RoundPart translate R_ * y}
         object {RoundPart rotate 180 * z translate (Height_ - R_) * y}
         object {VerticalBar translate -R_ * x}
         object {VerticalBar translate (R_ - TempSW_) * x}
      } //union
      translate R_ * x
   } //object

   #declare CharacterWidth = R_ * 2;

#end //#macro MakeGenericDigit_0

#macro MakeGenericDigit_69 (Border, Spin)

   #declare Character = object {
      #local R = Height_Lower * .46;
      #local CharacterWithTail = object {
         difference {
            union {
               cylinder {<0, 0, 0> <0, 0, 1>, R - Border}
               #local XC = 0;
               #local YC = 0;
               #local CurAngle = 0;
               #local CurR = R;
               #local NSections = 14;
               #local DeltaTheta = 2;
               #local RMultiplier = 1.2;
               #local Sections = object {
                  union {
                     #for (I, 0, NSections - 1)
                        #local X1 = XC - CurR * cos (radians (CurAngle));
                        #local Y1 = YC + CurR * sin (radians (CurAngle));
                        #local X2 = XC - (CurR - SW2) * cos (radians (CurAngle));
                        #local Y2 = YC + (CurR - SW2) * sin (radians (CurAngle));
                        #local CurR = CurR * RMultiplier;
                        #local XC = X1 - CurR * cos (radians (CurAngle + 180));
                        #local YC = Y1 + CurR * sin (radians (CurAngle + 180));
                        #local Section = object {
                           intersection {
                              difference {
                                 cylinder {<XC, YC, 0> <XC, YC, 1>, CurR - Border}
                                 cylinder {<XC, YC, -.1> <XC, YC, 1.1>, CurR - StrokeWidth + Border}
                              } //difference
                              plane {y, 0 inverse rotate -CurAngle * z translate <XC, YC, 0>}
                              plane {y, 0 rotate (-CurAngle - DeltaTheta) * z translate <XC, YC, 0>}
                           } //intersection
                        } //object
                        #if (I > 0)
                           #local Section = object {
                              union {
                                 object {Section}
                                 cylinder {<0, 0, 0> <0, 0, 1>, SW2 - Border translate <X2, Y2, 0>}
                              } //union
                           } //object
                        #end //#if
                        object {Section}
                        #local CurAngle = CurAngle + DeltaTheta;
                     #end //#for
                  } //union
               } //object
               object {Sections}
            } //union
            cylinder {<0, 0, -.1> <0, 0, 1.1>, R - StrokeWidth + Border}
         } //difference
         translate <R, R, 0>
      } //object
      intersection {
         object {CharacterWithTail}
         plane {y, Height_Upper - Border}
      } //intersection
      #if (Spin)
         translate <-R, -R, 0>
         rotate 180 * z
         translate <R, Height_Upper - R, 0>
      #end //#if
      bounded_by {
         box {<-.01, -.01, -.01> <R * 2 + .01, Height_Upper + .01, 1.01>}
      } //bounded_by
   } //object

   #declare CharacterWidth = R * 2;

#end //#macro MakeGenericDigit_69

#macro MakeGenericS (Border, Height, Uppercase)

   #local Height_ = Height;

   #if (Uppercase)
      #local RotationAmount = .5;
      #local ClipAngle_Top = 2.5 + RotationAmount;
      #local ClipAngle_Bottom = 5.5 + RotationAmount;
      #local R1 = .5;
      #local R2 = .3;
      #local R3 = .27;
      #local A1 = 20;
      #local A2 = 0;
      #local A3 = 15;
      #local R4 = .52;
      #local R5 = .34;
      #local R6 = R3;
      #local A4 = 25;
      #local A5 = A2;
      #local A6 = A3;
      #local BottomXOffset = .038;
      #local CharacterXOffset = .41250515; //* * * WRONG, BUT NOT IMPORTANT * * *
      #declare CharacterWidth = .79071627; //* * * WRONG, BUT NOT IMPORTANT * * *
   #else
      #local RotationAmount = 2;
      #local ClipAngle_Top = 10.5 + RotationAmount;
      #local ClipAngle_Bottom = 8.5 + RotationAmount;
      #local R1 = .4;
      #local R2 = .25;
      #local R3 = .22;
      #local A1 = 22;
      #local A2 = 5;
      #local A3 = 5;
      #local R4 = .42;
      #local R5 = .26;
      #local R6 = R3;
      #local A4 = 30;
      #local A5 = A2;
      #local A6 = A3;
      #local BottomXOffset = .012;
      #local CharacterXOffset = .32812045; //* * * WRONG, BUT NOT IMPORTANT * * *
      #declare CharacterWidth = .65667263; //* * * WRONG, BUT NOT IMPORTANT * * *
   #end //#if

   #declare Character = object {
      #local X1 = (R1 - SW2) * cos (radians (90 - A1));
      #local Y1 = (R1 - SW2) * sin (radians (90 - A1));
      #local X2 = -X1;
      #local Y2 = Y1;
      #local X3 = (R2 - StrokeWidth) * cos (radians (A2));
      #local Y3 = (R2 - StrokeWidth) * sin (radians (A2));
      #local X4 = (R3 - SW2) * cos (radians (-90 - A3));
      #local Y4 = (R3 - SW2) * sin (radians (-90 - A3));
      #local X6 = (R4 - SW2) * cos (radians (-90 - A4));
      #local Y6 = (R4 - SW2) * sin (radians (-90 - A4));
      #local X7 = -X6;
      #local Y7 = Y6;
      #local X8 = (R5 - StrokeWidth) * cos (radians (180 + A5));
      #local Y8 = (R5 - StrokeWidth) * sin (radians (180 + A5));
      #local X9 = (R6 - SW2) * cos (radians (90 - A6));
      #local Y9 = (R6 - SW2) * sin (radians (90 - A6));
      #local TopCenter = object {
         union {
            intersection {
               difference {
                  cylinder {<0, 0, 0> <0, 0, 1>, R1 - Border}
                  cylinder {<0, 0, -.1> <0, 0, 1.1>, R1 - StrokeWidth + Border}
               } //difference
               plane {x, 0 rotate -A1 * z}
               plane {x, 0 inverse rotate A1 * z}
            } //intersection
            cylinder {<0, 0, 0>, <0, 0, 1> SW2 - Border translate <X1, Y1, 0>}
            cylinder {<0, 0, 0>, <0, 0, 1> SW2 - Border translate <X2, Y2, 0>}
         } //union
      } //object
      #local TopRight = object {
         intersection {
            difference {
               cylinder {<0, 0, 0> <0, 0, 1>, R2 - Border}
               cylinder {<0, 0, -.1> <0, 0, 1.1>, R2 - StrokeWidth + Border}
            } //difference
            plane {x, 0 inverse rotate -A1 * z}
            plane {y, Border inverse rotate ClipAngle_Top * z translate <X3, Y3, 0>}
         } //intersection
      } //object
      #local TopLeft = object {
         union {
            intersection {
               difference {
                  cylinder {<0, 0, 0> <0, 0, 1>, R3 - Border}
                  cylinder {<0, 0, -.1> <0, 0, 1.1>, R3 - StrokeWidth + Border}
               } //difference
               plane {x, 0 rotate A1 * z}
               plane {x, 0 rotate -A3 * z}
            } //intersection
            cylinder {<0, 0, 0>, <0, 0, 1> SW2 - Border translate <X4, Y4, 0>}
         } //union
      } //object
      #local Top = object {
         union {
            object {TopCenter}
            #local X1A = (R2 - SW2) * cos (radians (90 - A1));
            #local Y1A = (R2 - SW2) * sin (radians (90 - A1));
            object {TopRight translate <X1 - X1A, Y1 - Y1A, 0>}
            #local X2A = (R3 - SW2) * cos (radians (90 + A1));
            #local Y2A = (R3 - SW2) * sin (radians (90 + A1));
            object {TopLeft translate <X2 - X2A, Y2 - Y2A, 0>}
         } //union
         #local TopYOffset = Height_ - R1;
         translate TopYOffset * y
         #local X4 = X4 + X2 - X2A;
         #local Y4 = Y4 + Y2 - Y2A + TopYOffset;
      } //object
      #local BottomCenter = object {
         union {
            intersection {
               difference {
                  cylinder {<0, 0, 0> <0, 0, 1>, R4 - Border}
                  cylinder {<0, 0, -.1> <0, 0, 1.1>, R4 - StrokeWidth + Border}
               } //difference
               plane {x, 0 inverse rotate -A4 * z}
               plane {x, 0 rotate A4 * z}
            } //intersection
            cylinder {<0, 0, 0>, <0, 0, 1> SW2 - Border translate <X6, Y6, 0>}
            cylinder {<0, 0, 0>, <0, 0, 1> SW2 - Border translate <X7, Y7, 0>}
         } //union
      } //object
      #local BottomLeft = object {
         intersection {
            difference {
               cylinder {<0, 0, 0> <0, 0, 1>, R5 - Border}
               cylinder {<0, 0, -.1> <0, 0, 1.1>, R5 - StrokeWidth + Border}
            } //difference
            plane {x, 0 rotate -A4 * z}
            plane {y, -Border rotate ClipAngle_Bottom * z translate <X8, Y8, 0>}
         } //intersection
      } //object
      #local BottomRight = object {
         union {
            intersection {
               difference {
                  cylinder {<0, 0, 0> <0, 0, 1>, R6 - Border}
                  cylinder {<0, 0, -.1> <0, 0, 1.1>, R6 - StrokeWidth + Border}
               } //difference
               plane {x, 0 inverse rotate A4 * z}
               plane {x, 0 inverse rotate -A6 * z}
            } //intersection
            cylinder {<0, 0, 0>, <0, 0, 1> SW2 - Border translate <X9, Y9, 0>}
         } //union
      } //object
      #local Bottom = object {
         union {
            object {BottomCenter}
            #local X6A = (R5 - SW2) * cos (radians (-90 - A4));
            #local Y6A = (R5 - SW2) * sin (radians (-90 - A4));
            object {BottomLeft translate <X6 - X6A, Y6 - Y6A, 0>}
            #local X7A = (R6 - SW2) * cos (radians (-90 + A4));
            #local Y7A = (R6 - SW2) * sin (radians (-90 + A4));
            object {BottomRight translate <X7 - X7A, Y7 - Y7A, 0>}
         } //union
         #local BottomYOffset = R4;
         translate <BottomXOffset, BottomYOffset, 0>
         #local X9 = X9 + X7 - X7A + BottomXOffset;
         #local Y9 = Y9 + Y7 - Y7A + BottomYOffset;
      } //object
      #local Bar = object {
         #local DX = X9 - X4;
         #local DY = Y9 - Y4;
         #local D = sqrt (DX * DX + DY * DY);
         #local A = degrees (asin (DX / D));
         box {<0, -SW2 + Border, 0> <D, SW2 - Border, 1> rotate (-90 + A) * z translate <X4, Y4, 0>}
      } //object
      union {
         object {Top}
         object {Bottom}
         object {Bar}
      } //union
      translate -BottomXOffset * x
      rotate -RotationAmount * z
      translate CharacterXOffset * x
   } //object

#end //#macro MakeGenericS

#macro MakeGenericV (Border, Height, Angle)

   #local Height_ = Height;
   #local Angle_ = Angle;

   #declare Character = object {
      #local Cutout = object {
         intersection {
            box {<-.5, 0, -.1> <.5, Height_ + .1, 1.1>}
            plane {y, SW2 - Border inverse rotate -Angle_ * z}
            plane {y, SW2 - Border inverse rotate Angle_ * z}
         } //intersection
      } //object
      difference {
         intersection {
            box {<-.6, Border, 0> <.6, Height_ - Border, 1>}
            plane {y, -SW2 + Border inverse rotate -Angle_ * z}
            plane {y, -SW2 + Border inverse rotate Angle_ * z}
         } //intersection
         object {Cutout}
      } //difference
      #local W = SW2 / sin (radians (Angle_));
      #local W = W + Height_ / tan (radians (Angle_));
      translate W * x
   } //object

   #declare CharacterWidth = W * 2;

#end //#macro MakeGenericV

#macro MakeGenericW (Border, Height, Angle)

   #local Height_ = Height;
   #local Angle_ = Angle;

   #declare Character = object {
      #local W1 = SW2 / sin (radians (Angle_));
      #local W2 = Height_ / sin (radians (Angle_)) * sin (radians (90 - Angle_));
      #local X1 = -W1 + W2;
      #local X2 = X1 + W1 * 2;
      #local Cutout_Top = object {
         intersection {
            box {<-.5, 0, -.1> <.5, Height_ + .1, 1.1>}
            plane {y, SW2 - Border inverse rotate -Angle_ * z}
            plane {y, SW2 - Border inverse rotate Angle_ * z}
         } //intersection
      } //object
      #local Cutout_Bottom = object {
         intersection {
            box {<-.5, -.1, -.1> <.5, Height_, 1.1>}
            plane {y, -SW2 + Border rotate -Angle_ * z translate Height_ * y}
            plane {y, -SW2 + Border rotate Angle_ * z translate Height_ * y}
         } //intersection
      } //object
      difference {
         intersection {
            box {<-.9, Border, 0> <.9, Height_ - Border, 1>}
            plane {y, Border inverse rotate -Angle_ * z translate -X2 * x}
            plane {y, Border inverse rotate Angle_ * z translate X2 * x}
         } //intersection
         object {Cutout_Bottom}
         object {Cutout_Top translate (X1 + W1) * x}
         object {Cutout_Top translate (-X1 - W1) * x}
      } //difference
      #local W = X2 + W2;
      translate W * x
   } //object

   #declare CharacterWidth = W * 2;

#end //#macro MakeGenericW

#macro MakeGenericX (Border, Height, Angle)

   #local Height_ = Height;
   #local Angle_ = Angle;

   #declare Character = object {
      #local W1 = StrokeWidth / sin (radians (Angle_));
      #local W2 = Height_ / sin (radians (Angle_)) * sin (radians (90 - Angle_));
      union {
         intersection {
            box {<-.1, Border, 0> <1.1, Height_ - Border, 1>}
            plane {y, -Border rotate Angle_ * z}
            plane {y, -StrokeWidth + Border inverse rotate Angle_ * z}
         } //intersection
         intersection {
            box {<-.1, Border, 0> <1.1, Height_ - Border, 1>}
            plane {y, Border inverse rotate -Angle_ * z translate Height_ * y}
            plane {y, StrokeWidth - Border rotate -Angle_ * z translate Height_ * y}
         } //intersection
      } //union
   } //object

   #declare CharacterWidth = W2 + W1;

#end //#macro MakeGenericX

#macro MakeGenericZ (Border, Height, Width)

   #local Height_ = Height;
   #local Width_ = Width;

   #declare Character = object {
      #local XC = Width_ / 2;
      #local YC = Height_ / 2;
      #local X1 = 0;
      #local Y1 = StrokeWidth;
      #local W1 = XC - X1;
      #local H1 = YC - Y1;
      #local D = sqrt (W1 * W1 + H1 * H1);
      #local A1 = degrees (asin (H1 / D));
      #local A2 = degrees (asin (SW2 / D));
      #local Angle = A1 + A2;
      #local Cutout_Front = object {
         intersection {
            box {<-.1, 0, -.1> <Width_, Height_ - StrokeWidth + Border, 1.1>}
            plane {y, -Border inverse rotate Angle * z translate StrokeWidth * y}
         } //intersection
      } //object
      #local Cutout_Back = object {
         intersection {
            box {<0, StrokeWidth - Border, -.1> <Width_ + .1, Height_, 1.1>}
            plane {y, Border rotate Angle * z translate <Width_, Height_ - StrokeWidth, 0>}
         } //intersection
      } //object
      difference {
         box {<Border, Border, 0> <Width_ - Border, Height_ - Border, 1>}
         object {Cutout_Front}
         object {Cutout_Back}
      } //difference
   } //object

   #declare CharacterWidth = Width_;

#end //#macro MakeGenericZ

#macro MakePERIOD (Border)

   #declare Character = object {
      box {<Border, Border, 0> <StrokeWidth - Border, StrokeWidth - Border, 1>}
   } //object

   #declare CharacterWidth = StrokeWidth;

#end //#macro MakePERIOD

#macro MakeCOMMA (Border)

   MakeGenericComma (Border)

#end //#macro MakeCOMMA

#macro MakeCOLON (Border)

   #declare Character = object {
      union {
         box {<Border, Border, 0> <StrokeWidth - Border, StrokeWidth - Border, 1>}
         box {<Border, Height_Lower - StrokeWidth + Border, 0> <StrokeWidth - Border, Height_Lower - Border, 1>}
      } //union
   } //object

   #declare CharacterWidth = StrokeWidth;

#end //#macro MakeCOLON

#macro MakeSEMICOLON (Border)

   MakeGenericComma (Border)

   #declare Character = object {
      union {
         object {Character}
         box {<Border, Height_Lower - StrokeWidth + Border, 0> <StrokeWidth - Border, Height_Lower - Border, 1>}
      } //union
   } //object

#end //#macro MakeSEMICOLON

#macro MakeDASH (Border)

   #declare Character = object {
      #local Width = .42;
      #local Elevation = Height_Lower / 2 - SW2;
      box {<Border, Border, 0> <Width - Border, StrokeWidth - Border, 1>}
      translate Elevation * y
   } //object

   #declare CharacterWidth = Width;

#end //#macro MakeDASH

#macro MakeAPOSTROPHE (Border)

   #local Elevation = Height_Upper * .6;
   #local Angle = 7;

   MakeGenericQUOTE (Border, Elevation, Angle)

   #declare CharacterWidth = StrokeWidth;

#end //#macro MakeAPOSTROPHE

#macro MakeQUOTE (Border)

   #local Elevation = Height_Upper * .6;
   #local Angle = 7;

   MakeGenericQUOTE (Border, Elevation, Angle)

   #declare Character = object {
      #local D = .05;
      union {
         object {Character}
         object {Character translate (StrokeWidth + D) * x}
      } //union
   } //object

   #declare CharacterWidth = StrokeWidth * 2 + D;

#end //#macro MakeQUOTE

#macro MakeEXCLAMATION (Border)

   #local Elevation = Height_Upper * .25;
   #local Angle = 3;

   MakeGenericQUOTE (Border, Elevation, Angle)

   #declare Character = object {
      union {
         object {Character}
         box {<Border, Border, 0> <StrokeWidth - Border, StrokeWidth - Border, 1>}
      } //union
   } //object

   #declare CharacterWidth = StrokeWidth;

#end //#macro MakeEXCLAMATION

#macro MakeQUESTION (Border)

   #declare Character = object {
      #local R1 = .315;
      #local R2 = R1 * .8;
      #local CurveExtension = .075;
      #local YExtension = .1;
      #local DiagonalExtension = .1;
      #local ClipAngle = 10;
      #local X1 = (R1 - SW2) * cos (radians (45));
      #local Y1 = -(R1 - SW2) * sin (radians (45));
      #local X2 = -(R2 - SW2) * cos (radians (45));
      #local Y2 = (R2 - SW2) * sin (radians (45));
      #local X3 = DiagonalExtension / 2 * cos (radians (45));
      #local Y3 = DiagonalExtension / 2 * sin (radians (45));
      #local X4 = -X3;
      #local Y4 = -Y3;
      #local Diagonal = object {
         union {
            box {<-DiagonalExtension / 2, -SW2 + Border, 0> <DiagonalExtension / 2, SW2 - Border, 1>}
            cylinder {<-DiagonalExtension / 2, 0, 0> <-DiagonalExtension / 2, 0, 1>, SW2 - Border}
            cylinder {<DiagonalExtension / 2, 0, 0> <DiagonalExtension / 2, 0, 1>, SW2 - Border}
         } //union
         rotate 45 * z
      } //object
      #local TopCurve = object {
         union {
            difference {
               cylinder {<0, 0, 0> <0, 0, 1>, R1 - Border}
               cylinder {<0, 0, -.1> <0, 0, 1.1>, R1 - StrokeWidth + Border}
               intersection {
                  box {<-R1 - .1, -R1 - .1, -.1> <R1 + .1, 0, 1.1>}
                  plane {y, 0 rotate -45 * z}
               } //intersection
            } //difference
            intersection {
               union {
                  box {<-R1 + Border, -CurveExtension, 0> <-R1 + StrokeWidth - Border, 0, 1>}
                  cylinder {<-R1 + SW2, 0, 0> <-R1 + SW2, 0, 1>, SW2 - Border}
               } //union
               plane {y, Border inverse rotate -ClipAngle * z translate <-R1 + StrokeWidth, -CurveExtension, 0>}
            } //intersection
         } //union
      } //object
      #local BottomCurve = object {
         union {
            intersection {
               difference {
                  cylinder {<0, 0, 0> <0, 0, 1>, R2 - Border}
                  cylinder {<0, 0, -.1> <0, 0, 1.1>, R2 - StrokeWidth + Border}
               } //difference
               plane {y, 0 rotate -45 * z}
               plane {y, 0 inverse}
            } //intersection
            cylinder {<-R2 + SW2, 0, 0> <-R2 + SW2, 0, 1>, SW2 - Border}
            box {<-R2 + Border, -YExtension + Border, 0> <-R2 + StrokeWidth - Border, 0, 1>}
         } //union
      } //object
      #local TopPart = object {
         union {
            object {TopCurve}
            object {Diagonal translate <X1 - X3, Y1 - Y3, 0>}
            #local X4 = X4 + X1 - X3;
            #local Y4 = Y4 + Y1 - Y3;
            object {BottomCurve translate <X4 - X2, Y4 - Y2, 0>}
         } //union
         translate <R1, Height_Upper - R1, 0>
      } //object
      union {
         object {TopPart}
         box {<Border, Border, 0> <StrokeWidth - Border, StrokeWidth - Border, 1> translate (-R2 + X4 - X2 + R1) * x}
      } //union
   } //object

   #declare CharacterWidth = R1 * 2;

#end //#macro MakeQUESTION

#macro MakeSLASH (Border)

   #declare Character = object {
      #local Angle = 74;
      #local W2 = Height_Upper / sin (radians (Angle)) * sin (radians (90 - Angle));
      #local W1 = StrokeWidth / sin (radians (Angle));
      intersection {
         box {<-1, Border, 0> <Height_Upper * .6, Height_Upper - Border, 1>}
         plane {y, -Border rotate Angle * z}
         plane {y, -StrokeWidth + Border inverse rotate Angle * z}
      } //intersection
   } //object

   #declare CharacterWidth = W2 + W1;

#end //#macro MakeSLASH

#macro MakePARENTHESIS_LEFT (Border)

   #declare Character = object {
      #local R1 = Height_Upper * 1.2;
      #local R2 = R1 * 1.24;
      #local Height = Height_Upper + Height_Lower / 2 * .95;
      intersection {
         difference {
            cylinder {<0, 0, 0> <0, 0, 1>, R1 - Border}
            cylinder {<0, 0, -.1> <0, 0, 1.1>, R2 + Border translate (R2 - R1 + StrokeWidth) * x}
         } //difference
         plane {x, 0}
         plane {y, -Height / 2 + Border inverse}
         plane {y, Height / 2 - Border}
      } //intersection
      translate <R1, Height / 2 - Height_Lower / 2 * .95, 0>
   } //object

   #declare CharacterWidth = R2 * .24; //* * * WRONG, BUT NOT IMPORTANT * * *

#end //#macro MakePARENTHESIS_LEFT

#macro MakePARENTHESIS_RIGHT (Border)

   #declare Character = object {
      #local R1 = Height_Upper * 1.2;
      #local R2 = R1 * 1.24;
      #local Height = Height_Upper + Height_Lower / 2 * .95;
      intersection {
         difference {
            cylinder {<0, 0, 0> <0, 0, 1>, R1 - Border}
            cylinder {<0, 0, -.1> <0, 0, 1.1>, R2 + Border translate -(R2 - R1 + StrokeWidth) * x}
         } //difference
         plane {x, 0 inverse}
         plane {y, -Height / 2 + Border inverse}
         plane {y, Height / 2 - Border}
      } //intersection
      translate <-R1 + R2 * .24, Height / 2 - Height_Lower / 2 * .95, 0> //* * * WRONG, BUT NOT IMPORTANT * * *
   } //object

   #declare CharacterWidth = R2 * .24; //* * * WRONG, BUT NOT IMPORTANT * * *

#end //#macro MakePARENTHESIS_RIGHT

#macro MakeBRACKET_LEFT (Border)

   #declare Character = object {
      #local Width = .4;
      #local Y1 = -.75 / 2 * .95;
      difference {
         box {<Border, Y1 + Border, 0> <Width - Border, Height_Upper - Border, 1>}
         box {<StrokeWidth - Border, Y1 + StrokeWidth - Border, -.1> <Width + .1, Height_Upper - StrokeWidth + Border, 1.1>}
      } //difference
   } //object

   #declare CharacterWidth = Width;

#end //#macro MakeBRACKET_LEFT

#macro MakeBRACKET_RIGHT (Border)

   #declare Character = object {
      #local Width = .4;
      #local Y1 = -.75 / 2 * .95;
      difference {
         box {<Border, Y1 + Border, 0> <Width - Border, Height_Upper - Border, 1>}
         box {<-.1, Y1 + StrokeWidth - Border, -.1> <Width - StrokeWidth + Border, Height_Upper - StrokeWidth + Border, 1.1>}
      } //difference
   } //object

   #declare CharacterWidth = Width;

#end //#macro MakeBRACKET_RIGHT

#macro MakePLUS (Border)

   #declare Character = object {
      #local Width = .6;
      #local W2 = Width / 2;
      difference {
         box {<Border, Border, 0> <Width - Border, Width - Border, 1>}
         box {<-.1, -.1, -.1> <W2 - SW2 + Border, W2 - SW2 + Border, 1.1>}
         box {<-.1, W2 + SW2 - Border, -.1> <W2 - SW2 + Border, Width + .1, 1.1>}
         box {<W2 + SW2 - Border, W2 + SW2 - Border, -.1> <Width + .1, Width + .1, 1.1>}
         box {<W2 + SW2 - Border, -.1, -.1> <Width + .1, W2 - SW2 + Border, 1.1>}
      } //difference
      translate (Height_Upper / 2 - W2) * y
   } //object

   #declare CharacterWidth = Width;

#end //#macro MakePLUS

#macro MakeEQUAL (Border)

   #declare Character = object {
      #local Width = .56;
      #local YDistance = StrokeWidth * 2/3;
      #local Height = StrokeWidth * 2 + YDistance;
      #local Elevation = Height_Upper / 2 - Height / 2;
      #local Bar = object {
         box {<Border, Border, 0> <Width - Border, StrokeWidth - Border, 1>}
      } //object
      union {
         object {Bar}
         object {Bar translate (StrokeWidth + YDistance) * y}
      } //union
      translate Elevation * y
   } //object

   #declare CharacterWidth = Width;

#end //#macro MakeEQUAL

#macro MakePERCENT (Border)

   #local R = Height_Lower * .29;
   #local Height = Height_Lower * 2/3;
   #local TempSW = StrokeWidth * .75;

   MakeGenericDigit_0 (Border, R, Height, TempSW)

   #declare Character = object {
      #local Angle = 62;
      #local XOffset = .14;
      #local W2 = Height_Upper / sin (radians (Angle)) * sin (radians (90 - Angle));
      #local W1 = StrokeWidth / sin (radians (Angle));
      union {
         object {Character translate <-XOffset, Height_Upper - Height, 0>}
         object {Character translate <W2 + W1 - R * 2 + XOffset, 0, 0>}
         intersection {
            box {<-1, Border, 0> <Height_Upper * .9, Height_Upper - Border, 1>}
            plane {y, -Border rotate Angle * z}
            plane {y, -StrokeWidth + Border inverse rotate Angle * z}
         } //intersection
      } //union
      translate XOffset * x
   } //object

   #declare CharacterWidth = W2 + W1 + XOffset * 2;

#end //#macro MakePERCENT

#macro MakeNUMBER (Border)

   #declare Character = object {
      #local Height = Height_Upper;
      #local Width = Height * .86;
      #local Angle = 78.4;
      #local XOffset = Width * 1/3;
      #local YOffset = Height * 1/3;
      #local Bar_Horizontal = object {
         box {<Border, -SW2 + Border, 0> <Width - Border, SW2 - Border, 1>}
      } //object
      #local Bar_Diagonal = object {
         intersection {
            box {<-1, Border, 0> <1, Height - Border, 1>}
            plane {y, SW2 - Border rotate Angle * z translate (Height / 2) * y}
            plane {y, -SW2 + Border inverse rotate Angle * z translate (Height / 2) * y}
         } //intersection
      } //object
      union {
         object {Bar_Horizontal translate YOffset * y}
         object {Bar_Horizontal translate (Height - YOffset) * y}
         object {Bar_Diagonal translate XOffset * x}
         object {Bar_Diagonal translate (Width - XOffset) * x}
      } //union
   } //object

   #declare CharacterWidth = Width;

#end //#macro MakeNUMBER

#macro MakeASTERISK (Border)

   #declare Character = object {
      #local R = Height_Lower / 2 * .8;
      #local R2 = R * .5;
      #local R3 = R2 * .75;
      #local ClipAngle = 10;
      #local NSides = 5;
      #local DeltaTheta = int (360 / NSides + .5);
      #local CutoutSide_Right = object {
         intersection {
            box {<-.1, -.1, -.2> <R + .2, R + .2, 1.2>}
            plane {x, Border inverse rotate (-DeltaTheta / 2) * z translate R2 * y}
            plane {x, Border inverse rotate (-DeltaTheta / 2 + ClipAngle) * z translate R3 * y}
         } //intersection
      } //object
      #local CutoutSide_Left = object {
         intersection {
            box {<-R - .2, -.1, -.3> <.1, R + .2, 1.3>}
            plane {x, -Border rotate (DeltaTheta / 2) * z translate R2 * y}
            plane {x, -Border rotate (DeltaTheta / 2 - ClipAngle) * z translate R3 * y}
         } //intersection
      } //object
      #local Cutout = object {
         difference {
            box {<-R - .1, 0, -.1> <R + .1, R + .1, 1.1>}
            object {CutoutSide_Right}
            object {CutoutSide_Left}
         } //difference
      } //object
      #local Center = object {
         intersection {
            box {<-R - .1, -R - .1, 0> <R + .1, R + .1, 1>}
            #for (Angle, 0, 360 - DeltaTheta, DeltaTheta)
               plane {y, R - Border rotate -Angle * z}
            #end //#for
         } //intersection
      } //object
      difference {
         object {Center}
         #for (Angle, 0, 360 - DeltaTheta, DeltaTheta)
            object {Cutout rotate (-Angle + DeltaTheta / 2) * z}
         #end //#for
      } //difference
      translate <R * 1.041, Height_Upper - R + .075, 0> //* * * WRONG, BUT NOT IMPORTANT * * *
   } //object

   #declare CharacterWidth = R * 1.041 * 2; //* * * WRONG, BUT NOT IMPORTANT * * *

#end //#macro MakeASTERISK

#macro MakeHEART (Border)

   #declare Character = object {
      #local R = .26;
      #local D = R * .82;
      #local StartAngle = 20;
      #local X1 = R;
      #local Y1 = 0;
      #local DY = Y1 - (-Height_Upper + R);
      #local DX = D + X1;
      #local BottomAngle = degrees (atan (DY / DX));
      #local Base = object {
         intersection {
            union {
               cylinder {<-D, 0, 0> <-D, 0, 1>, R - Border}
               cylinder {<D, 0, 0> <D, 0, 1>, R - Border}
               box {<-D - R + Border, -Height_Upper + R, 0> <D + R - Border, 0, 1>}
            } //union
            plane {y, Border inverse rotate BottomAngle * z translate <D + X1, Y1, 0>}
            plane {y, Border inverse rotate -BottomAngle * z translate <-D - X1, Y1, 0>}
         } //intersection
      } //object
      #local XC = D;
      #local YC = 0;
      #local CurAngle = StartAngle;
      #local CurR = R;
      #local NSections = 12;
      #local DeltaTheta = (90 - StartAngle) / NSections;
      #local RMultiplier = 1.144781;
      #local MaxWidth = 0;
      #local Section = object {
         union {
            #for (I, 0, NSections - 1)
               #local X1 = XC + CurR * cos (radians (CurAngle));
               #local Y1 = YC + CurR * sin (radians (CurAngle));
               #local CurR = CurR * RMultiplier;
               #local XC = X1 + CurR * cos (radians (CurAngle + 180));
               #local YC = Y1 + CurR * sin (radians (CurAngle + 180));
               intersection {
                  cylinder {<XC, YC, 0> <XC, YC, 1>, CurR - Border}
                  plane {y, 0 rotate CurAngle * z translate <XC, YC, 0>}
               } //intersection
               #local CurWidth = XC + CurR * cos (radians (CurAngle));
               #local MaxWidth = max (MaxWidth, CurWidth);
               #local CurAngle = CurAngle - DeltaTheta;
            #end //#for
         } //union
      } //object
      #local Section = object {
         intersection {
            object {Section}
            plane {x, 0 inverse rotate 1 * z translate <0, -Height_Upper + R + Border, 0>}
         } //intersection
      } //object
      union {
         object {Base}
         object {Section}
         object {Section rotate 180 * y translate 1 * z}
      } //union
      translate <MaxWidth, Height_Upper - R, 0>
      bounded_by {
         box {<-.01, -.01, -.01> <MaxWidth * 2 + .01, Height_Upper + .01, 1.01>}
      } //bounded_by
   } //object

   #declare CharacterWidth = MaxWidth * 2;

#end //#macro MakeHEART

#macro MakeDigit_0 (Border)

   #local R = Height_Lower * .44;
   #local Height = Height_Upper;

   MakeGenericDigit_0 (Border, R, Height, StrokeWidth)

   #declare CharacterWidth = R * 2;

#end //#macro MakeDigit_0

#macro MakeDigit_1 (Border)

   #declare Character = object {
      #local Width = Height_Upper * .43;
      #local R = .8;
      #local XC = -.36;
      #local YC = Height_Upper + R - .34;
      difference {
         box {<Border, Border, 0> <Width - Border, Height_Upper - Border, 1>}
         cylinder {<XC, YC, -.2> <XC, YC, 1.2>, R + Border}
         difference {
            box {<-.1, -.1, -.1> <Width - StrokeWidth + Border, Height_Upper + .1, 1.1>}
            cylinder {<XC, YC, -.2> <XC, YC, 1.2>, R + StrokeWidth * .85 - Border}
         } //difference
      } //difference
   } //object

   #declare CharacterWidth = Width;

#end //#macro MakeDigit_1

#macro MakeDigit_2 (Border)

   #declare Character = object {
      #local R1 = .32;
      #local R2 = R1 * .8;
      #local Angle = 40;
      #local CurveExtension = .075;
      #local YExtension = .2;
      #local DiagonalExtension = .5;
      #local ClipAngle = 10;
      #local BottomWidth = R1 * 1.475; //* * * WRONG, BUT NOT IMPORTANT * * *
      #local X1 = (R1 - SW2) * cos (radians (Angle));
      #local Y1 = -(R1 - SW2) * sin (radians (Angle));
      #local X2 = -(R2 - SW2) * cos (radians (Angle));
      #local Y2 = (R2 - SW2) * sin (radians (Angle));
      #local X3 = DiagonalExtension / 2 * cos (radians (Angle));
      #local Y3 = DiagonalExtension / 2 * sin (radians (Angle));
      #local X4 = -X3;
      #local Y4 = -Y3;
      #local Diagonal = object {
         union {
            box {<-DiagonalExtension / 2, -SW2 + Border, 0> <DiagonalExtension / 2, SW2 - Border, 1>}
            cylinder {<-DiagonalExtension / 2, 0, 0> <-DiagonalExtension / 2, 0, 1>, SW2 - Border}
            cylinder {<DiagonalExtension / 2, 0, 0> <DiagonalExtension / 2, 0, 1>, SW2 - Border}
         } //union
         rotate Angle * z
      } //object
      #local TopCurve = object {
         union {
            difference {
               cylinder {<0, 0, 0> <0, 0, 1>, R1 - Border}
               cylinder {<0, 0, -.1> <0, 0, 1.1>, R1 - StrokeWidth + Border}
               intersection {
                  box {<-R1 - .1, -R1 - .1, -.1> <R1 + .1, 0, 1.1>}
                  plane {y, 0 rotate -Angle * z}
               } //intersection
            } //difference
            intersection {
               union {
                  box {<-R1 + Border, -CurveExtension, 0> <-R1 + StrokeWidth - Border, 0, 1>}
                  cylinder {<-R1 + SW2, 0, 0> <-R1 + SW2, 0, 1>, SW2 - Border}
               } //union
               plane {y, Border inverse rotate -ClipAngle * z translate <-R1 + StrokeWidth, -CurveExtension, 0>}
            } //intersection
         } //union
      } //object
      #local BottomCurve = object {
         union {
            intersection {
               difference {
                  cylinder {<0, 0, 0> <0, 0, 1>, R2 - Border}
                  cylinder {<0, 0, -.1> <0, 0, 1.1>, R2 - StrokeWidth + Border}
               } //difference
               plane {y, 0 rotate -Angle * z}
               plane {y, 0 inverse}
            } //intersection
            cylinder {<-R2 + SW2, 0, 0> <-R2 + SW2, 0, 1>, SW2 - Border}
            box {<-R2 + Border, -YExtension, 0> <-R2 + StrokeWidth - Border, 0, 1>}
         } //union
      } //object
      #local TopPart = object {
         union {
            object {TopCurve}
            object {Diagonal translate <X1 - X3, Y1 - Y3, 0>}
            #local X4 = X4 + X1 - X3;
            #local Y4 = Y4 + Y1 - Y3;
            object {BottomCurve translate <X4 - X2, Y4 - Y2, 0>}
         } //union
         translate <R1, Height_Upper - R1, 0>
      } //object
      intersection {
         union {
            object {TopPart}
            box {<-SW2, -.1, 0> <BottomWidth - Border, StrokeWidth - Border, 1> translate (StrokeWidth - R2 + X4 - X2 + R1) * x}
         } //union
         plane {y, Border inverse}
      } //intersection
      translate .02715927 * x //* * * WRONG, BUT NOT IMPORTANT * * *
   } //object

   #declare CharacterWidth = R1 * 2 + .02715927; //* * * WRONG, BUT NOT IMPORTANT * * *

#end //#macro MakeDigit_2

#macro MakeDigit_3 (Border)

   #declare Character = object {
      #local R1 = .185 + SW2;
      #local R2 = (Height_Upper - R1 * 2) / 2 + SW2;
      #local XExtension = .1;
      #local ClipAngle = 10;
      #local XC1 = 0;
      #local YC1 = Height_Upper - R1;
      #local XC2 = 0;
      #local YC2 = R2;
      union {
         union {
            difference {
               cylinder {<0, YC1, 0> <0, YC1, 1>, R1 - Border}
               cylinder {<0, YC1, -.1> <0, YC1, 1.1>, R1 - StrokeWidth + Border}
               intersection {
                  box {<-R1 - .1, YC1 - R1 - .1, -.2> <0, YC1 + R1 + .1, 1.2>}
                  plane {y, Border rotate -ClipAngle * z translate (YC1 - .04) * y}
               } //intersection
            } //difference
            difference {
               cylinder {<0, YC2, 0> <0, YC2, 1>, R2 - Border}
               cylinder {<0, YC2, -.1> <0, YC2, 1.1>, R2 - StrokeWidth + Border}
               intersection {
                  box {<-R2 - .1, YC2 - R2 - .1, -.2> <0, YC2 + R2 + .1, 1.2>}
                  plane {y, -Border inverse rotate ClipAngle * z translate (YC2 + .04) * y}
               } //intersection
            } //difference
         } //union
         intersection {
            union {
               cylinder {<0, YC1 - R1 + SW2, 0> <0, YC1 - R1 + SW2, 1>, SW2 - Border}
               box {<-XExtension, YC1 - R1 + Border, 0> <0, YC1 - R1 + StrokeWidth - Border, 1>}
            } //union
            plane {x, Border inverse rotate -ClipAngle * z translate <-XExtension, YC1 - R1, 0>}
         } //intersection
      } //union
      translate R2 * x
   } //object

   #declare CharacterWidth = R2 * 2;

#end //#macro MakeDigit_3

#macro MakeDigit_4 (Border)

   #declare Character = object {
      #local Width = Height_Upper * .7;
      #local XExtension = StrokeWidth * .8;
      #local Y1 = Height_Upper * .24;
      #local Y2 = Y1 + StrokeWidth;
      #local Angle = 55;
      intersection {
         difference {
            box {<Border, Border, 0> <Width - Border, Height_Upper - Border, 1>}
            box {<-.1, -.1, -.1> <Width - XExtension - StrokeWidth + Border, Y1 + Border, 1.1>}
            box {<Width - XExtension - Border, -.1, -.1> <Width + .1, Y1 + Border, 1.1>}
            box {<Width - XExtension - Border, Y2 - Border, -.1> <Width + .1, Height_Upper + .1, 1.1>}
            intersection {
               box {<-.1, Y2 - Border, -.1> <Width - XExtension - StrokeWidth + Border, Height_Upper + .1, 1.1>}
               plane {y, -StrokeWidth + Border rotate Angle * z translate Y2 * y}
            } //intersection
         } //difference
         plane {y, -Border rotate Angle * z translate Y2 * y}
      } //intersection
   } //object

   #declare CharacterWidth = Width;

#end //#macro MakeDigit_4

#macro MakeDigit_5 (Border)

   #declare Character = object {
      #local R = Height_Lower * .46;
      #local Angle = 11;
      #local ClipAngle = 10;
      #local X1 = -.14;
      #local TopPart = object {
         intersection {
            union {
               box {<-R + Border, 0, 0> <-R + StrokeWidth - Border, Height_Upper - R + .1, 1> rotate -Angle * z}
               box {<X1, Height_Upper - R - StrokeWidth + Border, 0> <R - .08 - Border, Height_Upper - R + .1, 1>}
            } //union
            plane {y, Height_Upper - R - Border}
         } //intersection
      } //object
      #local BottomPart = object {
         difference {
            cylinder {<0, 0, 0> <0, 0, 1>, R - Border}
            cylinder {<0, 0, -.1> <0, 0, 1.1>, R - StrokeWidth + Border}
         } //difference
      } //object
      difference {
         union {
            object {TopPart}
            object {BottomPart}
         } //union
         intersection {
            box {<-R - .1, -R - .1, -.2> <0, R + .1, 1.2>}
            plane {y, -Border inverse rotate ClipAngle * z}
            plane {y, Border rotate -ClipAngle * z translate .07 * y}
         } //intersection
      } //difference
      translate <R * cos (radians (ClipAngle)), R, 0>
   } //object

   #declare CharacterWidth = R + R * cos (radians (ClipAngle));

#end //#macro MakeDigit_5

#macro MakeDigit_6 (Border)

   #local Spin = false;

   MakeGenericDigit_69 (Border, Spin)

#end //#macro MakeDigit_6

#macro MakeDigit_7 (Border)

   #declare Character = object {
      #local Width = Height_Upper * 2/3;
      #local R = 1.8;
      #local XC = Width + 1.47;
      #local YC = -.2;
      difference {
         box {<Border, Border, 0> <Width - Border, Height_Upper - Border, 1>}
         cylinder {<XC, YC, -.2> <XC, YC, 1.2>, R + Border}
         difference {
            box {<-.1, -.1, -.1> <Width + .1, Height_Upper - StrokeWidth + Border, 1.1>}
            cylinder {<XC, YC, -.2> <XC, YC, 1.2>, R + StrokeWidth - Border}
         } //difference
      } //difference
   } //object

   #declare CharacterWidth = Width;

#end //#macro MakeDigit_7

#macro MakeDigit_8 (Border)

   #declare Character = object {
      #local R1 = .185 + SW2;
      #local R2 = (Height_Upper - R1 * 2) / 2 + SW2;
      union {
         difference {
            cylinder {<R2, Height_Upper - R1, 0> <R2, Height_Upper - R1, 1>, R1 - Border}
            cylinder {<R2, Height_Upper - R1, -.1> <R2, Height_Upper - R1, 1.1>, R1 - StrokeWidth + Border}
         } //difference
         difference {
            cylinder {<R2, R2, 0> <R2, R2, 1>, R2 - Border}
            cylinder {<R2, R2, -.1> <R2, R2, 1.1>, R2 - StrokeWidth + Border}
         } //difference
      } //union
   } //object

   #declare CharacterWidth = R2 * 2;

#end //#macro MakeDigit_8

#macro MakeDigit_9 (Border)

   #local Spin = true;

   MakeGenericDigit_69 (Border, Spin)

#end //#macro MakeDigit_9

#macro MakeA1 (Border)

   #declare Character = object {
      #local Angle = 70;
      #local W = SW2 / sin (radians (Angle));
      #local W = W + Height_Upper / tan (radians (Angle));
      #local CrossbarHeight = Height_Upper * .24;
      #local Cutout = object {
         intersection {
            box {<-.5, 0, -.1> <.5, Height_Upper + .1, 1.1>}
            plane {y, SW2 - Border inverse rotate -Angle * z}
            plane {y, SW2 - Border inverse rotate Angle * z}
         } //intersection
      } //object
      union {
         difference {
            intersection {
               box {<-.6, Border, 0> <.6, Height_Upper - Border, 1>}
               plane {y, -SW2 + Border inverse rotate -Angle * z}
               plane {y, -SW2 + Border inverse rotate Angle * z}
            } //intersection
            object {Cutout}
            rotate 180 * z
            translate Height_Upper * y
         } //difference
         intersection {
            box {<-W, CrossbarHeight + Border, 0> <W, CrossbarHeight + StrokeWidth - Border, 1>}
            plane {y, 0 rotate Angle * z translate (-W + SW2) * x}
            plane {y, 0 rotate -Angle * z translate (W - SW2) * x}
         } //intersection
      } //union
      translate W * x
   } //object

   #declare CharacterWidth = W * 2;

#end //#macro MakeA1

#macro MakeB1 (Border)

   #declare Character = object {
      #local Width = .38;
      #local BarHeight = Height_Upper * .54;
      union {
         difference {
            box {<Border, Border, 0> <Width, Height_Upper - Border, 1>}
            box {<StrokeWidth - Border, StrokeWidth - Border, -.1> <Width + .1, BarHeight - SW2 + Border, 1.1>}
            box {<StrokeWidth - Border, Height_Upper - StrokeWidth + Border, -.1> <Width + .1, BarHeight + SW2 - Border, 1.1>}
         } //difference
         cylinder {<Width, SW2, 0> <Width, SW2, 1>, SW2 - Border}
         cylinder {<Width, BarHeight, 0> <Width, BarHeight, 1>, SW2 - Border}
         cylinder {<Width, Height_Upper - SW2, 0> <Width, Height_Upper - SW2, 1>, SW2 - Border}
         #local Y1 = (BarHeight + SW2) / 2;
         #local Y2 = (Height_Upper + (BarHeight - SW2)) / 2;
         #local R1 = Y1;
         #local R2 = Height_Upper - Y2;
         #local Bulge1 = object {
            intersection {
               difference {
                  cylinder {<Width, Y1, 0> <Width, Y1, 1>, R1 - Border}
                  cylinder {<Width, Y1, -.1> <Width, Y1, 1.1>, R1 - StrokeWidth + Border}
               } //difference
               plane {x, Width inverse}
            } //intersection
         } //object
         #local Bulge2 = object {
            intersection {
               difference {
                  cylinder {<Width, Y2, 0> <Width, Y2, 1>, R2 - Border}
                  cylinder {<Width, Y2, -.1> <Width, Y2, 1.1>, R2 - StrokeWidth + Border}
               } //difference
               plane {x, Width inverse}
            } //intersection
         } //object
         object {Bulge1}
         object {Bulge2}
      } //union
   } //object

   #declare CharacterWidth = Width + R1;

#end //#macro MakeB1

#macro MakeC1 (Border)

   #declare Character = object {
      #local R = Height_Upper / 2;
      #local ClipAngle1_Top = 32; //The angle (from the center) that the clipping will begin; the clipping plane will be tranlated here
      #local ClipAngle1_Bottom = 26; //The angle (from the center) that the clipping will begin; the clipping plane will be tranlated here
      #local ClipAngle2 = 20; //The angle that the ends will be clipped at
      #local WidthFactor = .91;
      difference {
         cylinder {<0, 0, 0> <0, 0, 1>, 1 scale <R * WidthFactor - Border, R - Border, 1>}
         cylinder {<0, 0, -.1> <0, 0, 1.1>, 1 scale <R * WidthFactor - StrokeWidth + Border, R - StrokeWidth + Border, 1>}
         #local ClipX_Top = R * WidthFactor * cos (radians (ClipAngle1_Top));
         #local ClipX_Bottom = R * WidthFactor * cos (radians (ClipAngle1_Bottom));
         #local ClipY_Top = R * sin (radians (ClipAngle1_Top));
         #local ClipY_Bottom = R * sin (radians (ClipAngle1_Bottom));
         intersection {
            box {<0, -R, -.2> <R + .1, R, 1.2>}
            plane {y, Border rotate ClipAngle2 * z translate <ClipX_Top, ClipY_Top, 0>}
            plane {y, -Border inverse rotate -ClipAngle2 * z translate <ClipX_Bottom, -ClipY_Bottom, 0>}
         } //intersection
      } //difference
      translate <R * WidthFactor, R, 0>
   } //object

   #declare CharacterWidth = R * WidthFactor + ClipX_Bottom;

#end //#macro MakeC1

#macro MakeD1 (Border)

   #declare Character = object {
      #local Width = .35;
      #local R = Height_Upper / 2;
      #local WidthFactor = .94;
      union {
         difference {
            box {<Border, Border, 0> <Width, Height_Upper - Border, 1>}
            box {<StrokeWidth - Border, StrokeWidth - Border, -.1> <Width + .1, Height_Upper - StrokeWidth + Border, 1.1>}
         } //difference
         cylinder {<Width, SW2, 0> <Width, SW2, 1>, SW2 - Border}
         cylinder {<Width, Height_Upper - SW2, 0> <Width, Height_Upper - SW2, 1>, SW2 - Border}
         #local Bulge = object {
            intersection {
               difference {
                  cylinder {<0, 0, 0> <0, 0, 1>, 1 scale <R * WidthFactor - Border, R - Border, 1>}
                  cylinder {<0, 0, -.1> <0, 0, 1.1>, 1 scale <R * WidthFactor - StrokeWidth + Border, R - StrokeWidth + Border, 1>}
                  translate <Width, Height_Upper / 2, 0>
               } //difference
               plane {x, Width inverse}
            } //intersection
         } //object
         object {Bulge}
      } //union
   } //object

   #declare CharacterWidth = Width + R * WidthFactor;

#end //#macro MakeD1

#macro MakeE1 (Border)

   #declare Character = object {
      #local Width = .68;
      #local ShortenAmount = .03;
      #local BarHeight = Height_Upper * .52;
      difference {
         box {<Border, Border, 0> <Width - Border, Height_Upper - Border, 1>}
         box {<StrokeWidth - Border, StrokeWidth - Border, -.1> <Width + .1, BarHeight - SW2 + Border, 1.1>}
         box {<StrokeWidth - Border, Height_Upper - StrokeWidth + Border, -.1> <Width + .1, BarHeight + SW2 - Border, 1.1>}
         box {<Width - ShortenAmount - Border, BarHeight - SW2 - .1, -.2> <Width + .2, BarHeight + SW2 + .1, 1.2>}
      } //difference
   } //object

   #declare CharacterWidth = Width;

#end //#macro MakeE1

#macro MakeF1 (Border)

   #declare Character = object {
      #local Width = .64;
      #local ShortenAmount = .08;
      #local BarHeight = Height_Upper * .52;
      difference {
         box {<Border, Border, 0> <Width - Border, Height_Upper - Border, 1>}
         box {<StrokeWidth - Border, -.1, -.1> <Width + .1, BarHeight - SW2 + Border, 1.1>}
         box {<StrokeWidth - Border, Height_Upper - StrokeWidth + Border, -.1> <Width + .1, BarHeight + SW2 - Border, 1.1>}
         box {<Width - ShortenAmount - Border, BarHeight - SW2 - .1, -.2> <Width + .2, BarHeight + SW2 + .1, 1.2>}
      } //difference
   } //object

   #declare CharacterWidth = Width;

#end //#macro MakeF1

#macro MakeG1 (Border)

   #declare Character = object {
      #local R1 = Height_Upper / 2;
      #local R2 = R1 * 1.13;
      #local ClipAngle1 = 40;
      #local ClipAngle2 = 45;
      #local X2 = R2 * cos (radians (90 - ClipAngle2));
      #local Y2 = -R2 * sin (radians (90 - ClipAngle2)) + R2 - R1;
      #local HookWidth = StrokeWidth + .24;
      #local HookHeight = StrokeWidth + .2;
      #local Hook = object {
         difference {
            box {<-HookWidth + Border, 0, 0> <-Border, HookHeight - Border, 1>}
            box {<-HookWidth - .1, -.1, -.1> <-StrokeWidth + Border, HookHeight - StrokeWidth + Border, 1.1>}
         } //difference
      } //object
      union {
         difference {
            cylinder {<0, 0, 0> <0, 0, 1>, R1 - Border}
            cylinder {<0, 0, -.1> <0, 0, 1.1>, R1 - StrokeWidth + Border}
            intersection {
               box {<0, -R1 - .1, -.2> <R1 + .1, Height_Upper, 1.2>}
               plane {y, Border rotate ClipAngle1 * z}
            } //intersection
         } //difference
         cylinder {<0, -R1 + SW2, 0> <0, -R1 + SW2, 1>, SW2 - Border}
         intersection {
            difference {
               cylinder {<0, 0, 0> <0, 0, 1>, R2 - Border}
               cylinder {<0, 0, -.1> <0, 0, 1.1>, R2 - StrokeWidth + Border}
            } //difference
            plane {x, 0 inverse}
            plane {x, -Border rotate ClipAngle2 * z}
            translate (R2 - R1) * y
         } //intersection
         intersection {
            object {Hook translate <X2, Y2, 0>}
            cylinder {<0, 0, -.2> <0, 0, 1.2>, R2 - Border translate (R2 - R1) * y}
         } //intersection
      } //union
      translate <R1, R1, 0>
   } //object

   #declare CharacterWidth = R1 + R2 * cos (radians (90 - ClipAngle2));

#end //#macro MakeG1

#macro MakeH1 (Border)

   #declare Character = object {
      #local Width = .76;
      #local BarHeight = Height_Upper * .52;
      difference {
         box {<Border, Border, 0> <Width - Border, Height_Upper - Border, 1>}
         box {<StrokeWidth - Border, -.1, -.1> <Width - StrokeWidth + Border, BarHeight - SW2 + Border, 1.1>}
         box {<StrokeWidth - Border, BarHeight + SW2 - Border, -.1> <Width - StrokeWidth + Border, Height_Upper + .1, 1.1>}
      } //difference
   } //object

   #declare CharacterWidth = Width;

#end //#macro MakeH1

#macro MakeI1 (Border)

   #declare Character = object {
      box {<Border, Border, 0> <StrokeWidth - Border, Height_Upper - Border, 1>}
   } //object

   #declare CharacterWidth = StrokeWidth;

#end //#macro MakeI1

#macro MakeJ1 (Border)

   #declare Character = object {
      #local R = .32;
      #local ClipAngle = 10;
      #local Hook = object {
         difference {
            union {
               box {<-R + Border, 0, 0> <-R + StrokeWidth - Border, Height_Lower, 1>}
               cylinder {<-R + SW2, 0, 0> <-R + SW2, 0, 1>, SW2 - Border}
               intersection {
                  difference {
                     cylinder {<0, 0, 0> <0, 0, 1>, R - Border}
                     cylinder {<0, 0, -.1> <0, 0, 1.1>, R - StrokeWidth + Border}
                  } //difference
                  plane {y, 0}
               } //intersection
            } //union
            intersection {
               box {<-R - .1, -R - .1, -.2> <0, Height_Lower + .1, 1.2>}
               plane {y, -Border inverse rotate ClipAngle * z translate .1 * y}
            } //intersection
         } //difference
      } //object
      union {
         box {<R - StrokeWidth + Border, 0, 0> <R - Border, Height_Upper - R - Border, 1>}
         cylinder {<R - SW2, 0, 0> <R - SW2, 0, 1>, SW2 - Border}
         object {Hook}
      } //union
      translate <R, R, 0>
   } //object

   #declare CharacterWidth = R * 2;

#end //#macro MakeJ1

#macro MakeK1 (Border)

   #declare Character = object {
      #local A1 = 45;
      #local X1 = .57;
      #local A2 = 34;
      #local X2 = .63;
      #local Extension1 = object {
         intersection {
            box {<SW2, 0, 0> <.9, Height_Upper - Border, 1>}
            plane {x, Border inverse rotate -A1 * z translate <X1, Height_Upper, 0>}
            plane {x, StrokeWidth - Border rotate -A1 * z translate <X1, Height_Upper, 0>}
         } //intersection
      } //object
      #local Extension2 = object {
         intersection {
            box {<StrokeWidth, Border, 0> <.9, Height_Upper - Border, 1>}
            plane {x, SW2 inverse rotate -A1 * z translate <X1, Height_Upper, 0>}
            plane {x, Border inverse rotate A2 * z translate X2 * x}
            plane {x, StrokeWidth - Border rotate A2 * z translate X2 * x}
         } //intersection
      } //object
      union {
         box {<Border, Border, 0> <StrokeWidth - Border, Height_Upper - Border, 1>}
         object {Extension1}
         object {Extension2}
      } //union
   } //object

   #declare CharacterWidth = X2 + StrokeWidth / cos (radians (A2));

#end //#macro MakeK1

#macro MakeL1 (Border)

   #declare Character = object {
      #local Width = .64;
      difference {
         box {<Border, Border, 0> <Width - Border, Height_Upper - Border, 1>}
         box {<StrokeWidth - Border, StrokeWidth - Border, -.1> <Width + .1, Height_Upper + .1, 1.1>}
      } //difference
   } //object

   #declare CharacterWidth = Width;

#end //#macro MakeL1

#macro MakeM1 (Border)

   #declare Character = object {
      #local Angle = 72;
      #local W1 = SW2 / sin (radians (Angle));
      #local W2 = Height_Upper / sin (radians (Angle)) * sin (radians (90 - Angle));
      #local X1 = -W1 + W2;
      #local X2 = X1 + .07 + StrokeWidth;
      #local Cutout_Top = object {
         intersection {
            box {<-.5, 0, -.1> <.5, Height_Upper + .1, 1.1>}
            plane {y, SW2 - Border inverse rotate -Angle * z}
            plane {y, SW2 - Border inverse rotate Angle * z}
         } //intersection
      } //object
      #local Cutout_Bottom_Left = object {
         intersection {
            box {<-X2 + StrokeWidth - Border, -.1, -.1> <0, Height_Upper, 1.1>}
            plane {y, -SW2 + Border rotate -Angle * z}
         } //intersection
      } //object
      #local Cutout_Bottom_Right = object {
         intersection {
            box {<0, -.1, -.1> <X2 - StrokeWidth + Border, Height_Upper, 1.1>}
            plane {y, -SW2 + Border rotate Angle * z}
         } //intersection
      } //object
      difference {
         box {<-X2 + Border, Border, 0> <X2 - Border, Height_Upper - Border, 1>}
         object {Cutout_Top}
         object {Cutout_Bottom_Left}
         object {Cutout_Bottom_Right}
      } //difference
      translate X2 * x
   } //object

   #declare CharacterWidth = X2 * 2;

#end //#macro MakeM1

#macro MakeN1 (Border)

   #local Height = Height_Upper * .8;
   #local Width = Height_Upper;

   #declare Character = object { //"Z" rotated sideways
      MakeGenericZ (Border, Height, Width)
      Character
      rotate -90 * z
      translate Width * y
   } //object

   #declare CharacterWidth = Height;

#end //#macro MakeN1

#macro MakeO1 (Border)

   #declare Character = object {
      #local R = Height_Upper / 2;
      #local WidthFactor = .94;
      difference {
         cylinder {<0, 0, 0> <0, 0, 1>, 1 scale <R * WidthFactor - Border, R - Border, 1>}
         cylinder {<0, 0, -.1> <0, 0, 1.1>, 1 scale <R * WidthFactor - StrokeWidth + Border, R - StrokeWidth + Border, 1>}
      } //difference
      translate <R * WidthFactor, R, 0>
   } //object

   #declare CharacterWidth = R * WidthFactor * 2;

#end //#macro MakeO1

#macro MakeP1 (Border)

   #declare Character = object {
      #local Width = .38;
      #local BarHeight = Height_Upper * .46;
      union {
         difference {
            box {<Border, Border, 0> <Width, Height_Upper - Border, 1>}
            box {<StrokeWidth - Border, -.1, -.1> <Width + .1, BarHeight - SW2 + Border, 1.1>}
            box {<StrokeWidth - Border, Height_Upper - StrokeWidth + Border, -.1> <Width + .1, BarHeight + SW2 - Border, 1.1>}
         } //difference
         cylinder {<Width, BarHeight, 0> <Width, BarHeight, 1>, SW2 - Border}
         cylinder {<Width, Height_Upper - SW2, 0> <Width, Height_Upper - SW2, 1>, SW2 - Border}
         #local Y2 = (Height_Upper + (BarHeight - SW2)) / 2;
         #local R = Height_Upper - Y2;
         #local Bulge = object {
            intersection {
               difference {
                  cylinder {<Width, Y2, 0> <Width, Y2, 1>, R - Border}
                  cylinder {<Width, Y2, -.1> <Width, Y2, 1.1>, R - StrokeWidth + Border}
               } //difference
               plane {x, Width inverse}
            } //intersection
         } //object
         object {Bulge}
      } //union
   } //object

   #declare CharacterWidth = Width + R;

#end //#macro MakeP1

#macro MakeQ1 (Border)

   #declare Character = object {
      #local R = Height_Upper / 2;
      #local TailR = R;
      #local TailAngle = 42;
      #local Tail = object {
         union {
            intersection {
               difference {
                  cylinder {<-TailR + SW2, 0, 0> <-TailR + SW2, 0, 1>, TailR - Border}
                  cylinder {<-TailR + SW2, 0, -.1> <-TailR + SW2, 0, 1.1>, TailR - StrokeWidth + Border}
               } //difference
               plane {y, 0 inverse}
               plane {y, -Border rotate TailAngle * z translate (-TailR + SW2) * x}
            } //intersection
            intersection {
               difference {
                  cylinder {<TailR - SW2, 0, 0> <TailR - SW2, 0, 1>, TailR - Border}
                  cylinder {<TailR - SW2, 0, -.1> <TailR - SW2, 0, 1.1>, TailR - StrokeWidth + Border}
               } //difference
               plane {y, 0}
               plane {y, Border inverse rotate TailAngle * z translate (TailR - SW2) * x}
            } //intersection
            cylinder {<0, 0, 0> <0, 0, 1>, SW2 - Border}
         } //union
      } //object
      union {
         object {Tail rotate 40 * z translate <R * .45, R * -.62, 0>}
         #local WidthFactor = .94;
         difference {
            cylinder {<0, 0, 0> <0, 0, 1>, 1 scale <R * WidthFactor - Border, R - Border, 1>}
            cylinder {<0, 0, -.1> <0, 0, 1.1>, 1 scale <R * WidthFactor - StrokeWidth + Border, R - StrokeWidth + Border, 1>}
         } //difference
      } //union
      translate <R * WidthFactor, R, 0>
   } //object

   #declare CharacterWidth = R * WidthFactor + .4908851; //* * * WRONG, BUT NOT IMPORTANT * * *

#end //#macro MakeQ1

#macro MakeR1 (Border)

   #declare Character = object {
      #local Width = .42;
      #local BarHeight = Height_Upper * .46;
      #local LegX = .6;
      union {
         difference {
            box {<Border, Border, 0> <Width, Height_Upper - Border, 1>}
            box {<StrokeWidth - Border, -.1, -.1> <Width + .1, BarHeight - SW2 + Border, 1.1>}
            box {<StrokeWidth - Border, Height_Upper - StrokeWidth + Border, -.1> <Width + .1, BarHeight + SW2 - Border, 1.1>}
         } //difference
         cylinder {<Width, BarHeight, 0> <Width, BarHeight, 1>, SW2 - Border}
         cylinder {<Width, Height_Upper - SW2, 0> <Width, Height_Upper - SW2, 1>, SW2 - Border}
         #local Y2 = (Height_Upper + (BarHeight - SW2)) / 2;
         #local R = Height_Upper - Y2;
         #local Bulge = object {
            intersection {
               difference {
                  cylinder {<Width, Y2, 0> <Width, Y2, 1>, R - Border}
                  cylinder {<Width, Y2, -.1> <Width, Y2, 1.1>, R - StrokeWidth + Border}
               } //difference
               plane {x, Width inverse}
            } //intersection
         } //object
         #local Leg = object {
            intersection {
               box {<StrokeWidth, Border, 0> <StrokeWidth + .7, BarHeight, 1>}
               plane {x, Border inverse rotate 35 * z translate LegX * x}
               plane {x, StrokeWidth - Border rotate 35 * z translate LegX * x}
            } //intersection
         } //object
         object {Bulge}
         object {Leg}
      } //union
   } //object

   #declare CharacterWidth = LegX + StrokeWidth / cos (radians (35));

#end //#macro MakeR1

#macro MakeS1 (Border)

   #local Height = Height_Upper;

   MakeGenericS (Border, Height, true)

#end //#macro MakeS1

#macro MakeT1 (Border)

   #declare Character = object {
      #local Width = .78;
      difference {
         box {<Border, Border, 0> <Width - Border, Height_Upper - Border, 1>}
         box {<-.1, -.1, -.1> <Width / 2 - SW2 + Border, Height_Upper - StrokeWidth + Border, 1.1>}
         box {<Width / 2 + SW2 - Border, -.1, -.1> <Width + .1, Height_Upper - StrokeWidth + Border, 1.1>}
      } //difference
   } //object

   #declare CharacterWidth = Width;

#end //#macro MakeT1

#macro MakeU1 (Border)

   #declare Character = object {
      #local R = .4;
      union {
         box {<-R + Border, 0, 0> <-R + StrokeWidth - Border, Height_Upper - R - Border, 1>}
         box {<R - StrokeWidth + Border, 0, 0> <R - Border, Height_Upper - R - Border, 1>}
         cylinder {<-R + SW2, 0, 0> <-R + SW2, 0, 1>, SW2 - Border}
         cylinder {<R - SW2, 0, 0> <R - SW2, 0, 1>, SW2 - Border}
         intersection {
            difference {
               cylinder {<0, 0, 0> <0, 0, 1>, R - Border}
               cylinder {<0, 0, -.1> <0, 0, 1.1>, R - StrokeWidth + Border}
            } //difference
            plane {y, 0}
         } //intersection
      } //union
      translate <R, R, 0>
   } //object

   #declare CharacterWidth = R * 2;

#end //#macro MakeU1

#macro MakeV1 (Border)

   #local Height = Height_Upper;
   #local Angle = 70;

   MakeGenericV (Border, Height, Angle)

#end //#macro MakeV1

#macro MakeW1 (Border)

   #local Height = Height_Upper;
   #local Angle = 74;

   MakeGenericW (Border, Height, Angle)

#end //#macro MakeW1

#macro MakeX1 (Border)

   #local Height = Height_Upper;
   #local Angle = 54;

   MakeGenericX (Border, Height, Angle)

#end //#macro MakeX1

#macro MakeY1 (Border)

   #declare Character = object {
      #local Angle = 55;
      #local SplitHeight = Height_Upper * .43;
      #local X1 = (Height_Upper - SplitHeight) / tan (radians (Angle));
      #local W = SW2 + X1;
      #local Cutout_Left = object {
         intersection {
            box {<-W - .2, -.1, -.1> <-SW2 + Border, Height_Upper + .1, 1.1>}
            plane {y, Border rotate -Angle * z translate <-W, Height_Upper, 0>}
         } //intersection
      } //object
      #local Cutout_Right = object {
         intersection {
            box {<SW2 - Border, -.1, -.1> <W + .2, Height_Upper + .1, 1.1>}
            plane {y, Border rotate Angle * z translate <W, Height_Upper, 0>}
         } //intersection
      } //object
      #local Cutout_Center = object {
         intersection {
            box {<-W, SplitHeight, -.1> <W, Height_Upper + .1, 1.1>}
            plane {y, StrokeWidth - Border inverse rotate -Angle * z translate <-W, Height_Upper, 0>}
            plane {y, StrokeWidth - Border inverse rotate Angle * z translate <W, Height_Upper, 0>}
         } //intersection
      } //object
      difference {
         box {<-W - .1, Border, 0> <W + .1, Height_Upper - Border, 1>}
         object {Cutout_Left}
         object {Cutout_Right}
         object {Cutout_Center}
      } //difference
      translate W * x
   } //object

   #declare CharacterWidth = W * 2;

#end //#macro MakeY1

#macro MakeZ1 (Border)

   #local Height = Height_Upper;
   #local Width = Height_Upper * .75;

   MakeGenericZ (Border, Height, Width)

#end //#macro MakeZ1

#macro MakeA2 (Border)

   #declare Character = object {
      #local TailHeight = .18;
      #local R1 = .6;
      #local R2 = .25;
      #local R3 = .8;
      #local R4 = R2;
      #local R5 = .45;
      #local R6 = .23;
      #local R7 = 1;
      #local R8 = R7;
      #local A1 = 8;
      #local A2 = 0;
      #local A3 = 11;
      #local A4 = 1;
      #local X2 = (R2 - SW2) * cos (radians (90 - A1));
      #local Y2 = (R2 - SW2) * sin (radians (90 - A1));
      #local X2A = (R3 - SW2) * cos (radians (90 - A1));
      #local Y2A = (R3 - SW2) * sin (radians (90 - A1));
      #local X3A = (R3 - SW2) * cos (radians (90 + A1));
      #local Y3A = (R3 - SW2) * sin (radians (90 + A1));
      #local X3 = (R4 - SW2) * cos (radians (90 + A1));
      #local Y3 = (R4 - SW2) * sin (radians (90 + A1));
      #local X4 = (R4 - StrokeWidth) * cos (radians (180 - A2));
      #local Y4 = (R4 - StrokeWidth) * sin (radians (180 - A2));
      #local TopHeight = R3 + Y2 - Y2A;
      #local X1 = 0;
      #local Y1 = Height_Lower - TopHeight;
      #local X5 = 0;
      #local Y5 = -R5 + SW2;
      #local X5A = 0;
      #local Y5A = -R6 + SW2;
      #local X6 = (R6 - SW2) * cos (radians (90 + A3));
      #local Y6 = (R6 - SW2) * sin (radians (90 + A3));
      #local X6A = (R7 - SW2) * cos (radians (90 + A3));
      #local Y6A = (R7 - SW2) * sin (radians (90 + A3));
      #local X7 = (R7 - SW2) * cos (radians (90 + A4));
      #local Y7 = (R7 - SW2) * sin (radians (90 + A4));
      #local X7A = (R8 - SW2) * cos (radians (90 + A4 + 180));
      #local Y7A = (R8 - SW2) * sin (radians (90 + A4 + 180));
      #local TailWidth = R1 - StrokeWidth - sqrt (pow (R1 - StrokeWidth, 2) - pow (TailHeight, 2));
      #local BottomWidth = R5 + R6;
      #local Top = object {
         #local Right = object {
            intersection {
               difference {
                  cylinder {<0, 0, 0> <0, 0, 1>, R2 - Border}
                  cylinder {<0, 0, -.1> <0, 0, 1.1>, R2 - StrokeWidth + Border}
               } //difference
               plane {y, 0 inverse}
               plane {y, 0 rotate (90 - A1) * z}
            } //intersection
         } //object
         #local Center = object {
            union {
               intersection {
                  difference {
                     cylinder {<0, 0, 0> <0, 0, 1>, R3 - Border}
                     cylinder {<0, 0, -.1> <0, 0, 1.1>, R3 - StrokeWidth + Border}
                  } //difference
                  plane {y, 0 inverse rotate (90 - A1) * z}
                  plane {y, 0 inverse rotate (-90 + A1) * z}
               } //intersection
               cylinder {<X2A, Y2A, 0> <X2A, Y2A, 1>, SW2 - Border}
               cylinder {<X3A, Y3A, 0> <X3A, Y3A, 1>, SW2 - Border}
            } //union
            translate <X2 - X2A, Y2 - Y2A, 0>
            #local X3A = X3A + X2 - X2A;
            #local Y3A = Y3A + Y2 - Y2A;
         } //object
         #local Left = object {
            intersection {
               difference {
                  cylinder {<0, 0, 0> <0, 0, 1>, R4 - Border}
                  cylinder {<0, 0, -.1> <0, 0, 1.1>, R4 - StrokeWidth + Border}
               } //difference
               plane {y, 0 inverse rotate (90 + A1) * z}
               plane {y, Border inverse rotate -7 * z translate <X4, Y4, 0>}
            } //intersection
            translate <X3A - X3, Y3A - Y3, 0>
         } //object
         union {
            object {Right}
            object {Center}
            object {Left}
         } //union
         translate <-R2 + SW2, Y1, 0>
      } //object
      #local Tail = object {
         intersection {
            difference {
               cylinder {<0, 0, 0> <0, 0, 1>, R1 - Border}
               cylinder {<0, 0, -.1> <0, 0, 1.1>, R1 - StrokeWidth + Border}
            } //difference
            plane {y, 0}
            plane {y, -TailHeight + Border inverse}
            plane {x, 0}
         } //intersection
         translate <R1 - SW2, TailHeight, 0>
      } //object
      #local Side = object {
         union {
            box {<-SW2 + Border, TailHeight, 0> <SW2 - Border, Y1, 1>}
            cylinder {<X1, TailHeight, 0>, <X1, TailHeight, 1> SW2 - Border}
            cylinder {<X1, Y1, 0>, <X1, Y1, 1> SW2 - Border}
         } //union
      } //object
      #local Bottom = object {
         union {
            #local Segment0 = object {
               intersection {
                  difference {
                     cylinder {<0, 0, 0> <0, 0, 1>, R5 - Border}
                     cylinder {<0, 0, -.1> <0, 0, 1.1>, R5 - StrokeWidth + Border}
                  } //difference
                  plane {y, 0}
                  plane {x, 0 inverse}
               } //intersection
            } //object
            #local Segment1 = object {
               intersection {
                  difference {
                     cylinder {<0, 0, 0> <0, 0, 1>, R6 - Border}
                     cylinder {<0, 0, -.1> <0, 0, 1.1>, R6 - StrokeWidth + Border}
                  } //difference
                  plane {x, 0}
                  plane {x, 0 rotate A3 * z}
               } //intersection
               translate <X5 - X5A, Y5 - Y5A, 0>
               #local X6 = X6 + X5 - X5A;
               #local Y6 = Y6 + Y5 - Y5A;
            } //object
            #local Segment2 = object {
               intersection {
                  difference {
                     cylinder {<0, 0, 0> <0, 0, 1>, R7 - Border}
                     cylinder {<0, 0, -.1> <0, 0, 1.1>, R7 - StrokeWidth + Border}
                  } //difference
                  plane {x, 0 inverse rotate A3 * z}
                  plane {x, 0 rotate A4 * z}
               } //intersection
               translate <X6 - X6A, Y6 - Y6A, 0>
               #local X7 = X7 + X6 - X6A;
               #local Y7 = Y7 + Y6 - Y6A;
            } //object
            #local Segment3 = object {
               intersection {
                  difference {
                     cylinder {<0, 0, 0> <0, 0, 1>, R8 - Border}
                     cylinder {<0, 0, -.1> <0, 0, 1.1>, R8 - StrokeWidth + Border}
                  } //difference
                  plane {x, 0 inverse rotate A4 * z}
                  plane {y, 0}
               } //intersection
               translate <X7 - X7A, Y7 - Y7A, 0>
            } //object
            object {Segment0}
            object {Segment1}
            object {Segment2}
            object {Segment3}
            cylinder {<X5, Y5, 0> <X5, Y5, 1>, SW2 - Border}
            cylinder {<X6, Y6, 0> <X6, Y6, 1>, SW2 - Border}
            cylinder {<X7, Y7, 0> <X7, Y7, 1>, SW2 - Border}
         } //union
         translate <-R5 + SW2, R5, 0>
      } //object
      #local Bottom = object {
         intersection {
            object {Bottom}
            plane {x, 0}
         } //intersection
      } //object
      union {
         object {Side}
         object {Tail}
         object {Top}
         object {Bottom}
      } //union
      translate (BottomWidth - SW2) * x
   } //object

   #declare CharacterWidth = BottomWidth + TailWidth;

#end //#macro MakeA2

#macro MakeB2 (Border)

   #declare Character = object {
      #local R = Height_Lower / 2;
      union {
         box {<Border, Border, 0> <StrokeWidth - Border, Height_Upper - Border, 1> translate -R * x}
         difference {
            cylinder {<0, R, 0> <0, R, 1>, R - Border}
            cylinder {<0, R, -.1> <0, R, 1.1>, R - StrokeWidth + Border}
         } //difference
      } //union
      translate R * x
   } //object

   #declare CharacterWidth = R * 2;

#end //#macro MakeB2

#macro MakeC2 (Border)

   #declare Character = object {
      #local R = Height_Lower / 2;
      #local ClipAngle = 25;
      difference {
         cylinder {<0, R, 0> <0, R, 1>, R - Border}
         cylinder {<0, R, -.1> <0, R, 1.1>, R - StrokeWidth + Border}
         intersection {
            box {<0, 0, -.2> <R + .1, Height_Upper, 1.2>}
            plane {y, Border rotate ClipAngle * z translate R * y}
            plane {y, -Border inverse rotate -ClipAngle * z translate R * y}
         } //intersection
      } //difference
      translate R * x
   } //object

   #declare CharacterWidth = R + R * cos (radians (ClipAngle));

#end //#macro MakeC2

#macro MakeD2 (Border)

   #declare Character = object {
      #local R = Height_Lower / 2;
      union {
         box {<Border, Border, 0> <StrokeWidth - Border, Height_Upper - Border, 1> translate (R - StrokeWidth) * x}
         difference {
            cylinder {<0, R, 0> <0, R, 1>, R - Border}
            cylinder {<0, R, -.1> <0, R, 1.1>, R - StrokeWidth + Border}
         } //difference
      } //union
      translate R * x
   } //object

   #declare CharacterWidth = R * 2;

#end //#macro MakeD2

#macro MakeE2 (Border)

   #declare Character = object {
      #local R = Height_Lower / 2;
      #local Hook = object {
         #local R1 = R - Border;
         #local R2 = R - StrokeWidth + Border;
         #local X1 = sqrt (R1 * R1 - (SW2 - Border) * (SW2 - Border));
         #local X2 = sqrt (R2 * R2 - (SW2 - Border) * (SW2 - Border));
         #local Y1 = -SW2 + Border;
         #local Y2 = -SW2 + Border;
         #local A1 = degrees (asin ((SW2 - Border) / R1));
         #local A2 = degrees (asin ((SW2 - Border) / R2)) + 180;
         #local XC1 = -X1 + (SW2 - Border) * cos (radians (A1));
         #local YC1 = Y1 + (SW2 - Border) * sin (radians (A1));
         #local XC2 = -X2 + (SW2 - Border) * cos (radians (A2));
         #local YC2 = Y2 + (SW2 - Border) * sin (radians (A2));
         difference {
            union {
               intersection {
                  difference {
                     cylinder {<0, 0, 0> <0, 0, 1>, R - Border}
                     cylinder {<0, 0, -.1> <0, 0, 1.1>, R - StrokeWidth + Border}
                  } //difference
                  plane {y, -SW2 + Border}
               } //intersection
               cylinder {<XC1, YC1, 0> <XC1, YC1, 1>, SW2 - Border}
               cylinder {<XC2, YC2, 0> <XC2, YC2, 1>, SW2 - Border}
            } //union
            intersection {
               box {<0, -R, -.2> <R + .1, 0, 1.2>}
               plane {y, -Border inverse rotate -10 * z translate (-R * .3) * y}
            } //intersection
         }//difference
      } //object
      union {
         intersection {
            difference {
               cylinder {<0, 0, 0> <0, 0, 1>, R - Border}
               intersection {
                  cylinder {<0, 0, -.1> <0, 0, 1.1>, R - StrokeWidth + Border}
                  plane {y, SW2 - Border inverse}
               } //intersection
            } //difference
            plane {y, -SW2 + Border inverse}
         } //intersection
         object {Hook}
      } //union
      translate <R, R, 0>
   } //object

   #declare CharacterWidth = R * 2;

#end //#macro MakeE2

#macro MakeF2 (Border)

   #declare Character = object {
      #local BarWidth = StrokeWidth * 2.05;
      #local XOffset = BarWidth * .22;
      #local BarSW = StrokeWidth * .9;
      #local R = .22;
      #local HookExtension = .16;
      #local ClipAngle = 10;
      #local Hook = object {
         intersection {
            union {
               intersection {
                  difference {
                     cylinder {<0, 0, 0> <0, 0, 1>, R - Border}
                     cylinder {<0, 0, -.1> <0, 0, 1.1>, R - StrokeWidth + Border}
                  } //difference
                  plane {y, 0 inverse}
                  plane {x, 0}
               } //intersection
               cylinder {<0, R - SW2, 0> <0, R - SW2, 1>, SW2 - Border}
               box {<0, R - StrokeWidth + Border, 0> <HookExtension + .1, R - Border, 1>}
            } //union
            plane {x, -Border rotate -ClipAngle * z translate <HookExtension, R, 0>}
         } //intersection
         translate <R, Height_Upper - R, 0>
      } //object
      #local Stem = object {
         union {
            box {<Border, Border, 0> <StrokeWidth - Border, Height_Upper - R, 1>}
            cylinder {<SW2, Height_Upper - R, 0> <SW2, Height_Upper - R, 1>, SW2 - Border}
            object {Hook}
         } //union
         translate XOffset * x
      } //object
      union {
         object {Stem}
         box {<Border, Height_Lower - BarSW + Border, 0> <BarWidth - Border, Height_Lower - Border, 1>}
      } //union
   } //object

   #declare CharacterWidth = XOffset + R + HookExtension;

#end //#macro MakeF2

#macro MakeG2 (Border)

   #declare Character = object {
      #local R1 = Height_Lower / 2;
      #local R2 = R1 * .95;
      #local ClipAngle = 7;
      #local Hook = object {
         difference {
            intersection {
               difference {
                  cylinder {<0, 0, 0> <0, 0, 1>, R2 - Border}
                  cylinder {<0, 0, -.1> <0, 0, 1.1>, R2 - StrokeWidth + Border}
               } //difference
               plane {y, 0}
            } //intersection
            intersection {
               box {<-R2 - .1, -R2, -.2> <0, .1, 1.2>}
               plane {y, -Border inverse rotate -ClipAngle * z translate -.1 * y}
            } //intersection
         } //difference
      } //object
      union {
         box {<Border, 0, 0> <StrokeWidth - Border, Height_Lower - Border, 1> translate (R1 - StrokeWidth) * x}
         cylinder {<SW2, 0, 0> <SW2, 0, 1>, SW2 - Border translate (R1 - StrokeWidth) * x}
         difference {
            cylinder {<0, R1, 0> <0, R1, 1>, R1 - Border}
            cylinder {<0, R1, -.1> <0, R1, 1.1>, R1 - StrokeWidth + Border}
         } //difference
         object {Hook translate (R1 - R2) * x}
      } //union
      translate R1 * x
   } //object

   #declare CharacterWidth = R1 * 2;

#end //#macro MakeG2

#macro MakeH2 (Border)

   #declare Character = object {
      #local R = .32;
      #local Hook = object {
         union {
            box {<Border, Border, 0> <StrokeWidth - Border, Height_Lower - R, 1>}
            cylinder {<SW2, Height_Lower - R, 0> <SW2, Height_Lower - R, 1>, SW2 - Border}
            intersection {
               difference {
                  cylinder {<0, 0, 0> <0, 0, 1>, R - Border}
                  cylinder {<0, 0, -.1> <0, 0, 1.1>, R - StrokeWidth + Border}
               } //difference
               plane {y, 0 inverse}
               translate <-R + StrokeWidth, Height_Lower - R, 0>
            } //intersection
         } //union
      } //object
      union {
         box {<Border, Border, 0> <StrokeWidth - Border, Height_Upper - Border, 1>}
         object {Hook translate <R * 2 - StrokeWidth, 0, 0>}
      } //union
   } //object

   #declare CharacterWidth = R * 2;

#end //#macro MakeH2

#macro MakeI2 (Border)

   #declare Character = object {
      #local DotHeight = StrokeWidth * 1.08;
      union {
         box {<Border, Border, 0> <StrokeWidth - Border, Height_Lower - Border, 1>}
         box {<Border, Height_Upper - DotHeight + Border, 0> <StrokeWidth - Border, Height_Upper - Border, 1>}
      } //union
   } //object

   #declare CharacterWidth = StrokeWidth;

#end //#macro MakeI2

#macro MakeJ2 (Border)

   #declare Character = object {
      #local DotHeight = StrokeWidth * 1.08;
      #local R = .22;
      #local HookExtension_X = .11;
      #local HookExtension_Y = Height_Lower / 2 * .95 - R;
      #local ClipAngle = 10;
      #local Hook = object {
         intersection {
            union {
               intersection {
                  difference {
                     cylinder {<0, 0, 0> <0, 0, 1>, R - Border}
                     cylinder {<0, 0, -.1> <0, 0, 1.1>, R - StrokeWidth + Border}
                  } //difference
                  plane {y, 0}
                  plane {x, 0 inverse}
               } //intersection
               cylinder {<0, -R + SW2, 0> <0, -R + SW2, 1>, SW2 - Border}
               box {<-HookExtension_X - .1, -R + Border, 0> <0, -R + StrokeWidth - Border, 1>}
            } //union
            plane {x, Border inverse rotate -ClipAngle * z translate <-HookExtension_X, -R, 0>}
         } //intersection
         translate <-R + StrokeWidth, -HookExtension_Y, 0>
      } //object
      #local Stem = object {
         union {
            box {<Border, -HookExtension_Y, 0> <StrokeWidth - Border, Height_Lower - Border, 1>}
            cylinder {<SW2, -HookExtension_Y, 0> <SW2, -HookExtension_Y, 1>, SW2 - Border}
            object {Hook}
         } //union
      } //object
      union {
         object {Stem}
         box {<Border, Height_Upper - DotHeight + Border, 0> <StrokeWidth - Border, Height_Upper - Border, 1>}
      } //union
      translate (R - StrokeWidth + HookExtension_X) * x
   } //object

   #declare CharacterWidth = R + HookExtension_X;

#end //#macro MakeJ2

#macro MakeK2 (Border)

   #declare Character = object {
      #local A1 = 45;
      #local X1 = .4;
      #local A2 = 34;
      #local X2 = .46;
      #local Extension1 = object {
         intersection {
            box {<SW2, 0, 0> <.7, Height_Lower - Border, 1>}
            plane {x, Border inverse rotate -A1 * z translate <X1, Height_Lower, 0>}
            plane {x, StrokeWidth - Border rotate -A1 * z translate <X1, Height_Lower, 0>}
         } //intersection
      } //object
      #local Extension2 = object {
         intersection {
            box {<StrokeWidth, Border, 0> <.7, Height_Lower - Border, 1>}
            plane {x, SW2 inverse rotate -A1 * z translate <X1, Height_Lower, 0>}
            plane {x, Border inverse rotate A2 * z translate X2 * x}
            plane {x, StrokeWidth - Border rotate A2 * z translate X2 * x}
         } //intersection
      } //object
      union {
         box {<Border, Border, 0> <StrokeWidth - Border, Height_Upper - Border, 1>}
         object {Extension1}
         object {Extension2}
      } //union
   } //object

   #declare CharacterWidth = X2 + StrokeWidth / cos (radians (A2));

#end //#macro MakeK2

#macro MakeL2 (Border)

   #declare Character = object {
      box {<Border, Border, 0> <StrokeWidth - Border, Height_Upper - Border, 1>}
   } //object

   #declare CharacterWidth = StrokeWidth;

#end //#macro MakeL2

#macro MakeM2 (Border)

   #declare Character = object {
      #local R = .3;
      #local Hook = object {
         union {
            box {<Border, Border, 0> <StrokeWidth - Border, Height_Lower - R, 1>}
            cylinder {<SW2, Height_Lower - R, 0> <SW2, Height_Lower - R, 1>, SW2 - Border}
            intersection {
               difference {
                  cylinder {<0, 0, 0> <0, 0, 1>, R - Border}
                  cylinder {<0, 0, -.1> <0, 0, 1.1>, R - StrokeWidth + Border}
               } //difference
               plane {y, 0 inverse}
               translate <-R + StrokeWidth, Height_Lower - R, 0>
            } //intersection
         } //union
      } //object
      union {
         box {<Border, Border, 0> <StrokeWidth - Border, Height_Lower - Border, 1>}
         object {Hook translate <R * 2 - StrokeWidth, 0, 0>}
         object {Hook translate <R * 4 - StrokeWidth * 2, 0, 0>}
      } //union
   } //object

   #declare CharacterWidth = R * 4 - StrokeWidth;

#end //#macro MakeM2

#macro MakeN2 (Border)

   #declare Character = object {
      #local R = .32;
      #local Hook = object {
         union {
            box {<Border, Border, 0> <StrokeWidth - Border, Height_Lower - R, 1>}
            cylinder {<SW2, Height_Lower - R, 0> <SW2, Height_Lower - R, 1>, SW2 - Border}
            intersection {
               difference {
                  cylinder {<0, 0, 0> <0, 0, 1>, R - Border}
                  cylinder {<0, 0, -.1> <0, 0, 1.1>, R - StrokeWidth + Border}
               } //difference
               plane {y, 0 inverse}
               translate <-R + StrokeWidth, Height_Lower - R, 0>
            } //intersection
         } //union
      } //object
      union {
         box {<Border, Border, 0> <StrokeWidth - Border, Height_Lower - Border, 1>}
         object {Hook translate <R * 2 - StrokeWidth, 0, 0>}
      } //union
   } //object

   #declare CharacterWidth = R * 2;

#end //#macro MakeN2

#macro MakeO2 (Border)

   #declare Character = object {
      #local R = Height_Lower / 2;
      difference {
         cylinder {<0, R, 0> <0, R, 1>, R - Border}
         cylinder {<0, R, -.1> <0, R, 1.1>, R - StrokeWidth + Border}
      } //difference
      translate R * x
   } //object

   #declare CharacterWidth = R * 2;

#end //#macro MakeO2

#macro MakeP2 (Border)

   #declare Character = object {
      #local R = Height_Lower / 2;
      union {
         box {<Border, -R * .95 + Border, 0> <StrokeWidth - Border, Height_Lower - Border, 1> translate -R * x}
         difference {
            cylinder {<0, R, 0> <0, R, 1>, R - Border}
            cylinder {<0, R, -.1> <0, R, 1.1>, R - StrokeWidth + Border}
         } //difference
      } //union
      translate R * x
   } //object

   #declare CharacterWidth = R * 2;

#end //#macro MakeP2

#macro MakeQ2 (Border)

   #declare Character = object {
      #local R = Height_Lower / 2;
      union {
         box {<Border, -R * .95 + Border, 0> <StrokeWidth - Border, Height_Lower - Border, 1> translate (R - StrokeWidth) * x}
         difference {
            cylinder {<0, R, 0> <0, R, 1>, R - Border}
            cylinder {<0, R, -.1> <0, R, 1.1>, R - StrokeWidth + Border}
         } //difference
      } //union
      translate R * x
   } //object

   #declare CharacterWidth = R * 2;

#end //#macro MakeQ2

#macro MakeR2 (Border)

   #declare Character = object {
      #local R = .3;
      #local ClipAngle = 70;
      #local XOffset = -.04;
      #local YOffset = .006;
      #local Hook = object {
         intersection {
            difference {
               cylinder {<0, 0, 0> <0, 0, 1>, R - Border}
               cylinder {<XOffset, YOffset, -.1> <XOffset, YOffset, 1.1>, R - StrokeWidth + Border}
            } //difference
            plane {y, Border inverse rotate ClipAngle * z}
            plane {y, 0 inverse}
         } //intersection
      } //object
      union {
         box {<Border, Border, 0> <StrokeWidth - Border, Height_Lower - Border, 1>}
         object {Hook translate <R - XOffset, Height_Lower - .3, 0>}
      } //union
   } //object

   #declare CharacterWidth = R * cos (radians (ClipAngle)) + R - XOffset;

#end //#macro MakeR2

#macro MakeS2 (Border)

   #local Height = Height_Lower;

   MakeGenericS (Border, Height, false)

#end //#macro MakeS2

#macro MakeT2 (Border)

   #declare Character = object {
      #local BarWidth = StrokeWidth * 2;
      #local XOffset = BarWidth * .22;
      #local BarSW = StrokeWidth * .85;
      #local R = .22;
      #local HookExtension = .11;
      #local ClipAngle = 10;
      #local Hook = object {
         intersection {
            union {
               intersection {
                  difference {
                     cylinder {<0, 0, 0> <0, 0, 1>, R - Border}
                     cylinder {<0, 0, -.1> <0, 0, 1.1>, R - StrokeWidth + Border}
                  } //difference
                  plane {y, 0}
                  plane {x, 0}
               } //intersection
               cylinder {<0, -R + SW2, 0> <0, -R + SW2, 1>, SW2 - Border}
               box {<0, -R + Border, 0> <HookExtension + .1, -R + StrokeWidth - Border, 1>}
            } //union
            plane {x, -Border rotate ClipAngle * z translate <HookExtension, -R, 0>}
         } //intersection
         translate <R, R, 0>
      } //object
      #local Stem = object {
         union {
            intersection {
               box {<Border, R, 0> <StrokeWidth - Border, Height_Upper - Border, 1>}
               plane {x, Border inverse rotate -60 * z translate <StrokeWidth, Height_Upper, 0>}
            } //intersection
            cylinder {<SW2, R, 0> <SW2, R, 1>, SW2 - Border}
            object {Hook}
         } //union
         translate XOffset * x
      } //object
      union {
         object {Stem}
         box {<Border, Height_Lower - BarSW + Border, 0> <BarWidth - Border, Height_Lower - Border, 1>}
      } //union
   } //object

   #declare CharacterWidth = XOffset + R + HookExtension;

#end //#macro MakeT2

#macro MakeU2 (Border)

   #declare Character = object {
      #local R = .32;
      #local Hook = object {
         union {
            box {<-R + Border, 0, 0> <-R + StrokeWidth - Border, Height_Lower - R - Border, 1>}
            cylinder {<-R + SW2, 0, 0> <-R + SW2, 0, 1>, SW2 - Border}
            intersection {
               difference {
                  cylinder {<0, 0, 0> <0, 0, 1>, R - Border}
                  cylinder {<0, 0, -.1> <0, 0, 1.1>, R - StrokeWidth + Border}
               } //difference
               plane {y, 0}
            } //intersection
         } //union
      } //object
      union {
         box {<R - StrokeWidth + Border, -R + Border, 0> <R - Border, Height_Lower - R - Border, 1>}
         object {Hook}
      } //union
      translate <R, R, 0>
   } //object

   #declare CharacterWidth = R * 2;

#end //#macro MakeU2

#macro MakeV2 (Border)

   #local Height = Height_Lower;
   #local Angle = 70;

   MakeGenericV (Border, Height, Angle)

#end //#macro MakeV2

#macro MakeW2 (Border)

   #local Height = Height_Lower;
   #local Angle = 74;

   MakeGenericW (Border, Height, Angle)

#end //#macro MakeW2

#macro MakeX2 (Border)

   #local Height = Height_Lower;
   #local Angle = 54;

   MakeGenericX (Border, Height, Angle)

#end //#macro MakeX2

#macro MakeY2 (Border)

   #declare Character = object {
      #local R = .24;
      #local Angle = 70;
      #local HookExtension_X = .1;
      #local HookExtension_Y = Height_Lower / 2 * .95;
      #local HookExtension_Y = HookExtension_Y / sin (radians (Angle)) - R;
      #local ClipAngle = 10;
      #local X1 = -HookExtension_Y * sin (radians (90 - Angle));;
      #local Y1 = -HookExtension_Y * sin (radians (Angle));
      #local X2 = SW2 * sin (radians (Angle));
      #local Y2 = SW2 * sin (radians (90 - Angle));
      #local X2 = X1 + X2;
      #local Y2 = Y1 - Y2;
      #local X3 = (R - SW2) * sin (radians (Angle));
      #local Y3 = -(R - SW2) * sin (radians (90 - Angle));
      #local W1 = StrokeWidth / sin (radians (Angle));
      #local W2 = Height_Lower / sin (radians (Angle)) * sin (radians (90 - Angle));
      #local Hook = object {
         intersection {
            union {
               intersection {
                  difference {
                     cylinder {<0, 0, 0> <0, 0, 1>, R - Border}
                     cylinder {<0, 0, -.1> <0, 0, 1.1>, R - StrokeWidth + Border}
                  } //difference
                  plane {y, 0 inverse rotate (90 + Angle) * z}
                  plane {x, 0 inverse}
               } //intersection
               box {<-HookExtension_X, -R + Border, 0> <0, -R + StrokeWidth - Border, 1>}
               cylinder {<0, -R + SW2, 0> <0, -R + SW2, 1>, SW2 - Border}
               cylinder {<X3, Y3, 0> <X3, Y3, 1>, SW2 - Border}
            } //union
            plane {x, Border inverse rotate ClipAngle * z translate -HookExtension_X * x}
         } //intersection
      } //object
      #local Stem = object {
         intersection {
            box {<-.2, -.3, 0> <.6, Height_Lower - Border, 1>}
            plane {y, -Border rotate Angle * z}
            plane {y, -StrokeWidth + Border inverse rotate Angle * z}
            plane {y, HookExtension_Y rotate (90 + Angle) * z}
         } //intersection
      } //object
      #local LeftSide = object {
         intersection {
            box {<.15, 0, 0> <-.6, Height_Lower - Border, 1>}
            plane {y, Border inverse rotate -Angle * z}
            plane {y, StrokeWidth - Border rotate -Angle * z}
         } //intersection
      } //object
      union {
         object {Stem}
         object {Hook translate <X2 - X3, Y2 - Y3, 0>}
         object {LeftSide}
      } //union
      translate W2 * x
   } //object

   #declare CharacterWidth = W1 + W2 * 2;

#end //#macro MakeY2

#macro MakeZ2 (Border)

   #local Height = Height_Lower;
   #local Width = Height_Lower * .85;

   MakeGenericZ (Border, Height, Width)

#end //#macro MakeZ2
