#version 3.7;

#local UseRadiosity = yes;

#local StartStyle = 0; //0, 14, 28, 42, etc. - Set this variable to render different sample styles.

global_settings {
   assumed_gamma 2.2
   charset utf8
   max_trace_level 20
   #if (UseRadiosity)
      radiosity {
         pretrace_start .08
         pretrace_end .004
         count 600
         error_bound .002
         recursion_limit 2
         normal on
      } //radiosity
   #end //#if
} //global_settings

#include "colors.inc"
#include "BorderChars_Definitions.inc"
#include "BorderChars_Macros.inc"
#include "BorderChars_Styles.inc"

#local CameraX = 0;
#local CameraY = 0;
#local CameraZ = 5.5;

camera {
   location <CameraX, CameraY, -CameraZ>
   direction <0, 0, 1>
   rotate -60 * x
   look_at <CameraX, CameraY - 1.5, 0>
} //camera

#if (UseRadiosity)
   #local Dome = object {
      difference {
         sphere {0, 20001}
         sphere {0, 20000}
      } //difference
      texture {
         pigment {
            gradient z
            color_map {
               [0, 1 color White * 2.21 color White * .6]
            } //color_map
         } //pigment
         finish {emission 1 diffuse 0}
         scale <1, 1, 20000>
      } //texture
      no_reflection
   } //object
   object {Dome}
#else
   light_source {<60, 80, -200> color White * 1.65 shadowless}
#end //#if

#declare TextColor_Outer = texture {pigment {color White}}

#declare TextColor_Inner = texture {
   #declare Color0 = color <0, 216, 183> / 255 * 1.05; //Bottom/Outside
   #declare Color1 = color <154, 3, 200> / 255 * 1.05; //Top/Inside
   pigment {
      gradient y
      color_map {
         [0 color Color0]
         [.4 color (Color0 * 75 + Color1 * 25) / 100]
         [.6 (Color0 + Color1) / 2]
         [1 color Color1]
      } //color_map
   } //pigment
   finish {emission .1}
   #local YScaleAdd_Bottom = .75 / 2 * .95; //Height of the bottom of the "g"
   #local YScaleAdd_Top = .075; //Height of the top of the "*"
   scale <1, 1 + YScaleAdd_Bottom + YScaleAdd_Top, 1>
   translate -YScaleAdd_Bottom * y
} //texture

#declare TextColor_Back = texture {pigment {color Black}}

#local BackgroundColor = texture {
   pigment {checker color (<96, 56, 13> / 255 * 1.5 + White * 4) / 5 color (<.8193, .7094, .5103> + White * 4) / 5}
   #local S = 1.5;
   scale <S, S, 1>
} //texture

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* *                                                                                                                 * */
/* * THE SCENE                                                                                                       * */
/* *                                                                                                                 * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#local LeftMargin = -2.25;
#local TopMargin = 1;
#local ZOffset = -.1;

#declare TextScale = 1;

#declare GAP_Width = .1;

#local DX = 1.5;
#local DY = DX;

#local Grid = object {
   union {
      #local Style = StartStyle;
      #for (I, 0, 3)
         #for (J, 0, 3)
            #if (I < 3 | J = 1 | J = 2)
               #local GridX = J * DX;
               #local GridY = -I * DY;
               #switch (Style)
                  #case (0) //Plain
                     #local TextDepth = .08;
                     #local InvisibleBorderWidth = 0;
                     Stylize (Style, TextDepth, InvisibleBorderWidth, -999, -999, -999, -999, -999)
                  #break
                  #case (1) //Raised center
                     #local TextDepth = .08;
                     #local InvisibleBorderWidth = 0;
                     #local BorderWidth = .03;
                     #local BorderHeight = .025;
                     Stylize (Style, TextDepth, InvisibleBorderWidth, BorderWidth, BorderHeight, -999, -999, -999)
                  #break
                  #case (2) //Lowered center
                     #local TextDepth = .08;
                     #local InvisibleBorderWidth = 0;
                     #local BorderWidth = .03;
                     #local BorderDepth = .025;
                     Stylize (Style, TextDepth, InvisibleBorderWidth, BorderWidth, BorderDepth, -999, -999, -999)
                  #break
                  #case (3) //Striped
                     #local TextDepth = .08;
                     #local InvisibleBorderWidth = 0;
                     #local BorderWidth = .03;
                     #local StripeWidth = .02;
                     #local StripeHeight = 0;
                     Stylize (Style, TextDepth, InvisibleBorderWidth, BorderWidth, StripeWidth, StripeHeight, -999, -999)
                  #break
                  #case (4) //Color gradient
                     #local TextDepth = .08;
                     #local InvisibleBorderWidth = 0;
                     #local BorderWidth = .03;
                     #local StripeWidth = .04;
                     #local NSteps = 3;
                     Stylize (Style, TextDepth, InvisibleBorderWidth, BorderWidth, StripeWidth, NSteps, -999, -999)
                  #break
                  #case (5) //Hollow stripe
                     #local TextDepth = .08;
                     #local InvisibleBorderWidth = 0;
                     #local BorderWidth = .03;
                     #local StripeWidth = .02;
                     #local StripeDepth = .015;
                     Stylize (Style, TextDepth, InvisibleBorderWidth, BorderWidth, StripeWidth, StripeDepth, -999, -999)
                  #break
                  #case (6) //Hollow inside
                     #local TextDepth = .08;
                     #local InvisibleBorderWidth = 0;
                     #local BorderWidth = .03;
                     Stylize (Style, TextDepth, InvisibleBorderWidth, BorderWidth, -999, -999, -999, -999)
                  #break
                  #case (7) //Angled bevel
                     #local TextDepth = .08;
                     #local BorderHeight = .05;
                     #local NSteps = 5;
                     Stylize (Style, TextDepth, BorderHeight, NSteps, -999, -999, -999, -999)
                  #break
                  #case (8) //Rounded bevel
                     #local TextDepth = .08;
                     #local BorderHeight = .05;
                     #local NSteps = 7;
                     Stylize (Style, TextDepth, BorderHeight, NSteps, -999, -999, -999, -999)
                  #break
                  #case (9) //Solid hourglass (convex)
                     #local TextDepth = .2;
                     #local EffectWidth = .04;
                     #local NSteps = 17;
                     Stylize (Style, TextDepth, EffectWidth, NSteps, -999, -999, -999, -999)
                  #break
                  #case (10) //Hollow hourglass (convex)
                     #local TextDepth = .2;
                     #local EffectWidth = .04;
                     #local WallThickness = .02;
                     #local NSteps = 17;
                     Stylize (Style, TextDepth, EffectWidth, WallThickness, NSteps, -999, -999, -999)
                  #break
                  #case (11) //Solid hourglass (concave)
                     #local TextDepth = .2;
                     #local EffectWidth = .04;
                     #local NSteps = 17;
                     Stylize (Style, TextDepth, EffectWidth, NSteps, -999, -999, -999, -999)
                  #break
                  #case (12) //Hollow hourglass (concave)
                     #local TextDepth = .2;
                     #local EffectWidth = .04;
                     #local WallThickness = .02;
                     #local NSteps = 17;
                     Stylize (Style, TextDepth, EffectWidth, WallThickness, NSteps, -999, -999, -999)
                  #break
                  #case (13) //Solid half-hourglass (concave)
                     #local TextDepth = .08;
                     #local EffectWidth = .04;
                     #local NSteps = 9;
                     Stylize (Style, TextDepth, EffectWidth, NSteps, -999, -999, -999, -999)
                  #break
                  #case (14) //Hollow inside, bordered
                     #local TextDepth = .08;
                     #local InvisibleBorderWidth = 0;
                     #local BorderWidth = .02;
                     #local SolidWidth = .02;
                     #local BorderDepth = -.02;
                     Stylize (Style, TextDepth, InvisibleBorderWidth, BorderWidth, SolidWidth, BorderDepth, -999, -999)
                  #break
                  #case (15) //Hollow stripe with raised center
                     #local TextDepth = .08;
                     #local InvisibleBorderWidth = 0;
                     #local BorderWidth = .03;
                     #local StripeWidth = .02;
                     #local StripeDepth = .02;
                     #local InnerHeight = .03;
                     Stylize (Style, TextDepth, InvisibleBorderWidth, BorderWidth, StripeWidth, StripeDepth, InnerHeight, -999)
                  #break
                  #case (16) //Angled reverse bevel
                     #local TextDepth = .2;
                     #local BorderDepth = .05;
                     #local NSteps = 5;
                     Stylize (Style, TextDepth, BorderDepth, NSteps, -999, -999, -999, -999)
                  #break
                  #case (17) //Rounded reverse bevel/concave
                     #local TextDepth = .2;
                     #local BorderDepth = .05;
                     #local NSteps = 7;
                     Stylize (Style, TextDepth, BorderDepth, NSteps, -999, -999, -999, -999)
                  #break
                  #case (18) //Rounded reverse bevel/convex
                     #local TextDepth = .2;
                     #local BorderDepth = .05;
                     #local NSteps = 7;
                     Stylize (Style, TextDepth, BorderDepth, NSteps, -999, -999, -999, -999)
                  #break
                  #case (19) //Stack
                     #local TextDepth = .04;
                     #local InvisibleBorderWidth = 0;
                     #local BorderWidth = .03;
                     #local SpacerDepth = .015;
                     #local NSteps = 3;
                     Stylize (Style, TextDepth, InvisibleBorderWidth, BorderWidth, SpacerDepth, NSteps, -999, -999)
                  #break
                  #case (20) //Raised inner border
                     #local TextDepth = .04;
                     #local InvisibleBorderWidth = 0;
                     #local BorderWidth = .03;
                     #local RaisedBorderWidth = .03;
                     #local RaisedBorderHeight = .04;
                     Stylize (Style, TextDepth, InvisibleBorderWidth, BorderWidth, RaisedBorderWidth, RaisedBorderHeight, -999, -999)
                  #break
                  #case (21) //Specular highlights
                     #local TextDepth = .08;
                     #local InvisibleBorderWidth = 0;
                     #local BorderWidth = .03;
                     #local BorderDepth = .025;
                     #local Angle = 160;
                     Stylize (Style, TextDepth, InvisibleBorderWidth, BorderWidth, BorderDepth, Angle, -999, -999)
                  #break
                  #range (22, 999)
                     #local TextDepth = .08;
                     #local InvisibleBorderWidth = 0;
                     Stylize (0, TextDepth, InvisibleBorderWidth, -999, -999, -999, -999, -999)
                  #break
               #end //#switch
               #declare NLines = 1;
               InitializeVariables (NLines)
               #declare LineText [0] = "P";
               CreateParagraphTextObject (NLines, LEFT, no)
               object {Paragraph translate <GridX - BorderCharacterWidth [15] / 2, GridY, 0>}
               #local Style = Style + 1;
            #end //#if
         #end //#for
      #end //#for
      #local TextDepth = .04;
      #local InvisibleBorderWidth = .025;
      Stylize (0, TextDepth, InvisibleBorderWidth, -999, -999, -999, -999, -999)
      #local Style = StartStyle;
      #for (I, 0, 3)
         #for (J, 0, 3)
            #if (I < 3 | J = 1 | J = 2)
               #local GridX = J * DX;
               #local GridY = -I * DY;
               #declare NLines = 1;
               InitializeVariables (NLines)
               #declare LineText [0] = str (Style, 0, 0);
               CreateParagraphTextObject (NLines, LEFT, no)
               object {Paragraph scale <.3, .3, 1> translate <GridX + .05, GridY, 0>}
               #local Style = Style + 1;
            #end //#if
         #end //#for
      #end //#for
   } //union
} //object

#local Background = object {
   plane {
      z, 0 inverse
      texture {BackgroundColor translate <LeftMargin - S / 2, DY / 2 + .2, 0>}
   } //plane
} //object

object {Grid translate <LeftMargin, TopMargin, ZOffset>}

object {Background}
